;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; RUN: wasm-opt %s -all --optimize-instructions --preserve-type-order -S -o - | filecheck %s

(module
  ;; CHECK:      (type $i32 (shared (struct (field (mut i32)))))
  (type $i32 (shared (struct (field (mut i32)))))
  ;; CHECK:      (type $i64 (shared (struct (field (mut i64)))))
  (type $i64 (shared (struct (field (mut i64)))))
  ;; CHECK:      (type $struct (shared (struct (field (mut (ref null $struct))))))
  (type $struct (shared (struct (field (mut (ref null $struct))))))
  ;; CHECK:      (type $unshared-i32 (struct (field (mut i32))))
  (type $unshared-i32 (struct (field (mut i32))))
  ;; CHECK:      (type $unshared-i64 (struct (field (mut i64))))
  (type $unshared-i64 (struct (field (mut i64))))
  ;; CHECK:      (type $unshared-struct (struct (field (mut (ref null $unshared-struct)))))
  (type $unshared-struct (struct (field (mut (ref null $unshared-struct)))))

  ;; CHECK:      (func $rmw-skip-non-null-cast (type $6) (param $0 (ref null $i32)) (param $1 i32) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.add $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-skip-non-null-cast (param (ref null $i32) i32) (result i32)
    (struct.atomic.rmw.add $i32 0
      (ref.as_non_null
        (local.get 0)
      )
      (local.get 1)
    )
  )

  ;; CHECK:      (func $cmpxchg-skip-non-null-cast (type $7) (param $0 (ref null $i32)) (param $1 i32) (param $2 i32) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.cmpxchg $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-skip-non-null-cast (param (ref null $i32) i32 i32) (result i32)
    (struct.atomic.rmw.cmpxchg $i32 0
      (ref.as_non_null
        (local.get 0)
      )
      (local.get 1)
      (local.get 2)
    )
  )

  ;; CHECK:      (func $rmw-trap-on-null (type $8) (result i32)
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $rmw-trap-on-null (result i32)
    (struct.atomic.rmw.add $i32 0
      (ref.null (shared none))
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $cmpxchg-trap-on-null (type $8) (result i32)
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $cmpxchg-trap-on-null (result i32)
    (struct.atomic.rmw.cmpxchg $i32 0
      (ref.null (shared none))
      (i32.const 1)
      (i32.const 2)
    )
  )

  ;; CHECK:      (func $rmw-add-i32-ident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i32 0
  ;; CHECK-NEXT:   (block (result (ref null $i32))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-add-i32-ident (param (ref null $i32)) (result i32)
    ;; This can be optimized to just an atomic load.
    (struct.atomic.rmw.add acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $rmw-add-i32-noident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.add acqrel acqrel $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-add-i32-noident (param (ref null $i32)) (result i32)
    ;; But this cannot be optimized at all.
    (struct.atomic.rmw.add acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $rmw-sub-i32-ident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i32 0
  ;; CHECK-NEXT:   (block (result (ref null $i32))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-sub-i32-ident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.sub acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $rmw-sub-i32-noident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.sub acqrel acqrel $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-sub-i32-noident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.sub acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $rmw-and-i32-ident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i32 0
  ;; CHECK-NEXT:   (block (result (ref null $i32))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const -1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-and-i32-ident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.and acqrel acqrel $i32 0
      (local.get 0)
      (i32.const -1)
    )
  )

  ;; CHECK:      (func $rmw-and-i32-noident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.and acqrel acqrel $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-and-i32-noident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.and acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $rmw-or-i32-ident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i32 0
  ;; CHECK-NEXT:   (block (result (ref null $i32))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-or-i32-ident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.or acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $rmw-or-i32-noident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.or acqrel acqrel $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const -1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-or-i32-noident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.or acqrel acqrel $i32 0
      (local.get 0)
      (i32.const -1)
    )
  )

  ;; CHECK:      (func $rmw-xor-i32-ident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i32 0
  ;; CHECK-NEXT:   (block (result (ref null $i32))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xor-i32-ident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.xor acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $rmw-xor-i32-noident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.xor acqrel acqrel $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const -1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xor-i32-noident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.xor acqrel acqrel $i32 0
      (local.get 0)
      (i32.const -1)
    )
  )

  ;; CHECK:      (func $rmw-xchg-i32-ident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg acqrel acqrel $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (struct.get $i32 0
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xchg-i32-ident (param (ref null $i32)) (result i32)
    ;; TODO: Optimize this case.
    (struct.atomic.rmw.xchg acqrel acqrel $i32 0
      (local.get 0)
      (struct.get $i32 0
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $rmw-xchg-i32-noident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg acqrel acqrel $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xchg-i32-noident (param (ref null $i32)) (result i32)
    (struct.atomic.rmw.xchg acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $cmpxchg-i32-ident (type $6) (param $0 (ref null $i32)) (param $1 i32) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i32 0
  ;; CHECK-NEXT:   (block (result (ref null $i32))
  ;; CHECK-NEXT:    (block
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-i32-ident (param (ref null $i32) i32) (result i32)
    (struct.atomic.rmw.cmpxchg acqrel acqrel $i32 0
      (local.get 0)
      (local.get 1)
      (local.get 1)
    )
  )

  ;; CHECK:      (func $cmpxchg-i32-noident (type $6) (param $0 (ref null $i32)) (param $1 i32) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.cmpxchg acqrel acqrel $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-i32-noident (param (ref null $i32) i32) (result i32)
    (struct.atomic.rmw.cmpxchg acqrel acqrel $i32 0
      (local.get 0)
      (i32.const 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $rmw-add-i64-ident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i64 0
  ;; CHECK-NEXT:   (block (result (ref null $i64))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i64.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-add-i64-ident (param (ref null $i64)) (result i64)
    ;; This can be optimized to just an atomic load.
    (struct.atomic.rmw.add acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 0)
    )
  )

  ;; CHECK:      (func $rmw-add-i64-noident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.rmw.add acqrel acqrel $i64 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-add-i64-noident (param (ref null $i64)) (result i64)
    ;; But this cannot be optimized at all.
    (struct.atomic.rmw.add acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $rmw-sub-i64-ident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i64 0
  ;; CHECK-NEXT:   (block (result (ref null $i64))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i64.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-sub-i64-ident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.sub acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 0)
    )
  )

  ;; CHECK:      (func $rmw-sub-i64-noident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.rmw.sub acqrel acqrel $i64 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-sub-i64-noident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.sub acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $rmw-and-i64-ident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i64 0
  ;; CHECK-NEXT:   (block (result (ref null $i64))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i64.const -1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-and-i64-ident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.and acqrel acqrel $i64 0
      (local.get 0)
      (i64.const -1)
    )
  )

  ;; CHECK:      (func $rmw-and-i64-noident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.rmw.and acqrel acqrel $i64 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i64.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-and-i64-noident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.and acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 0)
    )
  )

  ;; CHECK:      (func $rmw-or-i64-ident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i64 0
  ;; CHECK-NEXT:   (block (result (ref null $i64))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i64.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-or-i64-ident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.or acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 0)
    )
  )

  ;; CHECK:      (func $rmw-or-i64-noident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.rmw.or acqrel acqrel $i64 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i64.const -1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-or-i64-noident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.or acqrel acqrel $i64 0
      (local.get 0)
      (i64.const -1)
    )
  )

  ;; CHECK:      (func $rmw-xor-i64-ident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i64 0
  ;; CHECK-NEXT:   (block (result (ref null $i64))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i64.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xor-i64-ident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.xor acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 0)
    )
  )

  ;; CHECK:      (func $rmw-xor-i64-noident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.rmw.xor acqrel acqrel $i64 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i64.const -1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xor-i64-noident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.xor acqrel acqrel $i64 0
      (local.get 0)
      (i64.const -1)
    )
  )

  ;; CHECK:      (func $rmw-xchg-i64-ident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg acqrel acqrel $i64 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (struct.get $i64 0
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xchg-i64-ident (param (ref null $i64)) (result i64)
    ;; TODO: Optimize this case.
    (struct.atomic.rmw.xchg acqrel acqrel $i64 0
      (local.get 0)
      (struct.get $i64 0
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $rmw-xchg-i64-noident (type $10) (param $0 (ref null $i64)) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg acqrel acqrel $i64 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i64.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xchg-i64-noident (param (ref null $i64)) (result i64)
    (struct.atomic.rmw.xchg acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 0)
    )
  )

  ;; CHECK:      (func $cmpxchg-i64-ident (type $11) (param $0 (ref null $i64)) (param $1 i64) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $i64 0
  ;; CHECK-NEXT:   (block (result (ref null $i64))
  ;; CHECK-NEXT:    (block
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-i64-ident (param (ref null $i64) i64) (result i64)
    (struct.atomic.rmw.cmpxchg acqrel acqrel $i64 0
      (local.get 0)
      (local.get 1)
      (local.get 1)
    )
  )

  ;; CHECK:      (func $cmpxchg-i64-noident (type $11) (param $0 (ref null $i64)) (param $1 i64) (result i64)
  ;; CHECK-NEXT:  (struct.atomic.rmw.cmpxchg acqrel acqrel $i64 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i64.const 0)
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-i64-noident (param (ref null $i64) i64) (result i64)
    (struct.atomic.rmw.cmpxchg acqrel acqrel $i64 0
      (local.get 0)
      (i64.const 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $rmw-xchg-ref-ident (type $12) (param $0 (ref null $struct)) (result (ref null $struct))
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg acqrel acqrel $struct 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (struct.get $struct 0
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xchg-ref-ident (param (ref null $struct)) (result (ref null $struct))
    ;; TODO: Optimize this case.
    (struct.atomic.rmw.xchg acqrel acqrel $struct 0
      (local.get 0)
      (struct.get $struct 0
        (local.get 0)
      )
    )
  )

  ;; CHECK:      (func $rmw-xchg-ref-noident (type $12) (param $0 (ref null $struct)) (result (ref null $struct))
  ;; CHECK-NEXT:  (struct.atomic.rmw.xchg acqrel acqrel $struct 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-xchg-ref-noident (param (ref null $struct)) (result (ref null $struct))
    (struct.atomic.rmw.xchg acqrel acqrel $struct 0
      (local.get 0)
      (local.get 0)
    )
  )

  ;; CHECK:      (func $cmpxchg-ref-ident (type $12) (param $0 (ref null $struct)) (result (ref null $struct))
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $struct 0
  ;; CHECK-NEXT:   (block (result (ref null $struct))
  ;; CHECK-NEXT:    (block
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (local.get $0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-ref-ident (param (ref null $struct)) (result (ref null $struct))
    (struct.atomic.rmw.cmpxchg acqrel acqrel $struct 0
      (local.get 0)
      (local.get 0)
      (local.get 0)
    )
  )

  ;; CHECK:      (func $cmpxchg-ref-ident-null (type $12) (param $0 (ref null $struct)) (result (ref null $struct))
  ;; CHECK-NEXT:  (struct.atomic.get acqrel $struct 0
  ;; CHECK-NEXT:   (block (result (ref null $struct))
  ;; CHECK-NEXT:    (block
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (ref.null (shared none))
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (ref.null (shared none))
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-ref-ident-null (param (ref null $struct)) (result (ref null $struct))
    (struct.atomic.rmw.cmpxchg acqrel acqrel $struct 0
      (local.get 0)
      (ref.null (shared none))
      (ref.null (shared none))
    )
  )

  ;; CHECK:      (func $cmpxchg-ref-noident (type $12) (param $0 (ref null $struct)) (result (ref null $struct))
  ;; CHECK-NEXT:  (struct.atomic.rmw.cmpxchg acqrel acqrel $struct 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (ref.null (shared none))
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-ref-noident (param (ref null $struct)) (result (ref null $struct))
    (struct.atomic.rmw.cmpxchg acqrel acqrel $struct 0
      (local.get 0)
      (ref.null (shared none))
      (local.get 0)
    )
  )

  ;; CHECK:      (func $rmw-add-i32-seqcst-ident (type $9) (param $0 (ref null $i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.rmw.add $i32 0
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-add-i32-seqcst-ident (param (ref null $i32)) (result i32)
    ;; Check that seqcst rmws are not optimized to acquire gets.
    (struct.atomic.rmw.add $i32 0
      (local.get 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $rmw-add-i32-unshared-ident (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.get $unshared-i32 0
  ;; CHECK-NEXT:   (block (result (ref null $unshared-i32))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (i32.const 0)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $rmw-add-i32-unshared-ident (param (ref null $unshared-i32)) (result i32)
    ;; Check just one unshared seqcst case to make sure we do the same identity
    ;; optimizations tested above.
    (struct.atomic.rmw.add $unshared-i32 0
      (local.get 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $cmpxchg-i32-unshared-ident (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (struct.atomic.get $unshared-i32 0
  ;; CHECK-NEXT:   (block (result (ref null $unshared-i32))
  ;; CHECK-NEXT:    (block
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (drop
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $cmpxchg-i32-unshared-ident (param (ref null $unshared-i32)) (result i32)
    ;; Check the same for cmpxchg.
    (struct.atomic.rmw.cmpxchg $unshared-i32 0
      (local.get 0)
      (i32.const 0)
      (i32.const 0)
    )
  )

  ;; CHECK:      (func $rmw-add-i32-lower (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i32 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i32 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-add-i32-lower (param (ref null $unshared-i32)) (result i32)
    (struct.atomic.rmw.add $unshared-i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $rmw-sub-i32-lower (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i32 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i32 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i32.sub
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-sub-i32-lower (param (ref null $unshared-i32)) (result i32)
    (struct.atomic.rmw.sub $unshared-i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $rmw-and-i32-lower (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i32 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i32 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i32.and
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-and-i32-lower (param (ref null $unshared-i32)) (result i32)
    (struct.atomic.rmw.and $unshared-i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $rmw-or-i32-lower (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i32 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i32 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i32.or
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-or-i32-lower (param (ref null $unshared-i32)) (result i32)
    (struct.atomic.rmw.or $unshared-i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $rmw-xor-i32-lower (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i32 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i32 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i32.xor
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-xor-i32-lower (param (ref null $unshared-i32)) (result i32)
    (struct.atomic.rmw.xor $unshared-i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $rmw-xchg-i32-lower (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i32 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i32 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-xchg-i32-lower (param (ref null $unshared-i32)) (result i32)
    (struct.atomic.rmw.xchg $unshared-i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $cmpxchg-i32-lower (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (i32.const 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.eq
  ;; CHECK-NEXT:    (local.tee $4
  ;; CHECK-NEXT:     (struct.get $unshared-i32 0
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (struct.set $unshared-i32 0
  ;; CHECK-NEXT:     (local.get $1)
  ;; CHECK-NEXT:     (local.get $3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $4)
  ;; CHECK-NEXT: )
  (func $cmpxchg-i32-lower (param (ref null $unshared-i32)) (result i32)
    (struct.atomic.rmw.cmpxchg $unshared-i32 0
      (local.get 0)
      (i32.const 1)
      (i32.const 2)
    )
  )

  ;; CHECK:      (func $rmw-add-i64-lower (type $14) (param $0 (ref null $unshared-i64)) (result i64)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i64))
  ;; CHECK-NEXT:  (local $2 i64)
  ;; CHECK-NEXT:  (local $3 i64)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i64 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i64 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i64.add
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-add-i64-lower (param (ref null $unshared-i64)) (result i64)
    (struct.atomic.rmw.add $unshared-i64 0
      (local.get 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $rmw-sub-i64-lower (type $14) (param $0 (ref null $unshared-i64)) (result i64)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i64))
  ;; CHECK-NEXT:  (local $2 i64)
  ;; CHECK-NEXT:  (local $3 i64)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i64 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i64 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i64.sub
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-sub-i64-lower (param (ref null $unshared-i64)) (result i64)
    (struct.atomic.rmw.sub $unshared-i64 0
      (local.get 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $rmw-and-i64-lower (type $14) (param $0 (ref null $unshared-i64)) (result i64)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i64))
  ;; CHECK-NEXT:  (local $2 i64)
  ;; CHECK-NEXT:  (local $3 i64)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i64 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i64 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i64.and
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-and-i64-lower (param (ref null $unshared-i64)) (result i64)
    (struct.atomic.rmw.and $unshared-i64 0
      (local.get 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $rmw-or-i64-lower (type $14) (param $0 (ref null $unshared-i64)) (result i64)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i64))
  ;; CHECK-NEXT:  (local $2 i64)
  ;; CHECK-NEXT:  (local $3 i64)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i64 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i64 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i64.or
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-or-i64-lower (param (ref null $unshared-i64)) (result i64)
    (struct.atomic.rmw.or $unshared-i64 0
      (local.get 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $rmw-xor-i64-lower (type $14) (param $0 (ref null $unshared-i64)) (result i64)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i64))
  ;; CHECK-NEXT:  (local $2 i64)
  ;; CHECK-NEXT:  (local $3 i64)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i64 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i64 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i64.xor
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-xor-i64-lower (param (ref null $unshared-i64)) (result i64)
    (struct.atomic.rmw.xor $unshared-i64 0
      (local.get 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $rmw-xchg-i64-lower (type $14) (param $0 (ref null $unshared-i64)) (result i64)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i64))
  ;; CHECK-NEXT:  (local $2 i64)
  ;; CHECK-NEXT:  (local $3 i64)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i64 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i64 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-xchg-i64-lower (param (ref null $unshared-i64)) (result i64)
    (struct.atomic.rmw.xchg $unshared-i64 0
      (local.get 0)
      (i64.const 1)
    )
  )

  ;; CHECK:      (func $cmpxchg-i64-lower (type $14) (param $0 (ref null $unshared-i64)) (result i64)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i64))
  ;; CHECK-NEXT:  (local $2 i64)
  ;; CHECK-NEXT:  (local $3 i64)
  ;; CHECK-NEXT:  (local $4 i64)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i64.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (i64.const 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i64.eq
  ;; CHECK-NEXT:    (local.tee $4
  ;; CHECK-NEXT:     (struct.get $unshared-i64 0
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (struct.set $unshared-i64 0
  ;; CHECK-NEXT:     (local.get $1)
  ;; CHECK-NEXT:     (local.get $3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $4)
  ;; CHECK-NEXT: )
  (func $cmpxchg-i64-lower (param (ref null $unshared-i64)) (result i64)
    (struct.atomic.rmw.cmpxchg $unshared-i64 0
      (local.get 0)
      (i64.const 1)
      (i64.const 2)
    )
  )

  ;; CHECK:      (func $rmw-xchg-ref-lower (type $15) (param $0 (ref null $unshared-struct)) (result (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local $2 (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local $3 (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (ref.null none)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-struct 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-struct 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-xchg-ref-lower (param (ref null $unshared-struct)) (result (ref null $unshared-struct))
    (struct.atomic.rmw.xchg $unshared-struct 0
      (local.get 0)
      (ref.null none)
    )
  )

  ;; CHECK:      (func $cmpxchg-ref-lower (type $15) (param $0 (ref null $unshared-struct)) (result (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local $2 (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local $3 (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local $4 (ref null $unshared-struct))
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (ref.null none)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (ref.eq
  ;; CHECK-NEXT:    (local.tee $4
  ;; CHECK-NEXT:     (struct.get $unshared-struct 0
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (struct.set $unshared-struct 0
  ;; CHECK-NEXT:     (local.get $1)
  ;; CHECK-NEXT:     (local.get $3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $4)
  ;; CHECK-NEXT: )
  (func $cmpxchg-ref-lower (param (ref null $unshared-struct)) (result (ref null $unshared-struct))
    (struct.atomic.rmw.cmpxchg $unshared-struct 0
      (local.get 0)
      (ref.null none)
      (local.get 0)
    )
  )

  ;; CHECK:      (func $rmw-add-i32-acqrel (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (struct.get $unshared-i32 0
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (struct.set $unshared-i32 0
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $3)
  ;; CHECK-NEXT: )
  (func $rmw-add-i32-acqrel (param (ref null $unshared-i32)) (result i32)
    ;; Check that the lowering of an acqrel RMW works the same way.
    (struct.atomic.rmw.add acqrel acqrel $unshared-i32 0
      (local.get 0)
      (i32.const 1)
    )
  )

  ;; CHECK:      (func $cmpxchg-i32-acqrel (type $13) (param $0 (ref null $unshared-i32)) (result i32)
  ;; CHECK-NEXT:  (local $1 (ref null $unshared-i32))
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (i32.const 2)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (i32.eq
  ;; CHECK-NEXT:    (local.tee $4
  ;; CHECK-NEXT:     (struct.get $unshared-i32 0
  ;; CHECK-NEXT:      (local.get $1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (struct.set $unshared-i32 0
  ;; CHECK-NEXT:     (local.get $1)
  ;; CHECK-NEXT:     (local.get $3)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $4)
  ;; CHECK-NEXT: )
  (func $cmpxchg-i32-acqrel (param (ref null $unshared-i32)) (result i32)
    ;; Same for an cmpxchg.
    (struct.atomic.rmw.cmpxchg acqrel acqrel $unshared-i32 0
      (local.get 0)
      (i32.const 1)
      (i32.const 2)
    )
  )
)
