;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-ctor-eval --ctors=test,test2 --kept-exports=test,test2 --quiet -all -S -o - | filecheck %s

;; Test that we can precompute continuations.

(module
  ;; CHECK:      (type $f (func))
  (type $f (func))
  (type $k (cont $f))

  ;; CHECK:      (type $1 (func (result i32)))

  ;; CHECK:      (tag $more (type $f))
  (tag $more)

  (global $g (mut i32) (i32.const 0))

  (func $run (param $k (ref $k))
    ;; Run a coroutine, continuing to resume it until it is complete.
    ;; start
    (loop $loop
      (block $on (result (ref $k))
        (resume $k (on $more $on)
          (local.get $k)
        )
        ;; stop
        (return)
      )
      ;; continue
      (local.set $k)
      (br $loop)
    )
    (unreachable)
  )

  (func $cont
    ;; increment the global three times, around suspends.
    (global.set $g (i32.add (global.get $g) (i32.const 1)))
    (suspend $more)
    (global.set $g (i32.add (global.get $g) (i32.const 1)))
    (suspend $more)
    (global.set $g (i32.add (global.get $g) (i32.const 1)))
  )

  (func $test (export "test") (result i32)
    ;; All of this can be computed, leaving a return of 3.
    (call $run
      (cont.new $k (ref.func $cont))
    )
    (global.get $g)
  )

  ;; CHECK:      (export "test" (func $test_4))

  ;; CHECK:      (export "test2" (func $test2))

  ;; CHECK:      (func $test2 (type $f)
  ;; CHECK-NEXT:  (suspend $more)
  ;; CHECK-NEXT: )
  (func $test2 (export "test2")
    ;; This unhandled suspend will trap, and should not be precomputed.
    (suspend $more)
  )
)
;; CHECK:      (func $test_4 (type $1) (result i32)
;; CHECK-NEXT:  (i32.const 3)
;; CHECK-NEXT: )
