/* SPDX-FileCopyrightText: 2023 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

#include "gpu_shader_create_info.hh"

GPU_SHADER_CREATE_INFO(compositor_keying_extract_chroma)
LOCAL_GROUP_SIZE(16, 16)
SAMPLER(0, sampler2D, input_tx)
IMAGE(0, GPU_RGBA16F, write, image2D, output_img)
COMPUTE_SOURCE("compositor_keying_extract_chroma.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_replace_chroma)
LOCAL_GROUP_SIZE(16, 16)
SAMPLER(0, sampler2D, input_tx)
SAMPLER(1, sampler2D, new_chroma_tx)
IMAGE(0, GPU_RGBA16F, write, image2D, output_img)
COMPUTE_SOURCE("compositor_keying_replace_chroma.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_compute_matte)
LOCAL_GROUP_SIZE(16, 16)
PUSH_CONSTANT(float, key_balance)
SAMPLER(0, sampler2D, input_tx)
SAMPLER(1, sampler2D, key_tx)
IMAGE(0, GPU_R16F, write, image2D, output_img)
COMPUTE_SOURCE("compositor_keying_compute_matte.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_tweak_matte_shared)
LOCAL_GROUP_SIZE(16, 16)
PUSH_CONSTANT(int, edge_search_radius)
PUSH_CONSTANT(float, edge_tolerance)
PUSH_CONSTANT(float, black_level)
PUSH_CONSTANT(float, white_level)
SAMPLER(0, sampler2D, input_matte_tx)
SAMPLER(1, sampler2D, garbage_matte_tx)
SAMPLER(2, sampler2D, core_matte_tx)
IMAGE(0, GPU_R16F, write, image2D, output_matte_img)
COMPUTE_SOURCE("compositor_keying_tweak_matte.glsl")
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_tweak_matte_without_edges)
ADDITIONAL_INFO(compositor_keying_tweak_matte_shared)
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_tweak_matte_with_edges)
ADDITIONAL_INFO(compositor_keying_tweak_matte_shared)
DEFINE("COMPUTE_EDGES")
IMAGE(1, GPU_R16F, write, image2D, output_edges_img)
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_compute_image)
LOCAL_GROUP_SIZE(16, 16)
PUSH_CONSTANT(float, despill_factor)
PUSH_CONSTANT(float, despill_balance)
SAMPLER(0, sampler2D, input_tx)
SAMPLER(1, sampler2D, matte_tx)
SAMPLER(2, sampler2D, key_tx)
IMAGE(0, GPU_RGBA16F, write, image2D, output_img)
COMPUTE_SOURCE("compositor_keying_compute_image.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()
