; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-none-linux-gnu -mattr=+neon %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64-none-linux-gnu -mattr=+neon -global-isel %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define <8 x i8> @cmeq8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmeq8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp eq <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmeq16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmeq16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp eq <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmeq4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmeq4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp eq <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmeq8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmeq8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp eq <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmeq2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmeq2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp eq <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmeq4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmeq4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp eq <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmeq2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmeq2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp eq <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmne8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmne8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ne <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmne16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmne16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ne <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmne4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmne4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ne <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmne8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmne8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ne <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmne2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmne2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ne <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmne4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmne4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ne <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmne2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmne2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmeq v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ne <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmgt8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmgt8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp sgt <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmgt16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmgt16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp sgt <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmgt4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmgt4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp sgt <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmgt8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmgt8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp sgt <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmgt2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmgt2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp sgt <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmgt4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmgt4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp sgt <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmgt2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmgt2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp sgt <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; LT implemented as GT, so check reversed operands.
define <8 x i8> @cmlt8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmlt8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.8b, v1.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp slt <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

; LT implemented as GT, so check reversed operands.
define <16 x i8> @cmlt16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmlt16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp slt <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

; LT implemented as GT, so check reversed operands.
define <4 x i16> @cmlt4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmlt4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.4h, v1.4h, v0.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp slt <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

; LT implemented as GT, so check reversed operands.
define <8 x i16> @cmlt8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmlt8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp slt <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

; LT implemented as GT, so check reversed operands.
define <2 x i32> @cmlt2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmlt2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp slt <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; LT implemented as GT, so check reversed operands.
define <4 x i32> @cmlt4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmlt4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp slt <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; LT implemented as GT, so check reversed operands.
define <2 x i64> @cmlt2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmlt2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp slt <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmge8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmge8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp sge <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmge16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmge16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp sge <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmge4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmge4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp sge <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmge8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmge8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp sge <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmge2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmge2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp sge <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmge4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmge4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp sge <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmge2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmge2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp sge <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; LE implemented as GE, so check reversed operands.
define <8 x i8> @cmle8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmle8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.8b, v1.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp sle <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

; LE implemented as GE, so check reversed operands.
define <16 x i8> @cmle16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmle16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp sle <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

; LE implemented as GE, so check reversed operands.
define <4 x i16> @cmle4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmle4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.4h, v1.4h, v0.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp sle <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

; LE implemented as GE, so check reversed operands.
define <8 x i16> @cmle8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmle8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp sle <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

; LE implemented as GE, so check reversed operands.
define <2 x i32> @cmle2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmle2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp sle <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; LE implemented as GE, so check reversed operands.
define <4 x i32> @cmle4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmle4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp sle <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; LE implemented as GE, so check reversed operands.
define <2 x i64> @cmle2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmle2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmge v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp sle <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmhi8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmhi8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmhi16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmhi16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmhi4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmhi4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmhi8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmhi8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmhi2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmhi2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmhi4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmhi4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmhi2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmhi2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <8 x i8> @cmlo8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmlo8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.8b, v1.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <16 x i8> @cmlo16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmlo16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <4 x i16> @cmlo4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmlo4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.4h, v1.4h, v0.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <8 x i16> @cmlo8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmlo8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <2 x i32> @cmlo2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmlo2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <4 x i32> @cmlo4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmlo4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <2 x i64> @cmlo2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmlo2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhi v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmhs8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmhs8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmhs16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmhs16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmhs4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmhs4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmhs8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmhs8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmhs2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmhs2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmhs4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmhs4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmhs2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmhs2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <8 x i8> @cmls8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-LABEL: cmls8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.8b, v1.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <8 x i8> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <16 x i8> @cmls16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-LABEL: cmls16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <16 x i8> %A, %B
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <4 x i16> @cmls4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-LABEL: cmls4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.4h, v1.4h, v0.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <4 x i16> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <8 x i16> @cmls8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-LABEL: cmls8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <8 x i16> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <2 x i32> @cmls2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-LABEL: cmls2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <2 x i32> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <4 x i32> @cmls4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-LABEL: cmls4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <4 x i32> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <2 x i64> @cmls2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-LABEL: cmls2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmhs v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <2 x i64> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmtst8xi8(<8 x i8> %A, <8 x i8> %B) {
; CHECK-SD-LABEL: cmtst8xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmtst8xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0000000000000000
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    cmeq v0.8b, v0.8b, v2.8b
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = and <8 x i8> %A, %B
  %tmp4 = icmp ne <8 x i8> %tmp3, zeroinitializer
  %tmp5 = sext <8 x i1> %tmp4 to <8 x i8>
  ret <8 x i8> %tmp5
}

define <16 x i8> @cmtst16xi8(<16 x i8> %A, <16 x i8> %B) {
; CHECK-SD-LABEL: cmtst16xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmtst16xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0000000000000000
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    cmeq v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = and <16 x i8> %A, %B
  %tmp4 = icmp ne <16 x i8> %tmp3, zeroinitializer
  %tmp5 = sext <16 x i1> %tmp4 to <16 x i8>
  ret <16 x i8> %tmp5
}

define <4 x i16> @cmtst4xi16(<4 x i16> %A, <4 x i16> %B) {
; CHECK-SD-LABEL: cmtst4xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.4h, v0.4h, v1.4h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmtst4xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0000000000000000
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    cmeq v0.4h, v0.4h, v2.4h
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = and <4 x i16> %A, %B
  %tmp4 = icmp ne <4 x i16> %tmp3, zeroinitializer
  %tmp5 = sext <4 x i1> %tmp4 to <4 x i16>
  ret <4 x i16> %tmp5
}

define <8 x i16> @cmtst8xi16(<8 x i16> %A, <8 x i16> %B) {
; CHECK-SD-LABEL: cmtst8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.8h, v0.8h, v1.8h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmtst8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0000000000000000
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    cmeq v0.8h, v0.8h, v2.8h
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = and <8 x i16> %A, %B
  %tmp4 = icmp ne <8 x i16> %tmp3, zeroinitializer
  %tmp5 = sext <8 x i1> %tmp4 to <8 x i16>
  ret <8 x i16> %tmp5
}

define <2 x i32> @cmtst2xi32(<2 x i32> %A, <2 x i32> %B) {
; CHECK-SD-LABEL: cmtst2xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.2s, v0.2s, v1.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmtst2xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0000000000000000
; CHECK-GI-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    cmeq v0.2s, v0.2s, v2.2s
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = and <2 x i32> %A, %B
  %tmp4 = icmp ne <2 x i32> %tmp3, zeroinitializer
  %tmp5 = sext <2 x i1> %tmp4 to <2 x i32>
  ret <2 x i32> %tmp5
}

define <4 x i32> @cmtst4xi32(<4 x i32> %A, <4 x i32> %B) {
; CHECK-SD-LABEL: cmtst4xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmtst4xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0000000000000000
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v2.4s
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = and <4 x i32> %A, %B
  %tmp4 = icmp ne <4 x i32> %tmp3, zeroinitializer
  %tmp5 = sext <4 x i1> %tmp4 to <4 x i32>
  ret <4 x i32> %tmp5
}

define <2 x i64> @cmtst2xi64(<2 x i64> %A, <2 x i64> %B) {
; CHECK-SD-LABEL: cmtst2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.2d, v0.2d, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmtst2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.2d, #0000000000000000
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    cmeq v0.2d, v0.2d, v2.2d
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = and <2 x i64> %A, %B
  %tmp4 = icmp ne <2 x i64> %tmp3, zeroinitializer
  %tmp5 = sext <2 x i1> %tmp4 to <2 x i64>
  ret <2 x i64> %tmp5
}



define <8 x i8> @cmeqz8xi8(<8 x i8> %A) {
; CHECK-SD-LABEL: cmeqz8xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmeqz8xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp eq <8 x i8> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmeqz16xi8(<16 x i8> %A) {
; CHECK-SD-LABEL: cmeqz16xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmeqz16xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp eq <16 x i8> %A, zeroinitializer
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmeqz4xi16(<4 x i16> %A) {
; CHECK-SD-LABEL: cmeqz4xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmeqz4xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.4h, v0.4h, v1.4h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp eq <4 x i16> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmeqz8xi16(<8 x i16> %A) {
; CHECK-SD-LABEL: cmeqz8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmeqz8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp eq <8 x i16> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmeqz2xi32(<2 x i32> %A) {
; CHECK-SD-LABEL: cmeqz2xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmeqz2xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp eq <2 x i32> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmeqz4xi32(<4 x i32> %A) {
; CHECK-SD-LABEL: cmeqz4xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmeqz4xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp eq <4 x i32> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmeqz2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmeqz2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmeq v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmeqz2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp eq <2 x i64> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}


define <8 x i8> @cmgez8xi8(<8 x i8> %A) {
; CHECK-SD-LABEL: cmgez8xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez8xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sge <8 x i8> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmgez16xi8(<16 x i8> %A) {
; CHECK-SD-LABEL: cmgez16xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez16xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sge <16 x i8> %A, zeroinitializer
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmgez4xi16(<4 x i16> %A) {
; CHECK-SD-LABEL: cmgez4xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez4xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.4h, v0.4h, v1.4h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sge <4 x i16> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmgez8xi16(<8 x i16> %A) {
; CHECK-SD-LABEL: cmgez8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sge <8 x i16> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmgez2xi32(<2 x i32> %A) {
; CHECK-SD-LABEL: cmgez2xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez2xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sge <2 x i32> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmgez4xi32(<4 x i32> %A) {
; CHECK-SD-LABEL: cmgez4xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez4xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sge <4 x i32> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmgez2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmgez2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sge <2 x i64> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}


define <8 x i8> @cmgez8xi8_alt(<8 x i8> %A) {
; CHECK-SD-LABEL: cmgez8xi8_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez8xi8_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.8b, v0.8b, #7
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %sign = ashr <8 x i8> %A, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %not = xor <8 x i8> %sign, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  ret <8 x i8> %not
}

define <16 x i8> @cmgez16xi8_alt(<16 x i8> %A) {
; CHECK-SD-LABEL: cmgez16xi8_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez16xi8_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.16b, v0.16b, #7
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %sign = ashr <16 x i8> %A, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %not = xor <16 x i8> %sign, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  ret <16 x i8> %not
}

define <4 x i16> @cmgez4xi16_alt(<4 x i16> %A) {
; CHECK-SD-LABEL: cmgez4xi16_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez4xi16_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.4h, v0.4h, #15
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %sign = ashr <4 x i16> %A, <i16 15, i16 15, i16 15, i16 15>
  %not = xor <4 x i16> %sign, <i16 -1, i16 -1, i16 -1, i16 -1>
  ret <4 x i16> %not
}

define <8 x i16> @cmgez8xi16_alt(<8 x i16> %A) {
; CHECK-SD-LABEL: cmgez8xi16_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez8xi16_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.8h, v0.8h, #15
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %sign = ashr <8 x i16> %A, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  %not = xor <8 x i16> %sign, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  ret <8 x i16> %not
}

define <2 x i32> @cmgez2xi32_alt(<2 x i32> %A) {
; CHECK-SD-LABEL: cmgez2xi32_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez2xi32_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.2s, v0.2s, #31
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %sign = ashr <2 x i32> %A, <i32 31, i32 31>
  %not = xor <2 x i32> %sign, <i32 -1, i32 -1>
  ret <2 x i32> %not
}

define <4 x i32> @cmgez4xi32_alt(<4 x i32> %A) {
; CHECK-SD-LABEL: cmgez4xi32_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez4xi32_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.4s, v0.4s, #31
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %sign = ashr <4 x i32> %A, <i32 31, i32 31, i32 31, i32 31>
  %not = xor <4 x i32> %sign, <i32 -1, i32 -1, i32 -1, i32 -1>
  ret <4 x i32> %not
}

define <2 x i64> @cmgez2xi64_alt(<2 x i64> %A) {
; CHECK-SD-LABEL: cmgez2xi64_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez2xi64_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.2d, v0.2d, #63
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %sign = ashr <2 x i64> %A, <i64 63, i64 63>
  %not = xor <2 x i64> %sign, <i64 -1, i64 -1>
  ret <2 x i64> %not
}

define <8 x i8> @cmgez8xi8_alt2(<8 x i8> %A) {
; CHECK-SD-LABEL: cmgez8xi8_alt2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez8xi8_alt2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xffffffffffffffff
; CHECK-GI-NEXT:    cmgt v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <8 x i8> %A, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmgez16xi8_alt2(<16 x i8> %A) {
; CHECK-SD-LABEL: cmgez16xi8_alt2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez16xi8_alt2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xffffffffffffffff
; CHECK-GI-NEXT:    cmgt v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <16 x i8> %A, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmgez4xi16_alt2(<4 x i16> %A) {
; CHECK-SD-LABEL: cmgez4xi16_alt2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez4xi16_alt2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xffffffffffffffff
; CHECK-GI-NEXT:    cmgt v0.4h, v0.4h, v1.4h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <4 x i16> %A, <i16 -1, i16 -1, i16 -1, i16 -1>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmgez8xi16_alt2(<8 x i16> %A) {
; CHECK-SD-LABEL: cmgez8xi16_alt2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez8xi16_alt2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xffffffffffffffff
; CHECK-GI-NEXT:    cmgt v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <8 x i16> %A, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmgez2xi32_alt2(<2 x i32> %A) {
; CHECK-SD-LABEL: cmgez2xi32_alt2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez2xi32_alt2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi d1, #0xffffffffffffffff
; CHECK-GI-NEXT:    cmgt v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <2 x i32> %A, <i32 -1, i32 -1>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmgez4xi32_alt2(<4 x i32> %A) {
; CHECK-SD-LABEL: cmgez4xi32_alt2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez4xi32_alt2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xffffffffffffffff
; CHECK-GI-NEXT:    cmgt v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <4 x i32> %A, <i32 -1, i32 -1, i32 -1, i32 -1>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmgez2xi64_alt2(<2 x i64> %A) {
; CHECK-SD-LABEL: cmgez2xi64_alt2:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmge v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgez2xi64_alt2:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0xffffffffffffffff
; CHECK-GI-NEXT:    cmgt v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <2 x i64> %A, <i64 -1, i64 -1>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}


define <8 x i8> @cmgtz8xi8(<8 x i8> %A) {
; CHECK-SD-LABEL: cmgtz8xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgtz8xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <8 x i8> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmgtz16xi8(<16 x i8> %A) {
; CHECK-SD-LABEL: cmgtz16xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgtz16xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <16 x i8> %A, zeroinitializer
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmgtz4xi16(<4 x i16> %A) {
; CHECK-SD-LABEL: cmgtz4xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgtz4xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.4h, v0.4h, v1.4h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <4 x i16> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmgtz8xi16(<8 x i16> %A) {
; CHECK-SD-LABEL: cmgtz8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgtz8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <8 x i16> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmgtz2xi32(<2 x i32> %A) {
; CHECK-SD-LABEL: cmgtz2xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgtz2xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <2 x i32> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmgtz4xi32(<4 x i32> %A) {
; CHECK-SD-LABEL: cmgtz4xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgtz4xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <4 x i32> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmgtz2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmgtz2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmgtz2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sgt <2 x i64> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmlez8xi8(<8 x i8> %A) {
; CHECK-SD-LABEL: cmlez8xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez8xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.8b, v1.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sle <8 x i8> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmlez16xi8(<16 x i8> %A) {
; CHECK-SD-LABEL: cmlez16xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez16xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.16b, v1.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sle <16 x i8> %A, zeroinitializer
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmlez4xi16(<4 x i16> %A) {
; CHECK-SD-LABEL: cmlez4xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez4xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.4h, v1.4h, v0.4h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sle <4 x i16> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmlez8xi16(<8 x i16> %A) {
; CHECK-SD-LABEL: cmlez8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.8h, v1.8h, v0.8h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sle <8 x i16> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmlez2xi32(<2 x i32> %A) {
; CHECK-SD-LABEL: cmlez2xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez2xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.2s, v1.2s, v0.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sle <2 x i32> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmlez4xi32(<4 x i32> %A) {
; CHECK-SD-LABEL: cmlez4xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez4xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.4s, v1.4s, v0.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sle <4 x i32> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmlez2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmlez2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmge v0.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp sle <2 x i64> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmlez8xi8_alt(<8 x i8> %A) {
; CHECK-SD-LABEL: cmlez8xi8_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez8xi8_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.8b, #1
; CHECK-GI-NEXT:    cmgt v0.8b, v1.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <8 x i8> %A, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmlez16xi8_alt(<16 x i8> %A) {
; CHECK-SD-LABEL: cmlez16xi8_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez16xi8_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.16b, #1
; CHECK-GI-NEXT:    cmgt v0.16b, v1.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <16 x i8> %A, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmlez4xi16_alt(<4 x i16> %A) {
; CHECK-SD-LABEL: cmlez4xi16_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez4xi16_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.4h, #1
; CHECK-GI-NEXT:    cmgt v0.4h, v1.4h, v0.4h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <4 x i16> %A, <i16 1, i16 1, i16 1, i16 1>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmlez8xi16_alt(<8 x i16> %A) {
; CHECK-SD-LABEL: cmlez8xi16_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez8xi16_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.8h, #1
; CHECK-GI-NEXT:    cmgt v0.8h, v1.8h, v0.8h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <8 x i16> %A, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmlez2xi32_alt(<2 x i32> %A) {
; CHECK-SD-LABEL: cmlez2xi32_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez2xi32_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2s, #1
; CHECK-GI-NEXT:    cmgt v0.2s, v1.2s, v0.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <2 x i32> %A, <i32 1, i32 1>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmlez4xi32_alt(<4 x i32> %A) {
; CHECK-SD-LABEL: cmlez4xi32_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez4xi32_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.4s, #1
; CHECK-GI-NEXT:    cmgt v0.4s, v1.4s, v0.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <4 x i32> %A, <i32 1, i32 1, i32 1, i32 1>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmlez2xi64_alt(<2 x i64> %A) {
; CHECK-SD-LABEL: cmlez2xi64_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmle v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmlez2xi64_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI125_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI125_0]
; CHECK-GI-NEXT:    cmgt v0.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <2 x i64> %A, <i64 1, i64 1>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmltz8xi8(<8 x i8> %A) {
; CHECK-SD-LABEL: cmltz8xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz8xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.8b, v1.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <8 x i8> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmltz16xi8(<16 x i8> %A) {
; CHECK-SD-LABEL: cmltz16xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz16xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.16b, v1.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <16 x i8> %A, zeroinitializer
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmltz4xi16(<4 x i16> %A) {
; CHECK-SD-LABEL: cmltz4xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz4xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.4h, v1.4h, v0.4h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <4 x i16> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmltz8xi16(<8 x i16> %A) {
; CHECK-SD-LABEL: cmltz8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.8h, v1.8h, v0.8h
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <8 x i16> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmltz2xi32(<2 x i32> %A) {
; CHECK-SD-LABEL: cmltz2xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz2xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.2s, v1.2s, v0.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <2 x i32> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmltz4xi32(<4 x i32> %A) {
; CHECK-SD-LABEL: cmltz4xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz4xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.4s, v1.4s, v0.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <4 x i32> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmltz2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmltz2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmgt v0.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp slt <2 x i64> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i1> @not_cmle8xi8(<8 x i8> %0) {
; CHECK-SD-LABEL: not_cmle8xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v1.2s, #1
; CHECK-SD-NEXT:    cmgt v0.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: not_cmle8xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI133_0
; CHECK-GI-NEXT:    ldr d1, [x8, :lo12:.LCPI133_0]
; CHECK-GI-NEXT:    cmgt v0.8b, v1.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %cmp.i = icmp slt <8 x i8> %0, <i8 1, i8 0, i8 0, i8 0, i8 1, i8 0, i8 0, i8 0>
  ret <8 x i1> %cmp.i
}

define <4 x i1> @not_cmle16xi8(<4 x i32> %0) {
; CHECK-SD-LABEL: not_cmle16xi8:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    movi v1.8h, #1
; CHECK-SD-NEXT:    cmgt v0.4s, v1.4s, v0.4s
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: not_cmle16xi8:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    adrp x8, .LCPI134_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI134_0]
; CHECK-GI-NEXT:    cmgt v0.4s, v1.4s, v0.4s
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
entry:
  %bc = bitcast <16 x i8> <i8 1, i8 0, i8 1, i8 0, i8 1, i8 0, i8 1, i8 0, i8 1, i8 0, i8 1, i8 0, i8 1, i8 0, i8 1, i8 0> to <4 x i32>
  %cmp.i = icmp slt <4 x i32> %0, %bc
  ret <4 x i1> %cmp.i
}

define <8 x i8> @cmltz8xi8_alt(<8 x i8> %A) {
; CHECK-SD-LABEL: cmltz8xi8_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.8b, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz8xi8_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.8b, v0.8b, #7
; CHECK-GI-NEXT:    ret
  %A.lobit = ashr <8 x i8> %A, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  ret <8 x i8> %A.lobit
}

define <16 x i8> @cmltz16xi8_alt(<16 x i8> %A) {
; CHECK-SD-LABEL: cmltz16xi8_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.16b, v0.16b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz16xi8_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.16b, v0.16b, #7
; CHECK-GI-NEXT:    ret
  %A.lobit = ashr <16 x i8> %A, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  ret <16 x i8> %A.lobit
}

define <4 x i16> @cmltz4xi16_alt(<4 x i16> %A) {
; CHECK-SD-LABEL: cmltz4xi16_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.4h, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz4xi16_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.4h, v0.4h, #15
; CHECK-GI-NEXT:    ret
  %A.lobit = ashr <4 x i16> %A, <i16 15, i16 15, i16 15, i16 15>
  ret <4 x i16> %A.lobit
}

define <8 x i16> @cmltz8xi16_alt(<8 x i16> %A) {
; CHECK-SD-LABEL: cmltz8xi16_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.8h, v0.8h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz8xi16_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.8h, v0.8h, #15
; CHECK-GI-NEXT:    ret
  %A.lobit = ashr <8 x i16> %A, <i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15, i16 15>
  ret <8 x i16> %A.lobit
}

define <2 x i32> @cmltz2xi32_alt(<2 x i32> %A) {
; CHECK-SD-LABEL: cmltz2xi32_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.2s, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz2xi32_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.2s, v0.2s, #31
; CHECK-GI-NEXT:    ret
  %A.lobit = ashr <2 x i32> %A, <i32 31, i32 31>
  ret <2 x i32> %A.lobit
}

define <4 x i32> @cmltz4xi32_alt(<4 x i32> %A) {
; CHECK-SD-LABEL: cmltz4xi32_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.4s, v0.4s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz4xi32_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.4s, v0.4s, #31
; CHECK-GI-NEXT:    ret
  %A.lobit = ashr <4 x i32> %A, <i32 31, i32 31, i32 31, i32 31>
  ret <4 x i32> %A.lobit
}

define <2 x i64> @cmltz2xi64_alt(<2 x i64> %A) {
; CHECK-SD-LABEL: cmltz2xi64_alt:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmlt v0.2d, v0.2d, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmltz2xi64_alt:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    sshr v0.2d, v0.2d, #63
; CHECK-GI-NEXT:    ret
  %A.lobit = ashr <2 x i64> %A, <i64 63, i64 63>
  ret <2 x i64> %A.lobit
}

define <8 x i8> @cmneqz8xi8(<8 x i8> %A) {
; CHECK-SD-LABEL: cmneqz8xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmneqz8xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ne <8 x i8> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmneqz16xi8(<16 x i8> %A) {
; CHECK-SD-LABEL: cmneqz16xi8:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.16b, v0.16b, v0.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmneqz16xi8:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ne <16 x i8> %A, zeroinitializer
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmneqz4xi16(<4 x i16> %A) {
; CHECK-SD-LABEL: cmneqz4xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.4h, v0.4h, v0.4h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmneqz4xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.4h, v0.4h, v1.4h
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ne <4 x i16> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmneqz8xi16(<8 x i16> %A) {
; CHECK-SD-LABEL: cmneqz8xi16:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.8h, v0.8h, v0.8h
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmneqz8xi16:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.8h, v0.8h, v1.8h
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ne <8 x i16> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmneqz2xi32(<2 x i32> %A) {
; CHECK-SD-LABEL: cmneqz2xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.2s, v0.2s, v0.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmneqz2xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ne <2 x i32> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmneqz4xi32(<4 x i32> %A) {
; CHECK-SD-LABEL: cmneqz4xi32:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.4s, v0.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmneqz4xi32:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ne <4 x i32> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmneqz2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmneqz2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmtst v0.2d, v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmneqz2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v1.2d, #0000000000000000
; CHECK-GI-NEXT:    cmeq v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ne <2 x i64> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <8 x i8> @cmhsz8xi8(<8 x i8> %A) {
; CHECK-LABEL: cmhsz8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8b, #2
; CHECK-NEXT:    cmhs v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <8 x i8> %A, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmhsz16xi8(<16 x i8> %A) {
; CHECK-LABEL: cmhsz16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #2
; CHECK-NEXT:    cmhs v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <16 x i8> %A, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmhsz4xi16(<4 x i16> %A) {
; CHECK-LABEL: cmhsz4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4h, #2
; CHECK-NEXT:    cmhs v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <4 x i16> %A, <i16 2, i16 2, i16 2, i16 2>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmhsz8xi16(<8 x i16> %A) {
; CHECK-LABEL: cmhsz8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #2
; CHECK-NEXT:    cmhs v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <8 x i16> %A, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmhsz2xi32(<2 x i32> %A) {
; CHECK-LABEL: cmhsz2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2s, #2
; CHECK-NEXT:    cmhs v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <2 x i32> %A, <i32 2, i32 2>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmhsz4xi32(<4 x i32> %A) {
; CHECK-LABEL: cmhsz4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #2
; CHECK-NEXT:    cmhs v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp uge <4 x i32> %A, <i32 2, i32 2, i32 2, i32 2>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmhsz2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmhsz2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #2 // =0x2
; CHECK-SD-NEXT:    dup v1.2d, x8
; CHECK-SD-NEXT:    cmhs v0.2d, v0.2d, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmhsz2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI155_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI155_0]
; CHECK-GI-NEXT:    cmhs v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp uge <2 x i64> %A, <i64 2, i64 2>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}


define <8 x i8> @cmhiz8xi8(<8 x i8> %A) {
; CHECK-LABEL: cmhiz8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8b, #1
; CHECK-NEXT:    cmhi v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <8 x i8> %A, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

define <16 x i8> @cmhiz16xi8(<16 x i8> %A) {
; CHECK-LABEL: cmhiz16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #1
; CHECK-NEXT:    cmhi v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <16 x i8> %A, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

define <4 x i16> @cmhiz4xi16(<4 x i16> %A) {
; CHECK-LABEL: cmhiz4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4h, #1
; CHECK-NEXT:    cmhi v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <4 x i16> %A, <i16 1, i16 1, i16 1, i16 1>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

define <8 x i16> @cmhiz8xi16(<8 x i16> %A) {
; CHECK-LABEL: cmhiz8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #1
; CHECK-NEXT:    cmhi v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <8 x i16> %A, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

define <2 x i32> @cmhiz2xi32(<2 x i32> %A) {
; CHECK-LABEL: cmhiz2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2s, #1
; CHECK-NEXT:    cmhi v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <2 x i32> %A, <i32 1, i32 1>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @cmhiz4xi32(<4 x i32> %A) {
; CHECK-LABEL: cmhiz4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #1
; CHECK-NEXT:    cmhi v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp ugt <4 x i32> %A, <i32 1, i32 1, i32 1, i32 1>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @cmhiz2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmhiz2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #1 // =0x1
; CHECK-SD-NEXT:    dup v1.2d, x8
; CHECK-SD-NEXT:    cmhi v0.2d, v0.2d, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmhiz2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI162_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI162_0]
; CHECK-GI-NEXT:    cmhi v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ugt <2 x i64> %A, <i64 1, i64 1>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <8 x i8> @cmlsz8xi8(<8 x i8> %A) {
; CHECK-LABEL: cmlsz8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0000000000000000
; CHECK-NEXT:    cmhs v0.8b, v1.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <8 x i8> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <16 x i8> @cmlsz16xi8(<16 x i8> %A) {
; CHECK-LABEL: cmlsz16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0000000000000000
; CHECK-NEXT:    cmhs v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <16 x i8> %A, zeroinitializer
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <4 x i16> @cmlsz4xi16(<4 x i16> %A) {
; CHECK-LABEL: cmlsz4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0000000000000000
; CHECK-NEXT:    cmhs v0.4h, v1.4h, v0.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <4 x i16> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <8 x i16> @cmlsz8xi16(<8 x i16> %A) {
; CHECK-LABEL: cmlsz8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0000000000000000
; CHECK-NEXT:    cmhs v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <8 x i16> %A, zeroinitializer
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <2 x i32> @cmlsz2xi32(<2 x i32> %A) {
; CHECK-LABEL: cmlsz2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0000000000000000
; CHECK-NEXT:    cmhs v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <2 x i32> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <4 x i32> @cmlsz4xi32(<4 x i32> %A) {
; CHECK-LABEL: cmlsz4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0000000000000000
; CHECK-NEXT:    cmhs v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <4 x i32> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; LS implemented as HS, so check reversed operands.
define <2 x i64> @cmlsz2xi64(<2 x i64> %A) {
; CHECK-LABEL: cmlsz2xi64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0000000000000000
; CHECK-NEXT:    cmhs v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = icmp ule <2 x i64> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <8 x i8> @cmloz8xi8(<8 x i8> %A) {
; CHECK-LABEL: cmloz8xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8b, #2
; CHECK-NEXT:    cmhi v0.8b, v1.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <8 x i8> %A, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i8>
  ret <8 x i8> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <16 x i8> @cmloz16xi8(<16 x i8> %A) {
; CHECK-LABEL: cmloz16xi8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #2
; CHECK-NEXT:    cmhi v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <16 x i8> %A, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  %tmp4 = sext <16 x i1> %tmp3 to <16 x i8>
  ret <16 x i8> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <4 x i16> @cmloz4xi16(<4 x i16> %A) {
; CHECK-LABEL: cmloz4xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4h, #2
; CHECK-NEXT:    cmhi v0.4h, v1.4h, v0.4h
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <4 x i16> %A, <i16 2, i16 2, i16 2, i16 2>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i16>
  ret <4 x i16> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <8 x i16> @cmloz8xi16(<8 x i16> %A) {
; CHECK-LABEL: cmloz8xi16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #2
; CHECK-NEXT:    cmhi v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <8 x i16> %A, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i16>
  ret <8 x i16> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <2 x i32> @cmloz2xi32(<2 x i32> %A) {
; CHECK-LABEL: cmloz2xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2s, #2
; CHECK-NEXT:    cmhi v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <2 x i32> %A, <i32 2, i32 2>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <4 x i32> @cmloz4xi32(<4 x i32> %A) {
; CHECK-LABEL: cmloz4xi32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #2
; CHECK-NEXT:    cmhi v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = icmp ult <4 x i32> %A, <i32 2, i32 2, i32 2, i32 2>
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; LO implemented as HI, so check reversed operands.
define <2 x i64> @cmloz2xi64(<2 x i64> %A) {
; CHECK-SD-LABEL: cmloz2xi64:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    mov w8, #2 // =0x2
; CHECK-SD-NEXT:    dup v1.2d, x8
; CHECK-SD-NEXT:    cmhi v0.2d, v1.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: cmloz2xi64:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    adrp x8, .LCPI176_0
; CHECK-GI-NEXT:    ldr q1, [x8, :lo12:.LCPI176_0]
; CHECK-GI-NEXT:    cmhi v0.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = icmp ult <2 x i64> %A, <i64 2, i64 2>
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmoeq2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmoeq2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp oeq <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmoeq4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmoeq4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp oeq <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmoeq2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmoeq2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp oeq <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmoge2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmoge2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp oge <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmoge4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmoge4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp oge <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmoge2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmoge2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp oge <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmogt2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmogt2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp ogt <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmogt4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmogt4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp ogt <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmogt2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmogt2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp ogt <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; OLE implemented as OGE, so check reversed operands.
define <2 x i32> @fcmole2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmole2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp ole <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; OLE implemented as OGE, so check reversed operands.
define <4 x i32> @fcmole4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmole4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp ole <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; OLE implemented as OGE, so check reversed operands.
define <2 x i64> @fcmole2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmole2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp ole <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; OLE implemented as OGE, so check reversed operands.
define <2 x i32> @fcmolt2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmolt2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp olt <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; OLE implemented as OGE, so check reversed operands.
define <4 x i32> @fcmolt4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmolt4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp olt <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; OLE implemented as OGE, so check reversed operands.
define <2 x i64> @fcmolt2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmolt2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp olt <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ONE = OGT | OLT, OLT implemented as OGT so check reversed operands
define <2 x i32> @fcmone2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmone2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v2.2s, v0.2s, v1.2s
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp one <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; ONE = OGT | OLT, OLT implemented as OGT so check reversed operands
define <4 x i32> @fcmone4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmone4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v2.4s, v0.4s, v1.4s
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp one <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; ONE = OGT | OLT, OLT implemented as OGT so check reversed operands
; todo check reversed operands
define <2 x i64> @fcmone2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmone2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v2.2d, v0.2d, v1.2d
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp one <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ORD = OGE | OLT, OLT implemented as OGT, so check reversed operands.
define <2 x i32> @fcmord2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmord2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.2s, v0.2s, v1.2s
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ord <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; ORD = OGE | OLT, OLT implemented as OGT, so check reversed operands.
define <4 x i32> @fcmord4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmord4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.4s, v0.4s, v1.4s
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ord <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; ORD = OGE | OLT, OLT implemented as OGT, so check reversed operands.
define <2 x i64> @fcmord2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmord2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.2d, v0.2d, v1.2d
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ord <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}


; UNO = !(OGE | OLT), OLT implemented as OGT, so check reversed operands.
define <2 x i32> @fcmuno2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmuno2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.2s, v0.2s, v1.2s
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uno <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UNO = !(OGE | OLT), OLT implemented as OGT, so check reversed operands.
define <4 x i32> @fcmuno4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmuno4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.4s, v0.4s, v1.4s
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uno <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UNO = !(OGE | OLT), OLT implemented as OGT, so check reversed operands.
define <2 x i64> @fcmuno2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmuno2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.2d, v0.2d, v1.2d
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uno <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UEQ = !ONE = !(OGT | OLT), OLT implemented as OGT so check reversed operands
define <2 x i32> @fcmueq2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmueq2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v2.2s, v0.2s, v1.2s
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ueq <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UEQ = !ONE = !(OGT | OLT), OLT implemented as OGT so check reversed operands
define <4 x i32> @fcmueq4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmueq4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v2.4s, v0.4s, v1.4s
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ueq <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UEQ = !ONE = !(OGT | OLT), OLT implemented as OGT so check reversed operands
define <2 x i64> @fcmueq2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmueq2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v2.2d, v0.2d, v1.2d
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ueq <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UGE = ULE with swapped operands, ULE implemented as !OGT.
define <2 x i32> @fcmuge2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmuge2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uge <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UGE = ULE with swapped operands, ULE implemented as !OGT.
define <4 x i32> @fcmuge4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmuge4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uge <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UGE = ULE with swapped operands, ULE implemented as !OGT.
define <2 x i64> @fcmuge2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmuge2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uge <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UGT = ULT with swapped operands, ULT implemented as !OGE.
define <2 x i32> @fcmugt2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmugt2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ugt <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UGT = ULT with swapped operands, ULT implemented as !OGE.
define <4 x i32> @fcmugt4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmugt4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ugt <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmugt2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmugt2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ugt <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ULE implemented as !OGT.
define <2 x i32> @fcmule2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmule2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ule <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; ULE implemented as !OGT.
define <4 x i32> @fcmule4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmule4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ule <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; ULE implemented as !OGT.
define <2 x i64> @fcmule2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmule2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ule <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ULT implemented as !OGE.
define <2 x i32> @fcmult2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmult2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ult <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; ULT implemented as !OGE.
define <4 x i32> @fcmult4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmult4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ult <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; ULT implemented as !OGE.
define <2 x i64> @fcmult2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmult2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ult <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UNE = !OEQ.
define <2 x i32> @fcmune2xfloat(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmune2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp une <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UNE = !OEQ.
define <4 x i32> @fcmune4xfloat(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmune4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp une <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UNE = !OEQ.
define <2 x i64> @fcmune2xdouble(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmune2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp une <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmoeqz2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmoeqz2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp oeq <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmoeqz4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmoeqz4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp oeq <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmoeqz2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmoeqz2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp oeq <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}


define <2 x i32> @fcmogez2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmogez2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp oge <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmogez4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmogez4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp oge <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmogez2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmogez2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp oge <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmogtz2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmogtz2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp ogt <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmogtz4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmogtz4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp ogt <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmogtz2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmogtz2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp ogt <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmoltz2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmoltz2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp olt <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmoltz4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmoltz4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp olt <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmoltz2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmoltz2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp olt <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmolez2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmolez2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp ole <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmolez4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmolez4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp ole <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmolez2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmolez2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp ole <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ONE with zero = OLT | OGT
define <2 x i32> @fcmonez2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmonez2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v1.2s, v0.2s, #0.0
; CHECK-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp one <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; ONE with zero = OLT | OGT
define <4 x i32> @fcmonez4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmonez4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v1.4s, v0.4s, #0.0
; CHECK-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp one <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; ONE with zero = OLT | OGT
define <2 x i64> @fcmonez2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmonez2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v1.2d, v0.2d, #0.0
; CHECK-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp one <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ORD with zero = OLT | OGE
define <2 x i32> @fcmordz2xfloat(<2 x float> %A) {
; CHECK-SD-LABEL: fcmordz2xfloat:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v1.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmordz2xfloat:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmeq v0.2s, v0.2s, v0.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp ord <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; ORD with zero = OLT | OGE
define <4 x i32> @fcmordz4xfloat(<4 x float> %A) {
; CHECK-SD-LABEL: fcmordz4xfloat:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v1.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmordz4xfloat:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmeq v0.4s, v0.4s, v0.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp ord <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; ORD with zero = OLT | OGE
define <2 x i64> @fcmordz2xdouble(<2 x double> %A) {
; CHECK-SD-LABEL: fcmordz2xdouble:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v1.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmordz2xdouble:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmeq v0.2d, v0.2d, v0.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp ord <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UEQ with zero = !ONE = !(OLT |OGT)
define <2 x i32> @fcmueqz2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmueqz2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v1.2s, v0.2s, #0.0
; CHECK-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ueq <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UEQ with zero = !ONE = !(OLT |OGT)
define <4 x i32> @fcmueqz4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmueqz4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v1.4s, v0.4s, #0.0
; CHECK-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ueq <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UEQ with zero = !ONE = !(OLT |OGT)
define <2 x i64> @fcmueqz2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmueqz2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v1.2d, v0.2d, #0.0
; CHECK-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ueq <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UGE with zero = !OLT
define <2 x i32> @fcmugez2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmugez2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uge <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UGE with zero = !OLT
define <4 x i32> @fcmugez4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmugez4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uge <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UGE with zero = !OLT
define <2 x i64> @fcmugez2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmugez2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uge <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UGT with zero = !OLE
define <2 x i32> @fcmugtz2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmugtz2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.2s, v0.2s, #0.0
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ugt <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UGT with zero = !OLE
define <4 x i32> @fcmugtz4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmugtz4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.4s, v0.4s, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ugt <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UGT with zero = !OLE
define <2 x i64> @fcmugtz2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmugtz2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.2d, v0.2d, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ugt <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ULT with zero = !OGE
define <2 x i32> @fcmultz2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmultz2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v0.2s, #0.0
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ult <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmultz4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmultz4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v0.4s, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ult <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmultz2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmultz2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v0.2d, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ult <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ULE with zero = !OGT
define <2 x i32> @fcmulez2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmulez2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ule <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; ULE with zero = !OGT
define <4 x i32> @fcmulez4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmulez4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ule <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; ULE with zero = !OGT
define <2 x i64> @fcmulez2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmulez2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp ule <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UNE with zero = !OEQ with zero
define <2 x i32> @fcmunez2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmunez2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, #0.0
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp une <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UNE with zero = !OEQ with zero
define <4 x i32> @fcmunez4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmunez4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp une <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UNE with zero = !OEQ with zero
define <2 x i64> @fcmunez2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmunez2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2d, v0.2d, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp une <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; UNO with zero = !ORD = !(OLT | OGE)
define <2 x i32> @fcmunoz2xfloat(<2 x float> %A) {
; CHECK-LABEL: fcmunoz2xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v1.2s, v0.2s, #0.0
; CHECK-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uno <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

; UNO with zero = !ORD = !(OLT | OGE)
define <4 x i32> @fcmunoz4xfloat(<4 x float> %A) {
; CHECK-LABEL: fcmunoz4xfloat:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v1.4s, v0.4s, #0.0
; CHECK-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uno <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; UNO with zero = !ORD = !(OLT | OGE)
define <2 x i64> @fcmunoz2xdouble(<2 x double> %A) {
; CHECK-LABEL: fcmunoz2xdouble:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v1.2d, v0.2d, #0.0
; CHECK-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp uno <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4

}

define <2 x i32> @fcmoeq2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmoeq2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oeq <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmoeq4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmoeq4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oeq <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmoeq2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmoeq2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oeq <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmoge2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmoge2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oge <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmoge4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmoge4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oge <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmoge2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmoge2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oge <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmogt2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmogt2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ogt <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmogt4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmogt4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ogt <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmogt2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmogt2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ogt <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmole2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmole2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ole <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmole4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmole4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ole <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmole2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmole2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ole <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmolt2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmolt2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast olt <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmolt4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmolt4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast olt <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmolt2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmolt2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast olt <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmone2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-SD-LABEL: fcmone2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.2s, v0.2s, v1.2s
; CHECK-SD-NEXT:    mvn v0.8b, v0.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmone2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v2.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast one <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmone4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-SD-LABEL: fcmone4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    mvn v0.16b, v0.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmone4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v2.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast one <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmone2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-SD-LABEL: fcmone2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.2d, v0.2d, v1.2d
; CHECK-SD-NEXT:    mvn v0.16b, v0.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmone2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v2.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast one <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmord2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmord2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.2s, v0.2s, v1.2s
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ord <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmord4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmord4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.4s, v0.4s, v1.4s
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ord <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmord2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmord2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.2d, v0.2d, v1.2d
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ord <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}


define <2 x i32> @fcmuno2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmuno2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.2s, v0.2s, v1.2s
; CHECK-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast uno <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmuno4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmuno4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.4s, v0.4s, v1.4s
; CHECK-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast uno <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmuno2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmuno2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v2.2d, v0.2d, v1.2d
; CHECK-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast uno <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmueq2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-SD-LABEL: fcmueq2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.2s, v0.2s, v1.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmueq2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v2.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v2.8b
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ueq <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmueq4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-SD-LABEL: fcmueq4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmueq4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v2.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ueq <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmueq2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-SD-LABEL: fcmueq2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.2d, v0.2d, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmueq2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v2.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ueq <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmuge2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-SD-LABEL: fcmuge2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.2s, v0.2s, v1.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmuge2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast uge <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmuge4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-SD-LABEL: fcmuge4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmuge4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast uge <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmuge2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-SD-LABEL: fcmuge2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.2d, v0.2d, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmuge2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast uge <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmugt2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-SD-LABEL: fcmugt2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.2s, v0.2s, v1.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugt2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.2s, v1.2s, v0.2s
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ugt <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmugt4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-SD-LABEL: fcmugt4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugt4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ugt <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmugt2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-SD-LABEL: fcmugt2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.2d, v0.2d, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugt2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.2d, v1.2d, v0.2d
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ugt <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmule2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-SD-LABEL: fcmule2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.2s, v1.2s, v0.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmule2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ule <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmule4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-SD-LABEL: fcmule4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmule4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ule <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmule2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-SD-LABEL: fcmule2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.2d, v1.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmule2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ule <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmult2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-SD-LABEL: fcmult2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.2s, v1.2s, v0.2s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmult2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.2s, v0.2s, v1.2s
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ult <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmult4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-SD-LABEL: fcmult4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.4s, v1.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmult4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ult <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmult2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-SD-LABEL: fcmult2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.2d, v1.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmult2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.2d, v0.2d, v1.2d
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ult <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmune2xfloat_fast(<2 x float> %A, <2 x float> %B) {
; CHECK-LABEL: fcmune2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast une <2 x float> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmune4xfloat_fast(<4 x float> %A, <4 x float> %B) {
; CHECK-LABEL: fcmune4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast une <4 x float> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmune2xdouble_fast(<2 x double> %A, <2 x double> %B) {
; CHECK-LABEL: fcmune2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast une <2 x double> %A, %B
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmoeqz2xfloat_fast(<2 x float> %A) {
; CHECK-LABEL: fcmoeqz2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oeq <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmoeqz4xfloat_fast(<4 x float> %A) {
; CHECK-LABEL: fcmoeqz4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oeq <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmoeqz2xdouble_fast(<2 x double> %A) {
; CHECK-LABEL: fcmoeqz2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oeq <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}


define <2 x i32> @fcmogez2xfloat_fast(<2 x float> %A) {
; CHECK-LABEL: fcmogez2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oge <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmogez4xfloat_fast(<4 x float> %A) {
; CHECK-LABEL: fcmogez4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oge <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmogez2xdouble_fast(<2 x double> %A) {
; CHECK-LABEL: fcmogez2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast oge <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmogtz2xfloat_fast(<2 x float> %A) {
; CHECK-LABEL: fcmogtz2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ogt <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmogtz4xfloat_fast(<4 x float> %A) {
; CHECK-LABEL: fcmogtz4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ogt <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}
define <2 x i64> @fcmogtz2xdouble_fast(<2 x double> %A) {
; CHECK-LABEL: fcmogtz2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmgt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ogt <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmoltz2xfloat_fast(<2 x float> %A) {
; CHECK-LABEL: fcmoltz2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast olt <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmoltz4xfloat_fast(<4 x float> %A) {
; CHECK-LABEL: fcmoltz4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast olt <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmoltz2xdouble_fast(<2 x double> %A) {
; CHECK-LABEL: fcmoltz2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast olt <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmolez2xfloat_fast(<2 x float> %A) {
; CHECK-LABEL: fcmolez2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.2s, v0.2s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ole <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmolez4xfloat_fast(<4 x float> %A) {
; CHECK-LABEL: fcmolez4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.4s, v0.4s, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ole <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmolez2xdouble_fast(<2 x double> %A) {
; CHECK-LABEL: fcmolez2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmle v0.2d, v0.2d, #0.0
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast ole <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmonez2xfloat_fast(<2 x float> %A) {
; CHECK-SD-LABEL: fcmonez2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    mvn v0.8b, v0.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmonez2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v1.2s, v0.2s, #0.0
; CHECK-GI-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast one <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmonez4xfloat_fast(<4 x float> %A) {
; CHECK-SD-LABEL: fcmonez4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    mvn v0.16b, v0.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmonez4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v1.4s, v0.4s, #0.0
; CHECK-GI-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast one <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmonez2xdouble_fast(<2 x double> %A) {
; CHECK-SD-LABEL: fcmonez2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    mvn v0.16b, v0.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmonez2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v1.2d, v0.2d, #0.0
; CHECK-GI-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast one <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmordz2xfloat_fast(<2 x float> %A) {
; CHECK-SD-LABEL: fcmordz2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v1.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmordz2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmeq v0.2s, v0.2s, v0.2s
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ord <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmordz4xfloat_fast(<4 x float> %A) {
; CHECK-SD-LABEL: fcmordz4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v1.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmordz4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmeq v0.4s, v0.4s, v0.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ord <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmordz2xdouble_fast(<2 x double> %A) {
; CHECK-SD-LABEL: fcmordz2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v1.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmordz2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmeq v0.2d, v0.2d, v0.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ord <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmueqz2xfloat_fast(<2 x float> %A) {
; CHECK-SD-LABEL: fcmueqz2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmueqz2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v1.2s, v0.2s, #0.0
; CHECK-GI-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-GI-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ueq <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmueqz4xfloat_fast(<4 x float> %A) {
; CHECK-SD-LABEL: fcmueqz4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmueqz4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v1.4s, v0.4s, #0.0
; CHECK-GI-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ueq <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmueqz2xdouble_fast(<2 x double> %A) {
; CHECK-SD-LABEL: fcmueqz2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v0.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmueqz2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v1.2d, v0.2d, #0.0
; CHECK-GI-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ueq <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmugez2xfloat_fast(<2 x float> %A) {
; CHECK-SD-LABEL: fcmugez2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugez2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast uge <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmugez4xfloat_fast(<4 x float> %A) {
; CHECK-SD-LABEL: fcmugez4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugez4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast uge <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmugez2xdouble_fast(<2 x double> %A) {
; CHECK-SD-LABEL: fcmugez2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugez2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast uge <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmugtz2xfloat_fast(<2 x float> %A) {
; CHECK-SD-LABEL: fcmugtz2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugtz2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmle v0.2s, v0.2s, #0.0
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ugt <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmugtz4xfloat_fast(<4 x float> %A) {
; CHECK-SD-LABEL: fcmugtz4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugtz4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmle v0.4s, v0.4s, #0.0
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ugt <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmugtz2xdouble_fast(<2 x double> %A) {
; CHECK-SD-LABEL: fcmugtz2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmgt v0.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmugtz2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmle v0.2d, v0.2d, #0.0
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ugt <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmultz2xfloat_fast(<2 x float> %A) {
; CHECK-SD-LABEL: fcmultz2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmultz2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.2s, v0.2s, #0.0
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ult <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmultz4xfloat_fast(<4 x float> %A) {
; CHECK-SD-LABEL: fcmultz4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmultz4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.4s, v0.4s, #0.0
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ult <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmultz2xdouble_fast(<2 x double> %A) {
; CHECK-SD-LABEL: fcmultz2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmultz2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmge v0.2d, v0.2d, #0.0
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ult <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

; ULE with zero = !OGT
define <2 x i32> @fcmulez2xfloat_fast(<2 x float> %A) {
; CHECK-SD-LABEL: fcmulez2xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmle v0.2s, v0.2s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmulez2xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.2s, v0.2s, #0.0
; CHECK-GI-NEXT:    mvn v0.8b, v0.8b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ule <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmulez4xfloat_fast(<4 x float> %A) {
; CHECK-SD-LABEL: fcmulez4xfloat_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmle v0.4s, v0.4s, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmulez4xfloat_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.4s, v0.4s, #0.0
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ule <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmulez2xdouble_fast(<2 x double> %A) {
; CHECK-SD-LABEL: fcmulez2xdouble_fast:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmle v0.2d, v0.2d, #0.0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmulez2xdouble_fast:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.2d, v0.2d, #0.0
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ule <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmunez2xfloat_fast(<2 x float> %A) {
; CHECK-LABEL: fcmunez2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2s, v0.2s, #0.0
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast une <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmunez4xfloat_fast(<4 x float> %A) {
; CHECK-LABEL: fcmunez4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.4s, v0.4s, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast une <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmunez2xdouble_fast(<2 x double> %A) {
; CHECK-LABEL: fcmunez2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmeq v0.2d, v0.2d, #0.0
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast une <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4
}

define <2 x i32> @fcmunoz2xfloat_fast(<2 x float> %A) {
; CHECK-LABEL: fcmunoz2xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v1.2s, v0.2s, #0.0
; CHECK-NEXT:    fcmlt v0.2s, v0.2s, #0.0
; CHECK-NEXT:    orr v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    mvn v0.8b, v0.8b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast uno <2 x float> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i32>
  ret <2 x i32> %tmp4
}

define <4 x i32> @fcmunoz4xfloat_fast(<4 x float> %A) {
; CHECK-LABEL: fcmunoz4xfloat_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v1.4s, v0.4s, #0.0
; CHECK-NEXT:    fcmlt v0.4s, v0.4s, #0.0
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast uno <4 x float> %A, zeroinitializer
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

define <2 x i64> @fcmunoz2xdouble_fast(<2 x double> %A) {
; CHECK-LABEL: fcmunoz2xdouble_fast:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcmge v1.2d, v0.2d, #0.0
; CHECK-NEXT:    fcmlt v0.2d, v0.2d, #0.0
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    mvn v0.16b, v0.16b
; CHECK-NEXT:    ret
  %tmp3 = fcmp fast uno <2 x double> %A, zeroinitializer
  %tmp4 = sext <2 x i1> %tmp3 to <2 x i64>
  ret <2 x i64> %tmp4

}

; Test SETCC fast-math flags are propagated when combining zext(setcc).
define <4 x i32> @fcmule4xfloat_fast_zext(<4 x float> %A, <4 x float> %B) {
; CHECK-SD-LABEL: fcmule4xfloat_fast_zext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    movi v2.4s, #1
; CHECK-SD-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmule4xfloat_fast_zext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    movi v2.4s, #1
; CHECK-GI-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    bic v0.16b, v2.16b, v0.16b
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ule <4 x float> %A, %B
  %tmp4 = zext <4 x i1> %tmp3 to <4 x i32>
  ret <4 x i32> %tmp4
}

; Test SETCC fast-math flags are propagated when combining aext(setcc).
define <4 x i1> @fcmule4xfloat_fast_aext(<4 x float> %A, <4 x float> %B) {
; CHECK-SD-LABEL: fcmule4xfloat_fast_aext:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmge v0.4s, v1.4s, v0.4s
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmule4xfloat_fast_aext:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmgt v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    mvn v0.16b, v0.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp fast ule <4 x float> %A, %B
  ret <4 x i1> %tmp3
}

define <4 x i64> @fcmoeq4xdouble(<4 x double> %A, <4 x double> %B) {
; CHECK-SD-LABEL: fcmoeq4xdouble:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v1.2d, v1.2d, v3.2d
; CHECK-SD-NEXT:    fcmeq v0.2d, v0.2d, v2.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmoeq4xdouble:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmeq v0.2d, v0.2d, v2.2d
; CHECK-GI-NEXT:    fcmeq v1.2d, v1.2d, v3.2d
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp oeq <4 x double> %A, %B
  %tmp4 = sext <4 x i1> %tmp3 to <4 x i64>
  ret <4 x i64> %tmp4
}

define <8 x i32> @fcmoeq8xfloat(<8 x float> %A, <8 x float> %B) {
; CHECK-SD-LABEL: fcmoeq8xfloat:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    fcmeq v1.4s, v1.4s, v3.4s
; CHECK-SD-NEXT:    fcmeq v0.4s, v0.4s, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: fcmoeq8xfloat:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    fcmeq v0.4s, v0.4s, v2.4s
; CHECK-GI-NEXT:    fcmeq v1.4s, v1.4s, v3.4s
; CHECK-GI-NEXT:    ret
  %tmp3 = fcmp oeq <8 x float> %A, %B
  %tmp4 = sext <8 x i1> %tmp3 to <8 x i32>
  ret <8 x i32> %tmp4
}
