# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -instruction-tables < %s | FileCheck %s

xgetbv

xrstor  (%rax)

xrstors (%rax)

xsave   (%rax)

xsetbv

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      100   0.33                  U     xgetbv
# CHECK-NEXT:  1      100   0.33    *      *      U     xrstor	(%rax)
# CHECK-NEXT:  1      100   0.33    *      *      U     xrstors	(%rax)
# CHECK-NEXT:  1      100   0.33    *      *      U     xsave	(%rax)
# CHECK-NEXT:  1      100   0.33    *      *      U     xsetbv

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SBDivider
# CHECK-NEXT: [1]   - SBFPDivider
# CHECK-NEXT: [2]   - SBPort0
# CHECK-NEXT: [3]   - SBPort1
# CHECK-NEXT: [4]   - SBPort4
# CHECK-NEXT: [5]   - SBPort5
# CHECK-NEXT: [6.0] - SBPort23
# CHECK-NEXT: [6.1] - SBPort23

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]
# CHECK-NEXT:  -      -     1.67   1.67    -     1.67    -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]  Instructions:
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     xgetbv
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     xrstor	(%rax)
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     xrstors	(%rax)
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     xsave	(%rax)
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     xsetbv
