function(foreachTest result list_var_1 list_var_2 list_var_3)
    set(_options MUTE)
    set(_one_value_args)
    set(_multi_value_args)
    cmake_parse_arguments(PARSE_ARGV 3 _arg "${_options}" "${_one_value_args}" "${_multi_value_args}")

    set(_has_any_output FALSE)
    list(APPEND CMAKE_MESSAGE_INDENT "| ")
    foreach(first second third IN ZIP_LISTS ${list_var_1} ${list_var_2} ${list_var_3})
        if(NOT first)
            set(first "[undefined]")
        endif()
        if(NOT second)
            set(second "[undefined]")
        endif()
        if(NOT third)
            set(third "[undefined]")
        endif()
        if(NOT _arg_MUTE)
            message(STATUS "${first}, ${second}, ${third}")
        endif()
        set(_has_any_output TRUE)
    endforeach()
    set(${result} ${_has_any_output} PARENT_SCOPE)
endfunction()

function(foreachTestDecorated list_var_1 list_var_2 list_var_3)
    list(APPEND CMAKE_MESSAGE_INDENT "  ")
    message(STATUS "Begin output")
    foreachTest(_has_any_output ${list_var_1} ${list_var_2} ${list_var_3})
    if(NOT _has_any_output)
        message(STATUS "--> empty-output <--")
    endif()
    message(STATUS "End output")
endfunction()

list(APPEND english one two three)
list(APPEND bahasa satu dua tiga)
list(APPEND russian raz dva tri)

message(STATUS "foreach(... IN ZIP_LISTS):")
foreachTestDecorated(english bahasa russian)
