/*----------------------------------------------------------------------------*/
/*  CP2K: A general program to perform molecular dynamics simulations         */
/*  Copyright 2000-2026 CP2K developers group <https://cp2k.org>              */
/*                                                                            */
/*  SPDX-License-Identifier: MIT                                              */
/*----------------------------------------------------------------------------*/

/*
 *  libgrpp - a library for the evaluation of integrals over
 *            generalized relativistic pseudopotentials.
 *
 *  Copyright (C) 2021-2023 Alexander Oleynichenko
 */

#ifndef LIBGRPP_OVERLAP_GRADIENT_H
#define LIBGRPP_OVERLAP_GRADIENT_H

#include "libgrpp_types.h"

extern void libgrpp_overlap_integrals_gradient(libgrpp_shell_t *shell_A,
                                               libgrpp_shell_t *shell_B,
                                               double *point_3d, double **grad);
extern int libgrpp_nlm_to_linear(int *nlm);

#endif // LIBGRPP_OVERLAP_GRADIENT_H
