#ifndef _CLOSURECACHE_H_INCLUDED_
#define _CLOSURECACHE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// ClosureCache.h
// -------------
// Dragon closure hash interface defintion
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: ClosureHash
// 
// Description: 
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include <lfcbase/SetT.h>

#include "LR1Element.h"


class ClosureCache {
public:
    
    ClosureCache();
    
    ClosureCache(const LR1Element& e);
    ClosureCache(const SetT<LR1Element>& closureSet, const LR1Element& e);
    ~ClosureCache();
    
    SetT<LR1Element>& getClosure() const;
    
    ClosureCache& operator = (const ClosureCache& cc);
    
    bool operator == (const ClosureCache& cc) const;
    
private:
    
    LR1Element _e;
    SetT<LR1Element> _closureSet;
    
};

#endif





