#ifndef _LR1ELEMENT_H_INCLUDED_
#define _LR1ELEMENT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR1Element.h
// ------------
// Dragon LR(1) element interface definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: LR1Element
// 
// Description: description of the LR(1) grammar element  
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>
#include "Production.h"

class LR1Element {

public:

    LR1Element();
    LR1Element(Production* pProd, int pos, Chain first);
    ~LR1Element();
    
    Chain asChain() const;
    
    bool getFollowUpSymbol(Chain& s) const;
    bool getSymbolAtPos(Chain& s) const;
    bool isProdAtPos() const;
    unsigned long getProdId() const;
    const Chain& getFirst() const;
    void setFirst(const Chain& s);

    int getPos() const;

    LR1Element jumpOver();

    LR1Element& operator = (const LR1Element& e);
    bool operator == (const LR1Element& e) const; 


private:
    

    Production* _pProd;
    int _pos;
    Chain _first;
}; 

#endif




