///////////////////////////////////////////////////////////////////////////////
//                                                         
// TransHash.cc
// ------------
// dragon transiston hash implementation
// 
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: TransHash
// 
// Description: access to dragon termianal information 
//
///////////////////////////////////////////////////////////////////////////////

#include "TransHash.h"


///////////// TransHash ////////////////

TransHash::TransHash()
{
}

TransHash::TransHash(const Chain& prod)
{
    _prod = prod;
}

TransHash::~TransHash()
{
}

void TransHash::setTransSet( SetT<Chain>& transSet)
{
    _transSet = transSet;
}

SetT<Chain>& TransHash::getTransSet()
{
    return _transSet;
}

TransHash& TransHash::operator = (const TransHash& s)
{
    _prod = s._prod;
    _transSet = s._transSet;
    return (*this);
}

bool TransHash::operator == (const TransHash& s)
{
  return (_prod == s._prod);
}






