// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals --include-generated-funcs
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature -v9.5a -target-feature -fp-armv8 -S -emit-llvm -o - %s | FileCheck %s
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -target-feature -fmv -S -emit-llvm -o - %s | FileCheck %s -check-prefix=CHECK-NOFMV

int __attribute__((target_version("rng+flagm+fp16fml"))) fmv(void) { return 1; }
int __attribute__((target_version("flagm2+sme-i16i64"))) fmv(void) { return 2; }
int __attribute__((target_version("lse+sha2"))) fmv(void) { return 3; }
int __attribute__((target_version("dotprod+ls64_accdata"))) fmv(void) { return 4; }
int __attribute__((target_version("fp16fml+memtag"))) fmv(void) { return 5; }
int __attribute__((target_version("fp+aes"))) fmv(void) { return 6; }
int __attribute__((target_version("crc+ls64_v"))) fmv(void) { return 7; }
int __attribute__((target_version("bti"))) fmv(void) { return 8; }
int __attribute__((target_version("sme2"))) fmv(void) { return 9; }
int __attribute__((target_version("default"))) fmv(void);
int __attribute__((target_version("ls64+simd"))) fmv_one(void) { return 1; }
int __attribute__((target_version("dpb"))) fmv_one(void) { return 2; }
int __attribute__((target_version("default"))) fmv_one(void);
int __attribute__((target_version("fp"))) fmv_two(void) { return 1; }
int __attribute__((target_version("simd"))) fmv_two(void) { return 2; }
int __attribute__((target_version("dgh"))) fmv_two(void) { return 3; }
int __attribute__((target_version("fp16+simd"))) fmv_two(void) { return 4; }
int __attribute__((target_version("default"))) fmv_two(void);
int foo() {
  return fmv()+fmv_one()+fmv_two();
}

inline int __attribute__((target_version("sha1+pmull+f64mm"))) fmv_inline(void) { return 1; }
inline int __attribute__((target_version("fp16+fcma+rdma+sme+ fp16 "))) fmv_inline(void) { return 2; }
inline int __attribute__((target_version("sha3+i8mm+f32mm"))) fmv_inline(void) { return 12; }
inline int __attribute__((target_version("dit+sve-ebf16"))) fmv_inline(void) { return 8; }
inline int __attribute__((target_version("dpb+rcpc2 "))) fmv_inline(void) { return 6; }
inline int __attribute__((target_version(" dpb2 + jscvt"))) fmv_inline(void) { return 7; }
inline int __attribute__((target_version("rcpc+frintts"))) fmv_inline(void) { return 3; }
inline int __attribute__((target_version("sve+sve-bf16"))) fmv_inline(void) { return 4; }
inline int __attribute__((target_version("sve2-aes+sve2-sha3"))) fmv_inline(void) { return 5; }
inline int __attribute__((target_version("sve2+sve2-pmull128+sve2-bitperm"))) fmv_inline(void) { return 9; }
inline int __attribute__((target_version("sve2-sm4+memtag2"))) fmv_inline(void) { return 10; }
inline int __attribute__((target_version("memtag3+rcpc3+mops"))) fmv_inline(void) { return 11; }
inline int __attribute__((target_version("aes+dotprod"))) fmv_inline(void) { return 13; }
inline int __attribute__((target_version("simd+fp16fml"))) fmv_inline(void) { return 14; }
inline int __attribute__((target_version("fp+sm4"))) fmv_inline(void) { return 15; }
inline int __attribute__((target_version("lse+rdm"))) fmv_inline(void) { return 16; }
inline int __attribute__((target_version("default"))) fmv_inline(void) { return 3; }

__attribute__((target_version("ls64"))) int fmv_e(void);
int fmv_e(void) { return 20; }

static __attribute__((target_version("sb"))) inline int fmv_d(void);
static __attribute__((target_version("default"))) inline int fmv_d(void);

int __attribute__((target_version("default"))) fmv_default(void) { return 111; }
int fmv_default(void);

void fmv_c(void);
void __attribute__((target_version("ssbs"))) fmv_c(void){};
void __attribute__((target_version("default"))) fmv_c(void){};

int goo() {
  fmv_inline();
  fmv_e();
  fmv_d();
  fmv_c();
  return fmv_default();
}
static inline int __attribute__((target_version("sb"))) fmv_d(void) { return 0; }
static inline int __attribute__((target_version(" default "))) fmv_d(void) { return 1; }

static void func(void) {}
inline __attribute__((target_version("default"))) void recb(void) { func(); }
inline __attribute__((target_version("default"))) void reca(void) { recb(); }
void recur(void) { reca(); }

int __attribute__((target_version("default"))) main(void) {
  recur();
  return goo();
}

typedef int (*Fptr)();
void f(Fptr);
int hoo(void) {
  f(fmv);
  Fptr fp1 = &fmv;
  Fptr fp2 = fmv;
  return fp1() + fp2();
}

// This should generate one target version but no resolver.
__attribute__((target_version("default"))) int unused_with_forward_default_decl(void);
__attribute__((target_version("mops"))) int unused_with_forward_default_decl(void) { return 0; }

// This should also generate one target version but no resolver.
extern int unused_with_implicit_extern_forward_default_decl(void);
__attribute__((target_version("dotprod")))
int unused_with_implicit_extern_forward_default_decl(void) { return 0; }

// This should also generate one target version but no resolver.
__attribute__((target_version("aes"))) int unused_with_default_decl(void) { return 0; }
__attribute__((target_version("default"))) int unused_with_default_decl(void);

// This should generate two target versions and the resolver.
__attribute__((target_version("sve"))) int unused_with_default_def(void) { return 0; }
__attribute__((target_version("default"))) int unused_with_default_def(void) { return 1; }

// This should also generate two target versions and the resolver.
__attribute__((target_version("fp16"))) int unused_with_implicit_default_def(void) { return 0; }
int unused_with_implicit_default_def(void) { return 1; }

// This should also generate two target versions and the resolver.
int unused_with_implicit_forward_default_def(void) { return 0; }
__attribute__((target_version("lse"))) int unused_with_implicit_forward_default_def(void) { return 1; }

// This should generate a target version despite the default not being declared.
__attribute__((target_version("rdm"))) int unused_without_default(void) { return 0; }

// These shouldn't generate anything.
int unused_version_declarations(void);
__attribute__((target_version("jscvt"))) int unused_version_declarations(void);
__attribute__((target_version("rdma"))) int unused_version_declarations(void);

// These should generate the default (mangled) version and the resolver.
int default_def_with_version_decls(void) { return 0; }
__attribute__((target_version("jscvt"))) int default_def_with_version_decls(void);
__attribute__((target_version("rdma"))) int default_def_with_version_decls(void);

// The following is guarded because in NOFMV we get errors for calling undeclared functions.
#ifdef __HAVE_FUNCTION_MULTI_VERSIONING
// This should generate a default declaration, two target versions and the resolver.
__attribute__((target_version("jscvt"))) int used_def_without_default_decl(void) { return 1; }
__attribute__((target_version("rdma"))) int used_def_without_default_decl(void) { return 2; }

// This should generate a default declaration and the resolver.
__attribute__((target_version("jscvt"))) int used_decl_without_default_decl(void);
__attribute__((target_version("rdma"))) int used_decl_without_default_decl(void);

int caller(void) { return used_def_without_default_decl() + used_decl_without_default_decl(); }
#endif

//.
// CHECK: @__aarch64_cpu_features = external dso_local global { i64 }
// CHECK: @fmv.ifunc = weak_odr alias i32 (), ptr @fmv
// CHECK: @fmv_one.ifunc = weak_odr alias i32 (), ptr @fmv_one
// CHECK: @fmv_two.ifunc = weak_odr alias i32 (), ptr @fmv_two
// CHECK: @fmv_e.ifunc = weak_odr alias i32 (), ptr @fmv_e
// CHECK: @fmv_d.ifunc = internal alias i32 (), ptr @fmv_d
// CHECK: @fmv_c.ifunc = weak_odr alias void (), ptr @fmv_c
// CHECK: @fmv_inline.ifunc = weak_odr alias i32 (), ptr @fmv_inline
// CHECK: @unused_with_default_def.ifunc = weak_odr alias i32 (), ptr @unused_with_default_def
// CHECK: @unused_with_implicit_default_def.ifunc = weak_odr alias i32 (), ptr @unused_with_implicit_default_def
// CHECK: @unused_with_implicit_forward_default_def.ifunc = weak_odr alias i32 (), ptr @unused_with_implicit_forward_default_def
// CHECK: @default_def_with_version_decls.ifunc = weak_odr alias i32 (), ptr @default_def_with_version_decls
// CHECK: @used_def_without_default_decl.ifunc = weak_odr alias i32 (), ptr @used_def_without_default_decl
// CHECK: @used_decl_without_default_decl.ifunc = weak_odr alias i32 (), ptr @used_decl_without_default_decl
// CHECK: @fmv = weak_odr ifunc i32 (), ptr @fmv.resolver
// CHECK: @fmv_one = weak_odr ifunc i32 (), ptr @fmv_one.resolver
// CHECK: @fmv_two = weak_odr ifunc i32 (), ptr @fmv_two.resolver
// CHECK: @fmv_inline = weak_odr ifunc i32 (), ptr @fmv_inline.resolver
// CHECK: @fmv_e = weak_odr ifunc i32 (), ptr @fmv_e.resolver
// CHECK: @fmv_d = internal ifunc i32 (), ptr @fmv_d.resolver
// CHECK: @fmv_c = weak_odr ifunc void (), ptr @fmv_c.resolver
// CHECK: @used_def_without_default_decl = weak_odr ifunc i32 (), ptr @used_def_without_default_decl.resolver
// CHECK: @used_decl_without_default_decl = weak_odr ifunc i32 (), ptr @used_decl_without_default_decl.resolver
// CHECK: @unused_with_default_def = weak_odr ifunc i32 (), ptr @unused_with_default_def.resolver
// CHECK: @unused_with_implicit_default_def = weak_odr ifunc i32 (), ptr @unused_with_implicit_default_def.resolver
// CHECK: @unused_with_implicit_forward_default_def = weak_odr ifunc i32 (), ptr @unused_with_implicit_forward_default_def.resolver
// CHECK: @default_def_with_version_decls = weak_odr ifunc i32 (), ptr @default_def_with_version_decls.resolver
//.
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._MflagmMfp16fmlMrng
// CHECK-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._Mflagm2Msme-i16i64
// CHECK-SAME: () #[[ATTR1:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 2
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._MlseMsha2
// CHECK-SAME: () #[[ATTR2:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 3
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._MdotprodMls64_accdata
// CHECK-SAME: () #[[ATTR3:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 4
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._Mfp16fmlMmemtag
// CHECK-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 5
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._MaesMfp
// CHECK-SAME: () #[[ATTR5:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 6
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._McrcMls64_v
// CHECK-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 7
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._Mbti
// CHECK-SAME: () #[[ATTR7:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 8
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv._Msme2
// CHECK-SAME: () #[[ATTR8:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 9
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_one._Mls64Msimd
// CHECK-SAME: () #[[ATTR5]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_one._Mdpb
// CHECK-SAME: () #[[ATTR10:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 2
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_two._Mfp
// CHECK-SAME: () #[[ATTR5]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_two._Msimd
// CHECK-SAME: () #[[ATTR5]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 2
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_two._Mdgh
// CHECK-SAME: () #[[ATTR11:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 3
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_two._Mfp16Msimd
// CHECK-SAME: () #[[ATTR12:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 4
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@foo
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CALL:%.*]] = call i32 @fmv()
// CHECK-NEXT:    [[CALL1:%.*]] = call i32 @fmv_one()
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL]], [[CALL1]]
// CHECK-NEXT:    [[CALL2:%.*]] = call i32 @fmv_two()
// CHECK-NEXT:    [[ADD3:%.*]] = add nsw i32 [[ADD]], [[CALL2]]
// CHECK-NEXT:    ret i32 [[ADD3]]
//
//
// CHECK-LABEL: define {{[^@]+}}@fmv.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 11
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 11
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @fmv._MflagmMfp16fmlMrng
// CHECK:       resolver_else:
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 72057594037927940
// CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[TMP5]], 72057594037927940
// CHECK-NEXT:    [[TMP7:%.*]] = and i1 true, [[TMP6]]
// CHECK-NEXT:    br i1 [[TMP7]], label [[RESOLVER_RETURN1:%.*]], label [[RESOLVER_ELSE2:%.*]]
// CHECK:       resolver_return1:
// CHECK-NEXT:    ret ptr @fmv._Mflagm2Msme-i16i64
// CHECK:       resolver_else2:
// CHECK-NEXT:    [[TMP8:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = and i64 [[TMP8]], 9007199254741008
// CHECK-NEXT:    [[TMP10:%.*]] = icmp eq i64 [[TMP9]], 9007199254741008
// CHECK-NEXT:    [[TMP11:%.*]] = and i1 true, [[TMP10]]
// CHECK-NEXT:    br i1 [[TMP11]], label [[RESOLVER_RETURN3:%.*]], label [[RESOLVER_ELSE4:%.*]]
// CHECK:       resolver_return3:
// CHECK-NEXT:    ret ptr @fmv._MdotprodMls64_accdata
// CHECK:       resolver_else4:
// CHECK-NEXT:    [[TMP12:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = and i64 [[TMP12]], 4503599627371520
// CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[TMP13]], 4503599627371520
// CHECK-NEXT:    [[TMP15:%.*]] = and i1 true, [[TMP14]]
// CHECK-NEXT:    br i1 [[TMP15]], label [[RESOLVER_RETURN5:%.*]], label [[RESOLVER_ELSE6:%.*]]
// CHECK:       resolver_return5:
// CHECK-NEXT:    ret ptr @fmv._McrcMls64_v
// CHECK:       resolver_else6:
// CHECK-NEXT:    [[TMP16:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = and i64 [[TMP16]], 8796093022216
// CHECK-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[TMP17]], 8796093022216
// CHECK-NEXT:    [[TMP19:%.*]] = and i1 true, [[TMP18]]
// CHECK-NEXT:    br i1 [[TMP19]], label [[RESOLVER_RETURN7:%.*]], label [[RESOLVER_ELSE8:%.*]]
// CHECK:       resolver_return7:
// CHECK-NEXT:    ret ptr @fmv._Mfp16fmlMmemtag
// CHECK:       resolver_else8:
// CHECK-NEXT:    [[TMP20:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = and i64 [[TMP20]], 16640
// CHECK-NEXT:    [[TMP22:%.*]] = icmp eq i64 [[TMP21]], 16640
// CHECK-NEXT:    [[TMP23:%.*]] = and i1 true, [[TMP22]]
// CHECK-NEXT:    br i1 [[TMP23]], label [[RESOLVER_RETURN9:%.*]], label [[RESOLVER_ELSE10:%.*]]
// CHECK:       resolver_return9:
// CHECK-NEXT:    ret ptr @fmv._MaesMfp
// CHECK:       resolver_else10:
// CHECK-NEXT:    [[TMP24:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = and i64 [[TMP24]], 4224
// CHECK-NEXT:    [[TMP26:%.*]] = icmp eq i64 [[TMP25]], 4224
// CHECK-NEXT:    [[TMP27:%.*]] = and i1 true, [[TMP26]]
// CHECK-NEXT:    br i1 [[TMP27]], label [[RESOLVER_RETURN11:%.*]], label [[RESOLVER_ELSE12:%.*]]
// CHECK:       resolver_return11:
// CHECK-NEXT:    ret ptr @fmv._MlseMsha2
// CHECK:       resolver_else12:
// CHECK-NEXT:    [[TMP28:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = and i64 [[TMP28]], 144115188075855872
// CHECK-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[TMP29]], 144115188075855872
// CHECK-NEXT:    [[TMP31:%.*]] = and i1 true, [[TMP30]]
// CHECK-NEXT:    br i1 [[TMP31]], label [[RESOLVER_RETURN13:%.*]], label [[RESOLVER_ELSE14:%.*]]
// CHECK:       resolver_return13:
// CHECK-NEXT:    ret ptr @fmv._Msme2
// CHECK:       resolver_else14:
// CHECK-NEXT:    [[TMP32:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = and i64 [[TMP32]], 1125899906842624
// CHECK-NEXT:    [[TMP34:%.*]] = icmp eq i64 [[TMP33]], 1125899906842624
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 true, [[TMP34]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[RESOLVER_RETURN15:%.*]], label [[RESOLVER_ELSE16:%.*]]
// CHECK:       resolver_return15:
// CHECK-NEXT:    ret ptr @fmv._Mbti
// CHECK:       resolver_else16:
// CHECK-NEXT:    ret ptr @fmv.default
//
//
// CHECK-LABEL: define {{[^@]+}}@fmv_one.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 2251799813685760
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 2251799813685760
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @fmv_one._Mls64Msimd
// CHECK:       resolver_else:
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 262144
// CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[TMP5]], 262144
// CHECK-NEXT:    [[TMP7:%.*]] = and i1 true, [[TMP6]]
// CHECK-NEXT:    br i1 [[TMP7]], label [[RESOLVER_RETURN1:%.*]], label [[RESOLVER_ELSE2:%.*]]
// CHECK:       resolver_return1:
// CHECK-NEXT:    ret ptr @fmv_one._Mdpb
// CHECK:       resolver_else2:
// CHECK-NEXT:    ret ptr @fmv_one.default
//
//
// CHECK-LABEL: define {{[^@]+}}@fmv_two.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 66048
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 66048
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @fmv_two._Mfp16Msimd
// CHECK:       resolver_else:
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 33554432
// CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[TMP5]], 33554432
// CHECK-NEXT:    [[TMP7:%.*]] = and i1 true, [[TMP6]]
// CHECK-NEXT:    br i1 [[TMP7]], label [[RESOLVER_RETURN1:%.*]], label [[RESOLVER_ELSE2:%.*]]
// CHECK:       resolver_return1:
// CHECK-NEXT:    ret ptr @fmv_two._Mdgh
// CHECK:       resolver_else2:
// CHECK-NEXT:    [[TMP8:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = and i64 [[TMP8]], 512
// CHECK-NEXT:    [[TMP10:%.*]] = icmp eq i64 [[TMP9]], 512
// CHECK-NEXT:    [[TMP11:%.*]] = and i1 true, [[TMP10]]
// CHECK-NEXT:    br i1 [[TMP11]], label [[RESOLVER_RETURN3:%.*]], label [[RESOLVER_ELSE4:%.*]]
// CHECK:       resolver_return3:
// CHECK-NEXT:    ret ptr @fmv_two._Msimd
// CHECK:       resolver_else4:
// CHECK-NEXT:    [[TMP12:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = and i64 [[TMP12]], 256
// CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[TMP13]], 256
// CHECK-NEXT:    [[TMP15:%.*]] = and i1 true, [[TMP14]]
// CHECK-NEXT:    br i1 [[TMP15]], label [[RESOLVER_RETURN5:%.*]], label [[RESOLVER_ELSE6:%.*]]
// CHECK:       resolver_return5:
// CHECK-NEXT:    ret ptr @fmv_two._Mfp
// CHECK:       resolver_else6:
// CHECK-NEXT:    ret ptr @fmv_two.default
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_e.default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 20
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_d._Msb
// CHECK-SAME: () #[[ATTR13:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_d.default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 111
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_c._Mssbs
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_c.default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@goo
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CALL:%.*]] = call i32 @fmv_inline()
// CHECK-NEXT:    [[CALL1:%.*]] = call i32 @fmv_e()
// CHECK-NEXT:    [[CALL2:%.*]] = call i32 @fmv_d()
// CHECK-NEXT:    call void @fmv_c()
// CHECK-NEXT:    [[CALL3:%.*]] = call i32 @fmv_default()
// CHECK-NEXT:    ret i32 [[CALL3]]
//
//
// CHECK-LABEL: define {{[^@]+}}@fmv_inline.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 4398048673856
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 4398048673856
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @fmv_inline._MfcmaMfp16MrdmMsme
// CHECK:       resolver_else:
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 864726312827224064
// CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[TMP5]], 864726312827224064
// CHECK-NEXT:    [[TMP7:%.*]] = and i1 true, [[TMP6]]
// CHECK-NEXT:    br i1 [[TMP7]], label [[RESOLVER_RETURN1:%.*]], label [[RESOLVER_ELSE2:%.*]]
// CHECK:       resolver_return1:
// CHECK-NEXT:    ret ptr @fmv_inline._Mmemtag3MmopsMrcpc3
// CHECK:       resolver_else2:
// CHECK-NEXT:    [[TMP8:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP9:%.*]] = and i64 [[TMP8]], 893353197568
// CHECK-NEXT:    [[TMP10:%.*]] = icmp eq i64 [[TMP9]], 893353197568
// CHECK-NEXT:    [[TMP11:%.*]] = and i1 true, [[TMP10]]
// CHECK-NEXT:    br i1 [[TMP11]], label [[RESOLVER_RETURN3:%.*]], label [[RESOLVER_ELSE4:%.*]]
// CHECK:       resolver_return3:
// CHECK-NEXT:    ret ptr @fmv_inline._Msve2Msve2-bitpermMsve2-pmull128
// CHECK:       resolver_else4:
// CHECK-NEXT:    [[TMP12:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP13:%.*]] = and i64 [[TMP12]], 34359773184
// CHECK-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[TMP13]], 34359773184
// CHECK-NEXT:    [[TMP15:%.*]] = and i1 true, [[TMP14]]
// CHECK-NEXT:    br i1 [[TMP15]], label [[RESOLVER_RETURN5:%.*]], label [[RESOLVER_ELSE6:%.*]]
// CHECK:       resolver_return5:
// CHECK-NEXT:    ret ptr @fmv_inline._Mf64mmMpmullMsha1
// CHECK:       resolver_else6:
// CHECK-NEXT:    [[TMP16:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP17:%.*]] = and i64 [[TMP16]], 17246986240
// CHECK-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[TMP17]], 17246986240
// CHECK-NEXT:    [[TMP19:%.*]] = and i1 true, [[TMP18]]
// CHECK-NEXT:    br i1 [[TMP19]], label [[RESOLVER_RETURN7:%.*]], label [[RESOLVER_ELSE8:%.*]]
// CHECK:       resolver_return7:
// CHECK-NEXT:    ret ptr @fmv_inline._Mf32mmMi8mmMsha3
// CHECK:       resolver_else8:
// CHECK-NEXT:    [[TMP20:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP21:%.*]] = and i64 [[TMP20]], 19791209299968
// CHECK-NEXT:    [[TMP22:%.*]] = icmp eq i64 [[TMP21]], 19791209299968
// CHECK-NEXT:    [[TMP23:%.*]] = and i1 true, [[TMP22]]
// CHECK-NEXT:    br i1 [[TMP23]], label [[RESOLVER_RETURN9:%.*]], label [[RESOLVER_ELSE10:%.*]]
// CHECK:       resolver_return9:
// CHECK-NEXT:    ret ptr @fmv_inline._Mmemtag2Msve2-sm4
// CHECK:       resolver_else10:
// CHECK-NEXT:    [[TMP24:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP25:%.*]] = and i64 [[TMP24]], 1236950581248
// CHECK-NEXT:    [[TMP26:%.*]] = icmp eq i64 [[TMP25]], 1236950581248
// CHECK-NEXT:    [[TMP27:%.*]] = and i1 true, [[TMP26]]
// CHECK-NEXT:    br i1 [[TMP27]], label [[RESOLVER_RETURN11:%.*]], label [[RESOLVER_ELSE12:%.*]]
// CHECK:       resolver_return11:
// CHECK-NEXT:    ret ptr @fmv_inline._Msve2-aesMsve2-sha3
// CHECK:       resolver_else12:
// CHECK-NEXT:    [[TMP28:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP29:%.*]] = and i64 [[TMP28]], 4295098368
// CHECK-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[TMP29]], 4295098368
// CHECK-NEXT:    [[TMP31:%.*]] = and i1 true, [[TMP30]]
// CHECK-NEXT:    br i1 [[TMP31]], label [[RESOLVER_RETURN13:%.*]], label [[RESOLVER_ELSE14:%.*]]
// CHECK:       resolver_return13:
// CHECK-NEXT:    ret ptr @fmv_inline._MditMsve-ebf16
// CHECK:       resolver_else14:
// CHECK-NEXT:    [[TMP32:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP33:%.*]] = and i64 [[TMP32]], 3221225472
// CHECK-NEXT:    [[TMP34:%.*]] = icmp eq i64 [[TMP33]], 3221225472
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 true, [[TMP34]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[RESOLVER_RETURN15:%.*]], label [[RESOLVER_ELSE16:%.*]]
// CHECK:       resolver_return15:
// CHECK-NEXT:    ret ptr @fmv_inline._MsveMsve-bf16
// CHECK:       resolver_else16:
// CHECK-NEXT:    [[TMP36:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP37:%.*]] = and i64 [[TMP36]], 20971520
// CHECK-NEXT:    [[TMP38:%.*]] = icmp eq i64 [[TMP37]], 20971520
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 true, [[TMP38]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[RESOLVER_RETURN17:%.*]], label [[RESOLVER_ELSE18:%.*]]
// CHECK:       resolver_return17:
// CHECK-NEXT:    ret ptr @fmv_inline._MfrinttsMrcpc
// CHECK:       resolver_else18:
// CHECK-NEXT:    [[TMP40:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP41:%.*]] = and i64 [[TMP40]], 8650752
// CHECK-NEXT:    [[TMP42:%.*]] = icmp eq i64 [[TMP41]], 8650752
// CHECK-NEXT:    [[TMP43:%.*]] = and i1 true, [[TMP42]]
// CHECK-NEXT:    br i1 [[TMP43]], label [[RESOLVER_RETURN19:%.*]], label [[RESOLVER_ELSE20:%.*]]
// CHECK:       resolver_return19:
// CHECK-NEXT:    ret ptr @fmv_inline._MdpbMrcpc2
// CHECK:       resolver_else20:
// CHECK-NEXT:    [[TMP44:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP45:%.*]] = and i64 [[TMP44]], 1572864
// CHECK-NEXT:    [[TMP46:%.*]] = icmp eq i64 [[TMP45]], 1572864
// CHECK-NEXT:    [[TMP47:%.*]] = and i1 true, [[TMP46]]
// CHECK-NEXT:    br i1 [[TMP47]], label [[RESOLVER_RETURN21:%.*]], label [[RESOLVER_ELSE22:%.*]]
// CHECK:       resolver_return21:
// CHECK-NEXT:    ret ptr @fmv_inline._Mdpb2Mjscvt
// CHECK:       resolver_else22:
// CHECK-NEXT:    [[TMP48:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP49:%.*]] = and i64 [[TMP48]], 520
// CHECK-NEXT:    [[TMP50:%.*]] = icmp eq i64 [[TMP49]], 520
// CHECK-NEXT:    [[TMP51:%.*]] = and i1 true, [[TMP50]]
// CHECK-NEXT:    br i1 [[TMP51]], label [[RESOLVER_RETURN23:%.*]], label [[RESOLVER_ELSE24:%.*]]
// CHECK:       resolver_return23:
// CHECK-NEXT:    ret ptr @fmv_inline._Mfp16fmlMsimd
// CHECK:       resolver_else24:
// CHECK-NEXT:    [[TMP52:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP53:%.*]] = and i64 [[TMP52]], 16400
// CHECK-NEXT:    [[TMP54:%.*]] = icmp eq i64 [[TMP53]], 16400
// CHECK-NEXT:    [[TMP55:%.*]] = and i1 true, [[TMP54]]
// CHECK-NEXT:    br i1 [[TMP55]], label [[RESOLVER_RETURN25:%.*]], label [[RESOLVER_ELSE26:%.*]]
// CHECK:       resolver_return25:
// CHECK-NEXT:    ret ptr @fmv_inline._MaesMdotprod
// CHECK:       resolver_else26:
// CHECK-NEXT:    [[TMP56:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP57:%.*]] = and i64 [[TMP56]], 192
// CHECK-NEXT:    [[TMP58:%.*]] = icmp eq i64 [[TMP57]], 192
// CHECK-NEXT:    [[TMP59:%.*]] = and i1 true, [[TMP58]]
// CHECK-NEXT:    br i1 [[TMP59]], label [[RESOLVER_RETURN27:%.*]], label [[RESOLVER_ELSE28:%.*]]
// CHECK:       resolver_return27:
// CHECK-NEXT:    ret ptr @fmv_inline._MlseMrdm
// CHECK:       resolver_else28:
// CHECK-NEXT:    [[TMP60:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP61:%.*]] = and i64 [[TMP60]], 288
// CHECK-NEXT:    [[TMP62:%.*]] = icmp eq i64 [[TMP61]], 288
// CHECK-NEXT:    [[TMP63:%.*]] = and i1 true, [[TMP62]]
// CHECK-NEXT:    br i1 [[TMP63]], label [[RESOLVER_RETURN29:%.*]], label [[RESOLVER_ELSE30:%.*]]
// CHECK:       resolver_return29:
// CHECK-NEXT:    ret ptr @fmv_inline._MfpMsm4
// CHECK:       resolver_else30:
// CHECK-NEXT:    ret ptr @fmv_inline.default
//
//
// CHECK-LABEL: define {{[^@]+}}@fmv_e.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 2251799813685248
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 2251799813685248
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @fmv_e._Mls64
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @fmv_e.default
//
//
// CHECK-LABEL: define {{[^@]+}}@fmv_d.resolver() {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 70368744177664
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 70368744177664
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @fmv_d._Msb
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @fmv_d.default
//
//
// CHECK-LABEL: define {{[^@]+}}@fmv_c.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 281474976710656
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 281474976710656
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @fmv_c._Mssbs
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @fmv_c.default
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@recur
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @reca()
// CHECK-NEXT:    ret void
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@main
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-NEXT:    call void @recur()
// CHECK-NEXT:    [[CALL:%.*]] = call i32 @goo()
// CHECK-NEXT:    ret i32 [[CALL]]
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@hoo
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[FP1:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    [[FP2:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    call void @f(ptr noundef @fmv)
// CHECK-NEXT:    store ptr @fmv, ptr [[FP1]], align 8
// CHECK-NEXT:    store ptr @fmv, ptr [[FP2]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[FP1]], align 8
// CHECK-NEXT:    [[CALL:%.*]] = call i32 [[TMP0]]()
// CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[FP2]], align 8
// CHECK-NEXT:    [[CALL1:%.*]] = call i32 [[TMP1]]()
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL]], [[CALL1]]
// CHECK-NEXT:    ret i32 [[ADD]]
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_forward_default_decl._Mmops
// CHECK-SAME: () #[[ATTR14:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_implicit_extern_forward_default_decl._Mdotprod
// CHECK-SAME: () #[[ATTR15:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_default_decl._Maes
// CHECK-SAME: () #[[ATTR5]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_default_def._Msve
// CHECK-SAME: () #[[ATTR16:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_default_def.default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_implicit_default_def._Mfp16
// CHECK-SAME: () #[[ATTR12]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_implicit_default_def.default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_implicit_forward_default_def.default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_with_implicit_forward_default_def._Mlse
// CHECK-SAME: () #[[ATTR17:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@unused_without_default._Mrdm
// CHECK-SAME: () #[[ATTR18:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@default_def_with_version_decls.default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 0
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_def_without_default_decl._Mjscvt
// CHECK-SAME: () #[[ATTR21:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@used_def_without_default_decl._Mrdm
// CHECK-SAME: () #[[ATTR18]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 2
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@caller
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[CALL:%.*]] = call i32 @used_def_without_default_decl()
// CHECK-NEXT:    [[CALL1:%.*]] = call i32 @used_decl_without_default_decl()
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL]], [[CALL1]]
// CHECK-NEXT:    ret i32 [[ADD]]
//
//
// CHECK-LABEL: define {{[^@]+}}@used_def_without_default_decl.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 1048576
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 1048576
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @used_def_without_default_decl._Mjscvt
// CHECK:       resolver_else:
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 64
// CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[TMP5]], 64
// CHECK-NEXT:    [[TMP7:%.*]] = and i1 true, [[TMP6]]
// CHECK-NEXT:    br i1 [[TMP7]], label [[RESOLVER_RETURN1:%.*]], label [[RESOLVER_ELSE2:%.*]]
// CHECK:       resolver_return1:
// CHECK-NEXT:    ret ptr @used_def_without_default_decl._Mrdm
// CHECK:       resolver_else2:
// CHECK-NEXT:    ret ptr @used_def_without_default_decl.default
//
//
// CHECK-LABEL: define {{[^@]+}}@used_decl_without_default_decl.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 1048576
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 1048576
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @used_decl_without_default_decl._Mjscvt
// CHECK:       resolver_else:
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 64
// CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[TMP5]], 64
// CHECK-NEXT:    [[TMP7:%.*]] = and i1 true, [[TMP6]]
// CHECK-NEXT:    br i1 [[TMP7]], label [[RESOLVER_RETURN1:%.*]], label [[RESOLVER_ELSE2:%.*]]
// CHECK:       resolver_return1:
// CHECK-NEXT:    ret ptr @used_decl_without_default_decl._Mrdm
// CHECK:       resolver_else2:
// CHECK-NEXT:    ret ptr @used_decl_without_default_decl.default
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._Mf64mmMpmullMsha1
// CHECK-SAME: () #[[ATTR22:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 1
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._MfcmaMfp16MrdmMsme
// CHECK-SAME: () #[[ATTR23:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 2
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._Mf32mmMi8mmMsha3
// CHECK-SAME: () #[[ATTR24:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 12
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._MditMsve-ebf16
// CHECK-SAME: () #[[ATTR25:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 8
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._MdpbMrcpc2
// CHECK-SAME: () #[[ATTR26:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 6
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._Mdpb2Mjscvt
// CHECK-SAME: () #[[ATTR27:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 7
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._MfrinttsMrcpc
// CHECK-SAME: () #[[ATTR28:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 3
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._MsveMsve-bf16
// CHECK-SAME: () #[[ATTR29:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 4
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._Msve2-aesMsve2-sha3
// CHECK-SAME: () #[[ATTR30:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 5
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._Msve2Msve2-bitpermMsve2-pmull128
// CHECK-SAME: () #[[ATTR31:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 9
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._Mmemtag2Msve2-sm4
// CHECK-SAME: () #[[ATTR32:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 10
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._Mmemtag3MmopsMrcpc3
// CHECK-SAME: () #[[ATTR33:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 11
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._MaesMdotprod
// CHECK-SAME: () #[[ATTR15]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 13
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._Mfp16fmlMsimd
// CHECK-SAME: () #[[ATTR4]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 14
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._MfpMsm4
// CHECK-SAME: () #[[ATTR34:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 15
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline._MlseMrdm
// CHECK-SAME: () #[[ATTR35:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 16
//
//
// CHECK: Function Attrs: noinline nounwind optnone
// CHECK-LABEL: define {{[^@]+}}@fmv_inline.default
// CHECK-SAME: () #[[ATTR11]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i32 3
//
//
// CHECK-LABEL: define {{[^@]+}}@unused_with_default_def.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 1073741824
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 1073741824
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @unused_with_default_def._Msve
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @unused_with_default_def.default
//
//
// CHECK-LABEL: define {{[^@]+}}@unused_with_implicit_default_def.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 65536
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 65536
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @unused_with_implicit_default_def._Mfp16
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @unused_with_implicit_default_def.default
//
//
// CHECK-LABEL: define {{[^@]+}}@unused_with_implicit_forward_default_def.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 128
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 128
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @unused_with_implicit_forward_default_def._Mlse
// CHECK:       resolver_else:
// CHECK-NEXT:    ret ptr @unused_with_implicit_forward_default_def.default
//
//
// CHECK-LABEL: define {{[^@]+}}@default_def_with_version_decls.resolver() comdat {
// CHECK-NEXT:  resolver_entry:
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 1048576
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 1048576
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label [[RESOLVER_RETURN:%.*]], label [[RESOLVER_ELSE:%.*]]
// CHECK:       resolver_return:
// CHECK-NEXT:    ret ptr @default_def_with_version_decls._Mjscvt
// CHECK:       resolver_else:
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 64
// CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[TMP5]], 64
// CHECK-NEXT:    [[TMP7:%.*]] = and i1 true, [[TMP6]]
// CHECK-NEXT:    br i1 [[TMP7]], label [[RESOLVER_RETURN1:%.*]], label [[RESOLVER_ELSE2:%.*]]
// CHECK:       resolver_return1:
// CHECK-NEXT:    ret ptr @default_def_with_version_decls._Mrdm
// CHECK:       resolver_else2:
// CHECK-NEXT:    ret ptr @default_def_with_version_decls.default
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@foo
// CHECK-NOFMV-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    [[CALL:%.*]] = call i32 @fmv()
// CHECK-NOFMV-NEXT:    [[CALL1:%.*]] = call i32 @fmv_one()
// CHECK-NOFMV-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL]], [[CALL1]]
// CHECK-NOFMV-NEXT:    [[CALL2:%.*]] = call i32 @fmv_two()
// CHECK-NOFMV-NEXT:    [[ADD3:%.*]] = add nsw i32 [[ADD]], [[CALL2]]
// CHECK-NOFMV-NEXT:    ret i32 [[ADD3]]
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@fmv_e
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    ret i32 20
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@fmv_default
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    ret i32 111
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@fmv_c
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    ret void
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@goo
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    [[CALL:%.*]] = call i32 @fmv_inline()
// CHECK-NOFMV-NEXT:    [[CALL1:%.*]] = call i32 @fmv_e()
// CHECK-NOFMV-NEXT:    [[CALL2:%.*]] = call i32 @fmv_d()
// CHECK-NOFMV-NEXT:    call void @fmv_c()
// CHECK-NOFMV-NEXT:    [[CALL3:%.*]] = call i32 @fmv_default()
// CHECK-NOFMV-NEXT:    ret i32 [[CALL3]]
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@fmv_d
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    ret i32 1
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@recur
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    call void @reca()
// CHECK-NOFMV-NEXT:    ret void
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@main
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK-NOFMV-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK-NOFMV-NEXT:    call void @recur()
// CHECK-NOFMV-NEXT:    [[CALL:%.*]] = call i32 @goo()
// CHECK-NOFMV-NEXT:    ret i32 [[CALL]]
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@hoo
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    [[FP1:%.*]] = alloca ptr, align 8
// CHECK-NOFMV-NEXT:    [[FP2:%.*]] = alloca ptr, align 8
// CHECK-NOFMV-NEXT:    call void @f(ptr noundef @fmv)
// CHECK-NOFMV-NEXT:    store ptr @fmv, ptr [[FP1]], align 8
// CHECK-NOFMV-NEXT:    store ptr @fmv, ptr [[FP2]], align 8
// CHECK-NOFMV-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[FP1]], align 8
// CHECK-NOFMV-NEXT:    [[CALL:%.*]] = call i32 [[TMP0]]()
// CHECK-NOFMV-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[FP2]], align 8
// CHECK-NOFMV-NEXT:    [[CALL1:%.*]] = call i32 [[TMP1]]()
// CHECK-NOFMV-NEXT:    [[ADD:%.*]] = add nsw i32 [[CALL]], [[CALL1]]
// CHECK-NOFMV-NEXT:    ret i32 [[ADD]]
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@unused_with_default_def
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    ret i32 1
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@unused_with_implicit_default_def
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    ret i32 1
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@unused_with_implicit_forward_default_def
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    ret i32 0
//
//
// CHECK-NOFMV: Function Attrs: noinline nounwind optnone
// CHECK-NOFMV-LABEL: define {{[^@]+}}@default_def_with_version_decls
// CHECK-NOFMV-SAME: () #[[ATTR0]] {
// CHECK-NOFMV-NEXT:  entry:
// CHECK-NOFMV-NEXT:    ret i32 0
//
//.
// CHECK: attributes #[[ATTR0]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+flagm,+fp16fml,+fullfp16,+neon,+rand,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR1]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+altnzcv,+bf16,+flagm,+sme,+sme-i16i64,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR2]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+lse,+neon,+sha2,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR3]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+dotprod,+ls64,+neon,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR4]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+fp16fml,+fullfp16,+neon,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR5]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+neon,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR6]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+crc,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR7]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+bti,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR8]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+bf16,+sme,+sme2,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR9:[0-9]+]] = { "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR10]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+ccpp,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR11]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR12]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+fullfp16,+neon,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR13]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+sb,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR14]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+mops,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR15]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+dotprod,+neon,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR16]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+fullfp16,+neon,+sve,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR17]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+lse,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR18]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+neon,+rdm,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR19:[0-9]+]] = { "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+jsconv,+neon,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR20:[0-9]+]] = { "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+neon,+rdm,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR21]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+jsconv,+neon,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR22]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+aes,+f64mm,+fullfp16,+neon,+sve,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR23]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+bf16,+complxnum,+fullfp16,+neon,+rdm,+sme,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR24]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+f32mm,+fullfp16,+i8mm,+neon,+sha2,+sha3,+sve,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR25]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+bf16,+dit,+fullfp16,+neon,+sve,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR26]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+ccpp,+rcpc,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR27]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+ccdp,+ccpp,+jsconv,+neon,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR28]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+fptoint,+rcpc,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR29]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+bf16,+fullfp16,+neon,+sve,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR30]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+fullfp16,+neon,+sve,+sve2,+sve2-aes,+sve2-sha3,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR31]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+fullfp16,+neon,+sve,+sve2,+sve2-aes,+sve2-bitperm,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR32]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+fullfp16,+mte,+neon,+sve,+sve2,+sve2-sm4,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR33]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+mops,+mte,+rcpc,+rcpc3,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR34]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+neon,+sm4,-fp-armv8,-v9.5a" }
// CHECK: attributes #[[ATTR35]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="+lse,+neon,+rdm,-fp-armv8,-v9.5a" }
//.
// CHECK-NOFMV: attributes #[[ATTR0]] = { noinline nounwind optnone "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="-fmv" }
// CHECK-NOFMV: attributes #[[ATTR1:[0-9]+]] = { "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-features"="-fmv" }
//.
// CHECK: [[META0:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
// CHECK: [[META1:![0-9]+]] = !{!"{{.*}}clang version {{.*}}"}
//.
// CHECK-NOFMV: [[META0:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
// CHECK-NOFMV: [[META1:![0-9]+]] = !{!"{{.*}}clang version {{.*}}"}
//.
