;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; NOTE: This test was ported using port_passes_tests_to_lit.py and could be cleaned up.

;; RUN: foreach %s %t wasm-opt --local-cse -all -S -o - | filecheck %s

(module
 ;; CHECK:      (type $func (func))
 (type $func (func))
 ;; CHECK:      (type $cont (cont $func))
 (type $cont (cont $func))

  ;; CHECK:      (type $func-i32 (func (param i32)))
  (type $func-i32 (func (param i32)))
  ;; CHECK:      (type $cont-i32 (cont $func-i32))
  (type $cont-i32 (cont $func-i32))

 ;; CHECK:      (type $4 (func (param (ref $cont-i32))))

 ;; CHECK:      (elem declare func $cont.new)

 ;; CHECK:      (func $cont.new (type $func)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (cont.new $cont
 ;; CHECK-NEXT:    (ref.func $cont.new)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (cont.new $cont
 ;; CHECK-NEXT:    (ref.func $cont.new)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $cont.new (type $func)
  ;; We cannot CSE here, as each of these emits a unique continuation.
  (drop
   (cont.new $cont
    (ref.func $cont.new)
   )
  )
  (drop
   (cont.new $cont
    (ref.func $cont.new)
   )
  )
 )

 ;; CHECK:      (func $cont.bind (type $4) (param $cont-i32 (ref $cont-i32))
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (cont.bind $cont-i32 $cont
 ;; CHECK-NEXT:    (i32.const 42)
 ;; CHECK-NEXT:    (local.get $cont-i32)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (cont.bind $cont-i32 $cont
 ;; CHECK-NEXT:    (i32.const 42)
 ;; CHECK-NEXT:    (local.get $cont-i32)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $cont.bind (param $cont-i32 (ref $cont-i32))
  ;; We cannot optimize here: Each of these has a side effect of modifying the
  ;; continuation they were given, as it will trap if resumed, and in fact the
  ;; second cont.bind here should trap, which we should not remove.
  (drop
   (cont.bind $cont-i32 $cont
    (i32.const 42)
    (local.get $cont-i32)
   )
  )
  (drop
   (cont.bind $cont-i32 $cont
    (i32.const 42)
    (local.get $cont-i32)
   )
  )
 )
)

