#define len_trim__(cad,len) ({                           integer _r=0,i;                           for(i=0; i<(len) && (cad)[i]; i++)                             if((cad)[i] != ' ') _r=i;                           _r+1; })
#define ceiling_(a) (myceil(*(a)))
#define myceil(a) (sizeof(a) == sizeof(float) ? ceilf(a) : ceil(a))
#include <math.h>
/*  -- translated by f2c (version 20200916).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#define __LAPACK_PRECISION_QUAD
#include "f2c.h"

/* > \brief \b ZDROT */

/*  =========== DOCUMENTATION =========== */

/* Online html documentation available at */
/*            http://www.netlib.org/lapack/explore-html/ */

/*  Definition: */
/*  =========== */

/*       SUBROUTINE ZDROT( N, CX, INCX, CY, INCY, C, S ) */

/*       INTEGER            INCX, INCY, N */
/*       DOUBLE PRECISION   C, S */
/*       COMPLEX*16         CX( * ), CY( * ) */


/* > \par Purpose: */
/*  ============= */
/* > */
/* > \verbatim */
/* > */
/* > Applies a plane rotation, where the M(cos) and M(sin) (c and s) are doublereal */
/* > and the vectors cx and cy are complex. */
/* > jack dongarra, linpack, 3/11/78. */
/* > \endverbatim */

/*  Arguments: */
/*  ========== */

/* > \param[in] N */
/* > \verbatim */
/* >          N is INTEGER */
/* >           On entry, N specifies the order of the vectors cx and cy. */
/* >           N must be at least zero. */
/* > \endverbatim */
/* > */
/* > \param[in,out] CX */
/* > \verbatim */
/* >          CX is COMPLEX*16 array, dimension at least */
/* >           ( 1 + ( N - 1 )*abs( INCX ) ). */
/* >           Before entry, the incremented array CX must contain the n */
/* >           element vector cx. On exit, CX is overwritten by the updated */
/* >           vector cx. */
/* > \endverbatim */
/* > */
/* > \param[in] INCX */
/* > \verbatim */
/* >          INCX is INTEGER */
/* >           On entry, INCX specifies the increment for the elements of */
/* >           CX. INCX must not be zero. */
/* > \endverbatim */
/* > */
/* > \param[in,out] CY */
/* > \verbatim */
/* >          CY is COMPLEX*16 array, dimension at least */
/* >           ( 1 + ( N - 1 )*abs( INCY ) ). */
/* >           Before entry, the incremented array CY must contain the n */
/* >           element vector cy. On exit, CY is overwritten by the updated */
/* >           vector cy. */
/* > \endverbatim */
/* > */
/* > \param[in] INCY */
/* > \verbatim */
/* >          INCY is INTEGER */
/* >           On entry, INCY specifies the increment for the elements of */
/* >           CY. INCY must not be zero. */
/* > \endverbatim */
/* > */
/* > \param[in] C */
/* > \verbatim */
/* >          C is DOUBLE PRECISION */
/* >           On entry, C specifies the cosine, M(cos). */
/* > \endverbatim */
/* > */
/* > \param[in] S */
/* > \verbatim */
/* >          S is DOUBLE PRECISION */
/* >           On entry, S specifies the sine, M(sin). */
/* > \endverbatim */

/*  Authors: */
/*  ======== */

/* > \author Univ. of Tennessee */
/* > \author Univ. of California Berkeley */
/* > \author Univ. of Colorado Denver */
/* > \author NAG Ltd. */

/* > \date December 2016 */

/* > \ingroup complex16_blas_level1 */

/*  ===================================================================== */
void  wqrot_(integer *n, quadcomplex *cx, integer *incx, 
	quadcomplex *cy, integer *incy, quadreal *c__, quadreal *s)
{
    /* System generated locals */
    integer i__1, i__2, i__3, i__4;
    quadcomplex z__1, z__2, z__3;

    /* Local variables */
    integer i__, ix, iy;
    quadcomplex ctemp;


/*  -- Reference BLAS level1 routine (version 3.7.0) -- */
/*  -- Reference BLAS is a software package provided by Univ. of Tennessee,    -- */
/*  -- Univ. of California Berkeley, Univ. of Colorado Denver and NAG Ltd..-- */
/*     December 2016 */


/* ===================================================================== */


    /* Parameter adjustments */
    --cy;
    --cx;

    /* Function Body */
    if (*n <= 0) {
	return;
    }
    if (*incx == 1 && *incy == 1) {

/*        code for both increments equal to 1 */

	i__1 = *n;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    i__2 = i__;
	    z__2.r = *c__ * cx[i__2].r, z__2.i = *c__ * cx[i__2].i;
	    i__3 = i__;
	    z__3.r = *s * cy[i__3].r, z__3.i = *s * cy[i__3].i;
	    z__1.r = z__2.r + z__3.r, z__1.i = z__2.i + z__3.i;
	    ctemp.r = z__1.r, ctemp.i = z__1.i;
	    i__2 = i__;
	    i__3 = i__;
	    z__2.r = *c__ * cy[i__3].r, z__2.i = *c__ * cy[i__3].i;
	    i__4 = i__;
	    z__3.r = *s * cx[i__4].r, z__3.i = *s * cx[i__4].i;
	    z__1.r = z__2.r - z__3.r, z__1.i = z__2.i - z__3.i;
	    cy[i__2].r = z__1.r, cy[i__2].i = z__1.i;
	    i__2 = i__;
	    cx[i__2].r = ctemp.r, cx[i__2].i = ctemp.i;
	}
    } else {

/*        code for unequal increments or equal increments not equal */
/*          to 1 */

	ix = 1;
	iy = 1;
	if (*incx < 0) {
	    ix = (-(*n) + 1) * *incx + 1;
	}
	if (*incy < 0) {
	    iy = (-(*n) + 1) * *incy + 1;
	}
	i__1 = *n;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    i__2 = ix;
	    z__2.r = *c__ * cx[i__2].r, z__2.i = *c__ * cx[i__2].i;
	    i__3 = iy;
	    z__3.r = *s * cy[i__3].r, z__3.i = *s * cy[i__3].i;
	    z__1.r = z__2.r + z__3.r, z__1.i = z__2.i + z__3.i;
	    ctemp.r = z__1.r, ctemp.i = z__1.i;
	    i__2 = iy;
	    i__3 = iy;
	    z__2.r = *c__ * cy[i__3].r, z__2.i = *c__ * cy[i__3].i;
	    i__4 = ix;
	    z__3.r = *s * cx[i__4].r, z__3.i = *s * cx[i__4].i;
	    z__1.r = z__2.r - z__3.r, z__1.i = z__2.i - z__3.i;
	    cy[i__2].r = z__1.r, cy[i__2].i = z__1.i;
	    i__2 = ix;
	    cx[i__2].r = ctemp.r, cx[i__2].i = ctemp.i;
	    ix += *incx;
	    iy += *incy;
	}
    }
    return;
} /* wqrot_ */

