// This file was autogenerated by cloop - Cross Language Object Oriented Programming

#ifndef IDL_FB_INTERFACES_H
#define IDL_FB_INTERFACES_H

#ifndef CLOOP_CARG
#define CLOOP_CARG
#endif

#ifndef CLOOP_NOEXCEPT
#if __cplusplus >= 201103L
#define CLOOP_NOEXCEPT noexcept
#else
#define CLOOP_NOEXCEPT throw()
#endif
#endif


#ifndef CLOOP_CONSTEXPR
#if __cplusplus >= 201103L
#define CLOOP_CONSTEXPR constexpr
#else
#define CLOOP_CONSTEXPR const
#endif
#endif


namespace Firebird
{
	class DoNotInherit
	{
	};

	template <typename T>
	class Inherit : public T
	{
	public:
		Inherit(DoNotInherit = DoNotInherit())
			: T(DoNotInherit())
		{
		}
	};

	// Forward interfaces declarations

	class IVersioned;
	class IReferenceCounted;
	class IDisposable;
	class IStatus;
	class IMaster;
	class IPluginBase;
	class IPluginSet;
	class IConfigEntry;
	class IConfig;
	class IFirebirdConf;
	class IPluginConfig;
	class IPluginFactory;
	class IPluginModule;
	class IPluginManager;
	class ICryptKey;
	class IConfigManager;
	class IEventCallback;
	class IBlob;
	class ITransaction;
	class IMessageMetadata;
	class IMetadataBuilder;
	class IResultSet;
	class IStatement;
	class IBatch;
	class IBatchCompletionState;
	class IReplicator;
	class IRequest;
	class IEvents;
	class IAttachment;
	class IService;
	class IProvider;
	class IDtcStart;
	class IDtc;
	class IAuth;
	class IWriter;
	class IServerBlock;
	class IClientBlock;
	class IServer;
	class IClient;
	class IUserField;
	class ICharUserField;
	class IIntUserField;
	class IUser;
	class IListUsers;
	class ILogonInfo;
	class IManagement;
	class IAuthBlock;
	class IWireCryptPlugin;
	class ICryptKeyCallback;
	class IKeyHolderPlugin;
	class IDbCryptInfo;
	class IDbCryptPlugin;
	class IExternalContext;
	class IExternalResultSet;
	class IExternalFunction;
	class IExternalProcedure;
	class IExternalTrigger;
	class IRoutineMetadata;
	class IExternalEngine;
	class ITimer;
	class ITimerControl;
	class IVersionCallback;
	class IUtil;
	class IOffsetsCallback;
	class IXpbBuilder;
	class ITraceConnection;
	class ITraceDatabaseConnection;
	class ITraceTransaction;
	class ITraceParams;
	class ITraceStatement;
	class ITraceSQLStatement;
	class ITraceBLRStatement;
	class ITraceDYNRequest;
	class ITraceContextVariable;
	class ITraceProcedure;
	class ITraceFunction;
	class ITraceTrigger;
	class ITraceServiceConnection;
	class ITraceStatusVector;
	class ITraceSweepInfo;
	class ITraceLogWriter;
	class ITraceInitInfo;
	class ITracePlugin;
	class ITraceFactory;
	class IUdrFunctionFactory;
	class IUdrProcedureFactory;
	class IUdrTriggerFactory;
	class IUdrPlugin;
	class IDecFloat16;
	class IDecFloat34;
	class IInt128;
	class IReplicatedField;
	class IReplicatedRecord;
	class IReplicatedTransaction;
	class IReplicatedSession;
	class IProfilerPlugin;
	class IProfilerSession;
	class IProfilerStats;

	// Interfaces declarations

#define FIREBIRD_IVERSIONED_VERSION 1u

	class IVersioned
	{
	public:
		struct VTable
		{
			void* cloopDummy[1];
			uintptr_t version;
		};

		void* cloopDummy[1];
		VTable* cloopVTable;

	protected:
		IVersioned(DoNotInherit)
		{
		}

		~IVersioned()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IVERSIONED_VERSION;
	};

#define FIREBIRD_IREFERENCE_COUNTED_VERSION 2u

	class IReferenceCounted : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *addRef)(IReferenceCounted* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *release)(IReferenceCounted* self) CLOOP_NOEXCEPT;
		};

	protected:
		IReferenceCounted(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IReferenceCounted()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IREFERENCE_COUNTED_VERSION;

		void addRef()
		{
			static_cast<VTable*>(this->cloopVTable)->addRef(this);
		}

		int release()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->release(this);
			return ret;
		}
	};

#define FIREBIRD_IDISPOSABLE_VERSION 2u

	class IDisposable : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *dispose)(IDisposable* self) CLOOP_NOEXCEPT;
		};

	protected:
		IDisposable(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IDisposable()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IDISPOSABLE_VERSION;

		void dispose()
		{
			static_cast<VTable*>(this->cloopVTable)->dispose(this);
		}
	};

#define FIREBIRD_ISTATUS_VERSION 3u

	class IStatus : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *init)(IStatus* self) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getState)(const IStatus* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setErrors2)(IStatus* self, unsigned length, const intptr_t* value) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setWarnings2)(IStatus* self, unsigned length, const intptr_t* value) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setErrors)(IStatus* self, const intptr_t* value) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setWarnings)(IStatus* self, const intptr_t* value) CLOOP_NOEXCEPT;
			const intptr_t* (CLOOP_CARG *getErrors)(const IStatus* self) CLOOP_NOEXCEPT;
			const intptr_t* (CLOOP_CARG *getWarnings)(const IStatus* self) CLOOP_NOEXCEPT;
			IStatus* (CLOOP_CARG *clone)(const IStatus* self) CLOOP_NOEXCEPT;
		};

	protected:
		IStatus(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IStatus()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ISTATUS_VERSION;

		static CLOOP_CONSTEXPR unsigned STATE_WARNINGS = 0x1;
		static CLOOP_CONSTEXPR unsigned STATE_ERRORS = 0x2;
		static CLOOP_CONSTEXPR int RESULT_ERROR = -1;
		static CLOOP_CONSTEXPR int RESULT_OK = 0;
		static CLOOP_CONSTEXPR int RESULT_NO_DATA = 1;
		static CLOOP_CONSTEXPR int RESULT_SEGMENT = 2;

		void init()
		{
			static_cast<VTable*>(this->cloopVTable)->init(this);
		}

		unsigned getState() const
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getState(this);
			return ret;
		}

		void setErrors2(unsigned length, const intptr_t* value)
		{
			static_cast<VTable*>(this->cloopVTable)->setErrors2(this, length, value);
		}

		void setWarnings2(unsigned length, const intptr_t* value)
		{
			static_cast<VTable*>(this->cloopVTable)->setWarnings2(this, length, value);
		}

		void setErrors(const intptr_t* value)
		{
			static_cast<VTable*>(this->cloopVTable)->setErrors(this, value);
		}

		void setWarnings(const intptr_t* value)
		{
			static_cast<VTable*>(this->cloopVTable)->setWarnings(this, value);
		}

		const intptr_t* getErrors() const
		{
			const intptr_t* ret = static_cast<VTable*>(this->cloopVTable)->getErrors(this);
			return ret;
		}

		const intptr_t* getWarnings() const
		{
			const intptr_t* ret = static_cast<VTable*>(this->cloopVTable)->getWarnings(this);
			return ret;
		}

		IStatus* clone() const
		{
			IStatus* ret = static_cast<VTable*>(this->cloopVTable)->clone(this);
			return ret;
		}
	};

#define FIREBIRD_IMASTER_VERSION 2u

	class IMaster : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			IStatus* (CLOOP_CARG *getStatus)(IMaster* self) CLOOP_NOEXCEPT;
			IProvider* (CLOOP_CARG *getDispatcher)(IMaster* self) CLOOP_NOEXCEPT;
			IPluginManager* (CLOOP_CARG *getPluginManager)(IMaster* self) CLOOP_NOEXCEPT;
			ITimerControl* (CLOOP_CARG *getTimerControl)(IMaster* self) CLOOP_NOEXCEPT;
			IDtc* (CLOOP_CARG *getDtc)(IMaster* self) CLOOP_NOEXCEPT;
			IAttachment* (CLOOP_CARG *registerAttachment)(IMaster* self, IProvider* provider, IAttachment* attachment) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *registerTransaction)(IMaster* self, IAttachment* attachment, ITransaction* transaction) CLOOP_NOEXCEPT;
			IMetadataBuilder* (CLOOP_CARG *getMetadataBuilder)(IMaster* self, IStatus* status, unsigned fieldCount) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *serverMode)(IMaster* self, int mode) CLOOP_NOEXCEPT;
			IUtil* (CLOOP_CARG *getUtilInterface)(IMaster* self) CLOOP_NOEXCEPT;
			IConfigManager* (CLOOP_CARG *getConfigManager)(IMaster* self) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *getProcessExiting)(IMaster* self) CLOOP_NOEXCEPT;
		};

	protected:
		IMaster(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IMaster()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IMASTER_VERSION;

		IStatus* getStatus()
		{
			IStatus* ret = static_cast<VTable*>(this->cloopVTable)->getStatus(this);
			return ret;
		}

		IProvider* getDispatcher()
		{
			IProvider* ret = static_cast<VTable*>(this->cloopVTable)->getDispatcher(this);
			return ret;
		}

		IPluginManager* getPluginManager()
		{
			IPluginManager* ret = static_cast<VTable*>(this->cloopVTable)->getPluginManager(this);
			return ret;
		}

		ITimerControl* getTimerControl()
		{
			ITimerControl* ret = static_cast<VTable*>(this->cloopVTable)->getTimerControl(this);
			return ret;
		}

		IDtc* getDtc()
		{
			IDtc* ret = static_cast<VTable*>(this->cloopVTable)->getDtc(this);
			return ret;
		}

		IAttachment* registerAttachment(IProvider* provider, IAttachment* attachment)
		{
			IAttachment* ret = static_cast<VTable*>(this->cloopVTable)->registerAttachment(this, provider, attachment);
			return ret;
		}

		ITransaction* registerTransaction(IAttachment* attachment, ITransaction* transaction)
		{
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->registerTransaction(this, attachment, transaction);
			return ret;
		}

		template <typename StatusType> IMetadataBuilder* getMetadataBuilder(StatusType* status, unsigned fieldCount)
		{
			StatusType::clearException(status);
			IMetadataBuilder* ret = static_cast<VTable*>(this->cloopVTable)->getMetadataBuilder(this, status, fieldCount);
			StatusType::checkException(status);
			return ret;
		}

		int serverMode(int mode)
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->serverMode(this, mode);
			return ret;
		}

		IUtil* getUtilInterface()
		{
			IUtil* ret = static_cast<VTable*>(this->cloopVTable)->getUtilInterface(this);
			return ret;
		}

		IConfigManager* getConfigManager()
		{
			IConfigManager* ret = static_cast<VTable*>(this->cloopVTable)->getConfigManager(this);
			return ret;
		}

		FB_BOOLEAN getProcessExiting()
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->getProcessExiting(this);
			return ret;
		}
	};

#define FIREBIRD_IPLUGIN_BASE_VERSION 3u

	class IPluginBase : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *setOwner)(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT;
			IReferenceCounted* (CLOOP_CARG *getOwner)(IPluginBase* self) CLOOP_NOEXCEPT;
		};

	protected:
		IPluginBase(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IPluginBase()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPLUGIN_BASE_VERSION;

		void setOwner(IReferenceCounted* r)
		{
			static_cast<VTable*>(this->cloopVTable)->setOwner(this, r);
		}

		IReferenceCounted* getOwner()
		{
			IReferenceCounted* ret = static_cast<VTable*>(this->cloopVTable)->getOwner(this);
			return ret;
		}
	};

#define FIREBIRD_IPLUGIN_SET_VERSION 3u

	class IPluginSet : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			const char* (CLOOP_CARG *getName)(const IPluginSet* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getModuleName)(const IPluginSet* self) CLOOP_NOEXCEPT;
			IPluginBase* (CLOOP_CARG *getPlugin)(IPluginSet* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *next)(IPluginSet* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *set)(IPluginSet* self, IStatus* status, const char* s) CLOOP_NOEXCEPT;
		};

	protected:
		IPluginSet(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IPluginSet()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPLUGIN_SET_VERSION;

		const char* getName() const
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getName(this);
			return ret;
		}

		const char* getModuleName() const
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getModuleName(this);
			return ret;
		}

		template <typename StatusType> IPluginBase* getPlugin(StatusType* status)
		{
			StatusType::clearException(status);
			IPluginBase* ret = static_cast<VTable*>(this->cloopVTable)->getPlugin(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void next(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->next(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void set(StatusType* status, const char* s)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->set(this, status, s);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ICONFIG_ENTRY_VERSION 3u

	class IConfigEntry : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			const char* (CLOOP_CARG *getName)(IConfigEntry* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getValue)(IConfigEntry* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getIntValue)(IConfigEntry* self) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *getBoolValue)(IConfigEntry* self) CLOOP_NOEXCEPT;
			IConfig* (CLOOP_CARG *getSubConfig)(IConfigEntry* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IConfigEntry(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IConfigEntry()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ICONFIG_ENTRY_VERSION;

		const char* getName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getName(this);
			return ret;
		}

		const char* getValue()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getValue(this);
			return ret;
		}

		ISC_INT64 getIntValue()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getIntValue(this);
			return ret;
		}

		FB_BOOLEAN getBoolValue()
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->getBoolValue(this);
			return ret;
		}

		template <typename StatusType> IConfig* getSubConfig(StatusType* status)
		{
			StatusType::clearException(status);
			IConfig* ret = static_cast<VTable*>(this->cloopVTable)->getSubConfig(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_ICONFIG_VERSION 3u

	class IConfig : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			IConfigEntry* (CLOOP_CARG *find)(IConfig* self, IStatus* status, const char* name) CLOOP_NOEXCEPT;
			IConfigEntry* (CLOOP_CARG *findValue)(IConfig* self, IStatus* status, const char* name, const char* value) CLOOP_NOEXCEPT;
			IConfigEntry* (CLOOP_CARG *findPos)(IConfig* self, IStatus* status, const char* name, unsigned pos) CLOOP_NOEXCEPT;
		};

	protected:
		IConfig(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IConfig()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ICONFIG_VERSION;

		template <typename StatusType> IConfigEntry* find(StatusType* status, const char* name)
		{
			StatusType::clearException(status);
			IConfigEntry* ret = static_cast<VTable*>(this->cloopVTable)->find(this, status, name);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IConfigEntry* findValue(StatusType* status, const char* name, const char* value)
		{
			StatusType::clearException(status);
			IConfigEntry* ret = static_cast<VTable*>(this->cloopVTable)->findValue(this, status, name, value);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IConfigEntry* findPos(StatusType* status, const char* name, unsigned pos)
		{
			StatusType::clearException(status);
			IConfigEntry* ret = static_cast<VTable*>(this->cloopVTable)->findPos(this, status, name, pos);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IFIREBIRD_CONF_VERSION 4u

	class IFirebirdConf : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			unsigned (CLOOP_CARG *getKey)(IFirebirdConf* self, const char* name) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *asInteger)(IFirebirdConf* self, unsigned key) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *asString)(IFirebirdConf* self, unsigned key) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *asBoolean)(IFirebirdConf* self, unsigned key) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getVersion)(IFirebirdConf* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IFirebirdConf(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IFirebirdConf()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IFIREBIRD_CONF_VERSION;

		unsigned getKey(const char* name)
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getKey(this, name);
			return ret;
		}

		ISC_INT64 asInteger(unsigned key)
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->asInteger(this, key);
			return ret;
		}

		const char* asString(unsigned key)
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->asString(this, key);
			return ret;
		}

		FB_BOOLEAN asBoolean(unsigned key)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->asBoolean(this, key);
			return ret;
		}

		template <typename StatusType> unsigned getVersion(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IFirebirdConf", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getVersion(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IPLUGIN_CONFIG_VERSION 3u

	class IPluginConfig : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			const char* (CLOOP_CARG *getConfigFileName)(IPluginConfig* self) CLOOP_NOEXCEPT;
			IConfig* (CLOOP_CARG *getDefaultConfig)(IPluginConfig* self, IStatus* status) CLOOP_NOEXCEPT;
			IFirebirdConf* (CLOOP_CARG *getFirebirdConf)(IPluginConfig* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setReleaseDelay)(IPluginConfig* self, IStatus* status, ISC_UINT64 microSeconds) CLOOP_NOEXCEPT;
		};

	protected:
		IPluginConfig(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IPluginConfig()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPLUGIN_CONFIG_VERSION;

		const char* getConfigFileName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getConfigFileName(this);
			return ret;
		}

		template <typename StatusType> IConfig* getDefaultConfig(StatusType* status)
		{
			StatusType::clearException(status);
			IConfig* ret = static_cast<VTable*>(this->cloopVTable)->getDefaultConfig(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IFirebirdConf* getFirebirdConf(StatusType* status)
		{
			StatusType::clearException(status);
			IFirebirdConf* ret = static_cast<VTable*>(this->cloopVTable)->getFirebirdConf(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setReleaseDelay(StatusType* status, ISC_UINT64 microSeconds)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setReleaseDelay(this, status, microSeconds);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IPLUGIN_FACTORY_VERSION 2u

	class IPluginFactory : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			IPluginBase* (CLOOP_CARG *createPlugin)(IPluginFactory* self, IStatus* status, IPluginConfig* factoryParameter) CLOOP_NOEXCEPT;
		};

	protected:
		IPluginFactory(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IPluginFactory()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPLUGIN_FACTORY_VERSION;

		template <typename StatusType> IPluginBase* createPlugin(StatusType* status, IPluginConfig* factoryParameter)
		{
			StatusType::clearException(status);
			IPluginBase* ret = static_cast<VTable*>(this->cloopVTable)->createPlugin(this, status, factoryParameter);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IPLUGIN_MODULE_VERSION 3u

	class IPluginModule : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *doClean)(IPluginModule* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *threadDetach)(IPluginModule* self) CLOOP_NOEXCEPT;
		};

	protected:
		IPluginModule(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IPluginModule()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPLUGIN_MODULE_VERSION;

		void doClean()
		{
			static_cast<VTable*>(this->cloopVTable)->doClean(this);
		}

		void threadDetach()
		{
			if (cloopVTable->version < 3)
			{
				return;
			}
			static_cast<VTable*>(this->cloopVTable)->threadDetach(this);
		}
	};

#define FIREBIRD_IPLUGIN_MANAGER_VERSION 2u

	class IPluginManager : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *registerPluginFactory)(IPluginManager* self, unsigned pluginType, const char* defaultName, IPluginFactory* factory) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *registerModule)(IPluginManager* self, IPluginModule* cleanup) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *unregisterModule)(IPluginManager* self, IPluginModule* cleanup) CLOOP_NOEXCEPT;
			IPluginSet* (CLOOP_CARG *getPlugins)(IPluginManager* self, IStatus* status, unsigned pluginType, const char* namesList, IFirebirdConf* firebirdConf) CLOOP_NOEXCEPT;
			IConfig* (CLOOP_CARG *getConfig)(IPluginManager* self, IStatus* status, const char* filename) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *releasePlugin)(IPluginManager* self, IPluginBase* plugin) CLOOP_NOEXCEPT;
		};

	protected:
		IPluginManager(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IPluginManager()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPLUGIN_MANAGER_VERSION;

		static CLOOP_CONSTEXPR unsigned TYPE_PROVIDER = 1;
		static CLOOP_CONSTEXPR unsigned TYPE_FIRST_NON_LIB = 2;
		static CLOOP_CONSTEXPR unsigned TYPE_AUTH_SERVER = 3;
		static CLOOP_CONSTEXPR unsigned TYPE_AUTH_CLIENT = 4;
		static CLOOP_CONSTEXPR unsigned TYPE_AUTH_USER_MANAGEMENT = 5;
		static CLOOP_CONSTEXPR unsigned TYPE_EXTERNAL_ENGINE = 6;
		static CLOOP_CONSTEXPR unsigned TYPE_TRACE = 7;
		static CLOOP_CONSTEXPR unsigned TYPE_WIRE_CRYPT = 8;
		static CLOOP_CONSTEXPR unsigned TYPE_DB_CRYPT = 9;
		static CLOOP_CONSTEXPR unsigned TYPE_KEY_HOLDER = 10;
		static CLOOP_CONSTEXPR unsigned TYPE_REPLICATOR = 11;
		static CLOOP_CONSTEXPR unsigned TYPE_PROFILER = 12;
		static CLOOP_CONSTEXPR unsigned TYPE_COUNT = 13;

		void registerPluginFactory(unsigned pluginType, const char* defaultName, IPluginFactory* factory)
		{
			static_cast<VTable*>(this->cloopVTable)->registerPluginFactory(this, pluginType, defaultName, factory);
		}

		void registerModule(IPluginModule* cleanup)
		{
			static_cast<VTable*>(this->cloopVTable)->registerModule(this, cleanup);
		}

		void unregisterModule(IPluginModule* cleanup)
		{
			static_cast<VTable*>(this->cloopVTable)->unregisterModule(this, cleanup);
		}

		template <typename StatusType> IPluginSet* getPlugins(StatusType* status, unsigned pluginType, const char* namesList, IFirebirdConf* firebirdConf)
		{
			StatusType::clearException(status);
			IPluginSet* ret = static_cast<VTable*>(this->cloopVTable)->getPlugins(this, status, pluginType, namesList, firebirdConf);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IConfig* getConfig(StatusType* status, const char* filename)
		{
			StatusType::clearException(status);
			IConfig* ret = static_cast<VTable*>(this->cloopVTable)->getConfig(this, status, filename);
			StatusType::checkException(status);
			return ret;
		}

		void releasePlugin(IPluginBase* plugin)
		{
			static_cast<VTable*>(this->cloopVTable)->releasePlugin(this, plugin);
		}
	};

#define FIREBIRD_ICRYPT_KEY_VERSION 2u

	class ICryptKey : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *setSymmetric)(ICryptKey* self, IStatus* status, const char* type, unsigned keyLength, const void* key) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setAsymmetric)(ICryptKey* self, IStatus* status, const char* type, unsigned encryptKeyLength, const void* encryptKey, unsigned decryptKeyLength, const void* decryptKey) CLOOP_NOEXCEPT;
			const void* (CLOOP_CARG *getEncryptKey)(ICryptKey* self, unsigned* length) CLOOP_NOEXCEPT;
			const void* (CLOOP_CARG *getDecryptKey)(ICryptKey* self, unsigned* length) CLOOP_NOEXCEPT;
		};

	protected:
		ICryptKey(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ICryptKey()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ICRYPT_KEY_VERSION;

		template <typename StatusType> void setSymmetric(StatusType* status, const char* type, unsigned keyLength, const void* key)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setSymmetric(this, status, type, keyLength, key);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setAsymmetric(StatusType* status, const char* type, unsigned encryptKeyLength, const void* encryptKey, unsigned decryptKeyLength, const void* decryptKey)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setAsymmetric(this, status, type, encryptKeyLength, encryptKey, decryptKeyLength, decryptKey);
			StatusType::checkException(status);
		}

		const void* getEncryptKey(unsigned* length)
		{
			const void* ret = static_cast<VTable*>(this->cloopVTable)->getEncryptKey(this, length);
			return ret;
		}

		const void* getDecryptKey(unsigned* length)
		{
			const void* ret = static_cast<VTable*>(this->cloopVTable)->getDecryptKey(this, length);
			return ret;
		}
	};

#define FIREBIRD_ICONFIG_MANAGER_VERSION 3u

	class IConfigManager : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getDirectory)(IConfigManager* self, unsigned code) CLOOP_NOEXCEPT;
			IFirebirdConf* (CLOOP_CARG *getFirebirdConf)(IConfigManager* self) CLOOP_NOEXCEPT;
			IFirebirdConf* (CLOOP_CARG *getDatabaseConf)(IConfigManager* self, const char* dbName) CLOOP_NOEXCEPT;
			IConfig* (CLOOP_CARG *getPluginConfig)(IConfigManager* self, const char* configuredPlugin) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getInstallDirectory)(IConfigManager* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getRootDirectory)(IConfigManager* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getDefaultSecurityDb)(IConfigManager* self) CLOOP_NOEXCEPT;
		};

	protected:
		IConfigManager(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IConfigManager()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ICONFIG_MANAGER_VERSION;

		static CLOOP_CONSTEXPR unsigned DIR_BIN = 0;
		static CLOOP_CONSTEXPR unsigned DIR_SBIN = 1;
		static CLOOP_CONSTEXPR unsigned DIR_CONF = 2;
		static CLOOP_CONSTEXPR unsigned DIR_LIB = 3;
		static CLOOP_CONSTEXPR unsigned DIR_INC = 4;
		static CLOOP_CONSTEXPR unsigned DIR_DOC = 5;
		static CLOOP_CONSTEXPR unsigned DIR_UDF = 6;
		static CLOOP_CONSTEXPR unsigned DIR_SAMPLE = 7;
		static CLOOP_CONSTEXPR unsigned DIR_SAMPLEDB = 8;
		static CLOOP_CONSTEXPR unsigned DIR_HELP = 9;
		static CLOOP_CONSTEXPR unsigned DIR_INTL = 10;
		static CLOOP_CONSTEXPR unsigned DIR_MISC = 11;
		static CLOOP_CONSTEXPR unsigned DIR_SECDB = 12;
		static CLOOP_CONSTEXPR unsigned DIR_MSG = 13;
		static CLOOP_CONSTEXPR unsigned DIR_LOG = 14;
		static CLOOP_CONSTEXPR unsigned DIR_GUARD = 15;
		static CLOOP_CONSTEXPR unsigned DIR_PLUGINS = 16;
		static CLOOP_CONSTEXPR unsigned DIR_TZDATA = 17;
		static CLOOP_CONSTEXPR unsigned DIR_COUNT = 18;

		const char* getDirectory(unsigned code)
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getDirectory(this, code);
			return ret;
		}

		IFirebirdConf* getFirebirdConf()
		{
			IFirebirdConf* ret = static_cast<VTable*>(this->cloopVTable)->getFirebirdConf(this);
			return ret;
		}

		IFirebirdConf* getDatabaseConf(const char* dbName)
		{
			IFirebirdConf* ret = static_cast<VTable*>(this->cloopVTable)->getDatabaseConf(this, dbName);
			return ret;
		}

		IConfig* getPluginConfig(const char* configuredPlugin)
		{
			IConfig* ret = static_cast<VTable*>(this->cloopVTable)->getPluginConfig(this, configuredPlugin);
			return ret;
		}

		const char* getInstallDirectory()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getInstallDirectory(this);
			return ret;
		}

		const char* getRootDirectory()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getRootDirectory(this);
			return ret;
		}

		const char* getDefaultSecurityDb()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getDefaultSecurityDb(this);
			return ret;
		}
	};

#define FIREBIRD_IEVENT_CALLBACK_VERSION 3u

	class IEventCallback : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *eventCallbackFunction)(IEventCallback* self, unsigned length, const unsigned char* events) CLOOP_NOEXCEPT;
		};

	protected:
		IEventCallback(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IEventCallback()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IEVENT_CALLBACK_VERSION;

		void eventCallbackFunction(unsigned length, const unsigned char* events)
		{
			static_cast<VTable*>(this->cloopVTable)->eventCallbackFunction(this, length, events);
		}
	};

#define FIREBIRD_IBLOB_VERSION 4u

	class IBlob : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *getInfo)(IBlob* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getSegment)(IBlob* self, IStatus* status, unsigned bufferLength, void* buffer, unsigned* segmentLength) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *putSegment)(IBlob* self, IStatus* status, unsigned length, const void* buffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedCancel)(IBlob* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedClose)(IBlob* self, IStatus* status) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *seek)(IBlob* self, IStatus* status, int mode, int offset) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *cancel)(IBlob* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *close)(IBlob* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IBlob(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IBlob()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IBLOB_VERSION;

		template <typename StatusType> void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getInfo(this, status, itemsLength, items, bufferLength, buffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> int getSegment(StatusType* status, unsigned bufferLength, void* buffer, unsigned* segmentLength)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->getSegment(this, status, bufferLength, buffer, segmentLength);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void putSegment(StatusType* status, unsigned length, const void* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->putSegment(this, status, length, buffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedCancel(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedCancel(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedClose(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedClose(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> int seek(StatusType* status, int mode, int offset)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->seek(this, status, mode, offset);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void cancel(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IBlob", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedCancel(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->cancel(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void close(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IBlob", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedClose(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->close(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ITRANSACTION_VERSION 4u

	class ITransaction : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *getInfo)(ITransaction* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *prepare)(ITransaction* self, IStatus* status, unsigned msgLength, const unsigned char* message) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedCommit)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *commitRetaining)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedRollback)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *rollbackRetaining)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedDisconnect)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *join)(ITransaction* self, IStatus* status, ITransaction* transaction) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *validate)(ITransaction* self, IStatus* status, IAttachment* attachment) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *enterDtc)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *commit)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *rollback)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *disconnect)(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		ITransaction(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~ITransaction()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRANSACTION_VERSION;

		template <typename StatusType> void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getInfo(this, status, itemsLength, items, bufferLength, buffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void prepare(StatusType* status, unsigned msgLength, const unsigned char* message)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->prepare(this, status, msgLength, message);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedCommit(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedCommit(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void commitRetaining(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->commitRetaining(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedRollback(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedRollback(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void rollbackRetaining(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->rollbackRetaining(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedDisconnect(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedDisconnect(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> ITransaction* join(StatusType* status, ITransaction* transaction)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->join(this, status, transaction);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ITransaction* validate(StatusType* status, IAttachment* attachment)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->validate(this, status, attachment);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ITransaction* enterDtc(StatusType* status)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->enterDtc(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void commit(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "ITransaction", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedCommit(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->commit(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void rollback(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "ITransaction", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedRollback(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->rollback(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void disconnect(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "ITransaction", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedDisconnect(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->disconnect(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IMESSAGE_METADATA_VERSION 4u

	class IMessageMetadata : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			unsigned (CLOOP_CARG *getCount)(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getField)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getRelation)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getOwner)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getAlias)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getType)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *isNullable)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getSubType)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getLength)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getScale)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getCharSet)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getOffset)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getNullOffset)(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			IMetadataBuilder* (CLOOP_CARG *getBuilder)(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getMessageLength)(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getAlignment)(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getAlignedLength)(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IMessageMetadata(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IMessageMetadata()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IMESSAGE_METADATA_VERSION;

		template <typename StatusType> unsigned getCount(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getCount(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getField(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getField(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getRelation(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getRelation(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getOwner(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getOwner(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getAlias(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getAlias(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getType(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getType(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> FB_BOOLEAN isNullable(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->isNullable(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int getSubType(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->getSubType(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getLength(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getLength(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int getScale(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->getScale(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getCharSet(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getCharSet(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getOffset(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getOffset(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getNullOffset(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getNullOffset(this, status, index);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMetadataBuilder* getBuilder(StatusType* status)
		{
			StatusType::clearException(status);
			IMetadataBuilder* ret = static_cast<VTable*>(this->cloopVTable)->getBuilder(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getMessageLength(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getMessageLength(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getAlignment(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IMessageMetadata", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getAlignment(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getAlignedLength(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IMessageMetadata", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getAlignedLength(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IMETADATA_BUILDER_VERSION 4u

	class IMetadataBuilder : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *setType)(IMetadataBuilder* self, IStatus* status, unsigned index, unsigned type) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setSubType)(IMetadataBuilder* self, IStatus* status, unsigned index, int subType) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setLength)(IMetadataBuilder* self, IStatus* status, unsigned index, unsigned length) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setCharSet)(IMetadataBuilder* self, IStatus* status, unsigned index, unsigned charSet) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setScale)(IMetadataBuilder* self, IStatus* status, unsigned index, int scale) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *truncate)(IMetadataBuilder* self, IStatus* status, unsigned count) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *moveNameToIndex)(IMetadataBuilder* self, IStatus* status, const char* name, unsigned index) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *remove)(IMetadataBuilder* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *addField)(IMetadataBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			IMessageMetadata* (CLOOP_CARG *getMetadata)(IMetadataBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setField)(IMetadataBuilder* self, IStatus* status, unsigned index, const char* field) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setRelation)(IMetadataBuilder* self, IStatus* status, unsigned index, const char* relation) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setOwner)(IMetadataBuilder* self, IStatus* status, unsigned index, const char* owner) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setAlias)(IMetadataBuilder* self, IStatus* status, unsigned index, const char* alias) CLOOP_NOEXCEPT;
		};

	protected:
		IMetadataBuilder(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IMetadataBuilder()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IMETADATA_BUILDER_VERSION;

		template <typename StatusType> void setType(StatusType* status, unsigned index, unsigned type)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setType(this, status, index, type);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setSubType(StatusType* status, unsigned index, int subType)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setSubType(this, status, index, subType);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setLength(StatusType* status, unsigned index, unsigned length)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setLength(this, status, index, length);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setCharSet(StatusType* status, unsigned index, unsigned charSet)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setCharSet(this, status, index, charSet);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setScale(StatusType* status, unsigned index, int scale)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setScale(this, status, index, scale);
			StatusType::checkException(status);
		}

		template <typename StatusType> void truncate(StatusType* status, unsigned count)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->truncate(this, status, count);
			StatusType::checkException(status);
		}

		template <typename StatusType> void moveNameToIndex(StatusType* status, const char* name, unsigned index)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->moveNameToIndex(this, status, name, index);
			StatusType::checkException(status);
		}

		template <typename StatusType> void remove(StatusType* status, unsigned index)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->remove(this, status, index);
			StatusType::checkException(status);
		}

		template <typename StatusType> unsigned addField(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->addField(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMessageMetadata* getMetadata(StatusType* status)
		{
			StatusType::clearException(status);
			IMessageMetadata* ret = static_cast<VTable*>(this->cloopVTable)->getMetadata(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setField(StatusType* status, unsigned index, const char* field)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IMetadataBuilder", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setField(this, status, index, field);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setRelation(StatusType* status, unsigned index, const char* relation)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IMetadataBuilder", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setRelation(this, status, index, relation);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setOwner(StatusType* status, unsigned index, const char* owner)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IMetadataBuilder", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setOwner(this, status, index, owner);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setAlias(StatusType* status, unsigned index, const char* alias)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IMetadataBuilder", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setAlias(this, status, index, alias);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IRESULT_SET_VERSION 5u

	class IResultSet : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			int (CLOOP_CARG *fetchNext)(IResultSet* self, IStatus* status, void* message) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *fetchPrior)(IResultSet* self, IStatus* status, void* message) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *fetchFirst)(IResultSet* self, IStatus* status, void* message) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *fetchLast)(IResultSet* self, IStatus* status, void* message) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *fetchAbsolute)(IResultSet* self, IStatus* status, int position, void* message) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *fetchRelative)(IResultSet* self, IStatus* status, int offset, void* message) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *isEof)(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *isBof)(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT;
			IMessageMetadata* (CLOOP_CARG *getMetadata)(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedClose)(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setDelayedOutputFormat)(IResultSet* self, IStatus* status, IMessageMetadata* format) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *close)(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *getInfo)(IResultSet* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT;
		};

	protected:
		IResultSet(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IResultSet()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IRESULT_SET_VERSION;

		static CLOOP_CONSTEXPR unsigned char INF_RECORD_COUNT = 10;

		template <typename StatusType> int fetchNext(StatusType* status, void* message)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->fetchNext(this, status, message);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int fetchPrior(StatusType* status, void* message)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->fetchPrior(this, status, message);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int fetchFirst(StatusType* status, void* message)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->fetchFirst(this, status, message);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int fetchLast(StatusType* status, void* message)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->fetchLast(this, status, message);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int fetchAbsolute(StatusType* status, int position, void* message)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->fetchAbsolute(this, status, position, message);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int fetchRelative(StatusType* status, int offset, void* message)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->fetchRelative(this, status, offset, message);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> FB_BOOLEAN isEof(StatusType* status)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->isEof(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> FB_BOOLEAN isBof(StatusType* status)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->isBof(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMessageMetadata* getMetadata(StatusType* status)
		{
			StatusType::clearException(status);
			IMessageMetadata* ret = static_cast<VTable*>(this->cloopVTable)->getMetadata(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void deprecatedClose(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedClose(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setDelayedOutputFormat(StatusType* status, IMessageMetadata* format)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setDelayedOutputFormat(this, status, format);
			StatusType::checkException(status);
		}

		template <typename StatusType> void close(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IResultSet", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedClose(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->close(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer)
		{
			if (cloopVTable->version < 5)
			{
				StatusType::setVersionError(status, "IResultSet", cloopVTable->version, 5);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getInfo(this, status, itemsLength, items, bufferLength, buffer);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ISTATEMENT_VERSION 5u

	class IStatement : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *getInfo)(IStatement* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getType)(IStatement* self, IStatus* status) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getPlan)(IStatement* self, IStatus* status, FB_BOOLEAN detailed) CLOOP_NOEXCEPT;
			ISC_UINT64 (CLOOP_CARG *getAffectedRecords)(IStatement* self, IStatus* status) CLOOP_NOEXCEPT;
			IMessageMetadata* (CLOOP_CARG *getInputMetadata)(IStatement* self, IStatus* status) CLOOP_NOEXCEPT;
			IMessageMetadata* (CLOOP_CARG *getOutputMetadata)(IStatement* self, IStatus* status) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *execute)(IStatement* self, IStatus* status, ITransaction* transaction, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, void* outBuffer) CLOOP_NOEXCEPT;
			IResultSet* (CLOOP_CARG *openCursor)(IStatement* self, IStatus* status, ITransaction* transaction, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, unsigned flags) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setCursorName)(IStatement* self, IStatus* status, const char* name) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedFree)(IStatement* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getFlags)(IStatement* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getTimeout)(IStatement* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setTimeout)(IStatement* self, IStatus* status, unsigned timeOut) CLOOP_NOEXCEPT;
			IBatch* (CLOOP_CARG *createBatch)(IStatement* self, IStatus* status, IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *free)(IStatement* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IStatement(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IStatement()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ISTATEMENT_VERSION;

		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_NONE = 0x0;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_TYPE = 0x1;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_INPUT_PARAMETERS = 0x2;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_OUTPUT_PARAMETERS = 0x4;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_LEGACY_PLAN = 0x8;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_DETAILED_PLAN = 0x10;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_AFFECTED_RECORDS = 0x20;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_FLAGS = 0x40;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_METADATA = IStatement::PREPARE_PREFETCH_TYPE | IStatement::PREPARE_PREFETCH_FLAGS | IStatement::PREPARE_PREFETCH_INPUT_PARAMETERS | IStatement::PREPARE_PREFETCH_OUTPUT_PARAMETERS;
		static CLOOP_CONSTEXPR unsigned PREPARE_PREFETCH_ALL = IStatement::PREPARE_PREFETCH_METADATA | IStatement::PREPARE_PREFETCH_LEGACY_PLAN | IStatement::PREPARE_PREFETCH_DETAILED_PLAN | IStatement::PREPARE_PREFETCH_AFFECTED_RECORDS;
		static CLOOP_CONSTEXPR unsigned FLAG_HAS_CURSOR = 0x1;
		static CLOOP_CONSTEXPR unsigned FLAG_REPEAT_EXECUTE = 0x2;
		static CLOOP_CONSTEXPR unsigned CURSOR_TYPE_SCROLLABLE = 0x1;

		template <typename StatusType> void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getInfo(this, status, itemsLength, items, bufferLength, buffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> unsigned getType(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getType(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getPlan(StatusType* status, FB_BOOLEAN detailed)
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getPlan(this, status, detailed);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ISC_UINT64 getAffectedRecords(StatusType* status)
		{
			StatusType::clearException(status);
			ISC_UINT64 ret = static_cast<VTable*>(this->cloopVTable)->getAffectedRecords(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMessageMetadata* getInputMetadata(StatusType* status)
		{
			StatusType::clearException(status);
			IMessageMetadata* ret = static_cast<VTable*>(this->cloopVTable)->getInputMetadata(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMessageMetadata* getOutputMetadata(StatusType* status)
		{
			StatusType::clearException(status);
			IMessageMetadata* ret = static_cast<VTable*>(this->cloopVTable)->getOutputMetadata(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ITransaction* execute(StatusType* status, ITransaction* transaction, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, void* outBuffer)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->execute(this, status, transaction, inMetadata, inBuffer, outMetadata, outBuffer);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IResultSet* openCursor(StatusType* status, ITransaction* transaction, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, unsigned flags)
		{
			StatusType::clearException(status);
			IResultSet* ret = static_cast<VTable*>(this->cloopVTable)->openCursor(this, status, transaction, inMetadata, inBuffer, outMetadata, flags);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setCursorName(StatusType* status, const char* name)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setCursorName(this, status, name);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedFree(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedFree(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> unsigned getFlags(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getFlags(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getTimeout(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IStatement", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getTimeout(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setTimeout(StatusType* status, unsigned timeOut)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IStatement", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setTimeout(this, status, timeOut);
			StatusType::checkException(status);
		}

		template <typename StatusType> IBatch* createBatch(StatusType* status, IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IStatement", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			IBatch* ret = static_cast<VTable*>(this->cloopVTable)->createBatch(this, status, inMetadata, parLength, par);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void free(StatusType* status)
		{
			if (cloopVTable->version < 5)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IStatement", cloopVTable->version, 5);
					StatusType::checkException(status);
				}
				else {
					deprecatedFree(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->free(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IBATCH_VERSION 4u

	class IBatch : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *add)(IBatch* self, IStatus* status, unsigned count, const void* inBuffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *addBlob)(IBatch* self, IStatus* status, unsigned length, const void* inBuffer, ISC_QUAD* blobId, unsigned parLength, const unsigned char* par) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *appendBlobData)(IBatch* self, IStatus* status, unsigned length, const void* inBuffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *addBlobStream)(IBatch* self, IStatus* status, unsigned length, const void* inBuffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *registerBlob)(IBatch* self, IStatus* status, const ISC_QUAD* existingBlob, ISC_QUAD* blobId) CLOOP_NOEXCEPT;
			IBatchCompletionState* (CLOOP_CARG *execute)(IBatch* self, IStatus* status, ITransaction* transaction) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *cancel)(IBatch* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getBlobAlignment)(IBatch* self, IStatus* status) CLOOP_NOEXCEPT;
			IMessageMetadata* (CLOOP_CARG *getMetadata)(IBatch* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setDefaultBpb)(IBatch* self, IStatus* status, unsigned parLength, const unsigned char* par) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedClose)(IBatch* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *close)(IBatch* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *getInfo)(IBatch* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT;
		};

	protected:
		IBatch(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IBatch()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IBATCH_VERSION;

		static CLOOP_CONSTEXPR unsigned char VERSION1 = 1;
		static CLOOP_CONSTEXPR unsigned char CURRENT_VERSION = IBatch::VERSION1;
		static CLOOP_CONSTEXPR unsigned char TAG_MULTIERROR = 1;
		static CLOOP_CONSTEXPR unsigned char TAG_RECORD_COUNTS = 2;
		static CLOOP_CONSTEXPR unsigned char TAG_BUFFER_BYTES_SIZE = 3;
		static CLOOP_CONSTEXPR unsigned char TAG_BLOB_POLICY = 4;
		static CLOOP_CONSTEXPR unsigned char TAG_DETAILED_ERRORS = 5;
		static CLOOP_CONSTEXPR unsigned char INF_BUFFER_BYTES_SIZE = 10;
		static CLOOP_CONSTEXPR unsigned char INF_DATA_BYTES_SIZE = 11;
		static CLOOP_CONSTEXPR unsigned char INF_BLOBS_BYTES_SIZE = 12;
		static CLOOP_CONSTEXPR unsigned char INF_BLOB_ALIGNMENT = 13;
		static CLOOP_CONSTEXPR unsigned char INF_BLOB_HEADER = 14;
		static CLOOP_CONSTEXPR unsigned char BLOB_NONE = 0;
		static CLOOP_CONSTEXPR unsigned char BLOB_ID_ENGINE = 1;
		static CLOOP_CONSTEXPR unsigned char BLOB_ID_USER = 2;
		static CLOOP_CONSTEXPR unsigned char BLOB_STREAM = 3;
		static CLOOP_CONSTEXPR unsigned BLOB_SEGHDR_ALIGN = 2;

		template <typename StatusType> void add(StatusType* status, unsigned count, const void* inBuffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->add(this, status, count, inBuffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void addBlob(StatusType* status, unsigned length, const void* inBuffer, ISC_QUAD* blobId, unsigned parLength, const unsigned char* par)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->addBlob(this, status, length, inBuffer, blobId, parLength, par);
			StatusType::checkException(status);
		}

		template <typename StatusType> void appendBlobData(StatusType* status, unsigned length, const void* inBuffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->appendBlobData(this, status, length, inBuffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void addBlobStream(StatusType* status, unsigned length, const void* inBuffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->addBlobStream(this, status, length, inBuffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void registerBlob(StatusType* status, const ISC_QUAD* existingBlob, ISC_QUAD* blobId)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->registerBlob(this, status, existingBlob, blobId);
			StatusType::checkException(status);
		}

		template <typename StatusType> IBatchCompletionState* execute(StatusType* status, ITransaction* transaction)
		{
			StatusType::clearException(status);
			IBatchCompletionState* ret = static_cast<VTable*>(this->cloopVTable)->execute(this, status, transaction);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void cancel(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->cancel(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> unsigned getBlobAlignment(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getBlobAlignment(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMessageMetadata* getMetadata(StatusType* status)
		{
			StatusType::clearException(status);
			IMessageMetadata* ret = static_cast<VTable*>(this->cloopVTable)->getMetadata(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setDefaultBpb(StatusType* status, unsigned parLength, const unsigned char* par)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setDefaultBpb(this, status, parLength, par);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedClose(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedClose(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void close(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IBatch", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedClose(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->close(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IBatch", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getInfo(this, status, itemsLength, items, bufferLength, buffer);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IBATCH_COMPLETION_STATE_VERSION 3u

	class IBatchCompletionState : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			unsigned (CLOOP_CARG *getSize)(IBatchCompletionState* self, IStatus* status) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getState)(IBatchCompletionState* self, IStatus* status, unsigned pos) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *findError)(IBatchCompletionState* self, IStatus* status, unsigned pos) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *getStatus)(IBatchCompletionState* self, IStatus* status, IStatus* to, unsigned pos) CLOOP_NOEXCEPT;
		};

	protected:
		IBatchCompletionState(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IBatchCompletionState()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IBATCH_COMPLETION_STATE_VERSION;

		static CLOOP_CONSTEXPR int EXECUTE_FAILED = -1;
		static CLOOP_CONSTEXPR int SUCCESS_NO_INFO = -2;
		static CLOOP_CONSTEXPR unsigned NO_MORE_ERRORS = 0xffffffff;

		template <typename StatusType> unsigned getSize(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getSize(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int getState(StatusType* status, unsigned pos)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->getState(this, status, pos);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned findError(StatusType* status, unsigned pos)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->findError(this, status, pos);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void getStatus(StatusType* status, IStatus* to, unsigned pos)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getStatus(this, status, to, pos);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IREPLICATOR_VERSION 4u

	class IReplicator : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *process)(IReplicator* self, IStatus* status, unsigned length, const unsigned char* data) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedClose)(IReplicator* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *close)(IReplicator* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IReplicator(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IReplicator()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IREPLICATOR_VERSION;

		template <typename StatusType> void process(StatusType* status, unsigned length, const unsigned char* data)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->process(this, status, length, data);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedClose(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedClose(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void close(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IReplicator", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedClose(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->close(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IREQUEST_VERSION 4u

	class IRequest : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *receive)(IRequest* self, IStatus* status, int level, unsigned msgType, unsigned length, void* message) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *send)(IRequest* self, IStatus* status, int level, unsigned msgType, unsigned length, const void* message) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *getInfo)(IRequest* self, IStatus* status, int level, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *start)(IRequest* self, IStatus* status, ITransaction* tra, int level) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *startAndSend)(IRequest* self, IStatus* status, ITransaction* tra, int level, unsigned msgType, unsigned length, const void* message) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *unwind)(IRequest* self, IStatus* status, int level) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedFree)(IRequest* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *free)(IRequest* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IRequest(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IRequest()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IREQUEST_VERSION;

		template <typename StatusType> void receive(StatusType* status, int level, unsigned msgType, unsigned length, void* message)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->receive(this, status, level, msgType, length, message);
			StatusType::checkException(status);
		}

		template <typename StatusType> void send(StatusType* status, int level, unsigned msgType, unsigned length, const void* message)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->send(this, status, level, msgType, length, message);
			StatusType::checkException(status);
		}

		template <typename StatusType> void getInfo(StatusType* status, int level, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getInfo(this, status, level, itemsLength, items, bufferLength, buffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void start(StatusType* status, ITransaction* tra, int level)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->start(this, status, tra, level);
			StatusType::checkException(status);
		}

		template <typename StatusType> void startAndSend(StatusType* status, ITransaction* tra, int level, unsigned msgType, unsigned length, const void* message)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->startAndSend(this, status, tra, level, msgType, length, message);
			StatusType::checkException(status);
		}

		template <typename StatusType> void unwind(StatusType* status, int level)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->unwind(this, status, level);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedFree(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedFree(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void free(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IRequest", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedFree(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->free(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IEVENTS_VERSION 4u

	class IEvents : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *deprecatedCancel)(IEvents* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *cancel)(IEvents* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IEvents(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IEvents()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IEVENTS_VERSION;

		template <typename StatusType> void deprecatedCancel(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedCancel(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void cancel(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IEvents", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedCancel(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->cancel(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IATTACHMENT_VERSION 5u

	class IAttachment : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *getInfo)(IAttachment* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *startTransaction)(IAttachment* self, IStatus* status, unsigned tpbLength, const unsigned char* tpb) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *reconnectTransaction)(IAttachment* self, IStatus* status, unsigned length, const unsigned char* id) CLOOP_NOEXCEPT;
			IRequest* (CLOOP_CARG *compileRequest)(IAttachment* self, IStatus* status, unsigned blrLength, const unsigned char* blr) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *transactRequest)(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned blrLength, const unsigned char* blr, unsigned inMsgLength, const unsigned char* inMsg, unsigned outMsgLength, unsigned char* outMsg) CLOOP_NOEXCEPT;
			IBlob* (CLOOP_CARG *createBlob)(IAttachment* self, IStatus* status, ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb) CLOOP_NOEXCEPT;
			IBlob* (CLOOP_CARG *openBlob)(IAttachment* self, IStatus* status, ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getSlice)(IAttachment* self, IStatus* status, ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *putSlice)(IAttachment* self, IStatus* status, ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *executeDyn)(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned length, const unsigned char* dyn) CLOOP_NOEXCEPT;
			IStatement* (CLOOP_CARG *prepare)(IAttachment* self, IStatus* status, ITransaction* tra, unsigned stmtLength, const char* sqlStmt, unsigned dialect, unsigned flags) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *execute)(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, void* outBuffer) CLOOP_NOEXCEPT;
			IResultSet* (CLOOP_CARG *openCursor)(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, const char* cursorName, unsigned cursorFlags) CLOOP_NOEXCEPT;
			IEvents* (CLOOP_CARG *queEvents)(IAttachment* self, IStatus* status, IEventCallback* callback, unsigned length, const unsigned char* events) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *cancelOperation)(IAttachment* self, IStatus* status, int option) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *ping)(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedDetach)(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deprecatedDropDatabase)(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getIdleTimeout)(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setIdleTimeout)(IAttachment* self, IStatus* status, unsigned timeOut) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getStatementTimeout)(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setStatementTimeout)(IAttachment* self, IStatus* status, unsigned timeOut) CLOOP_NOEXCEPT;
			IBatch* (CLOOP_CARG *createBatch)(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par) CLOOP_NOEXCEPT;
			IReplicator* (CLOOP_CARG *createReplicator)(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *detach)(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *dropDatabase)(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IAttachment(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IAttachment()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IATTACHMENT_VERSION;

		template <typename StatusType> void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getInfo(this, status, itemsLength, items, bufferLength, buffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> ITransaction* startTransaction(StatusType* status, unsigned tpbLength, const unsigned char* tpb)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->startTransaction(this, status, tpbLength, tpb);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ITransaction* reconnectTransaction(StatusType* status, unsigned length, const unsigned char* id)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->reconnectTransaction(this, status, length, id);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IRequest* compileRequest(StatusType* status, unsigned blrLength, const unsigned char* blr)
		{
			StatusType::clearException(status);
			IRequest* ret = static_cast<VTable*>(this->cloopVTable)->compileRequest(this, status, blrLength, blr);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void transactRequest(StatusType* status, ITransaction* transaction, unsigned blrLength, const unsigned char* blr, unsigned inMsgLength, const unsigned char* inMsg, unsigned outMsgLength, unsigned char* outMsg)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->transactRequest(this, status, transaction, blrLength, blr, inMsgLength, inMsg, outMsgLength, outMsg);
			StatusType::checkException(status);
		}

		template <typename StatusType> IBlob* createBlob(StatusType* status, ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb)
		{
			StatusType::clearException(status);
			IBlob* ret = static_cast<VTable*>(this->cloopVTable)->createBlob(this, status, transaction, id, bpbLength, bpb);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IBlob* openBlob(StatusType* status, ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb)
		{
			StatusType::clearException(status);
			IBlob* ret = static_cast<VTable*>(this->cloopVTable)->openBlob(this, status, transaction, id, bpbLength, bpb);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int getSlice(StatusType* status, ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->getSlice(this, status, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void putSlice(StatusType* status, ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->putSlice(this, status, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice);
			StatusType::checkException(status);
		}

		template <typename StatusType> void executeDyn(StatusType* status, ITransaction* transaction, unsigned length, const unsigned char* dyn)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->executeDyn(this, status, transaction, length, dyn);
			StatusType::checkException(status);
		}

		template <typename StatusType> IStatement* prepare(StatusType* status, ITransaction* tra, unsigned stmtLength, const char* sqlStmt, unsigned dialect, unsigned flags)
		{
			StatusType::clearException(status);
			IStatement* ret = static_cast<VTable*>(this->cloopVTable)->prepare(this, status, tra, stmtLength, sqlStmt, dialect, flags);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ITransaction* execute(StatusType* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, void* outBuffer)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->execute(this, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, outBuffer);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IResultSet* openCursor(StatusType* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, const char* cursorName, unsigned cursorFlags)
		{
			StatusType::clearException(status);
			IResultSet* ret = static_cast<VTable*>(this->cloopVTable)->openCursor(this, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, cursorName, cursorFlags);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IEvents* queEvents(StatusType* status, IEventCallback* callback, unsigned length, const unsigned char* events)
		{
			StatusType::clearException(status);
			IEvents* ret = static_cast<VTable*>(this->cloopVTable)->queEvents(this, status, callback, length, events);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void cancelOperation(StatusType* status, int option)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->cancelOperation(this, status, option);
			StatusType::checkException(status);
		}

		template <typename StatusType> void ping(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->ping(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedDetach(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedDetach(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deprecatedDropDatabase(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedDropDatabase(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> unsigned getIdleTimeout(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IAttachment", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getIdleTimeout(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setIdleTimeout(StatusType* status, unsigned timeOut)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IAttachment", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setIdleTimeout(this, status, timeOut);
			StatusType::checkException(status);
		}

		template <typename StatusType> unsigned getStatementTimeout(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IAttachment", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getStatementTimeout(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setStatementTimeout(StatusType* status, unsigned timeOut)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IAttachment", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setStatementTimeout(this, status, timeOut);
			StatusType::checkException(status);
		}

		template <typename StatusType> IBatch* createBatch(StatusType* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IAttachment", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			IBatch* ret = static_cast<VTable*>(this->cloopVTable)->createBatch(this, status, transaction, stmtLength, sqlStmt, dialect, inMetadata, parLength, par);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IReplicator* createReplicator(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IAttachment", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			IReplicator* ret = static_cast<VTable*>(this->cloopVTable)->createReplicator(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void detach(StatusType* status)
		{
			if (cloopVTable->version < 5)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IAttachment", cloopVTable->version, 5);
					StatusType::checkException(status);
				}
				else {
					deprecatedDetach(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->detach(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void dropDatabase(StatusType* status)
		{
			if (cloopVTable->version < 5)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IAttachment", cloopVTable->version, 5);
					StatusType::checkException(status);
				}
				else {
					deprecatedDropDatabase(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->dropDatabase(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ISERVICE_VERSION 5u

	class IService : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *deprecatedDetach)(IService* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *query)(IService* self, IStatus* status, unsigned sendLength, const unsigned char* sendItems, unsigned receiveLength, const unsigned char* receiveItems, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *start)(IService* self, IStatus* status, unsigned spbLength, const unsigned char* spb) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *detach)(IService* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *cancel)(IService* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IService(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IService()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ISERVICE_VERSION;

		template <typename StatusType> void deprecatedDetach(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deprecatedDetach(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void query(StatusType* status, unsigned sendLength, const unsigned char* sendItems, unsigned receiveLength, const unsigned char* receiveItems, unsigned bufferLength, unsigned char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->query(this, status, sendLength, sendItems, receiveLength, receiveItems, bufferLength, buffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void start(StatusType* status, unsigned spbLength, const unsigned char* spb)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->start(this, status, spbLength, spb);
			StatusType::checkException(status);
		}

		template <typename StatusType> void detach(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				if (FB_UsedInYValve) {
					StatusType::setVersionError(status, "IService", cloopVTable->version, 4);
					StatusType::checkException(status);
				}
				else {
					deprecatedDetach(status);
				}
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->detach(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void cancel(StatusType* status)
		{
			if (cloopVTable->version < 5)
			{
				StatusType::setVersionError(status, "IService", cloopVTable->version, 5);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->cancel(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IPROVIDER_VERSION 4u

	class IProvider : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			IAttachment* (CLOOP_CARG *attachDatabase)(IProvider* self, IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb) CLOOP_NOEXCEPT;
			IAttachment* (CLOOP_CARG *createDatabase)(IProvider* self, IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb) CLOOP_NOEXCEPT;
			IService* (CLOOP_CARG *attachServiceManager)(IProvider* self, IStatus* status, const char* service, unsigned spbLength, const unsigned char* spb) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *shutdown)(IProvider* self, IStatus* status, unsigned timeout, const int reason) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setDbCryptCallback)(IProvider* self, IStatus* status, ICryptKeyCallback* cryptCallback) CLOOP_NOEXCEPT;
		};

	protected:
		IProvider(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IProvider()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPROVIDER_VERSION;

		template <typename StatusType> IAttachment* attachDatabase(StatusType* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb)
		{
			StatusType::clearException(status);
			IAttachment* ret = static_cast<VTable*>(this->cloopVTable)->attachDatabase(this, status, fileName, dpbLength, dpb);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IAttachment* createDatabase(StatusType* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb)
		{
			StatusType::clearException(status);
			IAttachment* ret = static_cast<VTable*>(this->cloopVTable)->createDatabase(this, status, fileName, dpbLength, dpb);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IService* attachServiceManager(StatusType* status, const char* service, unsigned spbLength, const unsigned char* spb)
		{
			StatusType::clearException(status);
			IService* ret = static_cast<VTable*>(this->cloopVTable)->attachServiceManager(this, status, service, spbLength, spb);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void shutdown(StatusType* status, unsigned timeout, const int reason)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->shutdown(this, status, timeout, reason);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setDbCryptCallback(StatusType* status, ICryptKeyCallback* cryptCallback)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setDbCryptCallback(this, status, cryptCallback);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IDTC_START_VERSION 3u

	class IDtcStart : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *addAttachment)(IDtcStart* self, IStatus* status, IAttachment* att) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *addWithTpb)(IDtcStart* self, IStatus* status, IAttachment* att, unsigned length, const unsigned char* tpb) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *start)(IDtcStart* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IDtcStart(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IDtcStart()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IDTC_START_VERSION;

		template <typename StatusType> void addAttachment(StatusType* status, IAttachment* att)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->addAttachment(this, status, att);
			StatusType::checkException(status);
		}

		template <typename StatusType> void addWithTpb(StatusType* status, IAttachment* att, unsigned length, const unsigned char* tpb)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->addWithTpb(this, status, att, length, tpb);
			StatusType::checkException(status);
		}

		template <typename StatusType> ITransaction* start(StatusType* status)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->start(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IDTC_VERSION 2u

	class IDtc : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			ITransaction* (CLOOP_CARG *join)(IDtc* self, IStatus* status, ITransaction* one, ITransaction* two) CLOOP_NOEXCEPT;
			IDtcStart* (CLOOP_CARG *startBuilder)(IDtc* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IDtc(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IDtc()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IDTC_VERSION;

		template <typename StatusType> ITransaction* join(StatusType* status, ITransaction* one, ITransaction* two)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->join(this, status, one, two);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IDtcStart* startBuilder(StatusType* status)
		{
			StatusType::clearException(status);
			IDtcStart* ret = static_cast<VTable*>(this->cloopVTable)->startBuilder(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IAUTH_VERSION 4u

	class IAuth : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
		};

	protected:
		IAuth(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IAuth()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IAUTH_VERSION;

		static CLOOP_CONSTEXPR int AUTH_FAILED = -1;
		static CLOOP_CONSTEXPR int AUTH_SUCCESS = 0;
		static CLOOP_CONSTEXPR int AUTH_MORE_DATA = 1;
		static CLOOP_CONSTEXPR int AUTH_CONTINUE = 2;
	};

#define FIREBIRD_IWRITER_VERSION 2u

	class IWriter : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *reset)(IWriter* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *add)(IWriter* self, IStatus* status, const char* name) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setType)(IWriter* self, IStatus* status, const char* value) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setDb)(IWriter* self, IStatus* status, const char* value) CLOOP_NOEXCEPT;
		};

	protected:
		IWriter(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IWriter()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IWRITER_VERSION;

		void reset()
		{
			static_cast<VTable*>(this->cloopVTable)->reset(this);
		}

		template <typename StatusType> void add(StatusType* status, const char* name)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->add(this, status, name);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setType(StatusType* status, const char* value)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setType(this, status, value);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setDb(StatusType* status, const char* value)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setDb(this, status, value);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ISERVER_BLOCK_VERSION 2u

	class IServerBlock : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getLogin)(IServerBlock* self) CLOOP_NOEXCEPT;
			const unsigned char* (CLOOP_CARG *getData)(IServerBlock* self, unsigned* length) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *putData)(IServerBlock* self, IStatus* status, unsigned length, const void* data) CLOOP_NOEXCEPT;
			ICryptKey* (CLOOP_CARG *newKey)(IServerBlock* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IServerBlock(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IServerBlock()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ISERVER_BLOCK_VERSION;

		const char* getLogin()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getLogin(this);
			return ret;
		}

		const unsigned char* getData(unsigned* length)
		{
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->getData(this, length);
			return ret;
		}

		template <typename StatusType> void putData(StatusType* status, unsigned length, const void* data)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->putData(this, status, length, data);
			StatusType::checkException(status);
		}

		template <typename StatusType> ICryptKey* newKey(StatusType* status)
		{
			StatusType::clearException(status);
			ICryptKey* ret = static_cast<VTable*>(this->cloopVTable)->newKey(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_ICLIENT_BLOCK_VERSION 4u

	class IClientBlock : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			const char* (CLOOP_CARG *getLogin)(IClientBlock* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getPassword)(IClientBlock* self) CLOOP_NOEXCEPT;
			const unsigned char* (CLOOP_CARG *getData)(IClientBlock* self, unsigned* length) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *putData)(IClientBlock* self, IStatus* status, unsigned length, const void* data) CLOOP_NOEXCEPT;
			ICryptKey* (CLOOP_CARG *newKey)(IClientBlock* self, IStatus* status) CLOOP_NOEXCEPT;
			IAuthBlock* (CLOOP_CARG *getAuthBlock)(IClientBlock* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IClientBlock(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IClientBlock()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ICLIENT_BLOCK_VERSION;

		const char* getLogin()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getLogin(this);
			return ret;
		}

		const char* getPassword()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getPassword(this);
			return ret;
		}

		const unsigned char* getData(unsigned* length)
		{
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->getData(this, length);
			return ret;
		}

		template <typename StatusType> void putData(StatusType* status, unsigned length, const void* data)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->putData(this, status, length, data);
			StatusType::checkException(status);
		}

		template <typename StatusType> ICryptKey* newKey(StatusType* status)
		{
			StatusType::clearException(status);
			ICryptKey* ret = static_cast<VTable*>(this->cloopVTable)->newKey(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IAuthBlock* getAuthBlock(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IClientBlock", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			IAuthBlock* ret = static_cast<VTable*>(this->cloopVTable)->getAuthBlock(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_ISERVER_VERSION 6u

	class IServer : public IAuth
	{
	public:
		struct VTable : public IAuth::VTable
		{
			int (CLOOP_CARG *authenticate)(IServer* self, IStatus* status, IServerBlock* sBlock, IWriter* writerInterface) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setDbCryptCallback)(IServer* self, IStatus* status, ICryptKeyCallback* cryptCallback) CLOOP_NOEXCEPT;
		};

	protected:
		IServer(DoNotInherit)
			: IAuth(DoNotInherit())
		{
		}

		~IServer()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ISERVER_VERSION;

		template <typename StatusType> int authenticate(StatusType* status, IServerBlock* sBlock, IWriter* writerInterface)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->authenticate(this, status, sBlock, writerInterface);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setDbCryptCallback(StatusType* status, ICryptKeyCallback* cryptCallback)
		{
			if (cloopVTable->version < 6)
			{
				StatusType::setVersionError(status, "IServer", cloopVTable->version, 6);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setDbCryptCallback(this, status, cryptCallback);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ICLIENT_VERSION 5u

	class IClient : public IAuth
	{
	public:
		struct VTable : public IAuth::VTable
		{
			int (CLOOP_CARG *authenticate)(IClient* self, IStatus* status, IClientBlock* cBlock) CLOOP_NOEXCEPT;
		};

	protected:
		IClient(DoNotInherit)
			: IAuth(DoNotInherit())
		{
		}

		~IClient()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ICLIENT_VERSION;

		template <typename StatusType> int authenticate(StatusType* status, IClientBlock* cBlock)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->authenticate(this, status, cBlock);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IUSER_FIELD_VERSION 2u

	class IUserField : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			int (CLOOP_CARG *entered)(IUserField* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *specified)(IUserField* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setEntered)(IUserField* self, IStatus* status, int newValue) CLOOP_NOEXCEPT;
		};

	protected:
		IUserField(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IUserField()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IUSER_FIELD_VERSION;

		int entered()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->entered(this);
			return ret;
		}

		int specified()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->specified(this);
			return ret;
		}

		template <typename StatusType> void setEntered(StatusType* status, int newValue)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setEntered(this, status, newValue);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ICHAR_USER_FIELD_VERSION 3u

	class ICharUserField : public IUserField
	{
	public:
		struct VTable : public IUserField::VTable
		{
			const char* (CLOOP_CARG *get)(ICharUserField* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *set)(ICharUserField* self, IStatus* status, const char* newValue) CLOOP_NOEXCEPT;
		};

	protected:
		ICharUserField(DoNotInherit)
			: IUserField(DoNotInherit())
		{
		}

		~ICharUserField()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ICHAR_USER_FIELD_VERSION;

		const char* get()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->get(this);
			return ret;
		}

		template <typename StatusType> void set(StatusType* status, const char* newValue)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->set(this, status, newValue);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IINT_USER_FIELD_VERSION 3u

	class IIntUserField : public IUserField
	{
	public:
		struct VTable : public IUserField::VTable
		{
			int (CLOOP_CARG *get)(IIntUserField* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *set)(IIntUserField* self, IStatus* status, int newValue) CLOOP_NOEXCEPT;
		};

	protected:
		IIntUserField(DoNotInherit)
			: IUserField(DoNotInherit())
		{
		}

		~IIntUserField()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IINT_USER_FIELD_VERSION;

		int get()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->get(this);
			return ret;
		}

		template <typename StatusType> void set(StatusType* status, int newValue)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->set(this, status, newValue);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IUSER_VERSION 2u

	class IUser : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			unsigned (CLOOP_CARG *operation)(IUser* self) CLOOP_NOEXCEPT;
			ICharUserField* (CLOOP_CARG *userName)(IUser* self) CLOOP_NOEXCEPT;
			ICharUserField* (CLOOP_CARG *password)(IUser* self) CLOOP_NOEXCEPT;
			ICharUserField* (CLOOP_CARG *firstName)(IUser* self) CLOOP_NOEXCEPT;
			ICharUserField* (CLOOP_CARG *lastName)(IUser* self) CLOOP_NOEXCEPT;
			ICharUserField* (CLOOP_CARG *middleName)(IUser* self) CLOOP_NOEXCEPT;
			ICharUserField* (CLOOP_CARG *comment)(IUser* self) CLOOP_NOEXCEPT;
			ICharUserField* (CLOOP_CARG *attributes)(IUser* self) CLOOP_NOEXCEPT;
			IIntUserField* (CLOOP_CARG *active)(IUser* self) CLOOP_NOEXCEPT;
			IIntUserField* (CLOOP_CARG *admin)(IUser* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *clear)(IUser* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IUser(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IUser()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IUSER_VERSION;

		static CLOOP_CONSTEXPR unsigned OP_USER_ADD = 1;
		static CLOOP_CONSTEXPR unsigned OP_USER_MODIFY = 2;
		static CLOOP_CONSTEXPR unsigned OP_USER_DELETE = 3;
		static CLOOP_CONSTEXPR unsigned OP_USER_DISPLAY = 4;
		static CLOOP_CONSTEXPR unsigned OP_USER_SET_MAP = 5;
		static CLOOP_CONSTEXPR unsigned OP_USER_DROP_MAP = 6;

		unsigned operation()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->operation(this);
			return ret;
		}

		ICharUserField* userName()
		{
			ICharUserField* ret = static_cast<VTable*>(this->cloopVTable)->userName(this);
			return ret;
		}

		ICharUserField* password()
		{
			ICharUserField* ret = static_cast<VTable*>(this->cloopVTable)->password(this);
			return ret;
		}

		ICharUserField* firstName()
		{
			ICharUserField* ret = static_cast<VTable*>(this->cloopVTable)->firstName(this);
			return ret;
		}

		ICharUserField* lastName()
		{
			ICharUserField* ret = static_cast<VTable*>(this->cloopVTable)->lastName(this);
			return ret;
		}

		ICharUserField* middleName()
		{
			ICharUserField* ret = static_cast<VTable*>(this->cloopVTable)->middleName(this);
			return ret;
		}

		ICharUserField* comment()
		{
			ICharUserField* ret = static_cast<VTable*>(this->cloopVTable)->comment(this);
			return ret;
		}

		ICharUserField* attributes()
		{
			ICharUserField* ret = static_cast<VTable*>(this->cloopVTable)->attributes(this);
			return ret;
		}

		IIntUserField* active()
		{
			IIntUserField* ret = static_cast<VTable*>(this->cloopVTable)->active(this);
			return ret;
		}

		IIntUserField* admin()
		{
			IIntUserField* ret = static_cast<VTable*>(this->cloopVTable)->admin(this);
			return ret;
		}

		template <typename StatusType> void clear(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->clear(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ILIST_USERS_VERSION 2u

	class IListUsers : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *list)(IListUsers* self, IStatus* status, IUser* user) CLOOP_NOEXCEPT;
		};

	protected:
		IListUsers(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IListUsers()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ILIST_USERS_VERSION;

		template <typename StatusType> void list(StatusType* status, IUser* user)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->list(this, status, user);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ILOGON_INFO_VERSION 3u

	class ILogonInfo : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *name)(ILogonInfo* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *role)(ILogonInfo* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *networkProtocol)(ILogonInfo* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *remoteAddress)(ILogonInfo* self) CLOOP_NOEXCEPT;
			const unsigned char* (CLOOP_CARG *authBlock)(ILogonInfo* self, unsigned* length) CLOOP_NOEXCEPT;
			IAttachment* (CLOOP_CARG *attachment)(ILogonInfo* self, IStatus* status) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *transaction)(ILogonInfo* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		ILogonInfo(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ILogonInfo()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ILOGON_INFO_VERSION;

		const char* name()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->name(this);
			return ret;
		}

		const char* role()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->role(this);
			return ret;
		}

		const char* networkProtocol()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->networkProtocol(this);
			return ret;
		}

		const char* remoteAddress()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->remoteAddress(this);
			return ret;
		}

		const unsigned char* authBlock(unsigned* length)
		{
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->authBlock(this, length);
			return ret;
		}

		template <typename StatusType> IAttachment* attachment(StatusType* status)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "ILogonInfo", cloopVTable->version, 3);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			IAttachment* ret = static_cast<VTable*>(this->cloopVTable)->attachment(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ITransaction* transaction(StatusType* status)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "ILogonInfo", cloopVTable->version, 3);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->transaction(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IMANAGEMENT_VERSION 4u

	class IManagement : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			void (CLOOP_CARG *start)(IManagement* self, IStatus* status, ILogonInfo* logonInfo) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *execute)(IManagement* self, IStatus* status, IUser* user, IListUsers* callback) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *commit)(IManagement* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *rollback)(IManagement* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IManagement(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IManagement()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IMANAGEMENT_VERSION;

		template <typename StatusType> void start(StatusType* status, ILogonInfo* logonInfo)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->start(this, status, logonInfo);
			StatusType::checkException(status);
		}

		template <typename StatusType> int execute(StatusType* status, IUser* user, IListUsers* callback)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->execute(this, status, user, callback);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void commit(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->commit(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void rollback(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->rollback(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IAUTH_BLOCK_VERSION 2u

	class IAuthBlock : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getType)(IAuthBlock* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getName)(IAuthBlock* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getPlugin)(IAuthBlock* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getSecurityDb)(IAuthBlock* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getOriginalPlugin)(IAuthBlock* self) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *next)(IAuthBlock* self, IStatus* status) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *first)(IAuthBlock* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IAuthBlock(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IAuthBlock()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IAUTH_BLOCK_VERSION;

		const char* getType()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getType(this);
			return ret;
		}

		const char* getName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getName(this);
			return ret;
		}

		const char* getPlugin()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getPlugin(this);
			return ret;
		}

		const char* getSecurityDb()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getSecurityDb(this);
			return ret;
		}

		const char* getOriginalPlugin()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getOriginalPlugin(this);
			return ret;
		}

		template <typename StatusType> FB_BOOLEAN next(StatusType* status)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->next(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> FB_BOOLEAN first(StatusType* status)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->first(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IWIRE_CRYPT_PLUGIN_VERSION 5u

	class IWireCryptPlugin : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			const char* (CLOOP_CARG *getKnownTypes)(IWireCryptPlugin* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setKey)(IWireCryptPlugin* self, IStatus* status, ICryptKey* key) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *encrypt)(IWireCryptPlugin* self, IStatus* status, unsigned length, const void* from, void* to) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *decrypt)(IWireCryptPlugin* self, IStatus* status, unsigned length, const void* from, void* to) CLOOP_NOEXCEPT;
			const unsigned char* (CLOOP_CARG *getSpecificData)(IWireCryptPlugin* self, IStatus* status, const char* keyType, unsigned* length) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setSpecificData)(IWireCryptPlugin* self, IStatus* status, const char* keyType, unsigned length, const unsigned char* data) CLOOP_NOEXCEPT;
		};

	protected:
		IWireCryptPlugin(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IWireCryptPlugin()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IWIRE_CRYPT_PLUGIN_VERSION;

		template <typename StatusType> const char* getKnownTypes(StatusType* status)
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getKnownTypes(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setKey(StatusType* status, ICryptKey* key)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setKey(this, status, key);
			StatusType::checkException(status);
		}

		template <typename StatusType> void encrypt(StatusType* status, unsigned length, const void* from, void* to)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->encrypt(this, status, length, from, to);
			StatusType::checkException(status);
		}

		template <typename StatusType> void decrypt(StatusType* status, unsigned length, const void* from, void* to)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->decrypt(this, status, length, from, to);
			StatusType::checkException(status);
		}

		template <typename StatusType> const unsigned char* getSpecificData(StatusType* status, const char* keyType, unsigned* length)
		{
			if (cloopVTable->version < 5)
			{
				StatusType::setVersionError(status, "IWireCryptPlugin", cloopVTable->version, 5);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->getSpecificData(this, status, keyType, length);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void setSpecificData(StatusType* status, const char* keyType, unsigned length, const unsigned char* data)
		{
			if (cloopVTable->version < 5)
			{
				StatusType::setVersionError(status, "IWireCryptPlugin", cloopVTable->version, 5);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setSpecificData(this, status, keyType, length, data);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_ICRYPT_KEY_CALLBACK_VERSION 2u

	class ICryptKeyCallback : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			unsigned (CLOOP_CARG *callback)(ICryptKeyCallback* self, unsigned dataLength, const void* data, unsigned bufferLength, void* buffer) CLOOP_NOEXCEPT;
		};

	protected:
		ICryptKeyCallback(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ICryptKeyCallback()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ICRYPT_KEY_CALLBACK_VERSION;

		unsigned callback(unsigned dataLength, const void* data, unsigned bufferLength, void* buffer)
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->callback(this, dataLength, data, bufferLength, buffer);
			return ret;
		}
	};

#define FIREBIRD_IKEY_HOLDER_PLUGIN_VERSION 5u

	class IKeyHolderPlugin : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			int (CLOOP_CARG *keyCallback)(IKeyHolderPlugin* self, IStatus* status, ICryptKeyCallback* callback) CLOOP_NOEXCEPT;
			ICryptKeyCallback* (CLOOP_CARG *keyHandle)(IKeyHolderPlugin* self, IStatus* status, const char* keyName) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *useOnlyOwnKeys)(IKeyHolderPlugin* self, IStatus* status) CLOOP_NOEXCEPT;
			ICryptKeyCallback* (CLOOP_CARG *chainHandle)(IKeyHolderPlugin* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IKeyHolderPlugin(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IKeyHolderPlugin()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IKEY_HOLDER_PLUGIN_VERSION;

		template <typename StatusType> int keyCallback(StatusType* status, ICryptKeyCallback* callback)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->keyCallback(this, status, callback);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ICryptKeyCallback* keyHandle(StatusType* status, const char* keyName)
		{
			StatusType::clearException(status);
			ICryptKeyCallback* ret = static_cast<VTable*>(this->cloopVTable)->keyHandle(this, status, keyName);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> FB_BOOLEAN useOnlyOwnKeys(StatusType* status)
		{
			if (cloopVTable->version < 5)
			{
				StatusType::setVersionError(status, "IKeyHolderPlugin", cloopVTable->version, 5);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->useOnlyOwnKeys(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ICryptKeyCallback* chainHandle(StatusType* status)
		{
			if (cloopVTable->version < 5)
			{
				StatusType::setVersionError(status, "IKeyHolderPlugin", cloopVTable->version, 5);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			ICryptKeyCallback* ret = static_cast<VTable*>(this->cloopVTable)->chainHandle(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IDB_CRYPT_INFO_VERSION 3u

	class IDbCryptInfo : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			const char* (CLOOP_CARG *getDatabaseFullPath)(IDbCryptInfo* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IDbCryptInfo(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~IDbCryptInfo()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IDB_CRYPT_INFO_VERSION;

		template <typename StatusType> const char* getDatabaseFullPath(StatusType* status)
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getDatabaseFullPath(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IDB_CRYPT_PLUGIN_VERSION 5u

	class IDbCryptPlugin : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			void (CLOOP_CARG *setKey)(IDbCryptPlugin* self, IStatus* status, unsigned length, IKeyHolderPlugin** sources, const char* keyName) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *encrypt)(IDbCryptPlugin* self, IStatus* status, unsigned length, const void* from, void* to) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *decrypt)(IDbCryptPlugin* self, IStatus* status, unsigned length, const void* from, void* to) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setInfo)(IDbCryptPlugin* self, IStatus* status, IDbCryptInfo* info) CLOOP_NOEXCEPT;
		};

	protected:
		IDbCryptPlugin(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IDbCryptPlugin()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IDB_CRYPT_PLUGIN_VERSION;

		template <typename StatusType> void setKey(StatusType* status, unsigned length, IKeyHolderPlugin** sources, const char* keyName)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setKey(this, status, length, sources, keyName);
			StatusType::checkException(status);
		}

		template <typename StatusType> void encrypt(StatusType* status, unsigned length, const void* from, void* to)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->encrypt(this, status, length, from, to);
			StatusType::checkException(status);
		}

		template <typename StatusType> void decrypt(StatusType* status, unsigned length, const void* from, void* to)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->decrypt(this, status, length, from, to);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setInfo(StatusType* status, IDbCryptInfo* info)
		{
			if (cloopVTable->version < 5)
			{
				StatusType::setVersionError(status, "IDbCryptPlugin", cloopVTable->version, 5);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setInfo(this, status, info);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IEXTERNAL_CONTEXT_VERSION 2u

	class IExternalContext : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			IMaster* (CLOOP_CARG *getMaster)(IExternalContext* self) CLOOP_NOEXCEPT;
			IExternalEngine* (CLOOP_CARG *getEngine)(IExternalContext* self, IStatus* status) CLOOP_NOEXCEPT;
			IAttachment* (CLOOP_CARG *getAttachment)(IExternalContext* self, IStatus* status) CLOOP_NOEXCEPT;
			ITransaction* (CLOOP_CARG *getTransaction)(IExternalContext* self, IStatus* status) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getUserName)(IExternalContext* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getDatabaseName)(IExternalContext* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getClientCharSet)(IExternalContext* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *obtainInfoCode)(IExternalContext* self) CLOOP_NOEXCEPT;
			void* (CLOOP_CARG *getInfo)(IExternalContext* self, int code) CLOOP_NOEXCEPT;
			void* (CLOOP_CARG *setInfo)(IExternalContext* self, int code, void* value) CLOOP_NOEXCEPT;
		};

	protected:
		IExternalContext(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IExternalContext()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IEXTERNAL_CONTEXT_VERSION;

		IMaster* getMaster()
		{
			IMaster* ret = static_cast<VTable*>(this->cloopVTable)->getMaster(this);
			return ret;
		}

		template <typename StatusType> IExternalEngine* getEngine(StatusType* status)
		{
			StatusType::clearException(status);
			IExternalEngine* ret = static_cast<VTable*>(this->cloopVTable)->getEngine(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IAttachment* getAttachment(StatusType* status)
		{
			StatusType::clearException(status);
			IAttachment* ret = static_cast<VTable*>(this->cloopVTable)->getAttachment(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ITransaction* getTransaction(StatusType* status)
		{
			StatusType::clearException(status);
			ITransaction* ret = static_cast<VTable*>(this->cloopVTable)->getTransaction(this, status);
			StatusType::checkException(status);
			return ret;
		}

		const char* getUserName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getUserName(this);
			return ret;
		}

		const char* getDatabaseName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getDatabaseName(this);
			return ret;
		}

		const char* getClientCharSet()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getClientCharSet(this);
			return ret;
		}

		int obtainInfoCode()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->obtainInfoCode(this);
			return ret;
		}

		void* getInfo(int code)
		{
			void* ret = static_cast<VTable*>(this->cloopVTable)->getInfo(this, code);
			return ret;
		}

		void* setInfo(int code, void* value)
		{
			void* ret = static_cast<VTable*>(this->cloopVTable)->setInfo(this, code, value);
			return ret;
		}
	};

#define FIREBIRD_IEXTERNAL_RESULT_SET_VERSION 3u

	class IExternalResultSet : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			FB_BOOLEAN (CLOOP_CARG *fetch)(IExternalResultSet* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IExternalResultSet(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IExternalResultSet()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IEXTERNAL_RESULT_SET_VERSION;

		template <typename StatusType> FB_BOOLEAN fetch(StatusType* status)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->fetch(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IEXTERNAL_FUNCTION_VERSION 3u

	class IExternalFunction : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *getCharSet)(IExternalFunction* self, IStatus* status, IExternalContext* context, char* name, unsigned nameSize) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *execute)(IExternalFunction* self, IStatus* status, IExternalContext* context, void* inMsg, void* outMsg) CLOOP_NOEXCEPT;
		};

	protected:
		IExternalFunction(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IExternalFunction()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IEXTERNAL_FUNCTION_VERSION;

		template <typename StatusType> void getCharSet(StatusType* status, IExternalContext* context, char* name, unsigned nameSize)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getCharSet(this, status, context, name, nameSize);
			StatusType::checkException(status);
		}

		template <typename StatusType> void execute(StatusType* status, IExternalContext* context, void* inMsg, void* outMsg)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->execute(this, status, context, inMsg, outMsg);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IEXTERNAL_PROCEDURE_VERSION 3u

	class IExternalProcedure : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *getCharSet)(IExternalProcedure* self, IStatus* status, IExternalContext* context, char* name, unsigned nameSize) CLOOP_NOEXCEPT;
			IExternalResultSet* (CLOOP_CARG *open)(IExternalProcedure* self, IStatus* status, IExternalContext* context, void* inMsg, void* outMsg) CLOOP_NOEXCEPT;
		};

	protected:
		IExternalProcedure(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IExternalProcedure()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IEXTERNAL_PROCEDURE_VERSION;

		template <typename StatusType> void getCharSet(StatusType* status, IExternalContext* context, char* name, unsigned nameSize)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getCharSet(this, status, context, name, nameSize);
			StatusType::checkException(status);
		}

		template <typename StatusType> IExternalResultSet* open(StatusType* status, IExternalContext* context, void* inMsg, void* outMsg)
		{
			StatusType::clearException(status);
			IExternalResultSet* ret = static_cast<VTable*>(this->cloopVTable)->open(this, status, context, inMsg, outMsg);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IEXTERNAL_TRIGGER_VERSION 3u

	class IExternalTrigger : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *getCharSet)(IExternalTrigger* self, IStatus* status, IExternalContext* context, char* name, unsigned nameSize) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *execute)(IExternalTrigger* self, IStatus* status, IExternalContext* context, unsigned action, void* oldMsg, void* newMsg) CLOOP_NOEXCEPT;
		};

	protected:
		IExternalTrigger(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IExternalTrigger()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IEXTERNAL_TRIGGER_VERSION;

		static CLOOP_CONSTEXPR unsigned TYPE_BEFORE = 1;
		static CLOOP_CONSTEXPR unsigned TYPE_AFTER = 2;
		static CLOOP_CONSTEXPR unsigned TYPE_DATABASE = 3;
		static CLOOP_CONSTEXPR unsigned ACTION_INSERT = 1;
		static CLOOP_CONSTEXPR unsigned ACTION_UPDATE = 2;
		static CLOOP_CONSTEXPR unsigned ACTION_DELETE = 3;
		static CLOOP_CONSTEXPR unsigned ACTION_CONNECT = 4;
		static CLOOP_CONSTEXPR unsigned ACTION_DISCONNECT = 5;
		static CLOOP_CONSTEXPR unsigned ACTION_TRANS_START = 6;
		static CLOOP_CONSTEXPR unsigned ACTION_TRANS_COMMIT = 7;
		static CLOOP_CONSTEXPR unsigned ACTION_TRANS_ROLLBACK = 8;
		static CLOOP_CONSTEXPR unsigned ACTION_DDL = 9;

		template <typename StatusType> void getCharSet(StatusType* status, IExternalContext* context, char* name, unsigned nameSize)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getCharSet(this, status, context, name, nameSize);
			StatusType::checkException(status);
		}

		template <typename StatusType> void execute(StatusType* status, IExternalContext* context, unsigned action, void* oldMsg, void* newMsg)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->execute(this, status, context, action, oldMsg, newMsg);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IROUTINE_METADATA_VERSION 2u

	class IRoutineMetadata : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getPackage)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getName)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getEntryPoint)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getBody)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			IMessageMetadata* (CLOOP_CARG *getInputMetadata)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			IMessageMetadata* (CLOOP_CARG *getOutputMetadata)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			IMessageMetadata* (CLOOP_CARG *getTriggerMetadata)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getTriggerTable)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getTriggerType)(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IRoutineMetadata(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IRoutineMetadata()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IROUTINE_METADATA_VERSION;

		template <typename StatusType> const char* getPackage(StatusType* status) const
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getPackage(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getName(StatusType* status) const
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getName(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getEntryPoint(StatusType* status) const
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getEntryPoint(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getBody(StatusType* status) const
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getBody(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMessageMetadata* getInputMetadata(StatusType* status) const
		{
			StatusType::clearException(status);
			IMessageMetadata* ret = static_cast<VTable*>(this->cloopVTable)->getInputMetadata(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMessageMetadata* getOutputMetadata(StatusType* status) const
		{
			StatusType::clearException(status);
			IMessageMetadata* ret = static_cast<VTable*>(this->cloopVTable)->getOutputMetadata(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IMessageMetadata* getTriggerMetadata(StatusType* status) const
		{
			StatusType::clearException(status);
			IMessageMetadata* ret = static_cast<VTable*>(this->cloopVTable)->getTriggerMetadata(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getTriggerTable(StatusType* status) const
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getTriggerTable(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getTriggerType(StatusType* status) const
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getTriggerType(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IEXTERNAL_ENGINE_VERSION 4u

	class IExternalEngine : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			void (CLOOP_CARG *open)(IExternalEngine* self, IStatus* status, IExternalContext* context, char* charSet, unsigned charSetSize) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *openAttachment)(IExternalEngine* self, IStatus* status, IExternalContext* context) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *closeAttachment)(IExternalEngine* self, IStatus* status, IExternalContext* context) CLOOP_NOEXCEPT;
			IExternalFunction* (CLOOP_CARG *makeFunction)(IExternalEngine* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) CLOOP_NOEXCEPT;
			IExternalProcedure* (CLOOP_CARG *makeProcedure)(IExternalEngine* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) CLOOP_NOEXCEPT;
			IExternalTrigger* (CLOOP_CARG *makeTrigger)(IExternalEngine* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* fieldsBuilder) CLOOP_NOEXCEPT;
		};

	protected:
		IExternalEngine(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IExternalEngine()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IEXTERNAL_ENGINE_VERSION;

		template <typename StatusType> void open(StatusType* status, IExternalContext* context, char* charSet, unsigned charSetSize)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->open(this, status, context, charSet, charSetSize);
			StatusType::checkException(status);
		}

		template <typename StatusType> void openAttachment(StatusType* status, IExternalContext* context)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->openAttachment(this, status, context);
			StatusType::checkException(status);
		}

		template <typename StatusType> void closeAttachment(StatusType* status, IExternalContext* context)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->closeAttachment(this, status, context);
			StatusType::checkException(status);
		}

		template <typename StatusType> IExternalFunction* makeFunction(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder)
		{
			StatusType::clearException(status);
			IExternalFunction* ret = static_cast<VTable*>(this->cloopVTable)->makeFunction(this, status, context, metadata, inBuilder, outBuilder);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IExternalProcedure* makeProcedure(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder)
		{
			StatusType::clearException(status);
			IExternalProcedure* ret = static_cast<VTable*>(this->cloopVTable)->makeProcedure(this, status, context, metadata, inBuilder, outBuilder);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IExternalTrigger* makeTrigger(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* fieldsBuilder)
		{
			StatusType::clearException(status);
			IExternalTrigger* ret = static_cast<VTable*>(this->cloopVTable)->makeTrigger(this, status, context, metadata, fieldsBuilder);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_ITIMER_VERSION 3u

	class ITimer : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			void (CLOOP_CARG *handler)(ITimer* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITimer(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~ITimer()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITIMER_VERSION;

		void handler()
		{
			static_cast<VTable*>(this->cloopVTable)->handler(this);
		}
	};

#define FIREBIRD_ITIMER_CONTROL_VERSION 2u

	class ITimerControl : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *start)(ITimerControl* self, IStatus* status, ITimer* timer, ISC_UINT64 microSeconds) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *stop)(ITimerControl* self, IStatus* status, ITimer* timer) CLOOP_NOEXCEPT;
		};

	protected:
		ITimerControl(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITimerControl()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITIMER_CONTROL_VERSION;

		template <typename StatusType> void start(StatusType* status, ITimer* timer, ISC_UINT64 microSeconds)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->start(this, status, timer, microSeconds);
			StatusType::checkException(status);
		}

		template <typename StatusType> void stop(StatusType* status, ITimer* timer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->stop(this, status, timer);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IVERSION_CALLBACK_VERSION 2u

	class IVersionCallback : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *callback)(IVersionCallback* self, IStatus* status, const char* text) CLOOP_NOEXCEPT;
		};

	protected:
		IVersionCallback(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IVersionCallback()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IVERSION_CALLBACK_VERSION;

		template <typename StatusType> void callback(StatusType* status, const char* text)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->callback(this, status, text);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IUTIL_VERSION 4u

	class IUtil : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *getFbVersion)(IUtil* self, IStatus* status, IAttachment* att, IVersionCallback* callback) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *loadBlob)(IUtil* self, IStatus* status, ISC_QUAD* blobId, IAttachment* att, ITransaction* tra, const char* file, FB_BOOLEAN txt) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *dumpBlob)(IUtil* self, IStatus* status, ISC_QUAD* blobId, IAttachment* att, ITransaction* tra, const char* file, FB_BOOLEAN txt) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *getPerfCounters)(IUtil* self, IStatus* status, IAttachment* att, const char* countersSet, ISC_INT64* counters) CLOOP_NOEXCEPT;
			IAttachment* (CLOOP_CARG *executeCreateDatabase)(IUtil* self, IStatus* status, unsigned stmtLength, const char* creatDBstatement, unsigned dialect, FB_BOOLEAN* stmtIsCreateDb) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *decodeDate)(IUtil* self, ISC_DATE date, unsigned* year, unsigned* month, unsigned* day) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *decodeTime)(IUtil* self, ISC_TIME time, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions) CLOOP_NOEXCEPT;
			ISC_DATE (CLOOP_CARG *encodeDate)(IUtil* self, unsigned year, unsigned month, unsigned day) CLOOP_NOEXCEPT;
			ISC_TIME (CLOOP_CARG *encodeTime)(IUtil* self, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *formatStatus)(IUtil* self, char* buffer, unsigned bufferSize, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getClientVersion)(IUtil* self) CLOOP_NOEXCEPT;
			IXpbBuilder* (CLOOP_CARG *getXpbBuilder)(IUtil* self, IStatus* status, unsigned kind, const unsigned char* buf, unsigned len) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *setOffsets)(IUtil* self, IStatus* status, IMessageMetadata* metadata, IOffsetsCallback* callback) CLOOP_NOEXCEPT;
			IDecFloat16* (CLOOP_CARG *getDecFloat16)(IUtil* self, IStatus* status) CLOOP_NOEXCEPT;
			IDecFloat34* (CLOOP_CARG *getDecFloat34)(IUtil* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *decodeTimeTz)(IUtil* self, IStatus* status, const ISC_TIME_TZ* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *decodeTimeStampTz)(IUtil* self, IStatus* status, const ISC_TIMESTAMP_TZ* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *encodeTimeTz)(IUtil* self, IStatus* status, ISC_TIME_TZ* timeTz, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *encodeTimeStampTz)(IUtil* self, IStatus* status, ISC_TIMESTAMP_TZ* timeStampTz, unsigned year, unsigned month, unsigned day, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone) CLOOP_NOEXCEPT;
			IInt128* (CLOOP_CARG *getInt128)(IUtil* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *decodeTimeTzEx)(IUtil* self, IStatus* status, const ISC_TIME_TZ_EX* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *decodeTimeStampTzEx)(IUtil* self, IStatus* status, const ISC_TIMESTAMP_TZ_EX* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) CLOOP_NOEXCEPT;
		};

	protected:
		IUtil(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IUtil()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IUTIL_VERSION;

		template <typename StatusType> void getFbVersion(StatusType* status, IAttachment* att, IVersionCallback* callback)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getFbVersion(this, status, att, callback);
			StatusType::checkException(status);
		}

		template <typename StatusType> void loadBlob(StatusType* status, ISC_QUAD* blobId, IAttachment* att, ITransaction* tra, const char* file, FB_BOOLEAN txt)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->loadBlob(this, status, blobId, att, tra, file, txt);
			StatusType::checkException(status);
		}

		template <typename StatusType> void dumpBlob(StatusType* status, ISC_QUAD* blobId, IAttachment* att, ITransaction* tra, const char* file, FB_BOOLEAN txt)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->dumpBlob(this, status, blobId, att, tra, file, txt);
			StatusType::checkException(status);
		}

		template <typename StatusType> void getPerfCounters(StatusType* status, IAttachment* att, const char* countersSet, ISC_INT64* counters)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->getPerfCounters(this, status, att, countersSet, counters);
			StatusType::checkException(status);
		}

		template <typename StatusType> IAttachment* executeCreateDatabase(StatusType* status, unsigned stmtLength, const char* creatDBstatement, unsigned dialect, FB_BOOLEAN* stmtIsCreateDb)
		{
			StatusType::clearException(status);
			IAttachment* ret = static_cast<VTable*>(this->cloopVTable)->executeCreateDatabase(this, status, stmtLength, creatDBstatement, dialect, stmtIsCreateDb);
			StatusType::checkException(status);
			return ret;
		}

		void decodeDate(ISC_DATE date, unsigned* year, unsigned* month, unsigned* day)
		{
			static_cast<VTable*>(this->cloopVTable)->decodeDate(this, date, year, month, day);
		}

		void decodeTime(ISC_TIME time, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions)
		{
			static_cast<VTable*>(this->cloopVTable)->decodeTime(this, time, hours, minutes, seconds, fractions);
		}

		ISC_DATE encodeDate(unsigned year, unsigned month, unsigned day)
		{
			ISC_DATE ret = static_cast<VTable*>(this->cloopVTable)->encodeDate(this, year, month, day);
			return ret;
		}

		ISC_TIME encodeTime(unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions)
		{
			ISC_TIME ret = static_cast<VTable*>(this->cloopVTable)->encodeTime(this, hours, minutes, seconds, fractions);
			return ret;
		}

		unsigned formatStatus(char* buffer, unsigned bufferSize, IStatus* status)
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->formatStatus(this, buffer, bufferSize, status);
			return ret;
		}

		unsigned getClientVersion()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getClientVersion(this);
			return ret;
		}

		template <typename StatusType> IXpbBuilder* getXpbBuilder(StatusType* status, unsigned kind, const unsigned char* buf, unsigned len)
		{
			StatusType::clearException(status);
			IXpbBuilder* ret = static_cast<VTable*>(this->cloopVTable)->getXpbBuilder(this, status, kind, buf, len);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned setOffsets(StatusType* status, IMessageMetadata* metadata, IOffsetsCallback* callback)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->setOffsets(this, status, metadata, callback);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IDecFloat16* getDecFloat16(StatusType* status)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 3);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			IDecFloat16* ret = static_cast<VTable*>(this->cloopVTable)->getDecFloat16(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IDecFloat34* getDecFloat34(StatusType* status)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 3);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			IDecFloat34* ret = static_cast<VTable*>(this->cloopVTable)->getDecFloat34(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void decodeTimeTz(StatusType* status, const ISC_TIME_TZ* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 3);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->decodeTimeTz(this, status, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void decodeTimeStampTz(StatusType* status, const ISC_TIMESTAMP_TZ* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 3);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->decodeTimeStampTz(this, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void encodeTimeTz(StatusType* status, ISC_TIME_TZ* timeTz, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 3);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->encodeTimeTz(this, status, timeTz, hours, minutes, seconds, fractions, timeZone);
			StatusType::checkException(status);
		}

		template <typename StatusType> void encodeTimeStampTz(StatusType* status, ISC_TIMESTAMP_TZ* timeStampTz, unsigned year, unsigned month, unsigned day, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 3);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->encodeTimeStampTz(this, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZone);
			StatusType::checkException(status);
		}

		template <typename StatusType> IInt128* getInt128(StatusType* status)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			IInt128* ret = static_cast<VTable*>(this->cloopVTable)->getInt128(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void decodeTimeTzEx(StatusType* status, const ISC_TIME_TZ_EX* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->decodeTimeTzEx(this, status, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void decodeTimeStampTzEx(StatusType* status, const ISC_TIMESTAMP_TZ_EX* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "IUtil", cloopVTable->version, 4);
				StatusType::checkException(status);
				return;
			}
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->decodeTimeStampTzEx(this, status, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IOFFSETS_CALLBACK_VERSION 2u

	class IOffsetsCallback : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *setOffset)(IOffsetsCallback* self, IStatus* status, unsigned index, unsigned offset, unsigned nullOffset) CLOOP_NOEXCEPT;
		};

	protected:
		IOffsetsCallback(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IOffsetsCallback()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IOFFSETS_CALLBACK_VERSION;

		template <typename StatusType> void setOffset(StatusType* status, unsigned index, unsigned offset, unsigned nullOffset)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setOffset(this, status, index, offset, nullOffset);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IXPB_BUILDER_VERSION 3u

	class IXpbBuilder : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *clear)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *removeCurrent)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *insertInt)(IXpbBuilder* self, IStatus* status, unsigned char tag, int value) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *insertBigInt)(IXpbBuilder* self, IStatus* status, unsigned char tag, ISC_INT64 value) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *insertBytes)(IXpbBuilder* self, IStatus* status, unsigned char tag, const void* bytes, unsigned length) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *insertString)(IXpbBuilder* self, IStatus* status, unsigned char tag, const char* str) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *insertTag)(IXpbBuilder* self, IStatus* status, unsigned char tag) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *isEof)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *moveNext)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *rewind)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *findFirst)(IXpbBuilder* self, IStatus* status, unsigned char tag) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *findNext)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned char (CLOOP_CARG *getTag)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getLength)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getInt)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getBigInt)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getString)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			const unsigned char* (CLOOP_CARG *getBytes)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getBufferLength)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
			const unsigned char* (CLOOP_CARG *getBuffer)(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IXpbBuilder(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IXpbBuilder()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IXPB_BUILDER_VERSION;

		static CLOOP_CONSTEXPR unsigned DPB = 1;
		static CLOOP_CONSTEXPR unsigned SPB_ATTACH = 2;
		static CLOOP_CONSTEXPR unsigned SPB_START = 3;
		static CLOOP_CONSTEXPR unsigned TPB = 4;
		static CLOOP_CONSTEXPR unsigned BATCH = 5;
		static CLOOP_CONSTEXPR unsigned BPB = 6;
		static CLOOP_CONSTEXPR unsigned SPB_SEND = 7;
		static CLOOP_CONSTEXPR unsigned SPB_RECEIVE = 8;
		static CLOOP_CONSTEXPR unsigned SPB_RESPONSE = 9;
		static CLOOP_CONSTEXPR unsigned INFO_SEND = 10;
		static CLOOP_CONSTEXPR unsigned INFO_RESPONSE = 11;

		template <typename StatusType> void clear(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->clear(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void removeCurrent(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->removeCurrent(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void insertInt(StatusType* status, unsigned char tag, int value)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->insertInt(this, status, tag, value);
			StatusType::checkException(status);
		}

		template <typename StatusType> void insertBigInt(StatusType* status, unsigned char tag, ISC_INT64 value)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->insertBigInt(this, status, tag, value);
			StatusType::checkException(status);
		}

		template <typename StatusType> void insertBytes(StatusType* status, unsigned char tag, const void* bytes, unsigned length)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->insertBytes(this, status, tag, bytes, length);
			StatusType::checkException(status);
		}

		template <typename StatusType> void insertString(StatusType* status, unsigned char tag, const char* str)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->insertString(this, status, tag, str);
			StatusType::checkException(status);
		}

		template <typename StatusType> void insertTag(StatusType* status, unsigned char tag)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->insertTag(this, status, tag);
			StatusType::checkException(status);
		}

		template <typename StatusType> FB_BOOLEAN isEof(StatusType* status)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->isEof(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void moveNext(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->moveNext(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void rewind(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->rewind(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> FB_BOOLEAN findFirst(StatusType* status, unsigned char tag)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->findFirst(this, status, tag);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> FB_BOOLEAN findNext(StatusType* status)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->findNext(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned char getTag(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned char ret = static_cast<VTable*>(this->cloopVTable)->getTag(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getLength(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getLength(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> int getInt(StatusType* status)
		{
			StatusType::clearException(status);
			int ret = static_cast<VTable*>(this->cloopVTable)->getInt(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> ISC_INT64 getBigInt(StatusType* status)
		{
			StatusType::clearException(status);
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getBigInt(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const char* getString(StatusType* status)
		{
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getString(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const unsigned char* getBytes(StatusType* status)
		{
			StatusType::clearException(status);
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->getBytes(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> unsigned getBufferLength(StatusType* status)
		{
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getBufferLength(this, status);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> const unsigned char* getBuffer(StatusType* status)
		{
			StatusType::clearException(status);
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->getBuffer(this, status);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_CONNECTION_VERSION 2u

	class ITraceConnection : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			unsigned (CLOOP_CARG *getKind)(ITraceConnection* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getProcessID)(ITraceConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getUserName)(ITraceConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getRoleName)(ITraceConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getCharSet)(ITraceConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getRemoteProtocol)(ITraceConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getRemoteAddress)(ITraceConnection* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getRemoteProcessID)(ITraceConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getRemoteProcessName)(ITraceConnection* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceConnection(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceConnection()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_CONNECTION_VERSION;

		static CLOOP_CONSTEXPR unsigned KIND_DATABASE = 1;
		static CLOOP_CONSTEXPR unsigned KIND_SERVICE = 2;

		unsigned getKind()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getKind(this);
			return ret;
		}

		int getProcessID()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->getProcessID(this);
			return ret;
		}

		const char* getUserName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getUserName(this);
			return ret;
		}

		const char* getRoleName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getRoleName(this);
			return ret;
		}

		const char* getCharSet()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getCharSet(this);
			return ret;
		}

		const char* getRemoteProtocol()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getRemoteProtocol(this);
			return ret;
		}

		const char* getRemoteAddress()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getRemoteAddress(this);
			return ret;
		}

		int getRemoteProcessID()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->getRemoteProcessID(this);
			return ret;
		}

		const char* getRemoteProcessName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getRemoteProcessName(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_DATABASE_CONNECTION_VERSION 3u

	class ITraceDatabaseConnection : public ITraceConnection
	{
	public:
		struct VTable : public ITraceConnection::VTable
		{
			ISC_INT64 (CLOOP_CARG *getConnectionID)(ITraceDatabaseConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getDatabaseName)(ITraceDatabaseConnection* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceDatabaseConnection(DoNotInherit)
			: ITraceConnection(DoNotInherit())
		{
		}

		~ITraceDatabaseConnection()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_DATABASE_CONNECTION_VERSION;

		ISC_INT64 getConnectionID()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getConnectionID(this);
			return ret;
		}

		const char* getDatabaseName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getDatabaseName(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_TRANSACTION_VERSION 3u

	class ITraceTransaction : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			ISC_INT64 (CLOOP_CARG *getTransactionID)(ITraceTransaction* self) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *getReadOnly)(ITraceTransaction* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getWait)(ITraceTransaction* self) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getIsolation)(ITraceTransaction* self) CLOOP_NOEXCEPT;
			PerformanceInfo* (CLOOP_CARG *getPerf)(ITraceTransaction* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getInitialID)(ITraceTransaction* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getPreviousID)(ITraceTransaction* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceTransaction(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceTransaction()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_TRANSACTION_VERSION;

		static CLOOP_CONSTEXPR unsigned ISOLATION_CONSISTENCY = 1;
		static CLOOP_CONSTEXPR unsigned ISOLATION_CONCURRENCY = 2;
		static CLOOP_CONSTEXPR unsigned ISOLATION_READ_COMMITTED_RECVER = 3;
		static CLOOP_CONSTEXPR unsigned ISOLATION_READ_COMMITTED_NORECVER = 4;
		static CLOOP_CONSTEXPR unsigned ISOLATION_READ_COMMITTED_READ_CONSISTENCY = 5;

		ISC_INT64 getTransactionID()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getTransactionID(this);
			return ret;
		}

		FB_BOOLEAN getReadOnly()
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->getReadOnly(this);
			return ret;
		}

		int getWait()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->getWait(this);
			return ret;
		}

		unsigned getIsolation()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getIsolation(this);
			return ret;
		}

		PerformanceInfo* getPerf()
		{
			PerformanceInfo* ret = static_cast<VTable*>(this->cloopVTable)->getPerf(this);
			return ret;
		}

		ISC_INT64 getInitialID()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getInitialID(this);
			return ret;
		}

		ISC_INT64 getPreviousID()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getPreviousID(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_PARAMS_VERSION 3u

	class ITraceParams : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			unsigned (CLOOP_CARG *getCount)(ITraceParams* self) CLOOP_NOEXCEPT;
			const dsc* (CLOOP_CARG *getParam)(ITraceParams* self, unsigned idx) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getTextUTF8)(ITraceParams* self, IStatus* status, unsigned idx) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceParams(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceParams()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_PARAMS_VERSION;

		unsigned getCount()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getCount(this);
			return ret;
		}

		const dsc* getParam(unsigned idx)
		{
			const dsc* ret = static_cast<VTable*>(this->cloopVTable)->getParam(this, idx);
			return ret;
		}

		template <typename StatusType> const char* getTextUTF8(StatusType* status, unsigned idx)
		{
			if (cloopVTable->version < 3)
			{
				StatusType::setVersionError(status, "ITraceParams", cloopVTable->version, 3);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getTextUTF8(this, status, idx);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_STATEMENT_VERSION 2u

	class ITraceStatement : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			ISC_INT64 (CLOOP_CARG *getStmtID)(ITraceStatement* self) CLOOP_NOEXCEPT;
			PerformanceInfo* (CLOOP_CARG *getPerf)(ITraceStatement* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceStatement(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceStatement()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_STATEMENT_VERSION;

		ISC_INT64 getStmtID()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getStmtID(this);
			return ret;
		}

		PerformanceInfo* getPerf()
		{
			PerformanceInfo* ret = static_cast<VTable*>(this->cloopVTable)->getPerf(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_SQLSTATEMENT_VERSION 3u

	class ITraceSQLStatement : public ITraceStatement
	{
	public:
		struct VTable : public ITraceStatement::VTable
		{
			const char* (CLOOP_CARG *getText)(ITraceSQLStatement* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getPlan)(ITraceSQLStatement* self) CLOOP_NOEXCEPT;
			ITraceParams* (CLOOP_CARG *getInputs)(ITraceSQLStatement* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getTextUTF8)(ITraceSQLStatement* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getExplainedPlan)(ITraceSQLStatement* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceSQLStatement(DoNotInherit)
			: ITraceStatement(DoNotInherit())
		{
		}

		~ITraceSQLStatement()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_SQLSTATEMENT_VERSION;

		const char* getText()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getText(this);
			return ret;
		}

		const char* getPlan()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getPlan(this);
			return ret;
		}

		ITraceParams* getInputs()
		{
			ITraceParams* ret = static_cast<VTable*>(this->cloopVTable)->getInputs(this);
			return ret;
		}

		const char* getTextUTF8()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getTextUTF8(this);
			return ret;
		}

		const char* getExplainedPlan()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getExplainedPlan(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_BLRSTATEMENT_VERSION 3u

	class ITraceBLRStatement : public ITraceStatement
	{
	public:
		struct VTable : public ITraceStatement::VTable
		{
			const unsigned char* (CLOOP_CARG *getData)(ITraceBLRStatement* self) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getDataLength)(ITraceBLRStatement* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getText)(ITraceBLRStatement* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceBLRStatement(DoNotInherit)
			: ITraceStatement(DoNotInherit())
		{
		}

		~ITraceBLRStatement()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_BLRSTATEMENT_VERSION;

		const unsigned char* getData()
		{
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->getData(this);
			return ret;
		}

		unsigned getDataLength()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getDataLength(this);
			return ret;
		}

		const char* getText()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getText(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_DYNREQUEST_VERSION 2u

	class ITraceDYNRequest : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const unsigned char* (CLOOP_CARG *getData)(ITraceDYNRequest* self) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getDataLength)(ITraceDYNRequest* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getText)(ITraceDYNRequest* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceDYNRequest(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceDYNRequest()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_DYNREQUEST_VERSION;

		const unsigned char* getData()
		{
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->getData(this);
			return ret;
		}

		unsigned getDataLength()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getDataLength(this);
			return ret;
		}

		const char* getText()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getText(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_CONTEXT_VARIABLE_VERSION 2u

	class ITraceContextVariable : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getNameSpace)(ITraceContextVariable* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getVarName)(ITraceContextVariable* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getVarValue)(ITraceContextVariable* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceContextVariable(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceContextVariable()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_CONTEXT_VARIABLE_VERSION;

		const char* getNameSpace()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getNameSpace(this);
			return ret;
		}

		const char* getVarName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getVarName(this);
			return ret;
		}

		const char* getVarValue()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getVarValue(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_PROCEDURE_VERSION 3u

	class ITraceProcedure : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getProcName)(ITraceProcedure* self) CLOOP_NOEXCEPT;
			ITraceParams* (CLOOP_CARG *getInputs)(ITraceProcedure* self) CLOOP_NOEXCEPT;
			PerformanceInfo* (CLOOP_CARG *getPerf)(ITraceProcedure* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getStmtID)(ITraceProcedure* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getPlan)(ITraceProcedure* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getExplainedPlan)(ITraceProcedure* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceProcedure(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceProcedure()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_PROCEDURE_VERSION;

		const char* getProcName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getProcName(this);
			return ret;
		}

		ITraceParams* getInputs()
		{
			ITraceParams* ret = static_cast<VTable*>(this->cloopVTable)->getInputs(this);
			return ret;
		}

		PerformanceInfo* getPerf()
		{
			PerformanceInfo* ret = static_cast<VTable*>(this->cloopVTable)->getPerf(this);
			return ret;
		}

		ISC_INT64 getStmtID()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getStmtID(this);
			return ret;
		}

		const char* getPlan()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getPlan(this);
			return ret;
		}

		const char* getExplainedPlan()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getExplainedPlan(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_FUNCTION_VERSION 3u

	class ITraceFunction : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getFuncName)(ITraceFunction* self) CLOOP_NOEXCEPT;
			ITraceParams* (CLOOP_CARG *getInputs)(ITraceFunction* self) CLOOP_NOEXCEPT;
			ITraceParams* (CLOOP_CARG *getResult)(ITraceFunction* self) CLOOP_NOEXCEPT;
			PerformanceInfo* (CLOOP_CARG *getPerf)(ITraceFunction* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getStmtID)(ITraceFunction* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getPlan)(ITraceFunction* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getExplainedPlan)(ITraceFunction* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceFunction(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceFunction()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_FUNCTION_VERSION;

		const char* getFuncName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getFuncName(this);
			return ret;
		}

		ITraceParams* getInputs()
		{
			ITraceParams* ret = static_cast<VTable*>(this->cloopVTable)->getInputs(this);
			return ret;
		}

		ITraceParams* getResult()
		{
			ITraceParams* ret = static_cast<VTable*>(this->cloopVTable)->getResult(this);
			return ret;
		}

		PerformanceInfo* getPerf()
		{
			PerformanceInfo* ret = static_cast<VTable*>(this->cloopVTable)->getPerf(this);
			return ret;
		}

		ISC_INT64 getStmtID()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getStmtID(this);
			return ret;
		}

		const char* getPlan()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getPlan(this);
			return ret;
		}

		const char* getExplainedPlan()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getExplainedPlan(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_TRIGGER_VERSION 3u

	class ITraceTrigger : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getTriggerName)(ITraceTrigger* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getRelationName)(ITraceTrigger* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getAction)(ITraceTrigger* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getWhich)(ITraceTrigger* self) CLOOP_NOEXCEPT;
			PerformanceInfo* (CLOOP_CARG *getPerf)(ITraceTrigger* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getStmtID)(ITraceTrigger* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getPlan)(ITraceTrigger* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getExplainedPlan)(ITraceTrigger* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceTrigger(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceTrigger()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_TRIGGER_VERSION;

		static CLOOP_CONSTEXPR unsigned TYPE_ALL = 0;
		static CLOOP_CONSTEXPR unsigned TYPE_BEFORE = 1;
		static CLOOP_CONSTEXPR unsigned TYPE_AFTER = 2;

		const char* getTriggerName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getTriggerName(this);
			return ret;
		}

		const char* getRelationName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getRelationName(this);
			return ret;
		}

		int getAction()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->getAction(this);
			return ret;
		}

		int getWhich()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->getWhich(this);
			return ret;
		}

		PerformanceInfo* getPerf()
		{
			PerformanceInfo* ret = static_cast<VTable*>(this->cloopVTable)->getPerf(this);
			return ret;
		}

		ISC_INT64 getStmtID()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getStmtID(this);
			return ret;
		}

		const char* getPlan()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getPlan(this);
			return ret;
		}

		const char* getExplainedPlan()
		{
			if (cloopVTable->version < 3)
			{
				return 0;
			}
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getExplainedPlan(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_SERVICE_CONNECTION_VERSION 3u

	class ITraceServiceConnection : public ITraceConnection
	{
	public:
		struct VTable : public ITraceConnection::VTable
		{
			void* (CLOOP_CARG *getServiceID)(ITraceServiceConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getServiceMgr)(ITraceServiceConnection* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getServiceName)(ITraceServiceConnection* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceServiceConnection(DoNotInherit)
			: ITraceConnection(DoNotInherit())
		{
		}

		~ITraceServiceConnection()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_SERVICE_CONNECTION_VERSION;

		void* getServiceID()
		{
			void* ret = static_cast<VTable*>(this->cloopVTable)->getServiceID(this);
			return ret;
		}

		const char* getServiceMgr()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getServiceMgr(this);
			return ret;
		}

		const char* getServiceName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getServiceName(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_STATUS_VECTOR_VERSION 2u

	class ITraceStatusVector : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			FB_BOOLEAN (CLOOP_CARG *hasError)(ITraceStatusVector* self) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *hasWarning)(ITraceStatusVector* self) CLOOP_NOEXCEPT;
			IStatus* (CLOOP_CARG *getStatus)(ITraceStatusVector* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getText)(ITraceStatusVector* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceStatusVector(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceStatusVector()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_STATUS_VECTOR_VERSION;

		FB_BOOLEAN hasError()
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->hasError(this);
			return ret;
		}

		FB_BOOLEAN hasWarning()
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->hasWarning(this);
			return ret;
		}

		IStatus* getStatus()
		{
			IStatus* ret = static_cast<VTable*>(this->cloopVTable)->getStatus(this);
			return ret;
		}

		const char* getText()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getText(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_SWEEP_INFO_VERSION 2u

	class ITraceSweepInfo : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			ISC_INT64 (CLOOP_CARG *getOIT)(ITraceSweepInfo* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getOST)(ITraceSweepInfo* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getOAT)(ITraceSweepInfo* self) CLOOP_NOEXCEPT;
			ISC_INT64 (CLOOP_CARG *getNext)(ITraceSweepInfo* self) CLOOP_NOEXCEPT;
			PerformanceInfo* (CLOOP_CARG *getPerf)(ITraceSweepInfo* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceSweepInfo(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceSweepInfo()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_SWEEP_INFO_VERSION;

		ISC_INT64 getOIT()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getOIT(this);
			return ret;
		}

		ISC_INT64 getOST()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getOST(this);
			return ret;
		}

		ISC_INT64 getOAT()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getOAT(this);
			return ret;
		}

		ISC_INT64 getNext()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getNext(this);
			return ret;
		}

		PerformanceInfo* getPerf()
		{
			PerformanceInfo* ret = static_cast<VTable*>(this->cloopVTable)->getPerf(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_LOG_WRITER_VERSION 4u

	class ITraceLogWriter : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			unsigned (CLOOP_CARG *write)(ITraceLogWriter* self, const void* buf, unsigned size) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *write_s)(ITraceLogWriter* self, IStatus* status, const void* buf, unsigned size) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceLogWriter(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~ITraceLogWriter()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_LOG_WRITER_VERSION;

		unsigned write(const void* buf, unsigned size)
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->write(this, buf, size);
			return ret;
		}

		template <typename StatusType> unsigned write_s(StatusType* status, const void* buf, unsigned size)
		{
			if (cloopVTable->version < 4)
			{
				StatusType::setVersionError(status, "ITraceLogWriter", cloopVTable->version, 4);
				StatusType::checkException(status);
				return 0;
			}
			StatusType::clearException(status);
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->write_s(this, status, buf, size);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_INIT_INFO_VERSION 2u

	class ITraceInitInfo : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getConfigText)(ITraceInitInfo* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getTraceSessionID)(ITraceInitInfo* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getTraceSessionName)(ITraceInitInfo* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getFirebirdRootDirectory)(ITraceInitInfo* self) CLOOP_NOEXCEPT;
			const char* (CLOOP_CARG *getDatabaseName)(ITraceInitInfo* self) CLOOP_NOEXCEPT;
			ITraceDatabaseConnection* (CLOOP_CARG *getConnection)(ITraceInitInfo* self) CLOOP_NOEXCEPT;
			ITraceLogWriter* (CLOOP_CARG *getLogWriter)(ITraceInitInfo* self) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceInitInfo(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~ITraceInitInfo()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_INIT_INFO_VERSION;

		const char* getConfigText()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getConfigText(this);
			return ret;
		}

		int getTraceSessionID()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->getTraceSessionID(this);
			return ret;
		}

		const char* getTraceSessionName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getTraceSessionName(this);
			return ret;
		}

		const char* getFirebirdRootDirectory()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getFirebirdRootDirectory(this);
			return ret;
		}

		const char* getDatabaseName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getDatabaseName(this);
			return ret;
		}

		ITraceDatabaseConnection* getConnection()
		{
			ITraceDatabaseConnection* ret = static_cast<VTable*>(this->cloopVTable)->getConnection(this);
			return ret;
		}

		ITraceLogWriter* getLogWriter()
		{
			ITraceLogWriter* ret = static_cast<VTable*>(this->cloopVTable)->getLogWriter(this);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_PLUGIN_VERSION 5u

	class ITracePlugin : public IReferenceCounted
	{
	public:
		struct VTable : public IReferenceCounted::VTable
		{
			const char* (CLOOP_CARG *trace_get_error)(ITracePlugin* self) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_attach)(ITracePlugin* self, ITraceDatabaseConnection* connection, FB_BOOLEAN create_db, unsigned att_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_detach)(ITracePlugin* self, ITraceDatabaseConnection* connection, FB_BOOLEAN drop_db) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_transaction_start)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, unsigned tpb_length, const unsigned char* tpb, unsigned tra_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_transaction_end)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, FB_BOOLEAN commit, FB_BOOLEAN retain_context, unsigned tra_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_proc_execute)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceProcedure* procedure, FB_BOOLEAN started, unsigned proc_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_trigger_execute)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceTrigger* trigger, FB_BOOLEAN started, unsigned trig_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_set_context)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceContextVariable* variable) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_dsql_prepare)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, ISC_INT64 time_millis, unsigned req_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_dsql_free)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceSQLStatement* statement, unsigned option) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_dsql_execute)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, FB_BOOLEAN started, unsigned req_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_blr_compile)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceBLRStatement* statement, ISC_INT64 time_millis, unsigned req_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_blr_execute)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceBLRStatement* statement, unsigned req_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_dyn_execute)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceDYNRequest* request, ISC_INT64 time_millis, unsigned req_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_service_attach)(ITracePlugin* self, ITraceServiceConnection* service, unsigned att_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_service_start)(ITracePlugin* self, ITraceServiceConnection* service, unsigned switches_length, const char* switches, unsigned start_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_service_query)(ITracePlugin* self, ITraceServiceConnection* service, unsigned send_item_length, const unsigned char* send_items, unsigned recv_item_length, const unsigned char* recv_items, unsigned query_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_service_detach)(ITracePlugin* self, ITraceServiceConnection* service, unsigned detach_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_event_error)(ITracePlugin* self, ITraceConnection* connection, ITraceStatusVector* status, const char* function) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_event_sweep)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceSweepInfo* sweep, unsigned sweep_state) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_func_execute)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceFunction* function, FB_BOOLEAN started, unsigned func_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_dsql_restart)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, unsigned number) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_proc_compile)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceProcedure* procedure, ISC_INT64 time_millis, unsigned proc_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_func_compile)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceFunction* function, ISC_INT64 time_millis, unsigned func_result) CLOOP_NOEXCEPT;
			FB_BOOLEAN (CLOOP_CARG *trace_trigger_compile)(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTrigger* trigger, ISC_INT64 time_millis, unsigned trig_result) CLOOP_NOEXCEPT;
		};

	protected:
		ITracePlugin(DoNotInherit)
			: IReferenceCounted(DoNotInherit())
		{
		}

		~ITracePlugin()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_PLUGIN_VERSION;

		static CLOOP_CONSTEXPR unsigned RESULT_SUCCESS = 0;
		static CLOOP_CONSTEXPR unsigned RESULT_FAILED = 1;
		static CLOOP_CONSTEXPR unsigned RESULT_UNAUTHORIZED = 2;
		static CLOOP_CONSTEXPR unsigned SWEEP_STATE_STARTED = 1;
		static CLOOP_CONSTEXPR unsigned SWEEP_STATE_FINISHED = 2;
		static CLOOP_CONSTEXPR unsigned SWEEP_STATE_FAILED = 3;
		static CLOOP_CONSTEXPR unsigned SWEEP_STATE_PROGRESS = 4;

		const char* trace_get_error()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->trace_get_error(this);
			return ret;
		}

		FB_BOOLEAN trace_attach(ITraceDatabaseConnection* connection, FB_BOOLEAN create_db, unsigned att_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_attach(this, connection, create_db, att_result);
			return ret;
		}

		FB_BOOLEAN trace_detach(ITraceDatabaseConnection* connection, FB_BOOLEAN drop_db)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_detach(this, connection, drop_db);
			return ret;
		}

		FB_BOOLEAN trace_transaction_start(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, unsigned tpb_length, const unsigned char* tpb, unsigned tra_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_transaction_start(this, connection, transaction, tpb_length, tpb, tra_result);
			return ret;
		}

		FB_BOOLEAN trace_transaction_end(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, FB_BOOLEAN commit, FB_BOOLEAN retain_context, unsigned tra_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_transaction_end(this, connection, transaction, commit, retain_context, tra_result);
			return ret;
		}

		FB_BOOLEAN trace_proc_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceProcedure* procedure, FB_BOOLEAN started, unsigned proc_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_proc_execute(this, connection, transaction, procedure, started, proc_result);
			return ret;
		}

		FB_BOOLEAN trace_trigger_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceTrigger* trigger, FB_BOOLEAN started, unsigned trig_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_trigger_execute(this, connection, transaction, trigger, started, trig_result);
			return ret;
		}

		FB_BOOLEAN trace_set_context(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceContextVariable* variable)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_set_context(this, connection, transaction, variable);
			return ret;
		}

		FB_BOOLEAN trace_dsql_prepare(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, ISC_INT64 time_millis, unsigned req_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_dsql_prepare(this, connection, transaction, statement, time_millis, req_result);
			return ret;
		}

		FB_BOOLEAN trace_dsql_free(ITraceDatabaseConnection* connection, ITraceSQLStatement* statement, unsigned option)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_dsql_free(this, connection, statement, option);
			return ret;
		}

		FB_BOOLEAN trace_dsql_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, FB_BOOLEAN started, unsigned req_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_dsql_execute(this, connection, transaction, statement, started, req_result);
			return ret;
		}

		FB_BOOLEAN trace_blr_compile(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceBLRStatement* statement, ISC_INT64 time_millis, unsigned req_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_blr_compile(this, connection, transaction, statement, time_millis, req_result);
			return ret;
		}

		FB_BOOLEAN trace_blr_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceBLRStatement* statement, unsigned req_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_blr_execute(this, connection, transaction, statement, req_result);
			return ret;
		}

		FB_BOOLEAN trace_dyn_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceDYNRequest* request, ISC_INT64 time_millis, unsigned req_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_dyn_execute(this, connection, transaction, request, time_millis, req_result);
			return ret;
		}

		FB_BOOLEAN trace_service_attach(ITraceServiceConnection* service, unsigned att_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_service_attach(this, service, att_result);
			return ret;
		}

		FB_BOOLEAN trace_service_start(ITraceServiceConnection* service, unsigned switches_length, const char* switches, unsigned start_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_service_start(this, service, switches_length, switches, start_result);
			return ret;
		}

		FB_BOOLEAN trace_service_query(ITraceServiceConnection* service, unsigned send_item_length, const unsigned char* send_items, unsigned recv_item_length, const unsigned char* recv_items, unsigned query_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_service_query(this, service, send_item_length, send_items, recv_item_length, recv_items, query_result);
			return ret;
		}

		FB_BOOLEAN trace_service_detach(ITraceServiceConnection* service, unsigned detach_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_service_detach(this, service, detach_result);
			return ret;
		}

		FB_BOOLEAN trace_event_error(ITraceConnection* connection, ITraceStatusVector* status, const char* function)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_event_error(this, connection, status, function);
			return ret;
		}

		FB_BOOLEAN trace_event_sweep(ITraceDatabaseConnection* connection, ITraceSweepInfo* sweep, unsigned sweep_state)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_event_sweep(this, connection, sweep, sweep_state);
			return ret;
		}

		FB_BOOLEAN trace_func_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceFunction* function, FB_BOOLEAN started, unsigned func_result)
		{
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_func_execute(this, connection, transaction, function, started, func_result);
			return ret;
		}

		FB_BOOLEAN trace_dsql_restart(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, unsigned number)
		{
			if (cloopVTable->version < 4)
			{
				return 0;
			}
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_dsql_restart(this, connection, transaction, statement, number);
			return ret;
		}

		FB_BOOLEAN trace_proc_compile(ITraceDatabaseConnection* connection, ITraceProcedure* procedure, ISC_INT64 time_millis, unsigned proc_result)
		{
			if (cloopVTable->version < 5)
			{
				return 0;
			}
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_proc_compile(this, connection, procedure, time_millis, proc_result);
			return ret;
		}

		FB_BOOLEAN trace_func_compile(ITraceDatabaseConnection* connection, ITraceFunction* function, ISC_INT64 time_millis, unsigned func_result)
		{
			if (cloopVTable->version < 5)
			{
				return 0;
			}
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_func_compile(this, connection, function, time_millis, func_result);
			return ret;
		}

		FB_BOOLEAN trace_trigger_compile(ITraceDatabaseConnection* connection, ITraceTrigger* trigger, ISC_INT64 time_millis, unsigned trig_result)
		{
			if (cloopVTable->version < 5)
			{
				return 0;
			}
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->trace_trigger_compile(this, connection, trigger, time_millis, trig_result);
			return ret;
		}
	};

#define FIREBIRD_ITRACE_FACTORY_VERSION 4u

	class ITraceFactory : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			ISC_UINT64 (CLOOP_CARG *trace_needs)(ITraceFactory* self) CLOOP_NOEXCEPT;
			ITracePlugin* (CLOOP_CARG *trace_create)(ITraceFactory* self, IStatus* status, ITraceInitInfo* init_info) CLOOP_NOEXCEPT;
		};

	protected:
		ITraceFactory(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~ITraceFactory()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_ITRACE_FACTORY_VERSION;

		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_ATTACH = 0;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_DETACH = 1;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_TRANSACTION_START = 2;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_TRANSACTION_END = 3;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_SET_CONTEXT = 4;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_PROC_EXECUTE = 5;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_TRIGGER_EXECUTE = 6;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_DSQL_PREPARE = 7;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_DSQL_FREE = 8;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_DSQL_EXECUTE = 9;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_BLR_COMPILE = 10;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_BLR_EXECUTE = 11;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_DYN_EXECUTE = 12;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_SERVICE_ATTACH = 13;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_SERVICE_START = 14;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_SERVICE_QUERY = 15;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_SERVICE_DETACH = 16;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_ERROR = 17;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_SWEEP = 18;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_FUNC_EXECUTE = 19;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_PROC_COMPILE = 20;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_FUNC_COMPILE = 21;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_TRIGGER_COMPILE = 22;
		static CLOOP_CONSTEXPR unsigned TRACE_EVENT_MAX = 23;

		ISC_UINT64 trace_needs()
		{
			ISC_UINT64 ret = static_cast<VTable*>(this->cloopVTable)->trace_needs(this);
			return ret;
		}

		template <typename StatusType> ITracePlugin* trace_create(StatusType* status, ITraceInitInfo* init_info)
		{
			StatusType::clearException(status);
			ITracePlugin* ret = static_cast<VTable*>(this->cloopVTable)->trace_create(this, status, init_info);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IUDR_FUNCTION_FACTORY_VERSION 3u

	class IUdrFunctionFactory : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *setup)(IUdrFunctionFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) CLOOP_NOEXCEPT;
			IExternalFunction* (CLOOP_CARG *newItem)(IUdrFunctionFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata) CLOOP_NOEXCEPT;
		};

	protected:
		IUdrFunctionFactory(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IUdrFunctionFactory()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IUDR_FUNCTION_FACTORY_VERSION;

		template <typename StatusType> void setup(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setup(this, status, context, metadata, inBuilder, outBuilder);
			StatusType::checkException(status);
		}

		template <typename StatusType> IExternalFunction* newItem(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata)
		{
			StatusType::clearException(status);
			IExternalFunction* ret = static_cast<VTable*>(this->cloopVTable)->newItem(this, status, context, metadata);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IUDR_PROCEDURE_FACTORY_VERSION 3u

	class IUdrProcedureFactory : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *setup)(IUdrProcedureFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) CLOOP_NOEXCEPT;
			IExternalProcedure* (CLOOP_CARG *newItem)(IUdrProcedureFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata) CLOOP_NOEXCEPT;
		};

	protected:
		IUdrProcedureFactory(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IUdrProcedureFactory()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IUDR_PROCEDURE_FACTORY_VERSION;

		template <typename StatusType> void setup(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setup(this, status, context, metadata, inBuilder, outBuilder);
			StatusType::checkException(status);
		}

		template <typename StatusType> IExternalProcedure* newItem(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata)
		{
			StatusType::clearException(status);
			IExternalProcedure* ret = static_cast<VTable*>(this->cloopVTable)->newItem(this, status, context, metadata);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IUDR_TRIGGER_FACTORY_VERSION 3u

	class IUdrTriggerFactory : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *setup)(IUdrTriggerFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* fieldsBuilder) CLOOP_NOEXCEPT;
			IExternalTrigger* (CLOOP_CARG *newItem)(IUdrTriggerFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata) CLOOP_NOEXCEPT;
		};

	protected:
		IUdrTriggerFactory(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IUdrTriggerFactory()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IUDR_TRIGGER_FACTORY_VERSION;

		template <typename StatusType> void setup(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* fieldsBuilder)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setup(this, status, context, metadata, fieldsBuilder);
			StatusType::checkException(status);
		}

		template <typename StatusType> IExternalTrigger* newItem(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata)
		{
			StatusType::clearException(status);
			IExternalTrigger* ret = static_cast<VTable*>(this->cloopVTable)->newItem(this, status, context, metadata);
			StatusType::checkException(status);
			return ret;
		}
	};

#define FIREBIRD_IUDR_PLUGIN_VERSION 2u

	class IUdrPlugin : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			IMaster* (CLOOP_CARG *getMaster)(IUdrPlugin* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *registerFunction)(IUdrPlugin* self, IStatus* status, const char* name, IUdrFunctionFactory* factory) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *registerProcedure)(IUdrPlugin* self, IStatus* status, const char* name, IUdrProcedureFactory* factory) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *registerTrigger)(IUdrPlugin* self, IStatus* status, const char* name, IUdrTriggerFactory* factory) CLOOP_NOEXCEPT;
		};

	protected:
		IUdrPlugin(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IUdrPlugin()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IUDR_PLUGIN_VERSION;

		IMaster* getMaster()
		{
			IMaster* ret = static_cast<VTable*>(this->cloopVTable)->getMaster(this);
			return ret;
		}

		template <typename StatusType> void registerFunction(StatusType* status, const char* name, IUdrFunctionFactory* factory)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->registerFunction(this, status, name, factory);
			StatusType::checkException(status);
		}

		template <typename StatusType> void registerProcedure(StatusType* status, const char* name, IUdrProcedureFactory* factory)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->registerProcedure(this, status, name, factory);
			StatusType::checkException(status);
		}

		template <typename StatusType> void registerTrigger(StatusType* status, const char* name, IUdrTriggerFactory* factory)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->registerTrigger(this, status, name, factory);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IDEC_FLOAT16_VERSION 2u

	class IDecFloat16 : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *toBcd)(IDecFloat16* self, const FB_DEC16* from, int* sign, unsigned char* bcd, int* exp) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *toString)(IDecFloat16* self, IStatus* status, const FB_DEC16* from, unsigned bufferLength, char* buffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *fromBcd)(IDecFloat16* self, int sign, const unsigned char* bcd, int exp, FB_DEC16* to) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *fromString)(IDecFloat16* self, IStatus* status, const char* from, FB_DEC16* to) CLOOP_NOEXCEPT;
		};

	protected:
		IDecFloat16(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IDecFloat16()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IDEC_FLOAT16_VERSION;

		static CLOOP_CONSTEXPR unsigned BCD_SIZE = 16;
		static CLOOP_CONSTEXPR unsigned STRING_SIZE = 24;

		void toBcd(const FB_DEC16* from, int* sign, unsigned char* bcd, int* exp)
		{
			static_cast<VTable*>(this->cloopVTable)->toBcd(this, from, sign, bcd, exp);
		}

		template <typename StatusType> void toString(StatusType* status, const FB_DEC16* from, unsigned bufferLength, char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->toString(this, status, from, bufferLength, buffer);
			StatusType::checkException(status);
		}

		void fromBcd(int sign, const unsigned char* bcd, int exp, FB_DEC16* to)
		{
			static_cast<VTable*>(this->cloopVTable)->fromBcd(this, sign, bcd, exp, to);
		}

		template <typename StatusType> void fromString(StatusType* status, const char* from, FB_DEC16* to)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->fromString(this, status, from, to);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IDEC_FLOAT34_VERSION 2u

	class IDecFloat34 : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *toBcd)(IDecFloat34* self, const FB_DEC34* from, int* sign, unsigned char* bcd, int* exp) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *toString)(IDecFloat34* self, IStatus* status, const FB_DEC34* from, unsigned bufferLength, char* buffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *fromBcd)(IDecFloat34* self, int sign, const unsigned char* bcd, int exp, FB_DEC34* to) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *fromString)(IDecFloat34* self, IStatus* status, const char* from, FB_DEC34* to) CLOOP_NOEXCEPT;
		};

	protected:
		IDecFloat34(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IDecFloat34()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IDEC_FLOAT34_VERSION;

		static CLOOP_CONSTEXPR unsigned BCD_SIZE = 34;
		static CLOOP_CONSTEXPR unsigned STRING_SIZE = 43;

		void toBcd(const FB_DEC34* from, int* sign, unsigned char* bcd, int* exp)
		{
			static_cast<VTable*>(this->cloopVTable)->toBcd(this, from, sign, bcd, exp);
		}

		template <typename StatusType> void toString(StatusType* status, const FB_DEC34* from, unsigned bufferLength, char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->toString(this, status, from, bufferLength, buffer);
			StatusType::checkException(status);
		}

		void fromBcd(int sign, const unsigned char* bcd, int exp, FB_DEC34* to)
		{
			static_cast<VTable*>(this->cloopVTable)->fromBcd(this, sign, bcd, exp, to);
		}

		template <typename StatusType> void fromString(StatusType* status, const char* from, FB_DEC34* to)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->fromString(this, status, from, to);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IINT128_VERSION 2u

	class IInt128 : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			void (CLOOP_CARG *toString)(IInt128* self, IStatus* status, const FB_I128* from, int scale, unsigned bufferLength, char* buffer) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *fromString)(IInt128* self, IStatus* status, int scale, const char* from, FB_I128* to) CLOOP_NOEXCEPT;
		};

	protected:
		IInt128(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IInt128()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IINT128_VERSION;

		static CLOOP_CONSTEXPR unsigned STRING_SIZE = 46;

		template <typename StatusType> void toString(StatusType* status, const FB_I128* from, int scale, unsigned bufferLength, char* buffer)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->toString(this, status, from, scale, bufferLength, buffer);
			StatusType::checkException(status);
		}

		template <typename StatusType> void fromString(StatusType* status, int scale, const char* from, FB_I128* to)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->fromString(this, status, scale, from, to);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IREPLICATED_FIELD_VERSION 2u

	class IReplicatedField : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			const char* (CLOOP_CARG *getName)(IReplicatedField* self) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getType)(IReplicatedField* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getSubType)(IReplicatedField* self) CLOOP_NOEXCEPT;
			int (CLOOP_CARG *getScale)(IReplicatedField* self) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getLength)(IReplicatedField* self) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getCharSet)(IReplicatedField* self) CLOOP_NOEXCEPT;
			const void* (CLOOP_CARG *getData)(IReplicatedField* self) CLOOP_NOEXCEPT;
		};

	protected:
		IReplicatedField(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IReplicatedField()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IREPLICATED_FIELD_VERSION;

		const char* getName()
		{
			const char* ret = static_cast<VTable*>(this->cloopVTable)->getName(this);
			return ret;
		}

		unsigned getType()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getType(this);
			return ret;
		}

		int getSubType()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->getSubType(this);
			return ret;
		}

		int getScale()
		{
			int ret = static_cast<VTable*>(this->cloopVTable)->getScale(this);
			return ret;
		}

		unsigned getLength()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getLength(this);
			return ret;
		}

		unsigned getCharSet()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getCharSet(this);
			return ret;
		}

		const void* getData()
		{
			const void* ret = static_cast<VTable*>(this->cloopVTable)->getData(this);
			return ret;
		}
	};

#define FIREBIRD_IREPLICATED_RECORD_VERSION 2u

	class IReplicatedRecord : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			unsigned (CLOOP_CARG *getCount)(IReplicatedRecord* self) CLOOP_NOEXCEPT;
			IReplicatedField* (CLOOP_CARG *getField)(IReplicatedRecord* self, unsigned index) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getRawLength)(IReplicatedRecord* self) CLOOP_NOEXCEPT;
			const unsigned char* (CLOOP_CARG *getRawData)(IReplicatedRecord* self) CLOOP_NOEXCEPT;
		};

	protected:
		IReplicatedRecord(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IReplicatedRecord()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IREPLICATED_RECORD_VERSION;

		unsigned getCount()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getCount(this);
			return ret;
		}

		IReplicatedField* getField(unsigned index)
		{
			IReplicatedField* ret = static_cast<VTable*>(this->cloopVTable)->getField(this, index);
			return ret;
		}

		unsigned getRawLength()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getRawLength(this);
			return ret;
		}

		const unsigned char* getRawData()
		{
			const unsigned char* ret = static_cast<VTable*>(this->cloopVTable)->getRawData(this);
			return ret;
		}
	};

#define FIREBIRD_IREPLICATED_TRANSACTION_VERSION 3u

	class IReplicatedTransaction : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			void (CLOOP_CARG *prepare)(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *commit)(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *rollback)(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *startSavepoint)(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *releaseSavepoint)(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *rollbackSavepoint)(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *insertRecord)(IReplicatedTransaction* self, IStatus* status, const char* name, IReplicatedRecord* record) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *updateRecord)(IReplicatedTransaction* self, IStatus* status, const char* name, IReplicatedRecord* orgRecord, IReplicatedRecord* newRecord) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *deleteRecord)(IReplicatedTransaction* self, IStatus* status, const char* name, IReplicatedRecord* record) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *executeSql)(IReplicatedTransaction* self, IStatus* status, const char* sql) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *executeSqlIntl)(IReplicatedTransaction* self, IStatus* status, unsigned charset, const char* sql) CLOOP_NOEXCEPT;
		};

	protected:
		IReplicatedTransaction(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IReplicatedTransaction()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IREPLICATED_TRANSACTION_VERSION;

		template <typename StatusType> void prepare(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->prepare(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void commit(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->commit(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void rollback(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->rollback(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void startSavepoint(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->startSavepoint(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void releaseSavepoint(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->releaseSavepoint(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void rollbackSavepoint(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->rollbackSavepoint(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void insertRecord(StatusType* status, const char* name, IReplicatedRecord* record)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->insertRecord(this, status, name, record);
			StatusType::checkException(status);
		}

		template <typename StatusType> void updateRecord(StatusType* status, const char* name, IReplicatedRecord* orgRecord, IReplicatedRecord* newRecord)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->updateRecord(this, status, name, orgRecord, newRecord);
			StatusType::checkException(status);
		}

		template <typename StatusType> void deleteRecord(StatusType* status, const char* name, IReplicatedRecord* record)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->deleteRecord(this, status, name, record);
			StatusType::checkException(status);
		}

		template <typename StatusType> void executeSql(StatusType* status, const char* sql)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->executeSql(this, status, sql);
			StatusType::checkException(status);
		}

		template <typename StatusType> void executeSqlIntl(StatusType* status, unsigned charset, const char* sql)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->executeSqlIntl(this, status, charset, sql);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IREPLICATED_SESSION_VERSION 4u

	class IReplicatedSession : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			FB_BOOLEAN (CLOOP_CARG *init)(IReplicatedSession* self, IStatus* status, IAttachment* attachment) CLOOP_NOEXCEPT;
			IReplicatedTransaction* (CLOOP_CARG *startTransaction)(IReplicatedSession* self, IStatus* status, ITransaction* transaction, ISC_INT64 number) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *cleanupTransaction)(IReplicatedSession* self, IStatus* status, ISC_INT64 number) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *setSequence)(IReplicatedSession* self, IStatus* status, const char* name, ISC_INT64 value) CLOOP_NOEXCEPT;
		};

	protected:
		IReplicatedSession(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IReplicatedSession()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IREPLICATED_SESSION_VERSION;

		template <typename StatusType> FB_BOOLEAN init(StatusType* status, IAttachment* attachment)
		{
			StatusType::clearException(status);
			FB_BOOLEAN ret = static_cast<VTable*>(this->cloopVTable)->init(this, status, attachment);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> IReplicatedTransaction* startTransaction(StatusType* status, ITransaction* transaction, ISC_INT64 number)
		{
			StatusType::clearException(status);
			IReplicatedTransaction* ret = static_cast<VTable*>(this->cloopVTable)->startTransaction(this, status, transaction, number);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void cleanupTransaction(StatusType* status, ISC_INT64 number)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->cleanupTransaction(this, status, number);
			StatusType::checkException(status);
		}

		template <typename StatusType> void setSequence(StatusType* status, const char* name, ISC_INT64 value)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->setSequence(this, status, name, value);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IPROFILER_PLUGIN_VERSION 4u

	class IProfilerPlugin : public IPluginBase
	{
	public:
		struct VTable : public IPluginBase::VTable
		{
			void (CLOOP_CARG *init)(IProfilerPlugin* self, IStatus* status, IAttachment* attachment, ISC_UINT64 ticksFrequency) CLOOP_NOEXCEPT;
			IProfilerSession* (CLOOP_CARG *startSession)(IProfilerPlugin* self, IStatus* status, const char* description, const char* options, ISC_TIMESTAMP_TZ timestamp) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *flush)(IProfilerPlugin* self, IStatus* status) CLOOP_NOEXCEPT;
		};

	protected:
		IProfilerPlugin(DoNotInherit)
			: IPluginBase(DoNotInherit())
		{
		}

		~IProfilerPlugin()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPROFILER_PLUGIN_VERSION;

		template <typename StatusType> void init(StatusType* status, IAttachment* attachment, ISC_UINT64 ticksFrequency)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->init(this, status, attachment, ticksFrequency);
			StatusType::checkException(status);
		}

		template <typename StatusType> IProfilerSession* startSession(StatusType* status, const char* description, const char* options, ISC_TIMESTAMP_TZ timestamp)
		{
			StatusType::clearException(status);
			IProfilerSession* ret = static_cast<VTable*>(this->cloopVTable)->startSession(this, status, description, options, timestamp);
			StatusType::checkException(status);
			return ret;
		}

		template <typename StatusType> void flush(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->flush(this, status);
			StatusType::checkException(status);
		}
	};

#define FIREBIRD_IPROFILER_SESSION_VERSION 3u

	class IProfilerSession : public IDisposable
	{
	public:
		struct VTable : public IDisposable::VTable
		{
			ISC_INT64 (CLOOP_CARG *getId)(IProfilerSession* self) CLOOP_NOEXCEPT;
			unsigned (CLOOP_CARG *getFlags)(IProfilerSession* self) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *cancel)(IProfilerSession* self, IStatus* status) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *finish)(IProfilerSession* self, IStatus* status, ISC_TIMESTAMP_TZ timestamp) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *defineStatement)(IProfilerSession* self, IStatus* status, ISC_INT64 statementId, ISC_INT64 parentStatementId, const char* type, const char* packageName, const char* routineName, const char* sqlText) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *defineCursor)(IProfilerSession* self, ISC_INT64 statementId, unsigned cursorId, const char* name, unsigned line, unsigned column) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *defineRecordSource)(IProfilerSession* self, ISC_INT64 statementId, unsigned cursorId, unsigned recSourceId, unsigned level, const char* accessPath, unsigned parentRecSourceId) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *onRequestStart)(IProfilerSession* self, IStatus* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_INT64 callerStatementId, ISC_INT64 callerRequestId, ISC_TIMESTAMP_TZ timestamp) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *onRequestFinish)(IProfilerSession* self, IStatus* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_TIMESTAMP_TZ timestamp, IProfilerStats* stats) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *beforePsqlLineColumn)(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *afterPsqlLineColumn)(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column, IProfilerStats* stats) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *beforeRecordSourceOpen)(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *afterRecordSourceOpen)(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, IProfilerStats* stats) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *beforeRecordSourceGetRecord)(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId) CLOOP_NOEXCEPT;
			void (CLOOP_CARG *afterRecordSourceGetRecord)(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, IProfilerStats* stats) CLOOP_NOEXCEPT;
		};

	protected:
		IProfilerSession(DoNotInherit)
			: IDisposable(DoNotInherit())
		{
		}

		~IProfilerSession()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPROFILER_SESSION_VERSION;

		static CLOOP_CONSTEXPR unsigned FLAG_BEFORE_EVENTS = 0x1;
		static CLOOP_CONSTEXPR unsigned FLAG_AFTER_EVENTS = 0x2;

		ISC_INT64 getId()
		{
			ISC_INT64 ret = static_cast<VTable*>(this->cloopVTable)->getId(this);
			return ret;
		}

		unsigned getFlags()
		{
			unsigned ret = static_cast<VTable*>(this->cloopVTable)->getFlags(this);
			return ret;
		}

		template <typename StatusType> void cancel(StatusType* status)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->cancel(this, status);
			StatusType::checkException(status);
		}

		template <typename StatusType> void finish(StatusType* status, ISC_TIMESTAMP_TZ timestamp)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->finish(this, status, timestamp);
			StatusType::checkException(status);
		}

		template <typename StatusType> void defineStatement(StatusType* status, ISC_INT64 statementId, ISC_INT64 parentStatementId, const char* type, const char* packageName, const char* routineName, const char* sqlText)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->defineStatement(this, status, statementId, parentStatementId, type, packageName, routineName, sqlText);
			StatusType::checkException(status);
		}

		void defineCursor(ISC_INT64 statementId, unsigned cursorId, const char* name, unsigned line, unsigned column)
		{
			static_cast<VTable*>(this->cloopVTable)->defineCursor(this, statementId, cursorId, name, line, column);
		}

		void defineRecordSource(ISC_INT64 statementId, unsigned cursorId, unsigned recSourceId, unsigned level, const char* accessPath, unsigned parentRecSourceId)
		{
			static_cast<VTable*>(this->cloopVTable)->defineRecordSource(this, statementId, cursorId, recSourceId, level, accessPath, parentRecSourceId);
		}

		template <typename StatusType> void onRequestStart(StatusType* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_INT64 callerStatementId, ISC_INT64 callerRequestId, ISC_TIMESTAMP_TZ timestamp)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->onRequestStart(this, status, statementId, requestId, callerStatementId, callerRequestId, timestamp);
			StatusType::checkException(status);
		}

		template <typename StatusType> void onRequestFinish(StatusType* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_TIMESTAMP_TZ timestamp, IProfilerStats* stats)
		{
			StatusType::clearException(status);
			static_cast<VTable*>(this->cloopVTable)->onRequestFinish(this, status, statementId, requestId, timestamp, stats);
			StatusType::checkException(status);
		}

		void beforePsqlLineColumn(ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column)
		{
			static_cast<VTable*>(this->cloopVTable)->beforePsqlLineColumn(this, statementId, requestId, line, column);
		}

		void afterPsqlLineColumn(ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column, IProfilerStats* stats)
		{
			static_cast<VTable*>(this->cloopVTable)->afterPsqlLineColumn(this, statementId, requestId, line, column, stats);
		}

		void beforeRecordSourceOpen(ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId)
		{
			static_cast<VTable*>(this->cloopVTable)->beforeRecordSourceOpen(this, statementId, requestId, cursorId, recSourceId);
		}

		void afterRecordSourceOpen(ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, IProfilerStats* stats)
		{
			static_cast<VTable*>(this->cloopVTable)->afterRecordSourceOpen(this, statementId, requestId, cursorId, recSourceId, stats);
		}

		void beforeRecordSourceGetRecord(ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId)
		{
			static_cast<VTable*>(this->cloopVTable)->beforeRecordSourceGetRecord(this, statementId, requestId, cursorId, recSourceId);
		}

		void afterRecordSourceGetRecord(ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, IProfilerStats* stats)
		{
			static_cast<VTable*>(this->cloopVTable)->afterRecordSourceGetRecord(this, statementId, requestId, cursorId, recSourceId, stats);
		}
	};

#define FIREBIRD_IPROFILER_STATS_VERSION 2u

	class IProfilerStats : public IVersioned
	{
	public:
		struct VTable : public IVersioned::VTable
		{
			ISC_UINT64 (CLOOP_CARG *getElapsedTicks)(IProfilerStats* self) CLOOP_NOEXCEPT;
		};

	protected:
		IProfilerStats(DoNotInherit)
			: IVersioned(DoNotInherit())
		{
		}

		~IProfilerStats()
		{
		}

	public:
		static CLOOP_CONSTEXPR unsigned VERSION = FIREBIRD_IPROFILER_STATS_VERSION;

		ISC_UINT64 getElapsedTicks()
		{
			ISC_UINT64 ret = static_cast<VTable*>(this->cloopVTable)->getElapsedTicks(this);
			return ret;
		}
	};

	// Interfaces implementations

	template <typename Name, typename StatusType, typename Base>
	class IVersionedBaseImpl : public Base
	{
	public:
		typedef IVersioned Declaration;

		IVersionedBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}
	};

	template <typename Name, typename StatusType, typename Base = Inherit<IVersioned> >
	class IVersionedImpl : public IVersionedBaseImpl<Name, StatusType, Base>
	{
	protected:
		IVersionedImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IVersionedImpl()
		{
		}

	};

	template <typename Name, typename StatusType, typename Base>
	class IReferenceCountedBaseImpl : public Base
	{
	public:
		typedef IReferenceCounted Declaration;

		IReferenceCountedBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IReferenceCounted> > >
	class IReferenceCountedImpl : public IReferenceCountedBaseImpl<Name, StatusType, Base>
	{
	protected:
		IReferenceCountedImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IReferenceCountedImpl()
		{
		}

		virtual void addRef() = 0;
		virtual int release() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IDisposableBaseImpl : public Base
	{
	public:
		typedef IDisposable Declaration;

		IDisposableBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IDisposable> > >
	class IDisposableImpl : public IDisposableBaseImpl<Name, StatusType, Base>
	{
	protected:
		IDisposableImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IDisposableImpl()
		{
		}

		virtual void dispose() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IStatusBaseImpl : public Base
	{
	public:
		typedef IStatus Declaration;

		IStatusBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->init = &Name::cloopinitDispatcher;
					this->getState = &Name::cloopgetStateDispatcher;
					this->setErrors2 = &Name::cloopsetErrors2Dispatcher;
					this->setWarnings2 = &Name::cloopsetWarnings2Dispatcher;
					this->setErrors = &Name::cloopsetErrorsDispatcher;
					this->setWarnings = &Name::cloopsetWarningsDispatcher;
					this->getErrors = &Name::cloopgetErrorsDispatcher;
					this->getWarnings = &Name::cloopgetWarningsDispatcher;
					this->clone = &Name::cloopcloneDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopinitDispatcher(IStatus* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::init();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetStateDispatcher(const IStatus* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<const Name*>(self)->Name::getState();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopsetErrors2Dispatcher(IStatus* self, unsigned length, const intptr_t* value) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setErrors2(length, value);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopsetWarnings2Dispatcher(IStatus* self, unsigned length, const intptr_t* value) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setWarnings2(length, value);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopsetErrorsDispatcher(IStatus* self, const intptr_t* value) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setErrors(value);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopsetWarningsDispatcher(IStatus* self, const intptr_t* value) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setWarnings(value);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static const intptr_t* CLOOP_CARG cloopgetErrorsDispatcher(const IStatus* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<const Name*>(self)->Name::getErrors();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return stubError();
			}
		}

		static const intptr_t* CLOOP_CARG cloopgetWarningsDispatcher(const IStatus* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<const Name*>(self)->Name::getWarnings();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return stubError();
			}
		}

		static IStatus* CLOOP_CARG cloopcloneDispatcher(const IStatus* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<const Name*>(self)->Name::clone();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IStatus*>(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IStatus> > > > >
	class IStatusImpl : public IStatusBaseImpl<Name, StatusType, Base>
	{
	protected:
		IStatusImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IStatusImpl()
		{
		}

		virtual void init() = 0;
		virtual unsigned getState() const = 0;
		virtual void setErrors2(unsigned length, const intptr_t* value) = 0;
		virtual void setWarnings2(unsigned length, const intptr_t* value) = 0;
		virtual void setErrors(const intptr_t* value) = 0;
		virtual void setWarnings(const intptr_t* value) = 0;
		virtual const intptr_t* getErrors() const = 0;
		virtual const intptr_t* getWarnings() const = 0;
		virtual IStatus* clone() const = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IMasterBaseImpl : public Base
	{
	public:
		typedef IMaster Declaration;

		IMasterBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getStatus = &Name::cloopgetStatusDispatcher;
					this->getDispatcher = &Name::cloopgetDispatcherDispatcher;
					this->getPluginManager = &Name::cloopgetPluginManagerDispatcher;
					this->getTimerControl = &Name::cloopgetTimerControlDispatcher;
					this->getDtc = &Name::cloopgetDtcDispatcher;
					this->registerAttachment = &Name::cloopregisterAttachmentDispatcher;
					this->registerTransaction = &Name::cloopregisterTransactionDispatcher;
					this->getMetadataBuilder = &Name::cloopgetMetadataBuilderDispatcher;
					this->serverMode = &Name::cloopserverModeDispatcher;
					this->getUtilInterface = &Name::cloopgetUtilInterfaceDispatcher;
					this->getConfigManager = &Name::cloopgetConfigManagerDispatcher;
					this->getProcessExiting = &Name::cloopgetProcessExitingDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static IStatus* CLOOP_CARG cloopgetStatusDispatcher(IMaster* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getStatus();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IStatus*>(0);
			}
		}

		static IProvider* CLOOP_CARG cloopgetDispatcherDispatcher(IMaster* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDispatcher();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IProvider*>(0);
			}
		}

		static IPluginManager* CLOOP_CARG cloopgetPluginManagerDispatcher(IMaster* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPluginManager();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IPluginManager*>(0);
			}
		}

		static ITimerControl* CLOOP_CARG cloopgetTimerControlDispatcher(IMaster* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getTimerControl();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ITimerControl*>(0);
			}
		}

		static IDtc* CLOOP_CARG cloopgetDtcDispatcher(IMaster* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDtc();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IDtc*>(0);
			}
		}

		static IAttachment* CLOOP_CARG cloopregisterAttachmentDispatcher(IMaster* self, IProvider* provider, IAttachment* attachment) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::registerAttachment(provider, attachment);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IAttachment*>(0);
			}
		}

		static ITransaction* CLOOP_CARG cloopregisterTransactionDispatcher(IMaster* self, IAttachment* attachment, ITransaction* transaction) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::registerTransaction(attachment, transaction);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ITransaction*>(0);
			}
		}

		static IMetadataBuilder* CLOOP_CARG cloopgetMetadataBuilderDispatcher(IMaster* self, IStatus* status, unsigned fieldCount) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getMetadataBuilder(&status2, fieldCount);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMetadataBuilder*>(0);
			}
		}

		static int CLOOP_CARG cloopserverModeDispatcher(IMaster* self, int mode) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::serverMode(mode);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static IUtil* CLOOP_CARG cloopgetUtilInterfaceDispatcher(IMaster* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getUtilInterface();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IUtil*>(0);
			}
		}

		static IConfigManager* CLOOP_CARG cloopgetConfigManagerDispatcher(IMaster* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getConfigManager();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IConfigManager*>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopgetProcessExitingDispatcher(IMaster* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getProcessExiting();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IMaster> > >
	class IMasterImpl : public IMasterBaseImpl<Name, StatusType, Base>
	{
	protected:
		IMasterImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IMasterImpl()
		{
		}

		virtual IStatus* getStatus() = 0;
		virtual IProvider* getDispatcher() = 0;
		virtual IPluginManager* getPluginManager() = 0;
		virtual ITimerControl* getTimerControl() = 0;
		virtual IDtc* getDtc() = 0;
		virtual IAttachment* registerAttachment(IProvider* provider, IAttachment* attachment) = 0;
		virtual ITransaction* registerTransaction(IAttachment* attachment, ITransaction* transaction) = 0;
		virtual IMetadataBuilder* getMetadataBuilder(StatusType* status, unsigned fieldCount) = 0;
		virtual int serverMode(int mode) = 0;
		virtual IUtil* getUtilInterface() = 0;
		virtual IConfigManager* getConfigManager() = 0;
		virtual FB_BOOLEAN getProcessExiting() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IPluginBaseBaseImpl : public Base
	{
	public:
		typedef IPluginBase Declaration;

		IPluginBaseBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IPluginBase> > > > >
	class IPluginBaseImpl : public IPluginBaseBaseImpl<Name, StatusType, Base>
	{
	protected:
		IPluginBaseImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IPluginBaseImpl()
		{
		}

		virtual void setOwner(IReferenceCounted* r) = 0;
		virtual IReferenceCounted* getOwner() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IPluginSetBaseImpl : public Base
	{
	public:
		typedef IPluginSet Declaration;

		IPluginSetBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getName = &Name::cloopgetNameDispatcher;
					this->getModuleName = &Name::cloopgetModuleNameDispatcher;
					this->getPlugin = &Name::cloopgetPluginDispatcher;
					this->next = &Name::cloopnextDispatcher;
					this->set = &Name::cloopsetDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetNameDispatcher(const IPluginSet* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<const Name*>(self)->Name::getName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetModuleNameDispatcher(const IPluginSet* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<const Name*>(self)->Name::getModuleName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static IPluginBase* CLOOP_CARG cloopgetPluginDispatcher(IPluginSet* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getPlugin(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IPluginBase*>(0);
			}
		}

		static void CLOOP_CARG cloopnextDispatcher(IPluginSet* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::next(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetDispatcher(IPluginSet* self, IStatus* status, const char* s) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::set(&status2, s);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IPluginSet> > > > >
	class IPluginSetImpl : public IPluginSetBaseImpl<Name, StatusType, Base>
	{
	protected:
		IPluginSetImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IPluginSetImpl()
		{
		}

		virtual const char* getName() const = 0;
		virtual const char* getModuleName() const = 0;
		virtual IPluginBase* getPlugin(StatusType* status) = 0;
		virtual void next(StatusType* status) = 0;
		virtual void set(StatusType* status, const char* s) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IConfigEntryBaseImpl : public Base
	{
	public:
		typedef IConfigEntry Declaration;

		IConfigEntryBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getName = &Name::cloopgetNameDispatcher;
					this->getValue = &Name::cloopgetValueDispatcher;
					this->getIntValue = &Name::cloopgetIntValueDispatcher;
					this->getBoolValue = &Name::cloopgetBoolValueDispatcher;
					this->getSubConfig = &Name::cloopgetSubConfigDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetNameDispatcher(IConfigEntry* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetValueDispatcher(IConfigEntry* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getValue();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetIntValueDispatcher(IConfigEntry* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getIntValue();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopgetBoolValueDispatcher(IConfigEntry* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getBoolValue();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static IConfig* CLOOP_CARG cloopgetSubConfigDispatcher(IConfigEntry* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getSubConfig(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IConfig*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IConfigEntry> > > > >
	class IConfigEntryImpl : public IConfigEntryBaseImpl<Name, StatusType, Base>
	{
	protected:
		IConfigEntryImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IConfigEntryImpl()
		{
		}

		virtual const char* getName() = 0;
		virtual const char* getValue() = 0;
		virtual ISC_INT64 getIntValue() = 0;
		virtual FB_BOOLEAN getBoolValue() = 0;
		virtual IConfig* getSubConfig(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IConfigBaseImpl : public Base
	{
	public:
		typedef IConfig Declaration;

		IConfigBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->find = &Name::cloopfindDispatcher;
					this->findValue = &Name::cloopfindValueDispatcher;
					this->findPos = &Name::cloopfindPosDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static IConfigEntry* CLOOP_CARG cloopfindDispatcher(IConfig* self, IStatus* status, const char* name) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::find(&status2, name);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IConfigEntry*>(0);
			}
		}

		static IConfigEntry* CLOOP_CARG cloopfindValueDispatcher(IConfig* self, IStatus* status, const char* name, const char* value) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::findValue(&status2, name, value);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IConfigEntry*>(0);
			}
		}

		static IConfigEntry* CLOOP_CARG cloopfindPosDispatcher(IConfig* self, IStatus* status, const char* name, unsigned pos) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::findPos(&status2, name, pos);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IConfigEntry*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IConfig> > > > >
	class IConfigImpl : public IConfigBaseImpl<Name, StatusType, Base>
	{
	protected:
		IConfigImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IConfigImpl()
		{
		}

		virtual IConfigEntry* find(StatusType* status, const char* name) = 0;
		virtual IConfigEntry* findValue(StatusType* status, const char* name, const char* value) = 0;
		virtual IConfigEntry* findPos(StatusType* status, const char* name, unsigned pos) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IFirebirdConfBaseImpl : public Base
	{
	public:
		typedef IFirebirdConf Declaration;

		IFirebirdConfBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getKey = &Name::cloopgetKeyDispatcher;
					this->asInteger = &Name::cloopasIntegerDispatcher;
					this->asString = &Name::cloopasStringDispatcher;
					this->asBoolean = &Name::cloopasBooleanDispatcher;
					this->getVersion = &Name::cloopgetVersionDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopgetKeyDispatcher(IFirebirdConf* self, const char* name) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getKey(name);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopasIntegerDispatcher(IFirebirdConf* self, unsigned key) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::asInteger(key);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static const char* CLOOP_CARG cloopasStringDispatcher(IFirebirdConf* self, unsigned key) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::asString(key);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopasBooleanDispatcher(IFirebirdConf* self, unsigned key) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::asBoolean(key);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetVersionDispatcher(IFirebirdConf* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getVersion(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IFirebirdConf> > > > >
	class IFirebirdConfImpl : public IFirebirdConfBaseImpl<Name, StatusType, Base>
	{
	protected:
		IFirebirdConfImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IFirebirdConfImpl()
		{
		}

		virtual unsigned getKey(const char* name) = 0;
		virtual ISC_INT64 asInteger(unsigned key) = 0;
		virtual const char* asString(unsigned key) = 0;
		virtual FB_BOOLEAN asBoolean(unsigned key) = 0;
		virtual unsigned getVersion(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IPluginConfigBaseImpl : public Base
	{
	public:
		typedef IPluginConfig Declaration;

		IPluginConfigBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getConfigFileName = &Name::cloopgetConfigFileNameDispatcher;
					this->getDefaultConfig = &Name::cloopgetDefaultConfigDispatcher;
					this->getFirebirdConf = &Name::cloopgetFirebirdConfDispatcher;
					this->setReleaseDelay = &Name::cloopsetReleaseDelayDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetConfigFileNameDispatcher(IPluginConfig* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getConfigFileName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static IConfig* CLOOP_CARG cloopgetDefaultConfigDispatcher(IPluginConfig* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getDefaultConfig(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IConfig*>(0);
			}
		}

		static IFirebirdConf* CLOOP_CARG cloopgetFirebirdConfDispatcher(IPluginConfig* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getFirebirdConf(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IFirebirdConf*>(0);
			}
		}

		static void CLOOP_CARG cloopsetReleaseDelayDispatcher(IPluginConfig* self, IStatus* status, ISC_UINT64 microSeconds) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setReleaseDelay(&status2, microSeconds);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IPluginConfig> > > > >
	class IPluginConfigImpl : public IPluginConfigBaseImpl<Name, StatusType, Base>
	{
	protected:
		IPluginConfigImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IPluginConfigImpl()
		{
		}

		virtual const char* getConfigFileName() = 0;
		virtual IConfig* getDefaultConfig(StatusType* status) = 0;
		virtual IFirebirdConf* getFirebirdConf(StatusType* status) = 0;
		virtual void setReleaseDelay(StatusType* status, ISC_UINT64 microSeconds) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IPluginFactoryBaseImpl : public Base
	{
	public:
		typedef IPluginFactory Declaration;

		IPluginFactoryBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->createPlugin = &Name::cloopcreatePluginDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static IPluginBase* CLOOP_CARG cloopcreatePluginDispatcher(IPluginFactory* self, IStatus* status, IPluginConfig* factoryParameter) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::createPlugin(&status2, factoryParameter);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IPluginBase*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IPluginFactory> > >
	class IPluginFactoryImpl : public IPluginFactoryBaseImpl<Name, StatusType, Base>
	{
	protected:
		IPluginFactoryImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IPluginFactoryImpl()
		{
		}

		virtual IPluginBase* createPlugin(StatusType* status, IPluginConfig* factoryParameter) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IPluginModuleBaseImpl : public Base
	{
	public:
		typedef IPluginModule Declaration;

		IPluginModuleBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->doClean = &Name::cloopdoCleanDispatcher;
					this->threadDetach = &Name::cloopthreadDetachDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopdoCleanDispatcher(IPluginModule* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::doClean();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopthreadDetachDispatcher(IPluginModule* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::threadDetach();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IPluginModule> > >
	class IPluginModuleImpl : public IPluginModuleBaseImpl<Name, StatusType, Base>
	{
	protected:
		IPluginModuleImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IPluginModuleImpl()
		{
		}

		virtual void doClean() = 0;
		virtual void threadDetach() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IPluginManagerBaseImpl : public Base
	{
	public:
		typedef IPluginManager Declaration;

		IPluginManagerBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->registerPluginFactory = &Name::cloopregisterPluginFactoryDispatcher;
					this->registerModule = &Name::cloopregisterModuleDispatcher;
					this->unregisterModule = &Name::cloopunregisterModuleDispatcher;
					this->getPlugins = &Name::cloopgetPluginsDispatcher;
					this->getConfig = &Name::cloopgetConfigDispatcher;
					this->releasePlugin = &Name::cloopreleasePluginDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopregisterPluginFactoryDispatcher(IPluginManager* self, unsigned pluginType, const char* defaultName, IPluginFactory* factory) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::registerPluginFactory(pluginType, defaultName, factory);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopregisterModuleDispatcher(IPluginManager* self, IPluginModule* cleanup) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::registerModule(cleanup);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopunregisterModuleDispatcher(IPluginManager* self, IPluginModule* cleanup) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::unregisterModule(cleanup);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IPluginSet* CLOOP_CARG cloopgetPluginsDispatcher(IPluginManager* self, IStatus* status, unsigned pluginType, const char* namesList, IFirebirdConf* firebirdConf) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getPlugins(&status2, pluginType, namesList, firebirdConf);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IPluginSet*>(0);
			}
		}

		static IConfig* CLOOP_CARG cloopgetConfigDispatcher(IPluginManager* self, IStatus* status, const char* filename) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getConfig(&status2, filename);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IConfig*>(0);
			}
		}

		static void CLOOP_CARG cloopreleasePluginDispatcher(IPluginManager* self, IPluginBase* plugin) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::releasePlugin(plugin);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IPluginManager> > >
	class IPluginManagerImpl : public IPluginManagerBaseImpl<Name, StatusType, Base>
	{
	protected:
		IPluginManagerImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IPluginManagerImpl()
		{
		}

		virtual void registerPluginFactory(unsigned pluginType, const char* defaultName, IPluginFactory* factory) = 0;
		virtual void registerModule(IPluginModule* cleanup) = 0;
		virtual void unregisterModule(IPluginModule* cleanup) = 0;
		virtual IPluginSet* getPlugins(StatusType* status, unsigned pluginType, const char* namesList, IFirebirdConf* firebirdConf) = 0;
		virtual IConfig* getConfig(StatusType* status, const char* filename) = 0;
		virtual void releasePlugin(IPluginBase* plugin) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ICryptKeyBaseImpl : public Base
	{
	public:
		typedef ICryptKey Declaration;

		ICryptKeyBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->setSymmetric = &Name::cloopsetSymmetricDispatcher;
					this->setAsymmetric = &Name::cloopsetAsymmetricDispatcher;
					this->getEncryptKey = &Name::cloopgetEncryptKeyDispatcher;
					this->getDecryptKey = &Name::cloopgetDecryptKeyDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetSymmetricDispatcher(ICryptKey* self, IStatus* status, const char* type, unsigned keyLength, const void* key) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setSymmetric(&status2, type, keyLength, key);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetAsymmetricDispatcher(ICryptKey* self, IStatus* status, const char* type, unsigned encryptKeyLength, const void* encryptKey, unsigned decryptKeyLength, const void* decryptKey) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setAsymmetric(&status2, type, encryptKeyLength, encryptKey, decryptKeyLength, decryptKey);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static const void* CLOOP_CARG cloopgetEncryptKeyDispatcher(ICryptKey* self, unsigned* length) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getEncryptKey(length);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const void*>(0);
			}
		}

		static const void* CLOOP_CARG cloopgetDecryptKeyDispatcher(ICryptKey* self, unsigned* length) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDecryptKey(length);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const void*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ICryptKey> > >
	class ICryptKeyImpl : public ICryptKeyBaseImpl<Name, StatusType, Base>
	{
	protected:
		ICryptKeyImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ICryptKeyImpl()
		{
		}

		virtual void setSymmetric(StatusType* status, const char* type, unsigned keyLength, const void* key) = 0;
		virtual void setAsymmetric(StatusType* status, const char* type, unsigned encryptKeyLength, const void* encryptKey, unsigned decryptKeyLength, const void* decryptKey) = 0;
		virtual const void* getEncryptKey(unsigned* length) = 0;
		virtual const void* getDecryptKey(unsigned* length) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IConfigManagerBaseImpl : public Base
	{
	public:
		typedef IConfigManager Declaration;

		IConfigManagerBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getDirectory = &Name::cloopgetDirectoryDispatcher;
					this->getFirebirdConf = &Name::cloopgetFirebirdConfDispatcher;
					this->getDatabaseConf = &Name::cloopgetDatabaseConfDispatcher;
					this->getPluginConfig = &Name::cloopgetPluginConfigDispatcher;
					this->getInstallDirectory = &Name::cloopgetInstallDirectoryDispatcher;
					this->getRootDirectory = &Name::cloopgetRootDirectoryDispatcher;
					this->getDefaultSecurityDb = &Name::cloopgetDefaultSecurityDbDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetDirectoryDispatcher(IConfigManager* self, unsigned code) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDirectory(code);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static IFirebirdConf* CLOOP_CARG cloopgetFirebirdConfDispatcher(IConfigManager* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getFirebirdConf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IFirebirdConf*>(0);
			}
		}

		static IFirebirdConf* CLOOP_CARG cloopgetDatabaseConfDispatcher(IConfigManager* self, const char* dbName) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDatabaseConf(dbName);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IFirebirdConf*>(0);
			}
		}

		static IConfig* CLOOP_CARG cloopgetPluginConfigDispatcher(IConfigManager* self, const char* configuredPlugin) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPluginConfig(configuredPlugin);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IConfig*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetInstallDirectoryDispatcher(IConfigManager* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getInstallDirectory();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRootDirectoryDispatcher(IConfigManager* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRootDirectory();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetDefaultSecurityDbDispatcher(IConfigManager* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDefaultSecurityDb();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IConfigManager> > >
	class IConfigManagerImpl : public IConfigManagerBaseImpl<Name, StatusType, Base>
	{
	protected:
		IConfigManagerImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IConfigManagerImpl()
		{
		}

		virtual const char* getDirectory(unsigned code) = 0;
		virtual IFirebirdConf* getFirebirdConf() = 0;
		virtual IFirebirdConf* getDatabaseConf(const char* dbName) = 0;
		virtual IConfig* getPluginConfig(const char* configuredPlugin) = 0;
		virtual const char* getInstallDirectory() = 0;
		virtual const char* getRootDirectory() = 0;
		virtual const char* getDefaultSecurityDb() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IEventCallbackBaseImpl : public Base
	{
	public:
		typedef IEventCallback Declaration;

		IEventCallbackBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->eventCallbackFunction = &Name::cloopeventCallbackFunctionDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopeventCallbackFunctionDispatcher(IEventCallback* self, unsigned length, const unsigned char* events) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::eventCallbackFunction(length, events);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IEventCallback> > > > >
	class IEventCallbackImpl : public IEventCallbackBaseImpl<Name, StatusType, Base>
	{
	protected:
		IEventCallbackImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IEventCallbackImpl()
		{
		}

		virtual void eventCallbackFunction(unsigned length, const unsigned char* events) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IBlobBaseImpl : public Base
	{
	public:
		typedef IBlob Declaration;

		IBlobBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getInfo = &Name::cloopgetInfoDispatcher;
					this->getSegment = &Name::cloopgetSegmentDispatcher;
					this->putSegment = &Name::cloopputSegmentDispatcher;
					this->deprecatedCancel = &Name::cloopdeprecatedCancelDispatcher;
					this->deprecatedClose = &Name::cloopdeprecatedCloseDispatcher;
					this->seek = &Name::cloopseekDispatcher;
					this->cancel = &Name::cloopcancelDispatcher;
					this->close = &Name::cloopcloseDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopgetInfoDispatcher(IBlob* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getInfo(&status2, itemsLength, items, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static int CLOOP_CARG cloopgetSegmentDispatcher(IBlob* self, IStatus* status, unsigned bufferLength, void* buffer, unsigned* segmentLength) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getSegment(&status2, bufferLength, buffer, segmentLength);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopputSegmentDispatcher(IBlob* self, IStatus* status, unsigned length, const void* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::putSegment(&status2, length, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedCancelDispatcher(IBlob* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedCancel(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedCloseDispatcher(IBlob* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedClose(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static int CLOOP_CARG cloopseekDispatcher(IBlob* self, IStatus* status, int mode, int offset) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::seek(&status2, mode, offset);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopcancelDispatcher(IBlob* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::cancel(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcloseDispatcher(IBlob* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::close(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IBlob> > > > >
	class IBlobImpl : public IBlobBaseImpl<Name, StatusType, Base>
	{
	protected:
		IBlobImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IBlobImpl()
		{
		}

		virtual void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) = 0;
		virtual int getSegment(StatusType* status, unsigned bufferLength, void* buffer, unsigned* segmentLength) = 0;
		virtual void putSegment(StatusType* status, unsigned length, const void* buffer) = 0;
		virtual void deprecatedCancel(StatusType* status) = 0;
		virtual void deprecatedClose(StatusType* status) = 0;
		virtual int seek(StatusType* status, int mode, int offset) = 0;
		virtual void cancel(StatusType* status) = 0;
		virtual void close(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITransactionBaseImpl : public Base
	{
	public:
		typedef ITransaction Declaration;

		ITransactionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getInfo = &Name::cloopgetInfoDispatcher;
					this->prepare = &Name::cloopprepareDispatcher;
					this->deprecatedCommit = &Name::cloopdeprecatedCommitDispatcher;
					this->commitRetaining = &Name::cloopcommitRetainingDispatcher;
					this->deprecatedRollback = &Name::cloopdeprecatedRollbackDispatcher;
					this->rollbackRetaining = &Name::clooprollbackRetainingDispatcher;
					this->deprecatedDisconnect = &Name::cloopdeprecatedDisconnectDispatcher;
					this->join = &Name::cloopjoinDispatcher;
					this->validate = &Name::cloopvalidateDispatcher;
					this->enterDtc = &Name::cloopenterDtcDispatcher;
					this->commit = &Name::cloopcommitDispatcher;
					this->rollback = &Name::clooprollbackDispatcher;
					this->disconnect = &Name::cloopdisconnectDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopgetInfoDispatcher(ITransaction* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getInfo(&status2, itemsLength, items, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopprepareDispatcher(ITransaction* self, IStatus* status, unsigned msgLength, const unsigned char* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::prepare(&status2, msgLength, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedCommitDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedCommit(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcommitRetainingDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::commitRetaining(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedRollbackDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedRollback(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooprollbackRetainingDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::rollbackRetaining(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedDisconnectDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedDisconnect(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static ITransaction* CLOOP_CARG cloopjoinDispatcher(ITransaction* self, IStatus* status, ITransaction* transaction) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::join(&status2, transaction);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static ITransaction* CLOOP_CARG cloopvalidateDispatcher(ITransaction* self, IStatus* status, IAttachment* attachment) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::validate(&status2, attachment);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static ITransaction* CLOOP_CARG cloopenterDtcDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::enterDtc(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static void CLOOP_CARG cloopcommitDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::commit(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooprollbackDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::rollback(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdisconnectDispatcher(ITransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::disconnect(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITransaction> > > > >
	class ITransactionImpl : public ITransactionBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITransactionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITransactionImpl()
		{
		}

		virtual void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) = 0;
		virtual void prepare(StatusType* status, unsigned msgLength, const unsigned char* message) = 0;
		virtual void deprecatedCommit(StatusType* status) = 0;
		virtual void commitRetaining(StatusType* status) = 0;
		virtual void deprecatedRollback(StatusType* status) = 0;
		virtual void rollbackRetaining(StatusType* status) = 0;
		virtual void deprecatedDisconnect(StatusType* status) = 0;
		virtual ITransaction* join(StatusType* status, ITransaction* transaction) = 0;
		virtual ITransaction* validate(StatusType* status, IAttachment* attachment) = 0;
		virtual ITransaction* enterDtc(StatusType* status) = 0;
		virtual void commit(StatusType* status) = 0;
		virtual void rollback(StatusType* status) = 0;
		virtual void disconnect(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IMessageMetadataBaseImpl : public Base
	{
	public:
		typedef IMessageMetadata Declaration;

		IMessageMetadataBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getCount = &Name::cloopgetCountDispatcher;
					this->getField = &Name::cloopgetFieldDispatcher;
					this->getRelation = &Name::cloopgetRelationDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->getAlias = &Name::cloopgetAliasDispatcher;
					this->getType = &Name::cloopgetTypeDispatcher;
					this->isNullable = &Name::cloopisNullableDispatcher;
					this->getSubType = &Name::cloopgetSubTypeDispatcher;
					this->getLength = &Name::cloopgetLengthDispatcher;
					this->getScale = &Name::cloopgetScaleDispatcher;
					this->getCharSet = &Name::cloopgetCharSetDispatcher;
					this->getOffset = &Name::cloopgetOffsetDispatcher;
					this->getNullOffset = &Name::cloopgetNullOffsetDispatcher;
					this->getBuilder = &Name::cloopgetBuilderDispatcher;
					this->getMessageLength = &Name::cloopgetMessageLengthDispatcher;
					this->getAlignment = &Name::cloopgetAlignmentDispatcher;
					this->getAlignedLength = &Name::cloopgetAlignedLengthDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopgetCountDispatcher(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getCount(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetFieldDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getField(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRelationDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getRelation(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetOwnerDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getOwner(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetAliasDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getAlias(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetTypeDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getType(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopisNullableDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::isNullable(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static int CLOOP_CARG cloopgetSubTypeDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getSubType(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetLengthDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getLength(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static int CLOOP_CARG cloopgetScaleDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getScale(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetCharSetDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getCharSet(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetOffsetDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getOffset(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetNullOffsetDispatcher(IMessageMetadata* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getNullOffset(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static IMetadataBuilder* CLOOP_CARG cloopgetBuilderDispatcher(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getBuilder(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMetadataBuilder*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetMessageLengthDispatcher(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getMessageLength(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetAlignmentDispatcher(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getAlignment(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetAlignedLengthDispatcher(IMessageMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getAlignedLength(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IMessageMetadata> > > > >
	class IMessageMetadataImpl : public IMessageMetadataBaseImpl<Name, StatusType, Base>
	{
	protected:
		IMessageMetadataImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IMessageMetadataImpl()
		{
		}

		virtual unsigned getCount(StatusType* status) = 0;
		virtual const char* getField(StatusType* status, unsigned index) = 0;
		virtual const char* getRelation(StatusType* status, unsigned index) = 0;
		virtual const char* getOwner(StatusType* status, unsigned index) = 0;
		virtual const char* getAlias(StatusType* status, unsigned index) = 0;
		virtual unsigned getType(StatusType* status, unsigned index) = 0;
		virtual FB_BOOLEAN isNullable(StatusType* status, unsigned index) = 0;
		virtual int getSubType(StatusType* status, unsigned index) = 0;
		virtual unsigned getLength(StatusType* status, unsigned index) = 0;
		virtual int getScale(StatusType* status, unsigned index) = 0;
		virtual unsigned getCharSet(StatusType* status, unsigned index) = 0;
		virtual unsigned getOffset(StatusType* status, unsigned index) = 0;
		virtual unsigned getNullOffset(StatusType* status, unsigned index) = 0;
		virtual IMetadataBuilder* getBuilder(StatusType* status) = 0;
		virtual unsigned getMessageLength(StatusType* status) = 0;
		virtual unsigned getAlignment(StatusType* status) = 0;
		virtual unsigned getAlignedLength(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IMetadataBuilderBaseImpl : public Base
	{
	public:
		typedef IMetadataBuilder Declaration;

		IMetadataBuilderBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setType = &Name::cloopsetTypeDispatcher;
					this->setSubType = &Name::cloopsetSubTypeDispatcher;
					this->setLength = &Name::cloopsetLengthDispatcher;
					this->setCharSet = &Name::cloopsetCharSetDispatcher;
					this->setScale = &Name::cloopsetScaleDispatcher;
					this->truncate = &Name::clooptruncateDispatcher;
					this->moveNameToIndex = &Name::cloopmoveNameToIndexDispatcher;
					this->remove = &Name::cloopremoveDispatcher;
					this->addField = &Name::cloopaddFieldDispatcher;
					this->getMetadata = &Name::cloopgetMetadataDispatcher;
					this->setField = &Name::cloopsetFieldDispatcher;
					this->setRelation = &Name::cloopsetRelationDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->setAlias = &Name::cloopsetAliasDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetTypeDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, unsigned type) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setType(&status2, index, type);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetSubTypeDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, int subType) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setSubType(&status2, index, subType);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetLengthDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, unsigned length) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setLength(&status2, index, length);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetCharSetDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, unsigned charSet) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setCharSet(&status2, index, charSet);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetScaleDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, int scale) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setScale(&status2, index, scale);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooptruncateDispatcher(IMetadataBuilder* self, IStatus* status, unsigned count) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::truncate(&status2, count);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopmoveNameToIndexDispatcher(IMetadataBuilder* self, IStatus* status, const char* name, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::moveNameToIndex(&status2, name, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopremoveDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::remove(&status2, index);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static unsigned CLOOP_CARG cloopaddFieldDispatcher(IMetadataBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::addField(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static IMessageMetadata* CLOOP_CARG cloopgetMetadataDispatcher(IMetadataBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getMetadata(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMessageMetadata*>(0);
			}
		}

		static void CLOOP_CARG cloopsetFieldDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, const char* field) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setField(&status2, index, field);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetRelationDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, const char* relation) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setRelation(&status2, index, relation);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, const char* owner) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setOwner(&status2, index, owner);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetAliasDispatcher(IMetadataBuilder* self, IStatus* status, unsigned index, const char* alias) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setAlias(&status2, index, alias);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IMetadataBuilder> > > > >
	class IMetadataBuilderImpl : public IMetadataBuilderBaseImpl<Name, StatusType, Base>
	{
	protected:
		IMetadataBuilderImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IMetadataBuilderImpl()
		{
		}

		virtual void setType(StatusType* status, unsigned index, unsigned type) = 0;
		virtual void setSubType(StatusType* status, unsigned index, int subType) = 0;
		virtual void setLength(StatusType* status, unsigned index, unsigned length) = 0;
		virtual void setCharSet(StatusType* status, unsigned index, unsigned charSet) = 0;
		virtual void setScale(StatusType* status, unsigned index, int scale) = 0;
		virtual void truncate(StatusType* status, unsigned count) = 0;
		virtual void moveNameToIndex(StatusType* status, const char* name, unsigned index) = 0;
		virtual void remove(StatusType* status, unsigned index) = 0;
		virtual unsigned addField(StatusType* status) = 0;
		virtual IMessageMetadata* getMetadata(StatusType* status) = 0;
		virtual void setField(StatusType* status, unsigned index, const char* field) = 0;
		virtual void setRelation(StatusType* status, unsigned index, const char* relation) = 0;
		virtual void setOwner(StatusType* status, unsigned index, const char* owner) = 0;
		virtual void setAlias(StatusType* status, unsigned index, const char* alias) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IResultSetBaseImpl : public Base
	{
	public:
		typedef IResultSet Declaration;

		IResultSetBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->fetchNext = &Name::cloopfetchNextDispatcher;
					this->fetchPrior = &Name::cloopfetchPriorDispatcher;
					this->fetchFirst = &Name::cloopfetchFirstDispatcher;
					this->fetchLast = &Name::cloopfetchLastDispatcher;
					this->fetchAbsolute = &Name::cloopfetchAbsoluteDispatcher;
					this->fetchRelative = &Name::cloopfetchRelativeDispatcher;
					this->isEof = &Name::cloopisEofDispatcher;
					this->isBof = &Name::cloopisBofDispatcher;
					this->getMetadata = &Name::cloopgetMetadataDispatcher;
					this->deprecatedClose = &Name::cloopdeprecatedCloseDispatcher;
					this->setDelayedOutputFormat = &Name::cloopsetDelayedOutputFormatDispatcher;
					this->close = &Name::cloopcloseDispatcher;
					this->getInfo = &Name::cloopgetInfoDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static int CLOOP_CARG cloopfetchNextDispatcher(IResultSet* self, IStatus* status, void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::fetchNext(&status2, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopfetchPriorDispatcher(IResultSet* self, IStatus* status, void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::fetchPrior(&status2, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopfetchFirstDispatcher(IResultSet* self, IStatus* status, void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::fetchFirst(&status2, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopfetchLastDispatcher(IResultSet* self, IStatus* status, void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::fetchLast(&status2, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopfetchAbsoluteDispatcher(IResultSet* self, IStatus* status, int position, void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::fetchAbsolute(&status2, position, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopfetchRelativeDispatcher(IResultSet* self, IStatus* status, int offset, void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::fetchRelative(&status2, offset, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopisEofDispatcher(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::isEof(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopisBofDispatcher(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::isBof(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static IMessageMetadata* CLOOP_CARG cloopgetMetadataDispatcher(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getMetadata(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMessageMetadata*>(0);
			}
		}

		static void CLOOP_CARG cloopdeprecatedCloseDispatcher(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedClose(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetDelayedOutputFormatDispatcher(IResultSet* self, IStatus* status, IMessageMetadata* format) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setDelayedOutputFormat(&status2, format);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcloseDispatcher(IResultSet* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::close(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopgetInfoDispatcher(IResultSet* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getInfo(&status2, itemsLength, items, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IResultSet> > > > >
	class IResultSetImpl : public IResultSetBaseImpl<Name, StatusType, Base>
	{
	protected:
		IResultSetImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IResultSetImpl()
		{
		}

		virtual int fetchNext(StatusType* status, void* message) = 0;
		virtual int fetchPrior(StatusType* status, void* message) = 0;
		virtual int fetchFirst(StatusType* status, void* message) = 0;
		virtual int fetchLast(StatusType* status, void* message) = 0;
		virtual int fetchAbsolute(StatusType* status, int position, void* message) = 0;
		virtual int fetchRelative(StatusType* status, int offset, void* message) = 0;
		virtual FB_BOOLEAN isEof(StatusType* status) = 0;
		virtual FB_BOOLEAN isBof(StatusType* status) = 0;
		virtual IMessageMetadata* getMetadata(StatusType* status) = 0;
		virtual void deprecatedClose(StatusType* status) = 0;
		virtual void setDelayedOutputFormat(StatusType* status, IMessageMetadata* format) = 0;
		virtual void close(StatusType* status) = 0;
		virtual void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IStatementBaseImpl : public Base
	{
	public:
		typedef IStatement Declaration;

		IStatementBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getInfo = &Name::cloopgetInfoDispatcher;
					this->getType = &Name::cloopgetTypeDispatcher;
					this->getPlan = &Name::cloopgetPlanDispatcher;
					this->getAffectedRecords = &Name::cloopgetAffectedRecordsDispatcher;
					this->getInputMetadata = &Name::cloopgetInputMetadataDispatcher;
					this->getOutputMetadata = &Name::cloopgetOutputMetadataDispatcher;
					this->execute = &Name::cloopexecuteDispatcher;
					this->openCursor = &Name::cloopopenCursorDispatcher;
					this->setCursorName = &Name::cloopsetCursorNameDispatcher;
					this->deprecatedFree = &Name::cloopdeprecatedFreeDispatcher;
					this->getFlags = &Name::cloopgetFlagsDispatcher;
					this->getTimeout = &Name::cloopgetTimeoutDispatcher;
					this->setTimeout = &Name::cloopsetTimeoutDispatcher;
					this->createBatch = &Name::cloopcreateBatchDispatcher;
					this->free = &Name::cloopfreeDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopgetInfoDispatcher(IStatement* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getInfo(&status2, itemsLength, items, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static unsigned CLOOP_CARG cloopgetTypeDispatcher(IStatement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getType(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetPlanDispatcher(IStatement* self, IStatus* status, FB_BOOLEAN detailed) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getPlan(&status2, detailed);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static ISC_UINT64 CLOOP_CARG cloopgetAffectedRecordsDispatcher(IStatement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getAffectedRecords(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ISC_UINT64>(0);
			}
		}

		static IMessageMetadata* CLOOP_CARG cloopgetInputMetadataDispatcher(IStatement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getInputMetadata(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMessageMetadata*>(0);
			}
		}

		static IMessageMetadata* CLOOP_CARG cloopgetOutputMetadataDispatcher(IStatement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getOutputMetadata(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMessageMetadata*>(0);
			}
		}

		static ITransaction* CLOOP_CARG cloopexecuteDispatcher(IStatement* self, IStatus* status, ITransaction* transaction, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, void* outBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::execute(&status2, transaction, inMetadata, inBuffer, outMetadata, outBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static IResultSet* CLOOP_CARG cloopopenCursorDispatcher(IStatement* self, IStatus* status, ITransaction* transaction, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, unsigned flags) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::openCursor(&status2, transaction, inMetadata, inBuffer, outMetadata, flags);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IResultSet*>(0);
			}
		}

		static void CLOOP_CARG cloopsetCursorNameDispatcher(IStatement* self, IStatus* status, const char* name) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setCursorName(&status2, name);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedFreeDispatcher(IStatement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedFree(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static unsigned CLOOP_CARG cloopgetFlagsDispatcher(IStatement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getFlags(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetTimeoutDispatcher(IStatement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getTimeout(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopsetTimeoutDispatcher(IStatement* self, IStatus* status, unsigned timeOut) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setTimeout(&status2, timeOut);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IBatch* CLOOP_CARG cloopcreateBatchDispatcher(IStatement* self, IStatus* status, IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::createBatch(&status2, inMetadata, parLength, par);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IBatch*>(0);
			}
		}

		static void CLOOP_CARG cloopfreeDispatcher(IStatement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::free(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IStatement> > > > >
	class IStatementImpl : public IStatementBaseImpl<Name, StatusType, Base>
	{
	protected:
		IStatementImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IStatementImpl()
		{
		}

		virtual void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) = 0;
		virtual unsigned getType(StatusType* status) = 0;
		virtual const char* getPlan(StatusType* status, FB_BOOLEAN detailed) = 0;
		virtual ISC_UINT64 getAffectedRecords(StatusType* status) = 0;
		virtual IMessageMetadata* getInputMetadata(StatusType* status) = 0;
		virtual IMessageMetadata* getOutputMetadata(StatusType* status) = 0;
		virtual ITransaction* execute(StatusType* status, ITransaction* transaction, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, void* outBuffer) = 0;
		virtual IResultSet* openCursor(StatusType* status, ITransaction* transaction, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, unsigned flags) = 0;
		virtual void setCursorName(StatusType* status, const char* name) = 0;
		virtual void deprecatedFree(StatusType* status) = 0;
		virtual unsigned getFlags(StatusType* status) = 0;
		virtual unsigned getTimeout(StatusType* status) = 0;
		virtual void setTimeout(StatusType* status, unsigned timeOut) = 0;
		virtual IBatch* createBatch(StatusType* status, IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par) = 0;
		virtual void free(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IBatchBaseImpl : public Base
	{
	public:
		typedef IBatch Declaration;

		IBatchBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->add = &Name::cloopaddDispatcher;
					this->addBlob = &Name::cloopaddBlobDispatcher;
					this->appendBlobData = &Name::cloopappendBlobDataDispatcher;
					this->addBlobStream = &Name::cloopaddBlobStreamDispatcher;
					this->registerBlob = &Name::cloopregisterBlobDispatcher;
					this->execute = &Name::cloopexecuteDispatcher;
					this->cancel = &Name::cloopcancelDispatcher;
					this->getBlobAlignment = &Name::cloopgetBlobAlignmentDispatcher;
					this->getMetadata = &Name::cloopgetMetadataDispatcher;
					this->setDefaultBpb = &Name::cloopsetDefaultBpbDispatcher;
					this->deprecatedClose = &Name::cloopdeprecatedCloseDispatcher;
					this->close = &Name::cloopcloseDispatcher;
					this->getInfo = &Name::cloopgetInfoDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopaddDispatcher(IBatch* self, IStatus* status, unsigned count, const void* inBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::add(&status2, count, inBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddBlobDispatcher(IBatch* self, IStatus* status, unsigned length, const void* inBuffer, ISC_QUAD* blobId, unsigned parLength, const unsigned char* par) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::addBlob(&status2, length, inBuffer, blobId, parLength, par);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopappendBlobDataDispatcher(IBatch* self, IStatus* status, unsigned length, const void* inBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::appendBlobData(&status2, length, inBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddBlobStreamDispatcher(IBatch* self, IStatus* status, unsigned length, const void* inBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::addBlobStream(&status2, length, inBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopregisterBlobDispatcher(IBatch* self, IStatus* status, const ISC_QUAD* existingBlob, ISC_QUAD* blobId) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::registerBlob(&status2, existingBlob, blobId);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IBatchCompletionState* CLOOP_CARG cloopexecuteDispatcher(IBatch* self, IStatus* status, ITransaction* transaction) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::execute(&status2, transaction);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IBatchCompletionState*>(0);
			}
		}

		static void CLOOP_CARG cloopcancelDispatcher(IBatch* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::cancel(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static unsigned CLOOP_CARG cloopgetBlobAlignmentDispatcher(IBatch* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getBlobAlignment(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static IMessageMetadata* CLOOP_CARG cloopgetMetadataDispatcher(IBatch* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getMetadata(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMessageMetadata*>(0);
			}
		}

		static void CLOOP_CARG cloopsetDefaultBpbDispatcher(IBatch* self, IStatus* status, unsigned parLength, const unsigned char* par) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setDefaultBpb(&status2, parLength, par);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedCloseDispatcher(IBatch* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedClose(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcloseDispatcher(IBatch* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::close(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopgetInfoDispatcher(IBatch* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getInfo(&status2, itemsLength, items, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IBatch> > > > >
	class IBatchImpl : public IBatchBaseImpl<Name, StatusType, Base>
	{
	protected:
		IBatchImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IBatchImpl()
		{
		}

		virtual void add(StatusType* status, unsigned count, const void* inBuffer) = 0;
		virtual void addBlob(StatusType* status, unsigned length, const void* inBuffer, ISC_QUAD* blobId, unsigned parLength, const unsigned char* par) = 0;
		virtual void appendBlobData(StatusType* status, unsigned length, const void* inBuffer) = 0;
		virtual void addBlobStream(StatusType* status, unsigned length, const void* inBuffer) = 0;
		virtual void registerBlob(StatusType* status, const ISC_QUAD* existingBlob, ISC_QUAD* blobId) = 0;
		virtual IBatchCompletionState* execute(StatusType* status, ITransaction* transaction) = 0;
		virtual void cancel(StatusType* status) = 0;
		virtual unsigned getBlobAlignment(StatusType* status) = 0;
		virtual IMessageMetadata* getMetadata(StatusType* status) = 0;
		virtual void setDefaultBpb(StatusType* status, unsigned parLength, const unsigned char* par) = 0;
		virtual void deprecatedClose(StatusType* status) = 0;
		virtual void close(StatusType* status) = 0;
		virtual void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IBatchCompletionStateBaseImpl : public Base
	{
	public:
		typedef IBatchCompletionState Declaration;

		IBatchCompletionStateBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->getSize = &Name::cloopgetSizeDispatcher;
					this->getState = &Name::cloopgetStateDispatcher;
					this->findError = &Name::cloopfindErrorDispatcher;
					this->getStatus = &Name::cloopgetStatusDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopgetSizeDispatcher(IBatchCompletionState* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getSize(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static int CLOOP_CARG cloopgetStateDispatcher(IBatchCompletionState* self, IStatus* status, unsigned pos) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getState(&status2, pos);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static unsigned CLOOP_CARG cloopfindErrorDispatcher(IBatchCompletionState* self, IStatus* status, unsigned pos) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::findError(&status2, pos);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopgetStatusDispatcher(IBatchCompletionState* self, IStatus* status, IStatus* to, unsigned pos) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getStatus(&status2, to, pos);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IBatchCompletionState> > > > >
	class IBatchCompletionStateImpl : public IBatchCompletionStateBaseImpl<Name, StatusType, Base>
	{
	protected:
		IBatchCompletionStateImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IBatchCompletionStateImpl()
		{
		}

		virtual unsigned getSize(StatusType* status) = 0;
		virtual int getState(StatusType* status, unsigned pos) = 0;
		virtual unsigned findError(StatusType* status, unsigned pos) = 0;
		virtual void getStatus(StatusType* status, IStatus* to, unsigned pos) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IReplicatorBaseImpl : public Base
	{
	public:
		typedef IReplicator Declaration;

		IReplicatorBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->process = &Name::cloopprocessDispatcher;
					this->deprecatedClose = &Name::cloopdeprecatedCloseDispatcher;
					this->close = &Name::cloopcloseDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopprocessDispatcher(IReplicator* self, IStatus* status, unsigned length, const unsigned char* data) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::process(&status2, length, data);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedCloseDispatcher(IReplicator* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedClose(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcloseDispatcher(IReplicator* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::close(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IReplicator> > > > >
	class IReplicatorImpl : public IReplicatorBaseImpl<Name, StatusType, Base>
	{
	protected:
		IReplicatorImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IReplicatorImpl()
		{
		}

		virtual void process(StatusType* status, unsigned length, const unsigned char* data) = 0;
		virtual void deprecatedClose(StatusType* status) = 0;
		virtual void close(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IRequestBaseImpl : public Base
	{
	public:
		typedef IRequest Declaration;

		IRequestBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->receive = &Name::cloopreceiveDispatcher;
					this->send = &Name::cloopsendDispatcher;
					this->getInfo = &Name::cloopgetInfoDispatcher;
					this->start = &Name::cloopstartDispatcher;
					this->startAndSend = &Name::cloopstartAndSendDispatcher;
					this->unwind = &Name::cloopunwindDispatcher;
					this->deprecatedFree = &Name::cloopdeprecatedFreeDispatcher;
					this->free = &Name::cloopfreeDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopreceiveDispatcher(IRequest* self, IStatus* status, int level, unsigned msgType, unsigned length, void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::receive(&status2, level, msgType, length, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsendDispatcher(IRequest* self, IStatus* status, int level, unsigned msgType, unsigned length, const void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::send(&status2, level, msgType, length, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopgetInfoDispatcher(IRequest* self, IStatus* status, int level, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getInfo(&status2, level, itemsLength, items, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopstartDispatcher(IRequest* self, IStatus* status, ITransaction* tra, int level) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::start(&status2, tra, level);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopstartAndSendDispatcher(IRequest* self, IStatus* status, ITransaction* tra, int level, unsigned msgType, unsigned length, const void* message) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::startAndSend(&status2, tra, level, msgType, length, message);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopunwindDispatcher(IRequest* self, IStatus* status, int level) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::unwind(&status2, level);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedFreeDispatcher(IRequest* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedFree(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopfreeDispatcher(IRequest* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::free(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IRequest> > > > >
	class IRequestImpl : public IRequestBaseImpl<Name, StatusType, Base>
	{
	protected:
		IRequestImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IRequestImpl()
		{
		}

		virtual void receive(StatusType* status, int level, unsigned msgType, unsigned length, void* message) = 0;
		virtual void send(StatusType* status, int level, unsigned msgType, unsigned length, const void* message) = 0;
		virtual void getInfo(StatusType* status, int level, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) = 0;
		virtual void start(StatusType* status, ITransaction* tra, int level) = 0;
		virtual void startAndSend(StatusType* status, ITransaction* tra, int level, unsigned msgType, unsigned length, const void* message) = 0;
		virtual void unwind(StatusType* status, int level) = 0;
		virtual void deprecatedFree(StatusType* status) = 0;
		virtual void free(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IEventsBaseImpl : public Base
	{
	public:
		typedef IEvents Declaration;

		IEventsBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->deprecatedCancel = &Name::cloopdeprecatedCancelDispatcher;
					this->cancel = &Name::cloopcancelDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopdeprecatedCancelDispatcher(IEvents* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedCancel(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcancelDispatcher(IEvents* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::cancel(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IEvents> > > > >
	class IEventsImpl : public IEventsBaseImpl<Name, StatusType, Base>
	{
	protected:
		IEventsImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IEventsImpl()
		{
		}

		virtual void deprecatedCancel(StatusType* status) = 0;
		virtual void cancel(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IAttachmentBaseImpl : public Base
	{
	public:
		typedef IAttachment Declaration;

		IAttachmentBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getInfo = &Name::cloopgetInfoDispatcher;
					this->startTransaction = &Name::cloopstartTransactionDispatcher;
					this->reconnectTransaction = &Name::cloopreconnectTransactionDispatcher;
					this->compileRequest = &Name::cloopcompileRequestDispatcher;
					this->transactRequest = &Name::clooptransactRequestDispatcher;
					this->createBlob = &Name::cloopcreateBlobDispatcher;
					this->openBlob = &Name::cloopopenBlobDispatcher;
					this->getSlice = &Name::cloopgetSliceDispatcher;
					this->putSlice = &Name::cloopputSliceDispatcher;
					this->executeDyn = &Name::cloopexecuteDynDispatcher;
					this->prepare = &Name::cloopprepareDispatcher;
					this->execute = &Name::cloopexecuteDispatcher;
					this->openCursor = &Name::cloopopenCursorDispatcher;
					this->queEvents = &Name::cloopqueEventsDispatcher;
					this->cancelOperation = &Name::cloopcancelOperationDispatcher;
					this->ping = &Name::clooppingDispatcher;
					this->deprecatedDetach = &Name::cloopdeprecatedDetachDispatcher;
					this->deprecatedDropDatabase = &Name::cloopdeprecatedDropDatabaseDispatcher;
					this->getIdleTimeout = &Name::cloopgetIdleTimeoutDispatcher;
					this->setIdleTimeout = &Name::cloopsetIdleTimeoutDispatcher;
					this->getStatementTimeout = &Name::cloopgetStatementTimeoutDispatcher;
					this->setStatementTimeout = &Name::cloopsetStatementTimeoutDispatcher;
					this->createBatch = &Name::cloopcreateBatchDispatcher;
					this->createReplicator = &Name::cloopcreateReplicatorDispatcher;
					this->detach = &Name::cloopdetachDispatcher;
					this->dropDatabase = &Name::cloopdropDatabaseDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopgetInfoDispatcher(IAttachment* self, IStatus* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getInfo(&status2, itemsLength, items, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static ITransaction* CLOOP_CARG cloopstartTransactionDispatcher(IAttachment* self, IStatus* status, unsigned tpbLength, const unsigned char* tpb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::startTransaction(&status2, tpbLength, tpb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static ITransaction* CLOOP_CARG cloopreconnectTransactionDispatcher(IAttachment* self, IStatus* status, unsigned length, const unsigned char* id) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::reconnectTransaction(&status2, length, id);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static IRequest* CLOOP_CARG cloopcompileRequestDispatcher(IAttachment* self, IStatus* status, unsigned blrLength, const unsigned char* blr) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::compileRequest(&status2, blrLength, blr);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IRequest*>(0);
			}
		}

		static void CLOOP_CARG clooptransactRequestDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned blrLength, const unsigned char* blr, unsigned inMsgLength, const unsigned char* inMsg, unsigned outMsgLength, unsigned char* outMsg) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::transactRequest(&status2, transaction, blrLength, blr, inMsgLength, inMsg, outMsgLength, outMsg);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IBlob* CLOOP_CARG cloopcreateBlobDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::createBlob(&status2, transaction, id, bpbLength, bpb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IBlob*>(0);
			}
		}

		static IBlob* CLOOP_CARG cloopopenBlobDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::openBlob(&status2, transaction, id, bpbLength, bpb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IBlob*>(0);
			}
		}

		static int CLOOP_CARG cloopgetSliceDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getSlice(&status2, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopputSliceDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::putSlice(&status2, transaction, id, sdlLength, sdl, paramLength, param, sliceLength, slice);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopexecuteDynDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned length, const unsigned char* dyn) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::executeDyn(&status2, transaction, length, dyn);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IStatement* CLOOP_CARG cloopprepareDispatcher(IAttachment* self, IStatus* status, ITransaction* tra, unsigned stmtLength, const char* sqlStmt, unsigned dialect, unsigned flags) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::prepare(&status2, tra, stmtLength, sqlStmt, dialect, flags);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IStatement*>(0);
			}
		}

		static ITransaction* CLOOP_CARG cloopexecuteDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, void* outBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::execute(&status2, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, outBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static IResultSet* CLOOP_CARG cloopopenCursorDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, const char* cursorName, unsigned cursorFlags) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::openCursor(&status2, transaction, stmtLength, sqlStmt, dialect, inMetadata, inBuffer, outMetadata, cursorName, cursorFlags);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IResultSet*>(0);
			}
		}

		static IEvents* CLOOP_CARG cloopqueEventsDispatcher(IAttachment* self, IStatus* status, IEventCallback* callback, unsigned length, const unsigned char* events) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::queEvents(&status2, callback, length, events);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IEvents*>(0);
			}
		}

		static void CLOOP_CARG cloopcancelOperationDispatcher(IAttachment* self, IStatus* status, int option) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::cancelOperation(&status2, option);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooppingDispatcher(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::ping(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedDetachDispatcher(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedDetach(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeprecatedDropDatabaseDispatcher(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedDropDatabase(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static unsigned CLOOP_CARG cloopgetIdleTimeoutDispatcher(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getIdleTimeout(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopsetIdleTimeoutDispatcher(IAttachment* self, IStatus* status, unsigned timeOut) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setIdleTimeout(&status2, timeOut);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static unsigned CLOOP_CARG cloopgetStatementTimeoutDispatcher(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getStatementTimeout(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopsetStatementTimeoutDispatcher(IAttachment* self, IStatus* status, unsigned timeOut) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setStatementTimeout(&status2, timeOut);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IBatch* CLOOP_CARG cloopcreateBatchDispatcher(IAttachment* self, IStatus* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::createBatch(&status2, transaction, stmtLength, sqlStmt, dialect, inMetadata, parLength, par);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IBatch*>(0);
			}
		}

		static IReplicator* CLOOP_CARG cloopcreateReplicatorDispatcher(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::createReplicator(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IReplicator*>(0);
			}
		}

		static void CLOOP_CARG cloopdetachDispatcher(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::detach(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdropDatabaseDispatcher(IAttachment* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::dropDatabase(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IAttachment> > > > >
	class IAttachmentImpl : public IAttachmentBaseImpl<Name, StatusType, Base>
	{
	protected:
		IAttachmentImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IAttachmentImpl()
		{
		}

		virtual void getInfo(StatusType* status, unsigned itemsLength, const unsigned char* items, unsigned bufferLength, unsigned char* buffer) = 0;
		virtual ITransaction* startTransaction(StatusType* status, unsigned tpbLength, const unsigned char* tpb) = 0;
		virtual ITransaction* reconnectTransaction(StatusType* status, unsigned length, const unsigned char* id) = 0;
		virtual IRequest* compileRequest(StatusType* status, unsigned blrLength, const unsigned char* blr) = 0;
		virtual void transactRequest(StatusType* status, ITransaction* transaction, unsigned blrLength, const unsigned char* blr, unsigned inMsgLength, const unsigned char* inMsg, unsigned outMsgLength, unsigned char* outMsg) = 0;
		virtual IBlob* createBlob(StatusType* status, ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb) = 0;
		virtual IBlob* openBlob(StatusType* status, ITransaction* transaction, ISC_QUAD* id, unsigned bpbLength, const unsigned char* bpb) = 0;
		virtual int getSlice(StatusType* status, ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice) = 0;
		virtual void putSlice(StatusType* status, ITransaction* transaction, ISC_QUAD* id, unsigned sdlLength, const unsigned char* sdl, unsigned paramLength, const unsigned char* param, int sliceLength, unsigned char* slice) = 0;
		virtual void executeDyn(StatusType* status, ITransaction* transaction, unsigned length, const unsigned char* dyn) = 0;
		virtual IStatement* prepare(StatusType* status, ITransaction* tra, unsigned stmtLength, const char* sqlStmt, unsigned dialect, unsigned flags) = 0;
		virtual ITransaction* execute(StatusType* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, void* outBuffer) = 0;
		virtual IResultSet* openCursor(StatusType* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, void* inBuffer, IMessageMetadata* outMetadata, const char* cursorName, unsigned cursorFlags) = 0;
		virtual IEvents* queEvents(StatusType* status, IEventCallback* callback, unsigned length, const unsigned char* events) = 0;
		virtual void cancelOperation(StatusType* status, int option) = 0;
		virtual void ping(StatusType* status) = 0;
		virtual void deprecatedDetach(StatusType* status) = 0;
		virtual void deprecatedDropDatabase(StatusType* status) = 0;
		virtual unsigned getIdleTimeout(StatusType* status) = 0;
		virtual void setIdleTimeout(StatusType* status, unsigned timeOut) = 0;
		virtual unsigned getStatementTimeout(StatusType* status) = 0;
		virtual void setStatementTimeout(StatusType* status, unsigned timeOut) = 0;
		virtual IBatch* createBatch(StatusType* status, ITransaction* transaction, unsigned stmtLength, const char* sqlStmt, unsigned dialect, IMessageMetadata* inMetadata, unsigned parLength, const unsigned char* par) = 0;
		virtual IReplicator* createReplicator(StatusType* status) = 0;
		virtual void detach(StatusType* status) = 0;
		virtual void dropDatabase(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IServiceBaseImpl : public Base
	{
	public:
		typedef IService Declaration;

		IServiceBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->deprecatedDetach = &Name::cloopdeprecatedDetachDispatcher;
					this->query = &Name::cloopqueryDispatcher;
					this->start = &Name::cloopstartDispatcher;
					this->detach = &Name::cloopdetachDispatcher;
					this->cancel = &Name::cloopcancelDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopdeprecatedDetachDispatcher(IService* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deprecatedDetach(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopqueryDispatcher(IService* self, IStatus* status, unsigned sendLength, const unsigned char* sendItems, unsigned receiveLength, const unsigned char* receiveItems, unsigned bufferLength, unsigned char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::query(&status2, sendLength, sendItems, receiveLength, receiveItems, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopstartDispatcher(IService* self, IStatus* status, unsigned spbLength, const unsigned char* spb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::start(&status2, spbLength, spb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdetachDispatcher(IService* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::detach(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcancelDispatcher(IService* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::cancel(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IService> > > > >
	class IServiceImpl : public IServiceBaseImpl<Name, StatusType, Base>
	{
	protected:
		IServiceImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IServiceImpl()
		{
		}

		virtual void deprecatedDetach(StatusType* status) = 0;
		virtual void query(StatusType* status, unsigned sendLength, const unsigned char* sendItems, unsigned receiveLength, const unsigned char* receiveItems, unsigned bufferLength, unsigned char* buffer) = 0;
		virtual void start(StatusType* status, unsigned spbLength, const unsigned char* spb) = 0;
		virtual void detach(StatusType* status) = 0;
		virtual void cancel(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IProviderBaseImpl : public Base
	{
	public:
		typedef IProvider Declaration;

		IProviderBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->attachDatabase = &Name::cloopattachDatabaseDispatcher;
					this->createDatabase = &Name::cloopcreateDatabaseDispatcher;
					this->attachServiceManager = &Name::cloopattachServiceManagerDispatcher;
					this->shutdown = &Name::cloopshutdownDispatcher;
					this->setDbCryptCallback = &Name::cloopsetDbCryptCallbackDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static IAttachment* CLOOP_CARG cloopattachDatabaseDispatcher(IProvider* self, IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::attachDatabase(&status2, fileName, dpbLength, dpb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IAttachment*>(0);
			}
		}

		static IAttachment* CLOOP_CARG cloopcreateDatabaseDispatcher(IProvider* self, IStatus* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::createDatabase(&status2, fileName, dpbLength, dpb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IAttachment*>(0);
			}
		}

		static IService* CLOOP_CARG cloopattachServiceManagerDispatcher(IProvider* self, IStatus* status, const char* service, unsigned spbLength, const unsigned char* spb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::attachServiceManager(&status2, service, spbLength, spb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IService*>(0);
			}
		}

		static void CLOOP_CARG cloopshutdownDispatcher(IProvider* self, IStatus* status, unsigned timeout, const int reason) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::shutdown(&status2, timeout, reason);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetDbCryptCallbackDispatcher(IProvider* self, IStatus* status, ICryptKeyCallback* cryptCallback) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setDbCryptCallback(&status2, cryptCallback);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IProvider> > > > > > >
	class IProviderImpl : public IProviderBaseImpl<Name, StatusType, Base>
	{
	protected:
		IProviderImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IProviderImpl()
		{
		}

		virtual IAttachment* attachDatabase(StatusType* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb) = 0;
		virtual IAttachment* createDatabase(StatusType* status, const char* fileName, unsigned dpbLength, const unsigned char* dpb) = 0;
		virtual IService* attachServiceManager(StatusType* status, const char* service, unsigned spbLength, const unsigned char* spb) = 0;
		virtual void shutdown(StatusType* status, unsigned timeout, const int reason) = 0;
		virtual void setDbCryptCallback(StatusType* status, ICryptKeyCallback* cryptCallback) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IDtcStartBaseImpl : public Base
	{
	public:
		typedef IDtcStart Declaration;

		IDtcStartBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->addAttachment = &Name::cloopaddAttachmentDispatcher;
					this->addWithTpb = &Name::cloopaddWithTpbDispatcher;
					this->start = &Name::cloopstartDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopaddAttachmentDispatcher(IDtcStart* self, IStatus* status, IAttachment* att) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::addAttachment(&status2, att);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopaddWithTpbDispatcher(IDtcStart* self, IStatus* status, IAttachment* att, unsigned length, const unsigned char* tpb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::addWithTpb(&status2, att, length, tpb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static ITransaction* CLOOP_CARG cloopstartDispatcher(IDtcStart* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::start(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IDtcStart> > > > >
	class IDtcStartImpl : public IDtcStartBaseImpl<Name, StatusType, Base>
	{
	protected:
		IDtcStartImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IDtcStartImpl()
		{
		}

		virtual void addAttachment(StatusType* status, IAttachment* att) = 0;
		virtual void addWithTpb(StatusType* status, IAttachment* att, unsigned length, const unsigned char* tpb) = 0;
		virtual ITransaction* start(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IDtcBaseImpl : public Base
	{
	public:
		typedef IDtc Declaration;

		IDtcBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->join = &Name::cloopjoinDispatcher;
					this->startBuilder = &Name::cloopstartBuilderDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static ITransaction* CLOOP_CARG cloopjoinDispatcher(IDtc* self, IStatus* status, ITransaction* one, ITransaction* two) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::join(&status2, one, two);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static IDtcStart* CLOOP_CARG cloopstartBuilderDispatcher(IDtc* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::startBuilder(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IDtcStart*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IDtc> > >
	class IDtcImpl : public IDtcBaseImpl<Name, StatusType, Base>
	{
	protected:
		IDtcImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IDtcImpl()
		{
		}

		virtual ITransaction* join(StatusType* status, ITransaction* one, ITransaction* two) = 0;
		virtual IDtcStart* startBuilder(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IAuthBaseImpl : public Base
	{
	public:
		typedef IAuth Declaration;

		IAuthBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IAuth> > > > > > >
	class IAuthImpl : public IAuthBaseImpl<Name, StatusType, Base>
	{
	protected:
		IAuthImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IAuthImpl()
		{
		}

	};

	template <typename Name, typename StatusType, typename Base>
	class IWriterBaseImpl : public Base
	{
	public:
		typedef IWriter Declaration;

		IWriterBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->reset = &Name::cloopresetDispatcher;
					this->add = &Name::cloopaddDispatcher;
					this->setType = &Name::cloopsetTypeDispatcher;
					this->setDb = &Name::cloopsetDbDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopresetDispatcher(IWriter* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::reset();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopaddDispatcher(IWriter* self, IStatus* status, const char* name) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::add(&status2, name);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetTypeDispatcher(IWriter* self, IStatus* status, const char* value) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setType(&status2, value);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetDbDispatcher(IWriter* self, IStatus* status, const char* value) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setDb(&status2, value);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IWriter> > >
	class IWriterImpl : public IWriterBaseImpl<Name, StatusType, Base>
	{
	protected:
		IWriterImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IWriterImpl()
		{
		}

		virtual void reset() = 0;
		virtual void add(StatusType* status, const char* name) = 0;
		virtual void setType(StatusType* status, const char* value) = 0;
		virtual void setDb(StatusType* status, const char* value) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IServerBlockBaseImpl : public Base
	{
	public:
		typedef IServerBlock Declaration;

		IServerBlockBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getLogin = &Name::cloopgetLoginDispatcher;
					this->getData = &Name::cloopgetDataDispatcher;
					this->putData = &Name::cloopputDataDispatcher;
					this->newKey = &Name::cloopnewKeyDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetLoginDispatcher(IServerBlock* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getLogin();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const unsigned char* CLOOP_CARG cloopgetDataDispatcher(IServerBlock* self, unsigned* length) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getData(length);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const unsigned char*>(0);
			}
		}

		static void CLOOP_CARG cloopputDataDispatcher(IServerBlock* self, IStatus* status, unsigned length, const void* data) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::putData(&status2, length, data);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static ICryptKey* CLOOP_CARG cloopnewKeyDispatcher(IServerBlock* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::newKey(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ICryptKey*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IServerBlock> > >
	class IServerBlockImpl : public IServerBlockBaseImpl<Name, StatusType, Base>
	{
	protected:
		IServerBlockImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IServerBlockImpl()
		{
		}

		virtual const char* getLogin() = 0;
		virtual const unsigned char* getData(unsigned* length) = 0;
		virtual void putData(StatusType* status, unsigned length, const void* data) = 0;
		virtual ICryptKey* newKey(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IClientBlockBaseImpl : public Base
	{
	public:
		typedef IClientBlock Declaration;

		IClientBlockBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getLogin = &Name::cloopgetLoginDispatcher;
					this->getPassword = &Name::cloopgetPasswordDispatcher;
					this->getData = &Name::cloopgetDataDispatcher;
					this->putData = &Name::cloopputDataDispatcher;
					this->newKey = &Name::cloopnewKeyDispatcher;
					this->getAuthBlock = &Name::cloopgetAuthBlockDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetLoginDispatcher(IClientBlock* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getLogin();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetPasswordDispatcher(IClientBlock* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPassword();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const unsigned char* CLOOP_CARG cloopgetDataDispatcher(IClientBlock* self, unsigned* length) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getData(length);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const unsigned char*>(0);
			}
		}

		static void CLOOP_CARG cloopputDataDispatcher(IClientBlock* self, IStatus* status, unsigned length, const void* data) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::putData(&status2, length, data);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static ICryptKey* CLOOP_CARG cloopnewKeyDispatcher(IClientBlock* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::newKey(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ICryptKey*>(0);
			}
		}

		static IAuthBlock* CLOOP_CARG cloopgetAuthBlockDispatcher(IClientBlock* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getAuthBlock(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IAuthBlock*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IClientBlock> > > > >
	class IClientBlockImpl : public IClientBlockBaseImpl<Name, StatusType, Base>
	{
	protected:
		IClientBlockImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IClientBlockImpl()
		{
		}

		virtual const char* getLogin() = 0;
		virtual const char* getPassword() = 0;
		virtual const unsigned char* getData(unsigned* length) = 0;
		virtual void putData(StatusType* status, unsigned length, const void* data) = 0;
		virtual ICryptKey* newKey(StatusType* status) = 0;
		virtual IAuthBlock* getAuthBlock(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IServerBaseImpl : public Base
	{
	public:
		typedef IServer Declaration;

		IServerBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->authenticate = &Name::cloopauthenticateDispatcher;
					this->setDbCryptCallback = &Name::cloopsetDbCryptCallbackDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static int CLOOP_CARG cloopauthenticateDispatcher(IServer* self, IStatus* status, IServerBlock* sBlock, IWriter* writerInterface) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::authenticate(&status2, sBlock, writerInterface);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopsetDbCryptCallbackDispatcher(IServer* self, IStatus* status, ICryptKeyCallback* cryptCallback) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setDbCryptCallback(&status2, cryptCallback);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IAuthImpl<Name, StatusType, Inherit<IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IServer> > > > > > > > >
	class IServerImpl : public IServerBaseImpl<Name, StatusType, Base>
	{
	protected:
		IServerImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IServerImpl()
		{
		}

		virtual int authenticate(StatusType* status, IServerBlock* sBlock, IWriter* writerInterface) = 0;
		virtual void setDbCryptCallback(StatusType* status, ICryptKeyCallback* cryptCallback) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IClientBaseImpl : public Base
	{
	public:
		typedef IClient Declaration;

		IClientBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->authenticate = &Name::cloopauthenticateDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static int CLOOP_CARG cloopauthenticateDispatcher(IClient* self, IStatus* status, IClientBlock* cBlock) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::authenticate(&status2, cBlock);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IAuthImpl<Name, StatusType, Inherit<IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IClient> > > > > > > > >
	class IClientImpl : public IClientBaseImpl<Name, StatusType, Base>
	{
	protected:
		IClientImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IClientImpl()
		{
		}

		virtual int authenticate(StatusType* status, IClientBlock* cBlock) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IUserFieldBaseImpl : public Base
	{
	public:
		typedef IUserField Declaration;

		IUserFieldBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->entered = &Name::cloopenteredDispatcher;
					this->specified = &Name::cloopspecifiedDispatcher;
					this->setEntered = &Name::cloopsetEnteredDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static int CLOOP_CARG cloopenteredDispatcher(IUserField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::entered();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopspecifiedDispatcher(IUserField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::specified();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopsetEnteredDispatcher(IUserField* self, IStatus* status, int newValue) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setEntered(&status2, newValue);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IUserField> > >
	class IUserFieldImpl : public IUserFieldBaseImpl<Name, StatusType, Base>
	{
	protected:
		IUserFieldImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IUserFieldImpl()
		{
		}

		virtual int entered() = 0;
		virtual int specified() = 0;
		virtual void setEntered(StatusType* status, int newValue) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ICharUserFieldBaseImpl : public Base
	{
	public:
		typedef ICharUserField Declaration;

		ICharUserFieldBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->entered = &Name::cloopenteredDispatcher;
					this->specified = &Name::cloopspecifiedDispatcher;
					this->setEntered = &Name::cloopsetEnteredDispatcher;
					this->get = &Name::cloopgetDispatcher;
					this->set = &Name::cloopsetDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetDispatcher(ICharUserField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::get();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static void CLOOP_CARG cloopsetDispatcher(ICharUserField* self, IStatus* status, const char* newValue) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::set(&status2, newValue);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static int CLOOP_CARG cloopenteredDispatcher(IUserField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::entered();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopspecifiedDispatcher(IUserField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::specified();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopsetEnteredDispatcher(IUserField* self, IStatus* status, int newValue) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setEntered(&status2, newValue);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IUserFieldImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ICharUserField> > > > >
	class ICharUserFieldImpl : public ICharUserFieldBaseImpl<Name, StatusType, Base>
	{
	protected:
		ICharUserFieldImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ICharUserFieldImpl()
		{
		}

		virtual const char* get() = 0;
		virtual void set(StatusType* status, const char* newValue) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IIntUserFieldBaseImpl : public Base
	{
	public:
		typedef IIntUserField Declaration;

		IIntUserFieldBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->entered = &Name::cloopenteredDispatcher;
					this->specified = &Name::cloopspecifiedDispatcher;
					this->setEntered = &Name::cloopsetEnteredDispatcher;
					this->get = &Name::cloopgetDispatcher;
					this->set = &Name::cloopsetDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static int CLOOP_CARG cloopgetDispatcher(IIntUserField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::get();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopsetDispatcher(IIntUserField* self, IStatus* status, int newValue) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::set(&status2, newValue);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static int CLOOP_CARG cloopenteredDispatcher(IUserField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::entered();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopspecifiedDispatcher(IUserField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::specified();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopsetEnteredDispatcher(IUserField* self, IStatus* status, int newValue) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setEntered(&status2, newValue);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IUserFieldImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IIntUserField> > > > >
	class IIntUserFieldImpl : public IIntUserFieldBaseImpl<Name, StatusType, Base>
	{
	protected:
		IIntUserFieldImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IIntUserFieldImpl()
		{
		}

		virtual int get() = 0;
		virtual void set(StatusType* status, int newValue) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IUserBaseImpl : public Base
	{
	public:
		typedef IUser Declaration;

		IUserBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->operation = &Name::cloopoperationDispatcher;
					this->userName = &Name::cloopuserNameDispatcher;
					this->password = &Name::clooppasswordDispatcher;
					this->firstName = &Name::cloopfirstNameDispatcher;
					this->lastName = &Name::clooplastNameDispatcher;
					this->middleName = &Name::cloopmiddleNameDispatcher;
					this->comment = &Name::cloopcommentDispatcher;
					this->attributes = &Name::cloopattributesDispatcher;
					this->active = &Name::cloopactiveDispatcher;
					this->admin = &Name::cloopadminDispatcher;
					this->clear = &Name::cloopclearDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopoperationDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::operation();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static ICharUserField* CLOOP_CARG cloopuserNameDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::userName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ICharUserField*>(0);
			}
		}

		static ICharUserField* CLOOP_CARG clooppasswordDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::password();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ICharUserField*>(0);
			}
		}

		static ICharUserField* CLOOP_CARG cloopfirstNameDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::firstName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ICharUserField*>(0);
			}
		}

		static ICharUserField* CLOOP_CARG clooplastNameDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::lastName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ICharUserField*>(0);
			}
		}

		static ICharUserField* CLOOP_CARG cloopmiddleNameDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::middleName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ICharUserField*>(0);
			}
		}

		static ICharUserField* CLOOP_CARG cloopcommentDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::comment();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ICharUserField*>(0);
			}
		}

		static ICharUserField* CLOOP_CARG cloopattributesDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::attributes();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ICharUserField*>(0);
			}
		}

		static IIntUserField* CLOOP_CARG cloopactiveDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::active();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IIntUserField*>(0);
			}
		}

		static IIntUserField* CLOOP_CARG cloopadminDispatcher(IUser* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::admin();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IIntUserField*>(0);
			}
		}

		static void CLOOP_CARG cloopclearDispatcher(IUser* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::clear(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IUser> > >
	class IUserImpl : public IUserBaseImpl<Name, StatusType, Base>
	{
	protected:
		IUserImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IUserImpl()
		{
		}

		virtual unsigned operation() = 0;
		virtual ICharUserField* userName() = 0;
		virtual ICharUserField* password() = 0;
		virtual ICharUserField* firstName() = 0;
		virtual ICharUserField* lastName() = 0;
		virtual ICharUserField* middleName() = 0;
		virtual ICharUserField* comment() = 0;
		virtual ICharUserField* attributes() = 0;
		virtual IIntUserField* active() = 0;
		virtual IIntUserField* admin() = 0;
		virtual void clear(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IListUsersBaseImpl : public Base
	{
	public:
		typedef IListUsers Declaration;

		IListUsersBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->list = &Name::clooplistDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG clooplistDispatcher(IListUsers* self, IStatus* status, IUser* user) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::list(&status2, user);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IListUsers> > >
	class IListUsersImpl : public IListUsersBaseImpl<Name, StatusType, Base>
	{
	protected:
		IListUsersImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IListUsersImpl()
		{
		}

		virtual void list(StatusType* status, IUser* user) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ILogonInfoBaseImpl : public Base
	{
	public:
		typedef ILogonInfo Declaration;

		ILogonInfoBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->name = &Name::cloopnameDispatcher;
					this->role = &Name::clooproleDispatcher;
					this->networkProtocol = &Name::cloopnetworkProtocolDispatcher;
					this->remoteAddress = &Name::cloopremoteAddressDispatcher;
					this->authBlock = &Name::cloopauthBlockDispatcher;
					this->attachment = &Name::cloopattachmentDispatcher;
					this->transaction = &Name::clooptransactionDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopnameDispatcher(ILogonInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::name();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG clooproleDispatcher(ILogonInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::role();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopnetworkProtocolDispatcher(ILogonInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::networkProtocol();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopremoteAddressDispatcher(ILogonInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::remoteAddress();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const unsigned char* CLOOP_CARG cloopauthBlockDispatcher(ILogonInfo* self, unsigned* length) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::authBlock(length);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const unsigned char*>(0);
			}
		}

		static IAttachment* CLOOP_CARG cloopattachmentDispatcher(ILogonInfo* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::attachment(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IAttachment*>(0);
			}
		}

		static ITransaction* CLOOP_CARG clooptransactionDispatcher(ILogonInfo* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::transaction(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ILogonInfo> > >
	class ILogonInfoImpl : public ILogonInfoBaseImpl<Name, StatusType, Base>
	{
	protected:
		ILogonInfoImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ILogonInfoImpl()
		{
		}

		virtual const char* name() = 0;
		virtual const char* role() = 0;
		virtual const char* networkProtocol() = 0;
		virtual const char* remoteAddress() = 0;
		virtual const unsigned char* authBlock(unsigned* length) = 0;
		virtual IAttachment* attachment(StatusType* status) = 0;
		virtual ITransaction* transaction(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IManagementBaseImpl : public Base
	{
	public:
		typedef IManagement Declaration;

		IManagementBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->start = &Name::cloopstartDispatcher;
					this->execute = &Name::cloopexecuteDispatcher;
					this->commit = &Name::cloopcommitDispatcher;
					this->rollback = &Name::clooprollbackDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopstartDispatcher(IManagement* self, IStatus* status, ILogonInfo* logonInfo) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::start(&status2, logonInfo);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static int CLOOP_CARG cloopexecuteDispatcher(IManagement* self, IStatus* status, IUser* user, IListUsers* callback) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::execute(&status2, user, callback);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static void CLOOP_CARG cloopcommitDispatcher(IManagement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::commit(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooprollbackDispatcher(IManagement* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::rollback(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IManagement> > > > > > >
	class IManagementImpl : public IManagementBaseImpl<Name, StatusType, Base>
	{
	protected:
		IManagementImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IManagementImpl()
		{
		}

		virtual void start(StatusType* status, ILogonInfo* logonInfo) = 0;
		virtual int execute(StatusType* status, IUser* user, IListUsers* callback) = 0;
		virtual void commit(StatusType* status) = 0;
		virtual void rollback(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IAuthBlockBaseImpl : public Base
	{
	public:
		typedef IAuthBlock Declaration;

		IAuthBlockBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getType = &Name::cloopgetTypeDispatcher;
					this->getName = &Name::cloopgetNameDispatcher;
					this->getPlugin = &Name::cloopgetPluginDispatcher;
					this->getSecurityDb = &Name::cloopgetSecurityDbDispatcher;
					this->getOriginalPlugin = &Name::cloopgetOriginalPluginDispatcher;
					this->next = &Name::cloopnextDispatcher;
					this->first = &Name::cloopfirstDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetTypeDispatcher(IAuthBlock* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getType();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetNameDispatcher(IAuthBlock* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetPluginDispatcher(IAuthBlock* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPlugin();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetSecurityDbDispatcher(IAuthBlock* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getSecurityDb();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetOriginalPluginDispatcher(IAuthBlock* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOriginalPlugin();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopnextDispatcher(IAuthBlock* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::next(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopfirstDispatcher(IAuthBlock* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::first(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IAuthBlock> > >
	class IAuthBlockImpl : public IAuthBlockBaseImpl<Name, StatusType, Base>
	{
	protected:
		IAuthBlockImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IAuthBlockImpl()
		{
		}

		virtual const char* getType() = 0;
		virtual const char* getName() = 0;
		virtual const char* getPlugin() = 0;
		virtual const char* getSecurityDb() = 0;
		virtual const char* getOriginalPlugin() = 0;
		virtual FB_BOOLEAN next(StatusType* status) = 0;
		virtual FB_BOOLEAN first(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IWireCryptPluginBaseImpl : public Base
	{
	public:
		typedef IWireCryptPlugin Declaration;

		IWireCryptPluginBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->getKnownTypes = &Name::cloopgetKnownTypesDispatcher;
					this->setKey = &Name::cloopsetKeyDispatcher;
					this->encrypt = &Name::cloopencryptDispatcher;
					this->decrypt = &Name::cloopdecryptDispatcher;
					this->getSpecificData = &Name::cloopgetSpecificDataDispatcher;
					this->setSpecificData = &Name::cloopsetSpecificDataDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetKnownTypesDispatcher(IWireCryptPlugin* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getKnownTypes(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static void CLOOP_CARG cloopsetKeyDispatcher(IWireCryptPlugin* self, IStatus* status, ICryptKey* key) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setKey(&status2, key);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopencryptDispatcher(IWireCryptPlugin* self, IStatus* status, unsigned length, const void* from, void* to) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::encrypt(&status2, length, from, to);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdecryptDispatcher(IWireCryptPlugin* self, IStatus* status, unsigned length, const void* from, void* to) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::decrypt(&status2, length, from, to);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static const unsigned char* CLOOP_CARG cloopgetSpecificDataDispatcher(IWireCryptPlugin* self, IStatus* status, const char* keyType, unsigned* length) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getSpecificData(&status2, keyType, length);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const unsigned char*>(0);
			}
		}

		static void CLOOP_CARG cloopsetSpecificDataDispatcher(IWireCryptPlugin* self, IStatus* status, const char* keyType, unsigned length, const unsigned char* data) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setSpecificData(&status2, keyType, length, data);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IWireCryptPlugin> > > > > > >
	class IWireCryptPluginImpl : public IWireCryptPluginBaseImpl<Name, StatusType, Base>
	{
	protected:
		IWireCryptPluginImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IWireCryptPluginImpl()
		{
		}

		virtual const char* getKnownTypes(StatusType* status) = 0;
		virtual void setKey(StatusType* status, ICryptKey* key) = 0;
		virtual void encrypt(StatusType* status, unsigned length, const void* from, void* to) = 0;
		virtual void decrypt(StatusType* status, unsigned length, const void* from, void* to) = 0;
		virtual const unsigned char* getSpecificData(StatusType* status, const char* keyType, unsigned* length) = 0;
		virtual void setSpecificData(StatusType* status, const char* keyType, unsigned length, const unsigned char* data) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ICryptKeyCallbackBaseImpl : public Base
	{
	public:
		typedef ICryptKeyCallback Declaration;

		ICryptKeyCallbackBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->callback = &Name::cloopcallbackDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopcallbackDispatcher(ICryptKeyCallback* self, unsigned dataLength, const void* data, unsigned bufferLength, void* buffer) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::callback(dataLength, data, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ICryptKeyCallback> > >
	class ICryptKeyCallbackImpl : public ICryptKeyCallbackBaseImpl<Name, StatusType, Base>
	{
	protected:
		ICryptKeyCallbackImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ICryptKeyCallbackImpl()
		{
		}

		virtual unsigned callback(unsigned dataLength, const void* data, unsigned bufferLength, void* buffer) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IKeyHolderPluginBaseImpl : public Base
	{
	public:
		typedef IKeyHolderPlugin Declaration;

		IKeyHolderPluginBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->keyCallback = &Name::cloopkeyCallbackDispatcher;
					this->keyHandle = &Name::cloopkeyHandleDispatcher;
					this->useOnlyOwnKeys = &Name::cloopuseOnlyOwnKeysDispatcher;
					this->chainHandle = &Name::cloopchainHandleDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static int CLOOP_CARG cloopkeyCallbackDispatcher(IKeyHolderPlugin* self, IStatus* status, ICryptKeyCallback* callback) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::keyCallback(&status2, callback);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static ICryptKeyCallback* CLOOP_CARG cloopkeyHandleDispatcher(IKeyHolderPlugin* self, IStatus* status, const char* keyName) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::keyHandle(&status2, keyName);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ICryptKeyCallback*>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopuseOnlyOwnKeysDispatcher(IKeyHolderPlugin* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::useOnlyOwnKeys(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static ICryptKeyCallback* CLOOP_CARG cloopchainHandleDispatcher(IKeyHolderPlugin* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::chainHandle(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ICryptKeyCallback*>(0);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IKeyHolderPlugin> > > > > > >
	class IKeyHolderPluginImpl : public IKeyHolderPluginBaseImpl<Name, StatusType, Base>
	{
	protected:
		IKeyHolderPluginImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IKeyHolderPluginImpl()
		{
		}

		virtual int keyCallback(StatusType* status, ICryptKeyCallback* callback) = 0;
		virtual ICryptKeyCallback* keyHandle(StatusType* status, const char* keyName) = 0;
		virtual FB_BOOLEAN useOnlyOwnKeys(StatusType* status) = 0;
		virtual ICryptKeyCallback* chainHandle(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IDbCryptInfoBaseImpl : public Base
	{
	public:
		typedef IDbCryptInfo Declaration;

		IDbCryptInfoBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->getDatabaseFullPath = &Name::cloopgetDatabaseFullPathDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetDatabaseFullPathDispatcher(IDbCryptInfo* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getDatabaseFullPath(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IDbCryptInfo> > > > >
	class IDbCryptInfoImpl : public IDbCryptInfoBaseImpl<Name, StatusType, Base>
	{
	protected:
		IDbCryptInfoImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IDbCryptInfoImpl()
		{
		}

		virtual const char* getDatabaseFullPath(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IDbCryptPluginBaseImpl : public Base
	{
	public:
		typedef IDbCryptPlugin Declaration;

		IDbCryptPluginBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->setKey = &Name::cloopsetKeyDispatcher;
					this->encrypt = &Name::cloopencryptDispatcher;
					this->decrypt = &Name::cloopdecryptDispatcher;
					this->setInfo = &Name::cloopsetInfoDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetKeyDispatcher(IDbCryptPlugin* self, IStatus* status, unsigned length, IKeyHolderPlugin** sources, const char* keyName) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setKey(&status2, length, sources, keyName);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopencryptDispatcher(IDbCryptPlugin* self, IStatus* status, unsigned length, const void* from, void* to) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::encrypt(&status2, length, from, to);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdecryptDispatcher(IDbCryptPlugin* self, IStatus* status, unsigned length, const void* from, void* to) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::decrypt(&status2, length, from, to);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetInfoDispatcher(IDbCryptPlugin* self, IStatus* status, IDbCryptInfo* info) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setInfo(&status2, info);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IDbCryptPlugin> > > > > > >
	class IDbCryptPluginImpl : public IDbCryptPluginBaseImpl<Name, StatusType, Base>
	{
	protected:
		IDbCryptPluginImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IDbCryptPluginImpl()
		{
		}

		virtual void setKey(StatusType* status, unsigned length, IKeyHolderPlugin** sources, const char* keyName) = 0;
		virtual void encrypt(StatusType* status, unsigned length, const void* from, void* to) = 0;
		virtual void decrypt(StatusType* status, unsigned length, const void* from, void* to) = 0;
		virtual void setInfo(StatusType* status, IDbCryptInfo* info) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IExternalContextBaseImpl : public Base
	{
	public:
		typedef IExternalContext Declaration;

		IExternalContextBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getMaster = &Name::cloopgetMasterDispatcher;
					this->getEngine = &Name::cloopgetEngineDispatcher;
					this->getAttachment = &Name::cloopgetAttachmentDispatcher;
					this->getTransaction = &Name::cloopgetTransactionDispatcher;
					this->getUserName = &Name::cloopgetUserNameDispatcher;
					this->getDatabaseName = &Name::cloopgetDatabaseNameDispatcher;
					this->getClientCharSet = &Name::cloopgetClientCharSetDispatcher;
					this->obtainInfoCode = &Name::cloopobtainInfoCodeDispatcher;
					this->getInfo = &Name::cloopgetInfoDispatcher;
					this->setInfo = &Name::cloopsetInfoDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static IMaster* CLOOP_CARG cloopgetMasterDispatcher(IExternalContext* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getMaster();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IMaster*>(0);
			}
		}

		static IExternalEngine* CLOOP_CARG cloopgetEngineDispatcher(IExternalContext* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getEngine(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IExternalEngine*>(0);
			}
		}

		static IAttachment* CLOOP_CARG cloopgetAttachmentDispatcher(IExternalContext* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getAttachment(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IAttachment*>(0);
			}
		}

		static ITransaction* CLOOP_CARG cloopgetTransactionDispatcher(IExternalContext* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getTransaction(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITransaction*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetUserNameDispatcher(IExternalContext* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getUserName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetDatabaseNameDispatcher(IExternalContext* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDatabaseName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetClientCharSetDispatcher(IExternalContext* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getClientCharSet();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static int CLOOP_CARG cloopobtainInfoCodeDispatcher(IExternalContext* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::obtainInfoCode();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static void* CLOOP_CARG cloopgetInfoDispatcher(IExternalContext* self, int code) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getInfo(code);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<void*>(0);
			}
		}

		static void* CLOOP_CARG cloopsetInfoDispatcher(IExternalContext* self, int code, void* value) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::setInfo(code, value);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<void*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IExternalContext> > >
	class IExternalContextImpl : public IExternalContextBaseImpl<Name, StatusType, Base>
	{
	protected:
		IExternalContextImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IExternalContextImpl()
		{
		}

		virtual IMaster* getMaster() = 0;
		virtual IExternalEngine* getEngine(StatusType* status) = 0;
		virtual IAttachment* getAttachment(StatusType* status) = 0;
		virtual ITransaction* getTransaction(StatusType* status) = 0;
		virtual const char* getUserName() = 0;
		virtual const char* getDatabaseName() = 0;
		virtual const char* getClientCharSet() = 0;
		virtual int obtainInfoCode() = 0;
		virtual void* getInfo(int code) = 0;
		virtual void* setInfo(int code, void* value) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IExternalResultSetBaseImpl : public Base
	{
	public:
		typedef IExternalResultSet Declaration;

		IExternalResultSetBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->fetch = &Name::cloopfetchDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static FB_BOOLEAN CLOOP_CARG cloopfetchDispatcher(IExternalResultSet* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::fetch(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IExternalResultSet> > > > >
	class IExternalResultSetImpl : public IExternalResultSetBaseImpl<Name, StatusType, Base>
	{
	protected:
		IExternalResultSetImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IExternalResultSetImpl()
		{
		}

		virtual FB_BOOLEAN fetch(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IExternalFunctionBaseImpl : public Base
	{
	public:
		typedef IExternalFunction Declaration;

		IExternalFunctionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->getCharSet = &Name::cloopgetCharSetDispatcher;
					this->execute = &Name::cloopexecuteDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopgetCharSetDispatcher(IExternalFunction* self, IStatus* status, IExternalContext* context, char* name, unsigned nameSize) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getCharSet(&status2, context, name, nameSize);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopexecuteDispatcher(IExternalFunction* self, IStatus* status, IExternalContext* context, void* inMsg, void* outMsg) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::execute(&status2, context, inMsg, outMsg);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IExternalFunction> > > > >
	class IExternalFunctionImpl : public IExternalFunctionBaseImpl<Name, StatusType, Base>
	{
	protected:
		IExternalFunctionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IExternalFunctionImpl()
		{
		}

		virtual void getCharSet(StatusType* status, IExternalContext* context, char* name, unsigned nameSize) = 0;
		virtual void execute(StatusType* status, IExternalContext* context, void* inMsg, void* outMsg) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IExternalProcedureBaseImpl : public Base
	{
	public:
		typedef IExternalProcedure Declaration;

		IExternalProcedureBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->getCharSet = &Name::cloopgetCharSetDispatcher;
					this->open = &Name::cloopopenDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopgetCharSetDispatcher(IExternalProcedure* self, IStatus* status, IExternalContext* context, char* name, unsigned nameSize) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getCharSet(&status2, context, name, nameSize);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IExternalResultSet* CLOOP_CARG cloopopenDispatcher(IExternalProcedure* self, IStatus* status, IExternalContext* context, void* inMsg, void* outMsg) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::open(&status2, context, inMsg, outMsg);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IExternalResultSet*>(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IExternalProcedure> > > > >
	class IExternalProcedureImpl : public IExternalProcedureBaseImpl<Name, StatusType, Base>
	{
	protected:
		IExternalProcedureImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IExternalProcedureImpl()
		{
		}

		virtual void getCharSet(StatusType* status, IExternalContext* context, char* name, unsigned nameSize) = 0;
		virtual IExternalResultSet* open(StatusType* status, IExternalContext* context, void* inMsg, void* outMsg) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IExternalTriggerBaseImpl : public Base
	{
	public:
		typedef IExternalTrigger Declaration;

		IExternalTriggerBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->getCharSet = &Name::cloopgetCharSetDispatcher;
					this->execute = &Name::cloopexecuteDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopgetCharSetDispatcher(IExternalTrigger* self, IStatus* status, IExternalContext* context, char* name, unsigned nameSize) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getCharSet(&status2, context, name, nameSize);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopexecuteDispatcher(IExternalTrigger* self, IStatus* status, IExternalContext* context, unsigned action, void* oldMsg, void* newMsg) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::execute(&status2, context, action, oldMsg, newMsg);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IExternalTrigger> > > > >
	class IExternalTriggerImpl : public IExternalTriggerBaseImpl<Name, StatusType, Base>
	{
	protected:
		IExternalTriggerImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IExternalTriggerImpl()
		{
		}

		virtual void getCharSet(StatusType* status, IExternalContext* context, char* name, unsigned nameSize) = 0;
		virtual void execute(StatusType* status, IExternalContext* context, unsigned action, void* oldMsg, void* newMsg) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IRoutineMetadataBaseImpl : public Base
	{
	public:
		typedef IRoutineMetadata Declaration;

		IRoutineMetadataBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getPackage = &Name::cloopgetPackageDispatcher;
					this->getName = &Name::cloopgetNameDispatcher;
					this->getEntryPoint = &Name::cloopgetEntryPointDispatcher;
					this->getBody = &Name::cloopgetBodyDispatcher;
					this->getInputMetadata = &Name::cloopgetInputMetadataDispatcher;
					this->getOutputMetadata = &Name::cloopgetOutputMetadataDispatcher;
					this->getTriggerMetadata = &Name::cloopgetTriggerMetadataDispatcher;
					this->getTriggerTable = &Name::cloopgetTriggerTableDispatcher;
					this->getTriggerType = &Name::cloopgetTriggerTypeDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetPackageDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getPackage(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetNameDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getName(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetEntryPointDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getEntryPoint(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetBodyDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getBody(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static IMessageMetadata* CLOOP_CARG cloopgetInputMetadataDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getInputMetadata(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMessageMetadata*>(0);
			}
		}

		static IMessageMetadata* CLOOP_CARG cloopgetOutputMetadataDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getOutputMetadata(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMessageMetadata*>(0);
			}
		}

		static IMessageMetadata* CLOOP_CARG cloopgetTriggerMetadataDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getTriggerMetadata(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IMessageMetadata*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetTriggerTableDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getTriggerTable(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetTriggerTypeDispatcher(const IRoutineMetadata* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<const Name*>(self)->Name::getTriggerType(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IRoutineMetadata> > >
	class IRoutineMetadataImpl : public IRoutineMetadataBaseImpl<Name, StatusType, Base>
	{
	protected:
		IRoutineMetadataImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IRoutineMetadataImpl()
		{
		}

		virtual const char* getPackage(StatusType* status) const = 0;
		virtual const char* getName(StatusType* status) const = 0;
		virtual const char* getEntryPoint(StatusType* status) const = 0;
		virtual const char* getBody(StatusType* status) const = 0;
		virtual IMessageMetadata* getInputMetadata(StatusType* status) const = 0;
		virtual IMessageMetadata* getOutputMetadata(StatusType* status) const = 0;
		virtual IMessageMetadata* getTriggerMetadata(StatusType* status) const = 0;
		virtual const char* getTriggerTable(StatusType* status) const = 0;
		virtual unsigned getTriggerType(StatusType* status) const = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IExternalEngineBaseImpl : public Base
	{
	public:
		typedef IExternalEngine Declaration;

		IExternalEngineBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->open = &Name::cloopopenDispatcher;
					this->openAttachment = &Name::cloopopenAttachmentDispatcher;
					this->closeAttachment = &Name::cloopcloseAttachmentDispatcher;
					this->makeFunction = &Name::cloopmakeFunctionDispatcher;
					this->makeProcedure = &Name::cloopmakeProcedureDispatcher;
					this->makeTrigger = &Name::cloopmakeTriggerDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopopenDispatcher(IExternalEngine* self, IStatus* status, IExternalContext* context, char* charSet, unsigned charSetSize) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::open(&status2, context, charSet, charSetSize);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopopenAttachmentDispatcher(IExternalEngine* self, IStatus* status, IExternalContext* context) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::openAttachment(&status2, context);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcloseAttachmentDispatcher(IExternalEngine* self, IStatus* status, IExternalContext* context) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::closeAttachment(&status2, context);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IExternalFunction* CLOOP_CARG cloopmakeFunctionDispatcher(IExternalEngine* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::makeFunction(&status2, context, metadata, inBuilder, outBuilder);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IExternalFunction*>(0);
			}
		}

		static IExternalProcedure* CLOOP_CARG cloopmakeProcedureDispatcher(IExternalEngine* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::makeProcedure(&status2, context, metadata, inBuilder, outBuilder);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IExternalProcedure*>(0);
			}
		}

		static IExternalTrigger* CLOOP_CARG cloopmakeTriggerDispatcher(IExternalEngine* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* fieldsBuilder) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::makeTrigger(&status2, context, metadata, fieldsBuilder);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IExternalTrigger*>(0);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IExternalEngine> > > > > > >
	class IExternalEngineImpl : public IExternalEngineBaseImpl<Name, StatusType, Base>
	{
	protected:
		IExternalEngineImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IExternalEngineImpl()
		{
		}

		virtual void open(StatusType* status, IExternalContext* context, char* charSet, unsigned charSetSize) = 0;
		virtual void openAttachment(StatusType* status, IExternalContext* context) = 0;
		virtual void closeAttachment(StatusType* status, IExternalContext* context) = 0;
		virtual IExternalFunction* makeFunction(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) = 0;
		virtual IExternalProcedure* makeProcedure(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) = 0;
		virtual IExternalTrigger* makeTrigger(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* fieldsBuilder) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITimerBaseImpl : public Base
	{
	public:
		typedef ITimer Declaration;

		ITimerBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->handler = &Name::cloophandlerDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloophandlerDispatcher(ITimer* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::handler();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITimer> > > > >
	class ITimerImpl : public ITimerBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITimerImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITimerImpl()
		{
		}

		virtual void handler() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITimerControlBaseImpl : public Base
	{
	public:
		typedef ITimerControl Declaration;

		ITimerControlBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->start = &Name::cloopstartDispatcher;
					this->stop = &Name::cloopstopDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopstartDispatcher(ITimerControl* self, IStatus* status, ITimer* timer, ISC_UINT64 microSeconds) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::start(&status2, timer, microSeconds);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopstopDispatcher(ITimerControl* self, IStatus* status, ITimer* timer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::stop(&status2, timer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITimerControl> > >
	class ITimerControlImpl : public ITimerControlBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITimerControlImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITimerControlImpl()
		{
		}

		virtual void start(StatusType* status, ITimer* timer, ISC_UINT64 microSeconds) = 0;
		virtual void stop(StatusType* status, ITimer* timer) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IVersionCallbackBaseImpl : public Base
	{
	public:
		typedef IVersionCallback Declaration;

		IVersionCallbackBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->callback = &Name::cloopcallbackDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopcallbackDispatcher(IVersionCallback* self, IStatus* status, const char* text) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::callback(&status2, text);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IVersionCallback> > >
	class IVersionCallbackImpl : public IVersionCallbackBaseImpl<Name, StatusType, Base>
	{
	protected:
		IVersionCallbackImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IVersionCallbackImpl()
		{
		}

		virtual void callback(StatusType* status, const char* text) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IUtilBaseImpl : public Base
	{
	public:
		typedef IUtil Declaration;

		IUtilBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getFbVersion = &Name::cloopgetFbVersionDispatcher;
					this->loadBlob = &Name::clooploadBlobDispatcher;
					this->dumpBlob = &Name::cloopdumpBlobDispatcher;
					this->getPerfCounters = &Name::cloopgetPerfCountersDispatcher;
					this->executeCreateDatabase = &Name::cloopexecuteCreateDatabaseDispatcher;
					this->decodeDate = &Name::cloopdecodeDateDispatcher;
					this->decodeTime = &Name::cloopdecodeTimeDispatcher;
					this->encodeDate = &Name::cloopencodeDateDispatcher;
					this->encodeTime = &Name::cloopencodeTimeDispatcher;
					this->formatStatus = &Name::cloopformatStatusDispatcher;
					this->getClientVersion = &Name::cloopgetClientVersionDispatcher;
					this->getXpbBuilder = &Name::cloopgetXpbBuilderDispatcher;
					this->setOffsets = &Name::cloopsetOffsetsDispatcher;
					this->getDecFloat16 = &Name::cloopgetDecFloat16Dispatcher;
					this->getDecFloat34 = &Name::cloopgetDecFloat34Dispatcher;
					this->decodeTimeTz = &Name::cloopdecodeTimeTzDispatcher;
					this->decodeTimeStampTz = &Name::cloopdecodeTimeStampTzDispatcher;
					this->encodeTimeTz = &Name::cloopencodeTimeTzDispatcher;
					this->encodeTimeStampTz = &Name::cloopencodeTimeStampTzDispatcher;
					this->getInt128 = &Name::cloopgetInt128Dispatcher;
					this->decodeTimeTzEx = &Name::cloopdecodeTimeTzExDispatcher;
					this->decodeTimeStampTzEx = &Name::cloopdecodeTimeStampTzExDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopgetFbVersionDispatcher(IUtil* self, IStatus* status, IAttachment* att, IVersionCallback* callback) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getFbVersion(&status2, att, callback);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooploadBlobDispatcher(IUtil* self, IStatus* status, ISC_QUAD* blobId, IAttachment* att, ITransaction* tra, const char* file, FB_BOOLEAN txt) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::loadBlob(&status2, blobId, att, tra, file, txt);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdumpBlobDispatcher(IUtil* self, IStatus* status, ISC_QUAD* blobId, IAttachment* att, ITransaction* tra, const char* file, FB_BOOLEAN txt) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::dumpBlob(&status2, blobId, att, tra, file, txt);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopgetPerfCountersDispatcher(IUtil* self, IStatus* status, IAttachment* att, const char* countersSet, ISC_INT64* counters) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::getPerfCounters(&status2, att, countersSet, counters);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IAttachment* CLOOP_CARG cloopexecuteCreateDatabaseDispatcher(IUtil* self, IStatus* status, unsigned stmtLength, const char* creatDBstatement, unsigned dialect, FB_BOOLEAN* stmtIsCreateDb) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::executeCreateDatabase(&status2, stmtLength, creatDBstatement, dialect, stmtIsCreateDb);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IAttachment*>(0);
			}
		}

		static void CLOOP_CARG cloopdecodeDateDispatcher(IUtil* self, ISC_DATE date, unsigned* year, unsigned* month, unsigned* day) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::decodeDate(date, year, month, day);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopdecodeTimeDispatcher(IUtil* self, ISC_TIME time, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::decodeTime(time, hours, minutes, seconds, fractions);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static ISC_DATE CLOOP_CARG cloopencodeDateDispatcher(IUtil* self, unsigned year, unsigned month, unsigned day) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::encodeDate(year, month, day);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_DATE>(0);
			}
		}

		static ISC_TIME CLOOP_CARG cloopencodeTimeDispatcher(IUtil* self, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::encodeTime(hours, minutes, seconds, fractions);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_TIME>(0);
			}
		}

		static unsigned CLOOP_CARG cloopformatStatusDispatcher(IUtil* self, char* buffer, unsigned bufferSize, IStatus* status) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::formatStatus(buffer, bufferSize, status);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetClientVersionDispatcher(IUtil* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getClientVersion();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static IXpbBuilder* CLOOP_CARG cloopgetXpbBuilderDispatcher(IUtil* self, IStatus* status, unsigned kind, const unsigned char* buf, unsigned len) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getXpbBuilder(&status2, kind, buf, len);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IXpbBuilder*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopsetOffsetsDispatcher(IUtil* self, IStatus* status, IMessageMetadata* metadata, IOffsetsCallback* callback) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::setOffsets(&status2, metadata, callback);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static IDecFloat16* CLOOP_CARG cloopgetDecFloat16Dispatcher(IUtil* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getDecFloat16(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IDecFloat16*>(0);
			}
		}

		static IDecFloat34* CLOOP_CARG cloopgetDecFloat34Dispatcher(IUtil* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getDecFloat34(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IDecFloat34*>(0);
			}
		}

		static void CLOOP_CARG cloopdecodeTimeTzDispatcher(IUtil* self, IStatus* status, const ISC_TIME_TZ* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::decodeTimeTz(&status2, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdecodeTimeStampTzDispatcher(IUtil* self, IStatus* status, const ISC_TIMESTAMP_TZ* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::decodeTimeStampTz(&status2, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopencodeTimeTzDispatcher(IUtil* self, IStatus* status, ISC_TIME_TZ* timeTz, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::encodeTimeTz(&status2, timeTz, hours, minutes, seconds, fractions, timeZone);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopencodeTimeStampTzDispatcher(IUtil* self, IStatus* status, ISC_TIMESTAMP_TZ* timeStampTz, unsigned year, unsigned month, unsigned day, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::encodeTimeStampTz(&status2, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZone);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IInt128* CLOOP_CARG cloopgetInt128Dispatcher(IUtil* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getInt128(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IInt128*>(0);
			}
		}

		static void CLOOP_CARG cloopdecodeTimeTzExDispatcher(IUtil* self, IStatus* status, const ISC_TIME_TZ_EX* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::decodeTimeTzEx(&status2, timeTz, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdecodeTimeStampTzExDispatcher(IUtil* self, IStatus* status, const ISC_TIMESTAMP_TZ_EX* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::decodeTimeStampTzEx(&status2, timeStampTz, year, month, day, hours, minutes, seconds, fractions, timeZoneBufferLength, timeZoneBuffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IUtil> > >
	class IUtilImpl : public IUtilBaseImpl<Name, StatusType, Base>
	{
	protected:
		IUtilImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IUtilImpl()
		{
		}

		virtual void getFbVersion(StatusType* status, IAttachment* att, IVersionCallback* callback) = 0;
		virtual void loadBlob(StatusType* status, ISC_QUAD* blobId, IAttachment* att, ITransaction* tra, const char* file, FB_BOOLEAN txt) = 0;
		virtual void dumpBlob(StatusType* status, ISC_QUAD* blobId, IAttachment* att, ITransaction* tra, const char* file, FB_BOOLEAN txt) = 0;
		virtual void getPerfCounters(StatusType* status, IAttachment* att, const char* countersSet, ISC_INT64* counters) = 0;
		virtual IAttachment* executeCreateDatabase(StatusType* status, unsigned stmtLength, const char* creatDBstatement, unsigned dialect, FB_BOOLEAN* stmtIsCreateDb) = 0;
		virtual void decodeDate(ISC_DATE date, unsigned* year, unsigned* month, unsigned* day) = 0;
		virtual void decodeTime(ISC_TIME time, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions) = 0;
		virtual ISC_DATE encodeDate(unsigned year, unsigned month, unsigned day) = 0;
		virtual ISC_TIME encodeTime(unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions) = 0;
		virtual unsigned formatStatus(char* buffer, unsigned bufferSize, IStatus* status) = 0;
		virtual unsigned getClientVersion() = 0;
		virtual IXpbBuilder* getXpbBuilder(StatusType* status, unsigned kind, const unsigned char* buf, unsigned len) = 0;
		virtual unsigned setOffsets(StatusType* status, IMessageMetadata* metadata, IOffsetsCallback* callback) = 0;
		virtual IDecFloat16* getDecFloat16(StatusType* status) = 0;
		virtual IDecFloat34* getDecFloat34(StatusType* status) = 0;
		virtual void decodeTimeTz(StatusType* status, const ISC_TIME_TZ* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) = 0;
		virtual void decodeTimeStampTz(StatusType* status, const ISC_TIMESTAMP_TZ* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) = 0;
		virtual void encodeTimeTz(StatusType* status, ISC_TIME_TZ* timeTz, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone) = 0;
		virtual void encodeTimeStampTz(StatusType* status, ISC_TIMESTAMP_TZ* timeStampTz, unsigned year, unsigned month, unsigned day, unsigned hours, unsigned minutes, unsigned seconds, unsigned fractions, const char* timeZone) = 0;
		virtual IInt128* getInt128(StatusType* status) = 0;
		virtual void decodeTimeTzEx(StatusType* status, const ISC_TIME_TZ_EX* timeTz, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) = 0;
		virtual void decodeTimeStampTzEx(StatusType* status, const ISC_TIMESTAMP_TZ_EX* timeStampTz, unsigned* year, unsigned* month, unsigned* day, unsigned* hours, unsigned* minutes, unsigned* seconds, unsigned* fractions, unsigned timeZoneBufferLength, char* timeZoneBuffer) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IOffsetsCallbackBaseImpl : public Base
	{
	public:
		typedef IOffsetsCallback Declaration;

		IOffsetsCallbackBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->setOffset = &Name::cloopsetOffsetDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetOffsetDispatcher(IOffsetsCallback* self, IStatus* status, unsigned index, unsigned offset, unsigned nullOffset) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setOffset(&status2, index, offset, nullOffset);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IOffsetsCallback> > >
	class IOffsetsCallbackImpl : public IOffsetsCallbackBaseImpl<Name, StatusType, Base>
	{
	protected:
		IOffsetsCallbackImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IOffsetsCallbackImpl()
		{
		}

		virtual void setOffset(StatusType* status, unsigned index, unsigned offset, unsigned nullOffset) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IXpbBuilderBaseImpl : public Base
	{
	public:
		typedef IXpbBuilder Declaration;

		IXpbBuilderBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->clear = &Name::cloopclearDispatcher;
					this->removeCurrent = &Name::cloopremoveCurrentDispatcher;
					this->insertInt = &Name::cloopinsertIntDispatcher;
					this->insertBigInt = &Name::cloopinsertBigIntDispatcher;
					this->insertBytes = &Name::cloopinsertBytesDispatcher;
					this->insertString = &Name::cloopinsertStringDispatcher;
					this->insertTag = &Name::cloopinsertTagDispatcher;
					this->isEof = &Name::cloopisEofDispatcher;
					this->moveNext = &Name::cloopmoveNextDispatcher;
					this->rewind = &Name::clooprewindDispatcher;
					this->findFirst = &Name::cloopfindFirstDispatcher;
					this->findNext = &Name::cloopfindNextDispatcher;
					this->getTag = &Name::cloopgetTagDispatcher;
					this->getLength = &Name::cloopgetLengthDispatcher;
					this->getInt = &Name::cloopgetIntDispatcher;
					this->getBigInt = &Name::cloopgetBigIntDispatcher;
					this->getString = &Name::cloopgetStringDispatcher;
					this->getBytes = &Name::cloopgetBytesDispatcher;
					this->getBufferLength = &Name::cloopgetBufferLengthDispatcher;
					this->getBuffer = &Name::cloopgetBufferDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopclearDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::clear(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopremoveCurrentDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::removeCurrent(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopinsertIntDispatcher(IXpbBuilder* self, IStatus* status, unsigned char tag, int value) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::insertInt(&status2, tag, value);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopinsertBigIntDispatcher(IXpbBuilder* self, IStatus* status, unsigned char tag, ISC_INT64 value) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::insertBigInt(&status2, tag, value);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopinsertBytesDispatcher(IXpbBuilder* self, IStatus* status, unsigned char tag, const void* bytes, unsigned length) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::insertBytes(&status2, tag, bytes, length);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopinsertStringDispatcher(IXpbBuilder* self, IStatus* status, unsigned char tag, const char* str) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::insertString(&status2, tag, str);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopinsertTagDispatcher(IXpbBuilder* self, IStatus* status, unsigned char tag) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::insertTag(&status2, tag);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopisEofDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::isEof(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static void CLOOP_CARG cloopmoveNextDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::moveNext(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooprewindDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::rewind(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopfindFirstDispatcher(IXpbBuilder* self, IStatus* status, unsigned char tag) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::findFirst(&status2, tag);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopfindNextDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::findNext(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static unsigned char CLOOP_CARG cloopgetTagDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getTag(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned char>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetLengthDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getLength(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static int CLOOP_CARG cloopgetIntDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getInt(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<int>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetBigIntDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getBigInt(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ISC_INT64>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetStringDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getString(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}

		static const unsigned char* CLOOP_CARG cloopgetBytesDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getBytes(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const unsigned char*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetBufferLengthDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getBufferLength(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static const unsigned char* CLOOP_CARG cloopgetBufferDispatcher(IXpbBuilder* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getBuffer(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const unsigned char*>(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IXpbBuilder> > > > >
	class IXpbBuilderImpl : public IXpbBuilderBaseImpl<Name, StatusType, Base>
	{
	protected:
		IXpbBuilderImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IXpbBuilderImpl()
		{
		}

		virtual void clear(StatusType* status) = 0;
		virtual void removeCurrent(StatusType* status) = 0;
		virtual void insertInt(StatusType* status, unsigned char tag, int value) = 0;
		virtual void insertBigInt(StatusType* status, unsigned char tag, ISC_INT64 value) = 0;
		virtual void insertBytes(StatusType* status, unsigned char tag, const void* bytes, unsigned length) = 0;
		virtual void insertString(StatusType* status, unsigned char tag, const char* str) = 0;
		virtual void insertTag(StatusType* status, unsigned char tag) = 0;
		virtual FB_BOOLEAN isEof(StatusType* status) = 0;
		virtual void moveNext(StatusType* status) = 0;
		virtual void rewind(StatusType* status) = 0;
		virtual FB_BOOLEAN findFirst(StatusType* status, unsigned char tag) = 0;
		virtual FB_BOOLEAN findNext(StatusType* status) = 0;
		virtual unsigned char getTag(StatusType* status) = 0;
		virtual unsigned getLength(StatusType* status) = 0;
		virtual int getInt(StatusType* status) = 0;
		virtual ISC_INT64 getBigInt(StatusType* status) = 0;
		virtual const char* getString(StatusType* status) = 0;
		virtual const unsigned char* getBytes(StatusType* status) = 0;
		virtual unsigned getBufferLength(StatusType* status) = 0;
		virtual const unsigned char* getBuffer(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceConnectionBaseImpl : public Base
	{
	public:
		typedef ITraceConnection Declaration;

		ITraceConnectionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getKind = &Name::cloopgetKindDispatcher;
					this->getProcessID = &Name::cloopgetProcessIDDispatcher;
					this->getUserName = &Name::cloopgetUserNameDispatcher;
					this->getRoleName = &Name::cloopgetRoleNameDispatcher;
					this->getCharSet = &Name::cloopgetCharSetDispatcher;
					this->getRemoteProtocol = &Name::cloopgetRemoteProtocolDispatcher;
					this->getRemoteAddress = &Name::cloopgetRemoteAddressDispatcher;
					this->getRemoteProcessID = &Name::cloopgetRemoteProcessIDDispatcher;
					this->getRemoteProcessName = &Name::cloopgetRemoteProcessNameDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopgetKindDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getKind();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static int CLOOP_CARG cloopgetProcessIDDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getProcessID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetUserNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getUserName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRoleNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRoleName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetCharSetDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getCharSet();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteProtocolDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProtocol();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteAddressDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteAddress();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static int CLOOP_CARG cloopgetRemoteProcessIDDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProcessID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteProcessNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProcessName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceConnection> > >
	class ITraceConnectionImpl : public ITraceConnectionBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceConnectionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceConnectionImpl()
		{
		}

		virtual unsigned getKind() = 0;
		virtual int getProcessID() = 0;
		virtual const char* getUserName() = 0;
		virtual const char* getRoleName() = 0;
		virtual const char* getCharSet() = 0;
		virtual const char* getRemoteProtocol() = 0;
		virtual const char* getRemoteAddress() = 0;
		virtual int getRemoteProcessID() = 0;
		virtual const char* getRemoteProcessName() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceDatabaseConnectionBaseImpl : public Base
	{
	public:
		typedef ITraceDatabaseConnection Declaration;

		ITraceDatabaseConnectionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getKind = &Name::cloopgetKindDispatcher;
					this->getProcessID = &Name::cloopgetProcessIDDispatcher;
					this->getUserName = &Name::cloopgetUserNameDispatcher;
					this->getRoleName = &Name::cloopgetRoleNameDispatcher;
					this->getCharSet = &Name::cloopgetCharSetDispatcher;
					this->getRemoteProtocol = &Name::cloopgetRemoteProtocolDispatcher;
					this->getRemoteAddress = &Name::cloopgetRemoteAddressDispatcher;
					this->getRemoteProcessID = &Name::cloopgetRemoteProcessIDDispatcher;
					this->getRemoteProcessName = &Name::cloopgetRemoteProcessNameDispatcher;
					this->getConnectionID = &Name::cloopgetConnectionIDDispatcher;
					this->getDatabaseName = &Name::cloopgetDatabaseNameDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static ISC_INT64 CLOOP_CARG cloopgetConnectionIDDispatcher(ITraceDatabaseConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getConnectionID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetDatabaseNameDispatcher(ITraceDatabaseConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDatabaseName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetKindDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getKind();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static int CLOOP_CARG cloopgetProcessIDDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getProcessID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetUserNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getUserName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRoleNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRoleName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetCharSetDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getCharSet();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteProtocolDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProtocol();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteAddressDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteAddress();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static int CLOOP_CARG cloopgetRemoteProcessIDDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProcessID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteProcessNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProcessName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = ITraceConnectionImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITraceDatabaseConnection> > > > >
	class ITraceDatabaseConnectionImpl : public ITraceDatabaseConnectionBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceDatabaseConnectionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceDatabaseConnectionImpl()
		{
		}

		virtual ISC_INT64 getConnectionID() = 0;
		virtual const char* getDatabaseName() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceTransactionBaseImpl : public Base
	{
	public:
		typedef ITraceTransaction Declaration;

		ITraceTransactionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getTransactionID = &Name::cloopgetTransactionIDDispatcher;
					this->getReadOnly = &Name::cloopgetReadOnlyDispatcher;
					this->getWait = &Name::cloopgetWaitDispatcher;
					this->getIsolation = &Name::cloopgetIsolationDispatcher;
					this->getPerf = &Name::cloopgetPerfDispatcher;
					this->getInitialID = &Name::cloopgetInitialIDDispatcher;
					this->getPreviousID = &Name::cloopgetPreviousIDDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static ISC_INT64 CLOOP_CARG cloopgetTransactionIDDispatcher(ITraceTransaction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getTransactionID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloopgetReadOnlyDispatcher(ITraceTransaction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getReadOnly();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static int CLOOP_CARG cloopgetWaitDispatcher(ITraceTransaction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getWait();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetIsolationDispatcher(ITraceTransaction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getIsolation();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static PerformanceInfo* CLOOP_CARG cloopgetPerfDispatcher(ITraceTransaction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPerf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<PerformanceInfo*>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetInitialIDDispatcher(ITraceTransaction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getInitialID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetPreviousIDDispatcher(ITraceTransaction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPreviousID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceTransaction> > >
	class ITraceTransactionImpl : public ITraceTransactionBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceTransactionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceTransactionImpl()
		{
		}

		virtual ISC_INT64 getTransactionID() = 0;
		virtual FB_BOOLEAN getReadOnly() = 0;
		virtual int getWait() = 0;
		virtual unsigned getIsolation() = 0;
		virtual PerformanceInfo* getPerf() = 0;
		virtual ISC_INT64 getInitialID() = 0;
		virtual ISC_INT64 getPreviousID() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceParamsBaseImpl : public Base
	{
	public:
		typedef ITraceParams Declaration;

		ITraceParamsBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getCount = &Name::cloopgetCountDispatcher;
					this->getParam = &Name::cloopgetParamDispatcher;
					this->getTextUTF8 = &Name::cloopgetTextUTF8Dispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopgetCountDispatcher(ITraceParams* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getCount();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static const dsc* CLOOP_CARG cloopgetParamDispatcher(ITraceParams* self, unsigned idx) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getParam(idx);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const dsc*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetTextUTF8Dispatcher(ITraceParams* self, IStatus* status, unsigned idx) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::getTextUTF8(&status2, idx);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceParams> > >
	class ITraceParamsImpl : public ITraceParamsBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceParamsImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceParamsImpl()
		{
		}

		virtual unsigned getCount() = 0;
		virtual const dsc* getParam(unsigned idx) = 0;
		virtual const char* getTextUTF8(StatusType* status, unsigned idx) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceStatementBaseImpl : public Base
	{
	public:
		typedef ITraceStatement Declaration;

		ITraceStatementBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getStmtID = &Name::cloopgetStmtIDDispatcher;
					this->getPerf = &Name::cloopgetPerfDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static ISC_INT64 CLOOP_CARG cloopgetStmtIDDispatcher(ITraceStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getStmtID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static PerformanceInfo* CLOOP_CARG cloopgetPerfDispatcher(ITraceStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPerf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<PerformanceInfo*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceStatement> > >
	class ITraceStatementImpl : public ITraceStatementBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceStatementImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceStatementImpl()
		{
		}

		virtual ISC_INT64 getStmtID() = 0;
		virtual PerformanceInfo* getPerf() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceSQLStatementBaseImpl : public Base
	{
	public:
		typedef ITraceSQLStatement Declaration;

		ITraceSQLStatementBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getStmtID = &Name::cloopgetStmtIDDispatcher;
					this->getPerf = &Name::cloopgetPerfDispatcher;
					this->getText = &Name::cloopgetTextDispatcher;
					this->getPlan = &Name::cloopgetPlanDispatcher;
					this->getInputs = &Name::cloopgetInputsDispatcher;
					this->getTextUTF8 = &Name::cloopgetTextUTF8Dispatcher;
					this->getExplainedPlan = &Name::cloopgetExplainedPlanDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetTextDispatcher(ITraceSQLStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getText();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetPlanDispatcher(ITraceSQLStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPlan();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static ITraceParams* CLOOP_CARG cloopgetInputsDispatcher(ITraceSQLStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getInputs();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ITraceParams*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetTextUTF8Dispatcher(ITraceSQLStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getTextUTF8();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetExplainedPlanDispatcher(ITraceSQLStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getExplainedPlan();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetStmtIDDispatcher(ITraceStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getStmtID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static PerformanceInfo* CLOOP_CARG cloopgetPerfDispatcher(ITraceStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPerf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<PerformanceInfo*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = ITraceStatementImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITraceSQLStatement> > > > >
	class ITraceSQLStatementImpl : public ITraceSQLStatementBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceSQLStatementImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceSQLStatementImpl()
		{
		}

		virtual const char* getText() = 0;
		virtual const char* getPlan() = 0;
		virtual ITraceParams* getInputs() = 0;
		virtual const char* getTextUTF8() = 0;
		virtual const char* getExplainedPlan() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceBLRStatementBaseImpl : public Base
	{
	public:
		typedef ITraceBLRStatement Declaration;

		ITraceBLRStatementBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getStmtID = &Name::cloopgetStmtIDDispatcher;
					this->getPerf = &Name::cloopgetPerfDispatcher;
					this->getData = &Name::cloopgetDataDispatcher;
					this->getDataLength = &Name::cloopgetDataLengthDispatcher;
					this->getText = &Name::cloopgetTextDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const unsigned char* CLOOP_CARG cloopgetDataDispatcher(ITraceBLRStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getData();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const unsigned char*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetDataLengthDispatcher(ITraceBLRStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDataLength();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetTextDispatcher(ITraceBLRStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getText();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetStmtIDDispatcher(ITraceStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getStmtID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static PerformanceInfo* CLOOP_CARG cloopgetPerfDispatcher(ITraceStatement* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPerf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<PerformanceInfo*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = ITraceStatementImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITraceBLRStatement> > > > >
	class ITraceBLRStatementImpl : public ITraceBLRStatementBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceBLRStatementImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceBLRStatementImpl()
		{
		}

		virtual const unsigned char* getData() = 0;
		virtual unsigned getDataLength() = 0;
		virtual const char* getText() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceDYNRequestBaseImpl : public Base
	{
	public:
		typedef ITraceDYNRequest Declaration;

		ITraceDYNRequestBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getData = &Name::cloopgetDataDispatcher;
					this->getDataLength = &Name::cloopgetDataLengthDispatcher;
					this->getText = &Name::cloopgetTextDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const unsigned char* CLOOP_CARG cloopgetDataDispatcher(ITraceDYNRequest* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getData();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const unsigned char*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetDataLengthDispatcher(ITraceDYNRequest* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDataLength();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetTextDispatcher(ITraceDYNRequest* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getText();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceDYNRequest> > >
	class ITraceDYNRequestImpl : public ITraceDYNRequestBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceDYNRequestImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceDYNRequestImpl()
		{
		}

		virtual const unsigned char* getData() = 0;
		virtual unsigned getDataLength() = 0;
		virtual const char* getText() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceContextVariableBaseImpl : public Base
	{
	public:
		typedef ITraceContextVariable Declaration;

		ITraceContextVariableBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getNameSpace = &Name::cloopgetNameSpaceDispatcher;
					this->getVarName = &Name::cloopgetVarNameDispatcher;
					this->getVarValue = &Name::cloopgetVarValueDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetNameSpaceDispatcher(ITraceContextVariable* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getNameSpace();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetVarNameDispatcher(ITraceContextVariable* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getVarName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetVarValueDispatcher(ITraceContextVariable* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getVarValue();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceContextVariable> > >
	class ITraceContextVariableImpl : public ITraceContextVariableBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceContextVariableImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceContextVariableImpl()
		{
		}

		virtual const char* getNameSpace() = 0;
		virtual const char* getVarName() = 0;
		virtual const char* getVarValue() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceProcedureBaseImpl : public Base
	{
	public:
		typedef ITraceProcedure Declaration;

		ITraceProcedureBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getProcName = &Name::cloopgetProcNameDispatcher;
					this->getInputs = &Name::cloopgetInputsDispatcher;
					this->getPerf = &Name::cloopgetPerfDispatcher;
					this->getStmtID = &Name::cloopgetStmtIDDispatcher;
					this->getPlan = &Name::cloopgetPlanDispatcher;
					this->getExplainedPlan = &Name::cloopgetExplainedPlanDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetProcNameDispatcher(ITraceProcedure* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getProcName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static ITraceParams* CLOOP_CARG cloopgetInputsDispatcher(ITraceProcedure* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getInputs();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ITraceParams*>(0);
			}
		}

		static PerformanceInfo* CLOOP_CARG cloopgetPerfDispatcher(ITraceProcedure* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPerf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<PerformanceInfo*>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetStmtIDDispatcher(ITraceProcedure* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getStmtID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetPlanDispatcher(ITraceProcedure* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPlan();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetExplainedPlanDispatcher(ITraceProcedure* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getExplainedPlan();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceProcedure> > >
	class ITraceProcedureImpl : public ITraceProcedureBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceProcedureImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceProcedureImpl()
		{
		}

		virtual const char* getProcName() = 0;
		virtual ITraceParams* getInputs() = 0;
		virtual PerformanceInfo* getPerf() = 0;
		virtual ISC_INT64 getStmtID() = 0;
		virtual const char* getPlan() = 0;
		virtual const char* getExplainedPlan() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceFunctionBaseImpl : public Base
	{
	public:
		typedef ITraceFunction Declaration;

		ITraceFunctionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getFuncName = &Name::cloopgetFuncNameDispatcher;
					this->getInputs = &Name::cloopgetInputsDispatcher;
					this->getResult = &Name::cloopgetResultDispatcher;
					this->getPerf = &Name::cloopgetPerfDispatcher;
					this->getStmtID = &Name::cloopgetStmtIDDispatcher;
					this->getPlan = &Name::cloopgetPlanDispatcher;
					this->getExplainedPlan = &Name::cloopgetExplainedPlanDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetFuncNameDispatcher(ITraceFunction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getFuncName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static ITraceParams* CLOOP_CARG cloopgetInputsDispatcher(ITraceFunction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getInputs();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ITraceParams*>(0);
			}
		}

		static ITraceParams* CLOOP_CARG cloopgetResultDispatcher(ITraceFunction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getResult();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ITraceParams*>(0);
			}
		}

		static PerformanceInfo* CLOOP_CARG cloopgetPerfDispatcher(ITraceFunction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPerf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<PerformanceInfo*>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetStmtIDDispatcher(ITraceFunction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getStmtID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetPlanDispatcher(ITraceFunction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPlan();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetExplainedPlanDispatcher(ITraceFunction* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getExplainedPlan();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceFunction> > >
	class ITraceFunctionImpl : public ITraceFunctionBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceFunctionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceFunctionImpl()
		{
		}

		virtual const char* getFuncName() = 0;
		virtual ITraceParams* getInputs() = 0;
		virtual ITraceParams* getResult() = 0;
		virtual PerformanceInfo* getPerf() = 0;
		virtual ISC_INT64 getStmtID() = 0;
		virtual const char* getPlan() = 0;
		virtual const char* getExplainedPlan() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceTriggerBaseImpl : public Base
	{
	public:
		typedef ITraceTrigger Declaration;

		ITraceTriggerBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getTriggerName = &Name::cloopgetTriggerNameDispatcher;
					this->getRelationName = &Name::cloopgetRelationNameDispatcher;
					this->getAction = &Name::cloopgetActionDispatcher;
					this->getWhich = &Name::cloopgetWhichDispatcher;
					this->getPerf = &Name::cloopgetPerfDispatcher;
					this->getStmtID = &Name::cloopgetStmtIDDispatcher;
					this->getPlan = &Name::cloopgetPlanDispatcher;
					this->getExplainedPlan = &Name::cloopgetExplainedPlanDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetTriggerNameDispatcher(ITraceTrigger* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getTriggerName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRelationNameDispatcher(ITraceTrigger* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRelationName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static int CLOOP_CARG cloopgetActionDispatcher(ITraceTrigger* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getAction();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopgetWhichDispatcher(ITraceTrigger* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getWhich();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static PerformanceInfo* CLOOP_CARG cloopgetPerfDispatcher(ITraceTrigger* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPerf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<PerformanceInfo*>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetStmtIDDispatcher(ITraceTrigger* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getStmtID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetPlanDispatcher(ITraceTrigger* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPlan();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetExplainedPlanDispatcher(ITraceTrigger* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getExplainedPlan();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceTrigger> > >
	class ITraceTriggerImpl : public ITraceTriggerBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceTriggerImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceTriggerImpl()
		{
		}

		virtual const char* getTriggerName() = 0;
		virtual const char* getRelationName() = 0;
		virtual int getAction() = 0;
		virtual int getWhich() = 0;
		virtual PerformanceInfo* getPerf() = 0;
		virtual ISC_INT64 getStmtID() = 0;
		virtual const char* getPlan() = 0;
		virtual const char* getExplainedPlan() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceServiceConnectionBaseImpl : public Base
	{
	public:
		typedef ITraceServiceConnection Declaration;

		ITraceServiceConnectionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getKind = &Name::cloopgetKindDispatcher;
					this->getProcessID = &Name::cloopgetProcessIDDispatcher;
					this->getUserName = &Name::cloopgetUserNameDispatcher;
					this->getRoleName = &Name::cloopgetRoleNameDispatcher;
					this->getCharSet = &Name::cloopgetCharSetDispatcher;
					this->getRemoteProtocol = &Name::cloopgetRemoteProtocolDispatcher;
					this->getRemoteAddress = &Name::cloopgetRemoteAddressDispatcher;
					this->getRemoteProcessID = &Name::cloopgetRemoteProcessIDDispatcher;
					this->getRemoteProcessName = &Name::cloopgetRemoteProcessNameDispatcher;
					this->getServiceID = &Name::cloopgetServiceIDDispatcher;
					this->getServiceMgr = &Name::cloopgetServiceMgrDispatcher;
					this->getServiceName = &Name::cloopgetServiceNameDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void* CLOOP_CARG cloopgetServiceIDDispatcher(ITraceServiceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getServiceID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<void*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetServiceMgrDispatcher(ITraceServiceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getServiceMgr();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetServiceNameDispatcher(ITraceServiceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getServiceName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetKindDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getKind();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static int CLOOP_CARG cloopgetProcessIDDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getProcessID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetUserNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getUserName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRoleNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRoleName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetCharSetDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getCharSet();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteProtocolDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProtocol();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteAddressDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteAddress();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static int CLOOP_CARG cloopgetRemoteProcessIDDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProcessID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetRemoteProcessNameDispatcher(ITraceConnection* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRemoteProcessName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = ITraceConnectionImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITraceServiceConnection> > > > >
	class ITraceServiceConnectionImpl : public ITraceServiceConnectionBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceServiceConnectionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceServiceConnectionImpl()
		{
		}

		virtual void* getServiceID() = 0;
		virtual const char* getServiceMgr() = 0;
		virtual const char* getServiceName() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceStatusVectorBaseImpl : public Base
	{
	public:
		typedef ITraceStatusVector Declaration;

		ITraceStatusVectorBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->hasError = &Name::cloophasErrorDispatcher;
					this->hasWarning = &Name::cloophasWarningDispatcher;
					this->getStatus = &Name::cloopgetStatusDispatcher;
					this->getText = &Name::cloopgetTextDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static FB_BOOLEAN CLOOP_CARG cloophasErrorDispatcher(ITraceStatusVector* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::hasError();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG cloophasWarningDispatcher(ITraceStatusVector* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::hasWarning();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static IStatus* CLOOP_CARG cloopgetStatusDispatcher(ITraceStatusVector* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getStatus();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IStatus*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetTextDispatcher(ITraceStatusVector* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getText();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceStatusVector> > >
	class ITraceStatusVectorImpl : public ITraceStatusVectorBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceStatusVectorImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceStatusVectorImpl()
		{
		}

		virtual FB_BOOLEAN hasError() = 0;
		virtual FB_BOOLEAN hasWarning() = 0;
		virtual IStatus* getStatus() = 0;
		virtual const char* getText() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceSweepInfoBaseImpl : public Base
	{
	public:
		typedef ITraceSweepInfo Declaration;

		ITraceSweepInfoBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getOIT = &Name::cloopgetOITDispatcher;
					this->getOST = &Name::cloopgetOSTDispatcher;
					this->getOAT = &Name::cloopgetOATDispatcher;
					this->getNext = &Name::cloopgetNextDispatcher;
					this->getPerf = &Name::cloopgetPerfDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static ISC_INT64 CLOOP_CARG cloopgetOITDispatcher(ITraceSweepInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOIT();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetOSTDispatcher(ITraceSweepInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOST();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetOATDispatcher(ITraceSweepInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOAT();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static ISC_INT64 CLOOP_CARG cloopgetNextDispatcher(ITraceSweepInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getNext();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static PerformanceInfo* CLOOP_CARG cloopgetPerfDispatcher(ITraceSweepInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getPerf();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<PerformanceInfo*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceSweepInfo> > >
	class ITraceSweepInfoImpl : public ITraceSweepInfoBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceSweepInfoImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceSweepInfoImpl()
		{
		}

		virtual ISC_INT64 getOIT() = 0;
		virtual ISC_INT64 getOST() = 0;
		virtual ISC_INT64 getOAT() = 0;
		virtual ISC_INT64 getNext() = 0;
		virtual PerformanceInfo* getPerf() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceLogWriterBaseImpl : public Base
	{
	public:
		typedef ITraceLogWriter Declaration;

		ITraceLogWriterBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->write = &Name::cloopwriteDispatcher;
					this->write_s = &Name::cloopwrite_sDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopwriteDispatcher(ITraceLogWriter* self, const void* buf, unsigned size) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::write(buf, size);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static unsigned CLOOP_CARG cloopwrite_sDispatcher(ITraceLogWriter* self, IStatus* status, const void* buf, unsigned size) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::write_s(&status2, buf, size);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITraceLogWriter> > > > >
	class ITraceLogWriterImpl : public ITraceLogWriterBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceLogWriterImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceLogWriterImpl()
		{
		}

		virtual unsigned write(const void* buf, unsigned size) = 0;
		virtual unsigned write_s(StatusType* status, const void* buf, unsigned size) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceInitInfoBaseImpl : public Base
	{
	public:
		typedef ITraceInitInfo Declaration;

		ITraceInitInfoBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getConfigText = &Name::cloopgetConfigTextDispatcher;
					this->getTraceSessionID = &Name::cloopgetTraceSessionIDDispatcher;
					this->getTraceSessionName = &Name::cloopgetTraceSessionNameDispatcher;
					this->getFirebirdRootDirectory = &Name::cloopgetFirebirdRootDirectoryDispatcher;
					this->getDatabaseName = &Name::cloopgetDatabaseNameDispatcher;
					this->getConnection = &Name::cloopgetConnectionDispatcher;
					this->getLogWriter = &Name::cloopgetLogWriterDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetConfigTextDispatcher(ITraceInitInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getConfigText();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static int CLOOP_CARG cloopgetTraceSessionIDDispatcher(ITraceInitInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getTraceSessionID();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetTraceSessionNameDispatcher(ITraceInitInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getTraceSessionName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetFirebirdRootDirectoryDispatcher(ITraceInitInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getFirebirdRootDirectory();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static const char* CLOOP_CARG cloopgetDatabaseNameDispatcher(ITraceInitInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getDatabaseName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static ITraceDatabaseConnection* CLOOP_CARG cloopgetConnectionDispatcher(ITraceInitInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getConnection();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ITraceDatabaseConnection*>(0);
			}
		}

		static ITraceLogWriter* CLOOP_CARG cloopgetLogWriterDispatcher(ITraceInitInfo* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getLogWriter();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ITraceLogWriter*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<ITraceInitInfo> > >
	class ITraceInitInfoImpl : public ITraceInitInfoBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceInitInfoImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceInitInfoImpl()
		{
		}

		virtual const char* getConfigText() = 0;
		virtual int getTraceSessionID() = 0;
		virtual const char* getTraceSessionName() = 0;
		virtual const char* getFirebirdRootDirectory() = 0;
		virtual const char* getDatabaseName() = 0;
		virtual ITraceDatabaseConnection* getConnection() = 0;
		virtual ITraceLogWriter* getLogWriter() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITracePluginBaseImpl : public Base
	{
	public:
		typedef ITracePlugin Declaration;

		ITracePluginBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->trace_get_error = &Name::clooptrace_get_errorDispatcher;
					this->trace_attach = &Name::clooptrace_attachDispatcher;
					this->trace_detach = &Name::clooptrace_detachDispatcher;
					this->trace_transaction_start = &Name::clooptrace_transaction_startDispatcher;
					this->trace_transaction_end = &Name::clooptrace_transaction_endDispatcher;
					this->trace_proc_execute = &Name::clooptrace_proc_executeDispatcher;
					this->trace_trigger_execute = &Name::clooptrace_trigger_executeDispatcher;
					this->trace_set_context = &Name::clooptrace_set_contextDispatcher;
					this->trace_dsql_prepare = &Name::clooptrace_dsql_prepareDispatcher;
					this->trace_dsql_free = &Name::clooptrace_dsql_freeDispatcher;
					this->trace_dsql_execute = &Name::clooptrace_dsql_executeDispatcher;
					this->trace_blr_compile = &Name::clooptrace_blr_compileDispatcher;
					this->trace_blr_execute = &Name::clooptrace_blr_executeDispatcher;
					this->trace_dyn_execute = &Name::clooptrace_dyn_executeDispatcher;
					this->trace_service_attach = &Name::clooptrace_service_attachDispatcher;
					this->trace_service_start = &Name::clooptrace_service_startDispatcher;
					this->trace_service_query = &Name::clooptrace_service_queryDispatcher;
					this->trace_service_detach = &Name::clooptrace_service_detachDispatcher;
					this->trace_event_error = &Name::clooptrace_event_errorDispatcher;
					this->trace_event_sweep = &Name::clooptrace_event_sweepDispatcher;
					this->trace_func_execute = &Name::clooptrace_func_executeDispatcher;
					this->trace_dsql_restart = &Name::clooptrace_dsql_restartDispatcher;
					this->trace_proc_compile = &Name::clooptrace_proc_compileDispatcher;
					this->trace_func_compile = &Name::clooptrace_func_compileDispatcher;
					this->trace_trigger_compile = &Name::clooptrace_trigger_compileDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG clooptrace_get_errorDispatcher(ITracePlugin* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_get_error();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_attachDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, FB_BOOLEAN create_db, unsigned att_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_attach(connection, create_db, att_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_detachDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, FB_BOOLEAN drop_db) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_detach(connection, drop_db);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_transaction_startDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, unsigned tpb_length, const unsigned char* tpb, unsigned tra_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_transaction_start(connection, transaction, tpb_length, tpb, tra_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_transaction_endDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, FB_BOOLEAN commit, FB_BOOLEAN retain_context, unsigned tra_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_transaction_end(connection, transaction, commit, retain_context, tra_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_proc_executeDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceProcedure* procedure, FB_BOOLEAN started, unsigned proc_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_proc_execute(connection, transaction, procedure, started, proc_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_trigger_executeDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceTrigger* trigger, FB_BOOLEAN started, unsigned trig_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_trigger_execute(connection, transaction, trigger, started, trig_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_set_contextDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceContextVariable* variable) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_set_context(connection, transaction, variable);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_dsql_prepareDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, ISC_INT64 time_millis, unsigned req_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_dsql_prepare(connection, transaction, statement, time_millis, req_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_dsql_freeDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceSQLStatement* statement, unsigned option) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_dsql_free(connection, statement, option);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_dsql_executeDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, FB_BOOLEAN started, unsigned req_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_dsql_execute(connection, transaction, statement, started, req_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_blr_compileDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceBLRStatement* statement, ISC_INT64 time_millis, unsigned req_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_blr_compile(connection, transaction, statement, time_millis, req_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_blr_executeDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceBLRStatement* statement, unsigned req_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_blr_execute(connection, transaction, statement, req_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_dyn_executeDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceDYNRequest* request, ISC_INT64 time_millis, unsigned req_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_dyn_execute(connection, transaction, request, time_millis, req_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_service_attachDispatcher(ITracePlugin* self, ITraceServiceConnection* service, unsigned att_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_service_attach(service, att_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_service_startDispatcher(ITracePlugin* self, ITraceServiceConnection* service, unsigned switches_length, const char* switches, unsigned start_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_service_start(service, switches_length, switches, start_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_service_queryDispatcher(ITracePlugin* self, ITraceServiceConnection* service, unsigned send_item_length, const unsigned char* send_items, unsigned recv_item_length, const unsigned char* recv_items, unsigned query_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_service_query(service, send_item_length, send_items, recv_item_length, recv_items, query_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_service_detachDispatcher(ITracePlugin* self, ITraceServiceConnection* service, unsigned detach_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_service_detach(service, detach_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_event_errorDispatcher(ITracePlugin* self, ITraceConnection* connection, ITraceStatusVector* status, const char* function) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_event_error(connection, status, function);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_event_sweepDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceSweepInfo* sweep, unsigned sweep_state) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_event_sweep(connection, sweep, sweep_state);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_func_executeDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceFunction* function, FB_BOOLEAN started, unsigned func_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_func_execute(connection, transaction, function, started, func_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_dsql_restartDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, unsigned number) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_dsql_restart(connection, transaction, statement, number);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_proc_compileDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceProcedure* procedure, ISC_INT64 time_millis, unsigned proc_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_proc_compile(connection, procedure, time_millis, proc_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_func_compileDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceFunction* function, ISC_INT64 time_millis, unsigned func_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_func_compile(connection, function, time_millis, func_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static FB_BOOLEAN CLOOP_CARG clooptrace_trigger_compileDispatcher(ITracePlugin* self, ITraceDatabaseConnection* connection, ITraceTrigger* trigger, ISC_INT64 time_millis, unsigned trig_result) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_trigger_compile(connection, trigger, time_millis, trig_result);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITracePlugin> > > > >
	class ITracePluginImpl : public ITracePluginBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITracePluginImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITracePluginImpl()
		{
		}

		virtual const char* trace_get_error() = 0;
		virtual FB_BOOLEAN trace_attach(ITraceDatabaseConnection* connection, FB_BOOLEAN create_db, unsigned att_result) = 0;
		virtual FB_BOOLEAN trace_detach(ITraceDatabaseConnection* connection, FB_BOOLEAN drop_db) = 0;
		virtual FB_BOOLEAN trace_transaction_start(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, unsigned tpb_length, const unsigned char* tpb, unsigned tra_result) = 0;
		virtual FB_BOOLEAN trace_transaction_end(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, FB_BOOLEAN commit, FB_BOOLEAN retain_context, unsigned tra_result) = 0;
		virtual FB_BOOLEAN trace_proc_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceProcedure* procedure, FB_BOOLEAN started, unsigned proc_result) = 0;
		virtual FB_BOOLEAN trace_trigger_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceTrigger* trigger, FB_BOOLEAN started, unsigned trig_result) = 0;
		virtual FB_BOOLEAN trace_set_context(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceContextVariable* variable) = 0;
		virtual FB_BOOLEAN trace_dsql_prepare(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, ISC_INT64 time_millis, unsigned req_result) = 0;
		virtual FB_BOOLEAN trace_dsql_free(ITraceDatabaseConnection* connection, ITraceSQLStatement* statement, unsigned option) = 0;
		virtual FB_BOOLEAN trace_dsql_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, FB_BOOLEAN started, unsigned req_result) = 0;
		virtual FB_BOOLEAN trace_blr_compile(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceBLRStatement* statement, ISC_INT64 time_millis, unsigned req_result) = 0;
		virtual FB_BOOLEAN trace_blr_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceBLRStatement* statement, unsigned req_result) = 0;
		virtual FB_BOOLEAN trace_dyn_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceDYNRequest* request, ISC_INT64 time_millis, unsigned req_result) = 0;
		virtual FB_BOOLEAN trace_service_attach(ITraceServiceConnection* service, unsigned att_result) = 0;
		virtual FB_BOOLEAN trace_service_start(ITraceServiceConnection* service, unsigned switches_length, const char* switches, unsigned start_result) = 0;
		virtual FB_BOOLEAN trace_service_query(ITraceServiceConnection* service, unsigned send_item_length, const unsigned char* send_items, unsigned recv_item_length, const unsigned char* recv_items, unsigned query_result) = 0;
		virtual FB_BOOLEAN trace_service_detach(ITraceServiceConnection* service, unsigned detach_result) = 0;
		virtual FB_BOOLEAN trace_event_error(ITraceConnection* connection, ITraceStatusVector* status, const char* function) = 0;
		virtual FB_BOOLEAN trace_event_sweep(ITraceDatabaseConnection* connection, ITraceSweepInfo* sweep, unsigned sweep_state) = 0;
		virtual FB_BOOLEAN trace_func_execute(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceFunction* function, FB_BOOLEAN started, unsigned func_result) = 0;
		virtual FB_BOOLEAN trace_dsql_restart(ITraceDatabaseConnection* connection, ITraceTransaction* transaction, ITraceSQLStatement* statement, unsigned number) = 0;
		virtual FB_BOOLEAN trace_proc_compile(ITraceDatabaseConnection* connection, ITraceProcedure* procedure, ISC_INT64 time_millis, unsigned proc_result) = 0;
		virtual FB_BOOLEAN trace_func_compile(ITraceDatabaseConnection* connection, ITraceFunction* function, ISC_INT64 time_millis, unsigned func_result) = 0;
		virtual FB_BOOLEAN trace_trigger_compile(ITraceDatabaseConnection* connection, ITraceTrigger* trigger, ISC_INT64 time_millis, unsigned trig_result) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class ITraceFactoryBaseImpl : public Base
	{
	public:
		typedef ITraceFactory Declaration;

		ITraceFactoryBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->trace_needs = &Name::clooptrace_needsDispatcher;
					this->trace_create = &Name::clooptrace_createDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static ISC_UINT64 CLOOP_CARG clooptrace_needsDispatcher(ITraceFactory* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::trace_needs();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_UINT64>(0);
			}
		}

		static ITracePlugin* CLOOP_CARG clooptrace_createDispatcher(ITraceFactory* self, IStatus* status, ITraceInitInfo* init_info) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::trace_create(&status2, init_info);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<ITracePlugin*>(0);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<ITraceFactory> > > > > > >
	class ITraceFactoryImpl : public ITraceFactoryBaseImpl<Name, StatusType, Base>
	{
	protected:
		ITraceFactoryImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~ITraceFactoryImpl()
		{
		}

		virtual ISC_UINT64 trace_needs() = 0;
		virtual ITracePlugin* trace_create(StatusType* status, ITraceInitInfo* init_info) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IUdrFunctionFactoryBaseImpl : public Base
	{
	public:
		typedef IUdrFunctionFactory Declaration;

		IUdrFunctionFactoryBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->setup = &Name::cloopsetupDispatcher;
					this->newItem = &Name::cloopnewItemDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetupDispatcher(IUdrFunctionFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setup(&status2, context, metadata, inBuilder, outBuilder);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IExternalFunction* CLOOP_CARG cloopnewItemDispatcher(IUdrFunctionFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::newItem(&status2, context, metadata);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IExternalFunction*>(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IUdrFunctionFactory> > > > >
	class IUdrFunctionFactoryImpl : public IUdrFunctionFactoryBaseImpl<Name, StatusType, Base>
	{
	protected:
		IUdrFunctionFactoryImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IUdrFunctionFactoryImpl()
		{
		}

		virtual void setup(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) = 0;
		virtual IExternalFunction* newItem(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IUdrProcedureFactoryBaseImpl : public Base
	{
	public:
		typedef IUdrProcedureFactory Declaration;

		IUdrProcedureFactoryBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->setup = &Name::cloopsetupDispatcher;
					this->newItem = &Name::cloopnewItemDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetupDispatcher(IUdrProcedureFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setup(&status2, context, metadata, inBuilder, outBuilder);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IExternalProcedure* CLOOP_CARG cloopnewItemDispatcher(IUdrProcedureFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::newItem(&status2, context, metadata);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IExternalProcedure*>(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IUdrProcedureFactory> > > > >
	class IUdrProcedureFactoryImpl : public IUdrProcedureFactoryBaseImpl<Name, StatusType, Base>
	{
	protected:
		IUdrProcedureFactoryImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IUdrProcedureFactoryImpl()
		{
		}

		virtual void setup(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* inBuilder, IMetadataBuilder* outBuilder) = 0;
		virtual IExternalProcedure* newItem(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IUdrTriggerFactoryBaseImpl : public Base
	{
	public:
		typedef IUdrTriggerFactory Declaration;

		IUdrTriggerFactoryBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->setup = &Name::cloopsetupDispatcher;
					this->newItem = &Name::cloopnewItemDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopsetupDispatcher(IUdrTriggerFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* fieldsBuilder) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setup(&status2, context, metadata, fieldsBuilder);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IExternalTrigger* CLOOP_CARG cloopnewItemDispatcher(IUdrTriggerFactory* self, IStatus* status, IExternalContext* context, IRoutineMetadata* metadata) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::newItem(&status2, context, metadata);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IExternalTrigger*>(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IUdrTriggerFactory> > > > >
	class IUdrTriggerFactoryImpl : public IUdrTriggerFactoryBaseImpl<Name, StatusType, Base>
	{
	protected:
		IUdrTriggerFactoryImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IUdrTriggerFactoryImpl()
		{
		}

		virtual void setup(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata, IMetadataBuilder* fieldsBuilder) = 0;
		virtual IExternalTrigger* newItem(StatusType* status, IExternalContext* context, IRoutineMetadata* metadata) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IUdrPluginBaseImpl : public Base
	{
	public:
		typedef IUdrPlugin Declaration;

		IUdrPluginBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getMaster = &Name::cloopgetMasterDispatcher;
					this->registerFunction = &Name::cloopregisterFunctionDispatcher;
					this->registerProcedure = &Name::cloopregisterProcedureDispatcher;
					this->registerTrigger = &Name::cloopregisterTriggerDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static IMaster* CLOOP_CARG cloopgetMasterDispatcher(IUdrPlugin* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getMaster();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IMaster*>(0);
			}
		}

		static void CLOOP_CARG cloopregisterFunctionDispatcher(IUdrPlugin* self, IStatus* status, const char* name, IUdrFunctionFactory* factory) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::registerFunction(&status2, name, factory);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopregisterProcedureDispatcher(IUdrPlugin* self, IStatus* status, const char* name, IUdrProcedureFactory* factory) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::registerProcedure(&status2, name, factory);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopregisterTriggerDispatcher(IUdrPlugin* self, IStatus* status, const char* name, IUdrTriggerFactory* factory) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::registerTrigger(&status2, name, factory);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IUdrPlugin> > >
	class IUdrPluginImpl : public IUdrPluginBaseImpl<Name, StatusType, Base>
	{
	protected:
		IUdrPluginImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IUdrPluginImpl()
		{
		}

		virtual IMaster* getMaster() = 0;
		virtual void registerFunction(StatusType* status, const char* name, IUdrFunctionFactory* factory) = 0;
		virtual void registerProcedure(StatusType* status, const char* name, IUdrProcedureFactory* factory) = 0;
		virtual void registerTrigger(StatusType* status, const char* name, IUdrTriggerFactory* factory) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IDecFloat16BaseImpl : public Base
	{
	public:
		typedef IDecFloat16 Declaration;

		IDecFloat16BaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->toBcd = &Name::clooptoBcdDispatcher;
					this->toString = &Name::clooptoStringDispatcher;
					this->fromBcd = &Name::cloopfromBcdDispatcher;
					this->fromString = &Name::cloopfromStringDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG clooptoBcdDispatcher(IDecFloat16* self, const FB_DEC16* from, int* sign, unsigned char* bcd, int* exp) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::toBcd(from, sign, bcd, exp);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG clooptoStringDispatcher(IDecFloat16* self, IStatus* status, const FB_DEC16* from, unsigned bufferLength, char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::toString(&status2, from, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopfromBcdDispatcher(IDecFloat16* self, int sign, const unsigned char* bcd, int exp, FB_DEC16* to) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::fromBcd(sign, bcd, exp, to);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopfromStringDispatcher(IDecFloat16* self, IStatus* status, const char* from, FB_DEC16* to) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::fromString(&status2, from, to);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IDecFloat16> > >
	class IDecFloat16Impl : public IDecFloat16BaseImpl<Name, StatusType, Base>
	{
	protected:
		IDecFloat16Impl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IDecFloat16Impl()
		{
		}

		virtual void toBcd(const FB_DEC16* from, int* sign, unsigned char* bcd, int* exp) = 0;
		virtual void toString(StatusType* status, const FB_DEC16* from, unsigned bufferLength, char* buffer) = 0;
		virtual void fromBcd(int sign, const unsigned char* bcd, int exp, FB_DEC16* to) = 0;
		virtual void fromString(StatusType* status, const char* from, FB_DEC16* to) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IDecFloat34BaseImpl : public Base
	{
	public:
		typedef IDecFloat34 Declaration;

		IDecFloat34BaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->toBcd = &Name::clooptoBcdDispatcher;
					this->toString = &Name::clooptoStringDispatcher;
					this->fromBcd = &Name::cloopfromBcdDispatcher;
					this->fromString = &Name::cloopfromStringDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG clooptoBcdDispatcher(IDecFloat34* self, const FB_DEC34* from, int* sign, unsigned char* bcd, int* exp) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::toBcd(from, sign, bcd, exp);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG clooptoStringDispatcher(IDecFloat34* self, IStatus* status, const FB_DEC34* from, unsigned bufferLength, char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::toString(&status2, from, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopfromBcdDispatcher(IDecFloat34* self, int sign, const unsigned char* bcd, int exp, FB_DEC34* to) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::fromBcd(sign, bcd, exp, to);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopfromStringDispatcher(IDecFloat34* self, IStatus* status, const char* from, FB_DEC34* to) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::fromString(&status2, from, to);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IDecFloat34> > >
	class IDecFloat34Impl : public IDecFloat34BaseImpl<Name, StatusType, Base>
	{
	protected:
		IDecFloat34Impl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IDecFloat34Impl()
		{
		}

		virtual void toBcd(const FB_DEC34* from, int* sign, unsigned char* bcd, int* exp) = 0;
		virtual void toString(StatusType* status, const FB_DEC34* from, unsigned bufferLength, char* buffer) = 0;
		virtual void fromBcd(int sign, const unsigned char* bcd, int exp, FB_DEC34* to) = 0;
		virtual void fromString(StatusType* status, const char* from, FB_DEC34* to) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IInt128BaseImpl : public Base
	{
	public:
		typedef IInt128 Declaration;

		IInt128BaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->toString = &Name::clooptoStringDispatcher;
					this->fromString = &Name::cloopfromStringDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG clooptoStringDispatcher(IInt128* self, IStatus* status, const FB_I128* from, int scale, unsigned bufferLength, char* buffer) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::toString(&status2, from, scale, bufferLength, buffer);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopfromStringDispatcher(IInt128* self, IStatus* status, int scale, const char* from, FB_I128* to) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::fromString(&status2, scale, from, to);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IInt128> > >
	class IInt128Impl : public IInt128BaseImpl<Name, StatusType, Base>
	{
	protected:
		IInt128Impl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IInt128Impl()
		{
		}

		virtual void toString(StatusType* status, const FB_I128* from, int scale, unsigned bufferLength, char* buffer) = 0;
		virtual void fromString(StatusType* status, int scale, const char* from, FB_I128* to) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IReplicatedFieldBaseImpl : public Base
	{
	public:
		typedef IReplicatedField Declaration;

		IReplicatedFieldBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getName = &Name::cloopgetNameDispatcher;
					this->getType = &Name::cloopgetTypeDispatcher;
					this->getSubType = &Name::cloopgetSubTypeDispatcher;
					this->getScale = &Name::cloopgetScaleDispatcher;
					this->getLength = &Name::cloopgetLengthDispatcher;
					this->getCharSet = &Name::cloopgetCharSetDispatcher;
					this->getData = &Name::cloopgetDataDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static const char* CLOOP_CARG cloopgetNameDispatcher(IReplicatedField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getName();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const char*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetTypeDispatcher(IReplicatedField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getType();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static int CLOOP_CARG cloopgetSubTypeDispatcher(IReplicatedField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getSubType();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static int CLOOP_CARG cloopgetScaleDispatcher(IReplicatedField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getScale();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetLengthDispatcher(IReplicatedField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getLength();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetCharSetDispatcher(IReplicatedField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getCharSet();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static const void* CLOOP_CARG cloopgetDataDispatcher(IReplicatedField* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getData();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const void*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IReplicatedField> > >
	class IReplicatedFieldImpl : public IReplicatedFieldBaseImpl<Name, StatusType, Base>
	{
	protected:
		IReplicatedFieldImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IReplicatedFieldImpl()
		{
		}

		virtual const char* getName() = 0;
		virtual unsigned getType() = 0;
		virtual int getSubType() = 0;
		virtual int getScale() = 0;
		virtual unsigned getLength() = 0;
		virtual unsigned getCharSet() = 0;
		virtual const void* getData() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IReplicatedRecordBaseImpl : public Base
	{
	public:
		typedef IReplicatedRecord Declaration;

		IReplicatedRecordBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getCount = &Name::cloopgetCountDispatcher;
					this->getField = &Name::cloopgetFieldDispatcher;
					this->getRawLength = &Name::cloopgetRawLengthDispatcher;
					this->getRawData = &Name::cloopgetRawDataDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static unsigned CLOOP_CARG cloopgetCountDispatcher(IReplicatedRecord* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getCount();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static IReplicatedField* CLOOP_CARG cloopgetFieldDispatcher(IReplicatedRecord* self, unsigned index) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getField(index);
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReplicatedField*>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetRawLengthDispatcher(IReplicatedRecord* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRawLength();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static const unsigned char* CLOOP_CARG cloopgetRawDataDispatcher(IReplicatedRecord* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getRawData();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<const unsigned char*>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IReplicatedRecord> > >
	class IReplicatedRecordImpl : public IReplicatedRecordBaseImpl<Name, StatusType, Base>
	{
	protected:
		IReplicatedRecordImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IReplicatedRecordImpl()
		{
		}

		virtual unsigned getCount() = 0;
		virtual IReplicatedField* getField(unsigned index) = 0;
		virtual unsigned getRawLength() = 0;
		virtual const unsigned char* getRawData() = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IReplicatedTransactionBaseImpl : public Base
	{
	public:
		typedef IReplicatedTransaction Declaration;

		IReplicatedTransactionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->prepare = &Name::cloopprepareDispatcher;
					this->commit = &Name::cloopcommitDispatcher;
					this->rollback = &Name::clooprollbackDispatcher;
					this->startSavepoint = &Name::cloopstartSavepointDispatcher;
					this->releaseSavepoint = &Name::cloopreleaseSavepointDispatcher;
					this->rollbackSavepoint = &Name::clooprollbackSavepointDispatcher;
					this->insertRecord = &Name::cloopinsertRecordDispatcher;
					this->updateRecord = &Name::cloopupdateRecordDispatcher;
					this->deleteRecord = &Name::cloopdeleteRecordDispatcher;
					this->executeSql = &Name::cloopexecuteSqlDispatcher;
					this->executeSqlIntl = &Name::cloopexecuteSqlIntlDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopprepareDispatcher(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::prepare(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopcommitDispatcher(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::commit(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooprollbackDispatcher(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::rollback(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopstartSavepointDispatcher(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::startSavepoint(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopreleaseSavepointDispatcher(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::releaseSavepoint(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooprollbackSavepointDispatcher(IReplicatedTransaction* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::rollbackSavepoint(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopinsertRecordDispatcher(IReplicatedTransaction* self, IStatus* status, const char* name, IReplicatedRecord* record) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::insertRecord(&status2, name, record);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopupdateRecordDispatcher(IReplicatedTransaction* self, IStatus* status, const char* name, IReplicatedRecord* orgRecord, IReplicatedRecord* newRecord) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::updateRecord(&status2, name, orgRecord, newRecord);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdeleteRecordDispatcher(IReplicatedTransaction* self, IStatus* status, const char* name, IReplicatedRecord* record) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::deleteRecord(&status2, name, record);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopexecuteSqlDispatcher(IReplicatedTransaction* self, IStatus* status, const char* sql) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::executeSql(&status2, sql);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopexecuteSqlIntlDispatcher(IReplicatedTransaction* self, IStatus* status, unsigned charset, const char* sql) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::executeSqlIntl(&status2, charset, sql);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IReplicatedTransaction> > > > >
	class IReplicatedTransactionImpl : public IReplicatedTransactionBaseImpl<Name, StatusType, Base>
	{
	protected:
		IReplicatedTransactionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IReplicatedTransactionImpl()
		{
		}

		virtual void prepare(StatusType* status) = 0;
		virtual void commit(StatusType* status) = 0;
		virtual void rollback(StatusType* status) = 0;
		virtual void startSavepoint(StatusType* status) = 0;
		virtual void releaseSavepoint(StatusType* status) = 0;
		virtual void rollbackSavepoint(StatusType* status) = 0;
		virtual void insertRecord(StatusType* status, const char* name, IReplicatedRecord* record) = 0;
		virtual void updateRecord(StatusType* status, const char* name, IReplicatedRecord* orgRecord, IReplicatedRecord* newRecord) = 0;
		virtual void deleteRecord(StatusType* status, const char* name, IReplicatedRecord* record) = 0;
		virtual void executeSql(StatusType* status, const char* sql) = 0;
		virtual void executeSqlIntl(StatusType* status, unsigned charset, const char* sql) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IReplicatedSessionBaseImpl : public Base
	{
	public:
		typedef IReplicatedSession Declaration;

		IReplicatedSessionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->init = &Name::cloopinitDispatcher;
					this->startTransaction = &Name::cloopstartTransactionDispatcher;
					this->cleanupTransaction = &Name::cloopcleanupTransactionDispatcher;
					this->setSequence = &Name::cloopsetSequenceDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static FB_BOOLEAN CLOOP_CARG cloopinitDispatcher(IReplicatedSession* self, IStatus* status, IAttachment* attachment) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::init(&status2, attachment);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<FB_BOOLEAN>(0);
			}
		}

		static IReplicatedTransaction* CLOOP_CARG cloopstartTransactionDispatcher(IReplicatedSession* self, IStatus* status, ITransaction* transaction, ISC_INT64 number) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::startTransaction(&status2, transaction, number);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IReplicatedTransaction*>(0);
			}
		}

		static void CLOOP_CARG cloopcleanupTransactionDispatcher(IReplicatedSession* self, IStatus* status, ISC_INT64 number) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::cleanupTransaction(&status2, number);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetSequenceDispatcher(IReplicatedSession* self, IStatus* status, const char* name, ISC_INT64 value) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::setSequence(&status2, name, value);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IReplicatedSession> > > > > > >
	class IReplicatedSessionImpl : public IReplicatedSessionBaseImpl<Name, StatusType, Base>
	{
	protected:
		IReplicatedSessionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IReplicatedSessionImpl()
		{
		}

		virtual FB_BOOLEAN init(StatusType* status, IAttachment* attachment) = 0;
		virtual IReplicatedTransaction* startTransaction(StatusType* status, ITransaction* transaction, ISC_INT64 number) = 0;
		virtual void cleanupTransaction(StatusType* status, ISC_INT64 number) = 0;
		virtual void setSequence(StatusType* status, const char* name, ISC_INT64 value) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IProfilerPluginBaseImpl : public Base
	{
	public:
		typedef IProfilerPlugin Declaration;

		IProfilerPluginBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->addRef = &Name::cloopaddRefDispatcher;
					this->release = &Name::cloopreleaseDispatcher;
					this->setOwner = &Name::cloopsetOwnerDispatcher;
					this->getOwner = &Name::cloopgetOwnerDispatcher;
					this->init = &Name::cloopinitDispatcher;
					this->startSession = &Name::cloopstartSessionDispatcher;
					this->flush = &Name::cloopflushDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static void CLOOP_CARG cloopinitDispatcher(IProfilerPlugin* self, IStatus* status, IAttachment* attachment, ISC_UINT64 ticksFrequency) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::init(&status2, attachment, ticksFrequency);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static IProfilerSession* CLOOP_CARG cloopstartSessionDispatcher(IProfilerPlugin* self, IStatus* status, const char* description, const char* options, ISC_TIMESTAMP_TZ timestamp) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				return static_cast<Name*>(self)->Name::startSession(&status2, description, options, timestamp);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
				return static_cast<IProfilerSession*>(0);
			}
		}

		static void CLOOP_CARG cloopflushDispatcher(IProfilerPlugin* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::flush(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopsetOwnerDispatcher(IPluginBase* self, IReferenceCounted* r) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::setOwner(r);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static IReferenceCounted* CLOOP_CARG cloopgetOwnerDispatcher(IPluginBase* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getOwner();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<IReferenceCounted*>(0);
			}
		}

		static void CLOOP_CARG cloopaddRefDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::addRef();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static int CLOOP_CARG cloopreleaseDispatcher(IReferenceCounted* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::release();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<int>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IPluginBaseImpl<Name, StatusType, Inherit<IReferenceCountedImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IProfilerPlugin> > > > > > >
	class IProfilerPluginImpl : public IProfilerPluginBaseImpl<Name, StatusType, Base>
	{
	protected:
		IProfilerPluginImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IProfilerPluginImpl()
		{
		}

		virtual void init(StatusType* status, IAttachment* attachment, ISC_UINT64 ticksFrequency) = 0;
		virtual IProfilerSession* startSession(StatusType* status, const char* description, const char* options, ISC_TIMESTAMP_TZ timestamp) = 0;
		virtual void flush(StatusType* status) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IProfilerSessionBaseImpl : public Base
	{
	public:
		typedef IProfilerSession Declaration;

		IProfilerSessionBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->dispose = &Name::cloopdisposeDispatcher;
					this->getId = &Name::cloopgetIdDispatcher;
					this->getFlags = &Name::cloopgetFlagsDispatcher;
					this->cancel = &Name::cloopcancelDispatcher;
					this->finish = &Name::cloopfinishDispatcher;
					this->defineStatement = &Name::cloopdefineStatementDispatcher;
					this->defineCursor = &Name::cloopdefineCursorDispatcher;
					this->defineRecordSource = &Name::cloopdefineRecordSourceDispatcher;
					this->onRequestStart = &Name::clooponRequestStartDispatcher;
					this->onRequestFinish = &Name::clooponRequestFinishDispatcher;
					this->beforePsqlLineColumn = &Name::cloopbeforePsqlLineColumnDispatcher;
					this->afterPsqlLineColumn = &Name::cloopafterPsqlLineColumnDispatcher;
					this->beforeRecordSourceOpen = &Name::cloopbeforeRecordSourceOpenDispatcher;
					this->afterRecordSourceOpen = &Name::cloopafterRecordSourceOpenDispatcher;
					this->beforeRecordSourceGetRecord = &Name::cloopbeforeRecordSourceGetRecordDispatcher;
					this->afterRecordSourceGetRecord = &Name::cloopafterRecordSourceGetRecordDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static ISC_INT64 CLOOP_CARG cloopgetIdDispatcher(IProfilerSession* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getId();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_INT64>(0);
			}
		}

		static unsigned CLOOP_CARG cloopgetFlagsDispatcher(IProfilerSession* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getFlags();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<unsigned>(0);
			}
		}

		static void CLOOP_CARG cloopcancelDispatcher(IProfilerSession* self, IStatus* status) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::cancel(&status2);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopfinishDispatcher(IProfilerSession* self, IStatus* status, ISC_TIMESTAMP_TZ timestamp) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::finish(&status2, timestamp);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdefineStatementDispatcher(IProfilerSession* self, IStatus* status, ISC_INT64 statementId, ISC_INT64 parentStatementId, const char* type, const char* packageName, const char* routineName, const char* sqlText) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::defineStatement(&status2, statementId, parentStatementId, type, packageName, routineName, sqlText);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopdefineCursorDispatcher(IProfilerSession* self, ISC_INT64 statementId, unsigned cursorId, const char* name, unsigned line, unsigned column) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::defineCursor(statementId, cursorId, name, line, column);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopdefineRecordSourceDispatcher(IProfilerSession* self, ISC_INT64 statementId, unsigned cursorId, unsigned recSourceId, unsigned level, const char* accessPath, unsigned parentRecSourceId) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::defineRecordSource(statementId, cursorId, recSourceId, level, accessPath, parentRecSourceId);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG clooponRequestStartDispatcher(IProfilerSession* self, IStatus* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_INT64 callerStatementId, ISC_INT64 callerRequestId, ISC_TIMESTAMP_TZ timestamp) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::onRequestStart(&status2, statementId, requestId, callerStatementId, callerRequestId, timestamp);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG clooponRequestFinishDispatcher(IProfilerSession* self, IStatus* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_TIMESTAMP_TZ timestamp, IProfilerStats* stats) CLOOP_NOEXCEPT
		{
			StatusType status2(status);

			try
			{
				static_cast<Name*>(self)->Name::onRequestFinish(&status2, statementId, requestId, timestamp, stats);
			}
			catch (...)
			{
				StatusType::catchException(&status2);
			}
		}

		static void CLOOP_CARG cloopbeforePsqlLineColumnDispatcher(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::beforePsqlLineColumn(statementId, requestId, line, column);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopafterPsqlLineColumnDispatcher(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column, IProfilerStats* stats) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::afterPsqlLineColumn(statementId, requestId, line, column, stats);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopbeforeRecordSourceOpenDispatcher(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::beforeRecordSourceOpen(statementId, requestId, cursorId, recSourceId);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopafterRecordSourceOpenDispatcher(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, IProfilerStats* stats) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::afterRecordSourceOpen(statementId, requestId, cursorId, recSourceId, stats);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopbeforeRecordSourceGetRecordDispatcher(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::beforeRecordSourceGetRecord(statementId, requestId, cursorId, recSourceId);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopafterRecordSourceGetRecordDispatcher(IProfilerSession* self, ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, IProfilerStats* stats) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::afterRecordSourceGetRecord(statementId, requestId, cursorId, recSourceId, stats);
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}

		static void CLOOP_CARG cloopdisposeDispatcher(IDisposable* self) CLOOP_NOEXCEPT
		{
			try
			{
				static_cast<Name*>(self)->Name::dispose();
			}
			catch (...)
			{
				StatusType::catchException(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IDisposableImpl<Name, StatusType, Inherit<IVersionedImpl<Name, StatusType, Inherit<IProfilerSession> > > > >
	class IProfilerSessionImpl : public IProfilerSessionBaseImpl<Name, StatusType, Base>
	{
	protected:
		IProfilerSessionImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IProfilerSessionImpl()
		{
		}

		virtual ISC_INT64 getId() = 0;
		virtual unsigned getFlags() = 0;
		virtual void cancel(StatusType* status) = 0;
		virtual void finish(StatusType* status, ISC_TIMESTAMP_TZ timestamp) = 0;
		virtual void defineStatement(StatusType* status, ISC_INT64 statementId, ISC_INT64 parentStatementId, const char* type, const char* packageName, const char* routineName, const char* sqlText) = 0;
		virtual void defineCursor(ISC_INT64 statementId, unsigned cursorId, const char* name, unsigned line, unsigned column) = 0;
		virtual void defineRecordSource(ISC_INT64 statementId, unsigned cursorId, unsigned recSourceId, unsigned level, const char* accessPath, unsigned parentRecSourceId) = 0;
		virtual void onRequestStart(StatusType* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_INT64 callerStatementId, ISC_INT64 callerRequestId, ISC_TIMESTAMP_TZ timestamp) = 0;
		virtual void onRequestFinish(StatusType* status, ISC_INT64 statementId, ISC_INT64 requestId, ISC_TIMESTAMP_TZ timestamp, IProfilerStats* stats) = 0;
		virtual void beforePsqlLineColumn(ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column) = 0;
		virtual void afterPsqlLineColumn(ISC_INT64 statementId, ISC_INT64 requestId, unsigned line, unsigned column, IProfilerStats* stats) = 0;
		virtual void beforeRecordSourceOpen(ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId) = 0;
		virtual void afterRecordSourceOpen(ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, IProfilerStats* stats) = 0;
		virtual void beforeRecordSourceGetRecord(ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId) = 0;
		virtual void afterRecordSourceGetRecord(ISC_INT64 statementId, ISC_INT64 requestId, unsigned cursorId, unsigned recSourceId, IProfilerStats* stats) = 0;
	};

	template <typename Name, typename StatusType, typename Base>
	class IProfilerStatsBaseImpl : public Base
	{
	public:
		typedef IProfilerStats Declaration;

		IProfilerStatsBaseImpl(DoNotInherit = DoNotInherit())
		{
			static struct VTableImpl : Base::VTable
			{
				VTableImpl()
				{
					this->version = Base::VERSION;
					this->getElapsedTicks = &Name::cloopgetElapsedTicksDispatcher;
				}
			} vTable;

			this->cloopVTable = &vTable;
		}

		static ISC_UINT64 CLOOP_CARG cloopgetElapsedTicksDispatcher(IProfilerStats* self) CLOOP_NOEXCEPT
		{
			try
			{
				return static_cast<Name*>(self)->Name::getElapsedTicks();
			}
			catch (...)
			{
				StatusType::catchException(0);
				return static_cast<ISC_UINT64>(0);
			}
		}
	};

	template <typename Name, typename StatusType, typename Base = IVersionedImpl<Name, StatusType, Inherit<IProfilerStats> > >
	class IProfilerStatsImpl : public IProfilerStatsBaseImpl<Name, StatusType, Base>
	{
	protected:
		IProfilerStatsImpl(DoNotInherit = DoNotInherit())
		{
		}

	public:
		virtual ~IProfilerStatsImpl()
		{
		}

		virtual ISC_UINT64 getElapsedTicks() = 0;
	};
};


#endif	// IDL_FB_INTERFACES_H
