/**
 * FreeRDP: A Remote Desktop Protocol Implementation
 * SDL Client
 *
 * Copyright 2023 Armin Novak <armin.novak@thincast.com>
 * Copyright 2023 Thincast Technologies GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#pragma once

#include <string>
#include <SDL.h>

class SdlWindow
{
  public:
	SdlWindow(const std::string& title, Sint32 startupX, Sint32 startupY, Sint32 width,
	          Sint32 height, Uint32 flags);
	SdlWindow(SdlWindow&& other);
	~SdlWindow();

	SDL_Window* window() const;

	Sint32 offsetX() const;
	void setOffsetX(Sint32 x);

	void setOffsetY(Sint32 y);
	Sint32 offsetY() const;

  private:
	SDL_Window* _window;
	Sint32 _offset_x;
	Sint32 _offset_y;

  private:
	SdlWindow(const SdlWindow& other) = delete;
};
