-------------------------------------------------------------------------------
-- Title      : Full-Adder
-- Project    :
-------------------------------------------------------------------------------
--! \file     full_adder.vhd
--! \author   Jose Correcher <jose.correcher@gmail.com>
--! \date     Created    : 2021-07-02
--            Last update: 2021-07-02
-- Platform   :
-- Standard   : VHDL'08
-------------------------------------------------------------------------------
-- Description:
--! \class    full_adder
--! \details
--!            This core contains a full-adder design.
-------------------------------------------------------------------------------
-- Copyright (c) 2021
-------------------------------------------------------------------------------
-- Revisions  :
-- Date        Version  Author  Description
-- 2021-07-02  1.0      jcorrecher	Created
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- * libraries
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

-------------------------------------------------------------------------------
-- * entity
-------------------------------------------------------------------------------

entity full_adder is

  port (
    a    : in  std_logic;
    b    : in  std_logic;
    cin  : in  std_logic;
    s    : out std_logic;
    cout : out std_logic);

end entity full_adder;

-------------------------------------------------------------------------------
-- * architecture body
-------------------------------------------------------------------------------

architecture rtl of full_adder is

begin

-------------------------------------------------------------------------------
-- * result
-------------------------------------------------------------------------------

  res_assign: s <= (a xor b) xor cin;

-------------------------------------------------------------------------------
-- * carry out
-------------------------------------------------------------------------------

  cout_assign: cout <= ((a xor b) and cin) or (a and b);

end architecture rtl;
