/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpgradient_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpgradient
 * @title: gimpgradient
 * @short_description: Installable object used by the gradient rendering tool.
 *
 * Installable object used by the gradient rendering tool.
 **/


/**
 * gimp_gradient_new:
 * @name: The requested name of the new gradient.
 *
 * Creates a new gradient
 *
 * Creates a new gradient having no segments.
 *
 * Returns: (transfer none): The gradient.
 *
 * Since: 2.2
 **/
GimpGradient *
gimp_gradient_new (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpGradient *gradient = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-new",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    gradient = GIMP_VALUES_GET_GRADIENT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return gradient;
}

/**
 * gimp_gradient_get_by_name:
 * @name: The name of the gradient.
 *
 * Returns the gradient with the given name.
 *
 * Returns the gradient with the given name.
 *
 * Returns: (transfer none): The gradient.
 *
 * Since: 3.0
 **/
GimpGradient *
gimp_gradient_get_by_name (const gchar *name)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpGradient *gradient = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-get-by-name",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    gradient = GIMP_VALUES_GET_GRADIENT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return gradient;
}

/**
 * gimp_gradient_get_number_of_segments:
 * @gradient: The gradient.
 *
 * Gets the number of segments of the gradient
 *
 * Gets the number of segments of the gradient
 *
 * Returns: Number of segments.
 *
 * Since: 2.6
 **/
gint
gimp_gradient_get_number_of_segments (GimpGradient *gradient)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gint num_segments = 0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-get-number-of-segments",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    num_segments = GIMP_VALUES_GET_INT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return num_segments;
}

/**
 * gimp_gradient_get_uniform_samples:
 * @gradient: The gradient.
 * @num_samples: The number of samples to take.
 * @reverse: Use the reverse gradient.
 * @num_color_samples: (out): Length of the color_samples array (4 * num_samples).
 * @color_samples: (out) (array length=num_color_samples) (element-type gdouble) (transfer full): Color samples: { R1, G1, B1, A1, ..., Rn, Gn, Bn, An }.
 *
 * Sample the gradient in uniform parts.
 *
 * Samples colors uniformly across the gradient. It returns a list of
 * floating-point values which correspond to the RGBA values for each
 * sample. The minimum number of samples to take is 2, in which case
 * the returned colors will correspond to the { 0.0, 1.0 } positions in
 * the gradient. For example, if the number of samples is 3, the
 * procedure will return the colors at positions { 0.0, 0.5, 1.0 }.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_get_uniform_samples (GimpGradient  *gradient,
                                   gint           num_samples,
                                   gboolean       reverse,
                                   gint          *num_color_samples,
                                   gdouble      **color_samples)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, num_samples,
                                          G_TYPE_BOOLEAN, reverse,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-get-uniform-samples",
                                               args);
  gimp_value_array_unref (args);

  *num_color_samples = 0;
  *color_samples = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_color_samples = GIMP_VALUES_GET_INT (return_vals, 1);
      *color_samples = GIMP_VALUES_DUP_FLOAT_ARRAY (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_get_custom_samples:
 * @gradient: The gradient.
 * @num_samples: The number of samples to take.
 * @positions: (array length=num_samples) (element-type gdouble): The list of positions to sample along the gradient.
 * @reverse: Use the reverse gradient.
 * @num_color_samples: (out): Length of the color_samples array (4 * num_samples).
 * @color_samples: (out) (array length=num_color_samples) (element-type gdouble) (transfer full): Color samples: { R1, G1, B1, A1, ..., Rn, Gn, Bn, An }.
 *
 * Sample the gradient in custom positions.
 *
 * Samples the color of the gradient at positions from a list. The left
 * endpoint of the gradient corresponds to position 0.0, and the right
 * endpoint corresponds to 1.0. Returns a list of floating-point
 * values, four for each sample (RGBA.)
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_get_custom_samples (GimpGradient   *gradient,
                                  gint            num_samples,
                                  const gdouble  *positions,
                                  gboolean        reverse,
                                  gint           *num_color_samples,
                                  gdouble       **color_samples)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, num_samples,
                                          GIMP_TYPE_FLOAT_ARRAY, NULL,
                                          G_TYPE_BOOLEAN, reverse,
                                          G_TYPE_NONE);
  gimp_value_set_float_array (gimp_value_array_index (args, 2), positions, num_samples);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-get-custom-samples",
                                               args);
  gimp_value_array_unref (args);

  *num_color_samples = 0;
  *color_samples = NULL;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    {
      *num_color_samples = GIMP_VALUES_GET_INT (return_vals, 1);
      *color_samples = GIMP_VALUES_DUP_FLOAT_ARRAY (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_left_color:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 *
 * Gets the left endpoint color of the segment
 *
 * Gets the left endpoint color of the indexed segment of the gradient.
 * Returns an error when the segment index is out of range.
 *
 * Returns: (transfer full): The return color.
 *
 * Since: 2.2
 **/
GeglColor *
gimp_gradient_segment_get_left_color (GimpGradient *gradient,
                                      gint          segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GeglColor *color = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-get-left-color",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    color = g_value_dup_object (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return color;
}

/**
 * gimp_gradient_segment_set_left_color:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @color: The color to set.
 *
 * Sets the left endpoint color of a segment
 *
 * Sets the color of the left endpoint the indexed segment of the
 * gradient. The alpha channel of the [class@Gegl.Color] is taken into
 * account.
 * Returns an error when gradient is not editable or index is out of
 * range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_left_color (GimpGradient *gradient,
                                      gint          segment,
                                      GeglColor    *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          GEGL_TYPE_COLOR, color,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-set-left-color",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_right_color:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 *
 * Gets the right endpoint color of the segment
 *
 * Gets the color of the right endpoint color of the segment of the
 * gradient.
 * Returns an error when the segment index is out of range.
 *
 * Returns: (transfer full): The return color.
 *
 * Since: 2.2
 **/
GeglColor *
gimp_gradient_segment_get_right_color (GimpGradient *gradient,
                                       gint          segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GeglColor *color = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-get-right-color",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    color = g_value_dup_object (gimp_value_array_index (return_vals, 1));

  gimp_value_array_unref (return_vals);

  return color;
}

/**
 * gimp_gradient_segment_set_right_color:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @color: The color to set.
 *
 * Sets the right endpoint color of the segment
 *
 * Sets the right endpoint color of the segment of the gradient. The
 * alpha channel of the [class@Gegl.Color] is taken into account.
 * Returns an error when gradient is not editable or segment index is
 * out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_right_color (GimpGradient *gradient,
                                       gint          segment,
                                       GeglColor    *color)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          GEGL_TYPE_COLOR, color,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-set-right-color",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_left_pos:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @pos: (out): The return position.
 *
 * Gets the left endpoint position of a segment
 *
 * Gets the position of the left endpoint of the segment of the
 * gradient.
 * Returns an error when the segment index is out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_left_pos (GimpGradient *gradient,
                                    gint          segment,
                                    gdouble      *pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-get-left-pos",
                                               args);
  gimp_value_array_unref (args);

  *pos = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *pos = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_set_left_pos:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @pos: The position to set the guidepoint to.
 * @final_pos: (out): The return position.
 *
 * Sets the left endpoint position of the segment
 *
 * Sets the position of the left endpoint of the segment of the
 * gradient. The final position will be the given fraction from the
 * midpoint to the left to the midpoint of the current segment.
 * Returns the final position. Returns an error when gradient is not
 * editable or segment index is out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_left_pos (GimpGradient *gradient,
                                    gint          segment,
                                    gdouble       pos,
                                    gdouble      *final_pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_DOUBLE, pos,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-set-left-pos",
                                               args);
  gimp_value_array_unref (args);

  *final_pos = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *final_pos = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_middle_pos:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @pos: (out): The return position.
 *
 * Gets the midpoint position of the segment
 *
 * Gets the position of the midpoint of the segment of the gradient.
 * Returns an error when the segment index is out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_middle_pos (GimpGradient *gradient,
                                      gint          segment,
                                      gdouble      *pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-get-middle-pos",
                                               args);
  gimp_value_array_unref (args);

  *pos = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *pos = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_set_middle_pos:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @pos: The position to set the guidepoint to.
 * @final_pos: (out): The return position.
 *
 * Sets the midpoint position of the segment
 *
 * Sets the midpoint position of the segment of the gradient. The final
 * position will be the given fraction between the two endpoints of the
 * segment.
 * Returns the final position. Returns an error when gradient is not
 * editable or segment index is out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_middle_pos (GimpGradient *gradient,
                                      gint          segment,
                                      gdouble       pos,
                                      gdouble      *final_pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_DOUBLE, pos,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-set-middle-pos",
                                               args);
  gimp_value_array_unref (args);

  *final_pos = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *final_pos = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_right_pos:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @pos: (out): The return position.
 *
 * Gets the right endpoint position of the segment
 *
 * Gets the position of the right endpoint of the segment of the
 * gradient.
 * Returns an error when the segment index is out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_right_pos (GimpGradient *gradient,
                                     gint          segment,
                                     gdouble      *pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-get-right-pos",
                                               args);
  gimp_value_array_unref (args);

  *pos = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *pos = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_set_right_pos:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @pos: The position to set the right endpoint to.
 * @final_pos: (out): The return position.
 *
 * Sets the right endpoint position of the segment
 *
 * Sets the right endpoint position of the segment of the gradient. The
 * final position will be the given fraction from the midpoint of the
 * current segment to the midpoint of the segment to the right.
 * Returns the final position. Returns an error when gradient is not
 * editable or segment index is out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_set_right_pos (GimpGradient *gradient,
                                     gint          segment,
                                     gdouble       pos,
                                     gdouble      *final_pos)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_DOUBLE, pos,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-set-right-pos",
                                               args);
  gimp_value_array_unref (args);

  *final_pos = 0.0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *final_pos = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_blending_function:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @blend_func: (out): The blending function of the segment.
 *
 * Gets the gradient segment's blending function
 *
 * Gets the blending function of the segment at the index.
 * Returns an error when the segment index is out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_blending_function (GimpGradient            *gradient,
                                             gint                     segment,
                                             GimpGradientSegmentType *blend_func)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-get-blending-function",
                                               args);
  gimp_value_array_unref (args);

  *blend_func = 0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *blend_func = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_get_coloring_type:
 * @gradient: The gradient.
 * @segment: The index of a segment within the gradient.
 * @coloring_type: (out): The coloring type of the segment.
 *
 * Gets the gradient segment's coloring type
 *
 * Gets the coloring type of the segment at the index.
 * Returns an error when the segment index is out of range.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_get_coloring_type (GimpGradient             *gradient,
                                         gint                      segment,
                                         GimpGradientSegmentColor *coloring_type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-get-coloring-type",
                                               args);
  gimp_value_array_unref (args);

  *coloring_type = 0;

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  if (success)
    *coloring_type = GIMP_VALUES_GET_ENUM (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_set_blending_function:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 * @blending_function: The blending function.
 *
 * Sets the blending function of a range of segments
 *
 * Sets the blending function of a range of segments.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_set_blending_function (GimpGradient            *gradient,
                                                   gint                     start_segment,
                                                   gint                     end_segment,
                                                   GimpGradientSegmentType  blending_function)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          GIMP_TYPE_GRADIENT_SEGMENT_TYPE, blending_function,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-set-blending-function",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_set_coloring_type:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 * @coloring_type: The coloring type.
 *
 * Sets the coloring type of a range of segments
 *
 * Sets the coloring type of a range of segments.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_set_coloring_type (GimpGradient             *gradient,
                                               gint                      start_segment,
                                               gint                      end_segment,
                                               GimpGradientSegmentColor  coloring_type)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          GIMP_TYPE_GRADIENT_SEGMENT_COLOR, coloring_type,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-set-coloring-type",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_flip:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 *
 * Flip the segment range
 *
 * Reverses the order of segments in a range, and swaps the left and
 * right colors in each segment. As if the range as a 1D line were
 * rotated in a plane.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_flip (GimpGradient *gradient,
                                  gint          start_segment,
                                  gint          end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-flip",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_replicate:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 * @replicate_times: The number of replicas for each segment.
 *
 * Replicate the segment range
 *
 * Replicates a segment range a given number of times. Instead of the
 * original segment range, several smaller scaled copies of it will
 * appear in equal widths.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_replicate (GimpGradient *gradient,
                                       gint          start_segment,
                                       gint          end_segment,
                                       gint          replicate_times)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_INT, replicate_times,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-replicate",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_split_midpoint:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 *
 * Splits each segment in the segment range at midpoint
 *
 * Splits each segment in the segment range at its midpoint.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_split_midpoint (GimpGradient *gradient,
                                            gint          start_segment,
                                            gint          end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-split-midpoint",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_split_uniform:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 * @split_parts: The number of uniform divisions to split each segment to.
 *
 * Splits each segment in the segment range uniformly
 *
 * Splits each segment in the segment range uniformly into to the
 * number of parts given.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_split_uniform (GimpGradient *gradient,
                                           gint          start_segment,
                                           gint          end_segment,
                                           gint          split_parts)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_INT, split_parts,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-split-uniform",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_delete:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 *
 * Delete the segment range
 *
 * Deletes a range of segments.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable. Deleting all the segments is undefined behavior.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_delete (GimpGradient *gradient,
                                    gint          start_segment,
                                    gint          end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-delete",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_redistribute_handles:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 *
 * Uniformly redistribute the segment range's handles
 *
 * Redistributes the handles of the segment range of the gradient, so
 * they'll be evenly spaced. A handle is where two segments meet.
 * Segments will then have the same width.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_redistribute_handles (GimpGradient *gradient,
                                                  gint          start_segment,
                                                  gint          end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-redistribute-handles",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_blend_colors:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 *
 * Blend the colors of the segment range.
 *
 * Blends the colors (but not the opacity) of the range of segments.
 * The colors' transition will then be uniform across the range.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_blend_colors (GimpGradient *gradient,
                                          gint          start_segment,
                                          gint          end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-blend-colors",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_blend_opacity:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 *
 * Blend the opacity of the segment range.
 *
 * Blends the opacity (but not the colors) of the range of segments.
 * The opacity's transition will then be uniform across the range.
 * Returns an error when a segment index is out of range, or gradient
 * is not editable.
 *
 * Returns: TRUE on success.
 *
 * Since: 2.2
 **/
gboolean
gimp_gradient_segment_range_blend_opacity (GimpGradient *gradient,
                                           gint          start_segment,
                                           gint          end_segment)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-blend-opacity",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_gradient_segment_range_move:
 * @gradient: The gradient.
 * @start_segment: Index of the first segment to operate on.
 * @end_segment: Index of the last segment to operate on. If negative, the range will extend to the end segment.
 * @delta: The delta to move the segment range.
 * @control_compress: Whether or not to compress the neighboring segments.
 *
 * Move the position of an entire segment range by a delta.
 *
 * Moves the position of an entire segment range by a delta. The actual
 * delta (which is returned) will be limited by the control points of
 * the neighboring segments.
 * Returns the actual delta. Returns an error when a segment index is
 * out of range, or gradient is not editable.
 *
 * Returns: The final delta by which the range moved.
 *
 * Since: 2.2
 **/
gdouble
gimp_gradient_segment_range_move (GimpGradient *gradient,
                                  gint          start_segment,
                                  gint          end_segment,
                                  gdouble       delta,
                                  gboolean      control_compress)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gdouble final_delta = 0.0;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_GRADIENT, gradient,
                                          G_TYPE_INT, start_segment,
                                          G_TYPE_INT, end_segment,
                                          G_TYPE_DOUBLE, delta,
                                          G_TYPE_BOOLEAN, control_compress,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-gradient-segment-range-move",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    final_delta = GIMP_VALUES_GET_DOUBLE (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return final_delta;
}
