---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab incident list`

List project incidents.

```plaintext
glab incident list [flags]
```

## Aliases

```plaintext
ls
```

## Examples

```console
$ glab incident list --all
$ glab incident ls --all
$ glab incident list --assignee=@me
$ glab incident list --milestone release-2.0.0 --opened

```

## Options

```plaintext
  -A, --all                    Get all incidents.
  -a, --assignee string        Filter incident by assignee <username>.
      --author string          Filter incident by author <username>.
  -c, --closed                 Get only closed incidents.
  -C, --confidential           Filter by confidential incidents.
  -e, --epic int               List issues belonging to a given epic (requires --group, no pagination support).
  -g, --group string           Select a group or subgroup. Ignored if a repo argument is set.
      --in string              search in: title, description. (default "title,description")
  -l, --label strings          Filter incident by label <name>.
  -m, --milestone string       Filter incident by milestone <id>.
      --not-assignee string    Filter incident by not being assigned to <username>.
      --not-author string      Filter incident by not being by author(s) <username>.
      --not-label strings      Filter incident by lack of label <name>.
  -O, --output string          Options: 'text' or 'json'. (default "text")
  -F, --output-format string   Options: 'details', 'ids', 'urls'. (default "details")
  -p, --page int               Page number. (default 1)
  -P, --per-page int           Number of items to list per page. (default 30)
  -R, --repo OWNER/REPO        Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
      --search string          Search <string> in the fields defined by '--in'.
```

## Options inherited from parent commands

```plaintext
  -h, --help   Show help for this command.
```
