# News - 14 series

(release-14-0-0)=
## Release 14.0.0 - 2024-02-29

This is a major version up!
But It keeps backward compatibility. We can upgrade to 14.0.0 without rebuilding database.

### Improvements

* Added a new tokenizer `TokenH3Index` (experimental).

  `TokenH3Index`tokenizes WGS84GetPoint to UInt64(H3 index).

* Added support for offline and online index construction with non text based tokenizer (experimental).

  `TokenH3Index` is one of non text based tokenizers.

* [{doc}`/reference/commands/select`] Added support for searching by index with non text based tokenizer (experimental).

  `TokenH3Index` is one of non text based tokenizers.

* Added new functions `distance_cosine()`, `distance_inner_product()`, `distance_l2_norm_squared()`, `distance_l1_norm()`.

  We can only get records that a small distance as vector with these functions and `limit N`

  These functions calculate distance in the `output` stage.

  However, we don't optimaize these functions yet.

  * `distance_cosine()`: Calculate cosine similarity.
  * `distance_inner_product()`: Calculate inner product.
  * `distance_l2_norm_squared()`: Calculate euclidean distance.
  * `distance_l1_norm()`: Calculate manhattan distance.

* Added a new function `number_round()`.

* [{doc}`/reference/commands/load`] Added support for parallel `load`.

  This feature only enable when the `input_type` of `load` is `apache-arrow`.

  This feature one thread per column. If there are many target columns, it will reduce load time.

* [{doc}`/reference/commands/select`] We can use uvector as much as possible for array literal in `--filter`.

  uvector is vector of elements with fix size.

  If all elements have the same type, we use uvector instead vector.

* [{doc}`/reference/commands/status`] Added `n_workers` to output of `status`.

* Optimized a dynamic column creation.

* [WAL] Added support for rebuilding broken indexes in parallel.

* [{doc}`/reference/commands/select`] Added support for `Int64` in `output_type=apache-arrow` for columns that reference other table.

### Fixes

* [Windows] Fixed path for documents of `groonga-normalizer-mysql` in package for Windows.

  Documents of `groonga-normalizer-mysql` put under the `share/` in this release.

* [{doc}`/reference/commands/select`] Fixed a bug that Groonga may crash when we use bitwise operations.
