ITK Release 4.7
===============

New Features

------------------------------------------------------------------------

-   Documentation Improvements

` - Update Software Guide registration examples to ITKv4 framework`\
` - Wiki and Sphinx examples are indexed in Doxygen`\
` - Clean Software Guide dashboard build`

-   Filtering Improvements

` - New Laplacian deformation filter’s for QuadEdgeMesh’s`\
`   - IJ article: `[`https://hdl.handle.net/10380/3410`](https://hdl.handle.net/10380/3410)\
`- FFTComplexToComplexImageFilter out of Review, Vnl, FFTW implementations`\
`- Faster recursive Gaussian on VectorImage`

-   ImageIO improvements

` - PNG sCAL unit support`\
` - TIFF IO performance greatly improved`\
` - TIFF tags read into Image MetaDataDictionary`\
` - MetaIO updated`\
` - Better support for system GDCM `

-   Infrastructure improvements

` - New method to erase a MetaDataDictionary entry`\
` - New global method to set physical space tolerance`\
` - New, experimental thread pool support`\
` - NumericTraits::Zero and ::One are deprecated in favor of ::ZeroValue() and ::OneValue()`\
` - VTK bridge modules only request required VTK modules`

-   New Remote Modules

` - Higher Order Accurate Gradient`\
`   - `[`https://hdl.handle.net/10380/3231`](https://hdl.handle.net/10380/3231)\
` - IO Transform DCMTK`\
`   - `[`https://hdl.handle.net/10380/3468`](https://hdl.handle.net/10380/3468)\
` - Subdivision Quad Edge Mesh Filters`\
`   - `[`https://hdl.handle.net/10380/3307`](https://hdl.handle.net/10380/3307)

-   Registration improvements

` - LandmarkBasedTransformInitializer supports BSplineTransform`\
` - Transverse inverse consistency increased`\
` - Automatic initialization of the transform center for multi-stage registrations`\
` - Sparse point B-spline field estimate`\
` - Mutual information faster, lower memory usage `

-   Wrapping improvements

` - Wrapping now builds without type warnings`\
` - pygccxml bumped to 1.6.2`\
` - Latest GCCXML`\
` - CMake wrapping infrastructure cleanup`\
` - Build with Ninja CMake generator`\
` - New GetTypes() and GetTypesAsList() methods`\
` - ITK_WRAP_PYTHON is exposed in ITKConfig.cmake`\
` `

-   Many style improvements -- ITK gets more stylish with every release!

<!-- -->

-   Improved code coverage -- we are over 85%!

<!-- -->

-   -   Lots\* of important bug fixes

List of changes since v4.7-rc02

------------------------------------------------------------------------

Bradley Lowekamp (1):

`     BUG: IOFDF remote module should stay with InsightConsortium repo`

Christopher Mullins (3):

`     DOC: Fix code overlapping figure`\
`     STYLE: Keep the text in the margins`\
`     STYLE: Put newline before long doxygen reference`

Cory Quammen (1):

`     BUG: Fix segfaults in ITKExamples`

Matthew McCormick (8):

`     BUG: Reset ITK_MODULES_REQUESTED to all modules with multiple calls.`\
`     BUG: Configure against VTK 5.`\
`     COMP: Add ITK_SOURCE_DIR to doxygen EXAMPLE_PATH.`\
`     COMP: Increase DOT_GRAPH_MAX_NODES.`\
`     DOC: Add Doxygen macros for itkSetGetDecoratedObjectMacro.`\
`     ENH: Warning when reading a PNG with UNKNOWN unit and non-unit spacing.`\
`     BUG: Fix VTK5 module export code.`\
`     BUG: Fix LevelSetsv4Visualization VTK variable names.`

Michka Popoff (1):

`     DOC: Improvements for Book1, Chap4`

List of changes since v4.7-rc01

------------------------------------------------------------------------

Ali Ghayoor (1):

`     DOC: Revise the registration examples of ITKSoftwareGuide`

Arnaud Gelas (3):

`     ENH: Adding SubdivisionQuadEdgeMeshFilters to ITK as remote module`\
`     COMP: address clang -Winconsistent-missing-override in ITKQuadEdgeMesh`\
`     COMP: fix warnings on dashboard for Subdivision remote module`

Bradley Lowekamp (5):

`     BUG: Fix segfault when setting displacement field as null`\
`     BUG: Don't enable SSE rounding with OSX and gccxml`\
`     BUG: Add portable access to Tiff field name`\
`     BUG: Fix conversion compilation error`\
`     BUG: Rename remote module FDFImageIO -> IOFDF`

Christopher Mullins (6):

`     STYLE: Fix line length in OpenJPEG license for 80 character.`\
`     DOC: Finish the ImageLinearIteratorWithIndex example.`\
`     DOC: Text and picture problems, book2`\
`     BUG: Fix text in margin issues`\
`     DOC: Edits for the beginning of chapter 5, Statistics`\
`     DOC: Fix empty code block.`

Cory Quammen (1):

`     COMP: Avoid including VTK_USE_FILE within ITK`

Kent Williams (1):

`     ENH: Add test to exercise issue with Transform::GetInverse`

Matthew McCormick (7):

`     BUG: Register AzimuthElevationToCartesianTransform to factories.`\
`     DOC: Update texture feature class references.`\
`     BUG: Fix texture feature correlation computation for constant image.`\
`     STYLE: Put ImageToImageFilterCommon in its own file.`\
`     BUG: Wrap ImageToImageFilterCommon.`\
`     STYLE: Put ImageSourceCommon in its own file.`\
`     COMP: Add missing itkImageRegionSplitterBase to ImageSourceCommon.`

Michka Popoff (1):

`     ENH: Add CVD and CVF types to VectorIndexSelectionCastImageFilter wrappings`

Ziv Yaniv (1):

`     COMP: fixed warnings from gcc4.1.2, made implicit casts explicit`

List of changes since v4.6.0

------------------------------------------------------------------------

Alexander Schmidt-Richberg (1):

`     ENH: Updated Remote Module VariationalRegistration to new git tag`

Ali Ghayoor (10):

`     ENH: Make ITKv4 compatible with ITKSoftwareGuide`\
`     ENH: Add GetCurrentStepLength to RegularStepGradDescentOptv4`\
`     ENH: Convert three ImageRegistration Examples to ITKv4`\
`     ENH: Add multi-Res and multistage registration Examples to ITKv4`\
`     ENH: Convert DeformableReg examples to ITKv4 reg framework`\
`     BUG: Expand a test to reflect multi-metric registration bug`\
`     BUG: Fix multi metric point sampling bug in ImageRegistrationMethodv4`\
`     ENH: Add direct initialization to SyN registration`\
`     ENH: Direct initialization of SyN by restoring the state`\
`     ENH: LandmarkBasedTransformInitializer supports BSplineTransformType`

Arnaud Gelas (15):

`     COMP: use find_package(VTK COMPONENTS) for LevelSetsv4Visualization`\
`     ENH: Importing Laplacian Deformation for QuadEdgeMesh`\
`     DOC: Add more explanation about SmoothingQuadEdgeMeshFilter's usage`\
`     ENH: SmoothingQuadEdgeMeshFilter::SetCoefficientMethod calls Modified()`\
`     ENH: Add progress report in itk::SmoothingQuadEdgeMeshFilter`\
`     BUG: fix gdcm version in GDCMImageIO.`\
`     COMP: missing cast when calling gdcm::DataElement::SetByteValue`\
`     COMP: missing cast when calling gdcm::DataElement::SetByteValue`\
`     ENH: increase LaplacianDeformation code coverage`\
`     STYLE: use typedef rather than inheritance`\
`     BUG: GDCMImageIO was not working properly when m_KeepOriginalUID is false`\
`     BUG: split include directories into appropriate cmake variables HDF5`\
`     BUG: missing gdcm libraries when using system GDCM`\
`     DOC: fix doxygen documentaiton for itk::LaplacianDeformationQuadEdgeMeshFilter`\
`     ENH: Add one method to erase a tag into MetaDataDictionary`

Bill Lorensen (5):

`     ENH: Specify required VTK modules`\
`     COMP: Wiki examples require additional vtk modules`\
`     ENH: Modify WikiExamples remote config`\
`     COMP: Bad test signature`\
`     COMP: Update tag for wiki examples`

Brad King (6):

`     COMP: Fix vxl_config_macros usage of CMake check macros`\
`     ENH: Use if(DEFINED) to simplify conditions`\
`     COMP: Fix vxl_config_macros checks broken by refactoring`\
`     COMP: Fix one more vxl_config_macros check broken by refactoring`\
`     BUG: Fix itk_module_config for repeated calls`\
`     BUG: Fix itk_module_config for repeated calls`

Bradley Lowekamp (52):

`     ENH: Adding License file from upstream MetaIO`\
`     ENH: Adding script to update MetaIO from upstream`\
`     ENH: Remove ITK MetaIO to prepare for upstream import`\
`     PERF: Remove dynamically allocated temporary in evaluate method`\
`     COMP: Fix variable type for Set/Get macros`\
`     BUG: Implement ITK Style Singleton design pattern`\
`     ENH: Add no throw exception specification for UnRegister methods`\
`     COMP: Must specify order as `“`noexcept`` ``override`”\
`     BUG: Add GetInverse for IdentityTransform`\
`     ENH: Adding SetIdentity method to base DisplacementField class`\
`     BUG: Remove unused redefinition of NULL`\
`     BUG: Don't print to std::cout in PrintSelf`\
`     ENH: Prefer the PrintSelfObjectMacro for printing nested objects`\
`     BUG: Use METER of sCAL scale unit`\
`     BUG: Use PNG_SCALE_METER for PNG sCAL unit`\
`     BUG: Use METER of sCAL scale unit`\
`     BUG: Use PNG_SCALE_METER for PNG sCAL unit`\
`     COMP: Fix signed to unsigned int comparison`\
`     BUG: Fix overflows computing size of read tiff image`\
`     ENH: Extract TiffReaderInternal to separate file`\
`     ENH: Refactor ReadTwoSamplePerPixelImage into template function`\
`     ENH: Refactor GenericReadImage into template function`\
`     BUG: Remove Zeiss 2-channel support code in TIFFImageIO ( and LSMImageIO )`\
`     ENH: Refactor method to convert RGBA image to output buffer`\
`     ENH: Refactor duplicated code to read a page`\
`     BUG: Fix right oriented tiff images`\
`     BUG: Remove dead separated plannar code, add test`\
`     STYLE: Fix minor kwstyle defects in test and test results`\
`     BUG: Use array delete operator for array new allocations`\
`     ENH: add arbitrary TIFF TAGs to meta-data dictionary`\
`     ENH: Reduce code duplicate in TIFFImageIO::ReadCurrentPage`\
`     BUG: Address Coverity warning about null pointer dereferences`\
`     ENH: Remove support for TIFF tile as 3D and dead code`\
`     ENH: RGBA read images should stay unchanged.`\
`     BUG: Override method to MakeOutput by name`\
`     ENH: Refactor per pixel conversion function to per scan-line method`\
`     PERF: Refactor color table lookup`\
`     BUG: Adding missing parentheses around boolean expression`\
`     ENH: adding TIFFImageIO test for RGB palette images`\
`     PERF: Improve recursive Gaussian perfromance with VectorImages`\
`     ENH: Query libtiff to determine compression support`\
`     BUG: Support TIFF tiled image with TIFFReadRGBAImage`\
`     BUG: Use SizeValueType for length of scanline`\
`     PERF: Store causal results directly in output buffers`\
`     COMP: Add explicit conversion to const char`\
`     COMP: Explicitly add override to GetNameOfClass method`\
`     COMP: Address internal segmentation fault with Intel compiler`\
`     ENH: Adding method to set global physical space tolerance`\
`     COMP: Explicitly add override to GetNameOfClass method`\
`     BUG: Add new TypeMacro for non-overloaded classes`\
`     BUG: Fix obscure race condition on access thread pool initialization`\
`     BUG: Updating FDFImageIO remote module`

Christopher Mullins (15):

`     COMP: Allows latex to compile for ITKSoftwareGuide`\
`     COMP: Allows latex to compile for ITKSoftwareGuide`\
`     COMP: Wrap MeshBase templates`\
`     COMP: Wrap MeshBase templates`\
`     COMP: Fix warning in BlockMatchingImageFilter`\
`     STYLE: Line lengths in examples should be no longer than 80 chars.`\
`     COMP: Wrap the remaining MeshBase and MeshToMeshFilter types.`\
`     COMP: Fix LaTeX warnings.`\
`     STYLE: Fix formatting/punctuation errors.`\
`     STYLE: Formatting and punctuation fixes.`\
`     DOC: Edits for Book 2 Chapter 1 documentation in the Examples.`\
`     DOC: Edits for book 2 chapter 2.`\
`     DOC: More chapter 2 edits`\
`     DOC: Book 2 Chapter 3 edits (part 1)`\
`     DOC: book 2 chapter 4 Segmentation edits`

Danny Perry (2):

`     BUG: adding test for vnl_sparse_matrix::mult()`\
`     BUG: size of q buffer should actually be (this->rows())*pcols.`

David T. Chen (1):

`     DOC: Fixed HistogramThresholdImageFitler`

Dirk Padfield (1):

`     BUG: Corrected processing of last sigma`

GCC-XML Upstream (1):

`     ENH: pygccxml v1.6.2 (reduced)`

Gert Wollny (1):

`     COMP: Fix SSE2 build errors with WrapITK on GCC 4.9. (ForRelease)`

Girish Mallya (1):

`     BUG: Tests added for BinaryImageToLabelMapFilter for single-row images.`

Hans Johnson (24):

`     COMP: Add tolerance for comparing floating point`\
`     PERF: Remove non-threadable algorithm components`\
`     COMP: Add tolerance for comparing floating point`\
`     PERF: Remove non-threadable algorithm components`\
`     PERF: Remove large foot print of PDF derivatives.`\
`     PERF: Revert Remove large foot print of PDF derivatives.`\
`     STYLE: Test against almost equal for floating point values`\
`     STYLE: Non-exact floating point testing`\
`     PERF: Distribute initialization per thread buffers`\
`     ENH: Remove unnecessary mutable qualifier.`\
`     STYLE: Remove comment with no meaning.`\
`     ENH: Moved accumlator logic to main MI class`\
`     ENH: Allow staggering of accumulations per thread.`\
`     PERF: Zero reset thread buffers during finalize`\
`     BUG: Syntax error in comment`\
`     PERF: Add non-blocking mutex locking.`\
`     ENH: Use TryLock minimize thread stalls`\
`     BUG: ThreadedIndexedContainerPartitioner is inclusive`\
`     STYLE: Remove include_regular_expression from Examples`\
`     BUG: Demonstrate Inv(Inv(T)) != T`\
`     BUG: Ensure Inv(Inv(T)) == T for transforms`\
`     COMP: Valgrind detects uninitialized memory read`\
`     COMP: Missing required base class API component`\
`     ENH: Expand interface for selecting threadpool`

Ismael Belghiti (1):

`     DOC: Spelling Error in PatchBasedDenoisingBaseImageFilter`

Jim Miller (1):

`     STYLE: Removing what appears to be a temporary file`

Johan Andruejol (1):

`     ENH: Fix normalization for null vectors and return the norm`

Jon Haitz Legarreta (1):

`     ENH: New test for itkLabelShapeOpeningImageFilter`

Kent Williams (9):

`     COMP: use find_package(VTK COMPONENTS) to specify just needed VTK Components`\
`     BUG: ImageSources/test/CMakeLists.txt incorrect library var reference`\
`     COMP: Fix coverity defects related to RegistrationV4 examples`\
`     COMP: silence warning of vnl_vector_fixed_ref::assert_size`\
`     COMP: Fix various Coverity warnings`\
`     COMP: Fix a typo in an error message print statement.`\
`     COMP: itk::Command-derived class used pointless dynamic_cast.`\
`     PERF: Don't recompute InternalInverse repeatedly`\
`     COMP: Correct orientation/spacing for Philips MultiFrame`

Mark Hiner (2):

`     ENH: Update SCIFIO remote module hash`\
`     BUG: Fix duplicate variables in Windows`

Matthew McCormick (105):

`     DOC: Fix itkSetGetDecoratedInputMacro Doxygen macro.`\
`     ENH: Move FFTComplexToComplexImageFilter out of Review.`\
`     ENH: Add VnlComplexToComplexFFTImageFilter.`\
`     BUG: Use fixed seed for Vnl FFT tests for repeatibility.`\
`     ENH: Bump CMakeLists.txt version to 4.7.0.`\
`     BUG: ArchiveTestingData.py future imports must occur at the beginning.`\
`     BUG: Do not run vnl_test_na with broken libc++.`\
`     DOC: Remove Image2.cxx reference from Book 2.`\
`     DOC: Fix Software Guide page overruns in IterativeClosestPoint3.cxx.`\
`     DOC: Remove references to Book 1 sections from Book 2.`\
`     DOC: Make BinaryThresholdImageFilter not floating.`\
`     DOC: Fix Software Guide figure caption for FlipImageFilter.`\
`     DOC: Avoid duplicate figure description in ResampleImageFilter2.cxx.`\
`     DOC: Remove duplicate figure in LaplacianRecursiveGaussianImageFilter2.cxx.`\
`     DOC: ImageRandomConstIteratorWithIndex table reference.`\
`     DOC: Fix Software Guide page overruns in IterativeClosestPoint{1,2}.cxx.`\
`     DOC: Remove duplicate text in LaplacianRecursiveGaussian example.`\
`     BUG: Uninitialized m_TransformDirection in ComplexToComplexFFTImageFilter.`\
`     BUG: Fix offset[2] in PointSetToSpatialObjectDemonsRegistrationTest.`\
`     STYLE: Fix style in VoronoiDiagram2D.`\
`     BUG: Fix invalid assignment of second VoronoiBoundaryOrigin.`\
`     BUG: Bump GCCXML to 2014-08-06.`\
`     BUG: Remove unused m_{SplitEpsilon,SigmoidPrimeOffset}.`\
`     BUG: Fix Win MultiThreader check for successful process creation.`\
`     BUG: Fix VTKPolyDataMeshIO writing for 2D second rank tensor.`\
`     COMP: Fix ImageRegistration8RegisteredSlice.png baseline name.`\
`     DOC: itk::statistics -> itk::Statistics.`\
`     COMP: Fix transform type for ITKv3/IterativeClosestPoint2.`\
`     BUG: Fix invalid assignment of second VoronoiBoundaryOrigin.`\
`     COMP: Improve const correctness of GradientRecursiveGaussianImageFilter.`\
`     BUG: Call clear instead of empty on PatchBasedDenoising EmptyCaches().`\
`     BUG: Fix Size() in ImageToListSampleAdaptor for VectorImage's.`\
`     COMP: ThreadJob NULL not defined.`\
`     BUG: Fix alpha assignment for RGBA TIFF.`\
`     COMP: Remove unused typedefs in LevelSetsv4Visualization.`\
`     COMP: Remove unused typedef's in VtkGlue.`\
`     ENH: Mark BSplineWarping2Test as RUNS_LONG.`\
`     BUG: Fix Nifti IO read with large images.`\
`     COMP: Remove call for non-existent variable in Nifti debugging.`\
`     BUG: Close the file on Read and Write in HDF5TransformIO.`\
`     BUG: Remove InsightLegacy test code from TransformHDF5Test.`\
`     ENH: Add {Set,Get}TransformIO for TransformFile{Reader,Writer}.`\
`     STYLE: Use SeriesUIDContainerType and FileNamesContainerType`\
`     ENH: Allow specification of orthogonality tolerance in rigid transforms.`\
`     BUG: TransformFileReader does not clear its TransformList.`\
`     BUG: Prevent dangling pointer in HDF5TransformIO.`\
`     COMP: Do not use _stat64 with MinGW-32.`\
`     BUG: Improve thread-safety and performance of PCAShapeSignedDistanceFunction.`\
`     DOC: itk::statistics -> itk::Statistics.`\
`     DOC: Remove duplicate text in LaplacianRecursiveGaussian example.`\
`     DOC: Fix Software Guide page overruns in IterativeClosestPoint{1,2}.cxx.`\
`     COMP: Address LaplacianDeformation Doxygen warnings.`\
`     BUG: TransformFileReader does not clear its TransformList.`\
`     BUG: Prevent dangling pointer in HDF5TransformIO.`\
`     COMP: Fix missing prefix in ITKv3ImageRegistration20Test.`\
`     BUG: Do not return SmartPointers in TimeVaryingVelocityFieldTransform`\
`     COMP: Do not wrap the FixedArray of Image SmartPointer's.`\
`     COMP: Add missing wrapping for TransformIOBaseTemplate.`\
`     COMP: Mark DeformableRegistration6Test as RUNS_LONG.`\
`     STYLE: Improve style in BinaryImageToLabelMapFilter.`\
`     BUG: Fix BinaryImageToLabelMapFilter on 1D image.`\
`     ENH: Improve precision of the joint PDF sum`\
`     BUG: Fix BinShrinkImageFilter for different input/output image types.`\
`     COMP: Fix transform type for ITKv3/IterativeClosestPoint2.`\
`     BUG: Use -py3 when building wrapping for Python 3.`\
`     COMP: Add missing wrapping for TransformIOBaseTemplate.`\
`     DOC: Improve ImageRegistration4 grammar.`\
`     ENH: Add IOTransformDCMTK Remote module.`\
`     BUG: gdcm::StringFilter recognizes backslash delimiter.`\
`     DOC: Add migration guide for GDCM Rescale slope intercept apply on write.`\
`     COMP: Remove unused typedef's in GPU code.`\
`     STYLE: Improve style of HoughTransform2DLinesImageFilter example.`\
`     COMP: Use ConceptChecking for IterativeInverse dimension check.`\
`     COMP: Wrap TransformIOBaseTemplate for const SmartPointer.`\
`     COMP: Add warning exceptions for third party pcre, swig, gccxml.`\
`     ENH: Bump ITK version to 4.6.1.`\
`     BUG: Add missing ITK_OVERRIDE to ITKImageeSources module.`\
`     BUG: Remove GaussianImageSource members shadowing GenerateImageSource.`\
`     STYLE: Style fixes to ITKImageSources module.`\
`     BUG: GaussianSpatialFunction and GaborImageSource use SpacePrecisionType.`\
`     BUG: Do not perform itk_download_attempt_check when not building ITK.`\
`     DOC: Update GDCMImageIO rescale slope intercept doc.`\
`     BUG: Only register requestion IO COMPONENT modules.`\
`     BUG: Fix wrapping .i, .idx CMake dependencies.`\
`     COMP: Add VTK Python module when wrapping ITKVtkGlue.`\
`     STYLE: Remove NULL definition in itkVoronoiDiagram2DGenerator.`\
`     STYLE: VoronoiDiagram2DGenerator defines a VoronoiDiagramType typedef.`\
`     COMP: Add missing VTK module dependency for LevelSetsv4Visualization.`\
`     BUG: By default, do not create any fixed parameters.`\
`     STYLE: Remove trivial method comments in itkTransform.hxx.`\
`     BUG: PolylineMask Filter's GenerateData is protected / virtual.`\
`     ENH: Add HigherOrderAccurateGradient Module.`\
`     BUG: Use input RequestedRegion Index in SliceBySliceImageFilter internal.`\
`     COMP: Remove extra semi-colon, variable scope in DCMTKFileReader.`\
`     STYLE: Style fixes for Transform classes.`\
`     DOC: Increase Doxygen LOOKUP_CACHE_SIZE.`\
`     BUG: MatrixOffsetTransformBase::GetFixedParameters not thread safe.`\
`     DOC: Index Wiki examples with Doxygen.`\
`     COMP: Bump SphinxExamples remote module.`\
`     DOC: Index Sphinx examples in Doxygen.`\
`     COMP: Remove old java examples.`\
`     COMP: Remove duplicate DiffusionTensor3DReconstruction example reference.`\
`     COMP: Address GradientAnisotropicDiffusionImageFilter example settings.`\
`     COMP: Bump Sphinx Examples remote.`\
`     COMP: Bump WikiExamples remote.`

MetaIO Maintainers (1):

`     MetaIO (reduced)`

Michka Popoff (40):

`     ENH: Fixes for python 3 support`\
`     BUG: Add VTK_VERSION for older VTK versions`\
`     BUG: Improve SWIG version check`\
`     COMP: Add wrapping for ThreadPool and ThreadJob`\
`     COMP: Remove unimplemented DestroyPool method`\
`     COMP: Fix itkVnlComplexToComplexFFTImageFilter wrapping`\
`     COMP: Do not hide pygccxml warnings`\
`     ENH: Update links in readme file`\
`     BUG: Improve SWIG version check`\
`     BUG: Add VTK_VERSION for older VTK versions`\
`     STYLE: Remove trailing whitespaces`\
`     STYLE: Set ITK_USE_SYTEM_ZLIB and ITK_USE_SYTEM_SZIP`\
`     BUG: Fix memory leak in MetaImageIO after exception`\
`     ENH: Add script to update pygccxml from upstream`\
`     BUG: Update VTK minimum version (for release)`\
`     BUG: Fix memory leak in MetaImageIO after exception`\
`     ENH: Remove Sun OS compatibility for the wrappings`\
`     COMP: Fix for conversion to non-pointer like type warning`\
`     STYLE: LabelObject style`\
`     DOC: Remove broken link from LabelObject class description`\
`     ENH: Do not setup the python tests if not asked`\
`     ENH: Add new GetTypes() and GetTypesAsList() methods to the template class`\
`     COMP: Fix CMP0054 warnings in wrappings`\
`     STYLE: Remove old cmake < 2.8.4 specific code`\
`     STYLE: Remove old cmake < 2.8.5 specific code`\
`     ENH: Update to PCRE 8.36`\
`     COMP: Refactor Wrapping setup and fix legacy warnings`\
`     ENH: Add wrapping configuration to ITKConfig.cmake`\
`     STYLE: Some minor code cleanup in the wrapping setup`\
`     DOC: Fix typo in RelabelComponentImageFilter`\
`     ENH: Deprecate VectorResampleImageFilter`\
`     DOC: Add migration guide for ::Zero and ::One`\
`     ENH: Deprecate ::Zero and ::One`\
`     ENH: Add option to disable sorting by size in itkRelabelComponentImageFilter`\
`     ENH: Add Vector and RGB wrapping to linear interpolator`\
`     STYLE: Remove SORT macro in wrappings`\
`     COMP: Fix warning for InterpolateImageFunction wrapping`\
`     COMP: Add a check for Blocks in GPU module`\
`     COMP: Bump SCIFIO to fix test build warnings`\
`     COMP: Fix wrapping of itkImageFunctionBase`

Nick Tustison (7):

`     BUG:  Need to explicitly specify spline order.`\
`     ENH:  Initializing the transform center.`\
`     BUG:  Need to check the dynamic cast before any calls.`\
`     ENH:  Adding modifications for point set metrics.`\
`     BUG:  Need to specify TInternalComputationValueType for default metric.`\
`     ENH:  Adding sparse points to B-spline field estimate.`\
`     BUG:  Uninitialized variables.`

Richard Beare (1):

`     ENH: Include TIFF tags in the MetaDataDictionary`

Taylor Braun-Jones (1):

`     BUG: Fix SliceBySliceImageFilter doesn't propagate information internally`

Umang B (1):

`     ENH: Use thread pool to dispatch multithreading tasks`

Vivien Delmon (2):

`     BUG: ExtractImageFilter::CollapseToSubMatrix fix`\
`     ENH: Add a test on extracted directions in CollapseToSubMatrix mode`

Vladimir S. FONOV (1):

`     BUG: Fixing incorrect MINC style inverse transform`

ITK Sphinx Examples Changelog

------------------------------------------------------------------------

Arnaud Gelas (12):

`     add one example to translate one itk::Image`\
`     add PasteImageFilter example`\
`     fix path in ArchiveBinaryData.py.in`\
`     BUG: error when TEST_IMAGE_PREFIX was used`\
`     fix broken links as detected by linkcheck`\
`     add example for PermuteAxesImageFilter`\
`     Add one example to apply an affine transform given homogeneous matrix`\
`     Add one example to multiply 2 images`\
`     use ITK 4.6.1 for superbuild`\
`     update breathe to 3.1.0`\
`     Add one example to generate slices from volume`\
`     Add one example about RegionOfInterestImageFilter`

Brad King (1):

`     setup-hooks: Create .git hooks directory if necessary`

Matt McCormick (15):

`     ENH: Bump ITK Superbuild tag to 4.6.0.`\
`     BUG: Fix ConvertAnITKGrayScaleImageToCVMat compare_to_baseline.`\
`     COMP: Remove breathe link to ConstantPadImageFilter.`\
`     BUG: Fix figure path for Iterative Hole Filling.`\
`     BUG: Evolution.gif needs to be ..only:: html`\
`     COMP: Content not permitted in image:: directive.`\
`     BUG: Require CMake 2.8.6 in CreateNewExample template.`\
`     BUG: Update CreateNewExample.py for new compare_to_baseline syntax.`\
`     COMP: Fix ITKMathematicalMorphology COMPONENT dependency.`\
`     COMP: Fix build as a Remote module.`\
`     COMP: Fix fresh configuration as an ITK module.`\
`     COMP: Fix configuration ITK_WRAP_PYTHON is not defined.`\
`     BUG: Annotate ReadUnknownImageType component type correctly.`\
`     ENH: Bump Superbuild VTK version to 6.1.0.`\
`     ENH: Bump Superbuild ITK version to 4.7.0.`

Michka Popoff (15):

`     COMP: Fix failing setup of SegmentBloodVessels example`\
`     STYLE: Update title for Apply Affine Transform example`\
`     ENH: Add GeodesicActiveContourLevelSetImageFilter example`\
`     COMP: Fix failing MultiplyTwoImagesTestBaselineComparison test`\
`     COMP: Add images to the MultiplyTwoImages documentation`\
`     COMP: Fix and improve ForwardFFTExample`\
`     COMP: Fix Multiply two images output`\
`     COMP: Update all cmake versions to 2.8.6`\
`     COMP: Fix MultiplyTwoImagesTestBaselineComparison`\
`     ENH: Add infrastructure for Python tests`\
`     ENH: Add example on how to resample a RGB image`\
`     BUG: Add missing images to ResampleAVectorImage documentation`\
`     COMP: Fix path for favicon`\
`     COMP: Fix for CleanQuadEdgeMesh documentation`\
`     BUG: Add missing semicolon to example`

ITK Software Guide Changelog

------------------------------------------------------------------------

Ali Ghayoor (4):

`     ENH: Part one of converting Registration chapter to ITKv4`\
`     ENH: Part two of converting Registration chapter to ITKv4`\
`     ENH: Part three of converting Registration chapter to ITKv4`\
`     DOC: Revise the registration chapter`

Christopher Mullins (16):

`     COMP: Use RegistrationITKv3 examples with ITKv3_COMPATIBILITY`\
`     STYLE: Use minted to highlight code syntax`\
`     DOC: Add instructions for using ITK from python`\
`     COMP: Sort and run the examples topologically.`\
`     COMP: add_custom_command no longer takes SOURCE parameter`\
`     STYLE: Fix python indentation`\
`     COMP: BuildTexFiles target should depend on SoftwareGuideExamples`\
`     COMP: Update the .eps generation command to use the OUTPUT signature.`\
`     STYLE: Fix quotes.`\
`     DOC: Language edits mostly from Book 2`\
`     ENH: Only flip the images we want to flip`\
`     BUG: Figure overlaps text in 4.3.`\
`     DOC: More language fixes, use minted instead of code tags.`\
`     STYLE: Put a new line before code blocks`\
`     STYLE: Fix margin problems with filenames and floating figure overlaps`\
`     STYLE: Change margins using the geometry package.`

Hans Johnson (1):

`     ENH: Bring ITK code closer to the 4.7 release code`

Matt McCormick (25):

`     ENH: Pass PDF_QUALITY_LEVEL in superbuild.`\
`     BUG: Remove unused RunExamples.py imports.`\
`     ENH: Reduce verbosity of RunExamples.py.`\
`     BUG: Do not include RegistrationITKv4 example sources in the build.`\
`     BUG: Fix caption on Confidence Connectened on BrainWeb figures.`\
`     BUG: Bump the ITK superbuild for LaTeX fixes.`\
`     ENH: Add new ISBN numbers.`\
`     DOC: CDash has replaced Dart.`\
`     DOC: itk::statistics -> itk::Statistics.`\
`     ENH: Update ITK logo.`\
`     STYLE: Remove box around CC logo.`\
`     DOC: Document instructions for building from the Docker image.`\
`     DOC: Docker build instruction improvements.`\
`     ENH: New path for starting the docker environment.`\
`     ENH: Change paper size.`\
`     COMP: Improve arguments for GradientAnisotropicDiffusionImageFilter.`\
`     ENH: Bump ITK Superbuild version to 2014-12-03.`\
`     BUG: Add flags for PDF_QUALITY_LEVEL STREQUAL ""`\
`     ENH: Add contributors for print release.`\
`     ENH: Upsample when building with PDF_QUALITY_LEVEL `“`Printer`”`.`\
`     BUG: Specify cc-by logo size explicitly.`\
`     BUG: Use original ITK configuration images.`\
`     ENH: Use file(COPY to copy over .eps images.`\
`     ENH: Margin tightening.`\
`     ENH: Bump ITK ExternalProject to v4.7.0.`

Michka Popoff (5):

`     ENH: Use the new licence file for MetaIO`\
`     DOC: Fixes for the ITK 4.7 book`\
`     DOC: Fixes for book1, part1, chapter 2`\
`     DOC: Fixes and improvements for Book 1, chapter 3`\
`     DOC: Minor fixes for Book 1, Chapter 4`

Sandy McKenzie (1):

`     STYLE: Add new line before code block`

ITKApps Changelog

------------------------------------------------------------------------

Bill Lorensen (1):

`     COMP: Update CTEST_DROP_SITE`

Matt McCormick (4):

`     COMP: Use ::ZeroValue() instead of ::Zero.`\
`     COMP: Patch FLTK for build against newer freetype.`\
`     COMP: Address %d type for VolviewPlugins.`\
`     ENH: Bump ITK Superbuild version to v4.7.0.`
