/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_2_H
#define LEXBOR_UNICODE_TABLES_2_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2A0C = {.cps = (lxb_codepoint_t[]) {0x222B, 0x222B, 0x222B, 0x222B}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2A74 = {.cps = (lxb_codepoint_t[]) {0x003A, 0x003A, 0x003D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2A75 = {.cps = (lxb_codepoint_t[]) {0x003D, 0x003D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2A76 = {.cps = (lxb_codepoint_t[]) {0x003D, 0x003D, 0x003D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2ADC = {.cps = (lxb_codepoint_t[]) {0x2ADD, 0x0338}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C00 = {.cps = (lxb_codepoint_t[]) {0x2C30}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C01 = {.cps = (lxb_codepoint_t[]) {0x2C31}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C02 = {.cps = (lxb_codepoint_t[]) {0x2C32}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C03 = {.cps = (lxb_codepoint_t[]) {0x2C33}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C04 = {.cps = (lxb_codepoint_t[]) {0x2C34}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C05 = {.cps = (lxb_codepoint_t[]) {0x2C35}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C06 = {.cps = (lxb_codepoint_t[]) {0x2C36}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C07 = {.cps = (lxb_codepoint_t[]) {0x2C37}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C08 = {.cps = (lxb_codepoint_t[]) {0x2C38}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C09 = {.cps = (lxb_codepoint_t[]) {0x2C39}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C0A = {.cps = (lxb_codepoint_t[]) {0x2C3A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C0B = {.cps = (lxb_codepoint_t[]) {0x2C3B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C0C = {.cps = (lxb_codepoint_t[]) {0x2C3C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C0D = {.cps = (lxb_codepoint_t[]) {0x2C3D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C0E = {.cps = (lxb_codepoint_t[]) {0x2C3E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C0F = {.cps = (lxb_codepoint_t[]) {0x2C3F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C10 = {.cps = (lxb_codepoint_t[]) {0x2C40}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C11 = {.cps = (lxb_codepoint_t[]) {0x2C41}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C12 = {.cps = (lxb_codepoint_t[]) {0x2C42}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C13 = {.cps = (lxb_codepoint_t[]) {0x2C43}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C14 = {.cps = (lxb_codepoint_t[]) {0x2C44}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C15 = {.cps = (lxb_codepoint_t[]) {0x2C45}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C16 = {.cps = (lxb_codepoint_t[]) {0x2C46}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C17 = {.cps = (lxb_codepoint_t[]) {0x2C47}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C18 = {.cps = (lxb_codepoint_t[]) {0x2C48}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C19 = {.cps = (lxb_codepoint_t[]) {0x2C49}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C1A = {.cps = (lxb_codepoint_t[]) {0x2C4A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C1B = {.cps = (lxb_codepoint_t[]) {0x2C4B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C1C = {.cps = (lxb_codepoint_t[]) {0x2C4C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C1D = {.cps = (lxb_codepoint_t[]) {0x2C4D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C1E = {.cps = (lxb_codepoint_t[]) {0x2C4E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C1F = {.cps = (lxb_codepoint_t[]) {0x2C4F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C20 = {.cps = (lxb_codepoint_t[]) {0x2C50}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C21 = {.cps = (lxb_codepoint_t[]) {0x2C51}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C22 = {.cps = (lxb_codepoint_t[]) {0x2C52}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C23 = {.cps = (lxb_codepoint_t[]) {0x2C53}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C24 = {.cps = (lxb_codepoint_t[]) {0x2C54}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C25 = {.cps = (lxb_codepoint_t[]) {0x2C55}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C26 = {.cps = (lxb_codepoint_t[]) {0x2C56}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C27 = {.cps = (lxb_codepoint_t[]) {0x2C57}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C28 = {.cps = (lxb_codepoint_t[]) {0x2C58}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C29 = {.cps = (lxb_codepoint_t[]) {0x2C59}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C2A = {.cps = (lxb_codepoint_t[]) {0x2C5A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C2B = {.cps = (lxb_codepoint_t[]) {0x2C5B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C2C = {.cps = (lxb_codepoint_t[]) {0x2C5C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C2D = {.cps = (lxb_codepoint_t[]) {0x2C5D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C2E = {.cps = (lxb_codepoint_t[]) {0x2C5E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C2F = {.cps = (lxb_codepoint_t[]) {0x2C5F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C60 = {.cps = (lxb_codepoint_t[]) {0x2C61}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C62 = {.cps = (lxb_codepoint_t[]) {0x026B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C63 = {.cps = (lxb_codepoint_t[]) {0x1D7D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C64 = {.cps = (lxb_codepoint_t[]) {0x027D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C67 = {.cps = (lxb_codepoint_t[]) {0x2C68}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C69 = {.cps = (lxb_codepoint_t[]) {0x2C6A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C6B = {.cps = (lxb_codepoint_t[]) {0x2C6C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C6D = {.cps = (lxb_codepoint_t[]) {0x0251}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C6E = {.cps = (lxb_codepoint_t[]) {0x0271}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C6F = {.cps = (lxb_codepoint_t[]) {0x0250}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C70 = {.cps = (lxb_codepoint_t[]) {0x0252}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C72 = {.cps = (lxb_codepoint_t[]) {0x2C73}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C75 = {.cps = (lxb_codepoint_t[]) {0x2C76}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C7C = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C7D = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C7E = {.cps = (lxb_codepoint_t[]) {0x023F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C7F = {.cps = (lxb_codepoint_t[]) {0x0240}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C80 = {.cps = (lxb_codepoint_t[]) {0x2C81}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C82 = {.cps = (lxb_codepoint_t[]) {0x2C83}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C84 = {.cps = (lxb_codepoint_t[]) {0x2C85}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C86 = {.cps = (lxb_codepoint_t[]) {0x2C87}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C88 = {.cps = (lxb_codepoint_t[]) {0x2C89}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C8A = {.cps = (lxb_codepoint_t[]) {0x2C8B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C8C = {.cps = (lxb_codepoint_t[]) {0x2C8D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C8E = {.cps = (lxb_codepoint_t[]) {0x2C8F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C90 = {.cps = (lxb_codepoint_t[]) {0x2C91}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C92 = {.cps = (lxb_codepoint_t[]) {0x2C93}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C94 = {.cps = (lxb_codepoint_t[]) {0x2C95}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C96 = {.cps = (lxb_codepoint_t[]) {0x2C97}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C98 = {.cps = (lxb_codepoint_t[]) {0x2C99}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C9A = {.cps = (lxb_codepoint_t[]) {0x2C9B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C9C = {.cps = (lxb_codepoint_t[]) {0x2C9D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2C9E = {.cps = (lxb_codepoint_t[]) {0x2C9F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CA0 = {.cps = (lxb_codepoint_t[]) {0x2CA1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CA2 = {.cps = (lxb_codepoint_t[]) {0x2CA3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CA4 = {.cps = (lxb_codepoint_t[]) {0x2CA5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CA6 = {.cps = (lxb_codepoint_t[]) {0x2CA7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CA8 = {.cps = (lxb_codepoint_t[]) {0x2CA9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CAA = {.cps = (lxb_codepoint_t[]) {0x2CAB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CAC = {.cps = (lxb_codepoint_t[]) {0x2CAD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CAE = {.cps = (lxb_codepoint_t[]) {0x2CAF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CB0 = {.cps = (lxb_codepoint_t[]) {0x2CB1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CB2 = {.cps = (lxb_codepoint_t[]) {0x2CB3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CB4 = {.cps = (lxb_codepoint_t[]) {0x2CB5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CB6 = {.cps = (lxb_codepoint_t[]) {0x2CB7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CB8 = {.cps = (lxb_codepoint_t[]) {0x2CB9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CBA = {.cps = (lxb_codepoint_t[]) {0x2CBB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CBC = {.cps = (lxb_codepoint_t[]) {0x2CBD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CBE = {.cps = (lxb_codepoint_t[]) {0x2CBF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CC0 = {.cps = (lxb_codepoint_t[]) {0x2CC1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CC2 = {.cps = (lxb_codepoint_t[]) {0x2CC3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CC4 = {.cps = (lxb_codepoint_t[]) {0x2CC5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CC6 = {.cps = (lxb_codepoint_t[]) {0x2CC7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CC8 = {.cps = (lxb_codepoint_t[]) {0x2CC9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CCA = {.cps = (lxb_codepoint_t[]) {0x2CCB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CCC = {.cps = (lxb_codepoint_t[]) {0x2CCD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CCE = {.cps = (lxb_codepoint_t[]) {0x2CCF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CD0 = {.cps = (lxb_codepoint_t[]) {0x2CD1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CD2 = {.cps = (lxb_codepoint_t[]) {0x2CD3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CD4 = {.cps = (lxb_codepoint_t[]) {0x2CD5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CD6 = {.cps = (lxb_codepoint_t[]) {0x2CD7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CD8 = {.cps = (lxb_codepoint_t[]) {0x2CD9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CDA = {.cps = (lxb_codepoint_t[]) {0x2CDB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CDC = {.cps = (lxb_codepoint_t[]) {0x2CDD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CDE = {.cps = (lxb_codepoint_t[]) {0x2CDF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CE0 = {.cps = (lxb_codepoint_t[]) {0x2CE1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CE2 = {.cps = (lxb_codepoint_t[]) {0x2CE3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CEB = {.cps = (lxb_codepoint_t[]) {0x2CEC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CED = {.cps = (lxb_codepoint_t[]) {0x2CEE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2CF2 = {.cps = (lxb_codepoint_t[]) {0x2CF3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2D6F = {.cps = (lxb_codepoint_t[]) {0x2D61}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2E9F = {.cps = (lxb_codepoint_t[]) {0x6BCD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2EF3 = {.cps = (lxb_codepoint_t[]) {0x9F9F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F00 = {.cps = (lxb_codepoint_t[]) {0x4E00}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F01 = {.cps = (lxb_codepoint_t[]) {0x4E28}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F02 = {.cps = (lxb_codepoint_t[]) {0x4E36}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F03 = {.cps = (lxb_codepoint_t[]) {0x4E3F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F04 = {.cps = (lxb_codepoint_t[]) {0x4E59}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F05 = {.cps = (lxb_codepoint_t[]) {0x4E85}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F06 = {.cps = (lxb_codepoint_t[]) {0x4E8C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F07 = {.cps = (lxb_codepoint_t[]) {0x4EA0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F08 = {.cps = (lxb_codepoint_t[]) {0x4EBA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F09 = {.cps = (lxb_codepoint_t[]) {0x513F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F0A = {.cps = (lxb_codepoint_t[]) {0x5165}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F0B = {.cps = (lxb_codepoint_t[]) {0x516B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F0C = {.cps = (lxb_codepoint_t[]) {0x5182}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F0D = {.cps = (lxb_codepoint_t[]) {0x5196}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F0E = {.cps = (lxb_codepoint_t[]) {0x51AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F0F = {.cps = (lxb_codepoint_t[]) {0x51E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F10 = {.cps = (lxb_codepoint_t[]) {0x51F5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F11 = {.cps = (lxb_codepoint_t[]) {0x5200}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F12 = {.cps = (lxb_codepoint_t[]) {0x529B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F13 = {.cps = (lxb_codepoint_t[]) {0x52F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F14 = {.cps = (lxb_codepoint_t[]) {0x5315}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F15 = {.cps = (lxb_codepoint_t[]) {0x531A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F16 = {.cps = (lxb_codepoint_t[]) {0x5338}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F17 = {.cps = (lxb_codepoint_t[]) {0x5341}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F18 = {.cps = (lxb_codepoint_t[]) {0x535C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F19 = {.cps = (lxb_codepoint_t[]) {0x5369}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F1A = {.cps = (lxb_codepoint_t[]) {0x5382}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F1B = {.cps = (lxb_codepoint_t[]) {0x53B6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F1C = {.cps = (lxb_codepoint_t[]) {0x53C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F1D = {.cps = (lxb_codepoint_t[]) {0x53E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F1E = {.cps = (lxb_codepoint_t[]) {0x56D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F1F = {.cps = (lxb_codepoint_t[]) {0x571F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F20 = {.cps = (lxb_codepoint_t[]) {0x58EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F21 = {.cps = (lxb_codepoint_t[]) {0x5902}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F22 = {.cps = (lxb_codepoint_t[]) {0x590A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F23 = {.cps = (lxb_codepoint_t[]) {0x5915}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F24 = {.cps = (lxb_codepoint_t[]) {0x5927}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F25 = {.cps = (lxb_codepoint_t[]) {0x5973}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F26 = {.cps = (lxb_codepoint_t[]) {0x5B50}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F27 = {.cps = (lxb_codepoint_t[]) {0x5B80}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F28 = {.cps = (lxb_codepoint_t[]) {0x5BF8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F29 = {.cps = (lxb_codepoint_t[]) {0x5C0F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F2A = {.cps = (lxb_codepoint_t[]) {0x5C22}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F2B = {.cps = (lxb_codepoint_t[]) {0x5C38}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F2C = {.cps = (lxb_codepoint_t[]) {0x5C6E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F2D = {.cps = (lxb_codepoint_t[]) {0x5C71}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F2E = {.cps = (lxb_codepoint_t[]) {0x5DDB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F2F = {.cps = (lxb_codepoint_t[]) {0x5DE5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F30 = {.cps = (lxb_codepoint_t[]) {0x5DF1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F31 = {.cps = (lxb_codepoint_t[]) {0x5DFE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F32 = {.cps = (lxb_codepoint_t[]) {0x5E72}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F33 = {.cps = (lxb_codepoint_t[]) {0x5E7A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F34 = {.cps = (lxb_codepoint_t[]) {0x5E7F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F35 = {.cps = (lxb_codepoint_t[]) {0x5EF4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F36 = {.cps = (lxb_codepoint_t[]) {0x5EFE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F37 = {.cps = (lxb_codepoint_t[]) {0x5F0B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F38 = {.cps = (lxb_codepoint_t[]) {0x5F13}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F39 = {.cps = (lxb_codepoint_t[]) {0x5F50}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F3A = {.cps = (lxb_codepoint_t[]) {0x5F61}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F3B = {.cps = (lxb_codepoint_t[]) {0x5F73}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F3C = {.cps = (lxb_codepoint_t[]) {0x5FC3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F3D = {.cps = (lxb_codepoint_t[]) {0x6208}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F3E = {.cps = (lxb_codepoint_t[]) {0x6236}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F3F = {.cps = (lxb_codepoint_t[]) {0x624B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F40 = {.cps = (lxb_codepoint_t[]) {0x652F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F41 = {.cps = (lxb_codepoint_t[]) {0x6534}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F42 = {.cps = (lxb_codepoint_t[]) {0x6587}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F43 = {.cps = (lxb_codepoint_t[]) {0x6597}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F44 = {.cps = (lxb_codepoint_t[]) {0x65A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F45 = {.cps = (lxb_codepoint_t[]) {0x65B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F46 = {.cps = (lxb_codepoint_t[]) {0x65E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F47 = {.cps = (lxb_codepoint_t[]) {0x65E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F48 = {.cps = (lxb_codepoint_t[]) {0x66F0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F49 = {.cps = (lxb_codepoint_t[]) {0x6708}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F4A = {.cps = (lxb_codepoint_t[]) {0x6728}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F4B = {.cps = (lxb_codepoint_t[]) {0x6B20}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F4C = {.cps = (lxb_codepoint_t[]) {0x6B62}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F4D = {.cps = (lxb_codepoint_t[]) {0x6B79}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F4E = {.cps = (lxb_codepoint_t[]) {0x6BB3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F4F = {.cps = (lxb_codepoint_t[]) {0x6BCB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F50 = {.cps = (lxb_codepoint_t[]) {0x6BD4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F51 = {.cps = (lxb_codepoint_t[]) {0x6BDB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F52 = {.cps = (lxb_codepoint_t[]) {0x6C0F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F53 = {.cps = (lxb_codepoint_t[]) {0x6C14}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F54 = {.cps = (lxb_codepoint_t[]) {0x6C34}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F55 = {.cps = (lxb_codepoint_t[]) {0x706B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F56 = {.cps = (lxb_codepoint_t[]) {0x722A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F57 = {.cps = (lxb_codepoint_t[]) {0x7236}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F58 = {.cps = (lxb_codepoint_t[]) {0x723B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F59 = {.cps = (lxb_codepoint_t[]) {0x723F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F5A = {.cps = (lxb_codepoint_t[]) {0x7247}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F5B = {.cps = (lxb_codepoint_t[]) {0x7259}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F5C = {.cps = (lxb_codepoint_t[]) {0x725B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F5D = {.cps = (lxb_codepoint_t[]) {0x72AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F5E = {.cps = (lxb_codepoint_t[]) {0x7384}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F5F = {.cps = (lxb_codepoint_t[]) {0x7389}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F60 = {.cps = (lxb_codepoint_t[]) {0x74DC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F61 = {.cps = (lxb_codepoint_t[]) {0x74E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F62 = {.cps = (lxb_codepoint_t[]) {0x7518}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F63 = {.cps = (lxb_codepoint_t[]) {0x751F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F64 = {.cps = (lxb_codepoint_t[]) {0x7528}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F65 = {.cps = (lxb_codepoint_t[]) {0x7530}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F66 = {.cps = (lxb_codepoint_t[]) {0x758B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F67 = {.cps = (lxb_codepoint_t[]) {0x7592}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F68 = {.cps = (lxb_codepoint_t[]) {0x7676}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F69 = {.cps = (lxb_codepoint_t[]) {0x767D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F6A = {.cps = (lxb_codepoint_t[]) {0x76AE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F6B = {.cps = (lxb_codepoint_t[]) {0x76BF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F6C = {.cps = (lxb_codepoint_t[]) {0x76EE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F6D = {.cps = (lxb_codepoint_t[]) {0x77DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F6E = {.cps = (lxb_codepoint_t[]) {0x77E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F6F = {.cps = (lxb_codepoint_t[]) {0x77F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F70 = {.cps = (lxb_codepoint_t[]) {0x793A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F71 = {.cps = (lxb_codepoint_t[]) {0x79B8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F72 = {.cps = (lxb_codepoint_t[]) {0x79BE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F73 = {.cps = (lxb_codepoint_t[]) {0x7A74}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F74 = {.cps = (lxb_codepoint_t[]) {0x7ACB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F75 = {.cps = (lxb_codepoint_t[]) {0x7AF9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F76 = {.cps = (lxb_codepoint_t[]) {0x7C73}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F77 = {.cps = (lxb_codepoint_t[]) {0x7CF8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F78 = {.cps = (lxb_codepoint_t[]) {0x7F36}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F79 = {.cps = (lxb_codepoint_t[]) {0x7F51}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F7A = {.cps = (lxb_codepoint_t[]) {0x7F8A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F7B = {.cps = (lxb_codepoint_t[]) {0x7FBD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F7C = {.cps = (lxb_codepoint_t[]) {0x8001}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F7D = {.cps = (lxb_codepoint_t[]) {0x800C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F7E = {.cps = (lxb_codepoint_t[]) {0x8012}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F7F = {.cps = (lxb_codepoint_t[]) {0x8033}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F80 = {.cps = (lxb_codepoint_t[]) {0x807F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F81 = {.cps = (lxb_codepoint_t[]) {0x8089}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F82 = {.cps = (lxb_codepoint_t[]) {0x81E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F83 = {.cps = (lxb_codepoint_t[]) {0x81EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F84 = {.cps = (lxb_codepoint_t[]) {0x81F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F85 = {.cps = (lxb_codepoint_t[]) {0x81FC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F86 = {.cps = (lxb_codepoint_t[]) {0x820C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F87 = {.cps = (lxb_codepoint_t[]) {0x821B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F88 = {.cps = (lxb_codepoint_t[]) {0x821F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F89 = {.cps = (lxb_codepoint_t[]) {0x826E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8A = {.cps = (lxb_codepoint_t[]) {0x8272}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8B = {.cps = (lxb_codepoint_t[]) {0x8278}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8C = {.cps = (lxb_codepoint_t[]) {0x864D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8D = {.cps = (lxb_codepoint_t[]) {0x866B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8E = {.cps = (lxb_codepoint_t[]) {0x8840}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F8F = {.cps = (lxb_codepoint_t[]) {0x884C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F90 = {.cps = (lxb_codepoint_t[]) {0x8863}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F91 = {.cps = (lxb_codepoint_t[]) {0x897E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F92 = {.cps = (lxb_codepoint_t[]) {0x898B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F93 = {.cps = (lxb_codepoint_t[]) {0x89D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F94 = {.cps = (lxb_codepoint_t[]) {0x8A00}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F95 = {.cps = (lxb_codepoint_t[]) {0x8C37}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F96 = {.cps = (lxb_codepoint_t[]) {0x8C46}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F97 = {.cps = (lxb_codepoint_t[]) {0x8C55}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F98 = {.cps = (lxb_codepoint_t[]) {0x8C78}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F99 = {.cps = (lxb_codepoint_t[]) {0x8C9D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9A = {.cps = (lxb_codepoint_t[]) {0x8D64}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B = {.cps = (lxb_codepoint_t[]) {0x8D70}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C = {.cps = (lxb_codepoint_t[]) {0x8DB3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D = {.cps = (lxb_codepoint_t[]) {0x8EAB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E = {.cps = (lxb_codepoint_t[]) {0x8ECA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F = {.cps = (lxb_codepoint_t[]) {0x8F9B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA0 = {.cps = (lxb_codepoint_t[]) {0x8FB0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA1 = {.cps = (lxb_codepoint_t[]) {0x8FB5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA2 = {.cps = (lxb_codepoint_t[]) {0x9091}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA3 = {.cps = (lxb_codepoint_t[]) {0x9149}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA4 = {.cps = (lxb_codepoint_t[]) {0x91C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA5 = {.cps = (lxb_codepoint_t[]) {0x91CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA6 = {.cps = (lxb_codepoint_t[]) {0x91D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA7 = {.cps = (lxb_codepoint_t[]) {0x9577}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA8 = {.cps = (lxb_codepoint_t[]) {0x9580}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA9 = {.cps = (lxb_codepoint_t[]) {0x961C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FAA = {.cps = (lxb_codepoint_t[]) {0x96B6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FAB = {.cps = (lxb_codepoint_t[]) {0x96B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FAC = {.cps = (lxb_codepoint_t[]) {0x96E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FAD = {.cps = (lxb_codepoint_t[]) {0x9751}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FAE = {.cps = (lxb_codepoint_t[]) {0x975E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FAF = {.cps = (lxb_codepoint_t[]) {0x9762}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB0 = {.cps = (lxb_codepoint_t[]) {0x9769}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB1 = {.cps = (lxb_codepoint_t[]) {0x97CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB2 = {.cps = (lxb_codepoint_t[]) {0x97ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB3 = {.cps = (lxb_codepoint_t[]) {0x97F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB4 = {.cps = (lxb_codepoint_t[]) {0x9801}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB5 = {.cps = (lxb_codepoint_t[]) {0x98A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB6 = {.cps = (lxb_codepoint_t[]) {0x98DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB7 = {.cps = (lxb_codepoint_t[]) {0x98DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB8 = {.cps = (lxb_codepoint_t[]) {0x9996}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FB9 = {.cps = (lxb_codepoint_t[]) {0x9999}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FBA = {.cps = (lxb_codepoint_t[]) {0x99AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FBB = {.cps = (lxb_codepoint_t[]) {0x9AA8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FBC = {.cps = (lxb_codepoint_t[]) {0x9AD8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FBD = {.cps = (lxb_codepoint_t[]) {0x9ADF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FBE = {.cps = (lxb_codepoint_t[]) {0x9B25}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FBF = {.cps = (lxb_codepoint_t[]) {0x9B2F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC0 = {.cps = (lxb_codepoint_t[]) {0x9B32}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC1 = {.cps = (lxb_codepoint_t[]) {0x9B3C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC2 = {.cps = (lxb_codepoint_t[]) {0x9B5A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC3 = {.cps = (lxb_codepoint_t[]) {0x9CE5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC4 = {.cps = (lxb_codepoint_t[]) {0x9E75}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC5 = {.cps = (lxb_codepoint_t[]) {0x9E7F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC6 = {.cps = (lxb_codepoint_t[]) {0x9EA5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC7 = {.cps = (lxb_codepoint_t[]) {0x9EBB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC8 = {.cps = (lxb_codepoint_t[]) {0x9EC3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FC9 = {.cps = (lxb_codepoint_t[]) {0x9ECD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FCA = {.cps = (lxb_codepoint_t[]) {0x9ED1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FCB = {.cps = (lxb_codepoint_t[]) {0x9EF9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FCC = {.cps = (lxb_codepoint_t[]) {0x9EFD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FCD = {.cps = (lxb_codepoint_t[]) {0x9F0E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FCE = {.cps = (lxb_codepoint_t[]) {0x9F13}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FCF = {.cps = (lxb_codepoint_t[]) {0x9F20}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FD0 = {.cps = (lxb_codepoint_t[]) {0x9F3B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FD1 = {.cps = (lxb_codepoint_t[]) {0x9F4A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FD2 = {.cps = (lxb_codepoint_t[]) {0x9F52}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FD3 = {.cps = (lxb_codepoint_t[]) {0x9F8D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FD4 = {.cps = (lxb_codepoint_t[]) {0x9F9C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FD5 = {.cps = (lxb_codepoint_t[]) {0x9FA0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3000 = {.cps = (lxb_codepoint_t[]) {0x0020}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3002 = {.cps = (lxb_codepoint_t[]) {0x002E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3036 = {.cps = (lxb_codepoint_t[]) {0x3012}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3038 = {.cps = (lxb_codepoint_t[]) {0x5341}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3039 = {.cps = (lxb_codepoint_t[]) {0x5344}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_303A = {.cps = (lxb_codepoint_t[]) {0x5345}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_309B = {.cps = (lxb_codepoint_t[]) {0x0020, 0x3099}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_309C = {.cps = (lxb_codepoint_t[]) {0x0020, 0x309A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_309F = {.cps = (lxb_codepoint_t[]) {0x3088, 0x308A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_30FF = {.cps = (lxb_codepoint_t[]) {0x30B3, 0x30C8}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3131 = {.cps = (lxb_codepoint_t[]) {0x1100}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3132 = {.cps = (lxb_codepoint_t[]) {0x1101}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3133 = {.cps = (lxb_codepoint_t[]) {0x11AA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3134 = {.cps = (lxb_codepoint_t[]) {0x1102}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3135 = {.cps = (lxb_codepoint_t[]) {0x11AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3136 = {.cps = (lxb_codepoint_t[]) {0x11AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3137 = {.cps = (lxb_codepoint_t[]) {0x1103}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3138 = {.cps = (lxb_codepoint_t[]) {0x1104}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3139 = {.cps = (lxb_codepoint_t[]) {0x1105}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_313A = {.cps = (lxb_codepoint_t[]) {0x11B0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_313B = {.cps = (lxb_codepoint_t[]) {0x11B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_313C = {.cps = (lxb_codepoint_t[]) {0x11B2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_313D = {.cps = (lxb_codepoint_t[]) {0x11B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_313E = {.cps = (lxb_codepoint_t[]) {0x11B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_313F = {.cps = (lxb_codepoint_t[]) {0x11B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3140 = {.cps = (lxb_codepoint_t[]) {0x111A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3141 = {.cps = (lxb_codepoint_t[]) {0x1106}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3142 = {.cps = (lxb_codepoint_t[]) {0x1107}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3143 = {.cps = (lxb_codepoint_t[]) {0x1108}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3144 = {.cps = (lxb_codepoint_t[]) {0x1121}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3145 = {.cps = (lxb_codepoint_t[]) {0x1109}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3146 = {.cps = (lxb_codepoint_t[]) {0x110A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3147 = {.cps = (lxb_codepoint_t[]) {0x110B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3148 = {.cps = (lxb_codepoint_t[]) {0x110C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3149 = {.cps = (lxb_codepoint_t[]) {0x110D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_314A = {.cps = (lxb_codepoint_t[]) {0x110E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_314B = {.cps = (lxb_codepoint_t[]) {0x110F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_314C = {.cps = (lxb_codepoint_t[]) {0x1110}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_314D = {.cps = (lxb_codepoint_t[]) {0x1111}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_314E = {.cps = (lxb_codepoint_t[]) {0x1112}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_314F = {.cps = (lxb_codepoint_t[]) {0x1161}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3150 = {.cps = (lxb_codepoint_t[]) {0x1162}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3151 = {.cps = (lxb_codepoint_t[]) {0x1163}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3152 = {.cps = (lxb_codepoint_t[]) {0x1164}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3153 = {.cps = (lxb_codepoint_t[]) {0x1165}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3154 = {.cps = (lxb_codepoint_t[]) {0x1166}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3155 = {.cps = (lxb_codepoint_t[]) {0x1167}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3156 = {.cps = (lxb_codepoint_t[]) {0x1168}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3157 = {.cps = (lxb_codepoint_t[]) {0x1169}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3158 = {.cps = (lxb_codepoint_t[]) {0x116A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3159 = {.cps = (lxb_codepoint_t[]) {0x116B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_315A = {.cps = (lxb_codepoint_t[]) {0x116C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_315B = {.cps = (lxb_codepoint_t[]) {0x116D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_315C = {.cps = (lxb_codepoint_t[]) {0x116E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_315D = {.cps = (lxb_codepoint_t[]) {0x116F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_315E = {.cps = (lxb_codepoint_t[]) {0x1170}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_315F = {.cps = (lxb_codepoint_t[]) {0x1171}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3160 = {.cps = (lxb_codepoint_t[]) {0x1172}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3161 = {.cps = (lxb_codepoint_t[]) {0x1173}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3162 = {.cps = (lxb_codepoint_t[]) {0x1174}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3163 = {.cps = (lxb_codepoint_t[]) {0x1175}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3165 = {.cps = (lxb_codepoint_t[]) {0x1114}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3166 = {.cps = (lxb_codepoint_t[]) {0x1115}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3167 = {.cps = (lxb_codepoint_t[]) {0x11C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3168 = {.cps = (lxb_codepoint_t[]) {0x11C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3169 = {.cps = (lxb_codepoint_t[]) {0x11CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_316A = {.cps = (lxb_codepoint_t[]) {0x11CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_316B = {.cps = (lxb_codepoint_t[]) {0x11D3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_316C = {.cps = (lxb_codepoint_t[]) {0x11D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_316D = {.cps = (lxb_codepoint_t[]) {0x11D9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_316E = {.cps = (lxb_codepoint_t[]) {0x111C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_316F = {.cps = (lxb_codepoint_t[]) {0x11DD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3170 = {.cps = (lxb_codepoint_t[]) {0x11DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3171 = {.cps = (lxb_codepoint_t[]) {0x111D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3172 = {.cps = (lxb_codepoint_t[]) {0x111E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3173 = {.cps = (lxb_codepoint_t[]) {0x1120}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3174 = {.cps = (lxb_codepoint_t[]) {0x1122}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3175 = {.cps = (lxb_codepoint_t[]) {0x1123}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3176 = {.cps = (lxb_codepoint_t[]) {0x1127}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3177 = {.cps = (lxb_codepoint_t[]) {0x1129}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3178 = {.cps = (lxb_codepoint_t[]) {0x112B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3179 = {.cps = (lxb_codepoint_t[]) {0x112C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_317A = {.cps = (lxb_codepoint_t[]) {0x112D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_317B = {.cps = (lxb_codepoint_t[]) {0x112E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_317C = {.cps = (lxb_codepoint_t[]) {0x112F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_317D = {.cps = (lxb_codepoint_t[]) {0x1132}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_317E = {.cps = (lxb_codepoint_t[]) {0x1136}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_317F = {.cps = (lxb_codepoint_t[]) {0x1140}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3180 = {.cps = (lxb_codepoint_t[]) {0x1147}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3181 = {.cps = (lxb_codepoint_t[]) {0x114C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3182 = {.cps = (lxb_codepoint_t[]) {0x11F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3183 = {.cps = (lxb_codepoint_t[]) {0x11F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3184 = {.cps = (lxb_codepoint_t[]) {0x1157}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3185 = {.cps = (lxb_codepoint_t[]) {0x1158}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3186 = {.cps = (lxb_codepoint_t[]) {0x1159}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3187 = {.cps = (lxb_codepoint_t[]) {0x1184}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3188 = {.cps = (lxb_codepoint_t[]) {0x1185}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3189 = {.cps = (lxb_codepoint_t[]) {0x1188}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_318A = {.cps = (lxb_codepoint_t[]) {0x1191}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_318B = {.cps = (lxb_codepoint_t[]) {0x1192}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_318C = {.cps = (lxb_codepoint_t[]) {0x1194}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_318D = {.cps = (lxb_codepoint_t[]) {0x119E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_318E = {.cps = (lxb_codepoint_t[]) {0x11A1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3192 = {.cps = (lxb_codepoint_t[]) {0x4E00}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3193 = {.cps = (lxb_codepoint_t[]) {0x4E8C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3194 = {.cps = (lxb_codepoint_t[]) {0x4E09}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3195 = {.cps = (lxb_codepoint_t[]) {0x56DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3196 = {.cps = (lxb_codepoint_t[]) {0x4E0A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3197 = {.cps = (lxb_codepoint_t[]) {0x4E2D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3198 = {.cps = (lxb_codepoint_t[]) {0x4E0B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3199 = {.cps = (lxb_codepoint_t[]) {0x7532}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_319A = {.cps = (lxb_codepoint_t[]) {0x4E59}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_319B = {.cps = (lxb_codepoint_t[]) {0x4E19}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_319C = {.cps = (lxb_codepoint_t[]) {0x4E01}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_319D = {.cps = (lxb_codepoint_t[]) {0x5929}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_319E = {.cps = (lxb_codepoint_t[]) {0x5730}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_319F = {.cps = (lxb_codepoint_t[]) {0x4EBA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3200 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1100, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3201 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1102, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3202 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1103, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3203 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1105, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3204 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1106, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3205 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1107, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3206 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1109, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3207 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x110B, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3208 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x110C, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3209 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x110E, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_320A = {.cps = (lxb_codepoint_t[]) {0x0028, 0x110F, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_320B = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1110, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_320C = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1111, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_320D = {.cps = (lxb_codepoint_t[]) {0x0028, 0x1112, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_320E = {.cps = (lxb_codepoint_t[]) {0x0028, 0xAC00, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_320F = {.cps = (lxb_codepoint_t[]) {0x0028, 0xB098, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3210 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xB2E4, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3211 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xB77C, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3212 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xB9C8, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3213 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xBC14, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3214 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xC0AC, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3215 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xC544, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3216 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xC790, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3217 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xCC28, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3218 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xCE74, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3219 = {.cps = (lxb_codepoint_t[]) {0x0028, 0xD0C0, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_321A = {.cps = (lxb_codepoint_t[]) {0x0028, 0xD30C, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_321B = {.cps = (lxb_codepoint_t[]) {0x0028, 0xD558, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_321C = {.cps = (lxb_codepoint_t[]) {0x0028, 0xC8FC, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_321D = {.cps = (lxb_codepoint_t[]) {0x0028, 0xC624, 0xC804, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_321E = {.cps = (lxb_codepoint_t[]) {0x0028, 0xC624, 0xD6C4, 0x0029}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3220 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4E00, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3221 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4E8C, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3222 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4E09, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3223 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x56DB, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3224 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4E94, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3225 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x516D, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3226 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4E03, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3227 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x516B, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3228 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4E5D, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3229 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x5341, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_322A = {.cps = (lxb_codepoint_t[]) {0x0028, 0x6708, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_322B = {.cps = (lxb_codepoint_t[]) {0x0028, 0x706B, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_322C = {.cps = (lxb_codepoint_t[]) {0x0028, 0x6C34, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_322D = {.cps = (lxb_codepoint_t[]) {0x0028, 0x6728, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_322E = {.cps = (lxb_codepoint_t[]) {0x0028, 0x91D1, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_322F = {.cps = (lxb_codepoint_t[]) {0x0028, 0x571F, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3230 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x65E5, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3231 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x682A, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3232 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x6709, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3233 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x793E, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3234 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x540D, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3235 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x7279, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3236 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x8CA1, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3237 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x795D, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3238 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x52B4, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3239 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4EE3, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_323A = {.cps = (lxb_codepoint_t[]) {0x0028, 0x547C, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_323B = {.cps = (lxb_codepoint_t[]) {0x0028, 0x5B66, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_323C = {.cps = (lxb_codepoint_t[]) {0x0028, 0x76E3, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_323D = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4F01, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_323E = {.cps = (lxb_codepoint_t[]) {0x0028, 0x8CC7, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_323F = {.cps = (lxb_codepoint_t[]) {0x0028, 0x5354, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3240 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x796D, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3241 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x4F11, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3242 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x81EA, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3243 = {.cps = (lxb_codepoint_t[]) {0x0028, 0x81F3, 0x0029}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3244 = {.cps = (lxb_codepoint_t[]) {0x554F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3245 = {.cps = (lxb_codepoint_t[]) {0x5E7C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3246 = {.cps = (lxb_codepoint_t[]) {0x6587}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3247 = {.cps = (lxb_codepoint_t[]) {0x7B8F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3250 = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0074, 0x0065}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3251 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0031}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3252 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0032}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3253 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0033}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3254 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0034}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3255 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0035}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3256 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0036}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3257 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0037}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3258 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0038}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3259 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0039}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_325A = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0030}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_325B = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0031}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_325C = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0032}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_325D = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0033}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_325E = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0034}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_325F = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0035}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3260 = {.cps = (lxb_codepoint_t[]) {0x1100}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3261 = {.cps = (lxb_codepoint_t[]) {0x1102}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3262 = {.cps = (lxb_codepoint_t[]) {0x1103}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3263 = {.cps = (lxb_codepoint_t[]) {0x1105}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3264 = {.cps = (lxb_codepoint_t[]) {0x1106}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3265 = {.cps = (lxb_codepoint_t[]) {0x1107}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3266 = {.cps = (lxb_codepoint_t[]) {0x1109}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3267 = {.cps = (lxb_codepoint_t[]) {0x110B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3268 = {.cps = (lxb_codepoint_t[]) {0x110C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3269 = {.cps = (lxb_codepoint_t[]) {0x110E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_326A = {.cps = (lxb_codepoint_t[]) {0x110F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_326B = {.cps = (lxb_codepoint_t[]) {0x1110}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_326C = {.cps = (lxb_codepoint_t[]) {0x1111}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_326D = {.cps = (lxb_codepoint_t[]) {0x1112}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_326E = {.cps = (lxb_codepoint_t[]) {0xAC00}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_326F = {.cps = (lxb_codepoint_t[]) {0xB098}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3270 = {.cps = (lxb_codepoint_t[]) {0xB2E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3271 = {.cps = (lxb_codepoint_t[]) {0xB77C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3272 = {.cps = (lxb_codepoint_t[]) {0xB9C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3273 = {.cps = (lxb_codepoint_t[]) {0xBC14}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3274 = {.cps = (lxb_codepoint_t[]) {0xC0AC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3275 = {.cps = (lxb_codepoint_t[]) {0xC544}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3276 = {.cps = (lxb_codepoint_t[]) {0xC790}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3277 = {.cps = (lxb_codepoint_t[]) {0xCC28}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3278 = {.cps = (lxb_codepoint_t[]) {0xCE74}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3279 = {.cps = (lxb_codepoint_t[]) {0xD0C0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_327A = {.cps = (lxb_codepoint_t[]) {0xD30C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_327B = {.cps = (lxb_codepoint_t[]) {0xD558}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_327C = {.cps = (lxb_codepoint_t[]) {0xCC38, 0xACE0}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_327D = {.cps = (lxb_codepoint_t[]) {0xC8FC, 0xC758}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_327E = {.cps = (lxb_codepoint_t[]) {0xC6B0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3280 = {.cps = (lxb_codepoint_t[]) {0x4E00}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3281 = {.cps = (lxb_codepoint_t[]) {0x4E8C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3282 = {.cps = (lxb_codepoint_t[]) {0x4E09}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3283 = {.cps = (lxb_codepoint_t[]) {0x56DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3284 = {.cps = (lxb_codepoint_t[]) {0x4E94}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3285 = {.cps = (lxb_codepoint_t[]) {0x516D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3286 = {.cps = (lxb_codepoint_t[]) {0x4E03}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3287 = {.cps = (lxb_codepoint_t[]) {0x516B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3288 = {.cps = (lxb_codepoint_t[]) {0x4E5D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3289 = {.cps = (lxb_codepoint_t[]) {0x5341}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_328A = {.cps = (lxb_codepoint_t[]) {0x6708}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_328B = {.cps = (lxb_codepoint_t[]) {0x706B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_328C = {.cps = (lxb_codepoint_t[]) {0x6C34}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_328D = {.cps = (lxb_codepoint_t[]) {0x6728}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_328E = {.cps = (lxb_codepoint_t[]) {0x91D1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_328F = {.cps = (lxb_codepoint_t[]) {0x571F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3290 = {.cps = (lxb_codepoint_t[]) {0x65E5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3291 = {.cps = (lxb_codepoint_t[]) {0x682A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3292 = {.cps = (lxb_codepoint_t[]) {0x6709}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3293 = {.cps = (lxb_codepoint_t[]) {0x793E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3294 = {.cps = (lxb_codepoint_t[]) {0x540D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3295 = {.cps = (lxb_codepoint_t[]) {0x7279}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3296 = {.cps = (lxb_codepoint_t[]) {0x8CA1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3297 = {.cps = (lxb_codepoint_t[]) {0x795D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3298 = {.cps = (lxb_codepoint_t[]) {0x52B4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3299 = {.cps = (lxb_codepoint_t[]) {0x79D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_329A = {.cps = (lxb_codepoint_t[]) {0x7537}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_329B = {.cps = (lxb_codepoint_t[]) {0x5973}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_329C = {.cps = (lxb_codepoint_t[]) {0x9069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_329D = {.cps = (lxb_codepoint_t[]) {0x512A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_329E = {.cps = (lxb_codepoint_t[]) {0x5370}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_329F = {.cps = (lxb_codepoint_t[]) {0x6CE8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A0 = {.cps = (lxb_codepoint_t[]) {0x9805}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A1 = {.cps = (lxb_codepoint_t[]) {0x4F11}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A2 = {.cps = (lxb_codepoint_t[]) {0x5199}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A3 = {.cps = (lxb_codepoint_t[]) {0x6B63}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A4 = {.cps = (lxb_codepoint_t[]) {0x4E0A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A5 = {.cps = (lxb_codepoint_t[]) {0x4E2D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A6 = {.cps = (lxb_codepoint_t[]) {0x4E0B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A7 = {.cps = (lxb_codepoint_t[]) {0x5DE6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A8 = {.cps = (lxb_codepoint_t[]) {0x53F3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32A9 = {.cps = (lxb_codepoint_t[]) {0x533B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32AA = {.cps = (lxb_codepoint_t[]) {0x5B97}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32AB = {.cps = (lxb_codepoint_t[]) {0x5B66}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32AC = {.cps = (lxb_codepoint_t[]) {0x76E3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32AD = {.cps = (lxb_codepoint_t[]) {0x4F01}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32AE = {.cps = (lxb_codepoint_t[]) {0x8CC7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32AF = {.cps = (lxb_codepoint_t[]) {0x5354}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B0 = {.cps = (lxb_codepoint_t[]) {0x591C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B1 = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0036}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B2 = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0037}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B3 = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0038}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B4 = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0039}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B5 = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0030}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B6 = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0031}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B7 = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0032}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B8 = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0033}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32B9 = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0034}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32BA = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0035}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32BB = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0036}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32BC = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0037}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32BD = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0038}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32BE = {.cps = (lxb_codepoint_t[]) {0x0034, 0x0039}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32BF = {.cps = (lxb_codepoint_t[]) {0x0035, 0x0030}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C0 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C1 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C2 = {.cps = (lxb_codepoint_t[]) {0x0033, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C3 = {.cps = (lxb_codepoint_t[]) {0x0034, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C4 = {.cps = (lxb_codepoint_t[]) {0x0035, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C5 = {.cps = (lxb_codepoint_t[]) {0x0036, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C6 = {.cps = (lxb_codepoint_t[]) {0x0037, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C7 = {.cps = (lxb_codepoint_t[]) {0x0038, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C8 = {.cps = (lxb_codepoint_t[]) {0x0039, 0x6708}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32C9 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0030, 0x6708}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32CA = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0031, 0x6708}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32CB = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0032, 0x6708}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32CC = {.cps = (lxb_codepoint_t[]) {0x0068, 0x0067}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32CD = {.cps = (lxb_codepoint_t[]) {0x0065, 0x0072, 0x0067}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32CE = {.cps = (lxb_codepoint_t[]) {0x0065, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32CF = {.cps = (lxb_codepoint_t[]) {0x006C, 0x0074, 0x0064}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D0 = {.cps = (lxb_codepoint_t[]) {0x30A2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D1 = {.cps = (lxb_codepoint_t[]) {0x30A4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D2 = {.cps = (lxb_codepoint_t[]) {0x30A6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D3 = {.cps = (lxb_codepoint_t[]) {0x30A8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D4 = {.cps = (lxb_codepoint_t[]) {0x30AA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D5 = {.cps = (lxb_codepoint_t[]) {0x30AB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D6 = {.cps = (lxb_codepoint_t[]) {0x30AD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D7 = {.cps = (lxb_codepoint_t[]) {0x30AF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D8 = {.cps = (lxb_codepoint_t[]) {0x30B1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32D9 = {.cps = (lxb_codepoint_t[]) {0x30B3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32DA = {.cps = (lxb_codepoint_t[]) {0x30B5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32DB = {.cps = (lxb_codepoint_t[]) {0x30B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32DC = {.cps = (lxb_codepoint_t[]) {0x30B9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32DD = {.cps = (lxb_codepoint_t[]) {0x30BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32DE = {.cps = (lxb_codepoint_t[]) {0x30BD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32DF = {.cps = (lxb_codepoint_t[]) {0x30BF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E0 = {.cps = (lxb_codepoint_t[]) {0x30C1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E1 = {.cps = (lxb_codepoint_t[]) {0x30C4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E2 = {.cps = (lxb_codepoint_t[]) {0x30C6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E3 = {.cps = (lxb_codepoint_t[]) {0x30C8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E4 = {.cps = (lxb_codepoint_t[]) {0x30CA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E5 = {.cps = (lxb_codepoint_t[]) {0x30CB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E6 = {.cps = (lxb_codepoint_t[]) {0x30CC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E7 = {.cps = (lxb_codepoint_t[]) {0x30CD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E8 = {.cps = (lxb_codepoint_t[]) {0x30CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32E9 = {.cps = (lxb_codepoint_t[]) {0x30CF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32EA = {.cps = (lxb_codepoint_t[]) {0x30D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32EB = {.cps = (lxb_codepoint_t[]) {0x30D5}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32EC = {.cps = (lxb_codepoint_t[]) {0x30D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32ED = {.cps = (lxb_codepoint_t[]) {0x30DB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32EE = {.cps = (lxb_codepoint_t[]) {0x30DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32EF = {.cps = (lxb_codepoint_t[]) {0x30DF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F0 = {.cps = (lxb_codepoint_t[]) {0x30E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F1 = {.cps = (lxb_codepoint_t[]) {0x30E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F2 = {.cps = (lxb_codepoint_t[]) {0x30E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F3 = {.cps = (lxb_codepoint_t[]) {0x30E4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F4 = {.cps = (lxb_codepoint_t[]) {0x30E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F5 = {.cps = (lxb_codepoint_t[]) {0x30E8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F6 = {.cps = (lxb_codepoint_t[]) {0x30E9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F7 = {.cps = (lxb_codepoint_t[]) {0x30EA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F8 = {.cps = (lxb_codepoint_t[]) {0x30EB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32F9 = {.cps = (lxb_codepoint_t[]) {0x30EC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32FA = {.cps = (lxb_codepoint_t[]) {0x30ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32FB = {.cps = (lxb_codepoint_t[]) {0x30EF}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32FC = {.cps = (lxb_codepoint_t[]) {0x30F0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32FD = {.cps = (lxb_codepoint_t[]) {0x30F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32FE = {.cps = (lxb_codepoint_t[]) {0x30F2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_32FF = {.cps = (lxb_codepoint_t[]) {0x4EE4, 0x548C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3300 = {.cps = (lxb_codepoint_t[]) {0x30A2, 0x30D1, 0x30FC, 0x30C8}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3301 = {.cps = (lxb_codepoint_t[]) {0x30A2, 0x30EB, 0x30D5, 0x30A1}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3302 = {.cps = (lxb_codepoint_t[]) {0x30A2, 0x30F3, 0x30DA, 0x30A2}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3303 = {.cps = (lxb_codepoint_t[]) {0x30A2, 0x30FC, 0x30EB}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3304 = {.cps = (lxb_codepoint_t[]) {0x30A4, 0x30CB, 0x30F3, 0x30B0}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3305 = {.cps = (lxb_codepoint_t[]) {0x30A4, 0x30F3, 0x30C1}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3306 = {.cps = (lxb_codepoint_t[]) {0x30A6, 0x30A9, 0x30F3}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3307 = {.cps = (lxb_codepoint_t[]) {0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3308 = {.cps = (lxb_codepoint_t[]) {0x30A8, 0x30FC, 0x30AB, 0x30FC}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3309 = {.cps = (lxb_codepoint_t[]) {0x30AA, 0x30F3, 0x30B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_330A = {.cps = (lxb_codepoint_t[]) {0x30AA, 0x30FC, 0x30E0}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_330B = {.cps = (lxb_codepoint_t[]) {0x30AB, 0x30A4, 0x30EA}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_330C = {.cps = (lxb_codepoint_t[]) {0x30AB, 0x30E9, 0x30C3, 0x30C8}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_330D = {.cps = (lxb_codepoint_t[]) {0x30AB, 0x30ED, 0x30EA, 0x30FC}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_330E = {.cps = (lxb_codepoint_t[]) {0x30AC, 0x30ED, 0x30F3}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_330F = {.cps = (lxb_codepoint_t[]) {0x30AC, 0x30F3, 0x30DE}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3310 = {.cps = (lxb_codepoint_t[]) {0x30AE, 0x30AC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3311 = {.cps = (lxb_codepoint_t[]) {0x30AE, 0x30CB, 0x30FC}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3312 = {.cps = (lxb_codepoint_t[]) {0x30AD, 0x30E5, 0x30EA, 0x30FC}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3313 = {.cps = (lxb_codepoint_t[]) {0x30AE, 0x30EB, 0x30C0, 0x30FC}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3314 = {.cps = (lxb_codepoint_t[]) {0x30AD, 0x30ED}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3315 = {.cps = (lxb_codepoint_t[]) {0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3316 = {.cps = (lxb_codepoint_t[]) {0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB}, .length = 6};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3317 = {.cps = (lxb_codepoint_t[]) {0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3318 = {.cps = (lxb_codepoint_t[]) {0x30B0, 0x30E9, 0x30E0}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3319 = {.cps = (lxb_codepoint_t[]) {0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_331A = {.cps = (lxb_codepoint_t[]) {0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_331B = {.cps = (lxb_codepoint_t[]) {0x30AF, 0x30ED, 0x30FC, 0x30CD}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_331C = {.cps = (lxb_codepoint_t[]) {0x30B1, 0x30FC, 0x30B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_331D = {.cps = (lxb_codepoint_t[]) {0x30B3, 0x30EB, 0x30CA}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_331E = {.cps = (lxb_codepoint_t[]) {0x30B3, 0x30FC, 0x30DD}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_331F = {.cps = (lxb_codepoint_t[]) {0x30B5, 0x30A4, 0x30AF, 0x30EB}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3320 = {.cps = (lxb_codepoint_t[]) {0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3321 = {.cps = (lxb_codepoint_t[]) {0x30B7, 0x30EA, 0x30F3, 0x30B0}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3322 = {.cps = (lxb_codepoint_t[]) {0x30BB, 0x30F3, 0x30C1}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3323 = {.cps = (lxb_codepoint_t[]) {0x30BB, 0x30F3, 0x30C8}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3324 = {.cps = (lxb_codepoint_t[]) {0x30C0, 0x30FC, 0x30B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3325 = {.cps = (lxb_codepoint_t[]) {0x30C7, 0x30B7}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3326 = {.cps = (lxb_codepoint_t[]) {0x30C9, 0x30EB}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3327 = {.cps = (lxb_codepoint_t[]) {0x30C8, 0x30F3}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3328 = {.cps = (lxb_codepoint_t[]) {0x30CA, 0x30CE}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3329 = {.cps = (lxb_codepoint_t[]) {0x30CE, 0x30C3, 0x30C8}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_332A = {.cps = (lxb_codepoint_t[]) {0x30CF, 0x30A4, 0x30C4}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_332B = {.cps = (lxb_codepoint_t[]) {0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_332C = {.cps = (lxb_codepoint_t[]) {0x30D1, 0x30FC, 0x30C4}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_332D = {.cps = (lxb_codepoint_t[]) {0x30D0, 0x30FC, 0x30EC, 0x30EB}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_332E = {.cps = (lxb_codepoint_t[]) {0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_332F = {.cps = (lxb_codepoint_t[]) {0x30D4, 0x30AF, 0x30EB}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3330 = {.cps = (lxb_codepoint_t[]) {0x30D4, 0x30B3}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3331 = {.cps = (lxb_codepoint_t[]) {0x30D3, 0x30EB}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3332 = {.cps = (lxb_codepoint_t[]) {0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3333 = {.cps = (lxb_codepoint_t[]) {0x30D5, 0x30A3, 0x30FC, 0x30C8}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3334 = {.cps = (lxb_codepoint_t[]) {0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3335 = {.cps = (lxb_codepoint_t[]) {0x30D5, 0x30E9, 0x30F3}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3336 = {.cps = (lxb_codepoint_t[]) {0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3337 = {.cps = (lxb_codepoint_t[]) {0x30DA, 0x30BD}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3338 = {.cps = (lxb_codepoint_t[]) {0x30DA, 0x30CB, 0x30D2}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3339 = {.cps = (lxb_codepoint_t[]) {0x30D8, 0x30EB, 0x30C4}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_333A = {.cps = (lxb_codepoint_t[]) {0x30DA, 0x30F3, 0x30B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_333B = {.cps = (lxb_codepoint_t[]) {0x30DA, 0x30FC, 0x30B8}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_333C = {.cps = (lxb_codepoint_t[]) {0x30D9, 0x30FC, 0x30BF}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_333D = {.cps = (lxb_codepoint_t[]) {0x30DD, 0x30A4, 0x30F3, 0x30C8}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_333E = {.cps = (lxb_codepoint_t[]) {0x30DC, 0x30EB, 0x30C8}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_333F = {.cps = (lxb_codepoint_t[]) {0x30DB, 0x30F3}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3340 = {.cps = (lxb_codepoint_t[]) {0x30DD, 0x30F3, 0x30C9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3341 = {.cps = (lxb_codepoint_t[]) {0x30DB, 0x30FC, 0x30EB}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3342 = {.cps = (lxb_codepoint_t[]) {0x30DB, 0x30FC, 0x30F3}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3343 = {.cps = (lxb_codepoint_t[]) {0x30DE, 0x30A4, 0x30AF, 0x30ED}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3344 = {.cps = (lxb_codepoint_t[]) {0x30DE, 0x30A4, 0x30EB}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3345 = {.cps = (lxb_codepoint_t[]) {0x30DE, 0x30C3, 0x30CF}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3346 = {.cps = (lxb_codepoint_t[]) {0x30DE, 0x30EB, 0x30AF}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3347 = {.cps = (lxb_codepoint_t[]) {0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3348 = {.cps = (lxb_codepoint_t[]) {0x30DF, 0x30AF, 0x30ED, 0x30F3}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3349 = {.cps = (lxb_codepoint_t[]) {0x30DF, 0x30EA}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_334A = {.cps = (lxb_codepoint_t[]) {0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_334B = {.cps = (lxb_codepoint_t[]) {0x30E1, 0x30AC}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_334C = {.cps = (lxb_codepoint_t[]) {0x30E1, 0x30AC, 0x30C8, 0x30F3}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_334D = {.cps = (lxb_codepoint_t[]) {0x30E1, 0x30FC, 0x30C8, 0x30EB}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_334E = {.cps = (lxb_codepoint_t[]) {0x30E4, 0x30FC, 0x30C9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_334F = {.cps = (lxb_codepoint_t[]) {0x30E4, 0x30FC, 0x30EB}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3350 = {.cps = (lxb_codepoint_t[]) {0x30E6, 0x30A2, 0x30F3}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3351 = {.cps = (lxb_codepoint_t[]) {0x30EA, 0x30C3, 0x30C8, 0x30EB}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3352 = {.cps = (lxb_codepoint_t[]) {0x30EA, 0x30E9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3353 = {.cps = (lxb_codepoint_t[]) {0x30EB, 0x30D4, 0x30FC}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3354 = {.cps = (lxb_codepoint_t[]) {0x30EB, 0x30FC, 0x30D6, 0x30EB}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3355 = {.cps = (lxb_codepoint_t[]) {0x30EC, 0x30E0}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3356 = {.cps = (lxb_codepoint_t[]) {0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3357 = {.cps = (lxb_codepoint_t[]) {0x30EF, 0x30C3, 0x30C8}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3358 = {.cps = (lxb_codepoint_t[]) {0x0030, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3359 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_335A = {.cps = (lxb_codepoint_t[]) {0x0032, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_335B = {.cps = (lxb_codepoint_t[]) {0x0033, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_335C = {.cps = (lxb_codepoint_t[]) {0x0034, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_335D = {.cps = (lxb_codepoint_t[]) {0x0035, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_335E = {.cps = (lxb_codepoint_t[]) {0x0036, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_335F = {.cps = (lxb_codepoint_t[]) {0x0037, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3360 = {.cps = (lxb_codepoint_t[]) {0x0038, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3361 = {.cps = (lxb_codepoint_t[]) {0x0039, 0x70B9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3362 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0030, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3363 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0031, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3364 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0032, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3365 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0033, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3366 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0034, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3367 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0035, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3368 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0036, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3369 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0037, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_336A = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0038, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_336B = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0039, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_336C = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0030, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_336D = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0031, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_336E = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0032, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_336F = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0033, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3370 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0034, 0x70B9}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3371 = {.cps = (lxb_codepoint_t[]) {0x0068, 0x0070, 0x0061}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3372 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x0061}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3373 = {.cps = (lxb_codepoint_t[]) {0x0061, 0x0075}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3374 = {.cps = (lxb_codepoint_t[]) {0x0062, 0x0061, 0x0072}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3375 = {.cps = (lxb_codepoint_t[]) {0x006F, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3376 = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0063}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3377 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3378 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x006D, 0x0032}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3379 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x006D, 0x0033}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_337A = {.cps = (lxb_codepoint_t[]) {0x0069, 0x0075}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_337B = {.cps = (lxb_codepoint_t[]) {0x5E73, 0x6210}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_337C = {.cps = (lxb_codepoint_t[]) {0x662D, 0x548C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_337D = {.cps = (lxb_codepoint_t[]) {0x5927, 0x6B63}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_337E = {.cps = (lxb_codepoint_t[]) {0x660E, 0x6CBB}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_337F = {.cps = (lxb_codepoint_t[]) {0x682A, 0x5F0F, 0x4F1A, 0x793E}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3380 = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0061}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3381 = {.cps = (lxb_codepoint_t[]) {0x006E, 0x0061}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3382 = {.cps = (lxb_codepoint_t[]) {0x03BC, 0x0061}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3383 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0061}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3384 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0061}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3385 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0062}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3386 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0062}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3387 = {.cps = (lxb_codepoint_t[]) {0x0067, 0x0062}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3388 = {.cps = (lxb_codepoint_t[]) {0x0063, 0x0061, 0x006C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3389 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0063, 0x0061, 0x006C}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_338A = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0066}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_338B = {.cps = (lxb_codepoint_t[]) {0x006E, 0x0066}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_338C = {.cps = (lxb_codepoint_t[]) {0x03BC, 0x0066}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_338D = {.cps = (lxb_codepoint_t[]) {0x03BC, 0x0067}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_338E = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0067}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_338F = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0067}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3390 = {.cps = (lxb_codepoint_t[]) {0x0068, 0x007A}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3391 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0068, 0x007A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3392 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0068, 0x007A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3393 = {.cps = (lxb_codepoint_t[]) {0x0067, 0x0068, 0x007A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3394 = {.cps = (lxb_codepoint_t[]) {0x0074, 0x0068, 0x007A}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3395 = {.cps = (lxb_codepoint_t[]) {0x03BC, 0x006C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3396 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x006C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3397 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x006C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3398 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x006C}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_3399 = {.cps = (lxb_codepoint_t[]) {0x0066, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_339A = {.cps = (lxb_codepoint_t[]) {0x006E, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_339B = {.cps = (lxb_codepoint_t[]) {0x03BC, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_339C = {.cps = (lxb_codepoint_t[]) {0x006D, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_339D = {.cps = (lxb_codepoint_t[]) {0x0063, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_339E = {.cps = (lxb_codepoint_t[]) {0x006B, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_339F = {.cps = (lxb_codepoint_t[]) {0x006D, 0x006D, 0x0032}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A0 = {.cps = (lxb_codepoint_t[]) {0x0063, 0x006D, 0x0032}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A1 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0032}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A2 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x006D, 0x0032}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A3 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x006D, 0x0033}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A4 = {.cps = (lxb_codepoint_t[]) {0x0063, 0x006D, 0x0033}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A5 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0033}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A6 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x006D, 0x0033}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A7 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x2215, 0x0073}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A8 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x2215, 0x0073, 0x0032}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33A9 = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0061}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33AA = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0070, 0x0061}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33AB = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0070, 0x0061}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33AC = {.cps = (lxb_codepoint_t[]) {0x0067, 0x0070, 0x0061}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33AD = {.cps = (lxb_codepoint_t[]) {0x0072, 0x0061, 0x0064}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33AE = {.cps = (lxb_codepoint_t[]) {0x0072, 0x0061, 0x0064, 0x2215, 0x0073}, .length = 5};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33AF = {.cps = (lxb_codepoint_t[]) {0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0032}, .length = 6};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B0 = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0073}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B1 = {.cps = (lxb_codepoint_t[]) {0x006E, 0x0073}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B2 = {.cps = (lxb_codepoint_t[]) {0x03BC, 0x0073}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B3 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0073}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B4 = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B5 = {.cps = (lxb_codepoint_t[]) {0x006E, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B6 = {.cps = (lxb_codepoint_t[]) {0x03BC, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B7 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B8 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33B9 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33BA = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0077}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33BB = {.cps = (lxb_codepoint_t[]) {0x006E, 0x0077}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33BC = {.cps = (lxb_codepoint_t[]) {0x03BC, 0x0077}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33BD = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0077}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33BE = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0077}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33BF = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0077}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33C0 = {.cps = (lxb_codepoint_t[]) {0x006B, 0x03C9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33C1 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x03C9}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33C3 = {.cps = (lxb_codepoint_t[]) {0x0062, 0x0071}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33C4 = {.cps = (lxb_codepoint_t[]) {0x0063, 0x0063}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33C5 = {.cps = (lxb_codepoint_t[]) {0x0063, 0x0064}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33C6 = {.cps = (lxb_codepoint_t[]) {0x0063, 0x2215, 0x006B, 0x0067}, .length = 4};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33C8 = {.cps = (lxb_codepoint_t[]) {0x0064, 0x0062}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33C9 = {.cps = (lxb_codepoint_t[]) {0x0067, 0x0079}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33CA = {.cps = (lxb_codepoint_t[]) {0x0068, 0x0061}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33CB = {.cps = (lxb_codepoint_t[]) {0x0068, 0x0070}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33CC = {.cps = (lxb_codepoint_t[]) {0x0069, 0x006E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33CD = {.cps = (lxb_codepoint_t[]) {0x006B, 0x006B}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33CE = {.cps = (lxb_codepoint_t[]) {0x006B, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33CF = {.cps = (lxb_codepoint_t[]) {0x006B, 0x0074}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D0 = {.cps = (lxb_codepoint_t[]) {0x006C, 0x006D}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D1 = {.cps = (lxb_codepoint_t[]) {0x006C, 0x006E}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D2 = {.cps = (lxb_codepoint_t[]) {0x006C, 0x006F, 0x0067}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D3 = {.cps = (lxb_codepoint_t[]) {0x006C, 0x0078}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D4 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0062}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D5 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x0069, 0x006C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D6 = {.cps = (lxb_codepoint_t[]) {0x006D, 0x006F, 0x006C}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D7 = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0068}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33D9 = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0070, 0x006D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33DA = {.cps = (lxb_codepoint_t[]) {0x0070, 0x0072}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33DB = {.cps = (lxb_codepoint_t[]) {0x0073, 0x0072}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33DC = {.cps = (lxb_codepoint_t[]) {0x0073, 0x0076}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33DD = {.cps = (lxb_codepoint_t[]) {0x0077, 0x0062}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33DE = {.cps = (lxb_codepoint_t[]) {0x0076, 0x2215, 0x006D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33DF = {.cps = (lxb_codepoint_t[]) {0x0061, 0x2215, 0x006D}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E0 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E1 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E2 = {.cps = (lxb_codepoint_t[]) {0x0033, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E3 = {.cps = (lxb_codepoint_t[]) {0x0034, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E4 = {.cps = (lxb_codepoint_t[]) {0x0035, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E5 = {.cps = (lxb_codepoint_t[]) {0x0036, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E6 = {.cps = (lxb_codepoint_t[]) {0x0037, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E7 = {.cps = (lxb_codepoint_t[]) {0x0038, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E8 = {.cps = (lxb_codepoint_t[]) {0x0039, 0x65E5}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33E9 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0030, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33EA = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0031, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33EB = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0032, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33EC = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0033, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33ED = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0034, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33EE = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0035, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33EF = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0036, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F0 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0037, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F1 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0038, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F2 = {.cps = (lxb_codepoint_t[]) {0x0031, 0x0039, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F3 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0030, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F4 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0031, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F5 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0032, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F6 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0033, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F7 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0034, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F8 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0035, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33F9 = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0036, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33FA = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0037, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33FB = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0038, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33FC = {.cps = (lxb_codepoint_t[]) {0x0032, 0x0039, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33FD = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0030, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33FE = {.cps = (lxb_codepoint_t[]) {0x0033, 0x0031, 0x65E5}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_33FF = {.cps = (lxb_codepoint_t[]) {0x0067, 0x0061, 0x006C}, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2A0C[4] = {0x222B, 0x222B, 0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2A0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2A0C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2A0C[4] = {0x222B, 0x222B, 0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2A0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2A0C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2A0C[4] = {0x222B, 0x222B, 0x222B, 0x222B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2A0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2A0C, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_2A0C = {.cp = 0x2A0C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2A0C, .cde = &lxb_unicode_decomposition_c_2A0C, .kde = &lxb_unicode_decomposition_k_2A0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2A74[3] = {0x003A, 0x003A, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2A74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2A74, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2A74[3] = {0x003A, 0x003A, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2A74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2A74, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2A74[3] = {0x003A, 0x003A, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2A74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2A74, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2A74 = {.cp = 0x2A74, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2A74, .cde = &lxb_unicode_decomposition_c_2A74, .kde = &lxb_unicode_decomposition_k_2A74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2A75[2] = {0x003D, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2A75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2A75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2A75[2] = {0x003D, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2A75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2A75, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2A75[2] = {0x003D, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2A75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2A75, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2A75 = {.cp = 0x2A75, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2A75, .cde = &lxb_unicode_decomposition_c_2A75, .kde = &lxb_unicode_decomposition_k_2A75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2A76[3] = {0x003D, 0x003D, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2A76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2A76, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2A76[3] = {0x003D, 0x003D, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2A76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2A76, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2A76[3] = {0x003D, 0x003D, 0x003D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2A76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2A76, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_2A76 = {.cp = 0x2A76, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2A76, .cde = &lxb_unicode_decomposition_c_2A76, .kde = &lxb_unicode_decomposition_k_2A76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2ADC[2] = {0x2ADD, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2ADC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2ADC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2ADC[2] = {0x2ADD, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2ADC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2ADC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2ADC[2] = {0x2ADD, 0x0338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2ADC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2ADC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_2ADC = {.cp = 0x2ADC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2ADC, .cde = &lxb_unicode_decomposition_c_2ADC, .kde = &lxb_unicode_decomposition_k_2ADC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2C7C[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2C7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_c_2C7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2C7C[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2C7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp_k_2C7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2C7C[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2C7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUB, .mapping = lxb_unicode_decomposition_cp__2C7C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2C7C = {.cp = 0x2C7C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2C7C, .cde = &lxb_unicode_decomposition_c_2C7C, .kde = &lxb_unicode_decomposition_k_2C7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2C7D[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2C7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2C7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2C7D[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2C7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2C7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2C7D[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2C7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2C7D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2C7D = {.cp = 0x2C7D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2C7D, .cde = &lxb_unicode_decomposition_c_2C7D, .kde = &lxb_unicode_decomposition_k_2C7D};

static const lxb_unicode_entry_t lxb_unicode_entry_2CEF = {.cp = 0x2CEF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2CF0 = {.cp = 0x2CF0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2CF1 = {.cp = 0x2CF1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2D6F[1] = {0x2D61};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2D6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_2D6F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2D6F[1] = {0x2D61};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2D6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_2D6F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2D6F[1] = {0x2D61};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2D6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__2D6F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2D6F = {.cp = 0x2D6F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2D6F, .cde = &lxb_unicode_decomposition_c_2D6F, .kde = &lxb_unicode_decomposition_k_2D6F};

static const lxb_unicode_entry_t lxb_unicode_entry_2D7F = {.cp = 0x2D7F, .ccc = 9, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE0 = {.cp = 0x2DE0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE1 = {.cp = 0x2DE1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE2 = {.cp = 0x2DE2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE3 = {.cp = 0x2DE3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE4 = {.cp = 0x2DE4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE5 = {.cp = 0x2DE5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE6 = {.cp = 0x2DE6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE7 = {.cp = 0x2DE7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE8 = {.cp = 0x2DE8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DE9 = {.cp = 0x2DE9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DEA = {.cp = 0x2DEA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DEB = {.cp = 0x2DEB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DEC = {.cp = 0x2DEC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DED = {.cp = 0x2DED, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DEE = {.cp = 0x2DEE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DEF = {.cp = 0x2DEF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF0 = {.cp = 0x2DF0, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF1 = {.cp = 0x2DF1, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF2 = {.cp = 0x2DF2, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF3 = {.cp = 0x2DF3, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF4 = {.cp = 0x2DF4, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF5 = {.cp = 0x2DF5, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF6 = {.cp = 0x2DF6, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF7 = {.cp = 0x2DF7, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF8 = {.cp = 0x2DF8, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DF9 = {.cp = 0x2DF9, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DFA = {.cp = 0x2DFA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DFB = {.cp = 0x2DFB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DFC = {.cp = 0x2DFC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DFD = {.cp = 0x2DFD, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DFE = {.cp = 0x2DFE, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_2DFF = {.cp = 0x2DFF, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2E9F[1] = {0x6BCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2E9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2E9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2E9F[1] = {0x6BCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2E9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2E9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2E9F[1] = {0x6BCD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2E9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2E9F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2E9F = {.cp = 0x2E9F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2E9F, .cde = &lxb_unicode_decomposition_c_2E9F, .kde = &lxb_unicode_decomposition_k_2E9F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2EF3[1] = {0x9F9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2EF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2EF3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2EF3[1] = {0x9F9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2EF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2EF3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2EF3[1] = {0x9F9F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2EF3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2EF3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2EF3 = {.cp = 0x2EF3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2EF3, .cde = &lxb_unicode_decomposition_c_2EF3, .kde = &lxb_unicode_decomposition_k_2EF3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F00[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F00, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F00[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F00, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F00[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F00, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F00 = {.cp = 0x2F00, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F00, .cde = &lxb_unicode_decomposition_c_2F00, .kde = &lxb_unicode_decomposition_k_2F00};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F01[1] = {0x4E28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F01, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F01[1] = {0x4E28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F01, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F01[1] = {0x4E28};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F01, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F01 = {.cp = 0x2F01, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F01, .cde = &lxb_unicode_decomposition_c_2F01, .kde = &lxb_unicode_decomposition_k_2F01};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F02[1] = {0x4E36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F02, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F02[1] = {0x4E36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F02, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F02[1] = {0x4E36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F02, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F02 = {.cp = 0x2F02, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F02, .cde = &lxb_unicode_decomposition_c_2F02, .kde = &lxb_unicode_decomposition_k_2F02};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F03[1] = {0x4E3F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F03, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F03[1] = {0x4E3F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F03, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F03[1] = {0x4E3F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F03, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F03 = {.cp = 0x2F03, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F03, .cde = &lxb_unicode_decomposition_c_2F03, .kde = &lxb_unicode_decomposition_k_2F03};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F04[1] = {0x4E59};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F04, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F04[1] = {0x4E59};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F04, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F04[1] = {0x4E59};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F04, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F04 = {.cp = 0x2F04, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F04, .cde = &lxb_unicode_decomposition_c_2F04, .kde = &lxb_unicode_decomposition_k_2F04};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F05[1] = {0x4E85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F05, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F05[1] = {0x4E85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F05, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F05[1] = {0x4E85};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F05, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F05 = {.cp = 0x2F05, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F05, .cde = &lxb_unicode_decomposition_c_2F05, .kde = &lxb_unicode_decomposition_k_2F05};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F06[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F06, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F06[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F06, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F06[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F06, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F06 = {.cp = 0x2F06, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F06, .cde = &lxb_unicode_decomposition_c_2F06, .kde = &lxb_unicode_decomposition_k_2F06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F07[1] = {0x4EA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F07, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F07[1] = {0x4EA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F07, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F07[1] = {0x4EA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F07, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F07 = {.cp = 0x2F07, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F07, .cde = &lxb_unicode_decomposition_c_2F07, .kde = &lxb_unicode_decomposition_k_2F07};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F08[1] = {0x4EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F08, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F08[1] = {0x4EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F08, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F08[1] = {0x4EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F08, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F08 = {.cp = 0x2F08, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F08, .cde = &lxb_unicode_decomposition_c_2F08, .kde = &lxb_unicode_decomposition_k_2F08};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F09[1] = {0x513F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F09, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F09[1] = {0x513F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F09, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F09[1] = {0x513F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F09, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F09 = {.cp = 0x2F09, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F09, .cde = &lxb_unicode_decomposition_c_2F09, .kde = &lxb_unicode_decomposition_k_2F09};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F0A[1] = {0x5165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F0A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F0A[1] = {0x5165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F0A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F0A[1] = {0x5165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F0A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F0A = {.cp = 0x2F0A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F0A, .cde = &lxb_unicode_decomposition_c_2F0A, .kde = &lxb_unicode_decomposition_k_2F0A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F0B[1] = {0x516B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F0B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F0B[1] = {0x516B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F0B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F0B[1] = {0x516B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F0B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F0B = {.cp = 0x2F0B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F0B, .cde = &lxb_unicode_decomposition_c_2F0B, .kde = &lxb_unicode_decomposition_k_2F0B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F0C[1] = {0x5182};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F0C[1] = {0x5182};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F0C[1] = {0x5182};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F0C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F0C = {.cp = 0x2F0C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F0C, .cde = &lxb_unicode_decomposition_c_2F0C, .kde = &lxb_unicode_decomposition_k_2F0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F0D[1] = {0x5196};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F0D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F0D[1] = {0x5196};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F0D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F0D[1] = {0x5196};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F0D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F0D = {.cp = 0x2F0D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F0D, .cde = &lxb_unicode_decomposition_c_2F0D, .kde = &lxb_unicode_decomposition_k_2F0D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F0E[1] = {0x51AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F0E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F0E[1] = {0x51AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F0E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F0E[1] = {0x51AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F0E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F0E = {.cp = 0x2F0E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F0E, .cde = &lxb_unicode_decomposition_c_2F0E, .kde = &lxb_unicode_decomposition_k_2F0E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F0F[1] = {0x51E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F0F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F0F[1] = {0x51E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F0F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F0F[1] = {0x51E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F0F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F0F = {.cp = 0x2F0F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F0F, .cde = &lxb_unicode_decomposition_c_2F0F, .kde = &lxb_unicode_decomposition_k_2F0F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F10[1] = {0x51F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F10[1] = {0x51F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F10[1] = {0x51F5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F10, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F10 = {.cp = 0x2F10, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F10, .cde = &lxb_unicode_decomposition_c_2F10, .kde = &lxb_unicode_decomposition_k_2F10};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F11[1] = {0x5200};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F11, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F11[1] = {0x5200};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F11, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F11[1] = {0x5200};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F11, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F11 = {.cp = 0x2F11, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F11, .cde = &lxb_unicode_decomposition_c_2F11, .kde = &lxb_unicode_decomposition_k_2F11};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F12[1] = {0x529B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F12[1] = {0x529B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F12[1] = {0x529B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F12, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F12 = {.cp = 0x2F12, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F12, .cde = &lxb_unicode_decomposition_c_2F12, .kde = &lxb_unicode_decomposition_k_2F12};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F13[1] = {0x52F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F13, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F13[1] = {0x52F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F13, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F13[1] = {0x52F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F13, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F13 = {.cp = 0x2F13, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F13, .cde = &lxb_unicode_decomposition_c_2F13, .kde = &lxb_unicode_decomposition_k_2F13};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F14[1] = {0x5315};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F14, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F14[1] = {0x5315};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F14, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F14[1] = {0x5315};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F14, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F14 = {.cp = 0x2F14, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F14, .cde = &lxb_unicode_decomposition_c_2F14, .kde = &lxb_unicode_decomposition_k_2F14};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F15[1] = {0x531A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F15[1] = {0x531A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F15[1] = {0x531A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F15, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F15 = {.cp = 0x2F15, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F15, .cde = &lxb_unicode_decomposition_c_2F15, .kde = &lxb_unicode_decomposition_k_2F15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F16[1] = {0x5338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F16[1] = {0x5338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F16[1] = {0x5338};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F16, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F16 = {.cp = 0x2F16, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F16, .cde = &lxb_unicode_decomposition_c_2F16, .kde = &lxb_unicode_decomposition_k_2F16};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F17[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F17[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F17[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F17, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F17 = {.cp = 0x2F17, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F17, .cde = &lxb_unicode_decomposition_c_2F17, .kde = &lxb_unicode_decomposition_k_2F17};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F18[1] = {0x535C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F18[1] = {0x535C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F18[1] = {0x535C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F18, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F18 = {.cp = 0x2F18, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F18, .cde = &lxb_unicode_decomposition_c_2F18, .kde = &lxb_unicode_decomposition_k_2F18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F19[1] = {0x5369};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F19[1] = {0x5369};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F19[1] = {0x5369};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F19, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F19 = {.cp = 0x2F19, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F19, .cde = &lxb_unicode_decomposition_c_2F19, .kde = &lxb_unicode_decomposition_k_2F19};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F1A[1] = {0x5382};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F1A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F1A[1] = {0x5382};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F1A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F1A[1] = {0x5382};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F1A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F1A = {.cp = 0x2F1A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F1A, .cde = &lxb_unicode_decomposition_c_2F1A, .kde = &lxb_unicode_decomposition_k_2F1A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F1B[1] = {0x53B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F1B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F1B[1] = {0x53B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F1B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F1B[1] = {0x53B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F1B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F1B = {.cp = 0x2F1B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F1B, .cde = &lxb_unicode_decomposition_c_2F1B, .kde = &lxb_unicode_decomposition_k_2F1B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F1C[1] = {0x53C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F1C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F1C[1] = {0x53C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F1C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F1C[1] = {0x53C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F1C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F1C = {.cp = 0x2F1C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F1C, .cde = &lxb_unicode_decomposition_c_2F1C, .kde = &lxb_unicode_decomposition_k_2F1C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F1D[1] = {0x53E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F1D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F1D[1] = {0x53E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F1D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F1D[1] = {0x53E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F1D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F1D = {.cp = 0x2F1D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F1D, .cde = &lxb_unicode_decomposition_c_2F1D, .kde = &lxb_unicode_decomposition_k_2F1D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F1E[1] = {0x56D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F1E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F1E[1] = {0x56D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F1E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F1E[1] = {0x56D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F1E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F1E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F1E = {.cp = 0x2F1E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F1E, .cde = &lxb_unicode_decomposition_c_2F1E, .kde = &lxb_unicode_decomposition_k_2F1E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F1F[1] = {0x571F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F1F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F1F[1] = {0x571F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F1F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F1F[1] = {0x571F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F1F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F1F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F1F = {.cp = 0x2F1F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F1F, .cde = &lxb_unicode_decomposition_c_2F1F, .kde = &lxb_unicode_decomposition_k_2F1F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F20[1] = {0x58EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F20, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F20[1] = {0x58EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F20, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F20[1] = {0x58EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F20 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F20, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F20 = {.cp = 0x2F20, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F20, .cde = &lxb_unicode_decomposition_c_2F20, .kde = &lxb_unicode_decomposition_k_2F20};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F21[1] = {0x5902};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F21, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F21[1] = {0x5902};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F21, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F21[1] = {0x5902};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F21 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F21, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F21 = {.cp = 0x2F21, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F21, .cde = &lxb_unicode_decomposition_c_2F21, .kde = &lxb_unicode_decomposition_k_2F21};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F22[1] = {0x590A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F22, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F22[1] = {0x590A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F22, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F22[1] = {0x590A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F22 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F22, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F22 = {.cp = 0x2F22, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F22, .cde = &lxb_unicode_decomposition_c_2F22, .kde = &lxb_unicode_decomposition_k_2F22};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F23[1] = {0x5915};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F23, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F23[1] = {0x5915};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F23, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F23[1] = {0x5915};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F23 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F23, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F23 = {.cp = 0x2F23, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F23, .cde = &lxb_unicode_decomposition_c_2F23, .kde = &lxb_unicode_decomposition_k_2F23};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F24[1] = {0x5927};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F24, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F24[1] = {0x5927};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F24, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F24[1] = {0x5927};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F24 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F24, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F24 = {.cp = 0x2F24, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F24, .cde = &lxb_unicode_decomposition_c_2F24, .kde = &lxb_unicode_decomposition_k_2F24};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F25[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F25, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F25[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F25, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F25[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F25 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F25, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F25 = {.cp = 0x2F25, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F25, .cde = &lxb_unicode_decomposition_c_2F25, .kde = &lxb_unicode_decomposition_k_2F25};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F26[1] = {0x5B50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F26, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F26[1] = {0x5B50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F26, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F26[1] = {0x5B50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F26 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F26, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F26 = {.cp = 0x2F26, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F26, .cde = &lxb_unicode_decomposition_c_2F26, .kde = &lxb_unicode_decomposition_k_2F26};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F27[1] = {0x5B80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F27, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F27[1] = {0x5B80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F27, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F27[1] = {0x5B80};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F27 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F27, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F27 = {.cp = 0x2F27, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F27, .cde = &lxb_unicode_decomposition_c_2F27, .kde = &lxb_unicode_decomposition_k_2F27};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F28[1] = {0x5BF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F28, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F28[1] = {0x5BF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F28, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F28[1] = {0x5BF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F28 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F28, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F28 = {.cp = 0x2F28, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F28, .cde = &lxb_unicode_decomposition_c_2F28, .kde = &lxb_unicode_decomposition_k_2F28};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F29[1] = {0x5C0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F29, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F29[1] = {0x5C0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F29, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F29[1] = {0x5C0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F29 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F29, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F29 = {.cp = 0x2F29, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F29, .cde = &lxb_unicode_decomposition_c_2F29, .kde = &lxb_unicode_decomposition_k_2F29};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F2A[1] = {0x5C22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F2A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F2A[1] = {0x5C22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F2A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F2A[1] = {0x5C22};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F2A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F2A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F2A = {.cp = 0x2F2A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F2A, .cde = &lxb_unicode_decomposition_c_2F2A, .kde = &lxb_unicode_decomposition_k_2F2A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F2B[1] = {0x5C38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F2B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F2B[1] = {0x5C38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F2B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F2B[1] = {0x5C38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F2B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F2B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F2B = {.cp = 0x2F2B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F2B, .cde = &lxb_unicode_decomposition_c_2F2B, .kde = &lxb_unicode_decomposition_k_2F2B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F2C[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F2C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F2C[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F2C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F2C[1] = {0x5C6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F2C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F2C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F2C = {.cp = 0x2F2C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F2C, .cde = &lxb_unicode_decomposition_c_2F2C, .kde = &lxb_unicode_decomposition_k_2F2C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F2D[1] = {0x5C71};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F2D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F2D[1] = {0x5C71};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F2D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F2D[1] = {0x5C71};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F2D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F2D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F2D = {.cp = 0x2F2D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F2D, .cde = &lxb_unicode_decomposition_c_2F2D, .kde = &lxb_unicode_decomposition_k_2F2D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F2E[1] = {0x5DDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F2E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F2E[1] = {0x5DDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F2E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F2E[1] = {0x5DDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F2E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F2E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F2E = {.cp = 0x2F2E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F2E, .cde = &lxb_unicode_decomposition_c_2F2E, .kde = &lxb_unicode_decomposition_k_2F2E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F2F[1] = {0x5DE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F2F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F2F[1] = {0x5DE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F2F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F2F[1] = {0x5DE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F2F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F2F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F2F = {.cp = 0x2F2F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F2F, .cde = &lxb_unicode_decomposition_c_2F2F, .kde = &lxb_unicode_decomposition_k_2F2F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F30[1] = {0x5DF1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F30[1] = {0x5DF1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F30, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F30[1] = {0x5DF1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F30 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F30, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F30 = {.cp = 0x2F30, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F30, .cde = &lxb_unicode_decomposition_c_2F30, .kde = &lxb_unicode_decomposition_k_2F30};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F31[1] = {0x5DFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F31[1] = {0x5DFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F31, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F31[1] = {0x5DFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F31 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F31, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F31 = {.cp = 0x2F31, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F31, .cde = &lxb_unicode_decomposition_c_2F31, .kde = &lxb_unicode_decomposition_k_2F31};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F32[1] = {0x5E72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F32[1] = {0x5E72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F32, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F32[1] = {0x5E72};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F32 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F32, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F32 = {.cp = 0x2F32, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F32, .cde = &lxb_unicode_decomposition_c_2F32, .kde = &lxb_unicode_decomposition_k_2F32};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F33[1] = {0x5E7A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F33[1] = {0x5E7A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F33, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F33[1] = {0x5E7A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F33 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F33, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F33 = {.cp = 0x2F33, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F33, .cde = &lxb_unicode_decomposition_c_2F33, .kde = &lxb_unicode_decomposition_k_2F33};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F34[1] = {0x5E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F34[1] = {0x5E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F34, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F34[1] = {0x5E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F34 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F34, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F34 = {.cp = 0x2F34, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F34, .cde = &lxb_unicode_decomposition_c_2F34, .kde = &lxb_unicode_decomposition_k_2F34};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F35[1] = {0x5EF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F35[1] = {0x5EF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F35, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F35[1] = {0x5EF4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F35 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F35, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F35 = {.cp = 0x2F35, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F35, .cde = &lxb_unicode_decomposition_c_2F35, .kde = &lxb_unicode_decomposition_k_2F35};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F36[1] = {0x5EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F36[1] = {0x5EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F36, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F36[1] = {0x5EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F36 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F36, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F36 = {.cp = 0x2F36, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F36, .cde = &lxb_unicode_decomposition_c_2F36, .kde = &lxb_unicode_decomposition_k_2F36};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F37[1] = {0x5F0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F37[1] = {0x5F0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F37, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F37[1] = {0x5F0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F37 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F37, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F37 = {.cp = 0x2F37, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F37, .cde = &lxb_unicode_decomposition_c_2F37, .kde = &lxb_unicode_decomposition_k_2F37};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F38[1] = {0x5F13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F38[1] = {0x5F13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F38, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F38[1] = {0x5F13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F38 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F38, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F38 = {.cp = 0x2F38, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F38, .cde = &lxb_unicode_decomposition_c_2F38, .kde = &lxb_unicode_decomposition_k_2F38};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F39[1] = {0x5F50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F39[1] = {0x5F50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F39, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F39[1] = {0x5F50};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F39 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F39, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F39 = {.cp = 0x2F39, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F39, .cde = &lxb_unicode_decomposition_c_2F39, .kde = &lxb_unicode_decomposition_k_2F39};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F3A[1] = {0x5F61};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F3A[1] = {0x5F61};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F3A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F3A[1] = {0x5F61};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F3A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F3A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F3A = {.cp = 0x2F3A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F3A, .cde = &lxb_unicode_decomposition_c_2F3A, .kde = &lxb_unicode_decomposition_k_2F3A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F3B[1] = {0x5F73};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F3B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F3B[1] = {0x5F73};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F3B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F3B[1] = {0x5F73};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F3B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F3B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F3B = {.cp = 0x2F3B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F3B, .cde = &lxb_unicode_decomposition_c_2F3B, .kde = &lxb_unicode_decomposition_k_2F3B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F3C[1] = {0x5FC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F3C[1] = {0x5FC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F3C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F3C[1] = {0x5FC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F3C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F3C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F3C = {.cp = 0x2F3C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F3C, .cde = &lxb_unicode_decomposition_c_2F3C, .kde = &lxb_unicode_decomposition_k_2F3C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F3D[1] = {0x6208};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F3D[1] = {0x6208};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F3D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F3D[1] = {0x6208};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F3D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F3D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F3D = {.cp = 0x2F3D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F3D, .cde = &lxb_unicode_decomposition_c_2F3D, .kde = &lxb_unicode_decomposition_k_2F3D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F3E[1] = {0x6236};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F3E[1] = {0x6236};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F3E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F3E[1] = {0x6236};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F3E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F3E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F3E = {.cp = 0x2F3E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F3E, .cde = &lxb_unicode_decomposition_c_2F3E, .kde = &lxb_unicode_decomposition_k_2F3E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F3F[1] = {0x624B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F3F[1] = {0x624B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F3F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F3F[1] = {0x624B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F3F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F3F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F3F = {.cp = 0x2F3F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F3F, .cde = &lxb_unicode_decomposition_c_2F3F, .kde = &lxb_unicode_decomposition_k_2F3F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F40[1] = {0x652F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F40[1] = {0x652F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F40, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F40[1] = {0x652F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F40 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F40, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F40 = {.cp = 0x2F40, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F40, .cde = &lxb_unicode_decomposition_c_2F40, .kde = &lxb_unicode_decomposition_k_2F40};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F41[1] = {0x6534};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F41[1] = {0x6534};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F41, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F41[1] = {0x6534};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F41 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F41, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F41 = {.cp = 0x2F41, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F41, .cde = &lxb_unicode_decomposition_c_2F41, .kde = &lxb_unicode_decomposition_k_2F41};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F42[1] = {0x6587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F42[1] = {0x6587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F42, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F42[1] = {0x6587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F42 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F42, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F42 = {.cp = 0x2F42, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F42, .cde = &lxb_unicode_decomposition_c_2F42, .kde = &lxb_unicode_decomposition_k_2F42};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F43[1] = {0x6597};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F43[1] = {0x6597};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F43, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F43[1] = {0x6597};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F43 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F43, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F43 = {.cp = 0x2F43, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F43, .cde = &lxb_unicode_decomposition_c_2F43, .kde = &lxb_unicode_decomposition_k_2F43};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F44[1] = {0x65A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F44[1] = {0x65A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F44, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F44[1] = {0x65A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F44 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F44, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F44 = {.cp = 0x2F44, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F44, .cde = &lxb_unicode_decomposition_c_2F44, .kde = &lxb_unicode_decomposition_k_2F44};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F45[1] = {0x65B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F45, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F45[1] = {0x65B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F45, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F45[1] = {0x65B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F45 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F45, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F45 = {.cp = 0x2F45, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F45, .cde = &lxb_unicode_decomposition_c_2F45, .kde = &lxb_unicode_decomposition_k_2F45};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F46[1] = {0x65E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F46, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F46[1] = {0x65E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F46, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F46[1] = {0x65E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F46 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F46, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F46 = {.cp = 0x2F46, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F46, .cde = &lxb_unicode_decomposition_c_2F46, .kde = &lxb_unicode_decomposition_k_2F46};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F47[1] = {0x65E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F47[1] = {0x65E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F47, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F47[1] = {0x65E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F47 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F47, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F47 = {.cp = 0x2F47, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F47, .cde = &lxb_unicode_decomposition_c_2F47, .kde = &lxb_unicode_decomposition_k_2F47};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F48[1] = {0x66F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F48[1] = {0x66F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F48, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F48[1] = {0x66F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F48 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F48, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F48 = {.cp = 0x2F48, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F48, .cde = &lxb_unicode_decomposition_c_2F48, .kde = &lxb_unicode_decomposition_k_2F48};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F49[1] = {0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F49[1] = {0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F49, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F49[1] = {0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F49 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F49, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F49 = {.cp = 0x2F49, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F49, .cde = &lxb_unicode_decomposition_c_2F49, .kde = &lxb_unicode_decomposition_k_2F49};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F4A[1] = {0x6728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F4A[1] = {0x6728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F4A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F4A[1] = {0x6728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F4A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F4A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F4A = {.cp = 0x2F4A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F4A, .cde = &lxb_unicode_decomposition_c_2F4A, .kde = &lxb_unicode_decomposition_k_2F4A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F4B[1] = {0x6B20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F4B[1] = {0x6B20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F4B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F4B[1] = {0x6B20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F4B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F4B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F4B = {.cp = 0x2F4B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F4B, .cde = &lxb_unicode_decomposition_c_2F4B, .kde = &lxb_unicode_decomposition_k_2F4B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F4C[1] = {0x6B62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F4C[1] = {0x6B62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F4C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F4C[1] = {0x6B62};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F4C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F4C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F4C = {.cp = 0x2F4C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F4C, .cde = &lxb_unicode_decomposition_c_2F4C, .kde = &lxb_unicode_decomposition_k_2F4C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F4D[1] = {0x6B79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F4D[1] = {0x6B79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F4D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F4D[1] = {0x6B79};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F4D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F4D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F4D = {.cp = 0x2F4D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F4D, .cde = &lxb_unicode_decomposition_c_2F4D, .kde = &lxb_unicode_decomposition_k_2F4D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F4E[1] = {0x6BB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F4E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F4E[1] = {0x6BB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F4E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F4E[1] = {0x6BB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F4E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F4E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F4E = {.cp = 0x2F4E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F4E, .cde = &lxb_unicode_decomposition_c_2F4E, .kde = &lxb_unicode_decomposition_k_2F4E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F4F[1] = {0x6BCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F4F[1] = {0x6BCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F4F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F4F[1] = {0x6BCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F4F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F4F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F4F = {.cp = 0x2F4F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F4F, .cde = &lxb_unicode_decomposition_c_2F4F, .kde = &lxb_unicode_decomposition_k_2F4F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F50[1] = {0x6BD4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F50[1] = {0x6BD4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F50, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F50[1] = {0x6BD4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F50 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F50, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F50 = {.cp = 0x2F50, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F50, .cde = &lxb_unicode_decomposition_c_2F50, .kde = &lxb_unicode_decomposition_k_2F50};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F51[1] = {0x6BDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F51[1] = {0x6BDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F51, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F51[1] = {0x6BDB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F51 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F51, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F51 = {.cp = 0x2F51, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F51, .cde = &lxb_unicode_decomposition_c_2F51, .kde = &lxb_unicode_decomposition_k_2F51};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F52[1] = {0x6C0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F52[1] = {0x6C0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F52, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F52[1] = {0x6C0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F52 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F52, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F52 = {.cp = 0x2F52, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F52, .cde = &lxb_unicode_decomposition_c_2F52, .kde = &lxb_unicode_decomposition_k_2F52};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F53[1] = {0x6C14};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F53[1] = {0x6C14};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F53, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F53[1] = {0x6C14};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F53 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F53, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F53 = {.cp = 0x2F53, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F53, .cde = &lxb_unicode_decomposition_c_2F53, .kde = &lxb_unicode_decomposition_k_2F53};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F54[1] = {0x6C34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F54[1] = {0x6C34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F54, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F54[1] = {0x6C34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F54 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F54, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F54 = {.cp = 0x2F54, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F54, .cde = &lxb_unicode_decomposition_c_2F54, .kde = &lxb_unicode_decomposition_k_2F54};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F55[1] = {0x706B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F55[1] = {0x706B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F55, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F55[1] = {0x706B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F55 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F55, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F55 = {.cp = 0x2F55, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F55, .cde = &lxb_unicode_decomposition_c_2F55, .kde = &lxb_unicode_decomposition_k_2F55};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F56[1] = {0x722A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F56[1] = {0x722A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F56, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F56[1] = {0x722A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F56 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F56, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F56 = {.cp = 0x2F56, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F56, .cde = &lxb_unicode_decomposition_c_2F56, .kde = &lxb_unicode_decomposition_k_2F56};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F57[1] = {0x7236};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F57[1] = {0x7236};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F57, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F57[1] = {0x7236};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F57 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F57, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F57 = {.cp = 0x2F57, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F57, .cde = &lxb_unicode_decomposition_c_2F57, .kde = &lxb_unicode_decomposition_k_2F57};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F58[1] = {0x723B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F58[1] = {0x723B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F58, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F58[1] = {0x723B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F58 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F58, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F58 = {.cp = 0x2F58, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F58, .cde = &lxb_unicode_decomposition_c_2F58, .kde = &lxb_unicode_decomposition_k_2F58};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F59[1] = {0x723F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F59[1] = {0x723F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F59, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F59[1] = {0x723F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F59 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F59, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F59 = {.cp = 0x2F59, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F59, .cde = &lxb_unicode_decomposition_c_2F59, .kde = &lxb_unicode_decomposition_k_2F59};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F5A[1] = {0x7247};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F5A[1] = {0x7247};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F5A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F5A[1] = {0x7247};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F5A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F5A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F5A = {.cp = 0x2F5A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F5A, .cde = &lxb_unicode_decomposition_c_2F5A, .kde = &lxb_unicode_decomposition_k_2F5A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F5B[1] = {0x7259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F5B[1] = {0x7259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F5B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F5B[1] = {0x7259};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F5B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F5B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F5B = {.cp = 0x2F5B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F5B, .cde = &lxb_unicode_decomposition_c_2F5B, .kde = &lxb_unicode_decomposition_k_2F5B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F5C[1] = {0x725B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F5C[1] = {0x725B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F5C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F5C[1] = {0x725B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F5C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F5C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F5C = {.cp = 0x2F5C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F5C, .cde = &lxb_unicode_decomposition_c_2F5C, .kde = &lxb_unicode_decomposition_k_2F5C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F5D[1] = {0x72AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F5D[1] = {0x72AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F5D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F5D[1] = {0x72AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F5D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F5D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F5D = {.cp = 0x2F5D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F5D, .cde = &lxb_unicode_decomposition_c_2F5D, .kde = &lxb_unicode_decomposition_k_2F5D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F5E[1] = {0x7384};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F5E[1] = {0x7384};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F5E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F5E[1] = {0x7384};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F5E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F5E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F5E = {.cp = 0x2F5E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F5E, .cde = &lxb_unicode_decomposition_c_2F5E, .kde = &lxb_unicode_decomposition_k_2F5E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F5F[1] = {0x7389};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F5F[1] = {0x7389};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F5F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F5F[1] = {0x7389};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F5F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F5F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F5F = {.cp = 0x2F5F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F5F, .cde = &lxb_unicode_decomposition_c_2F5F, .kde = &lxb_unicode_decomposition_k_2F5F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F60[1] = {0x74DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F60[1] = {0x74DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F60, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F60[1] = {0x74DC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F60 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F60, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F60 = {.cp = 0x2F60, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F60, .cde = &lxb_unicode_decomposition_c_2F60, .kde = &lxb_unicode_decomposition_k_2F60};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F61[1] = {0x74E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F61[1] = {0x74E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F61, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F61[1] = {0x74E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F61 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F61, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F61 = {.cp = 0x2F61, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F61, .cde = &lxb_unicode_decomposition_c_2F61, .kde = &lxb_unicode_decomposition_k_2F61};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F62[1] = {0x7518};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F62[1] = {0x7518};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F62, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F62[1] = {0x7518};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F62 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F62, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F62 = {.cp = 0x2F62, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F62, .cde = &lxb_unicode_decomposition_c_2F62, .kde = &lxb_unicode_decomposition_k_2F62};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F63[1] = {0x751F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F63[1] = {0x751F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F63, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F63[1] = {0x751F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F63 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F63, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F63 = {.cp = 0x2F63, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F63, .cde = &lxb_unicode_decomposition_c_2F63, .kde = &lxb_unicode_decomposition_k_2F63};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F64[1] = {0x7528};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F64[1] = {0x7528};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F64, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F64[1] = {0x7528};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F64 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F64, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F64 = {.cp = 0x2F64, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F64, .cde = &lxb_unicode_decomposition_c_2F64, .kde = &lxb_unicode_decomposition_k_2F64};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F65[1] = {0x7530};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F65[1] = {0x7530};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F65, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F65[1] = {0x7530};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F65 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F65, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F65 = {.cp = 0x2F65, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F65, .cde = &lxb_unicode_decomposition_c_2F65, .kde = &lxb_unicode_decomposition_k_2F65};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F66[1] = {0x758B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F66[1] = {0x758B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F66, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F66[1] = {0x758B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F66 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F66, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F66 = {.cp = 0x2F66, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F66, .cde = &lxb_unicode_decomposition_c_2F66, .kde = &lxb_unicode_decomposition_k_2F66};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F67[1] = {0x7592};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F67[1] = {0x7592};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F67, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F67[1] = {0x7592};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F67 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F67, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F67 = {.cp = 0x2F67, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F67, .cde = &lxb_unicode_decomposition_c_2F67, .kde = &lxb_unicode_decomposition_k_2F67};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F68[1] = {0x7676};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F68[1] = {0x7676};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F68, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F68[1] = {0x7676};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F68 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F68, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F68 = {.cp = 0x2F68, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F68, .cde = &lxb_unicode_decomposition_c_2F68, .kde = &lxb_unicode_decomposition_k_2F68};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F69[1] = {0x767D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F69[1] = {0x767D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F69, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F69[1] = {0x767D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F69 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F69, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F69 = {.cp = 0x2F69, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F69, .cde = &lxb_unicode_decomposition_c_2F69, .kde = &lxb_unicode_decomposition_k_2F69};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F6A[1] = {0x76AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F6A[1] = {0x76AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F6A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F6A[1] = {0x76AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F6A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F6A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F6A = {.cp = 0x2F6A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F6A, .cde = &lxb_unicode_decomposition_c_2F6A, .kde = &lxb_unicode_decomposition_k_2F6A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F6B[1] = {0x76BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F6B[1] = {0x76BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F6B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F6B[1] = {0x76BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F6B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F6B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F6B = {.cp = 0x2F6B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F6B, .cde = &lxb_unicode_decomposition_c_2F6B, .kde = &lxb_unicode_decomposition_k_2F6B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F6C[1] = {0x76EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F6C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F6C[1] = {0x76EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F6C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F6C[1] = {0x76EE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F6C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F6C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F6C = {.cp = 0x2F6C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F6C, .cde = &lxb_unicode_decomposition_c_2F6C, .kde = &lxb_unicode_decomposition_k_2F6C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F6D[1] = {0x77DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F6D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F6D[1] = {0x77DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F6D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F6D[1] = {0x77DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F6D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F6D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F6D = {.cp = 0x2F6D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F6D, .cde = &lxb_unicode_decomposition_c_2F6D, .kde = &lxb_unicode_decomposition_k_2F6D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F6E[1] = {0x77E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F6E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F6E[1] = {0x77E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F6E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F6E[1] = {0x77E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F6E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F6E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F6E = {.cp = 0x2F6E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F6E, .cde = &lxb_unicode_decomposition_c_2F6E, .kde = &lxb_unicode_decomposition_k_2F6E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F6F[1] = {0x77F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F6F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F6F[1] = {0x77F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F6F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F6F[1] = {0x77F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F6F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F6F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F6F = {.cp = 0x2F6F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F6F, .cde = &lxb_unicode_decomposition_c_2F6F, .kde = &lxb_unicode_decomposition_k_2F6F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F70[1] = {0x793A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F70, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F70[1] = {0x793A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F70, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F70[1] = {0x793A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F70 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F70, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F70 = {.cp = 0x2F70, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F70, .cde = &lxb_unicode_decomposition_c_2F70, .kde = &lxb_unicode_decomposition_k_2F70};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F71[1] = {0x79B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F71, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F71[1] = {0x79B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F71, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F71[1] = {0x79B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F71 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F71, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F71 = {.cp = 0x2F71, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F71, .cde = &lxb_unicode_decomposition_c_2F71, .kde = &lxb_unicode_decomposition_k_2F71};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F72[1] = {0x79BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F72, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F72[1] = {0x79BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F72, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F72[1] = {0x79BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F72 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F72, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F72 = {.cp = 0x2F72, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F72, .cde = &lxb_unicode_decomposition_c_2F72, .kde = &lxb_unicode_decomposition_k_2F72};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F73[1] = {0x7A74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F73, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F73[1] = {0x7A74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F73, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F73[1] = {0x7A74};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F73 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F73, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F73 = {.cp = 0x2F73, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F73, .cde = &lxb_unicode_decomposition_c_2F73, .kde = &lxb_unicode_decomposition_k_2F73};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F74[1] = {0x7ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F74, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F74[1] = {0x7ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F74, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F74[1] = {0x7ACB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F74 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F74, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F74 = {.cp = 0x2F74, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F74, .cde = &lxb_unicode_decomposition_c_2F74, .kde = &lxb_unicode_decomposition_k_2F74};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F75[1] = {0x7AF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F75, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F75[1] = {0x7AF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F75, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F75[1] = {0x7AF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F75 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F75, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F75 = {.cp = 0x2F75, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F75, .cde = &lxb_unicode_decomposition_c_2F75, .kde = &lxb_unicode_decomposition_k_2F75};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F76[1] = {0x7C73};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F76, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F76[1] = {0x7C73};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F76, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F76[1] = {0x7C73};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F76 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F76, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F76 = {.cp = 0x2F76, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F76, .cde = &lxb_unicode_decomposition_c_2F76, .kde = &lxb_unicode_decomposition_k_2F76};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F77[1] = {0x7CF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F77, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F77[1] = {0x7CF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F77, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F77[1] = {0x7CF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F77 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F77, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F77 = {.cp = 0x2F77, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F77, .cde = &lxb_unicode_decomposition_c_2F77, .kde = &lxb_unicode_decomposition_k_2F77};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F78[1] = {0x7F36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F78[1] = {0x7F36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F78, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F78[1] = {0x7F36};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F78 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F78, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F78 = {.cp = 0x2F78, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F78, .cde = &lxb_unicode_decomposition_c_2F78, .kde = &lxb_unicode_decomposition_k_2F78};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F79[1] = {0x7F51};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F79, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F79[1] = {0x7F51};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F79, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F79[1] = {0x7F51};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F79 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F79, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F79 = {.cp = 0x2F79, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F79, .cde = &lxb_unicode_decomposition_c_2F79, .kde = &lxb_unicode_decomposition_k_2F79};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F7A[1] = {0x7F8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F7A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F7A[1] = {0x7F8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F7A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F7A[1] = {0x7F8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F7A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F7A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F7A = {.cp = 0x2F7A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F7A, .cde = &lxb_unicode_decomposition_c_2F7A, .kde = &lxb_unicode_decomposition_k_2F7A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F7B[1] = {0x7FBD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F7B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F7B[1] = {0x7FBD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F7B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F7B[1] = {0x7FBD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F7B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F7B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F7B = {.cp = 0x2F7B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F7B, .cde = &lxb_unicode_decomposition_c_2F7B, .kde = &lxb_unicode_decomposition_k_2F7B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F7C[1] = {0x8001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F7C[1] = {0x8001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F7C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F7C[1] = {0x8001};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F7C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F7C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F7C = {.cp = 0x2F7C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F7C, .cde = &lxb_unicode_decomposition_c_2F7C, .kde = &lxb_unicode_decomposition_k_2F7C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F7D[1] = {0x800C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F7D[1] = {0x800C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F7D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F7D[1] = {0x800C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F7D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F7D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F7D = {.cp = 0x2F7D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F7D, .cde = &lxb_unicode_decomposition_c_2F7D, .kde = &lxb_unicode_decomposition_k_2F7D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F7E[1] = {0x8012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F7E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F7E[1] = {0x8012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F7E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F7E[1] = {0x8012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F7E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F7E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F7E = {.cp = 0x2F7E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F7E, .cde = &lxb_unicode_decomposition_c_2F7E, .kde = &lxb_unicode_decomposition_k_2F7E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F7F[1] = {0x8033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F7F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F7F[1] = {0x8033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F7F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F7F[1] = {0x8033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F7F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F7F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F7F = {.cp = 0x2F7F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F7F, .cde = &lxb_unicode_decomposition_c_2F7F, .kde = &lxb_unicode_decomposition_k_2F7F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F80[1] = {0x807F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F80[1] = {0x807F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F80, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F80[1] = {0x807F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F80 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F80, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F80 = {.cp = 0x2F80, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F80, .cde = &lxb_unicode_decomposition_c_2F80, .kde = &lxb_unicode_decomposition_k_2F80};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F81[1] = {0x8089};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F81, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F81[1] = {0x8089};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F81, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F81[1] = {0x8089};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F81 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F81, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F81 = {.cp = 0x2F81, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F81, .cde = &lxb_unicode_decomposition_c_2F81, .kde = &lxb_unicode_decomposition_k_2F81};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F82[1] = {0x81E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F82, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F82[1] = {0x81E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F82, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F82[1] = {0x81E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F82 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F82, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F82 = {.cp = 0x2F82, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F82, .cde = &lxb_unicode_decomposition_c_2F82, .kde = &lxb_unicode_decomposition_k_2F82};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F83[1] = {0x81EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F83, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F83[1] = {0x81EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F83, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F83[1] = {0x81EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F83 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F83, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F83 = {.cp = 0x2F83, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F83, .cde = &lxb_unicode_decomposition_c_2F83, .kde = &lxb_unicode_decomposition_k_2F83};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F84[1] = {0x81F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F84, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F84[1] = {0x81F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F84, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F84[1] = {0x81F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F84 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F84, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F84 = {.cp = 0x2F84, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F84, .cde = &lxb_unicode_decomposition_c_2F84, .kde = &lxb_unicode_decomposition_k_2F84};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F85[1] = {0x81FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F85, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F85[1] = {0x81FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F85, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F85[1] = {0x81FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F85 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F85, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F85 = {.cp = 0x2F85, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F85, .cde = &lxb_unicode_decomposition_c_2F85, .kde = &lxb_unicode_decomposition_k_2F85};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F86[1] = {0x820C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F86, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F86[1] = {0x820C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F86, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F86[1] = {0x820C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F86 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F86, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F86 = {.cp = 0x2F86, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F86, .cde = &lxb_unicode_decomposition_c_2F86, .kde = &lxb_unicode_decomposition_k_2F86};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F87[1] = {0x821B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F87, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F87[1] = {0x821B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F87, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F87[1] = {0x821B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F87 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F87, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F87 = {.cp = 0x2F87, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F87, .cde = &lxb_unicode_decomposition_c_2F87, .kde = &lxb_unicode_decomposition_k_2F87};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F88[1] = {0x821F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F88, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F88[1] = {0x821F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F88, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F88[1] = {0x821F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F88 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F88, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F88 = {.cp = 0x2F88, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F88, .cde = &lxb_unicode_decomposition_c_2F88, .kde = &lxb_unicode_decomposition_k_2F88};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F89[1] = {0x826E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F89, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F89[1] = {0x826E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F89, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F89[1] = {0x826E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F89 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F89, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F89 = {.cp = 0x2F89, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F89, .cde = &lxb_unicode_decomposition_c_2F89, .kde = &lxb_unicode_decomposition_k_2F89};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8A[1] = {0x8272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F8A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8A[1] = {0x8272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F8A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8A[1] = {0x8272};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F8A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8A = {.cp = 0x2F8A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8A, .cde = &lxb_unicode_decomposition_c_2F8A, .kde = &lxb_unicode_decomposition_k_2F8A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8B[1] = {0x8278};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F8B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8B[1] = {0x8278};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F8B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8B[1] = {0x8278};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F8B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8B = {.cp = 0x2F8B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8B, .cde = &lxb_unicode_decomposition_c_2F8B, .kde = &lxb_unicode_decomposition_k_2F8B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8C[1] = {0x864D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F8C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8C[1] = {0x864D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F8C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8C[1] = {0x864D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F8C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8C = {.cp = 0x2F8C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8C, .cde = &lxb_unicode_decomposition_c_2F8C, .kde = &lxb_unicode_decomposition_k_2F8C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8D[1] = {0x866B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8D[1] = {0x866B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F8D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8D[1] = {0x866B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F8D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8D = {.cp = 0x2F8D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8D, .cde = &lxb_unicode_decomposition_c_2F8D, .kde = &lxb_unicode_decomposition_k_2F8D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8E[1] = {0x8840};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8E[1] = {0x8840};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F8E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8E[1] = {0x8840};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F8E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8E = {.cp = 0x2F8E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8E, .cde = &lxb_unicode_decomposition_c_2F8E, .kde = &lxb_unicode_decomposition_k_2F8E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F8F[1] = {0x884C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F8F[1] = {0x884C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F8F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F8F[1] = {0x884C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F8F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F8F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F8F = {.cp = 0x2F8F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F8F, .cde = &lxb_unicode_decomposition_c_2F8F, .kde = &lxb_unicode_decomposition_k_2F8F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F90[1] = {0x8863};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F90[1] = {0x8863};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F90, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F90[1] = {0x8863};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F90 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F90, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F90 = {.cp = 0x2F90, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F90, .cde = &lxb_unicode_decomposition_c_2F90, .kde = &lxb_unicode_decomposition_k_2F90};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F91[1] = {0x897E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F91[1] = {0x897E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F91, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F91[1] = {0x897E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F91 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F91, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F91 = {.cp = 0x2F91, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F91, .cde = &lxb_unicode_decomposition_c_2F91, .kde = &lxb_unicode_decomposition_k_2F91};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F92[1] = {0x898B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F92[1] = {0x898B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F92, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F92[1] = {0x898B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F92 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F92, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F92 = {.cp = 0x2F92, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F92, .cde = &lxb_unicode_decomposition_c_2F92, .kde = &lxb_unicode_decomposition_k_2F92};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F93[1] = {0x89D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F93[1] = {0x89D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F93, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F93[1] = {0x89D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F93 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F93, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F93 = {.cp = 0x2F93, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F93, .cde = &lxb_unicode_decomposition_c_2F93, .kde = &lxb_unicode_decomposition_k_2F93};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F94[1] = {0x8A00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F94[1] = {0x8A00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F94, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F94[1] = {0x8A00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F94 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F94, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F94 = {.cp = 0x2F94, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F94, .cde = &lxb_unicode_decomposition_c_2F94, .kde = &lxb_unicode_decomposition_k_2F94};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F95[1] = {0x8C37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F95[1] = {0x8C37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F95, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F95[1] = {0x8C37};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F95 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F95, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F95 = {.cp = 0x2F95, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F95, .cde = &lxb_unicode_decomposition_c_2F95, .kde = &lxb_unicode_decomposition_k_2F95};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F96[1] = {0x8C46};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F96[1] = {0x8C46};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F96, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F96[1] = {0x8C46};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F96 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F96, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F96 = {.cp = 0x2F96, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F96, .cde = &lxb_unicode_decomposition_c_2F96, .kde = &lxb_unicode_decomposition_k_2F96};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F97[1] = {0x8C55};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F97[1] = {0x8C55};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F97, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F97[1] = {0x8C55};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F97 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F97, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F97 = {.cp = 0x2F97, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F97, .cde = &lxb_unicode_decomposition_c_2F97, .kde = &lxb_unicode_decomposition_k_2F97};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F98[1] = {0x8C78};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F98[1] = {0x8C78};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F98, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F98[1] = {0x8C78};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F98 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F98, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F98 = {.cp = 0x2F98, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F98, .cde = &lxb_unicode_decomposition_c_2F98, .kde = &lxb_unicode_decomposition_k_2F98};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F99[1] = {0x8C9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F99[1] = {0x8C9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F99, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F99[1] = {0x8C9D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F99 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F99, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F99 = {.cp = 0x2F99, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F99, .cde = &lxb_unicode_decomposition_c_2F99, .kde = &lxb_unicode_decomposition_k_2F99};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9A[1] = {0x8D64};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9A[1] = {0x8D64};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F9A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9A[1] = {0x8D64};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F9A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9A = {.cp = 0x2F9A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9A, .cde = &lxb_unicode_decomposition_c_2F9A, .kde = &lxb_unicode_decomposition_k_2F9A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B[1] = {0x8D70};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B[1] = {0x8D70};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F9B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B[1] = {0x8D70};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F9B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B = {.cp = 0x2F9B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B, .cde = &lxb_unicode_decomposition_c_2F9B, .kde = &lxb_unicode_decomposition_k_2F9B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C[1] = {0x8DB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C[1] = {0x8DB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F9C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C[1] = {0x8DB3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F9C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C = {.cp = 0x2F9C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C, .cde = &lxb_unicode_decomposition_c_2F9C, .kde = &lxb_unicode_decomposition_k_2F9C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D[1] = {0x8EAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D[1] = {0x8EAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F9D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D[1] = {0x8EAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F9D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D = {.cp = 0x2F9D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D, .cde = &lxb_unicode_decomposition_c_2F9D, .kde = &lxb_unicode_decomposition_k_2F9D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E[1] = {0x8ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E[1] = {0x8ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F9E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E[1] = {0x8ECA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F9E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E = {.cp = 0x2F9E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E, .cde = &lxb_unicode_decomposition_c_2F9E, .kde = &lxb_unicode_decomposition_k_2F9E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F[1] = {0x8F9B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2F9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F[1] = {0x8F9B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2F9F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F[1] = {0x8F9B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2F9F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F = {.cp = 0x2F9F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F, .cde = &lxb_unicode_decomposition_c_2F9F, .kde = &lxb_unicode_decomposition_k_2F9F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA0[1] = {0x8FB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA0[1] = {0x8FB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA0[1] = {0x8FB0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA0 = {.cp = 0x2FA0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA0, .cde = &lxb_unicode_decomposition_c_2FA0, .kde = &lxb_unicode_decomposition_k_2FA0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA1[1] = {0x8FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA1[1] = {0x8FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA1[1] = {0x8FB5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA1 = {.cp = 0x2FA1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA1, .cde = &lxb_unicode_decomposition_c_2FA1, .kde = &lxb_unicode_decomposition_k_2FA1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA2[1] = {0x9091};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA2[1] = {0x9091};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA2[1] = {0x9091};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA2 = {.cp = 0x2FA2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA2, .cde = &lxb_unicode_decomposition_c_2FA2, .kde = &lxb_unicode_decomposition_k_2FA2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA3[1] = {0x9149};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA3[1] = {0x9149};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA3[1] = {0x9149};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA3 = {.cp = 0x2FA3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA3, .cde = &lxb_unicode_decomposition_c_2FA3, .kde = &lxb_unicode_decomposition_k_2FA3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA4[1] = {0x91C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA4[1] = {0x91C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA4[1] = {0x91C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA4 = {.cp = 0x2FA4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA4, .cde = &lxb_unicode_decomposition_c_2FA4, .kde = &lxb_unicode_decomposition_k_2FA4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA5[1] = {0x91CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA5[1] = {0x91CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA5[1] = {0x91CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA5 = {.cp = 0x2FA5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA5, .cde = &lxb_unicode_decomposition_c_2FA5, .kde = &lxb_unicode_decomposition_k_2FA5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA6[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA6[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA6[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA6 = {.cp = 0x2FA6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA6, .cde = &lxb_unicode_decomposition_c_2FA6, .kde = &lxb_unicode_decomposition_k_2FA6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA7[1] = {0x9577};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA7[1] = {0x9577};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA7[1] = {0x9577};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA7 = {.cp = 0x2FA7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA7, .cde = &lxb_unicode_decomposition_c_2FA7, .kde = &lxb_unicode_decomposition_k_2FA7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA8[1] = {0x9580};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA8[1] = {0x9580};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA8[1] = {0x9580};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA8 = {.cp = 0x2FA8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA8, .cde = &lxb_unicode_decomposition_c_2FA8, .kde = &lxb_unicode_decomposition_k_2FA8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA9[1] = {0x961C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA9[1] = {0x961C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FA9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA9[1] = {0x961C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FA9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA9 = {.cp = 0x2FA9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA9, .cde = &lxb_unicode_decomposition_c_2FA9, .kde = &lxb_unicode_decomposition_k_2FA9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FAA[1] = {0x96B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FAA[1] = {0x96B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FAA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FAA[1] = {0x96B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FAA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FAA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FAA = {.cp = 0x2FAA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FAA, .cde = &lxb_unicode_decomposition_c_2FAA, .kde = &lxb_unicode_decomposition_k_2FAA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FAB[1] = {0x96B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FAB[1] = {0x96B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FAB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FAB[1] = {0x96B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FAB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FAB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FAB = {.cp = 0x2FAB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FAB, .cde = &lxb_unicode_decomposition_c_2FAB, .kde = &lxb_unicode_decomposition_k_2FAB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FAC[1] = {0x96E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FAC[1] = {0x96E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FAC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FAC[1] = {0x96E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FAC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FAC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FAC = {.cp = 0x2FAC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FAC, .cde = &lxb_unicode_decomposition_c_2FAC, .kde = &lxb_unicode_decomposition_k_2FAC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FAD[1] = {0x9751};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FAD[1] = {0x9751};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FAD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FAD[1] = {0x9751};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FAD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FAD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FAD = {.cp = 0x2FAD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FAD, .cde = &lxb_unicode_decomposition_c_2FAD, .kde = &lxb_unicode_decomposition_k_2FAD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FAE[1] = {0x975E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FAE[1] = {0x975E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FAE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FAE[1] = {0x975E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FAE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FAE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FAE = {.cp = 0x2FAE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FAE, .cde = &lxb_unicode_decomposition_c_2FAE, .kde = &lxb_unicode_decomposition_k_2FAE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FAF[1] = {0x9762};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FAF[1] = {0x9762};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FAF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FAF[1] = {0x9762};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FAF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FAF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FAF = {.cp = 0x2FAF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FAF, .cde = &lxb_unicode_decomposition_c_2FAF, .kde = &lxb_unicode_decomposition_k_2FAF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB0[1] = {0x9769};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB0[1] = {0x9769};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB0[1] = {0x9769};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB0 = {.cp = 0x2FB0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB0, .cde = &lxb_unicode_decomposition_c_2FB0, .kde = &lxb_unicode_decomposition_k_2FB0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB1[1] = {0x97CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB1[1] = {0x97CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB1[1] = {0x97CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB1 = {.cp = 0x2FB1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB1, .cde = &lxb_unicode_decomposition_c_2FB1, .kde = &lxb_unicode_decomposition_k_2FB1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB2[1] = {0x97ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB2[1] = {0x97ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB2[1] = {0x97ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB2 = {.cp = 0x2FB2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB2, .cde = &lxb_unicode_decomposition_c_2FB2, .kde = &lxb_unicode_decomposition_k_2FB2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB3[1] = {0x97F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB3[1] = {0x97F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB3[1] = {0x97F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB3 = {.cp = 0x2FB3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB3, .cde = &lxb_unicode_decomposition_c_2FB3, .kde = &lxb_unicode_decomposition_k_2FB3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB4[1] = {0x9801};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB4[1] = {0x9801};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB4[1] = {0x9801};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB4 = {.cp = 0x2FB4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB4, .cde = &lxb_unicode_decomposition_c_2FB4, .kde = &lxb_unicode_decomposition_k_2FB4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB5[1] = {0x98A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB5[1] = {0x98A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB5[1] = {0x98A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB5 = {.cp = 0x2FB5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB5, .cde = &lxb_unicode_decomposition_c_2FB5, .kde = &lxb_unicode_decomposition_k_2FB5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB6[1] = {0x98DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB6[1] = {0x98DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB6[1] = {0x98DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB6 = {.cp = 0x2FB6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB6, .cde = &lxb_unicode_decomposition_c_2FB6, .kde = &lxb_unicode_decomposition_k_2FB6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB7[1] = {0x98DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB7[1] = {0x98DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB7[1] = {0x98DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB7 = {.cp = 0x2FB7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB7, .cde = &lxb_unicode_decomposition_c_2FB7, .kde = &lxb_unicode_decomposition_k_2FB7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB8[1] = {0x9996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB8[1] = {0x9996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB8[1] = {0x9996};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB8 = {.cp = 0x2FB8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB8, .cde = &lxb_unicode_decomposition_c_2FB8, .kde = &lxb_unicode_decomposition_k_2FB8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FB9[1] = {0x9999};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FB9[1] = {0x9999};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FB9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FB9[1] = {0x9999};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FB9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FB9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FB9 = {.cp = 0x2FB9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FB9, .cde = &lxb_unicode_decomposition_c_2FB9, .kde = &lxb_unicode_decomposition_k_2FB9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FBA[1] = {0x99AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FBA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FBA[1] = {0x99AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FBA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FBA[1] = {0x99AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FBA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FBA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FBA = {.cp = 0x2FBA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FBA, .cde = &lxb_unicode_decomposition_c_2FBA, .kde = &lxb_unicode_decomposition_k_2FBA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FBB[1] = {0x9AA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FBB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FBB[1] = {0x9AA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FBB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FBB[1] = {0x9AA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FBB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FBB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FBB = {.cp = 0x2FBB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FBB, .cde = &lxb_unicode_decomposition_c_2FBB, .kde = &lxb_unicode_decomposition_k_2FBB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FBC[1] = {0x9AD8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FBC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FBC[1] = {0x9AD8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FBC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FBC[1] = {0x9AD8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FBC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FBC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FBC = {.cp = 0x2FBC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FBC, .cde = &lxb_unicode_decomposition_c_2FBC, .kde = &lxb_unicode_decomposition_k_2FBC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FBD[1] = {0x9ADF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FBD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FBD[1] = {0x9ADF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FBD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FBD[1] = {0x9ADF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FBD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FBD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FBD = {.cp = 0x2FBD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FBD, .cde = &lxb_unicode_decomposition_c_2FBD, .kde = &lxb_unicode_decomposition_k_2FBD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FBE[1] = {0x9B25};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FBE[1] = {0x9B25};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FBE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FBE[1] = {0x9B25};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FBE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FBE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FBE = {.cp = 0x2FBE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FBE, .cde = &lxb_unicode_decomposition_c_2FBE, .kde = &lxb_unicode_decomposition_k_2FBE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FBF[1] = {0x9B2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FBF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FBF[1] = {0x9B2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FBF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FBF[1] = {0x9B2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FBF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FBF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FBF = {.cp = 0x2FBF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FBF, .cde = &lxb_unicode_decomposition_c_2FBF, .kde = &lxb_unicode_decomposition_k_2FBF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC0[1] = {0x9B32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC0[1] = {0x9B32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC0[1] = {0x9B32};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC0 = {.cp = 0x2FC0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC0, .cde = &lxb_unicode_decomposition_c_2FC0, .kde = &lxb_unicode_decomposition_k_2FC0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC1[1] = {0x9B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC1[1] = {0x9B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC1[1] = {0x9B3C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC1 = {.cp = 0x2FC1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC1, .cde = &lxb_unicode_decomposition_c_2FC1, .kde = &lxb_unicode_decomposition_k_2FC1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC2[1] = {0x9B5A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC2[1] = {0x9B5A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC2[1] = {0x9B5A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC2 = {.cp = 0x2FC2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC2, .cde = &lxb_unicode_decomposition_c_2FC2, .kde = &lxb_unicode_decomposition_k_2FC2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC3[1] = {0x9CE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC3[1] = {0x9CE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC3[1] = {0x9CE5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC3 = {.cp = 0x2FC3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC3, .cde = &lxb_unicode_decomposition_c_2FC3, .kde = &lxb_unicode_decomposition_k_2FC3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC4[1] = {0x9E75};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC4[1] = {0x9E75};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC4[1] = {0x9E75};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC4 = {.cp = 0x2FC4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC4, .cde = &lxb_unicode_decomposition_c_2FC4, .kde = &lxb_unicode_decomposition_k_2FC4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC5[1] = {0x9E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC5[1] = {0x9E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC5[1] = {0x9E7F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC5 = {.cp = 0x2FC5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC5, .cde = &lxb_unicode_decomposition_c_2FC5, .kde = &lxb_unicode_decomposition_k_2FC5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC6[1] = {0x9EA5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC6[1] = {0x9EA5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC6[1] = {0x9EA5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC6 = {.cp = 0x2FC6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC6, .cde = &lxb_unicode_decomposition_c_2FC6, .kde = &lxb_unicode_decomposition_k_2FC6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC7[1] = {0x9EBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC7[1] = {0x9EBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC7[1] = {0x9EBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC7 = {.cp = 0x2FC7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC7, .cde = &lxb_unicode_decomposition_c_2FC7, .kde = &lxb_unicode_decomposition_k_2FC7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC8[1] = {0x9EC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC8[1] = {0x9EC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC8[1] = {0x9EC3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC8 = {.cp = 0x2FC8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC8, .cde = &lxb_unicode_decomposition_c_2FC8, .kde = &lxb_unicode_decomposition_k_2FC8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FC9[1] = {0x9ECD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FC9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FC9[1] = {0x9ECD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FC9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FC9[1] = {0x9ECD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FC9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FC9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FC9 = {.cp = 0x2FC9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FC9, .cde = &lxb_unicode_decomposition_c_2FC9, .kde = &lxb_unicode_decomposition_k_2FC9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FCA[1] = {0x9ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FCA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FCA[1] = {0x9ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FCA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FCA[1] = {0x9ED1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FCA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FCA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FCA = {.cp = 0x2FCA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FCA, .cde = &lxb_unicode_decomposition_c_2FCA, .kde = &lxb_unicode_decomposition_k_2FCA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FCB[1] = {0x9EF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FCB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FCB[1] = {0x9EF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FCB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FCB[1] = {0x9EF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FCB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FCB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FCB = {.cp = 0x2FCB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FCB, .cde = &lxb_unicode_decomposition_c_2FCB, .kde = &lxb_unicode_decomposition_k_2FCB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FCC[1] = {0x9EFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FCC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FCC[1] = {0x9EFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FCC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FCC[1] = {0x9EFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FCC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FCC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FCC = {.cp = 0x2FCC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FCC, .cde = &lxb_unicode_decomposition_c_2FCC, .kde = &lxb_unicode_decomposition_k_2FCC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FCD[1] = {0x9F0E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FCD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FCD[1] = {0x9F0E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FCD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FCD[1] = {0x9F0E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FCD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FCD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FCD = {.cp = 0x2FCD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FCD, .cde = &lxb_unicode_decomposition_c_2FCD, .kde = &lxb_unicode_decomposition_k_2FCD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FCE[1] = {0x9F13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FCE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FCE[1] = {0x9F13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FCE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FCE[1] = {0x9F13};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FCE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FCE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FCE = {.cp = 0x2FCE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FCE, .cde = &lxb_unicode_decomposition_c_2FCE, .kde = &lxb_unicode_decomposition_k_2FCE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FCF[1] = {0x9F20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FCF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FCF[1] = {0x9F20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FCF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FCF[1] = {0x9F20};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FCF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FCF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FCF = {.cp = 0x2FCF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FCF, .cde = &lxb_unicode_decomposition_c_2FCF, .kde = &lxb_unicode_decomposition_k_2FCF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FD0[1] = {0x9F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FD0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FD0[1] = {0x9F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FD0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FD0[1] = {0x9F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FD0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FD0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FD0 = {.cp = 0x2FD0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FD0, .cde = &lxb_unicode_decomposition_c_2FD0, .kde = &lxb_unicode_decomposition_k_2FD0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FD1[1] = {0x9F4A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FD1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FD1[1] = {0x9F4A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FD1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FD1[1] = {0x9F4A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FD1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FD1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FD1 = {.cp = 0x2FD1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FD1, .cde = &lxb_unicode_decomposition_c_2FD1, .kde = &lxb_unicode_decomposition_k_2FD1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FD2[1] = {0x9F52};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FD2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FD2[1] = {0x9F52};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FD2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FD2[1] = {0x9F52};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FD2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FD2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FD2 = {.cp = 0x2FD2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FD2, .cde = &lxb_unicode_decomposition_c_2FD2, .kde = &lxb_unicode_decomposition_k_2FD2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FD3[1] = {0x9F8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FD3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FD3[1] = {0x9F8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FD3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FD3[1] = {0x9F8D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FD3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FD3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FD3 = {.cp = 0x2FD3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FD3, .cde = &lxb_unicode_decomposition_c_2FD3, .kde = &lxb_unicode_decomposition_k_2FD3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FD4[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FD4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FD4[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FD4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FD4[1] = {0x9F9C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FD4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FD4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FD4 = {.cp = 0x2FD4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FD4, .cde = &lxb_unicode_decomposition_c_2FD4, .kde = &lxb_unicode_decomposition_k_2FD4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FD5[1] = {0x9FA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_2FD5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FD5[1] = {0x9FA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_2FD5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FD5[1] = {0x9FA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FD5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__2FD5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FD5 = {.cp = 0x2FD5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FD5, .cde = &lxb_unicode_decomposition_c_2FD5, .kde = &lxb_unicode_decomposition_k_2FD5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3000[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3000 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_c_3000, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3000[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3000 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp_k_3000, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3000[1] = {0x0020};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3000 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_WIDE, .mapping = lxb_unicode_decomposition_cp__3000, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3000 = {.cp = 0x3000, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3000, .cde = &lxb_unicode_decomposition_c_3000, .kde = &lxb_unicode_decomposition_k_3000};

static const lxb_unicode_entry_t lxb_unicode_entry_302A = {.cp = 0x302A, .ccc = 218, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_302B = {.cp = 0x302B, .ccc = 228, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_302C = {.cp = 0x302C, .ccc = 232, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_302D = {.cp = 0x302D, .ccc = 222, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_302E = {.cp = 0x302E, .ccc = 224, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_302F = {.cp = 0x302F, .ccc = 224, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3036[1] = {0x3012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3036 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3036, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3036[1] = {0x3012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3036 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3036, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3036[1] = {0x3012};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3036 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3036, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3036 = {.cp = 0x3036, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3036, .cde = &lxb_unicode_decomposition_c_3036, .kde = &lxb_unicode_decomposition_k_3036};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3038[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3038 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3038, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3038[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3038 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3038, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3038[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3038 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3038, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3038 = {.cp = 0x3038, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3038, .cde = &lxb_unicode_decomposition_c_3038, .kde = &lxb_unicode_decomposition_k_3038};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3039[1] = {0x5344};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3039 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3039, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3039[1] = {0x5344};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3039 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3039, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3039[1] = {0x5344};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3039 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3039, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3039 = {.cp = 0x3039, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3039, .cde = &lxb_unicode_decomposition_c_3039, .kde = &lxb_unicode_decomposition_k_3039};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_303A[1] = {0x5345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_303A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_303A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_303A[1] = {0x5345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_303A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_303A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__303A[1] = {0x5345};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__303A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__303A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_303A = {.cp = 0x303A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__303A, .cde = &lxb_unicode_decomposition_c_303A, .kde = &lxb_unicode_decomposition_k_303A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_304C[2] = {0x304B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_304C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_304C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_304C[2] = {0x304B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_304C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_304C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__304C[2] = {0x304B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__304C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__304C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_304C = {.cp = 0x304C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__304C, .cde = &lxb_unicode_decomposition_c_304C, .kde = &lxb_unicode_decomposition_k_304C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_304E[2] = {0x304D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_304E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_304E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_304E[2] = {0x304D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_304E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_304E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__304E[2] = {0x304D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__304E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__304E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_304E = {.cp = 0x304E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__304E, .cde = &lxb_unicode_decomposition_c_304E, .kde = &lxb_unicode_decomposition_k_304E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3050[2] = {0x304F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3050 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3050, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3050[2] = {0x304F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3050 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3050, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3050[2] = {0x304F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3050 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3050, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3050 = {.cp = 0x3050, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3050, .cde = &lxb_unicode_decomposition_c_3050, .kde = &lxb_unicode_decomposition_k_3050};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3052[2] = {0x3051, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3052 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3052, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3052[2] = {0x3051, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3052 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3052, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3052[2] = {0x3051, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3052 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3052, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3052 = {.cp = 0x3052, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3052, .cde = &lxb_unicode_decomposition_c_3052, .kde = &lxb_unicode_decomposition_k_3052};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3054[2] = {0x3053, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3054 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3054, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3054[2] = {0x3053, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3054 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3054, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3054[2] = {0x3053, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3054 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3054, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3054 = {.cp = 0x3054, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3054, .cde = &lxb_unicode_decomposition_c_3054, .kde = &lxb_unicode_decomposition_k_3054};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3056[2] = {0x3055, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3056 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3056, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3056[2] = {0x3055, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3056 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3056, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3056[2] = {0x3055, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3056 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3056, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3056 = {.cp = 0x3056, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3056, .cde = &lxb_unicode_decomposition_c_3056, .kde = &lxb_unicode_decomposition_k_3056};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3058[2] = {0x3057, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3058 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3058, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3058[2] = {0x3057, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3058 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3058, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3058[2] = {0x3057, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3058 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3058, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3058 = {.cp = 0x3058, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3058, .cde = &lxb_unicode_decomposition_c_3058, .kde = &lxb_unicode_decomposition_k_3058};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_305A[2] = {0x3059, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_305A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_305A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_305A[2] = {0x3059, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_305A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_305A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__305A[2] = {0x3059, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__305A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__305A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_305A = {.cp = 0x305A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__305A, .cde = &lxb_unicode_decomposition_c_305A, .kde = &lxb_unicode_decomposition_k_305A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_305C[2] = {0x305B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_305C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_305C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_305C[2] = {0x305B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_305C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_305C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__305C[2] = {0x305B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__305C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__305C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_305C = {.cp = 0x305C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__305C, .cde = &lxb_unicode_decomposition_c_305C, .kde = &lxb_unicode_decomposition_k_305C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_305E[2] = {0x305D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_305E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_305E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_305E[2] = {0x305D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_305E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_305E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__305E[2] = {0x305D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__305E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__305E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_305E = {.cp = 0x305E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__305E, .cde = &lxb_unicode_decomposition_c_305E, .kde = &lxb_unicode_decomposition_k_305E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3060[2] = {0x305F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3060 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3060, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3060[2] = {0x305F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3060 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3060, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3060[2] = {0x305F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3060 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3060, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3060 = {.cp = 0x3060, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3060, .cde = &lxb_unicode_decomposition_c_3060, .kde = &lxb_unicode_decomposition_k_3060};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3062[2] = {0x3061, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3062 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3062, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3062[2] = {0x3061, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3062 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3062, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3062[2] = {0x3061, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3062 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3062, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3062 = {.cp = 0x3062, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3062, .cde = &lxb_unicode_decomposition_c_3062, .kde = &lxb_unicode_decomposition_k_3062};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3065[2] = {0x3064, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3065 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3065, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3065[2] = {0x3064, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3065 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3065, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3065[2] = {0x3064, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3065 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3065, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3065 = {.cp = 0x3065, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3065, .cde = &lxb_unicode_decomposition_c_3065, .kde = &lxb_unicode_decomposition_k_3065};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3067[2] = {0x3066, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3067 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3067, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3067[2] = {0x3066, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3067 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3067, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3067[2] = {0x3066, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3067 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3067, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3067 = {.cp = 0x3067, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3067, .cde = &lxb_unicode_decomposition_c_3067, .kde = &lxb_unicode_decomposition_k_3067};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3069[2] = {0x3068, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3069 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3069, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3069[2] = {0x3068, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3069 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3069, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3069[2] = {0x3068, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3069 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3069, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3069 = {.cp = 0x3069, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3069, .cde = &lxb_unicode_decomposition_c_3069, .kde = &lxb_unicode_decomposition_k_3069};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3070[2] = {0x306F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3070 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3070, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3070[2] = {0x306F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3070 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3070, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3070[2] = {0x306F, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3070 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3070, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3070 = {.cp = 0x3070, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3070, .cde = &lxb_unicode_decomposition_c_3070, .kde = &lxb_unicode_decomposition_k_3070};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3071[2] = {0x306F, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3071 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3071, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3071[2] = {0x306F, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3071 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3071, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3071[2] = {0x306F, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3071 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3071, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3071 = {.cp = 0x3071, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3071, .cde = &lxb_unicode_decomposition_c_3071, .kde = &lxb_unicode_decomposition_k_3071};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3073[2] = {0x3072, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3073 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3073, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3073[2] = {0x3072, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3073 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3073, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3073[2] = {0x3072, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3073 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3073, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3073 = {.cp = 0x3073, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3073, .cde = &lxb_unicode_decomposition_c_3073, .kde = &lxb_unicode_decomposition_k_3073};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3074[2] = {0x3072, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3074 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3074, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3074[2] = {0x3072, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3074 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3074, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3074[2] = {0x3072, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3074 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3074, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3074 = {.cp = 0x3074, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3074, .cde = &lxb_unicode_decomposition_c_3074, .kde = &lxb_unicode_decomposition_k_3074};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3076[2] = {0x3075, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3076 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3076, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3076[2] = {0x3075, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3076 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3076, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3076[2] = {0x3075, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3076 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3076, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3076 = {.cp = 0x3076, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3076, .cde = &lxb_unicode_decomposition_c_3076, .kde = &lxb_unicode_decomposition_k_3076};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3077[2] = {0x3075, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3077 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3077, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3077[2] = {0x3075, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3077 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3077, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3077[2] = {0x3075, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3077 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3077, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3077 = {.cp = 0x3077, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3077, .cde = &lxb_unicode_decomposition_c_3077, .kde = &lxb_unicode_decomposition_k_3077};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3079[2] = {0x3078, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3079 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3079, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3079[2] = {0x3078, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3079 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3079, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3079[2] = {0x3078, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3079 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3079, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3079 = {.cp = 0x3079, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3079, .cde = &lxb_unicode_decomposition_c_3079, .kde = &lxb_unicode_decomposition_k_3079};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_307A[2] = {0x3078, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_307A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_307A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_307A[2] = {0x3078, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_307A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_307A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__307A[2] = {0x3078, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__307A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__307A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_307A = {.cp = 0x307A, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__307A, .cde = &lxb_unicode_decomposition_c_307A, .kde = &lxb_unicode_decomposition_k_307A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_307C[2] = {0x307B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_307C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_307C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_307C[2] = {0x307B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_307C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_307C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__307C[2] = {0x307B, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__307C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__307C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_307C = {.cp = 0x307C, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__307C, .cde = &lxb_unicode_decomposition_c_307C, .kde = &lxb_unicode_decomposition_k_307C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_307D[2] = {0x307B, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_307D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_307D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_307D[2] = {0x307B, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_307D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_307D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__307D[2] = {0x307B, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__307D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__307D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_307D = {.cp = 0x307D, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__307D, .cde = &lxb_unicode_decomposition_c_307D, .kde = &lxb_unicode_decomposition_k_307D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3094[2] = {0x3046, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3094 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_3094, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3094[2] = {0x3046, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3094 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_3094, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3094[2] = {0x3046, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3094 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__3094, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3094 = {.cp = 0x3094, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3094, .cde = &lxb_unicode_decomposition_c_3094, .kde = &lxb_unicode_decomposition_k_3094};

static const lxb_unicode_entry_t lxb_unicode_entry_3099 = {.cp = 0x3099, .ccc = 8, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_309A = {.cp = 0x309A, .ccc = 8, .quick = LXB_UNICODE_NFC_QUICK_MAYBE|LXB_UNICODE_NFKC_QUICK_MAYBE, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_309B[2] = {0x0020, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_309B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_309B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_309B[2] = {0x0020, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_309B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_309B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__309B[2] = {0x0020, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__309B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__309B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_309B = {.cp = 0x309B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__309B, .cde = &lxb_unicode_decomposition_c_309B, .kde = &lxb_unicode_decomposition_k_309B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_309C[2] = {0x0020, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_309C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_309C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_309C[2] = {0x0020, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_309C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_309C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__309C[2] = {0x0020, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__309C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__309C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_309C = {.cp = 0x309C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__309C, .cde = &lxb_unicode_decomposition_c_309C, .kde = &lxb_unicode_decomposition_k_309C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_309E[2] = {0x309D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_309E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_309E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_309E[2] = {0x309D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_309E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_309E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__309E[2] = {0x309D, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__309E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__309E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_309E = {.cp = 0x309E, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__309E, .cde = &lxb_unicode_decomposition_c_309E, .kde = &lxb_unicode_decomposition_k_309E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_309F[2] = {0x3088, 0x308A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_309F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_309F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_309F[2] = {0x3088, 0x308A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_309F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_309F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__309F[2] = {0x3088, 0x308A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__309F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__309F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_309F = {.cp = 0x309F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__309F, .cde = &lxb_unicode_decomposition_c_309F, .kde = &lxb_unicode_decomposition_k_309F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30AC[2] = {0x30AB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30AC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30AC[2] = {0x30AB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30AC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30AC[2] = {0x30AB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30AC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30AC = {.cp = 0x30AC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30AC, .cde = &lxb_unicode_decomposition_c_30AC, .kde = &lxb_unicode_decomposition_k_30AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30AE[2] = {0x30AD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30AE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30AE[2] = {0x30AD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30AE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30AE[2] = {0x30AD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30AE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30AE = {.cp = 0x30AE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30AE, .cde = &lxb_unicode_decomposition_c_30AE, .kde = &lxb_unicode_decomposition_k_30AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30B0[2] = {0x30AF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30B0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30B0[2] = {0x30AF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30B0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30B0[2] = {0x30AF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30B0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30B0 = {.cp = 0x30B0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30B0, .cde = &lxb_unicode_decomposition_c_30B0, .kde = &lxb_unicode_decomposition_k_30B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30B2[2] = {0x30B1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30B2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30B2[2] = {0x30B1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30B2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30B2[2] = {0x30B1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30B2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30B2 = {.cp = 0x30B2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30B2, .cde = &lxb_unicode_decomposition_c_30B2, .kde = &lxb_unicode_decomposition_k_30B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30B4[2] = {0x30B3, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30B4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30B4[2] = {0x30B3, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30B4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30B4[2] = {0x30B3, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30B4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30B4 = {.cp = 0x30B4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30B4, .cde = &lxb_unicode_decomposition_c_30B4, .kde = &lxb_unicode_decomposition_k_30B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30B6[2] = {0x30B5, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30B6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30B6[2] = {0x30B5, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30B6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30B6[2] = {0x30B5, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30B6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30B6 = {.cp = 0x30B6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30B6, .cde = &lxb_unicode_decomposition_c_30B6, .kde = &lxb_unicode_decomposition_k_30B6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30B8[2] = {0x30B7, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30B8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30B8[2] = {0x30B7, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30B8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30B8[2] = {0x30B7, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30B8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30B8 = {.cp = 0x30B8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30B8, .cde = &lxb_unicode_decomposition_c_30B8, .kde = &lxb_unicode_decomposition_k_30B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30BA[2] = {0x30B9, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30BA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30BA[2] = {0x30B9, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30BA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30BA[2] = {0x30B9, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30BA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30BA = {.cp = 0x30BA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30BA, .cde = &lxb_unicode_decomposition_c_30BA, .kde = &lxb_unicode_decomposition_k_30BA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30BC[2] = {0x30BB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30BC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30BC[2] = {0x30BB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30BC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30BC[2] = {0x30BB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30BC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30BC = {.cp = 0x30BC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30BC, .cde = &lxb_unicode_decomposition_c_30BC, .kde = &lxb_unicode_decomposition_k_30BC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30BE[2] = {0x30BD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30BE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30BE[2] = {0x30BD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30BE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30BE[2] = {0x30BD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30BE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30BE = {.cp = 0x30BE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30BE, .cde = &lxb_unicode_decomposition_c_30BE, .kde = &lxb_unicode_decomposition_k_30BE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30C0[2] = {0x30BF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30C0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30C0[2] = {0x30BF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30C0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30C0[2] = {0x30BF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30C0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30C0 = {.cp = 0x30C0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30C0, .cde = &lxb_unicode_decomposition_c_30C0, .kde = &lxb_unicode_decomposition_k_30C0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30C2[2] = {0x30C1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30C2[2] = {0x30C1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30C2[2] = {0x30C1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30C2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30C2 = {.cp = 0x30C2, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30C2, .cde = &lxb_unicode_decomposition_c_30C2, .kde = &lxb_unicode_decomposition_k_30C2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30C5[2] = {0x30C4, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30C5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30C5[2] = {0x30C4, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30C5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30C5[2] = {0x30C4, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30C5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30C5 = {.cp = 0x30C5, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30C5, .cde = &lxb_unicode_decomposition_c_30C5, .kde = &lxb_unicode_decomposition_k_30C5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30C7[2] = {0x30C6, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30C7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30C7[2] = {0x30C6, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30C7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30C7[2] = {0x30C6, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30C7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30C7 = {.cp = 0x30C7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30C7, .cde = &lxb_unicode_decomposition_c_30C7, .kde = &lxb_unicode_decomposition_k_30C7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30C9[2] = {0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30C9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30C9[2] = {0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30C9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30C9[2] = {0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30C9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30C9 = {.cp = 0x30C9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30C9, .cde = &lxb_unicode_decomposition_c_30C9, .kde = &lxb_unicode_decomposition_k_30C9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30D0[2] = {0x30CF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30D0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30D0[2] = {0x30CF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30D0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30D0[2] = {0x30CF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30D0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30D0 = {.cp = 0x30D0, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30D0, .cde = &lxb_unicode_decomposition_c_30D0, .kde = &lxb_unicode_decomposition_k_30D0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30D1[2] = {0x30CF, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30D1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30D1[2] = {0x30CF, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30D1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30D1[2] = {0x30CF, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30D1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30D1 = {.cp = 0x30D1, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30D1, .cde = &lxb_unicode_decomposition_c_30D1, .kde = &lxb_unicode_decomposition_k_30D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30D3[2] = {0x30D2, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30D3[2] = {0x30D2, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30D3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30D3[2] = {0x30D2, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30D3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30D3 = {.cp = 0x30D3, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30D3, .cde = &lxb_unicode_decomposition_c_30D3, .kde = &lxb_unicode_decomposition_k_30D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30D4[2] = {0x30D2, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30D4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30D4[2] = {0x30D2, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30D4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30D4[2] = {0x30D2, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30D4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30D4 = {.cp = 0x30D4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30D4, .cde = &lxb_unicode_decomposition_c_30D4, .kde = &lxb_unicode_decomposition_k_30D4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30D6[2] = {0x30D5, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30D6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30D6[2] = {0x30D5, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30D6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30D6[2] = {0x30D5, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30D6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30D6 = {.cp = 0x30D6, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30D6, .cde = &lxb_unicode_decomposition_c_30D6, .kde = &lxb_unicode_decomposition_k_30D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30D7[2] = {0x30D5, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30D7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30D7[2] = {0x30D5, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30D7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30D7[2] = {0x30D5, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30D7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30D7 = {.cp = 0x30D7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30D7, .cde = &lxb_unicode_decomposition_c_30D7, .kde = &lxb_unicode_decomposition_k_30D7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30D9[2] = {0x30D8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30D9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30D9[2] = {0x30D8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30D9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30D9[2] = {0x30D8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30D9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30D9 = {.cp = 0x30D9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30D9, .cde = &lxb_unicode_decomposition_c_30D9, .kde = &lxb_unicode_decomposition_k_30D9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30DA[2] = {0x30D8, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30DA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30DA[2] = {0x30D8, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30DA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30DA[2] = {0x30D8, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30DA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30DA = {.cp = 0x30DA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30DA, .cde = &lxb_unicode_decomposition_c_30DA, .kde = &lxb_unicode_decomposition_k_30DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30DC[2] = {0x30DB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30DC[2] = {0x30DB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30DC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30DC[2] = {0x30DB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30DC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30DC = {.cp = 0x30DC, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30DC, .cde = &lxb_unicode_decomposition_c_30DC, .kde = &lxb_unicode_decomposition_k_30DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30DD[2] = {0x30DB, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30DD[2] = {0x30DB, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30DD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30DD[2] = {0x30DB, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30DD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30DD = {.cp = 0x30DD, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30DD, .cde = &lxb_unicode_decomposition_c_30DD, .kde = &lxb_unicode_decomposition_k_30DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30F4[2] = {0x30A6, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30F4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30F4[2] = {0x30A6, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30F4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30F4[2] = {0x30A6, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30F4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30F4 = {.cp = 0x30F4, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30F4, .cde = &lxb_unicode_decomposition_c_30F4, .kde = &lxb_unicode_decomposition_k_30F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30F7[2] = {0x30EF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30F7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30F7[2] = {0x30EF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30F7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30F7[2] = {0x30EF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30F7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30F7 = {.cp = 0x30F7, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30F7, .cde = &lxb_unicode_decomposition_c_30F7, .kde = &lxb_unicode_decomposition_k_30F7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30F8[2] = {0x30F0, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30F8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30F8[2] = {0x30F0, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30F8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30F8[2] = {0x30F0, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30F8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30F8 = {.cp = 0x30F8, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30F8, .cde = &lxb_unicode_decomposition_c_30F8, .kde = &lxb_unicode_decomposition_k_30F8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30F9[2] = {0x30F1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30F9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30F9[2] = {0x30F1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30F9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30F9[2] = {0x30F1, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30F9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30F9 = {.cp = 0x30F9, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30F9, .cde = &lxb_unicode_decomposition_c_30F9, .kde = &lxb_unicode_decomposition_k_30F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30FA[2] = {0x30F2, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30FA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30FA[2] = {0x30F2, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30FA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30FA[2] = {0x30F2, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30FA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30FA = {.cp = 0x30FA, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30FA, .cde = &lxb_unicode_decomposition_c_30FA, .kde = &lxb_unicode_decomposition_k_30FA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30FE[2] = {0x30FD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_30FE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30FE[2] = {0x30FD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_30FE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30FE[2] = {0x30FD, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__30FE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30FE = {.cp = 0x30FE, .ccc = 0, .quick = LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30FE, .cde = &lxb_unicode_decomposition_c_30FE, .kde = &lxb_unicode_decomposition_k_30FE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_30FF[2] = {0x30B3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_30FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_c_30FF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_30FF[2] = {0x30B3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_30FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp_k_30FF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__30FF[2] = {0x30B3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__30FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_VERTICAL, .mapping = lxb_unicode_decomposition_cp__30FF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_30FF = {.cp = 0x30FF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__30FF, .cde = &lxb_unicode_decomposition_c_30FF, .kde = &lxb_unicode_decomposition_k_30FF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3131[1] = {0x1100};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3131 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3131, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3131[1] = {0x1100};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3131 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3131, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3131[1] = {0x1100};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3131 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3131, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3131 = {.cp = 0x3131, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3131, .cde = &lxb_unicode_decomposition_c_3131, .kde = &lxb_unicode_decomposition_k_3131};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3132[1] = {0x1101};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3132 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3132, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3132[1] = {0x1101};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3132 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3132, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3132[1] = {0x1101};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3132 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3132, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3132 = {.cp = 0x3132, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3132, .cde = &lxb_unicode_decomposition_c_3132, .kde = &lxb_unicode_decomposition_k_3132};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3133[1] = {0x11AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3133, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3133[1] = {0x11AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3133, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3133[1] = {0x11AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3133 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3133, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3133 = {.cp = 0x3133, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3133, .cde = &lxb_unicode_decomposition_c_3133, .kde = &lxb_unicode_decomposition_k_3133};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3134[1] = {0x1102};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3134, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3134[1] = {0x1102};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3134, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3134[1] = {0x1102};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3134 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3134, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3134 = {.cp = 0x3134, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3134, .cde = &lxb_unicode_decomposition_c_3134, .kde = &lxb_unicode_decomposition_k_3134};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3135[1] = {0x11AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3135, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3135[1] = {0x11AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3135, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3135[1] = {0x11AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3135 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3135, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3135 = {.cp = 0x3135, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3135, .cde = &lxb_unicode_decomposition_c_3135, .kde = &lxb_unicode_decomposition_k_3135};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3136[1] = {0x11AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3136, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3136[1] = {0x11AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3136, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3136[1] = {0x11AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3136 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3136, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3136 = {.cp = 0x3136, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3136, .cde = &lxb_unicode_decomposition_c_3136, .kde = &lxb_unicode_decomposition_k_3136};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3137[1] = {0x1103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3137, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3137[1] = {0x1103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3137, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3137[1] = {0x1103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3137 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3137, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3137 = {.cp = 0x3137, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3137, .cde = &lxb_unicode_decomposition_c_3137, .kde = &lxb_unicode_decomposition_k_3137};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3138[1] = {0x1104};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3138 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3138, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3138[1] = {0x1104};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3138 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3138, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3138[1] = {0x1104};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3138 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3138, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3138 = {.cp = 0x3138, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3138, .cde = &lxb_unicode_decomposition_c_3138, .kde = &lxb_unicode_decomposition_k_3138};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3139[1] = {0x1105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3139, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3139[1] = {0x1105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3139, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3139[1] = {0x1105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3139 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3139, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3139 = {.cp = 0x3139, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3139, .cde = &lxb_unicode_decomposition_c_3139, .kde = &lxb_unicode_decomposition_k_3139};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_313A[1] = {0x11B0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_313A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_313A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_313A[1] = {0x11B0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_313A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_313A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__313A[1] = {0x11B0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__313A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__313A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_313A = {.cp = 0x313A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__313A, .cde = &lxb_unicode_decomposition_c_313A, .kde = &lxb_unicode_decomposition_k_313A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_313B[1] = {0x11B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_313B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_313B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_313B[1] = {0x11B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_313B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_313B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__313B[1] = {0x11B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__313B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__313B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_313B = {.cp = 0x313B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__313B, .cde = &lxb_unicode_decomposition_c_313B, .kde = &lxb_unicode_decomposition_k_313B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_313C[1] = {0x11B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_313C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_313C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_313C[1] = {0x11B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_313C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_313C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__313C[1] = {0x11B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__313C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__313C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_313C = {.cp = 0x313C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__313C, .cde = &lxb_unicode_decomposition_c_313C, .kde = &lxb_unicode_decomposition_k_313C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_313D[1] = {0x11B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_313D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_313D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_313D[1] = {0x11B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_313D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_313D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__313D[1] = {0x11B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__313D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__313D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_313D = {.cp = 0x313D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__313D, .cde = &lxb_unicode_decomposition_c_313D, .kde = &lxb_unicode_decomposition_k_313D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_313E[1] = {0x11B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_313E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_313E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_313E[1] = {0x11B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_313E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_313E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__313E[1] = {0x11B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__313E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__313E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_313E = {.cp = 0x313E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__313E, .cde = &lxb_unicode_decomposition_c_313E, .kde = &lxb_unicode_decomposition_k_313E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_313F[1] = {0x11B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_313F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_313F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_313F[1] = {0x11B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_313F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_313F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__313F[1] = {0x11B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__313F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__313F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_313F = {.cp = 0x313F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__313F, .cde = &lxb_unicode_decomposition_c_313F, .kde = &lxb_unicode_decomposition_k_313F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3140[1] = {0x111A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3140, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3140[1] = {0x111A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3140, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3140[1] = {0x111A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3140 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3140, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3140 = {.cp = 0x3140, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3140, .cde = &lxb_unicode_decomposition_c_3140, .kde = &lxb_unicode_decomposition_k_3140};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3141[1] = {0x1106};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3141 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3141, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3141[1] = {0x1106};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3141 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3141, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3141[1] = {0x1106};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3141 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3141, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3141 = {.cp = 0x3141, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3141, .cde = &lxb_unicode_decomposition_c_3141, .kde = &lxb_unicode_decomposition_k_3141};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3142[1] = {0x1107};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3142 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3142, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3142[1] = {0x1107};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3142 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3142, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3142[1] = {0x1107};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3142 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3142, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3142 = {.cp = 0x3142, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3142, .cde = &lxb_unicode_decomposition_c_3142, .kde = &lxb_unicode_decomposition_k_3142};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3143[1] = {0x1108};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3143 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3143, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3143[1] = {0x1108};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3143 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3143, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3143[1] = {0x1108};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3143 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3143, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3143 = {.cp = 0x3143, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3143, .cde = &lxb_unicode_decomposition_c_3143, .kde = &lxb_unicode_decomposition_k_3143};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3144[1] = {0x1121};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3144 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3144, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3144[1] = {0x1121};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3144 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3144, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3144[1] = {0x1121};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3144 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3144, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3144 = {.cp = 0x3144, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3144, .cde = &lxb_unicode_decomposition_c_3144, .kde = &lxb_unicode_decomposition_k_3144};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3145[1] = {0x1109};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3145, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3145[1] = {0x1109};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3145, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3145[1] = {0x1109};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3145 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3145, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3145 = {.cp = 0x3145, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3145, .cde = &lxb_unicode_decomposition_c_3145, .kde = &lxb_unicode_decomposition_k_3145};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3146[1] = {0x110A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3146, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3146[1] = {0x110A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3146, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3146[1] = {0x110A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3146 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3146, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3146 = {.cp = 0x3146, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3146, .cde = &lxb_unicode_decomposition_c_3146, .kde = &lxb_unicode_decomposition_k_3146};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3147[1] = {0x110B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3147, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3147[1] = {0x110B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3147, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3147[1] = {0x110B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3147 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3147, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3147 = {.cp = 0x3147, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3147, .cde = &lxb_unicode_decomposition_c_3147, .kde = &lxb_unicode_decomposition_k_3147};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3148[1] = {0x110C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3148, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3148[1] = {0x110C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3148, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3148[1] = {0x110C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3148 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3148, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3148 = {.cp = 0x3148, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3148, .cde = &lxb_unicode_decomposition_c_3148, .kde = &lxb_unicode_decomposition_k_3148};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3149[1] = {0x110D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3149, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3149[1] = {0x110D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3149, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3149[1] = {0x110D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3149 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3149, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3149 = {.cp = 0x3149, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3149, .cde = &lxb_unicode_decomposition_c_3149, .kde = &lxb_unicode_decomposition_k_3149};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_314A[1] = {0x110E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_314A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_314A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_314A[1] = {0x110E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_314A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_314A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__314A[1] = {0x110E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__314A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__314A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_314A = {.cp = 0x314A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__314A, .cde = &lxb_unicode_decomposition_c_314A, .kde = &lxb_unicode_decomposition_k_314A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_314B[1] = {0x110F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_314B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_314B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_314B[1] = {0x110F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_314B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_314B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__314B[1] = {0x110F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__314B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__314B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_314B = {.cp = 0x314B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__314B, .cde = &lxb_unicode_decomposition_c_314B, .kde = &lxb_unicode_decomposition_k_314B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_314C[1] = {0x1110};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_314C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_314C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_314C[1] = {0x1110};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_314C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_314C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__314C[1] = {0x1110};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__314C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__314C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_314C = {.cp = 0x314C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__314C, .cde = &lxb_unicode_decomposition_c_314C, .kde = &lxb_unicode_decomposition_k_314C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_314D[1] = {0x1111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_314D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_314D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_314D[1] = {0x1111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_314D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_314D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__314D[1] = {0x1111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__314D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__314D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_314D = {.cp = 0x314D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__314D, .cde = &lxb_unicode_decomposition_c_314D, .kde = &lxb_unicode_decomposition_k_314D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_314E[1] = {0x1112};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_314E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_314E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_314E[1] = {0x1112};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_314E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_314E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__314E[1] = {0x1112};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__314E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__314E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_314E = {.cp = 0x314E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__314E, .cde = &lxb_unicode_decomposition_c_314E, .kde = &lxb_unicode_decomposition_k_314E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_314F[1] = {0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_314F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_314F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_314F[1] = {0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_314F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_314F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__314F[1] = {0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__314F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__314F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_314F = {.cp = 0x314F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__314F, .cde = &lxb_unicode_decomposition_c_314F, .kde = &lxb_unicode_decomposition_k_314F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3150[1] = {0x1162};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3150, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3150[1] = {0x1162};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3150, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3150[1] = {0x1162};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3150 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3150, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3150 = {.cp = 0x3150, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3150, .cde = &lxb_unicode_decomposition_c_3150, .kde = &lxb_unicode_decomposition_k_3150};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3151[1] = {0x1163};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3151, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3151[1] = {0x1163};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3151, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3151[1] = {0x1163};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3151 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3151, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3151 = {.cp = 0x3151, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3151, .cde = &lxb_unicode_decomposition_c_3151, .kde = &lxb_unicode_decomposition_k_3151};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3152[1] = {0x1164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3152 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3152, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3152[1] = {0x1164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3152 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3152, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3152[1] = {0x1164};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3152 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3152, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3152 = {.cp = 0x3152, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3152, .cde = &lxb_unicode_decomposition_c_3152, .kde = &lxb_unicode_decomposition_k_3152};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3153[1] = {0x1165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3153 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3153, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3153[1] = {0x1165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3153 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3153, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3153[1] = {0x1165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3153 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3153, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3153 = {.cp = 0x3153, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3153, .cde = &lxb_unicode_decomposition_c_3153, .kde = &lxb_unicode_decomposition_k_3153};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3154[1] = {0x1166};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3154, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3154[1] = {0x1166};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3154, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3154[1] = {0x1166};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3154 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3154, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3154 = {.cp = 0x3154, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3154, .cde = &lxb_unicode_decomposition_c_3154, .kde = &lxb_unicode_decomposition_k_3154};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3155[1] = {0x1167};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3155, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3155[1] = {0x1167};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3155, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3155[1] = {0x1167};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3155 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3155, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3155 = {.cp = 0x3155, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3155, .cde = &lxb_unicode_decomposition_c_3155, .kde = &lxb_unicode_decomposition_k_3155};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3156[1] = {0x1168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3156, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3156[1] = {0x1168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3156, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3156[1] = {0x1168};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3156 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3156, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3156 = {.cp = 0x3156, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3156, .cde = &lxb_unicode_decomposition_c_3156, .kde = &lxb_unicode_decomposition_k_3156};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3157[1] = {0x1169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3157, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3157[1] = {0x1169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3157, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3157[1] = {0x1169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3157 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3157, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3157 = {.cp = 0x3157, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3157, .cde = &lxb_unicode_decomposition_c_3157, .kde = &lxb_unicode_decomposition_k_3157};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3158[1] = {0x116A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3158, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3158[1] = {0x116A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3158, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3158[1] = {0x116A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3158 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3158, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3158 = {.cp = 0x3158, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3158, .cde = &lxb_unicode_decomposition_c_3158, .kde = &lxb_unicode_decomposition_k_3158};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3159[1] = {0x116B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3159, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3159[1] = {0x116B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3159, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3159[1] = {0x116B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3159 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3159, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3159 = {.cp = 0x3159, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3159, .cde = &lxb_unicode_decomposition_c_3159, .kde = &lxb_unicode_decomposition_k_3159};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_315A[1] = {0x116C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_315A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_315A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_315A[1] = {0x116C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_315A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_315A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__315A[1] = {0x116C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__315A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__315A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_315A = {.cp = 0x315A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__315A, .cde = &lxb_unicode_decomposition_c_315A, .kde = &lxb_unicode_decomposition_k_315A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_315B[1] = {0x116D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_315B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_315B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_315B[1] = {0x116D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_315B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_315B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__315B[1] = {0x116D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__315B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__315B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_315B = {.cp = 0x315B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__315B, .cde = &lxb_unicode_decomposition_c_315B, .kde = &lxb_unicode_decomposition_k_315B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_315C[1] = {0x116E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_315C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_315C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_315C[1] = {0x116E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_315C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_315C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__315C[1] = {0x116E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__315C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__315C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_315C = {.cp = 0x315C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__315C, .cde = &lxb_unicode_decomposition_c_315C, .kde = &lxb_unicode_decomposition_k_315C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_315D[1] = {0x116F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_315D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_315D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_315D[1] = {0x116F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_315D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_315D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__315D[1] = {0x116F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__315D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__315D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_315D = {.cp = 0x315D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__315D, .cde = &lxb_unicode_decomposition_c_315D, .kde = &lxb_unicode_decomposition_k_315D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_315E[1] = {0x1170};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_315E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_315E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_315E[1] = {0x1170};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_315E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_315E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__315E[1] = {0x1170};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__315E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__315E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_315E = {.cp = 0x315E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__315E, .cde = &lxb_unicode_decomposition_c_315E, .kde = &lxb_unicode_decomposition_k_315E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_315F[1] = {0x1171};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_315F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_315F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_315F[1] = {0x1171};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_315F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_315F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__315F[1] = {0x1171};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__315F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__315F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_315F = {.cp = 0x315F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__315F, .cde = &lxb_unicode_decomposition_c_315F, .kde = &lxb_unicode_decomposition_k_315F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3160[1] = {0x1172};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3160, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3160[1] = {0x1172};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3160, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3160[1] = {0x1172};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3160, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3160 = {.cp = 0x3160, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3160, .cde = &lxb_unicode_decomposition_c_3160, .kde = &lxb_unicode_decomposition_k_3160};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3161[1] = {0x1173};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3161, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3161[1] = {0x1173};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3161, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3161[1] = {0x1173};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3161, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3161 = {.cp = 0x3161, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3161, .cde = &lxb_unicode_decomposition_c_3161, .kde = &lxb_unicode_decomposition_k_3161};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3162[1] = {0x1174};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3162, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3162[1] = {0x1174};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3162, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3162[1] = {0x1174};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3162, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3162 = {.cp = 0x3162, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3162, .cde = &lxb_unicode_decomposition_c_3162, .kde = &lxb_unicode_decomposition_k_3162};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3163[1] = {0x1175};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3163, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3163[1] = {0x1175};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3163, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3163[1] = {0x1175};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3163, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3163 = {.cp = 0x3163, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3163, .cde = &lxb_unicode_decomposition_c_3163, .kde = &lxb_unicode_decomposition_k_3163};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3164[1] = {0x1160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3164, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3164[1] = {0x1160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3164, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3164[1] = {0x1160};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3164, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3164 = {.cp = 0x3164, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3164, .cde = &lxb_unicode_decomposition_c_3164, .kde = &lxb_unicode_decomposition_k_3164};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3165[1] = {0x1114};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3165, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3165[1] = {0x1114};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3165, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3165[1] = {0x1114};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3165 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3165, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3165 = {.cp = 0x3165, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3165, .cde = &lxb_unicode_decomposition_c_3165, .kde = &lxb_unicode_decomposition_k_3165};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3166[1] = {0x1115};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3166 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3166, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3166[1] = {0x1115};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3166 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3166, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3166[1] = {0x1115};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3166 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3166, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3166 = {.cp = 0x3166, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3166, .cde = &lxb_unicode_decomposition_c_3166, .kde = &lxb_unicode_decomposition_k_3166};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3167[1] = {0x11C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3167 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3167, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3167[1] = {0x11C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3167 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3167, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3167[1] = {0x11C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3167 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3167, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3167 = {.cp = 0x3167, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3167, .cde = &lxb_unicode_decomposition_c_3167, .kde = &lxb_unicode_decomposition_k_3167};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3168[1] = {0x11C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3168, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3168[1] = {0x11C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3168, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3168[1] = {0x11C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3168 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3168, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3168 = {.cp = 0x3168, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3168, .cde = &lxb_unicode_decomposition_c_3168, .kde = &lxb_unicode_decomposition_k_3168};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3169[1] = {0x11CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3169, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3169[1] = {0x11CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3169, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3169[1] = {0x11CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3169 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3169, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3169 = {.cp = 0x3169, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3169, .cde = &lxb_unicode_decomposition_c_3169, .kde = &lxb_unicode_decomposition_k_3169};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_316A[1] = {0x11CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_316A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_316A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_316A[1] = {0x11CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_316A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_316A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__316A[1] = {0x11CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__316A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__316A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_316A = {.cp = 0x316A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__316A, .cde = &lxb_unicode_decomposition_c_316A, .kde = &lxb_unicode_decomposition_k_316A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_316B[1] = {0x11D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_316B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_316B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_316B[1] = {0x11D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_316B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_316B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__316B[1] = {0x11D3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__316B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__316B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_316B = {.cp = 0x316B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__316B, .cde = &lxb_unicode_decomposition_c_316B, .kde = &lxb_unicode_decomposition_k_316B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_316C[1] = {0x11D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_316C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_316C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_316C[1] = {0x11D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_316C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_316C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__316C[1] = {0x11D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__316C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__316C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_316C = {.cp = 0x316C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__316C, .cde = &lxb_unicode_decomposition_c_316C, .kde = &lxb_unicode_decomposition_k_316C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_316D[1] = {0x11D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_316D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_316D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_316D[1] = {0x11D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_316D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_316D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__316D[1] = {0x11D9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__316D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__316D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_316D = {.cp = 0x316D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__316D, .cde = &lxb_unicode_decomposition_c_316D, .kde = &lxb_unicode_decomposition_k_316D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_316E[1] = {0x111C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_316E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_316E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_316E[1] = {0x111C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_316E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_316E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__316E[1] = {0x111C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__316E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__316E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_316E = {.cp = 0x316E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__316E, .cde = &lxb_unicode_decomposition_c_316E, .kde = &lxb_unicode_decomposition_k_316E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_316F[1] = {0x11DD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_316F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_316F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_316F[1] = {0x11DD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_316F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_316F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__316F[1] = {0x11DD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__316F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__316F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_316F = {.cp = 0x316F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__316F, .cde = &lxb_unicode_decomposition_c_316F, .kde = &lxb_unicode_decomposition_k_316F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3170[1] = {0x11DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3170, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3170[1] = {0x11DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3170, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3170[1] = {0x11DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3170 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3170, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3170 = {.cp = 0x3170, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3170, .cde = &lxb_unicode_decomposition_c_3170, .kde = &lxb_unicode_decomposition_k_3170};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3171[1] = {0x111D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3171, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3171[1] = {0x111D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3171, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3171[1] = {0x111D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3171 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3171, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3171 = {.cp = 0x3171, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3171, .cde = &lxb_unicode_decomposition_c_3171, .kde = &lxb_unicode_decomposition_k_3171};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3172[1] = {0x111E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3172, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3172[1] = {0x111E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3172, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3172[1] = {0x111E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3172 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3172, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3172 = {.cp = 0x3172, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3172, .cde = &lxb_unicode_decomposition_c_3172, .kde = &lxb_unicode_decomposition_k_3172};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3173[1] = {0x1120};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3173, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3173[1] = {0x1120};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3173, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3173[1] = {0x1120};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3173 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3173, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3173 = {.cp = 0x3173, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3173, .cde = &lxb_unicode_decomposition_c_3173, .kde = &lxb_unicode_decomposition_k_3173};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3174[1] = {0x1122};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3174, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3174[1] = {0x1122};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3174, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3174[1] = {0x1122};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3174 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3174, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3174 = {.cp = 0x3174, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3174, .cde = &lxb_unicode_decomposition_c_3174, .kde = &lxb_unicode_decomposition_k_3174};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3175[1] = {0x1123};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3175, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3175[1] = {0x1123};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3175, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3175[1] = {0x1123};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3175 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3175, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3175 = {.cp = 0x3175, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3175, .cde = &lxb_unicode_decomposition_c_3175, .kde = &lxb_unicode_decomposition_k_3175};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3176[1] = {0x1127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3176, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3176[1] = {0x1127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3176, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3176[1] = {0x1127};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3176 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3176, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3176 = {.cp = 0x3176, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3176, .cde = &lxb_unicode_decomposition_c_3176, .kde = &lxb_unicode_decomposition_k_3176};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3177[1] = {0x1129};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3177, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3177[1] = {0x1129};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3177, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3177[1] = {0x1129};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3177 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3177, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3177 = {.cp = 0x3177, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3177, .cde = &lxb_unicode_decomposition_c_3177, .kde = &lxb_unicode_decomposition_k_3177};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3178[1] = {0x112B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3178, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3178[1] = {0x112B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3178, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3178[1] = {0x112B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3178 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3178, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3178 = {.cp = 0x3178, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3178, .cde = &lxb_unicode_decomposition_c_3178, .kde = &lxb_unicode_decomposition_k_3178};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3179[1] = {0x112C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3179, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3179[1] = {0x112C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3179, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3179[1] = {0x112C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3179 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3179, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3179 = {.cp = 0x3179, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3179, .cde = &lxb_unicode_decomposition_c_3179, .kde = &lxb_unicode_decomposition_k_3179};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_317A[1] = {0x112D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_317A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_317A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_317A[1] = {0x112D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_317A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_317A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__317A[1] = {0x112D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__317A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__317A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_317A = {.cp = 0x317A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__317A, .cde = &lxb_unicode_decomposition_c_317A, .kde = &lxb_unicode_decomposition_k_317A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_317B[1] = {0x112E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_317B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_317B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_317B[1] = {0x112E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_317B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_317B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__317B[1] = {0x112E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__317B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__317B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_317B = {.cp = 0x317B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__317B, .cde = &lxb_unicode_decomposition_c_317B, .kde = &lxb_unicode_decomposition_k_317B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_317C[1] = {0x112F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_317C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_317C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_317C[1] = {0x112F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_317C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_317C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__317C[1] = {0x112F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__317C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__317C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_317C = {.cp = 0x317C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__317C, .cde = &lxb_unicode_decomposition_c_317C, .kde = &lxb_unicode_decomposition_k_317C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_317D[1] = {0x1132};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_317D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_317D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_317D[1] = {0x1132};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_317D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_317D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__317D[1] = {0x1132};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__317D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__317D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_317D = {.cp = 0x317D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__317D, .cde = &lxb_unicode_decomposition_c_317D, .kde = &lxb_unicode_decomposition_k_317D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_317E[1] = {0x1136};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_317E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_317E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_317E[1] = {0x1136};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_317E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_317E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__317E[1] = {0x1136};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__317E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__317E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_317E = {.cp = 0x317E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__317E, .cde = &lxb_unicode_decomposition_c_317E, .kde = &lxb_unicode_decomposition_k_317E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_317F[1] = {0x1140};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_317F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_317F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_317F[1] = {0x1140};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_317F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_317F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__317F[1] = {0x1140};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__317F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__317F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_317F = {.cp = 0x317F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__317F, .cde = &lxb_unicode_decomposition_c_317F, .kde = &lxb_unicode_decomposition_k_317F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3180[1] = {0x1147};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3180 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3180, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3180[1] = {0x1147};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3180 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3180, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3180[1] = {0x1147};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3180 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3180, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3180 = {.cp = 0x3180, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3180, .cde = &lxb_unicode_decomposition_c_3180, .kde = &lxb_unicode_decomposition_k_3180};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3181[1] = {0x114C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3181 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3181, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3181[1] = {0x114C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3181 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3181, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3181[1] = {0x114C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3181 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3181, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3181 = {.cp = 0x3181, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3181, .cde = &lxb_unicode_decomposition_c_3181, .kde = &lxb_unicode_decomposition_k_3181};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3182[1] = {0x11F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3182 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3182, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3182[1] = {0x11F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3182 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3182, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3182[1] = {0x11F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3182 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3182, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3182 = {.cp = 0x3182, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3182, .cde = &lxb_unicode_decomposition_c_3182, .kde = &lxb_unicode_decomposition_k_3182};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3183[1] = {0x11F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3183 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3183, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3183[1] = {0x11F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3183 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3183, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3183[1] = {0x11F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3183 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3183, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3183 = {.cp = 0x3183, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3183, .cde = &lxb_unicode_decomposition_c_3183, .kde = &lxb_unicode_decomposition_k_3183};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3184[1] = {0x1157};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3184 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3184, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3184[1] = {0x1157};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3184 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3184, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3184[1] = {0x1157};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3184 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3184, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3184 = {.cp = 0x3184, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3184, .cde = &lxb_unicode_decomposition_c_3184, .kde = &lxb_unicode_decomposition_k_3184};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3185[1] = {0x1158};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3185 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3185, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3185[1] = {0x1158};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3185 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3185, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3185[1] = {0x1158};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3185 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3185, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3185 = {.cp = 0x3185, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3185, .cde = &lxb_unicode_decomposition_c_3185, .kde = &lxb_unicode_decomposition_k_3185};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3186[1] = {0x1159};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3186 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3186, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3186[1] = {0x1159};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3186 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3186, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3186[1] = {0x1159};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3186 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3186, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3186 = {.cp = 0x3186, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3186, .cde = &lxb_unicode_decomposition_c_3186, .kde = &lxb_unicode_decomposition_k_3186};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3187[1] = {0x1184};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3187 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3187, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3187[1] = {0x1184};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3187 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3187, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3187[1] = {0x1184};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3187 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3187, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3187 = {.cp = 0x3187, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3187, .cde = &lxb_unicode_decomposition_c_3187, .kde = &lxb_unicode_decomposition_k_3187};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3188[1] = {0x1185};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3188 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3188, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3188[1] = {0x1185};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3188 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3188, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3188[1] = {0x1185};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3188 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3188, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3188 = {.cp = 0x3188, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3188, .cde = &lxb_unicode_decomposition_c_3188, .kde = &lxb_unicode_decomposition_k_3188};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3189[1] = {0x1188};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3189 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3189, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3189[1] = {0x1188};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3189 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3189, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3189[1] = {0x1188};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3189 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3189, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3189 = {.cp = 0x3189, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3189, .cde = &lxb_unicode_decomposition_c_3189, .kde = &lxb_unicode_decomposition_k_3189};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_318A[1] = {0x1191};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_318A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_318A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_318A[1] = {0x1191};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_318A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_318A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__318A[1] = {0x1191};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__318A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__318A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_318A = {.cp = 0x318A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__318A, .cde = &lxb_unicode_decomposition_c_318A, .kde = &lxb_unicode_decomposition_k_318A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_318B[1] = {0x1192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_318B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_318B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_318B[1] = {0x1192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_318B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_318B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__318B[1] = {0x1192};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__318B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__318B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_318B = {.cp = 0x318B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__318B, .cde = &lxb_unicode_decomposition_c_318B, .kde = &lxb_unicode_decomposition_k_318B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_318C[1] = {0x1194};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_318C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_318C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_318C[1] = {0x1194};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_318C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_318C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__318C[1] = {0x1194};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__318C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__318C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_318C = {.cp = 0x318C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__318C, .cde = &lxb_unicode_decomposition_c_318C, .kde = &lxb_unicode_decomposition_k_318C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_318D[1] = {0x119E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_318D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_318D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_318D[1] = {0x119E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_318D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_318D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__318D[1] = {0x119E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__318D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__318D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_318D = {.cp = 0x318D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__318D, .cde = &lxb_unicode_decomposition_c_318D, .kde = &lxb_unicode_decomposition_k_318D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_318E[1] = {0x11A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_318E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_318E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_318E[1] = {0x11A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_318E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_318E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__318E[1] = {0x11A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__318E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__318E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_318E = {.cp = 0x318E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__318E, .cde = &lxb_unicode_decomposition_c_318E, .kde = &lxb_unicode_decomposition_k_318E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3192[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3192 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_3192, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3192[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3192 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_3192, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3192[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3192 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__3192, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3192 = {.cp = 0x3192, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3192, .cde = &lxb_unicode_decomposition_c_3192, .kde = &lxb_unicode_decomposition_k_3192};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3193[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3193 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_3193, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3193[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3193 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_3193, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3193[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3193 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__3193, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3193 = {.cp = 0x3193, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3193, .cde = &lxb_unicode_decomposition_c_3193, .kde = &lxb_unicode_decomposition_k_3193};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3194[1] = {0x4E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3194 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_3194, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3194[1] = {0x4E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3194 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_3194, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3194[1] = {0x4E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3194 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__3194, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3194 = {.cp = 0x3194, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3194, .cde = &lxb_unicode_decomposition_c_3194, .kde = &lxb_unicode_decomposition_k_3194};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3195[1] = {0x56DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3195 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_3195, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3195[1] = {0x56DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3195 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_3195, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3195[1] = {0x56DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3195 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__3195, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3195 = {.cp = 0x3195, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3195, .cde = &lxb_unicode_decomposition_c_3195, .kde = &lxb_unicode_decomposition_k_3195};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3196[1] = {0x4E0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3196 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_3196, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3196[1] = {0x4E0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3196 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_3196, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3196[1] = {0x4E0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3196 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__3196, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3196 = {.cp = 0x3196, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3196, .cde = &lxb_unicode_decomposition_c_3196, .kde = &lxb_unicode_decomposition_k_3196};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3197[1] = {0x4E2D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3197 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_3197, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3197[1] = {0x4E2D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3197 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_3197, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3197[1] = {0x4E2D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3197 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__3197, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3197 = {.cp = 0x3197, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3197, .cde = &lxb_unicode_decomposition_c_3197, .kde = &lxb_unicode_decomposition_k_3197};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3198[1] = {0x4E0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3198 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_3198, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3198[1] = {0x4E0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3198 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_3198, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3198[1] = {0x4E0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3198 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__3198, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3198 = {.cp = 0x3198, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3198, .cde = &lxb_unicode_decomposition_c_3198, .kde = &lxb_unicode_decomposition_k_3198};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3199[1] = {0x7532};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3199 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_3199, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3199[1] = {0x7532};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3199 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_3199, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3199[1] = {0x7532};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3199 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__3199, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3199 = {.cp = 0x3199, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3199, .cde = &lxb_unicode_decomposition_c_3199, .kde = &lxb_unicode_decomposition_k_3199};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_319A[1] = {0x4E59};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_319A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_319A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_319A[1] = {0x4E59};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_319A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_319A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__319A[1] = {0x4E59};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__319A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__319A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_319A = {.cp = 0x319A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__319A, .cde = &lxb_unicode_decomposition_c_319A, .kde = &lxb_unicode_decomposition_k_319A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_319B[1] = {0x4E19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_319B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_319B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_319B[1] = {0x4E19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_319B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_319B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__319B[1] = {0x4E19};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__319B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__319B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_319B = {.cp = 0x319B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__319B, .cde = &lxb_unicode_decomposition_c_319B, .kde = &lxb_unicode_decomposition_k_319B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_319C[1] = {0x4E01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_319C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_319C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_319C[1] = {0x4E01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_319C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_319C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__319C[1] = {0x4E01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__319C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__319C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_319C = {.cp = 0x319C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__319C, .cde = &lxb_unicode_decomposition_c_319C, .kde = &lxb_unicode_decomposition_k_319C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_319D[1] = {0x5929};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_319D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_319D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_319D[1] = {0x5929};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_319D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_319D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__319D[1] = {0x5929};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__319D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__319D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_319D = {.cp = 0x319D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__319D, .cde = &lxb_unicode_decomposition_c_319D, .kde = &lxb_unicode_decomposition_k_319D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_319E[1] = {0x5730};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_319E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_319E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_319E[1] = {0x5730};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_319E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_319E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__319E[1] = {0x5730};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__319E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__319E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_319E = {.cp = 0x319E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__319E, .cde = &lxb_unicode_decomposition_c_319E, .kde = &lxb_unicode_decomposition_k_319E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_319F[1] = {0x4EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_319F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_c_319F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_319F[1] = {0x4EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_319F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp_k_319F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__319F[1] = {0x4EBA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__319F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SUPER, .mapping = lxb_unicode_decomposition_cp__319F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_319F = {.cp = 0x319F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__319F, .cde = &lxb_unicode_decomposition_c_319F, .kde = &lxb_unicode_decomposition_k_319F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3200[3] = {0x0028, 0x1100, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3200 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3200, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3200[3] = {0x0028, 0x1100, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3200 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3200, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3200[3] = {0x0028, 0x1100, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3200 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3200, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3200 = {.cp = 0x3200, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3200, .cde = &lxb_unicode_decomposition_c_3200, .kde = &lxb_unicode_decomposition_k_3200};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3201[3] = {0x0028, 0x1102, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3201 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3201, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3201[3] = {0x0028, 0x1102, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3201 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3201, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3201[3] = {0x0028, 0x1102, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3201 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3201, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3201 = {.cp = 0x3201, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3201, .cde = &lxb_unicode_decomposition_c_3201, .kde = &lxb_unicode_decomposition_k_3201};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3202[3] = {0x0028, 0x1103, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3202 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3202, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3202[3] = {0x0028, 0x1103, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3202 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3202, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3202[3] = {0x0028, 0x1103, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3202 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3202, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3202 = {.cp = 0x3202, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3202, .cde = &lxb_unicode_decomposition_c_3202, .kde = &lxb_unicode_decomposition_k_3202};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3203[3] = {0x0028, 0x1105, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3203 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3203, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3203[3] = {0x0028, 0x1105, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3203 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3203, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3203[3] = {0x0028, 0x1105, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3203 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3203, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3203 = {.cp = 0x3203, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3203, .cde = &lxb_unicode_decomposition_c_3203, .kde = &lxb_unicode_decomposition_k_3203};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3204[3] = {0x0028, 0x1106, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3204, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3204[3] = {0x0028, 0x1106, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3204, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3204[3] = {0x0028, 0x1106, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3204 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3204, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3204 = {.cp = 0x3204, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3204, .cde = &lxb_unicode_decomposition_c_3204, .kde = &lxb_unicode_decomposition_k_3204};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3205[3] = {0x0028, 0x1107, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3205 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3205, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3205[3] = {0x0028, 0x1107, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3205 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3205, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3205[3] = {0x0028, 0x1107, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3205 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3205, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3205 = {.cp = 0x3205, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3205, .cde = &lxb_unicode_decomposition_c_3205, .kde = &lxb_unicode_decomposition_k_3205};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3206[3] = {0x0028, 0x1109, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3206 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3206, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3206[3] = {0x0028, 0x1109, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3206 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3206, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3206[3] = {0x0028, 0x1109, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3206 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3206, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3206 = {.cp = 0x3206, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3206, .cde = &lxb_unicode_decomposition_c_3206, .kde = &lxb_unicode_decomposition_k_3206};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3207[3] = {0x0028, 0x110B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3207 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3207, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3207[3] = {0x0028, 0x110B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3207 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3207, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3207[3] = {0x0028, 0x110B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3207 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3207, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3207 = {.cp = 0x3207, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3207, .cde = &lxb_unicode_decomposition_c_3207, .kde = &lxb_unicode_decomposition_k_3207};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3208[3] = {0x0028, 0x110C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3208 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3208, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3208[3] = {0x0028, 0x110C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3208 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3208, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3208[3] = {0x0028, 0x110C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3208 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3208, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3208 = {.cp = 0x3208, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3208, .cde = &lxb_unicode_decomposition_c_3208, .kde = &lxb_unicode_decomposition_k_3208};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3209[3] = {0x0028, 0x110E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3209, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3209[3] = {0x0028, 0x110E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3209, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3209[3] = {0x0028, 0x110E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3209 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3209, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3209 = {.cp = 0x3209, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3209, .cde = &lxb_unicode_decomposition_c_3209, .kde = &lxb_unicode_decomposition_k_3209};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_320A[3] = {0x0028, 0x110F, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_320A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_320A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_320A[3] = {0x0028, 0x110F, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_320A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_320A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__320A[3] = {0x0028, 0x110F, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__320A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__320A, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_320A = {.cp = 0x320A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__320A, .cde = &lxb_unicode_decomposition_c_320A, .kde = &lxb_unicode_decomposition_k_320A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_320B[3] = {0x0028, 0x1110, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_320B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_320B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_320B[3] = {0x0028, 0x1110, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_320B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_320B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__320B[3] = {0x0028, 0x1110, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__320B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__320B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_320B = {.cp = 0x320B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__320B, .cde = &lxb_unicode_decomposition_c_320B, .kde = &lxb_unicode_decomposition_k_320B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_320C[3] = {0x0028, 0x1111, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_320C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_320C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_320C[3] = {0x0028, 0x1111, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_320C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_320C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__320C[3] = {0x0028, 0x1111, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__320C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__320C, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_320C = {.cp = 0x320C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__320C, .cde = &lxb_unicode_decomposition_c_320C, .kde = &lxb_unicode_decomposition_k_320C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_320D[3] = {0x0028, 0x1112, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_320D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_320D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_320D[3] = {0x0028, 0x1112, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_320D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_320D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__320D[3] = {0x0028, 0x1112, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__320D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__320D, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_320D = {.cp = 0x320D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__320D, .cde = &lxb_unicode_decomposition_c_320D, .kde = &lxb_unicode_decomposition_k_320D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_320E[4] = {0x0028, 0x1100, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_320E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_320E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_320E[4] = {0x0028, 0x1100, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_320E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_320E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__320E[4] = {0x0028, 0x1100, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__320E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__320E, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_320E = {.cp = 0x320E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__320E, .cde = &lxb_unicode_decomposition_c_320E, .kde = &lxb_unicode_decomposition_k_320E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_320F[4] = {0x0028, 0x1102, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_320F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_320F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_320F[4] = {0x0028, 0x1102, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_320F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_320F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__320F[4] = {0x0028, 0x1102, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__320F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__320F, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_320F = {.cp = 0x320F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__320F, .cde = &lxb_unicode_decomposition_c_320F, .kde = &lxb_unicode_decomposition_k_320F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3210[4] = {0x0028, 0x1103, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3210 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3210, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3210[4] = {0x0028, 0x1103, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3210 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3210, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3210[4] = {0x0028, 0x1103, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3210 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3210, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3210 = {.cp = 0x3210, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3210, .cde = &lxb_unicode_decomposition_c_3210, .kde = &lxb_unicode_decomposition_k_3210};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3211[4] = {0x0028, 0x1105, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3211 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3211, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3211[4] = {0x0028, 0x1105, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3211 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3211, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3211[4] = {0x0028, 0x1105, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3211 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3211, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3211 = {.cp = 0x3211, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3211, .cde = &lxb_unicode_decomposition_c_3211, .kde = &lxb_unicode_decomposition_k_3211};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3212[4] = {0x0028, 0x1106, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3212 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3212, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3212[4] = {0x0028, 0x1106, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3212 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3212, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3212[4] = {0x0028, 0x1106, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3212 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3212, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3212 = {.cp = 0x3212, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3212, .cde = &lxb_unicode_decomposition_c_3212, .kde = &lxb_unicode_decomposition_k_3212};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3213[4] = {0x0028, 0x1107, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3213 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3213, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3213[4] = {0x0028, 0x1107, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3213 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3213, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3213[4] = {0x0028, 0x1107, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3213 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3213, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3213 = {.cp = 0x3213, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3213, .cde = &lxb_unicode_decomposition_c_3213, .kde = &lxb_unicode_decomposition_k_3213};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3214[4] = {0x0028, 0x1109, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3214 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3214, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3214[4] = {0x0028, 0x1109, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3214 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3214, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3214[4] = {0x0028, 0x1109, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3214 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3214, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3214 = {.cp = 0x3214, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3214, .cde = &lxb_unicode_decomposition_c_3214, .kde = &lxb_unicode_decomposition_k_3214};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3215[4] = {0x0028, 0x110B, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3215 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3215, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3215[4] = {0x0028, 0x110B, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3215 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3215, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3215[4] = {0x0028, 0x110B, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3215 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3215, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3215 = {.cp = 0x3215, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3215, .cde = &lxb_unicode_decomposition_c_3215, .kde = &lxb_unicode_decomposition_k_3215};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3216[4] = {0x0028, 0x110C, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3216 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3216, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3216[4] = {0x0028, 0x110C, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3216 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3216, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3216[4] = {0x0028, 0x110C, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3216 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3216, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3216 = {.cp = 0x3216, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3216, .cde = &lxb_unicode_decomposition_c_3216, .kde = &lxb_unicode_decomposition_k_3216};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3217[4] = {0x0028, 0x110E, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3217 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3217, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3217[4] = {0x0028, 0x110E, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3217 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3217, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3217[4] = {0x0028, 0x110E, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3217 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3217, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3217 = {.cp = 0x3217, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3217, .cde = &lxb_unicode_decomposition_c_3217, .kde = &lxb_unicode_decomposition_k_3217};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3218[4] = {0x0028, 0x110F, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3218 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3218, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3218[4] = {0x0028, 0x110F, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3218 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3218, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3218[4] = {0x0028, 0x110F, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3218 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3218, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3218 = {.cp = 0x3218, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3218, .cde = &lxb_unicode_decomposition_c_3218, .kde = &lxb_unicode_decomposition_k_3218};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3219[4] = {0x0028, 0x1110, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3219 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3219, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3219[4] = {0x0028, 0x1110, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3219 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3219, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3219[4] = {0x0028, 0x1110, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3219 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3219, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3219 = {.cp = 0x3219, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3219, .cde = &lxb_unicode_decomposition_c_3219, .kde = &lxb_unicode_decomposition_k_3219};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_321A[4] = {0x0028, 0x1111, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_321A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_321A, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_321A[4] = {0x0028, 0x1111, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_321A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_321A, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__321A[4] = {0x0028, 0x1111, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__321A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__321A, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_321A = {.cp = 0x321A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__321A, .cde = &lxb_unicode_decomposition_c_321A, .kde = &lxb_unicode_decomposition_k_321A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_321B[4] = {0x0028, 0x1112, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_321B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_321B, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_321B[4] = {0x0028, 0x1112, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_321B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_321B, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__321B[4] = {0x0028, 0x1112, 0x1161, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__321B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__321B, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_321B = {.cp = 0x321B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__321B, .cde = &lxb_unicode_decomposition_c_321B, .kde = &lxb_unicode_decomposition_k_321B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_321C[4] = {0x0028, 0x110C, 0x116E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_321C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_321C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_321C[4] = {0x0028, 0x110C, 0x116E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_321C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_321C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__321C[4] = {0x0028, 0x110C, 0x116E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__321C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__321C, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_321C = {.cp = 0x321C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__321C, .cde = &lxb_unicode_decomposition_c_321C, .kde = &lxb_unicode_decomposition_k_321C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_321D[7] = {0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_321D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_321D, .length = 7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_321D[7] = {0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_321D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_321D, .length = 7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__321D[7] = {0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__321D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__321D, .length = 7};
static const lxb_unicode_entry_t lxb_unicode_entry_321D = {.cp = 0x321D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__321D, .cde = &lxb_unicode_decomposition_c_321D, .kde = &lxb_unicode_decomposition_k_321D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_321E[6] = {0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_321E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_321E, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_321E[6] = {0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_321E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_321E, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__321E[6] = {0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__321E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__321E, .length = 6};
static const lxb_unicode_entry_t lxb_unicode_entry_321E = {.cp = 0x321E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__321E, .cde = &lxb_unicode_decomposition_c_321E, .kde = &lxb_unicode_decomposition_k_321E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3220[3] = {0x0028, 0x4E00, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3220 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3220, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3220[3] = {0x0028, 0x4E00, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3220 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3220, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3220[3] = {0x0028, 0x4E00, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3220 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3220, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3220 = {.cp = 0x3220, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3220, .cde = &lxb_unicode_decomposition_c_3220, .kde = &lxb_unicode_decomposition_k_3220};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3221[3] = {0x0028, 0x4E8C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3221 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3221, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3221[3] = {0x0028, 0x4E8C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3221 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3221, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3221[3] = {0x0028, 0x4E8C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3221 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3221, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3221 = {.cp = 0x3221, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3221, .cde = &lxb_unicode_decomposition_c_3221, .kde = &lxb_unicode_decomposition_k_3221};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3222[3] = {0x0028, 0x4E09, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3222 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3222, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3222[3] = {0x0028, 0x4E09, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3222 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3222, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3222[3] = {0x0028, 0x4E09, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3222 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3222, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3222 = {.cp = 0x3222, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3222, .cde = &lxb_unicode_decomposition_c_3222, .kde = &lxb_unicode_decomposition_k_3222};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3223[3] = {0x0028, 0x56DB, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3223 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3223, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3223[3] = {0x0028, 0x56DB, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3223 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3223, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3223[3] = {0x0028, 0x56DB, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3223 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3223, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3223 = {.cp = 0x3223, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3223, .cde = &lxb_unicode_decomposition_c_3223, .kde = &lxb_unicode_decomposition_k_3223};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3224[3] = {0x0028, 0x4E94, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3224 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3224, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3224[3] = {0x0028, 0x4E94, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3224 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3224, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3224[3] = {0x0028, 0x4E94, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3224 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3224, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3224 = {.cp = 0x3224, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3224, .cde = &lxb_unicode_decomposition_c_3224, .kde = &lxb_unicode_decomposition_k_3224};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3225[3] = {0x0028, 0x516D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3225 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3225, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3225[3] = {0x0028, 0x516D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3225 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3225, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3225[3] = {0x0028, 0x516D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3225 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3225, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3225 = {.cp = 0x3225, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3225, .cde = &lxb_unicode_decomposition_c_3225, .kde = &lxb_unicode_decomposition_k_3225};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3226[3] = {0x0028, 0x4E03, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3226, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3226[3] = {0x0028, 0x4E03, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3226, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3226[3] = {0x0028, 0x4E03, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3226 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3226, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3226 = {.cp = 0x3226, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3226, .cde = &lxb_unicode_decomposition_c_3226, .kde = &lxb_unicode_decomposition_k_3226};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3227[3] = {0x0028, 0x516B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3227 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3227, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3227[3] = {0x0028, 0x516B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3227 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3227, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3227[3] = {0x0028, 0x516B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3227 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3227, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3227 = {.cp = 0x3227, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3227, .cde = &lxb_unicode_decomposition_c_3227, .kde = &lxb_unicode_decomposition_k_3227};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3228[3] = {0x0028, 0x4E5D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3228 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3228, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3228[3] = {0x0028, 0x4E5D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3228 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3228, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3228[3] = {0x0028, 0x4E5D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3228 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3228, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3228 = {.cp = 0x3228, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3228, .cde = &lxb_unicode_decomposition_c_3228, .kde = &lxb_unicode_decomposition_k_3228};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3229[3] = {0x0028, 0x5341, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3229 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3229, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3229[3] = {0x0028, 0x5341, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3229 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3229, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3229[3] = {0x0028, 0x5341, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3229 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3229, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3229 = {.cp = 0x3229, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3229, .cde = &lxb_unicode_decomposition_c_3229, .kde = &lxb_unicode_decomposition_k_3229};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_322A[3] = {0x0028, 0x6708, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_322A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_322A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_322A[3] = {0x0028, 0x6708, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_322A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_322A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__322A[3] = {0x0028, 0x6708, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__322A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__322A, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_322A = {.cp = 0x322A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__322A, .cde = &lxb_unicode_decomposition_c_322A, .kde = &lxb_unicode_decomposition_k_322A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_322B[3] = {0x0028, 0x706B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_322B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_322B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_322B[3] = {0x0028, 0x706B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_322B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_322B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__322B[3] = {0x0028, 0x706B, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__322B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__322B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_322B = {.cp = 0x322B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__322B, .cde = &lxb_unicode_decomposition_c_322B, .kde = &lxb_unicode_decomposition_k_322B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_322C[3] = {0x0028, 0x6C34, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_322C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_322C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_322C[3] = {0x0028, 0x6C34, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_322C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_322C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__322C[3] = {0x0028, 0x6C34, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__322C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__322C, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_322C = {.cp = 0x322C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__322C, .cde = &lxb_unicode_decomposition_c_322C, .kde = &lxb_unicode_decomposition_k_322C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_322D[3] = {0x0028, 0x6728, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_322D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_322D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_322D[3] = {0x0028, 0x6728, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_322D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_322D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__322D[3] = {0x0028, 0x6728, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__322D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__322D, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_322D = {.cp = 0x322D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__322D, .cde = &lxb_unicode_decomposition_c_322D, .kde = &lxb_unicode_decomposition_k_322D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_322E[3] = {0x0028, 0x91D1, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_322E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_322E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_322E[3] = {0x0028, 0x91D1, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_322E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_322E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__322E[3] = {0x0028, 0x91D1, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__322E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__322E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_322E = {.cp = 0x322E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__322E, .cde = &lxb_unicode_decomposition_c_322E, .kde = &lxb_unicode_decomposition_k_322E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_322F[3] = {0x0028, 0x571F, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_322F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_322F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_322F[3] = {0x0028, 0x571F, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_322F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_322F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__322F[3] = {0x0028, 0x571F, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__322F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__322F, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_322F = {.cp = 0x322F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__322F, .cde = &lxb_unicode_decomposition_c_322F, .kde = &lxb_unicode_decomposition_k_322F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3230[3] = {0x0028, 0x65E5, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3230, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3230[3] = {0x0028, 0x65E5, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3230, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3230[3] = {0x0028, 0x65E5, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3230 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3230, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3230 = {.cp = 0x3230, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3230, .cde = &lxb_unicode_decomposition_c_3230, .kde = &lxb_unicode_decomposition_k_3230};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3231[3] = {0x0028, 0x682A, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3231 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3231, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3231[3] = {0x0028, 0x682A, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3231 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3231, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3231[3] = {0x0028, 0x682A, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3231 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3231, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3231 = {.cp = 0x3231, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3231, .cde = &lxb_unicode_decomposition_c_3231, .kde = &lxb_unicode_decomposition_k_3231};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3232[3] = {0x0028, 0x6709, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3232 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3232, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3232[3] = {0x0028, 0x6709, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3232 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3232, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3232[3] = {0x0028, 0x6709, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3232 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3232, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3232 = {.cp = 0x3232, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3232, .cde = &lxb_unicode_decomposition_c_3232, .kde = &lxb_unicode_decomposition_k_3232};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3233[3] = {0x0028, 0x793E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3233 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3233, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3233[3] = {0x0028, 0x793E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3233 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3233, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3233[3] = {0x0028, 0x793E, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3233 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3233, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3233 = {.cp = 0x3233, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3233, .cde = &lxb_unicode_decomposition_c_3233, .kde = &lxb_unicode_decomposition_k_3233};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3234[3] = {0x0028, 0x540D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3234 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3234, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3234[3] = {0x0028, 0x540D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3234 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3234, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3234[3] = {0x0028, 0x540D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3234 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3234, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3234 = {.cp = 0x3234, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3234, .cde = &lxb_unicode_decomposition_c_3234, .kde = &lxb_unicode_decomposition_k_3234};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3235[3] = {0x0028, 0x7279, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3235 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3235, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3235[3] = {0x0028, 0x7279, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3235 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3235, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3235[3] = {0x0028, 0x7279, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3235 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3235, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3235 = {.cp = 0x3235, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3235, .cde = &lxb_unicode_decomposition_c_3235, .kde = &lxb_unicode_decomposition_k_3235};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3236[3] = {0x0028, 0x8CA1, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3236 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3236, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3236[3] = {0x0028, 0x8CA1, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3236 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3236, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3236[3] = {0x0028, 0x8CA1, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3236 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3236, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3236 = {.cp = 0x3236, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3236, .cde = &lxb_unicode_decomposition_c_3236, .kde = &lxb_unicode_decomposition_k_3236};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3237[3] = {0x0028, 0x795D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3237 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3237, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3237[3] = {0x0028, 0x795D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3237 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3237, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3237[3] = {0x0028, 0x795D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3237 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3237, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3237 = {.cp = 0x3237, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3237, .cde = &lxb_unicode_decomposition_c_3237, .kde = &lxb_unicode_decomposition_k_3237};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3238[3] = {0x0028, 0x52B4, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3238 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3238, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3238[3] = {0x0028, 0x52B4, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3238 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3238, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3238[3] = {0x0028, 0x52B4, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3238 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3238, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3238 = {.cp = 0x3238, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3238, .cde = &lxb_unicode_decomposition_c_3238, .kde = &lxb_unicode_decomposition_k_3238};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3239[3] = {0x0028, 0x4EE3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3239 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3239, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3239[3] = {0x0028, 0x4EE3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3239 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3239, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3239[3] = {0x0028, 0x4EE3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3239 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3239, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3239 = {.cp = 0x3239, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3239, .cde = &lxb_unicode_decomposition_c_3239, .kde = &lxb_unicode_decomposition_k_3239};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_323A[3] = {0x0028, 0x547C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_323A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_323A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_323A[3] = {0x0028, 0x547C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_323A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_323A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__323A[3] = {0x0028, 0x547C, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__323A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__323A, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_323A = {.cp = 0x323A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__323A, .cde = &lxb_unicode_decomposition_c_323A, .kde = &lxb_unicode_decomposition_k_323A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_323B[3] = {0x0028, 0x5B66, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_323B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_323B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_323B[3] = {0x0028, 0x5B66, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_323B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_323B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__323B[3] = {0x0028, 0x5B66, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__323B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__323B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_323B = {.cp = 0x323B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__323B, .cde = &lxb_unicode_decomposition_c_323B, .kde = &lxb_unicode_decomposition_k_323B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_323C[3] = {0x0028, 0x76E3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_323C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_323C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_323C[3] = {0x0028, 0x76E3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_323C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_323C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__323C[3] = {0x0028, 0x76E3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__323C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__323C, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_323C = {.cp = 0x323C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__323C, .cde = &lxb_unicode_decomposition_c_323C, .kde = &lxb_unicode_decomposition_k_323C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_323D[3] = {0x0028, 0x4F01, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_323D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_323D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_323D[3] = {0x0028, 0x4F01, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_323D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_323D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__323D[3] = {0x0028, 0x4F01, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__323D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__323D, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_323D = {.cp = 0x323D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__323D, .cde = &lxb_unicode_decomposition_c_323D, .kde = &lxb_unicode_decomposition_k_323D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_323E[3] = {0x0028, 0x8CC7, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_323E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_323E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_323E[3] = {0x0028, 0x8CC7, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_323E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_323E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__323E[3] = {0x0028, 0x8CC7, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__323E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__323E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_323E = {.cp = 0x323E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__323E, .cde = &lxb_unicode_decomposition_c_323E, .kde = &lxb_unicode_decomposition_k_323E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_323F[3] = {0x0028, 0x5354, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_323F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_323F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_323F[3] = {0x0028, 0x5354, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_323F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_323F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__323F[3] = {0x0028, 0x5354, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__323F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__323F, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_323F = {.cp = 0x323F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__323F, .cde = &lxb_unicode_decomposition_c_323F, .kde = &lxb_unicode_decomposition_k_323F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3240[3] = {0x0028, 0x796D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3240 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3240, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3240[3] = {0x0028, 0x796D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3240 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3240, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3240[3] = {0x0028, 0x796D, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3240 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3240, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3240 = {.cp = 0x3240, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3240, .cde = &lxb_unicode_decomposition_c_3240, .kde = &lxb_unicode_decomposition_k_3240};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3241[3] = {0x0028, 0x4F11, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3241 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3241, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3241[3] = {0x0028, 0x4F11, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3241 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3241, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3241[3] = {0x0028, 0x4F11, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3241 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3241, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3241 = {.cp = 0x3241, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3241, .cde = &lxb_unicode_decomposition_c_3241, .kde = &lxb_unicode_decomposition_k_3241};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3242[3] = {0x0028, 0x81EA, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3242 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3242, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3242[3] = {0x0028, 0x81EA, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3242 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3242, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3242[3] = {0x0028, 0x81EA, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3242 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3242, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3242 = {.cp = 0x3242, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3242, .cde = &lxb_unicode_decomposition_c_3242, .kde = &lxb_unicode_decomposition_k_3242};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3243[3] = {0x0028, 0x81F3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3243 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3243, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3243[3] = {0x0028, 0x81F3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3243 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3243, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3243[3] = {0x0028, 0x81F3, 0x0029};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3243 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3243, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3243 = {.cp = 0x3243, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3243, .cde = &lxb_unicode_decomposition_c_3243, .kde = &lxb_unicode_decomposition_k_3243};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3244[1] = {0x554F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3244 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3244, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3244[1] = {0x554F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3244 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3244, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3244[1] = {0x554F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3244 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3244, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3244 = {.cp = 0x3244, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3244, .cde = &lxb_unicode_decomposition_c_3244, .kde = &lxb_unicode_decomposition_k_3244};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3245[1] = {0x5E7C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3245 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3245, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3245[1] = {0x5E7C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3245 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3245, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3245[1] = {0x5E7C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3245 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3245, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3245 = {.cp = 0x3245, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3245, .cde = &lxb_unicode_decomposition_c_3245, .kde = &lxb_unicode_decomposition_k_3245};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3246[1] = {0x6587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3246 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3246, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3246[1] = {0x6587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3246 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3246, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3246[1] = {0x6587};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3246 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3246, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3246 = {.cp = 0x3246, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3246, .cde = &lxb_unicode_decomposition_c_3246, .kde = &lxb_unicode_decomposition_k_3246};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3247[1] = {0x7B8F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3247 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3247, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3247[1] = {0x7B8F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3247 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3247, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3247[1] = {0x7B8F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3247 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3247, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3247 = {.cp = 0x3247, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3247, .cde = &lxb_unicode_decomposition_c_3247, .kde = &lxb_unicode_decomposition_k_3247};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3250[3] = {0x0050, 0x0054, 0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3250 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3250, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3250[3] = {0x0050, 0x0054, 0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3250 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3250, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3250[3] = {0x0050, 0x0054, 0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3250 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3250, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3250 = {.cp = 0x3250, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3250, .cde = &lxb_unicode_decomposition_c_3250, .kde = &lxb_unicode_decomposition_k_3250};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3251[2] = {0x0032, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3251 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3251, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3251[2] = {0x0032, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3251 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3251, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3251[2] = {0x0032, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3251 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3251, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3251 = {.cp = 0x3251, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3251, .cde = &lxb_unicode_decomposition_c_3251, .kde = &lxb_unicode_decomposition_k_3251};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3252[2] = {0x0032, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3252 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3252, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3252[2] = {0x0032, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3252 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3252, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3252[2] = {0x0032, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3252 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3252, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3252 = {.cp = 0x3252, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3252, .cde = &lxb_unicode_decomposition_c_3252, .kde = &lxb_unicode_decomposition_k_3252};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3253[2] = {0x0032, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3253 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3253, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3253[2] = {0x0032, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3253 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3253, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3253[2] = {0x0032, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3253 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3253, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3253 = {.cp = 0x3253, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3253, .cde = &lxb_unicode_decomposition_c_3253, .kde = &lxb_unicode_decomposition_k_3253};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3254[2] = {0x0032, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3254 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3254, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3254[2] = {0x0032, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3254 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3254, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3254[2] = {0x0032, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3254 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3254, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3254 = {.cp = 0x3254, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3254, .cde = &lxb_unicode_decomposition_c_3254, .kde = &lxb_unicode_decomposition_k_3254};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3255[2] = {0x0032, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3255 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3255, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3255[2] = {0x0032, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3255 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3255, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3255[2] = {0x0032, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3255 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3255, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3255 = {.cp = 0x3255, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3255, .cde = &lxb_unicode_decomposition_c_3255, .kde = &lxb_unicode_decomposition_k_3255};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3256[2] = {0x0032, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3256 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3256, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3256[2] = {0x0032, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3256 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3256, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3256[2] = {0x0032, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3256 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3256, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3256 = {.cp = 0x3256, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3256, .cde = &lxb_unicode_decomposition_c_3256, .kde = &lxb_unicode_decomposition_k_3256};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3257[2] = {0x0032, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3257 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3257, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3257[2] = {0x0032, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3257 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3257, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3257[2] = {0x0032, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3257 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3257, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3257 = {.cp = 0x3257, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3257, .cde = &lxb_unicode_decomposition_c_3257, .kde = &lxb_unicode_decomposition_k_3257};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3258[2] = {0x0032, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3258 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3258, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3258[2] = {0x0032, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3258 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3258, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3258[2] = {0x0032, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3258 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3258, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3258 = {.cp = 0x3258, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3258, .cde = &lxb_unicode_decomposition_c_3258, .kde = &lxb_unicode_decomposition_k_3258};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3259[2] = {0x0032, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3259 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3259, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3259[2] = {0x0032, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3259 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3259, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3259[2] = {0x0032, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3259 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3259, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3259 = {.cp = 0x3259, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3259, .cde = &lxb_unicode_decomposition_c_3259, .kde = &lxb_unicode_decomposition_k_3259};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_325A[2] = {0x0033, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_325A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_325A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_325A[2] = {0x0033, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_325A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_325A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__325A[2] = {0x0033, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__325A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__325A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_325A = {.cp = 0x325A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__325A, .cde = &lxb_unicode_decomposition_c_325A, .kde = &lxb_unicode_decomposition_k_325A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_325B[2] = {0x0033, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_325B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_325B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_325B[2] = {0x0033, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_325B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_325B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__325B[2] = {0x0033, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__325B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__325B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_325B = {.cp = 0x325B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__325B, .cde = &lxb_unicode_decomposition_c_325B, .kde = &lxb_unicode_decomposition_k_325B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_325C[2] = {0x0033, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_325C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_325C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_325C[2] = {0x0033, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_325C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_325C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__325C[2] = {0x0033, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__325C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__325C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_325C = {.cp = 0x325C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__325C, .cde = &lxb_unicode_decomposition_c_325C, .kde = &lxb_unicode_decomposition_k_325C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_325D[2] = {0x0033, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_325D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_325D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_325D[2] = {0x0033, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_325D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_325D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__325D[2] = {0x0033, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__325D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__325D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_325D = {.cp = 0x325D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__325D, .cde = &lxb_unicode_decomposition_c_325D, .kde = &lxb_unicode_decomposition_k_325D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_325E[2] = {0x0033, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_325E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_325E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_325E[2] = {0x0033, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_325E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_325E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__325E[2] = {0x0033, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__325E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__325E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_325E = {.cp = 0x325E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__325E, .cde = &lxb_unicode_decomposition_c_325E, .kde = &lxb_unicode_decomposition_k_325E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_325F[2] = {0x0033, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_325F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_325F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_325F[2] = {0x0033, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_325F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_325F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__325F[2] = {0x0033, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__325F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__325F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_325F = {.cp = 0x325F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__325F, .cde = &lxb_unicode_decomposition_c_325F, .kde = &lxb_unicode_decomposition_k_325F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3260[1] = {0x1100};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3260 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3260, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3260[1] = {0x1100};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3260 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3260, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3260[1] = {0x1100};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3260 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3260, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3260 = {.cp = 0x3260, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3260, .cde = &lxb_unicode_decomposition_c_3260, .kde = &lxb_unicode_decomposition_k_3260};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3261[1] = {0x1102};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3261 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3261, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3261[1] = {0x1102};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3261 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3261, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3261[1] = {0x1102};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3261 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3261, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3261 = {.cp = 0x3261, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3261, .cde = &lxb_unicode_decomposition_c_3261, .kde = &lxb_unicode_decomposition_k_3261};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3262[1] = {0x1103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3262 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3262, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3262[1] = {0x1103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3262 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3262, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3262[1] = {0x1103};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3262 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3262, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3262 = {.cp = 0x3262, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3262, .cde = &lxb_unicode_decomposition_c_3262, .kde = &lxb_unicode_decomposition_k_3262};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3263[1] = {0x1105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3263 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3263, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3263[1] = {0x1105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3263 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3263, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3263[1] = {0x1105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3263 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3263, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3263 = {.cp = 0x3263, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3263, .cde = &lxb_unicode_decomposition_c_3263, .kde = &lxb_unicode_decomposition_k_3263};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3264[1] = {0x1106};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3264 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3264, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3264[1] = {0x1106};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3264 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3264, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3264[1] = {0x1106};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3264 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3264, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3264 = {.cp = 0x3264, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3264, .cde = &lxb_unicode_decomposition_c_3264, .kde = &lxb_unicode_decomposition_k_3264};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3265[1] = {0x1107};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3265 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3265, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3265[1] = {0x1107};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3265 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3265, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3265[1] = {0x1107};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3265 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3265, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3265 = {.cp = 0x3265, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3265, .cde = &lxb_unicode_decomposition_c_3265, .kde = &lxb_unicode_decomposition_k_3265};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3266[1] = {0x1109};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3266 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3266, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3266[1] = {0x1109};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3266 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3266, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3266[1] = {0x1109};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3266 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3266, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3266 = {.cp = 0x3266, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3266, .cde = &lxb_unicode_decomposition_c_3266, .kde = &lxb_unicode_decomposition_k_3266};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3267[1] = {0x110B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3267 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3267, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3267[1] = {0x110B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3267 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3267, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3267[1] = {0x110B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3267 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3267, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3267 = {.cp = 0x3267, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3267, .cde = &lxb_unicode_decomposition_c_3267, .kde = &lxb_unicode_decomposition_k_3267};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3268[1] = {0x110C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3268 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3268, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3268[1] = {0x110C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3268 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3268, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3268[1] = {0x110C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3268 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3268, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3268 = {.cp = 0x3268, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3268, .cde = &lxb_unicode_decomposition_c_3268, .kde = &lxb_unicode_decomposition_k_3268};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3269[1] = {0x110E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3269 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3269, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3269[1] = {0x110E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3269 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3269, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3269[1] = {0x110E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3269 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3269, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3269 = {.cp = 0x3269, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3269, .cde = &lxb_unicode_decomposition_c_3269, .kde = &lxb_unicode_decomposition_k_3269};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_326A[1] = {0x110F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_326A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_326A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_326A[1] = {0x110F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_326A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_326A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__326A[1] = {0x110F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__326A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__326A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_326A = {.cp = 0x326A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__326A, .cde = &lxb_unicode_decomposition_c_326A, .kde = &lxb_unicode_decomposition_k_326A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_326B[1] = {0x1110};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_326B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_326B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_326B[1] = {0x1110};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_326B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_326B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__326B[1] = {0x1110};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__326B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__326B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_326B = {.cp = 0x326B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__326B, .cde = &lxb_unicode_decomposition_c_326B, .kde = &lxb_unicode_decomposition_k_326B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_326C[1] = {0x1111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_326C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_326C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_326C[1] = {0x1111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_326C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_326C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__326C[1] = {0x1111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__326C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__326C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_326C = {.cp = 0x326C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__326C, .cde = &lxb_unicode_decomposition_c_326C, .kde = &lxb_unicode_decomposition_k_326C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_326D[1] = {0x1112};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_326D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_326D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_326D[1] = {0x1112};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_326D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_326D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__326D[1] = {0x1112};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__326D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__326D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_326D = {.cp = 0x326D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__326D, .cde = &lxb_unicode_decomposition_c_326D, .kde = &lxb_unicode_decomposition_k_326D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_326E[2] = {0x1100, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_326E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_326E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_326E[2] = {0x1100, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_326E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_326E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__326E[2] = {0x1100, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__326E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__326E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_326E = {.cp = 0x326E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__326E, .cde = &lxb_unicode_decomposition_c_326E, .kde = &lxb_unicode_decomposition_k_326E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_326F[2] = {0x1102, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_326F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_326F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_326F[2] = {0x1102, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_326F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_326F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__326F[2] = {0x1102, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__326F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__326F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_326F = {.cp = 0x326F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__326F, .cde = &lxb_unicode_decomposition_c_326F, .kde = &lxb_unicode_decomposition_k_326F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3270[2] = {0x1103, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3270 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3270, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3270[2] = {0x1103, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3270 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3270, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3270[2] = {0x1103, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3270 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3270, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3270 = {.cp = 0x3270, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3270, .cde = &lxb_unicode_decomposition_c_3270, .kde = &lxb_unicode_decomposition_k_3270};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3271[2] = {0x1105, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3271 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3271, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3271[2] = {0x1105, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3271 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3271, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3271[2] = {0x1105, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3271 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3271, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3271 = {.cp = 0x3271, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3271, .cde = &lxb_unicode_decomposition_c_3271, .kde = &lxb_unicode_decomposition_k_3271};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3272[2] = {0x1106, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3272 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3272, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3272[2] = {0x1106, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3272 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3272, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3272[2] = {0x1106, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3272 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3272, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3272 = {.cp = 0x3272, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3272, .cde = &lxb_unicode_decomposition_c_3272, .kde = &lxb_unicode_decomposition_k_3272};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3273[2] = {0x1107, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3273 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3273, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3273[2] = {0x1107, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3273 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3273, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3273[2] = {0x1107, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3273 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3273, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3273 = {.cp = 0x3273, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3273, .cde = &lxb_unicode_decomposition_c_3273, .kde = &lxb_unicode_decomposition_k_3273};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3274[2] = {0x1109, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3274 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3274, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3274[2] = {0x1109, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3274 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3274, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3274[2] = {0x1109, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3274 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3274, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3274 = {.cp = 0x3274, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3274, .cde = &lxb_unicode_decomposition_c_3274, .kde = &lxb_unicode_decomposition_k_3274};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3275[2] = {0x110B, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3275 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3275, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3275[2] = {0x110B, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3275 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3275, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3275[2] = {0x110B, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3275 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3275, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3275 = {.cp = 0x3275, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3275, .cde = &lxb_unicode_decomposition_c_3275, .kde = &lxb_unicode_decomposition_k_3275};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3276[2] = {0x110C, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3276 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3276, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3276[2] = {0x110C, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3276 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3276, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3276[2] = {0x110C, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3276 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3276, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3276 = {.cp = 0x3276, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3276, .cde = &lxb_unicode_decomposition_c_3276, .kde = &lxb_unicode_decomposition_k_3276};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3277[2] = {0x110E, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3277 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3277, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3277[2] = {0x110E, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3277 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3277, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3277[2] = {0x110E, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3277 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3277, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3277 = {.cp = 0x3277, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3277, .cde = &lxb_unicode_decomposition_c_3277, .kde = &lxb_unicode_decomposition_k_3277};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3278[2] = {0x110F, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3278 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3278, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3278[2] = {0x110F, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3278 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3278, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3278[2] = {0x110F, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3278 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3278, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3278 = {.cp = 0x3278, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3278, .cde = &lxb_unicode_decomposition_c_3278, .kde = &lxb_unicode_decomposition_k_3278};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3279[2] = {0x1110, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3279 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3279, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3279[2] = {0x1110, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3279 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3279, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3279[2] = {0x1110, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3279 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3279, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3279 = {.cp = 0x3279, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3279, .cde = &lxb_unicode_decomposition_c_3279, .kde = &lxb_unicode_decomposition_k_3279};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_327A[2] = {0x1111, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_327A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_327A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_327A[2] = {0x1111, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_327A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_327A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__327A[2] = {0x1111, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__327A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__327A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_327A = {.cp = 0x327A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__327A, .cde = &lxb_unicode_decomposition_c_327A, .kde = &lxb_unicode_decomposition_k_327A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_327B[2] = {0x1112, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_327B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_327B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_327B[2] = {0x1112, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_327B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_327B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__327B[2] = {0x1112, 0x1161};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__327B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__327B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_327B = {.cp = 0x327B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__327B, .cde = &lxb_unicode_decomposition_c_327B, .kde = &lxb_unicode_decomposition_k_327B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_327C[5] = {0x110E, 0x1161, 0x11B7, 0x1100, 0x1169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_327C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_327C, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_327C[5] = {0x110E, 0x1161, 0x11B7, 0x1100, 0x1169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_327C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_327C, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__327C[5] = {0x110E, 0x1161, 0x11B7, 0x1100, 0x1169};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__327C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__327C, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_327C = {.cp = 0x327C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__327C, .cde = &lxb_unicode_decomposition_c_327C, .kde = &lxb_unicode_decomposition_k_327C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_327D[4] = {0x110C, 0x116E, 0x110B, 0x1174};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_327D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_327D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_327D[4] = {0x110C, 0x116E, 0x110B, 0x1174};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_327D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_327D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__327D[4] = {0x110C, 0x116E, 0x110B, 0x1174};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__327D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__327D, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_327D = {.cp = 0x327D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__327D, .cde = &lxb_unicode_decomposition_c_327D, .kde = &lxb_unicode_decomposition_k_327D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_327E[2] = {0x110B, 0x116E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_327E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_327E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_327E[2] = {0x110B, 0x116E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_327E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_327E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__327E[2] = {0x110B, 0x116E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__327E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__327E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_327E = {.cp = 0x327E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__327E, .cde = &lxb_unicode_decomposition_c_327E, .kde = &lxb_unicode_decomposition_k_327E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3280[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3280 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3280, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3280[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3280 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3280, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3280[1] = {0x4E00};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3280 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3280, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3280 = {.cp = 0x3280, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3280, .cde = &lxb_unicode_decomposition_c_3280, .kde = &lxb_unicode_decomposition_k_3280};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3281[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3281 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3281, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3281[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3281 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3281, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3281[1] = {0x4E8C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3281 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3281, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3281 = {.cp = 0x3281, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3281, .cde = &lxb_unicode_decomposition_c_3281, .kde = &lxb_unicode_decomposition_k_3281};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3282[1] = {0x4E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3282 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3282, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3282[1] = {0x4E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3282 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3282, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3282[1] = {0x4E09};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3282 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3282, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3282 = {.cp = 0x3282, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3282, .cde = &lxb_unicode_decomposition_c_3282, .kde = &lxb_unicode_decomposition_k_3282};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3283[1] = {0x56DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3283 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3283, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3283[1] = {0x56DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3283 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3283, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3283[1] = {0x56DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3283 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3283, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3283 = {.cp = 0x3283, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3283, .cde = &lxb_unicode_decomposition_c_3283, .kde = &lxb_unicode_decomposition_k_3283};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3284[1] = {0x4E94};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3284 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3284, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3284[1] = {0x4E94};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3284 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3284, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3284[1] = {0x4E94};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3284 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3284, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3284 = {.cp = 0x3284, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3284, .cde = &lxb_unicode_decomposition_c_3284, .kde = &lxb_unicode_decomposition_k_3284};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3285[1] = {0x516D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3285 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3285, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3285[1] = {0x516D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3285 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3285, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3285[1] = {0x516D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3285 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3285, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3285 = {.cp = 0x3285, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3285, .cde = &lxb_unicode_decomposition_c_3285, .kde = &lxb_unicode_decomposition_k_3285};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3286[1] = {0x4E03};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3286 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3286, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3286[1] = {0x4E03};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3286 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3286, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3286[1] = {0x4E03};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3286 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3286, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3286 = {.cp = 0x3286, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3286, .cde = &lxb_unicode_decomposition_c_3286, .kde = &lxb_unicode_decomposition_k_3286};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3287[1] = {0x516B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3287 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3287, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3287[1] = {0x516B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3287 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3287, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3287[1] = {0x516B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3287 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3287, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3287 = {.cp = 0x3287, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3287, .cde = &lxb_unicode_decomposition_c_3287, .kde = &lxb_unicode_decomposition_k_3287};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3288[1] = {0x4E5D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3288 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3288, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3288[1] = {0x4E5D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3288 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3288, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3288[1] = {0x4E5D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3288 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3288, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3288 = {.cp = 0x3288, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3288, .cde = &lxb_unicode_decomposition_c_3288, .kde = &lxb_unicode_decomposition_k_3288};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3289[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3289 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3289, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3289[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3289 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3289, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3289[1] = {0x5341};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3289 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3289, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3289 = {.cp = 0x3289, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3289, .cde = &lxb_unicode_decomposition_c_3289, .kde = &lxb_unicode_decomposition_k_3289};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_328A[1] = {0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_328A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_328A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_328A[1] = {0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_328A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_328A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__328A[1] = {0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__328A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__328A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_328A = {.cp = 0x328A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__328A, .cde = &lxb_unicode_decomposition_c_328A, .kde = &lxb_unicode_decomposition_k_328A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_328B[1] = {0x706B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_328B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_328B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_328B[1] = {0x706B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_328B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_328B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__328B[1] = {0x706B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__328B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__328B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_328B = {.cp = 0x328B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__328B, .cde = &lxb_unicode_decomposition_c_328B, .kde = &lxb_unicode_decomposition_k_328B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_328C[1] = {0x6C34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_328C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_328C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_328C[1] = {0x6C34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_328C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_328C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__328C[1] = {0x6C34};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__328C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__328C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_328C = {.cp = 0x328C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__328C, .cde = &lxb_unicode_decomposition_c_328C, .kde = &lxb_unicode_decomposition_k_328C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_328D[1] = {0x6728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_328D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_328D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_328D[1] = {0x6728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_328D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_328D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__328D[1] = {0x6728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__328D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__328D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_328D = {.cp = 0x328D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__328D, .cde = &lxb_unicode_decomposition_c_328D, .kde = &lxb_unicode_decomposition_k_328D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_328E[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_328E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_328E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_328E[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_328E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_328E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__328E[1] = {0x91D1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__328E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__328E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_328E = {.cp = 0x328E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__328E, .cde = &lxb_unicode_decomposition_c_328E, .kde = &lxb_unicode_decomposition_k_328E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_328F[1] = {0x571F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_328F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_328F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_328F[1] = {0x571F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_328F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_328F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__328F[1] = {0x571F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__328F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__328F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_328F = {.cp = 0x328F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__328F, .cde = &lxb_unicode_decomposition_c_328F, .kde = &lxb_unicode_decomposition_k_328F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3290[1] = {0x65E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3290 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3290, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3290[1] = {0x65E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3290 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3290, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3290[1] = {0x65E5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3290 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3290, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3290 = {.cp = 0x3290, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3290, .cde = &lxb_unicode_decomposition_c_3290, .kde = &lxb_unicode_decomposition_k_3290};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3291[1] = {0x682A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3291 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3291, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3291[1] = {0x682A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3291 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3291, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3291[1] = {0x682A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3291 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3291, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3291 = {.cp = 0x3291, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3291, .cde = &lxb_unicode_decomposition_c_3291, .kde = &lxb_unicode_decomposition_k_3291};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3292[1] = {0x6709};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3292 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3292, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3292[1] = {0x6709};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3292 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3292, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3292[1] = {0x6709};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3292 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3292, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3292 = {.cp = 0x3292, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3292, .cde = &lxb_unicode_decomposition_c_3292, .kde = &lxb_unicode_decomposition_k_3292};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3293[1] = {0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3293 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3293, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3293[1] = {0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3293 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3293, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3293[1] = {0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3293 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3293, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3293 = {.cp = 0x3293, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3293, .cde = &lxb_unicode_decomposition_c_3293, .kde = &lxb_unicode_decomposition_k_3293};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3294[1] = {0x540D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3294 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3294, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3294[1] = {0x540D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3294 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3294, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3294[1] = {0x540D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3294 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3294, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3294 = {.cp = 0x3294, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3294, .cde = &lxb_unicode_decomposition_c_3294, .kde = &lxb_unicode_decomposition_k_3294};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3295[1] = {0x7279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3295 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3295, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3295[1] = {0x7279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3295 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3295, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3295[1] = {0x7279};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3295 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3295, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3295 = {.cp = 0x3295, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3295, .cde = &lxb_unicode_decomposition_c_3295, .kde = &lxb_unicode_decomposition_k_3295};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3296[1] = {0x8CA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3296 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3296, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3296[1] = {0x8CA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3296 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3296, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3296[1] = {0x8CA1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3296 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3296, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3296 = {.cp = 0x3296, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3296, .cde = &lxb_unicode_decomposition_c_3296, .kde = &lxb_unicode_decomposition_k_3296};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3297[1] = {0x795D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3297 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3297, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3297[1] = {0x795D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3297 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3297, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3297[1] = {0x795D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3297 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3297, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3297 = {.cp = 0x3297, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3297, .cde = &lxb_unicode_decomposition_c_3297, .kde = &lxb_unicode_decomposition_k_3297};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3298[1] = {0x52B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3298 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3298, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3298[1] = {0x52B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3298 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3298, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3298[1] = {0x52B4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3298 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3298, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3298 = {.cp = 0x3298, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3298, .cde = &lxb_unicode_decomposition_c_3298, .kde = &lxb_unicode_decomposition_k_3298};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3299[1] = {0x79D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3299 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_3299, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3299[1] = {0x79D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3299 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_3299, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3299[1] = {0x79D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3299 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__3299, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_3299 = {.cp = 0x3299, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3299, .cde = &lxb_unicode_decomposition_c_3299, .kde = &lxb_unicode_decomposition_k_3299};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_329A[1] = {0x7537};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_329A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_329A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_329A[1] = {0x7537};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_329A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_329A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__329A[1] = {0x7537};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__329A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__329A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_329A = {.cp = 0x329A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__329A, .cde = &lxb_unicode_decomposition_c_329A, .kde = &lxb_unicode_decomposition_k_329A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_329B[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_329B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_329B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_329B[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_329B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_329B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__329B[1] = {0x5973};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__329B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__329B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_329B = {.cp = 0x329B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__329B, .cde = &lxb_unicode_decomposition_c_329B, .kde = &lxb_unicode_decomposition_k_329B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_329C[1] = {0x9069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_329C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_329C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_329C[1] = {0x9069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_329C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_329C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__329C[1] = {0x9069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__329C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__329C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_329C = {.cp = 0x329C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__329C, .cde = &lxb_unicode_decomposition_c_329C, .kde = &lxb_unicode_decomposition_k_329C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_329D[1] = {0x512A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_329D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_329D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_329D[1] = {0x512A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_329D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_329D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__329D[1] = {0x512A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__329D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__329D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_329D = {.cp = 0x329D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__329D, .cde = &lxb_unicode_decomposition_c_329D, .kde = &lxb_unicode_decomposition_k_329D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_329E[1] = {0x5370};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_329E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_329E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_329E[1] = {0x5370};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_329E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_329E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__329E[1] = {0x5370};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__329E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__329E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_329E = {.cp = 0x329E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__329E, .cde = &lxb_unicode_decomposition_c_329E, .kde = &lxb_unicode_decomposition_k_329E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_329F[1] = {0x6CE8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_329F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_329F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_329F[1] = {0x6CE8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_329F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_329F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__329F[1] = {0x6CE8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__329F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__329F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_329F = {.cp = 0x329F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__329F, .cde = &lxb_unicode_decomposition_c_329F, .kde = &lxb_unicode_decomposition_k_329F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A0[1] = {0x9805};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A0[1] = {0x9805};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A0[1] = {0x9805};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A0 = {.cp = 0x32A0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A0, .cde = &lxb_unicode_decomposition_c_32A0, .kde = &lxb_unicode_decomposition_k_32A0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A1[1] = {0x4F11};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A1[1] = {0x4F11};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A1[1] = {0x4F11};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A1 = {.cp = 0x32A1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A1, .cde = &lxb_unicode_decomposition_c_32A1, .kde = &lxb_unicode_decomposition_k_32A1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A2[1] = {0x5199};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A2[1] = {0x5199};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A2[1] = {0x5199};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A2 = {.cp = 0x32A2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A2, .cde = &lxb_unicode_decomposition_c_32A2, .kde = &lxb_unicode_decomposition_k_32A2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A3[1] = {0x6B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A3[1] = {0x6B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A3[1] = {0x6B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A3 = {.cp = 0x32A3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A3, .cde = &lxb_unicode_decomposition_c_32A3, .kde = &lxb_unicode_decomposition_k_32A3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A4[1] = {0x4E0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A4[1] = {0x4E0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A4[1] = {0x4E0A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A4 = {.cp = 0x32A4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A4, .cde = &lxb_unicode_decomposition_c_32A4, .kde = &lxb_unicode_decomposition_k_32A4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A5[1] = {0x4E2D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A5[1] = {0x4E2D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A5[1] = {0x4E2D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A5 = {.cp = 0x32A5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A5, .cde = &lxb_unicode_decomposition_c_32A5, .kde = &lxb_unicode_decomposition_k_32A5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A6[1] = {0x4E0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A6[1] = {0x4E0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A6[1] = {0x4E0B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A6 = {.cp = 0x32A6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A6, .cde = &lxb_unicode_decomposition_c_32A6, .kde = &lxb_unicode_decomposition_k_32A6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A7[1] = {0x5DE6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A7[1] = {0x5DE6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A7[1] = {0x5DE6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A7 = {.cp = 0x32A7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A7, .cde = &lxb_unicode_decomposition_c_32A7, .kde = &lxb_unicode_decomposition_k_32A7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A8[1] = {0x53F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A8[1] = {0x53F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A8[1] = {0x53F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A8 = {.cp = 0x32A8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A8, .cde = &lxb_unicode_decomposition_c_32A8, .kde = &lxb_unicode_decomposition_k_32A8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32A9[1] = {0x533B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32A9[1] = {0x533B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32A9[1] = {0x533B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32A9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32A9 = {.cp = 0x32A9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32A9, .cde = &lxb_unicode_decomposition_c_32A9, .kde = &lxb_unicode_decomposition_k_32A9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32AA[1] = {0x5B97};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32AA[1] = {0x5B97};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32AA[1] = {0x5B97};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32AA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32AA = {.cp = 0x32AA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32AA, .cde = &lxb_unicode_decomposition_c_32AA, .kde = &lxb_unicode_decomposition_k_32AA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32AB[1] = {0x5B66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32AB[1] = {0x5B66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32AB[1] = {0x5B66};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32AB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32AB = {.cp = 0x32AB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32AB, .cde = &lxb_unicode_decomposition_c_32AB, .kde = &lxb_unicode_decomposition_k_32AB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32AC[1] = {0x76E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32AC[1] = {0x76E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32AC[1] = {0x76E3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32AC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32AC = {.cp = 0x32AC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32AC, .cde = &lxb_unicode_decomposition_c_32AC, .kde = &lxb_unicode_decomposition_k_32AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32AD[1] = {0x4F01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32AD[1] = {0x4F01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32AD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32AD[1] = {0x4F01};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32AD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32AD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32AD = {.cp = 0x32AD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32AD, .cde = &lxb_unicode_decomposition_c_32AD, .kde = &lxb_unicode_decomposition_k_32AD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32AE[1] = {0x8CC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32AE[1] = {0x8CC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32AE[1] = {0x8CC7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32AE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32AE = {.cp = 0x32AE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32AE, .cde = &lxb_unicode_decomposition_c_32AE, .kde = &lxb_unicode_decomposition_k_32AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32AF[1] = {0x5354};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32AF[1] = {0x5354};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32AF[1] = {0x5354};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32AF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32AF = {.cp = 0x32AF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32AF, .cde = &lxb_unicode_decomposition_c_32AF, .kde = &lxb_unicode_decomposition_k_32AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B0[1] = {0x591C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B0[1] = {0x591C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B0[1] = {0x591C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32B0 = {.cp = 0x32B0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B0, .cde = &lxb_unicode_decomposition_c_32B0, .kde = &lxb_unicode_decomposition_k_32B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B1[2] = {0x0033, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B1[2] = {0x0033, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B1[2] = {0x0033, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B1 = {.cp = 0x32B1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B1, .cde = &lxb_unicode_decomposition_c_32B1, .kde = &lxb_unicode_decomposition_k_32B1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B2[2] = {0x0033, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B2[2] = {0x0033, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B2[2] = {0x0033, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B2 = {.cp = 0x32B2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B2, .cde = &lxb_unicode_decomposition_c_32B2, .kde = &lxb_unicode_decomposition_k_32B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B3[2] = {0x0033, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B3[2] = {0x0033, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B3[2] = {0x0033, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B3 = {.cp = 0x32B3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B3, .cde = &lxb_unicode_decomposition_c_32B3, .kde = &lxb_unicode_decomposition_k_32B3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B4[2] = {0x0033, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B4[2] = {0x0033, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B4[2] = {0x0033, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B4 = {.cp = 0x32B4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B4, .cde = &lxb_unicode_decomposition_c_32B4, .kde = &lxb_unicode_decomposition_k_32B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B5[2] = {0x0034, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B5[2] = {0x0034, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B5[2] = {0x0034, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B5 = {.cp = 0x32B5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B5, .cde = &lxb_unicode_decomposition_c_32B5, .kde = &lxb_unicode_decomposition_k_32B5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B6[2] = {0x0034, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B6[2] = {0x0034, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B6[2] = {0x0034, 0x0031};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B6 = {.cp = 0x32B6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B6, .cde = &lxb_unicode_decomposition_c_32B6, .kde = &lxb_unicode_decomposition_k_32B6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B7[2] = {0x0034, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B7[2] = {0x0034, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B7[2] = {0x0034, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B7 = {.cp = 0x32B7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B7, .cde = &lxb_unicode_decomposition_c_32B7, .kde = &lxb_unicode_decomposition_k_32B7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B8[2] = {0x0034, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B8[2] = {0x0034, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B8[2] = {0x0034, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B8 = {.cp = 0x32B8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B8, .cde = &lxb_unicode_decomposition_c_32B8, .kde = &lxb_unicode_decomposition_k_32B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32B9[2] = {0x0034, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32B9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32B9[2] = {0x0034, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32B9, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32B9[2] = {0x0034, 0x0034};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32B9, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32B9 = {.cp = 0x32B9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32B9, .cde = &lxb_unicode_decomposition_c_32B9, .kde = &lxb_unicode_decomposition_k_32B9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32BA[2] = {0x0034, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32BA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32BA[2] = {0x0034, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32BA, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32BA[2] = {0x0034, 0x0035};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32BA, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32BA = {.cp = 0x32BA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32BA, .cde = &lxb_unicode_decomposition_c_32BA, .kde = &lxb_unicode_decomposition_k_32BA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32BB[2] = {0x0034, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32BB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32BB[2] = {0x0034, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32BB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32BB[2] = {0x0034, 0x0036};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32BB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32BB = {.cp = 0x32BB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32BB, .cde = &lxb_unicode_decomposition_c_32BB, .kde = &lxb_unicode_decomposition_k_32BB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32BC[2] = {0x0034, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32BC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32BC[2] = {0x0034, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32BC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32BC[2] = {0x0034, 0x0037};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32BC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32BC = {.cp = 0x32BC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32BC, .cde = &lxb_unicode_decomposition_c_32BC, .kde = &lxb_unicode_decomposition_k_32BC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32BD[2] = {0x0034, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32BD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32BD[2] = {0x0034, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32BD, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32BD[2] = {0x0034, 0x0038};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32BD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32BD = {.cp = 0x32BD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32BD, .cde = &lxb_unicode_decomposition_c_32BD, .kde = &lxb_unicode_decomposition_k_32BD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32BE[2] = {0x0034, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32BE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32BE[2] = {0x0034, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32BE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32BE[2] = {0x0034, 0x0039};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32BE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32BE = {.cp = 0x32BE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32BE, .cde = &lxb_unicode_decomposition_c_32BE, .kde = &lxb_unicode_decomposition_k_32BE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32BF[2] = {0x0035, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32BF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32BF[2] = {0x0035, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32BF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32BF[2] = {0x0035, 0x0030};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32BF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32BF = {.cp = 0x32BF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32BF, .cde = &lxb_unicode_decomposition_c_32BF, .kde = &lxb_unicode_decomposition_k_32BF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C0[2] = {0x0031, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C0[2] = {0x0031, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C0, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C0[2] = {0x0031, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C0 = {.cp = 0x32C0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C0, .cde = &lxb_unicode_decomposition_c_32C0, .kde = &lxb_unicode_decomposition_k_32C0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C1[2] = {0x0032, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C1[2] = {0x0032, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C1[2] = {0x0032, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C1 = {.cp = 0x32C1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C1, .cde = &lxb_unicode_decomposition_c_32C1, .kde = &lxb_unicode_decomposition_k_32C1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C2[2] = {0x0033, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C2[2] = {0x0033, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C2, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C2[2] = {0x0033, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C2, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C2 = {.cp = 0x32C2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C2, .cde = &lxb_unicode_decomposition_c_32C2, .kde = &lxb_unicode_decomposition_k_32C2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C3[2] = {0x0034, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C3[2] = {0x0034, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C3, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C3[2] = {0x0034, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C3, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C3 = {.cp = 0x32C3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C3, .cde = &lxb_unicode_decomposition_c_32C3, .kde = &lxb_unicode_decomposition_k_32C3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C4[2] = {0x0035, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C4[2] = {0x0035, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C4, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C4[2] = {0x0035, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C4, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C4 = {.cp = 0x32C4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C4, .cde = &lxb_unicode_decomposition_c_32C4, .kde = &lxb_unicode_decomposition_k_32C4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C5[2] = {0x0036, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C5[2] = {0x0036, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C5, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C5[2] = {0x0036, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C5, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C5 = {.cp = 0x32C5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C5, .cde = &lxb_unicode_decomposition_c_32C5, .kde = &lxb_unicode_decomposition_k_32C5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C6[2] = {0x0037, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C6[2] = {0x0037, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C6, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C6[2] = {0x0037, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C6, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C6 = {.cp = 0x32C6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C6, .cde = &lxb_unicode_decomposition_c_32C6, .kde = &lxb_unicode_decomposition_k_32C6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C7[2] = {0x0038, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C7[2] = {0x0038, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C7, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C7[2] = {0x0038, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C7, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C7 = {.cp = 0x32C7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C7, .cde = &lxb_unicode_decomposition_c_32C7, .kde = &lxb_unicode_decomposition_k_32C7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C8[2] = {0x0039, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C8[2] = {0x0039, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C8, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C8[2] = {0x0039, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C8, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32C8 = {.cp = 0x32C8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C8, .cde = &lxb_unicode_decomposition_c_32C8, .kde = &lxb_unicode_decomposition_k_32C8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32C9[3] = {0x0031, 0x0030, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32C9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32C9[3] = {0x0031, 0x0030, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32C9, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32C9[3] = {0x0031, 0x0030, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32C9, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_32C9 = {.cp = 0x32C9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32C9, .cde = &lxb_unicode_decomposition_c_32C9, .kde = &lxb_unicode_decomposition_k_32C9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32CA[3] = {0x0031, 0x0031, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32CA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32CA[3] = {0x0031, 0x0031, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32CA, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32CA[3] = {0x0031, 0x0031, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32CA, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_32CA = {.cp = 0x32CA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32CA, .cde = &lxb_unicode_decomposition_c_32CA, .kde = &lxb_unicode_decomposition_k_32CA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32CB[3] = {0x0031, 0x0032, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_32CB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32CB[3] = {0x0031, 0x0032, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_32CB, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32CB[3] = {0x0031, 0x0032, 0x6708};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__32CB, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_32CB = {.cp = 0x32CB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32CB, .cde = &lxb_unicode_decomposition_c_32CB, .kde = &lxb_unicode_decomposition_k_32CB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32CC[2] = {0x0048, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_32CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32CC[2] = {0x0048, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_32CC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32CC[2] = {0x0048, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__32CC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32CC = {.cp = 0x32CC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32CC, .cde = &lxb_unicode_decomposition_c_32CC, .kde = &lxb_unicode_decomposition_k_32CC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32CD[3] = {0x0065, 0x0072, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_32CD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32CD[3] = {0x0065, 0x0072, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_32CD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32CD[3] = {0x0065, 0x0072, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__32CD, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_32CD = {.cp = 0x32CD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32CD, .cde = &lxb_unicode_decomposition_c_32CD, .kde = &lxb_unicode_decomposition_k_32CD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32CE[2] = {0x0065, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_32CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32CE[2] = {0x0065, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_32CE, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32CE[2] = {0x0065, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__32CE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32CE = {.cp = 0x32CE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32CE, .cde = &lxb_unicode_decomposition_c_32CE, .kde = &lxb_unicode_decomposition_k_32CE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32CF[3] = {0x004C, 0x0054, 0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_32CF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32CF[3] = {0x004C, 0x0054, 0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_32CF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32CF[3] = {0x004C, 0x0054, 0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__32CF, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_32CF = {.cp = 0x32CF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32CF, .cde = &lxb_unicode_decomposition_c_32CF, .kde = &lxb_unicode_decomposition_k_32CF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D0[1] = {0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D0[1] = {0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D0[1] = {0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D0 = {.cp = 0x32D0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D0, .cde = &lxb_unicode_decomposition_c_32D0, .kde = &lxb_unicode_decomposition_k_32D0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D1[1] = {0x30A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D1[1] = {0x30A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D1[1] = {0x30A4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D1 = {.cp = 0x32D1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D1, .cde = &lxb_unicode_decomposition_c_32D1, .kde = &lxb_unicode_decomposition_k_32D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D2[1] = {0x30A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D2[1] = {0x30A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D2[1] = {0x30A6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D2 = {.cp = 0x32D2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D2, .cde = &lxb_unicode_decomposition_c_32D2, .kde = &lxb_unicode_decomposition_k_32D2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D3[1] = {0x30A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D3[1] = {0x30A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D3[1] = {0x30A8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D3 = {.cp = 0x32D3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D3, .cde = &lxb_unicode_decomposition_c_32D3, .kde = &lxb_unicode_decomposition_k_32D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D4[1] = {0x30AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D4[1] = {0x30AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D4[1] = {0x30AA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D4 = {.cp = 0x32D4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D4, .cde = &lxb_unicode_decomposition_c_32D4, .kde = &lxb_unicode_decomposition_k_32D4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D5[1] = {0x30AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D5[1] = {0x30AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D5[1] = {0x30AB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D5 = {.cp = 0x32D5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D5, .cde = &lxb_unicode_decomposition_c_32D5, .kde = &lxb_unicode_decomposition_k_32D5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D6[1] = {0x30AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D6[1] = {0x30AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D6[1] = {0x30AD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D6 = {.cp = 0x32D6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D6, .cde = &lxb_unicode_decomposition_c_32D6, .kde = &lxb_unicode_decomposition_k_32D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D7[1] = {0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D7[1] = {0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D7[1] = {0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D7 = {.cp = 0x32D7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D7, .cde = &lxb_unicode_decomposition_c_32D7, .kde = &lxb_unicode_decomposition_k_32D7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D8[1] = {0x30B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D8[1] = {0x30B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D8[1] = {0x30B1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D8 = {.cp = 0x32D8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D8, .cde = &lxb_unicode_decomposition_c_32D8, .kde = &lxb_unicode_decomposition_k_32D8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32D9[1] = {0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32D9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32D9[1] = {0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32D9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32D9[1] = {0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32D9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32D9 = {.cp = 0x32D9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32D9, .cde = &lxb_unicode_decomposition_c_32D9, .kde = &lxb_unicode_decomposition_k_32D9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32DA[1] = {0x30B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32DA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32DA[1] = {0x30B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32DA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32DA[1] = {0x30B5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32DA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32DA = {.cp = 0x32DA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32DA, .cde = &lxb_unicode_decomposition_c_32DA, .kde = &lxb_unicode_decomposition_k_32DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32DB[1] = {0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32DB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32DB[1] = {0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32DB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32DB[1] = {0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32DB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32DB = {.cp = 0x32DB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32DB, .cde = &lxb_unicode_decomposition_c_32DB, .kde = &lxb_unicode_decomposition_k_32DB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32DC[1] = {0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32DC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32DC[1] = {0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32DC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32DC[1] = {0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32DC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32DC = {.cp = 0x32DC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32DC, .cde = &lxb_unicode_decomposition_c_32DC, .kde = &lxb_unicode_decomposition_k_32DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32DD[1] = {0x30BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32DD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32DD[1] = {0x30BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32DD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32DD[1] = {0x30BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32DD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32DD = {.cp = 0x32DD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32DD, .cde = &lxb_unicode_decomposition_c_32DD, .kde = &lxb_unicode_decomposition_k_32DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32DE[1] = {0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32DE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32DE[1] = {0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32DE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32DE[1] = {0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32DE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32DE = {.cp = 0x32DE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32DE, .cde = &lxb_unicode_decomposition_c_32DE, .kde = &lxb_unicode_decomposition_k_32DE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32DF[1] = {0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32DF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32DF[1] = {0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32DF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32DF[1] = {0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32DF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32DF = {.cp = 0x32DF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32DF, .cde = &lxb_unicode_decomposition_c_32DF, .kde = &lxb_unicode_decomposition_k_32DF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E0[1] = {0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E0[1] = {0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E0[1] = {0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E0 = {.cp = 0x32E0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E0, .cde = &lxb_unicode_decomposition_c_32E0, .kde = &lxb_unicode_decomposition_k_32E0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E1[1] = {0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E1[1] = {0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E1[1] = {0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E1 = {.cp = 0x32E1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E1, .cde = &lxb_unicode_decomposition_c_32E1, .kde = &lxb_unicode_decomposition_k_32E1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E2[1] = {0x30C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E2[1] = {0x30C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E2[1] = {0x30C6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E2 = {.cp = 0x32E2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E2, .cde = &lxb_unicode_decomposition_c_32E2, .kde = &lxb_unicode_decomposition_k_32E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E3[1] = {0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E3[1] = {0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E3[1] = {0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E3 = {.cp = 0x32E3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E3, .cde = &lxb_unicode_decomposition_c_32E3, .kde = &lxb_unicode_decomposition_k_32E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E4[1] = {0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E4[1] = {0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E4[1] = {0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E4 = {.cp = 0x32E4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E4, .cde = &lxb_unicode_decomposition_c_32E4, .kde = &lxb_unicode_decomposition_k_32E4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E5[1] = {0x30CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E5[1] = {0x30CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E5[1] = {0x30CB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E5 = {.cp = 0x32E5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E5, .cde = &lxb_unicode_decomposition_c_32E5, .kde = &lxb_unicode_decomposition_k_32E5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E6[1] = {0x30CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E6[1] = {0x30CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E6[1] = {0x30CC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E6 = {.cp = 0x32E6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E6, .cde = &lxb_unicode_decomposition_c_32E6, .kde = &lxb_unicode_decomposition_k_32E6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E7[1] = {0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E7[1] = {0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E7[1] = {0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E7 = {.cp = 0x32E7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E7, .cde = &lxb_unicode_decomposition_c_32E7, .kde = &lxb_unicode_decomposition_k_32E7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E8[1] = {0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E8[1] = {0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E8[1] = {0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E8 = {.cp = 0x32E8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E8, .cde = &lxb_unicode_decomposition_c_32E8, .kde = &lxb_unicode_decomposition_k_32E8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32E9[1] = {0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32E9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32E9[1] = {0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32E9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32E9[1] = {0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32E9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32E9 = {.cp = 0x32E9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32E9, .cde = &lxb_unicode_decomposition_c_32E9, .kde = &lxb_unicode_decomposition_k_32E9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32EA[1] = {0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32EA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32EA[1] = {0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32EA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32EA[1] = {0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32EA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32EA = {.cp = 0x32EA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32EA, .cde = &lxb_unicode_decomposition_c_32EA, .kde = &lxb_unicode_decomposition_k_32EA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32EB[1] = {0x30D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32EB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32EB[1] = {0x30D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32EB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32EB[1] = {0x30D5};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32EB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32EB = {.cp = 0x32EB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32EB, .cde = &lxb_unicode_decomposition_c_32EB, .kde = &lxb_unicode_decomposition_k_32EB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32EC[1] = {0x30D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32EC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32EC[1] = {0x30D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32EC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32EC[1] = {0x30D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32EC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32EC = {.cp = 0x32EC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32EC, .cde = &lxb_unicode_decomposition_c_32EC, .kde = &lxb_unicode_decomposition_k_32EC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32ED[1] = {0x30DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32ED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32ED[1] = {0x30DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32ED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32ED[1] = {0x30DB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32ED, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32ED = {.cp = 0x32ED, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32ED, .cde = &lxb_unicode_decomposition_c_32ED, .kde = &lxb_unicode_decomposition_k_32ED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32EE[1] = {0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32EE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32EE[1] = {0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32EE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32EE[1] = {0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32EE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32EE = {.cp = 0x32EE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32EE, .cde = &lxb_unicode_decomposition_c_32EE, .kde = &lxb_unicode_decomposition_k_32EE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32EF[1] = {0x30DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32EF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32EF[1] = {0x30DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32EF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32EF[1] = {0x30DF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32EF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32EF = {.cp = 0x32EF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32EF, .cde = &lxb_unicode_decomposition_c_32EF, .kde = &lxb_unicode_decomposition_k_32EF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F0[1] = {0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F0[1] = {0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F0[1] = {0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F0 = {.cp = 0x32F0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F0, .cde = &lxb_unicode_decomposition_c_32F0, .kde = &lxb_unicode_decomposition_k_32F0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F1[1] = {0x30E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F1[1] = {0x30E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F1[1] = {0x30E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F1 = {.cp = 0x32F1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F1, .cde = &lxb_unicode_decomposition_c_32F1, .kde = &lxb_unicode_decomposition_k_32F1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F2[1] = {0x30E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F2[1] = {0x30E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F2[1] = {0x30E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F2 = {.cp = 0x32F2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F2, .cde = &lxb_unicode_decomposition_c_32F2, .kde = &lxb_unicode_decomposition_k_32F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F3[1] = {0x30E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F3[1] = {0x30E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F3[1] = {0x30E4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F3 = {.cp = 0x32F3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F3, .cde = &lxb_unicode_decomposition_c_32F3, .kde = &lxb_unicode_decomposition_k_32F3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F4[1] = {0x30E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F4[1] = {0x30E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F4[1] = {0x30E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F4 = {.cp = 0x32F4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F4, .cde = &lxb_unicode_decomposition_c_32F4, .kde = &lxb_unicode_decomposition_k_32F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F5[1] = {0x30E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F5[1] = {0x30E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F5[1] = {0x30E8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F5 = {.cp = 0x32F5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F5, .cde = &lxb_unicode_decomposition_c_32F5, .kde = &lxb_unicode_decomposition_k_32F5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F6[1] = {0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F6[1] = {0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F6[1] = {0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F6 = {.cp = 0x32F6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F6, .cde = &lxb_unicode_decomposition_c_32F6, .kde = &lxb_unicode_decomposition_k_32F6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F7[1] = {0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F7[1] = {0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F7[1] = {0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F7 = {.cp = 0x32F7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F7, .cde = &lxb_unicode_decomposition_c_32F7, .kde = &lxb_unicode_decomposition_k_32F7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F8[1] = {0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F8[1] = {0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F8[1] = {0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F8 = {.cp = 0x32F8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F8, .cde = &lxb_unicode_decomposition_c_32F8, .kde = &lxb_unicode_decomposition_k_32F8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32F9[1] = {0x30EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32F9[1] = {0x30EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32F9[1] = {0x30EC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32F9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32F9 = {.cp = 0x32F9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32F9, .cde = &lxb_unicode_decomposition_c_32F9, .kde = &lxb_unicode_decomposition_k_32F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32FA[1] = {0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32FA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32FA[1] = {0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32FA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32FA[1] = {0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32FA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32FA = {.cp = 0x32FA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32FA, .cde = &lxb_unicode_decomposition_c_32FA, .kde = &lxb_unicode_decomposition_k_32FA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32FB[1] = {0x30EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32FB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32FB[1] = {0x30EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32FB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32FB[1] = {0x30EF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32FB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32FB = {.cp = 0x32FB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32FB, .cde = &lxb_unicode_decomposition_c_32FB, .kde = &lxb_unicode_decomposition_k_32FB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32FC[1] = {0x30F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32FC[1] = {0x30F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32FC[1] = {0x30F0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32FC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32FC = {.cp = 0x32FC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32FC, .cde = &lxb_unicode_decomposition_c_32FC, .kde = &lxb_unicode_decomposition_k_32FC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32FD[1] = {0x30F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32FD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32FD[1] = {0x30F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32FD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32FD[1] = {0x30F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32FD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32FD = {.cp = 0x32FD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32FD, .cde = &lxb_unicode_decomposition_c_32FD, .kde = &lxb_unicode_decomposition_k_32FD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32FE[1] = {0x30F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_c_32FE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32FE[1] = {0x30F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp_k_32FE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32FE[1] = {0x30F2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_CIRCLE, .mapping = lxb_unicode_decomposition_cp__32FE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_32FE = {.cp = 0x32FE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32FE, .cde = &lxb_unicode_decomposition_c_32FE, .kde = &lxb_unicode_decomposition_k_32FE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_32FF[2] = {0x4EE4, 0x548C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_32FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_32FF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_32FF[2] = {0x4EE4, 0x548C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_32FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_32FF, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__32FF[2] = {0x4EE4, 0x548C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__32FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__32FF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_32FF = {.cp = 0x32FF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__32FF, .cde = &lxb_unicode_decomposition_c_32FF, .kde = &lxb_unicode_decomposition_k_32FF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3300[5] = {0x30A2, 0x30CF, 0x309A, 0x30FC, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3300 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3300, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3300[5] = {0x30A2, 0x30CF, 0x309A, 0x30FC, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3300 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3300, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3300[4] = {0x30A2, 0x30D1, 0x30FC, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3300 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3300, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3300 = {.cp = 0x3300, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3300, .cde = &lxb_unicode_decomposition_c_3300, .kde = &lxb_unicode_decomposition_k_3300};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3301[4] = {0x30A2, 0x30EB, 0x30D5, 0x30A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3301 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3301, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3301[4] = {0x30A2, 0x30EB, 0x30D5, 0x30A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3301 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3301, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3301[4] = {0x30A2, 0x30EB, 0x30D5, 0x30A1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3301 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3301, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3301 = {.cp = 0x3301, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3301, .cde = &lxb_unicode_decomposition_c_3301, .kde = &lxb_unicode_decomposition_k_3301};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3302[5] = {0x30A2, 0x30F3, 0x30D8, 0x309A, 0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3302 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3302, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3302[5] = {0x30A2, 0x30F3, 0x30D8, 0x309A, 0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3302 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3302, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3302[4] = {0x30A2, 0x30F3, 0x30DA, 0x30A2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3302 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3302, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3302 = {.cp = 0x3302, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3302, .cde = &lxb_unicode_decomposition_c_3302, .kde = &lxb_unicode_decomposition_k_3302};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3303[3] = {0x30A2, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3303 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3303, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3303[3] = {0x30A2, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3303 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3303, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3303[3] = {0x30A2, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3303 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3303, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3303 = {.cp = 0x3303, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3303, .cde = &lxb_unicode_decomposition_c_3303, .kde = &lxb_unicode_decomposition_k_3303};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3304[5] = {0x30A4, 0x30CB, 0x30F3, 0x30AF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3304 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3304, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3304[5] = {0x30A4, 0x30CB, 0x30F3, 0x30AF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3304 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3304, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3304[4] = {0x30A4, 0x30CB, 0x30F3, 0x30B0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3304 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3304, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3304 = {.cp = 0x3304, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3304, .cde = &lxb_unicode_decomposition_c_3304, .kde = &lxb_unicode_decomposition_k_3304};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3305[3] = {0x30A4, 0x30F3, 0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3305 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3305, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3305[3] = {0x30A4, 0x30F3, 0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3305 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3305, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3305[3] = {0x30A4, 0x30F3, 0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3305 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3305, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3305 = {.cp = 0x3305, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3305, .cde = &lxb_unicode_decomposition_c_3305, .kde = &lxb_unicode_decomposition_k_3305};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3306[3] = {0x30A6, 0x30A9, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3306 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3306, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3306[3] = {0x30A6, 0x30A9, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3306 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3306, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3306[3] = {0x30A6, 0x30A9, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3306 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3306, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3306 = {.cp = 0x3306, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3306, .cde = &lxb_unicode_decomposition_c_3306, .kde = &lxb_unicode_decomposition_k_3306};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3307[6] = {0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3307 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3307, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3307[6] = {0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3307 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3307, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3307[5] = {0x30A8, 0x30B9, 0x30AF, 0x30FC, 0x30C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3307 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3307, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3307 = {.cp = 0x3307, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3307, .cde = &lxb_unicode_decomposition_c_3307, .kde = &lxb_unicode_decomposition_k_3307};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3308[4] = {0x30A8, 0x30FC, 0x30AB, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3308 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3308, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3308[4] = {0x30A8, 0x30FC, 0x30AB, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3308 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3308, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3308[4] = {0x30A8, 0x30FC, 0x30AB, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3308 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3308, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3308 = {.cp = 0x3308, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3308, .cde = &lxb_unicode_decomposition_c_3308, .kde = &lxb_unicode_decomposition_k_3308};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3309[3] = {0x30AA, 0x30F3, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3309 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3309, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3309[3] = {0x30AA, 0x30F3, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3309 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3309, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3309[3] = {0x30AA, 0x30F3, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3309 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3309, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3309 = {.cp = 0x3309, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3309, .cde = &lxb_unicode_decomposition_c_3309, .kde = &lxb_unicode_decomposition_k_3309};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_330A[3] = {0x30AA, 0x30FC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_330A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_330A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_330A[3] = {0x30AA, 0x30FC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_330A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_330A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__330A[3] = {0x30AA, 0x30FC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__330A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__330A, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_330A = {.cp = 0x330A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__330A, .cde = &lxb_unicode_decomposition_c_330A, .kde = &lxb_unicode_decomposition_k_330A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_330B[3] = {0x30AB, 0x30A4, 0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_330B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_330B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_330B[3] = {0x30AB, 0x30A4, 0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_330B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_330B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__330B[3] = {0x30AB, 0x30A4, 0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__330B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__330B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_330B = {.cp = 0x330B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__330B, .cde = &lxb_unicode_decomposition_c_330B, .kde = &lxb_unicode_decomposition_k_330B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_330C[4] = {0x30AB, 0x30E9, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_330C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_330C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_330C[4] = {0x30AB, 0x30E9, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_330C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_330C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__330C[4] = {0x30AB, 0x30E9, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__330C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__330C, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_330C = {.cp = 0x330C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__330C, .cde = &lxb_unicode_decomposition_c_330C, .kde = &lxb_unicode_decomposition_k_330C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_330D[4] = {0x30AB, 0x30ED, 0x30EA, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_330D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_330D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_330D[4] = {0x30AB, 0x30ED, 0x30EA, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_330D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_330D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__330D[4] = {0x30AB, 0x30ED, 0x30EA, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__330D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__330D, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_330D = {.cp = 0x330D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__330D, .cde = &lxb_unicode_decomposition_c_330D, .kde = &lxb_unicode_decomposition_k_330D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_330E[4] = {0x30AB, 0x3099, 0x30ED, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_330E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_330E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_330E[4] = {0x30AB, 0x3099, 0x30ED, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_330E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_330E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__330E[3] = {0x30AC, 0x30ED, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__330E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__330E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_330E = {.cp = 0x330E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__330E, .cde = &lxb_unicode_decomposition_c_330E, .kde = &lxb_unicode_decomposition_k_330E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_330F[4] = {0x30AB, 0x3099, 0x30F3, 0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_330F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_330F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_330F[4] = {0x30AB, 0x3099, 0x30F3, 0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_330F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_330F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__330F[3] = {0x30AC, 0x30F3, 0x30DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__330F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__330F, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_330F = {.cp = 0x330F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__330F, .cde = &lxb_unicode_decomposition_c_330F, .kde = &lxb_unicode_decomposition_k_330F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3310[4] = {0x30AD, 0x3099, 0x30AB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3310 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3310, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3310[4] = {0x30AD, 0x3099, 0x30AB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3310 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3310, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3310[2] = {0x30AE, 0x30AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3310 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3310, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3310 = {.cp = 0x3310, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3310, .cde = &lxb_unicode_decomposition_c_3310, .kde = &lxb_unicode_decomposition_k_3310};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3311[4] = {0x30AD, 0x3099, 0x30CB, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3311 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3311, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3311[4] = {0x30AD, 0x3099, 0x30CB, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3311 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3311, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3311[3] = {0x30AE, 0x30CB, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3311 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3311, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3311 = {.cp = 0x3311, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3311, .cde = &lxb_unicode_decomposition_c_3311, .kde = &lxb_unicode_decomposition_k_3311};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3312[4] = {0x30AD, 0x30E5, 0x30EA, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3312 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3312, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3312[4] = {0x30AD, 0x30E5, 0x30EA, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3312 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3312, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3312[4] = {0x30AD, 0x30E5, 0x30EA, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3312 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3312, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3312 = {.cp = 0x3312, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3312, .cde = &lxb_unicode_decomposition_c_3312, .kde = &lxb_unicode_decomposition_k_3312};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3313[6] = {0x30AD, 0x3099, 0x30EB, 0x30BF, 0x3099, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3313 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3313, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3313[6] = {0x30AD, 0x3099, 0x30EB, 0x30BF, 0x3099, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3313 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3313, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3313[4] = {0x30AE, 0x30EB, 0x30C0, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3313 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3313, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3313 = {.cp = 0x3313, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3313, .cde = &lxb_unicode_decomposition_c_3313, .kde = &lxb_unicode_decomposition_k_3313};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3314[2] = {0x30AD, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3314 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3314, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3314[2] = {0x30AD, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3314 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3314, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3314[2] = {0x30AD, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3314 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3314, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3314 = {.cp = 0x3314, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3314, .cde = &lxb_unicode_decomposition_c_3314, .kde = &lxb_unicode_decomposition_k_3314};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3315[6] = {0x30AD, 0x30ED, 0x30AF, 0x3099, 0x30E9, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3315 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3315, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3315[6] = {0x30AD, 0x30ED, 0x30AF, 0x3099, 0x30E9, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3315 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3315, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3315[5] = {0x30AD, 0x30ED, 0x30B0, 0x30E9, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3315 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3315, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3315 = {.cp = 0x3315, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3315, .cde = &lxb_unicode_decomposition_c_3315, .kde = &lxb_unicode_decomposition_k_3315};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3316[6] = {0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3316 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3316, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3316[6] = {0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3316 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3316, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3316[6] = {0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3316 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3316, .length = 6};
static const lxb_unicode_entry_t lxb_unicode_entry_3316 = {.cp = 0x3316, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3316, .cde = &lxb_unicode_decomposition_c_3316, .kde = &lxb_unicode_decomposition_k_3316};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3317[5] = {0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3317 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3317, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3317[5] = {0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3317 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3317, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3317[5] = {0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3317 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3317, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3317 = {.cp = 0x3317, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3317, .cde = &lxb_unicode_decomposition_c_3317, .kde = &lxb_unicode_decomposition_k_3317};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3318[4] = {0x30AF, 0x3099, 0x30E9, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3318 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3318, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3318[4] = {0x30AF, 0x3099, 0x30E9, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3318 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3318, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3318[3] = {0x30B0, 0x30E9, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3318 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3318, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3318 = {.cp = 0x3318, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3318, .cde = &lxb_unicode_decomposition_c_3318, .kde = &lxb_unicode_decomposition_k_3318};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3319[6] = {0x30AF, 0x3099, 0x30E9, 0x30E0, 0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3319 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3319, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3319[6] = {0x30AF, 0x3099, 0x30E9, 0x30E0, 0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3319 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3319, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3319[5] = {0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3319 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3319, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3319 = {.cp = 0x3319, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3319, .cde = &lxb_unicode_decomposition_c_3319, .kde = &lxb_unicode_decomposition_k_3319};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_331A[6] = {0x30AF, 0x30EB, 0x30BB, 0x3099, 0x30A4, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_331A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_331A, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_331A[6] = {0x30AF, 0x30EB, 0x30BB, 0x3099, 0x30A4, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_331A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_331A, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__331A[5] = {0x30AF, 0x30EB, 0x30BC, 0x30A4, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__331A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__331A, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_331A = {.cp = 0x331A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__331A, .cde = &lxb_unicode_decomposition_c_331A, .kde = &lxb_unicode_decomposition_k_331A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_331B[4] = {0x30AF, 0x30ED, 0x30FC, 0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_331B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_331B, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_331B[4] = {0x30AF, 0x30ED, 0x30FC, 0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_331B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_331B, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__331B[4] = {0x30AF, 0x30ED, 0x30FC, 0x30CD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__331B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__331B, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_331B = {.cp = 0x331B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__331B, .cde = &lxb_unicode_decomposition_c_331B, .kde = &lxb_unicode_decomposition_k_331B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_331C[3] = {0x30B1, 0x30FC, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_331C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_331C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_331C[3] = {0x30B1, 0x30FC, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_331C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_331C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__331C[3] = {0x30B1, 0x30FC, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__331C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__331C, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_331C = {.cp = 0x331C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__331C, .cde = &lxb_unicode_decomposition_c_331C, .kde = &lxb_unicode_decomposition_k_331C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_331D[3] = {0x30B3, 0x30EB, 0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_331D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_331D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_331D[3] = {0x30B3, 0x30EB, 0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_331D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_331D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__331D[3] = {0x30B3, 0x30EB, 0x30CA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__331D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__331D, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_331D = {.cp = 0x331D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__331D, .cde = &lxb_unicode_decomposition_c_331D, .kde = &lxb_unicode_decomposition_k_331D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_331E[4] = {0x30B3, 0x30FC, 0x30DB, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_331E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_331E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_331E[4] = {0x30B3, 0x30FC, 0x30DB, 0x309A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_331E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_331E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__331E[3] = {0x30B3, 0x30FC, 0x30DD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__331E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__331E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_331E = {.cp = 0x331E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__331E, .cde = &lxb_unicode_decomposition_c_331E, .kde = &lxb_unicode_decomposition_k_331E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_331F[4] = {0x30B5, 0x30A4, 0x30AF, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_331F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_331F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_331F[4] = {0x30B5, 0x30A4, 0x30AF, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_331F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_331F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__331F[4] = {0x30B5, 0x30A4, 0x30AF, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__331F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__331F, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_331F = {.cp = 0x331F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__331F, .cde = &lxb_unicode_decomposition_c_331F, .kde = &lxb_unicode_decomposition_k_331F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3320[5] = {0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3320 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3320, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3320[5] = {0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3320 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3320, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3320[5] = {0x30B5, 0x30F3, 0x30C1, 0x30FC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3320 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3320, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3320 = {.cp = 0x3320, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3320, .cde = &lxb_unicode_decomposition_c_3320, .kde = &lxb_unicode_decomposition_k_3320};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3321[5] = {0x30B7, 0x30EA, 0x30F3, 0x30AF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3321 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3321, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3321[5] = {0x30B7, 0x30EA, 0x30F3, 0x30AF, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3321 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3321, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3321[4] = {0x30B7, 0x30EA, 0x30F3, 0x30B0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3321 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3321, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3321 = {.cp = 0x3321, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3321, .cde = &lxb_unicode_decomposition_c_3321, .kde = &lxb_unicode_decomposition_k_3321};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3322[3] = {0x30BB, 0x30F3, 0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3322 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3322, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3322[3] = {0x30BB, 0x30F3, 0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3322 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3322, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3322[3] = {0x30BB, 0x30F3, 0x30C1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3322 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3322, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3322 = {.cp = 0x3322, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3322, .cde = &lxb_unicode_decomposition_c_3322, .kde = &lxb_unicode_decomposition_k_3322};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3323[3] = {0x30BB, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3323 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3323, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3323[3] = {0x30BB, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3323 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3323, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3323[3] = {0x30BB, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3323 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3323, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3323 = {.cp = 0x3323, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3323, .cde = &lxb_unicode_decomposition_c_3323, .kde = &lxb_unicode_decomposition_k_3323};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3324[4] = {0x30BF, 0x3099, 0x30FC, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3324 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3324, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3324[4] = {0x30BF, 0x3099, 0x30FC, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3324 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3324, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3324[3] = {0x30C0, 0x30FC, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3324 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3324, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3324 = {.cp = 0x3324, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3324, .cde = &lxb_unicode_decomposition_c_3324, .kde = &lxb_unicode_decomposition_k_3324};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3325[3] = {0x30C6, 0x3099, 0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3325 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3325, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3325[3] = {0x30C6, 0x3099, 0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3325 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3325, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3325[2] = {0x30C7, 0x30B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3325 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3325, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3325 = {.cp = 0x3325, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3325, .cde = &lxb_unicode_decomposition_c_3325, .kde = &lxb_unicode_decomposition_k_3325};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3326[3] = {0x30C8, 0x3099, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3326 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3326, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3326[3] = {0x30C8, 0x3099, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3326 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3326, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3326[2] = {0x30C9, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3326 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3326, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3326 = {.cp = 0x3326, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3326, .cde = &lxb_unicode_decomposition_c_3326, .kde = &lxb_unicode_decomposition_k_3326};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3327[2] = {0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3327 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3327, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3327[2] = {0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3327 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3327, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3327[2] = {0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3327 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3327, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3327 = {.cp = 0x3327, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3327, .cde = &lxb_unicode_decomposition_c_3327, .kde = &lxb_unicode_decomposition_k_3327};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3328[2] = {0x30CA, 0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3328 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3328, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3328[2] = {0x30CA, 0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3328 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3328, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3328[2] = {0x30CA, 0x30CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3328 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3328, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3328 = {.cp = 0x3328, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3328, .cde = &lxb_unicode_decomposition_c_3328, .kde = &lxb_unicode_decomposition_k_3328};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3329[3] = {0x30CE, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3329 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3329, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3329[3] = {0x30CE, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3329 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3329, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3329[3] = {0x30CE, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3329 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3329, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3329 = {.cp = 0x3329, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3329, .cde = &lxb_unicode_decomposition_c_3329, .kde = &lxb_unicode_decomposition_k_3329};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_332A[3] = {0x30CF, 0x30A4, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_332A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_332A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_332A[3] = {0x30CF, 0x30A4, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_332A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_332A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__332A[3] = {0x30CF, 0x30A4, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__332A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__332A, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_332A = {.cp = 0x332A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__332A, .cde = &lxb_unicode_decomposition_c_332A, .kde = &lxb_unicode_decomposition_k_332A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_332B[6] = {0x30CF, 0x309A, 0x30FC, 0x30BB, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_332B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_332B, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_332B[6] = {0x30CF, 0x309A, 0x30FC, 0x30BB, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_332B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_332B, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__332B[5] = {0x30D1, 0x30FC, 0x30BB, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__332B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__332B, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_332B = {.cp = 0x332B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__332B, .cde = &lxb_unicode_decomposition_c_332B, .kde = &lxb_unicode_decomposition_k_332B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_332C[4] = {0x30CF, 0x309A, 0x30FC, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_332C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_332C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_332C[4] = {0x30CF, 0x309A, 0x30FC, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_332C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_332C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__332C[3] = {0x30D1, 0x30FC, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__332C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__332C, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_332C = {.cp = 0x332C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__332C, .cde = &lxb_unicode_decomposition_c_332C, .kde = &lxb_unicode_decomposition_k_332C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_332D[5] = {0x30CF, 0x3099, 0x30FC, 0x30EC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_332D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_332D, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_332D[5] = {0x30CF, 0x3099, 0x30FC, 0x30EC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_332D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_332D, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__332D[4] = {0x30D0, 0x30FC, 0x30EC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__332D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__332D, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_332D = {.cp = 0x332D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__332D, .cde = &lxb_unicode_decomposition_c_332D, .kde = &lxb_unicode_decomposition_k_332D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_332E[6] = {0x30D2, 0x309A, 0x30A2, 0x30B9, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_332E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_332E, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_332E[6] = {0x30D2, 0x309A, 0x30A2, 0x30B9, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_332E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_332E, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__332E[5] = {0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__332E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__332E, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_332E = {.cp = 0x332E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__332E, .cde = &lxb_unicode_decomposition_c_332E, .kde = &lxb_unicode_decomposition_k_332E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_332F[4] = {0x30D2, 0x309A, 0x30AF, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_332F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_332F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_332F[4] = {0x30D2, 0x309A, 0x30AF, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_332F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_332F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__332F[3] = {0x30D4, 0x30AF, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__332F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__332F, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_332F = {.cp = 0x332F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__332F, .cde = &lxb_unicode_decomposition_c_332F, .kde = &lxb_unicode_decomposition_k_332F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3330[3] = {0x30D2, 0x309A, 0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3330 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3330, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3330[3] = {0x30D2, 0x309A, 0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3330 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3330, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3330[2] = {0x30D4, 0x30B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3330 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3330, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3330 = {.cp = 0x3330, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3330, .cde = &lxb_unicode_decomposition_c_3330, .kde = &lxb_unicode_decomposition_k_3330};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3331[3] = {0x30D2, 0x3099, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3331 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3331, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3331[3] = {0x30D2, 0x3099, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3331 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3331, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3331[2] = {0x30D3, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3331 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3331, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3331 = {.cp = 0x3331, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3331, .cde = &lxb_unicode_decomposition_c_3331, .kde = &lxb_unicode_decomposition_k_3331};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3332[6] = {0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3332 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3332, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3332[6] = {0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3332 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3332, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3332[5] = {0x30D5, 0x30A1, 0x30E9, 0x30C3, 0x30C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3332 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3332, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3332 = {.cp = 0x3332, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3332, .cde = &lxb_unicode_decomposition_c_3332, .kde = &lxb_unicode_decomposition_k_3332};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3333[4] = {0x30D5, 0x30A3, 0x30FC, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3333 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3333, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3333[4] = {0x30D5, 0x30A3, 0x30FC, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3333 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3333, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3333[4] = {0x30D5, 0x30A3, 0x30FC, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3333 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3333, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3333 = {.cp = 0x3333, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3333, .cde = &lxb_unicode_decomposition_c_3333, .kde = &lxb_unicode_decomposition_k_3333};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3334[6] = {0x30D5, 0x3099, 0x30C3, 0x30B7, 0x30A7, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3334 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3334, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3334[6] = {0x30D5, 0x3099, 0x30C3, 0x30B7, 0x30A7, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3334 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3334, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3334[5] = {0x30D6, 0x30C3, 0x30B7, 0x30A7, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3334 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3334, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3334 = {.cp = 0x3334, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3334, .cde = &lxb_unicode_decomposition_c_3334, .kde = &lxb_unicode_decomposition_k_3334};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3335[3] = {0x30D5, 0x30E9, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3335 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3335, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3335[3] = {0x30D5, 0x30E9, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3335 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3335, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3335[3] = {0x30D5, 0x30E9, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3335 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3335, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3335 = {.cp = 0x3335, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3335, .cde = &lxb_unicode_decomposition_c_3335, .kde = &lxb_unicode_decomposition_k_3335};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3336[5] = {0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3336 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3336, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3336[5] = {0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3336 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3336, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3336[5] = {0x30D8, 0x30AF, 0x30BF, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3336 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3336, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3336 = {.cp = 0x3336, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3336, .cde = &lxb_unicode_decomposition_c_3336, .kde = &lxb_unicode_decomposition_k_3336};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3337[3] = {0x30D8, 0x309A, 0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3337 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3337, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3337[3] = {0x30D8, 0x309A, 0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3337 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3337, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3337[2] = {0x30DA, 0x30BD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3337 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3337, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3337 = {.cp = 0x3337, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3337, .cde = &lxb_unicode_decomposition_c_3337, .kde = &lxb_unicode_decomposition_k_3337};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3338[4] = {0x30D8, 0x309A, 0x30CB, 0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3338 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3338, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3338[4] = {0x30D8, 0x309A, 0x30CB, 0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3338 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3338, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3338[3] = {0x30DA, 0x30CB, 0x30D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3338 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3338, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3338 = {.cp = 0x3338, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3338, .cde = &lxb_unicode_decomposition_c_3338, .kde = &lxb_unicode_decomposition_k_3338};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3339[3] = {0x30D8, 0x30EB, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3339 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3339, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3339[3] = {0x30D8, 0x30EB, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3339 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3339, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3339[3] = {0x30D8, 0x30EB, 0x30C4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3339 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3339, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3339 = {.cp = 0x3339, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3339, .cde = &lxb_unicode_decomposition_c_3339, .kde = &lxb_unicode_decomposition_k_3339};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_333A[4] = {0x30D8, 0x309A, 0x30F3, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_333A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_333A, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_333A[4] = {0x30D8, 0x309A, 0x30F3, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_333A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_333A, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__333A[3] = {0x30DA, 0x30F3, 0x30B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__333A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__333A, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_333A = {.cp = 0x333A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__333A, .cde = &lxb_unicode_decomposition_c_333A, .kde = &lxb_unicode_decomposition_k_333A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_333B[5] = {0x30D8, 0x309A, 0x30FC, 0x30B7, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_333B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_333B, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_333B[5] = {0x30D8, 0x309A, 0x30FC, 0x30B7, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_333B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_333B, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__333B[3] = {0x30DA, 0x30FC, 0x30B8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__333B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__333B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_333B = {.cp = 0x333B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__333B, .cde = &lxb_unicode_decomposition_c_333B, .kde = &lxb_unicode_decomposition_k_333B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_333C[4] = {0x30D8, 0x3099, 0x30FC, 0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_333C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_333C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_333C[4] = {0x30D8, 0x3099, 0x30FC, 0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_333C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_333C, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__333C[3] = {0x30D9, 0x30FC, 0x30BF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__333C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__333C, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_333C = {.cp = 0x333C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__333C, .cde = &lxb_unicode_decomposition_c_333C, .kde = &lxb_unicode_decomposition_k_333C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_333D[5] = {0x30DB, 0x309A, 0x30A4, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_333D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_333D, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_333D[5] = {0x30DB, 0x309A, 0x30A4, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_333D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_333D, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__333D[4] = {0x30DD, 0x30A4, 0x30F3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__333D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__333D, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_333D = {.cp = 0x333D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__333D, .cde = &lxb_unicode_decomposition_c_333D, .kde = &lxb_unicode_decomposition_k_333D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_333E[4] = {0x30DB, 0x3099, 0x30EB, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_333E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_333E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_333E[4] = {0x30DB, 0x3099, 0x30EB, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_333E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_333E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__333E[3] = {0x30DC, 0x30EB, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__333E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__333E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_333E = {.cp = 0x333E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__333E, .cde = &lxb_unicode_decomposition_c_333E, .kde = &lxb_unicode_decomposition_k_333E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_333F[2] = {0x30DB, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_333F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_333F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_333F[2] = {0x30DB, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_333F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_333F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__333F[2] = {0x30DB, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__333F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__333F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_333F = {.cp = 0x333F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__333F, .cde = &lxb_unicode_decomposition_c_333F, .kde = &lxb_unicode_decomposition_k_333F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3340[5] = {0x30DB, 0x309A, 0x30F3, 0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3340 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3340, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3340[5] = {0x30DB, 0x309A, 0x30F3, 0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3340 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3340, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3340[3] = {0x30DD, 0x30F3, 0x30C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3340 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3340, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3340 = {.cp = 0x3340, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3340, .cde = &lxb_unicode_decomposition_c_3340, .kde = &lxb_unicode_decomposition_k_3340};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3341[3] = {0x30DB, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3341 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3341, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3341[3] = {0x30DB, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3341 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3341, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3341[3] = {0x30DB, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3341 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3341, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3341 = {.cp = 0x3341, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3341, .cde = &lxb_unicode_decomposition_c_3341, .kde = &lxb_unicode_decomposition_k_3341};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3342[3] = {0x30DB, 0x30FC, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3342 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3342, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3342[3] = {0x30DB, 0x30FC, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3342 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3342, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3342[3] = {0x30DB, 0x30FC, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3342 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3342, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3342 = {.cp = 0x3342, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3342, .cde = &lxb_unicode_decomposition_c_3342, .kde = &lxb_unicode_decomposition_k_3342};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3343[4] = {0x30DE, 0x30A4, 0x30AF, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3343 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3343, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3343[4] = {0x30DE, 0x30A4, 0x30AF, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3343 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3343, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3343[4] = {0x30DE, 0x30A4, 0x30AF, 0x30ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3343 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3343, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3343 = {.cp = 0x3343, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3343, .cde = &lxb_unicode_decomposition_c_3343, .kde = &lxb_unicode_decomposition_k_3343};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3344[3] = {0x30DE, 0x30A4, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3344 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3344, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3344[3] = {0x30DE, 0x30A4, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3344 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3344, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3344[3] = {0x30DE, 0x30A4, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3344 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3344, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3344 = {.cp = 0x3344, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3344, .cde = &lxb_unicode_decomposition_c_3344, .kde = &lxb_unicode_decomposition_k_3344};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3345[3] = {0x30DE, 0x30C3, 0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3345 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3345, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3345[3] = {0x30DE, 0x30C3, 0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3345 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3345, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3345[3] = {0x30DE, 0x30C3, 0x30CF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3345 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3345, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3345 = {.cp = 0x3345, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3345, .cde = &lxb_unicode_decomposition_c_3345, .kde = &lxb_unicode_decomposition_k_3345};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3346[3] = {0x30DE, 0x30EB, 0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3346 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3346, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3346[3] = {0x30DE, 0x30EB, 0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3346 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3346, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3346[3] = {0x30DE, 0x30EB, 0x30AF};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3346 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3346, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3346 = {.cp = 0x3346, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3346, .cde = &lxb_unicode_decomposition_c_3346, .kde = &lxb_unicode_decomposition_k_3346};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3347[5] = {0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3347 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3347, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3347[5] = {0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3347 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3347, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3347[5] = {0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3347 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3347, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3347 = {.cp = 0x3347, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3347, .cde = &lxb_unicode_decomposition_c_3347, .kde = &lxb_unicode_decomposition_k_3347};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3348[4] = {0x30DF, 0x30AF, 0x30ED, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3348 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3348, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3348[4] = {0x30DF, 0x30AF, 0x30ED, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3348 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3348, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3348[4] = {0x30DF, 0x30AF, 0x30ED, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3348 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3348, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3348 = {.cp = 0x3348, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3348, .cde = &lxb_unicode_decomposition_c_3348, .kde = &lxb_unicode_decomposition_k_3348};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3349[2] = {0x30DF, 0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3349 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3349, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3349[2] = {0x30DF, 0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3349 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3349, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3349[2] = {0x30DF, 0x30EA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3349 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3349, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3349 = {.cp = 0x3349, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3349, .cde = &lxb_unicode_decomposition_c_3349, .kde = &lxb_unicode_decomposition_k_3349};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_334A[6] = {0x30DF, 0x30EA, 0x30CF, 0x3099, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_334A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_334A, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_334A[6] = {0x30DF, 0x30EA, 0x30CF, 0x3099, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_334A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_334A, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__334A[5] = {0x30DF, 0x30EA, 0x30D0, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__334A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__334A, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_334A = {.cp = 0x334A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__334A, .cde = &lxb_unicode_decomposition_c_334A, .kde = &lxb_unicode_decomposition_k_334A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_334B[3] = {0x30E1, 0x30AB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_334B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_334B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_334B[3] = {0x30E1, 0x30AB, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_334B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_334B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__334B[2] = {0x30E1, 0x30AC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__334B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__334B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_334B = {.cp = 0x334B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__334B, .cde = &lxb_unicode_decomposition_c_334B, .kde = &lxb_unicode_decomposition_k_334B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_334C[5] = {0x30E1, 0x30AB, 0x3099, 0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_334C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_334C, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_334C[5] = {0x30E1, 0x30AB, 0x3099, 0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_334C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_334C, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__334C[4] = {0x30E1, 0x30AC, 0x30C8, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__334C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__334C, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_334C = {.cp = 0x334C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__334C, .cde = &lxb_unicode_decomposition_c_334C, .kde = &lxb_unicode_decomposition_k_334C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_334D[4] = {0x30E1, 0x30FC, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_334D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_334D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_334D[4] = {0x30E1, 0x30FC, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_334D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_334D, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__334D[4] = {0x30E1, 0x30FC, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__334D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__334D, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_334D = {.cp = 0x334D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__334D, .cde = &lxb_unicode_decomposition_c_334D, .kde = &lxb_unicode_decomposition_k_334D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_334E[4] = {0x30E4, 0x30FC, 0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_334E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_334E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_334E[4] = {0x30E4, 0x30FC, 0x30C8, 0x3099};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_334E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_334E, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__334E[3] = {0x30E4, 0x30FC, 0x30C9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__334E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__334E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_334E = {.cp = 0x334E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__334E, .cde = &lxb_unicode_decomposition_c_334E, .kde = &lxb_unicode_decomposition_k_334E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_334F[3] = {0x30E4, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_334F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_334F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_334F[3] = {0x30E4, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_334F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_334F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__334F[3] = {0x30E4, 0x30FC, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__334F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__334F, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_334F = {.cp = 0x334F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__334F, .cde = &lxb_unicode_decomposition_c_334F, .kde = &lxb_unicode_decomposition_k_334F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3350[3] = {0x30E6, 0x30A2, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3350 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3350, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3350[3] = {0x30E6, 0x30A2, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3350 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3350, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3350[3] = {0x30E6, 0x30A2, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3350 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3350, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3350 = {.cp = 0x3350, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3350, .cde = &lxb_unicode_decomposition_c_3350, .kde = &lxb_unicode_decomposition_k_3350};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3351[4] = {0x30EA, 0x30C3, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3351 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3351, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3351[4] = {0x30EA, 0x30C3, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3351 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3351, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3351[4] = {0x30EA, 0x30C3, 0x30C8, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3351 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3351, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3351 = {.cp = 0x3351, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3351, .cde = &lxb_unicode_decomposition_c_3351, .kde = &lxb_unicode_decomposition_k_3351};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3352[2] = {0x30EA, 0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3352 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3352, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3352[2] = {0x30EA, 0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3352 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3352, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3352[2] = {0x30EA, 0x30E9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3352 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3352, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3352 = {.cp = 0x3352, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3352, .cde = &lxb_unicode_decomposition_c_3352, .kde = &lxb_unicode_decomposition_k_3352};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3353[4] = {0x30EB, 0x30D2, 0x309A, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3353 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3353, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3353[4] = {0x30EB, 0x30D2, 0x309A, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3353 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3353, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3353[3] = {0x30EB, 0x30D4, 0x30FC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3353 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3353, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3353 = {.cp = 0x3353, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3353, .cde = &lxb_unicode_decomposition_c_3353, .kde = &lxb_unicode_decomposition_k_3353};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3354[5] = {0x30EB, 0x30FC, 0x30D5, 0x3099, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3354 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3354, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3354[5] = {0x30EB, 0x30FC, 0x30D5, 0x3099, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3354 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3354, .length = 5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3354[4] = {0x30EB, 0x30FC, 0x30D6, 0x30EB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3354 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3354, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3354 = {.cp = 0x3354, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3354, .cde = &lxb_unicode_decomposition_c_3354, .kde = &lxb_unicode_decomposition_k_3354};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3355[2] = {0x30EC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3355 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3355, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3355[2] = {0x30EC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3355 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3355, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3355[2] = {0x30EC, 0x30E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3355 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3355, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3355 = {.cp = 0x3355, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3355, .cde = &lxb_unicode_decomposition_c_3355, .kde = &lxb_unicode_decomposition_k_3355};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3356[6] = {0x30EC, 0x30F3, 0x30C8, 0x30B1, 0x3099, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3356 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3356, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3356[6] = {0x30EC, 0x30F3, 0x30C8, 0x30B1, 0x3099, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3356 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3356, .length = 6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3356[5] = {0x30EC, 0x30F3, 0x30C8, 0x30B2, 0x30F3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3356 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3356, .length = 5};
static const lxb_unicode_entry_t lxb_unicode_entry_3356 = {.cp = 0x3356, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3356, .cde = &lxb_unicode_decomposition_c_3356, .kde = &lxb_unicode_decomposition_k_3356};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3357[3] = {0x30EF, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3357 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3357, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3357[3] = {0x30EF, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3357 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3357, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3357[3] = {0x30EF, 0x30C3, 0x30C8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3357 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3357, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3357 = {.cp = 0x3357, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3357, .cde = &lxb_unicode_decomposition_c_3357, .kde = &lxb_unicode_decomposition_k_3357};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3358[2] = {0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3358 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3358, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3358[2] = {0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3358 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3358, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3358[2] = {0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3358 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3358, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3358 = {.cp = 0x3358, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3358, .cde = &lxb_unicode_decomposition_c_3358, .kde = &lxb_unicode_decomposition_k_3358};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3359[2] = {0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3359 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3359, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3359[2] = {0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3359 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3359, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3359[2] = {0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3359 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3359, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3359 = {.cp = 0x3359, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3359, .cde = &lxb_unicode_decomposition_c_3359, .kde = &lxb_unicode_decomposition_k_3359};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_335A[2] = {0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_335A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_335A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_335A[2] = {0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_335A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_335A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__335A[2] = {0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__335A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__335A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_335A = {.cp = 0x335A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__335A, .cde = &lxb_unicode_decomposition_c_335A, .kde = &lxb_unicode_decomposition_k_335A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_335B[2] = {0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_335B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_335B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_335B[2] = {0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_335B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_335B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__335B[2] = {0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__335B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__335B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_335B = {.cp = 0x335B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__335B, .cde = &lxb_unicode_decomposition_c_335B, .kde = &lxb_unicode_decomposition_k_335B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_335C[2] = {0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_335C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_335C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_335C[2] = {0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_335C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_335C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__335C[2] = {0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__335C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__335C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_335C = {.cp = 0x335C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__335C, .cde = &lxb_unicode_decomposition_c_335C, .kde = &lxb_unicode_decomposition_k_335C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_335D[2] = {0x0035, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_335D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_335D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_335D[2] = {0x0035, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_335D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_335D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__335D[2] = {0x0035, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__335D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__335D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_335D = {.cp = 0x335D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__335D, .cde = &lxb_unicode_decomposition_c_335D, .kde = &lxb_unicode_decomposition_k_335D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_335E[2] = {0x0036, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_335E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_335E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_335E[2] = {0x0036, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_335E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_335E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__335E[2] = {0x0036, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__335E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__335E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_335E = {.cp = 0x335E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__335E, .cde = &lxb_unicode_decomposition_c_335E, .kde = &lxb_unicode_decomposition_k_335E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_335F[2] = {0x0037, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_335F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_335F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_335F[2] = {0x0037, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_335F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_335F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__335F[2] = {0x0037, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__335F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__335F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_335F = {.cp = 0x335F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__335F, .cde = &lxb_unicode_decomposition_c_335F, .kde = &lxb_unicode_decomposition_k_335F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3360[2] = {0x0038, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3360 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3360, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3360[2] = {0x0038, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3360 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3360, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3360[2] = {0x0038, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3360 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3360, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3360 = {.cp = 0x3360, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3360, .cde = &lxb_unicode_decomposition_c_3360, .kde = &lxb_unicode_decomposition_k_3360};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3361[2] = {0x0039, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3361 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3361, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3361[2] = {0x0039, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3361 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3361, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3361[2] = {0x0039, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3361 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3361, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3361 = {.cp = 0x3361, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3361, .cde = &lxb_unicode_decomposition_c_3361, .kde = &lxb_unicode_decomposition_k_3361};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3362[3] = {0x0031, 0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3362 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3362, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3362[3] = {0x0031, 0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3362 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3362, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3362[3] = {0x0031, 0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3362 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3362, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3362 = {.cp = 0x3362, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3362, .cde = &lxb_unicode_decomposition_c_3362, .kde = &lxb_unicode_decomposition_k_3362};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3363[3] = {0x0031, 0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3363 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3363, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3363[3] = {0x0031, 0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3363 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3363, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3363[3] = {0x0031, 0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3363 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3363, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3363 = {.cp = 0x3363, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3363, .cde = &lxb_unicode_decomposition_c_3363, .kde = &lxb_unicode_decomposition_k_3363};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3364[3] = {0x0031, 0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3364 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3364, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3364[3] = {0x0031, 0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3364 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3364, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3364[3] = {0x0031, 0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3364 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3364, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3364 = {.cp = 0x3364, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3364, .cde = &lxb_unicode_decomposition_c_3364, .kde = &lxb_unicode_decomposition_k_3364};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3365[3] = {0x0031, 0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3365 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3365, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3365[3] = {0x0031, 0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3365 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3365, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3365[3] = {0x0031, 0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3365 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3365, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3365 = {.cp = 0x3365, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3365, .cde = &lxb_unicode_decomposition_c_3365, .kde = &lxb_unicode_decomposition_k_3365};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3366[3] = {0x0031, 0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3366 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3366, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3366[3] = {0x0031, 0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3366 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3366, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3366[3] = {0x0031, 0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3366 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3366, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3366 = {.cp = 0x3366, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3366, .cde = &lxb_unicode_decomposition_c_3366, .kde = &lxb_unicode_decomposition_k_3366};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3367[3] = {0x0031, 0x0035, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3367 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3367, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3367[3] = {0x0031, 0x0035, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3367 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3367, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3367[3] = {0x0031, 0x0035, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3367 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3367, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3367 = {.cp = 0x3367, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3367, .cde = &lxb_unicode_decomposition_c_3367, .kde = &lxb_unicode_decomposition_k_3367};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3368[3] = {0x0031, 0x0036, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3368 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3368, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3368[3] = {0x0031, 0x0036, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3368 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3368, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3368[3] = {0x0031, 0x0036, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3368 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3368, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3368 = {.cp = 0x3368, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3368, .cde = &lxb_unicode_decomposition_c_3368, .kde = &lxb_unicode_decomposition_k_3368};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3369[3] = {0x0031, 0x0037, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3369 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3369, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3369[3] = {0x0031, 0x0037, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3369 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3369, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3369[3] = {0x0031, 0x0037, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3369 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3369, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3369 = {.cp = 0x3369, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3369, .cde = &lxb_unicode_decomposition_c_3369, .kde = &lxb_unicode_decomposition_k_3369};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_336A[3] = {0x0031, 0x0038, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_336A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_336A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_336A[3] = {0x0031, 0x0038, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_336A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_336A, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__336A[3] = {0x0031, 0x0038, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__336A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__336A, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_336A = {.cp = 0x336A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__336A, .cde = &lxb_unicode_decomposition_c_336A, .kde = &lxb_unicode_decomposition_k_336A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_336B[3] = {0x0031, 0x0039, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_336B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_336B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_336B[3] = {0x0031, 0x0039, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_336B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_336B, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__336B[3] = {0x0031, 0x0039, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__336B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__336B, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_336B = {.cp = 0x336B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__336B, .cde = &lxb_unicode_decomposition_c_336B, .kde = &lxb_unicode_decomposition_k_336B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_336C[3] = {0x0032, 0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_336C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_336C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_336C[3] = {0x0032, 0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_336C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_336C, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__336C[3] = {0x0032, 0x0030, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__336C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__336C, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_336C = {.cp = 0x336C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__336C, .cde = &lxb_unicode_decomposition_c_336C, .kde = &lxb_unicode_decomposition_k_336C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_336D[3] = {0x0032, 0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_336D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_336D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_336D[3] = {0x0032, 0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_336D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_336D, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__336D[3] = {0x0032, 0x0031, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__336D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__336D, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_336D = {.cp = 0x336D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__336D, .cde = &lxb_unicode_decomposition_c_336D, .kde = &lxb_unicode_decomposition_k_336D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_336E[3] = {0x0032, 0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_336E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_336E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_336E[3] = {0x0032, 0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_336E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_336E, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__336E[3] = {0x0032, 0x0032, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__336E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__336E, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_336E = {.cp = 0x336E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__336E, .cde = &lxb_unicode_decomposition_c_336E, .kde = &lxb_unicode_decomposition_k_336E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_336F[3] = {0x0032, 0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_336F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_336F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_336F[3] = {0x0032, 0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_336F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_336F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__336F[3] = {0x0032, 0x0033, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__336F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__336F, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_336F = {.cp = 0x336F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__336F, .cde = &lxb_unicode_decomposition_c_336F, .kde = &lxb_unicode_decomposition_k_336F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3370[3] = {0x0032, 0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3370 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_c_3370, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3370[3] = {0x0032, 0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3370 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp_k_3370, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3370[3] = {0x0032, 0x0034, 0x70B9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3370 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_COMPAT, .mapping = lxb_unicode_decomposition_cp__3370, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3370 = {.cp = 0x3370, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3370, .cde = &lxb_unicode_decomposition_c_3370, .kde = &lxb_unicode_decomposition_k_3370};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3371[3] = {0x0068, 0x0050, 0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3371 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3371, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3371[3] = {0x0068, 0x0050, 0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3371 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3371, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3371[3] = {0x0068, 0x0050, 0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3371 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3371, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3371 = {.cp = 0x3371, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3371, .cde = &lxb_unicode_decomposition_c_3371, .kde = &lxb_unicode_decomposition_k_3371};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3372[2] = {0x0064, 0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3372 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3372, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3372[2] = {0x0064, 0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3372 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3372, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3372[2] = {0x0064, 0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3372 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3372, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3372 = {.cp = 0x3372, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3372, .cde = &lxb_unicode_decomposition_c_3372, .kde = &lxb_unicode_decomposition_k_3372};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3373[2] = {0x0041, 0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3373 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3373, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3373[2] = {0x0041, 0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3373 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3373, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3373[2] = {0x0041, 0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3373 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3373, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3373 = {.cp = 0x3373, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3373, .cde = &lxb_unicode_decomposition_c_3373, .kde = &lxb_unicode_decomposition_k_3373};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3374[3] = {0x0062, 0x0061, 0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3374 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3374, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3374[3] = {0x0062, 0x0061, 0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3374 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3374, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3374[3] = {0x0062, 0x0061, 0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3374 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3374, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3374 = {.cp = 0x3374, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3374, .cde = &lxb_unicode_decomposition_c_3374, .kde = &lxb_unicode_decomposition_k_3374};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3375[2] = {0x006F, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3375 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3375, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3375[2] = {0x006F, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3375 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3375, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3375[2] = {0x006F, 0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3375 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3375, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3375 = {.cp = 0x3375, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3375, .cde = &lxb_unicode_decomposition_c_3375, .kde = &lxb_unicode_decomposition_k_3375};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3376[2] = {0x0070, 0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3376 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3376, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3376[2] = {0x0070, 0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3376 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3376, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3376[2] = {0x0070, 0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3376 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3376, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3376 = {.cp = 0x3376, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3376, .cde = &lxb_unicode_decomposition_c_3376, .kde = &lxb_unicode_decomposition_k_3376};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3377[2] = {0x0064, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3377 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3377, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3377[2] = {0x0064, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3377 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3377, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3377[2] = {0x0064, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3377 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3377, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3377 = {.cp = 0x3377, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3377, .cde = &lxb_unicode_decomposition_c_3377, .kde = &lxb_unicode_decomposition_k_3377};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3378[3] = {0x0064, 0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3378 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3378, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3378[3] = {0x0064, 0x006D, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3378 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3378, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3378[3] = {0x0064, 0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3378 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3378, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3378 = {.cp = 0x3378, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3378, .cde = &lxb_unicode_decomposition_c_3378, .kde = &lxb_unicode_decomposition_k_3378};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3379[3] = {0x0064, 0x006D, 0x00B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3379 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3379, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3379[3] = {0x0064, 0x006D, 0x0033};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3379 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3379, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3379[3] = {0x0064, 0x006D, 0x00B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3379 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3379, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3379 = {.cp = 0x3379, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3379, .cde = &lxb_unicode_decomposition_c_3379, .kde = &lxb_unicode_decomposition_k_3379};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_337A[2] = {0x0049, 0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_337A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_337A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_337A[2] = {0x0049, 0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_337A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_337A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__337A[2] = {0x0049, 0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__337A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__337A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_337A = {.cp = 0x337A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__337A, .cde = &lxb_unicode_decomposition_c_337A, .kde = &lxb_unicode_decomposition_k_337A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_337B[2] = {0x5E73, 0x6210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_337B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_337B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_337B[2] = {0x5E73, 0x6210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_337B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_337B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__337B[2] = {0x5E73, 0x6210};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__337B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__337B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_337B = {.cp = 0x337B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__337B, .cde = &lxb_unicode_decomposition_c_337B, .kde = &lxb_unicode_decomposition_k_337B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_337C[2] = {0x662D, 0x548C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_337C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_337C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_337C[2] = {0x662D, 0x548C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_337C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_337C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__337C[2] = {0x662D, 0x548C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__337C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__337C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_337C = {.cp = 0x337C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__337C, .cde = &lxb_unicode_decomposition_c_337C, .kde = &lxb_unicode_decomposition_k_337C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_337D[2] = {0x5927, 0x6B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_337D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_337D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_337D[2] = {0x5927, 0x6B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_337D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_337D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__337D[2] = {0x5927, 0x6B63};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__337D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__337D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_337D = {.cp = 0x337D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__337D, .cde = &lxb_unicode_decomposition_c_337D, .kde = &lxb_unicode_decomposition_k_337D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_337E[2] = {0x660E, 0x6CBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_337E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_337E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_337E[2] = {0x660E, 0x6CBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_337E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_337E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__337E[2] = {0x660E, 0x6CBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__337E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__337E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_337E = {.cp = 0x337E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__337E, .cde = &lxb_unicode_decomposition_c_337E, .kde = &lxb_unicode_decomposition_k_337E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_337F[4] = {0x682A, 0x5F0F, 0x4F1A, 0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_337F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_337F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_337F[4] = {0x682A, 0x5F0F, 0x4F1A, 0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_337F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_337F, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__337F[4] = {0x682A, 0x5F0F, 0x4F1A, 0x793E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__337F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__337F, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_337F = {.cp = 0x337F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__337F, .cde = &lxb_unicode_decomposition_c_337F, .kde = &lxb_unicode_decomposition_k_337F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3380[2] = {0x0070, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3380 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3380, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3380[2] = {0x0070, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3380 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3380, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3380[2] = {0x0070, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3380 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3380, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3380 = {.cp = 0x3380, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3380, .cde = &lxb_unicode_decomposition_c_3380, .kde = &lxb_unicode_decomposition_k_3380};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3381[2] = {0x006E, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3381 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3381, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3381[2] = {0x006E, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3381 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3381, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3381[2] = {0x006E, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3381 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3381, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3381 = {.cp = 0x3381, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3381, .cde = &lxb_unicode_decomposition_c_3381, .kde = &lxb_unicode_decomposition_k_3381};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3382[2] = {0x03BC, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3382 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3382, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3382[2] = {0x03BC, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3382 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3382, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3382[2] = {0x03BC, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3382 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3382, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3382 = {.cp = 0x3382, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3382, .cde = &lxb_unicode_decomposition_c_3382, .kde = &lxb_unicode_decomposition_k_3382};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3383[2] = {0x006D, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3383 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3383, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3383[2] = {0x006D, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3383 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3383, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3383[2] = {0x006D, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3383 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3383, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3383 = {.cp = 0x3383, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3383, .cde = &lxb_unicode_decomposition_c_3383, .kde = &lxb_unicode_decomposition_k_3383};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3384[2] = {0x006B, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3384 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3384, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3384[2] = {0x006B, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3384 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3384, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3384[2] = {0x006B, 0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3384 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3384, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3384 = {.cp = 0x3384, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3384, .cde = &lxb_unicode_decomposition_c_3384, .kde = &lxb_unicode_decomposition_k_3384};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3385[2] = {0x004B, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3385 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3385, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3385[2] = {0x004B, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3385 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3385, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3385[2] = {0x004B, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3385 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3385, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3385 = {.cp = 0x3385, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3385, .cde = &lxb_unicode_decomposition_c_3385, .kde = &lxb_unicode_decomposition_k_3385};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3386[2] = {0x004D, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3386 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3386, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3386[2] = {0x004D, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3386 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3386, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3386[2] = {0x004D, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3386 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3386, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3386 = {.cp = 0x3386, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3386, .cde = &lxb_unicode_decomposition_c_3386, .kde = &lxb_unicode_decomposition_k_3386};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3387[2] = {0x0047, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3387 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3387, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3387[2] = {0x0047, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3387 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3387, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3387[2] = {0x0047, 0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3387 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3387, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3387 = {.cp = 0x3387, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3387, .cde = &lxb_unicode_decomposition_c_3387, .kde = &lxb_unicode_decomposition_k_3387};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3388[3] = {0x0063, 0x0061, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3388 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3388, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3388[3] = {0x0063, 0x0061, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3388 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3388, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3388[3] = {0x0063, 0x0061, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3388 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3388, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3388 = {.cp = 0x3388, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3388, .cde = &lxb_unicode_decomposition_c_3388, .kde = &lxb_unicode_decomposition_k_3388};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3389[4] = {0x006B, 0x0063, 0x0061, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3389 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3389, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3389[4] = {0x006B, 0x0063, 0x0061, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3389 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3389, .length = 4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3389[4] = {0x006B, 0x0063, 0x0061, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3389 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3389, .length = 4};
static const lxb_unicode_entry_t lxb_unicode_entry_3389 = {.cp = 0x3389, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3389, .cde = &lxb_unicode_decomposition_c_3389, .kde = &lxb_unicode_decomposition_k_3389};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_338A[2] = {0x0070, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_338A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_338A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_338A[2] = {0x0070, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_338A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_338A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__338A[2] = {0x0070, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__338A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__338A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_338A = {.cp = 0x338A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__338A, .cde = &lxb_unicode_decomposition_c_338A, .kde = &lxb_unicode_decomposition_k_338A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_338B[2] = {0x006E, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_338B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_338B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_338B[2] = {0x006E, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_338B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_338B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__338B[2] = {0x006E, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__338B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__338B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_338B = {.cp = 0x338B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__338B, .cde = &lxb_unicode_decomposition_c_338B, .kde = &lxb_unicode_decomposition_k_338B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_338C[2] = {0x03BC, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_338C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_338C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_338C[2] = {0x03BC, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_338C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_338C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__338C[2] = {0x03BC, 0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__338C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__338C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_338C = {.cp = 0x338C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__338C, .cde = &lxb_unicode_decomposition_c_338C, .kde = &lxb_unicode_decomposition_k_338C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_338D[2] = {0x03BC, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_338D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_338D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_338D[2] = {0x03BC, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_338D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_338D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__338D[2] = {0x03BC, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__338D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__338D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_338D = {.cp = 0x338D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__338D, .cde = &lxb_unicode_decomposition_c_338D, .kde = &lxb_unicode_decomposition_k_338D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_338E[2] = {0x006D, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_338E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_338E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_338E[2] = {0x006D, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_338E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_338E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__338E[2] = {0x006D, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__338E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__338E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_338E = {.cp = 0x338E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__338E, .cde = &lxb_unicode_decomposition_c_338E, .kde = &lxb_unicode_decomposition_k_338E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_338F[2] = {0x006B, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_338F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_338F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_338F[2] = {0x006B, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_338F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_338F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__338F[2] = {0x006B, 0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__338F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__338F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_338F = {.cp = 0x338F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__338F, .cde = &lxb_unicode_decomposition_c_338F, .kde = &lxb_unicode_decomposition_k_338F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3390[2] = {0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3390 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3390, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3390[2] = {0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3390 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3390, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3390[2] = {0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3390 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3390, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3390 = {.cp = 0x3390, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3390, .cde = &lxb_unicode_decomposition_c_3390, .kde = &lxb_unicode_decomposition_k_3390};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3391[3] = {0x006B, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3391 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3391, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3391[3] = {0x006B, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3391 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3391, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3391[3] = {0x006B, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3391 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3391, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3391 = {.cp = 0x3391, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3391, .cde = &lxb_unicode_decomposition_c_3391, .kde = &lxb_unicode_decomposition_k_3391};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3392[3] = {0x004D, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3392 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3392, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3392[3] = {0x004D, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3392 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3392, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3392[3] = {0x004D, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3392 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3392, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3392 = {.cp = 0x3392, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3392, .cde = &lxb_unicode_decomposition_c_3392, .kde = &lxb_unicode_decomposition_k_3392};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3393[3] = {0x0047, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3393 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3393, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3393[3] = {0x0047, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3393 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3393, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3393[3] = {0x0047, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3393 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3393, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3393 = {.cp = 0x3393, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3393, .cde = &lxb_unicode_decomposition_c_3393, .kde = &lxb_unicode_decomposition_k_3393};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3394[3] = {0x0054, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3394 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3394, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3394[3] = {0x0054, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3394 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3394, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3394[3] = {0x0054, 0x0048, 0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3394 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3394, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_3394 = {.cp = 0x3394, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3394, .cde = &lxb_unicode_decomposition_c_3394, .kde = &lxb_unicode_decomposition_k_3394};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3395[2] = {0x03BC, 0x2113};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3395 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3395, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3395[2] = {0x03BC, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3395 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3395, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3395[2] = {0x03BC, 0x2113};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3395 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3395, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3395 = {.cp = 0x3395, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3395, .cde = &lxb_unicode_decomposition_c_3395, .kde = &lxb_unicode_decomposition_k_3395};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3396[2] = {0x006D, 0x2113};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3396 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3396, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3396[2] = {0x006D, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3396 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3396, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3396[2] = {0x006D, 0x2113};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3396 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3396, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3396 = {.cp = 0x3396, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3396, .cde = &lxb_unicode_decomposition_c_3396, .kde = &lxb_unicode_decomposition_k_3396};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3397[2] = {0x0064, 0x2113};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3397 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3397, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3397[2] = {0x0064, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3397 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3397, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3397[2] = {0x0064, 0x2113};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3397 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3397, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3397 = {.cp = 0x3397, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3397, .cde = &lxb_unicode_decomposition_c_3397, .kde = &lxb_unicode_decomposition_k_3397};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3398[2] = {0x006B, 0x2113};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3398 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3398, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3398[2] = {0x006B, 0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3398 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3398, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3398[2] = {0x006B, 0x2113};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3398 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3398, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3398 = {.cp = 0x3398, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3398, .cde = &lxb_unicode_decomposition_c_3398, .kde = &lxb_unicode_decomposition_k_3398};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_3399[2] = {0x0066, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_3399 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_3399, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_3399[2] = {0x0066, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_3399 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_3399, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__3399[2] = {0x0066, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__3399 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__3399, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_3399 = {.cp = 0x3399, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__3399, .cde = &lxb_unicode_decomposition_c_3399, .kde = &lxb_unicode_decomposition_k_3399};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_339A[2] = {0x006E, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_339A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_339A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_339A[2] = {0x006E, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_339A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_339A, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__339A[2] = {0x006E, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__339A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__339A, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_339A = {.cp = 0x339A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__339A, .cde = &lxb_unicode_decomposition_c_339A, .kde = &lxb_unicode_decomposition_k_339A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_339B[2] = {0x03BC, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_339B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_339B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_339B[2] = {0x03BC, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_339B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_339B, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__339B[2] = {0x03BC, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__339B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__339B, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_339B = {.cp = 0x339B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__339B, .cde = &lxb_unicode_decomposition_c_339B, .kde = &lxb_unicode_decomposition_k_339B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_339C[2] = {0x006D, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_339C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_339C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_339C[2] = {0x006D, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_339C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_339C, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__339C[2] = {0x006D, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__339C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__339C, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_339C = {.cp = 0x339C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__339C, .cde = &lxb_unicode_decomposition_c_339C, .kde = &lxb_unicode_decomposition_k_339C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_339D[2] = {0x0063, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_339D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_339D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_339D[2] = {0x0063, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_339D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_339D, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__339D[2] = {0x0063, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__339D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__339D, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_339D = {.cp = 0x339D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__339D, .cde = &lxb_unicode_decomposition_c_339D, .kde = &lxb_unicode_decomposition_k_339D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_339E[2] = {0x006B, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_339E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_339E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_339E[2] = {0x006B, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_339E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_339E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__339E[2] = {0x006B, 0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__339E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__339E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_339E = {.cp = 0x339E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__339E, .cde = &lxb_unicode_decomposition_c_339E, .kde = &lxb_unicode_decomposition_k_339E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_339F[3] = {0x006D, 0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_339F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_339F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_339F[3] = {0x006D, 0x006D, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_339F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_339F, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__339F[3] = {0x006D, 0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__339F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__339F, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_339F = {.cp = 0x339F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__339F, .cde = &lxb_unicode_decomposition_c_339F, .kde = &lxb_unicode_decomposition_k_339F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_33A0[3] = {0x0063, 0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_33A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_33A0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_33A0[3] = {0x0063, 0x006D, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_33A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_33A0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__33A0[3] = {0x0063, 0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__33A0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__33A0, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_33A0 = {.cp = 0x33A0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__33A0, .cde = &lxb_unicode_decomposition_c_33A0, .kde = &lxb_unicode_decomposition_k_33A0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_33A1[2] = {0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_33A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_33A1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_33A1[2] = {0x006D, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_33A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_33A1, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__33A1[2] = {0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__33A1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__33A1, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_33A1 = {.cp = 0x33A1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__33A1, .cde = &lxb_unicode_decomposition_c_33A1, .kde = &lxb_unicode_decomposition_k_33A1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_33A2[3] = {0x006B, 0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_33A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_33A2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_33A2[3] = {0x006B, 0x006D, 0x0032};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_33A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_k_33A2, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__33A2[3] = {0x006B, 0x006D, 0x00B2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__33A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp__33A2, .length = 3};
static const lxb_unicode_entry_t lxb_unicode_entry_33A2 = {.cp = 0x33A2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__33A2, .cde = &lxb_unicode_decomposition_c_33A2, .kde = &lxb_unicode_decomposition_k_33A2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_33A3[3] = {0x006D, 0x006D, 0x00B3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_33A3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_SQUARE, .mapping = lxb_unicode_decomposition_cp_c_33A3, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_33A3[3] = {0x006D, 0x006D, 0x0033};
static