#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Json Visitor base class

template <class StructType>
class JsonBaseVisitor : public BaseVisitor<StructType>
{
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    std::string s, indtd = "";
    bool no_loc = false;
    int indent_level = 0, indent_spaces = 4;
    LocationManager &lm;
public:
    JsonBaseVisitor(LocationManager &lmref) : lm(lmref) {
        s.reserve(100000);
    }
    void inc_indent() {
        indent_level++;
        indtd = std::string(indent_level*indent_spaces, ' ');
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indtd = std::string(indent_level*indent_spaces, ' ');
    }
    void append_location(std::string &s, uint32_t first, uint32_t last) {
        if (no_loc) return;
        s.append(",\n" + indtd);
        s.append("\"loc\": {");
        inc_indent();
        s.append("\n" + indtd);
        s.append("\"first\": " + std::to_string(first));
        s.append(",\n" + indtd);
        s.append("\"last\": " + std::to_string(last));

        uint32_t first_line = 0, first_col = 0;
        std::string first_filename;
        uint32_t last_line = 0, last_col = 0;
        std::string last_filename;

        lm.pos_to_linecol(first, first_line, first_col, first_filename);
        lm.pos_to_linecol(last, last_line, last_col, last_filename);

        s.append(",\n" + indtd);
        s.append("\"first_filename\": \"" + first_filename + "\"");
        s.append(",\n" + indtd);
        s.append("\"first_line\": " + std::to_string(first_line));
        s.append(",\n" + indtd);
        s.append("\"first_column\": " + std::to_string(first_col));
        s.append(",\n" + indtd);
        s.append("\"last_filename\": \"" + last_filename + "\"");
        s.append(",\n" + indtd);
        s.append("\"last_line\": " + std::to_string(last_line));
        s.append(",\n" + indtd);
        s.append("\"last_column\": " + std::to_string(last_col));

        dec_indent();
        s.append("\n" + indtd);
        s.append("}");
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TranslationUnit\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"items\": ");
        s.append("[");
        if (x.n_items > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_items; i++) {
                self().visit_asr(*x.m_items[i]);
                if (i < x.n_items-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Program(const Program_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Program\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Module(const Module_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Module\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"loaded_from_mod\": ");
        if (x.m_loaded_from_mod) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"intrinsic\": ");
        if (x.m_intrinsic) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Function(const Function_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Function\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"function_signature\": ");
        self().visit_ttype(*x.m_function_signature);
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"return_var\": ");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"deterministic\": ");
        if (x.m_deterministic) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"side_effect_free\": ");
        if (x.m_side_effect_free) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"module_file\": ");
        if (x.m_module_file) {
            s.append("\"" + str_escape_c(x.m_module_file) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GenericProcedure\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"procs\": ");
        s.append("[");
        if (x.n_procs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_procs; i++) {
                self().visit_symbol(*x.m_procs[i]);
                if (i < x.n_procs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CustomOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"procs\": ");
        s.append("[");
        if (x.n_procs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_procs; i++) {
                self().visit_symbol(*x.m_procs[i]);
                if (i < x.n_procs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ExternalSymbol\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"external\": ");
        self().visit_symbol(*x.m_external);
        s.append(",\n" + indtd);
        s.append("\"module_name\": ");
        s.append("\"" + std::string(x.m_module_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"scope_names\": ");
        s.append("[");
        if (x.n_scope_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_scope_names; i++) {
                s.append("\"" + std::string(x.m_scope_names[i]) + "\"");
                if (i < x.n_scope_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"original_name\": ");
        s.append("\"" + std::string(x.m_original_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Struct(const Struct_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Struct\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"members\": ");
        s.append("[");
        if (x.n_members > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_members; i++) {
                s.append("\"" + std::string(x.m_members[i]) + "\"");
                if (i < x.n_members-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"is_packed\": ");
        if (x.m_is_packed) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"is_abstract\": ");
        if (x.m_is_abstract) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"initializers\": ");
        s.append("[");
        if (x.n_initializers > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_initializers; i++) {
                self().visit_call_arg(x.m_initializers[i]);
                if (i < x.n_initializers-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"alignment\": ");
        if (x.m_alignment) {
            self().visit_expr(*x.m_alignment);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"parent\": ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Enum(const Enum_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Enum\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"members\": ");
        s.append("[");
        if (x.n_members > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_members; i++) {
                s.append("\"" + std::string(x.m_members[i]) + "\"");
                if (i < x.n_members-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"enum_value_type\": ");
        visit_enumtypeType(x.m_enum_value_type);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"parent\": ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Union(const Union_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Union\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"members\": ");
        s.append("[");
        if (x.n_members > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_members; i++) {
                s.append("\"" + std::string(x.m_members[i]) + "\"");
                if (i < x.n_members-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"initializers\": ");
        s.append("[");
        if (x.n_initializers > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_initializers; i++) {
                self().visit_call_arg(x.m_initializers[i]);
                if (i < x.n_initializers-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"parent\": ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Variable(const Variable_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Variable\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"intent\": ");
        visit_intentType(x.m_intent);
        s.append(",\n" + indtd);
        s.append("\"symbolic_value\": ");
        if (x.m_symbolic_value) {
            self().visit_expr(*x.m_symbolic_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"storage\": ");
        visit_storage_typeType(x.m_storage);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"type_declaration\": ");
        if (x.m_type_declaration) {
            self().visit_symbol(*x.m_type_declaration);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"presence\": ");
        visit_presenceType(x.m_presence);
        s.append(",\n" + indtd);
        s.append("\"value_attr\": ");
        if (x.m_value_attr) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"target_attr\": ");
        if (x.m_target_attr) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Class(const Class_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Class\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ClassProcedure\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"self_argument\": ");
        if (x.m_self_argument) {
            s.append("\"" + std::string(x.m_self_argument) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"proc_name\": ");
        s.append("\"" + std::string(x.m_proc_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"proc\": ");
        self().visit_symbol(*x.m_proc);
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"is_deferred\": ");
        if (x.m_is_deferred) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"is_nopass\": ");
        if (x.m_is_nopass) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AssociateBlock\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Block(const Block_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Block\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Requirement(const Requirement_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Requirement\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                s.append("\"" + std::string(x.m_args[i]) + "\"");
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"requires\": ");
        s.append("[");
        if (x.n_requires > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_requires; i++) {
                self().visit_require_instantiation(*x.m_requires[i]);
                if (i < x.n_requires-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Template(const Template_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Template\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                s.append("\"" + std::string(x.m_args[i]) + "\"");
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"requires\": ");
        s.append("[");
        if (x.n_requires > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_requires; i++) {
                self().visit_require_instantiation(*x.m_requires[i]);
                if (i < x.n_requires-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Allocate(const Allocate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Allocate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_alloc_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"stat\": ");
        if (x.m_stat) {
            self().visit_expr(*x.m_stat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"errmsg\": ");
        if (x.m_errmsg) {
            self().visit_expr(*x.m_errmsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"source\": ");
        if (x.m_source) {
            self().visit_expr(*x.m_source);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ReAlloc\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_alloc_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assign(const Assign_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Assign\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"variable\": ");
        s.append("\"" + std::string(x.m_variable) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Assignment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Associate(const Associate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Associate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Cycle(const Cycle_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Cycle\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ExplicitDeallocate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vars\": ");
        s.append("[");
        if (x.n_vars > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_vars; i++) {
                self().visit_expr(*x.m_vars[i]);
                if (i < x.n_vars-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ImplicitDeallocate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vars\": ");
        s.append("[");
        if (x.n_vars > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_vars; i++) {
                self().visit_expr(*x.m_vars[i]);
                if (i < x.n_vars-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DoConcurrentLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"head\": ");
        s.append("[");
        if (x.n_head > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_head; i++) {
                self().visit_do_loop_head(x.m_head[i]);
                if (i < x.n_head-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"shared\": ");
        s.append("[");
        if (x.n_shared > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_shared; i++) {
                self().visit_expr(*x.m_shared[i]);
                if (i < x.n_shared-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"local\": ");
        s.append("[");
        if (x.n_local > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_local; i++) {
                self().visit_expr(*x.m_local[i]);
                if (i < x.n_local-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"reduction\": ");
        s.append("[");
        if (x.n_reduction > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_reduction; i++) {
                self().visit_reduction_expr(x.m_reduction[i]);
                if (i < x.n_reduction-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DoLoop(const DoLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DoLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"head\": ");
        self().visit_do_loop_head(x.m_head);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ErrorStop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"code\": ");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Exit(const Exit_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Exit\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ForAllSingle\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"head\": ");
        self().visit_do_loop_head(x.m_head);
        s.append(",\n" + indtd);
        s.append("\"assign_stmt\": ");
        self().visit_stmt(*x.m_assign_stmt);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoTo(const GoTo_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GoTo\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target_id\": ");
        s.append(std::to_string(x.m_target_id));
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GoToTarget\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append(std::to_string(x.m_id));
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"If\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IfArithmetic\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"lt_label\": ");
        s.append(std::to_string(x.m_lt_label));
        s.append(",\n" + indtd);
        s.append("\"eq_label\": ");
        s.append(std::to_string(x.m_eq_label));
        s.append(",\n" + indtd);
        s.append("\"gt_label\": ");
        s.append(std::to_string(x.m_gt_label));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Print(const Print_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Print\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"text\": ");
        self().visit_expr(*x.m_text);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileOpen(const FileOpen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileOpen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"newunit\": ");
        if (x.m_newunit) {
            self().visit_expr(*x.m_newunit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"filename\": ");
        if (x.m_filename) {
            self().visit_expr(*x.m_filename);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"status\": ");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"form\": ");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileClose(const FileClose_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileClose\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iomsg\": ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"status\": ");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileRead(const FileRead_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileRead\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"fmt\": ");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iomsg\": ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"size\": ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"id\": ");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileBackspace\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileRewind(const FileRewind_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileRewind\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileInquire(const FileInquire_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileInquire\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"file\": ");
        if (x.m_file) {
            self().visit_expr(*x.m_file);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"exist\": ");
        if (x.m_exist) {
            self().visit_expr(*x.m_exist);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"opened\": ");
        if (x.m_opened) {
            self().visit_expr(*x.m_opened);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"number\": ");
        if (x.m_number) {
            self().visit_expr(*x.m_number);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"named\": ");
        if (x.m_named) {
            self().visit_expr(*x.m_named);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            self().visit_expr(*x.m_name);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        if (x.m_access) {
            self().visit_expr(*x.m_access);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"sequential\": ");
        if (x.m_sequential) {
            self().visit_expr(*x.m_sequential);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"direct\": ");
        if (x.m_direct) {
            self().visit_expr(*x.m_direct);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"form\": ");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"formatted\": ");
        if (x.m_formatted) {
            self().visit_expr(*x.m_formatted);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"unformatted\": ");
        if (x.m_unformatted) {
            self().visit_expr(*x.m_unformatted);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"recl\": ");
        if (x.m_recl) {
            self().visit_expr(*x.m_recl);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"nextrec\": ");
        if (x.m_nextrec) {
            self().visit_expr(*x.m_nextrec);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"blank\": ");
        if (x.m_blank) {
            self().visit_expr(*x.m_blank);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"position\": ");
        if (x.m_position) {
            self().visit_expr(*x.m_position);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"action\": ");
        if (x.m_action) {
            self().visit_expr(*x.m_action);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"read\": ");
        if (x.m_read) {
            self().visit_expr(*x.m_read);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"write\": ");
        if (x.m_write) {
            self().visit_expr(*x.m_write);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"readwrite\": ");
        if (x.m_readwrite) {
            self().visit_expr(*x.m_readwrite);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"delim\": ");
        if (x.m_delim) {
            self().visit_expr(*x.m_delim);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"pad\": ");
        if (x.m_pad) {
            self().visit_expr(*x.m_pad);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"flen\": ");
        if (x.m_flen) {
            self().visit_expr(*x.m_flen);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"blocksize\": ");
        if (x.m_blocksize) {
            self().visit_expr(*x.m_blocksize);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"convert\": ");
        if (x.m_convert) {
            self().visit_expr(*x.m_convert);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"carriagecontrol\": ");
        if (x.m_carriagecontrol) {
            self().visit_expr(*x.m_carriagecontrol);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"size\": ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iolength\": ");
        if (x.m_iolength) {
            self().visit_expr(*x.m_iolength);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileWrite(const FileWrite_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileWrite\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iomsg\": ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"id\": ");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"separator\": ");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Return(const Return_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Return\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Select\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_case_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"default\": ");
        s.append("[");
        if (x.n_default > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_default; i++) {
                self().visit_stmt(*x.m_default[i]);
                if (i < x.n_default-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"enable_fall_through\": ");
        if (x.m_enable_fall_through) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Stop(const Stop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Stop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"code\": ");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assert(const Assert_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Assert\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"msg\": ");
        if (x.m_msg) {
            self().visit_expr(*x.m_msg);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SubroutineCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        self().visit_symbol(*x.m_name);
        s.append(",\n" + indtd);
        s.append("\"original_name\": ");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_call_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"dt\": ");
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicImpureSubroutine\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"sub_intrinsic_id\": ");
        s.append(std::to_string(x.m_sub_intrinsic_id));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overload_id\": ");
        s.append(std::to_string(x.m_overload_id));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Where(const Where_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Where\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"WhileLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Nullify(const Nullify_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Nullify\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vars\": ");
        s.append("[");
        if (x.n_vars > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_vars; i++) {
                self().visit_expr(*x.m_vars[i]);
                if (i < x.n_vars-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Flush(const Flush_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Flush\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        self().visit_expr(*x.m_unit);
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iomsg\": ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListAppend(const ListAppend_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListAppend\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AssociateBlockCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SelectType(const SelectType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SelectType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"selector\": ");
        self().visit_expr(*x.m_selector);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_type_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"default\": ");
        s.append("[");
        if (x.n_default > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_default; i++) {
                self().visit_stmt(*x.m_default[i]);
                if (i < x.n_default-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CPtrToPointer\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"cptr\": ");
        self().visit_expr(*x.m_cptr);
        s.append(",\n" + indtd);
        s.append("\"ptr\": ");
        self().visit_expr(*x.m_ptr);
        s.append(",\n" + indtd);
        s.append("\"shape\": ");
        if (x.m_shape) {
            self().visit_expr(*x.m_shape);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"lower_bounds\": ");
        if (x.m_lower_bounds) {
            self().visit_expr(*x.m_lower_bounds);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_BlockCall(const BlockCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"BlockCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetInsert(const SetInsert_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetInsert\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetRemove(const SetRemove_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetRemove\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListInsert(const ListInsert_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListInsert\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"pos\": ");
        self().visit_expr(*x.m_pos);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListRemove(const ListRemove_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListRemove\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListClear(const ListClear_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListClear\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DictInsert(const DictInsert_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DictInsert\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"key\": ");
        self().visit_expr(*x.m_key);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Expr(const Expr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Expr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"expression\": ");
        self().visit_expr(*x.m_expression);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IfExp(const IfExp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IfExp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        self().visit_expr(*x.m_body);
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        self().visit_expr(*x.m_orelse);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"re\": ");
        self().visit_expr(*x.m_re);
        s.append(",\n" + indtd);
        s.append("\"im\": ");
        self().visit_expr(*x.m_im);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"NamedExpr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FunctionCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        self().visit_symbol(*x.m_name);
        s.append(",\n" + indtd);
        s.append("\"original_name\": ");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_call_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"dt\": ");
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicElementalFunction\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"intrinsic_id\": ");
        s.append(std::to_string(x.m_intrinsic_id));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overload_id\": ");
        s.append(std::to_string(x.m_overload_id));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicArrayFunction\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arr_intrinsic_id\": ");
        s.append(std::to_string(x.m_arr_intrinsic_id));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overload_id\": ");
        s.append(std::to_string(x.m_overload_id));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicImpureFunction\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"impure_intrinsic_id\": ");
        s.append(std::to_string(x.m_impure_intrinsic_id));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overload_id\": ");
        s.append(std::to_string(x.m_overload_id));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TypeInquiry\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"inquiry_id\": ");
        s.append(std::to_string(x.m_inquiry_id));
        s.append(",\n" + indtd);
        s.append("\"arg_type\": ");
        self().visit_ttype(*x.m_arg_type);
        s.append(",\n" + indtd);
        s.append("\"arg\": ");
        if (x.m_arg) {
            self().visit_expr(*x.m_arg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructConstructor(const StructConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StructConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"dt_sym\": ");
        self().visit_symbol(*x.m_dt_sym);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_call_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumConstructor(const EnumConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"dt_sym\": ");
        self().visit_symbol(*x.m_dt_sym);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnionConstructor(const UnionConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnionConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"dt_sym\": ");
        self().visit_symbol(*x.m_dt_sym);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ImpliedDoLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"var\": ");
        self().visit_expr(*x.m_var);
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        self().visit_expr(*x.m_start);
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        self().visit_expr(*x.m_end);
        s.append(",\n" + indtd);
        s.append("\"increment\": ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"n\": ");
        s.append(std::to_string(x.m_n));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"intboz_type\": ");
        visit_integerbozType(x.m_intboz_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerBitNot\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"n\": ");
        s.append(std::to_string(x.m_n));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerBitNot\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealConstant(const RealConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"r\": ");
        s.append(std::to_string(x.m_r));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealCompare(const RealCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealCopySign\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"source\": ");
        self().visit_expr(*x.m_source);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"re\": ");
        s.append(std::to_string(x.m_re));
        s.append(",\n" + indtd);
        s.append("\"im\": ");
        s.append(std::to_string(x.m_im));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LogicalConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LogicalNot\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LogicalCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LogicalBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_logicalbinopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListConstant(const ListConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListLen(const ListLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListConcat(const ListConcat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListConcat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListCompare(const ListCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListCount(const ListCount_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListCount\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetConstant(const SetConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"elements\": ");
        s.append("[");
        if (x.n_elements > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_elements; i++) {
                self().visit_expr(*x.m_elements[i]);
                if (i < x.n_elements-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetLen(const SetLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"elements\": ");
        s.append("[");
        if (x.n_elements > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_elements; i++) {
                self().visit_expr(*x.m_elements[i]);
                if (i < x.n_elements-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleLen(const TupleLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleConcat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringConstant(const StringConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"s\": ");
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringConcat(const StringConcat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringConcat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringRepeat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringLen(const StringLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringItem(const StringItem_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringItem\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"idx\": ");
        self().visit_expr(*x.m_idx);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringSection(const StringSection_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringSection\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"step\": ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringCompare(const StringCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringContains(const StringContains_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringContains\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"substr\": ");
        self().visit_expr(*x.m_substr);
        s.append(",\n" + indtd);
        s.append("\"str\": ");
        self().visit_expr(*x.m_str);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringOrd(const StringOrd_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringOrd\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringChr(const StringChr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringChr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringFormat(const StringFormat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringFormat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"fmt\": ");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kind\": ");
        visit_string_format_kindType(x.m_kind);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringPhysicalCast(const StringPhysicalCast_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringPhysicalCast\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"old\": ");
        visit_string_physical_typeType(x.m_old);
        s.append(",\n" + indtd);
        s.append("\"new\": ");
        visit_string_physical_typeType(x.m_new);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CPtrCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolicCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DictConstant(const DictConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DictConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"keys\": ");
        s.append("[");
        if (x.n_keys > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_keys; i++) {
                self().visit_expr(*x.m_keys[i]);
                if (i < x.n_keys-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DictLen(const DictLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DictLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Var(const Var_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Var\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_symbol(*x.m_v);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FunctionParam\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"param_number\": ");
        s.append(std::to_string(x.m_param_number));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"storage_format\": ");
        visit_arraystorageType(x.m_storage_format);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"n_data\": ");
        s.append(std::to_string(x.m_n_data));
        s.append(",\n" + indtd);
        s.append("\"data\": ");
        s.append("\"Unimplementedvoid\"");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"storage_format\": ");
        visit_arraystorageType(x.m_storage_format);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayItem\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_array_index(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"storage_format\": ");
        visit_arraystorageType(x.m_storage_format);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArraySection(const ArraySection_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArraySection\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_array_index(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArraySize(const ArraySize_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArraySize\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"dim\": ");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayBound\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"dim\": ");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"bound\": ");
        visit_arrayboundType(x.m_bound);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayTranspose\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"matrix\": ");
        self().visit_expr(*x.m_matrix);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayPack\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"array\": ");
        self().visit_expr(*x.m_array);
        s.append(",\n" + indtd);
        s.append("\"mask\": ");
        self().visit_expr(*x.m_mask);
        s.append(",\n" + indtd);
        s.append("\"vector\": ");
        if (x.m_vector) {
            self().visit_expr(*x.m_vector);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayReshape\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"array\": ");
        self().visit_expr(*x.m_array);
        s.append(",\n" + indtd);
        s.append("\"shape\": ");
        self().visit_expr(*x.m_shape);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayBroadcast\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"array\": ");
        self().visit_expr(*x.m_array);
        s.append(",\n" + indtd);
        s.append("\"shape\": ");
        self().visit_expr(*x.m_shape);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_BitCast(const BitCast_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"BitCast\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"source\": ");
        self().visit_expr(*x.m_source);
        s.append(",\n" + indtd);
        s.append("\"mold\": ");
        self().visit_expr(*x.m_mold);
        s.append(",\n" + indtd);
        s.append("\"size\": ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StructInstanceMember\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StructStaticMember\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumStaticMember\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnionInstanceMember\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumName(const EnumName_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumName\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"enum_type\": ");
        self().visit_ttype(*x.m_enum_type);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumValue(const EnumValue_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumValue\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"enum_type\": ");
        self().visit_ttype(*x.m_enum_type);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"OverloadedCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        self().visit_expr(*x.m_overloaded);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"OverloadedBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        self().visit_expr(*x.m_overloaded);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"OverloadedUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        self().visit_expr(*x.m_overloaded);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"OverloadedStringConcat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        self().visit_expr(*x.m_overloaded);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Cast(const Cast_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Cast\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"kind\": ");
        visit_cast_kindType(x.m_kind);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayPhysicalCast\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"old\": ");
        visit_array_physical_typeType(x.m_old);
        s.append(",\n" + indtd);
        s.append("\"new\": ");
        visit_array_physical_typeType(x.m_new);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexRe\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexIm\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DictItem(const DictItem_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DictItem\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"key\": ");
        self().visit_expr(*x.m_key);
        s.append(",\n" + indtd);
        s.append("\"default\": ");
        if (x.m_default) {
            self().visit_expr(*x.m_default);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CLoc(const CLoc_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CLoc\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"PointerToCPtr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GetPointer(const GetPointer_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GetPointer\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListItem(const ListItem_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListItem\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"pos\": ");
        self().visit_expr(*x.m_pos);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleItem(const TupleItem_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleItem\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"pos\": ");
        self().visit_expr(*x.m_pos);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListSection(const ListSection_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListSection\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"section\": ");
        self().visit_array_index(x.m_section);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListRepeat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DictPop(const DictPop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DictPop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"key\": ");
        self().visit_expr(*x.m_key);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetPop(const SetPop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetPop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerBitLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Ichar(const Ichar_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Ichar\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Iachar(const Iachar_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Iachar\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SizeOfType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_ttype(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"PointerNullConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"PointerAssociated\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"ptr\": ");
        self().visit_expr(*x.m_ptr);
        s.append(",\n" + indtd);
        s.append("\"tgt\": ");
        if (x.m_tgt) {
            self().visit_expr(*x.m_tgt);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealSqrt\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Integer(const Integer_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Integer\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"kind\": ");
        s.append(std::to_string(x.m_kind));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedInteger\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"kind\": ");
        s.append(std::to_string(x.m_kind));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Real\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"kind\": ");
        s.append(std::to_string(x.m_kind));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Complex\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"kind\": ");
        s.append(std::to_string(x.m_kind));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_String(const String_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"String\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"kind\": ");
        s.append(std::to_string(x.m_kind));
        s.append(",\n" + indtd);
        s.append("\"len\": ");
        s.append(std::to_string(x.m_len));
        s.append(",\n" + indtd);
        s.append("\"len_expr\": ");
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"physical_type\": ");
        visit_string_physical_typeType(x.m_physical_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Logical(const Logical_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Logical\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"kind\": ");
        s.append(std::to_string(x.m_kind));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Set\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_List(const List_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"List\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Tuple(const Tuple_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Tuple\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        s.append("[");
        if (x.n_type > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_type; i++) {
                self().visit_ttype(*x.m_type[i]);
                if (i < x.n_type-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructType(const StructType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StructType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"derived_type\": ");
        self().visit_symbol(*x.m_derived_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumType(const EnumType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"enum_type\": ");
        self().visit_symbol(*x.m_enum_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnionType(const UnionType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnionType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"union_type\": ");
        self().visit_symbol(*x.m_union_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassType(const ClassType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ClassType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"class_type\": ");
        self().visit_symbol(*x.m_class_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Dict(const Dict_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Dict\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"key_type\": ");
        self().visit_ttype(*x.m_key_type);
        s.append(",\n" + indtd);
        s.append("\"value_type\": ");
        self().visit_ttype(*x.m_value_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Pointer(const Pointer_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Pointer\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Allocatable(const Allocatable_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Allocatable\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CPtr(const CPtr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CPtr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolicExpression\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TypeParameter\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"param\": ");
        s.append("\"" + std::string(x.m_param) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Array\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"dims\": ");
        s.append("[");
        if (x.n_dims > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dims; i++) {
                self().visit_dimension(x.m_dims[i]);
                if (i < x.n_dims-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"physical_type\": ");
        visit_array_physical_typeType(x.m_physical_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FunctionType(const FunctionType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FunctionType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg_types\": ");
        s.append("[");
        if (x.n_arg_types > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_arg_types; i++) {
                self().visit_ttype(*x.m_arg_types[i]);
                if (i < x.n_arg_types-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"return_var_type\": ");
        if (x.m_return_var_type) {
            self().visit_ttype(*x.m_return_var_type);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"deftype\": ");
        visit_deftypeType(x.m_deftype);
        s.append(",\n" + indtd);
        s.append("\"bindc_name\": ");
        if (x.m_bindc_name) {
            s.append("\"" + str_escape_c(x.m_bindc_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"elemental\": ");
        if (x.m_elemental) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"pure\": ");
        if (x.m_pure) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"module\": ");
        if (x.m_module) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"inline\": ");
        if (x.m_inline) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"static\": ");
        if (x.m_static) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"restrictions\": ");
        s.append("[");
        if (x.n_restrictions > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_restrictions; i++) {
                self().visit_symbol(*x.m_restrictions[i]);
                if (i < x.n_restrictions-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"is_restriction\": ");
        if (x.m_is_restriction) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_cast_kindType(const cast_kindType &x) {
        switch (x) {
            case (cast_kindType::RealToInteger) : {
                s.append("\"RealToInteger\"");
             break; }
            case (cast_kindType::IntegerToReal) : {
                s.append("\"IntegerToReal\"");
             break; }
            case (cast_kindType::LogicalToReal) : {
                s.append("\"LogicalToReal\"");
             break; }
            case (cast_kindType::RealToReal) : {
                s.append("\"RealToReal\"");
             break; }
            case (cast_kindType::IntegerToInteger) : {
                s.append("\"IntegerToInteger\"");
             break; }
            case (cast_kindType::RealToComplex) : {
                s.append("\"RealToComplex\"");
             break; }
            case (cast_kindType::IntegerToComplex) : {
                s.append("\"IntegerToComplex\"");
             break; }
            case (cast_kindType::IntegerToLogical) : {
                s.append("\"IntegerToLogical\"");
             break; }
            case (cast_kindType::RealToLogical) : {
                s.append("\"RealToLogical\"");
             break; }
            case (cast_kindType::StringToLogical) : {
                s.append("\"StringToLogical\"");
             break; }
            case (cast_kindType::StringToInteger) : {
                s.append("\"StringToInteger\"");
             break; }
            case (cast_kindType::StringToList) : {
                s.append("\"StringToList\"");
             break; }
            case (cast_kindType::ComplexToLogical) : {
                s.append("\"ComplexToLogical\"");
             break; }
            case (cast_kindType::ComplexToComplex) : {
                s.append("\"ComplexToComplex\"");
             break; }
            case (cast_kindType::ComplexToReal) : {
                s.append("\"ComplexToReal\"");
             break; }
            case (cast_kindType::ComplexToInteger) : {
                s.append("\"ComplexToInteger\"");
             break; }
            case (cast_kindType::LogicalToInteger) : {
                s.append("\"LogicalToInteger\"");
             break; }
            case (cast_kindType::RealToString) : {
                s.append("\"RealToString\"");
             break; }
            case (cast_kindType::IntegerToString) : {
                s.append("\"IntegerToString\"");
             break; }
            case (cast_kindType::LogicalToString) : {
                s.append("\"LogicalToString\"");
             break; }
            case (cast_kindType::UnsignedIntegerToInteger) : {
                s.append("\"UnsignedIntegerToInteger\"");
             break; }
            case (cast_kindType::UnsignedIntegerToUnsignedInteger) : {
                s.append("\"UnsignedIntegerToUnsignedInteger\"");
             break; }
            case (cast_kindType::UnsignedIntegerToReal) : {
                s.append("\"UnsignedIntegerToReal\"");
             break; }
            case (cast_kindType::UnsignedIntegerToLogical) : {
                s.append("\"UnsignedIntegerToLogical\"");
             break; }
            case (cast_kindType::IntegerToUnsignedInteger) : {
                s.append("\"IntegerToUnsignedInteger\"");
             break; }
            case (cast_kindType::RealToUnsignedInteger) : {
                s.append("\"RealToUnsignedInteger\"");
             break; }
            case (cast_kindType::CPtrToUnsignedInteger) : {
                s.append("\"CPtrToUnsignedInteger\"");
             break; }
            case (cast_kindType::UnsignedIntegerToCPtr) : {
                s.append("\"UnsignedIntegerToCPtr\"");
             break; }
            case (cast_kindType::IntegerToSymbolicExpression) : {
                s.append("\"IntegerToSymbolicExpression\"");
             break; }
            case (cast_kindType::ListToArray) : {
                s.append("\"ListToArray\"");
             break; }
        }
    }
    void visit_storage_typeType(const storage_typeType &x) {
        switch (x) {
            case (storage_typeType::Default) : {
                s.append("\"Default\"");
             break; }
            case (storage_typeType::Save) : {
                s.append("\"Save\"");
             break; }
            case (storage_typeType::Parameter) : {
                s.append("\"Parameter\"");
             break; }
        }
    }
    void visit_accessType(const accessType &x) {
        switch (x) {
            case (accessType::Public) : {
                s.append("\"Public\"");
             break; }
            case (accessType::Private) : {
                s.append("\"Private\"");
             break; }
        }
    }
    void visit_intentType(const intentType &x) {
        switch (x) {
            case (intentType::Local) : {
                s.append("\"Local\"");
             break; }
            case (intentType::In) : {
                s.append("\"In\"");
             break; }
            case (intentType::Out) : {
                s.append("\"Out\"");
             break; }
            case (intentType::InOut) : {
                s.append("\"InOut\"");
             break; }
            case (intentType::ReturnVar) : {
                s.append("\"ReturnVar\"");
             break; }
            case (intentType::Unspecified) : {
                s.append("\"Unspecified\"");
             break; }
        }
    }
    void visit_deftypeType(const deftypeType &x) {
        switch (x) {
            case (deftypeType::Implementation) : {
                s.append("\"Implementation\"");
             break; }
            case (deftypeType::Interface) : {
                s.append("\"Interface\"");
             break; }
        }
    }
    void visit_presenceType(const presenceType &x) {
        switch (x) {
            case (presenceType::Required) : {
                s.append("\"Required\"");
             break; }
            case (presenceType::Optional) : {
                s.append("\"Optional\"");
             break; }
        }
    }
    void visit_abiType(const abiType &x) {
        switch (x) {
            case (abiType::Source) : {
                s.append("\"Source\"");
             break; }
            case (abiType::LFortranModule) : {
                s.append("\"LFortranModule\"");
             break; }
            case (abiType::GFortranModule) : {
                s.append("\"GFortranModule\"");
             break; }
            case (abiType::BindC) : {
                s.append("\"BindC\"");
             break; }
            case (abiType::BindPython) : {
                s.append("\"BindPython\"");
             break; }
            case (abiType::BindJS) : {
                s.append("\"BindJS\"");
             break; }
            case (abiType::Interactive) : {
                s.append("\"Interactive\"");
             break; }
            case (abiType::Intrinsic) : {
                s.append("\"Intrinsic\"");
             break; }
        }
    }
    void visit_dimension(const dimension_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"dimension\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"length\": ");
        if (x.m_length) {
            self().visit_expr(*x.m_length);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"alloc_arg\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"dims\": ");
        s.append("[");
        if (x.n_dims > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dims; i++) {
                self().visit_dimension(x.m_dims[i]);
                if (i < x.n_dims-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"len_expr\": ");
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Attribute(const Attribute_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Attribute\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_attribute_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"attribute_arg\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        s.append("\"" + std::string(x.m_arg) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"call_arg\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_reduction_expr(const reduction_expr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"reduction_expr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"op\": ");
        visit_reduction_opType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Bind(const Bind_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Bind\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"lang\": ");
        s.append("\"" + str_escape_c(x.m_lang) + "\"");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + str_escape_c(x.m_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"array_index\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        if (x.m_left) {
            self().visit_expr(*x.m_left);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        if (x.m_right) {
            self().visit_expr(*x.m_right);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"step\": ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"do_loop_head\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        if (x.m_v) {
            self().visit_expr(*x.m_v);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"increment\": ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.loc.first, x.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CaseStmt\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        s.append("[");
        if (x.n_test > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_test; i++) {
                self().visit_expr(*x.m_test[i]);
                if (i < x.n_test-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"fall_through\": ");
        if (x.m_fall_through) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CaseStmt_Range\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TypeStmtName\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"sym\": ");
        self().visit_symbol(*x.m_sym);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ClassStmt\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"sym\": ");
        self().visit_symbol(*x.m_sym);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TypeStmtType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_enumtypeType(const enumtypeType &x) {
        switch (x) {
            case (enumtypeType::IntegerConsecutiveFromZero) : {
                s.append("\"IntegerConsecutiveFromZero\"");
             break; }
            case (enumtypeType::IntegerUnique) : {
                s.append("\"IntegerUnique\"");
             break; }
            case (enumtypeType::IntegerNotUnique) : {
                s.append("\"IntegerNotUnique\"");
             break; }
            case (enumtypeType::NonInteger) : {
                s.append("\"NonInteger\"");
             break; }
        }
    }
    void visit_Require(const Require_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Require\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                s.append("\"" + std::string(x.m_args[i]) + "\"");
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_physical_typeType(const array_physical_typeType &x) {
        switch (x) {
            case (array_physical_typeType::DescriptorArray) : {
                s.append("\"DescriptorArray\"");
             break; }
            case (array_physical_typeType::PointerToDataArray) : {
                s.append("\"PointerToDataArray\"");
             break; }
            case (array_physical_typeType::UnboundedPointerToDataArray) : {
                s.append("\"UnboundedPointerToDataArray\"");
             break; }
            case (array_physical_typeType::FixedSizeArray) : {
                s.append("\"FixedSizeArray\"");
             break; }
            case (array_physical_typeType::StringArraySinglePointer) : {
                s.append("\"StringArraySinglePointer\"");
             break; }
            case (array_physical_typeType::NumPyArray) : {
                s.append("\"NumPyArray\"");
             break; }
            case (array_physical_typeType::ISODescriptorArray) : {
                s.append("\"ISODescriptorArray\"");
             break; }
            case (array_physical_typeType::SIMDArray) : {
                s.append("\"SIMDArray\"");
             break; }
        }
    }
    void visit_string_physical_typeType(const string_physical_typeType &x) {
        switch (x) {
            case (string_physical_typeType::PointerString) : {
                s.append("\"PointerString\"");
             break; }
            case (string_physical_typeType::DescriptorString) : {
                s.append("\"DescriptorString\"");
             break; }
        }
    }
    void visit_binopType(const binopType &x) {
        switch (x) {
            case (binopType::Add) : {
                s.append("\"Add\"");
             break; }
            case (binopType::Sub) : {
                s.append("\"Sub\"");
             break; }
            case (binopType::Mul) : {
                s.append("\"Mul\"");
             break; }
            case (binopType::Div) : {
                s.append("\"Div\"");
             break; }
            case (binopType::Pow) : {
                s.append("\"Pow\"");
             break; }
            case (binopType::BitAnd) : {
                s.append("\"BitAnd\"");
             break; }
            case (binopType::BitOr) : {
                s.append("\"BitOr\"");
             break; }
            case (binopType::BitXor) : {
                s.append("\"BitXor\"");
             break; }
            case (binopType::BitLShift) : {
                s.append("\"BitLShift\"");
             break; }
            case (binopType::BitRShift) : {
                s.append("\"BitRShift\"");
             break; }
        }
    }
    void visit_reduction_opType(const reduction_opType &x) {
        switch (x) {
            case (reduction_opType::ReduceAdd) : {
                s.append("\"ReduceAdd\"");
             break; }
            case (reduction_opType::ReduceSub) : {
                s.append("\"ReduceSub\"");
             break; }
            case (reduction_opType::ReduceMul) : {
                s.append("\"ReduceMul\"");
             break; }
            case (reduction_opType::ReduceMIN) : {
                s.append("\"ReduceMIN\"");
             break; }
            case (reduction_opType::ReduceMAX) : {
                s.append("\"ReduceMAX\"");
             break; }
        }
    }
    void visit_logicalbinopType(const logicalbinopType &x) {
        switch (x) {
            case (logicalbinopType::And) : {
                s.append("\"And\"");
             break; }
            case (logicalbinopType::Or) : {
                s.append("\"Or\"");
             break; }
            case (logicalbinopType::Xor) : {
                s.append("\"Xor\"");
             break; }
            case (logicalbinopType::NEqv) : {
                s.append("\"NEqv\"");
             break; }
            case (logicalbinopType::Eqv) : {
                s.append("\"Eqv\"");
             break; }
        }
    }
    void visit_cmpopType(const cmpopType &x) {
        switch (x) {
            case (cmpopType::Eq) : {
                s.append("\"Eq\"");
             break; }
            case (cmpopType::NotEq) : {
                s.append("\"NotEq\"");
             break; }
            case (cmpopType::Lt) : {
                s.append("\"Lt\"");
             break; }
            case (cmpopType::LtE) : {
                s.append("\"LtE\"");
             break; }
            case (cmpopType::Gt) : {
                s.append("\"Gt\"");
             break; }
            case (cmpopType::GtE) : {
                s.append("\"GtE\"");
             break; }
        }
    }
    void visit_integerbozType(const integerbozType &x) {
        switch (x) {
            case (integerbozType::Binary) : {
                s.append("\"Binary\"");
             break; }
            case (integerbozType::Hex) : {
                s.append("\"Hex\"");
             break; }
            case (integerbozType::Octal) : {
                s.append("\"Octal\"");
             break; }
            case (integerbozType::Decimal) : {
                s.append("\"Decimal\"");
             break; }
        }
    }
    void visit_arrayboundType(const arrayboundType &x) {
        switch (x) {
            case (arrayboundType::LBound) : {
                s.append("\"LBound\"");
             break; }
            case (arrayboundType::UBound) : {
                s.append("\"UBound\"");
             break; }
        }
    }
    void visit_arraystorageType(const arraystorageType &x) {
        switch (x) {
            case (arraystorageType::RowMajor) : {
                s.append("\"RowMajor\"");
             break; }
            case (arraystorageType::ColMajor) : {
                s.append("\"ColMajor\"");
             break; }
        }
    }
    void visit_string_format_kindType(const string_format_kindType &x) {
        switch (x) {
            case (string_format_kindType::FormatFortran) : {
                s.append("\"FormatFortran\"");
             break; }
            case (string_format_kindType::FormatC) : {
                s.append("\"FormatC\"");
             break; }
            case (string_format_kindType::FormatPythonPercent) : {
                s.append("\"FormatPythonPercent\"");
             break; }
            case (string_format_kindType::FormatPythonFString) : {
                s.append("\"FormatPythonFString\"");
             break; }
            case (string_format_kindType::FormatPythonFormat) : {
                s.append("\"FormatPythonFormat\"");
             break; }
        }
    }
};


}
