/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-develop.

Abstract: This is an autogenerated C++ header file in order to allow easy
development of the 3MF Library. The implementer of the 3MF Library needs to
derive concrete classes from the abstract classes in this header.

Interface version: 2.3.0

*/


#ifndef __LIB3MF_CPPINTERFACES
#define __LIB3MF_CPPINTERFACES

#include <string>
#include <memory>

#include "lib3mf_types.hpp"



namespace Lib3MF {
namespace Impl {

/**
 Forward declarations of class interfaces
*/
class IBase;
class IWriter;
class IReader;
class IPackagePart;
class IResource;
class IResourceIterator;
class ISliceStackIterator;
class IObjectIterator;
class IMeshObjectIterator;
class IComponentsObjectIterator;
class ITexture2DIterator;
class IBaseMaterialGroupIterator;
class IColorGroupIterator;
class ITexture2DGroupIterator;
class ICompositeMaterialsIterator;
class IMultiPropertyGroupIterator;
class IMetaData;
class IMetaDataGroup;
class IObject;
class IMeshObject;
class IBeamLattice;
class IComponent;
class IComponentsObject;
class IBeamSet;
class IBaseMaterialGroup;
class IColorGroup;
class ITexture2DGroup;
class ICompositeMaterials;
class IMultiPropertyGroup;
class IAttachment;
class ITexture2D;
class IBuildItem;
class IBuildItemIterator;
class ISlice;
class ISliceStack;
class IConsumer;
class IAccessRight;
class IContentEncryptionParams;
class IResourceData;
class IResourceDataGroup;
class IKeyStore;
class IModel;



/*************************************************************************************************************************
 Parameter Cache definitions
**************************************************************************************************************************/

class ParameterCache {
	public:
		virtual ~ParameterCache() {}
};

template <class T1> class ParameterCache_1 : public ParameterCache {
	private:
		T1 m_param1;
	public:
		ParameterCache_1 (const T1 & param1)
			: m_param1 (param1)
		{
		}

		void retrieveData (T1 & param1)
		{
			param1 = m_param1;
		}
};

template <class T1, class T2> class ParameterCache_2 : public ParameterCache {
	private:
		T1 m_param1;
		T2 m_param2;
	public:
		ParameterCache_2 (const T1 & param1, const T2 & param2)
			: m_param1 (param1), m_param2 (param2)
		{
		}

		void retrieveData (T1 & param1, T2 & param2)
		{
			param1 = m_param1;
			param2 = m_param2;
		}
};

template <class T1, class T2, class T3> class ParameterCache_3 : public ParameterCache {
	private:
		T1 m_param1;
		T2 m_param2;
		T3 m_param3;
	public:
		ParameterCache_3 (const T1 & param1, const T2 & param2, const T3 & param3)
			: m_param1 (param1), m_param2 (param2), m_param3 (param3)
		{
		}

		void retrieveData (T1 & param1, T2 & param2, T3 & param3)
		{
			param1 = m_param1;
			param2 = m_param2;
			param3 = m_param3;
		}
};

template <class T1, class T2, class T3, class T4> class ParameterCache_4 : public ParameterCache {
	private:
		T1 m_param1;
		T2 m_param2;
		T3 m_param3;
		T4 m_param4;
	public:
		ParameterCache_4 (const T1 & param1, const T2 & param2, const T3 & param3, const T4 & param4)
			: m_param1 (param1), m_param2 (param2), m_param3 (param3), m_param4 (param4)
		{
		}

		void retrieveData (T1 & param1, T2 & param2, T3 & param3, T4 & param4)
		{
			param1 = m_param1;
			param2 = m_param2;
			param3 = m_param3;
			param4 = m_param4;
		}
};


/*************************************************************************************************************************
 Class interface for Base 
**************************************************************************************************************************/

class IBase {
private:
	std::unique_ptr<ParameterCache> m_ParameterCache;
public:
	/**
	* IBase::~IBase - virtual destructor of IBase
	*/
	virtual ~IBase() {};

	/**
	* IBase::ReleaseBaseClassInterface - Releases ownership of a base class interface. Deletes the reference, if necessary.
	* @param[in] pIBase - The base class instance to release
	*/
	static void ReleaseBaseClassInterface(IBase* pIBase)
	{
		if (pIBase) {
			pIBase->DecRefCount();
		}
	};

	/**
	* IBase::AcquireBaseClassInterface - Acquires shared ownership of a base class interface.
	* @param[in] pIBase - The base class instance to acquire
	*/
	static void AcquireBaseClassInterface(IBase* pIBase)
	{
		if (pIBase) {
			pIBase->IncRefCount();
		}
	};


	/**
	* IBase::GetLastErrorMessage - Returns the last error registered of this class instance
	* @param[out] sErrorMessage - Message of the last error registered
	* @return Has an error been registered already
	*/
	virtual bool GetLastErrorMessage(std::string & sErrorMessage) = 0;

	/**
	* IBase::ClearErrorMessages - Clears all registered messages of this class instance
	*/
	virtual void ClearErrorMessages() = 0;

	/**
	* IBase::RegisterErrorMessage - Registers an error message with this class instance
	* @param[in] sErrorMessage - Error message to register
	*/
	virtual void RegisterErrorMessage(const std::string & sErrorMessage) = 0;

	/**
	* IBase::IncRefCount - Increases the reference count of a class instance
	*/
	virtual void IncRefCount() = 0;

	/**
	* IBase::DecRefCount - Decreases the reference count of a class instance and free releases it, if the last reference has been removed
	* @return Has the object been released
	*/
	virtual bool DecRefCount() = 0;

	/**
	* IBase::_setCache - set parameter cache of object
	*/
	void _setCache(ParameterCache * pCache)
	{
		m_ParameterCache.reset(pCache);
	}

	/**
	* IBase::_getCache - returns parameter cache of object
	*/
	ParameterCache* _getCache()
	{
		return m_ParameterCache.get();
	}

	/**
	* IBase::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	virtual Lib3MF_uint64 ClassTypeId() = 0;
};


/**
 Definition of a shared pointer class for IBase
*/
template<class T>
class IBaseSharedPtr : public std::shared_ptr<T>
{
public:
	explicit IBaseSharedPtr(T* t = nullptr)
		: std::shared_ptr<T>(t, IBase::ReleaseBaseClassInterface)
	{
		t->IncRefCount();
	}

	// Reset function, as it also needs to properly set the deleter.
	void reset(T* t = nullptr)
	{
		std::shared_ptr<T>::reset(t, IBase::ReleaseBaseClassInterface);
	}

	// Get-function that increases the Base class's reference count
	T* getCoOwningPtr()
	{
		T* t = this->get();
		t->IncRefCount();
		return t;
	}
};


typedef IBaseSharedPtr<IBase> PIBase;


/*************************************************************************************************************************
 Class interface for Writer 
**************************************************************************************************************************/

class IWriter : public virtual IBase {
public:
	/**
	* IWriter::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE76F642F363FD7E9UL; // First 64 bits of SHA1 of a string: "Lib3MF::Writer"
	}

	/**
	* IWriter::WriteToFile - Writes out the model as file. The file type is specified by the Model Writer class.
	* @param[in] sFilename - Filename to write into
	*/
	virtual void WriteToFile(const std::string & sFilename) = 0;

	/**
	* IWriter::GetStreamSize - Retrieves the size of the full 3MF file stream.
	* @return the stream size
	*/
	virtual Lib3MF_uint64 GetStreamSize() = 0;

	/**
	* IWriter::WriteToBuffer - Writes out the 3MF file into a memory buffer
	* @param[in] nBufferBufferSize - Number of elements in buffer
	* @param[out] pBufferNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBufferBuffer - uint8 buffer of buffer to write into
	*/
	virtual void WriteToBuffer(Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer) = 0;

	/**
	* IWriter::WriteToCallback - Writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
	* @param[in] pTheWriteCallback - callback function
	* @param[in] pTheSeekCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void WriteToCallback(const Lib3MF::WriteCallback pTheWriteCallback, const Lib3MF::SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IWriter::SetProgressCallback - Set the progress callback for calls to this writer
	* @param[in] pProgressCallback - callback function
	* @param[in] nUserData - pointer to arbitrary user data that is passed without modification to the callback.
	*/
	virtual void SetProgressCallback(const Lib3MF::ProgressCallback pProgressCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IWriter::GetDecimalPrecision - Returns the number of digits after the decimal point to be written in each vertex coordinate-value.
	* @return The number of digits to be written in each vertex coordinate-value after the decimal point.
	*/
	virtual Lib3MF_uint32 GetDecimalPrecision() = 0;

	/**
	* IWriter::SetDecimalPrecision - Sets the number of digits after the decimal point to be written in each vertex coordinate-value.
	* @param[in] nDecimalPrecision - The number of digits to be written in each vertex coordinate-value after the decimal point.
	*/
	virtual void SetDecimalPrecision(const Lib3MF_uint32 nDecimalPrecision) = 0;

	/**
	* IWriter::SetStrictModeActive - Activates (deactivates) the strict mode of the reader.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	*/
	virtual void SetStrictModeActive(const bool bStrictModeActive) = 0;

	/**
	* IWriter::GetStrictModeActive - Queries whether the strict mode of the reader is active or not
	* @return returns flag whether strict mode is active or not.
	*/
	virtual bool GetStrictModeActive() = 0;

	/**
	* IWriter::GetWarning - Returns Warning and Error Information of the read process
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @param[out] nErrorCode - filled with the error code of the warning
	* @return the message of the warning
	*/
	virtual std::string GetWarning(const Lib3MF_uint32 nIndex, Lib3MF_uint32 & nErrorCode) = 0;

	/**
	* IWriter::GetWarningCount - Returns Warning and Error Count of the read process
	* @return filled with the count of the occurred warnings.
	*/
	virtual Lib3MF_uint32 GetWarningCount() = 0;

	/**
	* IWriter::AddKeyWrappingCallback - Registers a callback to deal with data key encryption/decryption from keystore
	* @param[in] sConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void AddKeyWrappingCallback(const std::string & sConsumerID, const Lib3MF::KeyWrappingCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IWriter::SetContentEncryptionCallback - Registers a callback to deal with encryption of content
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void SetContentEncryptionCallback(const Lib3MF::ContentEncryptionCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

};

typedef IBaseSharedPtr<IWriter> PIWriter;


/*************************************************************************************************************************
 Class interface for Reader 
**************************************************************************************************************************/

class IReader : public virtual IBase {
public:
	/**
	* IReader::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x2D86831DA59FBE72UL; // First 64 bits of SHA1 of a string: "Lib3MF::Reader"
	}

	/**
	* IReader::ReadFromFile - Reads a model from a file. The file type is specified by the Model Reader class
	* @param[in] sFilename - Filename to read from
	*/
	virtual void ReadFromFile(const std::string & sFilename) = 0;

	/**
	* IReader::ReadFromBuffer - Reads a model from a memory buffer.
	* @param[in] nBufferBufferSize - Number of elements in buffer
	* @param[in] pBufferBuffer - Buffer to read from
	*/
	virtual void ReadFromBuffer(const Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer) = 0;

	/**
	* IReader::ReadFromCallback - Reads a model and from the data provided by a callback function
	* @param[in] pTheReadCallback - callback function
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void ReadFromCallback(const Lib3MF::ReadCallback pTheReadCallback, const Lib3MF_uint64 nStreamSize, const Lib3MF::SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IReader::SetProgressCallback - Set the progress callback for calls to this writer
	* @param[in] pProgressCallback - callback function
	* @param[in] nUserData - pointer to arbitrary user data that is passed without modification to the callback.
	*/
	virtual void SetProgressCallback(const Lib3MF::ProgressCallback pProgressCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IReader::AddRelationToRead - Adds a relationship type which shall be read as attachment in memory while loading
	* @param[in] sRelationShipType - String of the relationship type
	*/
	virtual void AddRelationToRead(const std::string & sRelationShipType) = 0;

	/**
	* IReader::RemoveRelationToRead - Removes a relationship type which shall be read as attachment in memory while loading
	* @param[in] sRelationShipType - String of the relationship type
	*/
	virtual void RemoveRelationToRead(const std::string & sRelationShipType) = 0;

	/**
	* IReader::SetStrictModeActive - Activates (deactivates) the strict mode of the reader.
	* @param[in] bStrictModeActive - flag whether strict mode is active or not.
	*/
	virtual void SetStrictModeActive(const bool bStrictModeActive) = 0;

	/**
	* IReader::GetStrictModeActive - Queries whether the strict mode of the reader is active or not
	* @return returns flag whether strict mode is active or not.
	*/
	virtual bool GetStrictModeActive() = 0;

	/**
	* IReader::GetWarning - Returns Warning and Error Information of the read process
	* @param[in] nIndex - Index of the Warning. Valid values are 0 to WarningCount - 1
	* @param[out] nErrorCode - filled with the error code of the warning
	* @return the message of the warning
	*/
	virtual std::string GetWarning(const Lib3MF_uint32 nIndex, Lib3MF_uint32 & nErrorCode) = 0;

	/**
	* IReader::GetWarningCount - Returns Warning and Error Count of the read process
	* @return filled with the count of the occurred warnings.
	*/
	virtual Lib3MF_uint32 GetWarningCount() = 0;

	/**
	* IReader::AddKeyWrappingCallback - Registers a callback to deal with key wrapping mechanism from keystore
	* @param[in] sConsumerID - The ConsumerID to register for
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void AddKeyWrappingCallback(const std::string & sConsumerID, const Lib3MF::KeyWrappingCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IReader::SetContentEncryptionCallback - Registers a callback to deal with encryption of content
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void SetContentEncryptionCallback(const Lib3MF::ContentEncryptionCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

};

typedef IBaseSharedPtr<IReader> PIReader;


/*************************************************************************************************************************
 Class interface for PackagePart 
**************************************************************************************************************************/

class IPackagePart : public virtual IBase {
public:
	/**
	* IPackagePart::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE55A826D377483EUL; // First 64 bits of SHA1 of a string: "Lib3MF::PackagePart"
	}

	/**
	* IPackagePart::GetPath - Returns the absolute path of this PackagePart.
	* @return Returns the absolute path of this PackagePart
	*/
	virtual std::string GetPath() = 0;

	/**
	* IPackagePart::SetPath - Sets the absolute path of this PackagePart.
	* @param[in] sPath - Sets the absolute path of this PackagePart.
	*/
	virtual void SetPath(const std::string & sPath) = 0;

};

typedef IBaseSharedPtr<IPackagePart> PIPackagePart;


/*************************************************************************************************************************
 Class interface for Resource 
**************************************************************************************************************************/

class IResource : public virtual IBase {
public:
	/**
	* IResource::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xDFE3889D1B269CBBUL; // First 64 bits of SHA1 of a string: "Lib3MF::Resource"
	}

	/**
	* IResource::GetResourceID - Retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID
	* @return Retrieves the unique id of this resource within a package.
	*/
	virtual Lib3MF_uint32 GetResourceID() = 0;

	/**
	* IResource::GetUniqueResourceID - Retrieves the unique id of this resource within a package.
	* @return Retrieves the unique id of this resource within a package.
	*/
	virtual Lib3MF_uint32 GetUniqueResourceID() = 0;

	/**
	* IResource::PackagePart - Returns the PackagePart within which this resource resides
	* @return the PackagePart within which this resource resides.
	*/
	virtual IPackagePart * PackagePart() = 0;

	/**
	* IResource::SetPackagePart - Sets the new PackagePart within which this resource resides
	* @param[in] pPackagePart - the new PackagePart within which this resource resides.
	*/
	virtual void SetPackagePart(IPackagePart* pPackagePart) = 0;

	/**
	* IResource::GetModelResourceID - Retrieves the id of this resource within a model.
	* @return Retrieves the id of this resource within a model.
	*/
	virtual Lib3MF_uint32 GetModelResourceID() = 0;

};

typedef IBaseSharedPtr<IResource> PIResource;


/*************************************************************************************************************************
 Class interface for ResourceIterator 
**************************************************************************************************************************/

class IResourceIterator : public virtual IBase {
public:
	/**
	* IResourceIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x460F3515E2621DBEUL; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceIterator"
	}

	/**
	* IResourceIterator::MoveNext - Iterates to the next resource in the list.
	* @return Iterates to the next resource in the list.
	*/
	virtual bool MoveNext() = 0;

	/**
	* IResourceIterator::MovePrevious - Iterates to the previous resource in the list.
	* @return Iterates to the previous resource in the list.
	*/
	virtual bool MovePrevious() = 0;

	/**
	* IResourceIterator::GetCurrent - Returns the resource the iterator points at.
	* @return returns the resource instance.
	*/
	virtual IResource * GetCurrent() = 0;

	/**
	* IResourceIterator::Clone - Creates a new resource iterator with the same resource list.
	* @return returns the cloned Iterator instance
	*/
	virtual IResourceIterator * Clone() = 0;

	/**
	* IResourceIterator::Count - Returns the number of resoucres the iterator captures.
	* @return returns the number of resoucres the iterator captures.
	*/
	virtual Lib3MF_uint64 Count() = 0;

};

typedef IBaseSharedPtr<IResourceIterator> PIResourceIterator;


/*************************************************************************************************************************
 Class interface for SliceStackIterator 
**************************************************************************************************************************/

class ISliceStackIterator : public virtual IResourceIterator {
public:
	/**
	* ISliceStackIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x69684DB99FA813F6UL; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStackIterator"
	}

	/**
	* ISliceStackIterator::GetCurrentSliceStack - Returns the SliceStack the iterator points at.
	* @return returns the SliceStack instance.
	*/
	virtual ISliceStack * GetCurrentSliceStack() = 0;

};

typedef IBaseSharedPtr<ISliceStackIterator> PISliceStackIterator;


/*************************************************************************************************************************
 Class interface for ObjectIterator 
**************************************************************************************************************************/

class IObjectIterator : public virtual IResourceIterator {
public:
	/**
	* IObjectIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xDE92510BD2112288UL; // First 64 bits of SHA1 of a string: "Lib3MF::ObjectIterator"
	}

	/**
	* IObjectIterator::GetCurrentObject - Returns the Object the iterator points at.
	* @return returns the Object instance.
	*/
	virtual IObject * GetCurrentObject() = 0;

};

typedef IBaseSharedPtr<IObjectIterator> PIObjectIterator;


/*************************************************************************************************************************
 Class interface for MeshObjectIterator 
**************************************************************************************************************************/

class IMeshObjectIterator : public virtual IResourceIterator {
public:
	/**
	* IMeshObjectIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xF4196034E2B9FDE6UL; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObjectIterator"
	}

	/**
	* IMeshObjectIterator::GetCurrentMeshObject - Returns the MeshObject the iterator points at.
	* @return returns the MeshObject instance.
	*/
	virtual IMeshObject * GetCurrentMeshObject() = 0;

};

typedef IBaseSharedPtr<IMeshObjectIterator> PIMeshObjectIterator;


/*************************************************************************************************************************
 Class interface for ComponentsObjectIterator 
**************************************************************************************************************************/

class IComponentsObjectIterator : public virtual IResourceIterator {
public:
	/**
	* IComponentsObjectIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x564DE4217ED7614AUL; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObjectIterator"
	}

	/**
	* IComponentsObjectIterator::GetCurrentComponentsObject - Returns the ComponentsObject the iterator points at.
	* @return returns the ComponentsObject instance.
	*/
	virtual IComponentsObject * GetCurrentComponentsObject() = 0;

};

typedef IBaseSharedPtr<IComponentsObjectIterator> PIComponentsObjectIterator;


/*************************************************************************************************************************
 Class interface for Texture2DIterator 
**************************************************************************************************************************/

class ITexture2DIterator : public virtual IResourceIterator {
public:
	/**
	* ITexture2DIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x4BD32B4870FFC03BUL; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DIterator"
	}

	/**
	* ITexture2DIterator::GetCurrentTexture2D - Returns the Texture2D the iterator points at.
	* @return returns the Texture2D instance.
	*/
	virtual ITexture2D * GetCurrentTexture2D() = 0;

};

typedef IBaseSharedPtr<ITexture2DIterator> PITexture2DIterator;


/*************************************************************************************************************************
 Class interface for BaseMaterialGroupIterator 
**************************************************************************************************************************/

class IBaseMaterialGroupIterator : public virtual IResourceIterator {
public:
	/**
	* IBaseMaterialGroupIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x65E6EDD9362C79CBUL; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroupIterator"
	}

	/**
	* IBaseMaterialGroupIterator::GetCurrentBaseMaterialGroup - Returns the MaterialGroup the iterator points at.
	* @return returns the BaseMaterialGroup instance.
	*/
	virtual IBaseMaterialGroup * GetCurrentBaseMaterialGroup() = 0;

};

typedef IBaseSharedPtr<IBaseMaterialGroupIterator> PIBaseMaterialGroupIterator;


/*************************************************************************************************************************
 Class interface for ColorGroupIterator 
**************************************************************************************************************************/

class IColorGroupIterator : public virtual IResourceIterator {
public:
	/**
	* IColorGroupIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x10274A1757C729C0UL; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroupIterator"
	}

	/**
	* IColorGroupIterator::GetCurrentColorGroup - Returns the ColorGroup the iterator points at.
	* @return returns the ColorGroup instance.
	*/
	virtual IColorGroup * GetCurrentColorGroup() = 0;

};

typedef IBaseSharedPtr<IColorGroupIterator> PIColorGroupIterator;


/*************************************************************************************************************************
 Class interface for Texture2DGroupIterator 
**************************************************************************************************************************/

class ITexture2DGroupIterator : public virtual IResourceIterator {
public:
	/**
	* ITexture2DGroupIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x30D55F4DB88FE0CAUL; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroupIterator"
	}

	/**
	* ITexture2DGroupIterator::GetCurrentTexture2DGroup - Returns the Texture2DGroup the iterator points at.
	* @return returns the Texture2DGroup instance.
	*/
	virtual ITexture2DGroup * GetCurrentTexture2DGroup() = 0;

};

typedef IBaseSharedPtr<ITexture2DGroupIterator> PITexture2DGroupIterator;


/*************************************************************************************************************************
 Class interface for CompositeMaterialsIterator 
**************************************************************************************************************************/

class ICompositeMaterialsIterator : public virtual IResourceIterator {
public:
	/**
	* ICompositeMaterialsIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xA99CC6C3F70FB6F9UL; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterialsIterator"
	}

	/**
	* ICompositeMaterialsIterator::GetCurrentCompositeMaterials - Returns the CompositeMaterials the iterator points at.
	* @return returns the CompositeMaterials instance.
	*/
	virtual ICompositeMaterials * GetCurrentCompositeMaterials() = 0;

};

typedef IBaseSharedPtr<ICompositeMaterialsIterator> PICompositeMaterialsIterator;


/*************************************************************************************************************************
 Class interface for MultiPropertyGroupIterator 
**************************************************************************************************************************/

class IMultiPropertyGroupIterator : public virtual IResourceIterator {
public:
	/**
	* IMultiPropertyGroupIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xC2BDF5D8CBBDB1F0UL; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroupIterator"
	}

	/**
	* IMultiPropertyGroupIterator::GetCurrentMultiPropertyGroup - Returns the MultiPropertyGroup the iterator points at.
	* @return returns the MultiPropertyGroup instance.
	*/
	virtual IMultiPropertyGroup * GetCurrentMultiPropertyGroup() = 0;

};

typedef IBaseSharedPtr<IMultiPropertyGroupIterator> PIMultiPropertyGroupIterator;


/*************************************************************************************************************************
 Class interface for MetaData 
**************************************************************************************************************************/

class IMetaData : public virtual IBase {
public:
	/**
	* IMetaData::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD17716D063DE2C22UL; // First 64 bits of SHA1 of a string: "Lib3MF::MetaData"
	}

	/**
	* IMetaData::GetNameSpace - returns the namespace URL of the metadata
	* @return the namespace URL of the metadata
	*/
	virtual std::string GetNameSpace() = 0;

	/**
	* IMetaData::SetNameSpace - sets a new namespace URL of the metadata
	* @param[in] sNameSpace - the new namespace URL of the metadata
	*/
	virtual void SetNameSpace(const std::string & sNameSpace) = 0;

	/**
	* IMetaData::GetName - returns the name of a metadata
	* @return the name of the metadata
	*/
	virtual std::string GetName() = 0;

	/**
	* IMetaData::SetName - sets a new name of a metadata
	* @param[in] sName - the new name of the metadata
	*/
	virtual void SetName(const std::string & sName) = 0;

	/**
	* IMetaData::GetKey - returns the (namespace+name) of a metadata
	* @return the key (namespace+name) of the metadata
	*/
	virtual std::string GetKey() = 0;

	/**
	* IMetaData::GetMustPreserve - returns, whether a metadata must be preserved
	* @return returns, whether a metadata must be preserved
	*/
	virtual bool GetMustPreserve() = 0;

	/**
	* IMetaData::SetMustPreserve - sets whether a metadata must be preserved
	* @param[in] bMustPreserve - a new value whether a metadata must be preserved
	*/
	virtual void SetMustPreserve(const bool bMustPreserve) = 0;

	/**
	* IMetaData::GetType - returns the type of a metadata
	* @return the type of the metadata
	*/
	virtual std::string GetType() = 0;

	/**
	* IMetaData::SetType - sets a new type of a metadata. This must be a simple XML type
	* @param[in] sType - a new type of the metadata
	*/
	virtual void SetType(const std::string & sType) = 0;

	/**
	* IMetaData::GetValue - returns the value of the metadata
	* @return the value of the metadata
	*/
	virtual std::string GetValue() = 0;

	/**
	* IMetaData::SetValue - sets a new value of the metadata
	* @param[in] sValue - a new value of the metadata
	*/
	virtual void SetValue(const std::string & sValue) = 0;

};

typedef IBaseSharedPtr<IMetaData> PIMetaData;


/*************************************************************************************************************************
 Class interface for MetaDataGroup 
**************************************************************************************************************************/

class IMetaDataGroup : public virtual IBase {
public:
	/**
	* IMetaDataGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xC3B85369E9B25D3UL; // First 64 bits of SHA1 of a string: "Lib3MF::MetaDataGroup"
	}

	/**
	* IMetaDataGroup::GetMetaDataCount - returns the number of metadata in this metadatagroup
	* @return returns the number metadata
	*/
	virtual Lib3MF_uint32 GetMetaDataCount() = 0;

	/**
	* IMetaDataGroup::GetMetaData - returns a metadata value within this metadatagroup
	* @param[in] nIndex - Index of the Metadata.
	* @return an instance of the metadata
	*/
	virtual IMetaData * GetMetaData(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IMetaDataGroup::GetMetaDataByKey - returns a metadata value within this metadatagroup
	* @param[in] sNameSpace - the namespace of the metadata
	* @param[in] sName - the name of the Metadata
	* @return an instance of the metadata
	*/
	virtual IMetaData * GetMetaDataByKey(const std::string & sNameSpace, const std::string & sName) = 0;

	/**
	* IMetaDataGroup::RemoveMetaDataByIndex - removes metadata by index from the model.
	* @param[in] nIndex -  Index of the metadata to remove
	*/
	virtual void RemoveMetaDataByIndex(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IMetaDataGroup::RemoveMetaData - removes metadata from the model.
	* @param[in] pTheMetaData - The metadata to remove
	*/
	virtual void RemoveMetaData(IMetaData* pTheMetaData) = 0;

	/**
	* IMetaDataGroup::AddMetaData - adds a new metadata to this metadatagroup
	* @param[in] sNameSpace - the namespace of the metadata
	* @param[in] sName - the name of the metadata
	* @param[in] sValue - the value of the metadata
	* @param[in] sType - the type of the metadata
	* @param[in] bMustPreserve - shuold the metadata be preserved
	* @return a new instance of the metadata
	*/
	virtual IMetaData * AddMetaData(const std::string & sNameSpace, const std::string & sName, const std::string & sValue, const std::string & sType, const bool bMustPreserve) = 0;

};

typedef IBaseSharedPtr<IMetaDataGroup> PIMetaDataGroup;


/*************************************************************************************************************************
 Class interface for Object 
**************************************************************************************************************************/

class IObject : public virtual IResource {
public:
	/**
	* IObject::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x2DA2136F577A779CUL; // First 64 bits of SHA1 of a string: "Lib3MF::Object"
	}

	/**
	* IObject::GetType - Retrieves an object's type
	* @return returns object type enum.
	*/
	virtual Lib3MF::eObjectType GetType() = 0;

	/**
	* IObject::SetType - Sets an object's type
	* @param[in] eObjectType - object type enum.
	*/
	virtual void SetType(const Lib3MF::eObjectType eObjectType) = 0;

	/**
	* IObject::GetName - Retrieves an object's name
	* @return returns object name.
	*/
	virtual std::string GetName() = 0;

	/**
	* IObject::SetName - Sets an object's name string
	* @param[in] sName - new object name.
	*/
	virtual void SetName(const std::string & sName) = 0;

	/**
	* IObject::GetPartNumber - Retrieves an object's part number
	* @return returns object part number.
	*/
	virtual std::string GetPartNumber() = 0;

	/**
	* IObject::SetPartNumber - Sets an objects partnumber string
	* @param[in] sPartNumber - new object part number.
	*/
	virtual void SetPartNumber(const std::string & sPartNumber) = 0;

	/**
	* IObject::IsMeshObject - Retrieves, if an object is a mesh object
	* @return returns, whether the object is a mesh object
	*/
	virtual bool IsMeshObject() = 0;

	/**
	* IObject::IsComponentsObject - Retrieves, if an object is a components object
	* @return returns, whether the object is a components object
	*/
	virtual bool IsComponentsObject() = 0;

	/**
	* IObject::IsValid - Retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
	* @return returns whether the object is a valid object description
	*/
	virtual bool IsValid() = 0;

	/**
	* IObject::SetAttachmentAsThumbnail - Use an existing attachment as thumbnail for this object
	* @param[in] pAttachment - Instance of a new or the existing thumbnailattachment object.
	*/
	virtual void SetAttachmentAsThumbnail(IAttachment* pAttachment) = 0;

	/**
	* IObject::GetThumbnailAttachment - Get the attachment containing the object thumbnail.
	* @return Instance of the thumbnailattachment object or NULL.
	*/
	virtual IAttachment * GetThumbnailAttachment() = 0;

	/**
	* IObject::ClearThumbnailAttachment - Clears the attachment. The attachment instance is not removed from the package.
	*/
	virtual void ClearThumbnailAttachment() = 0;

	/**
	* IObject::GetOutbox - Returns the outbox of a build item
	* @return Outbox of this build item
	*/
	virtual Lib3MF::sBox GetOutbox() = 0;

	/**
	* IObject::GetUUID - Retrieves an object's uuid string (see production extension specification)
	* @param[out] bHasUUID - flag whether the build item has a UUID
	* @return returns object uuid.
	*/
	virtual std::string GetUUID(bool & bHasUUID) = 0;

	/**
	* IObject::SetUUID - Sets a build object's uuid string (see production extension specification)
	* @param[in] sUUID - new object uuid string.
	*/
	virtual void SetUUID(const std::string & sUUID) = 0;

	/**
	* IObject::GetMetaDataGroup - Returns the metadatagroup of this object
	* @return returns an Instance of the metadatagroup of this object
	*/
	virtual IMetaDataGroup * GetMetaDataGroup() = 0;

	/**
	* IObject::SetSlicesMeshResolution - set the meshresolution of the mesh object
	* @param[in] eMeshResolution - meshresolution of this object
	*/
	virtual void SetSlicesMeshResolution(const Lib3MF::eSlicesMeshResolution eMeshResolution) = 0;

	/**
	* IObject::GetSlicesMeshResolution - get the meshresolution of the mesh object
	* @return meshresolution of this object
	*/
	virtual Lib3MF::eSlicesMeshResolution GetSlicesMeshResolution() = 0;

	/**
	* IObject::HasSlices - returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack
	* @param[in] bRecursive - check also all referenced objects?
	* @return does the object have a slice stack?
	*/
	virtual bool HasSlices(const bool bRecursive) = 0;

	/**
	* IObject::ClearSliceStack - unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
	*/
	virtual void ClearSliceStack() = 0;

	/**
	* IObject::GetSliceStack - get the Slicestack attached to the object
	* @return returns the slicestack instance
	*/
	virtual ISliceStack * GetSliceStack() = 0;

	/**
	* IObject::AssignSliceStack - assigns a slicestack to the object
	* @param[in] pSliceStackInstance - the new slice stack of this Object
	*/
	virtual void AssignSliceStack(ISliceStack* pSliceStackInstance) = 0;

};

typedef IBaseSharedPtr<IObject> PIObject;


/*************************************************************************************************************************
 Class interface for MeshObject 
**************************************************************************************************************************/

class IMeshObject : public virtual IObject {
public:
	/**
	* IMeshObject::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x3B3A6DC6EC610497UL; // First 64 bits of SHA1 of a string: "Lib3MF::MeshObject"
	}

	/**
	* IMeshObject::GetVertexCount - Returns the vertex count of a mesh object.
	* @return filled with the vertex count.
	*/
	virtual Lib3MF_uint32 GetVertexCount() = 0;

	/**
	* IMeshObject::GetTriangleCount - Returns the triangle count of a mesh object.
	* @return filled with the triangle count.
	*/
	virtual Lib3MF_uint32 GetTriangleCount() = 0;

	/**
	* IMeshObject::GetVertex - Returns the vertex count of a mesh object.
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @return filled with the vertex coordinates.
	*/
	virtual Lib3MF::sPosition GetVertex(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IMeshObject::SetVertex - Sets the coordinates of a single vertex of a mesh object
	* @param[in] nIndex - Index of the vertex (0 to vertexcount - 1)
	* @param[in] Coordinates - contains the vertex coordinates.
	*/
	virtual void SetVertex(const Lib3MF_uint32 nIndex, const Lib3MF::sPosition Coordinates) = 0;

	/**
	* IMeshObject::AddVertex - Adds a single vertex to a mesh object
	* @param[in] Coordinates - contains the vertex coordinates.
	* @return Index of the new vertex
	*/
	virtual Lib3MF_uint32 AddVertex(const Lib3MF::sPosition Coordinates) = 0;

	/**
	* IMeshObject::GetVertices - Obtains all vertex positions of a mesh object
	* @param[in] nVerticesBufferSize - Number of elements in buffer
	* @param[out] pVerticesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pVerticesBuffer - Position buffer of contains the vertex coordinates.
	*/
	virtual void GetVertices(Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, Lib3MF::sPosition * pVerticesBuffer) = 0;

	/**
	* IMeshObject::GetTriangle - Returns indices of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @return filled with the triangle indices.
	*/
	virtual Lib3MF::sTriangle GetTriangle(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IMeshObject::SetTriangle - Sets the indices of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] Indices - contains the triangle indices.
	*/
	virtual void SetTriangle(const Lib3MF_uint32 nIndex, const Lib3MF::sTriangle Indices) = 0;

	/**
	* IMeshObject::AddTriangle - Adds a single triangle to a mesh object
	* @param[in] Indices - contains the triangle indices.
	* @return Index of the new triangle
	*/
	virtual Lib3MF_uint32 AddTriangle(const Lib3MF::sTriangle Indices) = 0;

	/**
	* IMeshObject::GetTriangleIndices - Get all triangles of a mesh object
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[out] pIndicesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pIndicesBuffer - Triangle buffer of contains the triangle indices.
	*/
	virtual void GetTriangleIndices(Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF::sTriangle * pIndicesBuffer) = 0;

	/**
	* IMeshObject::SetObjectLevelProperty - Sets the property at the object-level of the mesh object.
	* @param[in] nUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[in] nPropertyID - the object-level PropertyID.
	*/
	virtual void SetObjectLevelProperty(const Lib3MF_uint32 nUniqueResourceID, const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IMeshObject::GetObjectLevelProperty - Gets the property at the object-level of the mesh object.
	* @param[out] nUniqueResourceID - the object-level Property UniqueResourceID.
	* @param[out] nPropertyID - the object-level PropertyID.
	* @return Has an object-level property been specified?
	*/
	virtual bool GetObjectLevelProperty(Lib3MF_uint32 & nUniqueResourceID, Lib3MF_uint32 & nPropertyID) = 0;

	/**
	* IMeshObject::SetTriangleProperties - Sets the properties of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[in] Properties - contains the triangle properties.
	*/
	virtual void SetTriangleProperties(const Lib3MF_uint32 nIndex, const Lib3MF::sTriangleProperties Properties) = 0;

	/**
	* IMeshObject::GetTriangleProperties - Gets the properties of a single triangle of a mesh object.
	* @param[in] nIndex - Index of the triangle (0 to trianglecount - 1)
	* @param[out] sProperty - returns the triangle properties.
	*/
	virtual void GetTriangleProperties(const Lib3MF_uint32 nIndex, Lib3MF::sTriangleProperties & sProperty) = 0;

	/**
	* IMeshObject::SetAllTriangleProperties - Sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
	* @param[in] nPropertiesArrayBufferSize - Number of elements in buffer
	* @param[in] pPropertiesArrayBuffer - contains the triangle properties array. Must have trianglecount elements.
	*/
	virtual void SetAllTriangleProperties(const Lib3MF_uint64 nPropertiesArrayBufferSize, const Lib3MF::sTriangleProperties * pPropertiesArrayBuffer) = 0;

	/**
	* IMeshObject::GetAllTriangleProperties - Gets the properties of all triangles of a mesh object.
	* @param[in] nPropertiesArrayBufferSize - Number of elements in buffer
	* @param[out] pPropertiesArrayNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertiesArrayBuffer - TriangleProperties buffer of returns the triangle properties array. Must have trianglecount elements.
	*/
	virtual void GetAllTriangleProperties(Lib3MF_uint64 nPropertiesArrayBufferSize, Lib3MF_uint64* pPropertiesArrayNeededCount, Lib3MF::sTriangleProperties * pPropertiesArrayBuffer) = 0;

	/**
	* IMeshObject::ClearAllProperties - Clears all properties of this mesh object (triangle and object-level).
	*/
	virtual void ClearAllProperties() = 0;

	/**
	* IMeshObject::SetGeometry - Set all triangles of a mesh object
	* @param[in] nVerticesBufferSize - Number of elements in buffer
	* @param[in] pVerticesBuffer - contains the positions.
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[in] pIndicesBuffer - contains the triangle indices.
	*/
	virtual void SetGeometry(const Lib3MF_uint64 nVerticesBufferSize, const Lib3MF::sPosition * pVerticesBuffer, const Lib3MF_uint64 nIndicesBufferSize, const Lib3MF::sTriangle * pIndicesBuffer) = 0;

	/**
	* IMeshObject::IsManifoldAndOriented - Retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
	* @return returns, if the object is oriented and manifold.
	*/
	virtual bool IsManifoldAndOriented() = 0;

	/**
	* IMeshObject::BeamLattice - Retrieves the BeamLattice within this MeshObject.
	* @return the BeamLattice within this MeshObject
	*/
	virtual IBeamLattice * BeamLattice() = 0;

};

typedef IBaseSharedPtr<IMeshObject> PIMeshObject;


/*************************************************************************************************************************
 Class interface for BeamLattice 
**************************************************************************************************************************/

class IBeamLattice : public virtual IBase {
public:
	/**
	* IBeamLattice::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x63B3B461B30B4BA5UL; // First 64 bits of SHA1 of a string: "Lib3MF::BeamLattice"
	}

	/**
	* IBeamLattice::GetMinLength - Returns the minimal length of beams for the beamlattice.
	* @return minimal length of beams for the beamlattice
	*/
	virtual Lib3MF_double GetMinLength() = 0;

	/**
	* IBeamLattice::SetMinLength - Sets the minimal length of beams for the beamlattice.
	* @param[in] dMinLength - minimal length of beams for the beamlattice
	*/
	virtual void SetMinLength(const Lib3MF_double dMinLength) = 0;

	/**
	* IBeamLattice::GetClipping - Returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	* @param[out] eClipMode - contains the clip mode of this mesh
	* @param[out] nUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object or an undefined value if pClipMode is MODELBEAMLATTICECLIPMODE_NONE
	*/
	virtual void GetClipping(Lib3MF::eBeamLatticeClipMode & eClipMode, Lib3MF_uint32 & nUniqueResourceID) = 0;

	/**
	* IBeamLattice::SetClipping - Sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
	* @param[in] eClipMode - contains the clip mode of this mesh
	* @param[in] nUniqueResourceID - the UniqueResourceID of the clipping mesh-object. This mesh-object has to be defined before setting the Clipping.
	*/
	virtual void SetClipping(const Lib3MF::eBeamLatticeClipMode eClipMode, const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IBeamLattice::GetRepresentation - Returns the representation-mesh for the beamlattice of this mesh.
	* @return flag whether the beamlattice has a representation mesh.
	* @param[out] nUniqueResourceID - filled with the UniqueResourceID of the clipping mesh-object.
	*/
	virtual bool GetRepresentation(Lib3MF_uint32 & nUniqueResourceID) = 0;

	/**
	* IBeamLattice::SetRepresentation - Sets the representation-mesh for the beamlattice of this mesh.
	* @param[in] nUniqueResourceID - the UniqueResourceID of the representation mesh-object. This mesh-object has to be defined before setting the representation.
	*/
	virtual void SetRepresentation(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IBeamLattice::GetBallOptions - Returns the ball mode and the default ball radius for the beamlattice of this mesh.
	* @param[out] eBallMode - contains the ball mode of this mesh
	* @param[out] dBallRadius - default ball radius of balls for the beamlattice
	*/
	virtual void GetBallOptions(Lib3MF::eBeamLatticeBallMode & eBallMode, Lib3MF_double & dBallRadius) = 0;

	/**
	* IBeamLattice::SetBallOptions - Sets the ball mode and thedefault ball radius for the beamlattice.
	* @param[in] eBallMode - contains the ball mode of this mesh
	* @param[in] dBallRadius - default ball radius of balls for the beamlattice
	*/
	virtual void SetBallOptions(const Lib3MF::eBeamLatticeBallMode eBallMode, const Lib3MF_double dBallRadius) = 0;

	/**
	* IBeamLattice::GetBeamCount - Returns the beam count of a mesh object.
	* @return filled with the beam count.
	*/
	virtual Lib3MF_uint32 GetBeamCount() = 0;

	/**
	* IBeamLattice::GetBeam - Returns indices, radii and capmodes of a single beam of a mesh object.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @return filled with the beam indices, radii and capmodes.
	*/
	virtual Lib3MF::sBeam GetBeam(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IBeamLattice::AddBeam - Adds a single beam to a mesh object.
	* @param[in] BeamInfo - contains the node indices, radii and capmodes.
	* @return filled with the new Index of the beam.
	*/
	virtual Lib3MF_uint32 AddBeam(const Lib3MF::sBeam BeamInfo) = 0;

	/**
	* IBeamLattice::SetBeam - Sets the indices, radii and capmodes of a single beam of a mesh object.
	* @param[in] nIndex - Index of the beam (0 to beamcount - 1).
	* @param[in] BeamInfo - filled with the beam indices, radii and capmodes.
	*/
	virtual void SetBeam(const Lib3MF_uint32 nIndex, const Lib3MF::sBeam BeamInfo) = 0;

	/**
	* IBeamLattice::SetBeams - Sets all beam indices, radii and capmodes of a mesh object.
	* @param[in] nBeamInfoBufferSize - Number of elements in buffer
	* @param[in] pBeamInfoBuffer - contains information of a number of  beams
	*/
	virtual void SetBeams(const Lib3MF_uint64 nBeamInfoBufferSize, const Lib3MF::sBeam * pBeamInfoBuffer) = 0;

	/**
	* IBeamLattice::GetBeams - obtains all beam indices, radii and capmodes of a mesh object.
	* @param[in] nBeamInfoBufferSize - Number of elements in buffer
	* @param[out] pBeamInfoNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBeamInfoBuffer - Beam buffer of contains information of all beams
	*/
	virtual void GetBeams(Lib3MF_uint64 nBeamInfoBufferSize, Lib3MF_uint64* pBeamInfoNeededCount, Lib3MF::sBeam * pBeamInfoBuffer) = 0;

	/**
	* IBeamLattice::GetBallCount - Returns the ball count of a mesh object.
	* @return filled with the ball count.
	*/
	virtual Lib3MF_uint32 GetBallCount() = 0;

	/**
	* IBeamLattice::GetBall - Returns index and radius of a single ball of a mesh object.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @return filled with the ball node index and radius.
	*/
	virtual Lib3MF::sBall GetBall(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IBeamLattice::AddBall - Adds a single ball to a mesh object.
	* @param[in] BallInfo - contains the node index and radius.
	* @return filled with the new Index of the ball.
	*/
	virtual Lib3MF_uint32 AddBall(const Lib3MF::sBall BallInfo) = 0;

	/**
	* IBeamLattice::SetBall - Sets the index and radius of a single ball of a mesh object.
	* @param[in] nIndex - Index of the ball (0 to ballcount - 1).
	* @param[in] BallInfo - filled with the ball node index and radius.
	*/
	virtual void SetBall(const Lib3MF_uint32 nIndex, const Lib3MF::sBall BallInfo) = 0;

	/**
	* IBeamLattice::SetBalls - Sets all ball indices and radii of a mesh object.
	* @param[in] nBallInfoBufferSize - Number of elements in buffer
	* @param[in] pBallInfoBuffer - contains information of a number of  balls
	*/
	virtual void SetBalls(const Lib3MF_uint64 nBallInfoBufferSize, const Lib3MF::sBall * pBallInfoBuffer) = 0;

	/**
	* IBeamLattice::GetBalls - obtains all ball indices and radii of a mesh object.
	* @param[in] nBallInfoBufferSize - Number of elements in buffer
	* @param[out] pBallInfoNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBallInfoBuffer - Ball buffer of contains information of all balls
	*/
	virtual void GetBalls(Lib3MF_uint64 nBallInfoBufferSize, Lib3MF_uint64* pBallInfoNeededCount, Lib3MF::sBall * pBallInfoBuffer) = 0;

	/**
	* IBeamLattice::GetBeamSetCount - Returns the number of beamsets of a mesh object.
	* @return filled with the beamset count.
	*/
	virtual Lib3MF_uint32 GetBeamSetCount() = 0;

	/**
	* IBeamLattice::AddBeamSet - Adds an empty beamset to a mesh object
	* @return the new beamset
	*/
	virtual IBeamSet * AddBeamSet() = 0;

	/**
	* IBeamLattice::GetBeamSet - Returns a beamset of a mesh object
	* @param[in] nIndex - index of the requested beamset (0 ... beamsetcount-1).
	* @return the requested beamset
	*/
	virtual IBeamSet * GetBeamSet(const Lib3MF_uint32 nIndex) = 0;

};

typedef IBaseSharedPtr<IBeamLattice> PIBeamLattice;


/*************************************************************************************************************************
 Class interface for Component 
**************************************************************************************************************************/

class IComponent : public virtual IBase {
public:
	/**
	* IComponent::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x4ECDB6A6F69F2BEBUL; // First 64 bits of SHA1 of a string: "Lib3MF::Component"
	}

	/**
	* IComponent::GetObjectResource - Returns the Resource Instance of the component.
	* @return filled with the Resource Instance.
	*/
	virtual IObject * GetObjectResource() = 0;

	/**
	* IComponent::GetObjectResourceID - Returns the UniqueResourceID of the component.
	* @return returns the UniqueResourceID.
	*/
	virtual Lib3MF_uint32 GetObjectResourceID() = 0;

	/**
	* IComponent::GetUUID - returns, whether a component has a UUID and, if true, the component's UUID
	* @param[out] bHasUUID - flag whether the component has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual std::string GetUUID(bool & bHasUUID) = 0;

	/**
	* IComponent::SetUUID - sets the component's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual void SetUUID(const std::string & sUUID) = 0;

	/**
	* IComponent::HasTransform - Returns, if the component has a different transformation than the identity matrix
	* @return if true is returned, the transformation is not equal than the identity
	*/
	virtual bool HasTransform() = 0;

	/**
	* IComponent::GetTransform - Returns the transformation matrix of the component.
	* @return filled with the component transformation matrix
	*/
	virtual Lib3MF::sTransform GetTransform() = 0;

	/**
	* IComponent::SetTransform - Sets the transformation matrix of the component.
	* @param[in] Transform - new transformation matrix
	*/
	virtual void SetTransform(const Lib3MF::sTransform Transform) = 0;

};

typedef IBaseSharedPtr<IComponent> PIComponent;


/*************************************************************************************************************************
 Class interface for ComponentsObject 
**************************************************************************************************************************/

class IComponentsObject : public virtual IObject {
public:
	/**
	* IComponentsObject::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x6522CF04EB283FEDUL; // First 64 bits of SHA1 of a string: "Lib3MF::ComponentsObject"
	}

	/**
	* IComponentsObject::AddComponent - Adds a new component to a components object.
	* @param[in] pObjectResource - object to add as component. Must not lead to circular references!
	* @param[in] Transform - optional transform matrix for the component.
	* @return new component instance
	*/
	virtual IComponent * AddComponent(IObject* pObjectResource, const Lib3MF::sTransform Transform) = 0;

	/**
	* IComponentsObject::GetComponent - Retrieves a component from a component object.
	* @param[in] nIndex - index of the component to retrieve (0 to componentcount - 1)
	* @return component instance
	*/
	virtual IComponent * GetComponent(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IComponentsObject::GetComponentCount - Retrieves a component count of a component object.
	* @return returns the component count
	*/
	virtual Lib3MF_uint32 GetComponentCount() = 0;

};

typedef IBaseSharedPtr<IComponentsObject> PIComponentsObject;


/*************************************************************************************************************************
 Class interface for BeamSet 
**************************************************************************************************************************/

class IBeamSet : public virtual IBase {
public:
	/**
	* IBeamSet::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x30CCDBE90E00B55BUL; // First 64 bits of SHA1 of a string: "Lib3MF::BeamSet"
	}

	/**
	* IBeamSet::SetName - Sets a beamset's name string
	* @param[in] sName - new name of the beamset.
	*/
	virtual void SetName(const std::string & sName) = 0;

	/**
	* IBeamSet::GetName - Retrieves a beamset's name string
	* @return returns the name of the beamset.
	*/
	virtual std::string GetName() = 0;

	/**
	* IBeamSet::SetIdentifier - Sets a beamset's identifier string
	* @param[in] sIdentifier - new name of the beamset.
	*/
	virtual void SetIdentifier(const std::string & sIdentifier) = 0;

	/**
	* IBeamSet::GetIdentifier - Retrieves a beamset's identifier string
	* @return returns the identifier of the beamset.
	*/
	virtual std::string GetIdentifier() = 0;

	/**
	* IBeamSet::GetReferenceCount - Retrieves the reference count of a beamset
	* @return returns the reference count
	*/
	virtual Lib3MF_uint32 GetReferenceCount() = 0;

	/**
	* IBeamSet::SetReferences - Sets the references of a beamset
	* @param[in] nReferencesBufferSize - Number of elements in buffer
	* @param[in] pReferencesBuffer - the new indices of all beams in this beamset
	*/
	virtual void SetReferences(const Lib3MF_uint64 nReferencesBufferSize, const Lib3MF_uint32 * pReferencesBuffer) = 0;

	/**
	* IBeamSet::GetReferences - Retrieves the references of a beamset
	* @param[in] nReferencesBufferSize - Number of elements in buffer
	* @param[out] pReferencesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pReferencesBuffer - uint32 buffer of retrieves the indices of all beams in this beamset
	*/
	virtual void GetReferences(Lib3MF_uint64 nReferencesBufferSize, Lib3MF_uint64* pReferencesNeededCount, Lib3MF_uint32 * pReferencesBuffer) = 0;

	/**
	* IBeamSet::GetBallReferenceCount - Retrieves the ball reference count of a beamset
	* @return returns the ball reference count
	*/
	virtual Lib3MF_uint32 GetBallReferenceCount() = 0;

	/**
	* IBeamSet::SetBallReferences - Sets the ball references of a beamset
	* @param[in] nBallReferencesBufferSize - Number of elements in buffer
	* @param[in] pBallReferencesBuffer - the new indices of all balls in this beamset
	*/
	virtual void SetBallReferences(const Lib3MF_uint64 nBallReferencesBufferSize, const Lib3MF_uint32 * pBallReferencesBuffer) = 0;

	/**
	* IBeamSet::GetBallReferences - Retrieves the ball references of a beamset
	* @param[in] nBallReferencesBufferSize - Number of elements in buffer
	* @param[out] pBallReferencesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBallReferencesBuffer - uint32 buffer of retrieves the indices of all balls in this beamset
	*/
	virtual void GetBallReferences(Lib3MF_uint64 nBallReferencesBufferSize, Lib3MF_uint64* pBallReferencesNeededCount, Lib3MF_uint32 * pBallReferencesBuffer) = 0;

};

typedef IBaseSharedPtr<IBeamSet> PIBeamSet;


/*************************************************************************************************************************
 Class interface for BaseMaterialGroup 
**************************************************************************************************************************/

class IBaseMaterialGroup : public virtual IResource {
public:
	/**
	* IBaseMaterialGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xB27D4656E16609FAUL; // First 64 bits of SHA1 of a string: "Lib3MF::BaseMaterialGroup"
	}

	/**
	* IBaseMaterialGroup::GetCount - Retrieves the count of base materials in the material group.
	* @return returns the count of base materials.
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* IBaseMaterialGroup::GetAllPropertyIDs - returns all the PropertyIDs of all materials in this group
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the material in the material group.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IBaseMaterialGroup::AddMaterial - Adds a new material to the material group
	* @param[in] sName - new name of the base material.
	* @param[in] DisplayColor - Display color of the material
	* @return returns new PropertyID of the new material in the material group.
	*/
	virtual Lib3MF_uint32 AddMaterial(const std::string & sName, const Lib3MF::sColor DisplayColor) = 0;

	/**
	* IBaseMaterialGroup::RemoveMaterial - Removes a material from the material group.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	*/
	virtual void RemoveMaterial(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IBaseMaterialGroup::GetName - Returns the base material's name
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return returns the name of the base material.
	*/
	virtual std::string GetName(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IBaseMaterialGroup::SetName - Sets a base material's name
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] sName - new name of the base material.
	*/
	virtual void SetName(const Lib3MF_uint32 nPropertyID, const std::string & sName) = 0;

	/**
	* IBaseMaterialGroup::SetDisplayColor - Sets a base material's display color.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @param[in] TheColor - The base material's display color
	*/
	virtual void SetDisplayColor(const Lib3MF_uint32 nPropertyID, const Lib3MF::sColor TheColor) = 0;

	/**
	* IBaseMaterialGroup::GetDisplayColor - Returns a base material's display color.
	* @param[in] nPropertyID - PropertyID of the material in the material group.
	* @return The base material's display color
	*/
	virtual Lib3MF::sColor GetDisplayColor(const Lib3MF_uint32 nPropertyID) = 0;

};

typedef IBaseSharedPtr<IBaseMaterialGroup> PIBaseMaterialGroup;


/*************************************************************************************************************************
 Class interface for ColorGroup 
**************************************************************************************************************************/

class IColorGroup : public virtual IResource {
public:
	/**
	* IColorGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD085FB2E49CDB5B1UL; // First 64 bits of SHA1 of a string: "Lib3MF::ColorGroup"
	}

	/**
	* IColorGroup::GetCount - Retrieves the count of base materials in this Color Group.
	* @return returns the count of colors within this color group.
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* IColorGroup::GetAllPropertyIDs - returns all the PropertyIDs of all colors within this group
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the color in the color group.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IColorGroup::AddColor - Adds a new value.
	* @param[in] TheColor - The new color
	* @return PropertyID of the new color within this color group.
	*/
	virtual Lib3MF_uint32 AddColor(const Lib3MF::sColor TheColor) = 0;

	/**
	* IColorGroup::RemoveColor - Removes a color from the color group.
	* @param[in] nPropertyID - PropertyID of the color to be removed from the color group.
	*/
	virtual void RemoveColor(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IColorGroup::SetColor - Sets a color value.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @param[in] TheColor - The color
	*/
	virtual void SetColor(const Lib3MF_uint32 nPropertyID, const Lib3MF::sColor TheColor) = 0;

	/**
	* IColorGroup::GetColor - Sets a color value.
	* @param[in] nPropertyID - PropertyID of a color within this color group.
	* @return The color
	*/
	virtual Lib3MF::sColor GetColor(const Lib3MF_uint32 nPropertyID) = 0;

};

typedef IBaseSharedPtr<IColorGroup> PIColorGroup;


/*************************************************************************************************************************
 Class interface for Texture2DGroup 
**************************************************************************************************************************/

class ITexture2DGroup : public virtual IResource {
public:
	/**
	* ITexture2DGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xBC1208397E37055DUL; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2DGroup"
	}

	/**
	* ITexture2DGroup::GetCount - Retrieves the count of tex2coords in the Texture2DGroup.
	* @return returns the count of tex2coords.
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* ITexture2DGroup::GetAllPropertyIDs - returns all the PropertyIDs of all tex2coords in this Texture2DGroup
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the tex2coords in the Texture2DGroup.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* ITexture2DGroup::AddTex2Coord - Adds a new tex2coord to the Texture2DGroup
	* @param[in] UVCoordinate - The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	* @return returns new PropertyID of the new tex2coord in the Texture2DGroup.
	*/
	virtual Lib3MF_uint32 AddTex2Coord(const Lib3MF::sTex2Coord UVCoordinate) = 0;

	/**
	* ITexture2DGroup::GetTex2Coord - Obtains a tex2coord to the Texture2DGroup
	* @param[in] nPropertyID - the PropertyID of the tex2coord in the Texture2DGroup.
	* @return The u/v-coordinate within the texture, horizontally right/vertically up from the origin in the lower left of the texture.
	*/
	virtual Lib3MF::sTex2Coord GetTex2Coord(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* ITexture2DGroup::RemoveTex2Coord - Removes a tex2coords from the Texture2DGroup.
	* @param[in] nPropertyID - PropertyID of the tex2coords in the Texture2DGroup.
	*/
	virtual void RemoveTex2Coord(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* ITexture2DGroup::GetTexture2D - Obtains the texture2D instance of this group.
	* @return the texture2D instance of this group.
	*/
	virtual ITexture2D * GetTexture2D() = 0;

};

typedef IBaseSharedPtr<ITexture2DGroup> PITexture2DGroup;


/*************************************************************************************************************************
 Class interface for CompositeMaterials 
**************************************************************************************************************************/

class ICompositeMaterials : public virtual IResource {
public:
	/**
	* ICompositeMaterials::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xCE16224D688B86F2UL; // First 64 bits of SHA1 of a string: "Lib3MF::CompositeMaterials"
	}

	/**
	* ICompositeMaterials::GetCount - Retrieves the count of Composite-s in the CompositeMaterials.
	* @return returns the count of Composite-s
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* ICompositeMaterials::GetAllPropertyIDs - returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the Composite-Mixing Values in the CompositeMaterials.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* ICompositeMaterials::GetBaseMaterialGroup - Obtains the BaseMaterialGroup instance of this CompositeMaterials.
	* @return returns the BaseMaterialGroup instance of this CompositeMaterials
	*/
	virtual IBaseMaterialGroup * GetBaseMaterialGroup() = 0;

	/**
	* ICompositeMaterials::AddComposite - Adds a new Composite-Mixing Values to the CompositeMaterials.
	* @param[in] nCompositeBufferSize - Number of elements in buffer
	* @param[in] pCompositeBuffer - The Composite Constituents to be added as composite
	* @return returns new PropertyID of the new Composite in the CompositeMaterials.
	*/
	virtual Lib3MF_uint32 AddComposite(const Lib3MF_uint64 nCompositeBufferSize, const Lib3MF::sCompositeConstituent * pCompositeBuffer) = 0;

	/**
	* ICompositeMaterials::RemoveComposite - Removes a Composite-Maxing Ratio from the CompositeMaterials.
	* @param[in] nPropertyID - PropertyID of the  Composite-Mixing Values in the CompositeMaterials to be removed.
	*/
	virtual void RemoveComposite(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* ICompositeMaterials::GetComposite - Obtains a Composite-Maxing Ratio of this CompositeMaterials.
	* @param[in] nPropertyID - the PropertyID of the Composite-Maxing Ratio in the CompositeMaterials.
	* @param[in] nCompositeBufferSize - Number of elements in buffer
	* @param[out] pCompositeNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pCompositeBuffer - CompositeConstituent buffer of The Composite-Mixing Values with the given PropertyID
	*/
	virtual void GetComposite(const Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nCompositeBufferSize, Lib3MF_uint64* pCompositeNeededCount, Lib3MF::sCompositeConstituent * pCompositeBuffer) = 0;

};

typedef IBaseSharedPtr<ICompositeMaterials> PICompositeMaterials;


/*************************************************************************************************************************
 Class interface for MultiPropertyGroup 
**************************************************************************************************************************/

class IMultiPropertyGroup : public virtual IResource {
public:
	/**
	* IMultiPropertyGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xB989E02E43158FE6UL; // First 64 bits of SHA1 of a string: "Lib3MF::MultiPropertyGroup"
	}

	/**
	* IMultiPropertyGroup::GetCount - Retrieves the count of MultiProperty-s in the MultiPropertyGroup.
	* @return returns the count of MultiProperty-s
	*/
	virtual Lib3MF_uint32 GetCount() = 0;

	/**
	* IMultiPropertyGroup::GetAllPropertyIDs - returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of PropertyID of the MultiProperty-s in the MultiPropertyGroup.
	*/
	virtual void GetAllPropertyIDs(Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IMultiPropertyGroup::AddMultiProperty - Adds a new MultiProperty to the MultiPropertyGroup.
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[in] pPropertyIDsBuffer - The PropertyIDs of the new MultiProperty.
	* @return returns the PropertyID of the new MultiProperty in the MultiPropertyGroup.
	*/
	virtual Lib3MF_uint32 AddMultiProperty(const Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IMultiPropertyGroup::SetMultiProperty - Sets the PropertyIDs of a MultiProperty.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be changed.
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[in] pPropertyIDsBuffer - The new PropertyIDs of the MultiProperty
	*/
	virtual void SetMultiProperty(const Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IMultiPropertyGroup::GetMultiProperty - Obtains the PropertyIDs of a MultiProperty.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be queried.
	* @param[in] nPropertyIDsBufferSize - Number of elements in buffer
	* @param[out] pPropertyIDsNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pPropertyIDsBuffer - uint32 buffer of The PropertyIDs of the MultiProperty
	*/
	virtual void GetMultiProperty(const Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer) = 0;

	/**
	* IMultiPropertyGroup::RemoveMultiProperty - Removes a MultiProperty from this MultiPropertyGroup.
	* @param[in] nPropertyID - the PropertyID of the MultiProperty to be removed.
	*/
	virtual void RemoveMultiProperty(const Lib3MF_uint32 nPropertyID) = 0;

	/**
	* IMultiPropertyGroup::GetLayerCount - Retrieves the number of layers of this MultiPropertyGroup.
	* @return returns the number of layers
	*/
	virtual Lib3MF_uint32 GetLayerCount() = 0;

	/**
	* IMultiPropertyGroup::AddLayer - Adds a MultiPropertyLayer to this MultiPropertyGroup.
	* @param[in] TheLayer - The MultiPropertyLayer to add to this MultiPropertyGroup
	* @return returns the index of this MultiPropertyLayer
	*/
	virtual Lib3MF_uint32 AddLayer(const Lib3MF::sMultiPropertyLayer TheLayer) = 0;

	/**
	* IMultiPropertyGroup::GetLayer - Obtains a MultiPropertyLayer of this MultiPropertyGroup.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer queried
	* @return The MultiPropertyLayer with index LayerIndex within MultiPropertyGroup
	*/
	virtual Lib3MF::sMultiPropertyLayer GetLayer(const Lib3MF_uint32 nLayerIndex) = 0;

	/**
	* IMultiPropertyGroup::RemoveLayer - Removes a MultiPropertyLayer from this MultiPropertyGroup.
	* @param[in] nLayerIndex - The Index of the MultiPropertyLayer to be removed
	*/
	virtual void RemoveLayer(const Lib3MF_uint32 nLayerIndex) = 0;

};

typedef IBaseSharedPtr<IMultiPropertyGroup> PIMultiPropertyGroup;


/*************************************************************************************************************************
 Class interface for Attachment 
**************************************************************************************************************************/

class IAttachment : public virtual IBase {
public:
	/**
	* IAttachment::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x8CE7A1191A63A35DUL; // First 64 bits of SHA1 of a string: "Lib3MF::Attachment"
	}

	/**
	* IAttachment::GetPath - Retrieves an attachment's package path. This function will be removed in a later release.
	* @return returns the attachment's package path string
	*/
	virtual std::string GetPath() = 0;

	/**
	* IAttachment::SetPath - Sets an attachment's package path. This function will be removed in a later release.
	* @param[in] sPath - new path of the attachment.
	*/
	virtual void SetPath(const std::string & sPath) = 0;

	/**
	* IAttachment::PackagePart - Returns the PackagePart that is this attachment.
	* @return The PackagePart of this attachment.
	*/
	virtual IPackagePart * PackagePart() = 0;

	/**
	* IAttachment::GetRelationShipType - Retrieves an attachment's relationship type
	* @return returns the attachment's package relationship type string
	*/
	virtual std::string GetRelationShipType() = 0;

	/**
	* IAttachment::SetRelationShipType - Sets an attachment's relationship type.
	* @param[in] sPath - new relationship type string.
	*/
	virtual void SetRelationShipType(const std::string & sPath) = 0;

	/**
	* IAttachment::WriteToFile - Writes out the attachment as file.
	* @param[in] sFileName - file to write into.
	*/
	virtual void WriteToFile(const std::string & sFileName) = 0;

	/**
	* IAttachment::ReadFromFile - Reads an attachment from a file. The path of this file is only read when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
	* @param[in] sFileName - file to read from.
	*/
	virtual void ReadFromFile(const std::string & sFileName) = 0;

	/**
	* IAttachment::ReadFromCallback - Reads an attachment from the data provided by a callback function. This callback function is only invoked when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
	* @param[in] pTheReadCallback - callback function
	* @param[in] nStreamSize - number of bytes the callback returns
	* @param[in] pTheSeekCallback - callback function
	* @param[in] nUserData - Userdata that is passed to the callback function
	*/
	virtual void ReadFromCallback(const Lib3MF::ReadCallback pTheReadCallback, const Lib3MF_uint64 nStreamSize, const Lib3MF::SeekCallback pTheSeekCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IAttachment::GetStreamSize - Retrieves the size of the attachment stream
	* @return the stream size
	*/
	virtual Lib3MF_uint64 GetStreamSize() = 0;

	/**
	* IAttachment::WriteToBuffer - Writes out the attachment into a buffer
	* @param[in] nBufferBufferSize - Number of elements in buffer
	* @param[out] pBufferNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pBufferBuffer - uint8 buffer of Buffer to write into
	*/
	virtual void WriteToBuffer(Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer) = 0;

	/**
	* IAttachment::ReadFromBuffer - Reads an attachment from a memory buffer. This buffer is immediatly read (in contrast to the ReadFromCallback and ReadFromFile-methods).
	* @param[in] nBufferBufferSize - Number of elements in buffer
	* @param[in] pBufferBuffer - Buffer to read from
	*/
	virtual void ReadFromBuffer(const Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer) = 0;

};

typedef IBaseSharedPtr<IAttachment> PIAttachment;


/*************************************************************************************************************************
 Class interface for Texture2D 
**************************************************************************************************************************/

class ITexture2D : public virtual IResource {
public:
	/**
	* ITexture2D::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xE0441CF976B36319UL; // First 64 bits of SHA1 of a string: "Lib3MF::Texture2D"
	}

	/**
	* ITexture2D::GetAttachment - Retrieves the attachment located at the path of the texture.
	* @return attachment that holds the texture's image information.
	*/
	virtual IAttachment * GetAttachment() = 0;

	/**
	* ITexture2D::SetAttachment - Sets the texture's package path to the path of the attachment.
	* @param[in] pAttachment - attachment that holds the texture's image information.
	*/
	virtual void SetAttachment(IAttachment* pAttachment) = 0;

	/**
	* ITexture2D::GetContentType - Retrieves a texture's content type.
	* @return returns content type enum.
	*/
	virtual Lib3MF::eTextureType GetContentType() = 0;

	/**
	* ITexture2D::SetContentType - Retrieves a texture's content type.
	* @param[in] eContentType - new Content Type
	*/
	virtual void SetContentType(const Lib3MF::eTextureType eContentType) = 0;

	/**
	* ITexture2D::GetTileStyleUV - Retrieves a texture's tilestyle type.
	* @param[out] eTileStyleU - returns tilestyle type enum.
	* @param[out] eTileStyleV - returns tilestyle type enum.
	*/
	virtual void GetTileStyleUV(Lib3MF::eTextureTileStyle & eTileStyleU, Lib3MF::eTextureTileStyle & eTileStyleV) = 0;

	/**
	* ITexture2D::SetTileStyleUV - Sets a texture's tilestyle type.
	* @param[in] eTileStyleU - new tilestyle type enum.
	* @param[in] eTileStyleV - new tilestyle type enum.
	*/
	virtual void SetTileStyleUV(const Lib3MF::eTextureTileStyle eTileStyleU, const Lib3MF::eTextureTileStyle eTileStyleV) = 0;

	/**
	* ITexture2D::GetFilter - Retrieves a texture's filter type.
	* @return returns filter type enum.
	*/
	virtual Lib3MF::eTextureFilter GetFilter() = 0;

	/**
	* ITexture2D::SetFilter - Sets a texture's filter type.
	* @param[in] eFilter - sets new filter type enum.
	*/
	virtual void SetFilter(const Lib3MF::eTextureFilter eFilter) = 0;

};

typedef IBaseSharedPtr<ITexture2D> PITexture2D;


/*************************************************************************************************************************
 Class interface for BuildItem 
**************************************************************************************************************************/

class IBuildItem : public virtual IBase {
public:
	/**
	* IBuildItem::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x68FB2D5FFC4BA12AUL; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItem"
	}

	/**
	* IBuildItem::GetObjectResource - Retrieves the object resource associated to a build item
	* @return returns the associated resource instance
	*/
	virtual IObject * GetObjectResource() = 0;

	/**
	* IBuildItem::GetUUID - returns, whether a build item has a UUID and, if true, the build item's UUID
	* @param[out] bHasUUID - flag whether the build item has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual std::string GetUUID(bool & bHasUUID) = 0;

	/**
	* IBuildItem::SetUUID - sets the build item's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual void SetUUID(const std::string & sUUID) = 0;

	/**
	* IBuildItem::GetObjectResourceID - Retrieves the object UniqueResourceID associated to a build item
	* @return returns the UniqueResourceID of the object
	*/
	virtual Lib3MF_uint32 GetObjectResourceID() = 0;

	/**
	* IBuildItem::HasObjectTransform - Checks, if a build item has a non-identity transformation matrix
	* @return returns true, if the transformation matrix is not the identity
	*/
	virtual bool HasObjectTransform() = 0;

	/**
	* IBuildItem::GetObjectTransform - Retrieves a build item's transformation matrix.
	* @return returns the transformation matrix
	*/
	virtual Lib3MF::sTransform GetObjectTransform() = 0;

	/**
	* IBuildItem::SetObjectTransform - Sets a build item's transformation matrix.
	* @param[in] Transform - new transformation matrix
	*/
	virtual void SetObjectTransform(const Lib3MF::sTransform Transform) = 0;

	/**
	* IBuildItem::GetPartNumber - Retrieves a build item's part number string
	* @return Returns a build item's part number string
	*/
	virtual std::string GetPartNumber() = 0;

	/**
	* IBuildItem::SetPartNumber - Sets a build item's part number string
	* @param[in] sSetPartnumber - new part number string for referencing parts from the outside world
	*/
	virtual void SetPartNumber(const std::string & sSetPartnumber) = 0;

	/**
	* IBuildItem::GetMetaDataGroup - Returns the metadatagroup of this build item
	* @return returns an Instance of the metadatagroup of this build item
	*/
	virtual IMetaDataGroup * GetMetaDataGroup() = 0;

	/**
	* IBuildItem::GetOutbox - Returns the outbox of a build item
	* @return Outbox of this build item
	*/
	virtual Lib3MF::sBox GetOutbox() = 0;

};

typedef IBaseSharedPtr<IBuildItem> PIBuildItem;


/*************************************************************************************************************************
 Class interface for BuildItemIterator 
**************************************************************************************************************************/

class IBuildItemIterator : public virtual IBase {
public:
	/**
	* IBuildItemIterator::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xA7D21BD364910860UL; // First 64 bits of SHA1 of a string: "Lib3MF::BuildItemIterator"
	}

	/**
	* IBuildItemIterator::MoveNext - Iterates to the next build item in the list.
	* @return Iterates to the next build item in the list.
	*/
	virtual bool MoveNext() = 0;

	/**
	* IBuildItemIterator::MovePrevious - Iterates to the previous build item in the list.
	* @return Iterates to the previous build item in the list.
	*/
	virtual bool MovePrevious() = 0;

	/**
	* IBuildItemIterator::GetCurrent - Returns the build item the iterator points at.
	* @return returns the build item instance.
	*/
	virtual IBuildItem * GetCurrent() = 0;

	/**
	* IBuildItemIterator::Clone - Creates a new build item iterator with the same build item list.
	* @return returns the cloned Iterator instance
	*/
	virtual IBuildItemIterator * Clone() = 0;

	/**
	* IBuildItemIterator::Count - Returns the number of build items the iterator captures.
	* @return returns the number of build items the iterator captures.
	*/
	virtual Lib3MF_uint64 Count() = 0;

};

typedef IBaseSharedPtr<IBuildItemIterator> PIBuildItemIterator;


/*************************************************************************************************************************
 Class interface for Slice 
**************************************************************************************************************************/

class ISlice : public virtual IBase {
public:
	/**
	* ISlice::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x2198BCF4D8DF9C40UL; // First 64 bits of SHA1 of a string: "Lib3MF::Slice"
	}

	/**
	* ISlice::SetVertices - Set all vertices of a slice. All polygons will be cleared.
	* @param[in] nVerticesBufferSize - Number of elements in buffer
	* @param[in] pVerticesBuffer - contains the positions.
	*/
	virtual void SetVertices(const Lib3MF_uint64 nVerticesBufferSize, const Lib3MF::sPosition2D * pVerticesBuffer) = 0;

	/**
	* ISlice::GetVertices - Get all vertices of a slice
	* @param[in] nVerticesBufferSize - Number of elements in buffer
	* @param[out] pVerticesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pVerticesBuffer - Position2D buffer of contains the positions.
	*/
	virtual void GetVertices(Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, Lib3MF::sPosition2D * pVerticesBuffer) = 0;

	/**
	* ISlice::GetVertexCount - Get the number of vertices in a slice
	* @return the number of vertices in the slice
	*/
	virtual Lib3MF_uint64 GetVertexCount() = 0;

	/**
	* ISlice::AddPolygon - Add a new polygon to this slice
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[in] pIndicesBuffer - the new indices of the new polygon
	* @return the index of the new polygon
	*/
	virtual Lib3MF_uint64 AddPolygon(const Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer) = 0;

	/**
	* ISlice::GetPolygonCount - Get the number of polygons in the slice
	* @return the number of polygons in the slice
	*/
	virtual Lib3MF_uint64 GetPolygonCount() = 0;

	/**
	* ISlice::SetPolygonIndices - Set all indices of a polygon
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[in] pIndicesBuffer - the new indices of the index-th polygon
	*/
	virtual void SetPolygonIndices(const Lib3MF_uint64 nIndex, const Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer) = 0;

	/**
	* ISlice::GetPolygonIndices - Get all vertices of a slice
	* @param[in] nIndex - the index of the polygon to manipulate
	* @param[in] nIndicesBufferSize - Number of elements in buffer
	* @param[out] pIndicesNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pIndicesBuffer - uint32 buffer of the indices of the index-th polygon 
	*/
	virtual void GetPolygonIndices(const Lib3MF_uint64 nIndex, Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF_uint32 * pIndicesBuffer) = 0;

	/**
	* ISlice::GetPolygonIndexCount - Get the number of vertices in a slice
	* @param[in] nIndex - the index of the polygon to manipulate
	* @return the number of indices of the index-th polygon
	*/
	virtual Lib3MF_uint64 GetPolygonIndexCount(const Lib3MF_uint64 nIndex) = 0;

	/**
	* ISlice::GetZTop - Get the upper Z-Coordinate of this slice.
	* @return the upper Z-Coordinate of this slice
	*/
	virtual Lib3MF_double GetZTop() = 0;

};

typedef IBaseSharedPtr<ISlice> PISlice;


/*************************************************************************************************************************
 Class interface for SliceStack 
**************************************************************************************************************************/

class ISliceStack : public virtual IResource {
public:
	/**
	* ISliceStack::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x6594B031B6096238UL; // First 64 bits of SHA1 of a string: "Lib3MF::SliceStack"
	}

	/**
	* ISliceStack::GetBottomZ - Get the lower Z-Coordinate of the slice stack.
	* @return the lower Z-Coordinate the slice stack
	*/
	virtual Lib3MF_double GetBottomZ() = 0;

	/**
	* ISliceStack::GetSliceCount - Returns the number of slices
	* @return the number of slices
	*/
	virtual Lib3MF_uint64 GetSliceCount() = 0;

	/**
	* ISliceStack::GetSlice - Query a slice from the slice stack
	* @param[in] nSliceIndex - the index of the slice
	* @return the Slice instance
	*/
	virtual ISlice * GetSlice(const Lib3MF_uint64 nSliceIndex) = 0;

	/**
	* ISliceStack::AddSlice - Returns the number of slices
	* @param[in] dZTop - upper Z coordinate of the slice
	* @return a new Slice instance
	*/
	virtual ISlice * AddSlice(const Lib3MF_double dZTop) = 0;

	/**
	* ISliceStack::GetSliceRefCount - Returns the number of slice refs
	* @return the number of slicereferences
	*/
	virtual Lib3MF_uint64 GetSliceRefCount() = 0;

	/**
	* ISliceStack::AddSliceStackReference - Adds another existing slicestack as sliceref in this slicestack
	* @param[in] pTheSliceStack - the slicestack to use as sliceref
	*/
	virtual void AddSliceStackReference(ISliceStack* pTheSliceStack) = 0;

	/**
	* ISliceStack::GetSliceStackReference - Adds another existing slicestack as sliceref in this slicestack
	* @param[in] nSliceRefIndex - the index of the slice ref
	* @return the slicestack that is used as sliceref
	*/
	virtual ISliceStack * GetSliceStackReference(const Lib3MF_uint64 nSliceRefIndex) = 0;

	/**
	* ISliceStack::CollapseSliceReferences - Removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
	*/
	virtual void CollapseSliceReferences() = 0;

	/**
	* ISliceStack::SetOwnPath - Sets the package path where this Slice should be stored. Input an empty string to reset the path
	* @param[in] sPath - the package path where this Slice should be stored
	*/
	virtual void SetOwnPath(const std::string & sPath) = 0;

	/**
	* ISliceStack::GetOwnPath - Obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
	* @return the package path where this Slice will be stored
	*/
	virtual std::string GetOwnPath() = 0;

};

typedef IBaseSharedPtr<ISliceStack> PISliceStack;


/*************************************************************************************************************************
 Class interface for Consumer 
**************************************************************************************************************************/

class IConsumer : public virtual IBase {
public:
	/**
	* IConsumer::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD9E46D5E6D8118EEUL; // First 64 bits of SHA1 of a string: "Lib3MF::Consumer"
	}

	/**
	* IConsumer::GetConsumerID - Gets the consumerid
	* @return A unique identifier for the consumers
	*/
	virtual std::string GetConsumerID() = 0;

	/**
	* IConsumer::GetKeyID - Getts the keyid
	* @return The identifier for the key of this consumer
	*/
	virtual std::string GetKeyID() = 0;

	/**
	* IConsumer::GetKeyValue - Gets the keyvalue associated with this consumer
	* @return The public key, when available, of this consumer
	*/
	virtual std::string GetKeyValue() = 0;

};

typedef IBaseSharedPtr<IConsumer> PIConsumer;


/*************************************************************************************************************************
 Class interface for AccessRight 
**************************************************************************************************************************/

class IAccessRight : public virtual IBase {
public:
	/**
	* IAccessRight::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x385C42FC5609498AUL; // First 64 bits of SHA1 of a string: "Lib3MF::AccessRight"
	}

	/**
	* IAccessRight::GetConsumer - Gets the consumer associated with this access right
	* @return The consumer instance
	*/
	virtual IConsumer * GetConsumer() = 0;

	/**
	* IAccessRight::GetWrappingAlgorithm - Gets the associated encryption algorithm
	* @return The algorithm used for the key in this accessright
	*/
	virtual Lib3MF::eWrappingAlgorithm GetWrappingAlgorithm() = 0;

	/**
	* IAccessRight::GetMgfAlgorithm - Gets the associated mask generation function algorithm
	* @return The MFG1 algorithm
	*/
	virtual Lib3MF::eMgfAlgorithm GetMgfAlgorithm() = 0;

	/**
	* IAccessRight::GetDigestMethod - Gets the digest method assoicated
	* @return The digest method for this accessright
	*/
	virtual Lib3MF::eDigestMethod GetDigestMethod() = 0;

};

typedef IBaseSharedPtr<IAccessRight> PIAccessRight;


/*************************************************************************************************************************
 Class interface for ContentEncryptionParams 
**************************************************************************************************************************/

class IContentEncryptionParams : public virtual IBase {
public:
	/**
	* IContentEncryptionParams::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x7FB36B91D4CE4671UL; // First 64 bits of SHA1 of a string: "Lib3MF::ContentEncryptionParams"
	}

	/**
	* IContentEncryptionParams::GetEncryptionAlgorithm - Returns the encryption method to be used in this encryption process
	* @return 
	*/
	virtual Lib3MF::eEncryptionAlgorithm GetEncryptionAlgorithm() = 0;

	/**
	* IContentEncryptionParams::GetKey - Gets the key for the resource associated
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the key.
	*/
	virtual void GetKey(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::GetInitializationVector - Gets the IV data
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the data.
	*/
	virtual void GetInitializationVector(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::GetAuthenticationTag - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Pointer to a buffer where to place the data.
	*/
	virtual void GetAuthenticationTag(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::SetAuthenticationTag - Sets the authentication tag
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[in] pByteDataBuffer - The authentication tag size
	*/
	virtual void SetAuthenticationTag(const Lib3MF_uint64 nByteDataBufferSize, const Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::GetAdditionalAuthenticationData - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of Buffer where the data will be placed
	*/
	virtual void GetAdditionalAuthenticationData(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

	/**
	* IContentEncryptionParams::GetDescriptor - A handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value
	* @return 
	*/
	virtual Lib3MF_uint64 GetDescriptor() = 0;

	/**
	* IContentEncryptionParams::GetKeyUUID - Gets the resourcedatagroup keyuuid
	* @return The resourcedatagroup keyuuid that may be use to reference an external key
	*/
	virtual std::string GetKeyUUID() = 0;

};

typedef IBaseSharedPtr<IContentEncryptionParams> PIContentEncryptionParams;


/*************************************************************************************************************************
 Class interface for ResourceData 
**************************************************************************************************************************/

class IResourceData : public virtual IBase {
public:
	/**
	* IResourceData::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x1A47A5E258E22EF9UL; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceData"
	}

	/**
	* IResourceData::GetPath - Gets the encrypted part path
	* @return The part path
	*/
	virtual IPackagePart * GetPath() = 0;

	/**
	* IResourceData::GetEncryptionAlgorithm - Gets the encryption algorithm used to encrypt this ResourceData
	* @return The encryption algorithm
	*/
	virtual Lib3MF::eEncryptionAlgorithm GetEncryptionAlgorithm() = 0;

	/**
	* IResourceData::GetCompression - Tells whether this ResourceData is compressed or not
	* @return The compression method
	*/
	virtual Lib3MF::eCompression GetCompression() = 0;

	/**
	* IResourceData::GetAdditionalAuthenticationData - Tells whether this ResourceData is compressed or not
	* @param[in] nByteDataBufferSize - Number of elements in buffer
	* @param[out] pByteDataNeededCount - will be filled with the count of the written structs, or needed buffer size.
	* @param[out] pByteDataBuffer - uint8 buffer of The compression method
	*/
	virtual void GetAdditionalAuthenticationData(Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer) = 0;

};

typedef IBaseSharedPtr<IResourceData> PIResourceData;


/*************************************************************************************************************************
 Class interface for ResourceDataGroup 
**************************************************************************************************************************/

class IResourceDataGroup : public virtual IBase {
public:
	/**
	* IResourceDataGroup::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0xD59067227E428AA4UL; // First 64 bits of SHA1 of a string: "Lib3MF::ResourceDataGroup"
	}

	/**
	* IResourceDataGroup::GetKeyUUID - Sets the resourcedatagroup keyuuid
	* @return The new resourcedatagroup keyuuid.
	*/
	virtual std::string GetKeyUUID() = 0;

	/**
	* IResourceDataGroup::AddAccessRight - Add accessright to resourcedatagroup element
	* @param[in] pConsumer - The Consumer reference
	* @param[in] eWrappingAlgorithm - The key wrapping algorithm to be used
	* @param[in] eMgfAlgorithm - The mask generation function to be used
	* @param[in] eDigestMethod - The digest mechanism to be used
	* @return The acess right instance
	*/
	virtual IAccessRight * AddAccessRight(IConsumer* pConsumer, const Lib3MF::eWrappingAlgorithm eWrappingAlgorithm, const Lib3MF::eMgfAlgorithm eMgfAlgorithm, const Lib3MF::eDigestMethod eDigestMethod) = 0;

	/**
	* IResourceDataGroup::FindAccessRightByConsumer - Finds the AccessRight associated with a Consumer
	* @param[in] pConsumer - The Consumer instance
	* @return The AcessRight instance
	*/
	virtual IAccessRight * FindAccessRightByConsumer(IConsumer* pConsumer) = 0;

	/**
	* IResourceDataGroup::RemoveAccessRight - Removes access from a Consumer on this resource data group
	* @param[in] pConsumer - The Consumer instance
	*/
	virtual void RemoveAccessRight(IConsumer* pConsumer) = 0;

};

typedef IBaseSharedPtr<IResourceDataGroup> PIResourceDataGroup;


/*************************************************************************************************************************
 Class interface for KeyStore 
**************************************************************************************************************************/

class IKeyStore : public virtual IBase {
public:
	/**
	* IKeyStore::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x1CC9E0CC082253C6UL; // First 64 bits of SHA1 of a string: "Lib3MF::KeyStore"
	}

	/**
	* IKeyStore::AddConsumer - Adds a consumer to the keystore
	* @param[in] sConsumerID - A unique identifier for the consumer
	* @param[in] sKeyID - The id of the key of the consumer
	* @param[in] sKeyValue - The public key for this consumer in PEM format
	* @return The consumer instance
	*/
	virtual IConsumer * AddConsumer(const std::string & sConsumerID, const std::string & sKeyID, const std::string & sKeyValue) = 0;

	/**
	* IKeyStore::GetConsumerCount - Gets the number of consumers in the keystore
	* @return The consumer count
	*/
	virtual Lib3MF_uint64 GetConsumerCount() = 0;

	/**
	* IKeyStore::GetConsumer - Get a consumer from the keystore
	* @param[in] nConsumerIndex - The index of the consumer
	* @return The consumer instance
	*/
	virtual IConsumer * GetConsumer(const Lib3MF_uint64 nConsumerIndex) = 0;

	/**
	* IKeyStore::RemoveConsumer - Removes a consumer from the keystore
	* @param[in] pConsumer - The consumer instance to remove
	*/
	virtual void RemoveConsumer(IConsumer* pConsumer) = 0;

	/**
	* IKeyStore::FindConsumer - Finds a consumer by ID
	* @param[in] sConsumerID - The ID of the consumer
	* @return The consumer instance
	*/
	virtual IConsumer * FindConsumer(const std::string & sConsumerID) = 0;

	/**
	* IKeyStore::GetResourceDataGroupCount - Gets the number of resource data group in the keysore
	* @return The number of resource data available
	*/
	virtual Lib3MF_uint64 GetResourceDataGroupCount() = 0;

	/**
	* IKeyStore::AddResourceDataGroup - Adds a resource data group into the keystore.
	* @return The resource data group instance
	*/
	virtual IResourceDataGroup * AddResourceDataGroup() = 0;

	/**
	* IKeyStore::GetResourceDataGroup - Gets a resource data group
	* @param[in] nResourceDataIndex - The index of the resource data
	* @return The resource data group instance
	*/
	virtual IResourceDataGroup * GetResourceDataGroup(const Lib3MF_uint64 nResourceDataIndex) = 0;

	/**
	* IKeyStore::RemoveResourceDataGroup - Removes a resource data group
	* @param[in] pResourceDataGroup - The resource data group instance
	*/
	virtual void RemoveResourceDataGroup(IResourceDataGroup* pResourceDataGroup) = 0;

	/**
	* IKeyStore::FindResourceDataGroup - Finds a resource data group that contains a particular resourcedata
	* @param[in] pPartPath - The target path for the resourcedata hold by the resource data group
	* @return The data resource instance
	*/
	virtual IResourceDataGroup * FindResourceDataGroup(IPackagePart* pPartPath) = 0;

	/**
	* IKeyStore::AddResourceData - Add resourcedata to resourcedatagroup element
	* @param[in] pResourceDataGroup - The resource data group where to add this resource data
	* @param[in] pPartPath - The path of the part to be encrypted
	* @param[in] eAlgorithm - The encryption algorithm to be used to encrypt this resource
	* @param[in] eCompression - Whether compression should be used prior to encryption
	* @param[in] nAdditionalAuthenticationDataBufferSize - Number of elements in buffer
	* @param[in] pAdditionalAuthenticationDataBuffer - Additional data to be encrypted along the contents for better security
	* @return The data resource instance
	*/
	virtual IResourceData * AddResourceData(IResourceDataGroup* pResourceDataGroup, IPackagePart* pPartPath, const Lib3MF::eEncryptionAlgorithm eAlgorithm, const Lib3MF::eCompression eCompression, const Lib3MF_uint64 nAdditionalAuthenticationDataBufferSize, const Lib3MF_uint8 * pAdditionalAuthenticationDataBuffer) = 0;

	/**
	* IKeyStore::RemoveResourceData - Removes a resource data
	* @param[in] pResourceData - The resource data to be removed
	*/
	virtual void RemoveResourceData(IResourceData* pResourceData) = 0;

	/**
	* IKeyStore::FindResourceData - Finds a resource data on this resource group
	* @param[in] pResourcePath - The target path for the resourcedata
	* @return The resource data instance
	*/
	virtual IResourceData * FindResourceData(IPackagePart* pResourcePath) = 0;

	/**
	* IKeyStore::GetResourceDataCount - Gets the number of resource data in the keysore
	* @return The number of resource data available
	*/
	virtual Lib3MF_uint64 GetResourceDataCount() = 0;

	/**
	* IKeyStore::GetResourceData - Gets a resource data
	* @param[in] nResourceDataIndex - The index of the resource data
	* @return The data resource instance
	*/
	virtual IResourceData * GetResourceData(const Lib3MF_uint64 nResourceDataIndex) = 0;

	/**
	* IKeyStore::GetUUID - Gets the keystore UUID
	* @param[out] bHasUUID - flag whether the keystore has a UUID
	* @return returns the keystore uuid.
	*/
	virtual std::string GetUUID(bool & bHasUUID) = 0;

	/**
	* IKeyStore::SetUUID - Sets the keystore UUID
	* @param[in] sUUID - The new keystore uuid.
	*/
	virtual void SetUUID(const std::string & sUUID) = 0;

};

typedef IBaseSharedPtr<IKeyStore> PIKeyStore;


/*************************************************************************************************************************
 Class interface for Model 
**************************************************************************************************************************/

class IModel : public virtual IBase {
public:
	/**
	* IModel::ClassTypeId - Get Class Type Id
	* @return Class type as a 64 bits integer
	*/
	Lib3MF_uint64 ClassTypeId() override
	{
		return 0x5A8164ECEDB03F09UL; // First 64 bits of SHA1 of a string: "Lib3MF::Model"
	}

	/**
	* IModel::RootModelPart - Returns the PackagePart within the OPC package that holds the root model.
	* @return the PackagePart within the OPC package that holds the model-file
	*/
	virtual IPackagePart * RootModelPart() = 0;

	/**
	* IModel::FindOrCreatePackagePart - Returns a new PackagePart for use within the OPC package.
	* @param[in] sAbsolutePath - the absolute Path (physical location) within the OPC package
	* @return the new PackagePart within the OPC package
	*/
	virtual IPackagePart * FindOrCreatePackagePart(const std::string & sAbsolutePath) = 0;

	/**
	* IModel::SetUnit - sets the units of a model.
	* @param[in] eUnit - Unit enum value for the model unit
	*/
	virtual void SetUnit(const Lib3MF::eModelUnit eUnit) = 0;

	/**
	* IModel::GetUnit - returns the units of a model.
	* @return Unit enum value for the model unit
	*/
	virtual Lib3MF::eModelUnit GetUnit() = 0;

	/**
	* IModel::GetLanguage - retrieves the language of a model
	* @return language identifier
	*/
	virtual std::string GetLanguage() = 0;

	/**
	* IModel::SetLanguage - sets the language of a model
	* @param[in] sLanguage - language identifier
	*/
	virtual void SetLanguage(const std::string & sLanguage) = 0;

	/**
	* IModel::QueryWriter - creates a model writer instance for a specific file type
	* @param[in] sWriterClass -  string identifier for the file type
	* @return  string identifier for the file type
	*/
	virtual IWriter * QueryWriter(const std::string & sWriterClass) = 0;

	/**
	* IModel::QueryReader - creates a model reader instance for a specific file type
	* @param[in] sReaderClass -  string identifier for the file type
	* @return  string identifier for the file type
	*/
	virtual IReader * QueryReader(const std::string & sReaderClass) = 0;

	/**
	* IModel::GetResourceByID - finds a model resource by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the resource instance
	*/
	virtual IResource * GetResourceByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetTexture2DByID - finds a model texture by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the texture2d instance
	*/
	virtual ITexture2D * GetTexture2DByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetPropertyTypeByID - returns a Property's type
	* @param[in] nUniqueResourceID - Resource ID of the Property to Query
	* @return returns a Property's type
	*/
	virtual Lib3MF::ePropertyType GetPropertyTypeByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetBaseMaterialGroupByID - finds a model base material group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the BaseMaterialGroup instance
	*/
	virtual IBaseMaterialGroup * GetBaseMaterialGroupByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetTexture2DGroupByID - finds a model texture2d group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the Texture2DGroup instance
	*/
	virtual ITexture2DGroup * GetTexture2DGroupByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetCompositeMaterialsByID - finds a model CompositeMaterials by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the CompositeMaterials instance
	*/
	virtual ICompositeMaterials * GetCompositeMaterialsByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetMultiPropertyGroupByID - finds a model MultiPropertyGroup by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the MultiPropertyGroup instance
	*/
	virtual IMultiPropertyGroup * GetMultiPropertyGroupByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetMeshObjectByID - finds a mesh object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the mesh object instance
	*/
	virtual IMeshObject * GetMeshObjectByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetComponentsObjectByID - finds a components object by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the components object instance
	*/
	virtual IComponentsObject * GetComponentsObjectByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetColorGroupByID - finds a model color group by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the ColorGroup instance
	*/
	virtual IColorGroup * GetColorGroupByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetSliceStackByID - finds a model slicestack by its UniqueResourceID
	* @param[in] nUniqueResourceID - UniqueResourceID
	* @return returns the slicestack instance
	*/
	virtual ISliceStack * GetSliceStackByID(const Lib3MF_uint32 nUniqueResourceID) = 0;

	/**
	* IModel::GetBuildUUID - returns, whether a build has a UUID and, if true, the build's UUID
	* @param[out] bHasUUID - flag whether the build has a UUID
	* @return the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual std::string GetBuildUUID(bool & bHasUUID) = 0;

	/**
	* IModel::SetBuildUUID - sets the build's UUID
	* @param[in] sUUID - the UUID as string of the form 'xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx'
	*/
	virtual void SetBuildUUID(const std::string & sUUID) = 0;

	/**
	* IModel::GetBuildItems - creates a build item iterator instance with all build items.
	* @return returns the iterator instance.
	*/
	virtual IBuildItemIterator * GetBuildItems() = 0;

	/**
	* IModel::GetOutbox - Returns the outbox of a Model
	* @return Outbox of this Model
	*/
	virtual Lib3MF::sBox GetOutbox() = 0;

	/**
	* IModel::GetResources - creates a resource iterator instance with all resources.
	* @return returns the iterator instance.
	*/
	virtual IResourceIterator * GetResources() = 0;

	/**
	* IModel::GetObjects - creates a resource iterator instance with all object resources.
	* @return returns the iterator instance.
	*/
	virtual IObjectIterator * GetObjects() = 0;

	/**
	* IModel::GetMeshObjects - creates a resource iterator instance with all mesh object resources.
	* @return returns the iterator instance.
	*/
	virtual IMeshObjectIterator * GetMeshObjects() = 0;

	/**
	* IModel::GetComponentsObjects - creates a resource iterator instance with all components object resources.
	* @return returns the iterator instance.
	*/
	virtual IComponentsObjectIterator * GetComponentsObjects() = 0;

	/**
	* IModel::GetTexture2Ds - creates a Texture2DIterator instance with all texture2d resources.
	* @return returns the iterator instance.
	*/
	virtual ITexture2DIterator * GetTexture2Ds() = 0;

	/**
	* IModel::GetBaseMaterialGroups - creates a BaseMaterialGroupIterator instance with all base material resources.
	* @return returns the iterator instance.
	*/
	virtual IBaseMaterialGroupIterator * GetBaseMaterialGroups() = 0;

	/**
	* IModel::GetColorGroups - creates a ColorGroupIterator instance with all ColorGroup resources.
	* @return returns the iterator instance.
	*/
	virtual IColorGroupIterator * GetColorGroups() = 0;

	/**
	* IModel::GetTexture2DGroups - creates a Texture2DGroupIterator instance with all base material resources.
	* @return returns the iterator instance.
	*/
	virtual ITexture2DGroupIterator * GetTexture2DGroups() = 0;

	/**
	* IModel::GetCompositeMaterials - creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
	* @return returns the iterator instance.
	*/
	virtual ICompositeMaterialsIterator * GetCompositeMaterials() = 0;

	/**
	* IModel::GetMultiPropertyGroups - creates a MultiPropertyGroupsIterator instance with all MultiPropertyGroup resources.
	* @return returns the iterator instance.
	*/
	virtual IMultiPropertyGroupIterator * GetMultiPropertyGroups() = 0;

	/**
	* IModel::GetSliceStacks - creates a resource iterator instance with all slice stack resources.
	* @return returns the iterator instance.
	*/
	virtual ISliceStackIterator * GetSliceStacks() = 0;

	/**
	* IModel::MergeToModel - Merges all components and objects which are referenced by a build item into a mesh. The memory is duplicated and a new model is created.
	* @return returns the merged model instance
	*/
	virtual IModel * MergeToModel() = 0;

	/**
	* IModel::AddMeshObject - adds an empty mesh object to the model.
	* @return  returns the mesh object instance
	*/
	virtual IMeshObject * AddMeshObject() = 0;

	/**
	* IModel::AddComponentsObject - adds an empty component object to the model.
	* @return  returns the components object instance
	*/
	virtual IComponentsObject * AddComponentsObject() = 0;

	/**
	* IModel::AddSliceStack - creates a new model slicestack by its id
	* @param[in] dZBottom - Bottom Z value of the slicestack
	* @return returns the new slicestack instance
	*/
	virtual ISliceStack * AddSliceStack(const Lib3MF_double dZBottom) = 0;

	/**
	* IModel::AddTexture2DFromAttachment - adds a texture2d resource to the model. Its path is given by that of an existing attachment.
	* @param[in] pTextureAttachment - attachment containing the image data.
	* @return returns the new texture instance.
	*/
	virtual ITexture2D * AddTexture2DFromAttachment(IAttachment* pTextureAttachment) = 0;

	/**
	* IModel::AddBaseMaterialGroup - adds an empty BaseMaterialGroup resource to the model.
	* @return returns the new base material instance.
	*/
	virtual IBaseMaterialGroup * AddBaseMaterialGroup() = 0;

	/**
	* IModel::AddColorGroup - adds an empty ColorGroup resource to the model.
	* @return returns the new ColorGroup instance.
	*/
	virtual IColorGroup * AddColorGroup() = 0;

	/**
	* IModel::AddTexture2DGroup - adds an empty Texture2DGroup resource to the model.
	* @param[in] pTexture2DInstance - The texture2D instance of the created Texture2DGroup.
	* @return returns the new Texture2DGroup instance.
	*/
	virtual ITexture2DGroup * AddTexture2DGroup(ITexture2D* pTexture2DInstance) = 0;

	/**
	* IModel::AddCompositeMaterials - adds an empty CompositeMaterials resource to the model.
	* @param[in] pBaseMaterialGroupInstance - The BaseMaterialGroup instance of the created CompositeMaterials.
	* @return returns the new CompositeMaterials instance.
	*/
	virtual ICompositeMaterials * AddCompositeMaterials(IBaseMaterialGroup* pBaseMaterialGroupInstance) = 0;

	/**
	* IModel::AddMultiPropertyGroup - adds an empty MultiPropertyGroup resource to the model.
	* @return returns the new MultiPropertyGroup instance.
	*/
	virtual IMultiPropertyGroup * AddMultiPropertyGroup() = 0;

	/**
	* IModel::AddBuildItem - adds a build item to the model.
	* @param[in] pObject - Object instance.
	* @param[in] Transform - Transformation matrix.
	* @return returns the build item instance.
	*/
	virtual IBuildItem * AddBuildItem(IObject* pObject, const Lib3MF::sTransform Transform) = 0;

	/**
	* IModel::RemoveBuildItem - removes a build item from the model
	* @param[in] pBuildItemInstance - Build item to remove.
	*/
	virtual void RemoveBuildItem(IBuildItem* pBuildItemInstance) = 0;

	/**
	* IModel::GetMetaDataGroup - Returns the metadata of the model as MetaDataGroup
	* @return returns an Instance of the metadatagroup of the model
	*/
	virtual IMetaDataGroup * GetMetaDataGroup() = 0;

	/**
	* IModel::AddAttachment - adds an attachment stream to the model. The OPC part will be related to the model stream with a certain relationship type.
	* @param[in] sURI - Path of the attachment
	* @param[in] sRelationShipType - Relationship type of the attachment
	* @return Instance of the attachment object
	*/
	virtual IAttachment * AddAttachment(const std::string & sURI, const std::string & sRelationShipType) = 0;

	/**
	* IModel::RemoveAttachment - Removes attachment from the model.
	* @param[in] pAttachmentInstance - Attachment instance to remove
	*/
	virtual void RemoveAttachment(IAttachment* pAttachmentInstance) = 0;

	/**
	* IModel::GetAttachment - retrieves an attachment stream object from the model..
	* @param[in] nIndex - Index of the attachment stream
	* @return Instance of the attachment object
	*/
	virtual IAttachment * GetAttachment(const Lib3MF_uint32 nIndex) = 0;

	/**
	* IModel::FindAttachment - retrieves an attachment stream object from the model.
	* @param[in] sURI - Path URI in the package
	* @return Instance of the attachment object
	*/
	virtual IAttachment * FindAttachment(const std::string & sURI) = 0;

	/**
	* IModel::GetAttachmentCount - retrieves the number of attachments of the model.
	* @return Returns the number of attachments.
	*/
	virtual Lib3MF_uint32 GetAttachmentCount() = 0;

	/**
	* IModel::HasPackageThumbnailAttachment - Retrieve whether the OPC package contains a package thumbnail.
	* @return returns whether the OPC package contains a package thumbnail
	*/
	virtual bool HasPackageThumbnailAttachment() = 0;

	/**
	* IModel::CreatePackageThumbnailAttachment - Create a new or the existing package thumbnail for the OPC package.
	* @return Instance of a new or the existing thumbnailattachment object.
	*/
	virtual IAttachment * CreatePackageThumbnailAttachment() = 0;

	/**
	* IModel::GetPackageThumbnailAttachment - Get the attachment to the OPC package containing the package thumbnail.
	* @return Instance of the thumbnailattachment object or NULL.
	*/
	virtual IAttachment * GetPackageThumbnailAttachment() = 0;

	/**
	* IModel::RemovePackageThumbnailAttachment - Remove the attachment to the OPC package containing the package thumbnail.
	*/
	virtual void RemovePackageThumbnailAttachment() = 0;

	/**
	* IModel::AddCustomContentType - Adds a new Content Type to the model.
	* @param[in] sExtension - File Extension
	* @param[in] sContentType - Content Type Identifier
	*/
	virtual void AddCustomContentType(const std::string & sExtension, const std::string & sContentType) = 0;

	/**
	* IModel::RemoveCustomContentType - Removes a custom Content Type from the model (UTF8 version).
	* @param[in] sExtension - File Extension
	*/
	virtual void RemoveCustomContentType(const std::string & sExtension) = 0;

	/**
	* IModel::SetRandomNumberCallback - Sets the random number generator callback for use in the library
	* @param[in] pTheCallback - callback function
	* @param[in] nUserData - Userdata to be passed to the callback function
	*/
	virtual void SetRandomNumberCallback(const Lib3MF::RandomNumberCallback pTheCallback, const Lib3MF_pvoid pUserData) = 0;

	/**
	* IModel::GetKeyStore - Gets the keystore associated with this model
	* @return The package keystore
	*/
	virtual IKeyStore * GetKeyStore() = 0;

};

typedef IBaseSharedPtr<IModel> PIModel;


/*************************************************************************************************************************
 Global functions declarations
**************************************************************************************************************************/
class CWrapper {
public:
	/**
	* Ilib3mf::GetLibraryVersion - retrieves the binary version of this library.
	* @param[out] nMajor - returns the major version of this library
	* @param[out] nMinor - returns the minor version of this library
	* @param[out] nMicro - returns the micro version of this library
	*/
	static void GetLibraryVersion(Lib3MF_uint32 & nMajor, Lib3MF_uint32 & nMinor, Lib3MF_uint32 & nMicro);

	/**
	* Ilib3mf::GetPrereleaseInformation - retrieves prerelease information of this library.
	* @return Does the library provide prerelease version?
	* @param[out] sPrereleaseInfo - retrieves prerelease information of this library.
	*/
	static bool GetPrereleaseInformation(std::string & sPrereleaseInfo);

	/**
	* Ilib3mf::GetBuildInformation - retrieves build information of this library.
	* @return Does the library provide build version?
	* @param[out] sBuildInformation - retrieves build information of this library.
	*/
	static bool GetBuildInformation(std::string & sBuildInformation);

	/**
	* Ilib3mf::GetSpecificationVersion - retrieves whether a specification is supported, and if so, which version.
	* @param[in] sSpecificationURL - URL of extension to check
	* @param[out] bIsSupported - returns whether this specification is supported
	* @param[out] nMajor - returns the major version of the extension (if IsSupported)
	* @param[out] nMinor - returns the minor version of the extension (if IsSupported)
	* @param[out] nMicro - returns the micro version of the extension (if IsSupported)
	*/
	static void GetSpecificationVersion(const std::string & sSpecificationURL, bool & bIsSupported, Lib3MF_uint32 & nMajor, Lib3MF_uint32 & nMinor, Lib3MF_uint32 & nMicro);

	/**
	* Ilib3mf::CreateModel - creates an empty model instance.
	* @return returns an empty model instance
	*/
	static IModel * CreateModel();

	/**
	* Ilib3mf::Release - releases shared ownership of an object instance
	* @param[in] pInstance - the object instance to release
	*/
	static void Release(IBase* pInstance);

	/**
	* Ilib3mf::Acquire - acquires shared ownership of an object instance
	* @param[in] pInstance - the object instance to acquire
	*/
	static void Acquire(IBase* pInstance);

	/**
	* Ilib3mf::GetLastError - Retrieves the last error string of an instance
	* @param[in] pInstance - Object where the error occured.
	* @param[out] sLastErrorString - Last Error String
	* @return Returns if the instance has a last error.
	*/
	static bool GetLastError(IBase* pInstance, std::string & sLastErrorString);

	/**
	* Ilib3mf::RetrieveProgressMessage - Return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
	* @param[in] eTheProgressIdentifier - the progress identifier that is passed to the callback function
	* @param[out] sProgressMessage - English text for the progress identifier
	*/
	static void RetrieveProgressMessage(const Lib3MF::eProgressIdentifier eTheProgressIdentifier, std::string & sProgressMessage);

	/**
	* Ilib3mf::RGBAToColor - Creates a Color from uint8 RGBA values
	* @param[in] nRed - Red value of color (0-255)
	* @param[in] nGreen - Green value of color (0-255)
	* @param[in] nBlue - Blue value of color (0-255)
	* @param[in] nAlpha - Alpha value of color (0-255)
	* @return Assembled color
	*/
	static Lib3MF::sColor RGBAToColor(const Lib3MF_uint8 nRed, const Lib3MF_uint8 nGreen, const Lib3MF_uint8 nBlue, const Lib3MF_uint8 nAlpha);

	/**
	* Ilib3mf::FloatRGBAToColor - Creates a Color from uint8 RGBA values
	* @param[in] fRed - Red value of color (0-1)
	* @param[in] fGreen - Green value of color (0-1)
	* @param[in] fBlue - Blue value of color (0-1)
	* @param[in] fAlpha - Alpha value of color (0-1)
	* @return Assembled color
	*/
	static Lib3MF::sColor FloatRGBAToColor(const Lib3MF_single fRed, const Lib3MF_single fGreen, const Lib3MF_single fBlue, const Lib3MF_single fAlpha);

	/**
	* Ilib3mf::ColorToRGBA - Calculates uint8-RGBA-values from a Color
	* @param[in] TheColor - Color to handle
	* @param[out] nRed - Red value of color (0-255)
	* @param[out] nGreen - Green value of color (0-255)
	* @param[out] nBlue - Blue value of color (0-255)
	* @param[out] nAlpha - Alpha value of color (0-255)
	*/
	static void ColorToRGBA(const Lib3MF::sColor TheColor, Lib3MF_uint8 & nRed, Lib3MF_uint8 & nGreen, Lib3MF_uint8 & nBlue, Lib3MF_uint8 & nAlpha);

	/**
	* Ilib3mf::ColorToFloatRGBA - Calculates float-RGBA-values from a Color
	* @param[in] TheColor - Color to handle
	* @param[out] fRed - Red value of color (0-1)
	* @param[out] fGreen - Green value of color (0-1)
	* @param[out] fBlue - Blue value of color (0-1)
	* @param[out] fAlpha - Alpha value of color (0-1)
	*/
	static void ColorToFloatRGBA(const Lib3MF::sColor TheColor, Lib3MF_single & fRed, Lib3MF_single & fGreen, Lib3MF_single & fBlue, Lib3MF_single & fAlpha);

	/**
	* Ilib3mf::GetIdentityTransform - Creates an identity transform
	* @return Transformation matrix.
	*/
	static Lib3MF::sTransform GetIdentityTransform();

	/**
	* Ilib3mf::GetUniformScaleTransform - Creates a uniform scale transform
	* @param[in] fFactor - Factor in X, Y and Z
	* @return Transformation matrix.
	*/
	static Lib3MF::sTransform GetUniformScaleTransform(const Lib3MF_single fFactor);

	/**
	* Ilib3mf::GetScaleTransform - Creates a scale transform
	* @param[in] fFactorX - Factor in X
	* @param[in] fFactorY - Factor in Y
	* @param[in] fFactorZ - Factor in Z
	* @return Transformation matrix.
	*/
	static Lib3MF::sTransform GetScaleTransform(const Lib3MF_single fFactorX, const Lib3MF_single fFactorY, const Lib3MF_single fFactorZ);

	/**
	* Ilib3mf::GetTranslationTransform - Creates an translation transform
	* @param[in] fVectorX - Translation in X
	* @param[in] fVectorY - Translation in Y
	* @param[in] fVectorZ - Translation in Z
	* @return Transformation matrix.
	*/
	static Lib3MF::sTransform GetTranslationTransform(const Lib3MF_single fVectorX, const Lib3MF_single fVectorY, const Lib3MF_single fVectorZ);

};

Lib3MFResult Lib3MF_GetProcAddress (const char * pProcName, void ** ppProcAddress);

} // namespace Impl
} // namespace Lib3MF

#endif // __LIB3MF_CPPINTERFACES
