--
--  Copyright (C) 2014-2022, AdaCore
--  SPDX-License-Identifier: Apache-2.0
--

with Ada.Containers;              use Ada.Containers;
with Ada.Containers.Hashed_Maps;
with Ada.Containers.Hashed_Sets;
with Ada.Containers.Ordered_Maps;
with Ada.Exceptions;
with Ada.Strings.Unbounded;       use Ada.Strings.Unbounded;
with Ada.Strings.Unbounded.Hash;
with Ada.Unchecked_Conversion;
with Ada.Unchecked_Deallocation;

with System; use System;

with GNATCOLL.GMP.Integers;
with GNATCOLL.Traces;
with GNATCOLL.VFS; use GNATCOLL.VFS;

with Langkit_Support.Adalog.Logic_Var;
with Langkit_Support.Adalog.Solver;
with Langkit_Support.Adalog.Solver_Interface;

with Langkit_Support.Bump_Ptr;    use Langkit_Support.Bump_Ptr;
with Langkit_Support.Cheap_Sets;
with Langkit_Support.File_Readers; use Langkit_Support.File_Readers;
with Langkit_Support.Lexical_Envs; use Langkit_Support.Lexical_Envs;
with Langkit_Support.Lexical_Envs_Impl;
with Langkit_Support.Symbols;      use Langkit_Support.Symbols;
with Langkit_Support.Symbols.Precomputed;
with Langkit_Support.Token_Data_Handlers;
use Langkit_Support.Token_Data_Handlers;
with Langkit_Support.Types;        use Langkit_Support.Types;
with Langkit_Support.Vectors;

with Libadalang.Parsers; use Libadalang.Parsers;
with Libadalang.Common;  use Libadalang.Common;
with Libadalang.Lexer_Implementation;
use Libadalang.Lexer_Implementation;


          with Libadalang.Config_Pragmas_Impl;
            use Libadalang.Config_Pragmas_Impl;


--  Internal package: low-level primitives to implement public types and
--  operations in Libadalang.Analysis.

private package Libadalang.Implementation is

   use Support.Diagnostics, Support.Slocs, Support.Text;

   ------------
   -- Traces --
   ------------

   Main_Trace : constant GNATCOLL.Traces.Trace_Handle :=
     GNATCOLL.Traces.Create
       ("LIBADALANG.MAIN_TRACE", GNATCOLL.Traces.From_Config);

   PLE_Errors_Trace : constant GNATCOLL.Traces.Trace_Handle :=
     GNATCOLL.Traces.Create
       ("LIBADALANG.PLE_ERRORS", GNATCOLL.Traces.From_Config);

   -------------------------------------
   -- Symbols and token data handlers --
   -------------------------------------

   type Precomputed_Symbol_Index is
         (
            
               Precomputed_Sym, --  "&"
               Precomputed_Sym_1, --  "&""+"
               Precomputed_Sym_10, --  "="
               Precomputed_Sym_11, --  ">"
               Precomputed_Sym_12, --  ">="
               Precomputed_Sym_2, --  "*"
               Precomputed_Sym_20, --  <<>>
               Precomputed_Sym_3, --  "**"
               Precomputed_Sym_4, --  "+"
               Precomputed_Sym_5, --  "-"
               Precomputed_Sym_6, --  "/"
               Precomputed_Sym_7, --  "/="
               Precomputed_Sym_8, --  "<"
               Precomputed_Sym_9, --  "<="
               Precomputed_Sym_Abort, --  abort
               Precomputed_Sym_Abort_Signal, --  Abort_Signal
               Precomputed_Sym_Abort_Signal_259, --  abort_signal_
               Precomputed_Sym_Abs, --  "abs"
               Precomputed_Sym_Abs_260, --  abs
               Precomputed_Sym_Abstract, --  abstract
               Precomputed_Sym_Abstract_State, --  Abstract_State
               Precomputed_Sym_Accept, --  accept
               Precomputed_Sym_Access, --  Access
               Precomputed_Sym_Access_263, --  access
               Precomputed_Sym_Ada, --  Ada
               Precomputed_Sym_Ada_264, --  ada
               Precomputed_Sym_Address, --  Address
               Precomputed_Sym_Address_Size, --  Address_Size
               Precomputed_Sym_Adjacent, --  Adjacent
               Precomputed_Sym_Adjacent_265, --  adjacent
               Precomputed_Sym_Aft, --  Aft
               Precomputed_Sym_Aliased, --  aliased
               Precomputed_Sym_Alignment, --  Alignment
               Precomputed_Sym_All, --  all
               Precomputed_Sym_And, --  "and"
               Precomputed_Sym_And_268, --  and
               Precomputed_Sym_Array, --  array
               Precomputed_Sym_Asm_Input, --  Asm_Input
               Precomputed_Sym_Asm_Input_270, --  asm_input
               Precomputed_Sym_Asm_Input_Operand, --  Asm_Input_Operand
               Precomputed_Sym_Asm_Output, --  Asm_Output
               Precomputed_Sym_Asm_Output_271, --  asm_output
               Precomputed_Sym_Asm_Output_Operand, --  Asm_Output_Operand
               Precomputed_Sym_Assert, --  Assert
               Precomputed_Sym_Assert_And_Cut, --  Assert_And_Cut
               Precomputed_Sym_Assume, --  Assume
               Precomputed_Sym_Asynchronous, --  Asynchronous
               Precomputed_Sym_At, --  at
               Precomputed_Sym_Atomic, --  Atomic
               Precomputed_Sym_Atomic_Components, --  Atomic_Components
               Precomputed_Sym_Attach_Handler, --  Attach_Handler
               Precomputed_Sym_Aux_Dec, --  Aux_DEC
               Precomputed_Sym_Base, --  Base
               Precomputed_Sym_Begin, --  begin
               Precomputed_Sym_Bit_Order, --  Bit_Order
               Precomputed_Sym_Body, --  body
               Precomputed_Sym_Boolean, --  Boolean
               Precomputed_Sym_Buffer, --  Buffer
               Precomputed_Sym_Callable, --  Callable
               Precomputed_Sym_Caller, --  Caller
               Precomputed_Sym_Case, --  case
               Precomputed_Sym_Ceiling, --  Ceiling
               Precomputed_Sym_Ceiling_276, --  ceiling
               Precomputed_Sym_Character, --  Character
               Precomputed_Sym_Class, --  Class
               Precomputed_Sym_Compile_Time_Error, --  Compile_Time_Error
               Precomputed_Sym_Compile_Time_Warning, --  Compile_Time_Warning
               Precomputed_Sym_Component_Size, --  Component_Size
               Precomputed_Sym_Compose, --  Compose
               Precomputed_Sym_Compose_277, --  compose
               Precomputed_Sym_Constant, --  constant
               Precomputed_Sym_Constant_Indexing, --  Constant_Indexing
               Precomputed_Sym_Constrained, --  Constrained
               Precomputed_Sym_Contract_Cases, --  Contract_Cases
               Precomputed_Sym_Convention, --  Convention
               Precomputed_Sym_Copy_Sign, --  Copy_Sign
               Precomputed_Sym_Copy_Sign_279, --  copy_sign
               Precomputed_Sym_Count, --  Count
               Precomputed_Sym_Cursor, --  Cursor
               Precomputed_Sym_Debug, --  Debug
               Precomputed_Sym_Declare, --  declare
               Precomputed_Sym_Default_Bit_Order, --  Default_Bit_Order
               Precomputed_Sym_Default_Initial_Condition, --  Default_Initial_Condition
               Precomputed_Sym_Definite, --  Definite
               Precomputed_Sym_Delay, --  delay
               Precomputed_Sym_Delta, --  Delta
               Precomputed_Sym_Delta_282, --  delta
               Precomputed_Sym_Depends, --  Depends
               Precomputed_Sym_Descriptor_Size, --  Descriptor_Size
               Precomputed_Sym_Digits, --  Digits
               Precomputed_Sym_Digits_283, --  digits
               Precomputed_Sym_Discard_Names, --  Discard_Names
               Precomputed_Sym_Do, --  do
               Precomputed_Sym_Dummy, --  __dummy
               Precomputed_Sym_Duration, --  Duration
               Precomputed_Sym_Dynamic_Predicate, --  Dynamic_Predicate
               Precomputed_Sym_Elaborate_Body, --  Elaborate_Body
               Precomputed_Sym_Element, --  Element
               Precomputed_Sym_Else, --  else
               Precomputed_Sym_Elsif, --  elsif
               Precomputed_Sym_End, --  end
               Precomputed_Sym_Ensures, --  Ensures
               Precomputed_Sym_Entry, --  entry
               Precomputed_Sym_Enum_Rep, --  Enum_Rep
               Precomputed_Sym_Enum_Rep_289, --  enum_rep
               Precomputed_Sym_Enum_Val, --  Enum_Val
               Precomputed_Sym_Enum_Val_290, --  enum_val
               Precomputed_Sym_Epsilon, --  Epsilon
               Precomputed_Sym_Exception, --  exception
               Precomputed_Sym_Exception_Id, --  Exception_Id
               Precomputed_Sym_Exception_Occurrence, --  Exception_Occurrence
               Precomputed_Sym_Exceptions, --  Exceptions
               Precomputed_Sym_Exit, --  exit
               Precomputed_Sym_Exponent, --  Exponent
               Precomputed_Sym_Exponent_293, --  exponent
               Precomputed_Sym_Export, --  Export
               Precomputed_Sym_External_Tag, --  External_Tag
               Precomputed_Sym_Finalization_Size, --  Finalization_Size
               Precomputed_Sym_First, --  First
               Precomputed_Sym_First_Bit, --  First_Bit
               Precomputed_Sym_Fixed_Value, --  Fixed_Value
               Precomputed_Sym_Fixed_Value_294, --  fixed_value
               Precomputed_Sym_Floor, --  Floor
               Precomputed_Sym_Floor_295, --  floor
               Precomputed_Sym_For, --  for
               Precomputed_Sym_Fore, --  Fore
               Precomputed_Sym_Fraction, --  Fraction
               Precomputed_Sym_Fraction_297, --  fraction
               Precomputed_Sym_Function, --  function
               Precomputed_Sym_Generic, --  generic
               Precomputed_Sym_Ghost, --  Ghost
               Precomputed_Sym_Global, --  Global
               Precomputed_Sym_Goto, --  goto
               Precomputed_Sym_Has_Access_Values, --  Has_Access_Values
               Precomputed_Sym_Has_Discriminants, --  Has_Discriminants
               Precomputed_Sym_Has_Tagged_Values, --  Has_Tagged_Values
               Precomputed_Sym_Identity, --  Identity
               Precomputed_Sym_If, --  if
               Precomputed_Sym_Image, --  Image
               Precomputed_Sym_Image_302, --  image
               Precomputed_Sym_Img, --  Img
               Precomputed_Sym_Implicit_Dereference, --  Implicit_Dereference
               Precomputed_Sym_Import, --  Import
               Precomputed_Sym_Import_Function, --  Import_Function
               Precomputed_Sym_Import_Procedure, --  Import_Procedure
               Precomputed_Sym_In, --  in
               Precomputed_Sym_Independent, --  Independent
               Precomputed_Sym_Independent_Components, --  Independent_Components
               Precomputed_Sym_Index, --  Index
               Precomputed_Sym_Initialized, --  Initialized
               Precomputed_Sym_Inline, --  Inline
               Precomputed_Sym_Input, --  Input
               Precomputed_Sym_Input_304, --  input
               Precomputed_Sym_Integer, --  Integer
               Precomputed_Sym_Integer_Literal, --  Integer_Literal
               Precomputed_Sym_Integer_Value, --  Integer_Value
               Precomputed_Sym_Integer_Value_305, --  integer_value
               Precomputed_Sym_Interface, --  Interface
               Precomputed_Sym_Interface_306, --  interface
               Precomputed_Sym_Interrupt_Handler, --  Interrupt_Handler
               Precomputed_Sym_Invalid_Value, --  Invalid_Value
               Precomputed_Sym_Invariant, --  Invariant
               Precomputed_Sym_Invariant_Class, --  Invariant'Class
               Precomputed_Sym_Is, --  is
               Precomputed_Sym_Iterable, --  Iterable
               Precomputed_Sym_Iterator_Element, --  Iterator_Element
               Precomputed_Sym_Iterator_Interfaces, --  Iterator_Interfaces
               Precomputed_Sym_Large, --  Large
               Precomputed_Sym_Last, --  Last
               Precomputed_Sym_Last_Bit, --  Last_Bit
               Precomputed_Sym_Left, --  left
               Precomputed_Sym_Length, --  Length
               Precomputed_Sym_Limited, --  limited
               Precomputed_Sym_Loop, --  loop
               Precomputed_Sym_Loop_Entry, --  Loop_Entry
               Precomputed_Sym_Loop_Invariant, --  Loop_Invariant
               Precomputed_Sym_Machine, --  Machine
               Precomputed_Sym_Machine_311, --  machine
               Precomputed_Sym_Machine_Code, --  Machine_Code
               Precomputed_Sym_Machine_Emax, --  Machine_Emax
               Precomputed_Sym_Machine_Emin, --  Machine_Emin
               Precomputed_Sym_Machine_Mantissa, --  Machine_Mantissa
               Precomputed_Sym_Machine_Overflows, --  Machine_Overflows
               Precomputed_Sym_Machine_Radix, --  Machine_Radix
               Precomputed_Sym_Machine_Rounding, --  Machine_Rounding
               Precomputed_Sym_Machine_Rounding_312, --  machine_rounding
               Precomputed_Sym_Machine_Rounds, --  Machine_Rounds
               Precomputed_Sym_Mantissa, --  Mantissa
               Precomputed_Sym_Max, --  Max
               Precomputed_Sym_Max_313, --  max
               Precomputed_Sym_Max_Integer_Size, --  Max_Integer_Size
               Precomputed_Sym_Max_Size_In_Storage_Elements, --  Max_Size_In_Storage_Elements
               Precomputed_Sym_Maximum_Alignment, --  Maximum_Alignment
               Precomputed_Sym_Min, --  Min
               Precomputed_Sym_Min_314, --  min
               Precomputed_Sym_Mod, --  "mod"
               Precomputed_Sym_Mod_142, --  Mod
               Precomputed_Sym_Mod_315, --  mod
               Precomputed_Sym_Model_Epsilon, --  Model_Epsilon
               Precomputed_Sym_Model_Mantissa, --  Model_Mantissa
               Precomputed_Sym_Model_Small, --  Model_Small
               Precomputed_Sym_Modulus, --  Modulus
               Precomputed_Sym_New, --  new
               Precomputed_Sym_Nextpart, --  __nextpart
               Precomputed_Sym_No_Elaboration_Code, --  No_Elaboration_Code
               Precomputed_Sym_No_Return, --  No_Return
               Precomputed_Sym_Not, --  "not"
               Precomputed_Sym_Not_317, --  not
               Precomputed_Sym_Null, --  null
               Precomputed_Sym_Object_Size, --  Object_Size
               Precomputed_Sym_Of, --  of
               Precomputed_Sym_Old, --  Old
               Precomputed_Sym_Or, --  "or"
               Precomputed_Sym_Or_320, --  or
               Precomputed_Sym_Others, --  others
               Precomputed_Sym_Out, --  out
               Precomputed_Sym_Output, --  Output
               Precomputed_Sym_Output_323, --  output
               Precomputed_Sym_Overriding, --  overriding
               Precomputed_Sym_Pack, --  Pack
               Precomputed_Sym_Package, --  package
               Precomputed_Sym_Pos, --  Pos
               Precomputed_Sym_Pos_326, --  pos
               Precomputed_Sym_Position, --  Position
               Precomputed_Sym_Post, --  Post
               Precomputed_Sym_Post_Class, --  Post'Class
               Precomputed_Sym_Postcondition, --  Postcondition
               Precomputed_Sym_Postcondition_Class, --  Postcondition'Class
               Precomputed_Sym_Pragma, --  pragma
               Precomputed_Sym_Pre, --  Pre
               Precomputed_Sym_Pre_Class, --  Pre'Class
               Precomputed_Sym_Precondition, --  Precondition
               Precomputed_Sym_Precondition_Class, --  Precondition'Class
               Precomputed_Sym_Pred, --  Pred
               Precomputed_Sym_Pred_328, --  pred
               Precomputed_Sym_Predicate, --  Predicate
               Precomputed_Sym_Predicate_Failure, --  Predicate_Failure
               Precomputed_Sym_Preelaborate, --  Preelaborate
               Precomputed_Sym_Private, --  private
               Precomputed_Sym_Privatepart, --  __privatepart
               Precomputed_Sym_Procedure, --  procedure
               Precomputed_Sym_Protected, --  protected
               Precomputed_Sym_Pure, --  Pure
               Precomputed_Sym_Put_Image, --  Put_Image
               Precomputed_Sym_Put_Image_332, --  put_image
               Precomputed_Sym_Raise, --  raise
               Precomputed_Sym_Range, --  Range
               Precomputed_Sym_Range_334, --  range
               Precomputed_Sym_Range_Length, --  Range_Length
               Precomputed_Sym_Read, --  Read
               Precomputed_Sym_Read_335, --  read
               Precomputed_Sym_Real_Literal, --  Real_Literal
               Precomputed_Sym_Record, --  record
               Precomputed_Sym_Reduce, --  Reduce
               Precomputed_Sym_Refined_Depends, --  Refined_Depends
               Precomputed_Sym_Refined_Global, --  Refined_Global
               Precomputed_Sym_Refined_Post, --  Refined_Post
               Precomputed_Sym_Refined_State, --  Refined_State
               Precomputed_Sym_Rem, --  "rem"
               Precomputed_Sym_Rem_337, --  rem
               Precomputed_Sym_Remainder, --  Remainder
               Precomputed_Sym_Remainder_338, --  remainder
               Precomputed_Sym_Remote_Call_Interface, --  Remote_Call_Interface
               Precomputed_Sym_Remote_Types, --  Remote_Types
               Precomputed_Sym_Renames, --  renames
               Precomputed_Sym_Requeue, --  requeue
               Precomputed_Sym_Requires, --  Requires
               Precomputed_Sym_Restrictions, --  Restrictions
               Precomputed_Sym_Result, --  Result
               Precomputed_Sym_Return, --  return
               Precomputed_Sym_Reverse, --  reverse
               Precomputed_Sym_Right, --  right
               Precomputed_Sym_Root_Buffer_Type, --  Root_Buffer_Type
               Precomputed_Sym_Root_Integer, --  root_integer
               Precomputed_Sym_Root_Real, --  root_real
               Precomputed_Sym_Root_Storage_Pool, --  Root_Storage_Pool
               Precomputed_Sym_Root_Stream_Type, --  Root_Stream_Type
               Precomputed_Sym_Root_Types, --  root_types_
               Precomputed_Sym_Rounding, --  Rounding
               Precomputed_Sym_Rounding_347, --  rounding
               Precomputed_Sym_S, --  S
               Precomputed_Sym_Safe_Large, --  Safe_Large
               Precomputed_Sym_Safe_Small, --  Safe_Small
               Precomputed_Sym_Scalar_Storage_Order, --  Scalar_Storage_Order
               Precomputed_Sym_Scaling, --  Scaling
               Precomputed_Sym_Scaling_348, --  scaling
               Precomputed_Sym_Select, --  select
               Precomputed_Sym_Separate, --  separate
               Precomputed_Sym_Shared_Passive, --  Shared_Passive
               Precomputed_Sym_Size, --  Size
               Precomputed_Sym_Small, --  Small
               Precomputed_Sym_Small_Denominator, --  Small_Denominator
               Precomputed_Sym_Small_Numerator, --  Small_Numerator
               Precomputed_Sym_Some, --  some
               Precomputed_Sym_Stable_Properties, --  Stable_Properties
               Precomputed_Sym_Standard, --  Standard
               Precomputed_Sym_Standard_352, --  standard
               Precomputed_Sym_Static_Predicate, --  Static_Predicate
               Precomputed_Sym_Storage_Elements, --  Storage_Elements
               Precomputed_Sym_Storage_Pool, --  Storage_Pool
               Precomputed_Sym_Storage_Pools, --  Storage_Pools
               Precomputed_Sym_Storage_Size, --  Storage_Size
               Precomputed_Sym_Storage_Unit, --  Storage_Unit
               Precomputed_Sym_Streams, --  Streams
               Precomputed_Sym_String, --  String
               Precomputed_Sym_String_Literal, --  String_Literal
               Precomputed_Sym_Strings, --  Strings
               Precomputed_Sym_Style_Checks, --  Style_Checks
               Precomputed_Sym_Subtype, --  subtype
               Precomputed_Sym_Succ, --  Succ
               Precomputed_Sym_Succ_354, --  succ
               Precomputed_Sym_Synchronized, --  synchronized
               Precomputed_Sym_System, --  System
               Precomputed_Sym_System_Allocator_Alignment, --  System_Allocator_Alignment
               Precomputed_Sym_Tag, --  Tag
               Precomputed_Sym_Tagged, --  tagged
               Precomputed_Sym_Tags, --  Tags
               Precomputed_Sym_Target_Name, --  Target_Name
               Precomputed_Sym_Task, --  task
               Precomputed_Sym_Task_Id, --  Task_Id
               Precomputed_Sym_Task_Identification, --  Task_Identification
               Precomputed_Sym_Terminate, --  terminate
               Precomputed_Sym_Terminated, --  Terminated
               Precomputed_Sym_Test_Case, --  Test_Case
               Precomputed_Sym_Text_Buffers, --  Text_Buffers
               Precomputed_Sym_Text_Io, --  text_io
               Precomputed_Sym_Then, --  then
               Precomputed_Sym_To_Address, --  To_Address
               Precomputed_Sym_Truncation, --  Truncation
               Precomputed_Sym_Truncation_361, --  truncation
               Precomputed_Sym_Type, --  type
               Precomputed_Sym_Type_Class, --  Type_Class
               Precomputed_Sym_Type_Invariant, --  Type_Invariant
               Precomputed_Sym_Type_Invariant_Class, --  Type_Invariant'Class
               Precomputed_Sym_Unchecked_Access, --  Unchecked_Access
               Precomputed_Sym_Unchecked_Union, --  Unchecked_Union
               Precomputed_Sym_Universal_Int_Type, --  Universal_Int_Type_
               Precomputed_Sym_Universal_Real_Type, --  Universal_Real_Type_
               Precomputed_Sym_Unreferenced, --  Unreferenced
               Precomputed_Sym_Unrestricted_Access, --  Unrestricted_Access
               Precomputed_Sym_Until, --  until
               Precomputed_Sym_Update, --  Update
               Precomputed_Sym_Use, --  use
               Precomputed_Sym_Vads_Size, --  VADS_Size
               Precomputed_Sym_Val, --  Val
               Precomputed_Sym_Val_365, --  val
               Precomputed_Sym_Valid, --  Valid
               Precomputed_Sym_Valid_Scalars, --  Valid_Scalars
               Precomputed_Sym_Value, --  Value
               Precomputed_Sym_Value_366, --  value
               Precomputed_Sym_Value_Size, --  Value_Size
               Precomputed_Sym_Variable_Indexing, --  Variable_Indexing
               Precomputed_Sym_Volatile, --  Volatile
               Precomputed_Sym_Volatile_Components, --  Volatile_Components
               Precomputed_Sym_Warnings, --  Warnings
               Precomputed_Sym_When, --  when
               Precomputed_Sym_While, --  while
               Precomputed_Sym_Wide_Character, --  Wide_Character
               Precomputed_Sym_Wide_Image, --  Wide_Image
               Precomputed_Sym_Wide_Image_369, --  wide_image
               Precomputed_Sym_Wide_String, --  Wide_String
               Precomputed_Sym_Wide_Text_Io, --  wide_text_io
               Precomputed_Sym_Wide_Value, --  Wide_Value
               Precomputed_Sym_Wide_Value_371, --  wide_value
               Precomputed_Sym_Wide_Wide_Character, --  Wide_Wide_Character
               Precomputed_Sym_Wide_Wide_Image, --  Wide_Wide_Image
               Precomputed_Sym_Wide_Wide_Image_372, --  wide_wide_image
               Precomputed_Sym_Wide_Wide_String, --  Wide_Wide_String
               Precomputed_Sym_Wide_Wide_Text_Io, --  wide_wide_text_io
               Precomputed_Sym_Wide_Wide_Value, --  Wide_Wide_Value
               Precomputed_Sym_Wide_Wide_Value_374, --  wide_wide_value
               Precomputed_Sym_Width, --  Width
               Precomputed_Sym_With, --  with
               Precomputed_Sym_Word_Size, --  Word_Size
               Precomputed_Sym_Write, --  Write
               Precomputed_Sym_Write_376, --  write
               Precomputed_Sym_Xor, --  "xor"
               Precomputed_Sym_Xor_377 --  xor
         )
   ;

   function Precomputed_Symbol
     (Index : Precomputed_Symbol_Index) return Text_Type;

   --  GNAT emits an incorrect value not in range in instantiation warning...
   --  So deactivate them at the instantiation point.
   pragma Warnings (Off, "value not in range");
   package Precomputed_Symbols is new Langkit_Support.Symbols.Precomputed
     (Precomputed_Symbol_Index, Precomputed_Symbol);
   pragma Warnings (On, "value not in range");

   --------------------
   -- Analysis types --
   --------------------

   type Analysis_Context_Type;
   type Internal_Context is access all Analysis_Context_Type;

   Unexpected_Call_Depth : exception;
   --  Raised when the Call_Depth for two matching calls to Enter_Call and
   --  Exit_Call don't match, i.e. when there is a bug in the counting of
   --  recursive calls.

   procedure Enter_Call
     (Context : Internal_Context; Call_Depth : access Natural)
   with Inline_Always;
   --  Increment the call depth in Context. If the depth exceeds Context's
   --  maximum, raise a Property_Error for "stack overflow".
   --
   --  Note that in the case of an exception, the depth is still incremented.
   --  This means that all calls to Enter_Call must be wrapped in an exception
   --  handler which calls Exit_Call on exception.
   --
   --  Put in Call_Depth the incremented call depth.

   procedure Exit_Call (Context : Internal_Context; Call_Depth : Natural)
   with Inline_Always;
   --  Decrement the call depth in Context. If Call_Depth does not match the
   --  current call depth, raise an Unexpected_Call_Depth.

   type Analysis_Unit_Type;
   type Internal_Unit is access all Analysis_Unit_Type;

   type Root_Node_Record;
   type Bare_Ada_Node is access all Root_Node_Record;
   No_Bare_Ada_Node : constant Bare_Ada_Node := null;
   --  Most generic AST node type

   function "<" (Left, Right : Bare_Ada_Node) return Boolean;
   --  Abritrary but deterministic ordering criteria for parsing nodes. This
   --  handles null nodes as well. Raise a Property_Error for synthetic nodes.

   function Is_Null (Node : Bare_Ada_Node) return Boolean;
   function Kind (Node : Bare_Ada_Node) return Ada_Node_Kind_Type;

         subtype Bare_Abort_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abort_Node)
               or else Kind (Bare_Abort_Node) in Ada_Abort_Node;
         subtype Bare_Abort_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abort_Absent)
               or else Kind (Bare_Abort_Absent) in Ada_Abort_Absent_Range;
         subtype Bare_Abort_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abort_Present)
               or else Kind (Bare_Abort_Present) in Ada_Abort_Present_Range;
         subtype Bare_Abstract_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_Node)
               or else Kind (Bare_Abstract_Node) in Ada_Abstract_Node;
         subtype Bare_Abstract_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_Absent)
               or else Kind (Bare_Abstract_Absent) in Ada_Abstract_Absent_Range;
         subtype Bare_Abstract_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_Present)
               or else Kind (Bare_Abstract_Present) in Ada_Abstract_Present_Range;
         subtype Bare_Ada_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Ada_List)
               or else Kind (Bare_Ada_List) in Ada_Ada_List;
         subtype Bare_Ada_Node_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Ada_Node_List)
               or else Kind (Bare_Ada_Node_List) in Ada_Ada_Node_List_Range;
         subtype Bare_Abstract_State_Decl_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_State_Decl_List)
               or else Kind (Bare_Abstract_State_Decl_List) in Ada_Abstract_State_Decl_List_Range;
         subtype Bare_Alternatives_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Alternatives_List)
               or else Kind (Bare_Alternatives_List) in Ada_Alternatives_List_Range;
         subtype Bare_Constraint_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Constraint_List)
               or else Kind (Bare_Constraint_List) in Ada_Constraint_List_Range;
         subtype Bare_Decl_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Decl_List)
               or else Kind (Bare_Decl_List) in Ada_Decl_List_Range;
         subtype Bare_Stmt_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Stmt_List)
               or else Kind (Bare_Stmt_List) in Ada_Stmt_List_Range;
         subtype Bare_Aspect_Assoc_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aspect_Assoc_List)
               or else Kind (Bare_Aspect_Assoc_List) in Ada_Aspect_Assoc_List_Range;
         subtype Bare_Base_Assoc_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Assoc_List)
               or else Kind (Bare_Base_Assoc_List) in Ada_Base_Assoc_List_Range;
         subtype Bare_Basic_Assoc_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Basic_Assoc_List)
               or else Kind (Bare_Basic_Assoc_List) in Ada_Basic_Assoc_List;
         subtype Bare_Assoc_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Assoc_List)
               or else Kind (Bare_Assoc_List) in Ada_Assoc_List_Range;
         subtype Bare_Basic_Decl_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Basic_Decl_List)
               or else Kind (Bare_Basic_Decl_List) in Ada_Basic_Decl_List_Range;
         subtype Bare_Case_Expr_Alternative_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Case_Expr_Alternative_List)
               or else Kind (Bare_Case_Expr_Alternative_List) in Ada_Case_Expr_Alternative_List_Range;
         subtype Bare_Case_Stmt_Alternative_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Case_Stmt_Alternative_List)
               or else Kind (Bare_Case_Stmt_Alternative_List) in Ada_Case_Stmt_Alternative_List_Range;
         subtype Bare_Compilation_Unit_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Compilation_Unit_List)
               or else Kind (Bare_Compilation_Unit_List) in Ada_Compilation_Unit_List_Range;
         subtype Bare_Concat_Operand_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Concat_Operand_List)
               or else Kind (Bare_Concat_Operand_List) in Ada_Concat_Operand_List_Range;
         subtype Bare_Contract_Case_Assoc_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Contract_Case_Assoc_List)
               or else Kind (Bare_Contract_Case_Assoc_List) in Ada_Contract_Case_Assoc_List_Range;
         subtype Bare_Defining_Name_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Defining_Name_List)
               or else Kind (Bare_Defining_Name_List) in Ada_Defining_Name_List_Range;
         subtype Bare_Discriminant_Spec_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Discriminant_Spec_List)
               or else Kind (Bare_Discriminant_Spec_List) in Ada_Discriminant_Spec_List_Range;
         subtype Bare_Elsif_Expr_Part_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Elsif_Expr_Part_List)
               or else Kind (Bare_Elsif_Expr_Part_List) in Ada_Elsif_Expr_Part_List_Range;
         subtype Bare_Elsif_Stmt_Part_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Elsif_Stmt_Part_List)
               or else Kind (Bare_Elsif_Stmt_Part_List) in Ada_Elsif_Stmt_Part_List_Range;
         subtype Bare_Enum_Literal_Decl_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Enum_Literal_Decl_List)
               or else Kind (Bare_Enum_Literal_Decl_List) in Ada_Enum_Literal_Decl_List_Range;
         subtype Bare_Expr_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Expr_List)
               or else Kind (Bare_Expr_List) in Ada_Expr_List;
         subtype Bare_Expr_Alternatives_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Expr_Alternatives_List)
               or else Kind (Bare_Expr_Alternatives_List) in Ada_Expr_Alternatives_List_Range;
         subtype Bare_Identifier_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Identifier_List)
               or else Kind (Bare_Identifier_List) in Ada_Identifier_List;
         subtype Bare_Discriminant_Choice_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Discriminant_Choice_List)
               or else Kind (Bare_Discriminant_Choice_List) in Ada_Discriminant_Choice_List_Range;
         subtype Bare_Name_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Name_List)
               or else Kind (Bare_Name_List) in Ada_Name_List_Range;
         subtype Bare_Parent_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Parent_List)
               or else Kind (Bare_Parent_List) in Ada_Parent_List_Range;
         subtype Bare_Param_Spec_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Param_Spec_List)
               or else Kind (Bare_Param_Spec_List) in Ada_Param_Spec_List_Range;
         subtype Bare_Pragma_Node_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pragma_Node_List)
               or else Kind (Bare_Pragma_Node_List) in Ada_Pragma_Node_List_Range;
         subtype Bare_Select_When_Part_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Select_When_Part_List)
               or else Kind (Bare_Select_When_Part_List) in Ada_Select_When_Part_List_Range;
         subtype Bare_Unconstrained_Array_Index_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Unconstrained_Array_Index_List)
               or else Kind (Bare_Unconstrained_Array_Index_List) in Ada_Unconstrained_Array_Index_List_Range;
         subtype Bare_Variant_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Variant_List)
               or else Kind (Bare_Variant_List) in Ada_Variant_List_Range;
         subtype Bare_Aliased_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aliased_Node)
               or else Kind (Bare_Aliased_Node) in Ada_Aliased_Node;
         subtype Bare_Aliased_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aliased_Absent)
               or else Kind (Bare_Aliased_Absent) in Ada_Aliased_Absent_Range;
         subtype Bare_Aliased_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aliased_Present)
               or else Kind (Bare_Aliased_Present) in Ada_Aliased_Present_Range;
         subtype Bare_All_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_All_Node)
               or else Kind (Bare_All_Node) in Ada_All_Node;
         subtype Bare_All_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_All_Absent)
               or else Kind (Bare_All_Absent) in Ada_All_Absent_Range;
         subtype Bare_All_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_All_Present)
               or else Kind (Bare_All_Present) in Ada_All_Present_Range;
         subtype Bare_Array_Indices is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Array_Indices)
               or else Kind (Bare_Array_Indices) in Ada_Array_Indices;
         subtype Bare_Constrained_Array_Indices is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Constrained_Array_Indices)
               or else Kind (Bare_Constrained_Array_Indices) in Ada_Constrained_Array_Indices_Range;
         subtype Bare_Unconstrained_Array_Indices is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Unconstrained_Array_Indices)
               or else Kind (Bare_Unconstrained_Array_Indices) in Ada_Unconstrained_Array_Indices_Range;
         subtype Bare_Aspect_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aspect_Assoc)
               or else Kind (Bare_Aspect_Assoc) in Ada_Aspect_Assoc_Range;
         subtype Bare_Aspect_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aspect_Clause)
               or else Kind (Bare_Aspect_Clause) in Ada_Aspect_Clause;
         subtype Bare_At_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_At_Clause)
               or else Kind (Bare_At_Clause) in Ada_At_Clause_Range;
         subtype Bare_Attribute_Def_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attribute_Def_Clause)
               or else Kind (Bare_Attribute_Def_Clause) in Ada_Attribute_Def_Clause_Range;
         subtype Bare_Enum_Rep_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Enum_Rep_Clause)
               or else Kind (Bare_Enum_Rep_Clause) in Ada_Enum_Rep_Clause_Range;
         subtype Bare_Record_Rep_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Record_Rep_Clause)
               or else Kind (Bare_Record_Rep_Clause) in Ada_Record_Rep_Clause_Range;
         subtype Bare_Aspect_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aspect_Spec)
               or else Kind (Bare_Aspect_Spec) in Ada_Aspect_Spec_Range;
         subtype Bare_Base_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Assoc)
               or else Kind (Bare_Base_Assoc) in Ada_Base_Assoc;
         subtype Bare_Contract_Case_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Contract_Case_Assoc)
               or else Kind (Bare_Contract_Case_Assoc) in Ada_Contract_Case_Assoc_Range;
         subtype Bare_Pragma_Argument_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pragma_Argument_Assoc)
               or else Kind (Bare_Pragma_Argument_Assoc) in Ada_Pragma_Argument_Assoc_Range;
         subtype Bare_Base_Formal_Param_Holder is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Formal_Param_Holder)
               or else Kind (Bare_Base_Formal_Param_Holder) in Ada_Base_Formal_Param_Holder;
         subtype Bare_Base_Subp_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Subp_Spec)
               or else Kind (Bare_Base_Subp_Spec) in Ada_Base_Subp_Spec;
         subtype Bare_Entry_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Entry_Spec)
               or else Kind (Bare_Entry_Spec) in Ada_Entry_Spec_Range;
         subtype Bare_Enum_Subp_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Enum_Subp_Spec)
               or else Kind (Bare_Enum_Subp_Spec) in Ada_Enum_Subp_Spec_Range;
         subtype Bare_Subp_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subp_Spec)
               or else Kind (Bare_Subp_Spec) in Ada_Subp_Spec_Range;
         subtype Bare_Synthetic_Binary_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Binary_Spec)
               or else Kind (Bare_Synthetic_Binary_Spec) in Ada_Synthetic_Binary_Spec_Range;
         subtype Bare_Synthetic_Unary_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Unary_Spec)
               or else Kind (Bare_Synthetic_Unary_Spec) in Ada_Synthetic_Unary_Spec_Range;
         subtype Bare_Component_List is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Component_List)
               or else Kind (Bare_Component_List) in Ada_Component_List_Range;
         subtype Bare_Discriminant_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Discriminant_Part)
               or else Kind (Bare_Discriminant_Part) in Ada_Discriminant_Part;
         subtype Bare_Known_Discriminant_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Known_Discriminant_Part)
               or else Kind (Bare_Known_Discriminant_Part) in Ada_Known_Discriminant_Part_Range;
         subtype Bare_Unknown_Discriminant_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Unknown_Discriminant_Part)
               or else Kind (Bare_Unknown_Discriminant_Part) in Ada_Unknown_Discriminant_Part_Range;
         subtype Bare_Entry_Completion_Formal_Params is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Entry_Completion_Formal_Params)
               or else Kind (Bare_Entry_Completion_Formal_Params) in Ada_Entry_Completion_Formal_Params_Range;
         subtype Bare_Generic_Formal_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Formal_Part)
               or else Kind (Bare_Generic_Formal_Part) in Ada_Generic_Formal_Part_Range;
         subtype Bare_Base_Record_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Record_Def)
               or else Kind (Bare_Base_Record_Def) in Ada_Base_Record_Def;
         subtype Bare_Null_Record_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Record_Def)
               or else Kind (Bare_Null_Record_Def) in Ada_Null_Record_Def_Range;
         subtype Bare_Record_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Record_Def)
               or else Kind (Bare_Record_Def) in Ada_Record_Def_Range;
         subtype Bare_Basic_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Basic_Assoc)
               or else Kind (Bare_Basic_Assoc) in Ada_Basic_Assoc;
         subtype Bare_Aggregate_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aggregate_Assoc)
               or else Kind (Bare_Aggregate_Assoc) in Ada_Aggregate_Assoc_Range;
         subtype Bare_Multi_Dim_Array_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Multi_Dim_Array_Assoc)
               or else Kind (Bare_Multi_Dim_Array_Assoc) in Ada_Multi_Dim_Array_Assoc_Range;
         subtype Bare_Composite_Constraint_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Composite_Constraint_Assoc)
               or else Kind (Bare_Composite_Constraint_Assoc) in Ada_Composite_Constraint_Assoc_Range;
         subtype Bare_Iterated_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Iterated_Assoc)
               or else Kind (Bare_Iterated_Assoc) in Ada_Iterated_Assoc_Range;
         subtype Bare_Param_Assoc is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Param_Assoc)
               or else Kind (Bare_Param_Assoc) in Ada_Param_Assoc_Range;
         subtype Bare_Basic_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Basic_Decl)
               or else Kind (Bare_Basic_Decl) in Ada_Basic_Decl;
         subtype Bare_Abstract_State_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_State_Decl)
               or else Kind (Bare_Abstract_State_Decl) in Ada_Abstract_State_Decl_Range;
         subtype Bare_Anonymous_Expr_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Anonymous_Expr_Decl)
               or else Kind (Bare_Anonymous_Expr_Decl) in Ada_Anonymous_Expr_Decl_Range;
         subtype Bare_Base_Formal_Param_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Formal_Param_Decl)
               or else Kind (Bare_Base_Formal_Param_Decl) in Ada_Base_Formal_Param_Decl;
         subtype Bare_Component_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Component_Decl)
               or else Kind (Bare_Component_Decl) in Ada_Component_Decl_Range;
         subtype Bare_Discriminant_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Discriminant_Spec)
               or else Kind (Bare_Discriminant_Spec) in Ada_Discriminant_Spec_Range;
         subtype Bare_Generic_Formal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Formal)
               or else Kind (Bare_Generic_Formal) in Ada_Generic_Formal;
         subtype Bare_Generic_Formal_Obj_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Formal_Obj_Decl)
               or else Kind (Bare_Generic_Formal_Obj_Decl) in Ada_Generic_Formal_Obj_Decl_Range;
         subtype Bare_Generic_Formal_Package is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Formal_Package)
               or else Kind (Bare_Generic_Formal_Package) in Ada_Generic_Formal_Package_Range;
         subtype Bare_Generic_Formal_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Formal_Subp_Decl)
               or else Kind (Bare_Generic_Formal_Subp_Decl) in Ada_Generic_Formal_Subp_Decl_Range;
         subtype Bare_Generic_Formal_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Formal_Type_Decl)
               or else Kind (Bare_Generic_Formal_Type_Decl) in Ada_Generic_Formal_Type_Decl_Range;
         subtype Bare_Param_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Param_Spec)
               or else Kind (Bare_Param_Spec) in Ada_Param_Spec_Range;
         subtype Bare_Synthetic_Formal_Param_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Formal_Param_Decl)
               or else Kind (Bare_Synthetic_Formal_Param_Decl) in Ada_Synthetic_Formal_Param_Decl_Range;
         subtype Bare_Base_Package_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Package_Decl)
               or else Kind (Bare_Base_Package_Decl) in Ada_Base_Package_Decl;
         subtype Bare_Generic_Package_Internal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Package_Internal)
               or else Kind (Bare_Generic_Package_Internal) in Ada_Generic_Package_Internal_Range;
         subtype Bare_Package_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Package_Decl)
               or else Kind (Bare_Package_Decl) in Ada_Package_Decl_Range;
         subtype Bare_Base_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Type_Decl)
               or else Kind (Bare_Base_Type_Decl) in Ada_Base_Type_Decl;
         subtype Bare_Base_Subtype_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Subtype_Decl)
               or else Kind (Bare_Base_Subtype_Decl) in Ada_Base_Subtype_Decl;
         subtype Bare_Discrete_Base_Subtype_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Discrete_Base_Subtype_Decl)
               or else Kind (Bare_Discrete_Base_Subtype_Decl) in Ada_Discrete_Base_Subtype_Decl_Range;
         subtype Bare_Subtype_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subtype_Decl)
               or else Kind (Bare_Subtype_Decl) in Ada_Subtype_Decl_Range;
         subtype Bare_Classwide_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Classwide_Type_Decl)
               or else Kind (Bare_Classwide_Type_Decl) in Ada_Classwide_Type_Decl_Range;
         subtype Bare_Incomplete_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Incomplete_Type_Decl)
               or else Kind (Bare_Incomplete_Type_Decl) in Ada_Incomplete_Type_Decl_Range;
         subtype Bare_Incomplete_Formal_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Incomplete_Formal_Type_Decl)
               or else Kind (Bare_Incomplete_Formal_Type_Decl) in Ada_Incomplete_Formal_Type_Decl_Range;
         subtype Bare_Incomplete_Tagged_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Incomplete_Tagged_Type_Decl)
               or else Kind (Bare_Incomplete_Tagged_Type_Decl) in Ada_Incomplete_Tagged_Type_Decl_Range;
         subtype Bare_Protected_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Protected_Type_Decl)
               or else Kind (Bare_Protected_Type_Decl) in Ada_Protected_Type_Decl_Range;
         subtype Bare_Task_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Task_Type_Decl)
               or else Kind (Bare_Task_Type_Decl) in Ada_Task_Type_Decl_Range;
         subtype Bare_Single_Task_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Single_Task_Type_Decl)
               or else Kind (Bare_Single_Task_Type_Decl) in Ada_Single_Task_Type_Decl_Range;
         subtype Bare_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Decl)
               or else Kind (Bare_Type_Decl) in Ada_Type_Decl;
         subtype Bare_Anonymous_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Anonymous_Type_Decl)
               or else Kind (Bare_Anonymous_Type_Decl) in Ada_Anonymous_Type_Decl_Range;
         subtype Bare_Synth_Anonymous_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synth_Anonymous_Type_Decl)
               or else Kind (Bare_Synth_Anonymous_Type_Decl) in Ada_Synth_Anonymous_Type_Decl_Range;
         subtype Bare_Concrete_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Concrete_Type_Decl)
               or else Kind (Bare_Concrete_Type_Decl) in Ada_Concrete_Type_Decl_Range;
         subtype Bare_Formal_Type_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Formal_Type_Decl)
               or else Kind (Bare_Formal_Type_Decl) in Ada_Formal_Type_Decl_Range;
         subtype Bare_Basic_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Basic_Subp_Decl)
               or else Kind (Bare_Basic_Subp_Decl) in Ada_Basic_Subp_Decl;
         subtype Bare_Classic_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Classic_Subp_Decl)
               or else Kind (Bare_Classic_Subp_Decl) in Ada_Classic_Subp_Decl;
         subtype Bare_Abstract_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_Subp_Decl)
               or else Kind (Bare_Abstract_Subp_Decl) in Ada_Abstract_Subp_Decl_Range;
         subtype Bare_Formal_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Formal_Subp_Decl)
               or else Kind (Bare_Formal_Subp_Decl) in Ada_Formal_Subp_Decl;
         subtype Bare_Abstract_Formal_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_Formal_Subp_Decl)
               or else Kind (Bare_Abstract_Formal_Subp_Decl) in Ada_Abstract_Formal_Subp_Decl_Range;
         subtype Bare_Concrete_Formal_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Concrete_Formal_Subp_Decl)
               or else Kind (Bare_Concrete_Formal_Subp_Decl) in Ada_Concrete_Formal_Subp_Decl_Range;
         subtype Bare_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subp_Decl)
               or else Kind (Bare_Subp_Decl) in Ada_Subp_Decl_Range;
         subtype Bare_Entry_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Entry_Decl)
               or else Kind (Bare_Entry_Decl) in Ada_Entry_Decl_Range;
         subtype Bare_Enum_Literal_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Enum_Literal_Decl)
               or else Kind (Bare_Enum_Literal_Decl) in Ada_Enum_Literal_Decl_Range;
         subtype Bare_Synthetic_Char_Enum_Lit is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Char_Enum_Lit)
               or else Kind (Bare_Synthetic_Char_Enum_Lit) in Ada_Synthetic_Char_Enum_Lit_Range;
         subtype Bare_Generic_Subp_Internal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Subp_Internal)
               or else Kind (Bare_Generic_Subp_Internal) in Ada_Generic_Subp_Internal_Range;
         subtype Bare_Synthetic_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Subp_Decl)
               or else Kind (Bare_Synthetic_Subp_Decl) in Ada_Synthetic_Subp_Decl_Range;
         subtype Bare_Body_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Body_Node)
               or else Kind (Bare_Body_Node) in Ada_Body_Node;
         subtype Bare_Base_Subp_Body is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Subp_Body)
               or else Kind (Bare_Base_Subp_Body) in Ada_Base_Subp_Body;
         subtype Bare_Expr_Function is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Expr_Function)
               or else Kind (Bare_Expr_Function) in Ada_Expr_Function_Range;
         subtype Bare_Null_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Subp_Decl)
               or else Kind (Bare_Null_Subp_Decl) in Ada_Null_Subp_Decl_Range;
         subtype Bare_Subp_Body is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subp_Body)
               or else Kind (Bare_Subp_Body) in Ada_Subp_Body_Range;
         subtype Bare_Subp_Renaming_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subp_Renaming_Decl)
               or else Kind (Bare_Subp_Renaming_Decl) in Ada_Subp_Renaming_Decl_Range;
         subtype Bare_Body_Stub is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Body_Stub)
               or else Kind (Bare_Body_Stub) in Ada_Body_Stub;
         subtype Bare_Package_Body_Stub is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Package_Body_Stub)
               or else Kind (Bare_Package_Body_Stub) in Ada_Package_Body_Stub_Range;
         subtype Bare_Protected_Body_Stub is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Protected_Body_Stub)
               or else Kind (Bare_Protected_Body_Stub) in Ada_Protected_Body_Stub_Range;
         subtype Bare_Subp_Body_Stub is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subp_Body_Stub)
               or else Kind (Bare_Subp_Body_Stub) in Ada_Subp_Body_Stub_Range;
         subtype Bare_Task_Body_Stub is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Task_Body_Stub)
               or else Kind (Bare_Task_Body_Stub) in Ada_Task_Body_Stub_Range;
         subtype Bare_Entry_Body is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Entry_Body)
               or else Kind (Bare_Entry_Body) in Ada_Entry_Body_Range;
         subtype Bare_Package_Body is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Package_Body)
               or else Kind (Bare_Package_Body) in Ada_Package_Body_Range;
         subtype Bare_Protected_Body is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Protected_Body)
               or else Kind (Bare_Protected_Body) in Ada_Protected_Body_Range;
         subtype Bare_Task_Body is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Task_Body)
               or else Kind (Bare_Task_Body) in Ada_Task_Body_Range;
         subtype Bare_Entry_Index_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Entry_Index_Spec)
               or else Kind (Bare_Entry_Index_Spec) in Ada_Entry_Index_Spec_Range;
         subtype Bare_Error_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Error_Decl)
               or else Kind (Bare_Error_Decl) in Ada_Error_Decl_Range;
         subtype Bare_Exception_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Exception_Decl)
               or else Kind (Bare_Exception_Decl) in Ada_Exception_Decl_Range;
         subtype Bare_Exception_Handler is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Exception_Handler)
               or else Kind (Bare_Exception_Handler) in Ada_Exception_Handler_Range;
         subtype Bare_For_Loop_Var_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_For_Loop_Var_Decl)
               or else Kind (Bare_For_Loop_Var_Decl) in Ada_For_Loop_Var_Decl_Range;
         subtype Bare_Generic_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Decl)
               or else Kind (Bare_Generic_Decl) in Ada_Generic_Decl;
         subtype Bare_Generic_Package_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Package_Decl)
               or else Kind (Bare_Generic_Package_Decl) in Ada_Generic_Package_Decl_Range;
         subtype Bare_Generic_Subp_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Subp_Decl)
               or else Kind (Bare_Generic_Subp_Decl) in Ada_Generic_Subp_Decl_Range;
         subtype Bare_Generic_Instantiation is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Instantiation)
               or else Kind (Bare_Generic_Instantiation) in Ada_Generic_Instantiation;
         subtype Bare_Generic_Package_Instantiation is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Package_Instantiation)
               or else Kind (Bare_Generic_Package_Instantiation) in Ada_Generic_Package_Instantiation_Range;
         subtype Bare_Generic_Subp_Instantiation is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Subp_Instantiation)
               or else Kind (Bare_Generic_Subp_Instantiation) in Ada_Generic_Subp_Instantiation_Range;
         subtype Bare_Generic_Renaming_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Renaming_Decl)
               or else Kind (Bare_Generic_Renaming_Decl) in Ada_Generic_Renaming_Decl;
         subtype Bare_Generic_Package_Renaming_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Package_Renaming_Decl)
               or else Kind (Bare_Generic_Package_Renaming_Decl) in Ada_Generic_Package_Renaming_Decl_Range;
         subtype Bare_Generic_Subp_Renaming_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Generic_Subp_Renaming_Decl)
               or else Kind (Bare_Generic_Subp_Renaming_Decl) in Ada_Generic_Subp_Renaming_Decl_Range;
         subtype Bare_Label_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Label_Decl)
               or else Kind (Bare_Label_Decl) in Ada_Label_Decl_Range;
         subtype Bare_Named_Stmt_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Named_Stmt_Decl)
               or else Kind (Bare_Named_Stmt_Decl) in Ada_Named_Stmt_Decl_Range;
         subtype Bare_Number_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Number_Decl)
               or else Kind (Bare_Number_Decl) in Ada_Number_Decl_Range;
         subtype Bare_Object_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Object_Decl)
               or else Kind (Bare_Object_Decl) in Ada_Object_Decl_Range;
         subtype Bare_Extended_Return_Stmt_Object_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Extended_Return_Stmt_Object_Decl)
               or else Kind (Bare_Extended_Return_Stmt_Object_Decl) in Ada_Extended_Return_Stmt_Object_Decl_Range;
         subtype Bare_No_Type_Object_Renaming_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_No_Type_Object_Renaming_Decl)
               or else Kind (Bare_No_Type_Object_Renaming_Decl) in Ada_No_Type_Object_Renaming_Decl_Range;
         subtype Bare_Package_Renaming_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Package_Renaming_Decl)
               or else Kind (Bare_Package_Renaming_Decl) in Ada_Package_Renaming_Decl_Range;
         subtype Bare_Single_Protected_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Single_Protected_Decl)
               or else Kind (Bare_Single_Protected_Decl) in Ada_Single_Protected_Decl_Range;
         subtype Bare_Single_Task_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Single_Task_Decl)
               or else Kind (Bare_Single_Task_Decl) in Ada_Single_Task_Decl_Range;
         subtype Bare_Case_Stmt_Alternative is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Case_Stmt_Alternative)
               or else Kind (Bare_Case_Stmt_Alternative) in Ada_Case_Stmt_Alternative_Range;
         subtype Bare_Compilation_Unit is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Compilation_Unit)
               or else Kind (Bare_Compilation_Unit) in Ada_Compilation_Unit_Range;
         subtype Bare_Component_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Component_Clause)
               or else Kind (Bare_Component_Clause) in Ada_Component_Clause_Range;
         subtype Bare_Component_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Component_Def)
               or else Kind (Bare_Component_Def) in Ada_Component_Def_Range;
         subtype Bare_Constant_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Constant_Node)
               or else Kind (Bare_Constant_Node) in Ada_Constant_Node;
         subtype Bare_Constant_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Constant_Absent)
               or else Kind (Bare_Constant_Absent) in Ada_Constant_Absent_Range;
         subtype Bare_Constant_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Constant_Present)
               or else Kind (Bare_Constant_Present) in Ada_Constant_Present_Range;
         subtype Bare_Constraint is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Constraint)
               or else Kind (Bare_Constraint) in Ada_Constraint;
         subtype Bare_Composite_Constraint is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Composite_Constraint)
               or else Kind (Bare_Composite_Constraint) in Ada_Composite_Constraint_Range;
         subtype Bare_Delta_Constraint is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Delta_Constraint)
               or else Kind (Bare_Delta_Constraint) in Ada_Delta_Constraint_Range;
         subtype Bare_Digits_Constraint is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Digits_Constraint)
               or else Kind (Bare_Digits_Constraint) in Ada_Digits_Constraint_Range;
         subtype Bare_Range_Constraint is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Range_Constraint)
               or else Kind (Bare_Range_Constraint) in Ada_Range_Constraint_Range;
         subtype Bare_Declarative_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Declarative_Part)
               or else Kind (Bare_Declarative_Part) in Ada_Declarative_Part_Range;
         subtype Bare_Private_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Private_Part)
               or else Kind (Bare_Private_Part) in Ada_Private_Part_Range;
         subtype Bare_Public_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Public_Part)
               or else Kind (Bare_Public_Part) in Ada_Public_Part_Range;
         subtype Bare_Elsif_Expr_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Elsif_Expr_Part)
               or else Kind (Bare_Elsif_Expr_Part) in Ada_Elsif_Expr_Part_Range;
         subtype Bare_Elsif_Stmt_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Elsif_Stmt_Part)
               or else Kind (Bare_Elsif_Stmt_Part) in Ada_Elsif_Stmt_Part_Range;
         subtype Bare_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Expr)
               or else Kind (Bare_Expr) in Ada_Expr;
         subtype Bare_Abstract_State_Decl_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abstract_State_Decl_Expr)
               or else Kind (Bare_Abstract_State_Decl_Expr) in Ada_Abstract_State_Decl_Expr_Range;
         subtype Bare_Allocator is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Allocator)
               or else Kind (Bare_Allocator) in Ada_Allocator_Range;
         subtype Bare_Base_Aggregate is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Aggregate)
               or else Kind (Bare_Base_Aggregate) in Ada_Base_Aggregate;
         subtype Bare_Aggregate is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Aggregate)
               or else Kind (Bare_Aggregate) in Ada_Aggregate_Range;
         subtype Bare_Bracket_Aggregate is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Bracket_Aggregate)
               or else Kind (Bare_Bracket_Aggregate) in Ada_Bracket_Aggregate_Range;
         subtype Bare_Delta_Aggregate is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Delta_Aggregate)
               or else Kind (Bare_Delta_Aggregate) in Ada_Delta_Aggregate_Range;
         subtype Bare_Bracket_Delta_Aggregate is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Bracket_Delta_Aggregate)
               or else Kind (Bare_Bracket_Delta_Aggregate) in Ada_Bracket_Delta_Aggregate_Range;
         subtype Bare_Null_Record_Aggregate is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Record_Aggregate)
               or else Kind (Bare_Null_Record_Aggregate) in Ada_Null_Record_Aggregate_Range;
         subtype Bare_Bin_Op is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Bin_Op)
               or else Kind (Bare_Bin_Op) in Ada_Bin_Op_Range;
         subtype Bare_Relation_Op is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Relation_Op)
               or else Kind (Bare_Relation_Op) in Ada_Relation_Op_Range;
         subtype Bare_Box_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Box_Expr)
               or else Kind (Bare_Box_Expr) in Ada_Box_Expr_Range;
         subtype Bare_Case_Expr_Alternative is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Case_Expr_Alternative)
               or else Kind (Bare_Case_Expr_Alternative) in Ada_Case_Expr_Alternative_Range;
         subtype Bare_Concat_Op is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Concat_Op)
               or else Kind (Bare_Concat_Op) in Ada_Concat_Op_Range;
         subtype Bare_Concat_Operand is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Concat_Operand)
               or else Kind (Bare_Concat_Operand) in Ada_Concat_Operand_Range;
         subtype Bare_Cond_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Cond_Expr)
               or else Kind (Bare_Cond_Expr) in Ada_Cond_Expr;
         subtype Bare_Case_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Case_Expr)
               or else Kind (Bare_Case_Expr) in Ada_Case_Expr_Range;
         subtype Bare_If_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_If_Expr)
               or else Kind (Bare_If_Expr) in Ada_If_Expr_Range;
         subtype Bare_Contract_Cases is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Contract_Cases)
               or else Kind (Bare_Contract_Cases) in Ada_Contract_Cases_Range;
         subtype Bare_Decl_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Decl_Expr)
               or else Kind (Bare_Decl_Expr) in Ada_Decl_Expr_Range;
         subtype Bare_Membership_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Membership_Expr)
               or else Kind (Bare_Membership_Expr) in Ada_Membership_Expr_Range;
         subtype Bare_Name is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Name)
               or else Kind (Bare_Name) in Ada_Name;
         subtype Bare_Attribute_Ref is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Attribute_Ref)
               or else Kind (Bare_Attribute_Ref) in Ada_Attribute_Ref_Range;
         subtype Bare_Call_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Call_Expr)
               or else Kind (Bare_Call_Expr) in Ada_Call_Expr_Range;
         subtype Bare_Defining_Name is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Defining_Name)
               or else Kind (Bare_Defining_Name) in Ada_Defining_Name_Range;
         subtype Bare_Synthetic_Defining_Name is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Defining_Name)
               or else Kind (Bare_Synthetic_Defining_Name) in Ada_Synthetic_Defining_Name_Range;
         subtype Bare_Discrete_Subtype_Name is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Discrete_Subtype_Name)
               or else Kind (Bare_Discrete_Subtype_Name) in Ada_Discrete_Subtype_Name_Range;
         subtype Bare_Dotted_Name is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Dotted_Name)
               or else Kind (Bare_Dotted_Name) in Ada_Dotted_Name_Range;
         subtype Bare_End_Name is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_End_Name)
               or else Kind (Bare_End_Name) in Ada_End_Name_Range;
         subtype Bare_Explicit_Deref is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Explicit_Deref)
               or else Kind (Bare_Explicit_Deref) in Ada_Explicit_Deref_Range;
         subtype Bare_Qual_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Qual_Expr)
               or else Kind (Bare_Qual_Expr) in Ada_Qual_Expr_Range;
         subtype Bare_Reduce_Attribute_Ref is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Reduce_Attribute_Ref)
               or else Kind (Bare_Reduce_Attribute_Ref) in Ada_Reduce_Attribute_Ref_Range;
         subtype Bare_Single_Tok_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Single_Tok_Node)
               or else Kind (Bare_Single_Tok_Node) in Ada_Single_Tok_Node;
         subtype Bare_Base_Id is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Id)
               or else Kind (Bare_Base_Id) in Ada_Base_Id;
         subtype Bare_Char_Literal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Char_Literal)
               or else Kind (Bare_Char_Literal) in Ada_Char_Literal_Range;
         subtype Bare_Identifier is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Identifier)
               or else Kind (Bare_Identifier) in Ada_Identifier_Range;
         subtype Bare_Op is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op)
               or else Kind (Bare_Op) in Ada_Op;
         subtype Bare_Op_Abs is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Abs)
               or else Kind (Bare_Op_Abs) in Ada_Op_Abs_Range;
         subtype Bare_Op_And is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_And)
               or else Kind (Bare_Op_And) in Ada_Op_And_Range;
         subtype Bare_Op_And_Then is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_And_Then)
               or else Kind (Bare_Op_And_Then) in Ada_Op_And_Then_Range;
         subtype Bare_Op_Concat is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Concat)
               or else Kind (Bare_Op_Concat) in Ada_Op_Concat_Range;
         subtype Bare_Op_Div is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Div)
               or else Kind (Bare_Op_Div) in Ada_Op_Div_Range;
         subtype Bare_Op_Double_Dot is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Double_Dot)
               or else Kind (Bare_Op_Double_Dot) in Ada_Op_Double_Dot_Range;
         subtype Bare_Op_Eq is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Eq)
               or else Kind (Bare_Op_Eq) in Ada_Op_Eq_Range;
         subtype Bare_Op_Gt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Gt)
               or else Kind (Bare_Op_Gt) in Ada_Op_Gt_Range;
         subtype Bare_Op_Gte is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Gte)
               or else Kind (Bare_Op_Gte) in Ada_Op_Gte_Range;
         subtype Bare_Op_In is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_In)
               or else Kind (Bare_Op_In) in Ada_Op_In_Range;
         subtype Bare_Op_Lt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Lt)
               or else Kind (Bare_Op_Lt) in Ada_Op_Lt_Range;
         subtype Bare_Op_Lte is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Lte)
               or else Kind (Bare_Op_Lte) in Ada_Op_Lte_Range;
         subtype Bare_Op_Minus is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Minus)
               or else Kind (Bare_Op_Minus) in Ada_Op_Minus_Range;
         subtype Bare_Op_Mod is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Mod)
               or else Kind (Bare_Op_Mod) in Ada_Op_Mod_Range;
         subtype Bare_Op_Mult is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Mult)
               or else Kind (Bare_Op_Mult) in Ada_Op_Mult_Range;
         subtype Bare_Op_Neq is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Neq)
               or else Kind (Bare_Op_Neq) in Ada_Op_Neq_Range;
         subtype Bare_Op_Not is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Not)
               or else Kind (Bare_Op_Not) in Ada_Op_Not_Range;
         subtype Bare_Op_Not_In is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Not_In)
               or else Kind (Bare_Op_Not_In) in Ada_Op_Not_In_Range;
         subtype Bare_Op_Or is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Or)
               or else Kind (Bare_Op_Or) in Ada_Op_Or_Range;
         subtype Bare_Op_Or_Else is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Or_Else)
               or else Kind (Bare_Op_Or_Else) in Ada_Op_Or_Else_Range;
         subtype Bare_Op_Plus is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Plus)
               or else Kind (Bare_Op_Plus) in Ada_Op_Plus_Range;
         subtype Bare_Op_Pow is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Pow)
               or else Kind (Bare_Op_Pow) in Ada_Op_Pow_Range;
         subtype Bare_Op_Rem is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Rem)
               or else Kind (Bare_Op_Rem) in Ada_Op_Rem_Range;
         subtype Bare_Op_Xor is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Op_Xor)
               or else Kind (Bare_Op_Xor) in Ada_Op_Xor_Range;
         subtype Bare_String_Literal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_String_Literal)
               or else Kind (Bare_String_Literal) in Ada_String_Literal_Range;
         subtype Bare_Null_Literal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Literal)
               or else Kind (Bare_Null_Literal) in Ada_Null_Literal_Range;
         subtype Bare_Num_Literal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Num_Literal)
               or else Kind (Bare_Num_Literal) in Ada_Num_Literal;
         subtype Bare_Int_Literal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Int_Literal)
               or else Kind (Bare_Int_Literal) in Ada_Int_Literal_Range;
         subtype Bare_Real_Literal is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Real_Literal)
               or else Kind (Bare_Real_Literal) in Ada_Real_Literal_Range;
         subtype Bare_Synthetic_Identifier is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Identifier)
               or else Kind (Bare_Synthetic_Identifier) in Ada_Synthetic_Identifier_Range;
         subtype Bare_Target_Name is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Target_Name)
               or else Kind (Bare_Target_Name) in Ada_Target_Name_Range;
         subtype Bare_Update_Attribute_Ref is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Update_Attribute_Ref)
               or else Kind (Bare_Update_Attribute_Ref) in Ada_Update_Attribute_Ref_Range;
         subtype Bare_Paren_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Paren_Expr)
               or else Kind (Bare_Paren_Expr) in Ada_Paren_Expr_Range;
         subtype Bare_Quantified_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Quantified_Expr)
               or else Kind (Bare_Quantified_Expr) in Ada_Quantified_Expr_Range;
         subtype Bare_Raise_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Raise_Expr)
               or else Kind (Bare_Raise_Expr) in Ada_Raise_Expr_Range;
         subtype Bare_Un_Op is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Un_Op)
               or else Kind (Bare_Un_Op) in Ada_Un_Op_Range;
         subtype Bare_Handled_Stmts is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Handled_Stmts)
               or else Kind (Bare_Handled_Stmts) in Ada_Handled_Stmts_Range;
         subtype Bare_Interface_Kind is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Interface_Kind)
               or else Kind (Bare_Interface_Kind) in Ada_Interface_Kind;
         subtype Bare_Interface_Kind_Limited is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Interface_Kind_Limited)
               or else Kind (Bare_Interface_Kind_Limited) in Ada_Interface_Kind_Limited_Range;
         subtype Bare_Interface_Kind_Protected is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Interface_Kind_Protected)
               or else Kind (Bare_Interface_Kind_Protected) in Ada_Interface_Kind_Protected_Range;
         subtype Bare_Interface_Kind_Synchronized is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Interface_Kind_Synchronized)
               or else Kind (Bare_Interface_Kind_Synchronized) in Ada_Interface_Kind_Synchronized_Range;
         subtype Bare_Interface_Kind_Task is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Interface_Kind_Task)
               or else Kind (Bare_Interface_Kind_Task) in Ada_Interface_Kind_Task_Range;
         subtype Bare_Iter_Type is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Iter_Type)
               or else Kind (Bare_Iter_Type) in Ada_Iter_Type;
         subtype Bare_Iter_Type_In is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Iter_Type_In)
               or else Kind (Bare_Iter_Type_In) in Ada_Iter_Type_In_Range;
         subtype Bare_Iter_Type_Of is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Iter_Type_Of)
               or else Kind (Bare_Iter_Type_Of) in Ada_Iter_Type_Of_Range;
         subtype Bare_Library_Item is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Library_Item)
               or else Kind (Bare_Library_Item) in Ada_Library_Item_Range;
         subtype Bare_Limited_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Limited_Node)
               or else Kind (Bare_Limited_Node) in Ada_Limited_Node;
         subtype Bare_Limited_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Limited_Absent)
               or else Kind (Bare_Limited_Absent) in Ada_Limited_Absent_Range;
         subtype Bare_Limited_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Limited_Present)
               or else Kind (Bare_Limited_Present) in Ada_Limited_Present_Range;
         subtype Bare_Loop_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Loop_Spec)
               or else Kind (Bare_Loop_Spec) in Ada_Loop_Spec;
         subtype Bare_For_Loop_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_For_Loop_Spec)
               or else Kind (Bare_For_Loop_Spec) in Ada_For_Loop_Spec_Range;
         subtype Bare_While_Loop_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_While_Loop_Spec)
               or else Kind (Bare_While_Loop_Spec) in Ada_While_Loop_Spec_Range;
         subtype Bare_Mode is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Mode)
               or else Kind (Bare_Mode) in Ada_Mode;
         subtype Bare_Mode_Default is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Mode_Default)
               or else Kind (Bare_Mode_Default) in Ada_Mode_Default_Range;
         subtype Bare_Mode_In is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Mode_In)
               or else Kind (Bare_Mode_In) in Ada_Mode_In_Range;
         subtype Bare_Mode_In_Out is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Mode_In_Out)
               or else Kind (Bare_Mode_In_Out) in Ada_Mode_In_Out_Range;
         subtype Bare_Mode_Out is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Mode_Out)
               or else Kind (Bare_Mode_Out) in Ada_Mode_Out_Range;
         subtype Bare_Multi_Abstract_State_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Multi_Abstract_State_Decl)
               or else Kind (Bare_Multi_Abstract_State_Decl) in Ada_Multi_Abstract_State_Decl_Range;
         subtype Bare_Not_Null is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Not_Null)
               or else Kind (Bare_Not_Null) in Ada_Not_Null;
         subtype Bare_Not_Null_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Not_Null_Absent)
               or else Kind (Bare_Not_Null_Absent) in Ada_Not_Null_Absent_Range;
         subtype Bare_Not_Null_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Not_Null_Present)
               or else Kind (Bare_Not_Null_Present) in Ada_Not_Null_Present_Range;
         subtype Bare_Null_Component_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Component_Decl)
               or else Kind (Bare_Null_Component_Decl) in Ada_Null_Component_Decl_Range;
         subtype Bare_Others_Designator is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Others_Designator)
               or else Kind (Bare_Others_Designator) in Ada_Others_Designator_Range;
         subtype Bare_Overriding_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Overriding_Node)
               or else Kind (Bare_Overriding_Node) in Ada_Overriding_Node;
         subtype Bare_Overriding_Not_Overriding is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Overriding_Not_Overriding)
               or else Kind (Bare_Overriding_Not_Overriding) in Ada_Overriding_Not_Overriding_Range;
         subtype Bare_Overriding_Overriding is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Overriding_Overriding)
               or else Kind (Bare_Overriding_Overriding) in Ada_Overriding_Overriding_Range;
         subtype Bare_Overriding_Unspecified is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Overriding_Unspecified)
               or else Kind (Bare_Overriding_Unspecified) in Ada_Overriding_Unspecified_Range;
         subtype Bare_Params is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Params)
               or else Kind (Bare_Params) in Ada_Params_Range;
         subtype Bare_Paren_Abstract_State_Decl is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Paren_Abstract_State_Decl)
               or else Kind (Bare_Paren_Abstract_State_Decl) in Ada_Paren_Abstract_State_Decl_Range;
         subtype Bare_Pp_Directive is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pp_Directive)
               or else Kind (Bare_Pp_Directive) in Ada_Pp_Directive;
         subtype Bare_Pp_Else_Directive is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pp_Else_Directive)
               or else Kind (Bare_Pp_Else_Directive) in Ada_Pp_Else_Directive_Range;
         subtype Bare_Pp_Elsif_Directive is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pp_Elsif_Directive)
               or else Kind (Bare_Pp_Elsif_Directive) in Ada_Pp_Elsif_Directive_Range;
         subtype Bare_Pp_End_If_Directive is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pp_End_If_Directive)
               or else Kind (Bare_Pp_End_If_Directive) in Ada_Pp_End_If_Directive_Range;
         subtype Bare_Pp_If_Directive is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pp_If_Directive)
               or else Kind (Bare_Pp_If_Directive) in Ada_Pp_If_Directive_Range;
         subtype Bare_Pp_Then_Kw is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pp_Then_Kw)
               or else Kind (Bare_Pp_Then_Kw) in Ada_Pp_Then_Kw_Range;
         subtype Bare_Pragma_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Pragma_Node)
               or else Kind (Bare_Pragma_Node) in Ada_Pragma_Node_Range;
         subtype Bare_Private_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Private_Node)
               or else Kind (Bare_Private_Node) in Ada_Private_Node;
         subtype Bare_Private_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Private_Absent)
               or else Kind (Bare_Private_Absent) in Ada_Private_Absent_Range;
         subtype Bare_Private_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Private_Present)
               or else Kind (Bare_Private_Present) in Ada_Private_Present_Range;
         subtype Bare_Protected_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Protected_Def)
               or else Kind (Bare_Protected_Def) in Ada_Protected_Def_Range;
         subtype Bare_Protected_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Protected_Node)
               or else Kind (Bare_Protected_Node) in Ada_Protected_Node;
         subtype Bare_Protected_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Protected_Absent)
               or else Kind (Bare_Protected_Absent) in Ada_Protected_Absent_Range;
         subtype Bare_Protected_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Protected_Present)
               or else Kind (Bare_Protected_Present) in Ada_Protected_Present_Range;
         subtype Bare_Quantifier is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Quantifier)
               or else Kind (Bare_Quantifier) in Ada_Quantifier;
         subtype Bare_Quantifier_All is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Quantifier_All)
               or else Kind (Bare_Quantifier_All) in Ada_Quantifier_All_Range;
         subtype Bare_Quantifier_Some is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Quantifier_Some)
               or else Kind (Bare_Quantifier_Some) in Ada_Quantifier_Some_Range;
         subtype Bare_Range_Spec is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Range_Spec)
               or else Kind (Bare_Range_Spec) in Ada_Range_Spec_Range;
         subtype Bare_Renaming_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Renaming_Clause)
               or else Kind (Bare_Renaming_Clause) in Ada_Renaming_Clause_Range;
         subtype Bare_Synthetic_Renaming_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Renaming_Clause)
               or else Kind (Bare_Synthetic_Renaming_Clause) in Ada_Synthetic_Renaming_Clause_Range;
         subtype Bare_Reverse_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Reverse_Node)
               or else Kind (Bare_Reverse_Node) in Ada_Reverse_Node;
         subtype Bare_Reverse_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Reverse_Absent)
               or else Kind (Bare_Reverse_Absent) in Ada_Reverse_Absent_Range;
         subtype Bare_Reverse_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Reverse_Present)
               or else Kind (Bare_Reverse_Present) in Ada_Reverse_Present_Range;
         subtype Bare_Select_When_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Select_When_Part)
               or else Kind (Bare_Select_When_Part) in Ada_Select_When_Part_Range;
         subtype Bare_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Stmt)
               or else Kind (Bare_Stmt) in Ada_Stmt;
         subtype Bare_Composite_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Composite_Stmt)
               or else Kind (Bare_Composite_Stmt) in Ada_Composite_Stmt;
         subtype Bare_Accept_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Accept_Stmt)
               or else Kind (Bare_Accept_Stmt) in Ada_Accept_Stmt_Range;
         subtype Bare_Accept_Stmt_With_Stmts is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Accept_Stmt_With_Stmts)
               or else Kind (Bare_Accept_Stmt_With_Stmts) in Ada_Accept_Stmt_With_Stmts_Range;
         subtype Bare_Base_Loop_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Loop_Stmt)
               or else Kind (Bare_Base_Loop_Stmt) in Ada_Base_Loop_Stmt;
         subtype Bare_For_Loop_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_For_Loop_Stmt)
               or else Kind (Bare_For_Loop_Stmt) in Ada_For_Loop_Stmt_Range;
         subtype Bare_Loop_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Loop_Stmt)
               or else Kind (Bare_Loop_Stmt) in Ada_Loop_Stmt_Range;
         subtype Bare_While_Loop_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_While_Loop_Stmt)
               or else Kind (Bare_While_Loop_Stmt) in Ada_While_Loop_Stmt_Range;
         subtype Bare_Block_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Block_Stmt)
               or else Kind (Bare_Block_Stmt) in Ada_Block_Stmt;
         subtype Bare_Begin_Block is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Begin_Block)
               or else Kind (Bare_Begin_Block) in Ada_Begin_Block_Range;
         subtype Bare_Decl_Block is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Decl_Block)
               or else Kind (Bare_Decl_Block) in Ada_Decl_Block_Range;
         subtype Bare_Case_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Case_Stmt)
               or else Kind (Bare_Case_Stmt) in Ada_Case_Stmt_Range;
         subtype Bare_Extended_Return_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Extended_Return_Stmt)
               or else Kind (Bare_Extended_Return_Stmt) in Ada_Extended_Return_Stmt_Range;
         subtype Bare_If_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_If_Stmt)
               or else Kind (Bare_If_Stmt) in Ada_If_Stmt_Range;
         subtype Bare_Named_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Named_Stmt)
               or else Kind (Bare_Named_Stmt) in Ada_Named_Stmt_Range;
         subtype Bare_Select_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Select_Stmt)
               or else Kind (Bare_Select_Stmt) in Ada_Select_Stmt_Range;
         subtype Bare_Error_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Error_Stmt)
               or else Kind (Bare_Error_Stmt) in Ada_Error_Stmt_Range;
         subtype Bare_Simple_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Simple_Stmt)
               or else Kind (Bare_Simple_Stmt) in Ada_Simple_Stmt;
         subtype Bare_Abort_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Abort_Stmt)
               or else Kind (Bare_Abort_Stmt) in Ada_Abort_Stmt_Range;
         subtype Bare_Assign_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Assign_Stmt)
               or else Kind (Bare_Assign_Stmt) in Ada_Assign_Stmt_Range;
         subtype Bare_Call_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Call_Stmt)
               or else Kind (Bare_Call_Stmt) in Ada_Call_Stmt_Range;
         subtype Bare_Delay_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Delay_Stmt)
               or else Kind (Bare_Delay_Stmt) in Ada_Delay_Stmt_Range;
         subtype Bare_Exit_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Exit_Stmt)
               or else Kind (Bare_Exit_Stmt) in Ada_Exit_Stmt_Range;
         subtype Bare_Goto_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Goto_Stmt)
               or else Kind (Bare_Goto_Stmt) in Ada_Goto_Stmt_Range;
         subtype Bare_Label is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Label)
               or else Kind (Bare_Label) in Ada_Label_Range;
         subtype Bare_Null_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Null_Stmt)
               or else Kind (Bare_Null_Stmt) in Ada_Null_Stmt_Range;
         subtype Bare_Raise_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Raise_Stmt)
               or else Kind (Bare_Raise_Stmt) in Ada_Raise_Stmt_Range;
         subtype Bare_Requeue_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Requeue_Stmt)
               or else Kind (Bare_Requeue_Stmt) in Ada_Requeue_Stmt_Range;
         subtype Bare_Return_Stmt is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Return_Stmt)
               or else Kind (Bare_Return_Stmt) in Ada_Return_Stmt_Range;
         subtype Bare_Terminate_Alternative is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Terminate_Alternative)
               or else Kind (Bare_Terminate_Alternative) in Ada_Terminate_Alternative_Range;
         subtype Bare_Subp_Kind is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subp_Kind)
               or else Kind (Bare_Subp_Kind) in Ada_Subp_Kind;
         subtype Bare_Subp_Kind_Function is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subp_Kind_Function)
               or else Kind (Bare_Subp_Kind_Function) in Ada_Subp_Kind_Function_Range;
         subtype Bare_Subp_Kind_Procedure is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subp_Kind_Procedure)
               or else Kind (Bare_Subp_Kind_Procedure) in Ada_Subp_Kind_Procedure_Range;
         subtype Bare_Subunit is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subunit)
               or else Kind (Bare_Subunit) in Ada_Subunit_Range;
         subtype Bare_Synchronized_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synchronized_Node)
               or else Kind (Bare_Synchronized_Node) in Ada_Synchronized_Node;
         subtype Bare_Synchronized_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synchronized_Absent)
               or else Kind (Bare_Synchronized_Absent) in Ada_Synchronized_Absent_Range;
         subtype Bare_Synchronized_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synchronized_Present)
               or else Kind (Bare_Synchronized_Present) in Ada_Synchronized_Present_Range;
         subtype Bare_Tagged_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Tagged_Node)
               or else Kind (Bare_Tagged_Node) in Ada_Tagged_Node;
         subtype Bare_Tagged_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Tagged_Absent)
               or else Kind (Bare_Tagged_Absent) in Ada_Tagged_Absent_Range;
         subtype Bare_Tagged_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Tagged_Present)
               or else Kind (Bare_Tagged_Present) in Ada_Tagged_Present_Range;
         subtype Bare_Task_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Task_Def)
               or else Kind (Bare_Task_Def) in Ada_Task_Def_Range;
         subtype Bare_Type_Attributes_Repository is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Attributes_Repository)
               or else Kind (Bare_Type_Attributes_Repository) in Ada_Type_Attributes_Repository_Range;
         subtype Bare_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Def)
               or else Kind (Bare_Type_Def) in Ada_Type_Def;
         subtype Bare_Access_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Access_Def)
               or else Kind (Bare_Access_Def) in Ada_Access_Def;
         subtype Bare_Access_To_Subp_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Access_To_Subp_Def)
               or else Kind (Bare_Access_To_Subp_Def) in Ada_Access_To_Subp_Def_Range;
         subtype Bare_Base_Type_Access_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Base_Type_Access_Def)
               or else Kind (Bare_Base_Type_Access_Def) in Ada_Base_Type_Access_Def;
         subtype Bare_Anonymous_Type_Access_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Anonymous_Type_Access_Def)
               or else Kind (Bare_Anonymous_Type_Access_Def) in Ada_Anonymous_Type_Access_Def_Range;
         subtype Bare_Type_Access_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Access_Def)
               or else Kind (Bare_Type_Access_Def) in Ada_Type_Access_Def_Range;
         subtype Bare_Array_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Array_Type_Def)
               or else Kind (Bare_Array_Type_Def) in Ada_Array_Type_Def_Range;
         subtype Bare_Derived_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Derived_Type_Def)
               or else Kind (Bare_Derived_Type_Def) in Ada_Derived_Type_Def_Range;
         subtype Bare_Enum_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Enum_Type_Def)
               or else Kind (Bare_Enum_Type_Def) in Ada_Enum_Type_Def_Range;
         subtype Bare_Formal_Discrete_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Formal_Discrete_Type_Def)
               or else Kind (Bare_Formal_Discrete_Type_Def) in Ada_Formal_Discrete_Type_Def_Range;
         subtype Bare_Interface_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Interface_Type_Def)
               or else Kind (Bare_Interface_Type_Def) in Ada_Interface_Type_Def_Range;
         subtype Bare_Mod_Int_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Mod_Int_Type_Def)
               or else Kind (Bare_Mod_Int_Type_Def) in Ada_Mod_Int_Type_Def_Range;
         subtype Bare_Private_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Private_Type_Def)
               or else Kind (Bare_Private_Type_Def) in Ada_Private_Type_Def_Range;
         subtype Bare_Real_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Real_Type_Def)
               or else Kind (Bare_Real_Type_Def) in Ada_Real_Type_Def;
         subtype Bare_Decimal_Fixed_Point_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Decimal_Fixed_Point_Def)
               or else Kind (Bare_Decimal_Fixed_Point_Def) in Ada_Decimal_Fixed_Point_Def_Range;
         subtype Bare_Floating_Point_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Floating_Point_Def)
               or else Kind (Bare_Floating_Point_Def) in Ada_Floating_Point_Def_Range;
         subtype Bare_Ordinary_Fixed_Point_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Ordinary_Fixed_Point_Def)
               or else Kind (Bare_Ordinary_Fixed_Point_Def) in Ada_Ordinary_Fixed_Point_Def_Range;
         subtype Bare_Record_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Record_Type_Def)
               or else Kind (Bare_Record_Type_Def) in Ada_Record_Type_Def_Range;
         subtype Bare_Signed_Int_Type_Def is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Signed_Int_Type_Def)
               or else Kind (Bare_Signed_Int_Type_Def) in Ada_Signed_Int_Type_Def_Range;
         subtype Bare_Type_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Type_Expr)
               or else Kind (Bare_Type_Expr) in Ada_Type_Expr;
         subtype Bare_Anonymous_Type is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Anonymous_Type)
               or else Kind (Bare_Anonymous_Type) in Ada_Anonymous_Type_Range;
         subtype Bare_Enum_Lit_Synth_Type_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Enum_Lit_Synth_Type_Expr)
               or else Kind (Bare_Enum_Lit_Synth_Type_Expr) in Ada_Enum_Lit_Synth_Type_Expr_Range;
         subtype Bare_Subtype_Indication is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Subtype_Indication)
               or else Kind (Bare_Subtype_Indication) in Ada_Subtype_Indication_Range;
         subtype Bare_Constrained_Subtype_Indication is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Constrained_Subtype_Indication)
               or else Kind (Bare_Constrained_Subtype_Indication) in Ada_Constrained_Subtype_Indication_Range;
         subtype Bare_Discrete_Subtype_Indication is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Discrete_Subtype_Indication)
               or else Kind (Bare_Discrete_Subtype_Indication) in Ada_Discrete_Subtype_Indication_Range;
         subtype Bare_Synthetic_Type_Expr is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Synthetic_Type_Expr)
               or else Kind (Bare_Synthetic_Type_Expr) in Ada_Synthetic_Type_Expr_Range;
         subtype Bare_Unconstrained_Array_Index is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Unconstrained_Array_Index)
               or else Kind (Bare_Unconstrained_Array_Index) in Ada_Unconstrained_Array_Index_Range;
         subtype Bare_Until_Node is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Until_Node)
               or else Kind (Bare_Until_Node) in Ada_Until_Node;
         subtype Bare_Until_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Until_Absent)
               or else Kind (Bare_Until_Absent) in Ada_Until_Absent_Range;
         subtype Bare_Until_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Until_Present)
               or else Kind (Bare_Until_Present) in Ada_Until_Present_Range;
         subtype Bare_Use_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Use_Clause)
               or else Kind (Bare_Use_Clause) in Ada_Use_Clause;
         subtype Bare_Use_Package_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Use_Package_Clause)
               or else Kind (Bare_Use_Package_Clause) in Ada_Use_Package_Clause_Range;
         subtype Bare_Use_Type_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Use_Type_Clause)
               or else Kind (Bare_Use_Type_Clause) in Ada_Use_Type_Clause_Range;
         subtype Bare_Value_Sequence is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Value_Sequence)
               or else Kind (Bare_Value_Sequence) in Ada_Value_Sequence_Range;
         subtype Bare_Variant is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Variant)
               or else Kind (Bare_Variant) in Ada_Variant_Range;
         subtype Bare_Variant_Part is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_Variant_Part)
               or else Kind (Bare_Variant_Part) in Ada_Variant_Part_Range;
         subtype Bare_With_Clause is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_With_Clause)
               or else Kind (Bare_With_Clause) in Ada_With_Clause_Range;
         subtype Bare_With_Private is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_With_Private)
               or else Kind (Bare_With_Private) in Ada_With_Private;
         subtype Bare_With_Private_Absent is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_With_Private_Absent)
               or else Kind (Bare_With_Private_Absent) in Ada_With_Private_Absent_Range;
         subtype Bare_With_Private_Present is Bare_Ada_Node
            with Dynamic_Predicate =>
               Is_Null (Bare_With_Private_Present)
               or else Kind (Bare_With_Private_Present) in Ada_With_Private_Present_Range;

   package Alloc_AST_List_Array is new Langkit_Support.Bump_Ptr.Array_Alloc
     (Element_T  => Bare_Ada_Node,
      Index_Type => Positive);
   --  Allocator for array of nodes, used in list nodes

   type Rewriting_Handle_Pointer is new System.Address;
   No_Rewriting_Handle_Pointer : constant Rewriting_Handle_Pointer :=
      Rewriting_Handle_Pointer (System.Null_Address);

      Properties_Traces : constant GNATCOLL.Traces.Trace_Handle :=
         GNATCOLL.Traces.Create
           ("LANGKIT.PROPERTIES", GNATCOLL.Traces.On
           );

   function Short_Text_Image (Self : Bare_Ada_Node) return Text_Type;
   --  Return a short representation of the node, containing just the kind
   --  name and the sloc, or "None" if Self is null.

   function Is_Token_Node (Node : Bare_Ada_Node) return Boolean;
   --  Return whether this node is a node that contains only a single token.

   function Is_Synthetic (Node : Bare_Ada_Node) return Boolean;
   --  Return whether this node is synthetic.

   procedure Raise_Property_Exception
     (Node    : Bare_Ada_Node;
      Exc     : Ada.Exceptions.Exception_Id;
      Message : String)
     with No_Return;
   --  Raise an exception of the given type and with the given message. Prepend
   --  the sloc of the given node to the exception message.

   ---------------------------
   -- Iterators safety nets --
   ---------------------------

   type Iterator_Safety_Net is record
      Context         : Internal_Context;
      Context_Serial  : Version_Number;
      Context_Version : Version_Number;
      --  Analysis context, its serial number and version number at the time
      --  this safety net was produced.
   end record;

   No_Iterator_Safety_Net : constant Iterator_Safety_Net := (null, 0, 0);

   function Create_Safety_Net
     (Context : Internal_Context) return Iterator_Safety_Net;
   --  Create an iterator safety net from the given Context

   procedure Check_Safety_Net (Self : Iterator_Safety_Net);
   --  Check that the given iterator safety net is still valid, raising a
   --  Stale_Reference_Error if it is not.

   -----------------
   -- String type --
   -----------------

   type String_Record (Length : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Content : Text_Type (1 .. Length);
   end record;

   type String_Type is access all String_Record;

   Empty_String_Record : aliased String_Record :=
     (Length => 0, Ref_Count => -1, Content => (others => <>));
   Empty_String        : constant String_Type := Empty_String_Record'Access;

   procedure Inc_Ref (Self : String_Type);
   procedure Dec_Ref (Self : in out String_Type);
   procedure Free is new Ada.Unchecked_Deallocation
     (String_Record, String_Type);

   function Create_String (Content : Text_Type) return String_Type;
   function Create_String (Content : Unbounded_Text_Type) return String_Type;
   --  Create string values from their content. The overload for unbounded
   --  strings makes it easier for callers to avoid using the secondary stack,
   --  which can be a problem for big strings.

   function Concat_String (Left, Right : String_Type) return String_Type;
   --  Return a new string that is the concatenation of ``Left`` and ``Right``

   function Equivalent (Left, Right : String_Type) return Boolean;
   --  Return whether ``Left`` and ``Right`` contain equal strings

   ---------------------------
   -- Environments handling --
   ---------------------------

   
      type Internal_Metadata;
      

   

      

      type Internal_Metadata is record

               Dottable_Subp : aliased Boolean;
               --  Whether the stored element is a subprogram accessed through the
            --  dot notation
               
               Primitive : aliased Bare_Ada_Node;
               --  The type for which this subprogram is a primitive, if any
               
               Primitive_Real_Type : aliased Bare_Ada_Node;
               --  The type for which this subprogram is a primitive, if any
               
      end record
        with Convention => C;




   
      function Hash (R : Internal_Metadata) return Hash_Type;


      function Trace_Image (R : Internal_Metadata) return String;


   
      


      No_Metadata : constant Internal_Metadata :=
      (
               Dottable_Subp => False, 
               Primitive => No_Bare_Ada_Node, 
               Primitive_Real_Type => No_Bare_Ada_Node
      );


   
      type Internal_Inner_Env_Assoc;
      

   

      

      type Internal_Inner_Env_Assoc is record

               Key : aliased Symbol_Type;
               
               
               Value : aliased Bare_Ada_Node;
               
               
               Metadata : aliased Internal_Metadata;
               
               
      end record
        with Convention => C;




   


      function Trace_Image (R : Internal_Inner_Env_Assoc) return String;


   
      


      No_Inner_Env_Assoc : constant Internal_Inner_Env_Assoc :=
      (
               Key => null, 
               Value => No_Bare_Ada_Node, 
               Metadata => No_Metadata
      );

   function Get_Key (Self : Internal_Inner_Env_Assoc) return Symbol_Type
   is (Self.Key);
   function Get_Node
     (Self : Internal_Inner_Env_Assoc) return Bare_Ada_Node
   is (Self.Value);
   function Get_Metadata
     (Self : Internal_Inner_Env_Assoc) return Internal_Metadata
   is (Self.Metadata);

   
   type Internal_Inner_Env_Assoc_Array_Record;
   type Internal_Inner_Env_Assoc_Array_Access is access all Internal_Inner_Env_Assoc_Array_Record;

      
   type Internal_Internal_Inner_Env_Assoc_Iterator;
   type Internal_Inner_Env_Assoc_Iterator_Access is access all Internal_Internal_Inner_Env_Assoc_Iterator;


   

   

   type Internal_Internal_Inner_Env_Assoc_Array is
      array (Positive range <>) of Internal_Inner_Env_Assoc;

   type Internal_Inner_Env_Assoc_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Inner_Env_Assoc_Array (1 .. N);
   end record;

   Empty_Internal_Inner_Env_Assoc_Array_Record : aliased Internal_Inner_Env_Assoc_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Inner_Env_Assoc_Array_Type : constant Internal_Inner_Env_Assoc_Array_Access :=
      Empty_Internal_Inner_Env_Assoc_Array_Record'Access;


   function Create_Internal_Inner_Env_Assoc_Array (Items_Count : Natural) return Internal_Inner_Env_Assoc_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Inner_Env_Assoc_Array
     (Items : Internal_Internal_Inner_Env_Assoc_Array) return Internal_Inner_Env_Assoc_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Inner_Env_Assoc_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Inner_Env_Assoc;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Inner_Env_Assoc_Array_Access) return Internal_Inner_Env_Assoc_Array_Access;


   function Length (T : Internal_Inner_Env_Assoc_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Inner_Env_Assoc_Array_Access);
   procedure Dec_Ref (T : in out Internal_Inner_Env_Assoc_Array_Access);

   function Equivalent (L, R : Internal_Inner_Env_Assoc_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Inner_Env_Assoc_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Inner_Env_Assoc_Array_Record, Internal_Inner_Env_Assoc_Array_Access);

      

   

   type Internal_Internal_Inner_Env_Assoc_Iterator is record
      Ref_Count : Integer;
      --  Reference count. The iterator is freed when this drops to zero.
      --  Negative values are interpreted as "always living singleton".

      Safety_Net : Iterator_Safety_Net;
      --  Safety net for the iterator. Used to check that values produced by
      --  the iterator are still valid. Unlike for other types, we put the
      --  safety net in the internal type so that it can be used in all other
      --  APIs (Python, ...).
      --
      --  While other types (except nodes) are "deeply" converted to native
      --  APIs (for instance: internal arrays are turned into native Python
      --  lists, likewise for array items, etc.), iterators are lazy, so the
      --  deep conversion is not possible.

      Elements : Internal_Inner_Env_Assoc_Array_Access;
      Index    : Positive;
   end record;

   Empty_Internal_Internal_Inner_Env_Assoc_Iterator : aliased Internal_Internal_Inner_Env_Assoc_Iterator :=
     (Ref_Count  => -1,
      Safety_Net => No_Iterator_Safety_Net,
      Elements   => No_Internal_Inner_Env_Assoc_Array_Type,
      Index      => 1);
   No_Internal_Inner_Env_Assoc_Iterator_Type : constant Internal_Inner_Env_Assoc_Iterator_Access :=
      Empty_Internal_Internal_Inner_Env_Assoc_Iterator'Access;

   function Next
     (T       : Internal_Inner_Env_Assoc_Iterator_Access;
      Element : out Internal_Inner_Env_Assoc) return Boolean;

   procedure Inc_Ref (T : Internal_Inner_Env_Assoc_Iterator_Access);
   procedure Dec_Ref (T : in out Internal_Inner_Env_Assoc_Iterator_Access);

      function Trace_Image (A : Internal_Inner_Env_Assoc_Iterator_Access) return String;

   procedure Free is new Ada.Unchecked_Deallocation
     (Internal_Internal_Inner_Env_Assoc_Iterator, Internal_Inner_Env_Assoc_Iterator_Access);


   function Inner_Env_Assoc_Get
     (Self  : Internal_Inner_Env_Assoc_Array_Access;
      Index : Positive) return Internal_Inner_Env_Assoc
   is (Self.Items (Index));

   function Combine
     (L, R : Internal_Metadata) return Internal_Metadata;
   --  The combine function on environments metadata does a boolean Or on every
   --  boolean component of the env metadata.

   function Can_Reach (El, From : Bare_Ada_Node) return Boolean;
   --  Return whether El can reach From, from a sequential viewpoint. If
   --  elements are declared in different units, it will always return True,
   --  eg this does not handle general visibility issues, just sequentiality of
   --  declarations.

   function AST_Envs_Node_Text_Image
     (Node  : Bare_Ada_Node;
      Short : Boolean := True) return Text_Type;
   --  Return a "sourcefile:lineno:columnno" corresponding to the starting sloc
   --  of Node. Used to create a human-readable representation for env.
   --  rebindings.

   function Is_Rebindable (Node : Bare_Ada_Node) return Boolean;

   function Acquire_Rebinding
     (Node             : Bare_Ada_Node;
      Parent           : Env_Rebindings;
      Old_Env, New_Env : Lexical_Env) return Env_Rebindings;
   --  Initialize and return a fresh rebinding

   procedure Release_Rebinding (Self : in out Env_Rebindings);
   --  Mark the rebinding as unused, so that a future call to Acquire_Rebinding
   --  can return it.

   procedure Register_Rebinding
     (Node : Bare_Ada_Node; Rebinding : Env_Rebindings);
   --  Register a rebinding to be destroyed when Node's analysis unit is
   --  destroyed or reparsed.

   function Element_Parent
     (Node : Bare_Ada_Node) return Bare_Ada_Node;

   function Hash (Node : Bare_Ada_Node) return Hash_Type;
   function Node_Unit (Node : Bare_Ada_Node) return Generic_Unit_Ptr;
   function Named_Hash (Node : Bare_Ada_Node) return Hash_Type is
     (Hash (Node));

   No_Analysis_Unit : constant Internal_Unit := null;

   function Convert_Unit is new Ada.Unchecked_Conversion
     (Generic_Unit_Ptr, Internal_Unit);
   function Convert_Unit is new Ada.Unchecked_Conversion
     (Internal_Unit, Generic_Unit_Ptr);

   function Unit_Version (Unit : Generic_Unit_Ptr) return Version_Number;
   --  Return the version for Unit. Version is a number that is incremented
   --  every time Unit changes.

   function Get_Context_Version
     (Node : Bare_Ada_Node) return Version_Number;
   --  Assuming that Node is not null, return the version number for Node's
   --  context, which is incremented every time a unit in this context is
   --  parsed.

   type Ref_Category is
     (Inherited_Primitives, Nocat);
   type Ref_Categories is array (Ref_Category) of Boolean;
   pragma Pack (Ref_Categories);

   function Properties_May_Raise
     (Exc : Ada.Exceptions.Exception_Occurrence) return Boolean;
   --  Return if ``Exc`` is one of the exceptions that properties are allowed
   --  to raise.

   package AST_Envs is new Langkit_Support.Lexical_Envs_Impl
     (Get_Unit_Version         => Unit_Version,
      Node_Type                => Bare_Ada_Node,
      Node_Metadata            => Internal_Metadata,
      No_Node                  => null,
      Empty_Metadata           => No_Metadata,
      Node_Unit                => Node_Unit,
      Node_Hash                => Named_Hash,
      Metadata_Hash            => Hash,
      Combine                  => Combine,
      Node_Text_Image          => AST_Envs_Node_Text_Image,
      Acquire_Rebinding        => Acquire_Rebinding,
      Register_Rebinding       => Register_Rebinding,
      Ref_Category             => Ref_Category,
      Ref_Categories           => Ref_Categories,
      Inner_Env_Assoc          => Internal_Inner_Env_Assoc,
      Inner_Env_Assoc_Array    => Internal_Inner_Env_Assoc_Array_Access,
      Get                      => Inner_Env_Assoc_Get);

   use AST_Envs;
   subtype Internal_Entity is AST_Envs.Entity;
   subtype Internal_Entity_Info is AST_Envs.Entity_Info;

   No_Entity_Info : constant Internal_Entity_Info :=
     (No_Metadata, null, False);
   No_Entity : constant Internal_Entity :=
     (null, No_Entity_Info);

   function Hash_Entity (Self : Internal_Entity) return Hash_Type;
   --  Hash function to use in the public API. It's like the regular one, but
   --  disregards metadata.

   function Compare_Entity (Left, Right : Internal_Entity) return Boolean;
   --  Equality function to use in the public API. It's like the regular one,
   --  but disregards metadata.

   function Create_Dynamic_Lexical_Env
     (Self              : Bare_Ada_Node;
      Assocs_Getter     : Inner_Env_Assocs_Resolver;
      Assoc_Resolver    : Entity_Resolver;
      Transitive_Parent : Boolean) return Lexical_Env;
   --  Helper for properties code generation: wrapper around
   --  AST_Envs.Create_Dynamic_Lexical_Env.

      function Hash (B : Boolean) return Hash_Type;

      function Hash (I : Integer) return Hash_Type;




   --------------------------
   -- Big integers wrapper --
   --------------------------

   type Big_Integer_Record is limited record
      Value     : GNATCOLL.GMP.Integers.Big_Integer;
      Ref_Count : Integer;
      --  Number of owners. When it drops to 0, this record can be destroyed.
      --  If -1, this is a static big integer: Inc_Ref and Dec_Ref are no-ops.
   end record;

   type Big_Integer_Type is access all Big_Integer_Record;

   function Create_Big_Integer
     (Image : String; Base : Integer := 10) return Big_Integer_Type;
   function Create_Big_Integer
     (Big_Int : GNATCOLL.GMP.Integers.Big_Integer) return Big_Integer_Type;
   function Create_Big_Integer (Int : Integer) return Big_Integer_Type;
   function Create_Public_Big_Integer
     (Big_Int : Big_Integer_Type) return GNATCOLL.GMP.Integers.Big_Integer;

   No_Big_Integer_Record : aliased Big_Integer_Record :=
     (Value => <>, Ref_Count => -1);
   No_Big_Integer : constant Big_Integer_Type := No_Big_Integer_Record'Access;

   function To_Integer
     (Self    : Bare_Ada_Node;
      Big_Int : Big_Integer_Type) return Integer;
   --  Convert ``Big_Int`` into a regular integer, raising a ``Property_Error``
   --  if it is out of range (using ``Self`` to provide context for this
   --  error).

   procedure Inc_Ref (Big_Int : Big_Integer_Type);
   procedure Dec_Ref (Big_Int : in out Big_Integer_Type);

   function Equivalent (Left, Right : Big_Integer_Type) return Boolean;
   function "<" (Left, Right : Big_Integer_Type) return Boolean;
   function "<=" (Left, Right : Big_Integer_Type) return Boolean;
   function ">" (Left, Right : Big_Integer_Type) return Boolean;
   function ">=" (Left, Right : Big_Integer_Type) return Boolean;

   function "+" (Left, Right : Big_Integer_Type) return Big_Integer_Type;
   function "-" (Left, Right : Big_Integer_Type) return Big_Integer_Type;

   function Trace_Image (I : Big_Integer_Type) return String;

      function Trace_Image
        (Node       : Bare_Ada_Node;
         Decoration : Boolean := True) return String;

   function Is_Incomplete (Node : Bare_Ada_Node) return Boolean;
   --  Return whether this node is incomplete or not.  Incomplete nodes are a
   --  result of the parsing of a node failing as a result of a Cut parser
   --  annotation.

   function Kind_Name (Node : Bare_Ada_Node) return String;
   --  Return the concrete kind for Node

   ---------------------------
   -- Adalog instantiations --
   ---------------------------

   function Text_Image (Ent : Internal_Entity) return Text_Type;
   function Image (Ent : Internal_Entity) return String;
   --  Return a representation of this entity as a string.

   package Entity_Vars is new Langkit_Support.Adalog.Logic_Var
     (Value_Type => Internal_Entity, Value_Image => Image);
   package Solver_Ifc is new Langkit_Support.Adalog.Solver_Interface
     (Entity_Vars);
   package Solver is new Langkit_Support.Adalog.Solver (Solver_Ifc);

   subtype Logic_Var is Entity_Vars.Logic_Var;
   subtype Logic_Var_Record is Entity_Vars.Logic_Var_Record;
   Null_Var : constant Logic_Var := null;
   Null_Var_Record : constant Logic_Var_Record := (Reset => True, others => <>);

   subtype Logic_Equation is Solver.Relation;
   Null_Logic_Equation : constant Logic_Equation := Solver.No_Relation;

      function Trace_Image (K : Analysis_Unit_Kind) return String;
      function Trace_Image (B : Boolean) return String;
      function Trace_Image (I : Integer) return String;
      function Trace_Image (S : Symbol_Type) return String;
      function Trace_Image (C : Character_Type) return String;
      function Trace_Image (S : String_Type) return String;
      function Trace_Image (Env : Lexical_Env) return String;
      function Trace_Image (R : Env_Rebindings) return String;
      function Trace_Image (Unit : Internal_Unit) return String;
      function Trace_Image (Eq : Logic_Equation) return String;
      function Trace_Image (Var : Logic_Var) return String;
      function Trace_Image (T : Token_Reference) return String renames Image;
      function Trace_Image (Self : Ref_Categories) return String;

   
      type Resolution_Val is record
    Cache_Version : Version_Number;
    Rebindings    : Env_Rebindings;
    Return_Value  : Boolean;
    Raised_Exc    : Boolean;
end record;

package Nameres_Maps is new Ada.Containers.Hashed_Maps
  (Key_Type        => Bare_Ada_Node,
   Element_Type    => Resolution_Val,
   Hash            => Hash,
   Equivalent_Keys => "=",
   "="             => "=");



   -----------------------------------------------
   -- Structure types (incomplete declarations) --
   -----------------------------------------------

         

         

         
      type Internal_Entity_Expr;
      

         
      type Internal_Aspect;
      --  Composite field representing the aspect of an entity (:rmlink:`13`).

         
      type Internal_Entity_Basic_Decl;
      

         
      type Internal_Completion_Item;
      

         
      type Internal_Designated_Env;
      --  Designate an environment for an env spec action.
   --
   --  The designated environment can be either, depending on the ``Kind``
   --  field:
   --
   --  * If ``Kind`` is ``None``, no environment is designated.
   --
   --  * If ``Kind`` is ``Current_Env``, designate the current environment at
   --    this point during PLE.
   --
   --  * If ``Kind`` is ``Named_Env``, designate the environment which has
   --    precedence for the ``Env_Name`` environment name. If ``Env_Name`` is
   --    null, this designates to environment.
   --
   --  * If ``Kind`` is ``Direct_Env``, the direct value for the designated
   --    environment. That environment must be a primary one and cannot be
   --    foreign to the node currently processed by PLE. If it is the empty
   --    environment, do nothing.

         
      type Internal_Discrete_Range;
      --  Represent the range of a discrete type or subtype. The bounds are not
   --  evaluated, you need to call ``eval_as_int`` on them, if they're static,
   --  to get their value.

         
      type Internal_Entity_Ada_List;
      

         
      type Internal_Entity_Ada_Node_List;
      

         
      type Internal_Entity_Alternatives_List;
      

         
      type Internal_Entity_Name;
      

         
      type Internal_Entity_Single_Tok_Node;
      

         
      type Internal_Entity_Base_Id;
      

         
      type Internal_Entity_Identifier;
      

         
      type Internal_Discriminant_Values;
      --  Represent a set of values (as a list of choices) on a discriminant.

         
      type Internal_Doc_Annotation;
      --  Documentation annotation.

         
      type Internal_Entity_Abort_Node;
      

         
      type Internal_Entity_Abort_Absent;
      

         
      type Internal_Entity_Abort_Present;
      

         
      type Internal_Entity_Stmt;
      

         
      type Internal_Entity_Simple_Stmt;
      

         
      type Internal_Entity_Abort_Stmt;
      

         
      type Internal_Entity_Abstract_Node;
      

         
      type Internal_Entity_Abstract_Absent;
      

         
      type Internal_Entity_Basic_Subp_Decl;
      

         
      type Internal_Entity_Classic_Subp_Decl;
      

         
      type Internal_Entity_Formal_Subp_Decl;
      

         
      type Internal_Entity_Abstract_Formal_Subp_Decl;
      

         
      type Internal_Entity_Abstract_Present;
      

         
      type Internal_Entity_Abstract_State_Decl;
      

         
      type Internal_Entity_Abstract_State_Decl_Expr;
      

         
      type Internal_Entity_Abstract_State_Decl_List;
      

         
      type Internal_Entity_Abstract_Subp_Decl;
      

         
      type Internal_Entity_Composite_Stmt;
      

         
      type Internal_Entity_Accept_Stmt;
      

         
      type Internal_Entity_Accept_Stmt_With_Stmts;
      

         
      type Internal_Entity_Type_Def;
      

         
      type Internal_Entity_Access_Def;
      

         
      type Internal_Entity_Access_To_Subp_Def;
      

         
      type Internal_Entity_Base_Aggregate;
      

         
      type Internal_Entity_Aggregate;
      

         
      type Internal_Entity_Basic_Assoc;
      

         
      type Internal_Entity_Aggregate_Assoc;
      

         
      type Internal_Entity_Aliased_Node;
      

         
      type Internal_Entity_Aliased_Absent;
      

         
      type Internal_Entity_Aliased_Present;
      

         
      type Internal_Entity_All_Node;
      

         
      type Internal_Entity_All_Absent;
      

         
      type Internal_Entity_All_Present;
      

         
      type Internal_Entity_Allocator;
      

         
      type Internal_Entity_Anonymous_Expr_Decl;
      

         
      type Internal_Entity_Type_Expr;
      

         
      type Internal_Entity_Anonymous_Type;
      

         
      type Internal_Entity_Base_Type_Access_Def;
      

         
      type Internal_Entity_Anonymous_Type_Access_Def;
      

         
      type Internal_Entity_Base_Type_Decl;
      

         
      type Internal_Entity_Type_Decl;
      

         
      type Internal_Entity_Anonymous_Type_Decl;
      

         
      type Internal_Entity_Array_Indices;
      

         
      type Internal_Entity_Array_Type_Def;
      

         
      type Internal_Entity_Aspect_Assoc;
      

         
      type Internal_Entity_Aspect_Assoc_List;
      

         
      type Internal_Entity_Aspect_Clause;
      

         
      type Internal_Entity_Aspect_Spec;
      

         
      type Internal_Entity_Assign_Stmt;
      

         
      type Internal_Entity_Basic_Assoc_List;
      

         
      type Internal_Entity_Assoc_List;
      

         
      type Internal_Entity_At_Clause;
      

         
      type Internal_Entity_Attribute_Def_Clause;
      

         
      type Internal_Entity_Attribute_Ref;
      

         
      type Internal_Entity_Base_Assoc;
      

         
      type Internal_Entity_Base_Assoc_List;
      

         
      type Internal_Entity_Base_Formal_Param_Decl;
      

         
      type Internal_Entity_Base_Formal_Param_Holder;
      

         
      type Internal_Entity_Base_Loop_Stmt;
      

         
      type Internal_Entity_Base_Package_Decl;
      

         
      type Internal_Entity_Base_Record_Def;
      

         
      type Internal_Entity_Body_Node;
      

         
      type Internal_Entity_Base_Subp_Body;
      

         
      type Internal_Entity_Base_Subp_Spec;
      

         
      type Internal_Entity_Base_Subtype_Decl;
      

         
      type Internal_Entity_Basic_Decl_List;
      

         
      type Internal_Entity_Block_Stmt;
      

         
      type Internal_Entity_Begin_Block;
      

         
      type Internal_Entity_Bin_Op;
      

         
      type Internal_Entity_Body_Stub;
      

         
      type Internal_Entity_Box_Expr;
      

         
      type Internal_Entity_Bracket_Aggregate;
      

         
      type Internal_Entity_Delta_Aggregate;
      

         
      type Internal_Entity_Bracket_Delta_Aggregate;
      

         
      type Internal_Entity_Call_Expr;
      

         
      type Internal_Entity_Call_Stmt;
      

         
      type Internal_Entity_Cond_Expr;
      

         
      type Internal_Entity_Case_Expr;
      

         
      type Internal_Entity_Case_Expr_Alternative;
      

         
      type Internal_Entity_Case_Expr_Alternative_List;
      

         
      type Internal_Entity_Case_Stmt;
      

         
      type Internal_Entity_Case_Stmt_Alternative;
      

         
      type Internal_Entity_Case_Stmt_Alternative_List;
      

         
      type Internal_Entity_Char_Literal;
      

         
      type Internal_Entity_Classwide_Type_Decl;
      

         
      type Internal_Entity_Compilation_Unit;
      

         
      type Internal_Entity_Compilation_Unit_List;
      

         
      type Internal_Entity_Component_Clause;
      

         
      type Internal_Entity_Component_Decl;
      

         
      type Internal_Entity_Component_Def;
      

         
      type Internal_Entity_Component_List;
      

         
      type Internal_Entity_Constraint;
      

         
      type Internal_Entity_Composite_Constraint;
      

         
      type Internal_Entity_Composite_Constraint_Assoc;
      

         
      type Internal_Entity_Concat_Op;
      

         
      type Internal_Entity_Concat_Operand;
      

         
      type Internal_Entity_Concat_Operand_List;
      

         
      type Internal_Entity_Concrete_Formal_Subp_Decl;
      

         
      type Internal_Entity_Concrete_Type_Decl;
      

         
      type Internal_Entity_Constant_Node;
      

         
      type Internal_Entity_Constant_Absent;
      

         
      type Internal_Entity_Constant_Present;
      

         
      type Internal_Entity_Constrained_Array_Indices;
      

         
      type Internal_Entity_Subtype_Indication;
      

         
      type Internal_Entity_Constrained_Subtype_Indication;
      

         
      type Internal_Entity_Constraint_List;
      

         
      type Internal_Entity_Contract_Case_Assoc;
      

         
      type Internal_Entity_Contract_Case_Assoc_List;
      

         
      type Internal_Entity_Contract_Cases;
      

         
      type Internal_Entity_Real_Type_Def;
      

         
      type Internal_Entity_Decimal_Fixed_Point_Def;
      

         
      type Internal_Entity_Decl_Block;
      

         
      type Internal_Entity_Decl_Expr;
      

         
      type Internal_Entity_Decl_List;
      

         
      type Internal_Entity_Declarative_Part;
      

         
      type Internal_Entity_Defining_Name;
      

         
      type Internal_Entity_Defining_Name_List;
      

         
      type Internal_Entity_Delay_Stmt;
      

         
      type Internal_Entity_Delta_Constraint;
      

         
      type Internal_Entity_Derived_Type_Def;
      

         
      type Internal_Entity_Digits_Constraint;
      

         
      type Internal_Entity_Discrete_Base_Subtype_Decl;
      

         
      type Internal_Entity_Discrete_Subtype_Indication;
      

         
      type Internal_Entity_Discrete_Subtype_Name;
      

         
      type Internal_Entity_Identifier_List;
      

         
      type Internal_Entity_Discriminant_Choice_List;
      

         
      type Internal_Entity_Discriminant_Part;
      

         
      type Internal_Entity_Discriminant_Spec;
      

         
      type Internal_Entity_Discriminant_Spec_List;
      

         
      type Internal_Entity_Dotted_Name;
      

         
      type Internal_Entity_Elsif_Expr_Part;
      

         
      type Internal_Entity_Elsif_Expr_Part_List;
      

         
      type Internal_Entity_Elsif_Stmt_Part;
      

         
      type Internal_Entity_Elsif_Stmt_Part_List;
      

         
      type Internal_Entity_End_Name;
      

         
      type Internal_Entity_Entry_Body;
      

         
      type Internal_Entity_Entry_Completion_Formal_Params;
      

         
      type Internal_Entity_Entry_Decl;
      

         
      type Internal_Entity_Entry_Index_Spec;
      

         
      type Internal_Entity_Entry_Spec;
      

         
      type Internal_Entity_Enum_Lit_Synth_Type_Expr;
      

         
      type Internal_Entity_Enum_Literal_Decl;
      

         
      type Internal_Entity_Enum_Literal_Decl_List;
      

         
      type Internal_Entity_Enum_Rep_Clause;
      

         
      type Internal_Entity_Enum_Subp_Spec;
      

         
      type Internal_Entity_Enum_Type_Def;
      

         
      type Internal_Entity_Error_Decl;
      

         
      type Internal_Entity_Error_Stmt;
      

         
      type Internal_Entity_Exception_Decl;
      

         
      type Internal_Entity_Exception_Handler;
      

         
      type Internal_Entity_Exit_Stmt;
      

         
      type Internal_Entity_Explicit_Deref;
      

         
      type Internal_Entity_Expr_List;
      

         
      type Internal_Entity_Expr_Alternatives_List;
      

         
      type Internal_Entity_Expr_Function;
      

         
      type Internal_Entity_Extended_Return_Stmt;
      

         
      type Internal_Entity_Object_Decl;
      

         
      type Internal_Entity_Extended_Return_Stmt_Object_Decl;
      

         
      type Internal_Entity_Floating_Point_Def;
      

         
      type Internal_Entity_Loop_Spec;
      

         
      type Internal_Entity_For_Loop_Spec;
      

         
      type Internal_Entity_For_Loop_Stmt;
      

         
      type Internal_Entity_For_Loop_Var_Decl;
      

         
      type Internal_Entity_Formal_Discrete_Type_Def;
      

         
      type Internal_Entity_Formal_Type_Decl;
      

         
      type Internal_Entity_Generic_Decl;
      

         
      type Internal_Entity_Generic_Formal;
      

         
      type Internal_Entity_Generic_Formal_Obj_Decl;
      

         
      type Internal_Entity_Generic_Formal_Package;
      

         
      type Internal_Entity_Generic_Formal_Part;
      

         
      type Internal_Entity_Generic_Formal_Subp_Decl;
      

         
      type Internal_Entity_Generic_Formal_Type_Decl;
      

         
      type Internal_Entity_Generic_Instantiation;
      

         
      type Internal_Entity_Generic_Package_Decl;
      

         
      type Internal_Entity_Generic_Package_Instantiation;
      

         
      type Internal_Entity_Generic_Package_Internal;
      

         
      type Internal_Entity_Generic_Renaming_Decl;
      

         
      type Internal_Entity_Generic_Package_Renaming_Decl;
      

         
      type Internal_Entity_Generic_Subp_Decl;
      

         
      type Internal_Entity_Generic_Subp_Instantiation;
      

         
      type Internal_Entity_Generic_Subp_Internal;
      

         
      type Internal_Entity_Generic_Subp_Renaming_Decl;
      

         
      type Internal_Entity_Goto_Stmt;
      

         
      type Internal_Entity_Handled_Stmts;
      

         
      type Internal_Entity_If_Expr;
      

         
      type Internal_Entity_If_Stmt;
      

         
      type Internal_Entity_Incomplete_Type_Decl;
      

         
      type Internal_Entity_Incomplete_Formal_Type_Decl;
      

         
      type Internal_Entity_Incomplete_Tagged_Type_Decl;
      

         
      type Internal_Entity_Num_Literal;
      

         
      type Internal_Entity_Int_Literal;
      

         
      type Internal_Entity_Interface_Kind;
      

         
      type Internal_Entity_Interface_Kind_Limited;
      

         
      type Internal_Entity_Interface_Kind_Protected;
      

         
      type Internal_Entity_Interface_Kind_Synchronized;
      

         
      type Internal_Entity_Interface_Kind_Task;
      

         
      type Internal_Entity_Interface_Type_Def;
      

         
      type Internal_Entity_Iter_Type;
      

         
      type Internal_Entity_Iter_Type_In;
      

         
      type Internal_Entity_Iter_Type_Of;
      

         
      type Internal_Entity_Iterated_Assoc;
      

         
      type Internal_Entity_Known_Discriminant_Part;
      

         
      type Internal_Entity_Label;
      

         
      type Internal_Entity_Label_Decl;
      

         
      type Internal_Entity_Library_Item;
      

         
      type Internal_Entity_Limited_Node;
      

         
      type Internal_Entity_Limited_Absent;
      

         
      type Internal_Entity_Limited_Present;
      

         
      type Internal_Entity_Loop_Stmt;
      

         
      type Internal_Entity_Membership_Expr;
      

         
      type Internal_Entity_Mod_Int_Type_Def;
      

         
      type Internal_Entity_Mode;
      

         
      type Internal_Entity_Mode_Default;
      

         
      type Internal_Entity_Mode_In;
      

         
      type Internal_Entity_Mode_In_Out;
      

         
      type Internal_Entity_Mode_Out;
      

         
      type Internal_Entity_Multi_Abstract_State_Decl;
      

         
      type Internal_Entity_Multi_Dim_Array_Assoc;
      

         
      type Internal_Entity_Name_List;
      

         
      type Internal_Entity_Named_Stmt;
      

         
      type Internal_Entity_Named_Stmt_Decl;
      

         
      type Internal_Entity_No_Type_Object_Renaming_Decl;
      

         
      type Internal_Entity_Not_Null;
      

         
      type Internal_Entity_Not_Null_Absent;
      

         
      type Internal_Entity_Not_Null_Present;
      

         
      type Internal_Entity_Null_Component_Decl;
      

         
      type Internal_Entity_Null_Literal;
      

         
      type Internal_Entity_Null_Record_Aggregate;
      

         
      type Internal_Entity_Null_Record_Def;
      

         
      type Internal_Entity_Null_Stmt;
      

         
      type Internal_Entity_Null_Subp_Decl;
      

         
      type Internal_Entity_Number_Decl;
      

         
      type Internal_Entity_Op;
      

         
      type Internal_Entity_Op_Abs;
      

         
      type Internal_Entity_Op_And;
      

         
      type Internal_Entity_Op_And_Then;
      

         
      type Internal_Entity_Op_Concat;
      

         
      type Internal_Entity_Op_Div;
      

         
      type Internal_Entity_Op_Double_Dot;
      

         
      type Internal_Entity_Op_Eq;
      

         
      type Internal_Entity_Op_Gt;
      

         
      type Internal_Entity_Op_Gte;
      

         
      type Internal_Entity_Op_In;
      

         
      type Internal_Entity_Op_Lt;
      

         
      type Internal_Entity_Op_Lte;
      

         
      type Internal_Entity_Op_Minus;
      

         
      type Internal_Entity_Op_Mod;
      

         
      type Internal_Entity_Op_Mult;
      

         
      type Internal_Entity_Op_Neq;
      

         
      type Internal_Entity_Op_Not;
      

         
      type Internal_Entity_Op_Not_In;
      

         
      type Internal_Entity_Op_Or;
      

         
      type Internal_Entity_Op_Or_Else;
      

         
      type Internal_Entity_Op_Plus;
      

         
      type Internal_Entity_Op_Pow;
      

         
      type Internal_Entity_Op_Rem;
      

         
      type Internal_Entity_Op_Xor;
      

         
      type Internal_Entity_Ordinary_Fixed_Point_Def;
      

         
      type Internal_Entity_Others_Designator;
      

         
      type Internal_Entity_Overriding_Node;
      

         
      type Internal_Entity_Overriding_Not_Overriding;
      

         
      type Internal_Entity_Overriding_Overriding;
      

         
      type Internal_Entity_Overriding_Unspecified;
      

         
      type Internal_Entity_Package_Body;
      

         
      type Internal_Entity_Package_Body_Stub;
      

         
      type Internal_Entity_Package_Decl;
      

         
      type Internal_Entity_Package_Renaming_Decl;
      

         
      type Internal_Entity_Param_Assoc;
      

         
      type Internal_Entity_Param_Spec;
      

         
      type Internal_Entity_Param_Spec_List;
      

         
      type Internal_Entity_Params;
      

         
      type Internal_Entity_Paren_Abstract_State_Decl;
      

         
      type Internal_Entity_Paren_Expr;
      

         
      type Internal_Entity_Parent_List;
      

         
      type Internal_Entity_Pp_Directive;
      

         
      type Internal_Entity_Pp_Else_Directive;
      

         
      type Internal_Entity_Pp_Elsif_Directive;
      

         
      type Internal_Entity_Pp_End_If_Directive;
      

         
      type Internal_Entity_Pp_If_Directive;
      

         
      type Internal_Entity_Pp_Then_Kw;
      

         
      type Internal_Entity_Pragma_Argument_Assoc;
      

         
      type Internal_Entity_Pragma_Node;
      

         
      type Internal_Entity_Pragma_Node_List;
      

         
      type Internal_Entity_Private_Node;
      

         
      type Internal_Entity_Private_Absent;
      

         
      type Internal_Entity_Private_Part;
      

         
      type Internal_Entity_Private_Present;
      

         
      type Internal_Entity_Private_Type_Def;
      

         
      type Internal_Entity_Protected_Node;
      

         
      type Internal_Entity_Protected_Absent;
      

         
      type Internal_Entity_Protected_Body;
      

         
      type Internal_Entity_Protected_Body_Stub;
      

         
      type Internal_Entity_Protected_Def;
      

         
      type Internal_Entity_Protected_Present;
      

         
      type Internal_Entity_Protected_Type_Decl;
      

         
      type Internal_Entity_Public_Part;
      

         
      type Internal_Entity_Qual_Expr;
      

         
      type Internal_Entity_Quantified_Expr;
      

         
      type Internal_Entity_Quantifier;
      

         
      type Internal_Entity_Quantifier_All;
      

         
      type Internal_Entity_Quantifier_Some;
      

         
      type Internal_Entity_Raise_Expr;
      

         
      type Internal_Entity_Raise_Stmt;
      

         
      type Internal_Entity_Range_Constraint;
      

         
      type Internal_Entity_Range_Spec;
      

         
      type Internal_Entity_Real_Literal;
      

         
      type Internal_Entity_Record_Def;
      

         
      type Internal_Entity_Record_Rep_Clause;
      

         
      type Internal_Entity_Record_Type_Def;
      

         
      type Internal_Entity_Reduce_Attribute_Ref;
      

         
      type Internal_Entity_Relation_Op;
      

         
      type Internal_Entity_Renaming_Clause;
      

         
      type Internal_Entity_Requeue_Stmt;
      

         
      type Internal_Entity_Return_Stmt;
      

         
      type Internal_Entity_Reverse_Node;
      

         
      type Internal_Entity_Reverse_Absent;
      

         
      type Internal_Entity_Reverse_Present;
      

         
      type Internal_Entity_Select_Stmt;
      

         
      type Internal_Entity_Select_When_Part;
      

         
      type Internal_Entity_Select_When_Part_List;
      

         
      type Internal_Entity_Signed_Int_Type_Def;
      

         
      type Internal_Entity_Single_Protected_Decl;
      

         
      type Internal_Entity_Single_Task_Decl;
      

         
      type Internal_Entity_Task_Type_Decl;
      

         
      type Internal_Entity_Single_Task_Type_Decl;
      

         
      type Internal_Entity_Stmt_List;
      

         
      type Internal_Entity_String_Literal;
      

         
      type Internal_Entity_Subp_Body;
      

         
      type Internal_Entity_Subp_Body_Stub;
      

         
      type Internal_Entity_Subp_Decl;
      

         
      type Internal_Entity_Subp_Kind;
      

         
      type Internal_Entity_Subp_Kind_Function;
      

         
      type Internal_Entity_Subp_Kind_Procedure;
      

         
      type Internal_Entity_Subp_Renaming_Decl;
      

         
      type Internal_Entity_Subp_Spec;
      

         
      type Internal_Entity_Subtype_Decl;
      

         
      type Internal_Entity_Subunit;
      

         
      type Internal_Entity_Synchronized_Node;
      

         
      type Internal_Entity_Synchronized_Absent;
      

         
      type Internal_Entity_Synchronized_Present;
      

         
      type Internal_Entity_Synth_Anonymous_Type_Decl;
      

         
      type Internal_Entity_Synthetic_Binary_Spec;
      

         
      type Internal_Entity_Synthetic_Char_Enum_Lit;
      

         
      type Internal_Entity_Synthetic_Defining_Name;
      

         
      type Internal_Entity_Synthetic_Formal_Param_Decl;
      

         
      type Internal_Entity_Synthetic_Identifier;
      

         
      type Internal_Entity_Synthetic_Renaming_Clause;
      

         
      type Internal_Entity_Synthetic_Subp_Decl;
      

         
      type Internal_Entity_Synthetic_Type_Expr;
      

         
      type Internal_Entity_Synthetic_Unary_Spec;
      

         
      type Internal_Entity_Tagged_Node;
      

         
      type Internal_Entity_Tagged_Absent;
      

         
      type Internal_Entity_Tagged_Present;
      

         
      type Internal_Entity_Target_Name;
      

         
      type Internal_Entity_Task_Body;
      

         
      type Internal_Entity_Task_Body_Stub;
      

         
      type Internal_Entity_Task_Def;
      

         
      type Internal_Entity_Terminate_Alternative;
      

         
      type Internal_Entity_Type_Access_Def;
      

         
      type Internal_Entity_Type_Attributes_Repository;
      

         
      type Internal_Entity_Un_Op;
      

         
      type Internal_Entity_Unconstrained_Array_Index;
      

         
      type Internal_Entity_Unconstrained_Array_Index_List;
      

         
      type Internal_Entity_Unconstrained_Array_Indices;
      

         
      type Internal_Entity_Unknown_Discriminant_Part;
      

         
      type Internal_Entity_Until_Node;
      

         
      type Internal_Entity_Until_Absent;
      

         
      type Internal_Entity_Until_Present;
      

         
      type Internal_Entity_Update_Attribute_Ref;
      

         
      type Internal_Entity_Use_Clause;
      

         
      type Internal_Entity_Use_Package_Clause;
      

         
      type Internal_Entity_Use_Type_Clause;
      

         
      type Internal_Entity_Value_Sequence;
      

         
      type Internal_Entity_Variant;
      

         
      type Internal_Entity_Variant_List;
      

         
      type Internal_Entity_Variant_Part;
      

         
      type Internal_Entity_While_Loop_Spec;
      

         
      type Internal_Entity_While_Loop_Stmt;
      

         
      type Internal_Entity_With_Clause;
      

         
      type Internal_Entity_With_Private;
      

         
      type Internal_Entity_With_Private_Absent;
      

         
      type Internal_Entity_With_Private_Present;
      

         
      type Internal_Env_Assoc;
      

         
      type Internal_Eval_Discrete_Range;
      --  Represent the range of a discrete type or subtype. The bounds are
   --  already evaluated, so the type of the fields is BigInt.

         
      type Internal_Expected_Type_For_Expr;
      --  Struct used by ``potential_actuals_for_dispatch`` to store an expression
   --  together with the type that is expected for it.

         
      type Internal_Logic_Val_Result;
      --  Represent the result of a call to logic_val. ``success`` is True iff
   --  solving the logic equation was successful, and ``value`` holds the value
   --  of the logic variable.

         
      type Internal_Multidim_Aggregate_Info;
      --  Struct enclosing information about aggregates for multidimensional array
   --  types.

         
      type Internal_Param_Actual;
      --  Data structure used by zip_with_params, Name.call_params,
   --  GenericInstantiation.inst_params, BaseAggregate.aggregate_params,
   --  SubtypeIndication.subtype_constraints, and EnumRepClause.params
   --  properties. Associates an expression (the actual) to a formal param
   --  declaration (the parameter).

         
      type Internal_Single_Actual;
      

         
      type Internal_Param_Match;
      --  Helper data structure to implement SubpSpec/ParamAssocList matching.
   --
   --  Each value relates to one ParamAssoc.

         
      type Internal_Ref_Result;
      --  Result for a cross reference query returning a reference.

         
      type Internal_Refd_Decl;
      --  Result for a cross reference query returning a referenced decl.

         
      type Internal_Refd_Def;
      --  Result for a cross reference query returning a referenced defining name.

         
      type Internal_Shape;
      --  Represent one of the shapes that a variant record can have, as a list of
   --  the available components.

         
      type Internal_Substitution;
      --  Represent a substitution of a BasicDecl by a given value. This can then
   --  be used as part of an environment in the eval_as_*_in_env property. See
   --  the declaration of those properties for more details.


   -------------------------------------------
   -- Array types (incomplete declarations) --
   -------------------------------------------

         
   type Bare_Ada_Node_Array_Record;
   type Bare_Ada_Node_Array_Access is access all Bare_Ada_Node_Array_Record;

         
   type Bare_Anonymous_Expr_Decl_Array_Record;
   type Bare_Anonymous_Expr_Decl_Array_Access is access all Bare_Anonymous_Expr_Decl_Array_Record;

         
   type Bare_Compilation_Unit_Array_Record;
   type Bare_Compilation_Unit_Array_Access is access all Bare_Compilation_Unit_Array_Record;

         
   type Bare_Expr_Array_Record;
   type Bare_Expr_Array_Access is access all Bare_Expr_Array_Record;

         
   type Bare_Name_Array_Record;
   type Bare_Name_Array_Access is access all Bare_Name_Array_Record;

         
   type Bare_Pragma_Node_Array_Record;
   type Bare_Pragma_Node_Array_Access is access all Bare_Pragma_Node_Array_Record;

         
   type Bare_Single_Tok_Node_Array_Record;
   type Bare_Single_Tok_Node_Array_Access is access all Bare_Single_Tok_Node_Array_Record;

         
   type Bare_Use_Clause_Array_Record;
   type Bare_Use_Clause_Array_Access is access all Bare_Use_Clause_Array_Record;

         
   type Internal_Aspect_Array_Record;
   type Internal_Aspect_Array_Access is access all Internal_Aspect_Array_Record;

         
   type Internal_Completion_Item_Array_Record;
   type Internal_Completion_Item_Array_Access is access all Internal_Completion_Item_Array_Record;

         
   type Internal_Discriminant_Values_Array_Record;
   type Internal_Discriminant_Values_Array_Access is access all Internal_Discriminant_Values_Array_Record;

         
   type Internal_Doc_Annotation_Array_Record;
   type Internal_Doc_Annotation_Array_Access is access all Internal_Doc_Annotation_Array_Record;

         
   type Internal_Entity_Accept_Stmt_Array_Record;
   type Internal_Entity_Accept_Stmt_Array_Access is access all Internal_Entity_Accept_Stmt_Array_Record;

         
   type Internal_Entity_Array_Record;
   type Internal_Entity_Array_Access is access all Internal_Entity_Array_Record;

         
   type Internal_Entity_Base_Assoc_Array_Record;
   type Internal_Entity_Base_Assoc_Array_Access is access all Internal_Entity_Base_Assoc_Array_Record;

         
   type Internal_Entity_Base_Formal_Param_Decl_Array_Record;
   type Internal_Entity_Base_Formal_Param_Decl_Array_Access is access all Internal_Entity_Base_Formal_Param_Decl_Array_Record;

         
   type Internal_Entity_Base_Type_Decl_Array_Record;
   type Internal_Entity_Base_Type_Decl_Array_Access is access all Internal_Entity_Base_Type_Decl_Array_Record;

         
   type Internal_Entity_Basic_Assoc_Array_Record;
   type Internal_Entity_Basic_Assoc_Array_Access is access all Internal_Entity_Basic_Assoc_Array_Record;

         
   type Internal_Entity_Basic_Decl_Array_Record;
   type Internal_Entity_Basic_Decl_Array_Access is access all Internal_Entity_Basic_Decl_Array_Record;

         
   type Internal_Entity_Compilation_Unit_Array_Record;
   type Internal_Entity_Compilation_Unit_Array_Access is access all Internal_Entity_Compilation_Unit_Array_Record;

         
   type Internal_Entity_Declarative_Part_Array_Record;
   type Internal_Entity_Declarative_Part_Array_Access is access all Internal_Entity_Declarative_Part_Array_Record;

         
   type Internal_Entity_Defining_Name_Array_Record;
   type Internal_Entity_Defining_Name_Array_Access is access all Internal_Entity_Defining_Name_Array_Record;

         
   type Internal_Entity_Expr_Array_Record;
   type Internal_Entity_Expr_Array_Access is access all Internal_Entity_Expr_Array_Record;

         
   type Internal_Entity_Generic_Instantiation_Array_Record;
   type Internal_Entity_Generic_Instantiation_Array_Access is access all Internal_Entity_Generic_Instantiation_Array_Record;

         
   type Internal_Entity_Identifier_Array_Record;
   type Internal_Entity_Identifier_Array_Access is access all Internal_Entity_Identifier_Array_Record;

         
   type Internal_Entity_Mode_Array_Record;
   type Internal_Entity_Mode_Array_Access is access all Internal_Entity_Mode_Array_Record;

         
   type Internal_Entity_Name_Array_Record;
   type Internal_Entity_Name_Array_Access is access all Internal_Entity_Name_Array_Record;

         
   type Internal_Entity_Param_Spec_Array_Record;
   type Internal_Entity_Param_Spec_Array_Access is access all Internal_Entity_Param_Spec_Array_Record;

         
   type Internal_Entity_Pragma_Node_Array_Record;
   type Internal_Entity_Pragma_Node_Array_Access is access all Internal_Entity_Pragma_Node_Array_Record;

         
   type Internal_Entity_Type_Decl_Array_Record;
   type Internal_Entity_Type_Decl_Array_Access is access all Internal_Entity_Type_Decl_Array_Record;

         
   type Internal_Entity_Type_Expr_Array_Record;
   type Internal_Entity_Type_Expr_Array_Access is access all Internal_Entity_Type_Expr_Array_Record;

         
   type Internal_Env_Assoc_Array_Record;
   type Internal_Env_Assoc_Array_Access is access all Internal_Env_Assoc_Array_Record;

         
   type Internal_Expected_Type_For_Expr_Array_Record;
   type Internal_Expected_Type_For_Expr_Array_Access is access all Internal_Expected_Type_For_Expr_Array_Record;

         
   type Internal_Param_Actual_Array_Record;
   type Internal_Param_Actual_Array_Access is access all Internal_Param_Actual_Array_Record;

         
   type Internal_Param_Match_Array_Record;
   type Internal_Param_Match_Array_Access is access all Internal_Param_Match_Array_Record;

         
   type Internal_Ref_Result_Array_Record;
   type Internal_Ref_Result_Array_Access is access all Internal_Ref_Result_Array_Record;

         
   type Internal_Shape_Array_Record;
   type Internal_Shape_Array_Access is access all Internal_Shape_Array_Record;

         
   type Internal_Single_Actual_Array_Record;
   type Internal_Single_Actual_Array_Access is access all Internal_Single_Actual_Array_Record;

         
   type Internal_Substitution_Array_Record;
   type Internal_Substitution_Array_Access is access all Internal_Substitution_Array_Record;

         
   type Internal_Unit_Array_Record;
   type Internal_Unit_Array_Access is access all Internal_Unit_Array_Record;

         
   type Lexical_Env_Array_Record;
   type Lexical_Env_Array_Access is access all Lexical_Env_Array_Record;

         
   type Logic_Equation_Array_Record;
   type Logic_Equation_Array_Access is access all Logic_Equation_Array_Record;

         
   type String_Type_Array_Record;
   type String_Type_Array_Access is access all String_Type_Array_Record;

         
   type Symbol_Type_Array_Record;
   type Symbol_Type_Array_Access is access all Symbol_Type_Array_Record;


   ----------------------------------------------
   -- Iterator types (incomplete declarations) --
   ----------------------------------------------

         
   type Internal_Bare_Ada_Node_Iterator;
   type Bare_Ada_Node_Iterator_Access is access all Internal_Bare_Ada_Node_Iterator;

         
   type Internal_Internal_Completion_Item_Iterator;
   type Internal_Completion_Item_Iterator_Access is access all Internal_Internal_Completion_Item_Iterator;

         
   type Internal_Internal_Entity_Iterator;
   type Internal_Entity_Iterator_Access is access all Internal_Internal_Entity_Iterator;


   -----------------------------------------
   -- Structure types (full declarations) --
   -----------------------------------------

         





   
      function Hash (R : Internal_Entity_Info) return Hash_Type;


      function Trace_Image (R : Internal_Entity_Info) return String;


         



      function Create_Internal_Entity
        (Node : Bare_Ada_Node; Info : Internal_Entity_Info)
         return Internal_Entity;


   
      function Hash (R : Internal_Entity) return Hash_Type;


      function Trace_Image (R : Internal_Entity) return String;


         

      

      type Internal_Entity_Expr is record

               Node : aliased Bare_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Expr : constant Internal_Entity_Expr;


      function Create_Internal_Entity_Expr
        (Node : Bare_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Expr;


   


      function Trace_Image (R : Internal_Entity_Expr) return String;


         

      

      type Internal_Aspect is record

               Exists : aliased Boolean;
               --  Whether the aspect is defined or not
               
               Node : aliased Internal_Entity;
               --  Syntactic node that defines the aspect
               
               Value : aliased Internal_Entity_Expr;
               --  Expr node defining the value of the aspect
               
      end record
        with Convention => C;
      No_Aspect : constant Internal_Aspect;




   


      function Trace_Image (R : Internal_Aspect) return String;


         

      

      type Internal_Entity_Basic_Decl is record

               Node : aliased Bare_Basic_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Basic_Decl : constant Internal_Entity_Basic_Decl;


      function Create_Internal_Entity_Basic_Decl
        (Node : Bare_Basic_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Decl;


   
      function Hash (R : Internal_Entity_Basic_Decl) return Hash_Type;


      function Trace_Image (R : Internal_Entity_Basic_Decl) return String;


         

      

      type Internal_Completion_Item is record

               Decl : aliased Internal_Entity_Basic_Decl;
               
               
               Is_Dot_Call : aliased Boolean;
               
               
               Is_Visible : aliased Boolean;
               
               
               Weight : aliased Integer;
               
               
      end record
        with Convention => C;
      No_Completion_Item : constant Internal_Completion_Item;




   


      function Trace_Image (R : Internal_Completion_Item) return String;


         

      

      type Internal_Designated_Env is record

               Kind : aliased Designated_Env_Kind;
               
               
               Env_Name : aliased Symbol_Type;
               
               
               Direct_Env : aliased Lexical_Env;
               
               
      end record
        with Convention => C;
      No_Designated_Env : constant Internal_Designated_Env;

      procedure Inc_Ref (R : Internal_Designated_Env);
      procedure Dec_Ref (R : in out Internal_Designated_Env);


      function Equivalent (L, R : Internal_Designated_Env) return Boolean;

   


      function Trace_Image (R : Internal_Designated_Env) return String;


         

      

      type Internal_Discrete_Range is record

               Low_Bound : aliased Internal_Entity_Expr;
               
               
               High_Bound : aliased Internal_Entity_Expr;
               
               
      end record
        with Convention => C;
      No_Discrete_Range : constant Internal_Discrete_Range;




   


      function Trace_Image (R : Internal_Discrete_Range) return String;


         

      

      type Internal_Entity_Ada_List is record

               Node : aliased Bare_Ada_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Ada_List : constant Internal_Entity_Ada_List;


      function Create_Internal_Entity_Ada_List
        (Node : Bare_Ada_List; Info : Internal_Entity_Info)
         return Internal_Entity_Ada_List;


   


      function Trace_Image (R : Internal_Entity_Ada_List) return String;


         

      

      type Internal_Entity_Ada_Node_List is record

               Node : aliased Bare_Ada_Node_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Ada_Node_List : constant Internal_Entity_Ada_Node_List;


      function Create_Internal_Entity_Ada_Node_List
        (Node : Bare_Ada_Node_List; Info : Internal_Entity_Info)
         return Internal_Entity_Ada_Node_List;


   


      function Trace_Image (R : Internal_Entity_Ada_Node_List) return String;


         

      

      type Internal_Entity_Alternatives_List is record

               Node : aliased Bare_Alternatives_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Alternatives_List : constant Internal_Entity_Alternatives_List;


      function Create_Internal_Entity_Alternatives_List
        (Node : Bare_Alternatives_List; Info : Internal_Entity_Info)
         return Internal_Entity_Alternatives_List;


   


      function Trace_Image (R : Internal_Entity_Alternatives_List) return String;


         

      

      type Internal_Entity_Name is record

               Node : aliased Bare_Name;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Name : constant Internal_Entity_Name;


      function Create_Internal_Entity_Name
        (Node : Bare_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Name;


   


      function Trace_Image (R : Internal_Entity_Name) return String;


         

      

      type Internal_Entity_Single_Tok_Node is record

               Node : aliased Bare_Single_Tok_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Single_Tok_Node : constant Internal_Entity_Single_Tok_Node;


      function Create_Internal_Entity_Single_Tok_Node
        (Node : Bare_Single_Tok_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Single_Tok_Node;


   


      function Trace_Image (R : Internal_Entity_Single_Tok_Node) return String;


         

      

      type Internal_Entity_Base_Id is record

               Node : aliased Bare_Base_Id;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Id : constant Internal_Entity_Base_Id;


      function Create_Internal_Entity_Base_Id
        (Node : Bare_Base_Id; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Id;


   


      function Trace_Image (R : Internal_Entity_Base_Id) return String;


         

      

      type Internal_Entity_Identifier is record

               Node : aliased Bare_Identifier;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Identifier : constant Internal_Entity_Identifier;


      function Create_Internal_Entity_Identifier
        (Node : Bare_Identifier; Info : Internal_Entity_Info)
         return Internal_Entity_Identifier;


   


      function Trace_Image (R : Internal_Entity_Identifier) return String;


         

      

      type Internal_Discriminant_Values is record

               Discriminant : aliased Internal_Entity_Identifier;
               
               
               Values : aliased Internal_Entity_Alternatives_List;
               
               
      end record
        with Convention => C;
      No_Discriminant_Values : constant Internal_Discriminant_Values;




   


      function Trace_Image (R : Internal_Discriminant_Values) return String;


         

      

      type Internal_Doc_Annotation is record

               Key : aliased String_Type;
               --  Annotation key
               
               Value : aliased String_Type;
               --  Annotation value
               
      end record
        with Convention => C;
      No_Doc_Annotation : constant Internal_Doc_Annotation;

      procedure Inc_Ref (R : Internal_Doc_Annotation);
      procedure Dec_Ref (R : in out Internal_Doc_Annotation);


      function Equivalent (L, R : Internal_Doc_Annotation) return Boolean;

   


      function Trace_Image (R : Internal_Doc_Annotation) return String;


         

      

      type Internal_Entity_Abort_Node is record

               Node : aliased Bare_Abort_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abort_Node : constant Internal_Entity_Abort_Node;


      function Create_Internal_Entity_Abort_Node
        (Node : Bare_Abort_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Abort_Node;


   


      function Trace_Image (R : Internal_Entity_Abort_Node) return String;


         

      

      type Internal_Entity_Abort_Absent is record

               Node : aliased Bare_Abort_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abort_Absent : constant Internal_Entity_Abort_Absent;


      function Create_Internal_Entity_Abort_Absent
        (Node : Bare_Abort_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Abort_Absent;


   


      function Trace_Image (R : Internal_Entity_Abort_Absent) return String;


         

      

      type Internal_Entity_Abort_Present is record

               Node : aliased Bare_Abort_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abort_Present : constant Internal_Entity_Abort_Present;


      function Create_Internal_Entity_Abort_Present
        (Node : Bare_Abort_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Abort_Present;


   


      function Trace_Image (R : Internal_Entity_Abort_Present) return String;


         

      

      type Internal_Entity_Stmt is record

               Node : aliased Bare_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Stmt : constant Internal_Entity_Stmt;


      function Create_Internal_Entity_Stmt
        (Node : Bare_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Stmt;


   


      function Trace_Image (R : Internal_Entity_Stmt) return String;


         

      

      type Internal_Entity_Simple_Stmt is record

               Node : aliased Bare_Simple_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Simple_Stmt : constant Internal_Entity_Simple_Stmt;


      function Create_Internal_Entity_Simple_Stmt
        (Node : Bare_Simple_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Simple_Stmt;


   


      function Trace_Image (R : Internal_Entity_Simple_Stmt) return String;


         

      

      type Internal_Entity_Abort_Stmt is record

               Node : aliased Bare_Abort_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abort_Stmt : constant Internal_Entity_Abort_Stmt;


      function Create_Internal_Entity_Abort_Stmt
        (Node : Bare_Abort_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Abort_Stmt;


   


      function Trace_Image (R : Internal_Entity_Abort_Stmt) return String;


         

      

      type Internal_Entity_Abstract_Node is record

               Node : aliased Bare_Abstract_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_Node : constant Internal_Entity_Abstract_Node;


      function Create_Internal_Entity_Abstract_Node
        (Node : Bare_Abstract_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Node;


   


      function Trace_Image (R : Internal_Entity_Abstract_Node) return String;


         

      

      type Internal_Entity_Abstract_Absent is record

               Node : aliased Bare_Abstract_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_Absent : constant Internal_Entity_Abstract_Absent;


      function Create_Internal_Entity_Abstract_Absent
        (Node : Bare_Abstract_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Absent;


   


      function Trace_Image (R : Internal_Entity_Abstract_Absent) return String;


         

      

      type Internal_Entity_Basic_Subp_Decl is record

               Node : aliased Bare_Basic_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Basic_Subp_Decl : constant Internal_Entity_Basic_Subp_Decl;


      function Create_Internal_Entity_Basic_Subp_Decl
        (Node : Bare_Basic_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Basic_Subp_Decl) return String;


         

      

      type Internal_Entity_Classic_Subp_Decl is record

               Node : aliased Bare_Classic_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Classic_Subp_Decl : constant Internal_Entity_Classic_Subp_Decl;


      function Create_Internal_Entity_Classic_Subp_Decl
        (Node : Bare_Classic_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Classic_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Classic_Subp_Decl) return String;


         

      

      type Internal_Entity_Formal_Subp_Decl is record

               Node : aliased Bare_Formal_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Formal_Subp_Decl : constant Internal_Entity_Formal_Subp_Decl;


      function Create_Internal_Entity_Formal_Subp_Decl
        (Node : Bare_Formal_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Formal_Subp_Decl) return String;


         

      

      type Internal_Entity_Abstract_Formal_Subp_Decl is record

               Node : aliased Bare_Abstract_Formal_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_Formal_Subp_Decl : constant Internal_Entity_Abstract_Formal_Subp_Decl;


      function Create_Internal_Entity_Abstract_Formal_Subp_Decl
        (Node : Bare_Abstract_Formal_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Formal_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Abstract_Formal_Subp_Decl) return String;


         

      

      type Internal_Entity_Abstract_Present is record

               Node : aliased Bare_Abstract_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_Present : constant Internal_Entity_Abstract_Present;


      function Create_Internal_Entity_Abstract_Present
        (Node : Bare_Abstract_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Present;


   


      function Trace_Image (R : Internal_Entity_Abstract_Present) return String;


         

      

      type Internal_Entity_Abstract_State_Decl is record

               Node : aliased Bare_Abstract_State_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_State_Decl : constant Internal_Entity_Abstract_State_Decl;


      function Create_Internal_Entity_Abstract_State_Decl
        (Node : Bare_Abstract_State_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_State_Decl;


   


      function Trace_Image (R : Internal_Entity_Abstract_State_Decl) return String;


         

      

      type Internal_Entity_Abstract_State_Decl_Expr is record

               Node : aliased Bare_Abstract_State_Decl_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_State_Decl_Expr : constant Internal_Entity_Abstract_State_Decl_Expr;


      function Create_Internal_Entity_Abstract_State_Decl_Expr
        (Node : Bare_Abstract_State_Decl_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_State_Decl_Expr;


   


      function Trace_Image (R : Internal_Entity_Abstract_State_Decl_Expr) return String;


         

      

      type Internal_Entity_Abstract_State_Decl_List is record

               Node : aliased Bare_Abstract_State_Decl_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_State_Decl_List : constant Internal_Entity_Abstract_State_Decl_List;


      function Create_Internal_Entity_Abstract_State_Decl_List
        (Node : Bare_Abstract_State_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_State_Decl_List;


   


      function Trace_Image (R : Internal_Entity_Abstract_State_Decl_List) return String;


         

      

      type Internal_Entity_Abstract_Subp_Decl is record

               Node : aliased Bare_Abstract_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Abstract_Subp_Decl : constant Internal_Entity_Abstract_Subp_Decl;


      function Create_Internal_Entity_Abstract_Subp_Decl
        (Node : Bare_Abstract_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Abstract_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Abstract_Subp_Decl) return String;


         

      

      type Internal_Entity_Composite_Stmt is record

               Node : aliased Bare_Composite_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Composite_Stmt : constant Internal_Entity_Composite_Stmt;


      function Create_Internal_Entity_Composite_Stmt
        (Node : Bare_Composite_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Composite_Stmt;


   


      function Trace_Image (R : Internal_Entity_Composite_Stmt) return String;


         

      

      type Internal_Entity_Accept_Stmt is record

               Node : aliased Bare_Accept_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Accept_Stmt : constant Internal_Entity_Accept_Stmt;


      function Create_Internal_Entity_Accept_Stmt
        (Node : Bare_Accept_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Accept_Stmt;


   


      function Trace_Image (R : Internal_Entity_Accept_Stmt) return String;


         

      

      type Internal_Entity_Accept_Stmt_With_Stmts is record

               Node : aliased Bare_Accept_Stmt_With_Stmts;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Accept_Stmt_With_Stmts : constant Internal_Entity_Accept_Stmt_With_Stmts;


      function Create_Internal_Entity_Accept_Stmt_With_Stmts
        (Node : Bare_Accept_Stmt_With_Stmts; Info : Internal_Entity_Info)
         return Internal_Entity_Accept_Stmt_With_Stmts;


   


      function Trace_Image (R : Internal_Entity_Accept_Stmt_With_Stmts) return String;


         

      

      type Internal_Entity_Type_Def is record

               Node : aliased Bare_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Def : constant Internal_Entity_Type_Def;


      function Create_Internal_Entity_Type_Def
        (Node : Bare_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Type_Def) return String;


         

      

      type Internal_Entity_Access_Def is record

               Node : aliased Bare_Access_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Access_Def : constant Internal_Entity_Access_Def;


      function Create_Internal_Entity_Access_Def
        (Node : Bare_Access_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Access_Def;


   


      function Trace_Image (R : Internal_Entity_Access_Def) return String;


         

      

      type Internal_Entity_Access_To_Subp_Def is record

               Node : aliased Bare_Access_To_Subp_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Access_To_Subp_Def : constant Internal_Entity_Access_To_Subp_Def;


      function Create_Internal_Entity_Access_To_Subp_Def
        (Node : Bare_Access_To_Subp_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Access_To_Subp_Def;


   


      function Trace_Image (R : Internal_Entity_Access_To_Subp_Def) return String;


         

      

      type Internal_Entity_Base_Aggregate is record

               Node : aliased Bare_Base_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Aggregate : constant Internal_Entity_Base_Aggregate;


      function Create_Internal_Entity_Base_Aggregate
        (Node : Bare_Base_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Base_Aggregate) return String;


         

      

      type Internal_Entity_Aggregate is record

               Node : aliased Bare_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aggregate : constant Internal_Entity_Aggregate;


      function Create_Internal_Entity_Aggregate
        (Node : Bare_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Aggregate) return String;


         

      

      type Internal_Entity_Basic_Assoc is record

               Node : aliased Bare_Basic_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Basic_Assoc : constant Internal_Entity_Basic_Assoc;


      function Create_Internal_Entity_Basic_Assoc
        (Node : Bare_Basic_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Assoc;


   


      function Trace_Image (R : Internal_Entity_Basic_Assoc) return String;


         

      

      type Internal_Entity_Aggregate_Assoc is record

               Node : aliased Bare_Aggregate_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aggregate_Assoc : constant Internal_Entity_Aggregate_Assoc;


      function Create_Internal_Entity_Aggregate_Assoc
        (Node : Bare_Aggregate_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Aggregate_Assoc;


   


      function Trace_Image (R : Internal_Entity_Aggregate_Assoc) return String;


         

      

      type Internal_Entity_Aliased_Node is record

               Node : aliased Bare_Aliased_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aliased_Node : constant Internal_Entity_Aliased_Node;


      function Create_Internal_Entity_Aliased_Node
        (Node : Bare_Aliased_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Aliased_Node;


   


      function Trace_Image (R : Internal_Entity_Aliased_Node) return String;


         

      

      type Internal_Entity_Aliased_Absent is record

               Node : aliased Bare_Aliased_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aliased_Absent : constant Internal_Entity_Aliased_Absent;


      function Create_Internal_Entity_Aliased_Absent
        (Node : Bare_Aliased_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Aliased_Absent;


   


      function Trace_Image (R : Internal_Entity_Aliased_Absent) return String;


         

      

      type Internal_Entity_Aliased_Present is record

               Node : aliased Bare_Aliased_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aliased_Present : constant Internal_Entity_Aliased_Present;


      function Create_Internal_Entity_Aliased_Present
        (Node : Bare_Aliased_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Aliased_Present;


   


      function Trace_Image (R : Internal_Entity_Aliased_Present) return String;


         

      

      type Internal_Entity_All_Node is record

               Node : aliased Bare_All_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_All_Node : constant Internal_Entity_All_Node;


      function Create_Internal_Entity_All_Node
        (Node : Bare_All_Node; Info : Internal_Entity_Info)
         return Internal_Entity_All_Node;


   


      function Trace_Image (R : Internal_Entity_All_Node) return String;


         

      

      type Internal_Entity_All_Absent is record

               Node : aliased Bare_All_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_All_Absent : constant Internal_Entity_All_Absent;


      function Create_Internal_Entity_All_Absent
        (Node : Bare_All_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_All_Absent;


   


      function Trace_Image (R : Internal_Entity_All_Absent) return String;


         

      

      type Internal_Entity_All_Present is record

               Node : aliased Bare_All_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_All_Present : constant Internal_Entity_All_Present;


      function Create_Internal_Entity_All_Present
        (Node : Bare_All_Present; Info : Internal_Entity_Info)
         return Internal_Entity_All_Present;


   


      function Trace_Image (R : Internal_Entity_All_Present) return String;


         

      

      type Internal_Entity_Allocator is record

               Node : aliased Bare_Allocator;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Allocator : constant Internal_Entity_Allocator;


      function Create_Internal_Entity_Allocator
        (Node : Bare_Allocator; Info : Internal_Entity_Info)
         return Internal_Entity_Allocator;


   


      function Trace_Image (R : Internal_Entity_Allocator) return String;


         

      

      type Internal_Entity_Anonymous_Expr_Decl is record

               Node : aliased Bare_Anonymous_Expr_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Anonymous_Expr_Decl : constant Internal_Entity_Anonymous_Expr_Decl;


      function Create_Internal_Entity_Anonymous_Expr_Decl
        (Node : Bare_Anonymous_Expr_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Anonymous_Expr_Decl;


   


      function Trace_Image (R : Internal_Entity_Anonymous_Expr_Decl) return String;


         

      

      type Internal_Entity_Type_Expr is record

               Node : aliased Bare_Type_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Expr : constant Internal_Entity_Type_Expr;


      function Create_Internal_Entity_Type_Expr
        (Node : Bare_Type_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Expr;


   


      function Trace_Image (R : Internal_Entity_Type_Expr) return String;


         

      

      type Internal_Entity_Anonymous_Type is record

               Node : aliased Bare_Anonymous_Type;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Anonymous_Type : constant Internal_Entity_Anonymous_Type;


      function Create_Internal_Entity_Anonymous_Type
        (Node : Bare_Anonymous_Type; Info : Internal_Entity_Info)
         return Internal_Entity_Anonymous_Type;


   


      function Trace_Image (R : Internal_Entity_Anonymous_Type) return String;


         

      

      type Internal_Entity_Base_Type_Access_Def is record

               Node : aliased Bare_Base_Type_Access_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Type_Access_Def : constant Internal_Entity_Base_Type_Access_Def;


      function Create_Internal_Entity_Base_Type_Access_Def
        (Node : Bare_Base_Type_Access_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Type_Access_Def;


   


      function Trace_Image (R : Internal_Entity_Base_Type_Access_Def) return String;


         

      

      type Internal_Entity_Anonymous_Type_Access_Def is record

               Node : aliased Bare_Anonymous_Type_Access_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Anonymous_Type_Access_Def : constant Internal_Entity_Anonymous_Type_Access_Def;


      function Create_Internal_Entity_Anonymous_Type_Access_Def
        (Node : Bare_Anonymous_Type_Access_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Anonymous_Type_Access_Def;


   


      function Trace_Image (R : Internal_Entity_Anonymous_Type_Access_Def) return String;


         

      

      type Internal_Entity_Base_Type_Decl is record

               Node : aliased Bare_Base_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Type_Decl : constant Internal_Entity_Base_Type_Decl;


      function Create_Internal_Entity_Base_Type_Decl
        (Node : Bare_Base_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Type_Decl;


   
      function Hash (R : Internal_Entity_Base_Type_Decl) return Hash_Type;


      function Trace_Image (R : Internal_Entity_Base_Type_Decl) return String;


         

      

      type Internal_Entity_Type_Decl is record

               Node : aliased Bare_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Decl : constant Internal_Entity_Type_Decl;


      function Create_Internal_Entity_Type_Decl
        (Node : Bare_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Type_Decl) return String;


         

      

      type Internal_Entity_Anonymous_Type_Decl is record

               Node : aliased Bare_Anonymous_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Anonymous_Type_Decl : constant Internal_Entity_Anonymous_Type_Decl;


      function Create_Internal_Entity_Anonymous_Type_Decl
        (Node : Bare_Anonymous_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Anonymous_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Anonymous_Type_Decl) return String;


         

      

      type Internal_Entity_Array_Indices is record

               Node : aliased Bare_Array_Indices;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Array_Indices : constant Internal_Entity_Array_Indices;


      function Create_Internal_Entity_Array_Indices
        (Node : Bare_Array_Indices; Info : Internal_Entity_Info)
         return Internal_Entity_Array_Indices;


   


      function Trace_Image (R : Internal_Entity_Array_Indices) return String;


         

      

      type Internal_Entity_Array_Type_Def is record

               Node : aliased Bare_Array_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Array_Type_Def : constant Internal_Entity_Array_Type_Def;


      function Create_Internal_Entity_Array_Type_Def
        (Node : Bare_Array_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Array_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Array_Type_Def) return String;


         

      

      type Internal_Entity_Aspect_Assoc is record

               Node : aliased Bare_Aspect_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aspect_Assoc : constant Internal_Entity_Aspect_Assoc;


      function Create_Internal_Entity_Aspect_Assoc
        (Node : Bare_Aspect_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_Assoc;


   


      function Trace_Image (R : Internal_Entity_Aspect_Assoc) return String;


         

      

      type Internal_Entity_Aspect_Assoc_List is record

               Node : aliased Bare_Aspect_Assoc_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aspect_Assoc_List : constant Internal_Entity_Aspect_Assoc_List;


      function Create_Internal_Entity_Aspect_Assoc_List
        (Node : Bare_Aspect_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_Assoc_List;


   


      function Trace_Image (R : Internal_Entity_Aspect_Assoc_List) return String;


         

      

      type Internal_Entity_Aspect_Clause is record

               Node : aliased Bare_Aspect_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aspect_Clause : constant Internal_Entity_Aspect_Clause;


      function Create_Internal_Entity_Aspect_Clause
        (Node : Bare_Aspect_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_Clause;


   


      function Trace_Image (R : Internal_Entity_Aspect_Clause) return String;


         

      

      type Internal_Entity_Aspect_Spec is record

               Node : aliased Bare_Aspect_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Aspect_Spec : constant Internal_Entity_Aspect_Spec;


      function Create_Internal_Entity_Aspect_Spec
        (Node : Bare_Aspect_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Aspect_Spec;


   


      function Trace_Image (R : Internal_Entity_Aspect_Spec) return String;


         

      

      type Internal_Entity_Assign_Stmt is record

               Node : aliased Bare_Assign_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Assign_Stmt : constant Internal_Entity_Assign_Stmt;


      function Create_Internal_Entity_Assign_Stmt
        (Node : Bare_Assign_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Assign_Stmt;


   


      function Trace_Image (R : Internal_Entity_Assign_Stmt) return String;


         

      

      type Internal_Entity_Basic_Assoc_List is record

               Node : aliased Bare_Basic_Assoc_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Basic_Assoc_List : constant Internal_Entity_Basic_Assoc_List;


      function Create_Internal_Entity_Basic_Assoc_List
        (Node : Bare_Basic_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Assoc_List;


   


      function Trace_Image (R : Internal_Entity_Basic_Assoc_List) return String;


         

      

      type Internal_Entity_Assoc_List is record

               Node : aliased Bare_Assoc_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Assoc_List : constant Internal_Entity_Assoc_List;


      function Create_Internal_Entity_Assoc_List
        (Node : Bare_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Assoc_List;


   


      function Trace_Image (R : Internal_Entity_Assoc_List) return String;


         

      

      type Internal_Entity_At_Clause is record

               Node : aliased Bare_At_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_At_Clause : constant Internal_Entity_At_Clause;


      function Create_Internal_Entity_At_Clause
        (Node : Bare_At_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_At_Clause;


   


      function Trace_Image (R : Internal_Entity_At_Clause) return String;


         

      

      type Internal_Entity_Attribute_Def_Clause is record

               Node : aliased Bare_Attribute_Def_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attribute_Def_Clause : constant Internal_Entity_Attribute_Def_Clause;


      function Create_Internal_Entity_Attribute_Def_Clause
        (Node : Bare_Attribute_Def_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Attribute_Def_Clause;


   


      function Trace_Image (R : Internal_Entity_Attribute_Def_Clause) return String;


         

      

      type Internal_Entity_Attribute_Ref is record

               Node : aliased Bare_Attribute_Ref;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Attribute_Ref : constant Internal_Entity_Attribute_Ref;


      function Create_Internal_Entity_Attribute_Ref
        (Node : Bare_Attribute_Ref; Info : Internal_Entity_Info)
         return Internal_Entity_Attribute_Ref;


   


      function Trace_Image (R : Internal_Entity_Attribute_Ref) return String;


         

      

      type Internal_Entity_Base_Assoc is record

               Node : aliased Bare_Base_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Assoc : constant Internal_Entity_Base_Assoc;


      function Create_Internal_Entity_Base_Assoc
        (Node : Bare_Base_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Assoc;


   


      function Trace_Image (R : Internal_Entity_Base_Assoc) return String;


         

      

      type Internal_Entity_Base_Assoc_List is record

               Node : aliased Bare_Base_Assoc_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Assoc_List : constant Internal_Entity_Base_Assoc_List;


      function Create_Internal_Entity_Base_Assoc_List
        (Node : Bare_Base_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Assoc_List;


   


      function Trace_Image (R : Internal_Entity_Base_Assoc_List) return String;


         

      

      type Internal_Entity_Base_Formal_Param_Decl is record

               Node : aliased Bare_Base_Formal_Param_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Formal_Param_Decl : constant Internal_Entity_Base_Formal_Param_Decl;


      function Create_Internal_Entity_Base_Formal_Param_Decl
        (Node : Bare_Base_Formal_Param_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Formal_Param_Decl;


   


      function Trace_Image (R : Internal_Entity_Base_Formal_Param_Decl) return String;


         

      

      type Internal_Entity_Base_Formal_Param_Holder is record

               Node : aliased Bare_Base_Formal_Param_Holder;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Formal_Param_Holder : constant Internal_Entity_Base_Formal_Param_Holder;


      function Create_Internal_Entity_Base_Formal_Param_Holder
        (Node : Bare_Base_Formal_Param_Holder; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Formal_Param_Holder;


   


      function Trace_Image (R : Internal_Entity_Base_Formal_Param_Holder) return String;


         

      

      type Internal_Entity_Base_Loop_Stmt is record

               Node : aliased Bare_Base_Loop_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Loop_Stmt : constant Internal_Entity_Base_Loop_Stmt;


      function Create_Internal_Entity_Base_Loop_Stmt
        (Node : Bare_Base_Loop_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Loop_Stmt;


   


      function Trace_Image (R : Internal_Entity_Base_Loop_Stmt) return String;


         

      

      type Internal_Entity_Base_Package_Decl is record

               Node : aliased Bare_Base_Package_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Package_Decl : constant Internal_Entity_Base_Package_Decl;


      function Create_Internal_Entity_Base_Package_Decl
        (Node : Bare_Base_Package_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Package_Decl;


   


      function Trace_Image (R : Internal_Entity_Base_Package_Decl) return String;


         

      

      type Internal_Entity_Base_Record_Def is record

               Node : aliased Bare_Base_Record_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Record_Def : constant Internal_Entity_Base_Record_Def;


      function Create_Internal_Entity_Base_Record_Def
        (Node : Bare_Base_Record_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Record_Def;


   


      function Trace_Image (R : Internal_Entity_Base_Record_Def) return String;


         

      

      type Internal_Entity_Body_Node is record

               Node : aliased Bare_Body_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Body_Node : constant Internal_Entity_Body_Node;


      function Create_Internal_Entity_Body_Node
        (Node : Bare_Body_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Body_Node;


   


      function Trace_Image (R : Internal_Entity_Body_Node) return String;


         

      

      type Internal_Entity_Base_Subp_Body is record

               Node : aliased Bare_Base_Subp_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Subp_Body : constant Internal_Entity_Base_Subp_Body;


      function Create_Internal_Entity_Base_Subp_Body
        (Node : Bare_Base_Subp_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Subp_Body;


   


      function Trace_Image (R : Internal_Entity_Base_Subp_Body) return String;


         

      

      type Internal_Entity_Base_Subp_Spec is record

               Node : aliased Bare_Base_Subp_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Subp_Spec : constant Internal_Entity_Base_Subp_Spec;


      function Create_Internal_Entity_Base_Subp_Spec
        (Node : Bare_Base_Subp_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Subp_Spec;


   


      function Trace_Image (R : Internal_Entity_Base_Subp_Spec) return String;


         

      

      type Internal_Entity_Base_Subtype_Decl is record

               Node : aliased Bare_Base_Subtype_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Base_Subtype_Decl : constant Internal_Entity_Base_Subtype_Decl;


      function Create_Internal_Entity_Base_Subtype_Decl
        (Node : Bare_Base_Subtype_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Base_Subtype_Decl;


   


      function Trace_Image (R : Internal_Entity_Base_Subtype_Decl) return String;


         

      

      type Internal_Entity_Basic_Decl_List is record

               Node : aliased Bare_Basic_Decl_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Basic_Decl_List : constant Internal_Entity_Basic_Decl_List;


      function Create_Internal_Entity_Basic_Decl_List
        (Node : Bare_Basic_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Basic_Decl_List;


   


      function Trace_Image (R : Internal_Entity_Basic_Decl_List) return String;


         

      

      type Internal_Entity_Block_Stmt is record

               Node : aliased Bare_Block_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Block_Stmt : constant Internal_Entity_Block_Stmt;


      function Create_Internal_Entity_Block_Stmt
        (Node : Bare_Block_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Block_Stmt;


   


      function Trace_Image (R : Internal_Entity_Block_Stmt) return String;


         

      

      type Internal_Entity_Begin_Block is record

               Node : aliased Bare_Begin_Block;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Begin_Block : constant Internal_Entity_Begin_Block;


      function Create_Internal_Entity_Begin_Block
        (Node : Bare_Begin_Block; Info : Internal_Entity_Info)
         return Internal_Entity_Begin_Block;


   


      function Trace_Image (R : Internal_Entity_Begin_Block) return String;


         

      

      type Internal_Entity_Bin_Op is record

               Node : aliased Bare_Bin_Op;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Bin_Op : constant Internal_Entity_Bin_Op;


      function Create_Internal_Entity_Bin_Op
        (Node : Bare_Bin_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Bin_Op;


   


      function Trace_Image (R : Internal_Entity_Bin_Op) return String;


         

      

      type Internal_Entity_Body_Stub is record

               Node : aliased Bare_Body_Stub;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Body_Stub : constant Internal_Entity_Body_Stub;


      function Create_Internal_Entity_Body_Stub
        (Node : Bare_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Body_Stub;


   


      function Trace_Image (R : Internal_Entity_Body_Stub) return String;


         

      

      type Internal_Entity_Box_Expr is record

               Node : aliased Bare_Box_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Box_Expr : constant Internal_Entity_Box_Expr;


      function Create_Internal_Entity_Box_Expr
        (Node : Bare_Box_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Box_Expr;


   


      function Trace_Image (R : Internal_Entity_Box_Expr) return String;


         

      

      type Internal_Entity_Bracket_Aggregate is record

               Node : aliased Bare_Bracket_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Bracket_Aggregate : constant Internal_Entity_Bracket_Aggregate;


      function Create_Internal_Entity_Bracket_Aggregate
        (Node : Bare_Bracket_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Bracket_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Bracket_Aggregate) return String;


         

      

      type Internal_Entity_Delta_Aggregate is record

               Node : aliased Bare_Delta_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Delta_Aggregate : constant Internal_Entity_Delta_Aggregate;


      function Create_Internal_Entity_Delta_Aggregate
        (Node : Bare_Delta_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Delta_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Delta_Aggregate) return String;


         

      

      type Internal_Entity_Bracket_Delta_Aggregate is record

               Node : aliased Bare_Bracket_Delta_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Bracket_Delta_Aggregate : constant Internal_Entity_Bracket_Delta_Aggregate;


      function Create_Internal_Entity_Bracket_Delta_Aggregate
        (Node : Bare_Bracket_Delta_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Bracket_Delta_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Bracket_Delta_Aggregate) return String;


         

      

      type Internal_Entity_Call_Expr is record

               Node : aliased Bare_Call_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Call_Expr : constant Internal_Entity_Call_Expr;


      function Create_Internal_Entity_Call_Expr
        (Node : Bare_Call_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Call_Expr;


   


      function Trace_Image (R : Internal_Entity_Call_Expr) return String;


         

      

      type Internal_Entity_Call_Stmt is record

               Node : aliased Bare_Call_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Call_Stmt : constant Internal_Entity_Call_Stmt;


      function Create_Internal_Entity_Call_Stmt
        (Node : Bare_Call_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Call_Stmt;


   


      function Trace_Image (R : Internal_Entity_Call_Stmt) return String;


         

      

      type Internal_Entity_Cond_Expr is record

               Node : aliased Bare_Cond_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Cond_Expr : constant Internal_Entity_Cond_Expr;


      function Create_Internal_Entity_Cond_Expr
        (Node : Bare_Cond_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Cond_Expr;


   


      function Trace_Image (R : Internal_Entity_Cond_Expr) return String;


         

      

      type Internal_Entity_Case_Expr is record

               Node : aliased Bare_Case_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Case_Expr : constant Internal_Entity_Case_Expr;


      function Create_Internal_Entity_Case_Expr
        (Node : Bare_Case_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Expr;


   


      function Trace_Image (R : Internal_Entity_Case_Expr) return String;


         

      

      type Internal_Entity_Case_Expr_Alternative is record

               Node : aliased Bare_Case_Expr_Alternative;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Case_Expr_Alternative : constant Internal_Entity_Case_Expr_Alternative;


      function Create_Internal_Entity_Case_Expr_Alternative
        (Node : Bare_Case_Expr_Alternative; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Expr_Alternative;


   


      function Trace_Image (R : Internal_Entity_Case_Expr_Alternative) return String;


         

      

      type Internal_Entity_Case_Expr_Alternative_List is record

               Node : aliased Bare_Case_Expr_Alternative_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Case_Expr_Alternative_List : constant Internal_Entity_Case_Expr_Alternative_List;


      function Create_Internal_Entity_Case_Expr_Alternative_List
        (Node : Bare_Case_Expr_Alternative_List; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Expr_Alternative_List;


   


      function Trace_Image (R : Internal_Entity_Case_Expr_Alternative_List) return String;


         

      

      type Internal_Entity_Case_Stmt is record

               Node : aliased Bare_Case_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Case_Stmt : constant Internal_Entity_Case_Stmt;


      function Create_Internal_Entity_Case_Stmt
        (Node : Bare_Case_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Stmt;


   


      function Trace_Image (R : Internal_Entity_Case_Stmt) return String;


         

      

      type Internal_Entity_Case_Stmt_Alternative is record

               Node : aliased Bare_Case_Stmt_Alternative;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Case_Stmt_Alternative : constant Internal_Entity_Case_Stmt_Alternative;


      function Create_Internal_Entity_Case_Stmt_Alternative
        (Node : Bare_Case_Stmt_Alternative; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Stmt_Alternative;


   


      function Trace_Image (R : Internal_Entity_Case_Stmt_Alternative) return String;


         

      

      type Internal_Entity_Case_Stmt_Alternative_List is record

               Node : aliased Bare_Case_Stmt_Alternative_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Case_Stmt_Alternative_List : constant Internal_Entity_Case_Stmt_Alternative_List;


      function Create_Internal_Entity_Case_Stmt_Alternative_List
        (Node : Bare_Case_Stmt_Alternative_List; Info : Internal_Entity_Info)
         return Internal_Entity_Case_Stmt_Alternative_List;


   


      function Trace_Image (R : Internal_Entity_Case_Stmt_Alternative_List) return String;


         

      

      type Internal_Entity_Char_Literal is record

               Node : aliased Bare_Char_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Char_Literal : constant Internal_Entity_Char_Literal;


      function Create_Internal_Entity_Char_Literal
        (Node : Bare_Char_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Char_Literal;


   


      function Trace_Image (R : Internal_Entity_Char_Literal) return String;


         

      

      type Internal_Entity_Classwide_Type_Decl is record

               Node : aliased Bare_Classwide_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Classwide_Type_Decl : constant Internal_Entity_Classwide_Type_Decl;


      function Create_Internal_Entity_Classwide_Type_Decl
        (Node : Bare_Classwide_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Classwide_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Classwide_Type_Decl) return String;


         

      

      type Internal_Entity_Compilation_Unit is record

               Node : aliased Bare_Compilation_Unit;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Compilation_Unit : constant Internal_Entity_Compilation_Unit;


      function Create_Internal_Entity_Compilation_Unit
        (Node : Bare_Compilation_Unit; Info : Internal_Entity_Info)
         return Internal_Entity_Compilation_Unit;


   
      function Hash (R : Internal_Entity_Compilation_Unit) return Hash_Type;


      function Trace_Image (R : Internal_Entity_Compilation_Unit) return String;


         

      

      type Internal_Entity_Compilation_Unit_List is record

               Node : aliased Bare_Compilation_Unit_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Compilation_Unit_List : constant Internal_Entity_Compilation_Unit_List;


      function Create_Internal_Entity_Compilation_Unit_List
        (Node : Bare_Compilation_Unit_List; Info : Internal_Entity_Info)
         return Internal_Entity_Compilation_Unit_List;


   


      function Trace_Image (R : Internal_Entity_Compilation_Unit_List) return String;


         

      

      type Internal_Entity_Component_Clause is record

               Node : aliased Bare_Component_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Component_Clause : constant Internal_Entity_Component_Clause;


      function Create_Internal_Entity_Component_Clause
        (Node : Bare_Component_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Component_Clause;


   


      function Trace_Image (R : Internal_Entity_Component_Clause) return String;


         

      

      type Internal_Entity_Component_Decl is record

               Node : aliased Bare_Component_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Component_Decl : constant Internal_Entity_Component_Decl;


      function Create_Internal_Entity_Component_Decl
        (Node : Bare_Component_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Component_Decl;


   


      function Trace_Image (R : Internal_Entity_Component_Decl) return String;


         

      

      type Internal_Entity_Component_Def is record

               Node : aliased Bare_Component_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Component_Def : constant Internal_Entity_Component_Def;


      function Create_Internal_Entity_Component_Def
        (Node : Bare_Component_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Component_Def;


   


      function Trace_Image (R : Internal_Entity_Component_Def) return String;


         

      

      type Internal_Entity_Component_List is record

               Node : aliased Bare_Component_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Component_List : constant Internal_Entity_Component_List;


      function Create_Internal_Entity_Component_List
        (Node : Bare_Component_List; Info : Internal_Entity_Info)
         return Internal_Entity_Component_List;


   


      function Trace_Image (R : Internal_Entity_Component_List) return String;


         

      

      type Internal_Entity_Constraint is record

               Node : aliased Bare_Constraint;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Constraint : constant Internal_Entity_Constraint;


      function Create_Internal_Entity_Constraint
        (Node : Bare_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Constraint;


   


      function Trace_Image (R : Internal_Entity_Constraint) return String;


         

      

      type Internal_Entity_Composite_Constraint is record

               Node : aliased Bare_Composite_Constraint;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Composite_Constraint : constant Internal_Entity_Composite_Constraint;


      function Create_Internal_Entity_Composite_Constraint
        (Node : Bare_Composite_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Composite_Constraint;


   


      function Trace_Image (R : Internal_Entity_Composite_Constraint) return String;


         

      

      type Internal_Entity_Composite_Constraint_Assoc is record

               Node : aliased Bare_Composite_Constraint_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Composite_Constraint_Assoc : constant Internal_Entity_Composite_Constraint_Assoc;


      function Create_Internal_Entity_Composite_Constraint_Assoc
        (Node : Bare_Composite_Constraint_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Composite_Constraint_Assoc;


   


      function Trace_Image (R : Internal_Entity_Composite_Constraint_Assoc) return String;


         

      

      type Internal_Entity_Concat_Op is record

               Node : aliased Bare_Concat_Op;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Concat_Op : constant Internal_Entity_Concat_Op;


      function Create_Internal_Entity_Concat_Op
        (Node : Bare_Concat_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Concat_Op;


   


      function Trace_Image (R : Internal_Entity_Concat_Op) return String;


         

      

      type Internal_Entity_Concat_Operand is record

               Node : aliased Bare_Concat_Operand;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Concat_Operand : constant Internal_Entity_Concat_Operand;


      function Create_Internal_Entity_Concat_Operand
        (Node : Bare_Concat_Operand; Info : Internal_Entity_Info)
         return Internal_Entity_Concat_Operand;


   


      function Trace_Image (R : Internal_Entity_Concat_Operand) return String;


         

      

      type Internal_Entity_Concat_Operand_List is record

               Node : aliased Bare_Concat_Operand_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Concat_Operand_List : constant Internal_Entity_Concat_Operand_List;


      function Create_Internal_Entity_Concat_Operand_List
        (Node : Bare_Concat_Operand_List; Info : Internal_Entity_Info)
         return Internal_Entity_Concat_Operand_List;


   


      function Trace_Image (R : Internal_Entity_Concat_Operand_List) return String;


         

      

      type Internal_Entity_Concrete_Formal_Subp_Decl is record

               Node : aliased Bare_Concrete_Formal_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Concrete_Formal_Subp_Decl : constant Internal_Entity_Concrete_Formal_Subp_Decl;


      function Create_Internal_Entity_Concrete_Formal_Subp_Decl
        (Node : Bare_Concrete_Formal_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Concrete_Formal_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Concrete_Formal_Subp_Decl) return String;


         

      

      type Internal_Entity_Concrete_Type_Decl is record

               Node : aliased Bare_Concrete_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Concrete_Type_Decl : constant Internal_Entity_Concrete_Type_Decl;


      function Create_Internal_Entity_Concrete_Type_Decl
        (Node : Bare_Concrete_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Concrete_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Concrete_Type_Decl) return String;


         

      

      type Internal_Entity_Constant_Node is record

               Node : aliased Bare_Constant_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Constant_Node : constant Internal_Entity_Constant_Node;


      function Create_Internal_Entity_Constant_Node
        (Node : Bare_Constant_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Constant_Node;


   


      function Trace_Image (R : Internal_Entity_Constant_Node) return String;


         

      

      type Internal_Entity_Constant_Absent is record

               Node : aliased Bare_Constant_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Constant_Absent : constant Internal_Entity_Constant_Absent;


      function Create_Internal_Entity_Constant_Absent
        (Node : Bare_Constant_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Constant_Absent;


   


      function Trace_Image (R : Internal_Entity_Constant_Absent) return String;


         

      

      type Internal_Entity_Constant_Present is record

               Node : aliased Bare_Constant_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Constant_Present : constant Internal_Entity_Constant_Present;


      function Create_Internal_Entity_Constant_Present
        (Node : Bare_Constant_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Constant_Present;


   


      function Trace_Image (R : Internal_Entity_Constant_Present) return String;


         

      

      type Internal_Entity_Constrained_Array_Indices is record

               Node : aliased Bare_Constrained_Array_Indices;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Constrained_Array_Indices : constant Internal_Entity_Constrained_Array_Indices;


      function Create_Internal_Entity_Constrained_Array_Indices
        (Node : Bare_Constrained_Array_Indices; Info : Internal_Entity_Info)
         return Internal_Entity_Constrained_Array_Indices;


   


      function Trace_Image (R : Internal_Entity_Constrained_Array_Indices) return String;


         

      

      type Internal_Entity_Subtype_Indication is record

               Node : aliased Bare_Subtype_Indication;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subtype_Indication : constant Internal_Entity_Subtype_Indication;


      function Create_Internal_Entity_Subtype_Indication
        (Node : Bare_Subtype_Indication; Info : Internal_Entity_Info)
         return Internal_Entity_Subtype_Indication;


   


      function Trace_Image (R : Internal_Entity_Subtype_Indication) return String;


         

      

      type Internal_Entity_Constrained_Subtype_Indication is record

               Node : aliased Bare_Constrained_Subtype_Indication;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Constrained_Subtype_Indication : constant Internal_Entity_Constrained_Subtype_Indication;


      function Create_Internal_Entity_Constrained_Subtype_Indication
        (Node : Bare_Constrained_Subtype_Indication; Info : Internal_Entity_Info)
         return Internal_Entity_Constrained_Subtype_Indication;


   


      function Trace_Image (R : Internal_Entity_Constrained_Subtype_Indication) return String;


         

      

      type Internal_Entity_Constraint_List is record

               Node : aliased Bare_Constraint_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Constraint_List : constant Internal_Entity_Constraint_List;


      function Create_Internal_Entity_Constraint_List
        (Node : Bare_Constraint_List; Info : Internal_Entity_Info)
         return Internal_Entity_Constraint_List;


   


      function Trace_Image (R : Internal_Entity_Constraint_List) return String;


         

      

      type Internal_Entity_Contract_Case_Assoc is record

               Node : aliased Bare_Contract_Case_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Contract_Case_Assoc : constant Internal_Entity_Contract_Case_Assoc;


      function Create_Internal_Entity_Contract_Case_Assoc
        (Node : Bare_Contract_Case_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Contract_Case_Assoc;


   


      function Trace_Image (R : Internal_Entity_Contract_Case_Assoc) return String;


         

      

      type Internal_Entity_Contract_Case_Assoc_List is record

               Node : aliased Bare_Contract_Case_Assoc_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Contract_Case_Assoc_List : constant Internal_Entity_Contract_Case_Assoc_List;


      function Create_Internal_Entity_Contract_Case_Assoc_List
        (Node : Bare_Contract_Case_Assoc_List; Info : Internal_Entity_Info)
         return Internal_Entity_Contract_Case_Assoc_List;


   


      function Trace_Image (R : Internal_Entity_Contract_Case_Assoc_List) return String;


         

      

      type Internal_Entity_Contract_Cases is record

               Node : aliased Bare_Contract_Cases;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Contract_Cases : constant Internal_Entity_Contract_Cases;


      function Create_Internal_Entity_Contract_Cases
        (Node : Bare_Contract_Cases; Info : Internal_Entity_Info)
         return Internal_Entity_Contract_Cases;


   


      function Trace_Image (R : Internal_Entity_Contract_Cases) return String;


         

      

      type Internal_Entity_Real_Type_Def is record

               Node : aliased Bare_Real_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Real_Type_Def : constant Internal_Entity_Real_Type_Def;


      function Create_Internal_Entity_Real_Type_Def
        (Node : Bare_Real_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Real_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Real_Type_Def) return String;


         

      

      type Internal_Entity_Decimal_Fixed_Point_Def is record

               Node : aliased Bare_Decimal_Fixed_Point_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Decimal_Fixed_Point_Def : constant Internal_Entity_Decimal_Fixed_Point_Def;


      function Create_Internal_Entity_Decimal_Fixed_Point_Def
        (Node : Bare_Decimal_Fixed_Point_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Decimal_Fixed_Point_Def;


   


      function Trace_Image (R : Internal_Entity_Decimal_Fixed_Point_Def) return String;


         

      

      type Internal_Entity_Decl_Block is record

               Node : aliased Bare_Decl_Block;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Decl_Block : constant Internal_Entity_Decl_Block;


      function Create_Internal_Entity_Decl_Block
        (Node : Bare_Decl_Block; Info : Internal_Entity_Info)
         return Internal_Entity_Decl_Block;


   


      function Trace_Image (R : Internal_Entity_Decl_Block) return String;


         

      

      type Internal_Entity_Decl_Expr is record

               Node : aliased Bare_Decl_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Decl_Expr : constant Internal_Entity_Decl_Expr;


      function Create_Internal_Entity_Decl_Expr
        (Node : Bare_Decl_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Decl_Expr;


   


      function Trace_Image (R : Internal_Entity_Decl_Expr) return String;


         

      

      type Internal_Entity_Decl_List is record

               Node : aliased Bare_Decl_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Decl_List : constant Internal_Entity_Decl_List;


      function Create_Internal_Entity_Decl_List
        (Node : Bare_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Decl_List;


   


      function Trace_Image (R : Internal_Entity_Decl_List) return String;


         

      

      type Internal_Entity_Declarative_Part is record

               Node : aliased Bare_Declarative_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Declarative_Part : constant Internal_Entity_Declarative_Part;


      function Create_Internal_Entity_Declarative_Part
        (Node : Bare_Declarative_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Declarative_Part;


   


      function Trace_Image (R : Internal_Entity_Declarative_Part) return String;


         

      

      type Internal_Entity_Defining_Name is record

               Node : aliased Bare_Defining_Name;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Defining_Name : constant Internal_Entity_Defining_Name;


      function Create_Internal_Entity_Defining_Name
        (Node : Bare_Defining_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Defining_Name;


   


      function Trace_Image (R : Internal_Entity_Defining_Name) return String;


         

      

      type Internal_Entity_Defining_Name_List is record

               Node : aliased Bare_Defining_Name_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Defining_Name_List : constant Internal_Entity_Defining_Name_List;


      function Create_Internal_Entity_Defining_Name_List
        (Node : Bare_Defining_Name_List; Info : Internal_Entity_Info)
         return Internal_Entity_Defining_Name_List;


   


      function Trace_Image (R : Internal_Entity_Defining_Name_List) return String;


         

      

      type Internal_Entity_Delay_Stmt is record

               Node : aliased Bare_Delay_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Delay_Stmt : constant Internal_Entity_Delay_Stmt;


      function Create_Internal_Entity_Delay_Stmt
        (Node : Bare_Delay_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Delay_Stmt;


   


      function Trace_Image (R : Internal_Entity_Delay_Stmt) return String;


         

      

      type Internal_Entity_Delta_Constraint is record

               Node : aliased Bare_Delta_Constraint;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Delta_Constraint : constant Internal_Entity_Delta_Constraint;


      function Create_Internal_Entity_Delta_Constraint
        (Node : Bare_Delta_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Delta_Constraint;


   


      function Trace_Image (R : Internal_Entity_Delta_Constraint) return String;


         

      

      type Internal_Entity_Derived_Type_Def is record

               Node : aliased Bare_Derived_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Derived_Type_Def : constant Internal_Entity_Derived_Type_Def;


      function Create_Internal_Entity_Derived_Type_Def
        (Node : Bare_Derived_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Derived_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Derived_Type_Def) return String;


         

      

      type Internal_Entity_Digits_Constraint is record

               Node : aliased Bare_Digits_Constraint;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Digits_Constraint : constant Internal_Entity_Digits_Constraint;


      function Create_Internal_Entity_Digits_Constraint
        (Node : Bare_Digits_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Digits_Constraint;


   


      function Trace_Image (R : Internal_Entity_Digits_Constraint) return String;


         

      

      type Internal_Entity_Discrete_Base_Subtype_Decl is record

               Node : aliased Bare_Discrete_Base_Subtype_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Discrete_Base_Subtype_Decl : constant Internal_Entity_Discrete_Base_Subtype_Decl;


      function Create_Internal_Entity_Discrete_Base_Subtype_Decl
        (Node : Bare_Discrete_Base_Subtype_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Discrete_Base_Subtype_Decl;


   


      function Trace_Image (R : Internal_Entity_Discrete_Base_Subtype_Decl) return String;


         

      

      type Internal_Entity_Discrete_Subtype_Indication is record

               Node : aliased Bare_Discrete_Subtype_Indication;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Discrete_Subtype_Indication : constant Internal_Entity_Discrete_Subtype_Indication;


      function Create_Internal_Entity_Discrete_Subtype_Indication
        (Node : Bare_Discrete_Subtype_Indication; Info : Internal_Entity_Info)
         return Internal_Entity_Discrete_Subtype_Indication;


   


      function Trace_Image (R : Internal_Entity_Discrete_Subtype_Indication) return String;


         

      

      type Internal_Entity_Discrete_Subtype_Name is record

               Node : aliased Bare_Discrete_Subtype_Name;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Discrete_Subtype_Name : constant Internal_Entity_Discrete_Subtype_Name;


      function Create_Internal_Entity_Discrete_Subtype_Name
        (Node : Bare_Discrete_Subtype_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Discrete_Subtype_Name;


   


      function Trace_Image (R : Internal_Entity_Discrete_Subtype_Name) return String;


         

      

      type Internal_Entity_Identifier_List is record

               Node : aliased Bare_Identifier_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Identifier_List : constant Internal_Entity_Identifier_List;


      function Create_Internal_Entity_Identifier_List
        (Node : Bare_Identifier_List; Info : Internal_Entity_Info)
         return Internal_Entity_Identifier_List;


   


      function Trace_Image (R : Internal_Entity_Identifier_List) return String;


         

      

      type Internal_Entity_Discriminant_Choice_List is record

               Node : aliased Bare_Discriminant_Choice_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Discriminant_Choice_List : constant Internal_Entity_Discriminant_Choice_List;


      function Create_Internal_Entity_Discriminant_Choice_List
        (Node : Bare_Discriminant_Choice_List; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Choice_List;


   


      function Trace_Image (R : Internal_Entity_Discriminant_Choice_List) return String;


         

      

      type Internal_Entity_Discriminant_Part is record

               Node : aliased Bare_Discriminant_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Discriminant_Part : constant Internal_Entity_Discriminant_Part;


      function Create_Internal_Entity_Discriminant_Part
        (Node : Bare_Discriminant_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Part;


   


      function Trace_Image (R : Internal_Entity_Discriminant_Part) return String;


         

      

      type Internal_Entity_Discriminant_Spec is record

               Node : aliased Bare_Discriminant_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Discriminant_Spec : constant Internal_Entity_Discriminant_Spec;


      function Create_Internal_Entity_Discriminant_Spec
        (Node : Bare_Discriminant_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Spec;


   


      function Trace_Image (R : Internal_Entity_Discriminant_Spec) return String;


         

      

      type Internal_Entity_Discriminant_Spec_List is record

               Node : aliased Bare_Discriminant_Spec_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Discriminant_Spec_List : constant Internal_Entity_Discriminant_Spec_List;


      function Create_Internal_Entity_Discriminant_Spec_List
        (Node : Bare_Discriminant_Spec_List; Info : Internal_Entity_Info)
         return Internal_Entity_Discriminant_Spec_List;


   


      function Trace_Image (R : Internal_Entity_Discriminant_Spec_List) return String;


         

      

      type Internal_Entity_Dotted_Name is record

               Node : aliased Bare_Dotted_Name;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Dotted_Name : constant Internal_Entity_Dotted_Name;


      function Create_Internal_Entity_Dotted_Name
        (Node : Bare_Dotted_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Dotted_Name;


   


      function Trace_Image (R : Internal_Entity_Dotted_Name) return String;


         

      

      type Internal_Entity_Elsif_Expr_Part is record

               Node : aliased Bare_Elsif_Expr_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Elsif_Expr_Part : constant Internal_Entity_Elsif_Expr_Part;


      function Create_Internal_Entity_Elsif_Expr_Part
        (Node : Bare_Elsif_Expr_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Elsif_Expr_Part;


   


      function Trace_Image (R : Internal_Entity_Elsif_Expr_Part) return String;


         

      

      type Internal_Entity_Elsif_Expr_Part_List is record

               Node : aliased Bare_Elsif_Expr_Part_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Elsif_Expr_Part_List : constant Internal_Entity_Elsif_Expr_Part_List;


      function Create_Internal_Entity_Elsif_Expr_Part_List
        (Node : Bare_Elsif_Expr_Part_List; Info : Internal_Entity_Info)
         return Internal_Entity_Elsif_Expr_Part_List;


   


      function Trace_Image (R : Internal_Entity_Elsif_Expr_Part_List) return String;


         

      

      type Internal_Entity_Elsif_Stmt_Part is record

               Node : aliased Bare_Elsif_Stmt_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Elsif_Stmt_Part : constant Internal_Entity_Elsif_Stmt_Part;


      function Create_Internal_Entity_Elsif_Stmt_Part
        (Node : Bare_Elsif_Stmt_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Elsif_Stmt_Part;


   


      function Trace_Image (R : Internal_Entity_Elsif_Stmt_Part) return String;


         

      

      type Internal_Entity_Elsif_Stmt_Part_List is record

               Node : aliased Bare_Elsif_Stmt_Part_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Elsif_Stmt_Part_List : constant Internal_Entity_Elsif_Stmt_Part_List;


      function Create_Internal_Entity_Elsif_Stmt_Part_List
        (Node : Bare_Elsif_Stmt_Part_List; Info : Internal_Entity_Info)
         return Internal_Entity_Elsif_Stmt_Part_List;


   


      function Trace_Image (R : Internal_Entity_Elsif_Stmt_Part_List) return String;


         

      

      type Internal_Entity_End_Name is record

               Node : aliased Bare_End_Name;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_End_Name : constant Internal_Entity_End_Name;


      function Create_Internal_Entity_End_Name
        (Node : Bare_End_Name; Info : Internal_Entity_Info)
         return Internal_Entity_End_Name;


   


      function Trace_Image (R : Internal_Entity_End_Name) return String;


         

      

      type Internal_Entity_Entry_Body is record

               Node : aliased Bare_Entry_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Entry_Body : constant Internal_Entity_Entry_Body;


      function Create_Internal_Entity_Entry_Body
        (Node : Bare_Entry_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Body;


   


      function Trace_Image (R : Internal_Entity_Entry_Body) return String;


         

      

      type Internal_Entity_Entry_Completion_Formal_Params is record

               Node : aliased Bare_Entry_Completion_Formal_Params;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Entry_Completion_Formal_Params : constant Internal_Entity_Entry_Completion_Formal_Params;


      function Create_Internal_Entity_Entry_Completion_Formal_Params
        (Node : Bare_Entry_Completion_Formal_Params; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Completion_Formal_Params;


   


      function Trace_Image (R : Internal_Entity_Entry_Completion_Formal_Params) return String;


         

      

      type Internal_Entity_Entry_Decl is record

               Node : aliased Bare_Entry_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Entry_Decl : constant Internal_Entity_Entry_Decl;


      function Create_Internal_Entity_Entry_Decl
        (Node : Bare_Entry_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Decl;


   


      function Trace_Image (R : Internal_Entity_Entry_Decl) return String;


         

      

      type Internal_Entity_Entry_Index_Spec is record

               Node : aliased Bare_Entry_Index_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Entry_Index_Spec : constant Internal_Entity_Entry_Index_Spec;


      function Create_Internal_Entity_Entry_Index_Spec
        (Node : Bare_Entry_Index_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Index_Spec;


   


      function Trace_Image (R : Internal_Entity_Entry_Index_Spec) return String;


         

      

      type Internal_Entity_Entry_Spec is record

               Node : aliased Bare_Entry_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Entry_Spec : constant Internal_Entity_Entry_Spec;


      function Create_Internal_Entity_Entry_Spec
        (Node : Bare_Entry_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Entry_Spec;


   


      function Trace_Image (R : Internal_Entity_Entry_Spec) return String;


         

      

      type Internal_Entity_Enum_Lit_Synth_Type_Expr is record

               Node : aliased Bare_Enum_Lit_Synth_Type_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Enum_Lit_Synth_Type_Expr : constant Internal_Entity_Enum_Lit_Synth_Type_Expr;


      function Create_Internal_Entity_Enum_Lit_Synth_Type_Expr
        (Node : Bare_Enum_Lit_Synth_Type_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Lit_Synth_Type_Expr;


   


      function Trace_Image (R : Internal_Entity_Enum_Lit_Synth_Type_Expr) return String;


         

      

      type Internal_Entity_Enum_Literal_Decl is record

               Node : aliased Bare_Enum_Literal_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Enum_Literal_Decl : constant Internal_Entity_Enum_Literal_Decl;


      function Create_Internal_Entity_Enum_Literal_Decl
        (Node : Bare_Enum_Literal_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Literal_Decl;


   


      function Trace_Image (R : Internal_Entity_Enum_Literal_Decl) return String;


         

      

      type Internal_Entity_Enum_Literal_Decl_List is record

               Node : aliased Bare_Enum_Literal_Decl_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Enum_Literal_Decl_List : constant Internal_Entity_Enum_Literal_Decl_List;


      function Create_Internal_Entity_Enum_Literal_Decl_List
        (Node : Bare_Enum_Literal_Decl_List; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Literal_Decl_List;


   


      function Trace_Image (R : Internal_Entity_Enum_Literal_Decl_List) return String;


         

      

      type Internal_Entity_Enum_Rep_Clause is record

               Node : aliased Bare_Enum_Rep_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Enum_Rep_Clause : constant Internal_Entity_Enum_Rep_Clause;


      function Create_Internal_Entity_Enum_Rep_Clause
        (Node : Bare_Enum_Rep_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Rep_Clause;


   


      function Trace_Image (R : Internal_Entity_Enum_Rep_Clause) return String;


         

      

      type Internal_Entity_Enum_Subp_Spec is record

               Node : aliased Bare_Enum_Subp_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Enum_Subp_Spec : constant Internal_Entity_Enum_Subp_Spec;


      function Create_Internal_Entity_Enum_Subp_Spec
        (Node : Bare_Enum_Subp_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Subp_Spec;


   


      function Trace_Image (R : Internal_Entity_Enum_Subp_Spec) return String;


         

      

      type Internal_Entity_Enum_Type_Def is record

               Node : aliased Bare_Enum_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Enum_Type_Def : constant Internal_Entity_Enum_Type_Def;


      function Create_Internal_Entity_Enum_Type_Def
        (Node : Bare_Enum_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Enum_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Enum_Type_Def) return String;


         

      

      type Internal_Entity_Error_Decl is record

               Node : aliased Bare_Error_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Error_Decl : constant Internal_Entity_Error_Decl;


      function Create_Internal_Entity_Error_Decl
        (Node : Bare_Error_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Error_Decl;


   


      function Trace_Image (R : Internal_Entity_Error_Decl) return String;


         

      

      type Internal_Entity_Error_Stmt is record

               Node : aliased Bare_Error_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Error_Stmt : constant Internal_Entity_Error_Stmt;


      function Create_Internal_Entity_Error_Stmt
        (Node : Bare_Error_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Error_Stmt;


   


      function Trace_Image (R : Internal_Entity_Error_Stmt) return String;


         

      

      type Internal_Entity_Exception_Decl is record

               Node : aliased Bare_Exception_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Exception_Decl : constant Internal_Entity_Exception_Decl;


      function Create_Internal_Entity_Exception_Decl
        (Node : Bare_Exception_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Exception_Decl;


   


      function Trace_Image (R : Internal_Entity_Exception_Decl) return String;


         

      

      type Internal_Entity_Exception_Handler is record

               Node : aliased Bare_Exception_Handler;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Exception_Handler : constant Internal_Entity_Exception_Handler;


      function Create_Internal_Entity_Exception_Handler
        (Node : Bare_Exception_Handler; Info : Internal_Entity_Info)
         return Internal_Entity_Exception_Handler;


   


      function Trace_Image (R : Internal_Entity_Exception_Handler) return String;


         

      

      type Internal_Entity_Exit_Stmt is record

               Node : aliased Bare_Exit_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Exit_Stmt : constant Internal_Entity_Exit_Stmt;


      function Create_Internal_Entity_Exit_Stmt
        (Node : Bare_Exit_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Exit_Stmt;


   


      function Trace_Image (R : Internal_Entity_Exit_Stmt) return String;


         

      

      type Internal_Entity_Explicit_Deref is record

               Node : aliased Bare_Explicit_Deref;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Explicit_Deref : constant Internal_Entity_Explicit_Deref;


      function Create_Internal_Entity_Explicit_Deref
        (Node : Bare_Explicit_Deref; Info : Internal_Entity_Info)
         return Internal_Entity_Explicit_Deref;


   


      function Trace_Image (R : Internal_Entity_Explicit_Deref) return String;


         

      

      type Internal_Entity_Expr_List is record

               Node : aliased Bare_Expr_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Expr_List : constant Internal_Entity_Expr_List;


      function Create_Internal_Entity_Expr_List
        (Node : Bare_Expr_List; Info : Internal_Entity_Info)
         return Internal_Entity_Expr_List;


   


      function Trace_Image (R : Internal_Entity_Expr_List) return String;


         

      

      type Internal_Entity_Expr_Alternatives_List is record

               Node : aliased Bare_Expr_Alternatives_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Expr_Alternatives_List : constant Internal_Entity_Expr_Alternatives_List;


      function Create_Internal_Entity_Expr_Alternatives_List
        (Node : Bare_Expr_Alternatives_List; Info : Internal_Entity_Info)
         return Internal_Entity_Expr_Alternatives_List;


   


      function Trace_Image (R : Internal_Entity_Expr_Alternatives_List) return String;


         

      

      type Internal_Entity_Expr_Function is record

               Node : aliased Bare_Expr_Function;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Expr_Function : constant Internal_Entity_Expr_Function;


      function Create_Internal_Entity_Expr_Function
        (Node : Bare_Expr_Function; Info : Internal_Entity_Info)
         return Internal_Entity_Expr_Function;


   


      function Trace_Image (R : Internal_Entity_Expr_Function) return String;


         

      

      type Internal_Entity_Extended_Return_Stmt is record

               Node : aliased Bare_Extended_Return_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Extended_Return_Stmt : constant Internal_Entity_Extended_Return_Stmt;


      function Create_Internal_Entity_Extended_Return_Stmt
        (Node : Bare_Extended_Return_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Extended_Return_Stmt;


   


      function Trace_Image (R : Internal_Entity_Extended_Return_Stmt) return String;


         

      

      type Internal_Entity_Object_Decl is record

               Node : aliased Bare_Object_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Object_Decl : constant Internal_Entity_Object_Decl;


      function Create_Internal_Entity_Object_Decl
        (Node : Bare_Object_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Object_Decl;


   


      function Trace_Image (R : Internal_Entity_Object_Decl) return String;


         

      

      type Internal_Entity_Extended_Return_Stmt_Object_Decl is record

               Node : aliased Bare_Extended_Return_Stmt_Object_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Extended_Return_Stmt_Object_Decl : constant Internal_Entity_Extended_Return_Stmt_Object_Decl;


      function Create_Internal_Entity_Extended_Return_Stmt_Object_Decl
        (Node : Bare_Extended_Return_Stmt_Object_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Extended_Return_Stmt_Object_Decl;


   


      function Trace_Image (R : Internal_Entity_Extended_Return_Stmt_Object_Decl) return String;


         

      

      type Internal_Entity_Floating_Point_Def is record

               Node : aliased Bare_Floating_Point_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Floating_Point_Def : constant Internal_Entity_Floating_Point_Def;


      function Create_Internal_Entity_Floating_Point_Def
        (Node : Bare_Floating_Point_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Floating_Point_Def;


   


      function Trace_Image (R : Internal_Entity_Floating_Point_Def) return String;


         

      

      type Internal_Entity_Loop_Spec is record

               Node : aliased Bare_Loop_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Loop_Spec : constant Internal_Entity_Loop_Spec;


      function Create_Internal_Entity_Loop_Spec
        (Node : Bare_Loop_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Loop_Spec;


   


      function Trace_Image (R : Internal_Entity_Loop_Spec) return String;


         

      

      type Internal_Entity_For_Loop_Spec is record

               Node : aliased Bare_For_Loop_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_For_Loop_Spec : constant Internal_Entity_For_Loop_Spec;


      function Create_Internal_Entity_For_Loop_Spec
        (Node : Bare_For_Loop_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_For_Loop_Spec;


   


      function Trace_Image (R : Internal_Entity_For_Loop_Spec) return String;


         

      

      type Internal_Entity_For_Loop_Stmt is record

               Node : aliased Bare_For_Loop_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_For_Loop_Stmt : constant Internal_Entity_For_Loop_Stmt;


      function Create_Internal_Entity_For_Loop_Stmt
        (Node : Bare_For_Loop_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_For_Loop_Stmt;


   


      function Trace_Image (R : Internal_Entity_For_Loop_Stmt) return String;


         

      

      type Internal_Entity_For_Loop_Var_Decl is record

               Node : aliased Bare_For_Loop_Var_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_For_Loop_Var_Decl : constant Internal_Entity_For_Loop_Var_Decl;


      function Create_Internal_Entity_For_Loop_Var_Decl
        (Node : Bare_For_Loop_Var_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_For_Loop_Var_Decl;


   


      function Trace_Image (R : Internal_Entity_For_Loop_Var_Decl) return String;


         

      

      type Internal_Entity_Formal_Discrete_Type_Def is record

               Node : aliased Bare_Formal_Discrete_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Formal_Discrete_Type_Def : constant Internal_Entity_Formal_Discrete_Type_Def;


      function Create_Internal_Entity_Formal_Discrete_Type_Def
        (Node : Bare_Formal_Discrete_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Discrete_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Formal_Discrete_Type_Def) return String;


         

      

      type Internal_Entity_Formal_Type_Decl is record

               Node : aliased Bare_Formal_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Formal_Type_Decl : constant Internal_Entity_Formal_Type_Decl;


      function Create_Internal_Entity_Formal_Type_Decl
        (Node : Bare_Formal_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Formal_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Formal_Type_Decl) return String;


         

      

      type Internal_Entity_Generic_Decl is record

               Node : aliased Bare_Generic_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Decl : constant Internal_Entity_Generic_Decl;


      function Create_Internal_Entity_Generic_Decl
        (Node : Bare_Generic_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Decl) return String;


         

      

      type Internal_Entity_Generic_Formal is record

               Node : aliased Bare_Generic_Formal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Formal : constant Internal_Entity_Generic_Formal;


      function Create_Internal_Entity_Generic_Formal
        (Node : Bare_Generic_Formal; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal;


   


      function Trace_Image (R : Internal_Entity_Generic_Formal) return String;


         

      

      type Internal_Entity_Generic_Formal_Obj_Decl is record

               Node : aliased Bare_Generic_Formal_Obj_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Formal_Obj_Decl : constant Internal_Entity_Generic_Formal_Obj_Decl;


      function Create_Internal_Entity_Generic_Formal_Obj_Decl
        (Node : Bare_Generic_Formal_Obj_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Obj_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Formal_Obj_Decl) return String;


         

      

      type Internal_Entity_Generic_Formal_Package is record

               Node : aliased Bare_Generic_Formal_Package;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Formal_Package : constant Internal_Entity_Generic_Formal_Package;


      function Create_Internal_Entity_Generic_Formal_Package
        (Node : Bare_Generic_Formal_Package; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Package;


   


      function Trace_Image (R : Internal_Entity_Generic_Formal_Package) return String;


         

      

      type Internal_Entity_Generic_Formal_Part is record

               Node : aliased Bare_Generic_Formal_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Formal_Part : constant Internal_Entity_Generic_Formal_Part;


      function Create_Internal_Entity_Generic_Formal_Part
        (Node : Bare_Generic_Formal_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Part;


   


      function Trace_Image (R : Internal_Entity_Generic_Formal_Part) return String;


         

      

      type Internal_Entity_Generic_Formal_Subp_Decl is record

               Node : aliased Bare_Generic_Formal_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Formal_Subp_Decl : constant Internal_Entity_Generic_Formal_Subp_Decl;


      function Create_Internal_Entity_Generic_Formal_Subp_Decl
        (Node : Bare_Generic_Formal_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Formal_Subp_Decl) return String;


         

      

      type Internal_Entity_Generic_Formal_Type_Decl is record

               Node : aliased Bare_Generic_Formal_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Formal_Type_Decl : constant Internal_Entity_Generic_Formal_Type_Decl;


      function Create_Internal_Entity_Generic_Formal_Type_Decl
        (Node : Bare_Generic_Formal_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Formal_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Formal_Type_Decl) return String;


         

      

      type Internal_Entity_Generic_Instantiation is record

               Node : aliased Bare_Generic_Instantiation;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Instantiation : constant Internal_Entity_Generic_Instantiation;


      function Create_Internal_Entity_Generic_Instantiation
        (Node : Bare_Generic_Instantiation; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Instantiation;


   


      function Trace_Image (R : Internal_Entity_Generic_Instantiation) return String;


         

      

      type Internal_Entity_Generic_Package_Decl is record

               Node : aliased Bare_Generic_Package_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Package_Decl : constant Internal_Entity_Generic_Package_Decl;


      function Create_Internal_Entity_Generic_Package_Decl
        (Node : Bare_Generic_Package_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Package_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Package_Decl) return String;


         

      

      type Internal_Entity_Generic_Package_Instantiation is record

               Node : aliased Bare_Generic_Package_Instantiation;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Package_Instantiation : constant Internal_Entity_Generic_Package_Instantiation;


      function Create_Internal_Entity_Generic_Package_Instantiation
        (Node : Bare_Generic_Package_Instantiation; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Package_Instantiation;


   


      function Trace_Image (R : Internal_Entity_Generic_Package_Instantiation) return String;


         

      

      type Internal_Entity_Generic_Package_Internal is record

               Node : aliased Bare_Generic_Package_Internal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Package_Internal : constant Internal_Entity_Generic_Package_Internal;


      function Create_Internal_Entity_Generic_Package_Internal
        (Node : Bare_Generic_Package_Internal; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Package_Internal;


   


      function Trace_Image (R : Internal_Entity_Generic_Package_Internal) return String;


         

      

      type Internal_Entity_Generic_Renaming_Decl is record

               Node : aliased Bare_Generic_Renaming_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Renaming_Decl : constant Internal_Entity_Generic_Renaming_Decl;


      function Create_Internal_Entity_Generic_Renaming_Decl
        (Node : Bare_Generic_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Renaming_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Renaming_Decl) return String;


         

      

      type Internal_Entity_Generic_Package_Renaming_Decl is record

               Node : aliased Bare_Generic_Package_Renaming_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Package_Renaming_Decl : constant Internal_Entity_Generic_Package_Renaming_Decl;


      function Create_Internal_Entity_Generic_Package_Renaming_Decl
        (Node : Bare_Generic_Package_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Package_Renaming_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Package_Renaming_Decl) return String;


         

      

      type Internal_Entity_Generic_Subp_Decl is record

               Node : aliased Bare_Generic_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Subp_Decl : constant Internal_Entity_Generic_Subp_Decl;


      function Create_Internal_Entity_Generic_Subp_Decl
        (Node : Bare_Generic_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Subp_Decl) return String;


         

      

      type Internal_Entity_Generic_Subp_Instantiation is record

               Node : aliased Bare_Generic_Subp_Instantiation;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Subp_Instantiation : constant Internal_Entity_Generic_Subp_Instantiation;


      function Create_Internal_Entity_Generic_Subp_Instantiation
        (Node : Bare_Generic_Subp_Instantiation; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Subp_Instantiation;


   


      function Trace_Image (R : Internal_Entity_Generic_Subp_Instantiation) return String;


         

      

      type Internal_Entity_Generic_Subp_Internal is record

               Node : aliased Bare_Generic_Subp_Internal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Subp_Internal : constant Internal_Entity_Generic_Subp_Internal;


      function Create_Internal_Entity_Generic_Subp_Internal
        (Node : Bare_Generic_Subp_Internal; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Subp_Internal;


   


      function Trace_Image (R : Internal_Entity_Generic_Subp_Internal) return String;


         

      

      type Internal_Entity_Generic_Subp_Renaming_Decl is record

               Node : aliased Bare_Generic_Subp_Renaming_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Generic_Subp_Renaming_Decl : constant Internal_Entity_Generic_Subp_Renaming_Decl;


      function Create_Internal_Entity_Generic_Subp_Renaming_Decl
        (Node : Bare_Generic_Subp_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Generic_Subp_Renaming_Decl;


   


      function Trace_Image (R : Internal_Entity_Generic_Subp_Renaming_Decl) return String;


         

      

      type Internal_Entity_Goto_Stmt is record

               Node : aliased Bare_Goto_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Goto_Stmt : constant Internal_Entity_Goto_Stmt;


      function Create_Internal_Entity_Goto_Stmt
        (Node : Bare_Goto_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Goto_Stmt;


   


      function Trace_Image (R : Internal_Entity_Goto_Stmt) return String;


         

      

      type Internal_Entity_Handled_Stmts is record

               Node : aliased Bare_Handled_Stmts;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Handled_Stmts : constant Internal_Entity_Handled_Stmts;


      function Create_Internal_Entity_Handled_Stmts
        (Node : Bare_Handled_Stmts; Info : Internal_Entity_Info)
         return Internal_Entity_Handled_Stmts;


   


      function Trace_Image (R : Internal_Entity_Handled_Stmts) return String;


         

      

      type Internal_Entity_If_Expr is record

               Node : aliased Bare_If_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_If_Expr : constant Internal_Entity_If_Expr;


      function Create_Internal_Entity_If_Expr
        (Node : Bare_If_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_If_Expr;


   


      function Trace_Image (R : Internal_Entity_If_Expr) return String;


         

      

      type Internal_Entity_If_Stmt is record

               Node : aliased Bare_If_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_If_Stmt : constant Internal_Entity_If_Stmt;


      function Create_Internal_Entity_If_Stmt
        (Node : Bare_If_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_If_Stmt;


   


      function Trace_Image (R : Internal_Entity_If_Stmt) return String;


         

      

      type Internal_Entity_Incomplete_Type_Decl is record

               Node : aliased Bare_Incomplete_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Incomplete_Type_Decl : constant Internal_Entity_Incomplete_Type_Decl;


      function Create_Internal_Entity_Incomplete_Type_Decl
        (Node : Bare_Incomplete_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Incomplete_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Incomplete_Type_Decl) return String;


         

      

      type Internal_Entity_Incomplete_Formal_Type_Decl is record

               Node : aliased Bare_Incomplete_Formal_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Incomplete_Formal_Type_Decl : constant Internal_Entity_Incomplete_Formal_Type_Decl;


      function Create_Internal_Entity_Incomplete_Formal_Type_Decl
        (Node : Bare_Incomplete_Formal_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Incomplete_Formal_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Incomplete_Formal_Type_Decl) return String;


         

      

      type Internal_Entity_Incomplete_Tagged_Type_Decl is record

               Node : aliased Bare_Incomplete_Tagged_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Incomplete_Tagged_Type_Decl : constant Internal_Entity_Incomplete_Tagged_Type_Decl;


      function Create_Internal_Entity_Incomplete_Tagged_Type_Decl
        (Node : Bare_Incomplete_Tagged_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Incomplete_Tagged_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Incomplete_Tagged_Type_Decl) return String;


         

      

      type Internal_Entity_Num_Literal is record

               Node : aliased Bare_Num_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Num_Literal : constant Internal_Entity_Num_Literal;


      function Create_Internal_Entity_Num_Literal
        (Node : Bare_Num_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Num_Literal;


   


      function Trace_Image (R : Internal_Entity_Num_Literal) return String;


         

      

      type Internal_Entity_Int_Literal is record

               Node : aliased Bare_Int_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Int_Literal : constant Internal_Entity_Int_Literal;


      function Create_Internal_Entity_Int_Literal
        (Node : Bare_Int_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Int_Literal;


   


      function Trace_Image (R : Internal_Entity_Int_Literal) return String;


         

      

      type Internal_Entity_Interface_Kind is record

               Node : aliased Bare_Interface_Kind;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Interface_Kind : constant Internal_Entity_Interface_Kind;


      function Create_Internal_Entity_Interface_Kind
        (Node : Bare_Interface_Kind; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind;


   


      function Trace_Image (R : Internal_Entity_Interface_Kind) return String;


         

      

      type Internal_Entity_Interface_Kind_Limited is record

               Node : aliased Bare_Interface_Kind_Limited;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Interface_Kind_Limited : constant Internal_Entity_Interface_Kind_Limited;


      function Create_Internal_Entity_Interface_Kind_Limited
        (Node : Bare_Interface_Kind_Limited; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind_Limited;


   


      function Trace_Image (R : Internal_Entity_Interface_Kind_Limited) return String;


         

      

      type Internal_Entity_Interface_Kind_Protected is record

               Node : aliased Bare_Interface_Kind_Protected;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Interface_Kind_Protected : constant Internal_Entity_Interface_Kind_Protected;


      function Create_Internal_Entity_Interface_Kind_Protected
        (Node : Bare_Interface_Kind_Protected; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind_Protected;


   


      function Trace_Image (R : Internal_Entity_Interface_Kind_Protected) return String;


         

      

      type Internal_Entity_Interface_Kind_Synchronized is record

               Node : aliased Bare_Interface_Kind_Synchronized;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Interface_Kind_Synchronized : constant Internal_Entity_Interface_Kind_Synchronized;


      function Create_Internal_Entity_Interface_Kind_Synchronized
        (Node : Bare_Interface_Kind_Synchronized; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind_Synchronized;


   


      function Trace_Image (R : Internal_Entity_Interface_Kind_Synchronized) return String;


         

      

      type Internal_Entity_Interface_Kind_Task is record

               Node : aliased Bare_Interface_Kind_Task;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Interface_Kind_Task : constant Internal_Entity_Interface_Kind_Task;


      function Create_Internal_Entity_Interface_Kind_Task
        (Node : Bare_Interface_Kind_Task; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Kind_Task;


   


      function Trace_Image (R : Internal_Entity_Interface_Kind_Task) return String;


         

      

      type Internal_Entity_Interface_Type_Def is record

               Node : aliased Bare_Interface_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Interface_Type_Def : constant Internal_Entity_Interface_Type_Def;


      function Create_Internal_Entity_Interface_Type_Def
        (Node : Bare_Interface_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Interface_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Interface_Type_Def) return String;


         

      

      type Internal_Entity_Iter_Type is record

               Node : aliased Bare_Iter_Type;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Iter_Type : constant Internal_Entity_Iter_Type;


      function Create_Internal_Entity_Iter_Type
        (Node : Bare_Iter_Type; Info : Internal_Entity_Info)
         return Internal_Entity_Iter_Type;


   


      function Trace_Image (R : Internal_Entity_Iter_Type) return String;


         

      

      type Internal_Entity_Iter_Type_In is record

               Node : aliased Bare_Iter_Type_In;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Iter_Type_In : constant Internal_Entity_Iter_Type_In;


      function Create_Internal_Entity_Iter_Type_In
        (Node : Bare_Iter_Type_In; Info : Internal_Entity_Info)
         return Internal_Entity_Iter_Type_In;


   


      function Trace_Image (R : Internal_Entity_Iter_Type_In) return String;


         

      

      type Internal_Entity_Iter_Type_Of is record

               Node : aliased Bare_Iter_Type_Of;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Iter_Type_Of : constant Internal_Entity_Iter_Type_Of;


      function Create_Internal_Entity_Iter_Type_Of
        (Node : Bare_Iter_Type_Of; Info : Internal_Entity_Info)
         return Internal_Entity_Iter_Type_Of;


   


      function Trace_Image (R : Internal_Entity_Iter_Type_Of) return String;


         

      

      type Internal_Entity_Iterated_Assoc is record

               Node : aliased Bare_Iterated_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Iterated_Assoc : constant Internal_Entity_Iterated_Assoc;


      function Create_Internal_Entity_Iterated_Assoc
        (Node : Bare_Iterated_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Iterated_Assoc;


   


      function Trace_Image (R : Internal_Entity_Iterated_Assoc) return String;


         

      

      type Internal_Entity_Known_Discriminant_Part is record

               Node : aliased Bare_Known_Discriminant_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Known_Discriminant_Part : constant Internal_Entity_Known_Discriminant_Part;


      function Create_Internal_Entity_Known_Discriminant_Part
        (Node : Bare_Known_Discriminant_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Known_Discriminant_Part;


   


      function Trace_Image (R : Internal_Entity_Known_Discriminant_Part) return String;


         

      

      type Internal_Entity_Label is record

               Node : aliased Bare_Label;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Label : constant Internal_Entity_Label;


      function Create_Internal_Entity_Label
        (Node : Bare_Label; Info : Internal_Entity_Info)
         return Internal_Entity_Label;


   


      function Trace_Image (R : Internal_Entity_Label) return String;


         

      

      type Internal_Entity_Label_Decl is record

               Node : aliased Bare_Label_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Label_Decl : constant Internal_Entity_Label_Decl;


      function Create_Internal_Entity_Label_Decl
        (Node : Bare_Label_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Label_Decl;


   


      function Trace_Image (R : Internal_Entity_Label_Decl) return String;


         

      

      type Internal_Entity_Library_Item is record

               Node : aliased Bare_Library_Item;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Library_Item : constant Internal_Entity_Library_Item;


      function Create_Internal_Entity_Library_Item
        (Node : Bare_Library_Item; Info : Internal_Entity_Info)
         return Internal_Entity_Library_Item;


   


      function Trace_Image (R : Internal_Entity_Library_Item) return String;


         

      

      type Internal_Entity_Limited_Node is record

               Node : aliased Bare_Limited_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Limited_Node : constant Internal_Entity_Limited_Node;


      function Create_Internal_Entity_Limited_Node
        (Node : Bare_Limited_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Limited_Node;


   


      function Trace_Image (R : Internal_Entity_Limited_Node) return String;


         

      

      type Internal_Entity_Limited_Absent is record

               Node : aliased Bare_Limited_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Limited_Absent : constant Internal_Entity_Limited_Absent;


      function Create_Internal_Entity_Limited_Absent
        (Node : Bare_Limited_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Limited_Absent;


   


      function Trace_Image (R : Internal_Entity_Limited_Absent) return String;


         

      

      type Internal_Entity_Limited_Present is record

               Node : aliased Bare_Limited_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Limited_Present : constant Internal_Entity_Limited_Present;


      function Create_Internal_Entity_Limited_Present
        (Node : Bare_Limited_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Limited_Present;


   


      function Trace_Image (R : Internal_Entity_Limited_Present) return String;


         

      

      type Internal_Entity_Loop_Stmt is record

               Node : aliased Bare_Loop_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Loop_Stmt : constant Internal_Entity_Loop_Stmt;


      function Create_Internal_Entity_Loop_Stmt
        (Node : Bare_Loop_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Loop_Stmt;


   


      function Trace_Image (R : Internal_Entity_Loop_Stmt) return String;


         

      

      type Internal_Entity_Membership_Expr is record

               Node : aliased Bare_Membership_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Membership_Expr : constant Internal_Entity_Membership_Expr;


      function Create_Internal_Entity_Membership_Expr
        (Node : Bare_Membership_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Membership_Expr;


   


      function Trace_Image (R : Internal_Entity_Membership_Expr) return String;


         

      

      type Internal_Entity_Mod_Int_Type_Def is record

               Node : aliased Bare_Mod_Int_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Mod_Int_Type_Def : constant Internal_Entity_Mod_Int_Type_Def;


      function Create_Internal_Entity_Mod_Int_Type_Def
        (Node : Bare_Mod_Int_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Mod_Int_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Mod_Int_Type_Def) return String;


         

      

      type Internal_Entity_Mode is record

               Node : aliased Bare_Mode;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Mode : constant Internal_Entity_Mode;


      function Create_Internal_Entity_Mode
        (Node : Bare_Mode; Info : Internal_Entity_Info)
         return Internal_Entity_Mode;


   


      function Trace_Image (R : Internal_Entity_Mode) return String;


         

      

      type Internal_Entity_Mode_Default is record

               Node : aliased Bare_Mode_Default;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Mode_Default : constant Internal_Entity_Mode_Default;


      function Create_Internal_Entity_Mode_Default
        (Node : Bare_Mode_Default; Info : Internal_Entity_Info)
         return Internal_Entity_Mode_Default;


   


      function Trace_Image (R : Internal_Entity_Mode_Default) return String;


         

      

      type Internal_Entity_Mode_In is record

               Node : aliased Bare_Mode_In;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Mode_In : constant Internal_Entity_Mode_In;


      function Create_Internal_Entity_Mode_In
        (Node : Bare_Mode_In; Info : Internal_Entity_Info)
         return Internal_Entity_Mode_In;


   


      function Trace_Image (R : Internal_Entity_Mode_In) return String;


         

      

      type Internal_Entity_Mode_In_Out is record

               Node : aliased Bare_Mode_In_Out;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Mode_In_Out : constant Internal_Entity_Mode_In_Out;


      function Create_Internal_Entity_Mode_In_Out
        (Node : Bare_Mode_In_Out; Info : Internal_Entity_Info)
         return Internal_Entity_Mode_In_Out;


   


      function Trace_Image (R : Internal_Entity_Mode_In_Out) return String;


         

      

      type Internal_Entity_Mode_Out is record

               Node : aliased Bare_Mode_Out;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Mode_Out : constant Internal_Entity_Mode_Out;


      function Create_Internal_Entity_Mode_Out
        (Node : Bare_Mode_Out; Info : Internal_Entity_Info)
         return Internal_Entity_Mode_Out;


   


      function Trace_Image (R : Internal_Entity_Mode_Out) return String;


         

      

      type Internal_Entity_Multi_Abstract_State_Decl is record

               Node : aliased Bare_Multi_Abstract_State_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Multi_Abstract_State_Decl : constant Internal_Entity_Multi_Abstract_State_Decl;


      function Create_Internal_Entity_Multi_Abstract_State_Decl
        (Node : Bare_Multi_Abstract_State_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Multi_Abstract_State_Decl;


   


      function Trace_Image (R : Internal_Entity_Multi_Abstract_State_Decl) return String;


         

      

      type Internal_Entity_Multi_Dim_Array_Assoc is record

               Node : aliased Bare_Multi_Dim_Array_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Multi_Dim_Array_Assoc : constant Internal_Entity_Multi_Dim_Array_Assoc;


      function Create_Internal_Entity_Multi_Dim_Array_Assoc
        (Node : Bare_Multi_Dim_Array_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Multi_Dim_Array_Assoc;


   


      function Trace_Image (R : Internal_Entity_Multi_Dim_Array_Assoc) return String;


         

      

      type Internal_Entity_Name_List is record

               Node : aliased Bare_Name_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Name_List : constant Internal_Entity_Name_List;


      function Create_Internal_Entity_Name_List
        (Node : Bare_Name_List; Info : Internal_Entity_Info)
         return Internal_Entity_Name_List;


   


      function Trace_Image (R : Internal_Entity_Name_List) return String;


         

      

      type Internal_Entity_Named_Stmt is record

               Node : aliased Bare_Named_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Named_Stmt : constant Internal_Entity_Named_Stmt;


      function Create_Internal_Entity_Named_Stmt
        (Node : Bare_Named_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Named_Stmt;


   


      function Trace_Image (R : Internal_Entity_Named_Stmt) return String;


         

      

      type Internal_Entity_Named_Stmt_Decl is record

               Node : aliased Bare_Named_Stmt_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Named_Stmt_Decl : constant Internal_Entity_Named_Stmt_Decl;


      function Create_Internal_Entity_Named_Stmt_Decl
        (Node : Bare_Named_Stmt_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Named_Stmt_Decl;


   


      function Trace_Image (R : Internal_Entity_Named_Stmt_Decl) return String;


         

      

      type Internal_Entity_No_Type_Object_Renaming_Decl is record

               Node : aliased Bare_No_Type_Object_Renaming_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_No_Type_Object_Renaming_Decl : constant Internal_Entity_No_Type_Object_Renaming_Decl;


      function Create_Internal_Entity_No_Type_Object_Renaming_Decl
        (Node : Bare_No_Type_Object_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_No_Type_Object_Renaming_Decl;


   


      function Trace_Image (R : Internal_Entity_No_Type_Object_Renaming_Decl) return String;


         

      

      type Internal_Entity_Not_Null is record

               Node : aliased Bare_Not_Null;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Not_Null : constant Internal_Entity_Not_Null;


      function Create_Internal_Entity_Not_Null
        (Node : Bare_Not_Null; Info : Internal_Entity_Info)
         return Internal_Entity_Not_Null;


   


      function Trace_Image (R : Internal_Entity_Not_Null) return String;


         

      

      type Internal_Entity_Not_Null_Absent is record

               Node : aliased Bare_Not_Null_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Not_Null_Absent : constant Internal_Entity_Not_Null_Absent;


      function Create_Internal_Entity_Not_Null_Absent
        (Node : Bare_Not_Null_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Not_Null_Absent;


   


      function Trace_Image (R : Internal_Entity_Not_Null_Absent) return String;


         

      

      type Internal_Entity_Not_Null_Present is record

               Node : aliased Bare_Not_Null_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Not_Null_Present : constant Internal_Entity_Not_Null_Present;


      function Create_Internal_Entity_Not_Null_Present
        (Node : Bare_Not_Null_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Not_Null_Present;


   


      function Trace_Image (R : Internal_Entity_Not_Null_Present) return String;


         

      

      type Internal_Entity_Null_Component_Decl is record

               Node : aliased Bare_Null_Component_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Component_Decl : constant Internal_Entity_Null_Component_Decl;


      function Create_Internal_Entity_Null_Component_Decl
        (Node : Bare_Null_Component_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Component_Decl;


   


      function Trace_Image (R : Internal_Entity_Null_Component_Decl) return String;


         

      

      type Internal_Entity_Null_Literal is record

               Node : aliased Bare_Null_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Literal : constant Internal_Entity_Null_Literal;


      function Create_Internal_Entity_Null_Literal
        (Node : Bare_Null_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Literal;


   


      function Trace_Image (R : Internal_Entity_Null_Literal) return String;


         

      

      type Internal_Entity_Null_Record_Aggregate is record

               Node : aliased Bare_Null_Record_Aggregate;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Record_Aggregate : constant Internal_Entity_Null_Record_Aggregate;


      function Create_Internal_Entity_Null_Record_Aggregate
        (Node : Bare_Null_Record_Aggregate; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Record_Aggregate;


   


      function Trace_Image (R : Internal_Entity_Null_Record_Aggregate) return String;


         

      

      type Internal_Entity_Null_Record_Def is record

               Node : aliased Bare_Null_Record_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Record_Def : constant Internal_Entity_Null_Record_Def;


      function Create_Internal_Entity_Null_Record_Def
        (Node : Bare_Null_Record_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Record_Def;


   


      function Trace_Image (R : Internal_Entity_Null_Record_Def) return String;


         

      

      type Internal_Entity_Null_Stmt is record

               Node : aliased Bare_Null_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Stmt : constant Internal_Entity_Null_Stmt;


      function Create_Internal_Entity_Null_Stmt
        (Node : Bare_Null_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Stmt;


   


      function Trace_Image (R : Internal_Entity_Null_Stmt) return String;


         

      

      type Internal_Entity_Null_Subp_Decl is record

               Node : aliased Bare_Null_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Null_Subp_Decl : constant Internal_Entity_Null_Subp_Decl;


      function Create_Internal_Entity_Null_Subp_Decl
        (Node : Bare_Null_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Null_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Null_Subp_Decl) return String;


         

      

      type Internal_Entity_Number_Decl is record

               Node : aliased Bare_Number_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Number_Decl : constant Internal_Entity_Number_Decl;


      function Create_Internal_Entity_Number_Decl
        (Node : Bare_Number_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Number_Decl;


   


      function Trace_Image (R : Internal_Entity_Number_Decl) return String;


         

      

      type Internal_Entity_Op is record

               Node : aliased Bare_Op;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op : constant Internal_Entity_Op;


      function Create_Internal_Entity_Op
        (Node : Bare_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Op;


   


      function Trace_Image (R : Internal_Entity_Op) return String;


         

      

      type Internal_Entity_Op_Abs is record

               Node : aliased Bare_Op_Abs;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Abs : constant Internal_Entity_Op_Abs;


      function Create_Internal_Entity_Op_Abs
        (Node : Bare_Op_Abs; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Abs;


   


      function Trace_Image (R : Internal_Entity_Op_Abs) return String;


         

      

      type Internal_Entity_Op_And is record

               Node : aliased Bare_Op_And;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_And : constant Internal_Entity_Op_And;


      function Create_Internal_Entity_Op_And
        (Node : Bare_Op_And; Info : Internal_Entity_Info)
         return Internal_Entity_Op_And;


   


      function Trace_Image (R : Internal_Entity_Op_And) return String;


         

      

      type Internal_Entity_Op_And_Then is record

               Node : aliased Bare_Op_And_Then;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_And_Then : constant Internal_Entity_Op_And_Then;


      function Create_Internal_Entity_Op_And_Then
        (Node : Bare_Op_And_Then; Info : Internal_Entity_Info)
         return Internal_Entity_Op_And_Then;


   


      function Trace_Image (R : Internal_Entity_Op_And_Then) return String;


         

      

      type Internal_Entity_Op_Concat is record

               Node : aliased Bare_Op_Concat;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Concat : constant Internal_Entity_Op_Concat;


      function Create_Internal_Entity_Op_Concat
        (Node : Bare_Op_Concat; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Concat;


   


      function Trace_Image (R : Internal_Entity_Op_Concat) return String;


         

      

      type Internal_Entity_Op_Div is record

               Node : aliased Bare_Op_Div;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Div : constant Internal_Entity_Op_Div;


      function Create_Internal_Entity_Op_Div
        (Node : Bare_Op_Div; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Div;


   


      function Trace_Image (R : Internal_Entity_Op_Div) return String;


         

      

      type Internal_Entity_Op_Double_Dot is record

               Node : aliased Bare_Op_Double_Dot;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Double_Dot : constant Internal_Entity_Op_Double_Dot;


      function Create_Internal_Entity_Op_Double_Dot
        (Node : Bare_Op_Double_Dot; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Double_Dot;


   


      function Trace_Image (R : Internal_Entity_Op_Double_Dot) return String;


         

      

      type Internal_Entity_Op_Eq is record

               Node : aliased Bare_Op_Eq;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Eq : constant Internal_Entity_Op_Eq;


      function Create_Internal_Entity_Op_Eq
        (Node : Bare_Op_Eq; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Eq;


   


      function Trace_Image (R : Internal_Entity_Op_Eq) return String;


         

      

      type Internal_Entity_Op_Gt is record

               Node : aliased Bare_Op_Gt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Gt : constant Internal_Entity_Op_Gt;


      function Create_Internal_Entity_Op_Gt
        (Node : Bare_Op_Gt; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Gt;


   


      function Trace_Image (R : Internal_Entity_Op_Gt) return String;


         

      

      type Internal_Entity_Op_Gte is record

               Node : aliased Bare_Op_Gte;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Gte : constant Internal_Entity_Op_Gte;


      function Create_Internal_Entity_Op_Gte
        (Node : Bare_Op_Gte; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Gte;


   


      function Trace_Image (R : Internal_Entity_Op_Gte) return String;


         

      

      type Internal_Entity_Op_In is record

               Node : aliased Bare_Op_In;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_In : constant Internal_Entity_Op_In;


      function Create_Internal_Entity_Op_In
        (Node : Bare_Op_In; Info : Internal_Entity_Info)
         return Internal_Entity_Op_In;


   


      function Trace_Image (R : Internal_Entity_Op_In) return String;


         

      

      type Internal_Entity_Op_Lt is record

               Node : aliased Bare_Op_Lt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Lt : constant Internal_Entity_Op_Lt;


      function Create_Internal_Entity_Op_Lt
        (Node : Bare_Op_Lt; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Lt;


   


      function Trace_Image (R : Internal_Entity_Op_Lt) return String;


         

      

      type Internal_Entity_Op_Lte is record

               Node : aliased Bare_Op_Lte;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Lte : constant Internal_Entity_Op_Lte;


      function Create_Internal_Entity_Op_Lte
        (Node : Bare_Op_Lte; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Lte;


   


      function Trace_Image (R : Internal_Entity_Op_Lte) return String;


         

      

      type Internal_Entity_Op_Minus is record

               Node : aliased Bare_Op_Minus;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Minus : constant Internal_Entity_Op_Minus;


      function Create_Internal_Entity_Op_Minus
        (Node : Bare_Op_Minus; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Minus;


   


      function Trace_Image (R : Internal_Entity_Op_Minus) return String;


         

      

      type Internal_Entity_Op_Mod is record

               Node : aliased Bare_Op_Mod;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Mod : constant Internal_Entity_Op_Mod;


      function Create_Internal_Entity_Op_Mod
        (Node : Bare_Op_Mod; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Mod;


   


      function Trace_Image (R : Internal_Entity_Op_Mod) return String;


         

      

      type Internal_Entity_Op_Mult is record

               Node : aliased Bare_Op_Mult;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Mult : constant Internal_Entity_Op_Mult;


      function Create_Internal_Entity_Op_Mult
        (Node : Bare_Op_Mult; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Mult;


   


      function Trace_Image (R : Internal_Entity_Op_Mult) return String;


         

      

      type Internal_Entity_Op_Neq is record

               Node : aliased Bare_Op_Neq;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Neq : constant Internal_Entity_Op_Neq;


      function Create_Internal_Entity_Op_Neq
        (Node : Bare_Op_Neq; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Neq;


   


      function Trace_Image (R : Internal_Entity_Op_Neq) return String;


         

      

      type Internal_Entity_Op_Not is record

               Node : aliased Bare_Op_Not;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Not : constant Internal_Entity_Op_Not;


      function Create_Internal_Entity_Op_Not
        (Node : Bare_Op_Not; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Not;


   


      function Trace_Image (R : Internal_Entity_Op_Not) return String;


         

      

      type Internal_Entity_Op_Not_In is record

               Node : aliased Bare_Op_Not_In;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Not_In : constant Internal_Entity_Op_Not_In;


      function Create_Internal_Entity_Op_Not_In
        (Node : Bare_Op_Not_In; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Not_In;


   


      function Trace_Image (R : Internal_Entity_Op_Not_In) return String;


         

      

      type Internal_Entity_Op_Or is record

               Node : aliased Bare_Op_Or;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Or : constant Internal_Entity_Op_Or;


      function Create_Internal_Entity_Op_Or
        (Node : Bare_Op_Or; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Or;


   


      function Trace_Image (R : Internal_Entity_Op_Or) return String;


         

      

      type Internal_Entity_Op_Or_Else is record

               Node : aliased Bare_Op_Or_Else;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Or_Else : constant Internal_Entity_Op_Or_Else;


      function Create_Internal_Entity_Op_Or_Else
        (Node : Bare_Op_Or_Else; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Or_Else;


   


      function Trace_Image (R : Internal_Entity_Op_Or_Else) return String;


         

      

      type Internal_Entity_Op_Plus is record

               Node : aliased Bare_Op_Plus;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Plus : constant Internal_Entity_Op_Plus;


      function Create_Internal_Entity_Op_Plus
        (Node : Bare_Op_Plus; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Plus;


   


      function Trace_Image (R : Internal_Entity_Op_Plus) return String;


         

      

      type Internal_Entity_Op_Pow is record

               Node : aliased Bare_Op_Pow;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Pow : constant Internal_Entity_Op_Pow;


      function Create_Internal_Entity_Op_Pow
        (Node : Bare_Op_Pow; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Pow;


   


      function Trace_Image (R : Internal_Entity_Op_Pow) return String;


         

      

      type Internal_Entity_Op_Rem is record

               Node : aliased Bare_Op_Rem;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Rem : constant Internal_Entity_Op_Rem;


      function Create_Internal_Entity_Op_Rem
        (Node : Bare_Op_Rem; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Rem;


   


      function Trace_Image (R : Internal_Entity_Op_Rem) return String;


         

      

      type Internal_Entity_Op_Xor is record

               Node : aliased Bare_Op_Xor;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Op_Xor : constant Internal_Entity_Op_Xor;


      function Create_Internal_Entity_Op_Xor
        (Node : Bare_Op_Xor; Info : Internal_Entity_Info)
         return Internal_Entity_Op_Xor;


   


      function Trace_Image (R : Internal_Entity_Op_Xor) return String;


         

      

      type Internal_Entity_Ordinary_Fixed_Point_Def is record

               Node : aliased Bare_Ordinary_Fixed_Point_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Ordinary_Fixed_Point_Def : constant Internal_Entity_Ordinary_Fixed_Point_Def;


      function Create_Internal_Entity_Ordinary_Fixed_Point_Def
        (Node : Bare_Ordinary_Fixed_Point_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Ordinary_Fixed_Point_Def;


   


      function Trace_Image (R : Internal_Entity_Ordinary_Fixed_Point_Def) return String;


         

      

      type Internal_Entity_Others_Designator is record

               Node : aliased Bare_Others_Designator;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Others_Designator : constant Internal_Entity_Others_Designator;


      function Create_Internal_Entity_Others_Designator
        (Node : Bare_Others_Designator; Info : Internal_Entity_Info)
         return Internal_Entity_Others_Designator;


   


      function Trace_Image (R : Internal_Entity_Others_Designator) return String;


         

      

      type Internal_Entity_Overriding_Node is record

               Node : aliased Bare_Overriding_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Overriding_Node : constant Internal_Entity_Overriding_Node;


      function Create_Internal_Entity_Overriding_Node
        (Node : Bare_Overriding_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Overriding_Node;


   


      function Trace_Image (R : Internal_Entity_Overriding_Node) return String;


         

      

      type Internal_Entity_Overriding_Not_Overriding is record

               Node : aliased Bare_Overriding_Not_Overriding;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Overriding_Not_Overriding : constant Internal_Entity_Overriding_Not_Overriding;


      function Create_Internal_Entity_Overriding_Not_Overriding
        (Node : Bare_Overriding_Not_Overriding; Info : Internal_Entity_Info)
         return Internal_Entity_Overriding_Not_Overriding;


   


      function Trace_Image (R : Internal_Entity_Overriding_Not_Overriding) return String;


         

      

      type Internal_Entity_Overriding_Overriding is record

               Node : aliased Bare_Overriding_Overriding;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Overriding_Overriding : constant Internal_Entity_Overriding_Overriding;


      function Create_Internal_Entity_Overriding_Overriding
        (Node : Bare_Overriding_Overriding; Info : Internal_Entity_Info)
         return Internal_Entity_Overriding_Overriding;


   


      function Trace_Image (R : Internal_Entity_Overriding_Overriding) return String;


         

      

      type Internal_Entity_Overriding_Unspecified is record

               Node : aliased Bare_Overriding_Unspecified;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Overriding_Unspecified : constant Internal_Entity_Overriding_Unspecified;


      function Create_Internal_Entity_Overriding_Unspecified
        (Node : Bare_Overriding_Unspecified; Info : Internal_Entity_Info)
         return Internal_Entity_Overriding_Unspecified;


   


      function Trace_Image (R : Internal_Entity_Overriding_Unspecified) return String;


         

      

      type Internal_Entity_Package_Body is record

               Node : aliased Bare_Package_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Package_Body : constant Internal_Entity_Package_Body;


      function Create_Internal_Entity_Package_Body
        (Node : Bare_Package_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Body;


   


      function Trace_Image (R : Internal_Entity_Package_Body) return String;


         

      

      type Internal_Entity_Package_Body_Stub is record

               Node : aliased Bare_Package_Body_Stub;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Package_Body_Stub : constant Internal_Entity_Package_Body_Stub;


      function Create_Internal_Entity_Package_Body_Stub
        (Node : Bare_Package_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Body_Stub;


   


      function Trace_Image (R : Internal_Entity_Package_Body_Stub) return String;


         

      

      type Internal_Entity_Package_Decl is record

               Node : aliased Bare_Package_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Package_Decl : constant Internal_Entity_Package_Decl;


      function Create_Internal_Entity_Package_Decl
        (Node : Bare_Package_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Decl;


   


      function Trace_Image (R : Internal_Entity_Package_Decl) return String;


         

      

      type Internal_Entity_Package_Renaming_Decl is record

               Node : aliased Bare_Package_Renaming_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Package_Renaming_Decl : constant Internal_Entity_Package_Renaming_Decl;


      function Create_Internal_Entity_Package_Renaming_Decl
        (Node : Bare_Package_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Package_Renaming_Decl;


   


      function Trace_Image (R : Internal_Entity_Package_Renaming_Decl) return String;


         

      

      type Internal_Entity_Param_Assoc is record

               Node : aliased Bare_Param_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Param_Assoc : constant Internal_Entity_Param_Assoc;


      function Create_Internal_Entity_Param_Assoc
        (Node : Bare_Param_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Param_Assoc;


   


      function Trace_Image (R : Internal_Entity_Param_Assoc) return String;


         

      

      type Internal_Entity_Param_Spec is record

               Node : aliased Bare_Param_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Param_Spec : constant Internal_Entity_Param_Spec;


      function Create_Internal_Entity_Param_Spec
        (Node : Bare_Param_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Param_Spec;


   


      function Trace_Image (R : Internal_Entity_Param_Spec) return String;


         

      

      type Internal_Entity_Param_Spec_List is record

               Node : aliased Bare_Param_Spec_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Param_Spec_List : constant Internal_Entity_Param_Spec_List;


      function Create_Internal_Entity_Param_Spec_List
        (Node : Bare_Param_Spec_List; Info : Internal_Entity_Info)
         return Internal_Entity_Param_Spec_List;


   


      function Trace_Image (R : Internal_Entity_Param_Spec_List) return String;


         

      

      type Internal_Entity_Params is record

               Node : aliased Bare_Params;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Params : constant Internal_Entity_Params;


      function Create_Internal_Entity_Params
        (Node : Bare_Params; Info : Internal_Entity_Info)
         return Internal_Entity_Params;


   


      function Trace_Image (R : Internal_Entity_Params) return String;


         

      

      type Internal_Entity_Paren_Abstract_State_Decl is record

               Node : aliased Bare_Paren_Abstract_State_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Paren_Abstract_State_Decl : constant Internal_Entity_Paren_Abstract_State_Decl;


      function Create_Internal_Entity_Paren_Abstract_State_Decl
        (Node : Bare_Paren_Abstract_State_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Paren_Abstract_State_Decl;


   


      function Trace_Image (R : Internal_Entity_Paren_Abstract_State_Decl) return String;


         

      

      type Internal_Entity_Paren_Expr is record

               Node : aliased Bare_Paren_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Paren_Expr : constant Internal_Entity_Paren_Expr;


      function Create_Internal_Entity_Paren_Expr
        (Node : Bare_Paren_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Paren_Expr;


   


      function Trace_Image (R : Internal_Entity_Paren_Expr) return String;


         

      

      type Internal_Entity_Parent_List is record

               Node : aliased Bare_Parent_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Parent_List : constant Internal_Entity_Parent_List;


      function Create_Internal_Entity_Parent_List
        (Node : Bare_Parent_List; Info : Internal_Entity_Info)
         return Internal_Entity_Parent_List;


   


      function Trace_Image (R : Internal_Entity_Parent_List) return String;


         

      

      type Internal_Entity_Pp_Directive is record

               Node : aliased Bare_Pp_Directive;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pp_Directive : constant Internal_Entity_Pp_Directive;


      function Create_Internal_Entity_Pp_Directive
        (Node : Bare_Pp_Directive; Info : Internal_Entity_Info)
         return Internal_Entity_Pp_Directive;


   


      function Trace_Image (R : Internal_Entity_Pp_Directive) return String;


         

      

      type Internal_Entity_Pp_Else_Directive is record

               Node : aliased Bare_Pp_Else_Directive;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pp_Else_Directive : constant Internal_Entity_Pp_Else_Directive;


      function Create_Internal_Entity_Pp_Else_Directive
        (Node : Bare_Pp_Else_Directive; Info : Internal_Entity_Info)
         return Internal_Entity_Pp_Else_Directive;


   


      function Trace_Image (R : Internal_Entity_Pp_Else_Directive) return String;


         

      

      type Internal_Entity_Pp_Elsif_Directive is record

               Node : aliased Bare_Pp_Elsif_Directive;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pp_Elsif_Directive : constant Internal_Entity_Pp_Elsif_Directive;


      function Create_Internal_Entity_Pp_Elsif_Directive
        (Node : Bare_Pp_Elsif_Directive; Info : Internal_Entity_Info)
         return Internal_Entity_Pp_Elsif_Directive;


   


      function Trace_Image (R : Internal_Entity_Pp_Elsif_Directive) return String;


         

      

      type Internal_Entity_Pp_End_If_Directive is record

               Node : aliased Bare_Pp_End_If_Directive;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pp_End_If_Directive : constant Internal_Entity_Pp_End_If_Directive;


      function Create_Internal_Entity_Pp_End_If_Directive
        (Node : Bare_Pp_End_If_Directive; Info : Internal_Entity_Info)
         return Internal_Entity_Pp_End_If_Directive;


   


      function Trace_Image (R : Internal_Entity_Pp_End_If_Directive) return String;


         

      

      type Internal_Entity_Pp_If_Directive is record

               Node : aliased Bare_Pp_If_Directive;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pp_If_Directive : constant Internal_Entity_Pp_If_Directive;


      function Create_Internal_Entity_Pp_If_Directive
        (Node : Bare_Pp_If_Directive; Info : Internal_Entity_Info)
         return Internal_Entity_Pp_If_Directive;


   


      function Trace_Image (R : Internal_Entity_Pp_If_Directive) return String;


         

      

      type Internal_Entity_Pp_Then_Kw is record

               Node : aliased Bare_Pp_Then_Kw;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pp_Then_Kw : constant Internal_Entity_Pp_Then_Kw;


      function Create_Internal_Entity_Pp_Then_Kw
        (Node : Bare_Pp_Then_Kw; Info : Internal_Entity_Info)
         return Internal_Entity_Pp_Then_Kw;


   


      function Trace_Image (R : Internal_Entity_Pp_Then_Kw) return String;


         

      

      type Internal_Entity_Pragma_Argument_Assoc is record

               Node : aliased Bare_Pragma_Argument_Assoc;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pragma_Argument_Assoc : constant Internal_Entity_Pragma_Argument_Assoc;


      function Create_Internal_Entity_Pragma_Argument_Assoc
        (Node : Bare_Pragma_Argument_Assoc; Info : Internal_Entity_Info)
         return Internal_Entity_Pragma_Argument_Assoc;


   


      function Trace_Image (R : Internal_Entity_Pragma_Argument_Assoc) return String;


         

      

      type Internal_Entity_Pragma_Node is record

               Node : aliased Bare_Pragma_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pragma_Node : constant Internal_Entity_Pragma_Node;


      function Create_Internal_Entity_Pragma_Node
        (Node : Bare_Pragma_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Pragma_Node;


   


      function Trace_Image (R : Internal_Entity_Pragma_Node) return String;


         

      

      type Internal_Entity_Pragma_Node_List is record

               Node : aliased Bare_Pragma_Node_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Pragma_Node_List : constant Internal_Entity_Pragma_Node_List;


      function Create_Internal_Entity_Pragma_Node_List
        (Node : Bare_Pragma_Node_List; Info : Internal_Entity_Info)
         return Internal_Entity_Pragma_Node_List;


   


      function Trace_Image (R : Internal_Entity_Pragma_Node_List) return String;


         

      

      type Internal_Entity_Private_Node is record

               Node : aliased Bare_Private_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Private_Node : constant Internal_Entity_Private_Node;


      function Create_Internal_Entity_Private_Node
        (Node : Bare_Private_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Node;


   


      function Trace_Image (R : Internal_Entity_Private_Node) return String;


         

      

      type Internal_Entity_Private_Absent is record

               Node : aliased Bare_Private_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Private_Absent : constant Internal_Entity_Private_Absent;


      function Create_Internal_Entity_Private_Absent
        (Node : Bare_Private_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Absent;


   


      function Trace_Image (R : Internal_Entity_Private_Absent) return String;


         

      

      type Internal_Entity_Private_Part is record

               Node : aliased Bare_Private_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Private_Part : constant Internal_Entity_Private_Part;


      function Create_Internal_Entity_Private_Part
        (Node : Bare_Private_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Part;


   


      function Trace_Image (R : Internal_Entity_Private_Part) return String;


         

      

      type Internal_Entity_Private_Present is record

               Node : aliased Bare_Private_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Private_Present : constant Internal_Entity_Private_Present;


      function Create_Internal_Entity_Private_Present
        (Node : Bare_Private_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Present;


   


      function Trace_Image (R : Internal_Entity_Private_Present) return String;


         

      

      type Internal_Entity_Private_Type_Def is record

               Node : aliased Bare_Private_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Private_Type_Def : constant Internal_Entity_Private_Type_Def;


      function Create_Internal_Entity_Private_Type_Def
        (Node : Bare_Private_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Private_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Private_Type_Def) return String;


         

      

      type Internal_Entity_Protected_Node is record

               Node : aliased Bare_Protected_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Protected_Node : constant Internal_Entity_Protected_Node;


      function Create_Internal_Entity_Protected_Node
        (Node : Bare_Protected_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Node;


   


      function Trace_Image (R : Internal_Entity_Protected_Node) return String;


         

      

      type Internal_Entity_Protected_Absent is record

               Node : aliased Bare_Protected_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Protected_Absent : constant Internal_Entity_Protected_Absent;


      function Create_Internal_Entity_Protected_Absent
        (Node : Bare_Protected_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Absent;


   


      function Trace_Image (R : Internal_Entity_Protected_Absent) return String;


         

      

      type Internal_Entity_Protected_Body is record

               Node : aliased Bare_Protected_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Protected_Body : constant Internal_Entity_Protected_Body;


      function Create_Internal_Entity_Protected_Body
        (Node : Bare_Protected_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Body;


   


      function Trace_Image (R : Internal_Entity_Protected_Body) return String;


         

      

      type Internal_Entity_Protected_Body_Stub is record

               Node : aliased Bare_Protected_Body_Stub;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Protected_Body_Stub : constant Internal_Entity_Protected_Body_Stub;


      function Create_Internal_Entity_Protected_Body_Stub
        (Node : Bare_Protected_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Body_Stub;


   


      function Trace_Image (R : Internal_Entity_Protected_Body_Stub) return String;


         

      

      type Internal_Entity_Protected_Def is record

               Node : aliased Bare_Protected_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Protected_Def : constant Internal_Entity_Protected_Def;


      function Create_Internal_Entity_Protected_Def
        (Node : Bare_Protected_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Def;


   


      function Trace_Image (R : Internal_Entity_Protected_Def) return String;


         

      

      type Internal_Entity_Protected_Present is record

               Node : aliased Bare_Protected_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Protected_Present : constant Internal_Entity_Protected_Present;


      function Create_Internal_Entity_Protected_Present
        (Node : Bare_Protected_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Present;


   


      function Trace_Image (R : Internal_Entity_Protected_Present) return String;


         

      

      type Internal_Entity_Protected_Type_Decl is record

               Node : aliased Bare_Protected_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Protected_Type_Decl : constant Internal_Entity_Protected_Type_Decl;


      function Create_Internal_Entity_Protected_Type_Decl
        (Node : Bare_Protected_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Protected_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Protected_Type_Decl) return String;


         

      

      type Internal_Entity_Public_Part is record

               Node : aliased Bare_Public_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Public_Part : constant Internal_Entity_Public_Part;


      function Create_Internal_Entity_Public_Part
        (Node : Bare_Public_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Public_Part;


   


      function Trace_Image (R : Internal_Entity_Public_Part) return String;


         

      

      type Internal_Entity_Qual_Expr is record

               Node : aliased Bare_Qual_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Qual_Expr : constant Internal_Entity_Qual_Expr;


      function Create_Internal_Entity_Qual_Expr
        (Node : Bare_Qual_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Qual_Expr;


   


      function Trace_Image (R : Internal_Entity_Qual_Expr) return String;


         

      

      type Internal_Entity_Quantified_Expr is record

               Node : aliased Bare_Quantified_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Quantified_Expr : constant Internal_Entity_Quantified_Expr;


      function Create_Internal_Entity_Quantified_Expr
        (Node : Bare_Quantified_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Quantified_Expr;


   


      function Trace_Image (R : Internal_Entity_Quantified_Expr) return String;


         

      

      type Internal_Entity_Quantifier is record

               Node : aliased Bare_Quantifier;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Quantifier : constant Internal_Entity_Quantifier;


      function Create_Internal_Entity_Quantifier
        (Node : Bare_Quantifier; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier;


   


      function Trace_Image (R : Internal_Entity_Quantifier) return String;


         

      

      type Internal_Entity_Quantifier_All is record

               Node : aliased Bare_Quantifier_All;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Quantifier_All : constant Internal_Entity_Quantifier_All;


      function Create_Internal_Entity_Quantifier_All
        (Node : Bare_Quantifier_All; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier_All;


   


      function Trace_Image (R : Internal_Entity_Quantifier_All) return String;


         

      

      type Internal_Entity_Quantifier_Some is record

               Node : aliased Bare_Quantifier_Some;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Quantifier_Some : constant Internal_Entity_Quantifier_Some;


      function Create_Internal_Entity_Quantifier_Some
        (Node : Bare_Quantifier_Some; Info : Internal_Entity_Info)
         return Internal_Entity_Quantifier_Some;


   


      function Trace_Image (R : Internal_Entity_Quantifier_Some) return String;


         

      

      type Internal_Entity_Raise_Expr is record

               Node : aliased Bare_Raise_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Raise_Expr : constant Internal_Entity_Raise_Expr;


      function Create_Internal_Entity_Raise_Expr
        (Node : Bare_Raise_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Raise_Expr;


   


      function Trace_Image (R : Internal_Entity_Raise_Expr) return String;


         

      

      type Internal_Entity_Raise_Stmt is record

               Node : aliased Bare_Raise_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Raise_Stmt : constant Internal_Entity_Raise_Stmt;


      function Create_Internal_Entity_Raise_Stmt
        (Node : Bare_Raise_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Raise_Stmt;


   


      function Trace_Image (R : Internal_Entity_Raise_Stmt) return String;


         

      

      type Internal_Entity_Range_Constraint is record

               Node : aliased Bare_Range_Constraint;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Range_Constraint : constant Internal_Entity_Range_Constraint;


      function Create_Internal_Entity_Range_Constraint
        (Node : Bare_Range_Constraint; Info : Internal_Entity_Info)
         return Internal_Entity_Range_Constraint;


   


      function Trace_Image (R : Internal_Entity_Range_Constraint) return String;


         

      

      type Internal_Entity_Range_Spec is record

               Node : aliased Bare_Range_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Range_Spec : constant Internal_Entity_Range_Spec;


      function Create_Internal_Entity_Range_Spec
        (Node : Bare_Range_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Range_Spec;


   


      function Trace_Image (R : Internal_Entity_Range_Spec) return String;


         

      

      type Internal_Entity_Real_Literal is record

               Node : aliased Bare_Real_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Real_Literal : constant Internal_Entity_Real_Literal;


      function Create_Internal_Entity_Real_Literal
        (Node : Bare_Real_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_Real_Literal;


   


      function Trace_Image (R : Internal_Entity_Real_Literal) return String;


         

      

      type Internal_Entity_Record_Def is record

               Node : aliased Bare_Record_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Record_Def : constant Internal_Entity_Record_Def;


      function Create_Internal_Entity_Record_Def
        (Node : Bare_Record_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Record_Def;


   


      function Trace_Image (R : Internal_Entity_Record_Def) return String;


         

      

      type Internal_Entity_Record_Rep_Clause is record

               Node : aliased Bare_Record_Rep_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Record_Rep_Clause : constant Internal_Entity_Record_Rep_Clause;


      function Create_Internal_Entity_Record_Rep_Clause
        (Node : Bare_Record_Rep_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Record_Rep_Clause;


   


      function Trace_Image (R : Internal_Entity_Record_Rep_Clause) return String;


         

      

      type Internal_Entity_Record_Type_Def is record

               Node : aliased Bare_Record_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Record_Type_Def : constant Internal_Entity_Record_Type_Def;


      function Create_Internal_Entity_Record_Type_Def
        (Node : Bare_Record_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Record_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Record_Type_Def) return String;


         

      

      type Internal_Entity_Reduce_Attribute_Ref is record

               Node : aliased Bare_Reduce_Attribute_Ref;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Reduce_Attribute_Ref : constant Internal_Entity_Reduce_Attribute_Ref;


      function Create_Internal_Entity_Reduce_Attribute_Ref
        (Node : Bare_Reduce_Attribute_Ref; Info : Internal_Entity_Info)
         return Internal_Entity_Reduce_Attribute_Ref;


   


      function Trace_Image (R : Internal_Entity_Reduce_Attribute_Ref) return String;


         

      

      type Internal_Entity_Relation_Op is record

               Node : aliased Bare_Relation_Op;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Relation_Op : constant Internal_Entity_Relation_Op;


      function Create_Internal_Entity_Relation_Op
        (Node : Bare_Relation_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Relation_Op;


   


      function Trace_Image (R : Internal_Entity_Relation_Op) return String;


         

      

      type Internal_Entity_Renaming_Clause is record

               Node : aliased Bare_Renaming_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Renaming_Clause : constant Internal_Entity_Renaming_Clause;


      function Create_Internal_Entity_Renaming_Clause
        (Node : Bare_Renaming_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Renaming_Clause;


   


      function Trace_Image (R : Internal_Entity_Renaming_Clause) return String;


         

      

      type Internal_Entity_Requeue_Stmt is record

               Node : aliased Bare_Requeue_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Requeue_Stmt : constant Internal_Entity_Requeue_Stmt;


      function Create_Internal_Entity_Requeue_Stmt
        (Node : Bare_Requeue_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Requeue_Stmt;


   


      function Trace_Image (R : Internal_Entity_Requeue_Stmt) return String;


         

      

      type Internal_Entity_Return_Stmt is record

               Node : aliased Bare_Return_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Return_Stmt : constant Internal_Entity_Return_Stmt;


      function Create_Internal_Entity_Return_Stmt
        (Node : Bare_Return_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Return_Stmt;


   


      function Trace_Image (R : Internal_Entity_Return_Stmt) return String;


         

      

      type Internal_Entity_Reverse_Node is record

               Node : aliased Bare_Reverse_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Reverse_Node : constant Internal_Entity_Reverse_Node;


      function Create_Internal_Entity_Reverse_Node
        (Node : Bare_Reverse_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Reverse_Node;


   


      function Trace_Image (R : Internal_Entity_Reverse_Node) return String;


         

      

      type Internal_Entity_Reverse_Absent is record

               Node : aliased Bare_Reverse_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Reverse_Absent : constant Internal_Entity_Reverse_Absent;


      function Create_Internal_Entity_Reverse_Absent
        (Node : Bare_Reverse_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Reverse_Absent;


   


      function Trace_Image (R : Internal_Entity_Reverse_Absent) return String;


         

      

      type Internal_Entity_Reverse_Present is record

               Node : aliased Bare_Reverse_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Reverse_Present : constant Internal_Entity_Reverse_Present;


      function Create_Internal_Entity_Reverse_Present
        (Node : Bare_Reverse_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Reverse_Present;


   


      function Trace_Image (R : Internal_Entity_Reverse_Present) return String;


         

      

      type Internal_Entity_Select_Stmt is record

               Node : aliased Bare_Select_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Select_Stmt : constant Internal_Entity_Select_Stmt;


      function Create_Internal_Entity_Select_Stmt
        (Node : Bare_Select_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_Select_Stmt;


   


      function Trace_Image (R : Internal_Entity_Select_Stmt) return String;


         

      

      type Internal_Entity_Select_When_Part is record

               Node : aliased Bare_Select_When_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Select_When_Part : constant Internal_Entity_Select_When_Part;


      function Create_Internal_Entity_Select_When_Part
        (Node : Bare_Select_When_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Select_When_Part;


   


      function Trace_Image (R : Internal_Entity_Select_When_Part) return String;


         

      

      type Internal_Entity_Select_When_Part_List is record

               Node : aliased Bare_Select_When_Part_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Select_When_Part_List : constant Internal_Entity_Select_When_Part_List;


      function Create_Internal_Entity_Select_When_Part_List
        (Node : Bare_Select_When_Part_List; Info : Internal_Entity_Info)
         return Internal_Entity_Select_When_Part_List;


   


      function Trace_Image (R : Internal_Entity_Select_When_Part_List) return String;


         

      

      type Internal_Entity_Signed_Int_Type_Def is record

               Node : aliased Bare_Signed_Int_Type_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Signed_Int_Type_Def : constant Internal_Entity_Signed_Int_Type_Def;


      function Create_Internal_Entity_Signed_Int_Type_Def
        (Node : Bare_Signed_Int_Type_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Signed_Int_Type_Def;


   


      function Trace_Image (R : Internal_Entity_Signed_Int_Type_Def) return String;


         

      

      type Internal_Entity_Single_Protected_Decl is record

               Node : aliased Bare_Single_Protected_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Single_Protected_Decl : constant Internal_Entity_Single_Protected_Decl;


      function Create_Internal_Entity_Single_Protected_Decl
        (Node : Bare_Single_Protected_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Single_Protected_Decl;


   


      function Trace_Image (R : Internal_Entity_Single_Protected_Decl) return String;


         

      

      type Internal_Entity_Single_Task_Decl is record

               Node : aliased Bare_Single_Task_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Single_Task_Decl : constant Internal_Entity_Single_Task_Decl;


      function Create_Internal_Entity_Single_Task_Decl
        (Node : Bare_Single_Task_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Single_Task_Decl;


   


      function Trace_Image (R : Internal_Entity_Single_Task_Decl) return String;


         

      

      type Internal_Entity_Task_Type_Decl is record

               Node : aliased Bare_Task_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Task_Type_Decl : constant Internal_Entity_Task_Type_Decl;


      function Create_Internal_Entity_Task_Type_Decl
        (Node : Bare_Task_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Task_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Task_Type_Decl) return String;


         

      

      type Internal_Entity_Single_Task_Type_Decl is record

               Node : aliased Bare_Single_Task_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Single_Task_Type_Decl : constant Internal_Entity_Single_Task_Type_Decl;


      function Create_Internal_Entity_Single_Task_Type_Decl
        (Node : Bare_Single_Task_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Single_Task_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Single_Task_Type_Decl) return String;


         

      

      type Internal_Entity_Stmt_List is record

               Node : aliased Bare_Stmt_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Stmt_List : constant Internal_Entity_Stmt_List;


      function Create_Internal_Entity_Stmt_List
        (Node : Bare_Stmt_List; Info : Internal_Entity_Info)
         return Internal_Entity_Stmt_List;


   


      function Trace_Image (R : Internal_Entity_Stmt_List) return String;


         

      

      type Internal_Entity_String_Literal is record

               Node : aliased Bare_String_Literal;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_String_Literal : constant Internal_Entity_String_Literal;


      function Create_Internal_Entity_String_Literal
        (Node : Bare_String_Literal; Info : Internal_Entity_Info)
         return Internal_Entity_String_Literal;


   


      function Trace_Image (R : Internal_Entity_String_Literal) return String;


         

      

      type Internal_Entity_Subp_Body is record

               Node : aliased Bare_Subp_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subp_Body : constant Internal_Entity_Subp_Body;


      function Create_Internal_Entity_Subp_Body
        (Node : Bare_Subp_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Body;


   


      function Trace_Image (R : Internal_Entity_Subp_Body) return String;


         

      

      type Internal_Entity_Subp_Body_Stub is record

               Node : aliased Bare_Subp_Body_Stub;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subp_Body_Stub : constant Internal_Entity_Subp_Body_Stub;


      function Create_Internal_Entity_Subp_Body_Stub
        (Node : Bare_Subp_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Body_Stub;


   


      function Trace_Image (R : Internal_Entity_Subp_Body_Stub) return String;


         

      

      type Internal_Entity_Subp_Decl is record

               Node : aliased Bare_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subp_Decl : constant Internal_Entity_Subp_Decl;


      function Create_Internal_Entity_Subp_Decl
        (Node : Bare_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Subp_Decl) return String;


         

      

      type Internal_Entity_Subp_Kind is record

               Node : aliased Bare_Subp_Kind;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subp_Kind : constant Internal_Entity_Subp_Kind;


      function Create_Internal_Entity_Subp_Kind
        (Node : Bare_Subp_Kind; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Kind;


   


      function Trace_Image (R : Internal_Entity_Subp_Kind) return String;


         

      

      type Internal_Entity_Subp_Kind_Function is record

               Node : aliased Bare_Subp_Kind_Function;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subp_Kind_Function : constant Internal_Entity_Subp_Kind_Function;


      function Create_Internal_Entity_Subp_Kind_Function
        (Node : Bare_Subp_Kind_Function; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Kind_Function;


   


      function Trace_Image (R : Internal_Entity_Subp_Kind_Function) return String;


         

      

      type Internal_Entity_Subp_Kind_Procedure is record

               Node : aliased Bare_Subp_Kind_Procedure;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subp_Kind_Procedure : constant Internal_Entity_Subp_Kind_Procedure;


      function Create_Internal_Entity_Subp_Kind_Procedure
        (Node : Bare_Subp_Kind_Procedure; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Kind_Procedure;


   


      function Trace_Image (R : Internal_Entity_Subp_Kind_Procedure) return String;


         

      

      type Internal_Entity_Subp_Renaming_Decl is record

               Node : aliased Bare_Subp_Renaming_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subp_Renaming_Decl : constant Internal_Entity_Subp_Renaming_Decl;


      function Create_Internal_Entity_Subp_Renaming_Decl
        (Node : Bare_Subp_Renaming_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Renaming_Decl;


   


      function Trace_Image (R : Internal_Entity_Subp_Renaming_Decl) return String;


         

      

      type Internal_Entity_Subp_Spec is record

               Node : aliased Bare_Subp_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subp_Spec : constant Internal_Entity_Subp_Spec;


      function Create_Internal_Entity_Subp_Spec
        (Node : Bare_Subp_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Subp_Spec;


   


      function Trace_Image (R : Internal_Entity_Subp_Spec) return String;


         

      

      type Internal_Entity_Subtype_Decl is record

               Node : aliased Bare_Subtype_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subtype_Decl : constant Internal_Entity_Subtype_Decl;


      function Create_Internal_Entity_Subtype_Decl
        (Node : Bare_Subtype_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Subtype_Decl;


   


      function Trace_Image (R : Internal_Entity_Subtype_Decl) return String;


         

      

      type Internal_Entity_Subunit is record

               Node : aliased Bare_Subunit;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Subunit : constant Internal_Entity_Subunit;


      function Create_Internal_Entity_Subunit
        (Node : Bare_Subunit; Info : Internal_Entity_Info)
         return Internal_Entity_Subunit;


   


      function Trace_Image (R : Internal_Entity_Subunit) return String;


         

      

      type Internal_Entity_Synchronized_Node is record

               Node : aliased Bare_Synchronized_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synchronized_Node : constant Internal_Entity_Synchronized_Node;


      function Create_Internal_Entity_Synchronized_Node
        (Node : Bare_Synchronized_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Synchronized_Node;


   


      function Trace_Image (R : Internal_Entity_Synchronized_Node) return String;


         

      

      type Internal_Entity_Synchronized_Absent is record

               Node : aliased Bare_Synchronized_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synchronized_Absent : constant Internal_Entity_Synchronized_Absent;


      function Create_Internal_Entity_Synchronized_Absent
        (Node : Bare_Synchronized_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Synchronized_Absent;


   


      function Trace_Image (R : Internal_Entity_Synchronized_Absent) return String;


         

      

      type Internal_Entity_Synchronized_Present is record

               Node : aliased Bare_Synchronized_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synchronized_Present : constant Internal_Entity_Synchronized_Present;


      function Create_Internal_Entity_Synchronized_Present
        (Node : Bare_Synchronized_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Synchronized_Present;


   


      function Trace_Image (R : Internal_Entity_Synchronized_Present) return String;


         

      

      type Internal_Entity_Synth_Anonymous_Type_Decl is record

               Node : aliased Bare_Synth_Anonymous_Type_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synth_Anonymous_Type_Decl : constant Internal_Entity_Synth_Anonymous_Type_Decl;


      function Create_Internal_Entity_Synth_Anonymous_Type_Decl
        (Node : Bare_Synth_Anonymous_Type_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Synth_Anonymous_Type_Decl;


   


      function Trace_Image (R : Internal_Entity_Synth_Anonymous_Type_Decl) return String;


         

      

      type Internal_Entity_Synthetic_Binary_Spec is record

               Node : aliased Bare_Synthetic_Binary_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Binary_Spec : constant Internal_Entity_Synthetic_Binary_Spec;


      function Create_Internal_Entity_Synthetic_Binary_Spec
        (Node : Bare_Synthetic_Binary_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Binary_Spec;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Binary_Spec) return String;


         

      

      type Internal_Entity_Synthetic_Char_Enum_Lit is record

               Node : aliased Bare_Synthetic_Char_Enum_Lit;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Char_Enum_Lit : constant Internal_Entity_Synthetic_Char_Enum_Lit;


      function Create_Internal_Entity_Synthetic_Char_Enum_Lit
        (Node : Bare_Synthetic_Char_Enum_Lit; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Char_Enum_Lit;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Char_Enum_Lit) return String;


         

      

      type Internal_Entity_Synthetic_Defining_Name is record

               Node : aliased Bare_Synthetic_Defining_Name;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Defining_Name : constant Internal_Entity_Synthetic_Defining_Name;


      function Create_Internal_Entity_Synthetic_Defining_Name
        (Node : Bare_Synthetic_Defining_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Defining_Name;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Defining_Name) return String;


         

      

      type Internal_Entity_Synthetic_Formal_Param_Decl is record

               Node : aliased Bare_Synthetic_Formal_Param_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Formal_Param_Decl : constant Internal_Entity_Synthetic_Formal_Param_Decl;


      function Create_Internal_Entity_Synthetic_Formal_Param_Decl
        (Node : Bare_Synthetic_Formal_Param_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Formal_Param_Decl;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Formal_Param_Decl) return String;


         

      

      type Internal_Entity_Synthetic_Identifier is record

               Node : aliased Bare_Synthetic_Identifier;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Identifier : constant Internal_Entity_Synthetic_Identifier;


      function Create_Internal_Entity_Synthetic_Identifier
        (Node : Bare_Synthetic_Identifier; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Identifier;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Identifier) return String;


         

      

      type Internal_Entity_Synthetic_Renaming_Clause is record

               Node : aliased Bare_Synthetic_Renaming_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Renaming_Clause : constant Internal_Entity_Synthetic_Renaming_Clause;


      function Create_Internal_Entity_Synthetic_Renaming_Clause
        (Node : Bare_Synthetic_Renaming_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Renaming_Clause;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Renaming_Clause) return String;


         

      

      type Internal_Entity_Synthetic_Subp_Decl is record

               Node : aliased Bare_Synthetic_Subp_Decl;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Subp_Decl : constant Internal_Entity_Synthetic_Subp_Decl;


      function Create_Internal_Entity_Synthetic_Subp_Decl
        (Node : Bare_Synthetic_Subp_Decl; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Subp_Decl;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Subp_Decl) return String;


         

      

      type Internal_Entity_Synthetic_Type_Expr is record

               Node : aliased Bare_Synthetic_Type_Expr;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Type_Expr : constant Internal_Entity_Synthetic_Type_Expr;


      function Create_Internal_Entity_Synthetic_Type_Expr
        (Node : Bare_Synthetic_Type_Expr; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Type_Expr;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Type_Expr) return String;


         

      

      type Internal_Entity_Synthetic_Unary_Spec is record

               Node : aliased Bare_Synthetic_Unary_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Synthetic_Unary_Spec : constant Internal_Entity_Synthetic_Unary_Spec;


      function Create_Internal_Entity_Synthetic_Unary_Spec
        (Node : Bare_Synthetic_Unary_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_Synthetic_Unary_Spec;


   


      function Trace_Image (R : Internal_Entity_Synthetic_Unary_Spec) return String;


         

      

      type Internal_Entity_Tagged_Node is record

               Node : aliased Bare_Tagged_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Tagged_Node : constant Internal_Entity_Tagged_Node;


      function Create_Internal_Entity_Tagged_Node
        (Node : Bare_Tagged_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Tagged_Node;


   


      function Trace_Image (R : Internal_Entity_Tagged_Node) return String;


         

      

      type Internal_Entity_Tagged_Absent is record

               Node : aliased Bare_Tagged_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Tagged_Absent : constant Internal_Entity_Tagged_Absent;


      function Create_Internal_Entity_Tagged_Absent
        (Node : Bare_Tagged_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Tagged_Absent;


   


      function Trace_Image (R : Internal_Entity_Tagged_Absent) return String;


         

      

      type Internal_Entity_Tagged_Present is record

               Node : aliased Bare_Tagged_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Tagged_Present : constant Internal_Entity_Tagged_Present;


      function Create_Internal_Entity_Tagged_Present
        (Node : Bare_Tagged_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Tagged_Present;


   


      function Trace_Image (R : Internal_Entity_Tagged_Present) return String;


         

      

      type Internal_Entity_Target_Name is record

               Node : aliased Bare_Target_Name;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Target_Name : constant Internal_Entity_Target_Name;


      function Create_Internal_Entity_Target_Name
        (Node : Bare_Target_Name; Info : Internal_Entity_Info)
         return Internal_Entity_Target_Name;


   


      function Trace_Image (R : Internal_Entity_Target_Name) return String;


         

      

      type Internal_Entity_Task_Body is record

               Node : aliased Bare_Task_Body;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Task_Body : constant Internal_Entity_Task_Body;


      function Create_Internal_Entity_Task_Body
        (Node : Bare_Task_Body; Info : Internal_Entity_Info)
         return Internal_Entity_Task_Body;


   


      function Trace_Image (R : Internal_Entity_Task_Body) return String;


         

      

      type Internal_Entity_Task_Body_Stub is record

               Node : aliased Bare_Task_Body_Stub;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Task_Body_Stub : constant Internal_Entity_Task_Body_Stub;


      function Create_Internal_Entity_Task_Body_Stub
        (Node : Bare_Task_Body_Stub; Info : Internal_Entity_Info)
         return Internal_Entity_Task_Body_Stub;


   


      function Trace_Image (R : Internal_Entity_Task_Body_Stub) return String;


         

      

      type Internal_Entity_Task_Def is record

               Node : aliased Bare_Task_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Task_Def : constant Internal_Entity_Task_Def;


      function Create_Internal_Entity_Task_Def
        (Node : Bare_Task_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Task_Def;


   


      function Trace_Image (R : Internal_Entity_Task_Def) return String;


         

      

      type Internal_Entity_Terminate_Alternative is record

               Node : aliased Bare_Terminate_Alternative;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Terminate_Alternative : constant Internal_Entity_Terminate_Alternative;


      function Create_Internal_Entity_Terminate_Alternative
        (Node : Bare_Terminate_Alternative; Info : Internal_Entity_Info)
         return Internal_Entity_Terminate_Alternative;


   


      function Trace_Image (R : Internal_Entity_Terminate_Alternative) return String;


         

      

      type Internal_Entity_Type_Access_Def is record

               Node : aliased Bare_Type_Access_Def;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Access_Def : constant Internal_Entity_Type_Access_Def;


      function Create_Internal_Entity_Type_Access_Def
        (Node : Bare_Type_Access_Def; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Access_Def;


   


      function Trace_Image (R : Internal_Entity_Type_Access_Def) return String;


         

      

      type Internal_Entity_Type_Attributes_Repository is record

               Node : aliased Bare_Type_Attributes_Repository;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Type_Attributes_Repository : constant Internal_Entity_Type_Attributes_Repository;


      function Create_Internal_Entity_Type_Attributes_Repository
        (Node : Bare_Type_Attributes_Repository; Info : Internal_Entity_Info)
         return Internal_Entity_Type_Attributes_Repository;


   


      function Trace_Image (R : Internal_Entity_Type_Attributes_Repository) return String;


         

      

      type Internal_Entity_Un_Op is record

               Node : aliased Bare_Un_Op;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Un_Op : constant Internal_Entity_Un_Op;


      function Create_Internal_Entity_Un_Op
        (Node : Bare_Un_Op; Info : Internal_Entity_Info)
         return Internal_Entity_Un_Op;


   


      function Trace_Image (R : Internal_Entity_Un_Op) return String;


         

      

      type Internal_Entity_Unconstrained_Array_Index is record

               Node : aliased Bare_Unconstrained_Array_Index;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Unconstrained_Array_Index : constant Internal_Entity_Unconstrained_Array_Index;


      function Create_Internal_Entity_Unconstrained_Array_Index
        (Node : Bare_Unconstrained_Array_Index; Info : Internal_Entity_Info)
         return Internal_Entity_Unconstrained_Array_Index;


   


      function Trace_Image (R : Internal_Entity_Unconstrained_Array_Index) return String;


         

      

      type Internal_Entity_Unconstrained_Array_Index_List is record

               Node : aliased Bare_Unconstrained_Array_Index_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Unconstrained_Array_Index_List : constant Internal_Entity_Unconstrained_Array_Index_List;


      function Create_Internal_Entity_Unconstrained_Array_Index_List
        (Node : Bare_Unconstrained_Array_Index_List; Info : Internal_Entity_Info)
         return Internal_Entity_Unconstrained_Array_Index_List;


   


      function Trace_Image (R : Internal_Entity_Unconstrained_Array_Index_List) return String;


         

      

      type Internal_Entity_Unconstrained_Array_Indices is record

               Node : aliased Bare_Unconstrained_Array_Indices;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Unconstrained_Array_Indices : constant Internal_Entity_Unconstrained_Array_Indices;


      function Create_Internal_Entity_Unconstrained_Array_Indices
        (Node : Bare_Unconstrained_Array_Indices; Info : Internal_Entity_Info)
         return Internal_Entity_Unconstrained_Array_Indices;


   


      function Trace_Image (R : Internal_Entity_Unconstrained_Array_Indices) return String;


         

      

      type Internal_Entity_Unknown_Discriminant_Part is record

               Node : aliased Bare_Unknown_Discriminant_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Unknown_Discriminant_Part : constant Internal_Entity_Unknown_Discriminant_Part;


      function Create_Internal_Entity_Unknown_Discriminant_Part
        (Node : Bare_Unknown_Discriminant_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Unknown_Discriminant_Part;


   


      function Trace_Image (R : Internal_Entity_Unknown_Discriminant_Part) return String;


         

      

      type Internal_Entity_Until_Node is record

               Node : aliased Bare_Until_Node;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Until_Node : constant Internal_Entity_Until_Node;


      function Create_Internal_Entity_Until_Node
        (Node : Bare_Until_Node; Info : Internal_Entity_Info)
         return Internal_Entity_Until_Node;


   


      function Trace_Image (R : Internal_Entity_Until_Node) return String;


         

      

      type Internal_Entity_Until_Absent is record

               Node : aliased Bare_Until_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Until_Absent : constant Internal_Entity_Until_Absent;


      function Create_Internal_Entity_Until_Absent
        (Node : Bare_Until_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_Until_Absent;


   


      function Trace_Image (R : Internal_Entity_Until_Absent) return String;


         

      

      type Internal_Entity_Until_Present is record

               Node : aliased Bare_Until_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Until_Present : constant Internal_Entity_Until_Present;


      function Create_Internal_Entity_Until_Present
        (Node : Bare_Until_Present; Info : Internal_Entity_Info)
         return Internal_Entity_Until_Present;


   


      function Trace_Image (R : Internal_Entity_Until_Present) return String;


         

      

      type Internal_Entity_Update_Attribute_Ref is record

               Node : aliased Bare_Update_Attribute_Ref;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Update_Attribute_Ref : constant Internal_Entity_Update_Attribute_Ref;


      function Create_Internal_Entity_Update_Attribute_Ref
        (Node : Bare_Update_Attribute_Ref; Info : Internal_Entity_Info)
         return Internal_Entity_Update_Attribute_Ref;


   


      function Trace_Image (R : Internal_Entity_Update_Attribute_Ref) return String;


         

      

      type Internal_Entity_Use_Clause is record

               Node : aliased Bare_Use_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Use_Clause : constant Internal_Entity_Use_Clause;


      function Create_Internal_Entity_Use_Clause
        (Node : Bare_Use_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Use_Clause;


   


      function Trace_Image (R : Internal_Entity_Use_Clause) return String;


         

      

      type Internal_Entity_Use_Package_Clause is record

               Node : aliased Bare_Use_Package_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Use_Package_Clause : constant Internal_Entity_Use_Package_Clause;


      function Create_Internal_Entity_Use_Package_Clause
        (Node : Bare_Use_Package_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Use_Package_Clause;


   


      function Trace_Image (R : Internal_Entity_Use_Package_Clause) return String;


         

      

      type Internal_Entity_Use_Type_Clause is record

               Node : aliased Bare_Use_Type_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Use_Type_Clause : constant Internal_Entity_Use_Type_Clause;


      function Create_Internal_Entity_Use_Type_Clause
        (Node : Bare_Use_Type_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_Use_Type_Clause;


   


      function Trace_Image (R : Internal_Entity_Use_Type_Clause) return String;


         

      

      type Internal_Entity_Value_Sequence is record

               Node : aliased Bare_Value_Sequence;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Value_Sequence : constant Internal_Entity_Value_Sequence;


      function Create_Internal_Entity_Value_Sequence
        (Node : Bare_Value_Sequence; Info : Internal_Entity_Info)
         return Internal_Entity_Value_Sequence;


   


      function Trace_Image (R : Internal_Entity_Value_Sequence) return String;


         

      

      type Internal_Entity_Variant is record

               Node : aliased Bare_Variant;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Variant : constant Internal_Entity_Variant;


      function Create_Internal_Entity_Variant
        (Node : Bare_Variant; Info : Internal_Entity_Info)
         return Internal_Entity_Variant;


   


      function Trace_Image (R : Internal_Entity_Variant) return String;


         

      

      type Internal_Entity_Variant_List is record

               Node : aliased Bare_Variant_List;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Variant_List : constant Internal_Entity_Variant_List;


      function Create_Internal_Entity_Variant_List
        (Node : Bare_Variant_List; Info : Internal_Entity_Info)
         return Internal_Entity_Variant_List;


   


      function Trace_Image (R : Internal_Entity_Variant_List) return String;


         

      

      type Internal_Entity_Variant_Part is record

               Node : aliased Bare_Variant_Part;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_Variant_Part : constant Internal_Entity_Variant_Part;


      function Create_Internal_Entity_Variant_Part
        (Node : Bare_Variant_Part; Info : Internal_Entity_Info)
         return Internal_Entity_Variant_Part;


   


      function Trace_Image (R : Internal_Entity_Variant_Part) return String;


         

      

      type Internal_Entity_While_Loop_Spec is record

               Node : aliased Bare_While_Loop_Spec;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_While_Loop_Spec : constant Internal_Entity_While_Loop_Spec;


      function Create_Internal_Entity_While_Loop_Spec
        (Node : Bare_While_Loop_Spec; Info : Internal_Entity_Info)
         return Internal_Entity_While_Loop_Spec;


   


      function Trace_Image (R : Internal_Entity_While_Loop_Spec) return String;


         

      

      type Internal_Entity_While_Loop_Stmt is record

               Node : aliased Bare_While_Loop_Stmt;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_While_Loop_Stmt : constant Internal_Entity_While_Loop_Stmt;


      function Create_Internal_Entity_While_Loop_Stmt
        (Node : Bare_While_Loop_Stmt; Info : Internal_Entity_Info)
         return Internal_Entity_While_Loop_Stmt;


   


      function Trace_Image (R : Internal_Entity_While_Loop_Stmt) return String;


         

      

      type Internal_Entity_With_Clause is record

               Node : aliased Bare_With_Clause;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_With_Clause : constant Internal_Entity_With_Clause;


      function Create_Internal_Entity_With_Clause
        (Node : Bare_With_Clause; Info : Internal_Entity_Info)
         return Internal_Entity_With_Clause;


   


      function Trace_Image (R : Internal_Entity_With_Clause) return String;


         

      

      type Internal_Entity_With_Private is record

               Node : aliased Bare_With_Private;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_With_Private : constant Internal_Entity_With_Private;


      function Create_Internal_Entity_With_Private
        (Node : Bare_With_Private; Info : Internal_Entity_Info)
         return Internal_Entity_With_Private;


   


      function Trace_Image (R : Internal_Entity_With_Private) return String;


         

      

      type Internal_Entity_With_Private_Absent is record

               Node : aliased Bare_With_Private_Absent;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_With_Private_Absent : constant Internal_Entity_With_Private_Absent;


      function Create_Internal_Entity_With_Private_Absent
        (Node : Bare_With_Private_Absent; Info : Internal_Entity_Info)
         return Internal_Entity_With_Private_Absent;


   


      function Trace_Image (R : Internal_Entity_With_Private_Absent) return String;


         

      

      type Internal_Entity_With_Private_Present is record

               Node : aliased Bare_With_Private_Present;
               --  The stored AST node
               
               Info : aliased Internal_Entity_Info;
               --  Entity info for this node
               
      end record
        with Convention => C;
      No_Entity_With_Private_Present : constant Internal_Entity_With_Private_Present;


      function Create_Internal_Entity_With_Private_Present
        (Node : Bare_With_Private_Present; Info : Internal_Entity_Info)
         return Internal_Entity_With_Private_Present;


   


      function Trace_Image (R : Internal_Entity_With_Private_Present) return String;


         

      

      type Internal_Env_Assoc is record

               Key : aliased Symbol_Type;
               
               
               Value : aliased Bare_Ada_Node;
               
               
               Dest_Env : aliased Internal_Designated_Env;
               
               
               Metadata : aliased Internal_Metadata;
               
               
      end record
        with Convention => C;
      No_Env_Assoc : constant Internal_Env_Assoc;

      procedure Inc_Ref (R : Internal_Env_Assoc);
      procedure Dec_Ref (R : in out Internal_Env_Assoc);


      function Equivalent (L, R : Internal_Env_Assoc) return Boolean;

   


      function Trace_Image (R : Internal_Env_Assoc) return String;


         

      

      type Internal_Eval_Discrete_Range is record

               Low_Bound : aliased Big_Integer_Type;
               
               
               High_Bound : aliased Big_Integer_Type;
               
               
      end record
        with Convention => C;
      No_Eval_Discrete_Range : constant Internal_Eval_Discrete_Range;

      procedure Inc_Ref (R : Internal_Eval_Discrete_Range);
      procedure Dec_Ref (R : in out Internal_Eval_Discrete_Range);


      function Equivalent (L, R : Internal_Eval_Discrete_Range) return Boolean;

   


      function Trace_Image (R : Internal_Eval_Discrete_Range) return String;


         

      

      type Internal_Expected_Type_For_Expr is record

               Expected_Type : aliased Internal_Entity_Type_Expr;
               
               
               Expr : aliased Internal_Entity_Expr;
               
               
      end record
        with Convention => C;
      No_Expected_Type_For_Expr : constant Internal_Expected_Type_For_Expr;




   


      function Trace_Image (R : Internal_Expected_Type_For_Expr) return String;


         

      

      type Internal_Logic_Val_Result is record

               Success : aliased Boolean;
               
               
               Value : aliased Internal_Entity;
               
               
      end record
        with Convention => C;
      No_Logic_Val_Result : constant Internal_Logic_Val_Result;




   


      function Trace_Image (R : Internal_Logic_Val_Result) return String;


         

      

      type Internal_Multidim_Aggregate_Info is record

               Agg : aliased Internal_Entity_Base_Aggregate;
               --  the top level aggregate
               
               Typ : aliased Internal_Entity_Base_Type_Decl;
               --  the type of the array
               
               Rank : aliased Integer;
               --  the rank of the original sub-aggregate
               
      end record
        with Convention => C;
      No_Multidim_Aggregate_Info : constant Internal_Multidim_Aggregate_Info;




   


      function Trace_Image (R : Internal_Multidim_Aggregate_Info) return String;


         

      

      type Internal_Param_Actual is record

               Param : aliased Internal_Entity_Defining_Name;
               
               
               Actual : aliased Internal_Entity_Expr;
               
               
      end record
        with Convention => C;
      No_Param_Actual : constant Internal_Param_Actual;




   


      function Trace_Image (R : Internal_Param_Actual) return String;


         

      

      type Internal_Single_Actual is record

               Name : aliased Bare_Base_Id;
               
               
               Assoc : aliased Internal_Entity_Basic_Assoc;
               
               
      end record
        with Convention => C;
      No_Single_Actual : constant Internal_Single_Actual;




   


      function Trace_Image (R : Internal_Single_Actual) return String;


         

      

      type Internal_Param_Match is record

               Has_Matched : aliased Boolean;
               --  Whether the matched ParamAssoc a ParamSpec.
               
               Actual : aliased Internal_Single_Actual;
               
               
               Formal : aliased Internal_Entity_Defining_Name;
               
               
      end record
        with Convention => C;
      No_Param_Match : constant Internal_Param_Match;




   


      function Trace_Image (R : Internal_Param_Match) return String;


         

      

      type Internal_Ref_Result is record

               Ref : aliased Internal_Entity_Base_Id;
               
               
               Kind : aliased Ref_Result_Kind;
               
               
      end record
        with Convention => C;
      No_Ref_Result : constant Internal_Ref_Result;




   


      function Trace_Image (R : Internal_Ref_Result) return String;


         

      

      type Internal_Refd_Decl is record

               Decl : aliased Internal_Entity_Basic_Decl;
               
               
               Kind : aliased Ref_Result_Kind;
               
               
      end record
        with Convention => C;
      No_Refd_Decl : constant Internal_Refd_Decl;




   


      function Trace_Image (R : Internal_Refd_Decl) return String;


         

      

      type Internal_Refd_Def is record

               Def_Name : aliased Internal_Entity_Defining_Name;
               
               
               Kind : aliased Ref_Result_Kind;
               
               
      end record
        with Convention => C;
      No_Refd_Def : constant Internal_Refd_Def;




   


      function Trace_Image (R : Internal_Refd_Def) return String;


         

      

      type Internal_Shape is record

               Components : aliased Internal_Entity_Base_Formal_Param_Decl_Array_Access;
               
               
               Discriminants_Values : aliased Internal_Discriminant_Values_Array_Access;
               
               
      end record
        with Convention => C;
      No_Shape : constant Internal_Shape;

      procedure Inc_Ref (R : Internal_Shape);
      procedure Dec_Ref (R : in out Internal_Shape);


      function Equivalent (L, R : Internal_Shape) return Boolean;

   


      function Trace_Image (R : Internal_Shape) return String;


         

      

      type Internal_Substitution is record

               From_Decl : aliased Internal_Entity_Basic_Decl;
               --  The declaration to substitute.
               
               To_Value : aliased Big_Integer_Type;
               --  The value by which to substitute the declaration.
               
               Value_Type : aliased Internal_Entity_Base_Type_Decl;
               --  The type of the substituted value.
               
      end record
        with Convention => C;
      No_Substitution : constant Internal_Substitution;

      procedure Inc_Ref (R : Internal_Substitution);
      procedure Dec_Ref (R : in out Internal_Substitution);


      function Equivalent (L, R : Internal_Substitution) return Boolean;

   


      function Trace_Image (R : Internal_Substitution) return String;



   -----------------
   -- Array types --
   -----------------

   --  We implement array types as discriminated records so that binding to C
   --  can be done without copy.

         

   

   type Internal_Bare_Ada_Node_Array is
      array (Positive range <>) of Bare_Ada_Node;

   type Bare_Ada_Node_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_Ada_Node_Array (1 .. N);
   end record;

   Empty_Bare_Ada_Node_Array_Record : aliased Bare_Ada_Node_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_Ada_Node_Array_Type : constant Bare_Ada_Node_Array_Access :=
      Empty_Bare_Ada_Node_Array_Record'Access;


   function Create_Bare_Ada_Node_Array (Items_Count : Natural) return Bare_Ada_Node_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_Ada_Node_Array
     (Items : Internal_Bare_Ada_Node_Array) return Bare_Ada_Node_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Bare_Ada_Node_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Ada_Node;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_Ada_Node_Array_Access) return Bare_Ada_Node_Array_Access;


   function Length (T : Bare_Ada_Node_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_Ada_Node_Array_Access);
   procedure Dec_Ref (T : in out Bare_Ada_Node_Array_Access);

   function Equivalent (L, R : Bare_Ada_Node_Array_Access) return Boolean;


      function Trace_Image (A : Bare_Ada_Node_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_Ada_Node_Array_Record, Bare_Ada_Node_Array_Access);

         

   

   type Internal_Bare_Anonymous_Expr_Decl_Array is
      array (Positive range <>) of Bare_Anonymous_Expr_Decl;

   type Bare_Anonymous_Expr_Decl_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_Anonymous_Expr_Decl_Array (1 .. N);
   end record;

   Empty_Bare_Anonymous_Expr_Decl_Array_Record : aliased Bare_Anonymous_Expr_Decl_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_Anonymous_Expr_Decl_Array_Type : constant Bare_Anonymous_Expr_Decl_Array_Access :=
      Empty_Bare_Anonymous_Expr_Decl_Array_Record'Access;


   function Create_Bare_Anonymous_Expr_Decl_Array (Items_Count : Natural) return Bare_Anonymous_Expr_Decl_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_Anonymous_Expr_Decl_Array
     (Items : Internal_Bare_Anonymous_Expr_Decl_Array) return Bare_Anonymous_Expr_Decl_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Bare_Anonymous_Expr_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Anonymous_Expr_Decl;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_Anonymous_Expr_Decl_Array_Access) return Bare_Anonymous_Expr_Decl_Array_Access;


   function Length (T : Bare_Anonymous_Expr_Decl_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_Anonymous_Expr_Decl_Array_Access);
   procedure Dec_Ref (T : in out Bare_Anonymous_Expr_Decl_Array_Access);

   function Equivalent (L, R : Bare_Anonymous_Expr_Decl_Array_Access) return Boolean;


      function Trace_Image (A : Bare_Anonymous_Expr_Decl_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_Anonymous_Expr_Decl_Array_Record, Bare_Anonymous_Expr_Decl_Array_Access);

         

   

   type Internal_Bare_Compilation_Unit_Array is
      array (Positive range <>) of Bare_Compilation_Unit;

   type Bare_Compilation_Unit_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_Compilation_Unit_Array (1 .. N);
   end record;

   Empty_Bare_Compilation_Unit_Array_Record : aliased Bare_Compilation_Unit_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_Compilation_Unit_Array_Type : constant Bare_Compilation_Unit_Array_Access :=
      Empty_Bare_Compilation_Unit_Array_Record'Access;


   function Create_Bare_Compilation_Unit_Array (Items_Count : Natural) return Bare_Compilation_Unit_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_Compilation_Unit_Array
     (Items : Internal_Bare_Compilation_Unit_Array) return Bare_Compilation_Unit_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Bare_Compilation_Unit_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Compilation_Unit;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_Compilation_Unit_Array_Access) return Bare_Compilation_Unit_Array_Access;


   function Length (T : Bare_Compilation_Unit_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_Compilation_Unit_Array_Access);
   procedure Dec_Ref (T : in out Bare_Compilation_Unit_Array_Access);

   function Equivalent (L, R : Bare_Compilation_Unit_Array_Access) return Boolean;


      function Trace_Image (A : Bare_Compilation_Unit_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_Compilation_Unit_Array_Record, Bare_Compilation_Unit_Array_Access);

         

   

   type Internal_Bare_Expr_Array is
      array (Positive range <>) of Bare_Expr;

   type Bare_Expr_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_Expr_Array (1 .. N);
   end record;

   Empty_Bare_Expr_Array_Record : aliased Bare_Expr_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_Expr_Array_Type : constant Bare_Expr_Array_Access :=
      Empty_Bare_Expr_Array_Record'Access;


   function Create_Bare_Expr_Array (Items_Count : Natural) return Bare_Expr_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_Expr_Array
     (Items : Internal_Bare_Expr_Array) return Bare_Expr_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Bare_Expr_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Expr;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_Expr_Array_Access) return Bare_Expr_Array_Access;


   function Length (T : Bare_Expr_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_Expr_Array_Access);
   procedure Dec_Ref (T : in out Bare_Expr_Array_Access);

   function Equivalent (L, R : Bare_Expr_Array_Access) return Boolean;


      function Trace_Image (A : Bare_Expr_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_Expr_Array_Record, Bare_Expr_Array_Access);

         

   

   type Internal_Bare_Name_Array is
      array (Positive range <>) of Bare_Name;

   type Bare_Name_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_Name_Array (1 .. N);
   end record;

   Empty_Bare_Name_Array_Record : aliased Bare_Name_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_Name_Array_Type : constant Bare_Name_Array_Access :=
      Empty_Bare_Name_Array_Record'Access;


   function Create_Bare_Name_Array (Items_Count : Natural) return Bare_Name_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_Name_Array
     (Items : Internal_Bare_Name_Array) return Bare_Name_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Bare_Name_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Name;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_Name_Array_Access) return Bare_Name_Array_Access;


   function Length (T : Bare_Name_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_Name_Array_Access);
   procedure Dec_Ref (T : in out Bare_Name_Array_Access);

   function Equivalent (L, R : Bare_Name_Array_Access) return Boolean;


      function Trace_Image (A : Bare_Name_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_Name_Array_Record, Bare_Name_Array_Access);

         

   

   type Internal_Bare_Pragma_Node_Array is
      array (Positive range <>) of Bare_Pragma_Node;

   type Bare_Pragma_Node_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_Pragma_Node_Array (1 .. N);
   end record;

   Empty_Bare_Pragma_Node_Array_Record : aliased Bare_Pragma_Node_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_Pragma_Node_Array_Type : constant Bare_Pragma_Node_Array_Access :=
      Empty_Bare_Pragma_Node_Array_Record'Access;


   function Create_Bare_Pragma_Node_Array (Items_Count : Natural) return Bare_Pragma_Node_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_Pragma_Node_Array
     (Items : Internal_Bare_Pragma_Node_Array) return Bare_Pragma_Node_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Bare_Pragma_Node_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Pragma_Node;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_Pragma_Node_Array_Access) return Bare_Pragma_Node_Array_Access;


   function Length (T : Bare_Pragma_Node_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_Pragma_Node_Array_Access);
   procedure Dec_Ref (T : in out Bare_Pragma_Node_Array_Access);

   function Equivalent (L, R : Bare_Pragma_Node_Array_Access) return Boolean;


      function Trace_Image (A : Bare_Pragma_Node_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_Pragma_Node_Array_Record, Bare_Pragma_Node_Array_Access);

         

   

   type Internal_Bare_Single_Tok_Node_Array is
      array (Positive range <>) of Bare_Single_Tok_Node;

   type Bare_Single_Tok_Node_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_Single_Tok_Node_Array (1 .. N);
   end record;

   Empty_Bare_Single_Tok_Node_Array_Record : aliased Bare_Single_Tok_Node_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_Single_Tok_Node_Array_Type : constant Bare_Single_Tok_Node_Array_Access :=
      Empty_Bare_Single_Tok_Node_Array_Record'Access;


   function Create_Bare_Single_Tok_Node_Array (Items_Count : Natural) return Bare_Single_Tok_Node_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_Single_Tok_Node_Array
     (Items : Internal_Bare_Single_Tok_Node_Array) return Bare_Single_Tok_Node_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Bare_Single_Tok_Node_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Single_Tok_Node;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_Single_Tok_Node_Array_Access) return Bare_Single_Tok_Node_Array_Access;


   function Length (T : Bare_Single_Tok_Node_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_Single_Tok_Node_Array_Access);
   procedure Dec_Ref (T : in out Bare_Single_Tok_Node_Array_Access);

   function Equivalent (L, R : Bare_Single_Tok_Node_Array_Access) return Boolean;


      function Trace_Image (A : Bare_Single_Tok_Node_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_Single_Tok_Node_Array_Record, Bare_Single_Tok_Node_Array_Access);

         

   

   type Internal_Bare_Use_Clause_Array is
      array (Positive range <>) of Bare_Use_Clause;

   type Bare_Use_Clause_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Bare_Use_Clause_Array (1 .. N);
   end record;

   Empty_Bare_Use_Clause_Array_Record : aliased Bare_Use_Clause_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Bare_Use_Clause_Array_Type : constant Bare_Use_Clause_Array_Access :=
      Empty_Bare_Use_Clause_Array_Record'Access;


   function Create_Bare_Use_Clause_Array (Items_Count : Natural) return Bare_Use_Clause_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Bare_Use_Clause_Array
     (Items : Internal_Bare_Use_Clause_Array) return Bare_Use_Clause_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Bare_Use_Clause_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Use_Clause;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Bare_Use_Clause_Array_Access) return Bare_Use_Clause_Array_Access;


   function Length (T : Bare_Use_Clause_Array_Access) return Natural;

   procedure Inc_Ref (T : Bare_Use_Clause_Array_Access);
   procedure Dec_Ref (T : in out Bare_Use_Clause_Array_Access);

   function Equivalent (L, R : Bare_Use_Clause_Array_Access) return Boolean;


      function Trace_Image (A : Bare_Use_Clause_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Bare_Use_Clause_Array_Record, Bare_Use_Clause_Array_Access);

         

   

   type Internal_Internal_Aspect_Array is
      array (Positive range <>) of Internal_Aspect;

   type Internal_Aspect_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Aspect_Array (1 .. N);
   end record;

   Empty_Internal_Aspect_Array_Record : aliased Internal_Aspect_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Aspect_Array_Type : constant Internal_Aspect_Array_Access :=
      Empty_Internal_Aspect_Array_Record'Access;


   function Create_Internal_Aspect_Array (Items_Count : Natural) return Internal_Aspect_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Aspect_Array
     (Items : Internal_Internal_Aspect_Array) return Internal_Aspect_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Aspect_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Aspect;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Aspect_Array_Access) return Internal_Aspect_Array_Access;


   function Length (T : Internal_Aspect_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Aspect_Array_Access);
   procedure Dec_Ref (T : in out Internal_Aspect_Array_Access);

   function Equivalent (L, R : Internal_Aspect_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Aspect_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Aspect_Array_Record, Internal_Aspect_Array_Access);

         

   

   type Internal_Internal_Completion_Item_Array is
      array (Positive range <>) of Internal_Completion_Item;

   type Internal_Completion_Item_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Completion_Item_Array (1 .. N);
   end record;

   Empty_Internal_Completion_Item_Array_Record : aliased Internal_Completion_Item_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Completion_Item_Array_Type : constant Internal_Completion_Item_Array_Access :=
      Empty_Internal_Completion_Item_Array_Record'Access;


   function Create_Internal_Completion_Item_Array (Items_Count : Natural) return Internal_Completion_Item_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Completion_Item_Array
     (Items : Internal_Internal_Completion_Item_Array) return Internal_Completion_Item_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Completion_Item_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Completion_Item;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Completion_Item_Array_Access) return Internal_Completion_Item_Array_Access;


   function Length (T : Internal_Completion_Item_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Completion_Item_Array_Access);
   procedure Dec_Ref (T : in out Internal_Completion_Item_Array_Access);

   function Equivalent (L, R : Internal_Completion_Item_Array_Access) return Boolean;

      function To_Iterator
        (Self    : Internal_Completion_Item_Array_Access;
         Context : Internal_Context) return Internal_Completion_Item_Iterator_Access;
      --  Return an iterator on values from Self. Context is used to create the
      --  corresponding safety net.

      function Trace_Image (A : Internal_Completion_Item_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Completion_Item_Array_Record, Internal_Completion_Item_Array_Access);

         

   

   type Internal_Internal_Discriminant_Values_Array is
      array (Positive range <>) of Internal_Discriminant_Values;

   type Internal_Discriminant_Values_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Discriminant_Values_Array (1 .. N);
   end record;

   Empty_Internal_Discriminant_Values_Array_Record : aliased Internal_Discriminant_Values_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Discriminant_Values_Array_Type : constant Internal_Discriminant_Values_Array_Access :=
      Empty_Internal_Discriminant_Values_Array_Record'Access;


   function Create_Internal_Discriminant_Values_Array (Items_Count : Natural) return Internal_Discriminant_Values_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Discriminant_Values_Array
     (Items : Internal_Internal_Discriminant_Values_Array) return Internal_Discriminant_Values_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Discriminant_Values_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Discriminant_Values;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Discriminant_Values_Array_Access) return Internal_Discriminant_Values_Array_Access;


   function Length (T : Internal_Discriminant_Values_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Discriminant_Values_Array_Access);
   procedure Dec_Ref (T : in out Internal_Discriminant_Values_Array_Access);

   function Equivalent (L, R : Internal_Discriminant_Values_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Discriminant_Values_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Discriminant_Values_Array_Record, Internal_Discriminant_Values_Array_Access);

         

   

   type Internal_Internal_Doc_Annotation_Array is
      array (Positive range <>) of Internal_Doc_Annotation;

   type Internal_Doc_Annotation_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Doc_Annotation_Array (1 .. N);
   end record;

   Empty_Internal_Doc_Annotation_Array_Record : aliased Internal_Doc_Annotation_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Doc_Annotation_Array_Type : constant Internal_Doc_Annotation_Array_Access :=
      Empty_Internal_Doc_Annotation_Array_Record'Access;


   function Create_Internal_Doc_Annotation_Array (Items_Count : Natural) return Internal_Doc_Annotation_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Doc_Annotation_Array
     (Items : Internal_Internal_Doc_Annotation_Array) return Internal_Doc_Annotation_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Doc_Annotation_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Doc_Annotation;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Doc_Annotation_Array_Access) return Internal_Doc_Annotation_Array_Access;


   function Length (T : Internal_Doc_Annotation_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Doc_Annotation_Array_Access);
   procedure Dec_Ref (T : in out Internal_Doc_Annotation_Array_Access);

   function Equivalent (L, R : Internal_Doc_Annotation_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Doc_Annotation_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Doc_Annotation_Array_Record, Internal_Doc_Annotation_Array_Access);

         

   

   type Internal_Internal_Entity_Accept_Stmt_Array is
      array (Positive range <>) of Internal_Entity_Accept_Stmt;

   type Internal_Entity_Accept_Stmt_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Accept_Stmt_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Accept_Stmt_Array_Record : aliased Internal_Entity_Accept_Stmt_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Accept_Stmt_Array_Type : constant Internal_Entity_Accept_Stmt_Array_Access :=
      Empty_Internal_Entity_Accept_Stmt_Array_Record'Access;


   function Create_Internal_Entity_Accept_Stmt_Array (Items_Count : Natural) return Internal_Entity_Accept_Stmt_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Accept_Stmt_Array
     (Items : Internal_Internal_Entity_Accept_Stmt_Array) return Internal_Entity_Accept_Stmt_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Accept_Stmt_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Accept_Stmt;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Accept_Stmt_Array_Access) return Internal_Entity_Accept_Stmt_Array_Access;


   function Length (T : Internal_Entity_Accept_Stmt_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Accept_Stmt_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Accept_Stmt_Array_Access);

   function Equivalent (L, R : Internal_Entity_Accept_Stmt_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Accept_Stmt_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Accept_Stmt_Array_Record, Internal_Entity_Accept_Stmt_Array_Access);

         

   

   type Internal_Internal_Entity_Array is
      array (Positive range <>) of Internal_Entity;

   type Internal_Entity_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Array_Record : aliased Internal_Entity_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Array_Type : constant Internal_Entity_Array_Access :=
      Empty_Internal_Entity_Array_Record'Access;

   function Create_Internal_Entity_Array
     (Items : AST_Envs.Entity_Array) return Internal_Entity_Array_Access;

   function Create_Internal_Entity_Array (Items_Count : Natural) return Internal_Entity_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Array
     (Items : Internal_Internal_Entity_Array) return Internal_Entity_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Array_Access) return Internal_Entity_Array_Access;


   function Length (T : Internal_Entity_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Array_Access);

   function Equivalent (L, R : Internal_Entity_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Array_Record, Internal_Entity_Array_Access);

         

   

   type Internal_Internal_Entity_Base_Assoc_Array is
      array (Positive range <>) of Internal_Entity_Base_Assoc;

   type Internal_Entity_Base_Assoc_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Base_Assoc_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Base_Assoc_Array_Record : aliased Internal_Entity_Base_Assoc_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Base_Assoc_Array_Type : constant Internal_Entity_Base_Assoc_Array_Access :=
      Empty_Internal_Entity_Base_Assoc_Array_Record'Access;


   function Create_Internal_Entity_Base_Assoc_Array (Items_Count : Natural) return Internal_Entity_Base_Assoc_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Base_Assoc_Array
     (Items : Internal_Internal_Entity_Base_Assoc_Array) return Internal_Entity_Base_Assoc_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Base_Assoc_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Base_Assoc;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Base_Assoc_Array_Access) return Internal_Entity_Base_Assoc_Array_Access;


   function Length (T : Internal_Entity_Base_Assoc_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Base_Assoc_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Base_Assoc_Array_Access);

   function Equivalent (L, R : Internal_Entity_Base_Assoc_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Base_Assoc_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Base_Assoc_Array_Record, Internal_Entity_Base_Assoc_Array_Access);

         

   

   type Internal_Internal_Entity_Base_Formal_Param_Decl_Array is
      array (Positive range <>) of Internal_Entity_Base_Formal_Param_Decl;

   type Internal_Entity_Base_Formal_Param_Decl_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Base_Formal_Param_Decl_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Base_Formal_Param_Decl_Array_Record : aliased Internal_Entity_Base_Formal_Param_Decl_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Base_Formal_Param_Decl_Array_Type : constant Internal_Entity_Base_Formal_Param_Decl_Array_Access :=
      Empty_Internal_Entity_Base_Formal_Param_Decl_Array_Record'Access;


   function Create_Internal_Entity_Base_Formal_Param_Decl_Array (Items_Count : Natural) return Internal_Entity_Base_Formal_Param_Decl_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Base_Formal_Param_Decl_Array
     (Items : Internal_Internal_Entity_Base_Formal_Param_Decl_Array) return Internal_Entity_Base_Formal_Param_Decl_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Base_Formal_Param_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Base_Formal_Param_Decl;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Base_Formal_Param_Decl_Array_Access) return Internal_Entity_Base_Formal_Param_Decl_Array_Access;


   function Length (T : Internal_Entity_Base_Formal_Param_Decl_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Base_Formal_Param_Decl_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Base_Formal_Param_Decl_Array_Access);

   function Equivalent (L, R : Internal_Entity_Base_Formal_Param_Decl_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Base_Formal_Param_Decl_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Base_Formal_Param_Decl_Array_Record, Internal_Entity_Base_Formal_Param_Decl_Array_Access);

         

   

   type Internal_Internal_Entity_Base_Type_Decl_Array is
      array (Positive range <>) of Internal_Entity_Base_Type_Decl;

   type Internal_Entity_Base_Type_Decl_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Base_Type_Decl_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Base_Type_Decl_Array_Record : aliased Internal_Entity_Base_Type_Decl_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Base_Type_Decl_Array_Type : constant Internal_Entity_Base_Type_Decl_Array_Access :=
      Empty_Internal_Entity_Base_Type_Decl_Array_Record'Access;


   function Create_Internal_Entity_Base_Type_Decl_Array (Items_Count : Natural) return Internal_Entity_Base_Type_Decl_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Base_Type_Decl_Array
     (Items : Internal_Internal_Entity_Base_Type_Decl_Array) return Internal_Entity_Base_Type_Decl_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Base_Type_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Base_Type_Decl;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Base_Type_Decl_Array_Access) return Internal_Entity_Base_Type_Decl_Array_Access;


   function Length (T : Internal_Entity_Base_Type_Decl_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Base_Type_Decl_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Base_Type_Decl_Array_Access);

   function Equivalent (L, R : Internal_Entity_Base_Type_Decl_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Base_Type_Decl_Array_Access) return String;

      function Make_Unique (A : Internal_Entity_Base_Type_Decl_Array_Access) return Internal_Entity_Base_Type_Decl_Array_Access;
      --  Return a copy of A with duplicated elements removed

      function Hash (R : Internal_Entity_Base_Type_Decl_Array_Access) return Hash_Type;

  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Base_Type_Decl_Array_Record, Internal_Entity_Base_Type_Decl_Array_Access);

         

   

   type Internal_Internal_Entity_Basic_Assoc_Array is
      array (Positive range <>) of Internal_Entity_Basic_Assoc;

   type Internal_Entity_Basic_Assoc_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Basic_Assoc_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Basic_Assoc_Array_Record : aliased Internal_Entity_Basic_Assoc_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Basic_Assoc_Array_Type : constant Internal_Entity_Basic_Assoc_Array_Access :=
      Empty_Internal_Entity_Basic_Assoc_Array_Record'Access;


   function Create_Internal_Entity_Basic_Assoc_Array (Items_Count : Natural) return Internal_Entity_Basic_Assoc_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Basic_Assoc_Array
     (Items : Internal_Internal_Entity_Basic_Assoc_Array) return Internal_Entity_Basic_Assoc_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Basic_Assoc_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Basic_Assoc;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Basic_Assoc_Array_Access) return Internal_Entity_Basic_Assoc_Array_Access;


   function Length (T : Internal_Entity_Basic_Assoc_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Basic_Assoc_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Basic_Assoc_Array_Access);

   function Equivalent (L, R : Internal_Entity_Basic_Assoc_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Basic_Assoc_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Basic_Assoc_Array_Record, Internal_Entity_Basic_Assoc_Array_Access);

         

   

   type Internal_Internal_Entity_Basic_Decl_Array is
      array (Positive range <>) of Internal_Entity_Basic_Decl;

   type Internal_Entity_Basic_Decl_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Basic_Decl_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Basic_Decl_Array_Record : aliased Internal_Entity_Basic_Decl_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Basic_Decl_Array_Type : constant Internal_Entity_Basic_Decl_Array_Access :=
      Empty_Internal_Entity_Basic_Decl_Array_Record'Access;


   function Create_Internal_Entity_Basic_Decl_Array (Items_Count : Natural) return Internal_Entity_Basic_Decl_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Basic_Decl_Array
     (Items : Internal_Internal_Entity_Basic_Decl_Array) return Internal_Entity_Basic_Decl_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Basic_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Basic_Decl;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Basic_Decl_Array_Access) return Internal_Entity_Basic_Decl_Array_Access;


   function Length (T : Internal_Entity_Basic_Decl_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Basic_Decl_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Basic_Decl_Array_Access);

   function Equivalent (L, R : Internal_Entity_Basic_Decl_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Basic_Decl_Array_Access) return String;

      function Make_Unique (A : Internal_Entity_Basic_Decl_Array_Access) return Internal_Entity_Basic_Decl_Array_Access;
      --  Return a copy of A with duplicated elements removed


  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Basic_Decl_Array_Record, Internal_Entity_Basic_Decl_Array_Access);

         

   

   type Internal_Internal_Entity_Compilation_Unit_Array is
      array (Positive range <>) of Internal_Entity_Compilation_Unit;

   type Internal_Entity_Compilation_Unit_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Compilation_Unit_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Compilation_Unit_Array_Record : aliased Internal_Entity_Compilation_Unit_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Compilation_Unit_Array_Type : constant Internal_Entity_Compilation_Unit_Array_Access :=
      Empty_Internal_Entity_Compilation_Unit_Array_Record'Access;


   function Create_Internal_Entity_Compilation_Unit_Array (Items_Count : Natural) return Internal_Entity_Compilation_Unit_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Compilation_Unit_Array
     (Items : Internal_Internal_Entity_Compilation_Unit_Array) return Internal_Entity_Compilation_Unit_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Compilation_Unit_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Compilation_Unit;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Compilation_Unit_Array_Access) return Internal_Entity_Compilation_Unit_Array_Access;


   function Length (T : Internal_Entity_Compilation_Unit_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Compilation_Unit_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Compilation_Unit_Array_Access);

   function Equivalent (L, R : Internal_Entity_Compilation_Unit_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Compilation_Unit_Array_Access) return String;

      function Make_Unique (A : Internal_Entity_Compilation_Unit_Array_Access) return Internal_Entity_Compilation_Unit_Array_Access;
      --  Return a copy of A with duplicated elements removed


  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Compilation_Unit_Array_Record, Internal_Entity_Compilation_Unit_Array_Access);

         

   

   type Internal_Internal_Entity_Declarative_Part_Array is
      array (Positive range <>) of Internal_Entity_Declarative_Part;

   type Internal_Entity_Declarative_Part_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Declarative_Part_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Declarative_Part_Array_Record : aliased Internal_Entity_Declarative_Part_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Declarative_Part_Array_Type : constant Internal_Entity_Declarative_Part_Array_Access :=
      Empty_Internal_Entity_Declarative_Part_Array_Record'Access;


   function Create_Internal_Entity_Declarative_Part_Array (Items_Count : Natural) return Internal_Entity_Declarative_Part_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Declarative_Part_Array
     (Items : Internal_Internal_Entity_Declarative_Part_Array) return Internal_Entity_Declarative_Part_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Declarative_Part_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Declarative_Part;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Declarative_Part_Array_Access) return Internal_Entity_Declarative_Part_Array_Access;


   function Length (T : Internal_Entity_Declarative_Part_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Declarative_Part_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Declarative_Part_Array_Access);

   function Equivalent (L, R : Internal_Entity_Declarative_Part_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Declarative_Part_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Declarative_Part_Array_Record, Internal_Entity_Declarative_Part_Array_Access);

         

   

   type Internal_Internal_Entity_Defining_Name_Array is
      array (Positive range <>) of Internal_Entity_Defining_Name;

   type Internal_Entity_Defining_Name_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Defining_Name_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Defining_Name_Array_Record : aliased Internal_Entity_Defining_Name_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Defining_Name_Array_Type : constant Internal_Entity_Defining_Name_Array_Access :=
      Empty_Internal_Entity_Defining_Name_Array_Record'Access;


   function Create_Internal_Entity_Defining_Name_Array (Items_Count : Natural) return Internal_Entity_Defining_Name_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Defining_Name_Array
     (Items : Internal_Internal_Entity_Defining_Name_Array) return Internal_Entity_Defining_Name_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Defining_Name_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Defining_Name;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Defining_Name_Array_Access) return Internal_Entity_Defining_Name_Array_Access;


   function Length (T : Internal_Entity_Defining_Name_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Defining_Name_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Defining_Name_Array_Access);

   function Equivalent (L, R : Internal_Entity_Defining_Name_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Defining_Name_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Defining_Name_Array_Record, Internal_Entity_Defining_Name_Array_Access);

         

   

   type Internal_Internal_Entity_Expr_Array is
      array (Positive range <>) of Internal_Entity_Expr;

   type Internal_Entity_Expr_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Expr_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Expr_Array_Record : aliased Internal_Entity_Expr_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Expr_Array_Type : constant Internal_Entity_Expr_Array_Access :=
      Empty_Internal_Entity_Expr_Array_Record'Access;


   function Create_Internal_Entity_Expr_Array (Items_Count : Natural) return Internal_Entity_Expr_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Expr_Array
     (Items : Internal_Internal_Entity_Expr_Array) return Internal_Entity_Expr_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Expr_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Expr;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Expr_Array_Access) return Internal_Entity_Expr_Array_Access;


   function Length (T : Internal_Entity_Expr_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Expr_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Expr_Array_Access);

   function Equivalent (L, R : Internal_Entity_Expr_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Expr_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Expr_Array_Record, Internal_Entity_Expr_Array_Access);

         

   

   type Internal_Internal_Entity_Generic_Instantiation_Array is
      array (Positive range <>) of Internal_Entity_Generic_Instantiation;

   type Internal_Entity_Generic_Instantiation_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Generic_Instantiation_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Generic_Instantiation_Array_Record : aliased Internal_Entity_Generic_Instantiation_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Generic_Instantiation_Array_Type : constant Internal_Entity_Generic_Instantiation_Array_Access :=
      Empty_Internal_Entity_Generic_Instantiation_Array_Record'Access;


   function Create_Internal_Entity_Generic_Instantiation_Array (Items_Count : Natural) return Internal_Entity_Generic_Instantiation_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Generic_Instantiation_Array
     (Items : Internal_Internal_Entity_Generic_Instantiation_Array) return Internal_Entity_Generic_Instantiation_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Generic_Instantiation_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Generic_Instantiation;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Generic_Instantiation_Array_Access) return Internal_Entity_Generic_Instantiation_Array_Access;


   function Length (T : Internal_Entity_Generic_Instantiation_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Generic_Instantiation_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Generic_Instantiation_Array_Access);

   function Equivalent (L, R : Internal_Entity_Generic_Instantiation_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Generic_Instantiation_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Generic_Instantiation_Array_Record, Internal_Entity_Generic_Instantiation_Array_Access);

         

   

   type Internal_Internal_Entity_Identifier_Array is
      array (Positive range <>) of Internal_Entity_Identifier;

   type Internal_Entity_Identifier_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Identifier_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Identifier_Array_Record : aliased Internal_Entity_Identifier_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Identifier_Array_Type : constant Internal_Entity_Identifier_Array_Access :=
      Empty_Internal_Entity_Identifier_Array_Record'Access;


   function Create_Internal_Entity_Identifier_Array (Items_Count : Natural) return Internal_Entity_Identifier_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Identifier_Array
     (Items : Internal_Internal_Entity_Identifier_Array) return Internal_Entity_Identifier_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Identifier_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Identifier;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Identifier_Array_Access) return Internal_Entity_Identifier_Array_Access;


   function Length (T : Internal_Entity_Identifier_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Identifier_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Identifier_Array_Access);

   function Equivalent (L, R : Internal_Entity_Identifier_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Identifier_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Identifier_Array_Record, Internal_Entity_Identifier_Array_Access);

         

   

   type Internal_Internal_Entity_Mode_Array is
      array (Positive range <>) of Internal_Entity_Mode;

   type Internal_Entity_Mode_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Mode_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Mode_Array_Record : aliased Internal_Entity_Mode_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Mode_Array_Type : constant Internal_Entity_Mode_Array_Access :=
      Empty_Internal_Entity_Mode_Array_Record'Access;


   function Create_Internal_Entity_Mode_Array (Items_Count : Natural) return Internal_Entity_Mode_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Mode_Array
     (Items : Internal_Internal_Entity_Mode_Array) return Internal_Entity_Mode_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Mode_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Mode;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Mode_Array_Access) return Internal_Entity_Mode_Array_Access;


   function Length (T : Internal_Entity_Mode_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Mode_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Mode_Array_Access);

   function Equivalent (L, R : Internal_Entity_Mode_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Mode_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Mode_Array_Record, Internal_Entity_Mode_Array_Access);

         

   

   type Internal_Internal_Entity_Name_Array is
      array (Positive range <>) of Internal_Entity_Name;

   type Internal_Entity_Name_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Name_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Name_Array_Record : aliased Internal_Entity_Name_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Name_Array_Type : constant Internal_Entity_Name_Array_Access :=
      Empty_Internal_Entity_Name_Array_Record'Access;


   function Create_Internal_Entity_Name_Array (Items_Count : Natural) return Internal_Entity_Name_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Name_Array
     (Items : Internal_Internal_Entity_Name_Array) return Internal_Entity_Name_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Name_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Name;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Name_Array_Access) return Internal_Entity_Name_Array_Access;


   function Length (T : Internal_Entity_Name_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Name_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Name_Array_Access);

   function Equivalent (L, R : Internal_Entity_Name_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Name_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Name_Array_Record, Internal_Entity_Name_Array_Access);

         

   

   type Internal_Internal_Entity_Param_Spec_Array is
      array (Positive range <>) of Internal_Entity_Param_Spec;

   type Internal_Entity_Param_Spec_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Param_Spec_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Param_Spec_Array_Record : aliased Internal_Entity_Param_Spec_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Param_Spec_Array_Type : constant Internal_Entity_Param_Spec_Array_Access :=
      Empty_Internal_Entity_Param_Spec_Array_Record'Access;


   function Create_Internal_Entity_Param_Spec_Array (Items_Count : Natural) return Internal_Entity_Param_Spec_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Param_Spec_Array
     (Items : Internal_Internal_Entity_Param_Spec_Array) return Internal_Entity_Param_Spec_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Param_Spec_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Param_Spec;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Param_Spec_Array_Access) return Internal_Entity_Param_Spec_Array_Access;


   function Length (T : Internal_Entity_Param_Spec_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Param_Spec_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Param_Spec_Array_Access);

   function Equivalent (L, R : Internal_Entity_Param_Spec_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Param_Spec_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Param_Spec_Array_Record, Internal_Entity_Param_Spec_Array_Access);

         

   

   type Internal_Internal_Entity_Pragma_Node_Array is
      array (Positive range <>) of Internal_Entity_Pragma_Node;

   type Internal_Entity_Pragma_Node_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Pragma_Node_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Pragma_Node_Array_Record : aliased Internal_Entity_Pragma_Node_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Pragma_Node_Array_Type : constant Internal_Entity_Pragma_Node_Array_Access :=
      Empty_Internal_Entity_Pragma_Node_Array_Record'Access;


   function Create_Internal_Entity_Pragma_Node_Array (Items_Count : Natural) return Internal_Entity_Pragma_Node_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Pragma_Node_Array
     (Items : Internal_Internal_Entity_Pragma_Node_Array) return Internal_Entity_Pragma_Node_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Pragma_Node_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Pragma_Node;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Pragma_Node_Array_Access) return Internal_Entity_Pragma_Node_Array_Access;


   function Length (T : Internal_Entity_Pragma_Node_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Pragma_Node_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Pragma_Node_Array_Access);

   function Equivalent (L, R : Internal_Entity_Pragma_Node_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Pragma_Node_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Pragma_Node_Array_Record, Internal_Entity_Pragma_Node_Array_Access);

         

   

   type Internal_Internal_Entity_Type_Decl_Array is
      array (Positive range <>) of Internal_Entity_Type_Decl;

   type Internal_Entity_Type_Decl_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Type_Decl_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Type_Decl_Array_Record : aliased Internal_Entity_Type_Decl_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Type_Decl_Array_Type : constant Internal_Entity_Type_Decl_Array_Access :=
      Empty_Internal_Entity_Type_Decl_Array_Record'Access;


   function Create_Internal_Entity_Type_Decl_Array (Items_Count : Natural) return Internal_Entity_Type_Decl_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Type_Decl_Array
     (Items : Internal_Internal_Entity_Type_Decl_Array) return Internal_Entity_Type_Decl_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Type_Decl_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Type_Decl;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Type_Decl_Array_Access) return Internal_Entity_Type_Decl_Array_Access;


   function Length (T : Internal_Entity_Type_Decl_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Type_Decl_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Type_Decl_Array_Access);

   function Equivalent (L, R : Internal_Entity_Type_Decl_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Type_Decl_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Type_Decl_Array_Record, Internal_Entity_Type_Decl_Array_Access);

         

   

   type Internal_Internal_Entity_Type_Expr_Array is
      array (Positive range <>) of Internal_Entity_Type_Expr;

   type Internal_Entity_Type_Expr_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Entity_Type_Expr_Array (1 .. N);
   end record;

   Empty_Internal_Entity_Type_Expr_Array_Record : aliased Internal_Entity_Type_Expr_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Entity_Type_Expr_Array_Type : constant Internal_Entity_Type_Expr_Array_Access :=
      Empty_Internal_Entity_Type_Expr_Array_Record'Access;


   function Create_Internal_Entity_Type_Expr_Array (Items_Count : Natural) return Internal_Entity_Type_Expr_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Entity_Type_Expr_Array
     (Items : Internal_Internal_Entity_Type_Expr_Array) return Internal_Entity_Type_Expr_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Entity_Type_Expr_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Entity_Type_Expr;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Entity_Type_Expr_Array_Access) return Internal_Entity_Type_Expr_Array_Access;


   function Length (T : Internal_Entity_Type_Expr_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Entity_Type_Expr_Array_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Type_Expr_Array_Access);

   function Equivalent (L, R : Internal_Entity_Type_Expr_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Entity_Type_Expr_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Entity_Type_Expr_Array_Record, Internal_Entity_Type_Expr_Array_Access);

         

   

   type Internal_Internal_Env_Assoc_Array is
      array (Positive range <>) of Internal_Env_Assoc;

   type Internal_Env_Assoc_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Env_Assoc_Array (1 .. N);
   end record;

   Empty_Internal_Env_Assoc_Array_Record : aliased Internal_Env_Assoc_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Env_Assoc_Array_Type : constant Internal_Env_Assoc_Array_Access :=
      Empty_Internal_Env_Assoc_Array_Record'Access;


   function Create_Internal_Env_Assoc_Array (Items_Count : Natural) return Internal_Env_Assoc_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Env_Assoc_Array
     (Items : Internal_Internal_Env_Assoc_Array) return Internal_Env_Assoc_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Env_Assoc_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Env_Assoc;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Env_Assoc_Array_Access) return Internal_Env_Assoc_Array_Access;


   function Length (T : Internal_Env_Assoc_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Env_Assoc_Array_Access);
   procedure Dec_Ref (T : in out Internal_Env_Assoc_Array_Access);

   function Equivalent (L, R : Internal_Env_Assoc_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Env_Assoc_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Env_Assoc_Array_Record, Internal_Env_Assoc_Array_Access);

         

   

   type Internal_Internal_Expected_Type_For_Expr_Array is
      array (Positive range <>) of Internal_Expected_Type_For_Expr;

   type Internal_Expected_Type_For_Expr_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Expected_Type_For_Expr_Array (1 .. N);
   end record;

   Empty_Internal_Expected_Type_For_Expr_Array_Record : aliased Internal_Expected_Type_For_Expr_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Expected_Type_For_Expr_Array_Type : constant Internal_Expected_Type_For_Expr_Array_Access :=
      Empty_Internal_Expected_Type_For_Expr_Array_Record'Access;


   function Create_Internal_Expected_Type_For_Expr_Array (Items_Count : Natural) return Internal_Expected_Type_For_Expr_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Expected_Type_For_Expr_Array
     (Items : Internal_Internal_Expected_Type_For_Expr_Array) return Internal_Expected_Type_For_Expr_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Expected_Type_For_Expr_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Expected_Type_For_Expr;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Expected_Type_For_Expr_Array_Access) return Internal_Expected_Type_For_Expr_Array_Access;


   function Length (T : Internal_Expected_Type_For_Expr_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Expected_Type_For_Expr_Array_Access);
   procedure Dec_Ref (T : in out Internal_Expected_Type_For_Expr_Array_Access);

   function Equivalent (L, R : Internal_Expected_Type_For_Expr_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Expected_Type_For_Expr_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Expected_Type_For_Expr_Array_Record, Internal_Expected_Type_For_Expr_Array_Access);

         

   

   type Internal_Internal_Param_Actual_Array is
      array (Positive range <>) of Internal_Param_Actual;

   type Internal_Param_Actual_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Param_Actual_Array (1 .. N);
   end record;

   Empty_Internal_Param_Actual_Array_Record : aliased Internal_Param_Actual_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Param_Actual_Array_Type : constant Internal_Param_Actual_Array_Access :=
      Empty_Internal_Param_Actual_Array_Record'Access;


   function Create_Internal_Param_Actual_Array (Items_Count : Natural) return Internal_Param_Actual_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Param_Actual_Array
     (Items : Internal_Internal_Param_Actual_Array) return Internal_Param_Actual_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Param_Actual_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Param_Actual;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Param_Actual_Array_Access) return Internal_Param_Actual_Array_Access;


   function Length (T : Internal_Param_Actual_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Param_Actual_Array_Access);
   procedure Dec_Ref (T : in out Internal_Param_Actual_Array_Access);

   function Equivalent (L, R : Internal_Param_Actual_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Param_Actual_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Param_Actual_Array_Record, Internal_Param_Actual_Array_Access);

         

   

   type Internal_Internal_Param_Match_Array is
      array (Positive range <>) of Internal_Param_Match;

   type Internal_Param_Match_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Param_Match_Array (1 .. N);
   end record;

   Empty_Internal_Param_Match_Array_Record : aliased Internal_Param_Match_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Param_Match_Array_Type : constant Internal_Param_Match_Array_Access :=
      Empty_Internal_Param_Match_Array_Record'Access;


   function Create_Internal_Param_Match_Array (Items_Count : Natural) return Internal_Param_Match_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Param_Match_Array
     (Items : Internal_Internal_Param_Match_Array) return Internal_Param_Match_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Param_Match_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Param_Match;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Param_Match_Array_Access) return Internal_Param_Match_Array_Access;


   function Length (T : Internal_Param_Match_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Param_Match_Array_Access);
   procedure Dec_Ref (T : in out Internal_Param_Match_Array_Access);

   function Equivalent (L, R : Internal_Param_Match_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Param_Match_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Param_Match_Array_Record, Internal_Param_Match_Array_Access);

         

   

   type Internal_Internal_Ref_Result_Array is
      array (Positive range <>) of Internal_Ref_Result;

   type Internal_Ref_Result_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Ref_Result_Array (1 .. N);
   end record;

   Empty_Internal_Ref_Result_Array_Record : aliased Internal_Ref_Result_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Ref_Result_Array_Type : constant Internal_Ref_Result_Array_Access :=
      Empty_Internal_Ref_Result_Array_Record'Access;


   function Create_Internal_Ref_Result_Array (Items_Count : Natural) return Internal_Ref_Result_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Ref_Result_Array
     (Items : Internal_Internal_Ref_Result_Array) return Internal_Ref_Result_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Ref_Result_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Ref_Result;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Ref_Result_Array_Access) return Internal_Ref_Result_Array_Access;


   function Length (T : Internal_Ref_Result_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Ref_Result_Array_Access);
   procedure Dec_Ref (T : in out Internal_Ref_Result_Array_Access);

   function Equivalent (L, R : Internal_Ref_Result_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Ref_Result_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Ref_Result_Array_Record, Internal_Ref_Result_Array_Access);

         

   

   type Internal_Internal_Shape_Array is
      array (Positive range <>) of Internal_Shape;

   type Internal_Shape_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Shape_Array (1 .. N);
   end record;

   Empty_Internal_Shape_Array_Record : aliased Internal_Shape_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Shape_Array_Type : constant Internal_Shape_Array_Access :=
      Empty_Internal_Shape_Array_Record'Access;


   function Create_Internal_Shape_Array (Items_Count : Natural) return Internal_Shape_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Shape_Array
     (Items : Internal_Internal_Shape_Array) return Internal_Shape_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Shape_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Shape;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Shape_Array_Access) return Internal_Shape_Array_Access;


   function Length (T : Internal_Shape_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Shape_Array_Access);
   procedure Dec_Ref (T : in out Internal_Shape_Array_Access);

   function Equivalent (L, R : Internal_Shape_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Shape_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Shape_Array_Record, Internal_Shape_Array_Access);

         

   

   type Internal_Internal_Single_Actual_Array is
      array (Positive range <>) of Internal_Single_Actual;

   type Internal_Single_Actual_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Single_Actual_Array (1 .. N);
   end record;

   Empty_Internal_Single_Actual_Array_Record : aliased Internal_Single_Actual_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Single_Actual_Array_Type : constant Internal_Single_Actual_Array_Access :=
      Empty_Internal_Single_Actual_Array_Record'Access;


   function Create_Internal_Single_Actual_Array (Items_Count : Natural) return Internal_Single_Actual_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Single_Actual_Array
     (Items : Internal_Internal_Single_Actual_Array) return Internal_Single_Actual_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Single_Actual_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Single_Actual;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Single_Actual_Array_Access) return Internal_Single_Actual_Array_Access;


   function Length (T : Internal_Single_Actual_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Single_Actual_Array_Access);
   procedure Dec_Ref (T : in out Internal_Single_Actual_Array_Access);

   function Equivalent (L, R : Internal_Single_Actual_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Single_Actual_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Single_Actual_Array_Record, Internal_Single_Actual_Array_Access);

         

   

   type Internal_Internal_Substitution_Array is
      array (Positive range <>) of Internal_Substitution;

   type Internal_Substitution_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Substitution_Array (1 .. N);
   end record;

   Empty_Internal_Substitution_Array_Record : aliased Internal_Substitution_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Substitution_Array_Type : constant Internal_Substitution_Array_Access :=
      Empty_Internal_Substitution_Array_Record'Access;


   function Create_Internal_Substitution_Array (Items_Count : Natural) return Internal_Substitution_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Substitution_Array
     (Items : Internal_Internal_Substitution_Array) return Internal_Substitution_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Substitution_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Substitution;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Substitution_Array_Access) return Internal_Substitution_Array_Access;


   function Length (T : Internal_Substitution_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Substitution_Array_Access);
   procedure Dec_Ref (T : in out Internal_Substitution_Array_Access);

   function Equivalent (L, R : Internal_Substitution_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Substitution_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Substitution_Array_Record, Internal_Substitution_Array_Access);

         

   

   type Internal_Internal_Unit_Array is
      array (Positive range <>) of Internal_Unit;

   type Internal_Unit_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Internal_Unit_Array (1 .. N);
   end record;

   Empty_Internal_Unit_Array_Record : aliased Internal_Unit_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Internal_Unit_Array_Type : constant Internal_Unit_Array_Access :=
      Empty_Internal_Unit_Array_Record'Access;


   function Create_Internal_Unit_Array (Items_Count : Natural) return Internal_Unit_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Internal_Unit_Array
     (Items : Internal_Internal_Unit_Array) return Internal_Unit_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Internal_Unit_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Internal_Unit;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Internal_Unit_Array_Access) return Internal_Unit_Array_Access;


   function Length (T : Internal_Unit_Array_Access) return Natural;

   procedure Inc_Ref (T : Internal_Unit_Array_Access);
   procedure Dec_Ref (T : in out Internal_Unit_Array_Access);

   function Equivalent (L, R : Internal_Unit_Array_Access) return Boolean;


      function Trace_Image (A : Internal_Unit_Array_Access) return String;

      function Make_Unique (A : Internal_Unit_Array_Access) return Internal_Unit_Array_Access;
      --  Return a copy of A with duplicated elements removed


  procedure Free is new Ada.Unchecked_Deallocation
    (Internal_Unit_Array_Record, Internal_Unit_Array_Access);

         

   

   type Internal_Lexical_Env_Array is
      array (Positive range <>) of Lexical_Env;

   type Lexical_Env_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Lexical_Env_Array (1 .. N);
   end record;

   Empty_Lexical_Env_Array_Record : aliased Lexical_Env_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Lexical_Env_Array_Type : constant Lexical_Env_Array_Access :=
      Empty_Lexical_Env_Array_Record'Access;


   function Create_Lexical_Env_Array (Items_Count : Natural) return Lexical_Env_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Lexical_Env_Array
     (Items : Internal_Lexical_Env_Array) return Lexical_Env_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Lexical_Env_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Lexical_Env;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Lexical_Env_Array_Access) return Lexical_Env_Array_Access;


   function Length (T : Lexical_Env_Array_Access) return Natural;

   procedure Inc_Ref (T : Lexical_Env_Array_Access);
   procedure Dec_Ref (T : in out Lexical_Env_Array_Access);

   function Equivalent (L, R : Lexical_Env_Array_Access) return Boolean;


      function Trace_Image (A : Lexical_Env_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Lexical_Env_Array_Record, Lexical_Env_Array_Access);

         

   

   type Internal_Logic_Equation_Array is
      array (Positive range <>) of Logic_Equation;

   type Logic_Equation_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Logic_Equation_Array (1 .. N);
   end record;

   Empty_Logic_Equation_Array_Record : aliased Logic_Equation_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Logic_Equation_Array_Type : constant Logic_Equation_Array_Access :=
      Empty_Logic_Equation_Array_Record'Access;


   function Create_Logic_Equation_Array (Items_Count : Natural) return Logic_Equation_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Logic_Equation_Array
     (Items : Internal_Logic_Equation_Array) return Logic_Equation_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Logic_Equation_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Logic_Equation;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Logic_Equation_Array_Access) return Logic_Equation_Array_Access;


   function Length (T : Logic_Equation_Array_Access) return Natural;

   procedure Inc_Ref (T : Logic_Equation_Array_Access);
   procedure Dec_Ref (T : in out Logic_Equation_Array_Access);

   function Equivalent (L, R : Logic_Equation_Array_Access) return Boolean;


      function Trace_Image (A : Logic_Equation_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Logic_Equation_Array_Record, Logic_Equation_Array_Access);

         

   

   type Internal_String_Type_Array is
      array (Positive range <>) of String_Type;

   type String_Type_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_String_Type_Array (1 .. N);
   end record;

   Empty_String_Type_Array_Record : aliased String_Type_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_String_Type_Array_Type : constant String_Type_Array_Access :=
      Empty_String_Type_Array_Record'Access;


   function Create_String_Type_Array (Items_Count : Natural) return String_Type_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_String_Type_Array
     (Items : Internal_String_Type_Array) return String_Type_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : String_Type_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return String_Type;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : String_Type_Array_Access) return String_Type_Array_Access;

      function Join_Strings
        (Separator : String_Type;
         Strings   : String_Type_Array_Access) return String_Type;
      --  Return the concatenation of all strings in ``Strings``, separated by
      --  ``Separator``.

   function Length (T : String_Type_Array_Access) return Natural;

   procedure Inc_Ref (T : String_Type_Array_Access);
   procedure Dec_Ref (T : in out String_Type_Array_Access);

   function Equivalent (L, R : String_Type_Array_Access) return Boolean;


      function Trace_Image (A : String_Type_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (String_Type_Array_Record, String_Type_Array_Access);

         

   

   type Internal_Symbol_Type_Array is
      array (Positive range <>) of Symbol_Type;

   type Symbol_Type_Array_Record (N : Natural) is record
      Ref_Count : Integer;
      --  Negative values are interpreted as "always living singleton".
      --  Non-negative values have the usual ref-counting semantics.

      Items     : Internal_Symbol_Type_Array (1 .. N);
   end record;

   Empty_Symbol_Type_Array_Record : aliased Symbol_Type_Array_Record :=
     (N => 0, Ref_Count => -1, Items => (1 .. 0 => <>));
   No_Symbol_Type_Array_Type : constant Symbol_Type_Array_Access :=
      Empty_Symbol_Type_Array_Record'Access;


   function Create_Symbol_Type_Array (Items_Count : Natural) return Symbol_Type_Array_Access;
   --  Create a new array for N uninitialized elements and give its only
   --  ownership share to the caller.

   function Create_Symbol_Type_Array
     (Items : Internal_Symbol_Type_Array) return Symbol_Type_Array_Access;
   --  Create a new array from an existing collection of elements

   function Get
     (Node    : Bare_Ada_Node;
      T       : Symbol_Type_Array_Access;
      Index   : Integer;
      Or_Null : Boolean := False) return Symbol_Type;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based. If
   --  the result is ref-counted, a new owning reference is returned.

   function Concat (L, R : Symbol_Type_Array_Access) return Symbol_Type_Array_Access;


   function Length (T : Symbol_Type_Array_Access) return Natural;

   procedure Inc_Ref (T : Symbol_Type_Array_Access);
   procedure Dec_Ref (T : in out Symbol_Type_Array_Access);

   function Equivalent (L, R : Symbol_Type_Array_Access) return Boolean;


      function Trace_Image (A : Symbol_Type_Array_Access) return String;



  procedure Free is new Ada.Unchecked_Deallocation
    (Symbol_Type_Array_Record, Symbol_Type_Array_Access);


   --------------------
   -- Iterator types --
   --------------------

         

   

   type Internal_Bare_Ada_Node_Iterator is record
      Ref_Count : Integer;
      --  Reference count. The iterator is freed when this drops to zero.
      --  Negative values are interpreted as "always living singleton".

      Safety_Net : Iterator_Safety_Net;
      --  Safety net for the iterator. Used to check that values produced by
      --  the iterator are still valid. Unlike for other types, we put the
      --  safety net in the internal type so that it can be used in all other
      --  APIs (Python, ...).
      --
      --  While other types (except nodes) are "deeply" converted to native
      --  APIs (for instance: internal arrays are turned into native Python
      --  lists, likewise for array items, etc.), iterators are lazy, so the
      --  deep conversion is not possible.

      Elements : Bare_Ada_Node_Array_Access;
      Index    : Positive;
   end record;

   Empty_Internal_Bare_Ada_Node_Iterator : aliased Internal_Bare_Ada_Node_Iterator :=
     (Ref_Count  => -1,
      Safety_Net => No_Iterator_Safety_Net,
      Elements   => No_Bare_Ada_Node_Array_Type,
      Index      => 1);
   No_Bare_Ada_Node_Iterator_Type : constant Bare_Ada_Node_Iterator_Access :=
      Empty_Internal_Bare_Ada_Node_Iterator'Access;

   function Next
     (T       : Bare_Ada_Node_Iterator_Access;
      Element : out Bare_Ada_Node) return Boolean;

   procedure Inc_Ref (T : Bare_Ada_Node_Iterator_Access);
   procedure Dec_Ref (T : in out Bare_Ada_Node_Iterator_Access);

      function Trace_Image (A : Bare_Ada_Node_Iterator_Access) return String;

   procedure Free is new Ada.Unchecked_Deallocation
     (Internal_Bare_Ada_Node_Iterator, Bare_Ada_Node_Iterator_Access);

         

   

   type Internal_Internal_Completion_Item_Iterator is record
      Ref_Count : Integer;
      --  Reference count. The iterator is freed when this drops to zero.
      --  Negative values are interpreted as "always living singleton".

      Safety_Net : Iterator_Safety_Net;
      --  Safety net for the iterator. Used to check that values produced by
      --  the iterator are still valid. Unlike for other types, we put the
      --  safety net in the internal type so that it can be used in all other
      --  APIs (Python, ...).
      --
      --  While other types (except nodes) are "deeply" converted to native
      --  APIs (for instance: internal arrays are turned into native Python
      --  lists, likewise for array items, etc.), iterators are lazy, so the
      --  deep conversion is not possible.

      Elements : Internal_Completion_Item_Array_Access;
      Index    : Positive;
   end record;

   Empty_Internal_Internal_Completion_Item_Iterator : aliased Internal_Internal_Completion_Item_Iterator :=
     (Ref_Count  => -1,
      Safety_Net => No_Iterator_Safety_Net,
      Elements   => No_Internal_Completion_Item_Array_Type,
      Index      => 1);
   No_Internal_Completion_Item_Iterator_Type : constant Internal_Completion_Item_Iterator_Access :=
      Empty_Internal_Internal_Completion_Item_Iterator'Access;

   function Next
     (T       : Internal_Completion_Item_Iterator_Access;
      Element : out Internal_Completion_Item) return Boolean;

   procedure Inc_Ref (T : Internal_Completion_Item_Iterator_Access);
   procedure Dec_Ref (T : in out Internal_Completion_Item_Iterator_Access);

      function Trace_Image (A : Internal_Completion_Item_Iterator_Access) return String;

   procedure Free is new Ada.Unchecked_Deallocation
     (Internal_Internal_Completion_Item_Iterator, Internal_Completion_Item_Iterator_Access);

         

   

   type Internal_Internal_Entity_Iterator is record
      Ref_Count : Integer;
      --  Reference count. The iterator is freed when this drops to zero.
      --  Negative values are interpreted as "always living singleton".

      Safety_Net : Iterator_Safety_Net;
      --  Safety net for the iterator. Used to check that values produced by
      --  the iterator are still valid. Unlike for other types, we put the
      --  safety net in the internal type so that it can be used in all other
      --  APIs (Python, ...).
      --
      --  While other types (except nodes) are "deeply" converted to native
      --  APIs (for instance: internal arrays are turned into native Python
      --  lists, likewise for array items, etc.), iterators are lazy, so the
      --  deep conversion is not possible.

      Elements : Internal_Entity_Array_Access;
      Index    : Positive;
   end record;

   Empty_Internal_Internal_Entity_Iterator : aliased Internal_Internal_Entity_Iterator :=
     (Ref_Count  => -1,
      Safety_Net => No_Iterator_Safety_Net,
      Elements   => No_Internal_Entity_Array_Type,
      Index      => 1);
   No_Internal_Entity_Iterator_Type : constant Internal_Entity_Iterator_Access :=
      Empty_Internal_Internal_Entity_Iterator'Access;

   function Next
     (T       : Internal_Entity_Iterator_Access;
      Element : out Internal_Entity) return Boolean;

   procedure Inc_Ref (T : Internal_Entity_Iterator_Access);
   procedure Dec_Ref (T : in out Internal_Entity_Iterator_Access);

      function Trace_Image (A : Internal_Entity_Iterator_Access) return String;

   procedure Free is new Ada.Unchecked_Deallocation
     (Internal_Internal_Entity_Iterator, Internal_Entity_Iterator_Access);


   ------------------------
   -- Named environments --
   ------------------------

   --  The goal of named environments is to provide a sound mechanism to
   --  associate nodes and environments across analysis units: nodes whose
   --  Self_Env comes from another unit ("foreign env"), environments whose
   --  parent comes from another unit (also foreign env), or that contain
   --  symbol/node mappings for nodes coming from other units ("foreign
   --  nodes").
   --
   --  This mechanism comes with the following requirements:
   --
   --  * Ensure that, after unit reparsing, all cross-unit associations are
   --    still valid. For instance, no node's Self_Env can refer to a lexical
   --    environment that has been deallocated.
   --
   --  * Ensure that regardless of the sequence of unit parsing/reparsing that
   --    led to a given set of units (considering only unit filename and source
   --    buffer), the node/env graph (i.e. the result of PLE) is always the
   --    same, i.e. make incremental PLE idempotent.
   --
   --  Note that even though the end goal for named envs is to replace the
   --  previous mechanism (proved to be unsound, as violating the second
   --  requirement), both still coexist during the transition period.
   --
   --  Here is how this mechanism works:
   --
   --  1. Environments can be assigned zero, one or several names (i.e. one or
   --     several symbols). Name(s) assignment happens at environment
   --     construction.
   --
   --  2. As a consequence, multiple environments can be associated to a given
   --     env name. Using a total and deterministic ordering predicate, only
   --     one of them is said to have "precedence": looking up an environment
   --     using that name will return this unique environment.
   --
   --  3. For a given env name, we keep track of all uses of the environment
   --     that is looked up by its name: environment parent link, symbol/node
   --     mapping addition, node's Self_Env assignment. This info is
   --     tracked using the Named_Env_Descriptor record type below, often
   --     abbreviated NED. Note that this tracking happens even when there is
   --     no environment associated to the env name, as we need to do such
   --     updates when an environment gets associated to that env name.
   --
   --  4. Unit reparsing can destroy existing environments and/or create new
   --     ones. This means that, depending on their "ranking" using the
   --     ordering predicate, environments can earn or lose precedence for a
   --     given name.
   --
   --  5. When the precedence changes for a given name, we use the info
   --     collected as per 3. to perform relocation: relevant environment
   --     parent links are updated, symbol/node mappings are removed from the
   --     env that lost precedence and added to the env that earned precedence,
   --     etc.

   --  Tables to populate lexical entries in named envs

   package NED_Assoc_Maps is new Ada.Containers.Hashed_Maps
     (Key_Type        => Symbol_Type,
      Element_Type    => Internal_Map_Node_Vectors.Vector,
      Hash            => Hash,
      Equivalent_Keys => "=",
      "="             => Internal_Map_Node_Vectors."=");
   --  Symbol/lexical env entry mappings for a given named env descriptor.
   --  Symbols are not unique in all mappings, so the lexical env entries are
   --  stored in a vector.

   procedure Add
     (Self : in out NED_Assoc_Maps.Map;
      Key  : Symbol_Type;
      Node : AST_Envs.Internal_Map_Node);
   --  Add a symbol/lexical env entry mapping in Self

   procedure Remove
     (Self : in out NED_Assoc_Maps.Map;
      Key  : Symbol_Type;
      Node : Bare_Ada_Node);
   --  Remove a symbol/lexical env entry mapping from Self

   --  Global table for named environments

   package Sorted_Env_Maps is new Ada.Containers.Ordered_Maps
     (Key_Type     => Bare_Ada_Node,
      Element_Type => Lexical_Env);
   --  List of lexical environments, sorted by owning node. This means that the
   --  following must be true for all cursors in such maps::
   --
   --     Key (Cur) = Element (Cur).Env.Node

   package Node_Sets is new Ada.Containers.Hashed_Sets
     (Element_Type        => Bare_Ada_Node,
      Hash                => Hash,
      Equivalent_Elements => "=");

   type Named_Env_Descriptor is record
      Name : Symbol_Type;
      --  Name corresponding to this descriptor. Useful during debugging.

      Envs : Sorted_Env_Maps.Map;
      --  For each env name, we can have one or several environments
      --  (concurrent definitions). Just like foreign nodes in lexical
      --  environments, we keep them sorted by node to preserve determinism:
      --  given a set of loaded units, we will always have the same set of
      --  name:env associations sorted in the same order and thus always the
      --  same results at lookup time.

      Env_With_Precedence : Lexical_Env;
      --  Named environment that has precedence for this name.
      --
      --  Most of the time, if Envs is empty, this is Empty_Env and otherwise,
      --  shortcut to Envs.First_Element. However, when a change in Envs
      --  invalidates Env_With_Precedence, we reset it to Empty_Env momentarily
      --  during PLE as a way to tag the temprorary inconsistency. Later on, we
      --  recompute it and perform the needed relocations.

      Foreign_Nodes : NED_Assoc_Maps.Map;
      --  This maps symbols to lists of env entries for all the foreign nodes
      --  in Env_With_Precedence.
      --
      --  This set allows efficient relocation of env entries when
      --  Env_With_Precedence changes.

      Foreign_Envs : Sorted_Env_Maps.Map;
      --  This maps the owning node to env mapping for all lexical environments
      --  whose parent must be Env_With_Precedence. Envs are indexed by owning
      --  node for quick lookup during updates.
      --
      --  This set allows efficient env parent link updates when
      --  Env_With_Precedence changes.

      Nodes_With_Foreign_Env : Node_Sets.Set;
      --  Set of nodes whose env (Self_Env) must be Env_With_Precedence.
      --
      --  This set allows efficient Self_Env updates when Env_With_Precedence
      --  changes.

      --  Note that during the updating process of a reparsed unit
      --  (Update_After_Reparse procedure), these data structures become
      --  temporarily inconsistent: Env_With_Precedence can become Empty_Env
      --  even though Envs is not empty.  This is fine, because when it does,
      --  Update_After_Reparse keeps track of it as to be updated
      --  (Named_Envs_Needing_Update map).
   end record;
   type Named_Env_Descriptor_Access is access Named_Env_Descriptor;
   procedure Destroy is new Ada.Unchecked_Deallocation
     (Named_Env_Descriptor, Named_Env_Descriptor_Access);

   package NED_Maps is new Ada.Containers.Hashed_Maps
     (Key_Type        => Symbol_Type,
      Element_Type    => Named_Env_Descriptor_Access,
      Hash            => Hash,
      Equivalent_Keys => "=");
   --  Context-wide table that tracks for all env names the set of lexical envs
   --  that define it.

   type Exiled_Entry_In_NED is record
      Named_Env : Named_Env_Descriptor_Access;
      --  Named env descriptor in which Node is registered

      Key : Symbol_Type;
      --  Key in that Env's internal map that leads to the env descriptor that
      --  contains Node.

      Node : Bare_Ada_Node;
      --  Exiled node
   end record;

   package Exiled_Entry_In_NED_Vectors is new
      Langkit_Support.Vectors (Exiled_Entry_In_NED);

   type Exiled_Env is record
      Named_Env : Named_Env_Descriptor_Access;
      --  Named env descriptor in which Env is registered

      Env : Lexical_Env;
      --  Exiled environment
   end record;

   package Exiled_Env_Vectors is new Langkit_Support.Vectors (Exiled_Env);

   type Named_Env_Pair is record
      Name : Symbol_Type;
      --  Name on the lexical environment

      Env  : Lexical_Env;
      --  Named lexical environment
   end record;

   package Named_Env_Vectors is new Langkit_Support.Vectors (Named_Env_Pair);

   --  High-level primitives to handle the life cycle of named environment

   function Get_Named_Env_Descriptor
     (Context : Internal_Context;
      Name    : Symbol_Type) return Named_Env_Descriptor_Access;
   --  Return the named env descriptor in Context corresponding to Name. Create
   --  it first, if needed.

   procedure Register_Named_Env
     (Context                   : Internal_Context;
      Name                      : Symbol_Type;
      Env                       : Lexical_Env;
      Named_Envs_Needing_Update : in out NED_Maps.Map);
   --  Register Name as the environment name for Env. If Env takes the
   --  precedence for this name, add Name/its named env descriptor to
   --  Named_Envs_Needing_Update.

   procedure Update_Named_Envs
     (Context : Internal_Context; Named_Envs : NED_Maps.Map);
   --  For each named environment in Named_Envs, update Env_With_Precedence and
   --  do the necessary adjustments: relocate exiled entries, etc.

   -------------------------------
   -- Tree traversal operations --
   -------------------------------

   Kind_To_Node_Children_Count : constant array (Ada_Node_Kind_Type) of Integer :=
     (Ada_Abort_Absent => 0, 
Ada_Abort_Present => 0, 
Ada_Abstract_Absent => 0, 
Ada_Abstract_Present => 0, 
Ada_Ada_Node_List => -1, 
Ada_Abstract_State_Decl_List => -1, 
Ada_Alternatives_List => -1, 
Ada_Constraint_List => -1, 
Ada_Decl_List => -1, 
Ada_Stmt_List => -1, 
Ada_Aspect_Assoc_List => -1, 
Ada_Base_Assoc_List => -1, 
Ada_Assoc_List => -1, 
Ada_Basic_Decl_List => -1, 
Ada_Case_Expr_Alternative_List => -1, 
Ada_Case_Stmt_Alternative_List => -1, 
Ada_Compilation_Unit_List => -1, 
Ada_Concat_Operand_List => -1, 
Ada_Contract_Case_Assoc_List => -1, 
Ada_Defining_Name_List => -1, 
Ada_Discriminant_Spec_List => -1, 
Ada_Elsif_Expr_Part_List => -1, 
Ada_Elsif_Stmt_Part_List => -1, 
Ada_Enum_Literal_Decl_List => -1, 
Ada_Expr_Alternatives_List => -1, 
Ada_Discriminant_Choice_List => -1, 
Ada_Name_List => -1, 
Ada_Parent_List => -1, 
Ada_Param_Spec_List => -1, 
Ada_Pragma_Node_List => -1, 
Ada_Select_When_Part_List => -1, 
Ada_Unconstrained_Array_Index_List => -1, 
Ada_Variant_List => -1, 
Ada_Aliased_Absent => 0, 
Ada_Aliased_Present => 0, 
Ada_All_Absent => 0, 
Ada_All_Present => 0, 
Ada_Constrained_Array_Indices => 1, 
Ada_Unconstrained_Array_Indices => 1, 
Ada_Aspect_Assoc => 2, 
Ada_At_Clause => 2, 
Ada_Attribute_Def_Clause => 2, 
Ada_Enum_Rep_Clause => 2, 
Ada_Record_Rep_Clause => 3, 
Ada_Aspect_Spec => 1, 
Ada_Contract_Case_Assoc => 2, 
Ada_Pragma_Argument_Assoc => 2, 
Ada_Entry_Spec => 3, 
Ada_Enum_Subp_Spec => 0, 
Ada_Subp_Spec => 4, 
Ada_Synthetic_Binary_Spec => 3, 
Ada_Synthetic_Unary_Spec => 2, 
Ada_Component_List => 2, 
Ada_Known_Discriminant_Part => 1, 
Ada_Unknown_Discriminant_Part => 0, 
Ada_Entry_Completion_Formal_Params => 1, 
Ada_Generic_Formal_Part => 1, 
Ada_Null_Record_Def => 1, 
Ada_Record_Def => 1, 
Ada_Aggregate_Assoc => 2, 
Ada_Multi_Dim_Array_Assoc => 2, 
Ada_Composite_Constraint_Assoc => 2, 
Ada_Iterated_Assoc => 2, 
Ada_Param_Assoc => 2, 
Ada_Abstract_State_Decl => 2, 
Ada_Anonymous_Expr_Decl => 1, 
Ada_Component_Decl => 4, 
Ada_Discriminant_Spec => 4, 
Ada_Generic_Formal_Obj_Decl => 1, 
Ada_Generic_Formal_Package => 1, 
Ada_Generic_Formal_Subp_Decl => 1, 
Ada_Generic_Formal_Type_Decl => 1, 
Ada_Param_Spec => 6, 
Ada_Synthetic_Formal_Param_Decl => 1, 
Ada_Generic_Package_Internal => 5, 
Ada_Package_Decl => 5, 
Ada_Discrete_Base_Subtype_Decl => 1, 
Ada_Subtype_Decl => 3, 
Ada_Classwide_Type_Decl => 1, 
Ada_Incomplete_Type_Decl => 2, 
Ada_Incomplete_Formal_Type_Decl => 4, 
Ada_Incomplete_Tagged_Type_Decl => 3, 
Ada_Protected_Type_Decl => 5, 
Ada_Task_Type_Decl => 4, 
Ada_Single_Task_Type_Decl => 4, 
Ada_Anonymous_Type_Decl => 3, 
Ada_Synth_Anonymous_Type_Decl => 3, 
Ada_Concrete_Type_Decl => 4, 
Ada_Formal_Type_Decl => 5, 
Ada_Abstract_Subp_Decl => 3, 
Ada_Abstract_Formal_Subp_Decl => 4, 
Ada_Concrete_Formal_Subp_Decl => 4, 
Ada_Subp_Decl => 3, 
Ada_Entry_Decl => 3, 
Ada_Enum_Literal_Decl => 1, 
Ada_Synthetic_Char_Enum_Lit => 1, 
Ada_Generic_Subp_Internal => 2, 
Ada_Synthetic_Subp_Decl => 1, 
Ada_Expr_Function => 4, 
Ada_Null_Subp_Decl => 3, 
Ada_Subp_Body => 6, 
Ada_Subp_Renaming_Decl => 4, 
Ada_Package_Body_Stub => 2, 
Ada_Protected_Body_Stub => 2, 
Ada_Subp_Body_Stub => 3, 
Ada_Task_Body_Stub => 2, 
Ada_Entry_Body => 8, 
Ada_Package_Body => 5, 
Ada_Protected_Body => 4, 
Ada_Task_Body => 5, 
Ada_Entry_Index_Spec => 3, 
Ada_Error_Decl => 0, 
Ada_Exception_Decl => 3, 
Ada_Exception_Handler => 3, 
Ada_For_Loop_Var_Decl => 2, 
Ada_Generic_Package_Decl => 2, 
Ada_Generic_Subp_Decl => 2, 
Ada_Generic_Package_Instantiation => 4, 
Ada_Generic_Subp_Instantiation => 6, 
Ada_Generic_Package_Renaming_Decl => 3, 
Ada_Generic_Subp_Renaming_Decl => 4, 
Ada_Label_Decl => 1, 
Ada_Named_Stmt_Decl => 1, 
Ada_Number_Decl => 2, 
Ada_Object_Decl => 8, 
Ada_Extended_Return_Stmt_Object_Decl => 8, 
Ada_No_Type_Object_Renaming_Decl => 8, 
Ada_Package_Renaming_Decl => 3, 
Ada_Single_Protected_Decl => 4, 
Ada_Single_Task_Decl => 1, 
Ada_Case_Stmt_Alternative => 2, 
Ada_Compilation_Unit => 3, 
Ada_Component_Clause => 3, 
Ada_Component_Def => 3, 
Ada_Constant_Absent => 0, 
Ada_Constant_Present => 0, 
Ada_Composite_Constraint => 1, 
Ada_Delta_Constraint => 2, 
Ada_Digits_Constraint => 2, 
Ada_Range_Constraint => 1, 
Ada_Declarative_Part => 1, 
Ada_Private_Part => 1, 
Ada_Public_Part => 1, 
Ada_Elsif_Expr_Part => 2, 
Ada_Elsif_Stmt_Part => 2, 
Ada_Abstract_State_Decl_Expr => 1, 
Ada_Allocator => 2, 
Ada_Aggregate => 2, 
Ada_Bracket_Aggregate => 2, 
Ada_Delta_Aggregate => 2, 
Ada_Bracket_Delta_Aggregate => 2, 
Ada_Null_Record_Aggregate => 2, 
Ada_Bin_Op => 3, 
Ada_Relation_Op => 3, 
Ada_Box_Expr => 0, 
Ada_Case_Expr_Alternative => 2, 
Ada_Concat_Op => 2, 
Ada_Concat_Operand => 2, 
Ada_Case_Expr => 2, 
Ada_If_Expr => 4, 
Ada_Contract_Cases => 1, 
Ada_Decl_Expr => 2, 
Ada_Membership_Expr => 3, 
Ada_Attribute_Ref => 3, 
Ada_Call_Expr => 2, 
Ada_Defining_Name => 1, 
Ada_Synthetic_Defining_Name => 1, 
Ada_Discrete_Subtype_Name => 1, 
Ada_Dotted_Name => 2, 
Ada_End_Name => 1, 
Ada_Explicit_Deref => 1, 
Ada_Qual_Expr => 2, 
Ada_Reduce_Attribute_Ref => 3, 
Ada_Char_Literal => 0, 
Ada_Identifier => 0, 
Ada_Op_Abs => 0, 
Ada_Op_And => 0, 
Ada_Op_And_Then => 0, 
Ada_Op_Concat => 0, 
Ada_Op_Div => 0, 
Ada_Op_Double_Dot => 0, 
Ada_Op_Eq => 0, 
Ada_Op_Gt => 0, 
Ada_Op_Gte => 0, 
Ada_Op_In => 0, 
Ada_Op_Lt => 0, 
Ada_Op_Lte => 0, 
Ada_Op_Minus => 0, 
Ada_Op_Mod => 0, 
Ada_Op_Mult => 0, 
Ada_Op_Neq => 0, 
Ada_Op_Not => 0, 
Ada_Op_Not_In => 0, 
Ada_Op_Or => 0, 
Ada_Op_Or_Else => 0, 
Ada_Op_Plus => 0, 
Ada_Op_Pow => 0, 
Ada_Op_Rem => 0, 
Ada_Op_Xor => 0, 
Ada_String_Literal => 0, 
Ada_Null_Literal => 0, 
Ada_Int_Literal => 0, 
Ada_Real_Literal => 0, 
Ada_Synthetic_Identifier => 0, 
Ada_Target_Name => 0, 
Ada_Update_Attribute_Ref => 3, 
Ada_Paren_Expr => 1, 
Ada_Quantified_Expr => 3, 
Ada_Raise_Expr => 2, 
Ada_Un_Op => 2, 
Ada_Handled_Stmts => 2, 
Ada_Interface_Kind_Limited => 0, 
Ada_Interface_Kind_Protected => 0, 
Ada_Interface_Kind_Synchronized => 0, 
Ada_Interface_Kind_Task => 0, 
Ada_Iter_Type_In => 0, 
Ada_Iter_Type_Of => 0, 
Ada_Library_Item => 2, 
Ada_Limited_Absent => 0, 
Ada_Limited_Present => 0, 
Ada_For_Loop_Spec => 5, 
Ada_While_Loop_Spec => 1, 
Ada_Mode_Default => 0, 
Ada_Mode_In => 0, 
Ada_Mode_In_Out => 0, 
Ada_Mode_Out => 0, 
Ada_Multi_Abstract_State_Decl => 1, 
Ada_Not_Null_Absent => 0, 
Ada_Not_Null_Present => 0, 
Ada_Null_Component_Decl => 0, 
Ada_Others_Designator => 0, 
Ada_Overriding_Not_Overriding => 0, 
Ada_Overriding_Overriding => 0, 
Ada_Overriding_Unspecified => 0, 
Ada_Params => 1, 
Ada_Paren_Abstract_State_Decl => 1, 
Ada_Pp_Else_Directive => 0, 
Ada_Pp_Elsif_Directive => 2, 
Ada_Pp_End_If_Directive => 0, 
Ada_Pp_If_Directive => 2, 
Ada_Pp_Then_Kw => 0, 
Ada_Pragma_Node => 2, 
Ada_Private_Absent => 0, 
Ada_Private_Present => 0, 
Ada_Protected_Def => 3, 
Ada_Protected_Absent => 0, 
Ada_Protected_Present => 0, 
Ada_Quantifier_All => 0, 
Ada_Quantifier_Some => 0, 
Ada_Range_Spec => 1, 
Ada_Renaming_Clause => 1, 
Ada_Synthetic_Renaming_Clause => 1, 
Ada_Reverse_Absent => 0, 
Ada_Reverse_Present => 0, 
Ada_Select_When_Part => 2, 
Ada_Accept_Stmt => 3, 
Ada_Accept_Stmt_With_Stmts => 5, 
Ada_For_Loop_Stmt => 3, 
Ada_Loop_Stmt => 3, 
Ada_While_Loop_Stmt => 3, 
Ada_Begin_Block => 2, 
Ada_Decl_Block => 3, 
Ada_Case_Stmt => 3, 
Ada_Extended_Return_Stmt => 2, 
Ada_If_Stmt => 4, 
Ada_Named_Stmt => 2, 
Ada_Select_Stmt => 3, 
Ada_Error_Stmt => 0, 
Ada_Abort_Stmt => 1, 
Ada_Assign_Stmt => 2, 
Ada_Call_Stmt => 1, 
Ada_Delay_Stmt => 2, 
Ada_Exit_Stmt => 2, 
Ada_Goto_Stmt => 1, 
Ada_Label => 1, 
Ada_Null_Stmt => 0, 
Ada_Raise_Stmt => 2, 
Ada_Requeue_Stmt => 2, 
Ada_Return_Stmt => 1, 
Ada_Terminate_Alternative => 0, 
Ada_Subp_Kind_Function => 0, 
Ada_Subp_Kind_Procedure => 0, 
Ada_Subunit => 2, 
Ada_Synchronized_Absent => 0, 
Ada_Synchronized_Present => 0, 
Ada_Tagged_Absent => 0, 
Ada_Tagged_Present => 0, 
Ada_Task_Def => 4, 
Ada_Type_Attributes_Repository => 0, 
Ada_Access_To_Subp_Def => 3, 
Ada_Anonymous_Type_Access_Def => 2, 
Ada_Type_Access_Def => 4, 
Ada_Array_Type_Def => 2, 
Ada_Derived_Type_Def => 7, 
Ada_Enum_Type_Def => 1, 
Ada_Formal_Discrete_Type_Def => 0, 
Ada_Interface_Type_Def => 2, 
Ada_Mod_Int_Type_Def => 1, 
Ada_Private_Type_Def => 3, 
Ada_Decimal_Fixed_Point_Def => 3, 
Ada_Floating_Point_Def => 2, 
Ada_Ordinary_Fixed_Point_Def => 2, 
Ada_Record_Type_Def => 4, 
Ada_Signed_Int_Type_Def => 1, 
Ada_Anonymous_Type => 1, 
Ada_Enum_Lit_Synth_Type_Expr => 0, 
Ada_Subtype_Indication => 3, 
Ada_Constrained_Subtype_Indication => 3, 
Ada_Discrete_Subtype_Indication => 3, 
Ada_Synthetic_Type_Expr => 1, 
Ada_Unconstrained_Array_Index => 1, 
Ada_Until_Absent => 0, 
Ada_Until_Present => 0, 
Ada_Use_Package_Clause => 1, 
Ada_Use_Type_Clause => 2, 
Ada_Value_Sequence => 1, 
Ada_Variant => 2, 
Ada_Variant_Part => 2, 
Ada_With_Clause => 3, 
Ada_With_Private_Absent => 0, 
Ada_With_Private_Present => 0);
   --  For each AST node kind, this array gives the number of AST node children
   --  it has. For AST node lists, this is -1 as this number varies from one
   --  list instance to another.

   function First_Child_Index (Node : Bare_Ada_Node) return Natural;
   --  Return the index of the first child Node has

   function Last_Child_Index (Node : Bare_Ada_Node) return Natural;
   --  Return the index of the last child Node has, or 0 if there is no child

   function Children_Count (Node : Bare_Ada_Node) return Natural;
   --  Return the number of children that Node has

   procedure Get_Child
     (Node            : Bare_Ada_Node;
      Index           : Positive;
      Index_In_Bounds : out Boolean;
      Result          : out Bare_Ada_Node);
   --  Return the Index'th child of node, storing it into Result.
   --
   --  Child indexing is 1-based. Store in Index_In_Bounds whether Node had
   --  such a child: if not (i.e. ``Index`` is out-of-bounds), set ``Result``
   --  to a null node.

   function Child
     (Node  : Bare_Ada_Node;
      Index : Positive) return Bare_Ada_Node;
   --  Return the Index'th child of Node, or null if Node has no such child

   function Children
     (Node : Bare_Ada_Node) return Internal_Bare_Ada_Node_Array;
   --  Return an array containing all the children of Node.
   --  This is an alternative to the Child/Children_Count pair, useful if you
   --  want the convenience of Ada arrays, and you don't care about the small
   --  performance hit of creating an array.

   function Parents
     (Node      : Bare_Ada_Node;
      With_Self : Boolean := True)
      return Bare_Ada_Node_Array_Access;
   --  Return an array that contains the lexical parents, this node included
   --  iff ``with_self`` is True. Nearer parents are first in the list.

   function Parent (Node : Bare_Ada_Node) return Bare_Ada_Node;

   function Fetch_Sibling
     (Node   : Bare_Ada_Node;
      Offset : Integer) return Bare_Ada_Node;
   function Fetch_Sibling
     (Node   : Bare_Ada_Node;
      E_Info : Internal_Entity_Info;
      Offset : Integer) return Internal_Entity;
   --  Assuming Node is the Nth child of its parent, return the (N + Offset)'th
   --  child of the same parent, or null/No_Entity if there is no such sibling.

   function Traverse
     (Node  : Bare_Ada_Node;
      Visit : access function (Node : Bare_Ada_Node) return Visit_Status)
      return Visit_Status;
   --  Given the parent node for a subtree, traverse all syntactic nodes of
   --  this tree, calling the given function on each node in prefix order (i.e.
   --  top-down). The order of traversing subtrees follows the order of
   --  declaration of the corresponding attributes in the grammar. The
   --  traversal is controlled as follows by the result returned by Visit:
   --
   --     Into   The traversal continues normally with the syntactic
   --            children of the node just processed.
   --
   --     Over   The children of the node just processed are skipped and
   --            excluded from the traversal, but otherwise processing
   --            continues elsewhere in the tree.
   --
   --     Stop   The entire traversal is immediately abandoned, and the
   --            original call to Traverse returns Stop.

   procedure Traverse
     (Node  : Bare_Ada_Node;
      Visit : access function (Node : Bare_Ada_Node)
                               return Visit_Status);
   --  This is the same as Traverse function except that no result is returned
   --  i.e. the Traverse function is called and the result is simply discarded.

   generic
      type Data_Type is private;
      Reset_After_Traversal : Boolean := False;
   function Traverse_With_Data
     (Node  : Bare_Ada_Node;
      Visit : access function (Node : Bare_Ada_Node;
                               Data : in out Data_Type)
                               return Visit_Status;
      Data  : in out Data_Type)
      return Visit_Status;
   --  This is the same as the first Traverse function except it accepts an
   --  argument that is passed to all Visit calls.
   --
   --  If Reset_After_Traversal is True, the Data formal is left unchanged when
   --  Traverse_With_Data returns no matter what Visit does. Visit can change
   --  it otherwise.

   ----------------------------------------
   -- Source location-related operations --
   ----------------------------------------

   function Sloc_Range
     (Node : Bare_Ada_Node) return Source_Location_Range;
   --  Return the source location range corresponding to the set of tokens from
   --  which Node was parsed.

   function Compare
     (Node : Bare_Ada_Node;
      Sloc : Source_Location) return Relative_Position;
   --  Compare Sloc to the sloc range of Node

   function Lookup
     (Node : Bare_Ada_Node;
      Sloc : Source_Location) return Bare_Ada_Node;
   --  Look for the bottom-most AST node whose sloc range contains Sloc. Return
   --  it, or null if no such node was found.

   function Compare
     (Self, Left, Right : Bare_Ada_Node;
      Relation          : Comparison_Relation) return Boolean;
   --  If ``Left`` and ``Right`` don't belong to the same analysis units or if
   --  one of them is null, raise a ``Property_Error`` (use ``Self`` to provide
   --  error context). Otherwise, return the comparison of their starting
   --  source location according to Relation.

   -------------------
   -- Debug helpers --
   -------------------

   function Image (Value : Boolean) return String;
   --  Image for a Boolean, for debugging/logging purposes

   procedure Print
     (Node        : Bare_Ada_Node;
      Show_Slocs  : Boolean;
      Line_Prefix : String := "");
   --  Debug helper: print to standard output Node and all its children.
   --  Line_Prefix is prepended to each output line.

   procedure PP_Trivia
     (Node        : Bare_Ada_Node;
      Line_Prefix : String := "");
   --  Debug helper: print to standard output Node and all its children along
   --  with the trivia associated to them. Line_Prefix is prepended to each
   --  output line.

   procedure Assign_Names_To_Logic_Vars (Node : Bare_Ada_Node);
   --  Debug helper: Assign names to every logical variable in the root node,
   --  so that we can trace logical variables.

   -------------------------------
   -- Root AST node (internals) --
   -------------------------------

   type Root_Node_Record (Kind : Ada_Node_Kind_Type) is record
      Parent : Bare_Ada_Node;
      --  Reference to the parent node, or null if this is the root one

      Unit : Internal_Unit;
      --  Reference to the analysis unit that owns this node

      Token_Start_Index : Token_Index;
      Token_End_Index   : Token_Index;
      --  Reference to the start and end token that constitutes this node. If
      --  this node is a ghost, Token_Start_Index is the token that this AST
      --  node relates to and Token_End_Index is No_Token_Index. Otherwise,
      --  both tokens are inclusive, i.e. they both belong to this node.

      Self_Env : Lexical_Env;
      --  Hold the environment this node defines, or the parent environment
      --  otherwise.

      Last_Attempted_Child : Integer;
      --  0-based index for the last child we tried to parse for this node. -1
      --  if parsing for all children was successful.

      

      
         



         


            case Kind is
                  when Ada_Abort_Node =>
                     
         



         


            case Kind is
                  when Ada_Abort_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Abort_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Abstract_Node =>
                     
         



         


            case Kind is
                  when Ada_Abstract_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Abstract_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Ada_List =>
                     
         

            Count : Natural;
            Nodes : Alloc_AST_List_Array.Element_Array_Access;


         


            case Kind is
                  when Ada_Ada_Node_List_Range =>
                     
         



         


            case Kind is
                  when Ada_Abstract_State_Decl_List_Range =>
                     
         



         



            null;
      
                  when Ada_Alternatives_List_Range =>
                     
         



         



            null;
      
                  when Ada_Constraint_List_Range =>
                     
         



         



            null;
      
                  when Ada_Decl_List_Range =>
                     
         



         



            null;
      
                  when Ada_Stmt_List_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Aspect_Assoc_List_Range =>
                     
         



         



            null;
      
                  when Ada_Base_Assoc_List_Range =>
                     
         



         



            null;
      
                  when Ada_Basic_Assoc_List =>
                     
         



         


            case Kind is
                  when Ada_Assoc_List_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Basic_Decl_List_Range =>
                     
         



         



            null;
      
                  when Ada_Case_Expr_Alternative_List_Range =>
                     
         



         



            null;
      
                  when Ada_Case_Stmt_Alternative_List_Range =>
                     
         



         



            null;
      
                  when Ada_Compilation_Unit_List_Range =>
                     
         



         



            null;
      
                  when Ada_Concat_Operand_List_Range =>
                     
         



         



            null;
      
                  when Ada_Contract_Case_Assoc_List_Range =>
                     
         



         



            null;
      
                  when Ada_Defining_Name_List_Range =>
                     
         



         



            null;
      
                  when Ada_Discriminant_Spec_List_Range =>
                     
         



         



            null;
      
                  when Ada_Elsif_Expr_Part_List_Range =>
                     
         



         



            null;
      
                  when Ada_Elsif_Stmt_Part_List_Range =>
                     
         



         



            null;
      
                  when Ada_Enum_Literal_Decl_List_Range =>
                     
         



         



            null;
      
                  when Ada_Expr_List =>
                     
         



         


            case Kind is
                  when Ada_Expr_Alternatives_List_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Identifier_List =>
                     
         



         


            case Kind is
                  when Ada_Discriminant_Choice_List_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Name_List_Range =>
                     
         



         


            case Kind is
                  when Ada_Parent_List_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Param_Spec_List_Range =>
                     
         



         



            null;
      
                  when Ada_Pragma_Node_List_Range =>
                     
         



         



            null;
      
                  when Ada_Select_When_Part_List_Range =>
                     
         



         



            null;
      
                  when Ada_Unconstrained_Array_Index_List_Range =>
                     
         



         



            null;
      
                  when Ada_Variant_List_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Aliased_Node =>
                     
         



         


            case Kind is
                  when Ada_Aliased_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Aliased_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_All_Node =>
                     
         



         


            case Kind is
                  when Ada_All_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_All_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Array_Indices =>
                     
         



         


            case Kind is
                  when Ada_Constrained_Array_Indices_Range =>
                     
         


            Constrained_Array_Indices_F_List : aliased Bare_Constraint_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Unconstrained_Array_Indices_Range =>
                     
         


            Unconstrained_Array_Indices_F_Types : aliased Bare_Unconstrained_Array_Index_List :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Aspect_Assoc_Range =>
                     
         


            Aspect_Assoc_F_Id : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Aspect_Assoc_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Aspect_Clause =>
                     
         



         


            case Kind is
                  when Ada_At_Clause_Range =>
                     
         


            At_Clause_F_Name : aliased Bare_Base_Id :=
               No_Bare_Ada_Node;
            At_Clause_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Attribute_Def_Clause_Range =>
                     
         


            Attribute_Def_Clause_F_Attribute_Expr : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Attribute_Def_Clause_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Enum_Rep_Clause_Range =>
                     
         


            Enum_Rep_Clause_F_Type_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Enum_Rep_Clause_F_Aggregate : aliased Bare_Base_Aggregate :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Record_Rep_Clause_Range =>
                     
         


            Record_Rep_Clause_F_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Record_Rep_Clause_F_At_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Record_Rep_Clause_F_Components : aliased Bare_Ada_Node_List :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Aspect_Spec_Range =>
                     
         


            Aspect_Spec_F_Aspect_Assocs : aliased Bare_Aspect_Assoc_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Base_Assoc =>
                     
         



         


            case Kind is
                  when Ada_Contract_Case_Assoc_Range =>
                     
         


            Contract_Case_Assoc_F_Guard : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;
            Contract_Case_Assoc_F_Consequence : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Pragma_Argument_Assoc_Range =>
                     
         


            Pragma_Argument_Assoc_F_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Pragma_Argument_Assoc_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Base_Formal_Param_Holder =>
                     
         



         


            case Kind is
                  when Ada_Base_Subp_Spec =>
                     
         



         


            case Kind is
                  when Ada_Entry_Spec_Range =>
                     
         


            Entry_Spec_F_Entry_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Entry_Spec_F_Family_Type : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;
            Entry_Spec_F_Entry_Params : aliased Bare_Params :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Enum_Subp_Spec_Range =>
                     
         



         



            null;
      
                  when Ada_Subp_Spec_Range =>
                     
         


            Subp_Spec_F_Subp_Kind : aliased Bare_Subp_Kind :=
               No_Bare_Ada_Node;
            Subp_Spec_F_Subp_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Subp_Spec_F_Subp_Params : aliased Bare_Params :=
               No_Bare_Ada_Node;
            Subp_Spec_F_Subp_Returns : aliased Bare_Type_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Synthetic_Binary_Spec_Range =>
                     
         


            Synthetic_Binary_Spec_Subp_Symbol : aliased Symbol_Type :=
               null;
            Synthetic_Binary_Spec_F_Left_Param : aliased Bare_Synthetic_Formal_Param_Decl :=
               No_Bare_Ada_Node;
            Synthetic_Binary_Spec_F_Right_Param : aliased Bare_Synthetic_Formal_Param_Decl :=
               No_Bare_Ada_Node;
            Synthetic_Binary_Spec_F_Return_Type_Expr : aliased Bare_Type_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Synthetic_Unary_Spec_Range =>
                     
         


            Synthetic_Unary_Spec_Subp_Symbol : aliased Symbol_Type :=
               null;
            Synthetic_Unary_Spec_F_Right_Param : aliased Bare_Synthetic_Formal_Param_Decl :=
               No_Bare_Ada_Node;
            Synthetic_Unary_Spec_F_Return_Type_Expr : aliased Bare_Synthetic_Type_Expr :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Component_List_Range =>
                     
         


            Component_List_F_Components : aliased Bare_Ada_Node_List :=
               No_Bare_Ada_Node;
            Component_List_F_Variant_Part : aliased Bare_Variant_Part :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Discriminant_Part =>
                     
         



         


            case Kind is
                  when Ada_Known_Discriminant_Part_Range =>
                     
         


            Known_Discriminant_Part_F_Discr_Specs : aliased Bare_Discriminant_Spec_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Unknown_Discriminant_Part_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Entry_Completion_Formal_Params_Range =>
                     
         


            Entry_Completion_Formal_Params_F_Params : aliased Bare_Params :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Generic_Formal_Part_Range =>
                     
         


            Generic_Formal_Part_F_Decls : aliased Bare_Ada_Node_List :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Base_Record_Def =>
                     
         


            Base_Record_Def_F_Components : aliased Bare_Component_List :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Null_Record_Def_Range =>
                     
         



         



            null;
      
                  when Ada_Record_Def_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Basic_Assoc =>
                     
         



         


            case Kind is
                  when Ada_Aggregate_Assoc_Range =>
                     
         


            Aggregate_Assoc_F_Designators : aliased Bare_Alternatives_List :=
               No_Bare_Ada_Node;
            Aggregate_Assoc_F_R_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Multi_Dim_Array_Assoc_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Composite_Constraint_Assoc_Range =>
                     
         


            Composite_Constraint_Assoc_F_Ids : aliased Bare_Discriminant_Choice_List :=
               No_Bare_Ada_Node;
            Composite_Constraint_Assoc_F_Constraint_Expr : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Iterated_Assoc_Range =>
                     
         


            Iterated_Assoc_F_Spec : aliased Bare_For_Loop_Spec :=
               No_Bare_Ada_Node;
            Iterated_Assoc_F_R_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Param_Assoc_Range =>
                     
         


            Param_Assoc_F_Designator : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;
            Param_Assoc_F_R_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Basic_Decl =>
                     
         



         


            case Kind is
                  when Ada_Abstract_State_Decl_Range =>
                     
         


            Abstract_State_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Abstract_State_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Anonymous_Expr_Decl_Range =>
                     
         


            Anonymous_Expr_Decl_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Base_Formal_Param_Decl =>
                     
         



         


            case Kind is
                  when Ada_Component_Decl_Range =>
                     
         


            Component_Decl_F_Ids : aliased Bare_Defining_Name_List :=
               No_Bare_Ada_Node;
            Component_Decl_F_Component_Def : aliased Bare_Component_Def :=
               No_Bare_Ada_Node;
            Component_Decl_F_Default_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Component_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Discriminant_Spec_Range =>
                     
         


            Discriminant_Spec_F_Ids : aliased Bare_Defining_Name_List :=
               No_Bare_Ada_Node;
            Discriminant_Spec_F_Type_Expr : aliased Bare_Type_Expr :=
               No_Bare_Ada_Node;
            Discriminant_Spec_F_Default_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Discriminant_Spec_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Generic_Formal =>
                     
         


            Generic_Formal_F_Decl : aliased Bare_Basic_Decl :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Generic_Formal_Obj_Decl_Range =>
                     
         



         



            null;
      
                  when Ada_Generic_Formal_Package_Range =>
                     
         



         



            null;
      
                  when Ada_Generic_Formal_Subp_Decl_Range =>
                     
         



         



            null;
      
                  when Ada_Generic_Formal_Type_Decl_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Param_Spec_Range =>
                     
         


            Param_Spec_F_Ids : aliased Bare_Defining_Name_List :=
               No_Bare_Ada_Node;
            Param_Spec_F_Has_Aliased : aliased Bare_Aliased_Node :=
               No_Bare_Ada_Node;
            Param_Spec_F_Mode : aliased Bare_Mode :=
               No_Bare_Ada_Node;
            Param_Spec_F_Type_Expr : aliased Bare_Type_Expr :=
               No_Bare_Ada_Node;
            Param_Spec_F_Default_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Param_Spec_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Synthetic_Formal_Param_Decl_Range =>
                     
         


            Synthetic_Formal_Param_Decl_Param_Name : aliased Symbol_Type :=
               null;
            Synthetic_Formal_Param_Decl_F_Param_Type : aliased Bare_Type_Expr :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Base_Package_Decl =>
                     
         


            Base_Package_Decl_F_Package_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Base_Package_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Base_Package_Decl_F_Public_Part : aliased Bare_Public_Part :=
               No_Bare_Ada_Node;
            Base_Package_Decl_F_Private_Part : aliased Bare_Private_Part :=
               No_Bare_Ada_Node;
            Base_Package_Decl_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Generic_Package_Internal_Range =>
                     
         



         



            null;
      
                  when Ada_Package_Decl_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Base_Type_Decl =>
                     
         


            Base_Type_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Lf_Present_Attributes_Repo : aliased Boolean :=
               False;
            Lf_Stg_Attributes_Repo : aliased Bare_Type_Attributes_Repository :=
               No_Bare_Ada_Node;
            Lf_Present_Dottable_Subps_Env : aliased Boolean :=
               False;
            Lf_Stg_Dottable_Subps_Env : aliased Lexical_Env :=
               Empty_Env;

         


            case Kind is
                  when Ada_Base_Subtype_Decl =>
                     
         



         


            case Kind is
                  when Ada_Discrete_Base_Subtype_Decl_Range =>
                     
         



         



            null;
      
                  when Ada_Subtype_Decl_Range =>
                     
         


            Subtype_Decl_F_Subtype : aliased Bare_Subtype_Indication :=
               No_Bare_Ada_Node;
            Subtype_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Classwide_Type_Decl_Range =>
                     
         



         



            null;
      
                  when Ada_Incomplete_Type_Decl_Range =>
                     
         


            Incomplete_Type_Decl_F_Discriminants : aliased Bare_Discriminant_Part :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Incomplete_Formal_Type_Decl_Range =>
                     
         


            Incomplete_Formal_Type_Decl_F_Is_Tagged : aliased Bare_Tagged_Node :=
               No_Bare_Ada_Node;
            Incomplete_Formal_Type_Decl_F_Default_Type : aliased Bare_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Incomplete_Tagged_Type_Decl_Range =>
                     
         


            Incomplete_Tagged_Type_Decl_F_Has_Abstract : aliased Bare_Abstract_Node :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Protected_Type_Decl_Range =>
                     
         


            Protected_Type_Decl_F_Discriminants : aliased Bare_Discriminant_Part :=
               No_Bare_Ada_Node;
            Protected_Type_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Protected_Type_Decl_F_Interfaces : aliased Bare_Parent_List :=
               No_Bare_Ada_Node;
            Protected_Type_Decl_F_Definition : aliased Bare_Protected_Def :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Task_Type_Decl_Range =>
                     
         


            Task_Type_Decl_F_Discriminants : aliased Bare_Discriminant_Part :=
               No_Bare_Ada_Node;
            Task_Type_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Task_Type_Decl_F_Definition : aliased Bare_Task_Def :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Single_Task_Type_Decl_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Type_Decl =>
                     
         


            Type_Decl_F_Discriminants : aliased Bare_Discriminant_Part :=
               No_Bare_Ada_Node;
            Type_Decl_F_Type_Def : aliased Bare_Type_Def :=
               No_Bare_Ada_Node;
            Lf_Present_Direct_Primitives_Env : aliased Boolean :=
               False;
            Lf_Stg_Direct_Primitives_Env : aliased Lexical_Env :=
               Empty_Env;
            Lf_Present_Direct_Primitive_Subps : aliased Boolean :=
               False;
            Lf_Stg_Direct_Primitive_Subps : aliased Internal_Inner_Env_Assoc_Array_Access :=
               No_Internal_Inner_Env_Assoc_Array_Type;

         


            case Kind is
                  when Ada_Anonymous_Type_Decl_Range =>
                     
         



         


            case Kind is
                  when Ada_Synth_Anonymous_Type_Decl_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Concrete_Type_Decl_Range =>
                     
         


            Concrete_Type_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Formal_Type_Decl_Range =>
                     
         


            Formal_Type_Decl_F_Default_Type : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Formal_Type_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
               when others => null;
            end case;

      
                  when Ada_Basic_Subp_Decl =>
                     
         



         


            case Kind is
                  when Ada_Classic_Subp_Decl =>
                     
         


            Classic_Subp_Decl_F_Overriding : aliased Bare_Overriding_Node :=
               No_Bare_Ada_Node;
            Classic_Subp_Decl_F_Subp_Spec : aliased Bare_Subp_Spec :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Abstract_Subp_Decl_Range =>
                     
         


            Abstract_Subp_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Formal_Subp_Decl =>
                     
         


            Formal_Subp_Decl_F_Default_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Formal_Subp_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Abstract_Formal_Subp_Decl_Range =>
                     
         



         



            null;
      
                  when Ada_Concrete_Formal_Subp_Decl_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Subp_Decl_Range =>
                     
         


            Subp_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Entry_Decl_Range =>
                     
         


            Entry_Decl_F_Overriding : aliased Bare_Overriding_Node :=
               No_Bare_Ada_Node;
            Entry_Decl_F_Spec : aliased Bare_Entry_Spec :=
               No_Bare_Ada_Node;
            Entry_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Enum_Literal_Decl_Range =>
                     
         


            Enum_Literal_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Synthetic_Char_Enum_Lit_Range =>
                     
         


            Synthetic_Char_Enum_Lit_Char_Symbol : aliased Symbol_Type :=
               null;
            Synthetic_Char_Enum_Lit_Enum_Type_Decl : aliased Internal_Entity_Type_Decl :=
               No_Entity_Type_Decl;

         



      
               when others => null;
            end case;

      
                  when Ada_Generic_Subp_Internal_Range =>
                     
         


            Generic_Subp_Internal_F_Subp_Spec : aliased Bare_Subp_Spec :=
               No_Bare_Ada_Node;
            Generic_Subp_Internal_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Synthetic_Subp_Decl_Range =>
                     
         


            Synthetic_Subp_Decl_F_Spec : aliased Bare_Base_Subp_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Body_Node =>
                     
         



         


            case Kind is
                  when Ada_Base_Subp_Body =>
                     
         


            Base_Subp_Body_F_Overriding : aliased Bare_Overriding_Node :=
               No_Bare_Ada_Node;
            Base_Subp_Body_F_Subp_Spec : aliased Bare_Subp_Spec :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Expr_Function_Range =>
                     
         


            Expr_Function_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Expr_Function_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Null_Subp_Decl_Range =>
                     
         


            Null_Subp_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Subp_Body_Range =>
                     
         


            Subp_Body_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Subp_Body_F_Decls : aliased Bare_Declarative_Part :=
               No_Bare_Ada_Node;
            Subp_Body_F_Stmts : aliased Bare_Handled_Stmts :=
               No_Bare_Ada_Node;
            Subp_Body_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Subp_Renaming_Decl_Range =>
                     
         


            Subp_Renaming_Decl_F_Renames : aliased Bare_Renaming_Clause :=
               No_Bare_Ada_Node;
            Subp_Renaming_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Body_Stub =>
                     
         



         


            case Kind is
                  when Ada_Package_Body_Stub_Range =>
                     
         


            Package_Body_Stub_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Package_Body_Stub_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Protected_Body_Stub_Range =>
                     
         


            Protected_Body_Stub_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Protected_Body_Stub_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Subp_Body_Stub_Range =>
                     
         


            Subp_Body_Stub_F_Overriding : aliased Bare_Overriding_Node :=
               No_Bare_Ada_Node;
            Subp_Body_Stub_F_Subp_Spec : aliased Bare_Subp_Spec :=
               No_Bare_Ada_Node;
            Subp_Body_Stub_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Task_Body_Stub_Range =>
                     
         


            Task_Body_Stub_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Task_Body_Stub_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Entry_Body_Range =>
                     
         


            Entry_Body_F_Entry_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Entry_Body_F_Index_Spec : aliased Bare_Entry_Index_Spec :=
               No_Bare_Ada_Node;
            Entry_Body_F_Params : aliased Bare_Entry_Completion_Formal_Params :=
               No_Bare_Ada_Node;
            Entry_Body_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Entry_Body_F_Barrier : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Entry_Body_F_Decls : aliased Bare_Declarative_Part :=
               No_Bare_Ada_Node;
            Entry_Body_F_Stmts : aliased Bare_Handled_Stmts :=
               No_Bare_Ada_Node;
            Entry_Body_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Package_Body_Range =>
                     
         


            Package_Body_F_Package_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Package_Body_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Package_Body_F_Decls : aliased Bare_Declarative_Part :=
               No_Bare_Ada_Node;
            Package_Body_F_Stmts : aliased Bare_Handled_Stmts :=
               No_Bare_Ada_Node;
            Package_Body_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Protected_Body_Range =>
                     
         


            Protected_Body_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Protected_Body_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Protected_Body_F_Decls : aliased Bare_Declarative_Part :=
               No_Bare_Ada_Node;
            Protected_Body_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Task_Body_Range =>
                     
         


            Task_Body_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Task_Body_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Task_Body_F_Decls : aliased Bare_Declarative_Part :=
               No_Bare_Ada_Node;
            Task_Body_F_Stmts : aliased Bare_Handled_Stmts :=
               No_Bare_Ada_Node;
            Task_Body_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Entry_Index_Spec_Range =>
                     
         


            Entry_Index_Spec_F_Id : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Entry_Index_Spec_F_Subtype : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;
            Entry_Index_Spec_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Error_Decl_Range =>
                     
         



         



            null;
      
                  when Ada_Exception_Decl_Range =>
                     
         


            Exception_Decl_F_Ids : aliased Bare_Defining_Name_List :=
               No_Bare_Ada_Node;
            Exception_Decl_F_Renames : aliased Bare_Renaming_Clause :=
               No_Bare_Ada_Node;
            Exception_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Exception_Handler_Range =>
                     
         


            Exception_Handler_F_Exception_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Exception_Handler_F_Handled_Exceptions : aliased Bare_Alternatives_List :=
               No_Bare_Ada_Node;
            Exception_Handler_F_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_For_Loop_Var_Decl_Range =>
                     
         


            For_Loop_Var_Decl_F_Id : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            For_Loop_Var_Decl_F_Id_Type : aliased Bare_Type_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Generic_Decl =>
                     
         


            Generic_Decl_F_Formal_Part : aliased Bare_Generic_Formal_Part :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Generic_Package_Decl_Range =>
                     
         


            Generic_Package_Decl_F_Package_Decl : aliased Bare_Generic_Package_Internal :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Generic_Subp_Decl_Range =>
                     
         


            Generic_Subp_Decl_F_Subp_Decl : aliased Bare_Generic_Subp_Internal :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Generic_Instantiation =>
                     
         


            Lf_Present_Instantiation_Env : aliased Boolean :=
               False;
            Lf_Stg_Instantiation_Env : aliased Lexical_Env :=
               Empty_Env;
            Lf_Present_Actual_Expr_Decls : aliased Boolean :=
               False;
            Lf_Stg_Actual_Expr_Decls : aliased Bare_Anonymous_Expr_Decl_Array_Access :=
               No_Bare_Anonymous_Expr_Decl_Array_Type;

         


            case Kind is
                  when Ada_Generic_Package_Instantiation_Range =>
                     
         


            Generic_Package_Instantiation_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Generic_Package_Instantiation_F_Generic_Pkg_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Generic_Package_Instantiation_F_Params : aliased Bare_Assoc_List :=
               No_Bare_Ada_Node;
            Generic_Package_Instantiation_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Generic_Subp_Instantiation_Range =>
                     
         


            Generic_Subp_Instantiation_F_Overriding : aliased Bare_Overriding_Node :=
               No_Bare_Ada_Node;
            Generic_Subp_Instantiation_F_Kind : aliased Bare_Subp_Kind :=
               No_Bare_Ada_Node;
            Generic_Subp_Instantiation_F_Subp_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Generic_Subp_Instantiation_F_Generic_Subp_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Generic_Subp_Instantiation_F_Params : aliased Bare_Assoc_List :=
               No_Bare_Ada_Node;
            Generic_Subp_Instantiation_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Generic_Renaming_Decl =>
                     
         



         


            case Kind is
                  when Ada_Generic_Package_Renaming_Decl_Range =>
                     
         


            Generic_Package_Renaming_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Generic_Package_Renaming_Decl_F_Renames : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Generic_Package_Renaming_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Generic_Subp_Renaming_Decl_Range =>
                     
         


            Generic_Subp_Renaming_Decl_F_Kind : aliased Bare_Subp_Kind :=
               No_Bare_Ada_Node;
            Generic_Subp_Renaming_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Generic_Subp_Renaming_Decl_F_Renames : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Generic_Subp_Renaming_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Label_Decl_Range =>
                     
         


            Label_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Named_Stmt_Decl_Range =>
                     
         


            Named_Stmt_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Number_Decl_Range =>
                     
         


            Number_Decl_F_Ids : aliased Bare_Defining_Name_List :=
               No_Bare_Ada_Node;
            Number_Decl_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Object_Decl_Range =>
                     
         


            Object_Decl_F_Ids : aliased Bare_Defining_Name_List :=
               No_Bare_Ada_Node;
            Object_Decl_F_Has_Aliased : aliased Bare_Aliased_Node :=
               No_Bare_Ada_Node;
            Object_Decl_F_Has_Constant : aliased Bare_Constant_Node :=
               No_Bare_Ada_Node;
            Object_Decl_F_Mode : aliased Bare_Mode :=
               No_Bare_Ada_Node;
            Object_Decl_F_Type_Expr : aliased Bare_Type_Expr :=
               No_Bare_Ada_Node;
            Object_Decl_F_Default_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Object_Decl_F_Renaming_Clause : aliased Bare_Renaming_Clause :=
               No_Bare_Ada_Node;
            Object_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Extended_Return_Stmt_Object_Decl_Range =>
                     
         



         



            null;
      
                  when Ada_No_Type_Object_Renaming_Decl_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Package_Renaming_Decl_Range =>
                     
         


            Package_Renaming_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Package_Renaming_Decl_F_Renames : aliased Bare_Renaming_Clause :=
               No_Bare_Ada_Node;
            Package_Renaming_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Single_Protected_Decl_Range =>
                     
         


            Single_Protected_Decl_F_Name : aliased Bare_Defining_Name :=
               No_Bare_Ada_Node;
            Single_Protected_Decl_F_Aspects : aliased Bare_Aspect_Spec :=
               No_Bare_Ada_Node;
            Single_Protected_Decl_F_Interfaces : aliased Bare_Parent_List :=
               No_Bare_Ada_Node;
            Single_Protected_Decl_F_Definition : aliased Bare_Protected_Def :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Single_Task_Decl_Range =>
                     
         


            Single_Task_Decl_F_Task_Type : aliased Bare_Single_Task_Type_Decl :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Case_Stmt_Alternative_Range =>
                     
         


            Case_Stmt_Alternative_F_Choices : aliased Bare_Alternatives_List :=
               No_Bare_Ada_Node;
            Case_Stmt_Alternative_F_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Compilation_Unit_Range =>
                     
         


            Compilation_Unit_F_Prelude : aliased Bare_Ada_Node_List :=
               No_Bare_Ada_Node;
            Compilation_Unit_F_Body : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;
            Compilation_Unit_F_Pragmas : aliased Bare_Pragma_Node_List :=
               No_Bare_Ada_Node;
            Compilation_Unit_No_Env : aliased Lexical_Env :=
               Empty_Env;

         



      
                  when Ada_Component_Clause_Range =>
                     
         


            Component_Clause_F_Id : aliased Bare_Identifier :=
               No_Bare_Ada_Node;
            Component_Clause_F_Position : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Component_Clause_F_Range : aliased Bare_Range_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Component_Def_Range =>
                     
         


            Component_Def_F_Has_Aliased : aliased Bare_Aliased_Node :=
               No_Bare_Ada_Node;
            Component_Def_F_Has_Constant : aliased Bare_Constant_Node :=
               No_Bare_Ada_Node;
            Component_Def_F_Type_Expr : aliased Bare_Type_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Constant_Node =>
                     
         



         


            case Kind is
                  when Ada_Constant_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Constant_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Constraint =>
                     
         



         


            case Kind is
                  when Ada_Composite_Constraint_Range =>
                     
         


            Composite_Constraint_F_Constraints : aliased Bare_Assoc_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Delta_Constraint_Range =>
                     
         


            Delta_Constraint_F_Digits : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Delta_Constraint_F_Range : aliased Bare_Range_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Digits_Constraint_Range =>
                     
         


            Digits_Constraint_F_Digits : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Digits_Constraint_F_Range : aliased Bare_Range_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Range_Constraint_Range =>
                     
         


            Range_Constraint_F_Range : aliased Bare_Range_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Declarative_Part_Range =>
                     
         


            Declarative_Part_F_Decls : aliased Bare_Ada_Node_List :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Private_Part_Range =>
                     
         



         



            null;
      
                  when Ada_Public_Part_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Elsif_Expr_Part_Range =>
                     
         


            Elsif_Expr_Part_F_Cond_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Elsif_Expr_Part_F_Then_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Elsif_Stmt_Part_Range =>
                     
         


            Elsif_Stmt_Part_F_Cond_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Elsif_Stmt_Part_F_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Expr =>
                     
         


            Expr_Logic_Vars : aliased Address :=
               System.Null_Address;

         


            case Kind is
                  when Ada_Abstract_State_Decl_Expr_Range =>
                     
         


            Abstract_State_Decl_Expr_F_State_Decl : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Allocator_Range =>
                     
         


            Allocator_F_Subpool : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Allocator_F_Type_Or_Expr : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Base_Aggregate =>
                     
         


            Base_Aggregate_F_Ancestor_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Base_Aggregate_F_Assocs : aliased Bare_Assoc_List :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Aggregate_Range =>
                     
         



         


            case Kind is
                  when Ada_Bracket_Aggregate_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Delta_Aggregate_Range =>
                     
         



         


            case Kind is
                  when Ada_Bracket_Delta_Aggregate_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Null_Record_Aggregate_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Bin_Op_Range =>
                     
         


            Bin_Op_F_Left : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Bin_Op_F_Op : aliased Bare_Op :=
               No_Bare_Ada_Node;
            Bin_Op_F_Right : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Relation_Op_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Box_Expr_Range =>
                     
         



         



            null;
      
                  when Ada_Case_Expr_Alternative_Range =>
                     
         


            Case_Expr_Alternative_F_Choices : aliased Bare_Alternatives_List :=
               No_Bare_Ada_Node;
            Case_Expr_Alternative_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Concat_Op_Range =>
                     
         


            Concat_Op_F_First_Operand : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Concat_Op_F_Other_Operands : aliased Bare_Concat_Operand_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Concat_Operand_Range =>
                     
         


            Concat_Operand_F_Operator : aliased Bare_Op_Concat :=
               No_Bare_Ada_Node;
            Concat_Operand_F_Operand : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Cond_Expr =>
                     
         



         


            case Kind is
                  when Ada_Case_Expr_Range =>
                     
         


            Case_Expr_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Case_Expr_F_Cases : aliased Bare_Case_Expr_Alternative_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_If_Expr_Range =>
                     
         


            If_Expr_F_Cond_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            If_Expr_F_Then_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            If_Expr_F_Alternatives : aliased Bare_Elsif_Expr_Part_List :=
               No_Bare_Ada_Node;
            If_Expr_F_Else_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Contract_Cases_Range =>
                     
         


            Contract_Cases_F_Contract_Cases : aliased Bare_Contract_Case_Assoc_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Decl_Expr_Range =>
                     
         


            Decl_Expr_F_Decls : aliased Bare_Basic_Decl_List :=
               No_Bare_Ada_Node;
            Decl_Expr_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Membership_Expr_Range =>
                     
         


            Membership_Expr_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Membership_Expr_F_Op : aliased Bare_Op :=
               No_Bare_Ada_Node;
            Membership_Expr_F_Membership_Exprs : aliased Bare_Expr_Alternatives_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Name =>
                     
         



         


            case Kind is
                  when Ada_Attribute_Ref_Range =>
                     
         


            Attribute_Ref_F_Prefix : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Attribute_Ref_F_Attribute : aliased Bare_Identifier :=
               No_Bare_Ada_Node;
            Attribute_Ref_F_Args : aliased Bare_Assoc_List :=
               No_Bare_Ada_Node;
            Attribute_Ref_R_Ref_Var : aliased Logic_Var_Record :=
               Null_Var_Record;

         



      
                  when Ada_Call_Expr_Range =>
                     
         


            Call_Expr_F_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Call_Expr_F_Suffix : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;
            Call_Expr_R_Called_Spec : aliased Logic_Var_Record :=
               Null_Var_Record;

         



      
                  when Ada_Defining_Name_Range =>
                     
         


            Defining_Name_F_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Synthetic_Defining_Name_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Discrete_Subtype_Name_Range =>
                     
         


            Discrete_Subtype_Name_F_Subtype : aliased Bare_Discrete_Subtype_Indication :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Dotted_Name_Range =>
                     
         


            Dotted_Name_F_Prefix : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Dotted_Name_F_Suffix : aliased Bare_Base_Id :=
               No_Bare_Ada_Node;

         



      
                  when Ada_End_Name_Range =>
                     
         


            End_Name_F_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Explicit_Deref_Range =>
                     
         


            Explicit_Deref_F_Prefix : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Explicit_Deref_R_Called_Spec : aliased Logic_Var_Record :=
               Null_Var_Record;

         



      
                  when Ada_Qual_Expr_Range =>
                     
         


            Qual_Expr_F_Prefix : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Qual_Expr_F_Suffix : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Reduce_Attribute_Ref_Range =>
                     
         


            Reduce_Attribute_Ref_F_Prefix : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;
            Reduce_Attribute_Ref_F_Attribute : aliased Bare_Identifier :=
               No_Bare_Ada_Node;
            Reduce_Attribute_Ref_F_Args : aliased Bare_Assoc_List :=
               No_Bare_Ada_Node;
            Reduce_Attribute_Ref_R_Ref_Var : aliased Logic_Var_Record :=
               Null_Var_Record;

         



      
                  when Ada_Single_Tok_Node =>
                     
         



         


            case Kind is
                  when Ada_Base_Id =>
                     
         



         


            case Kind is
                  when Ada_Char_Literal_Range =>
                     
         



         



            null;
      
                  when Ada_Identifier_Range =>
                     
         



         



            null;
      
                  when Ada_Op =>
                     
         



         


            case Kind is
                  when Ada_Op_Abs_Range =>
                     
         



         



            null;
      
                  when Ada_Op_And_Range =>
                     
         



         



            null;
      
                  when Ada_Op_And_Then_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Concat_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Div_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Double_Dot_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Eq_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Gt_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Gte_Range =>
                     
         



         



            null;
      
                  when Ada_Op_In_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Lt_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Lte_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Minus_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Mod_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Mult_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Neq_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Not_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Not_In_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Or_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Or_Else_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Plus_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Pow_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Rem_Range =>
                     
         



         



            null;
      
                  when Ada_Op_Xor_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_String_Literal_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Null_Literal_Range =>
                     
         



         



            null;
      
                  when Ada_Num_Literal =>
                     
         



         


            case Kind is
                  when Ada_Int_Literal_Range =>
                     
         



         



            null;
      
                  when Ada_Real_Literal_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
               when others => null;
            end case;

      
                  when Ada_Synthetic_Identifier_Range =>
                     
         


            Synthetic_Identifier_Sym : aliased Symbol_Type :=
               null;

         



      
                  when Ada_Target_Name_Range =>
                     
         


            Target_Name_R_Ref_Var : aliased Logic_Var_Record :=
               Null_Var_Record;

         



      
                  when Ada_Update_Attribute_Ref_Range =>
                     
         


            Update_Attribute_Ref_F_Prefix : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Update_Attribute_Ref_F_Attribute : aliased Bare_Identifier :=
               No_Bare_Ada_Node;
            Update_Attribute_Ref_F_Values : aliased Bare_Base_Aggregate :=
               No_Bare_Ada_Node;
            Update_Attribute_Ref_R_Ref_Var : aliased Logic_Var_Record :=
               Null_Var_Record;

         



      
               when others => null;
            end case;

      
                  when Ada_Paren_Expr_Range =>
                     
         


            Paren_Expr_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Quantified_Expr_Range =>
                     
         


            Quantified_Expr_F_Quantifier : aliased Bare_Quantifier :=
               No_Bare_Ada_Node;
            Quantified_Expr_F_Loop_Spec : aliased Bare_For_Loop_Spec :=
               No_Bare_Ada_Node;
            Quantified_Expr_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Raise_Expr_Range =>
                     
         


            Raise_Expr_F_Exception_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Raise_Expr_F_Error_Message : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Un_Op_Range =>
                     
         


            Un_Op_F_Op : aliased Bare_Op :=
               No_Bare_Ada_Node;
            Un_Op_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Handled_Stmts_Range =>
                     
         


            Handled_Stmts_F_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;
            Handled_Stmts_F_Exceptions : aliased Bare_Ada_Node_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Interface_Kind =>
                     
         



         


            case Kind is
                  when Ada_Interface_Kind_Limited_Range =>
                     
         



         



            null;
      
                  when Ada_Interface_Kind_Protected_Range =>
                     
         



         



            null;
      
                  when Ada_Interface_Kind_Synchronized_Range =>
                     
         



         



            null;
      
                  when Ada_Interface_Kind_Task_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Iter_Type =>
                     
         



         


            case Kind is
                  when Ada_Iter_Type_In_Range =>
                     
         



         



            null;
      
                  when Ada_Iter_Type_Of_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Library_Item_Range =>
                     
         


            Library_Item_F_Has_Private : aliased Bare_Private_Node :=
               No_Bare_Ada_Node;
            Library_Item_F_Item : aliased Bare_Basic_Decl :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Limited_Node =>
                     
         



         


            case Kind is
                  when Ada_Limited_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Limited_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Loop_Spec =>
                     
         



         


            case Kind is
                  when Ada_For_Loop_Spec_Range =>
                     
         


            For_Loop_Spec_F_Var_Decl : aliased Bare_For_Loop_Var_Decl :=
               No_Bare_Ada_Node;
            For_Loop_Spec_F_Loop_Type : aliased Bare_Iter_Type :=
               No_Bare_Ada_Node;
            For_Loop_Spec_F_Has_Reverse : aliased Bare_Reverse_Node :=
               No_Bare_Ada_Node;
            For_Loop_Spec_F_Iter_Expr : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;
            For_Loop_Spec_F_Iter_Filter : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_While_Loop_Spec_Range =>
                     
         


            While_Loop_Spec_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Mode =>
                     
         



         


            case Kind is
                  when Ada_Mode_Default_Range =>
                     
         



         



            null;
      
                  when Ada_Mode_In_Range =>
                     
         



         



            null;
      
                  when Ada_Mode_In_Out_Range =>
                     
         



         



            null;
      
                  when Ada_Mode_Out_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Multi_Abstract_State_Decl_Range =>
                     
         


            Multi_Abstract_State_Decl_F_Decls : aliased Bare_Abstract_State_Decl_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Not_Null =>
                     
         



         


            case Kind is
                  when Ada_Not_Null_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Not_Null_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Null_Component_Decl_Range =>
                     
         



         



            null;
      
                  when Ada_Others_Designator_Range =>
                     
         



         



            null;
      
                  when Ada_Overriding_Node =>
                     
         



         


            case Kind is
                  when Ada_Overriding_Not_Overriding_Range =>
                     
         



         



            null;
      
                  when Ada_Overriding_Overriding_Range =>
                     
         



         



            null;
      
                  when Ada_Overriding_Unspecified_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Params_Range =>
                     
         


            Params_F_Params : aliased Bare_Param_Spec_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Paren_Abstract_State_Decl_Range =>
                     
         


            Paren_Abstract_State_Decl_F_Decl : aliased Bare_Ada_Node :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Pp_Directive =>
                     
         



         


            case Kind is
                  when Ada_Pp_Else_Directive_Range =>
                     
         



         



            null;
      
                  when Ada_Pp_Elsif_Directive_Range =>
                     
         


            Pp_Elsif_Directive_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Pp_Elsif_Directive_F_Then_Kw : aliased Bare_Pp_Then_Kw :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Pp_End_If_Directive_Range =>
                     
         



         



            null;
      
                  when Ada_Pp_If_Directive_Range =>
                     
         


            Pp_If_Directive_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Pp_If_Directive_F_Then_Kw : aliased Bare_Pp_Then_Kw :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Pp_Then_Kw_Range =>
                     
         



         



            null;
      
                  when Ada_Pragma_Node_Range =>
                     
         


            Pragma_Node_F_Id : aliased Bare_Identifier :=
               No_Bare_Ada_Node;
            Pragma_Node_F_Args : aliased Bare_Base_Assoc_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Private_Node =>
                     
         



         


            case Kind is
                  when Ada_Private_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Private_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Protected_Def_Range =>
                     
         


            Protected_Def_F_Public_Part : aliased Bare_Public_Part :=
               No_Bare_Ada_Node;
            Protected_Def_F_Private_Part : aliased Bare_Private_Part :=
               No_Bare_Ada_Node;
            Protected_Def_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Protected_Node =>
                     
         



         


            case Kind is
                  when Ada_Protected_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Protected_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Quantifier =>
                     
         



         


            case Kind is
                  when Ada_Quantifier_All_Range =>
                     
         



         



            null;
      
                  when Ada_Quantifier_Some_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Range_Spec_Range =>
                     
         


            Range_Spec_F_Range : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Renaming_Clause_Range =>
                     
         


            Renaming_Clause_F_Renamed_Object : aliased Bare_Name :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Synthetic_Renaming_Clause_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Reverse_Node =>
                     
         



         


            case Kind is
                  when Ada_Reverse_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Reverse_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Select_When_Part_Range =>
                     
         


            Select_When_Part_F_Cond_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Select_When_Part_F_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Stmt =>
                     
         



         


            case Kind is
                  when Ada_Composite_Stmt =>
                     
         



         


            case Kind is
                  when Ada_Accept_Stmt_Range =>
                     
         


            Accept_Stmt_F_Name : aliased Bare_Identifier :=
               No_Bare_Ada_Node;
            Accept_Stmt_F_Entry_Index_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Accept_Stmt_F_Params : aliased Bare_Entry_Completion_Formal_Params :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Accept_Stmt_With_Stmts_Range =>
                     
         


            Accept_Stmt_With_Stmts_F_Stmts : aliased Bare_Handled_Stmts :=
               No_Bare_Ada_Node;
            Accept_Stmt_With_Stmts_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Base_Loop_Stmt =>
                     
         


            Base_Loop_Stmt_F_Spec : aliased Bare_Loop_Spec :=
               No_Bare_Ada_Node;
            Base_Loop_Stmt_F_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;
            Base_Loop_Stmt_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_For_Loop_Stmt_Range =>
                     
         



         



            null;
      
                  when Ada_Loop_Stmt_Range =>
                     
         



         



            null;
      
                  when Ada_While_Loop_Stmt_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Block_Stmt =>
                     
         



         


            case Kind is
                  when Ada_Begin_Block_Range =>
                     
         


            Begin_Block_F_Stmts : aliased Bare_Handled_Stmts :=
               No_Bare_Ada_Node;
            Begin_Block_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Decl_Block_Range =>
                     
         


            Decl_Block_F_Decls : aliased Bare_Declarative_Part :=
               No_Bare_Ada_Node;
            Decl_Block_F_Stmts : aliased Bare_Handled_Stmts :=
               No_Bare_Ada_Node;
            Decl_Block_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Case_Stmt_Range =>
                     
         


            Case_Stmt_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Case_Stmt_F_Pragmas : aliased Bare_Pragma_Node_List :=
               No_Bare_Ada_Node;
            Case_Stmt_F_Alternatives : aliased Bare_Case_Stmt_Alternative_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Extended_Return_Stmt_Range =>
                     
         


            Extended_Return_Stmt_F_Decl : aliased Bare_Extended_Return_Stmt_Object_Decl :=
               No_Bare_Ada_Node;
            Extended_Return_Stmt_F_Stmts : aliased Bare_Handled_Stmts :=
               No_Bare_Ada_Node;

         



      
                  when Ada_If_Stmt_Range =>
                     
         


            If_Stmt_F_Cond_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            If_Stmt_F_Then_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;
            If_Stmt_F_Alternatives : aliased Bare_Elsif_Stmt_Part_List :=
               No_Bare_Ada_Node;
            If_Stmt_F_Else_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Named_Stmt_Range =>
                     
         


            Named_Stmt_F_Decl : aliased Bare_Named_Stmt_Decl :=
               No_Bare_Ada_Node;
            Named_Stmt_F_Stmt : aliased Bare_Composite_Stmt :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Select_Stmt_Range =>
                     
         


            Select_Stmt_F_Guards : aliased Bare_Select_When_Part_List :=
               No_Bare_Ada_Node;
            Select_Stmt_F_Else_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;
            Select_Stmt_F_Abort_Stmts : aliased Bare_Stmt_List :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Error_Stmt_Range =>
                     
         



         



            null;
      
                  when Ada_Simple_Stmt =>
                     
         



         


            case Kind is
                  when Ada_Abort_Stmt_Range =>
                     
         


            Abort_Stmt_F_Names : aliased Bare_Name_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Assign_Stmt_Range =>
                     
         


            Assign_Stmt_F_Dest : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Assign_Stmt_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Call_Stmt_Range =>
                     
         


            Call_Stmt_F_Call : aliased Bare_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Delay_Stmt_Range =>
                     
         


            Delay_Stmt_F_Has_Until : aliased Bare_Until_Node :=
               No_Bare_Ada_Node;
            Delay_Stmt_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Exit_Stmt_Range =>
                     
         


            Exit_Stmt_F_Loop_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Exit_Stmt_F_Cond_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Goto_Stmt_Range =>
                     
         


            Goto_Stmt_F_Label_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Label_Range =>
                     
         


            Label_F_Decl : aliased Bare_Label_Decl :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Null_Stmt_Range =>
                     
         



         



            null;
      
                  when Ada_Raise_Stmt_Range =>
                     
         


            Raise_Stmt_F_Exception_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Raise_Stmt_F_Error_Message : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Requeue_Stmt_Range =>
                     
         


            Requeue_Stmt_F_Call_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Requeue_Stmt_F_Has_Abort : aliased Bare_Abort_Node :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Return_Stmt_Range =>
                     
         


            Return_Stmt_F_Return_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Terminate_Alternative_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
               when others => null;
            end case;

      
                  when Ada_Subp_Kind =>
                     
         



         


            case Kind is
                  when Ada_Subp_Kind_Function_Range =>
                     
         



         



            null;
      
                  when Ada_Subp_Kind_Procedure_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Subunit_Range =>
                     
         


            Subunit_F_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Subunit_F_Body : aliased Bare_Body_Node :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Synchronized_Node =>
                     
         



         


            case Kind is
                  when Ada_Synchronized_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Synchronized_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Tagged_Node =>
                     
         



         


            case Kind is
                  when Ada_Tagged_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Tagged_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Task_Def_Range =>
                     
         


            Task_Def_F_Interfaces : aliased Bare_Parent_List :=
               No_Bare_Ada_Node;
            Task_Def_F_Public_Part : aliased Bare_Public_Part :=
               No_Bare_Ada_Node;
            Task_Def_F_Private_Part : aliased Bare_Private_Part :=
               No_Bare_Ada_Node;
            Task_Def_F_End_Name : aliased Bare_End_Name :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Type_Attributes_Repository_Range =>
                     
         


            Type_Attributes_Repository_Base_Type : aliased Bare_Base_Type_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Base_Type_Expr : aliased Boolean :=
               False;
            Lf_Stg_Base_Type_Expr : aliased Bare_Synthetic_Type_Expr :=
               No_Bare_Ada_Node;
            Lf_Present_Universal_Int_Type_Expr : aliased Boolean :=
               False;
            Lf_Stg_Universal_Int_Type_Expr : aliased Bare_Synthetic_Type_Expr :=
               No_Bare_Ada_Node;
            Lf_Present_Base_Type_Param : aliased Boolean :=
               False;
            Lf_Stg_Base_Type_Param : aliased Bare_Synthetic_Formal_Param_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Universal_Int_Param : aliased Boolean :=
               False;
            Lf_Stg_Universal_Int_Param : aliased Bare_Synthetic_Formal_Param_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Universal_Real_Param : aliased Boolean :=
               False;
            Lf_Stg_Universal_Real_Param : aliased Bare_Synthetic_Formal_Param_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Root_Stream_Param : aliased Boolean :=
               False;
            Lf_Stg_Root_Stream_Param : aliased Bare_Synthetic_Formal_Param_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Succ : aliased Boolean :=
               False;
            Lf_Stg_Succ : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Pred : aliased Boolean :=
               False;
            Lf_Stg_Pred : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Min : aliased Boolean :=
               False;
            Lf_Stg_Min : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Max : aliased Boolean :=
               False;
            Lf_Stg_Max : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Rounding : aliased Boolean :=
               False;
            Lf_Stg_Rounding : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Ceiling : aliased Boolean :=
               False;
            Lf_Stg_Ceiling : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Floor : aliased Boolean :=
               False;
            Lf_Stg_Floor : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Truncation : aliased Boolean :=
               False;
            Lf_Stg_Truncation : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Machine : aliased Boolean :=
               False;
            Lf_Stg_Machine : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Machine_Rounding : aliased Boolean :=
               False;
            Lf_Stg_Machine_Rounding : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Fraction : aliased Boolean :=
               False;
            Lf_Stg_Fraction : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Exponent : aliased Boolean :=
               False;
            Lf_Stg_Exponent : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Copy_Sign : aliased Boolean :=
               False;
            Lf_Stg_Copy_Sign : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Remainder : aliased Boolean :=
               False;
            Lf_Stg_Remainder : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Adjacent : aliased Boolean :=
               False;
            Lf_Stg_Adjacent : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Scaling : aliased Boolean :=
               False;
            Lf_Stg_Scaling : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Compose : aliased Boolean :=
               False;
            Lf_Stg_Compose : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Mod : aliased Boolean :=
               False;
            Lf_Stg_Mod : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Value : aliased Boolean :=
               False;
            Lf_Stg_Value : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Wide_Value : aliased Boolean :=
               False;
            Lf_Stg_Wide_Value : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Wide_Wide_Value : aliased Boolean :=
               False;
            Lf_Stg_Wide_Wide_Value : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Fixed_Value : aliased Boolean :=
               False;
            Lf_Stg_Fixed_Value : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Integer_Value : aliased Boolean :=
               False;
            Lf_Stg_Integer_Value : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Pos : aliased Boolean :=
               False;
            Lf_Stg_Pos : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Val_Attr : aliased Boolean :=
               False;
            Lf_Stg_Val_Attr : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Enum_Rep : aliased Boolean :=
               False;
            Lf_Stg_Enum_Rep : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Enum_Val : aliased Boolean :=
               False;
            Lf_Stg_Enum_Val : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Read : aliased Boolean :=
               False;
            Lf_Stg_Read : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Write : aliased Boolean :=
               False;
            Lf_Stg_Write : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Input : aliased Boolean :=
               False;
            Lf_Stg_Input : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Output : aliased Boolean :=
               False;
            Lf_Stg_Output : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Image : aliased Boolean :=
               False;
            Lf_Stg_Image : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Wide_Image : aliased Boolean :=
               False;
            Lf_Stg_Wide_Image : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Wide_Wide_Image : aliased Boolean :=
               False;
            Lf_Stg_Wide_Wide_Image : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Put_Image : aliased Boolean :=
               False;
            Lf_Stg_Put_Image : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Asm_Input : aliased Boolean :=
               False;
            Lf_Stg_Asm_Input : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;
            Lf_Present_Asm_Output : aliased Boolean :=
               False;
            Lf_Stg_Asm_Output : aliased Bare_Basic_Subp_Decl :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Type_Def =>
                     
         



         


            case Kind is
                  when Ada_Access_Def =>
                     
         


            Access_Def_F_Has_Not_Null : aliased Bare_Not_Null :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Access_To_Subp_Def_Range =>
                     
         


            Access_To_Subp_Def_F_Has_Protected : aliased Bare_Protected_Node :=
               No_Bare_Ada_Node;
            Access_To_Subp_Def_F_Subp_Spec : aliased Bare_Subp_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Base_Type_Access_Def =>
                     
         



         


            case Kind is
                  when Ada_Anonymous_Type_Access_Def_Range =>
                     
         


            Anonymous_Type_Access_Def_F_Type_Decl : aliased Bare_Base_Type_Decl :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Type_Access_Def_Range =>
                     
         


            Type_Access_Def_F_Has_All : aliased Bare_All_Node :=
               No_Bare_Ada_Node;
            Type_Access_Def_F_Has_Constant : aliased Bare_Constant_Node :=
               No_Bare_Ada_Node;
            Type_Access_Def_F_Subtype_Indication : aliased Bare_Subtype_Indication :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
               when others => null;
            end case;

      
                  when Ada_Array_Type_Def_Range =>
                     
         


            Array_Type_Def_F_Indices : aliased Bare_Array_Indices :=
               No_Bare_Ada_Node;
            Array_Type_Def_F_Component_Type : aliased Bare_Component_Def :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Derived_Type_Def_Range =>
                     
         


            Derived_Type_Def_F_Has_Abstract : aliased Bare_Abstract_Node :=
               No_Bare_Ada_Node;
            Derived_Type_Def_F_Has_Limited : aliased Bare_Limited_Node :=
               No_Bare_Ada_Node;
            Derived_Type_Def_F_Has_Synchronized : aliased Bare_Synchronized_Node :=
               No_Bare_Ada_Node;
            Derived_Type_Def_F_Subtype_Indication : aliased Bare_Subtype_Indication :=
               No_Bare_Ada_Node;
            Derived_Type_Def_F_Interfaces : aliased Bare_Parent_List :=
               No_Bare_Ada_Node;
            Derived_Type_Def_F_Record_Extension : aliased Bare_Base_Record_Def :=
               No_Bare_Ada_Node;
            Derived_Type_Def_F_Has_With_Private : aliased Bare_With_Private :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Enum_Type_Def_Range =>
                     
         


            Enum_Type_Def_F_Enum_Literals : aliased Bare_Enum_Literal_Decl_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Formal_Discrete_Type_Def_Range =>
                     
         



         



            null;
      
                  when Ada_Interface_Type_Def_Range =>
                     
         


            Interface_Type_Def_F_Interface_Kind : aliased Bare_Interface_Kind :=
               No_Bare_Ada_Node;
            Interface_Type_Def_F_Interfaces : aliased Bare_Parent_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Mod_Int_Type_Def_Range =>
                     
         


            Mod_Int_Type_Def_F_Expr : aliased Bare_Expr :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Private_Type_Def_Range =>
                     
         


            Private_Type_Def_F_Has_Abstract : aliased Bare_Abstract_Node :=
               No_Bare_Ada_Node;
            Private_Type_Def_F_Has_Tagged : aliased Bare_Tagged_Node :=
               No_Bare_Ada_Node;
            Private_Type_Def_F_Has_Limited : aliased Bare_Limited_Node :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Real_Type_Def =>
                     
         



         


            case Kind is
                  when Ada_Decimal_Fixed_Point_Def_Range =>
                     
         


            Decimal_Fixed_Point_Def_F_Delta : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Decimal_Fixed_Point_Def_F_Digits : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Decimal_Fixed_Point_Def_F_Range : aliased Bare_Range_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Floating_Point_Def_Range =>
                     
         


            Floating_Point_Def_F_Num_Digits : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Floating_Point_Def_F_Range : aliased Bare_Range_Spec :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Ordinary_Fixed_Point_Def_Range =>
                     
         


            Ordinary_Fixed_Point_Def_F_Delta : aliased Bare_Expr :=
               No_Bare_Ada_Node;
            Ordinary_Fixed_Point_Def_F_Range : aliased Bare_Range_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Record_Type_Def_Range =>
                     
         


            Record_Type_Def_F_Has_Abstract : aliased Bare_Abstract_Node :=
               No_Bare_Ada_Node;
            Record_Type_Def_F_Has_Tagged : aliased Bare_Tagged_Node :=
               No_Bare_Ada_Node;
            Record_Type_Def_F_Has_Limited : aliased Bare_Limited_Node :=
               No_Bare_Ada_Node;
            Record_Type_Def_F_Record_Def : aliased Bare_Base_Record_Def :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Signed_Int_Type_Def_Range =>
                     
         


            Signed_Int_Type_Def_F_Range : aliased Bare_Range_Spec :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Type_Expr =>
                     
         



         


            case Kind is
                  when Ada_Anonymous_Type_Range =>
                     
         


            Anonymous_Type_F_Type_Decl : aliased Bare_Anonymous_Type_Decl :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Enum_Lit_Synth_Type_Expr_Range =>
                     
         



         



            null;
      
                  when Ada_Subtype_Indication_Range =>
                     
         


            Subtype_Indication_F_Has_Not_Null : aliased Bare_Not_Null :=
               No_Bare_Ada_Node;
            Subtype_Indication_F_Name : aliased Bare_Name :=
               No_Bare_Ada_Node;
            Subtype_Indication_F_Constraint : aliased Bare_Constraint :=
               No_Bare_Ada_Node;

         


            case Kind is
                  when Ada_Constrained_Subtype_Indication_Range =>
                     
         



         



            null;
      
                  when Ada_Discrete_Subtype_Indication_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Synthetic_Type_Expr_Range =>
                     
         


            Synthetic_Type_Expr_F_Target_Type : aliased Bare_Base_Type_Decl :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Unconstrained_Array_Index_Range =>
                     
         


            Unconstrained_Array_Index_F_Subtype_Indication : aliased Bare_Subtype_Indication :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Until_Node =>
                     
         



         


            case Kind is
                  when Ada_Until_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_Until_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
                  when Ada_Use_Clause =>
                     
         



         


            case Kind is
                  when Ada_Use_Package_Clause_Range =>
                     
         


            Use_Package_Clause_F_Packages : aliased Bare_Name_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Use_Type_Clause_Range =>
                     
         


            Use_Type_Clause_F_Has_All : aliased Bare_All_Node :=
               No_Bare_Ada_Node;
            Use_Type_Clause_F_Types : aliased Bare_Name_List :=
               No_Bare_Ada_Node;

         



      
               when others => null;
            end case;

      
                  when Ada_Value_Sequence_Range =>
                     
         


            Value_Sequence_F_Iter_Assoc : aliased Bare_Iterated_Assoc :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Variant_Range =>
                     
         


            Variant_F_Choices : aliased Bare_Alternatives_List :=
               No_Bare_Ada_Node;
            Variant_F_Components : aliased Bare_Component_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_Variant_Part_Range =>
                     
         


            Variant_Part_F_Discr_Name : aliased Bare_Identifier :=
               No_Bare_Ada_Node;
            Variant_Part_F_Variant : aliased Bare_Variant_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_With_Clause_Range =>
                     
         


            With_Clause_F_Has_Limited : aliased Bare_Limited_Node :=
               No_Bare_Ada_Node;
            With_Clause_F_Has_Private : aliased Bare_Private_Node :=
               No_Bare_Ada_Node;
            With_Clause_F_Packages : aliased Bare_Name_List :=
               No_Bare_Ada_Node;

         



      
                  when Ada_With_Private =>
                     
         



         


            case Kind is
                  when Ada_With_Private_Absent_Range =>
                     
         



         



            null;
      
                  when Ada_With_Private_Present_Range =>
                     
         



         



            null;
      
               when others => null;
            end case;

      
               when others => null;
            end case;

      
   end record;

   procedure Initialize
     (Self              : Bare_Ada_Node;
      Kind              : Ada_Node_Kind_Type;
      Unit              : Internal_Unit;
      Token_Start_Index : Token_Index;
      Token_End_Index   : Token_Index;
      Parent            : Bare_Ada_Node := null;
      Self_Env          : Lexical_Env := AST_Envs.Empty_Env);
   --  Helper for parsers, to initialize a freshly allocated node

   type PLE_Unit_State is record
      Named_Envs_Needing_Update : NED_Maps.Map;
      --  Set of named env entries whose Env_With_Precedence needs to be
      --  updated.
   end record;
   --  State of PLE on a specific unit

   type PLE_Unit_State_Access is access all PLE_Unit_State;

   type PLE_Node_State is record
      Unit_State : PLE_Unit_State_Access;
      --  State of PLE on the unit that owns this node

      Current_Env : Lexical_Env;
      --  Current environment when processing the node: initially inheritted
      --  from the Current_Env of the parent node (or Root_Scope on the root
      --  node), SetInitialEnv actions can change this.
      --
      --  Other environment actions such as AddEnv or AddToEnv can use this.

      Current_NED : Named_Env_Descriptor_Access;
      --  If the current environment was looked up by name, reference to the
      --  named environment descriptor. Null otherwise.
   end record;
   --  State of PLE on a specific node

   procedure Use_Direct_Env (State : in out PLE_Node_State; Env : Lexical_Env);
   --  Change State so that the current environment is Env, and record that it
   --  was *not* looked up by name.

   procedure Use_Named_Env
     (State   : in out PLE_Node_State;
      Context : Internal_Context;
      Name    : Symbol_Type);
   --  Change State so that the current environment comes from the named
   --  environment looked up with Name.

   procedure Set_Initial_Env
     (Self         : Bare_Ada_Node;
      State        : in out PLE_Node_State;
      Env          : Internal_Designated_Env;
      DSL_Location : String);
   --  Helper for ``Populate_Lexical_Env``: fetch the initial environment for
   --  ``Self`` according to ``Env`` and update ``State`` accordingly.

   procedure Add_To_Env
     (Self         : Bare_Ada_Node;
      State        : PLE_Node_State;
      Key          : Symbol_Type;
      Value        : Bare_Ada_Node;
      Md           : Internal_Metadata;
      Resolver     : Entity_Resolver;
      Dest_Env     : Internal_Designated_Env;
      DSL_Location : String);
   --  Helper for Populate_Lexical_Env: insert the Key/Value/MD/Resolver entry
   --  in the appropriate lexical env.
   --
   --  The destination environment is:
   --
   --  * If Dest_Env_Name is not null, this is the corresponding named
   --    environment.
   --
   --  * Otherwise, use Dest_Env_Fallback if is not the empty environment.
   --
   --  * Finally, use State's current environment.
   --
   --  If the destination environment is foreign and not fetched from its name
   --  while DSL_Location is not empty, raise a Property_Error.

   procedure Ref_Env
     (Self                : Bare_Ada_Node;
      Dest_Env            : Lexical_Env;
      Ref_Env_Nodes       : in out Bare_Ada_Node_Array_Access;
      Resolver            : Lexical_Env_Resolver;
      Kind                : Ref_Kind;
      Cats                : Ref_Categories;
      Shed_Rebindings     : Boolean);
   --  Helper for Populate_Lexical_Env: add referenced environments to
   --  Dest_Env. Calling this takes an ownership share for Ref_Env_Nodes.

   procedure Add_Env
     (Self              : Bare_Ada_Node;
      State             : in out PLE_Node_State;
      No_Parent         : Boolean;
      Transitive_Parent : Boolean;
      Names             : in out Symbol_Type_Array_Access);
   --  Helper for Populate_Lexical_Env: create a new environment for Self, and
   --  update State accordingly.
   --
   --  State and No_Parent participate to the computation of the parent for
   --  this new environment. Transitive_Parent is directly forwarded to the
   --  lexical environment constructor.
   --
   --  If Names is not null, this also registers the new environment as a named
   --  env for all the given names. For PLE code brevity, Add_Env takes care of
   --  freeing Names before returning.

   procedure Pre_Env_Actions
     (Self            : Bare_Ada_Node;
      State           : in out PLE_Node_State;
      Add_To_Env_Only : Boolean := False);
   --  Internal procedure that will execute all necessary lexical env actions
   --  for Node. This is meant to be called by Populate_Lexical_Env, and not by
   --  the user.

   procedure Post_Env_Actions
     (Self : Bare_Ada_Node; State : in out PLE_Node_State);
   --  Internal procedure that will execute all post add to env actions for
   --  Node. This is meant to be called by Populate_Lexical_Env.

   function Get_Symbol (Node : Bare_Ada_Node) return Symbol_Type
      with Pre => Node = null or else Is_Token_Node (Node);
   --  Assuming Node is a token node, return the corresponding symbol for the
   --  token it contains.

   function Image (Self : Symbol_Type) return String_Type;
   --  Transform a Symbol into an internal String

   function Text (Node : Bare_Ada_Node) return Text_Type;
   --  Retun the fragment of text from which Node was parsed

   ------------------------------
   -- Root AST node properties --
   ------------------------------


   -----------------------
   -- Generic list type --
   -----------------------


   function Length (Node : Bare_Ada_List) return Natural;

   function Children
     (Node : Bare_Ada_Node) return Bare_Ada_Node_Array_Access;
   --  Return an array containing all the children of Node.
   --  This is an alternative to the Child/Children_Count pair, useful if you
   --  want the convenience of ada arrays, and you don't care about the small
   --  performance hit of creating an array.

   function Item
     (Node  : Bare_Ada_List;
      Index : Positive) return Bare_Ada_Node renames Child;

   function Get
     (Self    : Bare_Ada_Node;
      Node    : Bare_Ada_List;
      Index   : Integer;
      Or_Null : Boolean := False) return Bare_Ada_Node;
   --  When Index is positive, return the Index'th element in T. Otherwise,
   --  return the element at index (Size - Index - 1). Index is zero-based.
   --
   --  ``Self`` is used to provide context to the ``Property_Error`` that is
   --  raised when the index is invalid.

   procedure Free_User_Fields (Node : Bare_Ada_Node);
   --  Free resources associated to user fields in ``Node``

   procedure Set_Parents (Node, Parent : Bare_Ada_Node);
   --  Set Node.Parent to Parent, and initialize recursively the parent of all
   --  child nodes.

   procedure Destroy (Node : Bare_Ada_Node);
   --  Free the resources allocated to this node and all its children

   --------------------------------------
   -- Environments handling (internal) --
   --------------------------------------

   function Create_Static_Lexical_Env
     (Parent            : Lexical_Env;
      Node              : Bare_Ada_Node;
      Transitive_Parent : Boolean := False) return Lexical_Env;
   --  Wrapper around AST_Envs.Create_Lexical_Env. Create the environment and,
   --  if Node is not null, register the result for destruction in Node's
   --  analysis unit.

   function Get
     (Self  : Bare_Ada_Node;
      A     : AST_Envs.Entity_Array;
      Index : Integer) return Internal_Entity;
   --  Simple getter that raises a ``Property_Error`` on out-of-bound accesses
   --  (using ``Self`` to provide context for this error). Useful for code
   --  generation.

   function Group
     (Envs   : Lexical_Env_Array_Access;
      Env_Md : Internal_Metadata := No_Metadata) return Lexical_Env;
   --  Convenience wrapper for uniform types handling in code generation

   package Bare_Ada_Node_Vectors is
      new Langkit_Support.Vectors (Bare_Ada_Node);

   function Is_Visible_From
     (Self                     : Bare_Ada_Node;
      Referenced_Env, Base_Env : Lexical_Env) return Boolean;
   --  Return whether the unit that ``Referenced_Env`` belongs to is visible
   --  from the unit that Base_Env belongs to. If at least one of these two
   --  lexical environments does not belong to a particular analysis unit, this
   --  raises a ``Property_Error``.
   --
   --  ``Self`` is used to give context to the error in case of failure.

   function Populate_Lexical_Env (Node : Bare_Ada_Node) return Boolean;
   --  Populate the lexical environment for node and all its children. Return
   --  whether a Property_Error error occurred in the process.

   -----------------------------------
   -- Lexical utilities (internals) --
   -----------------------------------

   function Token
     (Node  : Bare_Ada_Node;
      Index : Token_Index) return Token_Reference;
   --  Helper for properties. This is used to turn token indexes as stored in
   --  AST nodes into Token_Reference values.

   function Stored_Token
     (Node  : Bare_Ada_Node;
      Token : Token_Reference) return Token_Index;
   --  Helper for properties. This is used to turn a Token_Reference value into
   --  a Token_Index value that can be stored as a field in Node. This raises a
   --  Property_Error if Node and Token don't belong to the same analysis unit
   --  or if Token is actually a Trivia.

   type Bare_Child_Record (Kind : Child_Or_Trivia := Child) is record
      case Kind is
         when Child =>
            Node : Bare_Ada_Node;
         when Trivia =>
            Trivia : Token_Reference;
      end case;
   end record;
   --  Variant that holds either an node or a token

   type Bare_Children_Array is array (Positive range <>) of Bare_Child_Record;

   function Children_And_Trivia
     (Node : Bare_Ada_Node) return Bare_Children_Array;
   --  Implementation for Analysis.Children_And_Trivia

      

   



         



 function Ada_Node_P_Declarative_Scope
   
  (Node : Bare_Ada_Node
  )

   return Bare_Declarative_Part
   ;
--  Return the scope of definition of this basic declaration.

         



 function Ada_Node_P_Owning_Unit_Kind
   
  (Node : Bare_Ada_Node
  )

   return Analysis_Unit_Kind
   ;
--  Return the kind of the compilation unit owning this node.

         



 function Ada_Node_P_Withed_Unit_Helper
   
  (Node : Bare_Ada_Node
      ; Unit_Name : Bare_Name
  )

   return Bare_Compilation_Unit
   ;
--  Static method helper. Fetch the unit designated by unit_name. Return the
--  compilation unit node.
--
--  This is designed in a way that will emit a
--  ``unit_requested(not_found_is_error=True, ...)`` event when not finding the
--  unit is supposed to be an error within Ada semantics.

         



 function Dispatcher_Ada_Node_P_Custom_Id_Text
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type
   with Inline_Always
   ;
--  Custom Unique identifying text used to recognize this node. Not applicable
--  to all nodes, but on AdaNode because it spans more than one hierarchy of
--  node types.

         



 function Ada_Node_P_Is_Contract_Aspect
   
  (Node : Bare_Ada_Node
      ; Name : Symbol_Type
  )

   return Boolean
   ;


         



 function Ada_Node_P_In_Contract
   
  (Node : Bare_Ada_Node
  )

   return Boolean
   ;


         



 function Ada_Node_P_In_Aspect
   
  (Node : Bare_Ada_Node
      ; Name : Symbol_Type
  )

   return Boolean
   ;
--  Return whether Self is contained by an aspect whose name is ``name``.

         



 function Ada_Node_P_Empty_Env
   
  (Node : Bare_Ada_Node
  )

   return Lexical_Env
   ;


         



 function Ada_Node_P_Is_Not_Null
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return True iff this node is not null.

         



 function Ada_Node_P_Eval_Discrete_Range
   
  (Node : Bare_Ada_Node
      ; Dr : Internal_Discrete_Range
  )

   return Internal_Eval_Discrete_Range
   ;
--  Static method. Evaluate the bounds of ``dr``.

         



 function Ada_Node_P_Sym_Join
   
  (Node : Bare_Ada_Node
      ; Syms : Symbol_Type_Array_Access
      ; Sep : String_Type
  )

   return String_Type
   ;
--  Static method. Return the array of symbols joined by separator ``sep``.

         



 function Ada_Node_P_Enclosing_Compilation_Unit
   
  (Node : Bare_Ada_Node
  )

   return Bare_Compilation_Unit
   ;
--  Return the compilation unit containing this node.
--
--  .. note:: This returns the :ada:ref:`Compilation_Unit` node, which is
--     different from the ``AnalysisUnit``. In particular, an analysis unit can
--     contain multiple compilation units.

         



 function Ada_Node_P_Is_Children_Env
   
  (Node : Bare_Ada_Node
      ; Parent : Lexical_Env
      ; Current_Env : Lexical_Env
  )

   return Boolean
   ;
--  Static property. Will return True if current_env is a children of parent.

         



 function Ada_Node_P_Without_Md
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Return Entity with an empty metadata field.

         



 function Ada_Node_P_Get_Uninstantiated_Node
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity
   ;
--  Assuming this node comes from an instantiated generic declaration, return
--  its non-instantiated counterpart lying in the generic declaration.

         



 function Ada_Node_P_Complete
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Completion_Item_Iterator_Access
   ;
--  Return possible completions at this point in the file.

         



 function Dispatcher_Ada_Node_P_Complete_Items
   
  (Node : Bare_Ada_Node
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Completion_Item_Array_Access
   with Inline_Always
   ;
--  Internal method used by ``complete`` to get the array of possible
--  completions for the current node. This method has to be overridden in order
--  to specialize the completion.

         



 function Dispatcher_Ada_Node_P_Complete_Item_Weight
   
  (Node : Bare_Ada_Node
      ; Item : Internal_Entity_Basic_Decl
      ; Origin : Bare_Ada_Node
  )

   return Integer
   with Inline_Always
   ;
--  Internal method used by ``complete_items`` that can be used to specialize
--  the completion weight field only.

         



 function Ada_Node_P_Valid_Keywords
   
  (Node : Bare_Ada_Node
  )

   return Symbol_Type_Array_Access
   ;
--  Return the list of keywords that are valid at this point in the file.
--
--  .. note:: This is work in progress. It will return all keywords for now,
--     without looking at the context.

         



 function Ada_Node_P_Generic_Instantiations
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Generic_Instantiation_Array_Access
   ;
--  Return the potentially empty list of generic package/subprogram
--  instantiations that led to the creation of this entity. Outer-most
--  instantiations appear last.

         



 function Ada_Node_P_Generic_Instantiations_Internal
   
  (Node : Bare_Ada_Node
      ; R : Env_Rebindings
  )

   return Internal_Entity_Generic_Instantiation_Array_Access
   ;


         



 function Ada_Node_P_Remove_Rebindings
   
  (Node : Bare_Ada_Node
      ; Base : Env_Rebindings
      ; Suffix : Env_Rebindings
  )

   return Env_Rebindings
   ;
--  If the rebindings in ``base`` end with ``suffix``, ``base`` is returned
--  without it. Otherwise ``base`` is returned as-is.

         



 function Ada_Node_P_Logic_Val
   
  (Node : Bare_Ada_Node
      ; From_Node : Internal_Entity
      ; Lvar : Logic_Var
  )

   return Internal_Logic_Val_Result
   ;


         



 function Ada_Node_P_Semantic_Parent_Helper
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;


         



 function Ada_Node_P_Semantic_Parent
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Return the semantic parent for this node, if applicable, null otherwise.
--
--  .. note:: A node lying outside of a library item's declaration or subunit's
--     body does not have a parent environment, meaning that this property will
--     return null.

         



 function Ada_Node_P_Is_In_Top_Level_Public_Part
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this node ultimately lies in the public part of a top-level
--  package.

         



 function Ada_Node_P_Parent_Basic_Decl
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the parent basic decl for this node, if applicable, null otherwise.
--
--  .. note:: If the parent BasicDecl of the given node is a generic
--     declaration, this call will return the instantiation from which the node
--     was retrieved instead, if any.
--
--  .. note:: When called on a subunit's body, this property will return the
--     its corresponding body stub.
--
--  .. note:: When called on a node lying outside of a library item's
--     declaration or subunit's body this property will return null.

         



 function Dispatcher_Ada_Node_P_Immediate_Declarative_Region
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   with Inline_Always
   ;
--  Return the immediate declarative region (:rmlink:`8.1`) corresponding to
--  this node, that is, the concatenation of the declarative parts of itself
--  and all its completion. This does not include the declarative regions of
--  the enclosed declarations.
--
--  This is mainly used to restrict the scope in which to search for the
--  previous part of a declaration.

         



 function Ada_Node_P_Designated_Compilation_Unit
   
  (Node : Bare_Ada_Node
      ; Name : Symbol_Type_Array_Access
      ; Kind : Analysis_Unit_Kind
      ; Load_If_Needed : Boolean
         := True
      ; Not_Found_Is_Error : Boolean
         := True
      ; Process_Parents : Boolean
         := True
  )

   return Bare_Compilation_Unit
   ;
--  Fetch the compilation unit designated by the given name defined in an
--  analysis unit of the given kind.

         



 function Ada_Node_P_Compilation_Unit_With_Name
   
  (Node : Bare_Ada_Node
      ; Unit : Internal_Unit
      ; Name : Symbol_Type_Array_Access
  )

   return Bare_Compilation_Unit
   ;
--  Helper for ``designated_compilation_unit``. From a given analysis unit,
--  that might contain several compilation units, and a name, return the
--  corresponding compilation unit.

         



 function Ada_Node_P_Get_Unit_Root_Decl
   
  (Node : Bare_Ada_Node
      ; Name : Symbol_Type_Array_Access
      ; Kind : Analysis_Unit_Kind
      ; Load_If_Needed : Boolean
         := True
      ; Not_Found_Is_Error : Boolean
         := True
      ; Process_Parents : Boolean
         := True
  )

   return Bare_Basic_Decl
   ;
--  If the corresponding analysis unit is loaded, return the root decl node for
--  the given analysis unit ``kind`` and correpsonding to the name ``name``. If
--  it's not loaded, return none.

         



 function Dispatcher_Ada_Node_P_Xref_Equation
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   with Inline_Always
   ;
--  This is the base property for constructing equations that, when solved,
--  will resolve names and types for every sub expression of the expression you
--  call it on. Note that if you call that on any expression, in some context
--  it might lack full information and return multiple solutions. If you want
--  completely precise resolution, you must call that on the outermost node
--  that supports xref_equation.

         



 function Dispatcher_Ada_Node_P_Xref_Stop_Resolution
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;


         



 function Dispatcher_Ada_Node_P_Stop_Resolution_Equation
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   with Inline_Always
   ;


         



 function Dispatcher_Ada_Node_P_Xref_Initial_Env
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   with Inline_Always
   ;
--  Return the environment to bind initially during the construction of the
--  xref equation for this node. Note that this only makes sense if this node
--  is an xref entry point.

         



 function Ada_Node_P_Sub_Equation
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Wrapper for xref_equation, meant to be used inside of xref_equation when
--  you want to get the sub equation of a sub expression. It is used to change
--  the behavior when xref_equation is called from another xref_equation call,
--  or from the top level, so that we can do resolution in several steps.

         



 function Ada_Node_P_Resolve_Children_Names
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Internal helper for resolve_names, implementing the recursive logic needed
--  to resolve names across xref_stop_resolution boundaries.

         



 function Ada_Node_P_Resolve_Names_Internal
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Resolves names for this node up to xref_entry_point boundaries.

         



 function Ada_Node_P_Resolve_Names_Internal_With_Eq
   
  (Node : Bare_Ada_Node
      ; Additional_Equation : Logic_Equation
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Resolves names in this node with an additional constraint given by
--  ``additional_equation``, up to xref_entry_point boundaries.

         



 function Dispatcher_Ada_Node_P_Xref_Entry_Point
   
  (Node : Bare_Ada_Node
  )

   return Boolean
   with Inline_Always
   ;
--  Designates entities that are entry point for the xref solving
--  infrastructure. If this returns true, then resolve_names can be called on
--  it.
--
--  .. note:: For convenience, and unlike what is defined in the ARM wrt.
--     complete contexts for name resolution, ``xref_entry_points`` can be
--     nested.

         



 function Ada_Node_P_Resolve_Names
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  This will resolve names for this node. If the operation is successful, then
--  type_var and ref_var will be bound on appropriate subnodes of the
--  statement.

         



 function Ada_Node_P_Resolve_Names_From_Closest_Entry_Point_Impl
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Implementation helper for ``resolve_names_from_closest_entry_point``.
--  Instead of returning a Boolean, it returns a LexicalEnv, which is either
--  None (indicating that resolution failed), or contains the lexical
--  environment which the children of that node should bind when resolving
--  their own names. This allows propagating the initial env we got from
--  ``Entity.xref_initial_env`` on the closest xref entry point.

         



 function Ada_Node_P_Resolve_Names_From_Closest_Entry_Point
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Resolve names from the closest entry point up to this node. Note that
--  unlike ``resolve_names``, this will *not* trigger resolution of every node
--  with stop_resolution that lie in the sub-tree formed by the closest entry
--  point. It will only resolve those that are in the path to resolving Self.
--  Consider for example the following entry point:
--
--  .. code::
--
--     R := (A, B);
--
--  Since aggregate association nodes have ``stop_resolution`` set to True,
--  calling ``resolve_names_from_closest_entry_point`` on ``B`` will resolve
--  nodes ``R`` and ``B`` but not ``A``, because ``A`` does not lie on the path
--  to ``B``.
--
--  This can be useful for resolving aggregates of variant records, because
--  resolution of a component association can safely call the resolution of a
--  discriminant association without triggering an infinite recursion, as both
--  are on different "paths".

         



 function Ada_Node_P_Parent_Unit_Env_Helper
   
  (Node : Bare_Ada_Node
      ; Unit : Internal_Unit
      ; Env : Lexical_Env
  )

   return Lexical_Env
   ;


         



 function Ada_Node_P_Parent_Unit_Env
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
  )

   return Lexical_Env
   ;
--  Given env's AnalysisUnit, return the first env that has a different
--  analysis unit in the env parent chain.

         



 function Ada_Node_P_Std
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Basic_Decl
   ;
--  Retrieves the package corresponding to the Standard unit. Used to access
--  standard types.

         



 function Ada_Node_P_Std_Env
   
  (Node : Bare_Ada_Node
  )

   return Lexical_Env
   ;
--  Get the children env of the Standard package.

         



 function Ada_Node_P_Std_Entity
   
  (Node : Bare_Ada_Node
      ; Sym : Symbol_Type
  )

   return Internal_Entity
   ;
--  Static property. Return an entity from the standard package with name
--  ``sym``.

         



 function Ada_Node_P_Std_Entity_Implem
   
  (Node : Bare_Ada_Node
      ; Sym : Symbol_Type
  )

   return Internal_Entity
   ;


         



 function Ada_Node_P_Bool_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Static method. Return the standard Boolean type.

         



 function Ada_Node_P_Int_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Static method. Return the standard Integer type.

         



 function Ada_Node_P_Universal_Int_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity
   ;
--  Static method. Return the standard Universal Integer type.

         



 function Ada_Node_P_Universal_Real_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity
   ;
--  Static method. Return the standard Universal Real type.

         



 function Ada_Node_P_Std_Char_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Static method. Return the standard Character type.

         



 function Ada_Node_P_Std_Wide_Char_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Static method. Return the standard Wide_Character type.

         



 function Ada_Node_P_Std_Wide_Wide_Char_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Static method. Return the standard Wide_Wide_Character type.

         



 function Ada_Node_P_Std_Root_Types
   
  (Node : Bare_Ada_Node
  )

   return Lexical_Env
   ;
--  Static method. Return the package containing the definitions of the root
--  types.

         



 function Ada_Node_P_Root_Int_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Static method. Return the root_integer type.

         



 function Ada_Node_P_Root_Real_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Static method. Return the root_real type.

         



 function Ada_Node_P_Root_Type_Ops_Impl
   
  (Node : Bare_Ada_Node
      ; Sym : Symbol_Type
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  See ``root_type_ops``.

         



 function Ada_Node_P_Root_Type_Ops
   
  (Node : Bare_Ada_Node
      ; Sym : Symbol_Type
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  Lookup the given symbol in the builtin ``root_types`` package. This is used
--  for fast-access to predefined operator on root types.

         



 function Ada_Node_P_Exc_Id_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the type Ada.Exceptions.Exception_Id.

         



 function Ada_Node_P_Task_Id_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the type Ada.Task_Identification.Task_Id.

         



 function Ada_Node_P_Root_Buffer_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the type Ada.Strings.Text_Buffers.Root_Buffer_Type

         



 function Ada_Node_P_Root_Stream_Type
   
  (Node : Bare_Ada_Node
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the type Ada.Streams.Root_Stream_Type

         



 function Ada_Node_P_Has_With_Visibility
   
  (Node : Bare_Ada_Node
      ; Refd_Unit : Internal_Unit
  )

   return Boolean
   ;
--  Return whether Self's unit has ``with visibility`` on ``refd_unit``.
--
--  In other words, whether Self's unit has a WITH clause on ``refd_unit``, or
--  if its spec, or one of its parent specs has one.

         



 function Ada_Node_P_Has_Visibility
   
  (Node : Bare_Ada_Node
      ; Other_Entity : Internal_Entity
  )

   return Boolean
   ;


         



 function Ada_Node_P_Resolve_Generic_Actual
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Helper property to resolve the actuals of generic instantiations.

         



 function Ada_Node_P_Top_Level_Use_Package_Clauses
   
  (Node : Bare_Ada_Node
  )

   return Bare_Ada_Node_Array_Access
   ;
--  If Self is a library item or a subunit, return a flat list of all names for
--  top-level UsePackageClause nodes. See UsePackageClause.env_spec.ref_envs
--  for more details.

         



 function Ada_Node_P_Top_Level_Use_Type_Clauses
   
  (Node : Bare_Ada_Node
  )

   return Bare_Ada_Node_Array_Access
   ;
--  If Self is a library item or a subunit, return a flat list of all names for
--  top-level UseTypeClause nodes. See UseTypeClause.env_spec for more details.

         



 function Ada_Node_P_Top_Level_Use_Clauses
   
  (Node : Bare_Ada_Node
  )

   return Bare_Use_Clause_Array_Access
   ;
--  If Self is a library item or a subunit, return a flat list of all names for
--  top-level UseClause nodes.

         



 function Ada_Node_P_Top_Level_With_Package_Clauses
   
  (Node : Bare_Ada_Node
  )

   return Bare_Name_Array_Access
   ;
--  Return a flat list of all package names that are with'ed by top-level
--  WithClause nodes of the compilation unit this node lies in.

         



 function Ada_Node_P_Use_Clauses_In_Spec_Of_Subp_Body
   
  (Node : Bare_Ada_Node
  )

   return Lexical_Env
   ;
--  If Self is a library-level SubpBody, fetch the environments USE'd in its
--  declaration.

         



 function Ada_Node_P_Use_Clauses_In_Generic_Formal_Part
   
  (Node : Bare_Ada_Node
  )

   return Lexical_Env
   ;
--  Assuming Self is a generic entity's body that is nested (not a library
--  item), return the grouped lexical environment containing all the
--  environments that are referred by use clauses inside formal part of its
--  generic declaration. Return an empty environment if this is not the body of
--  a generic decl.

         



 function Ada_Node_P_Nested_Generic_Formal_Part
   
  (Node : Bare_Ada_Node
  )

   return Lexical_Env
   ;
--  Assuming Self is a generic entity's body that is nested (not a library
--  item), return the lexical environment for the corresponding
--  GenericPackageDecl (or GenericSubpDecl) node. Return an empty environment
--  in all other cases.
--
--  This is a helper for generic formals visibility in generic bodies. See the
--  use in the child_unit macro.
--
--  The following property is evaluated each time we make a recursive lexical
--  environment lookup on a child unit. As it does itself a lot of lookups,
--  memoizing it is very important.

         



 function Ada_Node_P_Is_Package
   
  (Node : Bare_Ada_Node
  )

   return Boolean
   ;
--  Property helper to determine if an entity is a package or not.

         



 function Ada_Node_P_Default_Initial_Env
   
  (Node : Bare_Ada_Node
  )

   return Lexical_Env
   ;
--  Provide the default lexical environment to use in EnvSpec's initial_env.

         



 function Ada_Node_P_Top_Level_Decl
   
  (Node : Bare_Ada_Node
      ; Unit : Internal_Unit
  )

   return Bare_Basic_Decl
   ;
--  Static method. Get the top-level decl in ``unit``.  This is the body of a
--  Subunit, or the item of a ``LibraryItem``.

         



 function Ada_Node_P_Unpack_Formals
   
  (Node : Bare_Ada_Node
      ; Formal_Params : Internal_Entity_Base_Formal_Param_Decl_Array_Access
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;
--  Static method. DefiningName for all parameters.

         



 function Ada_Node_P_Unpack_Formals_Impl
   
  (Node : Bare_Ada_Node
      ; Formal_Params : Internal_Entity_Base_Formal_Param_Decl_Array_Access
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Ada_Node_P_Match_Formals
   
  (Node : Bare_Ada_Node
      ; Formal_Params : Internal_Entity_Base_Formal_Param_Decl_Array_Access
      ; Params : Internal_Entity_Assoc_List
      ; Is_Dottable_Subp : Boolean
  )

   return Internal_Param_Match_Array_Access
   ;
--  Static method. For each ParamAssoc in a AssocList, return whether we could
--  find a matching formal in Self, and whether this formal is optional (i.e.
--  has a default value).

         



 function Ada_Node_P_Choice_Match
   
  (Node : Bare_Ada_Node
      ; Value : Big_Integer_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Assuming that self is a choice expression (such as what can appear in an
--  alternative of a case statement or in the RHS of a membership expression,
--  this property returns whether the given value satisfies it.
--
--  .. attention:: This is an experimental feature, so even if it is exposed to
--     allow experiments, it is totally unsupported and the API and behavior
--     are very likely to change in the future.

         



 function Ada_Node_P_Gnat_Xref
   
  (Node : Bare_Ada_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;
--  Return a cross reference from this name to a defining identifier, trying to
--  mimic GNAT's xrefs as much as possible.

         



 function Ada_Node_P_Env_Get_Real_From_Node
   
  (Node : Bare_Ada_Node
      ; From_Node : Bare_Ada_Node
  )

   return Bare_Ada_Node
   ;
--  Static property. Finds the closest BasicSubpDecl / BaseSubpBody /
--  GenericInstantiation. Is used by env_get and env_get_first wrappers to
--  implement correct visibility rules for those. See documentation on those
--  properties.

         



 function Ada_Node_P_Entity_No_Md
   
  (Node : Bare_Ada_Node
      ; N : Bare_Ada_Node
      ; Rebindings : Env_Rebindings
      ; From_Rebound : Boolean
  )

   return Internal_Entity
   ;
--  Static property. Create an entity from the arguments with a null metadata.

         



 function Ada_Node_P_Env_Mappings
   
  (Node : Bare_Ada_Node
      ; Defining_Names : Bare_Defining_Name_List
      ; Value : Bare_Ada_Node
  )

   return Internal_Env_Assoc_Array_Access
   ;
--  Static method. Create an env mapping array from a list of BaseId to be used
--  as keys, and a node to be used as value in the mappings.

         



 function Ada_Node_P_Comp_Bind
   
  (Node : Bare_Ada_Node
      ; Left : Logic_Var
      ; Right : Logic_Var
      ; Origin : Bare_Ada_Node
  )

   return Logic_Equation
   ;


         



 function Ada_Node_P_Universal_Int_Bind
   
  (Node : Bare_Ada_Node
      ; Type_Var : Logic_Var
      ; Origin : Bare_Ada_Node
  )

   return Logic_Equation
   ;
--  Static method. Return an equation that will bind type_var to any integer
--  value, corresponding to the notion of universal_integer in the Ada RM (see
--  :rmlink:`3.4.1`).

         



 function Ada_Node_P_Universal_Real_Bind
   
  (Node : Bare_Ada_Node
      ; Type_Var : Logic_Var
      ; Origin : Bare_Ada_Node
  )

   return Logic_Equation
   ;
--  Static method. Return an equation that will bind type_var to any real
--  value, corresponding to the notion of universal_real in the Ada RM (see
--  :rmlink:`3.4.1`).

         



 function Ada_Node_P_Origin_Node
   
  (Node : Bare_Ada_Node
  )

   return Bare_Ada_Node
   ;
--  Return a null node iff we are in the definition of an aspect clause where
--  sequential lookup needs to be deactivated. Return Self otherwise.

         



 function Ada_Node_P_Env_Hook
   
  (Node : Bare_Ada_Node
  )

   return Boolean
   ;
--  Hook for the EnvSpec of units.
--
--  Return value is not significant: the only purpose of this property lies in
--  its side effects.

         



 function Ada_Node_P_Env_Get
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Symbol : Symbol_Type
      ; Lookup : Lookup_Kind
         := Recursive
      ; From_Node : Bare_Ada_Node
         := No_Bare_Ada_Node
      ; Categories : Ref_Categories
         := (Inherited_Primitives => True, Nocat => True)
  )

   return Internal_Entity_Array_Access
   ;
--  Wrapper for ``env.get``. Refines the results so that Ada visibility rules
--  for subprogram specifications and generic instantiations are correctly
--  handled: names inside the two aforementioned constructs do not have
--  visibility on their enclosing declaration, such that the following is
--  legal:
--
--  .. code:: ada
--
--     type T is null record;
--     procedure T (X : T) is null;
--
--  Here, calling ``env_get("T")`` in the subp spec of subprogram ``T`` must
--  not return the subprogram ``T`` itself, because according to Ada the
--  subprogram is not yet visible.

         



 function Ada_Node_P_Env_Get_Public
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Symbol : Symbol_Type
      ; Lookup : Lookup_Kind
         := Recursive
      ; From_Node : Bare_Ada_Node
         := No_Bare_Ada_Node
      ; Categories : Ref_Categories
         := (Inherited_Primitives => True, Nocat => True)
  )

   return Internal_Entity_Array_Access
   ;
--  Like ``env_get`` but should be used when the results are to be returned to
--  users: this wrapper takes care of removing internal structures which are of
--  no use for users.

         



 function Ada_Node_P_Synthesize_Defining_Name
   
  (Node : Bare_Ada_Node
      ; Sym : Symbol_Type
  )

   return Bare_Defining_Name
   ;
--  Synthesizes a defining name and its inner identifier using the given
--  symbol.

         



 function Ada_Node_P_Create_Unop_Assoc
   
  (Node : Bare_Ada_Node
      ; Op : Symbol_Type
      ; Rhs : Bare_Base_Type_Decl
      ; Ret : Bare_Base_Type_Decl
  )

   return Internal_Env_Assoc
   ;
--  Synthesizes a subprogram declaration named after the given symbol, with a
--  "Right" parameter having the ``rhs`` type, and the given return type.

         



 function Ada_Node_P_Create_Binop_Assoc_Impl
   
  (Node : Bare_Ada_Node
      ; Op : Symbol_Type
      ; Lhs : Bare_Type_Expr
      ; Rhs : Bare_Type_Expr
      ; Ret : Bare_Type_Expr
  )

   return Internal_Env_Assoc
   ;
--  Implementation for the various ``create_binop_assoc*`` variants. The
--  shorthands take care of synthesizing type expressions when necessary.

         



 function Ada_Node_P_Create_Binop_Assoc
   
  (Node : Bare_Ada_Node
      ; Op : Symbol_Type
      ; Lhs : Bare_Base_Type_Decl
      ; Rhs : Bare_Base_Type_Decl
      ; Ret : Bare_Base_Type_Decl
  )

   return Internal_Env_Assoc
   ;
--  Synthesizes a subprogram declaration named after the given symbol, with a
--  "Left" parameter having the ``lhs`` type, a "Right" parameter having the
--  ``rhs`` type, and the given return type.

         



 function Ada_Node_P_Create_Binop_Assoc_L_Expr
   
  (Node : Bare_Ada_Node
      ; Op : Symbol_Type
      ; Lhs : Bare_Type_Expr
      ; Rhs : Bare_Base_Type_Decl
      ; Ret : Bare_Base_Type_Decl
  )

   return Internal_Env_Assoc
   ;
--  Like ``create_binop_assoc`` but the left parameter's type is given as a
--  type expression.

         



 function Ada_Node_P_Create_Binop_Assoc_R_Expr
   
  (Node : Bare_Ada_Node
      ; Op : Symbol_Type
      ; Lhs : Bare_Base_Type_Decl
      ; Rhs : Bare_Type_Expr
      ; Ret : Bare_Base_Type_Decl
  )

   return Internal_Env_Assoc
   ;
--  Like ``create_binop_assoc`` but the right parameter's type is given as a
--  type expression.

         



 function Ada_Node_P_Create_Binop_Assoc_L_R_Expr
   
  (Node : Bare_Ada_Node
      ; Op : Symbol_Type
      ; Lhs : Bare_Type_Expr
      ; Rhs : Bare_Type_Expr
      ; Ret : Bare_Base_Type_Decl
  )

   return Internal_Env_Assoc
   ;
--  Like ``create_binop_assoc`` but the left and right parameters' types are
--  given as type expressions.

         



 function Node_Env
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  For nodes that introduce a new environment, return the parent lexical
--  environment. Return the "inherited" environment otherwise.

         



 function Children_Env
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  For nodes that introduce a new environment, return it. Return the
--  "inherited" environment otherwise.

         



 function Parent
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Return the syntactic parent for this node. Return null for the root node.

         



 function Parents
   
  (Node : Bare_Ada_Node
      ; With_Self : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Access
   ;
--  Return an array that contains the lexical parents, this node included iff
--  ``with_self`` is True. Nearer parents are first in the list.

         



 function Children
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Access
   ;
--  Return an array that contains the direct lexical children.
--
--  .. warning:: This constructs a whole array every-time you call it, and as
--     such is less efficient than calling the ``Child`` built-in.

         



 function Token_Start
   
  (Node : Bare_Ada_Node
  )

   return Token_Reference
   ;
--  Return the first token used to parse this node.

         



 function Token_End
   
  (Node : Bare_Ada_Node
  )

   return Token_Reference
   ;
--  Return the last token used to parse this node.

         



 function Child_Index
   
  (Node : Bare_Ada_Node
  )

   return Integer
   ;
--  Return the 0-based index for Node in its parent's children.

         



 function Previous_Sibling
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Return the node's previous sibling, or null if there is no such sibling.

         



 function Next_Sibling
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity
   ;
--  Return the node's next sibling, or null if there is no such sibling.

         



 function Unit
   
  (Node : Bare_Ada_Node
  )

   return Internal_Unit
   ;
--  Return the analysis unit owning this node.

         



 function Is_Ghost
   
  (Node : Bare_Ada_Node
  )

   return Boolean
   ;
--  Return whether the node is a ghost.
--
--  Unlike regular nodes, ghost nodes cover no token in the input source: they
--  are logically located instead between two tokens. Both the ``token_start``
--  and the ``token_end`` of all ghost nodes is the token right after this
--  logical position.

         



 function Text
   
  (Node : Bare_Ada_Node
  )

   return String_Type
   ;
--  Return the text corresponding to this node. Private property (for internal
--  DSL use).

         



 function Full_Sloc_Image
   
  (Node : Bare_Ada_Node
  )

   return String_Type
   ;
--  Return a string containing the filename + the sloc in GNU conformant
--  format. Useful to create diagnostics from a node.

         



 function Ada_Node_P_Custom_Id_Text
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type
   ;
--  Custom Unique identifying text used to recognize this node. Not applicable
--  to all nodes, but on AdaNode because it spans more than one hierarchy of
--  node types.

         



 function Ada_Node_P_Complete_Items
   
  (Node : Bare_Ada_Node
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Completion_Item_Array_Access
   ;
--  Internal method used by ``complete`` to get the array of possible
--  completions for the current node. This method has to be overridden in order
--  to specialize the completion.

         



 function Ada_Node_P_Complete_Item_Weight
   
  (Node : Bare_Ada_Node
      ; Item : Internal_Entity_Basic_Decl
      ; Origin : Bare_Ada_Node
  )

   return Integer
   ;
--  Internal method used by ``complete_items`` that can be used to specialize
--  the completion weight field only.

         



 function Ada_Node_P_Immediate_Declarative_Region
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return the immediate declarative region (:rmlink:`8.1`) corresponding to
--  this node, that is, the concatenation of the declarative parts of itself
--  and all its completion. This does not include the declarative regions of
--  the enclosed declarations.
--
--  This is mainly used to restrict the scope in which to search for the
--  previous part of a declaration.

         



 function Ada_Node_P_Xref_Equation
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  This is the base property for constructing equations that, when solved,
--  will resolve names and types for every sub expression of the expression you
--  call it on. Note that if you call that on any expression, in some context
--  it might lack full information and return multiple solutions. If you want
--  completely precise resolution, you must call that on the outermost node
--  that supports xref_equation.

         



 function Ada_Node_P_Xref_Stop_Resolution
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Ada_Node_P_Stop_Resolution_Equation
   
  (Node : Bare_Ada_Node
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Ada_Node_P_Xref_Initial_Env
   
  (Node : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return the environment to bind initially during the construction of the
--  xref equation for this node. Note that this only makes sense if this node
--  is an xref entry point.

         



 function Ada_Node_P_Xref_Entry_Point
   
  (Node : Bare_Ada_Node
  )

   return Boolean
   ;
--  Designates entities that are entry point for the xref solving
--  infrastructure. If this returns true, then resolve_names can be called on
--  it.
--
--  .. note:: For convenience, and unlike what is defined in the ARM wrt.
--     complete contexts for name resolution, ``xref_entry_points`` can be
--     nested.


   




      

   



         



 function Dispatcher_Abort_Node_P_As_Bool
   
  (Node : Bare_Abort_Node
  )

   return Boolean
   with Inline_Always
   ;
--  Return whether this is an instance of AbortPresent


   




      

   



         



 function Abort_Absent_P_As_Bool
   
  (Node : Bare_Abort_Absent
  )

   return Boolean
   ;



   




      

   



         



 function Abort_Present_P_As_Bool
   
  (Node : Bare_Abort_Present
  )

   return Boolean
   ;



   




      

   



         



 function Dispatcher_Abstract_Node_P_As_Bool
   
  (Node : Bare_Abstract_Node
  )

   return Boolean
   with Inline_Always
   ;
--  Return whether this is an instance of AbstractPresent


   




      

   



         



 function Abstract_Absent_P_As_Bool
   
  (Node : Bare_Abstract_Absent
  )

   return Boolean
   ;



   




      

   



         



 function Abstract_Present_P_As_Bool
   
  (Node : Bare_Abstract_Present
  )

   return Boolean
   ;



   




      

   




   




      

   




   




      

   




   




      

   



         



 function Alternatives_List_P_Enum_Type
   
  (Node : Bare_Alternatives_List
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  If this AlternativesList belongs to a case statement, return the type of
--  the enum this case statement operates on. Null otherwise.

         



 function Alternatives_List_P_Complete_Items
   
  (Node : Bare_Alternatives_List
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Completion_Item_Array_Access
   ;
--  Return possible completions at this point in the file.


   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   



         



 function Assoc_List_P_Actual_For_Param_At
   
  (Node : Bare_Assoc_List
      ; Param : Internal_Entity_Defining_Name
      ; Pos : Integer
      ; Default_Expr : Internal_Entity_Expr
         := No_Entity_Expr
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;
--  Return the actual expression for ``param`` if any, ``default_expr``
--  otherwise.

         



 function Assoc_List_P_Unpacked_Params
   
  (Node : Bare_Assoc_List
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Single_Actual_Array_Access
   ;
--  Given the list of ParamAssoc, that can in certain case designate several
--  actual parameters at once, create an unpacked list of SingleActual
--  instances.

         



 function Assoc_List_P_Zip_With_Params
   
  (Node : Bare_Assoc_List
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Param_Actual_Array_Access
   ;
--  Returns an array of pairs, associating formal parameters to actual
--  expressions. The formals to match are retrieved by resolving the call which
--  this AssocList represents the actuals of.


   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   




   




      

   



         



 function Dispatcher_Aliased_Node_P_As_Bool
   
  (Node : Bare_Aliased_Node
  )

   return Boolean
   with Inline_Always
   ;
--  Return whether this is an instance of AliasedPresent


   




      

   



         



 function Aliased_Absent_P_As_Bool
   
  (Node : Bare_Aliased_Absent
  )

   return Boolean
   ;



   




      

   



         



 function Aliased_Present_P_As_Bool
   
  (Node : Bare_Aliased_Present
  )

   return Boolean
   ;



   




      

   



         



 function Dispatcher_All_Node_P_As_Bool
   
  (Node : Bare_All_Node
  )

   return Boolean
   with Inline_Always
   ;
--  Return whether this is an instance of AllPresent


   




      

   



         



 function All_Absent_P_As_Bool
   
  (Node : Bare_All_Absent
  )

   return Boolean
   ;



   




      

   



         



 function All_Present_P_As_Bool
   
  (Node : Bare_All_Present
  )

   return Boolean
   ;



   




      

   



         



 function Dispatcher_Array_Indices_P_Ndims
   
  (Node : Bare_Array_Indices
  )

   return Integer
   with Inline_Always
   ;
--  Number of dimensions described in this node.

         



 function Dispatcher_Array_Indices_P_Constrain_Index_Expr
   
  (Node : Bare_Array_Indices
      ; Index_Expr : Internal_Entity_Expr
      ; Dim : Integer
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   with Inline_Always
   ;
--  Add a constraint on an expression passed as the index of an array access
--  expression.
--
--  For example:
--
--  .. code::
--
--     type A is array (Integer range 1 .. 10) of Integer;
--
--     A_Inst : A;
--
--     A_Inst (2);
--     --      ^ Will add constraint on lit that it needs to be of type
--     --      Integer.

         



 function Dispatcher_Array_Indices_P_Index_Type
   
  (Node : Bare_Array_Indices
      ; Dim : Integer
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;


         



 function Dispatcher_Array_Indices_P_Is_Static
   
  (Node : Bare_Array_Indices
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Return True iff all index types are static.


   




      

   

      
      procedure Initialize_Fields_For_Constrained_Array_Indices
        (Self : Bare_Constrained_Array_Indices
         ; Constrained_Array_Indices_F_List : Bare_Constraint_List
        );

      
   function Constrained_Array_Indices_F_List
     (Node : Bare_Constrained_Array_Indices) return Bare_Constraint_List;


         



 function Constrained_Array_Indices_P_Ndims
   
  (Node : Bare_Constrained_Array_Indices
  )

   return Integer
   ;


         



 function Constrained_Array_Indices_P_Constrain_Index_Expr
   
  (Node : Bare_Constrained_Array_Indices
      ; Index_Expr : Internal_Entity_Expr
      ; Dim : Integer
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Constrained_Array_Indices_P_Xref_Equation
   
  (Node : Bare_Constrained_Array_Indices
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Constrained_Array_Indices_P_Index_Type
   
  (Node : Bare_Constrained_Array_Indices
      ; Dim : Integer
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Constrained_Array_Indices_P_Is_Static
   
  (Node : Bare_Constrained_Array_Indices
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_Unconstrained_Array_Indices
        (Self : Bare_Unconstrained_Array_Indices
         ; Unconstrained_Array_Indices_F_Types : Bare_Unconstrained_Array_Index_List
        );

      
   function Unconstrained_Array_Indices_F_Types
     (Node : Bare_Unconstrained_Array_Indices) return Bare_Unconstrained_Array_Index_List;


         



 function Unconstrained_Array_Indices_P_Ndims
   
  (Node : Bare_Unconstrained_Array_Indices
  )

   return Integer
   ;


         



 function Unconstrained_Array_Indices_P_Constrain_Index_Expr
   
  (Node : Bare_Unconstrained_Array_Indices
      ; Index_Expr : Internal_Entity_Expr
      ; Dim : Integer
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Unconstrained_Array_Indices_P_Index_Type
   
  (Node : Bare_Unconstrained_Array_Indices
      ; Dim : Integer
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Unconstrained_Array_Indices_P_Xref_Equation
   
  (Node : Bare_Unconstrained_Array_Indices
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Unconstrained_Array_Indices_P_Is_Static
   
  (Node : Bare_Unconstrained_Array_Indices
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_Aspect_Assoc
        (Self : Bare_Aspect_Assoc
         ; Aspect_Assoc_F_Id : Bare_Name
         ; Aspect_Assoc_F_Expr : Bare_Expr
        );

      
   function Aspect_Assoc_F_Id
     (Node : Bare_Aspect_Assoc) return Bare_Name;

      
   function Aspect_Assoc_F_Expr
     (Node : Bare_Aspect_Assoc) return Bare_Expr;


         



 function Aspect_Assoc_P_Xref_Entry_Point
   
  (Node : Bare_Aspect_Assoc
  )

   return Boolean
   ;


         



 function Aspect_Assoc_P_Xref_Equation
   
  (Node : Bare_Aspect_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Aspect_Assoc_P_Stable_Properties_Assoc_Equation
   
  (Node : Bare_Aspect_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Equation for the case where this is an aspect assoc for a Stable_Properties
--  aspect.

         



 function Aspect_Assoc_P_Aspect_Name
   
  (Node : Bare_Aspect_Assoc
      ; N : Internal_Entity_Name
  )

   return String_Type
   ;
--  Return the string representation of the given name, which must be a Name
--  that can appear in an aspect association id.

         



 function Aspect_Assoc_P_Is_Ghost_Code
   
  (Node : Bare_Aspect_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this aspect is ghost code or not. See SPARK RM 6.9.


   




      

   



         



 function Aspect_Clause_P_Xref_Entry_Point
   
  (Node : Bare_Aspect_Clause
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_At_Clause
        (Self : Bare_At_Clause
         ; At_Clause_F_Name : Bare_Base_Id
         ; At_Clause_F_Expr : Bare_Expr
        );

      
   function At_Clause_F_Name
     (Node : Bare_At_Clause) return Bare_Base_Id;

      
   function At_Clause_F_Expr
     (Node : Bare_At_Clause) return Bare_Expr;


         



 function At_Clause_P_Xref_Equation
   
  (Node : Bare_At_Clause
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;



   




      

   

      
      procedure Initialize_Fields_For_Attribute_Def_Clause
        (Self : Bare_Attribute_Def_Clause
         ; Attribute_Def_Clause_F_Attribute_Expr : Bare_Name
         ; Attribute_Def_Clause_F_Expr : Bare_Expr
        );

      
   function Attribute_Def_Clause_F_Attribute_Expr
     (Node : Bare_Attribute_Def_Clause) return Bare_Name;

      
   function Attribute_Def_Clause_F_Expr
     (Node : Bare_Attribute_Def_Clause) return Bare_Expr;


         



 function Attribute_Def_Clause_P_Xref_Equation
   
  (Node : Bare_Attribute_Def_Clause
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;



   




      

   

      
      procedure Initialize_Fields_For_Enum_Rep_Clause
        (Self : Bare_Enum_Rep_Clause
         ; Enum_Rep_Clause_F_Type_Name : Bare_Name
         ; Enum_Rep_Clause_F_Aggregate : Bare_Base_Aggregate
        );

      
   function Enum_Rep_Clause_F_Type_Name
     (Node : Bare_Enum_Rep_Clause) return Bare_Name;

      
   function Enum_Rep_Clause_F_Aggregate
     (Node : Bare_Enum_Rep_Clause) return Bare_Base_Aggregate;


         



 function Enum_Rep_Clause_P_Xref_Equation
   
  (Node : Bare_Enum_Rep_Clause
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Enum_Rep_Clause_P_Params
   
  (Node : Bare_Enum_Rep_Clause
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Param_Actual_Array_Access
   ;
--  Returns an array of pairs, associating enum literals to representation
--  clause actuals.


   




      

   

      
      procedure Initialize_Fields_For_Record_Rep_Clause
        (Self : Bare_Record_Rep_Clause
         ; Record_Rep_Clause_F_Name : Bare_Name
         ; Record_Rep_Clause_F_At_Expr : Bare_Expr
         ; Record_Rep_Clause_F_Components : Bare_Ada_Node_List
        );

      
   function Record_Rep_Clause_F_Name
     (Node : Bare_Record_Rep_Clause) return Bare_Name;

      
   function Record_Rep_Clause_F_At_Expr
     (Node : Bare_Record_Rep_Clause) return Bare_Expr;

      
   function Record_Rep_Clause_F_Components
     (Node : Bare_Record_Rep_Clause) return Bare_Ada_Node_List;


         



 function Record_Rep_Clause_P_Xref_Equation
   
  (Node : Bare_Record_Rep_Clause
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;



   




      

   

      
      procedure Initialize_Fields_For_Aspect_Spec
        (Self : Bare_Aspect_Spec
         ; Aspect_Spec_F_Aspect_Assocs : Bare_Aspect_Assoc_List
        );

      
   function Aspect_Spec_F_Aspect_Assocs
     (Node : Bare_Aspect_Spec) return Bare_Aspect_Assoc_List;



   




      

   



         



 function Dispatcher_Base_Assoc_P_Assoc_Expr
   
  (Node : Bare_Base_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   with Inline_Always
   ;
--  Returns the expression side of this assoc node.


   




      

   

      
      procedure Initialize_Fields_For_Contract_Case_Assoc
        (Self : Bare_Contract_Case_Assoc
         ; Contract_Case_Assoc_F_Guard : Bare_Ada_Node
         ; Contract_Case_Assoc_F_Consequence : Bare_Expr
        );

      
   function Contract_Case_Assoc_F_Guard
     (Node : Bare_Contract_Case_Assoc) return Bare_Ada_Node;

      
   function Contract_Case_Assoc_F_Consequence
     (Node : Bare_Contract_Case_Assoc) return Bare_Expr;


         



 function Contract_Case_Assoc_P_Assoc_Expr
   
  (Node : Bare_Contract_Case_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;



   




      

   

      
      procedure Initialize_Fields_For_Pragma_Argument_Assoc
        (Self : Bare_Pragma_Argument_Assoc
         ; Pragma_Argument_Assoc_F_Name : Bare_Name
         ; Pragma_Argument_Assoc_F_Expr : Bare_Expr
        );

      
   function Pragma_Argument_Assoc_F_Name
     (Node : Bare_Pragma_Argument_Assoc) return Bare_Name;

      
   function Pragma_Argument_Assoc_F_Expr
     (Node : Bare_Pragma_Argument_Assoc) return Bare_Expr;


         



 function Pragma_Argument_Assoc_P_Assoc_Expr
   
  (Node : Bare_Pragma_Argument_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;



   




      

   



         



 function Dispatcher_Base_Formal_Param_Holder_P_Abstract_Formal_Params
   
  (Node : Bare_Base_Formal_Param_Holder
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   with Inline_Always
   ;
--  Return the list of abstract formal parameters for this holder.

         



 function Base_Formal_Param_Holder_P_Unpacked_Formal_Params
   
  (Node : Bare_Base_Formal_Param_Holder
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;
--  Return ``DefiningName`` for all parameters.

         



 function Base_Formal_Param_Holder_P_Formal_Params
   
  (Node : Bare_Base_Formal_Param_Holder
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;
--  Return all parameters as a ``DefiningName`` array. This property doesn't
--  return record discriminants nor variants when called on a record component
--  list.

         



 function Base_Formal_Param_Holder_P_Match_Param_List
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Params : Internal_Entity_Assoc_List
      ; Is_Dottable_Subp : Boolean
      ; Env : Lexical_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Param_Match_Array_Access
   ;


         



 function Base_Formal_Param_Holder_P_Nb_Min_Params
   
  (Node : Bare_Base_Formal_Param_Holder
  )

   return Integer
   ;
--  Return the minimum number of parameters this subprogram can be called while
--  still being a legal call.

         



 function Base_Formal_Param_Holder_P_Nb_Max_Params
   
  (Node : Bare_Base_Formal_Param_Holder
  )

   return Integer
   ;
--  Return the maximum number of parameters this subprogram can be called while
--  still being a legal call.

         



 function Base_Formal_Param_Holder_P_Paramless
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Dottable_Subp : Boolean
      ; Can_Be : Boolean
         := True
  )

   return Boolean
   ;
--  Utility function. Given a subprogram spec and whether the subprogram was
--  referenced using the dot notation, determine if it can be called without
--  parameters (and hence without a callexpr).

         



 function Base_Formal_Param_Holder_P_Is_Matching_Param_List
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Params : Internal_Entity_Assoc_List
      ; Is_Dottable_Subp : Boolean
      ; Env : Lexical_Env
  )

   return Boolean
   ;
--  Return whether a AssocList is a match for this SubpSpec, i.e. whether the
--  argument count (and designators, if any) match.

         



 function Base_Formal_Param_Holder_P_Param_Types
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;
--  Returns the type of each parameter of Self.

         



 function Base_Formal_Param_Holder_P_Param_Modes
   
  (Node : Bare_Base_Formal_Param_Holder
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Mode_Array_Access
   ;
--  Returns the mode of each parameter of Self.

         



 function Base_Formal_Param_Holder_P_Real_Type
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Typ : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the real type denoted by ``typ``, taking into account that ``typ``
--  might be the type of a derived primitive. In that case, return the derived
--  primitive type.

         



 function Base_Formal_Param_Holder_P_Real_Designated_Type
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Typ : Internal_Entity_Type_Expr
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Given a type expression that is part of this subprogram specification (for
--  example, appearing in a parameter specification), return the real type it
--  designates, taking into account the fact that Self might be the
--  specification of an inherited subprogram. Overall, we can distinguish the
--  following cases:
--
--  * Self is a primitive subprogram inherited from a base type and ``typ``
--    designates that base type, in which case we should return the inheriting
--    type.
--
--  * Self is a primitive subprogram inherited from a base type but ``typ``
--    does not designate that base type, in which case we must compute the
--    actual designated type by taking into account the rebindings associated
--    with the base type. This is done by traversing the inheritance hierarchy
--    starting from the inheriting type up to the inherited type and extracting
--    the rebindings that we got along the way.
--
--  * Self is not an inherited primitive subprogram, in which case we simply
--    return the designated type using the normal path.
--
--  The first two points are illustrated with the following example.
--
--  .. code::
--
--     generic
--        type G is private;
--     package Pkg is
--        type T is null record;
--
--        function Foo (Self : T) return G;      --  A
--     end Pkg;
--
--     package My_Pkg is new Pkg (Integer);      --  B
--
--     type My_T is new My_Pkg.T;
--
--     X : My_T    := (null record);
--     Y : Integer := Foo (X);                    -- C
--
--  Resolving the reference to ``Foo`` at line C gets us the function
--  declaration at line A with the appropriate metadata indicating it is a
--  primitive subprogram of T inherited by My_T.
--
--  Calling this property on the ``T`` node from the ``Self : T`` parameter
--  specification is an instance of the first case. We should obviously return
--  ``My_T`` in that case.
--
--  Calling it on ``G`` from the return type specification is an instance of
--  the second case. We traverse up the inheritance hierarchy starting from
--  ``My_T`` and get to ``T [B]``, where ``[B]`` indicates the rebindings
--  corresponding to the instantiation at line B. We can now use those
--  rebindings to compute the actual designated type (the type designated by
--  ``G [B]``) which correctly yields ``Integer``.
--
--  This property is used during the construction of xref equations for call
--  expressions in order to match the right parameter and return types.

         



 function Base_Formal_Param_Holder_P_Call_Argument_Equation
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Param : Internal_Entity_Base_Formal_Param_Decl
      ; Arg : Internal_Entity_Expr
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Generate the equation that binds the type_var of this expression given its
--  corresponding parameter in the context of a subprogram call. This takes
--  into account the fact that the called subprogram might be an inherited
--  primitive.

         



 function Base_Formal_Param_Holder_P_Match_Formal_Params
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Other : Internal_Entity_Base_Formal_Param_Holder
      ; Match_Names : Boolean
         := True
      ; Ignore_First_Param : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Check whether self's params match other's.

         



 function Dispatcher_Base_Formal_Param_Holder_P_Match_Other
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Other : Internal_Entity_Base_Formal_Param_Holder
      ; Match_Names : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Base method of any BaseFormalParamHolder that checks whether the other
--  given BaseFormalParamHolder matches. In practice, this will call
--  match_formal_params, except for BaseSubpSpecs for which it will call
--  match_signature.

         



 function Base_Formal_Param_Holder_P_Match_Other
   
  (Node : Bare_Base_Formal_Param_Holder
      ; Other : Internal_Entity_Base_Formal_Param_Holder
      ; Match_Names : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Base method of any BaseFormalParamHolder that checks whether the other
--  given BaseFormalParamHolder matches. In practice, this will call
--  match_formal_params, except for BaseSubpSpecs for which it will call
--  match_signature.


   




      

   



         



 function Dispatcher_Base_Subp_Spec_P_Name
   
  (Node : Bare_Base_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   with Inline_Always
   ;


         



 function Dispatcher_Base_Subp_Spec_P_Returns
   
  (Node : Bare_Base_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   with Inline_Always
   ;
--  Syntax property. Return the type expression node corresponding to the
--  return of this subprogram spec.

         



 function Dispatcher_Base_Subp_Spec_P_Params
   
  (Node : Bare_Base_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Param_Spec_Array_Access
   with Inline_Always
   ;
--  Returns the array of parameters specification for this subprogram spec.

         



 function Base_Subp_Spec_P_Abstract_Formal_Params
   
  (Node : Bare_Base_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Base_Subp_Spec_P_Match_Return_Type
   
  (Node : Bare_Base_Subp_Spec
      ; Other : Internal_Entity_Base_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subp_Spec_P_Match_Signature
   
  (Node : Bare_Base_Subp_Spec
      ; Other : Internal_Entity_Base_Subp_Spec
      ; Match_Name : Boolean
      ; Use_Entity_Info : Boolean
         := True
      ; Ignore_First_Param : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether SubpSpec's signature matches Self's.
--
--  Note that the comparison for types isn't just a name comparison: it
--  compares the canonical types.
--
--  If match_name is False, then the name of subprogram will not be checked.
--
--  If use_entity_info is True and Entity's metadata has values for fields
--  ``primitive`` and ``primitive_real_type`` (e.g. if it was retrieved from a
--  primitive_env), those will be taken into account and match_signature will
--  return True if ``other`` overrides ``Entity``.
--
--  If ignore_first_param is True, do the signature match by ignoring the
--  Self's first parameter. This can be used for example when matching a
--  TaskType's procedure with one of its parent interface primitives, because
--  the subprogram from the task has an implicit Self parameter which does not
--  appear in the subprogram specification.

         



 function Base_Subp_Spec_P_Match_Other
   
  (Node : Bare_Base_Subp_Spec
      ; Other : Internal_Entity_Base_Formal_Param_Holder
      ; Match_Names : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subp_Spec_P_Defining_Env
   
  (Node : Bare_Base_Subp_Spec
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Helper for BasicDecl.defining_env.

         



 function Base_Subp_Spec_P_Potential_Dottable_Type
   
  (Node : Bare_Base_Subp_Spec
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  If self meets the criteria for being a subprogram callable via the dot
--  notation, return the type of dottable elements.

         



 function Base_Subp_Spec_P_Get_Candidate_Type_For_Primitive
   
  (Node : Bare_Base_Subp_Spec
      ; Type_Expr : Internal_Entity_Type_Expr
      ; Canonicalize : Boolean
         := True
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  If the given type expression designates a type of which Self is a
--  primitive, return that designated type. Otherwise return null.
--
--  If ``canonicalize`` is true, then the returned type will be canonicalized
--  first. Else, the most complete part of the type will be returned.

         



 function Base_Subp_Spec_P_Candidate_Primitive_Subp_Types
   
  (Node : Bare_Base_Subp_Spec
      ; Canonicalize : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;
--  Return the types of which this subprogram is a candidate primitive of. If
--  ``canonicalize`` is true, then the returned types will be canonicalized.

         



 function Base_Subp_Spec_P_Candidate_Primitive_Subp_First_Type
   
  (Node : Bare_Base_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the first type of which this subprogram is a candidate primitive of.

         



 function Base_Subp_Spec_P_Candidate_Primitive_Subp_Tagged_Type
   
  (Node : Bare_Base_Subp_Spec
      ; Canonicalize : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  If this subprogram is a primitive for a tagged type, then return this type.
--  If ``canonicalize`` is true, then the returned types will be canonicalized.

         



 function Base_Subp_Spec_P_Decl_Spec
   
  (Node : Bare_Base_Subp_Spec
      ; Follow_Generic : Boolean
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   ;
--  If this subp spec is that of the body of an entity, this property returns
--  the subp spec of the declaration of that entity. It returns itself
--  otherwise.
--
--  If ``follow_generic`` is set to False, we explicitly return null if this
--  spec is part of a generic subprogram declaration. See
--  ``primitive_decl_spec``.

         



 function Base_Subp_Spec_P_Primitive_Decl_Spec
   
  (Node : Bare_Base_Subp_Spec
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   ;
--  Return the subp spec of the declaration of this potential primitive. Since
--  a generic subprogram cannot be a primitive, we explicitly set
--  ``follow_generic`` to False to filter out those early.

         



 function Base_Subp_Spec_P_As_Primitive_Subp_Type
   
  (Node : Bare_Base_Subp_Spec
      ; Typ : Internal_Entity_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Given a type that was retrieved by one of the ``candidate_primitive_*``
--  properties, return itself if the subp spec actually corresponds to a
--  primitive of this type, otherwise return null. This is needed because the
--  result of the ``candidate_primitive_*`` properties is an approximation.

         



 function Base_Subp_Spec_P_Primitive_Subp_Types
   
  (Node : Bare_Base_Subp_Spec
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;
--  Return the types of which this subprogram is a primitive of.

         



 function Base_Subp_Spec_P_Primitive_Subp_First_Type
   
  (Node : Bare_Base_Subp_Spec
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the first type of which this subprogram is a primitive of.

         



 function Base_Subp_Spec_P_Primitive_Subp_Tagged_Type
   
  (Node : Bare_Base_Subp_Spec
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  If this subprogram is a primitive for a tagged type, then return this type.

         



 function Base_Subp_Spec_P_Has_Controlling_Result
   
  (Node : Bare_Base_Subp_Spec
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this subprogram has a controlling result, i.e. that it is
--  the primitive of a tagged type ``T`` and its return type is ``T`` as well.

         



 function Base_Subp_Spec_P_Dottable_Subp_Of
   
  (Node : Bare_Base_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Returns whether the subprogram containing this spec is a subprogram
--  callable via the dot notation.

         



 function Base_Subp_Spec_P_Return_Type
   
  (Node : Bare_Base_Subp_Spec
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Returns the return type of Self, if applicable (e.g. if Self is a
--  subprogram). Else, returns null.

         



 function Base_Subp_Spec_P_Xref_Entry_Point
   
  (Node : Bare_Base_Subp_Spec
  )

   return Boolean
   ;


         



 function Base_Subp_Spec_P_Xref_Equation
   
  (Node : Bare_Base_Subp_Spec
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Base_Subp_Spec_P_Params
   
  (Node : Bare_Base_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Param_Spec_Array_Access
   ;
--  Returns the array of parameters specification for this subprogram spec.


   




      

   

      
      procedure Initialize_Fields_For_Entry_Spec
        (Self : Bare_Entry_Spec
         ; Entry_Spec_F_Entry_Name : Bare_Defining_Name
         ; Entry_Spec_F_Family_Type : Bare_Ada_Node
         ; Entry_Spec_F_Entry_Params : Bare_Params
        );

      
   function Entry_Spec_F_Entry_Name
     (Node : Bare_Entry_Spec) return Bare_Defining_Name;

      
   function Entry_Spec_F_Family_Type
     (Node : Bare_Entry_Spec) return Bare_Ada_Node;

      
   function Entry_Spec_F_Entry_Params
     (Node : Bare_Entry_Spec) return Bare_Params;


         



 function Entry_Spec_P_Name
   
  (Node : Bare_Entry_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;


         



 function Entry_Spec_P_Params
   
  (Node : Bare_Entry_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Param_Spec_Array_Access
   ;


         



 function Entry_Spec_P_Returns
   
  (Node : Bare_Entry_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Entry_Spec_P_Xref_Equation
   
  (Node : Bare_Entry_Spec
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;



   




      

   



         



 function Enum_Subp_Spec_P_Enum_Decl
   
  (Node : Bare_Enum_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Enum_Literal_Decl
   ;


         



 function Enum_Subp_Spec_P_Name
   
  (Node : Bare_Enum_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;


         



 function Enum_Subp_Spec_P_Returns
   
  (Node : Bare_Enum_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Enum_Subp_Spec_P_Params
   
  (Node : Bare_Enum_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Param_Spec_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Subp_Spec
        (Self : Bare_Subp_Spec
         ; Subp_Spec_F_Subp_Kind : Bare_Subp_Kind
         ; Subp_Spec_F_Subp_Name : Bare_Defining_Name
         ; Subp_Spec_F_Subp_Params : Bare_Params
         ; Subp_Spec_F_Subp_Returns : Bare_Type_Expr
        );

      
   function Subp_Spec_F_Subp_Kind
     (Node : Bare_Subp_Spec) return Bare_Subp_Kind;

      
   function Subp_Spec_F_Subp_Name
     (Node : Bare_Subp_Spec) return Bare_Defining_Name;

      
   function Subp_Spec_F_Subp_Params
     (Node : Bare_Subp_Spec) return Bare_Params;

      
   function Subp_Spec_F_Subp_Returns
     (Node : Bare_Subp_Spec) return Bare_Type_Expr;


         



 function Subp_Spec_P_Name
   
  (Node : Bare_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;


         



 function Subp_Spec_P_Params
   
  (Node : Bare_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Param_Spec_Array_Access
   ;


         



 function Subp_Spec_P_Returns
   
  (Node : Bare_Subp_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;



   




      

   

      
      procedure Initialize_Fields_For_Synthetic_Binary_Spec
        (Self : Bare_Synthetic_Binary_Spec
         ; Synthetic_Binary_Spec_F_Left_Param : Bare_Synthetic_Formal_Param_Decl
         ; Synthetic_Binary_Spec_F_Right_Param : Bare_Synthetic_Formal_Param_Decl
         ; Synthetic_Binary_Spec_F_Return_Type_Expr : Bare_Type_Expr
        );

      
   function Synthetic_Binary_Spec_F_Left_Param
     (Node : Bare_Synthetic_Binary_Spec) return Bare_Synthetic_Formal_Param_Decl;

      
   function Synthetic_Binary_Spec_F_Right_Param
     (Node : Bare_Synthetic_Binary_Spec) return Bare_Synthetic_Formal_Param_Decl;

      
   function Synthetic_Binary_Spec_F_Return_Type_Expr
     (Node : Bare_Synthetic_Binary_Spec) return Bare_Type_Expr;


         



 function Synthetic_Binary_Spec_P_Name
   
  (Node : Bare_Synthetic_Binary_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;


         



 function Synthetic_Binary_Spec_P_Returns
   
  (Node : Bare_Synthetic_Binary_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Synthetic_Binary_Spec_P_Abstract_Formal_Params
   
  (Node : Bare_Synthetic_Binary_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Synthetic_Unary_Spec
        (Self : Bare_Synthetic_Unary_Spec
         ; Synthetic_Unary_Spec_F_Right_Param : Bare_Synthetic_Formal_Param_Decl
         ; Synthetic_Unary_Spec_F_Return_Type_Expr : Bare_Synthetic_Type_Expr
        );

      
   function Synthetic_Unary_Spec_F_Right_Param
     (Node : Bare_Synthetic_Unary_Spec) return Bare_Synthetic_Formal_Param_Decl;

      
   function Synthetic_Unary_Spec_F_Return_Type_Expr
     (Node : Bare_Synthetic_Unary_Spec) return Bare_Synthetic_Type_Expr;


         



 function Synthetic_Unary_Spec_P_Name
   
  (Node : Bare_Synthetic_Unary_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;


         



 function Synthetic_Unary_Spec_P_Returns
   
  (Node : Bare_Synthetic_Unary_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Synthetic_Unary_Spec_P_Abstract_Formal_Params
   
  (Node : Bare_Synthetic_Unary_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Component_List
        (Self : Bare_Component_List
         ; Component_List_F_Components : Bare_Ada_Node_List
         ; Component_List_F_Variant_Part : Bare_Variant_Part
        );

      
   function Component_List_F_Components
     (Node : Bare_Component_List) return Bare_Ada_Node_List;

      
   function Component_List_F_Variant_Part
     (Node : Bare_Component_List) return Bare_Variant_Part;


         



 function Component_List_P_Type_Def
   
  (Node : Bare_Component_List
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Def
   ;


         



 function Component_List_P_Type_Decl
   
  (Node : Bare_Component_List
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Decl
   ;


         



 function Component_List_P_Parent_Component_List
   
  (Node : Bare_Component_List
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Component_List
   ;


         



 function Component_List_P_Abstract_Formal_Params_For_Assocs
   
  (Node : Bare_Component_List
      ; Assocs : Internal_Entity_Assoc_List
      ; Stop_Recurse_At : Internal_Entity_Base_Type_Decl
         := No_Entity_Base_Type_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Component_List_P_Abstract_Formal_Params_For_Delta_Assocs
   
  (Node : Bare_Component_List
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;
--  Return all the components lists of this ComponentList, which includes the
--  current and parent components, and all the components lists of the variant
--  part, recursively, regardless of the discriminants values. This list is
--  used for DeltaAggregate name resolution.

         



 function Component_List_P_Abstract_Formal_Params_Impl
   
  (Node : Bare_Component_List
      ; Discriminants : Internal_Param_Match_Array_Access
      ; Include_Discriminants : Boolean
         := True
      ; Recurse : Boolean
         := True
      ; Stop_Recurse_At : Internal_Entity_Base_Type_Decl
         := No_Entity_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Component_List_P_Abstract_Formal_Params
   
  (Node : Bare_Component_List
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Component_List_P_Shapes
   
  (Node : Bare_Component_List
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Shape_Array_Access
   ;
--  Return all the possible shapes that this component list spans.


   




      

   



         



 function Discriminant_Part_P_Abstract_Formal_Params
   
  (Node : Bare_Discriminant_Part
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Known_Discriminant_Part
        (Self : Bare_Known_Discriminant_Part
         ; Known_Discriminant_Part_F_Discr_Specs : Bare_Discriminant_Spec_List
        );

      
   function Known_Discriminant_Part_F_Discr_Specs
     (Node : Bare_Known_Discriminant_Part) return Bare_Discriminant_Spec_List;


         



 function Known_Discriminant_Part_P_Abstract_Formal_Params
   
  (Node : Bare_Known_Discriminant_Part
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;



   




      

   




   




      

   

      
      procedure Initialize_Fields_For_Entry_Completion_Formal_Params
        (Self : Bare_Entry_Completion_Formal_Params
         ; Entry_Completion_Formal_Params_F_Params : Bare_Params
        );

      
   function Entry_Completion_Formal_Params_F_Params
     (Node : Bare_Entry_Completion_Formal_Params) return Bare_Params;


         



 function Entry_Completion_Formal_Params_P_Abstract_Formal_Params
   
  (Node : Bare_Entry_Completion_Formal_Params
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Generic_Formal_Part
        (Self : Bare_Generic_Formal_Part
         ; Generic_Formal_Part_F_Decls : Bare_Ada_Node_List
        );

      
   function Generic_Formal_Part_F_Decls
     (Node : Bare_Generic_Formal_Part) return Bare_Ada_Node_List;


         



 function Generic_Formal_Part_P_Abstract_Formal_Params
   
  (Node : Bare_Generic_Formal_Part
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Generic_Formal_Part_P_Use_Clauses_Envs
   
  (Node : Bare_Generic_Formal_Part
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Returns the envs for all the use clauses declared in this generic formal
--  part.


   




      

   

      
      procedure Initialize_Fields_For_Base_Record_Def
        (Self : Bare_Base_Record_Def
         ; Base_Record_Def_F_Components : Bare_Component_List
        );

      
   function Base_Record_Def_F_Components
     (Node : Bare_Base_Record_Def) return Bare_Component_List;


         



 function Base_Record_Def_P_Comps
   
  (Node : Bare_Base_Record_Def
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Component_List
   ;



   




      

   

      
      procedure Initialize_Fields_For_Null_Record_Def
        (Self : Bare_Null_Record_Def
         ; Base_Record_Def_F_Components : Bare_Component_List
        );



   




      

   

      
      procedure Initialize_Fields_For_Record_Def
        (Self : Bare_Record_Def
         ; Base_Record_Def_F_Components : Bare_Component_List
        );



   




      

   



         



 function Dispatcher_Basic_Assoc_P_Expr
   
  (Node : Bare_Basic_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   with Inline_Always
   ;


         



 function Dispatcher_Basic_Assoc_P_Names
   
  (Node : Bare_Basic_Assoc
  )

   return Bare_Ada_Node_Array_Access
   with Inline_Always
   ;


         



 function Basic_Assoc_P_Get_Params
   
  (Node : Bare_Basic_Assoc
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;
--  Return the list of parameters that this association refers to.


   




      

   

      
      procedure Initialize_Fields_For_Aggregate_Assoc
        (Self : Bare_Aggregate_Assoc
         ; Aggregate_Assoc_F_Designators : Bare_Alternatives_List
         ; Aggregate_Assoc_F_R_Expr : Bare_Expr
        );

      
   function Aggregate_Assoc_F_Designators
     (Node : Bare_Aggregate_Assoc) return Bare_Alternatives_List;

      
   function Aggregate_Assoc_F_R_Expr
     (Node : Bare_Aggregate_Assoc) return Bare_Expr;


         



 function Aggregate_Assoc_P_Expr
   
  (Node : Bare_Aggregate_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;


         



 function Aggregate_Assoc_P_Names
   
  (Node : Bare_Aggregate_Assoc
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Aggregate_Assoc_P_Xref_Stop_Resolution
   
  (Node : Bare_Aggregate_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Aggregate_Assoc_P_Base_Aggregate
   
  (Node : Bare_Aggregate_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Aggregate
   ;


         



 function Aggregate_Assoc_P_Xref_Equation
   
  (Node : Bare_Aggregate_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Aggregate_Assoc_P_Record_Assoc_Equation
   
  (Node : Bare_Aggregate_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Equation for the case where this is an aggregate assoc for a record type.

         



 function Aggregate_Assoc_P_Array_Assoc_Equation
   
  (Node : Bare_Aggregate_Assoc
      ; Atd : Internal_Entity_Array_Type_Def
      ; Mra : Internal_Multidim_Aggregate_Info
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Equation for the case where this is an aggregate assoc for an array type.

         



 function Aggregate_Assoc_P_Globals_Assoc_Equation
   
  (Node : Bare_Aggregate_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Equation for the case where this is an aggregate assoc for a Globals
--  aspect.

         



 function Aggregate_Assoc_P_Depends_Assoc_Equation
   
  (Node : Bare_Aggregate_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Equation for the case where this is an aggregate assoc for a Depends
--  aspect.

         



 function Aggregate_Assoc_P_Test_Case_Assoc_Equation
   
  (Node : Bare_Aggregate_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Equation for the case where this is an aggregate assoc for a Test_Case
--  aspect.

         



 function Aggregate_Assoc_P_Contract_Cases_Assoc_Equation
   
  (Node : Bare_Aggregate_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Equation for the case where this is an aggregate assoc for a Contract_Cases
--  aspect. Both the ``guard`` and the ``consequence`` must be of type Boolean.

         



 function Aggregate_Assoc_P_Exprs_Assoc_Equation
   
  (Node : Bare_Aggregate_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Return the xref equation for the case where this is an aggregate assoc in
--  which all the designator as well as the RHS are usual expressions which can
--  be recursively resolved.


   




      

   

      
      procedure Initialize_Fields_For_Multi_Dim_Array_Assoc
        (Self : Bare_Multi_Dim_Array_Assoc
         ; Aggregate_Assoc_F_Designators : Bare_Alternatives_List
         ; Aggregate_Assoc_F_R_Expr : Bare_Expr
        );



   




      

   

      
      procedure Initialize_Fields_For_Composite_Constraint_Assoc
        (Self : Bare_Composite_Constraint_Assoc
         ; Composite_Constraint_Assoc_F_Ids : Bare_Discriminant_Choice_List
         ; Composite_Constraint_Assoc_F_Constraint_Expr : Bare_Ada_Node
        );

      
   function Composite_Constraint_Assoc_F_Ids
     (Node : Bare_Composite_Constraint_Assoc) return Bare_Discriminant_Choice_List;

      
   function Composite_Constraint_Assoc_F_Constraint_Expr
     (Node : Bare_Composite_Constraint_Assoc) return Bare_Ada_Node;


         



 function Composite_Constraint_Assoc_P_Expr
   
  (Node : Bare_Composite_Constraint_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;


         



 function Composite_Constraint_Assoc_P_Names
   
  (Node : Bare_Composite_Constraint_Assoc
  )

   return Bare_Ada_Node_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Iterated_Assoc
        (Self : Bare_Iterated_Assoc
         ; Iterated_Assoc_F_Spec : Bare_For_Loop_Spec
         ; Iterated_Assoc_F_R_Expr : Bare_Expr
        );

      
   function Iterated_Assoc_F_Spec
     (Node : Bare_Iterated_Assoc) return Bare_For_Loop_Spec;

      
   function Iterated_Assoc_F_R_Expr
     (Node : Bare_Iterated_Assoc) return Bare_Expr;


         



 function Iterated_Assoc_P_Expr
   
  (Node : Bare_Iterated_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;


         



 function Iterated_Assoc_P_Names
   
  (Node : Bare_Iterated_Assoc
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Iterated_Assoc_P_Base_Aggregate
   
  (Node : Bare_Iterated_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Aggregate
   ;


         



 function Iterated_Assoc_P_Xref_Stop_Resolution
   
  (Node : Bare_Iterated_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Iterated_Assoc_P_Xref_Equation
   
  (Node : Bare_Iterated_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Iterated_Assoc_P_Xref_Equation_For_Reduce
   
  (Node : Bare_Iterated_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  Equation specialization for ``ValueSequence`` name resolution (part of
--  ``ReduceAttributeRef``).


   




      

   

      
      procedure Initialize_Fields_For_Param_Assoc
        (Self : Bare_Param_Assoc
         ; Param_Assoc_F_Designator : Bare_Ada_Node
         ; Param_Assoc_F_R_Expr : Bare_Expr
        );

      
   function Param_Assoc_F_Designator
     (Node : Bare_Param_Assoc) return Bare_Ada_Node;

      
   function Param_Assoc_F_R_Expr
     (Node : Bare_Param_Assoc) return Bare_Expr;


         



 function Param_Assoc_P_Expr
   
  (Node : Bare_Param_Assoc
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;


         



 function Param_Assoc_P_Names
   
  (Node : Bare_Param_Assoc
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Param_Assoc_P_Xref_Entry_Point
   
  (Node : Bare_Param_Assoc
  )

   return Boolean
   ;


         



 function Param_Assoc_P_Xref_Equation
   
  (Node : Bare_Param_Assoc
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Param_Assoc_P_Is_Static_Attribute_Assoc
   
  (Node : Bare_Param_Assoc
  )

   return Boolean
   ;



   




      

   


      
   function Basic_Decl_F_Aspects
     (Node : Bare_Basic_Decl) return Bare_Aspect_Spec;


         



 function Basic_Decl_P_Env_Hook_Basic_Decl
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;
--  Helper for AdaNode.env_hook. Handle library-level unit decl nodes.

         



 function Basic_Decl_P_Populate_Body_Unit
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;
--  For library-level subprogram declarations, we always want to populate the
--  unit containing the body, so that the lexical envs always contain the spec
--  and the body, no matter which was initially requested.

         



 function Basic_Decl_P_Has_Top_Level_Env_Name_Impl
   
  (Node : Bare_Basic_Decl
      ; Allow_Bodies : Boolean
  )

   return Boolean
   ;
--  Helper for ``has_top_level_env_name``. See its docstring for more
--  information.

         



 function Basic_Decl_P_Has_Top_Level_Env_Name
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;
--  Return True if this declaration is exposed to other compilation units. This
--  is equivalent to asking if this declaration's env should be named.
--
--  Find a few examples below.
--
--  .. code::
--
--     package A is                     -- True
--         package B is                 -- True
--             procedure Foo;           -- True
--         end B;
--     end A;
--
--     package body A is                -- True
--         package B is                 -- True
--             procedure Foo;           -- True
--         end B;
--     end A;
--
--     package body A is                -- True
--         package body B is            -- True
--             procedure Foo;           -- False
--         end B;
--     end A;
--
--     package body A is                -- True
--         package body B is            -- True
--             procedure Foo is null;   -- True
--         end B;
--     end A;
--
--     package body A is                -- True
--         procedure B is               -- True
--             procedure Foo is null;   -- False
--         begin
--             ...
--         end B;
--     end A;
--
--     procedure A is                   -- True
--         procedure Foo;               -- True
--     begin
--         ...
--     end A;
--
--     procedure A is                   -- True
--         package body B is            -- False
--             procedure Foo is null;   -- False
--         end B;
--     begin
--         ...
--     end A;
--
--     procedure A is                   -- True
--         package B is                 -- True
--         end B;
--
--         package body B is            -- True
--         end B;
--     begin
--     end A;

         



 function Basic_Decl_P_Env_Spec_Fully_Qualified_Name_Impl
   
  (Node : Bare_Basic_Decl
      ; Self_Env : Lexical_Env
  )

   return String_Type
   ;
--  Helper to implement ``env_spec_fully_qualified_name``.

         



 function Basic_Decl_P_Env_Spec_Fully_Qualified_Name
   
  (Node : Bare_Basic_Decl
  )

   return String_Type
   ;
--  Return a the fully qualified name of this declaration to be used by env
--  specs. This should not be used elsewhere, as it does some assumption about
--  envs that are not True anymore after envs are populated.

         



 function Basic_Decl_P_Top_Level_Env_Name
   
  (Node : Bare_Basic_Decl
  )

   return String_Type
   ;
--  Return the name that this BasicDecl should use to create its lexical
--  environment. An empty name is returned if it shouldn't use a named env.

         



 function Dispatcher_Basic_Decl_P_Child_Decl_Initial_Env_Name
   
  (Node : Bare_Basic_Decl
      ; Private_Part : Boolean
         := False
  )

   return Symbol_Type
   with Inline_Always
   ;
--  If this is a child declaration, return the lexical environment name of its
--  parent declaration. Otherwise return an empty string.
--
--  If ``private_part`` is True, return the env name of the private part of its
--  parent.

         



 function Basic_Decl_P_Child_Decl_Initial_Env
   
  (Node : Bare_Basic_Decl
      ; Private_Part : Boolean
         := False
  )

   return Internal_Designated_Env
   ;
--  Return the initial env for this basic declaration. This is used to set the
--  parent environment of a child declaration to its actual parent in terms of
--  Ada semantics.
--
--  If ``private_part`` is True, return the env of the private part of its
--  parent.

         



 function Basic_Decl_P_Basic_Decl_Env_Assocs
   
  (Node : Bare_Basic_Decl
      ; Dest_Env : Internal_Designated_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;
--  Return an array of env assocs that should be added in the environment
--  designated by ``dest_env``. In the general case, it simply adds an entry
--  for Self using this declaration's name as key. However, if Self corresponds
--  to the declaration of a ``"="`` operator, we also generate an order to add
--  an entry for the ``"/="`` operator, as described in :rmlink:`4.5.2` 25.a.

         



 function Basic_Decl_P_Child_Decl_Env_Assocs
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;
--  Return the env association that describes where to register this basic
--  declaration. For a child declaration in particular, this orders adding
--  itself inside its parent declaration's environment.
--
--  .. note:: This intercepts user-defined "=" operators so as to introduce an
--     implicit "/=" operator, as per :rmlink:`4.5.2` 25.a.

         



 function Basic_Decl_P_Is_Formal
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;
--  Whether this decl is the nested decl of a generic formal declaration.

         



 function Dispatcher_Basic_Decl_P_Previous_Part_For_Decl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   with Inline_Always
   ;
--  Return the previous part for this decl, if applicable.
--
--  .. note:: It is not named previous_part, because BaseTypeDecl has a more
--     precise version of previous_part that returns a BaseTypeDecl. Probably,
--     we want to rename the specific versions, and have the root property be
--     named previous_part. (TODO R925-008)

         



 function Basic_Decl_P_Canonical_Part
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the canonical part for this decl. In the case of decls composed of
--  several parts, the canonical part will be the first part.

         



 function Basic_Decl_P_All_Previous_Parts
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  Return all previous parts of this entity, where the first part is at the
--  beginning of the array.

         



 function Basic_Decl_P_All_Next_Parts
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  Return all next parts of this entity, where the last part is at the end of
--  the array.

         



 function Basic_Decl_P_All_Parts
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  Return all parts that define this entity, sorted from first part to last
--  part.

         



 function Dispatcher_Basic_Decl_P_Is_Static_Decl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Return whether this declaration is static.

         



 function Basic_Decl_P_Unshed_Rebindings
   
  (Node : Bare_Basic_Decl
      ; Rebindings : Env_Rebindings
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Put ``rebindings`` back on ``Entity`` if ``Entity`` is rebound somewhere in
--  the chain of rebindings. Ensure coherency, e.g. that if Entity already has
--  some rebindings, the one that we add are a superset of the one it already
--  has.

         



 function Dispatcher_Basic_Decl_P_Is_Library_Item
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   with Inline_Always
   ;
--  Return whether this is a top-level element.

         



 function Basic_Decl_P_Decl_Private_Part
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Private_Part
   ;


         



 function Dispatcher_Basic_Decl_P_Declarative_Parts
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   with Inline_Always
   ;
--  Return the declarative parts directly associated to this BasicDecl, if any.

         



 function Basic_Decl_P_Immediate_Declarative_Region
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Dispatcher_Basic_Decl_P_Get_Aspect_Assoc
   
  (Node : Bare_Basic_Decl
      ; Name : Symbol_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Aspect_Assoc
   with Inline_Always
   ;
--  Return the aspect with name ``name`` for this entity.

         



 function Basic_Decl_P_Get_Aspect_Spec_Expr
   
  (Node : Bare_Basic_Decl
      ; Name : Symbol_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;
--  Return the expression associated to the aspect with name ``name`` for this
--  entity.

         



 function Basic_Decl_P_Library_Item_Pragmas
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Pragma_Node_List
   ;
--  If this entity is a library item, return the compilation unit pragmas.

         



 function Basic_Decl_P_Get_Aspect
   
  (Node : Bare_Basic_Decl
      ; Name : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Aspect
   ;
--  Return the aspect with name ``name`` associated to this entity.
--
--  Aspects are properties of entities that can be specified by the Ada
--  program, either via aspect specifications, pragmas, or attributes.
--
--  This will return the syntactic node corresponding to attribute directly.
--
--  Note: for some aspects (e.g. Inline), Libadalang will check if they are
--  defined on any part of the entity.

         



 function Basic_Decl_P_Has_Aspect
   
  (Node : Bare_Basic_Decl
      ; Name : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Returns whether the boolean aspect named ``name`` is set on the entity
--  represented by this node.
--
--  "Aspect" is used as in RM terminology (see :rmlink:`13`).

         



 function Basic_Decl_P_Get_Pragma
   
  (Node : Bare_Basic_Decl
      ; Name : Symbol_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Pragma_Node
   ;
--  Return the pragma with name ``name`` associated to this entity.
--
--  Please use the ``p_get_aspects`` property instead if you are interested in
--  aspects, i.e. information that can be represented by either aspect
--  specification nodes, pragma nodes or attribute definition nodes.

         



 function Basic_Decl_P_Get_Representation_Clause
   
  (Node : Bare_Basic_Decl
      ; Name : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Attribute_Def_Clause
   ;
--  Return the representation clause associated to this type decl that defines
--  the given attribute name.

         



 function Basic_Decl_P_Get_At_Clause
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_At_Clause
   ;
--  Return the at clause associated to this declaration.

         



 function Dispatcher_Basic_Decl_P_Is_Imported
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether this declaration is imported from another language.

         



 function Basic_Decl_P_Is_Ghost_Code
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this declaration is ghost code or not. See SPARK RM 6.9.

         



 function Basic_Decl_P_Get_Instantiation
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Generic_Instantiation
   ;
--  Assuming Self is a Generic*Internal node (BasicDecl is their greatest
--  common parent), return the GenericInstantiation node from which this
--  Generic*Internal node is derived.
--
--  .. attention:: If this Generic*Internal is not part of an instantiation,
--     but has been fetched through the formal generic subprogram, this will
--     return None. None is also returned if the rebindings do not correspond
--     to the instantiation of this generic declaration.

         



 function Basic_Decl_P_Is_Compilation_Unit_Root
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;
--  Whether a BasicDecl is the root decl for its unit.

         



 function Basic_Decl_P_Populate_Dependent_Units
   
  (Node : Bare_Basic_Decl
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Basic_Decl_P_Should_Ref_Generic_Formals
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;
--  Helper property used to determine whether we should add a referenced_env to
--  the generic formal part of a given entity.

         



 function Basic_Decl_P_Is_In_Public_Part
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;


         



 function Dispatcher_Basic_Decl_P_Is_In_Private_Part
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;


         



 function Basic_Decl_P_Is_Visible
   
  (Node : Bare_Basic_Decl
      ; From_Node : Internal_Entity
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this declaration is visible from the point of view of the
--  given ``origin`` node.
--
--  .. attention:: Only package-level (public or private) declarations are
--     supported for now.

         



 function Basic_Decl_P_Subp_Decl_Match_Signature
   
  (Node : Bare_Basic_Decl
      ; Other : Internal_Entity_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Basic_Decl_P_Base_Subp_Declarations_Impl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  Actual implementation of ``base_subp_declarations`` that already assumes
--  Entity is a subprogram.

         



 function Basic_Decl_P_Base_Subp_Declarations
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  If Self declares a primitive subprogram of some tagged type T, return the
--  set of all subprogram declarations that it overrides (including itself).
--
--  .. note:: for the moment this only works for tagged types. Remains to be
--     seen if we need to extend it.

         



 function Basic_Decl_P_Root_Subp_Declarations_Impl
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
      ; Imprecise_Fallback : Boolean
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  Actual implementation of ``root_subp_declarations`` that already assumes
--  Entity is a subprogram.

         



 function Basic_Decl_P_Root_Subp_Declarations
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  If Self declares a primitive subprogram of some tagged type T, return the
--  root subprogram declarations that it overrides. There can be several, as in
--  the following scenario:
--
--  * package Root defines the root tagged type T and subprogram Foo.
--
--  * package Itf defines interface I and abstract subprogram Foo.
--
--  * package D defines "type U is new Root.T and Itf.I" and an overriding
--    subprogram Foo.
--
--  Here, root_subp_declarations of Foo defined in package D will return both
--  Foo from package Root and Foo from package Itf.

         



 function Basic_Decl_P_Find_All_Overrides
   
  (Node : Bare_Basic_Decl
      ; Units : Internal_Unit_Array_Access
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  If Self is the declaration of a primitive of some type T, return the list
--  of all subprogram that override this subprogram among the given units.

         



 function Dispatcher_Basic_Decl_P_Defining_Names
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   with Inline_Always
   ;
--  Get all the names of this basic declaration.

         



 function Basic_Decl_P_Defining_Name
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;
--  Get the name of this declaration. If this declaration has several names, it
--  will return the first one.

         



 function Dispatcher_Basic_Decl_P_Defining_Env
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   with Inline_Always
   ;
--  Return a lexical environment that contains entities that are accessible as
--  suffixes when Self is a prefix.

         



 function Basic_Decl_P_Defining_Name_Or_Raise
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;
--  Return the defining name of this ``BasicDecl``, if and only if there is a
--  unique defining name for it. Otherwise, raise a property error.

         



 function Basic_Decl_P_Identity_Type
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Dispatcher_Basic_Decl_P_Array_Ndims
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Integer
   with Inline_Always
   ;


         



 function Basic_Decl_P_Is_Array
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Dispatcher_Basic_Decl_P_Expr_Type
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;
--  Return the type declaration corresponding to this basic declaration has
--  when it is used in an expression context. For example, for this basic
--  declaration:
--
--  .. code::
--
--     type Int is range 0 .. 100;
--
--     A : Int := 12;
--
--  the declaration of the Int type will be returned. For this declaration:
--
--  .. code::
--
--     type F is delta 0.01 digits 10;
--
--     function B return F;
--
--  expr_type will return the declaration of the type F.

         



 function Dispatcher_Basic_Decl_P_Type_Expression
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   with Inline_Always
   ;
--  Return the type expression for this BasicDecl if applicable, a null
--  otherwise.

         



 function Basic_Decl_P_Subp_Spec_Or_Null
   
  (Node : Bare_Basic_Decl
      ; Follow_Generic : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   ;
--  If Self is a Subp, returns the specification of this subprogram.
--
--  If ``follow_generic`` is True, will also work for instances of
--  ``GenericSubpDecl``.

         



 function Basic_Decl_P_Formal_Param_Holder_Or_Null
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Holder
   ;


         



 function Basic_Decl_P_Is_Subprogram
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;
--  Return True if self is a subprogram node in the general sense (which is, an
--  entity that can be called). This includes separates and entries.
--
--  .. attention: This is a purely syntactic query and will return True for
--     everything that is a syntactic entity that can be called like a
--     subprogram in some contexts, even generic formal subprograms for
--     example.

         



 function Basic_Decl_P_Is_Valid_Reducer_Candidate
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return True if self is a subprogram node that is a valid reducer candidate
--  as per RM 4.5.10 definition of the reducer program used by the ``'Reduce``
--  attribute (Ada 2022).

         



 function Basic_Decl_P_Is_Stream_Subprogram_For_Type
   
  (Node : Bare_Basic_Decl
      ; Typ : Internal_Entity_Base_Type_Decl
      ; Return_Obj : Boolean
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Basic_Decl_P_Is_Put_Image_Subprogram_For_Type
   
  (Node : Bare_Basic_Decl
      ; Typ : Internal_Entity_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this subprogram has the correct profile to be given as
--  argument to the ``Put_Image`` aspect.

         



 function Basic_Decl_P_Can_Be_Paramless
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return true if entity can be a paramless subprogram entity, when used in an
--  expression context.

         



 function Basic_Decl_P_Is_Paramless
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return true if entity is a paramless subprogram entity, when used in an
--  expression context.

         



 function Dispatcher_Basic_Decl_P_Constrain_Prefix
   
  (Node : Bare_Basic_Decl
      ; Prefix : Bare_Expr
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   with Inline_Always
   ;
--  This method is used when self is a candidate suffix in a dotted expression,
--  to express the potential constraint that the suffix could express on the
--  prefix.
--
--  For example, given this code:
--
--  .. code::
--
--     1 type P is record
--     2     A, B : Integer;
--     3 end record;
--     4
--     5 P_Inst : P;
--     7
--     8 P_Inst.A;
--       ^^^^^^^^
--
--  A references the A ComponentDecl at line 2, and the constraint that we want
--  to express on the prefix (P_Inst), is that it needs to be of type P.

         



 function Basic_Decl_P_Relative_Name
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Single_Tok_Node
   ;
--  Return the relative name for Self. If Self's defining name is ``A.B.C``,
--  return ``C`` as a node.

         



 function Basic_Decl_P_Relative_Name_Text
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Symbol_Type
   ;
--  Return the relative name for Self, as text.

         



 function Basic_Decl_P_Name_Symbol
   
  (Node : Bare_Basic_Decl
  )

   return Symbol_Type
   ;


         



 function Basic_Decl_P_Basic_Decl_Next_Part_For_Decl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Implementation of next_part_for_decl for basic decls, that can be reused by
--  subclasses when they override next_part_for_decl.

         



 function Dispatcher_Basic_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   with Inline_Always
   ;
--  Return the next part of this declaration, if applicable.
--
--  .. note:: It is not named next_part, because BaseTypeDecl has a more
--     precise version of next_part that returns a BaseTypeDecl. Probably, we
--     want to rename the specific versions, and have the root property be
--     named next_part. (TODO R925-008)

         



 function Basic_Decl_P_Body_Part_For_Decl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Body_Node
   ;
--  Return the body corresponding to this declaration, if applicable.
--
--  .. note:: It is not named body_part, subclasses have more precise versions
--     named body_part and returning a more precise result. Probably, we want
--     to rename the specific versions, and have the root property be named
--     body_part. (TODO R925-008)

         



 function Dispatcher_Basic_Decl_P_Next_Part_For_Name
   
  (Node : Bare_Basic_Decl
      ; Sym : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   with Inline_Always
   ;
--  Internal method for computing the next part of a basic decl according to
--  one of its defining names. By default, this property behaves just like
--  ``next_part_for_decl``. However it can be overriden for node types for
--  which the next part depends on the defining name to consider. One example
--  of that are constant declarations:
--
--  .. code:: ada
--
--     package Pkg is
--         X, Y : constant Integer;
--     private
--         X : constant Integer := 1;
--         Y : constant Integer := 2;
--     end Pkg;
--
--  So, ``next_part_for_name`` is overriden in ``ObjectDecl``.

         



 function Dispatcher_Basic_Decl_P_Previous_Part_For_Name
   
  (Node : Bare_Basic_Decl
      ; Sym : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   with Inline_Always
   ;
--  Internal method for computing the previous part of a basic decl according
--  to one of its defining names. By default, this property behaves just like
--  ``next_part_for_decl``. However it can be overriden for node types for
--  which the previous part depends on the defining name to consider. One
--  example of that are subprogram parameters:
--
--  .. code:: ada
--
--     package Pkg is
--         X : constant Integer;
--         Y : constant Integer;
--     private
--         X, Y : constant Integer := 1;
--     end Pkg;
--
--  So, ``previous_part_for_name`` is overriden in ``ObjectDecl``.

         



 function Basic_Decl_P_Canonical_Part_For_Name
   
  (Node : Bare_Basic_Decl
      ; Sym : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the canonical part for this decl. In the case of decls composed of
--  several parts, the canonical part will be the first part.

         



 function Basic_Decl_P_Most_Visible_Part
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Given an origin node and the entity represented by Self, this property
--  returns the most visible completion of Self that can be seen by origin,
--  according to Ada's visibility rules.

         



 function Basic_Decl_P_Most_Visible_Part_For_Name
   
  (Node : Bare_Basic_Decl
      ; Sym : Symbol_Type
      ; Origin : Bare_Ada_Node
      ; Imprecise_Fallback : Boolean
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Internal method for computing the most visible part of a basic decl
--  according to one of its defining names.

         



 function Basic_Decl_P_Fully_Qualified_Name_Impl
   
  (Node : Bare_Basic_Decl
      ; Include_Profile : Boolean
         := False
      ; Dn : Internal_Entity_Defining_Name
         := No_Entity_Defining_Name
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type_Array_Access
   ;
--  Return the fully qualified name corresponding to this declaration, as an
--  array of symbols.
--
--  If ``dn`` is null, take the first defining name for the declaration. Else,
--  assume that dn is one of the defining names for this declaration.

         



 function Basic_Decl_P_Fully_Qualified_Name_String_Array
   
  (Node : Bare_Basic_Decl
      ; Include_Profile : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type_Array_Access
   ;
--  Return the fully qualified name corresponding to this declaration, as an
--  array of symbols.

         



 function Basic_Decl_P_Fully_Qualified_Name_Array
   
  (Node : Bare_Basic_Decl
      ; Include_Profile : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Symbol_Type_Array_Access
   ;
--  Return the fully qualified name corresponding to this declaration, as an
--  array of symbols.

         



 function Basic_Decl_P_Fully_Qualified_Name
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type
   ;
--  Return the fully qualified name corresponding to this declaration.

         



 function Basic_Decl_P_Canonical_Fully_Qualified_Name_Impl
   
  (Node : Bare_Basic_Decl
      ; Include_Profile : Boolean
         := False
      ; Dn : Internal_Entity_Defining_Name
         := No_Entity_Defining_Name
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type
   ;
--  Implementation of canonical_fully_qualified_name.

         



 function Basic_Decl_P_Canonical_Fully_Qualified_Name
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type
   ;
--  Return a canonical representation of the fully qualified name corresponding
--  to this declaration.

         



 function Basic_Decl_P_Unique_Identifying_Name_Impl
   
  (Node : Bare_Basic_Decl
      ; Dn : Internal_Entity_Defining_Name
         := No_Entity_Defining_Name
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type
   ;
--  Implementation for unique_identifying_name.

         



 function Basic_Decl_P_Unique_Identifying_Name
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type
   ;
--  Return a unique identifying name for this declaration, provided this
--  declaration is a public declaration. In the case of subprograms, this will
--  include the profile.
--
--  .. attention:: This will only return a unique name for public declarations.
--     Notably, anything nested in an unnamed declare block won't be handled
--     correctly.

         



 function Basic_Decl_P_Custom_Id_Text
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return String_Type
   ;


         



 function Basic_Decl_P_Does_Aspects_Make_Preelaborable
   
  (Node : Bare_Basic_Decl
      ; From_Body : Boolean
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Implementation helper for ``CompilationUnit.is_preelaborable``.
--
--  Return whether ``Entity`` has aspects that make it preelaborable.
--
--  If ``from_body``, consider that ``Entity`` is a spec and that we are
--  computing whether its body is preelaborable.

         



 function Basic_Decl_P_Wrap_Public_Reference
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return a public-friendly view of this entity. For now this only needs to
--  handle the case where Self is a ``GenericSubpInternal``, in which case we
--  prefer to return its parent ``GenericSubpInstantiation`` node.
--
--  .. attention:: Properties typically use ``wrap_public_reference`` to
--     sanitize their return value for users. Sometimes however, those
--     properties end up being used by internal properties for practical
--     reasons, meaning those properties will work on biased values, which
--     could become problematic. Moreover, as of yet this property only exists
--     to handle the ``GenericSubpInternal`` case, which could actually be
--     addressed cleanly in at least two different ways:
--
--     * By adding interfaces to langkit, so that a
--       ``GenericSubpInstantiation`` could be both a ``GenericInstantiation``
--       and a ``BasicSubpDecl``.
--
--     * By also working with ``GenericSubpInstantiation`` nodes internally.
--       This mostly means getting rid of ``GenericSubpInternal`` nodes in the
--       envs.

         



 function Dispatcher_Basic_Decl_P_Is_Constant_Object
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Return whether this object is constant or not.

         



 function Basic_Decl_P_Child_Decl_Initial_Env_Name
   
  (Node : Bare_Basic_Decl
      ; Private_Part : Boolean
         := False
  )

   return Symbol_Type
   ;
--  If this is a child declaration, return the lexical environment name of its
--  parent declaration. Otherwise return an empty string.
--
--  If ``private_part`` is True, return the env name of the private part of its
--  parent.

         



 function Basic_Decl_P_Previous_Part_For_Decl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the previous part for this decl, if applicable.
--
--  .. note:: It is not named previous_part, because BaseTypeDecl has a more
--     precise version of previous_part that returns a BaseTypeDecl. Probably,
--     we want to rename the specific versions, and have the root property be
--     named previous_part. (TODO R925-008)

         



 function Basic_Decl_P_Is_Static_Decl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this declaration is static.

         



 function Basic_Decl_P_Is_Library_Item
   
  (Node : Bare_Basic_Decl
  )

   return Boolean
   ;
--  Return whether this is a top-level element.

         



 function Basic_Decl_P_Declarative_Parts
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;
--  Return the declarative parts directly associated to this BasicDecl, if any.

         



 function Basic_Decl_P_Get_Aspect_Assoc
   
  (Node : Bare_Basic_Decl
      ; Name : Symbol_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Aspect_Assoc
   ;
--  Return the aspect with name ``name`` for this entity.

         



 function Basic_Decl_P_Is_Imported
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether this declaration is imported from another language.

         



 function Basic_Decl_P_Is_In_Private_Part
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Basic_Decl_P_Defining_Env
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return a lexical environment that contains entities that are accessible as
--  suffixes when Self is a prefix.

         



 function Basic_Decl_P_Array_Ndims
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Integer
   ;


         



 function Basic_Decl_P_Expr_Type
   
  (Node : Bare_Basic_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the type declaration corresponding to this basic declaration has
--  when it is used in an expression context. For example, for this basic
--  declaration:
--
--  .. code::
--
--     type Int is range 0 .. 100;
--
--     A : Int := 12;
--
--  the declaration of the Int type will be returned. For this declaration:
--
--  .. code::
--
--     type F is delta 0.01 digits 10;
--
--     function B return F;
--
--  expr_type will return the declaration of the type F.

         



 function Basic_Decl_P_Type_Expression
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;
--  Return the type expression for this BasicDecl if applicable, a null
--  otherwise.

         



 function Basic_Decl_P_Constrain_Prefix
   
  (Node : Bare_Basic_Decl
      ; Prefix : Bare_Expr
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;
--  This method is used when self is a candidate suffix in a dotted expression,
--  to express the potential constraint that the suffix could express on the
--  prefix.
--
--  For example, given this code:
--
--  .. code::
--
--     1 type P is record
--     2     A, B : Integer;
--     3 end record;
--     4
--     5 P_Inst : P;
--     7
--     8 P_Inst.A;
--       ^^^^^^^^
--
--  A references the A ComponentDecl at line 2, and the constraint that we want
--  to express on the prefix (P_Inst), is that it needs to be of type P.

         



 function Basic_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Basic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the next part of this declaration, if applicable.
--
--  .. note:: It is not named next_part, because BaseTypeDecl has a more
--     precise version of next_part that returns a BaseTypeDecl. Probably, we
--     want to rename the specific versions, and have the root property be
--     named next_part. (TODO R925-008)

         



 function Basic_Decl_P_Next_Part_For_Name
   
  (Node : Bare_Basic_Decl
      ; Sym : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Internal method for computing the next part of a basic decl according to
--  one of its defining names. By default, this property behaves just like
--  ``next_part_for_decl``. However it can be overriden for node types for
--  which the next part depends on the defining name to consider. One example
--  of that are constant declarations:
--
--  .. code:: ada
--
--     package Pkg is
--         X, Y : constant Integer;
--     private
--         X : constant Integer := 1;
--         Y : constant Integer := 2;
--     end Pkg;
--
--  So, ``next_part_for_name`` is overriden in ``ObjectDecl``.

         



 function Basic_Decl_P_Previous_Part_For_Name
   
  (Node : Bare_Basic_Decl
      ; Sym : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Internal method for computing the previous part of a basic decl according
--  to one of its defining names. By default, this property behaves just like
--  ``next_part_for_decl``. However it can be overriden for node types for
--  which the previous part depends on the defining name to consider. One
--  example of that are subprogram parameters:
--
--  .. code:: ada
--
--     package Pkg is
--         X : constant Integer;
--         Y : constant Integer;
--     private
--         X, Y : constant Integer := 1;
--     end Pkg;
--
--  So, ``previous_part_for_name`` is overriden in ``ObjectDecl``.

         



 function Basic_Decl_P_Is_Constant_Object
   
  (Node : Bare_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this object is constant or not.


   




      

   

      
      procedure Initialize_Fields_For_Abstract_State_Decl
        (Self : Bare_Abstract_State_Decl
         ; Abstract_State_Decl_F_Name : Bare_Defining_Name
         ; Abstract_State_Decl_F_Aspects : Bare_Aspect_Spec
        );

      
   function Abstract_State_Decl_F_Name
     (Node : Bare_Abstract_State_Decl) return Bare_Defining_Name;


         



 function Abstract_State_Decl_P_Defining_Names
   
  (Node : Bare_Abstract_State_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Abstract_State_Decl_P_Type_Expression
   
  (Node : Bare_Abstract_State_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Env_Mappings_233
   
  (Node : Bare_Abstract_State_Decl
  )

   return Internal_Env_Assoc
   ;



   



         procedure Abstract_State_Decl_Pre_Env_Actions
           (Self            : Bare_Abstract_State_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Anonymous_Expr_Decl
        (Self : Bare_Anonymous_Expr_Decl
         ; Anonymous_Expr_Decl_F_Expr : Bare_Expr
        );

      
   function Anonymous_Expr_Decl_F_Expr
     (Node : Bare_Anonymous_Expr_Decl) return Bare_Expr;


         



 function Anonymous_Expr_Decl_P_Defining_Names
   
  (Node : Bare_Anonymous_Expr_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Anonymous_Expr_Decl_P_Defining_Env
   
  (Node : Bare_Anonymous_Expr_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Anonymous_Expr_Decl_P_Get_Formal
   
  (Node : Bare_Anonymous_Expr_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;
--  Return the generic formal object declaration corresponding to this actual.

         



 function Anonymous_Expr_Decl_P_Type_Expression
   
  (Node : Bare_Anonymous_Expr_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;
--  Internal property that actually retrieves the type expression. Since this
--  property requires non-trivial computation and is used during name
--  resolution, it's important for the ``get_formal`` to be memoized.

         



 function Anonymous_Expr_Decl_P_Is_Static_Decl
   
  (Node : Bare_Anonymous_Expr_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;



   




      

   



         



 function Dispatcher_Base_Formal_Param_Decl_P_Is_Mandatory
   
  (Node : Bare_Base_Formal_Param_Decl
  )

   return Boolean
   with Inline_Always
   ;


         



 function Base_Formal_Param_Decl_P_Formal_Type
   
  (Node : Bare_Base_Formal_Param_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the type for this formal.

         



 function Base_Formal_Param_Decl_P_Parent_Decl
   
  (Node : Bare_Base_Formal_Param_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Base_Formal_Param_Decl_P_Get_Param
   
  (Node : Bare_Base_Formal_Param_Decl
      ; Part : Internal_Entity_Basic_Decl
      ; Param : Symbol_Type
  )

   return Internal_Entity_Defining_Name
   ;


         



 function Base_Formal_Param_Decl_P_Decl_Param
   
  (Node : Bare_Base_Formal_Param_Decl
      ; Param : Internal_Entity_Defining_Name
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;
--  If self is a ParamSpec of a subprogram body, go fetch the equivalent spec
--  in the subprogram decl.

         



 function Base_Formal_Param_Decl_P_Next_Part_For_Name
   
  (Node : Bare_Base_Formal_Param_Decl
      ; Sym : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Base_Formal_Param_Decl_P_Previous_Part_For_Name
   
  (Node : Bare_Base_Formal_Param_Decl
      ; Sym : Symbol_Type
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Base_Formal_Param_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Base_Formal_Param_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Base_Formal_Param_Decl_P_Previous_Part_For_Decl
   
  (Node : Bare_Base_Formal_Param_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Base_Formal_Param_Decl_P_Is_Mandatory
   
  (Node : Bare_Base_Formal_Param_Decl
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_Component_Decl
        (Self : Bare_Component_Decl
         ; Component_Decl_F_Ids : Bare_Defining_Name_List
         ; Component_Decl_F_Component_Def : Bare_Component_Def
         ; Component_Decl_F_Default_Expr : Bare_Expr
         ; Component_Decl_F_Aspects : Bare_Aspect_Spec
        );

      
   function Component_Decl_F_Ids
     (Node : Bare_Component_Decl) return Bare_Defining_Name_List;

      
   function Component_Decl_F_Component_Def
     (Node : Bare_Component_Decl) return Bare_Component_Def;

      
   function Component_Decl_F_Default_Expr
     (Node : Bare_Component_Decl) return Bare_Expr;


         



 function Component_Decl_P_Defining_Env
   
  (Node : Bare_Component_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  See BasicDecl.defining_env

         



 function Component_Decl_P_Defining_Names
   
  (Node : Bare_Component_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Component_Decl_P_Array_Ndims
   
  (Node : Bare_Component_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Integer
   ;


         



 function Component_Decl_P_Type_Expression
   
  (Node : Bare_Component_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Component_Decl_P_Is_Constant_Object
   
  (Node : Bare_Component_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Component_Decl_P_Constrain_Prefix
   
  (Node : Bare_Component_Decl
      ; Prefix : Bare_Expr
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Component_Decl_P_Container_Type
   
  (Node : Bare_Component_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the defining container type for this component declaration.

         



 function Component_Decl_P_Xref_Equation
   
  (Node : Bare_Component_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Component_Decl_P_Xref_Entry_Point
   
  (Node : Bare_Component_Decl
  )

   return Boolean
   ;


         



 function Env_Mappings_1
   
  (Node : Bare_Component_Decl
  )

   return Internal_Env_Assoc_Array_Access
   ;



   



         procedure Component_Decl_Pre_Env_Actions
           (Self            : Bare_Component_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Discriminant_Spec
        (Self : Bare_Discriminant_Spec
         ; Discriminant_Spec_F_Ids : Bare_Defining_Name_List
         ; Discriminant_Spec_F_Type_Expr : Bare_Type_Expr
         ; Discriminant_Spec_F_Default_Expr : Bare_Expr
         ; Discriminant_Spec_F_Aspects : Bare_Aspect_Spec
        );

      
   function Discriminant_Spec_F_Ids
     (Node : Bare_Discriminant_Spec) return Bare_Defining_Name_List;

      
   function Discriminant_Spec_F_Type_Expr
     (Node : Bare_Discriminant_Spec) return Bare_Type_Expr;

      
   function Discriminant_Spec_F_Default_Expr
     (Node : Bare_Discriminant_Spec) return Bare_Expr;


         



 function Discriminant_Spec_P_Defining_Names
   
  (Node : Bare_Discriminant_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Discriminant_Spec_P_Defining_Env
   
  (Node : Bare_Discriminant_Spec
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Discriminant_Spec_P_Type_Expression
   
  (Node : Bare_Discriminant_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Discriminant_Spec_P_Xref_Entry_Point
   
  (Node : Bare_Discriminant_Spec
  )

   return Boolean
   ;


         



 function Discriminant_Spec_P_Is_Constant_Object
   
  (Node : Bare_Discriminant_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Discriminant_Spec_P_Xref_Equation
   
  (Node : Bare_Discriminant_Spec
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Env_Mappings_0
   
  (Node : Bare_Discriminant_Spec
  )

   return Internal_Env_Assoc_Array_Access
   ;



   



         procedure Discriminant_Spec_Pre_Env_Actions
           (Self            : Bare_Discriminant_Spec;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Generic_Formal
        (Self : Bare_Generic_Formal
         ; Generic_Formal_F_Decl : Bare_Basic_Decl
        );

      
   function Generic_Formal_F_Decl
     (Node : Bare_Generic_Formal) return Bare_Basic_Decl;


         



 function Generic_Formal_P_Defining_Names
   
  (Node : Bare_Generic_Formal
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Generic_Formal_P_Type_Expression
   
  (Node : Bare_Generic_Formal
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Generic_Formal_P_Xref_Entry_Point
   
  (Node : Bare_Generic_Formal
  )

   return Boolean
   ;


         



 function Generic_Formal_P_Xref_Equation
   
  (Node : Bare_Generic_Formal
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;



   




      

   

      
      procedure Initialize_Fields_For_Generic_Formal_Obj_Decl
        (Self : Bare_Generic_Formal_Obj_Decl
         ; Generic_Formal_F_Decl : Bare_Basic_Decl
        );



   




      

   

      
      procedure Initialize_Fields_For_Generic_Formal_Package
        (Self : Bare_Generic_Formal_Package
         ; Generic_Formal_F_Decl : Bare_Basic_Decl
        );



   




      

   

      
      procedure Initialize_Fields_For_Generic_Formal_Subp_Decl
        (Self : Bare_Generic_Formal_Subp_Decl
         ; Generic_Formal_F_Decl : Bare_Basic_Decl
        );



   




      

   

      
      procedure Initialize_Fields_For_Generic_Formal_Type_Decl
        (Self : Bare_Generic_Formal_Type_Decl
         ; Generic_Formal_F_Decl : Bare_Basic_Decl
        );


         



 function Generic_Formal_Type_Decl_P_Default_Type
   
  (Node : Bare_Generic_Formal_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;



   




      

   

      
      procedure Initialize_Fields_For_Param_Spec
        (Self : Bare_Param_Spec
         ; Param_Spec_F_Ids : Bare_Defining_Name_List
         ; Param_Spec_F_Has_Aliased : Bare_Aliased_Node
         ; Param_Spec_F_Mode : Bare_Mode
         ; Param_Spec_F_Type_Expr : Bare_Type_Expr
         ; Param_Spec_F_Default_Expr : Bare_Expr
         ; Param_Spec_F_Aspects : Bare_Aspect_Spec
        );

      
   function Param_Spec_F_Ids
     (Node : Bare_Param_Spec) return Bare_Defining_Name_List;

      
   function Param_Spec_F_Has_Aliased
     (Node : Bare_Param_Spec) return Bare_Aliased_Node;

      
   function Param_Spec_F_Mode
     (Node : Bare_Param_Spec) return Bare_Mode;

      
   function Param_Spec_F_Type_Expr
     (Node : Bare_Param_Spec) return Bare_Type_Expr;

      
   function Param_Spec_F_Default_Expr
     (Node : Bare_Param_Spec) return Bare_Expr;


         



 function Param_Spec_P_Is_Mandatory
   
  (Node : Bare_Param_Spec
  )

   return Boolean
   ;


         



 function Param_Spec_P_Defining_Names
   
  (Node : Bare_Param_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Param_Spec_P_Type_Expression
   
  (Node : Bare_Param_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Param_Spec_P_Is_Constant_Object
   
  (Node : Bare_Param_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Param_Spec_P_Defining_Env
   
  (Node : Bare_Param_Spec
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Param_Spec_P_Constrain_Prefix
   
  (Node : Bare_Param_Spec
      ; Prefix : Bare_Expr
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Param_Spec_P_Xref_Equation
   
  (Node : Bare_Param_Spec
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Param_Spec_P_Xref_Entry_Point
   
  (Node : Bare_Param_Spec
  )

   return Boolean
   ;


         



 function Env_Mappings_24
   
  (Node : Bare_Param_Spec
  )

   return Internal_Env_Assoc_Array_Access
   ;



   



         procedure Param_Spec_Pre_Env_Actions
           (Self            : Bare_Param_Spec;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Synthetic_Formal_Param_Decl
        (Self : Bare_Synthetic_Formal_Param_Decl
         ; Synthetic_Formal_Param_Decl_F_Param_Type : Bare_Type_Expr
        );

      
   function Synthetic_Formal_Param_Decl_F_Param_Type
     (Node : Bare_Synthetic_Formal_Param_Decl) return Bare_Type_Expr;


         



 function Synthetic_Formal_Param_Decl_P_Defining_Names
   
  (Node : Bare_Synthetic_Formal_Param_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Synthetic_Formal_Param_Decl_P_Type_Expression
   
  (Node : Bare_Synthetic_Formal_Param_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;



   




      

   

      
      procedure Initialize_Fields_For_Base_Package_Decl
        (Self : Bare_Base_Package_Decl
         ; Base_Package_Decl_F_Package_Name : Bare_Defining_Name
         ; Base_Package_Decl_F_Aspects : Bare_Aspect_Spec
         ; Base_Package_Decl_F_Public_Part : Bare_Public_Part
         ; Base_Package_Decl_F_Private_Part : Bare_Private_Part
         ; Base_Package_Decl_F_End_Name : Bare_End_Name
        );

      
   function Base_Package_Decl_F_Package_Name
     (Node : Bare_Base_Package_Decl) return Bare_Defining_Name;

      
   function Base_Package_Decl_F_Public_Part
     (Node : Bare_Base_Package_Decl) return Bare_Public_Part;

      
   function Base_Package_Decl_F_Private_Part
     (Node : Bare_Base_Package_Decl) return Bare_Private_Part;

      
   function Base_Package_Decl_F_End_Name
     (Node : Bare_Base_Package_Decl) return Bare_End_Name;


         



 function Base_Package_Decl_P_Defining_Names
   
  (Node : Bare_Base_Package_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Base_Package_Decl_P_Defining_Env
   
  (Node : Bare_Base_Package_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Base_Package_Decl_P_Body_Part
   
  (Node : Bare_Base_Package_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Package_Body
   ;
--  Return the PackageBody corresponding to this node.

         



 function Base_Package_Decl_P_Declarative_Parts
   
  (Node : Bare_Base_Package_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;


         



 function Base_Package_Decl_P_Env_Names
   
  (Node : Bare_Base_Package_Decl
  )

   return Symbol_Type_Array_Access
   ;
--  Return the env names that this package defines. Make sure to include the
--  ``.__privatepart`` env name if this package doesn't have a private part, as
--  some construct will always try to register themselves in the private part
--  and therefore expect it to always be defined.


   




      

   

      
      procedure Initialize_Fields_For_Generic_Package_Internal
        (Self : Bare_Generic_Package_Internal
         ; Base_Package_Decl_F_Package_Name : Bare_Defining_Name
         ; Base_Package_Decl_F_Aspects : Bare_Aspect_Spec
         ; Base_Package_Decl_F_Public_Part : Bare_Public_Part
         ; Base_Package_Decl_F_Private_Part : Bare_Private_Part
         ; Base_Package_Decl_F_End_Name : Bare_End_Name
        );


         



 function Generic_Package_Internal_P_Is_Library_Item
   
  (Node : Bare_Generic_Package_Internal
  )

   return Boolean
   ;
--  Return whether this is a top-level element.

         



 function Env_Trans_Parent_117
   
  (Node : Bare_Generic_Package_Internal
  )

   return Boolean
   ;


         



 function Env_Names_118
   
  (Node : Bare_Generic_Package_Internal
  )

   return Symbol_Type_Array_Access
   ;



   



         procedure Generic_Package_Internal_Pre_Env_Actions
           (Self            : Bare_Generic_Package_Internal;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Package_Decl
        (Self : Bare_Package_Decl
         ; Base_Package_Decl_F_Package_Name : Bare_Defining_Name
         ; Base_Package_Decl_F_Aspects : Bare_Aspect_Spec
         ; Base_Package_Decl_F_Public_Part : Bare_Public_Part
         ; Base_Package_Decl_F_Private_Part : Bare_Private_Part
         ; Base_Package_Decl_F_End_Name : Bare_End_Name
        );


         



 function Env_Do_48
   
  (Node : Bare_Package_Decl
  )

   return Boolean
   ;


         



 function Initial_Env_49
   
  (Node : Bare_Package_Decl
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_50
   
  (Node : Bare_Package_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;


         



 function Env_Trans_Parent_51
   
  (Node : Bare_Package_Decl
  )

   return Boolean
   ;


         



 function Env_Names_52
   
  (Node : Bare_Package_Decl
  )

   return Symbol_Type_Array_Access
   ;


         



 function Env_Do_53
   
  (Node : Bare_Package_Decl
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Ref_Env_Nodes_54
   
  (Node : Bare_Package_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_55
   
  (Node : Bare_Package_Decl
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_56
   
  (Node : Bare_Package_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_57
   
  (Node : Bare_Package_Decl
  )

   return Boolean
   ;



   



         procedure Package_Decl_Pre_Env_Actions
           (Self            : Bare_Package_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Base_Type_Decl
        (Self : Bare_Base_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
        );

      
   function Base_Type_Decl_F_Name
     (Node : Bare_Base_Type_Decl) return Bare_Defining_Name;


         



 function Base_Type_Decl_P_Defining_Names
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Base_Type_Decl_P_Base_Subtype
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  If this type decl is a subtype decl, return the base subtype. If not,
--  return ``Self``.

         



 function Base_Type_Decl_P_Anonymous_Access_Type
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Type_Decl_P_Anonymous_Access_Type_Or_Null
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Type_Decl_F_Attributes_Repo
   
  (Node : Bare_Base_Type_Decl
  )

   return Bare_Type_Attributes_Repository
   ;


         



 function Base_Type_Decl_P_Private_Completion
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the private completion for this type, if there is one.

         



 function Base_Type_Decl_P_Is_View_Of_Type
   
  (Node : Bare_Base_Type_Decl
      ; Comp_View : Internal_Entity_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Predicate that will return true if comp_view is a more complete view of
--  type typ, or if it is the same view of type typ.

         



 function Base_Type_Decl_P_Is_Array_Or_Rec
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Is_Inherited_Primitive
   
  (Node : Bare_Base_Type_Decl
      ; P : Internal_Entity_Basic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Assuming that P is a primitive of Self, return whether the given primitive
--  P is inherited from one of Self's parents.

         



 function Base_Type_Decl_P_Get_Record_Representation_Clause
   
  (Node : Bare_Base_Type_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Record_Rep_Clause
   ;
--  Return the record representation clause associated to this type decl, if
--  applicable (i.e. this type decl defines a record type).

         



 function Base_Type_Decl_P_Get_Enum_Representation_Clause
   
  (Node : Bare_Base_Type_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Enum_Rep_Clause
   ;
--  Return the enum representation clause associated to this type decl, if
--  applicable (i.e. this type decl defines an enum type).

         



 function Dispatcher_Base_Type_Decl_P_Primitives_Env
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   with Inline_Always
   ;


         



 function Dispatcher_Base_Type_Decl_P_Is_Record_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Return whether this type is a record type.
--
--  .. attention:: Private tagged types extending public tagged records are not
--     considered as record types.

         



 function Base_Type_Decl_P_Is_Array_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this type is an array type.

         



 function Base_Type_Decl_P_Find_Derived_Types
   
  (Node : Bare_Base_Type_Decl
      ; Root : Internal_Entity
      ; Origin : Bare_Ada_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Decl_Array_Access
   ;
--  Find types derived from self in the given ``root`` and its children.

         



 function Dispatcher_Base_Type_Decl_P_Is_Task_Type
   
  (Node : Bare_Base_Type_Decl
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is a task type

         



 function Dispatcher_Base_Type_Decl_P_Is_Real_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is a real type or not.

         



 function Dispatcher_Base_Type_Decl_P_Is_Float_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is a float type or not.

         



 function Dispatcher_Base_Type_Decl_P_Is_Fixed_Point
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is a fixed point type or not.

         



 function Dispatcher_Base_Type_Decl_P_Is_Enum_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is an enum type

         



 function Dispatcher_Base_Type_Decl_P_Is_Classwide
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;


         



 function Dispatcher_Base_Type_Decl_P_Is_Access_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether Self is an access type or not

         



 function Base_Type_Decl_P_Is_Implicit_Deref
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether Self is an implicitly dereferenceable type or not

         



 function Dispatcher_Base_Type_Decl_P_Has_Ud_Indexing
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether self has user defined indexing or not

         



 function Dispatcher_Base_Type_Decl_P_Constant_Indexing_Fns
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   with Inline_Always
   ;
--  For a type with user defined indexing, return the set of all
--  Constant_Indexing functions.

         



 function Dispatcher_Base_Type_Decl_P_Variable_Indexing_Fns
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   with Inline_Always
   ;
--  For a type with user defined indexing, return the set of all
--  Variable_Indexing functions.

         



 function Dispatcher_Base_Type_Decl_P_Get_Imp_Deref
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   with Inline_Always
   ;
--  If self has an Implicit_Dereference aspect, return its expression

         



 function Base_Type_Decl_P_Specific_Type
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Possible title underline, too short for the title. Treating it as ordinary
--  text because it's so short.
--
--  Return the specific type under a class-wide type. Consider for example: ```
--  subtype S1 is T'Class subtype S2 is S1'Class ``` Calling this property on
--  ``S2`` will return ``T``.

         



 function Base_Type_Decl_P_Derefed_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  If this type defines an Implicit_Dereference aspect, return the accessed
--  type, otherwise return Self.

         



 function Base_Type_Decl_P_Derefed_Base_Subtype
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the base subtype of this subtype. If this type defines an
--  Implicit_Dereference aspect, return the base subtype of the accessed type
--  instead.

         



 function Base_Type_Decl_P_One_Non_Universal
   
  (Node : Bare_Base_Type_Decl
      ; Second : Internal_Entity_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Non_Universal_Base_Subtype
   
  (Node : Bare_Base_Type_Decl
      ; Second : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Type_Decl_P_Array_Concat_Result_Type
   
  (Node : Bare_Base_Type_Decl
      ; Other : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Considering that Self is the actual type of the left operand of an array
--  concatenation and ``other`` the actual type of its right operand, return
--  the type of the result of the array concatenation.

         



 function Base_Type_Decl_P_Expected_Array_Concat_Operand_Type
   
  (Node : Bare_Base_Type_Decl
      ; Operand_Type : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Considering that Self is the result type of an array concatenation and
--  ``operand_type`` is the actual type of one of the operands, return the
--  expected type for that operand. In other words: if the actual type of the
--  operand is a subtype of the component-type of the resulting array, return
--  the component type of the array. Otherwise return the array type itself.

         



 function Dispatcher_Base_Type_Decl_P_Access_Def
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Access_Def
   with Inline_Always
   ;


         



 function Dispatcher_Base_Type_Decl_P_Is_Char_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is a character type or not

         



 function Base_Type_Decl_P_Is_Non_Null_Char_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Dispatcher_Base_Type_Decl_P_Classwide_Type
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Classwide_Type_Decl
   with Inline_Always
   ;


         



 function Base_Type_Decl_P_Scalar_Base_Type
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Discrete_Base_Subtype_Decl
   ;


         



 function Base_Type_Decl_P_Is_Universal_Type
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this type is one of the two universal types (universal
--  integer or universal real).
--
--  .. note:: Returns False if Self is null.

         



 function Base_Type_Decl_P_Is_Not_Universal_Type
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this type is *not* one of the two universal types (universal
--  integer or universal real).
--
--  .. note:: Returns False if Self is null.

         



 function Base_Type_Decl_P_Is_Access_Type_Predicate
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Predicate to use by logic equation. Return True iff this is an access type,
--  but checks first that this type is not null, in which case it returns
--  False.

         



 function Base_Type_Decl_P_Array_Ndims
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Integer
   ;


         



 function Dispatcher_Base_Type_Decl_P_Discrete_Range
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Discrete_Range
   with Inline_Always
   ;
--  Return the discrete range for this type decl, if applicable.

         



 function Base_Type_Decl_P_Static_Predicate
   
  (Node : Bare_Base_Type_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;
--  Return the expression from the Static_Predicate or the Predicate aspect
--  defined on this type.

         



 function Base_Type_Decl_P_Satisfies_Type_Predicates
   
  (Node : Bare_Base_Type_Decl
      ; Value : Big_Integer_Type
      ; Imprecise_Fallback : Boolean
         := False
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return true if the given value satisfies all of this type's static
--  predicates, including its parent predicates (in case this is a derived
--  type) and its base type predicate (if this is a subtype declaration).
--  Return true if no type predicates are defined for this type.

         



 function Base_Type_Decl_P_Is_Iterator_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Dispatcher_Base_Type_Decl_P_Is_Discrete_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is a discrete type or not.

         



 function Base_Type_Decl_P_Is_Not_Root_Int_Type
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Dispatcher_Base_Type_Decl_P_Is_Int_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is an integer type or not.

         



 function Base_Type_Decl_P_Allows_Universal_Int
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether a universal integer can be used to initialize a value of this type.
--  This is true for integer types in general, but also for arbitrary types
--  that define the Integer_Literal aspect.

         



 function Base_Type_Decl_P_Allows_Universal_Real
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether a universal real can be used to initialize a value of this type.
--  This is true for real types in general, but also for arbitrary types that
--  define the Real_Literal aspect.

         



 function Base_Type_Decl_P_Allows_String_Literal
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether a string literal can be used to initialize a value of this type.
--  This is true for string types in general, but also for arbitrary types that
--  define the String_Literal aspect.
--
--  .. note:: We also check that the node is not null because this property is
--     used directly as a logic predicate and may be invoked with null nodes
--     (unlike the other ``allows_*`` properties).

         



 function Base_Type_Decl_P_Is_Str_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether this is a string type (a one dimensional array of characters).

         



 function Dispatcher_Base_Type_Decl_P_Accessed_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;
--  If this type is an access type, or a type with an Implicit_Dereference
--  aspect, return the type of a dereference of an instance of this type.

         



 function Base_Type_Decl_P_Accessed_Type_No_Call
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Like ``BaseTypeDecl.accessed_type``, but does not perform an implicit call
--  if Self represents an access-to-subprogram.

         



 function Base_Type_Decl_P_Final_Accessed_Type
   
  (Node : Bare_Base_Type_Decl
      ; First_Call : Boolean
         := True
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Call accessed_type recursively until we get the most nested accessed type.
--  For example, for the following code:
--
--  .. code::
--
--     type A is access Integer;
--     type AA is access A;
--     type AAA is access AA;
--
--  ``AAA``'s final_accessed_type is Integer.

         



 function Base_Type_Decl_P_Is_Access_To
   
  (Node : Bare_Base_Type_Decl
      ; Typ : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Is_Subp_Access_Of
   
  (Node : Bare_Base_Type_Decl
      ; Entity : Internal_Entity_Basic_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Returns whether self is an access type whose accessed type matches other.

         



 function Base_Type_Decl_P_Is_Generic_Formal
   
  (Node : Bare_Base_Type_Decl
  )

   return Boolean
   ;
--  Return whether this type declaration is a generic formal.

         



 function Dispatcher_Base_Type_Decl_P_Is_Tagged_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether type is tagged or not

         



 function Base_Type_Decl_P_Is_Tagged_Type_With_Deref
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether Self is a tagged type after being implicitly dereferenced.

         



 function Dispatcher_Base_Type_Decl_P_Base_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;
--  Return the base type entity for this derived type declaration

         



 function Dispatcher_Base_Type_Decl_P_Base_Types
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   with Inline_Always
   ;
--  Return the list of base types for Self.

         



 function Dispatcher_Base_Type_Decl_P_Base_Interfaces
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   with Inline_Always
   ;


         



 function Base_Type_Decl_P_Find_All_Derived_Types
   
  (Node : Bare_Base_Type_Decl
      ; Units : Internal_Unit_Array_Access
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Decl_Array_Access
   ;
--  Return the list of all types that inherit (directly or inderictly) from
--  Self among the given units.

         



 function Dispatcher_Base_Type_Decl_P_Record_Def
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Record_Def
   with Inline_Always
   ;


         



 function Dispatcher_Base_Type_Decl_P_Array_Def
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Type_Def
   with Inline_Always
   ;


         



 function Base_Type_Decl_P_Array_Def_With_Deref
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Type_Def
   ;
--  Return the array definition corresponding to type ``Self`` in the context
--  of array-indexing, e.g. implicitly dereferencing if ``Self`` is an access.

         



 function Base_Type_Decl_P_Is_Array_Def_With_Deref
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Is_Array_Def_With_Deref_Or_Null
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Comp_Type
   
  (Node : Bare_Base_Type_Decl
      ; Is_Subscript : Boolean
         := False
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the component type of ``Self``, if applicable. The component type is
--  the type you'll get if you call a value whose type is ``Self``. So it can
--  either be:
--
--  1. The component type for an array.
--
--  2. The return type for an access to function.

         



 function Base_Type_Decl_P_Index_Type
   
  (Node : Bare_Base_Type_Decl
      ; Dim : Integer
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the index type for dimension ``dim`` for this type, if applicable.
--
--  .. warning:: ``dim`` is 0-based, so the first ``index_type`` is at index 0.

         



 function Base_Type_Decl_P_Expr_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Type_Decl_P_Is_Derived_Type
   
  (Node : Bare_Base_Type_Decl
      ; Other_Type : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether Self is derived from other_type.

         



 function Dispatcher_Base_Type_Decl_P_Is_Iterable_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether Self is a type that is iterable in a for .. of loop

         



 function Dispatcher_Base_Type_Decl_P_Is_Interface_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Return True iff this type declaration is an interface definition.

         



 function Dispatcher_Base_Type_Decl_P_Iterable_Comp_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;


         



 function Base_Type_Decl_P_Matching_Prefix_Type
   
  (Node : Bare_Base_Type_Decl
      ; Container_Type : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Given a dotted expression A.B, where container_type is the container type
--  for B, and Self is a potential type for A, returns whether Self is a valid
--  type for A in the dotted expression.

         



 function Base_Type_Decl_P_Matching_Access_Type
   
  (Node : Bare_Base_Type_Decl
      ; Expected_Type : Internal_Entity_Base_Type_Decl
      ; For_Assignment : Boolean
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether self is a matching access type for expected_type.

         



 function Base_Type_Decl_P_Matching_Formal_Prim_Type
   
  (Node : Bare_Base_Type_Decl
      ; Formal_Type : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Matching_Formal_Type
   
  (Node : Bare_Base_Type_Decl
      ; Formal_Type : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Matching_Formal_Type_Impl
   
  (Node : Bare_Base_Type_Decl
      ; Formal_Type : Internal_Entity_Base_Type_Decl
      ; Accept_Derived : Boolean
         := False
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Matching_Assign_Type
   
  (Node : Bare_Base_Type_Decl
      ; Expected_Type : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Matching_Type
   
  (Node : Bare_Base_Type_Decl
      ; Expected_Type : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether ``self`` matches ``expected_type``.

         



 function Base_Type_Decl_P_Matching_Allocator_Type
   
  (Node : Bare_Base_Type_Decl
      ; Allocated_Type : Internal_Entity_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Dispatcher_Base_Type_Decl_P_Canonical_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;
--  Return the canonical type declaration for this type declaration. For
--  subtypes, it will return the base type declaration.

         



 function Base_Type_Decl_P_Classwide_Type_Node
   
  (Node : Bare_Base_Type_Decl
  )

   return Bare_Classwide_Type_Decl
   ;


         



 function Base_Type_Decl_P_Scalar_Base_Subtype_Node
   
  (Node : Bare_Base_Type_Decl
  )

   return Bare_Discrete_Base_Subtype_Decl
   ;
--  Helper for scalar_base_subtype. Return the interned node for the subtype
--  entity.

         



 function Base_Type_Decl_P_Scalar_Base_Subtype
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Discrete_Base_Subtype_Decl
   ;
--  Return the base subtype for this type. Note that this is only legal for
--  scalar types.

         



 function Dispatcher_Base_Type_Decl_P_Previous_Part
   
  (Node : Bare_Base_Type_Decl
      ; Go_To_Incomplete : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;
--  Returns the previous part for this type decl.

         



 function Base_Type_Decl_P_Next_Part
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Returns the next part for this type decl.
--
--  .. note:: Since this property returns a ``BaseTypeDecl``, it cannot be used
--     to retrieve the next part of ``TaskTypeDecl`` and ``ProtectedTypeDecl``
--     nodes as their next part is actually a ``Body``. Use
--     ``BasicDecl.next_part_for_decl`` for those instead.

         



 function Base_Type_Decl_P_Full_View
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the full completion of this type.

         



 function Base_Type_Decl_P_Is_Definite_Subtype
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Returns whether this is a definite subtype.
--
--  For convenience, this will return ``False`` for incomplete types, even
--  though the correct answer is more akin to "non applicable".

         



 function Dispatcher_Base_Type_Decl_P_Is_Private
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   with Inline_Always
   ;
--  Whether node is a private view of corresponding type.

         



 function Dispatcher_Base_Type_Decl_P_Discriminants_List
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   with Inline_Always
   ;
--  Return the list of all discriminants of this type. If this type has no
--  discriminant or only unknown discriminants, an empty list is returned.

         



 function Base_Type_Decl_P_Corresponding_Char_Literal
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  If Self denotes the declaration of a character type (i.e. an enum type with
--  character literals) and origin is bound to a character literal, return the
--  EnumLiteralDecl that symbolically corresponds to the literal, or synthesize
--  one if the enum type is one of the standard Character types (we need to
--  synthesize them since we cannot declare them all in our standard package
--  implementation because of their number).

         



 function Dispatcher_Base_Type_Decl_P_Root_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;
--  Return the type that is at the root of the derivation hierarchy (ignoring
--  secondary interfaces derivations for tagged types)

         



 function Base_Type_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Base_Type_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Base_Type_Decl_P_Shapes
   
  (Node : Bare_Base_Type_Decl
      ; Include_Discriminants : Boolean
         := True
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Shape_Array_Access
   ;
--  Must be called on a record (sub-)type declaration. Return all the possible
--  shapes that a value of this record type can take. For example, consider the
--  following record definition:
--
--  .. code::
--
--     type R (A : Integer; B : Integer) is record
--         X : Integer;
--         case A is
--             when 1 .. 10 =>
--                 Y_1 : Integer;
--                 case B is
--                     when 1 .. 10 =>
--                         Z_1 : Integer;
--                     when others => null;
--                 end case;
--             when 11 .. 20 =>
--                 Y_2 : Integer;
--                 case B is
--                     when 1 .. 10 =>
--                         Z_2 : Integer;
--                     when others => null;
--                 end case;
--             when others => null;
--         end case;
--     end record;
--
--  For this instance, this property will return the following results:
--
--  .. code::
--
--     [
--         [X, Y_1, Z_1],
--         [X, Y_1],
--         [X, Y_2, Z_2],
--         [X, Y_2],
--         [X]
--     ]
--
--  .. attention:: This property is inaccurate when called on a record
--     extension which defines components under a certain condition C, and this
--     same condition is used to define some components in the parent record:
--     in that case, any feasible shape will in practice contain either both
--     the components defined under condition C in the child record and the
--     parent record, or none of them.However, due to the simplified algorithm
--     we use here to compute the feasible shapes, we will also return shapes
--     that include the components of the child record but not the parent
--     record, and conversely.

         



 function Base_Type_Decl_F_Dottable_Subps_Env
   
  (Node : Bare_Base_Type_Decl
  )

   return Lexical_Env
   ;
--  The environment that contains all subprograms that can be called with the
--  dot-notation on values of this type.

         



 function Base_Type_Decl_P_Dottable_Subps
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Inner_Env_Assoc_Array_Access
   ;
--  Return the list of all subprograms that can be called with the dot-
--  notation on values of this type. We look for them in the public part,
--  private part and body part of the package this type is declared in.

         



 function Base_Type_Decl_P_Find_Base_Type_Rebindings
   
  (Node : Bare_Base_Type_Decl
      ; Target : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Env_Rebindings
   ;
--  Given Self & a target type node, browse the inheritance hierarchy of Self
--  until the target is found, and return its associated rebindings. For
--  example, consider the following snippet.
--
--  .. code::
--
--     package My_Vectors is new Ada.Containers.Vectors (...);
--
--     type My_Vector is new My_Vectors.Vector;
--
--  Calling this property on ``My_Vector`` with the target type
--  ``Ada.Containers.Vectors.Vector`` will return the rebindings corresponding
--  to the instantiation in the first line of the snippet (package My_Vectors).

         



 function Base_Type_Decl_P_Has_Base_Type_Impl
   
  (Node : Bare_Base_Type_Decl
      ; Target : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Implementation of ``has_base_type``, which assumes that ``target`` has been
--  canonicalized.

         



 function Base_Type_Decl_P_Has_Base_Type
   
  (Node : Bare_Base_Type_Decl
      ; Target : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether the given type is amongst the bases types (direct or
--  indirect) of self.
--
--  .. note:: Unlike ``is_derived_type``, we don't care here about the
--     rebindings of ``target``, meaning any instance of ``target`` will be
--     accepted.

         



 function Env_Mappings_2
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Base_Type_Decl_P_Primitives_Env
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Base_Type_Decl_P_Is_Record_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return whether this type is a record type.
--
--  .. attention:: Private tagged types extending public tagged records are not
--     considered as record types.

         



 function Base_Type_Decl_P_Is_Task_Type
   
  (Node : Bare_Base_Type_Decl
  )

   return Boolean
   ;
--  Whether type is a task type

         



 function Base_Type_Decl_P_Is_Real_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether type is a real type or not.

         



 function Base_Type_Decl_P_Is_Float_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether type is a float type or not.

         



 function Base_Type_Decl_P_Is_Fixed_Point
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether type is a fixed point type or not.

         



 function Base_Type_Decl_P_Is_Enum_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether type is an enum type

         



 function Base_Type_Decl_P_Is_Classwide
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Type_Decl_P_Is_Access_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether Self is an access type or not

         



 function Base_Type_Decl_P_Has_Ud_Indexing
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether self has user defined indexing or not

         



 function Base_Type_Decl_P_Constant_Indexing_Fns
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  For a type with user defined indexing, return the set of all
--  Constant_Indexing functions.

         



 function Base_Type_Decl_P_Variable_Indexing_Fns
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  For a type with user defined indexing, return the set of all
--  Variable_Indexing functions.

         



 function Base_Type_Decl_P_Get_Imp_Deref
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;
--  If self has an Implicit_Dereference aspect, return its expression

         



 function Base_Type_Decl_P_Access_Def
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Access_Def
   ;


         



 function Base_Type_Decl_P_Is_Char_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether type is a character type or not

         



 function Base_Type_Decl_P_Classwide_Type
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Classwide_Type_Decl
   ;


         



 function Base_Type_Decl_P_Discrete_Range
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Discrete_Range
   ;
--  Return the discrete range for this type decl, if applicable.

         



 function Base_Type_Decl_P_Is_Discrete_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether type is a discrete type or not.

         



 function Base_Type_Decl_P_Is_Int_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether type is an integer type or not.

         



 function Base_Type_Decl_P_Accessed_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  If this type is an access type, or a type with an Implicit_Dereference
--  aspect, return the type of a dereference of an instance of this type.

         



 function Base_Type_Decl_P_Is_Tagged_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether type is tagged or not

         



 function Base_Type_Decl_P_Base_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the base type entity for this derived type declaration

         



 function Base_Type_Decl_P_Base_Types
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;
--  Return the list of base types for Self.

         



 function Base_Type_Decl_P_Base_Interfaces
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;


         



 function Base_Type_Decl_P_Record_Def
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Record_Def
   ;


         



 function Base_Type_Decl_P_Array_Def
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Type_Def
   ;


         



 function Base_Type_Decl_P_Is_Iterable_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether Self is a type that is iterable in a for .. of loop

         



 function Base_Type_Decl_P_Is_Interface_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Return True iff this type declaration is an interface definition.

         



 function Base_Type_Decl_P_Iterable_Comp_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Type_Decl_P_Canonical_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the canonical type declaration for this type declaration. For
--  subtypes, it will return the base type declaration.

         



 function Base_Type_Decl_P_Previous_Part
   
  (Node : Bare_Base_Type_Decl
      ; Go_To_Incomplete : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Returns the previous part for this type decl.

         



 function Base_Type_Decl_P_Is_Private
   
  (Node : Bare_Base_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether node is a private view of corresponding type.

         



 function Base_Type_Decl_P_Root_Type
   
  (Node : Bare_Base_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the type that is at the root of the derivation hierarchy (ignoring
--  secondary interfaces derivations for tagged types)


   



         procedure Base_Type_Decl_Pre_Env_Actions
           (Self            : Bare_Base_Type_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Base_Subtype_Decl
        (Self : Bare_Base_Subtype_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
        );


         



 function Base_Subtype_Decl_P_From_Type_Bound
   
  (Node : Bare_Base_Subtype_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Dispatcher_Base_Subtype_Decl_P_Get_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   with Inline_Always
   ;
--  Get the type for this subtype.

         



 function Base_Subtype_Decl_P_Primitives_Env
   
  (Node : Bare_Base_Subtype_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Base_Subtype_Decl_P_Array_Ndims
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Integer
   ;


         



 function Base_Subtype_Decl_P_Defining_Env
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Base_Subtype_Decl_P_Canonical_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Subtype_Decl_P_Record_Def
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Record_Def
   ;


         



 function Base_Subtype_Decl_P_Accessed_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Subtype_Decl_P_Is_Int_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Is_Discrete_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Is_Real_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Is_Float_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Is_Fixed_Point
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Is_Enum_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Is_Access_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Access_Def
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Access_Def
   ;


         



 function Base_Subtype_Decl_P_Is_Char_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Is_Tagged_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Base_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Subtype_Decl_P_Base_Interfaces
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;


         



 function Base_Subtype_Decl_P_Base_Types
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;


         



 function Base_Subtype_Decl_P_Array_Def
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Type_Def
   ;


         



 function Base_Subtype_Decl_P_Is_Classwide
   
  (Node : Bare_Base_Subtype_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Discriminants_List
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Base_Subtype_Decl_P_Is_Iterable_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Iterable_Comp_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Subtype_Decl_P_Is_Record_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Is_Private
   
  (Node : Bare_Base_Subtype_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Root_Type
   
  (Node : Bare_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Subtype_Decl_P_Has_Ud_Indexing
   
  (Node : Bare_Base_Subtype_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subtype_Decl_P_Constant_Indexing_Fns
   
  (Node : Bare_Base_Subtype_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;


         



 function Base_Subtype_Decl_P_Variable_Indexing_Fns
   
  (Node : Bare_Base_Subtype_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Discrete_Base_Subtype_Decl
        (Self : Bare_Discrete_Base_Subtype_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
        );


         



 function Discrete_Base_Subtype_Decl_P_Is_Static_Decl
   
  (Node : Bare_Discrete_Base_Subtype_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Discrete_Base_Subtype_Decl_P_Get_Type
   
  (Node : Bare_Discrete_Base_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;



   




      

   

      
      procedure Initialize_Fields_For_Subtype_Decl
        (Self : Bare_Subtype_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Subtype_Decl_F_Subtype : Bare_Subtype_Indication
         ; Subtype_Decl_F_Aspects : Bare_Aspect_Spec
        );

      
   function Subtype_Decl_F_Subtype
     (Node : Bare_Subtype_Decl) return Bare_Subtype_Indication;


         



 function Subtype_Decl_P_Get_Type
   
  (Node : Bare_Subtype_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Subtype_Decl_P_Discrete_Range
   
  (Node : Bare_Subtype_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Discrete_Range
   ;


         



 function Subtype_Decl_P_Xref_Equation
   
  (Node : Bare_Subtype_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Subtype_Decl_P_Is_Static_Decl
   
  (Node : Bare_Subtype_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Subtype_Decl_P_Xref_Entry_Point
   
  (Node : Bare_Subtype_Decl
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_Classwide_Type_Decl
        (Self : Bare_Classwide_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
        );


         



 function Classwide_Type_Decl_P_Typedecl
   
  (Node : Bare_Classwide_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Classwide_Type_Decl_P_Is_Classwide
   
  (Node : Bare_Classwide_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Classwide_Type_Decl_P_Is_Tagged_Type
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Classwide_Type_Decl_P_Base_Type
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Classwide_Type_Decl_P_Base_Interfaces
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;


         



 function Classwide_Type_Decl_P_Record_Def
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Record_Def
   ;


         



 function Classwide_Type_Decl_P_Classwide_Type
   
  (Node : Bare_Classwide_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Classwide_Type_Decl
   ;


         



 function Classwide_Type_Decl_P_Is_Iterable_Type
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Classwide_Type_Decl_P_Iterable_Comp_Type
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Classwide_Type_Decl_P_Defining_Env
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Classwide_Type_Decl_P_Is_Private
   
  (Node : Bare_Classwide_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Classwide_Type_Decl_P_Is_In_Private_Part
   
  (Node : Bare_Classwide_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Classwide_Type_Decl_P_Get_Aspect_Assoc
   
  (Node : Bare_Classwide_Type_Decl
      ; Name : Symbol_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Aspect_Assoc
   ;


         



 function Classwide_Type_Decl_P_Is_Interface_Type
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Classwide_Type_Decl_P_Discriminants_List
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Classwide_Type_Decl_P_Previous_Part
   
  (Node : Bare_Classwide_Type_Decl
      ; Go_To_Incomplete : Boolean
         := True
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Classwide_Type_Decl_P_Canonical_Type
   
  (Node : Bare_Classwide_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;



   







      

   

      
      procedure Initialize_Fields_For_Incomplete_Type_Decl
        (Self : Bare_Incomplete_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Incomplete_Type_Decl_F_Discriminants : Bare_Discriminant_Part
        );

      
   function Incomplete_Type_Decl_F_Discriminants
     (Node : Bare_Incomplete_Type_Decl) return Bare_Discriminant_Part;


         



 function Incomplete_Type_Decl_P_Find_Next_Part_In
   
  (Node : Bare_Incomplete_Type_Decl
      ; Decl_Part : Internal_Entity_Declarative_Part
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Searches for the next part of Self inside the given declarative part. Since
--  Self is an IncompleteTypeDecl, the next part will necessarily be the first
--  type declaration of the same name that is not Self.

         



 function Incomplete_Type_Decl_P_Defining_Env
   
  (Node : Bare_Incomplete_Type_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Incomplete_Type_Decl_P_Discriminants_List
   
  (Node : Bare_Incomplete_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Env_Mappings_231
   
  (Node : Bare_Incomplete_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_232
   
  (Node : Bare_Incomplete_Type_Decl
  )

   return Boolean
   ;



   



         procedure Incomplete_Type_Decl_Pre_Env_Actions
           (Self            : Bare_Incomplete_Type_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Incomplete_Formal_Type_Decl
        (Self : Bare_Incomplete_Formal_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Incomplete_Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Incomplete_Formal_Type_Decl_F_Is_Tagged : Bare_Tagged_Node
         ; Incomplete_Formal_Type_Decl_F_Default_Type : Bare_Name
        );

      
   function Incomplete_Formal_Type_Decl_F_Is_Tagged
     (Node : Bare_Incomplete_Formal_Type_Decl) return Bare_Tagged_Node;

      
   function Incomplete_Formal_Type_Decl_F_Default_Type
     (Node : Bare_Incomplete_Formal_Type_Decl) return Bare_Name;


         



 function Incomplete_Formal_Type_Decl_P_Is_Tagged_Type
   
  (Node : Bare_Incomplete_Formal_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_Incomplete_Tagged_Type_Decl
        (Self : Bare_Incomplete_Tagged_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Incomplete_Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Incomplete_Tagged_Type_Decl_F_Has_Abstract : Bare_Abstract_Node
        );

      
   function Incomplete_Tagged_Type_Decl_F_Has_Abstract
     (Node : Bare_Incomplete_Tagged_Type_Decl) return Bare_Abstract_Node;


         



 function Incomplete_Tagged_Type_Decl_P_Is_Tagged_Type
   
  (Node : Bare_Incomplete_Tagged_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_Protected_Type_Decl
        (Self : Bare_Protected_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Protected_Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Protected_Type_Decl_F_Aspects : Bare_Aspect_Spec
         ; Protected_Type_Decl_F_Interfaces : Bare_Parent_List
         ; Protected_Type_Decl_F_Definition : Bare_Protected_Def
        );

      
   function Protected_Type_Decl_F_Discriminants
     (Node : Bare_Protected_Type_Decl) return Bare_Discriminant_Part;

      
   function Protected_Type_Decl_F_Interfaces
     (Node : Bare_Protected_Type_Decl) return Bare_Parent_List;

      
   function Protected_Type_Decl_F_Definition
     (Node : Bare_Protected_Type_Decl) return Bare_Protected_Def;


         



 function Protected_Type_Decl_P_Discriminants_List
   
  (Node : Bare_Protected_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Protected_Type_Decl_P_Defining_Env
   
  (Node : Bare_Protected_Type_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Protected_Type_Decl_P_Base_Interfaces
   
  (Node : Bare_Protected_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;


         



 function Protected_Type_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Protected_Type_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Protected_Type_Decl_P_Xref_Entry_Point
   
  (Node : Bare_Protected_Type_Decl
  )

   return Boolean
   ;


         



 function Protected_Type_Decl_P_Xref_Equation
   
  (Node : Bare_Protected_Type_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Protected_Type_Decl_P_Declarative_Parts
   
  (Node : Bare_Protected_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;


         



 function Protected_Type_Decl_P_Env_Names
   
  (Node : Bare_Protected_Type_Decl
  )

   return Symbol_Type_Array_Access
   ;


         



 function Env_Mappings_13
   
  (Node : Bare_Protected_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_14
   
  (Node : Bare_Protected_Type_Decl
  )

   return Boolean
   ;


         



 function Env_Names_15
   
  (Node : Bare_Protected_Type_Decl
  )

   return Symbol_Type_Array_Access
   ;



   



         procedure Protected_Type_Decl_Pre_Env_Actions
           (Self            : Bare_Protected_Type_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Task_Type_Decl
        (Self : Bare_Task_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Task_Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Task_Type_Decl_F_Aspects : Bare_Aspect_Spec
         ; Task_Type_Decl_F_Definition : Bare_Task_Def
        );

      
   function Task_Type_Decl_F_Discriminants
     (Node : Bare_Task_Type_Decl) return Bare_Discriminant_Part;

      
   function Task_Type_Decl_F_Definition
     (Node : Bare_Task_Type_Decl) return Bare_Task_Def;


         



 function Task_Type_Decl_P_Is_Task_Type
   
  (Node : Bare_Task_Type_Decl
  )

   return Boolean
   ;


         



 function Task_Type_Decl_P_Base_Interfaces
   
  (Node : Bare_Task_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;


         



 function Task_Type_Decl_P_Env_Names
   
  (Node : Bare_Task_Type_Decl
  )

   return Symbol_Type_Array_Access
   ;


         



 function Task_Type_Decl_P_Defining_Env
   
  (Node : Bare_Task_Type_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Task_Type_Decl_P_Discriminants_List
   
  (Node : Bare_Task_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Task_Type_Decl_P_Xref_Entry_Point
   
  (Node : Bare_Task_Type_Decl
  )

   return Boolean
   ;


         



 function Task_Type_Decl_P_Xref_Equation
   
  (Node : Bare_Task_Type_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Task_Type_Decl_P_Declarative_Parts
   
  (Node : Bare_Task_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;


         



 function Env_Mappings_9
   
  (Node : Bare_Task_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_10
   
  (Node : Bare_Task_Type_Decl
  )

   return Boolean
   ;


         



 function Env_Names_11
   
  (Node : Bare_Task_Type_Decl
  )

   return Symbol_Type_Array_Access
   ;



   



         procedure Task_Type_Decl_Pre_Env_Actions
           (Self            : Bare_Task_Type_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Single_Task_Type_Decl
        (Self : Bare_Single_Task_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Task_Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Task_Type_Decl_F_Aspects : Bare_Aspect_Spec
         ; Task_Type_Decl_F_Definition : Bare_Task_Def
        );


         



 function Env_Trans_Parent_12
   
  (Node : Bare_Single_Task_Type_Decl
  )

   return Boolean
   ;



   



         procedure Single_Task_Type_Decl_Pre_Env_Actions
           (Self            : Bare_Single_Task_Type_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Type_Decl
        (Self : Bare_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Type_Decl_F_Type_Def : Bare_Type_Def
        );

      
   function Type_Decl_F_Discriminants
     (Node : Bare_Type_Decl) return Bare_Discriminant_Part;

      
   function Type_Decl_F_Type_Def
     (Node : Bare_Type_Decl) return Bare_Type_Def;


         



 function Type_Decl_P_Is_Iterable_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Whether Self is a type that is iterable in a for .. of loop

         



 function Type_Decl_P_Iterable_Comp_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Type_Decl_P_Discrete_Range
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Discrete_Range
   ;


         



 function Type_Decl_P_Discriminants_List
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Formal_Param_Decl_Array_Access
   ;


         



 function Type_Decl_F_Direct_Primitives_Env
   
  (Node : Bare_Type_Decl
  )

   return Lexical_Env
   ;
--  The environment that contains all subprograms that are direct primitives of
--  this type, that is, primitives that are not inherited.

         



 function Type_Decl_F_Direct_Primitive_Subps
   
  (Node : Bare_Type_Decl
  )

   return Internal_Inner_Env_Assoc_Array_Access
   ;
--  Return the list of all subprograms that are direct primitives of this type.
--  We look for them in the public part and private part of the package this
--  type is declared in.

         



 function Type_Decl_P_Array_Ndims
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Integer
   ;


         



 function Type_Decl_P_Is_Real_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Is_Float_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Is_Fixed_Point
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Is_Int_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Is_Access_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Is_Static_Decl
   
  (Node : Bare_Type_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Accessed_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Type_Decl_P_Access_Def
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Access_Def
   ;


         



 function Type_Decl_P_Is_Tagged_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Base_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Type_Decl_P_Base_Interfaces
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl_Array_Access
   ;


         



 function Type_Decl_P_Is_Char_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Is_Enum_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Is_Private
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Is_Derived_Tagged_Type
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Array_Def
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Array_Type_Def
   ;


         



 function Type_Decl_P_Root_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Type_Decl_P_Defining_Env
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Type_Decl_P_Predefined_Operators
   
  (Node : Bare_Type_Decl
  )

   return Internal_Env_Assoc_Array_Access
   ;
--  Return all the predefined operators for this type, as an array of env
--  associations ready to be added to a lexical environment.
--
--  Note that the universal int and universal real types are not real type
--  declarations and do not have their own operators (:rmlink:`3.4.1` - 7).

         



 function Type_Decl_P_Record_Def
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Record_Def
   ;


         



 function Type_Decl_P_Xref_Entry_Point
   
  (Node : Bare_Type_Decl
  )

   return Boolean
   ;


         



 function Type_Decl_P_Xref_Equation
   
  (Node : Bare_Type_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Type_Decl_P_Is_Discrete_Type
   
  (Node : Bare_Type_Decl
      ; Origin : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Own_Primitives_Env
   
  (Node : Bare_Type_Decl
      ; With_Rebindings : Env_Rebindings
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return the environment containing the primitives for Self, rebound using
--  the given rebindings.

         



 function Type_Decl_P_Own_Primitives_Envs
   
  (Node : Bare_Type_Decl
      ; With_Rebindings : Env_Rebindings
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env_Array_Access
   ;
--  Return the environments containing the primitives for Self and its previous
--  parts, if there are some. All returned environments are rebound using the
--  given rebindings.

         



 function Type_Decl_P_Primitives_Envs
   
  (Node : Bare_Type_Decl
      ; With_Rebindings : Env_Rebindings
      ; Stop_At : Internal_Entity_Base_Type_Decl_Array_Access
      ; Include_Self : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env_Array_Access
   ;
--  Return the environments containing the primitives for Self (if
--  ``include_self`` is True) and all its base types up to ``stop_at``: upon
--  rewinding the base type chain, if we stumble on one of the types included
--  in the ``stop_at`` set, we stop the recusion of that branch. All returned
--  environments are rebound using the given rebindings.

         



 function Type_Decl_P_Compute_Primitives_Env
   
  (Node : Bare_Type_Decl
      ; Include_Self : Boolean
         := True
      ; Stop_At : Internal_Entity_Base_Type_Decl_Array_Access
         := No_Internal_Entity_Base_Type_Decl_Array_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return a environment containing all primitives accessible to Self, with the
--  adjusted ``primitive_real_type`` metadata field.

         



 function Type_Decl_P_Parent_Primitives_Env
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Type_Decl_P_Refined_Parent_Primitives_Env
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return a lexical environment containing the primitives inherited by this
--  type. This makes sure not to re-include primitives which have already been
--  inherited by the previous part of this type, so as to:
--
--  * Not overload lexical envs with useless entries (when one has view on this
--    part, it necessarily has view on its previous part).
--
--  * But most importantly, to fix a visibility issue arising when resolving a
--    reference to a subprogram overriden in the public part of a package if
--    the type has a refined declaration in its private part, in which case the
--    inherited subprogram would take precedence over the overriden one (see
--    testcase precise_override_2, U817-024).This change fixes this issue
--    because, by construction, if the overriden subprogram lies in the public
--    part, it means the public type declaration already has a view on the
--    inherited subprogram, which means we won't include it in the environment
--    computed here for the private view.

         



 function Type_Decl_P_Primitives_Env
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Type_Decl_P_Get_Primitives
   
  (Node : Bare_Type_Decl
      ; Only_Inherited : Boolean
         := False
      ; Include_Predefined_Operators : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;
--  Return the list of all primitive operations that are available on this
--  type. If ``only_inherited`` is True, it will only return the primitives
--  that are implicitly inherited by this type, discarding those explicitly
--  defined on this type. Predefined operators are included in the result iff
--  ``include_predefined_operators`` is True. It defaults to False.

         



 function Type_Decl_P_Get_Imp_Deref
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Expr
   ;


         



 function Type_Decl_P_Has_Ud_Indexing
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Type_Decl_P_Constant_Indexing_Fns
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;


         



 function Type_Decl_P_Variable_Indexing_Fns
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl_Array_Access
   ;


         



 function Env_Mappings_3
   
  (Node : Bare_Type_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Mappings_4
   
  (Node : Bare_Type_Decl
  )

   return Internal_Env_Assoc_Array_Access
   ;


         



 function Env_Trans_Parent_5
   
  (Node : Bare_Type_Decl
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_6
   
  (Node : Bare_Type_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Env_Dest_7
   
  (Node : Bare_Type_Decl
  )

   return Lexical_Env
   ;


         



 function Ref_Cond_8
   
  (Node : Bare_Type_Decl
  )

   return Boolean
   ;



   



         procedure Type_Decl_Pre_Env_Actions
           (Self            : Bare_Type_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);

         procedure Type_Decl_Post_Env_Actions
           (Self : Bare_Type_Decl; State : in out PLE_Node_State);



      

   

      
      procedure Initialize_Fields_For_Anonymous_Type_Decl
        (Self : Bare_Anonymous_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Type_Decl_F_Type_Def : Bare_Type_Def
        );


         



 function Anonymous_Type_Decl_P_Access_Def_Matches
   
  (Node : Bare_Anonymous_Type_Decl
      ; Other : Internal_Entity_Base_Type_Decl
      ; For_Assignment : Boolean
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;
--  Returns whether:
--
--  1. Self and other are both access types.
--
--  2. Their access def matches structurally. If for_assignment is True,
--     matching_assign_type is used instead of matching_type to compare the two
--     access defs.

         



 function Anonymous_Type_Decl_P_Xref_Entry_Point
   
  (Node : Bare_Anonymous_Type_Decl
  )

   return Boolean
   ;



   







      

   

      
      procedure Initialize_Fields_For_Synth_Anonymous_Type_Decl
        (Self : Bare_Synth_Anonymous_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Type_Decl_F_Type_Def : Bare_Type_Def
        );



   




      

   

      
      procedure Initialize_Fields_For_Concrete_Type_Decl
        (Self : Bare_Concrete_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Type_Decl_F_Type_Def : Bare_Type_Def
         ; Concrete_Type_Decl_F_Aspects : Bare_Aspect_Spec
        );



   




      

   

      
      procedure Initialize_Fields_For_Formal_Type_Decl
        (Self : Bare_Formal_Type_Decl
         ; Base_Type_Decl_F_Name : Bare_Defining_Name
         ; Type_Decl_F_Discriminants : Bare_Discriminant_Part
         ; Type_Decl_F_Type_Def : Bare_Type_Def
         ; Formal_Type_Decl_F_Default_Type : Bare_Name
         ; Formal_Type_Decl_F_Aspects : Bare_Aspect_Spec
        );

      
   function Formal_Type_Decl_F_Default_Type
     (Node : Bare_Formal_Type_Decl) return Bare_Name;


         



 function Formal_Type_Decl_P_Xref_Equation
   
  (Node : Bare_Formal_Type_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;



   




      

   



         



 function Basic_Subp_Decl_P_Defining_Names
   
  (Node : Bare_Basic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Basic_Subp_Decl_P_Defining_Env
   
  (Node : Bare_Basic_Subp_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Basic_Subp_Decl_P_Type_Expression
   
  (Node : Bare_Basic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;
--  The expr type of a subprogram declaration is the return type of the
--  subprogram if the subprogram is a function.

         



 function Basic_Subp_Decl_P_Get_Body_In_Env
   
  (Node : Bare_Basic_Subp_Decl
      ; Env : Lexical_Env
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Body_Node
   ;


         



 function Basic_Subp_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Basic_Subp_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Basic_Subp_Decl_P_Constrain_Prefix
   
  (Node : Bare_Basic_Subp_Decl
      ; Prefix : Bare_Expr
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Basic_Subp_Decl_P_Expr_Type
   
  (Node : Bare_Basic_Subp_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Basic_Subp_Decl_P_Env_Names
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Symbol_Type_Array_Access
   ;


         



 function Dispatcher_Basic_Subp_Decl_P_Subp_Decl_Spec
   
  (Node : Bare_Basic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   with Inline_Always
   ;
--  Return the specification for this subprogram

         



 function Env_Do_25
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Boolean
   ;


         



 function Initial_Env_26
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_27
   
  (Node : Bare_Basic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;


         



 function Env_Trans_Parent_28
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Boolean
   ;


         



 function Env_Names_29
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Symbol_Type_Array_Access
   ;


         



 function Env_Do_30
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Ref_Env_Nodes_31
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_32
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_33
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_34
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Boolean
   ;


         



 function Env_Do_35
   
  (Node : Bare_Basic_Subp_Decl
  )

   return Boolean
   ;



   



         procedure Basic_Subp_Decl_Pre_Env_Actions
           (Self            : Bare_Basic_Subp_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);

         procedure Basic_Subp_Decl_Post_Env_Actions
           (Self : Bare_Basic_Subp_Decl; State : in out PLE_Node_State);



      

   

      
      procedure Initialize_Fields_For_Classic_Subp_Decl
        (Self : Bare_Classic_Subp_Decl
         ; Classic_Subp_Decl_F_Overriding : Bare_Overriding_Node
         ; Classic_Subp_Decl_F_Subp_Spec : Bare_Subp_Spec
        );

      
   function Classic_Subp_Decl_F_Overriding
     (Node : Bare_Classic_Subp_Decl) return Bare_Overriding_Node;

      
   function Classic_Subp_Decl_F_Subp_Spec
     (Node : Bare_Classic_Subp_Decl) return Bare_Subp_Spec;


         



 function Classic_Subp_Decl_P_Subp_Decl_Spec
   
  (Node : Bare_Classic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   ;


         



 function Classic_Subp_Decl_P_Body_Part
   
  (Node : Bare_Classic_Subp_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Body
   ;
--  Return the BaseSubpBody corresponding to this node.


   




      

   

      
      procedure Initialize_Fields_For_Abstract_Subp_Decl
        (Self : Bare_Abstract_Subp_Decl
         ; Classic_Subp_Decl_F_Overriding : Bare_Overriding_Node
         ; Classic_Subp_Decl_F_Subp_Spec : Bare_Subp_Spec
         ; Abstract_Subp_Decl_F_Aspects : Bare_Aspect_Spec
        );



   




      

   

      
      procedure Initialize_Fields_For_Formal_Subp_Decl
        (Self : Bare_Formal_Subp_Decl
         ; Classic_Subp_Decl_F_Overriding : Bare_Overriding_Node
         ; Classic_Subp_Decl_F_Subp_Spec : Bare_Subp_Spec
         ; Formal_Subp_Decl_F_Default_Expr : Bare_Expr
         ; Formal_Subp_Decl_F_Aspects : Bare_Aspect_Spec
        );

      
   function Formal_Subp_Decl_F_Default_Expr
     (Node : Bare_Formal_Subp_Decl) return Bare_Expr;


         



 function Formal_Subp_Decl_P_Defining_Names
   
  (Node : Bare_Formal_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Formal_Subp_Decl_P_Xref_Equation
   
  (Node : Bare_Formal_Subp_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Formal_Subp_Decl_P_Designated_Subprogram_From
   
  (Node : Bare_Formal_Subp_Decl
      ; Inst : Internal_Entity_Generic_Instantiation
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the first visible subprogram that can match this formal subp in the
--  context of an instantiation. This is used to find the matching subprogram
--  in an instantiation for a formal subp with a box expr.


   




      

   

      
      procedure Initialize_Fields_For_Abstract_Formal_Subp_Decl
        (Self : Bare_Abstract_Formal_Subp_Decl
         ; Classic_Subp_Decl_F_Overriding : Bare_Overriding_Node
         ; Classic_Subp_Decl_F_Subp_Spec : Bare_Subp_Spec
         ; Formal_Subp_Decl_F_Default_Expr : Bare_Expr
         ; Formal_Subp_Decl_F_Aspects : Bare_Aspect_Spec
        );



   




      

   

      
      procedure Initialize_Fields_For_Concrete_Formal_Subp_Decl
        (Self : Bare_Concrete_Formal_Subp_Decl
         ; Classic_Subp_Decl_F_Overriding : Bare_Overriding_Node
         ; Classic_Subp_Decl_F_Subp_Spec : Bare_Subp_Spec
         ; Formal_Subp_Decl_F_Default_Expr : Bare_Expr
         ; Formal_Subp_Decl_F_Aspects : Bare_Aspect_Spec
        );



   




      

   

      
      procedure Initialize_Fields_For_Subp_Decl
        (Self : Bare_Subp_Decl
         ; Classic_Subp_Decl_F_Overriding : Bare_Overriding_Node
         ; Classic_Subp_Decl_F_Subp_Spec : Bare_Subp_Spec
         ; Subp_Decl_F_Aspects : Bare_Aspect_Spec
        );


         



 function Subp_Decl_P_Is_Constant_Object
   
  (Node : Bare_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_Entry_Decl
        (Self : Bare_Entry_Decl
         ; Entry_Decl_F_Overriding : Bare_Overriding_Node
         ; Entry_Decl_F_Spec : Bare_Entry_Spec
         ; Entry_Decl_F_Aspects : Bare_Aspect_Spec
        );

      
   function Entry_Decl_F_Overriding
     (Node : Bare_Entry_Decl) return Bare_Overriding_Node;

      
   function Entry_Decl_F_Spec
     (Node : Bare_Entry_Decl) return Bare_Entry_Spec;


         



 function Entry_Decl_P_Subp_Decl_Spec
   
  (Node : Bare_Entry_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   ;


         



 function Entry_Decl_P_Defining_Names
   
  (Node : Bare_Entry_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Entry_Decl_P_Body_Part
   
  (Node : Bare_Entry_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Entry_Body
   ;
--  Return the entry body associated to this entry declaration.

         



 function Entry_Decl_P_Has_Family
   
  (Node : Bare_Entry_Decl
  )

   return Boolean
   ;
--  Return whether this actually declares a family of entries.

         



 function Entry_Decl_P_Family_Type
   
  (Node : Bare_Entry_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;
--  Return the type designated by the family type, if relevant. Note that the
--  family type may be an anonymous range, in which case this property returns
--  None.

         



 function Entry_Decl_P_Accept_Stmts
   
  (Node : Bare_Entry_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Accept_Stmt_Array_Access
   ;
--  Return an array of accept statements corresponding to this entry.

         



 function Entry_Decl_P_Find_Accept_Stmts
   
  (Node : Bare_Entry_Decl
      ; Root : Internal_Entity
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Accept_Stmt_Array_Access
   ;
--  Find all accept statements in all children of ``root`` that correspond to
--  this entry declaration.

         



 function Env_Mappings_131
   
  (Node : Bare_Entry_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_132
   
  (Node : Bare_Entry_Decl
  )

   return Boolean
   ;



   



         procedure Entry_Decl_Pre_Env_Actions
           (Self            : Bare_Entry_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Enum_Literal_Decl
        (Self : Bare_Enum_Literal_Decl
         ; Enum_Literal_Decl_F_Name : Bare_Defining_Name
        );

      
   function Enum_Literal_Decl_F_Name
     (Node : Bare_Enum_Literal_Decl) return Bare_Defining_Name;


         



 function Enum_Literal_Decl_P_Is_Static_Decl
   
  (Node : Bare_Enum_Literal_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Enum_Literal_Decl_P_Is_Constant_Object
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Dispatcher_Enum_Literal_Decl_P_Enum_Type
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Decl
   with Inline_Always
   ;
--  Return the enum type corresponding to this enum literal.

         



 function Enum_Literal_Decl_P_Defining_Names
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Enum_Literal_Decl_P_Synth_Type_Expr
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Enum_Lit_Synth_Type_Expr
   ;


         



 function Enum_Literal_Decl_P_Subp_Decl_Spec
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   ;


         



 function Dispatcher_Enum_Literal_Decl_P_Enum_Decl_Name
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   with Inline_Always
   ;


         



 function Env_Mappings_129
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_130
   
  (Node : Bare_Enum_Literal_Decl
  )

   return Boolean
   ;


         



 function Enum_Literal_Decl_P_Enum_Type
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Decl
   ;
--  Return the enum type corresponding to this enum literal.

         



 function Enum_Literal_Decl_P_Enum_Decl_Name
   
  (Node : Bare_Enum_Literal_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;



   



         procedure Enum_Literal_Decl_Pre_Env_Actions
           (Self            : Bare_Enum_Literal_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Synthetic_Char_Enum_Lit
        (Self : Bare_Synthetic_Char_Enum_Lit
         ; Enum_Literal_Decl_F_Name : Bare_Defining_Name
        );


         



 function Synthetic_Char_Enum_Lit_P_Enum_Type
   
  (Node : Bare_Synthetic_Char_Enum_Lit
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Decl
   ;


         



 function Synthetic_Char_Enum_Lit_P_Expr
   
  (Node : Bare_Synthetic_Char_Enum_Lit
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;
--  Return the CharLiteral expression corresponding to this enum literal.

         



 function Synthetic_Char_Enum_Lit_P_Enum_Decl_Name
   
  (Node : Bare_Synthetic_Char_Enum_Lit
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name
   ;


         



 function Synthetic_Char_Enum_Lit_P_Defining_Names
   
  (Node : Bare_Synthetic_Char_Enum_Lit
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Generic_Subp_Internal
        (Self : Bare_Generic_Subp_Internal
         ; Generic_Subp_Internal_F_Subp_Spec : Bare_Subp_Spec
         ; Generic_Subp_Internal_F_Aspects : Bare_Aspect_Spec
        );

      
   function Generic_Subp_Internal_F_Subp_Spec
     (Node : Bare_Generic_Subp_Internal) return Bare_Subp_Spec;


         



 function Generic_Subp_Internal_P_Subp_Decl_Spec
   
  (Node : Bare_Generic_Subp_Internal
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   ;


         



 function Env_Trans_Parent_105
   
  (Node : Bare_Generic_Subp_Internal
  )

   return Boolean
   ;


         



 function Env_Names_106
   
  (Node : Bare_Generic_Subp_Internal
  )

   return Symbol_Type_Array_Access
   ;



   



         procedure Generic_Subp_Internal_Pre_Env_Actions
           (Self            : Bare_Generic_Subp_Internal;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Synthetic_Subp_Decl
        (Self : Bare_Synthetic_Subp_Decl
         ; Synthetic_Subp_Decl_F_Spec : Bare_Base_Subp_Spec
        );

      
   function Synthetic_Subp_Decl_F_Spec
     (Node : Bare_Synthetic_Subp_Decl) return Bare_Base_Subp_Spec;


         



 function Synthetic_Subp_Decl_P_Subp_Decl_Spec
   
  (Node : Bare_Synthetic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Spec
   ;


         



 function Synthetic_Subp_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Synthetic_Subp_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Synthetic_Subp_Decl_P_Is_Static_Decl
   
  (Node : Bare_Synthetic_Subp_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;



   




      

   



         



 function Body_Node_P_Env_Hook_Body
   
  (Node : Bare_Body_Node
  )

   return Boolean
   ;
--  Helper for the AdaNode.env_hook. Handle library-level unit body nodes.

         



 function Body_Node_P_Subunit_Decl_Env
   
  (Node : Bare_Body_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Body_Node_P_In_Scope
   
  (Node : Bare_Body_Node
      ; Origin : Bare_Ada_Node
  )

   return Boolean
   ;
--  Return True if ``origin`` is directly in the scope of this body.

         



 function Body_Node_P_Body_Decl_Scope
   
  (Node : Bare_Body_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return the scope of this body's decl.

         



 function Body_Node_P_Body_Initial_Env_Name
   
  (Node : Bare_Body_Node
  )

   return Symbol_Type
   ;
--  A package or subprogram body has a named parent env only if it is a
--  compilation unit root, in which case it will be the name of its
--  corresponding declaration.

         



 function Body_Node_P_Body_Initial_Env
   
  (Node : Bare_Body_Node
  )

   return Internal_Designated_Env
   ;
--  Return the initial env for a body. It's always the current environment
--  except for compilation unit roots for which we use the environment of their
--  corresponding declaration.

         



 function Dispatcher_Body_Node_P_Previous_Part_Env_Name
   
  (Node : Bare_Body_Node
  )

   return Symbol_Type
   with Inline_Always
   ;
--  Return the name of the lexical env of the previous part of this body. For a
--  subunit, the previous part is its stub, otherwise it's the body's
--  declaration. If that declaration has a named env, it will be registered
--  with the same top_level_env_name as this body.

         



 function Dispatcher_Body_Node_P_Previous_Part_Link_Env_Assoc
   
  (Node : Bare_Body_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   with Inline_Always
   ;
--  Return the env association that describes where to add a ``__nextpart``
--  entry for this body, if it corresponds to a non-overloadable entity (i.e.
--  not a subprogram).
--
--  Note that entry navigation is handled a bit differently and in particular
--  we don't need a ``__nextpart`` link for them. Hence this property is never
--  called from EntryBody env specs.

         



 function Body_Node_P_Subp_Previous_Part
   
  (Node : Bare_Body_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the decl corresponding to this body. Specialized implementation for
--  subprogram bodies.
--
--  .. attention:: It is important to not perform any signature match in cases
--     where we don't need to (top-level subprograms), as the robustness of
--     some important properties is at stake (e.g. imported_units, and
--     therefore find_all_references).

         



 function Body_Node_P_Entry_Previous_Part
   
  (Node : Bare_Body_Node
      ; Env : Lexical_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Entry_Decl
   ;
--  Return the EntryDecl corresponding to this node.

         



 function Body_Node_P_Package_Previous_Part
   
  (Node : Bare_Body_Node
      ; Env : Lexical_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the BasePackageDecl corresponding to this node.
--
--  If the case of generic package declarations, this returns the
--  ``package_decl`` field instead of the ``GenericPackageDecl`` itself.

         



 function Body_Node_P_Task_Previous_Part
   
  (Node : Bare_Body_Node
      ; Env : Lexical_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the task decl corresponding to this node.

         



 function Body_Node_P_Protected_Previous_Part
   
  (Node : Bare_Body_Node
      ; Env : Lexical_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the ProtectedDecl corresponding to this node.

         



 function Body_Node_P_Unbound_Previous_Part
   
  (Node : Bare_Body_Node
      ; Env : Lexical_Env
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the previous part for this body. Might be a declaration or a body
--  stub.

         



 function Body_Node_P_Previous_Part_Internal
   
  (Node : Bare_Body_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the previous part for this body. Might be a declaration or a body
--  stub.
--
--  .. note:: This internal property was introduced by T812-020 in order to
--     break an infinite recursion.

         



 function Body_Node_P_Previous_Part
   
  (Node : Bare_Body_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the previous part for this body. Might be a declaration or a body
--  stub.

         



 function Body_Node_P_Decl_Part
   
  (Node : Bare_Body_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  Return the decl corresponding to this node if applicable.

         



 function Body_Node_P_Safe_Generic_Decl_Part
   
  (Node : Bare_Body_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Generic_Decl
   ;
--  Return the generic declaration corresponding to this body, if relevant.
--  This property is designed to be usable from within env specs.

         



 function Body_Node_P_Next_Part_For_Decl
   
  (Node : Bare_Body_Node
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  By default, bodies don't have a next part. This is not true for body stubs,
--  hence this property is overriden there.

         



 function Body_Node_P_Is_Subunit
   
  (Node : Bare_Body_Node
  )

   return Boolean
   ;


         



 function Body_Node_P_Subunit_Root
   
  (Node : Bare_Body_Node
  )

   return Internal_Entity_Basic_Decl
   ;
--  If self is a subunit, return the body in which it is rooted.

         



 function Body_Node_P_Body_Scope
   
  (Node : Bare_Body_Node
      ; Follow_Private : Boolean
      ; Force_Decl : Boolean
         := False
      ; Env : Lexical_Env
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return the scope for this body. If follow_private, then returns the private
--  part if possible.
--
--  If force_decl, then returns the corresponding declaration's scope, rather
--  than the parent body's scope.

         



 function Body_Node_P_Previous_Part_Env_Name
   
  (Node : Bare_Body_Node
  )

   return Symbol_Type
   ;
--  Return the name of the lexical env of the previous part of this body. For a
--  subunit, the previous part is its stub, otherwise it's the body's
--  declaration. If that declaration has a named env, it will be registered
--  with the same top_level_env_name as this body.

         



 function Body_Node_P_Previous_Part_Link_Env_Assoc
   
  (Node : Bare_Body_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;
--  Return the env association that describes where to add a ``__nextpart``
--  entry for this body, if it corresponds to a non-overloadable entity (i.e.
--  not a subprogram).
--
--  Note that entry navigation is handled a bit differently and in particular
--  we don't need a ``__nextpart`` link for them. Hence this property is never
--  called from EntryBody env specs.


   




      

   

      
      procedure Initialize_Fields_For_Base_Subp_Body
        (Self : Bare_Base_Subp_Body
         ; Base_Subp_Body_F_Overriding : Bare_Overriding_Node
         ; Base_Subp_Body_F_Subp_Spec : Bare_Subp_Spec
        );

      
   function Base_Subp_Body_F_Overriding
     (Node : Bare_Base_Subp_Body) return Bare_Overriding_Node;

      
   function Base_Subp_Body_F_Subp_Spec
     (Node : Bare_Base_Subp_Body) return Bare_Subp_Spec;


         



 function Base_Subp_Body_P_Defining_Names
   
  (Node : Bare_Base_Subp_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Base_Subp_Body_P_Is_Constant_Object
   
  (Node : Bare_Base_Subp_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Base_Subp_Body_P_Defining_Env
   
  (Node : Bare_Base_Subp_Body
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Base_Subp_Body_P_Type_Expression
   
  (Node : Bare_Base_Subp_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Base_Subp_Body_P_Expr_Type
   
  (Node : Bare_Base_Subp_Body
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Base_Subp_Body_P_Initial_Env_Name
   
  (Node : Bare_Base_Subp_Body
      ; Follow_Private : Boolean
         := False
  )

   return Symbol_Type
   ;


         



 function Base_Subp_Body_P_Previous_Part_Env_Name
   
  (Node : Bare_Base_Subp_Body
  )

   return Symbol_Type
   ;
--  Return the name of the lexical env of the previous part of this subprogram
--  body. Due to overloading, do not return anything in case we are not a
--  library item or subunit.

         



 function Env_Do_134
   
  (Node : Bare_Base_Subp_Body
  )

   return Boolean
   ;


         



 function Initial_Env_135
   
  (Node : Bare_Base_Subp_Body
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_136
   
  (Node : Bare_Base_Subp_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;


         



 function Env_Trans_Parent_137
   
  (Node : Bare_Base_Subp_Body
  )

   return Boolean
   ;


         



 function Env_Mappings_138
   
  (Node : Bare_Base_Subp_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Do_139
   
  (Node : Bare_Base_Subp_Body
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Ref_Env_Nodes_140
   
  (Node : Bare_Base_Subp_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_141
   
  (Node : Bare_Base_Subp_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_142
   
  (Node : Bare_Base_Subp_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_143
   
  (Node : Bare_Base_Subp_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_144
   
  (Node : Bare_Base_Subp_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_145
   
  (Node : Bare_Base_Subp_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_146
   
  (Node : Bare_Base_Subp_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_147
   
  (Node : Bare_Base_Subp_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_148
   
  (Node : Bare_Base_Subp_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_149
   
  (Node : Bare_Base_Subp_Body
  )

   return Boolean
   ;



   



         procedure Base_Subp_Body_Pre_Env_Actions
           (Self            : Bare_Base_Subp_Body;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Expr_Function
        (Self : Bare_Expr_Function
         ; Base_Subp_Body_F_Overriding : Bare_Overriding_Node
         ; Base_Subp_Body_F_Subp_Spec : Bare_Subp_Spec
         ; Expr_Function_F_Expr : Bare_Expr
         ; Expr_Function_F_Aspects : Bare_Aspect_Spec
        );

      
   function Expr_Function_F_Expr
     (Node : Bare_Expr_Function) return Bare_Expr;


         



 function Expr_Function_P_Xref_Equation
   
  (Node : Bare_Expr_Function
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Expr_Function_P_Xref_Entry_Point
   
  (Node : Bare_Expr_Function
  )

   return Boolean
   ;



   




      

   

      
      procedure Initialize_Fields_For_Null_Subp_Decl
        (Self : Bare_Null_Subp_Decl
         ; Base_Subp_Body_F_Overriding : Bare_Overriding_Node
         ; Base_Subp_Body_F_Subp_Spec : Bare_Subp_Spec
         ; Null_Subp_Decl_F_Aspects : Bare_Aspect_Spec
        );



   




      

   

      
      procedure Initialize_Fields_For_Subp_Body
        (Self : Bare_Subp_Body
         ; Base_Subp_Body_F_Overriding : Bare_Overriding_Node
         ; Base_Subp_Body_F_Subp_Spec : Bare_Subp_Spec
         ; Subp_Body_F_Aspects : Bare_Aspect_Spec
         ; Subp_Body_F_Decls : Bare_Declarative_Part
         ; Subp_Body_F_Stmts : Bare_Handled_Stmts
         ; Subp_Body_F_End_Name : Bare_End_Name
        );

      
   function Subp_Body_F_Decls
     (Node : Bare_Subp_Body) return Bare_Declarative_Part;

      
   function Subp_Body_F_Stmts
     (Node : Bare_Subp_Body) return Bare_Handled_Stmts;

      
   function Subp_Body_F_End_Name
     (Node : Bare_Subp_Body) return Bare_End_Name;


         



 function Subp_Body_P_Declarative_Parts
   
  (Node : Bare_Subp_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;



   




      

   

      
      procedure Initialize_Fields_For_Subp_Renaming_Decl
        (Self : Bare_Subp_Renaming_Decl
         ; Base_Subp_Body_F_Overriding : Bare_Overriding_Node
         ; Base_Subp_Body_F_Subp_Spec : Bare_Subp_Spec
         ; Subp_Renaming_Decl_F_Renames : Bare_Renaming_Clause
         ; Subp_Renaming_Decl_F_Aspects : Bare_Aspect_Spec
        );

      
   function Subp_Renaming_Decl_F_Renames
     (Node : Bare_Subp_Renaming_Decl) return Bare_Renaming_Clause;


         



 function Subp_Renaming_Decl_P_Xref_Entry_Point
   
  (Node : Bare_Subp_Renaming_Decl
  )

   return Boolean
   ;


         



 function Subp_Renaming_Decl_P_Xref_Equation
   
  (Node : Bare_Subp_Renaming_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;



   




      

   



         



 function Body_Stub_P_Next_Part_For_Decl
   
  (Node : Bare_Body_Stub
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Body_Stub_P_Syntactic_Fully_Qualified_Name
   
  (Node : Bare_Body_Stub
  )

   return Symbol_Type_Array_Access
   ;
--  Return the syntactic fully qualified name to refer to this body.
--
--  Note that this can raise a Property_Error when the stub is in an illegal
--  place (too nested, in a declare block, etc.).

         



 function Body_Stub_P_Env_Names
   
  (Node : Bare_Body_Stub
  )

   return Symbol_Type_Array_Access
   ;
--  All body stubs allow for a named environment, which is registered with a
--  ``__stub`` appended to the body's top_level_env_name.

         



 function Body_Stub_P_Previous_Part_Link_Env_Assoc
   
  (Node : Bare_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;



   




      

   

      
      procedure Initialize_Fields_For_Package_Body_Stub
        (Self : Bare_Package_Body_Stub
         ; Package_Body_Stub_F_Name : Bare_Defining_Name
         ; Package_Body_Stub_F_Aspects : Bare_Aspect_Spec
        );

      
   function Package_Body_Stub_F_Name
     (Node : Bare_Package_Body_Stub) return Bare_Defining_Name;


         



 function Package_Body_Stub_P_Defining_Names
   
  (Node : Bare_Package_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Env_Mappings_225
   
  (Node : Bare_Package_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_226
   
  (Node : Bare_Package_Body_Stub
  )

   return Boolean
   ;


         



 function Env_Names_227
   
  (Node : Bare_Package_Body_Stub
  )

   return Symbol_Type_Array_Access
   ;



   



         procedure Package_Body_Stub_Pre_Env_Actions
           (Self            : Bare_Package_Body_Stub;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Protected_Body_Stub
        (Self : Bare_Protected_Body_Stub
         ; Protected_Body_Stub_F_Name : Bare_Defining_Name
         ; Protected_Body_Stub_F_Aspects : Bare_Aspect_Spec
        );

      
   function Protected_Body_Stub_F_Name
     (Node : Bare_Protected_Body_Stub) return Bare_Defining_Name;


         



 function Protected_Body_Stub_P_Defining_Names
   
  (Node : Bare_Protected_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Env_Mappings_215
   
  (Node : Bare_Protected_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_216
   
  (Node : Bare_Protected_Body_Stub
  )

   return Boolean
   ;


         



 function Env_Names_217
   
  (Node : Bare_Protected_Body_Stub
  )

   return Symbol_Type_Array_Access
   ;



   



         procedure Protected_Body_Stub_Pre_Env_Actions
           (Self            : Bare_Protected_Body_Stub;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Subp_Body_Stub
        (Self : Bare_Subp_Body_Stub
         ; Subp_Body_Stub_F_Overriding : Bare_Overriding_Node
         ; Subp_Body_Stub_F_Subp_Spec : Bare_Subp_Spec
         ; Subp_Body_Stub_F_Aspects : Bare_Aspect_Spec
        );

      
   function Subp_Body_Stub_F_Overriding
     (Node : Bare_Subp_Body_Stub) return Bare_Overriding_Node;

      
   function Subp_Body_Stub_F_Subp_Spec
     (Node : Bare_Subp_Body_Stub) return Bare_Subp_Spec;


         



 function Subp_Body_Stub_P_Defining_Names
   
  (Node : Bare_Subp_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Subp_Body_Stub_P_Type_Expression
   
  (Node : Bare_Subp_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Type_Expr
   ;


         



 function Env_Mappings_218
   
  (Node : Bare_Subp_Body_Stub
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_219
   
  (Node : Bare_Subp_Body_Stub
  )

   return Boolean
   ;


         



 function Env_Names_220
   
  (Node : Bare_Subp_Body_Stub
  )

   return Symbol_Type_Array_Access
   ;


         



 function Ref_Env_Nodes_221
   
  (Node : Bare_Subp_Body_Stub
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_222
   
  (Node : Bare_Subp_Body_Stub
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_223
   
  (Node : Bare_Subp_Body_Stub
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_224
   
  (Node : Bare_Subp_Body_Stub
  )

   return Boolean
   ;



   



         procedure Subp_Body_Stub_Pre_Env_Actions
           (Self            : Bare_Subp_Body_Stub;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Task_Body_Stub
        (Self : Bare_Task_Body_Stub
         ; Task_Body_Stub_F_Name : Bare_Defining_Name
         ; Task_Body_Stub_F_Aspects : Bare_Aspect_Spec
        );

      
   function Task_Body_Stub_F_Name
     (Node : Bare_Task_Body_Stub) return Bare_Defining_Name;


         



 function Task_Body_Stub_P_Defining_Names
   
  (Node : Bare_Task_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Env_Mappings_228
   
  (Node : Bare_Task_Body_Stub
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_229
   
  (Node : Bare_Task_Body_Stub
  )

   return Boolean
   ;


         



 function Env_Names_230
   
  (Node : Bare_Task_Body_Stub
  )

   return Symbol_Type_Array_Access
   ;



   



         procedure Task_Body_Stub_Pre_Env_Actions
           (Self            : Bare_Task_Body_Stub;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Entry_Body
        (Self : Bare_Entry_Body
         ; Entry_Body_F_Entry_Name : Bare_Defining_Name
         ; Entry_Body_F_Index_Spec : Bare_Entry_Index_Spec
         ; Entry_Body_F_Params : Bare_Entry_Completion_Formal_Params
         ; Entry_Body_F_Aspects : Bare_Aspect_Spec
         ; Entry_Body_F_Barrier : Bare_Expr
         ; Entry_Body_F_Decls : Bare_Declarative_Part
         ; Entry_Body_F_Stmts : Bare_Handled_Stmts
         ; Entry_Body_F_End_Name : Bare_End_Name
        );

      
   function Entry_Body_F_Entry_Name
     (Node : Bare_Entry_Body) return Bare_Defining_Name;

      
   function Entry_Body_F_Index_Spec
     (Node : Bare_Entry_Body) return Bare_Entry_Index_Spec;

      
   function Entry_Body_F_Params
     (Node : Bare_Entry_Body) return Bare_Entry_Completion_Formal_Params;

      
   function Entry_Body_F_Barrier
     (Node : Bare_Entry_Body) return Bare_Expr;

      
   function Entry_Body_F_Decls
     (Node : Bare_Entry_Body) return Bare_Declarative_Part;

      
   function Entry_Body_F_Stmts
     (Node : Bare_Entry_Body) return Bare_Handled_Stmts;

      
   function Entry_Body_F_End_Name
     (Node : Bare_Entry_Body) return Bare_End_Name;


         



 function Entry_Body_P_Defining_Names
   
  (Node : Bare_Entry_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Entry_Body_P_Declarative_Parts
   
  (Node : Bare_Entry_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;


         



 function Entry_Body_P_Xref_Entry_Point
   
  (Node : Bare_Entry_Body
  )

   return Boolean
   ;


         



 function Entry_Body_P_Xref_Equation
   
  (Node : Bare_Entry_Body
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Env_Do_210
   
  (Node : Bare_Entry_Body
  )

   return Boolean
   ;


         



 function Initial_Env_211
   
  (Node : Bare_Entry_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_212
   
  (Node : Bare_Entry_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;


         



 function Env_Trans_Parent_213
   
  (Node : Bare_Entry_Body
  )

   return Boolean
   ;



   



         procedure Entry_Body_Pre_Env_Actions
           (Self            : Bare_Entry_Body;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Package_Body
        (Self : Bare_Package_Body
         ; Package_Body_F_Package_Name : Bare_Defining_Name
         ; Package_Body_F_Aspects : Bare_Aspect_Spec
         ; Package_Body_F_Decls : Bare_Declarative_Part
         ; Package_Body_F_Stmts : Bare_Handled_Stmts
         ; Package_Body_F_End_Name : Bare_End_Name
        );

      
   function Package_Body_F_Package_Name
     (Node : Bare_Package_Body) return Bare_Defining_Name;

      
   function Package_Body_F_Decls
     (Node : Bare_Package_Body) return Bare_Declarative_Part;

      
   function Package_Body_F_Stmts
     (Node : Bare_Package_Body) return Bare_Handled_Stmts;

      
   function Package_Body_F_End_Name
     (Node : Bare_Package_Body) return Bare_End_Name;


         



 function Package_Body_P_Defining_Names
   
  (Node : Bare_Package_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Package_Body_P_Defining_Env
   
  (Node : Bare_Package_Body
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Package_Body_P_Declarative_Parts
   
  (Node : Bare_Package_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;


         



 function Package_Body_P_Package_Decl_Uses_Clauses_Envs
   
  (Node : Bare_Package_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;
--  Return the environments for the use clauses of the package decl of this
--  body. Used because they need to be explicitly referenced.

         



 function Env_Do_159
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;


         



 function Initial_Env_160
   
  (Node : Bare_Package_Body
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_161
   
  (Node : Bare_Package_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_162
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;


         



 function Env_Do_163
   
  (Node : Bare_Package_Body
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Ref_Env_Nodes_164
   
  (Node : Bare_Package_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_165
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_166
   
  (Node : Bare_Package_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_167
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_168
   
  (Node : Bare_Package_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_169
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_170
   
  (Node : Bare_Package_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_171
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_172
   
  (Node : Bare_Package_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_173
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_174
   
  (Node : Bare_Package_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_175
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_176
   
  (Node : Bare_Package_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_177
   
  (Node : Bare_Package_Body
  )

   return Boolean
   ;



   



         procedure Package_Body_Pre_Env_Actions
           (Self            : Bare_Package_Body;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Protected_Body
        (Self : Bare_Protected_Body
         ; Protected_Body_F_Name : Bare_Defining_Name
         ; Protected_Body_F_Aspects : Bare_Aspect_Spec
         ; Protected_Body_F_Decls : Bare_Declarative_Part
         ; Protected_Body_F_End_Name : Bare_End_Name
        );

      
   function Protected_Body_F_Name
     (Node : Bare_Protected_Body) return Bare_Defining_Name;

      
   function Protected_Body_F_Decls
     (Node : Bare_Protected_Body) return Bare_Declarative_Part;

      
   function Protected_Body_F_End_Name
     (Node : Bare_Protected_Body) return Bare_End_Name;


         



 function Protected_Body_P_Defining_Names
   
  (Node : Bare_Protected_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Protected_Body_P_Declarative_Parts
   
  (Node : Bare_Protected_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;


         



 function Env_Do_194
   
  (Node : Bare_Protected_Body
  )

   return Boolean
   ;


         



 function Initial_Env_195
   
  (Node : Bare_Protected_Body
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_196
   
  (Node : Bare_Protected_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_197
   
  (Node : Bare_Protected_Body
  )

   return Boolean
   ;


         



 function Env_Do_198
   
  (Node : Bare_Protected_Body
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Ref_Env_Nodes_199
   
  (Node : Bare_Protected_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_200
   
  (Node : Bare_Protected_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_201
   
  (Node : Bare_Protected_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_202
   
  (Node : Bare_Protected_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_203
   
  (Node : Bare_Protected_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_204
   
  (Node : Bare_Protected_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_205
   
  (Node : Bare_Protected_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_206
   
  (Node : Bare_Protected_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_207
   
  (Node : Bare_Protected_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Env_Nodes_208
   
  (Node : Bare_Protected_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_209
   
  (Node : Bare_Protected_Body
  )

   return Boolean
   ;



   



         procedure Protected_Body_Pre_Env_Actions
           (Self            : Bare_Protected_Body;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Task_Body
        (Self : Bare_Task_Body
         ; Task_Body_F_Name : Bare_Defining_Name
         ; Task_Body_F_Aspects : Bare_Aspect_Spec
         ; Task_Body_F_Decls : Bare_Declarative_Part
         ; Task_Body_F_Stmts : Bare_Handled_Stmts
         ; Task_Body_F_End_Name : Bare_End_Name
        );

      
   function Task_Body_F_Name
     (Node : Bare_Task_Body) return Bare_Defining_Name;

      
   function Task_Body_F_Decls
     (Node : Bare_Task_Body) return Bare_Declarative_Part;

      
   function Task_Body_F_Stmts
     (Node : Bare_Task_Body) return Bare_Handled_Stmts;

      
   function Task_Body_F_End_Name
     (Node : Bare_Task_Body) return Bare_End_Name;


         



 function Task_Body_P_Defining_Names
   
  (Node : Bare_Task_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Task_Body_P_Declarative_Parts
   
  (Node : Bare_Task_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Declarative_Part_Array_Access
   ;


         



 function Task_Body_P_Task_Type_Decl_Scope
   
  (Node : Bare_Task_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Task_Body_P_Task_Type
   
  (Node : Bare_Task_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Task_Type_Decl
   ;


         



 function Env_Do_178
   
  (Node : Bare_Task_Body
  )

   return Boolean
   ;


         



 function Initial_Env_179
   
  (Node : Bare_Task_Body
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_180
   
  (Node : Bare_Task_Body
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;


         



 function Env_Trans_Parent_181
   
  (Node : Bare_Task_Body
  )

   return Boolean
   ;


         



 function Env_Do_182
   
  (Node : Bare_Task_Body
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Ref_Env_Nodes_183
   
  (Node : Bare_Task_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_184
   
  (Node : Bare_Task_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_185
   
  (Node : Bare_Task_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_186
   
  (Node : Bare_Task_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_187
   
  (Node : Bare_Task_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_188
   
  (Node : Bare_Task_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_189
   
  (Node : Bare_Task_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_190
   
  (Node : Bare_Task_Body
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_191
   
  (Node : Bare_Task_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Env_Nodes_192
   
  (Node : Bare_Task_Body
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_193
   
  (Node : Bare_Task_Body
  )

   return Boolean
   ;



   



         procedure Task_Body_Pre_Env_Actions
           (Self            : Bare_Task_Body;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Entry_Index_Spec
        (Self : Bare_Entry_Index_Spec
         ; Entry_Index_Spec_F_Id : Bare_Defining_Name
         ; Entry_Index_Spec_F_Subtype : Bare_Ada_Node
         ; Entry_Index_Spec_F_Aspects : Bare_Aspect_Spec
        );

      
   function Entry_Index_Spec_F_Id
     (Node : Bare_Entry_Index_Spec) return Bare_Defining_Name;

      
   function Entry_Index_Spec_F_Subtype
     (Node : Bare_Entry_Index_Spec) return Bare_Ada_Node;


         



 function Entry_Index_Spec_P_Defining_Names
   
  (Node : Bare_Entry_Index_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Entry_Index_Spec_P_Defining_Env
   
  (Node : Bare_Entry_Index_Spec
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Entry_Index_Spec_P_Expr_Type
   
  (Node : Bare_Entry_Index_Spec
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Entry_Index_Spec_P_Xref_Equation
   
  (Node : Bare_Entry_Index_Spec
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Entry_Index_Spec_P_Xref_Entry_Point
   
  (Node : Bare_Entry_Index_Spec
  )

   return Boolean
   ;


         



 function Env_Mappings_214
   
  (Node : Bare_Entry_Index_Spec
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc
   ;



   



         procedure Entry_Index_Spec_Pre_Env_Actions
           (Self            : Bare_Entry_Index_Spec;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   



         



 function Error_Decl_P_Defining_Names
   
  (Node : Bare_Error_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Error_Decl_P_Child_Decl_Initial_Env_Name
   
  (Node : Bare_Error_Decl
      ; Private_Part : Boolean
         := False
  )

   return Symbol_Type
   ;
--  Override for error decls, which cannot be child decls.


   




      

   

      
      procedure Initialize_Fields_For_Exception_Decl
        (Self : Bare_Exception_Decl
         ; Exception_Decl_F_Ids : Bare_Defining_Name_List
         ; Exception_Decl_F_Renames : Bare_Renaming_Clause
         ; Exception_Decl_F_Aspects : Bare_Aspect_Spec
        );

      
   function Exception_Decl_F_Ids
     (Node : Bare_Exception_Decl) return Bare_Defining_Name_List;

      
   function Exception_Decl_F_Renames
     (Node : Bare_Exception_Decl) return Bare_Renaming_Clause;


         



 function Exception_Decl_P_Defining_Names
   
  (Node : Bare_Exception_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Exception_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Exception_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;
--  An exception declaration never has a next part.

         



 function Exception_Decl_P_Xref_Entry_Point
   
  (Node : Bare_Exception_Decl
  )

   return Boolean
   ;


         



 function Exception_Decl_P_Xref_Equation
   
  (Node : Bare_Exception_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Env_Mappings_58
   
  (Node : Bare_Exception_Decl
  )

   return Internal_Env_Assoc_Array_Access
   ;



   



         procedure Exception_Decl_Pre_Env_Actions
           (Self            : Bare_Exception_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Exception_Handler
        (Self : Bare_Exception_Handler
         ; Exception_Handler_F_Exception_Name : Bare_Defining_Name
         ; Exception_Handler_F_Handled_Exceptions : Bare_Alternatives_List
         ; Exception_Handler_F_Stmts : Bare_Stmt_List
        );

      
   function Exception_Handler_F_Exception_Name
     (Node : Bare_Exception_Handler) return Bare_Defining_Name;

      
   function Exception_Handler_F_Handled_Exceptions
     (Node : Bare_Exception_Handler) return Bare_Alternatives_List;

      
   function Exception_Handler_F_Stmts
     (Node : Bare_Exception_Handler) return Bare_Stmt_List;


         



 function Exception_Handler_P_Defining_Names
   
  (Node : Bare_Exception_Handler
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Exception_Handler_P_Expr_Type
   
  (Node : Bare_Exception_Handler
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function Exception_Handler_P_Xref_Equation
   
  (Node : Bare_Exception_Handler
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Exception_Handler_P_Xref_Entry_Point
   
  (Node : Bare_Exception_Handler
  )

   return Boolean
   ;


         



 function Exception_Handler_P_Is_Constant_Object
   
  (Node : Bare_Exception_Handler
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Env_Trans_Parent_150
   
  (Node : Bare_Exception_Handler
  )

   return Boolean
   ;


         



 function Env_Mappings_151
   
  (Node : Bare_Exception_Handler
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;



   



         procedure Exception_Handler_Pre_Env_Actions
           (Self            : Bare_Exception_Handler;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_For_Loop_Var_Decl
        (Self : Bare_For_Loop_Var_Decl
         ; For_Loop_Var_Decl_F_Id : Bare_Defining_Name
         ; For_Loop_Var_Decl_F_Id_Type : Bare_Type_Expr
        );

      
   function For_Loop_Var_Decl_F_Id
     (Node : Bare_For_Loop_Var_Decl) return Bare_Defining_Name;

      
   function For_Loop_Var_Decl_F_Id_Type
     (Node : Bare_For_Loop_Var_Decl) return Bare_Type_Expr;


         



 function For_Loop_Var_Decl_P_Defining_Names
   
  (Node : Bare_For_Loop_Var_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function For_Loop_Var_Decl_P_Defining_Env
   
  (Node : Bare_For_Loop_Var_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function For_Loop_Var_Decl_P_Expr_Type
   
  (Node : Bare_For_Loop_Var_Decl
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Type_Decl
   ;


         



 function For_Loop_Var_Decl_P_Is_Constant_Object
   
  (Node : Bare_For_Loop_Var_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function For_Loop_Var_Decl_P_Xref_Equation
   
  (Node : Bare_For_Loop_Var_Decl
      ; Env : Lexical_Env
      ; Origin : Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Logic_Equation
   ;


         



 function Env_Mappings_133
   
  (Node : Bare_For_Loop_Var_Decl
  )

   return Internal_Env_Assoc
   ;



   



         procedure For_Loop_Var_Decl_Pre_Env_Actions
           (Self            : Bare_For_Loop_Var_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Generic_Decl
        (Self : Bare_Generic_Decl
         ; Generic_Decl_F_Formal_Part : Bare_Generic_Formal_Part
        );

      
   function Generic_Decl_F_Formal_Part
     (Node : Bare_Generic_Decl) return Bare_Generic_Formal_Part;


         



 function Dispatcher_Generic_Decl_P_Decl
   
  (Node : Bare_Generic_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   with Inline_Always
   ;


         



 function Generic_Decl_P_Get_Aspect_Assoc
   
  (Node : Bare_Generic_Decl
      ; Name : Symbol_Type
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Aspect_Assoc
   ;


         



 function Generic_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Generic_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;



   




      

   

      
      procedure Initialize_Fields_For_Generic_Package_Decl
        (Self : Bare_Generic_Package_Decl
         ; Generic_Decl_F_Formal_Part : Bare_Generic_Formal_Part
         ; Generic_Package_Decl_F_Package_Decl : Bare_Generic_Package_Internal
        );

      
   function Generic_Package_Decl_F_Package_Decl
     (Node : Bare_Generic_Package_Decl) return Bare_Generic_Package_Internal;


         



 function Generic_Package_Decl_P_Defining_Env
   
  (Node : Bare_Generic_Package_Decl
      ; Origin : Bare_Ada_Node
      ; Include_Ud_Indexing : Boolean
         := False
      ; Dottable_Type : Bare_Ada_Node
         := No_Bare_Ada_Node
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Lexical_Env
   ;


         



 function Generic_Package_Decl_P_Defining_Names
   
  (Node : Bare_Generic_Package_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Generic_Package_Decl_P_Body_Part
   
  (Node : Bare_Generic_Package_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Package_Body
   ;
--  Return the PackageBody corresponding to this node, or null if there is
--  none.

         



 function Generic_Package_Decl_P_Decl
   
  (Node : Bare_Generic_Package_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Env_Do_119
   
  (Node : Bare_Generic_Package_Decl
  )

   return Boolean
   ;


         



 function Initial_Env_120
   
  (Node : Bare_Generic_Package_Decl
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_121
   
  (Node : Bare_Generic_Package_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;


         



 function Env_Trans_Parent_122
   
  (Node : Bare_Generic_Package_Decl
  )

   return Boolean
   ;


         



 function Env_Do_123
   
  (Node : Bare_Generic_Package_Decl
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Ref_Env_Nodes_124
   
  (Node : Bare_Generic_Package_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_125
   
  (Node : Bare_Generic_Package_Decl
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_126
   
  (Node : Bare_Generic_Package_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_127
   
  (Node : Bare_Generic_Package_Decl
  )

   return Boolean
   ;



   



         procedure Generic_Package_Decl_Pre_Env_Actions
           (Self            : Bare_Generic_Package_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);




      

   

      
      procedure Initialize_Fields_For_Generic_Subp_Decl
        (Self : Bare_Generic_Subp_Decl
         ; Generic_Decl_F_Formal_Part : Bare_Generic_Formal_Part
         ; Generic_Subp_Decl_F_Subp_Decl : Bare_Generic_Subp_Internal
        );

      
   function Generic_Subp_Decl_F_Subp_Decl
     (Node : Bare_Generic_Subp_Decl) return Bare_Generic_Subp_Internal;


         



 function Generic_Subp_Decl_P_Defining_Names
   
  (Node : Bare_Generic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Defining_Name_Array_Access
   ;


         



 function Generic_Subp_Decl_P_Body_Part
   
  (Node : Bare_Generic_Subp_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Base_Subp_Body
   ;
--  Return the BaseSubpBody corresponding to this node.

         



 function Generic_Subp_Decl_P_Decl
   
  (Node : Bare_Generic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Generic_Subp_Decl_P_Is_Imported
   
  (Node : Bare_Generic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Generic_Subp_Decl_P_Next_Part_For_Decl
   
  (Node : Bare_Generic_Subp_Decl
      ; Imprecise_Fallback : Boolean
         := False
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   ;


         



 function Env_Do_107
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Boolean
   ;


         



 function Initial_Env_108
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Internal_Designated_Env
   ;


         



 function Env_Mappings_109
   
  (Node : Bare_Generic_Subp_Decl
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Env_Assoc_Array_Access
   ;


         



 function Env_Trans_Parent_110
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Boolean
   ;


         



 function Env_Do_111
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Bare_Compilation_Unit_Array_Access
   ;


         



 function Ref_Env_Nodes_112
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_113
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Boolean
   ;


         



 function Ref_Env_Nodes_114
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Bare_Ada_Node_Array_Access
   ;


         



 function Ref_Cond_115
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Boolean
   ;


         



 function Env_Do_116
   
  (Node : Bare_Generic_Subp_Decl
  )

   return Boolean
   ;



   



         procedure Generic_Subp_Decl_Pre_Env_Actions
           (Self            : Bare_Generic_Subp_Decl;
            State           : in out PLE_Node_State;
            Add_To_Env_Only : Boolean := False);

         procedure Generic_Subp_Decl_Post_Env_Actions
           (Self : Bare_Generic_Subp_Decl; State : in out PLE_Node_State);



      

   

      
      procedure Initialize_Fields_For_Generic_Instantiation
        (Self : Bare_Generic_Instantiation
        );


         



 function Generic_Instantiation_F_Instantiation_Env
   
  (Node : Bare_Generic_Instantiation
  )

   return Lexical_Env
   ;


         



 function Generic_Instantiation_P_Instantiation_Bindings
   
  (Node : Bare_Generic_Instantiation
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Inner_Env_Assoc_Array_Access
   ;


         



 function Generic_Instantiation_P_Instantiation_Bindings_Internal
   
  (Node : Bare_Generic_Instantiation
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Inner_Env_Assoc_Array_Access
   ;


         



 function Dispatcher_Generic_Instantiation_P_Generic_Entity_Name
   
  (Node : Bare_Generic_Instantiation
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Name
   with Inline_Always
   ;
--  Return the name of the generic entity designated by this generic
--  instantiation.

         



 function Dispatcher_Generic_Instantiation_P_Generic_Inst_Params
   
  (Node : Bare_Generic_Instantiation
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Assoc_List
   with Inline_Always
   ;
--  Return the parameters of this generic instantiation

         



 function Generic_Instantiation_P_Is_Any_Formal
   
  (Node : Bare_Generic_Instantiation
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Boolean
   ;


         



 function Generic_Instantiation_P_Nonbound_Generic_Decl
   
  (Node : Bare_Generic_Instantiation
  )

   return Internal_Entity_Generic_Decl
   ;
--  Return the formal package designated by the right hand part of this generic
--  package instantiation.

         



 function Dispatcher_Generic_Instantiation_P_Designated_Generic_Decl
   
  (Node : Bare_Generic_Instantiation
   ; E_Info : Internal_Entity_Info :=
      No_Entity_Info
  )

   return Internal_Entity_Basic_Decl
   with Inline_Always
   ;
--  Return the gene