// =================================================================== //
// Copyright (C) 2014-2020 Kimura Ryo                                  //
//                                                                     //
// This Source Code Form is subject to the terms of the Mozilla Public //
// License, v. 2.0. If a copy of the MPL was not distributed with this //
// file, You can obtain one at http://mozilla.org/MPL/2.0/.            //
// =================================================================== //

#include <libbsdf/Common/CieData.h>

using namespace lb;

const int CieData::numWavelengths = 95;
const float CieData::minWavelength = 360.0f;
const float CieData::maxWavelength = 830.0f;

const float CieData::XYZ[] =
{
    0.0001299f, 0.000003917f, 0.0006061f,
    0.0002321f, 0.000006965f, 0.001086f,
    0.0004149f, 0.00001239f, 0.001946f,
    0.0007416f, 0.00002202f, 0.003486f,
    0.001368f, 0.000039f, 0.006450001f,
    0.002236f, 0.000064f, 0.01054999f,
    0.004243f, 0.00012f, 0.02005001f,
    0.00765f, 0.000217f, 0.03621f,
    0.01431f, 0.000396f, 0.06785001f,
    0.02319f, 0.00064f, 0.1102f,
    0.04351f, 0.00121f, 0.2074f,
    0.07763f, 0.00218f, 0.3713f,
    0.13438f, 0.004f, 0.6456f,
    0.21477f, 0.0073f, 1.0390501f,
    0.2839f, 0.0116f, 1.3856f,
    0.3285f, 0.01684f, 1.62296f,
    0.34828f, 0.023f, 1.74706f,
    0.34806f, 0.0298f, 1.7826f,
    0.3362f, 0.038f, 1.77211f,
    0.3187f, 0.048f, 1.7441f,
    0.2908f, 0.06f, 1.6692f,
    0.2511f, 0.0739f, 1.5281f,
    0.19536f, 0.09098f, 1.28764f,
    0.1421f, 0.1126f, 1.0419f,
    0.09564f, 0.13902f, 0.8129501f,
    0.05795001f, 0.1693f, 0.6162f,
    0.03201f, 0.20802f, 0.46518f,
    0.0147f, 0.2586f, 0.3533f,
    0.0049f, 0.323f, 0.272f,
    0.0024f, 0.4073f, 0.2123f,
    0.0093f, 0.503f, 0.1582f,
    0.0291f, 0.6082f, 0.1117f,
    0.06327f, 0.71f, 0.07824999f,
    0.1096f, 0.7932f, 0.05725001f,
    0.1655f, 0.862f, 0.04216f,
    0.2257499f, 0.9148501f, 0.02984f,
    0.2904f, 0.954f, 0.0203f,
    0.3597f, 0.9803f, 0.0134f,
    0.4334499f, 0.9949501f, 0.008749999f,
    0.5120501f, 1.0f, 0.005749999f,
    0.5945f, 0.995f, 0.0039f,
    0.6784f, 0.9786f, 0.002749999f,
    0.7621f, 0.952f, 0.0021f,
    0.8425f, 0.9154f, 0.0018f,
    0.9163f, 0.87f, 0.001650001f,
    0.9786f, 0.8163f, 0.0014f,
    1.0263f, 0.757f, 0.0011f,
    1.0567f, 0.6949f, 0.001f,
    1.0622f, 0.631f, 0.0008f,
    1.0456f, 0.5668f, 0.0006f,
    1.0026f, 0.503f, 0.00034f,
    0.9384f, 0.4412f, 0.00024f,
    0.8544499f, 0.381f, 0.00019f,
    0.7514f, 0.321f, 0.0001f,
    0.6424f, 0.265f, 5E-05f,
    0.5419f, 0.217f, 0.00003f,
    0.4479f, 0.175f, 0.00002f,
    0.3608f, 0.1382f, 0.00001f,
    0.2835f, 0.107f, 0.0f,
    0.2187f, 0.0816f, 0.0f,
    0.1649f, 0.061f, 0.0f,
    0.1212f, 0.04458f, 0.0f,
    0.0874f, 0.032f, 0.0f,
    0.0636f, 0.0232f, 0.0f,
    0.04677f, 0.017f, 0.0f,
    0.0329f, 0.01192f, 0.0f,
    0.0227f, 0.00821f, 0.0f,
    0.01584f, 0.005723f, 0.0f,
    0.01135916f, 0.004102f, 0.0f,
    0.008110916f, 0.002929f, 0.0f,
    0.005790346f, 0.002091f, 0.0f,
    0.004106457f, 0.001484f, 0.0f,
    0.002899327f, 0.001047f, 0.0f,
    0.00204919f, 0.00074f, 0.0f,
    0.001439971f, 0.00052f, 0.0f,
    0.000999949f, 0.0003611f, 0.0f,
    0.000690079f, 0.0002492f, 0.0f,
    0.000476021f, 0.0001719f, 0.0f,
    0.000332301f, 0.00012f, 0.0f,
    0.000234826f, 0.0000848f, 0.0f,
    0.000166151f, 0.00006f, 0.0f,
    0.000117413f, 0.0000424f, 0.0f,
    8.30753E-05f, 0.00003f, 0.0f,
    5.87065E-05f, 0.0000212f, 0.0f,
    4.15099E-05f, 0.00001499f, 0.0f,
    2.93533E-05f, 0.0000106f, 0.0f,
    2.06738E-05f, 7.4657E-06f, 0.0f,
    1.45598E-05f, 5.2578E-06f, 0.0f,
    1.0254E-05f, 3.7029E-06f, 0.0f,
    7.22146E-06f, 2.6078E-06f, 0.0f,
    5.08587E-06f, 1.8366E-06f, 0.0f,
    3.58165E-06f, 1.2934E-06f, 0.0f,
    2.52253E-06f, 9.1093E-07f, 0.0f,
    1.77651E-06f, 6.4153E-07f, 0.0f,
    1.25114E-06f, 4.5181E-07f, 0.0f
};

const float CieData::D65[] =
{
    46.6383f,
    49.3637f,
    52.0891f,
    51.0323f,
    49.9755f,
    52.3118f,
    54.6482f,
    68.7015f,
    82.7549f,
    87.1204f,
    91.486f,
    92.4589f,
    93.4318f,
    90.057f,
    86.6823f,
    95.7736f,
    104.865f,
    110.936f,
    117.008f,
    117.41f,
    117.812f,
    116.336f,
    114.861f,
    115.392f,
    115.923f,
    112.367f,
    108.811f,
    109.082f,
    109.354f,
    108.578f,
    107.802f,
    106.296f,
    104.79f,
    106.239f,
    107.689f,
    106.047f,
    104.405f,
    104.225f,
    104.046f,
    102.023f,
    100.0f,
    98.1671f,
    96.3342f,
    96.0611f,
    95.788f,
    92.2368f,
    88.6856f,
    89.3459f,
    90.0062f,
    89.8026f,
    89.5991f,
    88.6489f,
    87.6987f,
    85.4936f,
    83.2886f,
    83.4939f,
    83.6992f,
    81.863f,
    80.0268f,
    80.1207f,
    80.2146f,
    81.2462f,
    82.2778f,
    80.281f,
    78.2842f,
    74.0027f,
    69.7213f,
    70.6652f,
    71.6091f,
    72.979f,
    74.349f,
    67.9765f,
    61.604f,
    65.7448f,
    69.8856f,
    72.4863f,
    75.087f,
    69.3398f,
    63.5927f,
    55.0054f,
    46.4182f,
    56.6118f,
    66.8054f,
    65.0941f,
    63.3828f,
    63.8434f,
    64.304f,
    61.8779f,
    59.4519f,
    55.7054f,
    51.959f,
    54.6998f,
    57.4406f,
    58.8765f,
    60.3125f
};

const float CieData::XYZ_sRGB[9] =
{
    3.2404542f, -1.5371385f, -0.4985314f,
    -0.9692660f, 1.8760108f, 0.0415560f,
    0.0556434f, -0.2040259f, 1.0572252f
};

const float CieData::sRGB_XYZ[9] =
{
    0.4124564f, 0.3575761f, 0.1804375f,
    0.2126729f, 0.7151522f, 0.0721750f,
    0.0193339f, 0.1191920f, 0.9503041f
};

const float CieData::XYZ_AdobeRGB[9] =
{
    2.0413690f, -0.5649464f, -0.3446944f,
    -0.9692660f, 1.8760108f, 0.0415560f,
    0.0134474f, -0.1183897f, 1.0154096f
};

const float CieData::AdobeRGB_XYZ[9] =
{
    0.5767309f, 0.1855540f, 0.1881852f,
    0.2973769f, 0.6273491f, 0.0752741f,
    0.0270343f, 0.0706872f, 0.9911085f
};
