; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
 ; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>,verify<scalar-evolution>" 2>&1 | FileCheck %s
 ; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>,verify<scalar-evolution>" -scev-range-iter-threshold=1 2>&1 | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64"

; Collection of cases exercising range logic, mostly (but not exclusively)
; involving SCEVUnknowns.

declare void @llvm.assume(i1)

define i32 @ashr(i32 %a) {
; CHECK-LABEL: 'ashr'
; CHECK-NEXT:  Classifying expressions for: @ashr
; CHECK-NEXT:    %ashr = ashr i32 %a, 31
; CHECK-NEXT:    --> %ashr U: [0,1) S: [0,1)
; CHECK-NEXT:  Determining loop execution counts for: @ashr
;
  %ashr = ashr i32 %a, 31
  %pos = icmp sge i32 %a, 0
  call void @llvm.assume(i1 %pos)
  ret i32 %ashr
}

; Highlight the fact that non-argument non-instructions are
; also possible.
@G = external global i8
define i64 @ashr_global() {
; CHECK-LABEL: 'ashr_global'
; CHECK-NEXT:  Classifying expressions for: @ashr_global
; CHECK-NEXT:    %ashr = ashr i64 ptrtoint (ptr @G to i64), 63
; CHECK-NEXT:    --> %ashr U: [0,1) S: [0,1)
; CHECK-NEXT:  Determining loop execution counts for: @ashr_global
;
  %ashr = ashr i64 ptrtoint (ptr @G to i64), 63
  %pos = icmp sge ptr @G, null
  call void @llvm.assume(i1 %pos)
  ret i64 %ashr
}


define i32 @shl(i32 %a) {
; CHECK-LABEL: 'shl'
; CHECK-NEXT:  Classifying expressions for: @shl
; CHECK-NEXT:    %res = shl i32 %a, 2
; CHECK-NEXT:    --> (4 * %a) U: [0,-3) S: [-2147483648,2147483645)
; CHECK-NEXT:  Determining loop execution counts for: @shl
;
  %res = shl i32 %a, 2
  %pos = icmp ult i32 %a, 1024
  call void @llvm.assume(i1 %pos)
  ret i32 %res
}

define i32 @lshr(i32 %a) {
; CHECK-LABEL: 'lshr'
; CHECK-NEXT:  Classifying expressions for: @lshr
; CHECK-NEXT:    %res = lshr i32 %a, 31
; CHECK-NEXT:    --> (%a /u -2147483648) U: [0,2) S: [0,2)
; CHECK-NEXT:  Determining loop execution counts for: @lshr
;
  %res = lshr i32 %a, 31
  %pos = icmp sge i32 %a, 0
  call void @llvm.assume(i1 %pos)
  ret i32 %res
}


define i32 @udiv(i32 %a) {
; CHECK-LABEL: 'udiv'
; CHECK-NEXT:  Classifying expressions for: @udiv
; CHECK-NEXT:    %res = udiv i32 %a, -2147483648
; CHECK-NEXT:    --> (%a /u -2147483648) U: [0,2) S: [0,2)
; CHECK-NEXT:  Determining loop execution counts for: @udiv
;
  %res = udiv i32 %a, 2147483648
  %pos = icmp sge i32 %a, 0
  call void @llvm.assume(i1 %pos)
  ret i32 %res
}

define i64 @sext(i8 %a) {
; CHECK-LABEL: 'sext'
; CHECK-NEXT:  Classifying expressions for: @sext
; CHECK-NEXT:    %res = sext i8 %a to i64
; CHECK-NEXT:    --> (sext i8 %a to i64) U: [-128,128) S: [-128,128)
; CHECK-NEXT:  Determining loop execution counts for: @sext
;
  %res = sext i8 %a to i64
  %pos = icmp sge i8 %a, 0
  call void @llvm.assume(i1 %pos)
  ret i64 %res
}

define i64 @zext(i8 %a) {
; CHECK-LABEL: 'zext'
; CHECK-NEXT:  Classifying expressions for: @zext
; CHECK-NEXT:    %res = zext i8 %a to i64
; CHECK-NEXT:    --> (zext i8 %a to i64) U: [0,256) S: [0,256)
; CHECK-NEXT:  Determining loop execution counts for: @zext
;
  %res = zext i8 %a to i64
  %pos = icmp sge i8 %a, 0
  call void @llvm.assume(i1 %pos)
  ret i64 %res
}

define i32 @phi_div() {
; CHECK-LABEL: 'phi_div'
; CHECK-NEXT:  Classifying expressions for: @phi_div
; CHECK-NEXT:    %range.1 = phi i32 [ 0, %entry ], [ %shr, %loop ]
; CHECK-NEXT:    --> %range.1 U: [0,1) S: [0,1) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %shr = lshr i32 %range.1, 1
; CHECK-NEXT:    --> (%range.1 /u 2) U: [0,1) S: [0,1) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @phi_div
; CHECK-NEXT:  Loop %loop: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %range.1 = phi i32 [ 0, %entry ], [ %shr, %loop ]
  %shr = lshr i32 %range.1, 1
  br label %loop
}

define void @add_6(i32 %n) {
; CHECK-LABEL: 'add_6'
; CHECK-NEXT:  Classifying expressions for: @add_6
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,6}<nuw><nsw><%loop> U: [0,-2147483648) S: [0,2147483647) Exits: (6 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 6) + (1 umin %n))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nsw i32 %iv, 6
; CHECK-NEXT:    --> {6,+,6}<nuw><%loop> U: [6,-3) S: [-2147483648,2147483647) Exits: (6 + (6 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 6) + (1 umin %n)))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @add_6
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 6) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 715827882
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 6) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 6) + (1 umin %n))
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i32 %iv, 6
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}
define void @add_7(i32 %n) {
; CHECK-LABEL: 'add_7'
; CHECK-NEXT:  Classifying expressions for: @add_7
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,7}<nuw><nsw><%loop> U: [0,-2147483648) S: [0,-2147483648) Exits: (7 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 7) + (1 umin %n))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nsw i32 %iv, 7
; CHECK-NEXT:    --> {7,+,7}<nuw><%loop> U: [7,-3) S: [7,0) Exits: (7 + (7 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 7) + (1 umin %n)))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @add_7
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 7) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 613566756
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 7) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 7) + (1 umin %n))
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i32 %iv, 7
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}
define void @add_8(i32 %n) {
; CHECK-LABEL: 'add_8'
; CHECK-NEXT:  Classifying expressions for: @add_8
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,8}<nuw><nsw><%loop> U: [0,-2147483648) S: [0,2147483641) Exits: (8 * ((7 + %n) /u 8))<nuw> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nsw i32 %iv, 8
; CHECK-NEXT:    --> {8,+,8}<nuw><%loop> U: [8,-7) S: [-2147483648,2147483641) Exits: (8 + (8 * ((7 + %n) /u 8))<nuw>) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @add_8
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((7 + %n) /u 8)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 536870911
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((7 + %n) /u 8)
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is ((7 + %n) /u 8)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i32 %iv, 8
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @add_9(i32 %n) {
; CHECK-LABEL: 'add_9'
; CHECK-NEXT:  Classifying expressions for: @add_9
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,9}<nuw><nsw><%loop> U: [0,-2147483648) S: [0,-2147483648) Exits: (9 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nsw i32 %iv, 9
; CHECK-NEXT:    --> {9,+,9}<nuw><%loop> U: [9,-3) S: [9,0) Exits: (9 + (9 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n)))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @add_9
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 477218588
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n))
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i32 %iv, 9
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @add_10(i32 %n) {
; CHECK-LABEL: 'add_10'
; CHECK-NEXT:  Classifying expressions for: @add_10
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,10}<nuw><nsw><%loop> U: [0,-2147483648) S: [0,2147483647) Exits: (10 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 10) + (1 umin %n))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nsw i32 %iv, 10
; CHECK-NEXT:    --> {10,+,10}<nuw><%loop> U: [10,-5) S: [-2147483648,2147483647) Exits: (10 + (10 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 10) + (1 umin %n)))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @add_10
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 10) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 429496729
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 10) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 10) + (1 umin %n))
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i32 %iv, 10
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @add_8_wrap(i32 %n) {
; CHECK-LABEL: 'add_8_wrap'
; CHECK-NEXT:  Classifying expressions for: @add_8_wrap
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,8}<%loop> U: [0,-7) S: [-2147483648,2147483641) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 8
; CHECK-NEXT:    --> {8,+,8}<%loop> U: [0,-7) S: [-2147483648,2147483641) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @add_8_wrap
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 8
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @add_10_wrap(i32 %n) {
; CHECK-LABEL: 'add_10_wrap'
; CHECK-NEXT:  Classifying expressions for: @add_10_wrap
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,10}<%loop> U: [0,-1) S: [-2147483648,2147483647) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add i32 %iv, 10
; CHECK-NEXT:    --> {10,+,10}<%loop> U: [0,-1) S: [-2147483648,2147483647) Exits: <<Unknown>> LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @add_10_wrap
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add i32 %iv, 10
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @mul_6(i32 %n) {
; CHECK-LABEL: 'mul_6'
; CHECK-NEXT:  Classifying expressions for: @mul_6
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> %iv U: [0,-1) S: [-2147483648,2147483645) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.inc = mul nuw i32 %iv, 6
; CHECK-NEXT:    --> (6 * %iv) U: [0,-3) S: [-2147483648,2147483645) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @mul_6
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = mul nuw i32 %iv, 6
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @mul_7(i32 %n) {
; CHECK-LABEL: 'mul_7'
; CHECK-NEXT:  Classifying expressions for: @mul_7
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> %iv U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.inc = mul nuw i32 %iv, 7
; CHECK-NEXT:    --> (7 * %iv) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @mul_7
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = mul nuw i32 %iv, 7
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @mul_8(i32 %n) {
; CHECK-LABEL: 'mul_8'
; CHECK-NEXT:  Classifying expressions for: @mul_8
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> %iv U: [0,-7) S: [-2147483648,2147483585) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.inc = mul nuw i32 %iv, 8
; CHECK-NEXT:    --> (8 * %iv) U: [0,-63) S: [-2147483648,2147483585) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @mul_8
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = mul nuw i32 %iv, 8
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @mul_9(i32 %n) {
; CHECK-LABEL: 'mul_9'
; CHECK-NEXT:  Classifying expressions for: @mul_9
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> %iv U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.inc = mul nuw i32 %iv, 9
; CHECK-NEXT:    --> (9 * %iv) U: full-set S: full-set Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @mul_9
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = mul nuw i32 %iv, 9
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @mul_10(i32 %n) {
; CHECK-LABEL: 'mul_10'
; CHECK-NEXT:  Classifying expressions for: @mul_10
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> %iv U: [0,-1) S: [-2147483648,2147483645) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.inc = mul nuw i32 %iv, 10
; CHECK-NEXT:    --> (10 * %iv) U: [0,-3) S: [-2147483648,2147483645) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @mul_10
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = mul nuw i32 %iv, 10
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @mul_8_wrap(i32 %n) {
; CHECK-LABEL: 'mul_8_wrap'
; CHECK-NEXT:  Classifying expressions for: @mul_8_wrap
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> %iv U: [0,-7) S: [-2147483648,2147483585) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.inc = mul i32 %iv, 8
; CHECK-NEXT:    --> (8 * %iv) U: [0,-63) S: [-2147483648,2147483585) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @mul_8_wrap
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = mul i32 %iv, 8
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @mul_10_wrap(i32 %n) {
; CHECK-LABEL: 'mul_10_wrap'
; CHECK-NEXT:  Classifying expressions for: @mul_10_wrap
; CHECK-NEXT:    %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> %iv U: [0,-1) S: [-2147483648,2147483645) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:    %iv.inc = mul i32 %iv, 10
; CHECK-NEXT:    --> (10 * %iv) U: [0,-3) S: [-2147483648,2147483645) Exits: <<Unknown>> LoopDispositions: { %loop: Variant }
; CHECK-NEXT:  Determining loop execution counts for: @mul_10_wrap
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = mul i32 %iv, 10
  %becond = icmp ult i32 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}

define void @truncate(i16 %n) {
; %t is not a multiple of 7 because we cannot make the assumption through truncation
; CHECK-LABEL: 'truncate'
; CHECK-NEXT:  Classifying expressions for: @truncate
; CHECK-NEXT:    %iv = phi i16 [ 0, %entry ], [ %iv.inc, %loop ]
; CHECK-NEXT:    --> {0,+,9}<nuw><%loop> U: [0,-6) S: [0,-6) Exits: (9 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %iv.inc = add nuw i16 %iv, 9
; CHECK-NEXT:    --> {9,+,9}<nw><%loop> U: [9,3) S: [9,3) Exits: (9 + (9 * ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n)))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:    %t = trunc i16 %iv.inc to i8
; CHECK-NEXT:    --> {9,+,9}<%loop> U: full-set S: full-set Exits: (9 + (9 * (trunc i16 ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n)) to i8))) LoopDispositions: { %loop: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @truncate
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 7281
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n))
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is ((((-1 * (1 umin %n))<nuw><nsw> + %n) /u 9) + (1 umin %n))
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  br label %loop

loop:
  %iv = phi i16 [ 0, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nuw i16 %iv, 9
  %t = trunc i16 %iv.inc to i8
  %becond = icmp ult i16 %iv, %n
  br i1 %becond, label %loop, label %leave

leave:
  ret void
}


