; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-NOFP16
; RUN: llc -mtriple=aarch64 -mattr=+fullfp16 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-FP16
; RUN: llc -mtriple=aarch64 -global-isel=true -global-isel-abort=2 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-NOFP16
; RUN: llc -mtriple=aarch64 -global-isel=true -global-isel-abort=2 -mattr=+fullfp16 %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

; Check that constrained fp intrinsics are correctly lowered.


; Half-precision intrinsics

define half @add_f16(half %x, half %y) #0 {
; CHECK-NOFP16-LABEL: add_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fadd s0, s0, s1
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: add_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fadd h0, h0, h1
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.fadd.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @sub_f16(half %x, half %y) #0 {
; CHECK-NOFP16-LABEL: sub_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fsub s0, s0, s1
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: sub_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fsub h0, h0, h1
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.fsub.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @mul_f16(half %x, half %y) #0 {
; CHECK-NOFP16-LABEL: mul_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fmul s0, s0, s1
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: mul_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fmul h0, h0, h1
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.fmul.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @div_f16(half %x, half %y) #0 {
; CHECK-NOFP16-LABEL: div_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fdiv s0, s0, s1
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: div_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fdiv h0, h0, h1
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.fdiv.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @frem_f16(half %x, half %y) #0 {
; CHECK-LABEL: frem_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl fmodf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.frem.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @fma_f16(half %x, half %y, half %z) #0 {
; CHECK-NOFP16-LABEL: fma_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s2, h2
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fmadd s0, s0, s1, s2
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fma_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fmadd h0, h0, h1, h2
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.fma.f16(half %x, half %y, half %z, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define i32 @fptosi_i32_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: fptosi_i32_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvtzs w0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fptosi_i32_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs w0, h0
; CHECK-FP16-NEXT:    ret
  %val = call i32 @llvm.experimental.constrained.fptosi.i32.f16(half %x, metadata !"fpexcept.strict") #0
  ret i32 %val
}

define i32 @fptoui_i32_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: fptoui_i32_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvtzu w0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fptoui_i32_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu w0, h0
; CHECK-FP16-NEXT:    ret
  %val = call i32 @llvm.experimental.constrained.fptoui.i32.f16(half %x, metadata !"fpexcept.strict") #0
  ret i32 %val
}

define i64 @fptosi_i64_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: fptosi_i64_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvtzs x0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fptosi_i64_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzs x0, h0
; CHECK-FP16-NEXT:    ret
  %val = call i64 @llvm.experimental.constrained.fptosi.i64.f16(half %x, metadata !"fpexcept.strict") #0
  ret i64 %val
}

define i64 @fptoui_i64_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: fptoui_i64_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvtzu x0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fptoui_i64_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtzu x0, h0
; CHECK-FP16-NEXT:    ret
  %val = call i64 @llvm.experimental.constrained.fptoui.i64.f16(half %x, metadata !"fpexcept.strict") #0
  ret i64 %val
}

define half @sitofp_f16_i32(i32 %x) #0 {
; CHECK-NOFP16-LABEL: sitofp_f16_i32:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    scvtf s0, w0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_f16_i32:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    scvtf h0, w0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.sitofp.f16.i32(i32 %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @uitofp_f16_i32(i32 %x) #0 {
; CHECK-NOFP16-LABEL: uitofp_f16_i32:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    ucvtf s0, w0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_f16_i32:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ucvtf h0, w0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.uitofp.f16.i32(i32 %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @sitofp_f16_i64(i64 %x) #0 {
; CHECK-NOFP16-LABEL: sitofp_f16_i64:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    scvtf s0, x0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_f16_i64:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    scvtf h0, x0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.sitofp.f16.i64(i64 %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @uitofp_f16_i64(i64 %x) #0 {
; CHECK-NOFP16-LABEL: uitofp_f16_i64:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    ucvtf s0, x0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_f16_i64:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    ucvtf h0, x0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.uitofp.f16.i64(i64 %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @sitofp_f16_i128(i128 %x) #0 {
; CHECK-NOFP16-LABEL: sitofp_f16_i128:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NOFP16-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NOFP16-NEXT:    .cfi_offset w30, -16
; CHECK-NOFP16-NEXT:    bl __floattisf
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: sitofp_f16_i128:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-FP16-NEXT:    .cfi_def_cfa_offset 16
; CHECK-FP16-NEXT:    .cfi_offset w30, -16
; CHECK-FP16-NEXT:    bl __floattihf
; CHECK-FP16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.sitofp.f16.i128(i128 %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @uitofp_f16_i128(i128 %x) #0 {
; CHECK-NOFP16-LABEL: uitofp_f16_i128:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NOFP16-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NOFP16-NEXT:    .cfi_offset w30, -16
; CHECK-NOFP16-NEXT:    bl __floatuntisf
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: uitofp_f16_i128:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-FP16-NEXT:    .cfi_def_cfa_offset 16
; CHECK-FP16-NEXT:    .cfi_offset w30, -16
; CHECK-FP16-NEXT:    bl __floatuntihf
; CHECK-FP16-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.uitofp.f16.i128(i128 %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @sqrt_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: sqrt_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fsqrt s0, s0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: sqrt_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fsqrt h0, h0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.sqrt.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @powi_f16(half %x, i32 %y) #0 {
; CHECK-LABEL: powi_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl __powisf2
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.powi.f16(half %x, i32 %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @sin_f16(half %x) #0 {
; CHECK-LABEL: sin_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.sin.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @cos_f16(half %x) #0 {
; CHECK-LABEL: cos_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.cos.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @pow_f16(half %x, half %y) #0 {
; CHECK-LABEL: pow_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.pow.f16(half %x, half %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @log_f16(half %x) #0 {
; CHECK-LABEL: log_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.log.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @log10_f16(half %x) #0 {
; CHECK-LABEL: log10_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.log10.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @log2_f16(half %x) #0 {
; CHECK-LABEL: log2_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.log2.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @exp_f16(half %x) #0 {
; CHECK-LABEL: exp_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.exp.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @exp2_f16(half %x) #0 {
; CHECK-LABEL: exp2_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.exp2.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @rint_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: rint_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frintx s0, s0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: rint_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frintx h0, h0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.rint.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define half @nearbyint_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: nearbyint_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frinti s0, s0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: nearbyint_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frinti h0, h0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.nearbyint.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define i32 @lrint_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: lrint_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frintx s0, s0
; CHECK-NOFP16-NEXT:    fcvtzs w0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: lrint_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frintx h0, h0
; CHECK-FP16-NEXT:    fcvtzs w0, h0
; CHECK-FP16-NEXT:    ret
  %val = call i32 @llvm.experimental.constrained.lrint.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret i32 %val
}

define i64 @llrint_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: llrint_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frintx s0, s0
; CHECK-NOFP16-NEXT:    fcvtzs x0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: llrint_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frintx h0, h0
; CHECK-FP16-NEXT:    fcvtzs x0, h0
; CHECK-FP16-NEXT:    ret
  %val = call i64 @llvm.experimental.constrained.llrint.f16(half %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret i64 %val
}

define half @maxnum_f16(half %x, half %y) #0 {
; CHECK-NOFP16-LABEL: maxnum_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fmaxnm s0, s0, s1
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: maxnum_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fmaxnm h0, h0, h1
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.maxnum.f16(half %x, half %y, metadata !"fpexcept.strict") #0
  ret half %val
}

define half @minnum_f16(half %x, half %y) #0 {
; CHECK-NOFP16-LABEL: minnum_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fminnm s0, s0, s1
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: minnum_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fminnm h0, h0, h1
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.minnum.f16(half %x, half %y, metadata !"fpexcept.strict") #0
  ret half %val
}

define half @ceil_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: ceil_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frintp s0, s0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: ceil_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frintp h0, h0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.ceil.f16(half %x, metadata !"fpexcept.strict") #0
  ret half %val
}

define half @floor_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: floor_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frintm s0, s0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: floor_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frintm h0, h0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.floor.f16(half %x, metadata !"fpexcept.strict") #0
  ret half %val
}

define i32 @lround_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: lround_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvtas w0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: lround_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtas w0, h0
; CHECK-FP16-NEXT:    ret
  %val = call i32 @llvm.experimental.constrained.lround.f16(half %x, metadata !"fpexcept.strict") #0
  ret i32 %val
}

define i64 @llround_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: llround_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvtas x0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: llround_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcvtas x0, h0
; CHECK-FP16-NEXT:    ret
  %val = call i64 @llvm.experimental.constrained.llround.f16(half %x, metadata !"fpexcept.strict") #0
  ret i64 %val
}

define half @round_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: round_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frinta s0, s0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: round_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frinta h0, h0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.round.f16(half %x, metadata !"fpexcept.strict") #0
  ret half %val
}

define half @roundeven_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: roundeven_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frintn s0, s0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: roundeven_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frintn h0, h0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.roundeven.f16(half %x, metadata !"fpexcept.strict") #0
  ret half %val
}

define half @trunc_f16(half %x) #0 {
; CHECK-NOFP16-LABEL: trunc_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    frintz s0, s0
; CHECK-NOFP16-NEXT:    fcvt h0, s0
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: trunc_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    frintz h0, h0
; CHECK-FP16-NEXT:    ret
  %val = call half @llvm.experimental.constrained.trunc.f16(half %x, metadata !"fpexcept.strict") #0
  ret half %val
}

define i32 @fcmp_olt_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_olt_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, mi
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_olt_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, mi
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"olt", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_ole_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_ole_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, ls
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_ole_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, ls
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ole", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_ogt_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_ogt_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, gt
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_ogt_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, gt
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ogt", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_oge_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_oge_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, ge
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_oge_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, ge
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"oge", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_oeq_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_oeq_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, eq
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_oeq_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, eq
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"oeq", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_one_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_one_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w8, mi
; CHECK-NOFP16-NEXT:    csinc w0, w8, wzr, le
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_one_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w8, mi
; CHECK-FP16-NEXT:    csinc w0, w8, wzr, le
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"one", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_ult_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_ult_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, lt
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_ult_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, lt
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ult", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_ule_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_ule_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, le
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_ule_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, le
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ule", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_ugt_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_ugt_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, hi
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_ugt_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, hi
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ugt", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_uge_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_uge_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, pl
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_uge_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, pl
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"uge", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_ueq_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_ueq_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w8, eq
; CHECK-NOFP16-NEXT:    csinc w0, w8, wzr, vc
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_ueq_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w8, eq
; CHECK-FP16-NEXT:    csinc w0, w8, wzr, vc
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ueq", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmp_une_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmp_une_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmp s0, s1
; CHECK-NOFP16-NEXT:    cset w0, ne
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmp_une_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmp h0, h1
; CHECK-FP16-NEXT:    cset w0, ne
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"une", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_olt_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_olt_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, mi
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_olt_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, mi
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"olt", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_ole_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_ole_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, ls
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_ole_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, ls
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ole", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_ogt_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_ogt_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, gt
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_ogt_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, gt
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ogt", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_oge_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_oge_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, ge
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_oge_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, ge
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"oge", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_oeq_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_oeq_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, eq
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_oeq_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, eq
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"oeq", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_one_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_one_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w8, mi
; CHECK-NOFP16-NEXT:    csinc w0, w8, wzr, le
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_one_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w8, mi
; CHECK-FP16-NEXT:    csinc w0, w8, wzr, le
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"one", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_ult_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_ult_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, lt
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_ult_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, lt
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ult", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_ule_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_ule_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, le
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_ule_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, le
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ule", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_ugt_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_ugt_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, hi
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_ugt_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, hi
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ugt", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_uge_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_uge_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, pl
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_uge_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, pl
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"uge", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_ueq_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_ueq_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w8, eq
; CHECK-NOFP16-NEXT:    csinc w0, w8, wzr, vc
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_ueq_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w8, eq
; CHECK-FP16-NEXT:    csinc w0, w8, wzr, vc
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ueq", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @fcmps_une_f16(half %a, half %b) #0 {
; CHECK-NOFP16-LABEL: fcmps_une_f16:
; CHECK-NOFP16:       // %bb.0:
; CHECK-NOFP16-NEXT:    fcvt s0, h0
; CHECK-NOFP16-NEXT:    fcvt s1, h1
; CHECK-NOFP16-NEXT:    fcmpe s0, s1
; CHECK-NOFP16-NEXT:    cset w0, ne
; CHECK-NOFP16-NEXT:    ret
;
; CHECK-FP16-LABEL: fcmps_une_f16:
; CHECK-FP16:       // %bb.0:
; CHECK-FP16-NEXT:    fcmpe h0, h1
; CHECK-FP16-NEXT:    cset w0, ne
; CHECK-FP16-NEXT:    ret
  %cmp = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"une", metadata !"fpexcept.strict") #0
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}


; Intrinsics to convert between floating-point types

define half @fptrunc_f16_f32(float %x) #0 {
; CHECK-LABEL: fptrunc_f16_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ret
  %val = call half @llvm.experimental.constrained.fptrunc.f16.f32(float %x, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret half %val
}

define float @fpext_f32_f16(half %x) #0 {
; CHECK-LABEL: fpext_f32_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    ret
  %val = call float @llvm.experimental.constrained.fpext.f32.f16(half %x, metadata !"fpexcept.strict") #0
  ret float %val
}


attributes #0 = { strictfp }

declare half @llvm.experimental.constrained.fadd.f16(half, half, metadata, metadata)
declare half @llvm.experimental.constrained.fsub.f16(half, half, metadata, metadata)
declare half @llvm.experimental.constrained.fmul.f16(half, half, metadata, metadata)
declare half @llvm.experimental.constrained.fdiv.f16(half, half, metadata, metadata)
declare half @llvm.experimental.constrained.frem.f16(half, half, metadata, metadata)
declare half @llvm.experimental.constrained.fma.f16(half, half, half, metadata, metadata)
declare i32 @llvm.experimental.constrained.fptosi.i32.f16(half, metadata)
declare i32 @llvm.experimental.constrained.fptoui.i32.f16(half, metadata)
declare i64 @llvm.experimental.constrained.fptosi.i64.f16(half, metadata)
declare i64 @llvm.experimental.constrained.fptoui.i64.f16(half, metadata)
declare half @llvm.experimental.constrained.sitofp.f16.i32(i32, metadata, metadata)
declare half @llvm.experimental.constrained.uitofp.f16.i32(i32, metadata, metadata)
declare half @llvm.experimental.constrained.sitofp.f16.i64(i64, metadata, metadata)
declare half @llvm.experimental.constrained.uitofp.f16.i64(i64, metadata, metadata)
declare half @llvm.experimental.constrained.sitofp.f16.i128(i128, metadata, metadata)
declare half @llvm.experimental.constrained.uitofp.f16.i128(i128, metadata, metadata)
declare half @llvm.experimental.constrained.sqrt.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.powi.f16(half, i32, metadata, metadata)
declare half @llvm.experimental.constrained.sin.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.cos.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.pow.f16(half, half, metadata, metadata)
declare half @llvm.experimental.constrained.log.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.log10.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.log2.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.exp.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.exp2.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.rint.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.nearbyint.f16(half, metadata, metadata)
declare i32 @llvm.experimental.constrained.lrint.f16(half, metadata, metadata)
declare i64 @llvm.experimental.constrained.llrint.f16(half, metadata, metadata)
declare half @llvm.experimental.constrained.maxnum.f16(half, half, metadata)
declare half @llvm.experimental.constrained.minnum.f16(half, half, metadata)
declare half @llvm.experimental.constrained.ceil.f16(half, metadata)
declare half @llvm.experimental.constrained.floor.f16(half, metadata)
declare i32 @llvm.experimental.constrained.lround.f16(half, metadata)
declare i64 @llvm.experimental.constrained.llround.f16(half, metadata)
declare half @llvm.experimental.constrained.round.f16(half, metadata)
declare half @llvm.experimental.constrained.roundeven.f16(half, metadata)
declare half @llvm.experimental.constrained.trunc.f16(half, metadata)
declare i1 @llvm.experimental.constrained.fcmps.f16(half, half, metadata, metadata)
declare i1 @llvm.experimental.constrained.fcmp.f16(half, half, metadata, metadata)

declare half @llvm.experimental.constrained.fptrunc.f16.f32(float, metadata, metadata)
declare float @llvm.experimental.constrained.fpext.f32.f16(half, metadata)
