; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 2>&1 | FileCheck %s

; Trip counts with trivial exit conditions.

define void @a(i64 %n) nounwind {
; CHECK-LABEL: 'a'
; CHECK-NEXT:  Determining loop execution counts for: @a
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  %t0 = icmp sgt i64 %n, 0
  br i1 %t0, label %loop, label %return

loop:
  %i = phi i64 [ %i.next, %loop ], [ 0, %entry ]
  %i.next = add nsw i64 %i, 1
  %exitcond = icmp eq i64 %i.next, %n
  br i1 false, label %return, label %loop

return:
  ret void
}
define void @b(i64 %n) nounwind {
; CHECK-LABEL: 'b'
; CHECK-NEXT:  Determining loop execution counts for: @b
; CHECK-NEXT:  Loop %loop: backedge-taken count is false
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is false
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is false
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is false
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %t0 = icmp sgt i64 %n, 0
  br i1 %t0, label %loop, label %return

loop:
  %i = phi i64 [ %i.next, %loop ], [ 0, %entry ]
  %i.next = add nsw i64 %i, 1
  %exitcond = icmp eq i64 %i.next, %n
  br i1 true, label %return, label %loop

return:
  ret void
}
define void @c(i64 %n) nounwind {
; CHECK-LABEL: 'c'
; CHECK-NEXT:  Determining loop execution counts for: @c
; CHECK-NEXT:  Loop %loop: backedge-taken count is false
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is false
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is false
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is false
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %t0 = icmp sgt i64 %n, 0
  br i1 %t0, label %loop, label %return

loop:
  %i = phi i64 [ %i.next, %loop ], [ 0, %entry ]
  %i.next = add nsw i64 %i, 1
  %exitcond = icmp eq i64 %i.next, %n
  br i1 false, label %loop, label %return

return:
  ret void
}
define void @d(i64 %n) nounwind {
; CHECK-LABEL: 'd'
; CHECK-NEXT:  Determining loop execution counts for: @d
; CHECK-NEXT:  Loop %loop: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loop: Unpredictable predicated backedge-taken count.
;
entry:
  %t0 = icmp sgt i64 %n, 0
  br i1 %t0, label %loop, label %return

loop:
  %i = phi i64 [ %i.next, %loop ], [ 0, %entry ]
  %i.next = add nsw i64 %i, 1
  %exitcond = icmp eq i64 %i.next, %n
  br i1 true, label %loop, label %return

return:
  ret void
}

; Trip counts for non-polynomial iterations. It's theoretically possible
; to compute a maximum count for these, but short of that, ScalarEvolution
; should return unknown.

; PR7416
declare i1 @g() nounwind

define void @nonpolynomial() {
; CHECK-LABEL: 'nonpolynomial'
; CHECK-NEXT:  Determining loop execution counts for: @nonpolynomial
; CHECK-NEXT:  Loop %loophead: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %loophead: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %loophead: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %loophead: Unpredictable predicated backedge-taken count.
;
entry:
  br label %loophead
loophead:
  %x = phi i32 [0, %entry], [%x.1, %bb1], [%x.2, %bb2]
  %y = icmp slt i32 %x, 100
  br i1 %y, label %loopbody, label %retbb
loopbody:
  %z = call i1 @g()
  br i1 %z, label %bb1, label %bb2
bb1:
  %x.1 = add i32 %x, 2
  br label %loophead
bb2:
  %x.2 = add i32 %x, 3
  br label %loophead
retbb:
  ret void
}

; PHI nodes with all constant operands.

define void @constant_phi_operands() nounwind {
; CHECK-LABEL: 'constant_phi_operands'
; CHECK-NEXT:  Determining loop execution counts for: @constant_phi_operands
; CHECK-NEXT:  Loop %loop: backedge-taken count is 1
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is 1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is 1
; CHECK-NEXT:  Loop %loop: Predicated backedge-taken count is 1
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %loop: Trip multiple is 2
;
entry:
  br label %loop

loop:
  %i = phi i64 [ 1, %loop ], [ 0, %entry ]
  %exitcond = icmp eq i64 %i, 1
  br i1 %exitcond, label %return, label %loop

return:
  ret void
}

; PR16130: Loop exit depends on an 'or' expression.
; One side of the expression test against a value that will be skipped.
; We can't assume undefined behavior just because we have an NSW flag.
;
define void @exit_orcond_nsw(ptr %a) nounwind {
; CHECK-LABEL: 'exit_orcond_nsw'
; CHECK-NEXT:  Determining loop execution counts for: @exit_orcond_nsw
; CHECK-NEXT:  Loop %for.body.i: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %for.body.i: constant max backedge-taken count is 1
; CHECK-NEXT:  Loop %for.body.i: symbolic max backedge-taken count is 1
; CHECK-NEXT:  Loop %for.body.i: Unpredictable predicated backedge-taken count.
;
entry:
  br label %for.body.i

for.body.i:                                       ; preds = %for.body.i, %entry
  %b.01.i = phi i32 [ 0, %entry ], [ %add.i, %for.body.i ]
  %tobool.i = icmp ne i32 %b.01.i, 0
  %add.i = add nsw i32 %b.01.i, 8
  %cmp.i = icmp eq i32 %add.i, 13
  %or.cond = or i1 %tobool.i, %cmp.i
  br i1 %or.cond, label %exit, label %for.body.i

exit:                                     ; preds = %for.body.i
  %b.01.i.lcssa = phi i32 [ %b.01.i, %for.body.i ]
  store i32 %b.01.i.lcssa, ptr %a, align 4
  ret void
}
