; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX10,GFX10-SDAG
; RUN: llc < %s -global-isel=1 -mtriple=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck %s -check-prefixes=GFX10,GFX10-GISEL

declare double @llvm.amdgcn.flat.atomic.fmin.f64.p1.f64(ptr %ptr, double %data)
declare double @llvm.amdgcn.flat.atomic.fmax.f64.p1.f64(ptr %ptr, double %data)

define amdgpu_cs void @flat_atomic_fmin_f64_noret(ptr %ptr, double %data) {
; GFX10-LABEL: flat_atomic_fmin_f64_noret:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    flat_atomic_fmin_x2 v[0:1], v[2:3]
; GFX10-NEXT:    s_endpgm
  %ret = call double @llvm.amdgcn.flat.atomic.fmin.f64.p1.f64(ptr %ptr, double %data)
  ret void
}

define amdgpu_cs void @flat_atomic_fmax_f64_noret(ptr %ptr, double %data) {
; GFX10-LABEL: flat_atomic_fmax_f64_noret:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    flat_atomic_fmax_x2 v[0:1], v[2:3]
; GFX10-NEXT:    s_endpgm
  %ret = call double @llvm.amdgcn.flat.atomic.fmax.f64.p1.f64(ptr %ptr, double %data)
  ret void
}

define amdgpu_cs void @flat_atomic_fmin_f64_rtn(ptr %ptr, double %data, ptr %out) {
; GFX10-LABEL: flat_atomic_fmin_f64_rtn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    flat_atomic_fmin_x2 v[0:1], v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX10-NEXT:    s_endpgm
  %ret = call double @llvm.amdgcn.flat.atomic.fmin.f64.p1.f64(ptr %ptr, double %data)
  store double %ret, ptr %out
  ret void
}

define amdgpu_cs void @flat_atomic_fmax_f64_rtn(ptr %ptr, double %data, ptr %out) {
; GFX10-LABEL: flat_atomic_fmax_f64_rtn:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    flat_atomic_fmax_x2 v[0:1], v[0:1], v[2:3] glc
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; GFX10-NEXT:    s_endpgm
  %ret = call double @llvm.amdgcn.flat.atomic.fmax.f64.p1.f64(ptr %ptr, double %data)
  store double %ret, ptr %out
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX10-GISEL: {{.*}}
; GFX10-SDAG: {{.*}}
