; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs --show-mc-encoding | FileCheck %s

define i8 @add8rr(i8 noundef %a, i8 noundef %b) {
; CHECK-LABEL: add8rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb %sil, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x00,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i8 %a, %b
    ret i8 %add
}

define i16 @add16rr(i16 noundef %a, i16 noundef %b) {
; CHECK-LABEL: add16rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x01,0xf7]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i16 %a, %b
    ret i16 %add
}

define i32 @add32rr(i32 noundef %a, i32 noundef %b) {
; CHECK-LABEL: add32rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %esi, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x01,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i32 %a, %b
    ret i32 %add
}

define i64 @add64rr(i64 noundef %a, i64 noundef %b) {
; CHECK-LABEL: add64rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq %rsi, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x01,0xf7]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i64 %a, %b
    ret i64 %add
}

define i8 @add8rm(i8 noundef %a, ptr %ptr) {
; CHECK-LABEL: add8rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb (%rsi), %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x02,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %b = load i8, ptr %ptr
    %add = add i8 %a, %b
    ret i8 %add
}

define i16 @add16rm(i16 noundef %a, ptr %ptr) {
; CHECK-LABEL: add16rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw (%rsi), %di, %ax # encoding: [0x62,0xf4,0x7d,0x18,0x03,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %b = load i16, ptr %ptr
    %add = add i16 %a, %b
    ret i16 %add
}

define i32 @add32rm(i32 noundef %a, ptr %ptr) {
; CHECK-LABEL: add32rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl (%rsi), %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x03,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %b = load i32, ptr %ptr
    %add = add i32 %a, %b
    ret i32 %add
}

define i64 @add64rm(i64 noundef %a, ptr %ptr) {
; CHECK-LABEL: add64rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq (%rsi), %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x03,0x3e]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %b = load i64, ptr %ptr
    %add = add i64 %a, %b
    ret i64 %add
}

define i16 @add16ri8(i16 noundef %a) {
; CHECK-LABEL: add16ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $123, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xc7,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i16 %a, 123
    ret i16 %add
}

define i32 @add32ri8(i32 noundef %a) {
; CHECK-LABEL: add32ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $123, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xc7,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i32 %a, 123
    ret i32 %add
}

define i64 @add64ri8(i64 noundef %a) {
; CHECK-LABEL: add64ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $123, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0xc7,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i64 %a, 123
    ret i64 %add
}

define i8 @add8ri(i8 noundef %a) {
; CHECK-LABEL: add8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $123, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0xc7,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i8 %a, 123
    ret i8 %add
}

define i16 @add16ri(i16 noundef %a) {
; CHECK-LABEL: add16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $1234, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xc7,0xd2,0x04,0x00,0x00]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i16 %a, 1234
    ret i16 %add
}

define i32 @add32ri(i32 noundef %a) {
; CHECK-LABEL: add32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $123456, %edi, %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0xc7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i32 %a, 123456
    ret i32 %add
}

define i64 @add64ri(i64 noundef %a) {
; CHECK-LABEL: add64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $123456, %rdi, %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0xc7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = add i64 %a, 123456
    ret i64 %add
}

define i8 @add8mr(ptr %a, i8 noundef %b) {
; CHECK-LABEL: add8mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb %sil, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0x00,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %add = add nsw i8 %t, %b
  ret i8 %add
}

define i16 @add16mr(ptr %a, i16 noundef %b) {
; CHECK-LABEL: add16mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw %si, (%rdi), %ax # encoding: [0x62,0xf4,0x7d,0x18,0x01,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %add = add nsw i16 %t, %b
  ret i16 %add
}

define i32 @add32mr(ptr %a, i32 noundef %b) {
; CHECK-LABEL: add32mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %esi, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x01,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %add = add nsw i32 %t, %b
  ret i32 %add
}

define i64 @add64mr(ptr %a, i64 noundef %b) {
; CHECK-LABEL: add64mr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq %rsi, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0x01,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %add = add nsw i64 %t, %b
  ret i64 %add
}

define i16 @add16mi8(ptr %a) {
; CHECK-LABEL: add16mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    addl $123, %eax # EVEX TO LEGACY Compression encoding: [0x83,0xc0,0x7b]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %add = add nsw i16 %t, 123
  ret i16 %add
}

define i32 @add32mi8(ptr %a) {
; CHECK-LABEL: add32mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $123, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0x07,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %add = add nsw i32 %t, 123
  ret i32 %add
}

define i64 @add64mi8(ptr %a) {
; CHECK-LABEL: add64mi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $123, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0x07,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %add = add nsw i64 %t, 123
  ret i64 %add
}

define i8 @add8mi(ptr %a) {
; CHECK-LABEL: add8mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $123, (%rdi), %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0x07,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %add = add nsw i8 %t, 123
  ret i8 %add
}

define i16 @add16mi(ptr %a) {
; CHECK-LABEL: add16mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax # encoding: [0x0f,0xb7,0x07]
; CHECK-NEXT:    addl $1234, %eax # EVEX TO LEGACY Compression encoding: [0x05,0xd2,0x04,0x00,0x00]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %add = add nsw i16 %t, 1234
  ret i16 %add
}

define i32 @add32mi(ptr %a) {
; CHECK-LABEL: add32mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $123456, (%rdi), %eax # encoding: [0x62,0xf4,0x7c,0x18,0x81,0x07,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %add = add nsw i32 %t, 123456
  ret i32 %add
}

define i64 @add64mi(ptr %a) {
; CHECK-LABEL: add64mi:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $123456, (%rdi), %rax # encoding: [0x62,0xf4,0xfc,0x18,0x81,0x07,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %add = add nsw i64 %t, 123456
  ret i64 %add
}

declare i8 @llvm.uadd.sat.i8(i8, i8)
declare i16 @llvm.uadd.sat.i16(i16, i16)
declare i32 @llvm.uadd.sat.i32(i32, i32)
declare i64 @llvm.uadd.sat.i64(i64, i64)

define i8 @addflag8rr(i8 noundef %a, i8 noundef %b) {
; CHECK-LABEL: addflag8rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb %sil, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x00,0xf7]
; CHECK-NEXT:    movzbl %al, %ecx # encoding: [0x0f,0xb6,0xc8]
; CHECK-NEXT:    movl $255, %eax # encoding: [0xb8,0xff,0x00,0x00,0x00]
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i8 @llvm.uadd.sat.i8(i8 %a, i8 %b)
    ret i8 %add
}

define i16 @addflag16rr(i16 noundef %a, i16 noundef %b) {
; CHECK-LABEL: addflag16rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw %si, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x01,0xf7]
; CHECK-NEXT:    movl $65535, %eax # encoding: [0xb8,0xff,0xff,0x00,0x00]
; CHECK-NEXT:    # imm = 0xFFFF
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i16 @llvm.uadd.sat.i16(i16 %a, i16 %b)
    ret i16 %add
}

define i32 @addflag32rr(i32 noundef %a, i32 noundef %b) {
; CHECK-LABEL: addflag32rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %esi, %edi, %ecx # encoding: [0x62,0xf4,0x74,0x18,0x01,0xf7]
; CHECK-NEXT:    movl $-1, %eax # encoding: [0xb8,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i32 @llvm.uadd.sat.i32(i32 %a, i32 %b)
    ret i32 %add
}

define i64 @addflag64rr(i64 noundef %a, i64 noundef %b) {
; CHECK-LABEL: addflag64rr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq %rsi, %rdi, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x01,0xf7]
; CHECK-NEXT:    movq $-1, %rax # encoding: [0x48,0xc7,0xc0,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    cmovaeq %rcx, %rax # encoding: [0x48,0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i64 @llvm.uadd.sat.i64(i64 %a, i64 %b)
    ret i64 %add
}

define i8 @addflag8rm(i8 noundef %a, ptr %b) {
; CHECK-LABEL: addflag8rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb (%rsi), %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x02,0x3e]
; CHECK-NEXT:    movzbl %al, %ecx # encoding: [0x0f,0xb6,0xc8]
; CHECK-NEXT:    movl $255, %eax # encoding: [0xb8,0xff,0x00,0x00,0x00]
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i8, ptr %b
    %add = call i8 @llvm.uadd.sat.i8(i8 %a, i8 %t)
    ret i8 %add
}

define i16 @addflag16rm(i16 noundef %a, ptr %b) {
; CHECK-LABEL: addflag16rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw (%rsi), %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x03,0x3e]
; CHECK-NEXT:    movl $65535, %eax # encoding: [0xb8,0xff,0xff,0x00,0x00]
; CHECK-NEXT:    # imm = 0xFFFF
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i16, ptr %b
    %add = call i16 @llvm.uadd.sat.i16(i16 %a, i16 %t)
    ret i16 %add
}

define i32 @addflag32rm(i32 noundef %a, ptr %b) {
; CHECK-LABEL: addflag32rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl (%rsi), %edi, %ecx # encoding: [0x62,0xf4,0x74,0x18,0x03,0x3e]
; CHECK-NEXT:    movl $-1, %eax # encoding: [0xb8,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i32, ptr %b
    %add = call i32 @llvm.uadd.sat.i32(i32 %a, i32 %t)
    ret i32 %add
}

define i64 @addflag64rm(i64 noundef %a, ptr %b) {
; CHECK-LABEL: addflag64rm:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq (%rsi), %rdi, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x03,0x3e]
; CHECK-NEXT:    movq $-1, %rax # encoding: [0x48,0xc7,0xc0,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    cmovaeq %rcx, %rax # encoding: [0x48,0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %t = load i64, ptr %b
    %add = call i64 @llvm.uadd.sat.i64(i64 %a, i64 %t)
    ret i64 %add
}

define i16 @addflag16ri8(i16 noundef %a) {
; CHECK-LABEL: addflag16ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $123, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x81,0xc7,0x7b,0x00]
; CHECK-NEXT:    movl $65535, %eax # encoding: [0xb8,0xff,0xff,0x00,0x00]
; CHECK-NEXT:    # imm = 0xFFFF
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i16 @llvm.uadd.sat.i16(i16 %a, i16 123)
    ret i16 %add
}

define i32 @addflag32ri8(i32 noundef %a) {
; CHECK-LABEL: addflag32ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $123, %edi, %ecx # encoding: [0x62,0xf4,0x74,0x18,0x81,0xc7,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    movl $-1, %eax # encoding: [0xb8,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i32 @llvm.uadd.sat.i32(i32 %a, i32 123)
    ret i32 %add
}

define i64 @addflag64ri8(i64 noundef %a) {
; CHECK-LABEL: addflag64ri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $123, %rdi, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x81,0xc7,0x7b,0x00,0x00,0x00]
; CHECK-NEXT:    movq $-1, %rax # encoding: [0x48,0xc7,0xc0,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    cmovaeq %rcx, %rax # encoding: [0x48,0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i64 @llvm.uadd.sat.i64(i64 %a, i64 123)
    ret i64 %add
}

define i8 @addflag8ri(i8 noundef %a) {
; CHECK-LABEL: addflag8ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $123, %dil, %al # encoding: [0x62,0xf4,0x7c,0x18,0x80,0xc7,0x7b]
; CHECK-NEXT:    movzbl %al, %ecx # encoding: [0x0f,0xb6,0xc8]
; CHECK-NEXT:    movl $255, %eax # encoding: [0xb8,0xff,0x00,0x00,0x00]
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i8 @llvm.uadd.sat.i8(i8 %a, i8 123)
    ret i8 %add
}

define i16 @addflag16ri(i16 noundef %a) {
; CHECK-LABEL: addflag16ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $1234, %di, %cx # encoding: [0x62,0xf4,0x75,0x18,0x81,0xc7,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    movl $65535, %eax # encoding: [0xb8,0xff,0xff,0x00,0x00]
; CHECK-NEXT:    # imm = 0xFFFF
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i16 @llvm.uadd.sat.i16(i16 %a, i16 1234)
    ret i16 %add
}

define i32 @addflag32ri(i32 noundef %a) {
; CHECK-LABEL: addflag32ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $123456, %edi, %ecx # encoding: [0x62,0xf4,0x74,0x18,0x81,0xc7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    movl $-1, %eax # encoding: [0xb8,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    cmovael %ecx, %eax # encoding: [0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i32 @llvm.uadd.sat.i32(i32 %a, i32 123456)
    ret i32 %add
}

define i64 @addflag64ri(i64 noundef %a) {
; CHECK-LABEL: addflag64ri:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $123456, %rdi, %rcx # encoding: [0x62,0xf4,0xf4,0x18,0x81,0xc7,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    movq $-1, %rax # encoding: [0x48,0xc7,0xc0,0xff,0xff,0xff,0xff]
; CHECK-NEXT:    cmovaeq %rcx, %rax # encoding: [0x48,0x0f,0x43,0xc1]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
    %add = call i64 @llvm.uadd.sat.i64(i64 %a, i64 123456)
    ret i64 %add
}

@val = external dso_local global i16, align 4

define i1 @add64ri_reloc(i16 %k) {
; CHECK-LABEL: add64ri_reloc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    movswq %di, %rax # encoding: [0x48,0x0f,0xbf,0xc7]
; CHECK-NEXT:    addq %rax, %rax # EVEX TO LEGACY Compression encoding: [0x48,0x01,0xc0]
; CHECK-NEXT:    addq $val, %rax # EVEX TO LEGACY Compression encoding: [0x48,0x05,A,A,A,A]
; CHECK-NEXT:    # fixup A - offset: 2, value: val, kind: reloc_signed_4byte
; CHECK-NEXT:    setne %al # encoding: [0x0f,0x95,0xc0]
; CHECK-NEXT:    retq # encoding: [0xc3]
  %g = getelementptr inbounds i16, ptr @val, i16 %k
  %cmp = icmp ne ptr %g, null
  ret i1 %cmp
}

define void @add8mr_legacy(ptr %a, i8 noundef %b) {
; CHECK-LABEL: add8mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb %sil, (%rdi) # encoding: [0x40,0x00,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %add = add i8 %t, %b
  store i8 %add, ptr %a
  ret void
}

define void @add16mr_legacy(ptr %a, i16 noundef %b) {
; CHECK-LABEL: add16mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw %si, (%rdi) # encoding: [0x66,0x01,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %add = add i16 %t, %b
  store i16 %add, ptr %a
  ret void
}

define void @add32mr_legacy(ptr %a, i32 noundef %b) {
; CHECK-LABEL: add32mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl %esi, (%rdi) # encoding: [0x01,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %add = add i32 %t, %b
  store i32 %add, ptr %a
  ret void
}

define void @add64mr_legacy(ptr %a, i64 noundef %b) {
; CHECK-LABEL: add64mr_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq %rsi, (%rdi) # encoding: [0x48,0x01,0x37]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %add = add i64 %t, %b
  store i64 %add, ptr %a
  ret void
}

define void @add8mi_legacy(ptr %a) {
; CHECK-LABEL: add8mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addb $123, (%rdi) # encoding: [0x80,0x07,0x7b]
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i8, ptr %a
  %add = add nsw i8 %t, 123
  store i8 %add, ptr %a
  ret void
}

define void @add16mi_legacy(ptr %a) {
; CHECK-LABEL: add16mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addw $1234, (%rdi) # encoding: [0x66,0x81,0x07,0xd2,0x04]
; CHECK-NEXT:    # imm = 0x4D2
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i16, ptr %a
  %add = add nsw i16 %t, 1234
  store i16 %add, ptr %a
  ret void
}

define void @add32mi_legacy(ptr %a) {
; CHECK-LABEL: add32mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addl $123456, (%rdi) # encoding: [0x81,0x07,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i32, ptr %a
  %add = add nsw i32 %t, 123456
  store i32 %add, ptr %a
  ret void
}

define void @add64mi_legacy(ptr %a) {
; CHECK-LABEL: add64mi_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addq $123456, (%rdi) # encoding: [0x48,0x81,0x07,0x40,0xe2,0x01,0x00]
; CHECK-NEXT:    # imm = 0x1E240
; CHECK-NEXT:    retq # encoding: [0xc3]
entry:
  %t= load i64, ptr %a
  %add = add nsw i64 %t, 123456
  store i64 %add, ptr %a
  ret void
}
