// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1010 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX10 %s
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1010 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefix=GFX10 %s

//===----------------------------------------------------------------------===//
// ENC_MUBUF.
//===----------------------------------------------------------------------===//

buffer_load_format_x v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_x v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_x v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_x v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_x v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_x v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_x v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_x v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_x v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_x v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x00,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xy v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xy v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xy v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xy v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xy v[5:6], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xy v[5:6], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x04,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[253:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyz v[5:7], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xyz v[5:7], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xyz v[5:7], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyz v[5:7], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyz v[5:7], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyz v[5:7], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x08,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[252:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyzw v[5:8], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xyzw v[5:8], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyzw v[5:8], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyzw v[5:8], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x0c,0xe0,0x00,0x05,0x42,0x03]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v255, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_x v1, off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_x v1, off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_x v1, off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_x v1, off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_x v1, off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_x v1, off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_x v1, off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_x v1, off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_x v1, v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x10,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[254:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xy v[1:2], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xy v[1:2], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xy v[1:2], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xy v[1:2], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xy v[1:2], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xy v[1:2], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x14,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[253:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyz v[1:3], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xyz v[1:3], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xyz v[1:3], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyz v[1:3], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyz v[1:3], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyz v[1:3], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x18,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[252:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyzw v[1:4], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xyzw v[1:4], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyzw v[1:4], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyzw v[1:4], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x1c,0xe0,0x00,0x01,0x43,0x04]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ubyte v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ubyte v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ubyte v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ubyte v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_ubyte v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ubyte v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ubyte v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ubyte v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ubyte v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x20,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sbyte v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sbyte v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sbyte v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sbyte v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_sbyte v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sbyte v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sbyte v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sbyte v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sbyte v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x24,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ushort v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ushort v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ushort v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ushort v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_ushort v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ushort v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ushort v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ushort v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ushort v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x28,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sshort v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sshort v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sshort v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sshort v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_sshort v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sshort v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sshort v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sshort v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sshort v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x2c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0xff,0x02,0x03]

buffer_load_dword v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dword v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dword v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dword v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dword v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dword v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dword v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dword v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dword v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x30,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x34,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[253:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx3 v[5:7], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx3 v[5:7], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx3 v[5:7], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx3 v[5:7], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x3c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[252:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx4 v[5:8], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx4 v[5:8], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx4 v[5:8], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx4 v[5:8], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x38,0xe0,0x00,0x05,0x42,0x03]

buffer_store_byte v1, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v255, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0xff,0x03,0x04]

buffer_store_byte v1, off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x04,0x04]

buffer_store_byte v1, off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x18,0x04]

buffer_store_byte v1, off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x65]

buffer_store_byte v1, off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_byte v1, off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x80]

buffer_store_byte v1, off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_byte v1, off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_byte v1, off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_byte v1, v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x43,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x60,0xe0,0x00,0x01,0x43,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v255, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0xff,0x03,0x04]

buffer_store_short v1, off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x04,0x04]

buffer_store_short v1, off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x18,0x04]

buffer_store_short v1, off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x65]

buffer_store_short v1, off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_short v1, off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x80]

buffer_store_short v1, off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_short v1, off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_short v1, off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_short v1, v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x43,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x68,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v255, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0xff,0x03,0x04]

buffer_store_dword v1, off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dword v1, off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dword v1, off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dword v1, off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dword v1, off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dword v1, off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dword v1, off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dword v1, off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dword v1, v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x70,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[254:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx2 v[1:2], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx2 v[1:2], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx2 v[1:2], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx2 v[1:2], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x74,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[253:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx3 v[1:3], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx3 v[1:3], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx3 v[1:3], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx3 v[1:3], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x7c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[252:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx4 v[1:4], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx4 v[1:4], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx4 v[1:4], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx4 v[1:4], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x78,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_swap v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_swap v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_swap v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_swap v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_swap v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_swap v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_swap v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0xfe,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_cmpswap v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_add v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_add v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_add v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_add v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_add v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_add v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_add v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_sub v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_sub v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_sub v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_sub v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_sub v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_sub v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_sub v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_smin v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_smin v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_smin v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_smin v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_smin v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_smin v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_smin v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_umin v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_umin v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_umin v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_umin v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_umin v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_umin v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_umin v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_smax v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_smax v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_smax v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_smax v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_smax v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_smax v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_smax v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_umax v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_umax v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_umax v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_umax v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_umax v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_umax v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_umax v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_and v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_and v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_and v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_and v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_and v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_and v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_and v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_or v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_or v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_or v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_or v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_or v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_or v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_or v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_xor v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_xor v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_xor v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_xor v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_xor v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_xor v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_xor v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_inc v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_inc v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_inc v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_inc v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_inc v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_inc v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_inc v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_dec v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_dec v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_dec v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_dec v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_dec v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_dec v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_dec v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[252:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0xfc,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_add_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_add_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_add_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_add_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_and_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_and_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_and_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_and_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_or_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_or_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_or_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_or_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x42,0x03]

buffer_gl0_inv
// GFX10: encoding: [0x00,0x00,0xc4,0xe1,0x00,0x00,0x00,0x00]

buffer_gl1_inv
// GFX10: encoding: [0x00,0x00,0xc8,0xe1,0x00,0x00,0x00,0x00]
