; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

; TEST 1
define i32 @foo1() {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CHECK-LABEL: define {{[^@]+}}@foo1
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    ret i32 1
;
  ret i32 1
}

declare void @unknown()
define void @foo2() nounwind {
; CHECK: Function Attrs: nounwind
; CHECK-LABEL: define {{[^@]+}}@foo2
; CHECK-SAME: () #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    call void @unknown()
; CHECK-NEXT:    ret void
;
  call void @unknown()
  ret void
}

; TEST 2
define i32 @scc1_foo() {
; TUNIT: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@scc1_foo
; TUNIT-SAME: () #[[ATTR2:[0-9]+]] {
; TUNIT-NEXT:    ret i32 1
;
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@scc1_foo
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:    ret i32 1
;
  %1 = call i32 @scc1_bar()
  ret i32 1
}


; TEST 3
define i32 @scc1_bar() {
; TUNIT: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@scc1_bar
; TUNIT-SAME: () #[[ATTR2]] {
; TUNIT-NEXT:    ret i32 1
;
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@scc1_bar
; CGSCC-SAME: () #[[ATTR0]] {
; CGSCC-NEXT:    ret i32 1
;
  %1 = call i32 @scc1_foo()
  ret i32 1
}

declare i32 @non_nounwind()

; TEST 4
define void @call_non_nounwind(){
; CHECK-LABEL: define {{[^@]+}}@call_non_nounwind() {
; CHECK-NEXT:    [[TMP1:%.*]] = tail call i32 @non_nounwind()
; CHECK-NEXT:    ret void
;
  tail call i32 @non_nounwind()
  ret void
}

; TEST 5 - throw
; int maybe_throw(bool canThrow) {
;   if (canThrow)
;     throw;
;   else
;     return -1;
; }

define i32 @maybe_throw(i1 zeroext %0) {
; CHECK-LABEL: define {{[^@]+}}@maybe_throw
; CHECK-SAME: (i1 noundef zeroext [[TMP0:%.*]]) {
; CHECK-NEXT:    br i1 [[TMP0]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; CHECK:       2:
; CHECK-NEXT:    tail call void @__cxa_rethrow()
; CHECK-NEXT:    unreachable
; CHECK:       3:
; CHECK-NEXT:    ret i32 -1
;
  br i1 %0, label %2, label %3

2:                                                ; preds = %1
  tail call void @__cxa_rethrow() #1
  unreachable

3:                                                ; preds = %1
  ret i32 -1
}

declare void @__cxa_rethrow()

; TEST 6 - catch
; int catch_thing() {
;   try {
;       int a = doThing(true);
;   }
;   catch(...) { return -1; }
;   return 1;
; }

define i32 @catch_thing() personality ptr @__gxx_personality_v0 {
; CHECK-LABEL: define {{[^@]+}}@catch_thing() personality ptr @__gxx_personality_v0 {
; CHECK-NEXT:    invoke void @__cxa_rethrow()
; CHECK-NEXT:    to label [[TMP1:%.*]] unwind label [[TMP2:%.*]]
; CHECK:       1:
; CHECK-NEXT:    unreachable
; CHECK:       2:
; CHECK-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:    catch ptr null
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = tail call ptr @__cxa_begin_catch(ptr [[TMP4]])
; CHECK-NEXT:    tail call void @__cxa_end_catch()
; CHECK-NEXT:    ret i32 -1
;
  invoke void @__cxa_rethrow() #1
  to label %1 unwind label %2

1:                                                ; preds = %0
  unreachable

2:                                                ; preds = %0
  %3 = landingpad { ptr, i32 }
  catch ptr null
  %4 = extractvalue { ptr, i32 } %3, 0
  %5 = tail call ptr @__cxa_begin_catch(ptr %4) #2
  tail call void @__cxa_end_catch()
  ret i32 -1
}

define i32 @catch_thing_user() {
; TUNIT-LABEL: define {{[^@]+}}@catch_thing_user() {
; TUNIT-NEXT:    [[CATCH_THING_CALL:%.*]] = call i32 @catch_thing()
; TUNIT-NEXT:    ret i32 -1
;
; CGSCC-LABEL: define {{[^@]+}}@catch_thing_user() {
; CGSCC-NEXT:    [[CATCH_THING_CALL:%.*]] = call noundef i32 @catch_thing()
; CGSCC-NEXT:    ret i32 [[CATCH_THING_CALL]]
;
  %catch_thing_call = call i32 @catch_thing()
  ret i32 %catch_thing_call
}

define void @two_potential_callees_pos1(i1 %c) {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@two_potential_callees_pos1
; TUNIT-SAME: (i1 [[C:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn
; CGSCC-LABEL: define {{[^@]+}}@two_potential_callees_pos1
; CGSCC-SAME: (i1 [[C:%.*]]) #[[ATTR2:[0-9]+]] {
; CGSCC-NEXT:    [[FP:%.*]] = select i1 [[C]], ptr @foo1, ptr @scc1_foo
; CGSCC-NEXT:    [[TMP1:%.*]] = icmp eq ptr [[FP]], @scc1_foo
; CGSCC-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; CGSCC:       2:
; CGSCC-NEXT:    call void @scc1_foo()
; CGSCC-NEXT:    br label [[TMP6:%.*]]
; CGSCC:       3:
; CGSCC-NEXT:    br i1 true, label [[TMP4:%.*]], label [[TMP5:%.*]]
; CGSCC:       4:
; CGSCC-NEXT:    call void @foo1()
; CGSCC-NEXT:    br label [[TMP6]]
; CGSCC:       5:
; CGSCC-NEXT:    unreachable
; CGSCC:       6:
; CGSCC-NEXT:    ret void
;
  %fp = select i1 %c, ptr @foo1, ptr @scc1_foo
  call void %fp()
  ret void
}
define void @two_potential_callees_pos2(i1 %c) {
; CHECK: Function Attrs: nounwind
; CHECK-LABEL: define {{[^@]+}}@two_potential_callees_pos2
; CHECK-SAME: (i1 [[C:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[FP:%.*]] = select i1 [[C]], ptr @foo2, ptr @scc1_foo
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq ptr [[FP]], @scc1_foo
; CHECK-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; CHECK:       2:
; CHECK-NEXT:    call void @scc1_foo()
; CHECK-NEXT:    br label [[TMP6:%.*]]
; CHECK:       3:
; CHECK-NEXT:    br i1 true, label [[TMP4:%.*]], label [[TMP5:%.*]]
; CHECK:       4:
; CHECK-NEXT:    call void @foo2()
; CHECK-NEXT:    br label [[TMP6]]
; CHECK:       5:
; CHECK-NEXT:    unreachable
; CHECK:       6:
; CHECK-NEXT:    ret void
;
  %fp = select i1 %c, ptr @foo2, ptr @scc1_foo
  call void %fp()
  ret void
}
define void @two_potential_callees_neg(i1 %c) {
; CHECK-LABEL: define {{[^@]+}}@two_potential_callees_neg
; CHECK-SAME: (i1 [[C:%.*]]) {
; CHECK-NEXT:    [[FP:%.*]] = select i1 [[C]], ptr @foo1, ptr @non_nounwind
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq ptr [[FP]], @non_nounwind
; CHECK-NEXT:    br i1 [[TMP1]], label [[TMP2:%.*]], label [[TMP3:%.*]]
; CHECK:       2:
; CHECK-NEXT:    call void @non_nounwind()
; CHECK-NEXT:    br label [[TMP6:%.*]]
; CHECK:       3:
; CHECK-NEXT:    br i1 true, label [[TMP4:%.*]], label [[TMP5:%.*]]
; CHECK:       4:
; CHECK-NEXT:    call void @foo1()
; CHECK-NEXT:    br label [[TMP6]]
; CHECK:       5:
; CHECK-NEXT:    unreachable
; CHECK:       6:
; CHECK-NEXT:    ret void
;
  %fp = select i1 %c, ptr @foo1, ptr @non_nounwind
  call void %fp()
  ret void
}

declare i32 @__gxx_personality_v0(...)

declare ptr @__cxa_begin_catch(ptr)

declare void @__cxa_end_catch()
;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR1]] = { nounwind }
; TUNIT: attributes #[[ATTR2]] = { mustprogress nofree nosync nounwind willreturn memory(none) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR1]] = { nounwind }
; CGSCC: attributes #[[ATTR2]] = { mustprogress nofree nosync nounwind willreturn }
;.
