#include <dicom/dicom.h>
#include "pdicom.h"
#include "dicom-dict-tables.h"

/* This ordering must match the enum in dicom.h.
 *
 * sizeof(value) > 0 -- one or more numeric values of the specified size
 *
 *   enum       name  class                        size capacity  header_length
 */
const struct _DcmVRTable dcm_vr_table[] = {
    {DCM_VR_AE, "AE", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_AE, 2},
    {DCM_VR_AS, "AS", DCM_VR_CLASS_STRING_SINGLE,      0, DCM_CAPACITY_AS, 2},
    {DCM_VR_AT, "AT", DCM_VR_CLASS_NUMERIC_INTEGER,    2, DCM_CAPACITY_AT, 2},
    {DCM_VR_CS, "CS", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_CS, 2},
    {DCM_VR_DA, "DA", DCM_VR_CLASS_STRING_SINGLE,      0, DCM_CAPACITY_DA, 2},
    {DCM_VR_DS, "DS", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_DS, 2},
    {DCM_VR_DT, "DT", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_DT, 2},

    {DCM_VR_FL, "FL", DCM_VR_CLASS_NUMERIC_DECIMAL,    4, 0,               2},
    {DCM_VR_FD, "FD", DCM_VR_CLASS_NUMERIC_DECIMAL,    8, 0,               2},

    {DCM_VR_IS, "IS", DCM_VR_CLASS_STRING_SINGLE,      0, DCM_CAPACITY_IS, 2},
    {DCM_VR_LO, "LO", DCM_VR_CLASS_STRING_SINGLE,      0, DCM_CAPACITY_LO, 2},

    {DCM_VR_LT, "LT", DCM_VR_CLASS_STRING_SINGLE,      0, DCM_CAPACITY_LT, 2},

    {DCM_VR_OB, "OB", DCM_VR_CLASS_BINARY,             1, 0,               4},

    {DCM_VR_OD, "OD", DCM_VR_CLASS_BINARY,             8, 0,               4},
    {DCM_VR_OF, "OF", DCM_VR_CLASS_BINARY,             4, 0,               4},

    {DCM_VR_OW, "OW", DCM_VR_CLASS_BINARY,             2, 0,               4},

    {DCM_VR_PN, "PN", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_PN, 2},
    {DCM_VR_SH, "SH", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_SH, 2},

    {DCM_VR_SL, "SL", DCM_VR_CLASS_NUMERIC_INTEGER,    4, 0,               2},

    {DCM_VR_SQ, "SQ", DCM_VR_CLASS_SEQUENCE,           0, 0,               4},

    {DCM_VR_SS, "SS", DCM_VR_CLASS_NUMERIC_INTEGER,    2, 0,               2},

    {DCM_VR_ST, "ST", DCM_VR_CLASS_STRING_SINGLE,      0, DCM_CAPACITY_ST, 2},

    {DCM_VR_TM, "TM", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_TM, 2},

    {DCM_VR_UI, "UI", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_UI, 2},

    {DCM_VR_UL, "UL", DCM_VR_CLASS_NUMERIC_INTEGER,    4, 0,               2},

    {DCM_VR_UN, "UN", DCM_VR_CLASS_BINARY,             0, 0,               4},

    {DCM_VR_US, "US", DCM_VR_CLASS_NUMERIC_INTEGER,    2, 0,               2},

    {DCM_VR_UT, "UT", DCM_VR_CLASS_STRING_SINGLE,      0, DCM_CAPACITY_UT, 4},
    {DCM_VR_UR, "UR", DCM_VR_CLASS_STRING_SINGLE,      0, DCM_CAPACITY_UR, 4},

    {DCM_VR_UC, "UC", DCM_VR_CLASS_STRING_MULTI,       0, DCM_CAPACITY_UC, 4},

    {DCM_VR_OL, "OL", DCM_VR_CLASS_BINARY,             4, 0,               4},
    {DCM_VR_OV, "OV", DCM_VR_CLASS_BINARY,             8, 0,               4},

    {DCM_VR_SV, "SV", DCM_VR_CLASS_NUMERIC_INTEGER,    8, 0,               4},
    {DCM_VR_UV, "UV", DCM_VR_CLASS_NUMERIC_INTEGER,    8, 0,               4},
};

const int dcm_vr_table_len = sizeof(dcm_vr_table) / sizeof(struct _DcmVRTable);

const struct _DcmAttribute dcm_attribute_table[] = {
    {0X00000000, DCM_VR_TAG_UL, "CommandGroupLength"},
    {0X00000001, DCM_VR_TAG_UL, "CommandLengthToEnd"},
    {0X00000002, DCM_VR_TAG_UI, "AffectedSOPClassUID"},
    {0X00000003, DCM_VR_TAG_UI, "RequestedSOPClassUID"},
    {0X00000010, DCM_VR_TAG_SH, "CommandRecognitionCode"},
    {0X00000100, DCM_VR_TAG_US, "CommandField"},
    {0X00000110, DCM_VR_TAG_US, "MessageID"},
    {0X00000120, DCM_VR_TAG_US, "MessageIDBeingRespondedTo"},
    {0X00000200, DCM_VR_TAG_AE, "Initiator"},
    {0X00000300, DCM_VR_TAG_AE, "Receiver"},
    {0X00000400, DCM_VR_TAG_AE, "FindLocation"},
    {0X00000600, DCM_VR_TAG_AE, "MoveDestination"},
    {0X00000700, DCM_VR_TAG_US, "Priority"},
    {0X00000800, DCM_VR_TAG_US, "CommandDataSetType"},
    {0X00000850, DCM_VR_TAG_US, "NumberOfMatches"},
    {0X00000860, DCM_VR_TAG_US, "ResponseSequenceNumber"},
    {0X00000900, DCM_VR_TAG_US, "Status"},
    {0X00000901, DCM_VR_TAG_AT, "OffendingElement"},
    {0X00000902, DCM_VR_TAG_LO, "ErrorComment"},
    {0X00000903, DCM_VR_TAG_US, "ErrorID"},
    {0X00001000, DCM_VR_TAG_UI, "AffectedSOPInstanceUID"},
    {0X00001001, DCM_VR_TAG_UI, "RequestedSOPInstanceUID"},
    {0X00001002, DCM_VR_TAG_US, "EventTypeID"},
    {0X00001005, DCM_VR_TAG_AT, "AttributeIdentifierList"},
    {0X00001008, DCM_VR_TAG_US, "ActionTypeID"},
    {0X00001020, DCM_VR_TAG_US, "NumberOfRemainingSuboperations"},
    {0X00001021, DCM_VR_TAG_US, "NumberOfCompletedSuboperations"},
    {0X00001022, DCM_VR_TAG_US, "NumberOfFailedSuboperations"},
    {0X00001023, DCM_VR_TAG_US, "NumberOfWarningSuboperations"},
    {0X00001030, DCM_VR_TAG_AE, "MoveOriginatorApplicationEntityTitle"},
    {0X00001031, DCM_VR_TAG_US, "MoveOriginatorMessageID"},
    {0X00004000, DCM_VR_TAG_LT, "DialogReceiver"},
    {0X00004010, DCM_VR_TAG_LT, "TerminalType"},
    {0X00005010, DCM_VR_TAG_SH, "MessageSetID"},
    {0X00005020, DCM_VR_TAG_SH, "EndMessageID"},
    {0X00005110, DCM_VR_TAG_LT, "DisplayFormat"},
    {0X00005120, DCM_VR_TAG_LT, "PagePositionID"},
    {0X00005130, DCM_VR_TAG_CS, "TextFormatID"},
    {0X00005140, DCM_VR_TAG_CS, "NormalReverse"},
    {0X00005150, DCM_VR_TAG_CS, "AddGrayScale"},
    {0X00005160, DCM_VR_TAG_CS, "Borders"},
    {0X00005170, DCM_VR_TAG_IS, "Copies"},
    {0X00005180, DCM_VR_TAG_CS, "CommandMagnificationType"},
    {0X00005190, DCM_VR_TAG_CS, "Erase"},
    {0X000051A0, DCM_VR_TAG_CS, "Print"},
    {0X000051B0, DCM_VR_TAG_US, "Overlays"},
    {0X00020000, DCM_VR_TAG_UL, "FileMetaInformationGroupLength"},
    {0X00020001, DCM_VR_TAG_OB, "FileMetaInformationVersion"},
    {0X00020002, DCM_VR_TAG_UI, "MediaStorageSOPClassUID"},
    {0X00020003, DCM_VR_TAG_UI, "MediaStorageSOPInstanceUID"},
    {0X00020010, DCM_VR_TAG_UI, "TransferSyntaxUID"},
    {0X00020012, DCM_VR_TAG_UI, "ImplementationClassUID"},
    {0X00020013, DCM_VR_TAG_SH, "ImplementationVersionName"},
    {0X00020016, DCM_VR_TAG_AE, "SourceApplicationEntityTitle"},
    {0X00020017, DCM_VR_TAG_AE, "SendingApplicationEntityTitle"},
    {0X00020018, DCM_VR_TAG_AE, "ReceivingApplicationEntityTitle"},
    {0X00020026, DCM_VR_TAG_UR, "SourcePresentationAddress"},
    {0X00020027, DCM_VR_TAG_UR, "SendingPresentationAddress"},
    {0X00020028, DCM_VR_TAG_UR, "ReceivingPresentationAddress"},
    {0X00020031, DCM_VR_TAG_OB, "RTVMetaInformationVersion"},
    {0X00020032, DCM_VR_TAG_UI, "RTVCommunicationSOPClassUID"},
    {0X00020033, DCM_VR_TAG_UI, "RTVCommunicationSOPInstanceUID"},
    {0X00020035, DCM_VR_TAG_OB, "RTVSourceIdentifier"},
    {0X00020036, DCM_VR_TAG_OB, "RTVFlowIdentifier"},
    {0X00020037, DCM_VR_TAG_UL, "RTVFlowRTPSamplingRate"},
    {0X00020038, DCM_VR_TAG_FD, "RTVFlowActualFrameDuration"},
    {0X00020100, DCM_VR_TAG_UI, "PrivateInformationCreatorUID"},
    {0X00020102, DCM_VR_TAG_OB, "PrivateInformation"},
    {0X00041130, DCM_VR_TAG_CS, "FileSetID"},
    {0X00041141, DCM_VR_TAG_CS, "FileSetDescriptorFileID"},
    {0X00041142, DCM_VR_TAG_CS, "SpecificCharacterSetOfFileSetDescriptorFile"},
    {0X00041200, DCM_VR_TAG_UL, "OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity"},
    {0X00041202, DCM_VR_TAG_UL, "OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity"},
    {0X00041212, DCM_VR_TAG_US, "FileSetConsistencyFlag"},
    {0X00041220, DCM_VR_TAG_SQ, "DirectoryRecordSequence"},
    {0X00041400, DCM_VR_TAG_UL, "OffsetOfTheNextDirectoryRecord"},
    {0X00041410, DCM_VR_TAG_US, "RecordInUseFlag"},
    {0X00041420, DCM_VR_TAG_UL, "OffsetOfReferencedLowerLevelDirectoryEntity"},
    {0X00041430, DCM_VR_TAG_CS, "DirectoryRecordType"},
    {0X00041432, DCM_VR_TAG_UI, "PrivateRecordUID"},
    {0X00041500, DCM_VR_TAG_CS, "ReferencedFileID"},
    {0X00041504, DCM_VR_TAG_UL, "MRDRDirectoryRecordOffset"},
    {0X00041510, DCM_VR_TAG_UI, "ReferencedSOPClassUIDInFile"},
    {0X00041511, DCM_VR_TAG_UI, "ReferencedSOPInstanceUIDInFile"},
    {0X00041512, DCM_VR_TAG_UI, "ReferencedTransferSyntaxUIDInFile"},
    {0X0004151A, DCM_VR_TAG_UI, "ReferencedRelatedGeneralSOPClassUIDInFile"},
    {0X00041600, DCM_VR_TAG_UL, "NumberOfReferences"},
    {0X00080000, DCM_VR_TAG_UL, "GenericGroupLength"},
    {0X00080001, DCM_VR_TAG_UL, "LengthToEnd"},
    {0X00080005, DCM_VR_TAG_CS, "SpecificCharacterSet"},
    {0X00080006, DCM_VR_TAG_SQ, "LanguageCodeSequence"},
    {0X00080008, DCM_VR_TAG_CS, "ImageType"},
    {0X00080010, DCM_VR_TAG_SH, "RecognitionCode"},
    {0X00080012, DCM_VR_TAG_DA, "InstanceCreationDate"},
    {0X00080013, DCM_VR_TAG_TM, "InstanceCreationTime"},
    {0X00080014, DCM_VR_TAG_UI, "InstanceCreatorUID"},
    {0X00080015, DCM_VR_TAG_DT, "InstanceCoercionDateTime"},
    {0X00080016, DCM_VR_TAG_UI, "SOPClassUID"},
    {0X00080017, DCM_VR_TAG_UI, "AcquisitionUID"},
    {0X00080018, DCM_VR_TAG_UI, "SOPInstanceUID"},
    {0X00080019, DCM_VR_TAG_UI, "PyramidUID"},
    {0X0008001A, DCM_VR_TAG_UI, "RelatedGeneralSOPClassUID"},
    {0X0008001B, DCM_VR_TAG_UI, "OriginalSpecializedSOPClassUID"},
    {0X00080020, DCM_VR_TAG_DA, "StudyDate"},
    {0X00080021, DCM_VR_TAG_DA, "SeriesDate"},
    {0X00080022, DCM_VR_TAG_DA, "AcquisitionDate"},
    {0X00080023, DCM_VR_TAG_DA, "ContentDate"},
    {0X00080024, DCM_VR_TAG_DA, "OverlayDate"},
    {0X00080025, DCM_VR_TAG_DA, "CurveDate"},
    {0X0008002A, DCM_VR_TAG_DT, "AcquisitionDateTime"},
    {0X00080030, DCM_VR_TAG_TM, "StudyTime"},
    {0X00080031, DCM_VR_TAG_TM, "SeriesTime"},
    {0X00080032, DCM_VR_TAG_TM, "AcquisitionTime"},
    {0X00080033, DCM_VR_TAG_TM, "ContentTime"},
    {0X00080034, DCM_VR_TAG_TM, "OverlayTime"},
    {0X00080035, DCM_VR_TAG_TM, "CurveTime"},
    {0X00080040, DCM_VR_TAG_US, "DataSetType"},
    {0X00080041, DCM_VR_TAG_LO, "DataSetSubtype"},
    {0X00080042, DCM_VR_TAG_CS, "NuclearMedicineSeriesType"},
    {0X00080050, DCM_VR_TAG_SH, "AccessionNumber"},
    {0X00080051, DCM_VR_TAG_SQ, "IssuerOfAccessionNumberSequence"},
    {0X00080052, DCM_VR_TAG_CS, "QueryRetrieveLevel"},
    {0X00080053, DCM_VR_TAG_CS, "QueryRetrieveView"},
    {0X00080054, DCM_VR_TAG_AE, "RetrieveAETitle"},
    {0X00080055, DCM_VR_TAG_AE, "StationAETitle"},
    {0X00080056, DCM_VR_TAG_CS, "InstanceAvailability"},
    {0X00080058, DCM_VR_TAG_UI, "FailedSOPInstanceUIDList"},
    {0X00080060, DCM_VR_TAG_CS, "Modality"},
    {0X00080061, DCM_VR_TAG_CS, "ModalitiesInStudy"},
    {0X00080062, DCM_VR_TAG_UI, "SOPClassesInStudy"},
    {0X00080063, DCM_VR_TAG_SQ, "AnatomicRegionsInStudyCodeSequence"},
    {0X00080064, DCM_VR_TAG_CS, "ConversionType"},
    {0X00080068, DCM_VR_TAG_CS, "PresentationIntentType"},
    {0X00080070, DCM_VR_TAG_LO, "Manufacturer"},
    {0X00080080, DCM_VR_TAG_LO, "InstitutionName"},
    {0X00080081, DCM_VR_TAG_ST, "InstitutionAddress"},
    {0X00080082, DCM_VR_TAG_SQ, "InstitutionCodeSequence"},
    {0X00080090, DCM_VR_TAG_PN, "ReferringPhysicianName"},
    {0X00080092, DCM_VR_TAG_ST, "ReferringPhysicianAddress"},
    {0X00080094, DCM_VR_TAG_SH, "ReferringPhysicianTelephoneNumbers"},
    {0X00080096, DCM_VR_TAG_SQ, "ReferringPhysicianIdentificationSequence"},
    {0X0008009C, DCM_VR_TAG_PN, "ConsultingPhysicianName"},
    {0X0008009D, DCM_VR_TAG_SQ, "ConsultingPhysicianIdentificationSequence"},
    {0X00080100, DCM_VR_TAG_SH, "CodeValue"},
    {0X00080101, DCM_VR_TAG_LO, "ExtendedCodeValue"},
    {0X00080102, DCM_VR_TAG_SH, "CodingSchemeDesignator"},
    {0X00080103, DCM_VR_TAG_SH, "CodingSchemeVersion"},
    {0X00080104, DCM_VR_TAG_LO, "CodeMeaning"},
    {0X00080105, DCM_VR_TAG_CS, "MappingResource"},
    {0X00080106, DCM_VR_TAG_DT, "ContextGroupVersion"},
    {0X00080107, DCM_VR_TAG_DT, "ContextGroupLocalVersion"},
    {0X00080108, DCM_VR_TAG_LT, "ExtendedCodeMeaning"},
    {0X00080109, DCM_VR_TAG_SQ, "CodingSchemeResourcesSequence"},
    {0X0008010A, DCM_VR_TAG_CS, "CodingSchemeURLType"},
    {0X0008010B, DCM_VR_TAG_CS, "ContextGroupExtensionFlag"},
    {0X0008010C, DCM_VR_TAG_UI, "CodingSchemeUID"},
    {0X0008010D, DCM_VR_TAG_UI, "ContextGroupExtensionCreatorUID"},
    {0X0008010E, DCM_VR_TAG_UR, "CodingSchemeURL"},
    {0X0008010F, DCM_VR_TAG_CS, "ContextIdentifier"},
    {0X00080110, DCM_VR_TAG_SQ, "CodingSchemeIdentificationSequence"},
    {0X00080112, DCM_VR_TAG_LO, "CodingSchemeRegistry"},
    {0X00080114, DCM_VR_TAG_ST, "CodingSchemeExternalID"},
    {0X00080115, DCM_VR_TAG_ST, "CodingSchemeName"},
    {0X00080116, DCM_VR_TAG_ST, "CodingSchemeResponsibleOrganization"},
    {0X00080117, DCM_VR_TAG_UI, "ContextUID"},
    {0X00080118, DCM_VR_TAG_UI, "MappingResourceUID"},
    {0X00080119, DCM_VR_TAG_UC, "LongCodeValue"},
    {0X00080120, DCM_VR_TAG_UR, "URNCodeValue"},
    {0X00080121, DCM_VR_TAG_SQ, "EquivalentCodeSequence"},
    {0X00080122, DCM_VR_TAG_LO, "MappingResourceName"},
    {0X00080123, DCM_VR_TAG_SQ, "ContextGroupIdentificationSequence"},
    {0X00080124, DCM_VR_TAG_SQ, "MappingResourceIdentificationSequence"},
    {0X00080201, DCM_VR_TAG_SH, "TimezoneOffsetFromUTC"},
    {0X00080202, DCM_VR_TAG_OB, ""},
    {0X00080220, DCM_VR_TAG_SQ, "ResponsibleGroupCodeSequence"},
    {0X00080221, DCM_VR_TAG_CS, "EquipmentModality"},
    {0X00080222, DCM_VR_TAG_LO, "ManufacturerRelatedModelGroup"},
    {0X00080300, DCM_VR_TAG_SQ, "PrivateDataElementCharacteristicsSequence"},
    {0X00080301, DCM_VR_TAG_US, "PrivateGroupReference"},
    {0X00080302, DCM_VR_TAG_LO, "PrivateCreatorReference"},
    {0X00080303, DCM_VR_TAG_CS, "BlockIdentifyingInformationStatus"},
    {0X00080304, DCM_VR_TAG_US, "NonidentifyingPrivateElements"},
    {0X00080305, DCM_VR_TAG_SQ, "DeidentificationActionSequence"},
    {0X00080306, DCM_VR_TAG_US, "IdentifyingPrivateElements"},
    {0X00080307, DCM_VR_TAG_CS, "DeidentificationAction"},
    {0X00080308, DCM_VR_TAG_US, "PrivateDataElement"},
    {0X00080309, DCM_VR_TAG_UL, "PrivateDataElementValueMultiplicity"},
    {0X0008030A, DCM_VR_TAG_CS, "PrivateDataElementValueRepresentation"},
    {0X0008030B, DCM_VR_TAG_UL, "PrivateDataElementNumberOfItems"},
    {0X0008030C, DCM_VR_TAG_UC, "PrivateDataElementName"},
    {0X0008030D, DCM_VR_TAG_UC, "PrivateDataElementKeyword"},
    {0X0008030E, DCM_VR_TAG_UT, "PrivateDataElementDescription"},
    {0X0008030F, DCM_VR_TAG_UT, "PrivateDataElementEncoding"},
    {0X00080310, DCM_VR_TAG_SQ, "PrivateDataElementDefinitionSequence"},
    {0X00081000, DCM_VR_TAG_AE, "NetworkID"},
    {0X00081010, DCM_VR_TAG_SH, "StationName"},
    {0X00081030, DCM_VR_TAG_LO, "StudyDescription"},
    {0X00081032, DCM_VR_TAG_SQ, "ProcedureCodeSequence"},
    {0X0008103E, DCM_VR_TAG_LO, "SeriesDescription"},
    {0X0008103F, DCM_VR_TAG_SQ, "SeriesDescriptionCodeSequence"},
    {0X00081040, DCM_VR_TAG_LO, "InstitutionalDepartmentName"},
    {0X00081041, DCM_VR_TAG_SQ, "InstitutionalDepartmentTypeCodeSequence"},
    {0X00081048, DCM_VR_TAG_PN, "PhysiciansOfRecord"},
    {0X00081049, DCM_VR_TAG_SQ, "PhysiciansOfRecordIdentificationSequence"},
    {0X00081050, DCM_VR_TAG_PN, "PerformingPhysicianName"},
    {0X00081052, DCM_VR_TAG_SQ, "PerformingPhysicianIdentificationSequence"},
    {0X00081060, DCM_VR_TAG_PN, "NameOfPhysiciansReadingStudy"},
    {0X00081062, DCM_VR_TAG_SQ, "PhysiciansReadingStudyIdentificationSequence"},
    {0X00081070, DCM_VR_TAG_PN, "OperatorsName"},
    {0X00081072, DCM_VR_TAG_SQ, "OperatorIdentificationSequence"},
    {0X00081080, DCM_VR_TAG_LO, "AdmittingDiagnosesDescription"},
    {0X00081084, DCM_VR_TAG_SQ, "AdmittingDiagnosesCodeSequence"},
    {0X00081090, DCM_VR_TAG_LO, "ManufacturerModelName"},
    {0X00081100, DCM_VR_TAG_SQ, "ReferencedResultsSequence"},
    {0X00081110, DCM_VR_TAG_SQ, "ReferencedStudySequence"},
    {0X00081111, DCM_VR_TAG_SQ, "ReferencedPerformedProcedureStepSequence"},
    {0X00081115, DCM_VR_TAG_SQ, "ReferencedSeriesSequence"},
    {0X00081120, DCM_VR_TAG_SQ, "ReferencedPatientSequence"},
    {0X00081125, DCM_VR_TAG_SQ, "ReferencedVisitSequence"},
    {0X00081130, DCM_VR_TAG_SQ, "ReferencedOverlaySequence"},
    {0X00081134, DCM_VR_TAG_SQ, "ReferencedStereometricInstanceSequence"},
    {0X0008113A, DCM_VR_TAG_SQ, "ReferencedWaveformSequence"},
    {0X00081140, DCM_VR_TAG_SQ, "ReferencedImageSequence"},
    {0X00081145, DCM_VR_TAG_SQ, "ReferencedCurveSequence"},
    {0X0008114A, DCM_VR_TAG_SQ, "ReferencedInstanceSequence"},
    {0X0008114B, DCM_VR_TAG_SQ, "ReferencedRealWorldValueMappingInstanceSequence"},
    {0X00081150, DCM_VR_TAG_UI, "ReferencedSOPClassUID"},
    {0X00081155, DCM_VR_TAG_UI, "ReferencedSOPInstanceUID"},
    {0X00081156, DCM_VR_TAG_SQ, "DefinitionSourceSequence"},
    {0X0008115A, DCM_VR_TAG_UI, "SOPClassesSupported"},
    {0X00081160, DCM_VR_TAG_IS, "ReferencedFrameNumber"},
    {0X00081161, DCM_VR_TAG_UL, "SimpleFrameList"},
    {0X00081162, DCM_VR_TAG_UL, "CalculatedFrameList"},
    {0X00081163, DCM_VR_TAG_FD, "TimeRange"},
    {0X00081164, DCM_VR_TAG_SQ, "FrameExtractionSequence"},
    {0X00081167, DCM_VR_TAG_UI, "MultiFrameSourceSOPInstanceUID"},
    {0X00081190, DCM_VR_TAG_UR, "RetrieveURL"},
    {0X00081195, DCM_VR_TAG_UI, "TransactionUID"},
    {0X00081196, DCM_VR_TAG_US, "WarningReason"},
    {0X00081197, DCM_VR_TAG_US, "FailureReason"},
    {0X00081198, DCM_VR_TAG_SQ, "FailedSOPSequence"},
    {0X00081199, DCM_VR_TAG_SQ, "ReferencedSOPSequence"},
    {0X0008119A, DCM_VR_TAG_SQ, "OtherFailuresSequence"},
    {0X00081200, DCM_VR_TAG_SQ, "StudiesContainingOtherReferencedInstancesSequence"},
    {0X00081250, DCM_VR_TAG_SQ, "RelatedSeriesSequence"},
    {0X00082110, DCM_VR_TAG_CS, "LossyImageCompressionRetired"},
    {0X00082111, DCM_VR_TAG_ST, "DerivationDescription"},
    {0X00082112, DCM_VR_TAG_SQ, "SourceImageSequence"},
    {0X00082120, DCM_VR_TAG_SH, "StageName"},
    {0X00082122, DCM_VR_TAG_IS, "StageNumber"},
    {0X00082124, DCM_VR_TAG_IS, "NumberOfStages"},
    {0X00082127, DCM_VR_TAG_SH, "ViewName"},
    {0X00082128, DCM_VR_TAG_IS, "ViewNumber"},
    {0X00082129, DCM_VR_TAG_IS, "NumberOfEventTimers"},
    {0X0008212A, DCM_VR_TAG_IS, "NumberOfViewsInStage"},
    {0X00082130, DCM_VR_TAG_DS, "EventElapsedTimes"},
    {0X00082132, DCM_VR_TAG_LO, "EventTimerNames"},
    {0X00082133, DCM_VR_TAG_SQ, "EventTimerSequence"},
    {0X00082134, DCM_VR_TAG_FD, "EventTimeOffset"},
    {0X00082135, DCM_VR_TAG_SQ, "EventCodeSequence"},
    {0X00082142, DCM_VR_TAG_IS, "StartTrim"},
    {0X00082143, DCM_VR_TAG_IS, "StopTrim"},
    {0X00082144, DCM_VR_TAG_IS, "RecommendedDisplayFrameRate"},
    {0X00082200, DCM_VR_TAG_CS, "TransducerPosition"},
    {0X00082204, DCM_VR_TAG_CS, "TransducerOrientation"},
    {0X00082208, DCM_VR_TAG_CS, "AnatomicStructure"},
    {0X00082218, DCM_VR_TAG_SQ, "AnatomicRegionSequence"},
    {0X00082220, DCM_VR_TAG_SQ, "AnatomicRegionModifierSequence"},
    {0X00082228, DCM_VR_TAG_SQ, "PrimaryAnatomicStructureSequence"},
    {0X00082229, DCM_VR_TAG_SQ, "AnatomicStructureSpaceOrRegionSequence"},
    {0X00082230, DCM_VR_TAG_SQ, "PrimaryAnatomicStructureModifierSequence"},
    {0X00082240, DCM_VR_TAG_SQ, "TransducerPositionSequence"},
    {0X00082242, DCM_VR_TAG_SQ, "TransducerPositionModifierSequence"},
    {0X00082244, DCM_VR_TAG_SQ, "TransducerOrientationSequence"},
    {0X00082246, DCM_VR_TAG_SQ, "TransducerOrientationModifierSequence"},
    {0X00082251, DCM_VR_TAG_SQ, "AnatomicStructureSpaceOrRegionCodeSequenceTrial"},
    {0X00082253, DCM_VR_TAG_SQ, "AnatomicPortalOfEntranceCodeSequenceTrial"},
    {0X00082255, DCM_VR_TAG_SQ, "AnatomicApproachDirectionCodeSequenceTrial"},
    {0X00082256, DCM_VR_TAG_ST, "AnatomicPerspectiveDescriptionTrial"},
    {0X00082257, DCM_VR_TAG_SQ, "AnatomicPerspectiveCodeSequenceTrial"},
    {0X00082258, DCM_VR_TAG_ST, "AnatomicLocationOfExaminingInstrumentDescriptionTrial"},
    {0X00082259, DCM_VR_TAG_SQ, "AnatomicLocationOfExaminingInstrumentCodeSequenceTrial"},
    {0X0008225A, DCM_VR_TAG_SQ, "AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial"},
    {0X0008225C, DCM_VR_TAG_SQ, "OnAxisBackgroundAnatomicStructureCodeSequenceTrial"},
    {0X00083001, DCM_VR_TAG_SQ, "AlternateRepresentationSequence"},
    {0X00083002, DCM_VR_TAG_UI, "AvailableTransferSyntaxUID"},
    {0X00083010, DCM_VR_TAG_UI, "IrradiationEventUID"},
    {0X00083011, DCM_VR_TAG_SQ, "SourceIrradiationEventSequence"},
    {0X00083012, DCM_VR_TAG_UI, "RadiopharmaceuticalAdministrationEventUID"},
    {0X00084000, DCM_VR_TAG_LT, "IdentifyingComments"},
    {0X00089007, DCM_VR_TAG_CS, "FrameType"},
    {0X00089092, DCM_VR_TAG_SQ, "ReferencedImageEvidenceSequence"},
    {0X00089121, DCM_VR_TAG_SQ, "ReferencedRawDataSequence"},
    {0X00089123, DCM_VR_TAG_UI, "CreatorVersionUID"},
    {0X00089124, DCM_VR_TAG_SQ, "DerivationImageSequence"},
    {0X00089154, DCM_VR_TAG_SQ, "SourceImageEvidenceSequence"},
    {0X00089205, DCM_VR_TAG_CS, "PixelPresentation"},
    {0X00089206, DCM_VR_TAG_CS, "VolumetricProperties"},
    {0X00089207, DCM_VR_TAG_CS, "VolumeBasedCalculationTechnique"},
    {0X00089208, DCM_VR_TAG_CS, "ComplexImageComponent"},
    {0X00089209, DCM_VR_TAG_CS, "AcquisitionContrast"},
    {0X00089215, DCM_VR_TAG_SQ, "DerivationCodeSequence"},
    {0X00089237, DCM_VR_TAG_SQ, "ReferencedPresentationStateSequence"},
    {0X00089410, DCM_VR_TAG_SQ, "ReferencedOtherPlaneSequence"},
    {0X00089458, DCM_VR_TAG_SQ, "FrameDisplaySequence"},
    {0X00089459, DCM_VR_TAG_FL, "RecommendedDisplayFrameRateInFloat"},
    {0X00089460, DCM_VR_TAG_CS, "SkipFrameRangeFlag"},
    {0X00090010, DCM_VR_TAG_LO, "PrivateCreator"},
    {0X00100010, DCM_VR_TAG_PN, "PatientName"},
    {0X00100020, DCM_VR_TAG_LO, "PatientID"},
    {0X00100021, DCM_VR_TAG_LO, "IssuerOfPatientID"},
    {0X00100022, DCM_VR_TAG_CS, "TypeOfPatientID"},
    {0X00100024, DCM_VR_TAG_SQ, "IssuerOfPatientIDQualifiersSequence"},
    {0X00100026, DCM_VR_TAG_SQ, "SourcePatientGroupIdentificationSequence"},
    {0X00100027, DCM_VR_TAG_SQ, "GroupOfPatientsIdentificationSequence"},
    {0X00100028, DCM_VR_TAG_US, "SubjectRelativePositionInImage"},
    {0X00100030, DCM_VR_TAG_DA, "PatientBirthDate"},
    {0X00100032, DCM_VR_TAG_TM, "PatientBirthTime"},
    {0X00100033, DCM_VR_TAG_LO, "PatientBirthDateInAlternativeCalendar"},
    {0X00100034, DCM_VR_TAG_LO, "PatientDeathDateInAlternativeCalendar"},
    {0X00100035, DCM_VR_TAG_CS, "PatientAlternativeCalendar"},
    {0X00100040, DCM_VR_TAG_CS, "PatientSex"},
    {0X00100050, DCM_VR_TAG_SQ, "PatientInsurancePlanCodeSequence"},
    {0X00100101, DCM_VR_TAG_SQ, "PatientPrimaryLanguageCodeSequence"},
    {0X00100102, DCM_VR_TAG_SQ, "PatientPrimaryLanguageModifierCodeSequence"},
    {0X00100200, DCM_VR_TAG_CS, "QualityControlSubject"},
    {0X00100201, DCM_VR_TAG_SQ, "QualityControlSubjectTypeCodeSequence"},
    {0X00100212, DCM_VR_TAG_UC, "StrainDescription"},
    {0X00100213, DCM_VR_TAG_LO, "StrainNomenclature"},
    {0X00100214, DCM_VR_TAG_LO, "StrainStockNumber"},
    {0X00100215, DCM_VR_TAG_SQ, "StrainSourceRegistryCodeSequence"},
    {0X00100216, DCM_VR_TAG_SQ, "StrainStockSequence"},
    {0X00100217, DCM_VR_TAG_LO, "StrainSource"},
    {0X00100218, DCM_VR_TAG_UT, "StrainAdditionalInformation"},
    {0X00100219, DCM_VR_TAG_SQ, "StrainCodeSequence"},
    {0X00100221, DCM_VR_TAG_SQ, "GeneticModificationsSequence"},
    {0X00100222, DCM_VR_TAG_UC, "GeneticModificationsDescription"},
    {0X00100223, DCM_VR_TAG_LO, "GeneticModificationsNomenclature"},
    {0X00100229, DCM_VR_TAG_SQ, "GeneticModificationsCodeSequence"},
    {0X00101000, DCM_VR_TAG_LO, "OtherPatientIDs"},
    {0X00101001, DCM_VR_TAG_PN, "OtherPatientNames"},
    {0X00101002, DCM_VR_TAG_SQ, "OtherPatientIDsSequence"},
    {0X00101005, DCM_VR_TAG_PN, "PatientBirthName"},
    {0X00101010, DCM_VR_TAG_AS, "PatientAge"},
    {0X00101020, DCM_VR_TAG_DS, "PatientSize"},
    {0X00101021, DCM_VR_TAG_SQ, "PatientSizeCodeSequence"},
    {0X00101022, DCM_VR_TAG_DS, "PatientBodyMassIndex"},
    {0X00101023, DCM_VR_TAG_DS, "MeasuredAPDimension"},
    {0X00101024, DCM_VR_TAG_DS, "MeasuredLateralDimension"},
    {0X00101030, DCM_VR_TAG_DS, "PatientWeight"},
    {0X00101040, DCM_VR_TAG_LO, "PatientAddress"},
    {0X00101050, DCM_VR_TAG_LO, "InsurancePlanIdentification"},
    {0X00101060, DCM_VR_TAG_PN, "PatientMotherBirthName"},
    {0X00101080, DCM_VR_TAG_LO, "MilitaryRank"},
    {0X00101081, DCM_VR_TAG_LO, "BranchOfService"},
    {0X00101090, DCM_VR_TAG_LO, "MedicalRecordLocator"},
    {0X00101100, DCM_VR_TAG_SQ, "ReferencedPatientPhotoSequence"},
    {0X00102000, DCM_VR_TAG_LO, "MedicalAlerts"},
    {0X00102110, DCM_VR_TAG_LO, "Allergies"},
    {0X00102150, DCM_VR_TAG_LO, "CountryOfResidence"},
    {0X00102152, DCM_VR_TAG_LO, "RegionOfResidence"},
    {0X00102154, DCM_VR_TAG_SH, "PatientTelephoneNumbers"},
    {0X00102155, DCM_VR_TAG_LT, "PatientTelecomInformation"},
    {0X00102160, DCM_VR_TAG_SH, "EthnicGroup"},
    {0X00102180, DCM_VR_TAG_SH, "Occupation"},
    {0X001021A0, DCM_VR_TAG_CS, "SmokingStatus"},
    {0X001021B0, DCM_VR_TAG_LT, "AdditionalPatientHistory"},
    {0X001021C0, DCM_VR_TAG_US, "PregnancyStatus"},
    {0X001021D0, DCM_VR_TAG_DA, "LastMenstrualDate"},
    {0X001021F0, DCM_VR_TAG_LO, "PatientReligiousPreference"},
    {0X00102201, DCM_VR_TAG_LO, "PatientSpeciesDescription"},
    {0X00102202, DCM_VR_TAG_SQ, "PatientSpeciesCodeSequence"},
    {0X00102203, DCM_VR_TAG_CS, "PatientSexNeutered"},
    {0X00102210, DCM_VR_TAG_CS, "AnatomicalOrientationType"},
    {0X00102292, DCM_VR_TAG_LO, "PatientBreedDescription"},
    {0X00102293, DCM_VR_TAG_SQ, "PatientBreedCodeSequence"},
    {0X00102294, DCM_VR_TAG_SQ, "BreedRegistrationSequence"},
    {0X00102295, DCM_VR_TAG_LO, "BreedRegistrationNumber"},
    {0X00102296, DCM_VR_TAG_SQ, "BreedRegistryCodeSequence"},
    {0X00102297, DCM_VR_TAG_PN, "ResponsiblePerson"},
    {0X00102298, DCM_VR_TAG_CS, "ResponsiblePersonRole"},
    {0X00102299, DCM_VR_TAG_LO, "ResponsibleOrganization"},
    {0X00104000, DCM_VR_TAG_LT, "PatientComments"},
    {0X00109431, DCM_VR_TAG_FL, "ExaminedBodyThickness"},
    {0X00120010, DCM_VR_TAG_LO, "ClinicalTrialSponsorName"},
    {0X00120020, DCM_VR_TAG_LO, "ClinicalTrialProtocolID"},
    {0X00120021, DCM_VR_TAG_LO, "ClinicalTrialProtocolName"},
    {0X00120030, DCM_VR_TAG_LO, "ClinicalTrialSiteID"},
    {0X00120031, DCM_VR_TAG_LO, "ClinicalTrialSiteName"},
    {0X00120040, DCM_VR_TAG_LO, "ClinicalTrialSubjectID"},
    {0X00120042, DCM_VR_TAG_LO, "ClinicalTrialSubjectReadingID"},
    {0X00120050, DCM_VR_TAG_LO, "ClinicalTrialTimePointID"},
    {0X00120051, DCM_VR_TAG_ST, "ClinicalTrialTimePointDescription"},
    {0X00120052, DCM_VR_TAG_FD, "LongitudinalTemporalOffsetFromEvent"},
    {0X00120053, DCM_VR_TAG_CS, "LongitudinalTemporalEventType"},
    {0X00120060, DCM_VR_TAG_LO, "ClinicalTrialCoordinatingCenterName"},
    {0X00120062, DCM_VR_TAG_CS, "PatientIdentityRemoved"},
    {0X00120063, DCM_VR_TAG_LO, "DeidentificationMethod"},
    {0X00120064, DCM_VR_TAG_SQ, "DeidentificationMethodCodeSequence"},
    {0X00120071, DCM_VR_TAG_LO, "ClinicalTrialSeriesID"},
    {0X00120072, DCM_VR_TAG_LO, "ClinicalTrialSeriesDescription"},
    {0X00120081, DCM_VR_TAG_LO, "ClinicalTrialProtocolEthicsCommitteeName"},
    {0X00120082, DCM_VR_TAG_LO, "ClinicalTrialProtocolEthicsCommitteeApprovalNumber"},
    {0X00120083, DCM_VR_TAG_SQ, "ConsentForClinicalTrialUseSequence"},
    {0X00120084, DCM_VR_TAG_CS, "DistributionType"},
    {0X00120085, DCM_VR_TAG_CS, "ConsentForDistributionFlag"},
    {0X00120086, DCM_VR_TAG_DA, "EthicsCommitteeApprovalEffectivenessStartDate"},
    {0X00120087, DCM_VR_TAG_DA, "EthicsCommitteeApprovalEffectivenessEndDate"},
    {0X00140023, DCM_VR_TAG_ST, "CADFileFormat"},
    {0X00140024, DCM_VR_TAG_ST, "ComponentReferenceSystem"},
    {0X00140025, DCM_VR_TAG_ST, "ComponentManufacturingProcedure"},
    {0X00140028, DCM_VR_TAG_ST, "ComponentManufacturer"},
    {0X00140030, DCM_VR_TAG_DS, "MaterialThickness"},
    {0X00140032, DCM_VR_TAG_DS, "MaterialPipeDiameter"},
    {0X00140034, DCM_VR_TAG_DS, "MaterialIsolationDiameter"},
    {0X00140042, DCM_VR_TAG_ST, "MaterialGrade"},
    {0X00140044, DCM_VR_TAG_ST, "MaterialPropertiesDescription"},
    {0X00140045, DCM_VR_TAG_ST, "MaterialPropertiesFileFormatRetired"},
    {0X00140046, DCM_VR_TAG_LT, "MaterialNotes"},
    {0X00140050, DCM_VR_TAG_CS, "ComponentShape"},
    {0X00140052, DCM_VR_TAG_CS, "CurvatureType"},
    {0X00140054, DCM_VR_TAG_DS, "OuterDiameter"},
    {0X00140056, DCM_VR_TAG_DS, "InnerDiameter"},
    {0X00140100, DCM_VR_TAG_LO, "ComponentWelderIDs"},
    {0X00140101, DCM_VR_TAG_CS, "SecondaryApprovalStatus"},
    {0X00140102, DCM_VR_TAG_DA, "SecondaryReviewDate"},
    {0X00140103, DCM_VR_TAG_TM, "SecondaryReviewTime"},
    {0X00140104, DCM_VR_TAG_PN, "SecondaryReviewerName"},
    {0X00140105, DCM_VR_TAG_ST, "RepairID"},
    {0X00140106, DCM_VR_TAG_SQ, "MultipleComponentApprovalSequence"},
    {0X00140107, DCM_VR_TAG_CS, "OtherApprovalStatus"},
    {0X00140108, DCM_VR_TAG_CS, "OtherSecondaryApprovalStatus"},
    {0X00141010, DCM_VR_TAG_ST, "ActualEnvironmentalConditions"},
    {0X00141020, DCM_VR_TAG_DA, "ExpiryDate"},
    {0X00141040, DCM_VR_TAG_ST, "EnvironmentalConditions"},
    {0X00142002, DCM_VR_TAG_SQ, "EvaluatorSequence"},
    {0X00142004, DCM_VR_TAG_IS, "EvaluatorNumber"},
    {0X00142006, DCM_VR_TAG_PN, "EvaluatorName"},
    {0X00142008, DCM_VR_TAG_IS, "EvaluationAttempt"},
    {0X00142012, DCM_VR_TAG_SQ, "IndicationSequence"},
    {0X00142014, DCM_VR_TAG_IS, "IndicationNumber"},
    {0X00142016, DCM_VR_TAG_SH, "IndicationLabel"},
    {0X00142018, DCM_VR_TAG_ST, "IndicationDescription"},
    {0X0014201A, DCM_VR_TAG_CS, "IndicationType"},
    {0X0014201C, DCM_VR_TAG_CS, "IndicationDisposition"},
    {0X0014201E, DCM_VR_TAG_SQ, "IndicationROISequence"},
    {0X00142030, DCM_VR_TAG_SQ, "IndicationPhysicalPropertySequence"},
    {0X00142032, DCM_VR_TAG_SH, "PropertyLabel"},
    {0X00142202, DCM_VR_TAG_IS, "CoordinateSystemNumberOfAxes"},
    {0X00142204, DCM_VR_TAG_SQ, "CoordinateSystemAxesSequence"},
    {0X00142206, DCM_VR_TAG_ST, "CoordinateSystemAxisDescription"},
    {0X00142208, DCM_VR_TAG_CS, "CoordinateSystemDataSetMapping"},
    {0X0014220A, DCM_VR_TAG_IS, "CoordinateSystemAxisNumber"},
    {0X0014220C, DCM_VR_TAG_CS, "CoordinateSystemAxisType"},
    {0X0014220E, DCM_VR_TAG_CS, "CoordinateSystemAxisUnits"},
    {0X00142210, DCM_VR_TAG_OB, "CoordinateSystemAxisValues"},
    {0X00142220, DCM_VR_TAG_SQ, "CoordinateSystemTransformSequence"},
    {0X00142222, DCM_VR_TAG_ST, "TransformDescription"},
    {0X00142224, DCM_VR_TAG_IS, "TransformNumberOfAxes"},
    {0X00142226, DCM_VR_TAG_IS, "TransformOrderOfAxes"},
    {0X00142228, DCM_VR_TAG_CS, "TransformedAxisUnits"},
    {0X0014222A, DCM_VR_TAG_DS, "CoordinateSystemTransformRotationAndScaleMatrix"},
    {0X0014222C, DCM_VR_TAG_DS, "CoordinateSystemTransformTranslationMatrix"},
    {0X00143011, DCM_VR_TAG_DS, "InternalDetectorFrameTime"},
    {0X00143012, DCM_VR_TAG_DS, "NumberOfFramesIntegrated"},
    {0X00143020, DCM_VR_TAG_SQ, "DetectorTemperatureSequence"},
    {0X00143022, DCM_VR_TAG_ST, "SensorName"},
    {0X00143024, DCM_VR_TAG_DS, "HorizontalOffsetOfSensor"},
    {0X00143026, DCM_VR_TAG_DS, "VerticalOffsetOfSensor"},
    {0X00143028, DCM_VR_TAG_DS, "SensorTemperature"},
    {0X00143040, DCM_VR_TAG_SQ, "DarkCurrentSequence"},
    {0X00143050, DCM_VR_TAG_OB_OW, "DarkCurrentCounts"},
    {0X00143060, DCM_VR_TAG_SQ, "GainCorrectionReferenceSequence"},
    {0X00143070, DCM_VR_TAG_OB_OW, "AirCounts"},
    {0X00143071, DCM_VR_TAG_DS, "KVUsedInGainCalibration"},
    {0X00143072, DCM_VR_TAG_DS, "MAUsedInGainCalibration"},
    {0X00143073, DCM_VR_TAG_DS, "NumberOfFramesUsedForIntegration"},
    {0X00143074, DCM_VR_TAG_LO, "FilterMaterialUsedInGainCalibration"},
    {0X00143075, DCM_VR_TAG_DS, "FilterThicknessUsedInGainCalibration"},
    {0X00143076, DCM_VR_TAG_DA, "DateOfGainCalibration"},
    {0X00143077, DCM_VR_TAG_TM, "TimeOfGainCalibration"},
    {0X00143080, DCM_VR_TAG_OB, "BadPixelImage"},
    {0X00143099, DCM_VR_TAG_LT, "CalibrationNotes"},
    {0X00143100, DCM_VR_TAG_LT, "LinearityCorrectionTechnique"},
    {0X00143101, DCM_VR_TAG_LT, "BeamHardeningCorrectionTechnique"},
    {0X00144002, DCM_VR_TAG_SQ, "PulserEquipmentSequence"},
    {0X00144004, DCM_VR_TAG_CS, "PulserType"},
    {0X00144006, DCM_VR_TAG_LT, "PulserNotes"},
    {0X00144008, DCM_VR_TAG_SQ, "ReceiverEquipmentSequence"},
    {0X0014400A, DCM_VR_TAG_CS, "AmplifierType"},
    {0X0014400C, DCM_VR_TAG_LT, "ReceiverNotes"},
    {0X0014400E, DCM_VR_TAG_SQ, "PreAmplifierEquipmentSequence"},
    {0X0014400F, DCM_VR_TAG_LT, "PreAmplifierNotes"},
    {0X00144010, DCM_VR_TAG_SQ, "TransmitTransducerSequence"},
    {0X00144011, DCM_VR_TAG_SQ, "ReceiveTransducerSequence"},
    {0X00144012, DCM_VR_TAG_US, "NumberOfElements"},
    {0X00144013, DCM_VR_TAG_CS, "ElementShape"},
    {0X00144014, DCM_VR_TAG_DS, "ElementDimensionA"},
    {0X00144015, DCM_VR_TAG_DS, "ElementDimensionB"},
    {0X00144016, DCM_VR_TAG_DS, "ElementPitchA"},
    {0X00144017, DCM_VR_TAG_DS, "MeasuredBeamDimensionA"},
    {0X00144018, DCM_VR_TAG_DS, "MeasuredBeamDimensionB"},
    {0X00144019, DCM_VR_TAG_DS, "LocationOfMeasuredBeamDiameter"},
    {0X0014401A, DCM_VR_TAG_DS, "NominalFrequency"},
    {0X0014401B, DCM_VR_TAG_DS, "MeasuredCenterFrequency"},
    {0X0014401C, DCM_VR_TAG_DS, "MeasuredBandwidth"},
    {0X0014401D, DCM_VR_TAG_DS, "ElementPitchB"},
    {0X00144020, DCM_VR_TAG_SQ, "PulserSettingsSequence"},
    {0X00144022, DCM_VR_TAG_DS, "PulseWidth"},
    {0X00144024, DCM_VR_TAG_DS, "ExcitationFrequency"},
    {0X00144026, DCM_VR_TAG_CS, "ModulationType"},
    {0X00144028, DCM_VR_TAG_DS, "Damping"},
    {0X00144030, DCM_VR_TAG_SQ, "ReceiverSettingsSequence"},
    {0X00144031, DCM_VR_TAG_DS, "AcquiredSoundpathLength"},
    {0X00144032, DCM_VR_TAG_CS, "AcquisitionCompressionType"},
    {0X00144033, DCM_VR_TAG_IS, "AcquisitionSampleSize"},
    {0X00144034, DCM_VR_TAG_DS, "RectifierSmoothing"},
    {0X00144035, DCM_VR_TAG_SQ, "DACSequence"},
    {0X00144036, DCM_VR_TAG_CS, "DACType"},
    {0X00144038, DCM_VR_TAG_DS, "DACGainPoints"},
    {0X0014403A, DCM_VR_TAG_DS, "DACTimePoints"},
    {0X0014403C, DCM_VR_TAG_DS, "DACAmplitude"},
    {0X00144040, DCM_VR_TAG_SQ, "PreAmplifierSettingsSequence"},
    {0X00144050, DCM_VR_TAG_SQ, "TransmitTransducerSettingsSequence"},
    {0X00144051, DCM_VR_TAG_SQ, "ReceiveTransducerSettingsSequence"},
    {0X00144052, DCM_VR_TAG_DS, "IncidentAngle"},
    {0X00144054, DCM_VR_TAG_ST, "CouplingTechnique"},
    {0X00144056, DCM_VR_TAG_ST, "CouplingMedium"},
    {0X00144057, DCM_VR_TAG_DS, "CouplingVelocity"},
    {0X00144058, DCM_VR_TAG_DS, "ProbeCenterLocationX"},
    {0X00144059, DCM_VR_TAG_DS, "ProbeCenterLocationZ"},
    {0X0014405A, DCM_VR_TAG_DS, "SoundPathLength"},
    {0X0014405C, DCM_VR_TAG_ST, "DelayLawIdentifier"},
    {0X00144060, DCM_VR_TAG_SQ, "GateSettingsSequence"},
    {0X00144062, DCM_VR_TAG_DS, "GateThreshold"},
    {0X00144064, DCM_VR_TAG_DS, "VelocityOfSound"},
    {0X00144070, DCM_VR_TAG_SQ, "CalibrationSettingsSequence"},
    {0X00144072, DCM_VR_TAG_ST, "CalibrationProcedure"},
    {0X00144074, DCM_VR_TAG_SH, "ProcedureVersion"},
    {0X00144076, DCM_VR_TAG_DA, "ProcedureCreationDate"},
    {0X00144078, DCM_VR_TAG_DA, "ProcedureExpirationDate"},
    {0X0014407A, DCM_VR_TAG_DA, "ProcedureLastModifiedDate"},
    {0X0014407C, DCM_VR_TAG_TM, "CalibrationTime"},
    {0X0014407E, DCM_VR_TAG_DA, "CalibrationDate"},
    {0X00144080, DCM_VR_TAG_SQ, "ProbeDriveEquipmentSequence"},
    {0X00144081, DCM_VR_TAG_CS, "DriveType"},
    {0X00144082, DCM_VR_TAG_LT, "ProbeDriveNotes"},
    {0X00144083, DCM_VR_TAG_SQ, "DriveProbeSequence"},
    {0X00144084, DCM_VR_TAG_DS, "ProbeInductance"},
    {0X00144085, DCM_VR_TAG_DS, "ProbeResistance"},
    {0X00144086, DCM_VR_TAG_SQ, "ReceiveProbeSequence"},
    {0X00144087, DCM_VR_TAG_SQ, "ProbeDriveSettingsSequence"},
    {0X00144088, DCM_VR_TAG_DS, "BridgeResistors"},
    {0X00144089, DCM_VR_TAG_DS, "ProbeOrientationAngle"},
    {0X0014408B, DCM_VR_TAG_DS, "UserSelectedGainY"},
    {0X0014408C, DCM_VR_TAG_DS, "UserSelectedPhase"},
    {0X0014408D, DCM_VR_TAG_DS, "UserSelectedOffsetX"},
    {0X0014408E, DCM_VR_TAG_DS, "UserSelectedOffsetY"},
    {0X00144091, DCM_VR_TAG_SQ, "ChannelSettingsSequence"},
    {0X00144092, DCM_VR_TAG_DS, "ChannelThreshold"},
    {0X0014409A, DCM_VR_TAG_SQ, "ScannerSettingsSequence"},
    {0X0014409B, DCM_VR_TAG_ST, "ScanProcedure"},
    {0X0014409C, DCM_VR_TAG_DS, "TranslationRateX"},
    {0X0014409D, DCM_VR_TAG_DS, "TranslationRateY"},
    {0X0014409F, DCM_VR_TAG_DS, "ChannelOverlap"},
    {0X001440A0, DCM_VR_TAG_LO, "ImageQualityIndicatorType"},
    {0X001440A1, DCM_VR_TAG_LO, "ImageQualityIndicatorMaterial"},
    {0X001440A2, DCM_VR_TAG_LO, "ImageQualityIndicatorSize"},
    {0X00145002, DCM_VR_TAG_IS, "LINACEnergy"},
    {0X00145004, DCM_VR_TAG_IS, "LINACOutput"},
    {0X00145100, DCM_VR_TAG_US, "ActiveAperture"},
    {0X00145101, DCM_VR_TAG_DS, "TotalAperture"},
    {0X00145102, DCM_VR_TAG_DS, "ApertureElevation"},
    {0X00145103, DCM_VR_TAG_DS, "MainLobeAngle"},
    {0X00145104, DCM_VR_TAG_DS, "MainRoofAngle"},
    {0X00145105, DCM_VR_TAG_CS, "ConnectorType"},
    {0X00145106, DCM_VR_TAG_SH, "WedgeModelNumber"},
    {0X00145107, DCM_VR_TAG_DS, "WedgeAngleFloat"},
    {0X00145108, DCM_VR_TAG_DS, "WedgeRoofAngle"},
    {0X00145109, DCM_VR_TAG_CS, "WedgeElement1Position"},
    {0X0014510A, DCM_VR_TAG_DS, "WedgeMaterialVelocity"},
    {0X0014510B, DCM_VR_TAG_SH, "WedgeMaterial"},
    {0X0014510C, DCM_VR_TAG_DS, "WedgeOffsetZ"},
    {0X0014510D, DCM_VR_TAG_DS, "WedgeOriginOffsetX"},
    {0X0014510E, DCM_VR_TAG_DS, "WedgeTimeDelay"},
    {0X0014510F, DCM_VR_TAG_SH, "WedgeName"},
    {0X00145110, DCM_VR_TAG_SH, "WedgeManufacturerName"},
    {0X00145111, DCM_VR_TAG_LO, "WedgeDescription"},
    {0X00145112, DCM_VR_TAG_DS, "NominalBeamAngle"},
    {0X00145113, DCM_VR_TAG_DS, "WedgeOffsetX"},
    {0X00145114, DCM_VR_TAG_DS, "WedgeOffsetY"},
    {0X00145115, DCM_VR_TAG_DS, "WedgeTotalLength"},
    {0X00145116, DCM_VR_TAG_DS, "WedgeInContactLength"},
    {0X00145117, DCM_VR_TAG_DS, "WedgeFrontGap"},
    {0X00145118, DCM_VR_TAG_DS, "WedgeTotalHeight"},
    {0X00145119, DCM_VR_TAG_DS, "WedgeFrontHeight"},
    {0X0014511A, DCM_VR_TAG_DS, "WedgeRearHeight"},
    {0X0014511B, DCM_VR_TAG_DS, "WedgeTotalWidth"},
    {0X0014511C, DCM_VR_TAG_DS, "WedgeInContactWidth"},
    {0X0014511D, DCM_VR_TAG_DS, "WedgeChamferHeight"},
    {0X0014511E, DCM_VR_TAG_CS, "WedgeCurve"},
    {0X0014511F, DCM_VR_TAG_DS, "RadiusAlongWedge"},
    {0X00160001, DCM_VR_TAG_DS, "WhitePoint"},
    {0X00160002, DCM_VR_TAG_DS, "PrimaryChromaticities"},
    {0X00160003, DCM_VR_TAG_UT, "BatteryLevel"},
    {0X00160004, DCM_VR_TAG_DS, "ExposureTimeInSeconds"},
    {0X00160005, DCM_VR_TAG_DS, "FNumber"},
    {0X00160006, DCM_VR_TAG_IS, "OECFRows"},
    {0X00160007, DCM_VR_TAG_IS, "OECFColumns"},
    {0X00160008, DCM_VR_TAG_UC, "OECFColumnNames"},
    {0X00160009, DCM_VR_TAG_DS, "OECFValues"},
    {0X0016000A, DCM_VR_TAG_IS, "SpatialFrequencyResponseRows"},
    {0X0016000B, DCM_VR_TAG_IS, "SpatialFrequencyResponseColumns"},
    {0X0016000C, DCM_VR_TAG_UC, "SpatialFrequencyResponseColumnNames"},
    {0X0016000D, DCM_VR_TAG_DS, "SpatialFrequencyResponseValues"},
    {0X0016000E, DCM_VR_TAG_IS, "ColorFilterArrayPatternRows"},
    {0X0016000F, DCM_VR_TAG_IS, "ColorFilterArrayPatternColumns"},
    {0X00160010, DCM_VR_TAG_DS, "ColorFilterArrayPatternValues"},
    {0X00160011, DCM_VR_TAG_US, "FlashFiringStatus"},
    {0X00160012, DCM_VR_TAG_US, "FlashReturnStatus"},
    {0X00160013, DCM_VR_TAG_US, "FlashMode"},
    {0X00160014, DCM_VR_TAG_US, "FlashFunctionPresent"},
    {0X00160015, DCM_VR_TAG_US, "FlashRedEyeMode"},
    {0X00160016, DCM_VR_TAG_US, "ExposureProgram"},
    {0X00160017, DCM_VR_TAG_UT, "SpectralSensitivity"},
    {0X00160018, DCM_VR_TAG_IS, "PhotographicSensitivity"},
    {0X00160019, DCM_VR_TAG_IS, "SelfTimerMode"},
    {0X0016001A, DCM_VR_TAG_US, "SensitivityType"},
    {0X0016001B, DCM_VR_TAG_IS, "StandardOutputSensitivity"},
    {0X0016001C, DCM_VR_TAG_IS, "RecommendedExposureIndex"},
    {0X0016001D, DCM_VR_TAG_IS, "ISOSpeed"},
    {0X0016001E, DCM_VR_TAG_IS, "ISOSpeedLatitudeyyy"},
    {0X0016001F, DCM_VR_TAG_IS, "ISOSpeedLatitudezzz"},
    {0X00160020, DCM_VR_TAG_UT, "EXIFVersion"},
    {0X00160021, DCM_VR_TAG_DS, "ShutterSpeedValue"},
    {0X00160022, DCM_VR_TAG_DS, "ApertureValue"},
    {0X00160023, DCM_VR_TAG_DS, "BrightnessValue"},
    {0X00160024, DCM_VR_TAG_DS, "ExposureBiasValue"},
    {0X00160025, DCM_VR_TAG_DS, "MaxApertureValue"},
    {0X00160026, DCM_VR_TAG_DS, "SubjectDistance"},
    {0X00160027, DCM_VR_TAG_US, "MeteringMode"},
    {0X00160028, DCM_VR_TAG_US, "LightSource"},
    {0X00160029, DCM_VR_TAG_DS, "FocalLength"},
    {0X0016002A, DCM_VR_TAG_IS, "SubjectArea"},
    {0X0016002B, DCM_VR_TAG_OB, "MakerNote"},
    {0X00160030, DCM_VR_TAG_DS, "Temperature"},
    {0X00160031, DCM_VR_TAG_DS, "Humidity"},
    {0X00160032, DCM_VR_TAG_DS, "Pressure"},
    {0X00160033, DCM_VR_TAG_DS, "WaterDepth"},
    {0X00160034, DCM_VR_TAG_DS, "Acceleration"},
    {0X00160035, DCM_VR_TAG_DS, "CameraElevationAngle"},
    {0X00160036, DCM_VR_TAG_DS, "FlashEnergy"},
    {0X00160037, DCM_VR_TAG_IS, "SubjectLocation"},
    {0X00160038, DCM_VR_TAG_DS, "PhotographicExposureIndex"},
    {0X00160039, DCM_VR_TAG_US, "SensingMethod"},
    {0X0016003A, DCM_VR_TAG_US, "FileSource"},
    {0X0016003B, DCM_VR_TAG_US, "SceneType"},
    {0X00160041, DCM_VR_TAG_US, "CustomRendered"},
    {0X00160042, DCM_VR_TAG_US, "ExposureMode"},
    {0X00160043, DCM_VR_TAG_US, "WhiteBalance"},
    {0X00160044, DCM_VR_TAG_DS, "DigitalZoomRatio"},
    {0X00160045, DCM_VR_TAG_IS, "FocalLengthIn35mmFilm"},
    {0X00160046, DCM_VR_TAG_US, "SceneCaptureType"},
    {0X00160047, DCM_VR_TAG_US, "GainControl"},
    {0X00160048, DCM_VR_TAG_US, "Contrast"},
    {0X00160049, DCM_VR_TAG_US, "Saturation"},
    {0X0016004A, DCM_VR_TAG_US, "Sharpness"},
    {0X0016004B, DCM_VR_TAG_OB, "DeviceSettingDescription"},
    {0X0016004C, DCM_VR_TAG_US, "SubjectDistanceRange"},
    {0X0016004D, DCM_VR_TAG_UT, "CameraOwnerName"},
    {0X0016004E, DCM_VR_TAG_DS, "LensSpecification"},
    {0X0016004F, DCM_VR_TAG_UT, "LensMake"},
    {0X00160050, DCM_VR_TAG_UT, "LensModel"},
    {0X00160051, DCM_VR_TAG_UT, "LensSerialNumber"},
    {0X00160061, DCM_VR_TAG_CS, "InteroperabilityIndex"},
    {0X00160062, DCM_VR_TAG_OB, "InteroperabilityVersion"},
    {0X00160070, DCM_VR_TAG_OB, "GPSVersionID"},
    {0X00160071, DCM_VR_TAG_CS, "GPSLatitudeRef"},
    {0X00160072, DCM_VR_TAG_DS, "GPSLatitude"},
    {0X00160073, DCM_VR_TAG_CS, "GPSLongitudeRef"},
    {0X00160074, DCM_VR_TAG_DS, "GPSLongitude"},
    {0X00160075, DCM_VR_TAG_US, "GPSAltitudeRef"},
    {0X00160076, DCM_VR_TAG_DS, "GPSAltitude"},
    {0X00160077, DCM_VR_TAG_DT, "GPSTimeStamp"},
    {0X00160078, DCM_VR_TAG_UT, "GPSSatellites"},
    {0X00160079, DCM_VR_TAG_CS, "GPSStatus"},
    {0X0016007A, DCM_VR_TAG_CS, "GPSMeasureMode"},
    {0X0016007B, DCM_VR_TAG_DS, "GPSDOP"},
    {0X0016007C, DCM_VR_TAG_CS, "GPSSpeedRef"},
    {0X0016007D, DCM_VR_TAG_DS, "GPSSpeed"},
    {0X0016007E, DCM_VR_TAG_CS, "GPSTrackRef"},
    {0X0016007F, DCM_VR_TAG_DS, "GPSTrack"},
    {0X00160080, DCM_VR_TAG_CS, "GPSImgDirectionRef"},
    {0X00160081, DCM_VR_TAG_DS, "GPSImgDirection"},
    {0X00160082, DCM_VR_TAG_UT, "GPSMapDatum"},
    {0X00160083, DCM_VR_TAG_CS, "GPSDestLatitudeRef"},
    {0X00160084, DCM_VR_TAG_DS, "GPSDestLatitude"},
    {0X00160085, DCM_VR_TAG_CS, "GPSDestLongitudeRef"},
    {0X00160086, DCM_VR_TAG_DS, "GPSDestLongitude"},
    {0X00160087, DCM_VR_TAG_CS, "GPSDestBearingRef"},
    {0X00160088, DCM_VR_TAG_DS, "GPSDestBearing"},
    {0X00160089, DCM_VR_TAG_CS, "GPSDestDistanceRef"},
    {0X0016008A, DCM_VR_TAG_DS, "GPSDestDistance"},
    {0X0016008B, DCM_VR_TAG_OB, "GPSProcessingMethod"},
    {0X0016008C, DCM_VR_TAG_OB, "GPSAreaInformation"},
    {0X0016008D, DCM_VR_TAG_DT, "GPSDateStamp"},
    {0X0016008E, DCM_VR_TAG_IS, "GPSDifferential"},
    {0X00161001, DCM_VR_TAG_CS, "LightSourcePolarization"},
    {0X00161002, DCM_VR_TAG_DS, "EmitterColorTemperature"},
    {0X00161003, DCM_VR_TAG_CS, "ContactMethod"},
    {0X00161004, DCM_VR_TAG_CS, "ImmersionMedia"},
    {0X00161005, DCM_VR_TAG_DS, "OpticalMagnificationFactor"},
    {0X00180010, DCM_VR_TAG_LO, "ContrastBolusAgent"},
    {0X00180012, DCM_VR_TAG_SQ, "ContrastBolusAgentSequence"},
    {0X00180013, DCM_VR_TAG_FL, "ContrastBolusT1Relaxivity"},
    {0X00180014, DCM_VR_TAG_SQ, "ContrastBolusAdministrationRouteSequence"},
    {0X00180015, DCM_VR_TAG_CS, "BodyPartExamined"},
    {0X00180020, DCM_VR_TAG_CS, "ScanningSequence"},
    {0X00180021, DCM_VR_TAG_CS, "SequenceVariant"},
    {0X00180022, DCM_VR_TAG_CS, "ScanOptions"},
    {0X00180023, DCM_VR_TAG_CS, "MRAcquisitionType"},
    {0X00180024, DCM_VR_TAG_SH, "SequenceName"},
    {0X00180025, DCM_VR_TAG_CS, "AngioFlag"},
    {0X00180026, DCM_VR_TAG_SQ, "InterventionDrugInformationSequence"},
    {0X00180027, DCM_VR_TAG_TM, "InterventionDrugStopTime"},
    {0X00180028, DCM_VR_TAG_DS, "InterventionDrugDose"},
    {0X00180029, DCM_VR_TAG_SQ, "InterventionDrugCodeSequence"},
    {0X0018002A, DCM_VR_TAG_SQ, "AdditionalDrugSequence"},
    {0X00180030, DCM_VR_TAG_LO, "Radionuclide"},
    {0X00180031, DCM_VR_TAG_LO, "Radiopharmaceutical"},
    {0X00180032, DCM_VR_TAG_DS, "EnergyWindowCenterline"},
    {0X00180033, DCM_VR_TAG_DS, "EnergyWindowTotalWidth"},
    {0X00180034, DCM_VR_TAG_LO, "InterventionDrugName"},
    {0X00180035, DCM_VR_TAG_TM, "InterventionDrugStartTime"},
    {0X00180036, DCM_VR_TAG_SQ, "InterventionSequence"},
    {0X00180037, DCM_VR_TAG_CS, "TherapyType"},
    {0X00180038, DCM_VR_TAG_CS, "InterventionStatus"},
    {0X00180039, DCM_VR_TAG_CS, "TherapyDescription"},
    {0X0018003A, DCM_VR_TAG_ST, "InterventionDescription"},
    {0X00180040, DCM_VR_TAG_IS, "CineRate"},
    {0X00180042, DCM_VR_TAG_CS, "InitialCineRunState"},
    {0X00180050, DCM_VR_TAG_DS, "SliceThickness"},
    {0X00180060, DCM_VR_TAG_DS, "KVP"},
    {0X00180061, DCM_VR_TAG_DS, ""},
    {0X00180070, DCM_VR_TAG_IS, "CountsAccumulated"},
    {0X00180071, DCM_VR_TAG_CS, "AcquisitionTerminationCondition"},
    {0X00180072, DCM_VR_TAG_DS, "EffectiveDuration"},
    {0X00180073, DCM_VR_TAG_CS, "AcquisitionStartCondition"},
    {0X00180074, DCM_VR_TAG_IS, "AcquisitionStartConditionData"},
    {0X00180075, DCM_VR_TAG_IS, "AcquisitionTerminationConditionData"},
    {0X00180080, DCM_VR_TAG_DS, "RepetitionTime"},
    {0X00180081, DCM_VR_TAG_DS, "EchoTime"},
    {0X00180082, DCM_VR_TAG_DS, "InversionTime"},
    {0X00180083, DCM_VR_TAG_DS, "NumberOfAverages"},
    {0X00180084, DCM_VR_TAG_DS, "ImagingFrequency"},
    {0X00180085, DCM_VR_TAG_SH, "ImagedNucleus"},
    {0X00180086, DCM_VR_TAG_IS, "EchoNumbers"},
    {0X00180087, DCM_VR_TAG_DS, "MagneticFieldStrength"},
    {0X00180088, DCM_VR_TAG_DS, "SpacingBetweenSlices"},
    {0X00180089, DCM_VR_TAG_IS, "NumberOfPhaseEncodingSteps"},
    {0X00180090, DCM_VR_TAG_DS, "DataCollectionDiameter"},
    {0X00180091, DCM_VR_TAG_IS, "EchoTrainLength"},
    {0X00180093, DCM_VR_TAG_DS, "PercentSampling"},
    {0X00180094, DCM_VR_TAG_DS, "PercentPhaseFieldOfView"},
    {0X00180095, DCM_VR_TAG_DS, "PixelBandwidth"},
    {0X00181000, DCM_VR_TAG_LO, "DeviceSerialNumber"},
    {0X00181002, DCM_VR_TAG_UI, "DeviceUID"},
    {0X00181003, DCM_VR_TAG_LO, "DeviceID"},
    {0X00181004, DCM_VR_TAG_LO, "PlateID"},
    {0X00181005, DCM_VR_TAG_LO, "GeneratorID"},
    {0X00181006, DCM_VR_TAG_LO, "GridID"},
    {0X00181007, DCM_VR_TAG_LO, "CassetteID"},
    {0X00181008, DCM_VR_TAG_LO, "GantryID"},
    {0X00181009, DCM_VR_TAG_UT, "UniqueDeviceIdentifier"},
    {0X0018100A, DCM_VR_TAG_SQ, "UDISequence"},
    {0X0018100B, DCM_VR_TAG_UI, "ManufacturerDeviceClassUID"},
    {0X00181010, DCM_VR_TAG_LO, "SecondaryCaptureDeviceID"},
    {0X00181011, DCM_VR_TAG_LO, "HardcopyCreationDeviceID"},
    {0X00181012, DCM_VR_TAG_DA, "DateOfSecondaryCapture"},
    {0X00181014, DCM_VR_TAG_TM, "TimeOfSecondaryCapture"},
    {0X00181016, DCM_VR_TAG_LO, "SecondaryCaptureDeviceManufacturer"},
    {0X00181017, DCM_VR_TAG_LO, "HardcopyDeviceManufacturer"},
    {0X00181018, DCM_VR_TAG_LO, "SecondaryCaptureDeviceManufacturerModelName"},
    {0X00181019, DCM_VR_TAG_LO, "SecondaryCaptureDeviceSoftwareVersions"},
    {0X0018101A, DCM_VR_TAG_LO, "HardcopyDeviceSoftwareVersion"},
    {0X0018101B, DCM_VR_TAG_LO, "HardcopyDeviceManufacturerModelName"},
    {0X00181020, DCM_VR_TAG_LO, "SoftwareVersions"},
    {0X00181022, DCM_VR_TAG_SH, "VideoImageFormatAcquired"},
    {0X00181023, DCM_VR_TAG_LO, "DigitalImageFormatAcquired"},
    {0X00181030, DCM_VR_TAG_LO, "ProtocolName"},
    {0X00181040, DCM_VR_TAG_LO, "ContrastBolusRoute"},
    {0X00181041, DCM_VR_TAG_DS, "ContrastBolusVolume"},
    {0X00181042, DCM_VR_TAG_TM, "ContrastBolusStartTime"},
    {0X00181043, DCM_VR_TAG_TM, "ContrastBolusStopTime"},
    {0X00181044, DCM_VR_TAG_DS, "ContrastBolusTotalDose"},
    {0X00181045, DCM_VR_TAG_IS, "SyringeCounts"},
    {0X00181046, DCM_VR_TAG_DS, "ContrastFlowRate"},
    {0X00181047, DCM_VR_TAG_DS, "ContrastFlowDuration"},
    {0X00181048, DCM_VR_TAG_CS, "ContrastBolusIngredient"},
    {0X00181049, DCM_VR_TAG_DS, "ContrastBolusIngredientConcentration"},
    {0X00181050, DCM_VR_TAG_DS, "SpatialResolution"},
    {0X00181060, DCM_VR_TAG_DS, "TriggerTime"},
    {0X00181061, DCM_VR_TAG_LO, "TriggerSourceOrType"},
    {0X00181062, DCM_VR_TAG_IS, "NominalInterval"},
    {0X00181063, DCM_VR_TAG_DS, "FrameTime"},
    {0X00181064, DCM_VR_TAG_LO, "CardiacFramingType"},
    {0X00181065, DCM_VR_TAG_DS, "FrameTimeVector"},
    {0X00181066, DCM_VR_TAG_DS, "FrameDelay"},
    {0X00181067, DCM_VR_TAG_DS, "ImageTriggerDelay"},
    {0X00181068, DCM_VR_TAG_DS, "MultiplexGroupTimeOffset"},
    {0X00181069, DCM_VR_TAG_DS, "TriggerTimeOffset"},
    {0X0018106A, DCM_VR_TAG_CS, "SynchronizationTrigger"},
    {0X0018106C, DCM_VR_TAG_US, "SynchronizationChannel"},
    {0X0018106E, DCM_VR_TAG_UL, "TriggerSamplePosition"},
    {0X00181070, DCM_VR_TAG_LO, "RadiopharmaceuticalRoute"},
    {0X00181071, DCM_VR_TAG_DS, "RadiopharmaceuticalVolume"},
    {0X00181072, DCM_VR_TAG_TM, "RadiopharmaceuticalStartTime"},
    {0X00181073, DCM_VR_TAG_TM, "RadiopharmaceuticalStopTime"},
    {0X00181074, DCM_VR_TAG_DS, "RadionuclideTotalDose"},
    {0X00181075, DCM_VR_TAG_DS, "RadionuclideHalfLife"},
    {0X00181076, DCM_VR_TAG_DS, "RadionuclidePositronFraction"},
    {0X00181077, DCM_VR_TAG_DS, "RadiopharmaceuticalSpecificActivity"},
    {0X00181078, DCM_VR_TAG_DT, "RadiopharmaceuticalStartDateTime"},
    {0X00181079, DCM_VR_TAG_DT, "RadiopharmaceuticalStopDateTime"},
    {0X00181080, DCM_VR_TAG_CS, "BeatRejectionFlag"},
    {0X00181081, DCM_VR_TAG_IS, "LowRRValue"},
    {0X00181082, DCM_VR_TAG_IS, "HighRRValue"},
    {0X00181083, DCM_VR_TAG_IS, "IntervalsAcquired"},
    {0X00181084, DCM_VR_TAG_IS, "IntervalsRejected"},
    {0X00181085, DCM_VR_TAG_LO, "PVCRejection"},
    {0X00181086, DCM_VR_TAG_IS, "SkipBeats"},
    {0X00181088, DCM_VR_TAG_IS, "HeartRate"},
    {0X00181090, DCM_VR_TAG_IS, "CardiacNumberOfImages"},
    {0X00181094, DCM_VR_TAG_IS, "TriggerWindow"},
    {0X00181100, DCM_VR_TAG_DS, "ReconstructionDiameter"},
    {0X00181110, DCM_VR_TAG_DS, "DistanceSourceToDetector"},
    {0X00181111, DCM_VR_TAG_DS, "DistanceSourceToPatient"},
    {0X00181114, DCM_VR_TAG_DS, "EstimatedRadiographicMagnificationFactor"},
    {0X00181120, DCM_VR_TAG_DS, "GantryDetectorTilt"},
    {0X00181121, DCM_VR_TAG_DS, "GantryDetectorSlew"},
    {0X00181130, DCM_VR_TAG_DS, "TableHeight"},
    {0X00181131, DCM_VR_TAG_DS, "TableTraverse"},
    {0X00181134, DCM_VR_TAG_CS, "TableMotion"},
    {0X00181135, DCM_VR_TAG_DS, "TableVerticalIncrement"},
    {0X00181136, DCM_VR_TAG_DS, "TableLateralIncrement"},
    {0X00181137, DCM_VR_TAG_DS, "TableLongitudinalIncrement"},
    {0X00181138, DCM_VR_TAG_DS, "TableAngle"},
    {0X0018113A, DCM_VR_TAG_CS, "TableType"},
    {0X00181140, DCM_VR_TAG_CS, "RotationDirection"},
    {0X00181141, DCM_VR_TAG_DS, "AngularPosition"},
    {0X00181142, DCM_VR_TAG_DS, "RadialPosition"},
    {0X00181143, DCM_VR_TAG_DS, "ScanArc"},
    {0X00181144, DCM_VR_TAG_DS, "AngularStep"},
    {0X00181145, DCM_VR_TAG_DS, "CenterOfRotationOffset"},
    {0X00181146, DCM_VR_TAG_DS, "RotationOffset"},
    {0X00181147, DCM_VR_TAG_CS, "FieldOfViewShape"},
    {0X00181149, DCM_VR_TAG_IS, "FieldOfViewDimensions"},
    {0X00181150, DCM_VR_TAG_IS, "ExposureTime"},
    {0X00181151, DCM_VR_TAG_IS, "XRayTubeCurrent"},
    {0X00181152, DCM_VR_TAG_IS, "Exposure"},
    {0X00181153, DCM_VR_TAG_IS, "ExposureInuAs"},
    {0X00181154, DCM_VR_TAG_DS, "AveragePulseWidth"},
    {0X00181155, DCM_VR_TAG_CS, "RadiationSetting"},
    {0X00181156, DCM_VR_TAG_CS, "RectificationType"},
    {0X0018115A, DCM_VR_TAG_CS, "RadiationMode"},
    {0X0018115E, DCM_VR_TAG_DS, "ImageAndFluoroscopyAreaDoseProduct"},
    {0X00181160, DCM_VR_TAG_SH, "FilterType"},
    {0X00181161, DCM_VR_TAG_LO, "TypeOfFilters"},
    {0X00181162, DCM_VR_TAG_DS, "IntensifierSize"},
    {0X00181164, DCM_VR_TAG_DS, "ImagerPixelSpacing"},
    {0X00181166, DCM_VR_TAG_CS, "Grid"},
    {0X00181170, DCM_VR_TAG_IS, "GeneratorPower"},
    {0X00181180, DCM_VR_TAG_SH, "CollimatorGridName"},
    {0X00181181, DCM_VR_TAG_CS, "CollimatorType"},
    {0X00181182, DCM_VR_TAG_IS, "FocalDistance"},
    {0X00181183, DCM_VR_TAG_DS, "XFocusCenter"},
    {0X00181184, DCM_VR_TAG_DS, "YFocusCenter"},
    {0X00181190, DCM_VR_TAG_DS, "FocalSpots"},
    {0X00181191, DCM_VR_TAG_CS, "AnodeTargetMaterial"},
    {0X001811A0, DCM_VR_TAG_DS, "BodyPartThickness"},
    {0X001811A2, DCM_VR_TAG_DS, "CompressionForce"},
    {0X001811A3, DCM_VR_TAG_DS, "CompressionPressure"},
    {0X001811A4, DCM_VR_TAG_LO, "PaddleDescription"},
    {0X001811A5, DCM_VR_TAG_DS, "CompressionContactArea"},
    {0X001811B0, DCM_VR_TAG_LO, "AcquisitionMode"},
    {0X001811B1, DCM_VR_TAG_LO, "DoseModeName"},
    {0X001811B2, DCM_VR_TAG_CS, "AcquiredSubtractionMaskFlag"},
    {0X001811B3, DCM_VR_TAG_CS, "FluoroscopyPersistenceFlag"},
    {0X001811B4, DCM_VR_TAG_CS, "FluoroscopyLastImageHoldPersistenceFlag"},
    {0X001811B5, DCM_VR_TAG_IS, "UpperLimitNumberOfPersistentFluoroscopyFrames"},
    {0X001811B6, DCM_VR_TAG_CS, "ContrastBolusAutoInjectionTriggerFlag"},
    {0X001811B7, DCM_VR_TAG_FD, "ContrastBolusInjectionDelay"},
    {0X001811B8, DCM_VR_TAG_SQ, "XAAcquisitionPhaseDetailsSequence"},
    {0X001811B9, DCM_VR_TAG_FD, "XAAcquisitionFrameRate"},
    {0X001811BA, DCM_VR_TAG_SQ, "XAPlaneDetailsSequence"},
    {0X001811BB, DCM_VR_TAG_LO, "AcquisitionFieldOfViewLabel"},
    {0X001811BC, DCM_VR_TAG_SQ, "XRayFilterDetailsSequence"},
    {0X001811BD, DCM_VR_TAG_FD, "XAAcquisitionDuration"},
    {0X001811BE, DCM_VR_TAG_CS, "ReconstructionPipelineType"},
    {0X001811BF, DCM_VR_TAG_SQ, "ImageFilterDetailsSequence"},
    {0X001811C0, DCM_VR_TAG_CS, "AppliedMaskSubtractionFlag"},
    {0X001811C1, DCM_VR_TAG_SQ, "RequestedSeriesDescriptionCodeSequence"},
    {0X00181200, DCM_VR_TAG_DA, "DateOfLastCalibration"},
    {0X00181201, DCM_VR_TAG_TM, "TimeOfLastCalibration"},
    {0X00181202, DCM_VR_TAG_DT, "DateTimeOfLastCalibration"},
    {0X00181210, DCM_VR_TAG_SH, "ConvolutionKernel"},
    {0X00181240, DCM_VR_TAG_IS, "UpperLowerPixelValues"},
    {0X00181242, DCM_VR_TAG_IS, "ActualFrameDuration"},
    {0X00181243, DCM_VR_TAG_IS, "CountRate"},
    {0X00181244, DCM_VR_TAG_US, "PreferredPlaybackSequencing"},
    {0X00181250, DCM_VR_TAG_SH, "ReceiveCoilName"},
    {0X00181251, DCM_VR_TAG_SH, "TransmitCoilName"},
    {0X00181260, DCM_VR_TAG_SH, "PlateType"},
    {0X00181261, DCM_VR_TAG_LO, "PhosphorType"},
    {0X00181271, DCM_VR_TAG_FD, "WaterEquivalentDiameter"},
    {0X00181272, DCM_VR_TAG_SQ, "WaterEquivalentDiameterCalculationMethodCodeSequence"},
    {0X00181300, DCM_VR_TAG_DS, "ScanVelocity"},
    {0X00181301, DCM_VR_TAG_CS, "WholeBodyTechnique"},
    {0X00181302, DCM_VR_TAG_IS, "ScanLength"},
    {0X00181310, DCM_VR_TAG_US, "AcquisitionMatrix"},
    {0X00181312, DCM_VR_TAG_CS, "InPlanePhaseEncodingDirection"},
    {0X00181314, DCM_VR_TAG_DS, "FlipAngle"},
    {0X00181315, DCM_VR_TAG_CS, "VariableFlipAngleFlag"},
    {0X00181316, DCM_VR_TAG_DS, "SAR"},
    {0X00181318, DCM_VR_TAG_DS, "dBdt"},
    {0X00181320, DCM_VR_TAG_FL, "B1rms"},
    {0X00181400, DCM_VR_TAG_LO, "AcquisitionDeviceProcessingDescription"},
    {0X00181401, DCM_VR_TAG_LO, "AcquisitionDeviceProcessingCode"},
    {0X00181402, DCM_VR_TAG_CS, "CassetteOrientation"},
    {0X00181403, DCM_VR_TAG_CS, "CassetteSize"},
    {0X00181404, DCM_VR_TAG_US, "ExposuresOnPlate"},
    {0X00181405, DCM_VR_TAG_IS, "RelativeXRayExposure"},
    {0X00181411, DCM_VR_TAG_DS, "ExposureIndex"},
    {0X00181412, DCM_VR_TAG_DS, "TargetExposureIndex"},
    {0X00181413, DCM_VR_TAG_DS, "DeviationIndex"},
    {0X00181450, DCM_VR_TAG_DS, "ColumnAngulation"},
    {0X00181460, DCM_VR_TAG_DS, "TomoLayerHeight"},
    {0X00181470, DCM_VR_TAG_DS, "TomoAngle"},
    {0X00181480, DCM_VR_TAG_DS, "TomoTime"},
    {0X00181490, DCM_VR_TAG_CS, "TomoType"},
    {0X00181491, DCM_VR_TAG_CS, "TomoClass"},
    {0X00181495, DCM_VR_TAG_IS, "NumberOfTomosynthesisSourceImages"},
    {0X00181500, DCM_VR_TAG_CS, "PositionerMotion"},
    {0X00181508, DCM_VR_TAG_CS, "PositionerType"},
    {0X00181510, DCM_VR_TAG_DS, "PositionerPrimaryAngle"},
    {0X00181511, DCM_VR_TAG_DS, "PositionerSecondaryAngle"},
    {0X00181520, DCM_VR_TAG_DS, "PositionerPrimaryAngleIncrement"},
    {0X00181521, DCM_VR_TAG_DS, "PositionerSecondaryAngleIncrement"},
    {0X00181530, DCM_VR_TAG_DS, "DetectorPrimaryAngle"},
    {0X00181531, DCM_VR_TAG_DS, "DetectorSecondaryAngle"},
    {0X00181600, DCM_VR_TAG_CS, "ShutterShape"},
    {0X00181602, DCM_VR_TAG_IS, "ShutterLeftVerticalEdge"},
    {0X00181604, DCM_VR_TAG_IS, "ShutterRightVerticalEdge"},
    {0X00181606, DCM_VR_TAG_IS, "ShutterUpperHorizontalEdge"},
    {0X00181608, DCM_VR_TAG_IS, "ShutterLowerHorizontalEdge"},
    {0X00181610, DCM_VR_TAG_IS, "CenterOfCircularShutter"},
    {0X00181612, DCM_VR_TAG_IS, "RadiusOfCircularShutter"},
    {0X00181620, DCM_VR_TAG_IS, "VerticesOfThePolygonalShutter"},
    {0X00181622, DCM_VR_TAG_US, "ShutterPresentationValue"},
    {0X00181623, DCM_VR_TAG_US, "ShutterOverlayGroup"},
    {0X00181624, DCM_VR_TAG_US, "ShutterPresentationColorCIELabValue"},
    {0X00181630, DCM_VR_TAG_CS, "OutlineShapeType"},
    {0X00181631, DCM_VR_TAG_FD, "OutlineLeftVerticalEdge"},
    {0X00181632, DCM_VR_TAG_FD, "OutlineRightVerticalEdge"},
    {0X00181633, DCM_VR_TAG_FD, "OutlineUpperHorizontalEdge"},
    {0X00181634, DCM_VR_TAG_FD, "OutlineLowerHorizontalEdge"},
    {0X00181635, DCM_VR_TAG_FD, "CenterOfCircularOutline"},
    {0X00181636, DCM_VR_TAG_FD, "DiameterOfCircularOutline"},
    {0X00181637, DCM_VR_TAG_UL, "NumberOfPolygonalVertices"},
    {0X00181638, DCM_VR_TAG_OF, "VerticesOfThePolygonalOutline"},
    {0X00181700, DCM_VR_TAG_CS, "CollimatorShape"},
    {0X00181702, DCM_VR_TAG_IS, "CollimatorLeftVerticalEdge"},
    {0X00181704, DCM_VR_TAG_IS, "CollimatorRightVerticalEdge"},
    {0X00181706, DCM_VR_TAG_IS, "CollimatorUpperHorizontalEdge"},
    {0X00181708, DCM_VR_TAG_IS, "CollimatorLowerHorizontalEdge"},
    {0X00181710, DCM_VR_TAG_IS, "CenterOfCircularCollimator"},
    {0X00181712, DCM_VR_TAG_IS, "RadiusOfCircularCollimator"},
    {0X00181720, DCM_VR_TAG_IS, "VerticesOfThePolygonalCollimator"},
    {0X00181800, DCM_VR_TAG_CS, "AcquisitionTimeSynchronized"},
    {0X00181801, DCM_VR_TAG_SH, "TimeSource"},
    {0X00181802, DCM_VR_TAG_CS, "TimeDistributionProtocol"},
    {0X00181803, DCM_VR_TAG_LO, "NTPSourceAddress"},
    {0X00182001, DCM_VR_TAG_IS, "PageNumberVector"},
    {0X00182002, DCM_VR_TAG_SH, "FrameLabelVector"},
    {0X00182003, DCM_VR_TAG_DS, "FramePrimaryAngleVector"},
    {0X00182004, DCM_VR_TAG_DS, "FrameSecondaryAngleVector"},
    {0X00182005, DCM_VR_TAG_DS, "SliceLocationVector"},
    {0X00182006, DCM_VR_TAG_SH, "DisplayWindowLabelVector"},
    {0X00182010, DCM_VR_TAG_DS, "NominalScannedPixelSpacing"},
    {0X00182020, DCM_VR_TAG_CS, "DigitizingDeviceTransportDirection"},
    {0X00182030, DCM_VR_TAG_DS, "RotationOfScannedFilm"},
    {0X00182041, DCM_VR_TAG_SQ, "BiopsyTargetSequence"},
    {0X00182042, DCM_VR_TAG_UI, "TargetUID"},
    {0X00182043, DCM_VR_TAG_FL, "LocalizingCursorPosition"},
    {0X00182044, DCM_VR_TAG_FL, "CalculatedTargetPosition"},
    {0X00182045, DCM_VR_TAG_SH, "TargetLabel"},
    {0X00182046, DCM_VR_TAG_FL, "DisplayedZValue"},
    {0X00183100, DCM_VR_TAG_CS, "IVUSAcquisition"},
    {0X00183101, DCM_VR_TAG_DS, "IVUSPullbackRate"},
    {0X00183102, DCM_VR_TAG_DS, "IVUSGatedRate"},
    {0X00183103, DCM_VR_TAG_IS, "IVUSPullbackStartFrameNumber"},
    {0X00183104, DCM_VR_TAG_IS, "IVUSPullbackStopFrameNumber"},
    {0X00183105, DCM_VR_TAG_IS, "LesionNumber"},
    {0X00184000, DCM_VR_TAG_LT, "AcquisitionComments"},
    {0X00185000, DCM_VR_TAG_SH, "OutputPower"},
    {0X00185010, DCM_VR_TAG_LO, "TransducerData"},
    {0X00185011, DCM_VR_TAG_SQ, "TransducerIdentificationSequence"},
    {0X00185012, DCM_VR_TAG_DS, "FocusDepth"},
    {0X00185020, DCM_VR_TAG_LO, "ProcessingFunction"},
    {0X00185021, DCM_VR_TAG_LO, "PostprocessingFunction"},
    {0X00185022, DCM_VR_TAG_DS, "MechanicalIndex"},
    {0X00185024, DCM_VR_TAG_DS, "BoneThermalIndex"},
    {0X00185026, DCM_VR_TAG_DS, "CranialThermalIndex"},
    {0X00185027, DCM_VR_TAG_DS, "SoftTissueThermalIndex"},
    {0X00185028, DCM_VR_TAG_DS, "SoftTissueFocusThermalIndex"},
    {0X00185029, DCM_VR_TAG_DS, "SoftTissueSurfaceThermalIndex"},
    {0X00185030, DCM_VR_TAG_DS, "DynamicRange"},
    {0X00185040, DCM_VR_TAG_DS, "TotalGain"},
    {0X00185050, DCM_VR_TAG_IS, "DepthOfScanField"},
    {0X00185100, DCM_VR_TAG_CS, "PatientPosition"},
    {0X00185101, DCM_VR_TAG_CS, "ViewPosition"},
    {0X00185104, DCM_VR_TAG_SQ, "ProjectionEponymousNameCodeSequence"},
    {0X00185210, DCM_VR_TAG_DS, "ImageTransformationMatrix"},
    {0X00185212, DCM_VR_TAG_DS, "ImageTranslationVector"},
    {0X00186000, DCM_VR_TAG_DS, "Sensitivity"},
    {0X00186011, DCM_VR_TAG_SQ, "SequenceOfUltrasoundRegions"},
    {0X00186012, DCM_VR_TAG_US, "RegionSpatialFormat"},
    {0X00186014, DCM_VR_TAG_US, "RegionDataType"},
    {0X00186016, DCM_VR_TAG_UL, "RegionFlags"},
    {0X00186018, DCM_VR_TAG_UL, "RegionLocationMinX0"},
    {0X0018601A, DCM_VR_TAG_UL, "RegionLocationMinY0"},
    {0X0018601C, DCM_VR_TAG_UL, "RegionLocationMaxX1"},
    {0X0018601E, DCM_VR_TAG_UL, "RegionLocationMaxY1"},
    {0X00186020, DCM_VR_TAG_SL, "ReferencePixelX0"},
    {0X00186022, DCM_VR_TAG_SL, "ReferencePixelY0"},
    {0X00186024, DCM_VR_TAG_US, "PhysicalUnitsXDirection"},
    {0X00186026, DCM_VR_TAG_US, "PhysicalUnitsYDirection"},
    {0X00186028, DCM_VR_TAG_FD, "ReferencePixelPhysicalValueX"},
    {0X0018602A, DCM_VR_TAG_FD, "ReferencePixelPhysicalValueY"},
    {0X0018602C, DCM_VR_TAG_FD, "PhysicalDeltaX"},
    {0X0018602E, DCM_VR_TAG_FD, "PhysicalDeltaY"},
    {0X00186030, DCM_VR_TAG_UL, "TransducerFrequency"},
    {0X00186031, DCM_VR_TAG_CS, "TransducerType"},
    {0X00186032, DCM_VR_TAG_UL, "PulseRepetitionFrequency"},
    {0X00186034, DCM_VR_TAG_FD, "DopplerCorrectionAngle"},
    {0X00186036, DCM_VR_TAG_FD, "SteeringAngle"},
    {0X00186038, DCM_VR_TAG_UL, "DopplerSampleVolumeXPositionRetired"},
    {0X00186039, DCM_VR_TAG_SL, "DopplerSampleVolumeXPosition"},
    {0X0018603A, DCM_VR_TAG_UL, "DopplerSampleVolumeYPositionRetired"},
    {0X0018603B, DCM_VR_TAG_SL, "DopplerSampleVolumeYPosition"},
    {0X0018603C, DCM_VR_TAG_UL, "TMLinePositionX0Retired"},
    {0X0018603D, DCM_VR_TAG_SL, "TMLinePositionX0"},
    {0X0018603E, DCM_VR_TAG_UL, "TMLinePositionY0Retired"},
    {0X0018603F, DCM_VR_TAG_SL, "TMLinePositionY0"},
    {0X00186040, DCM_VR_TAG_UL, "TMLinePositionX1Retired"},
    {0X00186041, DCM_VR_TAG_SL, "TMLinePositionX1"},
    {0X00186042, DCM_VR_TAG_UL, "TMLinePositionY1Retired"},
    {0X00186043, DCM_VR_TAG_SL, "TMLinePositionY1"},
    {0X00186044, DCM_VR_TAG_US, "PixelComponentOrganization"},
    {0X00186046, DCM_VR_TAG_UL, "PixelComponentMask"},
    {0X00186048, DCM_VR_TAG_UL, "PixelComponentRangeStart"},
    {0X0018604A, DCM_VR_TAG_UL, "PixelComponentRangeStop"},
    {0X0018604C, DCM_VR_TAG_US, "PixelComponentPhysicalUnits"},
    {0X0018604E, DCM_VR_TAG_US, "PixelComponentDataType"},
    {0X00186050, DCM_VR_TAG_UL, "NumberOfTableBreakPoints"},
    {0X00186052, DCM_VR_TAG_UL, "TableOfXBreakPoints"},
    {0X00186054, DCM_VR_TAG_FD, "TableOfYBreakPoints"},
    {0X00186056, DCM_VR_TAG_UL, "NumberOfTableEntries"},
    {0X00186058, DCM_VR_TAG_UL, "TableOfPixelValues"},
    {0X0018605A, DCM_VR_TAG_FL, "TableOfParameterValues"},
    {0X00186060, DCM_VR_TAG_FL, "RWaveTimeVector"},
    {0X00186070, DCM_VR_TAG_US, "ActiveImageAreaOverlayGroup"},
    {0X00187000, DCM_VR_TAG_CS, "DetectorConditionsNominalFlag"},
    {0X00187001, DCM_VR_TAG_DS, "DetectorTemperature"},
    {0X00187004, DCM_VR_TAG_CS, "DetectorType"},
    {0X00187005, DCM_VR_TAG_CS, "DetectorConfiguration"},
    {0X00187006, DCM_VR_TAG_LT, "DetectorDescription"},
    {0X00187008, DCM_VR_TAG_LT, "DetectorMode"},
    {0X0018700A, DCM_VR_TAG_SH, "DetectorID"},
    {0X0018700C, DCM_VR_TAG_DA, "DateOfLastDetectorCalibration"},
    {0X0018700E, DCM_VR_TAG_TM, "TimeOfLastDetectorCalibration"},
    {0X00187010, DCM_VR_TAG_IS, "ExposuresOnDetectorSinceLastCalibration"},
    {0X00187011, DCM_VR_TAG_IS, "ExposuresOnDetectorSinceManufactured"},
    {0X00187012, DCM_VR_TAG_DS, "DetectorTimeSinceLastExposure"},
    {0X00187014, DCM_VR_TAG_DS, "DetectorActiveTime"},
    {0X00187016, DCM_VR_TAG_DS, "DetectorActivationOffsetFromExposure"},
    {0X0018701A, DCM_VR_TAG_DS, "DetectorBinning"},
    {0X00187020, DCM_VR_TAG_DS, "DetectorElementPhysicalSize"},
    {0X00187022, DCM_VR_TAG_DS, "DetectorElementSpacing"},
    {0X00187024, DCM_VR_TAG_CS, "DetectorActiveShape"},
    {0X00187026, DCM_VR_TAG_DS, "DetectorActiveDimensions"},
    {0X00187028, DCM_VR_TAG_DS, "DetectorActiveOrigin"},
    {0X0018702A, DCM_VR_TAG_LO, "DetectorManufacturerName"},
    {0X0018702B, DCM_VR_TAG_LO, "DetectorManufacturerModelName"},
    {0X00187030, DCM_VR_TAG_DS, "FieldOfViewOrigin"},
    {0X00187032, DCM_VR_TAG_DS, "FieldOfViewRotation"},
    {0X00187034, DCM_VR_TAG_CS, "FieldOfViewHorizontalFlip"},
    {0X00187036, DCM_VR_TAG_FL, "PixelDataAreaOriginRelativeToFOV"},
    {0X00187038, DCM_VR_TAG_FL, "PixelDataAreaRotationAngleRelativeToFOV"},
    {0X00187040, DCM_VR_TAG_LT, "GridAbsorbingMaterial"},
    {0X00187041, DCM_VR_TAG_LT, "GridSpacingMaterial"},
    {0X00187042, DCM_VR_TAG_DS, "GridThickness"},
    {0X00187044, DCM_VR_TAG_DS, "GridPitch"},
    {0X00187046, DCM_VR_TAG_IS, "GridAspectRatio"},
    {0X00187048, DCM_VR_TAG_DS, "GridPeriod"},
    {0X0018704C, DCM_VR_TAG_DS, "GridFocalDistance"},
    {0X00187050, DCM_VR_TAG_CS, "FilterMaterial"},
    {0X00187052, DCM_VR_TAG_DS, "FilterThicknessMinimum"},
    {0X00187054, DCM_VR_TAG_DS, "FilterThicknessMaximum"},
    {0X00187056, DCM_VR_TAG_FL, "FilterBeamPathLengthMinimum"},
    {0X00187058, DCM_VR_TAG_FL, "FilterBeamPathLengthMaximum"},
    {0X00187060, DCM_VR_TAG_CS, "ExposureControlMode"},
    {0X00187062, DCM_VR_TAG_LT, "ExposureControlModeDescription"},
    {0X00187064, DCM_VR_TAG_CS, "ExposureStatus"},
    {0X00187065, DCM_VR_TAG_DS, "PhototimerSetting"},
    {0X00188150, DCM_VR_TAG_DS, "ExposureTimeInuS"},
    {0X00188151, DCM_VR_TAG_DS, "XRayTubeCurrentInuA"},
    {0X00189004, DCM_VR_TAG_CS, "ContentQualification"},
    {0X00189005, DCM_VR_TAG_SH, "PulseSequenceName"},
    {0X00189006, DCM_VR_TAG_SQ, "MRImagingModifierSequence"},
    {0X00189008, DCM_VR_TAG_CS, "EchoPulseSequence"},
    {0X00189009, DCM_VR_TAG_CS, "InversionRecovery"},
    {0X00189010, DCM_VR_TAG_CS, "FlowCompensation"},
    {0X00189011, DCM_VR_TAG_CS, "MultipleSpinEcho"},
    {0X00189012, DCM_VR_TAG_CS, "MultiPlanarExcitation"},
    {0X00189014, DCM_VR_TAG_CS, "PhaseContrast"},
    {0X00189015, DCM_VR_TAG_CS, "TimeOfFlightContrast"},
    {0X00189016, DCM_VR_TAG_CS, "Spoiling"},
    {0X00189017, DCM_VR_TAG_CS, "SteadyStatePulseSequence"},
    {0X00189018, DCM_VR_TAG_CS, "EchoPlanarPulseSequence"},
    {0X00189019, DCM_VR_TAG_FD, "TagAngleFirstAxis"},
    {0X00189020, DCM_VR_TAG_CS, "MagnetizationTransfer"},
    {0X00189021, DCM_VR_TAG_CS, "T2Preparation"},
    {0X00189022, DCM_VR_TAG_CS, "BloodSignalNulling"},
    {0X00189024, DCM_VR_TAG_CS, "SaturationRecovery"},
    {0X00189025, DCM_VR_TAG_CS, "SpectrallySelectedSuppression"},
    {0X00189026, DCM_VR_TAG_CS, "SpectrallySelectedExcitation"},
    {0X00189027, DCM_VR_TAG_CS, "SpatialPresaturation"},
    {0X00189028, DCM_VR_TAG_CS, "Tagging"},
    {0X00189029, DCM_VR_TAG_CS, "OversamplingPhase"},
    {0X00189030, DCM_VR_TAG_FD, "TagSpacingFirstDimension"},
    {0X00189032, DCM_VR_TAG_CS, "GeometryOfKSpaceTraversal"},
    {0X00189033, DCM_VR_TAG_CS, "SegmentedKSpaceTraversal"},
    {0X00189034, DCM_VR_TAG_CS, "RectilinearPhaseEncodeReordering"},
    {0X00189035, DCM_VR_TAG_FD, "TagThickness"},
    {0X00189036, DCM_VR_TAG_CS, "PartialFourierDirection"},
    {0X00189037, DCM_VR_TAG_CS, "CardiacSynchronizationTechnique"},
    {0X00189041, DCM_VR_TAG_LO, "ReceiveCoilManufacturerName"},
    {0X00189042, DCM_VR_TAG_SQ, "MRReceiveCoilSequence"},
    {0X00189043, DCM_VR_TAG_CS, "ReceiveCoilType"},
    {0X00189044, DCM_VR_TAG_CS, "QuadratureReceiveCoil"},
    {0X00189045, DCM_VR_TAG_SQ, "MultiCoilDefinitionSequence"},
    {0X00189046, DCM_VR_TAG_LO, "MultiCoilConfiguration"},
    {0X00189047, DCM_VR_TAG_SH, "MultiCoilElementName"},
    {0X00189048, DCM_VR_TAG_CS, "MultiCoilElementUsed"},
    {0X00189049, DCM_VR_TAG_SQ, "MRTransmitCoilSequence"},
    {0X00189050, DCM_VR_TAG_LO, "TransmitCoilManufacturerName"},
    {0X00189051, DCM_VR_TAG_CS, "TransmitCoilType"},
    {0X00189052, DCM_VR_TAG_FD, "SpectralWidth"},
    {0X00189053, DCM_VR_TAG_FD, "ChemicalShiftReference"},
    {0X00189054, DCM_VR_TAG_CS, "VolumeLocalizationTechnique"},
    {0X00189058, DCM_VR_TAG_US, "MRAcquisitionFrequencyEncodingSteps"},
    {0X00189059, DCM_VR_TAG_CS, "Decoupling"},
    {0X00189060, DCM_VR_TAG_CS, "DecoupledNucleus"},
    {0X00189061, DCM_VR_TAG_FD, "DecouplingFrequency"},
    {0X00189062, DCM_VR_TAG_CS, "DecouplingMethod"},
    {0X00189063, DCM_VR_TAG_FD, "DecouplingChemicalShiftReference"},
    {0X00189064, DCM_VR_TAG_CS, "KSpaceFiltering"},
    {0X00189065, DCM_VR_TAG_CS, "TimeDomainFiltering"},
    {0X00189066, DCM_VR_TAG_US, "NumberOfZeroFills"},
    {0X00189067, DCM_VR_TAG_CS, "BaselineCorrection"},
    {0X00189069, DCM_VR_TAG_FD, "ParallelReductionFactorInPlane"},
    {0X00189070, DCM_VR_TAG_FD, "CardiacRRIntervalSpecified"},
    {0X00189073, DCM_VR_TAG_FD, "AcquisitionDuration"},
    {0X00189074, DCM_VR_TAG_DT, "FrameAcquisitionDateTime"},
    {0X00189075, DCM_VR_TAG_CS, "DiffusionDirectionality"},
    {0X00189076, DCM_VR_TAG_SQ, "DiffusionGradientDirectionSequence"},
    {0X00189077, DCM_VR_TAG_CS, "ParallelAcquisition"},
    {0X00189078, DCM_VR_TAG_CS, "ParallelAcquisitionTechnique"},
    {0X00189079, DCM_VR_TAG_FD, "InversionTimes"},
    {0X00189080, DCM_VR_TAG_ST, "MetaboliteMapDescription"},
    {0X00189081, DCM_VR_TAG_CS, "PartialFourier"},
    {0X00189082, DCM_VR_TAG_FD, "EffectiveEchoTime"},
    {0X00189083, DCM_VR_TAG_SQ, "MetaboliteMapCodeSequence"},
    {0X00189084, DCM_VR_TAG_SQ, "ChemicalShiftSequence"},
    {0X00189085, DCM_VR_TAG_CS, "CardiacSignalSource"},
    {0X00189087, DCM_VR_TAG_FD, "DiffusionBValue"},
    {0X00189089, DCM_VR_TAG_FD, "DiffusionGradientOrientation"},
    {0X00189090, DCM_VR_TAG_FD, "VelocityEncodingDirection"},
    {0X00189091, DCM_VR_TAG_FD, "VelocityEncodingMinimumValue"},
    {0X00189092, DCM_VR_TAG_SQ, "VelocityEncodingAcquisitionSequence"},
    {0X00189093, DCM_VR_TAG_US, "NumberOfKSpaceTrajectories"},
    {0X00189094, DCM_VR_TAG_CS, "CoverageOfKSpace"},
    {0X00189095, DCM_VR_TAG_UL, "SpectroscopyAcquisitionPhaseRows"},
    {0X00189096, DCM_VR_TAG_FD, "ParallelReductionFactorInPlaneRetired"},
    {0X00189098, DCM_VR_TAG_FD, "TransmitterFrequency"},
    {0X00189100, DCM_VR_TAG_CS, "ResonantNucleus"},
    {0X00189101, DCM_VR_TAG_CS, "FrequencyCorrection"},
    {0X00189103, DCM_VR_TAG_SQ, "MRSpectroscopyFOVGeometrySequence"},
    {0X00189104, DCM_VR_TAG_FD, "SlabThickness"},
    {0X00189105, DCM_VR_TAG_FD, "SlabOrientation"},
    {0X00189106, DCM_VR_TAG_FD, "MidSlabPosition"},
    {0X00189107, DCM_VR_TAG_SQ, "MRSpatialSaturationSequence"},
    {0X00189112, DCM_VR_TAG_SQ, "MRTimingAndRelatedParametersSequence"},
    {0X00189114, DCM_VR_TAG_SQ, "MREchoSequence"},
    {0X00189115, DCM_VR_TAG_SQ, "MRModifierSequence"},
    {0X00189117, DCM_VR_TAG_SQ, "MRDiffusionSequence"},
    {0X00189118, DCM_VR_TAG_SQ, "CardiacSynchronizationSequence"},
    {0X00189119, DCM_VR_TAG_SQ, "MRAveragesSequence"},
    {0X00189125, DCM_VR_TAG_SQ, "MRFOVGeometrySequence"},
    {0X00189126, DCM_VR_TAG_SQ, "VolumeLocalizationSequence"},
    {0X00189127, DCM_VR_TAG_UL, "SpectroscopyAcquisitionDataColumns"},
    {0X00189147, DCM_VR_TAG_CS, "DiffusionAnisotropyType"},
    {0X00189151, DCM_VR_TAG_DT, "FrameReferenceDateTime"},
    {0X00189152, DCM_VR_TAG_SQ, "MRMetaboliteMapSequence"},
    {0X00189155, DCM_VR_TAG_FD, "ParallelReductionFactorOutOfPlane"},
    {0X00189159, DCM_VR_TAG_UL, "SpectroscopyAcquisitionOutOfPlanePhaseSteps"},
    {0X00189166, DCM_VR_TAG_CS, "BulkMotionStatus"},
    {0X00189168, DCM_VR_TAG_FD, "ParallelReductionFactorSecondInPlane"},
    {0X00189169, DCM_VR_TAG_CS, "CardiacBeatRejectionTechnique"},
    {0X00189170, DCM_VR_TAG_CS, "RespiratoryMotionCompensationTechnique"},
    {0X00189171, DCM_VR_TAG_CS, "RespiratorySignalSource"},
    {0X00189172, DCM_VR_TAG_CS, "BulkMotionCompensationTechnique"},
    {0X00189173, DCM_VR_TAG_CS, "BulkMotionSignalSource"},
    {0X00189174, DCM_VR_TAG_CS, "ApplicableSafetyStandardAgency"},
    {0X00189175, DCM_VR_TAG_LO, "ApplicableSafetyStandardDescription"},
    {0X00189176, DCM_VR_TAG_SQ, "OperatingModeSequence"},
    {0X00189177, DCM_VR_TAG_CS, "OperatingModeType"},
    {0X00189178, DCM_VR_TAG_CS, "OperatingMode"},
    {0X00189179, DCM_VR_TAG_CS, "SpecificAbsorptionRateDefinition"},
    {0X00189180, DCM_VR_TAG_CS, "GradientOutputType"},
    {0X00189181, DCM_VR_TAG_FD, "SpecificAbsorptionRateValue"},
    {0X00189182, DCM_VR_TAG_FD, "GradientOutput"},
    {0X00189183, DCM_VR_TAG_CS, "FlowCompensationDirection"},
    {0X00189184, DCM_VR_TAG_FD, "TaggingDelay"},
    {0X00189185, DCM_VR_TAG_ST, "RespiratoryMotionCompensationTechniqueDescription"},
    {0X00189186, DCM_VR_TAG_SH, "RespiratorySignalSourceID"},
    {0X00189195, DCM_VR_TAG_FD, "ChemicalShiftMinimumIntegrationLimitInHz"},
    {0X00189196, DCM_VR_TAG_FD, "ChemicalShiftMaximumIntegrationLimitInHz"},
    {0X00189197, DCM_VR_TAG_SQ, "MRVelocityEncodingSequence"},
    {0X00189198, DCM_VR_TAG_CS, "FirstOrderPhaseCorrection"},
    {0X00189199, DCM_VR_TAG_CS, "WaterReferencedPhaseCorrection"},
    {0X00189200, DCM_VR_TAG_CS, "MRSpectroscopyAcquisitionType"},
    {0X00189214, DCM_VR_TAG_CS, "RespiratoryCyclePosition"},
    {0X00189217, DCM_VR_TAG_FD, "VelocityEncodingMaximumValue"},
    {0X00189218, DCM_VR_TAG_FD, "TagSpacingSecondDimension"},
    {0X00189219, DCM_VR_TAG_SS, "TagAngleSecondAxis"},
    {0X00189220, DCM_VR_TAG_FD, "FrameAcquisitionDuration"},
    {0X00189226, DCM_VR_TAG_SQ, "MRImageFrameTypeSequence"},
    {0X00189227, DCM_VR_TAG_SQ, "MRSpectroscopyFrameTypeSequence"},
    {0X00189231, DCM_VR_TAG_US, "MRAcquisitionPhaseEncodingStepsInPlane"},
    {0X00189232, DCM_VR_TAG_US, "MRAcquisitionPhaseEncodingStepsOutOfPlane"},
    {0X00189234, DCM_VR_TAG_UL, "SpectroscopyAcquisitionPhaseColumns"},
    {0X00189236, DCM_VR_TAG_CS, "CardiacCyclePosition"},
    {0X00189239, DCM_VR_TAG_SQ, "SpecificAbsorptionRateSequence"},
    {0X00189240, DCM_VR_TAG_US, "RFEchoTrainLength"},
    {0X00189241, DCM_VR_TAG_US, "GradientEchoTrainLength"},
    {0X00189250, DCM_VR_TAG_CS, "ArterialSpinLabelingContrast"},
    {0X00189251, DCM_VR_TAG_SQ, "MRArterialSpinLabelingSequence"},
    {0X00189252, DCM_VR_TAG_LO, "ASLTechniqueDescription"},
    {0X00189253, DCM_VR_TAG_US, "ASLSlabNumber"},
    {0X00189254, DCM_VR_TAG_FD, "ASLSlabThickness"},
    {0X00189255, DCM_VR_TAG_FD, "ASLSlabOrientation"},
    {0X00189256, DCM_VR_TAG_FD, "ASLMidSlabPosition"},
    {0X00189257, DCM_VR_TAG_CS, "ASLContext"},
    {0X00189258, DCM_VR_TAG_UL, "ASLPulseTrainDuration"},
    {0X00189259, DCM_VR_TAG_CS, "ASLCrusherFlag"},
    {0X0018925A, DCM_VR_TAG_FD, "ASLCrusherFlowLimit"},
    {0X0018925B, DCM_VR_TAG_LO, "ASLCrusherDescription"},
    {0X0018925C, DCM_VR_TAG_CS, "ASLBolusCutoffFlag"},
    {0X0018925D, DCM_VR_TAG_SQ, "ASLBolusCutoffTimingSequence"},
    {0X0018925E, DCM_VR_TAG_LO, "ASLBolusCutoffTechnique"},
    {0X0018925F, DCM_VR_TAG_UL, "ASLBolusCutoffDelayTime"},
    {0X00189260, DCM_VR_TAG_SQ, "ASLSlabSequence"},
    {0X00189295, DCM_VR_TAG_FD, "ChemicalShiftMinimumIntegrationLimitInppm"},
    {0X00189296, DCM_VR_TAG_FD, "ChemicalShiftMaximumIntegrationLimitInppm"},
    {0X00189297, DCM_VR_TAG_CS, "WaterReferenceAcquisition"},
    {0X00189298, DCM_VR_TAG_IS, "EchoPeakPosition"},
    {0X00189301, DCM_VR_TAG_SQ, "CTAcquisitionTypeSequence"},
    {0X00189302, DCM_VR_TAG_CS, "AcquisitionType"},
    {0X00189303, DCM_VR_TAG_FD, "TubeAngle"},
    {0X00189304, DCM_VR_TAG_SQ, "CTAcquisitionDetailsSequence"},
    {0X00189305, DCM_VR_TAG_FD, "RevolutionTime"},
    {0X00189306, DCM_VR_TAG_FD, "SingleCollimationWidth"},
    {0X00189307, DCM_VR_TAG_FD, "TotalCollimationWidth"},
    {0X00189308, DCM_VR_TAG_SQ, "CTTableDynamicsSequence"},
    {0X00189309, DCM_VR_TAG_FD, "TableSpeed"},
    {0X00189310, DCM_VR_TAG_FD, "TableFeedPerRotation"},
    {0X00189311, DCM_VR_TAG_FD, "SpiralPitchFactor"},
    {0X00189312, DCM_VR_TAG_SQ, "CTGeometrySequence"},
    {0X00189313, DCM_VR_TAG_FD, "DataCollectionCenterPatient"},
    {0X00189314, DCM_VR_TAG_SQ, "CTReconstructionSequence"},
    {0X00189315, DCM_VR_TAG_CS, "ReconstructionAlgorithm"},
    {0X00189316, DCM_VR_TAG_CS, "ConvolutionKernelGroup"},
    {0X00189317, DCM_VR_TAG_FD, "ReconstructionFieldOfView"},
    {0X00189318, DCM_VR_TAG_FD, "ReconstructionTargetCenterPatient"},
    {0X00189319, DCM_VR_TAG_FD, "ReconstructionAngle"},
    {0X00189320, DCM_VR_TAG_SH, "ImageFilter"},
    {0X00189321, DCM_VR_TAG_SQ, "CTExposureSequence"},
    {0X00189322, DCM_VR_TAG_FD, "ReconstructionPixelSpacing"},
    {0X00189323, DCM_VR_TAG_CS, "ExposureModulationType"},
    {0X00189324, DCM_VR_TAG_FD, "EstimatedDoseSaving"},
    {0X00189325, DCM_VR_TAG_SQ, "CTXRayDetailsSequence"},
    {0X00189326, DCM_VR_TAG_SQ, "CTPositionSequence"},
    {0X00189327, DCM_VR_TAG_FD, "TablePosition"},
    {0X00189328, DCM_VR_TAG_FD, "ExposureTimeInms"},
    {0X00189329, DCM_VR_TAG_SQ, "CTImageFrameTypeSequence"},
    {0X00189330, DCM_VR_TAG_FD, "XRayTubeCurrentInmA"},
    {0X00189332, DCM_VR_TAG_FD, "ExposureInmAs"},
    {0X00189333, DCM_VR_TAG_CS, "ConstantVolumeFlag"},
    {0X00189334, DCM_VR_TAG_CS, "FluoroscopyFlag"},
    {0X00189335, DCM_VR_TAG_FD, "DistanceSourceToDataCollectionCenter"},
    {0X00189337, DCM_VR_TAG_US, "ContrastBolusAgentNumber"},
    {0X00189338, DCM_VR_TAG_SQ, "ContrastBolusIngredientCodeSequence"},
    {0X00189340, DCM_VR_TAG_SQ, "ContrastAdministrationProfileSequence"},
    {0X00189341, DCM_VR_TAG_SQ, "ContrastBolusUsageSequence"},
    {0X00189342, DCM_VR_TAG_CS, "ContrastBolusAgentAdministered"},
    {0X00189343, DCM_VR_TAG_CS, "ContrastBolusAgentDetected"},
    {0X00189344, DCM_VR_TAG_CS, "ContrastBolusAgentPhase"},
    {0X00189345, DCM_VR_TAG_FD, "CTDIvol"},
    {0X00189346, DCM_VR_TAG_SQ, "CTDIPhantomTypeCodeSequence"},
    {0X00189351, DCM_VR_TAG_FL, "CalciumScoringMassFactorPatient"},
    {0X00189352, DCM_VR_TAG_FL, "CalciumScoringMassFactorDevice"},
    {0X00189353, DCM_VR_TAG_FL, "EnergyWeightingFactor"},
    {0X00189360, DCM_VR_TAG_SQ, "CTAdditionalXRaySourceSequence"},
    {0X00189361, DCM_VR_TAG_CS, "MultienergyCTAcquisition"},
    {0X00189362, DCM_VR_TAG_SQ, "MultienergyCTAcquisitionSequence"},
    {0X00189363, DCM_VR_TAG_SQ, "MultienergyCTProcessingSequence"},
    {0X00189364, DCM_VR_TAG_SQ, "MultienergyCTCharacteristicsSequence"},
    {0X00189365, DCM_VR_TAG_SQ, "MultienergyCTXRaySourceSequence"},
    {0X00189366, DCM_VR_TAG_US, "XRaySourceIndex"},
    {0X00189367, DCM_VR_TAG_UC, "XRaySourceID"},
    {0X00189368, DCM_VR_TAG_CS, "MultienergySourceTechnique"},
    {0X00189369, DCM_VR_TAG_DT, "SourceStartDateTime"},
    {0X0018936A, DCM_VR_TAG_DT, "SourceEndDateTime"},
    {0X0018936B, DCM_VR_TAG_US, "SwitchingPhaseNumber"},
    {0X0018936C, DCM_VR_TAG_DS, "SwitchingPhaseNominalDuration"},
    {0X0018936D, DCM_VR_TAG_DS, "SwitchingPhaseTransitionDuration"},
    {0X0018936E, DCM_VR_TAG_DS, "EffectiveBinEnergy"},
    {0X0018936F, DCM_VR_TAG_SQ, "MultienergyCTXRayDetectorSequence"},
    {0X00189370, DCM_VR_TAG_US, "XRayDetectorIndex"},
    {0X00189371, DCM_VR_TAG_UC, "XRayDetectorID"},
    {0X00189372, DCM_VR_TAG_CS, "MultienergyDetectorType"},
    {0X00189373, DCM_VR_TAG_ST, "XRayDetectorLabel"},
    {0X00189374, DCM_VR_TAG_DS, "NominalMaxEnergy"},
    {0X00189375, DCM_VR_TAG_DS, "NominalMinEnergy"},
    {0X00189376, DCM_VR_TAG_US, "ReferencedXRayDetectorIndex"},
    {0X00189377, DCM_VR_TAG_US, "ReferencedXRaySourceIndex"},
    {0X00189378, DCM_VR_TAG_US, "ReferencedPathIndex"},
    {0X00189379, DCM_VR_TAG_SQ, "MultienergyCTPathSequence"},
    {0X0018937A, DCM_VR_TAG_US, "MultienergyCTPathIndex"},
    {0X0018937B, DCM_VR_TAG_UT, "MultienergyAcquisitionDescription"},
    {0X0018937C, DCM_VR_TAG_FD, "MonoenergeticEnergyEquivalent"},
    {0X0018937D, DCM_VR_TAG_SQ, "MaterialCodeSequence"},
    {0X0018937E, DCM_VR_TAG_CS, "DecompositionMethod"},
    {0X0018937F, DCM_VR_TAG_UT, "DecompositionDescription"},
    {0X00189380, DCM_VR_TAG_SQ, "DecompositionAlgorithmIdentificationSequence"},
    {0X00189381, DCM_VR_TAG_SQ, "DecompositionMaterialSequence"},
    {0X00189382, DCM_VR_TAG_SQ, "MaterialAttenuationSequence"},
    {0X00189383, DCM_VR_TAG_DS, "PhotonEnergy"},
    {0X00189384, DCM_VR_TAG_DS, "XRayMassAttenuationCoefficient"},
    {0X00189401, DCM_VR_TAG_SQ, "ProjectionPixelCalibrationSequence"},
    {0X00189402, DCM_VR_TAG_FL, "DistanceSourceToIsocenter"},
    {0X00189403, DCM_VR_TAG_FL, "DistanceObjectToTableTop"},
    {0X00189404, DCM_VR_TAG_FL, "ObjectPixelSpacingInCenterOfBeam"},
    {0X00189405, DCM_VR_TAG_SQ, "PositionerPositionSequence"},
    {0X00189406, DCM_VR_TAG_SQ, "TablePositionSequence"},
    {0X00189407, DCM_VR_TAG_SQ, "CollimatorShapeSequence"},
    {0X00189410, DCM_VR_TAG_CS, "PlanesInAcquisition"},
    {0X00189412, DCM_VR_TAG_SQ, "XAXRFFrameCharacteristicsSequence"},
    {0X00189417, DCM_VR_TAG_SQ, "FrameAcquisitionSequence"},
    {0X00189420, DCM_VR_TAG_CS, "XRayReceptorType"},
    {0X00189423, DCM_VR_TAG_LO, "AcquisitionProtocolName"},
    {0X00189424, DCM_VR_TAG_LT, "AcquisitionProtocolDescription"},
    {0X00189425, DCM_VR_TAG_CS, "ContrastBolusIngredientOpaque"},
    {0X00189426, DCM_VR_TAG_FL, "DistanceReceptorPlaneToDetectorHousing"},
    {0X00189427, DCM_VR_TAG_CS, "IntensifierActiveShape"},
    {0X00189428, DCM_VR_TAG_FL, "IntensifierActiveDimensions"},
    {0X00189429, DCM_VR_TAG_FL, "PhysicalDetectorSize"},
    {0X00189430, DCM_VR_TAG_FL, "PositionOfIsocenterProjection"},
    {0X00189432, DCM_VR_TAG_SQ, "FieldOfViewSequence"},
    {0X00189433, DCM_VR_TAG_LO, "FieldOfViewDescription"},
    {0X00189434, DCM_VR_TAG_SQ, "ExposureControlSensingRegionsSequence"},
    {0X00189435, DCM_VR_TAG_CS, "ExposureControlSensingRegionShape"},
    {0X00189436, DCM_VR_TAG_SS, "ExposureControlSensingRegionLeftVerticalEdge"},
    {0X00189437, DCM_VR_TAG_SS, "ExposureControlSensingRegionRightVerticalEdge"},
    {0X00189438, DCM_VR_TAG_SS, "ExposureControlSensingRegionUpperHorizontalEdge"},
    {0X00189439, DCM_VR_TAG_SS, "ExposureControlSensingRegionLowerHorizontalEdge"},
    {0X00189440, DCM_VR_TAG_SS, "CenterOfCircularExposureControlSensingRegion"},
    {0X00189441, DCM_VR_TAG_US, "RadiusOfCircularExposureControlSensingRegion"},
    {0X00189442, DCM_VR_TAG_SS, "VerticesOfThePolygonalExposureControlSensingRegion"},
    {0X00189445, DCM_VR_TAG_OB, ""},
    {0X00189447, DCM_VR_TAG_FL, "ColumnAngulationPatient"},
    {0X00189449, DCM_VR_TAG_FL, "BeamAngle"},
    {0X00189451, DCM_VR_TAG_SQ, "FrameDetectorParametersSequence"},
    {0X00189452, DCM_VR_TAG_FL, "CalculatedAnatomyThickness"},
    {0X00189455, DCM_VR_TAG_SQ, "CalibrationSequence"},
    {0X00189456, DCM_VR_TAG_SQ, "ObjectThicknessSequence"},
    {0X00189457, DCM_VR_TAG_CS, "PlaneIdentification"},
    {0X00189461, DCM_VR_TAG_FL, "FieldOfViewDimensionsInFloat"},
    {0X00189462, DCM_VR_TAG_SQ, "IsocenterReferenceSystemSequence"},
    {0X00189463, DCM_VR_TAG_FL, "PositionerIsocenterPrimaryAngle"},
    {0X00189464, DCM_VR_TAG_FL, "PositionerIsocenterSecondaryAngle"},
    {0X00189465, DCM_VR_TAG_FL, "PositionerIsocenterDetectorRotationAngle"},
    {0X00189466, DCM_VR_TAG_FL, "TableXPositionToIsocenter"},
    {0X00189467, DCM_VR_TAG_FL, "TableYPositionToIsocenter"},
    {0X00189468, DCM_VR_TAG_FL, "TableZPositionToIsocenter"},
    {0X00189469, DCM_VR_TAG_FL, "TableHorizontalRotationAngle"},
    {0X00189470, DCM_VR_TAG_FL, "TableHeadTiltAngle"},
    {0X00189471, DCM_VR_TAG_FL, "TableCradleTiltAngle"},
    {0X00189472, DCM_VR_TAG_SQ, "FrameDisplayShutterSequence"},
    {0X00189473, DCM_VR_TAG_FL, "AcquiredImageAreaDoseProduct"},
    {0X00189474, DCM_VR_TAG_CS, "CArmPositionerTabletopRelationship"},
    {0X00189476, DCM_VR_TAG_SQ, "XRayGeometrySequence"},
    {0X00189477, DCM_VR_TAG_SQ, "IrradiationEventIdentificationSequence"},
    {0X00189504, DCM_VR_TAG_SQ, "XRay3DFrameTypeSequence"},
    {0X00189506, DCM_VR_TAG_SQ, "ContributingSourcesSequence"},
    {0X00189507, DCM_VR_TAG_SQ, "XRay3DAcquisitionSequence"},
    {0X00189508, DCM_VR_TAG_FL, "PrimaryPositionerScanArc"},
    {0X00189509, DCM_VR_TAG_FL, "SecondaryPositionerScanArc"},
    {0X00189510, DCM_VR_TAG_FL, "PrimaryPositionerScanStartAngle"},
    {0X00189511, DCM_VR_TAG_FL, "SecondaryPositionerScanStartAngle"},
    {0X00189514, DCM_VR_TAG_FL, "PrimaryPositionerIncrement"},
    {0X00189515, DCM_VR_TAG_FL, "SecondaryPositionerIncrement"},
    {0X00189516, DCM_VR_TAG_DT, "StartAcquisitionDateTime"},
    {0X00189517, DCM_VR_TAG_DT, "EndAcquisitionDateTime"},
    {0X00189518, DCM_VR_TAG_SS, "PrimaryPositionerIncrementSign"},
    {0X00189519, DCM_VR_TAG_SS, "SecondaryPositionerIncrementSign"},
    {0X00189524, DCM_VR_TAG_LO, "ApplicationName"},
    {0X00189525, DCM_VR_TAG_LO, "ApplicationVersion"},
    {0X00189526, DCM_VR_TAG_LO, "ApplicationManufacturer"},
    {0X00189527, DCM_VR_TAG_CS, "AlgorithmType"},
    {0X00189528, DCM_VR_TAG_LO, "AlgorithmDescription"},
    {0X00189530, DCM_VR_TAG_SQ, "XRay3DReconstructionSequence"},
    {0X00189531, DCM_VR_TAG_LO, "ReconstructionDescription"},
    {0X00189538, DCM_VR_TAG_SQ, "PerProjectionAcquisitionSequence"},
    {0X00189541, DCM_VR_TAG_SQ, "DetectorPositionSequence"},
    {0X00189542, DCM_VR_TAG_SQ, "XRayAcquisitionDoseSequence"},
    {0X00189543, DCM_VR_TAG_FD, "XRaySourceIsocenterPrimaryAngle"},
    {0X00189544, DCM_VR_TAG_FD, "XRaySourceIsocenterSecondaryAngle"},
    {0X00189545, DCM_VR_TAG_FD, "BreastSupportIsocenterPrimaryAngle"},
    {0X00189546, DCM_VR_TAG_FD, "BreastSupportIsocenterSecondaryAngle"},
    {0X00189547, DCM_VR_TAG_FD, "BreastSupportXPositionToIsocenter"},
    {0X00189548, DCM_VR_TAG_FD, "BreastSupportYPositionToIsocenter"},
    {0X00189549, DCM_VR_TAG_FD, "BreastSupportZPositionToIsocenter"},
    {0X00189550, DCM_VR_TAG_FD, "DetectorIsocenterPrimaryAngle"},
    {0X00189551, DCM_VR_TAG_FD, "DetectorIsocenterSecondaryAngle"},
    {0X00189552, DCM_VR_TAG_FD, "DetectorXPositionToIsocenter"},
    {0X00189553, DCM_VR_TAG_FD, "DetectorYPositionToIsocenter"},
    {0X00189554, DCM_VR_TAG_FD, "DetectorZPositionToIsocenter"},
    {0X00189555, DCM_VR_TAG_SQ, "XRayGridSequence"},
    {0X00189556, DCM_VR_TAG_SQ, "XRayFilterSequence"},
    {0X00189557, DCM_VR_TAG_FD, "DetectorActiveAreaTLHCPosition"},
    {0X00189558, DCM_VR_TAG_FD, "DetectorActiveAreaOrientation"},
    {0X00189559, DCM_VR_TAG_CS, "PositionerPrimaryAngleDirection"},
    {0X00189601, DCM_VR_TAG_SQ, "DiffusionBMatrixSequence"},
    {0X00189602, DCM_VR_TAG_FD, "DiffusionBValueXX"},
    {0X00189603, DCM_VR_TAG_FD, "DiffusionBValueXY"},
    {0X00189604, DCM_VR_TAG_FD, "DiffusionBValueXZ"},
    {0X00189605, DCM_VR_TAG_FD, "DiffusionBValueYY"},
    {0X00189606, DCM_VR_TAG_FD, "DiffusionBValueYZ"},
    {0X00189607, DCM_VR_TAG_FD, "DiffusionBValueZZ"},
    {0X00189621, DCM_VR_TAG_SQ, "FunctionalMRSequence"},
    {0X00189622, DCM_VR_TAG_CS, "FunctionalSettlingPhaseFramesPresent"},
    {0X00189623, DCM_VR_TAG_DT, "FunctionalSyncPulse"},
    {0X00189624, DCM_VR_TAG_CS, "SettlingPhaseFrame"},
    {0X00189701, DCM_VR_TAG_DT, "DecayCorrectionDateTime"},
    {0X00189715, DCM_VR_TAG_FD, "StartDensityThreshold"},
    {0X00189716, DCM_VR_TAG_FD, "StartRelativeDensityDifferenceThreshold"},
    {0X00189717, DCM_VR_TAG_FD, "StartCardiacTriggerCountThreshold"},
    {0X00189718, DCM_VR_TAG_FD, "StartRespiratoryTriggerCountThreshold"},
    {0X00189719, DCM_VR_TAG_FD, "TerminationCountsThreshold"},
    {0X00189720, DCM_VR_TAG_FD, "TerminationDensityThreshold"},
    {0X00189721, DCM_VR_TAG_FD, "TerminationRelativeDensityThreshold"},
    {0X00189722, DCM_VR_TAG_FD, "TerminationTimeThreshold"},
    {0X00189723, DCM_VR_TAG_FD, "TerminationCardiacTriggerCountThreshold"},
    {0X00189724, DCM_VR_TAG_FD, "TerminationRespiratoryTriggerCountThreshold"},
    {0X00189725, DCM_VR_TAG_CS, "DetectorGeometry"},
    {0X00189726, DCM_VR_TAG_FD, "TransverseDetectorSeparation"},
    {0X00189727, DCM_VR_TAG_FD, "AxialDetectorDimension"},
    {0X00189729, DCM_VR_TAG_US, "RadiopharmaceuticalAgentNumber"},
    {0X00189732, DCM_VR_TAG_SQ, "PETFrameAcquisitionSequence"},
    {0X00189733, DCM_VR_TAG_SQ, "PETDetectorMotionDetailsSequence"},
    {0X00189734, DCM_VR_TAG_SQ, "PETTableDynamicsSequence"},
    {0X00189735, DCM_VR_TAG_SQ, "PETPositionSequence"},
    {0X00189736, DCM_VR_TAG_SQ, "PETFrameCorrectionFactorsSequence"},
    {0X00189737, DCM_VR_TAG_SQ, "RadiopharmaceuticalUsageSequence"},
    {0X00189738, DCM_VR_TAG_CS, "AttenuationCorrectionSource"},
    {0X00189739, DCM_VR_TAG_US, "NumberOfIterations"},
    {0X00189740, DCM_VR_TAG_US, "NumberOfSubsets"},
    {0X00189749, DCM_VR_TAG_SQ, "PETReconstructionSequence"},
    {0X00189751, DCM_VR_TAG_SQ, "PETFrameTypeSequence"},
    {0X00189755, DCM_VR_TAG_CS, "TimeOfFlightInformationUsed"},
    {0X00189756, DCM_VR_TAG_CS, "ReconstructionType"},
    {0X00189758, DCM_VR_TAG_CS, "DecayCorrected"},
    {0X00189759, DCM_VR_TAG_CS, "AttenuationCorrected"},
    {0X00189760, DCM_VR_TAG_CS, "ScatterCorrected"},
    {0X00189761, DCM_VR_TAG_CS, "DeadTimeCorrected"},
    {0X00189762, DCM_VR_TAG_CS, "GantryMotionCorrected"},
    {0X00189763, DCM_VR_TAG_CS, "PatientMotionCorrected"},
    {0X00189764, DCM_VR_TAG_CS, "CountLossNormalizationCorrected"},
    {0X00189765, DCM_VR_TAG_CS, "RandomsCorrected"},
    {0X00189766, DCM_VR_TAG_CS, "NonUniformRadialSamplingCorrected"},
    {0X00189767, DCM_VR_TAG_CS, "SensitivityCalibrated"},
    {0X00189768, DCM_VR_TAG_CS, "DetectorNormalizationCorrection"},
    {0X00189769, DCM_VR_TAG_CS, "IterativeReconstructionMethod"},
    {0X00189770, DCM_VR_TAG_CS, "AttenuationCorrectionTemporalRelationship"},
    {0X00189771, DCM_VR_TAG_SQ, "PatientPhysiologicalStateSequence"},
    {0X00189772, DCM_VR_TAG_SQ, "PatientPhysiologicalStateCodeSequence"},
    {0X00189801, DCM_VR_TAG_FD, "DepthsOfFocus"},
    {0X00189803, DCM_VR_TAG_SQ, "ExcludedIntervalsSequence"},
    {0X00189804, DCM_VR_TAG_DT, "ExclusionStartDateTime"},
    {0X00189805, DCM_VR_TAG_FD, "ExclusionDuration"},
    {0X00189806, DCM_VR_TAG_SQ, "USImageDescriptionSequence"},
    {0X00189807, DCM_VR_TAG_SQ, "ImageDataTypeSequence"},
    {0X00189808, DCM_VR_TAG_CS, "DataType"},
    {0X00189809, DCM_VR_TAG_SQ, "TransducerScanPatternCodeSequence"},
    {0X0018980B, DCM_VR_TAG_CS, "AliasedDataType"},
    {0X0018980C, DCM_VR_TAG_CS, "PositionMeasuringDeviceUsed"},
    {0X0018980D, DCM_VR_TAG_SQ, "TransducerGeometryCodeSequence"},
    {0X0018980E, DCM_VR_TAG_SQ, "TransducerBeamSteeringCodeSequence"},
    {0X0018980F, DCM_VR_TAG_SQ, "TransducerApplicationCodeSequence"},
    {0X00189810, DCM_VR_TAG_US_SS, "ZeroVelocityPixelValue"},
    {0X00189900, DCM_VR_TAG_LO, "ReferenceLocationLabel"},
    {0X00189901, DCM_VR_TAG_UT, "ReferenceLocationDescription"},
    {0X00189902, DCM_VR_TAG_SQ, "ReferenceBasisCodeSequence"},
    {0X00189903, DCM_VR_TAG_SQ, "ReferenceGeometryCodeSequence"},
    {0X00189904, DCM_VR_TAG_DS, "OffsetDistance"},
    {0X00189905, DCM_VR_TAG_CS, "OffsetDirection"},
    {0X00189906, DCM_VR_TAG_SQ, "PotentialScheduledProtocolCodeSequence"},
    {0X00189907, DCM_VR_TAG_SQ, "PotentialRequestedProcedureCodeSequence"},
    {0X00189908, DCM_VR_TAG_UC, "PotentialReasonsForProcedure"},
    {0X00189909, DCM_VR_TAG_SQ, "PotentialReasonsForProcedureCodeSequence"},
    {0X0018990A, DCM_VR_TAG_UC, "PotentialDiagnosticTasks"},
    {0X0018990B, DCM_VR_TAG_SQ, "ContraindicationsCodeSequence"},
    {0X0018990C, DCM_VR_TAG_SQ, "ReferencedDefinedProtocolSequence"},
    {0X0018990D, DCM_VR_TAG_SQ, "ReferencedPerformedProtocolSequence"},
    {0X0018990E, DCM_VR_TAG_SQ, "PredecessorProtocolSequence"},
    {0X0018990F, DCM_VR_TAG_UT, "ProtocolPlanningInformation"},
    {0X00189910, DCM_VR_TAG_UT, "ProtocolDesignRationale"},
    {0X00189911, DCM_VR_TAG_SQ, "PatientSpecificationSequence"},
    {0X00189912, DCM_VR_TAG_SQ, "ModelSpecificationSequence"},
    {0X00189913, DCM_VR_TAG_SQ, "ParametersSpecificationSequence"},
    {0X00189914, DCM_VR_TAG_SQ, "InstructionSequence"},
    {0X00189915, DCM_VR_TAG_US, "InstructionIndex"},
    {0X00189916, DCM_VR_TAG_LO, "InstructionText"},
    {0X00189917, DCM_VR_TAG_UT, "InstructionDescription"},
    {0X00189918, DCM_VR_TAG_CS, "InstructionPerformedFlag"},
    {0X00189919, DCM_VR_TAG_DT, "InstructionPerformedDateTime"},
    {0X0018991A, DCM_VR_TAG_UT, "InstructionPerformanceComment"},
    {0X0018991B, DCM_VR_TAG_SQ, "PatientPositioningInstructionSequence"},
    {0X0018991C, DCM_VR_TAG_SQ, "PositioningMethodCodeSequence"},
    {0X0018991D, DCM_VR_TAG_SQ, "PositioningLandmarkSequence"},
    {0X0018991E, DCM_VR_TAG_UI, "TargetFrameOfReferenceUID"},
    {0X0018991F, DCM_VR_TAG_SQ, "AcquisitionProtocolElementSpecificationSequence"},
    {0X00189920, DCM_VR_TAG_SQ, "AcquisitionProtocolElementSequence"},
    {0X00189921, DCM_VR_TAG_US, "ProtocolElementNumber"},
    {0X00189922, DCM_VR_TAG_LO, "ProtocolElementName"},
    {0X00189923, DCM_VR_TAG_UT, "ProtocolElementCharacteristicsSummary"},
    {0X00189924, DCM_VR_TAG_UT, "ProtocolElementPurpose"},
    {0X00189930, DCM_VR_TAG_CS, "AcquisitionMotion"},
    {0X00189931, DCM_VR_TAG_SQ, "AcquisitionStartLocationSequence"},
    {0X00189932, DCM_VR_TAG_SQ, "AcquisitionEndLocationSequence"},
    {0X00189933, DCM_VR_TAG_SQ, "ReconstructionProtocolElementSpecificationSequence"},
    {0X00189934, DCM_VR_TAG_SQ, "ReconstructionProtocolElementSequence"},
    {0X00189935, DCM_VR_TAG_SQ, "StorageProtocolElementSpecificationSequence"},
    {0X00189936, DCM_VR_TAG_SQ, "StorageProtocolElementSequence"},
    {0X00189937, DCM_VR_TAG_LO, "RequestedSeriesDescription"},
    {0X00189938, DCM_VR_TAG_US, "SourceAcquisitionProtocolElementNumber"},
    {0X00189939, DCM_VR_TAG_US, "SourceAcquisitionBeamNumber"},
    {0X0018993A, DCM_VR_TAG_US, "SourceReconstructionProtocolElementNumber"},
    {0X0018993B, DCM_VR_TAG_SQ, "ReconstructionStartLocationSequence"},
    {0X0018993C, DCM_VR_TAG_SQ, "ReconstructionEndLocationSequence"},
    {0X0018993D, DCM_VR_TAG_SQ, "ReconstructionAlgorithmSequence"},
    {0X0018993E, DCM_VR_TAG_SQ, "ReconstructionTargetCenterLocationSequence"},
    {0X00189941, DCM_VR_TAG_UT, "ImageFilterDescription"},
    {0X00189942, DCM_VR_TAG_FD, "CTDIvolNotificationTrigger"},
    {0X00189943, DCM_VR_TAG_FD, "DLPNotificationTrigger"},
    {0X00189944, DCM_VR_TAG_CS, "AutoKVPSelectionType"},
    {0X00189945, DCM_VR_TAG_FD, "AutoKVPUpperBound"},
    {0X00189946, DCM_VR_TAG_FD, "AutoKVPLowerBound"},
    {0X00189947, DCM_VR_TAG_CS, "ProtocolDefinedPatientPosition"},
    {0X0018A001, DCM_VR_TAG_SQ, "ContributingEquipmentSequence"},
    {0X0018A002, DCM_VR_TAG_DT, "ContributionDateTime"},
    {0X0018A003, DCM_VR_TAG_ST, "ContributionDescription"},
    {0X0020000D, DCM_VR_TAG_UI, "StudyInstanceUID"},
    {0X0020000E, DCM_VR_TAG_UI, "SeriesInstanceUID"},
    {0X00200010, DCM_VR_TAG_SH, "StudyID"},
    {0X00200011, DCM_VR_TAG_IS, "SeriesNumber"},
    {0X00200012, DCM_VR_TAG_IS, "AcquisitionNumber"},
    {0X00200013, DCM_VR_TAG_IS, "InstanceNumber"},
    {0X00200014, DCM_VR_TAG_IS, "IsotopeNumber"},
    {0X00200015, DCM_VR_TAG_IS, "PhaseNumber"},
    {0X00200016, DCM_VR_TAG_IS, "IntervalNumber"},
    {0X00200017, DCM_VR_TAG_IS, "TimeSlotNumber"},
    {0X00200018, DCM_VR_TAG_IS, "AngleNumber"},
    {0X00200019, DCM_VR_TAG_IS, "ItemNumber"},
    {0X00200020, DCM_VR_TAG_CS, "PatientOrientation"},
    {0X00200022, DCM_VR_TAG_IS, "OverlayNumber"},
    {0X00200024, DCM_VR_TAG_IS, "CurveNumber"},
    {0X00200026, DCM_VR_TAG_IS, "LUTNumber"},
    {0X00200030, DCM_VR_TAG_DS, "ImagePosition"},
    {0X00200032, DCM_VR_TAG_DS, "ImagePositionPatient"},
    {0X00200035, DCM_VR_TAG_DS, "ImageOrientation"},
    {0X00200037, DCM_VR_TAG_DS, "ImageOrientationPatient"},
    {0X00200050, DCM_VR_TAG_DS, "Location"},
    {0X00200052, DCM_VR_TAG_UI, "FrameOfReferenceUID"},
    {0X00200060, DCM_VR_TAG_CS, "Laterality"},
    {0X00200062, DCM_VR_TAG_CS, "ImageLaterality"},
    {0X00200070, DCM_VR_TAG_LO, "ImageGeometryType"},
    {0X00200080, DCM_VR_TAG_CS, "MaskingImage"},
    {0X002000AA, DCM_VR_TAG_IS, "ReportNumber"},
    {0X00200100, DCM_VR_TAG_IS, "TemporalPositionIdentifier"},
    {0X00200105, DCM_VR_TAG_IS, "NumberOfTemporalPositions"},
    {0X00200110, DCM_VR_TAG_DS, "TemporalResolution"},
    {0X00200200, DCM_VR_TAG_UI, "SynchronizationFrameOfReferenceUID"},
    {0X00200242, DCM_VR_TAG_UI, "SOPInstanceUIDOfConcatenationSource"},
    {0X00201000, DCM_VR_TAG_IS, "SeriesInStudy"},
    {0X00201001, DCM_VR_TAG_IS, "AcquisitionsInSeries"},
    {0X00201002, DCM_VR_TAG_IS, "ImagesInAcquisition"},
    {0X00201003, DCM_VR_TAG_IS, "ImagesInSeries"},
    {0X00201004, DCM_VR_TAG_IS, "AcquisitionsInStudy"},
    {0X00201005, DCM_VR_TAG_IS, "ImagesInStudy"},
    {0X00201020, DCM_VR_TAG_LO, "Reference"},
    {0X0020103F, DCM_VR_TAG_LO, "TargetPositionReferenceIndicator"},
    {0X00201040, DCM_VR_TAG_LO, "PositionReferenceIndicator"},
    {0X00201041, DCM_VR_TAG_DS, "SliceLocation"},
    {0X00201070, DCM_VR_TAG_IS, "OtherStudyNumbers"},
    {0X00201200, DCM_VR_TAG_IS, "NumberOfPatientRelatedStudies"},
    {0X00201202, DCM_VR_TAG_IS, "NumberOfPatientRelatedSeries"},
    {0X00201204, DCM_VR_TAG_IS, "NumberOfPatientRelatedInstances"},
    {0X00201206, DCM_VR_TAG_IS, "NumberOfStudyRelatedSeries"},
    {0X00201208, DCM_VR_TAG_IS, "NumberOfStudyRelatedInstances"},
    {0X00201209, DCM_VR_TAG_IS, "NumberOfSeriesRelatedInstances"},
    {0X00203401, DCM_VR_TAG_CS, "ModifyingDeviceID"},
    {0X00203402, DCM_VR_TAG_CS, "ModifiedImageID"},
    {0X00203403, DCM_VR_TAG_DA, "ModifiedImageDate"},
    {0X00203404, DCM_VR_TAG_LO, "ModifyingDeviceManufacturer"},
    {0X00203405, DCM_VR_TAG_TM, "ModifiedImageTime"},
    {0X00203406, DCM_VR_TAG_LO, "ModifiedImageDescription"},
    {0X00204000, DCM_VR_TAG_LT, "ImageComments"},
    {0X00205000, DCM_VR_TAG_AT, "OriginalImageIdentification"},
    {0X00205002, DCM_VR_TAG_LO, "OriginalImageIdentificationNomenclature"},
    {0X00209056, DCM_VR_TAG_SH, "StackID"},
    {0X00209057, DCM_VR_TAG_UL, "InStackPositionNumber"},
    {0X00209071, DCM_VR_TAG_SQ, "FrameAnatomySequence"},
    {0X00209072, DCM_VR_TAG_CS, "FrameLaterality"},
    {0X00209111, DCM_VR_TAG_SQ, "FrameContentSequence"},
    {0X00209113, DCM_VR_TAG_SQ, "PlanePositionSequence"},
    {0X00209116, DCM_VR_TAG_SQ, "PlaneOrientationSequence"},
    {0X00209128, DCM_VR_TAG_UL, "TemporalPositionIndex"},
    {0X00209153, DCM_VR_TAG_FD, "NominalCardiacTriggerDelayTime"},
    {0X00209154, DCM_VR_TAG_FL, "NominalCardiacTriggerTimePriorToRPeak"},
    {0X00209155, DCM_VR_TAG_FL, "ActualCardiacTriggerTimePriorToRPeak"},
    {0X00209156, DCM_VR_TAG_US, "FrameAcquisitionNumber"},
    {0X00209157, DCM_VR_TAG_UL, "DimensionIndexValues"},
    {0X00209158, DCM_VR_TAG_LT, "FrameComments"},
    {0X00209161, DCM_VR_TAG_UI, "ConcatenationUID"},
    {0X00209162, DCM_VR_TAG_US, "InConcatenationNumber"},
    {0X00209163, DCM_VR_TAG_US, "InConcatenationTotalNumber"},
    {0X00209164, DCM_VR_TAG_UI, "DimensionOrganizationUID"},
    {0X00209165, DCM_VR_TAG_AT, "DimensionIndexPointer"},
    {0X00209167, DCM_VR_TAG_AT, "FunctionalGroupPointer"},
    {0X00209170, DCM_VR_TAG_SQ, "UnassignedSharedConvertedAttributesSequence"},
    {0X00209171, DCM_VR_TAG_SQ, "UnassignedPerFrameConvertedAttributesSequence"},
    {0X00209172, DCM_VR_TAG_SQ, "ConversionSourceAttributesSequence"},
    {0X00209213, DCM_VR_TAG_LO, "DimensionIndexPrivateCreator"},
    {0X00209221, DCM_VR_TAG_SQ, "DimensionOrganizationSequence"},
    {0X00209222, DCM_VR_TAG_SQ, "DimensionIndexSequence"},
    {0X00209228, DCM_VR_TAG_UL, "ConcatenationFrameOffsetNumber"},
    {0X00209238, DCM_VR_TAG_LO, "FunctionalGroupPrivateCreator"},
    {0X00209241, DCM_VR_TAG_FL, "NominalPercentageOfCardiacPhase"},
    {0X00209245, DCM_VR_TAG_FL, "NominalPercentageOfRespiratoryPhase"},
    {0X00209246, DCM_VR_TAG_FL, "StartingRespiratoryAmplitude"},
    {0X00209247, DCM_VR_TAG_CS, "StartingRespiratoryPhase"},
    {0X00209248, DCM_VR_TAG_FL, "EndingRespiratoryAmplitude"},
    {0X00209249, DCM_VR_TAG_CS, "EndingRespiratoryPhase"},
    {0X00209250, DCM_VR_TAG_CS, "RespiratoryTriggerType"},
    {0X00209251, DCM_VR_TAG_FD, "RRIntervalTimeNominal"},
    {0X00209252, DCM_VR_TAG_FD, "ActualCardiacTriggerDelayTime"},
    {0X00209253, DCM_VR_TAG_SQ, "RespiratorySynchronizationSequence"},
    {0X00209254, DCM_VR_TAG_FD, "RespiratoryIntervalTime"},
    {0X00209255, DCM_VR_TAG_FD, "NominalRespiratoryTriggerDelayTime"},
    {0X00209256, DCM_VR_TAG_FD, "RespiratoryTriggerDelayThreshold"},
    {0X00209257, DCM_VR_TAG_FD, "ActualRespiratoryTriggerDelayTime"},
    {0X00209301, DCM_VR_TAG_FD, "ImagePositionVolume"},
    {0X00209302, DCM_VR_TAG_FD, "ImageOrientationVolume"},
    {0X00209307, DCM_VR_TAG_CS, "UltrasoundAcquisitionGeometry"},
    {0X00209308, DCM_VR_TAG_FD, "ApexPosition"},
    {0X00209309, DCM_VR_TAG_FD, "VolumeToTransducerMappingMatrix"},
    {0X0020930A, DCM_VR_TAG_FD, "VolumeToTableMappingMatrix"},
    {0X0020930B, DCM_VR_TAG_CS, "VolumeToTransducerRelationship"},
    {0X0020930C, DCM_VR_TAG_CS, "PatientFrameOfReferenceSource"},
    {0X0020930D, DCM_VR_TAG_FD, "TemporalPositionTimeOffset"},
    {0X0020930E, DCM_VR_TAG_SQ, "PlanePositionVolumeSequence"},
    {0X0020930F, DCM_VR_TAG_SQ, "PlaneOrientationVolumeSequence"},
    {0X00209310, DCM_VR_TAG_SQ, "TemporalPositionSequence"},
    {0X00209311, DCM_VR_TAG_CS, "DimensionOrganizationType"},
    {0X00209312, DCM_VR_TAG_UI, "VolumeFrameOfReferenceUID"},
    {0X00209313, DCM_VR_TAG_UI, "TableFrameOfReferenceUID"},
    {0X00209421, DCM_VR_TAG_LO, "DimensionDescriptionLabel"},
    {0X00209450, DCM_VR_TAG_SQ, "PatientOrientationInFrameSequence"},
    {0X00209453, DCM_VR_TAG_LO, "FrameLabel"},
    {0X00209518, DCM_VR_TAG_US, "AcquisitionIndex"},
    {0X00209529, DCM_VR_TAG_SQ, "ContributingSOPInstancesReferenceSequence"},
    {0X00209536, DCM_VR_TAG_US, "ReconstructionIndex"},
    {0X00220001, DCM_VR_TAG_US, "LightPathFilterPassThroughWavelength"},
    {0X00220002, DCM_VR_TAG_US, "LightPathFilterPassBand"},
    {0X00220003, DCM_VR_TAG_US, "ImagePathFilterPassThroughWavelength"},
    {0X00220004, DCM_VR_TAG_US, "ImagePathFilterPassBand"},
    {0X00220005, DCM_VR_TAG_CS, "PatientEyeMovementCommanded"},
    {0X00220006, DCM_VR_TAG_SQ, "PatientEyeMovementCommandCodeSequence"},
    {0X00220007, DCM_VR_TAG_FL, "SphericalLensPower"},
    {0X00220008, DCM_VR_TAG_FL, "CylinderLensPower"},
    {0X00220009, DCM_VR_TAG_FL, "CylinderAxis"},
    {0X0022000A, DCM_VR_TAG_FL, "EmmetropicMagnification"},
    {0X0022000B, DCM_VR_TAG_FL, "IntraOcularPressure"},
    {0X0022000C, DCM_VR_TAG_FL, "HorizontalFieldOfView"},
    {0X0022000D, DCM_VR_TAG_CS, "PupilDilated"},
    {0X0022000E, DCM_VR_TAG_FL, "DegreeOfDilation"},
    {0X00220010, DCM_VR_TAG_FL, "StereoBaselineAngle"},
    {0X00220011, DCM_VR_TAG_FL, "StereoBaselineDisplacement"},
    {0X00220012, DCM_VR_TAG_FL, "StereoHorizontalPixelOffset"},
    {0X00220013, DCM_VR_TAG_FL, "StereoVerticalPixelOffset"},
    {0X00220014, DCM_VR_TAG_FL, "StereoRotation"},
    {0X00220015, DCM_VR_TAG_SQ, "AcquisitionDeviceTypeCodeSequence"},
    {0X00220016, DCM_VR_TAG_SQ, "IlluminationTypeCodeSequence"},
    {0X00220017, DCM_VR_TAG_SQ, "LightPathFilterTypeStackCodeSequence"},
    {0X00220018, DCM_VR_TAG_SQ, "ImagePathFilterTypeStackCodeSequence"},
    {0X00220019, DCM_VR_TAG_SQ, "LensesCodeSequence"},
    {0X0022001A, DCM_VR_TAG_SQ, "ChannelDescriptionCodeSequence"},
    {0X0022001B, DCM_VR_TAG_SQ, "RefractiveStateSequence"},
    {0X0022001C, DCM_VR_TAG_SQ, "MydriaticAgentCodeSequence"},
    {0X0022001D, DCM_VR_TAG_SQ, "RelativeImagePositionCodeSequence"},
    {0X0022001E, DCM_VR_TAG_FL, "CameraAngleOfView"},
    {0X00220020, DCM_VR_TAG_SQ, "StereoPairsSequence"},
    {0X00220021, DCM_VR_TAG_SQ, "LeftImageSequence"},
    {0X00220022, DCM_VR_TAG_SQ, "RightImageSequence"},
    {0X00220028, DCM_VR_TAG_CS, "StereoPairsPresent"},
    {0X00220030, DCM_VR_TAG_FL, "AxialLengthOfTheEye"},
    {0X00220031, DCM_VR_TAG_SQ, "OphthalmicFrameLocationSequence"},
    {0X00220032, DCM_VR_TAG_FL, "ReferenceCoordinates"},
    {0X00220035, DCM_VR_TAG_FL, "DepthSpatialResolution"},
    {0X00220036, DCM_VR_TAG_FL, "MaximumDepthDistortion"},
    {0X00220037, DCM_VR_TAG_FL, "AlongScanSpatialResolution"},
    {0X00220038, DCM_VR_TAG_FL, "MaximumAlongScanDistortion"},
    {0X00220039, DCM_VR_TAG_CS, "OphthalmicImageOrientation"},
    {0X00220041, DCM_VR_TAG_FL, "DepthOfTransverseImage"},
    {0X00220042, DCM_VR_TAG_SQ, "MydriaticAgentConcentrationUnitsSequence"},
    {0X00220048, DCM_VR_TAG_FL, "AcrossScanSpatialResolution"},
    {0X00220049, DCM_VR_TAG_FL, "MaximumAcrossScanDistortion"},
    {0X0022004E, DCM_VR_TAG_DS, "MydriaticAgentConcentration"},
    {0X00220055, DCM_VR_TAG_FL, "IlluminationWaveLength"},
    {0X00220056, DCM_VR_TAG_FL, "IlluminationPower"},
    {0X00220057, DCM_VR_TAG_FL, "IlluminationBandwidth"},
    {0X00220058, DCM_VR_TAG_SQ, "MydriaticAgentSequence"},
    {0X00221007, DCM_VR_TAG_SQ, "OphthalmicAxialMeasurementsRightEyeSequence"},
    {0X00221008, DCM_VR_TAG_SQ, "OphthalmicAxialMeasurementsLeftEyeSequence"},
    {0X00221009, DCM_VR_TAG_CS, "OphthalmicAxialMeasurementsDeviceType"},
    {0X00221010, DCM_VR_TAG_CS, "OphthalmicAxialLengthMeasurementsType"},
    {0X00221012, DCM_VR_TAG_SQ, "OphthalmicAxialLengthSequence"},
    {0X00221019, DCM_VR_TAG_FL, "OphthalmicAxialLength"},
    {0X00221024, DCM_VR_TAG_SQ, "LensStatusCodeSequence"},
    {0X00221025, DCM_VR_TAG_SQ, "VitreousStatusCodeSequence"},
    {0X00221028, DCM_VR_TAG_SQ, "IOLFormulaCodeSequence"},
    {0X00221029, DCM_VR_TAG_LO, "IOLFormulaDetail"},
    {0X00221033, DCM_VR_TAG_FL, "KeratometerIndex"},
    {0X00221035, DCM_VR_TAG_SQ, "SourceOfOphthalmicAxialLengthCodeSequence"},
    {0X00221036, DCM_VR_TAG_SQ, "SourceOfCornealSizeDataCodeSequence"},
    {0X00221037, DCM_VR_TAG_FL, "TargetRefraction"},
    {0X00221039, DCM_VR_TAG_CS, "RefractiveProcedureOccurred"},
    {0X00221040, DCM_VR_TAG_SQ, "RefractiveSurgeryTypeCodeSequence"},
    {0X00221044, DCM_VR_TAG_SQ, "OphthalmicUltrasoundMethodCodeSequence"},
    {0X00221045, DCM_VR_TAG_SQ, "SurgicallyInducedAstigmatismSequence"},
    {0X00221046, DCM_VR_TAG_CS, "TypeOfOpticalCorrection"},
    {0X00221047, DCM_VR_TAG_SQ, "ToricIOLPowerSequence"},
    {0X00221048, DCM_VR_TAG_SQ, "PredictedToricErrorSequence"},
    {0X00221049, DCM_VR_TAG_CS, "PreSelectedForImplantation"},
    {0X0022104A, DCM_VR_TAG_SQ, "ToricIOLPowerForExactEmmetropiaSequence"},
    {0X0022104B, DCM_VR_TAG_SQ, "ToricIOLPowerForExactTargetRefractionSequence"},
    {0X00221050, DCM_VR_TAG_SQ, "OphthalmicAxialLengthMeasurementsSequence"},
    {0X00221053, DCM_VR_TAG_FL, "IOLPower"},
    {0X00221054, DCM_VR_TAG_FL, "PredictedRefractiveError"},
    {0X00221059, DCM_VR_TAG_FL, "OphthalmicAxialLengthVelocity"},
    {0X00221065, DCM_VR_TAG_LO, "LensStatusDescription"},
    {0X00221066, DCM_VR_TAG_LO, "VitreousStatusDescription"},
    {0X00221090, DCM_VR_TAG_SQ, "IOLPowerSequence"},
    {0X00221092, DCM_VR_TAG_SQ, "LensConstantSequence"},
    {0X00221093, DCM_VR_TAG_LO, "IOLManufacturer"},
    {0X00221094, DCM_VR_TAG_LO, "LensConstantDescription"},
    {0X00221095, DCM_VR_TAG_LO, "ImplantName"},
    {0X00221096, DCM_VR_TAG_SQ, "KeratometryMeasurementTypeCodeSequence"},
    {0X00221097, DCM_VR_TAG_LO, "ImplantPartNumber"},
    {0X00221100, DCM_VR_TAG_SQ, "ReferencedOphthalmicAxialMeasurementsSequence"},
    {0X00221101, DCM_VR_TAG_SQ, "OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence"},
    {0X00221103, DCM_VR_TAG_SQ, "RefractiveErrorBeforeRefractiveSurgeryCodeSequence"},
    {0X00221121, DCM_VR_TAG_FL, "IOLPowerForExactEmmetropia"},
    {0X00221122, DCM_VR_TAG_FL, "IOLPowerForExactTargetRefraction"},
    {0X00221125, DCM_VR_TAG_SQ, "AnteriorChamberDepthDefinitionCodeSequence"},
    {0X00221127, DCM_VR_TAG_SQ, "LensThicknessSequence"},
    {0X00221128, DCM_VR_TAG_SQ, "AnteriorChamberDepthSequence"},
    {0X0022112A, DCM_VR_TAG_SQ, "CalculationCommentSequence"},
    {0X0022112B, DCM_VR_TAG_CS, "CalculationCommentType"},
    {0X0022112C, DCM_VR_TAG_LT, "CalculationComment"},
    {0X00221130, DCM_VR_TAG_FL, "LensThickness"},
    {0X00221131, DCM_VR_TAG_FL, "AnteriorChamberDepth"},
    {0X00221132, DCM_VR_TAG_SQ, "SourceOfLensThicknessDataCodeSequence"},
    {0X00221133, DCM_VR_TAG_SQ, "SourceOfAnteriorChamberDepthDataCodeSequence"},
    {0X00221134, DCM_VR_TAG_SQ, "SourceOfRefractiveMeasurementsSequence"},
    {0X00221135, DCM_VR_TAG_SQ, "SourceOfRefractiveMeasurementsCodeSequence"},
    {0X00221140, DCM_VR_TAG_CS, "OphthalmicAxialLengthMeasurementModified"},
    {0X00221150, DCM_VR_TAG_SQ, "OphthalmicAxialLengthDataSourceCodeSequence"},
    {0X00221153, DCM_VR_TAG_SQ, "OphthalmicAxialLengthAcquisitionMethodCodeSequence"},
    {0X00221155, DCM_VR_TAG_FL, "SignalToNoiseRatio"},
    {0X00221159, DCM_VR_TAG_LO, "OphthalmicAxialLengthDataSourceDescription"},
    {0X00221210, DCM_VR_TAG_SQ, "OphthalmicAxialLengthMeasurementsTotalLengthSequence"},
    {0X00221211, DCM_VR_TAG_SQ, "OphthalmicAxialLengthMeasurementsSegmentalLengthSequence"},
    {0X00221212, DCM_VR_TAG_SQ, "OphthalmicAxialLengthMeasurementsLengthSummationSequence"},
    {0X00221220, DCM_VR_TAG_SQ, "UltrasoundOphthalmicAxialLengthMeasurementsSequence"},
    {0X00221225, DCM_VR_TAG_SQ, "OpticalOphthalmicAxialLengthMeasurementsSequence"},
    {0X00221230, DCM_VR_TAG_SQ, "UltrasoundSelectedOphthalmicAxialLengthSequence"},
    {0X00221250, DCM_VR_TAG_SQ, "OphthalmicAxialLengthSelectionMethodCodeSequence"},
    {0X00221255, DCM_VR_TAG_SQ, "OpticalSelectedOphthalmicAxialLengthSequence"},
    {0X00221257, DCM_VR_TAG_SQ, "SelectedSegmentalOphthalmicAxialLengthSequence"},
    {0X00221260, DCM_VR_TAG_SQ, "SelectedTotalOphthalmicAxialLengthSequence"},
    {0X00221262, DCM_VR_TAG_SQ, "OphthalmicAxialLengthQualityMetricSequence"},
    {0X00221265, DCM_VR_TAG_SQ, "OphthalmicAxialLengthQualityMetricTypeCodeSequence"},
    {0X00221273, DCM_VR_TAG_LO, "OphthalmicAxialLengthQualityMetricTypeDescription"},
    {0X00221300, DCM_VR_TAG_SQ, "IntraocularLensCalculationsRightEyeSequence"},
    {0X00221310, DCM_VR_TAG_SQ, "IntraocularLensCalculationsLeftEyeSequence"},
    {0X00221330, DCM_VR_TAG_SQ, "ReferencedOphthalmicAxialLengthMeasurementQCImageSequence"},
    {0X00221415, DCM_VR_TAG_CS, "OphthalmicMappingDeviceType"},
    {0X00221420, DCM_VR_TAG_SQ, "AcquisitionMethodCodeSequence"},
    {0X00221423, DCM_VR_TAG_SQ, "AcquisitionMethodAlgorithmSequence"},
    {0X00221436, DCM_VR_TAG_SQ, "OphthalmicThicknessMapTypeCodeSequence"},
    {0X00221443, DCM_VR_TAG_SQ, "OphthalmicThicknessMappingNormalsSequence"},
    {0X00221445, DCM_VR_TAG_SQ, "RetinalThicknessDefinitionCodeSequence"},
    {0X00221450, DCM_VR_TAG_SQ, "PixelValueMappingToCodedConceptSequence"},
    {0X00221452, DCM_VR_TAG_US_SS, "MappedPixelValue"},
    {0X00221454, DCM_VR_TAG_LO, "PixelValueMappingExplanation"},
    {0X00221458, DCM_VR_TAG_SQ, "OphthalmicThicknessMapQualityThresholdSequence"},
    {0X00221460, DCM_VR_TAG_FL, "OphthalmicThicknessMapThresholdQualityRating"},
    {0X00221463, DCM_VR_TAG_FL, "AnatomicStructureReferencePoint"},
    {0X00221465, DCM_VR_TAG_SQ, "RegistrationToLocalizerSequence"},
    {0X00221466, DCM_VR_TAG_CS, "RegisteredLocalizerUnits"},
    {0X00221467, DCM_VR_TAG_FL, "RegisteredLocalizerTopLeftHandCorner"},
    {0X00221468, DCM_VR_TAG_FL, "RegisteredLocalizerBottomRightHandCorner"},
    {0X00221470, DCM_VR_TAG_SQ, "OphthalmicThicknessMapQualityRatingSequence"},
    {0X00221472, DCM_VR_TAG_SQ, "RelevantOPTAttributesSequence"},
    {0X00221512, DCM_VR_TAG_SQ, "TransformationMethodCodeSequence"},
    {0X00221513, DCM_VR_TAG_SQ, "TransformationAlgorithmSequence"},
    {0X00221515, DCM_VR_TAG_CS, "OphthalmicAxialLengthMethod"},
    {0X00221517, DCM_VR_TAG_FL, "OphthalmicFOV"},
    {0X00221518, DCM_VR_TAG_SQ, "TwoDimensionalToThreeDimensionalMapSequence"},
    {0X00221525, DCM_VR_TAG_SQ, "WideFieldOphthalmicPhotographyQualityRatingSequence"},
    {0X00221526, DCM_VR_TAG_SQ, "WideFieldOphthalmicPhotographyQualityThresholdSequence"},
    {0X00221527, DCM_VR_TAG_FL, "WideFieldOphthalmicPhotographyThresholdQualityRating"},
    {0X00221528, DCM_VR_TAG_FL, "XCoordinatesCenterPixelViewAngle"},
    {0X00221529, DCM_VR_TAG_FL, "YCoordinatesCenterPixelViewAngle"},
    {0X00221530, DCM_VR_TAG_UL, "NumberOfMapPoints"},
    {0X00221531, DCM_VR_TAG_OF, "TwoDimensionalToThreeDimensionalMapData"},
    {0X00221612, DCM_VR_TAG_SQ, "DerivationAlgorithmSequence"},
    {0X00221615, DCM_VR_TAG_SQ, "OphthalmicImageTypeCodeSequence"},
    {0X00221616, DCM_VR_TAG_LO, "OphthalmicImageTypeDescription"},
    {0X00221618, DCM_VR_TAG_SQ, "ScanPatternTypeCodeSequence"},
    {0X00221620, DCM_VR_TAG_SQ, "ReferencedSurfaceMeshIdentificationSequence"},
    {0X00221622, DCM_VR_TAG_CS, "OphthalmicVolumetricPropertiesFlag"},
    {0X00221624, DCM_VR_TAG_FL, "OphthalmicAnatomicReferencePointXCoordinate"},
    {0X00221626, DCM_VR_TAG_FL, "OphthalmicAnatomicReferencePointYCoordinate"},
    {0X00221628, DCM_VR_TAG_SQ, "OphthalmicEnFaceImageQualityRatingSequence"},
    {0X00221630, DCM_VR_TAG_DS, "QualityThreshold"},
    {0X00221640, DCM_VR_TAG_SQ, "OCTBscanAnalysisAcquisitionParametersSequence"},
    {0X00221642, DCM_VR_TAG_UL, "NumberOfBscansPerFrame"},
    {0X00221643, DCM_VR_TAG_FL, "BscanSlabThickness"},
    {0X00221644, DCM_VR_TAG_FL, "DistanceBetweenBscanSlabs"},
    {0X00221645, DCM_VR_TAG_FL, "BscanCycleTime"},
    {0X00221646, DCM_VR_TAG_FL, "BscanCycleTimeVector"},
    {0X00221649, DCM_VR_TAG_FL, "AscanRate"},
    {0X00221650, DCM_VR_TAG_FL, "BscanRate"},
    {0X00221658, DCM_VR_TAG_UL, "SurfaceMeshZPixelOffset"},
    {0X00240010, DCM_VR_TAG_FL, "VisualFieldHorizontalExtent"},
    {0X00240011, DCM_VR_TAG_FL, "VisualFieldVerticalExtent"},
    {0X00240012, DCM_VR_TAG_CS, "VisualFieldShape"},
    {0X00240016, DCM_VR_TAG_SQ, "ScreeningTestModeCodeSequence"},
    {0X00240018, DCM_VR_TAG_FL, "MaximumStimulusLuminance"},
    {0X00240020, DCM_VR_TAG_FL, "BackgroundLuminance"},
    {0X00240021, DCM_VR_TAG_SQ, "StimulusColorCodeSequence"},
    {0X00240024, DCM_VR_TAG_SQ, "BackgroundIlluminationColorCodeSequence"},
    {0X00240025, DCM_VR_TAG_FL, "StimulusArea"},
    {0X00240028, DCM_VR_TAG_FL, "StimulusPresentationTime"},
    {0X00240032, DCM_VR_TAG_SQ, "FixationSequence"},
    {0X00240033, DCM_VR_TAG_SQ, "FixationMonitoringCodeSequence"},
    {0X00240034, DCM_VR_TAG_SQ, "VisualFieldCatchTrialSequence"},
    {0X00240035, DCM_VR_TAG_US, "FixationCheckedQuantity"},
    {0X00240036, DCM_VR_TAG_US, "PatientNotProperlyFixatedQuantity"},
    {0X00240037, DCM_VR_TAG_CS, "PresentedVisualStimuliDataFlag"},
    {0X00240038, DCM_VR_TAG_US, "NumberOfVisualStimuli"},
    {0X00240039, DCM_VR_TAG_CS, "ExcessiveFixationLossesDataFlag"},
    {0X00240040, DCM_VR_TAG_CS, "ExcessiveFixationLosses"},
    {0X00240042, DCM_VR_TAG_US, "StimuliRetestingQuantity"},
    {0X00240044, DCM_VR_TAG_LT, "CommentsOnPatientPerformanceOfVisualField"},
    {0X00240045, DCM_VR_TAG_CS, "FalseNegativesEstimateFlag"},
    {0X00240046, DCM_VR_TAG_FL, "FalseNegativesEstimate"},
    {0X00240048, DCM_VR_TAG_US, "NegativeCatchTrialsQuantity"},
    {0X00240050, DCM_VR_TAG_US, "FalseNegativesQuantity"},
    {0X00240051, DCM_VR_TAG_CS, "ExcessiveFalseNegativesDataFlag"},
    {0X00240052, DCM_VR_TAG_CS, "ExcessiveFalseNegatives"},
    {0X00240053, DCM_VR_TAG_CS, "FalsePositivesEstimateFlag"},
    {0X00240054, DCM_VR_TAG_FL, "FalsePositivesEstimate"},
    {0X00240055, DCM_VR_TAG_CS, "CatchTrialsDataFlag"},
    {0X00240056, DCM_VR_TAG_US, "PositiveCatchTrialsQuantity"},
    {0X00240057, DCM_VR_TAG_CS, "TestPointNormalsDataFlag"},
    {0X00240058, DCM_VR_TAG_SQ, "TestPointNormalsSequence"},
    {0X00240059, DCM_VR_TAG_CS, "GlobalDeviationProbabilityNormalsFlag"},
    {0X00240060, DCM_VR_TAG_US, "FalsePositivesQuantity"},
    {0X00240061, DCM_VR_TAG_CS, "ExcessiveFalsePositivesDataFlag"},
    {0X00240062, DCM_VR_TAG_CS, "ExcessiveFalsePositives"},
    {0X00240063, DCM_VR_TAG_CS, "VisualFieldTestNormalsFlag"},
    {0X00240064, DCM_VR_TAG_SQ, "ResultsNormalsSequence"},
    {0X00240065, DCM_VR_TAG_SQ, "AgeCorrectedSensitivityDeviationAlgorithmSequence"},
    {0X00240066, DCM_VR_TAG_FL, "GlobalDeviationFromNormal"},
    {0X00240067, DCM_VR_TAG_SQ, "GeneralizedDefectSensitivityDeviationAlgorithmSequence"},
    {0X00240068, DCM_VR_TAG_FL, "LocalizedDeviationFromNormal"},
    {0X00240069, DCM_VR_TAG_LO, "PatientReliabilityIndicator"},
    {0X00240070, DCM_VR_TAG_FL, "VisualFieldMeanSensitivity"},
    {0X00240071, DCM_VR_TAG_FL, "GlobalDeviationProbability"},
    {0X00240072, DCM_VR_TAG_CS, "LocalDeviationProbabilityNormalsFlag"},
    {0X00240073, DCM_VR_TAG_FL, "LocalizedDeviationProbability"},
    {0X00240074, DCM_VR_TAG_CS, "ShortTermFluctuationCalculated"},
    {0X00240075, DCM_VR_TAG_FL, "ShortTermFluctuation"},
    {0X00240076, DCM_VR_TAG_CS, "ShortTermFluctuationProbabilityCalculated"},
    {0X00240077, DCM_VR_TAG_FL, "ShortTermFluctuationProbability"},
    {0X00240078, DCM_VR_TAG_CS, "CorrectedLocalizedDeviationFromNormalCalculated"},
    {0X00240079, DCM_VR_TAG_FL, "CorrectedLocalizedDeviationFromNormal"},
    {0X00240080, DCM_VR_TAG_CS, "CorrectedLocalizedDeviationFromNormalProbabilityCalculated"},
    {0X00240081, DCM_VR_TAG_FL, "CorrectedLocalizedDeviationFromNormalProbability"},
    {0X00240083, DCM_VR_TAG_SQ, "GlobalDeviationProbabilitySequence"},
    {0X00240085, DCM_VR_TAG_SQ, "LocalizedDeviationProbabilitySequence"},
    {0X00240086, DCM_VR_TAG_CS, "FovealSensitivityMeasured"},
    {0X00240087, DCM_VR_TAG_FL, "FovealSensitivity"},
    {0X00240088, DCM_VR_TAG_FL, "VisualFieldTestDuration"},
    {0X00240089, DCM_VR_TAG_SQ, "VisualFieldTestPointSequence"},
    {0X00240090, DCM_VR_TAG_FL, "VisualFieldTestPointXCoordinate"},
    {0X00240091, DCM_VR_TAG_FL, "VisualFieldTestPointYCoordinate"},
    {0X00240092, DCM_VR_TAG_FL, "AgeCorrectedSensitivityDeviationValue"},
    {0X00240093, DCM_VR_TAG_CS, "StimulusResults"},
    {0X00240094, DCM_VR_TAG_FL, "SensitivityValue"},
    {0X00240095, DCM_VR_TAG_CS, "RetestStimulusSeen"},
    {0X00240096, DCM_VR_TAG_FL, "RetestSensitivityValue"},
    {0X00240097, DCM_VR_TAG_SQ, "VisualFieldTestPointNormalsSequence"},
    {0X00240098, DCM_VR_TAG_FL, "QuantifiedDefect"},
    {0X00240100, DCM_VR_TAG_FL, "AgeCorrectedSensitivityDeviationProbabilityValue"},
    {0X00240102, DCM_VR_TAG_CS, "GeneralizedDefectCorrectedSensitivityDeviationFlag"},
    {0X00240103, DCM_VR_TAG_FL, "GeneralizedDefectCorrectedSensitivityDeviationValue"},
    {0X00240104, DCM_VR_TAG_FL, "GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue"},
    {0X00240105, DCM_VR_TAG_FL, "MinimumSensitivityValue"},
    {0X00240106, DCM_VR_TAG_CS, "BlindSpotLocalized"},
    {0X00240107, DCM_VR_TAG_FL, "BlindSpotXCoordinate"},
    {0X00240108, DCM_VR_TAG_FL, "BlindSpotYCoordinate"},
    {0X00240110, DCM_VR_TAG_SQ, "VisualAcuityMeasurementSequence"},
    {0X00240112, DCM_VR_TAG_SQ, "RefractiveParametersUsedOnPatientSequence"},
    {0X00240113, DCM_VR_TAG_CS, "MeasurementLaterality"},
    {0X00240114, DCM_VR_TAG_SQ, "OphthalmicPatientClinicalInformationLeftEyeSequence"},
    {0X00240115, DCM_VR_TAG_SQ, "OphthalmicPatientClinicalInformationRightEyeSequence"},
    {0X00240117, DCM_VR_TAG_CS, "FovealPointNormativeDataFlag"},
    {0X00240118, DCM_VR_TAG_FL, "FovealPointProbabilityValue"},
    {0X00240120, DCM_VR_TAG_CS, "ScreeningBaselineMeasured"},
    {0X00240122, DCM_VR_TAG_SQ, "ScreeningBaselineMeasuredSequence"},
    {0X00240124, DCM_VR_TAG_CS, "ScreeningBaselineType"},
    {0X00240126, DCM_VR_TAG_FL, "ScreeningBaselineValue"},
    {0X00240202, DCM_VR_TAG_LO, "AlgorithmSource"},
    {0X00240306, DCM_VR_TAG_LO, "DataSetName"},
    {0X00240307, DCM_VR_TAG_LO, "DataSetVersion"},
    {0X00240308, DCM_VR_TAG_LO, "DataSetSource"},
    {0X00240309, DCM_VR_TAG_LO, "DataSetDescription"},
    {0X00240317, DCM_VR_TAG_SQ, "VisualFieldTestReliabilityGlobalIndexSequence"},
    {0X00240320, DCM_VR_TAG_SQ, "VisualFieldGlobalResultsIndexSequence"},
    {0X00240325, DCM_VR_TAG_SQ, "DataObservationSequence"},
    {0X00240338, DCM_VR_TAG_CS, "IndexNormalsFlag"},
    {0X00240341, DCM_VR_TAG_FL, "IndexProbability"},
    {0X00240344, DCM_VR_TAG_SQ, "IndexProbabilitySequence"},
    {0X00280002, DCM_VR_TAG_US, "SamplesPerPixel"},
    {0X00280003, DCM_VR_TAG_US, "SamplesPerPixelUsed"},
    {0X00280004, DCM_VR_TAG_CS, "PhotometricInterpretation"},
    {0X00280005, DCM_VR_TAG_US, "ImageDimensions"},
    {0X00280006, DCM_VR_TAG_US, "PlanarConfiguration"},
    {0X00280008, DCM_VR_TAG_IS, "NumberOfFrames"},
    {0X00280009, DCM_VR_TAG_AT, "FrameIncrementPointer"},
    {0X0028000A, DCM_VR_TAG_AT, "FrameDimensionPointer"},
    {0X00280010, DCM_VR_TAG_US, "Rows"},
    {0X00280011, DCM_VR_TAG_US, "Columns"},
    {0X00280012, DCM_VR_TAG_US, "Planes"},
    {0X00280014, DCM_VR_TAG_US, "UltrasoundColorDataPresent"},
    {0X00280020, DCM_VR_TAG_OB, ""},
    {0X00280030, DCM_VR_TAG_DS, "PixelSpacing"},
    {0X00280031, DCM_VR_TAG_DS, "ZoomFactor"},
    {0X00280032, DCM_VR_TAG_DS, "ZoomCenter"},
    {0X00280034, DCM_VR_TAG_IS, "PixelAspectRatio"},
    {0X00280040, DCM_VR_TAG_CS, "ImageFormat"},
    {0X00280050, DCM_VR_TAG_LO, "ManipulatedImage"},
    {0X00280051, DCM_VR_TAG_CS, "CorrectedImage"},
    {0X0028005F, DCM_VR_TAG_LO, "CompressionRecognitionCode"},
    {0X00280060, DCM_VR_TAG_CS, "CompressionCode"},
    {0X00280061, DCM_VR_TAG_SH, "CompressionOriginator"},
    {0X00280062, DCM_VR_TAG_LO, "CompressionLabel"},
    {0X00280063, DCM_VR_TAG_SH, "CompressionDescription"},
    {0X00280065, DCM_VR_TAG_CS, "CompressionSequence"},
    {0X00280066, DCM_VR_TAG_AT, "CompressionStepPointers"},
    {0X00280068, DCM_VR_TAG_US, "RepeatInterval"},
    {0X00280069, DCM_VR_TAG_US, "BitsGrouped"},
    {0X00280070, DCM_VR_TAG_US, "PerimeterTable"},
    {0X00280071, DCM_VR_TAG_US_SS, "PerimeterValue"},
    {0X00280080, DCM_VR_TAG_US, "PredictorRows"},
    {0X00280081, DCM_VR_TAG_US, "PredictorColumns"},
    {0X00280082, DCM_VR_TAG_US, "PredictorConstants"},
    {0X00280090, DCM_VR_TAG_CS, "BlockedPixels"},
    {0X00280091, DCM_VR_TAG_US, "BlockRows"},
    {0X00280092, DCM_VR_TAG_US, "BlockColumns"},
    {0X00280093, DCM_VR_TAG_US, "RowOverlap"},
    {0X00280094, DCM_VR_TAG_US, "ColumnOverlap"},
    {0X00280100, DCM_VR_TAG_US, "BitsAllocated"},
    {0X00280101, DCM_VR_TAG_US, "BitsStored"},
    {0X00280102, DCM_VR_TAG_US, "HighBit"},
    {0X00280103, DCM_VR_TAG_US, "PixelRepresentation"},
    {0X00280104, DCM_VR_TAG_US_SS, "SmallestValidPixelValue"},
    {0X00280105, DCM_VR_TAG_US_SS, "LargestValidPixelValue"},
    {0X00280106, DCM_VR_TAG_US_SS, "SmallestImagePixelValue"},
    {0X00280107, DCM_VR_TAG_US_SS, "LargestImagePixelValue"},
    {0X00280108, DCM_VR_TAG_US_SS, "SmallestPixelValueInSeries"},
    {0X00280109, DCM_VR_TAG_US_SS, "LargestPixelValueInSeries"},
    {0X00280110, DCM_VR_TAG_US_SS, "SmallestImagePixelValueInPlane"},
    {0X00280111, DCM_VR_TAG_US_SS, "LargestImagePixelValueInPlane"},
    {0X00280120, DCM_VR_TAG_US_SS, "PixelPaddingValue"},
    {0X00280121, DCM_VR_TAG_US_SS, "PixelPaddingRangeLimit"},
    {0X00280122, DCM_VR_TAG_FL, "FloatPixelPaddingValue"},
    {0X00280123, DCM_VR_TAG_FD, "DoubleFloatPixelPaddingValue"},
    {0X00280124, DCM_VR_TAG_FL, "FloatPixelPaddingRangeLimit"},
    {0X00280125, DCM_VR_TAG_FD, "DoubleFloatPixelPaddingRangeLimit"},
    {0X00280200, DCM_VR_TAG_US, "ImageLocation"},
    {0X00280300, DCM_VR_TAG_CS, "QualityControlImage"},
    {0X00280301, DCM_VR_TAG_CS, "BurnedInAnnotation"},
    {0X00280302, DCM_VR_TAG_CS, "RecognizableVisualFeatures"},
    {0X00280303, DCM_VR_TAG_CS, "LongitudinalTemporalInformationModified"},
    {0X00280304, DCM_VR_TAG_UI, "ReferencedColorPaletteInstanceUID"},
    {0X00280400, DCM_VR_TAG_LO, "TransformLabel"},
    {0X00280401, DCM_VR_TAG_LO, "TransformVersionNumber"},
    {0X00280402, DCM_VR_TAG_US, "NumberOfTransformSteps"},
    {0X00280403, DCM_VR_TAG_LO, "SequenceOfCompressedData"},
    {0X00280404, DCM_VR_TAG_AT, "DetailsOfCoefficients"},
    {0X00280700, DCM_VR_TAG_LO, "DCTLabel"},
    {0X00280701, DCM_VR_TAG_CS, "DataBlockDescription"},
    {0X00280702, DCM_VR_TAG_AT, "DataBlock"},
    {0X00280710, DCM_VR_TAG_US, "NormalizationFactorFormat"},
    {0X00280720, DCM_VR_TAG_US, "ZonalMapNumberFormat"},
    {0X00280721, DCM_VR_TAG_AT, "ZonalMapLocation"},
    {0X00280722, DCM_VR_TAG_US, "ZonalMapFormat"},
    {0X00280730, DCM_VR_TAG_US, "AdaptiveMapFormat"},
    {0X00280740, DCM_VR_TAG_US, "CodeNumberFormat"},
    {0X00280A02, DCM_VR_TAG_CS, "PixelSpacingCalibrationType"},
    {0X00280A04, DCM_VR_TAG_LO, "PixelSpacingCalibrationDescription"},
    {0X00281040, DCM_VR_TAG_CS, "PixelIntensityRelationship"},
    {0X00281041, DCM_VR_TAG_SS, "PixelIntensityRelationshipSign"},
    {0X00281050, DCM_VR_TAG_DS, "WindowCenter"},
    {0X00281051, DCM_VR_TAG_DS, "WindowWidth"},
    {0X00281052, DCM_VR_TAG_DS, "RescaleIntercept"},
    {0X00281053, DCM_VR_TAG_DS, "RescaleSlope"},
    {0X00281054, DCM_VR_TAG_LO, "RescaleType"},
    {0X00281055, DCM_VR_TAG_LO, "WindowCenterWidthExplanation"},
    {0X00281056, DCM_VR_TAG_CS, "VOILUTFunction"},
    {0X00281080, DCM_VR_TAG_CS, "GrayScale"},
    {0X00281090, DCM_VR_TAG_CS, "RecommendedViewingMode"},
    {0X00281100, DCM_VR_TAG_US_SS, "GrayLookupTableDescriptor"},
    {0X00281101, DCM_VR_TAG_US_SS, "RedPaletteColorLookupTableDescriptor"},
    {0X00281102, DCM_VR_TAG_US_SS, "GreenPaletteColorLookupTableDescriptor"},
    {0X00281103, DCM_VR_TAG_US_SS, "BluePaletteColorLookupTableDescriptor"},
    {0X00281104, DCM_VR_TAG_US, "AlphaPaletteColorLookupTableDescriptor"},
    {0X00281111, DCM_VR_TAG_US_SS, "LargeRedPaletteColorLookupTableDescriptor"},
    {0X00281112, DCM_VR_TAG_US_SS, "LargeGreenPaletteColorLookupTableDescriptor"},
    {0X00281113, DCM_VR_TAG_US_SS, "LargeBluePaletteColorLookupTableDescriptor"},
    {0X00281199, DCM_VR_TAG_UI, "PaletteColorLookupTableUID"},
    {0X00281200, DCM_VR_TAG_US_SS_OW, "GrayLookupTableData"},
    {0X00281201, DCM_VR_TAG_OW, "RedPaletteColorLookupTableData"},
    {0X00281202, DCM_VR_TAG_OW, "GreenPaletteColorLookupTableData"},
    {0X00281203, DCM_VR_TAG_OW, "BluePaletteColorLookupTableData"},
    {0X00281204, DCM_VR_TAG_OW, "AlphaPaletteColorLookupTableData"},
    {0X00281211, DCM_VR_TAG_OW, "LargeRedPaletteColorLookupTableData"},
    {0X00281212, DCM_VR_TAG_OW, "LargeGreenPaletteColorLookupTableData"},
    {0X00281213, DCM_VR_TAG_OW, "LargeBluePaletteColorLookupTableData"},
    {0X00281214, DCM_VR_TAG_UI, "LargePaletteColorLookupTableUID"},
    {0X00281221, DCM_VR_TAG_OW, "SegmentedRedPaletteColorLookupTableData"},
    {0X00281222, DCM_VR_TAG_OW, "SegmentedGreenPaletteColorLookupTableData"},
    {0X00281223, DCM_VR_TAG_OW, "SegmentedBluePaletteColorLookupTableData"},
    {0X00281224, DCM_VR_TAG_OW, "SegmentedAlphaPaletteColorLookupTableData"},
    {0X00281230, DCM_VR_TAG_SQ, "StoredValueColorRangeSequence"},
    {0X00281231, DCM_VR_TAG_FD, "MinimumStoredValueMapped"},
    {0X00281232, DCM_VR_TAG_FD, "MaximumStoredValueMapped"},
    {0X00281300, DCM_VR_TAG_CS, "BreastImplantPresent"},
    {0X00281350, DCM_VR_TAG_CS, "PartialView"},
    {0X00281351, DCM_VR_TAG_ST, "PartialViewDescription"},
    {0X00281352, DCM_VR_TAG_SQ, "PartialViewCodeSequence"},
    {0X0028135A, DCM_VR_TAG_CS, "SpatialLocationsPreserved"},
    {0X00281401, DCM_VR_TAG_SQ, "DataFrameAssignmentSequence"},
    {0X00281402, DCM_VR_TAG_CS, "DataPathAssignment"},
    {0X00281403, DCM_VR_TAG_US, "BitsMappedToColorLookupTable"},
    {0X00281404, DCM_VR_TAG_SQ, "BlendingLUT1Sequence"},
    {0X00281405, DCM_VR_TAG_CS, "BlendingLUT1TransferFunction"},
    {0X00281406, DCM_VR_TAG_FD, "BlendingWeightConstant"},
    {0X00281407, DCM_VR_TAG_US, "BlendingLookupTableDescriptor"},
    {0X00281408, DCM_VR_TAG_OW, "BlendingLookupTableData"},
    {0X0028140B, DCM_VR_TAG_SQ, "EnhancedPaletteColorLookupTableSequence"},
    {0X0028140C, DCM_VR_TAG_SQ, "BlendingLUT2Sequence"},
    {0X0028140D, DCM_VR_TAG_CS, "BlendingLUT2TransferFunction"},
    {0X0028140E, DCM_VR_TAG_CS, "DataPathID"},
    {0X0028140F, DCM_VR_TAG_CS, "RGBLUTTransferFunction"},
    {0X00281410, DCM_VR_TAG_CS, "AlphaLUTTransferFunction"},
    {0X00282000, DCM_VR_TAG_OB, "ICCProfile"},
    {0X00282002, DCM_VR_TAG_CS, "ColorSpace"},
    {0X00282110, DCM_VR_TAG_CS, "LossyImageCompression"},
    {0X00282112, DCM_VR_TAG_DS, "LossyImageCompressionRatio"},
    {0X00282114, DCM_VR_TAG_CS, "LossyImageCompressionMethod"},
    {0X00283000, DCM_VR_TAG_SQ, "ModalityLUTSequence"},
    {0X00283002, DCM_VR_TAG_US_SS, "LUTDescriptor"},
    {0X00283003, DCM_VR_TAG_LO, "LUTExplanation"},
    {0X00283004, DCM_VR_TAG_LO, "ModalityLUTType"},
    {0X00283006, DCM_VR_TAG_US_OW, "LUTData"},
    {0X00283010, DCM_VR_TAG_SQ, "VOILUTSequence"},
    {0X00283110, DCM_VR_TAG_SQ, "SoftcopyVOILUTSequence"},
    {0X00284000, DCM_VR_TAG_LT, "ImagePresentationComments"},
    {0X00285000, DCM_VR_TAG_SQ, "BiPlaneAcquisitionSequence"},
    {0X00286010, DCM_VR_TAG_US, "RepresentativeFrameNumber"},
    {0X00286020, DCM_VR_TAG_US, "FrameNumbersOfInterest"},
    {0X00286022, DCM_VR_TAG_LO, "FrameOfInterestDescription"},
    {0X00286023, DCM_VR_TAG_CS, "FrameOfInterestType"},
    {0X00286030, DCM_VR_TAG_US, "MaskPointers"},
    {0X00286040, DCM_VR_TAG_US, "RWavePointer"},
    {0X00286100, DCM_VR_TAG_SQ, "MaskSubtractionSequence"},
    {0X00286101, DCM_VR_TAG_CS, "MaskOperation"},
    {0X00286102, DCM_VR_TAG_US, "ApplicableFrameRange"},
    {0X00286110, DCM_VR_TAG_US, "MaskFrameNumbers"},
    {0X00286112, DCM_VR_TAG_US, "ContrastFrameAveraging"},
    {0X00286114, DCM_VR_TAG_FL, "MaskSubPixelShift"},
    {0X00286120, DCM_VR_TAG_SS, "TIDOffset"},
    {0X00286190, DCM_VR_TAG_ST, "MaskOperationExplanation"},
    {0X00287000, DCM_VR_TAG_SQ, "EquipmentAdministratorSequence"},
    {0X00287001, DCM_VR_TAG_US, "NumberOfDisplaySubsystems"},
    {0X00287002, DCM_VR_TAG_US, "CurrentConfigurationID"},
    {0X00287003, DCM_VR_TAG_US, "DisplaySubsystemID"},
    {0X00287004, DCM_VR_TAG_SH, "DisplaySubsystemName"},
    {0X00287005, DCM_VR_TAG_LO, "DisplaySubsystemDescription"},
    {0X00287006, DCM_VR_TAG_CS, "SystemStatus"},
    {0X00287007, DCM_VR_TAG_LO, "SystemStatusComment"},
    {0X00287008, DCM_VR_TAG_SQ, "TargetLuminanceCharacteristicsSequence"},
    {0X00287009, DCM_VR_TAG_US, "LuminanceCharacteristicsID"},
    {0X0028700A, DCM_VR_TAG_SQ, "DisplaySubsystemConfigurationSequence"},
    {0X0028700B, DCM_VR_TAG_US, "ConfigurationID"},
    {0X0028700C, DCM_VR_TAG_SH, "ConfigurationName"},
    {0X0028700D, DCM_VR_TAG_LO, "ConfigurationDescription"},
    {0X0028700E, DCM_VR_TAG_US, "ReferencedTargetLuminanceCharacteristicsID"},
    {0X0028700F, DCM_VR_TAG_SQ, "QAResultsSequence"},
    {0X00287010, DCM_VR_TAG_SQ, "DisplaySubsystemQAResultsSequence"},
    {0X00287011, DCM_VR_TAG_SQ, "ConfigurationQAResultsSequence"},
    {0X00287012, DCM_VR_TAG_SQ, "MeasurementEquipmentSequence"},
    {0X00287013, DCM_VR_TAG_CS, "MeasurementFunctions"},
    {0X00287014, DCM_VR_TAG_CS, "MeasurementEquipmentType"},
    {0X00287015, DCM_VR_TAG_SQ, "VisualEvaluationResultSequence"},
    {0X00287016, DCM_VR_TAG_SQ, "DisplayCalibrationResultSequence"},
    {0X00287017, DCM_VR_TAG_US, "DDLValue"},
    {0X00287018, DCM_VR_TAG_FL, "CIExyWhitePoint"},
    {0X00287019, DCM_VR_TAG_CS, "DisplayFunctionType"},
    {0X0028701A, DCM_VR_TAG_FL, "GammaValue"},
    {0X0028701B, DCM_VR_TAG_US, "NumberOfLuminancePoints"},
    {0X0028701C, DCM_VR_TAG_SQ, "LuminanceResponseSequence"},
    {0X0028701D, DCM_VR_TAG_FL, "TargetMinimumLuminance"},
    {0X0028701E, DCM_VR_TAG_FL, "TargetMaximumLuminance"},
    {0X0028701F, DCM_VR_TAG_FL, "LuminanceValue"},
    {0X00287020, DCM_VR_TAG_LO, "LuminanceResponseDescription"},
    {0X00287021, DCM_VR_TAG_CS, "WhitePointFlag"},
    {0X00287022, DCM_VR_TAG_SQ, "DisplayDeviceTypeCodeSequence"},
    {0X00287023, DCM_VR_TAG_SQ, "DisplaySubsystemSequence"},
    {0X00287024, DCM_VR_TAG_SQ, "LuminanceResultSequence"},
    {0X00287025, DCM_VR_TAG_CS, "AmbientLightValueSource"},
    {0X00287026, DCM_VR_TAG_CS, "MeasuredCharacteristics"},
    {0X00287027, DCM_VR_TAG_SQ, "LuminanceUniformityResultSequence"},
    {0X00287028, DCM_VR_TAG_SQ, "VisualEvaluationTestSequence"},
    {0X00287029, DCM_VR_TAG_CS, "TestResult"},
    {0X0028702A, DCM_VR_TAG_LO, "TestResultComment"},
    {0X0028702B, DCM_VR_TAG_CS, "TestImageValidation"},
    {0X0028702C, DCM_VR_TAG_SQ, "TestPatternCodeSequence"},
    {0X0028702D, DCM_VR_TAG_SQ, "MeasurementPatternCodeSequence"},
    {0X0028702E, DCM_VR_TAG_SQ, "VisualEvaluationMethodCodeSequence"},
    {0X00287FE0, DCM_VR_TAG_UR, "PixelDataProviderURL"},
    {0X00289001, DCM_VR_TAG_UL, "DataPointRows"},
    {0X00289002, DCM_VR_TAG_UL, "DataPointColumns"},
    {0X00289003, DCM_VR_TAG_CS, "SignalDomainColumns"},
    {0X00289099, DCM_VR_TAG_US, "LargestMonochromePixelValue"},
    {0X00289108, DCM_VR_TAG_CS, "DataRepresentation"},
    {0X00289110, DCM_VR_TAG_SQ, "PixelMeasuresSequence"},
    {0X00289132, DCM_VR_TAG_SQ, "FrameVOILUTSequence"},
    {0X00289145, DCM_VR_TAG_SQ, "PixelValueTransformationSequence"},
    {0X00289235, DCM_VR_TAG_CS, "SignalDomainRows"},
    {0X00289411, DCM_VR_TAG_FL, "DisplayFilterPercentage"},
    {0X00289415, DCM_VR_TAG_SQ, "FramePixelShiftSequence"},
    {0X00289416, DCM_VR_TAG_US, "SubtractionItemID"},
    {0X00289422, DCM_VR_TAG_SQ, "PixelIntensityRelationshipLUTSequence"},
    {0X00289443, DCM_VR_TAG_SQ, "FramePixelDataPropertiesSequence"},
    {0X00289444, DCM_VR_TAG_CS, "GeometricalProperties"},
    {0X00289445, DCM_VR_TAG_FL, "GeometricMaximumDistortion"},
    {0X00289446, DCM_VR_TAG_CS, "ImageProcessingApplied"},
    {0X00289454, DCM_VR_TAG_CS, "MaskSelectionMode"},
    {0X00289474, DCM_VR_TAG_CS, "LUTFunction"},
    {0X00289478, DCM_VR_TAG_FL, "MaskVisibilityPercentage"},
    {0X00289501, DCM_VR_TAG_SQ, "PixelShiftSequence"},
    {0X00289502, DCM_VR_TAG_SQ, "RegionPixelShiftSequence"},
    {0X00289503, DCM_VR_TAG_SS, "VerticesOfTheRegion"},
    {0X00289505, DCM_VR_TAG_SQ, "MultiFramePresentationSequence"},
    {0X00289506, DCM_VR_TAG_US, "PixelShiftFrameRange"},
    {0X00289507, DCM_VR_TAG_US, "LUTFrameRange"},
    {0X00289520, DCM_VR_TAG_DS, "ImageToEquipmentMappingMatrix"},
    {0X00289537, DCM_VR_TAG_CS, "EquipmentCoordinateSystemIdentification"},
    {0X0032000A, DCM_VR_TAG_CS, "StudyStatusID"},
    {0X0032000C, DCM_VR_TAG_CS, "StudyPriorityID"},
    {0X00320012, DCM_VR_TAG_LO, "StudyIDIssuer"},
    {0X00320032, DCM_VR_TAG_DA, "StudyVerifiedDate"},
    {0X00320033, DCM_VR_TAG_TM, "StudyVerifiedTime"},
    {0X00320034, DCM_VR_TAG_DA, "StudyReadDate"},
    {0X00320035, DCM_VR_TAG_TM, "StudyReadTime"},
    {0X00321000, DCM_VR_TAG_DA, "ScheduledStudyStartDate"},
    {0X00321001, DCM_VR_TAG_TM, "ScheduledStudyStartTime"},
    {0X00321010, DCM_VR_TAG_DA, "ScheduledStudyStopDate"},
    {0X00321011, DCM_VR_TAG_TM, "ScheduledStudyStopTime"},
    {0X00321020, DCM_VR_TAG_LO, "ScheduledStudyLocation"},
    {0X00321021, DCM_VR_TAG_AE, "ScheduledStudyLocationAETitle"},
    {0X00321030, DCM_VR_TAG_LO, "ReasonForStudy"},
    {0X00321031, DCM_VR_TAG_SQ, "RequestingPhysicianIdentificationSequence"},
    {0X00321032, DCM_VR_TAG_PN, "RequestingPhysician"},
    {0X00321033, DCM_VR_TAG_LO, "RequestingService"},
    {0X00321034, DCM_VR_TAG_SQ, "RequestingServiceCodeSequence"},
    {0X00321040, DCM_VR_TAG_DA, "StudyArrivalDate"},
    {0X00321041, DCM_VR_TAG_TM, "StudyArrivalTime"},
    {0X00321050, DCM_VR_TAG_DA, "StudyCompletionDate"},
    {0X00321051, DCM_VR_TAG_TM, "StudyCompletionTime"},
    {0X00321055, DCM_VR_TAG_CS, "StudyComponentStatusID"},
    {0X00321060, DCM_VR_TAG_LO, "RequestedProcedureDescription"},
    {0X00321064, DCM_VR_TAG_SQ, "RequestedProcedureCodeSequence"},
    {0X00321066, DCM_VR_TAG_UT, "ReasonForVisit"},
    {0X00321067, DCM_VR_TAG_SQ, "ReasonForVisitCodeSequence"},
    {0X00321070, DCM_VR_TAG_LO, "RequestedContrastAgent"},
    {0X00324000, DCM_VR_TAG_LT, "StudyComments"},
    {0X00340001, DCM_VR_TAG_SQ, "FlowIdentifierSequence"},
    {0X00340002, DCM_VR_TAG_OB, "FlowIdentifier"},
    {0X00340003, DCM_VR_TAG_UI, "FlowTransferSyntaxUID"},
    {0X00340004, DCM_VR_TAG_UL, "FlowRTPSamplingRate"},
    {0X00340005, DCM_VR_TAG_OB, "SourceIdentifier"},
    {0X00340007, DCM_VR_TAG_OB, "FrameOriginTimestamp"},
    {0X00340008, DCM_VR_TAG_CS, "IncludesImagingSubject"},
    {0X00340009, DCM_VR_TAG_SQ, "FrameUsefulnessGroupSequence"},
    {0X0034000A, DCM_VR_TAG_SQ, "RealTimeBulkDataFlowSequence"},
    {0X0034000B, DCM_VR_TAG_SQ, "CameraPositionGroupSequence"},
    {0X0034000C, DCM_VR_TAG_CS, "IncludesInformation"},
    {0X0034000D, DCM_VR_TAG_SQ, "TimeOfFrameGroupSequence"},
    {0X00380004, DCM_VR_TAG_SQ, "ReferencedPatientAliasSequence"},
    {0X00380008, DCM_VR_TAG_CS, "VisitStatusID"},
    {0X00380010, DCM_VR_TAG_LO, "AdmissionID"},
    {0X00380011, DCM_VR_TAG_LO, "IssuerOfAdmissionID"},
    {0X00380014, DCM_VR_TAG_SQ, "IssuerOfAdmissionIDSequence"},
    {0X00380016, DCM_VR_TAG_LO, "RouteOfAdmissions"},
    {0X0038001A, DCM_VR_TAG_DA, "ScheduledAdmissionDate"},
    {0X0038001B, DCM_VR_TAG_TM, "ScheduledAdmissionTime"},
    {0X0038001C, DCM_VR_TAG_DA, "ScheduledDischargeDate"},
    {0X0038001D, DCM_VR_TAG_TM, "ScheduledDischargeTime"},
    {0X0038001E, DCM_VR_TAG_LO, "ScheduledPatientInstitutionResidence"},
    {0X00380020, DCM_VR_TAG_DA, "AdmittingDate"},
    {0X00380021, DCM_VR_TAG_TM, "AdmittingTime"},
    {0X00380030, DCM_VR_TAG_DA, "DischargeDate"},
    {0X00380032, DCM_VR_TAG_TM, "DischargeTime"},
    {0X00380040, DCM_VR_TAG_LO, "DischargeDiagnosisDescription"},
    {0X00380044, DCM_VR_TAG_SQ, "DischargeDiagnosisCodeSequence"},
    {0X00380050, DCM_VR_TAG_LO, "SpecialNeeds"},
    {0X00380060, DCM_VR_TAG_LO, "ServiceEpisodeID"},
    {0X00380061, DCM_VR_TAG_LO, "IssuerOfServiceEpisodeID"},
    {0X00380062, DCM_VR_TAG_LO, "ServiceEpisodeDescription"},
    {0X00380064, DCM_VR_TAG_SQ, "IssuerOfServiceEpisodeIDSequence"},
    {0X00380100, DCM_VR_TAG_SQ, "PertinentDocumentsSequence"},
    {0X00380101, DCM_VR_TAG_SQ, "PertinentResourcesSequence"},
    {0X00380102, DCM_VR_TAG_LO, "ResourceDescription"},
    {0X00380300, DCM_VR_TAG_LO, "CurrentPatientLocation"},
    {0X00380400, DCM_VR_TAG_LO, "PatientInstitutionResidence"},
    {0X00380500, DCM_VR_TAG_LO, "PatientState"},
    {0X00380502, DCM_VR_TAG_SQ, "PatientClinicalTrialParticipationSequence"},
    {0X00384000, DCM_VR_TAG_LT, "VisitComments"},
    {0X003A0004, DCM_VR_TAG_CS, "WaveformOriginality"},
    {0X003A0005, DCM_VR_TAG_US, "NumberOfWaveformChannels"},
    {0X003A0010, DCM_VR_TAG_UL, "NumberOfWaveformSamples"},
    {0X003A001A, DCM_VR_TAG_DS, "SamplingFrequency"},
    {0X003A0020, DCM_VR_TAG_SH, "MultiplexGroupLabel"},
    {0X003A0200, DCM_VR_TAG_SQ, "ChannelDefinitionSequence"},
    {0X003A0202, DCM_VR_TAG_IS, "WaveformChannelNumber"},
    {0X003A0203, DCM_VR_TAG_SH, "ChannelLabel"},
    {0X003A0205, DCM_VR_TAG_CS, "ChannelStatus"},
    {0X003A0208, DCM_VR_TAG_SQ, "ChannelSourceSequence"},
    {0X003A0209, DCM_VR_TAG_SQ, "ChannelSourceModifiersSequence"},
    {0X003A020A, DCM_VR_TAG_SQ, "SourceWaveformSequence"},
    {0X003A020C, DCM_VR_TAG_LO, "ChannelDerivationDescription"},
    {0X003A0210, DCM_VR_TAG_DS, "ChannelSensitivity"},
    {0X003A0211, DCM_VR_TAG_SQ, "ChannelSensitivityUnitsSequence"},
    {0X003A0212, DCM_VR_TAG_DS, "ChannelSensitivityCorrectionFactor"},
    {0X003A0213, DCM_VR_TAG_DS, "ChannelBaseline"},
    {0X003A0214, DCM_VR_TAG_DS, "ChannelTimeSkew"},
    {0X003A0215, DCM_VR_TAG_DS, "ChannelSampleSkew"},
    {0X003A0218, DCM_VR_TAG_DS, "ChannelOffset"},
    {0X003A021A, DCM_VR_TAG_US, "WaveformBitsStored"},
    {0X003A0220, DCM_VR_TAG_DS, "FilterLowFrequency"},
    {0X003A0221, DCM_VR_TAG_DS, "FilterHighFrequency"},
    {0X003A0222, DCM_VR_TAG_DS, "NotchFilterFrequency"},
    {0X003A0223, DCM_VR_TAG_DS, "NotchFilterBandwidth"},
    {0X003A0230, DCM_VR_TAG_FL, "WaveformDataDisplayScale"},
    {0X003A0231, DCM_VR_TAG_US, "WaveformDisplayBackgroundCIELabValue"},
    {0X003A0240, DCM_VR_TAG_SQ, "WaveformPresentationGroupSequence"},
    {0X003A0241, DCM_VR_TAG_US, "PresentationGroupNumber"},
    {0X003A0242, DCM_VR_TAG_SQ, "ChannelDisplaySequence"},
    {0X003A0244, DCM_VR_TAG_US, "ChannelRecommendedDisplayCIELabValue"},
    {0X003A0245, DCM_VR_TAG_FL, "ChannelPosition"},
    {0X003A0246, DCM_VR_TAG_CS, "DisplayShadingFlag"},
    {0X003A0247, DCM_VR_TAG_FL, "FractionalChannelDisplayScale"},
    {0X003A0248, DCM_VR_TAG_FL, "AbsoluteChannelDisplayScale"},
    {0X003A0300, DCM_VR_TAG_SQ, "MultiplexedAudioChannelsDescriptionCodeSequence"},
    {0X003A0301, DCM_VR_TAG_IS, "ChannelIdentificationCode"},
    {0X003A0302, DCM_VR_TAG_CS, "ChannelMode"},
    {0X003A0310, DCM_VR_TAG_UI, "MultiplexGroupUID"},
    {0X003A0311, DCM_VR_TAG_DS, "PowerlineFrequency"},
    {0X003A0312, DCM_VR_TAG_SQ, "ChannelImpedanceSequence"},
    {0X003A0313, DCM_VR_TAG_DS, "ImpedanceValue"},
    {0X003A0314, DCM_VR_TAG_DT, "ImpedanceMeasurementDateTime"},
    {0X003A0315, DCM_VR_TAG_DS, "ImpedanceMeasurementFrequency"},
    {0X003A0316, DCM_VR_TAG_CS, "ImpedanceMeasurementCurrentType"},
    {0X00400001, DCM_VR_TAG_AE, "ScheduledStationAETitle"},
    {0X00400002, DCM_VR_TAG_DA, "ScheduledProcedureStepStartDate"},
    {0X00400003, DCM_VR_TAG_TM, "ScheduledProcedureStepStartTime"},
    {0X00400004, DCM_VR_TAG_DA, "ScheduledProcedureStepEndDate"},
    {0X00400005, DCM_VR_TAG_TM, "ScheduledProcedureStepEndTime"},
    {0X00400006, DCM_VR_TAG_PN, "ScheduledPerformingPhysicianName"},
    {0X00400007, DCM_VR_TAG_LO, "ScheduledProcedureStepDescription"},
    {0X00400008, DCM_VR_TAG_SQ, "ScheduledProtocolCodeSequence"},
    {0X00400009, DCM_VR_TAG_SH, "ScheduledProcedureStepID"},
    {0X0040000A, DCM_VR_TAG_SQ, "StageCodeSequence"},
    {0X0040000B, DCM_VR_TAG_SQ, "ScheduledPerformingPhysicianIdentificationSequence"},
    {0X00400010, DCM_VR_TAG_SH, "ScheduledStationName"},
    {0X00400011, DCM_VR_TAG_SH, "ScheduledProcedureStepLocation"},
    {0X00400012, DCM_VR_TAG_LO, "PreMedication"},
    {0X00400020, DCM_VR_TAG_CS, "ScheduledProcedureStepStatus"},
    {0X00400026, DCM_VR_TAG_SQ, "OrderPlacerIdentifierSequence"},
    {0X00400027, DCM_VR_TAG_SQ, "OrderFillerIdentifierSequence"},
    {0X00400031, DCM_VR_TAG_UT, "LocalNamespaceEntityID"},
    {0X00400032, DCM_VR_TAG_UT, "UniversalEntityID"},
    {0X00400033, DCM_VR_TAG_CS, "UniversalEntityIDType"},
    {0X00400035, DCM_VR_TAG_CS, "IdentifierTypeCode"},
    {0X00400036, DCM_VR_TAG_SQ, "AssigningFacilitySequence"},
    {0X00400039, DCM_VR_TAG_SQ, "AssigningJurisdictionCodeSequence"},
    {0X0040003A, DCM_VR_TAG_SQ, "AssigningAgencyOrDepartmentCodeSequence"},
    {0X00400100, DCM_VR_TAG_SQ, "ScheduledProcedureStepSequence"},
    {0X00400220, DCM_VR_TAG_SQ, "ReferencedNonImageCompositeSOPInstanceSequence"},
    {0X00400241, DCM_VR_TAG_AE, "PerformedStationAETitle"},
    {0X00400242, DCM_VR_TAG_SH, "PerformedStationName"},
    {0X00400243, DCM_VR_TAG_SH, "PerformedLocation"},
    {0X00400244, DCM_VR_TAG_DA, "PerformedProcedureStepStartDate"},
    {0X00400245, DCM_VR_TAG_TM, "PerformedProcedureStepStartTime"},
    {0X00400250, DCM_VR_TAG_DA, "PerformedProcedureStepEndDate"},
    {0X00400251, DCM_VR_TAG_TM, "PerformedProcedureStepEndTime"},
    {0X00400252, DCM_VR_TAG_CS, "PerformedProcedureStepStatus"},
    {0X00400253, DCM_VR_TAG_SH, "PerformedProcedureStepID"},
    {0X00400254, DCM_VR_TAG_LO, "PerformedProcedureStepDescription"},
    {0X00400255, DCM_VR_TAG_LO, "PerformedProcedureTypeDescription"},
    {0X00400260, DCM_VR_TAG_SQ, "PerformedProtocolCodeSequence"},
    {0X00400261, DCM_VR_TAG_CS, "PerformedProtocolType"},
    {0X00400270, DCM_VR_TAG_SQ, "ScheduledStepAttributesSequence"},
    {0X00400275, DCM_VR_TAG_SQ, "RequestAttributesSequence"},
    {0X00400280, DCM_VR_TAG_ST, "CommentsOnThePerformedProcedureStep"},
    {0X00400281, DCM_VR_TAG_SQ, "PerformedProcedureStepDiscontinuationReasonCodeSequence"},
    {0X00400293, DCM_VR_TAG_SQ, "QuantitySequence"},
    {0X00400294, DCM_VR_TAG_DS, "Quantity"},
    {0X00400295, DCM_VR_TAG_SQ, "MeasuringUnitsSequence"},
    {0X00400296, DCM_VR_TAG_SQ, "BillingItemSequence"},
    {0X00400300, DCM_VR_TAG_US, "TotalTimeOfFluoroscopy"},
    {0X00400301, DCM_VR_TAG_US, "TotalNumberOfExposures"},
    {0X00400302, DCM_VR_TAG_US, "EntranceDose"},
    {0X00400303, DCM_VR_TAG_US, "ExposedArea"},
    {0X00400306, DCM_VR_TAG_DS, "DistanceSourceToEntrance"},
    {0X00400307, DCM_VR_TAG_DS, "DistanceSourceToSupport"},
    {0X0040030E, DCM_VR_TAG_SQ, "ExposureDoseSequence"},
    {0X00400310, DCM_VR_TAG_ST, "CommentsOnRadiationDose"},
    {0X00400312, DCM_VR_TAG_DS, "XRayOutput"},
    {0X00400314, DCM_VR_TAG_DS, "HalfValueLayer"},
    {0X00400316, DCM_VR_TAG_DS, "OrganDose"},
    {0X00400318, DCM_VR_TAG_CS, "OrganExposed"},
    {0X00400320, DCM_VR_TAG_SQ, "BillingProcedureStepSequence"},
    {0X00400321, DCM_VR_TAG_SQ, "FilmConsumptionSequence"},
    {0X00400324, DCM_VR_TAG_SQ, "BillingSuppliesAndDevicesSequence"},
    {0X00400330, DCM_VR_TAG_SQ, "ReferencedProcedureStepSequence"},
    {0X00400340, DCM_VR_TAG_SQ, "PerformedSeriesSequence"},
    {0X00400400, DCM_VR_TAG_LT, "CommentsOnTheScheduledProcedureStep"},
    {0X00400440, DCM_VR_TAG_SQ, "ProtocolContextSequence"},
    {0X00400441, DCM_VR_TAG_SQ, "ContentItemModifierSequence"},
    {0X00400500, DCM_VR_TAG_SQ, "ScheduledSpecimenSequence"},
    {0X0040050A, DCM_VR_TAG_LO, "SpecimenAccessionNumber"},
    {0X00400512, DCM_VR_TAG_LO, "ContainerIdentifier"},
    {0X00400513, DCM_VR_TAG_SQ, "IssuerOfTheContainerIdentifierSequence"},
    {0X00400515, DCM_VR_TAG_SQ, "AlternateContainerIdentifierSequence"},
    {0X00400518, DCM_VR_TAG_SQ, "ContainerTypeCodeSequence"},
    {0X0040051A, DCM_VR_TAG_LO, "ContainerDescription"},
    {0X00400520, DCM_VR_TAG_SQ, "ContainerComponentSequence"},
    {0X00400550, DCM_VR_TAG_SQ, "SpecimenSequence"},
    {0X00400551, DCM_VR_TAG_LO, "SpecimenIdentifier"},
    {0X00400552, DCM_VR_TAG_SQ, "SpecimenDescriptionSequenceTrial"},
    {0X00400553, DCM_VR_TAG_ST, "SpecimenDescriptionTrial"},
    {0X00400554, DCM_VR_TAG_UI, "SpecimenUID"},
    {0X00400555, DCM_VR_TAG_SQ, "AcquisitionContextSequence"},
    {0X00400556, DCM_VR_TAG_ST, "AcquisitionContextDescription"},
    {0X00400560, DCM_VR_TAG_SQ, "SpecimenDescriptionSequence"},
    {0X00400562, DCM_VR_TAG_SQ, "IssuerOfTheSpecimenIdentifierSequence"},
    {0X0040059A, DCM_VR_TAG_SQ, "SpecimenTypeCodeSequence"},
    {0X00400600, DCM_VR_TAG_LO, "SpecimenShortDescription"},
    {0X00400602, DCM_VR_TAG_UT, "SpecimenDetailedDescription"},
    {0X00400610, DCM_VR_TAG_SQ, "SpecimenPreparationSequence"},
    {0X00400612, DCM_VR_TAG_SQ, "SpecimenPreparationStepContentItemSequence"},
    {0X00400620, DCM_VR_TAG_SQ, "SpecimenLocalizationContentItemSequence"},
    {0X004006FA, DCM_VR_TAG_LO, "SlideIdentifier"},
    {0X00400710, DCM_VR_TAG_SQ, "WholeSlideMicroscopyImageFrameTypeSequence"},
    {0X0040071A, DCM_VR_TAG_SQ, "ImageCenterPointCoordinatesSequence"},
    {0X0040072A, DCM_VR_TAG_DS, "XOffsetInSlideCoordinateSystem"},
    {0X0040073A, DCM_VR_TAG_DS, "YOffsetInSlideCoordinateSystem"},
    {0X0040074A, DCM_VR_TAG_DS, "ZOffsetInSlideCoordinateSystem"},
    {0X004008D8, DCM_VR_TAG_SQ, "PixelSpacingSequence"},
    {0X004008DA, DCM_VR_TAG_SQ, "CoordinateSystemAxisCodeSequence"},
    {0X004008EA, DCM_VR_TAG_SQ, "MeasurementUnitsCodeSequence"},
    {0X004009F8, DCM_VR_TAG_SQ, "VitalStainCodeSequenceTrial"},
    {0X00401001, DCM_VR_TAG_SH, "RequestedProcedureID"},
    {0X00401002, DCM_VR_TAG_LO, "ReasonForTheRequestedProcedure"},
    {0X00401003, DCM_VR_TAG_SH, "RequestedProcedurePriority"},
    {0X00401004, DCM_VR_TAG_LO, "PatientTransportArrangements"},
    {0X00401005, DCM_VR_TAG_LO, "RequestedProcedureLocation"},
    {0X00401006, DCM_VR_TAG_SH, "PlacerOrderNumberProcedure"},
    {0X00401007, DCM_VR_TAG_SH, "FillerOrderNumberProcedure"},
    {0X00401008, DCM_VR_TAG_LO, "ConfidentialityCode"},
    {0X00401009, DCM_VR_TAG_SH, "ReportingPriority"},
    {0X0040100A, DCM_VR_TAG_SQ, "ReasonForRequestedProcedureCodeSequence"},
    {0X00401010, DCM_VR_TAG_PN, "NamesOfIntendedRecipientsOfResults"},
    {0X00401011, DCM_VR_TAG_SQ, "IntendedRecipientsOfResultsIdentificationSequence"},
    {0X00401012, DCM_VR_TAG_SQ, "ReasonForPerformedProcedureCodeSequence"},
    {0X00401060, DCM_VR_TAG_LO, "RequestedProcedureDescriptionTrial"},
    {0X00401101, DCM_VR_TAG_SQ, "PersonIdentificationCodeSequence"},
    {0X00401102, DCM_VR_TAG_ST, "PersonAddress"},
    {0X00401103, DCM_VR_TAG_LO, "PersonTelephoneNumbers"},
    {0X00401104, DCM_VR_TAG_LT, "PersonTelecomInformation"},
    {0X00401400, DCM_VR_TAG_LT, "RequestedProcedureComments"},
    {0X00402001, DCM_VR_TAG_LO, "ReasonForTheImagingServiceRequest"},
    {0X00402004, DCM_VR_TAG_DA, "IssueDateOfImagingServiceRequest"},
    {0X00402005, DCM_VR_TAG_TM, "IssueTimeOfImagingServiceRequest"},
    {0X00402006, DCM_VR_TAG_SH, "PlacerOrderNumberImagingServiceRequestRetired"},
    {0X00402007, DCM_VR_TAG_SH, "FillerOrderNumberImagingServiceRequestRetired"},
    {0X00402008, DCM_VR_TAG_PN, "OrderEnteredBy"},
    {0X00402009, DCM_VR_TAG_SH, "OrderEntererLocation"},
    {0X00402010, DCM_VR_TAG_SH, "OrderCallbackPhoneNumber"},
    {0X00402011, DCM_VR_TAG_LT, "OrderCallbackTelecomInformation"},
    {0X00402016, DCM_VR_TAG_LO, "PlacerOrderNumberImagingServiceRequest"},
    {0X00402017, DCM_VR_TAG_LO, "FillerOrderNumberImagingServiceRequest"},
    {0X00402400, DCM_VR_TAG_LT, "ImagingServiceRequestComments"},
    {0X00403001, DCM_VR_TAG_LO, "ConfidentialityConstraintOnPatientDataDescription"},
    {0X00404001, DCM_VR_TAG_CS, "GeneralPurposeScheduledProcedureStepStatus"},
    {0X00404002, DCM_VR_TAG_CS, "GeneralPurposePerformedProcedureStepStatus"},
    {0X00404003, DCM_VR_TAG_CS, "GeneralPurposeScheduledProcedureStepPriority"},
    {0X00404004, DCM_VR_TAG_SQ, "ScheduledProcessingApplicationsCodeSequence"},
    {0X00404005, DCM_VR_TAG_DT, "ScheduledProcedureStepStartDateTime"},
    {0X00404006, DCM_VR_TAG_CS, "MultipleCopiesFlag"},
    {0X00404007, DCM_VR_TAG_SQ, "PerformedProcessingApplicationsCodeSequence"},
    {0X00404008, DCM_VR_TAG_DT, "ScheduledProcedureStepExpirationDateTime"},
    {0X00404009, DCM_VR_TAG_SQ, "HumanPerformerCodeSequence"},
    {0X00404010, DCM_VR_TAG_DT, "ScheduledProcedureStepModificationDateTime"},
    {0X00404011, DCM_VR_TAG_DT, "ExpectedCompletionDateTime"},
    {0X00404015, DCM_VR_TAG_SQ, "ResultingGeneralPurposePerformedProcedureStepsSequence"},
    {0X00404016, DCM_VR_TAG_SQ, "ReferencedGeneralPurposeScheduledProcedureStepSequence"},
    {0X00404018, DCM_VR_TAG_SQ, "ScheduledWorkitemCodeSequence"},
    {0X00404019, DCM_VR_TAG_SQ, "PerformedWorkitemCodeSequence"},
    {0X00404020, DCM_VR_TAG_CS, "InputAvailabilityFlag"},
    {0X00404021, DCM_VR_TAG_SQ, "InputInformationSequence"},
    {0X00404022, DCM_VR_TAG_SQ, "RelevantInformationSequence"},
    {0X00404023, DCM_VR_TAG_UI, "ReferencedGeneralPurposeScheduledProcedureStepTransactionUID"},
    {0X00404025, DCM_VR_TAG_SQ, "ScheduledStationNameCodeSequence"},
    {0X00404026, DCM_VR_TAG_SQ, "ScheduledStationClassCodeSequence"},
    {0X00404027, DCM_VR_TAG_SQ, "ScheduledStationGeographicLocationCodeSequence"},
    {0X00404028, DCM_VR_TAG_SQ, "PerformedStationNameCodeSequence"},
    {0X00404029, DCM_VR_TAG_SQ, "PerformedStationClassCodeSequence"},
    {0X00404030, DCM_VR_TAG_SQ, "PerformedStationGeographicLocationCodeSequence"},
    {0X00404031, DCM_VR_TAG_SQ, "RequestedSubsequentWorkitemCodeSequence"},
    {0X00404032, DCM_VR_TAG_SQ, "NonDICOMOutputCodeSequence"},
    {0X00404033, DCM_VR_TAG_SQ, "OutputInformationSequence"},
    {0X00404034, DCM_VR_TAG_SQ, "ScheduledHumanPerformersSequence"},
    {0X00404035, DCM_VR_TAG_SQ, "ActualHumanPerformersSequence"},
    {0X00404036, DCM_VR_TAG_LO, "HumanPerformerOrganization"},
    {0X00404037, DCM_VR_TAG_PN, "HumanPerformerName"},
    {0X00404040, DCM_VR_TAG_CS, "RawDataHandling"},
    {0X00404041, DCM_VR_TAG_CS, "InputReadinessState"},
    {0X00404050, DCM_VR_TAG_DT, "PerformedProcedureStepStartDateTime"},
    {0X00404051, DCM_VR_TAG_DT, "PerformedProcedureStepEndDateTime"},
    {0X00404052, DCM_VR_TAG_DT, "ProcedureStepCancellationDateTime"},
    {0X00404070, DCM_VR_TAG_SQ, "OutputDestinationSequence"},
    {0X00404071, DCM_VR_TAG_SQ, "DICOMStorageSequence"},
    {0X00404072, DCM_VR_TAG_SQ, "STOWRSStorageSequence"},
    {0X00404073, DCM_VR_TAG_UR, "StorageURL"},
    {0X00404074, DCM_VR_TAG_SQ, "XDSStorageSequence"},
    {0X00408302, DCM_VR_TAG_DS, "EntranceDoseInmGy"},
    {0X00408303, DCM_VR_TAG_CS, "EntranceDoseDerivation"},
    {0X00409092, DCM_VR_TAG_SQ, "ParametricMapFrameTypeSequence"},
    {0X00409094, DCM_VR_TAG_SQ, "ReferencedImageRealWorldValueMappingSequence"},
    {0X00409096, DCM_VR_TAG_SQ, "RealWorldValueMappingSequence"},
    {0X00409098, DCM_VR_TAG_SQ, "PixelValueMappingCodeSequence"},
    {0X00409210, DCM_VR_TAG_SH, "LUTLabel"},
    {0X00409211, DCM_VR_TAG_US, "RealWorldValueLastValueMapped"},
    {0X00409212, DCM_VR_TAG_FD, "RealWorldValueLUTData"},
    {0X00409213, DCM_VR_TAG_FD, "DoubleFloatRealWorldValueLastValueMapped"},
    {0X00409214, DCM_VR_TAG_FD, "DoubleFloatRealWorldValueFirstValueMapped"},
    {0X00409216, DCM_VR_TAG_US, "RealWorldValueFirstValueMapped"},
    {0X00409220, DCM_VR_TAG_SQ, "QuantityDefinitionSequence"},
    {0X00409224, DCM_VR_TAG_FD, "RealWorldValueIntercept"},
    {0X00409225, DCM_VR_TAG_FD, "RealWorldValueSlope"},
    {0X0040A007, DCM_VR_TAG_CS, "FindingsFlagTrial"},
    {0X0040A010, DCM_VR_TAG_CS, "RelationshipType"},
    {0X0040A020, DCM_VR_TAG_SQ, "FindingsSequenceTrial"},
    {0X0040A021, DCM_VR_TAG_UI, "FindingsGroupUIDTrial"},
    {0X0040A022, DCM_VR_TAG_UI, "ReferencedFindingsGroupUIDTrial"},
    {0X0040A023, DCM_VR_TAG_DA, "FindingsGroupRecordingDateTrial"},
    {0X0040A024, DCM_VR_TAG_TM, "FindingsGroupRecordingTimeTrial"},
    {0X0040A026, DCM_VR_TAG_SQ, "FindingsSourceCategoryCodeSequenceTrial"},
    {0X0040A027, DCM_VR_TAG_LO, "VerifyingOrganization"},
    {0X0040A028, DCM_VR_TAG_SQ, "DocumentingOrganizationIdentifierCodeSequenceTrial"},
    {0X0040A030, DCM_VR_TAG_DT, "VerificationDateTime"},
    {0X0040A032, DCM_VR_TAG_DT, "ObservationDateTime"},
    {0X0040A033, DCM_VR_TAG_DT, "ObservationStartDateTime"},
    {0X0040A040, DCM_VR_TAG_CS, "ValueType"},
    {0X0040A043, DCM_VR_TAG_SQ, "ConceptNameCodeSequence"},
    {0X0040A047, DCM_VR_TAG_LO, "MeasurementPrecisionDescriptionTrial"},
    {0X0040A050, DCM_VR_TAG_CS, "ContinuityOfContent"},
    {0X0040A057, DCM_VR_TAG_CS, "UrgencyOrPriorityAlertsTrial"},
    {0X0040A060, DCM_VR_TAG_LO, "SequencingIndicatorTrial"},
    {0X0040A066, DCM_VR_TAG_SQ, "DocumentIdentifierCodeSequenceTrial"},
    {0X0040A067, DCM_VR_TAG_PN, "DocumentAuthorTrial"},
    {0X0040A068, DCM_VR_TAG_SQ, "DocumentAuthorIdentifierCodeSequenceTrial"},
    {0X0040A070, DCM_VR_TAG_SQ, "IdentifierCodeSequenceTrial"},
    {0X0040A073, DCM_VR_TAG_SQ, "VerifyingObserverSequence"},
    {0X0040A074, DCM_VR_TAG_OB, "ObjectBinaryIdentifierTrial"},
    {0X0040A075, DCM_VR_TAG_PN, "VerifyingObserverName"},
    {0X0040A076, DCM_VR_TAG_SQ, "DocumentingObserverIdentifierCodeSequenceTrial"},
    {0X0040A078, DCM_VR_TAG_SQ, "AuthorObserverSequence"},
    {0X0040A07A, DCM_VR_TAG_SQ, "ParticipantSequence"},
    {0X0040A07C, DCM_VR_TAG_SQ, "CustodialOrganizationSequence"},
    {0X0040A080, DCM_VR_TAG_CS, "ParticipationType"},
    {0X0040A082, DCM_VR_TAG_DT, "ParticipationDateTime"},
    {0X0040A084, DCM_VR_TAG_CS, "ObserverType"},
    {0X0040A085, DCM_VR_TAG_SQ, "ProcedureIdentifierCodeSequenceTrial"},
    {0X0040A088, DCM_VR_TAG_SQ, "VerifyingObserverIdentificationCodeSequence"},
    {0X0040A089, DCM_VR_TAG_OB, "ObjectDirectoryBinaryIdentifierTrial"},
    {0X0040A090, DCM_VR_TAG_SQ, "EquivalentCDADocumentSequence"},
    {0X0040A0B0, DCM_VR_TAG_US, "ReferencedWaveformChannels"},
    {0X0040A110, DCM_VR_TAG_DA, "DateOfDocumentOrVerbalTransactionTrial"},
    {0X0040A112, DCM_VR_TAG_TM, "TimeOfDocumentCreationOrVerbalTransactionTrial"},
    {0X0040A120, DCM_VR_TAG_DT, "DateTime"},
    {0X0040A121, DCM_VR_TAG_DA, "Date"},
    {0X0040A122, DCM_VR_TAG_TM, "Time"},
    {0X0040A123, DCM_VR_TAG_PN, "PersonName"},
    {0X0040A124, DCM_VR_TAG_UI, "UID"},
    {0X0040A125, DCM_VR_TAG_CS, "ReportStatusIDTrial"},
    {0X0040A130, DCM_VR_TAG_CS, "TemporalRangeType"},
    {0X0040A132, DCM_VR_TAG_UL, "ReferencedSamplePositions"},
    {0X0040A136, DCM_VR_TAG_US, "ReferencedFrameNumbers"},
    {0X0040A138, DCM_VR_TAG_DS, "ReferencedTimeOffsets"},
    {0X0040A13A, DCM_VR_TAG_DT, "ReferencedDateTime"},
    {0X0040A160, DCM_VR_TAG_UT, "TextValue"},
    {0X0040A161, DCM_VR_TAG_FD, "FloatingPointValue"},
    {0X0040A162, DCM_VR_TAG_SL, "RationalNumeratorValue"},
    {0X0040A163, DCM_VR_TAG_UL, "RationalDenominatorValue"},
    {0X0040A167, DCM_VR_TAG_SQ, "ObservationCategoryCodeSequenceTrial"},
    {0X0040A168, DCM_VR_TAG_SQ, "ConceptCodeSequence"},
    {0X0040A16A, DCM_VR_TAG_ST, "BibliographicCitationTrial"},
    {0X0040A170, DCM_VR_TAG_SQ, "PurposeOfReferenceCodeSequence"},
    {0X0040A171, DCM_VR_TAG_UI, "ObservationUID"},
    {0X0040A172, DCM_VR_TAG_UI, "ReferencedObservationUIDTrial"},
    {0X0040A173, DCM_VR_TAG_CS, "ReferencedObservationClassTrial"},
    {0X0040A174, DCM_VR_TAG_CS, "ReferencedObjectObservationClassTrial"},
    {0X0040A180, DCM_VR_TAG_US, "AnnotationGroupNumber"},
    {0X0040A192, DCM_VR_TAG_DA, "ObservationDateTrial"},
    {0X0040A193, DCM_VR_TAG_TM, "ObservationTimeTrial"},
    {0X0040A194, DCM_VR_TAG_CS, "MeasurementAutomationTrial"},
    {0X0040A195, DCM_VR_TAG_SQ, "ModifierCodeSequence"},
    {0X0040A224, DCM_VR_TAG_ST, "IdentificationDescriptionTrial"},
    {0X0040A290, DCM_VR_TAG_CS, "CoordinatesSetGeometricTypeTrial"},
    {0X0040A296, DCM_VR_TAG_SQ, "AlgorithmCodeSequenceTrial"},
    {0X0040A297, DCM_VR_TAG_ST, "AlgorithmDescriptionTrial"},
    {0X0040A29A, DCM_VR_TAG_SL, "PixelCoordinatesSetTrial"},
    {0X0040A300, DCM_VR_TAG_SQ, "MeasuredValueSequence"},
    {0X0040A301, DCM_VR_TAG_SQ, "NumericValueQualifierCodeSequence"},
    {0X0040A307, DCM_VR_TAG_PN, "CurrentObserverTrial"},
    {0X0040A30A, DCM_VR_TAG_DS, "NumericValue"},
    {0X0040A313, DCM_VR_TAG_SQ, "ReferencedAccessionSequenceTrial"},
    {0X0040A33A, DCM_VR_TAG_ST, "ReportStatusCommentTrial"},
    {0X0040A340, DCM_VR_TAG_SQ, "ProcedureContextSequenceTrial"},
    {0X0040A352, DCM_VR_TAG_PN, "VerbalSourceTrial"},
    {0X0040A353, DCM_VR_TAG_ST, "AddressTrial"},
    {0X0040A354, DCM_VR_TAG_LO, "TelephoneNumberTrial"},
    {0X0040A358, DCM_VR_TAG_SQ, "VerbalSourceIdentifierCodeSequenceTrial"},
    {0X0040A360, DCM_VR_TAG_SQ, "PredecessorDocumentsSequence"},
    {0X0040A370, DCM_VR_TAG_SQ, "ReferencedRequestSequence"},
    {0X0040A372, DCM_VR_TAG_SQ, "PerformedProcedureCodeSequence"},
    {0X0040A375, DCM_VR_TAG_SQ, "CurrentRequestedProcedureEvidenceSequence"},
    {0X0040A380, DCM_VR_TAG_SQ, "ReportDetailSequenceTrial"},
    {0X0040A385, DCM_VR_TAG_SQ, "PertinentOtherEvidenceSequence"},
    {0X0040A390, DCM_VR_TAG_SQ, "HL7StructuredDocumentReferenceSequence"},
    {0X0040A402, DCM_VR_TAG_UI, "ObservationSubjectUIDTrial"},
    {0X0040A403, DCM_VR_TAG_CS, "ObservationSubjectClassTrial"},
    {0X0040A404, DCM_VR_TAG_SQ, "ObservationSubjectTypeCodeSequenceTrial"},
    {0X0040A491, DCM_VR_TAG_CS, "CompletionFlag"},
    {0X0040A492, DCM_VR_TAG_LO, "CompletionFlagDescription"},
    {0X0040A493, DCM_VR_TAG_CS, "VerificationFlag"},
    {0X0040A494, DCM_VR_TAG_CS, "ArchiveRequested"},
    {0X0040A496, DCM_VR_TAG_CS, "PreliminaryFlag"},
    {0X0040A504, DCM_VR_TAG_SQ, "ContentTemplateSequence"},
    {0X0040A525, DCM_VR_TAG_SQ, "IdenticalDocumentsSequence"},
    {0X0040A600, DCM_VR_TAG_CS, "ObservationSubjectContextFlagTrial"},
    {0X0040A601, DCM_VR_TAG_CS, "ObserverContextFlagTrial"},
    {0X0040A603, DCM_VR_TAG_CS, "ProcedureContextFlagTrial"},
    {0X0040A730, DCM_VR_TAG_SQ, "ContentSequence"},
    {0X0040A731, DCM_VR_TAG_SQ, "RelationshipSequenceTrial"},
    {0X0040A732, DCM_VR_TAG_SQ, "RelationshipTypeCodeSequenceTrial"},
    {0X0040A744, DCM_VR_TAG_SQ, "LanguageCodeSequenceTrial"},
    {0X0040A801, DCM_VR_TAG_SQ, "TabulatedValuesSequence"},
    {0X0040A802, DCM_VR_TAG_UL, "NumberOfTableRows"},
    {0X0040A803, DCM_VR_TAG_UL, "NumbeOfTableColumns"},
    {0X0040A804, DCM_VR_TAG_UL, "TableRowNumber"},
    {0X0040A805, DCM_VR_TAG_UL, "TableColumnNumber"},
    {0X0040A806, DCM_VR_TAG_SQ, "TableRowDefinitionSequence"},
    {0X0040A807, DCM_VR_TAG_SQ, "TableColumnDefinitionSequence"},
    {0X0040A808, DCM_VR_TAG_SQ, "CellValuesSequence"},
    {0X0040A992, DCM_VR_TAG_ST, "UniformResourceLocatorTrial"},
    {0X0040B020, DCM_VR_TAG_SQ, "WaveformAnnotationSequence"},
    {0X0040DB00, DCM_VR_TAG_CS, "TemplateIdentifier"},
    {0X0040DB06, DCM_VR_TAG_DT, "TemplateVersion"},
    {0X0040DB07, DCM_VR_TAG_DT, "TemplateLocalVersion"},
    {0X0040DB0B, DCM_VR_TAG_CS, "TemplateExtensionFlag"},
    {0X0040DB0C, DCM_VR_TAG_UI, "TemplateExtensionOrganizationUID"},
    {0X0040DB0D, DCM_VR_TAG_UI, "TemplateExtensionCreatorUID"},
    {0X0040DB73, DCM_VR_TAG_UL, "ReferencedContentItemIdentifier"},
    {0X0040E001, DCM_VR_TAG_ST, "HL7InstanceIdentifier"},
    {0X0040E004, DCM_VR_TAG_DT, "HL7DocumentEffectiveTime"},
    {0X0040E006, DCM_VR_TAG_SQ, "HL7DocumentTypeCodeSequence"},
    {0X0040E008, DCM_VR_TAG_SQ, "DocumentClassCodeSequence"},
    {0X0040E010, DCM_VR_TAG_UR, "RetrieveURI"},
    {0X0040E011, DCM_VR_TAG_UI, "RetrieveLocationUID"},
    {0X0040E020, DCM_VR_TAG_CS, "TypeOfInstances"},
    {0X0040E021, DCM_VR_TAG_SQ, "DICOMRetrievalSequence"},
    {0X0040E022, DCM_VR_TAG_SQ, "DICOMMediaRetrievalSequence"},
    {0X0040E023, DCM_VR_TAG_SQ, "WADORetrievalSequence"},
    {0X0040E024, DCM_VR_TAG_SQ, "XDSRetrievalSequence"},
    {0X0040E025, DCM_VR_TAG_SQ, "WADORSRetrievalSequence"},
    {0X0040E030, DCM_VR_TAG_UI, "RepositoryUniqueID"},
    {0X0040E031, DCM_VR_TAG_UI, "HomeCommunityID"},
    {0X00420010, DCM_VR_TAG_ST, "DocumentTitle"},
    {0X00420011, DCM_VR_TAG_OB, "EncapsulatedDocument"},
    {0X00420012, DCM_VR_TAG_LO, "MIMETypeOfEncapsulatedDocument"},
    {0X00420013, DCM_VR_TAG_SQ, "SourceInstanceSequence"},
    {0X00420014, DCM_VR_TAG_LO, "ListOfMIMETypes"},
    {0X00420015, DCM_VR_TAG_UL, "EncapsulatedDocumentLength"},
    {0X00440001, DCM_VR_TAG_ST, "ProductPackageIdentifier"},
    {0X00440002, DCM_VR_TAG_CS, "SubstanceAdministrationApproval"},
    {0X00440003, DCM_VR_TAG_LT, "ApprovalStatusFurtherDescription"},
    {0X00440004, DCM_VR_TAG_DT, "ApprovalStatusDateTime"},
    {0X00440007, DCM_VR_TAG_SQ, "ProductTypeCodeSequence"},
    {0X00440008, DCM_VR_TAG_LO, "ProductName"},
    {0X00440009, DCM_VR_TAG_LT, "ProductDescription"},
    {0X0044000A, DCM_VR_TAG_LO, "ProductLotIdentifier"},
    {0X0044000B, DCM_VR_TAG_DT, "ProductExpirationDateTime"},
    {0X00440010, DCM_VR_TAG_DT, "SubstanceAdministrationDateTime"},
    {0X00440011, DCM_VR_TAG_LO, "SubstanceAdministrationNotes"},
    {0X00440012, DCM_VR_TAG_LO, "SubstanceAdministrationDeviceID"},
    {0X00440013, DCM_VR_TAG_SQ, "ProductParameterSequence"},
    {0X00440019, DCM_VR_TAG_SQ, "SubstanceAdministrationParameterSequence"},
    {0X00440100, DCM_VR_TAG_SQ, "ApprovalSequence"},
    {0X00440101, DCM_VR_TAG_SQ, "AssertionCodeSequence"},
    {0X00440102, DCM_VR_TAG_UI, "AssertionUID"},
    {0X00440103, DCM_VR_TAG_SQ, "AsserterIdentificationSequence"},
    {0X00440104, DCM_VR_TAG_DT, "AssertionDateTime"},
    {0X00440105, DCM_VR_TAG_DT, "AssertionExpirationDateTime"},
    {0X00440106, DCM_VR_TAG_UT, "AssertionComments"},
    {0X00440107, DCM_VR_TAG_SQ, "RelatedAssertionSequence"},
    {0X00440108, DCM_VR_TAG_UI, "ReferencedAssertionUID"},
    {0X00440109, DCM_VR_TAG_SQ, "ApprovalSubjectSequence"},
    {0X0044010A, DCM_VR_TAG_SQ, "OrganizationalRoleCodeSequence"},
    {0X00460012, DCM_VR_TAG_LO, "LensDescription"},
    {0X00460014, DCM_VR_TAG_SQ, "RightLensSequence"},
    {0X00460015, DCM_VR_TAG_SQ, "LeftLensSequence"},
    {0X00460016, DCM_VR_TAG_SQ, "UnspecifiedLateralityLensSequence"},
    {0X00460018, DCM_VR_TAG_SQ, "CylinderSequence"},
    {0X00460028, DCM_VR_TAG_SQ, "PrismSequence"},
    {0X00460030, DCM_VR_TAG_FD, "HorizontalPrismPower"},
    {0X00460032, DCM_VR_TAG_CS, "HorizontalPrismBase"},
    {0X00460034, DCM_VR_TAG_FD, "VerticalPrismPower"},
    {0X00460036, DCM_VR_TAG_CS, "VerticalPrismBase"},
    {0X00460038, DCM_VR_TAG_CS, "LensSegmentType"},
    {0X00460040, DCM_VR_TAG_FD, "OpticalTransmittance"},
    {0X00460042, DCM_VR_TAG_FD, "ChannelWidth"},
    {0X00460044, DCM_VR_TAG_FD, "PupilSize"},
    {0X00460046, DCM_VR_TAG_FD, "CornealSize"},
    {0X00460047, DCM_VR_TAG_SQ, "CornealSizeSequence"},
    {0X00460050, DCM_VR_TAG_SQ, "AutorefractionRightEyeSequence"},
    {0X00460052, DCM_VR_TAG_SQ, "AutorefractionLeftEyeSequence"},
    {0X00460060, DCM_VR_TAG_FD, "DistancePupillaryDistance"},
    {0X00460062, DCM_VR_TAG_FD, "NearPupillaryDistance"},
    {0X00460063, DCM_VR_TAG_FD, "IntermediatePupillaryDistance"},
    {0X00460064, DCM_VR_TAG_FD, "OtherPupillaryDistance"},
    {0X00460070, DCM_VR_TAG_SQ, "KeratometryRightEyeSequence"},
    {0X00460071, DCM_VR_TAG_SQ, "KeratometryLeftEyeSequence"},
    {0X00460074, DCM_VR_TAG_SQ, "SteepKeratometricAxisSequence"},
    {0X00460075, DCM_VR_TAG_FD, "RadiusOfCurvature"},
    {0X00460076, DCM_VR_TAG_FD, "KeratometricPower"},
    {0X00460077, DCM_VR_TAG_FD, "KeratometricAxis"},
    {0X00460080, DCM_VR_TAG_SQ, "FlatKeratometricAxisSequence"},
    {0X00460092, DCM_VR_TAG_CS, "BackgroundColor"},
    {0X00460094, DCM_VR_TAG_CS, "Optotype"},
    {0X00460095, DCM_VR_TAG_CS, "OptotypePresentation"},
    {0X00460097, DCM_VR_TAG_SQ, "SubjectiveRefractionRightEyeSequence"},
    {0X00460098, DCM_VR_TAG_SQ, "SubjectiveRefractionLeftEyeSequence"},
    {0X00460100, DCM_VR_TAG_SQ, "AddNearSequence"},
    {0X00460101, DCM_VR_TAG_SQ, "AddIntermediateSequence"},
    {0X00460102, DCM_VR_TAG_SQ, "AddOtherSequence"},
    {0X00460104, DCM_VR_TAG_FD, "AddPower"},
    {0X00460106, DCM_VR_TAG_FD, "ViewingDistance"},
    {0X00460110, DCM_VR_TAG_SQ, "CorneaMeasurementsSequence"},
    {0X00460111, DCM_VR_TAG_SQ, "SourceOfCorneaMeasurementDataCodeSequence"},
    {0X00460112, DCM_VR_TAG_SQ, "SteepCornealAxisSequence"},
    {0X00460113, DCM_VR_TAG_SQ, "FlatCornealAxisSequence"},
    {0X00460114, DCM_VR_TAG_FD, "CornealPower"},
    {0X00460115, DCM_VR_TAG_FD, "CornealAxis"},
    {0X00460116, DCM_VR_TAG_SQ, "CorneaMeasurementMethodCodeSequence"},
    {0X00460117, DCM_VR_TAG_FL, "RefractiveIndexOfCornea"},
    {0X00460118, DCM_VR_TAG_FL, "RefractiveIndexOfAqueousHumor"},
    {0X00460121, DCM_VR_TAG_SQ, "VisualAcuityTypeCodeSequence"},
    {0X00460122, DCM_VR_TAG_SQ, "VisualAcuityRightEyeSequence"},
    {0X00460123, DCM_VR_TAG_SQ, "VisualAcuityLeftEyeSequence"},
    {0X00460124, DCM_VR_TAG_SQ, "VisualAcuityBothEyesOpenSequence"},
    {0X00460125, DCM_VR_TAG_CS, "ViewingDistanceType"},
    {0X00460135, DCM_VR_TAG_SS, "VisualAcuityModifiers"},
    {0X00460137, DCM_VR_TAG_FD, "DecimalVisualAcuity"},
    {0X00460139, DCM_VR_TAG_LO, "OptotypeDetailedDefinition"},
    {0X00460145, DCM_VR_TAG_SQ, "ReferencedRefractiveMeasurementsSequence"},
    {0X00460146, DCM_VR_TAG_FD, "SpherePower"},
    {0X00460147, DCM_VR_TAG_FD, "CylinderPower"},
    {0X00460201, DCM_VR_TAG_CS, "CornealTopographySurface"},
    {0X00460202, DCM_VR_TAG_FL, "CornealVertexLocation"},
    {0X00460203, DCM_VR_TAG_FL, "PupilCentroidXCoordinate"},
    {0X00460204, DCM_VR_TAG_FL, "PupilCentroidYCoordinate"},
    {0X00460205, DCM_VR_TAG_FL, "EquivalentPupilRadius"},
    {0X00460207, DCM_VR_TAG_SQ, "CornealTopographyMapTypeCodeSequence"},
    {0X00460208, DCM_VR_TAG_IS, "VerticesOfTheOutlineOfPupil"},
    {0X00460210, DCM_VR_TAG_SQ, "CornealTopographyMappingNormalsSequence"},
    {0X00460211, DCM_VR_TAG_SQ, "MaximumCornealCurvatureSequence"},
    {0X00460212, DCM_VR_TAG_FL, "MaximumCornealCurvature"},
    {0X00460213, DCM_VR_TAG_FL, "MaximumCornealCurvatureLocation"},
    {0X00460215, DCM_VR_TAG_SQ, "MinimumKeratometricSequence"},
    {0X00460218, DCM_VR_TAG_SQ, "SimulatedKeratometricCylinderSequence"},
    {0X00460220, DCM_VR_TAG_FL, "AverageCornealPower"},
    {0X00460224, DCM_VR_TAG_FL, "CornealISValue"},
    {0X00460227, DCM_VR_TAG_FL, "AnalyzedArea"},
    {0X00460230, DCM_VR_TAG_FL, "SurfaceRegularityIndex"},
    {0X00460232, DCM_VR_TAG_FL, "SurfaceAsymmetryIndex"},
    {0X00460234, DCM_VR_TAG_FL, "CornealEccentricityIndex"},
    {0X00460236, DCM_VR_TAG_FL, "KeratoconusPredictionIndex"},
    {0X00460238, DCM_VR_TAG_FL, "DecimalPotentialVisualAcuity"},
    {0X00460242, DCM_VR_TAG_CS, "CornealTopographyMapQualityEvaluation"},
    {0X00460244, DCM_VR_TAG_SQ, "SourceImageCornealProcessedDataSequence"},
    {0X00460247, DCM_VR_TAG_FL, "CornealPointLocation"},
    {0X00460248, DCM_VR_TAG_CS, "CornealPointEstimated"},
    {0X00460249, DCM_VR_TAG_FL, "AxialPower"},
    {0X00460250, DCM_VR_TAG_FL, "TangentialPower"},
    {0X00460251, DCM_VR_TAG_FL, "RefractivePower"},
    {0X00460252, DCM_VR_TAG_FL, "RelativeElevation"},
    {0X00460253, DCM_VR_TAG_FL, "CornealWavefront"},
    {0X00480001, DCM_VR_TAG_FL, "ImagedVolumeWidth"},
    {0X00480002, DCM_VR_TAG_FL, "ImagedVolumeHeight"},
    {0X00480003, DCM_VR_TAG_FL, "ImagedVolumeDepth"},
    {0X00480006, DCM_VR_TAG_UL, "TotalPixelMatrixColumns"},
    {0X00480007, DCM_VR_TAG_UL, "TotalPixelMatrixRows"},
    {0X00480008, DCM_VR_TAG_SQ, "TotalPixelMatrixOriginSequence"},
    {0X00480010, DCM_VR_TAG_CS, "SpecimenLabelInImage"},
    {0X00480011, DCM_VR_TAG_CS, "FocusMethod"},
    {0X00480012, DCM_VR_TAG_CS, "ExtendedDepthOfField"},
    {0X00480013, DCM_VR_TAG_US, "NumberOfFocalPlanes"},
    {0X00480014, DCM_VR_TAG_FL, "DistanceBetweenFocalPlanes"},
    {0X00480015, DCM_VR_TAG_US, "RecommendedAbsentPixelCIELabValue"},
    {0X00480100, DCM_VR_TAG_SQ, "IlluminatorTypeCodeSequence"},
    {0X00480102, DCM_VR_TAG_DS, "ImageOrientationSlide"},
    {0X00480105, DCM_VR_TAG_SQ, "OpticalPathSequence"},
    {0X00480106, DCM_VR_TAG_SH, "OpticalPathIdentifier"},
    {0X00480107, DCM_VR_TAG_ST, "OpticalPathDescription"},
    {0X00480108, DCM_VR_TAG_SQ, "IlluminationColorCodeSequence"},
    {0X00480110, DCM_VR_TAG_SQ, "SpecimenReferenceSequence"},
    {0X00480111, DCM_VR_TAG_DS, "CondenserLensPower"},
    {0X00480112, DCM_VR_TAG_DS, "ObjectiveLensPower"},
    {0X00480113, DCM_VR_TAG_DS, "ObjectiveLensNumericalAperture"},
    {0X00480120, DCM_VR_TAG_SQ, "PaletteColorLookupTableSequence"},
    {0X00480200, DCM_VR_TAG_SQ, "ReferencedImageNavigationSequence"},
    {0X00480201, DCM_VR_TAG_US, "TopLeftHandCornerOfLocalizerArea"},
    {0X00480202, DCM_VR_TAG_US, "BottomRightHandCornerOfLocalizerArea"},
    {0X00480207, DCM_VR_TAG_SQ, "OpticalPathIdentificationSequence"},
    {0X0048021A, DCM_VR_TAG_SQ, "PlanePositionSlideSequence"},
    {0X0048021E, DCM_VR_TAG_SL, "ColumnPositionInTotalImagePixelMatrix"},
    {0X0048021F, DCM_VR_TAG_SL, "RowPositionInTotalImagePixelMatrix"},
    {0X00480301, DCM_VR_TAG_CS, "PixelOriginInterpretation"},
    {0X00480302, DCM_VR_TAG_UL, "NumberOfOpticalPaths"},
    {0X00480303, DCM_VR_TAG_UL, "TotalPixelMatrixFocalPlanes"},
    {0X00500004, DCM_VR_TAG_CS, "CalibrationImage"},
    {0X00500010, DCM_VR_TAG_SQ, "DeviceSequence"},
    {0X00500012, DCM_VR_TAG_SQ, "ContainerComponentTypeCodeSequence"},
    {0X00500013, DCM_VR_TAG_FD, "ContainerComponentThickness"},
    {0X00500014, DCM_VR_TAG_DS, "DeviceLength"},
    {0X00500015, DCM_VR_TAG_FD, "ContainerComponentWidth"},
    {0X00500016, DCM_VR_TAG_DS, "DeviceDiameter"},
    {0X00500017, DCM_VR_TAG_CS, "DeviceDiameterUnits"},
    {0X00500018, DCM_VR_TAG_DS, "DeviceVolume"},
    {0X00500019, DCM_VR_TAG_DS, "InterMarkerDistance"},
    {0X0050001A, DCM_VR_TAG_CS, "ContainerComponentMaterial"},
    {0X0050001B, DCM_VR_TAG_LO, "ContainerComponentID"},
    {0X0050001C, DCM_VR_TAG_FD, "ContainerComponentLength"},
    {0X0050001D, DCM_VR_TAG_FD, "ContainerComponentDiameter"},
    {0X0050001E, DCM_VR_TAG_LO, "ContainerComponentDescription"},
    {0X00500020, DCM_VR_TAG_LO, "DeviceDescription"},
    {0X00500021, DCM_VR_TAG_ST, "LongDeviceDescription"},
    {0X00520001, DCM_VR_TAG_FL, "ContrastBolusIngredientPercentByVolume"},
    {0X00520002, DCM_VR_TAG_FD, "OCTFocalDistance"},
    {0X00520003, DCM_VR_TAG_FD, "BeamSpotSize"},
    {0X00520004, DCM_VR_TAG_FD, "EffectiveRefractiveIndex"},
    {0X00520006, DCM_VR_TAG_CS, "OCTAcquisitionDomain"},
    {0X00520007, DCM_VR_TAG_FD, "OCTOpticalCenterWavelength"},
    {0X00520008, DCM_VR_TAG_FD, "AxialResolution"},
    {0X00520009, DCM_VR_TAG_FD, "RangingDepth"},
    {0X00520011, DCM_VR_TAG_FD, "ALineRate"},
    {0X00520012, DCM_VR_TAG_US, "ALinesPerFrame"},
    {0X00520013, DCM_VR_TAG_FD, "CatheterRotationalRate"},
    {0X00520014, DCM_VR_TAG_FD, "ALinePixelSpacing"},
    {0X00520016, DCM_VR_TAG_SQ, "ModeOfPercutaneousAccessSequence"},
    {0X00520025, DCM_VR_TAG_SQ, "IntravascularOCTFrameTypeSequence"},
    {0X00520026, DCM_VR_TAG_CS, "OCTZOffsetApplied"},
    {0X00520027, DCM_VR_TAG_SQ, "IntravascularFrameContentSequence"},
    {0X00520028, DCM_VR_TAG_FD, "IntravascularLongitudinalDistance"},
    {0X00520029, DCM_VR_TAG_SQ, "IntravascularOCTFrameContentSequence"},
    {0X00520030, DCM_VR_TAG_SS, "OCTZOffsetCorrection"},
    {0X00520031, DCM_VR_TAG_CS, "CatheterDirectionOfRotation"},
    {0X00520033, DCM_VR_TAG_FD, "SeamLineLocation"},
    {0X00520034, DCM_VR_TAG_FD, "FirstALineLocation"},
    {0X00520036, DCM_VR_TAG_US, "SeamLineIndex"},
    {0X00520038, DCM_VR_TAG_US, "NumberOfPaddedALines"},
    {0X00520039, DCM_VR_TAG_CS, "InterpolationType"},
    {0X0052003A, DCM_VR_TAG_CS, "RefractiveIndexApplied"},
    {0X00540010, DCM_VR_TAG_US, "EnergyWindowVector"},
    {0X00540011, DCM_VR_TAG_US, "NumberOfEnergyWindows"},
    {0X00540012, DCM_VR_TAG_SQ, "EnergyWindowInformationSequence"},
    {0X00540013, DCM_VR_TAG_SQ, "EnergyWindowRangeSequence"},
    {0X00540014, DCM_VR_TAG_DS, "EnergyWindowLowerLimit"},
    {0X00540015, DCM_VR_TAG_DS, "EnergyWindowUpperLimit"},
    {0X00540016, DCM_VR_TAG_SQ, "RadiopharmaceuticalInformationSequence"},
    {0X00540017, DCM_VR_TAG_IS, "ResidualSyringeCounts"},
    {0X00540018, DCM_VR_TAG_SH, "EnergyWindowName"},
    {0X00540020, DCM_VR_TAG_US, "DetectorVector"},
    {0X00540021, DCM_VR_TAG_US, "NumberOfDetectors"},
    {0X00540022, DCM_VR_TAG_SQ, "DetectorInformationSequence"},
    {0X00540030, DCM_VR_TAG_US, "PhaseVector"},
    {0X00540031, DCM_VR_TAG_US, "NumberOfPhases"},
    {0X00540032, DCM_VR_TAG_SQ, "PhaseInformationSequence"},
    {0X00540033, DCM_VR_TAG_US, "NumberOfFramesInPhase"},
    {0X00540036, DCM_VR_TAG_IS, "PhaseDelay"},
    {0X00540038, DCM_VR_TAG_IS, "PauseBetweenFrames"},
    {0X00540039, DCM_VR_TAG_CS, "PhaseDescription"},
    {0X00540050, DCM_VR_TAG_US, "RotationVector"},
    {0X00540051, DCM_VR_TAG_US, "NumberOfRotations"},
    {0X00540052, DCM_VR_TAG_SQ, "RotationInformationSequence"},
    {0X00540053, DCM_VR_TAG_US, "NumberOfFramesInRotation"},
    {0X00540060, DCM_VR_TAG_US, "RRIntervalVector"},
    {0X00540061, DCM_VR_TAG_US, "NumberOfRRIntervals"},
    {0X00540062, DCM_VR_TAG_SQ, "GatedInformationSequence"},
    {0X00540063, DCM_VR_TAG_SQ, "DataInformationSequence"},
    {0X00540070, DCM_VR_TAG_US, "TimeSlotVector"},
    {0X00540071, DCM_VR_TAG_US, "NumberOfTimeSlots"},
    {0X00540072, DCM_VR_TAG_SQ, "TimeSlotInformationSequence"},
    {0X00540073, DCM_VR_TAG_DS, "TimeSlotTime"},
    {0X00540080, DCM_VR_TAG_US, "SliceVector"},
    {0X00540081, DCM_VR_TAG_US, "NumberOfSlices"},
    {0X00540090, DCM_VR_TAG_US, "AngularViewVector"},
    {0X00540100, DCM_VR_TAG_US, "TimeSliceVector"},
    {0X00540101, DCM_VR_TAG_US, "NumberOfTimeSlices"},
    {0X00540200, DCM_VR_TAG_DS, "StartAngle"},
    {0X00540202, DCM_VR_TAG_CS, "TypeOfDetectorMotion"},
    {0X00540210, DCM_VR_TAG_IS, "TriggerVector"},
    {0X00540211, DCM_VR_TAG_US, "NumberOfTriggersInPhase"},
    {0X00540220, DCM_VR_TAG_SQ, "ViewCodeSequence"},
    {0X00540222, DCM_VR_TAG_SQ, "ViewModifierCodeSequence"},
    {0X00540300, DCM_VR_TAG_SQ, "RadionuclideCodeSequence"},
    {0X00540302, DCM_VR_TAG_SQ, "AdministrationRouteCodeSequence"},
    {0X00540304, DCM_VR_TAG_SQ, "RadiopharmaceuticalCodeSequence"},
    {0X00540306, DCM_VR_TAG_SQ, "CalibrationDataSequence"},
    {0X00540308, DCM_VR_TAG_US, "EnergyWindowNumber"},
    {0X00540400, DCM_VR_TAG_SH, "ImageID"},
    {0X00540410, DCM_VR_TAG_SQ, "PatientOrientationCodeSequence"},
    {0X00540412, DCM_VR_TAG_SQ, "PatientOrientationModifierCodeSequence"},
    {0X00540414, DCM_VR_TAG_SQ, "PatientGantryRelationshipCodeSequence"},
    {0X00540500, DCM_VR_TAG_CS, "SliceProgressionDirection"},
    {0X00540501, DCM_VR_TAG_CS, "ScanProgressionDirection"},
    {0X00541000, DCM_VR_TAG_CS, "SeriesType"},
    {0X00541001, DCM_VR_TAG_CS, "Units"},
    {0X00541002, DCM_VR_TAG_CS, "CountsSource"},
    {0X00541004, DCM_VR_TAG_CS, "ReprojectionMethod"},
    {0X00541006, DCM_VR_TAG_CS, "SUVType"},
    {0X00541100, DCM_VR_TAG_CS, "RandomsCorrectionMethod"},
    {0X00541101, DCM_VR_TAG_LO, "AttenuationCorrectionMethod"},
    {0X00541102, DCM_VR_TAG_CS, "DecayCorrection"},
    {0X00541103, DCM_VR_TAG_LO, "ReconstructionMethod"},
    {0X00541104, DCM_VR_TAG_LO, "DetectorLinesOfResponseUsed"},
    {0X00541105, DCM_VR_TAG_LO, "ScatterCorrectionMethod"},
    {0X00541200, DCM_VR_TAG_DS, "AxialAcceptance"},
    {0X00541201, DCM_VR_TAG_IS, "AxialMash"},
    {0X00541202, DCM_VR_TAG_IS, "TransverseMash"},
    {0X00541203, DCM_VR_TAG_DS, "DetectorElementSize"},
    {0X00541210, DCM_VR_TAG_DS, "CoincidenceWindowWidth"},
    {0X00541220, DCM_VR_TAG_CS, "SecondaryCountsType"},
    {0X00541300, DCM_VR_TAG_DS, "FrameReferenceTime"},
    {0X00541310, DCM_VR_TAG_IS, "PrimaryPromptsCountsAccumulated"},
    {0X00541311, DCM_VR_TAG_IS, "SecondaryCountsAccumulated"},
    {0X00541320, DCM_VR_TAG_DS, "SliceSensitivityFactor"},
    {0X00541321, DCM_VR_TAG_DS, "DecayFactor"},
    {0X00541322, DCM_VR_TAG_DS, "DoseCalibrationFactor"},
    {0X00541323, DCM_VR_TAG_DS, "ScatterFractionFactor"},
    {0X00541324, DCM_VR_TAG_DS, "DeadTimeFactor"},
    {0X00541330, DCM_VR_TAG_US, "ImageIndex"},
    {0X00541400, DCM_VR_TAG_CS, "CountsIncluded"},
    {0X00541401, DCM_VR_TAG_CS, "DeadTimeCorrectionFlag"},
    {0X00603000, DCM_VR_TAG_SQ, "HistogramSequence"},
    {0X00603002, DCM_VR_TAG_US, "HistogramNumberOfBins"},
    {0X00603004, DCM_VR_TAG_US_SS, "HistogramFirstBinValue"},
    {0X00603006, DCM_VR_TAG_US_SS, "HistogramLastBinValue"},
    {0X00603008, DCM_VR_TAG_US, "HistogramBinWidth"},
    {0X00603010, DCM_VR_TAG_LO, "HistogramExplanation"},
    {0X00603020, DCM_VR_TAG_UL, "HistogramData"},
    {0X00620001, DCM_VR_TAG_CS, "SegmentationType"},
    {0X00620002, DCM_VR_TAG_SQ, "SegmentSequence"},
    {0X00620003, DCM_VR_TAG_SQ, "SegmentedPropertyCategoryCodeSequence"},
    {0X00620004, DCM_VR_TAG_US, "SegmentNumber"},
    {0X00620005, DCM_VR_TAG_LO, "SegmentLabel"},
    {0X00620006, DCM_VR_TAG_ST, "SegmentDescription"},
    {0X00620007, DCM_VR_TAG_SQ, "SegmentationAlgorithmIdentificationSequence"},
    {0X00620008, DCM_VR_TAG_CS, "SegmentAlgorithmType"},
    {0X00620009, DCM_VR_TAG_LO, "SegmentAlgorithmName"},
    {0X0062000A, DCM_VR_TAG_SQ, "SegmentIdentificationSequence"},
    {0X0062000B, DCM_VR_TAG_US, "ReferencedSegmentNumber"},
    {0X0062000C, DCM_VR_TAG_US, "RecommendedDisplayGrayscaleValue"},
    {0X0062000D, DCM_VR_TAG_US, "RecommendedDisplayCIELabValue"},
    {0X0062000E, DCM_VR_TAG_US, "MaximumFractionalValue"},
    {0X0062000F, DCM_VR_TAG_SQ, "SegmentedPropertyTypeCodeSequence"},
    {0X00620010, DCM_VR_TAG_CS, "SegmentationFractionalType"},
    {0X00620011, DCM_VR_TAG_SQ, "SegmentedPropertyTypeModifierCodeSequence"},
    {0X00620012, DCM_VR_TAG_SQ, "UsedSegmentsSequence"},
    {0X00620013, DCM_VR_TAG_CS, "SegmentsOverlap"},
    {0X00620020, DCM_VR_TAG_UT, "TrackingID"},
    {0X00620021, DCM_VR_TAG_UI, "TrackingUID"},
    {0X00640002, DCM_VR_TAG_SQ, "DeformableRegistrationSequence"},
    {0X00640003, DCM_VR_TAG_UI, "SourceFrameOfReferenceUID"},
    {0X00640005, DCM_VR_TAG_SQ, "DeformableRegistrationGridSequence"},
    {0X00640007, DCM_VR_TAG_UL, "GridDimensions"},
    {0X00640008, DCM_VR_TAG_FD, "GridResolution"},
    {0X00640009, DCM_VR_TAG_OF, "VectorGridData"},
    {0X0064000F, DCM_VR_TAG_SQ, "PreDeformationMatrixRegistrationSequence"},
    {0X00640010, DCM_VR_TAG_SQ, "PostDeformationMatrixRegistrationSequence"},
    {0X00660001, DCM_VR_TAG_UL, "NumberOfSurfaces"},
    {0X00660002, DCM_VR_TAG_SQ, "SurfaceSequence"},
    {0X00660003, DCM_VR_TAG_UL, "SurfaceNumber"},
    {0X00660004, DCM_VR_TAG_LT, "SurfaceComments"},
    {0X00660009, DCM_VR_TAG_CS, "SurfaceProcessing"},
    {0X0066000A, DCM_VR_TAG_FL, "SurfaceProcessingRatio"},
    {0X0066000B, DCM_VR_TAG_LO, "SurfaceProcessingDescription"},
    {0X0066000C, DCM_VR_TAG_FL, "RecommendedPresentationOpacity"},
    {0X0066000D, DCM_VR_TAG_CS, "RecommendedPresentationType"},
    {0X0066000E, DCM_VR_TAG_CS, "FiniteVolume"},
    {0X00660010, DCM_VR_TAG_CS, "Manifold"},
    {0X00660011, DCM_VR_TAG_SQ, "SurfacePointsSequence"},
    {0X00660012, DCM_VR_TAG_SQ, "SurfacePointsNormalsSequence"},
    {0X00660013, DCM_VR_TAG_SQ, "SurfaceMeshPrimitivesSequence"},
    {0X00660015, DCM_VR_TAG_UL, "NumberOfSurfacePoints"},
    {0X00660016, DCM_VR_TAG_OF, "PointCoordinatesData"},
    {0X00660017, DCM_VR_TAG_FL, "PointPositionAccuracy"},
    {0X00660018, DCM_VR_TAG_FL, "MeanPointDistance"},
    {0X00660019, DCM_VR_TAG_FL, "MaximumPointDistance"},
    {0X0066001A, DCM_VR_TAG_FL, "PointsBoundingBoxCoordinates"},
    {0X0066001B, DCM_VR_TAG_FL, "AxisOfRotation"},
    {0X0066001C, DCM_VR_TAG_FL, "CenterOfRotation"},
    {0X0066001E, DCM_VR_TAG_UL, "NumberOfVectors"},
    {0X0066001F, DCM_VR_TAG_US, "VectorDimensionality"},
    {0X00660020, DCM_VR_TAG_FL, "VectorAccuracy"},
    {0X00660021, DCM_VR_TAG_OF, "VectorCoordinateData"},
    {0X00660022, DCM_VR_TAG_OD, "DoublePointCoordinatesData"},
    {0X00660023, DCM_VR_TAG_OW, "TrianglePointIndexList"},
    {0X00660024, DCM_VR_TAG_OW, "EdgePointIndexList"},
    {0X00660025, DCM_VR_TAG_OW, "VertexPointIndexList"},
    {0X00660026, DCM_VR_TAG_SQ, "TriangleStripSequence"},
    {0X00660027, DCM_VR_TAG_SQ, "TriangleFanSequence"},
    {0X00660028, DCM_VR_TAG_SQ, "LineSequence"},
    {0X00660029, DCM_VR_TAG_OW, "PrimitivePointIndexList"},
    {0X0066002A, DCM_VR_TAG_UL, "SurfaceCount"},
    {0X0066002B, DCM_VR_TAG_SQ, "ReferencedSurfaceSequence"},
    {0X0066002C, DCM_VR_TAG_UL, "ReferencedSurfaceNumber"},
    {0X0066002D, DCM_VR_TAG_SQ, "SegmentSurfaceGenerationAlgorithmIdentificationSequence"},
    {0X0066002E, DCM_VR_TAG_SQ, "SegmentSurfaceSourceInstanceSequence"},
    {0X0066002F, DCM_VR_TAG_SQ, "AlgorithmFamilyCodeSequence"},
    {0X00660030, DCM_VR_TAG_SQ, "AlgorithmNameCodeSequence"},
    {0X00660031, DCM_VR_TAG_LO, "AlgorithmVersion"},
    {0X00660032, DCM_VR_TAG_LT, "AlgorithmParameters"},
    {0X00660034, DCM_VR_TAG_SQ, "FacetSequence"},
    {0X00660035, DCM_VR_TAG_SQ, "SurfaceProcessingAlgorithmIdentificationSequence"},
    {0X00660036, DCM_VR_TAG_LO, "AlgorithmName"},
    {0X00660037, DCM_VR_TAG_FL, "RecommendedPointRadius"},
    {0X00660038, DCM_VR_TAG_FL, "RecommendedLineThickness"},
    {0X00660040, DCM_VR_TAG_OL, "LongPrimitivePointIndexList"},
    {0X00660041, DCM_VR_TAG_OL, "LongTrianglePointIndexList"},
    {0X00660042, DCM_VR_TAG_OL, "LongEdgePointIndexList"},
    {0X00660043, DCM_VR_TAG_OL, "LongVertexPointIndexList"},
    {0X00660101, DCM_VR_TAG_SQ, "TrackSetSequence"},
    {0X00660102, DCM_VR_TAG_SQ, "TrackSequence"},
    {0X00660103, DCM_VR_TAG_OW, "RecommendedDisplayCIELabValueList"},
    {0X00660104, DCM_VR_TAG_SQ, "TrackingAlgorithmIdentificationSequence"},
    {0X00660105, DCM_VR_TAG_UL, "TrackSetNumber"},
    {0X00660106, DCM_VR_TAG_LO, "TrackSetLabel"},
    {0X00660107, DCM_VR_TAG_UT, "TrackSetDescription"},
    {0X00660108, DCM_VR_TAG_SQ, "TrackSetAnatomicalTypeCodeSequence"},
    {0X00660121, DCM_VR_TAG_SQ, "MeasurementsSequence"},
    {0X00660124, DCM_VR_TAG_SQ, "TrackSetStatisticsSequence"},
    {0X00660125, DCM_VR_TAG_OF, "FloatingPointValues"},
    {0X00660129, DCM_VR_TAG_OL, "TrackPointIndexList"},
    {0X00660130, DCM_VR_TAG_SQ, "TrackStatisticsSequence"},
    {0X00660132, DCM_VR_TAG_SQ, "MeasurementValuesSequence"},
    {0X00660133, DCM_VR_TAG_SQ, "DiffusionAcquisitionCodeSequence"},
    {0X00660134, DCM_VR_TAG_SQ, "DiffusionModelCodeSequence"},
    {0X00686210, DCM_VR_TAG_LO, "ImplantSize"},
    {0X00686221, DCM_VR_TAG_LO, "ImplantTemplateVersion"},
    {0X00686222, DCM_VR_TAG_SQ, "ReplacedImplantTemplateSequence"},
    {0X00686223, DCM_VR_TAG_CS, "ImplantType"},
    {0X00686224, DCM_VR_TAG_SQ, "DerivationImplantTemplateSequence"},
    {0X00686225, DCM_VR_TAG_SQ, "OriginalImplantTemplateSequence"},
    {0X00686226, DCM_VR_TAG_DT, "EffectiveDateTime"},
    {0X00686230, DCM_VR_TAG_SQ, "ImplantTargetAnatomySequence"},
    {0X00686260, DCM_VR_TAG_SQ, "InformationFromManufacturerSequence"},
    {0X00686265, DCM_VR_TAG_SQ, "NotificationFromManufacturerSequence"},
    {0X00686270, DCM_VR_TAG_DT, "InformationIssueDateTime"},
    {0X00686280, DCM_VR_TAG_ST, "InformationSummary"},
    {0X006862A0, DCM_VR_TAG_SQ, "ImplantRegulatoryDisapprovalCodeSequence"},
    {0X006862A5, DCM_VR_TAG_FD, "OverallTemplateSpatialTolerance"},
    {0X006862C0, DCM_VR_TAG_SQ, "HPGLDocumentSequence"},
    {0X006862D0, DCM_VR_TAG_US, "HPGLDocumentID"},
    {0X006862D5, DCM_VR_TAG_LO, "HPGLDocumentLabel"},
    {0X006862E0, DCM_VR_TAG_SQ, "ViewOrientationCodeSequence"},
    {0X006862F0, DCM_VR_TAG_SQ, "ViewOrientationModifierCodeSequence"},
    {0X006862F2, DCM_VR_TAG_FD, "HPGLDocumentScaling"},
    {0X00686300, DCM_VR_TAG_OB, "HPGLDocument"},
    {0X00686310, DCM_VR_TAG_US, "HPGLContourPenNumber"},
    {0X00686320, DCM_VR_TAG_SQ, "HPGLPenSequence"},
    {0X00686330, DCM_VR_TAG_US, "HPGLPenNumber"},
    {0X00686340, DCM_VR_TAG_LO, "HPGLPenLabel"},
    {0X00686345, DCM_VR_TAG_ST, "HPGLPenDescription"},
    {0X00686346, DCM_VR_TAG_FD, "RecommendedRotationPoint"},
    {0X00686347, DCM_VR_TAG_FD, "BoundingRectangle"},
    {0X00686350, DCM_VR_TAG_US, "ImplantTemplate3DModelSurfaceNumber"},
    {0X00686360, DCM_VR_TAG_SQ, "SurfaceModelDescriptionSequence"},
    {0X00686380, DCM_VR_TAG_LO, "SurfaceModelLabel"},
    {0X00686390, DCM_VR_TAG_FD, "SurfaceModelScalingFactor"},
    {0X006863A0, DCM_VR_TAG_SQ, "MaterialsCodeSequence"},
    {0X006863A4, DCM_VR_TAG_SQ, "CoatingMaterialsCodeSequence"},
    {0X006863A8, DCM_VR_TAG_SQ, "ImplantTypeCodeSequence"},
    {0X006863AC, DCM_VR_TAG_SQ, "FixationMethodCodeSequence"},
    {0X006863B0, DCM_VR_TAG_SQ, "MatingFeatureSetsSequence"},
    {0X006863C0, DCM_VR_TAG_US, "MatingFeatureSetID"},
    {0X006863D0, DCM_VR_TAG_LO, "MatingFeatureSetLabel"},
    {0X006863E0, DCM_VR_TAG_SQ, "MatingFeatureSequence"},
    {0X006863F0, DCM_VR_TAG_US, "MatingFeatureID"},
    {0X00686400, DCM_VR_TAG_SQ, "MatingFeatureDegreeOfFreedomSequence"},
    {0X00686410, DCM_VR_TAG_US, "DegreeOfFreedomID"},
    {0X00686420, DCM_VR_TAG_CS, "DegreeOfFreedomType"},
    {0X00686430, DCM_VR_TAG_SQ, "TwoDMatingFeatureCoordinatesSequence"},
    {0X00686440, DCM_VR_TAG_US, "ReferencedHPGLDocumentID"},
    {0X00686450, DCM_VR_TAG_FD, "TwoDMatingPoint"},
    {0X00686460, DCM_VR_TAG_FD, "TwoDMatingAxes"},
    {0X00686470, DCM_VR_TAG_SQ, "TwoDDegreeOfFreedomSequence"},
    {0X00686490, DCM_VR_TAG_FD, "ThreeDDegreeOfFreedomAxis"},
    {0X006864A0, DCM_VR_TAG_FD, "RangeOfFreedom"},
    {0X006864C0, DCM_VR_TAG_FD, "ThreeDMatingPoint"},
    {0X006864D0, DCM_VR_TAG_FD, "ThreeDMatingAxes"},
    {0X006864F0, DCM_VR_TAG_FD, "TwoDDegreeOfFreedomAxis"},
    {0X00686500, DCM_VR_TAG_SQ, "PlanningLandmarkPointSequence"},
    {0X00686510, DCM_VR_TAG_SQ, "PlanningLandmarkLineSequence"},
    {0X00686520, DCM_VR_TAG_SQ, "PlanningLandmarkPlaneSequence"},
    {0X00686530, DCM_VR_TAG_US, "PlanningLandmarkID"},
    {0X00686540, DCM_VR_TAG_LO, "PlanningLandmarkDescription"},
    {0X00686545, DCM_VR_TAG_SQ, "PlanningLandmarkIdentificationCodeSequence"},
    {0X00686550, DCM_VR_TAG_SQ, "TwoDPointCoordinatesSequence"},
    {0X00686560, DCM_VR_TAG_FD, "TwoDPointCoordinates"},
    {0X00686590, DCM_VR_TAG_FD, "ThreeDPointCoordinates"},
    {0X006865A0, DCM_VR_TAG_SQ, "TwoDLineCoordinatesSequence"},
    {0X006865B0, DCM_VR_TAG_FD, "TwoDLineCoordinates"},
    {0X006865D0, DCM_VR_TAG_FD, "ThreeDLineCoordinates"},
    {0X006865E0, DCM_VR_TAG_SQ, "TwoDPlaneCoordinatesSequence"},
    {0X006865F0, DCM_VR_TAG_FD, "TwoDPlaneIntersection"},
    {0X00686610, DCM_VR_TAG_FD, "ThreeDPlaneOrigin"},
    {0X00686620, DCM_VR_TAG_FD, "ThreeDPlaneNormal"},
    {0X00687001, DCM_VR_TAG_CS, "ModelModification"},
    {0X00687002, DCM_VR_TAG_CS, "ModelMirroring"},
    {0X00687003, DCM_VR_TAG_SQ, "ModelUsageCodeSequence"},
    {0X00687004, DCM_VR_TAG_UI, "ModelGroupUID"},
    {0X00687005, DCM_VR_TAG_UR, "RelativeURIReferenceWithinEncapsulatedDocument"},
    {0X006A0001, DCM_VR_TAG_CS, "AnnotationCoordinateType"},
    {0X006A0002, DCM_VR_TAG_SQ, "AnnotationGroupSequence"},
    {0X006A0003, DCM_VR_TAG_UI, "AnnotationGroupUID"},
    {0X006A0005, DCM_VR_TAG_LO, "AnnotationGroupLabel"},
    {0X006A0006, DCM_VR_TAG_UT, "AnnotationGroupDescription"},
    {0X006A0007, DCM_VR_TAG_CS, "AnnotationGroupGenerationType"},
    {0X006A0008, DCM_VR_TAG_SQ, "AnnotationGroupAlgorithmIdentificationSequence"},
    {0X006A0009, DCM_VR_TAG_SQ, "AnnotationPropertyCategoryCodeSequence"},
    {0X006A000A, DCM_VR_TAG_SQ, "AnnotationPropertyTypeCodeSequence"},
    {0X006A000B, DCM_VR_TAG_SQ, "AnnotationPropertyTypeModifierCodeSequence"},
    {0X006A000C, DCM_VR_TAG_UL, "NumberOfAnnotations"},
    {0X006A000D, DCM_VR_TAG_CS, "AnnotationAppliesToAllOpticalPaths"},
    {0X006A000E, DCM_VR_TAG_SH, "ReferencedOpticalPathIdentifier"},
    {0X006A000F, DCM_VR_TAG_CS, "AnnotationAppliesToAllZPlanes"},
    {0X006A0010, DCM_VR_TAG_FD, "CommonZCoordinateValue"},
    {0X006A0011, DCM_VR_TAG_OL, "AnnotationIndexList"},
    {0X00700001, DCM_VR_TAG_SQ, "GraphicAnnotationSequence"},
    {0X00700002, DCM_VR_TAG_CS, "GraphicLayer"},
    {0X00700003, DCM_VR_TAG_CS, "BoundingBoxAnnotationUnits"},
    {0X00700004, DCM_VR_TAG_CS, "AnchorPointAnnotationUnits"},
    {0X00700005, DCM_VR_TAG_CS, "GraphicAnnotationUnits"},
    {0X00700006, DCM_VR_TAG_ST, "UnformattedTextValue"},
    {0X00700008, DCM_VR_TAG_SQ, "TextObjectSequence"},
    {0X00700009, DCM_VR_TAG_SQ, "GraphicObjectSequence"},
    {0X00700010, DCM_VR_TAG_FL, "BoundingBoxTopLeftHandCorner"},
    {0X00700011, DCM_VR_TAG_FL, "BoundingBoxBottomRightHandCorner"},
    {0X00700012, DCM_VR_TAG_CS, "BoundingBoxTextHorizontalJustification"},
    {0X00700014, DCM_VR_TAG_FL, "AnchorPoint"},
    {0X00700015, DCM_VR_TAG_CS, "AnchorPointVisibility"},
    {0X00700020, DCM_VR_TAG_US, "GraphicDimensions"},
    {0X00700021, DCM_VR_TAG_US, "NumberOfGraphicPoints"},
    {0X00700022, DCM_VR_TAG_FL, "GraphicData"},
    {0X00700023, DCM_VR_TAG_CS, "GraphicType"},
    {0X00700024, DCM_VR_TAG_CS, "GraphicFilled"},
    {0X00700040, DCM_VR_TAG_IS, "ImageRotationRetired"},
    {0X00700041, DCM_VR_TAG_CS, "ImageHorizontalFlip"},
    {0X00700042, DCM_VR_TAG_US, "ImageRotation"},
    {0X00700050, DCM_VR_TAG_US, "DisplayedAreaTopLeftHandCornerTrial"},
    {0X00700051, DCM_VR_TAG_US, "DisplayedAreaBottomRightHandCornerTrial"},
    {0X00700052, DCM_VR_TAG_SL, "DisplayedAreaTopLeftHandCorner"},
    {0X00700053, DCM_VR_TAG_SL, "DisplayedAreaBottomRightHandCorner"},
    {0X0070005A, DCM_VR_TAG_SQ, "DisplayedAreaSelectionSequence"},
    {0X00700060, DCM_VR_TAG_SQ, "GraphicLayerSequence"},
    {0X00700062, DCM_VR_TAG_IS, "GraphicLayerOrder"},
    {0X00700066, DCM_VR_TAG_US, "GraphicLayerRecommendedDisplayGrayscaleValue"},
    {0X00700067, DCM_VR_TAG_US, "GraphicLayerRecommendedDisplayRGBValue"},
    {0X00700068, DCM_VR_TAG_LO, "GraphicLayerDescription"},
    {0X00700080, DCM_VR_TAG_CS, "ContentLabel"},
    {0X00700081, DCM_VR_TAG_LO, "ContentDescription"},
    {0X00700082, DCM_VR_TAG_DA, "PresentationCreationDate"},
    {0X00700083, DCM_VR_TAG_TM, "PresentationCreationTime"},
    {0X00700084, DCM_VR_TAG_PN, "ContentCreatorName"},
    {0X00700086, DCM_VR_TAG_SQ, "ContentCreatorIdentificationCodeSequence"},
    {0X00700087, DCM_VR_TAG_SQ, "AlternateContentDescriptionSequence"},
    {0X00700100, DCM_VR_TAG_CS, "PresentationSizeMode"},
    {0X00700101, DCM_VR_TAG_DS, "PresentationPixelSpacing"},
    {0X00700102, DCM_VR_TAG_IS, "PresentationPixelAspectRatio"},
    {0X00700103, DCM_VR_TAG_FL, "PresentationPixelMagnificationRatio"},
    {0X00700207, DCM_VR_TAG_LO, "GraphicGroupLabel"},
    {0X00700208, DCM_VR_TAG_ST, "GraphicGroupDescription"},
    {0X00700209, DCM_VR_TAG_SQ, "CompoundGraphicSequence"},
    {0X00700226, DCM_VR_TAG_UL, "CompoundGraphicInstanceID"},
    {0X00700227, DCM_VR_TAG_LO, "FontName"},
    {0X00700228, DCM_VR_TAG_CS, "FontNameType"},
    {0X00700229, DCM_VR_TAG_LO, "CSSFontName"},
    {0X00700230, DCM_VR_TAG_FD, "RotationAngle"},
    {0X00700231, DCM_VR_TAG_SQ, "TextStyleSequence"},
    {0X00700232, DCM_VR_TAG_SQ, "LineStyleSequence"},
    {0X00700233, DCM_VR_TAG_SQ, "FillStyleSequence"},
    {0X00700234, DCM_VR_TAG_SQ, "GraphicGroupSequence"},
    {0X00700241, DCM_VR_TAG_US, "TextColorCIELabValue"},
    {0X00700242, DCM_VR_TAG_CS, "HorizontalAlignment"},
    {0X00700243, DCM_VR_TAG_CS, "VerticalAlignment"},
    {0X00700244, DCM_VR_TAG_CS, "ShadowStyle"},
    {0X00700245, DCM_VR_TAG_FL, "ShadowOffsetX"},
    {0X00700246, DCM_VR_TAG_FL, "ShadowOffsetY"},
    {0X00700247, DCM_VR_TAG_US, "ShadowColorCIELabValue"},
    {0X00700248, DCM_VR_TAG_CS, "Underlined"},
    {0X00700249, DCM_VR_TAG_CS, "Bold"},
    {0X00700250, DCM_VR_TAG_CS, "Italic"},
    {0X00700251, DCM_VR_TAG_US, "PatternOnColorCIELabValue"},
    {0X00700252, DCM_VR_TAG_US, "PatternOffColorCIELabValue"},
    {0X00700253, DCM_VR_TAG_FL, "LineThickness"},
    {0X00700254, DCM_VR_TAG_CS, "LineDashingStyle"},
    {0X00700255, DCM_VR_TAG_UL, "LinePattern"},
    {0X00700256, DCM_VR_TAG_OB, "FillPattern"},
    {0X00700257, DCM_VR_TAG_CS, "FillMode"},
    {0X00700258, DCM_VR_TAG_FL, "ShadowOpacity"},
    {0X00700261, DCM_VR_TAG_FL, "GapLength"},
    {0X00700262, DCM_VR_TAG_FL, "DiameterOfVisibility"},
    {0X00700273, DCM_VR_TAG_FL, "RotationPoint"},
    {0X00700274, DCM_VR_TAG_CS, "TickAlignment"},
    {0X00700278, DCM_VR_TAG_CS, "ShowTickLabel"},
    {0X00700279, DCM_VR_TAG_CS, "TickLabelAlignment"},
    {0X00700282, DCM_VR_TAG_CS, "CompoundGraphicUnits"},
    {0X00700284, DCM_VR_TAG_FL, "PatternOnOpacity"},
    {0X00700285, DCM_VR_TAG_FL, "PatternOffOpacity"},
    {0X00700287, DCM_VR_TAG_SQ, "MajorTicksSequence"},
    {0X00700288, DCM_VR_TAG_FL, "TickPosition"},
    {0X00700289, DCM_VR_TAG_SH, "TickLabel"},
    {0X00700294, DCM_VR_TAG_CS, "CompoundGraphicType"},
    {0X00700295, DCM_VR_TAG_UL, "GraphicGroupID"},
    {0X00700306, DCM_VR_TAG_CS, "ShapeType"},
    {0X00700308, DCM_VR_TAG_SQ, "RegistrationSequence"},
    {0X00700309, DCM_VR_TAG_SQ, "MatrixRegistrationSequence"},
    {0X0070030A, DCM_VR_TAG_SQ, "MatrixSequence"},
    {0X0070030B, DCM_VR_TAG_FD, "FrameOfReferenceToDisplayedCoordinateSystemTransformationMatrix"},
    {0X0070030C, DCM_VR_TAG_CS, "FrameOfReferenceTransformationMatrixType"},
    {0X0070030D, DCM_VR_TAG_SQ, "RegistrationTypeCodeSequence"},
    {0X0070030F, DCM_VR_TAG_ST, "FiducialDescription"},
    {0X00700310, DCM_VR_TAG_SH, "FiducialIdentifier"},
    {0X00700311, DCM_VR_TAG_SQ, "FiducialIdentifierCodeSequence"},
    {0X00700312, DCM_VR_TAG_FD, "ContourUncertaintyRadius"},
    {0X00700314, DCM_VR_TAG_SQ, "UsedFiducialsSequence"},
    {0X00700318, DCM_VR_TAG_SQ, "GraphicCoordinatesDataSequence"},
    {0X0070031A, DCM_VR_TAG_UI, "FiducialUID"},
    {0X0070031B, DCM_VR_TAG_UI, "ReferencedFiducialUID"},
    {0X0070031C, DCM_VR_TAG_SQ, "FiducialSetSequence"},
    {0X0070031E, DCM_VR_TAG_SQ, "FiducialSequence"},
    {0X0070031F, DCM_VR_TAG_SQ, "FiducialsPropertyCategoryCodeSequence"},
    {0X00700401, DCM_VR_TAG_US, "GraphicLayerRecommendedDisplayCIELabValue"},
    {0X00700402, DCM_VR_TAG_SQ, "BlendingSequence"},
    {0X00700403, DCM_VR_TAG_FL, "RelativeOpacity"},
    {0X00700404, DCM_VR_TAG_SQ, "ReferencedSpatialRegistrationSequence"},
    {0X00700405, DCM_VR_TAG_CS, "BlendingPosition"},
    {0X00701101, DCM_VR_TAG_UI, "PresentationDisplayCollectionUID"},
    {0X00701102, DCM_VR_TAG_UI, "PresentationSequenceCollectionUID"},
    {0X00701103, DCM_VR_TAG_US, "PresentationSequencePositionIndex"},
    {0X00701104, DCM_VR_TAG_SQ, "RenderedImageReferenceSequence"},
    {0X00701201, DCM_VR_TAG_SQ, "VolumetricPresentationStateInputSequence"},
    {0X00701202, DCM_VR_TAG_CS, "PresentationInputType"},
    {0X00701203, DCM_VR_TAG_US, "InputSequencePositionIndex"},
    {0X00701204, DCM_VR_TAG_CS, "Crop"},
    {0X00701205, DCM_VR_TAG_US, "CroppingSpecificationIndex"},
    {0X00701206, DCM_VR_TAG_CS, "CompositingMethod"},
    {0X00701207, DCM_VR_TAG_US, "VolumetricPresentationInputNumber"},
    {0X00701208, DCM_VR_TAG_CS, "ImageVolumeGeometry"},
    {0X00701209, DCM_VR_TAG_UI, "VolumetricPresentationInputSetUID"},
    {0X0070120A, DCM_VR_TAG_SQ, "VolumetricPresentationInputSetSequence"},
    {0X0070120B, DCM_VR_TAG_CS, "GlobalCrop"},
    {0X0070120C, DCM_VR_TAG_US, "GlobalCroppingSpecificationIndex"},
    {0X0070120D, DCM_VR_TAG_CS, "RenderingMethod"},
    {0X00701301, DCM_VR_TAG_SQ, "VolumeCroppingSequence"},
    {0X00701302, DCM_VR_TAG_CS, "VolumeCroppingMethod"},
    {0X00701303, DCM_VR_TAG_FD, "BoundingBoxCrop"},
    {0X00701304, DCM_VR_TAG_SQ, "ObliqueCroppingPlaneSequence"},
    {0X00701305, DCM_VR_TAG_FD, "Plane"},
    {0X00701306, DCM_VR_TAG_FD, "PlaneNormal"},
    {0X00701309, DCM_VR_TAG_US, "CroppingSpecificationNumber"},
    {0X00701501, DCM_VR_TAG_CS, "MultiPlanarReconstructionStyle"},
    {0X00701502, DCM_VR_TAG_CS, "MPRThicknessType"},
    {0X00701503, DCM_VR_TAG_FD, "MPRSlabThickness"},
    {0X00701505, DCM_VR_TAG_FD, "MPRTopLeftHandCorner"},
    {0X00701507, DCM_VR_TAG_FD, "MPRViewWidthDirection"},
    {0X00701508, DCM_VR_TAG_FD, "MPRViewWidth"},
    {0X0070150C, DCM_VR_TAG_UL, "NumberOfVolumetricCurvePoints"},
    {0X0070150D, DCM_VR_TAG_OD, "VolumetricCurvePoints"},
    {0X00701511, DCM_VR_TAG_FD, "MPRViewHeightDirection"},
    {0X00701512, DCM_VR_TAG_FD, "MPRViewHeight"},
    {0X00701602, DCM_VR_TAG_CS, "RenderProjection"},
    {0X00701603, DCM_VR_TAG_FD, "ViewpointPosition"},
    {0X00701604, DCM_VR_TAG_FD, "ViewpointLookAtPoint"},
    {0X00701605, DCM_VR_TAG_FD, "ViewpointUpDirection"},
    {0X00701606, DCM_VR_TAG_FD, "RenderFieldOfView"},
    {0X00701607, DCM_VR_TAG_FD, "SamplingStepSize"},
    {0X00701701, DCM_VR_TAG_CS, "ShadingStyle"},
    {0X00701702, DCM_VR_TAG_FD, "AmbientReflectionIntensity"},
    {0X00701703, DCM_VR_TAG_FD, "LightDirection"},
    {0X00701704, DCM_VR_TAG_FD, "DiffuseReflectionIntensity"},
    {0X00701705, DCM_VR_TAG_FD, "SpecularReflectionIntensity"},
    {0X00701706, DCM_VR_TAG_FD, "Shininess"},
    {0X00701801, DCM_VR_TAG_SQ, "PresentationStateClassificationComponentSequence"},
    {0X00701802, DCM_VR_TAG_CS, "ComponentType"},
    {0X00701803, DCM_VR_TAG_SQ, "ComponentInputSequence"},
    {0X00701804, DCM_VR_TAG_US, "VolumetricPresentationInputIndex"},
    {0X00701805, DCM_VR_TAG_SQ, "PresentationStateCompositorComponentSequence"},
    {0X00701806, DCM_VR_TAG_SQ, "WeightingTransferFunctionSequence"},
    {0X00701807, DCM_VR_TAG_US, "WeightingLookupTableDescriptor"},
    {0X00701808, DCM_VR_TAG_OB, "WeightingLookupTableData"},
    {0X00701901, DCM_VR_TAG_SQ, "VolumetricAnnotationSequence"},
    {0X00701903, DCM_VR_TAG_SQ, "ReferencedStructuredContextSequence"},
    {0X00701904, DCM_VR_TAG_UI, "ReferencedContentItem"},
    {0X00701905, DCM_VR_TAG_SQ, "VolumetricPresentationInputAnnotationSequence"},
    {0X00701907, DCM_VR_TAG_CS, "AnnotationClipping"},
    {0X00701A01, DCM_VR_TAG_CS, "PresentationAnimationStyle"},
    {0X00701A03, DCM_VR_TAG_FD, "RecommendedAnimationRate"},
    {0X00701A04, DCM_VR_TAG_SQ, "AnimationCurveSequence"},
    {0X00701A05, DCM_VR_TAG_FD, "AnimationStepSize"},
    {0X00701A06, DCM_VR_TAG_FD, "SwivelRange"},
    {0X00701A07, DCM_VR_TAG_OD, "VolumetricCurveUpDirections"},
    {0X00701A08, DCM_VR_TAG_SQ, "VolumeStreamSequence"},
    {0X00701A09, DCM_VR_TAG_LO, "RGBATransferFunctionDescription"},
    {0X00701B01, DCM_VR_TAG_SQ, "AdvancedBlendingSequence"},
    {0X00701B02, DCM_VR_TAG_US, "BlendingInputNumber"},
    {0X00701B03, DCM_VR_TAG_SQ, "BlendingDisplayInputSequence"},
    {0X00701B04, DCM_VR_TAG_SQ, "BlendingDisplaySequence"},
    {0X00701B06, DCM_VR_TAG_CS, "BlendingMode"},
    {0X00701B07, DCM_VR_TAG_CS, "TimeSeriesBlending"},
    {0X00701B08, DCM_VR_TAG_CS, "GeometryForDisplay"},
    {0X00701B11, DCM_VR_TAG_SQ, "ThresholdSequence"},
    {0X00701B12, DCM_VR_TAG_SQ, "ThresholdValueSequence"},
    {0X00701B13, DCM_VR_TAG_CS, "ThresholdType"},
    {0X00701B14, DCM_VR_TAG_FD, "ThresholdValue"},
    {0X00720002, DCM_VR_TAG_SH, "HangingProtocolName"},
    {0X00720004, DCM_VR_TAG_LO, "HangingProtocolDescription"},
    {0X00720006, DCM_VR_TAG_CS, "HangingProtocolLevel"},
    {0X00720008, DCM_VR_TAG_LO, "HangingProtocolCreator"},
    {0X0072000A, DCM_VR_TAG_DT, "HangingProtocolCreationDateTime"},
    {0X0072000C, DCM_VR_TAG_SQ, "HangingProtocolDefinitionSequence"},
    {0X0072000E, DCM_VR_TAG_SQ, "HangingProtocolUserIdentificationCodeSequence"},
    {0X00720010, DCM_VR_TAG_LO, "HangingProtocolUserGroupName"},
    {0X00720012, DCM_VR_TAG_SQ, "SourceHangingProtocolSequence"},
    {0X00720014, DCM_VR_TAG_US, "NumberOfPriorsReferenced"},
    {0X00720020, DCM_VR_TAG_SQ, "ImageSetsSequence"},
    {0X00720022, DCM_VR_TAG_SQ, "ImageSetSelectorSequence"},
    {0X00720024, DCM_VR_TAG_CS, "ImageSetSelectorUsageFlag"},
    {0X00720026, DCM_VR_TAG_AT, "SelectorAttribute"},
    {0X00720028, DCM_VR_TAG_US, "SelectorValueNumber"},
    {0X00720030, DCM_VR_TAG_SQ, "TimeBasedImageSetsSequence"},
    {0X00720032, DCM_VR_TAG_US, "ImageSetNumber"},
    {0X00720034, DCM_VR_TAG_CS, "ImageSetSelectorCategory"},
    {0X00720038, DCM_VR_TAG_US, "RelativeTime"},
    {0X0072003A, DCM_VR_TAG_CS, "RelativeTimeUnits"},
    {0X0072003C, DCM_VR_TAG_SS, "AbstractPriorValue"},
    {0X0072003E, DCM_VR_TAG_SQ, "AbstractPriorCodeSequence"},
    {0X00720040, DCM_VR_TAG_LO, "ImageSetLabel"},
    {0X00720050, DCM_VR_TAG_CS, "SelectorAttributeVR"},
    {0X00720052, DCM_VR_TAG_AT, "SelectorSequencePointer"},
    {0X00720054, DCM_VR_TAG_LO, "SelectorSequencePointerPrivateCreator"},
    {0X00720056, DCM_VR_TAG_LO, "SelectorAttributePrivateCreator"},
    {0X0072005E, DCM_VR_TAG_AE, "SelectorAEValue"},
    {0X0072005F, DCM_VR_TAG_AS, "SelectorASValue"},
    {0X00720060, DCM_VR_TAG_AT, "SelectorATValue"},
    {0X00720061, DCM_VR_TAG_DA, "SelectorDAValue"},
    {0X00720062, DCM_VR_TAG_CS, "SelectorCSValue"},
    {0X00720063, DCM_VR_TAG_DT, "SelectorDTValue"},
    {0X00720064, DCM_VR_TAG_IS, "SelectorISValue"},
    {0X00720065, DCM_VR_TAG_OB, "SelectorOBValue"},
    {0X00720066, DCM_VR_TAG_LO, "SelectorLOValue"},
    {0X00720067, DCM_VR_TAG_OF, "SelectorOFValue"},
    {0X00720068, DCM_VR_TAG_LT, "SelectorLTValue"},
    {0X00720069, DCM_VR_TAG_OW, "SelectorOWValue"},
    {0X0072006A, DCM_VR_TAG_PN, "SelectorPNValue"},
    {0X0072006B, DCM_VR_TAG_TM, "SelectorTMValue"},
    {0X0072006C, DCM_VR_TAG_SH, "SelectorSHValue"},
    {0X0072006D, DCM_VR_TAG_UN, "SelectorUNValue"},
    {0X0072006E, DCM_VR_TAG_ST, "SelectorSTValue"},
    {0X0072006F, DCM_VR_TAG_UC, "SelectorUCValue"},
    {0X00720070, DCM_VR_TAG_UT, "SelectorUTValue"},
    {0X00720071, DCM_VR_TAG_UR, "SelectorURValue"},
    {0X00720072, DCM_VR_TAG_DS, "SelectorDSValue"},
    {0X00720073, DCM_VR_TAG_OD, "SelectorODValue"},
    {0X00720074, DCM_VR_TAG_FD, "SelectorFDValue"},
    {0X00720075, DCM_VR_TAG_OL, "SelectorOLValue"},
    {0X00720076, DCM_VR_TAG_FL, "SelectorFLValue"},
    {0X00720078, DCM_VR_TAG_UL, "SelectorULValue"},
    {0X0072007A, DCM_VR_TAG_US, "SelectorUSValue"},
    {0X0072007C, DCM_VR_TAG_SL, "SelectorSLValue"},
    {0X0072007E, DCM_VR_TAG_SS, "SelectorSSValue"},
    {0X0072007F, DCM_VR_TAG_UI, "SelectorUIValue"},
    {0X00720080, DCM_VR_TAG_SQ, "SelectorCodeSequenceValue"},
    {0X00720081, DCM_VR_TAG_OV, "SelectorOVValue"},
    {0X00720082, DCM_VR_TAG_SV, "SelectorSVValue"},
    {0X00720083, DCM_VR_TAG_UV, "SelectorUVValue"},
    {0X00720100, DCM_VR_TAG_US, "NumberOfScreens"},
    {0X00720102, DCM_VR_TAG_SQ, "NominalScreenDefinitionSequence"},
    {0X00720104, DCM_VR_TAG_US, "NumberOfVerticalPixels"},
    {0X00720106, DCM_VR_TAG_US, "NumberOfHorizontalPixels"},
    {0X00720108, DCM_VR_TAG_FD, "DisplayEnvironmentSpatialPosition"},
    {0X0072010A, DCM_VR_TAG_US, "ScreenMinimumGrayscaleBitDepth"},
    {0X0072010C, DCM_VR_TAG_US, "ScreenMinimumColorBitDepth"},
    {0X0072010E, DCM_VR_TAG_US, "ApplicationMaximumRepaintTime"},
    {0X00720200, DCM_VR_TAG_SQ, "DisplaySetsSequence"},
    {0X00720202, DCM_VR_TAG_US, "DisplaySetNumber"},
    {0X00720203, DCM_VR_TAG_LO, "DisplaySetLabel"},
    {0X00720204, DCM_VR_TAG_US, "DisplaySetPresentationGroup"},
    {0X00720206, DCM_VR_TAG_LO, "DisplaySetPresentationGroupDescription"},
    {0X00720208, DCM_VR_TAG_CS, "PartialDataDisplayHandling"},
    {0X00720210, DCM_VR_TAG_SQ, "SynchronizedScrollingSequence"},
    {0X00720212, DCM_VR_TAG_US, "DisplaySetScrollingGroup"},
    {0X00720214, DCM_VR_TAG_SQ, "NavigationIndicatorSequence"},
    {0X00720216, DCM_VR_TAG_US, "NavigationDisplaySet"},
    {0X00720218, DCM_VR_TAG_US, "ReferenceDisplaySets"},
    {0X00720300, DCM_VR_TAG_SQ, "ImageBoxesSequence"},
    {0X00720302, DCM_VR_TAG_US, "ImageBoxNumber"},
    {0X00720304, DCM_VR_TAG_CS, "ImageBoxLayoutType"},
    {0X00720306, DCM_VR_TAG_US, "ImageBoxTileHorizontalDimension"},
    {0X00720308, DCM_VR_TAG_US, "ImageBoxTileVerticalDimension"},
    {0X00720310, DCM_VR_TAG_CS, "ImageBoxScrollDirection"},
    {0X00720312, DCM_VR_TAG_CS, "ImageBoxSmallScrollType"},
    {0X00720314, DCM_VR_TAG_US, "ImageBoxSmallScrollAmount"},
    {0X00720316, DCM_VR_TAG_CS, "ImageBoxLargeScrollType"},
    {0X00720318, DCM_VR_TAG_US, "ImageBoxLargeScrollAmount"},
    {0X00720320, DCM_VR_TAG_US, "ImageBoxOverlapPriority"},
    {0X00720330, DCM_VR_TAG_FD, "CineRelativeToRealTime"},
    {0X00720400, DCM_VR_TAG_SQ, "FilterOperationsSequence"},
    {0X00720402, DCM_VR_TAG_CS, "FilterByCategory"},
    {0X00720404, DCM_VR_TAG_CS, "FilterByAttributePresence"},
    {0X00720406, DCM_VR_TAG_CS, "FilterByOperator"},
    {0X00720420, DCM_VR_TAG_US, "StructuredDisplayBackgroundCIELabValue"},
    {0X00720421, DCM_VR_TAG_US, "EmptyImageBoxCIELabValue"},
    {0X00720422, DCM_VR_TAG_SQ, "StructuredDisplayImageBoxSequence"},
    {0X00720424, DCM_VR_TAG_SQ, "StructuredDisplayTextBoxSequence"},
    {0X00720427, DCM_VR_TAG_SQ, "ReferencedFirstFrameSequence"},
    {0X00720430, DCM_VR_TAG_SQ, "ImageBoxSynchronizationSequence"},
    {0X00720432, DCM_VR_TAG_US, "SynchronizedImageBoxList"},
    {0X00720434, DCM_VR_TAG_CS, "TypeOfSynchronization"},
    {0X00720500, DCM_VR_TAG_CS, "BlendingOperationType"},
    {0X00720510, DCM_VR_TAG_CS, "ReformattingOperationType"},
    {0X00720512, DCM_VR_TAG_FD, "ReformattingThickness"},
    {0X00720514, DCM_VR_TAG_FD, "ReformattingInterval"},
    {0X00720516, DCM_VR_TAG_CS, "ReformattingOperationInitialViewDirection"},
    {0X00720520, DCM_VR_TAG_CS, "ThreeDRenderingType"},
    {0X00720600, DCM_VR_TAG_SQ, "SortingOperationsSequence"},
    {0X00720602, DCM_VR_TAG_CS, "SortByCategory"},
    {0X00720604, DCM_VR_TAG_CS, "SortingDirection"},
    {0X00720700, DCM_VR_TAG_CS, "DisplaySetPatientOrientation"},
    {0X00720702, DCM_VR_TAG_CS, "VOIType"},
    {0X00720704, DCM_VR_TAG_CS, "PseudoColorType"},
    {0X00720705, DCM_VR_TAG_SQ, "PseudoColorPaletteInstanceReferenceSequence"},
    {0X00720706, DCM_VR_TAG_CS, "ShowGrayscaleInverted"},
    {0X00720710, DCM_VR_TAG_CS, "ShowImageTrueSizeFlag"},
    {0X00720712, DCM_VR_TAG_CS, "ShowGraphicAnnotationFlag"},
    {0X00720714, DCM_VR_TAG_CS, "ShowPatientDemographicsFlag"},
    {0X00720716, DCM_VR_TAG_CS, "ShowAcquisitionTechniquesFlag"},
    {0X00720717, DCM_VR_TAG_CS, "DisplaySetHorizontalJustification"},
    {0X00720718, DCM_VR_TAG_CS, "DisplaySetVerticalJustification"},
    {0X00740120, DCM_VR_TAG_FD, "ContinuationStartMeterset"},
    {0X00740121, DCM_VR_TAG_FD, "ContinuationEndMeterset"},
    {0X00741000, DCM_VR_TAG_CS, "ProcedureStepState"},
    {0X00741002, DCM_VR_TAG_SQ, "ProcedureStepProgressInformationSequence"},
    {0X00741004, DCM_VR_TAG_DS, "ProcedureStepProgress"},
    {0X00741006, DCM_VR_TAG_ST, "ProcedureStepProgressDescription"},
    {0X00741007, DCM_VR_TAG_SQ, "ProcedureStepProgressParametersSequence"},
    {0X00741008, DCM_VR_TAG_SQ, "ProcedureStepCommunicationsURISequence"},
    {0X0074100A, DCM_VR_TAG_UR, "ContactURI"},
    {0X0074100C, DCM_VR_TAG_LO, "ContactDisplayName"},
    {0X0074100E, DCM_VR_TAG_SQ, "ProcedureStepDiscontinuationReasonCodeSequence"},
    {0X00741020, DCM_VR_TAG_SQ, "BeamTaskSequence"},
    {0X00741022, DCM_VR_TAG_CS, "BeamTaskType"},
    {0X00741024, DCM_VR_TAG_IS, "BeamOrderIndexTrial"},
    {0X00741025, DCM_VR_TAG_CS, "AutosequenceFlag"},
    {0X00741026, DCM_VR_TAG_FD, "TableTopVerticalAdjustedPosition"},
    {0X00741027, DCM_VR_TAG_FD, "TableTopLongitudinalAdjustedPosition"},
    {0X00741028, DCM_VR_TAG_FD, "TableTopLateralAdjustedPosition"},
    {0X0074102A, DCM_VR_TAG_FD, "PatientSupportAdjustedAngle"},
    {0X0074102B, DCM_VR_TAG_FD, "TableTopEccentricAdjustedAngle"},
    {0X0074102C, DCM_VR_TAG_FD, "TableTopPitchAdjustedAngle"},
    {0X0074102D, DCM_VR_TAG_FD, "TableTopRollAdjustedAngle"},
    {0X00741030, DCM_VR_TAG_SQ, "DeliveryVerificationImageSequence"},
    {0X00741032, DCM_VR_TAG_CS, "VerificationImageTiming"},
    {0X00741034, DCM_VR_TAG_CS, "DoubleExposureFlag"},
    {0X00741036, DCM_VR_TAG_CS, "DoubleExposureOrdering"},
    {0X00741038, DCM_VR_TAG_DS, "DoubleExposureMetersetTrial"},
    {0X0074103A, DCM_VR_TAG_DS, "DoubleExposureFieldDeltaTrial"},
    {0X00741040, DCM_VR_TAG_SQ, "RelatedReferenceRTImageSequence"},
    {0X00741042, DCM_VR_TAG_SQ, "GeneralMachineVerificationSequence"},
    {0X00741044, DCM_VR_TAG_SQ, "ConventionalMachineVerificationSequence"},
    {0X00741046, DCM_VR_TAG_SQ, "IonMachineVerificationSequence"},
    {0X00741048, DCM_VR_TAG_SQ, "FailedAttributesSequence"},
    {0X0074104A, DCM_VR_TAG_SQ, "OverriddenAttributesSequence"},
    {0X0074104C, DCM_VR_TAG_SQ, "ConventionalControlPointVerificationSequence"},
    {0X0074104E, DCM_VR_TAG_SQ, "IonControlPointVerificationSequence"},
    {0X00741050, DCM_VR_TAG_SQ, "AttributeOccurrenceSequence"},
    {0X00741052, DCM_VR_TAG_AT, "AttributeOccurrencePointer"},
    {0X00741054, DCM_VR_TAG_UL, "AttributeItemSelector"},
    {0X00741056, DCM_VR_TAG_LO, "AttributeOccurrencePrivateCreator"},
    {0X00741057, DCM_VR_TAG_IS, "SelectorSequencePointerItems"},
    {0X00741200, DCM_VR_TAG_CS, "ScheduledProcedureStepPriority"},
    {0X00741202, DCM_VR_TAG_LO, "WorklistLabel"},
    {0X00741204, DCM_VR_TAG_LO, "ProcedureStepLabel"},
    {0X00741210, DCM_VR_TAG_SQ, "ScheduledProcessingParametersSequence"},
    {0X00741212, DCM_VR_TAG_SQ, "PerformedProcessingParametersSequence"},
    {0X00741216, DCM_VR_TAG_SQ, "UnifiedProcedureStepPerformedProcedureSequence"},
    {0X00741220, DCM_VR_TAG_SQ, "RelatedProcedureStepSequence"},
    {0X00741222, DCM_VR_TAG_LO, "ProcedureStepRelationshipType"},
    {0X00741224, DCM_VR_TAG_SQ, "ReplacedProcedureStepSequence"},
    {0X00741230, DCM_VR_TAG_LO, "DeletionLock"},
    {0X00741234, DCM_VR_TAG_AE, "ReceivingAE"},
    {0X00741236, DCM_VR_TAG_AE, "RequestingAE"},
    {0X00741238, DCM_VR_TAG_LT, "ReasonForCancellation"},
    {0X00741242, DCM_VR_TAG_CS, "SCPStatus"},
    {0X00741244, DCM_VR_TAG_CS, "SubscriptionListStatus"},
    {0X00741246, DCM_VR_TAG_CS, "UnifiedProcedureStepListStatus"},
    {0X00741324, DCM_VR_TAG_UL, "BeamOrderIndex"},
    {0X00741338, DCM_VR_TAG_FD, "DoubleExposureMeterset"},
    {0X0074133A, DCM_VR_TAG_FD, "DoubleExposureFieldDelta"},
    {0X00741401, DCM_VR_TAG_SQ, "BrachyTaskSequence"},
    {0X00741402, DCM_VR_TAG_DS, "ContinuationStartTotalReferenceAirKerma"},
    {0X00741403, DCM_VR_TAG_DS, "ContinuationEndTotalReferenceAirKerma"},
    {0X00741404, DCM_VR_TAG_IS, "ContinuationPulseNumber"},
    {0X00741405, DCM_VR_TAG_SQ, "ChannelDeliveryOrderSequence"},
    {0X00741406, DCM_VR_TAG_IS, "ReferencedChannelNumber"},
    {0X00741407, DCM_VR_TAG_DS, "StartCumulativeTimeWeight"},
    {0X00741408, DCM_VR_TAG_DS, "EndCumulativeTimeWeight"},
    {0X00741409, DCM_VR_TAG_SQ, "OmittedChannelSequence"},
    {0X0074140A, DCM_VR_TAG_CS, "ReasonForChannelOmission"},
    {0X0074140B, DCM_VR_TAG_LO, "ReasonForChannelOmissionDescription"},
    {0X0074140C, DCM_VR_TAG_IS, "ChannelDeliveryOrderIndex"},
    {0X0074140D, DCM_VR_TAG_SQ, "ChannelDeliveryContinuationSequence"},
    {0X0074140E, DCM_VR_TAG_SQ, "OmittedApplicationSetupSequence"},
    {0X00760001, DCM_VR_TAG_LO, "ImplantAssemblyTemplateName"},
    {0X00760003, DCM_VR_TAG_LO, "ImplantAssemblyTemplateIssuer"},
    {0X00760006, DCM_VR_TAG_LO, "ImplantAssemblyTemplateVersion"},
    {0X00760008, DCM_VR_TAG_SQ, "ReplacedImplantAssemblyTemplateSequence"},
    {0X0076000A, DCM_VR_TAG_CS, "ImplantAssemblyTemplateType"},
    {0X0076000C, DCM_VR_TAG_SQ, "OriginalImplantAssemblyTemplateSequence"},
    {0X0076000E, DCM_VR_TAG_SQ, "DerivationImplantAssemblyTemplateSequence"},
    {0X00760010, DCM_VR_TAG_SQ, "ImplantAssemblyTemplateTargetAnatomySequence"},
    {0X00760020, DCM_VR_TAG_SQ, "ProcedureTypeCodeSequence"},
    {0X00760030, DCM_VR_TAG_LO, "SurgicalTechnique"},
    {0X00760032, DCM_VR_TAG_SQ, "ComponentTypesSequence"},
    {0X00760034, DCM_VR_TAG_SQ, "ComponentTypeCodeSequence"},
    {0X00760036, DCM_VR_TAG_CS, "ExclusiveComponentType"},
    {0X00760038, DCM_VR_TAG_CS, "MandatoryComponentType"},
    {0X00760040, DCM_VR_TAG_SQ, "ComponentSequence"},
    {0X00760055, DCM_VR_TAG_US, "ComponentID"},
    {0X00760060, DCM_VR_TAG_SQ, "ComponentAssemblySequence"},
    {0X00760070, DCM_VR_TAG_US, "Component1ReferencedID"},
    {0X00760080, DCM_VR_TAG_US, "Component1ReferencedMatingFeatureSetID"},
    {0X00760090, DCM_VR_TAG_US, "Component1ReferencedMatingFeatureID"},
    {0X007600A0, DCM_VR_TAG_US, "Component2ReferencedID"},
    {0X007600B0, DCM_VR_TAG_US, "Component2ReferencedMatingFeatureSetID"},
    {0X007600C0, DCM_VR_TAG_US, "Component2ReferencedMatingFeatureID"},
    {0X00780001, DCM_VR_TAG_LO, "ImplantTemplateGroupName"},
    {0X00780010, DCM_VR_TAG_ST, "ImplantTemplateGroupDescription"},
    {0X00780020, DCM_VR_TAG_LO, "ImplantTemplateGroupIssuer"},
    {0X00780024, DCM_VR_TAG_LO, "ImplantTemplateGroupVersion"},
    {0X00780026, DCM_VR_TAG_SQ, "ReplacedImplantTemplateGroupSequence"},
    {0X00780028, DCM_VR_TAG_SQ, "ImplantTemplateGroupTargetAnatomySequence"},
    {0X0078002A, DCM_VR_TAG_SQ, "ImplantTemplateGroupMembersSequence"},
    {0X0078002E, DCM_VR_TAG_US, "ImplantTemplateGroupMemberID"},
    {0X00780050, DCM_VR_TAG_FD, "ThreeDImplantTemplateGroupMemberMatchingPoint"},
    {0X00780060, DCM_VR_TAG_FD, "ThreeDImplantTemplateGroupMemberMatchingAxes"},
    {0X00780070, DCM_VR_TAG_SQ, "ImplantTemplateGroupMemberMatching2DCoordinatesSequence"},
    {0X00780090, DCM_VR_TAG_FD, "TwoDImplantTemplateGroupMemberMatchingPoint"},
    {0X007800A0, DCM_VR_TAG_FD, "TwoDImplantTemplateGroupMemberMatchingAxes"},
    {0X007800B0, DCM_VR_TAG_SQ, "ImplantTemplateGroupVariationDimensionSequence"},
    {0X007800B2, DCM_VR_TAG_LO, "ImplantTemplateGroupVariationDimensionName"},
    {0X007800B4, DCM_VR_TAG_SQ, "ImplantTemplateGroupVariationDimensionRankSequence"},
    {0X007800B6, DCM_VR_TAG_US, "ReferencedImplantTemplateGroupMemberID"},
    {0X007800B8, DCM_VR_TAG_US, "ImplantTemplateGroupVariationDimensionRank"},
    {0X00800001, DCM_VR_TAG_SQ, "SurfaceScanAcquisitionTypeCodeSequence"},
    {0X00800002, DCM_VR_TAG_SQ, "SurfaceScanModeCodeSequence"},
    {0X00800003, DCM_VR_TAG_SQ, "RegistrationMethodCodeSequence"},
    {0X00800004, DCM_VR_TAG_FD, "ShotDurationTime"},
    {0X00800005, DCM_VR_TAG_FD, "ShotOffsetTime"},
    {0X00800006, DCM_VR_TAG_US, "SurfacePointPresentationValueData"},
    {0X00800007, DCM_VR_TAG_US, "SurfacePointColorCIELabValueData"},
    {0X00800008, DCM_VR_TAG_SQ, "UVMappingSequence"},
    {0X00800009, DCM_VR_TAG_SH, "TextureLabel"},
    {0X00800010, DCM_VR_TAG_OF, "UValueData"},
    {0X00800011, DCM_VR_TAG_OF, "VValueData"},
    {0X00800012, DCM_VR_TAG_SQ, "ReferencedTextureSequence"},
    {0X00800013, DCM_VR_TAG_SQ, "ReferencedSurfaceDataSequence"},
    {0X00820001, DCM_VR_TAG_CS, "AssessmentSummary"},
    {0X00820003, DCM_VR_TAG_UT, "AssessmentSummaryDescription"},
    {0X00820004, DCM_VR_TAG_SQ, "AssessedSOPInstanceSequence"},
    {0X00820005, DCM_VR_TAG_SQ, "ReferencedComparisonSOPInstanceSequence"},
    {0X00820006, DCM_VR_TAG_UL, "NumberOfAssessmentObservations"},
    {0X00820007, DCM_VR_TAG_SQ, "AssessmentObservationsSequence"},
    {0X00820008, DCM_VR_TAG_CS, "ObservationSignificance"},
    {0X0082000A, DCM_VR_TAG_UT, "ObservationDescription"},
    {0X0082000C, DCM_VR_TAG_SQ, "StructuredConstraintObservationSequence"},
    {0X00820010, DCM_VR_TAG_SQ, "AssessedAttributeValueSequence"},
    {0X00820016, DCM_VR_TAG_LO, "AssessmentSetID"},
    {0X00820017, DCM_VR_TAG_SQ, "AssessmentRequesterSequence"},
    {0X00820018, DCM_VR_TAG_LO, "SelectorAttributeName"},
    {0X00820019, DCM_VR_TAG_LO, "SelectorAttributeKeyword"},
    {0X00820021, DCM_VR_TAG_SQ, "AssessmentTypeCodeSequence"},
    {0X00820022, DCM_VR_TAG_SQ, "ObservationBasisCodeSequence"},
    {0X00820023, DCM_VR_TAG_LO, "AssessmentLabel"},
    {0X00820032, DCM_VR_TAG_CS, "ConstraintType"},
    {0X00820033, DCM_VR_TAG_UT, "SpecificationSelectionGuidance"},
    {0X00820034, DCM_VR_TAG_SQ, "ConstraintValueSequence"},
    {0X00820035, DCM_VR_TAG_SQ, "RecommendedDefaultValueSequence"},
    {0X00820036, DCM_VR_TAG_CS, "ConstraintViolationSignificance"},
    {0X00820037, DCM_VR_TAG_UT, "ConstraintViolationCondition"},
    {0X00820038, DCM_VR_TAG_CS, "ModifiableConstraintFlag"},
    {0X00880130, DCM_VR_TAG_SH, "StorageMediaFileSetID"},
    {0X00880140, DCM_VR_TAG_UI, "StorageMediaFileSetUID"},
    {0X00880200, DCM_VR_TAG_SQ, "IconImageSequence"},
    {0X00880904, DCM_VR_TAG_LO, "TopicTitle"},
    {0X00880906, DCM_VR_TAG_ST, "TopicSubject"},
    {0X00880910, DCM_VR_TAG_LO, "TopicAuthor"},
    {0X00880912, DCM_VR_TAG_LO, "TopicKeywords"},
    {0X01000410, DCM_VR_TAG_CS, "SOPInstanceStatus"},
    {0X01000420, DCM_VR_TAG_DT, "SOPAuthorizationDateTime"},
    {0X01000424, DCM_VR_TAG_LT, "SOPAuthorizationComment"},
    {0X01000426, DCM_VR_TAG_LO, "AuthorizationEquipmentCertificationNumber"},
    {0X04000005, DCM_VR_TAG_US, "MACIDNumber"},
    {0X04000010, DCM_VR_TAG_UI, "MACCalculationTransferSyntaxUID"},
    {0X04000015, DCM_VR_TAG_CS, "MACAlgorithm"},
    {0X04000020, DCM_VR_TAG_AT, "DataElementsSigned"},
    {0X04000100, DCM_VR_TAG_UI, "DigitalSignatureUID"},
    {0X04000105, DCM_VR_TAG_DT, "DigitalSignatureDateTime"},
    {0X04000110, DCM_VR_TAG_CS, "CertificateType"},
    {0X04000115, DCM_VR_TAG_OB, "CertificateOfSigner"},
    {0X04000120, DCM_VR_TAG_OB, "Signature"},
    {0X04000305, DCM_VR_TAG_CS, "CertifiedTimestampType"},
    {0X04000310, DCM_VR_TAG_OB, "CertifiedTimestamp"},
    {0X04000315, DCM_VR_TAG_FL, ""},
    {0X04000401, DCM_VR_TAG_SQ, "DigitalSignaturePurposeCodeSequence"},
    {0X04000402, DCM_VR_TAG_SQ, "ReferencedDigitalSignatureSequence"},
    {0X04000403, DCM_VR_TAG_SQ, "ReferencedSOPInstanceMACSequence"},
    {0X04000404, DCM_VR_TAG_OB, "MAC"},
    {0X04000500, DCM_VR_TAG_SQ, "EncryptedAttributesSequence"},
    {0X04000510, DCM_VR_TAG_UI, "EncryptedContentTransferSyntaxUID"},
    {0X04000520, DCM_VR_TAG_OB, "EncryptedContent"},
    {0X04000550, DCM_VR_TAG_SQ, "ModifiedAttributesSequence"},
    {0X04000551, DCM_VR_TAG_SQ, "NonconformingModifiedAttributesSequence"},
    {0X04000552, DCM_VR_TAG_OB, "NonconformingDataElementValue"},
    {0X04000561, DCM_VR_TAG_SQ, "OriginalAttributesSequence"},
    {0X04000562, DCM_VR_TAG_DT, "AttributeModificationDateTime"},
    {0X04000563, DCM_VR_TAG_LO, "ModifyingSystem"},
    {0X04000564, DCM_VR_TAG_LO, "SourceOfPreviousValues"},
    {0X04000565, DCM_VR_TAG_CS, "ReasonForTheAttributeModification"},
    {0X04000600, DCM_VR_TAG_CS, "InstanceOriginStatus"},
    {0X20000010, DCM_VR_TAG_IS, "NumberOfCopies"},
    {0X2000001E, DCM_VR_TAG_SQ, "PrinterConfigurationSequence"},
    {0X20000020, DCM_VR_TAG_CS, "PrintPriority"},
    {0X20000030, DCM_VR_TAG_CS, "MediumType"},
    {0X20000040, DCM_VR_TAG_CS, "FilmDestination"},
    {0X20000050, DCM_VR_TAG_LO, "FilmSessionLabel"},
    {0X20000060, DCM_VR_TAG_IS, "MemoryAllocation"},
    {0X20000061, DCM_VR_TAG_IS, "MaximumMemoryAllocation"},
    {0X20000062, DCM_VR_TAG_CS, "ColorImagePrintingFlag"},
    {0X20000063, DCM_VR_TAG_CS, "CollationFlag"},
    {0X20000065, DCM_VR_TAG_CS, "AnnotationFlag"},
    {0X20000067, DCM_VR_TAG_CS, "ImageOverlayFlag"},
    {0X20000069, DCM_VR_TAG_CS, "PresentationLUTFlag"},
    {0X2000006A, DCM_VR_TAG_CS, "ImageBoxPresentationLUTFlag"},
    {0X200000A0, DCM_VR_TAG_US, "MemoryBitDepth"},
    {0X200000A1, DCM_VR_TAG_US, "PrintingBitDepth"},
    {0X200000A2, DCM_VR_TAG_SQ, "MediaInstalledSequence"},
    {0X200000A4, DCM_VR_TAG_SQ, "OtherMediaAvailableSequence"},
    {0X200000A8, DCM_VR_TAG_SQ, "SupportedImageDisplayFormatsSequence"},
    {0X20000500, DCM_VR_TAG_SQ, "ReferencedFilmBoxSequence"},
    {0X20000510, DCM_VR_TAG_SQ, "ReferencedStoredPrintSequence"},
    {0X20100010, DCM_VR_TAG_ST, "ImageDisplayFormat"},
    {0X20100030, DCM_VR_TAG_CS, "AnnotationDisplayFormatID"},
    {0X20100040, DCM_VR_TAG_CS, "FilmOrientation"},
    {0X20100050, DCM_VR_TAG_CS, "FilmSizeID"},
    {0X20100052, DCM_VR_TAG_CS, "PrinterResolutionID"},
    {0X20100054, DCM_VR_TAG_CS, "DefaultPrinterResolutionID"},
    {0X20100060, DCM_VR_TAG_CS, "MagnificationType"},
    {0X20100080, DCM_VR_TAG_CS, "SmoothingType"},
    {0X201000A6, DCM_VR_TAG_CS, "DefaultMagnificationType"},
    {0X201000A7, DCM_VR_TAG_CS, "OtherMagnificationTypesAvailable"},
    {0X201000A8, DCM_VR_TAG_CS, "DefaultSmoothingType"},
    {0X201000A9, DCM_VR_TAG_CS, "OtherSmoothingTypesAvailable"},
    {0X20100100, DCM_VR_TAG_CS, "BorderDensity"},
    {0X20100110, DCM_VR_TAG_CS, "EmptyImageDensity"},
    {0X20100120, DCM_VR_TAG_US, "MinDensity"},
    {0X20100130, DCM_VR_TAG_US, "MaxDensity"},
    {0X20100140, DCM_VR_TAG_CS, "Trim"},
    {0X20100150, DCM_VR_TAG_ST, "ConfigurationInformation"},
    {0X20100152, DCM_VR_TAG_LT, "ConfigurationInformationDescription"},
    {0X20100154, DCM_VR_TAG_IS, "MaximumCollatedFilms"},
    {0X2010015E, DCM_VR_TAG_US, "Illumination"},
    {0X20100160, DCM_VR_TAG_US, "ReflectedAmbientLight"},
    {0X20100376, DCM_VR_TAG_DS, "PrinterPixelSpacing"},
    {0X20100500, DCM_VR_TAG_SQ, "ReferencedFilmSessionSequence"},
    {0X20100510, DCM_VR_TAG_SQ, "ReferencedImageBoxSequence"},
    {0X20100520, DCM_VR_TAG_SQ, "ReferencedBasicAnnotationBoxSequence"},
    {0X20200010, DCM_VR_TAG_US, "ImageBoxPosition"},
    {0X20200020, DCM_VR_TAG_CS, "Polarity"},
    {0X20200030, DCM_VR_TAG_DS, "RequestedImageSize"},
    {0X20200040, DCM_VR_TAG_CS, "RequestedDecimateCropBehavior"},
    {0X20200050, DCM_VR_TAG_CS, "RequestedResolutionID"},
    {0X202000A0, DCM_VR_TAG_CS, "RequestedImageSizeFlag"},
    {0X202000A2, DCM_VR_TAG_CS, "DecimateCropResult"},
    {0X20200110, DCM_VR_TAG_SQ, "BasicGrayscaleImageSequence"},
    {0X20200111, DCM_VR_TAG_SQ, "BasicColorImageSequence"},
    {0X20200130, DCM_VR_TAG_SQ, "ReferencedImageOverlayBoxSequence"},
    {0X20200140, DCM_VR_TAG_SQ, "ReferencedVOILUTBoxSequence"},
    {0X20300010, DCM_VR_TAG_US, "AnnotationPosition"},
    {0X20300020, DCM_VR_TAG_LO, "TextString"},
    {0X20400010, DCM_VR_TAG_SQ, "ReferencedOverlayPlaneSequence"},
    {0X20400011, DCM_VR_TAG_US, "ReferencedOverlayPlaneGroups"},
    {0X20400020, DCM_VR_TAG_SQ, "OverlayPixelDataSequence"},
    {0X20400060, DCM_VR_TAG_CS, "OverlayMagnificationType"},
    {0X20400070, DCM_VR_TAG_CS, "OverlaySmoothingType"},
    {0X20400072, DCM_VR_TAG_CS, "OverlayOrImageMagnification"},
    {0X20400074, DCM_VR_TAG_US, "MagnifyToNumberOfColumns"},
    {0X20400080, DCM_VR_TAG_CS, "OverlayForegroundDensity"},
    {0X20400082, DCM_VR_TAG_CS, "OverlayBackgroundDensity"},
    {0X20400090, DCM_VR_TAG_CS, "OverlayMode"},
    {0X20400100, DCM_VR_TAG_CS, "ThresholdDensity"},
    {0X20400500, DCM_VR_TAG_SQ, "ReferencedImageBoxSequenceRetired"},
    {0X20500010, DCM_VR_TAG_SQ, "PresentationLUTSequence"},
    {0X20500020, DCM_VR_TAG_CS, "PresentationLUTShape"},
    {0X20500500, DCM_VR_TAG_SQ, "ReferencedPresentationLUTSequence"},
    {0X21000010, DCM_VR_TAG_SH, "PrintJobID"},
    {0X21000020, DCM_VR_TAG_CS, "ExecutionStatus"},
    {0X21000030, DCM_VR_TAG_CS, "ExecutionStatusInfo"},
    {0X21000040, DCM_VR_TAG_DA, "CreationDate"},
    {0X21000050, DCM_VR_TAG_TM, "CreationTime"},
    {0X21000070, DCM_VR_TAG_AE, "Originator"},
    {0X21000140, DCM_VR_TAG_AE, "DestinationAE"},
    {0X21000160, DCM_VR_TAG_SH, "OwnerID"},
    {0X21000170, DCM_VR_TAG_IS, "NumberOfFilms"},
    {0X21000500, DCM_VR_TAG_SQ, "ReferencedPrintJobSequencePullStoredPrint"},
    {0X21100010, DCM_VR_TAG_CS, "PrinterStatus"},
    {0X21100020, DCM_VR_TAG_CS, "PrinterStatusInfo"},
    {0X21100030, DCM_VR_TAG_LO, "PrinterName"},
    {0X21100099, DCM_VR_TAG_SH, "PrintQueueID"},
    {0X21200010, DCM_VR_TAG_CS, "QueueStatus"},
    {0X21200050, DCM_VR_TAG_SQ, "PrintJobDescriptionSequence"},
    {0X21200070, DCM_VR_TAG_SQ, "ReferencedPrintJobSequence"},
    {0X21300010, DCM_VR_TAG_SQ, "PrintManagementCapabilitiesSequence"},
    {0X21300015, DCM_VR_TAG_SQ, "PrinterCharacteristicsSequence"},
    {0X21300030, DCM_VR_TAG_SQ, "FilmBoxContentSequence"},
    {0X21300040, DCM_VR_TAG_SQ, "ImageBoxContentSequence"},
    {0X21300050, DCM_VR_TAG_SQ, "AnnotationContentSequence"},
    {0X21300060, DCM_VR_TAG_SQ, "ImageOverlayBoxContentSequence"},
    {0X21300080, DCM_VR_TAG_SQ, "PresentationLUTContentSequence"},
    {0X213000A0, DCM_VR_TAG_SQ, "ProposedStudySequence"},
    {0X213000C0, DCM_VR_TAG_SQ, "OriginalImageSequence"},
    {0X22000001, DCM_VR_TAG_CS, "LabelUsingInformationExtractedFromInstances"},
    {0X22000002, DCM_VR_TAG_UT, "LabelText"},
    {0X22000003, DCM_VR_TAG_CS, "LabelStyleSelection"},
    {0X22000004, DCM_VR_TAG_LT, "MediaDisposition"},
    {0X22000005, DCM_VR_TAG_LT, "BarcodeValue"},
    {0X22000006, DCM_VR_TAG_CS, "BarcodeSymbology"},
    {0X22000007, DCM_VR_TAG_CS, "AllowMediaSplitting"},
    {0X22000008, DCM_VR_TAG_CS, "IncludeNonDICOMObjects"},
    {0X22000009, DCM_VR_TAG_CS, "IncludeDisplayApplication"},
    {0X2200000A, DCM_VR_TAG_CS, "PreserveCompositeInstancesAfterMediaCreation"},
    {0X2200000B, DCM_VR_TAG_US, "TotalNumberOfPiecesOfMediaCreated"},
    {0X2200000C, DCM_VR_TAG_LO, "RequestedMediaApplicationProfile"},
    {0X2200000D, DCM_VR_TAG_SQ, "ReferencedStorageMediaSequence"},
    {0X2200000E, DCM_VR_TAG_AT, "FailureAttributes"},
    {0X2200000F, DCM_VR_TAG_CS, "AllowLossyCompression"},
    {0X22000020, DCM_VR_TAG_CS, "RequestPriority"},
    {0X30020002, DCM_VR_TAG_SH, "RTImageLabel"},
    {0X30020003, DCM_VR_TAG_LO, "RTImageName"},
    {0X30020004, DCM_VR_TAG_ST, "RTImageDescription"},
    {0X3002000A, DCM_VR_TAG_CS, "ReportedValuesOrigin"},
    {0X3002000C, DCM_VR_TAG_CS, "RTImagePlane"},
    {0X3002000D, DCM_VR_TAG_DS, "XRayImageReceptorTranslation"},
    {0X3002000E, DCM_VR_TAG_DS, "XRayImageReceptorAngle"},
    {0X30020010, DCM_VR_TAG_DS, "RTImageOrientation"},
    {0X30020011, DCM_VR_TAG_DS, "ImagePlanePixelSpacing"},
    {0X30020012, DCM_VR_TAG_DS, "RTImagePosition"},
    {0X30020020, DCM_VR_TAG_SH, "RadiationMachineName"},
    {0X30020022, DCM_VR_TAG_DS, "RadiationMachineSAD"},
    {0X30020024, DCM_VR_TAG_DS, "RadiationMachineSSD"},
    {0X30020026, DCM_VR_TAG_DS, "RTImageSID"},
    {0X30020028, DCM_VR_TAG_DS, "SourceToReferenceObjectDistance"},
    {0X30020029, DCM_VR_TAG_IS, "FractionNumber"},
    {0X30020030, DCM_VR_TAG_SQ, "ExposureSequence"},
    {0X30020032, DCM_VR_TAG_DS, "MetersetExposure"},
    {0X30020034, DCM_VR_TAG_DS, "DiaphragmPosition"},
    {0X30020040, DCM_VR_TAG_SQ, "FluenceMapSequence"},
    {0X30020041, DCM_VR_TAG_CS, "FluenceDataSource"},
    {0X30020042, DCM_VR_TAG_DS, "FluenceDataScale"},
    {0X30020050, DCM_VR_TAG_SQ, "PrimaryFluenceModeSequence"},
    {0X30020051, DCM_VR_TAG_CS, "FluenceMode"},
    {0X30020052, DCM_VR_TAG_SH, "FluenceModeID"},
    {0X30040001, DCM_VR_TAG_CS, "DVHType"},
    {0X30040002, DCM_VR_TAG_CS, "DoseUnits"},
    {0X30040004, DCM_VR_TAG_CS, "DoseType"},
    {0X30040005, DCM_VR_TAG_CS, "SpatialTransformOfDose"},
    {0X30040006, DCM_VR_TAG_LO, "DoseComment"},
    {0X30040008, DCM_VR_TAG_DS, "NormalizationPoint"},
    {0X3004000A, DCM_VR_TAG_CS, "DoseSummationType"},
    {0X3004000C, DCM_VR_TAG_DS, "GridFrameOffsetVector"},
    {0X3004000E, DCM_VR_TAG_DS, "DoseGridScaling"},
    {0X30040010, DCM_VR_TAG_SQ, "RTDoseROISequence"},
    {0X30040012, DCM_VR_TAG_DS, "DoseValue"},
    {0X30040014, DCM_VR_TAG_CS, "TissueHeterogeneityCorrection"},
    {0X30040040, DCM_VR_TAG_DS, "DVHNormalizationPoint"},
    {0X30040042, DCM_VR_TAG_DS, "DVHNormalizationDoseValue"},
    {0X30040050, DCM_VR_TAG_SQ, "DVHSequence"},
    {0X30040052, DCM_VR_TAG_DS, "DVHDoseScaling"},
    {0X30040054, DCM_VR_TAG_CS, "DVHVolumeUnits"},
    {0X30040056, DCM_VR_TAG_IS, "DVHNumberOfBins"},
    {0X30040058, DCM_VR_TAG_DS, "DVHData"},
    {0X30040060, DCM_VR_TAG_SQ, "DVHReferencedROISequence"},
    {0X30040062, DCM_VR_TAG_CS, "DVHROIContributionType"},
    {0X30040070, DCM_VR_TAG_DS, "DVHMinimumDose"},
    {0X30040072, DCM_VR_TAG_DS, "DVHMaximumDose"},
    {0X30040074, DCM_VR_TAG_DS, "DVHMeanDose"},
    {0X30060002, DCM_VR_TAG_SH, "StructureSetLabel"},
    {0X30060004, DCM_VR_TAG_LO, "StructureSetName"},
    {0X30060006, DCM_VR_TAG_ST, "StructureSetDescription"},
    {0X30060008, DCM_VR_TAG_DA, "StructureSetDate"},
    {0X30060009, DCM_VR_TAG_TM, "StructureSetTime"},
    {0X30060010, DCM_VR_TAG_SQ, "ReferencedFrameOfReferenceSequence"},
    {0X30060012, DCM_VR_TAG_SQ, "RTReferencedStudySequence"},
    {0X30060014, DCM_VR_TAG_SQ, "RTReferencedSeriesSequence"},
    {0X30060016, DCM_VR_TAG_SQ, "ContourImageSequence"},
    {0X30060018, DCM_VR_TAG_SQ, "PredecessorStructureSetSequence"},
    {0X30060020, DCM_VR_TAG_SQ, "StructureSetROISequence"},
    {0X30060022, DCM_VR_TAG_IS, "ROINumber"},
    {0X30060024, DCM_VR_TAG_UI, "ReferencedFrameOfReferenceUID"},
    {0X30060026, DCM_VR_TAG_LO, "ROIName"},
    {0X30060028, DCM_VR_TAG_ST, "ROIDescription"},
    {0X3006002A, DCM_VR_TAG_IS, "ROIDisplayColor"},
    {0X3006002C, DCM_VR_TAG_DS, "ROIVolume"},
    {0X30060030, DCM_VR_TAG_SQ, "RTRelatedROISequence"},
    {0X30060033, DCM_VR_TAG_CS, "RTROIRelationship"},
    {0X30060036, DCM_VR_TAG_CS, "ROIGenerationAlgorithm"},
    {0X30060037, DCM_VR_TAG_SQ, "ROIDerivationAlgorithmIdentificationSequence"},
    {0X30060038, DCM_VR_TAG_LO, "ROIGenerationDescription"},
    {0X30060039, DCM_VR_TAG_SQ, "ROIContourSequence"},
    {0X30060040, DCM_VR_TAG_SQ, "ContourSequence"},
    {0X30060042, DCM_VR_TAG_CS, "ContourGeometricType"},
    {0X30060044, DCM_VR_TAG_DS, "ContourSlabThickness"},
    {0X30060045, DCM_VR_TAG_DS, "ContourOffsetVector"},
    {0X30060046, DCM_VR_TAG_IS, "NumberOfContourPoints"},
    {0X30060048, DCM_VR_TAG_IS, "ContourNumber"},
    {0X30060049, DCM_VR_TAG_IS, "AttachedContours"},
    {0X3006004A, DCM_VR_TAG_SQ, "SourcePixelPlanesCharacteristicsSequence"},
    {0X30060050, DCM_VR_TAG_DS, "ContourData"},
    {0X30060080, DCM_VR_TAG_SQ, "RTROIObservationsSequence"},
    {0X30060082, DCM_VR_TAG_IS, "ObservationNumber"},
    {0X30060084, DCM_VR_TAG_IS, "ReferencedROINumber"},
    {0X30060085, DCM_VR_TAG_SH, "ROIObservationLabel"},
    {0X30060086, DCM_VR_TAG_SQ, "RTROIIdentificationCodeSequence"},
    {0X30060088, DCM_VR_TAG_ST, "ROIObservationDescription"},
    {0X300600A0, DCM_VR_TAG_SQ, "RelatedRTROIObservationsSequence"},
    {0X300600A4, DCM_VR_TAG_CS, "RTROIInterpretedType"},
    {0X300600A6, DCM_VR_TAG_PN, "ROIInterpreter"},
    {0X300600B0, DCM_VR_TAG_SQ, "ROIPhysicalPropertiesSequence"},
    {0X300600B2, DCM_VR_TAG_CS, "ROIPhysicalProperty"},
    {0X300600B4, DCM_VR_TAG_DS, "ROIPhysicalPropertyValue"},
    {0X300600B6, DCM_VR_TAG_SQ, "ROIElementalCompositionSequence"},
    {0X300600B7, DCM_VR_TAG_US, "ROIElementalCompositionAtomicNumber"},
    {0X300600B8, DCM_VR_TAG_FL, "ROIElementalCompositionAtomicMassFraction"},
    {0X300600B9, DCM_VR_TAG_SQ, "AdditionalRTROIIdentificationCodeSequence"},
    {0X300600C0, DCM_VR_TAG_SQ, "FrameOfReferenceRelationshipSequence"},
    {0X300600C2, DCM_VR_TAG_UI, "RelatedFrameOfReferenceUID"},
    {0X300600C4, DCM_VR_TAG_CS, "FrameOfReferenceTransformationType"},
    {0X300600C6, DCM_VR_TAG_DS, "FrameOfReferenceTransformationMatrix"},
    {0X300600C8, DCM_VR_TAG_LO, "FrameOfReferenceTransformationComment"},
    {0X300600C9, DCM_VR_TAG_SQ, "PatientLocationCoordinatesSequence"},
    {0X300600CA, DCM_VR_TAG_SQ, "PatientLocationCoordinatesCodeSequence"},
    {0X300600CB, DCM_VR_TAG_SQ, "PatientSupportPositionSequence"},
    {0X30080010, DCM_VR_TAG_SQ, "MeasuredDoseReferenceSequence"},
    {0X30080012, DCM_VR_TAG_ST, "MeasuredDoseDescription"},
    {0X30080014, DCM_VR_TAG_CS, "MeasuredDoseType"},
    {0X30080016, DCM_VR_TAG_DS, "MeasuredDoseValue"},
    {0X30080020, DCM_VR_TAG_SQ, "TreatmentSessionBeamSequence"},
    {0X30080021, DCM_VR_TAG_SQ, "TreatmentSessionIonBeamSequence"},
    {0X30080022, DCM_VR_TAG_IS, "CurrentFractionNumber"},
    {0X30080024, DCM_VR_TAG_DA, "TreatmentControlPointDate"},
    {0X30080025, DCM_VR_TAG_TM, "TreatmentControlPointTime"},
    {0X3008002A, DCM_VR_TAG_CS, "TreatmentTerminationStatus"},
    {0X3008002B, DCM_VR_TAG_SH, "TreatmentTerminationCode"},
    {0X3008002C, DCM_VR_TAG_CS, "TreatmentVerificationStatus"},
    {0X30080030, DCM_VR_TAG_SQ, "ReferencedTreatmentRecordSequence"},
    {0X30080032, DCM_VR_TAG_DS, "SpecifiedPrimaryMeterset"},
    {0X30080033, DCM_VR_TAG_DS, "SpecifiedSecondaryMeterset"},
    {0X30080036, DCM_VR_TAG_DS, "DeliveredPrimaryMeterset"},
    {0X30080037, DCM_VR_TAG_DS, "DeliveredSecondaryMeterset"},
    {0X3008003A, DCM_VR_TAG_DS, "SpecifiedTreatmentTime"},
    {0X3008003B, DCM_VR_TAG_DS, "DeliveredTreatmentTime"},
    {0X30080040, DCM_VR_TAG_SQ, "ControlPointDeliverySequence"},
    {0X30080041, DCM_VR_TAG_SQ, "IonControlPointDeliverySequence"},
    {0X30080042, DCM_VR_TAG_DS, "SpecifiedMeterset"},
    {0X30080044, DCM_VR_TAG_DS, "DeliveredMeterset"},
    {0X30080045, DCM_VR_TAG_FL, "MetersetRateSet"},
    {0X30080046, DCM_VR_TAG_FL, "MetersetRateDelivered"},
    {0X30080047, DCM_VR_TAG_FL, "ScanSpotMetersetsDelivered"},
    {0X30080048, DCM_VR_TAG_DS, "DoseRateDelivered"},
    {0X30080050, DCM_VR_TAG_SQ, "TreatmentSummaryCalculatedDoseReferenceSequence"},
    {0X30080052, DCM_VR_TAG_DS, "CumulativeDoseToDoseReference"},
    {0X30080054, DCM_VR_TAG_DA, "FirstTreatmentDate"},
    {0X30080056, DCM_VR_TAG_DA, "MostRecentTreatmentDate"},
    {0X3008005A, DCM_VR_TAG_IS, "NumberOfFractionsDelivered"},
    {0X30080060, DCM_VR_TAG_SQ, "OverrideSequence"},
    {0X30080061, DCM_VR_TAG_AT, "ParameterSequencePointer"},
    {0X30080062, DCM_VR_TAG_AT, "OverrideParameterPointer"},
    {0X30080063, DCM_VR_TAG_IS, "ParameterItemIndex"},
    {0X30080064, DCM_VR_TAG_IS, "MeasuredDoseReferenceNumber"},
    {0X30080065, DCM_VR_TAG_AT, "ParameterPointer"},
    {0X30080066, DCM_VR_TAG_ST, "OverrideReason"},
    {0X30080067, DCM_VR_TAG_US, "ParameterValueNumber"},
    {0X30080068, DCM_VR_TAG_SQ, "CorrectedParameterSequence"},
    {0X3008006A, DCM_VR_TAG_FL, "CorrectionValue"},
    {0X30080070, DCM_VR_TAG_SQ, "CalculatedDoseReferenceSequence"},
    {0X30080072, DCM_VR_TAG_IS, "CalculatedDoseReferenceNumber"},
    {0X30080074, DCM_VR_TAG_ST, "CalculatedDoseReferenceDescription"},
    {0X30080076, DCM_VR_TAG_DS, "CalculatedDoseReferenceDoseValue"},
    {0X30080078, DCM_VR_TAG_DS, "StartMeterset"},
    {0X3008007A, DCM_VR_TAG_DS, "EndMeterset"},
    {0X30080080, DCM_VR_TAG_SQ, "ReferencedMeasuredDoseReferenceSequence"},
    {0X30080082, DCM_VR_TAG_IS, "ReferencedMeasuredDoseReferenceNumber"},
    {0X30080090, DCM_VR_TAG_SQ, "ReferencedCalculatedDoseReferenceSequence"},
    {0X30080092, DCM_VR_TAG_IS, "ReferencedCalculatedDoseReferenceNumber"},
    {0X300800A0, DCM_VR_TAG_SQ, "BeamLimitingDeviceLeafPairsSequence"},
    {0X300800B0, DCM_VR_TAG_SQ, "RecordedWedgeSequence"},
    {0X300800C0, DCM_VR_TAG_SQ, "RecordedCompensatorSequence"},
    {0X300800D0, DCM_VR_TAG_SQ, "RecordedBlockSequence"},
    {0X300800E0, DCM_VR_TAG_SQ, "TreatmentSummaryMeasuredDoseReferenceSequence"},
    {0X300800F0, DCM_VR_TAG_SQ, "RecordedSnoutSequence"},
    {0X300800F2, DCM_VR_TAG_SQ, "RecordedRangeShifterSequence"},
    {0X300800F4, DCM_VR_TAG_SQ, "RecordedLateralSpreadingDeviceSequence"},
    {0X300800F6, DCM_VR_TAG_SQ, "RecordedRangeModulatorSequence"},
    {0X30080100, DCM_VR_TAG_SQ, "RecordedSourceSequence"},
    {0X30080105, DCM_VR_TAG_LO, "SourceSerialNumber"},
    {0X30080110, DCM_VR_TAG_SQ, "TreatmentSessionApplicationSetupSequence"},
    {0X30080116, DCM_VR_TAG_CS, "ApplicationSetupCheck"},
    {0X30080120, DCM_VR_TAG_SQ, "RecordedBrachyAccessoryDeviceSequence"},
    {0X30080122, DCM_VR_TAG_IS, "ReferencedBrachyAccessoryDeviceNumber"},
    {0X30080130, DCM_VR_TAG_SQ, "RecordedChannelSequence"},
    {0X30080132, DCM_VR_TAG_DS, "SpecifiedChannelTotalTime"},
    {0X30080134, DCM_VR_TAG_DS, "DeliveredChannelTotalTime"},
    {0X30080136, DCM_VR_TAG_IS, "SpecifiedNumberOfPulses"},
    {0X30080138, DCM_VR_TAG_IS, "DeliveredNumberOfPulses"},
    {0X3008013A, DCM_VR_TAG_DS, "SpecifiedPulseRepetitionInterval"},
    {0X3008013C, DCM_VR_TAG_DS, "DeliveredPulseRepetitionInterval"},
    {0X30080140, DCM_VR_TAG_SQ, "RecordedSourceApplicatorSequence"},
    {0X30080142, DCM_VR_TAG_IS, "ReferencedSourceApplicatorNumber"},
    {0X30080150, DCM_VR_TAG_SQ, "RecordedChannelShieldSequence"},
    {0X30080152, DCM_VR_TAG_IS, "ReferencedChannelShieldNumber"},
    {0X30080160, DCM_VR_TAG_SQ, "BrachyControlPointDeliveredSequence"},
    {0X30080162, DCM_VR_TAG_DA, "SafePositionExitDate"},
    {0X30080164, DCM_VR_TAG_TM, "SafePositionExitTime"},
    {0X30080166, DCM_VR_TAG_DA, "SafePositionReturnDate"},
    {0X30080168, DCM_VR_TAG_TM, "SafePositionReturnTime"},
    {0X30080171, DCM_VR_TAG_SQ, "PulseSpecificBrachyControlPointDeliveredSequence"},
    {0X30080172, DCM_VR_TAG_US, "PulseNumber"},
    {0X30080173, DCM_VR_TAG_SQ, "BrachyPulseControlPointDeliveredSequence"},
    {0X30080200, DCM_VR_TAG_CS, "CurrentTreatmentStatus"},
    {0X30080202, DCM_VR_TAG_ST, "TreatmentStatusComment"},
    {0X30080220, DCM_VR_TAG_SQ, "FractionGroupSummarySequence"},
    {0X30080223, DCM_VR_TAG_IS, "ReferencedFractionNumber"},
    {0X30080224, DCM_VR_TAG_CS, "FractionGroupType"},
    {0X30080230, DCM_VR_TAG_CS, "BeamStopperPosition"},
    {0X30080240, DCM_VR_TAG_SQ, "FractionStatusSummarySequence"},
    {0X30080250, DCM_VR_TAG_DA, "TreatmentDate"},
    {0X30080251, DCM_VR_TAG_TM, "TreatmentTime"},
    {0X300A0002, DCM_VR_TAG_SH, "RTPlanLabel"},
    {0X300A0003, DCM_VR_TAG_LO, "RTPlanName"},
    {0X300A0004, DCM_VR_TAG_ST, "RTPlanDescription"},
    {0X300A0006, DCM_VR_TAG_DA, "RTPlanDate"},
    {0X300A0007, DCM_VR_TAG_TM, "RTPlanTime"},
    {0X300A0009, DCM_VR_TAG_LO, "TreatmentProtocols"},
    {0X300A000A, DCM_VR_TAG_CS, "PlanIntent"},
    {0X300A000B, DCM_VR_TAG_LO, "TreatmentSites"},
    {0X300A000C, DCM_VR_TAG_CS, "RTPlanGeometry"},
    {0X300A000E, DCM_VR_TAG_ST, "PrescriptionDescription"},
    {0X300A0010, DCM_VR_TAG_SQ, "DoseReferenceSequence"},
    {0X300A0012, DCM_VR_TAG_IS, "DoseReferenceNumber"},
    {0X300A0013, DCM_VR_TAG_UI, "DoseReferenceUID"},
    {0X300A0014, DCM_VR_TAG_CS, "DoseReferenceStructureType"},
    {0X300A0015, DCM_VR_TAG_CS, "NominalBeamEnergyUnit"},
    {0X300A0016, DCM_VR_TAG_LO, "DoseReferenceDescription"},
    {0X300A0018, DCM_VR_TAG_DS, "DoseReferencePointCoordinates"},
    {0X300A001A, DCM_VR_TAG_DS, "NominalPriorDose"},
    {0X300A0020, DCM_VR_TAG_CS, "DoseReferenceType"},
    {0X300A0021, DCM_VR_TAG_DS, "ConstraintWeight"},
    {0X300A0022, DCM_VR_TAG_DS, "DeliveryWarningDose"},
    {0X300A0023, DCM_VR_TAG_DS, "DeliveryMaximumDose"},
    {0X300A0025, DCM_VR_TAG_DS, "TargetMinimumDose"},
    {0X300A0026, DCM_VR_TAG_DS, "TargetPrescriptionDose"},
    {0X300A0027, DCM_VR_TAG_DS, "TargetMaximumDose"},
    {0X300A0028, DCM_VR_TAG_DS, "TargetUnderdoseVolumeFraction"},
    {0X300A002A, DCM_VR_TAG_DS, "OrganAtRiskFullVolumeDose"},
    {0X300A002B, DCM_VR_TAG_DS, "OrganAtRiskLimitDose"},
    {0X300A002C, DCM_VR_TAG_DS, "OrganAtRiskMaximumDose"},
    {0X300A002D, DCM_VR_TAG_DS, "OrganAtRiskOverdoseVolumeFraction"},
    {0X300A0040, DCM_VR_TAG_SQ, "ToleranceTableSequence"},
    {0X300A0042, DCM_VR_TAG_IS, "ToleranceTableNumber"},
    {0X300A0043, DCM_VR_TAG_SH, "ToleranceTableLabel"},
    {0X300A0044, DCM_VR_TAG_DS, "GantryAngleTolerance"},
    {0X300A0046, DCM_VR_TAG_DS, "BeamLimitingDeviceAngleTolerance"},
    {0X300A0048, DCM_VR_TAG_SQ, "BeamLimitingDeviceToleranceSequence"},
    {0X300A004A, DCM_VR_TAG_DS, "BeamLimitingDevicePositionTolerance"},
    {0X300A004B, DCM_VR_TAG_FL, "SnoutPositionTolerance"},
    {0X300A004C, DCM_VR_TAG_DS, "PatientSupportAngleTolerance"},
    {0X300A004E, DCM_VR_TAG_DS, "TableTopEccentricAngleTolerance"},
    {0X300A004F, DCM_VR_TAG_FL, "TableTopPitchAngleTolerance"},
    {0X300A0050, DCM_VR_TAG_FL, "TableTopRollAngleTolerance"},
    {0X300A0051, DCM_VR_TAG_DS, "TableTopVerticalPositionTolerance"},
    {0X300A0052, DCM_VR_TAG_DS, "TableTopLongitudinalPositionTolerance"},
    {0X300A0053, DCM_VR_TAG_DS, "TableTopLateralPositionTolerance"},
    {0X300A0055, DCM_VR_TAG_CS, "RTPlanRelationship"},
    {0X300A0070, DCM_VR_TAG_SQ, "FractionGroupSequence"},
    {0X300A0071, DCM_VR_TAG_IS, "FractionGroupNumber"},
    {0X300A0072, DCM_VR_TAG_LO, "FractionGroupDescription"},
    {0X300A0078, DCM_VR_TAG_IS, "NumberOfFractionsPlanned"},
    {0X300A0079, DCM_VR_TAG_IS, "NumberOfFractionPatternDigitsPerDay"},
    {0X300A007A, DCM_VR_TAG_IS, "RepeatFractionCycleLength"},
    {0X300A007B, DCM_VR_TAG_LT, "FractionPattern"},
    {0X300A0080, DCM_VR_TAG_IS, "NumberOfBeams"},
    {0X300A0082, DCM_VR_TAG_DS, "BeamDoseSpecificationPoint"},
    {0X300A0083, DCM_VR_TAG_UI, "ReferencedDoseReferenceUID"},
    {0X300A0084, DCM_VR_TAG_DS, "BeamDose"},
    {0X300A0086, DCM_VR_TAG_DS, "BeamMeterset"},
    {0X300A0088, DCM_VR_TAG_FL, "BeamDosePointDepth"},
    {0X300A0089, DCM_VR_TAG_FL, "BeamDosePointEquivalentDepth"},
    {0X300A008A, DCM_VR_TAG_FL, "BeamDosePointSSD"},
    {0X300A008B, DCM_VR_TAG_CS, "BeamDoseMeaning"},
    {0X300A008C, DCM_VR_TAG_SQ, "BeamDoseVerificationControlPointSequence"},
    {0X300A008D, DCM_VR_TAG_FL, "AverageBeamDosePointDepth"},
    {0X300A008E, DCM_VR_TAG_FL, "AverageBeamDosePointEquivalentDepth"},
    {0X300A008F, DCM_VR_TAG_FL, "AverageBeamDosePointSSD"},
    {0X300A0090, DCM_VR_TAG_CS, "BeamDoseType"},
    {0X300A0091, DCM_VR_TAG_DS, "AlternateBeamDose"},
    {0X300A0092, DCM_VR_TAG_CS, "AlternateBeamDoseType"},
    {0X300A0093, DCM_VR_TAG_CS, "DepthValueAveragingFlag"},
    {0X300A0094, DCM_VR_TAG_DS, "BeamDosePointSourceToExternalContourDistance"},
    {0X300A00A0, DCM_VR_TAG_IS, "NumberOfBrachyApplicationSetups"},
    {0X300A00A2, DCM_VR_TAG_DS, "BrachyApplicationSetupDoseSpecificationPoint"},
    {0X300A00A4, DCM_VR_TAG_DS, "BrachyApplicationSetupDose"},
    {0X300A00B0, DCM_VR_TAG_SQ, "BeamSequence"},
    {0X300A00B2, DCM_VR_TAG_SH, "TreatmentMachineName"},
    {0X300A00B3, DCM_VR_TAG_CS, "PrimaryDosimeterUnit"},
    {0X300A00B4, DCM_VR_TAG_DS, "SourceAxisDistance"},
    {0X300A00B6, DCM_VR_TAG_SQ, "BeamLimitingDeviceSequence"},
    {0X300A00B8, DCM_VR_TAG_CS, "RTBeamLimitingDeviceType"},
    {0X300A00BA, DCM_VR_TAG_DS, "SourceToBeamLimitingDeviceDistance"},
    {0X300A00BB, DCM_VR_TAG_FL, "IsocenterToBeamLimitingDeviceDistance"},
    {0X300A00BC, DCM_VR_TAG_IS, "NumberOfLeafJawPairs"},
    {0X300A00BE, DCM_VR_TAG_DS, "LeafPositionBoundaries"},
    {0X300A00C0, DCM_VR_TAG_IS, "BeamNumber"},
    {0X300A00C2, DCM_VR_TAG_LO, "BeamName"},
    {0X300A00C3, DCM_VR_TAG_ST, "BeamDescription"},
    {0X300A00C4, DCM_VR_TAG_CS, "BeamType"},
    {0X300A00C5, DCM_VR_TAG_FD, "BeamDeliveryDurationLimit"},
    {0X300A00C6, DCM_VR_TAG_CS, "RadiationType"},
    {0X300A00C7, DCM_VR_TAG_CS, "HighDoseTechniqueType"},
    {0X300A00C8, DCM_VR_TAG_IS, "ReferenceImageNumber"},
    {0X300A00CA, DCM_VR_TAG_SQ, "PlannedVerificationImageSequence"},
    {0X300A00CC, DCM_VR_TAG_LO, "ImagingDeviceSpecificAcquisitionParameters"},
    {0X300A00CE, DCM_VR_TAG_CS, "TreatmentDeliveryType"},
    {0X300A00D0, DCM_VR_TAG_IS, "NumberOfWedges"},
    {0X300A00D1, DCM_VR_TAG_SQ, "WedgeSequence"},
    {0X300A00D2, DCM_VR_TAG_IS, "WedgeNumber"},
    {0X300A00D3, DCM_VR_TAG_CS, "WedgeType"},
    {0X300A00D4, DCM_VR_TAG_SH, "WedgeID"},
    {0X300A00D5, DCM_VR_TAG_IS, "WedgeAngle"},
    {0X300A00D6, DCM_VR_TAG_DS, "WedgeFactor"},
    {0X300A00D7, DCM_VR_TAG_FL, "TotalWedgeTrayWaterEquivalentThickness"},
    {0X300A00D8, DCM_VR_TAG_DS, "WedgeOrientation"},
    {0X300A00D9, DCM_VR_TAG_FL, "IsocenterToWedgeTrayDistance"},
    {0X300A00DA, DCM_VR_TAG_DS, "SourceToWedgeTrayDistance"},
    {0X300A00DB, DCM_VR_TAG_FL, "WedgeThinEdgePosition"},
    {0X300A00DC, DCM_VR_TAG_SH, "BolusID"},
    {0X300A00DD, DCM_VR_TAG_ST, "BolusDescription"},
    {0X300A00DE, DCM_VR_TAG_DS, "EffectiveWedgeAngle"},
    {0X300A00E0, DCM_VR_TAG_IS, "NumberOfCompensators"},
    {0X300A00E1, DCM_VR_TAG_SH, "MaterialID"},
    {0X300A00E2, DCM_VR_TAG_DS, "TotalCompensatorTrayFactor"},
    {0X300A00E3, DCM_VR_TAG_SQ, "CompensatorSequence"},
    {0X300A00E4, DCM_VR_TAG_IS, "CompensatorNumber"},
    {0X300A00E5, DCM_VR_TAG_SH, "CompensatorID"},
    {0X300A00E6, DCM_VR_TAG_DS, "SourceToCompensatorTrayDistance"},
    {0X300A00E7, DCM_VR_TAG_IS, "CompensatorRows"},
    {0X300A00E8, DCM_VR_TAG_IS, "CompensatorColumns"},
    {0X300A00E9, DCM_VR_TAG_DS, "CompensatorPixelSpacing"},
    {0X300A00EA, DCM_VR_TAG_DS, "CompensatorPosition"},
    {0X300A00EB, DCM_VR_TAG_DS, "CompensatorTransmissionData"},
    {0X300A00EC, DCM_VR_TAG_DS, "CompensatorThicknessData"},
    {0X300A00ED, DCM_VR_TAG_IS, "NumberOfBoli"},
    {0X300A00EE, DCM_VR_TAG_CS, "CompensatorType"},
    {0X300A00EF, DCM_VR_TAG_SH, "CompensatorTrayID"},
    {0X300A00F0, DCM_VR_TAG_IS, "NumberOfBlocks"},
    {0X300A00F2, DCM_VR_TAG_DS, "TotalBlockTrayFactor"},
    {0X300A00F3, DCM_VR_TAG_FL, "TotalBlockTrayWaterEquivalentThickness"},
    {0X300A00F4, DCM_VR_TAG_SQ, "BlockSequence"},
    {0X300A00F5, DCM_VR_TAG_SH, "BlockTrayID"},
    {0X300A00F6, DCM_VR_TAG_DS, "SourceToBlockTrayDistance"},
    {0X300A00F7, DCM_VR_TAG_FL, "IsocenterToBlockTrayDistance"},
    {0X300A00F8, DCM_VR_TAG_CS, "BlockType"},
    {0X300A00F9, DCM_VR_TAG_LO, "AccessoryCode"},
    {0X300A00FA, DCM_VR_TAG_CS, "BlockDivergence"},
    {0X300A00FB, DCM_VR_TAG_CS, "BlockMountingPosition"},
    {0X300A00FC, DCM_VR_TAG_IS, "BlockNumber"},
    {0X300A00FE, DCM_VR_TAG_LO, "BlockName"},
    {0X300A0100, DCM_VR_TAG_DS, "BlockThickness"},
    {0X300A0102, DCM_VR_TAG_DS, "BlockTransmission"},
    {0X300A0104, DCM_VR_TAG_IS, "BlockNumberOfPoints"},
    {0X300A0106, DCM_VR_TAG_DS, "BlockData"},
    {0X300A0107, DCM_VR_TAG_SQ, "ApplicatorSequence"},
    {0X300A0108, DCM_VR_TAG_SH, "ApplicatorID"},
    {0X300A0109, DCM_VR_TAG_CS, "ApplicatorType"},
    {0X300A010A, DCM_VR_TAG_LO, "ApplicatorDescription"},
    {0X300A010C, DCM_VR_TAG_DS, "CumulativeDoseReferenceCoefficient"},
    {0X300A010E, DCM_VR_TAG_DS, "FinalCumulativeMetersetWeight"},
    {0X300A0110, DCM_VR_TAG_IS, "NumberOfControlPoints"},
    {0X300A0111, DCM_VR_TAG_SQ, "ControlPointSequence"},
    {0X300A0112, DCM_VR_TAG_IS, "ControlPointIndex"},
    {0X300A0114, DCM_VR_TAG_DS, "NominalBeamEnergy"},
    {0X300A0115, DCM_VR_TAG_DS, "DoseRateSet"},
    {0X300A0116, DCM_VR_TAG_SQ, "WedgePositionSequence"},
    {0X300A0118, DCM_VR_TAG_CS, "WedgePosition"},
    {0X300A011A, DCM_VR_TAG_SQ, "BeamLimitingDevicePositionSequence"},
    {0X300A011C, DCM_VR_TAG_DS, "LeafJawPositions"},
    {0X300A011E, DCM_VR_TAG_DS, "GantryAngle"},
    {0X300A011F, DCM_VR_TAG_CS, "GantryRotationDirection"},
    {0X300A0120, DCM_VR_TAG_DS, "BeamLimitingDeviceAngle"},
    {0X300A0121, DCM_VR_TAG_CS, "BeamLimitingDeviceRotationDirection"},
    {0X300A0122, DCM_VR_TAG_DS, "PatientSupportAngle"},
    {0X300A0123, DCM_VR_TAG_CS, "PatientSupportRotationDirection"},
    {0X300A0124, DCM_VR_TAG_DS, "TableTopEccentricAxisDistance"},
    {0X300A0125, DCM_VR_TAG_DS, "TableTopEccentricAngle"},
    {0X300A0126, DCM_VR_TAG_CS, "TableTopEccentricRotationDirection"},
    {0X300A0128, DCM_VR_TAG_DS, "TableTopVerticalPosition"},
    {0X300A0129, DCM_VR_TAG_DS, "TableTopLongitudinalPosition"},
    {0X300A012A, DCM_VR_TAG_DS, "TableTopLateralPosition"},
    {0X300A012C, DCM_VR_TAG_DS, "IsocenterPosition"},
    {0X300A012E, DCM_VR_TAG_DS, "SurfaceEntryPoint"},
    {0X300A0130, DCM_VR_TAG_DS, "SourceToSurfaceDistance"},
    {0X300A0131, DCM_VR_TAG_FL, "AverageBeamDosePointSourceToExternalContourDistance"},
    {0X300A0132, DCM_VR_TAG_FL, "SourceToExternalContourDistance"},
    {0X300A0133, DCM_VR_TAG_FL, "ExternalContourEntryPoint"},
    {0X300A0134, DCM_VR_TAG_DS, "CumulativeMetersetWeight"},
    {0X300A0140, DCM_VR_TAG_FL, "TableTopPitchAngle"},
    {0X300A0142, DCM_VR_TAG_CS, "TableTopPitchRotationDirection"},
    {0X300A0144, DCM_VR_TAG_FL, "TableTopRollAngle"},
    {0X300A0146, DCM_VR_TAG_CS, "TableTopRollRotationDirection"},
    {0X300A0148, DCM_VR_TAG_FL, "HeadFixationAngle"},
    {0X300A014A, DCM_VR_TAG_FL, "GantryPitchAngle"},
    {0X300A014C, DCM_VR_TAG_CS, "GantryPitchRotationDirection"},
    {0X300A014E, DCM_VR_TAG_FL, "GantryPitchAngleTolerance"},
    {0X300A0150, DCM_VR_TAG_CS, "FixationEye"},
    {0X300A0151, DCM_VR_TAG_DS, "ChairHeadFramePosition"},
    {0X300A0152, DCM_VR_TAG_DS, "HeadFixationAngleTolerance"},
    {0X300A0153, DCM_VR_TAG_DS, "ChairHeadFramePositionTolerance"},
    {0X300A0154, DCM_VR_TAG_DS, "FixationLightAzimuthalAngleTolerance"},
    {0X300A0155, DCM_VR_TAG_DS, "FixationLightPolarAngleTolerance"},
    {0X300A0180, DCM_VR_TAG_SQ, "PatientSetupSequence"},
    {0X300A0182, DCM_VR_TAG_IS, "PatientSetupNumber"},
    {0X300A0183, DCM_VR_TAG_LO, "PatientSetupLabel"},
    {0X300A0184, DCM_VR_TAG_LO, "PatientAdditionalPosition"},
    {0X300A0190, DCM_VR_TAG_SQ, "FixationDeviceSequence"},
    {0X300A0192, DCM_VR_TAG_CS, "FixationDeviceType"},
    {0X300A0194, DCM_VR_TAG_SH, "FixationDeviceLabel"},
    {0X300A0196, DCM_VR_TAG_ST, "FixationDeviceDescription"},
    {0X300A0198, DCM_VR_TAG_SH, "FixationDevicePosition"},
    {0X300A0199, DCM_VR_TAG_FL, "FixationDevicePitchAngle"},
    {0X300A019A, DCM_VR_TAG_FL, "FixationDeviceRollAngle"},
    {0X300A01A0, DCM_VR_TAG_SQ, "ShieldingDeviceSequence"},
    {0X300A01A2, DCM_VR_TAG_CS, "ShieldingDeviceType"},
    {0X300A01A4, DCM_VR_TAG_SH, "ShieldingDeviceLabel"},
    {0X300A01A6, DCM_VR_TAG_ST, "ShieldingDeviceDescription"},
    {0X300A01A8, DCM_VR_TAG_SH, "ShieldingDevicePosition"},
    {0X300A01B0, DCM_VR_TAG_CS, "SetupTechnique"},
    {0X300A01B2, DCM_VR_TAG_ST, "SetupTechniqueDescription"},
    {0X300A01B4, DCM_VR_TAG_SQ, "SetupDeviceSequence"},
    {0X300A01B6, DCM_VR_TAG_CS, "SetupDeviceType"},
    {0X300A01B8, DCM_VR_TAG_SH, "SetupDeviceLabel"},
    {0X300A01BA, DCM_VR_TAG_ST, "SetupDeviceDescription"},
    {0X300A01BC, DCM_VR_TAG_DS, "SetupDeviceParameter"},
    {0X300A01D0, DCM_VR_TAG_ST, "SetupReferenceDescription"},
    {0X300A01D2, DCM_VR_TAG_DS, "TableTopVerticalSetupDisplacement"},
    {0X300A01D4, DCM_VR_TAG_DS, "TableTopLongitudinalSetupDisplacement"},
    {0X300A01D6, DCM_VR_TAG_DS, "TableTopLateralSetupDisplacement"},
    {0X300A0200, DCM_VR_TAG_CS, "BrachyTreatmentTechnique"},
    {0X300A0202, DCM_VR_TAG_CS, "BrachyTreatmentType"},
    {0X300A0206, DCM_VR_TAG_SQ, "TreatmentMachineSequence"},
    {0X300A0210, DCM_VR_TAG_SQ, "SourceSequence"},
    {0X300A0212, DCM_VR_TAG_IS, "SourceNumber"},
    {0X300A0214, DCM_VR_TAG_CS, "SourceType"},
    {0X300A0216, DCM_VR_TAG_LO, "SourceManufacturer"},
    {0X300A0218, DCM_VR_TAG_DS, "ActiveSourceDiameter"},
    {0X300A021A, DCM_VR_TAG_DS, "ActiveSourceLength"},
    {0X300A021B, DCM_VR_TAG_SH, "SourceModelID"},
    {0X300A021C, DCM_VR_TAG_LO, "SourceDescription"},
    {0X300A0222, DCM_VR_TAG_DS, "SourceEncapsulationNominalThickness"},
    {0X300A0224, DCM_VR_TAG_DS, "SourceEncapsulationNominalTransmission"},
    {0X300A0226, DCM_VR_TAG_LO, "SourceIsotopeName"},
    {0X300A0228, DCM_VR_TAG_DS, "SourceIsotopeHalfLife"},
    {0X300A0229, DCM_VR_TAG_CS, "SourceStrengthUnits"},
    {0X300A022A, DCM_VR_TAG_DS, "ReferenceAirKermaRate"},
    {0X300A022B, DCM_VR_TAG_DS, "SourceStrength"},
    {0X300A022C, DCM_VR_TAG_DA, "SourceStrengthReferenceDate"},
    {0X300A022E, DCM_VR_TAG_TM, "SourceStrengthReferenceTime"},
    {0X300A0230, DCM_VR_TAG_SQ, "ApplicationSetupSequence"},
    {0X300A0232, DCM_VR_TAG_CS, "ApplicationSetupType"},
    {0X300A0234, DCM_VR_TAG_IS, "ApplicationSetupNumber"},
    {0X300A0236, DCM_VR_TAG_LO, "ApplicationSetupName"},
    {0X300A0238, DCM_VR_TAG_LO, "ApplicationSetupManufacturer"},
    {0X300A0240, DCM_VR_TAG_IS, "TemplateNumber"},
    {0X300A0242, DCM_VR_TAG_SH, "TemplateType"},
    {0X300A0244, DCM_VR_TAG_LO, "TemplateName"},
    {0X300A0250, DCM_VR_TAG_DS, "TotalReferenceAirKerma"},
    {0X300A0260, DCM_VR_TAG_SQ, "BrachyAccessoryDeviceSequence"},
    {0X300A0262, DCM_VR_TAG_IS, "BrachyAccessoryDeviceNumber"},
    {0X300A0263, DCM_VR_TAG_SH, "BrachyAccessoryDeviceID"},
    {0X300A0264, DCM_VR_TAG_CS, "BrachyAccessoryDeviceType"},
    {0X300A0266, DCM_VR_TAG_LO, "BrachyAccessoryDeviceName"},
    {0X300A026A, DCM_VR_TAG_DS, "BrachyAccessoryDeviceNominalThickness"},
    {0X300A026C, DCM_VR_TAG_DS, "BrachyAccessoryDeviceNominalTransmission"},
    {0X300A0271, DCM_VR_TAG_DS, "ChannelEffectiveLength"},
    {0X300A0272, DCM_VR_TAG_DS, "ChannelInnerLength"},
    {0X300A0273, DCM_VR_TAG_SH, "AfterloaderChannelID"},
    {0X300A0274, DCM_VR_TAG_DS, "SourceApplicatorTipLength"},
    {0X300A0280, DCM_VR_TAG_SQ, "ChannelSequence"},
    {0X300A0282, DCM_VR_TAG_IS, "ChannelNumber"},
    {0X300A0284, DCM_VR_TAG_DS, "ChannelLength"},
    {0X300A0286, DCM_VR_TAG_DS, "ChannelTotalTime"},
    {0X300A0288, DCM_VR_TAG_CS, "SourceMovementType"},
    {0X300A028A, DCM_VR_TAG_IS, "NumberOfPulses"},
    {0X300A028C, DCM_VR_TAG_DS, "PulseRepetitionInterval"},
    {0X300A0290, DCM_VR_TAG_IS, "SourceApplicatorNumber"},
    {0X300A0291, DCM_VR_TAG_SH, "SourceApplicatorID"},
    {0X300A0292, DCM_VR_TAG_CS, "SourceApplicatorType"},
    {0X300A0294, DCM_VR_TAG_LO, "SourceApplicatorName"},
    {0X300A0296, DCM_VR_TAG_DS, "SourceApplicatorLength"},
    {0X300A0298, DCM_VR_TAG_LO, "SourceApplicatorManufacturer"},
    {0X300A029C, DCM_VR_TAG_DS, "SourceApplicatorWallNominalThickness"},
    {0X300A029E, DCM_VR_TAG_DS, "SourceApplicatorWallNominalTransmission"},
    {0X300A02A0, DCM_VR_TAG_DS, "SourceApplicatorStepSize"},
    {0X300A02A1, DCM_VR_TAG_IS, "ApplicatorShapeReferencedROINumber"},
    {0X300A02A2, DCM_VR_TAG_IS, "TransferTubeNumber"},
    {0X300A02A4, DCM_VR_TAG_DS, "TransferTubeLength"},
    {0X300A02B0, DCM_VR_TAG_SQ, "ChannelShieldSequence"},
    {0X300A02B2, DCM_VR_TAG_IS, "ChannelShieldNumber"},
    {0X300A02B3, DCM_VR_TAG_SH, "ChannelShieldID"},
    {0X300A02B4, DCM_VR_TAG_LO, "ChannelShieldName"},
    {0X300A02B8, DCM_VR_TAG_DS, "ChannelShieldNominalThickness"},
    {0X300A02BA, DCM_VR_TAG_DS, "ChannelShieldNominalTransmission"},
    {0X300A02C8, DCM_VR_TAG_DS, "FinalCumulativeTimeWeight"},
    {0X300A02D0, DCM_VR_TAG_SQ, "BrachyControlPointSequence"},
    {0X300A02D2, DCM_VR_TAG_DS, "ControlPointRelativePosition"},
    {0X300A02D4, DCM_VR_TAG_DS, "ControlPoint3DPosition"},
    {0X300A02D6, DCM_VR_TAG_DS, "CumulativeTimeWeight"},
    {0X300A02E0, DCM_VR_TAG_CS, "CompensatorDivergence"},
    {0X300A02E1, DCM_VR_TAG_CS, "CompensatorMountingPosition"},
    {0X300A02E2, DCM_VR_TAG_DS, "SourceToCompensatorDistance"},
    {0X300A02E3, DCM_VR_TAG_FL, "TotalCompensatorTrayWaterEquivalentThickness"},
    {0X300A02E4, DCM_VR_TAG_FL, "IsocenterToCompensatorTrayDistance"},
    {0X300A02E5, DCM_VR_TAG_FL, "CompensatorColumnOffset"},
    {0X300A02E6, DCM_VR_TAG_FL, "IsocenterToCompensatorDistances"},
    {0X300A02E7, DCM_VR_TAG_FL, "CompensatorRelativeStoppingPowerRatio"},
    {0X300A02E8, DCM_VR_TAG_FL, "CompensatorMillingToolDiameter"},
    {0X300A02EA, DCM_VR_TAG_SQ, "IonRangeCompensatorSequence"},
    {0X300A02EB, DCM_VR_TAG_LT, "CompensatorDescription"},
    {0X300A0302, DCM_VR_TAG_IS, "RadiationMassNumber"},
    {0X300A0304, DCM_VR_TAG_IS, "RadiationAtomicNumber"},
    {0X300A0306, DCM_VR_TAG_SS, "RadiationChargeState"},
    {0X300A0308, DCM_VR_TAG_CS, "ScanMode"},
    {0X300A0309, DCM_VR_TAG_CS, "ModulatedScanModeType"},
    {0X300A030A, DCM_VR_TAG_FL, "VirtualSourceAxisDistances"},
    {0X300A030C, DCM_VR_TAG_SQ, "SnoutSequence"},
    {0X300A030D, DCM_VR_TAG_FL, "SnoutPosition"},
    {0X300A030F, DCM_VR_TAG_SH, "SnoutID"},
    {0X300A0312, DCM_VR_TAG_IS, "NumberOfRangeShifters"},
    {0X300A0314, DCM_VR_TAG_SQ, "RangeShifterSequence"},
    {0X300A0316, DCM_VR_TAG_IS, "RangeShifterNumber"},
    {0X300A0318, DCM_VR_TAG_SH, "RangeShifterID"},
    {0X300A0320, DCM_VR_TAG_CS, "RangeShifterType"},
    {0X300A0322, DCM_VR_TAG_LO, "RangeShifterDescription"},
    {0X300A0330, DCM_VR_TAG_IS, "NumberOfLateralSpreadingDevices"},
    {0X300A0332, DCM_VR_TAG_SQ, "LateralSpreadingDeviceSequence"},
    {0X300A0334, DCM_VR_TAG_IS, "LateralSpreadingDeviceNumber"},
    {0X300A0336, DCM_VR_TAG_SH, "LateralSpreadingDeviceID"},
    {0X300A0338, DCM_VR_TAG_CS, "LateralSpreadingDeviceType"},
    {0X300A033A, DCM_VR_TAG_LO, "LateralSpreadingDeviceDescription"},
    {0X300A033C, DCM_VR_TAG_FL, "LateralSpreadingDeviceWaterEquivalentThickness"},
    {0X300A0340, DCM_VR_TAG_IS, "NumberOfRangeModulators"},
    {0X300A0342, DCM_VR_TAG_SQ, "RangeModulatorSequence"},
    {0X300A0344, DCM_VR_TAG_IS, "RangeModulatorNumber"},
    {0X300A0346, DCM_VR_TAG_SH, "RangeModulatorID"},
    {0X300A0348, DCM_VR_TAG_CS, "RangeModulatorType"},
    {0X300A034A, DCM_VR_TAG_LO, "RangeModulatorDescription"},
    {0X300A034C, DCM_VR_TAG_SH, "BeamCurrentModulationID"},
    {0X300A0350, DCM_VR_TAG_CS, "PatientSupportType"},
    {0X300A0352, DCM_VR_TAG_SH, "PatientSupportID"},
    {0X300A0354, DCM_VR_TAG_LO, "PatientSupportAccessoryCode"},
    {0X300A0355, DCM_VR_TAG_LO, "TrayAccessoryCode"},
    {0X300A0356, DCM_VR_TAG_FL, "FixationLightAzimuthalAngle"},
    {0X300A0358, DCM_VR_TAG_FL, "FixationLightPolarAngle"},
    {0X300A035A, DCM_VR_TAG_FL, "MetersetRate"},
    {0X300A0360, DCM_VR_TAG_SQ, "RangeShifterSettingsSequence"},
    {0X300A0362, DCM_VR_TAG_LO, "RangeShifterSetting"},
    {0X300A0364, DCM_VR_TAG_FL, "IsocenterToRangeShifterDistance"},
    {0X300A0366, DCM_VR_TAG_FL, "RangeShifterWaterEquivalentThickness"},
    {0X300A0370, DCM_VR_TAG_SQ, "LateralSpreadingDeviceSettingsSequence"},
    {0X300A0372, DCM_VR_TAG_LO, "LateralSpreadingDeviceSetting"},
    {0X300A0374, DCM_VR_TAG_FL, "IsocenterToLateralSpreadingDeviceDistance"},
    {0X300A0380, DCM_VR_TAG_SQ, "RangeModulatorSettingsSequence"},
    {0X300A0382, DCM_VR_TAG_FL, "RangeModulatorGatingStartValue"},
    {0X300A0384, DCM_VR_TAG_FL, "RangeModulatorGatingStopValue"},
    {0X300A0386, DCM_VR_TAG_FL, "RangeModulatorGatingStartWaterEquivalentThickness"},
    {0X300A0388, DCM_VR_TAG_FL, "RangeModulatorGatingStopWaterEquivalentThickness"},
    {0X300A038A, DCM_VR_TAG_FL, "IsocenterToRangeModulatorDistance"},
    {0X300A038F, DCM_VR_TAG_FL, "ScanSpotTimeOffset"},
    {0X300A0390, DCM_VR_TAG_SH, "ScanSpotTuneID"},
    {0X300A0391, DCM_VR_TAG_IS, "ScanSpotPrescribedIndices"},
    {0X300A0392, DCM_VR_TAG_IS, "NumberOfScanSpotPositions"},
    {0X300A0393, DCM_VR_TAG_CS, "ScanSpotReordered"},
    {0X300A0394, DCM_VR_TAG_FL, "ScanSpotPositionMap"},
    {0X300A0395, DCM_VR_TAG_CS, "ScanSpotReorderingAllowed"},
    {0X300A0396, DCM_VR_TAG_FL, "ScanSpotMetersetWeights"},
    {0X300A0398, DCM_VR_TAG_FL, "ScanningSpotSize"},
    {0X300A0399, DCM_VR_TAG_FL, "ScanSpotSizesDelivered"},
    {0X300A039A, DCM_VR_TAG_IS, "NumberOfPaintings"},
    {0X300A03A0, DCM_VR_TAG_SQ, "IonToleranceTableSequence"},
    {0X300A03A2, DCM_VR_TAG_SQ, "IonBeamSequence"},
    {0X300A03A4, DCM_VR_TAG_SQ, "IonBeamLimitingDeviceSequence"},
    {0X300A03A6, DCM_VR_TAG_SQ, "IonBlockSequence"},
    {0X300A03A8, DCM_VR_TAG_SQ, "IonControlPointSequence"},
    {0X300A03AA, DCM_VR_TAG_SQ, "IonWedgeSequence"},
    {0X300A03AC, DCM_VR_TAG_SQ, "IonWedgePositionSequence"},
    {0X300A0401, DCM_VR_TAG_SQ, "ReferencedSetupImageSequence"},
    {0X300A0402, DCM_VR_TAG_ST, "SetupImageComment"},
    {0X300A0410, DCM_VR_TAG_SQ, "MotionSynchronizationSequence"},
    {0X300A0412, DCM_VR_TAG_FL, "ControlPointOrientation"},
    {0X300A0420, DCM_VR_TAG_SQ, "GeneralAccessorySequence"},
    {0X300A0421, DCM_VR_TAG_SH, "GeneralAccessoryID"},
    {0X300A0422, DCM_VR_TAG_ST, "GeneralAccessoryDescription"},
    {0X300A0423, DCM_VR_TAG_CS, "GeneralAccessoryType"},
    {0X300A0424, DCM_VR_TAG_IS, "GeneralAccessoryNumber"},
    {0X300A0425, DCM_VR_TAG_FL, "SourceToGeneralAccessoryDistance"},
    {0X300A0426, DCM_VR_TAG_DS, "IsocenterToGeneralAccessoryDistance"},
    {0X300A0431, DCM_VR_TAG_SQ, "ApplicatorGeometrySequence"},
    {0X300A0432, DCM_VR_TAG_CS, "ApplicatorApertureShape"},
    {0X300A0433, DCM_VR_TAG_FL, "ApplicatorOpening"},
    {0X300A0434, DCM_VR_TAG_FL, "ApplicatorOpeningX"},
    {0X300A0435, DCM_VR_TAG_FL, "ApplicatorOpeningY"},
    {0X300A0436, DCM_VR_TAG_FL, "SourceToApplicatorMountingPositionDistance"},
    {0X300A0440, DCM_VR_TAG_IS, "NumberOfBlockSlabItems"},
    {0X300A0441, DCM_VR_TAG_SQ, "BlockSlabSequence"},
    {0X300A0442, DCM_VR_TAG_DS, "BlockSlabThickness"},
    {0X300A0443, DCM_VR_TAG_US, "BlockSlabNumber"},
    {0X300A0450, DCM_VR_TAG_SQ, "DeviceMotionControlSequence"},
    {0X300A0451, DCM_VR_TAG_CS, "DeviceMotionExecutionMode"},
    {0X300A0452, DCM_VR_TAG_CS, "DeviceMotionObservationMode"},
    {0X300A0453, DCM_VR_TAG_SQ, "DeviceMotionParameterCodeSequence"},
    {0X300A0501, DCM_VR_TAG_FL, "DistalDepthFraction"},
    {0X300A0502, DCM_VR_TAG_FL, "DistalDepth"},
    {0X300A0503, DCM_VR_TAG_FL, "NominalRangeModulationFractions"},
    {0X300A0504, DCM_VR_TAG_FL, "NominalRangeModulatedRegionDepths"},
    {0X300A0505, DCM_VR_TAG_SQ, "DepthDoseParametersSequence"},
    {0X300A0506, DCM_VR_TAG_SQ, "DeliveredDepthDoseParametersSequence"},
    {0X300A0507, DCM_VR_TAG_FL, "DeliveredDistalDepthFraction"},
    {0X300A0508, DCM_VR_TAG_FL, "DeliveredDistalDepth"},
    {0X300A0509, DCM_VR_TAG_FL, "DeliveredNominalRangeModulationFractions"},
    {0X300A0510, DCM_VR_TAG_FL, "DeliveredNominalRangeModulatedRegionDepths"},
    {0X300A0511, DCM_VR_TAG_CS, "DeliveredReferenceDoseDefinition"},
    {0X300A0512, DCM_VR_TAG_CS, "ReferenceDoseDefinition"},
    {0X300A0600, DCM_VR_TAG_US, "RTControlPointIndex"},
    {0X300A0601, DCM_VR_TAG_US, "RadiationGenerationModeIndex"},
    {0X300A0602, DCM_VR_TAG_US, "ReferencedDefinedDeviceIndex"},
    {0X300A0603, DCM_VR_TAG_US, "RadiationDoseIdentificationIndex"},
    {0X300A0604, DCM_VR_TAG_US, "NumberOfRTControlPoints"},
    {0X300A0605, DCM_VR_TAG_US, "ReferencedRadiationGenerationModeIndex"},
    {0X300A0606, DCM_VR_TAG_US, "TreatmentPositionIndex"},
    {0X300A0607, DCM_VR_TAG_US, "ReferencedDeviceIndex"},
    {0X300A0608, DCM_VR_TAG_LO, "TreatmentPositionGroupLabel"},
    {0X300A0609, DCM_VR_TAG_UI, "TreatmentPositionGroupUID"},
    {0X300A060A, DCM_VR_TAG_SQ, "TreatmentPositionGroupSequence"},
    {0X300A060B, DCM_VR_TAG_US, "ReferencedTreatmentPositionIndex"},
    {0X300A060C, DCM_VR_TAG_US, "ReferencedRadiationDoseIdentificationIndex"},
    {0X300A060D, DCM_VR_TAG_FD, "RTAccessoryHolderWaterEquivalentThickness"},
    {0X300A060E, DCM_VR_TAG_US, "ReferencedRTAccessoryHolderDeviceIndex"},
    {0X300A060F, DCM_VR_TAG_CS, "RTAccessoryHolderSlotExistenceFlag"},
    {0X300A0610, DCM_VR_TAG_SQ, "RTAccessoryHolderSlotSequence"},
    {0X300A0611, DCM_VR_TAG_LO, "RTAccessoryHolderSlotID"},
    {0X300A0612, DCM_VR_TAG_FD, "RTAccessoryHolderSlotDistance"},
    {0X300A0613, DCM_VR_TAG_FD, "RTAccessorySlotDistance"},
    {0X300A0614, DCM_VR_TAG_SQ, "RTAccessoryHolderDefinitionSequence"},
    {0X300A0615, DCM_VR_TAG_LO, "RTAccessoryDeviceSlotID"},
    {0X300A0616, DCM_VR_TAG_SQ, "RTRadiationSequence"},
    {0X300A0617, DCM_VR_TAG_SQ, "RadiationDoseSequence"},
    {0X300A0618, DCM_VR_TAG_SQ, "RadiationDoseIdentificationSequence"},
    {0X300A0619, DCM_VR_TAG_LO, "RadiationDoseIdentificationLabel"},
    {0X300A061A, DCM_VR_TAG_CS, "ReferenceDoseType"},
    {0X300A061B, DCM_VR_TAG_CS, "PrimaryDoseValueIndicator"},
    {0X300A061C, DCM_VR_TAG_SQ, "DoseValuesSequence"},
    {0X300A061D, DCM_VR_TAG_CS, "DoseValuePurpose"},
    {0X300A061E, DCM_VR_TAG_FD, "ReferenceDosePointCoordinates"},
    {0X300A061F, DCM_VR_TAG_SQ, "RadiationDoseValuesParametersSequence"},
    {0X300A0620, DCM_VR_TAG_SQ, "MetersetToDoseMappingSequence"},
    {0X300A0621, DCM_VR_TAG_SQ, "ExpectedInVivoMeasurementValuesSequence"},
    {0X300A0622, DCM_VR_TAG_US, "ExpectedInVivoMeasurementValueIndex"},
    {0X300A0623, DCM_VR_TAG_LO, "RadiationDoseInVivoMeasurementLabel"},
    {0X300A0624, DCM_VR_TAG_FD, "RadiationDoseCentralAxisDisplacement"},
    {0X300A0625, DCM_VR_TAG_FD, "RadiationDoseValue"},
    {0X300A0626, DCM_VR_TAG_FD, "RadiationDoseSourceToSkinDistance"},
    {0X300A0627, DCM_VR_TAG_FD, "RadiationDoseMeasurementPointCoordinates"},
    {0X300A0628, DCM_VR_TAG_FD, "RadiationDoseSourceToExternalContourDistance"},
    {0X300A0629, DCM_VR_TAG_SQ, "RTToleranceSetSequence"},
    {0X300A062A, DCM_VR_TAG_LO, "RTToleranceSetLabel"},
    {0X300A062B, DCM_VR_TAG_SQ, "AttributeToleranceValuesSequence"},
    {0X300A062C, DCM_VR_TAG_FD, "ToleranceValue"},
    {0X300A062D, DCM_VR_TAG_SQ, "PatientSupportPositionToleranceSequence"},
    {0X300A062E, DCM_VR_TAG_FD, "TreatmentTimeLimit"},
    {0X300A062F, DCM_VR_TAG_SQ, "CArmPhotonElectronControlPointSequence"},
    {0X300A0630, DCM_VR_TAG_SQ, "ReferencedRTRadiationSequence"},
    {0X300A0631, DCM_VR_TAG_SQ, "ReferencedRTInstanceSequence"},
    {0X300A0632, DCM_VR_TAG_SQ, "ReferencedRTPatientSetupSequence"},
    {0X300A0634, DCM_VR_TAG_FD, "SourceToPatientSurfaceDistance"},
    {0X300A0635, DCM_VR_TAG_SQ, "TreatmentMachineSpecialModeCodeSequence"},
    {0X300A0636, DCM_VR_TAG_US, "IntendedNumberOfFractions"},
    {0X300A0637, DCM_VR_TAG_CS, "RTRadiationSetIntent"},
    {0X300A0638, DCM_VR_TAG_CS, "RTRadiationPhysicalAndGeometricContentDetailFlag"},
    {0X300A0639, DCM_VR_TAG_CS, "RTRecordFlag"},
    {0X300A063A, DCM_VR_TAG_SQ, "TreatmentDeviceIdentificationSequence"},
    {0X300A063B, DCM_VR_TAG_SQ, "ReferencedRTPhysicianIntentSequence"},
    {0X300A063C, DCM_VR_TAG_FD, "CumulativeMeterset"},
    {0X300A063D, DCM_VR_TAG_FD, "DeliveryRate"},
    {0X300A063E, DCM_VR_TAG_SQ, "DeliveryRateUnitSequence"},
    {0X300A063F, DCM_VR_TAG_SQ, "TreatmentPositionSequence"},
    {0X300A0640, DCM_VR_TAG_FD, "RadiationSourceAxisDistance"},
    {0X300A0641, DCM_VR_TAG_US, "NumberOfRTBeamLimitingDevices"},
    {0X300A0642, DCM_VR_TAG_FD, "RTBeamLimitingDeviceProximalDistance"},
    {0X300A0643, DCM_VR_TAG_FD, "RTBeamLimitingDeviceDistalDistance"},
    {0X300A0644, DCM_VR_TAG_SQ, "ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence"},
    {0X300A0645, DCM_VR_TAG_FD, "BeamModifierOrientationAngle"},
    {0X300A0646, DCM_VR_TAG_SQ, "FixedRTBeamDelimiterDeviceSequence"},
    {0X300A0647, DCM_VR_TAG_SQ, "ParallelRTBeamDelimiterDeviceSequence"},
    {0X300A0648, DCM_VR_TAG_US, "NumberOfParallelRTBeamDelimiters"},
    {0X300A0649, DCM_VR_TAG_FD, "ParallelRTBeamDelimiterBoundaries"},
    {0X300A064A, DCM_VR_TAG_FD, "ParallelRTBeamDelimiterPositions"},
    {0X300A064B, DCM_VR_TAG_FD, "RTBeamLimitingDeviceOffset"},
    {0X300A064C, DCM_VR_TAG_SQ, "RTBeamDelimiterGeometrySequence"},
    {0X300A064D, DCM_VR_TAG_SQ, "RTBeamLimitingDeviceDefinitionSequence"},
    {0X300A064E, DCM_VR_TAG_CS, "ParallelRTBeamDelimiterOpeningMode"},
    {0X300A064F, DCM_VR_TAG_CS, "ParallelRTBeamDelimiterLeafMountingSide"},
    {0X300A0650, DCM_VR_TAG_UI, "PatientSetupUID"},
    {0X300A0651, DCM_VR_TAG_SQ, "WedgeDefinitionSequence"},
    {0X300A0652, DCM_VR_TAG_FD, "RadiationBeamWedgeAngle"},
    {0X300A0653, DCM_VR_TAG_FD, "RadiationBeamWedgeThinEdgeDistance"},
    {0X300A0654, DCM_VR_TAG_FD, "RadiationBeamEffectiveWedgeAngle"},
    {0X300A0655, DCM_VR_TAG_US, "NumberOfWedgePositions"},
    {0X300A0656, DCM_VR_TAG_SQ, "RTBeamLimitingDeviceOpeningSequence"},
    {0X300A0657, DCM_VR_TAG_US, "NumberOfRTBeamLimitingDeviceOpenings"},
    {0X300A0658, DCM_VR_TAG_SQ, "RadiationDosimeterUnitSequence"},
    {0X300A0659, DCM_VR_TAG_SQ, "RTDeviceDistanceReferenceLocationCodeSequence"},
    {0X300A065A, DCM_VR_TAG_SQ, "RadiationDeviceConfigurationAndCommissioningKeySequence"},
    {0X300A065B, DCM_VR_TAG_SQ, "PatientSupportPositionParameterSequence"},
    {0X300A065C, DCM_VR_TAG_CS, "PatientSupportPositionSpecificationMethod"},
    {0X300A065D, DCM_VR_TAG_SQ, "PatientSupportPositionDeviceParameterSequence"},
    {0X300A065E, DCM_VR_TAG_US, "DeviceOrderIndex"},
    {0X300A065F, DCM_VR_TAG_US, "PatientSupportPositionParameterOrderIndex"},
    {0X300A0660, DCM_VR_TAG_SQ, "PatientSupportPositionDeviceToleranceSequence"},
    {0X300A0661, DCM_VR_TAG_US, "PatientSupportPositionToleranceOrderIndex"},
    {0X300A0662, DCM_VR_TAG_SQ, "CompensatorDefinitionSequence"},
    {0X300A0663, DCM_VR_TAG_CS, "CompensatorMapOrientation"},
    {0X300A0664, DCM_VR_TAG_OF, "CompensatorProximalThicknessMap"},
    {0X300A0665, DCM_VR_TAG_OF, "CompensatorDistalThicknessMap"},
    {0X300A0666, DCM_VR_TAG_FD, "CompensatorBasePlaneOffset"},
    {0X300A0667, DCM_VR_TAG_SQ, "CompensatorShapeFabricationCodeSequence"},
    {0X300A0668, DCM_VR_TAG_SQ, "CompensatorShapeSequence"},
    {0X300A0669, DCM_VR_TAG_FD, "RadiationBeamCompensatorMillingToolDiameter"},
    {0X300A066A, DCM_VR_TAG_SQ, "BlockDefinitionSequence"},
    {0X300A066B, DCM_VR_TAG_OF, "BlockEdgeData"},
    {0X300A066C, DCM_VR_TAG_CS, "BlockOrientation"},
    {0X300A066D, DCM_VR_TAG_FD, "RadiationBeamBlockThickness"},
    {0X300A066E, DCM_VR_TAG_FD, "RadiationBeamBlockSlabThickness"},
    {0X300A066F, DCM_VR_TAG_SQ, "BlockEdgeDataSequence"},
    {0X300A0670, DCM_VR_TAG_US, "NumberOfRTAccessoryHolders"},
    {0X300A0671, DCM_VR_TAG_SQ, "GeneralAccessoryDefinitionSequence"},
    {0X300A0672, DCM_VR_TAG_US, "NumberOfGeneralAccessories"},
    {0X300A0673, DCM_VR_TAG_SQ, "BolusDefinitionSequence"},
    {0X300A0674, DCM_VR_TAG_US, "NumberOfBoluses"},
    {0X300A0675, DCM_VR_TAG_UI, "EquipmentFrameOfReferenceUID"},
    {0X300A0676, DCM_VR_TAG_ST, "EquipmentFrameOfReferenceDescription"},
    {0X300A0677, DCM_VR_TAG_SQ, "EquipmentReferencePointCoordinatesSequence"},
    {0X300A0678, DCM_VR_TAG_SQ, "EquipmentReferencePointCodeSequence"},
    {0X300A0679, DCM_VR_TAG_FD, "RTBeamLimitingDeviceAngle"},
    {0X300A067A, DCM_VR_TAG_FD, "SourceRollAngle"},
    {0X300A067B, DCM_VR_TAG_SQ, "RadiationGenerationModeSequence"},
    {0X300A067C, DCM_VR_TAG_SH, "RadiationGenerationModeLabel"},
    {0X300A067D, DCM_VR_TAG_ST, "RadiationGenerationModeDescription"},
    {0X300A067E, DCM_VR_TAG_SQ, "RadiationGenerationModeMachineCodeSequence"},
    {0X300A067F, DCM_VR_TAG_SQ, "RadiationTypeCodeSequence"},
    {0X300A0680, DCM_VR_TAG_DS, "NominalEnergy"},
    {0X300A0681, DCM_VR_TAG_DS, "MinimumNominalEnergy"},
    {0X300A0682, DCM_VR_TAG_DS, "MaximumNominalEnergy"},
    {0X300A0683, DCM_VR_TAG_SQ, "RadiationFluenceModifierCodeSequence"},
    {0X300A0684, DCM_VR_TAG_SQ, "EnergyUnitCodeSequence"},
    {0X300A0685, DCM_VR_TAG_US, "NumberOfRadiationGenerationModes"},
    {0X300A0686, DCM_VR_TAG_SQ, "PatientSupportDevicesSequence"},
    {0X300A0687, DCM_VR_TAG_US, "NumberOfPatientSupportDevices"},
    {0X300A0688, DCM_VR_TAG_FD, "RTBeamModifierDefinitionDistance"},
    {0X300A0689, DCM_VR_TAG_SQ, "BeamAreaLimitSequence"},
    {0X300A068A, DCM_VR_TAG_SQ, "ReferencedRTPrescriptionSequence"},
    {0X300A0700, DCM_VR_TAG_UI, "TreatmentSessionUID"},
    {0X300A0701, DCM_VR_TAG_CS, "RTRadiationUsage"},
    {0X300A0702, DCM_VR_TAG_SQ, "ReferencedRTRadiationSetSequence"},
    {0X300A0703, DCM_VR_TAG_SQ, "ReferencedRTRadiationRecordSequence"},
    {0X300A0704, DCM_VR_TAG_US, "RTRadiationSetDeliveryNumber"},
    {0X300A0705, DCM_VR_TAG_US, "ClinicalFractionNumber"},
    {0X300A0706, DCM_VR_TAG_CS, "RTTreatmentFractionCompletionStatus"},
    {0X300A0707, DCM_VR_TAG_CS, "RTRadiationSetUsage"},
    {0X300A0708, DCM_VR_TAG_CS, "TreatmentDeliveryContinuationFlag"},
    {0X300A0709, DCM_VR_TAG_CS, "TreatmentRecordContentOrigin"},
    {0X300A0714, DCM_VR_TAG_CS, "RTTreatmentTerminationStatus"},
    {0X300A0715, DCM_VR_TAG_SQ, "RTTreatmentTerminationReasonCodeSequence"},
    {0X300A0716, DCM_VR_TAG_SQ, "MachineSpecificTreatmentTerminationCodeSequence"},
    {0X300A0722, DCM_VR_TAG_SQ, "RTRadiationSalvageRecordControlPointSequence"},
    {0X300A0723, DCM_VR_TAG_CS, "StartingMetersetValueKnownFlag"},
    {0X300A0730, DCM_VR_TAG_ST, "TreatmentTerminationDescription"},
    {0X300A0731, DCM_VR_TAG_SQ, "TreatmentToleranceViolationSequence"},
    {0X300A0732, DCM_VR_TAG_CS, "TreatmentToleranceViolationCategory"},
    {0X300A0733, DCM_VR_TAG_SQ, "TreatmentToleranceViolationAttributeSequence"},
    {0X300A0734, DCM_VR_TAG_ST, "TreatmentToleranceViolationDescription"},
    {0X300A0735, DCM_VR_TAG_ST, "TreatmentToleranceViolationIdentification"},
    {0X300A0736, DCM_VR_TAG_DT, "TreatmentToleranceViolationDateTime"},
    {0X300A073A, DCM_VR_TAG_DT, "RecordedRTControlPointDateTime"},
    {0X300A073B, DCM_VR_TAG_US, "ReferencedRadiationRTControlPointIndex"},
    {0X300A073E, DCM_VR_TAG_SQ, "AlternateValueSequence"},
    {0X300A073F, DCM_VR_TAG_SQ, "ConfirmationSequence"},
    {0X300A0740, DCM_VR_TAG_SQ, "InterlockSequence"},
    {0X300A0741, DCM_VR_TAG_DT, "InterlockDateTime"},
    {0X300A0742, DCM_VR_TAG_ST, "InterlockDescription"},
    {0X300A0743, DCM_VR_TAG_SQ, "InterlockOriginatingDeviceSequence"},
    {0X300A0744, DCM_VR_TAG_SQ, "InterlockCodeSequence"},
    {0X300A0745, DCM_VR_TAG_SQ, "InterlockResolutionCodeSequence"},
    {0X300A0746, DCM_VR_TAG_SQ, "InterlockResolutionUserSequence"},
    {0X300A0760, DCM_VR_TAG_DT, "OverrideDateTime"},
    {0X300A0761, DCM_VR_TAG_SQ, "TreatmentToleranceViolationTypeCodeSequence"},
    {0X300A0762, DCM_VR_TAG_SQ, "TreatmentToleranceViolationCauseCodeSequence"},
    {0X300A0772, DCM_VR_TAG_SQ, "MeasuredMetersetToDoseMappingSequence"},
    {0X300A0773, DCM_VR_TAG_US, "ReferencedExpectedInVivoMeasurementValueIndex"},
    {0X300A0774, DCM_VR_TAG_SQ, "DoseMeasurementDeviceCodeSequence"},
    {0X300A0780, DCM_VR_TAG_SQ, "AdditionalParameterRecordingInstanceSequence"},
    {0X300A0782, DCM_VR_TAG_US, ""},
    {0X300A0783, DCM_VR_TAG_ST, "InterlockOriginDescription"},
    {0X300A0784, DCM_VR_TAG_SQ, "RTPatientPositionScopeSequence"},
    {0X300A0785, DCM_VR_TAG_UI, "ReferencedTreatmentPositionGroupUID"},
    {0X300A0786, DCM_VR_TAG_US, "RadiationOrderIndex"},
    {0X300A0787, DCM_VR_TAG_SQ, "OmittedRadiationSequence"},
    {0X300A0788, DCM_VR_TAG_SQ, "ReasonforOmissionCodeSequence"},
    {0X300A0789, DCM_VR_TAG_SQ, "RTDeliveryStartPatientPositionSequence"},
    {0X300A078A, DCM_VR_TAG_SQ, "RTTreatmentPreparationPatientPositionSequence"},
    {0X300A078B, DCM_VR_TAG_SQ, "ReferencedRTTreatmentPreparationSequence"},
    {0X300A078C, DCM_VR_TAG_SQ, "ReferencedPatientSetupPhotoSequence"},
    {0X300A078D, DCM_VR_TAG_SQ, "PatientTreatmentPreparationMethodCodeSequence"},
    {0X300A078E, DCM_VR_TAG_LT, "PatientTreatmentPreparationProcedureParameterDescription"},
    {0X300A078F, DCM_VR_TAG_SQ, "PatientTreatmentPreparationDeviceSequence"},
    {0X300A0790, DCM_VR_TAG_SQ, "PatientTreatmentPreparationProcedureSequence"},
    {0X300A0791, DCM_VR_TAG_SQ, "PatientTreatmentPreparationProcedureCodeSequence"},
    {0X300A0792, DCM_VR_TAG_LT, "PatientTreatmentPreparationMethodDescription"},
    {0X300A0793, DCM_VR_TAG_SQ, "PatientTreatmentPreparationProcedureParameterSequence"},
    {0X300A0794, DCM_VR_TAG_LT, "PatientSetupPhotoDescription"},
    {0X300A0795, DCM_VR_TAG_US, "PatientTreatmentPreparationProcedureIndex"},
    {0X300A0796, DCM_VR_TAG_US, "ReferencedPatientSetupProcedureIndex"},
    {0X300A0797, DCM_VR_TAG_SQ, "RTRadiationTaskSequence"},
    {0X300A0798, DCM_VR_TAG_SQ, "RTPatientPositionDisplacementSequence"},
    {0X300A0799, DCM_VR_TAG_SQ, "RTPatientPositionSequence"},
    {0X300A079A, DCM_VR_TAG_LO, "DisplacementReferenceLabel"},
    {0X300A079B, DCM_VR_TAG_FD, "DisplacementMatrix"},
    {0X300A079C, DCM_VR_TAG_SQ, "PatientSupportDisplacementSequence"},
    {0X300A079D, DCM_VR_TAG_SQ, "DisplacementReferenceLocationCodeSequence"},
    {0X300A079E, DCM_VR_TAG_CS, "RTRadiationSetDeliveryUsage"},
    {0X300C0002, DCM_VR_TAG_SQ, "ReferencedRTPlanSequence"},
    {0X300C0004, DCM_VR_TAG_SQ, "ReferencedBeamSequence"},
    {0X300C0006, DCM_VR_TAG_IS, "ReferencedBeamNumber"},
    {0X300C0007, DCM_VR_TAG_IS, "ReferencedReferenceImageNumber"},
    {0X300C0008, DCM_VR_TAG_DS, "StartCumulativeMetersetWeight"},
    {0X300C0009, DCM_VR_TAG_DS, "EndCumulativeMetersetWeight"},
    {0X300C000A, DCM_VR_TAG_SQ, "ReferencedBrachyApplicationSetupSequence"},
    {0X300C000C, DCM_VR_TAG_IS, "ReferencedBrachyApplicationSetupNumber"},
    {0X300C000E, DCM_VR_TAG_IS, "ReferencedSourceNumber"},
    {0X300C0020, DCM_VR_TAG_SQ, "ReferencedFractionGroupSequence"},
    {0X300C0022, DCM_VR_TAG_IS, "ReferencedFractionGroupNumber"},
    {0X300C0040, DCM_VR_TAG_SQ, "ReferencedVerificationImageSequence"},
    {0X300C0042, DCM_VR_TAG_SQ, "ReferencedReferenceImageSequence"},
    {0X300C0050, DCM_VR_TAG_SQ, "ReferencedDoseReferenceSequence"},
    {0X300C0051, DCM_VR_TAG_IS, "ReferencedDoseReferenceNumber"},
    {0X300C0055, DCM_VR_TAG_SQ, "BrachyReferencedDoseReferenceSequence"},
    {0X300C0060, DCM_VR_TAG_SQ, "ReferencedStructureSetSequence"},
    {0X300C006A, DCM_VR_TAG_IS, "ReferencedPatientSetupNumber"},
    {0X300C0080, DCM_VR_TAG_SQ, "ReferencedDoseSequence"},
    {0X300C00A0, DCM_VR_TAG_IS, "ReferencedToleranceTableNumber"},
    {0X300C00B0, DCM_VR_TAG_SQ, "ReferencedBolusSequence"},
    {0X300C00C0, DCM_VR_TAG_IS, "ReferencedWedgeNumber"},
    {0X300C00D0, DCM_VR_TAG_IS, "ReferencedCompensatorNumber"},
    {0X300C00E0, DCM_VR_TAG_IS, "ReferencedBlockNumber"},
    {0X300C00F0, DCM_VR_TAG_IS, "ReferencedControlPointIndex"},
    {0X300C00F2, DCM_VR_TAG_SQ, "ReferencedControlPointSequence"},
    {0X300C00F4, DCM_VR_TAG_IS, "ReferencedStartControlPointIndex"},
    {0X300C00F6, DCM_VR_TAG_IS, "ReferencedStopControlPointIndex"},
    {0X300C0100, DCM_VR_TAG_IS, "ReferencedRangeShifterNumber"},
    {0X300C0102, DCM_VR_TAG_IS, "ReferencedLateralSpreadingDeviceNumber"},
    {0X300C0104, DCM_VR_TAG_IS, "ReferencedRangeModulatorNumber"},
    {0X300C0111, DCM_VR_TAG_SQ, "OmittedBeamTaskSequence"},
    {0X300C0112, DCM_VR_TAG_CS, "ReasonForOmission"},
    {0X300C0113, DCM_VR_TAG_LO, "ReasonForOmissionDescription"},
    {0X300E0002, DCM_VR_TAG_CS, "ApprovalStatus"},
    {0X300E0004, DCM_VR_TAG_DA, "ReviewDate"},
    {0X300E0005, DCM_VR_TAG_TM, "ReviewTime"},
    {0X300E0008, DCM_VR_TAG_PN, "ReviewerName"},
    {0X30100001, DCM_VR_TAG_SQ, "RadiobiologicalDoseEffectSequence"},
    {0X30100002, DCM_VR_TAG_CS, "RadiobiologicalDoseEffectFlag"},
    {0X30100003, DCM_VR_TAG_SQ, "EffectiveDoseCalculationMethodCategoryCodeSequence"},
    {0X30100004, DCM_VR_TAG_SQ, "EffectiveDoseCalculationMethodCodeSequence"},
    {0X30100005, DCM_VR_TAG_LO, "EffectiveDoseCalculationMethodDescription"},
    {0X30100006, DCM_VR_TAG_UI, "ConceptualVolumeUID"},
    {0X30100007, DCM_VR_TAG_SQ, "OriginatingSOPInstanceReferenceSequence"},
    {0X30100008, DCM_VR_TAG_SQ, "ConceptualVolumeConstituentSequence"},
    {0X30100009, DCM_VR_TAG_SQ, "EquivalentConceptualVolumeInstanceReferenceSequence"},
    {0X3010000A, DCM_VR_TAG_SQ, "EquivalentConceptualVolumesSequence"},
    {0X3010000B, DCM_VR_TAG_UI, "ReferencedConceptualVolumeUID"},
    {0X3010000C, DCM_VR_TAG_UT, "ConceptualVolumeCombinationExpression"},
    {0X3010000D, DCM_VR_TAG_US, "ConceptualVolumeConstituentIndex"},
    {0X3010000E, DCM_VR_TAG_CS, "ConceptualVolumeCombinationFlag"},
    {0X3010000F, DCM_VR_TAG_ST, "ConceptualVolumeCombinationDescription"},
    {0X30100010, DCM_VR_TAG_CS, "ConceptualVolumeSegmentationDefinedFlag"},
    {0X30100011, DCM_VR_TAG_SQ, "ConceptualVolumeSegmentationReferenceSequence"},
    {0X30100012, DCM_VR_TAG_SQ, "ConceptualVolumeConstituentSegmentationReferenceSequence"},
    {0X30100013, DCM_VR_TAG_UI, "ConstituentConceptualVolumeUID"},
    {0X30100014, DCM_VR_TAG_SQ, "DerivationConceptualVolumeSequence"},
    {0X30100015, DCM_VR_TAG_UI, "SourceConceptualVolumeUID"},
    {0X30100016, DCM_VR_TAG_SQ, "ConceptualVolumeDerivationAlgorithmSequence"},
    {0X30100017, DCM_VR_TAG_ST, "ConceptualVolumeDescription"},
    {0X30100018, DCM_VR_TAG_SQ, "SourceConceptualVolumeSequence"},
    {0X30100019, DCM_VR_TAG_SQ, "AuthorIdentificationSequence"},
    {0X3010001A, DCM_VR_TAG_LO, "ManufacturerModelVersion"},
    {0X3010001B, DCM_VR_TAG_UC, "DeviceAlternateIdentifier"},
    {0X3010001C, DCM_VR_TAG_CS, "DeviceAlternateIdentifierType"},
    {0X3010001D, DCM_VR_TAG_LT, "DeviceAlternateIdentifierFormat"},
    {0X3010001E, DCM_VR_TAG_LO, "SegmentationCreationTemplateLabel"},
    {0X3010001F, DCM_VR_TAG_UI, "SegmentationTemplateUID"},
    {0X30100020, DCM_VR_TAG_US, "ReferencedSegmentReferenceIndex"},
    {0X30100021, DCM_VR_TAG_SQ, "SegmentReferenceSequence"},
    {0X30100022, DCM_VR_TAG_US, "SegmentReferenceIndex"},
    {0X30100023, DCM_VR_TAG_SQ, "DirectSegmentReferenceSequence"},
    {0X30100024, DCM_VR_TAG_SQ, "CombinationSegmentReferenceSequence"},
    {0X30100025, DCM_VR_TAG_SQ, "ConceptualVolumeSequence"},
    {0X30100026, DCM_VR_TAG_SQ, "SegmentedRTAccessoryDeviceSequence"},
    {0X30100027, DCM_VR_TAG_SQ, "SegmentCharacteristicsSequence"},
    {0X30100028, DCM_VR_TAG_SQ, "RelatedSegmentCharacteristicsSequence"},
    {0X30100029, DCM_VR_TAG_US, "SegmentCharacteristicsPrecedence"},
    {0X3010002A, DCM_VR_TAG_SQ, "RTSegmentAnnotationSequence"},
    {0X3010002B, DCM_VR_TAG_SQ, "SegmentAnnotationCategoryCodeSequence"},
    {0X3010002C, DCM_VR_TAG_SQ, "SegmentAnnotationTypeCodeSequence"},
    {0X3010002D, DCM_VR_TAG_LO, "DeviceLabel"},
    {0X3010002E, DCM_VR_TAG_SQ, "DeviceTypeCodeSequence"},
    {0X3010002F, DCM_VR_TAG_SQ, "SegmentAnnotationTypeModifierCodeSequence"},
    {0X30100030, DCM_VR_TAG_SQ, "PatientEquipmentRelationshipCodeSequence"},
    {0X30100031, DCM_VR_TAG_UI, "ReferencedFiducialsUID"},
    {0X30100032, DCM_VR_TAG_SQ, "PatientTreatmentOrientationSequence"},
    {0X30100033, DCM_VR_TAG_SH, "UserContentLabel"},
    {0X30100034, DCM_VR_TAG_LO, "UserContentLongLabel"},
    {0X30100035, DCM_VR_TAG_SH, "EntityLabel"},
    {0X30100036, DCM_VR_TAG_LO, "EntityName"},
    {0X30100037, DCM_VR_TAG_ST, "EntityDescription"},
    {0X30100038, DCM_VR_TAG_LO, "EntityLongLabel"},
    {0X30100039, DCM_VR_TAG_US, "DeviceIndex"},
    {0X3010003A, DCM_VR_TAG_US, "RTTreatmentPhaseIndex"},
    {0X3010003B, DCM_VR_TAG_UI, "RTTreatmentPhaseUID"},
    {0X3010003C, DCM_VR_TAG_US, "RTPrescriptionIndex"},
    {0X3010003D, DCM_VR_TAG_US, "RTSegmentAnnotationIndex"},
    {0X3010003E, DCM_VR_TAG_US, "BasisRTTreatmentPhaseIndex"},
    {0X3010003F, DCM_VR_TAG_US, "RelatedRTTreatmentPhaseIndex"},
    {0X30100040, DCM_VR_TAG_US, "ReferencedRTTreatmentPhaseIndex"},
    {0X30100041, DCM_VR_TAG_US, "ReferencedRTPrescriptionIndex"},
    {0X30100042, DCM_VR_TAG_US, "ReferencedParentRTPrescriptionIndex"},
    {0X30100043, DCM_VR_TAG_ST, "ManufacturerDeviceIdentifier"},
    {0X30100044, DCM_VR_TAG_SQ, "InstanceLevelReferencedPerformedProcedureStepSequence"},
    {0X30100045, DCM_VR_TAG_CS, "RTTreatmentPhaseIntentPresenceFlag"},
    {0X30100046, DCM_VR_TAG_CS, "RadiotherapyTreatmentType"},
    {0X30100047, DCM_VR_TAG_CS, "TeletherapyRadiationType"},
    {0X30100048, DCM_VR_TAG_CS, "BrachytherapySourceType"},
    {0X30100049, DCM_VR_TAG_SQ, "ReferencedRTTreatmentPhaseSequence"},
    {0X3010004A, DCM_VR_TAG_SQ, "ReferencedDirectSegmentInstanceSequence"},
    {0X3010004B, DCM_VR_TAG_SQ, "IntendedRTTreatmentPhaseSequence"},
    {0X3010004C, DCM_VR_TAG_DA, "IntendedPhaseStartDate"},
    {0X3010004D, DCM_VR_TAG_DA, "IntendedPhaseEndDate"},
    {0X3010004E, DCM_VR_TAG_SQ, "RTTreatmentPhaseIntervalSequence"},
    {0X3010004F, DCM_VR_TAG_CS, "TemporalRelationshipIntervalAnchor"},
    {0X30100050, DCM_VR_TAG_FD, "MinimumNumberOfIntervalDays"},
    {0X30100051, DCM_VR_TAG_FD, "MaximumNumberOfIntervalDays"},
    {0X30100052, DCM_VR_TAG_UI, "PertinentSOPClassesInStudy"},
    {0X30100053, DCM_VR_TAG_UI, "PertinentSOPClassesInSeries"},
    {0X30100054, DCM_VR_TAG_LO, "RTPrescriptionLabel"},
    {0X30100055, DCM_VR_TAG_SQ, "RTPhysicianIntentPredecessorSequence"},
    {0X30100056, DCM_VR_TAG_LO, "RTTreatmentApproachLabel"},
    {0X30100057, DCM_VR_TAG_SQ, "RTPhysicianIntentSequence"},
    {0X30100058, DCM_VR_TAG_US, "RTPhysicianIntentIndex"},
    {0X30100059, DCM_VR_TAG_CS, "RTTreatmentIntentType"},
    {0X3010005A, DCM_VR_TAG_UT, "RTPhysicianIntentNarrative"},
    {0X3010005B, DCM_VR_TAG_SQ, "RTProtocolCodeSequence"},
    {0X3010005C, DCM_VR_TAG_ST, "ReasonForSuperseding"},
    {0X3010005D, DCM_VR_TAG_SQ, "RTDiagnosisCodeSequence"},
    {0X3010005E, DCM_VR_TAG_US, "ReferencedRTPhysicianIntentIndex"},
    {0X3010005F, DCM_VR_TAG_SQ, "RTPhysicianIntentInputInstanceSequence"},
    {0X30100060, DCM_VR_TAG_SQ, "RTAnatomicPrescriptionSequence"},
    {0X30100061, DCM_VR_TAG_UT, "PriorTreatmentDoseDescription"},
    {0X30100062, DCM_VR_TAG_SQ, "PriorTreatmentReferenceSequence"},
    {0X30100063, DCM_VR_TAG_CS, "DosimetricObjectiveEvaluationScope"},
    {0X30100064, DCM_VR_TAG_SQ, "TherapeuticRoleCategoryCodeSequence"},
    {0X30100065, DCM_VR_TAG_SQ, "TherapeuticRoleTypeCodeSequence"},
    {0X30100066, DCM_VR_TAG_US, "ConceptualVolumeOptimizationPrecedence"},
    {0X30100067, DCM_VR_TAG_SQ, "ConceptualVolumeCategoryCodeSequence"},
    {0X30100068, DCM_VR_TAG_CS, "ConceptualVolumeBlockingConstraint"},
    {0X30100069, DCM_VR_TAG_SQ, "ConceptualVolumeTypeCodeSequence"},
    {0X3010006A, DCM_VR_TAG_SQ, "ConceptualVolumeTypeModifierCodeSequence"},
    {0X3010006B, DCM_VR_TAG_SQ, "RTPrescriptionSequence"},
    {0X3010006C, DCM_VR_TAG_SQ, "DosimetricObjectiveSequence"},
    {0X3010006D, DCM_VR_TAG_SQ, "DosimetricObjectiveTypeCodeSequence"},
    {0X3010006E, DCM_VR_TAG_UI, "DosimetricObjectiveUID"},
    {0X3010006F, DCM_VR_TAG_UI, "ReferencedDosimetricObjectiveUID"},
    {0X30100070, DCM_VR_TAG_SQ, "DosimetricObjectiveParameterSequence"},
    {0X30100071, DCM_VR_TAG_SQ, "ReferencedDosimetricObjectivesSequence"},
    {0X30100073, DCM_VR_TAG_CS, "AbsoluteDosimetricObjectiveFlag"},
    {0X30100074, DCM_VR_TAG_FD, "DosimetricObjectiveWeight"},
    {0X30100075, DCM_VR_TAG_CS, "DosimetricObjectivePurpose"},
    {0X30100076, DCM_VR_TAG_SQ, "PlanningInputInformationSequence"},
    {0X30100077, DCM_VR_TAG_LO, "TreatmentSite"},
    {0X30100078, DCM_VR_TAG_SQ, "TreatmentSiteCodeSequence"},
    {0X30100079, DCM_VR_TAG_SQ, "FractionPatternSequence"},
    {0X3010007A, DCM_VR_TAG_UT, "TreatmentTechniqueNotes"},
    {0X3010007B, DCM_VR_TAG_UT, "PrescriptionNotes"},
    {0X3010007C, DCM_VR_TAG_IS, "NumberOfIntervalFractions"},
    {0X3010007D, DCM_VR_TAG_US, "NumberOfFractions"},
    {0X3010007E, DCM_VR_TAG_US, "IntendedDeliveryDuration"},
    {0X3010007F, DCM_VR_TAG_UT, "FractionationNotes"},
    {0X30100080, DCM_VR_TAG_SQ, "RTTreatmentTechniqueCodeSequence"},
    {0X30100081, DCM_VR_TAG_SQ, "PrescriptionNotesSequence"},
    {0X30100082, DCM_VR_TAG_SQ, "FractionBasedRelationshipSequence"},
    {0X30100083, DCM_VR_TAG_CS, "FractionBasedRelationshipIntervalAnchor"},
    {0X30100084, DCM_VR_TAG_FD, "MinimumHoursBetweenFractions"},
    {0X30100085, DCM_VR_TAG_TM, "IntendedFractionStartTime"},
    {0X30100086, DCM_VR_TAG_LT, "IntendedStartDayOfWeek"},
    {0X30100087, DCM_VR_TAG_SQ, "WeekdayFractionPatternSequence"},
    {0X30100088, DCM_VR_TAG_SQ, "DeliveryTimeStructureCodeSequence"},
    {0X30100089, DCM_VR_TAG_SQ, "TreatmentSiteModifierCodeSequence"},
    {0X30100090, DCM_VR_TAG_CS, "RoboticBaseLocationIndicator"},
    {0X30100091, DCM_VR_TAG_SQ, "RoboticPathNodeSetCodeSequence"},
    {0X30100092, DCM_VR_TAG_UL, "RoboticNodeIdentifier"},
    {0X30100093, DCM_VR_TAG_FD, "RTTreatmentSourceCoordinates"},
    {0X30100094, DCM_VR_TAG_FD, "RadiationSourceCoordinateSystemYawAngle"},
    {0X30100095, DCM_VR_TAG_FD, "RadiationSourceCoordinateSystemRollAngle"},
    {0X30100096, DCM_VR_TAG_FD, "RadiationSourceCoordinateSystemPitchAngle"},
    {0X30100097, DCM_VR_TAG_SQ, "RoboticPathControlPointSequence"},
    {0X30100098, DCM_VR_TAG_SQ, "TomotherapeuticControlPointSequence"},
    {0X30100099, DCM_VR_TAG_FD, "TomotherapeuticLeafOpenDurations"},
    {0X3010009A, DCM_VR_TAG_FD, "TomotherapeuticLeafInitialClosedDurations"},
    {0X40000010, DCM_VR_TAG_LT, "Arbitrary"},
    {0X40004000, DCM_VR_TAG_LT, "TextComments"},
    {0X40080040, DCM_VR_TAG_SH, "ResultsID"},
    {0X40080042, DCM_VR_TAG_LO, "ResultsIDIssuer"},
    {0X40080050, DCM_VR_TAG_SQ, "ReferencedInterpretationSequence"},
    {0X400800FF, DCM_VR_TAG_CS, "ReportProductionStatusTrial"},
    {0X40080100, DCM_VR_TAG_DA, "InterpretationRecordedDate"},
    {0X40080101, DCM_VR_TAG_TM, "InterpretationRecordedTime"},
    {0X40080102, DCM_VR_TAG_PN, "InterpretationRecorder"},
    {0X40080103, DCM_VR_TAG_LO, "ReferenceToRecordedSound"},
    {0X40080108, DCM_VR_TAG_DA, "InterpretationTranscriptionDate"},
    {0X40080109, DCM_VR_TAG_TM, "InterpretationTranscriptionTime"},
    {0X4008010A, DCM_VR_TAG_PN, "InterpretationTranscriber"},
    {0X4008010B, DCM_VR_TAG_ST, "InterpretationText"},
    {0X4008010C, DCM_VR_TAG_PN, "InterpretationAuthor"},
    {0X40080111, DCM_VR_TAG_SQ, "InterpretationApproverSequence"},
    {0X40080112, DCM_VR_TAG_DA, "InterpretationApprovalDate"},
    {0X40080113, DCM_VR_TAG_TM, "InterpretationApprovalTime"},
    {0X40080114, DCM_VR_TAG_PN, "PhysicianApprovingInterpretation"},
    {0X40080115, DCM_VR_TAG_LT, "InterpretationDiagnosisDescription"},
    {0X40080117, DCM_VR_TAG_SQ, "InterpretationDiagnosisCodeSequence"},
    {0X40080118, DCM_VR_TAG_SQ, "ResultsDistributionListSequence"},
    {0X40080119, DCM_VR_TAG_PN, "DistributionName"},
    {0X4008011A, DCM_VR_TAG_LO, "DistributionAddress"},
    {0X40080200, DCM_VR_TAG_SH, "InterpretationID"},
    {0X40080202, DCM_VR_TAG_LO, "InterpretationIDIssuer"},
    {0X40080210, DCM_VR_TAG_CS, "InterpretationTypeID"},
    {0X40080212, DCM_VR_TAG_CS, "InterpretationStatusID"},
    {0X40080300, DCM_VR_TAG_ST, "Impressions"},
    {0X40084000, DCM_VR_TAG_ST, "ResultsComments"},
    {0X40100001, DCM_VR_TAG_CS, "LowEnergyDetectors"},
    {0X40100002, DCM_VR_TAG_CS, "HighEnergyDetectors"},
    {0X40100004, DCM_VR_TAG_SQ, "DetectorGeometrySequence"},
    {0X40101001, DCM_VR_TAG_SQ, "ThreatROIVoxelSequence"},
    {0X40101004, DCM_VR_TAG_FL, "ThreatROIBase"},
    {0X40101005, DCM_VR_TAG_FL, "ThreatROIExtents"},
    {0X40101006, DCM_VR_TAG_OB, "ThreatROIBitmap"},
    {0X40101007, DCM_VR_TAG_SH, "RouteSegmentID"},
    {0X40101008, DCM_VR_TAG_CS, "GantryType"},
    {0X40101009, DCM_VR_TAG_CS, "OOIOwnerType"},
    {0X4010100A, DCM_VR_TAG_SQ, "RouteSegmentSequence"},
    {0X40101010, DCM_VR_TAG_US, "PotentialThreatObjectID"},
    {0X40101011, DCM_VR_TAG_SQ, "ThreatSequence"},
    {0X40101012, DCM_VR_TAG_CS, "ThreatCategory"},
    {0X40101013, DCM_VR_TAG_LT, "ThreatCategoryDescription"},
    {0X40101014, DCM_VR_TAG_CS, "ATDAbilityAssessment"},
    {0X40101015, DCM_VR_TAG_CS, "ATDAssessmentFlag"},
    {0X40101016, DCM_VR_TAG_FL, "ATDAssessmentProbability"},
    {0X40101017, DCM_VR_TAG_FL, "Mass"},
    {0X40101018, DCM_VR_TAG_FL, "Density"},
    {0X40101019, DCM_VR_TAG_FL, "ZEffective"},
    {0X4010101A, DCM_VR_TAG_SH, "BoardingPassID"},
    {0X4010101B, DCM_VR_TAG_FL, "CenterOfMass"},
    {0X4010101C, DCM_VR_TAG_FL, "CenterOfPTO"},
    {0X4010101D, DCM_VR_TAG_FL, "BoundingPolygon"},
    {0X4010101E, DCM_VR_TAG_SH, "RouteSegmentStartLocationID"},
    {0X4010101F, DCM_VR_TAG_SH, "RouteSegmentEndLocationID"},
    {0X40101020, DCM_VR_TAG_CS, "RouteSegmentLocationIDType"},
    {0X40101021, DCM_VR_TAG_CS, "AbortReason"},
    {0X40101023, DCM_VR_TAG_FL, "VolumeOfPTO"},
    {0X40101024, DCM_VR_TAG_CS, "AbortFlag"},
    {0X40101025, DCM_VR_TAG_DT, "RouteSegmentStartTime"},
    {0X40101026, DCM_VR_TAG_DT, "RouteSegmentEndTime"},
    {0X40101027, DCM_VR_TAG_CS, "TDRType"},
    {0X40101028, DCM_VR_TAG_CS, "InternationalRouteSegment"},
    {0X40101029, DCM_VR_TAG_LO, "ThreatDetectionAlgorithmAndVersion"},
    {0X4010102A, DCM_VR_TAG_SH, "AssignedLocation"},
    {0X4010102B, DCM_VR_TAG_DT, "AlarmDecisionTime"},
    {0X40101031, DCM_VR_TAG_CS, "AlarmDecision"},
    {0X40101033, DCM_VR_TAG_US, "NumberOfTotalObjects"},
    {0X40101034, DCM_VR_TAG_US, "NumberOfAlarmObjects"},
    {0X40101037, DCM_VR_TAG_SQ, "PTORepresentationSequence"},
    {0X40101038, DCM_VR_TAG_SQ, "ATDAssessmentSequence"},
    {0X40101039, DCM_VR_TAG_CS, "TIPType"},
    {0X4010103A, DCM_VR_TAG_CS, "DICOSVersion"},
    {0X40101041, DCM_VR_TAG_DT, "OOIOwnerCreationTime"},
    {0X40101042, DCM_VR_TAG_CS, "OOIType"},
    {0X40101043, DCM_VR_TAG_FL, "OOISize"},
    {0X40101044, DCM_VR_TAG_CS, "AcquisitionStatus"},
    {0X40101045, DCM_VR_TAG_SQ, "BasisMaterialsCodeSequence"},
    {0X40101046, DCM_VR_TAG_CS, "PhantomType"},
    {0X40101047, DCM_VR_TAG_SQ, "OOIOwnerSequence"},
    {0X40101048, DCM_VR_TAG_CS, "ScanType"},
    {0X40101051, DCM_VR_TAG_LO, "ItineraryID"},
    {0X40101052, DCM_VR_TAG_SH, "ItineraryIDType"},
    {0X40101053, DCM_VR_TAG_LO, "ItineraryIDAssigningAuthority"},
    {0X40101054, DCM_VR_TAG_SH, "RouteID"},
    {0X40101055, DCM_VR_TAG_SH, "RouteIDAssigningAuthority"},
    {0X40101056, DCM_VR_TAG_CS, "InboundArrivalType"},
    {0X40101058, DCM_VR_TAG_SH, "CarrierID"},
    {0X40101059, DCM_VR_TAG_CS, "CarrierIDAssigningAuthority"},
    {0X40101060, DCM_VR_TAG_FL, "SourceOrientation"},
    {0X40101061, DCM_VR_TAG_FL, "SourcePosition"},
    {0X40101062, DCM_VR_TAG_FL, "BeltHeight"},
    {0X40101064, DCM_VR_TAG_SQ, "AlgorithmRoutingCodeSequence"},
    {0X40101067, DCM_VR_TAG_CS, "TransportClassification"},
    {0X40101068, DCM_VR_TAG_LT, "OOITypeDescriptor"},
    {0X40101069, DCM_VR_TAG_FL, "TotalProcessingTime"},
    {0X4010106C, DCM_VR_TAG_OB, "DetectorCalibrationData"},
    {0X4010106D, DCM_VR_TAG_CS, "AdditionalScreeningPerformed"},
    {0X4010106E, DCM_VR_TAG_CS, "AdditionalInspectionSelectionCriteria"},
    {0X4010106F, DCM_VR_TAG_SQ, "AdditionalInspectionMethodSequence"},
    {0X40101070, DCM_VR_TAG_CS, "AITDeviceType"},
    {0X40101071, DCM_VR_TAG_SQ, "QRMeasurementsSequence"},
    {0X40101072, DCM_VR_TAG_SQ, "TargetMaterialSequence"},
    {0X40101073, DCM_VR_TAG_FD, "SNRThreshold"},
    {0X40101075, DCM_VR_TAG_DS, "ImageScaleRepresentation"},
    {0X40101076, DCM_VR_TAG_SQ, "ReferencedPTOSequence"},
    {0X40101077, DCM_VR_TAG_SQ, "ReferencedTDRInstanceSequence"},
    {0X40101078, DCM_VR_TAG_ST, "PTOLocationDescription"},
    {0X40101079, DCM_VR_TAG_SQ, "AnomalyLocatorIndicatorSequence"},
    {0X4010107A, DCM_VR_TAG_FL, "AnomalyLocatorIndicator"},
    {0X4010107B, DCM_VR_TAG_SQ, "PTORegionSequence"},
    {0X4010107C, DCM_VR_TAG_CS, "InspectionSelectionCriteria"},
    {0X4010107D, DCM_VR_TAG_SQ, "SecondaryInspectionMethodSequence"},
    {0X4010107E, DCM_VR_TAG_DS, "PRCSToRCSOrientation"},
    {0X4FFE0001, DCM_VR_TAG_SQ, "MACParametersSequence"},
    {0X52009229, DCM_VR_TAG_SQ, "SharedFunctionalGroupsSequence"},
    {0X52009230, DCM_VR_TAG_SQ, "PerFrameFunctionalGroupsSequence"},
    {0X54000100, DCM_VR_TAG_SQ, "WaveformSequence"},
    {0X54000110, DCM_VR_TAG_OB_OW, "ChannelMinimumValue"},
    {0X54000112, DCM_VR_TAG_OB_OW, "ChannelMaximumValue"},
    {0X54001004, DCM_VR_TAG_US, "WaveformBitsAllocated"},
    {0X54001006, DCM_VR_TAG_CS, "WaveformSampleInterpretation"},
    {0X5400100A, DCM_VR_TAG_OB_OW, "WaveformPaddingValue"},
    {0X54001010, DCM_VR_TAG_OB_OW, "WaveformData"},
    {0X56000010, DCM_VR_TAG_OF, "FirstOrderPhaseCorrectionAngle"},
    {0X56000020, DCM_VR_TAG_OF, "SpectroscopyData"},
    {0X7FE00001, DCM_VR_TAG_OV, "ExtendedOffsetTable"},
    {0X7FE00002, DCM_VR_TAG_OV, "ExtendedOffsetTableLengths"},
    {0X7FE00008, DCM_VR_TAG_OF, "FloatPixelData"},
    {0X7FE00009, DCM_VR_TAG_OD, "DoubleFloatPixelData"},
    {0X7FE00010, DCM_VR_TAG_OB_OW, "PixelData"},
    {0X7FE00020, DCM_VR_TAG_OW, "CoefficientsSDVN"},
    {0X7FE00030, DCM_VR_TAG_OW, "CoefficientsSDHN"},
    {0X7FE00040, DCM_VR_TAG_OW, "CoefficientsSDDN"},
    {0XFFFAFFFA, DCM_VR_TAG_SQ, "DigitalSignaturesSequence"},
    {0XFFFCFFFC, DCM_VR_TAG_OB, "DataSetTrailingPadding"},
    {0XFFFEE000, DCM_VR_TAG_error, "Item"},
    {0XFFFEE00D, DCM_VR_TAG_error, "ItemDelimitationItem"},
    {0XFFFEE0DD, DCM_VR_TAG_error, "SequenceDelimitationItem"},
};

const int dcm_attribute_table_len = sizeof(dcm_attribute_table) /
                                    sizeof(struct _DcmAttribute);
