/*
** ###################################################################
**     Processors:          MIMXRT595SFAWC_cm33
**                          MIMXRT595SFFOC_cm33
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    iMXRT500RM Rev.0, 01/2021
**     Version:             rev. 5.0, 2020-08-27
**     Build:               b210222
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MIMXRT595S_cm33
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2021 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2019-04-19)
**         Initial version.
**     - rev. 2.0 (2019-07-22)
**         Base on rev 0.7 RM.
**     - rev. 3.0 (2020-03-16)
**         Base on Rev.A RM.
**     - rev. 4.0 (2020-05-18)
**         Base on Rev.B RM.
**     - rev. 5.0 (2020-08-27)
**         Base on Rev.C RM.
**
** ###################################################################
*/

/*!
 * @file MIMXRT595S_cm33.h
 * @version 5.0
 * @date 2020-08-27
 * @brief CMSIS Peripheral Access Layer for MIMXRT595S_cm33
 *
 * CMSIS Peripheral Access Layer for MIMXRT595S_cm33
 */

#ifndef _MIMXRT595S_CM33_H_
#define _MIMXRT595S_CM33_H_                      /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0500U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 90                 /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M33 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M33 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M33 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M33 Usage Fault Interrupt */
  SecureFault_IRQn             = -9,               /**< Cortex-M33 Secure Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M33 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M33 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M33 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M33 System Tick Interrupt */

  /* Device specific interrupts */
  WDT0_IRQn                    = 0,                /**< Watchdog timer interrupt */
  DMA0_IRQn                    = 1,                /**< DMA interrupt */
  GPIO_INTA_IRQn               = 2,                /**< GPIO Interrupt A */
  GPIO_INTB_IRQn               = 3,                /**< GPIO Interrupt B */
  PIN_INT0_IRQn                = 4,                /**< General Purpose Input/Output interrupt 0 */
  PIN_INT1_IRQn                = 5,                /**< General Purpose Input/Output interrupt 1 */
  PIN_INT2_IRQn                = 6,                /**< General Purpose Input/Output interrupt 2 */
  PIN_INT3_IRQn                = 7,                /**< General Purpose Input/Output interrupt 3 */
  UTICK0_IRQn                  = 8,                /**< Micro-tick Timer */
  MRT0_IRQn                    = 9,                /**< Multi-Rate Timer */
  CTIMER0_IRQn                 = 10,               /**< Standard counter/timer CTIMER0 */
  CTIMER1_IRQn                 = 11,               /**< Standard counter/timer CTIMER1 */
  SCT0_IRQn                    = 12,               /**< SCTimer/PWM */
  CTIMER3_IRQn                 = 13,               /**< Standard counter/timer CTIMER3 */
  FLEXCOMM0_IRQn               = 14,               /**< FlexComm interrupt */
  FLEXCOMM1_IRQn               = 15,               /**< FlexComm interrupt */
  FLEXCOMM2_IRQn               = 16,               /**< FlexComm interrupt */
  FLEXCOMM3_IRQn               = 17,               /**< FlexComm interrupt */
  FLEXCOMM4_IRQn               = 18,               /**< FlexComm interrupt */
  FLEXCOMM5_IRQn               = 19,               /**< FlexComm interrupt */
  FLEXCOMM14_IRQn              = 20,               /**< FlexComm interrupt. Standalone SPI */
  FLEXCOMM15_IRQn              = 21,               /**< FlexComm interrupt. Standalone I2C */
  ADC0_IRQn                    = 22,               /**< Analog-to-Digital Converter interrupt */
  Reserved39_IRQn              = 23,               /**< Reserved interrupt */
  ACMP_IRQn                    = 24,               /**< Analog comparator Interrupts */
  DMIC0_IRQn                   = 25,               /**< Digital Microphone Interface interrupt */
  Reserved42_IRQn              = 26,               /**< Reserved interrupt */
  HYPERVISOR_IRQn              = 27,               /**< Hypervisor interrupt */
  SECURE_VIOLATION_IRQn        = 28,               /**< Secure violation interrupt */
  HWVAD0_IRQn                  = 29,               /**< Hardware Voice Activity Detector interrupt */
  Reserved46_IRQn              = 30,               /**< Reserved interrupt */
  RNG_IRQn                     = 31,               /**< Random Number Generator interrupt */
  RTC_IRQn                     = 32,               /**< Real Time Clock Alarm interrupt OR Wakeup timer interrupt */
  DSP_TIE_EXPSTATE1_IRQn       = 33,               /**< DSP interrupt */
  MU_A_IRQn                    = 34,               /**< Messaging Unit - Side A */
  PIN_INT4_IRQn                = 35,               /**< General Purpose Input/Output interrupt 4 */
  PIN_INT5_IRQn                = 36,               /**< General Purpose Input/Output interrupt 5 */
  PIN_INT6_IRQn                = 37,               /**< General Purpose Input/Output interrupt 6 */
  PIN_INT7_IRQn                = 38,               /**< General Purpose Input/Output interrupt 7 */
  CTIMER2_IRQn                 = 39,               /**< Standard counter/timer CTIMER2 */
  CTIMER4_IRQn                 = 40,               /**< Standard counter/timer CTIMER4 */
  OS_EVENT_IRQn                = 41,               /**< Event timer M33 Wakeup/interrupt */
  FLEXSPI0_FLEXSPI1_IRQn       = 42,               /**< FlexSPI0_IRQ OR FlexSPI1_IRQ */
  FLEXCOMM6_IRQn               = 43,               /**< FlexComm interrupt */
  FLEXCOMM7_IRQn               = 44,               /**< FlexComm interrupt */
  USDHC0_IRQn                  = 45,               /**< USDHC interrupt */
  USDHC1_IRQn                  = 46,               /**< USDHC interrupt */
  SGPIO_INTA_IRQn              = 47,               /**< Secure GPIO HS interrupt 0 */
  SGPIO_INTB_IRQn              = 48,               /**< Secure GPIO HS interrupt 1 */
  I3C0_IRQn                    = 49,               /**< Improved Inter Integrated Circuit 0 interrupt */
  USB0_IRQn                    = 50,               /**< USB device */
  USB0_NEEDCLK_IRQn            = 51,               /**< USB Activity Wake-up Interrupt */
  WDT1_IRQn                    = 52,               /**< Watchdog timer 1 interrupt */
  USB_PHYDCD_IRQn              = 53,               /**< USBPHY DCD interrupt */
  DMA1_IRQn                    = 54,               /**< DMA interrupt */
  PUF_IRQn                     = 55,               /**< QuidKey interrupt */
  POWERQUAD_IRQn               = 56,               /**< Powerquad interrupt */
  CASPER_IRQn                  = 57,               /**< Caspar interrupt */
  PMU_PMIC_IRQn                = 58,               /**< Power Management Control interrupt */
  HASHCRYPT_IRQn               = 59,               /**< SHA interrupt */
  FLEXCOMM8_IRQn               = 60,               /**< FlexComm interrupt */
  FLEXCOMM9_IRQn               = 61,               /**< FlexComm interrupt */
  FLEXCOMM10_IRQn              = 62,               /**< FlexComm interrupt */
  FLEXCOMM11_IRQn              = 63,               /**< FlexComm interrupt */
  FLEXCOMM12_IRQn              = 64,               /**< FlexComm interrupt */
  FLEXCOMM13_IRQn              = 65,               /**< FlexComm interrupt */
  FLEXCOMM16_IRQn              = 66,               /**< FlexComm interrupt */
  I3C1_IRQn                    = 67,               /**< Improved Inter Integrated Circuit 1 interrupt */
  FLEXIO_IRQn                  = 68,               /**< Flexible I/O interrupt */
  LCDIF_IRQn                   = 69,               /**< Liquid Crystal Display interface interrupt */
  GPU_IRQn                     = 70,               /**< Graphics Processor Unit interrupt */
  MIPI_IRQn                    = 71,               /**< MIPI interrupt */
  Reserved88_IRQn              = 72,
  SDMA_IRQn                    = 73                /**< Smart DMA Engine Controller interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M33 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M33 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               3         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */
#define __DSP_PRESENT                  1         /**< Defines if Armv8-M Mainline core supports DSP instructions */
#define __SAUREGION_PRESENT            1         /**< Defines if an SAU is present or not */

#include "core_cm33.h"                 /* Core Peripheral Access Layer */
#include "system_MIMXRT595S_cm33.h"    /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CTRL;                              /**< ADC Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< ADC Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< ADC Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< ADC Pause Register, offset: 0x24 */
       uint8_t RESERVED_1[12];
  __O  uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
  __IO uint32_t TSTAT;                             /**< Trigger Status Register, offset: 0x38 */
       uint8_t RESERVED_2[100];
  __IO uint32_t TCTRL[16];                         /**< Trigger Control Register, array offset: 0xA0, array step: 0x4 */
  __IO uint32_t FCTRL[2];                          /**< FIFO Control Register, array offset: 0xE0, array step: 0x4 */
       uint8_t RESERVED_3[24];
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< ADC Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< ADC Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[15];
       uint8_t RESERVED_4[136];
  __IO uint32_t CV[4];                             /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_5[240];
  __I  uint32_t RESFIFO[2];                        /**< ADC Data Result FIFO Register, array offset: 0x300, array step: 0x4 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */
#define ADC_VERID_RES_MASK                       (0x1U)
#define ADC_VERID_RES_SHIFT                      (0U)
/*! RES - Resolution
 *  0b0..Up to 13-bit differential/12-bit single ended resolution supported.
 *  0b1..Up to 16-bit differential/15-bit single ended resolution supported.
 */
#define ADC_VERID_RES(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)
#define ADC_VERID_DIFFEN_MASK                    (0x2U)
#define ADC_VERID_DIFFEN_SHIFT                   (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Differential operation not supported.
 *  0b1..Differential operation supported. CMDLa[DIFF] and CMDLa[ABSEL] control fields implemented.
 */
#define ADC_VERID_DIFFEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)
#define ADC_VERID_MVI_MASK                       (0x8U)
#define ADC_VERID_MVI_SHIFT                      (3U)
/*! MVI - Multi Vref Implemented
 *  0b0..Single voltage reference high (VREFH) input supported.
 *  0b1..Multiple voltage reference high (VREFH) inputs supported.
 */
#define ADC_VERID_MVI(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)
#define ADC_VERID_CSW_MASK                       (0x70U)
#define ADC_VERID_CSW_SHIFT                      (4U)
/*! CSW - Channel Scale Width
 *  0b000..Channel scaling not supported.
 *  0b001..Channel scaling supported. 1-bit CSCALE control field.
 *  0b110..Channel scaling supported. 6-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)
#define ADC_VERID_VR1RNGI_MASK                   (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT                  (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required. CFG[VREF1RNG] is not implemented.
 *  0b1..Range control required. CFG[VREF1RNG] is implemented.
 */
#define ADC_VERID_VR1RNGI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)
#define ADC_VERID_IADCKI_MASK                    (0x200U)
#define ADC_VERID_IADCKI_SHIFT                   (9U)
/*! IADCKI - Internal ADC Clock implemented
 *  0b0..Internal clock source not implemented.
 *  0b1..Internal clock source (and CFG[ADCKEN]) implemented.
 */
#define ADC_VERID_IADCKI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)
#define ADC_VERID_CALOFSI_MASK                   (0x400U)
#define ADC_VERID_CALOFSI_SHIFT                  (10U)
/*! CALOFSI - Calibration Function Implemented
 *  0b0..Calibration Not Implemented.
 *  0b1..Calibration Implemented.
 */
#define ADC_VERID_CALOFSI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)
#define ADC_VERID_NUM_SEC_MASK                   (0x800U)
#define ADC_VERID_NUM_SEC_SHIFT                  (11U)
/*! NUM_SEC - Number of Single Ended Outputs Supported
 *  0b0..This design supports one single ended conversion at a time.
 *  0b1..This design supports two simultanious single ended conversions.
 */
#define ADC_VERID_NUM_SEC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_SEC_SHIFT)) & ADC_VERID_NUM_SEC_MASK)
#define ADC_VERID_NUM_FIFO_MASK                  (0x7000U)
#define ADC_VERID_NUM_FIFO_SHIFT                 (12U)
/*! NUM_FIFO - Number of FIFOs
 *  0b000..N/A
 *  0b001..This design supports one result FIFO.
 *  0b010..This design supports two result FIFOs.
 *  0b011..This design supports three result FIFOs.
 *  0b100..This design supports four result FIFOs.
 */
#define ADC_VERID_NUM_FIFO(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_FIFO_SHIFT)) & ADC_VERID_NUM_FIFO_MASK)
#define ADC_VERID_MINOR_MASK                     (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number
 */
#define ADC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)
#define ADC_VERID_MAJOR_MASK                     (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number
 */
#define ADC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */
#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number
 */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)
#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..Result FIFO depth = 1 dataword.
 *  0b00000100..Result FIFO depth = 4 datawords.
 *  0b00001000..Result FIFO depth = 8 datawords.
 *  0b00010000..Result FIFO depth = 16 datawords.
 *  0b00100000..Result FIFO depth = 32 datawords.
 *  0b01000000..Result FIFO depth = 64 datawords.
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)
#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number
 */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)
#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number
 */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - ADC Control Register */
/*! @{ */
#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - ADC Enable
 *  0b0..ADC is disabled.
 *  0b1..ADC is enabled.
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)
#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)
#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in Doze mode.
 *  0b1..ADC is disabled in Doze mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)
#define ADC_CTRL_RSTFIFO0_MASK                   (0x100U)
#define ADC_CTRL_RSTFIFO0_SHIFT                  (8U)
/*! RSTFIFO0 - Reset FIFO 0
 *  0b0..No effect.
 *  0b1..FIFO 0 is reset.
 */
#define ADC_CTRL_RSTFIFO0(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO0_SHIFT)) & ADC_CTRL_RSTFIFO0_MASK)
#define ADC_CTRL_RSTFIFO1_MASK                   (0x200U)
#define ADC_CTRL_RSTFIFO1_SHIFT                  (9U)
/*! RSTFIFO1 - Reset FIFO 1
 *  0b0..No effect.
 *  0b1..FIFO 1 is reset.
 */
#define ADC_CTRL_RSTFIFO1(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO1_SHIFT)) & ADC_CTRL_RSTFIFO1_MASK)
/*! @} */

/*! @name STAT - ADC Status Register */
/*! @{ */
#define ADC_STAT_RDY0_MASK                       (0x1U)
#define ADC_STAT_RDY0_SHIFT                      (0U)
/*! RDY0 - Result FIFO 0 Ready Flag
 *  0b0..Result FIFO 0 data level not above watermark level.
 *  0b1..Result FIFO 0 holding data above watermark level.
 */
#define ADC_STAT_RDY0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY0_SHIFT)) & ADC_STAT_RDY0_MASK)
#define ADC_STAT_FOF0_MASK                       (0x2U)
#define ADC_STAT_FOF0_SHIFT                      (1U)
/*! FOF0 - Result FIFO 0 Overflow Flag
 *  0b0..No result FIFO 0 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO 0 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF0_SHIFT)) & ADC_STAT_FOF0_MASK)
#define ADC_STAT_RDY1_MASK                       (0x4U)
#define ADC_STAT_RDY1_SHIFT                      (2U)
/*! RDY1 - Result FIFO1 Ready Flag
 *  0b0..Result FIFO1 data level not above watermark level.
 *  0b1..Result FIFO1 holding data above watermark level.
 */
#define ADC_STAT_RDY1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY1_SHIFT)) & ADC_STAT_RDY1_MASK)
#define ADC_STAT_FOF1_MASK                       (0x8U)
#define ADC_STAT_FOF1_SHIFT                      (3U)
/*! FOF1 - Result FIFO1 Overflow Flag
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF1_SHIFT)) & ADC_STAT_FOF1_MASK)
#define ADC_STAT_TEXC_INT_MASK                   (0x100U)
#define ADC_STAT_TEXC_INT_SHIFT                  (8U)
/*! TEXC_INT - Interrupt Flag For High Priority Trigger Exception
 *  0b0..No trigger exceptions have occurred.
 *  0b1..A trigger exception has occurred and is pending acknowledgement.
 */
#define ADC_STAT_TEXC_INT(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TEXC_INT_SHIFT)) & ADC_STAT_TEXC_INT_MASK)
#define ADC_STAT_TCOMP_INT_MASK                  (0x200U)
#define ADC_STAT_TCOMP_INT_SHIFT                 (9U)
/*! TCOMP_INT - Interrupt Flag For Trigger Completion
 *  0b0..Either IE[TCOMP_IE] is set to 0, or no trigger sequences have run to completion.
 *  0b1..Trigger sequence has been completed and all data is stored in the associated FIFO.
 */
#define ADC_STAT_TCOMP_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TCOMP_INT_SHIFT)) & ADC_STAT_TCOMP_INT_MASK)
#define ADC_STAT_ADC_ACTIVE_MASK                 (0x800U)
#define ADC_STAT_ADC_ACTIVE_SHIFT                (11U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..The ADC is IDLE. There are no pending triggers to service and no active commands are being processed.
 *  0b1..The ADC is processing a conversion, running through the power up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)
#define ADC_STAT_TRGACT_MASK                     (0xF0000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b0000..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b0001..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b0010..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b0011-0b1111..Command (sequence) from the associated Trigger number is currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)
#define ADC_STAT_CMDACT_MASK                     (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b0000..No command is currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b0011-0b1111..Associated command number is currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */
#define ADC_IE_FWMIE0_MASK                       (0x1U)
#define ADC_IE_FWMIE0_SHIFT                      (0U)
/*! FWMIE0 - FIFO 0 Watermark Interrupt Enable
 *  0b0..FIFO 0 watermark interrupts are not enabled.
 *  0b1..FIFO 0 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE0_SHIFT)) & ADC_IE_FWMIE0_MASK)
#define ADC_IE_FOFIE0_MASK                       (0x2U)
#define ADC_IE_FOFIE0_SHIFT                      (1U)
/*! FOFIE0 - Result FIFO 0 Overflow Interrupt Enable
 *  0b0..FIFO 0 overflow interrupts are not enabled.
 *  0b1..FIFO 0 overflow interrupts are enabled.
 */
#define ADC_IE_FOFIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE0_SHIFT)) & ADC_IE_FOFIE0_MASK)
#define ADC_IE_FWMIE1_MASK                       (0x4U)
#define ADC_IE_FWMIE1_SHIFT                      (2U)
/*! FWMIE1 - FIFO1 Watermark Interrupt Enable
 *  0b0..FIFO1 watermark interrupts are not enabled.
 *  0b1..FIFO1 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE1_SHIFT)) & ADC_IE_FWMIE1_MASK)
#define ADC_IE_FOFIE1_MASK                       (0x8U)
#define ADC_IE_FOFIE1_SHIFT                      (3U)
/*! FOFIE1 - Result FIFO1 Overflow Interrupt Enable
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_IE_FOFIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE1_SHIFT)) & ADC_IE_FOFIE1_MASK)
#define ADC_IE_TEXC_IE_MASK                      (0x100U)
#define ADC_IE_TEXC_IE_SHIFT                     (8U)
/*! TEXC_IE - Trigger Exception Interrupt Enable
 *  0b0..Trigger exception interrupts are disabled.
 *  0b1..Trigger exception interrupts are enabled.
 */
#define ADC_IE_TEXC_IE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_IE_TEXC_IE_SHIFT)) & ADC_IE_TEXC_IE_MASK)
#define ADC_IE_TCOMP_IE_MASK                     (0xFFFF0000U)
#define ADC_IE_TCOMP_IE_SHIFT                    (16U)
/*! TCOMP_IE - Trigger Completion Interrupt Enable
 *  0b0000000000000000..Trigger completion interrupts are disabled.
 *  0b0000000000000001..Trigger completion interrupts are enabled for trigger source 0 only.
 *  0b0000000000000010..Trigger completion interrupts are enabled for trigger source 1 only.
 *  0b0000000000000011-0b1111111111111110..Associated trigger completion interrupts are enabled.
 *  0b1111111111111111..Trigger completion interrupts are enabled for every trigger source.
 */
#define ADC_IE_TCOMP_IE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_IE_TCOMP_IE_SHIFT)) & ADC_IE_TCOMP_IE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */
#define ADC_DE_FWMDE0_MASK                       (0x1U)
#define ADC_DE_FWMDE0_SHIFT                      (0U)
/*! FWMDE0 - FIFO 0 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE0_SHIFT)) & ADC_DE_FWMDE0_MASK)
#define ADC_DE_FWMDE1_MASK                       (0x2U)
#define ADC_DE_FWMDE1_SHIFT                      (1U)
/*! FWMDE1 - FIFO1 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE1_SHIFT)) & ADC_DE_FWMDE1_MASK)
/*! @} */

/*! @name CFG - ADC Configuration Register */
/*! @{ */
#define ADC_CFG_TPRICTRL_MASK                    (0x3U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - ADC trigger priority control
 *  0b00..If a higher priority trigger is detected during command processing, the current conversion is aborted
 *        and the new command specified by the trigger is started.
 *  0b01..If a higher priority trigger is received during command processing, the current command is stopped after
 *        after completing the current conversion. If averaging is enabled, the averaging loop will be completed.
 *        However, CMDHa[LOOP] will be ignored and the higher priority trigger will be serviced.
 *  0b10..If a higher priority trigger is received during command processing, the current command will be
 *        completed (averaging, looping, compare) before servicing the higher priority trigger.
 *  0b11..RESERVED
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)
#define ADC_CFG_PWRSEL_MASK                      (0x30U)
#define ADC_CFG_PWRSEL_SHIFT                     (4U)
/*! PWRSEL - Power Configuration Select
 *  0b00..Lowest power setting.
 *  0b01..Higher power setting than 0b0.
 *  0b10..Higher power setting than 0b1.
 *  0b11..Highest power setting.
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)
#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..(Default) Option 1 setting.
 *  0b01..Option 2 setting.
 *  0b10..Option 3 setting.
 *  0b11..Reserved
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)
#define ADC_CFG_TRES_MASK                        (0x100U)
#define ADC_CFG_TRES_SHIFT                       (8U)
/*! TRES - Trigger Resume Enable
 *  0b0..Trigger sequences interrupted by a high priority trigger exception are not automatically resumed or restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception are automatically resumed or restarted.
 */
#define ADC_CFG_TRES(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TRES_SHIFT)) & ADC_CFG_TRES_MASK)
#define ADC_CFG_TCMDRES_MASK                     (0x200U)
#define ADC_CFG_TCMDRES_SHIFT                    (9U)
/*! TCMDRES - Trigger Command Resume
 *  0b0..Trigger sequences interrupted by a high priority trigger exception is automatically restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception is resumed from the command executing before the exception.
 */
#define ADC_CFG_TCMDRES(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TCMDRES_SHIFT)) & ADC_CFG_TCMDRES_MASK)
#define ADC_CFG_HPT_EXDI_MASK                    (0x400U)
#define ADC_CFG_HPT_EXDI_SHIFT                   (10U)
/*! HPT_EXDI - High Priority Trigger Exception Disable
 *  0b0..High priority trigger exceptions are enabled.
 *  0b1..High priority trigger exceptions are disabled.
 */
#define ADC_CFG_HPT_EXDI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_HPT_EXDI_SHIFT)) & ADC_CFG_HPT_EXDI_MASK)
#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power Up Delay
 */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)
#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Performance is affected due to analog startup delays.
 *  0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays (at the cost
 *       of higher DC current consumption). A single power up delay (CFG[PUDLY]) is executed immediately once PWREN
 *       is set, and any detected trigger does not begin ADC operation until the power up delay time has passed.
 *       After this initial delay expires the analog will remain pre-enabled, and no additional delays will be
 *       executed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - ADC Pause Register */
/*! @{ */
#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay
 */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)
#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - PAUSE Option Enable
 *  0b0..Pause operation disabled
 *  0b1..Pause operation enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */
#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software trigger 0 event
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)
#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software trigger 1 event
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)
#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software trigger 2 event
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)
#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software trigger 3 event
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)
#define ADC_SWTRIG_SWT4_MASK                     (0x10U)
#define ADC_SWTRIG_SWT4_SHIFT                    (4U)
/*! SWT4 - Software trigger 4 event
 *  0b0..No trigger 4 event generated.
 *  0b1..Trigger 4 event generated.
 */
#define ADC_SWTRIG_SWT4(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT4_SHIFT)) & ADC_SWTRIG_SWT4_MASK)
#define ADC_SWTRIG_SWT5_MASK                     (0x20U)
#define ADC_SWTRIG_SWT5_SHIFT                    (5U)
/*! SWT5 - Software trigger 5 event
 *  0b0..No trigger 5 event generated.
 *  0b1..Trigger 5 event generated.
 */
#define ADC_SWTRIG_SWT5(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT5_SHIFT)) & ADC_SWTRIG_SWT5_MASK)
#define ADC_SWTRIG_SWT6_MASK                     (0x40U)
#define ADC_SWTRIG_SWT6_SHIFT                    (6U)
/*! SWT6 - Software trigger 6 event
 *  0b0..No trigger 6 event generated.
 *  0b1..Trigger 6 event generated.
 */
#define ADC_SWTRIG_SWT6(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT6_SHIFT)) & ADC_SWTRIG_SWT6_MASK)
#define ADC_SWTRIG_SWT7_MASK                     (0x80U)
#define ADC_SWTRIG_SWT7_SHIFT                    (7U)
/*! SWT7 - Software trigger 7 event
 *  0b0..No trigger 7 event generated.
 *  0b1..Trigger 7 event generated.
 */
#define ADC_SWTRIG_SWT7(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT7_SHIFT)) & ADC_SWTRIG_SWT7_MASK)
#define ADC_SWTRIG_SWT8_MASK                     (0x100U)
#define ADC_SWTRIG_SWT8_SHIFT                    (8U)
/*! SWT8 - Software trigger 8 event
 *  0b0..No trigger 8 event generated.
 *  0b1..Trigger 8 event generated.
 */
#define ADC_SWTRIG_SWT8(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT8_SHIFT)) & ADC_SWTRIG_SWT8_MASK)
#define ADC_SWTRIG_SWT9_MASK                     (0x200U)
#define ADC_SWTRIG_SWT9_SHIFT                    (9U)
/*! SWT9 - Software trigger 9 event
 *  0b0..No trigger 9 event generated.
 *  0b1..Trigger 9 event generated.
 */
#define ADC_SWTRIG_SWT9(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT9_SHIFT)) & ADC_SWTRIG_SWT9_MASK)
#define ADC_SWTRIG_SWT10_MASK                    (0x400U)
#define ADC_SWTRIG_SWT10_SHIFT                   (10U)
/*! SWT10 - Software trigger 10 event
 *  0b0..No trigger 10 event generated.
 *  0b1..Trigger 10 event generated.
 */
#define ADC_SWTRIG_SWT10(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT10_SHIFT)) & ADC_SWTRIG_SWT10_MASK)
#define ADC_SWTRIG_SWT11_MASK                    (0x800U)
#define ADC_SWTRIG_SWT11_SHIFT                   (11U)
/*! SWT11 - Software trigger 11 event
 *  0b0..No trigger 11 event generated.
 *  0b1..Trigger 11 event generated.
 */
#define ADC_SWTRIG_SWT11(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT11_SHIFT)) & ADC_SWTRIG_SWT11_MASK)
#define ADC_SWTRIG_SWT12_MASK                    (0x1000U)
#define ADC_SWTRIG_SWT12_SHIFT                   (12U)
/*! SWT12 - Software trigger 12 event
 *  0b0..No trigger 12 event generated.
 *  0b1..Trigger 12 event generated.
 */
#define ADC_SWTRIG_SWT12(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT12_SHIFT)) & ADC_SWTRIG_SWT12_MASK)
#define ADC_SWTRIG_SWT13_MASK                    (0x2000U)
#define ADC_SWTRIG_SWT13_SHIFT                   (13U)
/*! SWT13 - Software trigger 13 event
 *  0b0..No trigger 13 event generated.
 *  0b1..Trigger 13 event generated.
 */
#define ADC_SWTRIG_SWT13(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT13_SHIFT)) & ADC_SWTRIG_SWT13_MASK)
#define ADC_SWTRIG_SWT14_MASK                    (0x4000U)
#define ADC_SWTRIG_SWT14_SHIFT                   (14U)
/*! SWT14 - Software trigger 14 event
 *  0b0..No trigger 14 event generated.
 *  0b1..Trigger 14 event generated.
 */
#define ADC_SWTRIG_SWT14(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT14_SHIFT)) & ADC_SWTRIG_SWT14_MASK)
#define ADC_SWTRIG_SWT15_MASK                    (0x8000U)
#define ADC_SWTRIG_SWT15_SHIFT                   (15U)
/*! SWT15 - Software trigger 15 event
 *  0b0..No trigger 15 event generated.
 *  0b1..Trigger 15 event generated.
 */
#define ADC_SWTRIG_SWT15(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT15_SHIFT)) & ADC_SWTRIG_SWT15_MASK)
/*! @} */

/*! @name TSTAT - Trigger Status Register */
/*! @{ */
#define ADC_TSTAT_TEXC_NUM_MASK                  (0xFFFFU)
#define ADC_TSTAT_TEXC_NUM_SHIFT                 (0U)
/*! TEXC_NUM - Trigger Exception Number
 *  0b0000000000000000..No triggers have been interrupted by a high priority exception. Or CFG[TRES] = 1.
 *  0b0000000000000001..Trigger 0 has been interrupted by a high priority exception.
 *  0b0000000000000010..Trigger 1 has been interrupted by a high priority exception.
 *  0b0000000000000011-0b1111111111111110..Associated trigger sequence has interrupted by a high priority exception.
 *  0b1111111111111111..Every trigger sequence has been interrupted by a high priority exception.
 */
#define ADC_TSTAT_TEXC_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TEXC_NUM_SHIFT)) & ADC_TSTAT_TEXC_NUM_MASK)
#define ADC_TSTAT_TCOMP_FLAG_MASK                (0xFFFF0000U)
#define ADC_TSTAT_TCOMP_FLAG_SHIFT               (16U)
/*! TCOMP_FLAG - Trigger Completion Flag
 *  0b0000000000000000..No triggers have been completed. Trigger completion interrupts are disabled.
 *  0b0000000000000001..Trigger 0 has been completed and triger 0 has enabled completion interrupts.
 *  0b0000000000000010..Trigger 1 has been completed and triger 1 has enabled completion interrupts.
 *  0b0000000000000011-0b1111111111111110..Associated trigger sequence has completed and has enabled completion interrupts.
 *  0b1111111111111111..Every trigger sequence has been completed and every trigger has enabled completion interrupts.
 */
#define ADC_TSTAT_TCOMP_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TCOMP_FLAG_SHIFT)) & ADC_TSTAT_TCOMP_FLAG_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */
#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger enable
 *  0b0..Hardware trigger source disabled
 *  0b1..Hardware trigger source enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)
#define ADC_TCTRL_FIFO_SEL_A_MASK                (0x2U)
#define ADC_TCTRL_FIFO_SEL_A_SHIFT               (1U)
/*! FIFO_SEL_A - SAR Result Destination For Channel A
 *  0b0..Result written to FIFO 0
 *  0b1..Result written to FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_A(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_A_SHIFT)) & ADC_TCTRL_FIFO_SEL_A_MASK)
#define ADC_TCTRL_TPRI_MASK                      (0xF00U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger priority setting
 *  0b0000..Set to highest priority, Level 1
 *  0b0001-0b1110..Set to corresponding priority level
 *  0b1111..Set to lowest priority, Level 16
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)
#define ADC_TCTRL_RSYNC_MASK                     (0x8000U)
#define ADC_TCTRL_RSYNC_SHIFT                    (15U)
/*! RSYNC - Trigger Resync
 */
#define ADC_TCTRL_RSYNC(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_RSYNC_SHIFT)) & ADC_TCTRL_RSYNC_MASK)
#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger delay select
 */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)
#define ADC_TCTRL_TCMD_MASK                      (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger command select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1 is executed
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15 is executed
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (16U)

/*! @name FCTRL - FIFO Control Register */
/*! @{ */
#define ADC_FCTRL_FCOUNT_MASK                    (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO counter
 */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)
#define ADC_FCTRL_FWMARK_MASK                    (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark level selection
 */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/* The count of ADC_FCTRL */
#define ADC_FCTRL_COUNT                          (2U)

/*! @name CMDL - ADC Command Low Buffer Register */
/*! @{ */
#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input channel select
 *  0b00000..Select CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..Select CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..Select CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..Select CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..Select CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..Select CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)
#define ADC_CMDL_ABSEL_MASK                      (0x20U)
#define ADC_CMDL_ABSEL_SHIFT                     (5U)
/*! ABSEL - A-side vs. B-side Select
 *  0b0..When DIFF=0b0, the associated A-side channel is converted as single-ended. When DIFF=0b1, the ADC result is (CHnA-CHnB).
 *  0b1..When DIFF=0b0, the associated B-side channel is converted as single-ended. When DIFF=0b1, the ADC result is (CHnB-CHnA).
 */
#define ADC_CMDL_ABSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ABSEL_SHIFT)) & ADC_CMDL_ABSEL_MASK)
#define ADC_CMDL_DIFF_MASK                       (0x40U)
#define ADC_CMDL_DIFF_SHIFT                      (6U)
/*! DIFF - Differential Mode Enable
 *  0b0..Single-ended mode.
 *  0b1..Differential mode.
 */
#define ADC_CMDL_DIFF(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_DIFF_SHIFT)) & ADC_CMDL_DIFF_MASK)
#define ADC_CMDL_CSCALE_MASK                     (0x2000U)
#define ADC_CMDL_CSCALE_SHIFT                    (13U)
/*! CSCALE - Channel Scale
 *  0b0..Scale selected analog channel (Factor of 30/64)
 *  0b1..(Default) Full scale (Factor of 1)
 */
#define ADC_CMDL_CSCALE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CSCALE_SHIFT)) & ADC_CMDL_CSCALE_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (15U)

/*! @name CMDH - ADC Command High Buffer Register */
/*! @{ */
#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Compare disabled.
 *  0b01..Reserved
 *  0b10..Compare enabled. Store on true.
 *  0b11..Compare enabled. Repeat channel acquisition (sample/convert/compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)
#define ADC_CMDH_WAIT_TRIG_MASK                  (0x4U)
#define ADC_CMDH_WAIT_TRIG_SHIFT                 (2U)
/*! WAIT_TRIG - Wait for trigger assertion before execution.
 *  0b0..This command will be automatically executed.
 *  0b1..The active trigger must be asserted again before executing this command.
 */
#define ADC_CMDH_WAIT_TRIG(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_WAIT_TRIG_SHIFT)) & ADC_CMDH_WAIT_TRIG_MASK)
#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Auto channel increment disabled
 *  0b1..Auto channel increment enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)
#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3 ADCK cycles.
 *  0b001..3 + 21 ADCK cycles; 5 ADCK cycles total sample time.
 *  0b010..3 + 22 ADCK cycles; 7 ADCK cycles total sample time.
 *  0b011..3 + 23 ADCK cycles; 11 ADCK cycles total sample time.
 *  0b100..3 + 24 ADCK cycles; 19 ADCK cycles total sample time.
 *  0b101..3 + 25 ADCK cycles; 35 ADCK cycles total sample time.
 *  0b110..3 + 26 ADCK cycles; 67 ADCK cycles total sample time.
 *  0b111..3 + 27 ADCK cycles; 131 ADCK cycles total sample time.
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)
#define ADC_CMDH_AVGS_MASK                       (0x7000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)
#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes 1 time.
 *  0b0001..Loop 1 time. Command executes 2 times.
 *  0b0010..Loop 2 times. Command executes 3 times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP+1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)
#define ADC_CMDH_NEXT_MASK                       (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..Select CMD1 command buffer register as next command.
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..Select CMD15 command buffer register as next command.
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (15U)

/*! @name CV - Compare Value Register */
/*! @{ */
#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low.
 */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)
#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High.
 */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (4U)

/*! @name RESFIFO - ADC Data Result FIFO Register */
/*! @{ */
#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data result
 */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)
#define ADC_RESFIFO_TSRC_MASK                    (0xF0000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b0000..Trigger source 0 initiated this conversion.
 *  0b0001..Trigger source 1 initiated this conversion.
 *  0b0010-0b1110..Corresponding trigger source initiated this conversion.
 *  0b1111..Trigger source 15 initiated this conversion.
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)
#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop count value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from LOOPCNT+1 conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)
#define ADC_RESFIFO_CMDSRC_MASK                  (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a dataword in RESFIFO. 0x0 is only found in initial FIFO state
 *          prior to an ADC conversion result dataword being stored to a RESFIFO buffer.
 *  0b0001..CMD1 buffer used as control settings for this conversion.
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15 buffer used as control settings for this conversion.
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)
#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO entry is valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */

/* The count of ADC_RESFIFO */
#define ADC_RESFIFO_COUNT                        (2U)


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x5013A000u)
  /** Peripheral ADC0 base address */
  #define ADC0_BASE_NS                             (0x4013A000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Peripheral ADC0 base pointer */
  #define ADC0_NS                                  ((ADC_Type *)ADC0_BASE_NS)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0 }
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS_NS                        { ADC0_BASE_NS }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS_NS                         { ADC0_NS }
#else
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x4013A000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0 }
#endif
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { ADC0_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AHB_SECURE_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHB_SECURE_CTRL_Peripheral_Access_Layer AHB_SECURE_CTRL Peripheral Access Layer
 * @{
 */

/** AHB_SECURE_CTRL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t ROM_MEM_RULE[4];                   /**< Memory ROM Rule(n) Register, array offset: 0x10, array step: 0x4 */
       uint8_t RESERVED_1[16];
  __IO uint32_t FLEXSPI0_REGION0_RULE[4];          /**< FLEXSPI0 Region 0 Rule(n) Register, array offset: 0x30, array step: 0x4 */
  struct {                                         /* offset: 0x40, array step: 0x10 */
    __IO uint32_t FLEXSPI0_REGION_RULE0;             /**< FLEXSPI0 Region 1 Rule 0 Register..FLEXSPI0 Region 4 Rule 0 Register, array offset: 0x40, array step: 0x10 */
         uint8_t RESERVED_0[12];
  } FLEXSPI0_REGION1_4_RULE[4];
       uint8_t RESERVED_2[16];
  __IO uint32_t RAM00_RULE[4];                     /**< SRAM Partition 00 Rule(n) Register, array offset: 0x90, array step: 0x4 */
  __IO uint32_t RAM01_RULE[4];                     /**< SRAM Partition 01 Rule(n) Register, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_3[16];
  __IO uint32_t RAM02_RULE[4];                     /**< SRAM Partition 02 Rule(n) Register, array offset: 0xC0, array step: 0x4 */
  __IO uint32_t RAM03_RULE[4];                     /**< SRAM Partition 03 Rule(n) Register, array offset: 0xD0, array step: 0x4 */
       uint8_t RESERVED_4[16];
  __IO uint32_t RAM04_RULE[4];                     /**< SRAM Partition 04 Rule(n) Register, array offset: 0xF0, array step: 0x4 */
  __IO uint32_t RAM05_RULE[4];                     /**< SRAM Partition 05 Rule(n) Register, array offset: 0x100, array step: 0x4 */
  __IO uint32_t RAM06_RULE[4];                     /**< SRAM Partition 06 Rule(n) Register, array offset: 0x110, array step: 0x4 */
  __IO uint32_t RAM07_RULE[4];                     /**< SRAM Partition 07 Rule(n) Register, array offset: 0x120, array step: 0x4 */
       uint8_t RESERVED_5[16];
  __IO uint32_t RAM08_RULE[4];                     /**< SRAM Partition 08 Rule(n) Register, array offset: 0x140, array step: 0x4 */
  __IO uint32_t RAM09_RULE[4];                     /**< SRAM Partition 09 Rule(n) Register, array offset: 0x150, array step: 0x4 */
  __IO uint32_t RAM10_RULE[4];                     /**< SRAM Partition 10 Rule(n) Register, array offset: 0x160, array step: 0x4 */
  __IO uint32_t RAM11_RULE[4];                     /**< SRAM Partition 11 Rule(n) Register, array offset: 0x170, array step: 0x4 */
       uint8_t RESERVED_6[16];
  __IO uint32_t RAM12_RULE[4];                     /**< SRAM Partition 12 Rule(n) Register, array offset: 0x190, array step: 0x4 */
  __IO uint32_t RAM13_RULE[4];                     /**< SRAM Partition 13 Rule(n) Register, array offset: 0x1A0, array step: 0x4 */
  __IO uint32_t RAM14_RULE[4];                     /**< SRAM Partition 14 Rule(n) Register, array offset: 0x1B0, array step: 0x4 */
  __IO uint32_t RAM15_RULE[4];                     /**< SRAM Partition 15 Rule(n) Register, array offset: 0x1C0, array step: 0x4 */
       uint8_t RESERVED_7[16];
  __IO uint32_t RAM16_RULE[4];                     /**< SRAM Partition 16 Rule(n) Register, array offset: 0x1E0, array step: 0x4 */
  __IO uint32_t RAM17_RULE[4];                     /**< SRAM Partition 17 Rule(n) Register, array offset: 0x1F0, array step: 0x4 */
  __IO uint32_t RAM18_RULE[4];                     /**< SRAM Partition 18 Rule(n) Register, array offset: 0x200, array step: 0x4 */
  __IO uint32_t RAM19_RULE[4];                     /**< SRAM Partition 19 Rule(n) Register, array offset: 0x210, array step: 0x4 */
       uint8_t RESERVED_8[16];
  __IO uint32_t RAM20_RULE[4];                     /**< SRAM Partition 20 Rule(n) Register, array offset: 0x230, array step: 0x4 */
  __IO uint32_t RAM21_RULE[4];                     /**< SRAM Partition 21 Rule(n) Register, array offset: 0x240, array step: 0x4 */
  __IO uint32_t RAM22_RULE[4];                     /**< SRAM Partition 22 Rule(n) Register, array offset: 0x250, array step: 0x4 */
  __IO uint32_t RAM23_RULE[4];                     /**< SRAM Partition 23 Rule(n) Register, array offset: 0x260, array step: 0x4 */
       uint8_t RESERVED_9[16];
  __IO uint32_t RAM24_RULE[4];                     /**< SRAM Partition 24 Rule(n) Register, array offset: 0x280, array step: 0x4 */
  __IO uint32_t RAM25_RULE[4];                     /**< SRAM Partition 25 Rule(n) Register, array offset: 0x290, array step: 0x4 */
  __IO uint32_t RAM26_RULE[4];                     /**< SRAM Partition 26 Rule(n) Register, array offset: 0x2A0, array step: 0x4 */
  __IO uint32_t RAM27_RULE[4];                     /**< SRAM Partition 27 Rule(n) Register, array offset: 0x2B0, array step: 0x4 */
       uint8_t RESERVED_10[16];
  __IO uint32_t RAM28_RULE[4];                     /**< SRAM Partition 28 Rule(n) Register, array offset: 0x2D0, array step: 0x4 */
  __IO uint32_t RAM29_RULE[4];                     /**< SRAM Partition 29 Rule(n) Register, array offset: 0x2E0, array step: 0x4 */
  __IO uint32_t RAM30_RULE[4];                     /**< SRAM Partition 30 Rule(n) Register, array offset: 0x2F0, array step: 0x4 */
  __IO uint32_t RAM31_RULE[4];                     /**< SRAM Partition 31 Rule(n) Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_11[16];
  __IO uint32_t SDMA_RAM_RULE[4];                  /**< Smart DMA (SDMA) RAM Rule(n) Register, array offset: 0x320, array step: 0x4 */
       uint8_t RESERVED_12[16];
  __IO uint32_t FLEXSPI1_REGION0_RULE[4];          /**< FlexSPI1 Region 0 Rule(n) Register, array offset: 0x340, array step: 0x4 */
  struct {                                         /* offset: 0x350, array step: 0x10 */
    __IO uint32_t FLEXSPI1_REGION_RULE0;             /**< FlexSPI1 Region 1 Rule 0 Register..FlexSPI1 Region 4 Rule 0 Register, array offset: 0x350, array step: 0x10 */
         uint8_t RESERVED_0[12];
  } FLEXSPI1_REGIONN_RULE0[4];
       uint8_t RESERVED_13[16];
  __IO uint32_t APB_BRIDGE_PER0_RULE0;             /**< APB Bridge Peripheral 0 Rule 0 Register, offset: 0x3A0 */
  __IO uint32_t APB_BRIDGE_PER0_RULE1;             /**< APB Bridge Peripheral 0 Rule 1 Register, offset: 0x3A4 */
       uint8_t RESERVED_14[4];
  __IO uint32_t APB_BRIDGE_PER0_RULE3;             /**< APB Bridge Peripheral 0 Rule 3 Register, offset: 0x3AC */
  __IO uint32_t APB_BRIDGE_PER1_RULE0;             /**< APB Bridge Peripheral 1 Rule 0 Register, offset: 0x3B0 */
  __IO uint32_t APB_BRIDGE_PER1_RULE1;             /**< APB Bridge Peripheral 1 Rule 1 Register, offset: 0x3B4 */
  __IO uint32_t APB_BRIDGE_PER1_RULE2;             /**< APB Bridge Peripheral 1 Rule 2 Register, offset: 0x3B8 */
  __IO uint32_t APB_BRIDGE_PER1_RULE3;             /**< APB Bridge Peripheral 1 Rule 3 Register, offset: 0x3BC */
  __IO uint32_t AHB_PERIPH0_SLAVE_RULE0;           /**< AHB Peripheral 0 Slave Rule 0 Register, offset: 0x3C0 */
       uint8_t RESERVED_15[12];
  __IO uint32_t AIPS_BRIDGE0_PER_RULE0;            /**< AIPS Bridge Peripheral 0 Rule 0 Register, offset: 0x3D0 */
       uint8_t RESERVED_16[12];
  __IO uint32_t AHB_PERIPH1_SLAVE_RULE0;           /**< AHB Peripheral 1 Slave Rule 0 Register, offset: 0x3E0 */
  __IO uint32_t AHB_PERIPH1_SLAVE_RULE1;           /**< AHB Peripheral 1 Slave Rule 1 Register, offset: 0x3E4 */
       uint8_t RESERVED_17[24];
  __IO uint32_t AIPS_BRIDGE1_PER_RULE0;            /**< AIPS Bridge Peripheral 1 Rule 0 Register, offset: 0x400 */
  __IO uint32_t AIPS_BRIDGE1_PER_RULE1;            /**< AIPS Bridge Peripheral 1 Rule 1 Register, offset: 0x404 */
       uint8_t RESERVED_18[8];
  __IO uint32_t AHB_PERIPH2_SLAVE_RULE0;           /**< AHB Peripheral 2 Slave Rule 0 Register, offset: 0x410 */
       uint8_t RESERVED_19[12];
  __IO uint32_t AHB_SECURE_CTRL_PERIPH_RULE0;      /**< AHB Secure Control Peripheral Rule 0 Register, offset: 0x420 */
       uint8_t RESERVED_20[12];
  __IO uint32_t AHB_PERIPH3_SLAVE_RULE0;           /**< AHB Peripheral 3 Slave Rule 0 Register, offset: 0x430 */
  __IO uint32_t AHB_PERIPH3_SLAVE_RULE1;           /**< AHB Peripheral 3 Slave Rule 1 Register, offset: 0x434 */
       uint8_t RESERVED_21[2504];
  __I  uint32_t SEC_VIO_ADDR[18];                  /**< Security Violation Address(n) Register, array offset: 0xE00, array step: 0x4 */
       uint8_t RESERVED_22[56];
  __I  uint32_t SEC_VIO_MISC_INFO[18];             /**< Security Violation Miscellaneous Information at Address(n) Register, array offset: 0xE80, array step: 0x4 */
       uint8_t RESERVED_23[56];
  __IO uint32_t SEC_VIO_INFO_VALID;                /**< Security Violation Info Validity for Address(n) Register, offset: 0xF00 */
       uint8_t RESERVED_24[124];
  __IO uint32_t SEC_GPIO_MASK0;                    /**< GPIO Mask for Port 0 Register, offset: 0xF80 */
  __IO uint32_t SEC_GPIO_MASK1;                    /**< GPIO Mask for Port 1 Register, offset: 0xF84 */
  __IO uint32_t SEC_GPIO_MASK2;                    /**< GPIO Mask for Port 2 Register, offset: 0xF88 */
       uint8_t RESERVED_25[20];
  __IO uint32_t DSP_INT_MASK0;                     /**< Secure Interrupt Mask for DSP Register, offset: 0xFA0 */
       uint8_t RESERVED_26[24];
  __IO uint32_t SEC_MASK_LOCK;                     /**< Secure Mask Lock Register, offset: 0xFBC */
       uint8_t RESERVED_27[16];
  __IO uint32_t MASTER_SEC_LEVEL;                  /**< Master Secure Level Register, offset: 0xFD0 */
  __IO uint32_t MASTER_SEC_ANTI_POL_REG;           /**< Master Secure Level Register, offset: 0xFD4 */
       uint8_t RESERVED_28[20];
  __IO uint32_t CM33_LOCK_REG;                     /**< Miscellaneous CPU0 Control Signals Register, offset: 0xFEC */
       uint8_t RESERVED_29[8];
  __IO uint32_t MISC_CTRL_DP_REG;                  /**< Secure Control Duplicate Register, offset: 0xFF8 */
  __IO uint32_t MISC_CTRL_REG;                     /**< Secure Control Register, offset: 0xFFC */
} AHB_SECURE_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- AHB_SECURE_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AHB_SECURE_CTRL_Register_Masks AHB_SECURE_CTRL Register Masks
 * @{
 */

/*! @name ROM_MEM_RULE - Memory ROM Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE0_MASK  (0x3U)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE0(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_ROM_MEM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_ROM_MEM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE1_MASK  (0x30U)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE1(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_ROM_MEM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_ROM_MEM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE2_MASK  (0x300U)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE2(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_ROM_MEM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_ROM_MEM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE3_MASK  (0x3000U)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE3(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_ROM_MEM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_ROM_MEM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE4_MASK  (0x30000U)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE4(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_ROM_MEM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_ROM_MEM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE5_MASK  (0x300000U)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE5(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_ROM_MEM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_ROM_MEM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE6_MASK  (0x3000000U)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE6(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_ROM_MEM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_ROM_MEM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE7_MASK  (0x30000000U)
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_RULE7(x)    (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_ROM_MEM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_ROM_MEM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_ROM_MEM_RULE */
#define AHB_SECURE_CTRL_ROM_MEM_RULE_COUNT       (4U)

/*! @name FLEXSPI0_REGION0_RULE - FLEXSPI0 Region 0 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE6_SHIFT (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE7_SHIFT (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION0_RULE_COUNT (4U)

/*! @name FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0 - FLEXSPI0 Region 1 Rule 0 Register..FLEXSPI0 Region 4 Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE0_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE1_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE2_MASK)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_RULE3_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0 */
#define AHB_SECURE_CTRL_FLEXSPI0_REGION1_4_RULE_FLEXSPI0_REGION_RULE0_COUNT (4U)

/*! @name RAM00_RULE - SRAM Partition 00 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM00_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM00_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM00_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM00_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM00_RULE */
#define AHB_SECURE_CTRL_RAM00_RULE_COUNT         (4U)

/*! @name RAM01_RULE - SRAM Partition 01 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM01_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM01_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM01_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM01_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM01_RULE */
#define AHB_SECURE_CTRL_RAM01_RULE_COUNT         (4U)

/*! @name RAM02_RULE - SRAM Partition 02 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM02_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM02_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM02_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM02_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM02_RULE */
#define AHB_SECURE_CTRL_RAM02_RULE_COUNT         (4U)

/*! @name RAM03_RULE - SRAM Partition 03 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM03_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM03_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM03_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM03_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM03_RULE */
#define AHB_SECURE_CTRL_RAM03_RULE_COUNT         (4U)

/*! @name RAM04_RULE - SRAM Partition 04 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM04_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM04_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM04_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM04_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM04_RULE */
#define AHB_SECURE_CTRL_RAM04_RULE_COUNT         (4U)

/*! @name RAM05_RULE - SRAM Partition 05 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM05_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM05_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM05_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM05_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM05_RULE */
#define AHB_SECURE_CTRL_RAM05_RULE_COUNT         (4U)

/*! @name RAM06_RULE - SRAM Partition 06 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM06_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM06_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM06_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM06_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM06_RULE */
#define AHB_SECURE_CTRL_RAM06_RULE_COUNT         (4U)

/*! @name RAM07_RULE - SRAM Partition 07 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM07_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM07_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM07_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM07_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM07_RULE */
#define AHB_SECURE_CTRL_RAM07_RULE_COUNT         (4U)

/*! @name RAM08_RULE - SRAM Partition 08 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM08_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM08_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM08_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM08_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM08_RULE */
#define AHB_SECURE_CTRL_RAM08_RULE_COUNT         (4U)

/*! @name RAM09_RULE - SRAM Partition 09 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM09_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM09_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM09_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM09_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM09_RULE */
#define AHB_SECURE_CTRL_RAM09_RULE_COUNT         (4U)

/*! @name RAM10_RULE - SRAM Partition 10 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM10_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM10_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM10_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM10_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM10_RULE */
#define AHB_SECURE_CTRL_RAM10_RULE_COUNT         (4U)

/*! @name RAM11_RULE - SRAM Partition 11 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM11_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM11_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM11_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM11_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM11_RULE */
#define AHB_SECURE_CTRL_RAM11_RULE_COUNT         (4U)

/*! @name RAM12_RULE - SRAM Partition 12 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM12_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM12_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM12_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM12_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM12_RULE */
#define AHB_SECURE_CTRL_RAM12_RULE_COUNT         (4U)

/*! @name RAM13_RULE - SRAM Partition 13 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM13_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM13_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM13_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM13_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM13_RULE */
#define AHB_SECURE_CTRL_RAM13_RULE_COUNT         (4U)

/*! @name RAM14_RULE - SRAM Partition 14 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM14_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM14_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM14_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM14_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM14_RULE */
#define AHB_SECURE_CTRL_RAM14_RULE_COUNT         (4U)

/*! @name RAM15_RULE - SRAM Partition 15 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM15_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM15_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM15_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM15_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM15_RULE */
#define AHB_SECURE_CTRL_RAM15_RULE_COUNT         (4U)

/*! @name RAM16_RULE - SRAM Partition 16 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM16_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM16_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM16_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM16_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM16_RULE */
#define AHB_SECURE_CTRL_RAM16_RULE_COUNT         (4U)

/*! @name RAM17_RULE - SRAM Partition 17 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM17_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM17_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM17_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM17_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM17_RULE */
#define AHB_SECURE_CTRL_RAM17_RULE_COUNT         (4U)

/*! @name RAM18_RULE - SRAM Partition 18 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM18_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM18_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM18_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM18_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM18_RULE */
#define AHB_SECURE_CTRL_RAM18_RULE_COUNT         (4U)

/*! @name RAM19_RULE - SRAM Partition 19 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM19_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM19_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM19_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM19_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM19_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM19_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM19_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM19_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM19_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM19_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM19_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM19_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM19_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM19_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM19_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM19_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM19_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM19_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM19_RULE */
#define AHB_SECURE_CTRL_RAM19_RULE_COUNT         (4U)

/*! @name RAM20_RULE - SRAM Partition 20 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM20_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM20_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM20_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM20_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM20_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM20_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM20_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM20_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM20_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM20_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM20_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM20_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM20_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM20_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM20_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM20_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM20_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM20_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM20_RULE */
#define AHB_SECURE_CTRL_RAM20_RULE_COUNT         (4U)

/*! @name RAM21_RULE - SRAM Partition 21 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM21_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM21_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM21_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM21_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM21_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM21_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM21_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM21_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM21_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM21_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM21_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM21_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM21_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM21_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM21_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM21_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM21_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM21_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM21_RULE */
#define AHB_SECURE_CTRL_RAM21_RULE_COUNT         (4U)

/*! @name RAM22_RULE - SRAM Partition 22 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM22_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM22_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM22_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM22_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM22_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM22_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM22_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM22_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM22_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM22_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM22_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM22_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM22_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM22_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM22_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM22_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM22_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM22_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM22_RULE */
#define AHB_SECURE_CTRL_RAM22_RULE_COUNT         (4U)

/*! @name RAM23_RULE - SRAM Partition 23 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM23_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM23_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM23_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM23_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM23_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM23_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM23_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM23_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM23_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM23_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM23_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM23_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM23_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM23_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM23_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM23_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM23_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM23_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM23_RULE */
#define AHB_SECURE_CTRL_RAM23_RULE_COUNT         (4U)

/*! @name RAM24_RULE - SRAM Partition 24 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM24_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM24_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM24_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM24_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM24_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM24_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM24_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM24_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM24_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM24_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM24_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM24_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM24_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM24_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM24_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM24_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM24_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM24_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM24_RULE */
#define AHB_SECURE_CTRL_RAM24_RULE_COUNT         (4U)

/*! @name RAM25_RULE - SRAM Partition 25 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM25_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM25_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM25_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM25_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM25_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM25_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM25_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM25_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM25_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM25_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM25_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM25_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM25_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM25_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM25_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM25_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM25_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM25_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM25_RULE */
#define AHB_SECURE_CTRL_RAM25_RULE_COUNT         (4U)

/*! @name RAM26_RULE - SRAM Partition 26 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM26_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM26_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM26_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM26_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM26_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM26_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM26_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM26_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM26_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM26_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM26_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM26_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM26_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM26_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM26_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM26_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM26_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM26_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM26_RULE */
#define AHB_SECURE_CTRL_RAM26_RULE_COUNT         (4U)

/*! @name RAM27_RULE - SRAM Partition 27 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM27_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM27_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM27_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM27_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM27_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM27_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM27_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM27_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM27_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM27_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM27_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM27_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM27_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM27_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM27_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM27_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM27_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM27_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM27_RULE */
#define AHB_SECURE_CTRL_RAM27_RULE_COUNT         (4U)

/*! @name RAM28_RULE - SRAM Partition 28 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM28_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM28_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM28_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM28_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM28_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM28_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM28_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM28_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM28_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM28_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM28_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM28_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM28_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM28_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM28_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM28_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM28_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM28_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM28_RULE */
#define AHB_SECURE_CTRL_RAM28_RULE_COUNT         (4U)

/*! @name RAM29_RULE - SRAM Partition 29 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM29_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM29_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM29_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM29_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM29_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM29_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM29_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM29_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM29_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM29_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM29_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM29_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM29_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM29_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM29_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM29_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM29_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM29_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM29_RULE */
#define AHB_SECURE_CTRL_RAM29_RULE_COUNT         (4U)

/*! @name RAM30_RULE - SRAM Partition 30 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM30_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM30_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM30_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM30_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM30_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM30_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM30_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM30_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM30_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM30_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM30_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM30_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM30_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM30_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM30_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM30_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM30_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM30_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM30_RULE */
#define AHB_SECURE_CTRL_RAM30_RULE_COUNT         (4U)

/*! @name RAM31_RULE - SRAM Partition 31 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE0_MASK    (0x3U)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE0_SHIFT   (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE0(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM31_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_RAM31_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE1_MASK    (0x30U)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE1_SHIFT   (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE1(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM31_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_RAM31_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE2_MASK    (0x300U)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE2_SHIFT   (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE2(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM31_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_RAM31_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE3_MASK    (0x3000U)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE3_SHIFT   (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE3(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM31_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_RAM31_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE4_MASK    (0x30000U)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE4_SHIFT   (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE4(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM31_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_RAM31_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE5_MASK    (0x300000U)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE5_SHIFT   (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE5(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM31_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_RAM31_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE6_MASK    (0x3000000U)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE6_SHIFT   (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE6(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM31_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_RAM31_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE7_MASK    (0x30000000U)
#define AHB_SECURE_CTRL_RAM31_RULE_RULE7_SHIFT   (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_RAM31_RULE_RULE7(x)      (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_RAM31_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_RAM31_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_RAM31_RULE */
#define AHB_SECURE_CTRL_RAM31_RULE_COUNT         (4U)

/*! @name SDMA_RAM_RULE - Smart DMA (SDMA) RAM Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE0(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE1(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE2(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE3(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE4(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE5(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE6_SHIFT (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE6(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE7_SHIFT (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE7(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_SDMA_RAM_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SDMA_RAM_RULE */
#define AHB_SECURE_CTRL_SDMA_RAM_RULE_COUNT      (4U)

/*! @name FLEXSPI1_REGION0_RULE - FlexSPI1 Region 0 Rule(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE0_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE1_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE2_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE3_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE4_MASK (0x30000U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE4_SHIFT (16U)
/*! RULE4 - Rule 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE4_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE4_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE5_MASK (0x300000U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE5_SHIFT (20U)
/*! RULE5 - Rule 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE5_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE5_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE6_MASK (0x3000000U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE6_SHIFT (24U)
/*! RULE6 - Rule 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE6_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE6_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE7_MASK (0x30000000U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE7_SHIFT (28U)
/*! RULE7 - Rule 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE7_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_RULE7_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE */
#define AHB_SECURE_CTRL_FLEXSPI1_REGION0_RULE_COUNT (4U)

/*! @name FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0 - FlexSPI1 Region 1 Rule 0 Register..FlexSPI1 Region 4 Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE0_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE0_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE1_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE1_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE2_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE2_MASK)
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE3_SHIFT)) & AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_RULE3_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0 */
#define AHB_SECURE_CTRL_FLEXSPI1_REGIONN_RULE0_FLEXSPI1_REGION_RULE0_COUNT (4U)

/*! @name APB_BRIDGE_PER0_RULE0 - APB Bridge Peripheral 0 Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_RSTCTL_A_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_RSTCTL_A_SHIFT (0U)
/*! RSTCTL_A - RSTCTL_A
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_RSTCTL_A(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_RSTCTL_A_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_RSTCTL_A_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_CLKCTL_A_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_CLKCTL_A_SHIFT (4U)
/*! CLKCTL_A - CLKCTL_A
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_CLKCTL_A(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_CLKCTL_A_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_CLKCTL_A_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_SYSCTL_A_MASK (0x300U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_SYSCTL_A_SHIFT (8U)
/*! SYSCTL_A - SYSCTL_A
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_SYSCTL_A(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_SYSCTL_A_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_SYSCTL_A_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PVT_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PVT_SHIFT (12U)
/*! PVT - PVT
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PVT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PVT_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PVT_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_IOCON_MASK (0x30000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_IOCON_SHIFT (16U)
/*! IOCON - IOCON
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_IOCON(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_IOCON_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_IOCON_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PUF_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PUF_SHIFT (24U)
/*! PUF - PUF
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PUF(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PUF_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE0_PUF_MASK)
/*! @} */

/*! @name APB_BRIDGE_PER0_RULE1 - APB Bridge Peripheral 0 Rule 1 Register */
/*! @{ */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_WWDT0_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_WWDT0_SHIFT (24U)
/*! WWDT0 - WWDT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_WWDT0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_WWDT0_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_WWDT0_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_MICRO_TICK_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_MICRO_TICK_SHIFT (28U)
/*! MICRO_TICK - MICRO_TICK
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_MICRO_TICK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_MICRO_TICK_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE1_MICRO_TICK_MASK)
/*! @} */

/*! @name APB_BRIDGE_PER0_RULE3 - APB Bridge Peripheral 0 Rule 3 Register */
/*! @{ */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_SYNC_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_SYNC_SHIFT (24U)
/*! PROBE_IS_SYNC - PROBE_IS (SYNC)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_SYNC(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_SYNC_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_SYNC_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_XVC_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_XVC_SHIFT (28U)
/*! PROBE_IS_XVC - PROBE_IS (XVC)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_XVC(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_XVC_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER0_RULE3_PROBE_IS_XVC_MASK)
/*! @} */

/*! @name APB_BRIDGE_PER1_RULE0 - APB Bridge Peripheral 1 Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_RSTCTL_B_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_RSTCTL_B_SHIFT (0U)
/*! RSTCTL_B - RSTCTL_B
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_RSTCTL_B(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_RSTCTL_B_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_RSTCTL_B_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_CLKCTL_B_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_CLKCTL_B_SHIFT (4U)
/*! CLKCTL_B - CLKCTL_B
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_CLKCTL_B(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_CLKCTL_B_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_CLKCTL_B_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SYSCTL_B_MASK (0x300U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SYSCTL_B_SHIFT (8U)
/*! SYSCTL_B - SYSCTL_B
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SYSCTL_B(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SYSCTL_B_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SYSCTL_B_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_GPIO_INT_MASK (0x300000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_GPIO_INT_SHIFT (20U)
/*! GPIO_INT - GPIO_INT
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_GPIO_INT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_GPIO_INT_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_GPIO_INT_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_PERIPHERAL_MUXES_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_PERIPHERAL_MUXES_SHIFT (24U)
/*! PERIPHERAL_MUXES - Peripheral Muxes
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_PERIPHERAL_MUXES(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_PERIPHERAL_MUXES_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_PERIPHERAL_MUXES_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SDMA_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SDMA_SHIFT (28U)
/*! SDMA - Smart DMA (SDMA)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SDMA(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SDMA_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE0_SDMA_MASK)
/*! @} */

/*! @name APB_BRIDGE_PER1_RULE1 - APB Bridge Peripheral 1 Rule 1 Register */
/*! @{ */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B0_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B0_SHIFT (0U)
/*! CT32B0 - CT32B0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B0_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B0_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B1_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B1_SHIFT (4U)
/*! CT32B1 - CT32B1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B1_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B1_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B2_MASK (0x300U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B2_SHIFT (8U)
/*! CT32B2 - CT32B2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B2_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B2_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B3_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B3_SHIFT (12U)
/*! CT32B3 - CT32B3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B3_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B3_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B4_MASK (0x30000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B4_SHIFT (16U)
/*! CT32B4 - CT32B4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B4_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_CT32B4_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_MRT0_MASK (0x300000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_MRT0_SHIFT (20U)
/*! MRT0 - MRT0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_MRT0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_MRT0_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_MRT0_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_WWDT1_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_WWDT1_SHIFT (24U)
/*! WWDT1 - WWDT1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_WWDT1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_WWDT1_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_WWDT1_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_FREQMEASURE_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_FREQMEASURE_SHIFT (28U)
/*! FREQMEASURE - FREQMEASURE
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_FREQMEASURE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_FREQMEASURE_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE1_FREQMEASURE_MASK)
/*! @} */

/*! @name APB_BRIDGE_PER1_RULE2 - APB Bridge Peripheral 1 Rule 2 Register */
/*! @{ */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_RTC_WAKEUP_MASK (0x3U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_RTC_WAKEUP_SHIFT (0U)
/*! RTC_WAKEUP - RTC Wakeup
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_RTC_WAKEUP(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_RTC_WAKEUP_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_RTC_WAKEUP_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_DSI_HOST_CONTROLLER_MASK (0x30U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_DSI_HOST_CONTROLLER_SHIFT (4U)
/*! DSI_HOST_CONTROLLER - DSI Host Controller
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_DSI_HOST_CONTROLLER(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_DSI_HOST_CONTROLLER_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_DSI_HOST_CONTROLLER_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_FLEXIO_REGISTERS_MASK (0x300U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_FLEXIO_REGISTERS_SHIFT (8U)
/*! FLEXIO_REGISTERS - FLEXIO Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_FLEXIO_REGISTERS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_FLEXIO_REGISTERS_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_FLEXIO_REGISTERS_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_0_REGS_MASK (0x3000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_0_REGS_SHIFT (12U)
/*! CACHE_CONTROL_0_REGS - Cache Control 0 Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_0_REGS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_0_REGS_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_0_REGS_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_1_REGS_MASK (0x30000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_1_REGS_SHIFT (16U)
/*! CACHE_CONTROL_1_REGS - Cache Control 1 Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_1_REGS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_1_REGS_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_CACHE_CONTROL_1_REGS_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C0_MASK (0x3000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C0_SHIFT (24U)
/*! I3C0 - I3C0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C0_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C0_MASK)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C1_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C1_SHIFT (28U)
/*! I3C1 - I3C1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C1_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE2_I3C1_MASK)
/*! @} */

/*! @name APB_BRIDGE_PER1_RULE3 - APB Bridge Peripheral 1 Rule 3 Register */
/*! @{ */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE3_MRT1_MASK (0x30000000U)
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE3_MRT1_SHIFT (28U)
/*! MRT1 - MRT1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE3_MRT1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE3_MRT1_SHIFT)) & AHB_SECURE_CTRL_APB_BRIDGE_PER1_RULE3_MRT1_MASK)
/*! @} */

/*! @name AHB_PERIPH0_SLAVE_RULE0 - AHB Peripheral 0 Slave Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_HSGPIO_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_HSGPIO_SHIFT (0U)
/*! HSGPIO - HSGPIO
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_HSGPIO(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_HSGPIO_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_HSGPIO_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA0_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA0_SHIFT (4U)
/*! DMA0 - DMA 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA0_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA0_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA1_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA1_SHIFT (8U)
/*! DMA1 - DMA 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA1_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DMA1_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM0_MASK (0x3000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM0_SHIFT (12U)
/*! FLEXCOMM0 - FLEXCOMM 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM0_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM0_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM1_MASK (0x30000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM1_SHIFT (16U)
/*! FLEXCOMM1 - FLEXCOMM 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM1_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM1_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM2_MASK (0x300000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM2_SHIFT (20U)
/*! FLEXCOMM2 - FLEXCOMM 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM2_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM2_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM3_MASK (0x3000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM3_SHIFT (24U)
/*! FLEXCOMM3 - FLEXCOMM 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM3_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_FLEXCOMM3_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DEBUG_MAILBOX_MASK (0x30000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DEBUG_MAILBOX_SHIFT (28U)
/*! DEBUG_MAILBOX - DEBUG_MAILBOX
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DEBUG_MAILBOX(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DEBUG_MAILBOX_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH0_SLAVE_RULE0_DEBUG_MAILBOX_MASK)
/*! @} */

/*! @name AIPS_BRIDGE0_PER_RULE0 - AIPS Bridge Peripheral 0 Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU0_MASK (0x3U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU0_SHIFT (0U)
/*! MU0 - MU0 (M33 PORT)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU0_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU0_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU1_MASK (0x30U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU1_SHIFT (4U)
/*! MU1 - MU1 (DSP PORT)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU1_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_MU1_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_SEMAPHORE_MASK (0x300U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_SEMAPHORE_SHIFT (8U)
/*! SEMAPHORE - Semaphore
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_SEMAPHORE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_SEMAPHORE_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_SEMAPHORE_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_M33_PORT_MASK (0x3000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_M33_PORT_SHIFT (12U)
/*! OS_EVENT_TIMER_M33_PORT - OS_EVENT TIMER (M33 PORT)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_M33_PORT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_M33_PORT_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_M33_PORT_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_DSP_PORT_MASK (0x30000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_DSP_PORT_SHIFT (16U)
/*! OS_EVENT_TIMER_DSP_PORT - OS_EVENT TIMER (DSP PORT)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_DSP_PORT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_DSP_PORT_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_OS_EVENT_TIMER_DSP_PORT_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_ROM_MASK (0x300000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_ROM_SHIFT (20U)
/*! ROM - ROM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_ROM(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_ROM_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE0_PER_RULE0_ROM_MASK)
/*! @} */

/*! @name AHB_PERIPH1_SLAVE_RULE0 - AHB Peripheral 1 Slave Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_CRC_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_CRC_SHIFT (0U)
/*! CRC - CRC
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_CRC(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_CRC_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_CRC_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_DMIC0_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_DMIC0_SHIFT (4U)
/*! DMIC0 - DMIC0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_DMIC0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_DMIC0_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_DMIC0_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM4_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM4_SHIFT (8U)
/*! FLEXCOMM4 - FLEXCOMM 4
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM4_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM4_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM5_MASK (0x3000U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM5_SHIFT (12U)
/*! FLEXCOMM5 - FLEXCOMM 5
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM5_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM5_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM6_MASK (0x30000U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM6_SHIFT (16U)
/*! FLEXCOMM6 - FLEXCOMM 6
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM6_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM6_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM7_MASK (0x300000U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM7_SHIFT (20U)
/*! FLEXCOMM7 - FLEXCOMM 7
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM7_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM7_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM14_MASK (0x3000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM14_SHIFT (24U)
/*! FLEXCOMM14 - FLEXCOMM 14
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM14(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM14_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM14_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM15_MASK (0x30000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM15_SHIFT (28U)
/*! FLEXCOMM15 - FLEXCOMM 15
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM15(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM15_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE0_FLEXCOMM15_MASK)
/*! @} */

/*! @name AHB_PERIPH1_SLAVE_RULE1 - AHB Peripheral 1 Slave Rule 1 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE1_FLEXCOMM16_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE1_FLEXCOMM16_SHIFT (0U)
/*! FLEXCOMM16 - FLEXCOMM 16
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE1_FLEXCOMM16(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE1_FLEXCOMM16_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH1_SLAVE_RULE1_FLEXCOMM16_MASK)
/*! @} */

/*! @name AIPS_BRIDGE1_PER_RULE0 - AIPS Bridge Peripheral 1 Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_0_MASK (0x3U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_0_SHIFT (0U)
/*! OTP_CONTROLLER_0 - OTP Controller 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_0_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_0_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_1_MASK (0x30U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_1_SHIFT (4U)
/*! OTP_CONTROLLER_1 - OTP Controller 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_1_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_1_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_2_MASK (0x300U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_2_SHIFT (8U)
/*! OTP_CONTROLLER_2 - OTP Controller 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_2_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_2_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_3_MASK (0x3000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_3_SHIFT (12U)
/*! OTP_CONTROLLER_3 - OTP Controller 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_3_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_OTP_CONTROLLER_3_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_FLEXSPI0_REGISTERS_MASK (0x30000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_FLEXSPI0_REGISTERS_SHIFT (16U)
/*! FLEXSPI0_REGISTERS - FLEXSPI0 Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_FLEXSPI0_REGISTERS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_FLEXSPI0_REGISTERS_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_FLEXSPI0_REGISTERS_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_PMC_PMU_CONTROL_MASK (0x300000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_PMC_PMU_CONTROL_SHIFT (20U)
/*! PMC_PMU_CONTROL - PMC (PMU CONTROL)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_PMC_PMU_CONTROL(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_PMC_PMU_CONTROL_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_PMC_PMU_CONTROL_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO0_REGISTERS_MASK (0x3000000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO0_REGISTERS_SHIFT (24U)
/*! SDIO0_REGISTERS - SDIO 0 Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO0_REGISTERS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO0_REGISTERS_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO0_REGISTERS_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO1_REGISTERS_MASK (0x30000000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO1_REGISTERS_SHIFT (28U)
/*! SDIO1_REGISTERS - SDIO 1 Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO1_REGISTERS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO1_REGISTERS_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE0_SDIO1_REGISTERS_MASK)
/*! @} */

/*! @name AIPS_BRIDGE1_PER_RULE1 - AIPS Bridge Peripheral 1 Rule 1 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_RNG_MASK (0x3U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_RNG_SHIFT (0U)
/*! RNG - RNG (Random Number Generator)
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_RNG(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_RNG_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_RNG_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ACMP0_MASK (0x30U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ACMP0_SHIFT (4U)
/*! ACMP0 - ACMP 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ACMP0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ACMP0_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ACMP0_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ADC0_MASK (0x300U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ADC0_SHIFT (8U)
/*! ADC0 - ADC 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ADC0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ADC0_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_ADC0_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_HS_USB_PHY_MASK (0x3000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_HS_USB_PHY_SHIFT (12U)
/*! HS_USB_PHY - HS USB PHY
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_HS_USB_PHY(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_HS_USB_PHY_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_HS_USB_PHY_MASK)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_FLEXSPI1_REGISTERS_MASK (0x30000U)
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_FLEXSPI1_REGISTERS_SHIFT (16U)
/*! FLEXSPI1_REGISTERS - FLEXSPI1 Registers
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_FLEXSPI1_REGISTERS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_FLEXSPI1_REGISTERS_SHIFT)) & AHB_SECURE_CTRL_AIPS_BRIDGE1_PER_RULE1_FLEXSPI1_REGISTERS_MASK)
/*! @} */

/*! @name AHB_PERIPH2_SLAVE_RULE0 - AHB Peripheral 2 Slave Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_RAM_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_RAM_SHIFT (0U)
/*! USB_HS_RAM - USB HS RAM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_RAM(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_RAM_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_RAM_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_DEV_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_DEV_SHIFT (4U)
/*! USB_HS_DEV - USB HS DEV
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_DEV(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_DEV_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_DEV_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_HOST_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_HOST_SHIFT (8U)
/*! USB_HS_HOST - USB HS HOST
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_HOST(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_HOST_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_USB_HS_HOST_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_SCT_MASK (0x3000U)
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_SCT_SHIFT (12U)
/*! SCT - SCT
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_SCT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_SCT_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH2_SLAVE_RULE0_SCT_MASK)
/*! @} */

/*! @name AHB_SECURE_CTRL_PERIPH_RULE0 - AHB Secure Control Peripheral Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE0_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE0_SHIFT (0U)
/*! RULE0 - Rule 0
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE0_SHIFT)) & AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE0_MASK)
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE1_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE1_SHIFT (4U)
/*! RULE1 - Rule 1
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE1_SHIFT)) & AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE1_MASK)
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE2_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE2_SHIFT (8U)
/*! RULE2 - Rule 2
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE2_SHIFT)) & AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE2_MASK)
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE3_MASK (0x3000U)
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE3_SHIFT (12U)
/*! RULE3 - Rule 3
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE3_SHIFT)) & AHB_SECURE_CTRL_AHB_SECURE_CTRL_PERIPH_RULE0_RULE3_MASK)
/*! @} */

/*! @name AHB_PERIPH3_SLAVE_RULE0 - AHB Peripheral 3 Slave Rule 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_POWERQUAD_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_POWERQUAD_SHIFT (0U)
/*! POWERQUAD - POWERQUAD
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_POWERQUAD(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_POWERQUAD_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_POWERQUAD_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_SHIFT (4U)
/*! CASPER - CASPER
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_RAM_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_RAM_SHIFT (8U)
/*! CASPER_RAM - CASPER RAM
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_RAM(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_RAM_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_CASPER_RAM_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_SECURE_GPIO_MASK (0x3000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_SECURE_GPIO_SHIFT (12U)
/*! SECURE_GPIO - Secure GPIO
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_SECURE_GPIO(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_SECURE_GPIO_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_SECURE_GPIO_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_HASH_MASK (0x30000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_HASH_SHIFT (16U)
/*! HASH - HASH
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_HASH(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_HASH_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_HASH_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM8_MASK (0x300000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM8_SHIFT (20U)
/*! FLEXCOMM8 - FLEXCOMM 8
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM8(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM8_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM8_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM9_MASK (0x3000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM9_SHIFT (24U)
/*! FLEXCOMM9 - FLEXCOMM 9
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM9(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM9_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM9_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM10_MASK (0x30000000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM10_SHIFT (28U)
/*! FLEXCOMM10 - FLEXCOMM 10
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM10(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM10_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE0_FLEXCOMM10_MASK)
/*! @} */

/*! @name AHB_PERIPH3_SLAVE_RULE1 - AHB Peripheral 3 Slave Rule 1 Register */
/*! @{ */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM11_MASK (0x3U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM11_SHIFT (0U)
/*! FLEXCOMM11 - FLEXCOMM 11
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM11(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM11_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM11_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM12_MASK (0x30U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM12_SHIFT (4U)
/*! FLEXCOMM12 - FLEXCOMM 12
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM12(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM12_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM12_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM13_MASK (0x300U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM13_SHIFT (8U)
/*! FLEXCOMM13 - FLEXCOMM 13
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM13(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM13_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_FLEXCOMM13_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_LCDIF_MASK (0x3000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_LCDIF_SHIFT (12U)
/*! LCDIF - LCDIF
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_LCDIF(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_LCDIF_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_LCDIF_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_GPU_MASK (0x30000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_GPU_SHIFT (16U)
/*! GPU - GPU
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_GPU(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_GPU_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_GPU_MASK)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_AXI_SWITCH_MASK (0x300000U)
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_AXI_SWITCH_SHIFT (20U)
/*! AXI_SWITCH - AXI Switch
 *  0b00..Non-secure and non-privilege user access allowed
 *  0b01..Non-secure and privilege access allowed
 *  0b10..Secure and non-privilege user access allowed
 *  0b11..Secure and privilege user access allowed
 */
#define AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_AXI_SWITCH(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_AXI_SWITCH_SHIFT)) & AHB_SECURE_CTRL_AHB_PERIPH3_SLAVE_RULE1_AXI_SWITCH_MASK)
/*! @} */

/*! @name SEC_VIO_ADDR - Security Violation Address(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_INFO_WRITE_MASK (0xFFFFFFFFU)
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_INFO_WRITE_SHIFT (0U)
/*! SEC_VIO_INFO_WRITE - Security violation access read/write indicator
 */
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_INFO_WRITE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_INFO_WRITE_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_ADDR_SEC_VIO_INFO_WRITE_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_VIO_ADDR */
#define AHB_SECURE_CTRL_SEC_VIO_ADDR_COUNT       (18U)

/*! @name SEC_VIO_MISC_INFO - Security Violation Miscellaneous Information at Address(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT (0U)
/*! SEC_VIO_INFO_WRITE - Security violation access read/write indicator
 *  0b0..Read access
 *  0b1..Write access
 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_WRITE_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT (1U)
/*! SEC_VIO_INFO_DATA_ACCESS - Security Violation Info Data Access
 *  0b0..Code
 *  0b1..Data
 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_DATA_ACCESS_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK (0xF0U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT (4U)
/*! SEC_VIO_INFO_MASTER_SEC_LEVEL - Security Violation Info Master Security Level
 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SEC_LEVEL_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK (0xF00U)
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT (8U)
/*! SEC_VIO_INFO_MASTER - Security violation master number
 *  0b0000..M33 Code
 *  0b0001..M33 System
 *  0b0010..Powerquad
 *  0b0011..DSP
 *  0b0100..DMA0
 *  0b0101..DMA1
 *  0b0110..SDMA Instruction
 *  0b0111..SDMA Data
 *  0b1000..SDIO0
 *  0b1001..SDIO1
 *  0b1010..HASH
 *  0b1011..GPU
 *  0b1100..Reserved
 *  0b1101..Reserved
 *  0b1110..Reserved
 *  0b1111..Reserved
 */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_SEC_VIO_INFO_MASTER_MASK)
/*! @} */

/* The count of AHB_SECURE_CTRL_SEC_VIO_MISC_INFO */
#define AHB_SECURE_CTRL_SEC_VIO_MISC_INFO_COUNT  (18U)

/*! @name SEC_VIO_INFO_VALID - Security Violation Info Validity for Address(n) Register */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT (0U)
/*! VIO_INFO_VALID0 - Violation information valid flag for AHB port 0
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID0_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT (1U)
/*! VIO_INFO_VALID1 - Violation information valid flag for AHB port 1
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID1_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT (2U)
/*! VIO_INFO_VALID2 - Violation information valid flag for AHB port 2
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID2_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT (3U)
/*! VIO_INFO_VALID3 - Violation information valid flag for AHB port 3
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID3_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT (4U)
/*! VIO_INFO_VALID4 - Violation information valid flag for AHB port 4
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID4_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT (5U)
/*! VIO_INFO_VALID5 - Violation information valid flag for AHB port 5
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID5_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT (6U)
/*! VIO_INFO_VALID6 - Violation information valid flag for AHB port 6
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID6_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT (7U)
/*! VIO_INFO_VALID7 - Violation information valid flag for AHB port 7
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID7_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT (8U)
/*! VIO_INFO_VALID8 - Violation information valid flag for AHB port 8
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID8_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT (9U)
/*! VIO_INFO_VALID9 - Violation information valid flag for AHB port 9
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID9_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT (10U)
/*! VIO_INFO_VALID10 - Violation information valid flag for AHB port 10
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID10_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT (11U)
/*! VIO_INFO_VALID11 - Violation information valid flag for AHB port 11
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID11_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_SHIFT (12U)
/*! VIO_INFO_VALID12 - Violation information valid flag for AHB port 12
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID12_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_SHIFT (13U)
/*! VIO_INFO_VALID13 - Violation information valid flag for AHB port 13
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID13_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_SHIFT (14U)
/*! VIO_INFO_VALID14 - Violation information valid flag for AHB port 14
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID14_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_SHIFT (15U)
/*! VIO_INFO_VALID15 - Violation information valid flag for AHB port 15
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID15_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_SHIFT (16U)
/*! VIO_INFO_VALID16 - Violation information valid flag for AHB port 16
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID16_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_SHIFT (17U)
/*! VIO_INFO_VALID17 - Violation information valid flag for AHB port 17
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID17_MASK)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_SHIFT (18U)
/*! VIO_INFO_VALID18 - Violation information valid flag for AHB port 18
 *  0b0..Not valid
 *  0b1..Valid
 */
#define AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_SHIFT)) & AHB_SECURE_CTRL_SEC_VIO_INFO_VALID_VIO_INFO_VALID18_MASK)
/*! @} */

/*! @name SEC_GPIO_MASK0 - GPIO Mask for Port 0 Register */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO0_PIN0_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN0_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO0_PIN1_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN1_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO0_PIN2_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN2_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO0_PIN3_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN3_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO0_PIN4_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN4_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO0_PIN5_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN5_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO0_PIN6_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN6_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO0_PIN7_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN7_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO0_PIN8_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN8_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO0_PIN9_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN9_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO0_PIN10_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN10_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO0_PIN11_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN11_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO0_PIN12_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN12_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO0_PIN13_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN13_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO0_PIN14_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN14_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO0_PIN15_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN15_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO0_PIN16_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN16_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO0_PIN17_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN17_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO0_PIN18_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN18_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO0_PIN19_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN19_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO0_PIN20_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN20_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO0_PIN21_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN21_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO0_PIN22_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN22_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO0_PIN23_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN23_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO0_PIN24_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN24_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO0_PIN25_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN25_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO0_PIN26_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN26_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO0_PIN27_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN27_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO0_PIN28_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN28_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO0_PIN29_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN29_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO0_PIN30_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN30_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO0_PIN31_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK0_PIO0_PIN31_SEC_MASK_MASK)
/*! @} */

/*! @name SEC_GPIO_MASK1 - GPIO Mask for Port 1 Register */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO1_PIN0_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN0_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO1_PIN1_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN1_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO1_PIN2_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN2_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO1_PIN3_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN3_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO1_PIN4_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN4_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO1_PIN5_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN5_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO1_PIN6_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN6_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO1_PIN7_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN7_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO1_PIN8_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN8_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO1_PIN9_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN9_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO1_PIN10_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN10_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO1_PIN11_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN11_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO1_PIN12_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN12_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO1_PIN13_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN13_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO1_PIN14_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN14_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO1_PIN15_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN15_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO1_PIN16_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN16_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO1_PIN17_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN17_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO1_PIN18_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN18_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO1_PIN19_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN19_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO1_PIN20_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN20_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO1_PIN21_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN21_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO1_PIN22_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN22_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO1_PIN23_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN23_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO1_PIN24_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN24_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO1_PIN25_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN25_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO1_PIN26_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN26_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO1_PIN27_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN27_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO1_PIN28_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN28_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO1_PIN29_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN29_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO1_PIN30_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN30_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO1_PIN31_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK1_PIO1_PIN31_SEC_MASK_MASK)
/*! @} */

/*! @name SEC_GPIO_MASK2 - GPIO Mask for Port 2 Register */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN0_SEC_MASK_MASK (0x1U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN0_SEC_MASK_SHIFT (0U)
/*! PIO2_PIN0_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN0_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN0_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN0_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN1_SEC_MASK_MASK (0x2U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN1_SEC_MASK_SHIFT (1U)
/*! PIO2_PIN1_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN1_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN1_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN1_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN2_SEC_MASK_MASK (0x4U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN2_SEC_MASK_SHIFT (2U)
/*! PIO2_PIN2_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN2_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN2_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN2_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN3_SEC_MASK_MASK (0x8U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN3_SEC_MASK_SHIFT (3U)
/*! PIO2_PIN3_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN3_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN3_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN3_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN4_SEC_MASK_MASK (0x10U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN4_SEC_MASK_SHIFT (4U)
/*! PIO2_PIN4_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN4_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN4_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN4_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN5_SEC_MASK_MASK (0x20U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN5_SEC_MASK_SHIFT (5U)
/*! PIO2_PIN5_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN5_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN5_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN5_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN6_SEC_MASK_MASK (0x40U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN6_SEC_MASK_SHIFT (6U)
/*! PIO2_PIN6_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN6_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN6_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN6_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN7_SEC_MASK_MASK (0x80U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN7_SEC_MASK_SHIFT (7U)
/*! PIO2_PIN7_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN7_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN7_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN7_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN8_SEC_MASK_MASK (0x100U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN8_SEC_MASK_SHIFT (8U)
/*! PIO2_PIN8_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN8_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN8_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN8_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN9_SEC_MASK_MASK (0x200U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN9_SEC_MASK_SHIFT (9U)
/*! PIO2_PIN9_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN9_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN9_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN9_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN10_SEC_MASK_MASK (0x400U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN10_SEC_MASK_SHIFT (10U)
/*! PIO2_PIN10_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN10_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN10_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN10_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN11_SEC_MASK_MASK (0x800U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN11_SEC_MASK_SHIFT (11U)
/*! PIO2_PIN11_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN11_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN11_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN11_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN12_SEC_MASK_MASK (0x1000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN12_SEC_MASK_SHIFT (12U)
/*! PIO2_PIN12_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN12_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN12_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN12_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN13_SEC_MASK_MASK (0x2000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN13_SEC_MASK_SHIFT (13U)
/*! PIO2_PIN13_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN13_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN13_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN13_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN14_SEC_MASK_MASK (0x4000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN14_SEC_MASK_SHIFT (14U)
/*! PIO2_PIN14_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN14_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN14_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN14_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN15_SEC_MASK_MASK (0x8000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN15_SEC_MASK_SHIFT (15U)
/*! PIO2_PIN15_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN15_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN15_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN15_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN16_SEC_MASK_MASK (0x10000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN16_SEC_MASK_SHIFT (16U)
/*! PIO2_PIN16_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN16_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN16_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN16_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN17_SEC_MASK_MASK (0x20000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN17_SEC_MASK_SHIFT (17U)
/*! PIO2_PIN17_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN17_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN17_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN17_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN18_SEC_MASK_MASK (0x40000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN18_SEC_MASK_SHIFT (18U)
/*! PIO2_PIN18_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN18_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN18_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN18_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN19_SEC_MASK_MASK (0x80000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN19_SEC_MASK_SHIFT (19U)
/*! PIO2_PIN19_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN19_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN19_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN19_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN20_SEC_MASK_MASK (0x100000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN20_SEC_MASK_SHIFT (20U)
/*! PIO2_PIN20_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN20_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN20_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN20_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN21_SEC_MASK_MASK (0x200000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN21_SEC_MASK_SHIFT (21U)
/*! PIO2_PIN21_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN21_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN21_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN21_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN22_SEC_MASK_MASK (0x400000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN22_SEC_MASK_SHIFT (22U)
/*! PIO2_PIN22_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN22_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN22_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN22_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN23_SEC_MASK_MASK (0x800000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN23_SEC_MASK_SHIFT (23U)
/*! PIO2_PIN23_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN23_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN23_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN23_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN24_SEC_MASK_MASK (0x1000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN24_SEC_MASK_SHIFT (24U)
/*! PIO2_PIN24_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN24_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN24_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN24_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN25_SEC_MASK_MASK (0x2000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN25_SEC_MASK_SHIFT (25U)
/*! PIO2_PIN25_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN25_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN25_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN25_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN26_SEC_MASK_MASK (0x4000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN26_SEC_MASK_SHIFT (26U)
/*! PIO2_PIN26_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN26_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN26_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN26_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN27_SEC_MASK_MASK (0x8000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN27_SEC_MASK_SHIFT (27U)
/*! PIO2_PIN27_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN27_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN27_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN27_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN28_SEC_MASK_MASK (0x10000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN28_SEC_MASK_SHIFT (28U)
/*! PIO2_PIN28_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN28_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN28_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN28_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN29_SEC_MASK_MASK (0x20000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN29_SEC_MASK_SHIFT (29U)
/*! PIO2_PIN29_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN29_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN29_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN29_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN30_SEC_MASK_MASK (0x40000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN30_SEC_MASK_SHIFT (30U)
/*! PIO2_PIN30_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN30_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN30_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN30_SEC_MASK_MASK)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN31_SEC_MASK_MASK (0x80000000U)
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN31_SEC_MASK_SHIFT (31U)
/*! PIO2_PIN31_SEC_MASK - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN31_SEC_MASK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN31_SEC_MASK_SHIFT)) & AHB_SECURE_CTRL_SEC_GPIO_MASK2_PIO2_PIN31_SEC_MASK_MASK)
/*! @} */

/*! @name DSP_INT_MASK0 - Secure Interrupt Mask for DSP Register */
/*! @{ */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT0_MASK (0x20U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT0_SHIFT (5U)
/*! PMUX_OUT0 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT0_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT0_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT1_MASK (0x40U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT1_SHIFT (6U)
/*! PMUX_OUT1 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT1_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT1_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT2_MASK (0x80U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT2_SHIFT (7U)
/*! PMUX_OUT2 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT2(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT2_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT2_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT3_MASK (0x100U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT3_SHIFT (8U)
/*! PMUX_OUT3 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT3(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT3_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT3_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT4_MASK (0x200U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT4_SHIFT (9U)
/*! PMUX_OUT4 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT4(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT4_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT4_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT5_MASK (0x400U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT5_SHIFT (10U)
/*! PMUX_OUT5 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT5(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT5_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT5_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT6_MASK (0x800U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT6_SHIFT (11U)
/*! PMUX_OUT6 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT6(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT6_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT6_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT7_MASK (0x1000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT7_SHIFT (12U)
/*! PMUX_OUT7 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT7(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT7_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT7_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT8_MASK (0x2000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT8_SHIFT (13U)
/*! PMUX_OUT8 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT8(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT8_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT8_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT9_MASK (0x4000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT9_SHIFT (14U)
/*! PMUX_OUT9 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT9(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT9_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT9_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT10_MASK (0x8000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT10_SHIFT (15U)
/*! PMUX_OUT10 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT10(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT10_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT10_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT11_MASK (0x10000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT11_SHIFT (16U)
/*! PMUX_OUT11 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT11(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT11_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT11_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT12_MASK (0x20000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT12_SHIFT (17U)
/*! PMUX_OUT12 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT12(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT12_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT12_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT13_MASK (0x40000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT13_SHIFT (18U)
/*! PMUX_OUT13 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT13(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT13_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT13_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT14_MASK (0x80000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT14_SHIFT (19U)
/*! PMUX_OUT14 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT14(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT14_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT14_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT15_MASK (0x100000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT15_SHIFT (20U)
/*! PMUX_OUT15 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT15(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT15_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT15_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT16_MASK (0x200000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT16_SHIFT (21U)
/*! PMUX_OUT16 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT16(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT16_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT16_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT17_MASK (0x400000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT17_SHIFT (22U)
/*! PMUX_OUT17 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT17(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT17_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT17_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT18_MASK (0x800000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT18_SHIFT (23U)
/*! PMUX_OUT18 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT18(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT18_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT18_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT19_MASK (0x1000000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT19_SHIFT (24U)
/*! PMUX_OUT19 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT19(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT19_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT19_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT20_MASK (0x2000000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT20_SHIFT (25U)
/*! PMUX_OUT20 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT20(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT20_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT20_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT21_MASK (0x4000000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT21_SHIFT (26U)
/*! PMUX_OUT21 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT21(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT21_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT21_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT22_MASK (0x8000000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT22_SHIFT (27U)
/*! PMUX_OUT22 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT22(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT22_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT22_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT23_MASK (0x10000000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT23_SHIFT (28U)
/*! PMUX_OUT23 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT23(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT23_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT23_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT24_MASK (0x20000000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT24_SHIFT (29U)
/*! PMUX_OUT24 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT24(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT24_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT24_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT25_MASK (0x40000000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT25_SHIFT (30U)
/*! PMUX_OUT25 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT25(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT25_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT25_MASK)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT26_MASK (0x80000000U)
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT26_SHIFT (31U)
/*! PMUX_OUT26 - Mask bit
 *  0b0..Masked
 *  0b1..Not masked
 */
#define AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT26(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT26_SHIFT)) & AHB_SECURE_CTRL_DSP_INT_MASK0_PMUX_OUT26_MASK)
/*! @} */

/*! @name SEC_MASK_LOCK - Secure Mask Lock Register */
/*! @{ */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK_SHIFT (0U)
/*! SEC_GPIO_MASK0_LOCK - Secure GPIO _MASK0 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK0 cannot be written
 *  0b10..SEC_GPIO_MASK0 can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK0_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK_MASK (0xCU)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK_SHIFT (2U)
/*! SEC_GPIO_MASK1_LOCK - Secure GPIO _MASK1 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK1 cannot be written
 *  0b10..SEC_GPIO_MASK1 can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK1_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK2_LOCK_MASK (0x30U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK2_LOCK_SHIFT (4U)
/*! SEC_GPIO_MASK2_LOCK - Secure GPIO _MASK2 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK2 cannot be written
 *  0b10..SEC_GPIO_MASK2 can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK2_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK2_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK2_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK3_LOCK_MASK (0xC0U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK3_LOCK_SHIFT (6U)
/*! SEC_GPIO_MASK3_LOCK - Secure GPIO _MASK3 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK3 cannot be written
 *  0b10..SEC_GPIO_MASK3 can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK3_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK3_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK3_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK4_LOCK_MASK (0x300U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK4_LOCK_SHIFT (8U)
/*! SEC_GPIO_MASK4_LOCK - SEC_GPIO_MASK4 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK4_LOCK cannot be written
 *  0b10..SEC_GPIO_MASK4_LOCK can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK4_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK4_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK4_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK5_LOCK_MASK (0xC00U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK5_LOCK_SHIFT (10U)
/*! SEC_GPIO_MASK5_LOCK - SEC_GPIO_MASK5 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK5 cannot be written
 *  0b10..SEC_GPIO_MASK5 can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK5_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK5_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK5_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK6_LOCK_MASK (0x3000U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK6_LOCK_SHIFT (12U)
/*! SEC_GPIO_MASK6_LOCK - SEC_GPIO_MASK6 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK6 cannot be written
 *  0b10..SEC_GPIO_MASK6 can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK6_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK6_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK6_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK7_LOCK_MASK (0xC000U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK7_LOCK_SHIFT (14U)
/*! SEC_GPIO_MASK7_LOCK - SEC_GPIO_MASK7 Lock
 *  0b00..Reserved
 *  0b01..SEC_GPIO_MASK7 cannot be written
 *  0b10..SEC_GPIO_MASK7 can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK7_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK7_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_GPIO_MASK7_LOCK_MASK)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_DSP_INT_MASK_LOCK_MASK (0x30000U)
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_DSP_INT_MASK_LOCK_SHIFT (16U)
/*! SEC_DSP_INT_MASK_LOCK - SEC_DSP_INT_MASK Lock
 *  0b00..Reserved
 *  0b01..SEC_DSP_INT_MASK cannot be written
 *  0b10..SEC_DSP_INT_MASK can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_DSP_INT_MASK_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_DSP_INT_MASK_LOCK_SHIFT)) & AHB_SECURE_CTRL_SEC_MASK_LOCK_SEC_DSP_INT_MASK_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_LEVEL - Master Secure Level Register */
/*! @{ */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ_MASK (0x30U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ_SHIFT (4U)
/*! PQ - Power Quad
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ(x)   (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_PQ_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DSP_MASK (0xC0U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DSP_SHIFT (6U)
/*! DSP - DSP
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DSP(x)  (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DSP_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DSP_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0_MASK (0x300U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0_SHIFT (8U)
/*! DMA0 - DMA 0
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA0_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1_MASK (0xC00U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1_SHIFT (10U)
/*! DMA1 - DMA 1
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_DMA1_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_I_MASK (0x3000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_I_SHIFT (12U)
/*! SDMA_I - Smart DMA (SDMA) Instruction
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_I(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_I_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_I_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_D_MASK (0xC000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_D_SHIFT (14U)
/*! SDMA_D - Smart DMA (SDMA) Data
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_D(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_D_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDMA_D_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO0_MASK (0x30000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO0_SHIFT (16U)
/*! SDIO0 - SDIO 0
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO0_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO0_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO1_MASK (0xC0000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO1_SHIFT (18U)
/*! SDIO1 - SDIO 1
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO1_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_SDIO1_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GPU_MASK (0x300000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GPU_SHIFT (20U)
/*! GPU - GPU
 *  0b00..Non-secure and non-privileged Master
 *  0b01..Non-secure and privileged Master
 *  0b10..Secure and non-privileged Master
 *  0b11..Secure and privileged Master
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GPU(x)  (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GPU_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_GPU_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_LOCK - Master Security Level Lock
 *  0b00..Reserved
 *  0b01..Lock writing to this register, including these (MASTER_SEC_LEVEL_LOCK) bits
 *  0b10..This register can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_LEVEL_MASTER_SEC_LEVEL_LOCK_MASK)
/*! @} */

/*! @name MASTER_SEC_ANTI_POL_REG - Master Secure Level Register */
/*! @{ */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ_MASK (0x30U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ_SHIFT (4U)
/*! PQ - Power Quad
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_PQ_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DSP_MASK (0xC0U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DSP_SHIFT (6U)
/*! DSP - DSP
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DSP(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DSP_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DSP_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA0_MASK (0x300U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA0_SHIFT (8U)
/*! DMA0 - DMA 0
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA0_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA0_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA1_MASK (0xC00U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA1_SHIFT (10U)
/*! DMA1 - DMA 1
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA1_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_DMA1_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_I_MASK (0x3000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_I_SHIFT (12U)
/*! SDMA_I - Smart DMA (SDMA) Instruction
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_I(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_I_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_I_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_D_MASK (0xC000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_D_SHIFT (14U)
/*! SDMA_D - Smart DMA (SDMA) Data
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_D(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_D_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDMA_D_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO0_MASK (0x30000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO0_SHIFT (16U)
/*! SDIO0 - SDIO 0
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO0(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO0_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO0_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO1_MASK (0xC0000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO1_SHIFT (18U)
/*! SDIO1 - SDIO 1
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO1(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO1_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_SDIO1_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_GPU_MASK (0x300000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_GPU_SHIFT (20U)
/*! GPU - GPU
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_GPU(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_GPU_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_GPU_MASK)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT (30U)
/*! MASTER_SEC_LEVEL_ANTIPOL_LOCK - Master Security Level Antipole Lock
 *  0b00..Reserved
 *  0b01..Lock writing to this register, including these (MASTER_SEC_LEVEL_ANTIPOL_LOCK) bits
 *  0b10..This register can be written
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_SHIFT)) & AHB_SECURE_CTRL_MASTER_SEC_ANTI_POL_REG_MASTER_SEC_LEVEL_ANTIPOL_LOCK_MASK)
/*! @} */

/*! @name CM33_LOCK_REG - Miscellaneous CPU0 Control Signals Register */
/*! @{ */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR_MASK (0x3U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR_SHIFT (0U)
/*! LOCK_NS_VTOR - Lock Non-Secure VTOR
 *  0b00..Reserved
 *  0b01..Locks Non-Secure VTOR
 *  0b10..Non-Secure VTOR can be used
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_VTOR_MASK)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU_MASK (0xCU)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU_SHIFT (2U)
/*! LOCK_NS_MPU - Lock Non-Secure MPU
 *  0b00..Reserved
 *  0b01..Locks Non-Secure MPU
 *  0b10..Non-Secure MPU can be used
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_NS_MPU_MASK)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTOR_MASK (0x30U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTOR_SHIFT (4U)
/*! LOCK_S_VTOR - Lock Secure VTOR
 *  0b00..Reserved
 *  0b01..Locks Secure VTOR
 *  0b10..Secure VTOR can be used
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTOR(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTOR_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_VTOR_MASK)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU_MASK (0xC0U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU_SHIFT (6U)
/*! LOCK_S_MPU - Lock Secure MPU
 *  0b00..Reserved
 *  0b01..Locks Secure MPU
 *  0b10..Secure MPU can be used
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_S_MPU_MASK)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU_MASK (0x300U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU_SHIFT (8U)
/*! LOCK_SAU - Lock SAU
 *  0b00..Reserved
 *  0b01..SAU is locked
 *  0b10..SAU can be used
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_LOCK_SAU_MASK)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_CM33_LOCK_REG_LOCK_MASK (0xC0000000U)
#define AHB_SECURE_CTRL_CM33_LOCK_REG_CM33_LOCK_REG_LOCK_SHIFT (30U)
/*! CM33_LOCK_REG_LOCK - Lock CM33 Lock Register
 *  0b00..Reserved
 *  0b01..Does not allow writing to this register
 *  0b10..Allows writing to this register
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_CM33_LOCK_REG_CM33_LOCK_REG_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_CM33_LOCK_REG_CM33_LOCK_REG_LOCK_SHIFT)) & AHB_SECURE_CTRL_CM33_LOCK_REG_CM33_LOCK_REG_LOCK_MASK)
/*! @} */

/*! @name MISC_CTRL_DP_REG - Secure Control Duplicate Register */
/*! @{ */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT (0U)
/*! WRITE_LOCK - Write Lock
 *  0b00..Reserved
 *  0b01..Writes to this register and to the Memory and Peripheral RULE registers are not allowed
 *  0b10..Writes to this register and to the Memory and Peripheral RULE registers are allowed
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_WRITE_LOCK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
/*! ENABLE_SECURE_CHECKING - Enable Secure Checking
 *  0b00..Reserved
 *  0b01..Enabled (restrictive mode)
 *  0b10..Disabled
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_SECURE_CHECKING_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
/*! ENABLE_S_PRIV_CHECK - Enable Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enabled (restrictive mode)
 *  0b10..Disabled
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_S_PRIV_CHECK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
/*! ENABLE_NS_PRIV_CHECK - Enable Non-Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enabled (restrictive mode)
 *  0b10..Disabled
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_ENABLE_NS_PRIV_CHECK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
/*! DISABLE_VIOLATION_ABORT - Disable Violation Abort
 *  0b00..Reserved
 *  0b01..The violation detected by the secure checker will not cause an abort, but a secure_violation_irq
 *        (interrupt request) will still be asserted and serviced by ISR.
 *  0b10..The violation detected by the secure checker will cause an abort.
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_VIOLATION_ABORT_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_MASK (0xC00U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_SHIFT (10U)
/*! DISABLE_SIMPLE_MASTER_STRICT_MODE - Disable Simple Master Strict Mode
 *  0b00..Reserved
 *  0b01..Can access memories and peripherals at the same level or below that level
 *  0b10..Can access memories and peripherals at same level only
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE_MASK (0x3000U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE_SHIFT (12U)
/*! DISABLE_SMART_MASTER_STRICT_MODE - Disable Smart Master Strict Mode
 *  0b00..Reserved
 *  0b01..Can access memories and peripherals at the same level or below that level
 *  0b10..Can access memories and peripherals at same level only
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_DISABLE_SMART_MASTER_STRICT_MODE_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK (0xC000U)
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT (14U)
/*! IDAU_ALL_NS - IDAU All Non-Secure
 *  0b00..Reserved
 *  0b01..IDAU is disabled, which means that all memories are attributed as non-secure memory.
 *  0b10..IDAU is enabled (restrictive mode)
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_DP_REG_IDAU_ALL_NS_MASK)
/*! @} */

/*! @name MISC_CTRL_REG - Secure Control Register */
/*! @{ */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_MASK (0x3U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_SHIFT (0U)
/*! WRITE_LOCK - Write Lock
 *  0b00..Reserved
 *  0b01..Writes to this register and to the Memory and Peripheral RULE registers are not allowed
 *  0b10..Writes to this register and to the Memory and Peripheral RULE registers are allowed
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_WRITE_LOCK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK (0xCU)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT (2U)
/*! ENABLE_SECURE_CHECKING - Enable Secure Checking
 *  0b00..Reserved
 *  0b01..Enabled (restrictive mode)
 *  0b10..Disabled
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_SECURE_CHECKING_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK (0x30U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT (4U)
/*! ENABLE_S_PRIV_CHECK - Enable Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enabled (restrictive mode)
 *  0b10..Disabled
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK (0xC0U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT (6U)
/*! ENABLE_NS_PRIV_CHECK - Enable Non-Secure Privilege Checking
 *  0b00..Reserved
 *  0b01..Enabled (restrictive mode)
 *  0b10..Disabled
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK (0x300U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT (8U)
/*! DISABLE_VIOLATION_ABORT - Disable Violation Abort
 *  0b00..Reserved
 *  0b01..The violation detected by the secure checker will not cause an abort, but a secure_violation_irq
 *        (interrupt request) will still be asserted and serviced by ISR.
 *  0b10..The violation detected by the secure checker will cause an abort.
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_MASK (0xC00U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_SHIFT (10U)
/*! DISABLE_SIMPLE_MASTER_STRICT_MODE - Disable Simple Master Strict Mode
 *  0b00..Reserved
 *  0b01..Can access memories and peripherals at the same level or below that level
 *  0b10..Can access memories and peripherals at same level only
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SIMPLE_MASTER_STRICT_MODE_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE_MASK (0x3000U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE_SHIFT (12U)
/*! DISABLE_SMART_MASTER_STRICT_MODE - Disable Smart Master Strict Mode
 *  0b00..Reserved
 *  0b01..Can access memories and peripherals at the same level or below that level
 *  0b10..Can access memories and peripherals at same level only
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_DISABLE_SMART_MASTER_STRICT_MODE_MASK)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_MASK (0xC000U)
#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT (14U)
/*! IDAU_ALL_NS - IDAU All Non-Secure
 *  0b00..Reserved
 *  0b01..IDAU is disabled, which means that all memories are attributed as non-secure memory.
 *  0b10..IDAU is enabled (restrictive mode)
 *  0b11..Reserved
 */
#define AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS(x) (((uint32_t)(((uint32_t)(x)) << AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_SHIFT)) & AHB_SECURE_CTRL_MISC_CTRL_REG_IDAU_ALL_NS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AHB_SECURE_CTRL_Register_Masks */


/* AHB_SECURE_CTRL - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral AHB_SECURE_CTRL base address */
  #define AHB_SECURE_CTRL_BASE                     (0x50148000u)
  /** Peripheral AHB_SECURE_CTRL base address */
  #define AHB_SECURE_CTRL_BASE_NS                  (0x40148000u)
  /** Peripheral AHB_SECURE_CTRL base pointer */
  #define AHB_SECURE_CTRL                          ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE)
  /** Peripheral AHB_SECURE_CTRL base pointer */
  #define AHB_SECURE_CTRL_NS                       ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE_NS)
  /** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
  #define AHB_SECURE_CTRL_BASE_ADDRS               { AHB_SECURE_CTRL_BASE }
  /** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
  #define AHB_SECURE_CTRL_BASE_PTRS                { AHB_SECURE_CTRL }
  /** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
  #define AHB_SECURE_CTRL_BASE_ADDRS_NS            { AHB_SECURE_CTRL_BASE_NS }
  /** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
  #define AHB_SECURE_CTRL_BASE_PTRS_NS             { AHB_SECURE_CTRL_NS }
#else
  /** Peripheral AHB_SECURE_CTRL base address */
  #define AHB_SECURE_CTRL_BASE                     (0x40148000u)
  /** Peripheral AHB_SECURE_CTRL base pointer */
  #define AHB_SECURE_CTRL                          ((AHB_SECURE_CTRL_Type *)AHB_SECURE_CTRL_BASE)
  /** Array initializer of AHB_SECURE_CTRL peripheral base addresses */
  #define AHB_SECURE_CTRL_BASE_ADDRS               { AHB_SECURE_CTRL_BASE }
  /** Array initializer of AHB_SECURE_CTRL peripheral base pointers */
  #define AHB_SECURE_CTRL_BASE_PTRS                { AHB_SECURE_CTRL }
#endif

/*!
 * @}
 */ /* end of group AHB_SECURE_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AXI_SWITCH_AMIB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXI_SWITCH_AMIB_Peripheral_Access_Layer AXI_SWITCH_AMIB Peripheral Access Layer
 * @{
 */

/** AXI_SWITCH_AMIB - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[8];
  __IO uint32_t FN_MOD_BM_ISS;                     /**< Bus Matrix Issuing Functionality Modification., offset: 0x8 */
       uint8_t RESERVED_1[24];
  __IO uint32_t FN_MOD2;                           /**< Bypass Merge, offset: 0x24 */
       uint8_t RESERVED_2[224];
  __IO uint32_t FN_MOD;                            /**< Issuing Functionality Modification, offset: 0x108 */
} AXI_SWITCH_AMIB_Type;

/* ----------------------------------------------------------------------------
   -- AXI_SWITCH_AMIB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXI_SWITCH_AMIB_Register_Masks AXI_SWITCH_AMIB Register Masks
 * @{
 */

/*! @name FN_MOD_BM_ISS - Bus Matrix Issuing Functionality Modification. */
/*! @{ */
#define AXI_SWITCH_AMIB_FN_MOD_BM_ISS_FN_MOD_BM_ISS_MASK (0x3U)
#define AXI_SWITCH_AMIB_FN_MOD_BM_ISS_FN_MOD_BM_ISS_SHIFT (0U)
/*! FN_MOD_BM_ISS - Read channel QoS value
 */
#define AXI_SWITCH_AMIB_FN_MOD_BM_ISS_FN_MOD_BM_ISS(x) (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_AMIB_FN_MOD_BM_ISS_FN_MOD_BM_ISS_SHIFT)) & AXI_SWITCH_AMIB_FN_MOD_BM_ISS_FN_MOD_BM_ISS_MASK)
/*! @} */

/*! @name FN_MOD2 - Bypass Merge */
/*! @{ */
#define AXI_SWITCH_AMIB_FN_MOD2_FN_MOD2_MASK     (0x1U)
#define AXI_SWITCH_AMIB_FN_MOD2_FN_MOD2_SHIFT    (0U)
/*! FN_MOD2 - Bypass Merge
 */
#define AXI_SWITCH_AMIB_FN_MOD2_FN_MOD2(x)       (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_AMIB_FN_MOD2_FN_MOD2_SHIFT)) & AXI_SWITCH_AMIB_FN_MOD2_FN_MOD2_MASK)
/*! @} */

/*! @name FN_MOD - Issuing Functionality Modification */
/*! @{ */
#define AXI_SWITCH_AMIB_FN_MOD_FN_MOD_MASK       (0x3U)
#define AXI_SWITCH_AMIB_FN_MOD_FN_MOD_SHIFT      (0U)
/*! FN_MOD - Bypass Merge
 */
#define AXI_SWITCH_AMIB_FN_MOD_FN_MOD(x)         (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_AMIB_FN_MOD_FN_MOD_SHIFT)) & AXI_SWITCH_AMIB_FN_MOD_FN_MOD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AXI_SWITCH_AMIB_Register_Masks */


/* AXI_SWITCH_AMIB - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral AXI_SWITCH_AMIB base address */
  #define AXI_SWITCH_AMIB_BASE                     (0x50282000u)
  /** Peripheral AXI_SWITCH_AMIB base address */
  #define AXI_SWITCH_AMIB_BASE_NS                  (0x40282000u)
  /** Peripheral AXI_SWITCH_AMIB base pointer */
  #define AXI_SWITCH_AMIB                          ((AXI_SWITCH_AMIB_Type *)AXI_SWITCH_AMIB_BASE)
  /** Peripheral AXI_SWITCH_AMIB base pointer */
  #define AXI_SWITCH_AMIB_NS                       ((AXI_SWITCH_AMIB_Type *)AXI_SWITCH_AMIB_BASE_NS)
  /** Array initializer of AXI_SWITCH_AMIB peripheral base addresses */
  #define AXI_SWITCH_AMIB_BASE_ADDRS               { AXI_SWITCH_AMIB_BASE }
  /** Array initializer of AXI_SWITCH_AMIB peripheral base pointers */
  #define AXI_SWITCH_AMIB_BASE_PTRS                { AXI_SWITCH_AMIB }
  /** Array initializer of AXI_SWITCH_AMIB peripheral base addresses */
  #define AXI_SWITCH_AMIB_BASE_ADDRS_NS            { AXI_SWITCH_AMIB_BASE_NS }
  /** Array initializer of AXI_SWITCH_AMIB peripheral base pointers */
  #define AXI_SWITCH_AMIB_BASE_PTRS_NS             { AXI_SWITCH_AMIB_NS }
#else
  /** Peripheral AXI_SWITCH_AMIB base address */
  #define AXI_SWITCH_AMIB_BASE                     (0x40282000u)
  /** Peripheral AXI_SWITCH_AMIB base pointer */
  #define AXI_SWITCH_AMIB                          ((AXI_SWITCH_AMIB_Type *)AXI_SWITCH_AMIB_BASE)
  /** Array initializer of AXI_SWITCH_AMIB peripheral base addresses */
  #define AXI_SWITCH_AMIB_BASE_ADDRS               { AXI_SWITCH_AMIB_BASE }
  /** Array initializer of AXI_SWITCH_AMIB peripheral base pointers */
  #define AXI_SWITCH_AMIB_BASE_PTRS                { AXI_SWITCH_AMIB }
#endif

/*!
 * @}
 */ /* end of group AXI_SWITCH_AMIB_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AXI_SWITCH_ASIB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXI_SWITCH_ASIB_Peripheral_Access_Layer AXI_SWITCH_ASIB Peripheral Access Layer
 * @{
 */

/** AXI_SWITCH_ASIB - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[256];
  __IO uint32_t READ_QOS;                          /**< Read channel QoS value, offset: 0x100 */
  __IO uint32_t WRITE_QOS;                         /**< WRITE channel QoS value, offset: 0x104 */
  __IO uint32_t FN_MOD;                            /**< Issuing Functionality Modification, offset: 0x108 */
} AXI_SWITCH_ASIB_Type;

/* ----------------------------------------------------------------------------
   -- AXI_SWITCH_ASIB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXI_SWITCH_ASIB_Register_Masks AXI_SWITCH_ASIB Register Masks
 * @{
 */

/*! @name READ_QOS - Read channel QoS value */
/*! @{ */
#define AXI_SWITCH_ASIB_READ_QOS_READ_QOS_MASK   (0xFU)
#define AXI_SWITCH_ASIB_READ_QOS_READ_QOS_SHIFT  (0U)
/*! READ_QOS - Read channel QoS value
 */
#define AXI_SWITCH_ASIB_READ_QOS_READ_QOS(x)     (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_ASIB_READ_QOS_READ_QOS_SHIFT)) & AXI_SWITCH_ASIB_READ_QOS_READ_QOS_MASK)
/*! @} */

/*! @name WRITE_QOS - WRITE channel QoS value */
/*! @{ */
#define AXI_SWITCH_ASIB_WRITE_QOS_WRITE_QOS_MASK (0xFU)
#define AXI_SWITCH_ASIB_WRITE_QOS_WRITE_QOS_SHIFT (0U)
/*! WRITE_QOS - Write channel QoS value
 */
#define AXI_SWITCH_ASIB_WRITE_QOS_WRITE_QOS(x)   (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_ASIB_WRITE_QOS_WRITE_QOS_SHIFT)) & AXI_SWITCH_ASIB_WRITE_QOS_WRITE_QOS_MASK)
/*! @} */

/*! @name FN_MOD - Issuing Functionality Modification */
/*! @{ */
#define AXI_SWITCH_ASIB_FN_MOD_WRITE_QOS_MASK    (0x3U)
#define AXI_SWITCH_ASIB_FN_MOD_WRITE_QOS_SHIFT   (0U)
/*! WRITE_QOS - Write channel QoS value
 */
#define AXI_SWITCH_ASIB_FN_MOD_WRITE_QOS(x)      (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_ASIB_FN_MOD_WRITE_QOS_SHIFT)) & AXI_SWITCH_ASIB_FN_MOD_WRITE_QOS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AXI_SWITCH_ASIB_Register_Masks */


/* AXI_SWITCH_ASIB - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral AXI_SWITCH_ASIB base address */
  #define AXI_SWITCH_ASIB_BASE                     (0x502C2000u)
  /** Peripheral AXI_SWITCH_ASIB base address */
  #define AXI_SWITCH_ASIB_BASE_NS                  (0x402C2000u)
  /** Peripheral AXI_SWITCH_ASIB base pointer */
  #define AXI_SWITCH_ASIB                          ((AXI_SWITCH_ASIB_Type *)AXI_SWITCH_ASIB_BASE)
  /** Peripheral AXI_SWITCH_ASIB base pointer */
  #define AXI_SWITCH_ASIB_NS                       ((AXI_SWITCH_ASIB_Type *)AXI_SWITCH_ASIB_BASE_NS)
  /** Array initializer of AXI_SWITCH_ASIB peripheral base addresses */
  #define AXI_SWITCH_ASIB_BASE_ADDRS               { AXI_SWITCH_ASIB_BASE }
  /** Array initializer of AXI_SWITCH_ASIB peripheral base pointers */
  #define AXI_SWITCH_ASIB_BASE_PTRS                { AXI_SWITCH_ASIB }
  /** Array initializer of AXI_SWITCH_ASIB peripheral base addresses */
  #define AXI_SWITCH_ASIB_BASE_ADDRS_NS            { AXI_SWITCH_ASIB_BASE_NS }
  /** Array initializer of AXI_SWITCH_ASIB peripheral base pointers */
  #define AXI_SWITCH_ASIB_BASE_PTRS_NS             { AXI_SWITCH_ASIB_NS }
#else
  /** Peripheral AXI_SWITCH_ASIB base address */
  #define AXI_SWITCH_ASIB_BASE                     (0x402C2000u)
  /** Peripheral AXI_SWITCH_ASIB base pointer */
  #define AXI_SWITCH_ASIB                          ((AXI_SWITCH_ASIB_Type *)AXI_SWITCH_ASIB_BASE)
  /** Array initializer of AXI_SWITCH_ASIB peripheral base addresses */
  #define AXI_SWITCH_ASIB_BASE_ADDRS               { AXI_SWITCH_ASIB_BASE }
  /** Array initializer of AXI_SWITCH_ASIB peripheral base pointers */
  #define AXI_SWITCH_ASIB_BASE_PTRS                { AXI_SWITCH_ASIB }
#endif

/*!
 * @}
 */ /* end of group AXI_SWITCH_ASIB_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Peripheral_Access_Layer CACHE64_CTRL Peripheral Access Layer
 * @{
 */

/** CACHE64_CTRL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CCR;                               /**< Cache control register, offset: 0x800 */
  __IO uint32_t CLCR;                              /**< Cache line control register, offset: 0x804 */
  __IO uint32_t CSAR;                              /**< Cache search address register, offset: 0x808 */
  __IO uint32_t CCVR;                              /**< Cache read/write value register, offset: 0x80C */
} CACHE64_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Register_Masks CACHE64_CTRL Register Masks
 * @{
 */

/*! @name CCR - Cache control register */
/*! @{ */
#define CACHE64_CTRL_CCR_ENCACHE_MASK            (0x1U)
#define CACHE64_CTRL_CCR_ENCACHE_SHIFT           (0U)
/*! ENCACHE - Cache enable
 *  0b0..Cache disabled
 *  0b1..Cache enabled
 */
#define CACHE64_CTRL_CCR_ENCACHE(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENCACHE_SHIFT)) & CACHE64_CTRL_CCR_ENCACHE_MASK)
#define CACHE64_CTRL_CCR_ENWRBUF_MASK            (0x2U)
#define CACHE64_CTRL_CCR_ENWRBUF_SHIFT           (1U)
/*! ENWRBUF - Enable Write Buffer
 *  0b0..Write buffer disabled
 *  0b1..Write buffer enabled
 */
#define CACHE64_CTRL_CCR_ENWRBUF(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENWRBUF_SHIFT)) & CACHE64_CTRL_CCR_ENWRBUF_MASK)
#define CACHE64_CTRL_CCR_INVW0_MASK              (0x1000000U)
#define CACHE64_CTRL_CCR_INVW0_SHIFT             (24U)
/*! INVW0 - Invalidate Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 0.
 */
#define CACHE64_CTRL_CCR_INVW0(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW0_SHIFT)) & CACHE64_CTRL_CCR_INVW0_MASK)
#define CACHE64_CTRL_CCR_PUSHW0_MASK             (0x2000000U)
#define CACHE64_CTRL_CCR_PUSHW0_SHIFT            (25U)
/*! PUSHW0 - Push Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 0
 */
#define CACHE64_CTRL_CCR_PUSHW0(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW0_SHIFT)) & CACHE64_CTRL_CCR_PUSHW0_MASK)
#define CACHE64_CTRL_CCR_INVW1_MASK              (0x4000000U)
#define CACHE64_CTRL_CCR_INVW1_SHIFT             (26U)
/*! INVW1 - Invalidate Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 1
 */
#define CACHE64_CTRL_CCR_INVW1(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW1_SHIFT)) & CACHE64_CTRL_CCR_INVW1_MASK)
#define CACHE64_CTRL_CCR_PUSHW1_MASK             (0x8000000U)
#define CACHE64_CTRL_CCR_PUSHW1_SHIFT            (27U)
/*! PUSHW1 - Push Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 1
 */
#define CACHE64_CTRL_CCR_PUSHW1(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW1_SHIFT)) & CACHE64_CTRL_CCR_PUSHW1_MASK)
#define CACHE64_CTRL_CCR_GO_MASK                 (0x80000000U)
#define CACHE64_CTRL_CCR_GO_SHIFT                (31U)
/*! GO - Initiate Cache Command
 *  0b0..Write: no effect. Read: no cache command active.
 *  0b1..Write: initiate command indicated by bits 27-24. Read: cache command active.
 */
#define CACHE64_CTRL_CCR_GO(x)                   (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_GO_SHIFT)) & CACHE64_CTRL_CCR_GO_MASK)
/*! @} */

/*! @name CLCR - Cache line control register */
/*! @{ */
#define CACHE64_CTRL_CLCR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CLCR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits 27-24. Read: line command active.
 */
#define CACHE64_CTRL_CLCR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LGO_SHIFT)) & CACHE64_CTRL_CLCR_LGO_MASK)
#define CACHE64_CTRL_CLCR_CACHEADDR_MASK         (0x3FFCU)
#define CACHE64_CTRL_CLCR_CACHEADDR_SHIFT        (2U)
/*! CACHEADDR - Cache address
 */
#define CACHE64_CTRL_CLCR_CACHEADDR(x)           (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_CACHEADDR_SHIFT)) & CACHE64_CTRL_CLCR_CACHEADDR_MASK)
#define CACHE64_CTRL_CLCR_WSEL_MASK              (0x4000U)
#define CACHE64_CTRL_CLCR_WSEL_SHIFT             (14U)
/*! WSEL - Way select
 *  0b0..Way 0
 *  0b1..Way 1
 */
#define CACHE64_CTRL_CLCR_WSEL(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_WSEL_SHIFT)) & CACHE64_CTRL_CLCR_WSEL_MASK)
#define CACHE64_CTRL_CLCR_TDSEL_MASK             (0x10000U)
#define CACHE64_CTRL_CLCR_TDSEL_SHIFT            (16U)
/*! TDSEL - Tag/Data Select
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE64_CTRL_CLCR_TDSEL(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_TDSEL_SHIFT)) & CACHE64_CTRL_CLCR_TDSEL_MASK)
#define CACHE64_CTRL_CLCR_LCIVB_MASK             (0x100000U)
#define CACHE64_CTRL_CLCR_LCIVB_SHIFT            (20U)
/*! LCIVB - Line Command Initial Valid Bit
 */
#define CACHE64_CTRL_CLCR_LCIVB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIVB_SHIFT)) & CACHE64_CTRL_CLCR_LCIVB_MASK)
#define CACHE64_CTRL_CLCR_LCIMB_MASK             (0x200000U)
#define CACHE64_CTRL_CLCR_LCIMB_SHIFT            (21U)
/*! LCIMB - Line Command Initial Modified Bit
 */
#define CACHE64_CTRL_CLCR_LCIMB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIMB_SHIFT)) & CACHE64_CTRL_CLCR_LCIMB_MASK)
#define CACHE64_CTRL_CLCR_LCWAY_MASK             (0x400000U)
#define CACHE64_CTRL_CLCR_LCWAY_SHIFT            (22U)
/*! LCWAY - Line Command Way
 */
#define CACHE64_CTRL_CLCR_LCWAY(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCWAY_SHIFT)) & CACHE64_CTRL_CLCR_LCWAY_MASK)
#define CACHE64_CTRL_CLCR_LCMD_MASK              (0x3000000U)
#define CACHE64_CTRL_CLCR_LCMD_SHIFT             (24U)
/*! LCMD - Line Command
 *  0b00..Search and read or write
 *  0b01..Invalidate
 *  0b10..Push
 *  0b11..Clear
 */
#define CACHE64_CTRL_CLCR_LCMD(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCMD_SHIFT)) & CACHE64_CTRL_CLCR_LCMD_MASK)
#define CACHE64_CTRL_CLCR_LADSEL_MASK            (0x4000000U)
#define CACHE64_CTRL_CLCR_LADSEL_SHIFT           (26U)
/*! LADSEL - Line Address Select
 *  0b0..Cache address
 *  0b1..Physical address
 */
#define CACHE64_CTRL_CLCR_LADSEL(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LADSEL_SHIFT)) & CACHE64_CTRL_CLCR_LADSEL_MASK)
#define CACHE64_CTRL_CLCR_LACC_MASK              (0x8000000U)
#define CACHE64_CTRL_CLCR_LACC_SHIFT             (27U)
/*! LACC - Line access type
 *  0b0..Read
 *  0b1..Write
 */
#define CACHE64_CTRL_CLCR_LACC(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LACC_SHIFT)) & CACHE64_CTRL_CLCR_LACC_MASK)
/*! @} */

/*! @name CSAR - Cache search address register */
/*! @{ */
#define CACHE64_CTRL_CSAR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CSAR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits CLCR[27:24]. Read: line command active.
 */
#define CACHE64_CTRL_CSAR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_LGO_SHIFT)) & CACHE64_CTRL_CSAR_LGO_MASK)
#define CACHE64_CTRL_CSAR_PHYADDR27_1_MASK       (0xFFFFFFEU)
#define CACHE64_CTRL_CSAR_PHYADDR27_1_SHIFT      (1U)
/*! PHYADDR27_1 - Physical Address
 */
#define CACHE64_CTRL_CSAR_PHYADDR27_1(x)         (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR27_1_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR27_1_MASK)
#define CACHE64_CTRL_CSAR_PHYADDR31_29_MASK      (0xE0000000U)
#define CACHE64_CTRL_CSAR_PHYADDR31_29_SHIFT     (29U)
/*! PHYADDR31_29 - Physical Address
 */
#define CACHE64_CTRL_CSAR_PHYADDR31_29(x)        (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR31_29_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR31_29_MASK)
/*! @} */

/*! @name CCVR - Cache read/write value register */
/*! @{ */
#define CACHE64_CTRL_CCVR_DATA_MASK              (0xFFFFFFFFU)
#define CACHE64_CTRL_CCVR_DATA_SHIFT             (0U)
/*! DATA - Cache read/write Data
 */
#define CACHE64_CTRL_CCVR_DATA(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCVR_DATA_SHIFT)) & CACHE64_CTRL_CCVR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Register_Masks */


/* CACHE64_CTRL - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE                       (0x50033000u)
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE_NS                    (0x40033000u)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0_NS                         ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE_NS)
  /** Peripheral CACHE64_CTRL1 base address */
  #define CACHE64_CTRL1_BASE                       (0x50034000u)
  /** Peripheral CACHE64_CTRL1 base address */
  #define CACHE64_CTRL1_BASE_NS                    (0x40034000u)
  /** Peripheral CACHE64_CTRL1 base pointer */
  #define CACHE64_CTRL1                            ((CACHE64_CTRL_Type *)CACHE64_CTRL1_BASE)
  /** Peripheral CACHE64_CTRL1 base pointer */
  #define CACHE64_CTRL1_NS                         ((CACHE64_CTRL_Type *)CACHE64_CTRL1_BASE_NS)
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE, CACHE64_CTRL1_BASE }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0, CACHE64_CTRL1 }
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS_NS               { CACHE64_CTRL0_BASE_NS, CACHE64_CTRL1_BASE_NS }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS_NS                { CACHE64_CTRL0_NS, CACHE64_CTRL1_NS }
#else
  /** Peripheral CACHE64_CTRL0 base address */
  #define CACHE64_CTRL0_BASE                       (0x40033000u)
  /** Peripheral CACHE64_CTRL0 base pointer */
  #define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
  /** Peripheral CACHE64_CTRL1 base address */
  #define CACHE64_CTRL1_BASE                       (0x40034000u)
  /** Peripheral CACHE64_CTRL1 base pointer */
  #define CACHE64_CTRL1                            ((CACHE64_CTRL_Type *)CACHE64_CTRL1_BASE)
  /** Array initializer of CACHE64_CTRL peripheral base addresses */
  #define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE, CACHE64_CTRL1_BASE }
  /** Array initializer of CACHE64_CTRL peripheral base pointers */
  #define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0, CACHE64_CTRL1 }
#endif
#if (__ARM_FEATURE_CMSE & 0x2)
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES                { 0x18000000u, 0x38000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES                { 0x08000000u, 0x08000000u }
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES_NS             { 0x08000000u, 0x28000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES_NS             { 0x08000000u, 0x08000000u }
#else
/** CACHE64_CTRL physical memory base address */
 #define CACHE64_CTRL_PHYMEM_BASES                { 0x08000000u, 0x28000000u }
/** CACHE64_CTRL physical memory size */
 #define CACHE64_CTRL_PHYMEM_SIZES                { 0x08000000u, 0x08000000u }
#endif
/* Backward compatibility */
#define CACHE64_CTRL_CSAR_PHYADDR_MASK (CACHE64_CTRL_CSAR_PHYADDR27_1_MASK | CACHE64_CTRL_CSAR_PHYADDR31_29_MASK)


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Peripheral_Access_Layer CACHE64_POLSEL Peripheral Access Layer
 * @{
 */

/** CACHE64_POLSEL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[20];
  __IO uint32_t REG0_TOP;                          /**< Region 0 Top Boundary, offset: 0x14 */
  __IO uint32_t REG1_TOP;                          /**< Region 1 Top Boundary, offset: 0x18 */
  __IO uint32_t POLSEL;                            /**< Policy Select, offset: 0x1C */
} CACHE64_POLSEL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Register_Masks CACHE64_POLSEL Register Masks
 * @{
 */

/*! @name REG0_TOP - Region 0 Top Boundary */
/*! @{ */
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT   (10U)
/*! REG0_TOP - Upper limit of Region 0
 */
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT)) & CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK)
/*! @} */

/*! @name REG1_TOP - Region 1 Top Boundary */
/*! @{ */
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT   (10U)
/*! REG1_TOP - Upper limit of Region 1
 */
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT)) & CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK)
/*! @} */

/*! @name POLSEL - Policy Select */
/*! @{ */
#define CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK   (0x3U)
#define CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT  (0U)
/*! REG0_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG0_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK)
#define CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK   (0xCU)
#define CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT  (2U)
/*! REG1_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG1_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK)
#define CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK  (0x30U)
#define CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT (4U)
/*! REG02_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG02_POLICY(x)    (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Register_Masks */


/* CACHE64_POLSEL - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE                     (0x50033000u)
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE_NS                  (0x40033000u)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0_NS                       ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE_NS)
  /** Peripheral CACHE64_POLSEL1 base address */
  #define CACHE64_POLSEL1_BASE                     (0x50034000u)
  /** Peripheral CACHE64_POLSEL1 base address */
  #define CACHE64_POLSEL1_BASE_NS                  (0x40034000u)
  /** Peripheral CACHE64_POLSEL1 base pointer */
  #define CACHE64_POLSEL1                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL1_BASE)
  /** Peripheral CACHE64_POLSEL1 base pointer */
  #define CACHE64_POLSEL1_NS                       ((CACHE64_POLSEL_Type *)CACHE64_POLSEL1_BASE_NS)
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE, CACHE64_POLSEL1_BASE }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0, CACHE64_POLSEL1 }
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS_NS             { CACHE64_POLSEL0_BASE_NS, CACHE64_POLSEL1_BASE_NS }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS_NS              { CACHE64_POLSEL0_NS, CACHE64_POLSEL1_NS }
#else
  /** Peripheral CACHE64_POLSEL0 base address */
  #define CACHE64_POLSEL0_BASE                     (0x40033000u)
  /** Peripheral CACHE64_POLSEL0 base pointer */
  #define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
  /** Peripheral CACHE64_POLSEL1 base address */
  #define CACHE64_POLSEL1_BASE                     (0x40034000u)
  /** Peripheral CACHE64_POLSEL1 base pointer */
  #define CACHE64_POLSEL1                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL1_BASE)
  /** Array initializer of CACHE64_POLSEL peripheral base addresses */
  #define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE, CACHE64_POLSEL1_BASE }
  /** Array initializer of CACHE64_POLSEL peripheral base pointers */
  #define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0, CACHE64_POLSEL1 }
#endif

/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CASPER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CASPER_Peripheral_Access_Layer CASPER Peripheral Access Layer
 * @{
 */

/** CASPER - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL0;                             /**< Control 0, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1, offset: 0x4 */
       uint8_t RESERVED_0[4];
  __IO uint32_t STATUS;                            /**< Status, offset: 0xC */
  __IO uint32_t INTENSET;                          /**< Interrupt Enable Set, offset: 0x10 */
  __IO uint32_t INTENCLR;                          /**< Interrupt Enable Clear, offset: 0x14 */
  __I  uint32_t INTSTAT;                           /**< Interrupt status, offset: 0x18 */
       uint8_t RESERVED_1[4];
  __IO uint32_t AREG;                              /**< A Register, offset: 0x20 */
  __IO uint32_t BREG;                              /**< B Register, offset: 0x24 */
  __IO uint32_t CREG;                              /**< C Register, offset: 0x28 */
  __IO uint32_t DREG;                              /**< D Register, offset: 0x2C */
  __IO uint32_t RES0;                              /**< Result Register 0, offset: 0x30 */
  __IO uint32_t RES1;                              /**< Result Register 1, offset: 0x34 */
  __IO uint32_t RES2;                              /**< Result Register 2, offset: 0x38 */
  __IO uint32_t RES3;                              /**< Result Register 3, offset: 0x3C */
       uint8_t RESERVED_2[32];
  __IO uint32_t MASK;                              /**< Mask, offset: 0x60 */
  __IO uint32_t REMASK;                            /**< Remask, offset: 0x64 */
       uint8_t RESERVED_3[24];
  __IO uint32_t LOCK;                              /**< Lock, offset: 0x80 */
} CASPER_Type;

/* ----------------------------------------------------------------------------
   -- CASPER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CASPER_Register_Masks CASPER Register Masks
 * @{
 */

/*! @name CTRL0 - Control 0 */
/*! @{ */
#define CASPER_CTRL0_ABBPAIR_MASK                (0x1U)
#define CASPER_CTRL0_ABBPAIR_SHIFT               (0U)
/*! ABBPAIR - ABOFF Bank Pair
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL0_ABBPAIR(x)                  (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_ABBPAIR_SHIFT)) & CASPER_CTRL0_ABBPAIR_MASK)
#define CASPER_CTRL0_ABOFF_MASK                  (0x4U)
#define CASPER_CTRL0_ABOFF_SHIFT                 (2U)
/*! ABOFF - AB Offset
 */
#define CASPER_CTRL0_ABOFF(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_ABOFF_SHIFT)) & CASPER_CTRL0_ABOFF_MASK)
#define CASPER_CTRL0_CDBPAIR_MASK                (0x10000U)
#define CASPER_CTRL0_CDBPAIR_SHIFT               (16U)
/*! CDBPAIR - CDOFF Bank Pair
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL0_CDBPAIR(x)                  (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_CDBPAIR_SHIFT)) & CASPER_CTRL0_CDBPAIR_MASK)
#define CASPER_CTRL0_CDOFF_MASK                  (0x1FFC0000U)
#define CASPER_CTRL0_CDOFF_SHIFT                 (18U)
/*! CDOFF - CD Offset
 */
#define CASPER_CTRL0_CDOFF(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_CDOFF_SHIFT)) & CASPER_CTRL0_CDOFF_MASK)
/*! @} */

/*! @name CTRL1 - Control 1 */
/*! @{ */
#define CASPER_CTRL1_ITER_MASK                   (0xFFU)
#define CASPER_CTRL1_ITER_SHIFT                  (0U)
/*! ITER - Interation Counter
 */
#define CASPER_CTRL1_ITER(x)                     (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_ITER_SHIFT)) & CASPER_CTRL1_ITER_MASK)
#define CASPER_CTRL1_MODE_MASK                   (0xFF00U)
#define CASPER_CTRL1_MODE_SHIFT                  (8U)
/*! MODE - Mode
 */
#define CASPER_CTRL1_MODE(x)                     (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_MODE_SHIFT)) & CASPER_CTRL1_MODE_MASK)
#define CASPER_CTRL1_RESBPAIR_MASK               (0x10000U)
#define CASPER_CTRL1_RESBPAIR_SHIFT              (16U)
/*! RESBPAIR - RESOFF Bank Pair
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL1_RESBPAIR(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_RESBPAIR_SHIFT)) & CASPER_CTRL1_RESBPAIR_MASK)
#define CASPER_CTRL1_RESOFF_MASK                 (0x1FFC0000U)
#define CASPER_CTRL1_RESOFF_SHIFT                (18U)
/*! RESOFF - Result Offset
 */
#define CASPER_CTRL1_RESOFF(x)                   (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_RESOFF_SHIFT)) & CASPER_CTRL1_RESOFF_MASK)
#define CASPER_CTRL1_CSKIP_MASK                  (0xC0000000U)
#define CASPER_CTRL1_CSKIP_SHIFT                 (30U)
/*! CSKIP - Skip Rules on Carry
 *  0b00..No Skip
 *  0b01..Skip if Carry is 1
 *  0b10..Skip if Carry is 0
 *  0b11..Set CTRLOFF to CDOFF and Skip
 */
#define CASPER_CTRL1_CSKIP(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_CSKIP_SHIFT)) & CASPER_CTRL1_CSKIP_MASK)
/*! @} */

/*! @name STATUS - Status */
/*! @{ */
#define CASPER_STATUS_DONE_MASK                  (0x1U)
#define CASPER_STATUS_DONE_SHIFT                 (0U)
/*! DONE - Done
 *  0b0..Busy or just cleared
 *  0b1..Completed last operation
 */
#define CASPER_STATUS_DONE(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_DONE_SHIFT)) & CASPER_STATUS_DONE_MASK)
#define CASPER_STATUS_CARRY_MASK                 (0x10U)
#define CASPER_STATUS_CARRY_SHIFT                (4U)
/*! CARRY - Carry
 *  0b0..Carry was 0 or no carry
 *  0b1..Carry was 1
 */
#define CASPER_STATUS_CARRY(x)                   (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_CARRY_SHIFT)) & CASPER_STATUS_CARRY_MASK)
#define CASPER_STATUS_BUSY_MASK                  (0x20U)
#define CASPER_STATUS_BUSY_SHIFT                 (5U)
/*! BUSY - Busy
 *  0b0..Not busy - is idle
 *  0b1..Is busy
 */
#define CASPER_STATUS_BUSY(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_BUSY_SHIFT)) & CASPER_STATUS_BUSY_MASK)
/*! @} */

/*! @name INTENSET - Interrupt Enable Set */
/*! @{ */
#define CASPER_INTENSET_DONE_MASK                (0x1U)
#define CASPER_INTENSET_DONE_SHIFT               (0U)
/*! DONE - Done
 *  0b0..Do not interrupt when done
 *  0b1..Interrupt when done
 */
#define CASPER_INTENSET_DONE(x)                  (((uint32_t)(((uint32_t)(x)) << CASPER_INTENSET_DONE_SHIFT)) & CASPER_INTENSET_DONE_MASK)
/*! @} */

/*! @name INTENCLR - Interrupt Enable Clear */
/*! @{ */
#define CASPER_INTENCLR_DONE_MASK                (0x1U)
#define CASPER_INTENCLR_DONE_SHIFT               (0U)
/*! DONE - Done
 *  0b0..If written 0, ignored
 *  0b1..If written 1, do not interrupt when done.
 */
#define CASPER_INTENCLR_DONE(x)                  (((uint32_t)(((uint32_t)(x)) << CASPER_INTENCLR_DONE_SHIFT)) & CASPER_INTENCLR_DONE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status */
/*! @{ */
#define CASPER_INTSTAT_DONE_MASK                 (0x1U)
#define CASPER_INTSTAT_DONE_SHIFT                (0U)
/*! DONE - If set, interrupt is caused by accelerator being done.
 *  0b0..Not caused by accelerator being done
 *  0b1..Caused by accelerator being done
 */
#define CASPER_INTSTAT_DONE(x)                   (((uint32_t)(((uint32_t)(x)) << CASPER_INTSTAT_DONE_SHIFT)) & CASPER_INTSTAT_DONE_MASK)
/*! @} */

/*! @name AREG - A Register */
/*! @{ */
#define CASPER_AREG_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_AREG_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_AREG_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_AREG_REG_VALUE_SHIFT)) & CASPER_AREG_REG_VALUE_MASK)
/*! @} */

/*! @name BREG - B Register */
/*! @{ */
#define CASPER_BREG_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_BREG_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_BREG_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_BREG_REG_VALUE_SHIFT)) & CASPER_BREG_REG_VALUE_MASK)
/*! @} */

/*! @name CREG - C Register */
/*! @{ */
#define CASPER_CREG_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_CREG_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_CREG_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_CREG_REG_VALUE_SHIFT)) & CASPER_CREG_REG_VALUE_MASK)
/*! @} */

/*! @name DREG - D Register */
/*! @{ */
#define CASPER_DREG_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_DREG_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_DREG_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_DREG_REG_VALUE_SHIFT)) & CASPER_DREG_REG_VALUE_MASK)
/*! @} */

/*! @name RES0 - Result Register 0 */
/*! @{ */
#define CASPER_RES0_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_RES0_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_RES0_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_RES0_REG_VALUE_SHIFT)) & CASPER_RES0_REG_VALUE_MASK)
/*! @} */

/*! @name RES1 - Result Register 1 */
/*! @{ */
#define CASPER_RES1_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_RES1_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register to hold working result (from multiplier, adder/xor, etc).
 */
#define CASPER_RES1_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_RES1_REG_VALUE_SHIFT)) & CASPER_RES1_REG_VALUE_MASK)
/*! @} */

/*! @name RES2 - Result Register 2 */
/*! @{ */
#define CASPER_RES2_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_RES2_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_RES2_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_RES2_REG_VALUE_SHIFT)) & CASPER_RES2_REG_VALUE_MASK)
/*! @} */

/*! @name RES3 - Result Register 3 */
/*! @{ */
#define CASPER_RES3_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_RES3_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register to hold working result (from multiplier, adder/xor, etc).
 */
#define CASPER_RES3_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_RES3_REG_VALUE_SHIFT)) & CASPER_RES3_REG_VALUE_MASK)
/*! @} */

/*! @name MASK - Mask */
/*! @{ */
#define CASPER_MASK_MASK_MASK                    (0xFFFFFFFFU)
#define CASPER_MASK_MASK_SHIFT                   (0U)
/*! MASK - Mask
 */
#define CASPER_MASK_MASK(x)                      (((uint32_t)(((uint32_t)(x)) << CASPER_MASK_MASK_SHIFT)) & CASPER_MASK_MASK_MASK)
/*! @} */

/*! @name REMASK - Remask */
/*! @{ */
#define CASPER_REMASK_MASK_MASK                  (0xFFFFFFFFU)
#define CASPER_REMASK_MASK_SHIFT                 (0U)
/*! MASK - Mask
 */
#define CASPER_REMASK_MASK(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_REMASK_MASK_SHIFT)) & CASPER_REMASK_MASK_MASK)
/*! @} */

/*! @name LOCK - Lock */
/*! @{ */
#define CASPER_LOCK_LOCK_MASK                    (0x1U)
#define CASPER_LOCK_LOCK_SHIFT                   (0U)
/*! LOCK - Lock
 *  0b0..Unlock
 *  0b1..Lock to current security level
 */
#define CASPER_LOCK_LOCK(x)                      (((uint32_t)(((uint32_t)(x)) << CASPER_LOCK_LOCK_SHIFT)) & CASPER_LOCK_LOCK_MASK)
#define CASPER_LOCK_KEY_MASK                     (0x1FFF0U)
#define CASPER_LOCK_KEY_SHIFT                    (4U)
/*! KEY - Key
 *  0b0011100111101..Key Value
 */
#define CASPER_LOCK_KEY(x)                       (((uint32_t)(((uint32_t)(x)) << CASPER_LOCK_KEY_SHIFT)) & CASPER_LOCK_KEY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CASPER_Register_Masks */


/* CASPER - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral CASPER base address */
  #define CASPER_BASE                              (0x50201000u)
  /** Peripheral CASPER base address */
  #define CASPER_BASE_NS                           (0x40201000u)
  /** Peripheral CASPER base pointer */
  #define CASPER                                   ((CASPER_Type *)CASPER_BASE)
  /** Peripheral CASPER base pointer */
  #define CASPER_NS                                ((CASPER_Type *)CASPER_BASE_NS)
  /** Array initializer of CASPER peripheral base addresses */
  #define CASPER_BASE_ADDRS                        { CASPER_BASE }
  /** Array initializer of CASPER peripheral base pointers */
  #define CASPER_BASE_PTRS                         { CASPER }
  /** Array initializer of CASPER peripheral base addresses */
  #define CASPER_BASE_ADDRS_NS                     { CASPER_BASE_NS }
  /** Array initializer of CASPER peripheral base pointers */
  #define CASPER_BASE_PTRS_NS                      { CASPER_NS }
#else
  /** Peripheral CASPER base address */
  #define CASPER_BASE                              (0x40201000u)
  /** Peripheral CASPER base pointer */
  #define CASPER                                   ((CASPER_Type *)CASPER_BASE)
  /** Array initializer of CASPER peripheral base addresses */
  #define CASPER_BASE_ADDRS                        { CASPER_BASE }
  /** Array initializer of CASPER peripheral base pointers */
  #define CASPER_BASE_PTRS                         { CASPER }
#endif
/** Interrupt vectors for the CASPER peripheral type */
#define CASPER_IRQS                              { CASPER_IRQn }

/*!
 * @}
 */ /* end of group CASPER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CLKCTL0 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL0_Peripheral_Access_Layer CLKCTL0 Peripheral Access Layer
 * @{
 */

/** CLKCTL0 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t PSCCTL0;                           /**< Clock Control 0, offset: 0x10 */
  __IO uint32_t PSCCTL1;                           /**< Clock Control 1, offset: 0x14 */
  __IO uint32_t PSCCTL2;                           /**< Clock Control 2, offset: 0x18 */
       uint8_t RESERVED_1[36];
  __O  uint32_t PSCCTL0_SET;                       /**< Clock Control 0 Set, offset: 0x40 */
  __O  uint32_t PSCCTL1_SET;                       /**< Clock Control 1 Set, offset: 0x44 */
  __O  uint32_t PSCCTL2_SET;                       /**< Clock Control 2 Set, offset: 0x48 */
       uint8_t RESERVED_2[36];
  __O  uint32_t PSCCTL0_CLR;                       /**< Clock Control 0 Clear, offset: 0x70 */
  __O  uint32_t PSCCTL1_CLR;                       /**< Clock Control 1 Clear, offset: 0x74 */
  __O  uint32_t PSCCTL2_CLR;                       /**< Clock Control 2 Clear, offset: 0x78 */
       uint8_t RESERVED_3[4];
  __IO uint32_t FRO_CONTROL;                       /**< Free Running Oscillator Control, offset: 0x80 */
  __I  uint32_t FRO_CAPVAL;                        /**< Free Running Oscillator Captured Value, offset: 0x84 */
       uint8_t RESERVED_4[4];
  __IO uint32_t FRO_RDTRIM;                        /**< Free Running Oscillator Trim, offset: 0x8C */
  __IO uint32_t FRO_SCTRIM;                        /**< Free Running OscillatorSC Trim, offset: 0x90 */
       uint8_t RESERVED_5[116];
  __IO uint32_t FRODIVSEL;                         /**< FRO Clock Divider, offset: 0x108 */
  __I  uint32_t FROCLKSTATUS;                      /**< FRO Clock Status, offset: 0x10C */
  __IO uint32_t FRODIVOEN;                         /**< FRO Enable Register, offset: 0x110 */
       uint8_t RESERVED_6[28];
  __IO uint32_t LOWFREQCLKDIV;                     /**< Low Frequency Clock Divider, offset: 0x130 */
       uint8_t RESERVED_7[44];
  __IO uint32_t SYSOSCCTL0;                        /**< System Oscillator Control 0, offset: 0x160 */
       uint8_t RESERVED_8[4];
  __IO uint32_t SYSOSCBYPASS;                      /**< OSC Clock Source Select, offset: 0x168 */
       uint8_t RESERVED_9[36];
  __IO uint32_t LPOSCCTL0;                         /**< Low Power Oscillator Control 0, offset: 0x190 */
       uint8_t RESERVED_10[44];
  __IO uint32_t OSC32KHZCTL0;                      /**< 32 KHz Oscillator Control 0, offset: 0x1C0 */
       uint8_t RESERVED_11[60];
  __IO uint32_t SYSPLL0CLKSEL;                     /**< System PLL 0 Clock Select, offset: 0x200 */
  __IO uint32_t SYSPLL0CTL0;                       /**< System PLL0 Control 0, offset: 0x204 */
       uint8_t RESERVED_12[4];
  __IO uint32_t SYSPLL0LOCKTIMEDIV2;               /**< System PLL0 Lock Time Div2, offset: 0x20C */
  __IO uint32_t SYSPLL0NUM;                        /**< System PLL0 Numerator, offset: 0x210 */
  __IO uint32_t SYSPLL0DENOM;                      /**< System PLL0 Denominator, offset: 0x214 */
  __IO uint32_t SYSPLL0PFD;                        /**< System PLL0 PFD, offset: 0x218 */
       uint8_t RESERVED_13[36];
  __IO uint32_t MAINPLLCLKDIV;                     /**< Main PLL Clock Divider, offset: 0x240 */
  __IO uint32_t DSPPLLCLKDIV;                      /**< DSP PLL Clock Divider, offset: 0x244 */
  __IO uint32_t AUX0PLLCLKDIV;                     /**< AUX0 PLL Clock Divider, offset: 0x248 */
  __IO uint32_t AUX1PLLCLKDIV;                     /**< AUX1 PLL Clock Divider, offset: 0x24C */
       uint8_t RESERVED_14[432];
  __IO uint32_t SYSCPUAHBCLKDIV;                   /**< System CPU AHB Clock Divider, offset: 0x400 */
       uint8_t RESERVED_15[44];
  __IO uint32_t MAINCLKSELA;                       /**< Main Clock Select A, offset: 0x430 */
  __IO uint32_t MAINCLKSELB;                       /**< Main Clock Select B, offset: 0x434 */
       uint8_t RESERVED_16[200];
  __IO uint32_t PFCDIV[2];                         /**< PFC divider 0 (trace clock)..PFC divider 1 (USB HS PHY bus clock), array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_17[280];
  __IO uint32_t FLEXSPI0FCLKSEL;                   /**< FlexSPI0 Functional Clock Select, offset: 0x620 */
  __IO uint32_t FLEXSPI0FCLKDIV;                   /**< FlexSPI0 Functional Clock Divider, offset: 0x624 */
       uint8_t RESERVED_18[8];
  __IO uint32_t FLEXSPI1FCLKSEL;                   /**< FlexSPI1 Functional Clock Select, offset: 0x630 */
  __IO uint32_t FLEXSPI1FCLKDIV;                   /**< FlexSPI1 Functional Clock Divider, offset: 0x634 */
       uint8_t RESERVED_19[8];
  __IO uint32_t SCTFCLKSEL;                        /**< SCT Functional Clock Select, offset: 0x640 */
  __IO uint32_t SCTIN7CLKDIV;                      /**< SCT Functional Clock Divider, offset: 0x644 */
       uint8_t RESERVED_20[24];
  __IO uint32_t USBHSFCLKSEL;                      /**< High Speed USB Functional Clock Select, offset: 0x660 */
  __IO uint32_t USBHSFCLKDIV;                      /**< High Speed USB Functional Clock Divider, offset: 0x664 */
       uint8_t RESERVED_21[24];
  __IO uint32_t SDIO0FCLKSEL;                      /**< SDIO0 Functional Clock Select, offset: 0x680 */
  __IO uint32_t SDIO0FCLKDIV;                      /**< SDIO0 Functional Clock Divider, offset: 0x684 */
       uint8_t RESERVED_22[8];
  __IO uint32_t SDIO1FCLKSEL;                      /**< SDIO1 Functional Clock Select, offset: 0x690 */
  __IO uint32_t SDIO1FCLKDIV;                      /**< SDIO1 Functional Clock Divider, offset: 0x694 */
       uint8_t RESERVED_23[56];
  __IO uint32_t ADC0FCLKSEL0;                      /**< ADC0 Functional Clock Select 0, offset: 0x6D0 */
  __IO uint32_t ADC0FCLKSEL1;                      /**< ADC0 Functional Clock Select 1, offset: 0x6D4 */
  __IO uint32_t ADC0FCLKDIV;                       /**< ADC0 Functional Clock Divider, offset: 0x6D8 */
       uint8_t RESERVED_24[36];
  __IO uint32_t UTICKFCLKSEL;                      /**< UTICK Functional Clock Select, offset: 0x700 */
       uint8_t RESERVED_25[28];
  __IO uint32_t WDT0FCLKSEL;                       /**< WDT0 Functional Clock Select, offset: 0x720 */
       uint8_t RESERVED_26[12];
  __IO uint32_t A32KHZWAKECLKSEL;                  /**< 32 KHz Wake Clock Source Select, offset: 0x730 */
  __IO uint32_t A32KHZWAKECLKDIV;                  /**< 32 KHz Wake Clock Divider, offset: 0x734 */
       uint8_t RESERVED_27[40];
  __IO uint32_t SYSTICKFCLKSEL;                    /**< SYSTICK Functional Clock Select, offset: 0x760 */
  __IO uint32_t SYSTICKFCLKDIV;                    /**< SYSTICK Functional Clock Divider, offset: 0x764 */
       uint8_t RESERVED_28[8];
  __IO uint32_t DPHYCLKSEL;                        /**< MIPI-DSI PHY Clock Select, offset: 0x770 */
  __IO uint32_t DPHYCLKDIV;                        /**< MIPI-DSI PHY Clock Divider, offset: 0x774 */
  __IO uint32_t DPHYESCCLKSEL;                     /**< MIPI-DSI DPHY Escape Mode Clock Select, offset: 0x778 */
  __IO uint32_t DPHYESCRXCLKDIV;                   /**< MIPI-DSI DPHY Escape Mode Receive Clock Divider, offset: 0x77C */
  __IO uint32_t DPHYESCTXCLKDIV;                   /**< MIPI-DSI DPHY Escape Mode Tramsmit Clock Divider, offset: 0x780 */
       uint8_t RESERVED_29[12];
  __IO uint32_t GPUCLKSEL;                         /**< GPU Clock Select, offset: 0x790 */
  __IO uint32_t GPUCLKDIV;                         /**< GPU Clock Divider, offset: 0x794 */
       uint8_t RESERVED_30[8];
  __IO uint32_t DCPIXELCLKSEL;                     /**< LCDIF Pixel Clock Select, offset: 0x7A0 */
  __IO uint32_t DCPIXELCLKDIV;                     /**< LCDIF Pixel Clock Divider, offset: 0x7A4 */
} CLKCTL0_Type;

/* ----------------------------------------------------------------------------
   -- CLKCTL0 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL0_Register_Masks CLKCTL0 Register Masks
 * @{
 */

/*! @name PSCCTL0 - Clock Control 0 */
/*! @{ */
#define CLKCTL0_PSCCTL0_DSP_CLK_MASK             (0x2U)
#define CLKCTL0_PSCCTL0_DSP_CLK_SHIFT            (1U)
/*! DSP_CLK - DSP clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_DSP_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_DSP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_DSP_CLK_MASK)
#define CLKCTL0_PSCCTL0_ROM_CTRLR_CLK_MASK       (0x4U)
#define CLKCTL0_PSCCTL0_ROM_CTRLR_CLK_SHIFT      (2U)
/*! ROM_CTRLR_CLK - 128KB ROM Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_ROM_CTRLR_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_ROM_CTRLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_ROM_CTRLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_AXI_SWITCH_CLK_MASK      (0x8U)
#define CLKCTL0_PSCCTL0_AXI_SWITCH_CLK_SHIFT     (3U)
/*! AXI_SWITCH_CLK - AXI Switch clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_AXI_SWITCH_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_AXI_SWITCH_CLK_SHIFT)) & CLKCTL0_PSCCTL0_AXI_SWITCH_CLK_MASK)
#define CLKCTL0_PSCCTL0_AXI_CTLR_CLK_MASK        (0x10U)
#define CLKCTL0_PSCCTL0_AXI_CTLR_CLK_SHIFT       (4U)
/*! AXI_CTLR_CLK - AXI Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_AXI_CTLR_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_AXI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_AXI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_POWERQUAD_CLK_MASK       (0x100U)
#define CLKCTL0_PSCCTL0_POWERQUAD_CLK_SHIFT      (8U)
/*! POWERQUAD_CLK - POWERQUAD clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_POWERQUAD_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_POWERQUAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_CASPER_CLK_MASK          (0x200U)
#define CLKCTL0_PSCCTL0_CASPER_CLK_SHIFT         (9U)
/*! CASPER_CLK - CASPER clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_CASPER_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CASPER_CLK_MASK)
#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK_MASK       (0x400U)
#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK_SHIFT      (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_HASHCRYPT_CLK_MASK)
#define CLKCTL0_PSCCTL0_PUF_CLK_MASK             (0x800U)
#define CLKCTL0_PSCCTL0_PUF_CLK_SHIFT            (11U)
/*! PUF_CLK - PUF clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_PUF_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_PUF_CLK_MASK)
#define CLKCTL0_PSCCTL0_RNG_CLK_MASK             (0x1000U)
#define CLKCTL0_PSCCTL0_RNG_CLK_SHIFT            (12U)
/*! RNG_CLK - Random Number Generator (RNG) clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_RNG_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_RNG_CLK_MASK)
#define CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK_MASK  (0x10000U)
#define CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK_SHIFT (16U)
/*! FLEXSPI0_OTFAD_CLK - FLEXSPI0 / OTFAD clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_OTP_CTLR_CLK_MASK        (0x20000U)
#define CLKCTL0_PSCCTL0_OTP_CTLR_CLK_SHIFT       (17U)
/*! OTP_CTLR_CLK - OTP Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_OTP_CTLR_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_OTP_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_OTP_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_FLEXSPI1_CLK_MASK        (0x40000U)
#define CLKCTL0_PSCCTL0_FLEXSPI1_CLK_SHIFT       (18U)
/*! FLEXSPI1_CLK - FLEXSPI1 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_FLEXSPI1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_FLEXSPI1_CLK_SHIFT)) & CLKCTL0_PSCCTL0_FLEXSPI1_CLK_MASK)
#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK_MASK       (0x100000U)
#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK_SHIFT      (20U)
/*! USBHS_PHY_CLK - USB HS PHY clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_PHY_CLK_MASK)
#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_MASK    (0x200000U)
#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_SHIFT   (21U)
/*! USBHS_DEVICE_CLK - USB HS Device clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_MASK)
#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK_MASK      (0x400000U)
#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK_SHIFT     (22U)
/*! USBHS_HOST_CLK - USB HS Host clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_HOST_CLK_MASK)
#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_MASK      (0x800000U)
#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_SHIFT     (23U)
/*! USBHS_SRAM_CLK - USB HS SRAM clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_MASK)
#define CLKCTL0_PSCCTL0_SCT_CLK_MASK             (0x1000000U)
#define CLKCTL0_PSCCTL0_SCT_CLK_SHIFT            (24U)
/*! SCT_CLK - SCT clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_SCT_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SCT_CLK_MASK)
#define CLKCTL0_PSCCTL0_GPU_CLK_MASK             (0x4000000U)
#define CLKCTL0_PSCCTL0_GPU_CLK_SHIFT            (26U)
/*! GPU_CLK - GPU clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_GPU_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_GPU_CLK_SHIFT)) & CLKCTL0_PSCCTL0_GPU_CLK_MASK)
#define CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK_MASK    (0x8000000U)
#define CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK_SHIFT   (27U)
/*! DISPLAY_CTLR_CLK - Display Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK_MASK   (0x10000000U)
#define CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK_SHIFT  (28U)
/*! MIPI_DSI_CTLR_CLK - MIPI-DSI Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SMARTDMA_CLK_MASK        (0x40000000U)
#define CLKCTL0_PSCCTL0_SMARTDMA_CLK_SHIFT       (30U)
/*! SMARTDMA_CLK - Smart DMA clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_SMARTDMA_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SMARTDMA_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SMARTDMA_CLK_MASK)
/*! @} */

/*! @name PSCCTL1 - Clock Control 1 */
/*! @{ */
#define CLKCTL0_PSCCTL1_SDIO0_CLK_MASK           (0x4U)
#define CLKCTL0_PSCCTL1_SDIO0_CLK_SHIFT          (2U)
/*! SDIO0_CLK - SDIO0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_SDIO0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SDIO0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SDIO1_CLK_MASK           (0x8U)
#define CLKCTL0_PSCCTL1_SDIO1_CLK_SHIFT          (3U)
/*! SDIO1_CLK - SDIO1 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_SDIO1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SDIO1_CLK_MASK)
#define CLKCTL0_PSCCTL1_ACMP0_CLK_MASK           (0x8000U)
#define CLKCTL0_PSCCTL1_ACMP0_CLK_SHIFT          (15U)
/*! ACMP0_CLK - ACMP0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_ACMP0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_ACMP0_CLK_MASK)
#define CLKCTL0_PSCCTL1_ADC0_CLK_MASK            (0x10000U)
#define CLKCTL0_PSCCTL1_ADC0_CLK_SHIFT           (16U)
/*! ADC0_CLK - ADC0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_ADC0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_ADC0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK_MASK        (0x1000000U)
#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK_SHIFT       (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2 - Clock Control 2 */
/*! @{ */
#define CLKCTL0_PSCCTL2_UTICK0_CLK_MASK          (0x1U)
#define CLKCTL0_PSCCTL2_UTICK0_CLK_SHIFT         (0U)
/*! UTICK0_CLK - Micro-Tick Timer 0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL2_UTICK0_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_UTICK0_CLK_MASK)
#define CLKCTL0_PSCCTL2_WWDT0_CLK_MASK           (0x2U)
#define CLKCTL0_PSCCTL2_WWDT0_CLK_SHIFT          (1U)
/*! WWDT0_CLK - Watchdog Timer 0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL2_WWDT0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_WWDT0_CLK_MASK)
#define CLKCTL0_PSCCTL2_PMC_CLK_MASK             (0x20000000U)
#define CLKCTL0_PSCCTL2_PMC_CLK_SHIFT            (29U)
/*! PMC_CLK - Power Management Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL2_PMC_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_PMC_CLK_SHIFT)) & CLKCTL0_PSCCTL2_PMC_CLK_MASK)
/*! @} */

/*! @name PSCCTL0_SET - Clock Control 0 Set */
/*! @{ */
#define CLKCTL0_PSCCTL0_SET_DSP_CLK_MASK         (0x2U)
#define CLKCTL0_PSCCTL0_SET_DSP_CLK_SHIFT        (1U)
/*! DSP_CLK - DSP clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_DSP_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_DSP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_DSP_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK_MASK   (0x4U)
#define CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK_SHIFT  (2U)
/*! ROM_CTRLR_CLK - 128KB ROM Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK_MASK  (0x8U)
#define CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK_SHIFT (3U)
/*! AXI_SWITCH_CLK - AXI Switch clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK_MASK    (0x10U)
#define CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK_SHIFT   (4U)
/*! AXI_CTLR_CLK - AXI Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_MASK   (0x100U)
#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_SHIFT  (8U)
/*! POWERQUAD_CLK - POWERQUAD clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_CASPER_CLK_MASK      (0x200U)
#define CLKCTL0_PSCCTL0_SET_CASPER_CLK_SHIFT     (9U)
/*! CASPER_CLK - CASPER clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_CASPER_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_CASPER_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_MASK   (0x400U)
#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_SHIFT  (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_PUF_CLK_MASK         (0x800U)
#define CLKCTL0_PSCCTL0_SET_PUF_CLK_SHIFT        (11U)
/*! PUF_CLK - PUF clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_PUF_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_PUF_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_RNG_CLK_MASK         (0x1000U)
#define CLKCTL0_PSCCTL0_SET_RNG_CLK_SHIFT        (12U)
/*! RNG_CLK - Random Number Generator (RNG) clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_RNG_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_RNG_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK_MASK (0x10000U)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK_SHIFT (16U)
/*! FLEXSPI0_OTFAD_CLK - FLEXSPI0 / OTFAD clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK_MASK    (0x20000U)
#define CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK_SHIFT   (17U)
/*! OTP_CTLR_CLK - OTP Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK_MASK    (0x40000U)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK_SHIFT   (18U)
/*! FLEXSPI1_CLK - FLEXSPI1 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_MASK   (0x100000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_SHIFT  (20U)
/*! USBHS_PHY_CLK - USB HS PHY clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_MASK (0x200000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_SHIFT (21U)
/*! USBHS_DEVICE_CLK - USB HS Device clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_MASK  (0x400000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_SHIFT (22U)
/*! USBHS_HOST_CLK - USB HS Host clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_MASK  (0x800000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_SHIFT (23U)
/*! USBHS_SRAM_CLK - USB HS SRAM clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_SCT_CLK_MASK         (0x1000000U)
#define CLKCTL0_PSCCTL0_SET_SCT_CLK_SHIFT        (24U)
/*! SCT_CLK - SCT clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_SCT_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_SCT_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_GPU_CLK_MASK         (0x4000000U)
#define CLKCTL0_PSCCTL0_SET_GPU_CLK_SHIFT        (26U)
/*! GPU_CLK - GPU clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_GPU_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_GPU_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_GPU_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK_MASK (0x8000000U)
#define CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK_SHIFT (27U)
/*! DISPLAY_CTLR_CLK - Display Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK_MASK (0x10000000U)
#define CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK_SHIFT (28U)
/*! MIPI_DSI_CTLR_CLK - MIPI-DSI Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK_MASK    (0x40000000U)
#define CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK_SHIFT   (30U)
/*! SMARTDMA_CLK - Smart DMA clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK_MASK)
/*! @} */

/*! @name PSCCTL1_SET - Clock Control 1 Set */
/*! @{ */
#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK_MASK       (0x4U)
#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK_SHIFT      (2U)
/*! SDIO0_CLK - SDIO0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SDIO0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK_MASK       (0x8U)
#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK_SHIFT      (3U)
/*! SDIO1_CLK - SDIO1 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SDIO1_CLK_MASK)
#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK_MASK       (0x8000U)
#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK_SHIFT      (15U)
/*! ACMP0_CLK - ACMP0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_ACMP0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SET_ADC0_CLK_MASK        (0x10000U)
#define CLKCTL0_PSCCTL1_SET_ADC0_CLK_SHIFT       (16U)
/*! ADC0_CLK - ADC0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_ADC0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_ADC0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_MASK    (0x1000000U)
#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_SHIFT   (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_SET - Clock Control 2 Set */
/*! @{ */
#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK_MASK      (0x1U)
#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK_SHIFT     (0U)
/*! UTICK0_CLK - Micro-Tick Timer 0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_SET_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_SET_UTICK0_CLK_MASK)
#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK_MASK       (0x2U)
#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK_SHIFT      (1U)
/*! WWDT0_CLK - Watchdog Timer 0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_SET_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_SET_WWDT0_CLK_MASK)
#define CLKCTL0_PSCCTL2_SET_PMC_MASK             (0x20000000U)
#define CLKCTL0_PSCCTL2_SET_PMC_SHIFT            (29U)
/*! PMC - Power Management Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_SET_PMC(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_SET_PMC_SHIFT)) & CLKCTL0_PSCCTL2_SET_PMC_MASK)
/*! @} */

/*! @name PSCCTL0_CLR - Clock Control 0 Clear */
/*! @{ */
#define CLKCTL0_PSCCTL0_CLR_DSP_CLK_MASK         (0x2U)
#define CLKCTL0_PSCCTL0_CLR_DSP_CLK_SHIFT        (1U)
/*! DSP_CLK - DSP clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_DSP_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_DSP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_DSP_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK_MASK   (0x4U)
#define CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK_SHIFT  (2U)
/*! ROM_CTRLR_CLK - 128KB ROM Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK_MASK  (0x8U)
#define CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK_SHIFT (3U)
/*! AXI_SWITCH_CLK - AXI Switch clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK_MASK    (0x10U)
#define CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK_SHIFT   (4U)
/*! AXI_CTLR_CLK - AXI Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_MASK   (0x100U)
#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_SHIFT  (8U)
/*! POWERQUAD_CLK - POWERQUAD clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK_MASK      (0x200U)
#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK_SHIFT     (9U)
/*! CASPER_CLK - CASPER clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_CASPER_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_MASK   (0x400U)
#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_SHIFT  (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_PUF_CLK_MASK         (0x800U)
#define CLKCTL0_PSCCTL0_CLR_PUF_CLK_SHIFT        (11U)
/*! PUF_CLK - PUF clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_PUF_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_PUF_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_RNG_CLK_MASK         (0x1000U)
#define CLKCTL0_PSCCTL0_CLR_RNG_CLK_SHIFT        (12U)
/*! RNG_CLK - RNG clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_RNG_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_RNG_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK_MASK (0x10000U)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK_SHIFT (16U)
/*! FLEXSPI0_OTFAD_CLK - FLEXSPI0 / OTFAD clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK_MASK    (0x20000U)
#define CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK_SHIFT   (17U)
/*! OTP_CTLR_CLK - OTP Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK_MASK    (0x40000U)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK_SHIFT   (18U)
/*! FLEXSPI1_CLK - FLEXSPI1 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_MASK   (0x100000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_SHIFT  (20U)
/*! USBHS_PHY_CLK - USB HS PHY clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_MASK (0x200000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_SHIFT (21U)
/*! USBHS_DEVICE_CLK - USB HS Device clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_MASK  (0x400000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_SHIFT (22U)
/*! USBHS_HOST_CLK - USB HS Host clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_MASK  (0x800000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_SHIFT (23U)
/*! USBHS_SRAM_CLK - USB HS SRAM clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_SCT_CLK_MASK         (0x1000000U)
#define CLKCTL0_PSCCTL0_CLR_SCT_CLK_SHIFT        (24U)
/*! SCT_CLK - SCT clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_SCT_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_SCT_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_GPU_CLK_MASK         (0x4000000U)
#define CLKCTL0_PSCCTL0_CLR_GPU_CLK_SHIFT        (26U)
/*! GPU_CLK - GPU clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_GPU_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_GPU_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_GPU_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK_MASK (0x8000000U)
#define CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK_SHIFT (27U)
/*! DISPLAY_CTLR_CLK - Display Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK_MASK (0x10000000U)
#define CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK_SHIFT (28U)
/*! MIPI_DSI_CTLR_CLK - MIPI-DSI Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK_MASK    (0x40000000U)
#define CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK_SHIFT   (30U)
/*! SMARTDMA_CLK - Smart DMA clock set
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK_MASK)
/*! @} */

/*! @name PSCCTL1_CLR - Clock Control 1 Clear */
/*! @{ */
#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_MASK       (0x4U)
#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_SHIFT      (2U)
/*! SDIO0_CLK - SDIO0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_MASK)
#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_MASK       (0x8U)
#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_SHIFT      (3U)
/*! SDIO1_CLK - SDIO1 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_MASK)
#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_MASK       (0x8000U)
#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_SHIFT      (15U)
/*! ACMP0_CLK - ACMP0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_MASK)
#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK_MASK        (0x10000U)
#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK_SHIFT       (16U)
/*! ADC0_CLK - ADC0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_ADC0_CLK_MASK)
#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_MASK    (0x1000000U)
#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_SHIFT   (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_CLR - Clock Control 2 Clear */
/*! @{ */
#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_MASK      (0x1U)
#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_SHIFT     (0U)
/*! UTICK0_CLK - Micro-Tick Timer 0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_MASK)
#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_MASK       (0x2U)
#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_SHIFT      (1U)
/*! WWDT0_CLK - Watchdog Timer 0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_MASK)
#define CLKCTL0_PSCCTL2_CLR_PMC_CLK_MASK         (0x20000000U)
#define CLKCTL0_PSCCTL2_CLR_PMC_CLK_SHIFT        (29U)
/*! PMC_CLK - Power Management Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_CLR_PMC_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_CLR_PMC_CLK_SHIFT)) & CLKCTL0_PSCCTL2_CLR_PMC_CLK_MASK)
/*! @} */

/*! @name FRO_CONTROL - Free Running Oscillator Control */
/*! @{ */
#define CLKCTL0_FRO_CONTROL_EXP_COUNT_MASK       (0xFFFFU)
#define CLKCTL0_FRO_CONTROL_EXP_COUNT_SHIFT      (0U)
/*! EXP_COUNT - Expected Count
 */
#define CLKCTL0_FRO_CONTROL_EXP_COUNT(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CONTROL_EXP_COUNT_SHIFT)) & CLKCTL0_FRO_CONTROL_EXP_COUNT_MASK)
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP_MASK (0x1F0000U)
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP_SHIFT (16U)
/*! THRESH_RANGE_UP - Threshold Range Upper Limit
 */
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP_SHIFT)) & CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP_MASK)
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW_MASK (0x3E00000U)
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW_SHIFT (21U)
/*! THRESH_RANGE_LOW - Threshold Range Lower Limit
 */
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW_SHIFT)) & CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW_MASK)
#define CLKCTL0_FRO_CONTROL_ENA_TUNE_MASK        (0x80000000U)
#define CLKCTL0_FRO_CONTROL_ENA_TUNE_SHIFT       (31U)
/*! ENA_TUNE - Enable Tuning
 *  0b0..Stop tuning
 *  0b1..Start tuning
 */
#define CLKCTL0_FRO_CONTROL_ENA_TUNE(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CONTROL_ENA_TUNE_SHIFT)) & CLKCTL0_FRO_CONTROL_ENA_TUNE_MASK)
/*! @} */

/*! @name FRO_CAPVAL - Free Running Oscillator Captured Value */
/*! @{ */
#define CLKCTL0_FRO_CAPVAL_CAPVAL_MASK           (0xFFFFU)
#define CLKCTL0_FRO_CAPVAL_CAPVAL_SHIFT          (0U)
/*! CAPVAL - Captured Value
 */
#define CLKCTL0_FRO_CAPVAL_CAPVAL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CAPVAL_CAPVAL_SHIFT)) & CLKCTL0_FRO_CAPVAL_CAPVAL_MASK)
#define CLKCTL0_FRO_CAPVAL_DATA_VALID_MASK       (0x80000000U)
#define CLKCTL0_FRO_CAPVAL_DATA_VALID_SHIFT      (31U)
/*! DATA_VALID - Data Valid
 *  0b0..CAPVAL data is not valid
 *  0b1..CAPVAL data is valid
 */
#define CLKCTL0_FRO_CAPVAL_DATA_VALID(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CAPVAL_DATA_VALID_SHIFT)) & CLKCTL0_FRO_CAPVAL_DATA_VALID_MASK)
/*! @} */

/*! @name FRO_RDTRIM - Free Running Oscillator Trim */
/*! @{ */
#define CLKCTL0_FRO_RDTRIM_TRIM_MASK             (0x7FFU)
#define CLKCTL0_FRO_RDTRIM_TRIM_SHIFT            (0U)
/*! TRIM - It is the trim value supplied to the oscillator
 */
#define CLKCTL0_FRO_RDTRIM_TRIM(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_RDTRIM_TRIM_SHIFT)) & CLKCTL0_FRO_RDTRIM_TRIM_MASK)
/*! @} */

/*! @name FRO_SCTRIM - Free Running OscillatorSC Trim */
/*! @{ */
#define CLKCTL0_FRO_SCTRIM_TRIM_MASK             (0x7FFU)
#define CLKCTL0_FRO_SCTRIM_TRIM_SHIFT            (0U)
/*! TRIM - sc_trim value for the oscillator.
 */
#define CLKCTL0_FRO_SCTRIM_TRIM(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_SCTRIM_TRIM_SHIFT)) & CLKCTL0_FRO_SCTRIM_TRIM_MASK)
/*! @} */

/*! @name FRODIVSEL - FRO Clock Divider */
/*! @{ */
#define CLKCTL0_FRODIVSEL_SEL_MASK               (0x3U)
#define CLKCTL0_FRODIVSEL_SEL_SHIFT              (0U)
/*! SEL - Select clock
 *  0b00..FRO_DIV2
 *  0b01..FRO_DIV4
 *  0b10..FRO_DIV8
 *  0b11..FRO_DIV16
 */
#define CLKCTL0_FRODIVSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVSEL_SEL_SHIFT)) & CLKCTL0_FRODIVSEL_SEL_MASK)
/*! @} */

/*! @name FROCLKSTATUS - FRO Clock Status */
/*! @{ */
#define CLKCTL0_FROCLKSTATUS_CLK_OK_MASK         (0x1U)
#define CLKCTL0_FROCLKSTATUS_CLK_OK_SHIFT        (0U)
/*! CLK_OK - FRO Clock OK
 *  0b0..FRO clock has not yet reached its final frequency
 *  0b1..FRO clock has reached its final frequency
 */
#define CLKCTL0_FROCLKSTATUS_CLK_OK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FROCLKSTATUS_CLK_OK_SHIFT)) & CLKCTL0_FROCLKSTATUS_CLK_OK_MASK)
/*! @} */

/*! @name FRODIVOEN - FRO Enable Register */
/*! @{ */
#define CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN_MASK     (0x1U)
#define CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN_SHIFT    (0U)
/*! FRO_DIV1_O_EN - FRO Divided-by-1 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN_MASK)
#define CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN_MASK     (0x2U)
#define CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN_SHIFT    (1U)
/*! FRO_DIV2_O_EN - FRO Divided-by-2 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN_MASK)
#define CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN_MASK     (0x4U)
#define CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN_SHIFT    (2U)
/*! FRO_DIV4_O_EN - FRO Divided-by-4 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN_MASK)
#define CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN_MASK     (0x8U)
#define CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN_SHIFT    (3U)
/*! FRO_DIV8_O_EN - FRO Divided-by-8 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN_MASK)
#define CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN_MASK    (0x10U)
#define CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN_SHIFT   (4U)
/*! FRO_DIV16_O_EN - FRO Divided-by-16 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN_MASK)
/*! @} */

/*! @name LOWFREQCLKDIV - Low Frequency Clock Divider */
/*! @{ */
#define CLKCTL0_LOWFREQCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_LOWFREQCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Low Frequency Clock Divider Value
 */
#define CLKCTL0_LOWFREQCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LOWFREQCLKDIV_DIV_SHIFT)) & CLKCTL0_LOWFREQCLKDIV_DIV_MASK)
#define CLKCTL0_LOWFREQCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_LOWFREQCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_LOWFREQCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LOWFREQCLKDIV_RESET_SHIFT)) & CLKCTL0_LOWFREQCLKDIV_RESET_MASK)
#define CLKCTL0_LOWFREQCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_LOWFREQCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_LOWFREQCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LOWFREQCLKDIV_HALT_SHIFT)) & CLKCTL0_LOWFREQCLKDIV_HALT_MASK)
#define CLKCTL0_LOWFREQCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_LOWFREQCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished
 *  0b1..The Divider value has changed
 */
#define CLKCTL0_LOWFREQCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LOWFREQCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_LOWFREQCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SYSOSCCTL0 - System Oscillator Control 0 */
/*! @{ */
#define CLKCTL0_SYSOSCCTL0_LP_ENABLE_MASK        (0x1U)
#define CLKCTL0_SYSOSCCTL0_LP_ENABLE_SHIFT       (0U)
/*! LP_ENABLE - Low Power Mode Enable
 *  0b0..Enable High Gain Mode (HP)
 *  0b1..Enable Low Power mode (LP)
 */
#define CLKCTL0_SYSOSCCTL0_LP_ENABLE(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCCTL0_LP_ENABLE_SHIFT)) & CLKCTL0_SYSOSCCTL0_LP_ENABLE_MASK)
#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_MASK    (0x2U)
#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_SHIFT   (1U)
/*! BYPASS_ENABLE - Bypass Enable
 *  0b0..Enable Normal mode. Oscillation with crystal connected.
 *  0b1..Enable Bypass mode. In this mode a clock can be directly input into the XTALIN pin.
 */
#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_SHIFT)) & CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_MASK)
/*! @} */

/*! @name SYSOSCBYPASS - OSC Clock Source Select */
/*! @{ */
#define CLKCTL0_SYSOSCBYPASS_SEL_MASK            (0x7U)
#define CLKCTL0_SYSOSCBYPASS_SEL_SHIFT           (0U)
/*! SEL - Select SYSOSC Bypass
 *  0b000..Select OSC Clock
 *  0b001..Select Clock IN clock
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed
 */
#define CLKCTL0_SYSOSCBYPASS_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCBYPASS_SEL_SHIFT)) & CLKCTL0_SYSOSCBYPASS_SEL_MASK)
/*! @} */

/*! @name LPOSCCTL0 - Low Power Oscillator Control 0 */
/*! @{ */
#define CLKCTL0_LPOSCCTL0_CLKRDY_MASK            (0x80000000U)
#define CLKCTL0_LPOSCCTL0_CLKRDY_SHIFT           (31U)
/*! CLKRDY - LPOSC Clock Ready
 *  0b0..LPOSC clock is not ready
 *  0b1..LPOSC clock is ready
 */
#define CLKCTL0_LPOSCCTL0_CLKRDY(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LPOSCCTL0_CLKRDY_SHIFT)) & CLKCTL0_LPOSCCTL0_CLKRDY_MASK)
/*! @} */

/*! @name OSC32KHZCTL0 - 32 KHz Oscillator Control 0 */
/*! @{ */
#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ_MASK       (0x1U)
#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ_SHIFT      (0U)
/*! ENA32KHZ - 32 KHz Oscillator Enable
 *  0b0..Disable oscillator
 *  0b1..Enable oscillator
 */
#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_OSC32KHZCTL0_ENA32KHZ_SHIFT)) & CLKCTL0_OSC32KHZCTL0_ENA32KHZ_MASK)
/*! @} */

/*! @name SYSPLL0CLKSEL - System PLL 0 Clock Select */
/*! @{ */
#define CLKCTL0_SYSPLL0CLKSEL_SEL_MASK           (0x7U)
#define CLKCTL0_SYSPLL0CLKSEL_SEL_SHIFT          (0U)
/*! SEL - System PLL0 Reference Input Clock Source
 *  0b000..FRO_DIV8 Clock
 *  0b001..OSC_CLK clock
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL0_SYSPLL0CLKSEL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CLKSEL_SEL_SHIFT)) & CLKCTL0_SYSPLL0CLKSEL_SEL_MASK)
/*! @} */

/*! @name SYSPLL0CTL0 - System PLL0 Control 0 */
/*! @{ */
#define CLKCTL0_SYSPLL0CTL0_BYPASS_MASK          (0x1U)
#define CLKCTL0_SYSPLL0CTL0_BYPASS_SHIFT         (0U)
/*! BYPASS - SYSPLL0 BYPASS Mode
 *  0b0..PFD outputs are PFD-programmed clocks
 *  0b1..Bypass Mode: PFD outputs are sourced directly from rhe reference input clock
 */
#define CLKCTL0_SYSPLL0CTL0_BYPASS(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_BYPASS_SHIFT)) & CLKCTL0_SYSPLL0CTL0_BYPASS_MASK)
#define CLKCTL0_SYSPLL0CTL0_RESET_MASK           (0x2U)
#define CLKCTL0_SYSPLL0CTL0_RESET_SHIFT          (1U)
/*! RESET - SYSPLL0 Reset
 *  0b0..SYSPLL0 reset is removed
 *  0b1..SYSPLL0 is placed into reset
 */
#define CLKCTL0_SYSPLL0CTL0_RESET(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_RESET_SHIFT)) & CLKCTL0_SYSPLL0CTL0_RESET_MASK)
#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_MASK (0x2000U)
#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_SHIFT (13U)
/*! HOLDRINGOFF_ENA - Hold Ring Off Control
 *  0b0..Disable
 *  0b1..Enable
 */
#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_SHIFT)) & CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_MASK)
#define CLKCTL0_SYSPLL0CTL0_MULT_MASK            (0xFF0000U)
#define CLKCTL0_SYSPLL0CTL0_MULT_SHIFT           (16U)
/*! MULT - Multiplication Factor
 *  0b00010000..Divide by 16
 *  0b00010001..Divide by 17
 *  0b00010010..Divide by 18
 *  0b00010011..Divide by 19
 *  0b00010100..Divide by 20
 *  0b00010101..Divide by 21
 *  0b00010110..Divide by 22
 */
#define CLKCTL0_SYSPLL0CTL0_MULT(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_MULT_SHIFT)) & CLKCTL0_SYSPLL0CTL0_MULT_MASK)
/*! @} */

/*! @name SYSPLL0LOCKTIMEDIV2 - System PLL0 Lock Time Div2 */
/*! @{ */
#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK (0xFFFFU)
#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT (0U)
/*! LOCKTIMEDIV2 - SYSPLL0 Lock Time Divide-by-2
 */
#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT)) & CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK)
/*! @} */

/*! @name SYSPLL0NUM - System PLL0 Numerator */
/*! @{ */
#define CLKCTL0_SYSPLL0NUM_NUM_MASK              (0x3FFFFFFFU)
#define CLKCTL0_SYSPLL0NUM_NUM_SHIFT             (0U)
/*! NUM - Numerator of the SYSPLL0 fractional loop divider
 */
#define CLKCTL0_SYSPLL0NUM_NUM(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0NUM_NUM_SHIFT)) & CLKCTL0_SYSPLL0NUM_NUM_MASK)
/*! @} */

/*! @name SYSPLL0DENOM - System PLL0 Denominator */
/*! @{ */
#define CLKCTL0_SYSPLL0DENOM_DENOM_MASK          (0x3FFFFFFFU)
#define CLKCTL0_SYSPLL0DENOM_DENOM_SHIFT         (0U)
/*! DENOM - Denominator of the SYSPLL0 fractional loop divider
 */
#define CLKCTL0_SYSPLL0DENOM_DENOM(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0DENOM_DENOM_SHIFT)) & CLKCTL0_SYSPLL0DENOM_DENOM_MASK)
/*! @} */

/*! @name SYSPLL0PFD - System PLL0 PFD */
/*! @{ */
#define CLKCTL0_SYSPLL0PFD_PFD0_MASK             (0x3FU)
#define CLKCTL0_SYSPLL0PFD_PFD0_SHIFT            (0U)
/*! PFD0 - PLL Fractional Divider 0
 */
#define CLKCTL0_SYSPLL0PFD_PFD0(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_MASK      (0x40U)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_SHIFT     (6U)
/*! PFD0_CLKRDY - PFD0 Clock Ready Status Flag
 *  0b0..PFD0 clock is not ready
 *  0b1..PFD0 clock is ready
 */
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_MASK     (0x80U)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_SHIFT    (7U)
/*! PFD0_CLKGATE - PFD0 Clock Gate
 *  0b0..PFD0 clock is not gated
 *  0b1..PFD0 clock is gated
 */
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD1_MASK             (0x3F00U)
#define CLKCTL0_SYSPLL0PFD_PFD1_SHIFT            (8U)
/*! PFD1 - PLL Fractional Divider 1
 */
#define CLKCTL0_SYSPLL0PFD_PFD1(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_MASK      (0x4000U)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_SHIFT     (14U)
/*! PFD1_CLKRDY - PFD1 Clock Ready Status Flag
 *  0b0..PFD1 clock is not ready
 *  0b1..PFD1 clock is ready
 */
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_MASK     (0x8000U)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_SHIFT    (15U)
/*! PFD1_CLKGATE - PFD1 Clock Gate
 *  0b0..PFD1 clock is not gated
 *  0b1..PFD1 clock is gated
 */
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD2_MASK             (0x3F0000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_SHIFT            (16U)
/*! PFD2 - PLL Fractional Divider 2
 */
#define CLKCTL0_SYSPLL0PFD_PFD2(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_MASK      (0x400000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_SHIFT     (22U)
/*! PFD2_CLKRDY - PFD2 Clock Ready Status Flag
 *  0b0..PFD2 clock is not ready
 *  0b1..PFD2 clock is ready
 */
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_MASK     (0x800000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_SHIFT    (23U)
/*! PFD2_CLKGATE - PFD2 Clock Gate
 *  0b0..PFD2 clock is not gated
 *  0b1..PFD2 clock is gated
 */
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD3_MASK             (0x3F000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_SHIFT            (24U)
/*! PFD3 - PLL Fractional Divider 3
 */
#define CLKCTL0_SYSPLL0PFD_PFD3(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_MASK      (0x40000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_SHIFT     (30U)
/*! PFD3_CLKRDY - PFD3 Clock Ready Status Flag
 *  0b0..PFD3 clock is not ready
 *  0b1..PFD3 clock is ready
 */
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_MASK     (0x80000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_SHIFT    (31U)
/*! PFD3_CLKGATE - PFD3 Clock Gate
 *  0b0..PFD3 clock is not gated
 *  0b1..PFD3 clock is gated
 */
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_MASK)
/*! @} */

/*! @name MAINPLLCLKDIV - Main PLL Clock Divider */
/*! @{ */
#define CLKCTL0_MAINPLLCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_MAINPLLCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Low Frequency Clock Divider Value
 */
#define CLKCTL0_MAINPLLCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINPLLCLKDIV_DIV_SHIFT)) & CLKCTL0_MAINPLLCLKDIV_DIV_MASK)
#define CLKCTL0_MAINPLLCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_MAINPLLCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Resets the divider counter
 */
#define CLKCTL0_MAINPLLCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINPLLCLKDIV_RESET_SHIFT)) & CLKCTL0_MAINPLLCLKDIV_RESET_MASK)
#define CLKCTL0_MAINPLLCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_MAINPLLCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halts the divider counter
 */
#define CLKCTL0_MAINPLLCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINPLLCLKDIV_HALT_SHIFT)) & CLKCTL0_MAINPLLCLKDIV_HALT_MASK)
#define CLKCTL0_MAINPLLCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_MAINPLLCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag
 */
#define CLKCTL0_MAINPLLCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_MAINPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DSPPLLCLKDIV - DSP PLL Clock Divider */
/*! @{ */
#define CLKCTL0_DSPPLLCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_DSPPLLCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Low Frequency Clock Divider Value
 */
#define CLKCTL0_DSPPLLCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DSPPLLCLKDIV_DIV_SHIFT)) & CLKCTL0_DSPPLLCLKDIV_DIV_MASK)
#define CLKCTL0_DSPPLLCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_DSPPLLCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter
 */
#define CLKCTL0_DSPPLLCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DSPPLLCLKDIV_RESET_SHIFT)) & CLKCTL0_DSPPLLCLKDIV_RESET_MASK)
#define CLKCTL0_DSPPLLCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_DSPPLLCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter
 */
#define CLKCTL0_DSPPLLCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DSPPLLCLKDIV_HALT_SHIFT)) & CLKCTL0_DSPPLLCLKDIV_HALT_MASK)
#define CLKCTL0_DSPPLLCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_DSPPLLCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 */
#define CLKCTL0_DSPPLLCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DSPPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DSPPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name AUX0PLLCLKDIV - AUX0 PLL Clock Divider */
/*! @{ */
#define CLKCTL0_AUX0PLLCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_AUX0PLLCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Low Frequency Clock Divider Value
 */
#define CLKCTL0_AUX0PLLCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX0PLLCLKDIV_DIV_SHIFT)) & CLKCTL0_AUX0PLLCLKDIV_DIV_MASK)
#define CLKCTL0_AUX0PLLCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_AUX0PLLCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Resets the divider counter
 */
#define CLKCTL0_AUX0PLLCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX0PLLCLKDIV_RESET_SHIFT)) & CLKCTL0_AUX0PLLCLKDIV_RESET_MASK)
#define CLKCTL0_AUX0PLLCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_AUX0PLLCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halts the divider counter
 */
#define CLKCTL0_AUX0PLLCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX0PLLCLKDIV_HALT_SHIFT)) & CLKCTL0_AUX0PLLCLKDIV_HALT_MASK)
#define CLKCTL0_AUX0PLLCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_AUX0PLLCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag
 */
#define CLKCTL0_AUX0PLLCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX0PLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_AUX0PLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name AUX1PLLCLKDIV - AUX1 PLL Clock Divider */
/*! @{ */
#define CLKCTL0_AUX1PLLCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_AUX1PLLCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Low Frequency Clock Divider Value
 */
#define CLKCTL0_AUX1PLLCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX1PLLCLKDIV_DIV_SHIFT)) & CLKCTL0_AUX1PLLCLKDIV_DIV_MASK)
#define CLKCTL0_AUX1PLLCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_AUX1PLLCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Resets the divider counter
 */
#define CLKCTL0_AUX1PLLCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX1PLLCLKDIV_RESET_SHIFT)) & CLKCTL0_AUX1PLLCLKDIV_RESET_MASK)
#define CLKCTL0_AUX1PLLCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_AUX1PLLCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halts the divider counter
 */
#define CLKCTL0_AUX1PLLCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX1PLLCLKDIV_HALT_SHIFT)) & CLKCTL0_AUX1PLLCLKDIV_HALT_MASK)
#define CLKCTL0_AUX1PLLCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_AUX1PLLCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag
 */
#define CLKCTL0_AUX1PLLCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX1PLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_AUX1PLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SYSCPUAHBCLKDIV - System CPU AHB Clock Divider */
/*! @{ */
#define CLKCTL0_SYSCPUAHBCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_SYSCPUAHBCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SYSCPUAHBCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSCPUAHBCLKDIV_DIV_SHIFT)) & CLKCTL0_SYSCPUAHBCLKDIV_DIV_MASK)
#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name MAINCLKSELA - Main Clock Select A */
/*! @{ */
#define CLKCTL0_MAINCLKSELA_SEL_MASK             (0x3U)
#define CLKCTL0_MAINCLKSELA_SEL_SHIFT            (0U)
/*! SEL - Control Main 1st Stage Control Clock Source
 *  0b00..Low Power Oscillator Clock (LPOSC)
 *  0b01..FRODIV which is the output of the FRODIVSEL mux
 *  0b10..OSC_CLK clock
 *  0b11..FRO_DIV1 clock
 */
#define CLKCTL0_MAINCLKSELA_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINCLKSELA_SEL_SHIFT)) & CLKCTL0_MAINCLKSELA_SEL_MASK)
/*! @} */

/*! @name MAINCLKSELB - Main Clock Select B */
/*! @{ */
#define CLKCTL0_MAINCLKSELB_SEL_MASK             (0x3U)
#define CLKCTL0_MAINCLKSELB_SEL_SHIFT            (0U)
/*! SEL - Main Clock Source Selection
 *  0b00..MAINCLKSELA 1st Stage Clock
 *  0b01..Main System PLL Clock
 *  0b10..RTC 32 KHz Clock
 *  0b11..Reserved
 */
#define CLKCTL0_MAINCLKSELB_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINCLKSELB_SEL_SHIFT)) & CLKCTL0_MAINCLKSELB_SEL_MASK)
/*! @} */

/*! @name PFCDIV - PFC divider 0 (trace clock)..PFC divider 1 (USB HS PHY bus clock) */
/*! @{ */
#define CLKCTL0_PFCDIV_DIV_MASK                  (0xFFU)
#define CLKCTL0_PFCDIV_DIV_SHIFT                 (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_PFCDIV_DIV(x)                    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_DIV_SHIFT)) & CLKCTL0_PFCDIV_DIV_MASK)
#define CLKCTL0_PFCDIV_RESET_MASK                (0x20000000U)
#define CLKCTL0_PFCDIV_RESET_SHIFT               (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_PFCDIV_RESET(x)                  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_RESET_SHIFT)) & CLKCTL0_PFCDIV_RESET_MASK)
#define CLKCTL0_PFCDIV_HALT_MASK                 (0x40000000U)
#define CLKCTL0_PFCDIV_HALT_SHIFT                (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_PFCDIV_HALT(x)                   (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_HALT_SHIFT)) & CLKCTL0_PFCDIV_HALT_MASK)
#define CLKCTL0_PFCDIV_REQFLAG_MASK              (0x80000000U)
#define CLKCTL0_PFCDIV_REQFLAG_SHIFT             (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_PFCDIV_REQFLAG(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_REQFLAG_SHIFT)) & CLKCTL0_PFCDIV_REQFLAG_MASK)
/*! @} */

/* The count of CLKCTL0_PFCDIV */
#define CLKCTL0_PFCDIV_COUNT                     (2U)

/*! @name FLEXSPI0FCLKSEL - FlexSPI0 Functional Clock Select */
/*! @{ */
#define CLKCTL0_FLEXSPI0FCLKSEL_SEL_MASK         (0x7U)
#define CLKCTL0_FLEXSPI0FCLKSEL_SEL_SHIFT        (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO_DIV1 Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_FLEXSPI0FCLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKSEL_SEL_SHIFT)) & CLKCTL0_FLEXSPI0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name FLEXSPI0FCLKDIV - FlexSPI0 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_FLEXSPI0FCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_FLEXSPI0FCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_FLEXSPI0FCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKDIV_DIV_SHIFT)) & CLKCTL0_FLEXSPI0FCLKDIV_DIV_MASK)
#define CLKCTL0_FLEXSPI0FCLKDIV_RESET_MASK       (0x20000000U)
#define CLKCTL0_FLEXSPI0FCLKDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_FLEXSPI0FCLKDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKDIV_RESET_SHIFT)) & CLKCTL0_FLEXSPI0FCLKDIV_RESET_MASK)
#define CLKCTL0_FLEXSPI0FCLKDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_FLEXSPI0FCLKDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_FLEXSPI0FCLKDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKDIV_HALT_SHIFT)) & CLKCTL0_FLEXSPI0FCLKDIV_HALT_MASK)
#define CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name FLEXSPI1FCLKSEL - FlexSPI1 Functional Clock Select */
/*! @{ */
#define CLKCTL0_FLEXSPI1FCLKSEL_SEL_MASK         (0x7U)
#define CLKCTL0_FLEXSPI1FCLKSEL_SEL_SHIFT        (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO_DIV1 Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_FLEXSPI1FCLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKSEL_SEL_SHIFT)) & CLKCTL0_FLEXSPI1FCLKSEL_SEL_MASK)
/*! @} */

/*! @name FLEXSPI1FCLKDIV - FlexSPI1 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_FLEXSPI1FCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_FLEXSPI1FCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_FLEXSPI1FCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKDIV_DIV_SHIFT)) & CLKCTL0_FLEXSPI1FCLKDIV_DIV_MASK)
#define CLKCTL0_FLEXSPI1FCLKDIV_RESET_MASK       (0x20000000U)
#define CLKCTL0_FLEXSPI1FCLKDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_FLEXSPI1FCLKDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKDIV_RESET_SHIFT)) & CLKCTL0_FLEXSPI1FCLKDIV_RESET_MASK)
#define CLKCTL0_FLEXSPI1FCLKDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_FLEXSPI1FCLKDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_FLEXSPI1FCLKDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKDIV_HALT_SHIFT)) & CLKCTL0_FLEXSPI1FCLKDIV_HALT_MASK)
#define CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SCTFCLKSEL - SCT Functional Clock Select */
/*! @{ */
#define CLKCTL0_SCTFCLKSEL_SEL_MASK              (0x7U)
#define CLKCTL0_SCTFCLKSEL_SEL_SHIFT             (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO_DIV1 Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..AUDIO PLL Clock
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_SCTFCLKSEL_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTFCLKSEL_SEL_SHIFT)) & CLKCTL0_SCTFCLKSEL_SEL_MASK)
/*! @} */

/*! @name SCTIN7CLKDIV - SCT Functional Clock Divider */
/*! @{ */
#define CLKCTL0_SCTIN7CLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_SCTIN7CLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SCTIN7CLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTIN7CLKDIV_DIV_SHIFT)) & CLKCTL0_SCTIN7CLKDIV_DIV_MASK)
#define CLKCTL0_SCTIN7CLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_SCTIN7CLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_SCTIN7CLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTIN7CLKDIV_RESET_SHIFT)) & CLKCTL0_SCTIN7CLKDIV_RESET_MASK)
#define CLKCTL0_SCTIN7CLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_SCTIN7CLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_SCTIN7CLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTIN7CLKDIV_HALT_SHIFT)) & CLKCTL0_SCTIN7CLKDIV_HALT_MASK)
#define CLKCTL0_SCTIN7CLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_SCTIN7CLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SCTIN7CLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTIN7CLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SCTIN7CLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name USBHSFCLKSEL - High Speed USB Functional Clock Select */
/*! @{ */
#define CLKCTL0_USBHSFCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_USBHSFCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..OSC_CLK Clock
 *  0b001..Main Clock
 *  0b010..Reserved
 *  0b011..AUX0_PLL_CLOCK
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_USBHSFCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKSEL_SEL_SHIFT)) & CLKCTL0_USBHSFCLKSEL_SEL_MASK)
/*! @} */

/*! @name USBHSFCLKDIV - High Speed USB Functional Clock Divider */
/*! @{ */
#define CLKCTL0_USBHSFCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_USBHSFCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_USBHSFCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_DIV_SHIFT)) & CLKCTL0_USBHSFCLKDIV_DIV_MASK)
#define CLKCTL0_USBHSFCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_USBHSFCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_USBHSFCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_RESET_SHIFT)) & CLKCTL0_USBHSFCLKDIV_RESET_MASK)
#define CLKCTL0_USBHSFCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_USBHSFCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_USBHSFCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_HALT_SHIFT)) & CLKCTL0_USBHSFCLKDIV_HALT_MASK)
#define CLKCTL0_USBHSFCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_USBHSFCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_USBHSFCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_USBHSFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SDIO0FCLKSEL - SDIO0 Functional Clock Select */
/*! @{ */
#define CLKCTL0_SDIO0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_SDIO0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO_DIV2
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_SDIO0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKSEL_SEL_SHIFT)) & CLKCTL0_SDIO0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name SDIO0FCLKDIV - SDIO0 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_SDIO0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_SDIO0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SDIO0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_DIV_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_DIV_MASK)
#define CLKCTL0_SDIO0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_SDIO0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_SDIO0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_RESET_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_RESET_MASK)
#define CLKCTL0_SDIO0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_SDIO0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_SDIO0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_HALT_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_HALT_MASK)
#define CLKCTL0_SDIO0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_SDIO0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SDIO0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SDIO1FCLKSEL - SDIO1 Functional Clock Select */
/*! @{ */
#define CLKCTL0_SDIO1FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_SDIO1FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO_DIV2
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_SDIO1FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKSEL_SEL_SHIFT)) & CLKCTL0_SDIO1FCLKSEL_SEL_MASK)
/*! @} */

/*! @name SDIO1FCLKDIV - SDIO1 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_SDIO1FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_SDIO1FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SDIO1FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_DIV_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_DIV_MASK)
#define CLKCTL0_SDIO1FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_SDIO1FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_SDIO1FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_RESET_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_RESET_MASK)
#define CLKCTL0_SDIO1FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_SDIO1FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_SDIO1FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_HALT_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_HALT_MASK)
#define CLKCTL0_SDIO1FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_SDIO1FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SDIO1FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name ADC0FCLKSEL0 - ADC0 Functional Clock Select 0 */
/*! @{ */
#define CLKCTL0_ADC0FCLKSEL0_SEL_MASK            (0x7U)
#define CLKCTL0_ADC0FCLKSEL0_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..OSC_CLK Clock
 *  0b001..Low Power Oscillator Clock (LPOSC)
 *  0b010..FRO_DIV4
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_ADC0FCLKSEL0_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKSEL0_SEL_SHIFT)) & CLKCTL0_ADC0FCLKSEL0_SEL_MASK)
/*! @} */

/*! @name ADC0FCLKSEL1 - ADC0 Functional Clock Select 1 */
/*! @{ */
#define CLKCTL0_ADC0FCLKSEL1_SEL_MASK            (0x7U)
#define CLKCTL0_ADC0FCLKSEL1_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..ADC0FCLKSEL0 Multiplexed Output
 *  0b001..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..SYSPLL0 AUX1_PLL_Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_ADC0FCLKSEL1_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKSEL1_SEL_SHIFT)) & CLKCTL0_ADC0FCLKSEL1_SEL_MASK)
/*! @} */

/*! @name ADC0FCLKDIV - ADC0 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_ADC0FCLKDIV_DIV_MASK             (0xFFU)
#define CLKCTL0_ADC0FCLKDIV_DIV_SHIFT            (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_ADC0FCLKDIV_DIV(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_DIV_SHIFT)) & CLKCTL0_ADC0FCLKDIV_DIV_MASK)
#define CLKCTL0_ADC0FCLKDIV_RESET_MASK           (0x20000000U)
#define CLKCTL0_ADC0FCLKDIV_RESET_SHIFT          (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_ADC0FCLKDIV_RESET(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_RESET_SHIFT)) & CLKCTL0_ADC0FCLKDIV_RESET_MASK)
#define CLKCTL0_ADC0FCLKDIV_HALT_MASK            (0x40000000U)
#define CLKCTL0_ADC0FCLKDIV_HALT_SHIFT           (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_ADC0FCLKDIV_HALT(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_HALT_SHIFT)) & CLKCTL0_ADC0FCLKDIV_HALT_MASK)
#define CLKCTL0_ADC0FCLKDIV_REQFLAG_MASK         (0x80000000U)
#define CLKCTL0_ADC0FCLKDIV_REQFLAG_SHIFT        (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_ADC0FCLKDIV_REQFLAG(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_ADC0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name UTICKFCLKSEL - UTICK Functional Clock Select */
/*! @{ */
#define CLKCTL0_UTICKFCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_UTICKFCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..Reserved
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_UTICKFCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_UTICKFCLKSEL_SEL_SHIFT)) & CLKCTL0_UTICKFCLKSEL_SEL_MASK)
/*! @} */

/*! @name WDT0FCLKSEL - WDT0 Functional Clock Select */
/*! @{ */
#define CLKCTL0_WDT0FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL0_WDT0FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - Select Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..Reserved
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_WDT0FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_WDT0FCLKSEL_SEL_SHIFT)) & CLKCTL0_WDT0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name A32KHZWAKECLKSEL - 32 KHz Wake Clock Source Select */
/*! @{ */
#define CLKCTL0_A32KHZWAKECLKSEL_SEL_MASK        (0x7U)
#define CLKCTL0_A32KHZWAKECLKSEL_SEL_SHIFT       (0U)
/*! SEL - Select Clock Source
 *  0b000..32 KHz
 *  0b001..Low Power Oscillator Clock (LPOSC); divided by 32 by default
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_A32KHZWAKECLKSEL_SEL(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKSEL_SEL_SHIFT)) & CLKCTL0_A32KHZWAKECLKSEL_SEL_MASK)
/*! @} */

/*! @name A32KHZWAKECLKDIV - 32 KHz Wake Clock Divider */
/*! @{ */
#define CLKCTL0_A32KHZWAKECLKDIV_DIV_MASK        (0xFFU)
#define CLKCTL0_A32KHZWAKECLKDIV_DIV_SHIFT       (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_A32KHZWAKECLKDIV_DIV(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKDIV_DIV_SHIFT)) & CLKCTL0_A32KHZWAKECLKDIV_DIV_MASK)
#define CLKCTL0_A32KHZWAKECLKDIV_RESET_MASK      (0x20000000U)
#define CLKCTL0_A32KHZWAKECLKDIV_RESET_SHIFT     (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_A32KHZWAKECLKDIV_RESET(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKDIV_RESET_SHIFT)) & CLKCTL0_A32KHZWAKECLKDIV_RESET_MASK)
#define CLKCTL0_A32KHZWAKECLKDIV_HALT_MASK       (0x40000000U)
#define CLKCTL0_A32KHZWAKECLKDIV_HALT_SHIFT      (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_A32KHZWAKECLKDIV_HALT(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKDIV_HALT_SHIFT)) & CLKCTL0_A32KHZWAKECLKDIV_HALT_MASK)
#define CLKCTL0_A32KHZWAKECLKDIV_REQFLAG_MASK    (0x80000000U)
#define CLKCTL0_A32KHZWAKECLKDIV_REQFLAG_SHIFT   (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_A32KHZWAKECLKDIV_REQFLAG(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKDIV_REQFLAG_SHIFT)) & CLKCTL0_A32KHZWAKECLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SYSTICKFCLKSEL - SYSTICK Functional Clock Select */
/*! @{ */
#define CLKCTL0_SYSTICKFCLKSEL_SEL_MASK          (0x7U)
#define CLKCTL0_SYSTICKFCLKSEL_SEL_SHIFT         (0U)
/*! SEL - Select Clock Source
 *  0b000..Systick Divider Output Clock
 *  0b001..Low Power Oscillator Clock (LPOSC)
 *  0b010..32 KHz RTC Clock
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_SYSTICKFCLKSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKSEL_SEL_SHIFT)) & CLKCTL0_SYSTICKFCLKSEL_SEL_MASK)
/*! @} */

/*! @name SYSTICKFCLKDIV - SYSTICK Functional Clock Divider */
/*! @{ */
#define CLKCTL0_SYSTICKFCLKDIV_DIV_MASK          (0xFFU)
#define CLKCTL0_SYSTICKFCLKDIV_DIV_SHIFT         (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SYSTICKFCLKDIV_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_DIV_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_DIV_MASK)
#define CLKCTL0_SYSTICKFCLKDIV_RESET_MASK        (0x20000000U)
#define CLKCTL0_SYSTICKFCLKDIV_RESET_SHIFT       (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_SYSTICKFCLKDIV_RESET(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_RESET_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_RESET_MASK)
#define CLKCTL0_SYSTICKFCLKDIV_HALT_MASK         (0x40000000U)
#define CLKCTL0_SYSTICKFCLKDIV_HALT_SHIFT        (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_SYSTICKFCLKDIV_HALT(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_HALT_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_HALT_MASK)
#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG_MASK      (0x80000000U)
#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG_SHIFT     (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DPHYCLKSEL - MIPI-DSI PHY Clock Select */
/*! @{ */
#define CLKCTL0_DPHYCLKSEL_SEL_MASK              (0x7U)
#define CLKCTL0_DPHYCLKSEL_SEL_SHIFT             (0U)
/*! SEL - Select Clock Source
 *  0b000..FRO_DIV1 Clock
 *  0b001..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..SYSPLL0 AUX1_PLL_Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_DPHYCLKSEL_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKSEL_SEL_SHIFT)) & CLKCTL0_DPHYCLKSEL_SEL_MASK)
/*! @} */

/*! @name DPHYCLKDIV - MIPI-DSI PHY Clock Divider */
/*! @{ */
#define CLKCTL0_DPHYCLKDIV_DIV_MASK              (0xFFU)
#define CLKCTL0_DPHYCLKDIV_DIV_SHIFT             (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_DPHYCLKDIV_DIV(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKDIV_DIV_SHIFT)) & CLKCTL0_DPHYCLKDIV_DIV_MASK)
#define CLKCTL0_DPHYCLKDIV_RESET_MASK            (0x20000000U)
#define CLKCTL0_DPHYCLKDIV_RESET_SHIFT           (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_DPHYCLKDIV_RESET(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKDIV_RESET_SHIFT)) & CLKCTL0_DPHYCLKDIV_RESET_MASK)
#define CLKCTL0_DPHYCLKDIV_HALT_MASK             (0x40000000U)
#define CLKCTL0_DPHYCLKDIV_HALT_SHIFT            (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_DPHYCLKDIV_HALT(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKDIV_HALT_SHIFT)) & CLKCTL0_DPHYCLKDIV_HALT_MASK)
#define CLKCTL0_DPHYCLKDIV_REQFLAG_MASK          (0x80000000U)
#define CLKCTL0_DPHYCLKDIV_REQFLAG_SHIFT         (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_DPHYCLKDIV_REQFLAG(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DPHYCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DPHYESCCLKSEL - MIPI-DSI DPHY Escape Mode Clock Select */
/*! @{ */
#define CLKCTL0_DPHYESCCLKSEL_SEL_MASK           (0x7U)
#define CLKCTL0_DPHYESCCLKSEL_SEL_SHIFT          (0U)
/*! SEL - Select Clock Source
 *  0b000..FRO_DIV1 clock
 *  0b001..FRO_DIV16 Clock
 *  0b010..AUX0_PLL_CLK
 *  0b011..AUX1_PLL_CLK
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_DPHYESCCLKSEL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCCLKSEL_SEL_SHIFT)) & CLKCTL0_DPHYESCCLKSEL_SEL_MASK)
/*! @} */

/*! @name DPHYESCRXCLKDIV - MIPI-DSI DPHY Escape Mode Receive Clock Divider */
/*! @{ */
#define CLKCTL0_DPHYESCRXCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_DPHYESCRXCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_DPHYESCRXCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCRXCLKDIV_DIV_SHIFT)) & CLKCTL0_DPHYESCRXCLKDIV_DIV_MASK)
#define CLKCTL0_DPHYESCRXCLKDIV_RESET_MASK       (0x20000000U)
#define CLKCTL0_DPHYESCRXCLKDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_DPHYESCRXCLKDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCRXCLKDIV_RESET_SHIFT)) & CLKCTL0_DPHYESCRXCLKDIV_RESET_MASK)
#define CLKCTL0_DPHYESCRXCLKDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_DPHYESCRXCLKDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_DPHYESCRXCLKDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCRXCLKDIV_HALT_SHIFT)) & CLKCTL0_DPHYESCRXCLKDIV_HALT_MASK)
#define CLKCTL0_DPHYESCRXCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_DPHYESCRXCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_DPHYESCRXCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCRXCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DPHYESCRXCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DPHYESCTXCLKDIV - MIPI-DSI DPHY Escape Mode Tramsmit Clock Divider */
/*! @{ */
#define CLKCTL0_DPHYESCTXCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_DPHYESCTXCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_DPHYESCTXCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCTXCLKDIV_DIV_SHIFT)) & CLKCTL0_DPHYESCTXCLKDIV_DIV_MASK)
#define CLKCTL0_DPHYESCTXCLKDIV_RESET_MASK       (0x20000000U)
#define CLKCTL0_DPHYESCTXCLKDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_DPHYESCTXCLKDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCTXCLKDIV_RESET_SHIFT)) & CLKCTL0_DPHYESCTXCLKDIV_RESET_MASK)
#define CLKCTL0_DPHYESCTXCLKDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_DPHYESCTXCLKDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_DPHYESCTXCLKDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCTXCLKDIV_HALT_SHIFT)) & CLKCTL0_DPHYESCTXCLKDIV_HALT_MASK)
#define CLKCTL0_DPHYESCTXCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_DPHYESCTXCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_DPHYESCTXCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCTXCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DPHYESCTXCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name GPUCLKSEL - GPU Clock Select */
/*! @{ */
#define CLKCTL0_GPUCLKSEL_SEL_MASK               (0x7U)
#define CLKCTL0_GPUCLKSEL_SEL_SHIFT              (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..FRO_DIV1 clock
 *  0b010..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b011..SYSPLL0 AUX0_PLL_Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_GPUCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKSEL_SEL_SHIFT)) & CLKCTL0_GPUCLKSEL_SEL_MASK)
/*! @} */

/*! @name GPUCLKDIV - GPU Clock Divider */
/*! @{ */
#define CLKCTL0_GPUCLKDIV_DIV_MASK               (0xFFU)
#define CLKCTL0_GPUCLKDIV_DIV_SHIFT              (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_GPUCLKDIV_DIV(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKDIV_DIV_SHIFT)) & CLKCTL0_GPUCLKDIV_DIV_MASK)
#define CLKCTL0_GPUCLKDIV_RESET_MASK             (0x20000000U)
#define CLKCTL0_GPUCLKDIV_RESET_SHIFT            (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_GPUCLKDIV_RESET(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKDIV_RESET_SHIFT)) & CLKCTL0_GPUCLKDIV_RESET_MASK)
#define CLKCTL0_GPUCLKDIV_HALT_MASK              (0x40000000U)
#define CLKCTL0_GPUCLKDIV_HALT_SHIFT             (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_GPUCLKDIV_HALT(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKDIV_HALT_SHIFT)) & CLKCTL0_GPUCLKDIV_HALT_MASK)
#define CLKCTL0_GPUCLKDIV_REQFLAG_MASK           (0x80000000U)
#define CLKCTL0_GPUCLKDIV_REQFLAG_SHIFT          (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_GPUCLKDIV_REQFLAG(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_GPUCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DCPIXELCLKSEL - LCDIF Pixel Clock Select */
/*! @{ */
#define CLKCTL0_DCPIXELCLKSEL_SEL_MASK           (0x7U)
#define CLKCTL0_DCPIXELCLKSEL_SEL_SHIFT          (0U)
/*! SEL - Select Clock Source
 *  0b000..MIPI-DSI PHY Clock
 *  0b001..Main Clock
 *  0b010..FRO_DIV1 Clock
 *  0b011..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b100..SYSPLL0 AUX0_PLL_Clock
 *  0b101..SYSPLL0 AUX1_PLL_Clock
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_DCPIXELCLKSEL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKSEL_SEL_SHIFT)) & CLKCTL0_DCPIXELCLKSEL_SEL_MASK)
/*! @} */

/*! @name DCPIXELCLKDIV - LCDIF Pixel Clock Divider */
/*! @{ */
#define CLKCTL0_DCPIXELCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_DCPIXELCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_DCPIXELCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKDIV_DIV_SHIFT)) & CLKCTL0_DCPIXELCLKDIV_DIV_MASK)
#define CLKCTL0_DCPIXELCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_DCPIXELCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_DCPIXELCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKDIV_RESET_SHIFT)) & CLKCTL0_DCPIXELCLKDIV_RESET_MASK)
#define CLKCTL0_DCPIXELCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_DCPIXELCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_DCPIXELCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKDIV_HALT_SHIFT)) & CLKCTL0_DCPIXELCLKDIV_HALT_MASK)
#define CLKCTL0_DCPIXELCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_DCPIXELCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_DCPIXELCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DCPIXELCLKDIV_REQFLAG_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CLKCTL0_Register_Masks */


/* CLKCTL0 - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral CLKCTL0 base address */
  #define CLKCTL0_BASE                             (0x50001000u)
  /** Peripheral CLKCTL0 base address */
  #define CLKCTL0_BASE_NS                          (0x40001000u)
  /** Peripheral CLKCTL0 base pointer */
  #define CLKCTL0                                  ((CLKCTL0_Type *)CLKCTL0_BASE)
  /** Peripheral CLKCTL0 base pointer */
  #define CLKCTL0_NS                               ((CLKCTL0_Type *)CLKCTL0_BASE_NS)
  /** Array initializer of CLKCTL0 peripheral base addresses */
  #define CLKCTL0_BASE_ADDRS                       { CLKCTL0_BASE }
  /** Array initializer of CLKCTL0 peripheral base pointers */
  #define CLKCTL0_BASE_PTRS                        { CLKCTL0 }
  /** Array initializer of CLKCTL0 peripheral base addresses */
  #define CLKCTL0_BASE_ADDRS_NS                    { CLKCTL0_BASE_NS }
  /** Array initializer of CLKCTL0 peripheral base pointers */
  #define CLKCTL0_BASE_PTRS_NS                     { CLKCTL0_NS }
#else
  /** Peripheral CLKCTL0 base address */
  #define CLKCTL0_BASE                             (0x40001000u)
  /** Peripheral CLKCTL0 base pointer */
  #define CLKCTL0                                  ((CLKCTL0_Type *)CLKCTL0_BASE)
  /** Array initializer of CLKCTL0 peripheral base addresses */
  #define CLKCTL0_BASE_ADDRS                       { CLKCTL0_BASE }
  /** Array initializer of CLKCTL0 peripheral base pointers */
  #define CLKCTL0_BASE_PTRS                        { CLKCTL0 }
#endif

/*!
 * @}
 */ /* end of group CLKCTL0_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CLKCTL1 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL1_Peripheral_Access_Layer CLKCTL1 Peripheral Access Layer
 * @{
 */

/** CLKCTL1 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t PSCCTL0;                           /**< Clock Control 0, offset: 0x10 */
  __IO uint32_t PSCCTL1;                           /**< Clock Control 1, offset: 0x14 */
  __IO uint32_t PSCCTL2;                           /**< Clock Control 2, offset: 0x18 */
       uint8_t RESERVED_1[36];
  __IO uint32_t PSCCTL0_SET;                       /**< Clock Set 0, offset: 0x40 */
  __IO uint32_t PSCCTL1_SET;                       /**< Clock Set 1, offset: 0x44 */
  __IO uint32_t PSCCTL2_SET;                       /**< Clock Set 2, offset: 0x48 */
       uint8_t RESERVED_2[36];
  __IO uint32_t PSCCTL0_CLR;                       /**< Clock Clear 0, offset: 0x70 */
  __IO uint32_t PSCCTL1_CLR;                       /**< Clock Clear 1, offset: 0x74 */
  __IO uint32_t PSCCTL2_CLR;                       /**< Clock Clear 2, offset: 0x78 */
       uint8_t RESERVED_3[388];
  __IO uint32_t AUDIOPLL0CLKSEL;                   /**< Audio PLL0 Clock Select, offset: 0x200 */
  __IO uint32_t AUDIOPLL0CTL0;                     /**< Audio PLL0 Control 0, offset: 0x204 */
       uint8_t RESERVED_4[4];
  __IO uint32_t AUDIOPLL0LOCKTIMEDIV2;             /**< Audio PLL0 Lock Time Divide-by-2, offset: 0x20C */
  __IO uint32_t AUDIOPLL0NUM;                      /**< Audio PLL0 Numerator, offset: 0x210 */
  __IO uint32_t AUDIOPLL0DENOM;                    /**< Audio PLL0 Denominator, offset: 0x214 */
  __IO uint32_t AUDIOPLL0PFD;                      /**< Audio PLL0 PFD, offset: 0x218 */
       uint8_t RESERVED_5[36];
  __IO uint32_t AUDIOPLLCLKDIV;                    /**< Audio PLL Clock Divider, offset: 0x240 */
       uint8_t RESERVED_6[444];
  __IO uint32_t DSPCPUCLKDIV;                      /**< DSP CPU Clock Divider, offset: 0x400 */
       uint8_t RESERVED_7[44];
  __IO uint32_t DSPCPUCLKSELA;                     /**< DSP CPU Clock Select A, offset: 0x430 */
  __IO uint32_t DSPCPUCLKSELB;                     /**< DSP CPU Clock Select B, offset: 0x434 */
       uint8_t RESERVED_8[72];
  __IO uint32_t OSEVENTTFCLKSEL;                   /**< OS Event Timer Functional Clock Select, offset: 0x480 */
       uint8_t RESERVED_9[124];
  struct {                                         /* offset: 0x500, array step: 0x20 */
    __IO uint32_t FRGCLKSEL;                         /**< Fractional Rate Generator 0 Clock Select..Fractional Rate Generator 16 Clock Select, array offset: 0x500, array step: 0x20 */
    __IO uint32_t FRGCTL;                            /**< Fractional Rate Generator 0 Control..Fractional Rate Generator 16 Control, array offset: 0x504, array step: 0x20 */
    __IO uint32_t FCFCLKSEL;                         /**< Flexcomm0 Clock Select..Flexcomm16 Clock Select, array offset: 0x508, array step: 0x20 */
         uint8_t RESERVED_0[20];
  } FLEXCOMM[17];
  __IO uint32_t FRG17CLKSEL;                       /**< Fractional Rate Generator 17 Clock Select, offset: 0x720 */
  __IO uint32_t FRG17CTL;                          /**< Fractional Rate Generator 17 Control, offset: 0x724 */
  __IO uint32_t FLEXIOCLKSEL;                      /**< FlexIO Clock Select, offset: 0x728 */
       uint8_t RESERVED_10[20];
  __IO uint32_t FLEXIOCLKDIV;                      /**< FlexIO Clock Divider, offset: 0x740 */
       uint8_t RESERVED_11[28];
  __IO uint32_t FRGPLLCLKDIV;                      /**< Fractional Rate Generator PLL Clock Divider, offset: 0x760 */
       uint8_t RESERVED_12[28];
  __IO uint32_t DMIC0FCLKSEL;                      /**< DMIC0 Functional Clock Select, offset: 0x780 */
  __IO uint32_t DMIC0FCLKDIV;                      /**< DMIC0 Functional Clock Divider, offset: 0x784 */
       uint8_t RESERVED_13[24];
  __IO uint32_t CT32BITFCLKSEL[5];                 /**< CT32BIT bit timer 0 Functional Clock Select..CT32BIT bit timer 4 Functional Clock Select, array offset: 0x7A0, array step: 0x4 */
       uint8_t RESERVED_14[12];
  __IO uint32_t AUDIOMCLKSEL;                      /**< Audio MCLK Clock Select, offset: 0x7C0 */
  __IO uint32_t AUDIOMCLKDIV;                      /**< Audio MCLK Clock Divider, offset: 0x7C4 */
       uint8_t RESERVED_15[24];
  __IO uint32_t CLKOUTSEL0;                        /**< CLKOUT Clock Select 0, offset: 0x7E0 */
  __IO uint32_t CLKOUTSEL1;                        /**< CLKOUT Clock Select 1, offset: 0x7E4 */
  __IO uint32_t CLKOUTFCLKDIV;                     /**< CLKOUT Functional Clock Divider, offset: 0x7E8 */
       uint8_t RESERVED_16[20];
  __IO uint32_t I3C01FCLKSEL;                      /**< I3C0, I3C1 Functional Clock Select, offset: 0x800 */
  __IO uint32_t I3C01FCLKSTCSEL;                   /**< I3C0, I3C1 Functional Slow Time Control Clock Select, offset: 0x804 */
  __IO uint32_t I3C01FCLKSTCDIV;                   /**< I3C0, I3C1 Functional Slow Time Control Clock Divider, offset: 0x808 */
  __IO uint32_t I3C01FCLKSDIV;                     /**< I3C0, I3C1 Functional Slow Clock Divider, offset: 0x80C */
  __IO uint32_t I3C01FCLKDIV;                      /**< I3C0, I3C1 Functional Clock Divider, offset: 0x810 */
  __IO uint32_t I3C01FCLKSTSTCLKSEL;               /**< I3C01 Functional Clock Select, offset: 0x814 */
       uint8_t RESERVED_17[8];
  __IO uint32_t WDT1FCLKSEL;                       /**< Watchdog Timer 1 Functional Clock Select, offset: 0x820 */
       uint8_t RESERVED_18[12];
  __IO uint32_t ACMP0FCLKSEL;                      /**< Analog Comparator 0 Clock Select, offset: 0x830 */
  __IO uint32_t ACMP0FCLKDIV;                      /**< Analog comparator 0 FCLK divider, offset: 0x834 */
} CLKCTL1_Type;

/* ----------------------------------------------------------------------------
   -- CLKCTL1 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL1_Register_Masks CLKCTL1 Register Masks
 * @{
 */

/*! @name PSCCTL0 - Clock Control 0 */
/*! @{ */
#define CLKCTL1_PSCCTL0_FC0_CLK_MASK             (0x100U)
#define CLKCTL1_PSCCTL0_FC0_CLK_SHIFT            (8U)
/*! FC0_CLK - Flexcomm Interface 0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC0_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC0_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC0_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC1_CLK_MASK             (0x200U)
#define CLKCTL1_PSCCTL0_FC1_CLK_SHIFT            (9U)
/*! FC1_CLK - Flexcomm Interface 1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC1_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC1_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC1_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC2_CLK_MASK             (0x400U)
#define CLKCTL1_PSCCTL0_FC2_CLK_SHIFT            (10U)
/*! FC2_CLK - Flexcomm Interface 2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC2_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC2_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC2_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC3_CLK_MASK             (0x800U)
#define CLKCTL1_PSCCTL0_FC3_CLK_SHIFT            (11U)
/*! FC3_CLK - Flexcomm Interface 3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC3_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC3_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC3_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC4_CLK_MASK             (0x1000U)
#define CLKCTL1_PSCCTL0_FC4_CLK_SHIFT            (12U)
/*! FC4_CLK - Flexcomm Interface 4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC4_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC4_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC4_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC5_CLK_MASK             (0x2000U)
#define CLKCTL1_PSCCTL0_FC5_CLK_SHIFT            (13U)
/*! FC5_CLK - Flexcomm Interface 5 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC5_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC5_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC5_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC6_CLK_MASK             (0x4000U)
#define CLKCTL1_PSCCTL0_FC6_CLK_SHIFT            (14U)
/*! FC6_CLK - Flexcomm Interface 6 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC6_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC6_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC6_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC7_CLK_MASK             (0x8000U)
#define CLKCTL1_PSCCTL0_FC7_CLK_SHIFT            (15U)
/*! FC7_CLK - Flexcomm Interface 7 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC7_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC7_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC7_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC8_CLK_MASK             (0x10000U)
#define CLKCTL1_PSCCTL0_FC8_CLK_SHIFT            (16U)
/*! FC8_CLK - Flexcomm Interface 8 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC8_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC8_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC8_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC9_CLK_MASK             (0x20000U)
#define CLKCTL1_PSCCTL0_FC9_CLK_SHIFT            (17U)
/*! FC9_CLK - Flexcomm Interface 9 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC9_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC9_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC9_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC10_CLK_MASK            (0x40000U)
#define CLKCTL1_PSCCTL0_FC10_CLK_SHIFT           (18U)
/*! FC10_CLK - Flexcomm Interface 10 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC10_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC10_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC10_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC11_CLK_MASK            (0x80000U)
#define CLKCTL1_PSCCTL0_FC11_CLK_SHIFT           (19U)
/*! FC11_CLK - Flexcomm Interface 11 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC11_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC11_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC11_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC12_CLK_MASK            (0x100000U)
#define CLKCTL1_PSCCTL0_FC12_CLK_SHIFT           (20U)
/*! FC12_CLK - Flexcomm Interface 12 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC12_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC12_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC12_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC13_CLK_MASK            (0x200000U)
#define CLKCTL1_PSCCTL0_FC13_CLK_SHIFT           (21U)
/*! FC13_CLK - Flexcomm Interface 13 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC13_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC13_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC13_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC14_SPI_CLK_MASK        (0x400000U)
#define CLKCTL1_PSCCTL0_FC14_SPI_CLK_SHIFT       (22U)
/*! FC14_SPI_CLK - Flexcomm Interface 14 SPI clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC14_SPI_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC14_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC14_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC15_I2C_CLK_MASK        (0x800000U)
#define CLKCTL1_PSCCTL0_FC15_I2C_CLK_SHIFT       (23U)
/*! FC15_I2C_CLK - Flexcomm Interface 15 I2C clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC15_I2C_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC15_I2C_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC15_I2C_CLK_MASK)
#define CLKCTL1_PSCCTL0_DMIC0_MASK               (0x1000000U)
#define CLKCTL1_PSCCTL0_DMIC0_SHIFT              (24U)
/*! DMIC0 - DMIC0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_DMIC0(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_DMIC0_SHIFT)) & CLKCTL1_PSCCTL0_DMIC0_MASK)
#define CLKCTL1_PSCCTL0_FC16_SPI_CLK_MASK        (0x2000000U)
#define CLKCTL1_PSCCTL0_FC16_SPI_CLK_SHIFT       (25U)
/*! FC16_SPI_CLK - Flexcomm Interface 16 SPI clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC16_SPI_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC16_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC16_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_OSEVENT_TIMER_MASK       (0x8000000U)
#define CLKCTL1_PSCCTL0_OSEVENT_TIMER_SHIFT      (27U)
/*! OSEVENT_TIMER - OS event timer bus clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_OSEVENT_TIMER(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_OSEVENT_TIMER_SHIFT)) & CLKCTL1_PSCCTL0_OSEVENT_TIMER_MASK)
#define CLKCTL1_PSCCTL0_FlexIO_MASK              (0x20000000U)
#define CLKCTL1_PSCCTL0_FlexIO_SHIFT             (29U)
/*! FlexIO - FlexIO clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FlexIO(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FlexIO_SHIFT)) & CLKCTL1_PSCCTL0_FlexIO_MASK)
/*! @} */

/*! @name PSCCTL1 - Clock Control 1 */
/*! @{ */
#define CLKCTL1_PSCCTL1_HSGPIO0_CLK_MASK         (0x1U)
#define CLKCTL1_PSCCTL1_HSGPIO0_CLK_SHIFT        (0U)
/*! HSGPIO0_CLK - Non-secure GPIO0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO0_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO0_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO1_CLK_MASK         (0x2U)
#define CLKCTL1_PSCCTL1_HSGPIO1_CLK_SHIFT        (1U)
/*! HSGPIO1_CLK - Non-secure GPIO1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO1_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO1_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO2_CLK_MASK         (0x4U)
#define CLKCTL1_PSCCTL1_HSGPIO2_CLK_SHIFT        (2U)
/*! HSGPIO2_CLK - Non-secure GPIO2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO2_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO2_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO2_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO3_CLK_MASK         (0x8U)
#define CLKCTL1_PSCCTL1_HSGPIO3_CLK_SHIFT        (3U)
/*! HSGPIO3_CLK - Non-secure GPIO3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO3_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO3_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO3_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO4_CLK_MASK         (0x10U)
#define CLKCTL1_PSCCTL1_HSGPIO4_CLK_SHIFT        (4U)
/*! HSGPIO4_CLK - Non-secure GPIO4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO4_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO4_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO4_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO5_CLK_MASK         (0x20U)
#define CLKCTL1_PSCCTL1_HSGPIO5_CLK_SHIFT        (5U)
/*! HSGPIO5_CLK - Non-secure GPIO5 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO5_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO5_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO5_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO6_CLK_MASK         (0x40U)
#define CLKCTL1_PSCCTL1_HSGPIO6_CLK_SHIFT        (6U)
/*! HSGPIO6_CLK - Non-secure GPIO6 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO6_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO6_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO6_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO7_CLK_MASK         (0x80U)
#define CLKCTL1_PSCCTL1_HSGPIO7_CLK_SHIFT        (7U)
/*! HSGPIO7_CLK - Non-secure GPIO7 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO7_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO7_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO7_CLK_MASK)
#define CLKCTL1_PSCCTL1_CRC_CLK_MASK             (0x10000U)
#define CLKCTL1_PSCCTL1_CRC_CLK_SHIFT            (16U)
/*! CRC_CLK - CRC clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_CRC_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CRC_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CRC_CLK_MASK)
#define CLKCTL1_PSCCTL1_DMAC0_CLK_MASK           (0x800000U)
#define CLKCTL1_PSCCTL1_DMAC0_CLK_SHIFT          (23U)
/*! DMAC0_CLK - DMAC0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_DMAC0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_DMAC0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_DMAC0_CLK_MASK)
#define CLKCTL1_PSCCTL1_DMAC1_CLK_MASK           (0x1000000U)
#define CLKCTL1_PSCCTL1_DMAC1_CLK_SHIFT          (24U)
/*! DMAC1_CLK - DMAC1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_DMAC1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_DMAC1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_DMAC1_CLK_MASK)
#define CLKCTL1_PSCCTL1_MU_CLK_MASK              (0x10000000U)
#define CLKCTL1_PSCCTL1_MU_CLK_SHIFT             (28U)
/*! MU_CLK - Messaging Unit clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_MU_CLK(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_MU_CLK_SHIFT)) & CLKCTL1_PSCCTL1_MU_CLK_MASK)
#define CLKCTL1_PSCCTL1_SEMA_CLK_MASK            (0x20000000U)
#define CLKCTL1_PSCCTL1_SEMA_CLK_SHIFT           (29U)
/*! SEMA_CLK - Semaphore clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_SEMA_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SEMA_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SEMA_CLK_MASK)
#define CLKCTL1_PSCCTL1_FREQME_CLK_MASK          (0x80000000U)
#define CLKCTL1_PSCCTL1_FREQME_CLK_SHIFT         (31U)
/*! FREQME_CLK - Frequency Measurement clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_FREQME_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_FREQME_CLK_SHIFT)) & CLKCTL1_PSCCTL1_FREQME_CLK_MASK)
/*! @} */

/*! @name PSCCTL2 - Clock Control 2 */
/*! @{ */
#define CLKCTL1_PSCCTL2_CT32BIT0_CLK_MASK        (0x1U)
#define CLKCTL1_PSCCTL2_CT32BIT0_CLK_SHIFT       (0U)
/*! CT32BIT0_CLK - CT32BIT bit timer 0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_CT32BIT1_CLK_MASK        (0x2U)
#define CLKCTL1_PSCCTL2_CT32BIT1_CLK_SHIFT       (1U)
/*! CT32BIT1_CLK - CT32BIT bit timer 1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_CT32BIT2_CLK_MASK        (0x4U)
#define CLKCTL1_PSCCTL2_CT32BIT2_CLK_SHIFT       (2U)
/*! CT32BIT2_CLK - CT32BIT bit timer 2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT2_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT2_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT2_CLK_MASK)
#define CLKCTL1_PSCCTL2_CT32BIT3_CLK_MASK        (0x8U)
#define CLKCTL1_PSCCTL2_CT32BIT3_CLK_SHIFT       (3U)
/*! CT32BIT3_CLK - CT32BIT bit timer 3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT3_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT3_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT3_CLK_MASK)
#define CLKCTL1_PSCCTL2_CT32BIT4_CLK_MASK        (0x10U)
#define CLKCTL1_PSCCTL2_CT32BIT4_CLK_SHIFT       (4U)
/*! CT32BIT4_CLK - CT32BIT bit timer 4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT4_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT4_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT4_CLK_MASK)
#define CLKCTL1_PSCCTL2_RTCLITE_CLK_MASK         (0x80U)
#define CLKCTL1_PSCCTL2_RTCLITE_CLK_SHIFT        (7U)
/*! RTCLITE_CLK - RTC clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_RTCLITE_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_RTCLITE_CLK_SHIFT)) & CLKCTL1_PSCCTL2_RTCLITE_CLK_MASK)
#define CLKCTL1_PSCCTL2_MRT0_CLK_MASK            (0x100U)
#define CLKCTL1_PSCCTL2_MRT0_CLK_SHIFT           (8U)
/*! MRT0_CLK - Multi-Rate Timer 0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_MRT0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_MRT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_MRT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_WWDT1_CLK_MASK           (0x400U)
#define CLKCTL1_PSCCTL2_WWDT1_CLK_SHIFT          (10U)
/*! WWDT1_CLK - Watchdog Timer 1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_WWDT1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_WWDT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_WWDT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_I3C0_CLK_MASK            (0x10000U)
#define CLKCTL1_PSCCTL2_I3C0_CLK_SHIFT           (16U)
/*! I3C0_CLK - I3C0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_I3C0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_I3C0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_I3C0_CLK_MASK)
#define CLKCTL1_PSCCTL2_I3C1_CLK_MASK            (0x20000U)
#define CLKCTL1_PSCCTL2_I3C1_CLK_SHIFT           (17U)
/*! I3C1_CLK - I3C1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_I3C1_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_I3C1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_I3C1_CLK_MASK)
#define CLKCTL1_PSCCTL2_GPIOINTCTL_CLK_MASK      (0x40000000U)
#define CLKCTL1_PSCCTL2_GPIOINTCTL_CLK_SHIFT     (30U)
/*! GPIOINTCTL_CLK - PINT clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_GPIOINTCTL_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_GPIOINTCTL_CLK_SHIFT)) & CLKCTL1_PSCCTL2_GPIOINTCTL_CLK_MASK)
#define CLKCTL1_PSCCTL2_PIMCTL_CLK_MASK          (0x80000000U)
#define CLKCTL1_PSCCTL2_PIMCTL_CLK_SHIFT         (31U)
/*! PIMCTL_CLK - INPUTMUX clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_PIMCTL_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_PIMCTL_CLK_SHIFT)) & CLKCTL1_PSCCTL2_PIMCTL_CLK_MASK)
/*! @} */

/*! @name PSCCTL0_SET - Clock Set 0 */
/*! @{ */
#define CLKCTL1_PSCCTL0_SET_FC0_CLK_MASK         (0x100U)
#define CLKCTL1_PSCCTL0_SET_FC0_CLK_SHIFT        (8U)
/*! FC0_CLK - Flexcomm Interface 0 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC0_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC0_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC0_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC1_CLK_MASK         (0x200U)
#define CLKCTL1_PSCCTL0_SET_FC1_CLK_SHIFT        (9U)
/*! FC1_CLK - Flexcomm Interface 1 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC1_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC1_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC1_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC2_CLK_MASK         (0x400U)
#define CLKCTL1_PSCCTL0_SET_FC2_CLK_SHIFT        (10U)
/*! FC2_CLK - Flexcomm Interface 2 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC2_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC2_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC2_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC3_CLK_MASK         (0x800U)
#define CLKCTL1_PSCCTL0_SET_FC3_CLK_SHIFT        (11U)
/*! FC3_CLK - Flexcomm Interface 3 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC3_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC3_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC3_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC4_CLK_MASK         (0x1000U)
#define CLKCTL1_PSCCTL0_SET_FC4_CLK_SHIFT        (12U)
/*! FC4_CLK - Flexcomm Interface 4 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC4_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC4_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC4_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC5_CLK_MASK         (0x2000U)
#define CLKCTL1_PSCCTL0_SET_FC5_CLK_SHIFT        (13U)
/*! FC5_CLK - Flexcomm Interface 5 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC5_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC5_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC5_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC6_CLK_MASK         (0x4000U)
#define CLKCTL1_PSCCTL0_SET_FC6_CLK_SHIFT        (14U)
/*! FC6_CLK - Flexcomm Interface 6 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC6_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC6_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC6_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC7_CLK_MASK         (0x8000U)
#define CLKCTL1_PSCCTL0_SET_FC7_CLK_SHIFT        (15U)
/*! FC7_CLK - Flexcomm Interface 7 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC7_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC7_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC7_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC8_CLK_MASK         (0x10000U)
#define CLKCTL1_PSCCTL0_SET_FC8_CLK_SHIFT        (16U)
/*! FC8_CLK - Flexcomm Interface 8 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC8_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC8_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC8_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC9_CLK_MASK         (0x20000U)
#define CLKCTL1_PSCCTL0_SET_FC9_CLK_SHIFT        (17U)
/*! FC9_CLK - Flexcomm Interface 9 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC9_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC9_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC9_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC10_CLK_MASK        (0x40000U)
#define CLKCTL1_PSCCTL0_SET_FC10_CLK_SHIFT       (18U)
/*! FC10_CLK - Flexcomm Interface 10 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC10_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC10_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC10_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC11_CLK_MASK        (0x80000U)
#define CLKCTL1_PSCCTL0_SET_FC11_CLK_SHIFT       (19U)
/*! FC11_CLK - Flexcomm Interface 11 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC11_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC11_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC11_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC12_CLK_MASK        (0x100000U)
#define CLKCTL1_PSCCTL0_SET_FC12_CLK_SHIFT       (20U)
/*! FC12_CLK - Flexcomm Interface 12 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC12_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC12_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC12_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC13_CLK_MASK        (0x200000U)
#define CLKCTL1_PSCCTL0_SET_FC13_CLK_SHIFT       (21U)
/*! FC13_CLK - Flexcomm Interface 13 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC13_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC13_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC13_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_MASK    (0x400000U)
#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SHIFT   (22U)
/*! FC14_SPI_CLK - Flexcomm Interface 14 SPI clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_MASK    (0x800000U)
#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SHIFT   (23U)
/*! FC15_I2C_CLK - Flexcomm Interface 15 I2C clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_DMIC0_MASK           (0x1000000U)
#define CLKCTL1_PSCCTL0_SET_DMIC0_SHIFT          (24U)
/*! DMIC0 - DMIC0 clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_DMIC0(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_DMIC0_SHIFT)) & CLKCTL1_PSCCTL0_SET_DMIC0_MASK)
#define CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK_MASK    (0x2000000U)
#define CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK_SHIFT   (25U)
/*! FC16_SPI_CLK - Flexcomm Interface 16 SPI clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_MASK   (0x8000000U)
#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_SHIFT  (27U)
/*! OSEVENT_TIMER - OS event timer bus clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_SHIFT)) & CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_MASK)
#define CLKCTL1_PSCCTL0_SET_FlexIO_MASK          (0x20000000U)
#define CLKCTL1_PSCCTL0_SET_FlexIO_SHIFT         (29U)
/*! FlexIO - FlexIO clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FlexIO(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FlexIO_SHIFT)) & CLKCTL1_PSCCTL0_SET_FlexIO_MASK)
/*! @} */

/*! @name PSCCTL1_SET - Clock Set 1 */
/*! @{ */
#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_MASK     (0x1U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SHIFT    (0U)
/*! HSGPIO0_CLK - Non-secure GPIO0 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_MASK     (0x2U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SHIFT    (1U)
/*! HSGPIO1_CLK - Non-secure GPIO1 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_MASK     (0x4U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SHIFT    (2U)
/*! HSGPIO2_CLK - Non-secure GPIO2 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_MASK     (0x8U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SHIFT    (3U)
/*! HSGPIO3_CLK - Non-secure GPIO3 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_MASK     (0x10U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SHIFT    (4U)
/*! HSGPIO4_CLK - Non-secure GPIO4 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_MASK     (0x20U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SHIFT    (5U)
/*! HSGPIO5_CLK - Non-secure GPIO5 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_MASK     (0x40U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SHIFT    (6U)
/*! HSGPIO6_CLK - Non-secure GPIO6 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_MASK     (0x80U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SHIFT    (7U)
/*! HSGPIO7_CLK - Non-secure GPIO7 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_CRC_CLK_MASK         (0x10000U)
#define CLKCTL1_PSCCTL1_SET_CRC_CLK_SHIFT        (16U)
/*! CRC_CLK - CRC clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_CRC_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_CRC_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_CRC_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK_MASK       (0x800000U)
#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SHIFT      (23U)
/*! DMAC0_CLK - DMAC0 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_DMAC0_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK_MASK       (0x1000000U)
#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SHIFT      (24U)
/*! DMAC1_CLK - DMAC1 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_DMAC1_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_MU_CLK_MASK          (0x10000000U)
#define CLKCTL1_PSCCTL1_SET_MU_CLK_SHIFT         (28U)
/*! MU_CLK - Messaging Unit clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_MU_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_MU_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_MU_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_SEMA_CLK_MASK        (0x20000000U)
#define CLKCTL1_PSCCTL1_SET_SEMA_CLK_SHIFT       (29U)
/*! SEMA_CLK - Semaphore clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_SEMA_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_SEMA_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_SEMA_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_FREQME_CLK_MASK      (0x80000000U)
#define CLKCTL1_PSCCTL1_SET_FREQME_CLK_SHIFT     (31U)
/*! FREQME_CLK - Frequency Measurement clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_FREQME_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_FREQME_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_FREQME_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_SET - Clock Set 2 */
/*! @{ */
#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_MASK    (0x1U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SHIFT   (0U)
/*! CT32BIT0_CLK - CT32BIT bit timer 0 clock set
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_MASK    (0x2U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SHIFT   (1U)
/*! CT32BIT1_CLK - CT32BIT bit timer 1 clock set
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_MASK    (0x4U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SHIFT   (2U)
/*! CT32BIT2_CLK - CT32BIT bit timer 2 clock set
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_MASK    (0x8U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SHIFT   (3U)
/*! CT32BIT3_CLK - CT32BIT bit timer 3 clock set
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_MASK    (0x10U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SHIFT   (4U)
/*! CT32BIT4_CLK - CT32BIT bit timer 4 clock set
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_RTCLITE_CLK_MASK     (0x80U)
#define CLKCTL1_PSCCTL2_SET_RTCLITE_CLK_SHIFT    (7U)
/*! RTCLITE_CLK - RTC clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_RTCLITE_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_RTCLITE_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_RTCLITE_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_MRT0_CLK_MASK        (0x100U)
#define CLKCTL1_PSCCTL2_SET_MRT0_CLK_SHIFT       (8U)
/*! MRT0_CLK - Multi-Rate Timer 0 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_MRT0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_MRT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_MRT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK_MASK       (0x400U)
#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SHIFT      (10U)
/*! WWDT1_CLK - Watchdog Timer 1 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_WWDT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_I3C0_CLK_MASK        (0x10000U)
#define CLKCTL1_PSCCTL2_SET_I3C0_CLK_SHIFT       (16U)
/*! I3C0_CLK - I3C0 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_I3C0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_I3C0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_I3C0_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_I3C1_CLK_MASK        (0x20000U)
#define CLKCTL1_PSCCTL2_SET_I3C1_CLK_SHIFT       (17U)
/*! I3C1_CLK - I3C1 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_I3C1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_I3C1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_I3C1_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_MASK  (0x40000000U)
#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_SHIFT (30U)
/*! GPIOINTCTL_CLK - PINT clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_MASK      (0x80000000U)
#define CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_SHIFT     (31U)
/*! PIMCTL_CLK - INPUTMUX clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_PIMCTL_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_MASK)
/*! @} */

/*! @name PSCCTL0_CLR - Clock Clear 0 */
/*! @{ */
#define CLKCTL1_PSCCTL0_CLR_FC0_CLK_MASK         (0x100U)
#define CLKCTL1_PSCCTL0_CLR_FC0_CLK_SHIFT        (8U)
/*! FC0_CLK - Flexcomm Interface 0 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC0_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC0_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC0_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC1_CLK_MASK         (0x200U)
#define CLKCTL1_PSCCTL0_CLR_FC1_CLK_SHIFT        (9U)
/*! FC1_CLK - Flexcomm Interface 1 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC1_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC1_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC1_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC2_CLK_MASK         (0x400U)
#define CLKCTL1_PSCCTL0_CLR_FC2_CLK_SHIFT        (10U)
/*! FC2_CLK - Flexcomm Interface 2 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC2_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC2_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC2_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC3_CLK_MASK         (0x800U)
#define CLKCTL1_PSCCTL0_CLR_FC3_CLK_SHIFT        (11U)
/*! FC3_CLK - Flexcomm Interface 3 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC3_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC3_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC3_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC4_CLK_MASK         (0x1000U)
#define CLKCTL1_PSCCTL0_CLR_FC4_CLK_SHIFT        (12U)
/*! FC4_CLK - Flexcomm Interface 4 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC4_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC4_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC4_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC5_CLK_MASK         (0x2000U)
#define CLKCTL1_PSCCTL0_CLR_FC5_CLK_SHIFT        (13U)
/*! FC5_CLK - Flexcomm Interface 5 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC5_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC5_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC5_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC6_CLK_MASK         (0x4000U)
#define CLKCTL1_PSCCTL0_CLR_FC6_CLK_SHIFT        (14U)
/*! FC6_CLK - Flexcomm Interface 6 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC6_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC6_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC6_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC7_CLK_MASK         (0x8000U)
#define CLKCTL1_PSCCTL0_CLR_FC7_CLK_SHIFT        (15U)
/*! FC7_CLK - Flexcomm Interface 7 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC7_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC7_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC7_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC8_CLK_MASK         (0x10000U)
#define CLKCTL1_PSCCTL0_CLR_FC8_CLK_SHIFT        (16U)
/*! FC8_CLK - Flexcomm Interface 8 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC8_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC8_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC8_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC9_CLK_MASK         (0x20000U)
#define CLKCTL1_PSCCTL0_CLR_FC9_CLK_SHIFT        (17U)
/*! FC9_CLK - Flexcomm Interface 9 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC9_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC9_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC9_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC10_CLK_MASK        (0x40000U)
#define CLKCTL1_PSCCTL0_CLR_FC10_CLK_SHIFT       (18U)
/*! FC10_CLK - Flexcomm Interface 10 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC10_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC10_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC10_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC11_CLK_MASK        (0x80000U)
#define CLKCTL1_PSCCTL0_CLR_FC11_CLK_SHIFT       (19U)
/*! FC11_CLK - Flexcomm Interface 11 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC11_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC11_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC11_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC12_CLK_MASK        (0x100000U)
#define CLKCTL1_PSCCTL0_CLR_FC12_CLK_SHIFT       (20U)
/*! FC12_CLK - Flexcomm Interface 12 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC12_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC12_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC12_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC13_CLK_MASK        (0x200000U)
#define CLKCTL1_PSCCTL0_CLR_FC13_CLK_SHIFT       (21U)
/*! FC13_CLK - Flexcomm Interface 13 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC13_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC13_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC13_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_MASK    (0x400000U)
#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_SHIFT   (22U)
/*! FC14_SPI_CLK - Flexcomm Interface 14 SPI clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_MASK    (0x800000U)
#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_SHIFT   (23U)
/*! FC15_I2C_CLK - Flexcomm Interface 15 I2C clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_DMIC0_MASK           (0x1000000U)
#define CLKCTL1_PSCCTL0_CLR_DMIC0_SHIFT          (24U)
/*! DMIC0 - DMIC0 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_DMIC0(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_DMIC0_SHIFT)) & CLKCTL1_PSCCTL0_CLR_DMIC0_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK_MASK    (0x2000000U)
#define CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK_SHIFT   (25U)
/*! FC16_SPI_CLK - Flexcomm Interface 16 SPI clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_MASK   (0x8000000U)
#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_SHIFT  (27U)
/*! OSEVENT_TIMER - OS event timer bus clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_SHIFT)) & CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_MASK)
#define CLKCTL1_PSCCTL0_CLR_FlexIO_MASK          (0x20000000U)
#define CLKCTL1_PSCCTL0_CLR_FlexIO_SHIFT         (29U)
/*! FlexIO - FlexIO clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FlexIO(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FlexIO_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FlexIO_MASK)
/*! @} */

/*! @name PSCCTL1_CLR - Clock Clear 1 */
/*! @{ */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_MASK     (0x1U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_SHIFT    (0U)
/*! HSGPIO0_CLK - Non-secure GPIO0 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_MASK     (0x2U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_SHIFT    (1U)
/*! HSGPIO1_CLK - Non-secure GPIO1 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_MASK     (0x4U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_SHIFT    (2U)
/*! HSGPIO2_CLK - Non-secure GPIO2 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_MASK     (0x8U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_SHIFT    (3U)
/*! HSGPIO3_CLK - Non-secure GPIO3 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_MASK     (0x10U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_SHIFT    (4U)
/*! HSGPIO4_CLK - Non-secure GPIO4 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_MASK     (0x20U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_SHIFT    (5U)
/*! HSGPIO5_CLK - Non-secure GPIO5 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_MASK     (0x40U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_SHIFT    (6U)
/*! HSGPIO6_CLK - Non-secure GPIO6 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_MASK     (0x80U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_SHIFT    (7U)
/*! HSGPIO7_CLK - Non-secure GPIO7 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_CRC_CLK_MASK         (0x10000U)
#define CLKCTL1_PSCCTL1_CLR_CRC_CLK_SHIFT        (16U)
/*! CRC_CLK - CRC clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_CRC_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_CRC_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_CRC_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_MASK       (0x800000U)
#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_SHIFT      (23U)
/*! DMAC0_CLK - DMAC0 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_MASK       (0x1000000U)
#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_SHIFT      (24U)
/*! DMAC1_CLK - DMAC1 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_MU_CLK_MASK          (0x10000000U)
#define CLKCTL1_PSCCTL1_CLR_MU_CLK_SHIFT         (28U)
/*! MU_CLK - Messaging Unit clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_MU_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_MU_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_MU_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK_MASK        (0x20000000U)
#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK_SHIFT       (29U)
/*! SEMA_CLK - Semaphore clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_SEMA_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_SEMA_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK_MASK      (0x80000000U)
#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK_SHIFT     (31U)
/*! FREQME_CLK - Frequency Measurement clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_FREQME_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_FREQME_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_CLR - Clock Clear 2 */
/*! @{ */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_MASK    (0x1U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_SHIFT   (0U)
/*! CT32BIT0_CLK - CT32BIT bit timer 0 clock clear
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_MASK    (0x2U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_SHIFT   (1U)
/*! CT32BIT1_CLK - CT32BIT bit timer 1 clock clear
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_MASK    (0x4U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_SHIFT   (2U)
/*! CT32BIT2_CLK - CT32BIT bit timer 2 clock clear
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_MASK    (0x8U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_SHIFT   (3U)
/*! CT32BIT3_CLK - CT32BIT bit timer 3 clock clear
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_MASK    (0x10U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_SHIFT   (4U)
/*! CT32BIT4_CLK - CT32BIT bit timer 4 clock clear
 *  0b0..No Effect
 *  0b1..Set Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK_MASK     (0x80U)
#define CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK_SHIFT    (7U)
/*! RTCLITE_CLK - RTC clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK_MASK        (0x100U)
#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK_SHIFT       (8U)
/*! MRT0_CLK - Multi-Rate Timer 0 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_MRT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_MRT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_MASK       (0x400U)
#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_SHIFT      (10U)
/*! WWDT1_CLK - Watchdog Timer 1 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK_MASK        (0x10000U)
#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK_SHIFT       (16U)
/*! I3C0_CLK - I3C0 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_I3C0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_I3C0_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_I3C1_CLK_MASK        (0x20000U)
#define CLKCTL1_PSCCTL2_CLR_I3C1_CLK_SHIFT       (17U)
/*! I3C1_CLK - I3C1 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_I3C1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_I3C1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_I3C1_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_MASK  (0x40000000U)
#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_SHIFT (30U)
/*! GPIOINTCTL_CLK - PINT clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_MASK      (0x80000000U)
#define CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_SHIFT     (31U)
/*! PIMCTL_CLK - INPUTMUX clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_MASK)
/*! @} */

/*! @name AUDIOPLL0CLKSEL - Audio PLL0 Clock Select */
/*! @{ */
#define CLKCTL1_AUDIOPLL0CLKSEL_SEL_MASK         (0x7U)
#define CLKCTL1_AUDIOPLL0CLKSEL_SEL_SHIFT        (0U)
/*! SEL - Audio PLL0 Clock Select
 *  0b000..FRO_DIV8
 *  0b001..OSC_CLK clock (User-Selectable)
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_AUDIOPLL0CLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CLKSEL_SEL_SHIFT)) & CLKCTL1_AUDIOPLL0CLKSEL_SEL_MASK)
/*! @} */

/*! @name AUDIOPLL0CTL0 - Audio PLL0 Control 0 */
/*! @{ */
#define CLKCTL1_AUDIOPLL0CTL0_BYPASS_MASK        (0x1U)
#define CLKCTL1_AUDIOPLL0CTL0_BYPASS_SHIFT       (0U)
/*! BYPASS - AUDIOPLL0 BYPASS Mode
 *  0b0..PFD outputs are PFD-programmed clocks
 *  0b1..Bypass Mode. PFD outputs are sourced directly from the reference input clock
 */
#define CLKCTL1_AUDIOPLL0CTL0_BYPASS(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_BYPASS_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_BYPASS_MASK)
#define CLKCTL1_AUDIOPLL0CTL0_RESET_MASK         (0x2U)
#define CLKCTL1_AUDIOPLL0CTL0_RESET_SHIFT        (1U)
/*! RESET - AUDIOPLL0 Reset
 *  0b0..AUDIOPLL0 reset is removed
 *  0b1..AUDIOPLL0 is placed into reset
 */
#define CLKCTL1_AUDIOPLL0CTL0_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_RESET_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_RESET_MASK)
#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_MASK (0x2000U)
#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_SHIFT (13U)
/*! HOLDRINGOFF_ENA - Hold Ring Off Control
 *  0b0..Disable
 *  0b1..Enable
 */
#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_MASK)
#define CLKCTL1_AUDIOPLL0CTL0_MULT_MASK          (0xFF0000U)
#define CLKCTL1_AUDIOPLL0CTL0_MULT_SHIFT         (16U)
/*! MULT - Multiplication Factor
 *  0b00010000..Divide by 16
 *  0b00010001..Divide by 17
 *  0b00010010..Divide by 18
 *  0b00010011..Divide by 19
 *  0b00010100..Divide by 20
 *  0b00010101..Divide by 21
 *  0b00010110..Divide by 22
 */
#define CLKCTL1_AUDIOPLL0CTL0_MULT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_MULT_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_MULT_MASK)
/*! @} */

/*! @name AUDIOPLL0LOCKTIMEDIV2 - Audio PLL0 Lock Time Divide-by-2 */
/*! @{ */
#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK (0xFFFFU)
#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT (0U)
/*! LOCKTIMEDIV2 - AUDIOPLL0 Lock Time Divide-by-2
 */
#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT)) & CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK)
/*! @} */

/*! @name AUDIOPLL0NUM - Audio PLL0 Numerator */
/*! @{ */
#define CLKCTL1_AUDIOPLL0NUM_NUM_MASK            (0x3FFFFFFFU)
#define CLKCTL1_AUDIOPLL0NUM_NUM_SHIFT           (0U)
/*! NUM - Numerator
 */
#define CLKCTL1_AUDIOPLL0NUM_NUM(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0NUM_NUM_SHIFT)) & CLKCTL1_AUDIOPLL0NUM_NUM_MASK)
/*! @} */

/*! @name AUDIOPLL0DENOM - Audio PLL0 Denominator */
/*! @{ */
#define CLKCTL1_AUDIOPLL0DENOM_DENOM_MASK        (0x3FFFFFFFU)
#define CLKCTL1_AUDIOPLL0DENOM_DENOM_SHIFT       (0U)
/*! DENOM - Denominator
 */
#define CLKCTL1_AUDIOPLL0DENOM_DENOM(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0DENOM_DENOM_SHIFT)) & CLKCTL1_AUDIOPLL0DENOM_DENOM_MASK)
/*! @} */

/*! @name AUDIOPLL0PFD - Audio PLL0 PFD */
/*! @{ */
#define CLKCTL1_AUDIOPLL0PFD_PFD0_MASK           (0x3FU)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_SHIFT          (0U)
/*! PFD0 - PLL Fractional Divider 0
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_MASK    (0x40U)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_SHIFT   (6U)
/*! PFD0_CLKRDY - PFD0 Clock Ready Status Flag
 *  0b0..Not ready
 *  0b1..Ready
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_MASK   (0x80U)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_SHIFT  (7U)
/*! PFD0_CLKGATE - PFD0 Clock Gate
 *  0b0..PFD0 clock is not gated
 *  0b1..PFD0 clock is gated
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_MASK           (0x3F00U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_SHIFT          (8U)
/*! PFD1 - PLL Fractional Divider 1
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_MASK    (0x4000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_SHIFT   (14U)
/*! PFD1_CLKRDY - PFD1 Clock Ready Status Flag
 *  0b0..Not ready
 *  0b1..Ready
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_MASK   (0x8000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_SHIFT  (15U)
/*! PFD1_CLKGATE - PFD1 Clock Gate
 *  0b0..PFD1 clock is not gated
 *  0b1..PFD1 clock is gated
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_MASK           (0x3F0000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_SHIFT          (16U)
/*! PFD2 - PLL Fractional Divider 2
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_MASK    (0x400000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_SHIFT   (22U)
/*! PFD2_CLKRDY - PFD2 Clock Ready Status Flag
 *  0b0..Not ready
 *  0b1..Ready
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_MASK   (0x800000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_SHIFT  (23U)
/*! PFD2_CLKGATE - PFD2 Clock Gate
 *  0b0..PFD2 clock is not gated
 *  0b1..PFD2 clock is gated
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_MASK           (0x3F000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_SHIFT          (24U)
/*! PFD3 - PLL Fractional Divider 3
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_MASK    (0x40000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_SHIFT   (30U)
/*! PFD3_CLKRDY - PFD3 Clock Ready Status Flag
 *  0b0..Not ready
 *  0b1..Ready
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_MASK   (0x80000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_SHIFT  (31U)
/*! PFD3_CLKGATE - PFD3 Clock Gate
 *  0b0..PFD3 clock is not gated
 *  0b1..PFD3 clock is gated
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_MASK)
/*! @} */

/*! @name AUDIOPLLCLKDIV - Audio PLL Clock Divider */
/*! @{ */
#define CLKCTL1_AUDIOPLLCLKDIV_DIV_MASK          (0xFFU)
#define CLKCTL1_AUDIOPLLCLKDIV_DIV_SHIFT         (0U)
/*! DIV - 32 KHz Wake Clock Divider Value
 */
#define CLKCTL1_AUDIOPLLCLKDIV_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_DIV_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_DIV_MASK)
#define CLKCTL1_AUDIOPLLCLKDIV_RESET_MASK        (0x20000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_RESET_SHIFT       (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_AUDIOPLLCLKDIV_RESET(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_RESET_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_RESET_MASK)
#define CLKCTL1_AUDIOPLLCLKDIV_HALT_MASK         (0x40000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_HALT_SHIFT        (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_AUDIOPLLCLKDIV_HALT(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_HALT_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_HALT_MASK)
#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_MASK      (0x80000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_SHIFT     (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished
 *  0b1..The Divider value has changed
 */
#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DSPCPUCLKDIV - DSP CPU Clock Divider */
/*! @{ */
#define CLKCTL1_DSPCPUCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_DSPCPUCLKDIV_DIV_SHIFT           (0U)
/*! DIV - DSP Clock Divider Value
 */
#define CLKCTL1_DSPCPUCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_DIV_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_DIV_MASK)
#define CLKCTL1_DSPCPUCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_DSPCPUCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_DSPCPUCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_RESET_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_RESET_MASK)
#define CLKCTL1_DSPCPUCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_DSPCPUCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_DSPCPUCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_HALT_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_HALT_MASK)
#define CLKCTL1_DSPCPUCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_DSPCPUCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_DSPCPUCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DSPCPUCLKSELA - DSP CPU Clock Select A */
/*! @{ */
#define CLKCTL1_DSPCPUCLKSELA_SEL_MASK           (0x3U)
#define CLKCTL1_DSPCPUCLKSELA_SEL_SHIFT          (0U)
/*! SEL - DSP Main 1st Stage Control Clock Source
 *  0b00..FRO_DIV1 Clock
 *  0b01..OSC_CLK Clock
 *  0b10..Low Power Oscillator Clock (LPOSC)
 *  0b11..Reserved
 */
#define CLKCTL1_DSPCPUCLKSELA_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKSELA_SEL_SHIFT)) & CLKCTL1_DSPCPUCLKSELA_SEL_MASK)
/*! @} */

/*! @name DSPCPUCLKSELB - DSP CPU Clock Select B */
/*! @{ */
#define CLKCTL1_DSPCPUCLKSELB_SEL_MASK           (0x3U)
#define CLKCTL1_DSPCPUCLKSELB_SEL_SHIFT          (0U)
/*! SEL - Main Clock Source
 *  0b00..MAINCLKSELA 1st Stage Clock
 *  0b01..Main System PLL Clock
 *  0b10..DSP System PLL Clock
 *  0b11..RTC 32 KHz Clock
 */
#define CLKCTL1_DSPCPUCLKSELB_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKSELB_SEL_SHIFT)) & CLKCTL1_DSPCPUCLKSELB_SEL_MASK)
/*! @} */

/*! @name OSEVENTTFCLKSEL - OS Event Timer Functional Clock Select */
/*! @{ */
#define CLKCTL1_OSEVENTTFCLKSEL_SEL_MASK         (0x7U)
#define CLKCTL1_OSEVENTTFCLKSEL_SEL_SHIFT        (0U)
/*! SEL - OS Event Timer Functional Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..RTC 32 KHz Clock
 *  0b010..HCLK Free-Running Clock (Global Time Stamping)
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_OSEVENTTFCLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_OSEVENTTFCLKSEL_SEL_SHIFT)) & CLKCTL1_OSEVENTTFCLKSEL_SEL_MASK)
/*! @} */

/*! @name FRGCLKSEL - Fractional Rate Generator 0 Clock Select..Fractional Rate Generator 16 Clock Select */
/*! @{ */
#define CLKCTL1_FRGCLKSEL_SEL_MASK               (0x7U)
#define CLKCTL1_FRGCLKSEL_SEL_SHIFT              (0U)
/*! SEL - Fractional Generator 16 Clock Source
 *  0b000..Main Clock
 *  0b001..FRG PLL Clock
 *  0b010..FRO_DIV4 clock
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_FRGCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCLKSEL_SEL_SHIFT)) & CLKCTL1_FRGCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_FRGCLKSEL */
#define CLKCTL1_FRGCLKSEL_COUNT                  (17U)

/*! @name FRGCTL - Fractional Rate Generator 0 Control..Fractional Rate Generator 16 Control */
/*! @{ */
#define CLKCTL1_FRGCTL_DIV_MASK                  (0xFFU)
#define CLKCTL1_FRGCTL_DIV_SHIFT                 (0U)
#define CLKCTL1_FRGCTL_DIV(x)                    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCTL_DIV_SHIFT)) & CLKCTL1_FRGCTL_DIV_MASK)
#define CLKCTL1_FRGCTL_MULT_MASK                 (0xFF00U)
#define CLKCTL1_FRGCTL_MULT_SHIFT                (8U)
#define CLKCTL1_FRGCTL_MULT(x)                   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCTL_MULT_SHIFT)) & CLKCTL1_FRGCTL_MULT_MASK)
/*! @} */

/* The count of CLKCTL1_FRGCTL */
#define CLKCTL1_FRGCTL_COUNT                     (17U)

/*! @name FCFCLKSEL - Flexcomm0 Clock Select..Flexcomm16 Clock Select */
/*! @{ */
#define CLKCTL1_FCFCLKSEL_SEL_MASK               (0x7U)
#define CLKCTL1_FCFCLKSEL_SEL_SHIFT              (0U)
/*! SEL - Flexcomm Functional Clock Source
 *  0b000..FRO_DIV4 clock
 *  0b001..Audio PLL Clock
 *  0b010..Master Clock In
 *  0b011..FCn FRG Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_FCFCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FCFCLKSEL_SEL_SHIFT)) & CLKCTL1_FCFCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_FCFCLKSEL */
#define CLKCTL1_FCFCLKSEL_COUNT                  (17U)

/*! @name FRG17CLKSEL - Fractional Rate Generator 17 Clock Select */
/*! @{ */
#define CLKCTL1_FRG17CLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_FRG17CLKSEL_SEL_SHIFT            (0U)
/*! SEL - Fractional Generator 17 Clock Source
 *  0b000..Main Clock
 *  0b001..FRG PLL Clock
 *  0b010..FRO_DIV4 clock
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_FRG17CLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG17CLKSEL_SEL_SHIFT)) & CLKCTL1_FRG17CLKSEL_SEL_MASK)
/*! @} */

/*! @name FRG17CTL - Fractional Rate Generator 17 Control */
/*! @{ */
#define CLKCTL1_FRG17CTL_DIV_MASK                (0xFFU)
#define CLKCTL1_FRG17CTL_DIV_SHIFT               (0U)
#define CLKCTL1_FRG17CTL_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG17CTL_DIV_SHIFT)) & CLKCTL1_FRG17CTL_DIV_MASK)
#define CLKCTL1_FRG17CTL_MULT_MASK               (0xFF00U)
#define CLKCTL1_FRG17CTL_MULT_SHIFT              (8U)
#define CLKCTL1_FRG17CTL_MULT(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG17CTL_MULT_SHIFT)) & CLKCTL1_FRG17CTL_MULT_MASK)
/*! @} */

/*! @name FLEXIOCLKSEL - FlexIO Clock Select */
/*! @{ */
#define CLKCTL1_FLEXIOCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_FLEXIOCLKSEL_SEL_SHIFT           (0U)
/*! SEL - FlexIO Functional Clock Source
 *  0b000..FRO_DIV2 Clock
 *  0b001..Audio PLL Clock
 *  0b010..Master Clock In
 *  0b011..FC17 FRG Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_FLEXIOCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKSEL_SEL_SHIFT)) & CLKCTL1_FLEXIOCLKSEL_SEL_MASK)
/*! @} */

/*! @name FLEXIOCLKDIV - FlexIO Clock Divider */
/*! @{ */
#define CLKCTL1_FLEXIOCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_FLEXIOCLKDIV_DIV_SHIFT           (0U)
/*! DIV - FLEXIO Clock Divider Value
 */
#define CLKCTL1_FLEXIOCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKDIV_DIV_SHIFT)) & CLKCTL1_FLEXIOCLKDIV_DIV_MASK)
#define CLKCTL1_FLEXIOCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_FLEXIOCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_FLEXIOCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKDIV_RESET_SHIFT)) & CLKCTL1_FLEXIOCLKDIV_RESET_MASK)
#define CLKCTL1_FLEXIOCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_FLEXIOCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_FLEXIOCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKDIV_HALT_SHIFT)) & CLKCTL1_FLEXIOCLKDIV_HALT_MASK)
#define CLKCTL1_FLEXIOCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_FLEXIOCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed
 */
#define CLKCTL1_FLEXIOCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_FLEXIOCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name FRGPLLCLKDIV - Fractional Rate Generator PLL Clock Divider */
/*! @{ */
#define CLKCTL1_FRGPLLCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_FRGPLLCLKDIV_DIV_SHIFT           (0U)
/*! DIV - FRG PLL Clock Divider Value
 */
#define CLKCTL1_FRGPLLCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_DIV_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_DIV_MASK)
#define CLKCTL1_FRGPLLCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_FRGPLLCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_FRGPLLCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_RESET_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_RESET_MASK)
#define CLKCTL1_FRGPLLCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_FRGPLLCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_FRGPLLCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_HALT_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_HALT_MASK)
#define CLKCTL1_FRGPLLCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_FRGPLLCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_FRGPLLCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DMIC0FCLKSEL - DMIC0 Functional Clock Select */
/*! @{ */
#define CLKCTL1_DMIC0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_DMIC0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - DMIC Functional Clock Source
 *  0b000..FRO Clock (Divided-by-4 selection)
 *  0b001..Audio PLL Clock
 *  0b010..Master Clock In
 *  0b011..Low Power Oscillator Clock (LPOSC)
 *  0b100..32 KHz Wake Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_DMIC0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKSEL_SEL_SHIFT)) & CLKCTL1_DMIC0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name DMIC0FCLKDIV - DMIC0 Functional Clock Divider */
/*! @{ */
#define CLKCTL1_DMIC0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_DMIC0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - 32 KHz Wake Clock Divider Value
 */
#define CLKCTL1_DMIC0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_DIV_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_DIV_MASK)
#define CLKCTL1_DMIC0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_DMIC0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_DMIC0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_RESET_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_RESET_MASK)
#define CLKCTL1_DMIC0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_DMIC0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_DMIC0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_HALT_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_HALT_MASK)
#define CLKCTL1_DMIC0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_DMIC0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_DMIC0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CT32BITFCLKSEL - CT32BIT bit timer 0 Functional Clock Select..CT32BIT bit timer 4 Functional Clock Select */
/*! @{ */
#define CLKCTL1_CT32BITFCLKSEL_SEL_MASK          (0x7U)
#define CLKCTL1_CT32BITFCLKSEL_SEL_SHIFT         (0U)
/*! SEL - CT32BIT bit timer 4 Functional Clock Source
 *  0b000..Main Clock
 *  0b001..FRO_DIV1 Clock
 *  0b010..Audio PLL Clock
 *  0b011..Master Clock In
 *  0b100..32 KHZ Wake Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_CT32BITFCLKSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CT32BITFCLKSEL_SEL_SHIFT)) & CLKCTL1_CT32BITFCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_CT32BITFCLKSEL */
#define CLKCTL1_CT32BITFCLKSEL_COUNT             (5U)

/*! @name AUDIOMCLKSEL - Audio MCLK Clock Select */
/*! @{ */
#define CLKCTL1_AUDIOMCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_AUDIOMCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Audio MCLK Clock Source Select
 *  0b000..FRO_DIV8 Clock
 *  0b001..AUDIO PLL Clock (Shared Domain)
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_AUDIOMCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKSEL_SEL_SHIFT)) & CLKCTL1_AUDIOMCLKSEL_SEL_MASK)
/*! @} */

/*! @name AUDIOMCLKDIV - Audio MCLK Clock Divider */
/*! @{ */
#define CLKCTL1_AUDIOMCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_AUDIOMCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Audio MCLK Clock Divider Value
 */
#define CLKCTL1_AUDIOMCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_DIV_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_DIV_MASK)
#define CLKCTL1_AUDIOMCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_AUDIOMCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_AUDIOMCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_RESET_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_RESET_MASK)
#define CLKCTL1_AUDIOMCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_AUDIOMCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_AUDIOMCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_HALT_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_HALT_MASK)
#define CLKCTL1_AUDIOMCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_AUDIOMCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_AUDIOMCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CLKOUTSEL0 - CLKOUT Clock Select 0 */
/*! @{ */
#define CLKCTL1_CLKOUTSEL0_SEL_MASK              (0x7U)
#define CLKCTL1_CLKOUTSEL0_SEL_SHIFT             (0U)
/*! SEL - Clock Output Select 1st Stage
 *  0b000..OSC_CLK Clock
 *  0b001..Low Power Oscillator Clock (LPOSC)
 *  0b010..FRO_DIV2 Clock
 *  0b011..Main Clock
 *  0b100..DSP Main Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_CLKOUTSEL0_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTSEL0_SEL_SHIFT)) & CLKCTL1_CLKOUTSEL0_SEL_MASK)
/*! @} */

/*! @name CLKOUTSEL1 - CLKOUT Clock Select 1 */
/*! @{ */
#define CLKCTL1_CLKOUTSEL1_SEL_MASK              (0x7U)
#define CLKCTL1_CLKOUTSEL1_SEL_SHIFT             (0U)
/*! SEL - Clock Out Source
 *  0b000..CLKOUTSEL0 Multiplexed Output
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..DSP PLL Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..AUDIO PLL Clock
 *  0b110..32 KHz RTC Clock
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_CLKOUTSEL1_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTSEL1_SEL_SHIFT)) & CLKCTL1_CLKOUTSEL1_SEL_MASK)
/*! @} */

/*! @name CLKOUTFCLKDIV - CLKOUT Functional Clock Divider */
/*! @{ */
#define CLKCTL1_CLKOUTFCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL1_CLKOUTFCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Clock-Out Clock Divider Value
 */
#define CLKCTL1_CLKOUTFCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTFCLKDIV_DIV_SHIFT)) & CLKCTL1_CLKOUTFCLKDIV_DIV_MASK)
#define CLKCTL1_CLKOUTFCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL1_CLKOUTFCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_CLKOUTFCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTFCLKDIV_RESET_SHIFT)) & CLKCTL1_CLKOUTFCLKDIV_RESET_MASK)
#define CLKCTL1_CLKOUTFCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL1_CLKOUTFCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_CLKOUTFCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTFCLKDIV_HALT_SHIFT)) & CLKCTL1_CLKOUTFCLKDIV_HALT_MASK)
#define CLKCTL1_CLKOUTFCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL1_CLKOUTFCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed
 */
#define CLKCTL1_CLKOUTFCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTFCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_CLKOUTFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C01FCLKSEL - I3C0, I3C1 Functional Clock Select */
/*! @{ */
#define CLKCTL1_I3C01FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_I3C01FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - I3C0, I3C1 Clock Source
 *  0b000..Main Clock
 *  0b001..FRO_DIV8 Clock
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_I3C01FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSEL_SEL_SHIFT)) & CLKCTL1_I3C01FCLKSEL_SEL_MASK)
/*! @} */

/*! @name I3C01FCLKSTCSEL - I3C0, I3C1 Functional Slow Time Control Clock Select */
/*! @{ */
#define CLKCTL1_I3C01FCLKSTCSEL_SEL_MASK         (0x7U)
#define CLKCTL1_I3C01FCLKSTCSEL_SEL_SHIFT        (0U)
/*! SEL - I3C0, I3C1 Clock Source
 *  0b000..I3C0 FCLK
 *  0b001..Low Power Oscillator Clock (LPOSC)
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_I3C01FCLKSTCSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCSEL_SEL_SHIFT)) & CLKCTL1_I3C01FCLKSTCSEL_SEL_MASK)
/*! @} */

/*! @name I3C01FCLKSTCDIV - I3C0, I3C1 Functional Slow Time Control Clock Divider */
/*! @{ */
#define CLKCTL1_I3C01FCLKSTCDIV_DIV_MASK         (0xFFU)
#define CLKCTL1_I3C01FCLKSTCDIV_DIV_SHIFT        (0U)
/*! DIV - I3C0, I3C1 Clock Divider Value
 */
#define CLKCTL1_I3C01FCLKSTCDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCDIV_DIV_SHIFT)) & CLKCTL1_I3C01FCLKSTCDIV_DIV_MASK)
#define CLKCTL1_I3C01FCLKSTCDIV_RESET_MASK       (0x20000000U)
#define CLKCTL1_I3C01FCLKSTCDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_I3C01FCLKSTCDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCDIV_RESET_SHIFT)) & CLKCTL1_I3C01FCLKSTCDIV_RESET_MASK)
#define CLKCTL1_I3C01FCLKSTCDIV_HALT_MASK        (0x40000000U)
#define CLKCTL1_I3C01FCLKSTCDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_I3C01FCLKSTCDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCDIV_HALT_SHIFT)) & CLKCTL1_I3C01FCLKSTCDIV_HALT_MASK)
#define CLKCTL1_I3C01FCLKSTCDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL1_I3C01FCLKSTCDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_I3C01FCLKSTCDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C01FCLKSTCDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C01FCLKSDIV - I3C0, I3C1 Functional Slow Clock Divider */
/*! @{ */
#define CLKCTL1_I3C01FCLKSDIV_DIV_MASK           (0xFFU)
#define CLKCTL1_I3C01FCLKSDIV_DIV_SHIFT          (0U)
/*! DIV - I3C0, I3C1 Clock Divider Value
 */
#define CLKCTL1_I3C01FCLKSDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSDIV_DIV_SHIFT)) & CLKCTL1_I3C01FCLKSDIV_DIV_MASK)
#define CLKCTL1_I3C01FCLKSDIV_RESET_MASK         (0x20000000U)
#define CLKCTL1_I3C01FCLKSDIV_RESET_SHIFT        (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_I3C01FCLKSDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSDIV_RESET_SHIFT)) & CLKCTL1_I3C01FCLKSDIV_RESET_MASK)
#define CLKCTL1_I3C01FCLKSDIV_HALT_MASK          (0x40000000U)
#define CLKCTL1_I3C01FCLKSDIV_HALT_SHIFT         (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_I3C01FCLKSDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSDIV_HALT_SHIFT)) & CLKCTL1_I3C01FCLKSDIV_HALT_MASK)
#define CLKCTL1_I3C01FCLKSDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL1_I3C01FCLKSDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_I3C01FCLKSDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C01FCLKSDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C01FCLKDIV - I3C0, I3C1 Functional Clock Divider */
/*! @{ */
#define CLKCTL1_I3C01FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_I3C01FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - I3C0, I3C1 Clock Divider Value
 */
#define CLKCTL1_I3C01FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKDIV_DIV_SHIFT)) & CLKCTL1_I3C01FCLKDIV_DIV_MASK)
#define CLKCTL1_I3C01FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_I3C01FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_I3C01FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKDIV_RESET_SHIFT)) & CLKCTL1_I3C01FCLKDIV_RESET_MASK)
#define CLKCTL1_I3C01FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_I3C01FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_I3C01FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKDIV_HALT_SHIFT)) & CLKCTL1_I3C01FCLKDIV_HALT_MASK)
#define CLKCTL1_I3C01FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_I3C01FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_I3C01FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C01FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C01FCLKSTSTCLKSEL - I3C01 Functional Clock Select */
/*! @{ */
#define CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL_MASK     (0x7U)
#define CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL_SHIFT    (0U)
/*! SEL - I3C0, I3C1 FCLK Test Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..Reserved
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL_SHIFT)) & CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL_MASK)
/*! @} */

/*! @name WDT1FCLKSEL - Watchdog Timer 1 Functional Clock Select */
/*! @{ */
#define CLKCTL1_WDT1FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_WDT1FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - WDT1 Functional Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..Main Clock
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_WDT1FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_WDT1FCLKSEL_SEL_SHIFT)) & CLKCTL1_WDT1FCLKSEL_SEL_MASK)
/*! @} */

/*! @name ACMP0FCLKSEL - Analog Comparator 0 Clock Select */
/*! @{ */
#define CLKCTL1_ACMP0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_ACMP0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - ACMP0 Fast Functional Clock Source
 *  0b000..Main Clock
 *  0b001..FRO_DIV4 Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..SYSPLL0 AUX1_PLL_Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_ACMP0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKSEL_SEL_SHIFT)) & CLKCTL1_ACMP0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name ACMP0FCLKDIV - Analog comparator 0 FCLK divider */
/*! @{ */
#define CLKCTL1_ACMP0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_ACMP0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Out Clock Divider Value
 */
#define CLKCTL1_ACMP0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_DIV_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_DIV_MASK)
#define CLKCTL1_ACMP0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_ACMP0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_ACMP0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_RESET_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_RESET_MASK)
#define CLKCTL1_ACMP0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_ACMP0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_ACMP0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_HALT_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_HALT_MASK)
#define CLKCTL1_ACMP0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_ACMP0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_ACMP0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_REQFLAG_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CLKCTL1_Register_Masks */


/* CLKCTL1 - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral CLKCTL1 base address */
  #define CLKCTL1_BASE                             (0x50021000u)
  /** Peripheral CLKCTL1 base address */
  #define CLKCTL1_BASE_NS                          (0x40021000u)
  /** Peripheral CLKCTL1 base pointer */
  #define CLKCTL1                                  ((CLKCTL1_Type *)CLKCTL1_BASE)
  /** Peripheral CLKCTL1 base pointer */
  #define CLKCTL1_NS                               ((CLKCTL1_Type *)CLKCTL1_BASE_NS)
  /** Array initializer of CLKCTL1 peripheral base addresses */
  #define CLKCTL1_BASE_ADDRS                       { CLKCTL1_BASE }
  /** Array initializer of CLKCTL1 peripheral base pointers */
  #define CLKCTL1_BASE_PTRS                        { CLKCTL1 }
  /** Array initializer of CLKCTL1 peripheral base addresses */
  #define CLKCTL1_BASE_ADDRS_NS                    { CLKCTL1_BASE_NS }
  /** Array initializer of CLKCTL1 peripheral base pointers */
  #define CLKCTL1_BASE_PTRS_NS                     { CLKCTL1_NS }
#else
  /** Peripheral CLKCTL1 base address */
  #define CLKCTL1_BASE                             (0x40021000u)
  /** Peripheral CLKCTL1 base pointer */
  #define CLKCTL1                                  ((CLKCTL1_Type *)CLKCTL1_BASE)
  /** Array initializer of CLKCTL1 peripheral base addresses */
  #define CLKCTL1_BASE_ADDRS                       { CLKCTL1_BASE }
  /** Array initializer of CLKCTL1 peripheral base pointers */
  #define CLKCTL1_BASE_PTRS                        { CLKCTL1 }
#endif

/*!
 * @}
 */ /* end of group CLKCTL1_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Peripheral_Access_Layer CMP Peripheral Access Layer
 * @{
 */

/** CMP - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
  __IO uint32_t C0;                                /**< CMP Control Register 0, offset: 0x8 */
  __IO uint32_t C1;                                /**< CMP Control Register 1, offset: 0xC */
  __IO uint32_t C2;                                /**< CMP Control Register 2, offset: 0x10 */
  __IO uint32_t C3;                                /**< CMP Control Register 3, offset: 0x14 */
  __IO uint32_t RR_TIMER_CR;                       /**< Round-Robin Timer Control Register, offset: 0x18 */
} CMP_Type;

/* ----------------------------------------------------------------------------
   -- CMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Masks CMP Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */
#define CMP_VERID_FEATURE_MASK                   (0xFFFFU)
#define CMP_VERID_FEATURE_SHIFT                  (0U)
/*! FEATURE - Feature Specification Number. This read only filed returns the feature set number.
 */
#define CMP_VERID_FEATURE(x)                     (((uint32_t)(((uint32_t)(x)) << CMP_VERID_FEATURE_SHIFT)) & CMP_VERID_FEATURE_MASK)
#define CMP_VERID_MINOR_MASK                     (0xFF0000U)
#define CMP_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number. This read only field returns the minor version number for the module specification.
 */
#define CMP_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMP_VERID_MINOR_SHIFT)) & CMP_VERID_MINOR_MASK)
#define CMP_VERID_MAJOR_MASK                     (0xFF000000U)
#define CMP_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number. This read only field returns the major version number for the module specification.
 */
#define CMP_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMP_VERID_MAJOR_SHIFT)) & CMP_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */
#define CMP_PARAM_PARAM_MASK                     (0xFFFFFFFFU)
#define CMP_PARAM_PARAM_SHIFT                    (0U)
/*! PARAM - Parameter Registers. This read only filed returns the feature parameters implemented along with the Version ID register.
 */
#define CMP_PARAM_PARAM(x)                       (((uint32_t)(((uint32_t)(x)) << CMP_PARAM_PARAM_SHIFT)) & CMP_PARAM_PARAM_MASK)
/*! @} */

/*! @name C0 - CMP Control Register 0 */
/*! @{ */
#define CMP_C0_HYSTCTR_MASK                      (0x3U)
#define CMP_C0_HYSTCTR_SHIFT                     (0U)
/*! HYSTCTR - Comparator hard block hysteresis control. See chip data sheet to get the actual hystersis value with each level
 *  0b00..The hard block output has level 0 hysteresis internally.
 *  0b01..The hard block output has level 1 hysteresis internally.
 *  0b10..The hard block output has level 2 hysteresis internally.
 *  0b11..The hard block output has level 3 hysteresis internally.
 */
#define CMP_C0_HYSTCTR(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C0_HYSTCTR_SHIFT)) & CMP_C0_HYSTCTR_MASK)
#define CMP_C0_FILTER_CNT_MASK                   (0x70U)
#define CMP_C0_FILTER_CNT_SHIFT                  (4U)
/*! FILTER_CNT - Filter Sample Count
 *  0b000..Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
 *  0b001..1 consecutive sample must agree (comparator output is simply sampled).
 *  0b010..2 consecutive samples must agree.
 *  0b011..3 consecutive samples must agree.
 *  0b100..4 consecutive samples must agree.
 *  0b101..5 consecutive samples must agree.
 *  0b110..6 consecutive samples must agree.
 *  0b111..7 consecutive samples must agree.
 */
#define CMP_C0_FILTER_CNT(x)                     (((uint32_t)(((uint32_t)(x)) << CMP_C0_FILTER_CNT_SHIFT)) & CMP_C0_FILTER_CNT_MASK)
#define CMP_C0_EN_MASK                           (0x100U)
#define CMP_C0_EN_SHIFT                          (8U)
/*! EN - Comparator Module Enable
 *  0b0..Analog Comparator is disabled.
 *  0b1..Analog Comparator is enabled.
 */
#define CMP_C0_EN(x)                             (((uint32_t)(((uint32_t)(x)) << CMP_C0_EN_SHIFT)) & CMP_C0_EN_MASK)
#define CMP_C0_OPE_MASK                          (0x200U)
#define CMP_C0_OPE_SHIFT                         (9U)
/*! OPE - Comparator Output Pin Enable
 *  0b0..When OPE is 0, the comparator output (after window/filter settings dependent on software configuration) is not available to a packaged pin.
 *  0b1..When OPE is 1, and if the software has configured the comparator to own a packaged pin, the comparator is available in a packaged pin.
 */
#define CMP_C0_OPE(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_OPE_SHIFT)) & CMP_C0_OPE_MASK)
#define CMP_C0_COS_MASK                          (0x400U)
#define CMP_C0_COS_SHIFT                         (10U)
/*! COS - Comparator Output Select
 *  0b0..Set CMPO to equal COUT (filtered comparator output).
 *  0b1..Set CMPO to equal COUTA (unfiltered comparator output).
 */
#define CMP_C0_COS(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_COS_SHIFT)) & CMP_C0_COS_MASK)
#define CMP_C0_INVT_MASK                         (0x800U)
#define CMP_C0_INVT_SHIFT                        (11U)
/*! INVT - Comparator invert
 *  0b0..Does not invert the comparator output.
 *  0b1..Inverts the comparator output.
 */
#define CMP_C0_INVT(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C0_INVT_SHIFT)) & CMP_C0_INVT_MASK)
#define CMP_C0_PMODE_MASK                        (0x1000U)
#define CMP_C0_PMODE_SHIFT                       (12U)
/*! PMODE - Power Mode Select
 *  0b0..Low Speed (LS) comparison mode is selected.
 *  0b1..High Speed (HS) comparison mode is selected.
 */
#define CMP_C0_PMODE(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C0_PMODE_SHIFT)) & CMP_C0_PMODE_MASK)
#define CMP_C0_WE_MASK                           (0x4000U)
#define CMP_C0_WE_SHIFT                          (14U)
/*! WE - Windowing Enable
 *  0b0..Windowing mode is not selected.
 *  0b1..Windowing mode is selected.
 */
#define CMP_C0_WE(x)                             (((uint32_t)(((uint32_t)(x)) << CMP_C0_WE_SHIFT)) & CMP_C0_WE_MASK)
#define CMP_C0_SE_MASK                           (0x8000U)
#define CMP_C0_SE_SHIFT                          (15U)
/*! SE - Sample Enable
 *  0b0..Sampling mode is not selected.
 *  0b1..Sampling mode is selected.
 */
#define CMP_C0_SE(x)                             (((uint32_t)(((uint32_t)(x)) << CMP_C0_SE_SHIFT)) & CMP_C0_SE_MASK)
#define CMP_C0_FPR_MASK                          (0xFF0000U)
#define CMP_C0_FPR_SHIFT                         (16U)
/*! FPR - Filter Sample Period
 */
#define CMP_C0_FPR(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_FPR_SHIFT)) & CMP_C0_FPR_MASK)
#define CMP_C0_COUT_MASK                         (0x1000000U)
#define CMP_C0_COUT_SHIFT                        (24U)
/*! COUT - Analog Comparator Output
 */
#define CMP_C0_COUT(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C0_COUT_SHIFT)) & CMP_C0_COUT_MASK)
#define CMP_C0_CFF_MASK                          (0x2000000U)
#define CMP_C0_CFF_SHIFT                         (25U)
/*! CFF - Analog Comparator Flag Falling
 *  0b0..A falling edge has not been detected on COUT.
 *  0b1..A falling edge on COUT has occurred.
 */
#define CMP_C0_CFF(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_CFF_SHIFT)) & CMP_C0_CFF_MASK)
#define CMP_C0_CFR_MASK                          (0x4000000U)
#define CMP_C0_CFR_SHIFT                         (26U)
/*! CFR - Analog Comparator Flag Rising
 *  0b0..A rising edge has not been detected on COUT.
 *  0b1..A rising edge on COUT has occurred.
 */
#define CMP_C0_CFR(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_CFR_SHIFT)) & CMP_C0_CFR_MASK)
#define CMP_C0_IEF_MASK                          (0x8000000U)
#define CMP_C0_IEF_SHIFT                         (27U)
/*! IEF - Comparator Interrupt Enable Falling
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CMP_C0_IEF(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_IEF_SHIFT)) & CMP_C0_IEF_MASK)
#define CMP_C0_IER_MASK                          (0x10000000U)
#define CMP_C0_IER_SHIFT                         (28U)
/*! IER - Comparator Interrupt Enable Rising
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CMP_C0_IER(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_IER_SHIFT)) & CMP_C0_IER_MASK)
#define CMP_C0_DMAEN_MASK                        (0x40000000U)
#define CMP_C0_DMAEN_SHIFT                       (30U)
/*! DMAEN - DMA Enable
 *  0b0..DMA is disabled.
 *  0b1..DMA is enabled.
 */
#define CMP_C0_DMAEN(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C0_DMAEN_SHIFT)) & CMP_C0_DMAEN_MASK)
#define CMP_C0_LINKEN_MASK                       (0x80000000U)
#define CMP_C0_LINKEN_SHIFT                      (31U)
/*! LINKEN - CMP to DAC link enable.
 *  0b0..CMP to DAC link is disabled
 *  0b1..CMP to DAC link is enabled.
 */
#define CMP_C0_LINKEN(x)                         (((uint32_t)(((uint32_t)(x)) << CMP_C0_LINKEN_SHIFT)) & CMP_C0_LINKEN_MASK)
/*! @} */

/*! @name C1 - CMP Control Register 1 */
/*! @{ */
#define CMP_C1_VOSEL_MASK                        (0xFFU)
#define CMP_C1_VOSEL_SHIFT                       (0U)
/*! VOSEL - DAC Output Voltage Select
 */
#define CMP_C1_VOSEL(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C1_VOSEL_SHIFT)) & CMP_C1_VOSEL_MASK)
#define CMP_C1_DMODE_MASK                        (0x100U)
#define CMP_C1_DMODE_SHIFT                       (8U)
/*! DMODE - DAC Mode Selection
 *  0b0..DAC is selected to work in low speed and low power mode.
 *  0b1..DAC is selected to work in high speed high power mode.
 */
#define CMP_C1_DMODE(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C1_DMODE_SHIFT)) & CMP_C1_DMODE_MASK)
#define CMP_C1_VRSEL_MASK                        (0x200U)
#define CMP_C1_VRSEL_SHIFT                       (9U)
/*! VRSEL - Supply Voltage Reference Source Select
 *  0b0..Vin1 is selected as resistor ladder network supply reference Vin. Vin1 is from internal PMC.
 *  0b1..Vin2 is selected as resistor ladder network supply reference Vin. Vin2 is from PAD.
 */
#define CMP_C1_VRSEL(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C1_VRSEL_SHIFT)) & CMP_C1_VRSEL_MASK)
#define CMP_C1_DACEN_MASK                        (0x400U)
#define CMP_C1_DACEN_SHIFT                       (10U)
/*! DACEN - DAC Enable
 *  0b0..DAC is disabled.
 *  0b1..DAC is enabled.
 */
#define CMP_C1_DACEN(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C1_DACEN_SHIFT)) & CMP_C1_DACEN_MASK)
#define CMP_C1_PSEL_SEC_MASK                     (0x7000U)
#define CMP_C1_PSEL_SEC_SHIFT                    (12U)
/*! PSEL_SEC - Secondary Plus channel select.
 *  0b000..Input 0 for Plus Channel
 *  0b001..Input 1 for Plus Channel
 *  0b010..Input 2 for Plus Channel
 *  0b011..Input 3 for Plus Channel
 *  0b100..Input 4 for Plus Channel
 *  0b101..Input 5 for Plus Channel
 *  0b110..Input 6 for Plus Channel
 *  0b111..Internal 8b DAC output for Plus Channel
 */
#define CMP_C1_PSEL_SEC(x)                       (((uint32_t)(((uint32_t)(x)) << CMP_C1_PSEL_SEC_SHIFT)) & CMP_C1_PSEL_SEC_MASK)
#define CMP_C1_CHN0_MASK                         (0x10000U)
#define CMP_C1_CHN0_SHIFT                        (16U)
/*! CHN0 - Channel 0 input enable
 */
#define CMP_C1_CHN0(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN0_SHIFT)) & CMP_C1_CHN0_MASK)
#define CMP_C1_CHN1_MASK                         (0x20000U)
#define CMP_C1_CHN1_SHIFT                        (17U)
/*! CHN1 - Channel 1 input enable
 */
#define CMP_C1_CHN1(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN1_SHIFT)) & CMP_C1_CHN1_MASK)
#define CMP_C1_CHN2_MASK                         (0x40000U)
#define CMP_C1_CHN2_SHIFT                        (18U)
/*! CHN2 - Channel 2 input enable
 */
#define CMP_C1_CHN2(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN2_SHIFT)) & CMP_C1_CHN2_MASK)
#define CMP_C1_CHN3_MASK                         (0x80000U)
#define CMP_C1_CHN3_SHIFT                        (19U)
/*! CHN3 - Channel 3 input enable
 */
#define CMP_C1_CHN3(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN3_SHIFT)) & CMP_C1_CHN3_MASK)
#define CMP_C1_CHN4_MASK                         (0x100000U)
#define CMP_C1_CHN4_SHIFT                        (20U)
/*! CHN4 - Channel 4 input enable
 */
#define CMP_C1_CHN4(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN4_SHIFT)) & CMP_C1_CHN4_MASK)
#define CMP_C1_CHN5_MASK                         (0x200000U)
#define CMP_C1_CHN5_SHIFT                        (21U)
/*! CHN5 - Channel 5 input enable
 */
#define CMP_C1_CHN5(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN5_SHIFT)) & CMP_C1_CHN5_MASK)
#define CMP_C1_MSEL_MASK                         (0x7000000U)
#define CMP_C1_MSEL_SHIFT                        (24U)
/*! MSEL - Minus Input MUX Control
 *  0b000..Internal Negative Input 0 for Minus Channel -- Internal Minus Input
 *  0b001..External Input 1 for Minus Channel -- Reference Input 0
 *  0b010..External Input 2 for Minus Channel -- Reference Input 1
 *  0b011..External Input 3 for Minus Channel -- Reference Input 2
 *  0b100..External Input 4 for Minus Channel -- Reference Input 3
 *  0b101..External Input 5 for Minus Channel -- Reference Input 4
 *  0b110..External Input 6 for Minus Channel -- Reference Input 5
 *  0b111..Internal 8b DAC output
 */
#define CMP_C1_MSEL(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_MSEL_SHIFT)) & CMP_C1_MSEL_MASK)
#define CMP_C1_PSEL_MASK                         (0x70000000U)
#define CMP_C1_PSEL_SHIFT                        (28U)
/*! PSEL - Plus Input MUX Control
 *  0b000..Internal Posivite Input 0 for Plus Channel -- Internal Minus Input
 *  0b001..External Input 1 for Plus Channel -- Reference Input 0
 *  0b010..External Input 2 for Plus Channel -- Reference Input 1
 *  0b011..External Input 3 for Plus Channel -- Reference Input 2
 *  0b100..External Input 4 for Plus Channel -- Reference Input 3
 *  0b101..External Input 4 for Plus Channel -- Reference Input 4
 *  0b110..External Input 4 for Plus Channel -- Reference Input 5
 *  0b111..Internal 8b DAC output
 */
#define CMP_C1_PSEL(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_PSEL_SHIFT)) & CMP_C1_PSEL_MASK)
/*! @} */

/*! @name C2 - CMP Control Register 2 */
/*! @{ */
#define CMP_C2_ACOn_MASK                         (0x3FU)
#define CMP_C2_ACOn_SHIFT                        (0U)
/*! ACOn - ACOn
 */
#define CMP_C2_ACOn(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_ACOn_SHIFT)) & CMP_C2_ACOn_MASK)
#define CMP_C2_INITMOD_MASK                      (0x3F00U)
#define CMP_C2_INITMOD_SHIFT                     (8U)
/*! INITMOD - Comparator and DAC initialization delay modulus.
 */
#define CMP_C2_INITMOD(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C2_INITMOD_SHIFT)) & CMP_C2_INITMOD_MASK)
#define CMP_C2_NSAM_MASK                         (0xC000U)
#define CMP_C2_NSAM_SHIFT                        (14U)
/*! NSAM - Number of sample clocks
 *  0b00..The comparison result is sampled as soon as the active channel is scanned in one round-robin clock.
 *  0b01..The sampling takes place 1 round-robin clock cycle after the next cycle of the round-robin clock.
 *  0b10..The sampling takes place 2 round-robin clock cycles after the next cycle of the round-robin clock.
 *  0b11..The sampling takes place 3 round-robin clock cycles after the next cycle of the round-robin clock.
 */
#define CMP_C2_NSAM(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_NSAM_SHIFT)) & CMP_C2_NSAM_MASK)
#define CMP_C2_CH0F_MASK                         (0x10000U)
#define CMP_C2_CH0F_SHIFT                        (16U)
/*! CH0F - CH0F
 */
#define CMP_C2_CH0F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH0F_SHIFT)) & CMP_C2_CH0F_MASK)
#define CMP_C2_CH1F_MASK                         (0x20000U)
#define CMP_C2_CH1F_SHIFT                        (17U)
/*! CH1F - CH1F
 */
#define CMP_C2_CH1F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH1F_SHIFT)) & CMP_C2_CH1F_MASK)
#define CMP_C2_CH2F_MASK                         (0x40000U)
#define CMP_C2_CH2F_SHIFT                        (18U)
/*! CH2F - CH2F
 */
#define CMP_C2_CH2F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH2F_SHIFT)) & CMP_C2_CH2F_MASK)
#define CMP_C2_CH3F_MASK                         (0x80000U)
#define CMP_C2_CH3F_SHIFT                        (19U)
/*! CH3F - CH3F
 */
#define CMP_C2_CH3F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH3F_SHIFT)) & CMP_C2_CH3F_MASK)
#define CMP_C2_CH4F_MASK                         (0x100000U)
#define CMP_C2_CH4F_SHIFT                        (20U)
/*! CH4F - CH4F
 */
#define CMP_C2_CH4F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH4F_SHIFT)) & CMP_C2_CH4F_MASK)
#define CMP_C2_CH5F_MASK                         (0x200000U)
#define CMP_C2_CH5F_SHIFT                        (21U)
/*! CH5F - CH5F
 */
#define CMP_C2_CH5F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH5F_SHIFT)) & CMP_C2_CH5F_MASK)
#define CMP_C2_FXMXCH_MASK                       (0xE000000U)
#define CMP_C2_FXMXCH_SHIFT                      (25U)
/*! FXMXCH - Fixed channel selection
 *  0b000..External Reference Input 0 is selected as the fixed reference input for the fixed mux port.
 *  0b001..External Reference Input 1 is selected as the fixed reference input for the fixed mux port.
 *  0b010..External Reference Input 2 is selected as the fixed reference input for the fixed mux port.
 *  0b011..External Reference Input 3 is selected as the fixed reference input for the fixed mux port.
 *  0b100..External Reference Input 4 is selected as the fixed reference input for the fixed mux port.
 *  0b101..External Reference Input 5 is selected as the fixed reference input for the fixed mux port.
 *  0b110..Reserved.
 *  0b111..The 8bit DAC is selected as the fixed reference input for the fixed mux port.
 */
#define CMP_C2_FXMXCH(x)                         (((uint32_t)(((uint32_t)(x)) << CMP_C2_FXMXCH_SHIFT)) & CMP_C2_FXMXCH_MASK)
#define CMP_C2_FXMP_MASK                         (0x20000000U)
#define CMP_C2_FXMP_SHIFT                        (29U)
/*! FXMP - Fixed MUX Port
 *  0b0..The Plus port is fixed. Only the inputs to the Minus port are swept in each round.
 *  0b1..The Minus port is fixed. Only the inputs to the Plus port are swept in each round.
 */
#define CMP_C2_FXMP(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_FXMP_SHIFT)) & CMP_C2_FXMP_MASK)
#define CMP_C2_RRIE_MASK                         (0x40000000U)
#define CMP_C2_RRIE_SHIFT                        (30U)
/*! RRIE - Round-Robin interrupt enable
 *  0b0..The round-robin interrupt is disabled.
 *  0b1..The round-robin interrupt is enabled when a comparison result changes from the last sample.
 */
#define CMP_C2_RRIE(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_RRIE_SHIFT)) & CMP_C2_RRIE_MASK)
/*! @} */

/*! @name C3 - CMP Control Register 3 */
/*! @{ */
#define CMP_C3_ACPH2TC_MASK                      (0x70U)
#define CMP_C3_ACPH2TC_SHIFT                     (4U)
/*! ACPH2TC - Analog Comparator Phase2 Timing Control.
 *  0b000..Phase2 active time in one sampling period equals to T
 *  0b001..Phase2 active time in one sampling period equals to 2*T
 *  0b010..Phase2 active time in one sampling period equals to 4*T
 *  0b011..Phase2 active time in one sampling period equals to 8*T
 *  0b100..Phase2 active time in one sampling period equals to 16*T
 *  0b101..Phase2 active time in one sampling period equals to 32*T
 *  0b110..Phase2 active time in one sampling period equals to 64*T
 *  0b111..Phase2 active time in one sampling period equals to 16*T
 */
#define CMP_C3_ACPH2TC(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C3_ACPH2TC_SHIFT)) & CMP_C3_ACPH2TC_MASK)
#define CMP_C3_ACPH1TC_MASK                      (0x700U)
#define CMP_C3_ACPH1TC_SHIFT                     (8U)
/*! ACPH1TC - Analog Comparator Phase1 Timing Control.
 *  0b000..Phase1 active time in one sampling period equals to T
 *  0b001..Phase1 active time in one sampling period equals to 2*T
 *  0b010..Phase1 active time in one sampling period equals to 4*T
 *  0b011..Phase1 active time in one sampling period equals to 8*T
 *  0b100..Phase1 active time in one sampling period equals to T
 *  0b101..Phase1 active time in one sampling period equals to T
 *  0b110..Phase1 active time in one sampling period equals to T
 *  0b111..Phase1 active time in one sampling period equals to 0
 */
#define CMP_C3_ACPH1TC(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C3_ACPH1TC_SHIFT)) & CMP_C3_ACPH1TC_MASK)
#define CMP_C3_ACSAT_MASK                        (0x7000U)
#define CMP_C3_ACSAT_SHIFT                       (12U)
/*! ACSAT - Analog Comparator Sampling Time control.
 *  0b000..The sampling time equals to T
 *  0b001..The sampling time equasl to 2*T
 *  0b010..The sampling time equasl to 4*T
 *  0b011..The sampling time equasl to 8*T
 *  0b100..The sampling time equasl to 16*T
 *  0b101..The sampling time equasl to 32*T
 *  0b110..The sampling time equasl to 64*T
 *  0b111..The sampling time equasl to 256*T
 */
#define CMP_C3_ACSAT(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C3_ACSAT_SHIFT)) & CMP_C3_ACSAT_MASK)
#define CMP_C3_DMCS_MASK                         (0x10000U)
#define CMP_C3_DMCS_SHIFT                        (16U)
/*! DMCS - Discrete Mode Clock Selection
 *  0b0..Slow clock is selected for the timing generation.
 *  0b1..Fast clock is selected for the timing generation.
 */
#define CMP_C3_DMCS(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C3_DMCS_SHIFT)) & CMP_C3_DMCS_MASK)
#define CMP_C3_RDIVE_MASK                        (0x100000U)
#define CMP_C3_RDIVE_SHIFT                       (20U)
/*! RDIVE - Resistor Divider Enable
 *  0b0..The resistor is not enabled even when either NCHEN or PCHEN is set to1 but the actual input is in the range of 0 - 1.8v.
 *  0b1..The resistor is enabled because the inputs are above 1.8v.
 */
#define CMP_C3_RDIVE(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C3_RDIVE_SHIFT)) & CMP_C3_RDIVE_MASK)
#define CMP_C3_NCHCTEN_MASK                      (0x1000000U)
#define CMP_C3_NCHCTEN_SHIFT                     (24U)
/*! NCHCTEN - Negative Channel Continuous Mode Enable.
 *  0b0..Negative channel is in Discrete Mode and special timing needs to be configured.
 *  0b1..Negative channel is in Continuous Mode and no special timing is requried.
 */
#define CMP_C3_NCHCTEN(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C3_NCHCTEN_SHIFT)) & CMP_C3_NCHCTEN_MASK)
#define CMP_C3_PCHCTEN_MASK                      (0x10000000U)
#define CMP_C3_PCHCTEN_SHIFT                     (28U)
/*! PCHCTEN - Positive Channel Continuous Mode Enable.
 *  0b0..Positive channel is in Discrete Mode and special timing needs to be configured.
 *  0b1..Positive channel is in Continuous Mode and no special timing is requried.
 */
#define CMP_C3_PCHCTEN(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C3_PCHCTEN_SHIFT)) & CMP_C3_PCHCTEN_MASK)
/*! @} */

/*! @name RR_TIMER_CR - Round-Robin Timer Control Register */
/*! @{ */
#define CMP_RR_TIMER_CR_RR_TIMER_RELOAD_MASK     (0xFFFFFFFU)
#define CMP_RR_TIMER_CR_RR_TIMER_RELOAD_SHIFT    (0U)
/*! RR_TIMER_RELOAD - This field establishes the repetitive count rate for the timer. Each time the
 *    timer counts down to zero it is reloaded with this value. The rr_trig signal will be generated
 *    at a rate of (rr_timer_reload + 1) times the rr_clock period (typically 30.6 uS)
 */
#define CMP_RR_TIMER_CR_RR_TIMER_RELOAD(x)       (((uint32_t)(((uint32_t)(x)) << CMP_RR_TIMER_CR_RR_TIMER_RELOAD_SHIFT)) & CMP_RR_TIMER_CR_RR_TIMER_RELOAD_MASK)
#define CMP_RR_TIMER_CR_RR_TIMER_ENA_MASK        (0x80000000U)
#define CMP_RR_TIMER_CR_RR_TIMER_ENA_SHIFT       (31U)
/*! RR_TIMER_ENA - RR_TIMER enable
 */
#define CMP_RR_TIMER_CR_RR_TIMER_ENA(x)          (((uint32_t)(((uint32_t)(x)) << CMP_RR_TIMER_CR_RR_TIMER_ENA_SHIFT)) & CMP_RR_TIMER_CR_RR_TIMER_ENA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CMP_Register_Masks */


/* CMP - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral ACMP0 base address */
  #define ACMP0_BASE                               (0x50139000u)
  /** Peripheral ACMP0 base address */
  #define ACMP0_BASE_NS                            (0x40139000u)
  /** Peripheral ACMP0 base pointer */
  #define ACMP0                                    ((CMP_Type *)ACMP0_BASE)
  /** Peripheral ACMP0 base pointer */
  #define ACMP0_NS                                 ((CMP_Type *)ACMP0_BASE_NS)
  /** Array initializer of CMP peripheral base addresses */
  #define CMP_BASE_ADDRS                           { ACMP0_BASE }
  /** Array initializer of CMP peripheral base pointers */
  #define CMP_BASE_PTRS                            { ACMP0 }
  /** Array initializer of CMP peripheral base addresses */
  #define CMP_BASE_ADDRS_NS                        { ACMP0_BASE_NS }
  /** Array initializer of CMP peripheral base pointers */
  #define CMP_BASE_PTRS_NS                         { ACMP0_NS }
#else
  /** Peripheral ACMP0 base address */
  #define ACMP0_BASE                               (0x40139000u)
  /** Peripheral ACMP0 base pointer */
  #define ACMP0                                    ((CMP_Type *)ACMP0_BASE)
  /** Array initializer of CMP peripheral base addresses */
  #define CMP_BASE_ADDRS                           { ACMP0_BASE }
  /** Array initializer of CMP peripheral base pointers */
  #define CMP_BASE_PTRS                            { ACMP0 }
#endif
/** Interrupt vectors for the CMP peripheral type */
#define CMP_IRQS                                 { ACMP_IRQn }

/*!
 * @}
 */ /* end of group CMP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  __IO uint32_t MODE;                              /**< MODE Register, offset: 0x0 */
  __IO uint32_t SEED;                              /**< CRC Seed Register, offset: 0x4 */
  union {                                          /* offset: 0x8 */
    __I  uint32_t SUM;                               /**< CRC Sum, offset: 0x8 */
    __IO uint32_t WR_DATA;                           /**< CRC Write Data, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name MODE - MODE Register */
/*! @{ */
#define CRC_MODE_CRC_POLY_MASK                   (0x3U)
#define CRC_MODE_CRC_POLY_SHIFT                  (0U)
/*! CRC_POLY - CRC Polynomial
 *  0b00..Use CRC-CCITT polynomial
 *  0b01..Use CRC-16 polynomial
 *  0b10..Use CRC-32 polynomial
 *  0b11..Reserved
 */
#define CRC_MODE_CRC_POLY(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CRC_POLY_SHIFT)) & CRC_MODE_CRC_POLY_MASK)
#define CRC_MODE_BIT_RVS_WR_MASK                 (0x4U)
#define CRC_MODE_BIT_RVS_WR_SHIFT                (2U)
/*! BIT_RVS_WR - Bit-order Reverse for Write Data
 *  0b0..Do not use bit-order reverse for WR_DATA (per byte)
 *  0b1..Use bit-order reverse for WR_DATA (per byte)
 */
#define CRC_MODE_BIT_RVS_WR(x)                   (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_WR_SHIFT)) & CRC_MODE_BIT_RVS_WR_MASK)
#define CRC_MODE_CMPL_WR_MASK                    (0x8U)
#define CRC_MODE_CMPL_WR_SHIFT                   (3U)
/*! CMPL_WR - 1's Complement for Write Data
 *  0b0..Do not use 1's complement for WR_DATA
 *  0b1..Use 1's complement for WR_DATA
 */
#define CRC_MODE_CMPL_WR(x)                      (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_WR_SHIFT)) & CRC_MODE_CMPL_WR_MASK)
#define CRC_MODE_BIT_RVS_SUM_MASK                (0x10U)
#define CRC_MODE_BIT_RVS_SUM_SHIFT               (4U)
/*! BIT_RVS_SUM - Bit-order Reverse for CRC Sum
 *  0b0..Do not use bit-order reverse for CRC Sum
 *  0b1..Use bit-order reverse for CRC Sum
 */
#define CRC_MODE_BIT_RVS_SUM(x)                  (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_SUM_SHIFT)) & CRC_MODE_BIT_RVS_SUM_MASK)
#define CRC_MODE_CMPL_SUM_MASK                   (0x20U)
#define CRC_MODE_CMPL_SUM_SHIFT                  (5U)
/*! CMPL_SUM - 1's Complement for CRC Sum
 *  0b0..Do not use 1's complement for CRC Sum
 *  0b1..Use 1's complement for CRC Sum
 */
#define CRC_MODE_CMPL_SUM(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_SUM_SHIFT)) & CRC_MODE_CMPL_SUM_MASK)
/*! @} */

/*! @name SEED - CRC Seed Register */
/*! @{ */
#define CRC_SEED_CRC_SEED_MASK                   (0xFFFFFFFFU)
#define CRC_SEED_CRC_SEED_SHIFT                  (0U)
/*! CRC_SEED - CRC Seed
 */
#define CRC_SEED_CRC_SEED(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_SEED_CRC_SEED_SHIFT)) & CRC_SEED_CRC_SEED_MASK)
/*! @} */

/*! @name SUM - CRC Sum */
/*! @{ */
#define CRC_SUM_CRC_SUM_MASK                     (0xFFFFFFFFU)
#define CRC_SUM_CRC_SUM_SHIFT                    (0U)
/*! CRC_SUM - CRC Sum
 */
#define CRC_SUM_CRC_SUM(x)                       (((uint32_t)(((uint32_t)(x)) << CRC_SUM_CRC_SUM_SHIFT)) & CRC_SUM_CRC_SUM_MASK)
/*! @} */

/*! @name WR_DATA - CRC Write Data */
/*! @{ */
#define CRC_WR_DATA_WR_DATA_MASK                 (0xFFFFFFFFU)
#define CRC_WR_DATA_WR_DATA_SHIFT                (0U)
/*! WR_DATA - CRC Write Data
 */
#define CRC_WR_DATA_WR_DATA(x)                   (((uint32_t)(((uint32_t)(x)) << CRC_WR_DATA_WR_DATA_SHIFT)) & CRC_WR_DATA_WR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral CRC_ENGINE base address */
  #define CRC_ENGINE_BASE                          (0x50120000u)
  /** Peripheral CRC_ENGINE base address */
  #define CRC_ENGINE_BASE_NS                       (0x40120000u)
  /** Peripheral CRC_ENGINE base pointer */
  #define CRC_ENGINE                               ((CRC_Type *)CRC_ENGINE_BASE)
  /** Peripheral CRC_ENGINE base pointer */
  #define CRC_ENGINE_NS                            ((CRC_Type *)CRC_ENGINE_BASE_NS)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC_ENGINE_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC_ENGINE }
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS_NS                        { CRC_ENGINE_BASE_NS }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS_NS                         { CRC_ENGINE_NS }
#else
  /** Peripheral CRC_ENGINE base address */
  #define CRC_ENGINE_BASE                          (0x40120000u)
  /** Peripheral CRC_ENGINE base pointer */
  #define CRC_ENGINE                               ((CRC_Type *)CRC_ENGINE_BASE)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC_ENGINE_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC_ENGINE }
#endif

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct {
  __IO uint32_t IR;                                /**< Interrupt Register., offset: 0x0 */
  __IO uint32_t TCR;                               /**< Timer Control Register, offset: 0x4 */
  __IO uint32_t TC;                                /**< Timer Counter, offset: 0x8 */
  __IO uint32_t PR;                                /**< Prescale Register, offset: 0xC */
  __IO uint32_t PC;                                /**< Prescale Counter., offset: 0x10 */
  __IO uint32_t MCR;                               /**< Match Control Register., offset: 0x14 */
  __IO uint32_t MR[4];                             /**< Match Register, array offset: 0x18, array step: 0x4 */
  __IO uint32_t CCR;                               /**< Capture Control Register, offset: 0x28 */
  __I  uint32_t CR[4];                             /**< Capture Register, array offset: 0x2C, array step: 0x4 */
  __IO uint32_t EMR;                               /**< External Match Register, offset: 0x3C */
       uint8_t RESERVED_0[48];
  __IO uint32_t CTCR;                              /**< Count Control Register, offset: 0x70 */
  __IO uint32_t PWMC;                              /**< PWM Control Register, offset: 0x74 */
  __IO uint32_t MSR[4];                            /**< Match Shadow Register, array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt Register. */
/*! @{ */
#define CTIMER_IR_MR0INT_MASK                    (0x1U)
#define CTIMER_IR_MR0INT_SHIFT                   (0U)
/*! MR0INT - Interrupt flag for match channel 0
 */
#define CTIMER_IR_MR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)
#define CTIMER_IR_MR1INT_MASK                    (0x2U)
#define CTIMER_IR_MR1INT_SHIFT                   (1U)
/*! MR1INT - Interrupt flag for match channel 1
 */
#define CTIMER_IR_MR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)
#define CTIMER_IR_MR2INT_MASK                    (0x4U)
#define CTIMER_IR_MR2INT_SHIFT                   (2U)
/*! MR2INT - Interrupt flag for match channel 2
 */
#define CTIMER_IR_MR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)
#define CTIMER_IR_MR3INT_MASK                    (0x8U)
#define CTIMER_IR_MR3INT_SHIFT                   (3U)
/*! MR3INT - Interrupt flag for match channel 3
 */
#define CTIMER_IR_MR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)
#define CTIMER_IR_CR0INT_MASK                    (0x10U)
#define CTIMER_IR_CR0INT_SHIFT                   (4U)
/*! CR0INT - Interrupt flag for capture channel 0 event
 */
#define CTIMER_IR_CR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)
#define CTIMER_IR_CR1INT_MASK                    (0x20U)
#define CTIMER_IR_CR1INT_SHIFT                   (5U)
/*! CR1INT - Interrupt flag for capture channel 1 event
 */
#define CTIMER_IR_CR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)
#define CTIMER_IR_CR2INT_MASK                    (0x40U)
#define CTIMER_IR_CR2INT_SHIFT                   (6U)
/*! CR2INT - Interrupt flag for capture channel 2 event
 */
#define CTIMER_IR_CR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)
#define CTIMER_IR_CR3INT_MASK                    (0x80U)
#define CTIMER_IR_CR3INT_SHIFT                   (7U)
/*! CR3INT - Interrupt flag for capture channel 3 event
 */
#define CTIMER_IR_CR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control Register */
/*! @{ */
#define CTIMER_TCR_CEN_MASK                      (0x1U)
#define CTIMER_TCR_CEN_SHIFT                     (0U)
/*! CEN - Counter enable.
 *  0b0..Disabled. The counters are disabled.
 *  0b1..Enabled. The Timer Counter and Prescale Counter are enabled.
 */
#define CTIMER_TCR_CEN(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)
#define CTIMER_TCR_CRST_MASK                     (0x2U)
#define CTIMER_TCR_CRST_SHIFT                    (1U)
/*! CRST - Counter reset.
 *  0b0..Disabled. Do nothing.
 *  0b1..Enabled
 */
#define CTIMER_TCR_CRST(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)
/*! @} */

/*! @name TC - Timer Counter */
/*! @{ */
#define CTIMER_TC_TCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT                    (0U)
/*! TCVAL - Timer counter value.
 */
#define CTIMER_TC_TCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale Register */
/*! @{ */
#define CTIMER_PR_PRVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT                    (0U)
/*! PRVAL - Prescale reload value.
 */
#define CTIMER_PR_PRVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter. */
/*! @{ */
#define CTIMER_PC_PCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT                    (0U)
/*! PCVAL - Prescale counter value.
 */
#define CTIMER_PC_PCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control Register. */
/*! @{ */
#define CTIMER_MCR_MR0I_MASK                     (0x1U)
#define CTIMER_MCR_MR0I_SHIFT                    (0U)
/*! MR0I - Interrupt on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)
#define CTIMER_MCR_MR0R_MASK                     (0x2U)
#define CTIMER_MCR_MR0R_SHIFT                    (1U)
/*! MR0R - Reset on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)
#define CTIMER_MCR_MR0S_MASK                     (0x4U)
#define CTIMER_MCR_MR0S_SHIFT                    (2U)
/*! MR0S - Stop on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)
#define CTIMER_MCR_MR1I_MASK                     (0x8U)
#define CTIMER_MCR_MR1I_SHIFT                    (3U)
/*! MR1I - Interrupt on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)
#define CTIMER_MCR_MR1R_MASK                     (0x10U)
#define CTIMER_MCR_MR1R_SHIFT                    (4U)
/*! MR1R - Reset on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)
#define CTIMER_MCR_MR1S_MASK                     (0x20U)
#define CTIMER_MCR_MR1S_SHIFT                    (5U)
/*! MR1S - Stop on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)
#define CTIMER_MCR_MR2I_MASK                     (0x40U)
#define CTIMER_MCR_MR2I_SHIFT                    (6U)
/*! MR2I - Interrupt on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)
#define CTIMER_MCR_MR2R_MASK                     (0x80U)
#define CTIMER_MCR_MR2R_SHIFT                    (7U)
/*! MR2R - Reset on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)
#define CTIMER_MCR_MR2S_MASK                     (0x100U)
#define CTIMER_MCR_MR2S_SHIFT                    (8U)
/*! MR2S - Stop on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)
#define CTIMER_MCR_MR3I_MASK                     (0x200U)
#define CTIMER_MCR_MR3I_SHIFT                    (9U)
/*! MR3I - Interrupt on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)
#define CTIMER_MCR_MR3R_MASK                     (0x400U)
#define CTIMER_MCR_MR3R_SHIFT                    (10U)
/*! MR3R - Reset on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)
#define CTIMER_MCR_MR3S_MASK                     (0x800U)
#define CTIMER_MCR_MR3S_SHIFT                    (11U)
/*! MR3S - Stop on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)
#define CTIMER_MCR_MR0RL_MASK                    (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT                   (24U)
/*! MR0RL - Reload MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)
#define CTIMER_MCR_MR1RL_MASK                    (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT                   (25U)
/*! MR1RL - Reload MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)
#define CTIMER_MCR_MR2RL_MASK                    (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT                   (26U)
/*! MR2RL - Reload MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)
#define CTIMER_MCR_MR3RL_MASK                    (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT                   (27U)
/*! MR3RL - Reload MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match Register */
/*! @{ */
#define CTIMER_MR_MATCH_MASK                     (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT                    (0U)
/*! MATCH - Timer counter match value.
 */
#define CTIMER_MR_MATCH(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT                          (4U)

/*! @name CCR - Capture Control Register */
/*! @{ */
#define CTIMER_CCR_CAP0RE_MASK                   (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT                  (0U)
/*! CAP0RE - Rising edge of capture channel 0: a sequence of 0 then 1 causes CR0 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)
#define CTIMER_CCR_CAP0FE_MASK                   (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT                  (1U)
/*! CAP0FE - Falling edge of capture channel 0: a sequence of 1 then 0 causes CR0 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)
#define CTIMER_CCR_CAP0I_MASK                    (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT                   (2U)
/*! CAP0I - Generate interrupt on channel 0 capture event: a CR0 load generates an interrupt.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)
#define CTIMER_CCR_CAP1RE_MASK                   (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT                  (3U)
/*! CAP1RE - Rising edge of capture channel 1: a sequence of 0 then 1 causes CR1 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)
#define CTIMER_CCR_CAP1FE_MASK                   (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT                  (4U)
/*! CAP1FE - Falling edge of capture channel 1: a sequence of 1 then 0 causes CR1 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)
#define CTIMER_CCR_CAP1I_MASK                    (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT                   (5U)
/*! CAP1I - Generate interrupt on channel 1 capture event: a CR1 load generates an interrupt.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)
#define CTIMER_CCR_CAP2RE_MASK                   (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT                  (6U)
/*! CAP2RE - Rising edge of capture channel 2: a sequence of 0 then 1 causes CR2 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)
#define CTIMER_CCR_CAP2FE_MASK                   (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT                  (7U)
/*! CAP2FE - Falling edge of capture channel 2: a sequence of 1 then 0 causes CR2 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)
#define CTIMER_CCR_CAP2I_MASK                    (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT                   (8U)
/*! CAP2I - Generate interrupt on channel 2 capture event: a CR2 load generates an interrupt.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)
#define CTIMER_CCR_CAP3RE_MASK                   (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT                  (9U)
/*! CAP3RE - Rising edge of capture channel 3: a sequence of 0 then 1 causes CR3 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)
#define CTIMER_CCR_CAP3FE_MASK                   (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT                  (10U)
/*! CAP3FE - Falling edge of capture channel 3: a sequence of 1 then 0 causes CR3 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)
#define CTIMER_CCR_CAP3I_MASK                    (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT                   (11U)
/*! CAP3I - Generate interrupt on channel 3 capture event: a CR3 load generates an interrupt.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture Register */
/*! @{ */
#define CTIMER_CR_CAP_MASK                       (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT                      (0U)
/*! CAP - Timer counter capture value.
 */
#define CTIMER_CR_CAP(x)                         (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT                          (4U)

/*! @name EMR - External Match Register */
/*! @{ */
#define CTIMER_EMR_EM0_MASK                      (0x1U)
#define CTIMER_EMR_EM0_SHIFT                     (0U)
/*! EM0 - External Match 0
 */
#define CTIMER_EMR_EM0(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)
#define CTIMER_EMR_EM1_MASK                      (0x2U)
#define CTIMER_EMR_EM1_SHIFT                     (1U)
/*! EM1 - External Match 1
 */
#define CTIMER_EMR_EM1(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)
#define CTIMER_EMR_EM2_MASK                      (0x4U)
#define CTIMER_EMR_EM2_SHIFT                     (2U)
/*! EM2 - External Match 2
 */
#define CTIMER_EMR_EM2(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)
#define CTIMER_EMR_EM3_MASK                      (0x8U)
#define CTIMER_EMR_EM3_SHIFT                     (3U)
/*! EM3 - External Match 3
 */
#define CTIMER_EMR_EM3(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)
#define CTIMER_EMR_EMC0_MASK                     (0x30U)
#define CTIMER_EMR_EMC0_SHIFT                    (4U)
/*! EMC0 - External Match Control 0
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT0 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT0 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC0(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)
#define CTIMER_EMR_EMC1_MASK                     (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT                    (6U)
/*! EMC1 - External Match Control 1
 *  0b00..Do Nothing
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT1 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT1 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC1(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)
#define CTIMER_EMR_EMC2_MASK                     (0x300U)
#define CTIMER_EMR_EMC2_SHIFT                    (8U)
/*! EMC2 - External Match Control 2
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT2 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT2 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC2(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)
#define CTIMER_EMR_EMC3_MASK                     (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT                    (10U)
/*! EMC3 - External Match Control 3
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT3 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT3 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC3(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control Register */
/*! @{ */
#define CTIMER_CTCR_CTMODE_MASK                  (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT                 (0U)
/*! CTMODE - The Count Control Register (CTCR) is used to select between Timer and Counter mode, and
 *    in Counter mode to select the pin and edge(s) for counting.
 *  0b00..Timer Mode
 *  0b01..Counter Mode rising edge
 *  0b10..Counter Mode falling edge
 *  0b11..Counter Mode dual edge
 */
#define CTIMER_CTCR_CTMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)
#define CTIMER_CTCR_CINSEL_MASK                  (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT                 (2U)
/*! CINSEL - Count Input Select
 *  0b00..Channel 0. CAPn.0 for CTIMERn
 *  0b01..Channel 1. CAPn.1 for CTIMERn
 *  0b10..Channel 2. CAPn.2 for CTIMERn
 *  0b11..Channel 3. CAPn.3 for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)
#define CTIMER_CTCR_ENCC_MASK                    (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT                   (4U)
#define CTIMER_CTCR_ENCC(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)
#define CTIMER_CTCR_SELCC_MASK                   (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT                  (5U)
/*! SELCC - Edge select
 *  0b000..Channel 0 Rising Edge. Rising edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b001..Channel 0 Falling Edge. Falling edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b010..Channel 1 Rising Edge. Rising edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b011..Channel 1 Falling Edge. Falling edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b100..Channel 2 Rising Edge. Rising edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 *  0b101..Channel 2 Falling Edge. Falling edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 */
#define CTIMER_CTCR_SELCC(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control Register */
/*! @{ */
#define CTIMER_PWMC_PWMEN0_MASK                  (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT                 (0U)
/*! PWMEN0 - PWM mode enable for channel0.
 *  0b0..Match. CTIMERn_MAT0 is controlled by EM0.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT0.
 */
#define CTIMER_PWMC_PWMEN0(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)
#define CTIMER_PWMC_PWMEN1_MASK                  (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT                 (1U)
/*! PWMEN1 - PWM mode enable for channel1.
 *  0b0..Match. CTIMERn_MAT01 is controlled by EM1.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT1.
 */
#define CTIMER_PWMC_PWMEN1(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)
#define CTIMER_PWMC_PWMEN2_MASK                  (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT                 (2U)
/*! PWMEN2 - PWM mode enable for channel2.
 *  0b0..Match. CTIMERn_MAT2 is controlled by EM2.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT2.
 */
#define CTIMER_PWMC_PWMEN2(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)
#define CTIMER_PWMC_PWMEN3_MASK                  (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT                 (3U)
/*! PWMEN3 - PWM mode enable for channel3. Note: It is recommended to use match channel 3 to set the PWM cycle.
 *  0b0..Match. CTIMERn_MAT3 is controlled by EM3.
 *  0b1..PWM. PWM mode is enabled for CT132Bn_MAT3.
 */
#define CTIMER_PWMC_PWMEN3(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow Register */
/*! @{ */
#define CTIMER_MSR_MATCH_SHADOW_MASK             (0xFFFFFFFFU)
#define CTIMER_MSR_MATCH_SHADOW_SHIFT            (0U)
/*! MATCH_SHADOW - Timer counter match shadow value.
 */
#define CTIMER_MSR_MATCH_SHADOW(x)               (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_MATCH_SHADOW_SHIFT)) & CTIMER_MSR_MATCH_SHADOW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT                         (4U)


/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */


/* CTIMER - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE                             (0x50028000u)
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE_NS                          (0x40028000u)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0_NS                               ((CTIMER_Type *)CTIMER0_BASE_NS)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE                             (0x50029000u)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE_NS                          (0x40029000u)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1_NS                               ((CTIMER_Type *)CTIMER1_BASE_NS)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE                             (0x5002A000u)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE_NS                          (0x4002A000u)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2_NS                               ((CTIMER_Type *)CTIMER2_BASE_NS)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE                             (0x5002B000u)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE_NS                          (0x4002B000u)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3_NS                               ((CTIMER_Type *)CTIMER3_BASE_NS)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE                             (0x5002C000u)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE_NS                          (0x4002C000u)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4_NS                               ((CTIMER_Type *)CTIMER4_BASE_NS)
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS_NS                     { CTIMER0_BASE_NS, CTIMER1_BASE_NS, CTIMER2_BASE_NS, CTIMER3_BASE_NS, CTIMER4_BASE_NS }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS_NS                      { CTIMER0_NS, CTIMER1_NS, CTIMER2_NS, CTIMER3_NS, CTIMER4_NS }
#else
  /** Peripheral CTIMER0 base address */
  #define CTIMER0_BASE                             (0x40028000u)
  /** Peripheral CTIMER0 base pointer */
  #define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
  /** Peripheral CTIMER1 base address */
  #define CTIMER1_BASE                             (0x40029000u)
  /** Peripheral CTIMER1 base pointer */
  #define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
  /** Peripheral CTIMER2 base address */
  #define CTIMER2_BASE                             (0x4002A000u)
  /** Peripheral CTIMER2 base pointer */
  #define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
  /** Peripheral CTIMER3 base address */
  #define CTIMER3_BASE                             (0x4002B000u)
  /** Peripheral CTIMER3 base pointer */
  #define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
  /** Peripheral CTIMER4 base address */
  #define CTIMER4_BASE                             (0x4002C000u)
  /** Peripheral CTIMER4 base pointer */
  #define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
  /** Array initializer of CTIMER peripheral base addresses */
  #define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
  /** Array initializer of CTIMER peripheral base pointers */
  #define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
#endif
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                              { CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DEBUGGER_MAILBOX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DEBUGGER_MAILBOX_Peripheral_Access_Layer DEBUGGER_MAILBOX Peripheral Access Layer
 * @{
 */

/** DEBUGGER_MAILBOX - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSW;                               /**< Command and status word, offset: 0x0 */
  __IO uint32_t REQUEST;                           /**< Request Value, offset: 0x4 */
  __IO uint32_t RETURN;                            /**< Return Value, offset: 0x8 */
       uint8_t RESERVED_0[240];
  __I  uint32_t ID;                                /**< Identification, offset: 0xFC */
} DEBUGGER_MAILBOX_Type;

/* ----------------------------------------------------------------------------
   -- DEBUGGER_MAILBOX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DEBUGGER_MAILBOX_Register_Masks DEBUGGER_MAILBOX Register Masks
 * @{
 */

/*! @name CSW - Command and status word */
/*! @{ */
#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_MASK    (0x1U)
#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_SHIFT   (0U)
/*! RESYNCH_REQ - Re-synchronization Request
 *  0b0..No Request
 *  0b1..Request for re-synchronization
 */
#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_SHIFT)) & DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_MASK)
#define DEBUGGER_MAILBOX_CSW_REQ_PENDING_MASK    (0x2U)
#define DEBUGGER_MAILBOX_CSW_REQ_PENDING_SHIFT   (1U)
/*! REQ_PENDING - Request Pending
 *  0b0..No Request Pending
 *  0b1..Request for Re-synchronization Pending
 */
#define DEBUGGER_MAILBOX_CSW_REQ_PENDING(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_REQ_PENDING_SHIFT)) & DEBUGGER_MAILBOX_CSW_REQ_PENDING_MASK)
#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_MASK     (0x4U)
#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_SHIFT    (2U)
/*! DBG_OR_ERR - Debug Overrun Error
 *  0b0..No Debug Overrun error
 *  0b1..Debug Overrun Error. A debug overrun occurred.
 */
#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_SHIFT)) & DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_MASK)
#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_MASK     (0x8U)
#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_SHIFT    (3U)
/*! AHB_OR_ERR - AHB Overrun Error
 *  0b0..No AHB Overrun Error
 *  0b1..AHB Overrun Error. An AHB overrun occurred.
 */
#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_SHIFT)) & DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_MASK)
#define DEBUGGER_MAILBOX_CSW_SOFT_RESET_MASK     (0x10U)
#define DEBUGGER_MAILBOX_CSW_SOFT_RESET_SHIFT    (4U)
/*! SOFT_RESET - Soft Reset
 */
#define DEBUGGER_MAILBOX_CSW_SOFT_RESET(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_SOFT_RESET_SHIFT)) & DEBUGGER_MAILBOX_CSW_SOFT_RESET_MASK)
#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_MASK (0x20U)
#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_SHIFT (5U)
/*! CHIP_RESET_REQ - Chip Reset Request
 */
#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ(x)   (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_SHIFT)) & DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_MASK)
/*! @} */

/*! @name REQUEST - Request Value */
/*! @{ */
#define DEBUGGER_MAILBOX_REQUEST_REQUEST_MASK    (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_REQUEST_REQUEST_SHIFT   (0U)
/*! REQUEST - Request Value
 */
#define DEBUGGER_MAILBOX_REQUEST_REQUEST(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_REQUEST_REQUEST_SHIFT)) & DEBUGGER_MAILBOX_REQUEST_REQUEST_MASK)
/*! @} */

/*! @name RETURN - Return Value */
/*! @{ */
#define DEBUGGER_MAILBOX_RETURN_RETURN_MASK      (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_RETURN_RETURN_SHIFT     (0U)
/*! RETURN - Return Value
 */
#define DEBUGGER_MAILBOX_RETURN_RETURN(x)        (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_RETURN_RETURN_SHIFT)) & DEBUGGER_MAILBOX_RETURN_RETURN_MASK)
/*! @} */

/*! @name ID - Identification */
/*! @{ */
#define DEBUGGER_MAILBOX_ID_ID_MASK              (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_ID_ID_SHIFT             (0U)
/*! ID - Identification Value
 */
#define DEBUGGER_MAILBOX_ID_ID(x)                (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_ID_ID_SHIFT)) & DEBUGGER_MAILBOX_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DEBUGGER_MAILBOX_Register_Masks */


/* DEBUGGER_MAILBOX - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral DEBUGGER_MAILBOX base address */
  #define DEBUGGER_MAILBOX_BASE                    (0x5010F000u)
  /** Peripheral DEBUGGER_MAILBOX base address */
  #define DEBUGGER_MAILBOX_BASE_NS                 (0x4010F000u)
  /** Peripheral DEBUGGER_MAILBOX base pointer */
  #define DEBUGGER_MAILBOX                         ((DEBUGGER_MAILBOX_Type *)DEBUGGER_MAILBOX_BASE)
  /** Peripheral DEBUGGER_MAILBOX base pointer */
  #define DEBUGGER_MAILBOX_NS                      ((DEBUGGER_MAILBOX_Type *)DEBUGGER_MAILBOX_BASE_NS)
  /** Array initializer of DEBUGGER_MAILBOX peripheral base addresses */
  #define DEBUGGER_MAILBOX_BASE_ADDRS              { DEBUGGER_MAILBOX_BASE }
  /** Array initializer of DEBUGGER_MAILBOX peripheral base pointers */
  #define DEBUGGER_MAILBOX_BASE_PTRS               { DEBUGGER_MAILBOX }
  /** Array initializer of DEBUGGER_MAILBOX peripheral base addresses */
  #define DEBUGGER_MAILBOX_BASE_ADDRS_NS           { DEBUGGER_MAILBOX_BASE_NS }
  /** Array initializer of DEBUGGER_MAILBOX peripheral base pointers */
  #define DEBUGGER_MAILBOX_BASE_PTRS_NS            { DEBUGGER_MAILBOX_NS }
#else
  /** Peripheral DEBUGGER_MAILBOX base address */
  #define DEBUGGER_MAILBOX_BASE                    (0x4010F000u)
  /** Peripheral DEBUGGER_MAILBOX base pointer */
  #define DEBUGGER_MAILBOX                         ((DEBUGGER_MAILBOX_Type *)DEBUGGER_MAILBOX_BASE)
  /** Array initializer of DEBUGGER_MAILBOX peripheral base addresses */
  #define DEBUGGER_MAILBOX_BASE_ADDRS              { DEBUGGER_MAILBOX_BASE }
  /** Array initializer of DEBUGGER_MAILBOX peripheral base pointers */
  #define DEBUGGER_MAILBOX_BASE_PTRS               { DEBUGGER_MAILBOX }
#endif

/*!
 * @}
 */ /* end of group DEBUGGER_MAILBOX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< DMA control, offset: 0x0 */
  __I  uint32_t INTSTAT;                           /**< Interrupt status, offset: 0x4 */
  __IO uint32_t SRAMBASE;                          /**< SRAM address of the channel configuration table, offset: 0x8 */
       uint8_t RESERVED_0[20];
  struct {                                         /* offset: 0x20, array step: 0x60 */
    __IO uint32_t ENABLESET;                         /**< Channel Enable read and set for all DMA channels, array offset: 0x20, array step: 0x60 */
    __IO uint32_t ENABLESET1;                        /**< Channel Enable read and set for all DMA channels, array offset: 0x24, array step: 0x60 */
    __IO uint32_t ENABLECLR;                         /**< Channel Enable Clear for all DMA channels, array offset: 0x28, array step: 0x60 */
    __IO uint32_t ENABLECLR1;                        /**< Channel Enable Clear for all DMA channels, array offset: 0x2C, array step: 0x60 */
    __I  uint32_t ACTIVE;                            /**< Channel Active status for all DMA channels, array offset: 0x30, array step: 0x60 */
    __I  uint32_t ACTIVE1;                           /**< Channel Active status for all DMA channels, array offset: 0x34, array step: 0x60 */
    __I  uint32_t BUSY;                              /**< Channel Busy status for all DMA channels, array offset: 0x38, array step: 0x60 */
    __I  uint32_t BUSY1;                             /**< Channel Busy status for all DMA channels, array offset: 0x3C, array step: 0x60 */
    __IO uint32_t ERRINT;                            /**< Error Interrupt status for all DMA channels, array offset: 0x40, array step: 0x60 */
    __IO uint32_t ERRINT1;                           /**< Error Interrupt status for all DMA channels, array offset: 0x44, array step: 0x60 */
    __IO uint32_t INTENSET;                          /**< Interrupt Enable read and Set for all DMA channels, array offset: 0x48, array step: 0x60 */
    __IO uint32_t INTENSET1;                         /**< Interrupt Enable read and Set for all DMA channels, array offset: 0x4C, array step: 0x60 */
    __O  uint32_t INTENCLR;                          /**< Interrupt Enable Clear for all DMA channels, array offset: 0x50, array step: 0x60 */
    __O  uint32_t INTENCLR1;                         /**< Interrupt Enable Clear for all DMA channels, array offset: 0x54, array step: 0x60 */
    __IO uint32_t INTA;                              /**< Interrupt A status for all DMA channels, array offset: 0x58, array step: 0x60 */
    __IO uint32_t INTA1;                             /**< Interrupt A status for all DMA channels, array offset: 0x5C, array step: 0x60 */
    __IO uint32_t INTB;                              /**< Interrupt B status for all DMA channels, array offset: 0x60, array step: 0x60 */
    __IO uint32_t INTB1;                             /**< Interrupt B status for all DMA channels, array offset: 0x64, array step: 0x60 */
    __O  uint32_t SETVALID;                          /**< Set ValidPending control bits for all DMA channels, array offset: 0x68, array step: 0x60 */
    __O  uint32_t SETVALID1;                         /**< Set ValidPending control bits for all DMA channels, array offset: 0x6C, array step: 0x60 */
    __O  uint32_t SETTRIG;                           /**< Set Trigger control bits for all DMA channels, array offset: 0x70, array step: 0x60 */
    __O  uint32_t SETTRIG1;                          /**< Set Trigger control bits for all DMA channels, array offset: 0x74, array step: 0x60 */
    __O  uint32_t ABORT;                             /**< Channel Abort control for all DMA channels, array offset: 0x78, array step: 0x60 */
    __O  uint32_t ABORT1;                            /**< Channel Abort control for all DMA channels, array offset: 0x7C, array step: 0x60 */
  } COMMON[1];
       uint8_t RESERVED_1[896];
  struct {                                         /* offset: 0x400, array step: 0x10 */
    __IO uint32_t CFG;                               /**< Configuration register for DMA channel, array offset: 0x400, array step: 0x10 */
    __I  uint32_t CTLSTAT;                           /**< Control and status register for DMA channel, array offset: 0x404, array step: 0x10 */
    __IO uint32_t XFERCFG;                           /**< Transfer configuration register for DMA channel, array offset: 0x408, array step: 0x10 */
         uint8_t RESERVED_0[4];
  } CHANNEL[37];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name CTRL - DMA control */
/*! @{ */
#define DMA_CTRL_ENABLE_MASK                     (0x1U)
#define DMA_CTRL_ENABLE_SHIFT                    (0U)
/*! ENABLE - DMA controller master enable.
 *  0b0..DMA controller is disabled.
 *  0b1..Enabled.
 */
#define DMA_CTRL_ENABLE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CTRL_ENABLE_SHIFT)) & DMA_CTRL_ENABLE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status */
/*! @{ */
#define DMA_INTSTAT_ACTIVEINT_MASK               (0x2U)
#define DMA_INTSTAT_ACTIVEINT_SHIFT              (1U)
/*! ACTIVEINT - Summarizes whether any enabled interrupts (other than error interrupts) are pending.
 *  0b0..No enabled interrupts are pending.
 *  0b1..At least one enabled interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEINT(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEINT_SHIFT)) & DMA_INTSTAT_ACTIVEINT_MASK)
#define DMA_INTSTAT_ACTIVEERRINT_MASK            (0x4U)
#define DMA_INTSTAT_ACTIVEERRINT_SHIFT           (2U)
/*! ACTIVEERRINT - Summarizes whether any error interrupts are pending.
 *  0b0..No error interrupts are pending.
 *  0b1..At least one error interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEERRINT(x)              (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEERRINT_SHIFT)) & DMA_INTSTAT_ACTIVEERRINT_MASK)
/*! @} */

/*! @name SRAMBASE - SRAM address of the channel configuration table */
/*! @{ */
#define DMA_SRAMBASE_OFFSET_MASK                 (0xFFFFFE00U)
#define DMA_SRAMBASE_OFFSET_SHIFT                (9U)
/*! OFFSET - Offset
 */
#define DMA_SRAMBASE_OFFSET(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_SRAMBASE_OFFSET_SHIFT)) & DMA_SRAMBASE_OFFSET_MASK)
/*! @} */

/*! @name COMMON_ENABLESET - Channel Enable read and set for all DMA channels */
/*! @{ */
#define DMA_COMMON_ENABLESET_ENABLE0_MASK        (0x1U)
#define DMA_COMMON_ENABLESET_ENABLE0_SHIFT       (0U)
/*! ENABLE0 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE0(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE0_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE0_MASK)
#define DMA_COMMON_ENABLESET_ENABLE1_MASK        (0x2U)
#define DMA_COMMON_ENABLESET_ENABLE1_SHIFT       (1U)
/*! ENABLE1 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE1(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE1_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE1_MASK)
#define DMA_COMMON_ENABLESET_ENABLE2_MASK        (0x4U)
#define DMA_COMMON_ENABLESET_ENABLE2_SHIFT       (2U)
/*! ENABLE2 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE2(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE2_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE2_MASK)
#define DMA_COMMON_ENABLESET_ENABLE3_MASK        (0x8U)
#define DMA_COMMON_ENABLESET_ENABLE3_SHIFT       (3U)
/*! ENABLE3 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE3(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE3_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE3_MASK)
#define DMA_COMMON_ENABLESET_ENABLE4_MASK        (0x10U)
#define DMA_COMMON_ENABLESET_ENABLE4_SHIFT       (4U)
/*! ENABLE4 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE4(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE4_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE4_MASK)
#define DMA_COMMON_ENABLESET_ENABLE5_MASK        (0x20U)
#define DMA_COMMON_ENABLESET_ENABLE5_SHIFT       (5U)
/*! ENABLE5 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE5(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE5_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE5_MASK)
#define DMA_COMMON_ENABLESET_ENABLE6_MASK        (0x40U)
#define DMA_COMMON_ENABLESET_ENABLE6_SHIFT       (6U)
/*! ENABLE6 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE6(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE6_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE6_MASK)
#define DMA_COMMON_ENABLESET_ENABLE7_MASK        (0x80U)
#define DMA_COMMON_ENABLESET_ENABLE7_SHIFT       (7U)
/*! ENABLE7 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE7(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE7_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE7_MASK)
#define DMA_COMMON_ENABLESET_ENABLE8_MASK        (0x100U)
#define DMA_COMMON_ENABLESET_ENABLE8_SHIFT       (8U)
/*! ENABLE8 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE8(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE8_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE8_MASK)
#define DMA_COMMON_ENABLESET_ENABLE9_MASK        (0x200U)
#define DMA_COMMON_ENABLESET_ENABLE9_SHIFT       (9U)
/*! ENABLE9 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE9(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE9_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE9_MASK)
#define DMA_COMMON_ENABLESET_ENABLE10_MASK       (0x400U)
#define DMA_COMMON_ENABLESET_ENABLE10_SHIFT      (10U)
/*! ENABLE10 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE10(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE10_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE10_MASK)
#define DMA_COMMON_ENABLESET_ENABLE11_MASK       (0x800U)
#define DMA_COMMON_ENABLESET_ENABLE11_SHIFT      (11U)
/*! ENABLE11 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE11(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE11_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE11_MASK)
#define DMA_COMMON_ENABLESET_ENABLE12_MASK       (0x1000U)
#define DMA_COMMON_ENABLESET_ENABLE12_SHIFT      (12U)
/*! ENABLE12 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE12(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE12_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE12_MASK)
#define DMA_COMMON_ENABLESET_ENABLE13_MASK       (0x2000U)
#define DMA_COMMON_ENABLESET_ENABLE13_SHIFT      (13U)
/*! ENABLE13 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE13(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE13_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE13_MASK)
#define DMA_COMMON_ENABLESET_ENABLE14_MASK       (0x4000U)
#define DMA_COMMON_ENABLESET_ENABLE14_SHIFT      (14U)
/*! ENABLE14 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE14(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE14_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE14_MASK)
#define DMA_COMMON_ENABLESET_ENABLE15_MASK       (0x8000U)
#define DMA_COMMON_ENABLESET_ENABLE15_SHIFT      (15U)
/*! ENABLE15 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE15(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE15_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE15_MASK)
#define DMA_COMMON_ENABLESET_ENABLE16_MASK       (0x10000U)
#define DMA_COMMON_ENABLESET_ENABLE16_SHIFT      (16U)
/*! ENABLE16 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE16(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE16_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE16_MASK)
#define DMA_COMMON_ENABLESET_ENABLE17_MASK       (0x20000U)
#define DMA_COMMON_ENABLESET_ENABLE17_SHIFT      (17U)
/*! ENABLE17 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE17(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE17_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE17_MASK)
#define DMA_COMMON_ENABLESET_ENABLE18_MASK       (0x40000U)
#define DMA_COMMON_ENABLESET_ENABLE18_SHIFT      (18U)
/*! ENABLE18 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE18(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE18_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE18_MASK)
#define DMA_COMMON_ENABLESET_ENABLE19_MASK       (0x80000U)
#define DMA_COMMON_ENABLESET_ENABLE19_SHIFT      (19U)
/*! ENABLE19 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE19(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE19_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE19_MASK)
#define DMA_COMMON_ENABLESET_ENABLE20_MASK       (0x100000U)
#define DMA_COMMON_ENABLESET_ENABLE20_SHIFT      (20U)
/*! ENABLE20 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE20(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE20_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE20_MASK)
#define DMA_COMMON_ENABLESET_ENABLE21_MASK       (0x200000U)
#define DMA_COMMON_ENABLESET_ENABLE21_SHIFT      (21U)
/*! ENABLE21 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE21(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE21_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE21_MASK)
#define DMA_COMMON_ENABLESET_ENABLE22_MASK       (0x400000U)
#define DMA_COMMON_ENABLESET_ENABLE22_SHIFT      (22U)
/*! ENABLE22 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE22(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE22_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE22_MASK)
#define DMA_COMMON_ENABLESET_ENABLE23_MASK       (0x800000U)
#define DMA_COMMON_ENABLESET_ENABLE23_SHIFT      (23U)
/*! ENABLE23 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE23(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE23_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE23_MASK)
#define DMA_COMMON_ENABLESET_ENABLE24_MASK       (0x1000000U)
#define DMA_COMMON_ENABLESET_ENABLE24_SHIFT      (24U)
/*! ENABLE24 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE24(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE24_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE24_MASK)
#define DMA_COMMON_ENABLESET_ENABLE25_MASK       (0x2000000U)
#define DMA_COMMON_ENABLESET_ENABLE25_SHIFT      (25U)
/*! ENABLE25 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE25(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE25_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE25_MASK)
#define DMA_COMMON_ENABLESET_ENABLE26_MASK       (0x4000000U)
#define DMA_COMMON_ENABLESET_ENABLE26_SHIFT      (26U)
/*! ENABLE26 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE26(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE26_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE26_MASK)
#define DMA_COMMON_ENABLESET_ENABLE27_MASK       (0x8000000U)
#define DMA_COMMON_ENABLESET_ENABLE27_SHIFT      (27U)
/*! ENABLE27 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE27(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE27_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE27_MASK)
#define DMA_COMMON_ENABLESET_ENABLE28_MASK       (0x10000000U)
#define DMA_COMMON_ENABLESET_ENABLE28_SHIFT      (28U)
/*! ENABLE28 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE28(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE28_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE28_MASK)
#define DMA_COMMON_ENABLESET_ENABLE29_MASK       (0x20000000U)
#define DMA_COMMON_ENABLESET_ENABLE29_SHIFT      (29U)
/*! ENABLE29 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE29(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE29_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE29_MASK)
#define DMA_COMMON_ENABLESET_ENABLE30_MASK       (0x40000000U)
#define DMA_COMMON_ENABLESET_ENABLE30_SHIFT      (30U)
/*! ENABLE30 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE30(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE30_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE30_MASK)
#define DMA_COMMON_ENABLESET_ENABLE31_MASK       (0x80000000U)
#define DMA_COMMON_ENABLESET_ENABLE31_SHIFT      (31U)
/*! ENABLE31 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE31(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE31_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE31_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET */
#define DMA_COMMON_ENABLESET_COUNT               (1U)

/*! @name COMMON_ENABLESET1 - Channel Enable read and set for all DMA channels */
/*! @{ */
#define DMA_COMMON_ENABLESET1_ENABLE32_MASK      (0x1U)
#define DMA_COMMON_ENABLESET1_ENABLE32_SHIFT     (0U)
/*! ENABLE32 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE32(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE32_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE32_MASK)
#define DMA_COMMON_ENABLESET1_ENABLE33_MASK      (0x2U)
#define DMA_COMMON_ENABLESET1_ENABLE33_SHIFT     (1U)
/*! ENABLE33 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE33(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE33_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE33_MASK)
#define DMA_COMMON_ENABLESET1_ENABLE34_MASK      (0x4U)
#define DMA_COMMON_ENABLESET1_ENABLE34_SHIFT     (2U)
/*! ENABLE34 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE34(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE34_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE34_MASK)
#define DMA_COMMON_ENABLESET1_ENABLE35_MASK      (0x8U)
#define DMA_COMMON_ENABLESET1_ENABLE35_SHIFT     (3U)
/*! ENABLE35 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE35(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE35_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE35_MASK)
#define DMA_COMMON_ENABLESET1_ENABLE36_MASK      (0x10U)
#define DMA_COMMON_ENABLESET1_ENABLE36_SHIFT     (4U)
/*! ENABLE36 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE36(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE36_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE36_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET1 */
#define DMA_COMMON_ENABLESET1_COUNT              (1U)

/*! @name COMMON_ENABLECLR - Channel Enable Clear for all DMA channels */
/*! @{ */
#define DMA_COMMON_ENABLECLR_CLR0_MASK           (0x1U)
#define DMA_COMMON_ENABLECLR_CLR0_SHIFT          (0U)
/*! CLR0 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR0(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR0_SHIFT)) & DMA_COMMON_ENABLECLR_CLR0_MASK)
#define DMA_COMMON_ENABLECLR_CLR1_MASK           (0x2U)
#define DMA_COMMON_ENABLECLR_CLR1_SHIFT          (1U)
/*! CLR1 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR1(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR1_SHIFT)) & DMA_COMMON_ENABLECLR_CLR1_MASK)
#define DMA_COMMON_ENABLECLR_CLR2_MASK           (0x4U)
#define DMA_COMMON_ENABLECLR_CLR2_SHIFT          (2U)
/*! CLR2 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR2(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR2_SHIFT)) & DMA_COMMON_ENABLECLR_CLR2_MASK)
#define DMA_COMMON_ENABLECLR_CLR3_MASK           (0x8U)
#define DMA_COMMON_ENABLECLR_CLR3_SHIFT          (3U)
/*! CLR3 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR3(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR3_SHIFT)) & DMA_COMMON_ENABLECLR_CLR3_MASK)
#define DMA_COMMON_ENABLECLR_CLR4_MASK           (0x10U)
#define DMA_COMMON_ENABLECLR_CLR4_SHIFT          (4U)
/*! CLR4 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR4(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR4_SHIFT)) & DMA_COMMON_ENABLECLR_CLR4_MASK)
#define DMA_COMMON_ENABLECLR_CLR5_MASK           (0x20U)
#define DMA_COMMON_ENABLECLR_CLR5_SHIFT          (5U)
/*! CLR5 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR5(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR5_SHIFT)) & DMA_COMMON_ENABLECLR_CLR5_MASK)
#define DMA_COMMON_ENABLECLR_CLR6_MASK           (0x40U)
#define DMA_COMMON_ENABLECLR_CLR6_SHIFT          (6U)
/*! CLR6 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR6(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR6_SHIFT)) & DMA_COMMON_ENABLECLR_CLR6_MASK)
#define DMA_COMMON_ENABLECLR_CLR7_MASK           (0x80U)
#define DMA_COMMON_ENABLECLR_CLR7_SHIFT          (7U)
/*! CLR7 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR7(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR7_SHIFT)) & DMA_COMMON_ENABLECLR_CLR7_MASK)
#define DMA_COMMON_ENABLECLR_CLR8_MASK           (0x100U)
#define DMA_COMMON_ENABLECLR_CLR8_SHIFT          (8U)
/*! CLR8 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR8(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR8_SHIFT)) & DMA_COMMON_ENABLECLR_CLR8_MASK)
#define DMA_COMMON_ENABLECLR_CLR9_MASK           (0x200U)
#define DMA_COMMON_ENABLECLR_CLR9_SHIFT          (9U)
/*! CLR9 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR9(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR9_SHIFT)) & DMA_COMMON_ENABLECLR_CLR9_MASK)
#define DMA_COMMON_ENABLECLR_CLR10_MASK          (0x400U)
#define DMA_COMMON_ENABLECLR_CLR10_SHIFT         (10U)
/*! CLR10 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR10(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR10_SHIFT)) & DMA_COMMON_ENABLECLR_CLR10_MASK)
#define DMA_COMMON_ENABLECLR_CLR11_MASK          (0x800U)
#define DMA_COMMON_ENABLECLR_CLR11_SHIFT         (11U)
/*! CLR11 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR11(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR11_SHIFT)) & DMA_COMMON_ENABLECLR_CLR11_MASK)
#define DMA_COMMON_ENABLECLR_CLR12_MASK          (0x1000U)
#define DMA_COMMON_ENABLECLR_CLR12_SHIFT         (12U)
/*! CLR12 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR12(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR12_SHIFT)) & DMA_COMMON_ENABLECLR_CLR12_MASK)
#define DMA_COMMON_ENABLECLR_CLR13_MASK          (0x2000U)
#define DMA_COMMON_ENABLECLR_CLR13_SHIFT         (13U)
/*! CLR13 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR13(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR13_SHIFT)) & DMA_COMMON_ENABLECLR_CLR13_MASK)
#define DMA_COMMON_ENABLECLR_CLR14_MASK          (0x4000U)
#define DMA_COMMON_ENABLECLR_CLR14_SHIFT         (14U)
/*! CLR14 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR14(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR14_SHIFT)) & DMA_COMMON_ENABLECLR_CLR14_MASK)
#define DMA_COMMON_ENABLECLR_CLR15_MASK          (0x8000U)
#define DMA_COMMON_ENABLECLR_CLR15_SHIFT         (15U)
/*! CLR15 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR15(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR15_SHIFT)) & DMA_COMMON_ENABLECLR_CLR15_MASK)
#define DMA_COMMON_ENABLECLR_CLR16_MASK          (0x10000U)
#define DMA_COMMON_ENABLECLR_CLR16_SHIFT         (16U)
/*! CLR16 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR16(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR16_SHIFT)) & DMA_COMMON_ENABLECLR_CLR16_MASK)
#define DMA_COMMON_ENABLECLR_CLR17_MASK          (0x20000U)
#define DMA_COMMON_ENABLECLR_CLR17_SHIFT         (17U)
/*! CLR17 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR17(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR17_SHIFT)) & DMA_COMMON_ENABLECLR_CLR17_MASK)
#define DMA_COMMON_ENABLECLR_CLR18_MASK          (0x40000U)
#define DMA_COMMON_ENABLECLR_CLR18_SHIFT         (18U)
/*! CLR18 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR18(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR18_SHIFT)) & DMA_COMMON_ENABLECLR_CLR18_MASK)
#define DMA_COMMON_ENABLECLR_CLR19_MASK          (0x80000U)
#define DMA_COMMON_ENABLECLR_CLR19_SHIFT         (19U)
/*! CLR19 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR19(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR19_SHIFT)) & DMA_COMMON_ENABLECLR_CLR19_MASK)
#define DMA_COMMON_ENABLECLR_CLR20_MASK          (0x100000U)
#define DMA_COMMON_ENABLECLR_CLR20_SHIFT         (20U)
/*! CLR20 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR20(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR20_SHIFT)) & DMA_COMMON_ENABLECLR_CLR20_MASK)
#define DMA_COMMON_ENABLECLR_CLR21_MASK          (0x200000U)
#define DMA_COMMON_ENABLECLR_CLR21_SHIFT         (21U)
/*! CLR21 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR21(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR21_SHIFT)) & DMA_COMMON_ENABLECLR_CLR21_MASK)
#define DMA_COMMON_ENABLECLR_CLR22_MASK          (0x400000U)
#define DMA_COMMON_ENABLECLR_CLR22_SHIFT         (22U)
/*! CLR22 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR22(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR22_SHIFT)) & DMA_COMMON_ENABLECLR_CLR22_MASK)
#define DMA_COMMON_ENABLECLR_CLR23_MASK          (0x800000U)
#define DMA_COMMON_ENABLECLR_CLR23_SHIFT         (23U)
/*! CLR23 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR23(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR23_SHIFT)) & DMA_COMMON_ENABLECLR_CLR23_MASK)
#define DMA_COMMON_ENABLECLR_CLR24_MASK          (0x1000000U)
#define DMA_COMMON_ENABLECLR_CLR24_SHIFT         (24U)
/*! CLR24 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR24(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR24_SHIFT)) & DMA_COMMON_ENABLECLR_CLR24_MASK)
#define DMA_COMMON_ENABLECLR_CLR25_MASK          (0x2000000U)
#define DMA_COMMON_ENABLECLR_CLR25_SHIFT         (25U)
/*! CLR25 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR25(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR25_SHIFT)) & DMA_COMMON_ENABLECLR_CLR25_MASK)
#define DMA_COMMON_ENABLECLR_CLR26_MASK          (0x4000000U)
#define DMA_COMMON_ENABLECLR_CLR26_SHIFT         (26U)
/*! CLR26 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR26(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR26_SHIFT)) & DMA_COMMON_ENABLECLR_CLR26_MASK)
#define DMA_COMMON_ENABLECLR_CLR27_MASK          (0x8000000U)
#define DMA_COMMON_ENABLECLR_CLR27_SHIFT         (27U)
/*! CLR27 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR27(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR27_SHIFT)) & DMA_COMMON_ENABLECLR_CLR27_MASK)
#define DMA_COMMON_ENABLECLR_CLR28_MASK          (0x10000000U)
#define DMA_COMMON_ENABLECLR_CLR28_SHIFT         (28U)
/*! CLR28 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR28(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR28_SHIFT)) & DMA_COMMON_ENABLECLR_CLR28_MASK)
#define DMA_COMMON_ENABLECLR_CLR29_MASK          (0x20000000U)
#define DMA_COMMON_ENABLECLR_CLR29_SHIFT         (29U)
/*! CLR29 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR29(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR29_SHIFT)) & DMA_COMMON_ENABLECLR_CLR29_MASK)
#define DMA_COMMON_ENABLECLR_CLR30_MASK          (0x40000000U)
#define DMA_COMMON_ENABLECLR_CLR30_SHIFT         (30U)
/*! CLR30 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR30(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR30_SHIFT)) & DMA_COMMON_ENABLECLR_CLR30_MASK)
#define DMA_COMMON_ENABLECLR_CLR31_MASK          (0x80000000U)
#define DMA_COMMON_ENABLECLR_CLR31_SHIFT         (31U)
/*! CLR31 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR31(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR31_SHIFT)) & DMA_COMMON_ENABLECLR_CLR31_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR */
#define DMA_COMMON_ENABLECLR_COUNT               (1U)

/*! @name COMMON_ENABLECLR1 - Channel Enable Clear for all DMA channels */
/*! @{ */
#define DMA_COMMON_ENABLECLR1_CLR32_MASK         (0x1U)
#define DMA_COMMON_ENABLECLR1_CLR32_SHIFT        (0U)
/*! CLR32 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR32(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR32_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR32_MASK)
#define DMA_COMMON_ENABLECLR1_CLR33_MASK         (0x2U)
#define DMA_COMMON_ENABLECLR1_CLR33_SHIFT        (1U)
/*! CLR33 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR33(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR33_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR33_MASK)
#define DMA_COMMON_ENABLECLR1_CLR34_MASK         (0x4U)
#define DMA_COMMON_ENABLECLR1_CLR34_SHIFT        (2U)
/*! CLR34 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR34(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR34_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR34_MASK)
#define DMA_COMMON_ENABLECLR1_CLR35_MASK         (0x8U)
#define DMA_COMMON_ENABLECLR1_CLR35_SHIFT        (3U)
/*! CLR35 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR35(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR35_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR35_MASK)
#define DMA_COMMON_ENABLECLR1_CLR36_MASK         (0x10U)
#define DMA_COMMON_ENABLECLR1_CLR36_SHIFT        (4U)
/*! CLR36 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR36(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR36_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR36_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR1 */
#define DMA_COMMON_ENABLECLR1_COUNT              (1U)

/*! @name COMMON_ACTIVE - Channel Active status for all DMA channels */
/*! @{ */
#define DMA_COMMON_ACTIVE_ACTIVE0_MASK           (0x1U)
#define DMA_COMMON_ACTIVE_ACTIVE0_SHIFT          (0U)
/*! ACTIVE0 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE0(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE0_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE0_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE1_MASK           (0x2U)
#define DMA_COMMON_ACTIVE_ACTIVE1_SHIFT          (1U)
/*! ACTIVE1 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE1(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE1_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE1_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE2_MASK           (0x4U)
#define DMA_COMMON_ACTIVE_ACTIVE2_SHIFT          (2U)
/*! ACTIVE2 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE2(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE2_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE2_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE3_MASK           (0x8U)
#define DMA_COMMON_ACTIVE_ACTIVE3_SHIFT          (3U)
/*! ACTIVE3 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE3(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE3_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE3_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE4_MASK           (0x10U)
#define DMA_COMMON_ACTIVE_ACTIVE4_SHIFT          (4U)
/*! ACTIVE4 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE4(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE4_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE4_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE5_MASK           (0x20U)
#define DMA_COMMON_ACTIVE_ACTIVE5_SHIFT          (5U)
/*! ACTIVE5 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE5(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE5_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE5_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE6_MASK           (0x40U)
#define DMA_COMMON_ACTIVE_ACTIVE6_SHIFT          (6U)
/*! ACTIVE6 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE6(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE6_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE6_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE7_MASK           (0x80U)
#define DMA_COMMON_ACTIVE_ACTIVE7_SHIFT          (7U)
/*! ACTIVE7 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE7(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE7_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE7_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE8_MASK           (0x100U)
#define DMA_COMMON_ACTIVE_ACTIVE8_SHIFT          (8U)
/*! ACTIVE8 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE8(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE8_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE8_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE9_MASK           (0x200U)
#define DMA_COMMON_ACTIVE_ACTIVE9_SHIFT          (9U)
/*! ACTIVE9 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE9(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE9_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE9_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE10_MASK          (0x400U)
#define DMA_COMMON_ACTIVE_ACTIVE10_SHIFT         (10U)
/*! ACTIVE10 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE10(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE10_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE10_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE11_MASK          (0x800U)
#define DMA_COMMON_ACTIVE_ACTIVE11_SHIFT         (11U)
/*! ACTIVE11 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE11(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE11_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE11_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE12_MASK          (0x1000U)
#define DMA_COMMON_ACTIVE_ACTIVE12_SHIFT         (12U)
/*! ACTIVE12 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE12(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE12_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE12_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE13_MASK          (0x2000U)
#define DMA_COMMON_ACTIVE_ACTIVE13_SHIFT         (13U)
/*! ACTIVE13 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE13(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE13_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE13_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE14_MASK          (0x4000U)
#define DMA_COMMON_ACTIVE_ACTIVE14_SHIFT         (14U)
/*! ACTIVE14 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE14(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE14_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE14_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE15_MASK          (0x8000U)
#define DMA_COMMON_ACTIVE_ACTIVE15_SHIFT         (15U)
/*! ACTIVE15 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE15(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE15_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE15_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE16_MASK          (0x10000U)
#define DMA_COMMON_ACTIVE_ACTIVE16_SHIFT         (16U)
/*! ACTIVE16 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE16(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE16_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE16_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE17_MASK          (0x20000U)
#define DMA_COMMON_ACTIVE_ACTIVE17_SHIFT         (17U)
/*! ACTIVE17 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE17(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE17_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE17_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE18_MASK          (0x40000U)
#define DMA_COMMON_ACTIVE_ACTIVE18_SHIFT         (18U)
/*! ACTIVE18 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE18(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE18_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE18_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE19_MASK          (0x80000U)
#define DMA_COMMON_ACTIVE_ACTIVE19_SHIFT         (19U)
/*! ACTIVE19 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE19(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE19_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE19_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE20_MASK          (0x100000U)
#define DMA_COMMON_ACTIVE_ACTIVE20_SHIFT         (20U)
/*! ACTIVE20 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE20(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE20_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE20_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE21_MASK          (0x200000U)
#define DMA_COMMON_ACTIVE_ACTIVE21_SHIFT         (21U)
/*! ACTIVE21 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE21(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE21_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE21_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE22_MASK          (0x400000U)
#define DMA_COMMON_ACTIVE_ACTIVE22_SHIFT         (22U)
/*! ACTIVE22 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE22(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE22_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE22_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE23_MASK          (0x800000U)
#define DMA_COMMON_ACTIVE_ACTIVE23_SHIFT         (23U)
/*! ACTIVE23 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE23(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE23_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE23_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE24_MASK          (0x1000000U)
#define DMA_COMMON_ACTIVE_ACTIVE24_SHIFT         (24U)
/*! ACTIVE24 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE24(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE24_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE24_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE25_MASK          (0x2000000U)
#define DMA_COMMON_ACTIVE_ACTIVE25_SHIFT         (25U)
/*! ACTIVE25 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE25(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE25_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE25_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE26_MASK          (0x4000000U)
#define DMA_COMMON_ACTIVE_ACTIVE26_SHIFT         (26U)
/*! ACTIVE26 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE26(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE26_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE26_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE27_MASK          (0x8000000U)
#define DMA_COMMON_ACTIVE_ACTIVE27_SHIFT         (27U)
/*! ACTIVE27 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE27(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE27_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE27_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE28_MASK          (0x10000000U)
#define DMA_COMMON_ACTIVE_ACTIVE28_SHIFT         (28U)
/*! ACTIVE28 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE28(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE28_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE28_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE29_MASK          (0x20000000U)
#define DMA_COMMON_ACTIVE_ACTIVE29_SHIFT         (29U)
/*! ACTIVE29 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE29(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE29_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE29_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE30_MASK          (0x40000000U)
#define DMA_COMMON_ACTIVE_ACTIVE30_SHIFT         (30U)
/*! ACTIVE30 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE30(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE30_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE30_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE31_MASK          (0x80000000U)
#define DMA_COMMON_ACTIVE_ACTIVE31_SHIFT         (31U)
/*! ACTIVE31 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE31(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE31_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE31_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE */
#define DMA_COMMON_ACTIVE_COUNT                  (1U)

/*! @name COMMON_ACTIVE1 - Channel Active status for all DMA channels */
/*! @{ */
#define DMA_COMMON_ACTIVE1_ACTIVE32_MASK         (0x1U)
#define DMA_COMMON_ACTIVE1_ACTIVE32_SHIFT        (0U)
/*! ACTIVE32 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE32(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE32_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE32_MASK)
#define DMA_COMMON_ACTIVE1_ACTIVE33_MASK         (0x2U)
#define DMA_COMMON_ACTIVE1_ACTIVE33_SHIFT        (1U)
/*! ACTIVE33 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE33(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE33_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE33_MASK)
#define DMA_COMMON_ACTIVE1_ACTIVE34_MASK         (0x4U)
#define DMA_COMMON_ACTIVE1_ACTIVE34_SHIFT        (2U)
/*! ACTIVE34 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE34(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE34_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE34_MASK)
#define DMA_COMMON_ACTIVE1_ACTIVE35_MASK         (0x8U)
#define DMA_COMMON_ACTIVE1_ACTIVE35_SHIFT        (3U)
/*! ACTIVE35 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE35(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE35_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE35_MASK)
#define DMA_COMMON_ACTIVE1_ACTIVE36_MASK         (0x10U)
#define DMA_COMMON_ACTIVE1_ACTIVE36_SHIFT        (4U)
/*! ACTIVE36 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE36(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE36_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE36_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE1 */
#define DMA_COMMON_ACTIVE1_COUNT                 (1U)

/*! @name COMMON_BUSY - Channel Busy status for all DMA channels */
/*! @{ */
#define DMA_COMMON_BUSY_BUSY0_MASK               (0x1U)
#define DMA_COMMON_BUSY_BUSY0_SHIFT              (0U)
/*! BUSY0 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY0_SHIFT)) & DMA_COMMON_BUSY_BUSY0_MASK)
#define DMA_COMMON_BUSY_BUSY1_MASK               (0x2U)
#define DMA_COMMON_BUSY_BUSY1_SHIFT              (1U)
/*! BUSY1 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY1_SHIFT)) & DMA_COMMON_BUSY_BUSY1_MASK)
#define DMA_COMMON_BUSY_BUSY2_MASK               (0x4U)
#define DMA_COMMON_BUSY_BUSY2_SHIFT              (2U)
/*! BUSY2 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY2_SHIFT)) & DMA_COMMON_BUSY_BUSY2_MASK)
#define DMA_COMMON_BUSY_BUSY3_MASK               (0x8U)
#define DMA_COMMON_BUSY_BUSY3_SHIFT              (3U)
/*! BUSY3 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY3_SHIFT)) & DMA_COMMON_BUSY_BUSY3_MASK)
#define DMA_COMMON_BUSY_BUSY4_MASK               (0x10U)
#define DMA_COMMON_BUSY_BUSY4_SHIFT              (4U)
/*! BUSY4 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY4_SHIFT)) & DMA_COMMON_BUSY_BUSY4_MASK)
#define DMA_COMMON_BUSY_BUSY5_MASK               (0x20U)
#define DMA_COMMON_BUSY_BUSY5_SHIFT              (5U)
/*! BUSY5 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY5_SHIFT)) & DMA_COMMON_BUSY_BUSY5_MASK)
#define DMA_COMMON_BUSY_BUSY6_MASK               (0x40U)
#define DMA_COMMON_BUSY_BUSY6_SHIFT              (6U)
/*! BUSY6 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY6_SHIFT)) & DMA_COMMON_BUSY_BUSY6_MASK)
#define DMA_COMMON_BUSY_BUSY7_MASK               (0x80U)
#define DMA_COMMON_BUSY_BUSY7_SHIFT              (7U)
/*! BUSY7 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY7_SHIFT)) & DMA_COMMON_BUSY_BUSY7_MASK)
#define DMA_COMMON_BUSY_BUSY8_MASK               (0x100U)
#define DMA_COMMON_BUSY_BUSY8_SHIFT              (8U)
/*! BUSY8 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY8_SHIFT)) & DMA_COMMON_BUSY_BUSY8_MASK)
#define DMA_COMMON_BUSY_BUSY9_MASK               (0x200U)
#define DMA_COMMON_BUSY_BUSY9_SHIFT              (9U)
/*! BUSY9 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY9_SHIFT)) & DMA_COMMON_BUSY_BUSY9_MASK)
#define DMA_COMMON_BUSY_BUSY10_MASK              (0x400U)
#define DMA_COMMON_BUSY_BUSY10_SHIFT             (10U)
/*! BUSY10 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY10_SHIFT)) & DMA_COMMON_BUSY_BUSY10_MASK)
#define DMA_COMMON_BUSY_BUSY11_MASK              (0x800U)
#define DMA_COMMON_BUSY_BUSY11_SHIFT             (11U)
/*! BUSY11 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY11_SHIFT)) & DMA_COMMON_BUSY_BUSY11_MASK)
#define DMA_COMMON_BUSY_BUSY12_MASK              (0x1000U)
#define DMA_COMMON_BUSY_BUSY12_SHIFT             (12U)
/*! BUSY12 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY12_SHIFT)) & DMA_COMMON_BUSY_BUSY12_MASK)
#define DMA_COMMON_BUSY_BUSY13_MASK              (0x2000U)
#define DMA_COMMON_BUSY_BUSY13_SHIFT             (13U)
/*! BUSY13 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY13_SHIFT)) & DMA_COMMON_BUSY_BUSY13_MASK)
#define DMA_COMMON_BUSY_BUSY14_MASK              (0x4000U)
#define DMA_COMMON_BUSY_BUSY14_SHIFT             (14U)
/*! BUSY14 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY14_SHIFT)) & DMA_COMMON_BUSY_BUSY14_MASK)
#define DMA_COMMON_BUSY_BUSY15_MASK              (0x8000U)
#define DMA_COMMON_BUSY_BUSY15_SHIFT             (15U)
/*! BUSY15 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY15_SHIFT)) & DMA_COMMON_BUSY_BUSY15_MASK)
#define DMA_COMMON_BUSY_BUSY16_MASK              (0x10000U)
#define DMA_COMMON_BUSY_BUSY16_SHIFT             (16U)
/*! BUSY16 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY16_SHIFT)) & DMA_COMMON_BUSY_BUSY16_MASK)
#define DMA_COMMON_BUSY_BUSY17_MASK              (0x20000U)
#define DMA_COMMON_BUSY_BUSY17_SHIFT             (17U)
/*! BUSY17 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY17_SHIFT)) & DMA_COMMON_BUSY_BUSY17_MASK)
#define DMA_COMMON_BUSY_BUSY18_MASK              (0x40000U)
#define DMA_COMMON_BUSY_BUSY18_SHIFT             (18U)
/*! BUSY18 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY18_SHIFT)) & DMA_COMMON_BUSY_BUSY18_MASK)
#define DMA_COMMON_BUSY_BUSY19_MASK              (0x80000U)
#define DMA_COMMON_BUSY_BUSY19_SHIFT             (19U)
/*! BUSY19 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY19_SHIFT)) & DMA_COMMON_BUSY_BUSY19_MASK)
#define DMA_COMMON_BUSY_BUSY20_MASK              (0x100000U)
#define DMA_COMMON_BUSY_BUSY20_SHIFT             (20U)
/*! BUSY20 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY20_SHIFT)) & DMA_COMMON_BUSY_BUSY20_MASK)
#define DMA_COMMON_BUSY_BUSY21_MASK              (0x200000U)
#define DMA_COMMON_BUSY_BUSY21_SHIFT             (21U)
/*! BUSY21 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY21_SHIFT)) & DMA_COMMON_BUSY_BUSY21_MASK)
#define DMA_COMMON_BUSY_BUSY22_MASK              (0x400000U)
#define DMA_COMMON_BUSY_BUSY22_SHIFT             (22U)
/*! BUSY22 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY22_SHIFT)) & DMA_COMMON_BUSY_BUSY22_MASK)
#define DMA_COMMON_BUSY_BUSY23_MASK              (0x800000U)
#define DMA_COMMON_BUSY_BUSY23_SHIFT             (23U)
/*! BUSY23 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY23_SHIFT)) & DMA_COMMON_BUSY_BUSY23_MASK)
#define DMA_COMMON_BUSY_BUSY24_MASK              (0x1000000U)
#define DMA_COMMON_BUSY_BUSY24_SHIFT             (24U)
/*! BUSY24 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY24_SHIFT)) & DMA_COMMON_BUSY_BUSY24_MASK)
#define DMA_COMMON_BUSY_BUSY25_MASK              (0x2000000U)
#define DMA_COMMON_BUSY_BUSY25_SHIFT             (25U)
/*! BUSY25 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY25_SHIFT)) & DMA_COMMON_BUSY_BUSY25_MASK)
#define DMA_COMMON_BUSY_BUSY26_MASK              (0x4000000U)
#define DMA_COMMON_BUSY_BUSY26_SHIFT             (26U)
/*! BUSY26 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY26_SHIFT)) & DMA_COMMON_BUSY_BUSY26_MASK)
#define DMA_COMMON_BUSY_BUSY27_MASK              (0x8000000U)
#define DMA_COMMON_BUSY_BUSY27_SHIFT             (27U)
/*! BUSY27 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY27_SHIFT)) & DMA_COMMON_BUSY_BUSY27_MASK)
#define DMA_COMMON_BUSY_BUSY28_MASK              (0x10000000U)
#define DMA_COMMON_BUSY_BUSY28_SHIFT             (28U)
/*! BUSY28 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY28_SHIFT)) & DMA_COMMON_BUSY_BUSY28_MASK)
#define DMA_COMMON_BUSY_BUSY29_MASK              (0x20000000U)
#define DMA_COMMON_BUSY_BUSY29_SHIFT             (29U)
/*! BUSY29 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY29_SHIFT)) & DMA_COMMON_BUSY_BUSY29_MASK)
#define DMA_COMMON_BUSY_BUSY30_MASK              (0x40000000U)
#define DMA_COMMON_BUSY_BUSY30_SHIFT             (30U)
/*! BUSY30 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY30_SHIFT)) & DMA_COMMON_BUSY_BUSY30_MASK)
#define DMA_COMMON_BUSY_BUSY31_MASK              (0x80000000U)
#define DMA_COMMON_BUSY_BUSY31_SHIFT             (31U)
/*! BUSY31 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY31_SHIFT)) & DMA_COMMON_BUSY_BUSY31_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY */
#define DMA_COMMON_BUSY_COUNT                    (1U)

/*! @name COMMON_BUSY1 - Channel Busy status for all DMA channels */
/*! @{ */
#define DMA_COMMON_BUSY1_BUSY32_MASK             (0x1U)
#define DMA_COMMON_BUSY1_BUSY32_SHIFT            (0U)
/*! BUSY32 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY32_SHIFT)) & DMA_COMMON_BUSY1_BUSY32_MASK)
#define DMA_COMMON_BUSY1_BUSY33_MASK             (0x2U)
#define DMA_COMMON_BUSY1_BUSY33_SHIFT            (1U)
/*! BUSY33 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY33(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY33_SHIFT)) & DMA_COMMON_BUSY1_BUSY33_MASK)
#define DMA_COMMON_BUSY1_BUSY34_MASK             (0x4U)
#define DMA_COMMON_BUSY1_BUSY34_SHIFT            (2U)
/*! BUSY34 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY34(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY34_SHIFT)) & DMA_COMMON_BUSY1_BUSY34_MASK)
#define DMA_COMMON_BUSY1_BUSY35_MASK             (0x8U)
#define DMA_COMMON_BUSY1_BUSY35_SHIFT            (3U)
/*! BUSY35 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY35(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY35_SHIFT)) & DMA_COMMON_BUSY1_BUSY35_MASK)
#define DMA_COMMON_BUSY1_BUSY36_MASK             (0x10U)
#define DMA_COMMON_BUSY1_BUSY36_SHIFT            (4U)
/*! BUSY36 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY36(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY36_SHIFT)) & DMA_COMMON_BUSY1_BUSY36_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY1 */
#define DMA_COMMON_BUSY1_COUNT                   (1U)

/*! @name COMMON_ERRINT - Error Interrupt status for all DMA channels */
/*! @{ */
#define DMA_COMMON_ERRINT_ERR0_MASK              (0x1U)
#define DMA_COMMON_ERRINT_ERR0_SHIFT             (0U)
/*! ERR0 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR0(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR0_SHIFT)) & DMA_COMMON_ERRINT_ERR0_MASK)
#define DMA_COMMON_ERRINT_ERR1_MASK              (0x2U)
#define DMA_COMMON_ERRINT_ERR1_SHIFT             (1U)
/*! ERR1 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR1(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR1_SHIFT)) & DMA_COMMON_ERRINT_ERR1_MASK)
#define DMA_COMMON_ERRINT_ERR2_MASK              (0x4U)
#define DMA_COMMON_ERRINT_ERR2_SHIFT             (2U)
/*! ERR2 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR2(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR2_SHIFT)) & DMA_COMMON_ERRINT_ERR2_MASK)
#define DMA_COMMON_ERRINT_ERR3_MASK              (0x8U)
#define DMA_COMMON_ERRINT_ERR3_SHIFT             (3U)
/*! ERR3 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR3(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR3_SHIFT)) & DMA_COMMON_ERRINT_ERR3_MASK)
#define DMA_COMMON_ERRINT_ERR4_MASK              (0x10U)
#define DMA_COMMON_ERRINT_ERR4_SHIFT             (4U)
/*! ERR4 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR4(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR4_SHIFT)) & DMA_COMMON_ERRINT_ERR4_MASK)
#define DMA_COMMON_ERRINT_ERR5_MASK              (0x20U)
#define DMA_COMMON_ERRINT_ERR5_SHIFT             (5U)
/*! ERR5 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR5(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR5_SHIFT)) & DMA_COMMON_ERRINT_ERR5_MASK)
#define DMA_COMMON_ERRINT_ERR6_MASK              (0x40U)
#define DMA_COMMON_ERRINT_ERR6_SHIFT             (6U)
/*! ERR6 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR6(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR6_SHIFT)) & DMA_COMMON_ERRINT_ERR6_MASK)
#define DMA_COMMON_ERRINT_ERR7_MASK              (0x80U)
#define DMA_COMMON_ERRINT_ERR7_SHIFT             (7U)
/*! ERR7 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR7(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR7_SHIFT)) & DMA_COMMON_ERRINT_ERR7_MASK)
#define DMA_COMMON_ERRINT_ERR8_MASK              (0x100U)
#define DMA_COMMON_ERRINT_ERR8_SHIFT             (8U)
/*! ERR8 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR8(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR8_SHIFT)) & DMA_COMMON_ERRINT_ERR8_MASK)
#define DMA_COMMON_ERRINT_ERR9_MASK              (0x200U)
#define DMA_COMMON_ERRINT_ERR9_SHIFT             (9U)
/*! ERR9 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR9(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR9_SHIFT)) & DMA_COMMON_ERRINT_ERR9_MASK)
#define DMA_COMMON_ERRINT_ERR10_MASK             (0x400U)
#define DMA_COMMON_ERRINT_ERR10_SHIFT            (10U)
/*! ERR10 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR10(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR10_SHIFT)) & DMA_COMMON_ERRINT_ERR10_MASK)
#define DMA_COMMON_ERRINT_ERR11_MASK             (0x800U)
#define DMA_COMMON_ERRINT_ERR11_SHIFT            (11U)
/*! ERR11 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR11(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR11_SHIFT)) & DMA_COMMON_ERRINT_ERR11_MASK)
#define DMA_COMMON_ERRINT_ERR12_MASK             (0x1000U)
#define DMA_COMMON_ERRINT_ERR12_SHIFT            (12U)
/*! ERR12 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR12(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR12_SHIFT)) & DMA_COMMON_ERRINT_ERR12_MASK)
#define DMA_COMMON_ERRINT_ERR13_MASK             (0x2000U)
#define DMA_COMMON_ERRINT_ERR13_SHIFT            (13U)
/*! ERR13 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR13(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR13_SHIFT)) & DMA_COMMON_ERRINT_ERR13_MASK)
#define DMA_COMMON_ERRINT_ERR14_MASK             (0x4000U)
#define DMA_COMMON_ERRINT_ERR14_SHIFT            (14U)
/*! ERR14 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR14(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR14_SHIFT)) & DMA_COMMON_ERRINT_ERR14_MASK)
#define DMA_COMMON_ERRINT_ERR15_MASK             (0x8000U)
#define DMA_COMMON_ERRINT_ERR15_SHIFT            (15U)
/*! ERR15 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR15(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR15_SHIFT)) & DMA_COMMON_ERRINT_ERR15_MASK)
#define DMA_COMMON_ERRINT_ERR16_MASK             (0x10000U)
#define DMA_COMMON_ERRINT_ERR16_SHIFT            (16U)
/*! ERR16 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR16(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR16_SHIFT)) & DMA_COMMON_ERRINT_ERR16_MASK)
#define DMA_COMMON_ERRINT_ERR17_MASK             (0x20000U)
#define DMA_COMMON_ERRINT_ERR17_SHIFT            (17U)
/*! ERR17 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR17(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR17_SHIFT)) & DMA_COMMON_ERRINT_ERR17_MASK)
#define DMA_COMMON_ERRINT_ERR18_MASK             (0x40000U)
#define DMA_COMMON_ERRINT_ERR18_SHIFT            (18U)
/*! ERR18 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR18(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR18_SHIFT)) & DMA_COMMON_ERRINT_ERR18_MASK)
#define DMA_COMMON_ERRINT_ERR19_MASK             (0x80000U)
#define DMA_COMMON_ERRINT_ERR19_SHIFT            (19U)
/*! ERR19 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR19(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR19_SHIFT)) & DMA_COMMON_ERRINT_ERR19_MASK)
#define DMA_COMMON_ERRINT_ERR20_MASK             (0x100000U)
#define DMA_COMMON_ERRINT_ERR20_SHIFT            (20U)
/*! ERR20 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR20(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR20_SHIFT)) & DMA_COMMON_ERRINT_ERR20_MASK)
#define DMA_COMMON_ERRINT_ERR21_MASK             (0x200000U)
#define DMA_COMMON_ERRINT_ERR21_SHIFT            (21U)
/*! ERR21 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR21(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR21_SHIFT)) & DMA_COMMON_ERRINT_ERR21_MASK)
#define DMA_COMMON_ERRINT_ERR22_MASK             (0x400000U)
#define DMA_COMMON_ERRINT_ERR22_SHIFT            (22U)
/*! ERR22 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR22(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR22_SHIFT)) & DMA_COMMON_ERRINT_ERR22_MASK)
#define DMA_COMMON_ERRINT_ERR23_MASK             (0x800000U)
#define DMA_COMMON_ERRINT_ERR23_SHIFT            (23U)
/*! ERR23 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR23(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR23_SHIFT)) & DMA_COMMON_ERRINT_ERR23_MASK)
#define DMA_COMMON_ERRINT_ERR24_MASK             (0x1000000U)
#define DMA_COMMON_ERRINT_ERR24_SHIFT            (24U)
/*! ERR24 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR24(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR24_SHIFT)) & DMA_COMMON_ERRINT_ERR24_MASK)
#define DMA_COMMON_ERRINT_ERR25_MASK             (0x2000000U)
#define DMA_COMMON_ERRINT_ERR25_SHIFT            (25U)
/*! ERR25 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR25(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR25_SHIFT)) & DMA_COMMON_ERRINT_ERR25_MASK)
#define DMA_COMMON_ERRINT_ERR26_MASK             (0x4000000U)
#define DMA_COMMON_ERRINT_ERR26_SHIFT            (26U)
/*! ERR26 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR26(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR26_SHIFT)) & DMA_COMMON_ERRINT_ERR26_MASK)
#define DMA_COMMON_ERRINT_ERR27_MASK             (0x8000000U)
#define DMA_COMMON_ERRINT_ERR27_SHIFT            (27U)
/*! ERR27 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR27(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR27_SHIFT)) & DMA_COMMON_ERRINT_ERR27_MASK)
#define DMA_COMMON_ERRINT_ERR28_MASK             (0x10000000U)
#define DMA_COMMON_ERRINT_ERR28_SHIFT            (28U)
/*! ERR28 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR28(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR28_SHIFT)) & DMA_COMMON_ERRINT_ERR28_MASK)
#define DMA_COMMON_ERRINT_ERR29_MASK             (0x20000000U)
#define DMA_COMMON_ERRINT_ERR29_SHIFT            (29U)
/*! ERR29 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR29(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR29_SHIFT)) & DMA_COMMON_ERRINT_ERR29_MASK)
#define DMA_COMMON_ERRINT_ERR30_MASK             (0x40000000U)
#define DMA_COMMON_ERRINT_ERR30_SHIFT            (30U)
/*! ERR30 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR30(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR30_SHIFT)) & DMA_COMMON_ERRINT_ERR30_MASK)
#define DMA_COMMON_ERRINT_ERR31_MASK             (0x80000000U)
#define DMA_COMMON_ERRINT_ERR31_SHIFT            (31U)
/*! ERR31 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR31(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR31_SHIFT)) & DMA_COMMON_ERRINT_ERR31_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT */
#define DMA_COMMON_ERRINT_COUNT                  (1U)

/*! @name COMMON_ERRINT1 - Error Interrupt status for all DMA channels */
/*! @{ */
#define DMA_COMMON_ERRINT1_ERR32_MASK            (0x1U)
#define DMA_COMMON_ERRINT1_ERR32_SHIFT           (0U)
/*! ERR32 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR32(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR32_SHIFT)) & DMA_COMMON_ERRINT1_ERR32_MASK)
#define DMA_COMMON_ERRINT1_ERR33_MASK            (0x2U)
#define DMA_COMMON_ERRINT1_ERR33_SHIFT           (1U)
/*! ERR33 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR33(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR33_SHIFT)) & DMA_COMMON_ERRINT1_ERR33_MASK)
#define DMA_COMMON_ERRINT1_ERR34_MASK            (0x4U)
#define DMA_COMMON_ERRINT1_ERR34_SHIFT           (2U)
/*! ERR34 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR34(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR34_SHIFT)) & DMA_COMMON_ERRINT1_ERR34_MASK)
#define DMA_COMMON_ERRINT1_ERR35_MASK            (0x8U)
#define DMA_COMMON_ERRINT1_ERR35_SHIFT           (3U)
/*! ERR35 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR35(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR35_SHIFT)) & DMA_COMMON_ERRINT1_ERR35_MASK)
#define DMA_COMMON_ERRINT1_ERR36_MASK            (0x10U)
#define DMA_COMMON_ERRINT1_ERR36_SHIFT           (4U)
/*! ERR36 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR36(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR36_SHIFT)) & DMA_COMMON_ERRINT1_ERR36_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT1 */
#define DMA_COMMON_ERRINT1_COUNT                 (1U)

/*! @name COMMON_INTENSET - Interrupt Enable read and Set for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTENSET_INTEN0_MASK          (0x1U)
#define DMA_COMMON_INTENSET_INTEN0_SHIFT         (0U)
/*! INTEN0 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN0(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN0_SHIFT)) & DMA_COMMON_INTENSET_INTEN0_MASK)
#define DMA_COMMON_INTENSET_INTEN1_MASK          (0x2U)
#define DMA_COMMON_INTENSET_INTEN1_SHIFT         (1U)
/*! INTEN1 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN1(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN1_SHIFT)) & DMA_COMMON_INTENSET_INTEN1_MASK)
#define DMA_COMMON_INTENSET_INTEN2_MASK          (0x4U)
#define DMA_COMMON_INTENSET_INTEN2_SHIFT         (2U)
/*! INTEN2 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN2(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN2_SHIFT)) & DMA_COMMON_INTENSET_INTEN2_MASK)
#define DMA_COMMON_INTENSET_INTEN3_MASK          (0x8U)
#define DMA_COMMON_INTENSET_INTEN3_SHIFT         (3U)
/*! INTEN3 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN3(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN3_SHIFT)) & DMA_COMMON_INTENSET_INTEN3_MASK)
#define DMA_COMMON_INTENSET_INTEN4_MASK          (0x10U)
#define DMA_COMMON_INTENSET_INTEN4_SHIFT         (4U)
/*! INTEN4 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN4(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN4_SHIFT)) & DMA_COMMON_INTENSET_INTEN4_MASK)
#define DMA_COMMON_INTENSET_INTEN5_MASK          (0x20U)
#define DMA_COMMON_INTENSET_INTEN5_SHIFT         (5U)
/*! INTEN5 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN5(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN5_SHIFT)) & DMA_COMMON_INTENSET_INTEN5_MASK)
#define DMA_COMMON_INTENSET_INTEN6_MASK          (0x40U)
#define DMA_COMMON_INTENSET_INTEN6_SHIFT         (6U)
/*! INTEN6 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN6(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN6_SHIFT)) & DMA_COMMON_INTENSET_INTEN6_MASK)
#define DMA_COMMON_INTENSET_INTEN7_MASK          (0x80U)
#define DMA_COMMON_INTENSET_INTEN7_SHIFT         (7U)
/*! INTEN7 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN7(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN7_SHIFT)) & DMA_COMMON_INTENSET_INTEN7_MASK)
#define DMA_COMMON_INTENSET_INTEN8_MASK          (0x100U)
#define DMA_COMMON_INTENSET_INTEN8_SHIFT         (8U)
/*! INTEN8 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN8(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN8_SHIFT)) & DMA_COMMON_INTENSET_INTEN8_MASK)
#define DMA_COMMON_INTENSET_INTEN9_MASK          (0x200U)
#define DMA_COMMON_INTENSET_INTEN9_SHIFT         (9U)
/*! INTEN9 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN9(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN9_SHIFT)) & DMA_COMMON_INTENSET_INTEN9_MASK)
#define DMA_COMMON_INTENSET_INTEN10_MASK         (0x400U)
#define DMA_COMMON_INTENSET_INTEN10_SHIFT        (10U)
/*! INTEN10 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN10(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN10_SHIFT)) & DMA_COMMON_INTENSET_INTEN10_MASK)
#define DMA_COMMON_INTENSET_INTEN11_MASK         (0x800U)
#define DMA_COMMON_INTENSET_INTEN11_SHIFT        (11U)
/*! INTEN11 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN11(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN11_SHIFT)) & DMA_COMMON_INTENSET_INTEN11_MASK)
#define DMA_COMMON_INTENSET_INTEN12_MASK         (0x1000U)
#define DMA_COMMON_INTENSET_INTEN12_SHIFT        (12U)
/*! INTEN12 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN12(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN12_SHIFT)) & DMA_COMMON_INTENSET_INTEN12_MASK)
#define DMA_COMMON_INTENSET_INTEN13_MASK         (0x2000U)
#define DMA_COMMON_INTENSET_INTEN13_SHIFT        (13U)
/*! INTEN13 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN13(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN13_SHIFT)) & DMA_COMMON_INTENSET_INTEN13_MASK)
#define DMA_COMMON_INTENSET_INTEN14_MASK         (0x4000U)
#define DMA_COMMON_INTENSET_INTEN14_SHIFT        (14U)
/*! INTEN14 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN14(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN14_SHIFT)) & DMA_COMMON_INTENSET_INTEN14_MASK)
#define DMA_COMMON_INTENSET_INTEN15_MASK         (0x8000U)
#define DMA_COMMON_INTENSET_INTEN15_SHIFT        (15U)
/*! INTEN15 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN15(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN15_SHIFT)) & DMA_COMMON_INTENSET_INTEN15_MASK)
#define DMA_COMMON_INTENSET_INTEN16_MASK         (0x10000U)
#define DMA_COMMON_INTENSET_INTEN16_SHIFT        (16U)
/*! INTEN16 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN16(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN16_SHIFT)) & DMA_COMMON_INTENSET_INTEN16_MASK)
#define DMA_COMMON_INTENSET_INTEN17_MASK         (0x20000U)
#define DMA_COMMON_INTENSET_INTEN17_SHIFT        (17U)
/*! INTEN17 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN17(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN17_SHIFT)) & DMA_COMMON_INTENSET_INTEN17_MASK)
#define DMA_COMMON_INTENSET_INTEN18_MASK         (0x40000U)
#define DMA_COMMON_INTENSET_INTEN18_SHIFT        (18U)
/*! INTEN18 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN18(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN18_SHIFT)) & DMA_COMMON_INTENSET_INTEN18_MASK)
#define DMA_COMMON_INTENSET_INTEN19_MASK         (0x80000U)
#define DMA_COMMON_INTENSET_INTEN19_SHIFT        (19U)
/*! INTEN19 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN19(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN19_SHIFT)) & DMA_COMMON_INTENSET_INTEN19_MASK)
#define DMA_COMMON_INTENSET_INTEN20_MASK         (0x100000U)
#define DMA_COMMON_INTENSET_INTEN20_SHIFT        (20U)
/*! INTEN20 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN20(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN20_SHIFT)) & DMA_COMMON_INTENSET_INTEN20_MASK)
#define DMA_COMMON_INTENSET_INTEN21_MASK         (0x200000U)
#define DMA_COMMON_INTENSET_INTEN21_SHIFT        (21U)
/*! INTEN21 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN21(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN21_SHIFT)) & DMA_COMMON_INTENSET_INTEN21_MASK)
#define DMA_COMMON_INTENSET_INTEN22_MASK         (0x400000U)
#define DMA_COMMON_INTENSET_INTEN22_SHIFT        (22U)
/*! INTEN22 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN22(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN22_SHIFT)) & DMA_COMMON_INTENSET_INTEN22_MASK)
#define DMA_COMMON_INTENSET_INTEN23_MASK         (0x800000U)
#define DMA_COMMON_INTENSET_INTEN23_SHIFT        (23U)
/*! INTEN23 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN23(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN23_SHIFT)) & DMA_COMMON_INTENSET_INTEN23_MASK)
#define DMA_COMMON_INTENSET_INTEN24_MASK         (0x1000000U)
#define DMA_COMMON_INTENSET_INTEN24_SHIFT        (24U)
/*! INTEN24 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN24(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN24_SHIFT)) & DMA_COMMON_INTENSET_INTEN24_MASK)
#define DMA_COMMON_INTENSET_INTEN25_MASK         (0x2000000U)
#define DMA_COMMON_INTENSET_INTEN25_SHIFT        (25U)
/*! INTEN25 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN25(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN25_SHIFT)) & DMA_COMMON_INTENSET_INTEN25_MASK)
#define DMA_COMMON_INTENSET_INTEN26_MASK         (0x4000000U)
#define DMA_COMMON_INTENSET_INTEN26_SHIFT        (26U)
/*! INTEN26 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN26(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN26_SHIFT)) & DMA_COMMON_INTENSET_INTEN26_MASK)
#define DMA_COMMON_INTENSET_INTEN27_MASK         (0x8000000U)
#define DMA_COMMON_INTENSET_INTEN27_SHIFT        (27U)
/*! INTEN27 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN27(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN27_SHIFT)) & DMA_COMMON_INTENSET_INTEN27_MASK)
#define DMA_COMMON_INTENSET_INTEN28_MASK         (0x10000000U)
#define DMA_COMMON_INTENSET_INTEN28_SHIFT        (28U)
/*! INTEN28 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN28(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN28_SHIFT)) & DMA_COMMON_INTENSET_INTEN28_MASK)
#define DMA_COMMON_INTENSET_INTEN29_MASK         (0x20000000U)
#define DMA_COMMON_INTENSET_INTEN29_SHIFT        (29U)
/*! INTEN29 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN29(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN29_SHIFT)) & DMA_COMMON_INTENSET_INTEN29_MASK)
#define DMA_COMMON_INTENSET_INTEN30_MASK         (0x40000000U)
#define DMA_COMMON_INTENSET_INTEN30_SHIFT        (30U)
/*! INTEN30 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN30(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN30_SHIFT)) & DMA_COMMON_INTENSET_INTEN30_MASK)
#define DMA_COMMON_INTENSET_INTEN31_MASK         (0x80000000U)
#define DMA_COMMON_INTENSET_INTEN31_SHIFT        (31U)
/*! INTEN31 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN31(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN31_SHIFT)) & DMA_COMMON_INTENSET_INTEN31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET */
#define DMA_COMMON_INTENSET_COUNT                (1U)

/*! @name COMMON_INTENSET1 - Interrupt Enable read and Set for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTENSET1_INTEN32_MASK        (0x1U)
#define DMA_COMMON_INTENSET1_INTEN32_SHIFT       (0U)
/*! INTEN32 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN32(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN32_SHIFT)) & DMA_COMMON_INTENSET1_INTEN32_MASK)
#define DMA_COMMON_INTENSET1_INTEN33_MASK        (0x2U)
#define DMA_COMMON_INTENSET1_INTEN33_SHIFT       (1U)
/*! INTEN33 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN33(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN33_SHIFT)) & DMA_COMMON_INTENSET1_INTEN33_MASK)
#define DMA_COMMON_INTENSET1_INTEN34_MASK        (0x4U)
#define DMA_COMMON_INTENSET1_INTEN34_SHIFT       (2U)
/*! INTEN34 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN34(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN34_SHIFT)) & DMA_COMMON_INTENSET1_INTEN34_MASK)
#define DMA_COMMON_INTENSET1_INTEN35_MASK        (0x8U)
#define DMA_COMMON_INTENSET1_INTEN35_SHIFT       (3U)
/*! INTEN35 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN35(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN35_SHIFT)) & DMA_COMMON_INTENSET1_INTEN35_MASK)
#define DMA_COMMON_INTENSET1_INTEN36_MASK        (0x10U)
#define DMA_COMMON_INTENSET1_INTEN36_SHIFT       (4U)
/*! INTEN36 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN36(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN36_SHIFT)) & DMA_COMMON_INTENSET1_INTEN36_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET1 */
#define DMA_COMMON_INTENSET1_COUNT               (1U)

/*! @name COMMON_INTENCLR - Interrupt Enable Clear for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTENCLR_CLR0_MASK            (0x1U)
#define DMA_COMMON_INTENCLR_CLR0_SHIFT           (0U)
/*! CLR0 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR0(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR0_SHIFT)) & DMA_COMMON_INTENCLR_CLR0_MASK)
#define DMA_COMMON_INTENCLR_CLR1_MASK            (0x2U)
#define DMA_COMMON_INTENCLR_CLR1_SHIFT           (1U)
/*! CLR1 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR1(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR1_SHIFT)) & DMA_COMMON_INTENCLR_CLR1_MASK)
#define DMA_COMMON_INTENCLR_CLR2_MASK            (0x4U)
#define DMA_COMMON_INTENCLR_CLR2_SHIFT           (2U)
/*! CLR2 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR2(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR2_SHIFT)) & DMA_COMMON_INTENCLR_CLR2_MASK)
#define DMA_COMMON_INTENCLR_CLR3_MASK            (0x8U)
#define DMA_COMMON_INTENCLR_CLR3_SHIFT           (3U)
/*! CLR3 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR3(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR3_SHIFT)) & DMA_COMMON_INTENCLR_CLR3_MASK)
#define DMA_COMMON_INTENCLR_CLR4_MASK            (0x10U)
#define DMA_COMMON_INTENCLR_CLR4_SHIFT           (4U)
/*! CLR4 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR4(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR4_SHIFT)) & DMA_COMMON_INTENCLR_CLR4_MASK)
#define DMA_COMMON_INTENCLR_CLR5_MASK            (0x20U)
#define DMA_COMMON_INTENCLR_CLR5_SHIFT           (5U)
/*! CLR5 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR5(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR5_SHIFT)) & DMA_COMMON_INTENCLR_CLR5_MASK)
#define DMA_COMMON_INTENCLR_CLR6_MASK            (0x40U)
#define DMA_COMMON_INTENCLR_CLR6_SHIFT           (6U)
/*! CLR6 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR6(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR6_SHIFT)) & DMA_COMMON_INTENCLR_CLR6_MASK)
#define DMA_COMMON_INTENCLR_CLR7_MASK            (0x80U)
#define DMA_COMMON_INTENCLR_CLR7_SHIFT           (7U)
/*! CLR7 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR7(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR7_SHIFT)) & DMA_COMMON_INTENCLR_CLR7_MASK)
#define DMA_COMMON_INTENCLR_CLR8_MASK            (0x100U)
#define DMA_COMMON_INTENCLR_CLR8_SHIFT           (8U)
/*! CLR8 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR8(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR8_SHIFT)) & DMA_COMMON_INTENCLR_CLR8_MASK)
#define DMA_COMMON_INTENCLR_CLR9_MASK            (0x200U)
#define DMA_COMMON_INTENCLR_CLR9_SHIFT           (9U)
/*! CLR9 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR9(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR9_SHIFT)) & DMA_COMMON_INTENCLR_CLR9_MASK)
#define DMA_COMMON_INTENCLR_CLR10_MASK           (0x400U)
#define DMA_COMMON_INTENCLR_CLR10_SHIFT          (10U)
/*! CLR10 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR10(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR10_SHIFT)) & DMA_COMMON_INTENCLR_CLR10_MASK)
#define DMA_COMMON_INTENCLR_CLR11_MASK           (0x800U)
#define DMA_COMMON_INTENCLR_CLR11_SHIFT          (11U)
/*! CLR11 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR11(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR11_SHIFT)) & DMA_COMMON_INTENCLR_CLR11_MASK)
#define DMA_COMMON_INTENCLR_CLR12_MASK           (0x1000U)
#define DMA_COMMON_INTENCLR_CLR12_SHIFT          (12U)
/*! CLR12 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR12(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR12_SHIFT)) & DMA_COMMON_INTENCLR_CLR12_MASK)
#define DMA_COMMON_INTENCLR_CLR13_MASK           (0x2000U)
#define DMA_COMMON_INTENCLR_CLR13_SHIFT          (13U)
/*! CLR13 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR13(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR13_SHIFT)) & DMA_COMMON_INTENCLR_CLR13_MASK)
#define DMA_COMMON_INTENCLR_CLR14_MASK           (0x4000U)
#define DMA_COMMON_INTENCLR_CLR14_SHIFT          (14U)
/*! CLR14 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR14(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR14_SHIFT)) & DMA_COMMON_INTENCLR_CLR14_MASK)
#define DMA_COMMON_INTENCLR_CLR15_MASK           (0x8000U)
#define DMA_COMMON_INTENCLR_CLR15_SHIFT          (15U)
/*! CLR15 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR15(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR15_SHIFT)) & DMA_COMMON_INTENCLR_CLR15_MASK)
#define DMA_COMMON_INTENCLR_CLR16_MASK           (0x10000U)
#define DMA_COMMON_INTENCLR_CLR16_SHIFT          (16U)
/*! CLR16 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR16(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR16_SHIFT)) & DMA_COMMON_INTENCLR_CLR16_MASK)
#define DMA_COMMON_INTENCLR_CLR17_MASK           (0x20000U)
#define DMA_COMMON_INTENCLR_CLR17_SHIFT          (17U)
/*! CLR17 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR17(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR17_SHIFT)) & DMA_COMMON_INTENCLR_CLR17_MASK)
#define DMA_COMMON_INTENCLR_CLR18_MASK           (0x40000U)
#define DMA_COMMON_INTENCLR_CLR18_SHIFT          (18U)
/*! CLR18 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR18(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR18_SHIFT)) & DMA_COMMON_INTENCLR_CLR18_MASK)
#define DMA_COMMON_INTENCLR_CLR19_MASK           (0x80000U)
#define DMA_COMMON_INTENCLR_CLR19_SHIFT          (19U)
/*! CLR19 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR19(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR19_SHIFT)) & DMA_COMMON_INTENCLR_CLR19_MASK)
#define DMA_COMMON_INTENCLR_CLR20_MASK           (0x100000U)
#define DMA_COMMON_INTENCLR_CLR20_SHIFT          (20U)
/*! CLR20 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR20(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR20_SHIFT)) & DMA_COMMON_INTENCLR_CLR20_MASK)
#define DMA_COMMON_INTENCLR_CLR21_MASK           (0x200000U)
#define DMA_COMMON_INTENCLR_CLR21_SHIFT          (21U)
/*! CLR21 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR21(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR21_SHIFT)) & DMA_COMMON_INTENCLR_CLR21_MASK)
#define DMA_COMMON_INTENCLR_CLR22_MASK           (0x400000U)
#define DMA_COMMON_INTENCLR_CLR22_SHIFT          (22U)
/*! CLR22 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR22(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR22_SHIFT)) & DMA_COMMON_INTENCLR_CLR22_MASK)
#define DMA_COMMON_INTENCLR_CLR23_MASK           (0x800000U)
#define DMA_COMMON_INTENCLR_CLR23_SHIFT          (23U)
/*! CLR23 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR23(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR23_SHIFT)) & DMA_COMMON_INTENCLR_CLR23_MASK)
#define DMA_COMMON_INTENCLR_CLR24_MASK           (0x1000000U)
#define DMA_COMMON_INTENCLR_CLR24_SHIFT          (24U)
/*! CLR24 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR24(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR24_SHIFT)) & DMA_COMMON_INTENCLR_CLR24_MASK)
#define DMA_COMMON_INTENCLR_CLR25_MASK           (0x2000000U)
#define DMA_COMMON_INTENCLR_CLR25_SHIFT          (25U)
/*! CLR25 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR25(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR25_SHIFT)) & DMA_COMMON_INTENCLR_CLR25_MASK)
#define DMA_COMMON_INTENCLR_CLR26_MASK           (0x4000000U)
#define DMA_COMMON_INTENCLR_CLR26_SHIFT          (26U)
/*! CLR26 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR26(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR26_SHIFT)) & DMA_COMMON_INTENCLR_CLR26_MASK)
#define DMA_COMMON_INTENCLR_CLR27_MASK           (0x8000000U)
#define DMA_COMMON_INTENCLR_CLR27_SHIFT          (27U)
/*! CLR27 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR27(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR27_SHIFT)) & DMA_COMMON_INTENCLR_CLR27_MASK)
#define DMA_COMMON_INTENCLR_CLR28_MASK           (0x10000000U)
#define DMA_COMMON_INTENCLR_CLR28_SHIFT          (28U)
/*! CLR28 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR28(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR28_SHIFT)) & DMA_COMMON_INTENCLR_CLR28_MASK)
#define DMA_COMMON_INTENCLR_CLR29_MASK           (0x20000000U)
#define DMA_COMMON_INTENCLR_CLR29_SHIFT          (29U)
/*! CLR29 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR29(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR29_SHIFT)) & DMA_COMMON_INTENCLR_CLR29_MASK)
#define DMA_COMMON_INTENCLR_CLR30_MASK           (0x40000000U)
#define DMA_COMMON_INTENCLR_CLR30_SHIFT          (30U)
/*! CLR30 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR30(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR30_SHIFT)) & DMA_COMMON_INTENCLR_CLR30_MASK)
#define DMA_COMMON_INTENCLR_CLR31_MASK           (0x80000000U)
#define DMA_COMMON_INTENCLR_CLR31_SHIFT          (31U)
/*! CLR31 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR31(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR31_SHIFT)) & DMA_COMMON_INTENCLR_CLR31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR */
#define DMA_COMMON_INTENCLR_COUNT                (1U)

/*! @name COMMON_INTENCLR1 - Interrupt Enable Clear for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTENCLR1_CLR32_MASK          (0x1U)
#define DMA_COMMON_INTENCLR1_CLR32_SHIFT         (0U)
/*! CLR32 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR32(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR32_SHIFT)) & DMA_COMMON_INTENCLR1_CLR32_MASK)
#define DMA_COMMON_INTENCLR1_CLR33_MASK          (0x2U)
#define DMA_COMMON_INTENCLR1_CLR33_SHIFT         (1U)
/*! CLR33 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR33(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR33_SHIFT)) & DMA_COMMON_INTENCLR1_CLR33_MASK)
#define DMA_COMMON_INTENCLR1_CLR34_MASK          (0x4U)
#define DMA_COMMON_INTENCLR1_CLR34_SHIFT         (2U)
/*! CLR34 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR34(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR34_SHIFT)) & DMA_COMMON_INTENCLR1_CLR34_MASK)
#define DMA_COMMON_INTENCLR1_CLR35_MASK          (0x8U)
#define DMA_COMMON_INTENCLR1_CLR35_SHIFT         (3U)
/*! CLR35 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR35(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR35_SHIFT)) & DMA_COMMON_INTENCLR1_CLR35_MASK)
#define DMA_COMMON_INTENCLR1_CLR36_MASK          (0x10U)
#define DMA_COMMON_INTENCLR1_CLR36_SHIFT         (4U)
/*! CLR36 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR36(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR36_SHIFT)) & DMA_COMMON_INTENCLR1_CLR36_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR1 */
#define DMA_COMMON_INTENCLR1_COUNT               (1U)

/*! @name COMMON_INTA - Interrupt A status for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTA_INTA0_MASK               (0x1U)
#define DMA_COMMON_INTA_INTA0_SHIFT              (0U)
/*! INTA0 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA0_SHIFT)) & DMA_COMMON_INTA_INTA0_MASK)
#define DMA_COMMON_INTA_INTA1_MASK               (0x2U)
#define DMA_COMMON_INTA_INTA1_SHIFT              (1U)
/*! INTA1 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA1_SHIFT)) & DMA_COMMON_INTA_INTA1_MASK)
#define DMA_COMMON_INTA_INTA2_MASK               (0x4U)
#define DMA_COMMON_INTA_INTA2_SHIFT              (2U)
/*! INTA2 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA2_SHIFT)) & DMA_COMMON_INTA_INTA2_MASK)
#define DMA_COMMON_INTA_INTA3_MASK               (0x8U)
#define DMA_COMMON_INTA_INTA3_SHIFT              (3U)
/*! INTA3 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA3_SHIFT)) & DMA_COMMON_INTA_INTA3_MASK)
#define DMA_COMMON_INTA_INTA4_MASK               (0x10U)
#define DMA_COMMON_INTA_INTA4_SHIFT              (4U)
/*! INTA4 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA4_SHIFT)) & DMA_COMMON_INTA_INTA4_MASK)
#define DMA_COMMON_INTA_INTA5_MASK               (0x20U)
#define DMA_COMMON_INTA_INTA5_SHIFT              (5U)
/*! INTA5 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA5_SHIFT)) & DMA_COMMON_INTA_INTA5_MASK)
#define DMA_COMMON_INTA_INTA6_MASK               (0x40U)
#define DMA_COMMON_INTA_INTA6_SHIFT              (6U)
/*! INTA6 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA6_SHIFT)) & DMA_COMMON_INTA_INTA6_MASK)
#define DMA_COMMON_INTA_INTA7_MASK               (0x80U)
#define DMA_COMMON_INTA_INTA7_SHIFT              (7U)
/*! INTA7 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA7_SHIFT)) & DMA_COMMON_INTA_INTA7_MASK)
#define DMA_COMMON_INTA_INTA8_MASK               (0x100U)
#define DMA_COMMON_INTA_INTA8_SHIFT              (8U)
/*! INTA8 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA8_SHIFT)) & DMA_COMMON_INTA_INTA8_MASK)
#define DMA_COMMON_INTA_INTA9_MASK               (0x200U)
#define DMA_COMMON_INTA_INTA9_SHIFT              (9U)
/*! INTA9 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA9_SHIFT)) & DMA_COMMON_INTA_INTA9_MASK)
#define DMA_COMMON_INTA_INTA10_MASK              (0x400U)
#define DMA_COMMON_INTA_INTA10_SHIFT             (10U)
/*! INTA10 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA10_SHIFT)) & DMA_COMMON_INTA_INTA10_MASK)
#define DMA_COMMON_INTA_INTA11_MASK              (0x800U)
#define DMA_COMMON_INTA_INTA11_SHIFT             (11U)
/*! INTA11 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA11_SHIFT)) & DMA_COMMON_INTA_INTA11_MASK)
#define DMA_COMMON_INTA_INTA12_MASK              (0x1000U)
#define DMA_COMMON_INTA_INTA12_SHIFT             (12U)
/*! INTA12 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA12_SHIFT)) & DMA_COMMON_INTA_INTA12_MASK)
#define DMA_COMMON_INTA_INTA13_MASK              (0x2000U)
#define DMA_COMMON_INTA_INTA13_SHIFT             (13U)
/*! INTA13 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA13_SHIFT)) & DMA_COMMON_INTA_INTA13_MASK)
#define DMA_COMMON_INTA_INTA14_MASK              (0x4000U)
#define DMA_COMMON_INTA_INTA14_SHIFT             (14U)
/*! INTA14 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA14_SHIFT)) & DMA_COMMON_INTA_INTA14_MASK)
#define DMA_COMMON_INTA_INTA15_MASK              (0x8000U)
#define DMA_COMMON_INTA_INTA15_SHIFT             (15U)
/*! INTA15 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA15_SHIFT)) & DMA_COMMON_INTA_INTA15_MASK)
#define DMA_COMMON_INTA_INTA16_MASK              (0x10000U)
#define DMA_COMMON_INTA_INTA16_SHIFT             (16U)
/*! INTA16 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA16_SHIFT)) & DMA_COMMON_INTA_INTA16_MASK)
#define DMA_COMMON_INTA_INTA17_MASK              (0x20000U)
#define DMA_COMMON_INTA_INTA17_SHIFT             (17U)
/*! INTA17 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA17_SHIFT)) & DMA_COMMON_INTA_INTA17_MASK)
#define DMA_COMMON_INTA_INTA18_MASK              (0x40000U)
#define DMA_COMMON_INTA_INTA18_SHIFT             (18U)
/*! INTA18 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA18_SHIFT)) & DMA_COMMON_INTA_INTA18_MASK)
#define DMA_COMMON_INTA_INTA19_MASK              (0x80000U)
#define DMA_COMMON_INTA_INTA19_SHIFT             (19U)
/*! INTA19 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA19_SHIFT)) & DMA_COMMON_INTA_INTA19_MASK)
#define DMA_COMMON_INTA_INTA20_MASK              (0x100000U)
#define DMA_COMMON_INTA_INTA20_SHIFT             (20U)
/*! INTA20 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA20_SHIFT)) & DMA_COMMON_INTA_INTA20_MASK)
#define DMA_COMMON_INTA_INTA21_MASK              (0x200000U)
#define DMA_COMMON_INTA_INTA21_SHIFT             (21U)
/*! INTA21 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA21_SHIFT)) & DMA_COMMON_INTA_INTA21_MASK)
#define DMA_COMMON_INTA_INTA22_MASK              (0x400000U)
#define DMA_COMMON_INTA_INTA22_SHIFT             (22U)
/*! INTA22 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA22_SHIFT)) & DMA_COMMON_INTA_INTA22_MASK)
#define DMA_COMMON_INTA_INTA23_MASK              (0x800000U)
#define DMA_COMMON_INTA_INTA23_SHIFT             (23U)
/*! INTA23 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA23_SHIFT)) & DMA_COMMON_INTA_INTA23_MASK)
#define DMA_COMMON_INTA_INTA24_MASK              (0x1000000U)
#define DMA_COMMON_INTA_INTA24_SHIFT             (24U)
/*! INTA24 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA24_SHIFT)) & DMA_COMMON_INTA_INTA24_MASK)
#define DMA_COMMON_INTA_INTA25_MASK              (0x2000000U)
#define DMA_COMMON_INTA_INTA25_SHIFT             (25U)
/*! INTA25 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA25_SHIFT)) & DMA_COMMON_INTA_INTA25_MASK)
#define DMA_COMMON_INTA_INTA26_MASK              (0x4000000U)
#define DMA_COMMON_INTA_INTA26_SHIFT             (26U)
/*! INTA26 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA26_SHIFT)) & DMA_COMMON_INTA_INTA26_MASK)
#define DMA_COMMON_INTA_INTA27_MASK              (0x8000000U)
#define DMA_COMMON_INTA_INTA27_SHIFT             (27U)
/*! INTA27 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA27_SHIFT)) & DMA_COMMON_INTA_INTA27_MASK)
#define DMA_COMMON_INTA_INTA28_MASK              (0x10000000U)
#define DMA_COMMON_INTA_INTA28_SHIFT             (28U)
/*! INTA28 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA28_SHIFT)) & DMA_COMMON_INTA_INTA28_MASK)
#define DMA_COMMON_INTA_INTA29_MASK              (0x20000000U)
#define DMA_COMMON_INTA_INTA29_SHIFT             (29U)
/*! INTA29 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA29_SHIFT)) & DMA_COMMON_INTA_INTA29_MASK)
#define DMA_COMMON_INTA_INTA30_MASK              (0x40000000U)
#define DMA_COMMON_INTA_INTA30_SHIFT             (30U)
/*! INTA30 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA30_SHIFT)) & DMA_COMMON_INTA_INTA30_MASK)
#define DMA_COMMON_INTA_INTA31_MASK              (0x80000000U)
#define DMA_COMMON_INTA_INTA31_SHIFT             (31U)
/*! INTA31 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA31_SHIFT)) & DMA_COMMON_INTA_INTA31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA */
#define DMA_COMMON_INTA_COUNT                    (1U)

/*! @name COMMON_INTA1 - Interrupt A status for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTA1_INTA32_MASK             (0x1U)
#define DMA_COMMON_INTA1_INTA32_SHIFT            (0U)
/*! INTA32 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA32_SHIFT)) & DMA_COMMON_INTA1_INTA32_MASK)
#define DMA_COMMON_INTA1_INTA33_MASK             (0x2U)
#define DMA_COMMON_INTA1_INTA33_SHIFT            (1U)
/*! INTA33 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA33(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA33_SHIFT)) & DMA_COMMON_INTA1_INTA33_MASK)
#define DMA_COMMON_INTA1_INTA34_MASK             (0x4U)
#define DMA_COMMON_INTA1_INTA34_SHIFT            (2U)
/*! INTA34 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA34(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA34_SHIFT)) & DMA_COMMON_INTA1_INTA34_MASK)
#define DMA_COMMON_INTA1_INTA35_MASK             (0x8U)
#define DMA_COMMON_INTA1_INTA35_SHIFT            (3U)
/*! INTA35 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA35(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA35_SHIFT)) & DMA_COMMON_INTA1_INTA35_MASK)
#define DMA_COMMON_INTA1_INTA36_MASK             (0x10U)
#define DMA_COMMON_INTA1_INTA36_SHIFT            (4U)
/*! INTA36 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA36(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA36_SHIFT)) & DMA_COMMON_INTA1_INTA36_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA1 */
#define DMA_COMMON_INTA1_COUNT                   (1U)

/*! @name COMMON_INTB - Interrupt B status for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTB_INTB0_MASK               (0x1U)
#define DMA_COMMON_INTB_INTB0_SHIFT              (0U)
/*! INTB0 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB0_SHIFT)) & DMA_COMMON_INTB_INTB0_MASK)
#define DMA_COMMON_INTB_INTB1_MASK               (0x2U)
#define DMA_COMMON_INTB_INTB1_SHIFT              (1U)
/*! INTB1 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB1_SHIFT)) & DMA_COMMON_INTB_INTB1_MASK)
#define DMA_COMMON_INTB_INTB2_MASK               (0x4U)
#define DMA_COMMON_INTB_INTB2_SHIFT              (2U)
/*! INTB2 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB2_SHIFT)) & DMA_COMMON_INTB_INTB2_MASK)
#define DMA_COMMON_INTB_INTB3_MASK               (0x8U)
#define DMA_COMMON_INTB_INTB3_SHIFT              (3U)
/*! INTB3 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB3_SHIFT)) & DMA_COMMON_INTB_INTB3_MASK)
#define DMA_COMMON_INTB_INTB4_MASK               (0x10U)
#define DMA_COMMON_INTB_INTB4_SHIFT              (4U)
/*! INTB4 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB4_SHIFT)) & DMA_COMMON_INTB_INTB4_MASK)
#define DMA_COMMON_INTB_INTB5_MASK               (0x20U)
#define DMA_COMMON_INTB_INTB5_SHIFT              (5U)
/*! INTB5 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB5_SHIFT)) & DMA_COMMON_INTB_INTB5_MASK)
#define DMA_COMMON_INTB_INTB6_MASK               (0x40U)
#define DMA_COMMON_INTB_INTB6_SHIFT              (6U)
/*! INTB6 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB6_SHIFT)) & DMA_COMMON_INTB_INTB6_MASK)
#define DMA_COMMON_INTB_INTB7_MASK               (0x80U)
#define DMA_COMMON_INTB_INTB7_SHIFT              (7U)
/*! INTB7 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB7_SHIFT)) & DMA_COMMON_INTB_INTB7_MASK)
#define DMA_COMMON_INTB_INTB8_MASK               (0x100U)
#define DMA_COMMON_INTB_INTB8_SHIFT              (8U)
/*! INTB8 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB8_SHIFT)) & DMA_COMMON_INTB_INTB8_MASK)
#define DMA_COMMON_INTB_INTB9_MASK               (0x200U)
#define DMA_COMMON_INTB_INTB9_SHIFT              (9U)
/*! INTB9 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB9_SHIFT)) & DMA_COMMON_INTB_INTB9_MASK)
#define DMA_COMMON_INTB_INTB10_MASK              (0x400U)
#define DMA_COMMON_INTB_INTB10_SHIFT             (10U)
/*! INTB10 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB10_SHIFT)) & DMA_COMMON_INTB_INTB10_MASK)
#define DMA_COMMON_INTB_INTB11_MASK              (0x800U)
#define DMA_COMMON_INTB_INTB11_SHIFT             (11U)
/*! INTB11 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB11_SHIFT)) & DMA_COMMON_INTB_INTB11_MASK)
#define DMA_COMMON_INTB_INTB12_MASK              (0x1000U)
#define DMA_COMMON_INTB_INTB12_SHIFT             (12U)
/*! INTB12 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB12_SHIFT)) & DMA_COMMON_INTB_INTB12_MASK)
#define DMA_COMMON_INTB_INTB13_MASK              (0x2000U)
#define DMA_COMMON_INTB_INTB13_SHIFT             (13U)
/*! INTB13 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB13_SHIFT)) & DMA_COMMON_INTB_INTB13_MASK)
#define DMA_COMMON_INTB_INTB14_MASK              (0x4000U)
#define DMA_COMMON_INTB_INTB14_SHIFT             (14U)
/*! INTB14 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB14_SHIFT)) & DMA_COMMON_INTB_INTB14_MASK)
#define DMA_COMMON_INTB_INTB15_MASK              (0x8000U)
#define DMA_COMMON_INTB_INTB15_SHIFT             (15U)
/*! INTB15 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB15_SHIFT)) & DMA_COMMON_INTB_INTB15_MASK)
#define DMA_COMMON_INTB_INTB16_MASK              (0x10000U)
#define DMA_COMMON_INTB_INTB16_SHIFT             (16U)
/*! INTB16 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB16_SHIFT)) & DMA_COMMON_INTB_INTB16_MASK)
#define DMA_COMMON_INTB_INTB17_MASK              (0x20000U)
#define DMA_COMMON_INTB_INTB17_SHIFT             (17U)
/*! INTB17 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB17_SHIFT)) & DMA_COMMON_INTB_INTB17_MASK)
#define DMA_COMMON_INTB_INTB18_MASK              (0x40000U)
#define DMA_COMMON_INTB_INTB18_SHIFT             (18U)
/*! INTB18 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB18_SHIFT)) & DMA_COMMON_INTB_INTB18_MASK)
#define DMA_COMMON_INTB_INTB19_MASK              (0x80000U)
#define DMA_COMMON_INTB_INTB19_SHIFT             (19U)
/*! INTB19 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB19_SHIFT)) & DMA_COMMON_INTB_INTB19_MASK)
#define DMA_COMMON_INTB_INTB20_MASK              (0x100000U)
#define DMA_COMMON_INTB_INTB20_SHIFT             (20U)
/*! INTB20 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB20_SHIFT)) & DMA_COMMON_INTB_INTB20_MASK)
#define DMA_COMMON_INTB_INTB21_MASK              (0x200000U)
#define DMA_COMMON_INTB_INTB21_SHIFT             (21U)
/*! INTB21 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB21_SHIFT)) & DMA_COMMON_INTB_INTB21_MASK)
#define DMA_COMMON_INTB_INTB22_MASK              (0x400000U)
#define DMA_COMMON_INTB_INTB22_SHIFT             (22U)
/*! INTB22 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB22_SHIFT)) & DMA_COMMON_INTB_INTB22_MASK)
#define DMA_COMMON_INTB_INTB23_MASK              (0x800000U)
#define DMA_COMMON_INTB_INTB23_SHIFT             (23U)
/*! INTB23 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB23_SHIFT)) & DMA_COMMON_INTB_INTB23_MASK)
#define DMA_COMMON_INTB_INTB24_MASK              (0x1000000U)
#define DMA_COMMON_INTB_INTB24_SHIFT             (24U)
/*! INTB24 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB24_SHIFT)) & DMA_COMMON_INTB_INTB24_MASK)
#define DMA_COMMON_INTB_INTB25_MASK              (0x2000000U)
#define DMA_COMMON_INTB_INTB25_SHIFT             (25U)
/*! INTB25 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB25_SHIFT)) & DMA_COMMON_INTB_INTB25_MASK)
#define DMA_COMMON_INTB_INTB26_MASK              (0x4000000U)
#define DMA_COMMON_INTB_INTB26_SHIFT             (26U)
/*! INTB26 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB26_SHIFT)) & DMA_COMMON_INTB_INTB26_MASK)
#define DMA_COMMON_INTB_INTB27_MASK              (0x8000000U)
#define DMA_COMMON_INTB_INTB27_SHIFT             (27U)
/*! INTB27 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB27_SHIFT)) & DMA_COMMON_INTB_INTB27_MASK)
#define DMA_COMMON_INTB_INTB28_MASK              (0x10000000U)
#define DMA_COMMON_INTB_INTB28_SHIFT             (28U)
/*! INTB28 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB28_SHIFT)) & DMA_COMMON_INTB_INTB28_MASK)
#define DMA_COMMON_INTB_INTB29_MASK              (0x20000000U)
#define DMA_COMMON_INTB_INTB29_SHIFT             (29U)
/*! INTB29 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB29_SHIFT)) & DMA_COMMON_INTB_INTB29_MASK)
#define DMA_COMMON_INTB_INTB30_MASK              (0x40000000U)
#define DMA_COMMON_INTB_INTB30_SHIFT             (30U)
/*! INTB30 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB30_SHIFT)) & DMA_COMMON_INTB_INTB30_MASK)
#define DMA_COMMON_INTB_INTB31_MASK              (0x80000000U)
#define DMA_COMMON_INTB_INTB31_SHIFT             (31U)
/*! INTB31 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB31_SHIFT)) & DMA_COMMON_INTB_INTB31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB */
#define DMA_COMMON_INTB_COUNT                    (1U)

/*! @name COMMON_INTB1 - Interrupt B status for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTB1_INTB0_MASK              (0x1U)
#define DMA_COMMON_INTB1_INTB0_SHIFT             (0U)
/*! INTB0 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB0(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB0_SHIFT)) & DMA_COMMON_INTB1_INTB0_MASK)
#define DMA_COMMON_INTB1_INTB1_MASK              (0x2U)
#define DMA_COMMON_INTB1_INTB1_SHIFT             (1U)
/*! INTB1 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB1(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB1_SHIFT)) & DMA_COMMON_INTB1_INTB1_MASK)
#define DMA_COMMON_INTB1_INTB2_MASK              (0x4U)
#define DMA_COMMON_INTB1_INTB2_SHIFT             (2U)
/*! INTB2 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB2(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB2_SHIFT)) & DMA_COMMON_INTB1_INTB2_MASK)
#define DMA_COMMON_INTB1_INTB3_MASK              (0x8U)
#define DMA_COMMON_INTB1_INTB3_SHIFT             (3U)
/*! INTB3 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB3(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB3_SHIFT)) & DMA_COMMON_INTB1_INTB3_MASK)
#define DMA_COMMON_INTB1_INTB4_MASK              (0x10U)
#define DMA_COMMON_INTB1_INTB4_SHIFT             (4U)
/*! INTB4 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB4(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB4_SHIFT)) & DMA_COMMON_INTB1_INTB4_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB1 */
#define DMA_COMMON_INTB1_COUNT                   (1U)

/*! @name COMMON_SETVALID - Set ValidPending control bits for all DMA channels */
/*! @{ */
#define DMA_COMMON_SETVALID_SETVALID0_MASK       (0x1U)
#define DMA_COMMON_SETVALID_SETVALID0_SHIFT      (0U)
/*! SETVALID0 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID0(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID0_SHIFT)) & DMA_COMMON_SETVALID_SETVALID0_MASK)
#define DMA_COMMON_SETVALID_SETVALID1_MASK       (0x2U)
#define DMA_COMMON_SETVALID_SETVALID1_SHIFT      (1U)
/*! SETVALID1 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID1(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID1_SHIFT)) & DMA_COMMON_SETVALID_SETVALID1_MASK)
#define DMA_COMMON_SETVALID_SETVALID2_MASK       (0x4U)
#define DMA_COMMON_SETVALID_SETVALID2_SHIFT      (2U)
/*! SETVALID2 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID2(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID2_SHIFT)) & DMA_COMMON_SETVALID_SETVALID2_MASK)
#define DMA_COMMON_SETVALID_SETVALID3_MASK       (0x8U)
#define DMA_COMMON_SETVALID_SETVALID3_SHIFT      (3U)
/*! SETVALID3 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID3(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID3_SHIFT)) & DMA_COMMON_SETVALID_SETVALID3_MASK)
#define DMA_COMMON_SETVALID_SETVALID4_MASK       (0x10U)
#define DMA_COMMON_SETVALID_SETVALID4_SHIFT      (4U)
/*! SETVALID4 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID4(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID4_SHIFT)) & DMA_COMMON_SETVALID_SETVALID4_MASK)
#define DMA_COMMON_SETVALID_SETVALID5_MASK       (0x20U)
#define DMA_COMMON_SETVALID_SETVALID5_SHIFT      (5U)
/*! SETVALID5 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID5(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID5_SHIFT)) & DMA_COMMON_SETVALID_SETVALID5_MASK)
#define DMA_COMMON_SETVALID_SETVALID6_MASK       (0x40U)
#define DMA_COMMON_SETVALID_SETVALID6_SHIFT      (6U)
/*! SETVALID6 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID6(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID6_SHIFT)) & DMA_COMMON_SETVALID_SETVALID6_MASK)
#define DMA_COMMON_SETVALID_SETVALID7_MASK       (0x80U)
#define DMA_COMMON_SETVALID_SETVALID7_SHIFT      (7U)
/*! SETVALID7 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID7(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID7_SHIFT)) & DMA_COMMON_SETVALID_SETVALID7_MASK)
#define DMA_COMMON_SETVALID_SETVALID8_MASK       (0x100U)
#define DMA_COMMON_SETVALID_SETVALID8_SHIFT      (8U)
/*! SETVALID8 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID8(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID8_SHIFT)) & DMA_COMMON_SETVALID_SETVALID8_MASK)
#define DMA_COMMON_SETVALID_SETVALID9_MASK       (0x200U)
#define DMA_COMMON_SETVALID_SETVALID9_SHIFT      (9U)
/*! SETVALID9 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID9(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID9_SHIFT)) & DMA_COMMON_SETVALID_SETVALID9_MASK)
#define DMA_COMMON_SETVALID_SETVALID10_MASK      (0x400U)
#define DMA_COMMON_SETVALID_SETVALID10_SHIFT     (10U)
/*! SETVALID10 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID10(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID10_SHIFT)) & DMA_COMMON_SETVALID_SETVALID10_MASK)
#define DMA_COMMON_SETVALID_SETVALID11_MASK      (0x800U)
#define DMA_COMMON_SETVALID_SETVALID11_SHIFT     (11U)
/*! SETVALID11 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID11(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID11_SHIFT)) & DMA_COMMON_SETVALID_SETVALID11_MASK)
#define DMA_COMMON_SETVALID_SETVALID12_MASK      (0x1000U)
#define DMA_COMMON_SETVALID_SETVALID12_SHIFT     (12U)
/*! SETVALID12 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID12(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID12_SHIFT)) & DMA_COMMON_SETVALID_SETVALID12_MASK)
#define DMA_COMMON_SETVALID_SETVALID13_MASK      (0x2000U)
#define DMA_COMMON_SETVALID_SETVALID13_SHIFT     (13U)
/*! SETVALID13 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID13(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID13_SHIFT)) & DMA_COMMON_SETVALID_SETVALID13_MASK)
#define DMA_COMMON_SETVALID_SETVALID14_MASK      (0x4000U)
#define DMA_COMMON_SETVALID_SETVALID14_SHIFT     (14U)
/*! SETVALID14 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID14(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID14_SHIFT)) & DMA_COMMON_SETVALID_SETVALID14_MASK)
#define DMA_COMMON_SETVALID_SETVALID15_MASK      (0x8000U)
#define DMA_COMMON_SETVALID_SETVALID15_SHIFT     (15U)
/*! SETVALID15 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID15(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID15_SHIFT)) & DMA_COMMON_SETVALID_SETVALID15_MASK)
#define DMA_COMMON_SETVALID_SETVALID16_MASK      (0x10000U)
#define DMA_COMMON_SETVALID_SETVALID16_SHIFT     (16U)
/*! SETVALID16 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID16(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID16_SHIFT)) & DMA_COMMON_SETVALID_SETVALID16_MASK)
#define DMA_COMMON_SETVALID_SETVALID17_MASK      (0x20000U)
#define DMA_COMMON_SETVALID_SETVALID17_SHIFT     (17U)
/*! SETVALID17 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID17(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID17_SHIFT)) & DMA_COMMON_SETVALID_SETVALID17_MASK)
#define DMA_COMMON_SETVALID_SETVALID18_MASK      (0x40000U)
#define DMA_COMMON_SETVALID_SETVALID18_SHIFT     (18U)
/*! SETVALID18 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID18(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID18_SHIFT)) & DMA_COMMON_SETVALID_SETVALID18_MASK)
#define DMA_COMMON_SETVALID_SETVALID19_MASK      (0x80000U)
#define DMA_COMMON_SETVALID_SETVALID19_SHIFT     (19U)
/*! SETVALID19 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID19(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID19_SHIFT)) & DMA_COMMON_SETVALID_SETVALID19_MASK)
#define DMA_COMMON_SETVALID_SETVALID20_MASK      (0x100000U)
#define DMA_COMMON_SETVALID_SETVALID20_SHIFT     (20U)
/*! SETVALID20 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID20(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID20_SHIFT)) & DMA_COMMON_SETVALID_SETVALID20_MASK)
#define DMA_COMMON_SETVALID_SETVALID21_MASK      (0x200000U)
#define DMA_COMMON_SETVALID_SETVALID21_SHIFT     (21U)
/*! SETVALID21 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID21(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID21_SHIFT)) & DMA_COMMON_SETVALID_SETVALID21_MASK)
#define DMA_COMMON_SETVALID_SETVALID22_MASK      (0x400000U)
#define DMA_COMMON_SETVALID_SETVALID22_SHIFT     (22U)
/*! SETVALID22 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID22(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID22_SHIFT)) & DMA_COMMON_SETVALID_SETVALID22_MASK)
#define DMA_COMMON_SETVALID_SETVALID23_MASK      (0x800000U)
#define DMA_COMMON_SETVALID_SETVALID23_SHIFT     (23U)
/*! SETVALID23 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID23(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID23_SHIFT)) & DMA_COMMON_SETVALID_SETVALID23_MASK)
#define DMA_COMMON_SETVALID_SETVALID24_MASK      (0x1000000U)
#define DMA_COMMON_SETVALID_SETVALID24_SHIFT     (24U)
/*! SETVALID24 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID24(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID24_SHIFT)) & DMA_COMMON_SETVALID_SETVALID24_MASK)
#define DMA_COMMON_SETVALID_SETVALID25_MASK      (0x2000000U)
#define DMA_COMMON_SETVALID_SETVALID25_SHIFT     (25U)
/*! SETVALID25 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID25(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID25_SHIFT)) & DMA_COMMON_SETVALID_SETVALID25_MASK)
#define DMA_COMMON_SETVALID_SETVALID26_MASK      (0x4000000U)
#define DMA_COMMON_SETVALID_SETVALID26_SHIFT     (26U)
/*! SETVALID26 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID26(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID26_SHIFT)) & DMA_COMMON_SETVALID_SETVALID26_MASK)
#define DMA_COMMON_SETVALID_SETVALID27_MASK      (0x8000000U)
#define DMA_COMMON_SETVALID_SETVALID27_SHIFT     (27U)
/*! SETVALID27 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID27(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID27_SHIFT)) & DMA_COMMON_SETVALID_SETVALID27_MASK)
#define DMA_COMMON_SETVALID_SETVALID28_MASK      (0x10000000U)
#define DMA_COMMON_SETVALID_SETVALID28_SHIFT     (28U)
/*! SETVALID28 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID28(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID28_SHIFT)) & DMA_COMMON_SETVALID_SETVALID28_MASK)
#define DMA_COMMON_SETVALID_SETVALID29_MASK      (0x20000000U)
#define DMA_COMMON_SETVALID_SETVALID29_SHIFT     (29U)
/*! SETVALID29 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID29(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID29_SHIFT)) & DMA_COMMON_SETVALID_SETVALID29_MASK)
#define DMA_COMMON_SETVALID_SETVALID30_MASK      (0x40000000U)
#define DMA_COMMON_SETVALID_SETVALID30_SHIFT     (30U)
/*! SETVALID30 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID30(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID30_SHIFT)) & DMA_COMMON_SETVALID_SETVALID30_MASK)
#define DMA_COMMON_SETVALID_SETVALID31_MASK      (0x80000000U)
#define DMA_COMMON_SETVALID_SETVALID31_SHIFT     (31U)
/*! SETVALID31 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID31(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID31_SHIFT)) & DMA_COMMON_SETVALID_SETVALID31_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID */
#define DMA_COMMON_SETVALID_COUNT                (1U)

/*! @name COMMON_SETVALID1 - Set ValidPending control bits for all DMA channels */
/*! @{ */
#define DMA_COMMON_SETVALID1_SETVALID32_MASK     (0x1U)
#define DMA_COMMON_SETVALID1_SETVALID32_SHIFT    (0U)
/*! SETVALID32 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID32(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID32_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID32_MASK)
#define DMA_COMMON_SETVALID1_SETVALID33_MASK     (0x2U)
#define DMA_COMMON_SETVALID1_SETVALID33_SHIFT    (1U)
/*! SETVALID33 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID33(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID33_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID33_MASK)
#define DMA_COMMON_SETVALID1_SETVALID34_MASK     (0x4U)
#define DMA_COMMON_SETVALID1_SETVALID34_SHIFT    (2U)
/*! SETVALID34 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID34(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID34_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID34_MASK)
#define DMA_COMMON_SETVALID1_SETVALID35_MASK     (0x8U)
#define DMA_COMMON_SETVALID1_SETVALID35_SHIFT    (3U)
/*! SETVALID35 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID35(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID35_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID35_MASK)
#define DMA_COMMON_SETVALID1_SETVALID36_MASK     (0x10U)
#define DMA_COMMON_SETVALID1_SETVALID36_SHIFT    (4U)
/*! SETVALID36 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID36(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID36_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID36_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID1 */
#define DMA_COMMON_SETVALID1_COUNT               (1U)

/*! @name COMMON_SETTRIG - Set Trigger control bits for all DMA channels */
/*! @{ */
#define DMA_COMMON_SETTRIG_SETTRIG0_MASK         (0x1U)
#define DMA_COMMON_SETTRIG_SETTRIG0_SHIFT        (0U)
/*! SETTRIG0 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG0(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG0_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG0_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG1_MASK         (0x2U)
#define DMA_COMMON_SETTRIG_SETTRIG1_SHIFT        (1U)
/*! SETTRIG1 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG1(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG1_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG1_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG2_MASK         (0x4U)
#define DMA_COMMON_SETTRIG_SETTRIG2_SHIFT        (2U)
/*! SETTRIG2 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG2(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG2_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG2_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG3_MASK         (0x8U)
#define DMA_COMMON_SETTRIG_SETTRIG3_SHIFT        (3U)
/*! SETTRIG3 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG3(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG3_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG3_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG4_MASK         (0x10U)
#define DMA_COMMON_SETTRIG_SETTRIG4_SHIFT        (4U)
/*! SETTRIG4 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG4(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG4_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG4_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG5_MASK         (0x20U)
#define DMA_COMMON_SETTRIG_SETTRIG5_SHIFT        (5U)
/*! SETTRIG5 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG5(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG5_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG5_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG6_MASK         (0x40U)
#define DMA_COMMON_SETTRIG_SETTRIG6_SHIFT        (6U)
/*! SETTRIG6 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG6(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG6_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG6_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG7_MASK         (0x80U)
#define DMA_COMMON_SETTRIG_SETTRIG7_SHIFT        (7U)
/*! SETTRIG7 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG7(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG7_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG7_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG8_MASK         (0x100U)
#define DMA_COMMON_SETTRIG_SETTRIG8_SHIFT        (8U)
/*! SETTRIG8 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG8(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG8_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG8_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG9_MASK         (0x200U)
#define DMA_COMMON_SETTRIG_SETTRIG9_SHIFT        (9U)
/*! SETTRIG9 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG9(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG9_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG9_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG10_MASK        (0x400U)
#define DMA_COMMON_SETTRIG_SETTRIG10_SHIFT       (10U)
/*! SETTRIG10 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG10(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG10_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG10_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG11_MASK        (0x800U)
#define DMA_COMMON_SETTRIG_SETTRIG11_SHIFT       (11U)
/*! SETTRIG11 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG11(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG11_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG11_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG12_MASK        (0x1000U)
#define DMA_COMMON_SETTRIG_SETTRIG12_SHIFT       (12U)
/*! SETTRIG12 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG12(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG12_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG12_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG13_MASK        (0x2000U)
#define DMA_COMMON_SETTRIG_SETTRIG13_SHIFT       (13U)
/*! SETTRIG13 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG13(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG13_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG13_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG14_MASK        (0x4000U)
#define DMA_COMMON_SETTRIG_SETTRIG14_SHIFT       (14U)
/*! SETTRIG14 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG14(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG14_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG14_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG15_MASK        (0x8000U)
#define DMA_COMMON_SETTRIG_SETTRIG15_SHIFT       (15U)
/*! SETTRIG15 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG15(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG15_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG15_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG16_MASK        (0x10000U)
#define DMA_COMMON_SETTRIG_SETTRIG16_SHIFT       (16U)
/*! SETTRIG16 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG16(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG16_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG16_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG17_MASK        (0x20000U)
#define DMA_COMMON_SETTRIG_SETTRIG17_SHIFT       (17U)
/*! SETTRIG17 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG17(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG17_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG17_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG18_MASK        (0x40000U)
#define DMA_COMMON_SETTRIG_SETTRIG18_SHIFT       (18U)
/*! SETTRIG18 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG18(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG18_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG18_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG19_MASK        (0x80000U)
#define DMA_COMMON_SETTRIG_SETTRIG19_SHIFT       (19U)
/*! SETTRIG19 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG19(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG19_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG19_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG20_MASK        (0x100000U)
#define DMA_COMMON_SETTRIG_SETTRIG20_SHIFT       (20U)
/*! SETTRIG20 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG20(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG20_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG20_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG21_MASK        (0x200000U)
#define DMA_COMMON_SETTRIG_SETTRIG21_SHIFT       (21U)
/*! SETTRIG21 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG21(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG21_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG21_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG22_MASK        (0x400000U)
#define DMA_COMMON_SETTRIG_SETTRIG22_SHIFT       (22U)
/*! SETTRIG22 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG22(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG22_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG22_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG23_MASK        (0x800000U)
#define DMA_COMMON_SETTRIG_SETTRIG23_SHIFT       (23U)
/*! SETTRIG23 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG23(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG23_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG23_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG24_MASK        (0x1000000U)
#define DMA_COMMON_SETTRIG_SETTRIG24_SHIFT       (24U)
/*! SETTRIG24 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG24(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG24_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG24_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG25_MASK        (0x2000000U)
#define DMA_COMMON_SETTRIG_SETTRIG25_SHIFT       (25U)
/*! SETTRIG25 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG25(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG25_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG25_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG26_MASK        (0x4000000U)
#define DMA_COMMON_SETTRIG_SETTRIG26_SHIFT       (26U)
/*! SETTRIG26 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG26(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG26_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG26_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG27_MASK        (0x8000000U)
#define DMA_COMMON_SETTRIG_SETTRIG27_SHIFT       (27U)
/*! SETTRIG27 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG27(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG27_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG27_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG28_MASK        (0x10000000U)
#define DMA_COMMON_SETTRIG_SETTRIG28_SHIFT       (28U)
/*! SETTRIG28 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG28(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG28_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG28_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG29_MASK        (0x20000000U)
#define DMA_COMMON_SETTRIG_SETTRIG29_SHIFT       (29U)
/*! SETTRIG29 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG29(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG29_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG29_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG30_MASK        (0x40000000U)
#define DMA_COMMON_SETTRIG_SETTRIG30_SHIFT       (30U)
/*! SETTRIG30 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG30(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG30_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG30_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG31_MASK        (0x80000000U)
#define DMA_COMMON_SETTRIG_SETTRIG31_SHIFT       (31U)
/*! SETTRIG31 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG31(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG31_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG31_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG */
#define DMA_COMMON_SETTRIG_COUNT                 (1U)

/*! @name COMMON_SETTRIG1 - Set Trigger control bits for all DMA channels */
/*! @{ */
#define DMA_COMMON_SETTRIG1_SETTRIG32_MASK       (0x1U)
#define DMA_COMMON_SETTRIG1_SETTRIG32_SHIFT      (0U)
/*! SETTRIG32 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG32(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG32_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG32_MASK)
#define DMA_COMMON_SETTRIG1_SETTRIG33_MASK       (0x2U)
#define DMA_COMMON_SETTRIG1_SETTRIG33_SHIFT      (1U)
/*! SETTRIG33 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG33(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG33_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG33_MASK)
#define DMA_COMMON_SETTRIG1_SETTRIG34_MASK       (0x4U)
#define DMA_COMMON_SETTRIG1_SETTRIG34_SHIFT      (2U)
/*! SETTRIG34 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG34(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG34_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG34_MASK)
#define DMA_COMMON_SETTRIG1_SETTRIG35_MASK       (0x8U)
#define DMA_COMMON_SETTRIG1_SETTRIG35_SHIFT      (3U)
/*! SETTRIG35 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG35(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG35_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG35_MASK)
#define DMA_COMMON_SETTRIG1_SETTRIG36_MASK       (0x10U)
#define DMA_COMMON_SETTRIG1_SETTRIG36_SHIFT      (4U)
/*! SETTRIG36 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG36(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG36_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG36_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG1 */
#define DMA_COMMON_SETTRIG1_COUNT                (1U)

/*! @name COMMON_ABORT - Channel Abort control for all DMA channels */
/*! @{ */
#define DMA_COMMON_ABORT_ABORT0_MASK             (0x1U)
#define DMA_COMMON_ABORT_ABORT0_SHIFT            (0U)
/*! ABORT0 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT0(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT0_SHIFT)) & DMA_COMMON_ABORT_ABORT0_MASK)
#define DMA_COMMON_ABORT_ABORT1_MASK             (0x2U)
#define DMA_COMMON_ABORT_ABORT1_SHIFT            (1U)
/*! ABORT1 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT1(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT1_SHIFT)) & DMA_COMMON_ABORT_ABORT1_MASK)
#define DMA_COMMON_ABORT_ABORT2_MASK             (0x4U)
#define DMA_COMMON_ABORT_ABORT2_SHIFT            (2U)
/*! ABORT2 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT2(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT2_SHIFT)) & DMA_COMMON_ABORT_ABORT2_MASK)
#define DMA_COMMON_ABORT_ABORT3_MASK             (0x8U)
#define DMA_COMMON_ABORT_ABORT3_SHIFT            (3U)
/*! ABORT3 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT3(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT3_SHIFT)) & DMA_COMMON_ABORT_ABORT3_MASK)
#define DMA_COMMON_ABORT_ABORT4_MASK             (0x10U)
#define DMA_COMMON_ABORT_ABORT4_SHIFT            (4U)
/*! ABORT4 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT4(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT4_SHIFT)) & DMA_COMMON_ABORT_ABORT4_MASK)
#define DMA_COMMON_ABORT_ABORT5_MASK             (0x20U)
#define DMA_COMMON_ABORT_ABORT5_SHIFT            (5U)
/*! ABORT5 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT5(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT5_SHIFT)) & DMA_COMMON_ABORT_ABORT5_MASK)
#define DMA_COMMON_ABORT_ABORT6_MASK             (0x40U)
#define DMA_COMMON_ABORT_ABORT6_SHIFT            (6U)
/*! ABORT6 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT6(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT6_SHIFT)) & DMA_COMMON_ABORT_ABORT6_MASK)
#define DMA_COMMON_ABORT_ABORT7_MASK             (0x80U)
#define DMA_COMMON_ABORT_ABORT7_SHIFT            (7U)
/*! ABORT7 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT7(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT7_SHIFT)) & DMA_COMMON_ABORT_ABORT7_MASK)
#define DMA_COMMON_ABORT_ABORT8_MASK             (0x100U)
#define DMA_COMMON_ABORT_ABORT8_SHIFT            (8U)
/*! ABORT8 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT8(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT8_SHIFT)) & DMA_COMMON_ABORT_ABORT8_MASK)
#define DMA_COMMON_ABORT_ABORT9_MASK             (0x200U)
#define DMA_COMMON_ABORT_ABORT9_SHIFT            (9U)
/*! ABORT9 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT9(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT9_SHIFT)) & DMA_COMMON_ABORT_ABORT9_MASK)
#define DMA_COMMON_ABORT_ABORT10_MASK            (0x400U)
#define DMA_COMMON_ABORT_ABORT10_SHIFT           (10U)
/*! ABORT10 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT10(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT10_SHIFT)) & DMA_COMMON_ABORT_ABORT10_MASK)
#define DMA_COMMON_ABORT_ABORT11_MASK            (0x800U)
#define DMA_COMMON_ABORT_ABORT11_SHIFT           (11U)
/*! ABORT11 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT11(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT11_SHIFT)) & DMA_COMMON_ABORT_ABORT11_MASK)
#define DMA_COMMON_ABORT_ABORT12_MASK            (0x1000U)
#define DMA_COMMON_ABORT_ABORT12_SHIFT           (12U)
/*! ABORT12 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT12(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT12_SHIFT)) & DMA_COMMON_ABORT_ABORT12_MASK)
#define DMA_COMMON_ABORT_ABORT13_MASK            (0x2000U)
#define DMA_COMMON_ABORT_ABORT13_SHIFT           (13U)
/*! ABORT13 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT13(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT13_SHIFT)) & DMA_COMMON_ABORT_ABORT13_MASK)
#define DMA_COMMON_ABORT_ABORT14_MASK            (0x4000U)
#define DMA_COMMON_ABORT_ABORT14_SHIFT           (14U)
/*! ABORT14 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT14(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT14_SHIFT)) & DMA_COMMON_ABORT_ABORT14_MASK)
#define DMA_COMMON_ABORT_ABORT15_MASK            (0x8000U)
#define DMA_COMMON_ABORT_ABORT15_SHIFT           (15U)
/*! ABORT15 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT15(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT15_SHIFT)) & DMA_COMMON_ABORT_ABORT15_MASK)
#define DMA_COMMON_ABORT_ABORT16_MASK            (0x10000U)
#define DMA_COMMON_ABORT_ABORT16_SHIFT           (16U)
/*! ABORT16 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT16(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT16_SHIFT)) & DMA_COMMON_ABORT_ABORT16_MASK)
#define DMA_COMMON_ABORT_ABORT17_MASK            (0x20000U)
#define DMA_COMMON_ABORT_ABORT17_SHIFT           (17U)
/*! ABORT17 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT17(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT17_SHIFT)) & DMA_COMMON_ABORT_ABORT17_MASK)
#define DMA_COMMON_ABORT_ABORT18_MASK            (0x40000U)
#define DMA_COMMON_ABORT_ABORT18_SHIFT           (18U)
/*! ABORT18 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT18(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT18_SHIFT)) & DMA_COMMON_ABORT_ABORT18_MASK)
#define DMA_COMMON_ABORT_ABORT19_MASK            (0x80000U)
#define DMA_COMMON_ABORT_ABORT19_SHIFT           (19U)
/*! ABORT19 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT19(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT19_SHIFT)) & DMA_COMMON_ABORT_ABORT19_MASK)
#define DMA_COMMON_ABORT_ABORT20_MASK            (0x100000U)
#define DMA_COMMON_ABORT_ABORT20_SHIFT           (20U)
/*! ABORT20 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT20(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT20_SHIFT)) & DMA_COMMON_ABORT_ABORT20_MASK)
#define DMA_COMMON_ABORT_ABORT21_MASK            (0x200000U)
#define DMA_COMMON_ABORT_ABORT21_SHIFT           (21U)
/*! ABORT21 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT21(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT21_SHIFT)) & DMA_COMMON_ABORT_ABORT21_MASK)
#define DMA_COMMON_ABORT_ABORT22_MASK            (0x400000U)
#define DMA_COMMON_ABORT_ABORT22_SHIFT           (22U)
/*! ABORT22 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT22(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT22_SHIFT)) & DMA_COMMON_ABORT_ABORT22_MASK)
#define DMA_COMMON_ABORT_ABORT23_MASK            (0x800000U)
#define DMA_COMMON_ABORT_ABORT23_SHIFT           (23U)
/*! ABORT23 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT23(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT23_SHIFT)) & DMA_COMMON_ABORT_ABORT23_MASK)
#define DMA_COMMON_ABORT_ABORT24_MASK            (0x1000000U)
#define DMA_COMMON_ABORT_ABORT24_SHIFT           (24U)
/*! ABORT24 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT24(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT24_SHIFT)) & DMA_COMMON_ABORT_ABORT24_MASK)
#define DMA_COMMON_ABORT_ABORT25_MASK            (0x2000000U)
#define DMA_COMMON_ABORT_ABORT25_SHIFT           (25U)
/*! ABORT25 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT25(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT25_SHIFT)) & DMA_COMMON_ABORT_ABORT25_MASK)
#define DMA_COMMON_ABORT_ABORT26_MASK            (0x4000000U)
#define DMA_COMMON_ABORT_ABORT26_SHIFT           (26U)
/*! ABORT26 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT26(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT26_SHIFT)) & DMA_COMMON_ABORT_ABORT26_MASK)
#define DMA_COMMON_ABORT_ABORT27_MASK            (0x8000000U)
#define DMA_COMMON_ABORT_ABORT27_SHIFT           (27U)
/*! ABORT27 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT27(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT27_SHIFT)) & DMA_COMMON_ABORT_ABORT27_MASK)
#define DMA_COMMON_ABORT_ABORT28_MASK            (0x10000000U)
#define DMA_COMMON_ABORT_ABORT28_SHIFT           (28U)
/*! ABORT28 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT28(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT28_SHIFT)) & DMA_COMMON_ABORT_ABORT28_MASK)
#define DMA_COMMON_ABORT_ABORT29_MASK            (0x20000000U)
#define DMA_COMMON_ABORT_ABORT29_SHIFT           (29U)
/*! ABORT29 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT29(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT29_SHIFT)) & DMA_COMMON_ABORT_ABORT29_MASK)
#define DMA_COMMON_ABORT_ABORT30_MASK            (0x40000000U)
#define DMA_COMMON_ABORT_ABORT30_SHIFT           (30U)
/*! ABORT30 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT30(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT30_SHIFT)) & DMA_COMMON_ABORT_ABORT30_MASK)
#define DMA_COMMON_ABORT_ABORT31_MASK            (0x80000000U)
#define DMA_COMMON_ABORT_ABORT31_SHIFT           (31U)
/*! ABORT31 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT31(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT31_SHIFT)) & DMA_COMMON_ABORT_ABORT31_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT */
#define DMA_COMMON_ABORT_COUNT                   (1U)

/*! @name COMMON_ABORT1 - Channel Abort control for all DMA channels */
/*! @{ */
#define DMA_COMMON_ABORT1_ABORT32_MASK           (0x1U)
#define DMA_COMMON_ABORT1_ABORT32_SHIFT          (0U)
/*! ABORT32 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT32(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT32_SHIFT)) & DMA_COMMON_ABORT1_ABORT32_MASK)
#define DMA_COMMON_ABORT1_ABORT33_MASK           (0x2U)
#define DMA_COMMON_ABORT1_ABORT33_SHIFT          (1U)
/*! ABORT33 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT33(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT33_SHIFT)) & DMA_COMMON_ABORT1_ABORT33_MASK)
#define DMA_COMMON_ABORT1_ABORT34_MASK           (0x4U)
#define DMA_COMMON_ABORT1_ABORT34_SHIFT          (2U)
/*! ABORT34 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT34(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT34_SHIFT)) & DMA_COMMON_ABORT1_ABORT34_MASK)
#define DMA_COMMON_ABORT1_ABORT35_MASK           (0x8U)
#define DMA_COMMON_ABORT1_ABORT35_SHIFT          (3U)
/*! ABORT35 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT35(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT35_SHIFT)) & DMA_COMMON_ABORT1_ABORT35_MASK)
#define DMA_COMMON_ABORT1_ABORT36_MASK           (0x10U)
#define DMA_COMMON_ABORT1_ABORT36_SHIFT          (4U)
/*! ABORT36 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT36(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT36_SHIFT)) & DMA_COMMON_ABORT1_ABORT36_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT1 */
#define DMA_COMMON_ABORT1_COUNT                  (1U)

/*! @name CHANNEL_CFG - Configuration register for DMA channel */
/*! @{ */
#define DMA_CHANNEL_CFG_PERIPHREQEN_MASK         (0x1U)
#define DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT        (0U)
/*! PERIPHREQEN - Peripheral request Enable.
 *  0b0..Peripheral DMA requests disabled.
 *  0b1..Peripheral DMA requests enabled.
 */
#define DMA_CHANNEL_CFG_PERIPHREQEN(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT)) & DMA_CHANNEL_CFG_PERIPHREQEN_MASK)
#define DMA_CHANNEL_CFG_HWTRIGEN_MASK            (0x2U)
#define DMA_CHANNEL_CFG_HWTRIGEN_SHIFT           (1U)
/*! HWTRIGEN - Hardware Triggering Enable for channel.
 *  0b0..Hardware triggering not used for channel.
 *  0b1..Hardware triggering used for channel.
 */
#define DMA_CHANNEL_CFG_HWTRIGEN(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_HWTRIGEN_SHIFT)) & DMA_CHANNEL_CFG_HWTRIGEN_MASK)
#define DMA_CHANNEL_CFG_TRIGPOL_MASK             (0x10U)
#define DMA_CHANNEL_CFG_TRIGPOL_SHIFT            (4U)
/*! TRIGPOL - Trigger Polarity.
 *  0b0..Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
 *  0b1..Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
 */
#define DMA_CHANNEL_CFG_TRIGPOL(x)               (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGPOL_SHIFT)) & DMA_CHANNEL_CFG_TRIGPOL_MASK)
#define DMA_CHANNEL_CFG_TRIGTYPE_MASK            (0x20U)
#define DMA_CHANNEL_CFG_TRIGTYPE_SHIFT           (5U)
/*! TRIGTYPE - Trigger Type.
 *  0b0..Edge. Hardware trigger is edge triggered. Transfers will be initiated and completed, as specified for a single trigger.
 *  0b1..Level.
 */
#define DMA_CHANNEL_CFG_TRIGTYPE(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGTYPE_SHIFT)) & DMA_CHANNEL_CFG_TRIGTYPE_MASK)
#define DMA_CHANNEL_CFG_TRIGBURST_MASK           (0x40U)
#define DMA_CHANNEL_CFG_TRIGBURST_SHIFT          (6U)
/*! TRIGBURST - Trigger Burst.
 *  0b0..Single transfer.
 *  0b1..Burst transfer.
 */
#define DMA_CHANNEL_CFG_TRIGBURST(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGBURST_SHIFT)) & DMA_CHANNEL_CFG_TRIGBURST_MASK)
#define DMA_CHANNEL_CFG_BURSTPOWER_MASK          (0xF00U)
#define DMA_CHANNEL_CFG_BURSTPOWER_SHIFT         (8U)
/*! BURSTPOWER - Burst Power.
 */
#define DMA_CHANNEL_CFG_BURSTPOWER(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_BURSTPOWER_SHIFT)) & DMA_CHANNEL_CFG_BURSTPOWER_MASK)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK        (0x4000U)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT       (14U)
/*! SRCBURSTWRAP - Source Burst Wrap.
 *  0b0..Disabled.
 *  0b1..Enabled.
 */
#define DMA_CHANNEL_CFG_SRCBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK        (0x8000U)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT       (15U)
/*! DSTBURSTWRAP - Destination Burst Wrap.
 *  0b0..Disabled. Destination burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Destination burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_DSTBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK)
#define DMA_CHANNEL_CFG_CHPRIORITY_MASK          (0x70000U)
#define DMA_CHANNEL_CFG_CHPRIORITY_SHIFT         (16U)
/*! CHPRIORITY - Priority of channel when multiple DMA requests are pending.
 */
#define DMA_CHANNEL_CFG_CHPRIORITY(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_CHPRIORITY_SHIFT)) & DMA_CHANNEL_CFG_CHPRIORITY_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CFG */
#define DMA_CHANNEL_CFG_COUNT                    (37U)

/*! @name CHANNEL_CTLSTAT - Control and status register for DMA channel */
/*! @{ */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK    (0x1U)
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT   (0U)
/*! VALIDPENDING - Valid pending flag for this channel.
 *  0b0..No effect on DMA operation.
 *  0b1..Valid pending.
 */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING(x)      (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT)) & DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK)
#define DMA_CHANNEL_CTLSTAT_TRIG_MASK            (0x4U)
#define DMA_CHANNEL_CTLSTAT_TRIG_SHIFT           (2U)
/*! TRIG - Trigger flag.
 *  0b0..Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
 *  0b1..Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
 */
#define DMA_CHANNEL_CTLSTAT_TRIG(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_TRIG_SHIFT)) & DMA_CHANNEL_CTLSTAT_TRIG_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CTLSTAT */
#define DMA_CHANNEL_CTLSTAT_COUNT                (37U)

/*! @name CHANNEL_XFERCFG - Transfer configuration register for DMA channel */
/*! @{ */
#define DMA_CHANNEL_XFERCFG_CFGVALID_MASK        (0x1U)
#define DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT       (0U)
/*! CFGVALID - Configuration Valid flag.
 *  0b0..Not valid.
 *  0b1..Valid.
 */
#define DMA_CHANNEL_XFERCFG_CFGVALID(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT)) & DMA_CHANNEL_XFERCFG_CFGVALID_MASK)
#define DMA_CHANNEL_XFERCFG_RELOAD_MASK          (0x2U)
#define DMA_CHANNEL_XFERCFG_RELOAD_SHIFT         (1U)
/*! RELOAD - Reload.
 *  0b0..Disabled. The channels' control structure should not be reloaded when the current descriptor is exhausted.
 *  0b1..Enabled. The channels' control structure should be reloaded when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_RELOAD(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_RELOAD_SHIFT)) & DMA_CHANNEL_XFERCFG_RELOAD_MASK)
#define DMA_CHANNEL_XFERCFG_SWTRIG_MASK          (0x4U)
#define DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT         (2U)
/*! SWTRIG - Software Trigger.
 *  0b0..Not set.
 *  0b1..Set.
 */
#define DMA_CHANNEL_XFERCFG_SWTRIG(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_SWTRIG_MASK)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_MASK         (0x8U)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT        (3U)
/*! CLRTRIG - Clear Trigger.
 *  0b0..Not cleared.
 *  0b1..Cleared.
 */
#define DMA_CHANNEL_XFERCFG_CLRTRIG(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_CLRTRIG_MASK)
#define DMA_CHANNEL_XFERCFG_SETINTA_MASK         (0x10U)
#define DMA_CHANNEL_XFERCFG_SETINTA_SHIFT        (4U)
/*! SETINTA - Set Interrupt flag A for channel.
 *  0b0..No effect.
 *  0b1..Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTA_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTA_MASK)
#define DMA_CHANNEL_XFERCFG_SETINTB_MASK         (0x20U)
#define DMA_CHANNEL_XFERCFG_SETINTB_SHIFT        (5U)
/*! SETINTB - Set Interrupt flag B for channel.
 *  0b0..No effect.
 *  0b1..Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTB(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTB_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTB_MASK)
#define DMA_CHANNEL_XFERCFG_WIDTH_MASK           (0x300U)
#define DMA_CHANNEL_XFERCFG_WIDTH_SHIFT          (8U)
/*! WIDTH - Transfer width used for this DMA channel.
 *  0b00..8-bit.
 *  0b01..16-bit.
 *  0b10..32-bit.
 *  0b11..Reserved.
 */
#define DMA_CHANNEL_XFERCFG_WIDTH(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_WIDTH_SHIFT)) & DMA_CHANNEL_XFERCFG_WIDTH_MASK)
#define DMA_CHANNEL_XFERCFG_SRCINC_MASK          (0x3000U)
#define DMA_CHANNEL_XFERCFG_SRCINC_SHIFT         (12U)
/*! SRCINC - Source address increment
 *  0b00..No increment.
 *  0b01..1 x width.
 *  0b10..2 x width.
 *  0b11..4 x width.
 */
#define DMA_CHANNEL_XFERCFG_SRCINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SRCINC_SHIFT)) & DMA_CHANNEL_XFERCFG_SRCINC_MASK)
#define DMA_CHANNEL_XFERCFG_DSTINC_MASK          (0xC000U)
#define DMA_CHANNEL_XFERCFG_DSTINC_SHIFT         (14U)
/*! DSTINC - Destination address increment
 *  0b00..No increment.
 *  0b01..1 x width.
 *  0b10..2 x width.
 *  0b11..4 x width.
 */
#define DMA_CHANNEL_XFERCFG_DSTINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_DSTINC_SHIFT)) & DMA_CHANNEL_XFERCFG_DSTINC_MASK)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK       (0x3FF0000U)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT      (16U)
/*! XFERCOUNT - Total number of transfers to be performed, minus 1 encoded.
 */
#define DMA_CHANNEL_XFERCFG_XFERCOUNT(x)         (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT)) & DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK)
/*! @} */

/* The count of DMA_CHANNEL_XFERCFG */
#define DMA_CHANNEL_XFERCFG_COUNT                (37U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x50104000u)
  /** Peripheral DMA0 base address */
  #define DMA0_BASE_NS                             (0x40104000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA0 base pointer */
  #define DMA0_NS                                  ((DMA_Type *)DMA0_BASE_NS)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE                                (0x50105000u)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE_NS                             (0x40105000u)
  /** Peripheral DMA1 base pointer */
  #define DMA1                                     ((DMA_Type *)DMA1_BASE)
  /** Peripheral DMA1 base pointer */
  #define DMA1_NS                                  ((DMA_Type *)DMA1_BASE_NS)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0, DMA1 }
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS_NS                        { DMA0_BASE_NS, DMA1_BASE_NS }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS_NS                         { DMA0_NS, DMA1_NS }
#else
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x40104000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA1 base address */
  #define DMA1_BASE                                (0x40105000u)
  /** Peripheral DMA1 base pointer */
  #define DMA1                                     ((DMA_Type *)DMA1_BASE)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0, DMA1 }
#endif
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS                                 { DMA0_IRQn, DMA1_IRQn }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMIC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Peripheral_Access_Layer DMIC Peripheral Access Layer
 * @{
 */

/** DMIC - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x100 */
    __IO uint32_t OSR;                               /**< Oversample Rate, array offset: 0x0, array step: 0x100 */
    __IO uint32_t DIVHFCLK;                          /**< DMIC Clock, array offset: 0x4, array step: 0x100 */
    __IO uint32_t PREAC2FSCOEF;                      /**< Compensation Filter for 2 FS, array offset: 0x8, array step: 0x100 */
    __IO uint32_t PREAC4FSCOEF;                      /**< Compensation Filter for 4 FS, array offset: 0xC, array step: 0x100 */
    __IO uint32_t GAINSHIFT;                         /**< Decimator Gain Shift, array offset: 0x10, array step: 0x100 */
         uint8_t RESERVED_0[108];
    __IO uint32_t FIFO_CTRL;                         /**< FIFO Control, array offset: 0x80, array step: 0x100 */
    __IO uint32_t FIFO_STATUS;                       /**< FIFO Status, array offset: 0x84, array step: 0x100 */
    __I  uint32_t FIFO_DATA;                         /**< FIFO Data, array offset: 0x88, array step: 0x100 */
    __IO uint32_t PHY_CTRL;                          /**< Physical Control, array offset: 0x8C, array step: 0x100 */
    __IO uint32_t DC_CTRL;                           /**< DC Filter Control, array offset: 0x90, array step: 0x100 */
         uint8_t RESERVED_1[108];
  } CHANNEL[8];
       uint8_t RESERVED_0[1792];
  __IO uint32_t CHANEN;                            /**< Channel Enable, offset: 0xF00 */
       uint8_t RESERVED_1[12];
  __IO uint32_t USE2FS;                            /**< Use 2 FS register, offset: 0xF10 */
  __IO uint32_t GLOBAL_SYNC_EN;                    /**< Global Channel Synchronization Enable, offset: 0xF14 */
  __IO uint32_t GLOBAL_COUNT_VAL;                  /**< Global channel synchronization counter value, offset: 0xF18 */
  __IO uint32_t DECRESET;                          /**< DMIC decimator reset, offset: 0xF1C */
       uint8_t RESERVED_2[96];
  __IO uint32_t HWVADGAIN;                         /**< HWVAD Input Gain, offset: 0xF80 */
  __IO uint32_t HWVADHPFS;                         /**< HWVAD Filter Control, offset: 0xF84 */
  __IO uint32_t HWVADST10;                         /**< HWVAD Control, offset: 0xF88 */
  __IO uint32_t HWVADRSTT;                         /**< HWVAD Filter Reset, offset: 0xF8C */
  __IO uint32_t HWVADTHGN;                         /**< HWVAD Noise Estimator Gain, offset: 0xF90 */
  __IO uint32_t HWVADTHGS;                         /**< HWVAD Signal Estimator Gain, offset: 0xF94 */
  __I  uint32_t HWVADLOWZ;                         /**< HWVAD Noise Envelope Estimator, offset: 0xF98 */
} DMIC_Type;

/* ----------------------------------------------------------------------------
   -- DMIC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Register_Masks DMIC Register Masks
 * @{
 */

/*! @name CHANNEL_OSR - Oversample Rate */
/*! @{ */
#define DMIC_CHANNEL_OSR_OSR_MASK                (0xFFU)
#define DMIC_CHANNEL_OSR_OSR_SHIFT               (0U)
/*! OSR - Oversample Rate
 */
#define DMIC_CHANNEL_OSR_OSR(x)                  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_OSR_OSR_SHIFT)) & DMIC_CHANNEL_OSR_OSR_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_OSR */
#define DMIC_CHANNEL_OSR_COUNT                   (8U)

/*! @name CHANNEL_DIVHFCLK - DMIC Clock */
/*! @{ */
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK        (0xFU)
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT       (0U)
/*! PDMDIV - PDM Clock Divider Value
 *  0b0000..Divide by 1
 *  0b0001..Divide by 2
 *  0b0010..Divide by 3
 *  0b0011..Divide by 4
 *  0b0100..Divide by 6
 *  0b0101..Divide by 8
 *  0b0110..Divide by 12
 *  0b0111..Divide by 16
 *  0b1000..Divide by 24
 *  0b1001..Divide by 32
 *  0b1010..Divide by 48
 *  0b1011..Divide by 64
 *  0b1100..Divide by 96
 *  0b1101..Divide by 128
 *  0b1110-0b1111..Reserved
 */
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT)) & DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DIVHFCLK */
#define DMIC_CHANNEL_DIVHFCLK_COUNT              (8U)

/*! @name CHANNEL_PREAC2FSCOEF - Compensation Filter for 2 FS */
/*! @{ */
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Compensation value
 *  0b00..Compensation = 0. This is the recommended setting.
 *  0b01..Compensation = -0.16
 *  0b10..Compensation = -0.15
 *  0b11..Compensation = -0.13
 */
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC2FSCOEF */
#define DMIC_CHANNEL_PREAC2FSCOEF_COUNT          (8U)

/*! @name CHANNEL_PREAC4FSCOEF - Compensation Filter for 4 FS */
/*! @{ */
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Compensation value
 *  0b00..Compensation = 0. This is the recommended setting.
 *  0b01..Compensation = -0.16
 *  0b10..Compensation = -0.15
 *  0b11..Compensation = -0.13
 */
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC4FSCOEF */
#define DMIC_CHANNEL_PREAC4FSCOEF_COUNT          (8U)

/*! @name CHANNEL_GAINSHIFT - Decimator Gain Shift */
/*! @{ */
#define DMIC_CHANNEL_GAINSHIFT_GAIN_MASK         (0x1FU)
#define DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT        (0U)
/*! GAIN - Gain
 */
#define DMIC_CHANNEL_GAINSHIFT_GAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT)) & DMIC_CHANNEL_GAINSHIFT_GAIN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_GAINSHIFT */
#define DMIC_CHANNEL_GAINSHIFT_COUNT             (8U)

/*! @name CHANNEL_FIFO_CTRL - FIFO Control */
/*! @{ */
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK       (0x1U)
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT      (0U)
/*! ENABLE - FIFO Enable.
 *  0b0..Disabled.
 *  0b1..FIFO is enabled. The FIFO must be enabled in order for the CPU or DMA to read data from the DMIC via the FIFODATA register.
 */
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK       (0x2U)
#define DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT      (1U)
/*! RESETN - FIFO Reset
 *  0b0..Reset the FIFO. This must be cleared before resuming operation.
 *  0b1..Normal operation
 */
#define DMIC_CHANNEL_FIFO_CTRL_RESETN(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK        (0x4U)
#define DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT       (2U)
/*! INTEN - Interrupt Enable.
 *  0b0..FIFO level interrupts are not enabled.
 *  0b1..FIFO level interrupts are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_INTEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK        (0x8U)
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT       (3U)
/*! DMAEN - DMA Enable
 *  0b0..DMA requests are not enabled.
 *  0b1..DMA requests based on FIFO level are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK      (0x1F0000U)
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT     (16U)
/*! TRIGLVL - FIFO Trigger Level for Interrupt
 *  0b00000..Trigger when the FIFO has received one entry (is no longer empty).
 *  0b00001..Trigger when the FIFO has received two entries.
 *  0b01110..Trigger when the FIFO has received 15 entries.
 *  0b01111..Trigger when the FIFO has received 16 entries (has become full).
 */
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_CTRL */
#define DMIC_CHANNEL_FIFO_CTRL_COUNT             (8U)

/*! @name CHANNEL_FIFO_STATUS - FIFO Status */
/*! @{ */
#define DMIC_CHANNEL_FIFO_STATUS_INT_MASK        (0x1U)
#define DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT       (0U)
/*! INT - Status of Interrupt (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_INT(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_INT_MASK)
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK    (0x2U)
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT   (1U)
/*! OVERRUN - Overrun Detected (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN(x)      (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK)
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK   (0x4U)
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT  (2U)
/*! UNDERRUN - Underrun Detected (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN(x)     (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_STATUS */
#define DMIC_CHANNEL_FIFO_STATUS_COUNT           (8U)

/*! @name CHANNEL_FIFO_DATA - FIFO Data */
/*! @{ */
#define DMIC_CHANNEL_FIFO_DATA_DATA_MASK         (0xFFFFFFU)
#define DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT        (0U)
/*! DATA - PCM Data
 */
#define DMIC_CHANNEL_FIFO_DATA_DATA(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT)) & DMIC_CHANNEL_FIFO_DATA_DATA_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_DATA */
#define DMIC_CHANNEL_FIFO_DATA_COUNT             (8U)

/*! @name CHANNEL_PHY_CTRL - Physical Control */
/*! @{ */
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK      (0x1U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT     (0U)
/*! PHY_FALL - Capture DMIC on Falling edge (0 means on rising)
 *  0b0..Capture PDM_DATA on the rising edge of PDM_CLK.
 *  0b1..Capture PDM_DATA on the falling edge of PDM_CLK.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK)
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK      (0x2U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT     (1U)
/*! PHY_HALF - Use Half rate sampling (ie Clock to dmic is sent at half the speed than the decimator is providing)
 *  0b0..Standard half rate sampling. The clock to the DMIC is sent at the same rate as the decimator is providing.
 *  0b1..Use half rate sampling. The clock to the DMIC is sent at half the rate that the decimator is providing.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PHY_CTRL */
#define DMIC_CHANNEL_PHY_CTRL_COUNT              (8U)

/*! @name CHANNEL_DC_CTRL - DC Filter Control */
/*! @{ */
#define DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK         (0x3U)
#define DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT        (0U)
/*! DCPOLE - DC Block Filter
 *  0b00..Flat Response, no filter
 *  0b01..155 Hz
 *  0b10..78 Hz
 *  0b11..39 Hz
 */
#define DMIC_CHANNEL_DC_CTRL_DCPOLE(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK)
#define DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK         (0xF0U)
#define DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT        (4U)
/*! DCGAIN - DC Gain
 */
#define DMIC_CHANNEL_DC_CTRL_DCGAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK)
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK (0x100U)
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT (8U)
/*! SATURATEAT16BIT - Saturate at 16 Bit
 *  0b0..Do not Saturate. Results roll over if out range and do not saturate.
 *  0b1..Saturate. If the result overflows, it saturates at 0xFFFF for positive overflow and 0x8000 for negative overflow.
 */
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT(x)  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK)
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_MASK     (0x200U)
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_SHIFT    (9U)
/*! SIGNEXTEND - Sign Extend
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND(x)       (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DC_CTRL */
#define DMIC_CHANNEL_DC_CTRL_COUNT               (8U)

/*! @name CHANEN - Channel Enable */
/*! @{ */
#define DMIC_CHANEN_EN_CH0_MASK                  (0x1U)
#define DMIC_CHANEN_EN_CH0_SHIFT                 (0U)
/*! EN_CH0 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH0(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH0_SHIFT)) & DMIC_CHANEN_EN_CH0_MASK)
#define DMIC_CHANEN_EN_CH1_MASK                  (0x2U)
#define DMIC_CHANEN_EN_CH1_SHIFT                 (1U)
/*! EN_CH1 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH1(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH1_SHIFT)) & DMIC_CHANEN_EN_CH1_MASK)
#define DMIC_CHANEN_EN_CH2_MASK                  (0x4U)
#define DMIC_CHANEN_EN_CH2_SHIFT                 (2U)
/*! EN_CH2 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH2(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH2_SHIFT)) & DMIC_CHANEN_EN_CH2_MASK)
#define DMIC_CHANEN_EN_CH3_MASK                  (0x8U)
#define DMIC_CHANEN_EN_CH3_SHIFT                 (3U)
/*! EN_CH3 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH3(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH3_SHIFT)) & DMIC_CHANEN_EN_CH3_MASK)
#define DMIC_CHANEN_EN_CH4_MASK                  (0x10U)
#define DMIC_CHANEN_EN_CH4_SHIFT                 (4U)
/*! EN_CH4 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH4(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH4_SHIFT)) & DMIC_CHANEN_EN_CH4_MASK)
#define DMIC_CHANEN_EN_CH5_MASK                  (0x20U)
#define DMIC_CHANEN_EN_CH5_SHIFT                 (5U)
/*! EN_CH5 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH5(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH5_SHIFT)) & DMIC_CHANEN_EN_CH5_MASK)
#define DMIC_CHANEN_EN_CH6_MASK                  (0x40U)
#define DMIC_CHANEN_EN_CH6_SHIFT                 (6U)
/*! EN_CH6 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH6(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH6_SHIFT)) & DMIC_CHANEN_EN_CH6_MASK)
#define DMIC_CHANEN_EN_CH7_MASK                  (0x80U)
#define DMIC_CHANEN_EN_CH7_SHIFT                 (7U)
/*! EN_CH7 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH7(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH7_SHIFT)) & DMIC_CHANEN_EN_CH7_MASK)
/*! @} */

/*! @name USE2FS - Use 2 FS register */
/*! @{ */
#define DMIC_USE2FS_USE2FS_MASK                  (0x1U)
#define DMIC_USE2FS_USE2FS_SHIFT                 (0U)
/*! USE2FS - Use 2FS register
 *  0b0..Use 1 FS output for PCM data.
 *  0b1..Use 2 FS output for PCM data.
 */
#define DMIC_USE2FS_USE2FS(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_USE2FS_USE2FS_SHIFT)) & DMIC_USE2FS_USE2FS_MASK)
/*! @} */

/*! @name GLOBAL_SYNC_EN - Global Channel Synchronization Enable */
/*! @{ */
#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_MASK      (0xFFU)
#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_SHIFT     (0U)
/*! CH_SYNC_EN - Channel synch enable
 */
#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_SHIFT)) & DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_MASK)
/*! @} */

/*! @name GLOBAL_COUNT_VAL - Global channel synchronization counter value */
/*! @{ */
#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_MASK     (0xFFFFFFFFU)
#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_SHIFT    (0U)
/*! CCOUNTVAL - Channel Counter Value
 */
#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL(x)       (((uint32_t)(((uint32_t)(x)) << DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_SHIFT)) & DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_MASK)
/*! @} */

/*! @name DECRESET - DMIC decimator reset */
/*! @{ */
#define DMIC_DECRESET_DECRESET_MASK              (0xFFU)
#define DMIC_DECRESET_DECRESET_SHIFT             (0U)
/*! DECRESET - Decimator reset
 *  0b00000000..Disable
 *  0b00000001..Enable
 */
#define DMIC_DECRESET_DECRESET(x)                (((uint32_t)(((uint32_t)(x)) << DMIC_DECRESET_DECRESET_SHIFT)) & DMIC_DECRESET_DECRESET_MASK)
/*! @} */

/*! @name HWVADGAIN - HWVAD Input Gain */
/*! @{ */
#define DMIC_HWVADGAIN_INPUTGAIN_MASK            (0xFU)
#define DMIC_HWVADGAIN_INPUTGAIN_SHIFT           (0U)
/*! INPUTGAIN - Input Gain
 *  0b0000..-10 bits
 *  0b0001..-8 bits
 *  0b0010..-6 bits
 *  0b0011..-4 bits
 *  0b0100..-2 bits
 *  0b0101..0 bits (default)
 *  0b0110..+2 bits
 *  0b0111..+4 bits
 *  0b1000..+6 bits
 *  0b1001..+8 bits
 *  0b1010..+10 bits
 *  0b1011..+12 bits
 *  0b1100..+14 bits
 *  0b1101-0b1111..Reserved
 */
#define DMIC_HWVADGAIN_INPUTGAIN(x)              (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADGAIN_INPUTGAIN_SHIFT)) & DMIC_HWVADGAIN_INPUTGAIN_MASK)
/*! @} */

/*! @name HWVADHPFS - HWVAD Filter Control */
/*! @{ */
#define DMIC_HWVADHPFS_HPFS_MASK                 (0x3U)
#define DMIC_HWVADHPFS_HPFS_SHIFT                (0U)
/*! HPFS - The HPFS field chooses the High Pass filter in first part of HWVAD.
 *  0b00..Bypass
 *  0b01..High Pass 1750 Hz
 *  0b10..High Pass 215 Hz
 *  0b11..Reserved
 */
#define DMIC_HWVADHPFS_HPFS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADHPFS_HPFS_SHIFT)) & DMIC_HWVADHPFS_HPFS_MASK)
/*! @} */

/*! @name HWVADST10 - HWVAD Control */
/*! @{ */
#define DMIC_HWVADST10_ST10_MASK                 (0x1U)
#define DMIC_HWVADST10_ST10_SHIFT                (0U)
/*! ST10 - STAGE 1
 *  0b0..Normal operation, waiting for HWVAD trigger event (stage 0).
 *  0b1..Reset internal interrupt flag by writing a '1' (stage 1) pulse.
 */
#define DMIC_HWVADST10_ST10(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADST10_ST10_SHIFT)) & DMIC_HWVADST10_ST10_MASK)
/*! @} */

/*! @name HWVADRSTT - HWVAD Filter Reset */
/*! @{ */
#define DMIC_HWVADRSTT_RSST_MASK                 (0x1U)
#define DMIC_HWVADRSTT_RSST_SHIFT                (0U)
/*! RSST - Reset HWVAD
 */
#define DMIC_HWVADRSTT_RSST(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADRSTT_RSST_SHIFT)) & DMIC_HWVADRSTT_RSST_MASK)
/*! @} */

/*! @name HWVADTHGN - HWVAD Noise Estimator Gain */
/*! @{ */
#define DMIC_HWVADTHGN_THGN_MASK                 (0xFU)
#define DMIC_HWVADTHGN_THGN_SHIFT                (0U)
/*! THGN - Gain Factor for Noise Estimator
 */
#define DMIC_HWVADTHGN_THGN(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGN_THGN_SHIFT)) & DMIC_HWVADTHGN_THGN_MASK)
/*! @} */

/*! @name HWVADTHGS - HWVAD Signal Estimator Gain */
/*! @{ */
#define DMIC_HWVADTHGS_THGS_MASK                 (0xFU)
#define DMIC_HWVADTHGS_THGS_SHIFT                (0U)
/*! THGS - Signal Gain Factor
 */
#define DMIC_HWVADTHGS_THGS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGS_THGS_SHIFT)) & DMIC_HWVADTHGS_THGS_MASK)
/*! @} */

/*! @name HWVADLOWZ - HWVAD Noise Envelope Estimator */
/*! @{ */
#define DMIC_HWVADLOWZ_LOWZ_MASK                 (0xFFFFU)
#define DMIC_HWVADLOWZ_LOWZ_SHIFT                (0U)
/*! LOWZ - Average Noise-floor Value
 */
#define DMIC_HWVADLOWZ_LOWZ(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADLOWZ_LOWZ_SHIFT)) & DMIC_HWVADLOWZ_LOWZ_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DMIC_Register_Masks */


/* DMIC - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral DMIC0 base address */
  #define DMIC0_BASE                               (0x50121000u)
  /** Peripheral DMIC0 base address */
  #define DMIC0_BASE_NS                            (0x40121000u)
  /** Peripheral DMIC0 base pointer */
  #define DMIC0                                    ((DMIC_Type *)DMIC0_BASE)
  /** Peripheral DMIC0 base pointer */
  #define DMIC0_NS                                 ((DMIC_Type *)DMIC0_BASE_NS)
  /** Array initializer of DMIC peripheral base addresses */
  #define DMIC_BASE_ADDRS                          { DMIC0_BASE }
  /** Array initializer of DMIC peripheral base pointers */
  #define DMIC_BASE_PTRS                           { DMIC0 }
  /** Array initializer of DMIC peripheral base addresses */
  #define DMIC_BASE_ADDRS_NS                       { DMIC0_BASE_NS }
  /** Array initializer of DMIC peripheral base pointers */
  #define DMIC_BASE_PTRS_NS                        { DMIC0_NS }
#else
  /** Peripheral DMIC0 base address */
  #define DMIC0_BASE                               (0x40121000u)
  /** Peripheral DMIC0 base pointer */
  #define DMIC0                                    ((DMIC_Type *)DMIC0_BASE)
  /** Array initializer of DMIC peripheral base addresses */
  #define DMIC_BASE_ADDRS                          { DMIC0_BASE }
  /** Array initializer of DMIC peripheral base pointers */
  #define DMIC_BASE_PTRS                           { DMIC0 }
#endif
/** Interrupt vectors for the DMIC peripheral type */
#define DMIC_IRQS                                { DMIC0_IRQn }
#define DMIC_HWVAD_IRQS                          { HWVAD0_IRQn }

/*!
 * @}
 */ /* end of group DMIC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXCOMM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Peripheral_Access_Layer FLEXCOMM Peripheral Access Layer
 * @{
 */

/** FLEXCOMM - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4088];
  __IO uint32_t PSELID;                            /**< Peripheral Select and Flexcomm module ID, offset: 0xFF8 */
  __I  uint32_t PID;                               /**< Peripheral Identification, offset: 0xFFC */
} FLEXCOMM_Type;

/* ----------------------------------------------------------------------------
   -- FLEXCOMM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Register_Masks FLEXCOMM Register Masks
 * @{
 */

/*! @name PSELID - Peripheral Select and Flexcomm module ID */
/*! @{ */
#define FLEXCOMM_PSELID_PERSEL_MASK              (0x7U)
#define FLEXCOMM_PSELID_PERSEL_SHIFT             (0U)
/*! PERSEL - Peripheral Select
 *  0b000..No peripheral selected.
 *  0b001..USART function selected
 *  0b010..SPI function selected
 *  0b011..I2C
 *  0b100..I2S Transmit
 *  0b101..I2S Receive
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define FLEXCOMM_PSELID_PERSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_PERSEL_SHIFT)) & FLEXCOMM_PSELID_PERSEL_MASK)
#define FLEXCOMM_PSELID_LOCK_MASK                (0x8U)
#define FLEXCOMM_PSELID_LOCK_SHIFT               (3U)
/*! LOCK - Lock the peripheral select
 *  0b0..Peripheral select can be changed by software.
 *  0b1..Peripheral select is locked and cannot be changed until this Flexcomm module or the entire device is reset.
 */
#define FLEXCOMM_PSELID_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_LOCK_SHIFT)) & FLEXCOMM_PSELID_LOCK_MASK)
#define FLEXCOMM_PSELID_USARTPRESENT_MASK        (0x10U)
#define FLEXCOMM_PSELID_USARTPRESENT_SHIFT       (4U)
/*! USARTPRESENT - USART present indicator
 *  0b0..This Flexcomm module does not include the USART function.
 *  0b1..This Flexcomm module includes the USART function.
 */
#define FLEXCOMM_PSELID_USARTPRESENT(x)          (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_USARTPRESENT_SHIFT)) & FLEXCOMM_PSELID_USARTPRESENT_MASK)
#define FLEXCOMM_PSELID_SPIPRESENT_MASK          (0x20U)
#define FLEXCOMM_PSELID_SPIPRESENT_SHIFT         (5U)
/*! SPIPRESENT - SPI present indicator
 *  0b0..This Flexcomm module does not include the SPI function.
 *  0b1..This Flexcomm module includes the SPI function.
 */
#define FLEXCOMM_PSELID_SPIPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_SPIPRESENT_SHIFT)) & FLEXCOMM_PSELID_SPIPRESENT_MASK)
#define FLEXCOMM_PSELID_I2CPRESENT_MASK          (0x40U)
#define FLEXCOMM_PSELID_I2CPRESENT_SHIFT         (6U)
/*! I2CPRESENT - I2C present indicator
 *  0b0..I2C Not Present
 *  0b1..I2C Present
 */
#define FLEXCOMM_PSELID_I2CPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2CPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2CPRESENT_MASK)
#define FLEXCOMM_PSELID_I2SPRESENT_MASK          (0x80U)
#define FLEXCOMM_PSELID_I2SPRESENT_SHIFT         (7U)
/*! I2SPRESENT - I2S Present
 *  0b0..I2S Not Present
 *  0b1..I2S Present
 */
#define FLEXCOMM_PSELID_I2SPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2SPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2SPRESENT_MASK)
#define FLEXCOMM_PSELID_ID_MASK                  (0xFFFFF000U)
#define FLEXCOMM_PSELID_ID_SHIFT                 (12U)
/*! ID - Flexcomm ID
 */
#define FLEXCOMM_PSELID_ID(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_ID_SHIFT)) & FLEXCOMM_PSELID_ID_MASK)
/*! @} */

/*! @name PID - Peripheral Identification */
/*! @{ */
#define FLEXCOMM_PID_Minor_Rev_MASK              (0xF00U)
#define FLEXCOMM_PID_Minor_Rev_SHIFT             (8U)
/*! Minor_Rev - Minor revision of module implementation
 */
#define FLEXCOMM_PID_Minor_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Minor_Rev_SHIFT)) & FLEXCOMM_PID_Minor_Rev_MASK)
#define FLEXCOMM_PID_Major_Rev_MASK              (0xF000U)
#define FLEXCOMM_PID_Major_Rev_SHIFT             (12U)
/*! Major_Rev - Major revision of module implementation
 */
#define FLEXCOMM_PID_Major_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Major_Rev_SHIFT)) & FLEXCOMM_PID_Major_Rev_MASK)
#define FLEXCOMM_PID_ID_MASK                     (0xFFFF0000U)
#define FLEXCOMM_PID_ID_SHIFT                    (16U)
/*! ID - Module identifier for the selected function
 */
#define FLEXCOMM_PID_ID(x)                       (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_ID_SHIFT)) & FLEXCOMM_PID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FLEXCOMM_Register_Masks */


/* FLEXCOMM - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral FLEXCOMM0 base address */
  #define FLEXCOMM0_BASE                           (0x50106000u)
  /** Peripheral FLEXCOMM0 base address */
  #define FLEXCOMM0_BASE_NS                        (0x40106000u)
  /** Peripheral FLEXCOMM0 base pointer */
  #define FLEXCOMM0                                ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
  /** Peripheral FLEXCOMM0 base pointer */
  #define FLEXCOMM0_NS                             ((FLEXCOMM_Type *)FLEXCOMM0_BASE_NS)
  /** Peripheral FLEXCOMM1 base address */
  #define FLEXCOMM1_BASE                           (0x50107000u)
  /** Peripheral FLEXCOMM1 base address */
  #define FLEXCOMM1_BASE_NS                        (0x40107000u)
  /** Peripheral FLEXCOMM1 base pointer */
  #define FLEXCOMM1                                ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
  /** Peripheral FLEXCOMM1 base pointer */
  #define FLEXCOMM1_NS                             ((FLEXCOMM_Type *)FLEXCOMM1_BASE_NS)
  /** Peripheral FLEXCOMM2 base address */
  #define FLEXCOMM2_BASE                           (0x50108000u)
  /** Peripheral FLEXCOMM2 base address */
  #define FLEXCOMM2_BASE_NS                        (0x40108000u)
  /** Peripheral FLEXCOMM2 base pointer */
  #define FLEXCOMM2                                ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
  /** Peripheral FLEXCOMM2 base pointer */
  #define FLEXCOMM2_NS                             ((FLEXCOMM_Type *)FLEXCOMM2_BASE_NS)
  /** Peripheral FLEXCOMM3 base address */
  #define FLEXCOMM3_BASE                           (0x50109000u)
  /** Peripheral FLEXCOMM3 base address */
  #define FLEXCOMM3_BASE_NS                        (0x40109000u)
  /** Peripheral FLEXCOMM3 base pointer */
  #define FLEXCOMM3                                ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
  /** Peripheral FLEXCOMM3 base pointer */
  #define FLEXCOMM3_NS                             ((FLEXCOMM_Type *)FLEXCOMM3_BASE_NS)
  /** Peripheral FLEXCOMM4 base address */
  #define FLEXCOMM4_BASE                           (0x50122000u)
  /** Peripheral FLEXCOMM4 base address */
  #define FLEXCOMM4_BASE_NS                        (0x40122000u)
  /** Peripheral FLEXCOMM4 base pointer */
  #define FLEXCOMM4                                ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
  /** Peripheral FLEXCOMM4 base pointer */
  #define FLEXCOMM4_NS                             ((FLEXCOMM_Type *)FLEXCOMM4_BASE_NS)
  /** Peripheral FLEXCOMM5 base address */
  #define FLEXCOMM5_BASE                           (0x50123000u)
  /** Peripheral FLEXCOMM5 base address */
  #define FLEXCOMM5_BASE_NS                        (0x40123000u)
  /** Peripheral FLEXCOMM5 base pointer */
  #define FLEXCOMM5                                ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
  /** Peripheral FLEXCOMM5 base pointer */
  #define FLEXCOMM5_NS                             ((FLEXCOMM_Type *)FLEXCOMM5_BASE_NS)
  /** Peripheral FLEXCOMM6 base address */
  #define FLEXCOMM6_BASE                           (0x50124000u)
  /** Peripheral FLEXCOMM6 base address */
  #define FLEXCOMM6_BASE_NS                        (0x40124000u)
  /** Peripheral FLEXCOMM6 base pointer */
  #define FLEXCOMM6                                ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
  /** Peripheral FLEXCOMM6 base pointer */
  #define FLEXCOMM6_NS                             ((FLEXCOMM_Type *)FLEXCOMM6_BASE_NS)
  /** Peripheral FLEXCOMM7 base address */
  #define FLEXCOMM7_BASE                           (0x50125000u)
  /** Peripheral FLEXCOMM7 base address */
  #define FLEXCOMM7_BASE_NS                        (0x40125000u)
  /** Peripheral FLEXCOMM7 base pointer */
  #define FLEXCOMM7                                ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
  /** Peripheral FLEXCOMM7 base pointer */
  #define FLEXCOMM7_NS                             ((FLEXCOMM_Type *)FLEXCOMM7_BASE_NS)
  /** Peripheral FLEXCOMM8 base address */
  #define FLEXCOMM8_BASE                           (0x50209000u)
  /** Peripheral FLEXCOMM8 base address */
  #define FLEXCOMM8_BASE_NS                        (0x40209000u)
  /** Peripheral FLEXCOMM8 base pointer */
  #define FLEXCOMM8                                ((FLEXCOMM_Type *)FLEXCOMM8_BASE)
  /** Peripheral FLEXCOMM8 base pointer */
  #define FLEXCOMM8_NS                             ((FLEXCOMM_Type *)FLEXCOMM8_BASE_NS)
  /** Peripheral FLEXCOMM9 base address */
  #define FLEXCOMM9_BASE                           (0x5020A000u)
  /** Peripheral FLEXCOMM9 base address */
  #define FLEXCOMM9_BASE_NS                        (0x4020A000u)
  /** Peripheral FLEXCOMM9 base pointer */
  #define FLEXCOMM9                                ((FLEXCOMM_Type *)FLEXCOMM9_BASE)
  /** Peripheral FLEXCOMM9 base pointer */
  #define FLEXCOMM9_NS                             ((FLEXCOMM_Type *)FLEXCOMM9_BASE_NS)
  /** Peripheral FLEXCOMM10 base address */
  #define FLEXCOMM10_BASE                          (0x5020B000u)
  /** Peripheral FLEXCOMM10 base address */
  #define FLEXCOMM10_BASE_NS                       (0x4020B000u)
  /** Peripheral FLEXCOMM10 base pointer */
  #define FLEXCOMM10                               ((FLEXCOMM_Type *)FLEXCOMM10_BASE)
  /** Peripheral FLEXCOMM10 base pointer */
  #define FLEXCOMM10_NS                            ((FLEXCOMM_Type *)FLEXCOMM10_BASE_NS)
  /** Peripheral FLEXCOMM11 base address */
  #define FLEXCOMM11_BASE                          (0x5020C000u)
  /** Peripheral FLEXCOMM11 base address */
  #define FLEXCOMM11_BASE_NS                       (0x4020C000u)
  /** Peripheral FLEXCOMM11 base pointer */
  #define FLEXCOMM11                               ((FLEXCOMM_Type *)FLEXCOMM11_BASE)
  /** Peripheral FLEXCOMM11 base pointer */
  #define FLEXCOMM11_NS                            ((FLEXCOMM_Type *)FLEXCOMM11_BASE_NS)
  /** Peripheral FLEXCOMM12 base address */
  #define FLEXCOMM12_BASE                          (0x5020D000u)
  /** Peripheral FLEXCOMM12 base address */
  #define FLEXCOMM12_BASE_NS                       (0x4020D000u)
  /** Peripheral FLEXCOMM12 base pointer */
  #define FLEXCOMM12                               ((FLEXCOMM_Type *)FLEXCOMM12_BASE)
  /** Peripheral FLEXCOMM12 base pointer */
  #define FLEXCOMM12_NS                            ((FLEXCOMM_Type *)FLEXCOMM12_BASE_NS)
  /** Peripheral FLEXCOMM13 base address */
  #define FLEXCOMM13_BASE                          (0x5020E000u)
  /** Peripheral FLEXCOMM13 base address */
  #define FLEXCOMM13_BASE_NS                       (0x4020E000u)
  /** Peripheral FLEXCOMM13 base pointer */
  #define FLEXCOMM13                               ((FLEXCOMM_Type *)FLEXCOMM13_BASE)
  /** Peripheral FLEXCOMM13 base pointer */
  #define FLEXCOMM13_NS                            ((FLEXCOMM_Type *)FLEXCOMM13_BASE_NS)
  /** Peripheral FLEXCOMM14 base address */
  #define FLEXCOMM14_BASE                          (0x50126000u)
  /** Peripheral FLEXCOMM14 base address */
  #define FLEXCOMM14_BASE_NS                       (0x40126000u)
  /** Peripheral FLEXCOMM14 base pointer */
  #define FLEXCOMM14                               ((FLEXCOMM_Type *)FLEXCOMM14_BASE)
  /** Peripheral FLEXCOMM14 base pointer */
  #define FLEXCOMM14_NS                            ((FLEXCOMM_Type *)FLEXCOMM14_BASE_NS)
  /** Peripheral FLEXCOMM15 base address */
  #define FLEXCOMM15_BASE                          (0x50127000u)
  /** Peripheral FLEXCOMM15 base address */
  #define FLEXCOMM15_BASE_NS                       (0x40127000u)
  /** Peripheral FLEXCOMM15 base pointer */
  #define FLEXCOMM15                               ((FLEXCOMM_Type *)FLEXCOMM15_BASE)
  /** Peripheral FLEXCOMM15 base pointer */
  #define FLEXCOMM15_NS                            ((FLEXCOMM_Type *)FLEXCOMM15_BASE_NS)
  /** Peripheral FLEXCOMM16 base address */
  #define FLEXCOMM16_BASE                          (0x50128000u)
  /** Peripheral FLEXCOMM16 base address */
  #define FLEXCOMM16_BASE_NS                       (0x40128000u)
  /** Peripheral FLEXCOMM16 base pointer */
  #define FLEXCOMM16                               ((FLEXCOMM_Type *)FLEXCOMM16_BASE)
  /** Peripheral FLEXCOMM16 base pointer */
  #define FLEXCOMM16_NS                            ((FLEXCOMM_Type *)FLEXCOMM16_BASE_NS)
  /** Array initializer of FLEXCOMM peripheral base addresses */
  #define FLEXCOMM_BASE_ADDRS                      { FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM8_BASE, FLEXCOMM9_BASE, FLEXCOMM10_BASE, FLEXCOMM11_BASE, FLEXCOMM12_BASE, FLEXCOMM13_BASE, FLEXCOMM14_BASE, FLEXCOMM15_BASE, FLEXCOMM16_BASE }
  /** Array initializer of FLEXCOMM peripheral base pointers */
  #define FLEXCOMM_BASE_PTRS                       { FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM8, FLEXCOMM9, FLEXCOMM10, FLEXCOMM11, FLEXCOMM12, FLEXCOMM13, FLEXCOMM14, FLEXCOMM15, FLEXCOMM16 }
  /** Array initializer of FLEXCOMM peripheral base addresses */
  #define FLEXCOMM_BASE_ADDRS_NS                   { FLEXCOMM0_BASE_NS, FLEXCOMM1_BASE_NS, FLEXCOMM2_BASE_NS, FLEXCOMM3_BASE_NS, FLEXCOMM4_BASE_NS, FLEXCOMM5_BASE_NS, FLEXCOMM6_BASE_NS, FLEXCOMM7_BASE_NS, FLEXCOMM8_BASE_NS, FLEXCOMM9_BASE_NS, FLEXCOMM10_BASE_NS, FLEXCOMM11_BASE_NS, FLEXCOMM12_BASE_NS, FLEXCOMM13_BASE_NS, FLEXCOMM14_BASE_NS, FLEXCOMM15_BASE_NS, FLEXCOMM16_BASE_NS }
  /** Array initializer of FLEXCOMM peripheral base pointers */
  #define FLEXCOMM_BASE_PTRS_NS                    { FLEXCOMM0_NS, FLEXCOMM1_NS, FLEXCOMM2_NS, FLEXCOMM3_NS, FLEXCOMM4_NS, FLEXCOMM5_NS, FLEXCOMM6_NS, FLEXCOMM7_NS, FLEXCOMM8_NS, FLEXCOMM9_NS, FLEXCOMM10_NS, FLEXCOMM11_NS, FLEXCOMM12_NS, FLEXCOMM13_NS, FLEXCOMM14_NS, FLEXCOMM15_NS, FLEXCOMM16_NS }
#else
  /** Peripheral FLEXCOMM0 base address */
  #define FLEXCOMM0_BASE                           (0x40106000u)
  /** Peripheral FLEXCOMM0 base pointer */
  #define FLEXCOMM0                                ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
  /** Peripheral FLEXCOMM1 base address */
  #define FLEXCOMM1_BASE                           (0x40107000u)
  /** Peripheral FLEXCOMM1 base pointer */
  #define FLEXCOMM1                                ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
  /** Peripheral FLEXCOMM2 base address */
  #define FLEXCOMM2_BASE                           (0x40108000u)
  /** Peripheral FLEXCOMM2 base pointer */
  #define FLEXCOMM2                                ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
  /** Peripheral FLEXCOMM3 base address */
  #define FLEXCOMM3_BASE                           (0x40109000u)
  /** Peripheral FLEXCOMM3 base pointer */
  #define FLEXCOMM3                                ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
  /** Peripheral FLEXCOMM4 base address */
  #define FLEXCOMM4_BASE                           (0x40122000u)
  /** Peripheral FLEXCOMM4 base pointer */
  #define FLEXCOMM4                                ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
  /** Peripheral FLEXCOMM5 base address */
  #define FLEXCOMM5_BASE                           (0x40123000u)
  /** Peripheral FLEXCOMM5 base pointer */
  #define FLEXCOMM5                                ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
  /** Peripheral FLEXCOMM6 base address */
  #define FLEXCOMM6_BASE                           (0x40124000u)
  /** Peripheral FLEXCOMM6 base pointer */
  #define FLEXCOMM6                                ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
  /** Peripheral FLEXCOMM7 base address */
  #define FLEXCOMM7_BASE                           (0x40125000u)
  /** Peripheral FLEXCOMM7 base pointer */
  #define FLEXCOMM7                                ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
  /** Peripheral FLEXCOMM8 base address */
  #define FLEXCOMM8_BASE                           (0x40209000u)
  /** Peripheral FLEXCOMM8 base pointer */
  #define FLEXCOMM8                                ((FLEXCOMM_Type *)FLEXCOMM8_BASE)
  /** Peripheral FLEXCOMM9 base address */
  #define FLEXCOMM9_BASE                           (0x4020A000u)
  /** Peripheral FLEXCOMM9 base pointer */
  #define FLEXCOMM9                                ((FLEXCOMM_Type *)FLEXCOMM9_BASE)
  /** Peripheral FLEXCOMM10 base address */
  #define FLEXCOMM10_BASE                          (0x4020B000u)
  /** Peripheral FLEXCOMM10 base pointer */
  #define FLEXCOMM10                               ((FLEXCOMM_Type *)FLEXCOMM10_BASE)
  /** Peripheral FLEXCOMM11 base address */
  #define FLEXCOMM11_BASE                          (0x4020C000u)
  /** Peripheral FLEXCOMM11 base pointer */
  #define FLEXCOMM11                               ((FLEXCOMM_Type *)FLEXCOMM11_BASE)
  /** Peripheral FLEXCOMM12 base address */
  #define FLEXCOMM12_BASE                          (0x4020D000u)
  /** Peripheral FLEXCOMM12 base pointer */
  #define FLEXCOMM12                               ((FLEXCOMM_Type *)FLEXCOMM12_BASE)
  /** Peripheral FLEXCOMM13 base address */
  #define FLEXCOMM13_BASE                          (0x4020E000u)
  /** Peripheral FLEXCOMM13 base pointer */
  #define FLEXCOMM13                               ((FLEXCOMM_Type *)FLEXCOMM13_BASE)
  /** Peripheral FLEXCOMM14 base address */
  #define FLEXCOMM14_BASE                          (0x40126000u)
  /** Peripheral FLEXCOMM14 base pointer */
  #define FLEXCOMM14                               ((FLEXCOMM_Type *)FLEXCOMM14_BASE)
  /** Peripheral FLEXCOMM15 base address */
  #define FLEXCOMM15_BASE                          (0x40127000u)
  /** Peripheral FLEXCOMM15 base pointer */
  #define FLEXCOMM15                               ((FLEXCOMM_Type *)FLEXCOMM15_BASE)
  /** Peripheral FLEXCOMM16 base address */
  #define FLEXCOMM16_BASE                          (0x40128000u)
  /** Peripheral FLEXCOMM16 base pointer */
  #define FLEXCOMM16                               ((FLEXCOMM_Type *)FLEXCOMM16_BASE)
  /** Array initializer of FLEXCOMM peripheral base addresses */
  #define FLEXCOMM_BASE_ADDRS                      { FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM8_BASE, FLEXCOMM9_BASE, FLEXCOMM10_BASE, FLEXCOMM11_BASE, FLEXCOMM12_BASE, FLEXCOMM13_BASE, FLEXCOMM14_BASE, FLEXCOMM15_BASE, FLEXCOMM16_BASE }
  /** Array initializer of FLEXCOMM peripheral base pointers */
  #define FLEXCOMM_BASE_PTRS                       { FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM8, FLEXCOMM9, FLEXCOMM10, FLEXCOMM11, FLEXCOMM12, FLEXCOMM13, FLEXCOMM14, FLEXCOMM15, FLEXCOMM16 }
#endif
/** Interrupt vectors for the FLEXCOMM peripheral type */
#define FLEXCOMM_IRQS                            { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, FLEXCOMM8_IRQn, FLEXCOMM9_IRQn, FLEXCOMM10_IRQn, FLEXCOMM11_IRQn, FLEXCOMM12_IRQn, FLEXCOMM13_IRQn, FLEXCOMM14_IRQn, FLEXCOMM15_IRQn, FLEXCOMM16_IRQn }

/*!
 * @}
 */ /* end of group FLEXCOMM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Peripheral_Access_Layer FLEXIO Peripheral Access Layer
 * @{
 */

/** FLEXIO - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< FlexIO Control Register, offset: 0x8 */
  __I  uint32_t PIN;                               /**< Pin State Register, offset: 0xC */
  __IO uint32_t SHIFTSTAT;                         /**< Shifter Status Register, offset: 0x10 */
  __IO uint32_t SHIFTERR;                          /**< Shifter Error Register, offset: 0x14 */
  __IO uint32_t TIMSTAT;                           /**< Timer Status Register, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t SHIFTSIEN;                         /**< Shifter Status Interrupt Enable, offset: 0x20 */
  __IO uint32_t SHIFTEIEN;                         /**< Shifter Error Interrupt Enable, offset: 0x24 */
  __IO uint32_t TIMIEN;                            /**< Timer Interrupt Enable Register, offset: 0x28 */
       uint8_t RESERVED_1[4];
  __IO uint32_t SHIFTSDEN;                         /**< Shifter Status DMA Enable, offset: 0x30 */
       uint8_t RESERVED_2[4];
  __IO uint32_t TIMERSDEN;                         /**< Timer Status DMA Enable, offset: 0x38 */
       uint8_t RESERVED_3[4];
  __IO uint32_t SHIFTSTATE;                        /**< Shifter State Register, offset: 0x40 */
       uint8_t RESERVED_4[4];
  __IO uint32_t TRGSTAT;                           /**< Trigger Status Register, offset: 0x48 */
  __IO uint32_t TRIGIEN;                           /**< External Trigger Interrupt Enable Register, offset: 0x4C */
  __IO uint32_t PINSTAT;                           /**< Pin Status Register, offset: 0x50 */
  __IO uint32_t PINIEN;                            /**< Pin Interrupt Enable Register, offset: 0x54 */
  __IO uint32_t PINREN;                            /**< Pin Rising Edge Enable Register, offset: 0x58 */
  __IO uint32_t PINFEN;                            /**< Pin Falling Edge Enable Register, offset: 0x5C */
  __IO uint32_t PINOUTD;                           /**< Pin Output Data Register, offset: 0x60 */
  __IO uint32_t PINOUTE;                           /**< Pin Output Enable Register, offset: 0x64 */
  __O  uint32_t PINOUTDIS;                         /**< Pin Output Disable Register, offset: 0x68 */
  __O  uint32_t PINOUTCLR;                         /**< Pin Output Clear Register, offset: 0x6C */
  __O  uint32_t PINOUTSET;                         /**< Pin Output Set Register, offset: 0x70 */
  __O  uint32_t PINOUTTOG;                         /**< Pin Output Toggle Register, offset: 0x74 */
       uint8_t RESERVED_5[8];
  __IO uint32_t SHIFTCTL[8];                       /**< Shifter Control N Register, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_6[96];
  __IO uint32_t SHIFTCFG[8];                       /**< Shifter Configuration N Register, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_7[224];
  __IO uint32_t SHIFTBUF[8];                       /**< Shifter Buffer N Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_8[96];
  __IO uint32_t SHIFTBUFBIS[8];                    /**< Shifter Buffer N Bit Swapped Register, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_9[96];
  __IO uint32_t SHIFTBUFBYS[8];                    /**< Shifter Buffer N Byte Swapped Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_10[96];
  __IO uint32_t SHIFTBUFBBS[8];                    /**< Shifter Buffer N Bit Byte Swapped Register, array offset: 0x380, array step: 0x4 */
       uint8_t RESERVED_11[96];
  __IO uint32_t TIMCTL[8];                         /**< Timer Control N Register, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_12[96];
  __IO uint32_t TIMCFG[8];                         /**< Timer Configuration N Register, array offset: 0x480, array step: 0x4 */
       uint8_t RESERVED_13[96];
  __IO uint32_t TIMCMP[8];                         /**< Timer Compare N Register, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_14[352];
  __IO uint32_t SHIFTBUFNBS[8];                    /**< Shifter Buffer N Nibble Byte Swapped Register, array offset: 0x680, array step: 0x4 */
       uint8_t RESERVED_15[96];
  __IO uint32_t SHIFTBUFHWS[8];                    /**< Shifter Buffer N Half Word Swapped Register, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_16[96];
  __IO uint32_t SHIFTBUFNIS[8];                    /**< Shifter Buffer N Nibble Swapped Register, array offset: 0x780, array step: 0x4 */
       uint8_t RESERVED_17[96];
  __IO uint32_t SHIFTBUFOES[8];                    /**< Shifter Buffer N Odd Even Swapped Register, array offset: 0x800, array step: 0x4 */
       uint8_t RESERVED_18[96];
  __IO uint32_t SHIFTBUFEOS[8];                    /**< Shifter Buffer N Even Odd Swapped Register, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_19[96];
  __IO uint32_t SHIFTBUFHBS[8];                    /**< Shifter Buffer N Halfword Byte Swapped Register, array offset: 0x900, array step: 0x4 */
} FLEXIO_Type;

/* ----------------------------------------------------------------------------
   -- FLEXIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Register_Masks FLEXIO Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */
#define FLEXIO_VERID_FEATURE_MASK                (0xFFFFU)
#define FLEXIO_VERID_FEATURE_SHIFT               (0U)
/*! FEATURE - Feature Specification Number
 *  0b0000000000000000..Standard features implemented.
 *  0b0000000000000001..Supports state, logic and parallel modes.
 *  0b0000000000000010..Supports pin control registers.
 *  0b0000000000000011..Supports state, logic and parallel modes; plus pin control registers.
 */
#define FLEXIO_VERID_FEATURE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_FEATURE_SHIFT)) & FLEXIO_VERID_FEATURE_MASK)
#define FLEXIO_VERID_MINOR_MASK                  (0xFF0000U)
#define FLEXIO_VERID_MINOR_SHIFT                 (16U)
/*! MINOR - Minor Version Number
 */
#define FLEXIO_VERID_MINOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MINOR_SHIFT)) & FLEXIO_VERID_MINOR_MASK)
#define FLEXIO_VERID_MAJOR_MASK                  (0xFF000000U)
#define FLEXIO_VERID_MAJOR_SHIFT                 (24U)
/*! MAJOR - Major Version Number
 */
#define FLEXIO_VERID_MAJOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MAJOR_SHIFT)) & FLEXIO_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */
#define FLEXIO_PARAM_SHIFTER_MASK                (0xFFU)
#define FLEXIO_PARAM_SHIFTER_SHIFT               (0U)
/*! SHIFTER - Shifter Number
 */
#define FLEXIO_PARAM_SHIFTER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_SHIFTER_SHIFT)) & FLEXIO_PARAM_SHIFTER_MASK)
#define FLEXIO_PARAM_TIMER_MASK                  (0xFF00U)
#define FLEXIO_PARAM_TIMER_SHIFT                 (8U)
/*! TIMER - Timer Number
 */
#define FLEXIO_PARAM_TIMER(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TIMER_SHIFT)) & FLEXIO_PARAM_TIMER_MASK)
#define FLEXIO_PARAM_PIN_MASK                    (0xFF0000U)
#define FLEXIO_PARAM_PIN_SHIFT                   (16U)
/*! PIN - Pin Number
 */
#define FLEXIO_PARAM_PIN(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_PIN_SHIFT)) & FLEXIO_PARAM_PIN_MASK)
#define FLEXIO_PARAM_TRIGGER_MASK                (0xFF000000U)
#define FLEXIO_PARAM_TRIGGER_SHIFT               (24U)
/*! TRIGGER - Trigger Number
 */
#define FLEXIO_PARAM_TRIGGER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TRIGGER_SHIFT)) & FLEXIO_PARAM_TRIGGER_MASK)
/*! @} */

/*! @name CTRL - FlexIO Control Register */
/*! @{ */
#define FLEXIO_CTRL_FLEXEN_MASK                  (0x1U)
#define FLEXIO_CTRL_FLEXEN_SHIFT                 (0U)
/*! FLEXEN - FlexIO Enable
 *  0b0..FlexIO module is disabled.
 *  0b1..FlexIO module is enabled.
 */
#define FLEXIO_CTRL_FLEXEN(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FLEXEN_SHIFT)) & FLEXIO_CTRL_FLEXEN_MASK)
#define FLEXIO_CTRL_SWRST_MASK                   (0x2U)
#define FLEXIO_CTRL_SWRST_SHIFT                  (1U)
/*! SWRST - Software Reset
 *  0b0..Software reset is disabled
 *  0b1..Software reset is enabled, all FlexIO registers except the Control Register are reset.
 */
#define FLEXIO_CTRL_SWRST(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_SWRST_SHIFT)) & FLEXIO_CTRL_SWRST_MASK)
#define FLEXIO_CTRL_FASTACC_MASK                 (0x4U)
#define FLEXIO_CTRL_FASTACC_SHIFT                (2U)
/*! FASTACC - Fast Access
 *  0b0..Configures for normal register accesses to FlexIO
 *  0b1..Configures for fast register accesses to FlexIO
 */
#define FLEXIO_CTRL_FASTACC(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FASTACC_SHIFT)) & FLEXIO_CTRL_FASTACC_MASK)
#define FLEXIO_CTRL_DBGE_MASK                    (0x40000000U)
#define FLEXIO_CTRL_DBGE_SHIFT                   (30U)
/*! DBGE - Debug Enable
 *  0b0..FlexIO is disabled in debug modes.
 *  0b1..FlexIO is enabled in debug modes
 */
#define FLEXIO_CTRL_DBGE(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DBGE_SHIFT)) & FLEXIO_CTRL_DBGE_MASK)
#define FLEXIO_CTRL_DOZEN_MASK                   (0x80000000U)
#define FLEXIO_CTRL_DOZEN_SHIFT                  (31U)
/*! DOZEN - Doze Enable
 *  0b0..FlexIO enabled in Doze modes.
 *  0b1..FlexIO disabled in Doze modes.
 */
#define FLEXIO_CTRL_DOZEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DOZEN_SHIFT)) & FLEXIO_CTRL_DOZEN_MASK)
/*! @} */

/*! @name PIN - Pin State Register */
/*! @{ */
#define FLEXIO_PIN_PDI_MASK                      (0xFFFFU)
#define FLEXIO_PIN_PDI_SHIFT                     (0U)
/*! PDI - Pin Data Input
 */
#define FLEXIO_PIN_PDI(x)                        (((uint32_t)(((uint32_t)(x)) << FLEXIO_PIN_PDI_SHIFT)) & FLEXIO_PIN_PDI_MASK)
/*! @} */

/*! @name SHIFTSTAT - Shifter Status Register */
/*! @{ */
#define FLEXIO_SHIFTSTAT_SSF_MASK                (0xFFU)
#define FLEXIO_SHIFTSTAT_SSF_SHIFT               (0U)
/*! SSF - Shifter Status Flag
 */
#define FLEXIO_SHIFTSTAT_SSF(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTAT_SSF_SHIFT)) & FLEXIO_SHIFTSTAT_SSF_MASK)
/*! @} */

/*! @name SHIFTERR - Shifter Error Register */
/*! @{ */
#define FLEXIO_SHIFTERR_SEF_MASK                 (0xFFU)
#define FLEXIO_SHIFTERR_SEF_SHIFT                (0U)
/*! SEF - Shifter Error Flags
 */
#define FLEXIO_SHIFTERR_SEF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTERR_SEF_SHIFT)) & FLEXIO_SHIFTERR_SEF_MASK)
/*! @} */

/*! @name TIMSTAT - Timer Status Register */
/*! @{ */
#define FLEXIO_TIMSTAT_TSF_MASK                  (0xFFU)
#define FLEXIO_TIMSTAT_TSF_SHIFT                 (0U)
/*! TSF - Timer Status Flags
 */
#define FLEXIO_TIMSTAT_TSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMSTAT_TSF_SHIFT)) & FLEXIO_TIMSTAT_TSF_MASK)
/*! @} */

/*! @name SHIFTSIEN - Shifter Status Interrupt Enable */
/*! @{ */
#define FLEXIO_SHIFTSIEN_SSIE_MASK               (0xFFU)
#define FLEXIO_SHIFTSIEN_SSIE_SHIFT              (0U)
/*! SSIE - Shifter Status Interrupt Enable
 */
#define FLEXIO_SHIFTSIEN_SSIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSIEN_SSIE_SHIFT)) & FLEXIO_SHIFTSIEN_SSIE_MASK)
/*! @} */

/*! @name SHIFTEIEN - Shifter Error Interrupt Enable */
/*! @{ */
#define FLEXIO_SHIFTEIEN_SEIE_MASK               (0xFFU)
#define FLEXIO_SHIFTEIEN_SEIE_SHIFT              (0U)
/*! SEIE - Shifter Error Interrupt Enable
 */
#define FLEXIO_SHIFTEIEN_SEIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTEIEN_SEIE_SHIFT)) & FLEXIO_SHIFTEIEN_SEIE_MASK)
/*! @} */

/*! @name TIMIEN - Timer Interrupt Enable Register */
/*! @{ */
#define FLEXIO_TIMIEN_TEIE_MASK                  (0xFFU)
#define FLEXIO_TIMIEN_TEIE_SHIFT                 (0U)
/*! TEIE - Timer Status Interrupt Enable
 */
#define FLEXIO_TIMIEN_TEIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMIEN_TEIE_SHIFT)) & FLEXIO_TIMIEN_TEIE_MASK)
/*! @} */

/*! @name SHIFTSDEN - Shifter Status DMA Enable */
/*! @{ */
#define FLEXIO_SHIFTSDEN_SSDE_MASK               (0xFFU)
#define FLEXIO_SHIFTSDEN_SSDE_SHIFT              (0U)
/*! SSDE - Shifter Status DMA Enable
 */
#define FLEXIO_SHIFTSDEN_SSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSDEN_SSDE_SHIFT)) & FLEXIO_SHIFTSDEN_SSDE_MASK)
/*! @} */

/*! @name TIMERSDEN - Timer Status DMA Enable */
/*! @{ */
#define FLEXIO_TIMERSDEN_TSDE_MASK               (0xFFU)
#define FLEXIO_TIMERSDEN_TSDE_SHIFT              (0U)
/*! TSDE - Timer Status DMA Enable
 */
#define FLEXIO_TIMERSDEN_TSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMERSDEN_TSDE_SHIFT)) & FLEXIO_TIMERSDEN_TSDE_MASK)
/*! @} */

/*! @name SHIFTSTATE - Shifter State Register */
/*! @{ */
#define FLEXIO_SHIFTSTATE_STATE_MASK             (0x7U)
#define FLEXIO_SHIFTSTATE_STATE_SHIFT            (0U)
/*! STATE - Current State Pointer
 */
#define FLEXIO_SHIFTSTATE_STATE(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTATE_STATE_SHIFT)) & FLEXIO_SHIFTSTATE_STATE_MASK)
/*! @} */

/*! @name TRGSTAT - Trigger Status Register */
/*! @{ */
#define FLEXIO_TRGSTAT_ETSF_MASK                 (0xFFFFU)
#define FLEXIO_TRGSTAT_ETSF_SHIFT                (0U)
/*! ETSF - External Trigger Status Flags
 */
#define FLEXIO_TRGSTAT_ETSF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRGSTAT_ETSF_SHIFT)) & FLEXIO_TRGSTAT_ETSF_MASK)
/*! @} */

/*! @name TRIGIEN - External Trigger Interrupt Enable Register */
/*! @{ */
#define FLEXIO_TRIGIEN_TRIE_MASK                 (0xFFFFU)
#define FLEXIO_TRIGIEN_TRIE_SHIFT                (0U)
/*! TRIE - External Trigger Interrupt Enable
 */
#define FLEXIO_TRIGIEN_TRIE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRIGIEN_TRIE_SHIFT)) & FLEXIO_TRIGIEN_TRIE_MASK)
/*! @} */

/*! @name PINSTAT - Pin Status Register */
/*! @{ */
#define FLEXIO_PINSTAT_PSF_MASK                  (0xFFFFU)
#define FLEXIO_PINSTAT_PSF_SHIFT                 (0U)
/*! PSF - Pin Status Flags
 */
#define FLEXIO_PINSTAT_PSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINSTAT_PSF_SHIFT)) & FLEXIO_PINSTAT_PSF_MASK)
/*! @} */

/*! @name PINIEN - Pin Interrupt Enable Register */
/*! @{ */
#define FLEXIO_PINIEN_PSIE_MASK                  (0xFFFFU)
#define FLEXIO_PINIEN_PSIE_SHIFT                 (0U)
/*! PSIE - Pin Status Interrupt Enable
 */
#define FLEXIO_PINIEN_PSIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINIEN_PSIE_SHIFT)) & FLEXIO_PINIEN_PSIE_MASK)
/*! @} */

/*! @name PINREN - Pin Rising Edge Enable Register */
/*! @{ */
#define FLEXIO_PINREN_PRE_MASK                   (0xFFFFU)
#define FLEXIO_PINREN_PRE_SHIFT                  (0U)
/*! PRE - Pin Rising Edge
 */
#define FLEXIO_PINREN_PRE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINREN_PRE_SHIFT)) & FLEXIO_PINREN_PRE_MASK)
/*! @} */

/*! @name PINFEN - Pin Falling Edge Enable Register */
/*! @{ */
#define FLEXIO_PINFEN_PFE_MASK                   (0xFFFFU)
#define FLEXIO_PINFEN_PFE_SHIFT                  (0U)
/*! PFE - Pin Falling Edge
 */
#define FLEXIO_PINFEN_PFE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINFEN_PFE_SHIFT)) & FLEXIO_PINFEN_PFE_MASK)
/*! @} */

/*! @name PINOUTD - Pin Output Data Register */
/*! @{ */
#define FLEXIO_PINOUTD_OUTD_MASK                 (0xFFFFU)
#define FLEXIO_PINOUTD_OUTD_SHIFT                (0U)
/*! OUTD - Output Data
 */
#define FLEXIO_PINOUTD_OUTD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTD_OUTD_SHIFT)) & FLEXIO_PINOUTD_OUTD_MASK)
/*! @} */

/*! @name PINOUTE - Pin Output Enable Register */
/*! @{ */
#define FLEXIO_PINOUTE_OUTE_MASK                 (0xFFFFU)
#define FLEXIO_PINOUTE_OUTE_SHIFT                (0U)
/*! OUTE - Output Enable
 */
#define FLEXIO_PINOUTE_OUTE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTE_OUTE_SHIFT)) & FLEXIO_PINOUTE_OUTE_MASK)
/*! @} */

/*! @name PINOUTDIS - Pin Output Disable Register */
/*! @{ */
#define FLEXIO_PINOUTDIS_OUTDIS_MASK             (0xFFFFU)
#define FLEXIO_PINOUTDIS_OUTDIS_SHIFT            (0U)
/*! OUTDIS - Output Disable
 */
#define FLEXIO_PINOUTDIS_OUTDIS(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTDIS_OUTDIS_SHIFT)) & FLEXIO_PINOUTDIS_OUTDIS_MASK)
/*! @} */

/*! @name PINOUTCLR - Pin Output Clear Register */
/*! @{ */
#define FLEXIO_PINOUTCLR_OUTCLR_MASK             (0xFFFFU)
#define FLEXIO_PINOUTCLR_OUTCLR_SHIFT            (0U)
/*! OUTCLR - Output Clear
 */
#define FLEXIO_PINOUTCLR_OUTCLR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTCLR_OUTCLR_SHIFT)) & FLEXIO_PINOUTCLR_OUTCLR_MASK)
/*! @} */

/*! @name PINOUTSET - Pin Output Set Register */
/*! @{ */
#define FLEXIO_PINOUTSET_OUTSET_MASK             (0xFFFFU)
#define FLEXIO_PINOUTSET_OUTSET_SHIFT            (0U)
/*! OUTSET - Output Set
 */
#define FLEXIO_PINOUTSET_OUTSET(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTSET_OUTSET_SHIFT)) & FLEXIO_PINOUTSET_OUTSET_MASK)
/*! @} */

/*! @name PINOUTTOG - Pin Output Toggle Register */
/*! @{ */
#define FLEXIO_PINOUTTOG_OUTTOG_MASK             (0xFFFFU)
#define FLEXIO_PINOUTTOG_OUTTOG_SHIFT            (0U)
/*! OUTTOG - Output Toggle
 */
#define FLEXIO_PINOUTTOG_OUTTOG(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTTOG_OUTTOG_SHIFT)) & FLEXIO_PINOUTTOG_OUTTOG_MASK)
/*! @} */

/*! @name SHIFTCTL - Shifter Control N Register */
/*! @{ */
#define FLEXIO_SHIFTCTL_SMOD_MASK                (0x7U)
#define FLEXIO_SHIFTCTL_SMOD_SHIFT               (0U)
/*! SMOD - Shifter Mode
 *  0b000..Disabled.
 *  0b001..Receive mode. Captures the current Shifter content into the SHIFTBUF on expiration of the Timer.
 *  0b010..Transmit mode. Load SHIFTBUF contents into the Shifter on expiration of the Timer.
 *  0b011..Reserved.
 *  0b100..Match Store mode. Shifter data is compared to SHIFTBUF content on expiration of the Timer.
 *  0b101..Match Continuous mode. Shifter data is continuously compared to SHIFTBUF contents.
 *  0b110..State mode. SHIFTBUF contents are used for storing programmable state attributes.
 *  0b111..Logic mode. SHIFTBUF contents are used for implementing programmable logic look up table.
 */
#define FLEXIO_SHIFTCTL_SMOD(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_SMOD_SHIFT)) & FLEXIO_SHIFTCTL_SMOD_MASK)
#define FLEXIO_SHIFTCTL_PINPOL_MASK              (0x80U)
#define FLEXIO_SHIFTCTL_PINPOL_SHIFT             (7U)
/*! PINPOL - Shifter Pin Polarity
 *  0b0..Pin is active high
 *  0b1..Pin is active low
 */
#define FLEXIO_SHIFTCTL_PINPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINPOL_SHIFT)) & FLEXIO_SHIFTCTL_PINPOL_MASK)
#define FLEXIO_SHIFTCTL_PINSEL_MASK              (0xF00U)
#define FLEXIO_SHIFTCTL_PINSEL_SHIFT             (8U)
/*! PINSEL - Shifter Pin Select
 */
#define FLEXIO_SHIFTCTL_PINSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINSEL_SHIFT)) & FLEXIO_SHIFTCTL_PINSEL_MASK)
#define FLEXIO_SHIFTCTL_PINCFG_MASK              (0x30000U)
#define FLEXIO_SHIFTCTL_PINCFG_SHIFT             (16U)
/*! PINCFG - Shifter Pin Configuration
 *  0b00..Shifter pin output disabled
 *  0b01..Shifter pin open drain or bidirectional output enable
 *  0b10..Shifter pin bidirectional output data
 *  0b11..Shifter pin output
 */
#define FLEXIO_SHIFTCTL_PINCFG(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINCFG_SHIFT)) & FLEXIO_SHIFTCTL_PINCFG_MASK)
#define FLEXIO_SHIFTCTL_TIMPOL_MASK              (0x800000U)
#define FLEXIO_SHIFTCTL_TIMPOL_SHIFT             (23U)
/*! TIMPOL - Timer Polarity
 *  0b0..Shift on posedge of Shift clock
 *  0b1..Shift on negedge of Shift clock
 */
#define FLEXIO_SHIFTCTL_TIMPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMPOL_SHIFT)) & FLEXIO_SHIFTCTL_TIMPOL_MASK)
#define FLEXIO_SHIFTCTL_TIMSEL_MASK              (0x7000000U)
#define FLEXIO_SHIFTCTL_TIMSEL_SHIFT             (24U)
/*! TIMSEL - Timer Select
 */
#define FLEXIO_SHIFTCTL_TIMSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMSEL_SHIFT)) & FLEXIO_SHIFTCTL_TIMSEL_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCTL */
#define FLEXIO_SHIFTCTL_COUNT                    (8U)

/*! @name SHIFTCFG - Shifter Configuration N Register */
/*! @{ */
#define FLEXIO_SHIFTCFG_SSTART_MASK              (0x3U)
#define FLEXIO_SHIFTCFG_SSTART_SHIFT             (0U)
/*! SSTART - Shifter Start bit
 *  0b00..Start bit disabled for transmitter/receiver/match store, transmitter loads data on enable
 *  0b01..Start bit disabled for transmitter/receiver/match store, transmitter loads data on first shift
 *  0b10..Transmitter outputs start bit value 0 before loading data on first shift, receiver/match store sets error flag if start bit is not 0
 *  0b11..Transmitter outputs start bit value 1 before loading data on first shift, receiver/match store sets error flag if start bit is not 1
 */
#define FLEXIO_SHIFTCFG_SSTART(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTART_SHIFT)) & FLEXIO_SHIFTCFG_SSTART_MASK)
#define FLEXIO_SHIFTCFG_SSTOP_MASK               (0x30U)
#define FLEXIO_SHIFTCFG_SSTOP_SHIFT              (4U)
/*! SSTOP - Shifter Stop bit
 *  0b00..Stop bit disabled for transmitter/receiver/match store
 *  0b01..Reserved for transmitter/receiver/match store
 *  0b10..Transmitter outputs stop bit value 0 on store, receiver/match store sets error flag if stop bit is not 0
 *  0b11..Transmitter outputs stop bit value 1 on store, receiver/match store sets error flag if stop bit is not 1
 */
#define FLEXIO_SHIFTCFG_SSTOP(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTOP_SHIFT)) & FLEXIO_SHIFTCFG_SSTOP_MASK)
#define FLEXIO_SHIFTCFG_INSRC_MASK               (0x100U)
#define FLEXIO_SHIFTCFG_INSRC_SHIFT              (8U)
/*! INSRC - Input Source
 *  0b0..Pin
 *  0b1..Shifter N+1 Output
 */
#define FLEXIO_SHIFTCFG_INSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_INSRC_SHIFT)) & FLEXIO_SHIFTCFG_INSRC_MASK)
#define FLEXIO_SHIFTCFG_LATST_MASK               (0x200U)
#define FLEXIO_SHIFTCFG_LATST_SHIFT              (9U)
/*! LATST - Late Store
 *  0b0..Shift register stores the pre-shift register state.
 *  0b1..Shift register stores the post-shift register state.
 */
#define FLEXIO_SHIFTCFG_LATST(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_LATST_SHIFT)) & FLEXIO_SHIFTCFG_LATST_MASK)
#define FLEXIO_SHIFTCFG_SSIZE_MASK               (0x1000U)
#define FLEXIO_SHIFTCFG_SSIZE_SHIFT              (12U)
/*! SSIZE - Shifter Size
 *  0b0..Shift register is 32-bit.
 *  0b1..Shift register is 24-bit.
 */
#define FLEXIO_SHIFTCFG_SSIZE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSIZE_SHIFT)) & FLEXIO_SHIFTCFG_SSIZE_MASK)
#define FLEXIO_SHIFTCFG_PWIDTH_MASK              (0xF0000U)
#define FLEXIO_SHIFTCFG_PWIDTH_SHIFT             (16U)
/*! PWIDTH - Parallel Width
 */
#define FLEXIO_SHIFTCFG_PWIDTH(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_PWIDTH_SHIFT)) & FLEXIO_SHIFTCFG_PWIDTH_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCFG */
#define FLEXIO_SHIFTCFG_COUNT                    (8U)

/*! @name SHIFTBUF - Shifter Buffer N Register */
/*! @{ */
#define FLEXIO_SHIFTBUF_SHIFTBUF_MASK            (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT           (0U)
/*! SHIFTBUF - Shift Buffer
 */
#define FLEXIO_SHIFTBUF_SHIFTBUF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT)) & FLEXIO_SHIFTBUF_SHIFTBUF_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUF */
#define FLEXIO_SHIFTBUF_COUNT                    (8U)

/*! @name SHIFTBUFBIS - Shifter Buffer N Bit Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT     (0U)
/*! SHIFTBUFBIS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT)) & FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBIS */
#define FLEXIO_SHIFTBUFBIS_COUNT                 (8U)

/*! @name SHIFTBUFBYS - Shifter Buffer N Byte Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT     (0U)
/*! SHIFTBUFBYS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT)) & FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBYS */
#define FLEXIO_SHIFTBUFBYS_COUNT                 (8U)

/*! @name SHIFTBUFBBS - Shifter Buffer N Bit Byte Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT     (0U)
/*! SHIFTBUFBBS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT)) & FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBBS */
#define FLEXIO_SHIFTBUFBBS_COUNT                 (8U)

/*! @name TIMCTL - Timer Control N Register */
/*! @{ */
#define FLEXIO_TIMCTL_TIMOD_MASK                 (0x7U)
#define FLEXIO_TIMCTL_TIMOD_SHIFT                (0U)
/*! TIMOD - Timer Mode
 *  0b000..Timer Disabled.
 *  0b001..Dual 8-bit counters baud mode.
 *  0b010..Dual 8-bit counters PWM high mode.
 *  0b011..Single 16-bit counter mode.
 *  0b100..Single 16-bit counter disable mode.
 *  0b101..Dual 8-bit counters word mode.
 *  0b110..Dual 8-bit counters PWM low mode.
 *  0b111..Single 16-bit input capture mode.
 */
#define FLEXIO_TIMCTL_TIMOD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TIMOD_SHIFT)) & FLEXIO_TIMCTL_TIMOD_MASK)
#define FLEXIO_TIMCTL_ONETIM_MASK                (0x20U)
#define FLEXIO_TIMCTL_ONETIM_SHIFT               (5U)
/*! ONETIM - Timer One Time Operation
 *  0b0..The timer enable event is generated as normal.
 *  0b1..The timer enable event is blocked unless timer status flag is clear.
 */
#define FLEXIO_TIMCTL_ONETIM(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_ONETIM_SHIFT)) & FLEXIO_TIMCTL_ONETIM_MASK)
#define FLEXIO_TIMCTL_PININS_MASK                (0x40U)
#define FLEXIO_TIMCTL_PININS_SHIFT               (6U)
/*! PININS - Timer Pin Input Select
 *  0b0..Timer pin input and output are selected by PINSEL.
 *  0b1..Timer pin input is selected by PINSEL+1, timer pin output remains selected by PINSEL.
 */
#define FLEXIO_TIMCTL_PININS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PININS_SHIFT)) & FLEXIO_TIMCTL_PININS_MASK)
#define FLEXIO_TIMCTL_PINPOL_MASK                (0x80U)
#define FLEXIO_TIMCTL_PINPOL_SHIFT               (7U)
/*! PINPOL - Timer Pin Polarity
 *  0b0..Pin is active high
 *  0b1..Pin is active low
 */
#define FLEXIO_TIMCTL_PINPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINPOL_SHIFT)) & FLEXIO_TIMCTL_PINPOL_MASK)
#define FLEXIO_TIMCTL_PINSEL_MASK                (0xF00U)
#define FLEXIO_TIMCTL_PINSEL_SHIFT               (8U)
/*! PINSEL - Timer Pin Select
 */
#define FLEXIO_TIMCTL_PINSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINSEL_SHIFT)) & FLEXIO_TIMCTL_PINSEL_MASK)
#define FLEXIO_TIMCTL_PINCFG_MASK                (0x30000U)
#define FLEXIO_TIMCTL_PINCFG_SHIFT               (16U)
/*! PINCFG - Timer Pin Configuration
 *  0b00..Timer pin output disabled
 *  0b01..Timer pin open drain or bidirectional output enable
 *  0b10..Timer pin bidirectional output data
 *  0b11..Timer pin output
 */
#define FLEXIO_TIMCTL_PINCFG(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINCFG_SHIFT)) & FLEXIO_TIMCTL_PINCFG_MASK)
#define FLEXIO_TIMCTL_TRGSRC_MASK                (0x400000U)
#define FLEXIO_TIMCTL_TRGSRC_SHIFT               (22U)
/*! TRGSRC - Trigger Source
 *  0b0..External trigger selected
 *  0b1..Internal trigger selected
 */
#define FLEXIO_TIMCTL_TRGSRC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSRC_SHIFT)) & FLEXIO_TIMCTL_TRGSRC_MASK)
#define FLEXIO_TIMCTL_TRGPOL_MASK                (0x800000U)
#define FLEXIO_TIMCTL_TRGPOL_SHIFT               (23U)
/*! TRGPOL - Trigger Polarity
 *  0b0..Trigger active high
 *  0b1..Trigger active low
 */
#define FLEXIO_TIMCTL_TRGPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGPOL_SHIFT)) & FLEXIO_TIMCTL_TRGPOL_MASK)
#define FLEXIO_TIMCTL_TRGSEL_MASK                (0x1F000000U)
#define FLEXIO_TIMCTL_TRGSEL_SHIFT               (24U)
/*! TRGSEL - Trigger Select
 */
#define FLEXIO_TIMCTL_TRGSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSEL_SHIFT)) & FLEXIO_TIMCTL_TRGSEL_MASK)
/*! @} */

/* The count of FLEXIO_TIMCTL */
#define FLEXIO_TIMCTL_COUNT                      (8U)

/*! @name TIMCFG - Timer Configuration N Register */
/*! @{ */
#define FLEXIO_TIMCFG_TSTART_MASK                (0x2U)
#define FLEXIO_TIMCFG_TSTART_SHIFT               (1U)
/*! TSTART - Timer Start Bit
 *  0b0..Start bit disabled
 *  0b1..Start bit enabled
 */
#define FLEXIO_TIMCFG_TSTART(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTART_SHIFT)) & FLEXIO_TIMCFG_TSTART_MASK)
#define FLEXIO_TIMCFG_TSTOP_MASK                 (0x30U)
#define FLEXIO_TIMCFG_TSTOP_SHIFT                (4U)
/*! TSTOP - Timer Stop Bit
 *  0b00..Stop bit disabled
 *  0b01..Stop bit is enabled on timer compare
 *  0b10..Stop bit is enabled on timer disable
 *  0b11..Stop bit is enabled on timer compare and timer disable
 */
#define FLEXIO_TIMCFG_TSTOP(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTOP_SHIFT)) & FLEXIO_TIMCFG_TSTOP_MASK)
#define FLEXIO_TIMCFG_TIMENA_MASK                (0x700U)
#define FLEXIO_TIMCFG_TIMENA_SHIFT               (8U)
/*! TIMENA - Timer Enable
 *  0b000..Timer always enabled
 *  0b001..Timer enabled on Timer N-1 enable
 *  0b010..Timer enabled on Trigger high
 *  0b011..Timer enabled on Trigger high and Pin high
 *  0b100..Timer enabled on Pin rising edge
 *  0b101..Timer enabled on Pin rising edge and Trigger high
 *  0b110..Timer enabled on Trigger rising edge
 *  0b111..Timer enabled on Trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMENA(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMENA_SHIFT)) & FLEXIO_TIMCFG_TIMENA_MASK)
#define FLEXIO_TIMCFG_TIMDIS_MASK                (0x7000U)
#define FLEXIO_TIMCFG_TIMDIS_SHIFT               (12U)
/*! TIMDIS - Timer Disable
 *  0b000..Timer never disabled
 *  0b001..Timer disabled on Timer N-1 disable
 *  0b010..Timer disabled on Timer compare (upper 8-bits match and decrement)
 *  0b011..Timer disabled on Timer compare (upper 8-bits match and decrement) and Trigger Low
 *  0b100..Timer disabled on Pin rising or falling edge
 *  0b101..Timer disabled on Pin rising or falling edge provided Trigger is high
 *  0b110..Timer disabled on Trigger falling edge
 *  0b111..Reserved
 */
#define FLEXIO_TIMCFG_TIMDIS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDIS_SHIFT)) & FLEXIO_TIMCFG_TIMDIS_MASK)
#define FLEXIO_TIMCFG_TIMRST_MASK                (0x70000U)
#define FLEXIO_TIMCFG_TIMRST_SHIFT               (16U)
/*! TIMRST - Timer Reset
 *  0b000..Timer never reset
 *  0b001..Timer reset on Timer Output high.
 *  0b010..Timer reset on Timer Pin equal to Timer Output
 *  0b011..Timer reset on Timer Trigger equal to Timer Output
 *  0b100..Timer reset on Timer Pin rising edge
 *  0b101..Reserved
 *  0b110..Timer reset on Trigger rising edge
 *  0b111..Timer reset on Trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMRST(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMRST_SHIFT)) & FLEXIO_TIMCFG_TIMRST_MASK)
#define FLEXIO_TIMCFG_TIMDEC_MASK                (0x700000U)
#define FLEXIO_TIMCFG_TIMDEC_SHIFT               (20U)
/*! TIMDEC - Timer Decrement
 *  0b000..Decrement counter on FlexIO clock, Shift clock equals Timer output.
 *  0b001..Decrement counter on Trigger input (both edges), Shift clock equals Timer output.
 *  0b010..Decrement counter on Pin input (both edges), Shift clock equals Pin input.
 *  0b011..Decrement counter on Trigger input (both edges), Shift clock equals Trigger input.
 *  0b100..Decrement counter on FlexIO clock divided by 16, Shift clock equals Timer output.
 *  0b101..Decrement counter on FlexIO clock divided by 256, Shift clock equals Timer output.
 *  0b110..Decrement counter on Pin input (rising edge), Shift clock equals Pin input.
 *  0b111..Decrement counter on Trigger input (rising edge), Shift clock equals Trigger input.
 */
#define FLEXIO_TIMCFG_TIMDEC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDEC_SHIFT)) & FLEXIO_TIMCFG_TIMDEC_MASK)
#define FLEXIO_TIMCFG_TIMOUT_MASK                (0x3000000U)
#define FLEXIO_TIMCFG_TIMOUT_SHIFT               (24U)
/*! TIMOUT - Timer Output
 *  0b00..Timer output is logic one when enabled and is not affected by timer reset
 *  0b01..Timer output is logic zero when enabled and is not affected by timer reset
 *  0b10..Timer output is logic one when enabled and on timer reset
 *  0b11..Timer output is logic zero when enabled and on timer reset
 */
#define FLEXIO_TIMCFG_TIMOUT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMOUT_SHIFT)) & FLEXIO_TIMCFG_TIMOUT_MASK)
/*! @} */

/* The count of FLEXIO_TIMCFG */
#define FLEXIO_TIMCFG_COUNT                      (8U)

/*! @name TIMCMP - Timer Compare N Register */
/*! @{ */
#define FLEXIO_TIMCMP_CMP_MASK                   (0xFFFFU)
#define FLEXIO_TIMCMP_CMP_SHIFT                  (0U)
/*! CMP - Timer Compare Value
 */
#define FLEXIO_TIMCMP_CMP(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCMP_CMP_SHIFT)) & FLEXIO_TIMCMP_CMP_MASK)
/*! @} */

/* The count of FLEXIO_TIMCMP */
#define FLEXIO_TIMCMP_COUNT                      (8U)

/*! @name SHIFTBUFNBS - Shifter Buffer N Nibble Byte Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT     (0U)
/*! SHIFTBUFNBS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT)) & FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNBS */
#define FLEXIO_SHIFTBUFNBS_COUNT                 (8U)

/*! @name SHIFTBUFHWS - Shifter Buffer N Half Word Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT     (0U)
/*! SHIFTBUFHWS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT)) & FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHWS */
#define FLEXIO_SHIFTBUFHWS_COUNT                 (8U)

/*! @name SHIFTBUFNIS - Shifter Buffer N Nibble Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT     (0U)
/*! SHIFTBUFNIS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT)) & FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNIS */
#define FLEXIO_SHIFTBUFNIS_COUNT                 (8U)

/*! @name SHIFTBUFOES - Shifter Buffer N Odd Even Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT     (0U)
/*! SHIFTBUFOES - Shift Buffer
 */
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT)) & FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFOES */
#define FLEXIO_SHIFTBUFOES_COUNT                 (8U)

/*! @name SHIFTBUFEOS - Shifter Buffer N Even Odd Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT     (0U)
/*! SHIFTBUFEOS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT)) & FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFEOS */
#define FLEXIO_SHIFTBUFEOS_COUNT                 (8U)

/*! @name SHIFTBUFHBS - Shifter Buffer N Halfword Byte Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_SHIFT     (0U)
/*! SHIFTBUFHBS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_SHIFT)) & FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHBS */
#define FLEXIO_SHIFTBUFHBS_COUNT                 (8U)


/*!
 * @}
 */ /* end of group FLEXIO_Register_Masks */


/* FLEXIO - Peripheral instance base addresses */
#if (__ARM_FEATURE_CMSE & 0x2)
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE                             (0x50032000u)
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE_NS                          (0x40032000u)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0_NS                               ((FLEXIO_Type *)FLEXIO0_BASE_NS)
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS                         { FLEXIO0 }
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS_NS                     { FLEXIO0_BASE_NS }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS_NS                      { FLEXIO0_NS }
#else
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE                             (0x40032000u)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS                         { FLEXIO0 }
#endif
/** Interrupt vectors for the FLEXIO peripheral type */
#define FLEXIO_IRQS                              { FLEXIO_IRQn }

/*!
 * @}
 */ /* end of group FLEXIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXSPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXSPI_Peripheral_Access_Layer FLEXSPI Peripheral Access Layer
 * @{
 */

/** FLEXSPI - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR0;                              /**< Module Control Register 0, offset: 0x0 */
  __IO uint32_t MCR1;                              /**< Module Control Register 1, offset: 0x4 */
  __IO uint32_t MCR2;                              /**< Module Control Register 2, offset: 0x8 */
  __IO uint32_t AHBCR;                             /**< AHB Bus Control Register, offset: 0xC */
  __IO uint32_t INTEN;                             /**< Interrupt Enable Register, offset: 0x10 */
  __IO uint32_t INTR;                              /**< Interrupt Register, offset: 0x14 */
  __IO uint32_t LUTKEY;                            /**< LUT Key Register, offset: 0x18 */
  __IO uint32_t LUTCR;                             /**< LUT Control Register, offset: 0x1C */
  __IO uint32_t AHBRXBUFCR0[8];                    /**< AHB RX Buffer 0 Control Register 0..AHB RX Buffer 7 Control Register 0, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_0[32];
  __IO uint32_t FLSHCR0[4];                        /**< Flash Control Register 0, array offset: 0x60, array step: 0x4 */
  __IO uint32_t FLSHCR1[4];                        /**< Flash Control Register 1, array offset: 0x70, array step: 0x4 */
  __IO uint32_t FLSHCR2[4];                        /**< Flash Control Register 2, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_1[4];
  __IO uint32_t FLSHCR4;                           /**< Flash Control Register 4, offset: 0x94 */
       uint8_t RESERVED_2[8];
  __IO uint32_t IPCR0;                             /**< IP Control Register 0, offset: 0xA0 */
  __IO uint32_t IPCR1;                             /**< IP Control Register 1, offset: 0xA4 */
       uint8_t RESERVED_3[8];
  __IO uint32_t IPCMD;                             /**< IP Command Register, offset: 0xB0 */
  __IO uint32_t DLPR;                              /**< Data Learn Pattern Register, offset: 0xB4 */
  __IO uint32_t IPRXFCR;                           /**< IP RX FIFO Control Register, offset: 0xB8 */
  __IO uint32_t IPTXFCR;                           /**< IP TX FIFO Control Register, offset: 0xBC */
  __IO uint32_t DLLCR[2];                          /**< DLL Control Register 0, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_4[24];
  __I  uint32_t STS0;                              /**< Status Register 0, offset: 0xE0 */
  __I  uint32_t STS1;                              /**< Status Register 1, offset: 0xE4 */
  __I  uint32_t STS2;                              /**< Status Register 2, offset: 0xE8 */
  __I  uint32_t AHBSPNDSTS;                        /**< AHB Suspend Status Register, offset: 0xEC */
  __I  uint32_t IPRXFSTS;                          /**< IP RX FIFO Status Register, offset: 0xF0 */
  __I  uint32_t IPTXFSTS;                          /**< IP TX FIFO Status Register, offset: 0xF4 */
       uint8_t RESERVED_5[8];
  __I  uint32_t RFDR[32];                          /**< IP RX FIFO Data Register 0..IP RX FIFO Data Register 31, array offset: 0x100, array step: 0x4 */
  __O  uint32_t TFDR[32];                          /**< IP TX FIFO Data Register 0..IP TX FIFO Data Register 31, array offset: 0x180, array step: 0x4 */
  __IO uint32_t LUT[64];                           /**< LUT 0..LUT 63, array offset: 0x200, array step: 0x4 */
} FLEXSPI_Type;

/* ----------------------------------------------------------------------------
   -- FLEXSPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXSPI_Register_Masks FLEXSPI Register Masks
 * @{
 */

/*! @name MCR0 - Module Control Register 0 */
/*! @{ */
#define FLEXSPI_MCR0_SWRESET_MASK                (0x1U)
#define FLEXSPI_MCR0_SWRESET_SHIFT               (0U)
/*! SWRESET - Software Reset
 */
#define FLEXSPI_MCR0_SWRESET(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SWRESET_SHIFT)) & FLEXSPI_MCR0_SWRESET_MASK)
#define FLEXSPI_MCR0_MDIS_MASK                   (0x2U)
#define FLEXSPI_MCR0_MDIS_SHIFT                  (1U)
/*! MDIS - Module Disable
 */
#define FLEXSPI_MCR0_MDIS(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_MDIS_SHIFT)) & FLEXSPI_MCR0_MDIS_MASK)
#define FLEXSPI_MCR0_RXCLKSRC_MASK               (0x30U)
#define FLEXSPI_MCR0_RXCLKSRC_SHIFT              (4U)
/*! RXCLKSRC - Sample Clock source selection for Flash Reading
 *  0b00..Dummy Read strobe generated by FlexSPI Controller and loopback internally.
 *  0b01..Dummy Read strobe generated by FlexSPI Controller and loopback from DQS pad.
 *  0b10..Reserved
 *  0b11..Flash provided Read strobe and input from DQS pad
 */
#define FLEXSPI_MCR0_RXCLKSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_RXCLKSRC_SHIFT)) & FLEXSPI_MCR0_RXCLKSRC_MASK)
#define FLEXSPI_MCR0_SERCLKDIV_MASK              (0x700U)
#define FLEXSPI_MCR0_SERCLKDIV_SHIFT             (8U)
/*! SERCLKDIV - The serial root clock could be divided inside FlexSPI wrapper. Refer Clocks chapter for more details on clocking.
 *  0b000..Divided by 1
 *  0b001..Divided by 2
 *  0b010..Divided by 3
 *  0b011..Divided by 4
 *  0b100..Divided by 5
 *  0b101..Divided by 6
 *  0b110..Divided by 7
 *  0b111..Divided by 8
 */
#define FLEXSPI_MCR0_SERCLKDIV(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SERCLKDIV_SHIFT)) & FLEXSPI_MCR0_SERCLKDIV_MASK)
#define FLEXSPI_MCR0_HSEN_MASK                   (0x800U)
#define FLEXSPI_MCR0_HSEN_SHIFT                  (11U)
/*! HSEN - Half Speed Serial Flash access Enable.
 *  0b0..Disable divide by 2 of serial flash clock for half speed commands.
 *  0b1..Enable divide by 2 of serial flash clock for half speed commands.
 */
#define FLEXSPI_MCR0_HSEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_HSEN_SHIFT)) & FLEXSPI_MCR0_HSEN_MASK)
#define FLEXSPI_MCR0_DOZEEN_MASK                 (0x1000U)
#define FLEXSPI_MCR0_DOZEEN_SHIFT                (12U)
/*! DOZEEN - Doze mode enable bit
 *  0b0..Doze mode support disabled. AHB clock and serial clock will not be gated off when there is doze mode request from system.
 *  0b1..Doze mode support enabled. AHB clock and serial clock will be gated off when there is doze mode request from system.
 */
#define FLEXSPI_MCR0_DOZEEN(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_DOZEEN_SHIFT)) & FLEXSPI_MCR0_DOZEEN_MASK)
#define FLEXSPI_MCR0_SCKFREERUNEN_MASK           (0x4000U)
#define FLEXSPI_MCR0_SCKFREERUNEN_SHIFT          (14U)
/*! SCKFREERUNEN - This bit is used to force SCLK output free-running. For FPGA applications,
 *    external device may use SCLK as reference clock to its internal PLL. If SCLK free-running is
 *    enabled, data sampling with loopback clock from SCLK pad is not supported (MCR0[RXCLKSRC]=2).
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_SCKFREERUNEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SCKFREERUNEN_SHIFT)) & FLEXSPI_MCR0_SCKFREERUNEN_MASK)
#define FLEXSPI_MCR0_LEARNEN_MASK                (0x8000U)
#define FLEXSPI_MCR0_LEARNEN_SHIFT               (15U)
/*! LEARNEN - This bit is used to enable/disable data learning feature. When data learning is
 *    disabled, the sampling clock phase 0 is always used for RX data sampling even if LEARN instruction
 *    is correctly executed.
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_LEARNEN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_LEARNEN_SHIFT)) & FLEXSPI_MCR0_LEARNEN_MASK)
#define FLEXSPI_MCR0_IPGRANTWAIT_MASK            (0xFF0000U)
#define FLEXSPI_MCR0_IPGRANTWAIT_SHIFT           (16U)
/*! IPGRANTWAIT - Time out wait cycle for IP command grant.
 */
#define FLEXSPI_MCR0_IPGRANTWAIT(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_IPGRANTWAIT_SHIFT)) & FLEXSPI_MCR0_IPGRANTWAIT_MASK)
#define FLEXSPI_MCR0_AHBGRANTWAIT_MASK           (0xFF000000U)
#define FLEXSPI_MCR0_AHBGRANTWAIT_SHIFT          (24U)
/*! AHBGRANTWAIT - Timeout wait cycle for AHB command grant.
 */
#define FLEXSPI_MCR0_AHBGRANTWAIT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_AHBGRANTWAIT_SHIFT)) & FLEXSPI_MCR0_AHBGRANTWAIT_MASK)
/*! @} */

/*! @name MCR1 - Module Control Register 1 */
/*! @{ */
#define FLEXSPI_MCR1_AHBBUSWAIT_MASK             (0xFFFFU)
#define FLEXSPI_MCR1_AHBBUSWAIT_SHIFT            (0U)
#define FLEXSPI_MCR1_AHBBUSWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR1_AHBBUSWAIT_SHIFT)) & FLEXSPI_MCR1_AHBBUSWAIT_MASK)
#define FLEXSPI_MCR1_SEQWAIT_MASK                (0xFFFF0000U)
#define FLEXSPI_MCR1_SEQWAIT_SHIFT               (16U)
#define FLEXSPI_MCR1_SEQWAIT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR1_SEQWAIT_SHIFT)) & FLEXSPI_MCR1_SEQWAIT_MASK)
/*! @} */

/*! @name MCR2 - Module Control Register 2 */
/*! @{ */
#define FLEXSPI_MCR2_CLRAHBBUFOPT_MASK           (0x800U)
#define FLEXSPI_MCR2_CLRAHBBUFOPT_SHIFT          (11U)
/*! CLRAHBBUFOPT - This bit determines whether AHB RX Buffer and AHB TX Buffer will be cleaned
 *    automatically when FlexSPI returns STOP mode ACK. Software should set this bit if AHB RX Buffer or
 *    AHB TX Buffer will be powered off in STOP mode. Otherwise AHB read access after exiting STOP
 *    mode may hit AHB RX Buffer or AHB TX Buffer but their data entries are invalid.
 *  0b0..AHB RX/TX Buffer will not be cleaned automatically when FlexSPI return Stop mode ACK.
 *  0b1..AHB RX/TX Buffer will be cleaned automatically when FlexSPI return Stop mode ACK.
 */
#define FLEXSPI_MCR2_CLRAHBBUFOPT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_CLRAHBBUFOPT_SHIFT)) & FLEXSPI_MCR2_CLRAHBBUFOPT_MASK)
#define FLEXSPI_MCR2_CLRLEARNPHASE_MASK          (0x4000U)
#define FLEXSPI_MCR2_CLRLEARNPHASE_SHIFT         (14U)
/*! CLRLEARNPHASE - The sampling clock phase selection will be reset to phase 0 when this bit is
 *    written with 0x1. This bit will be auto-cleared immediately.
 */
#define FLEXSPI_MCR2_CLRLEARNPHASE(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_CLRLEARNPHASE_SHIFT)) & FLEXSPI_MCR2_CLRLEARNPHASE_MASK)
#define FLEXSPI_MCR2_SAMEDEVICEEN_MASK           (0x8000U)
#define FLEXSPI_MCR2_SAMEDEVICEEN_SHIFT          (15U)
/*! SAMEDEVICEEN - All external devices are same devices (both in types and size) for A1/A2/B1/B2.
 *  0b0..In Individual mode, FLSHA1CRx/FLSHA2CRx/FLSHB1CRx/FLSHB2CRx register setting will be applied to Flash
 *       A1/A2/B1/B2 separately. In Parallel mode, FLSHA1CRx register setting will be applied to Flash A1 and B1,
 *       FLSHA2CRx register setting will be applied to Flash A2 and B2. FLSHB1CRx/FLSHB2CRx register settings will be
 *       ignored.
 *  0b1..FLSHA1CR0/FLSHA1CR1/FLSHA1CR2 register settings will be applied to Flash A1/A2/B1/B2. FLSHA2CRx/FLSHB1CRx/FLSHB2CRx will be ignored.
 */
#define FLEXSPI_MCR2_SAMEDEVICEEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_SAMEDEVICEEN_SHIFT)) & FLEXSPI_MCR2_SAMEDEVICEEN_MASK)
#define FLEXSPI_MCR2_SCKBDIFFOPT_MASK            (0x80000U)
#define FLEXSPI_MCR2_SCKBDIFFOPT_SHIFT           (19U)
/*! SCKBDIFFOPT - B_SCLK pad can be used as A_SCLK differential clock output (inverted clock to
 *    A_SCLK). In this case, port B flash access is not available. After changing the value of this
 *    field, MCR0[SWRESET] should be set.
 *  0b1..B_SCLK pad is used as port A SCLK inverted clock output (Differential clock to A_SCLK). Port B flash access is not available.
 *  0b0..B_SCLK pad is used as port B SCLK clock output. Port B flash access is available.
 */
#define FLEXSPI_MCR2_SCKBDIFFOPT(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_SCKBDIFFOPT_SHIFT)) & FLEXSPI_MCR2_SCKBDIFFOPT_MASK)
#define FLEXSPI_MCR2_RESUMEWAIT_MASK             (0xFF000000U)
#define FLEXSPI_MCR2_RESUMEWAIT_SHIFT            (24U)
/*! RESUMEWAIT - Wait cycle (in AHB clock cycle) for idle state before suspended command sequence resumed.
 */
#define FLEXSPI_MCR2_RESUMEWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_RESUMEWAIT_SHIFT)) & FLEXSPI_MCR2_RESUMEWAIT_MASK)
/*! @} */

/*! @name AHBCR - AHB Bus Control Register */
/*! @{ */
#define FLEXSPI_AHBCR_APAREN_MASK                (0x1U)
#define FLEXSPI_AHBCR_APAREN_SHIFT               (0U)
/*! APAREN - Parallel mode enabled for AHB triggered Command (both read and write) .
 *  0b0..Flash will be accessed in Individual mode.
 *  0b1..Flash will be accessed in Parallel mode.
 */
#define FLEXSPI_AHBCR_APAREN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_APAREN_SHIFT)) & FLEXSPI_AHBCR_APAREN_MASK)
#define FLEXSPI_AHBCR_CACHABLEEN_MASK            (0x8U)
#define FLEXSPI_AHBCR_CACHABLEEN_SHIFT           (3U)
/*! CACHABLEEN - Enable AHB bus cachable read access support.
 *  0b0..Disabled. When there is AHB bus cachable read access, FlexSPI will not check whether it hit AHB TX Buffer.
 *  0b1..Enabled. When there is AHB bus cachable read access, FlexSPI will check whether it hit AHB TX Buffer first.
 */
#define FLEXSPI_AHBCR_CACHABLEEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_CACHABLEEN_SHIFT)) & FLEXSPI_AHBCR_CACHABLEEN_MASK)
#define FLEXSPI_AHBCR_BUFFERABLEEN_MASK          (0x10U)
#define FLEXSPI_AHBCR_BUFFERABLEEN_SHIFT         (4U)
/*! BUFFERABLEEN - Enable AHB bus bufferable write access support. This field affects the last beat
 *    of AHB write access, refer for more details about AHB bufferable write.
 *  0b0..Disabled. For all AHB write access (no matter bufferable or non-bufferable ), FlexSPI will return AHB Bus
 *       ready after all data is transmitted to External device and AHB command finished.
 *  0b1..Enabled. For AHB bufferable write access, FlexSPI will return AHB Bus ready when the AHB command is
 *       granted by arbitrator and will not wait for AHB command finished.
 */
#define FLEXSPI_AHBCR_BUFFERABLEEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_BUFFERABLEEN_SHIFT)) & FLEXSPI_AHBCR_BUFFERABLEEN_MASK)
#define FLEXSPI_AHBCR_PREFETCHEN_MASK            (0x20U)
#define FLEXSPI_AHBCR_PREFETCHEN_SHIFT           (5U)
/*! PREFETCHEN - AHB Read Prefetch Enable.
 */
#define FLEXSPI_AHBCR_PREFETCHEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_PREFETCHEN_SHIFT)) & FLEXSPI_AHBCR_PREFETCHEN_MASK)
#define FLEXSPI_AHBCR_READADDROPT_MASK           (0x40U)
#define FLEXSPI_AHBCR_READADDROPT_SHIFT          (6U)
/*! READADDROPT - AHB Read Address option bit. This option bit is intend to remove AHB burst start address alignment limitation.
 *  0b0..There is AHB read burst start address alignment limitation when flash is accessed in parallel mode or flash is word-addressable.
 *  0b1..There is no AHB read burst start address alignment limitation. FlexSPI will fetch more data than AHB
 *       burst required to meet the alignment requirement.
 */
#define FLEXSPI_AHBCR_READADDROPT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_READADDROPT_SHIFT)) & FLEXSPI_AHBCR_READADDROPT_MASK)
#define FLEXSPI_AHBCR_READSZALIGN_MASK           (0x400U)
#define FLEXSPI_AHBCR_READSZALIGN_SHIFT          (10U)
/*! READSZALIGN - AHB Read Size Alignment
 *  0b0..AHB read size will be decided by other register setting like PREFETCH_EN,OTFAD_EN...
 *  0b1..AHB read size to up size to 8 bytes aligned, no prefetching
 */
#define FLEXSPI_AHBCR_READSZALIGN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_READSZALIGN_SHIFT)) & FLEXSPI_AHBCR_READSZALIGN_MASK)
/*! @} */

/*! @name INTEN - Interrupt Enable Register */
/*! @{ */
#define FLEXSPI_INTEN_IPCMDDONEEN_MASK           (0x1U)
#define FLEXSPI_INTEN_IPCMDDONEEN_SHIFT          (0U)
/*! IPCMDDONEEN - IP triggered Command Sequences Execution finished interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDDONEEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDDONEEN_SHIFT)) & FLEXSPI_INTEN_IPCMDDONEEN_MASK)
#define FLEXSPI_INTEN_IPCMDGEEN_MASK             (0x2U)
#define FLEXSPI_INTEN_IPCMDGEEN_SHIFT            (1U)
/*! IPCMDGEEN - IP triggered Command Sequences Grant Timeout interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDGEEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDGEEN_SHIFT)) & FLEXSPI_INTEN_IPCMDGEEN_MASK)
#define FLEXSPI_INTEN_AHBCMDGEEN_MASK            (0x4U)
#define FLEXSPI_INTEN_AHBCMDGEEN_SHIFT           (2U)
/*! AHBCMDGEEN - AHB triggered Command Sequences Grant Timeout interrupt enable.
 */
#define FLEXSPI_INTEN_AHBCMDGEEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBCMDGEEN_SHIFT)) & FLEXSPI_INTEN_AHBCMDGEEN_MASK)
#define FLEXSPI_INTEN_IPCMDERREN_MASK            (0x8U)
#define FLEXSPI_INTEN_IPCMDERREN_SHIFT           (3U)
/*! IPCMDERREN - IP triggered Command Sequences Error Detected interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDERREN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDERREN_SHIFT)) & FLEXSPI_INTEN_IPCMDERREN_MASK)
#define FLEXSPI_INTEN_AHBCMDERREN_MASK           (0x10U)
#define FLEXSPI_INTEN_AHBCMDERREN_SHIFT          (4U)
/*! AHBCMDERREN - AHB triggered Command Sequences Error Detected interrupt enable.
 */
#define FLEXSPI_INTEN_AHBCMDERREN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBCMDERREN_SHIFT)) & FLEXSPI_INTEN_AHBCMDERREN_MASK)
#define FLEXSPI_INTEN_IPRXWAEN_MASK              (0x20U)
#define FLEXSPI_INTEN_IPRXWAEN_SHIFT             (5U)
/*! IPRXWAEN - IP RX FIFO WaterMark available interrupt enable.
 */
#define FLEXSPI_INTEN_IPRXWAEN(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPRXWAEN_SHIFT)) & FLEXSPI_INTEN_IPRXWAEN_MASK)
#define FLEXSPI_INTEN_IPTXWEEN_MASK              (0x40U)
#define FLEXSPI_INTEN_IPTXWEEN_SHIFT             (6U)
/*! IPTXWEEN - IP TX FIFO WaterMark empty interrupt enable.
 */
#define FLEXSPI_INTEN_IPTXWEEN(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPTXWEEN_SHIFT)) & FLEXSPI_INTEN_IPTXWEEN_MASK)
#define FLEXSPI_INTEN_DATALEARNFAILEN_MASK       (0x80U)
#define FLEXSPI_INTEN_DATALEARNFAILEN_SHIFT      (7U)
/*! DATALEARNFAILEN - Data Learning failed interrupt enable.
 */
#define FLEXSPI_INTEN_DATALEARNFAILEN(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_DATALEARNFAILEN_SHIFT)) & FLEXSPI_INTEN_DATALEARNFAILEN_MASK)
#define FLEXSPI_INTEN_SCKSTOPBYRDEN_MASK         (0x100U)
#define FLEXSPI_INTEN_SCKSTOPBYRDEN_SHIFT        (8U)
/*! SCKSTOPBYRDEN - SCLK is stopped during command sequence because Async RX FIFO full interrupt enable.
 */
#define FLEXSPI_INTEN_SCKSTOPBYRDEN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SCKSTOPBYRDEN_SHIFT)) & FLEXSPI_INTEN_SCKSTOPBYRDEN_MASK)
#define FLEXSPI_INTEN_SCKSTOPBYWREN_MASK         (0x200U)
#define FLEXSPI_INTEN_SCKSTOPBYWREN_SHIFT        (9U)
/*! SCKSTOPBYWREN - SCLK is stopped during command sequence because Async TX FIFO empty interrupt enable.
 */
#define FLEXSPI_INTEN_SCKSTOPBYWREN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SCKSTOPBYWREN_SHIFT)) & FLEXSPI_INTEN_SCKSTOPBYWREN_MASK)
#define FLEXSPI_INTEN_AHBBUSERROREN_MASK         (0x400U)
#define FLEXSPI_INTEN_AHBBUSERROREN_SHIFT        (10U)
/*! AHBBUSERROREN - AHB Bus error interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_AHBBUSERROREN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBBUSERROREN_SHIFT)) & FLEXSPI_INTEN_AHBBUSERROREN_MASK)
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN_MASK       (0x400U)
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN_SHIFT      (10U)
/*! AHBBUSTIMEOUTEN - AHB Bus timeout interrupt.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBBUSTIMEOUTEN_SHIFT)) & FLEXSPI_INTEN_AHBBUSTIMEOUTEN_MASK)
#define FLEXSPI_INTEN_SEQTIMEOUTEN_MASK          (0x800U)
#define FLEXSPI_INTEN_SEQTIMEOUTEN_SHIFT         (11U)
/*! SEQTIMEOUTEN - Sequence execution timeout interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_SEQTIMEOUTEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SEQTIMEOUTEN_SHIFT)) & FLEXSPI_INTEN_SEQTIMEOUTEN_MASK)
#define FLEXSPI_INTEN_KEYDONEEN_MASK             (0x1000U)
#define FLEXSPI_INTEN_KEYDONEEN_SHIFT            (12U)
/*! KEYDONEEN - OTFAD key blob processing done interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_KEYDONEEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_KEYDONEEN_SHIFT)) & FLEXSPI_INTEN_KEYDONEEN_MASK)
#define FLEXSPI_INTEN_KEYERROREN_MASK            (0x2000U)
#define FLEXSPI_INTEN_KEYERROREN_SHIFT           (13U)
/*! KEYERROREN - OTFAD key blob processing error interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_KEYERROREN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_KEYERROREN_SHIFT)) & FLEXSPI_INTEN_KEYERROREN_MASK)
/*! @} */

/*! @name INTR - Interrupt Register */
/*! @{ */
#define FLEXSPI_INTR_IPCMDDONE_MASK              (0x1U)
#define FLEXSPI_INTR_IPCMDDONE_SHIFT             (0U)
/*! IPCMDDONE - IP triggered Command Sequences Execution finished interrupt. This interrupt is also
 *    generated when there is IPCMDGE or IPCMDERR interrupt generated.
 */
#define FLEXSPI_INTR_IPCMDDONE(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDDONE_SHIFT)) & FLEXSPI_INTR_IPCMDDONE_MASK)
#define FLEXSPI_INTR_IPCMDGE_MASK                (0x2U)
#define FLEXSPI_INTR_IPCMDGE_SHIFT               (1U)
/*! IPCMDGE - IP triggered Command Sequences Grant Timeout interrupt.
 */
#define FLEXSPI_INTR_IPCMDGE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDGE_SHIFT)) & FLEXSPI_INTR_IPCMDGE_MASK)
#define FLEXSPI_INTR_AHBCMDGE_MASK               (0x4U)
#define FLEXSPI_INTR_AHBCMDGE_SHIFT              (2U)
/*! AHBCMDGE - AHB triggered Command Sequences Grant Timeout interrupt.
 */
#define FLEXSPI_INTR_AHBCMDGE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBCMDGE_SHIFT)) & FLEXSPI_INTR_AHBCMDGE_MASK)
#define FLEXSPI_INTR_IPCMDERR_MASK               (0x8U)
#define FLEXSPI_INTR_IPCMDERR_SHIFT              (3U)
/*! IPCMDERR - IP triggered Command Sequences Error Detected interrupt. When an error detected for
 *    IP command, this command will be ignored and not executed at all.
 */
#define FLEXSPI_INTR_IPCMDERR(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDERR_SHIFT)) & FLEXSPI_INTR_IPCMDERR_MASK)
#define FLEXSPI_INTR_AHBCMDERR_MASK              (0x10U)
#define FLEXSPI_INTR_AHBCMDERR_SHIFT             (4U)
/*! AHBCMDERR - AHB triggered Command Sequences Error Detected interrupt. When an error detected for
 *    AHB command, this command will be ignored and not executed at all.
 */
#define FLEXSPI_INTR_AHBCMDERR(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBCMDERR_SHIFT)) & FLEXSPI_INTR_AHBCMDERR_MASK)
#define FLEXSPI_INTR_IPRXWA_MASK                 (0x20U)
#define FLEXSPI_INTR_IPRXWA_SHIFT                (5U)
/*! IPRXWA - IP RX FIFO watermark available interrupt.
 */
#define FLEXSPI_INTR_IPRXWA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPRXWA_SHIFT)) & FLEXSPI_INTR_IPRXWA_MASK)
#define FLEXSPI_INTR_IPTXWE_MASK                 (0x40U)
#define FLEXSPI_INTR_IPTXWE_SHIFT                (6U)
/*! IPTXWE - IP TX FIFO watermark empty interrupt.
 */
#define FLEXSPI_INTR_IPTXWE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPTXWE_SHIFT)) & FLEXSPI_INTR_IPTXWE_MASK)
#define FLEXSPI_INTR_DATALEARNFAIL_MASK          (0x80U)
#define FLEXSPI_INTR_DATALEARNFAIL_SHIFT         (7U)
/*! DATALEARNFAIL - Data Learning failed interrupt.
 */
#define FLEXSPI_INTR_DATALEARNFAIL(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_DATALEARNFAIL_SHIFT)) & FLEXSPI_INTR_DATALEARNFAIL_MASK)
#define FLEXSPI_INTR_SCKSTOPBYRD_MASK            (0x100U)
#define FLEXSPI_INTR_SCKSTOPBYRD_SHIFT           (8U)
/*! SCKSTOPBYRD - SCLK is stopped during command sequence because Async RX FIFO full interrupt.
 */
#define FLEXSPI_INTR_SCKSTOPBYRD(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SCKSTOPBYRD_SHIFT)) & FLEXSPI_INTR_SCKSTOPBYRD_MASK)
#define FLEXSPI_INTR_SCKSTOPBYWR_MASK            (0x200U)
#define FLEXSPI_INTR_SCKSTOPBYWR_SHIFT           (9U)
/*! SCKSTOPBYWR - SCLK is stopped during command sequence because Async TX FIFO empty interrupt.
 */
#define FLEXSPI_INTR_SCKSTOPBYWR(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SCKSTOPBYWR_SHIFT)) & FLEXSPI_INTR_SCKSTOPBYWR_MASK)
#define FLEXSPI_INTR_AHBBUSERROR_MASK            (0x400U)
#define FLEXSPI_INTR_AHBBUSERROR_SHIFT           (10U)
/*! AHBBUSERROR - AHB Bus timeout or AHB bus illegal access Flash during OTFAD key blob processing interrupt.
 */
#define FLEXSPI_INTR_AHBBUSERROR(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBBUSERROR_SHIFT)) & FLEXSPI_INTR_AHBBUSERROR_MASK)
#define FLEXSPI_INTR_AHBBUSTIMEOUT_MASK          (0x400U)
#define FLEXSPI_INTR_AHBBUSTIMEOUT_SHIFT         (10U)
/*! AHBBUSTIMEOUT - AHB Bus timeout interrupt.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTR_AHBBUSTIMEOUT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBBUSTIMEOUT_SHIFT)) & FLEXSPI_INTR_AHBBUSTIMEOUT_MASK)
#define FLEXSPI_INTR_SEQTIMEOUT_MASK             (0x800U)
#define FLEXSPI_INTR_SEQTIMEOUT_SHIFT            (11U)
/*! SEQTIMEOUT - Sequence execution timeout interrupt.
 */
#define FLEXSPI_INTR_SEQTIMEOUT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SEQTIMEOUT_SHIFT)) & FLEXSPI_INTR_SEQTIMEOUT_MASK)
#define FLEXSPI_INTR_KEYDONE_MASK                (0x1000U)
#define FLEXSPI_INTR_KEYDONE_SHIFT               (12U)
/*! KEYDONE - OTFAD key blob processing done interrupt.
 */
#define FLEXSPI_INTR_KEYDONE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_KEYDONE_SHIFT)) & FLEXSPI_INTR_KEYDONE_MASK)
#define FLEXSPI_INTR_KEYERROR_MASK               (0x2000U)
#define FLEXSPI_INTR_KEYERROR_SHIFT              (13U)
/*! KEYERROR - OTFAD key blob processing error interrupt.
 */
#define FLEXSPI_INTR_KEYERROR(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_KEYERROR_SHIFT)) & FLEXSPI_INTR_KEYERROR_MASK)
/*! @} */

/*! @name LUTKEY - LUT Key Register */
/*! @{ */
#define FLEXSPI_LUTKEY_KEY_MASK                  (0xFFFFFFFFU)
#define FLEXSPI_LUTKEY_KEY_SHIFT                 (0U)
/*! KEY - The Key to lock or unlock LUT.
 */
#define FLEXSPI_LUTKEY_KEY(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTKEY_KEY_SHIFT)) & FLEXSPI_LUTKEY_KEY_MASK)
/*! @} */

/*! @name LUTCR - LUT Control Register */
/*! @{ */
#define FLEXSPI_LUTCR_LOCK_MASK                  (0x1U)
#define FLEXSPI_LUTCR_LOCK_SHIFT                 (0U)
/*! LOCK - Lock LUT
 */
#define FLEXSPI_LUTCR_LOCK(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_LOCK_SHIFT)) & FLEXSPI_LUTCR_LOCK_MASK)
#define FLEXSPI_LUTCR_UNLOCK_MASK                (0x2U)
#define FLEXSPI_LUTCR_UNLOCK_SHIFT               (1U)
/*! UNLOCK - Unlock LUT
 */
#define FLEXSPI_LUTCR_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_UNLOCK_SHIFT)) & FLEXSPI_LUTCR_UNLOCK_MASK)
/*! @} */

/*! @name AHBRXBUFCR0 - AHB RX Buffer 0 Control Register 0..AHB RX Buffer 7 Control Register 0 */
/*! @{ */
#define FLEXSPI_AHBRXBUFCR0_BUFSZ_MASK           (0x1FFU)  /* Merged from fields with different position or width, of widths (8, 9), largest definition used */
#define FLEXSPI_AHBRXBUFCR0_BUFSZ_SHIFT          (0U)
/*! BUFSZ - AHB RX Buffer Size in 64 bits.
 */
#define FLEXSPI_AHBRXBUFCR0_BUFSZ(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_BUFSZ_SHIFT)) & FLEXSPI_AHBRXBUFCR0_BUFSZ_MASK)  /* Merged from fields with different position or width, of widths (8, 9), largest definition used */
#define FLEXSPI_AHBRXBUFCR0_MSTRID_MASK          (0xF0000U)
#define FLEXSPI_AHBRXBUFCR0_MSTRID_SHIFT         (16U)
/*! MSTRID - This AHB RX Buffer is assigned according to AHB Master with ID (MSTR_ID).
 */
#define FLEXSPI_AHBRXBUFCR0_MSTRID(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_MSTRID_SHIFT)) & FLEXSPI_AHBRXBUFCR0_MSTRID_MASK)
#define FLEXSPI_AHBRXBUFCR0_PRIORITY_MASK        (0x7000000U)
#define FLEXSPI_AHBRXBUFCR0_PRIORITY_SHIFT       (24U)
/*! PRIORITY - This priority for AHB Master Read which this AHB RX Buffer is assigned. 7 is the highest priority, 0 the lowest.
 */
#define FLEXSPI_AHBRXBUFCR0_PRIORITY(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_PRIORITY_SHIFT)) & FLEXSPI_AHBRXBUFCR0_PRIORITY_MASK)
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN_MASK      (0x80000000U)
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN_SHIFT     (31U)
/*! PREFETCHEN - AHB Read Prefetch Enable for current AHB RX Buffer corresponding Master.
 */
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_PREFETCHEN_SHIFT)) & FLEXSPI_AHBRXBUFCR0_PREFETCHEN_MASK)
/*! @} */

/* The count of FLEXSPI_AHBRXBUFCR0 */
#define FLEXSPI_AHBRXBUFCR0_COUNT                (8U)

/*! @name FLSHCR0 - Flash Control Register 0 */
/*! @{ */
#define FLEXSPI_FLSHCR0_FLSHSZ_MASK              (0x7FFFFFU)
#define FLEXSPI_FLSHCR0_FLSHSZ_SHIFT             (0U)
/*! FLSHSZ - Flash Size in KByte.
 */
#define FLEXSPI_FLSHCR0_FLSHSZ(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR0_FLSHSZ_SHIFT)) & FLEXSPI_FLSHCR0_FLSHSZ_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR0 */
#define FLEXSPI_FLSHCR0_COUNT                    (4U)

/*! @name FLSHCR1 - Flash Control Register 1 */
/*! @{ */
#define FLEXSPI_FLSHCR1_TCSS_MASK                (0x1FU)
#define FLEXSPI_FLSHCR1_TCSS_SHIFT               (0U)
/*! TCSS - Serial Flash CS setup time.
 */
#define FLEXSPI_FLSHCR1_TCSS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_TCSS_SHIFT)) & FLEXSPI_FLSHCR1_TCSS_MASK)
#define FLEXSPI_FLSHCR1_TCSH_MASK                (0x3E0U)
#define FLEXSPI_FLSHCR1_TCSH_SHIFT               (5U)
/*! TCSH - Serial Flash CS Hold time.
 */
#define FLEXSPI_FLSHCR1_TCSH(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_TCSH_SHIFT)) & FLEXSPI_FLSHCR1_TCSH_MASK)
#define FLEXSPI_FLSHCR1_WA_MASK                  (0x400U)
#define FLEXSPI_FLSHCR1_WA_SHIFT                 (10U)
/*! WA - Word Addressable.
 */
#define FLEXSPI_FLSHCR1_WA(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_WA_SHIFT)) & FLEXSPI_FLSHCR1_WA_MASK)
#define FLEXSPI_FLSHCR1_CAS_MASK                 (0x7800U)
#define FLEXSPI_FLSHCR1_CAS_SHIFT                (11U)
/*! CAS - Column Address Size.
 */
#define FLEXSPI_FLSHCR1_CAS(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CAS_SHIFT)) & FLEXSPI_FLSHCR1_CAS_MASK)
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT_MASK      (0x8000U)
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT_SHIFT     (15U)
/*! CSINTERVALUNIT - CS interval unit
 *  0b0..The CS interval unit is 1 serial clock cycle
 *  0b1..The CS interval unit is 256 serial clock cycle
 */
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CSINTERVALUNIT_SHIFT)) & FLEXSPI_FLSHCR1_CSINTERVALUNIT_MASK)
#define FLEXSPI_FLSHCR1_CSINTERVAL_MASK          (0xFFFF0000U)
#define FLEXSPI_FLSHCR1_CSINTERVAL_SHIFT         (16U)
/*! CSINTERVAL - This field is used to set the minimum interval between flash device Chip selection
 *    deassertion and flash device Chip selection assertion. If external flash has a limitation on
 *    the interval between command sequences, this field should be set accordingly. If there is no
 *    limitation, set this field with value 0x0.
 */
#define FLEXSPI_FLSHCR1_CSINTERVAL(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CSINTERVAL_SHIFT)) & FLEXSPI_FLSHCR1_CSINTERVAL_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR1 */
#define FLEXSPI_FLSHCR1_COUNT                    (4U)

/*! @name FLSHCR2 - Flash Control Register 2 */
/*! @{ */
#define FLEXSPI_FLSHCR2_ARDSEQID_MASK            (0xFU)
#define FLEXSPI_FLSHCR2_ARDSEQID_SHIFT           (0U)
/*! ARDSEQID - Sequence Index for AHB Read triggered Command in LUT.
 */
#define FLEXSPI_FLSHCR2_ARDSEQID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_ARDSEQID_SHIFT)) & FLEXSPI_FLSHCR2_ARDSEQID_MASK)
#define FLEXSPI_FLSHCR2_ARDSEQNUM_MASK           (0xE0U)
#define FLEXSPI_FLSHCR2_ARDSEQNUM_SHIFT          (5U)
/*! ARDSEQNUM - Sequence Number for AHB Read triggered Command in LUT.
 */
#define FLEXSPI_FLSHCR2_ARDSEQNUM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_ARDSEQNUM_SHIFT)) & FLEXSPI_FLSHCR2_ARDSEQNUM_MASK)
#define FLEXSPI_FLSHCR2_AWRSEQID_MASK            (0xF00U)
#define FLEXSPI_FLSHCR2_AWRSEQID_SHIFT           (8U)
/*! AWRSEQID - Sequence Index for AHB Write triggered Command.
 */
#define FLEXSPI_FLSHCR2_AWRSEQID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRSEQID_SHIFT)) & FLEXSPI_FLSHCR2_AWRSEQID_MASK)
#define FLEXSPI_FLSHCR2_AWRSEQNUM_MASK           (0xE000U)
#define FLEXSPI_FLSHCR2_AWRSEQNUM_SHIFT          (13U)
/*! AWRSEQNUM - Sequence Number for AHB Write triggered Command.
 */
#define FLEXSPI_FLSHCR2_AWRSEQNUM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRSEQNUM_SHIFT)) & FLEXSPI_FLSHCR2_AWRSEQNUM_MASK)
#define FLEXSPI_FLSHCR2_AWRWAIT_MASK             (0xFFF0000U)
#define FLEXSPI_FLSHCR2_AWRWAIT_SHIFT            (16U)
#define FLEXSPI_FLSHCR2_AWRWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRWAIT_SHIFT)) & FLEXSPI_FLSHCR2_AWRWAIT_MASK)
#define FLEXSPI_FLSHCR2_AWRWAITUNIT_MASK         (0x70000000U)
#define FLEXSPI_FLSHCR2_AWRWAITUNIT_SHIFT        (28U)
/*! AWRWAITUNIT - AWRWAIT unit
 *  0b000..The AWRWAIT unit is 2 ahb clock cycle
 *  0b001..The AWRWAIT unit is 8 ahb clock cycle
 *  0b010..The AWRWAIT unit is 32 ahb clock cycle
 *  0b011..The AWRWAIT unit is 128 ahb clock cycle
 *  0b100..The AWRWAIT unit is 512 ahb clock cycle
 *  0b101..The AWRWAIT unit is 2048 ahb clock cycle
 *  0b110..The AWRWAIT unit is 8192 ahb clock cycle
 *  0b111..The AWRWAIT unit is 32768 ahb clock cycle
 */
#define FLEXSPI_FLSHCR2_AWRWAITUNIT(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRWAITUNIT_SHIFT)) & FLEXSPI_FLSHCR2_AWRWAITUNIT_MASK)
#define FLEXSPI_FLSHCR2_CLRINSTRPTR_MASK         (0x80000000U)
#define FLEXSPI_FLSHCR2_CLRINSTRPTR_SHIFT        (31U)
/*! CLRINSTRPTR - Clear the instruction pointer which is internally saved pointer by JMP_ON_CS.
 *    Refer Programmable Sequence Engine for details.
 */
#define FLEXSPI_FLSHCR2_CLRINSTRPTR(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_CLRINSTRPTR_SHIFT)) & FLEXSPI_FLSHCR2_CLRINSTRPTR_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR2 */
#define FLEXSPI_FLSHCR2_COUNT                    (4U)

/*! @name FLSHCR4 - Flash Control Register 4 */
/*! @{ */
#define FLEXSPI_FLSHCR4_WMOPT1_MASK              (0x1U)
#define FLEXSPI_FLSHCR4_WMOPT1_SHIFT             (0U)
/*! WMOPT1 - Write mask option bit 1. This option bit could be used to remove AHB write burst start address alignment limitation.
 *  0b0..DQS pin will be used as Write Mask when writing to external device. There is no limitation on AHB write
 *       burst start address alignment when flash is accessed in individual mode.
 *  0b1..DQS pin will not be used as Write Mask when writing to external device. There is limitation on AHB write
 *       burst start address alignment when flash is accessed in individual mode.
 */
#define FLEXSPI_FLSHCR4_WMOPT1(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMOPT1_SHIFT)) & FLEXSPI_FLSHCR4_WMOPT1_MASK)
#define FLEXSPI_FLSHCR4_WMENA_MASK               (0x4U)
#define FLEXSPI_FLSHCR4_WMENA_SHIFT              (2U)
/*! WMENA - Write mask enable bit for flash device on port A. When write mask function is needed for
 *    memory device on port A, this bit must be set.
 *  0b0..Write mask is disabled, DQS(RWDS) pin will be un-driven when writing to external device.
 *  0b1..Write mask is enabled, DQS(RWDS) pin will be driven by FlexSPI as write mask output when writing to external device.
 */
#define FLEXSPI_FLSHCR4_WMENA(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMENA_SHIFT)) & FLEXSPI_FLSHCR4_WMENA_MASK)
#define FLEXSPI_FLSHCR4_WMENB_MASK               (0x8U)
#define FLEXSPI_FLSHCR4_WMENB_SHIFT              (3U)
/*! WMENB - Write mask enable bit for flash device on port B. When write mask function is needed for
 *    memory device on port B, this bit must be set.
 *  0b0..Write mask is disabled, DQS(RWDS) pin will be un-driven when writing to external device.
 *  0b1..Write mask is enabled, DQS(RWDS) pin will be driven by FlexSPI as write mask output when writing to external device.
 */
#define FLEXSPI_FLSHCR4_WMENB(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMENB_SHIFT)) & FLEXSPI_FLSHCR4_WMENB_MASK)
/*! @} */

/*! @name IPCR0 - IP Control Register 0 */
/*! @{ */
#define FLEXSPI_IPCR0_SFAR_MASK                  (0xFFFFFFFFU)
#define FLEXSPI_IPCR0_SFAR_SHIFT                 (0U)
/*! SFAR - Serial Flash Address for IP command.
 */
#define FLEXSPI_IPCR0_SFAR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR0_SFAR_SHIFT)) & FLEXSPI_IPCR0_SFAR_MASK)
/*! @} */

/*! @name IPCR1 - IP Control Register 1 */
/*! @{ */
#define FLEXSPI_IPCR1_IDATSZ_MASK                (0xFFFFU)
#define FLEXSPI_IPCR1_IDATSZ_SHIFT               (0U)
/*! IDATSZ - Flash Read/Program Data Size (in Bytes) for IP command.
 */
#define FLEXSPI_IPCR1_IDATSZ(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_IDATSZ_SHIFT)) & FLEXSPI_IPCR1_IDATSZ_MASK)
#define FLEXSPI_IPCR1_ISEQID_MASK                (0xF0000U)
#define 