/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_msb.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  double t89, t93, t94, t97, t98, t99, t101, t102;
  double t103, t104, t106, t107, t108, t112, t115, t118;
  double t119, t122, t123, t124, t127, t128, t132, t133;
  double t137, t138, t141, t142, t144, t147, t150, t152;
  double t157, tvrho0, t160, t161, t162, t164, t165, t166;
  double t169, t171, t173, t175, t176, t180, t182, t186;
  double tvsigma0, tvlapl0, t188, t190, t192, t193, t202, t206;
  double t207, t209, t213, tvtau0;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t89 = t18 / t31;
  t93 = params->kappa * params->kappa;
  t94 = t37 * t37;
  t97 = t93 / t94 * t21;
  t98 = t25 * sigma[0];
  t99 = t30 * rho[0];
  t101 = 0.1e1 / t31 / t99;
  t102 = t28 * t101;
  t103 = t98 * t102;
  t104 = t97 * t103;
  t106 = t58 * t74;
  t107 = t47 * t54;
  t108 = t42 * t33;
  t112 = -0.5e1 / 0.3e1 * t108 + t29 * t101 / 0.3e1;
  t115 = t48 * t62;
  t118 = -0.8e1 * t107 * t112 - 0.4e2 / 0.3e1 * t115 * t108;
  t119 = t81 * t118;
  t122 = t73 * t73;
  t123 = 0.1e1 / t122;
  t124 = t59 * t123;
  t127 = 0.1e1 / t68;
  t128 = t60 * t127;
  t132 = params->b * t65 * t47;
  t133 = t70 * t112;
  t137 = 0.1e1 / t68 / t61;
  t138 = t67 * t137;
  t141 = 0.4e2 * t128 * t108 + 0.64e3 * t138 * t108 + 0.24e2 * t115 * t112 + 0.384e3 * t132 * t133;
  t142 = t81 * t141;
  t144 = t76 * t76;
  t147 = t93 / t144 * t21;
  t150 = -0.1e2 / 0.729e3 * t147 * t103 + 0.1e2 / 0.729e3 * t104;
  t152 = -0.1e2 / 0.729e3 * t104 + 0.3e1 * t106 * t119 - t124 * t142 + t75 * t150;
  t157 = my_piecewise3(t3, 0, -t7 * t89 * t83 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t152);
  tvrho0 = 0.2e1 * rho[0] * t157 + 0.2e1 * t87;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t160 = t25 * t28;
  t161 = t160 * t33;
  t162 = t97 * t161;
  t164 = t106 * t81;
  t165 = t28 * t33;
  t166 = t107 * t165;
  t169 = t115 * t165;
  t171 = t70 * t28;
  t173 = t132 * t171 * t33;
  t175 = -0.3e1 * t169 - 0.48e2 * t173;
  t176 = t81 * t175;
  t180 = 0.5e1 / 0.972e3 * t147 * t161 - 0.5e1 / 0.972e3 * t162;
  t182 = 0.5e1 / 0.972e3 * t162 + 0.3e1 * t164 * t166 - t124 * t176 + t75 * t180;
  t186 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t182);
  tvsigma0 = 0.2e1 * rho[0] * t186;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t188 = t28 * t44;
  t190 = t115 * t188;
  t192 = -0.8e1 * t107 * t188 + 0.8e1 * t190;
  t193 = t81 * t192;
  t202 = t137 * t28;
  t206 = 0.384e3 * t132 * t171 * t44 - 0.384e3 * t67 * t202 * t44 - 0.24e2 * t128 * t188 + 0.24e2 * t190;
  t207 = t81 * t206;
  t209 = 0.3e1 * t106 * t193 - t124 * t207;
  t213 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t209);
  tvtau0 = 0.2e1 * rho[0] * t213;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  double t89, t93, t94, t97, t98, t99, t101, t102;
  double t103, t104, t106, t107, t108, t112, t115, t118;
  double t119, t122, t123, t124, t127, t128, t132, t133;
  double t137, t138, t141, t142, t144, t147, t150, t152;
  double t157, tvrho0, t160, t161, t162, t164, t165, t166;
  double t169, t171, t173, t175, t176, t180, t182, t186;
  double tvsigma0, tvlapl0, t188, t190, t192, t193, t202, t206;
  double t207, t209, t213, tvtau0;

  double t216, t226, t228, t229, t230, t231, t232, t234;
  double t235, t236, t238, t240, t241, t242, t244, t245;
  double t246, t247, t250, t254, t257, t260, t261, t264;
  double t268, t271, t272, t273, t274, t276, t277, t282;
  double t283, t287, t288, t289, t290, t293, t298, t304;
  double t305, t310, t311, t314, t315, t322, t323, t324;
  double t329, t335, t340, t342, t347, tv2rho20, t353, t354;
  double t356, t358, t360, t361, t363, t364, t365, t366;
  double t367, t368, t371, t373, t376, t379, t380, t383;
  double t384, t386, t389, t398, t400, t401, t403, t404;
  double t405, t407, t409, t410, t412, t415, t417, t418;
  double t420, t423, t429, t431, t436, tv2rhosigma0, tv2rholapl0, t445;
  double t448, t454, t455, t456, t460, t461, t463, t466;
  double t467, t476, t499, t500, t502, t507, tv2rhotau0, t510;
  double t511, t513, t514, t517, t518, t521, t524, t527;
  double t528, t531, t534, t536, t538, t540, t541, t545;
  double t547, t551, tv2sigma20, tv2sigmalapl0, t553, t556, t559, t562;
  double t564, t566, t567, t570, t576, t579, t582, t584;
  double t586, t588, t589, t591, t595, tv2sigmatau0, tv2lapl20, tv2lapltau0;
  double t597, t598, t601, t605, t606, t609, t611, t613;
  double t614, t617, t618, t631, t635, t636, t638, t642;
  double tv2tau20;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t89 = t18 / t31;
  t93 = params->kappa * params->kappa;
  t94 = t37 * t37;
  t97 = t93 / t94 * t21;
  t98 = t25 * sigma[0];
  t99 = t30 * rho[0];
  t101 = 0.1e1 / t31 / t99;
  t102 = t28 * t101;
  t103 = t98 * t102;
  t104 = t97 * t103;
  t106 = t58 * t74;
  t107 = t47 * t54;
  t108 = t42 * t33;
  t112 = -0.5e1 / 0.3e1 * t108 + t29 * t101 / 0.3e1;
  t115 = t48 * t62;
  t118 = -0.8e1 * t107 * t112 - 0.4e2 / 0.3e1 * t115 * t108;
  t119 = t81 * t118;
  t122 = t73 * t73;
  t123 = 0.1e1 / t122;
  t124 = t59 * t123;
  t127 = 0.1e1 / t68;
  t128 = t60 * t127;
  t132 = params->b * t65 * t47;
  t133 = t70 * t112;
  t137 = 0.1e1 / t68 / t61;
  t138 = t67 * t137;
  t141 = 0.4e2 * t128 * t108 + 0.64e3 * t138 * t108 + 0.24e2 * t115 * t112 + 0.384e3 * t132 * t133;
  t142 = t81 * t141;
  t144 = t76 * t76;
  t147 = t93 / t144 * t21;
  t150 = -0.1e2 / 0.729e3 * t147 * t103 + 0.1e2 / 0.729e3 * t104;
  t152 = -0.1e2 / 0.729e3 * t104 + 0.3e1 * t106 * t119 - t124 * t142 + t75 * t150;
  t157 = my_piecewise3(t3, 0, -t7 * t89 * t83 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t152);
  tvrho0 = 0.2e1 * rho[0] * t157 + 0.2e1 * t87;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t160 = t25 * t28;
  t161 = t160 * t33;
  t162 = t97 * t161;
  t164 = t106 * t81;
  t165 = t28 * t33;
  t166 = t107 * t165;
  t169 = t115 * t165;
  t171 = t70 * t28;
  t173 = t132 * t171 * t33;
  t175 = -0.3e1 * t169 - 0.48e2 * t173;
  t176 = t81 * t175;
  t180 = 0.5e1 / 0.972e3 * t147 * t161 - 0.5e1 / 0.972e3 * t162;
  t182 = 0.5e1 / 0.972e3 * t162 + 0.3e1 * t164 * t166 - t124 * t176 + t75 * t180;
  t186 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t182);
  tvsigma0 = 0.2e1 * rho[0] * t186;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t188 = t28 * t44;
  t190 = t115 * t188;
  t192 = -0.8e1 * t107 * t188 + 0.8e1 * t190;
  t193 = t81 * t192;
  t202 = t137 * t28;
  t206 = 0.384e3 * t132 * t171 * t44 - 0.384e3 * t67 * t202 * t44 - 0.24e2 * t128 * t188 + 0.24e2 * t190;
  t207 = t81 * t206;
  t209 = 0.3e1 * t106 * t193 - t124 * t207;
  t213 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t209);
  tvtau0 = 0.2e1 * rho[0] * t213;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t216 = t18 * t44;
  t226 = t93 / t94 / t37 * t49;
  t228 = 0.1e1 / t23 / t22;
  t229 = sigma[0] * sigma[0];
  t230 = t228 * t229;
  t231 = t30 * t30;
  t232 = t231 * t99;
  t234 = 0.1e1 / t19 / t232;
  t235 = t27 * t234;
  t236 = t230 * t235;
  t238 = 0.4e3 / 0.531441e6 * t226 * t236;
  t240 = 0.1e1 / t31 / t231;
  t241 = t28 * t240;
  t242 = t98 * t241;
  t244 = 0.11e3 / 0.2187e4 * t97 * t242;
  t245 = t57 * t74;
  t246 = t118 * t118;
  t247 = t81 * t246;
  t250 = t58 * t123;
  t254 = t150 * t118;
  t257 = t112 * t112;
  t260 = t47 * t62;
  t261 = t260 * t112;
  t264 = t42 * t101;
  t268 = 0.4e2 / 0.9e1 * t264 - 0.11e2 / 0.9e1 * t29 * t240;
  t271 = t48 * t127;
  t272 = tau[0] * tau[0];
  t273 = t272 * t27;
  t274 = t231 * rho[0];
  t276 = 0.1e1 / t19 / t274;
  t277 = t273 * t276;
  t282 = -0.8e1 * t257 * t54 - 0.16e3 / 0.3e1 * t261 * t108 - 0.8e1 * t107 * t268 - 0.4e3 / 0.3e1 * t271 * t277 + 0.32e3 / 0.9e1 * t115 * t264;
  t283 = t81 * t282;
  t287 = 0.1e1 / t122 / t73;
  t288 = t59 * t287;
  t289 = t141 * t141;
  t290 = t81 * t289;
  t293 = t150 * t141;
  t298 = t271 * t112;
  t304 = 0.1e1 / t68 / t52;
  t305 = t60 * t304;
  t310 = params->b * t65;
  t311 = t70 * t257;
  t314 = t132 * t137;
  t315 = t112 * tau[0];
  t322 = t68 * t68;
  t323 = 0.1e1 / t322;
  t324 = t67 * t323;
  t329 = 0.48e2 * t260 * t257 + 0.24e3 * t298 * t108 + 0.24e2 * t115 * t268 + 0.16e4 / 0.3e1 * t305 * t277 - 0.32e3 / 0.3e1 * t128 * t264 + 0.192e4 * t310 * t311 + 0.768e4 * t314 * t315 * t165 + 0.384e3 * t132 * t70 * t268 + 0.448e5 / 0.3e1 * t324 * t277 - 0.512e4 / 0.3e1 * t138 * t264;
  t335 = t93 / t144 / t76 * t49;
  t340 = -0.4e3 / 0.531441e6 * t335 * t236 + 0.11e3 / 0.2187e4 * t147 * t242 + t238 - t244;
  t342 = -0.6e1 * t250 * t119 * t141 - t124 * t81 * t329 + 0.6e1 * t106 * t254 + 0.3e1 * t106 * t283 - 0.2e1 * t124 * t293 + 0.6e1 * t245 * t247 + 0.2e1 * t288 * t290 + t75 * t340 - t238 + t244;
  t347 = my_piecewise3(t3, 0, t7 * t216 * t83 / 0.12e2 - t7 * t89 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t342);
  tv2rho20 = 0.2e1 * rho[0] * t347 + 0.4e1 * t157;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t353 = t228 * t27;
  t354 = t231 * t30;
  t356 = 0.1e1 / t19 / t354;
  t358 = t353 * t356 * sigma[0];
  t360 = 0.5e2 / 0.177147e6 * t226 * t358;
  t361 = t160 * t101;
  t363 = 0.1e2 / 0.729e3 * t97 * t361;
  t364 = t81 * t47;
  t365 = t245 * t364;
  t366 = t54 * t28;
  t367 = t33 * t118;
  t368 = t366 * t367;
  t371 = t250 * t364;
  t373 = t366 * t33 * t141;
  t376 = t106 * t150;
  t379 = t112 * t54;
  t380 = t379 * t165;
  t383 = t106 * t364;
  t384 = t62 * t27;
  t386 = t384 * t276 * tau[0];
  t389 = t107 * t102;
  t398 = t150 * t175;
  t400 = t165 * t112;
  t401 = t260 * t400;
  t403 = t27 * t276;
  t404 = t403 * tau[0];
  t405 = t271 * t404;
  t407 = t115 * t102;
  t409 = t310 * t70;
  t410 = t409 * t400;
  t412 = t314 * t404;
  t415 = t132 * t171 * t101;
  t417 = -0.6e1 * t401 - 0.3e2 * t405 + 0.8e1 * t407 - 0.24e3 * t410 - 0.96e3 * t412 + 0.128e3 * t415;
  t418 = t81 * t417;
  t420 = t180 * t118;
  t423 = t180 * t141;
  t429 = 0.5e2 / 0.177147e6 * t335 * t358 - 0.1e2 / 0.729e3 * t147 * t361 - t360 + t363;
  t431 = -0.3e1 * t250 * t176 * t118 + 0.2e1 * t288 * t176 * t141 + 0.3e1 * t106 * t420 - t124 * t398 - t124 * t418 - t124 * t423 + 0.3e1 * t164 * t380 - 0.8e1 * t164 * t389 + 0.3e1 * t376 * t166 + 0.6e1 * t365 * t368 - 0.3e1 * t371 * t373 + 0.2e2 * t383 * t386 + t75 * t429 + t360 - t363;
  t436 = my_piecewise3(t3, 0, -t7 * t89 * t182 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t431);
  tv2rhosigma0 = 0.2e1 * rho[0] * t436 + 0.2e1 * t186;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t445 = t193 * t141;
  t448 = t150 * t192;
  t454 = 0.1e1 / t19 / t231;
  t455 = t27 * t454;
  t456 = t455 * tau[0];
  t460 = t188 * t112;
  t461 = t260 * t460;
  t463 = t271 * t456;
  t466 = -0.8e1 * t379 * t188 - 0.16e3 / 0.3e1 * t260 * t456 + 0.4e2 / 0.3e1 * t166 + 0.16e2 * t461 + 0.8e2 * t463 - 0.4e2 / 0.3e1 * t169;
  t467 = t81 * t466;
  t476 = t150 * t206;
  t499 = 0.64e3 * t67 * t202 * t33 + 0.4e2 * t128 * t165 - 0.72e2 * t271 * t460 - 0.32e3 * t305 * t456 + 0.768e4 * t314 * t456 - 0.2304e4 * t314 * t460 - 0.896e4 * t324 * t456 + 0.192e4 * t409 * t460 - 0.4e2 * t169 - 0.64e3 * t173 + 0.48e2 * t461 + 0.24e3 * t463;
  t500 = t81 * t499;
  t502 = 0.6e1 * t245 * t193 * t118 - 0.3e1 * t250 * t207 * t118 + 0.2e1 * t288 * t207 * t141 + 0.3e1 * t106 * t448 + 0.3e1 * t106 * t467 - t124 * t476 - t124 * t500 - 0.3e1 * t250 * t445;
  t507 = my_piecewise3(t3, 0, -t7 * t89 * t209 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t502);
  tv2rhotau0 = 0.2e1 * rho[0] * t507 + 0.2e1 * t213;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t510 = t353 * t276;
  t511 = t226 * t510;
  t513 = t245 * t81;
  t514 = t271 * t403;
  t517 = t33 * t175;
  t518 = t366 * t517;
  t521 = t106 * t180;
  t524 = t403 * t54;
  t527 = t175 * t175;
  t528 = t81 * t527;
  t531 = t180 * t175;
  t534 = t260 * t403;
  t536 = t70 * t27;
  t538 = t310 * t536 * t276;
  t540 = 0.3e1 / 0.2e1 * t534 + 0.6e2 * t538;
  t541 = t81 * t540;
  t545 = -0.25e2 / 0.236196e6 * t335 * t510 + 0.25e2 / 0.236196e6 * t511;
  t547 = -0.25e2 / 0.236196e6 * t511 + 0.12e2 * t513 * t514 - 0.6e1 * t371 * t518 + 0.6e1 * t521 * t166 - 0.3e1 / 0.4e1 * t164 * t524 + 0.2e1 * t288 * t528 - 0.2e1 * t124 * t531 - t124 * t541 + t75 * t545;
  t551 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t547);
  tv2sigma20 = 0.2e1 * rho[0] * t551;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t553 = t245 * t193;
  t556 = t193 * t175;
  t559 = t180 * t192;
  t562 = t455 * t54;
  t564 = t260 * t455;
  t566 = 0.2e1 * t562 - 0.4e1 * t564;
  t567 = t81 * t566;
  t570 = t250 * t207;
  t576 = t180 * t206;
  t579 = t271 * t455;
  t582 = t310 * t536 * t454;
  t584 = t137 * t27;
  t586 = t132 * t584 * t454;
  t588 = -0.12e2 * t564 + 0.18e2 * t579 - 0.48e3 * t582 + 0.576e3 * t586;
  t589 = t81 * t588;
  t591 = 0.2e1 * t288 * t207 * t175 + 0.3e1 * t106 * t559 + 0.3e1 * t106 * t567 - t124 * t576 - t124 * t589 + 0.6e1 * t553 * t166 - 0.3e1 * t570 * t166 - 0.3e1 * t250 * t556;
  t595 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t591);
  tv2sigmatau0 = 0.2e1 * rho[0] * t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t597 = t192 * t192;
  t598 = t81 * t597;
  t601 = t193 * t206;
  t605 = 0.1e1 / t19 / t99;
  t606 = t27 * t605;
  t609 = t260 * t606;
  t611 = t271 * t606;
  t613 = -0.16e2 * t606 * t54 + 0.64e2 * t609 - 0.48e2 * t611;
  t614 = t81 * t613;
  t617 = t206 * t206;
  t618 = t81 * t617;
  t631 = t323 * t27;
  t635 = -0.9216e4 * t132 * t584 * t605 + 0.384e4 * t310 * t536 * t605 + 0.5376e4 * t67 * t631 * t605 + 0.192e3 * t305 * t606 + 0.96e2 * t609 - 0.288e3 * t611;
  t636 = t81 * t635;
  t638 = 0.3e1 * t106 * t614 - t124 * t636 + 0.6e1 * t245 * t598 - 0.6e1 * t250 * t601 + 0.2e1 * t288 * t618;
  t642 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t638);
  tv2tau20 = 0.2e1 * rho[0] * t642;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  double t89, t93, t94, t97, t98, t99, t101, t102;
  double t103, t104, t106, t107, t108, t112, t115, t118;
  double t119, t122, t123, t124, t127, t128, t132, t133;
  double t137, t138, t141, t142, t144, t147, t150, t152;
  double t157, tvrho0, t160, t161, t162, t164, t165, t166;
  double t169, t171, t173, t175, t176, t180, t182, t186;
  double tvsigma0, tvlapl0, t188, t190, t192, t193, t202, t206;
  double t207, t209, t213, tvtau0;

  double t216, t226, t228, t229, t230, t231, t232, t234;
  double t235, t236, t238, t240, t241, t242, t244, t245;
  double t246, t247, t250, t254, t257, t260, t261, t264;
  double t268, t271, t272, t273, t274, t276, t277, t282;
  double t283, t287, t288, t289, t290, t293, t298, t304;
  double t305, t310, t311, t314, t315, t322, t323, t324;
  double t329, t335, t340, t342, t347, tv2rho20, t353, t354;
  double t356, t358, t360, t361, t363, t364, t365, t366;
  double t367, t368, t371, t373, t376, t379, t380, t383;
  double t384, t386, t389, t398, t400, t401, t403, t404;
  double t405, t407, t409, t410, t412, t415, t417, t418;
  double t420, t423, t429, t431, t436, tv2rhosigma0, tv2rholapl0, t445;
  double t448, t454, t455, t456, t460, t461, t463, t466;
  double t467, t476, t499, t500, t502, t507, tv2rhotau0, t510;
  double t511, t513, t514, t517, t518, t521, t524, t527;
  double t528, t531, t534, t536, t538, t540, t541, t545;
  double t547, t551, tv2sigma20, tv2sigmalapl0, t553, t556, t559, t562;
  double t564, t566, t567, t570, t576, t579, t582, t584;
  double t586, t588, t589, t591, t595, tv2sigmatau0, tv2lapl20, tv2lapltau0;
  double t597, t598, t601, t605, t606, t609, t611, t613;
  double t614, t617, t618, t631, t635, t636, t638, t642;
  double tv2tau20;

  double t645, t655, t656, t657, t658, t659, t665, t667;
  double t668, t669, t670, t671, t672, t673, t674, t675;
  double t677, t678, t694, t696, t700, t702, t706, t707;
  double t708, t712, t714, t715, t717, t731, t732, t740;
  double t741, t742, t743, t749, t753, t756, t757, t760;
  double t765, t766, t769, t772, t775, t776, t785, t786;
  double t789, t790, t800, t801, t805, t808, t809, t812;
  double t815, t818, t823, t826, t829, t842, t843, t846;
  double t847, t852, tv3rho30, t862, t863, t866, t867, t870;
  double t872, t876, t879, t880, t883, t884, t887, t888;
  double t891, t894, t897, t898, t901, t904, t905, t908;
  double t910, t915, t918, t920, t923, t925, t926, t930;
  double t933, t937, t939, t941, t942, t964, t978, t980;
  double t981, t982, t983, t985, t986, t988, t989, t991;
  double t992, t994, t995, t996, t998, t1000, t1001, t1002;
  double t1004, t1005, t1007, t1009, t1011, t1013, t1015, t1018;
  double t1020, t1021, t1023, t1026, t1029, t1031, t1037, t1038;
  double t1041, t1042, t1043, t1046, t1051, t1052, t1055, t1060;
  double t1063, t1066, t1067, t1070, t1072, t1077, tv3rho2sigma0, tv3rho2lapl0;
  double t1087, t1088, t1089, t1098, t1099, t1119, t1125, t1144;
  double t1146, t1152, t1154, t1155, t1156, t1165, t1170, t1173;
  double t1177, t1181, t1185, t1191, t1192, t1194, t1206, t1213;
  double t1214, t1215, t1217, t1220, t1225, t1231, t1241, t1242;
  double t1245, t1246, t1251, tv3rho2tau0, t1257, t1258, t1261, t1262;
  double t1263, t1264, t1267, t1274, t1275, t1278, t1281, t1285;
  double t1289, t1292, t1294, t1318, t1319, t1320, t1321, t1323;
  double t1326, t1330, t1331, t1333, t1334, t1339, t1340, t1343;
  double t1346, t1347, t1350, t1355, t1356, t1359, t1360, t1361;
  double t1367, t1370, t1371, t1374, t1375, t1378, t1383, t1386;
  double t1389, t1392, t1394, t1396, t1398, t1400, t1401, t1403;
  double t1405, t1408, t1410, t1411, t1413, t1415, t1420, tv3rhosigma20;
  double tv3rhosigmalapl0, t1428, t1429, t1430, t1433, t1434, t1435, t1440;
  double t1485, t1486, t1487, t1490, t1491, t1492, t1495, t1498;
  double t1501, t1503, t1504, t1507, t1508, t1510, t1513, t1515;
  double t1517, t1520, t1523, t1526, t1528, t1529, t1531, t1533;
  double t1535, t1539, t1540, t1545, t1546, t1549, t1551, t1554;
  double t1561, t1564, t1569, t1572, t1575, t1580, t1581, t1586;
  double tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t1594, t1597, t1600, t1603, t1604;
  double t1607, t1626, t1630, t1631, t1634, t1636, t1637, t1640;
  double t1641, t1643, t1646, t1647, t1656, t1668, t1684, t1691;
  double t1698, t1705, t1706, t1708, t1709, t1714, tv3rhotau20, t1717;
  double t1722, t1724, t1726, t1728, t1732, t1733, t1739, t1740;
  double t1744, t1747, t1750, t1754, t1755, t1757, t1758, t1760;
  double t1763, t1766, t1767, t1772, t1773, t1776, t1779, t1783;
  double tv3sigma30, tv3sigma2lapl0, t1813, t1816, t1818, t1821, t1823, t1825;
  double t1826, t1828, t1830, t1831, t1833, t1836, t1839, t1842;
  double t1847, t1850, t1851, t1856, t1857, t1861, t1862, t1863;
  double t1866, t1867, t1870, t1871, t1875, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0;
  double t1877, t1878, t1879, t1882, t1885, t1888, t1891, t1892;
  double t1893, t1896, t1908, t1915, t1919, t1921, t1922, t1925;
  double t1931, t1937, t1943, t1947, t1949, t1950, t1952, t1954;
  double t1956, t1957, t1959, t1960, t1964, tv3sigmatau20, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, t1966, t1967, t1970, t1973, t1985, t1987, t1988;
  double t1990, t1992, t1993, t1996, t1997, t2007, t2010, t2013;
  double t2016, t2019, t2020, t2022, t2026, tv3tau30;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t89 = t18 / t31;
  t93 = params->kappa * params->kappa;
  t94 = t37 * t37;
  t97 = t93 / t94 * t21;
  t98 = t25 * sigma[0];
  t99 = t30 * rho[0];
  t101 = 0.1e1 / t31 / t99;
  t102 = t28 * t101;
  t103 = t98 * t102;
  t104 = t97 * t103;
  t106 = t58 * t74;
  t107 = t47 * t54;
  t108 = t42 * t33;
  t112 = -0.5e1 / 0.3e1 * t108 + t29 * t101 / 0.3e1;
  t115 = t48 * t62;
  t118 = -0.8e1 * t107 * t112 - 0.4e2 / 0.3e1 * t115 * t108;
  t119 = t81 * t118;
  t122 = t73 * t73;
  t123 = 0.1e1 / t122;
  t124 = t59 * t123;
  t127 = 0.1e1 / t68;
  t128 = t60 * t127;
  t132 = params->b * t65 * t47;
  t133 = t70 * t112;
  t137 = 0.1e1 / t68 / t61;
  t138 = t67 * t137;
  t141 = 0.4e2 * t128 * t108 + 0.64e3 * t138 * t108 + 0.24e2 * t115 * t112 + 0.384e3 * t132 * t133;
  t142 = t81 * t141;
  t144 = t76 * t76;
  t147 = t93 / t144 * t21;
  t150 = -0.1e2 / 0.729e3 * t147 * t103 + 0.1e2 / 0.729e3 * t104;
  t152 = -0.1e2 / 0.729e3 * t104 + 0.3e1 * t106 * t119 - t124 * t142 + t75 * t150;
  t157 = my_piecewise3(t3, 0, -t7 * t89 * t83 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t152);
  tvrho0 = 0.2e1 * rho[0] * t157 + 0.2e1 * t87;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t160 = t25 * t28;
  t161 = t160 * t33;
  t162 = t97 * t161;
  t164 = t106 * t81;
  t165 = t28 * t33;
  t166 = t107 * t165;
  t169 = t115 * t165;
  t171 = t70 * t28;
  t173 = t132 * t171 * t33;
  t175 = -0.3e1 * t169 - 0.48e2 * t173;
  t176 = t81 * t175;
  t180 = 0.5e1 / 0.972e3 * t147 * t161 - 0.5e1 / 0.972e3 * t162;
  t182 = 0.5e1 / 0.972e3 * t162 + 0.3e1 * t164 * t166 - t124 * t176 + t75 * t180;
  t186 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t182);
  tvsigma0 = 0.2e1 * rho[0] * t186;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t188 = t28 * t44;
  t190 = t115 * t188;
  t192 = -0.8e1 * t107 * t188 + 0.8e1 * t190;
  t193 = t81 * t192;
  t202 = t137 * t28;
  t206 = 0.384e3 * t132 * t171 * t44 - 0.384e3 * t67 * t202 * t44 - 0.24e2 * t128 * t188 + 0.24e2 * t190;
  t207 = t81 * t206;
  t209 = 0.3e1 * t106 * t193 - t124 * t207;
  t213 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t209);
  tvtau0 = 0.2e1 * rho[0] * t213;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t216 = t18 * t44;
  t226 = t93 / t94 / t37 * t49;
  t228 = 0.1e1 / t23 / t22;
  t229 = sigma[0] * sigma[0];
  t230 = t228 * t229;
  t231 = t30 * t30;
  t232 = t231 * t99;
  t234 = 0.1e1 / t19 / t232;
  t235 = t27 * t234;
  t236 = t230 * t235;
  t238 = 0.4e3 / 0.531441e6 * t226 * t236;
  t240 = 0.1e1 / t31 / t231;
  t241 = t28 * t240;
  t242 = t98 * t241;
  t244 = 0.11e3 / 0.2187e4 * t97 * t242;
  t245 = t57 * t74;
  t246 = t118 * t118;
  t247 = t81 * t246;
  t250 = t58 * t123;
  t254 = t150 * t118;
  t257 = t112 * t112;
  t260 = t47 * t62;
  t261 = t260 * t112;
  t264 = t42 * t101;
  t268 = 0.4e2 / 0.9e1 * t264 - 0.11e2 / 0.9e1 * t29 * t240;
  t271 = t48 * t127;
  t272 = tau[0] * tau[0];
  t273 = t272 * t27;
  t274 = t231 * rho[0];
  t276 = 0.1e1 / t19 / t274;
  t277 = t273 * t276;
  t282 = -0.8e1 * t257 * t54 - 0.16e3 / 0.3e1 * t261 * t108 - 0.8e1 * t107 * t268 - 0.4e3 / 0.3e1 * t271 * t277 + 0.32e3 / 0.9e1 * t115 * t264;
  t283 = t81 * t282;
  t287 = 0.1e1 / t122 / t73;
  t288 = t59 * t287;
  t289 = t141 * t141;
  t290 = t81 * t289;
  t293 = t150 * t141;
  t298 = t271 * t112;
  t304 = 0.1e1 / t68 / t52;
  t305 = t60 * t304;
  t310 = params->b * t65;
  t311 = t70 * t257;
  t314 = t132 * t137;
  t315 = t112 * tau[0];
  t322 = t68 * t68;
  t323 = 0.1e1 / t322;
  t324 = t67 * t323;
  t329 = 0.48e2 * t260 * t257 + 0.24e3 * t298 * t108 + 0.24e2 * t115 * t268 + 0.16e4 / 0.3e1 * t305 * t277 - 0.32e3 / 0.3e1 * t128 * t264 + 0.192e4 * t310 * t311 + 0.768e4 * t314 * t315 * t165 + 0.384e3 * t132 * t70 * t268 + 0.448e5 / 0.3e1 * t324 * t277 - 0.512e4 / 0.3e1 * t138 * t264;
  t335 = t93 / t144 / t76 * t49;
  t340 = -0.4e3 / 0.531441e6 * t335 * t236 + 0.11e3 / 0.2187e4 * t147 * t242 + t238 - t244;
  t342 = -0.6e1 * t250 * t119 * t141 - t124 * t81 * t329 + 0.6e1 * t106 * t254 + 0.3e1 * t106 * t283 - 0.2e1 * t124 * t293 + 0.6e1 * t245 * t247 + 0.2e1 * t288 * t290 + t75 * t340 - t238 + t244;
  t347 = my_piecewise3(t3, 0, t7 * t216 * t83 / 0.12e2 - t7 * t89 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t342);
  tv2rho20 = 0.2e1 * rho[0] * t347 + 0.4e1 * t157;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t353 = t228 * t27;
  t354 = t231 * t30;
  t356 = 0.1e1 / t19 / t354;
  t358 = t353 * t356 * sigma[0];
  t360 = 0.5e2 / 0.177147e6 * t226 * t358;
  t361 = t160 * t101;
  t363 = 0.1e2 / 0.729e3 * t97 * t361;
  t364 = t81 * t47;
  t365 = t245 * t364;
  t366 = t54 * t28;
  t367 = t33 * t118;
  t368 = t366 * t367;
  t371 = t250 * t364;
  t373 = t366 * t33 * t141;
  t376 = t106 * t150;
  t379 = t112 * t54;
  t380 = t379 * t165;
  t383 = t106 * t364;
  t384 = t62 * t27;
  t386 = t384 * t276 * tau[0];
  t389 = t107 * t102;
  t398 = t150 * t175;
  t400 = t165 * t112;
  t401 = t260 * t400;
  t403 = t27 * t276;
  t404 = t403 * tau[0];
  t405 = t271 * t404;
  t407 = t115 * t102;
  t409 = t310 * t70;
  t410 = t409 * t400;
  t412 = t314 * t404;
  t415 = t132 * t171 * t101;
  t417 = -0.6e1 * t401 - 0.3e2 * t405 + 0.8e1 * t407 - 0.24e3 * t410 - 0.96e3 * t412 + 0.128e3 * t415;
  t418 = t81 * t417;
  t420 = t180 * t118;
  t423 = t180 * t141;
  t429 = 0.5e2 / 0.177147e6 * t335 * t358 - 0.1e2 / 0.729e3 * t147 * t361 - t360 + t363;
  t431 = -0.3e1 * t250 * t176 * t118 + 0.2e1 * t288 * t176 * t141 + 0.3e1 * t106 * t420 - t124 * t398 - t124 * t418 - t124 * t423 + 0.3e1 * t164 * t380 - 0.8e1 * t164 * t389 + 0.3e1 * t376 * t166 + 0.6e1 * t365 * t368 - 0.3e1 * t371 * t373 + 0.2e2 * t383 * t386 + t75 * t429 + t360 - t363;
  t436 = my_piecewise3(t3, 0, -t7 * t89 * t182 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t431);
  tv2rhosigma0 = 0.2e1 * rho[0] * t436 + 0.2e1 * t186;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t445 = t193 * t141;
  t448 = t150 * t192;
  t454 = 0.1e1 / t19 / t231;
  t455 = t27 * t454;
  t456 = t455 * tau[0];
  t460 = t188 * t112;
  t461 = t260 * t460;
  t463 = t271 * t456;
  t466 = -0.8e1 * t379 * t188 - 0.16e3 / 0.3e1 * t260 * t456 + 0.4e2 / 0.3e1 * t166 + 0.16e2 * t461 + 0.8e2 * t463 - 0.4e2 / 0.3e1 * t169;
  t467 = t81 * t466;
  t476 = t150 * t206;
  t499 = 0.64e3 * t67 * t202 * t33 + 0.4e2 * t128 * t165 - 0.72e2 * t271 * t460 - 0.32e3 * t305 * t456 + 0.768e4 * t314 * t456 - 0.2304e4 * t314 * t460 - 0.896e4 * t324 * t456 + 0.192e4 * t409 * t460 - 0.4e2 * t169 - 0.64e3 * t173 + 0.48e2 * t461 + 0.24e3 * t463;
  t500 = t81 * t499;
  t502 = 0.6e1 * t245 * t193 * t118 - 0.3e1 * t250 * t207 * t118 + 0.2e1 * t288 * t207 * t141 + 0.3e1 * t106 * t448 + 0.3e1 * t106 * t467 - t124 * t476 - t124 * t500 - 0.3e1 * t250 * t445;
  t507 = my_piecewise3(t3, 0, -t7 * t89 * t209 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t502);
  tv2rhotau0 = 0.2e1 * rho[0] * t507 + 0.2e1 * t213;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t510 = t353 * t276;
  t511 = t226 * t510;
  t513 = t245 * t81;
  t514 = t271 * t403;
  t517 = t33 * t175;
  t518 = t366 * t517;
  t521 = t106 * t180;
  t524 = t403 * t54;
  t527 = t175 * t175;
  t528 = t81 * t527;
  t531 = t180 * t175;
  t534 = t260 * t403;
  t536 = t70 * t27;
  t538 = t310 * t536 * t276;
  t540 = 0.3e1 / 0.2e1 * t534 + 0.6e2 * t538;
  t541 = t81 * t540;
  t545 = -0.25e2 / 0.236196e6 * t335 * t510 + 0.25e2 / 0.236196e6 * t511;
  t547 = -0.25e2 / 0.236196e6 * t511 + 0.12e2 * t513 * t514 - 0.6e1 * t371 * t518 + 0.6e1 * t521 * t166 - 0.3e1 / 0.4e1 * t164 * t524 + 0.2e1 * t288 * t528 - 0.2e1 * t124 * t531 - t124 * t541 + t75 * t545;
  t551 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t547);
  tv2sigma20 = 0.2e1 * rho[0] * t551;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t553 = t245 * t193;
  t556 = t193 * t175;
  t559 = t180 * t192;
  t562 = t455 * t54;
  t564 = t260 * t455;
  t566 = 0.2e1 * t562 - 0.4e1 * t564;
  t567 = t81 * t566;
  t570 = t250 * t207;
  t576 = t180 * t206;
  t579 = t271 * t455;
  t582 = t310 * t536 * t454;
  t584 = t137 * t27;
  t586 = t132 * t584 * t454;
  t588 = -0.12e2 * t564 + 0.18e2 * t579 - 0.48e3 * t582 + 0.576e3 * t586;
  t589 = t81 * t588;
  t591 = 0.2e1 * t288 * t207 * t175 + 0.3e1 * t106 * t559 + 0.3e1 * t106 * t567 - t124 * t576 - t124 * t589 + 0.6e1 * t553 * t166 - 0.3e1 * t570 * t166 - 0.3e1 * t250 * t556;
  t595 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t591);
  tv2sigmatau0 = 0.2e1 * rho[0] * t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t597 = t192 * t192;
  t598 = t81 * t597;
  t601 = t193 * t206;
  t605 = 0.1e1 / t19 / t99;
  t606 = t27 * t605;
  t609 = t260 * t606;
  t611 = t271 * t606;
  t613 = -0.16e2 * t606 * t54 + 0.64e2 * t609 - 0.48e2 * t611;
  t614 = t81 * t613;
  t617 = t206 * t206;
  t618 = t81 * t617;
  t631 = t323 * t27;
  t635 = -0.9216e4 * t132 * t584 * t605 + 0.384e4 * t310 * t536 * t605 + 0.5376e4 * t67 * t631 * t605 + 0.192e3 * t305 * t606 + 0.96e2 * t609 - 0.288e3 * t611;
  t636 = t81 * t635;
  t638 = 0.3e1 * t106 * t614 - t124 * t636 + 0.6e1 * t245 * t598 - 0.6e1 * t250 * t601 + 0.2e1 * t288 * t618;
  t642 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t638);
  tv2tau20 = 0.2e1 * rho[0] * t642;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t645 = t18 * t33;
  t655 = t122 * t122;
  t656 = 0.1e1 / t655;
  t657 = t59 * t656;
  t658 = t289 * t141;
  t659 = t81 * t658;
  t665 = t94 * t94;
  t667 = t93 / t665;
  t668 = t22 * t22;
  t669 = 0.1e1 / t668;
  t670 = t229 * sigma[0];
  t671 = t669 * t670;
  t672 = t231 * t231;
  t673 = t672 * t99;
  t674 = 0.1e1 / t673;
  t675 = t671 * t674;
  t677 = 0.16e5 / 0.43046721e8 * t667 * t675;
  t678 = t57 * t123;
  t694 = t144 * t144;
  t696 = t93 / t694;
  t700 = 0.1e1 / t19 / t672;
  t702 = t230 * t27 * t700;
  t706 = 0.1e1 / t31 / t274;
  t707 = t28 * t706;
  t708 = t98 * t707;
  t712 = 0.44e4 / 0.531441e6 * t226 * t702;
  t714 = 0.154e4 / 0.6561e4 * t97 * t708;
  t715 = -0.16e5 / 0.43046721e8 * t696 * t675 + 0.44e4 / 0.531441e6 * t335 * t702 - 0.154e4 / 0.6561e4 * t147 * t708 + t677 - t712 + t714;
  t717 = t58 * t287;
  t731 = params->b * t60;
  t732 = t257 * t112;
  t740 = 0.1e1 / t322 / t52;
  t741 = t272 * tau[0];
  t742 = t740 * t741;
  t743 = 0.1e1 / t672;
  t749 = t42 * t240;
  t753 = -0.44e3 / 0.27e2 * t749 + 0.154e3 / 0.27e2 * t29 * t706;
  t756 = t48 * t304;
  t757 = t756 * t112;
  t760 = t273 * t356;
  t765 = t47 * t127;
  t766 = t765 * t257;
  t769 = t271 * t268;
  t772 = t112 * t268;
  t775 = t60 * t70;
  t776 = t741 * t743;
  t785 = t268 * tau[0];
  t786 = t785 * t165;
  t789 = t132 * t323;
  t790 = t112 * t272;
  t800 = t310 * t137;
  t801 = t257 * tau[0];
  t805 = 0.768e4 * t731 * t70 * t732 + 0.576e4 * t310 * t133 * t268 + 0.3584e7 / 0.9e1 * t67 * t742 * t743 + 0.48e2 * t732 * t62 + 0.24e2 * t115 * t753 + 0.48e4 * t757 * t277 - 0.128e5 / 0.3e1 * t305 * t760 + 0.352e4 / 0.9e1 * t128 * t749 + 0.72e3 * t766 * t108 + 0.36e3 * t769 * t108 + 0.144e3 * t260 * t772 + 0.8e5 / 0.9e1 * t775 * t776 + 0.384e3 * t132 * t70 * t753 - 0.3072e5 * t314 * t315 * t102 + 0.1152e5 * t314 * t786 + 0.2688e6 * t789 * t790 * t403 - 0.3584e6 / 0.3e1 * t324 * t760 + 0.5632e5 / 0.9e1 * t138 * t749 - 0.96e3 * t298 * t264 + 0.576e5 * t800 * t801 * t165;
  t808 = t246 * t118;
  t809 = t808 * t74;
  t812 = t150 * t246;
  t815 = t340 * t118;
  t818 = t150 * t282;
  t823 = t257 * t62;
  t826 = t765 * t112;
  t829 = t260 * t268;
  t842 = -0.24e2 * t379 * t268 - 0.8e2 * t823 * t108 - 0.8e3 * t826 * t277 - 0.8e2 * t829 * t108 + 0.64e3 / 0.3e1 * t261 * t264 - 0.8e1 * t107 * t753 - 0.16e5 / 0.9e1 * t756 * t776 + 0.32e4 / 0.3e1 * t271 * t760 - 0.352e4 / 0.27e2 * t115 * t749;
  t843 = t81 * t842;
  t846 = -0.3e1 * t124 * t340 * t141 - 0.3e1 * t124 * t150 * t329 - t124 * t81 * t805 + 0.6e1 * t288 * t150 * t289 + 0.9e1 * t106 * t815 + 0.9e1 * t106 * t818 + 0.3e1 * t106 * t843 + 0.18e2 * t245 * t812 + 0.6e1 * t809 * t81 + t712 - t714;
  t847 = 0.18e2 * t245 * t119 * t282 - 0.9e1 * t250 * t119 * t329 + 0.18e2 * t717 * t119 * t289 - 0.18e2 * t678 * t247 * t141 - 0.18e2 * t250 * t254 * t141 - 0.9e1 * t250 * t283 * t141 + 0.6e1 * t288 * t142 * t329 - 0.6e1 * t657 * t659 + t75 * t715 - t677 + t846;
  t852 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t645 * t83 + t7 * t216 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t89 * t342 - 0.3e1 / 0.8e1 * t7 * t20 * t847);
  tv3rho30 = 0.2e1 * rho[0] * t852 + 0.6e1 * t347;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t862 = t356 * tau[0];
  t863 = t384 * t862;
  t866 = t101 * t118;
  t867 = t366 * t866;
  t870 = t717 * t364;
  t872 = t366 * t33 * t289;
  t876 = t366 * t101 * t141;
  t879 = t150 * t47;
  t880 = t245 * t879;
  t883 = t81 * t112;
  t884 = t245 * t883;
  t887 = t33 * t282;
  t888 = t366 * t887;
  t891 = t250 * t879;
  t894 = t250 * t883;
  t897 = t33 * t329;
  t898 = t366 * t897;
  t901 = t106 * t879;
  t904 = -0.32e2 * t365 * t867 + 0.6e1 * t365 * t888 + 0.12e2 * t880 * t368 + 0.12e2 * t884 * t368 + 0.16e2 * t371 * t876 - 0.3e1 * t371 * t898 - 0.6e1 * t891 * t373 - 0.6e1 * t894 * t373 - 0.16e3 * t383 * t863 + 0.4e2 * t901 * t386 + 0.6e1 * t870 * t872;
  t905 = t106 * t883;
  t908 = t678 * t364;
  t910 = t366 * t367 * t141;
  t915 = t384 * t276 * t118 * tau[0];
  t918 = t276 * t141;
  t920 = t384 * t918 * tau[0];
  t923 = t672 * t30;
  t925 = t669 / t923;
  t926 = t925 * t229;
  t930 = t353 * t234 * sigma[0];
  t933 = t160 * t240;
  t937 = 0.2e4 / 0.14348907e8 * t667 * t926;
  t939 = 0.5e2 / 0.19683e5 * t226 * t930;
  t941 = 0.11e3 / 0.2187e4 * t97 * t933;
  t942 = 0.2e4 / 0.14348907e8 * t696 * t926 - 0.5e2 / 0.19683e5 * t335 * t930 + 0.11e3 / 0.2187e4 * t147 * t933 - t937 + t939 - t941;
  t964 = -0.6e1 * t250 * t418 * t118 - 0.2e1 * t124 * t429 * t141 - t124 * t180 * t329 - 0.6e1 * t250 * t420 * t141 - 0.6e1 * t678 * t176 * t246 - 0.3e1 * t250 * t176 * t282 - 0.6e1 * t657 * t176 * t289 + 0.8e2 * t365 * t915 - 0.4e2 * t371 * t920 + 0.4e2 * t905 * t386 + t75 * t942 - 0.12e2 * t908 * t910;
  t978 = t823 * t165;
  t980 = t765 * t27;
  t981 = t276 * t112;
  t982 = t981 * tau[0];
  t983 = t980 * t982;
  t985 = t102 * t112;
  t986 = t260 * t985;
  t988 = t165 * t268;
  t989 = t260 * t988;
  t991 = t743 * t272;
  t992 = t756 * t991;
  t994 = t27 * t356;
  t995 = t994 * tau[0];
  t996 = t271 * t995;
  t998 = t115 * t241;
  t1000 = t731 * t70;
  t1001 = t165 * t257;
  t1002 = t1000 * t1001;
  t1004 = t403 * t315;
  t1005 = t800 * t1004;
  t1007 = t409 * t985;
  t1009 = t409 * t988;
  t1011 = t323 * t743;
  t1013 = t132 * t1011 * t272;
  t1015 = t314 * t995;
  t1018 = t132 * t171 * t240;
  t1020 = -0.6e1 * t978 - 0.12e3 * t983 + 0.32e2 * t986 - 0.6e1 * t989 - 0.4e3 * t992 + 0.24e3 * t996 - 0.88e2 / 0.3e1 * t998 - 0.96e3 * t1002 - 0.96e4 * t1005 + 0.128e4 * t1007 - 0.24e3 * t1009 - 0.224e5 * t1013 + 0.768e4 * t1015 - 0.1408e4 / 0.3e1 * t1018;
  t1021 = t81 * t1020;
  t1023 = t429 * t118;
  t1026 = t180 * t282;
  t1029 = t340 * t175;
  t1031 = t150 * t417;
  t1037 = -0.6e1 * t250 * t398 * t118 + 0.4e1 * t288 * t398 * t141 + 0.4e1 * t288 * t418 * t141 + 0.2e1 * t288 * t176 * t329 + 0.2e1 * t288 * t180 * t289 - t124 * t1021 + 0.6e1 * t106 * t1023 + 0.3e1 * t106 * t1026 - t124 * t1029 - 0.2e1 * t124 * t1031 + t937;
  t1038 = t180 * t246;
  t1041 = t717 * t81;
  t1042 = t175 * t118;
  t1043 = t1042 * t141;
  t1046 = t106 * t340;
  t1051 = t268 * t54;
  t1052 = t1051 * t165;
  t1055 = t765 * t991;
  t1060 = t379 * t102;
  t1063 = t107 * t241;
  t1066 = t246 * t74;
  t1067 = t1066 * t81;
  t1070 = 0.6e1 * t245 * t1038 + t941 + 0.12e2 * t1041 * t1043 + 0.3e1 * t1046 * t166 + 0.6e1 * t376 * t380 + 0.3e1 * t164 * t1052 + 0.2e3 * t164 * t1055 - 0.16e2 * t376 * t389 - 0.16e2 * t164 * t1060 + 0.88e2 / 0.3e1 * t164 * t1063 - t939 + 0.6e1 * t1067 * t166;
  t1072 = t904 + t964 + t1037 + t1070;
  t1077 = my_piecewise3(t3, 0, t7 * t216 * t182 / 0.12e2 - t7 * t89 * t431 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1072);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t1077 + 0.4e1 * t436;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1087 = t678 * t81;
  t1088 = t192 * t118;
  t1089 = t1088 * t141;
  t1098 = t206 * t118;
  t1099 = t1098 * t141;
  t1119 = t193 * t282;
  t1125 = 0.12e2 * t245 * t448 * t118 + 0.12e2 * t245 * t467 * t118 - 0.6e1 * t250 * t448 * t141 + 0.4e1 * t288 * t500 * t141 + 0.6e1 * t717 * t193 * t289 - 0.6e1 * t678 * t207 * t246 + 0.2e1 * t288 * t207 * t329 - 0.6e1 * t657 * t207 * t289 + 0.12e2 * t1041 * t1099 + 0.6e1 * t1066 * t193 - 0.12e2 * t1087 * t1089 + 0.6e1 * t245 * t1119;
  t1144 = t340 * t206;
  t1146 = t150 * t499;
  t1152 = t823 * t188;
  t1154 = 0.1e1 / t232;
  t1155 = t1154 * t272;
  t1156 = t756 * t1155;
  t1165 = t188 * t257;
  t1170 = t188 * t268;
  t1173 = t323 * t1154;
  t1177 = t740 * t1154;
  t1181 = t260 * t1170;
  t1185 = 0.32e3 / 0.3e1 * t407 - 0.32e3 / 0.3e1 * t128 * t102 + 0.48e2 * t1152 + 0.32e4 * t1156 - 0.16e5 / 0.3e1 * t775 * t1155 + 0.192e4 * t305 * t404 - 0.512e4 / 0.3e1 * t67 * t202 * t101 - 0.144e3 * t765 * t1165 + 0.24e3 * t271 * t400 - 0.72e2 * t271 * t1170 + 0.1792e6 * t132 * t1173 * t272 - 0.7168e6 / 0.3e1 * t67 * t1177 * t272 + 0.48e2 * t1181 + 0.5376e5 * t324 * t404;
  t1191 = t454 * t112 * tau[0];
  t1192 = t980 * t1191;
  t1194 = t756 * t27;
  t1206 = t455 * t315;
  t1213 = 0.192e4 * t409 * t1170 - 0.2304e4 * t314 * t1170 + 0.96e3 * t1192 - 0.192e4 * t1194 * t1191 + 0.768e4 * t1000 * t1165 - 0.1152e5 * t800 * t1165 + 0.768e4 * t314 * t400 - 0.16e3 * t401 - 0.144e4 * t405 + 0.512e4 / 0.3e1 * t415 + 0.768e5 * t800 * t1206 - 0.10752e6 * t789 * t1206 - 0.64e4 * t410 - 0.4608e5 * t412;
  t1214 = t1185 + t1213;
  t1215 = t81 * t1214;
  t1217 = t340 * t192;
  t1220 = t150 * t466;
  t1225 = t112 * t62;
  t1231 = t260 * t404;
  t1241 = -0.8e1 * t1051 * t188 - 0.32e3 / 0.3e1 * t1225 * t456 + 0.8e2 / 0.3e1 * t380 - 0.16e4 / 0.3e1 * t765 * t1155 + 0.32e3 * t1231 - 0.32e3 / 0.9e1 * t389 + 0.16e2 * t1152 + 0.32e3 * t1192 - 0.16e3 / 0.3e1 * t401 + 0.16e2 * t1181 + 0.32e4 / 0.3e1 * t1156 - 0.48e3 * t405 + 0.32e3 / 0.9e1 * t407;
  t1242 = t81 * t1241;
  t1245 = -0.6e1 * t250 * t476 * t118 - 0.6e1 * t250 * t500 * t118 - 0.6e1 * t250 * t467 * t141 + 0.4e1 * t288 * t476 * t141 - 0.3e1 * t250 * t193 * t329 - 0.3e1 * t250 * t207 * t282 + 0.3e1 * t106 * t1217 + 0.6e1 * t106 * t1220 + 0.3e1 * t106 * t1242 - t124 * t1144 - 0.2e1 * t124 * t1146 - t124 * t1215;
  t1246 = t1125 + t1245;
  t1251 = my_piecewise3(t3, 0, t7 * t216 * t209 / 0.12e2 - t7 * t89 * t502 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1246);
  tv3rho2tau0 = 0.2e1 * rho[0] * t1251 + 0.4e1 * t507;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1257 = t180 * t47;
  t1258 = t106 * t1257;
  t1261 = t81 * t48;
  t1262 = t678 * t1261;
  t1263 = t127 * t27;
  t1264 = t1263 * t918;
  t1267 = t1263 * t981;
  t1274 = t33 * t417;
  t1275 = t366 * t1274;
  t1278 = t245 * t1257;
  t1281 = t250 * t1257;
  t1285 = t366 * t517 * t118;
  t1289 = t366 * t517 * t141;
  t1292 = t276 * t175;
  t1294 = t384 * t1292 * tau[0];
  t1318 = t672 * rho[0];
  t1319 = 0.1e1 / t1318;
  t1320 = t669 * t1319;
  t1321 = t1320 * sigma[0];
  t1323 = 0.25e3 / 0.4782969e7 * t667 * t1321;
  t1326 = t353 * t356;
  t1330 = 0.1e3 / 0.177147e6 * t226 * t1326;
  t1331 = -0.25e3 / 0.4782969e7 * t696 * t1321 + 0.1e3 / 0.177147e6 * t335 * t1326 + t1323 - t1330;
  t1333 = 0.4e2 * t1258 * t386 - 0.12e2 * t1262 * t1264 + 0.24e2 * t365 * t1267 - 0.6e1 * t891 * t518 - 0.6e1 * t894 * t518 - 0.6e1 * t371 * t1275 + 0.12e2 * t1278 * t368 - 0.6e1 * t1281 * t373 - 0.12e2 * t908 * t1285 + 0.12e2 * t870 * t1289 - 0.4e2 * t371 * t1294 + 0.4e1 * t288 * t531 * t141 - 0.3e1 * t250 * t541 * t118 + 0.2e1 * t288 * t541 * t141 - 0.6e1 * t657 * t528 * t141 + 0.4e1 * t288 * t176 * t417 - 0.6e1 * t250 * t531 * t118 + 0.6e1 * t717 * t528 * t118 - t1323 + t75 * t1331;
  t1334 = t994 * t54;
  t1339 = t743 * t62;
  t1340 = t1339 * tau[0];
  t1343 = t245 * t150;
  t1346 = t743 * tau[0];
  t1347 = t756 * t1346;
  t1350 = t106 * t429;
  t1355 = t54 * t118;
  t1356 = t403 * t1355;
  t1359 = t250 * t81;
  t1360 = t54 * t141;
  t1361 = t403 * t1360;
  t1367 = t271 * t994;
  t1370 = t118 * t74;
  t1371 = t1370 * t81;
  t1374 = t101 * t175;
  t1375 = t366 * t1374;
  t1378 = t545 * t118;
  t1383 = t150 * t527;
  t1386 = t429 * t175;
  t1389 = t180 * t417;
  t1392 = t150 * t540;
  t1394 = t1225 * t403;
  t1396 = t765 * t1346;
  t1398 = t260 * t994;
  t1400 = t403 * t112;
  t1401 = t1000 * t1400;
  t1403 = t137 * t743;
  t1405 = t310 * t1403 * tau[0];
  t1408 = t310 * t536 * t356;
  t1410 = 0.3e1 / 0.2e1 * t1394 + 0.15e2 * t1396 - 0.8e1 * t1398 + 0.24e3 * t1401 + 0.12e4 * t1405 - 0.32e3 * t1408;
  t1411 = t81 * t1410;
  t1413 = -t124 * t545 * t141 + 0.3e1 * t106 * t1378 - 0.2e1 * t124 * t1386 - 0.2e1 * t124 * t1389 - t124 * t1392 - t124 * t1411 - 0.64e2 * t513 * t1367 + 0.12e2 * t1371 * t514 + 0.16e2 * t371 * t1375 + 0.2e1 * t288 * t1383 - 0.16e2 * t521 * t389;
  t1415 = t1333 + 0.4e1 * t164 * t1334 - 0.3e1 / 0.4e1 * t376 * t524 - 0.5e1 * t164 * t1340 + t1330 + 0.12e2 * t1343 * t514 + 0.16e3 * t513 * t1347 + 0.6e1 * t1350 * t166 + 0.6e1 * t521 * t380 - 0.3e1 / 0.2e1 * t513 * t1356 + 0.3e1 / 0.4e1 * t1359 * t1361 + t1413;
  t1420 = my_piecewise3(t3, 0, -t7 * t89 * t547 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1415);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1420 + 0.2e1 * t551;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1428 = t678 * t207;
  t1429 = t165 * t118;
  t1430 = t107 * t1429;
  t1433 = t717 * t207;
  t1434 = t165 * t141;
  t1435 = t107 * t1434;
  t1440 = t678 * t193;
  t1485 = t657 * t81;
  t1486 = t206 * t175;
  t1487 = t1486 * t141;
  t1490 = 0.6e1 * t245 * t559 * t118 + 0.6e1 * t245 * t567 * t118 - 0.3e1 * t250 * t576 * t118 - 0.3e1 * t250 * t589 * t118 - 0.3e1 * t250 * t559 * t141 - 0.3e1 * t250 * t567 * t141 + 0.2e1 * t288 * t576 * t141 + 0.2e1 * t288 * t589 * t141 - 0.3e1 * t250 * t448 * t175 - 0.3e1 * t250 * t467 * t175 + 0.2e1 * t288 * t476 * t175 + 0.2e1 * t288 * t500 * t175 - 0.3e1 * t250 * t193 * t417 + 0.2e1 * t288 * t207 * t417 + 0.4e2 * t553 * t1231 - 0.2e2 * t570 * t1231 - 0.6e1 * t1428 * t1430 + 0.6e1 * t1433 * t1435 - 0.6e1 * t1440 * t1435 - 0.6e1 * t1485 * t1487;
  t1491 = t192 * t175;
  t1492 = t1491 * t118;
  t1495 = t1491 * t141;
  t1498 = t1486 * t118;
  t1501 = t1225 * t455;
  t1503 = t1154 * tau[0];
  t1504 = t765 * t1503;
  t1507 = t455 * t112;
  t1508 = t765 * t1507;
  t1510 = t756 * t1503;
  t1513 = t1000 * t1507;
  t1515 = t137 * t1154;
  t1517 = t310 * t1515 * tau[0];
  t1520 = t800 * t1507;
  t1523 = t132 * t1173 * tau[0];
  t1526 = t132 * t584 * t276;
  t1528 = -0.12e2 * t1501 - 0.12e3 * t1504 + 0.52e2 * t534 + 0.36e2 * t1508 + 0.24e3 * t1510 - 0.78e2 * t514 - 0.192e4 * t1513 - 0.96e4 * t1517 + 0.208e4 * t538 + 0.288e4 * t1520 + 0.1344e5 * t1523 - 0.2496e4 * t1526;
  t1529 = t81 * t1528;
  t1531 = t180 * t499;
  t1533 = t150 * t588;
  t1535 = t150 * t566;
  t1539 = t1154 * t62;
  t1540 = t1539 * tau[0];
  t1545 = -0.26e2 / 0.3e1 * t524 + 0.4e2 / 0.3e1 * t1540 - 0.4e1 * t1501 - 0.4e2 * t1504 + 0.52e2 / 0.3e1 * t534;
  t1546 = t81 * t1545;
  t1549 = t429 * t206;
  t1551 = t429 * t192;
  t1554 = t180 * t466;
  t1561 = t250 * t476;
  t1564 = t250 * t500;
  t1569 = t1370 * t193;
  t1572 = t245 * t448;
  t1575 = t245 * t467;
  t1580 = 0.6e1 * t1041 * t1495 + 0.6e1 * t1041 * t1498 + 0.3e1 * t106 * t1535 + 0.3e1 * t106 * t1546 + 0.3e1 * t106 * t1551 + 0.3e1 * t106 * t1554 - 0.6e1 * t1087 * t1492 - t124 * t1529 - t124 * t1531 - t124 * t1533 - t124 * t1549 - 0.3e1 * t1561 * t166 - 0.3e1 * t1564 * t166 + 0.6e1 * t1569 * t166 + 0.6e1 * t1572 * t166 + 0.6e1 * t1575 * t166 + 0.6e1 * t553 * t380 - 0.3e1 * t570 * t380 - 0.16e2 * t553 * t389 + 0.8e1 * t570 * t389;
  t1581 = t1490 + t1580;
  t1586 = my_piecewise3(t3, 0, -t7 * t89 * t591 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1581);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1586 + 0.2e1 * t595;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1594 = t598 * t141;
  t1597 = t150 * t597;
  t1600 = t193 * t466;
  t1603 = t192 * t206;
  t1604 = t1603 * t118;
  t1607 = t1603 * t141;
  t1626 = t150 * t613;
  t1630 = 0.1e1 / t354;
  t1631 = t1630 * t62;
  t1634 = t1225 * t606;
  t1636 = t1630 * tau[0];
  t1637 = t765 * t1636;
  t1640 = t606 * t112;
  t1641 = t765 * t1640;
  t1643 = t756 * t1636;
  t1646 = 0.16e3 / 0.3e1 * t562 - 0.32e3 / 0.3e1 * t1631 * tau[0] + 0.64e2 * t1634 + 0.64e3 * t1637 - 0.64e3 / 0.3e1 * t564 - 0.96e2 * t1641 - 0.64e3 * t1643 + 0.16e3 * t579;
  t1647 = t81 * t1646;
  t1656 = t150 * t617;
  t1668 = t150 * t635;
  t1684 = t137 * t1630;
  t1691 = t323 * t1630;
  t1698 = t740 * t1630;
  t1705 = -0.21504e6 * t132 * t1691 * tau[0] + 0.768e5 * t310 * t1684 * tau[0] + 0.14336e6 * t67 * t1698 * tau[0] - 0.1792e5 * t67 * t631 * t454 + 0.1536e5 * t1000 * t1640 + 0.32e4 * t775 * t1636 + 0.576e3 * t756 * t1640 + 0.32256e5 * t789 * t1640 - 0.4608e5 * t800 * t1640 - 0.64e3 * t305 * t455 + 0.96e2 * t1634 + 0.96e3 * t1637 - 0.576e3 * t1641 - 0.384e4 * t1643 - 0.32e3 * t564 + 0.96e3 * t579 - 0.128e5 * t582 + 0.3072e5 * t586;
  t1706 = t81 * t1705;
  t1708 = -0.3e1 * t250 * t636 * t118 + 0.6e1 * t717 * t618 * t118 - 0.3e1 * t250 * t614 * t141 + 0.2e1 * t288 * t636 * t141 - 0.6e1 * t657 * t618 * t141 + 0.4e1 * t288 * t207 * t499 + 0.3e1 * t106 * t1626 + 0.3e1 * t106 * t1647 - t124 * t1668 - t124 * t1706 + 0.2e1 * t288 * t1656;
  t1709 = 0.6e1 * t245 * t614 * t118 - 0.6e1 * t250 * t193 * t499 - 0.6e1 * t250 * t448 * t206 - 0.6e1 * t250 * t467 * t206 + 0.12e2 * t1041 * t1607 - 0.12e2 * t1087 * t1604 + 0.6e1 * t1370 * t598 - 0.6e1 * t678 * t1594 + 0.6e1 * t245 * t1597 + 0.12e2 * t245 * t1600 + t1708;
  t1714 = my_piecewise3(t3, 0, -t7 * t89 * t638 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1709);
  tv3rhotau20 = 0.2e1 * rho[0] * t1714 + 0.2e1 * t642;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1717 = t765 * t743;
  t1722 = t669 * t743;
  t1724 = t667 * t1722;
  t1726 = 0.125e3 / 0.6377292e7 * t696 * t1722 - 0.125e3 / 0.6377292e7 * t1724;
  t1728 = t743 * t74;
  t1732 = t527 * t175;
  t1733 = t81 * t1732;
  t1739 = t33 * t527;
  t1740 = t366 * t1739;
  t1744 = t180 * t527;
  t1747 = t545 * t175;
  t1750 = t180 * t540;
  t1754 = t70 * t743;
  t1755 = t731 * t1754;
  t1757 = -0.3e1 / 0.8e1 * t1339 - 0.6e2 * t1755;
  t1758 = t81 * t1757;
  t1760 = t106 * t545;
  t1763 = t245 * t180;
  t1766 = t54 * t175;
  t1767 = t403 * t1766;
  t1772 = t33 * t540;
  t1773 = t366 * t1772;
  t1776 = t1263 * t1292;
  t1779 = -0.9e1 * t513 * t1717 - 0.9e1 / 0.4e1 * t521 * t524 + t75 * t1726 + 0.24e2 * t775 * t1728 * t81 - 0.6e1 * t657 * t1733 + 0.6e1 * t288 * t176 * t540 + 0.18e2 * t870 * t1740 + 0.125e3 / 0.6377292e7 * t1724 + 0.6e1 * t288 * t1744 - 0.3e1 * t124 * t1747 - 0.3e1 * t124 * t1750 - t124 * t1758 + 0.9e1 * t1760 * t166 + 0.36e2 * t1763 * t514 + 0.9e1 / 0.4e1 * t1359 * t1767 - 0.18e2 * t1281 * t518 - 0.9e1 * t371 * t1773 - 0.36e2 * t1262 * t1776;
  t1783 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1779);
  tv3sigma30 = 0.2e1 * rho[0] * t1783;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1813 = t180 * t566;
  t1816 = t545 * t206;
  t1818 = t180 * t588;
  t1821 = 0.3e1 * t106 * t81 * t1154 * t62 - 0.6e1 * t250 * t559 * t175 - 0.6e1 * t250 * t567 * t175 + 0.4e1 * t288 * t576 * t175 + 0.4e1 * t288 * t589 * t175 - 0.3e1 * t250 * t193 * t540 + 0.6e1 * t717 * t193 * t527 + 0.2e1 * t288 * t207 * t540 - 0.6e1 * t657 * t207 * t527 + 0.6e1 * t106 * t1813 - t124 * t1816 - 0.2e1 * t124 * t1818;
  t1823 = t765 * t1154;
  t1825 = t70 * t1154;
  t1826 = t731 * t1825;
  t1828 = t310 * t1515;
  t1830 = 0.3e1 * t1539 - 0.9e1 * t1823 + 0.48e3 * t1826 - 0.72e3 * t1828;
  t1831 = t81 * t1830;
  t1833 = t545 * t192;
  t1836 = t245 * t567;
  t1839 = t250 * t576;
  t1842 = t250 * t589;
  t1847 = t245 * t559;
  t1850 = t165 * t175;
  t1851 = t107 * t1850;
  t1856 = t271 * t27;
  t1857 = t276 * t74;
  t1861 = t192 * t27;
  t1862 = t276 * t54;
  t1863 = t1861 * t1862;
  t1866 = t206 * t27;
  t1867 = t1866 * t1862;
  t1870 = -t124 * t1831 + 0.3e1 * t106 * t1833 + 0.12e2 * t1836 * t166 - 0.6e1 * t1839 * t166 - 0.6e1 * t1842 * t166 - 0.12e2 * t1428 * t514 + 0.12e2 * t1847 * t166 + 0.12e2 * t1433 * t1851 - 0.12e2 * t1440 * t1851 + 0.12e2 * t1856 * t1857 * t193 - 0.3e1 / 0.2e1 * t513 * t1863 + 0.3e1 / 0.4e1 * t1359 * t1867;
  t1871 = t1821 + t1870;
  t1875 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1871);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1875;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1877 = t107 * t28;
  t1878 = t33 * t74;
  t1879 = t1878 * t598;
  t1882 = t598 * t175;
  t1885 = t180 * t597;
  t1888 = t193 * t566;
  t1891 = t206 * t47;
  t1892 = t366 * t33;
  t1893 = t1891 * t1892;
  t1896 = t1603 * t175;
  t1908 = t245 * t614;
  t1915 = t180 * t613;
  t1919 = t765 * t1630;
  t1921 = -0.16e2 * t1631 + 0.24e2 * t1919;
  t1922 = t81 * t1921;
  t1925 = t717 * t618;
  t1931 = t180 * t617;
  t1937 = t250 * t636;
  t1943 = t180 * t635;
  t1947 = t756 * t1630;
  t1949 = t70 * t1630;
  t1950 = t731 * t1949;
  t1952 = t310 * t1684;
  t1954 = t132 * t1691;
  t1956 = -0.24e2 * t1631 + 0.144e3 * t1919 - 0.144e3 * t1947 - 0.384e4 * t1950 + 0.1152e5 * t1952 - 0.8064e4 * t1954;
  t1957 = t81 * t1956;
  t1959 = -0.3e1 * t250 * t614 * t175 + 0.2e1 * t288 * t636 * t175 - 0.6e1 * t657 * t618 * t175 + 0.4e1 * t288 * t207 * t588 + 0.3e1 * t106 * t1915 + 0.3e1 * t106 * t1922 - t124 * t1943 - t124 * t1957 + 0.6e1 * t1925 * t166 - 0.3e1 * t1937 * t166 + 0.2e1 * t288 * t1931;
  t1960 = -0.6e1 * t250 * t193 * t588 - 0.6e1 * t250 * t559 * t206 - 0.6e1 * t250 * t567 * t206 + 0.12e2 * t1041 * t1896 - 0.12e2 * t1440 * t1893 + 0.6e1 * t1908 * t166 + 0.6e1 * t1877 * t1879 - 0.6e1 * t678 * t1882 + 0.6e1 * t245 * t1885 + 0.12e2 * t245 * t1888 + t1959;
  t1964 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1960);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1964;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1966 = t597 * t192;
  t1967 = t1966 * t74;
  t1970 = t598 * t206;
  t1973 = t193 * t613;
  t1985 = 0.1e1 / t274;
  t1987 = 0.192e3 * t1985 * t62;
  t1988 = t765 * t1985;
  t1990 = t756 * t1985;
  t1992 = t1987 - 0.576e3 * t1988 + 0.384e3 * t1990;
  t1993 = t81 * t1992;
  t1996 = t617 * t206;
  t1997 = t81 * t1996;
  t2007 = t70 * t1985;
  t2010 = t137 * t1985;
  t2013 = t323 * t1985;
  t2016 = t740 * t1985;
  t2019 = 0.193536e6 * t132 * t2013 - 0.192e4 * t775 * t1985 + 0.3072e5 * t731 * t2007 - 0.13824e6 * t310 * t2010 - 0.86016e5 * t67 * t2016 + t1987 - 0.1728e4 * t1988 + 0.3456e4 * t1990;
  t2020 = t81 * t2019;
  t2022 = -0.9e1 * t250 * t193 * t635 + 0.18e2 * t717 * t193 * t617 - 0.9e1 * t250 * t614 * t206 + 0.6e1 * t288 * t207 * t635 + 0.3e1 * t106 * t1993 - t124 * t2020 + 0.6e1 * t1967 * t81 - 0.18e2 * t678 * t1970 + 0.18e2 * t245 * t1973 - 0.6e1 * t657 * t1997;
  t2026 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t2022);
  tv3tau30 = 0.2e1 * rho[0] * t2026;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t30, t31;
  double t33, t34, t36, t37, t41, t42, t44, t45;
  double t47, t48, t49, t52, t53, t54, t57, t58;
  double t59, t60, t61, t62, t65, t67, t68, t70;
  double t73, t74, t75, t76, t81, t83, t87, tzk0;

  double t89, t93, t94, t97, t98, t99, t101, t102;
  double t103, t104, t106, t107, t108, t112, t115, t118;
  double t119, t122, t123, t124, t127, t128, t132, t133;
  double t137, t138, t141, t142, t144, t147, t150, t152;
  double t157, tvrho0, t160, t161, t162, t164, t165, t166;
  double t169, t171, t173, t175, t176, t180, t182, t186;
  double tvsigma0, tvlapl0, t188, t190, t192, t193, t202, t206;
  double t207, t209, t213, tvtau0;

  double t216, t226, t228, t229, t230, t231, t232, t234;
  double t235, t236, t238, t240, t241, t242, t244, t245;
  double t246, t247, t250, t254, t257, t260, t261, t264;
  double t268, t271, t272, t273, t274, t276, t277, t282;
  double t283, t287, t288, t289, t290, t293, t298, t304;
  double t305, t310, t311, t314, t315, t322, t323, t324;
  double t329, t335, t340, t342, t347, tv2rho20, t353, t354;
  double t356, t358, t360, t361, t363, t364, t365, t366;
  double t367, t368, t371, t373, t376, t379, t380, t383;
  double t384, t386, t389, t398, t400, t401, t403, t404;
  double t405, t407, t409, t410, t412, t415, t417, t418;
  double t420, t423, t429, t431, t436, tv2rhosigma0, tv2rholapl0, t445;
  double t448, t454, t455, t456, t460, t461, t463, t466;
  double t467, t476, t499, t500, t502, t507, tv2rhotau0, t510;
  double t511, t513, t514, t517, t518, t521, t524, t527;
  double t528, t531, t534, t536, t538, t540, t541, t545;
  double t547, t551, tv2sigma20, tv2sigmalapl0, t553, t556, t559, t562;
  double t564, t566, t567, t570, t576, t579, t582, t584;
  double t586, t588, t589, t591, t595, tv2sigmatau0, tv2lapl20, tv2lapltau0;
  double t597, t598, t601, t605, t606, t609, t611, t613;
  double t614, t617, t618, t631, t635, t636, t638, t642;
  double tv2tau20;

  double t645, t655, t656, t657, t658, t659, t665, t667;
  double t668, t669, t670, t671, t672, t673, t674, t675;
  double t677, t678, t694, t696, t700, t702, t706, t707;
  double t708, t712, t714, t715, t717, t731, t732, t740;
  double t741, t742, t743, t749, t753, t756, t757, t760;
  double t765, t766, t769, t772, t775, t776, t785, t786;
  double t789, t790, t800, t801, t805, t808, t809, t812;
  double t815, t818, t823, t826, t829, t842, t843, t846;
  double t847, t852, tv3rho30, t862, t863, t866, t867, t870;
  double t872, t876, t879, t880, t883, t884, t887, t888;
  double t891, t894, t897, t898, t901, t904, t905, t908;
  double t910, t915, t918, t920, t923, t925, t926, t930;
  double t933, t937, t939, t941, t942, t964, t978, t980;
  double t981, t982, t983, t985, t986, t988, t989, t991;
  double t992, t994, t995, t996, t998, t1000, t1001, t1002;
  double t1004, t1005, t1007, t1009, t1011, t1013, t1015, t1018;
  double t1020, t1021, t1023, t1026, t1029, t1031, t1037, t1038;
  double t1041, t1042, t1043, t1046, t1051, t1052, t1055, t1060;
  double t1063, t1066, t1067, t1070, t1072, t1077, tv3rho2sigma0, tv3rho2lapl0;
  double t1087, t1088, t1089, t1098, t1099, t1119, t1125, t1144;
  double t1146, t1152, t1154, t1155, t1156, t1165, t1170, t1173;
  double t1177, t1181, t1185, t1191, t1192, t1194, t1206, t1213;
  double t1214, t1215, t1217, t1220, t1225, t1231, t1241, t1242;
  double t1245, t1246, t1251, tv3rho2tau0, t1257, t1258, t1261, t1262;
  double t1263, t1264, t1267, t1274, t1275, t1278, t1281, t1285;
  double t1289, t1292, t1294, t1318, t1319, t1320, t1321, t1323;
  double t1326, t1330, t1331, t1333, t1334, t1339, t1340, t1343;
  double t1346, t1347, t1350, t1355, t1356, t1359, t1360, t1361;
  double t1367, t1370, t1371, t1374, t1375, t1378, t1383, t1386;
  double t1389, t1392, t1394, t1396, t1398, t1400, t1401, t1403;
  double t1405, t1408, t1410, t1411, t1413, t1415, t1420, tv3rhosigma20;
  double tv3rhosigmalapl0, t1428, t1429, t1430, t1433, t1434, t1435, t1440;
  double t1485, t1486, t1487, t1490, t1491, t1492, t1495, t1498;
  double t1501, t1503, t1504, t1507, t1508, t1510, t1513, t1515;
  double t1517, t1520, t1523, t1526, t1528, t1529, t1531, t1533;
  double t1535, t1539, t1540, t1545, t1546, t1549, t1551, t1554;
  double t1561, t1564, t1569, t1572, t1575, t1580, t1581, t1586;
  double tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t1594, t1597, t1600, t1603, t1604;
  double t1607, t1626, t1630, t1631, t1634, t1636, t1637, t1640;
  double t1641, t1643, t1646, t1647, t1656, t1668, t1684, t1691;
  double t1698, t1705, t1706, t1708, t1709, t1714, tv3rhotau20, t1717;
  double t1722, t1724, t1726, t1728, t1732, t1733, t1739, t1740;
  double t1744, t1747, t1750, t1754, t1755, t1757, t1758, t1760;
  double t1763, t1766, t1767, t1772, t1773, t1776, t1779, t1783;
  double tv3sigma30, tv3sigma2lapl0, t1813, t1816, t1818, t1821, t1823, t1825;
  double t1826, t1828, t1830, t1831, t1833, t1836, t1839, t1842;
  double t1847, t1850, t1851, t1856, t1857, t1861, t1862, t1863;
  double t1866, t1867, t1870, t1871, t1875, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0;
  double t1877, t1878, t1879, t1882, t1885, t1888, t1891, t1892;
  double t1893, t1896, t1908, t1915, t1919, t1921, t1922, t1925;
  double t1931, t1937, t1943, t1947, t1949, t1950, t1952, t1954;
  double t1956, t1957, t1959, t1960, t1964, tv3sigmatau20, tv3lapl30, tv3lapl2tau0;
  double tv3lapltau20, t1966, t1967, t1970, t1973, t1985, t1987, t1988;
  double t1990, t1992, t1993, t1996, t1997, t2007, t2010, t2013;
  double t2016, t2019, t2020, t2022, t2026, tv3tau30;

  double t2046, t2047, t2048, t2054, t2057, t2059, t2065, t2069;
  double t2070, t2071, t2076, t2079, t2081, t2083, t2085, t2108;
  double t2127, t2130, t2136, t2137, t2147, t2151, t2158, t2164;
  double t2168, t2171, t2177, t2182, t2183, t2185, t2187, t2196;
  double t2199, t2201, t2208, t2216, t2230, t2243, t2244, t2251;
  double t2262, t2268, t2272, t2273, t2283, t2290, t2328, t2343;
  double t2366, t2370, t2377, tv4rho40, t2390, t2397, t2419, t2422;
  double t2431, t2444, t2451, t2452, t2493, t2502, t2504, t2534;
  double t2541, t2549, t2551, t2552, t2556, t2561, t2563, t2564;
  double t2571, t2582, t2594, t2608, t2612, t2617, t2631, t2632;
  double t2635, t2644, t2647, t2658, t2662, t2684, t2702, t2705;
  double t2716, t2727, t2733, t2741, t2756, t2765, t2770, t2776;
  double t2778, t2794, t2795, t2801, t2822, t2827, t2830, t2838;
  double t2845, t2846, t2849, t2854, t2876, t2884, tv4rho3sigma0, tv4rho3lapl0;
  double t2927, t2929, t2931, t2934, t2935, t2938, t2944, t2946;
  double t2950, t2951, t2952, t2954, t2955, t2957, t2958, t2960;
  double t2973, t2983, t3029, t3065, t3072, t3075, t3082, t3090;
  double t3100, t3124, t3147, t3185, t3193, t3224, t3228, t3235;
  double t3242, tv4rho3tau0, t3273, t3276, t3302, t3333, t3356, t3371;
  double t3376, t3390, t3400, t3427, t3430, t3433, t3436, t3441;
  double t3443, t3445, t3448, t3472, t3473, t3485, t3507, t3514;
  double t3518, t3519, t3528, t3547, t3559, t3563, t3579, t3584;
  double t3585, t3640, t3672, t3676, t3682, t3683, t3691, t3692;
  double t3693, t3699, t3731, t3738, t3746, tv4rho2sigma20, tv4rho2sigmalapl0, t3768;
  double t3771, t3774, t3777, t3781, t3794, t3797, t3798, t3805;
  double t3807, t3811, t3814, t3826, t3829, t3836, t3840, t3843;
  double t3844, t3847, t3856, t3863, t3909, t3910, t3914, t3926;
  double t3929, t3933, t3942, t3951, t3954, t3959, t3961, t3969;
  double t3980, t3987, t4019, t4049, t4065, t4083, t4099, t4132;
  double t4177, t4232, t4240, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0, t4250, t4299;
  double t4348, t4377, t4382, t4385, t4386, t4390, t4392, t4395;
  double t4397, t4399, t4401, t4415, t4447, t4449, t4451, t4453;
  double t4461, t4467, t4471, t4484, t4528, t4544, t4553, t4560;
  double tv4rho2tau20, t4579, t4598, t4603, t4616, t4620, t4643, t4645;
  double t4671, t4672, t4676, t4677, t4726, t4750, t4760, t4775;
  double t4795, t4801, t4803, t4805, t4812, t4831, t4873, t4881;
  double tv4rhosigma30, tv4rhosigma2lapl0, t4924, t4935, t4977, t5026, t5027, t5041;
  double t5054, t5079, t5115, t5122, t5129, t5133, t5156, t5161;
  double t5178, t5206, t5209, t5226, t5231, t5235, t5240, t5243;
  double t5248, t5251, t5256, t5261, t5264, t5269, t5305, t5313;
  double tv4rhosigma2tau0, tv4rhosigmalapl20, tv4rhosigmalapltau0, t5320, t5322, t5325, t5326, t5354;
  double t5389, t5395, t5438, t5480, t5521, t5562, t5580, t5587;
  double t5592, t5595, t5602, t5605, t5607, t5625, t5629, t5633;
  double t5640, t5649, t5650, t5671, t5680, t5687, t5694, t5702;
  double tv4rhosigmatau20, tv4rholapl30, tv4rholapl2tau0, tv4rholapltau20, t5708, t5712, t5722, t5732;
  double t5741, t5745, t5749, t5753, t5755, t5758, t5759, t5762;
  double t5763, t5766, t5767, t5769, t5778, t5804, t5810, t5829;
  double t5838, t5872, t5908, t5915, tv4rhotau30, t5920, t5923, t5954;
  double t5958, t5976, t5979, t6014, t6032, t6037, tv4sigma40, tv4sigma3lapl0;
  double t6091, t6132, t6177, t6198, t6215, t6221, tv4sigma3tau0, tv4sigma2lapl20;
  double tv4sigma2lapltau0, t6269, t6322, t6343, t6361, t6362, t6368, t6428;
  double t6432, t6436, t6442, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, t6477;
  double t6511, t6514, t6521, t6522, t6524, t6569, t6605, t6611;
  double tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30, t6614, t6616, t6618;
  double t6668, t6678, t6697, t6704, t6708, tv4tau40;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = M_CBRT6;
  t22 = M_PI * M_PI;
  t23 = POW_1_3(t22);
  t24 = t23 * t23;
  t25 = 0.1e1 / t24;
  t26 = t21 * t25;
  t27 = M_CBRT2;
  t28 = t27 * t27;
  t29 = sigma[0] * t28;
  t30 = rho[0] * rho[0];
  t31 = t19 * t19;
  t33 = 0.1e1 / t31 / t30;
  t34 = t29 * t33;
  t36 = 0.5e1 / 0.972e3 * t26 * t34;
  t37 = params->kappa + t36;
  t41 = params->kappa * (0.1e1 - params->kappa / t37);
  t42 = tau[0] * t28;
  t44 = 0.1e1 / t31 / rho[0];
  t45 = t42 * t44;
  t47 = t45 - t34 / 0.8e1;
  t48 = t47 * t47;
  t49 = t21 * t21;
  t52 = t45 + 0.3e1 / 0.1e2 * t49 * t24;
  t53 = t52 * t52;
  t54 = 0.1e1 / t53;
  t57 = -0.4e1 * t48 * t54 + 0.1e1;
  t58 = t57 * t57;
  t59 = t58 * t57;
  t60 = t48 * t47;
  t61 = t53 * t52;
  t62 = 0.1e1 / t61;
  t65 = t48 * t48;
  t67 = params->b * t65 * t48;
  t68 = t53 * t53;
  t70 = 0.1e1 / t68 / t53;
  t73 = 0.8e1 * t60 * t62 + 0.64e2 * t67 * t70 + 0.1e1;
  t74 = 0.1e1 / t73;
  t75 = t59 * t74;
  t76 = params->kappa + t36 + params->c;
  t81 = params->kappa * (0.1e1 - params->kappa / t76) - t41;
  t83 = t75 * t81 + t41 + 0.1e1;
  t87 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t83);
  tzk0 = 0.2e1 * t87;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t89 = t18 / t31;
  t93 = params->kappa * params->kappa;
  t94 = t37 * t37;
  t97 = t93 / t94 * t21;
  t98 = t25 * sigma[0];
  t99 = t30 * rho[0];
  t101 = 0.1e1 / t31 / t99;
  t102 = t28 * t101;
  t103 = t98 * t102;
  t104 = t97 * t103;
  t106 = t58 * t74;
  t107 = t47 * t54;
  t108 = t42 * t33;
  t112 = -0.5e1 / 0.3e1 * t108 + t29 * t101 / 0.3e1;
  t115 = t48 * t62;
  t118 = -0.8e1 * t107 * t112 - 0.4e2 / 0.3e1 * t115 * t108;
  t119 = t81 * t118;
  t122 = t73 * t73;
  t123 = 0.1e1 / t122;
  t124 = t59 * t123;
  t127 = 0.1e1 / t68;
  t128 = t60 * t127;
  t132 = params->b * t65 * t47;
  t133 = t70 * t112;
  t137 = 0.1e1 / t68 / t61;
  t138 = t67 * t137;
  t141 = 0.4e2 * t128 * t108 + 0.64e3 * t138 * t108 + 0.24e2 * t115 * t112 + 0.384e3 * t132 * t133;
  t142 = t81 * t141;
  t144 = t76 * t76;
  t147 = t93 / t144 * t21;
  t150 = -0.1e2 / 0.729e3 * t147 * t103 + 0.1e2 / 0.729e3 * t104;
  t152 = -0.1e2 / 0.729e3 * t104 + 0.3e1 * t106 * t119 - t124 * t142 + t75 * t150;
  t157 = my_piecewise3(t3, 0, -t7 * t89 * t83 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t152);
  tvrho0 = 0.2e1 * rho[0] * t157 + 0.2e1 * t87;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t160 = t25 * t28;
  t161 = t160 * t33;
  t162 = t97 * t161;
  t164 = t106 * t81;
  t165 = t28 * t33;
  t166 = t107 * t165;
  t169 = t115 * t165;
  t171 = t70 * t28;
  t173 = t132 * t171 * t33;
  t175 = -0.3e1 * t169 - 0.48e2 * t173;
  t176 = t81 * t175;
  t180 = 0.5e1 / 0.972e3 * t147 * t161 - 0.5e1 / 0.972e3 * t162;
  t182 = 0.5e1 / 0.972e3 * t162 + 0.3e1 * t164 * t166 - t124 * t176 + t75 * t180;
  t186 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t182);
  tvsigma0 = 0.2e1 * rho[0] * t186;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t188 = t28 * t44;
  t190 = t115 * t188;
  t192 = -0.8e1 * t107 * t188 + 0.8e1 * t190;
  t193 = t81 * t192;
  t202 = t137 * t28;
  t206 = 0.384e3 * t132 * t171 * t44 - 0.384e3 * t67 * t202 * t44 - 0.24e2 * t128 * t188 + 0.24e2 * t190;
  t207 = t81 * t206;
  t209 = 0.3e1 * t106 * t193 - t124 * t207;
  t213 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t209);
  tvtau0 = 0.2e1 * rho[0] * t213;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t216 = t18 * t44;
  t226 = t93 / t94 / t37 * t49;
  t228 = 0.1e1 / t23 / t22;
  t229 = sigma[0] * sigma[0];
  t230 = t228 * t229;
  t231 = t30 * t30;
  t232 = t231 * t99;
  t234 = 0.1e1 / t19 / t232;
  t235 = t27 * t234;
  t236 = t230 * t235;
  t238 = 0.4e3 / 0.531441e6 * t226 * t236;
  t240 = 0.1e1 / t31 / t231;
  t241 = t28 * t240;
  t242 = t98 * t241;
  t244 = 0.11e3 / 0.2187e4 * t97 * t242;
  t245 = t57 * t74;
  t246 = t118 * t118;
  t247 = t81 * t246;
  t250 = t58 * t123;
  t254 = t150 * t118;
  t257 = t112 * t112;
  t260 = t47 * t62;
  t261 = t260 * t112;
  t264 = t42 * t101;
  t268 = 0.4e2 / 0.9e1 * t264 - 0.11e2 / 0.9e1 * t29 * t240;
  t271 = t48 * t127;
  t272 = tau[0] * tau[0];
  t273 = t272 * t27;
  t274 = t231 * rho[0];
  t276 = 0.1e1 / t19 / t274;
  t277 = t273 * t276;
  t282 = -0.8e1 * t257 * t54 - 0.16e3 / 0.3e1 * t261 * t108 - 0.8e1 * t107 * t268 - 0.4e3 / 0.3e1 * t271 * t277 + 0.32e3 / 0.9e1 * t115 * t264;
  t283 = t81 * t282;
  t287 = 0.1e1 / t122 / t73;
  t288 = t59 * t287;
  t289 = t141 * t141;
  t290 = t81 * t289;
  t293 = t150 * t141;
  t298 = t271 * t112;
  t304 = 0.1e1 / t68 / t52;
  t305 = t60 * t304;
  t310 = params->b * t65;
  t311 = t70 * t257;
  t314 = t132 * t137;
  t315 = t112 * tau[0];
  t322 = t68 * t68;
  t323 = 0.1e1 / t322;
  t324 = t67 * t323;
  t329 = 0.48e2 * t260 * t257 + 0.24e3 * t298 * t108 + 0.24e2 * t115 * t268 + 0.16e4 / 0.3e1 * t305 * t277 - 0.32e3 / 0.3e1 * t128 * t264 + 0.192e4 * t310 * t311 + 0.768e4 * t314 * t315 * t165 + 0.384e3 * t132 * t70 * t268 + 0.448e5 / 0.3e1 * t324 * t277 - 0.512e4 / 0.3e1 * t138 * t264;
  t335 = t93 / t144 / t76 * t49;
  t340 = -0.4e3 / 0.531441e6 * t335 * t236 + 0.11e3 / 0.2187e4 * t147 * t242 + t238 - t244;
  t342 = -0.6e1 * t250 * t119 * t141 - t124 * t81 * t329 + 0.6e1 * t106 * t254 + 0.3e1 * t106 * t283 - 0.2e1 * t124 * t293 + 0.6e1 * t245 * t247 + 0.2e1 * t288 * t290 + t75 * t340 - t238 + t244;
  t347 = my_piecewise3(t3, 0, t7 * t216 * t83 / 0.12e2 - t7 * t89 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t342);
  tv2rho20 = 0.2e1 * rho[0] * t347 + 0.4e1 * t157;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t353 = t228 * t27;
  t354 = t231 * t30;
  t356 = 0.1e1 / t19 / t354;
  t358 = t353 * t356 * sigma[0];
  t360 = 0.5e2 / 0.177147e6 * t226 * t358;
  t361 = t160 * t101;
  t363 = 0.1e2 / 0.729e3 * t97 * t361;
  t364 = t81 * t47;
  t365 = t245 * t364;
  t366 = t54 * t28;
  t367 = t33 * t118;
  t368 = t366 * t367;
  t371 = t250 * t364;
  t373 = t366 * t33 * t141;
  t376 = t106 * t150;
  t379 = t112 * t54;
  t380 = t379 * t165;
  t383 = t106 * t364;
  t384 = t62 * t27;
  t386 = t384 * t276 * tau[0];
  t389 = t107 * t102;
  t398 = t150 * t175;
  t400 = t165 * t112;
  t401 = t260 * t400;
  t403 = t27 * t276;
  t404 = t403 * tau[0];
  t405 = t271 * t404;
  t407 = t115 * t102;
  t409 = t310 * t70;
  t410 = t409 * t400;
  t412 = t314 * t404;
  t415 = t132 * t171 * t101;
  t417 = -0.6e1 * t401 - 0.3e2 * t405 + 0.8e1 * t407 - 0.24e3 * t410 - 0.96e3 * t412 + 0.128e3 * t415;
  t418 = t81 * t417;
  t420 = t180 * t118;
  t423 = t180 * t141;
  t429 = 0.5e2 / 0.177147e6 * t335 * t358 - 0.1e2 / 0.729e3 * t147 * t361 - t360 + t363;
  t431 = -0.3e1 * t250 * t176 * t118 + 0.2e1 * t288 * t176 * t141 + 0.3e1 * t106 * t420 - t124 * t398 - t124 * t418 - t124 * t423 + 0.3e1 * t164 * t380 - 0.8e1 * t164 * t389 + 0.3e1 * t376 * t166 + 0.6e1 * t365 * t368 - 0.3e1 * t371 * t373 + 0.2e2 * t383 * t386 + t75 * t429 + t360 - t363;
  t436 = my_piecewise3(t3, 0, -t7 * t89 * t182 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t431);
  tv2rhosigma0 = 0.2e1 * rho[0] * t436 + 0.2e1 * t186;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t445 = t193 * t141;
  t448 = t150 * t192;
  t454 = 0.1e1 / t19 / t231;
  t455 = t27 * t454;
  t456 = t455 * tau[0];
  t460 = t188 * t112;
  t461 = t260 * t460;
  t463 = t271 * t456;
  t466 = -0.8e1 * t379 * t188 - 0.16e3 / 0.3e1 * t260 * t456 + 0.4e2 / 0.3e1 * t166 + 0.16e2 * t461 + 0.8e2 * t463 - 0.4e2 / 0.3e1 * t169;
  t467 = t81 * t466;
  t476 = t150 * t206;
  t499 = 0.64e3 * t67 * t202 * t33 + 0.4e2 * t128 * t165 - 0.72e2 * t271 * t460 - 0.32e3 * t305 * t456 + 0.768e4 * t314 * t456 - 0.2304e4 * t314 * t460 - 0.896e4 * t324 * t456 + 0.192e4 * t409 * t460 - 0.4e2 * t169 - 0.64e3 * t173 + 0.48e2 * t461 + 0.24e3 * t463;
  t500 = t81 * t499;
  t502 = 0.6e1 * t245 * t193 * t118 - 0.3e1 * t250 * t207 * t118 + 0.2e1 * t288 * t207 * t141 + 0.3e1 * t106 * t448 + 0.3e1 * t106 * t467 - t124 * t476 - t124 * t500 - 0.3e1 * t250 * t445;
  t507 = my_piecewise3(t3, 0, -t7 * t89 * t209 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t502);
  tv2rhotau0 = 0.2e1 * rho[0] * t507 + 0.2e1 * t213;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t510 = t353 * t276;
  t511 = t226 * t510;
  t513 = t245 * t81;
  t514 = t271 * t403;
  t517 = t33 * t175;
  t518 = t366 * t517;
  t521 = t106 * t180;
  t524 = t403 * t54;
  t527 = t175 * t175;
  t528 = t81 * t527;
  t531 = t180 * t175;
  t534 = t260 * t403;
  t536 = t70 * t27;
  t538 = t310 * t536 * t276;
  t540 = 0.3e1 / 0.2e1 * t534 + 0.6e2 * t538;
  t541 = t81 * t540;
  t545 = -0.25e2 / 0.236196e6 * t335 * t510 + 0.25e2 / 0.236196e6 * t511;
  t547 = -0.25e2 / 0.236196e6 * t511 + 0.12e2 * t513 * t514 - 0.6e1 * t371 * t518 + 0.6e1 * t521 * t166 - 0.3e1 / 0.4e1 * t164 * t524 + 0.2e1 * t288 * t528 - 0.2e1 * t124 * t531 - t124 * t541 + t75 * t545;
  t551 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t547);
  tv2sigma20 = 0.2e1 * rho[0] * t551;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t553 = t245 * t193;
  t556 = t193 * t175;
  t559 = t180 * t192;
  t562 = t455 * t54;
  t564 = t260 * t455;
  t566 = 0.2e1 * t562 - 0.4e1 * t564;
  t567 = t81 * t566;
  t570 = t250 * t207;
  t576 = t180 * t206;
  t579 = t271 * t455;
  t582 = t310 * t536 * t454;
  t584 = t137 * t27;
  t586 = t132 * t584 * t454;
  t588 = -0.12e2 * t564 + 0.18e2 * t579 - 0.48e3 * t582 + 0.576e3 * t586;
  t589 = t81 * t588;
  t591 = 0.2e1 * t288 * t207 * t175 + 0.3e1 * t106 * t559 + 0.3e1 * t106 * t567 - t124 * t576 - t124 * t589 + 0.6e1 * t553 * t166 - 0.3e1 * t570 * t166 - 0.3e1 * t250 * t556;
  t595 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t591);
  tv2sigmatau0 = 0.2e1 * rho[0] * t595;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t597 = t192 * t192;
  t598 = t81 * t597;
  t601 = t193 * t206;
  t605 = 0.1e1 / t19 / t99;
  t606 = t27 * t605;
  t609 = t260 * t606;
  t611 = t271 * t606;
  t613 = -0.16e2 * t606 * t54 + 0.64e2 * t609 - 0.48e2 * t611;
  t614 = t81 * t613;
  t617 = t206 * t206;
  t618 = t81 * t617;
  t631 = t323 * t27;
  t635 = -0.9216e4 * t132 * t584 * t605 + 0.384e4 * t310 * t536 * t605 + 0.5376e4 * t67 * t631 * t605 + 0.192e3 * t305 * t606 + 0.96e2 * t609 - 0.288e3 * t611;
  t636 = t81 * t635;
  t638 = 0.3e1 * t106 * t614 - t124 * t636 + 0.6e1 * t245 * t598 - 0.6e1 * t250 * t601 + 0.2e1 * t288 * t618;
  t642 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t638);
  tv2tau20 = 0.2e1 * rho[0] * t642;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t645 = t18 * t33;
  t655 = t122 * t122;
  t656 = 0.1e1 / t655;
  t657 = t59 * t656;
  t658 = t289 * t141;
  t659 = t81 * t658;
  t665 = t94 * t94;
  t667 = t93 / t665;
  t668 = t22 * t22;
  t669 = 0.1e1 / t668;
  t670 = t229 * sigma[0];
  t671 = t669 * t670;
  t672 = t231 * t231;
  t673 = t672 * t99;
  t674 = 0.1e1 / t673;
  t675 = t671 * t674;
  t677 = 0.16e5 / 0.43046721e8 * t667 * t675;
  t678 = t57 * t123;
  t694 = t144 * t144;
  t696 = t93 / t694;
  t700 = 0.1e1 / t19 / t672;
  t702 = t230 * t27 * t700;
  t706 = 0.1e1 / t31 / t274;
  t707 = t28 * t706;
  t708 = t98 * t707;
  t712 = 0.44e4 / 0.531441e6 * t226 * t702;
  t714 = 0.154e4 / 0.6561e4 * t97 * t708;
  t715 = -0.16e5 / 0.43046721e8 * t696 * t675 + 0.44e4 / 0.531441e6 * t335 * t702 - 0.154e4 / 0.6561e4 * t147 * t708 + t677 - t712 + t714;
  t717 = t58 * t287;
  t731 = params->b * t60;
  t732 = t257 * t112;
  t740 = 0.1e1 / t322 / t52;
  t741 = t272 * tau[0];
  t742 = t740 * t741;
  t743 = 0.1e1 / t672;
  t749 = t42 * t240;
  t753 = -0.44e3 / 0.27e2 * t749 + 0.154e3 / 0.27e2 * t29 * t706;
  t756 = t48 * t304;
  t757 = t756 * t112;
  t760 = t273 * t356;
  t765 = t47 * t127;
  t766 = t765 * t257;
  t769 = t271 * t268;
  t772 = t112 * t268;
  t775 = t60 * t70;
  t776 = t741 * t743;
  t785 = t268 * tau[0];
  t786 = t785 * t165;
  t789 = t132 * t323;
  t790 = t112 * t272;
  t800 = t310 * t137;
  t801 = t257 * tau[0];
  t805 = 0.768e4 * t731 * t70 * t732 + 0.576e4 * t310 * t133 * t268 + 0.3584e7 / 0.9e1 * t67 * t742 * t743 + 0.48e2 * t732 * t62 + 0.24e2 * t115 * t753 + 0.48e4 * t757 * t277 - 0.128e5 / 0.3e1 * t305 * t760 + 0.352e4 / 0.9e1 * t128 * t749 + 0.72e3 * t766 * t108 + 0.36e3 * t769 * t108 + 0.144e3 * t260 * t772 + 0.8e5 / 0.9e1 * t775 * t776 + 0.384e3 * t132 * t70 * t753 - 0.3072e5 * t314 * t315 * t102 + 0.1152e5 * t314 * t786 + 0.2688e6 * t789 * t790 * t403 - 0.3584e6 / 0.3e1 * t324 * t760 + 0.5632e5 / 0.9e1 * t138 * t749 - 0.96e3 * t298 * t264 + 0.576e5 * t800 * t801 * t165;
  t808 = t246 * t118;
  t809 = t808 * t74;
  t812 = t150 * t246;
  t815 = t340 * t118;
  t818 = t150 * t282;
  t823 = t257 * t62;
  t826 = t765 * t112;
  t829 = t260 * t268;
  t842 = -0.24e2 * t379 * t268 - 0.8e2 * t823 * t108 - 0.8e3 * t826 * t277 - 0.8e2 * t829 * t108 + 0.64e3 / 0.3e1 * t261 * t264 - 0.8e1 * t107 * t753 - 0.16e5 / 0.9e1 * t756 * t776 + 0.32e4 / 0.3e1 * t271 * t760 - 0.352e4 / 0.27e2 * t115 * t749;
  t843 = t81 * t842;
  t846 = -0.3e1 * t124 * t340 * t141 - 0.3e1 * t124 * t150 * t329 - t124 * t81 * t805 + 0.6e1 * t288 * t150 * t289 + 0.9e1 * t106 * t815 + 0.9e1 * t106 * t818 + 0.3e1 * t106 * t843 + 0.18e2 * t245 * t812 + 0.6e1 * t809 * t81 + t712 - t714;
  t847 = 0.18e2 * t245 * t119 * t282 - 0.9e1 * t250 * t119 * t329 + 0.18e2 * t717 * t119 * t289 - 0.18e2 * t678 * t247 * t141 - 0.18e2 * t250 * t254 * t141 - 0.9e1 * t250 * t283 * t141 + 0.6e1 * t288 * t142 * t329 - 0.6e1 * t657 * t659 + t75 * t715 - t677 + t846;
  t852 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t645 * t83 + t7 * t216 * t152 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t89 * t342 - 0.3e1 / 0.8e1 * t7 * t20 * t847);
  tv3rho30 = 0.2e1 * rho[0] * t852 + 0.6e1 * t347;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t862 = t356 * tau[0];
  t863 = t384 * t862;
  t866 = t101 * t118;
  t867 = t366 * t866;
  t870 = t717 * t364;
  t872 = t366 * t33 * t289;
  t876 = t366 * t101 * t141;
  t879 = t150 * t47;
  t880 = t245 * t879;
  t883 = t81 * t112;
  t884 = t245 * t883;
  t887 = t33 * t282;
  t888 = t366 * t887;
  t891 = t250 * t879;
  t894 = t250 * t883;
  t897 = t33 * t329;
  t898 = t366 * t897;
  t901 = t106 * t879;
  t904 = -0.32e2 * t365 * t867 + 0.6e1 * t365 * t888 + 0.12e2 * t880 * t368 + 0.12e2 * t884 * t368 + 0.16e2 * t371 * t876 - 0.3e1 * t371 * t898 - 0.6e1 * t891 * t373 - 0.6e1 * t894 * t373 - 0.16e3 * t383 * t863 + 0.4e2 * t901 * t386 + 0.6e1 * t870 * t872;
  t905 = t106 * t883;
  t908 = t678 * t364;
  t910 = t366 * t367 * t141;
  t915 = t384 * t276 * t118 * tau[0];
  t918 = t276 * t141;
  t920 = t384 * t918 * tau[0];
  t923 = t672 * t30;
  t925 = t669 / t923;
  t926 = t925 * t229;
  t930 = t353 * t234 * sigma[0];
  t933 = t160 * t240;
  t937 = 0.2e4 / 0.14348907e8 * t667 * t926;
  t939 = 0.5e2 / 0.19683e5 * t226 * t930;
  t941 = 0.11e3 / 0.2187e4 * t97 * t933;
  t942 = 0.2e4 / 0.14348907e8 * t696 * t926 - 0.5e2 / 0.19683e5 * t335 * t930 + 0.11e3 / 0.2187e4 * t147 * t933 - t937 + t939 - t941;
  t964 = -0.6e1 * t250 * t418 * t118 - 0.2e1 * t124 * t429 * t141 - t124 * t180 * t329 - 0.6e1 * t250 * t420 * t141 - 0.6e1 * t678 * t176 * t246 - 0.3e1 * t250 * t176 * t282 - 0.6e1 * t657 * t176 * t289 + 0.8e2 * t365 * t915 - 0.4e2 * t371 * t920 + 0.4e2 * t905 * t386 + t75 * t942 - 0.12e2 * t908 * t910;
  t978 = t823 * t165;
  t980 = t765 * t27;
  t981 = t276 * t112;
  t982 = t981 * tau[0];
  t983 = t980 * t982;
  t985 = t102 * t112;
  t986 = t260 * t985;
  t988 = t165 * t268;
  t989 = t260 * t988;
  t991 = t743 * t272;
  t992 = t756 * t991;
  t994 = t27 * t356;
  t995 = t994 * tau[0];
  t996 = t271 * t995;
  t998 = t115 * t241;
  t1000 = t731 * t70;
  t1001 = t165 * t257;
  t1002 = t1000 * t1001;
  t1004 = t403 * t315;
  t1005 = t800 * t1004;
  t1007 = t409 * t985;
  t1009 = t409 * t988;
  t1011 = t323 * t743;
  t1013 = t132 * t1011 * t272;
  t1015 = t314 * t995;
  t1018 = t132 * t171 * t240;
  t1020 = -0.6e1 * t978 - 0.12e3 * t983 + 0.32e2 * t986 - 0.6e1 * t989 - 0.4e3 * t992 + 0.24e3 * t996 - 0.88e2 / 0.3e1 * t998 - 0.96e3 * t1002 - 0.96e4 * t1005 + 0.128e4 * t1007 - 0.24e3 * t1009 - 0.224e5 * t1013 + 0.768e4 * t1015 - 0.1408e4 / 0.3e1 * t1018;
  t1021 = t81 * t1020;
  t1023 = t429 * t118;
  t1026 = t180 * t282;
  t1029 = t340 * t175;
  t1031 = t150 * t417;
  t1037 = -0.6e1 * t250 * t398 * t118 + 0.4e1 * t288 * t398 * t141 + 0.4e1 * t288 * t418 * t141 + 0.2e1 * t288 * t176 * t329 + 0.2e1 * t288 * t180 * t289 - t124 * t1021 + 0.6e1 * t106 * t1023 + 0.3e1 * t106 * t1026 - t124 * t1029 - 0.2e1 * t124 * t1031 + t937;
  t1038 = t180 * t246;
  t1041 = t717 * t81;
  t1042 = t175 * t118;
  t1043 = t1042 * t141;
  t1046 = t106 * t340;
  t1051 = t268 * t54;
  t1052 = t1051 * t165;
  t1055 = t765 * t991;
  t1060 = t379 * t102;
  t1063 = t107 * t241;
  t1066 = t246 * t74;
  t1067 = t1066 * t81;
  t1070 = 0.6e1 * t245 * t1038 + t941 + 0.12e2 * t1041 * t1043 + 0.3e1 * t1046 * t166 + 0.6e1 * t376 * t380 + 0.3e1 * t164 * t1052 + 0.2e3 * t164 * t1055 - 0.16e2 * t376 * t389 - 0.16e2 * t164 * t1060 + 0.88e2 / 0.3e1 * t164 * t1063 - t939 + 0.6e1 * t1067 * t166;
  t1072 = t904 + t964 + t1037 + t1070;
  t1077 = my_piecewise3(t3, 0, t7 * t216 * t182 / 0.12e2 - t7 * t89 * t431 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1072);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t1077 + 0.4e1 * t436;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1087 = t678 * t81;
  t1088 = t192 * t118;
  t1089 = t1088 * t141;
  t1098 = t206 * t118;
  t1099 = t1098 * t141;
  t1119 = t193 * t282;
  t1125 = 0.12e2 * t245 * t448 * t118 + 0.12e2 * t245 * t467 * t118 - 0.6e1 * t250 * t448 * t141 + 0.4e1 * t288 * t500 * t141 + 0.6e1 * t717 * t193 * t289 - 0.6e1 * t678 * t207 * t246 + 0.2e1 * t288 * t207 * t329 - 0.6e1 * t657 * t207 * t289 + 0.12e2 * t1041 * t1099 + 0.6e1 * t1066 * t193 - 0.12e2 * t1087 * t1089 + 0.6e1 * t245 * t1119;
  t1144 = t340 * t206;
  t1146 = t150 * t499;
  t1152 = t823 * t188;
  t1154 = 0.1e1 / t232;
  t1155 = t1154 * t272;
  t1156 = t756 * t1155;
  t1165 = t188 * t257;
  t1170 = t188 * t268;
  t1173 = t323 * t1154;
  t1177 = t740 * t1154;
  t1181 = t260 * t1170;
  t1185 = 0.32e3 / 0.3e1 * t407 - 0.32e3 / 0.3e1 * t128 * t102 + 0.48e2 * t1152 + 0.32e4 * t1156 - 0.16e5 / 0.3e1 * t775 * t1155 + 0.192e4 * t305 * t404 - 0.512e4 / 0.3e1 * t67 * t202 * t101 - 0.144e3 * t765 * t1165 + 0.24e3 * t271 * t400 - 0.72e2 * t271 * t1170 + 0.1792e6 * t132 * t1173 * t272 - 0.7168e6 / 0.3e1 * t67 * t1177 * t272 + 0.48e2 * t1181 + 0.5376e5 * t324 * t404;
  t1191 = t454 * t112 * tau[0];
  t1192 = t980 * t1191;
  t1194 = t756 * t27;
  t1206 = t455 * t315;
  t1213 = 0.192e4 * t409 * t1170 - 0.2304e4 * t314 * t1170 + 0.96e3 * t1192 - 0.192e4 * t1194 * t1191 + 0.768e4 * t1000 * t1165 - 0.1152e5 * t800 * t1165 + 0.768e4 * t314 * t400 - 0.16e3 * t401 - 0.144e4 * t405 + 0.512e4 / 0.3e1 * t415 + 0.768e5 * t800 * t1206 - 0.10752e6 * t789 * t1206 - 0.64e4 * t410 - 0.4608e5 * t412;
  t1214 = t1185 + t1213;
  t1215 = t81 * t1214;
  t1217 = t340 * t192;
  t1220 = t150 * t466;
  t1225 = t112 * t62;
  t1231 = t260 * t404;
  t1241 = -0.8e1 * t1051 * t188 - 0.32e3 / 0.3e1 * t1225 * t456 + 0.8e2 / 0.3e1 * t380 - 0.16e4 / 0.3e1 * t765 * t1155 + 0.32e3 * t1231 - 0.32e3 / 0.9e1 * t389 + 0.16e2 * t1152 + 0.32e3 * t1192 - 0.16e3 / 0.3e1 * t401 + 0.16e2 * t1181 + 0.32e4 / 0.3e1 * t1156 - 0.48e3 * t405 + 0.32e3 / 0.9e1 * t407;
  t1242 = t81 * t1241;
  t1245 = -0.6e1 * t250 * t476 * t118 - 0.6e1 * t250 * t500 * t118 - 0.6e1 * t250 * t467 * t141 + 0.4e1 * t288 * t476 * t141 - 0.3e1 * t250 * t193 * t329 - 0.3e1 * t250 * t207 * t282 + 0.3e1 * t106 * t1217 + 0.6e1 * t106 * t1220 + 0.3e1 * t106 * t1242 - t124 * t1144 - 0.2e1 * t124 * t1146 - t124 * t1215;
  t1246 = t1125 + t1245;
  t1251 = my_piecewise3(t3, 0, t7 * t216 * t209 / 0.12e2 - t7 * t89 * t502 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1246);
  tv3rho2tau0 = 0.2e1 * rho[0] * t1251 + 0.4e1 * t507;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1257 = t180 * t47;
  t1258 = t106 * t1257;
  t1261 = t81 * t48;
  t1262 = t678 * t1261;
  t1263 = t127 * t27;
  t1264 = t1263 * t918;
  t1267 = t1263 * t981;
  t1274 = t33 * t417;
  t1275 = t366 * t1274;
  t1278 = t245 * t1257;
  t1281 = t250 * t1257;
  t1285 = t366 * t517 * t118;
  t1289 = t366 * t517 * t141;
  t1292 = t276 * t175;
  t1294 = t384 * t1292 * tau[0];
  t1318 = t672 * rho[0];
  t1319 = 0.1e1 / t1318;
  t1320 = t669 * t1319;
  t1321 = t1320 * sigma[0];
  t1323 = 0.25e3 / 0.4782969e7 * t667 * t1321;
  t1326 = t353 * t356;
  t1330 = 0.1e3 / 0.177147e6 * t226 * t1326;
  t1331 = -0.25e3 / 0.4782969e7 * t696 * t1321 + 0.1e3 / 0.177147e6 * t335 * t1326 + t1323 - t1330;
  t1333 = 0.4e2 * t1258 * t386 - 0.12e2 * t1262 * t1264 + 0.24e2 * t365 * t1267 - 0.6e1 * t891 * t518 - 0.6e1 * t894 * t518 - 0.6e1 * t371 * t1275 + 0.12e2 * t1278 * t368 - 0.6e1 * t1281 * t373 - 0.12e2 * t908 * t1285 + 0.12e2 * t870 * t1289 - 0.4e2 * t371 * t1294 + 0.4e1 * t288 * t531 * t141 - 0.3e1 * t250 * t541 * t118 + 0.2e1 * t288 * t541 * t141 - 0.6e1 * t657 * t528 * t141 + 0.4e1 * t288 * t176 * t417 - 0.6e1 * t250 * t531 * t118 + 0.6e1 * t717 * t528 * t118 - t1323 + t75 * t1331;
  t1334 = t994 * t54;
  t1339 = t743 * t62;
  t1340 = t1339 * tau[0];
  t1343 = t245 * t150;
  t1346 = t743 * tau[0];
  t1347 = t756 * t1346;
  t1350 = t106 * t429;
  t1355 = t54 * t118;
  t1356 = t403 * t1355;
  t1359 = t250 * t81;
  t1360 = t54 * t141;
  t1361 = t403 * t1360;
  t1367 = t271 * t994;
  t1370 = t118 * t74;
  t1371 = t1370 * t81;
  t1374 = t101 * t175;
  t1375 = t366 * t1374;
  t1378 = t545 * t118;
  t1383 = t150 * t527;
  t1386 = t429 * t175;
  t1389 = t180 * t417;
  t1392 = t150 * t540;
  t1394 = t1225 * t403;
  t1396 = t765 * t1346;
  t1398 = t260 * t994;
  t1400 = t403 * t112;
  t1401 = t1000 * t1400;
  t1403 = t137 * t743;
  t1405 = t310 * t1403 * tau[0];
  t1408 = t310 * t536 * t356;
  t1410 = 0.3e1 / 0.2e1 * t1394 + 0.15e2 * t1396 - 0.8e1 * t1398 + 0.24e3 * t1401 + 0.12e4 * t1405 - 0.32e3 * t1408;
  t1411 = t81 * t1410;
  t1413 = -t124 * t545 * t141 + 0.3e1 * t106 * t1378 - 0.2e1 * t124 * t1386 - 0.2e1 * t124 * t1389 - t124 * t1392 - t124 * t1411 - 0.64e2 * t513 * t1367 + 0.12e2 * t1371 * t514 + 0.16e2 * t371 * t1375 + 0.2e1 * t288 * t1383 - 0.16e2 * t521 * t389;
  t1415 = t1333 + 0.4e1 * t164 * t1334 - 0.3e1 / 0.4e1 * t376 * t524 - 0.5e1 * t164 * t1340 + t1330 + 0.12e2 * t1343 * t514 + 0.16e3 * t513 * t1347 + 0.6e1 * t1350 * t166 + 0.6e1 * t521 * t380 - 0.3e1 / 0.2e1 * t513 * t1356 + 0.3e1 / 0.4e1 * t1359 * t1361 + t1413;
  t1420 = my_piecewise3(t3, 0, -t7 * t89 * t547 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1415);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1420 + 0.2e1 * t551;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1428 = t678 * t207;
  t1429 = t165 * t118;
  t1430 = t107 * t1429;
  t1433 = t717 * t207;
  t1434 = t165 * t141;
  t1435 = t107 * t1434;
  t1440 = t678 * t193;
  t1485 = t657 * t81;
  t1486 = t206 * t175;
  t1487 = t1486 * t141;
  t1490 = 0.6e1 * t245 * t559 * t118 + 0.6e1 * t245 * t567 * t118 - 0.3e1 * t250 * t576 * t118 - 0.3e1 * t250 * t589 * t118 - 0.3e1 * t250 * t559 * t141 - 0.3e1 * t250 * t567 * t141 + 0.2e1 * t288 * t576 * t141 + 0.2e1 * t288 * t589 * t141 - 0.3e1 * t250 * t448 * t175 - 0.3e1 * t250 * t467 * t175 + 0.2e1 * t288 * t476 * t175 + 0.2e1 * t288 * t500 * t175 - 0.3e1 * t250 * t193 * t417 + 0.2e1 * t288 * t207 * t417 + 0.4e2 * t553 * t1231 - 0.2e2 * t570 * t1231 - 0.6e1 * t1428 * t1430 + 0.6e1 * t1433 * t1435 - 0.6e1 * t1440 * t1435 - 0.6e1 * t1485 * t1487;
  t1491 = t192 * t175;
  t1492 = t1491 * t118;
  t1495 = t1491 * t141;
  t1498 = t1486 * t118;
  t1501 = t1225 * t455;
  t1503 = t1154 * tau[0];
  t1504 = t765 * t1503;
  t1507 = t455 * t112;
  t1508 = t765 * t1507;
  t1510 = t756 * t1503;
  t1513 = t1000 * t1507;
  t1515 = t137 * t1154;
  t1517 = t310 * t1515 * tau[0];
  t1520 = t800 * t1507;
  t1523 = t132 * t1173 * tau[0];
  t1526 = t132 * t584 * t276;
  t1528 = -0.12e2 * t1501 - 0.12e3 * t1504 + 0.52e2 * t534 + 0.36e2 * t1508 + 0.24e3 * t1510 - 0.78e2 * t514 - 0.192e4 * t1513 - 0.96e4 * t1517 + 0.208e4 * t538 + 0.288e4 * t1520 + 0.1344e5 * t1523 - 0.2496e4 * t1526;
  t1529 = t81 * t1528;
  t1531 = t180 * t499;
  t1533 = t150 * t588;
  t1535 = t150 * t566;
  t1539 = t1154 * t62;
  t1540 = t1539 * tau[0];
  t1545 = -0.26e2 / 0.3e1 * t524 + 0.4e2 / 0.3e1 * t1540 - 0.4e1 * t1501 - 0.4e2 * t1504 + 0.52e2 / 0.3e1 * t534;
  t1546 = t81 * t1545;
  t1549 = t429 * t206;
  t1551 = t429 * t192;
  t1554 = t180 * t466;
  t1561 = t250 * t476;
  t1564 = t250 * t500;
  t1569 = t1370 * t193;
  t1572 = t245 * t448;
  t1575 = t245 * t467;
  t1580 = 0.6e1 * t1041 * t1495 + 0.6e1 * t1041 * t1498 + 0.3e1 * t106 * t1535 + 0.3e1 * t106 * t1546 + 0.3e1 * t106 * t1551 + 0.3e1 * t106 * t1554 - 0.6e1 * t1087 * t1492 - t124 * t1529 - t124 * t1531 - t124 * t1533 - t124 * t1549 - 0.3e1 * t1561 * t166 - 0.3e1 * t1564 * t166 + 0.6e1 * t1569 * t166 + 0.6e1 * t1572 * t166 + 0.6e1 * t1575 * t166 + 0.6e1 * t553 * t380 - 0.3e1 * t570 * t380 - 0.16e2 * t553 * t389 + 0.8e1 * t570 * t389;
  t1581 = t1490 + t1580;
  t1586 = my_piecewise3(t3, 0, -t7 * t89 * t591 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1581);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1586 + 0.2e1 * t595;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1594 = t598 * t141;
  t1597 = t150 * t597;
  t1600 = t193 * t466;
  t1603 = t192 * t206;
  t1604 = t1603 * t118;
  t1607 = t1603 * t141;
  t1626 = t150 * t613;
  t1630 = 0.1e1 / t354;
  t1631 = t1630 * t62;
  t1634 = t1225 * t606;
  t1636 = t1630 * tau[0];
  t1637 = t765 * t1636;
  t1640 = t606 * t112;
  t1641 = t765 * t1640;
  t1643 = t756 * t1636;
  t1646 = 0.16e3 / 0.3e1 * t562 - 0.32e3 / 0.3e1 * t1631 * tau[0] + 0.64e2 * t1634 + 0.64e3 * t1637 - 0.64e3 / 0.3e1 * t564 - 0.96e2 * t1641 - 0.64e3 * t1643 + 0.16e3 * t579;
  t1647 = t81 * t1646;
  t1656 = t150 * t617;
  t1668 = t150 * t635;
  t1684 = t137 * t1630;
  t1691 = t323 * t1630;
  t1698 = t740 * t1630;
  t1705 = -0.21504e6 * t132 * t1691 * tau[0] + 0.768e5 * t310 * t1684 * tau[0] + 0.14336e6 * t67 * t1698 * tau[0] - 0.1792e5 * t67 * t631 * t454 + 0.1536e5 * t1000 * t1640 + 0.32e4 * t775 * t1636 + 0.576e3 * t756 * t1640 + 0.32256e5 * t789 * t1640 - 0.4608e5 * t800 * t1640 - 0.64e3 * t305 * t455 + 0.96e2 * t1634 + 0.96e3 * t1637 - 0.576e3 * t1641 - 0.384e4 * t1643 - 0.32e3 * t564 + 0.96e3 * t579 - 0.128e5 * t582 + 0.3072e5 * t586;
  t1706 = t81 * t1705;
  t1708 = -0.3e1 * t250 * t636 * t118 + 0.6e1 * t717 * t618 * t118 - 0.3e1 * t250 * t614 * t141 + 0.2e1 * t288 * t636 * t141 - 0.6e1 * t657 * t618 * t141 + 0.4e1 * t288 * t207 * t499 + 0.3e1 * t106 * t1626 + 0.3e1 * t106 * t1647 - t124 * t1668 - t124 * t1706 + 0.2e1 * t288 * t1656;
  t1709 = 0.6e1 * t245 * t614 * t118 - 0.6e1 * t250 * t193 * t499 - 0.6e1 * t250 * t448 * t206 - 0.6e1 * t250 * t467 * t206 + 0.12e2 * t1041 * t1607 - 0.12e2 * t1087 * t1604 + 0.6e1 * t1370 * t598 - 0.6e1 * t678 * t1594 + 0.6e1 * t245 * t1597 + 0.12e2 * t245 * t1600 + t1708;
  t1714 = my_piecewise3(t3, 0, -t7 * t89 * t638 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * t1709);
  tv3rhotau20 = 0.2e1 * rho[0] * t1714 + 0.2e1 * t642;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1717 = t765 * t743;
  t1722 = t669 * t743;
  t1724 = t667 * t1722;
  t1726 = 0.125e3 / 0.6377292e7 * t696 * t1722 - 0.125e3 / 0.6377292e7 * t1724;
  t1728 = t743 * t74;
  t1732 = t527 * t175;
  t1733 = t81 * t1732;
  t1739 = t33 * t527;
  t1740 = t366 * t1739;
  t1744 = t180 * t527;
  t1747 = t545 * t175;
  t1750 = t180 * t540;
  t1754 = t70 * t743;
  t1755 = t731 * t1754;
  t1757 = -0.3e1 / 0.8e1 * t1339 - 0.6e2 * t1755;
  t1758 = t81 * t1757;
  t1760 = t106 * t545;
  t1763 = t245 * t180;
  t1766 = t54 * t175;
  t1767 = t403 * t1766;
  t1772 = t33 * t540;
  t1773 = t366 * t1772;
  t1776 = t1263 * t1292;
  t1779 = -0.9e1 * t513 * t1717 - 0.9e1 / 0.4e1 * t521 * t524 + t75 * t1726 + 0.24e2 * t775 * t1728 * t81 - 0.6e1 * t657 * t1733 + 0.6e1 * t288 * t176 * t540 + 0.18e2 * t870 * t1740 + 0.125e3 / 0.6377292e7 * t1724 + 0.6e1 * t288 * t1744 - 0.3e1 * t124 * t1747 - 0.3e1 * t124 * t1750 - t124 * t1758 + 0.9e1 * t1760 * t166 + 0.36e2 * t1763 * t514 + 0.9e1 / 0.4e1 * t1359 * t1767 - 0.18e2 * t1281 * t518 - 0.9e1 * t371 * t1773 - 0.36e2 * t1262 * t1776;
  t1783 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1779);
  tv3sigma30 = 0.2e1 * rho[0] * t1783;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1813 = t180 * t566;
  t1816 = t545 * t206;
  t1818 = t180 * t588;
  t1821 = 0.3e1 * t106 * t81 * t1154 * t62 - 0.6e1 * t250 * t559 * t175 - 0.6e1 * t250 * t567 * t175 + 0.4e1 * t288 * t576 * t175 + 0.4e1 * t288 * t589 * t175 - 0.3e1 * t250 * t193 * t540 + 0.6e1 * t717 * t193 * t527 + 0.2e1 * t288 * t207 * t540 - 0.6e1 * t657 * t207 * t527 + 0.6e1 * t106 * t1813 - t124 * t1816 - 0.2e1 * t124 * t1818;
  t1823 = t765 * t1154;
  t1825 = t70 * t1154;
  t1826 = t731 * t1825;
  t1828 = t310 * t1515;
  t1830 = 0.3e1 * t1539 - 0.9e1 * t1823 + 0.48e3 * t1826 - 0.72e3 * t1828;
  t1831 = t81 * t1830;
  t1833 = t545 * t192;
  t1836 = t245 * t567;
  t1839 = t250 * t576;
  t1842 = t250 * t589;
  t1847 = t245 * t559;
  t1850 = t165 * t175;
  t1851 = t107 * t1850;
  t1856 = t271 * t27;
  t1857 = t276 * t74;
  t1861 = t192 * t27;
  t1862 = t276 * t54;
  t1863 = t1861 * t1862;
  t1866 = t206 * t27;
  t1867 = t1866 * t1862;
  t1870 = -t124 * t1831 + 0.3e1 * t106 * t1833 + 0.12e2 * t1836 * t166 - 0.6e1 * t1839 * t166 - 0.6e1 * t1842 * t166 - 0.12e2 * t1428 * t514 + 0.12e2 * t1847 * t166 + 0.12e2 * t1433 * t1851 - 0.12e2 * t1440 * t1851 + 0.12e2 * t1856 * t1857 * t193 - 0.3e1 / 0.2e1 * t513 * t1863 + 0.3e1 / 0.4e1 * t1359 * t1867;
  t1871 = t1821 + t1870;
  t1875 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1871);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t1875;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t1877 = t107 * t28;
  t1878 = t33 * t74;
  t1879 = t1878 * t598;
  t1882 = t598 * t175;
  t1885 = t180 * t597;
  t1888 = t193 * t566;
  t1891 = t206 * t47;
  t1892 = t366 * t33;
  t1893 = t1891 * t1892;
  t1896 = t1603 * t175;
  t1908 = t245 * t614;
  t1915 = t180 * t613;
  t1919 = t765 * t1630;
  t1921 = -0.16e2 * t1631 + 0.24e2 * t1919;
  t1922 = t81 * t1921;
  t1925 = t717 * t618;
  t1931 = t180 * t617;
  t1937 = t250 * t636;
  t1943 = t180 * t635;
  t1947 = t756 * t1630;
  t1949 = t70 * t1630;
  t1950 = t731 * t1949;
  t1952 = t310 * t1684;
  t1954 = t132 * t1691;
  t1956 = -0.24e2 * t1631 + 0.144e3 * t1919 - 0.144e3 * t1947 - 0.384e4 * t1950 + 0.1152e5 * t1952 - 0.8064e4 * t1954;
  t1957 = t81 * t1956;
  t1959 = -0.3e1 * t250 * t614 * t175 + 0.2e1 * t288 * t636 * t175 - 0.6e1 * t657 * t618 * t175 + 0.4e1 * t288 * t207 * t588 + 0.3e1 * t106 * t1915 + 0.3e1 * t106 * t1922 - t124 * t1943 - t124 * t1957 + 0.6e1 * t1925 * t166 - 0.3e1 * t1937 * t166 + 0.2e1 * t288 * t1931;
  t1960 = -0.6e1 * t250 * t193 * t588 - 0.6e1 * t250 * t559 * t206 - 0.6e1 * t250 * t567 * t206 + 0.12e2 * t1041 * t1896 - 0.12e2 * t1440 * t1893 + 0.6e1 * t1908 * t166 + 0.6e1 * t1877 * t1879 - 0.6e1 * t678 * t1882 + 0.6e1 * t245 * t1885 + 0.12e2 * t245 * t1888 + t1959;
  t1964 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t1960);
  tv3sigmatau20 = 0.2e1 * rho[0] * t1964;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t1966 = t597 * t192;
  t1967 = t1966 * t74;
  t1970 = t598 * t206;
  t1973 = t193 * t613;
  t1985 = 0.1e1 / t274;
  t1987 = 0.192e3 * t1985 * t62;
  t1988 = t765 * t1985;
  t1990 = t756 * t1985;
  t1992 = t1987 - 0.576e3 * t1988 + 0.384e3 * t1990;
  t1993 = t81 * t1992;
  t1996 = t617 * t206;
  t1997 = t81 * t1996;
  t2007 = t70 * t1985;
  t2010 = t137 * t1985;
  t2013 = t323 * t1985;
  t2016 = t740 * t1985;
  t2019 = 0.193536e6 * t132 * t2013 - 0.192e4 * t775 * t1985 + 0.3072e5 * t731 * t2007 - 0.13824e6 * t310 * t2010 - 0.86016e5 * t67 * t2016 + t1987 - 0.1728e4 * t1988 + 0.3456e4 * t1990;
  t2020 = t81 * t2019;
  t2022 = -0.9e1 * t250 * t193 * t635 + 0.18e2 * t717 * t193 * t617 - 0.9e1 * t250 * t614 * t206 + 0.6e1 * t288 * t207 * t635 + 0.3e1 * t106 * t1993 - t124 * t2020 + 0.6e1 * t1967 * t81 - 0.18e2 * t678 * t1970 + 0.18e2 * t245 * t1973 - 0.6e1 * t657 * t1997;
  t2026 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t2022);
  tv3tau30 = 0.2e1 * rho[0] * t2026;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t2046 = t93 / t694 / t76;
  t2047 = t229 * t229;
  t2048 = t669 * t2047;
  t2054 = 0.1e1 / t31 / t672 / t354 * t21 * t160;
  t2057 = t672 * t231;
  t2059 = t671 / t2057;
  t2065 = t230 * t27 / t19 / t1318;
  t2069 = 0.1e1 / t31 / t354;
  t2070 = t28 * t2069;
  t2071 = t98 * t2070;
  t2076 = t93 / t665 / t37;
  t2079 = 0.64e6 / 0.31381059609e11 * t2076 * t2048 * t2054;
  t2081 = 0.352e6 / 0.43046721e8 * t667 * t2059;
  t2083 = 0.3916e6 / 0.4782969e7 * t226 * t2065;
  t2085 = 0.2618e5 / 0.19683e5 * t97 * t2071;
  t2108 = t58 * t656;
  t2127 = t808 * t123;
  t2130 = t329 * t329;
  t2136 = t59 / t655 / t73;
  t2137 = t289 * t289;
  t2147 = 0.24e2 * t809 * t150 + t75 * (-0.64e6 / 0.31381059609e11 * t2046 * t2048 * t2054 + 0.352e6 / 0.43046721e8 * t696 * t2059 - 0.3916e6 / 0.4782969e7 * t335 * t2065 + 0.2618e5 / 0.19683e5 * t147 * t2071 + t2079 - t2081 + t2083 - t2085) + 0.36e2 * t1066 * t283 + 0.8e1 * t288 * t142 * t805 - 0.72e2 * t678 * t812 * t141 - 0.36e2 * t678 * t247 * t329 - 0.36e2 * t657 * t290 * t329 + 0.24e2 * t288 * t293 * t329 - 0.12e2 * t250 * t119 * t805 - 0.72e2 * t2108 * t659 * t118 - 0.36e2 * t250 * t815 * t141 - 0.36e2 * t250 * t818 * t141 - 0.36e2 * t250 * t254 * t329 - 0.12e2 * t250 * t843 * t141 - 0.18e2 * t250 * t283 * t329 - 0.24e2 * t2127 * t142 + 0.6e1 * t288 * t81 * t2130 + 0.24e2 * t2136 * t81 * t2137 + 0.72e2 * t245 * t254 * t282 + 0.24e2 * t245 * t119 * t842;
  t2151 = t57 * t287;
  t2158 = t282 * t282;
  t2164 = t42 * t706;
  t2168 = 0.616e4 / 0.81e2 * t2164 - 0.2618e4 / 0.81e2 * t29 * t2069;
  t2171 = t268 * t268;
  t2177 = t273 * t234;
  t2182 = t60 * t137;
  t2183 = t272 * t272;
  t2185 = 0.1e1 / t31 / t923;
  t2187 = t2183 * t2185 * t28;
  t2196 = t732 * t127;
  t2199 = t48 * t70;
  t2201 = t112 * t741 * t743;
  t2208 = t731 * t137;
  t2216 = t310 * t323;
  t2230 = 0.288e3 * t823 * t268 + 0.24e2 * t115 * t2168 + 0.144e3 * t260 * t2171 - 0.57344e8 / 0.9e1 * t67 * t742 * t1319 + 0.8704e6 / 0.27e2 * t305 * t2177 - 0.4928e5 / 0.27e2 * t128 * t2164 + 0.8e6 / 0.9e1 * t2182 * t2187 + 0.4608e5 * t731 * t311 * t268 + 0.768e4 * t310 * t133 * t753 + 0.96e3 * t2196 * t108 + 0.32e6 / 0.3e1 * t2199 * t2201 + 0.5376e6 * t789 * t268 * t272 * t403 + 0.3072e6 * t2208 * t732 * tau[0] * t165 + 0.45056e6 / 0.3e1 * t314 * t315 * t241 + 0.2688e7 * t2216 * t257 * t272 * t403 - 0.3072e6 * t800 * t801 * t102 + 0.288e4 * t826 * t786 + 0.1536e5 * t314 * t753 * tau[0] * t165;
  t2243 = params->b * t48;
  t2244 = t257 * t257;
  t2251 = t741 * t1319;
  t2262 = t47 * t304;
  t2268 = t132 * t740;
  t2272 = 0.1e1 / t322 / t53;
  t2273 = t67 * t2272;
  t2283 = t241 * t112;
  t2290 = -0.6144e5 * t314 * t785 * t102 - 0.28672e7 * t789 * t790 * t994 + 0.384e3 * t132 * t70 * t2168 + 0.192e3 * t260 * t753 * t112 + 0.2304e5 * t2243 * t70 * t2244 + 0.576e4 * t310 * t70 * t2171 - 0.128e7 / 0.9e1 * t775 * t2251 - 0.78848e6 / 0.27e2 * t138 * t2164 - 0.384e4 * t766 * t264 - 0.192e4 * t769 * t264 + 0.243712e8 / 0.27e2 * t324 * t2177 + 0.192e5 * t2262 * t257 * t277 - 0.512e5 * t757 * t760 + 0.28672e8 / 0.3e1 * t2268 * t2201 + 0.1792e8 / 0.3e1 * t2273 * t2187 + 0.48e3 * t271 * t753 * t108 + 0.96e4 * t756 * t268 * t277 + 0.1408e5 / 0.3e1 * t271 * tau[0] * t2283 + 0.2304e6 * t310 * t137 * t112 * t786;
  t2328 = t257 * t127;
  t2343 = -0.2176e6 / 0.27e2 * t271 * t2177 + 0.4928e5 / 0.81e2 * t115 * t2164 - 0.32e3 * t1225 * t268 * t108 + 0.128e4 / 0.3e1 * t823 * t264 - 0.16e4 * t765 * t268 * t277 - 0.32e3 / 0.3e1 * t260 * t753 * t108 - 0.24e2 * t2171 * t54 - 0.32e2 * t379 * t753 - 0.8e1 * t107 * t2168 - 0.16e4 * t2328 * t277 - 0.128e6 / 0.9e1 * t2262 * t2201 + 0.256e6 / 0.9e1 * t756 * t2251 - 0.4e6 / 0.27e2 * t2199 * t2187 + 0.256e5 / 0.3e1 * t826 * t760 + 0.128e4 / 0.3e1 * t829 * t264 - 0.2816e5 / 0.27e2 * t261 * t749;
  t2366 = t118 * t141;
  t2370 = 0.72e2 * t1041 * t141 * t329 * t118 + 0.12e2 * t106 * t715 * t118 + 0.12e2 * t106 * t150 * t842 + 0.3e1 * t106 * t81 * t2343 + 0.18e2 * t106 * t340 * t282 - 0.72e2 * t1087 * t2366 * t282 - 0.4e1 * t124 * t715 * t141 - 0.24e2 * t657 * t150 * t658 + 0.36e2 * t245 * t340 * t246 + 0.12e2 * t288 * t340 * t289 - t2079;
  t2377 = my_piecewise3(t3, 0, 0.1e2 / 0.27e2 * t7 * t18 * t101 * t83 - 0.5e1 / 0.9e1 * t7 * t645 * t152 + t7 * t216 * t342 / 0.2e1 - t7 * t89 * t847 / 0.2e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t2147 + 0.36e2 * t717 * t283 * t289 - t2083 + t2085 + t2081 + 0.72e2 * t2151 * t247 * t289 + 0.72e2 * t717 * t254 * t289 + 0.18e2 * t245 * t81 * t2158 - t124 * t81 * (t2230 + t2290) - 0.4e1 * t124 * t150 * t805 - 0.6e1 * t124 * t340 * t329 + t2370));
  tv4rho40 = 0.2e1 * rho[0] * t2377 + 0.8e1 * t852;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t2390 = t276 * t329;
  t2397 = t678 * t883;
  t2419 = t678 * t879;
  t2422 = t2151 * t364;
  t2431 = t276 * t289;
  t2444 = 0.12e3 * t365 * t384 * t276 * t282 * tau[0] - 0.96e3 * t365 * t384 * t862 * t118 - 0.18e2 * t908 * t366 * t897 * t118 + 0.96e2 * t908 * t366 * t866 * t141 - 0.18e2 * t908 * t366 * t887 * t141 + 0.48e3 * t371 * t384 * t862 * t141 - 0.6e2 * t371 * t384 * t2390 * tau[0] + 0.36e2 * t2422 * t366 * t367 * t289 + 0.12e3 * t870 * t384 * t2431 * tau[0] - 0.36e2 * t2397 * t910 - 0.36e2 * t2419 * t910 + 0.24e3 * t880 * t915 + 0.24e3 * t884 * t915 - 0.12e3 * t891 * t920 - 0.12e3 * t894 * t920;
  t2451 = t364 * t62;
  t2452 = t678 * t2451;
  t2493 = 0.18e2 * t870 * t366 * t897 * t141 - 0.24e3 * t2452 * t403 * t2366 * tau[0] - 0.18e2 * t250 * t1023 * t141 - 0.9e1 * t250 * t1026 * t141 - 0.18e2 * t678 * t1038 * t141 + 0.24e2 * t2136 * t176 * t658 + 0.18e2 * t245 * t420 * t282 - 0.18e2 * t678 * t398 * t246 - 0.18e2 * t678 * t418 * t246 - 0.9e1 * t250 * t420 * t329 + 0.6e1 * t288 * t423 * t329 - 0.18e2 * t657 * t398 * t289 - 0.18e2 * t657 * t418 * t289 + 0.18e2 * t717 * t420 * t289 + 0.6e1 * t809 * t180;
  t2502 = t353 * t700 * sigma[0];
  t2504 = 0.341e5 / 0.1594323e7 * t226 * t2502;
  t2534 = t2108 * t81;
  t2541 = 0.88e2 * t164 * t379 * t241 - 0.1232e4 / 0.9e1 * t164 * t107 * t707 + t2504 - 0.48e2 * t1067 * t389 + 0.6e1 * t288 * t1021 * t141 + 0.6e1 * t288 * t418 * t329 + 0.2e1 * t288 * t176 * t805 + 0.6e1 * t288 * t398 * t329 - 0.9e1 * t250 * t1021 * t118 - 0.9e1 * t250 * t418 * t282 - 0.3e1 * t250 * t176 * t842 + 0.6e1 * t288 * t1029 * t141 + 0.12e2 * t288 * t1031 * t141 - 0.54e2 * t2534 * t1042 * t289 - 0.9e1 * t250 * t1029 * t118;
  t2549 = t669 * t674 * t229;
  t2551 = 0.38e5 / 0.14348907e8 * t667 * t2549;
  t2552 = t1319 * t272;
  t2556 = t2151 * t81;
  t2561 = t160 * t706;
  t2563 = 0.154e4 / 0.6561e4 * t97 * t2561;
  t2564 = t175 * t329;
  t2571 = t175 * t282;
  t2582 = t717 * t150;
  t2594 = 0.36e2 * t1041 * t417 * t118 * t141 + 0.36e2 * t2556 * t175 * t246 * t141 - 0.18e2 * t250 * t1031 * t118 + 0.18e2 * t1041 * t2564 * t118 + 0.18e2 * t1041 * t2571 * t141 + 0.9e1 * t106 * t942 * t118 - 0.18e2 * t1087 * t2571 * t118 - 0.3e1 * t124 * t942 * t141 - 0.18e2 * t1485 * t2564 * t141 - 0.32e4 * t164 * t765 * t2552 - 0.9e1 * t250 * t398 * t282 + 0.6e1 * t288 * t429 * t289 + 0.36e2 * t2582 * t1043 - t2551 - t2563;
  t2608 = t165 * t753;
  t2612 = t2185 * t741 * t28;
  t2617 = t235 * tau[0];
  t2631 = t743 * t112;
  t2632 = t2631 * t272;
  t2635 = t102 * t268;
  t2644 = -0.6e1 * t260 * t2608 - 0.1e5 / 0.3e1 * t2199 * t2612 - 0.176e3 * t260 * t2283 - 0.544e4 / 0.3e1 * t271 * t2617 + 0.3584e6 * t132 * t323 * t1319 * t272 + 0.19712e5 / 0.9e1 * t132 * t171 * t706 - 0.18e2 * t1225 * t988 - 0.18e3 * t2328 * t404 - 0.24e4 * t2262 * t2632 + 0.48e2 * t260 * t2635 - 0.336e6 * t2216 * t2632 + 0.192e4 * t409 * t2635 - 0.24e3 * t409 * t2608;
  t2647 = t276 * t268;
  t2658 = t356 * t112;
  t2662 = t2243 * t70;
  t2684 = -0.896e6 / 0.3e1 * t2268 * t2612 - 0.18e3 * t980 * t2647 * tau[0] + 0.768e4 * t1000 * t102 * t257 - 0.704e4 * t409 * t2283 - 0.17408e6 / 0.3e1 * t314 * t2617 + 0.144e4 * t980 * t2658 * tau[0] - 0.288e4 * t2662 * t165 * t732 + 0.48e2 * t823 * t102 + 0.64e4 * t756 * t2552 + 0.1232e4 / 0.9e1 * t115 * t707 + 0.1152e6 * t800 * t994 * t315 - 0.288e4 * t1000 * t165 * t772 - 0.576e5 * t2208 * t403 * t801 - 0.144e5 * t800 * t403 * t785;
  t2702 = t669 / t31 / t672 / t274;
  t2705 = t670 * t21 * t160;
  t2716 = 0.8e5 / 0.10460353203e11 * t2076 * t2702 * t2705;
  t2727 = t112 * t127;
  t2733 = -t124 * t180 * t805 + 0.18e2 * t245 * t429 * t246 - 0.3e1 * t124 * t429 * t329 + 0.3e1 * t106 * t180 * t842 - t124 * t81 * (t2644 + t2684) + 0.9e1 * t106 * t429 * t282 - 0.3e1 * t124 * t150 * t1020 - 0.3e1 * t124 * t340 * t417 - t124 * t715 * t175 + t75 * (0.8e5 / 0.10460353203e11 * t2046 * t2702 * t2705 - 0.38e5 / 0.14348907e8 * t696 * t2549 + 0.341e5 / 0.1594323e7 * t335 * t2502 - 0.154e4 / 0.6561e4 * t147 * t2561 - t2716 + t2551 - t2504 + t2563) + 0.88e2 * t376 * t1063 + 0.18e2 * t1066 * t150 * t166 - 0.24e2 * t164 * t1051 * t102 + 0.6e3 * t164 * t2727 * t991 + 0.18e2 * t1067 * t380;
  t2741 = t753 * t54;
  t2756 = t127 * t743;
  t2765 = t304 * t2185;
  t2770 = t150 * t112;
  t2776 = 0.3e1 * t106 * t715 * t166 + 0.9e1 * t1046 * t380 + 0.9e1 * t376 * t1052 + 0.3e1 * t164 * t2741 * t165 - 0.24e2 * t1046 * t389 - 0.48e2 * t376 * t1060 + 0.6e3 * t376 * t1055 - 0.6e1 * t657 * t180 * t658 - 0.6e1 * t2127 * t176 + 0.12e4 * t365 * t2756 * t272 * t118 - 0.6e3 * t371 * t2756 * t272 * t141 + 0.4e4 / 0.3e1 * t383 * t2765 * t741 * t28 + t2716 + 0.12e3 * t106 * t2770 * t386 - 0.48e3 * t905 * t863;
  t2778 = t81 * t268;
  t2794 = t246 * t123;
  t2795 = t2794 * t364;
  t2801 = t2108 * t364;
  t2822 = t717 * t879;
  t2827 = t717 * t883;
  t2830 = 0.6e2 * t106 * t2778 * t386 + 0.176e3 * t365 * t366 * t240 * t118 - 0.88e2 * t371 * t366 * t240 * t141 + 0.1088e5 / 0.9e1 * t383 * t384 * t234 * tau[0] - 0.18e2 * t2795 * t373 + 0.12e3 * t1066 * t364 * t386 - 0.18e2 * t2801 * t366 * t33 * t658 - 0.48e2 * t870 * t366 * t101 * t289 + 0.24e2 * t371 * t366 * t101 * t329 - 0.96e2 * t880 * t867 - 0.96e2 * t884 * t867 - 0.48e2 * t365 * t366 * t101 * t282 + 0.18e2 * t2822 * t872 + 0.48e2 * t891 * t876 + 0.18e2 * t2827 * t872;
  t2838 = t1370 * t364;
  t2845 = t340 * t47;
  t2846 = t250 * t2845;
  t2849 = t250 * t2770;
  t2854 = t250 * t2778;
  t2876 = 0.6e1 * t365 * t366 * t33 * t842 - 0.3e1 * t371 * t366 * t33 * t805 + 0.6e2 * t106 * t2845 * t386 + 0.36e2 * t245 * t2770 * t368 + 0.18e2 * t245 * t2778 * t368 + 0.18e2 * t245 * t2845 * t368 + 0.18e2 * t2838 * t888 - 0.9e1 * t2846 * t373 - 0.18e2 * t2849 * t373 - 0.9e1 * t2854 * t373 - 0.48e3 * t901 * t863 + 0.48e2 * t894 * t876 + 0.18e2 * t880 * t888 + 0.18e2 * t884 * t888 - 0.9e1 * t891 * t898 - 0.9e1 * t894 * t898;
  t2884 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t645 * t182 + t7 * t216 * t431 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t89 * t1072 - 0.3e1 / 0.8e1 * t7 * t20 * (t2444 + t2493 + t2541 + t2594 + t2733 + t2776 + t2830 + t2876));
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2884 + 0.6e1 * t1077;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t2927 = t1225 * t404;
  t2929 = t260 * t995;
  t2931 = t2328 * t456;
  t2934 = t454 * t268 * tau[0];
  t2935 = t980 * t2934;
  t2938 = t268 * t62;
  t2944 = 0.1e1 / t31 / t1318;
  t2946 = t2944 * t741 * t28;
  t2950 = t1154 * t112;
  t2951 = t2950 * t272;
  t2952 = t2262 * t2951;
  t2954 = 0.96e3 * t2927 - 0.5248e5 / 0.27e2 * t2929 + 0.48e3 * t2931 + 0.48e3 * t2935 + 0.4e2 * t1052 - 0.16e3 * t2938 * t456 - 0.32e3 / 0.3e1 * t1060 + 0.208e5 / 0.3e1 * t1055 - 0.32e5 / 0.9e1 * t2262 * t2946 + 0.352e4 / 0.27e2 * t1063 + 0.64e4 * t2952;
  t2955 = t1225 * t1170;
  t2957 = t188 * t753;
  t2958 = t260 * t2957;
  t2960 = t2199 * t2946;
  t2973 = 0.48e2 * t2955 + 0.16e2 * t2958 + 0.8e5 / 0.9e1 * t2960 - 0.8e1 * t2741 * t188 - 0.16e4 * t2727 * t1155 - 0.8e2 * t978 - 0.8e2 * t989 - 0.352e4 / 0.27e2 * t998 + 0.64e3 / 0.3e1 * t986 - 0.288e4 * t983 + 0.2624e5 / 0.9e1 * t996 - 0.416e5 / 0.3e1 * t992;
  t2983 = 0.36e2 * t2556 * t1088 * t289 - 0.54e2 * t2534 * t1098 * t289 + 0.18e2 * t245 * t448 * t282 + 0.2e1 * t288 * t207 * t805 + 0.18e2 * t1370 * t1119 + 0.18e2 * t245 * t1217 * t118 + 0.36e2 * t245 * t1220 * t118 - 0.3e1 * t124 * t150 * t1214 - 0.3e1 * t124 * t340 * t499 + 0.18e2 * t1066 * t467 - t124 * t715 * t206 + 0.3e1 * t106 * t81 * (t2954 + t2973) + 0.18e2 * t1066 * t448 + 0.6e1 * t288 * t500 * t329;
  t3029 = -0.9e1 * t250 * t1144 * t118 + 0.6e1 * t288 * t1144 * t141 - 0.18e2 * t250 * t1146 * t118 + 0.12e2 * t288 * t1146 * t141 - 0.9e1 * t250 * t1215 * t118 + 0.6e1 * t288 * t1215 * t141 - 0.3e1 * t250 * t207 * t842 - 0.18e2 * t678 * t476 * t246 - 0.18e2 * t678 * t500 * t246 - 0.9e1 * t250 * t500 * t282 + 0.6e1 * t288 * t476 * t329 + 0.18e2 * t717 * t448 * t289 + 0.18e2 * t717 * t467 * t289 - 0.18e2 * t657 * t476 * t289 - 0.18e2 * t657 * t500 * t289;
  t3065 = 0.8e5 / 0.3e1 * t2960 - 0.16e6 / 0.3e1 * t2182 * t2946 + 0.93184e7 / 0.3e1 * t67 * t740 * t743 * t272 + 0.144e4 * t2931 + 0.72e3 * t765 * t1001 - 0.96e3 * t271 * t985 - 0.10496e6 / 0.9e1 * t305 * t995 + 0.5632e5 / 0.9e1 * t67 * t202 * t240 + 0.192e5 * t2952 + 0.36e3 * t271 * t988 - 0.48e5 * t2199 * t2951 - 0.72e2 * t271 * t2957 + 0.144e3 * t2955;
  t3072 = t455 * t801;
  t3075 = t455 * t785;
  t3082 = t188 * t772;
  t3090 = 0.48e2 * t2958 + 0.64e3 * t986 - 0.24e3 * t989 + 0.2624e5 / 0.3e1 * t996 - 0.23296e7 * t1013 - 0.5632e5 / 0.9e1 * t1018 - 0.8064e6 * t2216 * t3072 - 0.16128e6 * t789 * t3075 + 0.4608e6 * t2208 * t3072 + 0.96768e6 * t789 * t1004 + 0.2304e5 * t1000 * t3082 + 0.1152e6 * t800 * t3075 - 0.3456e5 * t800 * t3082 - 0.416e5 * t992;
  t3100 = t188 * t732;
  t3124 = -0.352e4 / 0.9e1 * t998 - 0.24e3 * t978 + 0.192e4 * t409 * t2957 - 0.2304e4 * t314 * t2957 - 0.3072e5 * t314 * t985 - 0.4608e5 * t2208 * t3100 + 0.576e5 * t800 * t1001 + 0.1152e5 * t314 * t988 + 0.2304e5 * t2662 * t3100 - 0.293888e7 / 0.9e1 * t324 * t995 + 0.144e4 * t2935 - 0.432e3 * t765 * t28 * t44 * t112 * t268 - 0.576e4 * t2262 * t27 * t454 * t257 * tau[0] - 0.288e4 * t1194 * t2934;
  t3147 = 0.2688e7 * t2216 * t2951 + 0.7168e7 / 0.3e1 * t2268 * t2946 - 0.43008e7 * t2268 * t2951 - 0.3584e7 * t2273 * t2946 + 0.1728e5 * t1194 * t982 - 0.864e4 * t983 - 0.384e5 * t1002 + 0.256e5 * t1007 - 0.96e4 * t1009 + 0.83968e6 / 0.3e1 * t1015 + 0.352e4 / 0.9e1 * t128 * t241 + 0.208e6 / 0.3e1 * t775 * t991 - 0.144e3 * t2196 * t188 - 0.6912e6 * t1005;
  t3185 = -0.9e1 * t250 * t476 * t282 + 0.9e1 * t106 * t150 * t1241 + 0.9e1 * t106 * t340 * t466 - t124 * t81 * (t3065 + t3090 + t3124 + t3147) + 0.3e1 * t106 * t715 * t192 - 0.9e1 * t250 * t1242 * t141 - 0.9e1 * t250 * t467 * t329 - 0.3e1 * t250 * t193 * t805 - 0.9e1 * t250 * t1217 * t141 - 0.18e2 * t250 * t1220 * t141 - 0.9e1 * t250 * t448 * t329 + 0.18e2 * t245 * t1242 * t118 + 0.18e2 * t245 * t467 * t282 + 0.6e1 * t245 * t193 * t842 + 0.24e2 * t2136 * t207 * t658;
  t3193 = t206 * t141;
  t3224 = t192 * t141;
  t3228 = t678 * t150;
  t3235 = 0.36e2 * t1041 * t499 * t118 * t141 + 0.18e2 * t1041 * t206 * t282 * t141 - 0.36e2 * t1087 * t466 * t118 * t141 - 0.18e2 * t1087 * t192 * t282 * t141 + 0.36e2 * t2556 * t206 * t246 * t141 + 0.18e2 * t1041 * t1098 * t329 + 0.18e2 * t1041 * t3224 * t329 - 0.18e2 * t1087 * t1088 * t329 - 0.18e2 * t1087 * t1098 * t282 - 0.18e2 * t1485 * t3193 * t329 - 0.18e2 * t2108 * t193 * t658 - 0.36e2 * t3228 * t1089 + 0.36e2 * t2582 * t1099 - 0.6e1 * t2127 * t207 - 0.18e2 * t2794 * t445;
  t3242 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t645 * t209 + t7 * t216 * t502 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t89 * t1246 - 0.3e1 / 0.8e1 * t7 * t20 * (t2983 + t3029 + t3185 + t3235));
  tv4rho3tau0 = 0.2e1 * rho[0] * t3242 + 0.6e1 * t1251;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t3273 = t2185 * t272 * t28;
  t3276 = t1319 * tau[0];
  t3302 = 0.3e1 / 0.2e1 * t2938 * t403 + 0.3e2 * t2727 * t1346 - 0.16e2 * t1225 * t994 + 0.1e3 * t2262 * t3273 - 0.2e3 * t765 * t3276 + 0.152e3 / 0.3e1 * t260 * t235 + 0.72e3 * t2662 * t403 * t257 + 0.96e4 * t2208 * t2631 * tau[0] - 0.256e4 * t1000 * t994 * t112 + 0.24e3 * t1000 * t403 * t268 + 0.14e5 * t2216 * t3273 - 0.16e5 * t310 * t137 * t1319 * tau[0] + 0.608e4 / 0.3e1 * t310 * t536 * t234;
  t3333 = 0.2e1 * t288 * t340 * t527 - 0.2e1 * t124 * t942 * t175 - 0.4e1 * t124 * t429 * t417 + 0.3e1 * t106 * t545 * t282 - t124 * t545 * t329 - t124 * t81 * t3302 + 0.6e1 * t106 * t1331 * t118 - 0.2e1 * t124 * t1331 * t141 - 0.2e1 * t124 * t180 * t1020 - t124 * t340 * t540 - 0.2e1 * t124 * t150 * t1410 + 0.2e1 * t288 * t545 * t289 + 0.6e1 * t245 * t545 * t246 - 0.3e1 / 0.2e1 * t1067 * t524 + 0.24e2 * t2822 * t1289 - 0.8e2 * t891 * t1294 - 0.24e2 * t2397 * t1285;
  t3356 = t356 * t175;
  t3371 = t276 * t417;
  t3376 = t678 * t1257;
  t3390 = t175 * t141;
  t3400 = 0.24e2 * t2827 * t1289 - 0.36e2 * t2801 * t366 * t517 * t289 - 0.64e2 * t870 * t366 * t1374 * t141 + 0.64e2 * t908 * t366 * t1374 * t118 - 0.12e2 * t908 * t366 * t517 * t282 + 0.12e2 * t870 * t366 * t517 * t329 + 0.32e3 * t371 * t384 * t3356 * tau[0] - 0.8e2 * t894 * t1294 - 0.24e2 * t908 * t366 * t1274 * t118 + 0.24e2 * t870 * t366 * t1274 * t141 - 0.8e2 * t371 * t384 * t3371 * tau[0] - 0.24e2 * t3376 * t910 + 0.16e3 * t1278 * t915 - 0.8e2 * t1281 * t920 - 0.48e2 * t908 * t1263 * t918 * t112 - 0.24e2 * t2419 * t1285 + 0.16e3 * t717 * t2451 * t403 * t3390 * tau[0] + 0.48e2 * t2151 * t364 * t54 * t165 * t1043;
  t3427 = t669 / t31 / t2057;
  t3430 = t229 * t21 * t160;
  t3433 = t925 * sigma[0];
  t3436 = t353 * t234;
  t3441 = 0.1e5 / 0.3486784401e10 * t2076 * t3427 * t3430;
  t3443 = 0.1075e5 / 0.14348907e8 * t667 * t3433;
  t3445 = 0.19e4 / 0.531441e6 * t226 * t3436;
  t3448 = t417 * t417;
  t3472 = -0.16e3 * t2452 * t403 * t1042 * tau[0] - 0.128e3 * t1343 * t1367 - 0.64e4 / 0.3e1 * t513 * t756 * t3276 - 0.32e2 * t1350 * t389 - 0.3e1 / 0.2e1 * t1041 * t403 * t54 * t289 - 0.8e1 * t1359 * t994 * t1360 - 0.128e3 * t1371 * t1367 + 0.16e2 * t513 * t994 * t1355 + t75 * (-0.1e5 / 0.3486784401e10 * t2046 * t3427 * t3430 + 0.1075e5 / 0.14348907e8 * t696 * t3433 - 0.19e4 / 0.531441e6 * t335 * t3436 + t3441 - t3443 + t3445) + 0.4e1 * t288 * t81 * t3448 - 0.32e2 * t521 * t1060 + 0.12e2 * t1066 * t180 * t166 + 0.176e3 / 0.3e1 * t521 * t1063 + 0.24e2 * t513 * t2328 * t403 + 0.1216e4 / 0.3e1 * t513 * t271 * t235 + 0.12e2 * t1041 * t540 * t118 * t141 - 0.24e2 * t1485 * t3390 * t417;
  t3473 = t717 * t180;
  t3485 = t1319 * t62;
  t3507 = t250 * t150;
  t3514 = t141 * tau[0];
  t3518 = t2185 * t127;
  t3519 = t272 * t28;
  t3528 = 0.24e2 * t3473 * t1043 - 0.36e2 * t2534 * t527 * t118 * t141 + 0.24e2 * t1041 * t1042 * t417 + 0.8e1 * t376 * t1334 + 0.2e3 / 0.3e1 * t164 * t3485 * tau[0] - 0.3e1 / 0.4e1 * t1046 * t524 - 0.1e2 * t376 * t1340 + 0.12e2 * t1350 * t380 + 0.6e1 * t521 * t1052 - 0.3e1 * t1343 * t1356 - 0.3e1 / 0.2e1 * t513 * t403 * t54 * t282 - 0.2e2 * t513 * t1339 * t118 * tau[0] + 0.3e1 / 0.2e1 * t3507 * t1361 + 0.3e1 / 0.4e1 * t1359 * t403 * t54 * t329 + 0.1e2 * t1359 * t1339 * t3514 - 0.25e2 * t164 * t3518 * t3519 + 0.4e3 * t521 * t1055 + 0.12e2 * t245 * t340 * t514;
  t3547 = t304 * t743;
  t3559 = t429 * t47;
  t3563 = t250 * t3559;
  t3579 = t717 * t1257;
  t3584 = 0.32e3 * t1343 * t1347 + 0.6e1 * t106 * t942 * t166 + 0.128e3 * t1262 * t1263 * t356 * t141 - 0.256e3 * t365 * t1263 * t2658 + 0.32e2 * t891 * t1375 + 0.48e2 * t880 * t1267 - 0.32e3 * t1262 * t3547 * t3514 + 0.64e3 * t365 * t3547 * t315 + 0.4e4 / 0.3e1 * t245 * t1261 * t70 * t2185 * t3519 + 0.24e2 * t245 * t3559 * t368 - 0.12e2 * t3563 * t373 + 0.8e2 * t106 * t3559 * t386 - 0.176e3 / 0.3e1 * t371 * t366 * t240 * t175 + 0.32e2 * t894 * t1375 + 0.32e2 * t371 * t366 * t101 * t417 + 0.12e2 * t3579 * t872 - 0.12e2 * t2795 * t518;
  t3585 = t2151 * t1261;
  t3640 = -0.6e1 * t250 * t1392 * t118 - 0.6e1 * t250 * t1411 * t118 + 0.24e2 * t3585 * t1263 * t2431 - 0.6e1 * t250 * t1378 * t141 + 0.8e1 * t288 * t1386 * t141 + 0.8e1 * t288 * t1389 * t141 + 0.4e1 * t288 * t1392 * t141 + 0.4e1 * t288 * t1411 * t141 + 0.24e2 * t2136 * t528 * t289 + 0.12e2 * t2151 * t528 * t246 - 0.12e2 * t678 * t531 * t246 - 0.6e1 * t678 * t541 * t246 - 0.6e1 * t250 * t531 * t282 - 0.3e1 * t250 * t541 * t282 + 0.4e1 * t288 * t531 * t329 + 0.2e1 * t288 * t541 * t329 - 0.12e2 * t657 * t531 * t289 - 0.6e1 * t657 * t541 * t289;
  t3672 = t180 * t112;
  t3676 = t250 * t3672;
  t3682 = t81 * t27;
  t3683 = t678 * t3682;
  t3691 = 0.4e1 * t288 * t176 * t1020 - 0.12e2 * t250 * t1386 * t118 - 0.12e2 * t250 * t1389 * t118 + 0.6e1 * t717 * t528 * t282 - 0.12e2 * t657 * t1383 * t141 - 0.6e1 * t657 * t528 * t329 + 0.8e1 * t288 * t398 * t417 + t3443 + 0.12e2 * t717 * t1383 * t118 - 0.6e1 * t2846 * t518 - 0.12e2 * t2849 * t518 - 0.12e2 * t891 * t1275 + 0.24e2 * t245 * t3672 * t368 - 0.12e2 * t3676 * t373 + 0.8e2 * t106 * t3672 * t386 + 0.3e1 * t3683 * t1862 * t2366 - 0.64e2 * t1278 * t867 + 0.32e2 * t1281 * t876;
  t3692 = t118 * t123;
  t3693 = t3692 * t1261;
  t3699 = t678 * t150 * t48;
  t3731 = t282 * t74;
  t3738 = -0.24e2 * t3693 * t1264 + 0.48e2 * t2838 * t1267 - 0.24e2 * t3699 * t1264 - 0.6e1 * t2854 * t518 - 0.12e2 * t894 * t1275 - 0.6e1 * t371 * t366 * t33 * t1020 + 0.12e2 * t1278 * t888 - 0.6e1 * t1281 * t898 - 0.4e3 * t371 * t2756 * t175 * t272 - 0.32e3 * t1258 * t863 - 0.12e2 * t1262 * t1263 * t2390 + 0.24e2 * t365 * t1263 * t2647 - t3441 + 0.24e2 * t1370 * t150 * t514 + 0.32e3 * t1371 * t1347 + 0.12e2 * t3731 * t81 * t514 - 0.76e2 / 0.3e1 * t164 * t235 * t54 - t3445;
  t3746 = my_piecewise3(t3, 0, t7 * t216 * t547 / 0.12e2 - t7 * t89 * t1415 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3333 + t3400 + t3472 + t3528 + t3584 + t3640 + t3691 + t3738));
  tv4rho2sigma20 = 0.2e1 * rho[0] * t3746 + 0.4e1 * t1420;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t3768 = t3692 * t193;
  t3771 = t678 * t448;
  t3774 = t678 * t467;
  t3777 = t379 * t1434;
  t3781 = t107 * t165 * t329;
  t3794 = t678 * t476;
  t3797 = 0.6e1 * t1066 * t559 + 0.6e1 * t1066 * t567 - 0.4e2 * t1561 * t1231 - 0.4e2 * t1564 * t1231 + 0.8e2 * t1569 * t1231 + 0.8e2 * t1572 * t1231 + 0.8e2 * t1575 * t1231 - 0.12e2 * t3794 * t1430 - 0.12e2 * t3768 * t1435 - 0.12e2 * t3771 * t1435 - 0.12e2 * t3774 * t1435 - 0.12e2 * t1440 * t3777 - 0.6e1 * t1440 * t3781 + 0.8e2 * t553 * t2927 - 0.4e2 * t570 * t2927 - 0.32e3 * t553 * t2929 + 0.16e3 * t570 * t2929;
  t3798 = t678 * t500;
  t3805 = t2108 * t207;
  t3807 = t107 * t165 * t289;
  t3811 = t107 * t102 * t141;
  t3814 = t2151 * t193;
  t3826 = t717 * t476;
  t3829 = t717 * t500;
  t3836 = t207 * t47;
  t3840 = t717 * t3836;
  t3843 = t193 * t47;
  t3844 = t678 * t3843;
  t3847 = t2151 * t3836;
  t3856 = -0.12e2 * t3798 * t1430 + 0.32e2 * t1428 * t107 * t102 * t118 - 0.18e2 * t3805 * t3807 - 0.32e2 * t1433 * t3811 + 0.12e2 * t3814 * t3807 + 0.32e2 * t1440 * t3811 - 0.12e2 * t1428 * t379 * t1429 - 0.6e1 * t1428 * t107 * t165 * t282 + 0.12e2 * t3826 * t1435 + 0.12e2 * t3829 * t1435 + 0.12e2 * t1433 * t3777 + 0.6e1 * t1433 * t3781 - 0.8e2 * t678 * t3836 * t915 + 0.8e2 * t3840 * t920 - 0.8e2 * t3844 * t920 + 0.24e2 * t3847 * t910 + 0.6e1 * t717 * t567 * t289 + 0.6e1 * t717 * t559 * t289;
  t3863 = t2136 * t81;
  t3909 = 0.12e2 * t245 * t1535 * t118 + 0.12e2 * t245 * t1546 * t118 + 0.12e2 * t245 * t1551 * t118 + 0.12e2 * t245 * t1554 * t118 - 0.6e1 * t250 * t1551 * t141 - 0.6e1 * t250 * t1554 * t141 + 0.12e2 * t2556 * t1486 * t246 + 0.24e2 * t3863 * t1486 * t289 - 0.18e2 * t2534 * t1491 * t289 + 0.6e1 * t245 * t559 * t282 + 0.6e1 * t245 * t567 * t282 - 0.6e1 * t678 * t576 * t246 - 0.6e1 * t678 * t589 * t246 - 0.3e1 * t250 * t559 * t329 - 0.6e1 * t657 * t576 * t289 - 0.6e1 * t657 * t589 * t289 - 0.6e1 * t2794 * t556;
  t3910 = t192 * t417;
  t3914 = t678 * t180;
  t3926 = t455 * t268;
  t3929 = t2950 * tau[0];
  t3933 = t2944 * t272 * t28;
  t3942 = t455 * t257;
  t3951 = t2262 * t3933;
  t3954 = -0.192e4 * t1000 * t3926 - 0.768e5 * t2208 * t3929 - 0.112e6 * t2216 * t3933 + 0.288e4 * t800 * t3926 + 0.1344e6 * t2216 * t3929 + 0.1792e6 * t2268 * t3933 - 0.576e4 * t2662 * t3942 + 0.1152e5 * t2208 * t3942 - 0.2496e5 * t800 * t1400 + 0.1088e6 * t1405 - 0.3328e5 / 0.3e1 * t1408 - 0.8e3 * t3951 + 0.1664e5 * t1401;
  t3959 = t2938 * t455;
  t3961 = t2727 * t1503;
  t3969 = t765 * t1400;
  t3980 = 0.36e2 * t2328 * t455 - 0.272e4 * t1347 + 0.416e3 * t1367 - 0.12e2 * t3959 - 0.24e3 * t3961 + 0.36e2 * t765 * t3926 + 0.96e3 * t2262 * t3929 + 0.2e4 * t2199 * t3933 - 0.312e3 * t3969 - 0.15232e6 * t132 * t1011 * tau[0] + 0.13312e5 * t132 * t584 * t356 + 0.104e3 * t1394 + 0.136e4 * t1396 - 0.832e3 / 0.3e1 * t1398;
  t3987 = t466 * t175;
  t4019 = 0.12e2 * t1041 * t3910 * t141 - 0.12e2 * t3914 * t1089 - 0.12e2 * t1087 * t566 * t118 * t141 + 0.12e2 * t2582 * t1498 + 0.6e1 * t106 * t429 * t466 - t124 * t81 * (t3954 + t3980) + 0.3e1 * t106 * t942 * t192 + 0.12e2 * t1041 * t3987 * t141 - 0.12e2 * t1087 * t3910 * t118 - 0.6e1 * t1087 * t1491 * t282 - 0.12e2 * t3228 * t1492 + 0.12e2 * t2582 * t1495 - 0.12e2 * t1087 * t3987 * t118 - 0.3e1 * t250 * t1242 * t175 - 0.6e1 * t250 * t467 * t417 - 0.3e1 * t250 * t193 * t1020 - 0.6e1 * t250 * t1220 * t175 - 0.6e1 * t250 * t448 * t417;
  t4049 = t206 * t417;
  t4065 = t2944 * t127;
  t4083 = 0.4e1 * t288 * t1529 * t141 + 0.2e1 * t288 * t589 * t329 - 0.3e1 * t250 * t1217 * t175 + 0.6e1 * t1041 * t1491 * t329 + 0.6e1 * t1041 * t1486 * t282 - 0.6e1 * t1485 * t1486 * t329 + 0.4e1 * t288 * t1533 * t141 + 0.12e2 * t3473 * t1099 + 0.12e2 * t1041 * t588 * t118 * t141 + 0.12e2 * t1041 * t4049 * t118 - 0.12e2 * t1485 * t4049 * t141 - 0.2e1 * t124 * t150 * t1528 - t124 * t180 * t1214 - t124 * t340 * t588 + 0.3e1 * t106 * t81 * (0.416e3 / 0.9e1 * t1334 - 0.136e4 / 0.9e1 * t1340 + 0.2e3 / 0.3e1 * t4065 * t3519 - 0.4e1 * t3959 - 0.8e2 * t3961 + 0.104e3 / 0.3e1 * t1394 - 0.8e3 / 0.3e1 * t3951 + 0.136e4 / 0.3e1 * t1396 - 0.832e3 / 0.9e1 * t1398) - t124 * t942 * t206 - 0.2e1 * t124 * t429 * t499;
  t4099 = t499 * t175;
  t4132 = 0.3e1 * t106 * t180 * t1241 + 0.3e1 * t106 * t340 * t566 + 0.6e1 * t106 * t150 * t1545 + 0.24e2 * t2556 * t1491 * t2366 - 0.36e2 * t2534 * t1486 * t2366 + 0.12e2 * t1041 * t4099 * t118 - 0.12e2 * t1485 * t4099 * t141 - 0.12e2 * t657 * t150 * t1487 - 0.88e2 / 0.3e1 * t570 * t1063 + 0.176e3 / 0.3e1 * t553 * t1063 - 0.6e1 * t2794 * t207 * t166 - 0.32e2 * t1575 * t389 - 0.32e2 * t553 * t1060 + 0.4e3 * t553 * t1055 - 0.2e3 * t570 * t1055 - 0.3e1 * t250 * t1144 * t166 - 0.6e1 * t250 * t1146 * t166 - 0.6e1 * t1561 * t380;
  t4177 = -0.3e1 * t250 * t1215 * t166 + 0.6e1 * t245 * t1217 * t166 + 0.12e2 * t245 * t1220 * t166 + 0.6e1 * t245 * t1242 * t166 + 0.12e2 * t1370 * t448 * t166 + 0.12e2 * t1370 * t467 * t166 + 0.6e1 * t3731 * t193 * t166 + 0.6e1 * t553 * t1052 - 0.3e1 * t570 * t1052 + 0.16e2 * t570 * t1060 + 0.16e2 * t1561 * t389 - 0.6e1 * t1564 * t380 + 0.16e2 * t1564 * t389 + 0.12e2 * t1569 * t380 - 0.32e2 * t1569 * t389 + 0.12e2 * t1572 * t380 - 0.32e2 * t1572 * t389 + 0.12e2 * t1575 * t380;
  t4232 = 0.2e1 * t288 * t207 * t1020 + 0.2e1 * t288 * t1144 * t175 + 0.4e1 * t288 * t1146 * t175 - 0.6e1 * t250 * t1529 * t118 - 0.6e1 * t250 * t1531 * t118 - 0.6e1 * t250 * t1533 * t118 - 0.6e1 * t250 * t1549 * t118 + 0.2e1 * t288 * t1215 * t175 + 0.4e1 * t288 * t1531 * t141 - 0.6e1 * t250 * t1535 * t141 - 0.6e1 * t250 * t1546 * t141 + 0.4e1 * t288 * t1549 * t141 - 0.3e1 * t250 * t576 * t282 - 0.3e1 * t250 * t589 * t282 - 0.3e1 * t250 * t567 * t329 + 0.2e1 * t288 * t576 * t329 + 0.4e1 * t288 * t476 * t417 + 0.4e1 * t288 * t500 * t417;
  t4240 = my_piecewise3(t3, 0, t7 * t216 * t591 / 0.12e2 - t7 * t89 * t1581 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t3797 + t3856 + t3909 + t4019 + t4083 + t4132 + t4177 + t4232));
  tv4rho2sigmatau0 = 0.2e1 * rho[0] * t4240 + 0.4e1 * t1586;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t4250 = t499 * t499;
  t4299 = 0.12e2 * t245 * t1626 * t118 + 0.12e2 * t245 * t1647 * t118 - 0.6e1 * t250 * t193 * t1214 - 0.6e1 * t250 * t1217 * t206 - 0.12e2 * t250 * t1220 * t206 + 0.12e2 * t245 * t193 * t1241 - 0.6e1 * t250 * t1242 * t206 - 0.12e2 * t678 * t1597 * t141 - 0.6e1 * t250 * t1626 * t141 - 0.6e1 * t250 * t1647 * t141 + 0.6e1 * t245 * t614 * t282 - 0.3e1 * t250 * t614 * t329 - 0.12e2 * t250 * t448 * t499 - 0.12e2 * t250 * t467 * t499 + 0.4e1 * t288 * t81 * t4250 - 0.6e1 * t678 * t598 * t329;
  t4348 = 0.12e2 * t717 * t1656 * t118 - 0.6e1 * t250 * t1668 * t118 - 0.6e1 * t250 * t1706 * t118 + 0.4e1 * t288 * t207 * t1214 - 0.12e2 * t657 * t1656 * t141 + 0.4e1 * t288 * t1668 * t141 + 0.4e1 * t288 * t1706 * t141 + 0.48e2 * t2556 * t1603 * t2366 + 0.24e2 * t245 * t448 * t466 - 0.3e1 * t250 * t636 * t282 + 0.6e1 * t717 * t618 * t282 + 0.2e1 * t288 * t636 * t329 + 0.8e1 * t288 * t476 * t499 - 0.6e1 * t657 * t618 * t329 + 0.24e2 * t1370 * t1600 - 0.12e2 * t3692 * t1594 - 0.12e2 * t2794 * t601;
  t4377 = t606 * t257;
  t4382 = t606 * t268;
  t4385 = t1630 * t112;
  t4386 = t4385 * tau[0];
  t4390 = 0.1e1 / t31 / t672;
  t4392 = t4390 * t272 * t28;
  t4395 = t2262 * t4392;
  t4397 = t2262 * t4386;
  t4399 = t765 * t4382;
  t4401 = t2199 * t4392;
  t4415 = -0.401408e7 / 0.3e1 * t67 * t1177 * tau[0] + 0.23296e6 / 0.3e1 * t67 * t631 * t276 + 0.1152e4 * t2262 * t4377 - 0.384e4 * t756 * t1507 + 0.576e3 * t756 * t4382 + 0.192e5 * t2199 * t4386 + 0.32e5 * t2182 * t4392 + 0.64e4 * t4395 - 0.1536e5 * t4397 - 0.576e3 * t4399 - 0.32e5 * t4401 + 0.384e4 * t1508 - 0.7168e6 * t1517 + 0.200704e7 * t1523 - 0.13312e6 * t1526 - 0.1024e6 * t1513 + 0.3072e6 * t1520 + 0.4608e5 * t2662 * t4377 - 0.18432e6 * t2208 * t4377 + 0.16128e6 * t2216 * t4377;
  t4447 = t2938 * t606;
  t4449 = t2727 * t1636;
  t4451 = t2328 * t606;
  t4453 = 0.1664e6 / 0.3e1 * t538 + 0.3584e5 * t1510 - 0.416e4 * t514 - 0.64e3 * t1501 - 0.896e4 * t1504 - 0.896e5 / 0.3e1 * t775 * t1503 + 0.832e4 / 0.3e1 * t305 * t403 + 0.416e4 / 0.3e1 * t534 + 0.96e2 * t4447 + 0.192e4 * t4449 - 0.576e3 * t4451;
  t4461 = t466 * t466;
  t4467 = t466 * t206;
  t4471 = t192 * t499;
  t4484 = -0.36e2 * t2534 * t1603 * t289 - 0.6e1 * t657 * t636 * t289 + 0.12e2 * t2151 * t598 * t289 - 0.6e1 * t678 * t636 * t246 + 0.24e2 * t2136 * t618 * t289 + 0.6e1 * t717 * t614 * t289 + 0.12e2 * t2151 * t618 * t246 - t124 * t81 * (0.1536e5 * t1000 * t4382 - 0.21504e6 * t789 * t1507 + 0.6144e6 * t2208 * t4386 - 0.21504e7 * t2216 * t4386 + 0.896e6 * t2216 * t4392 + 0.172032e7 * t2268 * t4386 - 0.28672e7 * t2268 * t4392 + 0.21504e7 * t2273 * t4392 + 0.32256e5 * t789 * t4382 - 0.4608e5 * t800 * t4382 + t4415 + t4453) - 0.2e1 * t124 * t150 * t1705 + 0.12e2 * t245 * t81 * t4461 - 0.24e2 * t3228 * t1604 - 0.24e2 * t1087 * t4467 * t118 - 0.24e2 * t1087 * t4471 * t118 - 0.12e2 * t1087 * t1603 * t282 - 0.24e2 * t1087 * t3224 * t466 - 0.24e2 * t1485 * t3193 * t499;
  t4528 = t4390 * t127;
  t4544 = -0.208e4 / 0.9e1 * t524 + 0.896e4 / 0.9e1 * t1540 - 0.16e4 / 0.3e1 * t4528 * t3519 + 0.64e2 * t4447 + 0.128e4 * t4449 - 0.128e4 / 0.3e1 * t1501 + 0.128e5 / 0.3e1 * t4395 - 0.1792e5 / 0.3e1 * t1504 + 0.832e4 / 0.9e1 * t534 - 0.96e2 * t4451 - 0.256e4 * t4397 + 0.64e3 * t1508 - 0.96e2 * t4399 - 0.16e5 / 0.3e1 * t4401 + 0.1792e5 / 0.3e1 * t1510 - 0.208e4 / 0.3e1 * t514;
  t4553 = 0.12e2 * t1041 * t635 * t118 * t141 - 0.36e2 * t2534 * t617 * t118 * t141 + 0.24e2 * t1041 * t1098 * t499 + 0.24e2 * t1041 * t4471 * t141 + 0.12e2 * t1041 * t1603 * t329 - 0.12e2 * t1087 * t613 * t118 * t141 + 0.24e2 * t2582 * t1607 + 0.24e2 * t1041 * t4467 * t141 + 0.6e1 * t1066 * t614 + 0.6e1 * t3731 * t598 + 0.12e2 * t1370 * t1597 + 0.6e1 * t245 * t340 * t597 + 0.3e1 * t106 * t340 * t613 + 0.6e1 * t106 * t150 * t1646 + 0.3e1 * t106 * t81 * t4544 + 0.2e1 * t288 * t340 * t617 - t124 * t340 * t635;
  t4560 = my_piecewise3(t3, 0, t7 * t216 * t638 / 0.12e2 - t7 * t89 * t1709 / 0.4e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t4299 + t4348 + t4484 + t4553));
  tv4rho2tau20 = 0.2e1 * rho[0] * t4560 + 0.4e1 * t1714;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t4579 = t276 * t527;
  t4598 = t276 * t540;
  t4603 = -0.18e2 * t908 * t366 * t1772 * t118 - 0.54e2 * t2801 * t366 * t1739 * t141 + 0.18e2 * t870 * t366 * t1772 * t141 + 0.36e2 * t870 * t366 * t517 * t417 - 0.6e2 * t371 * t384 * t4598 * tau[0] + 0.12e3 * t870 * t384 * t4579 * tau[0] + 0.72e2 * t513 * t765 * t1319 - 0.12e3 * t1281 * t1294 - 0.36e2 * t3376 * t1285 + 0.36e2 * t3579 * t1289 + 0.12e2 * t521 * t1334;
  t4616 = t250 * t180;
  t4620 = t74 * t81;
  t4643 = 0.72e2 * t3585 * t1263 * t1292 * t141 - 0.72e2 * t908 * t1263 * t1292 * t112 + 0.36e2 * t2422 * t366 * t1739 * t118 + 0.9e1 / 0.4e1 * t4616 * t1361 + 0.24e3 * t2182 * t2185 * t4620 * t42 + 0.9e1 * t106 * t1331 * t166 + 0.9e1 * t1760 * t380 + 0.36e2 * t1370 * t180 * t514 + 0.36e2 * t245 * t429 * t514 + 0.48e3 * t1763 * t1347 + 0.9e1 / 0.4e1 * t3507 * t1767 + 0.9e1 / 0.4e1 * t1359 * t403 * t54 * t417;
  t4645 = t175 * tau[0];
  t4671 = t775 * t743;
  t4672 = t123 * t81;
  t4676 = 0.15e2 * t1359 * t1339 * t4645 - 0.24e2 * t1760 * t389 + 0.9e1 * t1087 * t765 * t743 * t141 - 0.9e1 / 0.2e1 * t1763 * t1356 - 0.192e3 * t1763 * t1367 - 0.12e2 * t1359 * t994 * t1766 - 0.9e1 * t1343 * t1717 - 0.9e1 * t513 * t2727 * t743 - 0.9e1 / 0.4e1 * t1350 * t524 - 0.15e2 * t521 * t1340 - 0.24e2 * t4671 * t4672 * t141;
  t4677 = t175 * t540;
  t4726 = 0.18e2 * t1041 * t4677 * t118 - 0.18e2 * t1485 * t4677 * t141 - 0.9e1 * t1371 * t1717 + 0.72e2 * t2199 * t743 * t4620 * t112 - 0.3e1 * t124 * t180 * t1410 - t124 * t150 * t1757 - t124 * t81 * (0.3e1 * t3485 - 0.15e2 / 0.8e1 * t3518 * t42 - 0.18e3 * t2243 * t1754 * t112 - 0.6e3 * t2208 * t2185 * tau[0] * t28 + 0.48e3 * t731 * t70 * t1319) - 0.6e1 * t657 * t150 * t1732 + 0.6e1 * t288 * t429 * t527 - 0.3e1 * t124 * t1331 * t175 - 0.3e1 * t124 * t545 * t417 - 0.3e1 * t124 * t429 * t540;
  t4750 = t545 * t47;
  t4760 = -0.9e1 * t371 * t366 * t33 * t1410 + 0.192e3 * t1262 * t1263 * t3356 - 0.36e2 * t1262 * t1263 * t3371 - 0.48e3 * t1262 * t3547 * t4645 + 0.18e2 * t245 * t4750 * t368 - 0.9e1 * t250 * t4750 * t373 - 0.6e2 * t365 * t2765 * t42 + 0.18e2 * t2822 * t1740 + 0.18e2 * t2827 * t1740 - 0.36e2 * t3693 * t1776 - 0.36e2 * t3699 * t1776;
  t4775 = t678 * t180 * t48;
  t4795 = -0.48e2 * t870 * t366 * t101 * t527 + 0.48e2 * t1281 * t1375 + 0.24e2 * t371 * t366 * t101 * t540 + 0.6e2 * t106 * t4750 * t386 - 0.36e2 * t4775 * t1264 + 0.72e2 * t1278 * t1267 + 0.9e1 / 0.2e1 * t3683 * t1862 * t1042 - 0.9e1 / 0.2e1 * t717 * t3682 * t1862 * t3390 - 0.18e2 * t3563 * t518 - 0.18e2 * t3676 * t518 - 0.18e2 * t1281 * t1275 - 0.9e1 * t891 * t1773;
  t4801 = t669 / t31 / t673;
  t4803 = t26 * t29;
  t4805 = 0.125e4 / 0.1162261467e10 * t2076 * t4801 * t4803;
  t4812 = 0.25e3 / 0.1594323e7 * t667 * t1320;
  t4831 = 0.3e1 * t106 * t1726 * t118 - 0.9e1 * t250 * t1750 * t118 - 0.3e1 * t250 * t1758 * t118 - t124 * t1726 * t141 + 0.6e1 * t288 * t1747 * t141 + 0.6e1 * t288 * t1750 * t141 + 0.2e1 * t288 * t1758 * t141 + 0.6e1 * t288 * t176 * t1410 - 0.9e1 * t894 * t1773 + t4805 - t4812;
  t4873 = 0.18e2 * t717 * t1744 * t118 - 0.18e2 * t657 * t1744 * t141 + 0.12e2 * t288 * t531 * t417 - 0.9e1 * t250 * t1747 * t118 + 0.24e2 * t2136 * t1733 * t141 - 0.18e2 * t657 * t528 * t417 + 0.6e1 * t288 * t398 * t540 + 0.6e1 * t288 * t418 * t540 + 0.24e2 * t775 * t1728 * t150 - 0.18e2 * t2108 * t1733 * t118 + t75 * (0.125e4 / 0.1162261467e10 * t2046 * t4801 * t4803 - 0.25e3 / 0.1594323e7 * t696 * t1320 - t4805 + t4812) - 0.192e3 * t775 * t1319 * t74 * t81;
  t4881 = my_piecewise3(t3, 0, -t7 * t89 * t1779 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t4603 + t4643 + t4676 + t4726 + t4760 + t4795 + t4831 + t4873));
  tv4rhosigma30 = 0.2e1 * rho[0] * t4881 + 0.2e1 * t1783;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  t4924 = t356 * t54;
  t4935 = -0.6e1 * t250 * t1546 * t175 - 0.6e1 * t250 * t1535 * t175 + 0.24e2 * t3847 * t1285 - 0.36e2 * t2108 * t3836 * t1289 + 0.8e2 * t3840 * t1294 + 0.24e2 * t2151 * t3843 * t1289 - 0.8e2 * t3844 * t1294 - 0.6e1 * t250 * t559 * t417 - 0.6e1 * t250 * t1551 * t175 - 0.6e1 * t250 * t1554 * t175 + 0.6e1 * t245 * t1833 * t118 - 0.3e1 * t250 * t1833 * t141 - 0.64e2 * t1856 * t356 * t74 * t193 + 0.8e1 * t513 * t1861 * t4924 - 0.4e1 * t1359 * t1866 * t4924 - 0.21e2 * t106 * t81 * t743 * t62;
  t4977 = 0.12e2 * t1370 * t559 * t166 + 0.12e2 * t1370 * t567 * t166 + 0.12e2 * t245 * t1535 * t166 + 0.12e2 * t245 * t1546 * t166 - 0.6e1 * t250 * t1549 * t166 + 0.12e2 * t245 * t1551 * t166 + 0.12e2 * t245 * t1554 * t166 - 0.16e3 * t1428 * t1347 + 0.64e2 * t1428 * t1367 + 0.12e2 * t1836 * t380 - 0.32e2 * t1836 * t389 + 0.16e2 * t1839 * t389 + 0.16e2 * t1842 * t389 + 0.12e2 * t1847 * t380 - 0.32e2 * t1847 * t389 - 0.12e2 * t3794 * t514 - 0.12e2 * t3798 * t514;
  t5026 = 0.24e2 * t765 * t403 * t4620 * t192 * t112 - 0.12e2 * t514 * t4672 * t3224 + 0.3e1 / 0.2e1 * t1440 * t1361 + 0.3e1 / 0.2e1 * t1428 * t1356 - 0.3e1 / 0.2e1 * t1433 * t1361 - 0.6e1 * t250 * t1531 * t166 - 0.6e1 * t1839 * t380 - 0.6e1 * t250 * t1533 * t166 - 0.6e1 * t250 * t1529 * t166 - 0.6e1 * t1842 * t380 - 0.12e2 * t3692 * t207 * t514 + 0.12e2 * t3473 * t1498 - 0.12e2 * t657 * t180 * t1487 + 0.2e1 * t288 * t1831 * t141 - 0.6e1 * t250 * t1818 * t118 + 0.4e1 * t288 * t1818 * t141 - 0.3e1 * t250 * t1831 * t118;
  t5027 = t192 * t540;
  t5041 = t566 * t175;
  t5054 = t206 * t527;
  t5079 = 0.6e1 * t1041 * t5027 * t141 + 0.12e2 * t1041 * t5041 * t141 + 0.12e2 * t1041 * t1491 * t417 - 0.6e1 * t1087 * t5027 * t118 - 0.12e2 * t1087 * t5041 * t118 + 0.6e1 * t513 * t1539 * t118 + 0.12e2 * t245 * t1813 * t118 - 0.3e1 * t250 * t1816 * t118 - 0.18e2 * t2534 * t5054 * t118 - 0.3e1 * t1359 * t1539 * t141 - 0.6e1 * t250 * t1813 * t141 + 0.2e1 * t288 * t1816 * t141 + 0.24e2 * t3863 * t5054 * t141 - 0.12e2 * t1485 * t1486 * t417 - 0.6e1 * t657 * t500 * t527 - 0.12e2 * t3914 * t1492 + 0.12e2 * t3473 * t1495;
  t5115 = t206 * t540;
  t5122 = t192 * t527;
  t5129 = t588 * t175;
  t5133 = 0.6e1 * t1041 * t5115 * t118 + 0.12e2 * t1041 * t5129 * t118 + 0.12e2 * t2556 * t5122 * t118 - 0.6e1 * t1485 * t5115 * t141 - 0.18e2 * t2534 * t5122 * t141 + 0.2e1 * t288 * t207 * t1410 + 0.4e1 * t288 * t1529 * t175 + 0.4e1 * t288 * t1531 * t175 + 0.4e1 * t288 * t1533 * t175 + 0.4e1 * t288 * t576 * t417 + 0.4e1 * t288 * t589 * t417 + 0.2e1 * t288 * t476 * t540 + 0.2e1 * t288 * t500 * t540 + 0.6e1 * t717 * t448 * t527 + 0.6e1 * t717 * t467 * t527 - 0.6e1 * t657 * t476 * t527;
  t5156 = t4065 * t42;
  t5161 = t2944 * tau[0] * t28;
  t5178 = -0.288e4 * t731 * t1515 * t112 + 0.144e4 * t2243 * t1825 * t112 - 0.9e1 * t2727 * t1154 + 0.504e4 * t310 * t1403 + 0.48e4 * t2208 * t5161 - 0.84e4 * t2216 * t5161 - 0.6e2 * t2262 * t5161 - 0.21e2 * t1339 + 0.63e2 * t1717 - 0.336e4 * t1755 + 0.15e2 * t5156;
  t5206 = -0.12e2 * t1485 * t5129 * t141 + 0.6e1 * t106 * t429 * t566 + 0.6e1 * t106 * t180 * t1545 - t124 * t1331 * t206 - t124 * t545 * t499 - 0.2e1 * t124 * t429 * t588 - 0.2e1 * t124 * t180 * t1528 - t124 * t150 * t1830 - t124 * t81 * t5178 + 0.3e1 * t106 * t1331 * t192 + 0.3e1 * t106 * t545 * t466 + 0.12e2 * t1856 * t1857 * t448 + 0.12e2 * t1856 * t1857 * t467 + 0.16e3 * t756 * t743 * t4620 * t192 * tau[0] - 0.3e1 / 0.2e1 * t1371 * t1863 - 0.3e1 / 0.2e1 * t1343 * t1863 - 0.3e1 / 0.2e1 * t513 * t466 * t27 * t1862;
  t5209 = t62 * tau[0];
  t5226 = t107 * t102 * t175;
  t5231 = t379 * t1850;
  t5235 = t107 * t165 * t417;
  t5240 = t678 * t576;
  t5243 = t717 * t576;
  t5248 = t678 * t589;
  t5251 = t717 * t589;
  t5256 = t2151 * t207;
  t5261 = -0.1e2 * t513 * t192 * t743 * t5209 + 0.3e1 / 0.4e1 * t3507 * t1867 + 0.3e1 / 0.4e1 * t1359 * t499 * t27 * t1862 + 0.5e1 * t1359 * t206 * t743 * t5209 + 0.15e2 * t164 * t5156 - 0.32e2 * t1433 * t5226 + 0.32e2 * t1440 * t5226 - 0.12e2 * t1440 * t5231 - 0.12e2 * t1440 * t5235 + 0.8e2 * t1836 * t1231 - 0.12e2 * t5240 * t1430 + 0.12e2 * t5243 * t1435 - 0.4e2 * t1839 * t1231 - 0.12e2 * t5248 * t1430 + 0.12e2 * t5251 * t1435 - 0.4e2 * t1842 * t1231 + 0.24e2 * t5256 * t271 * t403 * t141;
  t5264 = t678 * t559;
  t5269 = t678 * t567;
  t5305 = -0.24e2 * t1428 * t3969 - 0.12e2 * t5264 * t1435 + 0.8e2 * t1847 * t1231 - 0.12e2 * t5269 * t1435 - 0.3e1 * t250 * t467 * t540 - 0.3e1 * t250 * t193 * t1410 + 0.3e1 * t106 * t150 * t1154 * t62 + 0.4e1 * t288 * t1549 * t175 - 0.3e1 * t250 * t448 * t540 - 0.6e1 * t250 * t567 * t417 + 0.12e2 * t3826 * t1851 + 0.12e2 * t3829 * t1851 + 0.12e2 * t1433 * t5231 + 0.12e2 * t1433 * t5235 - 0.12e2 * t3768 * t1851 - 0.12e2 * t3771 * t1851 - 0.12e2 * t3774 * t1851;
  t5313 = my_piecewise3(t3, 0, -t7 * t89 * t1871 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t4935 + t4977 + t5026 + t5079 + t5133 + t5206 + t5261 + t5305));
  tv4rhosigma2tau0 = 0.2e1 * rho[0] * t5313 + 0.2e1 * t1875;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t5320 = t4528 * t42;
  t5322 = t2727 * t1630;
  t5325 = t4390 * tau[0] * t28;
  t5326 = t2262 * t5325;
  t5354 = 0.4608e5 * t731 * t1684 * t112 - 0.4032e5 * t310 * t1691 * t112 - 0.1152e5 * t2243 * t1949 * t112 + 0.864e3 * t756 * t1154 + 0.48384e5 * t132 * t1173 - 0.12e4 * t2199 * t5325 - 0.384e5 * t2208 * t5325 + 0.1344e6 * t2216 * t5325 - 0.288e3 * t2262 * t4385 - 0.10752e6 * t2268 * t5325 + 0.144e3 * t1539 - 0.864e3 * t1823 + 0.2304e5 * t1826 - 0.6912e5 * t1828 - 0.12e3 * t5320 + 0.144e3 * t5322 + 0.96e3 * t5326;
  t5389 = t2151 * t601;
  t5395 = -t124 * t81 * t5354 - t124 * t180 * t1705 - t124 * t150 * t1956 + 0.2e1 * t288 * t429 * t617 - t124 * t429 * t635 + 0.3e1 * t106 * t180 * t1646 + 0.3e1 * t106 * t150 * t1921 + 0.3e1 * t106 * t81 * (0.96e2 * t1539 - 0.8e2 * t5320 + 0.24e2 * t5322 + 0.16e3 * t5326 - 0.144e3 * t1823) + 0.6e1 * t1370 * t1885 + 0.6e1 * t245 * t429 * t597 + 0.3e1 * t106 * t429 * t613 + 0.24e2 * t5389 * t1435 - 0.8e2 * t678 * t601 * t1231;
  t5438 = -0.6e1 * t250 * t193 * t1528 - 0.6e1 * t250 * t1535 * t206 + 0.12e2 * t245 * t193 * t1545 - 0.6e1 * t250 * t1546 * t206 - 0.6e1 * t250 * t1551 * t206 - 0.6e1 * t250 * t1554 * t206 - 0.3e1 * t250 * t1626 * t175 - 0.3e1 * t250 * t1647 * t175 + 0.12e2 * t245 * t448 * t566 + 0.12e2 * t245 * t467 * t566 - 0.6e1 * t250 * t448 * t588 - 0.6e1 * t250 * t467 * t588 - 0.6e1 * t250 * t559 * t499 - 0.6e1 * t250 * t567 * t499;
  t5480 = -0.3e1 * t250 * t1943 * t118 - 0.3e1 * t250 * t1957 * t118 - 0.6e1 * t678 * t1885 * t141 + 0.2e1 * t288 * t1943 * t141 + 0.2e1 * t288 * t1957 * t141 - 0.6e1 * t678 * t1597 * t175 + 0.2e1 * t288 * t1668 * t175 + 0.2e1 * t288 * t1706 * t175 + 0.12e2 * t245 * t559 * t466 + 0.2e1 * t288 * t636 * t417 + 0.4e1 * t288 * t476 * t588 - 0.6e1 * t678 * t598 * t417 + 0.12e2 * t1370 * t1888 - 0.6e1 * t3692 * t1882;
  t5521 = -0.6e1 * t166 * t4672 * t597 * t141 + 0.12e2 * t166 * t4620 * t192 * t466 + 0.6e1 * t1370 * t614 * t166 + 0.4e1 * t288 * t207 * t1528 + 0.6e1 * t245 * t1626 * t166 + 0.6e1 * t245 * t1647 * t166 + 0.6e1 * t717 * t1656 * t166 - 0.3e1 * t250 * t1668 * t166 - 0.3e1 * t250 * t1706 * t166 + 0.4e1 * t288 * t500 * t588 + 0.6e1 * t1908 * t380 + 0.6e1 * t1925 * t380 - 0.3e1 * t1937 * t380 + 0.8e1 * t1937 * t389;
  t5562 = 0.4e2 * t534 * t4620 * t597 * tau[0] + 0.6e1 * t245 * t1915 * t118 + 0.6e1 * t245 * t1922 * t118 + 0.6e1 * t717 * t1931 * t118 - 0.3e1 * t250 * t1915 * t141 - 0.3e1 * t250 * t1922 * t141 - 0.6e1 * t657 * t1931 * t141 - 0.6e1 * t657 * t1656 * t175 - 0.3e1 * t250 * t614 * t417 + 0.4e1 * t288 * t576 * t499 - 0.6e1 * t657 * t618 * t417 - 0.16e2 * t1908 * t389 - 0.16e2 * t1925 * t389;
  t5580 = t499 * t47 * t1892;
  t5587 = t678 * t614;
  t5592 = t2151 * t618;
  t5595 = t2108 * t618;
  t5602 = t678 * t636;
  t5605 = -0.16e2 * t1877 * t101 * t74 * t598 - 0.12e2 * t1440 * t206 * t112 * t1892 + 0.24e2 * t2556 * t1603 * t1042 + 0.6e1 * t1877 * t1878 * t1597 - 0.36e2 * t2534 * t1603 * t3390 + 0.6e1 * t379 * t28 * t1879 + 0.4e2 * t1908 * t1231 + 0.4e2 * t1925 * t1231 + 0.12e2 * t5592 * t1430 - 0.6e1 * t5602 * t1430 + 0.12e2 * t1433 * t5580 - 0.6e1 * t5587 * t1435 - 0.18e2 * t5595 * t1435 - 0.12e2 * t1440 * t5580;
  t5607 = t717 * t636;
  t5625 = t206 * t588;
  t5629 = t192 * t588;
  t5633 = t613 * t175;
  t5640 = t617 * t175;
  t5649 = 0.32e2 * t1440 * t1891 * t366 * t101 + 0.12e2 * t1041 * t5625 * t118 + 0.12e2 * t1041 * t5629 * t141 + 0.6e1 * t1041 * t5633 * t141 - 0.6e1 * t1087 * t5633 * t118 - 0.18e2 * t2534 * t5640 * t118 + 0.24e2 * t3863 * t5640 * t141 - 0.12e2 * t1485 * t1486 * t499 - 0.2e2 * t1937 * t1231 + 0.6e1 * t5607 * t1435 + 0.12e2 * t3473 * t1607 - 0.12e2 * t3768 * t1893 - 0.12e2 * t3771 * t1893 - 0.12e2 * t3774 * t1893;
  t5650 = t566 * t206;
  t5671 = t192 * t566;
  t5680 = t635 * t175;
  t5687 = t597 * t175;
  t5694 = 0.6e1 * t1041 * t5680 * t118 + 0.12e2 * t1041 * t5650 * t141 + 0.12e2 * t1041 * t1603 * t417 + 0.12e2 * t1041 * t4467 * t175 + 0.12e2 * t1041 * t4471 * t175 - 0.12e2 * t1087 * t5629 * t118 - 0.12e2 * t1087 * t5650 * t118 - 0.12e2 * t1087 * t5671 * t141 - 0.12e2 * t1087 * t1491 * t466 - 0.12e2 * t1485 * t5625 * t141 - 0.6e1 * t1485 * t5680 * t141 + 0.12e2 * t2556 * t5687 * t141 - 0.12e2 * t3914 * t1604 + 0.12e2 * t2582 * t1896;
  t5702 = my_piecewise3(t3, 0, -t7 * t89 * t1960 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t5395 + t5438 + t5480 + t5521 + t5562 + t5605 + t5649 + t5694));
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t5702 + 0.2e1 * t1964;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t5708 = t192 * t635;
  t5712 = t206 * t635;
  t5722 = t613 * t206;
  t5732 = t192 * t617;
  t5741 = t597 * t206;
  t5745 = 0.18e2 * t1041 * t5712 * t118 + 0.18e2 * t1041 * t5708 * t141 + 0.18e2 * t1041 * t5722 * t141 + 0.36e2 * t1041 * t1603 * t499 - 0.18e2 * t1087 * t5708 * t118 - 0.18e2 * t1087 * t5722 * t118 + 0.36e2 * t2556 * t5732 * t118 - 0.18e2 * t1485 * t5712 * t141 - 0.54e2 * t2534 * t5732 * t141 + 0.36e2 * t2556 * t5741 * t141 + 0.6e1 * t1967 * t150;
  t5749 = t192 * t613;
  t5753 = 0.96e3 * t1631;
  t5755 = 0.1e1 / t31 / t232;
  t5758 = 0.96e3 * t5755 * t127 * t42;
  t5759 = t2727 * t1985;
  t5762 = t5755 * tau[0] * t28;
  t5763 = t2262 * t5762;
  t5766 = t1985 * t112;
  t5767 = t2262 * t5766;
  t5769 = t2199 * t5762;
  t5778 = 0.96e4 * t775 * t1630 - 0.192e5 * t2182 * t5762 - 0.576e4 * t2199 * t5766 + 0.864e4 * t1919 - 0.1728e5 * t1947 - t5753 + t5758 - 0.1728e4 * t5759 - 0.1152e5 * t5763 + 0.6912e4 * t5767 + 0.288e5 * t5769;
  t5804 = -0.516096e6 * t132 * t2016 * t112 + 0.9216e5 * t2243 * t2007 * t112 - 0.55296e6 * t731 * t2010 * t112 + 0.96768e6 * t310 * t2013 * t112 + 0.43008e6 * t67 * t1698 + 0.3072e6 * t2208 * t5762 - 0.16128e7 * t2216 * t5762 + 0.258048e7 * t2268 * t5762 - 0.129024e7 * t2273 * t5762 - 0.1536e6 * t1950 + 0.6912e6 * t1952 - 0.96768e6 * t1954;
  t5810 = t1966 * t123;
  t5829 = t597 * t74;
  t5838 = -0.36e2 * t1087 * t1603 * t466 - 0.18e2 * t1087 * t5749 * t141 - t124 * t81 * (t5778 + t5804) - t124 * t150 * t2019 - 0.6e1 * t5810 * t142 + 0.3e1 * t106 * t150 * t1992 + 0.3e1 * t106 * t81 * (-t5753 + t5758 - 0.576e3 * t5759 - 0.384e4 * t5763 + 0.288e4 * t1919 + 0.768e3 * t5767 + 0.32e4 * t5769 - 0.192e4 * t1947) - 0.6e1 * t657 * t150 * t1996 + 0.18e2 * t5829 * t467 - 0.9e1 * t250 * t193 * t1705 + 0.6e1 * t245 * t1993 * t118;
  t5872 = -0.9e1 * t250 * t1626 * t206 + 0.18e2 * t245 * t193 * t1646 - 0.9e1 * t250 * t1647 * t206 + 0.18e2 * t245 * t467 * t613 - 0.9e1 * t250 * t448 * t635 - 0.9e1 * t250 * t467 * t635 - 0.9e1 * t250 * t614 * t499 + 0.18e2 * t717 * t448 * t617 + 0.18e2 * t717 * t467 * t617 - 0.18e2 * t678 * t598 * t499 + 0.18e2 * t1370 * t1973;
  t5908 = -0.18e2 * t2108 * t1997 * t118 - 0.3e1 * t250 * t2020 * t118 - 0.3e1 * t250 * t1993 * t141 + 0.24e2 * t2136 * t1997 * t141 + 0.2e1 * t288 * t2020 * t141 - 0.18e2 * t678 * t1597 * t206 + 0.6e1 * t288 * t207 * t1705 + 0.18e2 * t245 * t448 * t613 + 0.6e1 * t288 * t476 * t635 + 0.6e1 * t288 * t500 * t635 - 0.18e2 * t657 * t618 * t499 - 0.18e2 * t3692 * t1970;
  t5915 = my_piecewise3(t3, 0, -t7 * t89 * t2022 / 0.8e1 - 0.3e1 / 0.8e1 * t7 * t20 * (t5745 + t5838 + t5872 + t5908));
  tv4rhotau30 = 0.2e1 * rho[0] * t5915 + 0.2e1 * t2026;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t5920 = t2185 * t21 * t160;
  t5923 = t2076 * t669 * t5920;
  t5954 = t540 * t540;
  t5958 = t527 * t527;
  t5976 = t75 * (-0.625e3 / 0.1549681956e10 * t2046 * t669 * t5920 + 0.625e3 / 0.1549681956e10 * t5923) - 0.6e1 * t124 * t545 * t540 - 0.4e1 * t124 * t180 * t1757 - 0.4e1 * t124 * t1726 * t175 - 0.24e2 * t657 * t180 * t1732 + 0.12e2 * t288 * t545 * t527 + 0.8e1 * t288 * t176 * t1757 + 0.96e2 * t775 * t1728 * t180 - 0.36e2 * t657 * t528 * t540 + 0.24e2 * t288 * t531 * t540 + 0.6e1 * t288 * t81 * t5954 + 0.24e2 * t2136 * t81 * t5958 + 0.72e2 * t3579 * t1740 + 0.144e3 * t3585 * t1263 * t4579 - 0.36e2 * t250 * t1747 * t166 - 0.36e2 * t250 * t1750 * t166 - 0.12e2 * t250 * t1758 * t166;
  t5979 = t2185 * t28;
  t6014 = t540 * t47 * t1892;
  t6032 = -0.45e2 / 0.2e1 * t124 * t81 * params->b * t2199 * t5979 - 0.144e3 * t4775 * t1776 - 0.72e2 * t1262 * t1263 * t4598 - 0.72e2 * t2108 * t1733 * t166 + 0.9e1 * t4616 * t1767 + 0.12e2 * t106 * t1726 * t166 - 0.9e1 * t1041 * t403 * t54 * t527 + 0.72e2 * t245 * t545 * t514 - 0.625e3 / 0.1549681956e10 * t5923 + 0.9e1 / 0.2e1 * t1359 * t403 * t54 * t540 + 0.36e2 * t1087 * t765 * t743 * t175 + 0.72e2 * t717 * t176 * t6014 - 0.18e2 * t2199 * t28 * t2185 * t74 * t81 - 0.36e2 * t1763 * t1717 + 0.9e1 / 0.8e1 * t513 * t5979 * t127 - 0.9e1 / 0.2e1 * t1760 * t524 - 0.96e2 * t4671 * t4672 * t175;
  t6037 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t5976 + t6032));
  tv4sigma40 = 0.2e1 * rho[0] * t6037;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t6091 = 0.9e1 * t106 * t545 * t566 - t124 * t1726 * t206 - 0.3e1 * t124 * t545 * t588 - 0.3e1 * t124 * t180 * t1830 - t124 * t81 * (0.9e1 / 0.8e1 * t28 * t2944 * t127 - 0.18e3 * t2243 * t70 * t2944 * t28 + 0.36e3 * t731 * t137 * t2944 * t28) + 0.3e1 * t106 * t1726 * t192 + 0.6e1 * t288 * t576 * t540 + 0.6e1 * t288 * t1831 * t175 + 0.6e1 * t288 * t589 * t540 + 0.2e1 * t288 * t207 * t1757 + 0.12e2 * t288 * t1818 * t175 - 0.18e2 * t250 * t1813 * t175 - 0.9e1 * t250 * t559 * t540 - 0.9e1 * t250 * t567 * t540;
  t6132 = -0.3e1 * t250 * t193 * t1757 + 0.9e1 * t106 * t180 * t1154 * t62 + 0.6e1 * t288 * t1816 * t175 - 0.9e1 * t250 * t1833 * t175 - 0.18e2 * t657 * t576 * t527 - 0.18e2 * t657 * t589 * t527 + 0.18e2 * t717 * t559 * t527 + 0.18e2 * t717 * t567 * t527 - 0.18e2 * t2108 * t193 * t1732 + 0.24e2 * t2136 * t207 * t1732 - 0.36e2 * t5240 * t514 - 0.36e2 * t5248 * t514 - 0.9e1 / 0.2e1 * t1433 * t1767 - 0.36e2 * t514 * t4672 * t1491;
  t6177 = 0.9e1 / 0.2e1 * t1440 * t1767 + 0.36e2 * t245 * t1813 * t166 - 0.9e1 * t250 * t1816 * t166 - 0.18e2 * t250 * t1818 * t166 - 0.9e1 * t250 * t1831 * t166 + 0.18e2 * t245 * t1833 * t166 + 0.36e2 * t1856 * t1857 * t567 - 0.9e1 / 0.2e1 * t513 * t566 * t27 * t1862 + 0.9e1 / 0.4e1 * t4616 * t1867 + 0.9e1 / 0.4e1 * t1359 * t588 * t27 * t1862 + 0.9e1 * t1087 * t1891 * t2756 + 0.36e2 * t1856 * t1857 * t559 - 0.9e1 / 0.2e1 * t1763 * t1863 + 0.18e2 * t513 * t2944 * t304 * t47 * t28;
  t6198 = t527 * t47 * t1892;
  t6215 = 0.72e2 * t5256 * t271 * t403 * t175 + 0.18e2 * t1041 * t5027 * t175 - 0.9e1 * t1359 * t1539 * t175 - 0.18e2 * t1485 * t5115 * t175 - 0.9e1 * t1717 * t4620 * t192 - 0.24e2 * t4671 * t4672 * t206 + 0.18e2 * t1433 * t6014 - 0.18e2 * t1440 * t6014 + 0.36e2 * t5243 * t1851 + 0.36e2 * t5251 * t1851 - 0.36e2 * t5264 * t1851 - 0.36e2 * t5269 * t1851 - 0.54e2 * t3805 * t6198 + 0.36e2 * t3814 * t6198;
  t6221 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t6091 + t6132 + t6177 + t6215));
  tv4sigma3tau0 = 0.2e1 * rho[0] * t6221;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t6269 = 0.12e2 * t245 * t1915 * t166 + 0.12e2 * t245 * t1922 * t166 + 0.12e2 * t717 * t1931 * t166 - 0.6e1 * t250 * t1915 * t175 - 0.6e1 * t250 * t1922 * t175 - 0.12e2 * t657 * t1931 * t175 + 0.4e1 * t288 * t1943 * t175 + 0.4e1 * t288 * t1957 * t175 + 0.4e1 * t288 * t207 * t1830 - 0.3e1 * t250 * t614 * t540 + 0.2e1 * t288 * t636 * t540 + 0.8e1 * t288 * t576 * t588 + 0.6e1 * t717 * t614 * t527 - 0.6e1 * t657 * t618 * t540 + 0.48e2 * t5389 * t1851 + 0.24e2 * t5592 * t514;
  t6322 = -0.6e1 * t250 * t1943 * t166 - 0.6e1 * t250 * t1957 * t166 - 0.12e2 * t5602 * t514 - 0.12e2 * t166 * t4672 * t5687 + 0.24e2 * t166 * t4620 * t5671 - 0.24e2 * t514 * t4672 * t1603 + 0.3e1 * t1440 * t1867 - 0.3e1 / 0.2e1 * t513 * t613 * t27 * t1862 - 0.3e1 / 0.2e1 * t1041 * t617 * t27 * t1862 + 0.3e1 / 0.4e1 * t1359 * t635 * t27 * t1862 + 0.12e2 * t2151 * t598 * t527 - 0.36e2 * t2534 * t1603 * t527 + 0.12e2 * t1877 * t1878 * t1885 + 0.12e2 * t1856 * t1857 * t614 + 0.24e2 * t1041 * t5629 * t175 + 0.12e2 * t1041 * t1603 * t540 - 0.24e2 * t1087 * t1491 * t566;
  t6343 = t588 * t47 * t1892;
  t6361 = t28 * t4390;
  t6362 = t6361 * t127;
  t6368 = 0.12e2 * t513 * t192 * t1154 * t62 + 0.24e2 * t3473 * t1896 + 0.24e2 * t1041 * t5650 * t175 - 0.3e1 / 0.2e1 * t524 * t4620 * t597 + 0.12e2 * t5607 * t1851 - 0.24e2 * t5264 * t1893 - 0.24e2 * t5269 * t1893 - 0.24e2 * t1440 * t6343 - 0.12e2 * t5587 * t1851 - 0.36e2 * t5595 * t1851 + 0.24e2 * t1433 * t6343 + 0.24e2 * t2136 * t618 * t527 - 0.6e1 * t657 * t636 * t527 - 0.6e1 * t1359 * t1539 * t206 - 0.9e1 * t164 * t6362 - 0.24e2 * t1485 * t1486 * t588;
  t6428 = t566 * t566;
  t6432 = t588 * t588;
  t6436 = 0.2e1 * t288 * t545 * t617 - t124 * t545 * t635 - 0.2e1 * t124 * t180 * t1956 - t124 * t81 * (-0.576e4 * t731 * t137 * t4390 * t28 + 0.144e4 * t2243 * t70 * t4390 * t28 + 0.504e4 * t310 * t323 * t4390 * t28 + 0.36e2 * t2262 * t6361 - 0.18e2 * t6362) + 0.6e1 * t245 * t545 * t597 + 0.3e1 * t106 * t545 * t613 + 0.6e1 * t106 * t180 * t1921 - 0.12e2 * t678 * t1885 * t175 - 0.6e1 * t678 * t598 * t540 + 0.24e2 * t245 * t559 * t566 - 0.6e1 * t250 * t1833 * t206 - 0.12e2 * t250 * t1813 * t206 - 0.12e2 * t250 * t559 * t588 - 0.12e2 * t250 * t567 * t588 - 0.6e1 * t250 * t193 * t1830 + 0.12e2 * t245 * t81 * t6428 + 0.4e1 * t288 * t81 * t6432;
  t6442 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t6269 + t6322 + t6368 + t6436));
  tv4sigma2tau20 = 0.2e1 * rho[0] * t6442;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t6477 = 0.18e2 * t1041 * t5708 * t175 - 0.36e2 * t1087 * t1603 * t566 - 0.18e2 * t1485 * t5712 * t175 + 0.6e1 * t245 * t1993 * t166 - 0.18e2 * t2108 * t1997 * t166 - 0.3e1 * t250 * t2020 * t166 + 0.18e2 * t166 * t4620 * t5749 - 0.18e2 * t166 * t4672 * t5741 + 0.36e2 * t2556 * t5741 * t175 + 0.18e2 * t717 * t559 * t617 + 0.18e2 * t717 * t567 * t617;
  t6511 = 0.36e2 * t3814 * t617 * t47 * t1892 + 0.36e2 * t1041 * t1603 * t588 + 0.18e2 * t1041 * t5722 * t175 - 0.18e2 * t1087 * t5749 * t175 - 0.54e2 * t2534 * t5732 * t175 - 0.9e1 * t250 * t1915 * t206 - 0.9e1 * t250 * t1922 * t206 - 0.9e1 * t250 * t559 * t635 - 0.9e1 * t250 * t567 * t635 - 0.9e1 * t250 * t614 * t588 - 0.18e2 * t5587 * t1893;
  t6514 = t635 * t47 * t1892;
  t6521 = t28 * t5755;
  t6522 = t6521 * t127;
  t6524 = t2262 * t6521;
  t6569 = -0.18e2 * t1440 * t6514 + 0.18e2 * t1433 * t6514 - t124 * t180 * t2019 - t124 * t81 * (0.64512e5 * t132 * t740 * t5755 * t28 + 0.6912e5 * t731 * t137 * t5755 * t28 - 0.1152e5 * t2243 * t70 * t5755 * t28 - 0.12096e6 * t310 * t323 * t5755 * t28 + 0.72e3 * t2199 * t6521 + 0.216e3 * t6522 - 0.864e3 * t6524) + 0.18e2 * t5829 * t567 - 0.6e1 * t5810 * t176 + 0.3e1 * t106 * t180 * t1992 + 0.3e1 * t106 * t81 * (0.72e2 * t6522 - 0.96e2 * t6524) - 0.6e1 * t657 * t180 * t1996 + 0.18e2 * t245 * t567 * t613 + 0.18e2 * t245 * t193 * t1921;
  t6605 = -0.3e1 * t250 * t1993 * t175 + 0.24e2 * t2136 * t1997 * t175 + 0.2e1 * t288 * t2020 * t175 - 0.18e2 * t678 * t1885 * t206 - 0.9e1 * t250 * t193 * t1956 + 0.6e1 * t288 * t207 * t1956 + 0.18e2 * t245 * t559 * t613 + 0.6e1 * t288 * t576 * t635 + 0.6e1 * t288 * t589 * t635 - 0.18e2 * t678 * t598 * t588 - 0.18e2 * t657 * t618 * t588 + 0.6e1 * t1967 * t180;
  t6611 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * (t6477 + t6511 + t6569 + t6605));
  tv4sigmatau30 = 0.2e1 * rho[0] * t6611;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t6614 = t2069 * t127 * t28;
  t6616 = t2262 * t2070;
  t6618 = t2199 * t2070;
  t6668 = t635 * t635;
  t6678 = t613 * t613;
  t6697 = t617 * t617;
  t6704 = -t124 * t81 * (-0.2064384e7 * t132 * t740 * t2069 * t28 - 0.73728e6 * t731 * t137 * t2069 * t28 + 0.9216e5 * t2243 * t70 * t2069 * t28 + 0.774144e6 * t67 * t2272 * t2069 * t28 + 0.193536e7 * t310 * t323 * t2069 * t28 + 0.1152e5 * t2182 * t2070 - 0.2304e4 * t6614 + 0.13824e5 * t6616 - 0.2304e5 * t6618) + 0.36e2 * t5829 * t614 - 0.24e2 * t5810 * t207 + 0.3e1 * t106 * t81 * (-0.1152e4 * t6614 + 0.3072e4 * t6616 - 0.192e4 * t6618) + 0.72e2 * t2151 * t598 * t617 - 0.72e2 * t1087 * t1603 * t613 - 0.72e2 * t2108 * t193 * t1996 + 0.72e2 * t1041 * t1603 * t635 + 0.6e1 * t288 * t81 * t6668 + 0.8e1 * t288 * t207 * t2019 - 0.36e2 * t678 * t598 * t635 + 0.18e2 * t245 * t81 * t6678 + 0.24e2 * t245 * t193 * t1992 + 0.36e2 * t717 * t614 * t617 - 0.12e2 * t250 * t1993 * t206 - 0.18e2 * t250 * t614 * t635 - 0.12e2 * t250 * t193 * t2019 + 0.24e2 * t2136 * t81 * t6697 - 0.36e2 * t657 * t618 * t635;
  t6708 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t6704);
  tv4tau40 = 0.2e1 * rho[0] * t6708;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  double t158, t159, t160, t162, t165, t166, t170, t171;
  double t172, t175, t176, t177, t179, t180, t181, t182;
  double t184, t185, t186, t188, t189, t190, t194, t197;
  double t200, t201, t204, t205, t206, t209, t210, t214;
  double t215, t219, t220, t224, t225, t227, t229, t230;
  double t233, t235, t240, t241, t243, t246, t247, t251;
  double t254, t256, tvrho0, t260, t263, t264, t269, t271;
  double t274, t275, t279, t281, t282, t283, t284, t286;
  double t287, t288, t290, t291, t292, t296, t299, t302;
  double t303, t306, t307, t308, t311, t312, t316, t317;
  double t321, t322, t326, t327, t329, t331, t332, t335;
  double t337, t342, tvrho1, t345, t346, t348, t349, t352;
  double t354, t355, t357, t358, t362, t364, t368, tvsigma0;
  double tvsigma1, t369, t370, t372, t373, t376, t378, t379;
  double t381, t382, t386, t388, t392, tvsigma2, tvlapl0, tvlapl1;
  double t394, t396, t397, t403, t406, t409, t410, t412;
  double t416, tvtau0, t418, t420, t421, t427, t430, t433;
  double t434, t436, t440, tvtau1;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = t7 * t7;
  t159 = 0.1e1 / t158;
  t160 = t17 * t159;
  t162 = my_piecewise5(t11, 0, t15, 0, t8 - t160);
  t165 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t162);
  t166 = t165 * t27;
  t170 = t27 * t27;
  t171 = 0.1e1 / t170;
  t172 = t26 * t171;
  t175 = t6 * t172 * t88 / 0.8e1;
  t176 = params->kappa * params->kappa;
  t177 = t43 * t43;
  t179 = t176 / t177;
  t180 = t179 * t29;
  t181 = t33 * sigma[0];
  t182 = t35 * rho[0];
  t184 = 0.1e1 / t37 / t182;
  t185 = t181 * t184;
  t186 = t180 * t185;
  t188 = t63 * t79;
  t189 = t52 * t59;
  t190 = tau[0] * t39;
  t194 = -0.5e1 / 0.3e1 * t190 + sigma[0] * t184 / 0.3e1;
  t197 = t53 * t67;
  t200 = -0.8e1 * t189 * t194 - 0.4e2 / 0.3e1 * t197 * t190;
  t201 = t86 * t200;
  t204 = t78 * t78;
  t205 = 0.1e1 / t204;
  t206 = t64 * t205;
  t209 = 0.1e1 / t73;
  t210 = t65 * t209;
  t214 = params->b * t70 * t52;
  t215 = t75 * t194;
  t219 = 0.1e1 / t73 / t66;
  t220 = t219 * tau[0];
  t224 = 0.64e3 * t72 * t220 * t39 + 0.4e2 * t210 * t190 + 0.24e2 * t197 * t194 + 0.384e3 * t214 * t215;
  t225 = t86 * t224;
  t227 = t81 * t81;
  t229 = t176 / t227;
  t230 = t229 * t29;
  t233 = -0.1e2 / 0.729e3 * t230 * t185 + 0.1e2 / 0.729e3 * t186;
  t235 = -0.1e2 / 0.729e3 * t186 + 0.3e1 * t188 * t201 - t206 * t225 + t80 * t233;
  t240 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t88 - t175 - 0.3e1 / 0.8e1 * t6 * t28 * t235);
  t241 = t94 * t159;
  t243 = my_piecewise5(t15, 0, t11, 0, -t8 - t241);
  t246 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t243);
  t247 = t246 * t27;
  t251 = t101 * t171;
  t254 = t6 * t251 * t153 / 0.8e1;
  t256 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t153 - t254);
  tvrho0 = t92 + t157 + t7 * (t240 + t256);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t260 = my_piecewise5(t11, 0, t15, 0, -t8 - t160);
  t263 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t260);
  t264 = t263 * t27;
  t269 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t88 - t175);
  t271 = my_piecewise5(t15, 0, t11, 0, t8 - t241);
  t274 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t271);
  t275 = t274 * t27;
  t279 = t111 * t111;
  t281 = t176 / t279;
  t282 = t281 * t29;
  t283 = t33 * sigma[2];
  t284 = t103 * rho[1];
  t286 = 0.1e1 / t105 / t284;
  t287 = t283 * t286;
  t288 = t282 * t287;
  t290 = t128 * t144;
  t291 = t120 * t124;
  t292 = tau[1] * t107;
  t296 = -0.5e1 / 0.3e1 * t292 + sigma[2] * t286 / 0.3e1;
  t299 = t121 * t132;
  t302 = -0.8e1 * t291 * t296 - 0.4e2 / 0.3e1 * t299 * t292;
  t303 = t151 * t302;
  t306 = t143 * t143;
  t307 = 0.1e1 / t306;
  t308 = t129 * t307;
  t311 = 0.1e1 / t138;
  t312 = t130 * t311;
  t316 = params->b * t135 * t120;
  t317 = t140 * t296;
  t321 = 0.1e1 / t138 / t131;
  t322 = t321 * tau[1];
  t326 = 0.64e3 * t137 * t322 * t107 + 0.4e2 * t312 * t292 + 0.24e2 * t299 * t296 + 0.384e3 * t316 * t317;
  t327 = t151 * t326;
  t329 = t146 * t146;
  t331 = t176 / t329;
  t332 = t331 * t29;
  t335 = -0.1e2 / 0.729e3 * t332 * t287 + 0.1e2 / 0.729e3 * t288;
  t337 = -0.1e2 / 0.729e3 * t288 + 0.3e1 * t290 * t303 - t308 * t327 + t145 * t335;
  t342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t153 - t254 - 0.3e1 / 0.8e1 * t6 * t102 * t337);
  tvrho1 = t92 + t157 + t7 * (t269 + t342);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t345 = t34 * t39;
  t346 = t179 * t345;
  t348 = t188 * t86;
  t349 = t189 * t39;
  t352 = t197 * t39;
  t354 = t75 * t39;
  t355 = t214 * t354;
  t357 = -0.3e1 * t352 - 0.48e2 * t355;
  t358 = t86 * t357;
  t362 = 0.5e1 / 0.972e3 * t229 * t345 - 0.5e1 / 0.972e3 * t346;
  t364 = 0.5e1 / 0.972e3 * t346 + 0.3e1 * t348 * t349 - t206 * t358 + t80 * t362;
  t368 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t364);
  tvsigma0 = t7 * t368;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t369 = t34 * t107;
  t370 = t281 * t369;
  t372 = t290 * t151;
  t373 = t291 * t107;
  t376 = t299 * t107;
  t378 = t140 * t107;
  t379 = t316 * t378;
  t381 = -0.3e1 * t376 - 0.48e2 * t379;
  t382 = t151 * t381;
  t386 = 0.5e1 / 0.972e3 * t331 * t369 - 0.5e1 / 0.972e3 * t370;
  t388 = 0.5e1 / 0.972e3 * t370 + 0.3e1 * t372 * t373 - t308 * t382 + t145 * t386;
  t392 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t388);
  tvsigma2 = t7 * t392;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t394 = t197 * t49;
  t396 = -0.8e1 * t189 * t49 + 0.8e1 * t394;
  t397 = t86 * t396;
  t403 = t75 * t49;
  t406 = t219 * t49;
  t409 = -0.24e2 * t210 * t49 + 0.384e3 * t214 * t403 - 0.384e3 * t72 * t406 + 0.24e2 * t394;
  t410 = t86 * t409;
  t412 = 0.3e1 * t188 * t397 - t206 * t410;
  t416 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t412);
  tvtau0 = t7 * t416;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t418 = t299 * t117;
  t420 = -0.8e1 * t291 * t117 + 0.8e1 * t418;
  t421 = t151 * t420;
  t427 = t140 * t117;
  t430 = t321 * t117;
  t433 = -0.24e2 * t312 * t117 - 0.384e3 * t137 * t430 + 0.384e3 * t316 * t427 + 0.24e2 * t418;
  t434 = t151 * t433;
  t436 = 0.3e1 * t290 * t421 - t308 * t434;
  t440 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t436);
  tvtau1 = t7 * t440;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  double t158, t159, t160, t162, t165, t166, t170, t171;
  double t172, t175, t176, t177, t179, t180, t181, t182;
  double t184, t185, t186, t188, t189, t190, t194, t197;
  double t200, t201, t204, t205, t206, t209, t210, t214;
  double t215, t219, t220, t224, t225, t227, t229, t230;
  double t233, t235, t240, t241, t243, t246, t247, t251;
  double t254, t256, tvrho0, t260, t263, t264, t269, t271;
  double t274, t275, t279, t281, t282, t283, t284, t286;
  double t287, t288, t290, t291, t292, t296, t299, t302;
  double t303, t306, t307, t308, t311, t312, t316, t317;
  double t321, t322, t326, t327, t329, t331, t332, t335;
  double t337, t342, tvrho1, t345, t346, t348, t349, t352;
  double t354, t355, t357, t358, t362, t364, t368, tvsigma0;
  double tvsigma1, t369, t370, t372, t373, t376, t378, t379;
  double t381, t382, t386, t388, t392, tvsigma2, tvlapl0, tvlapl1;
  double t394, t396, t397, t403, t406, t409, t410, t412;
  double t416, tvtau0, t418, t420, t421, t427, t430, t433;
  double t434, t436, t440, tvtau1;

  double t443, t444, t445, t448, t449, t450, t453, t457;
  double t458, t462, t464, t470, t471, t474, t476, t480;
  double t481, t483, t484, t485, t486, t487, t489, t490;
  double t492, t494, t495, t497, t498, t499, t500, t503;
  double t507, t510, t513, t514, t515, t518, t522, t525;
  double t526, t527, t529, t530, t535, t536, t540, t541;
  double t542, t543, t546, t556, t557, t562, t563, t566;
  double t572, t573, t574, t581, t586, t587, t592, t594;
  double t599, t600, t601, t602, t605, t608, t612, t613;
  double t617, t619, t621, t624, t626, tv2rho20, t629, t633;
  double t637, t638, t642, t644, t652, t653, t657, t661;
  double t662, t666, t668, t675, t678, tv2rho21, t683, t688;
  double t692, t693, t699, t700, t705, t709, t710, t721;
  double t722, t723, t724, t725, t726, t728, t729, t731;
  double t733, t734, t736, t737, t738, t739, t742, t746;
  double t749, t752, t753, t754, t757, t761, t764, t765;
  double t766, t768, t769, t774, t775, t779, t780, t781;
  double t782, t785, t795, t796, t801, t802, t805, t811;
  double t812, t813, t820, t825, t826, t831, t833, t838;
  double tv2rho22, t846, t847, t849, t851, t853, t854, t856;
  double t857, t858, t859, t862, t863, t864, t867, t870;
  double t871, t874, t875, t878, t887, t889, t890, t892;
  double t894, t897, t899, t901, t903, t904, t906, t907;
  double t909, t918, t920, t925, tv2rhosigma0, tv2rhosigma1, t932, t934;
  double tv2rhosigma2, t940, tv2rhosigma3, tv2rhosigma4, t945, t947, t949, t951;
  double t952, t954, t955, t956, t957, t960, t961, t962;
  double t965, t968, t969, t972, t973, t976, t985, t987;
  double t988, t990, t992, t995, t997, t999, t1001, t1002;
  double t1004, t1005, t1007, t1016, t1018, t1023, tv2rhosigma5, tv2rholapl0;
  double tv2rholapl1, tv2rholapl2, tv2rholapl3, t1030, t1034, t1037, t1043, t1044;
  double t1048, t1049, t1051, t1054, t1055, t1064, t1078, t1086;
  double t1090, t1093, t1094, t1096, t1101, tv2rhotau0, t1108, t1110;
  double tv2rhotau1, t1116, tv2rhotau2, t1124, t1127, t1133, t1134, t1138;
  double t1139, t1141, t1144, t1145, t1154, t1168, t1176, t1180;
  double t1183, t1184, t1186, t1191, tv2rhotau3, t1193, t1194, t1195;
  double t1197, t1200, t1201, t1204, t1208, t1211, t1212, t1215;
  double t1218, t1220, t1221, t1223, t1224, t1228, t1230, t1234;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1235, t1236, t1238;
  double t1241, t1242, t1245, t1249, t1252, t1253, t1256, t1259;
  double t1261, t1262, t1264, t1265, t1269, t1271, t1275, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1276, t1277;
  double t1278, t1281, t1284, t1287, t1288, t1290, t1291, t1294;
  double t1295, t1301, t1304, t1306, t1307, t1309, t1311, t1312;
  double t1314, t1318, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1319;
  double t1320, t1321, t1324, t1327, t1330, t1331, t1333, t1334;
  double t1337, t1338, t1344, t1347, t1349, t1350, t1352, t1354;
  double t1355, t1357, t1361, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1362, t1363, t1366, t1370, t1373;
  double t1375, t1377, t1378, t1381, t1382, t1389, t1392, t1395;
  double t1398, t1399, t1401, t1405, tv2tau20, tv2tau21, t1406, t1407;
  double t1410, t1414, t1417, t1419, t1421, t1422, t1425, t1426;
  double t1433, t1436, t1439, t1442, t1443, t1445, t1449, tv2tau22;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = t7 * t7;
  t159 = 0.1e1 / t158;
  t160 = t17 * t159;
  t162 = my_piecewise5(t11, 0, t15, 0, t8 - t160);
  t165 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t162);
  t166 = t165 * t27;
  t170 = t27 * t27;
  t171 = 0.1e1 / t170;
  t172 = t26 * t171;
  t175 = t6 * t172 * t88 / 0.8e1;
  t176 = params->kappa * params->kappa;
  t177 = t43 * t43;
  t179 = t176 / t177;
  t180 = t179 * t29;
  t181 = t33 * sigma[0];
  t182 = t35 * rho[0];
  t184 = 0.1e1 / t37 / t182;
  t185 = t181 * t184;
  t186 = t180 * t185;
  t188 = t63 * t79;
  t189 = t52 * t59;
  t190 = tau[0] * t39;
  t194 = -0.5e1 / 0.3e1 * t190 + sigma[0] * t184 / 0.3e1;
  t197 = t53 * t67;
  t200 = -0.8e1 * t189 * t194 - 0.4e2 / 0.3e1 * t197 * t190;
  t201 = t86 * t200;
  t204 = t78 * t78;
  t205 = 0.1e1 / t204;
  t206 = t64 * t205;
  t209 = 0.1e1 / t73;
  t210 = t65 * t209;
  t214 = params->b * t70 * t52;
  t215 = t75 * t194;
  t219 = 0.1e1 / t73 / t66;
  t220 = t219 * tau[0];
  t224 = 0.64e3 * t72 * t220 * t39 + 0.4e2 * t210 * t190 + 0.24e2 * t197 * t194 + 0.384e3 * t214 * t215;
  t225 = t86 * t224;
  t227 = t81 * t81;
  t229 = t176 / t227;
  t230 = t229 * t29;
  t233 = -0.1e2 / 0.729e3 * t230 * t185 + 0.1e2 / 0.729e3 * t186;
  t235 = -0.1e2 / 0.729e3 * t186 + 0.3e1 * t188 * t201 - t206 * t225 + t80 * t233;
  t240 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t88 - t175 - 0.3e1 / 0.8e1 * t6 * t28 * t235);
  t241 = t94 * t159;
  t243 = my_piecewise5(t15, 0, t11, 0, -t8 - t241);
  t246 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t243);
  t247 = t246 * t27;
  t251 = t101 * t171;
  t254 = t6 * t251 * t153 / 0.8e1;
  t256 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t153 - t254);
  tvrho0 = t92 + t157 + t7 * (t240 + t256);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t260 = my_piecewise5(t11, 0, t15, 0, -t8 - t160);
  t263 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t260);
  t264 = t263 * t27;
  t269 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t88 - t175);
  t271 = my_piecewise5(t15, 0, t11, 0, t8 - t241);
  t274 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t271);
  t275 = t274 * t27;
  t279 = t111 * t111;
  t281 = t176 / t279;
  t282 = t281 * t29;
  t283 = t33 * sigma[2];
  t284 = t103 * rho[1];
  t286 = 0.1e1 / t105 / t284;
  t287 = t283 * t286;
  t288 = t282 * t287;
  t290 = t128 * t144;
  t291 = t120 * t124;
  t292 = tau[1] * t107;
  t296 = -0.5e1 / 0.3e1 * t292 + sigma[2] * t286 / 0.3e1;
  t299 = t121 * t132;
  t302 = -0.8e1 * t291 * t296 - 0.4e2 / 0.3e1 * t299 * t292;
  t303 = t151 * t302;
  t306 = t143 * t143;
  t307 = 0.1e1 / t306;
  t308 = t129 * t307;
  t311 = 0.1e1 / t138;
  t312 = t130 * t311;
  t316 = params->b * t135 * t120;
  t317 = t140 * t296;
  t321 = 0.1e1 / t138 / t131;
  t322 = t321 * tau[1];
  t326 = 0.64e3 * t137 * t322 * t107 + 0.4e2 * t312 * t292 + 0.24e2 * t299 * t296 + 0.384e3 * t316 * t317;
  t327 = t151 * t326;
  t329 = t146 * t146;
  t331 = t176 / t329;
  t332 = t331 * t29;
  t335 = -0.1e2 / 0.729e3 * t332 * t287 + 0.1e2 / 0.729e3 * t288;
  t337 = -0.1e2 / 0.729e3 * t288 + 0.3e1 * t290 * t303 - t308 * t327 + t145 * t335;
  t342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t153 - t254 - 0.3e1 / 0.8e1 * t6 * t102 * t337);
  tvrho1 = t92 + t157 + t7 * (t269 + t342);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t345 = t34 * t39;
  t346 = t179 * t345;
  t348 = t188 * t86;
  t349 = t189 * t39;
  t352 = t197 * t39;
  t354 = t75 * t39;
  t355 = t214 * t354;
  t357 = -0.3e1 * t352 - 0.48e2 * t355;
  t358 = t86 * t357;
  t362 = 0.5e1 / 0.972e3 * t229 * t345 - 0.5e1 / 0.972e3 * t346;
  t364 = 0.5e1 / 0.972e3 * t346 + 0.3e1 * t348 * t349 - t206 * t358 + t80 * t362;
  t368 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t364);
  tvsigma0 = t7 * t368;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t369 = t34 * t107;
  t370 = t281 * t369;
  t372 = t290 * t151;
  t373 = t291 * t107;
  t376 = t299 * t107;
  t378 = t140 * t107;
  t379 = t316 * t378;
  t381 = -0.3e1 * t376 - 0.48e2 * t379;
  t382 = t151 * t381;
  t386 = 0.5e1 / 0.972e3 * t331 * t369 - 0.5e1 / 0.972e3 * t370;
  t388 = 0.5e1 / 0.972e3 * t370 + 0.3e1 * t372 * t373 - t308 * t382 + t145 * t386;
  t392 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t388);
  tvsigma2 = t7 * t392;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t394 = t197 * t49;
  t396 = -0.8e1 * t189 * t49 + 0.8e1 * t394;
  t397 = t86 * t396;
  t403 = t75 * t49;
  t406 = t219 * t49;
  t409 = -0.24e2 * t210 * t49 + 0.384e3 * t214 * t403 - 0.384e3 * t72 * t406 + 0.24e2 * t394;
  t410 = t86 * t409;
  t412 = 0.3e1 * t188 * t397 - t206 * t410;
  t416 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t412);
  tvtau0 = t7 * t416;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t418 = t299 * t117;
  t420 = -0.8e1 * t291 * t117 + 0.8e1 * t418;
  t421 = t151 * t420;
  t427 = t140 * t117;
  t430 = t321 * t117;
  t433 = -0.24e2 * t312 * t117 - 0.384e3 * t137 * t430 + 0.384e3 * t316 * t427 + 0.24e2 * t418;
  t434 = t151 * t433;
  t436 = 0.3e1 * t290 * t421 - t308 * t434;
  t440 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t436);
  tvtau1 = t7 * t440;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t443 = t24 * t24;
  t444 = 0.1e1 / t443;
  t445 = t162 * t162;
  t448 = t158 * t7;
  t449 = 0.1e1 / t448;
  t450 = t17 * t449;
  t453 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t159 + 0.2e1 * t450);
  t457 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t445 + 0.4e1 / 0.3e1 * t24 * t453);
  t458 = t457 * t27;
  t462 = t165 * t171;
  t464 = t6 * t462 * t88;
  t470 = 0.1e1 / t170 / t7;
  t471 = t26 * t470;
  t474 = t6 * t471 * t88 / 0.12e2;
  t476 = t6 * t172 * t235;
  t480 = t176 / t177 / t43;
  t481 = t480 * t54;
  t483 = 0.1e1 / t31 / t30;
  t484 = sigma[0] * sigma[0];
  t485 = t483 * t484;
  t486 = t35 * t35;
  t487 = t486 * t182;
  t489 = 0.1e1 / t36 / t487;
  t490 = t485 * t489;
  t492 = 0.2e3 / 0.531441e6 * t481 * t490;
  t494 = 0.1e1 / t37 / t486;
  t495 = t181 * t494;
  t497 = 0.11e3 / 0.2187e4 * t180 * t495;
  t498 = t62 * t79;
  t499 = t200 * t200;
  t500 = t86 * t499;
  t503 = t63 * t205;
  t507 = t233 * t200;
  t510 = t194 * t194;
  t513 = t52 * t67;
  t514 = t194 * tau[0];
  t515 = t514 * t39;
  t518 = tau[0] * t184;
  t522 = 0.4e2 / 0.9e1 * t518 - 0.11e2 / 0.9e1 * sigma[0] * t494;
  t525 = t53 * t209;
  t526 = tau[0] * tau[0];
  t527 = t486 * rho[0];
  t529 = 0.1e1 / t36 / t527;
  t530 = t526 * t529;
  t535 = -0.8e1 * t510 * t59 - 0.16e3 / 0.3e1 * t513 * t515 - 0.8e1 * t189 * t522 - 0.2e3 / 0.3e1 * t525 * t530 + 0.32e3 / 0.9e1 * t197 * t518;
  t536 = t86 * t535;
  t540 = 0.1e1 / t204 / t78;
  t541 = t64 * t540;
  t542 = t224 * t224;
  t543 = t86 * t542;
  t546 = t233 * t224;
  t556 = 0.1e1 / t73 / t57;
  t557 = t65 * t556;
  t562 = params->b * t70;
  t563 = t75 * t510;
  t566 = t214 * t219;
  t572 = t73 * t73;
  t573 = 0.1e1 / t572;
  t574 = t573 * t526;
  t581 = 0.48e2 * t513 * t510 + 0.24e3 * t525 * t515 + 0.24e2 * t197 * t522 + 0.8e3 / 0.3e1 * t557 * t530 - 0.32e3 / 0.3e1 * t210 * t518 + 0.192e4 * t562 * t563 + 0.768e4 * t566 * t515 + 0.384e3 * t214 * t75 * t522 + 0.224e5 / 0.3e1 * t72 * t574 * t529 - 0.512e4 / 0.3e1 * t72 * t220 * t184;
  t586 = t176 / t227 / t81;
  t587 = t586 * t54;
  t592 = -0.2e3 / 0.531441e6 * t587 * t490 + 0.11e3 / 0.2187e4 * t230 * t495 + t492 - t497;
  t594 = -0.6e1 * t503 * t201 * t224 - t206 * t86 * t581 + 0.6e1 * t188 * t507 + 0.3e1 * t188 * t536 - 0.2e1 * t206 * t546 + 0.6e1 * t498 * t500 + 0.2e1 * t541 * t543 + t80 * t592 - t492 + t497;
  t599 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t88 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t235 + t474 - t476 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t594);
  t600 = t99 * t99;
  t601 = 0.1e1 / t600;
  t602 = t243 * t243;
  t605 = t94 * t449;
  t608 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t159 + 0.2e1 * t605);
  t612 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t602 + 0.4e1 / 0.3e1 * t99 * t608);
  t613 = t612 * t27;
  t617 = t246 * t171;
  t619 = t6 * t617 * t153;
  t621 = t101 * t470;
  t624 = t6 * t621 * t153 / 0.12e2;
  t626 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t153 - t619 / 0.4e1 + t624);
  tv2rho20 = 0.2e1 * t240 + 0.2e1 * t256 + t7 * (t599 + t626);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t629 = t444 * t260;
  t633 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t450);
  t637 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t629 * t162 + 0.4e1 / 0.3e1 * t24 * t633);
  t638 = t637 * t27;
  t642 = t263 * t171;
  t644 = t6 * t642 * t88;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t88 - t644 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t235 - t464 / 0.8e1 + t474 - t476 / 0.8e1);
  t653 = t601 * t271;
  t657 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t605);
  t661 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t653 * t243 + 0.4e1 / 0.3e1 * t99 * t657);
  t662 = t661 * t27;
  t666 = t274 * t171;
  t668 = t6 * t666 * t153;
  t675 = t6 * t251 * t337;
  t678 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t153 - t668 / 0.8e1 - t619 / 0.8e1 + t624 - 0.3e1 / 0.8e1 * t6 * t247 * t337 - t675 / 0.8e1);
  tv2rho21 = t240 + t256 + t269 + t342 + t7 * (t652 + t678);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t683 = t260 * t260;
  t688 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t159 + 0.2e1 * t450);
  t692 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t683 + 0.4e1 / 0.3e1 * t24 * t688);
  t693 = t692 * t27;
  t699 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t88 - t644 / 0.4e1 + t474);
  t700 = t271 * t271;
  t705 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t159 + 0.2e1 * t605);
  t709 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t700 + 0.4e1 / 0.3e1 * t99 * t705);
  t710 = t709 * t27;
  t721 = t176 / t279 / t111;
  t722 = t721 * t54;
  t723 = sigma[2] * sigma[2];
  t724 = t483 * t723;
  t725 = t103 * t103;
  t726 = t725 * t284;
  t728 = 0.1e1 / t104 / t726;
  t729 = t724 * t728;
  t731 = 0.2e3 / 0.531441e6 * t722 * t729;
  t733 = 0.1e1 / t105 / t725;
  t734 = t283 * t733;
  t736 = 0.11e3 / 0.2187e4 * t282 * t734;
  t737 = t127 * t144;
  t738 = t302 * t302;
  t739 = t151 * t738;
  t742 = t128 * t307;
  t746 = t335 * t302;
  t749 = t296 * t296;
  t752 = t120 * t132;
  t753 = t296 * tau[1];
  t754 = t753 * t107;
  t757 = tau[1] * t286;
  t761 = 0.4e2 / 0.9e1 * t757 - 0.11e2 / 0.9e1 * sigma[2] * t733;
  t764 = t121 * t311;
  t765 = tau[1] * tau[1];
  t766 = t725 * rho[1];
  t768 = 0.1e1 / t104 / t766;
  t769 = t765 * t768;
  t774 = -0.8e1 * t749 * t124 - 0.16e3 / 0.3e1 * t752 * t754 - 0.8e1 * t291 * t761 - 0.2e3 / 0.3e1 * t764 * t769 + 0.32e3 / 0.9e1 * t299 * t757;
  t775 = t151 * t774;
  t779 = 0.1e1 / t306 / t143;
  t780 = t129 * t779;
  t781 = t326 * t326;
  t782 = t151 * t781;
  t785 = t335 * t326;
  t795 = 0.1e1 / t138 / t122;
  t796 = t130 * t795;
  t801 = params->b * t135;
  t802 = t140 * t749;
  t805 = t316 * t321;
  t811 = t138 * t138;
  t812 = 0.1e1 / t811;
  t813 = t812 * t765;
  t820 = 0.48e2 * t752 * t749 + 0.24e3 * t764 * t754 + 0.24e2 * t299 * t761 + 0.8e3 / 0.3e1 * t796 * t769 - 0.32e3 / 0.3e1 * t312 * t757 + 0.192e4 * t801 * t802 + 0.768e4 * t805 * t754 + 0.384e3 * t316 * t140 * t761 + 0.224e5 / 0.3e1 * t137 * t813 * t768 - 0.512e4 / 0.3e1 * t137 * t322 * t286;
  t825 = t176 / t329 / t146;
  t826 = t825 * t54;
  t831 = -0.2e3 / 0.531441e6 * t826 * t729 + 0.11e3 / 0.2187e4 * t332 * t734 + t731 - t736;
  t833 = -t308 * t151 * t820 - 0.6e1 * t742 * t303 * t326 + t145 * t831 + 0.6e1 * t290 * t746 + 0.3e1 * t290 * t775 - 0.2e1 * t308 * t785 + 0.6e1 * t737 * t739 + 0.2e1 * t780 * t782 - t731 + t736;
  t838 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t153 - t668 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t337 + t624 - t675 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t833);
  tv2rho22 = 0.2e1 * t269 + 0.2e1 * t342 + t7 * (t699 + t838);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t846 = t6 * t172 * t364 / 0.8e1;
  t847 = t486 * t35;
  t849 = 0.1e1 / t36 / t847;
  t851 = t483 * t849 * sigma[0];
  t853 = 0.25e2 / 0.177147e6 * t481 * t851;
  t854 = t34 * t184;
  t856 = 0.1e2 / 0.729e3 * t179 * t854;
  t857 = t498 * t86;
  t858 = t39 * t200;
  t859 = t189 * t858;
  t862 = t503 * t86;
  t863 = t39 * t224;
  t864 = t189 * t863;
  t867 = t188 * t233;
  t870 = t194 * t59;
  t871 = t870 * t39;
  t874 = t529 * tau[0];
  t875 = t513 * t874;
  t878 = t189 * t184;
  t887 = t233 * t357;
  t889 = t39 * t194;
  t890 = t513 * t889;
  t892 = t525 * t874;
  t894 = t197 * t184;
  t897 = t562 * t354 * t194;
  t899 = t219 * t529;
  t901 = t214 * t899 * tau[0];
  t903 = t75 * t184;
  t904 = t214 * t903;
  t906 = -0.6e1 * t890 - 0.15e2 * t892 + 0.8e1 * t894 - 0.24e3 * t897 - 0.48e3 * t901 + 0.128e3 * t904;
  t907 = t86 * t906;
  t909 = t362 * t200;
  t918 = 0.25e2 / 0.177147e6 * t587 * t851 - 0.1e2 / 0.729e3 * t229 * t854 - t853 + t856;
  t920 = -0.3e1 * t503 * t358 * t200 - t206 * t362 * t224 + 0.2e1 * t541 * t358 * t224 + 0.3e1 * t188 * t909 - t206 * t887 - t206 * t907 + 0.3e1 * t348 * t871 + 0.1e2 * t348 * t875 - 0.8e1 * t348 * t878 + 0.3e1 * t867 * t349 + t80 * t918 + 0.6e1 * t857 * t859 - 0.3e1 * t862 * t864 + t853 - t856;
  t925 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t364 - t846 - 0.3e1 / 0.8e1 * t6 * t28 * t920);
  tv2rhosigma0 = t7 * t925 + t368;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t932 = t6 * t251 * t388 / 0.8e1;
  t934 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t388 - t932);
  tv2rhosigma2 = t7 * t934 + t392;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t940 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t364 - t846);
  tv2rhosigma3 = t7 * t940 + t368;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t945 = t725 * t103;
  t947 = 0.1e1 / t104 / t945;
  t949 = t483 * t947 * sigma[2];
  t951 = 0.25e2 / 0.177147e6 * t722 * t949;
  t952 = t34 * t286;
  t954 = 0.1e2 / 0.729e3 * t281 * t952;
  t955 = t737 * t151;
  t956 = t107 * t302;
  t957 = t291 * t956;
  t960 = t742 * t151;
  t961 = t107 * t326;
  t962 = t291 * t961;
  t965 = t290 * t335;
  t968 = t296 * t124;
  t969 = t968 * t107;
  t972 = t768 * tau[1];
  t973 = t752 * t972;
  t976 = t291 * t286;
  t985 = t335 * t381;
  t987 = t107 * t296;
  t988 = t752 * t987;
  t990 = t764 * t972;
  t992 = t299 * t286;
  t995 = t801 * t378 * t296;
  t997 = t321 * t768;
  t999 = t316 * t997 * tau[1];
  t1001 = t140 * t286;
  t1002 = t316 * t1001;
  t1004 = -0.6e1 * t988 - 0.15e2 * t990 + 0.8e1 * t992 - 0.24e3 * t995 - 0.48e3 * t999 + 0.128e3 * t1002;
  t1005 = t151 * t1004;
  t1007 = t386 * t302;
  t1016 = 0.25e2 / 0.177147e6 * t826 * t949 - 0.1e2 / 0.729e3 * t331 * t952 - t951 + t954;
  t1018 = -0.3e1 * t742 * t382 * t302 - t308 * t386 * t326 + 0.2e1 * t780 * t382 * t326 - t308 * t1005 + 0.3e1 * t290 * t1007 + t145 * t1016 - t308 * t985 + 0.3e1 * t372 * t969 + 0.1e2 * t372 * t973 - 0.8e1 * t372 * t976 + 0.3e1 * t965 * t373 + 0.6e1 * t955 * t957 - 0.3e1 * t960 * t962 + t951 - t954;
  t1023 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t388 - t932 - 0.3e1 / 0.8e1 * t6 * t102 * t1018);
  tv2rhosigma5 = t7 * t1023 + t392;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1030 = t6 * t172 * t412 / 0.8e1;
  t1034 = t397 * t224;
  t1037 = t233 * t396;
  t1043 = 0.1e1 / t36 / t486;
  t1044 = t1043 * tau[0];
  t1048 = t49 * t194;
  t1049 = t513 * t1048;
  t1051 = t525 * t1044;
  t1054 = -0.8e1 * t870 * t49 - 0.8e2 / 0.3e1 * t513 * t1044 + 0.4e2 / 0.3e1 * t349 + 0.16e2 * t1049 + 0.4e2 * t1051 - 0.4e2 / 0.3e1 * t352;
  t1055 = t86 * t1054;
  t1064 = t233 * t409;
  t1078 = t219 * t1043;
  t1086 = t573 * t1043;
  t1090 = t219 * t39;
  t1093 = 0.384e4 * t214 * t1078 * tau[0] - 0.448e4 * t72 * t1086 * tau[0] - 0.2304e4 * t214 * t406 * t194 + 0.192e4 * t562 * t403 * t194 - 0.16e3 * t557 * t1044 - 0.72e2 * t525 * t1048 + 0.64e3 * t72 * t1090 + 0.4e2 * t210 * t39 + 0.48e2 * t1049 + 0.12e3 * t1051 - 0.4e2 * t352 - 0.64e3 * t355;
  t1094 = t86 * t1093;
  t1096 = 0.6e1 * t498 * t397 * t200 - 0.3e1 * t503 * t410 * t200 + 0.2e1 * t541 * t410 * t224 - 0.3e1 * t503 * t1034 + 0.3e1 * t188 * t1037 + 0.3e1 * t188 * t1055 - t206 * t1064 - t206 * t1094;
  t1101 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t412 - t1030 - 0.3e1 / 0.8e1 * t6 * t28 * t1096);
  tv2rhotau0 = t7 * t1101 + t416;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1108 = t6 * t251 * t436 / 0.8e1;
  t1110 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t436 - t1108);
  tv2rhotau1 = t7 * t1110 + t440;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t412 - t1030);
  tv2rhotau2 = t7 * t1116 + t416;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1124 = t421 * t326;
  t1127 = t335 * t420;
  t1133 = 0.1e1 / t104 / t725;
  t1134 = t1133 * tau[1];
  t1138 = t117 * t296;
  t1139 = t752 * t1138;
  t1141 = t764 * t1134;
  t1144 = -0.8e1 * t968 * t117 - 0.8e2 / 0.3e1 * t752 * t1134 + 0.4e2 / 0.3e1 * t373 + 0.16e2 * t1139 + 0.4e2 * t1141 - 0.4e2 / 0.3e1 * t376;
  t1145 = t151 * t1144;
  t1154 = t335 * t433;
  t1168 = t321 * t1133;
  t1176 = t812 * t1133;
  t1180 = t321 * t107;
  t1183 = 0.384e4 * t316 * t1168 * tau[1] - 0.448e4 * t137 * t1176 * tau[1] - 0.2304e4 * t316 * t430 * t296 + 0.192e4 * t801 * t427 * t296 + 0.4e2 * t312 * t107 - 0.16e3 * t796 * t1134 - 0.72e2 * t764 * t1138 + 0.64e3 * t137 * t1180 + 0.48e2 * t1139 + 0.12e3 * t1141 - 0.4e2 * t376 - 0.64e3 * t379;
  t1184 = t151 * t1183;
  t1186 = 0.6e1 * t737 * t421 * t302 - 0.3e1 * t742 * t434 * t302 + 0.2e1 * t780 * t434 * t326 - 0.3e1 * t742 * t1124 + 0.3e1 * t290 * t1127 + 0.3e1 * t290 * t1145 - t308 * t1154 - t308 * t1184;
  t1191 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t436 - t1108 - 0.3e1 / 0.8e1 * t6 * t102 * t1186);
  tv2rhotau3 = t7 * t1191 + t440;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1193 = t54 * t483;
  t1194 = t1193 * t529;
  t1195 = t480 * t1194;
  t1197 = t525 * t529;
  t1200 = t39 * t357;
  t1201 = t189 * t1200;
  t1204 = t188 * t362;
  t1208 = t86 * t529 * t59;
  t1211 = t357 * t357;
  t1212 = t86 * t1211;
  t1215 = t362 * t357;
  t1218 = t513 * t529;
  t1220 = t75 * t529;
  t1221 = t562 * t1220;
  t1223 = 0.3e1 / 0.4e1 * t1218 + 0.3e2 * t1221;
  t1224 = t86 * t1223;
  t1228 = -0.25e2 / 0.472392e6 * t586 * t1194 + 0.25e2 / 0.472392e6 * t1195;
  t1230 = -0.25e2 / 0.472392e6 * t1195 + 0.6e1 * t857 * t1197 - 0.6e1 * t862 * t1201 + 0.6e1 * t1204 * t349 - 0.3e1 / 0.8e1 * t188 * t1208 + 0.2e1 * t541 * t1212 - 0.2e1 * t206 * t1215 - t206 * t1224 + t80 * t1228;
  t1234 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1230);
  tv2sigma20 = t7 * t1234;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1235 = t1193 * t768;
  t1236 = t721 * t1235;
  t1238 = t764 * t768;
  t1241 = t107 * t381;
  t1242 = t291 * t1241;
  t1245 = t290 * t386;
  t1249 = t151 * t768 * t124;
  t1252 = t381 * t381;
  t1253 = t151 * t1252;
  t1256 = t386 * t381;
  t1259 = t752 * t768;
  t1261 = t140 * t768;
  t1262 = t801 * t1261;
  t1264 = 0.3e1 / 0.4e1 * t1259 + 0.3e2 * t1262;
  t1265 = t151 * t1264;
  t1269 = -0.25e2 / 0.472392e6 * t825 * t1235 + 0.25e2 / 0.472392e6 * t1236;
  t1271 = -0.25e2 / 0.472392e6 * t1236 + 0.6e1 * t955 * t1238 - 0.6e1 * t960 * t1242 + 0.6e1 * t1245 * t373 - 0.3e1 / 0.8e1 * t290 * t1249 + 0.2e1 * t780 * t1253 - 0.2e1 * t308 * t1256 - t308 * t1265 + t145 * t1269;
  t1275 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1271);
  tv2sigma25 = t7 * t1275;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1276 = t396 * t52;
  t1277 = t59 * t39;
  t1278 = t1276 * t1277;
  t1281 = t397 * t357;
  t1284 = t362 * t396;
  t1287 = t1043 * t59;
  t1288 = t513 * t1043;
  t1290 = t1287 - 0.2e1 * t1288;
  t1291 = t86 * t1290;
  t1294 = t409 * t52;
  t1295 = t1294 * t1277;
  t1301 = t362 * t409;
  t1304 = t525 * t1043;
  t1306 = t75 * t1043;
  t1307 = t562 * t1306;
  t1309 = t214 * t1078;
  t1311 = -0.6e1 * t1288 + 0.9e1 * t1304 - 0.24e3 * t1307 + 0.288e3 * t1309;
  t1312 = t86 * t1311;
  t1314 = 0.2e1 * t541 * t410 * t357 + 0.6e1 * t857 * t1278 - 0.3e1 * t503 * t1281 + 0.3e1 * t188 * t1284 + 0.3e1 * t188 * t1291 - 0.3e1 * t862 * t1295 - t206 * t1301 - t206 * t1312;
  t1318 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1314);
  tv2sigmatau0 = t7 * t1318;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1319 = t420 * t120;
  t1320 = t124 * t107;
  t1321 = t1319 * t1320;
  t1324 = t421 * t381;
  t1327 = t386 * t420;
  t1330 = t1133 * t124;
  t1331 = t752 * t1133;
  t1333 = t1330 - 0.2e1 * t1331;
  t1334 = t151 * t1333;
  t1337 = t433 * t120;
  t1338 = t1337 * t1320;
  t1344 = t386 * t433;
  t1347 = t764 * t1133;
  t1349 = t140 * t1133;
  t1350 = t801 * t1349;
  t1352 = t316 * t1168;
  t1354 = -0.6e1 * t1331 + 0.9e1 * t1347 - 0.24e3 * t1350 + 0.288e3 * t1352;
  t1355 = t151 * t1354;
  t1357 = 0.2e1 * t780 * t434 * t381 + 0.6e1 * t955 * t1321 - 0.3e1 * t742 * t1324 + 0.3e1 * t290 * t1327 + 0.3e1 * t290 * t1334 - 0.3e1 * t960 * t1338 - t308 * t1344 - t308 * t1355;
  t1361 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1357);
  tv2sigmatau5 = t7 * t1361;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1362 = t396 * t396;
  t1363 = t86 * t1362;
  t1366 = t397 * t409;
  t1370 = 0.1e1 / t36 / t182;
  t1373 = t513 * t1370;
  t1375 = t525 * t1370;
  t1377 = -0.8e1 * t1370 * t59 + 0.32e2 * t1373 - 0.24e2 * t1375;
  t1378 = t86 * t1377;
  t1381 = t409 * t409;
  t1382 = t86 * t1381;
  t1389 = t75 * t1370;
  t1392 = t219 * t1370;
  t1395 = t573 * t1370;
  t1398 = 0.96e2 * t557 * t1370 + 0.192e4 * t562 * t1389 - 0.4608e4 * t214 * t1392 + 0.2688e4 * t72 * t1395 + 0.48e2 * t1373 - 0.144e3 * t1375;
  t1399 = t86 * t1398;
  t1401 = 0.6e1 * t498 * t1363 - 0.6e1 * t503 * t1366 + 0.3e1 * t188 * t1378 + 0.2e1 * t541 * t1382 - t206 * t1399;
  t1405 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1401);
  tv2tau20 = t7 * t1405;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1406 = t420 * t420;
  t1407 = t151 * t1406;
  t1410 = t421 * t433;
  t1414 = 0.1e1 / t104 / t284;
  t1417 = t752 * t1414;
  t1419 = t764 * t1414;
  t1421 = -0.8e1 * t1414 * t124 + 0.32e2 * t1417 - 0.24e2 * t1419;
  t1422 = t151 * t1421;
  t1425 = t433 * t433;
  t1426 = t151 * t1425;
  t1433 = t140 * t1414;
  t1436 = t321 * t1414;
  t1439 = t812 * t1414;
  t1442 = 0.2688e4 * t137 * t1439 + 0.96e2 * t796 * t1414 + 0.192e4 * t801 * t1433 - 0.4608e4 * t316 * t1436 + 0.48e2 * t1417 - 0.144e3 * t1419;
  t1443 = t151 * t1442;
  t1445 = 0.6e1 * t737 * t1407 - 0.6e1 * t742 * t1410 + 0.3e1 * t290 * t1422 + 0.2e1 * t780 * t1426 - t308 * t1443;
  t1449 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1445);
  tv2tau22 = t7 * t1449;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  double t158, t159, t160, t162, t165, t166, t170, t171;
  double t172, t175, t176, t177, t179, t180, t181, t182;
  double t184, t185, t186, t188, t189, t190, t194, t197;
  double t200, t201, t204, t205, t206, t209, t210, t214;
  double t215, t219, t220, t224, t225, t227, t229, t230;
  double t233, t235, t240, t241, t243, t246, t247, t251;
  double t254, t256, tvrho0, t260, t263, t264, t269, t271;
  double t274, t275, t279, t281, t282, t283, t284, t286;
  double t287, t288, t290, t291, t292, t296, t299, t302;
  double t303, t306, t307, t308, t311, t312, t316, t317;
  double t321, t322, t326, t327, t329, t331, t332, t335;
  double t337, t342, tvrho1, t345, t346, t348, t349, t352;
  double t354, t355, t357, t358, t362, t364, t368, tvsigma0;
  double tvsigma1, t369, t370, t372, t373, t376, t378, t379;
  double t381, t382, t386, t388, t392, tvsigma2, tvlapl0, tvlapl1;
  double t394, t396, t397, t403, t406, t409, t410, t412;
  double t416, tvtau0, t418, t420, t421, t427, t430, t433;
  double t434, t436, t440, tvtau1;

  double t443, t444, t445, t448, t449, t450, t453, t457;
  double t458, t462, t464, t470, t471, t474, t476, t480;
  double t481, t483, t484, t485, t486, t487, t489, t490;
  double t492, t494, t495, t497, t498, t499, t500, t503;
  double t507, t510, t513, t514, t515, t518, t522, t525;
  double t526, t527, t529, t530, t535, t536, t540, t541;
  double t542, t543, t546, t556, t557, t562, t563, t566;
  double t572, t573, t574, t581, t586, t587, t592, t594;
  double t599, t600, t601, t602, t605, t608, t612, t613;
  double t617, t619, t621, t624, t626, tv2rho20, t629, t633;
  double t637, t638, t642, t644, t652, t653, t657, t661;
  double t662, t666, t668, t675, t678, tv2rho21, t683, t688;
  double t692, t693, t699, t700, t705, t709, t710, t721;
  double t722, t723, t724, t725, t726, t728, t729, t731;
  double t733, t734, t736, t737, t738, t739, t742, t746;
  double t749, t752, t753, t754, t757, t761, t764, t765;
  double t766, t768, t769, t774, t775, t779, t780, t781;
  double t782, t785, t795, t796, t801, t802, t805, t811;
  double t812, t813, t820, t825, t826, t831, t833, t838;
  double tv2rho22, t846, t847, t849, t851, t853, t854, t856;
  double t857, t858, t859, t862, t863, t864, t867, t870;
  double t871, t874, t875, t878, t887, t889, t890, t892;
  double t894, t897, t899, t901, t903, t904, t906, t907;
  double t909, t918, t920, t925, tv2rhosigma0, tv2rhosigma1, t932, t934;
  double tv2rhosigma2, t940, tv2rhosigma3, tv2rhosigma4, t945, t947, t949, t951;
  double t952, t954, t955, t956, t957, t960, t961, t962;
  double t965, t968, t969, t972, t973, t976, t985, t987;
  double t988, t990, t992, t995, t997, t999, t1001, t1002;
  double t1004, t1005, t1007, t1016, t1018, t1023, tv2rhosigma5, tv2rholapl0;
  double tv2rholapl1, tv2rholapl2, tv2rholapl3, t1030, t1034, t1037, t1043, t1044;
  double t1048, t1049, t1051, t1054, t1055, t1064, t1078, t1086;
  double t1090, t1093, t1094, t1096, t1101, tv2rhotau0, t1108, t1110;
  double tv2rhotau1, t1116, tv2rhotau2, t1124, t1127, t1133, t1134, t1138;
  double t1139, t1141, t1144, t1145, t1154, t1168, t1176, t1180;
  double t1183, t1184, t1186, t1191, tv2rhotau3, t1193, t1194, t1195;
  double t1197, t1200, t1201, t1204, t1208, t1211, t1212, t1215;
  double t1218, t1220, t1221, t1223, t1224, t1228, t1230, t1234;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1235, t1236, t1238;
  double t1241, t1242, t1245, t1249, t1252, t1253, t1256, t1259;
  double t1261, t1262, t1264, t1265, t1269, t1271, t1275, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1276, t1277;
  double t1278, t1281, t1284, t1287, t1288, t1290, t1291, t1294;
  double t1295, t1301, t1304, t1306, t1307, t1309, t1311, t1312;
  double t1314, t1318, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1319;
  double t1320, t1321, t1324, t1327, t1330, t1331, t1333, t1334;
  double t1337, t1338, t1344, t1347, t1349, t1350, t1352, t1354;
  double t1355, t1357, t1361, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1362, t1363, t1366, t1370, t1373;
  double t1375, t1377, t1378, t1381, t1382, t1389, t1392, t1395;
  double t1398, t1399, t1401, t1405, tv2tau20, tv2tau21, t1406, t1407;
  double t1410, t1414, t1417, t1419, t1421, t1422, t1425, t1426;
  double t1433, t1436, t1439, t1442, t1443, t1445, t1449, tv2tau22;

  double t1453, t1454, t1457, t1460, t1461, t1462, t1465, t1469;
  double t1470, t1474, t1476, t1481, t1483, t1486, t1492, t1493;
  double t1496, t1498, t1501, t1503, t1504, t1505, t1506, t1507;
  double t1513, t1515, t1516, t1517, t1518, t1519, t1520, t1521;
  double t1522, t1523, t1525, t1526, t1542, t1546, t1550, t1555;
  double t1558, t1559, t1560, t1563, t1564, t1567, t1570, t1573;
  double t1576, t1579, t1580, t1581, t1582, t1585, t1590, t1591;
  double t1604, t1605, t1609, t1610, t1621, t1622, t1629, t1634;
  double t1645, t1648, t1660, t1663, t1664, t1667, t1670, t1672;
  double t1674, t1675, t1677, t1678, t1680, t1687, t1689, t1690;
  double t1695, t1697, t1698, t1701, t1704, t1707, t1711, t1712;
  double t1716, t1718, t1720, t1722, t1724, t1727, t1729, tv3rho30;
  double t1732, t1733, t1734, t1737, t1742, t1743, t1745, t1749;
  double t1750, t1754, t1757, t1761, t1763, t1767, t1776, t1777;
  double t1778, t1781, t1786, t1788, t1792, t1793, t1797, t1800;
  double t1801, t1803, t1812, t1814, t1817, tv3rho31, t1820, t1825;
  double t1829, t1833, t1834, t1838, t1840, t1849, t1850, t1855;
  double t1859, t1863, t1864, t1868, t1870, t1877, t1885, t1887;
  double t1888, tv3rho32, t1893, t1900, t1904, t1905, t1912, t1913;
  double t1920, t1924, t1925, t1940, t1956, t1957, t1958, t1959;
  double t1960, t1966, t1968, t1969, t1970, t1971, t1972, t1973;
  double t1974, t1976, t1977, t1991, t1994, t1995, t2003, t2004;
  double t2005, t2006, t2010, t2011, t2012, t2015, t2016, t2019;
  double t2020, t2021, t2024, t2027, t2032, t2041, t2044, t2047;
  double t2048, t2053, t2056, t2066, t2069, t2070, t2073, t2076;
  double t2079, t2084, t2101, t2102, t2105, t2107, t2109, t2110;
  double t2112, t2113, t2115, t2122, t2124, t2125, t2130, tv3rho33;
  double t2138, t2145, t2147, t2149, t2152, t2158, t2163, t2165;
  double t2167, t2168, t2169, t2171, t2172, t2174, t2175, t2177;
  double t2178, t2180, t2181, t2183, t2186, t2188, t2191, t2194;
  double t2196, t2198, t2200, t2202, t2204, t2205, t2207, t2208;
  double t2210, t2213, t2222, t2223, t2225, t2226, t2228, t2247;
  double t2249, t2253, t2256, t2260, t2262, t2263, t2265, t2266;
  double t2271, t2276, t2277, t2280, t2281, t2282, t2285, t2288;
  double t2289, t2294, t2295, t2298, t2299, t2302, t2303, t2304;
  double t2307, t2310, t2311, t2314, t2317, t2320, t2323, t2324;
  double t2327, t2336, t2338, t2339, t2340, t2341, t2344, t2345;
  double t2346, t2347, t2350, t2351, t2352, t2355, t2357, t2362;
  double tv3rho2sigma0, tv3rho2sigma1, t2369, t2373, t2375, tv3rho2sigma2, t2381, t2389;
  double tv3rho2sigma3, tv3rho2sigma4, t2395, t2402, t2405, tv3rho2sigma5, t2413, tv3rho2sigma6;
  double tv3rho2sigma7, t2427, t2430, t2433, t2439, t2441, t2443, t2446;
  double t2448, t2449, t2450, t2452, t2453, t2455, t2456, t2458;
  double t2459, t2461, t2462, t2464, t2467, t2469, t2472, t2475;
  double t2477, t2479, t2481, t2483, t2485, t2486, t2488, t2489;
  double t2497, t2519, t2521, t2522, t2524, t2525, t2527, t2528;
  double t2533, t2534, t2537, t2539, t2540, t2541, t2546, t2549;
  double t2552, t2553, t2556, t2557, t2560, t2561, t2564, t2567;
  double t2570, t2571, t2574, t2577, t2578, t2581, t2582, t2587;
  double t2588, t2591, t2594, t2598, t2600, t2601, t2602, t2611;
  double t2613, t2614, t2615, t2616, t2619, t2620, t2621, t2622;
  double t2625, t2626, t2627, t2630, t2632, t2637, tv3rho2sigma8, tv3rho2lapl0;
  double tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2644, t2651, t2653;
  double t2673, t2676, t2684, t2685, t2690, t2692, t2693, t2694;
  double t2697, t2698, t2700, t2704, t2705, t2708, t2710, t2720;
  double t2734, t2741, t2748, t2755, t2773, t2774, t2775, t2777;
  double t2781, t2782, t2783, t2792, t2793, t2804, t2816, t2817;
  double t2822, tv3rho2tau0, t2829, t2833, t2835, tv3rho2tau1, t2841, t2849;
  double tv3rho2tau2, t2855, t2862, t2865, tv3rho2tau3, t2873, tv3rho2tau4, t2910;
  double t2919, t2923, t2926, t2934, t2935, t2940, t2942, t2943;
  double t2944, t2947, t2948, t2950, t2954, t2955, t2958, t2960;
  double t2971, t2978, t2991, t3000, t3002, t3023, t3024, t3025;
  double t3027, t3028, t3029, t3038, t3039, t3045, t3046, t3051;
  double tv3rho2tau5, t3058, t3063, t3064, t3065, t3066, t3069, t3073;
  double t3075, t3076, t3103, t3104, t3109, t3114, t3115, t3118;
  double t3121, t3122, t3125, t3128, t3131, t3132, t3135, t3136;
  double t3141, t3144, t3145, t3148, t3151, t3156, t3157, t3161;
  double t3164, t3169, t3172, t3175, t3178, t3180, t3182, t3184;
  double t3187, t3189, t3191, t3193, t3194, t3196, t3197, t3199;
  double t3202, t3203, t3204, t3207, t3208, t3211, t3213, t3218;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t3225, t3227, tv3rhosigma25;
  double t3233, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t3257, t3258;
  double t3259, t3260, t3262, t3273, t3275, t3278, t3283, t3288;
  double t3289, t3292, t3295, t3296, t3299, t3300, t3303, t3308;
  double t3310, t3311, t3316, t3319, t3320, t3323, t3326, t3331;
  double t3332, t3335, t3339, t3340, t3343, t3345, t3347, t3350;
  double t3352, t3354, t3356, t3357, t3359, t3360, t3362, t3367;
  double t3370, t3373, t3376, t3378, t3381, t3382, t3383, t3386;
  double t3387, t3390, t3392, t3397, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2;
  double tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10;
  double tv3rhosigmalapl11, t3404, t3447, t3448, t3451, t3454, t3455, t3458;
  double t3459, t3466, t3467, t3468, t3471, t3472, t3477, t3478;
  double t3481, t3482, t3485, t3486, t3489, t3492, t3494, t3496;
  double t3497, t3500, t3502, t3506, t3508, t3510, t3514, t3517;
  double t3519, t3521, t3522, t3524, t3527, t3531, t3532, t3537;
  double t3538, t3541, t3543, t3545, t3548, t3551, t3554, t3557;
  double t3560, t3563, t3564, t3569, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3;
  double tv3rhosigmatau4, t3576, t3578, tv3rhosigmatau5, t3584, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, t3631, t3632, t3633, t3636, t3637, t3640;
  double t3643, t3645, t3646, t3649, t3651, t3655, t3657, t3659;
  double t3663, t3666, t3668, t3670, t3671, t3673, t3675, t3677;
  double t3678, t3681, t3684, t3688, t3689, t3694, t3695, t3698;
  double t3700, t3705, t3706, t3709, t3710, t3713, t3714, t3717;
  double t3724, t3725, t3728, t3729, t3732, t3735, t3738, t3741;
  double t3744, t3747, t3748, t3753, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22;
  double tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t3760, t3763, t3766, t3769, t3772;
  double t3773, t3776, t3795, t3799, t3800, t3803, t3805, t3806;
  double t3809, t3810, t3812, t3815, t3816, t3825, t3837, t3854;
  double t3862, t3870, t3876, t3877, t3879, t3880, t3885, tv3rhotau20;
  double tv3rhotau21, t3892, t3894, tv3rhotau22, t3900, tv3rhotau23, tv3rhotau24, t3907;
  double t3910, t3913, t3916, t3917, t3920, t3939, t3943, t3944;
  double t3947, t3949, t3950, t3953, t3954, t3956, t3959, t3960;
  double t3969, t3981, t3998, t4006, t4014, t4020, t4021, t4023;
  double t4024, t4029, tv3rhotau25, t4031, t4032, t4035, t4036, t4048;
  double t4051, t4054, t4057, t4059, t4061, t4064, t4067, t4070;
  double t4074, t4075, t4077, t4078, t4082, t4083, t4086, t4087;
  double t4090, t4094, t4098, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t4099, t4100, t4102, t4105;
  double t4108, t4112, t4113, t4115, t4116, t4118, t4122, t4123;
  double t4130, t4131, t4139, t4142, t4145, t4150, t4152, t4153;
  double t4158, t4159, t4162, t4166, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double tv3sigma2lapl11, t4169, t4170, t4175, t4176, t4179, t4182, t4185;
  double t4187, t4191, t4193, t4194, t4196, t4198, t4199, t4208;
  double t4228, t4229, t4235, t4236, t4242, t4243, t4246, t4247;
  double t4248, t4251, t4252, t4256, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3;
  double tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t4270;
  double t4271, t4277, t4278, t4286, t4287, t4292, t4293, t4296;
  double t4297, t4300, t4303, t4305, t4309, t4311, t4312, t4314;
  double t4316, t4317, t4332, t4333, t4336, t4337, t4338, t4341;
  double t4342, t4346, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24;
  double tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3;
  double tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11;
  double t4347, t4350, t4353, t4356, t4361, t4373, t4374, t4381;
  double t4385, t4387, t4388, t4391, t4392, t4398, t4404, t4405;
  double t4411, t4415, t4417, t4418, t4420, t4422, t4424, t4425;
  double t4427, t4428, t4432, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24;
  double tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t4433, t4436, t4439, t4442, t4447;
  double t4459, t4460, t4467, t4471, t4473, t4474, t4477, t4478;
  double t4484, t4490, t4491, t4497, t4501, t4503, t4504, t4506;
  double t4508, t4510, t4511, t4513, t4514, t4518, tv3sigmatau28, tv3lapl30;
  double tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4;
  double tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t4519;
  double t4520, t4523, t4526, t4538, t4540, t4541, t4543, t4545;
  double t4546, t4549, t4550, t4560, t4563, t4566, t4569, t4572;
  double t4573, t4575, t4579, tv3tau30, tv3tau31, tv3tau32, t4580, t4581;
  double t4584, t4587, t4599, t4601, t4602, t4604, t4606, t4607;
  double t4610, t4611, t4621, t4624, t4627, t4630, t4633, t4634;
  double t4636, t4640, tv3tau33;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = t7 * t7;
  t159 = 0.1e1 / t158;
  t160 = t17 * t159;
  t162 = my_piecewise5(t11, 0, t15, 0, t8 - t160);
  t165 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t162);
  t166 = t165 * t27;
  t170 = t27 * t27;
  t171 = 0.1e1 / t170;
  t172 = t26 * t171;
  t175 = t6 * t172 * t88 / 0.8e1;
  t176 = params->kappa * params->kappa;
  t177 = t43 * t43;
  t179 = t176 / t177;
  t180 = t179 * t29;
  t181 = t33 * sigma[0];
  t182 = t35 * rho[0];
  t184 = 0.1e1 / t37 / t182;
  t185 = t181 * t184;
  t186 = t180 * t185;
  t188 = t63 * t79;
  t189 = t52 * t59;
  t190 = tau[0] * t39;
  t194 = -0.5e1 / 0.3e1 * t190 + sigma[0] * t184 / 0.3e1;
  t197 = t53 * t67;
  t200 = -0.8e1 * t189 * t194 - 0.4e2 / 0.3e1 * t197 * t190;
  t201 = t86 * t200;
  t204 = t78 * t78;
  t205 = 0.1e1 / t204;
  t206 = t64 * t205;
  t209 = 0.1e1 / t73;
  t210 = t65 * t209;
  t214 = params->b * t70 * t52;
  t215 = t75 * t194;
  t219 = 0.1e1 / t73 / t66;
  t220 = t219 * tau[0];
  t224 = 0.64e3 * t72 * t220 * t39 + 0.4e2 * t210 * t190 + 0.24e2 * t197 * t194 + 0.384e3 * t214 * t215;
  t225 = t86 * t224;
  t227 = t81 * t81;
  t229 = t176 / t227;
  t230 = t229 * t29;
  t233 = -0.1e2 / 0.729e3 * t230 * t185 + 0.1e2 / 0.729e3 * t186;
  t235 = -0.1e2 / 0.729e3 * t186 + 0.3e1 * t188 * t201 - t206 * t225 + t80 * t233;
  t240 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t88 - t175 - 0.3e1 / 0.8e1 * t6 * t28 * t235);
  t241 = t94 * t159;
  t243 = my_piecewise5(t15, 0, t11, 0, -t8 - t241);
  t246 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t243);
  t247 = t246 * t27;
  t251 = t101 * t171;
  t254 = t6 * t251 * t153 / 0.8e1;
  t256 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t153 - t254);
  tvrho0 = t92 + t157 + t7 * (t240 + t256);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t260 = my_piecewise5(t11, 0, t15, 0, -t8 - t160);
  t263 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t260);
  t264 = t263 * t27;
  t269 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t88 - t175);
  t271 = my_piecewise5(t15, 0, t11, 0, t8 - t241);
  t274 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t271);
  t275 = t274 * t27;
  t279 = t111 * t111;
  t281 = t176 / t279;
  t282 = t281 * t29;
  t283 = t33 * sigma[2];
  t284 = t103 * rho[1];
  t286 = 0.1e1 / t105 / t284;
  t287 = t283 * t286;
  t288 = t282 * t287;
  t290 = t128 * t144;
  t291 = t120 * t124;
  t292 = tau[1] * t107;
  t296 = -0.5e1 / 0.3e1 * t292 + sigma[2] * t286 / 0.3e1;
  t299 = t121 * t132;
  t302 = -0.8e1 * t291 * t296 - 0.4e2 / 0.3e1 * t299 * t292;
  t303 = t151 * t302;
  t306 = t143 * t143;
  t307 = 0.1e1 / t306;
  t308 = t129 * t307;
  t311 = 0.1e1 / t138;
  t312 = t130 * t311;
  t316 = params->b * t135 * t120;
  t317 = t140 * t296;
  t321 = 0.1e1 / t138 / t131;
  t322 = t321 * tau[1];
  t326 = 0.64e3 * t137 * t322 * t107 + 0.4e2 * t312 * t292 + 0.24e2 * t299 * t296 + 0.384e3 * t316 * t317;
  t327 = t151 * t326;
  t329 = t146 * t146;
  t331 = t176 / t329;
  t332 = t331 * t29;
  t335 = -0.1e2 / 0.729e3 * t332 * t287 + 0.1e2 / 0.729e3 * t288;
  t337 = -0.1e2 / 0.729e3 * t288 + 0.3e1 * t290 * t303 - t308 * t327 + t145 * t335;
  t342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t153 - t254 - 0.3e1 / 0.8e1 * t6 * t102 * t337);
  tvrho1 = t92 + t157 + t7 * (t269 + t342);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t345 = t34 * t39;
  t346 = t179 * t345;
  t348 = t188 * t86;
  t349 = t189 * t39;
  t352 = t197 * t39;
  t354 = t75 * t39;
  t355 = t214 * t354;
  t357 = -0.3e1 * t352 - 0.48e2 * t355;
  t358 = t86 * t357;
  t362 = 0.5e1 / 0.972e3 * t229 * t345 - 0.5e1 / 0.972e3 * t346;
  t364 = 0.5e1 / 0.972e3 * t346 + 0.3e1 * t348 * t349 - t206 * t358 + t80 * t362;
  t368 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t364);
  tvsigma0 = t7 * t368;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t369 = t34 * t107;
  t370 = t281 * t369;
  t372 = t290 * t151;
  t373 = t291 * t107;
  t376 = t299 * t107;
  t378 = t140 * t107;
  t379 = t316 * t378;
  t381 = -0.3e1 * t376 - 0.48e2 * t379;
  t382 = t151 * t381;
  t386 = 0.5e1 / 0.972e3 * t331 * t369 - 0.5e1 / 0.972e3 * t370;
  t388 = 0.5e1 / 0.972e3 * t370 + 0.3e1 * t372 * t373 - t308 * t382 + t145 * t386;
  t392 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t388);
  tvsigma2 = t7 * t392;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t394 = t197 * t49;
  t396 = -0.8e1 * t189 * t49 + 0.8e1 * t394;
  t397 = t86 * t396;
  t403 = t75 * t49;
  t406 = t219 * t49;
  t409 = -0.24e2 * t210 * t49 + 0.384e3 * t214 * t403 - 0.384e3 * t72 * t406 + 0.24e2 * t394;
  t410 = t86 * t409;
  t412 = 0.3e1 * t188 * t397 - t206 * t410;
  t416 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t412);
  tvtau0 = t7 * t416;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t418 = t299 * t117;
  t420 = -0.8e1 * t291 * t117 + 0.8e1 * t418;
  t421 = t151 * t420;
  t427 = t140 * t117;
  t430 = t321 * t117;
  t433 = -0.24e2 * t312 * t117 - 0.384e3 * t137 * t430 + 0.384e3 * t316 * t427 + 0.24e2 * t418;
  t434 = t151 * t433;
  t436 = 0.3e1 * t290 * t421 - t308 * t434;
  t440 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t436);
  tvtau1 = t7 * t440;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t443 = t24 * t24;
  t444 = 0.1e1 / t443;
  t445 = t162 * t162;
  t448 = t158 * t7;
  t449 = 0.1e1 / t448;
  t450 = t17 * t449;
  t453 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t159 + 0.2e1 * t450);
  t457 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t445 + 0.4e1 / 0.3e1 * t24 * t453);
  t458 = t457 * t27;
  t462 = t165 * t171;
  t464 = t6 * t462 * t88;
  t470 = 0.1e1 / t170 / t7;
  t471 = t26 * t470;
  t474 = t6 * t471 * t88 / 0.12e2;
  t476 = t6 * t172 * t235;
  t480 = t176 / t177 / t43;
  t481 = t480 * t54;
  t483 = 0.1e1 / t31 / t30;
  t484 = sigma[0] * sigma[0];
  t485 = t483 * t484;
  t486 = t35 * t35;
  t487 = t486 * t182;
  t489 = 0.1e1 / t36 / t487;
  t490 = t485 * t489;
  t492 = 0.2e3 / 0.531441e6 * t481 * t490;
  t494 = 0.1e1 / t37 / t486;
  t495 = t181 * t494;
  t497 = 0.11e3 / 0.2187e4 * t180 * t495;
  t498 = t62 * t79;
  t499 = t200 * t200;
  t500 = t86 * t499;
  t503 = t63 * t205;
  t507 = t233 * t200;
  t510 = t194 * t194;
  t513 = t52 * t67;
  t514 = t194 * tau[0];
  t515 = t514 * t39;
  t518 = tau[0] * t184;
  t522 = 0.4e2 / 0.9e1 * t518 - 0.11e2 / 0.9e1 * sigma[0] * t494;
  t525 = t53 * t209;
  t526 = tau[0] * tau[0];
  t527 = t486 * rho[0];
  t529 = 0.1e1 / t36 / t527;
  t530 = t526 * t529;
  t535 = -0.8e1 * t510 * t59 - 0.16e3 / 0.3e1 * t513 * t515 - 0.8e1 * t189 * t522 - 0.2e3 / 0.3e1 * t525 * t530 + 0.32e3 / 0.9e1 * t197 * t518;
  t536 = t86 * t535;
  t540 = 0.1e1 / t204 / t78;
  t541 = t64 * t540;
  t542 = t224 * t224;
  t543 = t86 * t542;
  t546 = t233 * t224;
  t556 = 0.1e1 / t73 / t57;
  t557 = t65 * t556;
  t562 = params->b * t70;
  t563 = t75 * t510;
  t566 = t214 * t219;
  t572 = t73 * t73;
  t573 = 0.1e1 / t572;
  t574 = t573 * t526;
  t581 = 0.48e2 * t513 * t510 + 0.24e3 * t525 * t515 + 0.24e2 * t197 * t522 + 0.8e3 / 0.3e1 * t557 * t530 - 0.32e3 / 0.3e1 * t210 * t518 + 0.192e4 * t562 * t563 + 0.768e4 * t566 * t515 + 0.384e3 * t214 * t75 * t522 + 0.224e5 / 0.3e1 * t72 * t574 * t529 - 0.512e4 / 0.3e1 * t72 * t220 * t184;
  t586 = t176 / t227 / t81;
  t587 = t586 * t54;
  t592 = -0.2e3 / 0.531441e6 * t587 * t490 + 0.11e3 / 0.2187e4 * t230 * t495 + t492 - t497;
  t594 = -0.6e1 * t503 * t201 * t224 - t206 * t86 * t581 + 0.6e1 * t188 * t507 + 0.3e1 * t188 * t536 - 0.2e1 * t206 * t546 + 0.6e1 * t498 * t500 + 0.2e1 * t541 * t543 + t80 * t592 - t492 + t497;
  t599 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t88 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t235 + t474 - t476 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t594);
  t600 = t99 * t99;
  t601 = 0.1e1 / t600;
  t602 = t243 * t243;
  t605 = t94 * t449;
  t608 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t159 + 0.2e1 * t605);
  t612 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t602 + 0.4e1 / 0.3e1 * t99 * t608);
  t613 = t612 * t27;
  t617 = t246 * t171;
  t619 = t6 * t617 * t153;
  t621 = t101 * t470;
  t624 = t6 * t621 * t153 / 0.12e2;
  t626 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t153 - t619 / 0.4e1 + t624);
  tv2rho20 = 0.2e1 * t240 + 0.2e1 * t256 + t7 * (t599 + t626);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t629 = t444 * t260;
  t633 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t450);
  t637 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t629 * t162 + 0.4e1 / 0.3e1 * t24 * t633);
  t638 = t637 * t27;
  t642 = t263 * t171;
  t644 = t6 * t642 * t88;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t88 - t644 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t235 - t464 / 0.8e1 + t474 - t476 / 0.8e1);
  t653 = t601 * t271;
  t657 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t605);
  t661 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t653 * t243 + 0.4e1 / 0.3e1 * t99 * t657);
  t662 = t661 * t27;
  t666 = t274 * t171;
  t668 = t6 * t666 * t153;
  t675 = t6 * t251 * t337;
  t678 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t153 - t668 / 0.8e1 - t619 / 0.8e1 + t624 - 0.3e1 / 0.8e1 * t6 * t247 * t337 - t675 / 0.8e1);
  tv2rho21 = t240 + t256 + t269 + t342 + t7 * (t652 + t678);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t683 = t260 * t260;
  t688 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t159 + 0.2e1 * t450);
  t692 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t683 + 0.4e1 / 0.3e1 * t24 * t688);
  t693 = t692 * t27;
  t699 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t88 - t644 / 0.4e1 + t474);
  t700 = t271 * t271;
  t705 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t159 + 0.2e1 * t605);
  t709 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t700 + 0.4e1 / 0.3e1 * t99 * t705);
  t710 = t709 * t27;
  t721 = t176 / t279 / t111;
  t722 = t721 * t54;
  t723 = sigma[2] * sigma[2];
  t724 = t483 * t723;
  t725 = t103 * t103;
  t726 = t725 * t284;
  t728 = 0.1e1 / t104 / t726;
  t729 = t724 * t728;
  t731 = 0.2e3 / 0.531441e6 * t722 * t729;
  t733 = 0.1e1 / t105 / t725;
  t734 = t283 * t733;
  t736 = 0.11e3 / 0.2187e4 * t282 * t734;
  t737 = t127 * t144;
  t738 = t302 * t302;
  t739 = t151 * t738;
  t742 = t128 * t307;
  t746 = t335 * t302;
  t749 = t296 * t296;
  t752 = t120 * t132;
  t753 = t296 * tau[1];
  t754 = t753 * t107;
  t757 = tau[1] * t286;
  t761 = 0.4e2 / 0.9e1 * t757 - 0.11e2 / 0.9e1 * sigma[2] * t733;
  t764 = t121 * t311;
  t765 = tau[1] * tau[1];
  t766 = t725 * rho[1];
  t768 = 0.1e1 / t104 / t766;
  t769 = t765 * t768;
  t774 = -0.8e1 * t749 * t124 - 0.16e3 / 0.3e1 * t752 * t754 - 0.8e1 * t291 * t761 - 0.2e3 / 0.3e1 * t764 * t769 + 0.32e3 / 0.9e1 * t299 * t757;
  t775 = t151 * t774;
  t779 = 0.1e1 / t306 / t143;
  t780 = t129 * t779;
  t781 = t326 * t326;
  t782 = t151 * t781;
  t785 = t335 * t326;
  t795 = 0.1e1 / t138 / t122;
  t796 = t130 * t795;
  t801 = params->b * t135;
  t802 = t140 * t749;
  t805 = t316 * t321;
  t811 = t138 * t138;
  t812 = 0.1e1 / t811;
  t813 = t812 * t765;
  t820 = 0.48e2 * t752 * t749 + 0.24e3 * t764 * t754 + 0.24e2 * t299 * t761 + 0.8e3 / 0.3e1 * t796 * t769 - 0.32e3 / 0.3e1 * t312 * t757 + 0.192e4 * t801 * t802 + 0.768e4 * t805 * t754 + 0.384e3 * t316 * t140 * t761 + 0.224e5 / 0.3e1 * t137 * t813 * t768 - 0.512e4 / 0.3e1 * t137 * t322 * t286;
  t825 = t176 / t329 / t146;
  t826 = t825 * t54;
  t831 = -0.2e3 / 0.531441e6 * t826 * t729 + 0.11e3 / 0.2187e4 * t332 * t734 + t731 - t736;
  t833 = -t308 * t151 * t820 - 0.6e1 * t742 * t303 * t326 + t145 * t831 + 0.6e1 * t290 * t746 + 0.3e1 * t290 * t775 - 0.2e1 * t308 * t785 + 0.6e1 * t737 * t739 + 0.2e1 * t780 * t782 - t731 + t736;
  t838 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t153 - t668 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t337 + t624 - t675 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t833);
  tv2rho22 = 0.2e1 * t269 + 0.2e1 * t342 + t7 * (t699 + t838);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t846 = t6 * t172 * t364 / 0.8e1;
  t847 = t486 * t35;
  t849 = 0.1e1 / t36 / t847;
  t851 = t483 * t849 * sigma[0];
  t853 = 0.25e2 / 0.177147e6 * t481 * t851;
  t854 = t34 * t184;
  t856 = 0.1e2 / 0.729e3 * t179 * t854;
  t857 = t498 * t86;
  t858 = t39 * t200;
  t859 = t189 * t858;
  t862 = t503 * t86;
  t863 = t39 * t224;
  t864 = t189 * t863;
  t867 = t188 * t233;
  t870 = t194 * t59;
  t871 = t870 * t39;
  t874 = t529 * tau[0];
  t875 = t513 * t874;
  t878 = t189 * t184;
  t887 = t233 * t357;
  t889 = t39 * t194;
  t890 = t513 * t889;
  t892 = t525 * t874;
  t894 = t197 * t184;
  t897 = t562 * t354 * t194;
  t899 = t219 * t529;
  t901 = t214 * t899 * tau[0];
  t903 = t75 * t184;
  t904 = t214 * t903;
  t906 = -0.6e1 * t890 - 0.15e2 * t892 + 0.8e1 * t894 - 0.24e3 * t897 - 0.48e3 * t901 + 0.128e3 * t904;
  t907 = t86 * t906;
  t909 = t362 * t200;
  t918 = 0.25e2 / 0.177147e6 * t587 * t851 - 0.1e2 / 0.729e3 * t229 * t854 - t853 + t856;
  t920 = -0.3e1 * t503 * t358 * t200 - t206 * t362 * t224 + 0.2e1 * t541 * t358 * t224 + 0.3e1 * t188 * t909 - t206 * t887 - t206 * t907 + 0.3e1 * t348 * t871 + 0.1e2 * t348 * t875 - 0.8e1 * t348 * t878 + 0.3e1 * t867 * t349 + t80 * t918 + 0.6e1 * t857 * t859 - 0.3e1 * t862 * t864 + t853 - t856;
  t925 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t364 - t846 - 0.3e1 / 0.8e1 * t6 * t28 * t920);
  tv2rhosigma0 = t7 * t925 + t368;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t932 = t6 * t251 * t388 / 0.8e1;
  t934 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t388 - t932);
  tv2rhosigma2 = t7 * t934 + t392;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t940 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t364 - t846);
  tv2rhosigma3 = t7 * t940 + t368;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t945 = t725 * t103;
  t947 = 0.1e1 / t104 / t945;
  t949 = t483 * t947 * sigma[2];
  t951 = 0.25e2 / 0.177147e6 * t722 * t949;
  t952 = t34 * t286;
  t954 = 0.1e2 / 0.729e3 * t281 * t952;
  t955 = t737 * t151;
  t956 = t107 * t302;
  t957 = t291 * t956;
  t960 = t742 * t151;
  t961 = t107 * t326;
  t962 = t291 * t961;
  t965 = t290 * t335;
  t968 = t296 * t124;
  t969 = t968 * t107;
  t972 = t768 * tau[1];
  t973 = t752 * t972;
  t976 = t291 * t286;
  t985 = t335 * t381;
  t987 = t107 * t296;
  t988 = t752 * t987;
  t990 = t764 * t972;
  t992 = t299 * t286;
  t995 = t801 * t378 * t296;
  t997 = t321 * t768;
  t999 = t316 * t997 * tau[1];
  t1001 = t140 * t286;
  t1002 = t316 * t1001;
  t1004 = -0.6e1 * t988 - 0.15e2 * t990 + 0.8e1 * t992 - 0.24e3 * t995 - 0.48e3 * t999 + 0.128e3 * t1002;
  t1005 = t151 * t1004;
  t1007 = t386 * t302;
  t1016 = 0.25e2 / 0.177147e6 * t826 * t949 - 0.1e2 / 0.729e3 * t331 * t952 - t951 + t954;
  t1018 = -0.3e1 * t742 * t382 * t302 - t308 * t386 * t326 + 0.2e1 * t780 * t382 * t326 - t308 * t1005 + 0.3e1 * t290 * t1007 + t145 * t1016 - t308 * t985 + 0.3e1 * t372 * t969 + 0.1e2 * t372 * t973 - 0.8e1 * t372 * t976 + 0.3e1 * t965 * t373 + 0.6e1 * t955 * t957 - 0.3e1 * t960 * t962 + t951 - t954;
  t1023 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t388 - t932 - 0.3e1 / 0.8e1 * t6 * t102 * t1018);
  tv2rhosigma5 = t7 * t1023 + t392;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1030 = t6 * t172 * t412 / 0.8e1;
  t1034 = t397 * t224;
  t1037 = t233 * t396;
  t1043 = 0.1e1 / t36 / t486;
  t1044 = t1043 * tau[0];
  t1048 = t49 * t194;
  t1049 = t513 * t1048;
  t1051 = t525 * t1044;
  t1054 = -0.8e1 * t870 * t49 - 0.8e2 / 0.3e1 * t513 * t1044 + 0.4e2 / 0.3e1 * t349 + 0.16e2 * t1049 + 0.4e2 * t1051 - 0.4e2 / 0.3e1 * t352;
  t1055 = t86 * t1054;
  t1064 = t233 * t409;
  t1078 = t219 * t1043;
  t1086 = t573 * t1043;
  t1090 = t219 * t39;
  t1093 = 0.384e4 * t214 * t1078 * tau[0] - 0.448e4 * t72 * t1086 * tau[0] - 0.2304e4 * t214 * t406 * t194 + 0.192e4 * t562 * t403 * t194 - 0.16e3 * t557 * t1044 - 0.72e2 * t525 * t1048 + 0.64e3 * t72 * t1090 + 0.4e2 * t210 * t39 + 0.48e2 * t1049 + 0.12e3 * t1051 - 0.4e2 * t352 - 0.64e3 * t355;
  t1094 = t86 * t1093;
  t1096 = 0.6e1 * t498 * t397 * t200 - 0.3e1 * t503 * t410 * t200 + 0.2e1 * t541 * t410 * t224 - 0.3e1 * t503 * t1034 + 0.3e1 * t188 * t1037 + 0.3e1 * t188 * t1055 - t206 * t1064 - t206 * t1094;
  t1101 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t412 - t1030 - 0.3e1 / 0.8e1 * t6 * t28 * t1096);
  tv2rhotau0 = t7 * t1101 + t416;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1108 = t6 * t251 * t436 / 0.8e1;
  t1110 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t436 - t1108);
  tv2rhotau1 = t7 * t1110 + t440;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t412 - t1030);
  tv2rhotau2 = t7 * t1116 + t416;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1124 = t421 * t326;
  t1127 = t335 * t420;
  t1133 = 0.1e1 / t104 / t725;
  t1134 = t1133 * tau[1];
  t1138 = t117 * t296;
  t1139 = t752 * t1138;
  t1141 = t764 * t1134;
  t1144 = -0.8e1 * t968 * t117 - 0.8e2 / 0.3e1 * t752 * t1134 + 0.4e2 / 0.3e1 * t373 + 0.16e2 * t1139 + 0.4e2 * t1141 - 0.4e2 / 0.3e1 * t376;
  t1145 = t151 * t1144;
  t1154 = t335 * t433;
  t1168 = t321 * t1133;
  t1176 = t812 * t1133;
  t1180 = t321 * t107;
  t1183 = 0.384e4 * t316 * t1168 * tau[1] - 0.448e4 * t137 * t1176 * tau[1] - 0.2304e4 * t316 * t430 * t296 + 0.192e4 * t801 * t427 * t296 + 0.4e2 * t312 * t107 - 0.16e3 * t796 * t1134 - 0.72e2 * t764 * t1138 + 0.64e3 * t137 * t1180 + 0.48e2 * t1139 + 0.12e3 * t1141 - 0.4e2 * t376 - 0.64e3 * t379;
  t1184 = t151 * t1183;
  t1186 = 0.6e1 * t737 * t421 * t302 - 0.3e1 * t742 * t434 * t302 + 0.2e1 * t780 * t434 * t326 - 0.3e1 * t742 * t1124 + 0.3e1 * t290 * t1127 + 0.3e1 * t290 * t1145 - t308 * t1154 - t308 * t1184;
  t1191 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t436 - t1108 - 0.3e1 / 0.8e1 * t6 * t102 * t1186);
  tv2rhotau3 = t7 * t1191 + t440;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1193 = t54 * t483;
  t1194 = t1193 * t529;
  t1195 = t480 * t1194;
  t1197 = t525 * t529;
  t1200 = t39 * t357;
  t1201 = t189 * t1200;
  t1204 = t188 * t362;
  t1208 = t86 * t529 * t59;
  t1211 = t357 * t357;
  t1212 = t86 * t1211;
  t1215 = t362 * t357;
  t1218 = t513 * t529;
  t1220 = t75 * t529;
  t1221 = t562 * t1220;
  t1223 = 0.3e1 / 0.4e1 * t1218 + 0.3e2 * t1221;
  t1224 = t86 * t1223;
  t1228 = -0.25e2 / 0.472392e6 * t586 * t1194 + 0.25e2 / 0.472392e6 * t1195;
  t1230 = -0.25e2 / 0.472392e6 * t1195 + 0.6e1 * t857 * t1197 - 0.6e1 * t862 * t1201 + 0.6e1 * t1204 * t349 - 0.3e1 / 0.8e1 * t188 * t1208 + 0.2e1 * t541 * t1212 - 0.2e1 * t206 * t1215 - t206 * t1224 + t80 * t1228;
  t1234 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1230);
  tv2sigma20 = t7 * t1234;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1235 = t1193 * t768;
  t1236 = t721 * t1235;
  t1238 = t764 * t768;
  t1241 = t107 * t381;
  t1242 = t291 * t1241;
  t1245 = t290 * t386;
  t1249 = t151 * t768 * t124;
  t1252 = t381 * t381;
  t1253 = t151 * t1252;
  t1256 = t386 * t381;
  t1259 = t752 * t768;
  t1261 = t140 * t768;
  t1262 = t801 * t1261;
  t1264 = 0.3e1 / 0.4e1 * t1259 + 0.3e2 * t1262;
  t1265 = t151 * t1264;
  t1269 = -0.25e2 / 0.472392e6 * t825 * t1235 + 0.25e2 / 0.472392e6 * t1236;
  t1271 = -0.25e2 / 0.472392e6 * t1236 + 0.6e1 * t955 * t1238 - 0.6e1 * t960 * t1242 + 0.6e1 * t1245 * t373 - 0.3e1 / 0.8e1 * t290 * t1249 + 0.2e1 * t780 * t1253 - 0.2e1 * t308 * t1256 - t308 * t1265 + t145 * t1269;
  t1275 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1271);
  tv2sigma25 = t7 * t1275;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1276 = t396 * t52;
  t1277 = t59 * t39;
  t1278 = t1276 * t1277;
  t1281 = t397 * t357;
  t1284 = t362 * t396;
  t1287 = t1043 * t59;
  t1288 = t513 * t1043;
  t1290 = t1287 - 0.2e1 * t1288;
  t1291 = t86 * t1290;
  t1294 = t409 * t52;
  t1295 = t1294 * t1277;
  t1301 = t362 * t409;
  t1304 = t525 * t1043;
  t1306 = t75 * t1043;
  t1307 = t562 * t1306;
  t1309 = t214 * t1078;
  t1311 = -0.6e1 * t1288 + 0.9e1 * t1304 - 0.24e3 * t1307 + 0.288e3 * t1309;
  t1312 = t86 * t1311;
  t1314 = 0.2e1 * t541 * t410 * t357 + 0.6e1 * t857 * t1278 - 0.3e1 * t503 * t1281 + 0.3e1 * t188 * t1284 + 0.3e1 * t188 * t1291 - 0.3e1 * t862 * t1295 - t206 * t1301 - t206 * t1312;
  t1318 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1314);
  tv2sigmatau0 = t7 * t1318;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1319 = t420 * t120;
  t1320 = t124 * t107;
  t1321 = t1319 * t1320;
  t1324 = t421 * t381;
  t1327 = t386 * t420;
  t1330 = t1133 * t124;
  t1331 = t752 * t1133;
  t1333 = t1330 - 0.2e1 * t1331;
  t1334 = t151 * t1333;
  t1337 = t433 * t120;
  t1338 = t1337 * t1320;
  t1344 = t386 * t433;
  t1347 = t764 * t1133;
  t1349 = t140 * t1133;
  t1350 = t801 * t1349;
  t1352 = t316 * t1168;
  t1354 = -0.6e1 * t1331 + 0.9e1 * t1347 - 0.24e3 * t1350 + 0.288e3 * t1352;
  t1355 = t151 * t1354;
  t1357 = 0.2e1 * t780 * t434 * t381 + 0.6e1 * t955 * t1321 - 0.3e1 * t742 * t1324 + 0.3e1 * t290 * t1327 + 0.3e1 * t290 * t1334 - 0.3e1 * t960 * t1338 - t308 * t1344 - t308 * t1355;
  t1361 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1357);
  tv2sigmatau5 = t7 * t1361;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1362 = t396 * t396;
  t1363 = t86 * t1362;
  t1366 = t397 * t409;
  t1370 = 0.1e1 / t36 / t182;
  t1373 = t513 * t1370;
  t1375 = t525 * t1370;
  t1377 = -0.8e1 * t1370 * t59 + 0.32e2 * t1373 - 0.24e2 * t1375;
  t1378 = t86 * t1377;
  t1381 = t409 * t409;
  t1382 = t86 * t1381;
  t1389 = t75 * t1370;
  t1392 = t219 * t1370;
  t1395 = t573 * t1370;
  t1398 = 0.96e2 * t557 * t1370 + 0.192e4 * t562 * t1389 - 0.4608e4 * t214 * t1392 + 0.2688e4 * t72 * t1395 + 0.48e2 * t1373 - 0.144e3 * t1375;
  t1399 = t86 * t1398;
  t1401 = 0.6e1 * t498 * t1363 - 0.6e1 * t503 * t1366 + 0.3e1 * t188 * t1378 + 0.2e1 * t541 * t1382 - t206 * t1399;
  t1405 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1401);
  tv2tau20 = t7 * t1405;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1406 = t420 * t420;
  t1407 = t151 * t1406;
  t1410 = t421 * t433;
  t1414 = 0.1e1 / t104 / t284;
  t1417 = t752 * t1414;
  t1419 = t764 * t1414;
  t1421 = -0.8e1 * t1414 * t124 + 0.32e2 * t1417 - 0.24e2 * t1419;
  t1422 = t151 * t1421;
  t1425 = t433 * t433;
  t1426 = t151 * t1425;
  t1433 = t140 * t1414;
  t1436 = t321 * t1414;
  t1439 = t812 * t1414;
  t1442 = 0.2688e4 * t137 * t1439 + 0.96e2 * t796 * t1414 + 0.192e4 * t801 * t1433 - 0.4608e4 * t316 * t1436 + 0.48e2 * t1417 - 0.144e3 * t1419;
  t1443 = t151 * t1442;
  t1445 = 0.6e1 * t737 * t1407 - 0.6e1 * t742 * t1410 + 0.3e1 * t290 * t1422 + 0.2e1 * t780 * t1426 - t308 * t1443;
  t1449 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1445);
  tv2tau22 = t7 * t1449;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1453 = 0.1e1 / t443 / t20;
  t1454 = t445 * t162;
  t1457 = t444 * t162;
  t1460 = t158 * t158;
  t1461 = 0.1e1 / t1460;
  t1462 = t17 * t1461;
  t1465 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t449 - 0.6e1 * t1462);
  t1469 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1453 * t1454 + 0.4e1 / 0.3e1 * t1457 * t453 + 0.4e1 / 0.3e1 * t24 * t1465);
  t1470 = t1469 * t27;
  t1474 = t457 * t171;
  t1476 = t6 * t1474 * t88;
  t1481 = t165 * t470;
  t1483 = t6 * t1481 * t88;
  t1486 = t6 * t462 * t235;
  t1492 = 0.1e1 / t170 / t158;
  t1493 = t26 * t1492;
  t1496 = 0.5e1 / 0.36e2 * t6 * t1493 * t88;
  t1498 = t6 * t471 * t235;
  t1501 = t6 * t172 * t594;
  t1503 = t204 * t204;
  t1504 = 0.1e1 / t1503;
  t1505 = t64 * t1504;
  t1506 = t542 * t224;
  t1507 = t86 * t1506;
  t1513 = t177 * t177;
  t1515 = t176 / t1513;
  t1516 = t30 * t30;
  t1517 = 0.1e1 / t1516;
  t1518 = t484 * sigma[0];
  t1519 = t1517 * t1518;
  t1520 = t486 * t486;
  t1521 = t1520 * t182;
  t1522 = 0.1e1 / t1521;
  t1523 = t1519 * t1522;
  t1525 = 0.4e4 / 0.43046721e8 * t1515 * t1523;
  t1526 = t62 * t205;
  t1542 = t63 * t540;
  t1546 = t592 * t200;
  t1550 = t233 * t535;
  t1555 = t510 * t67;
  t1558 = t52 * t209;
  t1559 = t194 * t526;
  t1560 = t1559 * t529;
  t1563 = t522 * tau[0];
  t1564 = t1563 * t39;
  t1567 = t514 * t184;
  t1570 = tau[0] * t494;
  t1573 = 0.1e1 / t37 / t527;
  t1576 = -0.44e3 / 0.27e2 * t1570 + 0.154e3 / 0.27e2 * sigma[0] * t1573;
  t1579 = t53 * t556;
  t1580 = t526 * tau[0];
  t1581 = 0.1e1 / t1520;
  t1582 = t1580 * t1581;
  t1585 = t526 * t849;
  t1590 = -0.24e2 * t870 * t522 - 0.8e2 * t1555 * t190 - 0.4e3 * t1558 * t1560 - 0.8e2 * t513 * t1564 + 0.64e3 / 0.3e1 * t513 * t1567 - 0.8e1 * t189 * t1576 - 0.4e4 / 0.9e1 * t1579 * t1582 + 0.16e4 / 0.3e1 * t525 * t1585 - 0.352e4 / 0.27e2 * t197 * t1570;
  t1591 = t86 * t1590;
  t1604 = 0.1e1 / t572 / t57;
  t1605 = t1604 * t1580;
  t1609 = t510 * tau[0];
  t1610 = t1609 * t39;
  t1621 = params->b * t65;
  t1622 = t510 * t194;
  t1629 = t562 * t219;
  t1634 = t214 * t573;
  t1645 = t194 * t522;
  t1648 = t65 * t75;
  t1660 = 0.896e6 / 0.9e1 * t72 * t1605 * t1581 + 0.72e3 * t1558 * t1610 + 0.36e3 * t525 * t1564 + 0.24e4 * t1579 * t1560 - 0.64e4 / 0.3e1 * t557 * t1585 + 0.352e4 / 0.9e1 * t210 * t1570 + 0.768e4 * t1621 * t75 * t1622 + 0.576e4 * t562 * t215 * t522 + 0.576e5 * t1629 * t1610 + 0.1152e5 * t566 * t1564 + 0.1344e6 * t1634 * t1560 - 0.1792e6 / 0.3e1 * t72 * t574 * t849 + 0.5632e5 / 0.9e1 * t72 * t220 * t494 - 0.96e3 * t525 * t1567 + 0.144e3 * t513 * t1645 + 0.2e5 / 0.9e1 * t1648 * t1582 + 0.384e3 * t214 * t75 * t1576 - 0.3072e5 * t566 * t1567 + 0.48e2 * t1622 * t67 + 0.24e2 * t197 * t1576;
  t1663 = t499 * t200;
  t1664 = t1663 * t79;
  t1667 = t233 * t499;
  t1670 = t181 * t1573;
  t1672 = 0.154e4 / 0.6561e4 * t180 * t1670;
  t1674 = 0.1e1 / t36 / t1520;
  t1675 = t485 * t1674;
  t1677 = 0.22e4 / 0.531441e6 * t481 * t1675;
  t1678 = t227 * t227;
  t1680 = t176 / t1678;
  t1687 = -0.4e4 / 0.43046721e8 * t1680 * t1523 + 0.22e4 / 0.531441e6 * t587 * t1675 - 0.154e4 / 0.6561e4 * t230 * t1670 + t1525 - t1677 + t1672;
  t1689 = -t206 * t86 * t1660 - 0.3e1 * t206 * t592 * t224 - 0.3e1 * t206 * t233 * t581 + 0.6e1 * t541 * t233 * t542 + 0.9e1 * t188 * t1550 + 0.3e1 * t188 * t1591 + 0.6e1 * t1664 * t86 + 0.18e2 * t498 * t1667 + t80 * t1687 - t1672 + t1677;
  t1690 = -0.18e2 * t1526 * t500 * t224 + 0.18e2 * t1542 * t201 * t542 + 0.18e2 * t498 * t201 * t535 - 0.9e1 * t503 * t201 * t581 - 0.18e2 * t503 * t507 * t224 - 0.9e1 * t503 * t536 * t224 + 0.6e1 * t541 * t225 * t581 - 0.6e1 * t1505 * t1507 + 0.9e1 * t188 * t1546 - t1525 + t1689;
  t1695 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1470 * t88 - 0.3e1 / 0.8e1 * t1476 - 0.9e1 / 0.8e1 * t6 * t458 * t235 + t1483 / 0.4e1 - 0.3e1 / 0.4e1 * t1486 - 0.9e1 / 0.8e1 * t6 * t166 * t594 - t1496 + t1498 / 0.4e1 - 0.3e1 / 0.8e1 * t1501 - 0.3e1 / 0.8e1 * t6 * t28 * t1690);
  t1697 = 0.1e1 / t600 / t97;
  t1698 = t602 * t243;
  t1701 = t601 * t243;
  t1704 = t94 * t1461;
  t1707 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t449 - 0.6e1 * t1704);
  t1711 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1697 * t1698 + 0.4e1 / 0.3e1 * t1701 * t608 + 0.4e1 / 0.3e1 * t99 * t1707);
  t1712 = t1711 * t27;
  t1716 = t612 * t171;
  t1718 = t6 * t1716 * t153;
  t1720 = t246 * t470;
  t1722 = t6 * t1720 * t153;
  t1724 = t101 * t1492;
  t1727 = 0.5e1 / 0.36e2 * t6 * t1724 * t153;
  t1729 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1712 * t153 - 0.3e1 / 0.8e1 * t1718 + t1722 / 0.4e1 - t1727);
  tv3rho30 = 0.3e1 * t599 + 0.3e1 * t626 + t7 * (t1695 + t1729);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1732 = 0.2e1 * t652;
  t1733 = 0.2e1 * t678;
  t1734 = t1453 * t260;
  t1737 = t444 * t633;
  t1742 = 0.2e1 * t449;
  t1743 = 0.6e1 * t1462;
  t1745 = my_piecewise5(t11, 0, t15, 0, t1742 - t1743);
  t1749 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1734 * t445 + 0.8e1 / 0.9e1 * t1737 * t162 + 0.4e1 / 0.9e1 * t629 * t453 + 0.4e1 / 0.3e1 * t24 * t1745);
  t1750 = t1749 * t27;
  t1754 = t637 * t171;
  t1757 = t6 * t1754 * t88 / 0.4e1;
  t1761 = t263 * t470;
  t1763 = t6 * t1761 * t88;
  t1767 = t6 * t642 * t235 / 0.4e1;
  t1776 = -0.3e1 / 0.8e1 * t6 * t1750 * t88 - t1757 - 0.3e1 / 0.4e1 * t6 * t638 * t235 + t1763 / 0.12e2 - t1767 - 0.3e1 / 0.8e1 * t6 * t264 * t594 - t1476 / 0.8e1 + t1483 / 0.6e1 - t1486 / 0.4e1 - t1496 + t1498 / 0.6e1 - t1501 / 0.8e1;
  t1777 = my_piecewise3(t2, 0, t1776);
  t1778 = t1697 * t271;
  t1781 = t601 * t657;
  t1786 = 0.6e1 * t1704;
  t1788 = my_piecewise5(t15, 0, t11, 0, -t1742 - t1786);
  t1792 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1778 * t602 + 0.8e1 / 0.9e1 * t1781 * t243 + 0.4e1 / 0.9e1 * t653 * t608 + 0.4e1 / 0.3e1 * t99 * t1788);
  t1793 = t1792 * t27;
  t1797 = t661 * t171;
  t1800 = t6 * t1797 * t153 / 0.4e1;
  t1801 = t274 * t470;
  t1803 = t6 * t1801 * t153;
  t1812 = t6 * t617 * t337 / 0.4e1;
  t1814 = t6 * t621 * t337;
  t1817 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1793 * t153 - t1800 + t1803 / 0.12e2 - t1718 / 0.8e1 + t1722 / 0.6e1 - t1727 - 0.3e1 / 0.8e1 * t6 * t613 * t337 - t1812 + t1814 / 0.12e2);
  tv3rho31 = t599 + t626 + t1732 + t1733 + t7 * (t1777 + t1817);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1820 = t1453 * t683;
  t1825 = t444 * t688;
  t1829 = my_piecewise5(t11, 0, t15, 0, -t1742 - t1743);
  t1833 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1820 * t162 + 0.8e1 / 0.9e1 * t629 * t633 + 0.4e1 / 0.9e1 * t1825 * t162 + 0.4e1 / 0.3e1 * t24 * t1829);
  t1834 = t1833 * t27;
  t1838 = t692 * t171;
  t1840 = t6 * t1838 * t88;
  t1849 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1834 * t88 - t1840 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t693 * t235 - t1757 + t1763 / 0.6e1 - t1767 + t1483 / 0.12e2 - t1496 + t1498 / 0.12e2);
  t1850 = t1697 * t700;
  t1855 = t601 * t705;
  t1859 = my_piecewise5(t15, 0, t11, 0, t1742 - t1786);
  t1863 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1850 * t243 + 0.8e1 / 0.9e1 * t653 * t657 + 0.4e1 / 0.9e1 * t1855 * t243 + 0.4e1 / 0.3e1 * t99 * t1859);
  t1864 = t1863 * t27;
  t1868 = t709 * t171;
  t1870 = t6 * t1868 * t153;
  t1877 = t6 * t666 * t337;
  t1885 = t6 * t251 * t833;
  t1887 = -0.3e1 / 0.8e1 * t6 * t1864 * t153 - t1870 / 0.8e1 - t1800 + t1803 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t662 * t337 - t1877 / 0.4e1 + t1722 / 0.12e2 - t1727 - t1812 + t1814 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t247 * t833 - t1885 / 0.8e1;
  t1888 = my_piecewise3(t93, 0, t1887);
  tv3rho32 = t1732 + t1733 + t699 + t838 + t7 * (t1849 + t1888);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1893 = t683 * t260;
  t1900 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t449 - 0.6e1 * t1462);
  t1904 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1453 * t1893 + 0.4e1 / 0.3e1 * t629 * t688 + 0.4e1 / 0.3e1 * t24 * t1900);
  t1905 = t1904 * t27;
  t1912 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1905 * t88 - 0.3e1 / 0.8e1 * t1840 + t1763 / 0.4e1 - t1496);
  t1913 = t700 * t271;
  t1920 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t449 - 0.6e1 * t1704);
  t1924 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1697 * t1913 + 0.4e1 / 0.3e1 * t653 * t705 + 0.4e1 / 0.3e1 * t99 * t1920);
  t1925 = t1924 * t27;
  t1940 = t127 * t307;
  t1956 = t306 * t306;
  t1957 = 0.1e1 / t1956;
  t1958 = t129 * t1957;
  t1959 = t781 * t326;
  t1960 = t151 * t1959;
  t1966 = t279 * t279;
  t1968 = t176 / t1966;
  t1969 = t723 * sigma[2];
  t1970 = t1517 * t1969;
  t1971 = t725 * t725;
  t1972 = t1971 * t284;
  t1973 = 0.1e1 / t1972;
  t1974 = t1970 * t1973;
  t1976 = 0.4e4 / 0.43046721e8 * t1968 * t1974;
  t1977 = t128 * t779;
  t1991 = tau[1] * t733;
  t1994 = params->b * t130;
  t1995 = t749 * t296;
  t2003 = 0.1e1 / t811 / t122;
  t2004 = t765 * tau[1];
  t2005 = t2003 * t2004;
  t2006 = 0.1e1 / t1971;
  t2010 = t120 * t311;
  t2011 = t749 * tau[1];
  t2012 = t2011 * t107;
  t2015 = t761 * tau[1];
  t2016 = t2015 * t107;
  t2019 = t121 * t795;
  t2020 = t296 * t765;
  t2021 = t2020 * t768;
  t2024 = t765 * t947;
  t2027 = t801 * t321;
  t2032 = t316 * t812;
  t2041 = t753 * t286;
  t2044 = t296 * t761;
  t2047 = t130 * t140;
  t2048 = t2004 * t2006;
  t2053 = 0.1e1 / t105 / t766;
  t2056 = -0.44e3 / 0.27e2 * t1991 + 0.154e3 / 0.27e2 * sigma[2] * t2053;
  t2066 = 0.352e4 / 0.9e1 * t312 * t1991 + 0.768e4 * t1994 * t140 * t1995 + 0.576e4 * t801 * t317 * t761 + 0.896e6 / 0.9e1 * t137 * t2005 * t2006 + 0.72e3 * t2010 * t2012 + 0.36e3 * t764 * t2016 + 0.24e4 * t2019 * t2021 - 0.64e4 / 0.3e1 * t796 * t2024 + 0.576e5 * t2027 * t2012 + 0.1152e5 * t805 * t2016 + 0.1344e6 * t2032 * t2021 - 0.1792e6 / 0.3e1 * t137 * t813 * t947 + 0.5632e5 / 0.9e1 * t137 * t322 * t733 - 0.96e3 * t764 * t2041 + 0.144e3 * t752 * t2044 + 0.2e5 / 0.9e1 * t2047 * t2048 + 0.384e3 * t316 * t140 * t2056 - 0.3072e5 * t805 * t2041 + 0.48e2 * t1995 * t132 + 0.24e2 * t299 * t2056;
  t2069 = t738 * t302;
  t2070 = t2069 * t144;
  t2073 = t335 * t738;
  t2076 = t831 * t302;
  t2079 = t335 * t774;
  t2084 = t749 * t132;
  t2101 = -0.24e2 * t968 * t761 - 0.8e2 * t2084 * t292 - 0.4e3 * t2010 * t2021 - 0.8e2 * t752 * t2016 + 0.64e3 / 0.3e1 * t752 * t2041 - 0.8e1 * t291 * t2056 - 0.4e4 / 0.9e1 * t2019 * t2048 + 0.16e4 / 0.3e1 * t764 * t2024 - 0.352e4 / 0.27e2 * t299 * t1991;
  t2102 = t151 * t2101;
  t2105 = t283 * t2053;
  t2107 = 0.154e4 / 0.6561e4 * t282 * t2105;
  t2109 = 0.1e1 / t104 / t1971;
  t2110 = t724 * t2109;
  t2112 = 0.22e4 / 0.531441e6 * t722 * t2110;
  t2113 = t329 * t329;
  t2115 = t176 / t2113;
  t2122 = -0.4e4 / 0.43046721e8 * t2115 * t1974 + 0.22e4 / 0.531441e6 * t826 * t2110 - 0.154e4 / 0.6561e4 * t332 * t2105 + t1976 - t2112 + t2107;
  t2124 = -t308 * t151 * t2066 - 0.3e1 * t308 * t831 * t326 - 0.3e1 * t308 * t335 * t820 + t145 * t2122 + 0.6e1 * t2070 * t151 + 0.18e2 * t737 * t2073 + 0.9e1 * t290 * t2076 + 0.9e1 * t290 * t2079 + 0.3e1 * t290 * t2102 - t2107 + t2112;
  t2125 = -0.18e2 * t1940 * t739 * t326 + 0.18e2 * t1977 * t303 * t781 + 0.18e2 * t737 * t303 * t774 - 0.9e1 * t742 * t303 * t820 - 0.18e2 * t742 * t746 * t326 - 0.9e1 * t742 * t775 * t326 + 0.6e1 * t780 * t327 * t820 + 0.6e1 * t780 * t335 * t781 - 0.6e1 * t1958 * t1960 - t1976 + t2124;
  t2130 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1925 * t153 - 0.3e1 / 0.8e1 * t1870 - 0.9e1 / 0.8e1 * t6 * t710 * t337 + t1803 / 0.4e1 - 0.3e1 / 0.4e1 * t1877 - 0.9e1 / 0.8e1 * t6 * t275 * t833 - t1727 + t1814 / 0.4e1 - 0.3e1 / 0.8e1 * t1885 - 0.3e1 / 0.8e1 * t6 * t102 * t2125);
  tv3rho33 = 0.3e1 * t699 + 0.3e1 * t838 + t7 * (t1912 + t2130);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t2138 = t6 * t462 * t364;
  t2145 = t6 * t471 * t364 / 0.12e2;
  t2147 = t6 * t172 * t920;
  t2149 = t233 * t906;
  t2152 = t362 * t499;
  t2158 = t592 * t357;
  t2163 = t362 * t581;
  t2165 = t1555 * t39;
  t2167 = t529 * t194;
  t2168 = t2167 * tau[0];
  t2169 = t1558 * t2168;
  t2171 = t184 * t194;
  t2172 = t513 * t2171;
  t2174 = t39 * t522;
  t2175 = t513 * t2174;
  t2177 = t1581 * t526;
  t2178 = t1579 * t2177;
  t2180 = t849 * tau[0];
  t2181 = t525 * t2180;
  t2183 = t197 * t494;
  t2186 = t1621 * t354 * t510;
  t2188 = t1629 * t2168;
  t2191 = t562 * t903 * t194;
  t2194 = t562 * t354 * t522;
  t2196 = t573 * t1581;
  t2198 = t214 * t2196 * t526;
  t2200 = t219 * t849;
  t2202 = t214 * t2200 * tau[0];
  t2204 = t75 * t494;
  t2205 = t214 * t2204;
  t2207 = -0.6e1 * t2165 - 0.6e2 * t2169 + 0.32e2 * t2172 - 0.6e1 * t2175 - 0.1e3 * t2178 + 0.12e3 * t2181 - 0.88e2 / 0.3e1 * t2183 - 0.96e3 * t2186 - 0.48e4 * t2188 + 0.128e4 * t2191 - 0.24e3 * t2194 - 0.56e4 * t2198 + 0.384e4 * t2202 - 0.1408e4 / 0.3e1 * t2205;
  t2208 = t86 * t2207;
  t2210 = t918 * t200;
  t2213 = t362 * t535;
  t2222 = -0.2e1 * t206 * t918 * t224 - 0.6e1 * t503 * t909 * t224 + 0.2e1 * t541 * t358 * t581 + 0.2e1 * t541 * t362 * t542 + 0.6e1 * t188 * t2210 + 0.3e1 * t188 * t2213 - 0.2e1 * t206 * t2149 - t206 * t2158 - t206 * t2163 - t206 * t2208 + 0.6e1 * t498 * t2152;
  t2223 = t1520 * t35;
  t2225 = t1517 / t2223;
  t2226 = t2225 * t484;
  t2228 = 0.5e3 / 0.14348907e8 * t1515 * t2226;
  t2247 = t34 * t494;
  t2249 = 0.11e3 / 0.2187e4 * t179 * t2247;
  t2253 = t870 * t184;
  t2256 = t189 * t494;
  t2260 = t483 * t489 * sigma[0];
  t2262 = 0.25e2 / 0.19683e5 * t481 * t2260;
  t2263 = t2228 - 0.6e1 * t1505 * t358 * t542 - 0.6e1 * t503 * t887 * t200 - 0.6e1 * t503 * t907 * t200 - 0.3e1 * t503 * t358 * t535 + 0.4e1 * t541 * t887 * t224 + 0.4e1 * t541 * t907 * t224 + t2249 - 0.6e1 * t1526 * t358 * t499 - 0.16e2 * t348 * t2253 + 0.88e2 / 0.3e1 * t348 * t2256 - t2262;
  t2265 = t499 * t79;
  t2266 = t2265 * t86;
  t2271 = t188 * t592;
  t2276 = t522 * t59;
  t2277 = t2276 * t39;
  t2280 = t1542 * t86;
  t2281 = t357 * t200;
  t2282 = t2281 * t224;
  t2285 = t870 * t863;
  t2288 = t39 * t581;
  t2289 = t189 * t2288;
  t2294 = t184 * t200;
  t2295 = t189 * t2294;
  t2298 = t39 * t542;
  t2299 = t189 * t2298;
  t2302 = 0.6e1 * t2266 * t349 + 0.3e1 * t2271 * t349 + 0.3e1 * t348 * t2277 + 0.12e2 * t2280 * t2282 + 0.6e1 * t2280 * t2299 - 0.6e1 * t862 * t2285 - 0.3e1 * t862 * t2289 - 0.32e2 * t857 * t2295 + 0.6e1 * t867 * t871 + 0.2e2 * t867 * t875 - 0.16e2 * t867 * t878;
  t2303 = t184 * t224;
  t2304 = t189 * t2303;
  t2307 = t513 * t2180;
  t2310 = t194 * t67;
  t2311 = t2310 * t874;
  t2314 = t1558 * t2177;
  t2317 = t498 * t233;
  t2320 = t870 * t858;
  t2323 = t39 * t535;
  t2324 = t189 * t2323;
  t2327 = t503 * t233;
  t2336 = 0.5e3 / 0.14348907e8 * t1680 * t2226 - 0.25e2 / 0.19683e5 * t587 * t2260 + 0.11e3 / 0.2187e4 * t229 * t2247 - t2228 + t2262 - t2249;
  t2338 = t86 * t52;
  t2339 = t1526 * t2338;
  t2340 = t200 * t224;
  t2341 = t1277 * t2340;
  t2344 = t498 * t2338;
  t2345 = t67 * t529;
  t2346 = t200 * tau[0];
  t2347 = t2345 * t2346;
  t2350 = t503 * t2338;
  t2351 = t224 * tau[0];
  t2352 = t2345 * t2351;
  t2355 = 0.16e2 * t862 * t2304 - 0.8e2 * t348 * t2307 + 0.2e2 * t348 * t2311 + 0.5e2 * t348 * t2314 + 0.12e2 * t2317 * t859 + 0.12e2 * t857 * t2320 + 0.6e1 * t857 * t2324 - 0.6e1 * t2327 * t864 + t80 * t2336 - 0.12e2 * t2339 * t2341 + 0.4e2 * t2344 * t2347 - 0.2e2 * t2350 * t2352;
  t2357 = t2222 + t2263 + t2302 + t2355;
  t2362 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t364 - t2138 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t920 + t2145 - t2147 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2357);
  tv3rho2sigma0 = t7 * t2362 + 0.2e1 * t925;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2369 = t6 * t617 * t388;
  t2373 = t6 * t621 * t388 / 0.12e2;
  t2375 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t388 - t2369 / 0.4e1 + t2373);
  tv3rho2sigma2 = t7 * t2375 + 0.2e1 * t934;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2381 = t6 * t642 * t364;
  t2389 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t364 - t2381 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t920 - t2138 / 0.8e1 + t2145 - t2147 / 0.8e1);
  tv3rho2sigma3 = t7 * t2389 + t925 + t940;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2395 = t6 * t666 * t388;
  t2402 = t6 * t251 * t1018;
  t2405 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t388 - t2395 / 0.8e1 - t2369 / 0.8e1 + t2373 - 0.3e1 / 0.8e1 * t6 * t247 * t1018 - t2402 / 0.8e1);
  tv3rho2sigma5 = t7 * t2405 + t1023 + t934;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2413 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t364 - t2381 / 0.4e1 + t2145);
  tv3rho2sigma6 = t7 * t2413 + 0.2e1 * t940;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2427 = t386 * t738;
  t2430 = t1016 * t302;
  t2433 = t386 * t774;
  t2439 = t386 * t820;
  t2441 = t831 * t381;
  t2443 = t335 * t1004;
  t2446 = t2084 * t107;
  t2448 = t768 * t296;
  t2449 = t2448 * tau[1];
  t2450 = t2010 * t2449;
  t2452 = t286 * t296;
  t2453 = t752 * t2452;
  t2455 = t107 * t761;
  t2456 = t752 * t2455;
  t2458 = t2006 * t765;
  t2459 = t2019 * t2458;
  t2461 = t947 * tau[1];
  t2462 = t764 * t2461;
  t2464 = t299 * t733;
  t2467 = t1994 * t378 * t749;
  t2469 = t2027 * t2449;
  t2472 = t801 * t1001 * t296;
  t2475 = t801 * t378 * t761;
  t2477 = t812 * t2006;
  t2479 = t316 * t2477 * t765;
  t2481 = t321 * t947;
  t2483 = t316 * t2481 * tau[1];
  t2485 = t140 * t733;
  t2486 = t316 * t2485;
  t2488 = -0.6e1 * t2446 - 0.6e2 * t2450 + 0.32e2 * t2453 - 0.6e1 * t2456 - 0.1e3 * t2459 + 0.12e3 * t2462 - 0.88e2 / 0.3e1 * t2464 - 0.96e3 * t2467 - 0.48e4 * t2469 + 0.128e4 * t2472 - 0.24e3 * t2475 - 0.56e4 * t2479 + 0.384e4 * t2483 - 0.1408e4 / 0.3e1 * t2486;
  t2489 = t151 * t2488;
  t2497 = 0.4e1 * t780 * t1005 * t326 - 0.2e1 * t308 * t1016 * t326 + 0.2e1 * t780 * t382 * t820 + 0.2e1 * t780 * t386 * t781 + 0.6e1 * t737 * t2427 + 0.6e1 * t290 * t2430 + 0.3e1 * t290 * t2433 - t308 * t2439 - t308 * t2441 - 0.2e1 * t308 * t2443 - t308 * t2489;
  t2519 = t1971 * t103;
  t2521 = t1517 / t2519;
  t2522 = t2521 * t723;
  t2524 = 0.5e3 / 0.14348907e8 * t1968 * t2522;
  t2525 = t34 * t733;
  t2527 = 0.11e3 / 0.2187e4 * t281 * t2525;
  t2528 = t290 * t831;
  t2533 = t761 * t124;
  t2534 = t2533 * t107;
  t2537 = -0.6e1 * t742 * t1005 * t302 - 0.6e1 * t742 * t1007 * t326 - 0.6e1 * t1940 * t382 * t738 - 0.6e1 * t1958 * t382 * t781 - 0.6e1 * t742 * t985 * t302 + 0.4e1 * t780 * t985 * t326 - 0.3e1 * t742 * t382 * t774 + 0.3e1 * t2528 * t373 + 0.3e1 * t372 * t2534 + 0.6e1 * t965 * t969 + t2524 + t2527;
  t2539 = t1977 * t151;
  t2540 = t381 * t302;
  t2541 = t2540 * t326;
  t2546 = t968 * t286;
  t2549 = t291 * t733;
  t2552 = t286 * t302;
  t2553 = t291 * t2552;
  t2556 = t107 * t781;
  t2557 = t291 * t2556;
  t2560 = t286 * t326;
  t2561 = t291 * t2560;
  t2564 = t752 * t2461;
  t2567 = t968 * t956;
  t2570 = t107 * t774;
  t2571 = t291 * t2570;
  t2574 = t742 * t335;
  t2577 = 0.12e2 * t2539 * t2541 - 0.16e2 * t965 * t976 - 0.16e2 * t372 * t2546 + 0.88e2 / 0.3e1 * t372 * t2549 - 0.32e2 * t955 * t2553 + 0.6e1 * t2539 * t2557 + 0.16e2 * t960 * t2561 - 0.8e2 * t372 * t2564 + 0.12e2 * t955 * t2567 + 0.6e1 * t955 * t2571 - 0.6e1 * t2574 * t962;
  t2578 = t968 * t961;
  t2581 = t107 * t820;
  t2582 = t291 * t2581;
  t2587 = t296 * t132;
  t2588 = t2587 * t972;
  t2591 = t2010 * t2458;
  t2594 = t737 * t335;
  t2598 = t483 * t728 * sigma[2];
  t2600 = 0.25e2 / 0.19683e5 * t722 * t2598;
  t2601 = t738 * t144;
  t2602 = t2601 * t151;
  t2611 = 0.5e3 / 0.14348907e8 * t2115 * t2522 - 0.25e2 / 0.19683e5 * t826 * t2598 + 0.11e3 / 0.2187e4 * t331 * t2525 - t2524 + t2600 - t2527;
  t2613 = t151 * t120;
  t2614 = t1940 * t2613;
  t2615 = t302 * t326;
  t2616 = t1320 * t2615;
  t2619 = t737 * t2613;
  t2620 = t132 * t768;
  t2621 = t302 * tau[1];
  t2622 = t2620 * t2621;
  t2625 = t742 * t2613;
  t2626 = t326 * tau[1];
  t2627 = t2620 * t2626;
  t2630 = t145 * t2611 - 0.6e1 * t960 * t2578 - 0.3e1 * t960 * t2582 + 0.2e2 * t372 * t2588 + 0.5e2 * t372 * t2591 + 0.12e2 * t2594 * t957 + 0.6e1 * t2602 * t373 - 0.12e2 * t2614 * t2616 + 0.4e2 * t2619 * t2622 - 0.2e2 * t2625 * t2627 + 0.2e2 * t965 * t973 - t2600;
  t2632 = t2497 + t2537 + t2577 + t2630;
  t2637 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t388 - t2395 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t1018 + t2373 - t2402 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t2632);
  tv3rho2sigma8 = t7 * t2637 + 0.2e1 * t1023;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2644 = t6 * t462 * t412;
  t2651 = t6 * t471 * t412 / 0.12e2;
  t2653 = t6 * t172 * t1096;
  t2673 = t592 * t396;
  t2676 = t233 * t1054;
  t2684 = 0.1e1 / t487;
  t2685 = t2684 * t526;
  t2690 = t1555 * t49;
  t2692 = t1043 * t194;
  t2693 = t2692 * tau[0];
  t2694 = t1558 * t2693;
  t2697 = t49 * t522;
  t2698 = t513 * t2697;
  t2700 = t1579 * t2685;
  t2704 = -0.8e1 * t2276 * t49 - 0.16e3 / 0.3e1 * t2310 * t1044 + 0.8e2 / 0.3e1 * t871 - 0.4e3 / 0.3e1 * t1558 * t2685 + 0.16e3 * t875 - 0.32e3 / 0.9e1 * t878 + 0.16e2 * t2690 + 0.16e3 * t2694 - 0.16e3 / 0.3e1 * t890 + 0.16e2 * t2698 + 0.8e3 / 0.3e1 * t2700 - 0.24e3 * t892 + 0.32e3 / 0.9e1 * t894;
  t2705 = t86 * t2704;
  t2708 = t592 * t409;
  t2710 = t233 * t1093;
  t2720 = t219 * t184;
  t2734 = t573 * t2684;
  t2741 = t1604 * t2684;
  t2748 = -0.144e3 * t1558 * t49 * t510 + 0.24e3 * t525 * t889 + 0.96e3 * t557 * t874 - 0.512e4 / 0.3e1 * t72 * t2720 - 0.72e2 * t525 * t2697 - 0.4e4 / 0.3e1 * t1648 * t2685 + 0.48e2 * t2698 + 0.8e3 * t2700 - 0.96e3 * t1579 * t2693 + 0.192e4 * t562 * t403 * t522 + 0.448e5 * t214 * t2734 * t526 - 0.2304e4 * t214 * t406 * t522 - 0.1792e6 / 0.3e1 * t72 * t2741 * t526 + 0.768e4 * t1621 * t403 * t510;
  t2755 = t573 * t529;
  t2773 = -0.1152e5 * t562 * t406 * t510 + 0.768e4 * t214 * t1090 * t194 + 0.2688e5 * t72 * t2755 * tau[0] + 0.48e3 * t2694 - 0.32e3 / 0.3e1 * t210 * t184 + 0.48e2 * t2690 + 0.384e5 * t1629 * t2693 - 0.5376e5 * t1634 * t2693 - 0.64e4 * t897 - 0.2304e5 * t901 - 0.16e3 * t890 - 0.72e3 * t892 + 0.512e4 / 0.3e1 * t904 + 0.32e3 / 0.3e1 * t894;
  t2774 = t2748 + t2773;
  t2775 = t86 * t2774;
  t2777 = -0.6e1 * t503 * t1064 * t200 + 0.4e1 * t541 * t1064 * t224 - 0.6e1 * t503 * t1094 * t200 + 0.4e1 * t541 * t1094 * t224 - 0.3e1 * t503 * t410 * t535 + 0.2e1 * t541 * t410 * t581 + 0.3e1 * t188 * t2673 + 0.6e1 * t188 * t2676 + 0.3e1 * t188 * t2705 - t206 * t2708 - 0.2e1 * t206 * t2710 - t206 * t2775;
  t2781 = t1526 * t86;
  t2782 = t396 * t200;
  t2783 = t2782 * t224;
  t2792 = t409 * t200;
  t2793 = t2792 * t224;
  t2804 = t397 * t535;
  t2816 = 0.12e2 * t498 * t1037 * t200 - 0.6e1 * t503 * t1037 * t224 + 0.12e2 * t498 * t1055 * t200 - 0.6e1 * t503 * t1055 * t224 - 0.6e1 * t1505 * t410 * t542 - 0.6e1 * t1526 * t410 * t499 + 0.6e1 * t1542 * t397 * t542 - 0.3e1 * t503 * t397 * t581 + 0.6e1 * t2265 * t397 + 0.12e2 * t2280 * t2793 - 0.12e2 * t2781 * t2783 + 0.6e1 * t498 * t2804;
  t2817 = t2777 + t2816;
  t2822 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t412 - t2644 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t1096 + t2651 - t2653 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2817);
  tv3rho2tau0 = t7 * t2822 + 0.2e1 * t1101;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2829 = t6 * t617 * t436;
  t2833 = t6 * t621 * t436 / 0.12e2;
  t2835 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t436 - t2829 / 0.4e1 + t2833);
  tv3rho2tau1 = t7 * t2835 + 0.2e1 * t1110;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2841 = t6 * t642 * t412;
  t2849 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t412 - t2841 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t1096 - t2644 / 0.8e1 + t2651 - t2653 / 0.8e1);
  tv3rho2tau2 = t7 * t2849 + t1101 + t1116;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2855 = t6 * t666 * t436;
  t2862 = t6 * t251 * t1186;
  t2865 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t436 - t2855 / 0.8e1 - t2829 / 0.8e1 + t2833 - 0.3e1 / 0.8e1 * t6 * t247 * t1186 - t2862 / 0.8e1);
  tv3rho2tau3 = t7 * t2865 + t1110 + t1191;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2873 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t412 - t2841 / 0.4e1 + t2651);
  tv3rho2tau4 = t7 * t2873 + 0.2e1 * t1116;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2910 = t421 * t774;
  t2919 = 0.12e2 * t737 * t1127 * t302 - 0.6e1 * t742 * t1127 * t326 + 0.12e2 * t737 * t1145 * t302 - 0.6e1 * t742 * t1145 * t326 - 0.6e1 * t742 * t1154 * t302 + 0.4e1 * t780 * t1154 * t326 - 0.6e1 * t742 * t1184 * t302 + 0.4e1 * t780 * t1184 * t326 - 0.3e1 * t742 * t434 * t774 + 0.2e1 * t780 * t434 * t820 + 0.6e1 * t2601 * t421 + 0.6e1 * t737 * t2910;
  t2923 = t831 * t420;
  t2926 = t335 * t1144;
  t2934 = 0.1e1 / t726;
  t2935 = t2934 * t765;
  t2940 = t2084 * t117;
  t2942 = t1133 * t296;
  t2943 = t2942 * tau[1];
  t2944 = t2010 * t2943;
  t2947 = t117 * t761;
  t2948 = t752 * t2947;
  t2950 = t2019 * t2935;
  t2954 = -0.8e1 * t2533 * t117 - 0.16e3 / 0.3e1 * t2587 * t1134 + 0.8e2 / 0.3e1 * t969 - 0.4e3 / 0.3e1 * t2010 * t2935 + 0.16e3 * t973 - 0.32e3 / 0.9e1 * t976 + 0.16e2 * t2940 + 0.16e3 * t2944 - 0.16e3 / 0.3e1 * t988 + 0.16e2 * t2948 + 0.8e3 / 0.3e1 * t2950 - 0.24e3 * t990 + 0.32e3 / 0.9e1 * t992;
  t2955 = t151 * t2954;
  t2958 = t831 * t433;
  t2960 = t335 * t1183;
  t2971 = t812 * t2934;
  t2978 = t2003 * t2934;
  t2991 = t812 * t768;
  t3000 = -0.32e3 / 0.3e1 * t312 * t286 + 0.48e2 * t2940 - 0.96e3 * t2019 * t2943 + 0.192e4 * t801 * t427 * t761 + 0.448e5 * t316 * t2971 * t765 - 0.2304e4 * t316 * t430 * t761 - 0.1792e6 / 0.3e1 * t137 * t2978 * t765 + 0.768e4 * t1994 * t427 * t749 - 0.1152e5 * t801 * t430 * t749 + 0.768e4 * t316 * t1180 * t296 + 0.2688e5 * t137 * t2991 * tau[1] + 0.48e3 * t2944 + 0.384e5 * t2027 * t2943 - 0.5376e5 * t2032 * t2943;
  t3002 = t321 * t286;
  t3023 = 0.512e4 / 0.3e1 * t1002 - 0.512e4 / 0.3e1 * t137 * t3002 - 0.144e3 * t2010 * t117 * t749 + 0.24e3 * t764 * t987 + 0.96e3 * t796 * t972 - 0.4e4 / 0.3e1 * t2047 * t2935 - 0.72e2 * t764 * t2947 - 0.16e3 * t988 - 0.72e3 * t990 + 0.32e3 / 0.3e1 * t992 - 0.64e4 * t995 - 0.2304e5 * t999 + 0.48e2 * t2948 + 0.8e3 * t2950;
  t3024 = t3000 + t3023;
  t3025 = t151 * t3024;
  t3027 = t1940 * t151;
  t3028 = t420 * t302;
  t3029 = t3028 * t326;
  t3038 = t433 * t302;
  t3039 = t3038 * t326;
  t3045 = -0.6e1 * t1940 * t434 * t738 - 0.6e1 * t1958 * t434 * t781 + 0.6e1 * t1977 * t421 * t781 - 0.3e1 * t742 * t421 * t820 + 0.12e2 * t2539 * t3039 + 0.3e1 * t290 * t2923 + 0.6e1 * t290 * t2926 + 0.3e1 * t290 * t2955 - t308 * t2958 - 0.2e1 * t308 * t2960 - t308 * t3025 - 0.12e2 * t3027 * t3029;
  t3046 = t2919 + t3045;
  t3051 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t436 - t2855 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t1186 + t2833 - t2862 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t3046);
  tv3rho2tau5 = t7 * t3051 + 0.2e1 * t1191;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t3058 = t6 * t172 * t1230 / 0.8e1;
  t3063 = t1520 * rho[0];
  t3064 = 0.1e1 / t3063;
  t3065 = t1517 * t3064;
  t3066 = t3065 * sigma[0];
  t3069 = t1193 * t849;
  t3073 = 0.125e3 / 0.9565938e7 * t1515 * t3066;
  t3075 = 0.5e2 / 0.177147e6 * t480 * t3069;
  t3076 = -0.125e3 / 0.9565938e7 * t1680 * t3066 + 0.5e2 / 0.177147e6 * t586 * t3069 + t3073 - t3075;
  t3103 = t200 * t79;
  t3104 = t3103 * t86;
  t3109 = t188 * t918;
  t3114 = t529 * t59;
  t3115 = t3114 * t200;
  t3118 = t3114 * t224;
  t3121 = t1581 * t67;
  t3122 = t3121 * tau[0];
  t3125 = t525 * t849;
  t3128 = 0.2e1 * t188 * t86 * t849 * t59 + t80 * t3076 + 0.4e1 * t541 * t1215 * t224 - 0.3e1 * t503 * t1224 * t200 + 0.2e1 * t541 * t1224 * t224 + t3075 - t3073 - 0.3e1 / 0.8e1 * t188 * t233 * t529 * t59 + 0.6e1 * t1542 * t1212 * t200 - 0.6e1 * t1505 * t1212 * t224 + 0.4e1 * t541 * t358 * t906 - 0.6e1 * t503 * t1215 * t200 + 0.6e1 * t3104 * t1197 + 0.6e1 * t2317 * t1197 + 0.6e1 * t3109 * t349 + 0.6e1 * t1204 * t871 - 0.3e1 / 0.4e1 * t857 * t3115 + 0.3e1 / 0.8e1 * t862 * t3118 - 0.5e1 / 0.4e1 * t348 * t3122 - 0.32e2 * t857 * t3125;
  t3131 = t184 * t357;
  t3132 = t189 * t3131;
  t3135 = t1581 * tau[0];
  t3136 = t1579 * t3135;
  t3141 = t870 * t1200;
  t3144 = t39 * t906;
  t3145 = t189 * t3144;
  t3148 = t498 * t362;
  t3151 = t503 * t362;
  t3156 = t529 * t224;
  t3157 = t525 * t3156;
  t3161 = t1558 * t2167;
  t3164 = t1228 * t200;
  t3169 = t233 * t1211;
  t3172 = t918 * t357;
  t3175 = t362 * t906;
  t3178 = t233 * t1223;
  t3180 = t2310 * t529;
  t3182 = t1558 * t3135;
  t3184 = t513 * t849;
  t3187 = t1621 * t1220 * t194;
  t3189 = t219 * t1581;
  t3191 = t562 * t3189 * tau[0];
  t3193 = t75 * t849;
  t3194 = t562 * t3193;
  t3196 = 0.3e1 / 0.4e1 * t3180 + 0.15e2 / 0.4e1 * t3182 - 0.4e1 * t3184 + 0.12e3 * t3187 + 0.3e3 * t3191 - 0.16e3 * t3194;
  t3197 = t86 * t3196;
  t3199 = t1277 * t2281;
  t3202 = t1542 * t2338;
  t3203 = t357 * t224;
  t3204 = t1277 * t3203;
  t3207 = t357 * tau[0];
  t3208 = t2345 * t3207;
  t3211 = -t206 * t1228 * t224 + 0.3e1 * t188 * t3164 - 0.2e1 * t206 * t3172 - 0.2e1 * t206 * t3175 - t206 * t3178 - t206 * t3197 - 0.12e2 * t2339 * t3199 - 0.2e2 * t2350 * t3208 + 0.12e2 * t857 * t3161 + 0.2e1 * t541 * t3169 + 0.12e2 * t3202 * t3204;
  t3213 = -0.6e1 * t2327 * t1201 + 0.2e2 * t1204 * t875 - 0.16e2 * t1204 * t878 - 0.6e1 * t2781 * t3157 + 0.16e2 * t862 * t3132 + 0.4e2 * t857 * t3136 - 0.6e1 * t862 * t3141 - 0.6e1 * t862 * t3145 + 0.12e2 * t3148 * t859 - 0.6e1 * t3151 * t864 + t3128 + t3211;
  t3218 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1230 - t3058 - 0.3e1 / 0.8e1 * t6 * t28 * t3213);
  tv3rhosigma20 = t7 * t3218 + t1234;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t3225 = t6 * t251 * t1271 / 0.8e1;
  t3227 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1271 - t3225);
  tv3rhosigma25 = t7 * t3227 + t1275;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t3233 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1230 - t3058);
  tv3rhosigma26 = t7 * t3233 + t1234;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t3257 = t1971 * rho[1];
  t3258 = 0.1e1 / t3257;
  t3259 = t1517 * t3258;
  t3260 = t3259 * sigma[2];
  t3262 = 0.125e3 / 0.9565938e7 * t1968 * t3260;
  t3273 = t1193 * t947;
  t3275 = 0.5e2 / 0.177147e6 * t721 * t3273;
  t3278 = t764 * t947;
  t3283 = t290 * t1016;
  t3288 = t768 * t124;
  t3289 = t3288 * t302;
  t3292 = t3288 * t326;
  t3295 = t2006 * t132;
  t3296 = t3295 * tau[1];
  t3299 = t302 * t144;
  t3300 = t3299 * t151;
  t3303 = -0.3e1 * t742 * t1265 * t302 + 0.2e1 * t780 * t1265 * t326 + 0.4e1 * t780 * t382 * t1004 - 0.6e1 * t742 * t1256 * t302 + 0.4e1 * t780 * t1256 * t326 + 0.2e1 * t290 * t151 * t947 * t124 - t3262 - 0.3e1 / 0.8e1 * t290 * t335 * t768 * t124 + 0.6e1 * t1977 * t1253 * t302 - 0.6e1 * t1958 * t1253 * t326 + t3275 - 0.16e2 * t1245 * t976 - 0.32e2 * t955 * t3278 + 0.6e1 * t2594 * t1238 + 0.6e1 * t3283 * t373 + 0.6e1 * t1245 * t969 - 0.3e1 / 0.4e1 * t955 * t3289 + 0.3e1 / 0.8e1 * t960 * t3292 - 0.5e1 / 0.4e1 * t372 * t3296 + 0.6e1 * t3300 * t1238;
  t3308 = -0.125e3 / 0.9565938e7 * t2115 * t3260 + 0.5e2 / 0.177147e6 * t825 * t3273 + t3262 - t3275;
  t3310 = t2006 * tau[1];
  t3311 = t2019 * t3310;
  t3316 = t968 * t1241;
  t3319 = t107 * t1004;
  t3320 = t291 * t3319;
  t3323 = t737 * t386;
  t3326 = t742 * t386;
  t3331 = t768 * t326;
  t3332 = t764 * t3331;
  t3335 = t2010 * t2448;
  t3339 = t286 * t381;
  t3340 = t291 * t3339;
  t3343 = t2587 * t768;
  t3345 = t2010 * t3310;
  t3347 = t752 * t947;
  t3350 = t1994 * t1261 * t296;
  t3352 = t321 * t2006;
  t3354 = t801 * t3352 * tau[1];
  t3356 = t140 * t947;
  t3357 = t801 * t3356;
  t3359 = 0.3e1 / 0.4e1 * t3343 + 0.15e2 / 0.4e1 * t3345 - 0.4e1 * t3347 + 0.12e3 * t3350 + 0.3e3 * t3354 - 0.16e3 * t3357;
  t3360 = t151 * t3359;
  t3362 = t1269 * t302;
  t3367 = t335 * t1252;
  t3370 = t1016 * t381;
  t3373 = t386 * t1004;
  t3376 = t335 * t1264;
  t3378 = t1320 * t2540;
  t3381 = t1977 * t2613;
  t3382 = t381 * t326;
  t3383 = t1320 * t3382;
  t3386 = t381 * tau[1];
  t3387 = t2620 * t3386;
  t3390 = -t308 * t1269 * t326 - 0.12e2 * t2614 * t3378 - 0.2e2 * t2625 * t3387 + 0.3e1 * t290 * t3362 - t308 * t3360 - 0.2e1 * t308 * t3370 - 0.2e1 * t308 * t3373 - t308 * t3376 + 0.16e2 * t960 * t3340 + 0.2e1 * t780 * t3367 + 0.12e2 * t3381 * t3383;
  t3392 = -0.6e1 * t2574 * t1242 + 0.2e2 * t1245 * t973 + t145 * t3308 - 0.6e1 * t3027 * t3332 + 0.4e2 * t955 * t3311 - 0.6e1 * t960 * t3316 - 0.6e1 * t960 * t3320 + 0.12e2 * t3323 * t957 - 0.6e1 * t3326 * t962 + 0.12e2 * t955 * t3335 + t3303 + t3390;
  t3397 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1271 - t3225 - 0.3e1 / 0.8e1 * t6 * t102 * t3392);
  tv3rhosigma211 = t7 * t3397 + t1275;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t3404 = t6 * t172 * t1314 / 0.8e1;
  t3447 = t396 * t357;
  t3448 = t3447 * t200;
  t3451 = t3447 * t224;
  t3454 = t409 * t357;
  t3455 = t3454 * t200;
  t3458 = t1505 * t86;
  t3459 = t3454 * t224;
  t3466 = -0.3e1 * t503 * t1037 * t357 - 0.3e1 * t503 * t1055 * t357 + 0.2e1 * t541 * t1064 * t357 + 0.2e1 * t541 * t1094 * t357 + 0.6e1 * t498 * t1284 * t200 - 0.3e1 * t503 * t1284 * t224 + 0.6e1 * t498 * t1291 * t200 - 0.3e1 * t503 * t1291 * t224 - 0.3e1 * t503 * t1301 * t200 + 0.2e1 * t541 * t1301 * t224 - 0.3e1 * t503 * t1312 * t200 + 0.2e1 * t541 * t1312 * t224 - 0.3e1 * t503 * t397 * t906 + 0.2e1 * t541 * t410 * t906 + 0.6e1 * t2317 * t1278 + 0.6e1 * t3104 * t1278 + 0.6e1 * t2280 * t3451 + 0.6e1 * t2280 * t3455 - 0.6e1 * t2781 * t3448 - 0.6e1 * t3458 * t3459;
  t3467 = t1054 * t52;
  t3468 = t3467 * t1277;
  t3471 = t396 * t194;
  t3472 = t3471 * t1277;
  t3477 = t1093 * t52;
  t3478 = t3477 * t1277;
  t3481 = t409 * t194;
  t3482 = t3481 * t1277;
  t3485 = t59 * t184;
  t3486 = t1276 * t3485;
  t3489 = t1294 * t3485;
  t3492 = t233 * t1311;
  t3494 = t2310 * t1043;
  t3496 = t2684 * tau[0];
  t3497 = t1558 * t3496;
  t3500 = t1558 * t2692;
  t3502 = t1579 * t3496;
  t3506 = t1621 * t1306 * t194;
  t3508 = t219 * t2684;
  t3510 = t562 * t3508 * tau[0];
  t3514 = t562 * t1078 * t194;
  t3517 = t214 * t2734 * tau[0];
  t3519 = t214 * t899;
  t3521 = -0.6e1 * t3494 - 0.3e2 * t3497 + 0.26e2 * t1218 + 0.18e2 * t3500 + 0.6e2 * t3502 - 0.39e2 * t1197 - 0.96e3 * t3506 - 0.24e4 * t3510 + 0.104e4 * t1221 + 0.144e4 * t3514 + 0.336e4 * t3517 - 0.1248e4 * t3519;
  t3522 = t86 * t3521;
  t3524 = t362 * t1054;
  t3527 = t233 * t1290;
  t3531 = t2684 * t67;
  t3532 = t3531 * tau[0];
  t3537 = -0.13e2 / 0.3e1 * t3114 + 0.1e2 / 0.3e1 * t3532 - 0.2e1 * t3494 - 0.1e2 * t3497 + 0.26e2 / 0.3e1 * t1218;
  t3538 = t86 * t3537;
  t3541 = t918 * t409;
  t3543 = t362 * t1093;
  t3545 = t918 * t396;
  t3548 = t1526 * t397;
  t3551 = t498 * t397;
  t3554 = t1526 * t410;
  t3557 = t1542 * t410;
  t3560 = t503 * t410;
  t3563 = -0.3e1 * t2327 * t1295 + 0.3e1 * t188 * t3524 + 0.3e1 * t188 * t3527 + 0.3e1 * t188 * t3538 + 0.3e1 * t188 * t3545 - t206 * t3492 - t206 * t3522 - t206 * t3541 - t206 * t3543 + 0.6e1 * t857 * t3468 + 0.6e1 * t857 * t3472 - 0.3e1 * t862 * t3478 - 0.3e1 * t862 * t3482 - 0.16e2 * t857 * t3486 + 0.8e1 * t862 * t3489 - 0.6e1 * t3548 * t864 + 0.2e2 * t3551 * t875 - 0.6e1 * t3554 * t859 + 0.6e1 * t3557 * t864 - 0.1e2 * t3560 * t875;
  t3564 = t3466 + t3563;
  t3569 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1314 - t3404 - 0.3e1 / 0.8e1 * t6 * t28 * t3564);
  tv3rhosigmatau0 = t7 * t3569 + t1318;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t3576 = t6 * t251 * t1357 / 0.8e1;
  t3578 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1357 - t3576);
  tv3rhosigmatau5 = t7 * t3578 + t1361;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t3584 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1314 - t3404);
  tv3rhosigmatau6 = t7 * t3584 + t1318;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t3631 = t1958 * t151;
  t3632 = t433 * t381;
  t3633 = t3632 * t326;
  t3636 = t420 * t381;
  t3637 = t3636 * t302;
  t3640 = t3636 * t326;
  t3643 = t2587 * t1133;
  t3645 = t2934 * tau[1];
  t3646 = t2010 * t3645;
  t3649 = t2010 * t2942;
  t3651 = t2019 * t3645;
  t3655 = t1994 * t1349 * t296;
  t3657 = t321 * t2934;
  t3659 = t801 * t3657 * tau[1];
  t3663 = t801 * t1168 * t296;
  t3666 = t316 * t2971 * tau[1];
  t3668 = t316 * t997;
  t3670 = -0.6e1 * t3643 - 0.3e2 * t3646 + 0.26e2 * t1259 + 0.18e2 * t3649 + 0.6e2 * t3651 - 0.39e2 * t1238 - 0.96e3 * t3655 - 0.24e4 * t3659 + 0.104e4 * t1262 + 0.144e4 * t3663 + 0.336e4 * t3666 - 0.1248e4 * t3668;
  t3671 = t151 * t3670;
  t3673 = t386 * t1183;
  t3675 = t335 * t1354;
  t3677 = -0.3e1 * t742 * t421 * t1004 + 0.2e1 * t780 * t434 * t1004 - 0.3e1 * t742 * t1127 * t381 - 0.3e1 * t742 * t1145 * t381 + 0.2e1 * t780 * t1154 * t381 + 0.2e1 * t780 * t1184 * t381 + 0.6e1 * t737 * t1327 * t302 - 0.3e1 * t742 * t1327 * t326 + 0.6e1 * t737 * t1334 * t302 - 0.3e1 * t742 * t1334 * t326 - 0.3e1 * t742 * t1344 * t302 + 0.2e1 * t780 * t1344 * t326 - 0.3e1 * t742 * t1355 * t302 + 0.2e1 * t780 * t1355 * t326 + 0.6e1 * t2539 * t3640 - 0.6e1 * t3027 * t3637 - t308 * t3671 - t308 * t3673 - t308 * t3675 - 0.6e1 * t3631 * t3633;
  t3678 = t1016 * t420;
  t3681 = t386 * t1144;
  t3684 = t335 * t1333;
  t3688 = t2934 * t132;
  t3689 = t3688 * tau[1];
  t3694 = -0.13e2 / 0.3e1 * t3288 + 0.1e2 / 0.3e1 * t3689 - 0.2e1 * t3643 - 0.1e2 * t3646 + 0.26e2 / 0.3e1 * t1259;
  t3695 = t151 * t3694;
  t3698 = t1016 * t433;
  t3700 = t3632 * t302;
  t3705 = t1183 * t120;
  t3706 = t3705 * t1320;
  t3709 = t433 * t296;
  t3710 = t3709 * t1320;
  t3713 = t124 * t286;
  t3714 = t1319 * t3713;
  t3717 = t1337 * t3713;
  t3724 = t1144 * t120;
  t3725 = t3724 * t1320;
  t3728 = t420 * t296;
  t3729 = t3728 * t1320;
  t3732 = t1940 * t421;
  t3735 = t737 * t421;
  t3738 = t1940 * t434;
  t3741 = t1977 * t434;
  t3744 = t742 * t434;
  t3747 = 0.6e1 * t2594 * t1321 + 0.6e1 * t3300 * t1321 - 0.3e1 * t2574 * t1338 + 0.6e1 * t2539 * t3700 + 0.3e1 * t290 * t3678 + 0.3e1 * t290 * t3681 + 0.3e1 * t290 * t3684 + 0.3e1 * t290 * t3695 - t308 * t3698 - 0.3e1 * t960 * t3706 - 0.3e1 * t960 * t3710 - 0.16e2 * t955 * t3714 + 0.8e1 * t960 * t3717 + 0.6e1 * t955 * t3725 + 0.6e1 * t955 * t3729 - 0.6e1 * t3732 * t962 + 0.2e2 * t3735 * t973 - 0.6e1 * t3738 * t957 + 0.6e1 * t3741 * t962 - 0.1e2 * t3744 * t973;
  t3748 = t3677 + t3747;
  t3753 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1357 - t3576 - 0.3e1 / 0.8e1 * t6 * t102 * t3748);
  tv3rhosigmatau11 = t7 * t3753 + t1361;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3760 = t6 * t172 * t1401 / 0.8e1;
  t3763 = t1363 * t224;
  t3766 = t233 * t1362;
  t3769 = t397 * t1054;
  t3772 = t396 * t409;
  t3773 = t3772 * t200;
  t3776 = t3772 * t224;
  t3795 = t233 * t1377;
  t3799 = 0.1e1 / t847;
  t3800 = t3799 * t67;
  t3803 = t2310 * t1370;
  t3805 = t3799 * tau[0];
  t3806 = t1558 * t3805;
  t3809 = t1370 * t194;
  t3810 = t1558 * t3809;
  t3812 = t1579 * t3805;
  t3815 = 0.8e2 / 0.3e1 * t1287 - 0.8e2 / 0.3e1 * t3800 * tau[0] + 0.32e2 * t3803 + 0.16e3 * t3806 - 0.32e3 / 0.3e1 * t1288 - 0.48e2 * t3810 - 0.16e3 * t3812 + 0.8e2 * t1304;
  t3816 = t86 * t3815;
  t3825 = t233 * t1381;
  t3837 = t233 * t1398;
  t3854 = t219 * t3799;
  t3862 = t573 * t3799;
  t3870 = t1604 * t3799;
  t3876 = 0.768e4 * t1621 * t1389 * t194 - 0.2304e5 * t562 * t1392 * t194 + 0.16128e5 * t214 * t1395 * t194 - 0.5376e5 * t214 * t3862 * tau[0] + 0.192e5 * t562 * t3854 * tau[0] + 0.3584e5 * t72 * t3870 * tau[0] - 0.32e3 * t557 * t1043 - 0.896e4 * t72 * t1086 + 0.288e3 * t1579 * t3809 + 0.8e3 * t1648 * t3805 - 0.16e3 * t1288 + 0.48e3 * t1304 - 0.64e4 * t1307 + 0.1536e5 * t1309 + 0.48e2 * t3803 + 0.24e3 * t3806 - 0.288e3 * t3810 - 0.96e3 * t3812;
  t3877 = t86 * t3876;
  t3879 = 0.4e1 * t541 * t410 * t1093 - 0.3e1 * t503 * t1378 * t224 - 0.6e1 * t1505 * t1382 * t224 + 0.6e1 * t1542 * t1382 * t200 - 0.3e1 * t503 * t1399 * t200 + 0.2e1 * t541 * t1399 * t224 + 0.3e1 * t188 * t3795 + 0.3e1 * t188 * t3816 - t206 * t3837 - t206 * t3877 + 0.2e1 * t541 * t3825;
  t3880 = -0.6e1 * t503 * t1037 * t409 - 0.6e1 * t503 * t1055 * t409 - 0.6e1 * t503 * t397 * t1093 + 0.6e1 * t498 * t1378 * t200 + 0.6e1 * t3103 * t1363 - 0.6e1 * t1526 * t3763 + 0.12e2 * t2280 * t3776 - 0.12e2 * t2781 * t3773 + 0.6e1 * t498 * t3766 + 0.12e2 * t498 * t3769 + t3879;
  t3885 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1401 - t3760 - 0.3e1 / 0.8e1 * t6 * t28 * t3880);
  tv3rhotau20 = t7 * t3885 + t1405;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3892 = t6 * t251 * t1445 / 0.8e1;
  t3894 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1445 - t3892);
  tv3rhotau22 = t7 * t3894 + t1449;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3900 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1401 - t3760);
  tv3rhotau23 = t7 * t3900 + t1405;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3907 = t1407 * t326;
  t3910 = t335 * t1406;
  t3913 = t421 * t1144;
  t3916 = t420 * t433;
  t3917 = t3916 * t302;
  t3920 = t3916 * t326;
  t3939 = t335 * t1421;
  t3943 = 0.1e1 / t945;
  t3944 = t3943 * t132;
  t3947 = t2587 * t1414;
  t3949 = t3943 * tau[1];
  t3950 = t2010 * t3949;
  t3953 = t1414 * t296;
  t3954 = t2010 * t3953;
  t3956 = t2019 * t3949;
  t3959 = 0.8e2 / 0.3e1 * t1330 - 0.8e2 / 0.3e1 * t3944 * tau[1] + 0.32e2 * t3947 + 0.16e3 * t3950 - 0.32e3 / 0.3e1 * t1331 - 0.48e2 * t3954 - 0.16e3 * t3956 + 0.8e2 * t1347;
  t3960 = t151 * t3959;
  t3969 = t335 * t1425;
  t3981 = t335 * t1442;
  t3998 = t321 * t3943;
  t4006 = t812 * t3943;
  t4014 = t2003 * t3943;
  t4020 = 0.3584e5 * t137 * t4014 * tau[1] + 0.768e4 * t1994 * t1433 * t296 - 0.2304e5 * t801 * t1436 * t296 + 0.16128e5 * t316 * t1439 * t296 - 0.5376e5 * t316 * t4006 * tau[1] + 0.192e5 * t801 * t3998 * tau[1] - 0.32e3 * t796 * t1133 - 0.896e4 * t137 * t1176 + 0.288e3 * t2019 * t3953 + 0.8e3 * t2047 * t3949 - 0.16e3 * t1331 + 0.48e3 * t1347 - 0.64e4 * t1350 + 0.1536e5 * t1352 + 0.48e2 * t3947 + 0.24e3 * t3950 - 0.288e3 * t3954 - 0.96e3 * t3956;
  t4021 = t151 * t4020;
  t4023 = 0.4e1 * t780 * t434 * t1183 - 0.3e1 * t742 * t1422 * t326 - 0.6e1 * t1958 * t1426 * t326 + 0.6e1 * t1977 * t1426 * t302 - 0.3e1 * t742 * t1443 * t302 + 0.2e1 * t780 * t1443 * t326 + 0.3e1 * t290 * t3939 + 0.3e1 * t290 * t3960 - t308 * t3981 - t308 * t4021 + 0.2e1 * t780 * t3969;
  t4024 = -0.6e1 * t742 * t1127 * t433 - 0.6e1 * t742 * t1145 * t433 - 0.6e1 * t742 * t421 * t1183 + 0.6e1 * t737 * t1422 * t302 + 0.6e1 * t3299 * t1407 - 0.6e1 * t1940 * t3907 + 0.12e2 * t2539 * t3920 - 0.12e2 * t3027 * t3917 + 0.6e1 * t737 * t3910 + 0.12e2 * t737 * t3913 + t4023;
  t4029 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1445 - t3892 - 0.3e1 / 0.8e1 * t6 * t102 * t4024);
  tv3rhotau25 = t7 * t4029 + t1449;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t4031 = t39 * t1211;
  t4032 = t189 * t4031;
  t4035 = t1211 * t357;
  t4036 = t86 * t4035;
  t4048 = t1558 * t1581;
  t4051 = t3114 * t357;
  t4054 = t188 * t1228;
  t4057 = t1517 * t1581;
  t4059 = t1515 * t4057;
  t4061 = 0.125e3 / 0.25509168e8 * t1680 * t4057 - 0.125e3 / 0.25509168e8 * t4059;
  t4064 = t362 * t1211;
  t4067 = t1228 * t357;
  t4070 = t362 * t1223;
  t4074 = t75 * t1581;
  t4075 = t1621 * t4074;
  t4077 = -0.3e1 / 0.32e2 * t3121 - 0.15e2 * t4075;
  t4078 = t86 * t4077;
  t4082 = t39 * t1223;
  t4083 = t189 * t4082;
  t4086 = t529 * t357;
  t4087 = t525 * t4086;
  t4090 = t1581 * t79;
  t4094 = 0.18e2 * t2280 * t4032 - 0.6e1 * t1505 * t4036 + 0.6e1 * t541 * t358 * t1223 - 0.9e1 / 0.8e1 * t188 * t362 * t529 * t59 + 0.18e2 * t3148 * t1197 - 0.9e1 / 0.4e1 * t857 * t4048 + 0.9e1 / 0.8e1 * t862 * t4051 + 0.9e1 * t4054 * t349 + t80 * t4061 + 0.125e3 / 0.25509168e8 * t4059 + 0.6e1 * t541 * t4064 - 0.3e1 * t206 * t4067 - 0.3e1 * t206 * t4070 - t206 * t4078 - 0.18e2 * t3151 * t1201 - 0.9e1 * t862 * t4083 - 0.18e2 * t2781 * t4087 + 0.6e1 * t1648 * t4090 * t86;
  t4098 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4094);
  tv3sigma30 = t7 * t4098;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t4099 = t1517 * t2006;
  t4100 = t1968 * t4099;
  t4102 = t386 * t1252;
  t4105 = t1269 * t381;
  t4108 = t386 * t1264;
  t4112 = t140 * t2006;
  t4113 = t1994 * t4112;
  t4115 = -0.3e1 / 0.32e2 * t3295 - 0.15e2 * t4113;
  t4116 = t151 * t4115;
  t4118 = t2006 * t144;
  t4122 = t107 * t1252;
  t4123 = t291 * t4122;
  t4130 = t1252 * t381;
  t4131 = t151 * t4130;
  t4139 = t2010 * t2006;
  t4142 = t3288 * t381;
  t4145 = t290 * t1269;
  t4150 = 0.125e3 / 0.25509168e8 * t2115 * t4099 - 0.125e3 / 0.25509168e8 * t4100;
  t4152 = t768 * t381;
  t4153 = t764 * t4152;
  t4158 = t107 * t1264;
  t4159 = t291 * t4158;
  t4162 = 0.125e3 / 0.25509168e8 * t4100 + 0.6e1 * t780 * t4102 - 0.3e1 * t308 * t4105 - 0.3e1 * t308 * t4108 - t308 * t4116 + 0.6e1 * t2047 * t4118 * t151 + 0.18e2 * t2539 * t4123 - 0.9e1 / 0.8e1 * t290 * t386 * t768 * t124 - 0.6e1 * t1958 * t4131 + 0.6e1 * t780 * t382 * t1264 + 0.18e2 * t3323 * t1238 - 0.9e1 / 0.4e1 * t955 * t4139 + 0.9e1 / 0.8e1 * t960 * t4142 + 0.9e1 * t4145 * t373 + t145 * t4150 - 0.18e2 * t3027 * t4153 - 0.18e2 * t3326 * t1242 - 0.9e1 * t960 * t4159;
  t4166 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4162);
  tv3sigma39 = t7 * t4166;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t4169 = t1290 * t52;
  t4170 = t4169 * t1277;
  t4175 = t1311 * t52;
  t4176 = t4175 * t1277;
  t4179 = t1228 * t396;
  t4182 = t362 * t1290;
  t4185 = t1228 * t409;
  t4187 = t362 * t1311;
  t4191 = t1558 * t2684;
  t4193 = t75 * t2684;
  t4194 = t1621 * t4193;
  t4196 = t562 * t3508;
  t4198 = 0.3e1 / 0.4e1 * t3531 - 0.9e1 / 0.4e1 * t4191 + 0.12e3 * t4194 - 0.18e3 * t4196;
  t4199 = t86 * t4198;
  t4208 = 0.4e1 * t541 * t1301 * t357 - 0.12e2 * t3548 * t1201 + 0.12e2 * t3557 * t1201 + 0.12e2 * t3148 * t1278 - 0.6e1 * t3151 * t1295 + 0.3e1 * t188 * t4179 + 0.6e1 * t188 * t4182 - t206 * t4185 - 0.2e1 * t206 * t4187 - t206 * t4199 + 0.12e2 * t857 * t4170 - 0.6e1 * t862 * t4176;
  t4228 = t396 * t529;
  t4229 = t4228 * t59;
  t4235 = t409 * t529;
  t4236 = t4235 * t59;
  t4242 = t79 * t86;
  t4243 = t4242 * t396;
  t4246 = t409 * t53;
  t4247 = t209 * t529;
  t4248 = t4246 * t4247;
  t4251 = 0.4e1 * t541 * t1312 * t357 + 0.2e1 * t541 * t410 * t1223 - 0.6e1 * t503 * t1284 * t357 - 0.6e1 * t503 * t1291 * t357 - 0.3e1 * t503 * t397 * t1223 + 0.3e1 / 0.4e1 * t188 * t86 * t2684 * t67 - 0.3e1 / 0.4e1 * t857 * t4229 + 0.6e1 * t1542 * t397 * t1211 + 0.3e1 / 0.8e1 * t862 * t4236 - 0.6e1 * t1505 * t410 * t1211 + 0.6e1 * t1197 * t4243 - 0.6e1 * t2781 * t4248;
  t4252 = t4208 + t4251;
  t4256 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4252);
  tv3sigma2tau0 = t7 * t4256;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t4270 = t420 * t768;
  t4271 = t4270 * t124;
  t4277 = t433 * t768;
  t4278 = t4277 * t124;
  t4286 = t1333 * t120;
  t4287 = t4286 * t1320;
  t4292 = t1354 * t120;
  t4293 = t4292 * t1320;
  t4296 = 0.3e1 / 0.4e1 * t290 * t151 * t2934 * t132 + 0.4e1 * t780 * t1344 * t381 + 0.4e1 * t780 * t1355 * t381 + 0.2e1 * t780 * t434 * t1264 - 0.3e1 / 0.4e1 * t955 * t4271 + 0.6e1 * t1977 * t421 * t1252 + 0.3e1 / 0.8e1 * t960 * t4278 - 0.6e1 * t1958 * t434 * t1252 + 0.12e2 * t3323 * t1321 + 0.12e2 * t955 * t4287 - 0.6e1 * t3326 * t1338 - 0.6e1 * t960 * t4293;
  t4297 = t1269 * t420;
  t4300 = t386 * t1333;
  t4303 = t1269 * t433;
  t4305 = t386 * t1354;
  t4309 = t2010 * t2934;
  t4311 = t140 * t2934;
  t4312 = t1994 * t4311;
  t4314 = t801 * t3657;
  t4316 = 0.3e1 / 0.4e1 * t3688 - 0.9e1 / 0.4e1 * t4309 + 0.12e3 * t4312 - 0.18e3 * t4314;
  t4317 = t151 * t4316;
  t4332 = t144 * t151;
  t4333 = t4332 * t420;
  t4336 = t433 * t121;
  t4337 = t311 * t768;
  t4338 = t4336 * t4337;
  t4341 = -0.3e1 * t742 * t421 * t1264 - 0.6e1 * t742 * t1327 * t381 - 0.6e1 * t742 * t1334 * t381 + 0.6e1 * t1238 * t4333 - 0.12e2 * t3732 * t1242 + 0.12e2 * t3741 * t1242 + 0.3e1 * t290 * t4297 + 0.6e1 * t290 * t4300 - 0.6e1 * t3027 * t4338 - t308 * t4303 - 0.2e1 * t308 * t4305 - t308 * t4317;
  t4342 = t4296 + t4341;
  t4346 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4342);
  tv3sigma2tau11 = t7 * t4346;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t4347 = t4242 * t1362;
  t4350 = t1363 * t357;
  t4353 = t362 * t1362;
  t4356 = t397 * t1290;
  t4361 = t3772 * t357;
  t4373 = t1377 * t52;
  t4374 = t4373 * t1277;
  t4381 = t362 * t1377;
  t4385 = t1558 * t3799;
  t4387 = -0.4e1 * t3800 + 0.6e1 * t4385;
  t4388 = t86 * t4387;
  t4391 = t1381 * t52;
  t4392 = t4391 * t1277;
  t4398 = t362 * t1381;
  t4404 = t1398 * t52;
  t4405 = t4404 * t1277;
  t4411 = t362 * t1398;
  t4415 = t1579 * t3799;
  t4417 = t75 * t3799;
  t4418 = t1621 * t4417;
  t4420 = t562 * t3854;
  t4422 = t214 * t3862;
  t4424 = -0.6e1 * t3800 + 0.36e2 * t4385 - 0.36e2 * t4415 - 0.96e3 * t4418 + 0.288e4 * t4420 - 0.2016e4 * t4422;
  t4425 = t86 * t4424;
  t4427 = 0.4e1 * t541 * t410 * t1311 - 0.3e1 * t503 * t1378 * t357 - 0.6e1 * t1505 * t1382 * t357 + 0.2e1 * t541 * t1399 * t357 + 0.3e1 * t188 * t4381 + 0.3e1 * t188 * t4388 - t206 * t4411 - t206 * t4425 + 0.6e1 * t2280 * t4392 + 0.2e1 * t541 * t4398 - 0.3e1 * t862 * t4405;
  t4428 = -0.6e1 * t503 * t1284 * t409 - 0.6e1 * t503 * t1291 * t409 - 0.6e1 * t503 * t397 * t1311 - 0.12e2 * t3548 * t1295 - 0.6e1 * t1526 * t4350 + 0.12e2 * t2280 * t4361 + 0.6e1 * t349 * t4347 + 0.6e1 * t498 * t4353 + 0.12e2 * t498 * t4356 + 0.6e1 * t857 * t4374 + t4427;
  t4432 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4428);
  tv3sigmatau20 = t7 * t4432;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t4433 = t4332 * t1406;
  t4436 = t1407 * t381;
  t4439 = t386 * t1406;
  t4442 = t421 * t1333;
  t4447 = t3916 * t381;
  t4459 = t1421 * t120;
  t4460 = t4459 * t1320;
  t4467 = t386 * t1421;
  t4471 = t2010 * t3943;
  t4473 = -0.4e1 * t3944 + 0.6e1 * t4471;
  t4474 = t151 * t4473;
  t4477 = t1425 * t120;
  t4478 = t4477 * t1320;
  t4484 = t386 * t1425;
  t4490 = t1442 * t120;
  t4491 = t4490 * t1320;
  t4497 = t386 * t1442;
  t4501 = t2019 * t3943;
  t4503 = t140 * t3943;
  t4504 = t1994 * t4503;
  t4506 = t801 * t3998;
  t4508 = t316 * t4006;
  t4510 = -0.6e1 * t3944 + 0.36e2 * t4471 - 0.36e2 * t4501 - 0.96e3 * t4504 + 0.288e4 * t4506 - 0.2016e4 * t4508;
  t4511 = t151 * t4510;
  t4513 = 0.4e1 * t780 * t434 * t1354 - 0.3e1 * t742 * t1422 * t381 - 0.6e1 * t1958 * t1426 * t381 + 0.2e1 * t780 * t1443 * t381 + 0.6e1 * t2539 * t4478 + 0.3e1 * t290 * t4467 + 0.3e1 * t290 * t4474 - t308 * t4497 - t308 * t4511 + 0.2e1 * t780 * t4484 - 0.3e1 * t960 * t4491;
  t4514 = -0.6e1 * t742 * t1327 * t433 - 0.6e1 * t742 * t1334 * t433 - 0.6e1 * t742 * t421 * t1354 - 0.12e2 * t3732 * t1338 - 0.6e1 * t1940 * t4436 + 0.12e2 * t2539 * t4447 + 0.6e1 * t373 * t4433 + 0.6e1 * t737 * t4439 + 0.12e2 * t737 * t4442 + 0.6e1 * t955 * t4460 + t4513;
  t4518 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4514);
  tv3sigmatau28 = t7 * t4518;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4519 = t1362 * t396;
  t4520 = t4519 * t79;
  t4523 = t1363 * t409;
  t4526 = t397 * t1377;
  t4538 = 0.1e1 / t527;
  t4540 = 0.48e2 * t4538 * t67;
  t4541 = t1558 * t4538;
  t4543 = t1579 * t4538;
  t4545 = t4540 - 0.144e3 * t4541 + 0.96e2 * t4543;
  t4546 = t86 * t4545;
  t4549 = t1381 * t409;
  t4550 = t86 * t4549;
  t4560 = t75 * t4538;
  t4563 = t219 * t4538;
  t4566 = t573 * t4538;
  t4569 = t1604 * t4538;
  t4572 = 0.768e4 * t1621 * t4560 - 0.48e3 * t1648 * t4538 + 0.48384e5 * t214 * t4566 - 0.3456e5 * t562 * t4563 - 0.21504e5 * t72 * t4569 + t4540 - 0.432e3 * t4541 + 0.864e3 * t4543;
  t4573 = t86 * t4572;
  t4575 = -0.9e1 * t503 * t1378 * t409 + 0.18e2 * t1542 * t397 * t1381 - 0.9e1 * t503 * t397 * t1398 + 0.6e1 * t541 * t410 * t1398 - 0.6e1 * t1505 * t4550 - 0.18e2 * t1526 * t4523 + 0.3e1 * t188 * t4546 - t206 * t4573 + 0.6e1 * t4520 * t86 + 0.18e2 * t498 * t4526;
  t4579 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4575);
  tv3tau30 = t7 * t4579;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4580 = t1406 * t420;
  t4581 = t4580 * t144;
  t4584 = t1407 * t433;
  t4587 = t421 * t1421;
  t4599 = 0.1e1 / t766;
  t4601 = 0.48e2 * t4599 * t132;
  t4602 = t2010 * t4599;
  t4604 = t2019 * t4599;
  t4606 = t4601 - 0.144e3 * t4602 + 0.96e2 * t4604;
  t4607 = t151 * t4606;
  t4610 = t1425 * t433;
  t4611 = t151 * t4610;
  t4621 = t140 * t4599;
  t4624 = t321 * t4599;
  t4627 = t812 * t4599;
  t4630 = t2003 * t4599;
  t4633 = -0.21504e5 * t137 * t4630 + 0.768e4 * t1994 * t4621 - 0.48e3 * t2047 * t4599 + 0.48384e5 * t316 * t4627 - 0.3456e5 * t801 * t4624 + t4601 - 0.432e3 * t4602 + 0.864e3 * t4604;
  t4634 = t151 * t4633;
  t4636 = -0.9e1 * t742 * t1422 * t433 + 0.18e2 * t1977 * t421 * t1425 - 0.9e1 * t742 * t421 * t1442 + 0.6e1 * t780 * t434 * t1442 + 0.6e1 * t4581 * t151 - 0.18e2 * t1940 * t4584 - 0.6e1 * t1958 * t4611 + 0.3e1 * t290 * t4607 - t308 * t4634 + 0.18e2 * t737 * t4587;
  t4640 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4636);
  tv3tau33 = t7 * t4640;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t42;
  double t43, t47, t49, t50, t52, t53, t54, t56;
  double t57, t58, t59, t62, t63, t64, t65, t66;
  double t67, t70, t72, t73, t75, t78, t79, t80;
  double t81, t86, t88, t92, t93, t94, t96, t97;
  double t98, t99, t101, t102, t103, t104, t105, t107;
  double t108, t110, t111, t115, t117, t118, t120, t121;
  double t122, t123, t124, t127, t128, t129, t130, t131;
  double t132, t135, t137, t138, t140, t143, t144, t145;
  double t146, t151, t153, t157, tzk0;

  double t158, t159, t160, t162, t165, t166, t170, t171;
  double t172, t175, t176, t177, t179, t180, t181, t182;
  double t184, t185, t186, t188, t189, t190, t194, t197;
  double t200, t201, t204, t205, t206, t209, t210, t214;
  double t215, t219, t220, t224, t225, t227, t229, t230;
  double t233, t235, t240, t241, t243, t246, t247, t251;
  double t254, t256, tvrho0, t260, t263, t264, t269, t271;
  double t274, t275, t279, t281, t282, t283, t284, t286;
  double t287, t288, t290, t291, t292, t296, t299, t302;
  double t303, t306, t307, t308, t311, t312, t316, t317;
  double t321, t322, t326, t327, t329, t331, t332, t335;
  double t337, t342, tvrho1, t345, t346, t348, t349, t352;
  double t354, t355, t357, t358, t362, t364, t368, tvsigma0;
  double tvsigma1, t369, t370, t372, t373, t376, t378, t379;
  double t381, t382, t386, t388, t392, tvsigma2, tvlapl0, tvlapl1;
  double t394, t396, t397, t403, t406, t409, t410, t412;
  double t416, tvtau0, t418, t420, t421, t427, t430, t433;
  double t434, t436, t440, tvtau1;

  double t443, t444, t445, t448, t449, t450, t453, t457;
  double t458, t462, t464, t470, t471, t474, t476, t480;
  double t481, t483, t484, t485, t486, t487, t489, t490;
  double t492, t494, t495, t497, t498, t499, t500, t503;
  double t507, t510, t513, t514, t515, t518, t522, t525;
  double t526, t527, t529, t530, t535, t536, t540, t541;
  double t542, t543, t546, t556, t557, t562, t563, t566;
  double t572, t573, t574, t581, t586, t587, t592, t594;
  double t599, t600, t601, t602, t605, t608, t612, t613;
  double t617, t619, t621, t624, t626, tv2rho20, t629, t633;
  double t637, t638, t642, t644, t652, t653, t657, t661;
  double t662, t666, t668, t675, t678, tv2rho21, t683, t688;
  double t692, t693, t699, t700, t705, t709, t710, t721;
  double t722, t723, t724, t725, t726, t728, t729, t731;
  double t733, t734, t736, t737, t738, t739, t742, t746;
  double t749, t752, t753, t754, t757, t761, t764, t765;
  double t766, t768, t769, t774, t775, t779, t780, t781;
  double t782, t785, t795, t796, t801, t802, t805, t811;
  double t812, t813, t820, t825, t826, t831, t833, t838;
  double tv2rho22, t846, t847, t849, t851, t853, t854, t856;
  double t857, t858, t859, t862, t863, t864, t867, t870;
  double t871, t874, t875, t878, t887, t889, t890, t892;
  double t894, t897, t899, t901, t903, t904, t906, t907;
  double t909, t918, t920, t925, tv2rhosigma0, tv2rhosigma1, t932, t934;
  double tv2rhosigma2, t940, tv2rhosigma3, tv2rhosigma4, t945, t947, t949, t951;
  double t952, t954, t955, t956, t957, t960, t961, t962;
  double t965, t968, t969, t972, t973, t976, t985, t987;
  double t988, t990, t992, t995, t997, t999, t1001, t1002;
  double t1004, t1005, t1007, t1016, t1018, t1023, tv2rhosigma5, tv2rholapl0;
  double tv2rholapl1, tv2rholapl2, tv2rholapl3, t1030, t1034, t1037, t1043, t1044;
  double t1048, t1049, t1051, t1054, t1055, t1064, t1078, t1086;
  double t1090, t1093, t1094, t1096, t1101, tv2rhotau0, t1108, t1110;
  double tv2rhotau1, t1116, tv2rhotau2, t1124, t1127, t1133, t1134, t1138;
  double t1139, t1141, t1144, t1145, t1154, t1168, t1176, t1180;
  double t1183, t1184, t1186, t1191, tv2rhotau3, t1193, t1194, t1195;
  double t1197, t1200, t1201, t1204, t1208, t1211, t1212, t1215;
  double t1218, t1220, t1221, t1223, t1224, t1228, t1230, t1234;
  double tv2sigma20, tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1235, t1236, t1238;
  double t1241, t1242, t1245, t1249, t1252, t1253, t1256, t1259;
  double t1261, t1262, t1264, t1265, t1269, t1271, t1275, tv2sigma25;
  double tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1276, t1277;
  double t1278, t1281, t1284, t1287, t1288, t1290, t1291, t1294;
  double t1295, t1301, t1304, t1306, t1307, t1309, t1311, t1312;
  double t1314, t1318, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1319;
  double t1320, t1321, t1324, t1327, t1330, t1331, t1333, t1334;
  double t1337, t1338, t1344, t1347, t1349, t1350, t1352, t1354;
  double t1355, t1357, t1361, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0;
  double tv2lapltau1, tv2lapltau2, tv2lapltau3, t1362, t1363, t1366, t1370, t1373;
  double t1375, t1377, t1378, t1381, t1382, t1389, t1392, t1395;
  double t1398, t1399, t1401, t1405, tv2tau20, tv2tau21, t1406, t1407;
  double t1410, t1414, t1417, t1419, t1421, t1422, t1425, t1426;
  double t1433, t1436, t1439, t1442, t1443, t1445, t1449, tv2tau22;

  double t1453, t1454, t1457, t1460, t1461, t1462, t1465, t1469;
  double t1470, t1474, t1476, t1481, t1483, t1486, t1492, t1493;
  double t1496, t1498, t1501, t1503, t1504, t1505, t1506, t1507;
  double t1513, t1515, t1516, t1517, t1518, t1519, t1520, t1521;
  double t1522, t1523, t1525, t1526, t1542, t1546, t1550, t1555;
  double t1558, t1559, t1560, t1563, t1564, t1567, t1570, t1573;
  double t1576, t1579, t1580, t1581, t1582, t1585, t1590, t1591;
  double t1604, t1605, t1609, t1610, t1621, t1622, t1629, t1634;
  double t1645, t1648, t1660, t1663, t1664, t1667, t1670, t1672;
  double t1674, t1675, t1677, t1678, t1680, t1687, t1689, t1690;
  double t1695, t1697, t1698, t1701, t1704, t1707, t1711, t1712;
  double t1716, t1718, t1720, t1722, t1724, t1727, t1729, tv3rho30;
  double t1732, t1733, t1734, t1737, t1742, t1743, t1745, t1749;
  double t1750, t1754, t1757, t1761, t1763, t1767, t1776, t1777;
  double t1778, t1781, t1786, t1788, t1792, t1793, t1797, t1800;
  double t1801, t1803, t1812, t1814, t1817, tv3rho31, t1820, t1825;
  double t1829, t1833, t1834, t1838, t1840, t1849, t1850, t1855;
  double t1859, t1863, t1864, t1868, t1870, t1877, t1885, t1887;
  double t1888, tv3rho32, t1893, t1900, t1904, t1905, t1912, t1913;
  double t1920, t1924, t1925, t1940, t1956, t1957, t1958, t1959;
  double t1960, t1966, t1968, t1969, t1970, t1971, t1972, t1973;
  double t1974, t1976, t1977, t1991, t1994, t1995, t2003, t2004;
  double t2005, t2006, t2010, t2011, t2012, t2015, t2016, t2019;
  double t2020, t2021, t2024, t2027, t2032, t2041, t2044, t2047;
  double t2048, t2053, t2056, t2066, t2069, t2070, t2073, t2076;
  double t2079, t2084, t2101, t2102, t2105, t2107, t2109, t2110;
  double t2112, t2113, t2115, t2122, t2124, t2125, t2130, tv3rho33;
  double t2138, t2145, t2147, t2149, t2152, t2158, t2163, t2165;
  double t2167, t2168, t2169, t2171, t2172, t2174, t2175, t2177;
  double t2178, t2180, t2181, t2183, t2186, t2188, t2191, t2194;
  double t2196, t2198, t2200, t2202, t2204, t2205, t2207, t2208;
  double t2210, t2213, t2222, t2223, t2225, t2226, t2228, t2247;
  double t2249, t2253, t2256, t2260, t2262, t2263, t2265, t2266;
  double t2271, t2276, t2277, t2280, t2281, t2282, t2285, t2288;
  double t2289, t2294, t2295, t2298, t2299, t2302, t2303, t2304;
  double t2307, t2310, t2311, t2314, t2317, t2320, t2323, t2324;
  double t2327, t2336, t2338, t2339, t2340, t2341, t2344, t2345;
  double t2346, t2347, t2350, t2351, t2352, t2355, t2357, t2362;
  double tv3rho2sigma0, tv3rho2sigma1, t2369, t2373, t2375, tv3rho2sigma2, t2381, t2389;
  double tv3rho2sigma3, tv3rho2sigma4, t2395, t2402, t2405, tv3rho2sigma5, t2413, tv3rho2sigma6;
  double tv3rho2sigma7, t2427, t2430, t2433, t2439, t2441, t2443, t2446;
  double t2448, t2449, t2450, t2452, t2453, t2455, t2456, t2458;
  double t2459, t2461, t2462, t2464, t2467, t2469, t2472, t2475;
  double t2477, t2479, t2481, t2483, t2485, t2486, t2488, t2489;
  double t2497, t2519, t2521, t2522, t2524, t2525, t2527, t2528;
  double t2533, t2534, t2537, t2539, t2540, t2541, t2546, t2549;
  double t2552, t2553, t2556, t2557, t2560, t2561, t2564, t2567;
  double t2570, t2571, t2574, t2577, t2578, t2581, t2582, t2587;
  double t2588, t2591, t2594, t2598, t2600, t2601, t2602, t2611;
  double t2613, t2614, t2615, t2616, t2619, t2620, t2621, t2622;
  double t2625, t2626, t2627, t2630, t2632, t2637, tv3rho2sigma8, tv3rho2lapl0;
  double tv3rho2lapl1, tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2644, t2651, t2653;
  double t2673, t2676, t2684, t2685, t2690, t2692, t2693, t2694;
  double t2697, t2698, t2700, t2704, t2705, t2708, t2710, t2720;
  double t2734, t2741, t2748, t2755, t2773, t2774, t2775, t2777;
  double t2781, t2782, t2783, t2792, t2793, t2804, t2816, t2817;
  double t2822, tv3rho2tau0, t2829, t2833, t2835, tv3rho2tau1, t2841, t2849;
  double tv3rho2tau2, t2855, t2862, t2865, tv3rho2tau3, t2873, tv3rho2tau4, t2910;
  double t2919, t2923, t2926, t2934, t2935, t2940, t2942, t2943;
  double t2944, t2947, t2948, t2950, t2954, t2955, t2958, t2960;
  double t2971, t2978, t2991, t3000, t3002, t3023, t3024, t3025;
  double t3027, t3028, t3029, t3038, t3039, t3045, t3046, t3051;
  double tv3rho2tau5, t3058, t3063, t3064, t3065, t3066, t3069, t3073;
  double t3075, t3076, t3103, t3104, t3109, t3114, t3115, t3118;
  double t3121, t3122, t3125, t3128, t3131, t3132, t3135, t3136;
  double t3141, t3144, t3145, t3148, t3151, t3156, t3157, t3161;
  double t3164, t3169, t3172, t3175, t3178, t3180, t3182, t3184;
  double t3187, t3189, t3191, t3193, t3194, t3196, t3197, t3199;
  double t3202, t3203, t3204, t3207, t3208, t3211, t3213, t3218;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t3225, t3227, tv3rhosigma25;
  double t3233, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t3257, t3258;
  double t3259, t3260, t3262, t3273, t3275, t3278, t3283, t3288;
  double t3289, t3292, t3295, t3296, t3299, t3300, t3303, t3308;
  double t3310, t3311, t3316, t3319, t3320, t3323, t3326, t3331;
  double t3332, t3335, t3339, t3340, t3343, t3345, t3347, t3350;
  double t3352, t3354, t3356, t3357, t3359, t3360, t3362, t3367;
  double t3370, t3373, t3376, t3378, t3381, t3382, t3383, t3386;
  double t3387, t3390, t3392, t3397, tv3rhosigma211, tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2;
  double tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7, tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10;
  double tv3rhosigmalapl11, t3404, t3447, t3448, t3451, t3454, t3455, t3458;
  double t3459, t3466, t3467, t3468, t3471, t3472, t3477, t3478;
  double t3481, t3482, t3485, t3486, t3489, t3492, t3494, t3496;
  double t3497, t3500, t3502, t3506, t3508, t3510, t3514, t3517;
  double t3519, t3521, t3522, t3524, t3527, t3531, t3532, t3537;
  double t3538, t3541, t3543, t3545, t3548, t3551, t3554, t3557;
  double t3560, t3563, t3564, t3569, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2, tv3rhosigmatau3;
  double tv3rhosigmatau4, t3576, t3578, tv3rhosigmatau5, t3584, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, t3631, t3632, t3633, t3636, t3637, t3640;
  double t3643, t3645, t3646, t3649, t3651, t3655, t3657, t3659;
  double t3663, t3666, t3668, t3670, t3671, t3673, t3675, t3677;
  double t3678, t3681, t3684, t3688, t3689, t3694, t3695, t3698;
  double t3700, t3705, t3706, t3709, t3710, t3713, t3714, t3717;
  double t3724, t3725, t3728, t3729, t3732, t3735, t3738, t3741;
  double t3744, t3747, t3748, t3753, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21, tv3rholapl22;
  double tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3, tv3rholapltau4;
  double tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t3760, t3763, t3766, t3769, t3772;
  double t3773, t3776, t3795, t3799, t3800, t3803, t3805, t3806;
  double t3809, t3810, t3812, t3815, t3816, t3825, t3837, t3854;
  double t3862, t3870, t3876, t3877, t3879, t3880, t3885, tv3rhotau20;
  double tv3rhotau21, t3892, t3894, tv3rhotau22, t3900, tv3rhotau23, tv3rhotau24, t3907;
  double t3910, t3913, t3916, t3917, t3920, t3939, t3943, t3944;
  double t3947, t3949, t3950, t3953, t3954, t3956, t3959, t3960;
  double t3969, t3981, t3998, t4006, t4014, t4020, t4021, t4023;
  double t4024, t4029, tv3rhotau25, t4031, t4032, t4035, t4036, t4048;
  double t4051, t4054, t4057, t4059, t4061, t4064, t4067, t4070;
  double t4074, t4075, t4077, t4078, t4082, t4083, t4086, t4087;
  double t4090, t4094, t4098, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34;
  double tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t4099, t4100, t4102, t4105;
  double t4108, t4112, t4113, t4115, t4116, t4118, t4122, t4123;
  double t4130, t4131, t4139, t4142, t4145, t4150, t4152, t4153;
  double t4158, t4159, t4162, t4166, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2;
  double tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5, tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10;
  double tv3sigma2lapl11, t4169, t4170, t4175, t4176, t4179, t4182, t4185;
  double t4187, t4191, t4193, t4194, t4196, t4198, t4199, t4208;
  double t4228, t4229, t4235, t4236, t4242, t4243, t4246, t4247;
  double t4248, t4251, t4252, t4256, tv3sigma2tau0, tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3;
  double tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8, tv3sigma2tau9, tv3sigma2tau10, t4270;
  double t4271, t4277, t4278, t4286, t4287, t4292, t4293, t4296;
  double t4297, t4300, t4303, t4305, t4309, t4311, t4312, t4314;
  double t4316, t4317, t4332, t4333, t4336, t4337, t4338, t4341;
  double t4342, t4346, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23, tv3sigmalapl24;
  double tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2, tv3sigmalapltau3;
  double tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10, tv3sigmalapltau11;
  double t4347, t4350, t4353, t4356, t4361, t4373, t4374, t4381;
  double t4385, t4387, t4388, t4391, t4392, t4398, t4404, t4405;
  double t4411, t4415, t4417, t4418, t4420, t4422, t4424, t4425;
  double t4427, t4428, t4432, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23, tv3sigmatau24;
  double tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t4433, t4436, t4439, t4442, t4447;
  double t4459, t4460, t4467, t4471, t4473, t4474, t4477, t4478;
  double t4484, t4490, t4491, t4497, t4501, t4503, t4504, t4506;
  double t4508, t4510, t4511, t4513, t4514, t4518, tv3sigmatau28, tv3lapl30;
  double tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3, tv3lapl2tau4;
  double tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25, t4519;
  double t4520, t4523, t4526, t4538, t4540, t4541, t4543, t4545;
  double t4546, t4549, t4550, t4560, t4563, t4566, t4569, t4572;
  double t4573, t4575, t4579, tv3tau30, tv3tau31, tv3tau32, t4580, t4581;
  double t4584, t4587, t4599, t4601, t4602, t4604, t4606, t4607;
  double t4610, t4611, t4621, t4624, t4627, t4630, t4633, t4634;
  double t4636, t4640, tv3tau33;

  double t4645, t4649, t4653, t4656, t4660, t4662, t4668, t4670;
  double t4676, t4679, t4682, t4689, t4690, t4695, t4698, t4700;
  double t4705, t4709, t4710, t4716, t4718, t4720, t4722, t4724;
  double t4727, t4754, t4757, t4761, t4765, t4769, t4772, t4775;
  double t4778, t4781, t4784, t4785, t4791, t4796, t4798, t4804;
  double t4811, t4814, t4839, t4840, t4843, t4847, t4850, t4855;
  double t4856, t4863, t4869, t4870, t4876, t4908, t4913, t4932;
  double t4957, t4974, t4980, t4984, t4988, t4993, t4994, t5001;
  double t5007, t5009, t5010, t5016, t5022, t5023, t5026, t5030;
  double t5038, t5039, t5040, t5042, t5043, t5049, t5054, t5057;
  double t5061, t5068, t5072, t5076, t5081, t5083, tv4rho40, t5090;
  double t5094, t5095, t5098, t5119, t5120, t5122, t5126, t5135;
  double t5141, t5142, t5144, t5155, t5156, t5173, t5175, t5179;
  double t5186, t5190, t5191, t5194, t5203, t5206, t5207, t5209;
  double t5211, t5212, tv4rho41, t5221, t5225, t5240, t5253, t5257;
  double t5266, t5277, t5278, t5287, t5300, t5304, t5311, t5315;
  double t5324, t5327, t5338, t5341, t5343, t5344, tv4rho42, t5365;
  double t5369, t5376, t5387, t5388, t5405, t5409, t5416, t5424;
  double t5433, t5443, t5445, t5446, tv4rho43, t5451, t5456, t5463;
  double t5467, t5476, t5485, t5488, t5490, t5494, t5497, t5500;
  double t5503, t5506, t5509, t5510, t5512, t5513, t5516, t5523;
  double t5526, t5529, t5532, t5535, t5538, t5550, t5551, t5558;
  double t5568, t5576, t5581, t5587, t5589, t5596, t5601, t5611;
  double t5650, t5672, t5678, t5679, t5685, t5689, t5694, t5696;
  double t5697, t5699, t5703, t5707, t5711, t5713, t5715, t5716;
  double t5732, t5770, t5771, t5776, t5778, t5784, t5795, t5809;
  double t5814, t5821, t5825, t5839, t5840, tv4rho44, t5848, t5854;
  double t5857, t5864, t5866, t5869, t5875, t5879, t5883, t5886;
  double t5890, t5892, t5894, t5896, t5941, t5957, t5971, t5975;
  double t5983, t5985, t5988, t6008, t6026, t6038, t6044, t6061;
  double t6067, t6070, t6082, t6086, t6089, t6090, t6112, t6116;
  double t6180, t6181, t6184, t6188, t6193, t6194, t6197, t6198;
  double t6234, t6244, t6281, t6289, t6293, t6309, t6310, t6324;
  double t6328, t6331, t6340, t6346, t6349, t6357, tv4rho3sigma0, tv4rho3sigma1;
  double t6364, t6367, t6371, t6373, tv4rho3sigma2, t6375, t6381, t6386;
  double t6390, t6399, t6400, tv4rho3sigma3, tv4rho3sigma4, t6402, t6408, t6410;
  double t6419, t6421, t6424, tv4rho3sigma5, t6430, t6439, tv4rho3sigma6, tv4rho3sigma7;
  double t6445, t6452, t6460, t6462, t6463, tv4rho3sigma8, t6472, tv4rho3sigma9;
  double tv4rho3sigma10, t6493, t6497, t6501, t6504, t6508, t6510, t6512;
  double t6514, t6535, t6543, t6544, t6547, t6548, t6551, t6552;
  double t6561, t6564, t6571, t6578, t6614, t6635, t6646, t6654;
  double t6657, t6661, t6681, t6687, t6698, t6711, t6721, t6730;
  double t6734, t6740, t6741, t6746, t6765, t6810, t6852, t6853;
  double t6859, t6869, t6870, t6876, t6879, t6891, t6895, t6918;
  double t6919, t6967, t6975, tv4rho3sigma11, tv4rho3lapl0, tv4rho3lapl1, tv4rho3lapl2, tv4rho3lapl3;
  double tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6, tv4rho3lapl7, t6982, t6988, t6991, t6998;
  double t7000, t7003, t7020, t7024, t7025, t7032, t7034, t7036;
  double t7038, t7039, t7042, t7047, t7048, t7051, t7052, t7058;
  double t7086, t7094, t7097, t7099, t7114, t7136, t7156, t7169;
  double t7203, t7246, t7250, t7261, t7268, t7282, t7303, t7347;
  double t7354, tv4rho3tau0, t7361, t7364, t7368, t7370, tv4rho3tau1, t7372;
  double t7378, t7383, t7387, t7396, t7397, tv4rho3tau2, t7399, t7405;
  double t7407, t7416, t7418, t7421, tv4rho3tau3, t7427, t7436, tv4rho3tau4;
  double t7442, t7449, t7457, t7459, t7460, tv4rho3tau5, t7469, tv4rho3tau6;
  double t7510, t7518, t7519, t7528, t7533, t7535, t7537, t7539;
  double t7542, t7549, t7552, t7553, t7556, t7563, t7588, t7602;
  double t7622, t7624, t7628, t7647, t7661, t7683, t7729, t7774;
  double t7784, t7788, t7795, t7813, t7826, t7833, tv4rho3tau7, t7840;
  double t7847, t7849, t7874, t7875, t7885, t7892, t7899, t7905;
  double t7907, t7929, t7952, t8005, t8031, t8033, t8034, t8036;
  double t8060, t8081, t8082, t8088, t8094, t8118, t8122, t8123;
  double t8144, t8148, t8160, t8161, t8164, t8172, t8181, t8194;
  double t8219, t8220, t8221, t8234, t8238, t8246, t8318, t8321;
  double t8329, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t8336, t8340;
  double t8342, tv4rho2sigma25, t8348, t8356, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29;
  double tv4rho2sigma210, t8362, t8369, t8372, tv4rho2sigma211, t8380, tv4rho2sigma212, tv4rho2sigma213;
  double tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t8397, t8400, t8428, t8459, t8475;
  double t8478, t8516, t8522, t8526, t8528, t8531, t8535, t8536;
  double t8539, t8544, t8567, t8568, t8574, t8580, t8585, t8607;
  double t8608, t8609, t8643, t8699, t8747, t8748, t8753, t8763;
  double t8792, t8794, t8795, t8797, t8801, t8809, t8812, t8837;
  double t8861, t8869, tv4rho2sigma217, tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4;
  double tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7, tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11, tv4rho2sigmalapl12;
  double tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15, tv4rho2sigmalapl16, tv4rho2sigmalapl17, t8876, t8883, t8885;
  double t8937, t8992, t9024, t9032, t9036, t9045, t9049, t9053;
  double t9078, t9093, t9101, t9110, t9113, t9131, t9137, t9145;
  double t9151, t9160, t9168, t9174, t9199, t9203, t9214, t9217;
  double t9219, t9225, t9256, t9293, t9318, t9331, t9353, t9356;
  double t9370, t9378, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3, tv4rho2sigmatau4, t9385;
  double t9389, t9391, tv4rho2sigmatau5, t9397, t9405, tv4rho2sigmatau6, tv4rho2sigmatau7, tv4rho2sigmatau8;
  double tv4rho2sigmatau9, tv4rho2sigmatau10, t9411, t9418, t9421, tv4rho2sigmatau11, t9429, tv4rho2sigmatau12;
  double tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, t9491, t9534, t9544, t9546;
  double t9555, t9569, t9575, t9581, t9590, t9598, t9639, t9660;
  double t9687, t9737, t9741, t9754, t9761, t9768, t9772, t9797;
  double t9799, t9802, t9817, t9850, t9856, t9866, t9867, t9877;
  double t9878, t9884, t9890, t9911, t9924, t9932, tv4rho2sigmatau17, tv4rho2lapl20;
  double tv4rho2lapl21, tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26, tv4rho2lapl27, tv4rho2lapl28;
  double tv4rho2lapltau0, tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7;
  double tv4rho2lapltau8, tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, t9939, t9946, t9948, t9950;
  double t9952, t9964, t9968, t9969, t9972, t9974, t9983, t9985;
  double t9988, t9993, t9994, t10022, t10029, t10040, t10043, t10050;
  double t10066, t10091, t10095, t10104, t10108, t10112, t10165, t10213;
  double t10265, t10272, tv4rho2tau20, tv4rho2tau21, t10279, t10283, t10285, tv4rho2tau22;
  double t10291, t10299, tv4rho2tau23, tv4rho2tau24, t10305, t10312, t10315, tv4rho2tau25;
  double t10323, tv4rho2tau26, tv4rho2tau27, t10380, t10432, t10465, t10471, t10475;
  double t10484, t10501, t10505, t10530, t10531, t10538, t10539, t10546;
  double t10550, t10568, t10580, t10585, t10589, t10590, t10592, t10597;
  double t10599, t10601, t10610, t10630, t10646, t10650, t10657, tv4rho2tau28;
  double t10664, t10701, t10729, t10735, t10737, t10747, t10783, t10804;
  double t10807, t10814, t10855, t10884, t10885, t10891, t10895, t10913;
  double t10922, t10966, t10974, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33, tv4rhosigma34;
  double tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t10981, t10983, tv4rhosigma39, t10989;
  double tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317;
  double tv4rhosigma318, t10997, t11003, t11005, t11034, t11058, t11061, t11068;
  double t11105, t11155, t11183, t11188, t11210, t11211, t11223, t11227;
  double t11257, t11295, t11303, tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3;
  double tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11;
  double tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19;
  double tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, tv4rhosigma2lapl23, t11310, t11327, t11332, t11343;
  double t11361, t11409, t11414, t11425, t11438, t11472, t11478, t11479;
  double t11488, t11497, t11525, t11532, t11542, t11554, t11558, t11562;
  double t11579, t11586, t11601, t11631, t11685, t11723, t11731, t11738;
  double t11746, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6;
  double tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, t11753, t11755, tv4rhosigma2tau11, t11761;
  double tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19;
  double tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, t11767, t11775, t11779, t11811, t11863;
  double t11867, t11873, t11900, t11906, t11910, t11957, t12001, t12008;
  double t12012, t12024, t12040, t12047, t12054, t12061, t12068, t12076;
  double t12119, t12137, t12150, t12178, t12182, t12193, t12201, tv4rhosigma2tau23;
  double tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25, tv4rhosigmalapl26, tv4rhosigmalapl27;
  double tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213, tv4rhosigmalapl214, tv4rhosigmalapl215;
  double tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3, tv4rhosigmalapltau4, tv4rhosigmalapltau5;
  double tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11, tv4rhosigmalapltau12, tv4rhosigmalapltau13;
  double tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19, tv4rhosigmalapltau20, tv4rhosigmalapltau21;
  double tv4rhosigmalapltau22, tv4rhosigmalapltau23, t12208, t12210, t12212, t12214, t12215, t12259;
  double t12279, t12287, t12296, t12305, t12316, t12323, t12327, t12339;
  double t12346, t12363, t12367, t12371, t12378, t12385, t12395, t12414;
  double t12454, t12497, t12542, t12590, t12598, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22;
  double tv4rhosigmatau23, tv4rhosigmatau24, tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, t12605, t12607, tv4rhosigmatau28;
  double t12613, tv4rhosigmatau29, tv4rhosigmatau210, tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215;
  double tv4rhosigmatau216, t12621, t12632, t12648, t12651, t12660, t12667, t12679;
  double t12686, t12694, t12709, t12716, t12723, t12730, t12740, t12766;
  double t12768, t12770, t12771, t12792, t12834, t12875, t12912, t12932;
  double t12953, t12999, t13007, tv4rhosigmatau217, tv4rholapl30, tv4rholapl31, tv4rholapl32, tv4rholapl33;
  double tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37, tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3;
  double tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7, tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11;
  double tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23, tv4rholapltau24, tv4rholapltau25, tv4rholapltau26, tv4rholapltau27;
  double tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211, t13014, t13048, t13081, t13091;
  double t13095, t13102, t13109, t13113, t13120, t13124, t13136, t13139;
  double t13145, t13147, t13148, t13150, t13151, t13153, t13154, t13157;
  double t13158, t13160, t13184, t13188, t13196, t13204, t13218, t13222;
  double t13229, tv4rhotau30, tv4rhotau31, tv4rhotau32, t13236, t13238, tv4rhotau33, t13244;
  double tv4rhotau34, tv4rhotau35, tv4rhotau36, t13260, t13267, t13271, t13281, t13285;
  double t13289, t13296, t13303, t13305, t13306, t13308, t13309, t13311;
  double t13312, t13315, t13316, t13318, t13342, t13346, t13354, t13362;
  double t13376, t13380, t13383, t13386, t13421, t13456, t13463, tv4rhotau37;
  double t13466, t13468, t13509, t13513, t13517, t13575, t13580, tv4sigma40;
  double tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48;
  double tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t13590, t13591, t13604;
  double t13608, t13634, t13691, t13696, tv4sigma414, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2;
  double tv4sigma3lapl3, tv4sigma3lapl4, tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10;
  double tv4sigma3lapl11, tv4sigma3lapl12, tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18;
  double tv4sigma3lapl19, t13735, t13778, t13796, t13821, t13842, t13865, t13871;
  double tv4sigma3tau0, tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7;
  double tv4sigma3tau8, tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15;
  double tv4sigma3tau16, tv4sigma3tau17, tv4sigma3tau18, t13911, t13953, t13971, t13997, t14003;
  double t14040, t14046, tv4sigma3tau19, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24;
  double tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212;
  double tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2;
  double tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10;
  double tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18;
  double tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, t14047, t14051, t14099;
  double t14152, t14204, t14258, t14264, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22, tv4sigma2tau23;
  double tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210, tv4sigma2tau211;
  double tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, t14265, t14269, t14317;
  double t14368, t14422, t14476, t14482, tv4sigma2tau217, tv4sigmalapl30, tv4sigmalapl31, tv4sigmalapl32;
  double tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38, tv4sigmalapl39, tv4sigmalapl310;
  double tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4, tv4sigmalapl2tau5, tv4sigmalapl2tau6;
  double tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12, tv4sigmalapl2tau13, tv4sigmalapl2tau14;
  double tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22, tv4sigmalapltau23, tv4sigmalapltau24;
  double tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210, tv4sigmalapltau211, tv4sigmalapltau212;
  double tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, t14512, t14546, t14584;
  double t14605, t14634, t14640, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34;
  double tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, t14670, t14704;
  double t14733, t14753, t14792, t14798, tv4sigmatau311, tv4lapl40, tv4lapl41, tv4lapl42;
  double tv4lapl43, tv4lapl44, tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5;
  double tv4lapl3tau6, tv4lapl3tau7, tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25;
  double tv4lapl2tau26, tv4lapl2tau27, tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34;
  double tv4lapltau35, tv4lapltau36, tv4lapltau37, t14799, t14801, t14803, t14836, t14855;
  double t14862, t14884, t14888, tv4tau40, tv4tau41, tv4tau42, tv4tau43, t14889;
  double t14896, t14906, t14925, t14927, t14929, t14974, t14978, tv4tau44;

  mgga_x_msb_params *params;

  assert(p->params != NULL);
  params = (mgga_x_msb_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = M_CBRT6;
  t30 = M_PI * M_PI;
  t31 = POW_1_3(t30);
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t29 * t33;
  t35 = rho[0] * rho[0];
  t36 = POW_1_3(rho[0]);
  t37 = t36 * t36;
  t39 = 0.1e1 / t37 / t35;
  t40 = sigma[0] * t39;
  t42 = 0.5e1 / 0.972e3 * t34 * t40;
  t43 = params->kappa + t42;
  t47 = params->kappa * (0.1e1 - params->kappa / t43);
  t49 = 0.1e1 / t37 / rho[0];
  t50 = tau[0] * t49;
  t52 = t50 - t40 / 0.8e1;
  t53 = t52 * t52;
  t54 = t29 * t29;
  t56 = 0.3e1 / 0.1e2 * t54 * t32;
  t57 = t50 + t56;
  t58 = t57 * t57;
  t59 = 0.1e1 / t58;
  t62 = -0.4e1 * t53 * t59 + 0.1e1;
  t63 = t62 * t62;
  t64 = t63 * t62;
  t65 = t53 * t52;
  t66 = t58 * t57;
  t67 = 0.1e1 / t66;
  t70 = t53 * t53;
  t72 = params->b * t70 * t53;
  t73 = t58 * t58;
  t75 = 0.1e1 / t73 / t58;
  t78 = 0.8e1 * t65 * t67 + 0.64e2 * t72 * t75 + 0.1e1;
  t79 = 0.1e1 / t78;
  t80 = t64 * t79;
  t81 = params->kappa + t42 + params->c;
  t86 = params->kappa * (0.1e1 - params->kappa / t81) - t47;
  t88 = t80 * t86 + t47 + 0.1e1;
  t92 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t88);
  t93 = rho[1] <= p->dens_threshold;
  t94 = -t17;
  t96 = my_piecewise5(t15, t12, t11, t16, t94 * t8);
  t97 = 0.1e1 + t96;
  t98 = t97 <= p->zeta_threshold;
  t99 = POW_1_3(t97);
  t101 = my_piecewise3(t98, t23, t99 * t97);
  t102 = t101 * t27;
  t103 = rho[1] * rho[1];
  t104 = POW_1_3(rho[1]);
  t105 = t104 * t104;
  t107 = 0.1e1 / t105 / t103;
  t108 = sigma[2] * t107;
  t110 = 0.5e1 / 0.972e3 * t34 * t108;
  t111 = params->kappa + t110;
  t115 = params->kappa * (0.1e1 - params->kappa / t111);
  t117 = 0.1e1 / t105 / rho[1];
  t118 = tau[1] * t117;
  t120 = t118 - t108 / 0.8e1;
  t121 = t120 * t120;
  t122 = t118 + t56;
  t123 = t122 * t122;
  t124 = 0.1e1 / t123;
  t127 = -0.4e1 * t121 * t124 + 0.1e1;
  t128 = t127 * t127;
  t129 = t128 * t127;
  t130 = t121 * t120;
  t131 = t123 * t122;
  t132 = 0.1e1 / t131;
  t135 = t121 * t121;
  t137 = params->b * t135 * t121;
  t138 = t123 * t123;
  t140 = 0.1e1 / t138 / t123;
  t143 = 0.8e1 * t130 * t132 + 0.64e2 * t137 * t140 + 0.1e1;
  t144 = 0.1e1 / t143;
  t145 = t129 * t144;
  t146 = params->kappa + t110 + params->c;
  t151 = params->kappa * (0.1e1 - params->kappa / t146) - t115;
  t153 = t145 * t151 + t115 + 0.1e1;
  t157 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t153);
  tzk0 = t92 + t157;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t158 = t7 * t7;
  t159 = 0.1e1 / t158;
  t160 = t17 * t159;
  t162 = my_piecewise5(t11, 0, t15, 0, t8 - t160);
  t165 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t162);
  t166 = t165 * t27;
  t170 = t27 * t27;
  t171 = 0.1e1 / t170;
  t172 = t26 * t171;
  t175 = t6 * t172 * t88 / 0.8e1;
  t176 = params->kappa * params->kappa;
  t177 = t43 * t43;
  t179 = t176 / t177;
  t180 = t179 * t29;
  t181 = t33 * sigma[0];
  t182 = t35 * rho[0];
  t184 = 0.1e1 / t37 / t182;
  t185 = t181 * t184;
  t186 = t180 * t185;
  t188 = t63 * t79;
  t189 = t52 * t59;
  t190 = tau[0] * t39;
  t194 = -0.5e1 / 0.3e1 * t190 + sigma[0] * t184 / 0.3e1;
  t197 = t53 * t67;
  t200 = -0.8e1 * t189 * t194 - 0.4e2 / 0.3e1 * t197 * t190;
  t201 = t86 * t200;
  t204 = t78 * t78;
  t205 = 0.1e1 / t204;
  t206 = t64 * t205;
  t209 = 0.1e1 / t73;
  t210 = t65 * t209;
  t214 = params->b * t70 * t52;
  t215 = t75 * t194;
  t219 = 0.1e1 / t73 / t66;
  t220 = t219 * tau[0];
  t224 = 0.64e3 * t72 * t220 * t39 + 0.4e2 * t210 * t190 + 0.24e2 * t197 * t194 + 0.384e3 * t214 * t215;
  t225 = t86 * t224;
  t227 = t81 * t81;
  t229 = t176 / t227;
  t230 = t229 * t29;
  t233 = -0.1e2 / 0.729e3 * t230 * t185 + 0.1e2 / 0.729e3 * t186;
  t235 = -0.1e2 / 0.729e3 * t186 + 0.3e1 * t188 * t201 - t206 * t225 + t80 * t233;
  t240 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t88 - t175 - 0.3e1 / 0.8e1 * t6 * t28 * t235);
  t241 = t94 * t159;
  t243 = my_piecewise5(t15, 0, t11, 0, -t8 - t241);
  t246 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t243);
  t247 = t246 * t27;
  t251 = t101 * t171;
  t254 = t6 * t251 * t153 / 0.8e1;
  t256 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t153 - t254);
  tvrho0 = t92 + t157 + t7 * (t240 + t256);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t260 = my_piecewise5(t11, 0, t15, 0, -t8 - t160);
  t263 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t260);
  t264 = t263 * t27;
  t269 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t88 - t175);
  t271 = my_piecewise5(t15, 0, t11, 0, t8 - t241);
  t274 = my_piecewise3(t98, 0, 0.4e1 / 0.3e1 * t99 * t271);
  t275 = t274 * t27;
  t279 = t111 * t111;
  t281 = t176 / t279;
  t282 = t281 * t29;
  t283 = t33 * sigma[2];
  t284 = t103 * rho[1];
  t286 = 0.1e1 / t105 / t284;
  t287 = t283 * t286;
  t288 = t282 * t287;
  t290 = t128 * t144;
  t291 = t120 * t124;
  t292 = tau[1] * t107;
  t296 = -0.5e1 / 0.3e1 * t292 + sigma[2] * t286 / 0.3e1;
  t299 = t121 * t132;
  t302 = -0.8e1 * t291 * t296 - 0.4e2 / 0.3e1 * t299 * t292;
  t303 = t151 * t302;
  t306 = t143 * t143;
  t307 = 0.1e1 / t306;
  t308 = t129 * t307;
  t311 = 0.1e1 / t138;
  t312 = t130 * t311;
  t316 = params->b * t135 * t120;
  t317 = t140 * t296;
  t321 = 0.1e1 / t138 / t131;
  t322 = t321 * tau[1];
  t326 = 0.64e3 * t137 * t322 * t107 + 0.4e2 * t312 * t292 + 0.24e2 * t299 * t296 + 0.384e3 * t316 * t317;
  t327 = t151 * t326;
  t329 = t146 * t146;
  t331 = t176 / t329;
  t332 = t331 * t29;
  t335 = -0.1e2 / 0.729e3 * t332 * t287 + 0.1e2 / 0.729e3 * t288;
  t337 = -0.1e2 / 0.729e3 * t288 + 0.3e1 * t290 * t303 - t308 * t327 + t145 * t335;
  t342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t153 - t254 - 0.3e1 / 0.8e1 * t6 * t102 * t337);
  tvrho1 = t92 + t157 + t7 * (t269 + t342);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t345 = t34 * t39;
  t346 = t179 * t345;
  t348 = t188 * t86;
  t349 = t189 * t39;
  t352 = t197 * t39;
  t354 = t75 * t39;
  t355 = t214 * t354;
  t357 = -0.3e1 * t352 - 0.48e2 * t355;
  t358 = t86 * t357;
  t362 = 0.5e1 / 0.972e3 * t229 * t345 - 0.5e1 / 0.972e3 * t346;
  t364 = 0.5e1 / 0.972e3 * t346 + 0.3e1 * t348 * t349 - t206 * t358 + t80 * t362;
  t368 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t364);
  tvsigma0 = t7 * t368;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t369 = t34 * t107;
  t370 = t281 * t369;
  t372 = t290 * t151;
  t373 = t291 * t107;
  t376 = t299 * t107;
  t378 = t140 * t107;
  t379 = t316 * t378;
  t381 = -0.3e1 * t376 - 0.48e2 * t379;
  t382 = t151 * t381;
  t386 = 0.5e1 / 0.972e3 * t331 * t369 - 0.5e1 / 0.972e3 * t370;
  t388 = 0.5e1 / 0.972e3 * t370 + 0.3e1 * t372 * t373 - t308 * t382 + t145 * t386;
  t392 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t388);
  tvsigma2 = t7 * t392;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t394 = t197 * t49;
  t396 = -0.8e1 * t189 * t49 + 0.8e1 * t394;
  t397 = t86 * t396;
  t403 = t75 * t49;
  t406 = t219 * t49;
  t409 = -0.24e2 * t210 * t49 + 0.384e3 * t214 * t403 - 0.384e3 * t72 * t406 + 0.24e2 * t394;
  t410 = t86 * t409;
  t412 = 0.3e1 * t188 * t397 - t206 * t410;
  t416 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t412);
  tvtau0 = t7 * t416;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t418 = t299 * t117;
  t420 = -0.8e1 * t291 * t117 + 0.8e1 * t418;
  t421 = t151 * t420;
  t427 = t140 * t117;
  t430 = t321 * t117;
  t433 = -0.24e2 * t312 * t117 - 0.384e3 * t137 * t430 + 0.384e3 * t316 * t427 + 0.24e2 * t418;
  t434 = t151 * t433;
  t436 = 0.3e1 * t290 * t421 - t308 * t434;
  t440 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t436);
  tvtau1 = t7 * t440;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t443 = t24 * t24;
  t444 = 0.1e1 / t443;
  t445 = t162 * t162;
  t448 = t158 * t7;
  t449 = 0.1e1 / t448;
  t450 = t17 * t449;
  t453 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t159 + 0.2e1 * t450);
  t457 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t445 + 0.4e1 / 0.3e1 * t24 * t453);
  t458 = t457 * t27;
  t462 = t165 * t171;
  t464 = t6 * t462 * t88;
  t470 = 0.1e1 / t170 / t7;
  t471 = t26 * t470;
  t474 = t6 * t471 * t88 / 0.12e2;
  t476 = t6 * t172 * t235;
  t480 = t176 / t177 / t43;
  t481 = t480 * t54;
  t483 = 0.1e1 / t31 / t30;
  t484 = sigma[0] * sigma[0];
  t485 = t483 * t484;
  t486 = t35 * t35;
  t487 = t486 * t182;
  t489 = 0.1e1 / t36 / t487;
  t490 = t485 * t489;
  t492 = 0.2e3 / 0.531441e6 * t481 * t490;
  t494 = 0.1e1 / t37 / t486;
  t495 = t181 * t494;
  t497 = 0.11e3 / 0.2187e4 * t180 * t495;
  t498 = t62 * t79;
  t499 = t200 * t200;
  t500 = t86 * t499;
  t503 = t63 * t205;
  t507 = t233 * t200;
  t510 = t194 * t194;
  t513 = t52 * t67;
  t514 = t194 * tau[0];
  t515 = t514 * t39;
  t518 = tau[0] * t184;
  t522 = 0.4e2 / 0.9e1 * t518 - 0.11e2 / 0.9e1 * sigma[0] * t494;
  t525 = t53 * t209;
  t526 = tau[0] * tau[0];
  t527 = t486 * rho[0];
  t529 = 0.1e1 / t36 / t527;
  t530 = t526 * t529;
  t535 = -0.8e1 * t510 * t59 - 0.16e3 / 0.3e1 * t513 * t515 - 0.8e1 * t189 * t522 - 0.2e3 / 0.3e1 * t525 * t530 + 0.32e3 / 0.9e1 * t197 * t518;
  t536 = t86 * t535;
  t540 = 0.1e1 / t204 / t78;
  t541 = t64 * t540;
  t542 = t224 * t224;
  t543 = t86 * t542;
  t546 = t233 * t224;
  t556 = 0.1e1 / t73 / t57;
  t557 = t65 * t556;
  t562 = params->b * t70;
  t563 = t75 * t510;
  t566 = t214 * t219;
  t572 = t73 * t73;
  t573 = 0.1e1 / t572;
  t574 = t573 * t526;
  t581 = 0.48e2 * t513 * t510 + 0.24e3 * t525 * t515 + 0.24e2 * t197 * t522 + 0.8e3 / 0.3e1 * t557 * t530 - 0.32e3 / 0.3e1 * t210 * t518 + 0.192e4 * t562 * t563 + 0.768e4 * t566 * t515 + 0.384e3 * t214 * t75 * t522 + 0.224e5 / 0.3e1 * t72 * t574 * t529 - 0.512e4 / 0.3e1 * t72 * t220 * t184;
  t586 = t176 / t227 / t81;
  t587 = t586 * t54;
  t592 = -0.2e3 / 0.531441e6 * t587 * t490 + 0.11e3 / 0.2187e4 * t230 * t495 + t492 - t497;
  t594 = -0.6e1 * t503 * t201 * t224 - t206 * t86 * t581 + 0.6e1 * t188 * t507 + 0.3e1 * t188 * t536 - 0.2e1 * t206 * t546 + 0.6e1 * t498 * t500 + 0.2e1 * t541 * t543 + t80 * t592 - t492 + t497;
  t599 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t88 - t464 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t235 + t474 - t476 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t594);
  t600 = t99 * t99;
  t601 = 0.1e1 / t600;
  t602 = t243 * t243;
  t605 = t94 * t449;
  t608 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t159 + 0.2e1 * t605);
  t612 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t602 + 0.4e1 / 0.3e1 * t99 * t608);
  t613 = t612 * t27;
  t617 = t246 * t171;
  t619 = t6 * t617 * t153;
  t621 = t101 * t470;
  t624 = t6 * t621 * t153 / 0.12e2;
  t626 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t153 - t619 / 0.4e1 + t624);
  tv2rho20 = 0.2e1 * t240 + 0.2e1 * t256 + t7 * (t599 + t626);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t629 = t444 * t260;
  t633 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t450);
  t637 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t629 * t162 + 0.4e1 / 0.3e1 * t24 * t633);
  t638 = t637 * t27;
  t642 = t263 * t171;
  t644 = t6 * t642 * t88;
  t652 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t88 - t644 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t235 - t464 / 0.8e1 + t474 - t476 / 0.8e1);
  t653 = t601 * t271;
  t657 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t605);
  t661 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t653 * t243 + 0.4e1 / 0.3e1 * t99 * t657);
  t662 = t661 * t27;
  t666 = t274 * t171;
  t668 = t6 * t666 * t153;
  t675 = t6 * t251 * t337;
  t678 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t153 - t668 / 0.8e1 - t619 / 0.8e1 + t624 - 0.3e1 / 0.8e1 * t6 * t247 * t337 - t675 / 0.8e1);
  tv2rho21 = t240 + t256 + t269 + t342 + t7 * (t652 + t678);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t683 = t260 * t260;
  t688 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t159 + 0.2e1 * t450);
  t692 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t444 * t683 + 0.4e1 / 0.3e1 * t24 * t688);
  t693 = t692 * t27;
  t699 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t88 - t644 / 0.4e1 + t474);
  t700 = t271 * t271;
  t705 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t159 + 0.2e1 * t605);
  t709 = my_piecewise3(t98, 0, 0.4e1 / 0.9e1 * t601 * t700 + 0.4e1 / 0.3e1 * t99 * t705);
  t710 = t709 * t27;
  t721 = t176 / t279 / t111;
  t722 = t721 * t54;
  t723 = sigma[2] * sigma[2];
  t724 = t483 * t723;
  t725 = t103 * t103;
  t726 = t725 * t284;
  t728 = 0.1e1 / t104 / t726;
  t729 = t724 * t728;
  t731 = 0.2e3 / 0.531441e6 * t722 * t729;
  t733 = 0.1e1 / t105 / t725;
  t734 = t283 * t733;
  t736 = 0.11e3 / 0.2187e4 * t282 * t734;
  t737 = t127 * t144;
  t738 = t302 * t302;
  t739 = t151 * t738;
  t742 = t128 * t307;
  t746 = t335 * t302;
  t749 = t296 * t296;
  t752 = t120 * t132;
  t753 = t296 * tau[1];
  t754 = t753 * t107;
  t757 = tau[1] * t286;
  t761 = 0.4e2 / 0.9e1 * t757 - 0.11e2 / 0.9e1 * sigma[2] * t733;
  t764 = t121 * t311;
  t765 = tau[1] * tau[1];
  t766 = t725 * rho[1];
  t768 = 0.1e1 / t104 / t766;
  t769 = t765 * t768;
  t774 = -0.8e1 * t749 * t124 - 0.16e3 / 0.3e1 * t752 * t754 - 0.8e1 * t291 * t761 - 0.2e3 / 0.3e1 * t764 * t769 + 0.32e3 / 0.9e1 * t299 * t757;
  t775 = t151 * t774;
  t779 = 0.1e1 / t306 / t143;
  t780 = t129 * t779;
  t781 = t326 * t326;
  t782 = t151 * t781;
  t785 = t335 * t326;
  t795 = 0.1e1 / t138 / t122;
  t796 = t130 * t795;
  t801 = params->b * t135;
  t802 = t140 * t749;
  t805 = t316 * t321;
  t811 = t138 * t138;
  t812 = 0.1e1 / t811;
  t813 = t812 * t765;
  t820 = 0.48e2 * t752 * t749 + 0.24e3 * t764 * t754 + 0.24e2 * t299 * t761 + 0.8e3 / 0.3e1 * t796 * t769 - 0.32e3 / 0.3e1 * t312 * t757 + 0.192e4 * t801 * t802 + 0.768e4 * t805 * t754 + 0.384e3 * t316 * t140 * t761 + 0.224e5 / 0.3e1 * t137 * t813 * t768 - 0.512e4 / 0.3e1 * t137 * t322 * t286;
  t825 = t176 / t329 / t146;
  t826 = t825 * t54;
  t831 = -0.2e3 / 0.531441e6 * t826 * t729 + 0.11e3 / 0.2187e4 * t332 * t734 + t731 - t736;
  t833 = -t308 * t151 * t820 - 0.6e1 * t742 * t303 * t326 + t145 * t831 + 0.6e1 * t290 * t746 + 0.3e1 * t290 * t775 - 0.2e1 * t308 * t785 + 0.6e1 * t737 * t739 + 0.2e1 * t780 * t782 - t731 + t736;
  t838 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t153 - t668 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t337 + t624 - t675 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t833);
  tv2rho22 = 0.2e1 * t269 + 0.2e1 * t342 + t7 * (t699 + t838);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t846 = t6 * t172 * t364 / 0.8e1;
  t847 = t486 * t35;
  t849 = 0.1e1 / t36 / t847;
  t851 = t483 * t849 * sigma[0];
  t853 = 0.25e2 / 0.177147e6 * t481 * t851;
  t854 = t34 * t184;
  t856 = 0.1e2 / 0.729e3 * t179 * t854;
  t857 = t498 * t86;
  t858 = t39 * t200;
  t859 = t189 * t858;
  t862 = t503 * t86;
  t863 = t39 * t224;
  t864 = t189 * t863;
  t867 = t188 * t233;
  t870 = t194 * t59;
  t871 = t870 * t39;
  t874 = t529 * tau[0];
  t875 = t513 * t874;
  t878 = t189 * t184;
  t887 = t233 * t357;
  t889 = t39 * t194;
  t890 = t513 * t889;
  t892 = t525 * t874;
  t894 = t197 * t184;
  t897 = t562 * t354 * t194;
  t899 = t219 * t529;
  t901 = t214 * t899 * tau[0];
  t903 = t75 * t184;
  t904 = t214 * t903;
  t906 = -0.6e1 * t890 - 0.15e2 * t892 + 0.8e1 * t894 - 0.24e3 * t897 - 0.48e3 * t901 + 0.128e3 * t904;
  t907 = t86 * t906;
  t909 = t362 * t200;
  t918 = 0.25e2 / 0.177147e6 * t587 * t851 - 0.1e2 / 0.729e3 * t229 * t854 - t853 + t856;
  t920 = -0.3e1 * t503 * t358 * t200 - t206 * t362 * t224 + 0.2e1 * t541 * t358 * t224 + 0.3e1 * t188 * t909 - t206 * t887 - t206 * t907 + 0.3e1 * t348 * t871 + 0.1e2 * t348 * t875 - 0.8e1 * t348 * t878 + 0.3e1 * t867 * t349 + t80 * t918 + 0.6e1 * t857 * t859 - 0.3e1 * t862 * t864 + t853 - t856;
  t925 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t364 - t846 - 0.3e1 / 0.8e1 * t6 * t28 * t920);
  tv2rhosigma0 = t7 * t925 + t368;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t932 = t6 * t251 * t388 / 0.8e1;
  t934 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t388 - t932);
  tv2rhosigma2 = t7 * t934 + t392;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t940 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t364 - t846);
  tv2rhosigma3 = t7 * t940 + t368;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t945 = t725 * t103;
  t947 = 0.1e1 / t104 / t945;
  t949 = t483 * t947 * sigma[2];
  t951 = 0.25e2 / 0.177147e6 * t722 * t949;
  t952 = t34 * t286;
  t954 = 0.1e2 / 0.729e3 * t281 * t952;
  t955 = t737 * t151;
  t956 = t107 * t302;
  t957 = t291 * t956;
  t960 = t742 * t151;
  t961 = t107 * t326;
  t962 = t291 * t961;
  t965 = t290 * t335;
  t968 = t296 * t124;
  t969 = t968 * t107;
  t972 = t768 * tau[1];
  t973 = t752 * t972;
  t976 = t291 * t286;
  t985 = t335 * t381;
  t987 = t107 * t296;
  t988 = t752 * t987;
  t990 = t764 * t972;
  t992 = t299 * t286;
  t995 = t801 * t378 * t296;
  t997 = t321 * t768;
  t999 = t316 * t997 * tau[1];
  t1001 = t140 * t286;
  t1002 = t316 * t1001;
  t1004 = -0.6e1 * t988 - 0.15e2 * t990 + 0.8e1 * t992 - 0.24e3 * t995 - 0.48e3 * t999 + 0.128e3 * t1002;
  t1005 = t151 * t1004;
  t1007 = t386 * t302;
  t1016 = 0.25e2 / 0.177147e6 * t826 * t949 - 0.1e2 / 0.729e3 * t331 * t952 - t951 + t954;
  t1018 = -0.3e1 * t742 * t382 * t302 - t308 * t386 * t326 + 0.2e1 * t780 * t382 * t326 - t308 * t1005 + 0.3e1 * t290 * t1007 + t145 * t1016 - t308 * t985 + 0.3e1 * t372 * t969 + 0.1e2 * t372 * t973 - 0.8e1 * t372 * t976 + 0.3e1 * t965 * t373 + 0.6e1 * t955 * t957 - 0.3e1 * t960 * t962 + t951 - t954;
  t1023 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t388 - t932 - 0.3e1 / 0.8e1 * t6 * t102 * t1018);
  tv2rhosigma5 = t7 * t1023 + t392;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1030 = t6 * t172 * t412 / 0.8e1;
  t1034 = t397 * t224;
  t1037 = t233 * t396;
  t1043 = 0.1e1 / t36 / t486;
  t1044 = t1043 * tau[0];
  t1048 = t49 * t194;
  t1049 = t513 * t1048;
  t1051 = t525 * t1044;
  t1054 = -0.8e1 * t870 * t49 - 0.8e2 / 0.3e1 * t513 * t1044 + 0.4e2 / 0.3e1 * t349 + 0.16e2 * t1049 + 0.4e2 * t1051 - 0.4e2 / 0.3e1 * t352;
  t1055 = t86 * t1054;
  t1064 = t233 * t409;
  t1078 = t219 * t1043;
  t1086 = t573 * t1043;
  t1090 = t219 * t39;
  t1093 = 0.384e4 * t214 * t1078 * tau[0] - 0.448e4 * t72 * t1086 * tau[0] - 0.2304e4 * t214 * t406 * t194 + 0.192e4 * t562 * t403 * t194 - 0.16e3 * t557 * t1044 - 0.72e2 * t525 * t1048 + 0.64e3 * t72 * t1090 + 0.4e2 * t210 * t39 + 0.48e2 * t1049 + 0.12e3 * t1051 - 0.4e2 * t352 - 0.64e3 * t355;
  t1094 = t86 * t1093;
  t1096 = 0.6e1 * t498 * t397 * t200 - 0.3e1 * t503 * t410 * t200 + 0.2e1 * t541 * t410 * t224 - 0.3e1 * t503 * t1034 + 0.3e1 * t188 * t1037 + 0.3e1 * t188 * t1055 - t206 * t1064 - t206 * t1094;
  t1101 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t412 - t1030 - 0.3e1 / 0.8e1 * t6 * t28 * t1096);
  tv2rhotau0 = t7 * t1101 + t416;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1108 = t6 * t251 * t436 / 0.8e1;
  t1110 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t436 - t1108);
  tv2rhotau1 = t7 * t1110 + t440;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1116 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t412 - t1030);
  tv2rhotau2 = t7 * t1116 + t416;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1124 = t421 * t326;
  t1127 = t335 * t420;
  t1133 = 0.1e1 / t104 / t725;
  t1134 = t1133 * tau[1];
  t1138 = t117 * t296;
  t1139 = t752 * t1138;
  t1141 = t764 * t1134;
  t1144 = -0.8e1 * t968 * t117 - 0.8e2 / 0.3e1 * t752 * t1134 + 0.4e2 / 0.3e1 * t373 + 0.16e2 * t1139 + 0.4e2 * t1141 - 0.4e2 / 0.3e1 * t376;
  t1145 = t151 * t1144;
  t1154 = t335 * t433;
  t1168 = t321 * t1133;
  t1176 = t812 * t1133;
  t1180 = t321 * t107;
  t1183 = 0.384e4 * t316 * t1168 * tau[1] - 0.448e4 * t137 * t1176 * tau[1] - 0.2304e4 * t316 * t430 * t296 + 0.192e4 * t801 * t427 * t296 + 0.4e2 * t312 * t107 - 0.16e3 * t796 * t1134 - 0.72e2 * t764 * t1138 + 0.64e3 * t137 * t1180 + 0.48e2 * t1139 + 0.12e3 * t1141 - 0.4e2 * t376 - 0.64e3 * t379;
  t1184 = t151 * t1183;
  t1186 = 0.6e1 * t737 * t421 * t302 - 0.3e1 * t742 * t434 * t302 + 0.2e1 * t780 * t434 * t326 - 0.3e1 * t742 * t1124 + 0.3e1 * t290 * t1127 + 0.3e1 * t290 * t1145 - t308 * t1154 - t308 * t1184;
  t1191 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t436 - t1108 - 0.3e1 / 0.8e1 * t6 * t102 * t1186);
  tv2rhotau3 = t7 * t1191 + t440;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1193 = t54 * t483;
  t1194 = t1193 * t529;
  t1195 = t480 * t1194;
  t1197 = t525 * t529;
  t1200 = t39 * t357;
  t1201 = t189 * t1200;
  t1204 = t188 * t362;
  t1208 = t86 * t529 * t59;
  t1211 = t357 * t357;
  t1212 = t86 * t1211;
  t1215 = t362 * t357;
  t1218 = t513 * t529;
  t1220 = t75 * t529;
  t1221 = t562 * t1220;
  t1223 = 0.3e1 / 0.4e1 * t1218 + 0.3e2 * t1221;
  t1224 = t86 * t1223;
  t1228 = -0.25e2 / 0.472392e6 * t586 * t1194 + 0.25e2 / 0.472392e6 * t1195;
  t1230 = -0.25e2 / 0.472392e6 * t1195 + 0.6e1 * t857 * t1197 - 0.6e1 * t862 * t1201 + 0.6e1 * t1204 * t349 - 0.3e1 / 0.8e1 * t188 * t1208 + 0.2e1 * t541 * t1212 - 0.2e1 * t206 * t1215 - t206 * t1224 + t80 * t1228;
  t1234 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1230);
  tv2sigma20 = t7 * t1234;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1235 = t1193 * t768;
  t1236 = t721 * t1235;
  t1238 = t764 * t768;
  t1241 = t107 * t381;
  t1242 = t291 * t1241;
  t1245 = t290 * t386;
  t1249 = t151 * t768 * t124;
  t1252 = t381 * t381;
  t1253 = t151 * t1252;
  t1256 = t386 * t381;
  t1259 = t752 * t768;
  t1261 = t140 * t768;
  t1262 = t801 * t1261;
  t1264 = 0.3e1 / 0.4e1 * t1259 + 0.3e2 * t1262;
  t1265 = t151 * t1264;
  t1269 = -0.25e2 / 0.472392e6 * t825 * t1235 + 0.25e2 / 0.472392e6 * t1236;
  t1271 = -0.25e2 / 0.472392e6 * t1236 + 0.6e1 * t955 * t1238 - 0.6e1 * t960 * t1242 + 0.6e1 * t1245 * t373 - 0.3e1 / 0.8e1 * t290 * t1249 + 0.2e1 * t780 * t1253 - 0.2e1 * t308 * t1256 - t308 * t1265 + t145 * t1269;
  t1275 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1271);
  tv2sigma25 = t7 * t1275;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1276 = t396 * t52;
  t1277 = t59 * t39;
  t1278 = t1276 * t1277;
  t1281 = t397 * t357;
  t1284 = t362 * t396;
  t1287 = t1043 * t59;
  t1288 = t513 * t1043;
  t1290 = t1287 - 0.2e1 * t1288;
  t1291 = t86 * t1290;
  t1294 = t409 * t52;
  t1295 = t1294 * t1277;
  t1301 = t362 * t409;
  t1304 = t525 * t1043;
  t1306 = t75 * t1043;
  t1307 = t562 * t1306;
  t1309 = t214 * t1078;
  t1311 = -0.6e1 * t1288 + 0.9e1 * t1304 - 0.24e3 * t1307 + 0.288e3 * t1309;
  t1312 = t86 * t1311;
  t1314 = 0.2e1 * t541 * t410 * t357 + 0.6e1 * t857 * t1278 - 0.3e1 * t503 * t1281 + 0.3e1 * t188 * t1284 + 0.3e1 * t188 * t1291 - 0.3e1 * t862 * t1295 - t206 * t1301 - t206 * t1312;
  t1318 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1314);
  tv2sigmatau0 = t7 * t1318;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1319 = t420 * t120;
  t1320 = t124 * t107;
  t1321 = t1319 * t1320;
  t1324 = t421 * t381;
  t1327 = t386 * t420;
  t1330 = t1133 * t124;
  t1331 = t752 * t1133;
  t1333 = t1330 - 0.2e1 * t1331;
  t1334 = t151 * t1333;
  t1337 = t433 * t120;
  t1338 = t1337 * t1320;
  t1344 = t386 * t433;
  t1347 = t764 * t1133;
  t1349 = t140 * t1133;
  t1350 = t801 * t1349;
  t1352 = t316 * t1168;
  t1354 = -0.6e1 * t1331 + 0.9e1 * t1347 - 0.24e3 * t1350 + 0.288e3 * t1352;
  t1355 = t151 * t1354;
  t1357 = 0.2e1 * t780 * t434 * t381 + 0.6e1 * t955 * t1321 - 0.3e1 * t742 * t1324 + 0.3e1 * t290 * t1327 + 0.3e1 * t290 * t1334 - 0.3e1 * t960 * t1338 - t308 * t1344 - t308 * t1355;
  t1361 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1357);
  tv2sigmatau5 = t7 * t1361;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1362 = t396 * t396;
  t1363 = t86 * t1362;
  t1366 = t397 * t409;
  t1370 = 0.1e1 / t36 / t182;
  t1373 = t513 * t1370;
  t1375 = t525 * t1370;
  t1377 = -0.8e1 * t1370 * t59 + 0.32e2 * t1373 - 0.24e2 * t1375;
  t1378 = t86 * t1377;
  t1381 = t409 * t409;
  t1382 = t86 * t1381;
  t1389 = t75 * t1370;
  t1392 = t219 * t1370;
  t1395 = t573 * t1370;
  t1398 = 0.96e2 * t557 * t1370 + 0.192e4 * t562 * t1389 - 0.4608e4 * t214 * t1392 + 0.2688e4 * t72 * t1395 + 0.48e2 * t1373 - 0.144e3 * t1375;
  t1399 = t86 * t1398;
  t1401 = 0.6e1 * t498 * t1363 - 0.6e1 * t503 * t1366 + 0.3e1 * t188 * t1378 + 0.2e1 * t541 * t1382 - t206 * t1399;
  t1405 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t1401);
  tv2tau20 = t7 * t1405;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1406 = t420 * t420;
  t1407 = t151 * t1406;
  t1410 = t421 * t433;
  t1414 = 0.1e1 / t104 / t284;
  t1417 = t752 * t1414;
  t1419 = t764 * t1414;
  t1421 = -0.8e1 * t1414 * t124 + 0.32e2 * t1417 - 0.24e2 * t1419;
  t1422 = t151 * t1421;
  t1425 = t433 * t433;
  t1426 = t151 * t1425;
  t1433 = t140 * t1414;
  t1436 = t321 * t1414;
  t1439 = t812 * t1414;
  t1442 = 0.2688e4 * t137 * t1439 + 0.96e2 * t796 * t1414 + 0.192e4 * t801 * t1433 - 0.4608e4 * t316 * t1436 + 0.48e2 * t1417 - 0.144e3 * t1419;
  t1443 = t151 * t1442;
  t1445 = 0.6e1 * t737 * t1407 - 0.6e1 * t742 * t1410 + 0.3e1 * t290 * t1422 + 0.2e1 * t780 * t1426 - t308 * t1443;
  t1449 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t1445);
  tv2tau22 = t7 * t1449;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1453 = 0.1e1 / t443 / t20;
  t1454 = t445 * t162;
  t1457 = t444 * t162;
  t1460 = t158 * t158;
  t1461 = 0.1e1 / t1460;
  t1462 = t17 * t1461;
  t1465 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t449 - 0.6e1 * t1462);
  t1469 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1453 * t1454 + 0.4e1 / 0.3e1 * t1457 * t453 + 0.4e1 / 0.3e1 * t24 * t1465);
  t1470 = t1469 * t27;
  t1474 = t457 * t171;
  t1476 = t6 * t1474 * t88;
  t1481 = t165 * t470;
  t1483 = t6 * t1481 * t88;
  t1486 = t6 * t462 * t235;
  t1492 = 0.1e1 / t170 / t158;
  t1493 = t26 * t1492;
  t1496 = 0.5e1 / 0.36e2 * t6 * t1493 * t88;
  t1498 = t6 * t471 * t235;
  t1501 = t6 * t172 * t594;
  t1503 = t204 * t204;
  t1504 = 0.1e1 / t1503;
  t1505 = t64 * t1504;
  t1506 = t542 * t224;
  t1507 = t86 * t1506;
  t1513 = t177 * t177;
  t1515 = t176 / t1513;
  t1516 = t30 * t30;
  t1517 = 0.1e1 / t1516;
  t1518 = t484 * sigma[0];
  t1519 = t1517 * t1518;
  t1520 = t486 * t486;
  t1521 = t1520 * t182;
  t1522 = 0.1e1 / t1521;
  t1523 = t1519 * t1522;
  t1525 = 0.4e4 / 0.43046721e8 * t1515 * t1523;
  t1526 = t62 * t205;
  t1542 = t63 * t540;
  t1546 = t592 * t200;
  t1550 = t233 * t535;
  t1555 = t510 * t67;
  t1558 = t52 * t209;
  t1559 = t194 * t526;
  t1560 = t1559 * t529;
  t1563 = t522 * tau[0];
  t1564 = t1563 * t39;
  t1567 = t514 * t184;
  t1570 = tau[0] * t494;
  t1573 = 0.1e1 / t37 / t527;
  t1576 = -0.44e3 / 0.27e2 * t1570 + 0.154e3 / 0.27e2 * sigma[0] * t1573;
  t1579 = t53 * t556;
  t1580 = t526 * tau[0];
  t1581 = 0.1e1 / t1520;
  t1582 = t1580 * t1581;
  t1585 = t526 * t849;
  t1590 = -0.24e2 * t870 * t522 - 0.8e2 * t1555 * t190 - 0.4e3 * t1558 * t1560 - 0.8e2 * t513 * t1564 + 0.64e3 / 0.3e1 * t513 * t1567 - 0.8e1 * t189 * t1576 - 0.4e4 / 0.9e1 * t1579 * t1582 + 0.16e4 / 0.3e1 * t525 * t1585 - 0.352e4 / 0.27e2 * t197 * t1570;
  t1591 = t86 * t1590;
  t1604 = 0.1e1 / t572 / t57;
  t1605 = t1604 * t1580;
  t1609 = t510 * tau[0];
  t1610 = t1609 * t39;
  t1621 = params->b * t65;
  t1622 = t510 * t194;
  t1629 = t562 * t219;
  t1634 = t214 * t573;
  t1645 = t194 * t522;
  t1648 = t65 * t75;
  t1660 = 0.896e6 / 0.9e1 * t72 * t1605 * t1581 + 0.72e3 * t1558 * t1610 + 0.36e3 * t525 * t1564 + 0.24e4 * t1579 * t1560 - 0.64e4 / 0.3e1 * t557 * t1585 + 0.352e4 / 0.9e1 * t210 * t1570 + 0.768e4 * t1621 * t75 * t1622 + 0.576e4 * t562 * t215 * t522 + 0.576e5 * t1629 * t1610 + 0.1152e5 * t566 * t1564 + 0.1344e6 * t1634 * t1560 - 0.1792e6 / 0.3e1 * t72 * t574 * t849 + 0.5632e5 / 0.9e1 * t72 * t220 * t494 - 0.96e3 * t525 * t1567 + 0.144e3 * t513 * t1645 + 0.2e5 / 0.9e1 * t1648 * t1582 + 0.384e3 * t214 * t75 * t1576 - 0.3072e5 * t566 * t1567 + 0.48e2 * t1622 * t67 + 0.24e2 * t197 * t1576;
  t1663 = t499 * t200;
  t1664 = t1663 * t79;
  t1667 = t233 * t499;
  t1670 = t181 * t1573;
  t1672 = 0.154e4 / 0.6561e4 * t180 * t1670;
  t1674 = 0.1e1 / t36 / t1520;
  t1675 = t485 * t1674;
  t1677 = 0.22e4 / 0.531441e6 * t481 * t1675;
  t1678 = t227 * t227;
  t1680 = t176 / t1678;
  t1687 = -0.4e4 / 0.43046721e8 * t1680 * t1523 + 0.22e4 / 0.531441e6 * t587 * t1675 - 0.154e4 / 0.6561e4 * t230 * t1670 + t1525 - t1677 + t1672;
  t1689 = -t206 * t86 * t1660 - 0.3e1 * t206 * t592 * t224 - 0.3e1 * t206 * t233 * t581 + 0.6e1 * t541 * t233 * t542 + 0.9e1 * t188 * t1550 + 0.3e1 * t188 * t1591 + 0.6e1 * t1664 * t86 + 0.18e2 * t498 * t1667 + t80 * t1687 - t1672 + t1677;
  t1690 = -0.18e2 * t1526 * t500 * t224 + 0.18e2 * t1542 * t201 * t542 + 0.18e2 * t498 * t201 * t535 - 0.9e1 * t503 * t201 * t581 - 0.18e2 * t503 * t507 * t224 - 0.9e1 * t503 * t536 * t224 + 0.6e1 * t541 * t225 * t581 - 0.6e1 * t1505 * t1507 + 0.9e1 * t188 * t1546 - t1525 + t1689;
  t1695 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1470 * t88 - 0.3e1 / 0.8e1 * t1476 - 0.9e1 / 0.8e1 * t6 * t458 * t235 + t1483 / 0.4e1 - 0.3e1 / 0.4e1 * t1486 - 0.9e1 / 0.8e1 * t6 * t166 * t594 - t1496 + t1498 / 0.4e1 - 0.3e1 / 0.8e1 * t1501 - 0.3e1 / 0.8e1 * t6 * t28 * t1690);
  t1697 = 0.1e1 / t600 / t97;
  t1698 = t602 * t243;
  t1701 = t601 * t243;
  t1704 = t94 * t1461;
  t1707 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t449 - 0.6e1 * t1704);
  t1711 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1697 * t1698 + 0.4e1 / 0.3e1 * t1701 * t608 + 0.4e1 / 0.3e1 * t99 * t1707);
  t1712 = t1711 * t27;
  t1716 = t612 * t171;
  t1718 = t6 * t1716 * t153;
  t1720 = t246 * t470;
  t1722 = t6 * t1720 * t153;
  t1724 = t101 * t1492;
  t1727 = 0.5e1 / 0.36e2 * t6 * t1724 * t153;
  t1729 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1712 * t153 - 0.3e1 / 0.8e1 * t1718 + t1722 / 0.4e1 - t1727);
  tv3rho30 = 0.3e1 * t599 + 0.3e1 * t626 + t7 * (t1695 + t1729);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1732 = 0.2e1 * t652;
  t1733 = 0.2e1 * t678;
  t1734 = t1453 * t260;
  t1737 = t444 * t633;
  t1742 = 0.2e1 * t449;
  t1743 = 0.6e1 * t1462;
  t1745 = my_piecewise5(t11, 0, t15, 0, t1742 - t1743);
  t1749 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1734 * t445 + 0.8e1 / 0.9e1 * t1737 * t162 + 0.4e1 / 0.9e1 * t629 * t453 + 0.4e1 / 0.3e1 * t24 * t1745);
  t1750 = t1749 * t27;
  t1754 = t637 * t171;
  t1757 = t6 * t1754 * t88 / 0.4e1;
  t1761 = t263 * t470;
  t1763 = t6 * t1761 * t88;
  t1767 = t6 * t642 * t235 / 0.4e1;
  t1776 = -0.3e1 / 0.8e1 * t6 * t1750 * t88 - t1757 - 0.3e1 / 0.4e1 * t6 * t638 * t235 + t1763 / 0.12e2 - t1767 - 0.3e1 / 0.8e1 * t6 * t264 * t594 - t1476 / 0.8e1 + t1483 / 0.6e1 - t1486 / 0.4e1 - t1496 + t1498 / 0.6e1 - t1501 / 0.8e1;
  t1777 = my_piecewise3(t2, 0, t1776);
  t1778 = t1697 * t271;
  t1781 = t601 * t657;
  t1786 = 0.6e1 * t1704;
  t1788 = my_piecewise5(t15, 0, t11, 0, -t1742 - t1786);
  t1792 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1778 * t602 + 0.8e1 / 0.9e1 * t1781 * t243 + 0.4e1 / 0.9e1 * t653 * t608 + 0.4e1 / 0.3e1 * t99 * t1788);
  t1793 = t1792 * t27;
  t1797 = t661 * t171;
  t1800 = t6 * t1797 * t153 / 0.4e1;
  t1801 = t274 * t470;
  t1803 = t6 * t1801 * t153;
  t1812 = t6 * t617 * t337 / 0.4e1;
  t1814 = t6 * t621 * t337;
  t1817 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1793 * t153 - t1800 + t1803 / 0.12e2 - t1718 / 0.8e1 + t1722 / 0.6e1 - t1727 - 0.3e1 / 0.8e1 * t6 * t613 * t337 - t1812 + t1814 / 0.12e2);
  tv3rho31 = t599 + t626 + t1732 + t1733 + t7 * (t1777 + t1817);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t1820 = t1453 * t683;
  t1825 = t444 * t688;
  t1829 = my_piecewise5(t11, 0, t15, 0, -t1742 - t1743);
  t1833 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1820 * t162 + 0.8e1 / 0.9e1 * t629 * t633 + 0.4e1 / 0.9e1 * t1825 * t162 + 0.4e1 / 0.3e1 * t24 * t1829);
  t1834 = t1833 * t27;
  t1838 = t692 * t171;
  t1840 = t6 * t1838 * t88;
  t1849 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1834 * t88 - t1840 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t693 * t235 - t1757 + t1763 / 0.6e1 - t1767 + t1483 / 0.12e2 - t1496 + t1498 / 0.12e2);
  t1850 = t1697 * t700;
  t1855 = t601 * t705;
  t1859 = my_piecewise5(t15, 0, t11, 0, t1742 - t1786);
  t1863 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1850 * t243 + 0.8e1 / 0.9e1 * t653 * t657 + 0.4e1 / 0.9e1 * t1855 * t243 + 0.4e1 / 0.3e1 * t99 * t1859);
  t1864 = t1863 * t27;
  t1868 = t709 * t171;
  t1870 = t6 * t1868 * t153;
  t1877 = t6 * t666 * t337;
  t1885 = t6 * t251 * t833;
  t1887 = -0.3e1 / 0.8e1 * t6 * t1864 * t153 - t1870 / 0.8e1 - t1800 + t1803 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t662 * t337 - t1877 / 0.4e1 + t1722 / 0.12e2 - t1727 - t1812 + t1814 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t247 * t833 - t1885 / 0.8e1;
  t1888 = my_piecewise3(t93, 0, t1887);
  tv3rho32 = t1732 + t1733 + t699 + t838 + t7 * (t1849 + t1888);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t1893 = t683 * t260;
  t1900 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t449 - 0.6e1 * t1462);
  t1904 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1453 * t1893 + 0.4e1 / 0.3e1 * t629 * t688 + 0.4e1 / 0.3e1 * t24 * t1900);
  t1905 = t1904 * t27;
  t1912 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1905 * t88 - 0.3e1 / 0.8e1 * t1840 + t1763 / 0.4e1 - t1496);
  t1913 = t700 * t271;
  t1920 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t449 - 0.6e1 * t1704);
  t1924 = my_piecewise3(t98, 0, -0.8e1 / 0.27e2 * t1697 * t1913 + 0.4e1 / 0.3e1 * t653 * t705 + 0.4e1 / 0.3e1 * t99 * t1920);
  t1925 = t1924 * t27;
  t1940 = t127 * t307;
  t1956 = t306 * t306;
  t1957 = 0.1e1 / t1956;
  t1958 = t129 * t1957;
  t1959 = t781 * t326;
  t1960 = t151 * t1959;
  t1966 = t279 * t279;
  t1968 = t176 / t1966;
  t1969 = t723 * sigma[2];
  t1970 = t1517 * t1969;
  t1971 = t725 * t725;
  t1972 = t1971 * t284;
  t1973 = 0.1e1 / t1972;
  t1974 = t1970 * t1973;
  t1976 = 0.4e4 / 0.43046721e8 * t1968 * t1974;
  t1977 = t128 * t779;
  t1991 = tau[1] * t733;
  t1994 = params->b * t130;
  t1995 = t749 * t296;
  t2003 = 0.1e1 / t811 / t122;
  t2004 = t765 * tau[1];
  t2005 = t2003 * t2004;
  t2006 = 0.1e1 / t1971;
  t2010 = t120 * t311;
  t2011 = t749 * tau[1];
  t2012 = t2011 * t107;
  t2015 = t761 * tau[1];
  t2016 = t2015 * t107;
  t2019 = t121 * t795;
  t2020 = t296 * t765;
  t2021 = t2020 * t768;
  t2024 = t765 * t947;
  t2027 = t801 * t321;
  t2032 = t316 * t812;
  t2041 = t753 * t286;
  t2044 = t296 * t761;
  t2047 = t130 * t140;
  t2048 = t2004 * t2006;
  t2053 = 0.1e1 / t105 / t766;
  t2056 = -0.44e3 / 0.27e2 * t1991 + 0.154e3 / 0.27e2 * sigma[2] * t2053;
  t2066 = 0.352e4 / 0.9e1 * t312 * t1991 + 0.768e4 * t1994 * t140 * t1995 + 0.576e4 * t801 * t317 * t761 + 0.896e6 / 0.9e1 * t137 * t2005 * t2006 + 0.72e3 * t2010 * t2012 + 0.36e3 * t764 * t2016 + 0.24e4 * t2019 * t2021 - 0.64e4 / 0.3e1 * t796 * t2024 + 0.576e5 * t2027 * t2012 + 0.1152e5 * t805 * t2016 + 0.1344e6 * t2032 * t2021 - 0.1792e6 / 0.3e1 * t137 * t813 * t947 + 0.5632e5 / 0.9e1 * t137 * t322 * t733 - 0.96e3 * t764 * t2041 + 0.144e3 * t752 * t2044 + 0.2e5 / 0.9e1 * t2047 * t2048 + 0.384e3 * t316 * t140 * t2056 - 0.3072e5 * t805 * t2041 + 0.48e2 * t1995 * t132 + 0.24e2 * t299 * t2056;
  t2069 = t738 * t302;
  t2070 = t2069 * t144;
  t2073 = t335 * t738;
  t2076 = t831 * t302;
  t2079 = t335 * t774;
  t2084 = t749 * t132;
  t2101 = -0.24e2 * t968 * t761 - 0.8e2 * t2084 * t292 - 0.4e3 * t2010 * t2021 - 0.8e2 * t752 * t2016 + 0.64e3 / 0.3e1 * t752 * t2041 - 0.8e1 * t291 * t2056 - 0.4e4 / 0.9e1 * t2019 * t2048 + 0.16e4 / 0.3e1 * t764 * t2024 - 0.352e4 / 0.27e2 * t299 * t1991;
  t2102 = t151 * t2101;
  t2105 = t283 * t2053;
  t2107 = 0.154e4 / 0.6561e4 * t282 * t2105;
  t2109 = 0.1e1 / t104 / t1971;
  t2110 = t724 * t2109;
  t2112 = 0.22e4 / 0.531441e6 * t722 * t2110;
  t2113 = t329 * t329;
  t2115 = t176 / t2113;
  t2122 = -0.4e4 / 0.43046721e8 * t2115 * t1974 + 0.22e4 / 0.531441e6 * t826 * t2110 - 0.154e4 / 0.6561e4 * t332 * t2105 + t1976 - t2112 + t2107;
  t2124 = -t308 * t151 * t2066 - 0.3e1 * t308 * t831 * t326 - 0.3e1 * t308 * t335 * t820 + t145 * t2122 + 0.6e1 * t2070 * t151 + 0.18e2 * t737 * t2073 + 0.9e1 * t290 * t2076 + 0.9e1 * t290 * t2079 + 0.3e1 * t290 * t2102 - t2107 + t2112;
  t2125 = -0.18e2 * t1940 * t739 * t326 + 0.18e2 * t1977 * t303 * t781 + 0.18e2 * t737 * t303 * t774 - 0.9e1 * t742 * t303 * t820 - 0.18e2 * t742 * t746 * t326 - 0.9e1 * t742 * t775 * t326 + 0.6e1 * t780 * t327 * t820 + 0.6e1 * t780 * t335 * t781 - 0.6e1 * t1958 * t1960 - t1976 + t2124;
  t2130 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1925 * t153 - 0.3e1 / 0.8e1 * t1870 - 0.9e1 / 0.8e1 * t6 * t710 * t337 + t1803 / 0.4e1 - 0.3e1 / 0.4e1 * t1877 - 0.9e1 / 0.8e1 * t6 * t275 * t833 - t1727 + t1814 / 0.4e1 - 0.3e1 / 0.8e1 * t1885 - 0.3e1 / 0.8e1 * t6 * t102 * t2125);
  tv3rho33 = 0.3e1 * t699 + 0.3e1 * t838 + t7 * (t1912 + t2130);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t2138 = t6 * t462 * t364;
  t2145 = t6 * t471 * t364 / 0.12e2;
  t2147 = t6 * t172 * t920;
  t2149 = t233 * t906;
  t2152 = t362 * t499;
  t2158 = t592 * t357;
  t2163 = t362 * t581;
  t2165 = t1555 * t39;
  t2167 = t529 * t194;
  t2168 = t2167 * tau[0];
  t2169 = t1558 * t2168;
  t2171 = t184 * t194;
  t2172 = t513 * t2171;
  t2174 = t39 * t522;
  t2175 = t513 * t2174;
  t2177 = t1581 * t526;
  t2178 = t1579 * t2177;
  t2180 = t849 * tau[0];
  t2181 = t525 * t2180;
  t2183 = t197 * t494;
  t2186 = t1621 * t354 * t510;
  t2188 = t1629 * t2168;
  t2191 = t562 * t903 * t194;
  t2194 = t562 * t354 * t522;
  t2196 = t573 * t1581;
  t2198 = t214 * t2196 * t526;
  t2200 = t219 * t849;
  t2202 = t214 * t2200 * tau[0];
  t2204 = t75 * t494;
  t2205 = t214 * t2204;
  t2207 = -0.6e1 * t2165 - 0.6e2 * t2169 + 0.32e2 * t2172 - 0.6e1 * t2175 - 0.1e3 * t2178 + 0.12e3 * t2181 - 0.88e2 / 0.3e1 * t2183 - 0.96e3 * t2186 - 0.48e4 * t2188 + 0.128e4 * t2191 - 0.24e3 * t2194 - 0.56e4 * t2198 + 0.384e4 * t2202 - 0.1408e4 / 0.3e1 * t2205;
  t2208 = t86 * t2207;
  t2210 = t918 * t200;
  t2213 = t362 * t535;
  t2222 = -0.2e1 * t206 * t918 * t224 - 0.6e1 * t503 * t909 * t224 + 0.2e1 * t541 * t358 * t581 + 0.2e1 * t541 * t362 * t542 + 0.6e1 * t188 * t2210 + 0.3e1 * t188 * t2213 - 0.2e1 * t206 * t2149 - t206 * t2158 - t206 * t2163 - t206 * t2208 + 0.6e1 * t498 * t2152;
  t2223 = t1520 * t35;
  t2225 = t1517 / t2223;
  t2226 = t2225 * t484;
  t2228 = 0.5e3 / 0.14348907e8 * t1515 * t2226;
  t2247 = t34 * t494;
  t2249 = 0.11e3 / 0.2187e4 * t179 * t2247;
  t2253 = t870 * t184;
  t2256 = t189 * t494;
  t2260 = t483 * t489 * sigma[0];
  t2262 = 0.25e2 / 0.19683e5 * t481 * t2260;
  t2263 = t2228 - 0.6e1 * t1505 * t358 * t542 - 0.6e1 * t503 * t887 * t200 - 0.6e1 * t503 * t907 * t200 - 0.3e1 * t503 * t358 * t535 + 0.4e1 * t541 * t887 * t224 + 0.4e1 * t541 * t907 * t224 + t2249 - 0.6e1 * t1526 * t358 * t499 - 0.16e2 * t348 * t2253 + 0.88e2 / 0.3e1 * t348 * t2256 - t2262;
  t2265 = t499 * t79;
  t2266 = t2265 * t86;
  t2271 = t188 * t592;
  t2276 = t522 * t59;
  t2277 = t2276 * t39;
  t2280 = t1542 * t86;
  t2281 = t357 * t200;
  t2282 = t2281 * t224;
  t2285 = t870 * t863;
  t2288 = t39 * t581;
  t2289 = t189 * t2288;
  t2294 = t184 * t200;
  t2295 = t189 * t2294;
  t2298 = t39 * t542;
  t2299 = t189 * t2298;
  t2302 = 0.6e1 * t2266 * t349 + 0.3e1 * t2271 * t349 + 0.3e1 * t348 * t2277 + 0.12e2 * t2280 * t2282 + 0.6e1 * t2280 * t2299 - 0.6e1 * t862 * t2285 - 0.3e1 * t862 * t2289 - 0.32e2 * t857 * t2295 + 0.6e1 * t867 * t871 + 0.2e2 * t867 * t875 - 0.16e2 * t867 * t878;
  t2303 = t184 * t224;
  t2304 = t189 * t2303;
  t2307 = t513 * t2180;
  t2310 = t194 * t67;
  t2311 = t2310 * t874;
  t2314 = t1558 * t2177;
  t2317 = t498 * t233;
  t2320 = t870 * t858;
  t2323 = t39 * t535;
  t2324 = t189 * t2323;
  t2327 = t503 * t233;
  t2336 = 0.5e3 / 0.14348907e8 * t1680 * t2226 - 0.25e2 / 0.19683e5 * t587 * t2260 + 0.11e3 / 0.2187e4 * t229 * t2247 - t2228 + t2262 - t2249;
  t2338 = t86 * t52;
  t2339 = t1526 * t2338;
  t2340 = t200 * t224;
  t2341 = t1277 * t2340;
  t2344 = t498 * t2338;
  t2345 = t67 * t529;
  t2346 = t200 * tau[0];
  t2347 = t2345 * t2346;
  t2350 = t503 * t2338;
  t2351 = t224 * tau[0];
  t2352 = t2345 * t2351;
  t2355 = 0.16e2 * t862 * t2304 - 0.8e2 * t348 * t2307 + 0.2e2 * t348 * t2311 + 0.5e2 * t348 * t2314 + 0.12e2 * t2317 * t859 + 0.12e2 * t857 * t2320 + 0.6e1 * t857 * t2324 - 0.6e1 * t2327 * t864 + t80 * t2336 - 0.12e2 * t2339 * t2341 + 0.4e2 * t2344 * t2347 - 0.2e2 * t2350 * t2352;
  t2357 = t2222 + t2263 + t2302 + t2355;
  t2362 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t364 - t2138 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t920 + t2145 - t2147 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2357);
  tv3rho2sigma0 = t7 * t2362 + 0.2e1 * t925;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2369 = t6 * t617 * t388;
  t2373 = t6 * t621 * t388 / 0.12e2;
  t2375 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t388 - t2369 / 0.4e1 + t2373);
  tv3rho2sigma2 = t7 * t2375 + 0.2e1 * t934;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2381 = t6 * t642 * t364;
  t2389 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t364 - t2381 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t920 - t2138 / 0.8e1 + t2145 - t2147 / 0.8e1);
  tv3rho2sigma3 = t7 * t2389 + t925 + t940;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2395 = t6 * t666 * t388;
  t2402 = t6 * t251 * t1018;
  t2405 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t388 - t2395 / 0.8e1 - t2369 / 0.8e1 + t2373 - 0.3e1 / 0.8e1 * t6 * t247 * t1018 - t2402 / 0.8e1);
  tv3rho2sigma5 = t7 * t2405 + t1023 + t934;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2413 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t364 - t2381 / 0.4e1 + t2145);
  tv3rho2sigma6 = t7 * t2413 + 0.2e1 * t940;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2427 = t386 * t738;
  t2430 = t1016 * t302;
  t2433 = t386 * t774;
  t2439 = t386 * t820;
  t2441 = t831 * t381;
  t2443 = t335 * t1004;
  t2446 = t2084 * t107;
  t2448 = t768 * t296;
  t2449 = t2448 * tau[1];
  t2450 = t2010 * t2449;
  t2452 = t286 * t296;
  t2453 = t752 * t2452;
  t2455 = t107 * t761;
  t2456 = t752 * t2455;
  t2458 = t2006 * t765;
  t2459 = t2019 * t2458;
  t2461 = t947 * tau[1];
  t2462 = t764 * t2461;
  t2464 = t299 * t733;
  t2467 = t1994 * t378 * t749;
  t2469 = t2027 * t2449;
  t2472 = t801 * t1001 * t296;
  t2475 = t801 * t378 * t761;
  t2477 = t812 * t2006;
  t2479 = t316 * t2477 * t765;
  t2481 = t321 * t947;
  t2483 = t316 * t2481 * tau[1];
  t2485 = t140 * t733;
  t2486 = t316 * t2485;
  t2488 = -0.6e1 * t2446 - 0.6e2 * t2450 + 0.32e2 * t2453 - 0.6e1 * t2456 - 0.1e3 * t2459 + 0.12e3 * t2462 - 0.88e2 / 0.3e1 * t2464 - 0.96e3 * t2467 - 0.48e4 * t2469 + 0.128e4 * t2472 - 0.24e3 * t2475 - 0.56e4 * t2479 + 0.384e4 * t2483 - 0.1408e4 / 0.3e1 * t2486;
  t2489 = t151 * t2488;
  t2497 = 0.4e1 * t780 * t1005 * t326 - 0.2e1 * t308 * t1016 * t326 + 0.2e1 * t780 * t382 * t820 + 0.2e1 * t780 * t386 * t781 + 0.6e1 * t737 * t2427 + 0.6e1 * t290 * t2430 + 0.3e1 * t290 * t2433 - t308 * t2439 - t308 * t2441 - 0.2e1 * t308 * t2443 - t308 * t2489;
  t2519 = t1971 * t103;
  t2521 = t1517 / t2519;
  t2522 = t2521 * t723;
  t2524 = 0.5e3 / 0.14348907e8 * t1968 * t2522;
  t2525 = t34 * t733;
  t2527 = 0.11e3 / 0.2187e4 * t281 * t2525;
  t2528 = t290 * t831;
  t2533 = t761 * t124;
  t2534 = t2533 * t107;
  t2537 = -0.6e1 * t742 * t1005 * t302 - 0.6e1 * t742 * t1007 * t326 - 0.6e1 * t1940 * t382 * t738 - 0.6e1 * t1958 * t382 * t781 - 0.6e1 * t742 * t985 * t302 + 0.4e1 * t780 * t985 * t326 - 0.3e1 * t742 * t382 * t774 + 0.3e1 * t2528 * t373 + 0.3e1 * t372 * t2534 + 0.6e1 * t965 * t969 + t2524 + t2527;
  t2539 = t1977 * t151;
  t2540 = t381 * t302;
  t2541 = t2540 * t326;
  t2546 = t968 * t286;
  t2549 = t291 * t733;
  t2552 = t286 * t302;
  t2553 = t291 * t2552;
  t2556 = t107 * t781;
  t2557 = t291 * t2556;
  t2560 = t286 * t326;
  t2561 = t291 * t2560;
  t2564 = t752 * t2461;
  t2567 = t968 * t956;
  t2570 = t107 * t774;
  t2571 = t291 * t2570;
  t2574 = t742 * t335;
  t2577 = 0.12e2 * t2539 * t2541 - 0.16e2 * t965 * t976 - 0.16e2 * t372 * t2546 + 0.88e2 / 0.3e1 * t372 * t2549 - 0.32e2 * t955 * t2553 + 0.6e1 * t2539 * t2557 + 0.16e2 * t960 * t2561 - 0.8e2 * t372 * t2564 + 0.12e2 * t955 * t2567 + 0.6e1 * t955 * t2571 - 0.6e1 * t2574 * t962;
  t2578 = t968 * t961;
  t2581 = t107 * t820;
  t2582 = t291 * t2581;
  t2587 = t296 * t132;
  t2588 = t2587 * t972;
  t2591 = t2010 * t2458;
  t2594 = t737 * t335;
  t2598 = t483 * t728 * sigma[2];
  t2600 = 0.25e2 / 0.19683e5 * t722 * t2598;
  t2601 = t738 * t144;
  t2602 = t2601 * t151;
  t2611 = 0.5e3 / 0.14348907e8 * t2115 * t2522 - 0.25e2 / 0.19683e5 * t826 * t2598 + 0.11e3 / 0.2187e4 * t331 * t2525 - t2524 + t2600 - t2527;
  t2613 = t151 * t120;
  t2614 = t1940 * t2613;
  t2615 = t302 * t326;
  t2616 = t1320 * t2615;
  t2619 = t737 * t2613;
  t2620 = t132 * t768;
  t2621 = t302 * tau[1];
  t2622 = t2620 * t2621;
  t2625 = t742 * t2613;
  t2626 = t326 * tau[1];
  t2627 = t2620 * t2626;
  t2630 = t145 * t2611 - 0.6e1 * t960 * t2578 - 0.3e1 * t960 * t2582 + 0.2e2 * t372 * t2588 + 0.5e2 * t372 * t2591 + 0.12e2 * t2594 * t957 + 0.6e1 * t2602 * t373 - 0.12e2 * t2614 * t2616 + 0.4e2 * t2619 * t2622 - 0.2e2 * t2625 * t2627 + 0.2e2 * t965 * t973 - t2600;
  t2632 = t2497 + t2537 + t2577 + t2630;
  t2637 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t388 - t2395 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t1018 + t2373 - t2402 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t2632);
  tv3rho2sigma8 = t7 * t2637 + 0.2e1 * t1023;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2644 = t6 * t462 * t412;
  t2651 = t6 * t471 * t412 / 0.12e2;
  t2653 = t6 * t172 * t1096;
  t2673 = t592 * t396;
  t2676 = t233 * t1054;
  t2684 = 0.1e1 / t487;
  t2685 = t2684 * t526;
  t2690 = t1555 * t49;
  t2692 = t1043 * t194;
  t2693 = t2692 * tau[0];
  t2694 = t1558 * t2693;
  t2697 = t49 * t522;
  t2698 = t513 * t2697;
  t2700 = t1579 * t2685;
  t2704 = -0.8e1 * t2276 * t49 - 0.16e3 / 0.3e1 * t2310 * t1044 + 0.8e2 / 0.3e1 * t871 - 0.4e3 / 0.3e1 * t1558 * t2685 + 0.16e3 * t875 - 0.32e3 / 0.9e1 * t878 + 0.16e2 * t2690 + 0.16e3 * t2694 - 0.16e3 / 0.3e1 * t890 + 0.16e2 * t2698 + 0.8e3 / 0.3e1 * t2700 - 0.24e3 * t892 + 0.32e3 / 0.9e1 * t894;
  t2705 = t86 * t2704;
  t2708 = t592 * t409;
  t2710 = t233 * t1093;
  t2720 = t219 * t184;
  t2734 = t573 * t2684;
  t2741 = t1604 * t2684;
  t2748 = -0.144e3 * t1558 * t49 * t510 + 0.24e3 * t525 * t889 + 0.96e3 * t557 * t874 - 0.512e4 / 0.3e1 * t72 * t2720 - 0.72e2 * t525 * t2697 - 0.4e4 / 0.3e1 * t1648 * t2685 + 0.48e2 * t2698 + 0.8e3 * t2700 - 0.96e3 * t1579 * t2693 + 0.192e4 * t562 * t403 * t522 + 0.448e5 * t214 * t2734 * t526 - 0.2304e4 * t214 * t406 * t522 - 0.1792e6 / 0.3e1 * t72 * t2741 * t526 + 0.768e4 * t1621 * t403 * t510;
  t2755 = t573 * t529;
  t2773 = -0.1152e5 * t562 * t406 * t510 + 0.768e4 * t214 * t1090 * t194 + 0.2688e5 * t72 * t2755 * tau[0] + 0.48e3 * t2694 - 0.32e3 / 0.3e1 * t210 * t184 + 0.48e2 * t2690 + 0.384e5 * t1629 * t2693 - 0.5376e5 * t1634 * t2693 - 0.64e4 * t897 - 0.2304e5 * t901 - 0.16e3 * t890 - 0.72e3 * t892 + 0.512e4 / 0.3e1 * t904 + 0.32e3 / 0.3e1 * t894;
  t2774 = t2748 + t2773;
  t2775 = t86 * t2774;
  t2777 = -0.6e1 * t503 * t1064 * t200 + 0.4e1 * t541 * t1064 * t224 - 0.6e1 * t503 * t1094 * t200 + 0.4e1 * t541 * t1094 * t224 - 0.3e1 * t503 * t410 * t535 + 0.2e1 * t541 * t410 * t581 + 0.3e1 * t188 * t2673 + 0.6e1 * t188 * t2676 + 0.3e1 * t188 * t2705 - t206 * t2708 - 0.2e1 * t206 * t2710 - t206 * t2775;
  t2781 = t1526 * t86;
  t2782 = t396 * t200;
  t2783 = t2782 * t224;
  t2792 = t409 * t200;
  t2793 = t2792 * t224;
  t2804 = t397 * t535;
  t2816 = 0.12e2 * t498 * t1037 * t200 - 0.6e1 * t503 * t1037 * t224 + 0.12e2 * t498 * t1055 * t200 - 0.6e1 * t503 * t1055 * t224 - 0.6e1 * t1505 * t410 * t542 - 0.6e1 * t1526 * t410 * t499 + 0.6e1 * t1542 * t397 * t542 - 0.3e1 * t503 * t397 * t581 + 0.6e1 * t2265 * t397 + 0.12e2 * t2280 * t2793 - 0.12e2 * t2781 * t2783 + 0.6e1 * t498 * t2804;
  t2817 = t2777 + t2816;
  t2822 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t412 - t2644 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t1096 + t2651 - t2653 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * t2817);
  tv3rho2tau0 = t7 * t2822 + 0.2e1 * t1101;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t2829 = t6 * t617 * t436;
  t2833 = t6 * t621 * t436 / 0.12e2;
  t2835 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t436 - t2829 / 0.4e1 + t2833);
  tv3rho2tau1 = t7 * t2835 + 0.2e1 * t1110;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t2841 = t6 * t642 * t412;
  t2849 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t412 - t2841 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t1096 - t2644 / 0.8e1 + t2651 - t2653 / 0.8e1);
  tv3rho2tau2 = t7 * t2849 + t1101 + t1116;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t2855 = t6 * t666 * t436;
  t2862 = t6 * t251 * t1186;
  t2865 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t436 - t2855 / 0.8e1 - t2829 / 0.8e1 + t2833 - 0.3e1 / 0.8e1 * t6 * t247 * t1186 - t2862 / 0.8e1);
  tv3rho2tau3 = t7 * t2865 + t1110 + t1191;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t2873 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t412 - t2841 / 0.4e1 + t2651);
  tv3rho2tau4 = t7 * t2873 + 0.2e1 * t1116;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t2910 = t421 * t774;
  t2919 = 0.12e2 * t737 * t1127 * t302 - 0.6e1 * t742 * t1127 * t326 + 0.12e2 * t737 * t1145 * t302 - 0.6e1 * t742 * t1145 * t326 - 0.6e1 * t742 * t1154 * t302 + 0.4e1 * t780 * t1154 * t326 - 0.6e1 * t742 * t1184 * t302 + 0.4e1 * t780 * t1184 * t326 - 0.3e1 * t742 * t434 * t774 + 0.2e1 * t780 * t434 * t820 + 0.6e1 * t2601 * t421 + 0.6e1 * t737 * t2910;
  t2923 = t831 * t420;
  t2926 = t335 * t1144;
  t2934 = 0.1e1 / t726;
  t2935 = t2934 * t765;
  t2940 = t2084 * t117;
  t2942 = t1133 * t296;
  t2943 = t2942 * tau[1];
  t2944 = t2010 * t2943;
  t2947 = t117 * t761;
  t2948 = t752 * t2947;
  t2950 = t2019 * t2935;
  t2954 = -0.8e1 * t2533 * t117 - 0.16e3 / 0.3e1 * t2587 * t1134 + 0.8e2 / 0.3e1 * t969 - 0.4e3 / 0.3e1 * t2010 * t2935 + 0.16e3 * t973 - 0.32e3 / 0.9e1 * t976 + 0.16e2 * t2940 + 0.16e3 * t2944 - 0.16e3 / 0.3e1 * t988 + 0.16e2 * t2948 + 0.8e3 / 0.3e1 * t2950 - 0.24e3 * t990 + 0.32e3 / 0.9e1 * t992;
  t2955 = t151 * t2954;
  t2958 = t831 * t433;
  t2960 = t335 * t1183;
  t2971 = t812 * t2934;
  t2978 = t2003 * t2934;
  t2991 = t812 * t768;
  t3000 = -0.32e3 / 0.3e1 * t312 * t286 + 0.48e2 * t2940 - 0.96e3 * t2019 * t2943 + 0.192e4 * t801 * t427 * t761 + 0.448e5 * t316 * t2971 * t765 - 0.2304e4 * t316 * t430 * t761 - 0.1792e6 / 0.3e1 * t137 * t2978 * t765 + 0.768e4 * t1994 * t427 * t749 - 0.1152e5 * t801 * t430 * t749 + 0.768e4 * t316 * t1180 * t296 + 0.2688e5 * t137 * t2991 * tau[1] + 0.48e3 * t2944 + 0.384e5 * t2027 * t2943 - 0.5376e5 * t2032 * t2943;
  t3002 = t321 * t286;
  t3023 = 0.512e4 / 0.3e1 * t1002 - 0.512e4 / 0.3e1 * t137 * t3002 - 0.144e3 * t2010 * t117 * t749 + 0.24e3 * t764 * t987 + 0.96e3 * t796 * t972 - 0.4e4 / 0.3e1 * t2047 * t2935 - 0.72e2 * t764 * t2947 - 0.16e3 * t988 - 0.72e3 * t990 + 0.32e3 / 0.3e1 * t992 - 0.64e4 * t995 - 0.2304e5 * t999 + 0.48e2 * t2948 + 0.8e3 * t2950;
  t3024 = t3000 + t3023;
  t3025 = t151 * t3024;
  t3027 = t1940 * t151;
  t3028 = t420 * t302;
  t3029 = t3028 * t326;
  t3038 = t433 * t302;
  t3039 = t3038 * t326;
  t3045 = -0.6e1 * t1940 * t434 * t738 - 0.6e1 * t1958 * t434 * t781 + 0.6e1 * t1977 * t421 * t781 - 0.3e1 * t742 * t421 * t820 + 0.12e2 * t2539 * t3039 + 0.3e1 * t290 * t2923 + 0.6e1 * t290 * t2926 + 0.3e1 * t290 * t2955 - t308 * t2958 - 0.2e1 * t308 * t2960 - t308 * t3025 - 0.12e2 * t3027 * t3029;
  t3046 = t2919 + t3045;
  t3051 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t436 - t2855 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t1186 + t2833 - t2862 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * t3046);
  tv3rho2tau5 = t7 * t3051 + 0.2e1 * t1191;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t3058 = t6 * t172 * t1230 / 0.8e1;
  t3063 = t1520 * rho[0];
  t3064 = 0.1e1 / t3063;
  t3065 = t1517 * t3064;
  t3066 = t3065 * sigma[0];
  t3069 = t1193 * t849;
  t3073 = 0.125e3 / 0.9565938e7 * t1515 * t3066;
  t3075 = 0.5e2 / 0.177147e6 * t480 * t3069;
  t3076 = -0.125e3 / 0.9565938e7 * t1680 * t3066 + 0.5e2 / 0.177147e6 * t586 * t3069 + t3073 - t3075;
  t3103 = t200 * t79;
  t3104 = t3103 * t86;
  t3109 = t188 * t918;
  t3114 = t529 * t59;
  t3115 = t3114 * t200;
  t3118 = t3114 * t224;
  t3121 = t1581 * t67;
  t3122 = t3121 * tau[0];
  t3125 = t525 * t849;
  t3128 = 0.2e1 * t188 * t86 * t849 * t59 + t80 * t3076 + 0.4e1 * t541 * t1215 * t224 - 0.3e1 * t503 * t1224 * t200 + 0.2e1 * t541 * t1224 * t224 + t3075 - t3073 - 0.3e1 / 0.8e1 * t188 * t233 * t529 * t59 + 0.6e1 * t1542 * t1212 * t200 - 0.6e1 * t1505 * t1212 * t224 + 0.4e1 * t541 * t358 * t906 - 0.6e1 * t503 * t1215 * t200 + 0.6e1 * t3104 * t1197 + 0.6e1 * t2317 * t1197 + 0.6e1 * t3109 * t349 + 0.6e1 * t1204 * t871 - 0.3e1 / 0.4e1 * t857 * t3115 + 0.3e1 / 0.8e1 * t862 * t3118 - 0.5e1 / 0.4e1 * t348 * t3122 - 0.32e2 * t857 * t3125;
  t3131 = t184 * t357;
  t3132 = t189 * t3131;
  t3135 = t1581 * tau[0];
  t3136 = t1579 * t3135;
  t3141 = t870 * t1200;
  t3144 = t39 * t906;
  t3145 = t189 * t3144;
  t3148 = t498 * t362;
  t3151 = t503 * t362;
  t3156 = t529 * t224;
  t3157 = t525 * t3156;
  t3161 = t1558 * t2167;
  t3164 = t1228 * t200;
  t3169 = t233 * t1211;
  t3172 = t918 * t357;
  t3175 = t362 * t906;
  t3178 = t233 * t1223;
  t3180 = t2310 * t529;
  t3182 = t1558 * t3135;
  t3184 = t513 * t849;
  t3187 = t1621 * t1220 * t194;
  t3189 = t219 * t1581;
  t3191 = t562 * t3189 * tau[0];
  t3193 = t75 * t849;
  t3194 = t562 * t3193;
  t3196 = 0.3e1 / 0.4e1 * t3180 + 0.15e2 / 0.4e1 * t3182 - 0.4e1 * t3184 + 0.12e3 * t3187 + 0.3e3 * t3191 - 0.16e3 * t3194;
  t3197 = t86 * t3196;
  t3199 = t1277 * t2281;
  t3202 = t1542 * t2338;
  t3203 = t357 * t224;
  t3204 = t1277 * t3203;
  t3207 = t357 * tau[0];
  t3208 = t2345 * t3207;
  t3211 = -t206 * t1228 * t224 + 0.3e1 * t188 * t3164 - 0.2e1 * t206 * t3172 - 0.2e1 * t206 * t3175 - t206 * t3178 - t206 * t3197 - 0.12e2 * t2339 * t3199 - 0.2e2 * t2350 * t3208 + 0.12e2 * t857 * t3161 + 0.2e1 * t541 * t3169 + 0.12e2 * t3202 * t3204;
  t3213 = -0.6e1 * t2327 * t1201 + 0.2e2 * t1204 * t875 - 0.16e2 * t1204 * t878 - 0.6e1 * t2781 * t3157 + 0.16e2 * t862 * t3132 + 0.4e2 * t857 * t3136 - 0.6e1 * t862 * t3141 - 0.6e1 * t862 * t3145 + 0.12e2 * t3148 * t859 - 0.6e1 * t3151 * t864 + t3128 + t3211;
  t3218 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1230 - t3058 - 0.3e1 / 0.8e1 * t6 * t28 * t3213);
  tv3rhosigma20 = t7 * t3218 + t1234;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t3225 = t6 * t251 * t1271 / 0.8e1;
  t3227 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1271 - t3225);
  tv3rhosigma25 = t7 * t3227 + t1275;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t3233 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1230 - t3058);
  tv3rhosigma26 = t7 * t3233 + t1234;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t3257 = t1971 * rho[1];
  t3258 = 0.1e1 / t3257;
  t3259 = t1517 * t3258;
  t3260 = t3259 * sigma[2];
  t3262 = 0.125e3 / 0.9565938e7 * t1968 * t3260;
  t3273 = t1193 * t947;
  t3275 = 0.5e2 / 0.177147e6 * t721 * t3273;
  t3278 = t764 * t947;
  t3283 = t290 * t1016;
  t3288 = t768 * t124;
  t3289 = t3288 * t302;
  t3292 = t3288 * t326;
  t3295 = t2006 * t132;
  t3296 = t3295 * tau[1];
  t3299 = t302 * t144;
  t3300 = t3299 * t151;
  t3303 = -0.3e1 * t742 * t1265 * t302 + 0.2e1 * t780 * t1265 * t326 + 0.4e1 * t780 * t382 * t1004 - 0.6e1 * t742 * t1256 * t302 + 0.4e1 * t780 * t1256 * t326 + 0.2e1 * t290 * t151 * t947 * t124 - t3262 - 0.3e1 / 0.8e1 * t290 * t335 * t768 * t124 + 0.6e1 * t1977 * t1253 * t302 - 0.6e1 * t1958 * t1253 * t326 + t3275 - 0.16e2 * t1245 * t976 - 0.32e2 * t955 * t3278 + 0.6e1 * t2594 * t1238 + 0.6e1 * t3283 * t373 + 0.6e1 * t1245 * t969 - 0.3e1 / 0.4e1 * t955 * t3289 + 0.3e1 / 0.8e1 * t960 * t3292 - 0.5e1 / 0.4e1 * t372 * t3296 + 0.6e1 * t3300 * t1238;
  t3308 = -0.125e3 / 0.9565938e7 * t2115 * t3260 + 0.5e2 / 0.177147e6 * t825 * t3273 + t3262 - t3275;
  t3310 = t2006 * tau[1];
  t3311 = t2019 * t3310;
  t3316 = t968 * t1241;
  t3319 = t107 * t1004;
  t3320 = t291 * t3319;
  t3323 = t737 * t386;
  t3326 = t742 * t386;
  t3331 = t768 * t326;
  t3332 = t764 * t3331;
  t3335 = t2010 * t2448;
  t3339 = t286 * t381;
  t3340 = t291 * t3339;
  t3343 = t2587 * t768;
  t3345 = t2010 * t3310;
  t3347 = t752 * t947;
  t3350 = t1994 * t1261 * t296;
  t3352 = t321 * t2006;
  t3354 = t801 * t3352 * tau[1];
  t3356 = t140 * t947;
  t3357 = t801 * t3356;
  t3359 = 0.3e1 / 0.4e1 * t3343 + 0.15e2 / 0.4e1 * t3345 - 0.4e1 * t3347 + 0.12e3 * t3350 + 0.3e3 * t3354 - 0.16e3 * t3357;
  t3360 = t151 * t3359;
  t3362 = t1269 * t302;
  t3367 = t335 * t1252;
  t3370 = t1016 * t381;
  t3373 = t386 * t1004;
  t3376 = t335 * t1264;
  t3378 = t1320 * t2540;
  t3381 = t1977 * t2613;
  t3382 = t381 * t326;
  t3383 = t1320 * t3382;
  t3386 = t381 * tau[1];
  t3387 = t2620 * t3386;
  t3390 = -t308 * t1269 * t326 - 0.12e2 * t2614 * t3378 - 0.2e2 * t2625 * t3387 + 0.3e1 * t290 * t3362 - t308 * t3360 - 0.2e1 * t308 * t3370 - 0.2e1 * t308 * t3373 - t308 * t3376 + 0.16e2 * t960 * t3340 + 0.2e1 * t780 * t3367 + 0.12e2 * t3381 * t3383;
  t3392 = -0.6e1 * t2574 * t1242 + 0.2e2 * t1245 * t973 + t145 * t3308 - 0.6e1 * t3027 * t3332 + 0.4e2 * t955 * t3311 - 0.6e1 * t960 * t3316 - 0.6e1 * t960 * t3320 + 0.12e2 * t3323 * t957 - 0.6e1 * t3326 * t962 + 0.12e2 * t955 * t3335 + t3303 + t3390;
  t3397 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1271 - t3225 - 0.3e1 / 0.8e1 * t6 * t102 * t3392);
  tv3rhosigma211 = t7 * t3397 + t1275;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t3404 = t6 * t172 * t1314 / 0.8e1;
  t3447 = t396 * t357;
  t3448 = t3447 * t200;
  t3451 = t3447 * t224;
  t3454 = t409 * t357;
  t3455 = t3454 * t200;
  t3458 = t1505 * t86;
  t3459 = t3454 * t224;
  t3466 = -0.3e1 * t503 * t1037 * t357 - 0.3e1 * t503 * t1055 * t357 + 0.2e1 * t541 * t1064 * t357 + 0.2e1 * t541 * t1094 * t357 + 0.6e1 * t498 * t1284 * t200 - 0.3e1 * t503 * t1284 * t224 + 0.6e1 * t498 * t1291 * t200 - 0.3e1 * t503 * t1291 * t224 - 0.3e1 * t503 * t1301 * t200 + 0.2e1 * t541 * t1301 * t224 - 0.3e1 * t503 * t1312 * t200 + 0.2e1 * t541 * t1312 * t224 - 0.3e1 * t503 * t397 * t906 + 0.2e1 * t541 * t410 * t906 + 0.6e1 * t2317 * t1278 + 0.6e1 * t3104 * t1278 + 0.6e1 * t2280 * t3451 + 0.6e1 * t2280 * t3455 - 0.6e1 * t2781 * t3448 - 0.6e1 * t3458 * t3459;
  t3467 = t1054 * t52;
  t3468 = t3467 * t1277;
  t3471 = t396 * t194;
  t3472 = t3471 * t1277;
  t3477 = t1093 * t52;
  t3478 = t3477 * t1277;
  t3481 = t409 * t194;
  t3482 = t3481 * t1277;
  t3485 = t59 * t184;
  t3486 = t1276 * t3485;
  t3489 = t1294 * t3485;
  t3492 = t233 * t1311;
  t3494 = t2310 * t1043;
  t3496 = t2684 * tau[0];
  t3497 = t1558 * t3496;
  t3500 = t1558 * t2692;
  t3502 = t1579 * t3496;
  t3506 = t1621 * t1306 * t194;
  t3508 = t219 * t2684;
  t3510 = t562 * t3508 * tau[0];
  t3514 = t562 * t1078 * t194;
  t3517 = t214 * t2734 * tau[0];
  t3519 = t214 * t899;
  t3521 = -0.6e1 * t3494 - 0.3e2 * t3497 + 0.26e2 * t1218 + 0.18e2 * t3500 + 0.6e2 * t3502 - 0.39e2 * t1197 - 0.96e3 * t3506 - 0.24e4 * t3510 + 0.104e4 * t1221 + 0.144e4 * t3514 + 0.336e4 * t3517 - 0.1248e4 * t3519;
  t3522 = t86 * t3521;
  t3524 = t362 * t1054;
  t3527 = t233 * t1290;
  t3531 = t2684 * t67;
  t3532 = t3531 * tau[0];
  t3537 = -0.13e2 / 0.3e1 * t3114 + 0.1e2 / 0.3e1 * t3532 - 0.2e1 * t3494 - 0.1e2 * t3497 + 0.26e2 / 0.3e1 * t1218;
  t3538 = t86 * t3537;
  t3541 = t918 * t409;
  t3543 = t362 * t1093;
  t3545 = t918 * t396;
  t3548 = t1526 * t397;
  t3551 = t498 * t397;
  t3554 = t1526 * t410;
  t3557 = t1542 * t410;
  t3560 = t503 * t410;
  t3563 = -0.3e1 * t2327 * t1295 + 0.3e1 * t188 * t3524 + 0.3e1 * t188 * t3527 + 0.3e1 * t188 * t3538 + 0.3e1 * t188 * t3545 - t206 * t3492 - t206 * t3522 - t206 * t3541 - t206 * t3543 + 0.6e1 * t857 * t3468 + 0.6e1 * t857 * t3472 - 0.3e1 * t862 * t3478 - 0.3e1 * t862 * t3482 - 0.16e2 * t857 * t3486 + 0.8e1 * t862 * t3489 - 0.6e1 * t3548 * t864 + 0.2e2 * t3551 * t875 - 0.6e1 * t3554 * t859 + 0.6e1 * t3557 * t864 - 0.1e2 * t3560 * t875;
  t3564 = t3466 + t3563;
  t3569 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1314 - t3404 - 0.3e1 / 0.8e1 * t6 * t28 * t3564);
  tv3rhosigmatau0 = t7 * t3569 + t1318;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t3576 = t6 * t251 * t1357 / 0.8e1;
  t3578 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1357 - t3576);
  tv3rhosigmatau5 = t7 * t3578 + t1361;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t3584 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1314 - t3404);
  tv3rhosigmatau6 = t7 * t3584 + t1318;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t3631 = t1958 * t151;
  t3632 = t433 * t381;
  t3633 = t3632 * t326;
  t3636 = t420 * t381;
  t3637 = t3636 * t302;
  t3640 = t3636 * t326;
  t3643 = t2587 * t1133;
  t3645 = t2934 * tau[1];
  t3646 = t2010 * t3645;
  t3649 = t2010 * t2942;
  t3651 = t2019 * t3645;
  t3655 = t1994 * t1349 * t296;
  t3657 = t321 * t2934;
  t3659 = t801 * t3657 * tau[1];
  t3663 = t801 * t1168 * t296;
  t3666 = t316 * t2971 * tau[1];
  t3668 = t316 * t997;
  t3670 = -0.6e1 * t3643 - 0.3e2 * t3646 + 0.26e2 * t1259 + 0.18e2 * t3649 + 0.6e2 * t3651 - 0.39e2 * t1238 - 0.96e3 * t3655 - 0.24e4 * t3659 + 0.104e4 * t1262 + 0.144e4 * t3663 + 0.336e4 * t3666 - 0.1248e4 * t3668;
  t3671 = t151 * t3670;
  t3673 = t386 * t1183;
  t3675 = t335 * t1354;
  t3677 = -0.3e1 * t742 * t421 * t1004 + 0.2e1 * t780 * t434 * t1004 - 0.3e1 * t742 * t1127 * t381 - 0.3e1 * t742 * t1145 * t381 + 0.2e1 * t780 * t1154 * t381 + 0.2e1 * t780 * t1184 * t381 + 0.6e1 * t737 * t1327 * t302 - 0.3e1 * t742 * t1327 * t326 + 0.6e1 * t737 * t1334 * t302 - 0.3e1 * t742 * t1334 * t326 - 0.3e1 * t742 * t1344 * t302 + 0.2e1 * t780 * t1344 * t326 - 0.3e1 * t742 * t1355 * t302 + 0.2e1 * t780 * t1355 * t326 + 0.6e1 * t2539 * t3640 - 0.6e1 * t3027 * t3637 - t308 * t3671 - t308 * t3673 - t308 * t3675 - 0.6e1 * t3631 * t3633;
  t3678 = t1016 * t420;
  t3681 = t386 * t1144;
  t3684 = t335 * t1333;
  t3688 = t2934 * t132;
  t3689 = t3688 * tau[1];
  t3694 = -0.13e2 / 0.3e1 * t3288 + 0.1e2 / 0.3e1 * t3689 - 0.2e1 * t3643 - 0.1e2 * t3646 + 0.26e2 / 0.3e1 * t1259;
  t3695 = t151 * t3694;
  t3698 = t1016 * t433;
  t3700 = t3632 * t302;
  t3705 = t1183 * t120;
  t3706 = t3705 * t1320;
  t3709 = t433 * t296;
  t3710 = t3709 * t1320;
  t3713 = t124 * t286;
  t3714 = t1319 * t3713;
  t3717 = t1337 * t3713;
  t3724 = t1144 * t120;
  t3725 = t3724 * t1320;
  t3728 = t420 * t296;
  t3729 = t3728 * t1320;
  t3732 = t1940 * t421;
  t3735 = t737 * t421;
  t3738 = t1940 * t434;
  t3741 = t1977 * t434;
  t3744 = t742 * t434;
  t3747 = 0.6e1 * t2594 * t1321 + 0.6e1 * t3300 * t1321 - 0.3e1 * t2574 * t1338 + 0.6e1 * t2539 * t3700 + 0.3e1 * t290 * t3678 + 0.3e1 * t290 * t3681 + 0.3e1 * t290 * t3684 + 0.3e1 * t290 * t3695 - t308 * t3698 - 0.3e1 * t960 * t3706 - 0.3e1 * t960 * t3710 - 0.16e2 * t955 * t3714 + 0.8e1 * t960 * t3717 + 0.6e1 * t955 * t3725 + 0.6e1 * t955 * t3729 - 0.6e1 * t3732 * t962 + 0.2e2 * t3735 * t973 - 0.6e1 * t3738 * t957 + 0.6e1 * t3741 * t962 - 0.1e2 * t3744 * t973;
  t3748 = t3677 + t3747;
  t3753 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1357 - t3576 - 0.3e1 / 0.8e1 * t6 * t102 * t3748);
  tv3rhosigmatau11 = t7 * t3753 + t1361;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t3760 = t6 * t172 * t1401 / 0.8e1;
  t3763 = t1363 * t224;
  t3766 = t233 * t1362;
  t3769 = t397 * t1054;
  t3772 = t396 * t409;
  t3773 = t3772 * t200;
  t3776 = t3772 * t224;
  t3795 = t233 * t1377;
  t3799 = 0.1e1 / t847;
  t3800 = t3799 * t67;
  t3803 = t2310 * t1370;
  t3805 = t3799 * tau[0];
  t3806 = t1558 * t3805;
  t3809 = t1370 * t194;
  t3810 = t1558 * t3809;
  t3812 = t1579 * t3805;
  t3815 = 0.8e2 / 0.3e1 * t1287 - 0.8e2 / 0.3e1 * t3800 * tau[0] + 0.32e2 * t3803 + 0.16e3 * t3806 - 0.32e3 / 0.3e1 * t1288 - 0.48e2 * t3810 - 0.16e3 * t3812 + 0.8e2 * t1304;
  t3816 = t86 * t3815;
  t3825 = t233 * t1381;
  t3837 = t233 * t1398;
  t3854 = t219 * t3799;
  t3862 = t573 * t3799;
  t3870 = t1604 * t3799;
  t3876 = 0.768e4 * t1621 * t1389 * t194 - 0.2304e5 * t562 * t1392 * t194 + 0.16128e5 * t214 * t1395 * t194 - 0.5376e5 * t214 * t3862 * tau[0] + 0.192e5 * t562 * t3854 * tau[0] + 0.3584e5 * t72 * t3870 * tau[0] - 0.32e3 * t557 * t1043 - 0.896e4 * t72 * t1086 + 0.288e3 * t1579 * t3809 + 0.8e3 * t1648 * t3805 - 0.16e3 * t1288 + 0.48e3 * t1304 - 0.64e4 * t1307 + 0.1536e5 * t1309 + 0.48e2 * t3803 + 0.24e3 * t3806 - 0.288e3 * t3810 - 0.96e3 * t3812;
  t3877 = t86 * t3876;
  t3879 = 0.4e1 * t541 * t410 * t1093 - 0.3e1 * t503 * t1378 * t224 - 0.6e1 * t1505 * t1382 * t224 + 0.6e1 * t1542 * t1382 * t200 - 0.3e1 * t503 * t1399 * t200 + 0.2e1 * t541 * t1399 * t224 + 0.3e1 * t188 * t3795 + 0.3e1 * t188 * t3816 - t206 * t3837 - t206 * t3877 + 0.2e1 * t541 * t3825;
  t3880 = -0.6e1 * t503 * t1037 * t409 - 0.6e1 * t503 * t1055 * t409 - 0.6e1 * t503 * t397 * t1093 + 0.6e1 * t498 * t1378 * t200 + 0.6e1 * t3103 * t1363 - 0.6e1 * t1526 * t3763 + 0.12e2 * t2280 * t3776 - 0.12e2 * t2781 * t3773 + 0.6e1 * t498 * t3766 + 0.12e2 * t498 * t3769 + t3879;
  t3885 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t1401 - t3760 - 0.3e1 / 0.8e1 * t6 * t28 * t3880);
  tv3rhotau20 = t7 * t3885 + t1405;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t3892 = t6 * t251 * t1445 / 0.8e1;
  t3894 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t1445 - t3892);
  tv3rhotau22 = t7 * t3894 + t1449;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t3900 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t1401 - t3760);
  tv3rhotau23 = t7 * t3900 + t1405;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t3907 = t1407 * t326;
  t3910 = t335 * t1406;
  t3913 = t421 * t1144;
  t3916 = t420 * t433;
  t3917 = t3916 * t302;
  t3920 = t3916 * t326;
  t3939 = t335 * t1421;
  t3943 = 0.1e1 / t945;
  t3944 = t3943 * t132;
  t3947 = t2587 * t1414;
  t3949 = t3943 * tau[1];
  t3950 = t2010 * t3949;
  t3953 = t1414 * t296;
  t3954 = t2010 * t3953;
  t3956 = t2019 * t3949;
  t3959 = 0.8e2 / 0.3e1 * t1330 - 0.8e2 / 0.3e1 * t3944 * tau[1] + 0.32e2 * t3947 + 0.16e3 * t3950 - 0.32e3 / 0.3e1 * t1331 - 0.48e2 * t3954 - 0.16e3 * t3956 + 0.8e2 * t1347;
  t3960 = t151 * t3959;
  t3969 = t335 * t1425;
  t3981 = t335 * t1442;
  t3998 = t321 * t3943;
  t4006 = t812 * t3943;
  t4014 = t2003 * t3943;
  t4020 = 0.3584e5 * t137 * t4014 * tau[1] + 0.768e4 * t1994 * t1433 * t296 - 0.2304e5 * t801 * t1436 * t296 + 0.16128e5 * t316 * t1439 * t296 - 0.5376e5 * t316 * t4006 * tau[1] + 0.192e5 * t801 * t3998 * tau[1] - 0.32e3 * t796 * t1133 - 0.896e4 * t137 * t1176 + 0.288e3 * t2019 * t3953 + 0.8e3 * t2047 * t3949 - 0.16e3 * t1331 + 0.48e3 * t1347 - 0.64e4 * t1350 + 0.1536e5 * t1352 + 0.48e2 * t3947 + 0.24e3 * t3950 - 0.288e3 * t3954 - 0.96e3 * t3956;
  t4021 = t151 * t4020;
  t4023 = 0.4e1 * t780 * t434 * t1183 - 0.3e1 * t742 * t1422 * t326 - 0.6e1 * t1958 * t1426 * t326 + 0.6e1 * t1977 * t1426 * t302 - 0.3e1 * t742 * t1443 * t302 + 0.2e1 * t780 * t1443 * t326 + 0.3e1 * t290 * t3939 + 0.3e1 * t290 * t3960 - t308 * t3981 - t308 * t4021 + 0.2e1 * t780 * t3969;
  t4024 = -0.6e1 * t742 * t1127 * t433 - 0.6e1 * t742 * t1145 * t433 - 0.6e1 * t742 * t421 * t1183 + 0.6e1 * t737 * t1422 * t302 + 0.6e1 * t3299 * t1407 - 0.6e1 * t1940 * t3907 + 0.12e2 * t2539 * t3920 - 0.12e2 * t3027 * t3917 + 0.6e1 * t737 * t3910 + 0.12e2 * t737 * t3913 + t4023;
  t4029 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t1445 - t3892 - 0.3e1 / 0.8e1 * t6 * t102 * t4024);
  tv3rhotau25 = t7 * t4029 + t1449;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t4031 = t39 * t1211;
  t4032 = t189 * t4031;
  t4035 = t1211 * t357;
  t4036 = t86 * t4035;
  t4048 = t1558 * t1581;
  t4051 = t3114 * t357;
  t4054 = t188 * t1228;
  t4057 = t1517 * t1581;
  t4059 = t1515 * t4057;
  t4061 = 0.125e3 / 0.25509168e8 * t1680 * t4057 - 0.125e3 / 0.25509168e8 * t4059;
  t4064 = t362 * t1211;
  t4067 = t1228 * t357;
  t4070 = t362 * t1223;
  t4074 = t75 * t1581;
  t4075 = t1621 * t4074;
  t4077 = -0.3e1 / 0.32e2 * t3121 - 0.15e2 * t4075;
  t4078 = t86 * t4077;
  t4082 = t39 * t1223;
  t4083 = t189 * t4082;
  t4086 = t529 * t357;
  t4087 = t525 * t4086;
  t4090 = t1581 * t79;
  t4094 = 0.18e2 * t2280 * t4032 - 0.6e1 * t1505 * t4036 + 0.6e1 * t541 * t358 * t1223 - 0.9e1 / 0.8e1 * t188 * t362 * t529 * t59 + 0.18e2 * t3148 * t1197 - 0.9e1 / 0.4e1 * t857 * t4048 + 0.9e1 / 0.8e1 * t862 * t4051 + 0.9e1 * t4054 * t349 + t80 * t4061 + 0.125e3 / 0.25509168e8 * t4059 + 0.6e1 * t541 * t4064 - 0.3e1 * t206 * t4067 - 0.3e1 * t206 * t4070 - t206 * t4078 - 0.18e2 * t3151 * t1201 - 0.9e1 * t862 * t4083 - 0.18e2 * t2781 * t4087 + 0.6e1 * t1648 * t4090 * t86;
  t4098 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4094);
  tv3sigma30 = t7 * t4098;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t4099 = t1517 * t2006;
  t4100 = t1968 * t4099;
  t4102 = t386 * t1252;
  t4105 = t1269 * t381;
  t4108 = t386 * t1264;
  t4112 = t140 * t2006;
  t4113 = t1994 * t4112;
  t4115 = -0.3e1 / 0.32e2 * t3295 - 0.15e2 * t4113;
  t4116 = t151 * t4115;
  t4118 = t2006 * t144;
  t4122 = t107 * t1252;
  t4123 = t291 * t4122;
  t4130 = t1252 * t381;
  t4131 = t151 * t4130;
  t4139 = t2010 * t2006;
  t4142 = t3288 * t381;
  t4145 = t290 * t1269;
  t4150 = 0.125e3 / 0.25509168e8 * t2115 * t4099 - 0.125e3 / 0.25509168e8 * t4100;
  t4152 = t768 * t381;
  t4153 = t764 * t4152;
  t4158 = t107 * t1264;
  t4159 = t291 * t4158;
  t4162 = 0.125e3 / 0.25509168e8 * t4100 + 0.6e1 * t780 * t4102 - 0.3e1 * t308 * t4105 - 0.3e1 * t308 * t4108 - t308 * t4116 + 0.6e1 * t2047 * t4118 * t151 + 0.18e2 * t2539 * t4123 - 0.9e1 / 0.8e1 * t290 * t386 * t768 * t124 - 0.6e1 * t1958 * t4131 + 0.6e1 * t780 * t382 * t1264 + 0.18e2 * t3323 * t1238 - 0.9e1 / 0.4e1 * t955 * t4139 + 0.9e1 / 0.8e1 * t960 * t4142 + 0.9e1 * t4145 * t373 + t145 * t4150 - 0.18e2 * t3027 * t4153 - 0.18e2 * t3326 * t1242 - 0.9e1 * t960 * t4159;
  t4166 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4162);
  tv3sigma39 = t7 * t4166;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t4169 = t1290 * t52;
  t4170 = t4169 * t1277;
  t4175 = t1311 * t52;
  t4176 = t4175 * t1277;
  t4179 = t1228 * t396;
  t4182 = t362 * t1290;
  t4185 = t1228 * t409;
  t4187 = t362 * t1311;
  t4191 = t1558 * t2684;
  t4193 = t75 * t2684;
  t4194 = t1621 * t4193;
  t4196 = t562 * t3508;
  t4198 = 0.3e1 / 0.4e1 * t3531 - 0.9e1 / 0.4e1 * t4191 + 0.12e3 * t4194 - 0.18e3 * t4196;
  t4199 = t86 * t4198;
  t4208 = 0.4e1 * t541 * t1301 * t357 - 0.12e2 * t3548 * t1201 + 0.12e2 * t3557 * t1201 + 0.12e2 * t3148 * t1278 - 0.6e1 * t3151 * t1295 + 0.3e1 * t188 * t4179 + 0.6e1 * t188 * t4182 - t206 * t4185 - 0.2e1 * t206 * t4187 - t206 * t4199 + 0.12e2 * t857 * t4170 - 0.6e1 * t862 * t4176;
  t4228 = t396 * t529;
  t4229 = t4228 * t59;
  t4235 = t409 * t529;
  t4236 = t4235 * t59;
  t4242 = t79 * t86;
  t4243 = t4242 * t396;
  t4246 = t409 * t53;
  t4247 = t209 * t529;
  t4248 = t4246 * t4247;
  t4251 = 0.4e1 * t541 * t1312 * t357 + 0.2e1 * t541 * t410 * t1223 - 0.6e1 * t503 * t1284 * t357 - 0.6e1 * t503 * t1291 * t357 - 0.3e1 * t503 * t397 * t1223 + 0.3e1 / 0.4e1 * t188 * t86 * t2684 * t67 - 0.3e1 / 0.4e1 * t857 * t4229 + 0.6e1 * t1542 * t397 * t1211 + 0.3e1 / 0.8e1 * t862 * t4236 - 0.6e1 * t1505 * t410 * t1211 + 0.6e1 * t1197 * t4243 - 0.6e1 * t2781 * t4248;
  t4252 = t4208 + t4251;
  t4256 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4252);
  tv3sigma2tau0 = t7 * t4256;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t4270 = t420 * t768;
  t4271 = t4270 * t124;
  t4277 = t433 * t768;
  t4278 = t4277 * t124;
  t4286 = t1333 * t120;
  t4287 = t4286 * t1320;
  t4292 = t1354 * t120;
  t4293 = t4292 * t1320;
  t4296 = 0.3e1 / 0.4e1 * t290 * t151 * t2934 * t132 + 0.4e1 * t780 * t1344 * t381 + 0.4e1 * t780 * t1355 * t381 + 0.2e1 * t780 * t434 * t1264 - 0.3e1 / 0.4e1 * t955 * t4271 + 0.6e1 * t1977 * t421 * t1252 + 0.3e1 / 0.8e1 * t960 * t4278 - 0.6e1 * t1958 * t434 * t1252 + 0.12e2 * t3323 * t1321 + 0.12e2 * t955 * t4287 - 0.6e1 * t3326 * t1338 - 0.6e1 * t960 * t4293;
  t4297 = t1269 * t420;
  t4300 = t386 * t1333;
  t4303 = t1269 * t433;
  t4305 = t386 * t1354;
  t4309 = t2010 * t2934;
  t4311 = t140 * t2934;
  t4312 = t1994 * t4311;
  t4314 = t801 * t3657;
  t4316 = 0.3e1 / 0.4e1 * t3688 - 0.9e1 / 0.4e1 * t4309 + 0.12e3 * t4312 - 0.18e3 * t4314;
  t4317 = t151 * t4316;
  t4332 = t144 * t151;
  t4333 = t4332 * t420;
  t4336 = t433 * t121;
  t4337 = t311 * t768;
  t4338 = t4336 * t4337;
  t4341 = -0.3e1 * t742 * t421 * t1264 - 0.6e1 * t742 * t1327 * t381 - 0.6e1 * t742 * t1334 * t381 + 0.6e1 * t1238 * t4333 - 0.12e2 * t3732 * t1242 + 0.12e2 * t3741 * t1242 + 0.3e1 * t290 * t4297 + 0.6e1 * t290 * t4300 - 0.6e1 * t3027 * t4338 - t308 * t4303 - 0.2e1 * t308 * t4305 - t308 * t4317;
  t4342 = t4296 + t4341;
  t4346 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4342);
  tv3sigma2tau11 = t7 * t4346;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t4347 = t4242 * t1362;
  t4350 = t1363 * t357;
  t4353 = t362 * t1362;
  t4356 = t397 * t1290;
  t4361 = t3772 * t357;
  t4373 = t1377 * t52;
  t4374 = t4373 * t1277;
  t4381 = t362 * t1377;
  t4385 = t1558 * t3799;
  t4387 = -0.4e1 * t3800 + 0.6e1 * t4385;
  t4388 = t86 * t4387;
  t4391 = t1381 * t52;
  t4392 = t4391 * t1277;
  t4398 = t362 * t1381;
  t4404 = t1398 * t52;
  t4405 = t4404 * t1277;
  t4411 = t362 * t1398;
  t4415 = t1579 * t3799;
  t4417 = t75 * t3799;
  t4418 = t1621 * t4417;
  t4420 = t562 * t3854;
  t4422 = t214 * t3862;
  t4424 = -0.6e1 * t3800 + 0.36e2 * t4385 - 0.36e2 * t4415 - 0.96e3 * t4418 + 0.288e4 * t4420 - 0.2016e4 * t4422;
  t4425 = t86 * t4424;
  t4427 = 0.4e1 * t541 * t410 * t1311 - 0.3e1 * t503 * t1378 * t357 - 0.6e1 * t1505 * t1382 * t357 + 0.2e1 * t541 * t1399 * t357 + 0.3e1 * t188 * t4381 + 0.3e1 * t188 * t4388 - t206 * t4411 - t206 * t4425 + 0.6e1 * t2280 * t4392 + 0.2e1 * t541 * t4398 - 0.3e1 * t862 * t4405;
  t4428 = -0.6e1 * t503 * t1284 * t409 - 0.6e1 * t503 * t1291 * t409 - 0.6e1 * t503 * t397 * t1311 - 0.12e2 * t3548 * t1295 - 0.6e1 * t1526 * t4350 + 0.12e2 * t2280 * t4361 + 0.6e1 * t349 * t4347 + 0.6e1 * t498 * t4353 + 0.12e2 * t498 * t4356 + 0.6e1 * t857 * t4374 + t4427;
  t4432 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4428);
  tv3sigmatau20 = t7 * t4432;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t4433 = t4332 * t1406;
  t4436 = t1407 * t381;
  t4439 = t386 * t1406;
  t4442 = t421 * t1333;
  t4447 = t3916 * t381;
  t4459 = t1421 * t120;
  t4460 = t4459 * t1320;
  t4467 = t386 * t1421;
  t4471 = t2010 * t3943;
  t4473 = -0.4e1 * t3944 + 0.6e1 * t4471;
  t4474 = t151 * t4473;
  t4477 = t1425 * t120;
  t4478 = t4477 * t1320;
  t4484 = t386 * t1425;
  t4490 = t1442 * t120;
  t4491 = t4490 * t1320;
  t4497 = t386 * t1442;
  t4501 = t2019 * t3943;
  t4503 = t140 * t3943;
  t4504 = t1994 * t4503;
  t4506 = t801 * t3998;
  t4508 = t316 * t4006;
  t4510 = -0.6e1 * t3944 + 0.36e2 * t4471 - 0.36e2 * t4501 - 0.96e3 * t4504 + 0.288e4 * t4506 - 0.2016e4 * t4508;
  t4511 = t151 * t4510;
  t4513 = 0.4e1 * t780 * t434 * t1354 - 0.3e1 * t742 * t1422 * t381 - 0.6e1 * t1958 * t1426 * t381 + 0.2e1 * t780 * t1443 * t381 + 0.6e1 * t2539 * t4478 + 0.3e1 * t290 * t4467 + 0.3e1 * t290 * t4474 - t308 * t4497 - t308 * t4511 + 0.2e1 * t780 * t4484 - 0.3e1 * t960 * t4491;
  t4514 = -0.6e1 * t742 * t1327 * t433 - 0.6e1 * t742 * t1334 * t433 - 0.6e1 * t742 * t421 * t1354 - 0.12e2 * t3732 * t1338 - 0.6e1 * t1940 * t4436 + 0.12e2 * t2539 * t4447 + 0.6e1 * t373 * t4433 + 0.6e1 * t737 * t4439 + 0.12e2 * t737 * t4442 + 0.6e1 * t955 * t4460 + t4513;
  t4518 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4514);
  tv3sigmatau28 = t7 * t4518;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4519 = t1362 * t396;
  t4520 = t4519 * t79;
  t4523 = t1363 * t409;
  t4526 = t397 * t1377;
  t4538 = 0.1e1 / t527;
  t4540 = 0.48e2 * t4538 * t67;
  t4541 = t1558 * t4538;
  t4543 = t1579 * t4538;
  t4545 = t4540 - 0.144e3 * t4541 + 0.96e2 * t4543;
  t4546 = t86 * t4545;
  t4549 = t1381 * t409;
  t4550 = t86 * t4549;
  t4560 = t75 * t4538;
  t4563 = t219 * t4538;
  t4566 = t573 * t4538;
  t4569 = t1604 * t4538;
  t4572 = 0.768e4 * t1621 * t4560 - 0.48e3 * t1648 * t4538 + 0.48384e5 * t214 * t4566 - 0.3456e5 * t562 * t4563 - 0.21504e5 * t72 * t4569 + t4540 - 0.432e3 * t4541 + 0.864e3 * t4543;
  t4573 = t86 * t4572;
  t4575 = -0.9e1 * t503 * t1378 * t409 + 0.18e2 * t1542 * t397 * t1381 - 0.9e1 * t503 * t397 * t1398 + 0.6e1 * t541 * t410 * t1398 - 0.6e1 * t1505 * t4550 - 0.18e2 * t1526 * t4523 + 0.3e1 * t188 * t4546 - t206 * t4573 + 0.6e1 * t4520 * t86 + 0.18e2 * t498 * t4526;
  t4579 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t4575);
  tv3tau30 = t7 * t4579;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4580 = t1406 * t420;
  t4581 = t4580 * t144;
  t4584 = t1407 * t433;
  t4587 = t421 * t1421;
  t4599 = 0.1e1 / t766;
  t4601 = 0.48e2 * t4599 * t132;
  t4602 = t2010 * t4599;
  t4604 = t2019 * t4599;
  t4606 = t4601 - 0.144e3 * t4602 + 0.96e2 * t4604;
  t4607 = t151 * t4606;
  t4610 = t1425 * t433;
  t4611 = t151 * t4610;
  t4621 = t140 * t4599;
  t4624 = t321 * t4599;
  t4627 = t812 * t4599;
  t4630 = t2003 * t4599;
  t4633 = -0.21504e5 * t137 * t4630 + 0.768e4 * t1994 * t4621 - 0.48e3 * t2047 * t4599 + 0.48384e5 * t316 * t4627 - 0.3456e5 * t801 * t4624 + t4601 - 0.432e3 * t4602 + 0.864e3 * t4604;
  t4634 = t151 * t4633;
  t4636 = -0.9e1 * t742 * t1422 * t433 + 0.18e2 * t1977 * t421 * t1425 - 0.9e1 * t742 * t421 * t1442 + 0.6e1 * t780 * t434 * t1442 + 0.6e1 * t4581 * t151 - 0.18e2 * t1940 * t4584 - 0.6e1 * t1958 * t4611 + 0.3e1 * t290 * t4607 - t308 * t4634 + 0.18e2 * t737 * t4587;
  t4640 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t4636);
  tv3tau33 = t7 * t4640;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t4645 = t6 * t1469 * t171 * t88;
  t4649 = t6 * t457 * t470 * t88;
  t4653 = t6 * t165 * t1492 * t88;
  t4656 = 0.1e1 / t170 / t448;
  t4660 = 0.1e2 / 0.27e2 * t6 * t26 * t4656 * t88;
  t4662 = t6 * t1474 * t235;
  t4668 = t6 * t1481 * t235;
  t4670 = t6 * t462 * t594;
  t4676 = t6 * t1493 * t235;
  t4679 = t6 * t471 * t594;
  t4682 = t6 * t172 * t1690;
  t4689 = t176 / t1678 / t81 * t1517;
  t4690 = t484 * t484;
  t4695 = t4690 / t37 / t1520 / t847 * t34;
  t4698 = t1520 * t486;
  t4700 = t1519 / t4698;
  t4705 = t485 / t36 / t3063;
  t4709 = 0.1e1 / t37 / t847;
  t4710 = t181 * t4709;
  t4716 = t176 / t1513 / t43 * t1517;
  t4718 = 0.16e6 / 0.31381059609e11 * t4716 * t4695;
  t4720 = 0.88e5 / 0.43046721e8 * t1515 * t4700;
  t4722 = 0.1958e6 / 0.4782969e7 * t481 * t4705;
  t4724 = 0.2618e5 / 0.19683e5 * t180 * t4710;
  t4727 = t224 * t581;
  t4754 = t522 * t522;
  t4757 = tau[0] * t1573;
  t4761 = 0.616e4 / 0.81e2 * t4757 - 0.2618e4 / 0.81e2 * sigma[0] * t4709;
  t4765 = t1576 * tau[0] * t39;
  t4769 = t522 * t526 * t529;
  t4772 = t1570 * t194;
  t4775 = t1563 * t184;
  t4778 = t1559 * t849;
  t4781 = t1609 * t184;
  t4784 = t214 * t1604;
  t4785 = t1582 * t194;
  t4791 = t1621 * t219;
  t4796 = t562 * t573;
  t4798 = t510 * t526 * t529;
  t4804 = t52 * t556;
  t4811 = t53 * t75;
  t4814 = 0.288e3 * t1555 * t522 + 0.144e3 * t513 * t4754 + 0.24e2 * t197 * t4761 + 0.1536e5 * t566 * t4765 + 0.2688e6 * t1634 * t4769 + 0.45056e6 / 0.3e1 * t566 * t4772 - 0.6144e5 * t566 * t4775 - 0.14336e7 * t1634 * t4778 - 0.3072e6 * t1629 * t4781 + 0.7168e7 / 0.3e1 * t4784 * t4785 + 0.288e4 * t1558 * t194 * t1564 + 0.3072e6 * t4791 * t1622 * tau[0] * t39 + 0.1344e7 * t4796 * t4798 + 0.2304e6 * t1629 * t1645 * t190 + 0.96e4 * t4804 * t4798 + 0.48e3 * t525 * t4765 + 0.48e4 * t1579 * t4769 + 0.8e5 / 0.3e1 * t4811 * t4785;
  t4839 = 0.1e1 / t572 / t58;
  t4840 = t526 * t526;
  t4843 = 0.1e1 / t37 / t2223;
  t4847 = t1622 * t209;
  t4850 = t526 * t489;
  t4855 = params->b * t53;
  t4856 = t510 * t510;
  t4863 = t1580 * t3064;
  t4869 = t65 * t219;
  t4870 = t4840 * t4843;
  t4876 = 0.1408e5 / 0.3e1 * t525 * t4772 + 0.4608e5 * t1621 * t563 * t522 + 0.768e4 * t562 * t215 * t1576 - 0.78848e6 / 0.27e2 * t72 * t220 * t1573 - 0.14336e8 / 0.9e1 * t72 * t1605 * t3064 - 0.384e4 * t1558 * t4781 - 0.192e4 * t525 * t4775 - 0.256e5 * t1579 * t4778 + 0.121856e8 / 0.27e2 * t72 * t574 * t489 + 0.448e7 / 0.3e1 * t72 * t4839 * t4840 * t4843 + 0.96e3 * t4847 * t190 + 0.4352e6 / 0.27e2 * t557 * t4850 - 0.4928e5 / 0.27e2 * t210 * t4757 + 0.2304e5 * t4855 * t75 * t4856 + 0.576e4 * t562 * t75 * t4754 - 0.32e6 / 0.9e1 * t1648 * t4863 + 0.192e3 * t513 * t194 * t1576 + 0.2e6 / 0.9e1 * t4869 * t4870 + 0.384e3 * t214 * t75 * t4761;
  t4908 = t510 * t209;
  t4913 = -0.24e2 * t4754 * t59 - 0.32e2 * t870 * t1576 - 0.8e1 * t189 * t4761 + 0.128e5 / 0.3e1 * t1558 * t4778 + 0.128e4 / 0.3e1 * t513 * t4775 - 0.2816e5 / 0.27e2 * t513 * t4772 - 0.1088e6 / 0.27e2 * t525 * t4850 + 0.4928e5 / 0.81e2 * t197 * t4757 - 0.32e3 * t2310 * t1564 + 0.128e4 / 0.3e1 * t1555 * t518 - 0.8e3 * t1558 * t4769 - 0.32e5 / 0.9e1 * t4804 * t4785 - 0.32e3 / 0.3e1 * t513 * t4765 + 0.64e5 / 0.9e1 * t1579 * t4863 - 0.8e3 * t4908 * t530 - 0.1e6 / 0.27e2 * t4811 * t4870;
  t4932 = 0.24e2 * t1664 * t233 + t80 * (-0.16e6 / 0.31381059609e11 * t4689 * t4695 + 0.88e5 / 0.43046721e8 * t1680 * t4700 - 0.1958e6 / 0.4782969e7 * t587 * t4705 + 0.2618e5 / 0.19683e5 * t230 * t4710 + t4718 - t4720 + t4722 - t4724) + t4724 + 0.72e2 * t2280 * t4727 * t200 - 0.72e2 * t2781 * t2340 * t535 - t4722 - t4718 + 0.24e2 * t498 * t201 * t1590 - 0.36e2 * t503 * t1546 * t224 - 0.36e2 * t503 * t1550 * t224 - 0.36e2 * t1526 * t500 * t581 + 0.72e2 * t498 * t507 * t535 - 0.4e1 * t206 * t233 * t1660 - t206 * t86 * (t4814 + t4876) + 0.3e1 * t188 * t86 * t4913 + 0.12e2 * t541 * t592 * t542 - 0.4e1 * t206 * t1687 * t224 - 0.6e1 * t206 * t592 * t581 - 0.24e2 * t1505 * t233 * t1506 + 0.12e2 * t188 * t1687 * t200;
  t4957 = t63 * t1504;
  t4974 = t62 * t540;
  t4980 = t535 * t535;
  t4984 = t581 * t581;
  t4988 = t1663 * t205;
  t4993 = t64 / t1503 / t78;
  t4994 = t542 * t542;
  t5001 = 0.72e2 * t1542 * t507 * t542 + 0.36e2 * t1542 * t536 * t542 - 0.12e2 * t503 * t1591 * t224 + 0.72e2 * t4974 * t500 * t542 + 0.18e2 * t498 * t86 * t4980 + 0.36e2 * t498 * t592 * t499 + 0.6e1 * t541 * t86 * t4984 + 0.24e2 * t4993 * t86 * t4994 - 0.24e2 * t4988 * t225 + 0.36e2 * t2265 * t536 + t4720;
  t5007 = t20 * t20;
  t5009 = 0.1e1 / t443 / t5007;
  t5010 = t445 * t445;
  t5016 = t453 * t453;
  t5022 = 0.1e1 / t1460 / t7;
  t5023 = t17 * t5022;
  t5026 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t1461 + 0.24e2 * t5023);
  t5030 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5009 * t5010 - 0.16e2 / 0.9e1 * t1453 * t445 * t453 + 0.4e1 / 0.3e1 * t444 * t5016 + 0.16e2 / 0.9e1 * t1457 * t1465 + 0.4e1 / 0.3e1 * t24 * t5026);
  t5038 = -t4645 / 0.2e1 + t4649 / 0.2e1 - 0.5e1 / 0.9e1 * t4653 + t4660 - 0.3e1 / 0.2e1 * t4662 - 0.9e1 / 0.4e1 * t6 * t458 * t594 + t4668 - 0.3e1 / 0.2e1 * t4670 - 0.3e1 / 0.2e1 * t6 * t166 * t1690 - 0.5e1 / 0.9e1 * t4676 + t4679 / 0.2e1 - t4682 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t28 * (-0.36e2 * t1505 * t543 * t581 - 0.72e2 * t4957 * t1507 * t200 - 0.72e2 * t1526 * t1667 * t224 + 0.12e2 * t188 * t233 * t1590 - 0.12e2 * t503 * t201 * t1660 + 0.8e1 * t541 * t225 * t1660 + 0.18e2 * t188 * t592 * t535 - 0.36e2 * t503 * t507 * t581 - 0.18e2 * t503 * t536 * t581 + 0.24e2 * t541 * t546 * t581 + t4932 + t5001) - 0.3e1 / 0.8e1 * t6 * t5030 * t27 * t88 - 0.3e1 / 0.2e1 * t6 * t1470 * t235;
  t5039 = my_piecewise3(t2, 0, t5038);
  t5040 = t97 * t97;
  t5042 = 0.1e1 / t600 / t5040;
  t5043 = t602 * t602;
  t5049 = t608 * t608;
  t5054 = t94 * t5022;
  t5057 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t1461 + 0.24e2 * t5054);
  t5061 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t5043 - 0.16e2 / 0.9e1 * t1697 * t602 * t608 + 0.4e1 / 0.3e1 * t601 * t5049 + 0.16e2 / 0.9e1 * t1701 * t1707 + 0.4e1 / 0.3e1 * t99 * t5057);
  t5068 = t6 * t1711 * t171 * t153;
  t5072 = t6 * t612 * t470 * t153;
  t5076 = t6 * t246 * t1492 * t153;
  t5081 = 0.1e2 / 0.27e2 * t6 * t101 * t4656 * t153;
  t5083 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t5061 * t27 * t153 - t5068 / 0.2e1 + t5072 / 0.2e1 - 0.5e1 / 0.9e1 * t5076 + t5081);
  tv4rho40 = 0.4e1 * t1695 + 0.4e1 * t1729 + t7 * (t5039 + t5083);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t5090 = t6 * t1749 * t171 * t88;
  t5094 = t6 * t637 * t470 * t88;
  t5095 = t5094 / 0.4e1;
  t5098 = t6 * t263 * t1492 * t88;
  t5119 = 0.12e2 * t1461;
  t5120 = 0.24e2 * t5023;
  t5122 = my_piecewise5(t11, 0, t15, 0, -t5119 + t5120);
  t5126 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5009 * t260 * t1454 - 0.8e1 / 0.9e1 * t1453 * t633 * t445 - 0.8e1 / 0.9e1 * t1734 * t162 * t453 + 0.4e1 / 0.3e1 * t444 * t1745 * t162 + 0.4e1 / 0.3e1 * t1737 * t453 + 0.4e1 / 0.9e1 * t629 * t1465 + 0.4e1 / 0.3e1 * t24 * t5122);
  t5135 = t6 * t1754 * t235;
  t5141 = t6 * t1761 * t235;
  t5142 = t5141 / 0.4e1;
  t5144 = t6 * t642 * t594;
  t5155 = -0.3e1 / 0.8e1 * t5090 + t5095 - 0.5e1 / 0.36e2 * t5098 - t4645 / 0.8e1 + t4649 / 0.4e1 - 0.5e1 / 0.12e2 * t4653 + t4660 - 0.3e1 / 0.8e1 * t6 * t5126 * t27 * t88 - 0.9e1 / 0.8e1 * t6 * t1750 * t235 - 0.3e1 / 0.4e1 * t5135 - 0.9e1 / 0.8e1 * t6 * t638 * t594 + t5142 - 0.3e1 / 0.8e1 * t5144 - 0.3e1 / 0.8e1 * t6 * t264 * t1690 - 0.3e1 / 0.8e1 * t4662 + t4668 / 0.2e1 - 0.3e1 / 0.8e1 * t4670 - 0.5e1 / 0.12e2 * t4676 + t4679 / 0.4e1 - t4682 / 0.8e1;
  t5156 = my_piecewise3(t2, 0, t5155);
  t5173 = 0.24e2 * t5054;
  t5175 = my_piecewise5(t15, 0, t11, 0, t5119 + t5173);
  t5179 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t271 * t1698 - 0.8e1 / 0.9e1 * t1697 * t657 * t602 - 0.8e1 / 0.9e1 * t1778 * t243 * t608 + 0.4e1 / 0.3e1 * t601 * t1788 * t243 + 0.4e1 / 0.3e1 * t1781 * t608 + 0.4e1 / 0.9e1 * t653 * t1707 + 0.4e1 / 0.3e1 * t99 * t5175);
  t5186 = t6 * t1792 * t171 * t153;
  t5190 = t6 * t661 * t470 * t153;
  t5191 = t5190 / 0.4e1;
  t5194 = t6 * t274 * t1492 * t153;
  t5203 = t6 * t1716 * t337;
  t5206 = t6 * t1720 * t337;
  t5207 = t5206 / 0.4e1;
  t5209 = t6 * t1724 * t337;
  t5211 = -0.3e1 / 0.8e1 * t6 * t5179 * t27 * t153 - 0.3e1 / 0.8e1 * t5186 + t5191 - 0.5e1 / 0.36e2 * t5194 - t5068 / 0.8e1 + t5072 / 0.4e1 - 0.5e1 / 0.12e2 * t5076 + t5081 - 0.3e1 / 0.8e1 * t6 * t1712 * t337 - 0.3e1 / 0.8e1 * t5203 + t5207 - 0.5e1 / 0.36e2 * t5209;
  t5212 = my_piecewise3(t93, 0, t5211);
  tv4rho41 = t1695 + t1729 + 0.3e1 * t1777 + 0.3e1 * t1817 + t7 * (t5156 + t5212);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t5221 = t6 * t1833 * t171 * t88;
  t5225 = t6 * t692 * t470 * t88;
  t5240 = t633 * t633;
  t5253 = my_piecewise5(t11, 0, t15, 0, t5120);
  t5257 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5009 * t683 * t445 - 0.32e2 / 0.27e2 * t1734 * t162 * t633 - 0.8e1 / 0.27e2 * t1820 * t453 + 0.8e1 / 0.9e1 * t444 * t5240 + 0.8e1 / 0.9e1 * t629 * t1745 - 0.8e1 / 0.27e2 * t1453 * t688 * t445 + 0.8e1 / 0.9e1 * t444 * t1829 * t162 + 0.4e1 / 0.9e1 * t1825 * t453 + 0.4e1 / 0.3e1 * t24 * t5253);
  t5266 = t6 * t1838 * t235;
  t5277 = -t5221 / 0.4e1 + t5225 / 0.12e2 - t5090 / 0.4e1 + t5094 / 0.3e1 - 0.5e1 / 0.18e2 * t5098 + t4649 / 0.12e2 - 0.5e1 / 0.18e2 * t4653 + t4660 - 0.3e1 / 0.8e1 * t6 * t5257 * t27 * t88 - 0.3e1 / 0.4e1 * t6 * t1834 * t235 - t5266 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t693 * t594 - t5135 / 0.2e1 + t5141 / 0.3e1 - t5144 / 0.4e1 + t4668 / 0.6e1 - 0.5e1 / 0.18e2 * t4676 + t4679 / 0.12e2;
  t5278 = my_piecewise3(t2, 0, t5277);
  t5287 = t657 * t657;
  t5300 = my_piecewise5(t15, 0, t11, 0, t5173);
  t5304 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t700 * t602 - 0.32e2 / 0.27e2 * t1778 * t243 * t657 - 0.8e1 / 0.27e2 * t1850 * t608 + 0.8e1 / 0.9e1 * t601 * t5287 + 0.8e1 / 0.9e1 * t653 * t1788 - 0.8e1 / 0.27e2 * t1697 * t705 * t602 + 0.8e1 / 0.9e1 * t601 * t1859 * t243 + 0.4e1 / 0.9e1 * t1855 * t608 + 0.4e1 / 0.3e1 * t99 * t5300);
  t5311 = t6 * t1863 * t171 * t153;
  t5315 = t6 * t709 * t470 * t153;
  t5324 = t6 * t1797 * t337;
  t5327 = t6 * t1801 * t337;
  t5338 = t6 * t617 * t833;
  t5341 = t6 * t621 * t833;
  t5343 = -0.3e1 / 0.8e1 * t6 * t5304 * t27 * t153 - t5311 / 0.4e1 + t5315 / 0.12e2 - t5186 / 0.4e1 + t5190 / 0.3e1 - 0.5e1 / 0.18e2 * t5194 - 0.3e1 / 0.4e1 * t6 * t1793 * t337 - t5324 / 0.2e1 + t5327 / 0.6e1 + t5072 / 0.12e2 - 0.5e1 / 0.18e2 * t5076 + t5081 - t5203 / 0.4e1 + t5206 / 0.3e1 - 0.5e1 / 0.18e2 * t5209 - 0.3e1 / 0.8e1 * t6 * t613 * t833 - t5338 / 0.4e1 + t5341 / 0.12e2;
  t5344 = my_piecewise3(t93, 0, t5343);
  tv4rho42 = 0.2e1 * t1777 + 0.2e1 * t1817 + 0.2e1 * t1849 + 0.2e1 * t1888 + t7 * (t5278 + t5344);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t5365 = my_piecewise5(t11, 0, t15, 0, t5119 + t5120);
  t5369 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5009 * t1893 * t162 - 0.8e1 / 0.9e1 * t1820 * t633 - 0.8e1 / 0.9e1 * t1734 * t688 * t162 + 0.4e1 / 0.3e1 * t1737 * t688 + 0.4e1 / 0.3e1 * t629 * t1829 + 0.4e1 / 0.9e1 * t444 * t1900 * t162 + 0.4e1 / 0.3e1 * t24 * t5365);
  t5376 = t6 * t1904 * t171 * t88;
  t5387 = -0.3e1 / 0.8e1 * t6 * t5369 * t27 * t88 - t5376 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t1905 * t235 - 0.3e1 / 0.8e1 * t5221 + t5225 / 0.4e1 - 0.3e1 / 0.8e1 * t5266 + t5095 - 0.5e1 / 0.12e2 * t5098 + t5142 - 0.5e1 / 0.36e2 * t4653 + t4660 - 0.5e1 / 0.36e2 * t4676;
  t5388 = my_piecewise3(t2, 0, t5387);
  t5405 = my_piecewise5(t15, 0, t11, 0, -t5119 + t5173);
  t5409 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t1913 * t243 - 0.8e1 / 0.9e1 * t1850 * t657 - 0.8e1 / 0.9e1 * t1778 * t705 * t243 + 0.4e1 / 0.3e1 * t1781 * t705 + 0.4e1 / 0.3e1 * t653 * t1859 + 0.4e1 / 0.9e1 * t601 * t1920 * t243 + 0.4e1 / 0.3e1 * t99 * t5405);
  t5416 = t6 * t1924 * t171 * t153;
  t5424 = t6 * t1868 * t337;
  t5433 = t6 * t666 * t833;
  t5443 = t6 * t251 * t2125;
  t5445 = -0.3e1 / 0.8e1 * t6 * t5409 * t27 * t153 - t5416 / 0.8e1 - 0.3e1 / 0.8e1 * t5311 + t5315 / 0.4e1 - 0.9e1 / 0.8e1 * t6 * t1864 * t337 - 0.3e1 / 0.8e1 * t5424 + t5191 - 0.5e1 / 0.12e2 * t5194 - 0.3e1 / 0.4e1 * t5324 + t5327 / 0.2e1 - 0.9e1 / 0.8e1 * t6 * t662 * t833 - 0.3e1 / 0.8e1 * t5433 - 0.5e1 / 0.36e2 * t5076 + t5081 + t5207 - 0.5e1 / 0.12e2 * t5209 - 0.3e1 / 0.8e1 * t5338 + t5341 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t247 * t2125 - t5443 / 0.8e1;
  t5446 = my_piecewise3(t93, 0, t5445);
  tv4rho43 = 0.3e1 * t1849 + 0.3e1 * t1888 + t1912 + t2130 + t7 * (t5388 + t5446);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t5451 = t683 * t683;
  t5456 = t688 * t688;
  t5463 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t1461 + 0.24e2 * t5023);
  t5467 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5009 * t5451 - 0.16e2 / 0.9e1 * t1820 * t688 + 0.4e1 / 0.3e1 * t444 * t5456 + 0.16e2 / 0.9e1 * t629 * t1900 + 0.4e1 / 0.3e1 * t24 * t5463);
  t5476 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t5467 * t27 * t88 - t5376 / 0.2e1 + t5225 / 0.2e1 - 0.5e1 / 0.9e1 * t5098 + t4660);
  t5485 = t761 * t765 * t768;
  t5488 = t120 * t795;
  t5490 = t296 * t2004 * t2006;
  t5494 = t2056 * tau[1] * t107;
  t5497 = t2004 * t3258;
  t5500 = t765 * t728;
  t5503 = tau[1] * t2053;
  t5506 = t749 * t311;
  t5509 = t121 * t140;
  t5510 = t765 * t765;
  t5512 = 0.1e1 / t105 / t2519;
  t5513 = t5510 * t5512;
  t5516 = t761 * t761;
  t5523 = 0.1e1 / t105 / t945;
  t5526 = 0.616e4 / 0.81e2 * t5503 - 0.2618e4 / 0.81e2 * sigma[2] * t5523;
  t5529 = t2020 * t947;
  t5532 = t2015 * t286;
  t5535 = t753 * t733;
  t5538 = -0.32e3 * t2587 * t2016 + 0.128e4 / 0.3e1 * t2084 * t757 - 0.8e3 * t2010 * t5485 - 0.32e5 / 0.9e1 * t5488 * t5490 - 0.32e3 / 0.3e1 * t752 * t5494 + 0.64e5 / 0.9e1 * t2019 * t5497 - 0.1088e6 / 0.27e2 * t764 * t5500 + 0.4928e5 / 0.81e2 * t299 * t5503 - 0.8e3 * t5506 * t769 - 0.1e6 / 0.27e2 * t5509 * t5513 - 0.24e2 * t5516 * t124 - 0.32e2 * t968 * t2056 - 0.8e1 * t291 * t5526 + 0.128e5 / 0.3e1 * t2010 * t5529 + 0.128e4 / 0.3e1 * t752 * t5532 - 0.2816e5 / 0.27e2 * t752 * t5535;
  t5550 = params->b * t121;
  t5551 = t749 * t749;
  t5558 = t1995 * t311;
  t5568 = t130 * t321;
  t5576 = t1994 * t321;
  t5581 = t316 * t2003;
  t5587 = t801 * t812;
  t5589 = t749 * t765 * t768;
  t5596 = t2011 * t286;
  t5601 = -0.4928e5 / 0.27e2 * t312 * t5503 + 0.2304e5 * t5550 * t140 * t5551 + 0.576e4 * t801 * t140 * t5516 + 0.96e3 * t5558 * t292 + 0.4352e6 / 0.27e2 * t796 * t5500 - 0.32e6 / 0.9e1 * t2047 * t5497 + 0.192e3 * t752 * t296 * t2056 + 0.2e6 / 0.9e1 * t5568 * t5513 + 0.384e3 * t316 * t140 * t5526 + 0.45056e6 / 0.3e1 * t805 * t5535 + 0.3072e6 * t5576 * t1995 * tau[1] * t107 + 0.7168e7 / 0.3e1 * t5581 * t5490 + 0.288e4 * t2010 * t296 * t2016 + 0.1344e7 * t5587 * t5589 + 0.1536e5 * t805 * t5494 + 0.2688e6 * t2032 * t5485 - 0.3072e6 * t2027 * t5596 - 0.6144e5 * t805 * t5532;
  t5611 = 0.1e1 / t811 / t123;
  t5650 = -0.14336e7 * t2032 * t5529 + 0.4608e5 * t1994 * t802 * t761 + 0.768e4 * t801 * t317 * t2056 + 0.448e7 / 0.3e1 * t137 * t5611 * t5510 * t5512 + 0.96e4 * t5488 * t5589 + 0.48e3 * t764 * t5494 + 0.48e4 * t2019 * t5485 + 0.8e5 / 0.3e1 * t5509 * t5490 + 0.1408e5 / 0.3e1 * t764 * t5535 - 0.78848e6 / 0.27e2 * t137 * t322 * t2053 - 0.14336e8 / 0.9e1 * t137 * t2005 * t3258 - 0.384e4 * t2010 * t5596 - 0.192e4 * t764 * t5532 - 0.256e5 * t2019 * t5529 + 0.121856e8 / 0.27e2 * t137 * t813 * t728 + 0.2304e6 * t2027 * t2044 * t292 + 0.288e3 * t2084 * t761 + 0.144e3 * t752 * t5516 + 0.24e2 * t299 * t5526;
  t5672 = t820 * t820;
  t5678 = t129 / t1956 / t143;
  t5679 = t781 * t781;
  t5685 = t774 * t774;
  t5689 = t2069 * t307;
  t5694 = t724 / t104 / t3257;
  t5696 = 0.1958e6 / 0.4782969e7 * t722 * t5694;
  t5697 = t283 * t5523;
  t5699 = 0.2618e5 / 0.19683e5 * t282 * t5697;
  t5703 = t302 * t820;
  t5707 = 0.12e2 * t290 * t335 * t2101 + 0.3e1 * t290 * t151 * t5538 - 0.24e2 * t1958 * t335 * t1959 - 0.4e1 * t308 * t335 * t2066 - t308 * t151 * (t5601 + t5650) + 0.36e2 * t737 * t831 * t738 + 0.12e2 * t290 * t2122 * t302 + 0.18e2 * t290 * t831 * t774 + 0.12e2 * t780 * t831 * t781 - 0.4e1 * t308 * t2122 * t326 - 0.6e1 * t308 * t831 * t820 + 0.6e1 * t780 * t151 * t5672 + 0.24e2 * t5678 * t151 * t5679 + 0.36e2 * t2601 * t775 + 0.18e2 * t737 * t151 * t5685 - 0.24e2 * t5689 * t327 - t5696 + t5699 - 0.72e2 * t3027 * t2615 * t774 + 0.72e2 * t2539 * t5703 * t326;
  t5711 = t1971 * t725;
  t5713 = t1970 / t5711;
  t5715 = 0.88e5 / 0.43046721e8 * t1968 * t5713;
  t5716 = t127 * t779;
  t5732 = t128 * t1957;
  t5770 = t176 / t1966 / t111 * t1517;
  t5771 = t723 * t723;
  t5776 = t5771 / t105 / t1971 / t945 * t34;
  t5778 = 0.16e6 / 0.31381059609e11 * t5770 * t5776;
  t5784 = t176 / t2113 / t146 * t1517;
  t5795 = -0.36e2 * t742 * t746 * t820 - 0.12e2 * t742 * t2102 * t326 + 0.24e2 * t737 * t303 * t2101 - 0.36e2 * t742 * t2076 * t326 - 0.36e2 * t742 * t2079 * t326 - 0.36e2 * t1940 * t739 * t820 + 0.72e2 * t737 * t746 * t774 - 0.72e2 * t1940 * t2073 * t326 - t5778 + 0.24e2 * t2070 * t335 + t145 * (-0.16e6 / 0.31381059609e11 * t5784 * t5776 + 0.88e5 / 0.43046721e8 * t2115 * t5713 - 0.1958e6 / 0.4782969e7 * t826 * t5694 + 0.2618e5 / 0.19683e5 * t332 * t5697 + t5778 - t5715 + t5696 - t5699);
  t5809 = t700 * t700;
  t5814 = t705 * t705;
  t5821 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t1461 + 0.24e2 * t5054);
  t5825 = my_piecewise3(t98, 0, 0.4e2 / 0.81e2 * t5042 * t5809 - 0.16e2 / 0.9e1 * t1850 * t705 + 0.4e1 / 0.3e1 * t601 * t5814 + 0.16e2 / 0.9e1 * t653 * t1920 + 0.4e1 / 0.3e1 * t99 * t5821);
  t5839 = -0.3e1 / 0.8e1 * t6 * t102 * (-0.36e2 * t1958 * t782 * t820 - 0.72e2 * t5732 * t1960 * t302 + 0.72e2 * t1977 * t746 * t781 + 0.36e2 * t1977 * t775 * t781 - 0.12e2 * t742 * t303 * t2066 + 0.8e1 * t780 * t327 * t2066 + 0.72e2 * t5716 * t739 * t781 - 0.18e2 * t742 * t775 * t820 + 0.24e2 * t780 * t785 * t820 + t5707 + t5715 + t5795) - 0.3e1 / 0.2e1 * t5433 - t5443 / 0.2e1 + t5315 / 0.2e1 + t5327 + t5341 / 0.2e1 - t5416 / 0.2e1 - 0.3e1 / 0.2e1 * t5424 - 0.5e1 / 0.9e1 * t5194 - 0.5e1 / 0.9e1 * t5209 + t5081 - 0.3e1 / 0.8e1 * t6 * t5825 * t27 * t153 - 0.3e1 / 0.2e1 * t6 * t1925 * t337 - 0.9e1 / 0.4e1 * t6 * t710 * t833 - 0.3e1 / 0.2e1 * t6 * t275 * t2125;
  t5840 = my_piecewise3(t93, 0, t5839);
  tv4rho44 = 0.4e1 * t1912 + 0.4e1 * t2130 + t7 * (t5476 + t5840);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t5848 = t6 * t1474 * t364;
  t5854 = t6 * t1481 * t364;
  t5857 = t6 * t462 * t920;
  t5864 = 0.5e1 / 0.36e2 * t6 * t1493 * t364;
  t5866 = t6 * t471 * t920;
  t5869 = t6 * t172 * t2357;
  t5875 = 0.1e1 / t37 / t1520 / t527 * t1518 * t34;
  t5879 = t1517 * t1522 * t484;
  t5883 = t483 * t1674 * sigma[0];
  t5886 = t34 * t1573;
  t5890 = 0.2e5 / 0.10460353203e11 * t4716 * t5875;
  t5892 = 0.95e4 / 0.14348907e8 * t1515 * t5879;
  t5894 = 0.1705e5 / 0.1594323e7 * t481 * t5883;
  t5896 = 0.154e4 / 0.6561e4 * t179 * t5886;
  t5941 = t80 * (0.2e5 / 0.10460353203e11 * t4689 * t5875 - 0.95e4 / 0.14348907e8 * t1680 * t5879 + 0.1705e5 / 0.1594323e7 * t587 * t5883 - 0.154e4 / 0.6561e4 * t229 * t5886 - t5890 + t5892 - t5894 + t5896) - 0.18e2 * t503 * t2210 * t224 + 0.18e2 * t498 * t2213 * t200 - 0.9e1 * t503 * t2213 * t224 + 0.2e1 * t541 * t358 * t1660 - 0.18e2 * t1526 * t2152 * t224 + 0.12e2 * t541 * t2149 * t224 + 0.6e1 * t541 * t887 * t581 + 0.6e1 * t541 * t907 * t581 - 0.9e1 * t503 * t887 * t535 - 0.9e1 * t503 * t907 * t535 - 0.3e1 * t503 * t358 * t1590 + 0.6e1 * t541 * t2158 * t224 - 0.18e2 * t1526 * t907 * t499 - 0.18e2 * t1505 * t887 * t542;
  t5957 = t357 * t535;
  t5971 = t1576 * t59;
  t5975 = t4974 * t86;
  t5983 = -0.18e2 * t1505 * t907 * t542 - 0.9e1 * t503 * t2158 * t200 - 0.18e2 * t503 * t2149 * t200 + 0.24e2 * t4993 * t358 * t1506 + 0.18e2 * t1542 * t909 * t542 - t5892 - t5896 + 0.18e2 * t2280 * t5957 * t224 + 0.18e2 * t2280 * t2281 * t581 + 0.3e1 * t188 * t1687 * t349 + 0.9e1 * t2271 * t871 + 0.9e1 * t867 * t2277 + 0.3e1 * t348 * t5971 * t39 + 0.36e2 * t5975 * t357 * t499 * t224 - 0.18e2 * t2781 * t2281 * t535;
  t5985 = t1542 * t233;
  t5988 = t906 * t200;
  t6008 = t4957 * t86;
  t6026 = 0.36e2 * t5985 * t2282 + 0.36e2 * t2280 * t5988 * t224 - 0.24e2 * t2271 * t878 - 0.48e2 * t867 * t2253 + 0.88e2 * t867 * t2256 + 0.18e2 * t2265 * t233 * t349 + 0.18e2 * t2266 * t871 + t5894 - 0.48e2 * t2266 * t878 - 0.24e2 * t348 * t2276 * t184 - 0.54e2 * t6008 * t2281 * t542 + 0.88e2 * t348 * t870 * t494 - 0.1232e4 / 0.9e1 * t348 * t189 * t1573 - 0.12e3 * t2339 * t2345 * t2340 * tau[0] - 0.48e2 * t857 * t189 * t184 * t535;
  t6038 = t3064 * t526;
  t6044 = t503 * t592;
  t6061 = t194 * t209;
  t6067 = 0.24e2 * t862 * t189 * t184 * t581 - 0.8e3 * t348 * t1558 * t6038 + 0.15e3 * t348 * t6061 * t2177 - 0.24e3 * t348 * t2310 * t2180 + 0.18e2 * t2280 * t870 * t2298 + 0.48e2 * t862 * t870 * t2303 + 0.3e2 * t2271 * t875 - 0.18e2 * t2327 * t2285 - 0.96e2 * t2317 * t2295 + 0.18e2 * t5985 * t2299 + 0.48e2 * t2327 * t2304 + 0.6e2 * t867 * t2311 + 0.15e3 * t867 * t2314 + 0.36e2 * t2317 * t2320 - 0.9e1 * t6044 * t864;
  t6070 = t4843 * t1580;
  t6082 = t489 * tau[0];
  t6086 = t498 * t592;
  t6089 = t499 * t205;
  t6090 = t6089 * t86;
  t6112 = t522 * t67;
  t6116 = 0.1e4 / 0.3e1 * t348 * t4804 * t6070 + 0.176e3 * t857 * t189 * t494 * t200 - 0.88e2 * t862 * t189 * t494 * t224 + 0.544e4 / 0.9e1 * t348 * t513 * t6082 + 0.18e2 * t6086 * t859 - 0.18e2 * t6090 * t864 + 0.6e2 * t2266 * t875 + 0.18e2 * t2317 * t2324 + 0.18e2 * t857 * t870 * t2323 + 0.6e1 * t857 * t189 * t39 * t1590 - 0.9e1 * t2327 * t2289 + 0.18e2 * t857 * t2276 * t858 - 0.9e1 * t862 * t2276 * t863 + 0.3e2 * t348 * t6112 * t874 + t5890;
  t6180 = t849 * t194;
  t6181 = t6180 * tau[0];
  t6184 = t1621 * t75;
  t6188 = 0.1232e4 / 0.9e1 * t197 * t1573 + 0.48e2 * t1555 * t184 - 0.176e3 * t513 * t494 * t194 + 0.16e4 * t1579 * t6038 - 0.272e4 / 0.3e1 * t525 * t6082 + 0.19712e5 / 0.9e1 * t214 * t75 * t1573 - 0.18e2 * t2310 * t2174 - 0.9e2 * t4908 * t874 + 0.48e2 * t513 * t184 * t522 - 0.6e1 * t513 * t39 * t1576 - 0.25e4 / 0.3e1 * t4811 * t6070 + 0.576e5 * t1629 * t6181 - 0.288e4 * t6184 * t889 * t522;
  t6193 = t529 * t522;
  t6194 = t6193 * tau[0];
  t6197 = t1581 * t194;
  t6198 = t6197 * t526;
  t6234 = -0.288e5 * t4791 * t529 * t510 * tau[0] - 0.72e4 * t1629 * t6194 - 0.84e5 * t4796 * t6198 - 0.9e2 * t1558 * t6194 - 0.8704e5 / 0.3e1 * t214 * t219 * t489 * tau[0] - 0.6e3 * t4804 * t6198 + 0.192e4 * t562 * t903 * t522 - 0.24e3 * t562 * t354 * t1576 - 0.224e6 / 0.3e1 * t214 * t1604 * t4843 * t1580 - 0.704e4 * t562 * t2204 * t194 + 0.896e5 * t214 * t573 * t3064 * t526 + 0.72e3 * t1558 * t6181 - 0.288e4 * t4855 * t354 * t1622 + 0.768e4 * t1621 * t903 * t510;
  t6244 = -0.96e2 * t857 * t870 * t2294 - 0.18e2 * t6008 * t189 * t39 * t1506 - 0.48e2 * t2280 * t189 * t184 * t542 - 0.9e1 * t862 * t870 * t2288 - 0.3e1 * t862 * t189 * t39 * t1660 - 0.24e3 * t867 * t2307 + 0.18e2 * t3104 * t2324 + 0.3e1 * t188 * t362 * t1590 - 0.3e1 * t206 * t2336 * t224 - 0.3e1 * t206 * t918 * t581 - 0.3e1 * t206 * t592 * t906 - 0.3e1 * t206 * t233 * t2207 - t206 * t86 * (t6188 + t6234) + 0.9e1 * t188 * t2336 * t200 + 0.9e1 * t188 * t918 * t535;
  t6281 = t67 * t849;
  t6289 = -t206 * t362 * t1660 - t206 * t1687 * t357 - 0.6e1 * t4988 * t358 + 0.6e1 * t541 * t918 * t542 - 0.6e1 * t1505 * t362 * t1506 + 0.18e2 * t498 * t918 * t499 + 0.6e1 * t1664 * t362 - 0.18e2 * t3458 * t3203 * t581 - 0.9e1 * t503 * t2163 * t200 + 0.6e1 * t541 * t2163 * t224 - 0.18e2 * t1526 * t887 * t499 - 0.9e1 * t503 * t2208 * t200 + 0.6e1 * t541 * t2208 * t224 - 0.48e3 * t2344 * t6281 * t2346 + 0.6e2 * t3202 * t2345 * t542 * tau[0];
  t6293 = t4974 * t2338;
  t6309 = t233 * t52;
  t6310 = t503 * t6309;
  t6324 = t86 * t194;
  t6328 = t503 * t6324;
  t6331 = t209 * t1581;
  t6340 = t1526 * t6309;
  t6346 = t1526 * t6324;
  t6349 = -0.18e2 * t2339 * t1277 * t581 * t200 + 0.36e2 * t6293 * t1277 * t200 * t542 - 0.18e2 * t2339 * t1277 * t535 * t224 + 0.3e3 * t2344 * t6331 * t526 * t200 - 0.15e3 * t2350 * t6331 * t526 * t224 + 0.6e2 * t2344 * t2345 * t535 * tau[0] - 0.3e2 * t2350 * t2345 * t581 * tau[0] + 0.18e2 * t3202 * t1277 * t4727 + 0.96e2 * t2339 * t3485 * t2340 + 0.12e3 * t498 * t6309 * t2347 + 0.12e3 * t498 * t6324 * t2347 + 0.24e3 * t2350 * t6281 * t2351 - 0.36e2 * t6340 * t2341 - 0.36e2 * t6346 * t2341 - 0.6e2 * t6310 * t2352 - 0.6e2 * t6328 * t2352;
  t6357 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1470 * t364 - 0.3e1 / 0.8e1 * t5848 - 0.9e1 / 0.8e1 * t6 * t458 * t920 + t5854 / 0.4e1 - 0.3e1 / 0.4e1 * t5857 - 0.9e1 / 0.8e1 * t6 * t166 * t2357 - t5864 + t5866 / 0.4e1 - 0.3e1 / 0.8e1 * t5869 - 0.3e1 / 0.8e1 * t6 * t28 * (t5941 + t5983 + t6026 + t6067 + t6116 + t6244 + t6289 + t6349));
  tv4rho3sigma0 = t7 * t6357 + 0.3e1 * t2362;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t6364 = t6 * t1716 * t388;
  t6367 = t6 * t1720 * t388;
  t6371 = 0.5e1 / 0.36e2 * t6 * t1724 * t388;
  t6373 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1712 * t388 - 0.3e1 / 0.8e1 * t6364 + t6367 / 0.4e1 - t6371);
  tv4rho3sigma2 = t7 * t6373 + 0.3e1 * t2375;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t6375 = 0.2e1 * t2389;
  t6381 = t6 * t1754 * t364 / 0.4e1;
  t6386 = t6 * t1761 * t364;
  t6390 = t6 * t642 * t920 / 0.4e1;
  t6399 = -0.3e1 / 0.8e1 * t6 * t1750 * t364 - t6381 - 0.3e1 / 0.4e1 * t6 * t638 * t920 + t6386 / 0.12e2 - t6390 - 0.3e1 / 0.8e1 * t6 * t264 * t2357 - t5848 / 0.8e1 + t5854 / 0.6e1 - t5857 / 0.4e1 - t5864 + t5866 / 0.6e1 - t5869 / 0.8e1;
  t6400 = my_piecewise3(t2, 0, t6399);
  tv4rho3sigma3 = t7 * t6400 + t2362 + t6375;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t6402 = 0.2e1 * t2405;
  t6408 = t6 * t1797 * t388 / 0.4e1;
  t6410 = t6 * t1801 * t388;
  t6419 = t6 * t617 * t1018 / 0.4e1;
  t6421 = t6 * t621 * t1018;
  t6424 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1793 * t388 - t6408 + t6410 / 0.12e2 - t6364 / 0.8e1 + t6367 / 0.6e1 - t6371 - 0.3e1 / 0.8e1 * t6 * t613 * t1018 - t6419 + t6421 / 0.12e2);
  tv4rho3sigma5 = t7 * t6424 + t2375 + t6402;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t6430 = t6 * t1838 * t364;
  t6439 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1834 * t364 - t6430 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t693 * t920 - t6381 + t6386 / 0.6e1 - t6390 + t5854 / 0.12e2 - t5864 + t5866 / 0.12e2);
  tv4rho3sigma6 = t7 * t6439 + t2413 + t6375;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t6445 = t6 * t1868 * t388;
  t6452 = t6 * t666 * t1018;
  t6460 = t6 * t251 * t2632;
  t6462 = -0.3e1 / 0.8e1 * t6 * t1864 * t388 - t6445 / 0.8e1 - t6408 + t6410 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t662 * t1018 - t6452 / 0.4e1 + t6367 / 0.12e2 - t6371 - t6419 + t6421 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t247 * t2632 - t6460 / 0.8e1;
  t6463 = my_piecewise3(t93, 0, t6462);
  tv4rho3sigma8 = t7 * t6463 + t2637 + t6402;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t6472 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1905 * t364 - 0.3e1 / 0.8e1 * t6430 + t6386 / 0.4e1 - t5864);
  tv4rho3sigma9 = t7 * t6472 + 0.3e1 * t2413;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t6493 = 0.1e1 / t105 / t1971 / t766 * t1969 * t34;
  t6497 = t1517 * t1973 * t723;
  t6501 = t483 * t2109 * sigma[2];
  t6504 = t34 * t2053;
  t6508 = 0.2e5 / 0.10460353203e11 * t5770 * t6493;
  t6510 = 0.95e4 / 0.14348907e8 * t1968 * t6497;
  t6512 = 0.1705e5 / 0.1594323e7 * t722 * t6501;
  t6514 = 0.154e4 / 0.6561e4 * t281 * t6504;
  t6535 = t1994 * t140;
  t6543 = t768 * t761;
  t6544 = t6543 * tau[1];
  t6547 = t2006 * t296;
  t6548 = t6547 * t765;
  t6551 = t947 * t296;
  t6552 = t6551 * tau[1];
  t6561 = t3258 * t765;
  t6564 = t728 * tau[1];
  t6571 = 0.48e2 * t2084 * t286 + 0.1232e4 / 0.9e1 * t299 * t2053 - 0.288e4 * t6535 * t987 * t761 - 0.288e5 * t5576 * t768 * t749 * tau[1] - 0.72e4 * t2027 * t6544 - 0.84e5 * t5587 * t6548 + 0.576e5 * t2027 * t6552 + 0.19712e5 / 0.9e1 * t316 * t140 * t2053 - 0.176e3 * t752 * t733 * t296 + 0.16e4 * t2019 * t6561 - 0.272e4 / 0.3e1 * t764 * t6564 - 0.18e2 * t2587 * t2455 - 0.9e2 * t5506 * t972;
  t6578 = t5512 * t2004;
  t6614 = 0.48e2 * t752 * t286 * t761 - 0.6e1 * t752 * t107 * t2056 - 0.25e4 / 0.3e1 * t5509 * t6578 - 0.704e4 * t801 * t2485 * t296 + 0.896e5 * t316 * t812 * t3258 * t765 - 0.8704e5 / 0.3e1 * t316 * t321 * t728 * tau[1] + 0.72e3 * t2010 * t6552 - 0.288e4 * t5550 * t378 * t1995 + 0.768e4 * t1994 * t1001 * t749 + 0.192e4 * t801 * t1001 * t761 - 0.24e3 * t801 * t378 * t2056 - 0.224e6 / 0.3e1 * t316 * t2003 * t5512 * t2004 - 0.9e2 * t2010 * t6544 - 0.6e3 * t5488 * t6548;
  t6635 = t145 * (0.2e5 / 0.10460353203e11 * t5784 * t6493 - 0.95e4 / 0.14348907e8 * t2115 * t6497 + 0.1705e5 / 0.1594323e7 * t826 * t6501 - 0.154e4 / 0.6561e4 * t331 * t6504 - t6508 + t6510 - t6512 + t6514) - 0.12e3 * t2614 * t2620 * t2615 * tau[1] + 0.6e1 * t2070 * t386 - t6510 - t6514 - 0.3e1 * t308 * t1016 * t820 - t308 * t386 * t2066 - 0.3e1 * t308 * t335 * t2488 - t308 * t151 * (t6571 + t6614) + 0.9e1 * t290 * t1016 * t774 + 0.3e1 * t290 * t386 * t2101 + 0.9e1 * t290 * t2611 * t302 - 0.3e1 * t308 * t2611 * t326 - t308 * t2122 * t381 - 0.3e1 * t308 * t831 * t1004;
  t6646 = t5716 * t151;
  t6654 = t1977 * t335;
  t6657 = t1004 * t302;
  t6661 = t381 * t774;
  t6681 = -0.6e1 * t1958 * t386 * t1959 - 0.6e1 * t5689 * t382 - 0.48e2 * t965 * t2546 - 0.24e2 * t372 * t2533 * t286 + 0.36e2 * t6646 * t381 * t738 * t326 - 0.18e2 * t3027 * t2540 * t774 + 0.36e2 * t6654 * t2541 + 0.36e2 * t2539 * t6657 * t326 + 0.18e2 * t2539 * t6661 * t326 + 0.18e2 * t2539 * t2540 * t820 + 0.18e2 * t2601 * t335 * t373 + 0.18e2 * t2602 * t969 - 0.24e2 * t2528 * t976 - 0.18e2 * t3631 * t3382 * t820 + 0.3e1 * t290 * t2122 * t373;
  t6687 = t2056 * t124;
  t6698 = t5732 * t151;
  t6711 = t737 * t831;
  t6721 = 0.9e1 * t2528 * t969 + 0.9e1 * t965 * t2534 + 0.3e1 * t372 * t6687 * t107 + 0.88e2 * t965 * t2549 + 0.88e2 * t372 * t968 * t733 - 0.48e2 * t2602 * t976 - 0.54e2 * t6698 * t2540 * t781 - 0.1232e4 / 0.9e1 * t372 * t291 * t2053 + t6512 + 0.6e1 * t780 * t1016 * t781 + 0.18e2 * t737 * t1016 * t738 + 0.18e2 * t6711 * t957 + 0.36e2 * t2594 * t2567 + 0.18e2 * t2594 * t2571 + 0.18e2 * t955 * t2533 * t956;
  t6730 = t761 * t132;
  t6734 = t296 * t311;
  t6740 = t738 * t307;
  t6741 = t6740 * t151;
  t6746 = t742 * t831;
  t6765 = -0.3e1 * t960 * t291 * t107 * t2066 + 0.15e3 * t372 * t6734 * t2458 - 0.24e3 * t372 * t2587 * t2461 - 0.9e1 * t960 * t2533 * t961 + 0.18e2 * t955 * t968 * t2570 - 0.9e1 * t960 * t968 * t2581 + 0.3e2 * t372 * t6730 * t972 - 0.24e3 * t965 * t2564 + 0.18e2 * t3300 * t2571 - 0.18e2 * t2574 * t2578 - 0.9e1 * t2574 * t2582 + 0.15e3 * t965 * t2591 + 0.6e2 * t2602 * t973 - 0.18e2 * t6741 * t962 - 0.9e1 * t6746 * t962;
  t6810 = 0.3e2 * t2528 * t973 + 0.6e2 * t965 * t2588 - 0.48e2 * t955 * t291 * t286 * t774 + 0.18e2 * t6654 * t2557 + 0.48e2 * t2574 * t2561 + 0.18e2 * t2539 * t968 * t2556 + 0.48e2 * t960 * t968 * t2560 + 0.24e2 * t960 * t291 * t286 * t820 - 0.96e2 * t2594 * t2553 + 0.1e4 / 0.3e1 * t372 * t5488 * t6578 + 0.176e3 * t955 * t291 * t733 * t302 - 0.88e2 * t960 * t291 * t733 * t326 + 0.544e4 / 0.9e1 * t372 * t752 * t6564 + 0.6e1 * t955 * t291 * t107 * t2101 + t6508;
  t6852 = t151 * t296;
  t6853 = t742 * t6852;
  t6859 = -0.18e2 * t6698 * t291 * t107 * t1959 - 0.48e2 * t2539 * t291 * t286 * t781 - 0.18e2 * t1958 * t1005 * t781 - 0.18e2 * t2614 * t1320 * t5703 - 0.18e2 * t1940 * t2427 * t326 - 0.18e2 * t1958 * t985 * t781 - 0.8e3 * t372 * t2010 * t6561 - 0.9e1 * t742 * t2441 * t302 + 0.6e1 * t780 * t2441 * t326 - 0.18e2 * t742 * t2443 * t302 + 0.12e2 * t780 * t2443 * t326 - 0.9e1 * t742 * t2489 * t302 + 0.6e1 * t780 * t2489 * t326 - 0.96e2 * t955 * t968 * t2552 - 0.6e2 * t6853 * t2627;
  t6869 = t335 * t120;
  t6870 = t1940 * t6869;
  t6876 = t1940 * t6852;
  t6879 = t5716 * t2613;
  t6891 = t132 * t947;
  t6895 = t311 * t2006;
  t6918 = -0.18e2 * t2614 * t1320 * t774 * t326 + 0.36e2 * t6879 * t1320 * t302 * t781 + 0.18e2 * t3381 * t1320 * t820 * t326 + 0.6e2 * t2619 * t2620 * t774 * tau[1] + 0.3e3 * t2619 * t6895 * t765 * t302 - 0.3e2 * t2625 * t2620 * t820 * tau[1] + 0.6e2 * t3381 * t2620 * t781 * tau[1] - 0.15e3 * t2625 * t6895 * t765 * t326 + 0.96e2 * t2614 * t3713 * t2615 - 0.48e3 * t2619 * t6891 * t2621 + 0.12e3 * t737 * t6852 * t2622 + 0.12e3 * t737 * t6869 * t2622 + 0.24e3 * t2625 * t6891 * t2626 - 0.36e2 * t6870 * t2616 - 0.36e2 * t6876 * t2616;
  t6919 = t742 * t6869;
  t6967 = -0.18e2 * t1940 * t1005 * t738 - 0.9e1 * t742 * t1005 * t774 + 0.6e1 * t780 * t1005 * t820 + 0.18e2 * t1977 * t1007 * t781 - 0.18e2 * t1940 * t985 * t738 + 0.24e2 * t5678 * t382 * t1959 + 0.2e1 * t780 * t382 * t2066 - 0.3e1 * t742 * t382 * t2101 - 0.18e2 * t742 * t2430 * t326 + 0.18e2 * t737 * t2433 * t302 - 0.9e1 * t742 * t2433 * t326 - 0.9e1 * t742 * t2439 * t302 + 0.6e1 * t780 * t2439 * t326 - 0.9e1 * t742 * t985 * t774 + 0.6e1 * t780 * t985 * t820 - 0.6e2 * t6919 * t2627;
  t6975 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1925 * t388 - 0.3e1 / 0.8e1 * t6445 - 0.9e1 / 0.8e1 * t6 * t710 * t1018 + t6410 / 0.4e1 - 0.3e1 / 0.4e1 * t6452 - 0.9e1 / 0.8e1 * t6 * t275 * t2632 - t6371 + t6421 / 0.4e1 - 0.3e1 / 0.8e1 * t6460 - 0.3e1 / 0.8e1 * t6 * t102 * (t6635 + t6681 + t6721 + t6765 + t6810 + t6859 + t6918 + t6967));
  tv4rho3sigma11 = t7 * t6975 + 0.3e1 * t2637;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  tv4rho3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  tv4rho3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  tv4rho3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  tv4rho3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  tv4rho3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  tv4rho3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t6982 = t6 * t1474 * t412;
  t6988 = t6 * t1481 * t412;
  t6991 = t6 * t462 * t1096;
  t6998 = 0.5e1 / 0.36e2 * t6 * t1493 * t412;
  t7000 = t6 * t471 * t1096;
  t7003 = t6 * t172 * t2817;
  t7020 = t49 * t1576;
  t7024 = 0.1e1 / t37 / t3063;
  t7025 = t7024 * t1580;
  t7032 = t2310 * t2697;
  t7034 = t4908 * t1044;
  t7036 = t513 * t7020;
  t7038 = -0.24e3 * t2165 - 0.352e4 / 0.9e1 * t2183 - 0.96e3 * t525 * t2171 - 0.5248e5 / 0.9e1 * t557 * t2180 + 0.5632e5 / 0.9e1 * t72 * t219 * t494 + 0.72e3 * t1558 * t39 * t510 - 0.72e2 * t525 * t7020 - 0.4e5 / 0.3e1 * t4869 * t7025 + 0.36e3 * t525 * t2174 + 0.52e5 / 0.3e1 * t1648 * t2177 + 0.144e3 * t7032 + 0.72e3 * t7034 + 0.48e2 * t7036;
  t7039 = t4811 * t7025;
  t7042 = t1043 * t510 * tau[0];
  t7047 = t1043 * t522;
  t7048 = t7047 * tau[0];
  t7051 = t2684 * t194;
  t7052 = t7051 * t526;
  t7058 = t1604 * t7024;
  t7086 = 0.2e5 / 0.3e1 * t7039 - 0.288e4 * t4804 * t7042 + 0.864e4 * t1579 * t2168 - 0.144e4 * t1579 * t7048 - 0.12e5 * t4811 * t7052 + 0.192e4 * t562 * t403 * t1576 + 0.1792e7 / 0.3e1 * t214 * t7058 * t1580 - 0.2304e4 * t214 * t406 * t1576 - 0.896e6 * t72 * t4839 * t7024 * t1580 - 0.3072e5 * t214 * t2720 * t194 - 0.146944e7 / 0.9e1 * t72 * t573 * t849 * tau[0] + 0.1152e5 * t214 * t1090 * t522 + 0.23296e7 / 0.3e1 * t72 * t1604 * t1581 * t526 + 0.2304e5 * t4855 * t403 * t1622;
  t7094 = t1048 * t522;
  t7097 = t1558 * t7048;
  t7099 = t4804 * t7052;
  t7114 = -0.4608e5 * t1621 * t406 * t1622 + 0.576e5 * t562 * t1090 * t510 - 0.432e3 * t1558 * t7094 + 0.72e3 * t7097 + 0.48e4 * t7099 + 0.64e3 * t2172 - 0.24e3 * t2175 - 0.104e5 * t2178 + 0.1312e5 / 0.3e1 * t2181 - 0.5632e5 / 0.9e1 * t2205 - 0.4032e6 * t4796 * t7042 + 0.48384e6 * t1634 * t2168 + 0.2304e5 * t6184 * t7094 + 0.576e5 * t1629 * t7048;
  t7136 = 0.672e6 * t4796 * t7052 - 0.3456e5 * t1629 * t7094 - 0.8064e5 * t1634 * t7048 - 0.10752e7 * t4784 * t7052 + 0.2304e6 * t4791 * t7042 - 0.432e4 * t2169 - 0.384e5 * t2186 + 0.256e5 * t2191 - 0.96e4 * t2194 - 0.5824e6 * t2198 + 0.41984e6 / 0.3e1 * t2202 - 0.3456e6 * t2188 + 0.352e4 / 0.9e1 * t210 * t494 - 0.144e3 * t4847 * t49;
  t7156 = 0.48e3 * t2311 + 0.52e4 / 0.3e1 * t2314 - 0.2624e5 / 0.27e2 * t2307 + 0.24e3 * t7097 + 0.16e4 * t7099 - 0.8e1 * t5971 * t49 + 0.4e2 * t2277 - 0.8e2 * t6112 * t1044 - 0.4e3 * t6061 * t2685 - 0.32e3 / 0.3e1 * t2253 - 0.8e4 / 0.9e1 * t4804 * t7025;
  t7169 = 0.352e4 / 0.27e2 * t2256 + 0.48e2 * t7032 + 0.24e3 * t7034 + 0.16e2 * t7036 + 0.2e5 / 0.9e1 * t7039 - 0.8e2 * t2165 - 0.8e2 * t2175 - 0.104e5 / 0.3e1 * t2178 - 0.352e4 / 0.27e2 * t2183 + 0.64e3 / 0.3e1 * t2172 - 0.144e4 * t2169 + 0.1312e5 / 0.9e1 * t2181;
  t7203 = -0.3e1 * t206 * t233 * t2774 - t206 * t86 * (t7038 + t7086 + t7114 + t7136) + 0.3e1 * t188 * t86 * (t7156 + t7169) - t206 * t1687 * t409 - 0.3e1 * t206 * t592 * t1093 + 0.3e1 * t188 * t1687 * t396 + 0.9e1 * t188 * t592 * t1054 + 0.9e1 * t188 * t233 * t2704 + 0.18e2 * t2265 * t1037 + 0.18e2 * t2265 * t1055 - 0.6e1 * t4988 * t410 + 0.12e2 * t541 * t2710 * t224 - 0.9e1 * t503 * t1094 * t535 - 0.3e1 * t503 * t410 * t1590;
  t7246 = t409 * t581;
  t7250 = -0.9e1 * t503 * t1064 * t535 + 0.6e1 * t541 * t1094 * t581 + 0.2e1 * t541 * t410 * t1660 + 0.18e2 * t2280 * t7246 * t200 + 0.18e2 * t498 * t2673 * t200 + 0.36e2 * t498 * t2676 * t200 + 0.18e2 * t498 * t2705 * t200 - 0.9e1 * t503 * t2708 * t200 - 0.18e2 * t503 * t2710 * t200 - 0.9e1 * t503 * t2775 * t200 - 0.9e1 * t503 * t2673 * t224 - 0.18e2 * t503 * t2676 * t224 - 0.9e1 * t503 * t2705 * t224 + 0.6e1 * t541 * t2708 * t224 + 0.36e2 * t5975 * t2782 * t542;
  t7261 = t409 * t535;
  t7268 = t1526 * t233;
  t7282 = t396 * t224;
  t7303 = -0.36e2 * t2781 * t1054 * t200 * t224 + 0.36e2 * t2280 * t1093 * t200 * t224 - 0.54e2 * t6008 * t409 * t542 * t200 - 0.18e2 * t2781 * t396 * t535 * t224 + 0.36e2 * t5975 * t409 * t499 * t224 - 0.9e1 * t503 * t1055 * t581 + 0.6e1 * t541 * t1064 * t581 - 0.18e2 * t2781 * t7261 * t200 + 0.18e2 * t2280 * t7261 * t224 + 0.6e1 * t541 * t2775 * t224 - 0.18e2 * t3458 * t7246 * t224 + 0.18e2 * t2280 * t7282 * t581 - 0.18e2 * t2781 * t2782 * t581 - 0.36e2 * t7268 * t2783 + 0.36e2 * t5985 * t2793;
  t7347 = 0.18e2 * t1542 * t1037 * t542 + 0.18e2 * t498 * t1037 * t535 - 0.9e1 * t503 * t1037 * t581 + 0.18e2 * t1542 * t1055 * t542 + 0.18e2 * t498 * t1055 * t535 - 0.18e2 * t1505 * t1064 * t542 - 0.18e2 * t1526 * t1064 * t499 - 0.18e2 * t1505 * t1094 * t542 - 0.18e2 * t1526 * t1094 * t499 - 0.18e2 * t4957 * t397 * t1506 + 0.24e2 * t4993 * t410 * t1506 + 0.6e1 * t498 * t397 * t1590 - 0.3e1 * t503 * t397 * t1660 - 0.18e2 * t6089 * t1034 + 0.18e2 * t3103 * t2804;
  t7354 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1470 * t412 - 0.3e1 / 0.8e1 * t6982 - 0.9e1 / 0.8e1 * t6 * t458 * t1096 + t6988 / 0.4e1 - 0.3e1 / 0.4e1 * t6991 - 0.9e1 / 0.8e1 * t6 * t166 * t2817 - t6998 + t7000 / 0.4e1 - 0.3e1 / 0.8e1 * t7003 - 0.3e1 / 0.8e1 * t6 * t28 * (t7203 + t7250 + t7303 + t7347));
  tv4rho3tau0 = t7 * t7354 + 0.3e1 * t2822;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t7361 = t6 * t1716 * t436;
  t7364 = t6 * t1720 * t436;
  t7368 = 0.5e1 / 0.36e2 * t6 * t1724 * t436;
  t7370 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1712 * t436 - 0.3e1 / 0.8e1 * t7361 + t7364 / 0.4e1 - t7368);
  tv4rho3tau1 = t7 * t7370 + 0.3e1 * t2835;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t7372 = 0.2e1 * t2849;
  t7378 = t6 * t1754 * t412 / 0.4e1;
  t7383 = t6 * t1761 * t412;
  t7387 = t6 * t642 * t1096 / 0.4e1;
  t7396 = -0.3e1 / 0.8e1 * t6 * t1750 * t412 - t7378 - 0.3e1 / 0.4e1 * t6 * t638 * t1096 + t7383 / 0.12e2 - t7387 - 0.3e1 / 0.8e1 * t6 * t264 * t2817 - t6982 / 0.8e1 + t6988 / 0.6e1 - t6991 / 0.4e1 - t6998 + t7000 / 0.6e1 - t7003 / 0.8e1;
  t7397 = my_piecewise3(t2, 0, t7396);
  tv4rho3tau2 = t7 * t7397 + t2822 + t7372;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t7399 = 0.2e1 * t2865;
  t7405 = t6 * t1797 * t436 / 0.4e1;
  t7407 = t6 * t1801 * t436;
  t7416 = t6 * t617 * t1186 / 0.4e1;
  t7418 = t6 * t621 * t1186;
  t7421 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1793 * t436 - t7405 + t7407 / 0.12e2 - t7361 / 0.8e1 + t7364 / 0.6e1 - t7368 - 0.3e1 / 0.8e1 * t6 * t613 * t1186 - t7416 + t7418 / 0.12e2);
  tv4rho3tau3 = t7 * t7421 + t2835 + t7399;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t7427 = t6 * t1838 * t412;
  t7436 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1834 * t412 - t7427 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t693 * t1096 - t7378 + t7383 / 0.6e1 - t7387 + t6988 / 0.12e2 - t6998 + t7000 / 0.12e2);
  tv4rho3tau4 = t7 * t7436 + t2873 + t7372;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t7442 = t6 * t1868 * t436;
  t7449 = t6 * t666 * t1186;
  t7457 = t6 * t251 * t3046;
  t7459 = -0.3e1 / 0.8e1 * t6 * t1864 * t436 - t7442 / 0.8e1 - t7405 + t7407 / 0.6e1 - 0.3e1 / 0.4e1 * t6 * t662 * t1186 - t7449 / 0.4e1 + t7364 / 0.12e2 - t7368 - t7416 + t7418 / 0.6e1 - 0.3e1 / 0.8e1 * t6 * t247 * t3046 - t7457 / 0.8e1;
  t7460 = my_piecewise3(t93, 0, t7459);
  tv4rho3tau5 = t7 * t7460 + t3051 + t7399;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t7469 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t1905 * t412 - 0.3e1 / 0.8e1 * t7427 + t7383 / 0.4e1 - t6998);
  tv4rho3tau6 = t7 * t7469 + 0.3e1 * t2873;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t7510 = t117 * t2056;
  t7518 = 0.1e1 / t105 / t3257;
  t7519 = t7518 * t2004;
  t7528 = 0.352e4 / 0.9e1 * t312 * t733 - 0.144e3 * t5558 * t117 + 0.64e3 * t2453 - 0.24e3 * t2456 - 0.104e5 * t2459 + 0.1312e5 / 0.3e1 * t2462 - 0.5632e5 / 0.9e1 * t2486 - 0.72e2 * t764 * t7510 + 0.36e3 * t764 * t2455 + 0.52e5 / 0.3e1 * t2047 * t2458 - 0.4e5 / 0.3e1 * t5568 * t7519 + 0.5632e5 / 0.9e1 * t137 * t321 * t733 + 0.72e3 * t2010 * t107 * t749;
  t7533 = t2587 * t2947;
  t7535 = t5506 * t1134;
  t7537 = t752 * t7510;
  t7539 = t5509 * t7519;
  t7542 = t1133 * t749 * tau[1];
  t7549 = t2947 * t296;
  t7552 = t1133 * t761;
  t7553 = t7552 * tau[1];
  t7556 = t2935 * t296;
  t7563 = -0.96e3 * t764 * t2452 - 0.5248e5 / 0.9e1 * t796 * t2461 + 0.144e3 * t7533 + 0.72e3 * t7535 + 0.48e2 * t7537 + 0.2e5 / 0.3e1 * t7539 + 0.2304e6 * t5576 * t7542 - 0.4032e6 * t5587 * t7542 + 0.48384e6 * t2032 * t2449 + 0.2304e5 * t6535 * t7549 + 0.576e5 * t2027 * t7553 + 0.672e6 * t5587 * t7556 - 0.3456e5 * t2027 * t7549 - 0.8064e5 * t2032 * t7553;
  t7588 = -0.10752e7 * t5581 * t7556 - 0.432e4 * t2450 - 0.384e5 * t2467 + 0.256e5 * t2472 - 0.96e4 * t2475 - 0.5824e6 * t2479 + 0.41984e6 / 0.3e1 * t2483 - 0.3456e6 * t2469 - 0.288e4 * t5488 * t7542 + 0.864e4 * t2019 * t2449 - 0.144e4 * t2019 * t7553 - 0.12e5 * t5509 * t7556 + 0.192e4 * t801 * t427 * t2056 - 0.4608e5 * t1994 * t430 * t1995;
  t7602 = t2003 * t7518;
  t7622 = t2010 * t7553;
  t7624 = t5488 * t7556;
  t7628 = 0.576e5 * t801 * t1180 * t749 + 0.1152e5 * t316 * t1180 * t761 + 0.23296e7 / 0.3e1 * t137 * t2003 * t2006 * t765 + 0.2304e5 * t5550 * t427 * t1995 + 0.1792e7 / 0.3e1 * t316 * t7602 * t2004 - 0.2304e4 * t316 * t430 * t2056 - 0.896e6 * t137 * t5611 * t7518 * t2004 - 0.3072e5 * t316 * t3002 * t296 - 0.146944e7 / 0.9e1 * t137 * t812 * t947 * tau[1] - 0.432e3 * t2010 * t7549 + 0.72e3 * t7622 + 0.48e4 * t7624 - 0.352e4 / 0.9e1 * t2464 - 0.24e3 * t2446;
  t7647 = 0.4e2 * t2534 - 0.8e2 * t6730 * t1134 - 0.4e3 * t6734 * t2935 - 0.32e3 / 0.3e1 * t2546 - 0.8e4 / 0.9e1 * t5488 * t7519 + 0.352e4 / 0.27e2 * t2549 + 0.48e2 * t7533 + 0.24e3 * t7535 + 0.16e2 * t7537 + 0.2e5 / 0.9e1 * t7539 + 0.52e4 / 0.3e1 * t2591;
  t7661 = -0.2624e5 / 0.27e2 * t2564 + 0.24e3 * t7622 + 0.16e4 * t7624 + 0.48e3 * t2588 - 0.8e1 * t6687 * t117 - 0.8e2 * t2446 - 0.8e2 * t2456 - 0.104e5 / 0.3e1 * t2459 - 0.352e4 / 0.27e2 * t2464 + 0.64e3 / 0.3e1 * t2453 - 0.144e4 * t2450 + 0.1312e5 / 0.9e1 * t2462;
  t7683 = 0.18e2 * t2601 * t1127 + 0.18e2 * t2601 * t1145 + 0.3e1 * t290 * t2122 * t420 + 0.9e1 * t290 * t831 * t1144 - 0.6e1 * t5689 * t434 - 0.3e1 * t308 * t335 * t3024 - t308 * t151 * (t7528 + t7563 + t7588 + t7628) + 0.3e1 * t290 * t151 * (t7647 + t7661) - t308 * t2122 * t433 - 0.3e1 * t308 * t831 * t1183 + 0.9e1 * t290 * t335 * t2954 + 0.6e1 * t780 * t1154 * t820 + 0.6e1 * t780 * t2958 * t326 + 0.12e2 * t780 * t2960 * t326;
  t7729 = -0.9e1 * t742 * t1127 * t820 + 0.18e2 * t737 * t1145 * t774 - 0.9e1 * t742 * t1145 * t820 - 0.9e1 * t742 * t1154 * t774 - 0.9e1 * t742 * t1184 * t774 - 0.3e1 * t742 * t421 * t2066 + 0.6e1 * t737 * t421 * t2101 - 0.3e1 * t742 * t434 * t2101 - 0.9e1 * t742 * t2923 * t326 - 0.18e2 * t742 * t2926 * t326 + 0.18e2 * t737 * t2955 * t302 - 0.9e1 * t742 * t2955 * t326 - 0.9e1 * t742 * t2958 * t302 - 0.18e2 * t742 * t2960 * t302 - 0.9e1 * t742 * t3025 * t302;
  t7774 = 0.18e2 * t1977 * t1127 * t781 + 0.18e2 * t737 * t1127 * t774 + 0.18e2 * t1977 * t1145 * t781 - 0.18e2 * t1940 * t1154 * t738 - 0.18e2 * t1958 * t1154 * t781 - 0.18e2 * t1940 * t1184 * t738 - 0.18e2 * t1958 * t1184 * t781 + 0.6e1 * t780 * t1184 * t820 + 0.24e2 * t5678 * t434 * t1959 + 0.2e1 * t780 * t434 * t2066 + 0.18e2 * t737 * t2923 * t302 + 0.36e2 * t737 * t2926 * t302 + 0.6e1 * t780 * t3025 * t326 - 0.18e2 * t6740 * t1124 + 0.18e2 * t3299 * t2910;
  t7784 = t420 * t820;
  t7788 = t433 * t820;
  t7795 = t1940 * t335;
  t7813 = t433 * t774;
  t7826 = -0.36e2 * t3027 * t1144 * t302 * t326 + 0.36e2 * t2539 * t1183 * t302 * t326 - 0.18e2 * t3027 * t420 * t774 * t326 + 0.36e2 * t6646 * t433 * t738 * t326 - 0.18e2 * t5732 * t421 * t1959 + 0.18e2 * t2539 * t7788 * t302 + 0.18e2 * t2539 * t7784 * t326 + 0.18e2 * t2539 * t7813 * t326 - 0.18e2 * t3027 * t7784 * t302 - 0.18e2 * t3027 * t7813 * t302 + 0.36e2 * t6646 * t3028 * t781 - 0.54e2 * t6698 * t3038 * t781 - 0.18e2 * t3631 * t7788 * t326 - 0.36e2 * t7795 * t3029 + 0.36e2 * t6654 * t3039;
  t7833 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t1925 * t436 - 0.3e1 / 0.8e1 * t7442 - 0.9e1 / 0.8e1 * t6 * t710 * t1186 + t7407 / 0.4e1 - 0.3e1 / 0.4e1 * t7449 - 0.9e1 / 0.8e1 * t6 * t275 * t3046 - t7368 + t7418 / 0.4e1 - 0.3e1 / 0.8e1 * t7457 - 0.3e1 / 0.8e1 * t6 * t102 * (t7683 + t7729 + t7774 + t7826));
  tv4rho3tau7 = t7 * t7833 + 0.3e1 * t3051;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t7840 = t6 * t462 * t1230;
  t7847 = t6 * t471 * t1230 / 0.12e2;
  t7849 = t6 * t172 * t3213;
  t7874 = t200 * t205;
  t7875 = t7874 * t86;
  t7885 = t498 * t918;
  t7892 = t503 * t918;
  t7899 = 0.48e2 * t6293 * t1277 * t2282 - 0.8e2 * t2339 * t2345 * t2281 * tau[0] + 0.8e2 * t3202 * t2345 * t3203 * tau[0] - 0.12e2 * t7268 * t3157 - 0.6e1 * t2781 * t525 * t529 * t581 + 0.4e2 * t3109 * t875 + 0.4e2 * t1204 * t2311 + 0.1e3 * t1204 * t2314 - 0.12e2 * t7875 * t3157 - 0.12e2 * t862 * t870 * t3144 - 0.6e1 * t862 * t189 * t39 * t2207 + 0.24e2 * t7885 * t859 + 0.24e2 * t3148 * t2320 + 0.12e2 * t3148 * t2324 - 0.12e2 * t7892 * t864 - 0.12e2 * t3151 * t2285 - 0.6e1 * t3151 * t2289;
  t7905 = 0.1e1 / t37 / t4698 * t484 * t34;
  t7907 = 0.25e4 / 0.3486784401e10 * t4716 * t7905;
  t7929 = t1542 * t362;
  t7952 = -0.16e3 * t1204 * t2307 - t7907 - 0.176e3 / 0.3e1 * t862 * t189 * t494 * t357 + 0.12e2 * t5975 * t525 * t529 * t542 - 0.12e2 * t6090 * t1201 + 0.32e2 * t2327 * t3132 + 0.32e2 * t862 * t870 * t3131 + 0.32e2 * t862 * t189 * t184 * t906 - 0.64e2 * t3148 * t2295 + 0.12e2 * t7929 * t2299 + 0.32e2 * t3151 * t2304 - 0.12e2 * t2327 * t3141 - 0.12e2 * t2327 * t3145 - 0.6e1 * t862 * t2276 * t1200 + 0.24e2 * t2317 * t3161 + 0.12e2 * t857 * t1558 * t6193 + 0.3e1 / 0.2e1 * t2781 * t3114 * t2340 - 0.5e1 * t857 * t3121 * t2346;
  t8005 = 0.5e1 / 0.2e1 * t862 * t3121 * t2351 + 0.24e2 * t3104 * t3161 - 0.12e2 * t503 * t3175 * t200 - 0.6e1 * t503 * t1215 * t535 + 0.4e1 * t541 * t358 * t2207 - 0.12e2 * t503 * t3172 * t200 + 0.6e1 * t1542 * t1212 * t535 - 0.12e2 * t1505 * t3169 * t224 - 0.6e1 * t1505 * t1212 * t581 + 0.8e1 * t541 * t887 * t906 - 0.6e1 * t503 * t3164 * t224 - 0.3e1 / 0.8e1 * t188 * t592 * t529 * t59 + 0.12e2 * t1542 * t3169 * t200 - 0.6e1 * t503 * t3197 * t200 - 0.3e1 * t503 * t1224 * t535 + 0.4e1 * t541 * t3178 * t224 + 0.4e1 * t541 * t3197 * t224;
  t8031 = t1193 * t489;
  t8033 = 0.95e3 / 0.531441e6 * t480 * t8031;
  t8034 = t2225 * sigma[0];
  t8036 = 0.5375e4 / 0.28697814e8 * t1515 * t8034;
  t8060 = 0.2e1 * t541 * t1224 * t581 + 0.8e1 * t541 * t3175 * t224 + 0.4e1 * t541 * t1215 * t581 - 0.6e1 * t503 * t3178 * t200 + 0.4e1 * t188 * t233 * t849 * t59 + 0.12e2 * t4974 * t1212 * t499 + 0.8e1 * t541 * t3172 * t224 - 0.6e1 * t1505 * t1224 * t542 - t8033 + t8036 - 0.12e2 * t1526 * t1215 * t499 - 0.12e2 * t1505 * t1215 * t542 - 0.6e1 * t1526 * t1224 * t499 - 0.38e2 / 0.3e1 * t188 * t86 * t489 * t59 + 0.24e2 * t4993 * t1212 * t542 - 0.3e1 / 0.4e1 * t2265 * t1208 + 0.24e2 * t1542 * t6309 * t3204 - 0.4e2 * t6310 * t3208;
  t8081 = t362 * t52;
  t8082 = t1526 * t8081;
  t8088 = t503 * t8081;
  t8094 = t4957 * t2338;
  t8118 = t1211 * t200;
  t8122 = -0.24e2 * t6346 * t3199 + 0.24e2 * t1542 * t6324 * t3204 - 0.4e2 * t6328 * t3208 - 0.24e2 * t2339 * t1277 * t5988 + 0.24e2 * t3202 * t1277 * t906 * t224 - 0.4e2 * t2350 * t2345 * t906 * tau[0] - 0.24e2 * t8082 * t2341 + 0.8e2 * t498 * t8081 * t2347 - 0.4e2 * t8088 * t2352 + 0.64e2 * t2339 * t3485 * t2281 - 0.36e2 * t8094 * t1277 * t357 * t542 - 0.64e2 * t3202 * t3485 * t3203 + t80 * (-0.25e4 / 0.3486784401e10 * t4689 * t7905 + 0.5375e4 / 0.28697814e8 * t1680 * t8034 - 0.95e3 / 0.531441e6 * t586 * t8031 + t7907 - t8036 + t8033) + 0.608e3 / 0.3e1 * t857 * t525 * t489 + 0.176e3 / 0.3e1 * t1204 * t2256 + 0.12e2 * t2265 * t362 * t349 - 0.36e2 * t6008 * t8118 * t224;
  t8123 = t1223 * t200;
  t8144 = t3064 * t67;
  t8148 = t4843 * t209;
  t8160 = t535 * t79;
  t8161 = t8160 * t86;
  t8164 = t3103 * t233;
  t8172 = 0.12e2 * t2280 * t8123 * t224 - 0.64e2 * t3104 * t3125 - 0.64e2 * t2317 * t3125 - 0.32e2 * t3109 * t878 - 0.32e2 * t1204 * t2253 - 0.3e1 / 0.2e1 * t2317 * t3115 + 0.3e1 / 0.4e1 * t2327 * t3118 - 0.5e1 / 0.2e1 * t867 * t3122 + 0.3e1 / 0.8e1 * t862 * t3114 * t581 + 0.5e2 / 0.3e1 * t348 * t8144 * tau[0] - 0.25e2 / 0.4e1 * t348 * t8148 * t526 + 0.24e2 * t2280 * t2281 * t906 - 0.24e2 * t3458 * t3203 * t906 + 0.24e2 * t7929 * t2282 + 0.6e1 * t8161 * t1197 + 0.12e2 * t8164 * t1197 + 0.6e1 * t6086 * t1197 + 0.6e1 * t188 * t2336 * t349;
  t8181 = t849 * t59;
  t8194 = t906 * t906;
  t8219 = t86 * t53;
  t8220 = t1526 * t8219;
  t8221 = t556 * t1581;
  t8234 = 0.12e2 * t3109 * t871 + 0.6e1 * t1204 * t2277 - 0.3e1 / 0.4e1 * t857 * t3114 * t535 - 0.4e1 * t862 * t8181 * t224 + 0.12e2 * t857 * t4908 * t529 + 0.8e1 * t857 * t8181 * t200 - 0.3e1 / 0.4e1 * t2280 * t3114 * t542 + 0.4e1 * t541 * t86 * t8194 + 0.6e1 * t498 * t1228 * t499 + 0.12e2 * t3202 * t1277 * t357 * t581 + 0.16e3 * t2350 * t6281 * t3207 - 0.1e3 * t2350 * t6331 * t357 * t526 - 0.24e2 * t2339 * t4247 * t224 * t194 - 0.12e2 * t2339 * t1277 * t5957 - 0.8e2 * t8220 * t8221 * t2351 + 0.16e3 * t2344 * t8221 * t514 - 0.24e2 * t6340 * t3199 + 0.64e2 * t2781 * t525 * t849 * t224;
  t8238 = t3064 * tau[0];
  t8246 = t4843 * t526;
  t8318 = 0.3e1 / 0.4e1 * t6112 * t529 + 0.15e2 / 0.2e1 * t6061 * t3135 - 0.8e1 * t2310 * t849 + 0.25e2 * t4804 * t8246 - 0.5e2 * t1558 * t8238 + 0.76e2 / 0.3e1 * t513 * t489 + 0.36e3 * t4855 * t1220 * t510 + 0.24e4 * t4791 * t6197 * tau[0] - 0.128e4 * t1621 * t3193 * t194 + 0.12e3 * t1621 * t1220 * t522 + 0.35e4 * t562 * t573 * t4843 * t526 - 0.4e4 * t562 * t219 * t3064 * tau[0] + 0.304e4 / 0.3e1 * t562 * t75 * t489;
  t8321 = -0.128e3 * t857 * t1558 * t6180 - 0.16e4 / 0.3e1 * t857 * t1579 * t8238 + 0.8e2 * t3104 * t3136 + 0.8e2 * t2317 * t3136 + 0.1e4 / 0.3e1 * t857 * t4811 * t8246 - 0.6e1 * t6044 * t1201 + 0.2e1 * t541 * t1228 * t542 + 0.3e1 * t188 * t1228 * t535 - t206 * t1228 * t581 + 0.6e1 * t188 * t3076 * t200 - 0.2e1 * t206 * t3076 * t224 + 0.2e1 * t541 * t592 * t1211 - 0.2e1 * t206 * t2336 * t357 - 0.4e1 * t206 * t918 * t906 - 0.2e1 * t206 * t362 * t2207 - t206 * t592 * t1223 - 0.2e1 * t206 * t233 * t3196 - t206 * t86 * t8318;
  t8329 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t1230 - t7840 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t3213 + t7847 - t7849 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t7899 + t7952 + t8005 + t8060 + t8122 + t8172 + t8234 + t8321));
  tv4rho2sigma20 = t7 * t8329 + 0.2e1 * t3218;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t8336 = t6 * t617 * t1271;
  t8340 = t6 * t621 * t1271 / 0.12e2;
  t8342 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t1271 - t8336 / 0.4e1 + t8340);
  tv4rho2sigma25 = t7 * t8342 + 0.2e1 * t3227;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t8348 = t6 * t642 * t1230;
  t8356 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t1230 - t8348 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t3213 - t7840 / 0.8e1 + t7847 - t7849 / 0.8e1);
  tv4rho2sigma26 = t7 * t8356 + t3218 + t3233;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t8362 = t6 * t666 * t1271;
  t8369 = t6 * t251 * t3392;
  t8372 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t1271 - t8362 / 0.8e1 - t8336 / 0.8e1 + t8340 - 0.3e1 / 0.8e1 * t6 * t247 * t3392 - t8369 / 0.8e1);
  tv4rho2sigma211 = t7 * t8372 + t3227 + t3397;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t8380 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t1230 - t8348 / 0.4e1 + t7847);
  tv4rho2sigma212 = t7 * t8380 + 0.2e1 * t3233;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t8397 = t5512 * t765;
  t8400 = t3258 * tau[1];
  t8428 = 0.3e1 / 0.4e1 * t6730 * t768 + 0.15e2 / 0.2e1 * t6734 * t3310 - 0.8e1 * t2587 * t947 + 0.25e2 * t5488 * t8397 - 0.5e2 * t2010 * t8400 + 0.76e2 / 0.3e1 * t752 * t728 + 0.36e3 * t5550 * t1261 * t749 + 0.24e4 * t5576 * t6547 * tau[1] - 0.128e4 * t1994 * t3356 * t296 + 0.12e3 * t1994 * t1261 * t761 + 0.35e4 * t801 * t812 * t5512 * t765 - 0.4e4 * t801 * t321 * t3258 * tau[1] + 0.304e4 / 0.3e1 * t801 * t140 * t728;
  t8459 = t1004 * t1004;
  t8475 = -0.4e1 * t308 * t1016 * t1004 + 0.2e1 * t780 * t831 * t1252 - t308 * t831 * t1264 + 0.3e1 * t290 * t1269 * t774 - t308 * t1269 * t820 + 0.6e1 * t737 * t1269 * t738 + 0.2e1 * t780 * t1269 * t781 - t308 * t151 * t8428 + 0.4e1 * t780 * t151 * t8459 - 0.2e1 * t308 * t386 * t2488 - 0.2e1 * t308 * t2611 * t381 + 0.6e1 * t290 * t3308 * t302 - 0.2e1 * t308 * t3308 * t326 - 0.2e1 * t308 * t335 * t3359 - 0.64e2 * t2594 * t3278 - 0.64e2 * t3300 * t3278 - 0.32e2 * t3283 * t976;
  t8478 = t947 * t124;
  t8516 = t3258 * t132;
  t8522 = t5512 * t311;
  t8526 = -0.32e2 * t1245 * t2546 + 0.8e1 * t955 * t8478 * t302 - 0.3e1 / 0.4e1 * t2539 * t3288 * t781 - 0.4e1 * t960 * t8478 * t326 + 0.12e2 * t2601 * t386 * t373 + 0.176e3 / 0.3e1 * t1245 * t2549 + 0.12e2 * t955 * t5506 * t768 + 0.608e3 / 0.3e1 * t955 * t764 * t728 + 0.6e1 * t290 * t2611 * t373 + 0.12e2 * t3283 * t969 + 0.6e1 * t1245 * t2534 - 0.3e1 / 0.2e1 * t2594 * t3289 - 0.3e1 / 0.4e1 * t955 * t3288 * t774 + 0.3e1 / 0.4e1 * t2574 * t3292 + 0.3e1 / 0.8e1 * t960 * t3288 * t820 + 0.5e2 / 0.3e1 * t372 * t8516 * tau[1] - 0.5e1 / 0.2e1 * t965 * t3296 - 0.25e2 / 0.4e1 * t372 * t8522 * t765;
  t8528 = t1977 * t386;
  t8531 = t1264 * t302;
  t8535 = t774 * t144;
  t8536 = t8535 * t151;
  t8539 = t3299 * t335;
  t8544 = t1252 * t302;
  t8567 = t386 * t120;
  t8568 = t1940 * t8567;
  t8574 = t742 * t8567;
  t8580 = t5732 * t2613;
  t8585 = 0.24e2 * t8528 * t2541 + 0.12e2 * t2539 * t8531 * t326 + 0.6e1 * t8536 * t1238 + 0.12e2 * t8539 * t1238 + 0.6e1 * t6711 * t1238 - 0.36e2 * t6698 * t8544 * t326 + 0.24e2 * t2539 * t2540 * t1004 - 0.24e2 * t3631 * t3382 * t1004 - 0.4e2 * t6853 * t3387 - 0.24e2 * t2614 * t1320 * t6657 + 0.24e2 * t3381 * t1320 * t1004 * t326 - 0.4e2 * t2625 * t2620 * t1004 * tau[1] - 0.24e2 * t8568 * t2616 + 0.8e2 * t737 * t8567 * t2622 - 0.4e2 * t8574 * t2627 + 0.64e2 * t2614 * t3713 * t2540 - 0.36e2 * t8580 * t1320 * t381 * t781;
  t8607 = t151 * t121;
  t8608 = t1940 * t8607;
  t8609 = t795 * t2006;
  t8643 = -0.64e2 * t3381 * t3713 * t3382 + 0.16e3 * t2625 * t6891 * t3386 - 0.1e3 * t2625 * t6895 * t381 * t765 - 0.24e2 * t2614 * t4337 * t326 * t296 - 0.12e2 * t2614 * t1320 * t6661 + 0.12e2 * t3381 * t1320 * t381 * t820 - 0.8e2 * t8608 * t8609 * t2626 + 0.16e3 * t2619 * t8609 * t753 - 0.24e2 * t6870 * t3378 + 0.24e2 * t1977 * t6869 * t3383 - 0.4e2 * t6919 * t3387 - 0.24e2 * t6876 * t3378 + 0.24e2 * t1977 * t6852 * t3383 + 0.2e1 * t780 * t1265 * t820 - 0.6e1 * t742 * t3376 * t302 - 0.6e1 * t742 * t3360 * t302 - 0.3e1 * t742 * t1265 * t774 + 0.4e1 * t780 * t3376 * t326;
  t8699 = 0.4e1 * t780 * t3360 * t326 + 0.8e1 * t780 * t3373 * t326 + 0.4e1 * t780 * t1256 * t820 - 0.12e2 * t742 * t3370 * t302 - 0.12e2 * t742 * t3373 * t302 - 0.6e1 * t742 * t1256 * t774 + 0.8e1 * t780 * t3370 * t326 + 0.4e1 * t780 * t382 * t2488 - 0.6e1 * t1958 * t1253 * t820 + 0.8e1 * t780 * t985 * t1004 - 0.3e1 / 0.8e1 * t290 * t831 * t768 * t124 + 0.12e2 * t1977 * t3367 * t302 + 0.6e1 * t1977 * t1253 * t774 - 0.12e2 * t1958 * t3367 * t326 + 0.12e2 * t5716 * t1253 * t738 - 0.6e1 * t742 * t3362 * t326 + 0.4e1 * t290 * t335 * t947 * t124;
  t8747 = t302 * t307;
  t8748 = t8747 * t151;
  t8753 = -0.3e1 / 0.4e1 * t2601 * t1249 - 0.38e2 / 0.3e1 * t290 * t151 * t728 * t124 + 0.32e2 * t960 * t968 * t3339 + 0.32e2 * t960 * t291 * t286 * t1004 - 0.64e2 * t3323 * t2553 + 0.12e2 * t8528 * t2557 + 0.32e2 * t3326 * t2561 - 0.16e4 / 0.3e1 * t955 * t2019 * t8400 + 0.32e2 * t2574 * t3340 - 0.176e3 / 0.3e1 * t960 * t291 * t733 * t381 + 0.12e2 * t6646 * t764 * t768 * t781 + 0.64e2 * t3027 * t764 * t947 * t326 - 0.128e3 * t955 * t2010 * t6551 - 0.12e2 * t6741 * t1242 - 0.5e1 * t955 * t3295 * t2621 + 0.5e1 / 0.2e1 * t960 * t3295 * t2626 - 0.12e2 * t8748 * t3332 + 0.24e2 * t3300 * t3335;
  t8763 = t742 * t1016;
  t8792 = t2521 * sigma[2];
  t8794 = 0.5375e4 / 0.28697814e8 * t1968 * t8792;
  t8795 = t1193 * t728;
  t8797 = 0.95e3 / 0.531441e6 * t721 * t8795;
  t8801 = 0.1e1 / t105 / t5711 * t723 * t34;
  t8809 = 0.25e4 / 0.3486784401e10 * t5770 * t8801;
  t8812 = 0.8e2 * t3300 * t3311 - 0.12e2 * t7795 * t3332 + 0.24e2 * t2594 * t3335 + 0.8e2 * t2594 * t3311 - 0.12e2 * t8763 * t962 + 0.4e2 * t3283 * t973 + 0.24e2 * t3323 * t2567 - 0.12e2 * t3326 * t2578 + 0.4e2 * t1245 * t2588 + 0.3e1 / 0.2e1 * t3027 * t3288 * t2615 - 0.12e2 * t1958 * t1256 * t781 - 0.6e1 * t1940 * t1265 * t738 - 0.6e1 * t1958 * t1265 * t781 + 0.24e2 * t5678 * t1253 * t781 - 0.12e2 * t1940 * t1256 * t738 + t8794 - t8797 + t145 * (-0.25e4 / 0.3486784401e10 * t5784 * t8801 + 0.5375e4 / 0.28697814e8 * t2115 * t8792 - 0.95e3 / 0.531441e6 * t825 * t8795 + t8809 - t8794 + t8797);
  t8837 = t737 * t1016;
  t8861 = -0.6e1 * t6746 * t1242 - 0.12e2 * t2574 * t3316 - 0.12e2 * t2574 * t3320 - 0.6e1 * t960 * t2533 * t1241 - 0.12e2 * t960 * t968 * t3319 - 0.6e1 * t960 * t291 * t107 * t2488 + 0.12e2 * t3323 * t2571 - 0.6e1 * t3326 * t2582 - 0.16e3 * t1245 * t2564 + 0.1e3 * t1245 * t2591 + 0.24e2 * t8837 * t957 - 0.6e1 * t3027 * t764 * t768 * t820 + 0.12e2 * t955 * t2010 * t6543 + 0.1e4 / 0.3e1 * t955 * t5509 * t8397 - t8809 + 0.48e2 * t6879 * t1320 * t2541 - 0.8e2 * t2614 * t2620 * t2540 * tau[1] + 0.8e2 * t3381 * t2620 * t3382 * tau[1];
  t8869 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t1271 - t8362 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t3392 + t8340 - t8369 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * (t8475 + t8526 + t8585 + t8643 + t8699 + t8753 + t8812 + t8861));
  tv4rho2sigma217 = t7 * t8869 + 0.2e1 * t3397;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t8876 = t6 * t462 * t1314;
  t8883 = t6 * t471 * t1314 / 0.12e2;
  t8885 = t6 * t172 * t3564;
  t8937 = -0.6e1 * t503 * t1037 * t906 - 0.6e1 * t503 * t1055 * t906 + 0.6e1 * t1542 * t1284 * t542 + 0.6e1 * t1542 * t1291 * t542 - 0.6e1 * t1505 * t1301 * t542 - 0.6e1 * t1526 * t1301 * t499 - 0.6e1 * t1505 * t1312 * t542 - 0.6e1 * t1526 * t1312 * t499 + 0.2e1 * t541 * t1312 * t581 + 0.12e2 * t498 * t3524 * t200 + 0.12e2 * t498 * t3545 * t200 - 0.3e1 * t503 * t397 * t2207 + 0.4e1 * t541 * t3492 * t224 + 0.4e1 * t541 * t3522 * t224 - 0.6e1 * t503 * t2676 * t357 - 0.3e1 * t503 * t2705 * t357 - 0.6e1 * t6089 * t1281;
  t8992 = 0.4e1 * t541 * t1064 * t906 + 0.4e1 * t541 * t1094 * t906 - 0.3e1 * t503 * t1291 * t581 - 0.3e1 * t503 * t1301 * t535 + 0.2e1 * t541 * t1301 * t581 - 0.3e1 * t503 * t1312 * t535 - 0.6e1 * t503 * t3492 * t200 - 0.6e1 * t503 * t3522 * t200 - 0.6e1 * t503 * t3541 * t200 - 0.6e1 * t503 * t3543 * t200 + 0.2e1 * t541 * t410 * t2207 - 0.6e1 * t503 * t3527 * t224 + 0.4e1 * t541 * t3541 * t224 + 0.4e1 * t541 * t3543 * t224 - 0.3e1 * t503 * t2673 * t357 + 0.2e1 * t541 * t2708 * t357 + 0.4e1 * t541 * t2710 * t357 + 0.2e1 * t541 * t2775 * t357;
  t9024 = t4993 * t86;
  t9032 = t1093 * t357;
  t9036 = t409 * t906;
  t9045 = t396 * t906;
  t9049 = 0.12e2 * t2280 * t1311 * t200 * t224 + 0.6e1 * t498 * t1284 * t535 - 0.3e1 * t503 * t1284 * t581 + 0.6e1 * t498 * t1291 * t535 + 0.12e2 * t2280 * t9036 * t200 - 0.12e2 * t2781 * t9045 * t200 + 0.12e2 * t498 * t3527 * t200 + 0.12e2 * t498 * t3538 * t200 - 0.12e2 * t3458 * t9032 * t224 - 0.12e2 * t3458 * t9036 * t224 - 0.6e1 * t503 * t3524 * t224 - 0.6e1 * t503 * t3538 * t224 - 0.6e1 * t503 * t3545 * t224 - 0.18e2 * t6008 * t3447 * t542 + 0.12e2 * t5975 * t3454 * t499 + 0.24e2 * t9024 * t3454 * t542 + 0.12e2 * t7929 * t2793;
  t9053 = t1526 * t362;
  t9078 = t1054 * t357;
  t9093 = t4957 * t410;
  t9101 = 0.12e2 * t2280 * t9045 * t224 - 0.12e2 * t9053 * t2783 - 0.12e2 * t2781 * t1290 * t200 * t224 + 0.12e2 * t5985 * t3455 - 0.12e2 * t1505 * t233 * t3459 + 0.12e2 * t2280 * t9032 * t200 + 0.6e1 * t2280 * t3454 * t535 - 0.6e1 * t3458 * t3454 * t581 - 0.12e2 * t7268 * t3448 + 0.12e2 * t5985 * t3451 - 0.12e2 * t2781 * t9078 * t200 + 0.12e2 * t2280 * t9078 * t224 + 0.6e1 * t2280 * t3447 * t581 - 0.6e1 * t2781 * t3447 * t535 + 0.32e2 * t3554 * t2295 - 0.18e2 * t9093 * t2299 - 0.32e2 * t3557 * t2304 - 0.2e2 * t503 * t1094 * t875;
  t9110 = t7874 * t397;
  t9113 = t4974 * t397;
  t9131 = t1526 * t1037;
  t9137 = t1526 * t1055;
  t9145 = 0.4e2 * t498 * t1037 * t875 + 0.4e2 * t498 * t1055 * t875 + 0.4e2 * t3103 * t397 * t875 - 0.12e2 * t3548 * t2285 + 0.12e2 * t3557 * t2285 - 0.6e1 * t3548 * t2289 + 0.6e1 * t3557 * t2289 + 0.12e2 * t9113 * t2299 + 0.32e2 * t3548 * t2304 - 0.16e3 * t3551 * t2307 - 0.2e2 * t3560 * t2311 + 0.1e3 * t3551 * t2314 - 0.12e2 * t3554 * t2320 - 0.6e1 * t3554 * t2324 - 0.12e2 * t9110 * t864 - 0.12e2 * t9131 * t864 - 0.12e2 * t9137 * t864;
  t9151 = t1542 * t1064;
  t9160 = t1542 * t1094;
  t9168 = t7051 * tau[0];
  t9174 = t573 * t7024;
  t9199 = t6112 * t1043;
  t9203 = 0.576e4 * t1621 * t1078 * t510 + 0.144e4 * t562 * t1078 * t522 - 0.96e3 * t1621 * t1306 * t522 - 0.288e4 * t4855 * t1306 * t510 - 0.1248e5 * t562 * t899 * t194 - 0.3808e5 * t214 * t2196 * tau[0] + 0.448e5 * t214 * t7058 * t526 - 0.28e5 * t562 * t9174 * t526 + 0.18e2 * t4908 * t1043 - 0.192e5 * t4791 * t9168 + 0.24e3 * t4804 * t9168 + 0.208e3 * t3125 - 0.6e1 * t9199;
  t9214 = t7024 * t526;
  t9217 = t6061 * t3496;
  t9219 = t4804 * t9214;
  t9225 = 0.336e5 * t4796 * t9168 + 0.832e4 * t3187 + 0.272e5 * t3191 - 0.156e3 * t3161 - 0.68e3 * t3136 + 0.6656e4 * t214 * t2200 + 0.18e2 * t1558 * t7047 + 0.5e3 * t4811 * t9214 - 0.6e2 * t9217 - 0.2e3 * t9219 + 0.34e3 * t3182 - 0.1664e5 / 0.3e1 * t3194 + 0.52e2 * t3180 - 0.416e3 / 0.3e1 * t3184;
  t9256 = 0.4e2 * t3551 * t2311 - 0.12e2 * t1526 * t1064 * t859 + 0.12e2 * t9151 * t864 - 0.2e2 * t503 * t1064 * t875 - 0.12e2 * t1526 * t1094 * t859 + 0.12e2 * t9160 * t864 - t206 * t592 * t1311 - 0.2e1 * t206 * t233 * t3521 - t206 * t86 * (t9203 + t9225) - t206 * t2336 * t409 - 0.2e1 * t206 * t918 * t1093 - t206 * t362 * t2774 + 0.12e2 * t2317 * t3468 + 0.12e2 * t2317 * t3472 + 0.6e1 * t857 * t2704 * t52 * t1277 + 0.12e2 * t857 * t1054 * t194 * t1277 + 0.6e1 * t857 * t396 * t522 * t1277 - 0.3e1 * t862 * t2774 * t52 * t1277;
  t9293 = t7024 * t209;
  t9318 = -0.6e1 * t862 * t1093 * t194 * t1277 - 0.3e1 * t862 * t409 * t522 * t1277 + 0.24e2 * t5975 * t3447 * t2340 - 0.36e2 * t6008 * t3454 * t2340 + 0.6e1 * t8161 * t1278 + 0.12e2 * t8164 * t1278 + 0.12e2 * t3104 * t3468 + 0.12e2 * t3104 * t3472 + 0.6e1 * t6086 * t1278 + 0.3e1 * t188 * t362 * t2704 + 0.3e1 * t188 * t592 * t1290 + 0.6e1 * t188 * t233 * t3537 + 0.3e1 * t188 * t86 * (0.208e3 / 0.9e1 * t8181 - 0.34e3 / 0.9e1 * t3122 + 0.5e2 / 0.3e1 * t9293 * t526 - 0.2e1 * t9199 - 0.2e2 * t9217 + 0.52e2 / 0.3e1 * t3180 - 0.2e3 / 0.3e1 * t9219 + 0.34e3 / 0.3e1 * t3182 - 0.416e3 / 0.9e1 * t3184) + 0.3e1 * t188 * t2336 * t396 + 0.6e1 * t188 * t918 * t1054 + 0.8e2 * t3560 * t2307 - 0.5e2 * t3560 * t2314 - 0.3e1 * t6044 * t1295;
  t9331 = t59 * t494;
  t9353 = t513 * t3156 * tau[0];
  t9356 = t4974 * t410;
  t9370 = -0.6e1 * t2327 * t3478 - 0.6e1 * t2327 * t3482 + 0.16e2 * t2327 * t3489 + 0.16e2 * t862 * t3477 * t3485 + 0.16e2 * t862 * t3481 * t3485 - 0.88e2 / 0.3e1 * t862 * t1294 * t9331 + 0.176e3 / 0.3e1 * t857 * t1276 * t9331 - 0.6e1 * t6090 * t1295 - 0.32e2 * t3104 * t3486 - 0.32e2 * t2317 * t3486 - 0.32e2 * t857 * t3467 * t3485 - 0.32e2 * t857 * t3471 * t3485 + 0.6e1 * t2265 * t1284 - 0.4e2 * t3548 * t9353 + 0.24e2 * t9356 * t189 * t858 * t224 - 0.4e2 * t3554 * t513 * t529 * t200 * tau[0] + 0.4e2 * t3557 * t9353 + 0.6e1 * t2265 * t1291;
  t9378 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t1314 - t8876 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t3564 + t8883 - t8885 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t8937 + t8992 + t9049 + t9101 + t9145 + t9256 + t9318 + t9370));
  tv4rho2sigmatau0 = t7 * t9378 + 0.2e1 * t3569;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t9385 = t6 * t617 * t1357;
  t9389 = t6 * t621 * t1357 / 0.12e2;
  t9391 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t1357 - t9385 / 0.4e1 + t9389);
  tv4rho2sigmatau5 = t7 * t9391 + 0.2e1 * t3578;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t9397 = t6 * t642 * t1314;
  t9405 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t1314 - t9397 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t3564 - t8876 / 0.8e1 + t8883 - t8885 / 0.8e1);
  tv4rho2sigmatau6 = t7 * t9405 + t3569 + t3584;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t9411 = t6 * t666 * t1357;
  t9418 = t6 * t251 * t3748;
  t9421 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t1357 - t9411 / 0.8e1 - t9385 / 0.8e1 + t9389 - 0.3e1 / 0.8e1 * t6 * t247 * t3748 - t9418 / 0.8e1);
  tv4rho2sigmatau11 = t7 * t9421 + t3578 + t3753;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t9429 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t1314 - t9397 / 0.4e1 + t8883);
  tv4rho2sigmatau12 = t7 * t9429 + 0.2e1 * t3584;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t9491 = -0.6e1 * t742 * t1145 * t1004 + 0.4e1 * t780 * t1184 * t1004 - 0.3e1 * t742 * t1344 * t774 + 0.2e1 * t780 * t1344 * t820 - 0.3e1 * t742 * t1355 * t774 + 0.2e1 * t780 * t434 * t2488 + 0.6e1 * t2539 * t3632 * t774 - 0.6e1 * t742 * t2926 * t381 - 0.3e1 * t742 * t2955 * t381 - 0.6e1 * t742 * t3671 * t302 - 0.6e1 * t742 * t3673 * t302 - 0.6e1 * t742 * t3675 * t302 - 0.6e1 * t742 * t3698 * t302 - 0.6e1 * t3027 * t3636 * t774 + 0.4e1 * t780 * t3673 * t326 + 0.4e1 * t780 * t3698 * t326 - 0.6e1 * t3631 * t3632 * t820;
  t9534 = t5716 * t421;
  t9544 = 0.4e1 * t780 * t1154 * t1004 - 0.12e2 * t1940 * t1154 * t957 + 0.6e1 * t737 * t1327 * t774 - 0.3e1 * t742 * t1327 * t820 + 0.6e1 * t737 * t1334 * t774 - 0.3e1 * t742 * t1334 * t820 + 0.2e1 * t780 * t2958 * t381 + 0.4e1 * t780 * t2960 * t381 + 0.12e2 * t737 * t3684 * t302 + 0.12e2 * t737 * t3695 * t302 + 0.2e1 * t780 * t3025 * t381 - 0.6e1 * t742 * t3678 * t326 - 0.6e1 * t742 * t3681 * t326 - 0.6e1 * t742 * t3684 * t326 - 0.6e1 * t742 * t3695 * t326 + 0.12e2 * t9534 * t2557 + 0.32e2 * t3732 * t2561 + 0.4e2 * t3735 * t2588;
  t9546 = t1977 * t1154;
  t9555 = t1977 * t1184;
  t9569 = t8747 * t421;
  t9575 = t1940 * t1127;
  t9581 = t1940 * t1145;
  t9590 = 0.4e2 * t737 * t1127 * t973 - 0.2e2 * t742 * t1154 * t973 - 0.12e2 * t1940 * t1184 * t957 - 0.2e2 * t742 * t1184 * t973 + 0.4e2 * t3299 * t421 * t973 + 0.8e2 * t3744 * t2564 - 0.12e2 * t3738 * t2567 - 0.6e1 * t3738 * t2571 + 0.12e2 * t3741 * t2578 - 0.6e1 * t3732 * t2582 + 0.6e1 * t3741 * t2582 - 0.2e2 * t3744 * t2588 + 0.12e2 * t9546 * t962 + 0.12e2 * t9555 * t962 - 0.12e2 * t9569 * t962 - 0.12e2 * t9575 * t962 - 0.12e2 * t9581 * t962;
  t9598 = t5732 * t434;
  t9639 = 0.4e2 * t737 * t1145 * t973 - 0.12e2 * t3732 * t2578 + 0.32e2 * t3738 * t2553 - 0.18e2 * t9598 * t2557 - 0.32e2 * t3741 * t2561 - 0.5e2 * t3744 * t2591 - 0.16e3 * t3735 * t2564 + 0.1e3 * t3735 * t2591 + 0.6e1 * t6711 * t1321 + 0.12e2 * t2594 * t3725 + 0.12e2 * t2594 * t3729 + 0.6e1 * t955 * t2954 * t120 * t1320 + 0.12e2 * t955 * t1144 * t296 * t1320 + 0.6e1 * t955 * t420 * t761 * t1320 - 0.3e1 * t6746 * t1338 - 0.6e1 * t2574 * t3710 - 0.3e1 * t960 * t3024 * t120 * t1320 - 0.6e1 * t960 * t1183 * t296 * t1320;
  t9660 = t124 * t733;
  t9687 = -0.3e1 * t960 * t433 * t761 * t1320 - 0.36e2 * t6698 * t3632 * t2615 + 0.24e2 * t6646 * t3636 * t2615 + 0.6e1 * t8536 * t1321 + 0.12e2 * t8539 * t1321 + 0.12e2 * t3300 * t3725 + 0.12e2 * t3300 * t3729 + 0.176e3 / 0.3e1 * t955 * t1319 * t9660 - 0.6e1 * t6741 * t1338 - 0.88e2 / 0.3e1 * t960 * t1337 * t9660 - 0.32e2 * t955 * t3724 * t3713 - 0.32e2 * t955 * t3728 * t3713 + 0.16e2 * t2574 * t3717 + 0.16e2 * t960 * t3705 * t3713 + 0.16e2 * t960 * t3709 * t3713 - 0.32e2 * t3300 * t3714 - 0.32e2 * t2594 * t3714;
  t9737 = t5678 * t151;
  t9741 = -0.6e1 * t2574 * t3706 - 0.3e1 * t742 * t421 * t2488 + 0.12e2 * t737 * t3678 * t302 + 0.12e2 * t737 * t3681 * t302 - 0.3e1 * t742 * t2923 * t381 - 0.6e1 * t742 * t1127 * t1004 + 0.4e1 * t780 * t3675 * t326 + 0.4e1 * t780 * t3671 * t326 + 0.2e1 * t780 * t1355 * t820 - 0.6e1 * t1958 * t1344 * t781 - 0.6e1 * t1940 * t1355 * t738 - 0.6e1 * t1958 * t1355 * t781 - 0.6e1 * t1940 * t1344 * t738 + 0.6e1 * t1977 * t1327 * t781 + 0.6e1 * t1977 * t1334 * t781 - 0.6e1 * t6740 * t1324 + 0.12e2 * t6646 * t3632 * t738 + 0.24e2 * t9737 * t3632 * t781;
  t9754 = t1144 * t381;
  t9761 = t420 * t1004;
  t9768 = t1183 * t381;
  t9772 = t433 * t1004;
  t9797 = -0.12e2 * t3027 * t1333 * t302 * t326 + 0.12e2 * t2539 * t1354 * t302 * t326 - 0.12e2 * t1958 * t335 * t3633 + 0.12e2 * t2539 * t9768 * t302 + 0.12e2 * t2539 * t9772 * t302 + 0.12e2 * t2539 * t9754 * t326 + 0.12e2 * t2539 * t9761 * t326 - 0.12e2 * t3027 * t9754 * t302 - 0.12e2 * t3027 * t9761 * t302 - 0.12e2 * t3631 * t9768 * t326 - 0.12e2 * t3631 * t9772 * t326 - 0.18e2 * t6698 * t3636 * t781 + 0.6e1 * t2601 * t1327 + 0.6e1 * t2601 * t1334 + 0.12e2 * t8528 * t3039 - 0.12e2 * t7795 * t3637 + 0.12e2 * t6654 * t3640 + 0.12e2 * t6654 * t3700;
  t9799 = t752 * t3331 * tau[1];
  t9802 = t5716 * t434;
  t9817 = t1940 * t386;
  t9850 = t2934 * t296 * tau[1];
  t9856 = t812 * t7518;
  t9866 = 0.576e4 * t1994 * t1168 * t749 + 0.144e4 * t801 * t1168 * t761 - 0.96e3 * t1994 * t1349 * t761 - 0.288e4 * t5550 * t1349 * t749 - 0.3808e5 * t316 * t2477 * tau[1] - 0.1248e5 * t801 * t997 * t296 + 0.448e5 * t316 * t7602 * t765 - 0.28e5 * t801 * t9856 * t765 + 0.18e2 * t5506 * t1133 + 0.24e3 * t5488 * t9850 + 0.208e3 * t3278 + 0.832e4 * t3350 + 0.272e5 * t3354;
  t9867 = t6730 * t1133;
  t9877 = t7518 * t765;
  t9878 = t5488 * t9877;
  t9884 = t6734 * t3645;
  t9890 = -0.6e1 * t9867 + 0.52e2 * t3343 - 0.416e3 / 0.3e1 * t3347 - 0.1664e5 / 0.3e1 * t3357 + 0.34e3 * t3345 - 0.192e5 * t5576 * t9850 + 0.336e5 * t5587 * t9850 - 0.2e3 * t9878 + 0.18e2 * t2010 * t7552 + 0.5e3 * t5509 * t9877 - 0.6e2 * t9884 + 0.6656e4 * t316 * t2481 - 0.156e3 * t3335 - 0.68e3 * t3311;
  t9911 = t7518 * t311;
  t9924 = -0.4e2 * t3732 * t9799 + 0.24e2 * t9802 * t291 * t956 * t326 - 0.4e2 * t3738 * t752 * t768 * t302 * tau[1] + 0.4e2 * t3741 * t9799 + 0.6e1 * t2539 * t3636 * t820 - 0.12e2 * t9817 * t3029 - t308 * t2611 * t433 - 0.2e1 * t308 * t1016 * t1183 - t308 * t386 * t3024 - t308 * t831 * t1354 - 0.2e1 * t308 * t335 * t3670 - t308 * t151 * (t9866 + t9890) + 0.3e1 * t290 * t2611 * t420 + 0.6e1 * t290 * t1016 * t1144 + 0.3e1 * t290 * t386 * t2954 + 0.3e1 * t290 * t831 * t1333 + 0.6e1 * t290 * t335 * t3694 + 0.3e1 * t290 * t151 * (0.208e3 / 0.9e1 * t8478 - 0.34e3 / 0.9e1 * t3296 + 0.5e2 / 0.3e1 * t9911 * t765 - 0.2e1 * t9867 - 0.2e2 * t9884 + 0.52e2 / 0.3e1 * t3343 - 0.2e3 / 0.3e1 * t9878 + 0.34e3 / 0.3e1 * t3345 - 0.416e3 / 0.9e1 * t3347);
  t9932 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t1357 - t9411 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t3748 + t9389 - t9418 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * (t9491 + t9544 + t9590 + t9639 + t9687 + t9741 + t9797 + t9924));
  tv4rho2sigmatau17 = t7 * t9932 + 0.2e1 * t3753;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  tv4rho2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  tv4rho2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  tv4rho2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  tv4rho2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  tv4rho2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t9939 = t6 * t462 * t1401;
  t9946 = t6 * t471 * t1401 / 0.12e2;
  t9948 = t6 * t172 * t3880;
  t9950 = t6112 * t1370;
  t9952 = t4908 * t1370;
  t9964 = t1370 * t522;
  t9968 = 0.1e1 / t37 / t1520;
  t9969 = t9968 * t526;
  t9972 = t1558 * t9964;
  t9974 = t4811 * t9969;
  t9983 = t6061 * t3805;
  t9985 = t4804 * t9969;
  t9988 = 0.48e2 * t9950 - 0.288e3 * t9952 + 0.416e4 / 0.3e1 * t557 * t529 - 0.208e4 * t1197 - 0.32e3 * t3494 - 0.512e5 * t3506 - 0.1792e6 * t3510 + 0.1536e6 * t3514 + 0.50176e6 * t3517 + 0.11648e6 / 0.3e1 * t72 * t2755 + 0.288e3 * t1579 * t9964 + 0.8e4 * t4869 * t9969 - 0.288e3 * t9972 - 0.8e4 * t9974 + 0.576e3 * t4804 * t1370 * t510 - 0.192e4 * t1579 * t2692 - 0.224e5 / 0.3e1 * t1648 * t3496 + 0.48e3 * t9983 + 0.16e4 * t9985 + 0.192e4 * t3500;
  t9993 = t3799 * t194;
  t9994 = t9993 * tau[0];
  t10022 = t573 * t9968;
  t10029 = t1604 * t9968;
  t10040 = t4804 * t9994;
  t10043 = -0.100352e7 / 0.3e1 * t72 * t2741 * tau[0] + 0.2304e5 * t4855 * t1389 * t510 + 0.48e4 * t4811 * t9994 + 0.768e4 * t1621 * t1389 * t522 + 0.224e6 * t562 * t10022 * t526 - 0.2304e5 * t562 * t1392 * t522 - 0.7168e6 * t214 * t10029 * t526 + 0.16128e5 * t214 * t1395 * t522 + 0.5376e6 * t72 * t4839 * t9968 * t526 - 0.384e4 * t10040 + 0.832e5 / 0.3e1 * t1221;
  t10050 = t9968 * t209;
  t10066 = -0.104e4 / 0.9e1 * t3114 + 0.224e4 / 0.9e1 * t3532 - 0.4e3 / 0.3e1 * t10050 * t526 + 0.32e2 * t9950 + 0.32e3 * t9983 - 0.64e3 / 0.3e1 * t3494 + 0.32e4 / 0.3e1 * t9985 - 0.448e4 / 0.3e1 * t3497 + 0.416e4 / 0.9e1 * t1218 - 0.48e2 * t9952 - 0.64e3 * t10040 + 0.32e3 * t3500 - 0.48e2 * t9972 - 0.4e4 / 0.3e1 * t9974 + 0.448e4 / 0.3e1 * t3502 - 0.104e4 / 0.3e1 * t1197;
  t10091 = t1054 * t1054;
  t10095 = t1093 * t1093;
  t10104 = t1054 * t409;
  t10108 = t396 * t1093;
  t10112 = -t206 * t86 * (t9988 + 0.896e4 * t3502 - 0.6656e5 * t3519 - 0.224e4 * t3497 + 0.208e4 / 0.3e1 * t1218 - 0.5376e6 * t4796 * t9994 + 0.43008e6 * t4784 * t9994 + 0.1536e6 * t4791 * t9994 - 0.9216e5 * t1621 * t1392 * t510 + 0.8064e5 * t562 * t1395 * t510 - 0.10752e6 * t214 * t1086 * t194 + t10043) + 0.3e1 * t188 * t86 * t10066 + 0.2e1 * t541 * t592 * t1381 - t206 * t592 * t1398 - 0.2e1 * t206 * t233 * t3876 + 0.6e1 * t8160 * t1363 + 0.12e2 * t3103 * t3766 + 0.6e1 * t498 * t592 * t1362 + 0.3e1 * t188 * t592 * t1377 + 0.6e1 * t188 * t233 * t3815 + 0.12e2 * t498 * t86 * t10091 + 0.4e1 * t541 * t86 * t10095 + 0.48e2 * t5975 * t3772 * t2340 + 0.6e1 * t2265 * t1378 - 0.24e2 * t2781 * t10104 * t200 - 0.24e2 * t2781 * t10108 * t200;
  t10165 = -0.24e2 * t2781 * t7282 * t1054 - 0.24e2 * t7268 * t3773 - 0.36e2 * t6008 * t1381 * t200 * t224 + 0.24e2 * t2280 * t2792 * t1093 - 0.24e2 * t3458 * t409 * t224 * t1093 + 0.12e2 * t2280 * t1398 * t200 * t224 - 0.36e2 * t6008 * t3772 * t542 - 0.12e2 * t2781 * t3772 * t535 + 0.24e2 * t5985 * t3776 + 0.24e2 * t2280 * t10104 * t224 + 0.24e2 * t2280 * t10108 * t224 + 0.12e2 * t2280 * t3772 * t581 - 0.12e2 * t2781 * t1377 * t200 * t224 - 0.6e1 * t503 * t2705 * t409 + 0.12e2 * t4974 * t1363 * t542 - 0.12e2 * t6089 * t1366 - 0.6e1 * t503 * t2673 * t409;
  t10213 = 0.24e2 * t498 * t1037 * t1054 - 0.12e2 * t503 * t1037 * t1093 + 0.8e1 * t541 * t1064 * t1093 - 0.6e1 * t1526 * t1363 * t581 - 0.3e1 * t503 * t1378 * t581 - 0.6e1 * t1505 * t1382 * t581 - 0.3e1 * t503 * t1399 * t535 - 0.12e2 * t1505 * t3825 * t224 - 0.12e2 * t1526 * t3766 * t224 - 0.6e1 * t503 * t3837 * t200 - 0.6e1 * t503 * t3877 * t200 - 0.12e2 * t503 * t2676 * t409 + 0.12e2 * t498 * t397 * t2704 + 0.4e1 * t541 * t410 * t2774 + 0.24e2 * t3103 * t3769 - 0.12e2 * t7874 * t3763;
  t10265 = -0.12e2 * t503 * t1055 * t1093 + 0.6e1 * t1542 * t1378 * t542 + 0.6e1 * t498 * t1378 * t535 + 0.6e1 * t1542 * t1382 * t535 + 0.12e2 * t4974 * t1382 * t499 + 0.24e2 * t4993 * t1382 * t542 - 0.6e1 * t1505 * t1399 * t542 - 0.6e1 * t1526 * t1399 * t499 + 0.2e1 * t541 * t1399 * t581 + 0.12e2 * t1542 * t3825 * t200 + 0.12e2 * t498 * t3795 * t200 + 0.12e2 * t498 * t3816 * t200 - 0.6e1 * t503 * t3795 * t224 - 0.6e1 * t503 * t3816 * t224 + 0.4e1 * t541 * t3837 * t224 + 0.4e1 * t541 * t3877 * t224 - 0.6e1 * t503 * t397 * t2774;
  t10272 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t458 * t1401 - t9939 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t166 * t3880 + t9946 - t9948 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t28 * (t10112 + t10165 + t10213 + t10265));
  tv4rho2tau20 = t7 * t10272 + 0.2e1 * t3885;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t10279 = t6 * t617 * t1445;
  t10283 = t6 * t621 * t1445 / 0.12e2;
  t10285 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t613 * t1445 - t10279 / 0.4e1 + t10283);
  tv4rho2tau22 = t7 * t10285 + 0.2e1 * t3894;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t10291 = t6 * t642 * t1401;
  t10299 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t638 * t1401 - t10291 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t264 * t3880 - t9939 / 0.8e1 + t9946 - t9948 / 0.8e1);
  tv4rho2tau23 = t7 * t10299 + t3885 + t3900;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t10305 = t6 * t666 * t1445;
  t10312 = t6 * t251 * t4024;
  t10315 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t662 * t1445 - t10305 / 0.8e1 - t10279 / 0.8e1 + t10283 - 0.3e1 / 0.8e1 * t6 * t247 * t4024 - t10312 / 0.8e1);
  tv4rho2tau25 = t7 * t10315 + t3894 + t4029;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t10323 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t693 * t1401 - t10291 / 0.4e1 + t9946);
  tv4rho2tau26 = t7 * t10323 + 0.2e1 * t3900;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t10380 = -0.12e2 * t742 * t1127 * t1183 - 0.12e2 * t742 * t1145 * t1183 + 0.6e1 * t737 * t1422 * t774 - 0.3e1 * t742 * t1422 * t820 + 0.6e1 * t1977 * t1426 * t774 - 0.12e2 * t1940 * t3910 * t326 + 0.12e2 * t1977 * t3969 * t302 - 0.12e2 * t742 * t2926 * t433 - 0.6e1 * t742 * t2955 * t433 + 0.12e2 * t737 * t3939 * t302 + 0.12e2 * t737 * t3960 * t302 - 0.6e1 * t742 * t421 * t3024 - 0.6e1 * t742 * t3939 * t326 - 0.6e1 * t742 * t3960 * t326 + 0.24e2 * t3299 * t3913 - 0.12e2 * t8747 * t3907;
  t10432 = 0.24e2 * t737 * t1127 * t1144 + 0.8e1 * t780 * t1154 * t1183 - 0.6e1 * t1940 * t1407 * t820 + 0.12e2 * t5716 * t1407 * t781 + 0.6e1 * t1977 * t1422 * t781 - 0.6e1 * t1958 * t1426 * t820 + 0.12e2 * t5716 * t1426 * t738 - 0.3e1 * t742 * t1443 * t774 + 0.2e1 * t780 * t1443 * t820 - 0.12e2 * t1958 * t3969 * t326 - 0.6e1 * t742 * t2923 * t433 + 0.12e2 * t737 * t421 * t2954 - 0.6e1 * t742 * t3981 * t302 - 0.6e1 * t742 * t4021 * t302 + 0.4e1 * t780 * t434 * t3024 + 0.4e1 * t780 * t3981 * t326 + 0.4e1 * t780 * t4021 * t326;
  t10465 = t420 * t326;
  t10471 = t1144 * t433;
  t10475 = t420 * t1183;
  t10484 = -0.12e2 * t6740 * t1410 - 0.6e1 * t1958 * t1443 * t781 + 0.24e2 * t5678 * t1426 * t781 - 0.6e1 * t1940 * t1443 * t738 + 0.48e2 * t6646 * t3916 * t2615 + 0.12e2 * t2539 * t3916 * t820 - 0.12e2 * t3027 * t1421 * t302 * t326 - 0.36e2 * t6698 * t1425 * t302 * t326 + 0.24e2 * t2539 * t3038 * t1183 - 0.36e2 * t6698 * t3916 * t781 - 0.24e2 * t3027 * t10465 * t1144 - 0.24e2 * t7795 * t3917 - 0.24e2 * t3027 * t10471 * t302 - 0.24e2 * t3027 * t10475 * t302 - 0.12e2 * t3027 * t3916 * t774 + 0.24e2 * t6654 * t3920;
  t10501 = t1144 * t1144;
  t10505 = t1183 * t1183;
  t10530 = t3943 * t296;
  t10531 = t10530 * tau[1];
  t10538 = 0.1e1 / t105 / t1971;
  t10539 = t812 * t10538;
  t10546 = t2003 * t10538;
  t10550 = t5488 * t10531;
  t10568 = -0.512e5 * t3655 - 0.1792e6 * t3659 + 0.1536e6 * t3663 + 0.50176e6 * t3666 + 0.8064e5 * t801 * t1439 * t749 - 0.10752e6 * t316 * t1176 * t296 - 0.100352e7 / 0.3e1 * t137 * t2978 * tau[1] + 0.48e4 * t5509 * t10531 + 0.768e4 * t1994 * t1433 * t761 + 0.224e6 * t801 * t10539 * t765 - 0.2304e5 * t801 * t1436 * t761 - 0.7168e6 * t316 * t10546 * t765 - 0.384e4 * t10550 + 0.16128e5 * t316 * t1439 * t761 + 0.5376e6 * t137 * t5611 * t10538 * t765 + 0.2304e5 * t5550 * t1433 * t749 - 0.9216e5 * t1994 * t1436 * t749 - 0.208e4 * t1238 - 0.32e3 * t3643 - 0.6656e5 * t3668;
  t10580 = t6730 * t1414;
  t10585 = t5506 * t1414;
  t10589 = t10538 * t765;
  t10590 = t5509 * t10589;
  t10592 = t1414 * t761;
  t10597 = t6734 * t3949;
  t10599 = t5488 * t10589;
  t10601 = t2010 * t10592;
  t10610 = -0.288e3 * t10585 + 0.11648e6 / 0.3e1 * t137 * t2991 - 0.8e4 * t10590 + 0.288e3 * t2019 * t10592 + 0.8e4 * t5568 * t10589 + 0.48e3 * t10597 + 0.16e4 * t10599 - 0.288e3 * t10601 + 0.576e3 * t5488 * t1414 * t749 - 0.192e4 * t2019 * t2942 - 0.224e5 / 0.3e1 * t2047 * t3645;
  t10630 = t10538 * t311;
  t10646 = -0.104e4 / 0.9e1 * t3288 + 0.224e4 / 0.9e1 * t3689 - 0.4e3 / 0.3e1 * t10630 * t765 + 0.32e2 * t10580 + 0.32e3 * t10597 - 0.64e3 / 0.3e1 * t3643 + 0.32e4 / 0.3e1 * t10599 - 0.448e4 / 0.3e1 * t3646 + 0.416e4 / 0.9e1 * t1259 - 0.48e2 * t10585 - 0.64e3 * t10550 + 0.32e3 * t3649 - 0.48e2 * t10601 - 0.4e4 / 0.3e1 * t10590 + 0.448e4 / 0.3e1 * t3651 - 0.104e4 / 0.3e1 * t1238;
  t10650 = 0.24e2 * t2539 * t10471 * t326 + 0.24e2 * t2539 * t10475 * t326 - 0.24e2 * t3631 * t433 * t326 * t1183 + 0.12e2 * t2539 * t1442 * t302 * t326 + 0.6e1 * t2601 * t1422 + 0.12e2 * t737 * t151 * t10501 + 0.4e1 * t780 * t151 * t10505 + 0.2e1 * t780 * t831 * t1425 - t308 * t831 * t1442 - 0.2e1 * t308 * t335 * t4020 - t308 * t151 * (t10568 + 0.192e4 * t3649 + 0.896e4 * t3651 - 0.224e4 * t3646 + 0.1536e6 * t5576 * t10531 - 0.5376e6 * t5587 * t10531 + 0.43008e6 * t5581 * t10531 + 0.208e4 / 0.3e1 * t1259 + 0.832e5 / 0.3e1 * t1262 + 0.48e2 * t10580 + 0.416e4 / 0.3e1 * t796 * t768 + t10610) + 0.6e1 * t8535 * t1407 + 0.12e2 * t3299 * t3910 + 0.6e1 * t737 * t831 * t1406 + 0.3e1 * t290 * t831 * t1421 + 0.6e1 * t290 * t335 * t3959 + 0.3e1 * t290 * t151 * t10646;
  t10657 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t710 * t1445 - t10305 / 0.4e1 - 0.3e1 / 0.4e1 * t6 * t275 * t4024 + t10283 - t10312 / 0.4e1 - 0.3e1 / 0.8e1 * t6 * t102 * (t10380 + t10432 + t10484 + t10650));
  tv4rho2tau28 = t7 * t10657 + 0.2e1 * t4029;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t10664 = t6 * t172 * t4094 / 0.8e1;
  t10701 = -0.48e2 * t1648 * t3064 * t79 * t86 + 0.6e1 * t188 * t362 * t849 * t59 + 0.6e1 * t541 * t907 * t1223 + 0.6e1 * t541 * t358 * t3196 - 0.9e1 / 0.8e1 * t188 * t918 * t529 * t59 + 0.24e2 * t4993 * t4036 * t224 - 0.18e2 * t1505 * t1212 * t906 + 0.6e1 * t541 * t887 * t1223 + 0.6e1 * t541 * t4070 * t224 - 0.3e1 * t503 * t4078 * t200 + 0.2e1 * t541 * t4078 * t224;
  t10729 = 0.1e1 / t37 / t1521 * t29 * t181;
  t10735 = 0.625e3 / 0.2324522934e10 * t4716 * t10729;
  t10737 = 0.125e3 / 0.3188646e7 * t1515 * t3065;
  t10747 = 0.6e1 * t1648 * t4090 * t233 - 0.18e2 * t4957 * t4036 * t200 + 0.12e2 * t541 * t1215 * t906 - 0.9e1 * t503 * t4067 * t200 + 0.6e1 * t541 * t4067 * t224 - 0.9e1 * t503 * t4070 * t200 + 0.18e2 * t1542 * t4064 * t200 - 0.18e2 * t1505 * t4064 * t224 + t80 * (0.625e3 / 0.2324522934e10 * t4689 * t10729 - 0.125e3 / 0.3188646e7 * t1680 * t3065 - t10735 + t10737) + 0.18e2 * t5985 * t4032 + 0.18e2 * t2280 * t870 * t4031 - 0.18e2 * t9053 * t3157;
  t10783 = 0.36e2 * t3148 * t3161 + 0.12e3 * t3148 * t3136 + 0.9e1 / 0.4e1 * t2781 * t1558 * t1581 * t224 - 0.15e2 * t857 * t4804 * t4843 * tau[0] + 0.9e1 / 0.4e1 * t2781 * t3114 * t2281 - 0.9e1 / 0.4e1 * t2280 * t3114 * t3203 + 0.48e2 * t3151 * t3132 + 0.24e2 * t862 * t189 * t184 * t1223 + 0.96e2 * t2781 * t525 * t849 * t357 - 0.48e2 * t2280 * t189 * t184 * t1211 - 0.18e2 * t3151 * t3145;
  t10804 = t498 * t1228;
  t10807 = t503 * t1228;
  t10814 = -0.9e1 * t2327 * t4083 - 0.9e1 * t862 * t870 * t4082 - 0.9e1 * t862 * t189 * t39 * t3196 - 0.18e2 * t7875 * t4087 - 0.18e2 * t7268 * t4087 - 0.18e2 * t2781 * t525 * t529 * t906 + t10735 + 0.15e2 / 0.4e1 * t862 * t3121 * t3207 + 0.18e2 * t10804 * t859 - 0.9e1 * t10807 * t864 + 0.3e2 * t4054 * t875 - 0.18e2 * t7892 * t1201;
  t10855 = -0.54e2 * t8094 * t1277 * t1211 * t224 + 0.6e2 * t3202 * t2345 * t1211 * tau[0] + 0.18e2 * t3202 * t1277 * t1223 * t224 - 0.3e2 * t2350 * t2345 * t1223 * tau[0] + 0.36e2 * t3202 * t1277 * t357 * t906 - 0.36e2 * t2339 * t4247 * t357 * t194 + 0.36e2 * t4974 * t8219 * t4247 * t3203 + 0.36e2 * t6293 * t1277 * t8118 - 0.12e3 * t8220 * t8221 * t3207 - 0.18e2 * t3151 * t3141 - 0.36e2 * t8082 * t3199;
  t10884 = t1648 * t1581;
  t10885 = t205 * t86;
  t10891 = 0.36e2 * t1542 * t8081 * t3204 - 0.6e2 * t8088 * t3208 - 0.18e2 * t2339 * t1277 * t8123 + 0.18e2 * t857 * t1558 * t3064 - 0.6e1 * t862 * t8181 * t357 - 0.96e2 * t3148 * t3125 + 0.9e1 / 0.8e1 * t862 * t3114 * t906 + 0.9e1 * t188 * t3076 * t349 + 0.9e1 * t4054 * t871 + 0.18e2 * t4811 * t1581 * t4242 * t194 - 0.6e1 * t10884 * t10885 * t224 - 0.24e2 * t4054 * t878;
  t10895 = t3103 * t362;
  t10913 = t357 * t1223;
  t10922 = -0.15e2 / 0.4e1 * t1204 * t3122 + 0.18e2 * t10895 * t1197 + 0.18e2 * t7885 * t1197 - 0.9e1 / 0.4e1 * t3104 * t4048 - 0.9e1 / 0.4e1 * t2317 * t4048 - 0.9e1 / 0.4e1 * t857 * t6061 * t1581 + 0.9e1 / 0.8e1 * t2327 * t4051 + 0.6e2 * t4869 * t4843 * t4242 * tau[0] + 0.18e2 * t2280 * t10913 * t200 - 0.18e2 * t3458 * t10913 * t224 - 0.9e1 / 0.4e1 * t3148 * t3115;
  t10966 = 0.9e1 / 0.8e1 * t3151 * t3118 - 0.3e1 * t206 * t1228 * t906 - 0.3e1 * t206 * t918 * t1223 + 0.3e1 * t188 * t4061 * t200 - t206 * t4061 * t224 + 0.6e1 * t541 * t918 * t1211 - 0.3e1 * t206 * t3076 * t357 - 0.3e1 * t206 * t362 * t3196 - t206 * t233 * t4077 - t206 * t86 * (0.3e1 / 0.4e1 * t8144 - 0.15e2 / 0.32e2 * t8148 * tau[0] - 0.45e2 * t4855 * t4074 * t194 - 0.15e3 * t1621 * t219 * t4843 * tau[0] + 0.12e3 * t1621 * t75 * t3064) - 0.6e1 * t1505 * t233 * t4035 - t10737;
  t10974 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t4094 - t10664 - 0.3e1 / 0.8e1 * t6 * t28 * (t10701 + t10747 + t10783 + t10814 + t10855 + t10891 + t10922 + t10966));
  tv4rhosigma30 = t7 * t10974 + t4098;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t10981 = t6 * t251 * t4162 / 0.8e1;
  t10983 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t4162 - t10981);
  tv4rhosigma39 = t7 * t10983 + t4166;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t10989 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t4094 - t10664);
  tv4rhosigma310 = t7 * t10989 + t4098;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t10997 = 0.1e1 / t105 / t1972 * t29 * t283;
  t11003 = 0.625e3 / 0.2324522934e10 * t5770 * t10997;
  t11005 = 0.125e3 / 0.3188646e7 * t1968 * t3259;
  t11034 = t145 * (0.625e3 / 0.2324522934e10 * t5784 * t10997 - 0.125e3 / 0.3188646e7 * t2115 * t3259 - t11003 + t11005) - 0.18e2 * t7795 * t4153 - 0.18e2 * t3027 * t764 * t768 * t1004 - 0.18e2 * t8763 * t1242 - 0.18e2 * t3326 * t3316 - 0.18e2 * t3326 * t3320 - 0.9e1 * t2574 * t4159 - 0.9e1 * t960 * t968 * t4158 - 0.9e1 * t960 * t291 * t107 * t3359 + 0.18e2 * t6654 * t4123 + 0.18e2 * t2539 * t968 * t4122;
  t11058 = t737 * t1269;
  t11061 = t742 * t1269;
  t11068 = -0.18e2 * t9817 * t3332 + 0.36e2 * t3323 * t3335 + 0.12e3 * t3323 * t3311 + 0.9e1 / 0.4e1 * t3027 * t2010 * t2006 * t326 - 0.15e2 * t955 * t5488 * t5512 * tau[1] + 0.9e1 / 0.4e1 * t3027 * t3288 * t2540 - 0.9e1 / 0.4e1 * t2539 * t3288 * t3382 + 0.15e2 / 0.4e1 * t960 * t3295 * t3386 + 0.18e2 * t11058 * t957 - 0.9e1 * t11061 * t962 + 0.3e2 * t4145 * t973 - 0.18e2 * t8748 * t4153;
  t11105 = -0.48e2 * t2539 * t291 * t286 * t1252 + 0.6e2 * t3381 * t2620 * t1252 * tau[1] - 0.3e2 * t2625 * t2620 * t1264 * tau[1] + 0.24e2 * t960 * t291 * t286 * t1264 - 0.36e2 * t2614 * t4337 * t381 * t296 + 0.96e2 * t3027 * t764 * t947 * t381 + 0.36e2 * t5716 * t8607 * t4337 * t3382 - 0.12e3 * t8608 * t8609 * t3386 + 0.48e2 * t3326 * t3340 - 0.36e2 * t8568 * t3378 + t11003;
  t11155 = 0.36e2 * t1977 * t8567 * t3383 - 0.6e2 * t8574 * t3387 - 0.18e2 * t2614 * t1320 * t8531 + 0.18e2 * t3381 * t1320 * t1264 * t326 + 0.36e2 * t6879 * t1320 * t8544 - 0.54e2 * t8580 * t1320 * t1252 * t326 + 0.36e2 * t3381 * t1320 * t381 * t1004 - t308 * t4150 * t326 - 0.3e1 * t308 * t1016 * t1264 - 0.3e1 * t308 * t386 * t3359 - t308 * t335 * t4115 - t308 * t151 * (0.3e1 / 0.4e1 * t8516 - 0.15e2 / 0.32e2 * t8522 * tau[1] - 0.45e2 * t5550 * t4112 * t296 - 0.15e3 * t1994 * t321 * t5512 * tau[1] + 0.12e3 * t1994 * t140 * t3258);
  t11183 = t3299 * t386;
  t11188 = -0.3e1 * t308 * t1269 * t1004 + 0.6e1 * t780 * t1016 * t1252 - 0.6e1 * t1958 * t335 * t4130 + 0.18e2 * t955 * t2010 * t3258 + 0.3e1 * t290 * t4150 * t302 - 0.3e1 * t308 * t3308 * t381 - 0.6e1 * t960 * t8478 * t381 + 0.18e2 * t11183 * t1238 + 0.18e2 * t8837 * t1238 - 0.96e2 * t3323 * t3278 - 0.24e2 * t4145 * t976;
  t11210 = t2047 * t2006;
  t11211 = t307 * t151;
  t11223 = -0.9e1 / 0.4e1 * t3300 * t4139 - 0.9e1 / 0.4e1 * t2594 * t4139 - 0.9e1 / 0.4e1 * t955 * t6734 * t2006 + 0.9e1 / 0.8e1 * t2574 * t4142 + 0.9e1 / 0.8e1 * t960 * t3288 * t1004 + 0.9e1 * t290 * t3308 * t373 + 0.9e1 * t4145 * t969 + 0.18e2 * t5509 * t2006 * t4332 * t296 - 0.6e1 * t11210 * t11211 * t326 + 0.6e2 * t5568 * t5512 * t4332 * tau[1] - 0.9e1 / 0.4e1 * t3323 * t3289 + 0.9e1 / 0.8e1 * t3326 * t3292;
  t11227 = t381 * t1264;
  t11257 = -0.15e2 / 0.4e1 * t1245 * t3296 + 0.18e2 * t2539 * t11227 * t302 - 0.18e2 * t3631 * t11227 * t326 - t11005 + 0.6e1 * t290 * t386 * t947 * t124 - 0.48e2 * t2047 * t3258 * t144 * t151 + 0.2e1 * t780 * t4116 * t326 + 0.6e1 * t2047 * t4118 * t335 + 0.6e1 * t780 * t4105 * t326 - 0.9e1 * t742 * t4108 * t302 + 0.6e1 * t780 * t4108 * t326;
  t11295 = -0.3e1 * t742 * t4116 * t302 + 0.18e2 * t1977 * t4102 * t302 - 0.18e2 * t1958 * t4102 * t326 + 0.12e2 * t780 * t1256 * t1004 - 0.9e1 * t742 * t4105 * t302 - 0.18e2 * t1958 * t1253 * t1004 + 0.6e1 * t780 * t985 * t1264 + 0.6e1 * t780 * t1005 * t1264 + 0.6e1 * t780 * t382 * t3359 - 0.9e1 / 0.8e1 * t290 * t1016 * t768 * t124 - 0.18e2 * t5732 * t4131 * t302 + 0.24e2 * t5678 * t4131 * t326;
  t11303 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t4162 - t10981 - 0.3e1 / 0.8e1 * t6 * t102 * (t11034 + t11068 + t11105 + t11155 + t11188 + t11223 + t11257 + t11295));
  tv4rhosigma319 = t7 * t11303 + t4166;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  t11310 = t6 * t172 * t4252 / 0.8e1;
  t11327 = t59 * t224;
  t11332 = t67 * tau[0];
  t11343 = t409 * t1581;
  t11361 = -0.6e1 * t7892 * t1295 - 0.6e1 * t3151 * t3478 - 0.6e1 * t3151 * t3482 - 0.6e1 * t2327 * t4176 - 0.6e1 * t862 * t3521 * t52 * t1277 - 0.6e1 * t862 * t1311 * t194 * t1277 + 0.3e1 / 0.4e1 * t2781 * t4228 * t11327 - 0.5e1 / 0.2e1 * t857 * t396 * t1581 * t11332 + 0.3e1 / 0.4e1 * t2781 * t4235 * t59 * t200 - 0.3e1 / 0.4e1 * t2280 * t4235 * t11327 + 0.5e1 / 0.4e1 * t862 * t11343 * t11332 + 0.32e2 * t2781 * t4246 * t209 * t849 - 0.32e2 * t3148 * t3486 - 0.32e2 * t857 * t4169 * t3485 + 0.16e2 * t3151 * t3489 + 0.16e2 * t862 * t4175 * t3485;
  t11409 = 0.12e2 * t1558 * t529 * t4242 * t3471 - 0.6e1 * t1197 * t10885 * t7282 + 0.4e2 * t1579 * t1581 * t4242 * t396 * tau[0] - 0.6e1 * t7875 * t4248 - 0.6e1 * t7268 * t4248 - 0.6e1 * t2781 * t1093 * t53 * t4247 + 0.12e2 * t10895 * t1278 + 0.12e2 * t7885 * t1278 + 0.12e2 * t3148 * t3468 + 0.12e2 * t3148 * t3472 + 0.12e2 * t3104 * t4170 + 0.12e2 * t2317 * t4170 + 0.12e2 * t857 * t3537 * t52 * t1277 + 0.12e2 * t857 * t1290 * t194 * t1277 + 0.32e2 * t3548 * t3132 - 0.32e2 * t3557 * t3132 - 0.2e1 * t206 * t362 * t3521;
  t11414 = t9293 * tau[0];
  t11425 = t219 * t7024;
  t11438 = -0.21e2 / 0.4e1 * t3121 + 0.15e2 / 0.4e1 * t11414 - 0.9e1 / 0.4e1 * t6061 * t2684 - 0.15e2 * t4804 * t7024 * tau[0] + 0.63e2 / 0.4e1 * t4048 + 0.36e3 * t4855 * t4193 * t194 + 0.12e4 * t1621 * t11425 * tau[0] - 0.84e3 * t4075 - 0.72e3 * t1621 * t3508 * t194 - 0.21e4 * t562 * t9174 * tau[0] + 0.126e4 * t562 * t3189;
  t11472 = t1526 * t1284;
  t11478 = -t206 * t233 * t4198 - t206 * t86 * t11438 - t206 * t3076 * t409 - t206 * t1228 * t1093 - 0.2e1 * t206 * t918 * t1311 + 0.3e1 * t188 * t3076 * t396 + 0.3e1 * t188 * t1228 * t1054 + 0.6e1 * t188 * t918 * t1290 + 0.6e1 * t188 * t362 * t3537 + 0.12e2 * t9160 * t1201 + 0.12e2 * t3557 * t3141 + 0.12e2 * t3557 * t3145 + 0.12e2 * t9356 * t3157 - 0.12e2 * t3554 * t3161 - 0.4e2 * t3554 * t3136 - 0.12e2 * t11472 * t864 + 0.4e2 * t498 * t1284 * t875;
  t11479 = t1526 * t1291;
  t11488 = t1542 * t1301;
  t11497 = t1542 * t1312;
  t11525 = 0.4e1 * t857 * t396 * t849 * t59 - 0.2e1 * t862 * t409 * t849 * t59 + 0.4e2 * t498 * t1291 * t875 - 0.12e2 * t1526 * t1301 * t859 - 0.2e2 * t503 * t1301 * t875 - 0.12e2 * t1526 * t1312 * t859 - 0.2e2 * t503 * t1312 * t875 - 0.12e2 * t11479 * t864 + 0.12e2 * t11488 * t864 + 0.12e2 * t11497 * t864 - 0.12e2 * t9110 * t1201 - 0.12e2 * t9131 * t1201 - 0.12e2 * t9137 * t1201 + 0.12e2 * t9151 * t1201 - 0.32e2 * t3125 * t4243 - 0.12e2 * t3548 * t3141 - 0.12e2 * t3548 * t3145;
  t11532 = t409 * t1211;
  t11542 = t79 * t233;
  t11554 = t1311 * t357;
  t11558 = t1290 * t357;
  t11562 = t396 * t1223;
  t11579 = 0.3e1 / 0.8e1 * t862 * t1093 * t529 * t59 - 0.18e2 * t6008 * t11532 * t200 + 0.24e2 * t9024 * t11532 * t224 - 0.12e2 * t3458 * t3454 * t906 + 0.6e1 * t1197 * t11542 * t396 + 0.6e1 * t1197 * t4242 * t1054 + 0.12e2 * t7929 * t3455 - 0.12e2 * t1505 * t362 * t3459 + 0.12e2 * t2280 * t11554 * t200 + 0.12e2 * t2280 * t11558 * t224 - 0.6e1 * t2781 * t11562 * t200 + 0.6e1 * t2280 * t11562 * t224 + 0.3e1 / 0.2e1 * t857 * t3531 * t200 - 0.3e1 / 0.4e1 * t862 * t3531 * t224 + 0.15e2 / 0.4e1 * t348 * t11414 - 0.3e1 / 0.4e1 * t3104 * t4229;
  t11586 = t396 * t1211;
  t11601 = t409 * t1223;
  t11631 = -0.3e1 / 0.4e1 * t2317 * t4229 - 0.3e1 / 0.4e1 * t857 * t1054 * t529 * t59 + 0.12e2 * t5975 * t11586 * t200 - 0.18e2 * t6008 * t11586 * t224 + 0.12e2 * t2280 * t3447 * t906 + 0.3e1 / 0.8e1 * t2327 * t4236 - 0.12e2 * t3458 * t11554 * t224 + 0.6e1 * t2280 * t11601 * t200 - 0.6e1 * t3458 * t11601 * t224 - 0.12e2 * t9053 * t3448 + 0.12e2 * t7929 * t3451 - 0.12e2 * t2781 * t11558 * t200 - 0.21e2 / 0.4e1 * t188 * t86 * t1581 * t67 + 0.4e1 * t541 * t4187 * t224 - 0.3e1 * t503 * t4199 * t200 + 0.2e1 * t541 * t4199 * t224 - 0.6e1 * t503 * t4182 * t224;
  t11685 = -0.3e1 * t503 * t4185 * t200 + 0.2e1 * t541 * t4185 * t224 - 0.6e1 * t503 * t4187 * t200 - 0.6e1 * t1505 * t1094 * t1211 + 0.6e1 * t498 * t4179 * t200 - 0.3e1 * t503 * t4179 * t224 + 0.12e2 * t498 * t4182 * t200 + 0.6e1 * t1542 * t1055 * t1211 - 0.6e1 * t1505 * t1064 * t1211 - 0.3e1 * t503 * t1055 * t1223 - 0.3e1 * t503 * t397 * t3196 + 0.3e1 / 0.4e1 * t188 * t233 * t2684 * t67 + 0.6e1 * t1542 * t1037 * t1211 - 0.6e1 * t503 * t3538 * t357 - 0.6e1 * t503 * t1291 * t906 - 0.3e1 * t503 * t1037 * t1223 - 0.6e1 * t503 * t1284 * t906;
  t11723 = t513 * t4086 * tau[0];
  t11731 = t189 * t1200 * t224;
  t11738 = 0.24e2 * t9356 * t189 * t1200 * t200 + 0.2e1 * t541 * t1064 * t1223 + 0.2e1 * t541 * t1094 * t1223 + 0.4e1 * t541 * t1301 * t906 + 0.4e1 * t541 * t1312 * t906 + 0.2e1 * t541 * t410 * t3196 + 0.4e1 * t541 * t3492 * t357 + 0.4e1 * t541 * t3522 * t357 - 0.6e1 * t503 * t3524 * t357 - 0.6e1 * t503 * t3527 * t357 + 0.4e1 * t541 * t3541 * t357 + 0.4e1 * t541 * t3543 * t357 - 0.6e1 * t503 * t3545 * t357 - 0.4e2 * t3548 * t11723 + 0.4e2 * t3557 * t11723 - 0.36e2 * t9093 * t11731 + 0.24e2 * t9113 * t11731;
  t11746 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t4252 - t11310 - 0.3e1 / 0.8e1 * t6 * t28 * (t11361 + t11409 + t11478 + t11525 + t11579 + t11631 + t11685 + t11738));
  tv4rhosigma2tau0 = t7 * t11746 + t4256;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  t11753 = t6 * t251 * t4342 / 0.8e1;
  t11755 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t4342 - t11753);
  tv4rhosigma2tau11 = t7 * t11755 + t4346;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  t11761 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t4252 - t11310);
  tv4rhosigma2tau12 = t7 * t11761 + t4256;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  t11767 = t132 * tau[1];
  t11775 = t124 * t326;
  t11779 = t433 * t2006;
  t11811 = -0.5e1 / 0.2e1 * t955 * t420 * t2006 * t11767 + 0.3e1 / 0.4e1 * t3027 * t4277 * t124 * t302 - 0.3e1 / 0.4e1 * t2539 * t4277 * t11775 + 0.5e1 / 0.4e1 * t960 * t11779 * t11767 + 0.12e2 * t11183 * t1321 + 0.12e2 * t8837 * t1321 + 0.12e2 * t3323 * t3725 + 0.12e2 * t3323 * t3729 + 0.12e2 * t3300 * t4287 + 0.12e2 * t2594 * t4287 + 0.12e2 * t955 * t3694 * t120 * t1320 + 0.12e2 * t955 * t1333 * t296 * t1320 - 0.6e1 * t8763 * t1338 - 0.6e1 * t3326 * t3706 - 0.6e1 * t3326 * t3710 - 0.6e1 * t2574 * t4293;
  t11863 = -0.6e1 * t960 * t3670 * t120 * t1320 - 0.6e1 * t960 * t1354 * t296 * t1320 + 0.12e2 * t2010 * t768 * t4332 * t3728 + 0.16e2 * t3326 * t3717 + 0.16e2 * t960 * t4292 * t3713 + 0.32e2 * t3027 * t4336 * t311 * t947 - 0.32e2 * t3323 * t3714 - 0.32e2 * t955 * t4286 * t3713 + 0.3e1 / 0.4e1 * t3027 * t4270 * t11775 - 0.6e1 * t1238 * t11211 * t10465 + 0.4e2 * t2019 * t2006 * t4332 * t420 * tau[1] - 0.6e1 * t8748 * t4338 - 0.6e1 * t7795 * t4338 - 0.6e1 * t3027 * t1183 * t121 * t4337 + 0.32e2 * t3732 * t3340 - 0.32e2 * t3741 * t3340 - 0.12e2 * t3738 * t3335;
  t11867 = t1940 * t1327;
  t11873 = t1940 * t1334;
  t11900 = t1977 * t1344;
  t11906 = 0.4e2 * t737 * t1327 * t973 + 0.4e2 * t737 * t1334 * t973 - 0.12e2 * t1940 * t1344 * t957 - 0.2e2 * t742 * t1344 * t973 - 0.12e2 * t11867 * t962 - 0.12e2 * t11873 * t962 + 0.12e2 * t11900 * t962 + 0.12e2 * t9546 * t1242 + 0.12e2 * t9555 * t1242 - 0.12e2 * t9575 * t1242 - 0.12e2 * t9581 * t1242 - 0.4e2 * t3738 * t3311 - 0.12e2 * t3732 * t3316 + 0.12e2 * t3741 * t3316 - 0.12e2 * t3732 * t3320 + 0.12e2 * t3741 * t3320 + 0.12e2 * t9802 * t3332;
  t11910 = t1977 * t1355;
  t11957 = 0.4e1 * t780 * t1344 * t1004 + 0.4e1 * t780 * t1355 * t1004 + 0.6e1 * t1977 * t1127 * t1252 + 0.6e1 * t1977 * t1145 * t1252 - 0.6e1 * t1958 * t1154 * t1252 + 0.2e1 * t780 * t1154 * t1264 - 0.6e1 * t1958 * t1184 * t1252 + 0.2e1 * t780 * t1184 * t1264 - 0.12e2 * t1940 * t1355 * t957 - 0.2e2 * t742 * t1355 * t973 + 0.6e1 * t737 * t4297 * t302 + 0.2e1 * t780 * t434 * t3359 + 0.4e1 * t780 * t3671 * t381 + 0.4e1 * t780 * t3673 * t381 + 0.4e1 * t780 * t3675 * t381 + 0.12e2 * t11910 * t962 - 0.12e2 * t9569 * t1242;
  t12001 = t1354 * t381;
  t12008 = t433 * t1264;
  t12012 = 0.3e1 / 0.4e1 * t290 * t335 * t2934 * t132 + 0.4e1 * t780 * t3698 * t381 + 0.4e1 * t955 * t420 * t947 * t124 - 0.2e1 * t960 * t433 * t947 * t124 - 0.12e2 * t3631 * t3632 * t1004 - 0.12e2 * t9817 * t3637 + 0.12e2 * t8528 * t3640 - 0.21e2 / 0.4e1 * t290 * t151 * t2006 * t132 - 0.6e1 * t742 * t1334 * t1004 - 0.3e1 * t742 * t1127 * t1264 - 0.3e1 * t742 * t1145 * t1264 - 0.3e1 * t742 * t421 * t3359 - 0.12e2 * t1958 * t386 * t3633 + 0.12e2 * t2539 * t12001 * t302 - 0.12e2 * t3631 * t12001 * t326 + 0.6e1 * t2539 * t12008 * t302;
  t12024 = t420 * t1252;
  t12040 = t433 * t1252;
  t12047 = t1333 * t381;
  t12054 = t420 * t1264;
  t12061 = t144 * t335;
  t12068 = -0.6e1 * t3631 * t12008 * t326 - 0.3e1 / 0.4e1 * t3300 * t4271 - 0.3e1 / 0.4e1 * t2594 * t4271 - 0.3e1 / 0.4e1 * t955 * t1144 * t768 * t124 + 0.12e2 * t6646 * t12024 * t302 - 0.18e2 * t6698 * t12024 * t326 + 0.12e2 * t2539 * t3636 * t1004 + 0.3e1 / 0.8e1 * t2574 * t4278 + 0.3e1 / 0.8e1 * t960 * t1183 * t768 * t124 - 0.18e2 * t6698 * t12040 * t302 + 0.24e2 * t9737 * t12040 * t326 - 0.12e2 * t3027 * t12047 * t302 + 0.12e2 * t2539 * t12047 * t326 - 0.6e1 * t3027 * t12054 * t302 + 0.6e1 * t2539 * t12054 * t326 + 0.6e1 * t1238 * t12061 * t420 + 0.6e1 * t1238 * t4332 * t1144;
  t12076 = t9911 * tau[1];
  t12119 = 0.3e1 / 0.2e1 * t955 * t3688 * t302 - 0.3e1 / 0.4e1 * t960 * t3688 * t326 + 0.15e2 / 0.4e1 * t372 * t12076 + 0.12e2 * t8528 * t3700 - 0.32e2 * t3278 * t4333 - 0.6e1 * t742 * t3681 * t381 - 0.6e1 * t742 * t1327 * t1004 - 0.6e1 * t742 * t3684 * t381 - 0.6e1 * t742 * t3695 * t381 + 0.4e1 * t780 * t4305 * t326 - 0.3e1 * t742 * t4317 * t302 + 0.2e1 * t780 * t4317 * t326 - 0.6e1 * t742 * t3678 * t381 + 0.12e2 * t737 * t4300 * t302 - 0.6e1 * t742 * t4300 * t326 - 0.3e1 * t742 * t4303 * t302 + 0.2e1 * t780 * t4303 * t326;
  t12137 = t321 * t7518;
  t12150 = -0.21e2 / 0.4e1 * t3295 + 0.15e2 / 0.4e1 * t12076 - 0.9e1 / 0.4e1 * t6734 * t2934 - 0.15e2 * t5488 * t7518 * tau[1] + 0.63e2 / 0.4e1 * t4139 + 0.36e3 * t5550 * t4311 * t296 + 0.12e4 * t1994 * t12137 * tau[1] - 0.84e3 * t4113 - 0.72e3 * t1994 * t3657 * t296 - 0.21e4 * t801 * t9856 * tau[1] + 0.126e4 * t801 * t3352;
  t12178 = t291 * t1241 * t326;
  t12182 = t752 * t4152 * tau[1];
  t12193 = -0.6e1 * t742 * t4305 * t302 - 0.3e1 * t742 * t4297 * t326 - t308 * t151 * t12150 - t308 * t3308 * t433 - t308 * t1269 * t1183 - 0.2e1 * t308 * t1016 * t1354 - 0.2e1 * t308 * t386 * t3670 - t308 * t335 * t4316 + 0.3e1 * t290 * t3308 * t420 + 0.3e1 * t290 * t1269 * t1144 + 0.6e1 * t290 * t1016 * t1333 + 0.6e1 * t290 * t386 * t3694 + 0.24e2 * t9534 * t12178 - 0.4e2 * t3732 * t12182 + 0.24e2 * t9802 * t291 * t1241 * t302 - 0.36e2 * t9598 * t12178 + 0.4e2 * t3741 * t12182;
  t12201 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t4342 - t11753 - 0.3e1 / 0.8e1 * t6 * t102 * (t11811 + t11863 + t11906 + t11957 + t12012 + t12068 + t12119 + t12193));
  tv4rhosigma2tau23 = t7 * t12201 + t4346;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t12208 = t6 * t172 * t4428 / 0.8e1;
  t12210 = t10050 * tau[0];
  t12212 = t6061 * t3799;
  t12214 = t9968 * tau[0];
  t12215 = t4804 * t12214;
  t12259 = t219 * t9968;
  t12279 = 0.336e5 * t562 * t10022 * tau[0] - 0.2688e5 * t214 * t10029 * tau[0] - 0.96e4 * t1621 * t12259 * tau[0] + 0.1152e5 * t1621 * t3854 * t194 - 0.1008e5 * t562 * t3862 * t194 - 0.288e4 * t4855 * t4417 * t194 - 0.3e3 * t4811 * t12214 + 0.216e3 * t1579 * t2684 + 0.12096e5 * t214 * t2734 - 0.72e2 * t4804 * t9993 - 0.3e2 * t12210 + 0.36e2 * t12212 + 0.24e3 * t12215 + 0.36e2 * t3531 - 0.216e3 * t4191 + 0.576e4 * t4194 - 0.1728e5 * t4196;
  t12287 = 0.3e1 * t188 * t86 * (0.24e2 * t3531 - 0.2e2 * t12210 + 0.6e1 * t12212 + 0.4e2 * t12215 - 0.36e2 * t4191) + 0.2e1 * t541 * t918 * t1381 - t206 * t918 * t1398 - t206 * t362 * t3876 + 0.6e1 * t3103 * t4353 + 0.6e1 * t498 * t918 * t1362 + 0.3e1 * t188 * t918 * t1377 + 0.3e1 * t188 * t362 * t3815 + 0.3e1 * t188 * t233 * t4387 - t206 * t233 * t4424 - t206 * t86 * t12279 - 0.1e2 * t503 * t1399 * t875 - 0.12e2 * t9110 * t1295;
  t12296 = t1526 * t1378;
  t12305 = t4957 * t1382;
  t12316 = t1542 * t1399;
  t12323 = 0.2e2 * t498 * t1378 * t875 + 0.2e2 * t1542 * t1382 * t875 + 0.12e2 * t4974 * t1382 * t859 - 0.6e1 * t1526 * t1399 * t859 - 0.6e1 * t12296 * t864 - 0.18e2 * t12305 * t864 + 0.6e1 * t12316 * t864 - 0.12e2 * t9131 * t1295 - 0.12e2 * t9137 * t1295 - 0.12e2 * t3548 * t3478 + 0.12e2 * t3557 * t3478 - 0.12e2 * t3548 * t3482 + 0.32e2 * t3548 * t3489 - 0.16e2 * t878 * t4347;
  t12327 = t1398 * t357;
  t12339 = t1362 * t357;
  t12346 = t396 * t1290;
  t12363 = t1290 * t409;
  t12367 = 0.12e2 * t2280 * t10104 * t357 + 0.12e2 * t2280 * t10108 * t357 - 0.12e2 * t2781 * t3447 * t1054 + 0.6e1 * t349 * t11542 * t1362 + 0.6e1 * t2280 * t12327 * t200 - 0.6e1 * t3458 * t12327 * t224 + 0.12e2 * t5975 * t12339 * t224 - 0.12e2 * t2781 * t12346 * t224 - 0.12e2 * t2781 * t12363 * t200 + 0.12e2 * t2280 * t3772 * t906 - 0.12e2 * t9053 * t3773 + 0.12e2 * t7929 * t3776 + 0.6e1 * t871 * t4347 + 0.12e2 * t5985 * t4361;
  t12371 = t396 * t1311;
  t12378 = t1377 * t357;
  t12385 = t1381 * t357;
  t12395 = t409 * t1311;
  t12414 = -0.6e1 * t503 * t1037 * t1311 - 0.6e1 * t503 * t1055 * t1311 - 0.6e1 * t503 * t1284 * t1093 - 0.6e1 * t503 * t1291 * t1093 - 0.12e2 * t3458 * t3454 * t1093 + 0.12e2 * t2280 * t12363 * t224 - 0.12e2 * t2781 * t12371 * t200 + 0.12e2 * t2280 * t12371 * t224 - 0.6e1 * t2781 * t12378 * t200 + 0.6e1 * t2280 * t12378 * t224 - 0.18e2 * t6008 * t12385 * t200 + 0.24e2 * t9024 * t12385 * t224 + 0.12e2 * t2280 * t12395 * t200 - 0.12e2 * t3458 * t12395 * t224;
  t12454 = 0.12e2 * t498 * t1037 * t1290 + 0.12e2 * t498 * t1284 * t1054 + 0.12e2 * t498 * t1055 * t1290 - 0.6e1 * t1526 * t4353 * t224 - 0.6e1 * t1526 * t3766 * t357 + 0.2e1 * t541 * t4425 * t224 - 0.6e1 * t503 * t3524 * t409 - 0.6e1 * t503 * t3527 * t409 + 0.12e2 * t498 * t397 * t3537 - 0.6e1 * t503 * t3538 * t409 - 0.6e1 * t503 * t3545 * t409 + 0.12e2 * t3103 * t4356 - 0.6e1 * t7874 * t4350;
  t12497 = 0.4e1 * t541 * t1064 * t1311 + 0.4e1 * t541 * t1301 * t1093 + 0.4e1 * t541 * t1094 * t1311 - 0.6e1 * t1526 * t1363 * t906 - 0.6e1 * t1505 * t1382 * t906 + 0.2e1 * t541 * t1399 * t906 - 0.6e1 * t1505 * t4398 * t224 + 0.6e1 * t1542 * t4398 * t200 - 0.3e1 * t503 * t4411 * t200 - 0.3e1 * t503 * t4425 * t200 + 0.2e1 * t541 * t4411 * t224 + 0.4e1 * t541 * t410 * t3521 + 0.2e1 * t541 * t3837 * t357 + 0.2e1 * t541 * t3877 * t357;
  t12542 = 0.6e1 * t857 * t1377 * t194 * t1277 + 0.6e1 * t2280 * t1381 * t194 * t1277 + 0.6e1 * t857 * t3815 * t52 * t1277 - 0.3e1 * t503 * t1378 * t906 - 0.6e1 * t1505 * t3825 * t357 + 0.6e1 * t498 * t4381 * t200 + 0.6e1 * t498 * t4388 * t200 - 0.3e1 * t503 * t4381 * t224 - 0.3e1 * t503 * t4388 * t224 - 0.6e1 * t503 * t397 * t3521 - 0.3e1 * t503 * t3795 * t357 - 0.3e1 * t503 * t3816 * t357 + 0.6e1 * t2317 * t4374 + 0.6e1 * t5985 * t4392;
  t12590 = -0.3e1 * t2327 * t4405 - 0.3e1 * t862 * t3876 * t52 * t1277 - 0.3e1 * t862 * t1398 * t194 * t1277 - 0.16e2 * t2280 * t4391 * t3485 + 0.8e1 * t862 * t4404 * t3485 - 0.16e2 * t857 * t4373 * t3485 - 0.6e1 * t349 * t10885 * t1362 * t224 + 0.12e2 * t349 * t4242 * t396 * t1054 + 0.2e2 * t1218 * t4242 * t1362 * tau[0] + 0.24e2 * t5975 * t3772 * t2281 - 0.36e2 * t6008 * t3772 * t3203 + 0.6e1 * t3104 * t4374 - 0.4e2 * t3548 * t1294 * t2345 * tau[0] + 0.24e2 * t9113 * t1294 * t1277 * t224;
  t12598 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t4428 - t12208 - 0.3e1 / 0.8e1 * t6 * t28 * (t12287 + t12323 + t12367 + t12414 + t12454 + t12497 + t12542 + t12590));
  tv4rhosigmatau20 = t7 * t12598 + t4432;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t12605 = t6 * t251 * t4514 / 0.8e1;
  t12607 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t4514 - t12605);
  tv4rhosigmatau28 = t7 * t12607 + t4518;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t12613 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t4428 - t12208);
  tv4rhosigmatau29 = t7 * t12613 + t4432;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t12621 = t5732 * t1426;
  t12632 = t1977 * t1443;
  t12648 = t1940 * t1422;
  t12651 = 0.2e2 * t1977 * t1426 * t973 + 0.12e2 * t5716 * t1426 * t957 - 0.6e1 * t1940 * t1443 * t957 - 0.1e2 * t742 * t1443 * t973 - 0.18e2 * t12621 * t962 + 0.6e1 * t12632 * t962 - 0.6e1 * t12648 * t962 - 0.12e2 * t9569 * t1338 - 0.12e2 * t9575 * t1338 - 0.12e2 * t9581 * t1338 - 0.12e2 * t3732 * t3706 + 0.12e2 * t3741 * t3706 - 0.12e2 * t3732 * t3710;
  t12660 = t433 * t1354;
  t12667 = t1442 * t381;
  t12679 = t1406 * t381;
  t12686 = t420 * t1333;
  t12694 = -0.12e2 * t3027 * t3636 * t1144 - 0.12e2 * t3631 * t3632 * t1183 + 0.6e1 * t373 * t12061 * t1406 + 0.12e2 * t2539 * t12660 * t302 - 0.12e2 * t3631 * t12660 * t326 + 0.6e1 * t2539 * t12667 * t302 - 0.6e1 * t3631 * t12667 * t326 + 0.12e2 * t6646 * t12679 * t326 - 0.12e2 * t3027 * t12686 * t326 + 0.2e2 * t737 * t1422 * t973 + 0.32e2 * t3732 * t3717 + 0.6e1 * t969 * t4433 - 0.16e2 * t976 * t4433 + 0.12e2 * t6654 * t4447;
  t12709 = t1333 * t433;
  t12716 = t420 * t1354;
  t12723 = t1421 * t381;
  t12730 = t1425 * t381;
  t12740 = 0.12e2 * t2539 * t3916 * t1004 + 0.12e2 * t2539 * t10471 * t381 + 0.12e2 * t2539 * t10475 * t381 + 0.12e2 * t2539 * t12709 * t326 - 0.12e2 * t3027 * t12709 * t302 + 0.12e2 * t2539 * t12716 * t326 - 0.12e2 * t3027 * t12716 * t302 + 0.6e1 * t2539 * t12723 * t326 - 0.6e1 * t3027 * t12723 * t302 - 0.18e2 * t6698 * t12730 * t302 + 0.24e2 * t9737 * t12730 * t326 + 0.6e1 * t1977 * t4484 * t302 - 0.12e2 * t9817 * t3917 + 0.12e2 * t8528 * t3920;
  t12766 = t10630 * tau[1];
  t12768 = t6734 * t3943;
  t12770 = t10538 * tau[1];
  t12771 = t5488 * t12770;
  t12792 = 0.6e1 * t737 * t4474 * t302 - 0.3e1 * t742 * t4474 * t326 - 0.6e1 * t1958 * t3969 * t381 - 0.6e1 * t1958 * t1426 * t1004 + 0.6e1 * t737 * t1016 * t1406 + 0.3e1 * t290 * t1016 * t1421 + 0.3e1 * t290 * t386 * t3959 + 0.3e1 * t290 * t335 * t4473 + 0.3e1 * t290 * t151 * (0.24e2 * t3688 - 0.2e2 * t12766 + 0.6e1 * t12768 + 0.4e2 * t12771 - 0.36e2 * t4309) + 0.2e1 * t780 * t1016 * t1425 + 0.6e1 * t3299 * t4439 - 0.6e1 * t742 * t421 * t3670 - 0.3e1 * t742 * t3939 * t381 - 0.3e1 * t742 * t3960 * t381;
  t12834 = -0.3e1 * t742 * t1422 * t1004 - 0.6e1 * t742 * t1127 * t1354 + 0.12e2 * t737 * t1327 * t1144 - 0.6e1 * t742 * t1145 * t1354 - 0.6e1 * t742 * t1327 * t1183 - 0.6e1 * t742 * t1334 * t1183 - 0.6e1 * t1940 * t4439 * t326 + 0.6e1 * t737 * t4467 * t302 - 0.3e1 * t742 * t4467 * t326 - 0.6e1 * t742 * t3678 * t433 - 0.6e1 * t742 * t3681 * t433 - 0.6e1 * t742 * t3684 * t433 - 0.6e1 * t742 * t3695 * t433;
  t12875 = -0.6e1 * t1940 * t1407 * t1004 + 0.2e1 * t780 * t1443 * t1004 + 0.12e2 * t737 * t1127 * t1333 + 0.12e2 * t737 * t1145 * t1333 + 0.4e1 * t780 * t1154 * t1354 - 0.6e1 * t1940 * t3910 * t381 - 0.3e1 * t742 * t4497 * t302 - 0.3e1 * t742 * t4511 * t302 + 0.2e1 * t780 * t4497 * t326 + 0.2e1 * t780 * t4511 * t326 + 0.12e2 * t737 * t421 * t3694 + 0.2e1 * t780 * t4021 * t381 + 0.12e2 * t3299 * t4442 - 0.6e1 * t8747 * t4436;
  t12912 = t321 * t10538;
  t12932 = 0.336e5 * t801 * t10539 * tau[1] - 0.2688e5 * t316 * t10546 * tau[1] - 0.96e4 * t1994 * t12912 * tau[1] + 0.1152e5 * t1994 * t3998 * t296 - 0.1008e5 * t801 * t4006 * t296 - 0.288e4 * t5550 * t4503 * t296 - 0.72e2 * t5488 * t10530 - 0.3e3 * t5509 * t12770 + 0.216e3 * t2019 * t2934 + 0.12096e5 * t316 * t2971 - 0.3e2 * t12766 + 0.36e2 * t12768 + 0.24e3 * t12771 + 0.36e2 * t3688 - 0.216e3 * t4309 + 0.576e4 * t4312 - 0.1728e5 * t4314;
  t12953 = 0.4e1 * t780 * t1184 * t1354 + 0.4e1 * t780 * t434 * t3670 + 0.2e1 * t780 * t3981 * t381 - 0.6e1 * t1958 * t4484 * t326 + 0.4e1 * t780 * t1344 * t1183 - t308 * t1016 * t1442 - t308 * t386 * t4020 - t308 * t335 * t4510 - t308 * t151 * t12932 + 0.24e2 * t9534 * t1337 * t1320 * t326 - 0.4e2 * t3732 * t1337 * t2620 * tau[1] + 0.6e1 * t955 * t1421 * t296 * t1320 + 0.6e1 * t6654 * t4478 + 0.6e1 * t2539 * t1425 * t296 * t1320;
  t12999 = -0.3e1 * t2574 * t4491 - 0.3e1 * t960 * t4020 * t120 * t1320 - 0.3e1 * t960 * t1442 * t296 * t1320 - 0.6e1 * t373 * t11211 * t1406 * t326 + 0.12e2 * t373 * t4332 * t420 * t1144 + 0.2e2 * t1259 * t4332 * t1406 * tau[1] + 0.24e2 * t6646 * t3916 * t2540 - 0.36e2 * t6698 * t3916 * t3382 + 0.6e1 * t3300 * t4460 + 0.6e1 * t2594 * t4460 + 0.6e1 * t955 * t3959 * t120 * t1320 - 0.16e2 * t2539 * t4477 * t3713 + 0.8e1 * t960 * t4490 * t3713 - 0.16e2 * t955 * t4459 * t3713;
  t13007 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t4514 - t12605 - 0.3e1 / 0.8e1 * t6 * t102 * (t12651 + t12694 + t12740 + t12792 + t12834 + t12875 + t12953 + t12999));
  tv4rhosigmatau217 = t7 * t13007 + t4518;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t13014 = t6 * t172 * t4575 / 0.8e1;
  t13048 = -0.9e1 * t503 * t1037 * t1398 - 0.9e1 * t503 * t1055 * t1398 + 0.6e1 * t541 * t1064 * t1398 - 0.18e2 * t1505 * t1382 * t1093 + 0.6e1 * t541 * t1094 * t1398 + 0.6e1 * t498 * t4546 * t200 - 0.18e2 * t4957 * t4550 * t200 - 0.3e1 * t503 * t4546 * t224 + 0.24e2 * t4993 * t4550 * t224 - 0.9e1 * t503 * t397 * t3876 + 0.6e1 * t541 * t410 * t3876;
  t13081 = 0.18e2 * t498 * t1037 * t1377 + 0.18e2 * t1542 * t1037 * t1381 + 0.18e2 * t498 * t1055 * t1377 + 0.18e2 * t1542 * t1055 * t1381 - 0.18e2 * t1526 * t1363 * t1093 - 0.9e1 * t503 * t1378 * t1093 - 0.3e1 * t503 * t4573 * t200 - 0.9e1 * t503 * t3795 * t409 + 0.18e2 * t498 * t397 * t3815 - 0.9e1 * t503 * t3816 * t409 + 0.18e2 * t3103 * t4526;
  t13091 = t396 * t1398;
  t13095 = t409 * t1398;
  t13102 = t1362 * t409;
  t13109 = t396 * t1377;
  t13113 = t396 * t1381;
  t13120 = -0.36e2 * t2781 * t3772 * t1054 + 0.18e2 * t2280 * t13091 * t224 + 0.18e2 * t2280 * t13095 * t200 - 0.18e2 * t3458 * t13095 * t224 + 0.36e2 * t5975 * t13102 * t224 - 0.18e2 * t2781 * t13109 * t224 + 0.36e2 * t5975 * t13113 * t200 - 0.54e2 * t6008 * t13113 * t224 - 0.18e2 * t1526 * t3766 * t409 + 0.2e1 * t541 * t4573 * t224 - 0.18e2 * t7874 * t4523;
  t13124 = t1377 * t409;
  t13136 = t1362 * t79;
  t13139 = t4519 * t205;
  t13145 = 0.24e3 * t3800;
  t13147 = 0.1e1 / t37 / t487;
  t13148 = t13147 * t209;
  t13150 = 0.24e3 * t13148 * tau[0];
  t13151 = t6061 * t4538;
  t13153 = t13147 * tau[0];
  t13154 = t4804 * t13153;
  t13157 = t4538 * t194;
  t13158 = t4804 * t13157;
  t13160 = t4811 * t13153;
  t13184 = -0.48e4 * t4869 * t13153 - 0.144e4 * t4811 * t13157 + 0.24e4 * t1648 * t3799 - t13145 + t13150 - 0.432e3 * t13151 - 0.288e4 * t13154 + 0.1728e4 * t13158 + 0.72e4 * t13160 + 0.216e4 * t4385 - 0.432e4 * t4415;
  t13188 = t219 * t13147;
  t13196 = t573 * t13147;
  t13204 = t1604 * t13147;
  t13218 = -0.32256e6 * t72 * t4839 * t13147 * tau[0] + 0.768e5 * t1621 * t13188 * tau[0] - 0.4032e6 * t562 * t13196 * tau[0] + 0.64512e6 * t214 * t13204 * tau[0] - 0.13824e6 * t1621 * t4563 * t194 - 0.129024e6 * t214 * t4569 * t194 + 0.2304e5 * t4855 * t4560 * t194 + 0.24192e6 * t562 * t4566 * t194 + 0.10752e6 * t72 * t3870 - 0.384e5 * t4418 + 0.1728e6 * t4420 - 0.24192e6 * t4422;
  t13222 = 0.36e2 * t2280 * t3772 * t1093 - 0.18e2 * t2781 * t13124 * t200 + 0.18e2 * t2280 * t13124 * t224 - 0.18e2 * t2781 * t13091 * t200 + 0.6e1 * t4520 * t233 + 0.18e2 * t13136 * t1055 - 0.6e1 * t13139 * t225 + 0.3e1 * t188 * t233 * t4545 + 0.3e1 * t188 * t86 * (-t13145 + t13150 - 0.144e3 * t13151 - 0.96e3 * t13154 + 0.72e3 * t4385 + 0.192e3 * t13158 + 0.8e3 * t13160 - 0.48e3 * t4415) - 0.6e1 * t1505 * t233 * t4549 - t206 * t233 * t4572 - t206 * t86 * (t13184 + t13218);
  t13229 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t166 * t4575 - t13014 - 0.3e1 / 0.8e1 * t6 * t28 * (t13048 + t13081 + t13120 + t13222));
  tv4rhotau30 = t7 * t13229 + t4579;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t13236 = t6 * t251 * t4636 / 0.8e1;
  t13238 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t247 * t4636 - t13236);
  tv4rhotau33 = t7 * t13238 + t4640;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t13244 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t264 * t4575 - t13014);
  tv4rhotau34 = t7 * t13244 + t4579;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t13260 = t1406 * t433;
  t13267 = t420 * t1421;
  t13271 = t420 * t1425;
  t13281 = t1421 * t433;
  t13285 = -0.36e2 * t3027 * t3916 * t1144 - 0.18e2 * t1958 * t1426 * t1183 + 0.36e2 * t2539 * t3916 * t1183 + 0.36e2 * t6646 * t13260 * t326 - 0.18e2 * t3027 * t13267 * t326 + 0.36e2 * t6646 * t13271 * t302 - 0.54e2 * t6698 * t13271 * t326 - 0.18e2 * t3027 * t13281 * t302 - 0.18e2 * t5732 * t4611 * t302 + 0.24e2 * t5678 * t4611 * t326 + 0.6e1 * t4581 * t335;
  t13289 = t420 * t1442;
  t13296 = t433 * t1442;
  t13303 = 0.24e3 * t3944;
  t13305 = 0.1e1 / t105 / t726;
  t13306 = t13305 * t311;
  t13308 = 0.24e3 * t13306 * tau[1];
  t13309 = t6734 * t4599;
  t13311 = t13305 * tau[1];
  t13312 = t5488 * t13311;
  t13315 = t4599 * t296;
  t13316 = t5488 * t13315;
  t13318 = t5509 * t13311;
  t13342 = -0.48e4 * t5568 * t13311 - 0.144e4 * t5509 * t13315 + 0.24e4 * t2047 * t3943 - t13303 + t13308 - 0.432e3 * t13309 - 0.288e4 * t13312 + 0.1728e4 * t13316 + 0.72e4 * t13318 + 0.216e4 * t4471 - 0.432e4 * t4501;
  t13346 = t321 * t13305;
  t13354 = t812 * t13305;
  t13362 = t2003 * t13305;
  t13376 = -0.32256e6 * t137 * t5611 * t13305 * tau[1] + 0.768e5 * t1994 * t13346 * tau[1] - 0.4032e6 * t801 * t13354 * tau[1] + 0.64512e6 * t316 * t13362 * tau[1] - 0.13824e6 * t1994 * t4624 * t296 - 0.129024e6 * t316 * t4630 * t296 + 0.2304e5 * t5550 * t4621 * t296 + 0.24192e6 * t801 * t4627 * t296 + 0.10752e6 * t137 * t4014 - 0.384e5 * t4504 + 0.1728e6 * t4506 - 0.24192e6 * t4508;
  t13380 = t1406 * t144;
  t13383 = t4580 * t307;
  t13386 = 0.18e2 * t2539 * t13281 * t326 - 0.18e2 * t3027 * t13289 * t302 + 0.18e2 * t2539 * t13289 * t326 + 0.18e2 * t2539 * t13296 * t302 - 0.18e2 * t3631 * t13296 * t326 + 0.3e1 * t290 * t151 * (-t13303 + t13308 - 0.144e3 * t13309 - 0.96e3 * t13312 + 0.72e3 * t4471 + 0.192e3 * t13316 + 0.8e3 * t13318 - 0.48e3 * t4501) - 0.6e1 * t1958 * t335 * t4610 - t308 * t335 * t4633 - t308 * t151 * (t13342 + t13376) + 0.18e2 * t13380 * t1145 - 0.6e1 * t13383 * t327;
  t13421 = 0.18e2 * t1977 * t1127 * t1425 - 0.9e1 * t742 * t1127 * t1442 + 0.18e2 * t1977 * t1145 * t1425 - 0.9e1 * t742 * t1145 * t1442 - 0.9e1 * t742 * t1422 * t1183 + 0.3e1 * t290 * t335 * t4606 + 0.6e1 * t737 * t4607 * t302 - 0.3e1 * t742 * t4607 * t326 - 0.9e1 * t742 * t3939 * t433 - 0.9e1 * t742 * t3960 * t433 - 0.9e1 * t742 * t421 * t4020;
  t13456 = 0.18e2 * t737 * t1127 * t1421 + 0.18e2 * t737 * t1145 * t1421 + 0.6e1 * t780 * t1154 * t1442 - 0.18e2 * t1940 * t1407 * t1183 + 0.6e1 * t780 * t1184 * t1442 - 0.18e2 * t1940 * t3910 * t433 - 0.3e1 * t742 * t4634 * t302 + 0.2e1 * t780 * t4634 * t326 + 0.18e2 * t737 * t421 * t3959 + 0.6e1 * t780 * t434 * t4020 + 0.18e2 * t3299 * t4587 - 0.18e2 * t8747 * t4584;
  t13463 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t275 * t4636 - t13236 - 0.3e1 / 0.8e1 * t6 * t102 * (t13285 + t13386 + t13421 + t13456));
  tv4rhotau37 = t7 * t13463 + t4640;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t13466 = t4843 * t29 * t33;
  t13468 = t4716 * t13466;
  t13509 = t1211 * t1211;
  t13513 = t1223 * t1223;
  t13517 = t80 * (-0.625e3 / 0.6198727824e10 * t4689 * t13466 + 0.625e3 / 0.6198727824e10 * t13468) + 0.36e2 * t10804 * t1197 - 0.9e1 * t3148 * t4048 - 0.24e2 * t10884 * t10885 * t357 - 0.625e3 / 0.6198727824e10 * t13468 + 0.9e1 / 0.4e1 * t862 * t3114 * t1223 + 0.12e2 * t188 * t4061 * t349 - 0.9e1 / 0.2e1 * t2280 * t3114 * t1211 + 0.9e1 / 0.2e1 * t3151 * t4051 + 0.72e2 * t3202 * t1277 * t10913 - 0.4e1 * t206 * t362 * t4077 - 0.24e2 * t1505 * t362 * t4035 - 0.4e1 * t206 * t4061 * t357 + 0.12e2 * t541 * t1228 * t1211 - 0.6e1 * t206 * t1228 * t1223 + 0.24e2 * t4993 * t86 * t13509 + 0.6e1 * t541 * t86 * t13513;
  t13575 = 0.24e2 * t1648 * t4090 * t362 - 0.9e1 / 0.2e1 * t4811 * t4843 * t79 * t86 - 0.72e2 * t6008 * t189 * t39 * t4035 + 0.72e2 * t5975 * t525 * t529 * t1211 - 0.36e2 * t2781 * t525 * t529 * t1223 - 0.72e2 * t9053 * t4087 + 0.9e1 * t2781 * t1558 * t1581 * t357 - 0.36e2 * t10807 * t1201 - 0.36e2 * t3151 * t4083 - 0.12e2 * t862 * t4077 * t52 * t1277 - 0.45e2 / 0.8e1 * t206 * t86 * t4855 * t75 * t4843 + 0.72e2 * t7929 * t4032 + 0.24e2 * t541 * t1215 * t1223 + 0.8e1 * t541 * t358 * t4077 - 0.9e1 / 0.4e1 * t188 * t1228 * t529 * t59 + 0.9e1 / 0.32e2 * t498 * t86 * t4843 * t209 - 0.36e2 * t1505 * t1212 * t1223;
  t13580 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t13517 + t13575));
  tv4sigma40 = t7 * t13580;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t13590 = t5512 * t29 * t33;
  t13591 = t5770 * t13590;
  t13604 = t1252 * t1252;
  t13608 = t1264 * t1264;
  t13634 = 0.36e2 * t11058 * t1238 + 0.9e1 / 0.4e1 * t960 * t3288 * t1264 + 0.12e2 * t290 * t4150 * t373 - 0.625e3 / 0.6198727824e10 * t13591 - 0.24e2 * t11210 * t11211 * t381 - 0.9e1 / 0.2e1 * t2539 * t3288 * t1252 + 0.9e1 / 0.2e1 * t3326 * t4142 + 0.72e2 * t3381 * t1320 * t11227 + 0.24e2 * t5678 * t151 * t13604 + 0.6e1 * t780 * t151 * t13608 - 0.24e2 * t1958 * t386 * t4130 + 0.12e2 * t780 * t1269 * t1252 - 0.4e1 * t308 * t4150 * t381 - 0.6e1 * t308 * t1269 * t1264 - 0.4e1 * t308 * t386 * t4115 + 0.24e2 * t780 * t1256 * t1264 - 0.9e1 / 0.4e1 * t290 * t1269 * t768 * t124;
  t13691 = -0.36e2 * t1958 * t1253 * t1264 + 0.9e1 / 0.32e2 * t737 * t151 * t5512 * t311 + 0.8e1 * t780 * t4116 * t381 + 0.24e2 * t2047 * t4118 * t386 - 0.9e1 / 0.2e1 * t5509 * t5512 * t144 * t151 + t145 * (-0.625e3 / 0.6198727824e10 * t5784 * t13590 + 0.625e3 / 0.6198727824e10 * t13591) - 0.72e2 * t9817 * t4153 + 0.9e1 * t3027 * t2010 * t2006 * t381 - 0.36e2 * t3027 * t764 * t768 * t1264 + 0.72e2 * t8528 * t4123 - 0.36e2 * t11061 * t1242 - 0.36e2 * t3326 * t4159 - 0.12e2 * t960 * t4115 * t120 * t1320 - 0.45e2 / 0.8e1 * t308 * t151 * t5550 * t140 * t5512 - 0.72e2 * t6698 * t291 * t107 * t4130 + 0.72e2 * t6646 * t764 * t768 * t1252 - 0.9e1 * t3323 * t4139;
  t13696 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * (t13634 + t13691));
  tv4sigma414 = t7 * t13696;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  t13735 = -0.36e2 * t11479 * t1201 + 0.36e2 * t11488 * t1201 - 0.54e2 * t9093 * t4032 + 0.36e2 * t9113 * t4032 + 0.36e2 * t9356 * t4087 + 0.36e2 * t11497 * t1201 - 0.18e2 * t3548 * t4083 + 0.18e2 * t3557 * t4083 - 0.36e2 * t11472 * t1201 - 0.3e1 * t206 * t362 * t4198 - t206 * t86 * (0.9e1 / 0.32e2 * t9293 - 0.45e2 * t4855 * t75 * t7024 + 0.9e2 * t1621 * t11425) + 0.3e1 * t188 * t4061 * t396 + 0.9e1 * t188 * t1228 * t1290 - t206 * t4061 * t409;
  t13778 = 0.18e2 * t1542 * t1284 * t1211 + 0.18e2 * t1542 * t1291 * t1211 - 0.18e2 * t1505 * t1301 * t1211 - 0.18e2 * t1505 * t1312 * t1211 + 0.6e1 * t541 * t1301 * t1223 + 0.6e1 * t541 * t1312 * t1223 - 0.3e1 * t206 * t1228 * t1311 - 0.18e2 * t503 * t4182 * t357 + 0.6e1 * t541 * t4185 * t357 + 0.12e2 * t541 * t4187 * t357 + 0.6e1 * t541 * t4199 * t357 - 0.18e2 * t4957 * t397 * t4035 + 0.24e2 * t4993 * t410 * t4035 + 0.2e1 * t541 * t410 * t4077;
  t13796 = t59 * t357;
  t13821 = 0.9e1 / 0.4e1 * t188 * t362 * t2684 * t67 - 0.9e1 * t503 * t1284 * t1223 - 0.9e1 * t503 * t1291 * t1223 - 0.3e1 * t503 * t397 * t4077 - 0.9e1 * t503 * t4179 * t357 + 0.9e1 / 0.4e1 * t2781 * t4228 * t13796 - 0.9e1 / 0.4e1 * t2280 * t4235 * t13796 + 0.18e2 * t10804 * t1278 + 0.36e2 * t3148 * t4170 - 0.9e1 * t10807 * t1295 - 0.18e2 * t3151 * t4176 - 0.9e1 * t862 * t4198 * t52 * t1277 - 0.18e2 * t9053 * t4248 - 0.18e2 * t2781 * t1311 * t53 * t4247;
  t13842 = t79 * t362;
  t13865 = -0.18e2 * t1197 * t10885 * t3447 + 0.9e1 / 0.4e1 * t2781 * t11343 * t1558 - 0.18e2 * t3458 * t11601 * t357 - 0.9e1 / 0.4e1 * t862 * t3531 * t357 + 0.18e2 * t2280 * t11562 * t357 - 0.9e1 / 0.4e1 * t4048 * t4243 - 0.6e1 * t10884 * t10885 * t409 + 0.18e2 * t1197 * t13842 * t396 + 0.18e2 * t1197 * t4242 * t1290 - 0.9e1 / 0.4e1 * t3148 * t4229 + 0.9e1 / 0.2e1 * t857 * t7024 * t556 * t52 - 0.9e1 / 0.4e1 * t857 * t1290 * t529 * t59 + 0.9e1 / 0.8e1 * t3151 * t4236 + 0.9e1 / 0.8e1 * t862 * t1311 * t529 * t59;
  t13871 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t13735 + t13778 + t13821 + t13865));
  tv4sigma3tau0 = t7 * t13871;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  t13911 = -0.3e1 * t308 * t386 * t4316 - t308 * t151 * (0.9e1 / 0.32e2 * t9911 - 0.45e2 * t5550 * t140 * t7518 + 0.9e2 * t1994 * t12137) + 0.3e1 * t290 * t4150 * t420 + 0.9e1 * t290 * t1269 * t1333 - t308 * t4150 * t433 - 0.3e1 * t308 * t1269 * t1354 - 0.18e2 * t3732 * t4159 + 0.36e2 * t11900 * t1242 + 0.36e2 * t11910 * t1242 + 0.18e2 * t3741 * t4159 + 0.36e2 * t9534 * t4123 - 0.54e2 * t9598 * t4123 - 0.36e2 * t11867 * t1242 - 0.36e2 * t11873 * t1242;
  t13953 = 0.18e2 * t1977 * t1327 * t1252 + 0.18e2 * t1977 * t1334 * t1252 - 0.9e1 * t742 * t1327 * t1264 - 0.9e1 * t742 * t1334 * t1264 + 0.6e1 * t780 * t1344 * t1264 + 0.6e1 * t780 * t1355 * t1264 - 0.9e1 * t742 * t4297 * t381 - 0.18e2 * t742 * t4300 * t381 + 0.6e1 * t780 * t4303 * t381 + 0.12e2 * t780 * t4305 * t381 + 0.6e1 * t780 * t4317 * t381 - 0.3e1 * t742 * t421 * t4115 + 0.2e1 * t780 * t434 * t4115 + 0.36e2 * t9802 * t4153;
  t13971 = t124 * t381;
  t13997 = 0.9e1 / 0.4e1 * t290 * t386 * t2934 * t132 + 0.24e2 * t5678 * t434 * t4130 - 0.18e2 * t1958 * t1344 * t1252 - 0.18e2 * t1958 * t1355 * t1252 - 0.18e2 * t5732 * t421 * t4130 - 0.9e1 / 0.4e1 * t2539 * t4277 * t13971 + 0.18e2 * t11058 * t1321 + 0.36e2 * t3323 * t4287 - 0.9e1 * t11061 * t1338 - 0.18e2 * t3326 * t4293 - 0.9e1 * t960 * t4316 * t120 * t1320 + 0.9e1 / 0.4e1 * t3027 * t4270 * t13971 - 0.18e2 * t3027 * t1354 * t121 * t4337 - 0.18e2 * t1238 * t11211 * t3636;
  t14003 = t144 * t386;
  t14040 = -0.18e2 * t9817 * t4338 + 0.9e1 / 0.4e1 * t3027 * t11779 * t2010 + 0.18e2 * t1238 * t14003 * t420 + 0.18e2 * t1238 * t4332 * t1333 - 0.6e1 * t11210 * t11211 * t433 + 0.9e1 / 0.2e1 * t955 * t7518 * t795 * t120 - 0.9e1 / 0.4e1 * t4139 * t4333 - 0.9e1 / 0.4e1 * t960 * t3688 * t381 - 0.18e2 * t3631 * t12008 * t381 - 0.9e1 / 0.4e1 * t3323 * t4271 - 0.9e1 / 0.4e1 * t955 * t1333 * t768 * t124 + 0.18e2 * t2539 * t3636 * t1264 + 0.9e1 / 0.8e1 * t3326 * t4278 + 0.9e1 / 0.8e1 * t960 * t1354 * t768 * t124;
  t14046 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * (t13911 + t13953 + t13997 + t14040));
  tv4sigma3tau19 = t7 * t14046;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  t14047 = t1290 * t1290;
  t14051 = t1311 * t1311;
  t14099 = 0.12e2 * t498 * t86 * t14047 + 0.4e1 * t541 * t86 * t14051 - 0.2e1 * t206 * t362 * t4424 - t206 * t86 * (-0.9e1 / 0.2e1 * t10050 + 0.9e1 * t4804 * t9968 + 0.36e3 * t4855 * t75 * t9968 - 0.144e4 * t1621 * t12259 + 0.126e4 * t562 * t10022) + 0.3e1 * t188 * t1228 * t1377 + 0.6e1 * t188 * t362 * t4387 + 0.2e1 * t541 * t1228 * t1381 - t206 * t1228 * t1398 + 0.6e1 * t498 * t1228 * t1362 - 0.12e2 * t12296 * t1201 - 0.36e2 * t12305 * t1201 + 0.24e2 * t3557 * t4176 + 0.12e2 * t12316 * t1201 - 0.24e2 * t11472 * t1295 - 0.24e2 * t11479 * t1295 - 0.24e2 * t3548 * t4176;
  t14152 = -0.6e1 * t503 * t397 * t4198 - 0.6e1 * t503 * t4381 * t357 - 0.6e1 * t503 * t4388 * t357 - 0.3e1 * t503 * t1378 * t1223 - 0.9e1 / 0.4e1 * t188 * t86 * t9968 * t209 + 0.24e2 * t498 * t1284 * t1290 - 0.6e1 * t503 * t4179 * t409 - 0.12e2 * t503 * t4182 * t409 - 0.12e2 * t503 * t1284 * t1311 - 0.12e2 * t503 * t1291 * t1311 + 0.4e1 * t541 * t4425 * t357 + 0.2e1 * t541 * t1399 * t1223 - 0.3e1 / 0.4e1 * t3114 * t4347 - 0.12e2 * t1526 * t4353 * t357 - 0.6e1 * t1526 * t1363 * t1223 + 0.48e2 * t9113 * t1294 * t1277 * t357 + 0.8e1 * t541 * t1301 * t1311;
  t14204 = 0.4e1 * t541 * t410 * t4198 + 0.4e1 * t541 * t4411 * t357 - 0.12e2 * t1505 * t4398 * t357 - 0.6e1 * t1505 * t1382 * t1223 + 0.12e2 * t4974 * t1363 * t1211 - 0.6e1 * t1505 * t1399 * t1211 + 0.6e1 * t1542 * t1378 * t1211 + 0.24e2 * t4993 * t1382 * t1211 - 0.6e1 * t862 * t4424 * t52 * t1277 - 0.12e2 * t1197 * t10885 * t3772 + 0.12e2 * t5975 * t1381 * t53 * t4247 - 0.6e1 * t2781 * t1398 * t53 * t4247 - 0.12e2 * t349 * t10885 * t12339 + 0.24e2 * t349 * t4242 * t12346 + 0.3e1 / 0.2e1 * t2781 * t3772 * t3114 + 0.12e2 * t3148 * t4374;
  t14258 = 0.12e2 * t857 * t4387 * t52 * t1277 + 0.12e2 * t7929 * t4392 - 0.6e1 * t3151 * t4405 + 0.6e1 * t1197 * t4242 * t1377 - 0.36e2 * t6008 * t3772 * t1211 + 0.24e2 * t2280 * t12371 * t357 + 0.12e2 * t2280 * t3772 * t1223 - 0.3e1 / 0.2e1 * t862 * t3531 * t409 - 0.3e1 / 0.4e1 * t857 * t1377 * t529 * t59 - 0.3e1 / 0.4e1 * t2280 * t1381 * t529 * t59 - 0.24e2 * t3458 * t3454 * t1311 + 0.3e1 / 0.8e1 * t862 * t1398 * t529 * t59 + 0.12e2 * t349 * t13842 * t1362 - 0.24e2 * t2781 * t3447 * t1290 + 0.3e1 * t857 * t396 * t2684 * t67 + 0.24e2 * t7929 * t4361 + 0.24e2 * t2280 * t12363 * t357;
  t14264 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t14099 + t14152 + t14204 + t14258));
  tv4sigma2tau20 = t7 * t14264;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  t14265 = t1354 * t1354;
  t14269 = t1333 * t1333;
  t14317 = 0.4e1 * t780 * t151 * t14265 + 0.12e2 * t737 * t151 * t14269 + 0.6e1 * t737 * t1269 * t1406 + 0.3e1 * t290 * t1269 * t1421 + 0.6e1 * t290 * t386 * t4473 - 0.24e2 * t11867 * t1338 - 0.24e2 * t11873 * t1338 - 0.24e2 * t3732 * t4293 - 0.12e2 * t12648 * t1242 - 0.36e2 * t12621 * t1242 + 0.24e2 * t3741 * t4293 + 0.12e2 * t12632 * t1242 + 0.2e1 * t780 * t1269 * t1425 - t308 * t1269 * t1442 - 0.2e1 * t308 * t386 * t4510 - t308 * t151 * (-0.9e1 / 0.2e1 * t10630 + 0.9e1 * t5488 * t10538 + 0.36e3 * t5550 * t140 * t10538 - 0.144e4 * t1994 * t12912 + 0.126e4 * t801 * t10539);
  t14368 = 0.6e1 * t1977 * t1422 * t1252 + 0.24e2 * t5678 * t1426 * t1252 - 0.6e1 * t1958 * t1443 * t1252 - 0.6e1 * t1940 * t1407 * t1264 + 0.24e2 * t737 * t1327 * t1333 - 0.6e1 * t742 * t4297 * t433 + 0.12e2 * t5716 * t1407 * t1252 + 0.4e1 * t780 * t4497 * t381 + 0.4e1 * t780 * t4511 * t381 + 0.2e1 * t780 * t1443 * t1264 - 0.3e1 / 0.4e1 * t3288 * t4433 - 0.12e2 * t1940 * t4439 * t381 - 0.12e2 * t1958 * t4484 * t381 - 0.6e1 * t1958 * t1426 * t1264 + 0.8e1 * t780 * t1344 * t1354 + 0.4e1 * t780 * t434 * t4316 - 0.12e2 * t742 * t1327 * t1354;
  t14422 = -0.12e2 * t742 * t1334 * t1354 - 0.6e1 * t742 * t421 * t4316 - 0.6e1 * t742 * t4467 * t381 - 0.6e1 * t742 * t4474 * t381 - 0.3e1 * t742 * t1422 * t1264 - 0.9e1 / 0.4e1 * t290 * t151 * t10538 * t311 - 0.12e2 * t742 * t4300 * t433 + 0.48e2 * t9534 * t1337 * t1320 * t381 - 0.12e2 * t1238 * t11211 * t3916 + 0.12e2 * t6646 * t1425 * t121 * t4337 - 0.6e1 * t3027 * t1442 * t121 * t4337 - 0.12e2 * t373 * t11211 * t12679 + 0.24e2 * t373 * t4332 * t12686 + 0.3e1 / 0.2e1 * t3027 * t3916 * t3288 + 0.12e2 * t3323 * t4460 + 0.12e2 * t955 * t4473 * t120 * t1320;
  t14476 = 0.12e2 * t8528 * t4478 - 0.6e1 * t3326 * t4491 - 0.6e1 * t960 * t4510 * t120 * t1320 + 0.6e1 * t1238 * t4332 * t1421 + 0.12e2 * t373 * t14003 * t1406 - 0.24e2 * t3027 * t3636 * t1333 + 0.3e1 * t955 * t420 * t2934 * t132 + 0.24e2 * t8528 * t4447 + 0.24e2 * t2539 * t12709 * t381 + 0.24e2 * t2539 * t12716 * t381 + 0.12e2 * t2539 * t3916 * t1264 - 0.3e1 / 0.2e1 * t960 * t3688 * t433 - 0.3e1 / 0.4e1 * t955 * t1421 * t768 * t124 - 0.3e1 / 0.4e1 * t2539 * t1425 * t768 * t124 - 0.24e2 * t3631 * t3632 * t1354 + 0.3e1 / 0.8e1 * t960 * t1442 * t768 * t124 - 0.36e2 * t6698 * t3916 * t1252;
  t14482 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * (t14317 + t14368 + t14422 + t14476));
  tv4sigma2tau217 = t7 * t14482;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t14512 = 0.6e1 * t541 * t1301 * t1398 - 0.9e1 * t503 * t1378 * t1311 - 0.18e2 * t1505 * t1382 * t1311 + 0.6e1 * t541 * t1312 * t1398 + 0.24e2 * t4993 * t4550 * t357 - 0.9e1 * t503 * t4381 * t409 - 0.9e1 * t503 * t4388 * t409 - 0.18e2 * t12296 * t1295 - 0.18e2 * t3548 * t4405 + 0.18e2 * t3557 * t4405 + 0.36e2 * t9113 * t4392;
  t14546 = 0.18e2 * t1542 * t1284 * t1381 - 0.9e1 * t503 * t1284 * t1398 + 0.18e2 * t498 * t1291 * t1377 + 0.18e2 * t1542 * t1291 * t1381 - 0.9e1 * t503 * t1291 * t1398 - 0.18e2 * t1526 * t1363 * t1311 - 0.18e2 * t1526 * t4353 * t409 - 0.3e1 * t503 * t4546 * t357 + 0.2e1 * t541 * t4573 * t357 + 0.18e2 * t498 * t397 * t4387 - 0.9e1 * t503 * t397 * t4424;
  t14584 = 0.6e1 * t857 * t4545 * t52 * t1277 - 0.18e2 * t6008 * t4549 * t52 * t1277 - 0.3e1 * t862 * t4572 * t52 * t1277 - 0.18e2 * t349 * t10885 * t13102 + 0.18e2 * t498 * t1284 * t1377 + 0.18e2 * t2280 * t13091 * t357 - 0.18e2 * t3458 * t13095 * t357 + 0.36e2 * t5975 * t13102 * t357 + 0.18e2 * t349 * t4242 * t13109 + 0.18e2 * t2280 * t13124 * t357 + 0.6e1 * t541 * t410 * t4424;
  t14605 = t4804 * t13147;
  t14634 = -0.36e2 * t2781 * t3772 * t1290 - 0.18e2 * t2781 * t13109 * t357 - 0.54e2 * t6008 * t13113 * t357 + 0.36e2 * t2280 * t3772 * t1311 + 0.18e2 * t13136 * t1291 - 0.6e1 * t13139 * t358 + 0.3e1 * t188 * t362 * t4545 + 0.3e1 * t188 * t86 * (0.18e2 * t13148 - 0.24e2 * t14605) - 0.6e1 * t1505 * t362 * t4549 - t206 * t362 * t4572 - t206 * t86 * (-0.288e4 * t4855 * t75 * t13147 + 0.18e3 * t4811 * t13147 + 0.1728e5 * t1621 * t13188 - 0.3024e5 * t562 * t13196 + 0.16128e5 * t214 * t13204 + 0.54e2 * t13148 - 0.216e3 * t14605) + 0.6e1 * t4520 * t362;
  t14640 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * (t14512 + t14546 + t14584 + t14634));
  tv4sigmatau30 = t7 * t14640;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t14670 = 0.6e1 * t780 * t1344 * t1442 - 0.18e2 * t1958 * t1426 * t1354 + 0.6e1 * t780 * t1355 * t1442 - 0.3e1 * t742 * t4607 * t381 + 0.24e2 * t5678 * t4611 * t381 + 0.2e1 * t780 * t4634 * t381 + 0.6e1 * t780 * t434 * t4510 - 0.18e2 * t12648 * t1338 - 0.18e2 * t3732 * t4491 + 0.18e2 * t3741 * t4491 + 0.36e2 * t9534 * t4478;
  t14704 = 0.18e2 * t737 * t1327 * t1421 + 0.18e2 * t1977 * t1327 * t1425 - 0.9e1 * t742 * t1327 * t1442 + 0.18e2 * t737 * t1334 * t1421 + 0.18e2 * t1977 * t1334 * t1425 - 0.9e1 * t742 * t1334 * t1442 - 0.18e2 * t1940 * t1407 * t1354 - 0.9e1 * t742 * t1422 * t1354 + 0.18e2 * t737 * t421 * t4473 - 0.9e1 * t742 * t421 * t4510 - 0.9e1 * t742 * t4474 * t433;
  t14733 = t5488 * t13305;
  t14753 = -0.9e1 * t742 * t4467 * t433 - 0.18e2 * t1940 * t4439 * t433 - 0.18e2 * t373 * t11211 * t13260 + 0.18e2 * t373 * t4332 * t13267 + 0.6e1 * t955 * t4606 * t120 * t1320 - 0.18e2 * t6698 * t4610 * t120 * t1320 - 0.3e1 * t960 * t4633 * t120 * t1320 - t308 * t386 * t4633 - t308 * t151 * (-0.288e4 * t5550 * t140 * t13305 + 0.18e3 * t5509 * t13305 + 0.1728e5 * t1994 * t13346 - 0.3024e5 * t801 * t13354 + 0.16128e5 * t316 * t13362 + 0.54e2 * t13306 - 0.216e3 * t14733) + 0.18e2 * t13380 * t1334 - 0.6e1 * t13383 * t382;
  t14792 = 0.3e1 * t290 * t386 * t4606 + 0.3e1 * t290 * t151 * (0.18e2 * t13306 - 0.24e2 * t14733) + 0.36e2 * t6646 * t13260 * t381 - 0.36e2 * t3027 * t3916 * t1333 - 0.18e2 * t3027 * t13267 * t381 - 0.54e2 * t6698 * t13271 * t381 + 0.36e2 * t2539 * t3916 * t1354 + 0.18e2 * t2539 * t13281 * t381 + 0.18e2 * t2539 * t13289 * t381 - 0.18e2 * t3631 * t13296 * t381 - 0.6e1 * t1958 * t386 * t4610 + 0.6e1 * t4581 * t386;
  t14798 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * (t14670 + t14704 + t14753 + t14792));
  tv4sigmatau311 = t7 * t14798;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t14799 = t4709 * t209;
  t14801 = t4804 * t4709;
  t14803 = t4811 * t4709;
  t14836 = t1377 * t1377;
  t14855 = t1381 * t1381;
  t14862 = t1398 * t1398;
  t14884 = 0.3e1 * t188 * t86 * (-0.288e3 * t14799 + 0.768e3 * t14801 - 0.48e3 * t14803) - t206 * t86 * (-0.516096e6 * t214 * t1604 * t4709 - 0.18432e6 * t1621 * t219 * t4709 + 0.193536e6 * t72 * t4839 * t4709 + 0.2304e5 * t4855 * t75 * t4709 + 0.48384e6 * t562 * t573 * t4709 + 0.288e4 * t4869 * t4709 - 0.576e3 * t14799 + 0.3456e4 * t14801 - 0.576e4 * t14803) + 0.36e2 * t13136 * t1378 - 0.24e2 * t13139 * t410 + 0.18e2 * t498 * t86 * t14836 + 0.24e2 * t498 * t397 * t4545 + 0.36e2 * t1542 * t1378 * t1381 - 0.12e2 * t503 * t4546 * t409 - 0.18e2 * t503 * t1378 * t1398 - 0.12e2 * t503 * t397 * t4572 + 0.24e2 * t4993 * t86 * t14855 - 0.36e2 * t1505 * t1382 * t1398 + 0.6e1 * t541 * t86 * t14862 + 0.8e1 * t541 * t410 * t4572 - 0.36e2 * t1526 * t1363 * t1398 + 0.72e2 * t4974 * t1363 * t1381 - 0.72e2 * t2781 * t3772 * t1377 - 0.72e2 * t4957 * t397 * t4549 + 0.72e2 * t2280 * t3772 * t1398;
  t14888 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t14884);
  tv4tau40 = t7 * t14888;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t14889 = t1425 * t1425;
  t14896 = t1442 * t1442;
  t14906 = t1421 * t1421;
  t14925 = t5523 * t311;
  t14927 = t5488 * t5523;
  t14929 = t5509 * t5523;
  t14974 = 0.24e2 * t5678 * t151 * t14889 - 0.36e2 * t1958 * t1426 * t1442 + 0.6e1 * t780 * t151 * t14896 + 0.8e1 * t780 * t434 * t4633 - 0.36e2 * t1940 * t1407 * t1442 + 0.18e2 * t737 * t151 * t14906 + 0.24e2 * t737 * t421 * t4606 + 0.36e2 * t1977 * t1422 * t1425 - 0.12e2 * t742 * t4607 * t433 - 0.18e2 * t742 * t1422 * t1442 - 0.12e2 * t742 * t421 * t4633 - t308 * t151 * (0.193536e6 * t137 * t5611 * t5523 + 0.2304e5 * t5550 * t140 * t5523 - 0.18432e6 * t1994 * t321 * t5523 - 0.516096e6 * t316 * t2003 * t5523 + 0.48384e6 * t801 * t812 * t5523 + 0.288e4 * t5568 * t5523 - 0.576e3 * t14925 + 0.3456e4 * t14927 - 0.576e4 * t14929) + 0.36e2 * t13380 * t1422 - 0.24e2 * t13383 * t434 + 0.3e1 * t290 * t151 * (-0.288e3 * t14925 + 0.768e3 * t14927 - 0.48e3 * t14929) + 0.72e2 * t5716 * t1407 * t1425 - 0.72e2 * t3027 * t3916 * t1421 - 0.72e2 * t5732 * t421 * t4610 + 0.72e2 * t2539 * t3916 * t1442;
  t14978 = my_piecewise3(t93, 0, -0.3e1 / 0.8e1 * t6 * t102 * t14974);
  tv4tau44 = t7 * t14978;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

