/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2020 (X86 64 LINUX)
  Maple source      : ./maple/gga_exc/gga_x_2d_b86.mpl
  Type of functional: gga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t5, t6, t8, t9, t11, t13;
  double t15, t17, t18, t19, t20, t21, t23, t25;
  double t28, t29, t33, tzk0;


  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = sqrt(M_PI);
  t5 = 0.1e1 <= p->zeta_threshold;
  t6 = p->zeta_threshold - 0.1e1;
  t8 = my_piecewise5(t5, t6, t5, -t6, 0);
  t9 = 0.1e1 + t8;
  t11 = sqrt(p->zeta_threshold);
  t13 = sqrt(t9);
  t15 = my_piecewise3(t9 <= p->zeta_threshold, t11 * p->zeta_threshold, t13 * t9);
  t17 = M_SQRT2;
  t18 = 0.1e1 / t3 * t15 * t17;
  t19 = sqrt(rho[0]);
  t20 = rho[0] * rho[0];
  t21 = t20 * rho[0];
  t23 = sigma[0] / t21;
  t25 = 0.1e1 + 0.421e-2 * t23;
  t28 = 0.1e1 + 0.238e-3 * t23;
  t29 = 0.1e1 / t28;
  t33 = my_piecewise3(t2, 0, -0.2e1 / 0.3e1 * t18 * t19 * t25 * t29);
  tzk0 = 0.2e1 * t33;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t5, t6, t8, t9, t11, t13;
  double t15, t17, t18, t19, t20, t21, t23, t25;
  double t28, t29, t33, tzk0;

  double t39, t41, t47, t48, t50, t54, tvrho0, t58;
  double t62, t67, tvsigma0;


  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = sqrt(M_PI);
  t5 = 0.1e1 <= p->zeta_threshold;
  t6 = p->zeta_threshold - 0.1e1;
  t8 = my_piecewise5(t5, t6, t5, -t6, 0);
  t9 = 0.1e1 + t8;
  t11 = sqrt(p->zeta_threshold);
  t13 = sqrt(t9);
  t15 = my_piecewise3(t9 <= p->zeta_threshold, t11 * p->zeta_threshold, t13 * t9);
  t17 = M_SQRT2;
  t18 = 0.1e1 / t3 * t15 * t17;
  t19 = sqrt(rho[0]);
  t20 = rho[0] * rho[0];
  t21 = t20 * rho[0];
  t23 = sigma[0] / t21;
  t25 = 0.1e1 + 0.421e-2 * t23;
  t28 = 0.1e1 + 0.238e-3 * t23;
  t29 = 0.1e1 / t28;
  t33 = my_piecewise3(t2, 0, -0.2e1 / 0.3e1 * t18 * t19 * t25 * t29);
  tzk0 = 0.2e1 * t33;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t39 = t15 * t17;
  t41 = 0.1e1 / t19 / t21;
  t47 = t28 * t28;
  t48 = 0.1e1 / t47;
  t50 = t25 * t48 * sigma[0];
  t54 = my_piecewise3(t2, 0, -t18 / t19 * t25 * t29 / 0.3e1 + 0.47504762934721079361e-2 * t39 * t41 * sigma[0] * t29 - 0.26855424176873199259e-3 * t39 * t41 * t50);
  tvrho0 = 0.2e1 * rho[0] * t54 + 0.2e1 * t33;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t58 = 0.1e1 / t19 / t20;
  t62 = t58 * t25;
  t67 = my_piecewise3(t2, 0, -0.15834920978240359787e-2 * t39 * t58 * t29 + 0.8951808058957733086e-4 * t39 * t62 * t48);
  tvsigma0 = 0.2e1 * rho[0] * t67;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t5, t6, t8, t9, t11, t13;
  double t15, t17, t18, t19, t20, t21, t23, t25;
  double t28, t29, t33, tzk0;

  double t39, t41, t47, t48, t50, t54, tvrho0, t58;
  double t62, t67, tvsigma0;

  double t76, t78, t86, t88, t89, t94, t96, t97;
  double t98, t102, tv2rho20, t108, t110, t111, t115, t119;
  double t120, t124, tv2rhosigma0, t127, t129, t133, t138, tv2sigma20;


  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = sqrt(M_PI);
  t5 = 0.1e1 <= p->zeta_threshold;
  t6 = p->zeta_threshold - 0.1e1;
  t8 = my_piecewise5(t5, t6, t5, -t6, 0);
  t9 = 0.1e1 + t8;
  t11 = sqrt(p->zeta_threshold);
  t13 = sqrt(t9);
  t15 = my_piecewise3(t9 <= p->zeta_threshold, t11 * p->zeta_threshold, t13 * t9);
  t17 = M_SQRT2;
  t18 = 0.1e1 / t3 * t15 * t17;
  t19 = sqrt(rho[0]);
  t20 = rho[0] * rho[0];
  t21 = t20 * rho[0];
  t23 = sigma[0] / t21;
  t25 = 0.1e1 + 0.421e-2 * t23;
  t28 = 0.1e1 + 0.238e-3 * t23;
  t29 = 0.1e1 / t28;
  t33 = my_piecewise3(t2, 0, -0.2e1 / 0.3e1 * t18 * t19 * t25 * t29);
  tzk0 = 0.2e1 * t33;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t39 = t15 * t17;
  t41 = 0.1e1 / t19 / t21;
  t47 = t28 * t28;
  t48 = 0.1e1 / t47;
  t50 = t25 * t48 * sigma[0];
  t54 = my_piecewise3(t2, 0, -t18 / t19 * t25 * t29 / 0.3e1 + 0.47504762934721079361e-2 * t39 * t41 * sigma[0] * t29 - 0.26855424176873199259e-3 * t39 * t41 * t50);
  tvrho0 = 0.2e1 * rho[0] * t54 + 0.2e1 * t33;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t58 = 0.1e1 / t19 / t20;
  t62 = t58 * t25;
  t67 = my_piecewise3(t2, 0, -0.15834920978240359787e-2 * t39 * t58 * t29 + 0.8951808058957733086e-4 * t39 * t62 * t48);
  tvsigma0 = 0.2e1 * rho[0] * t67;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t76 = t20 * t20;
  t78 = 0.1e1 / t19 / t76;
  t86 = t76 * t21;
  t88 = 0.1e1 / t19 / t86;
  t89 = sigma[0] * sigma[0];
  t94 = t39 * t88;
  t96 = 0.1e1 / t47 / t28;
  t97 = t25 * t96;
  t98 = t97 * t89;
  t102 = my_piecewise3(t2, 0, t18 / t19 / rho[0] * t25 * t29 / 0.6e1 - 0.14251428880416323808e-1 * t39 * t78 * sigma[0] * t29 + 0.80566272530619597777e-3 * t39 * t78 * t50 + 0.67836801470781701328e-5 * t39 * t88 * t89 * t48 - 0.38349545724574928542e-6 * t94 * t98);
  tv2rho20 = 0.2e1 * rho[0] * t102 + 0.4e1 * t54;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t108 = t76 * t20;
  t110 = 0.1e1 / t19 / t108;
  t111 = t110 * t48;
  t115 = t41 * t25;
  t119 = t39 * t110;
  t120 = t97 * sigma[0];
  t124 = my_piecewise3(t2, 0, 0.39587302445600899468e-2 * t39 * t41 * t29 - 0.22612267156927233776e-5 * t39 * t111 * sigma[0] - 0.22379520147394332715e-3 * t39 * t115 * t48 + 0.12783181908191642847e-6 * t119 * t120);
  tv2rhosigma0 = 0.2e1 * rho[0] * t124 + 0.2e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t127 = t76 * rho[0];
  t129 = 0.1e1 / t19 / t127;
  t133 = t129 * t25;
  t138 = my_piecewise3(t2, 0, 0.75374223856424112585e-6 * t39 * t129 * t48 - 0.42610606360638809489e-7 * t39 * t133 * t96);
  tv2sigma20 = 0.2e1 * rho[0] * t138;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t5, t6, t8, t9, t11, t13;
  double t15, t17, t18, t19, t20, t21, t23, t25;
  double t28, t29, t33, tzk0;

  double t39, t41, t47, t48, t50, t54, tvrho0, t58;
  double t62, t67, tvsigma0;

  double t76, t78, t86, t88, t89, t94, t96, t97;
  double t98, t102, tv2rho20, t108, t110, t111, t115, t119;
  double t120, t124, tv2rhosigma0, t127, t129, t133, t138, tv2sigma20;

  double t151, t153, t158, t163, t164, t169, t170, t171;
  double t172, t173, t177, tv3rho30, t184, t190, t191, t201;
  double t202, t206, tv3rho2sigma0, t213, t214, t222, t223, t227;
  double tv3rhosigma20, t238, tv3sigma30;


  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = sqrt(M_PI);
  t5 = 0.1e1 <= p->zeta_threshold;
  t6 = p->zeta_threshold - 0.1e1;
  t8 = my_piecewise5(t5, t6, t5, -t6, 0);
  t9 = 0.1e1 + t8;
  t11 = sqrt(p->zeta_threshold);
  t13 = sqrt(t9);
  t15 = my_piecewise3(t9 <= p->zeta_threshold, t11 * p->zeta_threshold, t13 * t9);
  t17 = M_SQRT2;
  t18 = 0.1e1 / t3 * t15 * t17;
  t19 = sqrt(rho[0]);
  t20 = rho[0] * rho[0];
  t21 = t20 * rho[0];
  t23 = sigma[0] / t21;
  t25 = 0.1e1 + 0.421e-2 * t23;
  t28 = 0.1e1 + 0.238e-3 * t23;
  t29 = 0.1e1 / t28;
  t33 = my_piecewise3(t2, 0, -0.2e1 / 0.3e1 * t18 * t19 * t25 * t29);
  tzk0 = 0.2e1 * t33;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t39 = t15 * t17;
  t41 = 0.1e1 / t19 / t21;
  t47 = t28 * t28;
  t48 = 0.1e1 / t47;
  t50 = t25 * t48 * sigma[0];
  t54 = my_piecewise3(t2, 0, -t18 / t19 * t25 * t29 / 0.3e1 + 0.47504762934721079361e-2 * t39 * t41 * sigma[0] * t29 - 0.26855424176873199259e-3 * t39 * t41 * t50);
  tvrho0 = 0.2e1 * rho[0] * t54 + 0.2e1 * t33;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t58 = 0.1e1 / t19 / t20;
  t62 = t58 * t25;
  t67 = my_piecewise3(t2, 0, -0.15834920978240359787e-2 * t39 * t58 * t29 + 0.8951808058957733086e-4 * t39 * t62 * t48);
  tvsigma0 = 0.2e1 * rho[0] * t67;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t76 = t20 * t20;
  t78 = 0.1e1 / t19 / t76;
  t86 = t76 * t21;
  t88 = 0.1e1 / t19 / t86;
  t89 = sigma[0] * sigma[0];
  t94 = t39 * t88;
  t96 = 0.1e1 / t47 / t28;
  t97 = t25 * t96;
  t98 = t97 * t89;
  t102 = my_piecewise3(t2, 0, t18 / t19 / rho[0] * t25 * t29 / 0.6e1 - 0.14251428880416323808e-1 * t39 * t78 * sigma[0] * t29 + 0.80566272530619597777e-3 * t39 * t78 * t50 + 0.67836801470781701328e-5 * t39 * t88 * t89 * t48 - 0.38349545724574928542e-6 * t94 * t98);
  tv2rho20 = 0.2e1 * rho[0] * t102 + 0.4e1 * t54;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t108 = t76 * t20;
  t110 = 0.1e1 / t19 / t108;
  t111 = t110 * t48;
  t115 = t41 * t25;
  t119 = t39 * t110;
  t120 = t97 * sigma[0];
  t124 = my_piecewise3(t2, 0, 0.39587302445600899468e-2 * t39 * t41 * t29 - 0.22612267156927233776e-5 * t39 * t111 * sigma[0] - 0.22379520147394332715e-3 * t39 * t115 * t48 + 0.12783181908191642847e-6 * t119 * t120);
  tv2rhosigma0 = 0.2e1 * rho[0] * t124 + 0.2e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t127 = t76 * rho[0];
  t129 = 0.1e1 / t19 / t127;
  t133 = t129 * t25;
  t138 = my_piecewise3(t2, 0, 0.75374223856424112585e-6 * t39 * t129 * t48 - 0.42610606360638809489e-7 * t39 * t133 * t96);
  tv2sigma20 = 0.2e1 * rho[0] * t138;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t151 = t76 * t76;
  t153 = 0.1e1 / t19 / t151;
  t158 = t39 * t153;
  t163 = 0.1e1 / t19 / t151 / t21;
  t164 = t89 * sigma[0];
  t169 = t39 * t163;
  t170 = t47 * t47;
  t171 = 0.1e1 / t170;
  t172 = t25 * t171;
  t173 = t172 * t164;
  t177 = my_piecewise3(t2, 0, -t18 * t62 * t29 / 0.4e1 + 0.62943810888505430152e-1 * t39 * t129 * sigma[0] * t29 - 0.35583437034356989019e-2 * t39 * t129 * t50 - 0.71228641544320786394e-4 * t39 * t153 * t89 * t48 + 0.40267023010803674969e-5 * t158 * t98 + 0.14530642875041440424e-7 * t39 * t163 * t164 * t96 - 0.82144726942039496937e-9 * t169 * t173);
  tv3rho30 = 0.2e1 * rho[0] * t177 + 0.6e1 * t102;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t184 = t88 * t48;
  t190 = 0.1e1 / t19 / t151 / t20;
  t191 = t190 * t96;
  t201 = t39 * t190;
  t202 = t172 * t89;
  t206 = my_piecewise3(t2, 0, -0.13855555855960314814e-1 * t39 * t78 * t29 + 0.20351040441234510398e-4 * t39 * t184 * sigma[0] - 0.48435476250138134748e-8 * t39 * t191 * t89 + 0.78328320515880164502e-3 * t39 * t78 * t25 * t48 - 0.11504863717372478562e-5 * t94 * t120 + 0.27381575647346498978e-9 * t201 * t202);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t206 + 0.4e1 * t124;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t213 = 0.1e1 / t19 / t151 / rho[0];
  t214 = t213 * t96;
  t222 = t39 * t213;
  t223 = t172 * sigma[0];
  t227 = my_piecewise3(t2, 0, -0.41455823121033261922e-5 * t39 * t111 + 0.16145158750046044916e-8 * t39 * t214 * sigma[0] + 0.23435833498351345219e-6 * t39 * t110 * t25 * t96 - 0.91271918824488329925e-10 * t222 * t223);
  tv3rhosigma20 = 0.2e1 * rho[0] * t227 + 0.2e1 * t138;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t238 = my_piecewise3(t2, 0, -0.53817195833486816385e-9 * t39 * t153 * t96 + 0.30423972941496109975e-10 * t39 * t153 * t25 * t171);
  tv3sigma30 = 0.2e1 * rho[0] * t238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t2, t3, t5, t6, t8, t9, t11, t13;
  double t15, t17, t18, t19, t20, t21, t23, t25;
  double t28, t29, t33, tzk0;

  double t39, t41, t47, t48, t50, t54, tvrho0, t58;
  double t62, t67, tvsigma0;

  double t76, t78, t86, t88, t89, t94, t96, t97;
  double t98, t102, tv2rho20, t108, t110, t111, t115, t119;
  double t120, t124, tv2rhosigma0, t127, t129, t133, t138, tv2sigma20;

  double t151, t153, t158, t163, t164, t169, t170, t171;
  double t172, t173, t177, tv3rho30, t184, t190, t191, t201;
  double t202, t206, tv3rho2sigma0, t213, t214, t222, t223, t227;
  double tv3rhosigma20, t238, tv3sigma30;

  double t258, t263, t268, t269, t276, t277, t282, tv4rho40;
  double t299, t316, tv4rho3sigma0, t327, t343, tv4rho2sigma20, t360, tv4rhosigma30;
  double t371, tv4sigma40;


  t2 = rho[0] / 0.2e1 <= p->dens_threshold;
  t3 = sqrt(M_PI);
  t5 = 0.1e1 <= p->zeta_threshold;
  t6 = p->zeta_threshold - 0.1e1;
  t8 = my_piecewise5(t5, t6, t5, -t6, 0);
  t9 = 0.1e1 + t8;
  t11 = sqrt(p->zeta_threshold);
  t13 = sqrt(t9);
  t15 = my_piecewise3(t9 <= p->zeta_threshold, t11 * p->zeta_threshold, t13 * t9);
  t17 = M_SQRT2;
  t18 = 0.1e1 / t3 * t15 * t17;
  t19 = sqrt(rho[0]);
  t20 = rho[0] * rho[0];
  t21 = t20 * rho[0];
  t23 = sigma[0] / t21;
  t25 = 0.1e1 + 0.421e-2 * t23;
  t28 = 0.1e1 + 0.238e-3 * t23;
  t29 = 0.1e1 / t28;
  t33 = my_piecewise3(t2, 0, -0.2e1 / 0.3e1 * t18 * t19 * t25 * t29);
  tzk0 = 0.2e1 * t33;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t39 = t15 * t17;
  t41 = 0.1e1 / t19 / t21;
  t47 = t28 * t28;
  t48 = 0.1e1 / t47;
  t50 = t25 * t48 * sigma[0];
  t54 = my_piecewise3(t2, 0, -t18 / t19 * t25 * t29 / 0.3e1 + 0.47504762934721079361e-2 * t39 * t41 * sigma[0] * t29 - 0.26855424176873199259e-3 * t39 * t41 * t50);
  tvrho0 = 0.2e1 * rho[0] * t54 + 0.2e1 * t33;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t58 = 0.1e1 / t19 / t20;
  t62 = t58 * t25;
  t67 = my_piecewise3(t2, 0, -0.15834920978240359787e-2 * t39 * t58 * t29 + 0.8951808058957733086e-4 * t39 * t62 * t48);
  tvsigma0 = 0.2e1 * rho[0] * t67;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  t76 = t20 * t20;
  t78 = 0.1e1 / t19 / t76;
  t86 = t76 * t21;
  t88 = 0.1e1 / t19 / t86;
  t89 = sigma[0] * sigma[0];
  t94 = t39 * t88;
  t96 = 0.1e1 / t47 / t28;
  t97 = t25 * t96;
  t98 = t97 * t89;
  t102 = my_piecewise3(t2, 0, t18 / t19 / rho[0] * t25 * t29 / 0.6e1 - 0.14251428880416323808e-1 * t39 * t78 * sigma[0] * t29 + 0.80566272530619597777e-3 * t39 * t78 * t50 + 0.67836801470781701328e-5 * t39 * t88 * t89 * t48 - 0.38349545724574928542e-6 * t94 * t98);
  tv2rho20 = 0.2e1 * rho[0] * t102 + 0.4e1 * t54;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t108 = t76 * t20;
  t110 = 0.1e1 / t19 / t108;
  t111 = t110 * t48;
  t115 = t41 * t25;
  t119 = t39 * t110;
  t120 = t97 * sigma[0];
  t124 = my_piecewise3(t2, 0, 0.39587302445600899468e-2 * t39 * t41 * t29 - 0.22612267156927233776e-5 * t39 * t111 * sigma[0] - 0.22379520147394332715e-3 * t39 * t115 * t48 + 0.12783181908191642847e-6 * t119 * t120);
  tv2rhosigma0 = 0.2e1 * rho[0] * t124 + 0.2e1 * t67;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  t127 = t76 * rho[0];
  t129 = 0.1e1 / t19 / t127;
  t133 = t129 * t25;
  t138 = my_piecewise3(t2, 0, 0.75374223856424112585e-6 * t39 * t129 * t48 - 0.42610606360638809489e-7 * t39 * t133 * t96);
  tv2sigma20 = 0.2e1 * rho[0] * t138;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  t151 = t76 * t76;
  t153 = 0.1e1 / t19 / t151;
  t158 = t39 * t153;
  t163 = 0.1e1 / t19 / t151 / t21;
  t164 = t89 * sigma[0];
  t169 = t39 * t163;
  t170 = t47 * t47;
  t171 = 0.1e1 / t170;
  t172 = t25 * t171;
  t173 = t172 * t164;
  t177 = my_piecewise3(t2, 0, -t18 * t62 * t29 / 0.4e1 + 0.62943810888505430152e-1 * t39 * t129 * sigma[0] * t29 - 0.35583437034356989019e-2 * t39 * t129 * t50 - 0.71228641544320786394e-4 * t39 * t153 * t89 * t48 + 0.40267023010803674969e-5 * t158 * t98 + 0.14530642875041440424e-7 * t39 * t163 * t164 * t96 - 0.82144726942039496937e-9 * t169 * t173);
  tv3rho30 = 0.2e1 * rho[0] * t177 + 0.6e1 * t102;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t184 = t88 * t48;
  t190 = 0.1e1 / t19 / t151 / t20;
  t191 = t190 * t96;
  t201 = t39 * t190;
  t202 = t172 * t89;
  t206 = my_piecewise3(t2, 0, -0.13855555855960314814e-1 * t39 * t78 * t29 + 0.20351040441234510398e-4 * t39 * t184 * sigma[0] - 0.48435476250138134748e-8 * t39 * t191 * t89 + 0.78328320515880164502e-3 * t39 * t78 * t25 * t48 - 0.11504863717372478562e-5 * t94 * t120 + 0.27381575647346498978e-9 * t201 * t202);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t206 + 0.4e1 * t124;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  t213 = 0.1e1 / t19 / t151 / rho[0];
  t214 = t213 * t96;
  t222 = t39 * t213;
  t223 = t172 * sigma[0];
  t227 = my_piecewise3(t2, 0, -0.41455823121033261922e-5 * t39 * t111 + 0.16145158750046044916e-8 * t39 * t214 * sigma[0] + 0.23435833498351345219e-6 * t39 * t110 * t25 * t96 - 0.91271918824488329925e-10 * t222 * t223);
  tv3rhosigma20 = 0.2e1 * rho[0] * t227 + 0.2e1 * t138;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  t238 = my_piecewise3(t2, 0, -0.53817195833486816385e-9 * t39 * t153 * t96 + 0.30423972941496109975e-10 * t39 * t153 * t25 * t171);
  tv3sigma30 = 0.2e1 * rho[0] * t238;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  t258 = 0.1e1 / t19 / t151 / t76;
  t263 = t39 * t258;
  t268 = 0.1e1 / t19 / t151 / t86;
  t269 = t89 * t89;
  t276 = 0.1e1 / t170 / t28;
  t277 = t25 * t276;
  t282 = my_piecewise3(t2, 0, 0.5e1 / 0.8e1 * t18 * t115 * t29 - 0.34440953127672782536e0 * t39 * t110 * sigma[0] * t29 + 0.19470182528233069463e-1 * t119 * t50 + 0.69532721507551243861e-3 * t39 * t213 * t89 * t48 - 0.39308284367689301756e-4 * t222 * t98 - 0.31967414325091168934e-6 * t39 * t258 * t164 * t96 + 0.18071839927248689326e-7 * t263 * t173 + 0.41499516051118353851e-10 * t39 * t268 * t269 * t171 - 0.23460534014646480325e-11 * t39 * t268 * t277 * t269);
  tv4rho40 = 0.2e1 * rho[0] * t282 + 0.8e1 * t177;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t299 = 0.1e1 / t19 / t151 / t108;
  t316 = my_piecewise3(t2, 0, 0.62350001351821416663e-1 * t39 * t129 * t29 - 0.17241853707157015753e-3 * t39 * t153 * t48 * sigma[0] + 0.94449178687769362757e-7 * t39 * t163 * t96 * t89 - 0.13833172017039451284e-10 * t39 * t299 * t171 * t164 - 0.35247744232146074026e-2 * t39 * t133 * t48 + 0.97471762049961276706e-5 * t158 * t120 - 0.53394072512325673007e-8 * t169 * t202 + 0.78201780048821601081e-12 * t39 * t299 * t277 * t164);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t316 + 0.6e1 * t206;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  t327 = 0.1e1 / t19 / t151 / t127;
  t343 = my_piecewise3(t2, 0, 0.26946285028671620249e-4 * t39 * t184 - 0.24217738125069067374e-7 * t39 * t191 * sigma[0] + 0.4611057339013150428e-11 * t39 * t327 * t171 * t89 - 0.15233291773928374392e-5 * t39 * t88 * t25 * t96 + 0.13690787823673249489e-8 * t201 * t223 - 0.26067260016273867027e-12 * t39 * t327 * t277 * t89);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t343 + 0.4e1 * t227;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  t360 = my_piecewise3(t2, 0, 0.45744616458463793927e-8 * t39 * t214 - 0.1537019113004383476e-11 * t39 * t258 * t171 * sigma[0] - 0.25860377000271693479e-9 * t39 * t213 * t25 * t171 + 0.86890866720912890089e-13 * t263 * t277 * sigma[0]);
  tv4rhosigma30 = 0.2e1 * rho[0] * t360 + 0.2e1 * t238;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  t371 = my_piecewise3(t2, 0, 0.51233970433479449198e-12 * t39 * t163 * t171 - 0.28963622240304296696e-13 * t39 * t163 * t25 * t276);
  tv4sigma40 = 0.2e1 * rho[0] * t371;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t12;
  double t13, t14, t16, t17, t18, t19, t20, t21;
  double t22, t23, t25, t26, t27, t28, t29, t30;
  double t31, t33, t36, t37, t38, t41, t42, t43;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t54, t55, t56, t58, t61, t62, t63, t66;
  double tzk0;


  t1 = rho[0] <= p->dens_threshold;
  t2 = sqrt(M_PI);
  t3 = 0.1e1 / t2;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 <= p->zeta_threshold;
  t19 = sqrt(p->zeta_threshold);
  t20 = t19 * p->zeta_threshold;
  t21 = sqrt(t17);
  t22 = t21 * t17;
  t23 = my_piecewise3(t18, t20, t22);
  t25 = M_SQRT2;
  t26 = t3 * t23 * t25;
  t27 = sqrt(t4);
  t28 = rho[0] * rho[0];
  t29 = t28 * rho[0];
  t30 = 0.1e1 / t29;
  t31 = sigma[0] * t30;
  t33 = 0.1e1 + 0.2105e-2 * t31;
  t36 = 0.1e1 + 0.119e-3 * t31;
  t37 = 0.1e1 / t36;
  t38 = t27 * t33 * t37;
  t41 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t26 * t38);
  t42 = rho[1] <= p->dens_threshold;
  t43 = -t14;
  t45 = my_piecewise5(t12, t9, t8, t13, t43 * t5);
  t46 = 0.1e1 + t45;
  t47 = t46 <= p->zeta_threshold;
  t48 = sqrt(t46);
  t49 = t48 * t46;
  t50 = my_piecewise3(t47, t20, t49);
  t52 = t3 * t50 * t25;
  t53 = rho[1] * rho[1];
  t54 = t53 * rho[1];
  t55 = 0.1e1 / t54;
  t56 = sigma[2] * t55;
  t58 = 0.1e1 + 0.2105e-2 * t56;
  t61 = 0.1e1 + 0.119e-3 * t56;
  t62 = 0.1e1 / t61;
  t63 = t27 * t58 * t62;
  t66 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t52 * t63);
  tzk0 = t41 + t66;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t12;
  double t13, t14, t16, t17, t18, t19, t20, t21;
  double t22, t23, t25, t26, t27, t28, t29, t30;
  double t31, t33, t36, t37, t38, t41, t42, t43;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t54, t55, t56, t58, t61, t62, t63, t66;
  double tzk0;

  double t67, t68, t69, t71, t74, t76, t79, t81;
  double t83, t84, t85, t86, t87, t88, t89, t92;
  double t93, t94, t95, t99, t100, t102, t105, t107;
  double t111, t113, t115, tvrho0, t119, t122, t124, t128;
  double t130, t133, t135, t138, t139, t140, t141, t142;
  double t143, t146, t147, t148, t149, t153, tvrho1, t157;
  double t160, t164, tvsigma0, tvsigma1, t166, t169, t173, tvsigma2;


  t1 = rho[0] <= p->dens_threshold;
  t2 = sqrt(M_PI);
  t3 = 0.1e1 / t2;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 <= p->zeta_threshold;
  t19 = sqrt(p->zeta_threshold);
  t20 = t19 * p->zeta_threshold;
  t21 = sqrt(t17);
  t22 = t21 * t17;
  t23 = my_piecewise3(t18, t20, t22);
  t25 = M_SQRT2;
  t26 = t3 * t23 * t25;
  t27 = sqrt(t4);
  t28 = rho[0] * rho[0];
  t29 = t28 * rho[0];
  t30 = 0.1e1 / t29;
  t31 = sigma[0] * t30;
  t33 = 0.1e1 + 0.2105e-2 * t31;
  t36 = 0.1e1 + 0.119e-3 * t31;
  t37 = 0.1e1 / t36;
  t38 = t27 * t33 * t37;
  t41 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t26 * t38);
  t42 = rho[1] <= p->dens_threshold;
  t43 = -t14;
  t45 = my_piecewise5(t12, t9, t8, t13, t43 * t5);
  t46 = 0.1e1 + t45;
  t47 = t46 <= p->zeta_threshold;
  t48 = sqrt(t46);
  t49 = t48 * t46;
  t50 = my_piecewise3(t47, t20, t49);
  t52 = t3 * t50 * t25;
  t53 = rho[1] * rho[1];
  t54 = t53 * rho[1];
  t55 = 0.1e1 / t54;
  t56 = sigma[2] * t55;
  t58 = 0.1e1 + 0.2105e-2 * t56;
  t61 = 0.1e1 + 0.119e-3 * t56;
  t62 = 0.1e1 / t61;
  t63 = t27 * t58 * t62;
  t66 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t52 * t63);
  tzk0 = t41 + t66;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t67 = t4 * t4;
  t68 = 0.1e1 / t67;
  t69 = t14 * t68;
  t71 = my_piecewise5(t8, 0, t12, 0, t5 - t69);
  t74 = my_piecewise3(t18, 0, 0.3e1 / 0.2e1 * t21 * t71);
  t76 = t3 * t74 * t25;
  t79 = 0.1e1 / t27;
  t81 = t79 * t33 * t37;
  t83 = t26 * t81 / 0.3e1;
  t84 = t23 * t25;
  t85 = t84 * t27;
  t86 = t28 * t28;
  t87 = 0.1e1 / t86;
  t88 = sigma[0] * t87;
  t89 = t88 * t37;
  t92 = t36 * t36;
  t93 = 0.1e1 / t92;
  t94 = t33 * t93;
  t95 = t94 * t88;
  t99 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t76 * t38 - t83 + 0.23752381467360539681e-2 * t85 * t89 - 0.13427712088436599629e-3 * t85 * t95);
  t100 = t43 * t68;
  t102 = my_piecewise5(t12, 0, t8, 0, -t5 - t100);
  t105 = my_piecewise3(t47, 0, 0.3e1 / 0.2e1 * t48 * t102);
  t107 = t3 * t105 * t25;
  t111 = t79 * t58 * t62;
  t113 = t52 * t111 / 0.3e1;
  t115 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t107 * t63 - t113);
  tvrho0 = t41 + t66 + t4 * (t99 + t115);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t119 = my_piecewise5(t8, 0, t12, 0, -t5 - t69);
  t122 = my_piecewise3(t18, 0, 0.3e1 / 0.2e1 * t21 * t119);
  t124 = t3 * t122 * t25;
  t128 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t124 * t38 - t83);
  t130 = my_piecewise5(t12, 0, t8, 0, t5 - t100);
  t133 = my_piecewise3(t47, 0, 0.3e1 / 0.2e1 * t48 * t130);
  t135 = t3 * t133 * t25;
  t138 = t50 * t25;
  t139 = t138 * t27;
  t140 = t53 * t53;
  t141 = 0.1e1 / t140;
  t142 = sigma[2] * t141;
  t143 = t142 * t62;
  t146 = t61 * t61;
  t147 = 0.1e1 / t146;
  t148 = t58 * t147;
  t149 = t148 * t142;
  t153 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t135 * t63 - t113 + 0.23752381467360539681e-2 * t139 * t143 - 0.13427712088436599629e-3 * t139 * t149);
  tvrho1 = t41 + t66 + t4 * (t128 + t153);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t157 = t27 * t30 * t37;
  t160 = t94 * t30;
  t164 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t84 * t157 + 0.44759040294788665431e-4 * t85 * t160);
  tvsigma0 = t4 * t164;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t166 = t27 * t55 * t62;
  t169 = t148 * t55;
  t173 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t138 * t166 + 0.44759040294788665431e-4 * t139 * t169);
  tvsigma2 = t4 * t173;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t12;
  double t13, t14, t16, t17, t18, t19, t20, t21;
  double t22, t23, t25, t26, t27, t28, t29, t30;
  double t31, t33, t36, t37, t38, t41, t42, t43;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t54, t55, t56, t58, t61, t62, t63, t66;
  double tzk0;

  double t67, t68, t69, t71, t74, t76, t79, t81;
  double t83, t84, t85, t86, t87, t88, t89, t92;
  double t93, t94, t95, t99, t100, t102, t105, t107;
  double t111, t113, t115, tvrho0, t119, t122, t124, t128;
  double t130, t133, t135, t138, t139, t140, t141, t142;
  double t143, t146, t147, t148, t149, t153, tvrho1, t157;
  double t160, t164, tvsigma0, tvsigma1, t166, t169, t173, tvsigma2;

  double t176, t177, t180, t181, t182, t185, t189, t191;
  double t194, t196, t197, t203, t205, t207, t208, t209;
  double t211, t213, t214, t215, t216, t219, t220, t221;
  double t222, t223, t227, t228, t229, t232, t235, t236;
  double t237, t238, t241, t244, t248, t250, t253, t256;
  double t258, t260, tv2rho20, t263, t267, t271, t273, t276;
  double t278, t279, t288, t289, t293, t297, t299, t302;
  double t305, t306, t309, t310, t314, t317, tv2rho21, t322;
  double t327, t331, t333, t338, t339, t344, t348, t350;
  double t354, t355, t362, t363, t364, t365, t368, t369;
  double t370, t371, t372, t376, t377, t378, t381, t384;
  double t385, tv2rho22, t391, t393, t395, t398, t399, t401;
  double t407, t408, t409, t412, t416, tv2rhosigma0, tv2rhosigma1, t421;
  double t423, t427, t429, tv2rhosigma2, t436, tv2rhosigma3, tv2rhosigma4, t441;
  double t444, t445, t447, t452, t453, t456, t460, tv2rhosigma5;
  double t462, t463, t464, t465, t468, t472, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t473, t474, t475, t476, t479;
  double t483, tv2sigma25;


  t1 = rho[0] <= p->dens_threshold;
  t2 = sqrt(M_PI);
  t3 = 0.1e1 / t2;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 <= p->zeta_threshold;
  t19 = sqrt(p->zeta_threshold);
  t20 = t19 * p->zeta_threshold;
  t21 = sqrt(t17);
  t22 = t21 * t17;
  t23 = my_piecewise3(t18, t20, t22);
  t25 = M_SQRT2;
  t26 = t3 * t23 * t25;
  t27 = sqrt(t4);
  t28 = rho[0] * rho[0];
  t29 = t28 * rho[0];
  t30 = 0.1e1 / t29;
  t31 = sigma[0] * t30;
  t33 = 0.1e1 + 0.2105e-2 * t31;
  t36 = 0.1e1 + 0.119e-3 * t31;
  t37 = 0.1e1 / t36;
  t38 = t27 * t33 * t37;
  t41 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t26 * t38);
  t42 = rho[1] <= p->dens_threshold;
  t43 = -t14;
  t45 = my_piecewise5(t12, t9, t8, t13, t43 * t5);
  t46 = 0.1e1 + t45;
  t47 = t46 <= p->zeta_threshold;
  t48 = sqrt(t46);
  t49 = t48 * t46;
  t50 = my_piecewise3(t47, t20, t49);
  t52 = t3 * t50 * t25;
  t53 = rho[1] * rho[1];
  t54 = t53 * rho[1];
  t55 = 0.1e1 / t54;
  t56 = sigma[2] * t55;
  t58 = 0.1e1 + 0.2105e-2 * t56;
  t61 = 0.1e1 + 0.119e-3 * t56;
  t62 = 0.1e1 / t61;
  t63 = t27 * t58 * t62;
  t66 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t52 * t63);
  tzk0 = t41 + t66;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t67 = t4 * t4;
  t68 = 0.1e1 / t67;
  t69 = t14 * t68;
  t71 = my_piecewise5(t8, 0, t12, 0, t5 - t69);
  t74 = my_piecewise3(t18, 0, 0.3e1 / 0.2e1 * t21 * t71);
  t76 = t3 * t74 * t25;
  t79 = 0.1e1 / t27;
  t81 = t79 * t33 * t37;
  t83 = t26 * t81 / 0.3e1;
  t84 = t23 * t25;
  t85 = t84 * t27;
  t86 = t28 * t28;
  t87 = 0.1e1 / t86;
  t88 = sigma[0] * t87;
  t89 = t88 * t37;
  t92 = t36 * t36;
  t93 = 0.1e1 / t92;
  t94 = t33 * t93;
  t95 = t94 * t88;
  t99 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t76 * t38 - t83 + 0.23752381467360539681e-2 * t85 * t89 - 0.13427712088436599629e-3 * t85 * t95);
  t100 = t43 * t68;
  t102 = my_piecewise5(t12, 0, t8, 0, -t5 - t100);
  t105 = my_piecewise3(t47, 0, 0.3e1 / 0.2e1 * t48 * t102);
  t107 = t3 * t105 * t25;
  t111 = t79 * t58 * t62;
  t113 = t52 * t111 / 0.3e1;
  t115 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t107 * t63 - t113);
  tvrho0 = t41 + t66 + t4 * (t99 + t115);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t119 = my_piecewise5(t8, 0, t12, 0, -t5 - t69);
  t122 = my_piecewise3(t18, 0, 0.3e1 / 0.2e1 * t21 * t119);
  t124 = t3 * t122 * t25;
  t128 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t124 * t38 - t83);
  t130 = my_piecewise5(t12, 0, t8, 0, t5 - t100);
  t133 = my_piecewise3(t47, 0, 0.3e1 / 0.2e1 * t48 * t130);
  t135 = t3 * t133 * t25;
  t138 = t50 * t25;
  t139 = t138 * t27;
  t140 = t53 * t53;
  t141 = 0.1e1 / t140;
  t142 = sigma[2] * t141;
  t143 = t142 * t62;
  t146 = t61 * t61;
  t147 = 0.1e1 / t146;
  t148 = t58 * t147;
  t149 = t148 * t142;
  t153 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t135 * t63 - t113 + 0.23752381467360539681e-2 * t139 * t143 - 0.13427712088436599629e-3 * t139 * t149);
  tvrho1 = t41 + t66 + t4 * (t128 + t153);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t157 = t27 * t30 * t37;
  t160 = t94 * t30;
  t164 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t84 * t157 + 0.44759040294788665431e-4 * t85 * t160);
  tvsigma0 = t4 * t164;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t166 = t27 * t55 * t62;
  t169 = t148 * t55;
  t173 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t138 * t166 + 0.44759040294788665431e-4 * t139 * t169);
  tvsigma2 = t4 * t173;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t176 = 0.1e1 / t21;
  t177 = t71 * t71;
  t180 = t67 * t4;
  t181 = 0.1e1 / t180;
  t182 = t14 * t181;
  t185 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t68 + 0.2e1 * t182);
  t189 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t176 * t177 + 0.3e1 / 0.2e1 * t21 * t185);
  t191 = t3 * t189 * t25;
  t194 = t76 * t81;
  t196 = t74 * t25;
  t197 = t196 * t27;
  t203 = 0.1e1 / t27 / t4;
  t205 = t203 * t33 * t37;
  t207 = t26 * t205 / 0.6e1;
  t208 = t84 * t79;
  t209 = t208 * t89;
  t211 = t208 * t95;
  t213 = t86 * rho[0];
  t214 = 0.1e1 / t213;
  t215 = sigma[0] * t214;
  t216 = t215 * t37;
  t219 = sigma[0] * sigma[0];
  t220 = t86 * t86;
  t221 = 0.1e1 / t220;
  t222 = t219 * t221;
  t223 = t222 * t93;
  t227 = 0.1e1 / t92 / t36;
  t228 = t33 * t227;
  t229 = t228 * t222;
  t232 = t94 * t215;
  t235 = -0.2e1 / 0.3e1 * t191 * t38 - 0.2e1 / 0.3e1 * t194 + 0.47504762934721079362e-2 * t197 * t89 - 0.26855424176873199258e-3 * t197 * t95 + t207 + 0.2375238146736053968e-2 * t209 - 0.13427712088436599629e-3 * t211 - 0.95009525869442158724e-2 * t85 * t216 + 0.16959200367695425332e-5 * t85 * t223 - 0.95873864311437321351e-7 * t85 * t229 + 0.53710848353746398516e-3 * t85 * t232;
  t236 = my_piecewise3(t1, 0, t235);
  t237 = 0.1e1 / t48;
  t238 = t102 * t102;
  t241 = t43 * t181;
  t244 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t68 + 0.2e1 * t241);
  t248 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t237 * t238 + 0.3e1 / 0.2e1 * t48 * t244);
  t250 = t3 * t248 * t25;
  t253 = t107 * t111;
  t256 = t203 * t58 * t62;
  t258 = t52 * t256 / 0.6e1;
  t260 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t250 * t63 - 0.2e1 / 0.3e1 * t253 + t258);
  tv2rho20 = 0.2e1 * t99 + 0.2e1 * t115 + t4 * (t236 + t260);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = t176 * t119;
  t267 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t182);
  t271 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t263 * t71 + 0.3e1 / 0.2e1 * t21 * t267);
  t273 = t3 * t271 * t25;
  t276 = t124 * t81;
  t278 = t122 * t25;
  t279 = t278 * t27;
  t288 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t273 * t38 - t276 / 0.3e1 + 0.23752381467360539681e-2 * t279 * t89 - 0.13427712088436599629e-3 * t279 * t95 - t194 / 0.3e1 + t207 + 0.1187619073368026984e-2 * t209 - 0.67138560442182998147e-4 * t211);
  t289 = t237 * t130;
  t293 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t241);
  t297 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t289 * t102 + 0.3e1 / 0.2e1 * t48 * t293);
  t299 = t3 * t297 * t25;
  t302 = t135 * t111;
  t305 = t105 * t25;
  t306 = t305 * t27;
  t309 = t138 * t79;
  t310 = t309 * t143;
  t314 = t309 * t149;
  t317 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t299 * t63 - t302 / 0.3e1 - t253 / 0.3e1 + t258 + 0.23752381467360539681e-2 * t306 * t143 + 0.1187619073368026984e-2 * t310 - 0.13427712088436599629e-3 * t306 * t149 - 0.67138560442182998145e-4 * t314);
  tv2rho21 = t99 + t115 + t128 + t153 + t4 * (t288 + t317);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t322 = t119 * t119;
  t327 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t68 + 0.2e1 * t182);
  t331 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t176 * t322 + 0.3e1 / 0.2e1 * t21 * t327);
  t333 = t3 * t331 * t25;
  t338 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t333 * t38 - 0.2e1 / 0.3e1 * t276 + t207);
  t339 = t130 * t130;
  t344 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t68 + 0.2e1 * t241);
  t348 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t237 * t339 + 0.3e1 / 0.2e1 * t48 * t344);
  t350 = t3 * t348 * t25;
  t354 = t133 * t25;
  t355 = t354 * t27;
  t362 = t140 * rho[1];
  t363 = 0.1e1 / t362;
  t364 = sigma[2] * t363;
  t365 = t364 * t62;
  t368 = sigma[2] * sigma[2];
  t369 = t140 * t140;
  t370 = 0.1e1 / t369;
  t371 = t368 * t370;
  t372 = t371 * t147;
  t376 = 0.1e1 / t146 / t61;
  t377 = t58 * t376;
  t378 = t377 * t371;
  t381 = t148 * t364;
  t384 = -0.2e1 / 0.3e1 * t350 * t63 - 0.2e1 / 0.3e1 * t302 + 0.47504762934721079362e-2 * t355 * t143 - 0.26855424176873199258e-3 * t355 * t149 + t258 + 0.2375238146736053968e-2 * t310 - 0.13427712088436599629e-3 * t314 - 0.95009525869442158724e-2 * t139 * t365 + 0.16959200367695425332e-5 * t139 * t372 - 0.95873864311437321351e-7 * t139 * t378 + 0.53710848353746398516e-3 * t139 * t381;
  t385 = my_piecewise3(t42, 0, t384);
  tv2rho22 = 0.2e1 * t128 + 0.2e1 * t153 + t4 * (t338 + t385);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t391 = t79 * t30 * t37;
  t393 = 0.39587302445600899466e-3 * t84 * t391;
  t395 = t27 * t87 * t37;
  t398 = t86 * t29;
  t399 = 0.1e1 / t398;
  t401 = t399 * t93 * sigma[0];
  t407 = 0.22379520147394332716e-4 * t208 * t160;
  t408 = t399 * sigma[0];
  t409 = t228 * t408;
  t412 = t94 * t87;
  t416 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t196 * t157 - t393 + 0.2375238146736053968e-2 * t84 * t395 - 0.56530667892318084439e-6 * t85 * t401 + 0.44759040294788665431e-4 * t197 * t160 + t407 + 0.31957954770479107118e-7 * t85 * t409 - 0.13427712088436599629e-3 * t85 * t412);
  tv2rhosigma0 = t4 * t416 + t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t421 = t79 * t55 * t62;
  t423 = 0.39587302445600899466e-3 * t138 * t421;
  t427 = 0.22379520147394332716e-4 * t309 * t169;
  t429 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t305 * t166 - t423 + 0.44759040294788665431e-4 * t306 * t169 + t427);
  tv2rhosigma2 = t4 * t429 + t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t436 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t278 * t157 - t393 + 0.44759040294788665431e-4 * t279 * t160 + t407);
  tv2rhosigma3 = t4 * t436 + t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t441 = t27 * t141 * t62;
  t444 = t140 * t54;
  t445 = 0.1e1 / t444;
  t447 = t445 * t147 * sigma[2];
  t452 = t445 * sigma[2];
  t453 = t377 * t452;
  t456 = t148 * t141;
  t460 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t354 * t166 - t423 + 0.2375238146736053968e-2 * t138 * t441 - 0.56530667892318084439e-6 * t139 * t447 + 0.44759040294788665431e-4 * t355 * t169 + t427 + 0.31957954770479107118e-7 * t139 * t453 - 0.13427712088436599629e-3 * t139 * t456);
  tv2rhosigma5 = t4 * t460 + t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t462 = t86 * t28;
  t463 = 0.1e1 / t462;
  t464 = t27 * t463;
  t465 = t464 * t93;
  t468 = t228 * t463;
  t472 = my_piecewise3(t1, 0, 0.18843555964106028146e-6 * t84 * t465 - 0.10652651590159702373e-7 * t85 * t468);
  tv2sigma20 = t4 * t472;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t473 = t140 * t53;
  t474 = 0.1e1 / t473;
  t475 = t27 * t474;
  t476 = t475 * t147;
  t479 = t377 * t474;
  t483 = my_piecewise3(t42, 0, 0.18843555964106028146e-6 * t138 * t476 - 0.10652651590159702373e-7 * t139 * t479);
  tv2sigma25 = t4 * t483;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t12;
  double t13, t14, t16, t17, t18, t19, t20, t21;
  double t22, t23, t25, t26, t27, t28, t29, t30;
  double t31, t33, t36, t37, t38, t41, t42, t43;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t54, t55, t56, t58, t61, t62, t63, t66;
  double tzk0;

  double t67, t68, t69, t71, t74, t76, t79, t81;
  double t83, t84, t85, t86, t87, t88, t89, t92;
  double t93, t94, t95, t99, t100, t102, t105, t107;
  double t111, t113, t115, tvrho0, t119, t122, t124, t128;
  double t130, t133, t135, t138, t139, t140, t141, t142;
  double t143, t146, t147, t148, t149, t153, tvrho1, t157;
  double t160, t164, tvsigma0, tvsigma1, t166, t169, t173, tvsigma2;

  double t176, t177, t180, t181, t182, t185, t189, t191;
  double t194, t196, t197, t203, t205, t207, t208, t209;
  double t211, t213, t214, t215, t216, t219, t220, t221;
  double t222, t223, t227, t228, t229, t232, t235, t236;
  double t237, t238, t241, t244, t248, t250, t253, t256;
  double t258, t260, tv2rho20, t263, t267, t271, t273, t276;
  double t278, t279, t288, t289, t293, t297, t299, t302;
  double t305, t306, t309, t310, t314, t317, tv2rho21, t322;
  double t327, t331, t333, t338, t339, t344, t348, t350;
  double t354, t355, t362, t363, t364, t365, t368, t369;
  double t370, t371, t372, t376, t377, t378, t381, t384;
  double t385, tv2rho22, t391, t393, t395, t398, t399, t401;
  double t407, t408, t409, t412, t416, tv2rhosigma0, tv2rhosigma1, t421;
  double t423, t427, t429, tv2rhosigma2, t436, tv2rhosigma3, tv2rhosigma4, t441;
  double t444, t445, t447, t452, t453, t456, t460, tv2rhosigma5;
  double t462, t463, t464, t465, t468, t472, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t473, t474, t475, t476, t479;
  double t483, tv2sigma25;

  double t489, t491, t493, t494, t495, t497, t499, t501;
  double t502, t505, t506, t507, t508, t510, t511, t512;
  double t515, t516, t517, t520, t522, t523, t527, t528;
  double t531, t532, t533, t536, t539, t540, t543, t546;
  double t547, t548, t551, t555, t557, t562, t566, t570;
  double t572, t575, t578, t580, t581, t582, t585, t588;
  double t591, t595, t597, t600, t601, t604, t606, t608;
  double tv3rho30, t611, t612, t614, t615, t616, t619, t621;
  double t623, t632, t635, t638, t643, t644, t646, t650;
  double t652, t657, t667, t669, t670, t673, t678, t680;
  double t684, t686, t690, t691, t695, t696, t699, t701;
  double t702, t703, t708, t709, t711, t712, tv3rho31, t715;
  double t720, t724, t728, t730, t733, t735, t736, t746;
  double t747, t748, t753, t757, t761, t763, t766, t769;
  double t770, t773, t774, t778, t781, t786, t790, t794;
  double t798, t800, t802, tv3rho32, t807, t814, t818, t820;
  double t825, t826, t827, t833, t834, t835, t838, t840;
  double t841, t842, t845, t852, t856, t858, t861, t864;
  double t865, t873, t876, t877, t878, t879, t880, t895;
  double t897, tv3rho33, t903, t910, t912, t914, t915, t917;
  double t920, t924, t928, t929, t930, t934, t940, t941;
  double t943, t946, t949, t952, t958, t959, tv3rho2sigma0, tv3rho2sigma1;
  double t964, t967, t969, t972, t975, t977, tv3rho2sigma2, t981;
  double t992, t1001, t1002, tv3rho2sigma3, tv3rho2sigma4, t1006, t1012, t1013;
  double t1017, t1021, t1026, t1030, t1032, t1033, tv3rho2sigma5, t1043;
  double tv3rho2sigma6, tv3rho2sigma7, t1051, t1053, t1056, t1067, t1071, t1074;
  double t1075, t1083, t1089, t1090, tv3rho2sigma8, t1095, t1097, t1099;
  double t1103, t1105, t1111, t1113, t1116, t1120, tv3rhosigma20, tv3rhosigma21;
  double tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1125, t1127, t1131, t1133, tv3rhosigma25;
  double t1140, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1145, t1149;
  double t1151, t1157, t1160, t1164, tv3rhosigma211, t1167, t1170, t1174;
  double tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37;
  double tv3sigma38, t1176, t1179, t1183, tv3sigma39;


  t1 = rho[0] <= p->dens_threshold;
  t2 = sqrt(M_PI);
  t3 = 0.1e1 / t2;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 <= p->zeta_threshold;
  t19 = sqrt(p->zeta_threshold);
  t20 = t19 * p->zeta_threshold;
  t21 = sqrt(t17);
  t22 = t21 * t17;
  t23 = my_piecewise3(t18, t20, t22);
  t25 = M_SQRT2;
  t26 = t3 * t23 * t25;
  t27 = sqrt(t4);
  t28 = rho[0] * rho[0];
  t29 = t28 * rho[0];
  t30 = 0.1e1 / t29;
  t31 = sigma[0] * t30;
  t33 = 0.1e1 + 0.2105e-2 * t31;
  t36 = 0.1e1 + 0.119e-3 * t31;
  t37 = 0.1e1 / t36;
  t38 = t27 * t33 * t37;
  t41 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t26 * t38);
  t42 = rho[1] <= p->dens_threshold;
  t43 = -t14;
  t45 = my_piecewise5(t12, t9, t8, t13, t43 * t5);
  t46 = 0.1e1 + t45;
  t47 = t46 <= p->zeta_threshold;
  t48 = sqrt(t46);
  t49 = t48 * t46;
  t50 = my_piecewise3(t47, t20, t49);
  t52 = t3 * t50 * t25;
  t53 = rho[1] * rho[1];
  t54 = t53 * rho[1];
  t55 = 0.1e1 / t54;
  t56 = sigma[2] * t55;
  t58 = 0.1e1 + 0.2105e-2 * t56;
  t61 = 0.1e1 + 0.119e-3 * t56;
  t62 = 0.1e1 / t61;
  t63 = t27 * t58 * t62;
  t66 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t52 * t63);
  tzk0 = t41 + t66;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t67 = t4 * t4;
  t68 = 0.1e1 / t67;
  t69 = t14 * t68;
  t71 = my_piecewise5(t8, 0, t12, 0, t5 - t69);
  t74 = my_piecewise3(t18, 0, 0.3e1 / 0.2e1 * t21 * t71);
  t76 = t3 * t74 * t25;
  t79 = 0.1e1 / t27;
  t81 = t79 * t33 * t37;
  t83 = t26 * t81 / 0.3e1;
  t84 = t23 * t25;
  t85 = t84 * t27;
  t86 = t28 * t28;
  t87 = 0.1e1 / t86;
  t88 = sigma[0] * t87;
  t89 = t88 * t37;
  t92 = t36 * t36;
  t93 = 0.1e1 / t92;
  t94 = t33 * t93;
  t95 = t94 * t88;
  t99 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t76 * t38 - t83 + 0.23752381467360539681e-2 * t85 * t89 - 0.13427712088436599629e-3 * t85 * t95);
  t100 = t43 * t68;
  t102 = my_piecewise5(t12, 0, t8, 0, -t5 - t100);
  t105 = my_piecewise3(t47, 0, 0.3e1 / 0.2e1 * t48 * t102);
  t107 = t3 * t105 * t25;
  t111 = t79 * t58 * t62;
  t113 = t52 * t111 / 0.3e1;
  t115 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t107 * t63 - t113);
  tvrho0 = t41 + t66 + t4 * (t99 + t115);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t119 = my_piecewise5(t8, 0, t12, 0, -t5 - t69);
  t122 = my_piecewise3(t18, 0, 0.3e1 / 0.2e1 * t21 * t119);
  t124 = t3 * t122 * t25;
  t128 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t124 * t38 - t83);
  t130 = my_piecewise5(t12, 0, t8, 0, t5 - t100);
  t133 = my_piecewise3(t47, 0, 0.3e1 / 0.2e1 * t48 * t130);
  t135 = t3 * t133 * t25;
  t138 = t50 * t25;
  t139 = t138 * t27;
  t140 = t53 * t53;
  t141 = 0.1e1 / t140;
  t142 = sigma[2] * t141;
  t143 = t142 * t62;
  t146 = t61 * t61;
  t147 = 0.1e1 / t146;
  t148 = t58 * t147;
  t149 = t148 * t142;
  t153 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t135 * t63 - t113 + 0.23752381467360539681e-2 * t139 * t143 - 0.13427712088436599629e-3 * t139 * t149);
  tvrho1 = t41 + t66 + t4 * (t128 + t153);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t157 = t27 * t30 * t37;
  t160 = t94 * t30;
  t164 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t84 * t157 + 0.44759040294788665431e-4 * t85 * t160);
  tvsigma0 = t4 * t164;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t166 = t27 * t55 * t62;
  t169 = t148 * t55;
  t173 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t138 * t166 + 0.44759040294788665431e-4 * t139 * t169);
  tvsigma2 = t4 * t173;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t176 = 0.1e1 / t21;
  t177 = t71 * t71;
  t180 = t67 * t4;
  t181 = 0.1e1 / t180;
  t182 = t14 * t181;
  t185 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t68 + 0.2e1 * t182);
  t189 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t176 * t177 + 0.3e1 / 0.2e1 * t21 * t185);
  t191 = t3 * t189 * t25;
  t194 = t76 * t81;
  t196 = t74 * t25;
  t197 = t196 * t27;
  t203 = 0.1e1 / t27 / t4;
  t205 = t203 * t33 * t37;
  t207 = t26 * t205 / 0.6e1;
  t208 = t84 * t79;
  t209 = t208 * t89;
  t211 = t208 * t95;
  t213 = t86 * rho[0];
  t214 = 0.1e1 / t213;
  t215 = sigma[0] * t214;
  t216 = t215 * t37;
  t219 = sigma[0] * sigma[0];
  t220 = t86 * t86;
  t221 = 0.1e1 / t220;
  t222 = t219 * t221;
  t223 = t222 * t93;
  t227 = 0.1e1 / t92 / t36;
  t228 = t33 * t227;
  t229 = t228 * t222;
  t232 = t94 * t215;
  t235 = -0.2e1 / 0.3e1 * t191 * t38 - 0.2e1 / 0.3e1 * t194 + 0.47504762934721079362e-2 * t197 * t89 - 0.26855424176873199258e-3 * t197 * t95 + t207 + 0.2375238146736053968e-2 * t209 - 0.13427712088436599629e-3 * t211 - 0.95009525869442158724e-2 * t85 * t216 + 0.16959200367695425332e-5 * t85 * t223 - 0.95873864311437321351e-7 * t85 * t229 + 0.53710848353746398516e-3 * t85 * t232;
  t236 = my_piecewise3(t1, 0, t235);
  t237 = 0.1e1 / t48;
  t238 = t102 * t102;
  t241 = t43 * t181;
  t244 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t68 + 0.2e1 * t241);
  t248 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t237 * t238 + 0.3e1 / 0.2e1 * t48 * t244);
  t250 = t3 * t248 * t25;
  t253 = t107 * t111;
  t256 = t203 * t58 * t62;
  t258 = t52 * t256 / 0.6e1;
  t260 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t250 * t63 - 0.2e1 / 0.3e1 * t253 + t258);
  tv2rho20 = 0.2e1 * t99 + 0.2e1 * t115 + t4 * (t236 + t260);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = t176 * t119;
  t267 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t182);
  t271 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t263 * t71 + 0.3e1 / 0.2e1 * t21 * t267);
  t273 = t3 * t271 * t25;
  t276 = t124 * t81;
  t278 = t122 * t25;
  t279 = t278 * t27;
  t288 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t273 * t38 - t276 / 0.3e1 + 0.23752381467360539681e-2 * t279 * t89 - 0.13427712088436599629e-3 * t279 * t95 - t194 / 0.3e1 + t207 + 0.1187619073368026984e-2 * t209 - 0.67138560442182998147e-4 * t211);
  t289 = t237 * t130;
  t293 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t241);
  t297 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t289 * t102 + 0.3e1 / 0.2e1 * t48 * t293);
  t299 = t3 * t297 * t25;
  t302 = t135 * t111;
  t305 = t105 * t25;
  t306 = t305 * t27;
  t309 = t138 * t79;
  t310 = t309 * t143;
  t314 = t309 * t149;
  t317 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t299 * t63 - t302 / 0.3e1 - t253 / 0.3e1 + t258 + 0.23752381467360539681e-2 * t306 * t143 + 0.1187619073368026984e-2 * t310 - 0.13427712088436599629e-3 * t306 * t149 - 0.67138560442182998145e-4 * t314);
  tv2rho21 = t99 + t115 + t128 + t153 + t4 * (t288 + t317);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t322 = t119 * t119;
  t327 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t68 + 0.2e1 * t182);
  t331 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t176 * t322 + 0.3e1 / 0.2e1 * t21 * t327);
  t333 = t3 * t331 * t25;
  t338 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t333 * t38 - 0.2e1 / 0.3e1 * t276 + t207);
  t339 = t130 * t130;
  t344 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t68 + 0.2e1 * t241);
  t348 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t237 * t339 + 0.3e1 / 0.2e1 * t48 * t344);
  t350 = t3 * t348 * t25;
  t354 = t133 * t25;
  t355 = t354 * t27;
  t362 = t140 * rho[1];
  t363 = 0.1e1 / t362;
  t364 = sigma[2] * t363;
  t365 = t364 * t62;
  t368 = sigma[2] * sigma[2];
  t369 = t140 * t140;
  t370 = 0.1e1 / t369;
  t371 = t368 * t370;
  t372 = t371 * t147;
  t376 = 0.1e1 / t146 / t61;
  t377 = t58 * t376;
  t378 = t377 * t371;
  t381 = t148 * t364;
  t384 = -0.2e1 / 0.3e1 * t350 * t63 - 0.2e1 / 0.3e1 * t302 + 0.47504762934721079362e-2 * t355 * t143 - 0.26855424176873199258e-3 * t355 * t149 + t258 + 0.2375238146736053968e-2 * t310 - 0.13427712088436599629e-3 * t314 - 0.95009525869442158724e-2 * t139 * t365 + 0.16959200367695425332e-5 * t139 * t372 - 0.95873864311437321351e-7 * t139 * t378 + 0.53710848353746398516e-3 * t139 * t381;
  t385 = my_piecewise3(t42, 0, t384);
  tv2rho22 = 0.2e1 * t128 + 0.2e1 * t153 + t4 * (t338 + t385);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t391 = t79 * t30 * t37;
  t393 = 0.39587302445600899466e-3 * t84 * t391;
  t395 = t27 * t87 * t37;
  t398 = t86 * t29;
  t399 = 0.1e1 / t398;
  t401 = t399 * t93 * sigma[0];
  t407 = 0.22379520147394332716e-4 * t208 * t160;
  t408 = t399 * sigma[0];
  t409 = t228 * t408;
  t412 = t94 * t87;
  t416 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t196 * t157 - t393 + 0.2375238146736053968e-2 * t84 * t395 - 0.56530667892318084439e-6 * t85 * t401 + 0.44759040294788665431e-4 * t197 * t160 + t407 + 0.31957954770479107118e-7 * t85 * t409 - 0.13427712088436599629e-3 * t85 * t412);
  tv2rhosigma0 = t4 * t416 + t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t421 = t79 * t55 * t62;
  t423 = 0.39587302445600899466e-3 * t138 * t421;
  t427 = 0.22379520147394332716e-4 * t309 * t169;
  t429 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t305 * t166 - t423 + 0.44759040294788665431e-4 * t306 * t169 + t427);
  tv2rhosigma2 = t4 * t429 + t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t436 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t278 * t157 - t393 + 0.44759040294788665431e-4 * t279 * t160 + t407);
  tv2rhosigma3 = t4 * t436 + t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t441 = t27 * t141 * t62;
  t444 = t140 * t54;
  t445 = 0.1e1 / t444;
  t447 = t445 * t147 * sigma[2];
  t452 = t445 * sigma[2];
  t453 = t377 * t452;
  t456 = t148 * t141;
  t460 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t354 * t166 - t423 + 0.2375238146736053968e-2 * t138 * t441 - 0.56530667892318084439e-6 * t139 * t447 + 0.44759040294788665431e-4 * t355 * t169 + t427 + 0.31957954770479107118e-7 * t139 * t453 - 0.13427712088436599629e-3 * t139 * t456);
  tv2rhosigma5 = t4 * t460 + t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t462 = t86 * t28;
  t463 = 0.1e1 / t462;
  t464 = t27 * t463;
  t465 = t464 * t93;
  t468 = t228 * t463;
  t472 = my_piecewise3(t1, 0, 0.18843555964106028146e-6 * t84 * t465 - 0.10652651590159702373e-7 * t85 * t468);
  tv2sigma20 = t4 * t472;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t473 = t140 * t53;
  t474 = 0.1e1 / t473;
  t475 = t27 * t474;
  t476 = t475 * t147;
  t479 = t377 * t474;
  t483 = my_piecewise3(t42, 0, 0.18843555964106028146e-6 * t138 * t476 - 0.10652651590159702373e-7 * t139 * t479);
  tv2sigma25 = t4 * t483;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t489 = 0.1e1 / t27 / t67;
  t491 = t489 * t33 * t37;
  t493 = t26 * t491 / 0.4e1;
  t494 = t84 * t203;
  t495 = t494 * t95;
  t497 = t208 * t216;
  t499 = t208 * t229;
  t501 = sigma[0] * t463;
  t502 = t501 * t37;
  t505 = t92 * t92;
  t506 = 0.1e1 / t505;
  t507 = t33 * t506;
  t508 = t219 * sigma[0];
  t510 = 0.1e1 / t220 / t86;
  t511 = t508 * t510;
  t512 = t507 * t511;
  t515 = t191 * t81;
  t516 = t189 * t25;
  t517 = t516 * t27;
  t520 = t76 * t205;
  t522 = t196 * t79;
  t523 = t522 * t95;
  t527 = -0.28762159293431196405e-6 * t197 * t229 - t493 + 0.10070784066327449722e-3 * t495 - 0.14251428880416323808e-1 * t497 - 0.14381079646715598203e-6 * t499 + 0.47504762934721079362e-1 * t85 * t502 - 0.10268090867754937117e-9 * t85 * t512 - t515 - 0.40283136265309798887e-3 * t517 * t95 + t520 / 0.2e1 - 0.40283136265309798887e-3 * t523 - 0.28502857760832647617e-1 * t197 * t216;
  t528 = t208 * t223;
  t531 = 0.1e1 / t220 / rho[0];
  t532 = t219 * t531;
  t533 = t532 * t93;
  t536 = t511 * t227;
  t539 = 0.1e1 / t22;
  t540 = t177 * t71;
  t543 = t176 * t71;
  t546 = t67 * t67;
  t547 = 0.1e1 / t546;
  t548 = t14 * t547;
  t551 = my_piecewise5(t8, 0, t12, 0, 0.6e1 * t181 - 0.6e1 * t548);
  t555 = my_piecewise3(t18, 0, -0.3e1 / 0.8e1 * t539 * t540 + 0.9e1 / 0.4e1 * t543 * t185 + 0.3e1 / 0.2e1 * t21 * t551);
  t557 = t3 * t555 * t25;
  t562 = t522 * t89;
  t566 = t494 * t89;
  t570 = t208 * t232;
  t572 = t228 * t532;
  t575 = t94 * t501;
  t578 = 0.25438800551543137998e-5 * t528 - 0.20351040441234510398e-4 * t85 * t533 + 0.1816330359380180053e-8 * t85 * t536 - 0.2e1 / 0.3e1 * t557 * t38 + 0.71257144402081619043e-2 * t517 * t89 + 0.71257144402081619042e-2 * t562 + 0.50877601103086275995e-5 * t197 * t223 - 0.1781428610052040476e-2 * t566 + 0.16113254506123919555e-2 * t197 * t232 + 0.80566272530619597774e-3 * t570 + 0.11504863717372478562e-5 * t85 * t572 - 0.26855424176873199258e-2 * t85 * t575;
  t580 = my_piecewise3(t1, 0, t527 + t578);
  t581 = 0.1e1 / t49;
  t582 = t238 * t102;
  t585 = t237 * t102;
  t588 = t43 * t547;
  t591 = my_piecewise5(t12, 0, t8, 0, -0.6e1 * t181 - 0.6e1 * t588);
  t595 = my_piecewise3(t47, 0, -0.3e1 / 0.8e1 * t581 * t582 + 0.9e1 / 0.4e1 * t585 * t244 + 0.3e1 / 0.2e1 * t48 * t591);
  t597 = t3 * t595 * t25;
  t600 = t250 * t111;
  t601 = t107 * t256;
  t604 = t489 * t58 * t62;
  t606 = t52 * t604 / 0.4e1;
  t608 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t597 * t63 - t600 + t601 / 0.2e1 - t606);
  tv3rho30 = 0.3e1 * t236 + 0.3e1 * t260 + t4 * (t580 + t608);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t611 = 0.2e1 * t288;
  t612 = 0.2e1 * t317;
  t614 = 0.2e1 / 0.3e1 * t273 * t81;
  t615 = t271 * t25;
  t616 = t615 * t27;
  t619 = t124 * t205;
  t621 = t278 * t79;
  t623 = 0.13427712088436599629e-3 * t621 * t95;
  t632 = -t614 - 0.26855424176873199258e-3 * t616 * t95 + t619 / 0.6e1 - t623 - 0.95009525869442158724e-2 * t279 * t216 - 0.95873864311437321351e-7 * t279 * t229 - t493 + 0.67138560442182998147e-4 * t495 - 0.4750476293472107936e-2 * t497 - 0.47936932155718660677e-7 * t499 - t515 / 0.3e1;
  t635 = t539 * t119;
  t638 = t176 * t267;
  t643 = 0.2e1 * t181;
  t644 = 0.6e1 * t548;
  t646 = my_piecewise5(t8, 0, t12, 0, t643 - t644);
  t650 = my_piecewise3(t18, 0, -0.3e1 / 0.8e1 * t635 * t177 + 0.3e1 / 0.2e1 * t638 * t71 + 0.3e1 / 0.4e1 * t263 * t185 + 0.3e1 / 0.2e1 * t21 * t646);
  t652 = t3 * t650 * t25;
  t657 = t621 * t89;
  t667 = t520 / 0.3e1 - 0.13427712088436599629e-3 * t523 - 0.2e1 / 0.3e1 * t652 * t38 + 0.47504762934721079362e-2 * t616 * t89 + 0.2375238146736053968e-2 * t657 + 0.16959200367695425332e-5 * t279 * t223 + 0.84796001838477126659e-6 * t528 + 0.2375238146736053968e-2 * t562 - 0.1187619073368026984e-2 * t566 + 0.26855424176873199259e-3 * t570 + 0.53710848353746398516e-3 * t279 * t232;
  t669 = my_piecewise3(t1, 0, t632 + t667);
  t670 = t581 * t130;
  t673 = t237 * t293;
  t678 = 0.6e1 * t588;
  t680 = my_piecewise5(t12, 0, t8, 0, -t643 - t678);
  t684 = my_piecewise3(t47, 0, -0.3e1 / 0.8e1 * t670 * t238 + 0.3e1 / 0.2e1 * t673 * t102 + 0.3e1 / 0.4e1 * t289 * t244 + 0.3e1 / 0.2e1 * t48 * t680);
  t686 = t3 * t684 * t25;
  t690 = 0.2e1 / 0.3e1 * t299 * t111;
  t691 = t135 * t256;
  t695 = t248 * t25;
  t696 = t695 * t27;
  t699 = t305 * t79;
  t701 = 0.2375238146736053968e-2 * t699 * t143;
  t702 = t138 * t203;
  t703 = t702 * t143;
  t708 = 0.13427712088436599629e-3 * t699 * t149;
  t709 = t702 * t149;
  t711 = -0.2e1 / 0.3e1 * t686 * t63 - t690 + t691 / 0.6e1 - t600 / 0.3e1 + t601 / 0.3e1 - t606 + 0.23752381467360539681e-2 * t696 * t143 + t701 - 0.593809536684013492e-3 * t703 - 0.13427712088436599629e-3 * t696 * t149 - t708 + 0.33569280221091499072e-4 * t709;
  t712 = my_piecewise3(t42, 0, t711);
  tv3rho31 = t236 + t260 + t611 + t612 + t4 * (t669 + t712);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t715 = t539 * t322;
  t720 = t176 * t327;
  t724 = my_piecewise5(t8, 0, t12, 0, -t643 - t644);
  t728 = my_piecewise3(t18, 0, -0.3e1 / 0.8e1 * t715 * t71 + 0.3e1 / 0.2e1 * t263 * t267 + 0.3e1 / 0.4e1 * t720 * t71 + 0.3e1 / 0.2e1 * t21 * t724);
  t730 = t3 * t728 * t25;
  t733 = t333 * t81;
  t735 = t331 * t25;
  t736 = t735 * t27;
  t746 = -0.2e1 / 0.3e1 * t730 * t38 - t733 / 0.3e1 + 0.23752381467360539681e-2 * t736 * t89 - 0.13427712088436599629e-3 * t736 * t95 - t614 + t619 / 0.3e1 + 0.23752381467360539681e-2 * t657 - t623 + t520 / 0.6e1 - t493 - 0.59380953668401349202e-3 * t566 + 0.33569280221091499073e-4 * t495;
  t747 = my_piecewise3(t1, 0, t746);
  t748 = t581 * t339;
  t753 = t237 * t344;
  t757 = my_piecewise5(t12, 0, t8, 0, t643 - t678);
  t761 = my_piecewise3(t47, 0, -0.3e1 / 0.8e1 * t748 * t102 + 0.3e1 / 0.2e1 * t289 * t293 + 0.3e1 / 0.4e1 * t753 * t102 + 0.3e1 / 0.2e1 * t48 * t757);
  t763 = t3 * t761 * t25;
  t766 = t350 * t111;
  t769 = t297 * t25;
  t770 = t769 * t27;
  t773 = t354 * t79;
  t774 = t773 * t143;
  t778 = t773 * t149;
  t781 = -0.2e1 / 0.3e1 * t763 * t63 - t766 / 0.3e1 - t690 + t691 / 0.3e1 + 0.47504762934721079362e-2 * t770 * t143 + 0.23752381467360539681e-2 * t774 - 0.26855424176873199258e-3 * t770 * t149 - 0.13427712088436599629e-3 * t778 + t601 / 0.6e1 - t606 + t701;
  t786 = t309 * t365;
  t790 = t309 * t372;
  t794 = t309 * t378;
  t798 = t309 * t381;
  t800 = -0.1187619073368026984e-2 * t703 - t708 + 0.67138560442182998145e-4 * t709 - 0.95009525869442158724e-2 * t306 * t365 - 0.47504762934721079362e-2 * t786 + 0.16959200367695425332e-5 * t306 * t372 + 0.8479600183847712666e-6 * t790 - 0.95873864311437321351e-7 * t306 * t378 - 0.47936932155718660676e-7 * t794 + 0.53710848353746398516e-3 * t306 * t381 + 0.26855424176873199258e-3 * t798;
  t802 = my_piecewise3(t42, 0, t781 + t800);
  tv3rho32 = t611 + t612 + t338 + t385 + t4 * (t747 + t802);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t807 = t322 * t119;
  t814 = my_piecewise5(t8, 0, t12, 0, -0.6e1 * t181 - 0.6e1 * t548);
  t818 = my_piecewise3(t18, 0, -0.3e1 / 0.8e1 * t539 * t807 + 0.9e1 / 0.4e1 * t263 * t327 + 0.3e1 / 0.2e1 * t21 * t814);
  t820 = t3 * t818 * t25;
  t825 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t820 * t38 - t733 + t619 / 0.2e1 - t493);
  t826 = t348 * t25;
  t827 = t826 * t27;
  t833 = 0.1e1 / t369 / rho[1];
  t834 = t368 * t833;
  t835 = t834 * t147;
  t838 = t368 * sigma[2];
  t840 = 0.1e1 / t369 / t140;
  t841 = t838 * t840;
  t842 = t841 * t376;
  t845 = t339 * t130;
  t852 = my_piecewise5(t12, 0, t8, 0, 0.6e1 * t181 - 0.6e1 * t588);
  t856 = my_piecewise3(t47, 0, -0.3e1 / 0.8e1 * t581 * t845 + 0.9e1 / 0.4e1 * t289 * t344 + 0.3e1 / 0.2e1 * t48 * t852);
  t858 = t3 * t856 * t25;
  t861 = t377 * t834;
  t864 = sigma[2] * t474;
  t865 = t148 * t864;
  t873 = t864 * t62;
  t876 = 0.71257144402081619043e-2 * t827 * t143 + 0.50877601103086275995e-5 * t355 * t372 - 0.20351040441234510398e-4 * t139 * t835 + 0.1816330359380180053e-8 * t139 * t842 - 0.2e1 / 0.3e1 * t858 * t63 + 0.11504863717372478562e-5 * t139 * t861 - 0.26855424176873199258e-2 * t139 * t865 + 0.16113254506123919555e-2 * t355 * t381 - 0.40283136265309798887e-3 * t778 - 0.14381079646715598203e-6 * t794 + 0.80566272530619597774e-3 * t798 + 0.47504762934721079362e-1 * t139 * t873;
  t877 = t146 * t146;
  t878 = 0.1e1 / t877;
  t879 = t58 * t878;
  t880 = t879 * t841;
  t895 = -0.10268090867754937117e-9 * t139 * t880 - 0.40283136265309798887e-3 * t827 * t149 - 0.28502857760832647617e-1 * t355 * t365 - 0.28762159293431196405e-6 * t355 * t378 - 0.14251428880416323808e-1 * t786 + 0.25438800551543137998e-5 * t790 - t766 + 0.71257144402081619042e-2 * t774 + t691 / 0.2e1 - 0.1781428610052040476e-2 * t703 - t606 + 0.10070784066327449722e-3 * t709;
  t897 = my_piecewise3(t42, 0, t876 + t895);
  tv3rho33 = 0.3e1 * t338 + 0.3e1 * t385 + t4 * (t825 + t897);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t903 = t196 * t391;
  t910 = t203 * t30 * t37;
  t912 = 0.19793651222800449733e-3 * t84 * t910;
  t914 = t79 * t87 * t37;
  t915 = t84 * t914;
  t917 = t208 * t401;
  t920 = t27 * t214 * t37;
  t924 = t221 * t93 * sigma[0];
  t928 = 0.1e1 / t220 / t29;
  t929 = t928 * t227;
  t930 = t929 * t219;
  t934 = t228 * t221 * sigma[0];
  t940 = 0.11189760073697166358e-4 * t494 * t160;
  t941 = t208 * t412;
  t943 = t208 * t409;
  t946 = t507 * t928 * t219;
  t949 = t94 * t214;
  t952 = t522 * t160;
  t958 = 0.44759040294788665431e-4 * t517 * t160 - 0.79174604891201798932e-3 * t903 + 0.4750476293472107936e-2 * t196 * t395 - 0.11306133578463616888e-5 * t197 * t401 + t912 + 0.2375238146736053968e-2 * t915 - 0.56530667892318084439e-6 * t917 - 0.9500952586944215872e-2 * t84 * t920 + 0.56530667892318084439e-5 * t85 * t924 - 0.60544345312672668434e-9 * t85 * t930 - 0.31957954770479107118e-6 * t85 * t934 + 0.63915909540958214236e-7 * t197 * t409 - t940 - 0.13427712088436599629e-3 * t941 + 0.31957954770479107118e-7 * t943 + 0.34226969559183123723e-10 * t85 * t946 + 0.53710848353746398516e-3 * t85 * t949 + 0.44759040294788665432e-4 * t952 - 0.26855424176873199258e-3 * t197 * t412 - 0.79174604891201798933e-3 * t516 * t157;
  t959 = my_piecewise3(t1, 0, t958);
  tv3rho2sigma0 = t4 * t959 + 0.2e1 * t416;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t964 = t305 * t421;
  t967 = t203 * t55 * t62;
  t969 = 0.19793651222800449733e-3 * t138 * t967;
  t972 = t699 * t169;
  t975 = 0.11189760073697166358e-4 * t702 * t169;
  t977 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t695 * t166 - 0.79174604891201798932e-3 * t964 + t969 + 0.44759040294788665431e-4 * t696 * t169 + 0.44759040294788665432e-4 * t972 - t975);
  tv3rho2sigma2 = t4 * t977 + 0.2e1 * t429;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t981 = t278 * t391;
  t992 = t621 * t160;
  t1001 = -0.79174604891201798933e-3 * t615 * t157 - 0.39587302445600899466e-3 * t981 + 0.2375238146736053968e-2 * t278 * t395 - 0.56530667892318084439e-6 * t279 * t401 - 0.39587302445600899466e-3 * t903 + t912 + 0.1187619073368026984e-2 * t915 - 0.28265333946159042219e-6 * t917 + 0.44759040294788665431e-4 * t616 * t160 + 0.22379520147394332716e-4 * t992 + 0.31957954770479107118e-7 * t279 * t409 - 0.13427712088436599629e-3 * t279 * t412 + 0.22379520147394332716e-4 * t952 - t940 + 0.15978977385239553559e-7 * t943 - 0.67138560442182998148e-4 * t941;
  t1002 = my_piecewise3(t1, 0, t1001);
  tv3rho2sigma3 = t4 * t1002 + t416 + t436;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1006 = t354 * t421;
  t1012 = t79 * t141 * t62;
  t1013 = t138 * t1012;
  t1017 = t309 * t447;
  t1021 = t773 * t169;
  t1026 = t309 * t453;
  t1030 = t309 * t456;
  t1032 = -0.79174604891201798933e-3 * t769 * t166 - 0.39587302445600899466e-3 * t1006 - 0.39587302445600899466e-3 * t964 + t969 + 0.2375238146736053968e-2 * t305 * t441 + 0.1187619073368026984e-2 * t1013 - 0.56530667892318084439e-6 * t306 * t447 - 0.2826533394615904222e-6 * t1017 + 0.44759040294788665431e-4 * t770 * t169 + 0.22379520147394332716e-4 * t1021 + 0.22379520147394332716e-4 * t972 - t975 + 0.31957954770479107118e-7 * t306 * t453 + 0.15978977385239553559e-7 * t1026 - 0.13427712088436599629e-3 * t306 * t456 - 0.67138560442182998145e-4 * t1030;
  t1033 = my_piecewise3(t42, 0, t1032);
  tv3rho2sigma5 = t4 * t1033 + t429 + t460;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1043 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t735 * t157 - 0.79174604891201798932e-3 * t981 + t912 + 0.44759040294788665431e-4 * t736 * t160 + 0.44759040294788665432e-4 * t992 - t940);
  tv3rho2sigma6 = t4 * t1043 + 0.2e1 * t436;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1051 = 0.1e1 / t369 / t54;
  t1053 = t879 * t1051 * t368;
  t1056 = t148 * t363;
  t1067 = t27 * t363 * t62;
  t1071 = t370 * t147 * sigma[2];
  t1074 = t1051 * t376;
  t1075 = t1074 * t368;
  t1083 = t377 * t370 * sigma[2];
  t1089 = -0.26855424176873199258e-3 * t355 * t456 + 0.63915909540958214236e-7 * t355 * t453 + 0.34226969559183123723e-10 * t139 * t1053 + 0.53710848353746398516e-3 * t139 * t1056 - 0.13427712088436599629e-3 * t1030 - 0.56530667892318084439e-6 * t1017 + 0.44759040294788665432e-4 * t1021 + 0.4750476293472107936e-2 * t354 * t441 - 0.11306133578463616888e-5 * t355 * t447 - 0.9500952586944215872e-2 * t138 * t1067 + 0.56530667892318084439e-5 * t139 * t1071 - 0.60544345312672668434e-9 * t139 * t1075 + 0.44759040294788665431e-4 * t827 * t169 - 0.79174604891201798932e-3 * t1006 + 0.2375238146736053968e-2 * t1013 + t969 - 0.31957954770479107118e-6 * t139 * t1083 + 0.31957954770479107118e-7 * t1026 - t975 - 0.79174604891201798933e-3 * t826 * t166;
  t1090 = my_piecewise3(t42, 0, t1089);
  tv3rho2sigma8 = t4 * t1090 + 0.2e1 * t460;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1095 = t79 * t463 * t93;
  t1097 = 0.9421777982053014073e-7 * t84 * t1095;
  t1099 = t27 * t399 * t93;
  t1103 = 0.1e1 / t220 / t28;
  t1105 = t1103 * t227 * sigma[0];
  t1111 = 0.53263257950798511865e-8 * t208 * t468;
  t1113 = t507 * t1103 * sigma[0];
  t1116 = t228 * t399;
  t1120 = my_piecewise3(t1, 0, 0.18843555964106028146e-6 * t196 * t465 + t1097 - 0.11306133578463616888e-5 * t84 * t1099 + 0.20181448437557556144e-9 * t85 * t1105 - 0.10652651590159702373e-7 * t197 * t468 - t1111 - 0.11408989853061041241e-10 * t85 * t1113 + 0.63915909540958214238e-7 * t85 * t1116);
  tv3rhosigma20 = t4 * t1120 + t472;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1125 = t79 * t474 * t147;
  t1127 = 0.9421777982053014073e-7 * t138 * t1125;
  t1131 = 0.53263257950798511865e-8 * t309 * t479;
  t1133 = my_piecewise3(t42, 0, 0.18843555964106028146e-6 * t305 * t476 + t1127 - 0.10652651590159702373e-7 * t306 * t479 - t1131);
  tv3rhosigma25 = t4 * t1133 + t483;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1140 = my_piecewise3(t1, 0, 0.18843555964106028146e-6 * t278 * t465 + t1097 - 0.10652651590159702373e-7 * t279 * t468 - t1111);
  tv3rhosigma26 = t4 * t1140 + t472;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1145 = t27 * t445 * t147;
  t1149 = 0.1e1 / t369 / t53;
  t1151 = t1149 * t376 * sigma[2];
  t1157 = t879 * t1149 * sigma[2];
  t1160 = t377 * t445;
  t1164 = my_piecewise3(t42, 0, 0.18843555964106028146e-6 * t354 * t476 + t1127 - 0.11306133578463616888e-5 * t138 * t1145 + 0.20181448437557556144e-9 * t139 * t1151 - 0.10652651590159702373e-7 * t355 * t479 - t1131 - 0.11408989853061041241e-10 * t139 * t1157 + 0.63915909540958214238e-7 * t139 * t1160);
  tv3rhosigma211 = t4 * t1164 + t483;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1167 = t27 * t531 * t227;
  t1170 = t507 * t531;
  t1174 = my_piecewise3(t1, 0, -0.67271494791858520482e-10 * t84 * t1167 + 0.38029966176870137472e-11 * t85 * t1170);
  tv3sigma30 = t4 * t1174;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1176 = t27 * t833 * t376;
  t1179 = t879 * t833;
  t1183 = my_piecewise3(t42, 0, -0.67271494791858520482e-10 * t138 * t1176 + 0.38029966176870137472e-11 * t139 * t1179);
  tv3sigma39 = t4 * t1183;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, xc_gga_out_params *out)
{
  double t1, t2, t3, t4, t5, t8, t9, t12;
  double t13, t14, t16, t17, t18, t19, t20, t21;
  double t22, t23, t25, t26, t27, t28, t29, t30;
  double t31, t33, t36, t37, t38, t41, t42, t43;
  double t45, t46, t47, t48, t49, t50, t52, t53;
  double t54, t55, t56, t58, t61, t62, t63, t66;
  double tzk0;

  double t67, t68, t69, t71, t74, t76, t79, t81;
  double t83, t84, t85, t86, t87, t88, t89, t92;
  double t93, t94, t95, t99, t100, t102, t105, t107;
  double t111, t113, t115, tvrho0, t119, t122, t124, t128;
  double t130, t133, t135, t138, t139, t140, t141, t142;
  double t143, t146, t147, t148, t149, t153, tvrho1, t157;
  double t160, t164, tvsigma0, tvsigma1, t166, t169, t173, tvsigma2;

  double t176, t177, t180, t181, t182, t185, t189, t191;
  double t194, t196, t197, t203, t205, t207, t208, t209;
  double t211, t213, t214, t215, t216, t219, t220, t221;
  double t222, t223, t227, t228, t229, t232, t235, t236;
  double t237, t238, t241, t244, t248, t250, t253, t256;
  double t258, t260, tv2rho20, t263, t267, t271, t273, t276;
  double t278, t279, t288, t289, t293, t297, t299, t302;
  double t305, t306, t309, t310, t314, t317, tv2rho21, t322;
  double t327, t331, t333, t338, t339, t344, t348, t350;
  double t354, t355, t362, t363, t364, t365, t368, t369;
  double t370, t371, t372, t376, t377, t378, t381, t384;
  double t385, tv2rho22, t391, t393, t395, t398, t399, t401;
  double t407, t408, t409, t412, t416, tv2rhosigma0, tv2rhosigma1, t421;
  double t423, t427, t429, tv2rhosigma2, t436, tv2rhosigma3, tv2rhosigma4, t441;
  double t444, t445, t447, t452, t453, t456, t460, tv2rhosigma5;
  double t462, t463, t464, t465, t468, t472, tv2sigma20, tv2sigma21;
  double tv2sigma22, tv2sigma23, tv2sigma24, t473, t474, t475, t476, t479;
  double t483, tv2sigma25;

  double t489, t491, t493, t494, t495, t497, t499, t501;
  double t502, t505, t506, t507, t508, t510, t511, t512;
  double t515, t516, t517, t520, t522, t523, t527, t528;
  double t531, t532, t533, t536, t539, t540, t543, t546;
  double t547, t548, t551, t555, t557, t562, t566, t570;
  double t572, t575, t578, t580, t581, t582, t585, t588;
  double t591, t595, t597, t600, t601, t604, t606, t608;
  double tv3rho30, t611, t612, t614, t615, t616, t619, t621;
  double t623, t632, t635, t638, t643, t644, t646, t650;
  double t652, t657, t667, t669, t670, t673, t678, t680;
  double t684, t686, t690, t691, t695, t696, t699, t701;
  double t702, t703, t708, t709, t711, t712, tv3rho31, t715;
  double t720, t724, t728, t730, t733, t735, t736, t746;
  double t747, t748, t753, t757, t761, t763, t766, t769;
  double t770, t773, t774, t778, t781, t786, t790, t794;
  double t798, t800, t802, tv3rho32, t807, t814, t818, t820;
  double t825, t826, t827, t833, t834, t835, t838, t840;
  double t841, t842, t845, t852, t856, t858, t861, t864;
  double t865, t873, t876, t877, t878, t879, t880, t895;
  double t897, tv3rho33, t903, t910, t912, t914, t915, t917;
  double t920, t924, t928, t929, t930, t934, t940, t941;
  double t943, t946, t949, t952, t958, t959, tv3rho2sigma0, tv3rho2sigma1;
  double t964, t967, t969, t972, t975, t977, tv3rho2sigma2, t981;
  double t992, t1001, t1002, tv3rho2sigma3, tv3rho2sigma4, t1006, t1012, t1013;
  double t1017, t1021, t1026, t1030, t1032, t1033, tv3rho2sigma5, t1043;
  double tv3rho2sigma6, tv3rho2sigma7, t1051, t1053, t1056, t1067, t1071, t1074;
  double t1075, t1083, t1089, t1090, tv3rho2sigma8, t1095, t1097, t1099;
  double t1103, t1105, t1111, t1113, t1116, t1120, tv3rhosigma20, tv3rhosigma21;
  double tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t1125, t1127, t1131, t1133, tv3rhosigma25;
  double t1140, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29, tv3rhosigma210, t1145, t1149;
  double t1151, t1157, t1160, t1164, tv3rhosigma211, t1167, t1170, t1174;
  double tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33, tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37;
  double tv3sigma38, t1176, t1179, t1183, tv3sigma39;

  double t1186, t1188, t1193, t1195, t1199, t1200, t1204, t1205;
  double t1207, t1211, t1213, t1214, t1218, t1219, t1221, t1222;
  double t1229, t1230, t1234, t1236, t1237, t1243, t1249, t1250;
  double t1253, t1257, t1262, t1263, t1268, t1269, t1270, t1272;
  double t1274, t1276, t1278, t1280, t1284, t1288, t1292, t1300;
  double t1302, t1304, t1307, t1309, t1313, t1326, t1328, t1330;
  double t1332, t1335, t1336, t1338, t1339, t1345, t1350, t1353;
  double t1357, t1362, t1364, t1365, t1369, t1371, tv4rho40, t1376;
  double t1400, t1401, t1403, t1407, t1412, t1413, t1416, t1417;
  double t1418, t1420, t1424, t1425, t1426, t1428, t1441, t1446;
  double t1447, t1448, t1449, t1455, t1456, t1457, t1465, t1466;
  double t1480, t1483, t1500, t1502, t1506, t1511, t1512, t1513;
  double t1514, t1519, t1520, t1523, t1524, t1526, t1527, t1528;
  double t1529, t1530, t1534, t1536, t1537, t1538, t1540, t1541;
  double tv4rho41, t1556, t1569, t1573, t1578, t1579, t1582, t1583;
  double t1587, t1591, t1601, t1609, t1623, t1625, t1626, t1628;
  double t1630, t1632, t1646, t1659, t1663, t1668, t1669, t1672;
  double t1673, t1675, t1676, t1678, t1680, t1686, t1695, t1697;
  double t1699, t1701, t1703, t1705, t1712, t1714, tv4rho42, t1735;
  double t1739, t1744, t1746, t1747, t1759, t1760, t1761, t1763;
  double t1765, t1766, t1768, t1770, t1772, t1774, t1776, t1777;
  double t1802, t1806, t1811, t1824, t1828, t1830, t1832, t1834;
  double t1836, t1838, t1844, t1860, t1863, tv4rho43, t1868, t1873;
  double t1880, t1884, t1891, t1899, t1903, t1904, t1912, t1913;
  double t1917, t1918, t1920, t1924, t1929, t1936, t1940, t1947;
  double t1958, t1967, t1982, t1999, t2002, tv4rho44, t2017, t2022;
  double t2024, t2032, t2038, t2040, t2042, t2045, t2046, t2048;
  double t2053, t2055, t2056, t2062, t2072, t2074, t2082, t2084;
  double t2091, t2094, t2098, t2103, t2109, t2111, tv4rho3sigma0, tv4rho3sigma1;
  double t2116, t2118, t2123, t2126, t2128, t2131, t2133, tv4rho3sigma2;
  double t2135, t2143, t2153, t2156, t2158, t2165, t2171, t2180;
  double t2183, t2194, t2195, t2197, tv4rho3sigma3, tv4rho3sigma4, t2199, t2201;
  double t2204, t2215, t2216, t2218, t2220, t2223, t2224, t2226;
  double t2232, t2233, t2238, t2239, t2243, t2245, tv4rho3sigma5, t2247;
  double t2259, t2265, t2273, t2275, tv4rho3sigma6, tv4rho3sigma7, t2277, t2279;
  double t2281, t2283, t2285, t2287, t2306, t2313, t2315, t2317;
  double t2322, t2326, t2328, t2337, t2339, tv4rho3sigma8, t2351, tv4rho3sigma9;
  double tv4rho3sigma10, t2362, t2366, t2400, t2427, t2429, tv4rho3sigma11, t2435;
  double t2436, t2438, t2441, t2449, t2453, t2462, t2465, t2467;
  double t2488, t2489, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22, tv4rho2sigma23, tv4rho2sigma24, t2494;
  double t2499, t2502, t2505, t2507, tv4rho2sigma25, t2511, t2522, t2531;
  double t2532, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29, tv4rho2sigma210, t2536, t2543;
  double t2547, t2551, t2556, t2560, t2562, t2563, tv4rho2sigma211, t2573;
  double tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216, t2582, t2618, t2619;
  double tv4rho2sigma217, t2626, t2638, t2647, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32, tv4rhosigma33;
  double tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t2654, t2658, t2660;
  double tv4rhosigma39, t2667, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313, tv4rhosigma314, tv4rhosigma315;
  double tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t2689, tv4rhosigma319, t2699, tv4sigma40, tv4sigma41;
  double tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47, tv4sigma48, tv4sigma49;
  double tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t2708, tv4sigma414;


  t1 = rho[0] <= p->dens_threshold;
  t2 = sqrt(M_PI);
  t3 = 0.1e1 / t2;
  t4 = rho[0] + rho[1];
  t5 = 0.1e1 / t4;
  t8 = 0.2e1 * rho[0] * t5 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t12 = 0.2e1 * rho[1] * t5 <= p->zeta_threshold;
  t13 = -t9;
  t14 = rho[0] - rho[1];
  t16 = my_piecewise5(t8, t9, t12, t13, t14 * t5);
  t17 = 0.1e1 + t16;
  t18 = t17 <= p->zeta_threshold;
  t19 = sqrt(p->zeta_threshold);
  t20 = t19 * p->zeta_threshold;
  t21 = sqrt(t17);
  t22 = t21 * t17;
  t23 = my_piecewise3(t18, t20, t22);
  t25 = M_SQRT2;
  t26 = t3 * t23 * t25;
  t27 = sqrt(t4);
  t28 = rho[0] * rho[0];
  t29 = t28 * rho[0];
  t30 = 0.1e1 / t29;
  t31 = sigma[0] * t30;
  t33 = 0.1e1 + 0.2105e-2 * t31;
  t36 = 0.1e1 + 0.119e-3 * t31;
  t37 = 0.1e1 / t36;
  t38 = t27 * t33 * t37;
  t41 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t26 * t38);
  t42 = rho[1] <= p->dens_threshold;
  t43 = -t14;
  t45 = my_piecewise5(t12, t9, t8, t13, t43 * t5);
  t46 = 0.1e1 + t45;
  t47 = t46 <= p->zeta_threshold;
  t48 = sqrt(t46);
  t49 = t48 * t46;
  t50 = my_piecewise3(t47, t20, t49);
  t52 = t3 * t50 * t25;
  t53 = rho[1] * rho[1];
  t54 = t53 * rho[1];
  t55 = 0.1e1 / t54;
  t56 = sigma[2] * t55;
  t58 = 0.1e1 + 0.2105e-2 * t56;
  t61 = 0.1e1 + 0.119e-3 * t56;
  t62 = 0.1e1 / t61;
  t63 = t27 * t58 * t62;
  t66 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t52 * t63);
  tzk0 = t41 + t66;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t67 = t4 * t4;
  t68 = 0.1e1 / t67;
  t69 = t14 * t68;
  t71 = my_piecewise5(t8, 0, t12, 0, t5 - t69);
  t74 = my_piecewise3(t18, 0, 0.3e1 / 0.2e1 * t21 * t71);
  t76 = t3 * t74 * t25;
  t79 = 0.1e1 / t27;
  t81 = t79 * t33 * t37;
  t83 = t26 * t81 / 0.3e1;
  t84 = t23 * t25;
  t85 = t84 * t27;
  t86 = t28 * t28;
  t87 = 0.1e1 / t86;
  t88 = sigma[0] * t87;
  t89 = t88 * t37;
  t92 = t36 * t36;
  t93 = 0.1e1 / t92;
  t94 = t33 * t93;
  t95 = t94 * t88;
  t99 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t76 * t38 - t83 + 0.23752381467360539681e-2 * t85 * t89 - 0.13427712088436599629e-3 * t85 * t95);
  t100 = t43 * t68;
  t102 = my_piecewise5(t12, 0, t8, 0, -t5 - t100);
  t105 = my_piecewise3(t47, 0, 0.3e1 / 0.2e1 * t48 * t102);
  t107 = t3 * t105 * t25;
  t111 = t79 * t58 * t62;
  t113 = t52 * t111 / 0.3e1;
  t115 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t107 * t63 - t113);
  tvrho0 = t41 + t66 + t4 * (t99 + t115);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t119 = my_piecewise5(t8, 0, t12, 0, -t5 - t69);
  t122 = my_piecewise3(t18, 0, 0.3e1 / 0.2e1 * t21 * t119);
  t124 = t3 * t122 * t25;
  t128 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t124 * t38 - t83);
  t130 = my_piecewise5(t12, 0, t8, 0, t5 - t100);
  t133 = my_piecewise3(t47, 0, 0.3e1 / 0.2e1 * t48 * t130);
  t135 = t3 * t133 * t25;
  t138 = t50 * t25;
  t139 = t138 * t27;
  t140 = t53 * t53;
  t141 = 0.1e1 / t140;
  t142 = sigma[2] * t141;
  t143 = t142 * t62;
  t146 = t61 * t61;
  t147 = 0.1e1 / t146;
  t148 = t58 * t147;
  t149 = t148 * t142;
  t153 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t135 * t63 - t113 + 0.23752381467360539681e-2 * t139 * t143 - 0.13427712088436599629e-3 * t139 * t149);
  tvrho1 = t41 + t66 + t4 * (t128 + t153);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t157 = t27 * t30 * t37;
  t160 = t94 * t30;
  t164 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t84 * t157 + 0.44759040294788665431e-4 * t85 * t160);
  tvsigma0 = t4 * t164;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t166 = t27 * t55 * t62;
  t169 = t148 * t55;
  t173 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t138 * t166 + 0.44759040294788665431e-4 * t139 * t169);
  tvsigma2 = t4 * t173;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  t176 = 0.1e1 / t21;
  t177 = t71 * t71;
  t180 = t67 * t4;
  t181 = 0.1e1 / t180;
  t182 = t14 * t181;
  t185 = my_piecewise5(t8, 0, t12, 0, -0.2e1 * t68 + 0.2e1 * t182);
  t189 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t176 * t177 + 0.3e1 / 0.2e1 * t21 * t185);
  t191 = t3 * t189 * t25;
  t194 = t76 * t81;
  t196 = t74 * t25;
  t197 = t196 * t27;
  t203 = 0.1e1 / t27 / t4;
  t205 = t203 * t33 * t37;
  t207 = t26 * t205 / 0.6e1;
  t208 = t84 * t79;
  t209 = t208 * t89;
  t211 = t208 * t95;
  t213 = t86 * rho[0];
  t214 = 0.1e1 / t213;
  t215 = sigma[0] * t214;
  t216 = t215 * t37;
  t219 = sigma[0] * sigma[0];
  t220 = t86 * t86;
  t221 = 0.1e1 / t220;
  t222 = t219 * t221;
  t223 = t222 * t93;
  t227 = 0.1e1 / t92 / t36;
  t228 = t33 * t227;
  t229 = t228 * t222;
  t232 = t94 * t215;
  t235 = -0.2e1 / 0.3e1 * t191 * t38 - 0.2e1 / 0.3e1 * t194 + 0.47504762934721079362e-2 * t197 * t89 - 0.26855424176873199258e-3 * t197 * t95 + t207 + 0.2375238146736053968e-2 * t209 - 0.13427712088436599629e-3 * t211 - 0.95009525869442158724e-2 * t85 * t216 + 0.16959200367695425332e-5 * t85 * t223 - 0.95873864311437321351e-7 * t85 * t229 + 0.53710848353746398516e-3 * t85 * t232;
  t236 = my_piecewise3(t1, 0, t235);
  t237 = 0.1e1 / t48;
  t238 = t102 * t102;
  t241 = t43 * t181;
  t244 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t68 + 0.2e1 * t241);
  t248 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t237 * t238 + 0.3e1 / 0.2e1 * t48 * t244);
  t250 = t3 * t248 * t25;
  t253 = t107 * t111;
  t256 = t203 * t58 * t62;
  t258 = t52 * t256 / 0.6e1;
  t260 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t250 * t63 - 0.2e1 / 0.3e1 * t253 + t258);
  tv2rho20 = 0.2e1 * t99 + 0.2e1 * t115 + t4 * (t236 + t260);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t263 = t176 * t119;
  t267 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t182);
  t271 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t263 * t71 + 0.3e1 / 0.2e1 * t21 * t267);
  t273 = t3 * t271 * t25;
  t276 = t124 * t81;
  t278 = t122 * t25;
  t279 = t278 * t27;
  t288 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t273 * t38 - t276 / 0.3e1 + 0.23752381467360539681e-2 * t279 * t89 - 0.13427712088436599629e-3 * t279 * t95 - t194 / 0.3e1 + t207 + 0.1187619073368026984e-2 * t209 - 0.67138560442182998147e-4 * t211);
  t289 = t237 * t130;
  t293 = my_piecewise5(t12, 0, t8, 0, 0.2e1 * t241);
  t297 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t289 * t102 + 0.3e1 / 0.2e1 * t48 * t293);
  t299 = t3 * t297 * t25;
  t302 = t135 * t111;
  t305 = t105 * t25;
  t306 = t305 * t27;
  t309 = t138 * t79;
  t310 = t309 * t143;
  t314 = t309 * t149;
  t317 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t299 * t63 - t302 / 0.3e1 - t253 / 0.3e1 + t258 + 0.23752381467360539681e-2 * t306 * t143 + 0.1187619073368026984e-2 * t310 - 0.13427712088436599629e-3 * t306 * t149 - 0.67138560442182998145e-4 * t314);
  tv2rho21 = t99 + t115 + t128 + t153 + t4 * (t288 + t317);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t322 = t119 * t119;
  t327 = my_piecewise5(t8, 0, t12, 0, 0.2e1 * t68 + 0.2e1 * t182);
  t331 = my_piecewise3(t18, 0, 0.3e1 / 0.4e1 * t176 * t322 + 0.3e1 / 0.2e1 * t21 * t327);
  t333 = t3 * t331 * t25;
  t338 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t333 * t38 - 0.2e1 / 0.3e1 * t276 + t207);
  t339 = t130 * t130;
  t344 = my_piecewise5(t12, 0, t8, 0, -0.2e1 * t68 + 0.2e1 * t241);
  t348 = my_piecewise3(t47, 0, 0.3e1 / 0.4e1 * t237 * t339 + 0.3e1 / 0.2e1 * t48 * t344);
  t350 = t3 * t348 * t25;
  t354 = t133 * t25;
  t355 = t354 * t27;
  t362 = t140 * rho[1];
  t363 = 0.1e1 / t362;
  t364 = sigma[2] * t363;
  t365 = t364 * t62;
  t368 = sigma[2] * sigma[2];
  t369 = t140 * t140;
  t370 = 0.1e1 / t369;
  t371 = t368 * t370;
  t372 = t371 * t147;
  t376 = 0.1e1 / t146 / t61;
  t377 = t58 * t376;
  t378 = t377 * t371;
  t381 = t148 * t364;
  t384 = -0.2e1 / 0.3e1 * t350 * t63 - 0.2e1 / 0.3e1 * t302 + 0.47504762934721079362e-2 * t355 * t143 - 0.26855424176873199258e-3 * t355 * t149 + t258 + 0.2375238146736053968e-2 * t310 - 0.13427712088436599629e-3 * t314 - 0.95009525869442158724e-2 * t139 * t365 + 0.16959200367695425332e-5 * t139 * t372 - 0.95873864311437321351e-7 * t139 * t378 + 0.53710848353746398516e-3 * t139 * t381;
  t385 = my_piecewise3(t42, 0, t384);
  tv2rho22 = 0.2e1 * t128 + 0.2e1 * t153 + t4 * (t338 + t385);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t391 = t79 * t30 * t37;
  t393 = 0.39587302445600899466e-3 * t84 * t391;
  t395 = t27 * t87 * t37;
  t398 = t86 * t29;
  t399 = 0.1e1 / t398;
  t401 = t399 * t93 * sigma[0];
  t407 = 0.22379520147394332716e-4 * t208 * t160;
  t408 = t399 * sigma[0];
  t409 = t228 * t408;
  t412 = t94 * t87;
  t416 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t196 * t157 - t393 + 0.2375238146736053968e-2 * t84 * t395 - 0.56530667892318084439e-6 * t85 * t401 + 0.44759040294788665431e-4 * t197 * t160 + t407 + 0.31957954770479107118e-7 * t85 * t409 - 0.13427712088436599629e-3 * t85 * t412);
  tv2rhosigma0 = t4 * t416 + t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t421 = t79 * t55 * t62;
  t423 = 0.39587302445600899466e-3 * t138 * t421;
  t427 = 0.22379520147394332716e-4 * t309 * t169;
  t429 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t305 * t166 - t423 + 0.44759040294788665431e-4 * t306 * t169 + t427);
  tv2rhosigma2 = t4 * t429 + t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t436 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t278 * t157 - t393 + 0.44759040294788665431e-4 * t279 * t160 + t407);
  tv2rhosigma3 = t4 * t436 + t164;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t441 = t27 * t141 * t62;
  t444 = t140 * t54;
  t445 = 0.1e1 / t444;
  t447 = t445 * t147 * sigma[2];
  t452 = t445 * sigma[2];
  t453 = t377 * t452;
  t456 = t148 * t141;
  t460 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t354 * t166 - t423 + 0.2375238146736053968e-2 * t138 * t441 - 0.56530667892318084439e-6 * t139 * t447 + 0.44759040294788665431e-4 * t355 * t169 + t427 + 0.31957954770479107118e-7 * t139 * t453 - 0.13427712088436599629e-3 * t139 * t456);
  tv2rhosigma5 = t4 * t460 + t173;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  t462 = t86 * t28;
  t463 = 0.1e1 / t462;
  t464 = t27 * t463;
  t465 = t464 * t93;
  t468 = t228 * t463;
  t472 = my_piecewise3(t1, 0, 0.18843555964106028146e-6 * t84 * t465 - 0.10652651590159702373e-7 * t85 * t468);
  tv2sigma20 = t4 * t472;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t473 = t140 * t53;
  t474 = 0.1e1 / t473;
  t475 = t27 * t474;
  t476 = t475 * t147;
  t479 = t377 * t474;
  t483 = my_piecewise3(t42, 0, 0.18843555964106028146e-6 * t138 * t476 - 0.10652651590159702373e-7 * t139 * t479);
  tv2sigma25 = t4 * t483;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  t489 = 0.1e1 / t27 / t67;
  t491 = t489 * t33 * t37;
  t493 = t26 * t491 / 0.4e1;
  t494 = t84 * t203;
  t495 = t494 * t95;
  t497 = t208 * t216;
  t499 = t208 * t229;
  t501 = sigma[0] * t463;
  t502 = t501 * t37;
  t505 = t92 * t92;
  t506 = 0.1e1 / t505;
  t507 = t33 * t506;
  t508 = t219 * sigma[0];
  t510 = 0.1e1 / t220 / t86;
  t511 = t508 * t510;
  t512 = t507 * t511;
  t515 = t191 * t81;
  t516 = t189 * t25;
  t517 = t516 * t27;
  t520 = t76 * t205;
  t522 = t196 * t79;
  t523 = t522 * t95;
  t527 = -0.28762159293431196405e-6 * t197 * t229 - t493 + 0.10070784066327449722e-3 * t495 - 0.14251428880416323808e-1 * t497 - 0.14381079646715598203e-6 * t499 + 0.47504762934721079362e-1 * t85 * t502 - 0.10268090867754937117e-9 * t85 * t512 - t515 - 0.40283136265309798887e-3 * t517 * t95 + t520 / 0.2e1 - 0.40283136265309798887e-3 * t523 - 0.28502857760832647617e-1 * t197 * t216;
  t528 = t208 * t223;
  t531 = 0.1e1 / t220 / rho[0];
  t532 = t219 * t531;
  t533 = t532 * t93;
  t536 = t511 * t227;
  t539 = 0.1e1 / t22;
  t540 = t177 * t71;
  t543 = t176 * t71;
  t546 = t67 * t67;
  t547 = 0.1e1 / t546;
  t548 = t14 * t547;
  t551 = my_piecewise5(t8, 0, t12, 0, 0.6e1 * t181 - 0.6e1 * t548);
  t555 = my_piecewise3(t18, 0, -0.3e1 / 0.8e1 * t539 * t540 + 0.9e1 / 0.4e1 * t543 * t185 + 0.3e1 / 0.2e1 * t21 * t551);
  t557 = t3 * t555 * t25;
  t562 = t522 * t89;
  t566 = t494 * t89;
  t570 = t208 * t232;
  t572 = t228 * t532;
  t575 = t94 * t501;
  t578 = 0.25438800551543137998e-5 * t528 - 0.20351040441234510398e-4 * t85 * t533 + 0.1816330359380180053e-8 * t85 * t536 - 0.2e1 / 0.3e1 * t557 * t38 + 0.71257144402081619043e-2 * t517 * t89 + 0.71257144402081619042e-2 * t562 + 0.50877601103086275995e-5 * t197 * t223 - 0.1781428610052040476e-2 * t566 + 0.16113254506123919555e-2 * t197 * t232 + 0.80566272530619597774e-3 * t570 + 0.11504863717372478562e-5 * t85 * t572 - 0.26855424176873199258e-2 * t85 * t575;
  t580 = my_piecewise3(t1, 0, t527 + t578);
  t581 = 0.1e1 / t49;
  t582 = t238 * t102;
  t585 = t237 * t102;
  t588 = t43 * t547;
  t591 = my_piecewise5(t12, 0, t8, 0, -0.6e1 * t181 - 0.6e1 * t588);
  t595 = my_piecewise3(t47, 0, -0.3e1 / 0.8e1 * t581 * t582 + 0.9e1 / 0.4e1 * t585 * t244 + 0.3e1 / 0.2e1 * t48 * t591);
  t597 = t3 * t595 * t25;
  t600 = t250 * t111;
  t601 = t107 * t256;
  t604 = t489 * t58 * t62;
  t606 = t52 * t604 / 0.4e1;
  t608 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t597 * t63 - t600 + t601 / 0.2e1 - t606);
  tv3rho30 = 0.3e1 * t236 + 0.3e1 * t260 + t4 * (t580 + t608);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t611 = 0.2e1 * t288;
  t612 = 0.2e1 * t317;
  t614 = 0.2e1 / 0.3e1 * t273 * t81;
  t615 = t271 * t25;
  t616 = t615 * t27;
  t619 = t124 * t205;
  t621 = t278 * t79;
  t623 = 0.13427712088436599629e-3 * t621 * t95;
  t632 = -t614 - 0.26855424176873199258e-3 * t616 * t95 + t619 / 0.6e1 - t623 - 0.95009525869442158724e-2 * t279 * t216 - 0.95873864311437321351e-7 * t279 * t229 - t493 + 0.67138560442182998147e-4 * t495 - 0.4750476293472107936e-2 * t497 - 0.47936932155718660677e-7 * t499 - t515 / 0.3e1;
  t635 = t539 * t119;
  t638 = t176 * t267;
  t643 = 0.2e1 * t181;
  t644 = 0.6e1 * t548;
  t646 = my_piecewise5(t8, 0, t12, 0, t643 - t644);
  t650 = my_piecewise3(t18, 0, -0.3e1 / 0.8e1 * t635 * t177 + 0.3e1 / 0.2e1 * t638 * t71 + 0.3e1 / 0.4e1 * t263 * t185 + 0.3e1 / 0.2e1 * t21 * t646);
  t652 = t3 * t650 * t25;
  t657 = t621 * t89;
  t667 = t520 / 0.3e1 - 0.13427712088436599629e-3 * t523 - 0.2e1 / 0.3e1 * t652 * t38 + 0.47504762934721079362e-2 * t616 * t89 + 0.2375238146736053968e-2 * t657 + 0.16959200367695425332e-5 * t279 * t223 + 0.84796001838477126659e-6 * t528 + 0.2375238146736053968e-2 * t562 - 0.1187619073368026984e-2 * t566 + 0.26855424176873199259e-3 * t570 + 0.53710848353746398516e-3 * t279 * t232;
  t669 = my_piecewise3(t1, 0, t632 + t667);
  t670 = t581 * t130;
  t673 = t237 * t293;
  t678 = 0.6e1 * t588;
  t680 = my_piecewise5(t12, 0, t8, 0, -t643 - t678);
  t684 = my_piecewise3(t47, 0, -0.3e1 / 0.8e1 * t670 * t238 + 0.3e1 / 0.2e1 * t673 * t102 + 0.3e1 / 0.4e1 * t289 * t244 + 0.3e1 / 0.2e1 * t48 * t680);
  t686 = t3 * t684 * t25;
  t690 = 0.2e1 / 0.3e1 * t299 * t111;
  t691 = t135 * t256;
  t695 = t248 * t25;
  t696 = t695 * t27;
  t699 = t305 * t79;
  t701 = 0.2375238146736053968e-2 * t699 * t143;
  t702 = t138 * t203;
  t703 = t702 * t143;
  t708 = 0.13427712088436599629e-3 * t699 * t149;
  t709 = t702 * t149;
  t711 = -0.2e1 / 0.3e1 * t686 * t63 - t690 + t691 / 0.6e1 - t600 / 0.3e1 + t601 / 0.3e1 - t606 + 0.23752381467360539681e-2 * t696 * t143 + t701 - 0.593809536684013492e-3 * t703 - 0.13427712088436599629e-3 * t696 * t149 - t708 + 0.33569280221091499072e-4 * t709;
  t712 = my_piecewise3(t42, 0, t711);
  tv3rho31 = t236 + t260 + t611 + t612 + t4 * (t669 + t712);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t715 = t539 * t322;
  t720 = t176 * t327;
  t724 = my_piecewise5(t8, 0, t12, 0, -t643 - t644);
  t728 = my_piecewise3(t18, 0, -0.3e1 / 0.8e1 * t715 * t71 + 0.3e1 / 0.2e1 * t263 * t267 + 0.3e1 / 0.4e1 * t720 * t71 + 0.3e1 / 0.2e1 * t21 * t724);
  t730 = t3 * t728 * t25;
  t733 = t333 * t81;
  t735 = t331 * t25;
  t736 = t735 * t27;
  t746 = -0.2e1 / 0.3e1 * t730 * t38 - t733 / 0.3e1 + 0.23752381467360539681e-2 * t736 * t89 - 0.13427712088436599629e-3 * t736 * t95 - t614 + t619 / 0.3e1 + 0.23752381467360539681e-2 * t657 - t623 + t520 / 0.6e1 - t493 - 0.59380953668401349202e-3 * t566 + 0.33569280221091499073e-4 * t495;
  t747 = my_piecewise3(t1, 0, t746);
  t748 = t581 * t339;
  t753 = t237 * t344;
  t757 = my_piecewise5(t12, 0, t8, 0, t643 - t678);
  t761 = my_piecewise3(t47, 0, -0.3e1 / 0.8e1 * t748 * t102 + 0.3e1 / 0.2e1 * t289 * t293 + 0.3e1 / 0.4e1 * t753 * t102 + 0.3e1 / 0.2e1 * t48 * t757);
  t763 = t3 * t761 * t25;
  t766 = t350 * t111;
  t769 = t297 * t25;
  t770 = t769 * t27;
  t773 = t354 * t79;
  t774 = t773 * t143;
  t778 = t773 * t149;
  t781 = -0.2e1 / 0.3e1 * t763 * t63 - t766 / 0.3e1 - t690 + t691 / 0.3e1 + 0.47504762934721079362e-2 * t770 * t143 + 0.23752381467360539681e-2 * t774 - 0.26855424176873199258e-3 * t770 * t149 - 0.13427712088436599629e-3 * t778 + t601 / 0.6e1 - t606 + t701;
  t786 = t309 * t365;
  t790 = t309 * t372;
  t794 = t309 * t378;
  t798 = t309 * t381;
  t800 = -0.1187619073368026984e-2 * t703 - t708 + 0.67138560442182998145e-4 * t709 - 0.95009525869442158724e-2 * t306 * t365 - 0.47504762934721079362e-2 * t786 + 0.16959200367695425332e-5 * t306 * t372 + 0.8479600183847712666e-6 * t790 - 0.95873864311437321351e-7 * t306 * t378 - 0.47936932155718660676e-7 * t794 + 0.53710848353746398516e-3 * t306 * t381 + 0.26855424176873199258e-3 * t798;
  t802 = my_piecewise3(t42, 0, t781 + t800);
  tv3rho32 = t611 + t612 + t338 + t385 + t4 * (t747 + t802);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t807 = t322 * t119;
  t814 = my_piecewise5(t8, 0, t12, 0, -0.6e1 * t181 - 0.6e1 * t548);
  t818 = my_piecewise3(t18, 0, -0.3e1 / 0.8e1 * t539 * t807 + 0.9e1 / 0.4e1 * t263 * t327 + 0.3e1 / 0.2e1 * t21 * t814);
  t820 = t3 * t818 * t25;
  t825 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t820 * t38 - t733 + t619 / 0.2e1 - t493);
  t826 = t348 * t25;
  t827 = t826 * t27;
  t833 = 0.1e1 / t369 / rho[1];
  t834 = t368 * t833;
  t835 = t834 * t147;
  t838 = t368 * sigma[2];
  t840 = 0.1e1 / t369 / t140;
  t841 = t838 * t840;
  t842 = t841 * t376;
  t845 = t339 * t130;
  t852 = my_piecewise5(t12, 0, t8, 0, 0.6e1 * t181 - 0.6e1 * t588);
  t856 = my_piecewise3(t47, 0, -0.3e1 / 0.8e1 * t581 * t845 + 0.9e1 / 0.4e1 * t289 * t344 + 0.3e1 / 0.2e1 * t48 * t852);
  t858 = t3 * t856 * t25;
  t861 = t377 * t834;
  t864 = sigma[2] * t474;
  t865 = t148 * t864;
  t873 = t864 * t62;
  t876 = 0.71257144402081619043e-2 * t827 * t143 + 0.50877601103086275995e-5 * t355 * t372 - 0.20351040441234510398e-4 * t139 * t835 + 0.1816330359380180053e-8 * t139 * t842 - 0.2e1 / 0.3e1 * t858 * t63 + 0.11504863717372478562e-5 * t139 * t861 - 0.26855424176873199258e-2 * t139 * t865 + 0.16113254506123919555e-2 * t355 * t381 - 0.40283136265309798887e-3 * t778 - 0.14381079646715598203e-6 * t794 + 0.80566272530619597774e-3 * t798 + 0.47504762934721079362e-1 * t139 * t873;
  t877 = t146 * t146;
  t878 = 0.1e1 / t877;
  t879 = t58 * t878;
  t880 = t879 * t841;
  t895 = -0.10268090867754937117e-9 * t139 * t880 - 0.40283136265309798887e-3 * t827 * t149 - 0.28502857760832647617e-1 * t355 * t365 - 0.28762159293431196405e-6 * t355 * t378 - 0.14251428880416323808e-1 * t786 + 0.25438800551543137998e-5 * t790 - t766 + 0.71257144402081619042e-2 * t774 + t691 / 0.2e1 - 0.1781428610052040476e-2 * t703 - t606 + 0.10070784066327449722e-3 * t709;
  t897 = my_piecewise3(t42, 0, t876 + t895);
  tv3rho33 = 0.3e1 * t338 + 0.3e1 * t385 + t4 * (t825 + t897);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t903 = t196 * t391;
  t910 = t203 * t30 * t37;
  t912 = 0.19793651222800449733e-3 * t84 * t910;
  t914 = t79 * t87 * t37;
  t915 = t84 * t914;
  t917 = t208 * t401;
  t920 = t27 * t214 * t37;
  t924 = t221 * t93 * sigma[0];
  t928 = 0.1e1 / t220 / t29;
  t929 = t928 * t227;
  t930 = t929 * t219;
  t934 = t228 * t221 * sigma[0];
  t940 = 0.11189760073697166358e-4 * t494 * t160;
  t941 = t208 * t412;
  t943 = t208 * t409;
  t946 = t507 * t928 * t219;
  t949 = t94 * t214;
  t952 = t522 * t160;
  t958 = 0.44759040294788665431e-4 * t517 * t160 - 0.79174604891201798932e-3 * t903 + 0.4750476293472107936e-2 * t196 * t395 - 0.11306133578463616888e-5 * t197 * t401 + t912 + 0.2375238146736053968e-2 * t915 - 0.56530667892318084439e-6 * t917 - 0.9500952586944215872e-2 * t84 * t920 + 0.56530667892318084439e-5 * t85 * t924 - 0.60544345312672668434e-9 * t85 * t930 - 0.31957954770479107118e-6 * t85 * t934 + 0.63915909540958214236e-7 * t197 * t409 - t940 - 0.13427712088436599629e-3 * t941 + 0.31957954770479107118e-7 * t943 + 0.34226969559183123723e-10 * t85 * t946 + 0.53710848353746398516e-3 * t85 * t949 + 0.44759040294788665432e-4 * t952 - 0.26855424176873199258e-3 * t197 * t412 - 0.79174604891201798933e-3 * t516 * t157;
  t959 = my_piecewise3(t1, 0, t958);
  tv3rho2sigma0 = t4 * t959 + 0.2e1 * t416;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t964 = t305 * t421;
  t967 = t203 * t55 * t62;
  t969 = 0.19793651222800449733e-3 * t138 * t967;
  t972 = t699 * t169;
  t975 = 0.11189760073697166358e-4 * t702 * t169;
  t977 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t695 * t166 - 0.79174604891201798932e-3 * t964 + t969 + 0.44759040294788665431e-4 * t696 * t169 + 0.44759040294788665432e-4 * t972 - t975);
  tv3rho2sigma2 = t4 * t977 + 0.2e1 * t429;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t981 = t278 * t391;
  t992 = t621 * t160;
  t1001 = -0.79174604891201798933e-3 * t615 * t157 - 0.39587302445600899466e-3 * t981 + 0.2375238146736053968e-2 * t278 * t395 - 0.56530667892318084439e-6 * t279 * t401 - 0.39587302445600899466e-3 * t903 + t912 + 0.1187619073368026984e-2 * t915 - 0.28265333946159042219e-6 * t917 + 0.44759040294788665431e-4 * t616 * t160 + 0.22379520147394332716e-4 * t992 + 0.31957954770479107118e-7 * t279 * t409 - 0.13427712088436599629e-3 * t279 * t412 + 0.22379520147394332716e-4 * t952 - t940 + 0.15978977385239553559e-7 * t943 - 0.67138560442182998148e-4 * t941;
  t1002 = my_piecewise3(t1, 0, t1001);
  tv3rho2sigma3 = t4 * t1002 + t416 + t436;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t1006 = t354 * t421;
  t1012 = t79 * t141 * t62;
  t1013 = t138 * t1012;
  t1017 = t309 * t447;
  t1021 = t773 * t169;
  t1026 = t309 * t453;
  t1030 = t309 * t456;
  t1032 = -0.79174604891201798933e-3 * t769 * t166 - 0.39587302445600899466e-3 * t1006 - 0.39587302445600899466e-3 * t964 + t969 + 0.2375238146736053968e-2 * t305 * t441 + 0.1187619073368026984e-2 * t1013 - 0.56530667892318084439e-6 * t306 * t447 - 0.2826533394615904222e-6 * t1017 + 0.44759040294788665431e-4 * t770 * t169 + 0.22379520147394332716e-4 * t1021 + 0.22379520147394332716e-4 * t972 - t975 + 0.31957954770479107118e-7 * t306 * t453 + 0.15978977385239553559e-7 * t1026 - 0.13427712088436599629e-3 * t306 * t456 - 0.67138560442182998145e-4 * t1030;
  t1033 = my_piecewise3(t42, 0, t1032);
  tv3rho2sigma5 = t4 * t1033 + t429 + t460;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t1043 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t735 * t157 - 0.79174604891201798932e-3 * t981 + t912 + 0.44759040294788665431e-4 * t736 * t160 + 0.44759040294788665432e-4 * t992 - t940);
  tv3rho2sigma6 = t4 * t1043 + 0.2e1 * t436;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t1051 = 0.1e1 / t369 / t54;
  t1053 = t879 * t1051 * t368;
  t1056 = t148 * t363;
  t1067 = t27 * t363 * t62;
  t1071 = t370 * t147 * sigma[2];
  t1074 = t1051 * t376;
  t1075 = t1074 * t368;
  t1083 = t377 * t370 * sigma[2];
  t1089 = -0.26855424176873199258e-3 * t355 * t456 + 0.63915909540958214236e-7 * t355 * t453 + 0.34226969559183123723e-10 * t139 * t1053 + 0.53710848353746398516e-3 * t139 * t1056 - 0.13427712088436599629e-3 * t1030 - 0.56530667892318084439e-6 * t1017 + 0.44759040294788665432e-4 * t1021 + 0.4750476293472107936e-2 * t354 * t441 - 0.11306133578463616888e-5 * t355 * t447 - 0.9500952586944215872e-2 * t138 * t1067 + 0.56530667892318084439e-5 * t139 * t1071 - 0.60544345312672668434e-9 * t139 * t1075 + 0.44759040294788665431e-4 * t827 * t169 - 0.79174604891201798932e-3 * t1006 + 0.2375238146736053968e-2 * t1013 + t969 - 0.31957954770479107118e-6 * t139 * t1083 + 0.31957954770479107118e-7 * t1026 - t975 - 0.79174604891201798933e-3 * t826 * t166;
  t1090 = my_piecewise3(t42, 0, t1089);
  tv3rho2sigma8 = t4 * t1090 + 0.2e1 * t460;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  t1095 = t79 * t463 * t93;
  t1097 = 0.9421777982053014073e-7 * t84 * t1095;
  t1099 = t27 * t399 * t93;
  t1103 = 0.1e1 / t220 / t28;
  t1105 = t1103 * t227 * sigma[0];
  t1111 = 0.53263257950798511865e-8 * t208 * t468;
  t1113 = t507 * t1103 * sigma[0];
  t1116 = t228 * t399;
  t1120 = my_piecewise3(t1, 0, 0.18843555964106028146e-6 * t196 * t465 + t1097 - 0.11306133578463616888e-5 * t84 * t1099 + 0.20181448437557556144e-9 * t85 * t1105 - 0.10652651590159702373e-7 * t197 * t468 - t1111 - 0.11408989853061041241e-10 * t85 * t1113 + 0.63915909540958214238e-7 * t85 * t1116);
  tv3rhosigma20 = t4 * t1120 + t472;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t1125 = t79 * t474 * t147;
  t1127 = 0.9421777982053014073e-7 * t138 * t1125;
  t1131 = 0.53263257950798511865e-8 * t309 * t479;
  t1133 = my_piecewise3(t42, 0, 0.18843555964106028146e-6 * t305 * t476 + t1127 - 0.10652651590159702373e-7 * t306 * t479 - t1131);
  tv3rhosigma25 = t4 * t1133 + t483;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t1140 = my_piecewise3(t1, 0, 0.18843555964106028146e-6 * t278 * t465 + t1097 - 0.10652651590159702373e-7 * t279 * t468 - t1111);
  tv3rhosigma26 = t4 * t1140 + t472;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t1145 = t27 * t445 * t147;
  t1149 = 0.1e1 / t369 / t53;
  t1151 = t1149 * t376 * sigma[2];
  t1157 = t879 * t1149 * sigma[2];
  t1160 = t377 * t445;
  t1164 = my_piecewise3(t42, 0, 0.18843555964106028146e-6 * t354 * t476 + t1127 - 0.11306133578463616888e-5 * t138 * t1145 + 0.20181448437557556144e-9 * t139 * t1151 - 0.10652651590159702373e-7 * t355 * t479 - t1131 - 0.11408989853061041241e-10 * t139 * t1157 + 0.63915909540958214238e-7 * t139 * t1160);
  tv3rhosigma211 = t4 * t1164 + t483;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  t1167 = t27 * t531 * t227;
  t1170 = t507 * t531;
  t1174 = my_piecewise3(t1, 0, -0.67271494791858520482e-10 * t84 * t1167 + 0.38029966176870137472e-11 * t85 * t1170);
  tv3sigma30 = t4 * t1174;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t1176 = t27 * t833 * t376;
  t1179 = t879 * t833;
  t1183 = my_piecewise3(t42, 0, -0.67271494791858520482e-10 * t138 * t1176 + 0.38029966176870137472e-11 * t139 * t1179);
  tv3sigma39 = t4 * t1183;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  t1186 = t494 * t216;
  t1188 = t208 * t502;
  t1193 = t191 * t205;
  t1195 = 0.1e1 / t27 / t180;
  t1199 = 0.5e1 / 0.8e1 * t26 * t1195 * t33 * t37;
  t1200 = t219 * t1103;
  t1204 = t219 * t219;
  t1205 = t220 * t220;
  t1207 = t1204 / t1205;
  t1211 = t557 * t81;
  t1213 = t516 * t79;
  t1214 = t1213 * t89;
  t1218 = t196 * t203;
  t1219 = t1218 * t89;
  t1221 = 0.14251428880416323808e-1 * t1186 + 0.95009525869442158721e-1 * t1188 - 0.28502857760832647617e0 * t85 * t408 * t37 + t1193 + t1199 + 0.21707776470650144424e-3 * t85 * t1200 * t93 + 0.25937197531948971157e-11 * t85 * t1207 * t506 - 0.4e1 / 0.3e1 * t1211 + 0.14251428880416323808e-1 * t1214 + 0.10175520220617255199e-4 * t517 * t223 - 0.71257144402081619041e-2 * t1219;
  t1222 = t522 * t223;
  t1229 = 0.1e1 / t220 / t213;
  t1230 = t508 * t1229;
  t1234 = t17 * t17;
  t1236 = 0.1e1 / t21 / t1234;
  t1237 = t177 * t177;
  t1243 = t185 * t185;
  t1249 = 0.1e1 / t546 / t4;
  t1250 = t14 * t1249;
  t1253 = my_piecewise5(t8, 0, t12, 0, -0.24e2 * t547 + 0.24e2 * t1250);
  t1257 = my_piecewise3(t18, 0, 0.9e1 / 0.16e2 * t1236 * t1237 - 0.9e1 / 0.4e1 * t539 * t177 * t185 + 0.9e1 / 0.4e1 * t176 * t1243 + 0.3e1 * t543 * t551 + 0.3e1 / 0.2e1 * t21 * t1253);
  t1262 = t555 * t25;
  t1263 = t1262 * t27;
  t1268 = t76 * t491;
  t1269 = t84 * t489;
  t1270 = t1269 * t89;
  t1272 = t494 * t223;
  t1274 = t522 * t216;
  t1276 = 0.10175520220617255199e-4 * t1222 - 0.57005715521665295234e-1 * t517 * t216 - 0.81404161764938041592e-4 * t197 * t533 - 0.43591928625124321272e-7 * t85 * t1230 * t227 - 0.2e1 / 0.3e1 * t3 * t1257 * t25 * t38 + 0.95009525869442158724e-2 * t1263 * t89 + 0.7265321437520720212e-8 * t197 * t536 - t1268 + 0.3562857220104080952e-2 * t1270 - 0.25438800551543137997e-5 * t1272 - 0.57005715521665295233e-1 * t1274;
  t1278 = t208 * t533;
  t1280 = t208 * t536;
  t1284 = t208 * t512;
  t1288 = t33 / t505 / t36;
  t1292 = t1213 * t95;
  t1300 = t1269 * t95;
  t1302 = t522 * t229;
  t1304 = -0.40702080882469020796e-4 * t1278 + 0.36326607187603601061e-8 * t1280 + 0.19001905173888431744e0 * t197 * t502 - 0.20536181735509874234e-9 * t1284 - 0.14662833759154050203e-12 * t85 * t1288 * t1207 - 0.80566272530619597775e-3 * t1292 - 0.53710848353746398516e-3 * t1263 * t95 - 0.5752431858686239281e-6 * t517 * t229 - 0.41072363471019748467e-9 * t197 * t512 - 0.20141568132654899444e-3 * t1300 - 0.5752431858686239281e-6 * t1302;
  t1307 = t494 * t232;
  t1309 = t208 * t572;
  t1313 = t208 * t575;
  t1326 = t522 * t232;
  t1328 = t1218 * t95;
  t1330 = t494 * t229;
  t1332 = 0.46019454869489914248e-5 * t197 * t572 - 0.80566272530619597775e-3 * t1307 + 0.23009727434744957124e-5 * t1309 - 0.10742169670749279703e-1 * t197 * t575 - 0.53710848353746398516e-2 * t1313 - 0.12271854631863977133e-4 * t85 * t228 * t1200 + 0.16113254506123919555e-1 * t85 * t94 * t408 + 0.2464341808261184908e-8 * t85 * t507 * t1230 + 0.3222650901224783911e-2 * t517 * t232 + 0.32226509012247839109e-2 * t1326 + 0.40283136265309798888e-3 * t1328 + 0.14381079646715598203e-6 * t1330;
  t1335 = my_piecewise3(t1, 0, t1221 + t1276 + t1304 + t1332);
  t1336 = t46 * t46;
  t1338 = 0.1e1 / t48 / t1336;
  t1339 = t238 * t238;
  t1345 = t244 * t244;
  t1350 = t43 * t1249;
  t1353 = my_piecewise5(t12, 0, t8, 0, 0.24e2 * t547 + 0.24e2 * t1350);
  t1357 = my_piecewise3(t47, 0, 0.9e1 / 0.16e2 * t1338 * t1339 - 0.9e1 / 0.4e1 * t581 * t238 * t244 + 0.9e1 / 0.4e1 * t237 * t1345 + 0.3e1 * t585 * t591 + 0.3e1 / 0.2e1 * t48 * t1353);
  t1362 = t597 * t111;
  t1364 = t250 * t256;
  t1365 = t107 * t604;
  t1369 = 0.5e1 / 0.8e1 * t52 * t1195 * t58 * t62;
  t1371 = my_piecewise3(t42, 0, -0.2e1 / 0.3e1 * t3 * t1357 * t25 * t63 - 0.4e1 / 0.3e1 * t1362 + t1364 - t1365 + t1369);
  tv4rho40 = 0.4e1 * t580 + 0.4e1 * t608 + t4 * (t1335 + t1371);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t1376 = t621 * t223;
  t1400 = 0.12e2 * t547;
  t1401 = 0.24e2 * t1250;
  t1403 = my_piecewise5(t8, 0, t12, 0, -t1400 + t1401);
  t1407 = my_piecewise3(t18, 0, 0.9e1 / 0.16e2 * t1236 * t119 * t540 - 0.9e1 / 0.8e1 * t539 * t267 * t177 - 0.9e1 / 0.8e1 * t635 * t71 * t185 + 0.9e1 / 0.4e1 * t176 * t646 * t71 + 0.9e1 / 0.4e1 * t638 * t185 + 0.3e1 / 0.4e1 * t263 * t551 + 0.3e1 / 0.2e1 * t21 * t1403);
  t1412 = t650 * t25;
  t1413 = t1412 * t27;
  t1416 = t273 * t205;
  t1417 = t1416 / 0.2e1;
  t1418 = t124 * t491;
  t1420 = t621 * t216;
  t1424 = t652 * t81;
  t1425 = t615 * t79;
  t1426 = t1425 * t89;
  t1428 = 0.25438800551543137998e-5 * t1376 - 0.28502857760832647617e-1 * t616 * t216 - 0.20351040441234510398e-4 * t279 * t533 + 0.1816330359380180053e-8 * t279 * t536 - 0.2e1 / 0.3e1 * t3 * t1407 * t25 * t38 + 0.71257144402081619043e-2 * t1413 * t89 + t1417 - t1418 / 0.4e1 - 0.14251428880416323808e-1 * t1420 + 0.47504762934721079362e-1 * t279 * t502 - t1424 + 0.71257144402081619042e-2 * t1426;
  t1441 = 0.50877601103086275995e-5 * t616 * t223 + 0.7125714440208161904e-2 * t1186 + 0.2375238146736053968e-1 * t1188 + t1193 / 0.2e1 + t1199 - t1211 / 0.3e1 + 0.3562857220104080952e-2 * t1214 - 0.3562857220104080952e-2 * t1219 + 0.25438800551543137998e-5 * t1222 - 0.3e1 / 0.4e1 * t1268 + 0.2672142915078060714e-2 * t1270 - 0.12719400275771568999e-5 * t1272;
  t1446 = t278 * t203;
  t1447 = t1446 * t89;
  t1448 = 0.1781428610052040476e-2 * t1447;
  t1449 = t1425 * t95;
  t1455 = t1446 * t95;
  t1456 = 0.10070784066327449722e-3 * t1455;
  t1457 = t621 * t229;
  t1465 = -0.14251428880416323808e-1 * t1274 - 0.10175520220617255199e-4 * t1278 + 0.90816517969009002653e-9 * t1280 - t1448 - 0.40283136265309798887e-3 * t1449 - 0.40283136265309798887e-3 * t1413 * t95 - 0.28762159293431196405e-6 * t616 * t229 + t1456 - 0.14381079646715598203e-6 * t1457 - 0.10268090867754937117e-9 * t279 * t512 - 0.26855424176873199258e-2 * t279 * t575 + 0.16113254506123919555e-2 * t616 * t232;
  t1466 = t621 * t232;
  t1480 = 0.80566272530619597774e-3 * t1466 + 0.11504863717372478562e-5 * t279 * t572 - 0.51340454338774685585e-10 * t1284 - 0.20141568132654899444e-3 * t1292 - 0.15106176099491174583e-3 * t1300 - 0.14381079646715598203e-6 * t1302 - 0.40283136265309798889e-3 * t1307 + 0.57524318586862392813e-6 * t1309 - 0.1342771208843659963e-2 * t1313 + 0.80566272530619597775e-3 * t1326 + 0.20141568132654899444e-3 * t1328 + 0.71905398233577991015e-7 * t1330;
  t1483 = my_piecewise3(t1, 0, t1428 + t1441 + t1465 + t1480);
  t1500 = 0.24e2 * t1350;
  t1502 = my_piecewise5(t12, 0, t8, 0, t1400 + t1500);
  t1506 = my_piecewise3(t47, 0, 0.9e1 / 0.16e2 * t1338 * t130 * t582 - 0.9e1 / 0.8e1 * t581 * t293 * t238 - 0.9e1 / 0.8e1 * t670 * t102 * t244 + 0.9e1 / 0.4e1 * t237 * t680 * t102 + 0.9e1 / 0.4e1 * t673 * t244 + 0.3e1 / 0.4e1 * t289 * t591 + 0.3e1 / 0.2e1 * t48 * t1502);
  t1511 = t686 * t111;
  t1512 = t299 * t256;
  t1513 = t1512 / 0.2e1;
  t1514 = t135 * t604;
  t1519 = t595 * t25;
  t1520 = t1519 * t27;
  t1523 = t695 * t79;
  t1524 = t1523 * t143;
  t1526 = t305 * t203;
  t1527 = t1526 * t143;
  t1528 = 0.1781428610052040476e-2 * t1527;
  t1529 = t138 * t489;
  t1530 = t1529 * t143;
  t1534 = t1523 * t149;
  t1536 = t1526 * t149;
  t1537 = 0.10070784066327449722e-3 * t1536;
  t1538 = t1529 * t149;
  t1540 = -0.2e1 / 0.3e1 * t3 * t1506 * t25 * t63 - t1511 + t1513 - t1514 / 0.4e1 - t1362 / 0.3e1 + t1364 / 0.2e1 - 0.3e1 / 0.4e1 * t1365 + t1369 + 0.23752381467360539681e-2 * t1520 * t143 + 0.3562857220104080952e-2 * t1524 - t1528 + 0.890714305026020238e-3 * t1530 - 0.13427712088436599629e-3 * t1520 * t149 - 0.20141568132654899444e-3 * t1534 + t1537 - 0.50353920331637248608e-4 * t1538;
  t1541 = my_piecewise3(t42, 0, t1540);
  tv4rho41 = t580 + t608 + 0.3e1 * t669 + 0.3e1 * t712 + t4 * (t1483 + t1541);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t1556 = t267 * t267;
  t1569 = my_piecewise5(t8, 0, t12, 0, t1401);
  t1573 = my_piecewise3(t18, 0, 0.9e1 / 0.16e2 * t1236 * t322 * t177 - 0.3e1 / 0.2e1 * t635 * t71 * t267 - 0.3e1 / 0.8e1 * t715 * t185 + 0.3e1 / 0.2e1 * t176 * t1556 + 0.3e1 / 0.2e1 * t263 * t646 - 0.3e1 / 0.8e1 * t539 * t327 * t177 + 0.3e1 / 0.2e1 * t176 * t724 * t71 + 0.3e1 / 0.4e1 * t720 * t185 + 0.3e1 / 0.2e1 * t21 * t1569);
  t1578 = t728 * t25;
  t1579 = t1578 * t27;
  t1582 = t735 * t79;
  t1583 = t1582 * t89;
  t1587 = t333 * t205;
  t1591 = t730 * t81;
  t1601 = -0.2e1 / 0.3e1 * t3 * t1573 * t25 * t38 + 0.47504762934721079362e-2 * t1579 * t89 + 0.2375238146736053968e-2 * t1583 + 0.16959200367695425332e-5 * t736 * t223 + t1587 / 0.6e1 - 0.95009525869442158724e-2 * t736 * t216 - 0.2e1 / 0.3e1 * t1591 + 0.16959200367695425332e-5 * t1376 + 0.2e1 / 0.3e1 * t1416 - t1418 / 0.2e1 - 0.95009525869442158724e-2 * t1420 - 0.2e1 / 0.3e1 * t1424 + 0.47504762934721079362e-2 * t1426 + 0.23752381467360539681e-2 * t1186 + t1193 / 0.6e1 + t1199;
  t1609 = t1582 * t95;
  t1623 = -0.1187619073368026984e-2 * t1219 - t1268 / 0.2e1 + 0.1781428610052040476e-2 * t1270 - 0.4239800091923856333e-6 * t1272 - 0.2375238146736053968e-2 * t1447 - 0.26855424176873199258e-3 * t1579 * t95 - 0.13427712088436599629e-3 * t1609 - 0.95873864311437321351e-7 * t736 * t229 + 0.53710848353746398516e-3 * t736 * t232 - 0.26855424176873199258e-3 * t1449 + 0.13427712088436599629e-3 * t1455 - 0.95873864311437321351e-7 * t1457 + 0.53710848353746398516e-3 * t1466 - 0.10070784066327449722e-3 * t1300 - 0.13427712088436599629e-3 * t1307 + 0.67138560442182998146e-4 * t1328 + 0.23968466077859330338e-7 * t1330;
  t1625 = my_piecewise3(t1, 0, t1601 + t1623);
  t1626 = t699 * t365;
  t1628 = t702 * t365;
  t1630 = t699 * t372;
  t1632 = t702 * t372;
  t1646 = t293 * t293;
  t1659 = my_piecewise5(t12, 0, t8, 0, t1500);
  t1663 = my_piecewise3(t47, 0, 0.9e1 / 0.16e2 * t1338 * t339 * t238 - 0.3e1 / 0.2e1 * t670 * t102 * t293 - 0.3e1 / 0.8e1 * t748 * t244 + 0.3e1 / 0.2e1 * t237 * t1646 + 0.3e1 / 0.2e1 * t289 * t680 - 0.3e1 / 0.8e1 * t581 * t344 * t238 + 0.3e1 / 0.2e1 * t237 * t757 * t102 + 0.3e1 / 0.4e1 * t753 * t244 + 0.3e1 / 0.2e1 * t48 * t1659);
  t1668 = t684 * t25;
  t1669 = t1668 * t27;
  t1672 = t769 * t79;
  t1673 = t1672 * t143;
  t1675 = t354 * t203;
  t1676 = t1675 * t143;
  t1678 = t763 * t111;
  t1680 = t350 * t256;
  t1686 = -0.95009525869442158724e-2 * t1626 + 0.23752381467360539681e-2 * t1628 + 0.16959200367695425332e-5 * t1630 - 0.4239800091923856333e-6 * t1632 - 0.95009525869442158724e-2 * t696 * t365 + 0.16959200367695425332e-5 * t696 * t372 - 0.2e1 / 0.3e1 * t3 * t1663 * t25 * t63 + 0.47504762934721079362e-2 * t1669 * t143 + 0.47504762934721079362e-2 * t1673 - 0.1187619073368026984e-2 * t1676 - 0.2e1 / 0.3e1 * t1678 + t1680 / 0.6e1 - 0.2e1 / 0.3e1 * t1511 + 0.2e1 / 0.3e1 * t1512 - t1514 / 0.2e1 + 0.2375238146736053968e-2 * t1524;
  t1695 = t702 * t378;
  t1697 = t699 * t381;
  t1699 = t702 * t381;
  t1701 = t1672 * t149;
  t1703 = t1675 * t149;
  t1705 = t699 * t378;
  t1712 = -0.2375238146736053968e-2 * t1527 + 0.1781428610052040476e-2 * t1530 + t1364 / 0.6e1 - t1365 / 0.2e1 + t1369 + 0.53710848353746398516e-3 * t696 * t381 - 0.95873864311437321351e-7 * t696 * t378 + 0.23968466077859330338e-7 * t1695 + 0.53710848353746398516e-3 * t1697 - 0.13427712088436599629e-3 * t1699 - 0.26855424176873199258e-3 * t1701 + 0.67138560442182998145e-4 * t1703 - 0.95873864311437321352e-7 * t1705 - 0.26855424176873199258e-3 * t1669 * t149 + 0.13427712088436599629e-3 * t1536 - 0.10070784066327449722e-3 * t1538 - 0.13427712088436599629e-3 * t1534;
  t1714 = my_piecewise3(t42, 0, t1686 + t1712);
  tv4rho42 = 0.2e1 * t669 + 0.2e1 * t712 + 0.2e1 * t747 + 0.2e1 * t802 + t4 * (t1625 + t1714);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t1735 = my_piecewise5(t8, 0, t12, 0, t1400 + t1401);
  t1739 = my_piecewise3(t18, 0, 0.9e1 / 0.16e2 * t1236 * t807 * t71 - 0.9e1 / 0.8e1 * t715 * t267 - 0.9e1 / 0.8e1 * t635 * t327 * t71 + 0.9e1 / 0.4e1 * t638 * t327 + 0.9e1 / 0.4e1 * t263 * t724 + 0.3e1 / 0.4e1 * t176 * t814 * t71 + 0.3e1 / 0.2e1 * t21 * t1735);
  t1744 = t820 * t81;
  t1746 = t818 * t25;
  t1747 = t1746 * t27;
  t1759 = -0.2e1 / 0.3e1 * t3 * t1739 * t25 * t38 - t1744 / 0.3e1 + 0.23752381467360539681e-2 * t1747 * t89 - 0.13427712088436599629e-3 * t1747 * t95 - t1591 + t1587 / 0.2e1 + 0.35628572201040809521e-2 * t1583 - 0.20141568132654899444e-3 * t1609 + t1417 - 0.3e1 / 0.4e1 * t1418 - t1448 + t1456 - t1268 / 0.4e1 + t1199 + 0.89071430502602023802e-3 * t1270 - 0.5035392033163724861e-4 * t1300;
  t1760 = my_piecewise3(t1, 0, t1759);
  t1761 = t773 * t365;
  t1763 = t309 * t873;
  t1765 = t826 * t79;
  t1766 = t1765 * t143;
  t1768 = t773 * t372;
  t1770 = t309 * t835;
  t1772 = t309 * t842;
  t1774 = t858 * t111;
  t1776 = t761 * t25;
  t1777 = t1776 * t27;
  t1802 = my_piecewise5(t12, 0, t8, 0, -t1400 + t1500);
  t1806 = my_piecewise3(t47, 0, 0.9e1 / 0.16e2 * t1338 * t845 * t102 - 0.9e1 / 0.8e1 * t748 * t293 - 0.9e1 / 0.8e1 * t670 * t344 * t102 + 0.9e1 / 0.4e1 * t673 * t344 + 0.9e1 / 0.4e1 * t289 * t757 + 0.3e1 / 0.4e1 * t237 * t852 * t102 + 0.3e1 / 0.2e1 * t48 * t1802);
  t1811 = -0.14251428880416323808e-1 * t1761 + 0.23752381467360539681e-1 * t1763 + 0.35628572201040809522e-2 * t1766 + 0.25438800551543137998e-5 * t1768 - 0.10175520220617255199e-4 * t1770 + 0.9081651796900900265e-9 * t1772 - t1774 / 0.3e1 + 0.71257144402081619043e-2 * t1777 * t143 + 0.50877601103086275995e-5 * t770 * t372 - 0.20351040441234510398e-4 * t306 * t835 + 0.1816330359380180053e-8 * t306 * t842 - 0.2e1 / 0.3e1 * t3 * t1806 * t25 * t63;
  t1824 = 0.47504762934721079362e-1 * t306 * t873 - 0.28502857760832647617e-1 * t770 * t365 - 0.14251428880416323808e-1 * t1626 + 0.7125714440208161904e-2 * t1628 + 0.25438800551543137998e-5 * t1630 - 0.12719400275771568999e-5 * t1632 + 0.71257144402081619042e-2 * t1673 - 0.35628572201040809521e-2 * t1676 - t1678 + t1680 / 0.2e1 + t1513 - 0.3e1 / 0.4e1 * t1514;
  t1828 = t773 * t378;
  t1830 = t309 * t865;
  t1832 = t773 * t381;
  t1834 = t309 * t880;
  t1836 = t1765 * t149;
  t1838 = t309 * t861;
  t1844 = -t1528 + 0.2672142915078060714e-2 * t1530 - t1365 / 0.4e1 + t1369 - 0.14381079646715598202e-6 * t1828 - 0.13427712088436599629e-2 * t1830 + 0.80566272530619597775e-3 * t1832 - 0.51340454338774685585e-10 * t1834 - 0.20141568132654899444e-3 * t1836 + 0.5752431858686239281e-6 * t1838 - 0.28762159293431196405e-6 * t770 * t378 + 0.11504863717372478562e-5 * t306 * t861;
  t1860 = -0.26855424176873199258e-2 * t306 * t865 + 0.16113254506123919555e-2 * t770 * t381 - 0.10268090867754937117e-9 * t306 * t880 - 0.40283136265309798887e-3 * t1777 * t149 + 0.71905398233577991015e-7 * t1695 + 0.80566272530619597774e-3 * t1697 - 0.40283136265309798887e-3 * t1699 - 0.40283136265309798887e-3 * t1701 + 0.20141568132654899444e-3 * t1703 - 0.14381079646715598203e-6 * t1705 + t1537 - 0.15106176099491174583e-3 * t1538;
  t1863 = my_piecewise3(t42, 0, t1811 + t1824 + t1844 + t1860);
  tv4rho43 = 0.3e1 * t747 + 0.3e1 * t802 + t825 + t897 + t4 * (t1760 + t1863);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t1868 = t322 * t322;
  t1873 = t327 * t327;
  t1880 = my_piecewise5(t8, 0, t12, 0, 0.24e2 * t547 + 0.24e2 * t1250);
  t1884 = my_piecewise3(t18, 0, 0.9e1 / 0.16e2 * t1236 * t1868 - 0.9e1 / 0.4e1 * t715 * t327 + 0.9e1 / 0.4e1 * t176 * t1873 + 0.3e1 * t263 * t814 + 0.3e1 / 0.2e1 * t21 * t1880);
  t1891 = my_piecewise3(t1, 0, -0.2e1 / 0.3e1 * t3 * t1884 * t25 * t38 - 0.4e1 / 0.3e1 * t1744 + t1587 - t1418 + t1199);
  t1899 = t368 * t1149;
  t1903 = t856 * t25;
  t1904 = t1903 * t27;
  t1912 = 0.1e1 / t369 / t362;
  t1913 = t838 * t1912;
  t1917 = t368 * t368;
  t1918 = t369 * t369;
  t1920 = t1917 / t1918;
  t1924 = t339 * t339;
  t1929 = t344 * t344;
  t1936 = my_piecewise5(t12, 0, t8, 0, -0.24e2 * t547 + 0.24e2 * t1350);
  t1940 = my_piecewise3(t47, 0, 0.9e1 / 0.16e2 * t1338 * t1924 - 0.9e1 / 0.4e1 * t748 * t344 + 0.9e1 / 0.4e1 * t237 * t1929 + 0.3e1 * t289 * t852 + 0.3e1 / 0.2e1 * t48 * t1936);
  t1947 = -0.28502857760832647617e0 * t139 * t452 * t62 - 0.57005715521665295234e-1 * t827 * t365 - 0.81404161764938041592e-4 * t355 * t835 + 0.21707776470650144424e-3 * t139 * t1899 * t147 + 0.95009525869442158724e-2 * t1904 * t143 + 0.10175520220617255199e-4 * t827 * t372 + 0.7265321437520720212e-8 * t355 * t842 - 0.43591928625124321272e-7 * t139 * t1913 * t376 + 0.25937197531948971157e-11 * t139 * t1920 * t878 - 0.2e1 / 0.3e1 * t3 * t1940 * t25 * t63 + 0.19001905173888431744e0 * t355 * t873;
  t1958 = -0.57005715521665295233e-1 * t1761 + 0.95009525869442158721e-1 * t1763 + 0.14251428880416323808e-1 * t1766 + 0.10175520220617255199e-4 * t1768 - 0.40702080882469020796e-4 * t1770 + 0.36326607187603601061e-8 * t1772 - 0.4e1 / 0.3e1 * t1774 + 0.14251428880416323808e-1 * t1628 - 0.25438800551543137997e-5 * t1632 - 0.71257144402081619041e-2 * t1676 + t1680;
  t1967 = t58 / t877 / t61;
  t1982 = -t1514 + 0.3562857220104080952e-2 * t1530 + t1369 + 0.3222650901224783911e-2 * t827 * t381 - 0.41072363471019748467e-9 * t355 * t880 - 0.14662833759154050203e-12 * t139 * t1967 * t1920 - 0.5752431858686239281e-6 * t827 * t378 - 0.53710848353746398516e-3 * t1904 * t149 + 0.46019454869489914248e-5 * t355 * t861 + 0.2464341808261184908e-8 * t139 * t879 * t1913 - 0.10742169670749279703e-1 * t355 * t865;
  t1999 = -0.12271854631863977133e-4 * t139 * t377 * t1899 + 0.16113254506123919555e-1 * t139 * t148 * t452 - 0.5752431858686239281e-6 * t1828 - 0.53710848353746398516e-2 * t1830 + 0.32226509012247839109e-2 * t1832 - 0.20536181735509874234e-9 * t1834 - 0.80566272530619597775e-3 * t1836 + 0.23009727434744957124e-5 * t1838 + 0.14381079646715598203e-6 * t1695 - 0.80566272530619597775e-3 * t1699 + 0.40283136265309798888e-3 * t1703 - 0.20141568132654899444e-3 * t1538;
  t2002 = my_piecewise3(t42, 0, t1947 + t1958 + t1982 + t1999);
  tv4rho44 = 0.4e1 * t825 + 0.4e1 * t897 + t4 * (t1891 + t2002);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t2017 = 0.1e1 / t220 / t398;
  t2022 = t1218 * t160;
  t2024 = t522 * t412;
  t2032 = t522 * t401;
  t2038 = t494 * t401;
  t2040 = t208 * t924;
  t2042 = t208 * t930;
  t2045 = 0.16784640110545749537e-4 * t1269 * t160;
  t2046 = t494 * t412;
  t2048 = t208 * t949;
  t2053 = t1213 * t160;
  t2055 = -0.40283136265309798887e-3 * t517 * t412 - 0.52008214460932637683e-4 * t85 * t531 * t93 * sigma[0] + 0.12714312515661260372e-7 * t85 * t510 * t227 * t219 - 0.86457325106496570524e-12 * t85 * t2017 * t506 * t508 - 0.33569280221091499074e-4 * t2022 - 0.40283136265309798888e-3 * t2024 + 0.16113254506123919555e-2 * t197 * t949 + 0.44759040294788665431e-4 * t1263 * t160 - 0.16959200367695425332e-5 * t517 * t401 - 0.16959200367695425332e-5 * t2032 + 0.16959200367695425332e-4 * t197 * t924 - 0.1816330359380180053e-8 * t197 * t930 + 0.4239800091923856333e-6 * t2038 + 0.84796001838477126659e-5 * t2040 - 0.90816517969009002651e-9 * t2042 + t2045 + 0.10070784066327449722e-3 * t2046 + 0.80566272530619597774e-3 * t2048 - 0.26855424176873199258e-2 * t85 * t94 * t463 + 0.67138560442182998148e-4 * t2053;
  t2056 = t208 * t934;
  t2062 = t522 * t409;
  t2072 = t494 * t409;
  t2074 = t208 * t946;
  t2082 = t196 * t910;
  t2084 = t196 * t914;
  t2091 = 0.296904768342006746e-3 * t84 * t489 * t30 * t37;
  t2094 = t84 * t203 * t87 * t37;
  t2098 = t84 * t79 * t214 * t37;
  t2103 = t516 * t391;
  t2109 = -0.47936932155718660677e-6 * t2056 + 0.29401318388840778548e-5 * t85 * t228 * t531 * sigma[0] + 0.95873864311437321354e-7 * t2062 - 0.95873864311437321353e-6 * t197 * t934 - 0.71876636074284559818e-9 * t85 * t507 * t510 * t219 + 0.10268090867754937117e-9 * t197 * t946 - 0.23968466077859330339e-7 * t2072 + 0.51340454338774685585e-10 * t2074 + 0.48876112530513500676e-13 * t85 * t1288 * t2017 * t508 + 0.95873864311437321354e-7 * t517 * t409 + 0.59380953668401349199e-3 * t2082 + 0.7125714440208161904e-2 * t2084 - 0.28502857760832647616e-1 * t196 * t920 - t2091 - 0.1781428610052040476e-2 * t2094 - 0.14251428880416323808e-1 * t2098 + 0.4750476293472107936e-1 * t84 * t464 * t37 - 0.1187619073368026984e-2 * t2103 + 0.7125714440208161904e-2 * t516 * t395 - 0.79174604891201798933e-3 * t1262 * t157;
  t2111 = my_piecewise3(t1, 0, t2055 + t2109);
  tv4rho3sigma0 = t4 * t2111 + 0.3e1 * t959;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t2116 = t695 * t421;
  t2118 = t305 * t967;
  t2123 = 0.296904768342006746e-3 * t138 * t489 * t55 * t62;
  t2126 = t1523 * t169;
  t2128 = t1526 * t169;
  t2131 = 0.16784640110545749537e-4 * t1529 * t169;
  t2133 = my_piecewise3(t42, 0, -0.79174604891201798933e-3 * t1519 * t166 - 0.1187619073368026984e-2 * t2116 + 0.59380953668401349199e-3 * t2118 - t2123 + 0.44759040294788665431e-4 * t1520 * t169 + 0.67138560442182998148e-4 * t2126 - 0.33569280221091499074e-4 * t2128 + t2131);
  tv4rho3sigma2 = t4 * t2133 + 0.3e1 * t977;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t2135 = 0.2e1 * t1002;
  t2143 = 0.56530667892318084439e-6 * t621 * t401;
  t2153 = 0.44759040294788665432e-4 * t1425 * t160;
  t2156 = t1446 * t160;
  t2158 = t621 * t412;
  t2165 = -0.60544345312672668434e-9 * t279 * t930 + 0.44759040294788665431e-4 * t1413 * t160 - 0.11306133578463616888e-5 * t616 * t401 - t2143 + 0.56530667892318084439e-5 * t279 * t924 - 0.22379520147394332716e-4 * t2022 - 0.1342771208843659963e-3 * t2024 - 0.56530667892318084438e-6 * t2032 + 0.2826533394615904222e-6 * t2038 + 0.28265333946159042219e-5 * t2040 - 0.30272172656336334217e-9 * t2042 + t2153 - 0.26855424176873199258e-3 * t616 * t412 - 0.11189760073697166358e-4 * t2156 - 0.13427712088436599629e-3 * t2158 + 0.53710848353746398516e-3 * t279 * t949 + t2045 + 0.67138560442182998148e-4 * t2046 + 0.26855424176873199259e-3 * t2048 + 0.22379520147394332716e-4 * t2053;
  t2171 = 0.31957954770479107118e-7 * t621 * t409;
  t2180 = t278 * t910;
  t2183 = 0.2375238146736053968e-2 * t278 * t914;
  t2194 = 0.79174604891201798932e-3 * t615 * t391;
  t2195 = -0.31957954770479107118e-6 * t279 * t934 + 0.63915909540958214236e-7 * t616 * t409 + t2171 + 0.34226969559183123723e-10 * t279 * t946 - 0.15978977385239553559e-6 * t2056 + 0.31957954770479107118e-7 * t2062 - 0.15978977385239553559e-7 * t2072 + 0.17113484779591561862e-10 * t2074 + 0.4750476293472107936e-2 * t615 * t395 + 0.19793651222800449733e-3 * t2180 + t2183 - 0.9500952586944215872e-2 * t278 * t920 + 0.39587302445600899466e-3 * t2082 + 0.2375238146736053968e-2 * t2084 - t2091 - 0.1187619073368026984e-2 * t2094 - 0.4750476293472107936e-2 * t2098 - 0.39587302445600899466e-3 * t2103 - 0.79174604891201798933e-3 * t1412 * t157 - t2194;
  t2197 = my_piecewise3(t1, 0, t2165 + t2195);
  tv4rho3sigma3 = t4 * t2197 + t2135 + t959;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t2199 = 0.2e1 * t1033;
  t2201 = 0.2375238146736053968e-2 * t305 * t1012;
  t2204 = t138 * t203 * t141 * t62;
  t2215 = 0.13427712088436599629e-3 * t699 * t456;
  t2216 = t702 * t456;
  t2218 = t699 * t447;
  t2220 = t702 * t447;
  t2223 = 0.44759040294788665432e-4 * t1672 * t169;
  t2224 = t1675 * t169;
  t2226 = t2201 - 0.593809536684013492e-3 * t2204 - 0.56530667892318084439e-6 * t696 * t447 + 0.44759040294788665431e-4 * t1669 * t169 - 0.13427712088436599629e-3 * t696 * t456 + 0.31957954770479107118e-7 * t696 * t453 - t2215 + 0.33569280221091499072e-4 * t2216 - 0.5653066789231808444e-6 * t2218 + 0.1413266697307952111e-6 * t2220 + t2223 - 0.11189760073697166358e-4 * t2224;
  t2232 = 0.31957954770479107118e-7 * t699 * t453;
  t2233 = t702 * t453;
  t2238 = 0.79174604891201798932e-3 * t769 * t421;
  t2239 = t354 * t967;
  t2243 = -0.79174604891201798933e-3 * t1668 * t166 + 0.2375238146736053968e-2 * t695 * t441 + t2232 - 0.79894886926197767795e-8 * t2233 + t2131 + 0.22379520147394332716e-4 * t2126 - 0.22379520147394332716e-4 * t2128 - t2238 + 0.19793651222800449733e-3 * t2239 - 0.39587302445600899466e-3 * t2116 + 0.39587302445600899466e-3 * t2118 - t2123;
  t2245 = my_piecewise3(t42, 0, t2226 + t2243);
  tv4rho3sigma5 = t4 * t2245 + t2199 + t977;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t2247 = t735 * t391;
  t2259 = t1582 * t160;
  t2265 = -0.39587302445600899466e-3 * t2247 + 0.2375238146736053968e-2 * t735 * t395 - 0.56530667892318084439e-6 * t736 * t401 + 0.44759040294788665431e-4 * t1579 * t160 - 0.13427712088436599629e-3 * t736 * t412 + 0.31957954770479107118e-7 * t736 * t409 + 0.22379520147394332716e-4 * t2259 - 0.79174604891201798933e-3 * t1578 * t157 + t2153 - 0.22379520147394332716e-4 * t2156 - 0.1342771208843659963e-3 * t2158 + t2171;
  t2273 = t2045 + 0.33569280221091499074e-4 * t2046 - 0.79894886926197767796e-8 * t2072 - t2194 + 0.39587302445600899466e-3 * t2180 + t2183 - t2143 - 0.11189760073697166358e-4 * t2022 + 0.19793651222800449733e-3 * t2082 - t2091 - 0.59380953668401349199e-3 * t2094 + 0.1413266697307952111e-6 * t2038;
  t2275 = my_piecewise3(t1, 0, t2265 + t2273);
  tv4rho3sigma6 = t4 * t2275 + t1043 + t2135;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t2277 = t309 * t1075;
  t2279 = t1765 * t169;
  t2281 = t773 * t456;
  t2283 = t309 * t1056;
  t2285 = t773 * t447;
  t2287 = t309 * t1071;
  t2306 = -0.30272172656336334217e-9 * t2277 + 0.22379520147394332716e-4 * t2279 - 0.13427712088436599629e-3 * t2281 + 0.26855424176873199258e-3 * t2283 - 0.5653066789231808444e-6 * t2285 + 0.2826533394615904222e-5 * t2287 - 0.11306133578463616888e-5 * t770 * t447 + 0.56530667892318084439e-5 * t306 * t1071 - 0.60544345312672668434e-9 * t306 * t1075 + 0.44759040294788665431e-4 * t1777 * t169 - 0.26855424176873199258e-3 * t770 * t456 + 0.53710848353746398516e-3 * t306 * t1056 - t2215 + 0.67138560442182998145e-4 * t2216 - 0.56530667892318084439e-6 * t2218 + 0.2826533394615904222e-6 * t2220 + t2223 - 0.22379520147394332716e-4 * t2224 - 0.11189760073697166358e-4 * t2128 + t2131;
  t2313 = t309 * t1083;
  t2315 = t773 * t453;
  t2317 = t309 * t1053;
  t2322 = t354 * t1012;
  t2326 = t138 * t79 * t363 * t62;
  t2328 = t826 * t421;
  t2337 = -0.31957954770479107118e-6 * t306 * t1083 + 0.63915909540958214236e-7 * t770 * t453 + 0.34226969559183123723e-10 * t306 * t1053 - 0.15978977385239553559e-6 * t2313 + 0.31957954770479107118e-7 * t2315 + 0.17113484779591561862e-10 * t2317 + t2232 - 0.15978977385239553559e-7 * t2233 + t2201 - 0.1187619073368026984e-2 * t2204 - t2238 + 0.39587302445600899466e-3 * t2239 + 0.2375238146736053968e-2 * t2322 - 0.4750476293472107936e-2 * t2326 - 0.39587302445600899466e-3 * t2328 - 0.9500952586944215872e-2 * t305 * t1067 - 0.79174604891201798933e-3 * t1776 * t166 + 0.4750476293472107936e-2 * t769 * t441 + 0.19793651222800449733e-3 * t2118 - t2123;
  t2339 = my_piecewise3(t42, 0, t2306 + t2337);
  tv4rho3sigma8 = t4 * t2339 + t1090 + t2199;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t2351 = my_piecewise3(t1, 0, -0.79174604891201798933e-3 * t1746 * t157 - 0.1187619073368026984e-2 * t2247 + 0.59380953668401349199e-3 * t2180 - t2091 + 0.44759040294788665431e-4 * t1747 * t160 + 0.67138560442182998148e-4 * t2259 - 0.33569280221091499074e-4 * t2156 + t2045);
  tv4rho3sigma9 = t4 * t2351 + 0.3e1 * t1043;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t2362 = 0.1e1 / t369 / t444 * t838;
  t2366 = t833 * sigma[2];
  t2400 = -0.95873864311437321353e-6 * t355 * t1083 + 0.95873864311437321354e-7 * t827 * t453 + 0.10268090867754937117e-9 * t355 * t1053 + 0.48876112530513500676e-13 * t139 * t1967 * t2362 + 0.29401318388840778548e-5 * t139 * t377 * t2366 - 0.71876636074284559818e-9 * t139 * t879 * t840 * t368 - 0.52008214460932637684e-4 * t139 * t2366 * t147 + 0.16113254506123919555e-2 * t355 * t1056 - 0.26855424176873199258e-2 * t139 * t148 * t474 - 0.90816517969009002651e-9 * t2277 + 0.67138560442182998148e-4 * t2279 - 0.40283136265309798888e-3 * t2281 + 0.80566272530619597774e-3 * t2283 - 0.16959200367695425332e-5 * t2285 + 0.84796001838477126659e-5 * t2287 - 0.16959200367695425332e-5 * t827 * t447 + 0.12714312515661260372e-7 * t139 * t840 * t376 * t368 + 0.44759040294788665431e-4 * t1904 * t169 - 0.40283136265309798887e-3 * t827 * t456 + 0.16959200367695425332e-4 * t355 * t1071;
  t2427 = -0.1816330359380180053e-8 * t355 * t1075 - 0.86457325106496570524e-12 * t139 * t2362 * t878 + 0.10070784066327449722e-3 * t2216 + 0.4239800091923856333e-6 * t2220 - 0.33569280221091499074e-4 * t2224 + t2131 - 0.47936932155718660677e-6 * t2313 + 0.95873864311437321354e-7 * t2315 + 0.51340454338774685585e-10 * t2317 - 0.23968466077859330339e-7 * t2233 - 0.28502857760832647616e-1 * t354 * t1067 + 0.4750476293472107936e-1 * t138 * t475 * t62 + 0.7125714440208161904e-2 * t826 * t441 - 0.79174604891201798933e-3 * t1903 * t166 - 0.1781428610052040476e-2 * t2204 + 0.59380953668401349199e-3 * t2239 + 0.7125714440208161904e-2 * t2322 - 0.14251428880416323808e-1 * t2326 - 0.1187619073368026984e-2 * t2328 - t2123;
  t2429 = my_piecewise3(t42, 0, t2400 + t2427);
  tv4rho3sigma11 = t4 * t2429 + 0.3e1 * t1090;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  t2435 = 0.26631628975399255932e-8 * t494 * t468;
  t2436 = t208 * t1116;
  t2438 = t208 * t1113;
  t2441 = 0.1e1 / t220 / t462;
  t2449 = t522 * t468;
  t2453 = t196 * t1095;
  t2462 = 0.47108889910265070365e-7 * t84 * t203 * t463 * t93;
  t2465 = t84 * t79 * t399 * t93;
  t2467 = t208 * t1105;
  t2488 = -0.22817979706122082482e-10 * t197 * t1113 + t2435 + 0.63915909540958214238e-7 * t2436 - 0.11408989853061041241e-10 * t2438 - 0.16292037510171166892e-13 * t85 * t1288 * t2441 * t219 - 0.44741136678670749967e-6 * t85 * t228 * t221 - 0.10652651590159702373e-7 * t2449 + 0.12783181908191642848e-6 * t197 * t1116 + 0.18843555964106028146e-6 * t2453 - 0.22612267156927233776e-5 * t196 * t1099 + 0.40362896875115112288e-9 * t197 * t1105 - t2462 - 0.11306133578463616888e-5 * t2465 + 0.20181448437557556144e-9 * t2467 + 0.79142935049245318216e-5 * t84 * t27 * t221 * t93 - 0.32290317500092089831e-8 * t85 * t929 * sigma[0] + 0.28819108368832190174e-12 * t85 * t2441 * t506 * t219 - 0.10652651590159702373e-7 * t517 * t468 + 0.18843555964106028146e-6 * t516 * t465 + 0.18254383764897665986e-9 * t85 * t507 * t928 * sigma[0];
  t2489 = my_piecewise3(t1, 0, t2488);
  tv4rho2sigma20 = t4 * t2489 + 0.2e1 * t1120;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t2494 = t305 * t1125;
  t2499 = 0.47108889910265070365e-7 * t138 * t203 * t474 * t147;
  t2502 = t699 * t479;
  t2505 = 0.26631628975399255932e-8 * t702 * t479;
  t2507 = my_piecewise3(t42, 0, 0.18843555964106028146e-6 * t695 * t476 + 0.18843555964106028146e-6 * t2494 - t2499 - 0.10652651590159702373e-7 * t696 * t479 - 0.10652651590159702373e-7 * t2502 + t2505);
  tv4rho2sigma25 = t4 * t2507 + 0.2e1 * t1133;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t2511 = t278 * t1095;
  t2522 = t621 * t468;
  t2531 = 0.18843555964106028146e-6 * t615 * t465 + 0.9421777982053014073e-7 * t2511 - 0.11306133578463616888e-5 * t278 * t1099 + 0.20181448437557556144e-9 * t279 * t1105 + 0.9421777982053014073e-7 * t2453 - t2462 - 0.56530667892318084438e-6 * t2465 + 0.10090724218778778072e-9 * t2467 - 0.10652651590159702373e-7 * t616 * t468 - 0.53263257950798511865e-8 * t2522 - 0.11408989853061041241e-10 * t279 * t1113 + 0.63915909540958214238e-7 * t279 * t1116 - 0.53263257950798511865e-8 * t2449 + t2435 - 0.57044949265305206207e-11 * t2438 + 0.31957954770479107119e-7 * t2436;
  t2532 = my_piecewise3(t1, 0, t2531);
  tv4rho2sigma26 = t4 * t2532 + t1120 + t1140;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t2536 = t354 * t1125;
  t2543 = t138 * t79 * t445 * t147;
  t2547 = t309 * t1151;
  t2551 = t773 * t479;
  t2556 = t309 * t1157;
  t2560 = t309 * t1160;
  t2562 = 0.18843555964106028146e-6 * t769 * t476 + 0.9421777982053014073e-7 * t2536 + 0.9421777982053014073e-7 * t2494 - t2499 - 0.11306133578463616888e-5 * t305 * t1145 - 0.5653066789231808444e-6 * t2543 + 0.20181448437557556144e-9 * t306 * t1151 + 0.10090724218778778072e-9 * t2547 - 0.10652651590159702373e-7 * t770 * t479 - 0.53263257950798511865e-8 * t2551 - 0.53263257950798511865e-8 * t2502 + t2505 - 0.11408989853061041241e-10 * t306 * t1157 - 0.57044949265305206205e-11 * t2556 + 0.63915909540958214238e-7 * t306 * t1160 + 0.31957954770479107119e-7 * t2560;
  t2563 = my_piecewise3(t42, 0, t2562);
  tv4rho2sigma211 = t4 * t2563 + t1133 + t1164;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t2573 = my_piecewise3(t1, 0, 0.18843555964106028146e-6 * t735 * t465 + 0.18843555964106028146e-6 * t2511 - t2462 - 0.10652651590159702373e-7 * t736 * t468 - 0.10652651590159702373e-7 * t2522 + t2435);
  tv4rho2sigma212 = t4 * t2573 + 0.2e1 * t1140;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t2582 = 0.1e1 / t369 / t473;
  t2618 = 0.18254383764897665986e-9 * t139 * t879 * t1051 * sigma[2] - 0.11408989853061041241e-10 * t2556 + 0.28819108368832190174e-12 * t139 * t2582 * t878 * t368 - 0.10652651590159702373e-7 * t827 * t479 - 0.22612267156927233776e-5 * t354 * t1145 + 0.40362896875115112288e-9 * t355 * t1151 + 0.79142935049245318216e-5 * t138 * t27 * t370 * t147 - 0.32290317500092089831e-8 * t139 * t1074 * sigma[2] - 0.11306133578463616888e-5 * t2543 + 0.18843555964106028146e-6 * t2536 - t2499 + 0.12783181908191642848e-6 * t355 * t1160 - 0.22817979706122082482e-10 * t355 * t1157 - 0.16292037510171166892e-13 * t139 * t1967 * t2582 * t368 - 0.44741136678670749967e-6 * t139 * t377 * t370 + 0.20181448437557556144e-9 * t2547 - 0.10652651590159702373e-7 * t2551 + 0.63915909540958214238e-7 * t2560 + t2505 + 0.18843555964106028146e-6 * t826 * t476;
  t2619 = my_piecewise3(t42, 0, t2618);
  tv4rho2sigma217 = t4 * t2619 + 0.2e1 * t1164;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  t2626 = 0.33635747395929260241e-10 * t84 * t79 * t531 * t227;
  t2638 = 0.19014983088435068736e-11 * t208 * t1170;
  t2647 = my_piecewise3(t1, 0, -0.67271494791858520482e-10 * t196 * t1167 - t2626 + 0.60544345312672668434e-9 * t84 * t27 * t1103 * t227 - 0.9606369456277396725e-13 * t85 * t1229 * t506 * sigma[0] + 0.38029966176870137472e-11 * t197 * t1170 + t2638 + 0.5430679170057055631e-14 * t85 * t1288 * t1229 * sigma[0] - 0.34226969559183123725e-10 * t85 * t507 * t1103);
  tv4rhosigma30 = t4 * t2647 + t1174;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t2654 = 0.33635747395929260241e-10 * t138 * t79 * t833 * t376;
  t2658 = 0.19014983088435068736e-11 * t309 * t1179;
  t2660 = my_piecewise3(t42, 0, -0.67271494791858520482e-10 * t305 * t1176 - t2654 + 0.38029966176870137472e-11 * t306 * t1179 + t2658);
  tv4rhosigma39 = t4 * t2660 + t1183;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t2667 = my_piecewise3(t1, 0, -0.67271494791858520482e-10 * t278 * t1167 - t2626 + 0.38029966176870137472e-11 * t279 * t1170 + t2638);
  tv4rhosigma310 = t4 * t2667 + t1174;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t2689 = my_piecewise3(t42, 0, -0.67271494791858520482e-10 * t354 * t1176 - t2654 + 0.60544345312672668434e-9 * t138 * t27 * t1149 * t376 - 0.9606369456277396725e-13 * t139 * t1912 * t878 * sigma[2] + 0.38029966176870137472e-11 * t355 * t1179 + t2658 + 0.5430679170057055631e-14 * t139 * t1967 * t1912 * sigma[2] - 0.34226969559183123725e-10 * t139 * t879 * t1149);
  tv4rhosigma319 = t4 * t2689 + t1183;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  t2699 = my_piecewise3(t1, 0, 0.3202123152092465575e-13 * t84 * t27 * t510 * t506 - 0.18102263900190185437e-14 * t85 * t1288 * t510);
  tv4sigma40 = t4 * t2699;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t2708 = my_piecewise3(t42, 0, 0.3202123152092465575e-13 * t138 * t27 * t840 * t878 - 0.18102263900190185437e-14 * t139 * t1967 * t840);
  tv4sigma414 = t4 * t2708;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

}

#endif

