; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512FVEC512
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512FVEC256
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX512DQVEC512
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512dq,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512DQVEC256
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw | FileCheck %s --check-prefixes=AVX512BWVEC512
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512BWVEC256
;
; RUN: opt < %s -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mcpu=slm | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mcpu=goldmont | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mcpu=btver2 | FileCheck %s --check-prefixes=BTVER2

define i32 @trunc_vXi32() "min-legal-vector-width"="256" {
; SSE-LABEL: 'trunc_vXi32'
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; SSE-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'trunc_vXi32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'trunc_vXi32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'trunc_vXi32'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'trunc_vXi32'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'trunc_vXi32'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'trunc_vXi32'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'trunc_vXi32'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'trunc_vXi32'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'trunc_vXi32'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i32
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %i64 = trunc i64 undef to i32
  %V2i64 = trunc <2 x i64> undef to <2 x i32>
  %V4i64 = trunc <4 x i64> undef to <4 x i32>
  %V8i64 = trunc <8 x i64> undef to <8 x i32>
  %V16i64 = trunc <16 x i64> undef to <16 x i32>
  ret i32 undef
}

define i32 @trunc_vXi16() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'trunc_vXi16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'trunc_vXi16'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'trunc_vXi16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'trunc_vXi16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 208 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 416 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'trunc_vXi16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 336 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 672 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'trunc_vXi16'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'trunc_vXi16'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 336 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 672 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'trunc_vXi16'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'trunc_vXi16'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 336 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 672 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'trunc_vXi16'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'trunc_vXi16'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 336 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 672 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'trunc_vXi16'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i16
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 208 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 416 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i16
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 31 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 37 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 51 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 73 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 101 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 126 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 143 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 210 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 252 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 294 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 420 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 504 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 588 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 840 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1008 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1176 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %i64 = trunc i64 undef to i16
  %V2i64 = trunc <2 x i64> undef to <2 x i16>
  %V3i64 = trunc <3 x i64> undef to <3 x i16>
  %V4i64 = trunc <4 x i64> undef to <4 x i16>
  %V5i64 = trunc <5 x i64> undef to <5 x i16>
  %V6i64 = trunc <6 x i64> undef to <6 x i16>
  %V7i64 = trunc <7 x i64> undef to <7 x i16>
  %V8i64 = trunc <8 x i64> undef to <8 x i16>
  %V10i64 = trunc <10 x i64> undef to <10 x i16>
  %V12i64 = trunc <12 x i64> undef to <12 x i16>
  %V14i64 = trunc <14 x i64> undef to <14 x i16>
  %V16i64 = trunc <16 x i64> undef to <16 x i16>
  %V20i64 = trunc <20 x i64> undef to <20 x i16>
  %V24i64 = trunc <24 x i64> undef to <24 x i16>
  %V28i64 = trunc <28 x i64> undef to <28 x i16>
  %V32i64 = trunc <32 x i64> undef to <32 x i16>
  %V40i64 = trunc <40 x i64> undef to <40 x i16>
  %V48i64 = trunc <48 x i64> undef to <48 x i16>
  %V56i64 = trunc <56 x i64> undef to <56 x i16>
  %V64i64 = trunc <64 x i64> undef to <64 x i16>
  %V80i64 = trunc <80 x i64> undef to <80 x i16>
  %V96i64 = trunc <96 x i64> undef to <96 x i16>
  %V112i64 = trunc <112 x i64> undef to <112 x i16>
  %V128i64 = trunc <128 x i64> undef to <128 x i16>
  %V160i64 = trunc <160 x i64> undef to <160 x i16>
  %V192i64 = trunc <192 x i64> undef to <192 x i16>
  %V224i64 = trunc <224 x i64> undef to <224 x i16>
  %V256i64 = trunc <256 x i64> undef to <256 x i16>
  %V320i64 = trunc <320 x i64> undef to <320 x i16>
  %V384i64 = trunc <384 x i64> undef to <384 x i16>
  %V448i64 = trunc <448 x i64> undef to <448 x i16>
  %V512i64 = trunc <512 x i64> undef to <512 x i16>

  %i32 = trunc i32 undef to i16
  %V2i32 = trunc <2 x i32> undef to <2 x i16>
  %V3i32 = trunc <3 x i32> undef to <3 x i16>
  %V4i32 = trunc <4 x i32> undef to <4 x i16>
  %V5i32 = trunc <5 x i32> undef to <5 x i16>
  %V6i32 = trunc <6 x i32> undef to <6 x i16>
  %V7i32 = trunc <7 x i32> undef to <7 x i16>
  %V8i32 = trunc <8 x i32> undef to <8 x i16>
  %V10i32 = trunc <10 x i32> undef to <10 x i16>
  %V12i32 = trunc <12 x i32> undef to <12 x i16>
  %V14i32 = trunc <14 x i32> undef to <14 x i16>
  %V16i32 = trunc <16 x i32> undef to <16 x i16>
  %V20i32 = trunc <20 x i32> undef to <20 x i16>
  %V24i32 = trunc <24 x i32> undef to <24 x i16>
  %V28i32 = trunc <28 x i32> undef to <28 x i16>
  %V32i32 = trunc <32 x i32> undef to <32 x i16>
  %V40i32 = trunc <40 x i32> undef to <40 x i16>
  %V48i32 = trunc <48 x i32> undef to <48 x i16>
  %V56i32 = trunc <56 x i32> undef to <56 x i16>
  %V64i32 = trunc <64 x i32> undef to <64 x i16>
  %V80i32 = trunc <80 x i32> undef to <80 x i16>
  %V96i32 = trunc <96 x i32> undef to <96 x i16>
  %V112i32 = trunc <112 x i32> undef to <112 x i16>
  %V128i32 = trunc <128 x i32> undef to <128 x i16>
  %V160i32 = trunc <160 x i32> undef to <160 x i16>
  %V192i32 = trunc <192 x i32> undef to <192 x i16>
  %V224i32 = trunc <224 x i32> undef to <224 x i16>
  %V256i32 = trunc <256 x i32> undef to <256 x i16>
  %V320i32 = trunc <320 x i32> undef to <320 x i16>
  %V384i32 = trunc <384 x i32> undef to <384 x i16>
  %V448i32 = trunc <448 x i32> undef to <448 x i16>
  %V512i32 = trunc <512 x i32> undef to <512 x i16>

  ret i32 undef
}

define i32 @trunc_vXi8() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'trunc_vXi8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'trunc_vXi8'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'trunc_vXi8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'trunc_vXi8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 82 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 164 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 328 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 656 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1312 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 208 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 416 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'trunc_vXi8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 132 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 264 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 528 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1056 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 288 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'trunc_vXi8'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'trunc_vXi8'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 132 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 264 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 528 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1056 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 288 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'trunc_vXi8'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'trunc_vXi8'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 132 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 264 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 528 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1056 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 288 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'trunc_vXi8'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'trunc_vXi8'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 132 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 264 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 528 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1056 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 288 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'trunc_vXi8'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i8
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 41 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 82 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 164 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 328 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 656 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1312 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i8
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 104 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 208 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 416 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i8
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 246 for instruction: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %i64 = trunc i64 undef to i8
  %V2i64 = trunc <2 x i64> undef to <2 x i8>
  %V4i64 = trunc <4 x i64> undef to <4 x i8>
  %V6i64 = trunc <6 x i64> undef to <6 x i8>
  %V8i64 = trunc <8 x i64> undef to <8 x i8>
  %V10i64 = trunc <10 x i64> undef to <10 x i8>
  %V12i64 = trunc <12 x i64> undef to <12 x i8>
  %V14i64 = trunc <14 x i64> undef to <14 x i8>
  %V16i64 = trunc <16 x i64> undef to <16 x i8>
  %V20i64 = trunc <20 x i64> undef to <20 x i8>
  %V24i64 = trunc <24 x i64> undef to <24 x i8>
  %V28i64 = trunc <28 x i64> undef to <28 x i8>
  %V32i64 = trunc <32 x i64> undef to <32 x i8>
  %V40i64 = trunc <40 x i64> undef to <40 x i8>
  %V48i64 = trunc <48 x i64> undef to <48 x i8>
  %V56i64 = trunc <56 x i64> undef to <56 x i8>
  %V64i64 = trunc <64 x i64> undef to <64 x i8>
  %V80i64 = trunc <80 x i64> undef to <80 x i8>
  %V96i64 = trunc <96 x i64> undef to <96 x i8>
  %V112i64 = trunc <112 x i64> undef to <112 x i8>
  %V128i64 = trunc <128 x i64> undef to <128 x i8>
  %V160i64 = trunc <160 x i64> undef to <160 x i8>
  %V192i64 = trunc <192 x i64> undef to <192 x i8>
  %V224i64 = trunc <224 x i64> undef to <224 x i8>
  %V256i64 = trunc <256 x i64> undef to <256 x i8>
  %V320i64 = trunc <320 x i64> undef to <320 x i8>
  %V384i64 = trunc <384 x i64> undef to <384 x i8>
  %V448i64 = trunc <448 x i64> undef to <448 x i8>
  %V512i64 = trunc <512 x i64> undef to <512 x i8>
  %V640i64 = trunc <640 x i64> undef to <640 x i8>
  %V768i64 = trunc <768 x i64> undef to <768 x i8>
  %V896i64 = trunc <896 x i64> undef to <896 x i8>
  %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>

  %i32 = trunc i32 undef to i8
  %V2i32 = trunc <2 x i32> undef to <2 x i8>
  %V4i32 = trunc <4 x i32> undef to <4 x i8>
  %V6i32 = trunc <6 x i32> undef to <6 x i8>
  %V8i32 = trunc <8 x i32> undef to <8 x i8>
  %V10i32 = trunc <10 x i32> undef to <10 x i8>
  %V12i32 = trunc <12 x i32> undef to <12 x i8>
  %V14i32 = trunc <14 x i32> undef to <14 x i8>
  %V16i32 = trunc <16 x i32> undef to <16 x i8>
  %V20i32 = trunc <20 x i32> undef to <20 x i8>
  %V24i32 = trunc <24 x i32> undef to <24 x i8>
  %V28i32 = trunc <28 x i32> undef to <28 x i8>
  %V32i32 = trunc <32 x i32> undef to <32 x i8>
  %V40i32 = trunc <40 x i32> undef to <40 x i8>
  %V48i32 = trunc <48 x i32> undef to <48 x i8>
  %V56i32 = trunc <56 x i32> undef to <56 x i8>
  %V64i32 = trunc <64 x i32> undef to <64 x i8>
  %V80i32 = trunc <80 x i32> undef to <80 x i8>
  %V96i32 = trunc <96 x i32> undef to <96 x i8>
  %V112i32 = trunc <112 x i32> undef to <112 x i8>
  %V128i32 = trunc <128 x i32> undef to <128 x i8>
  %V160i32 = trunc <160 x i32> undef to <160 x i8>
  %V192i32 = trunc <192 x i32> undef to <192 x i8>
  %V224i32 = trunc <224 x i32> undef to <224 x i8>
  %V256i32 = trunc <256 x i32> undef to <256 x i8>
  %V320i32 = trunc <320 x i32> undef to <320 x i8>
  %V384i32 = trunc <384 x i32> undef to <384 x i8>
  %V448i32 = trunc <448 x i32> undef to <448 x i8>
  %V512i32 = trunc <512 x i32> undef to <512 x i8>
  %V640i32 = trunc <640 x i32> undef to <640 x i8>
  %V768i32 = trunc <768 x i32> undef to <768 x i8>
  %V896i32 = trunc <896 x i32> undef to <896 x i8>
  %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>

  %i16 = trunc i16 undef to i8
  %V2i16 = trunc <2 x i16> undef to <2 x i8>
  %V4i16 = trunc <4 x i16> undef to <4 x i8>
  %V6i16 = trunc <6 x i16> undef to <6 x i8>
  %V8i16 = trunc <8 x i16> undef to <8 x i8>
  %V10i16 = trunc <10 x i16> undef to <10 x i8>
  %V12i16 = trunc <12 x i16> undef to <12 x i8>
  %V14i16 = trunc <14 x i16> undef to <14 x i8>
  %V16i16 = trunc <16 x i16> undef to <16 x i8>
  %V20i16 = trunc <20 x i16> undef to <20 x i8>
  %V24i16 = trunc <24 x i16> undef to <24 x i8>
  %V28i16 = trunc <28 x i16> undef to <28 x i8>
  %V32i16 = trunc <32 x i16> undef to <32 x i8>
  %V40i16 = trunc <40 x i16> undef to <40 x i8>
  %V48i16 = trunc <48 x i16> undef to <48 x i8>
  %V56i16 = trunc <56 x i16> undef to <56 x i8>
  %V64i16 = trunc <64 x i16> undef to <64 x i8>
  %V80i16 = trunc <80 x i16> undef to <80 x i8>
  %V96i16 = trunc <96 x i16> undef to <96 x i8>
  %V112i16 = trunc <112 x i16> undef to <112 x i8>
  %V128i16 = trunc <128 x i16> undef to <128 x i8>
  %V160i16 = trunc <160 x i16> undef to <160 x i8>
  %V192i16 = trunc <192 x i16> undef to <192 x i8>
  %V224i16 = trunc <224 x i16> undef to <224 x i8>
  %V256i16 = trunc <256 x i16> undef to <256 x i8>
  %V320i16 = trunc <320 x i16> undef to <320 x i8>
  %V384i16 = trunc <384 x i16> undef to <384 x i8>
  %V448i16 = trunc <448 x i16> undef to <448 x i8>
  %V512i16 = trunc <512 x i16> undef to <512 x i8>
  %V640i16 = trunc <640 x i16> undef to <640 x i8>
  %V768i16 = trunc <768 x i16> undef to <768 x i8>
  %V896i16 = trunc <896 x i16> undef to <896 x i8>
  %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>

  ret i32 undef
}

define i32 @trunc_vXi1() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'trunc_vXi1'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSSE3-LABEL: 'trunc_vXi1'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2048 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SSE42-LABEL: 'trunc_vXi1'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1024 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX1-LABEL: 'trunc_vXi1'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 184 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 368 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 736 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 336 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 672 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 288 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX2-LABEL: 'trunc_vXi1'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 184 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 368 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 736 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 288 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC512-LABEL: 'trunc_vXi1'
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 176 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 352 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 704 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 60 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 120 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 240 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512FVEC256-LABEL: 'trunc_vXi1'
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 176 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 352 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 704 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'trunc_vXi1'
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 30 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 60 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 120 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 240 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'trunc_vXi1'
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 256 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 512 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'trunc_vXi1'
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 94 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 188 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 376 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 752 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 176 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'trunc_vXi1'
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 94 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 188 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 376 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 752 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 320 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 384 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 448 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 640 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 768 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 896 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 184 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1280 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1536 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 1792 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 368 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; BTVER2-LABEL: 'trunc_vXi1'
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i64 = trunc i64 undef to i1
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 92 for instruction: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 184 for instruction: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 368 for instruction: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 736 for instruction: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i32 = trunc i32 undef to i1
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 84 for instruction: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 168 for instruction: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 336 for instruction: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 672 for instruction: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i16 = trunc i16 undef to i1
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 59 for instruction: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 71 for instruction: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 99 for instruction: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 115 for instruction: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 141 for instruction: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 197 for instruction: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 279 for instruction: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 410 for instruction: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 492 for instruction: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 574 for instruction: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 72 for instruction: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 820 for instruction: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 984 for instruction: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1148 for instruction: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 144 for instruction: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1640 for instruction: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1968 for instruction: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 2296 for instruction: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 288 for instruction: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %i8 = trunc i8 undef to i1
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; BTVER2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %i64 = trunc i64 undef to i1
  %V2i64 = trunc <2 x i64> undef to <2 x i1>
  %V3i64 = trunc <3 x i64> undef to <3 x i1>
  %V4i64 = trunc <4 x i64> undef to <4 x i1>
  %V5i64 = trunc <5 x i64> undef to <5 x i1>
  %V6i64 = trunc <6 x i64> undef to <6 x i1>
  %V7i64 = trunc <7 x i64> undef to <7 x i1>
  %V8i64 = trunc <8 x i64> undef to <8 x i1>
  %V10i64 = trunc <10 x i64> undef to <10 x i1>
  %V12i64 = trunc <12 x i64> undef to <12 x i1>
  %V14i64 = trunc <14 x i64> undef to <14 x i1>
  %V16i64 = trunc <16 x i64> undef to <16 x i1>
  %V20i64 = trunc <20 x i64> undef to <20 x i1>
  %V24i64 = trunc <24 x i64> undef to <24 x i1>
  %V28i64 = trunc <28 x i64> undef to <28 x i1>
  %V32i64 = trunc <32 x i64> undef to <32 x i1>
  %V40i64 = trunc <40 x i64> undef to <40 x i1>
  %V48i64 = trunc <48 x i64> undef to <48 x i1>
  %V56i64 = trunc <56 x i64> undef to <56 x i1>
  %V64i64 = trunc <64 x i64> undef to <64 x i1>
  %V80i64 = trunc <80 x i64> undef to <80 x i1>
  %V112i64 = trunc <112 x i64> undef to <112 x i1>
  %V128i64 = trunc <128 x i64> undef to <128 x i1>
  %V160i64 = trunc <160 x i64> undef to <160 x i1>
  %V192i64 = trunc <192 x i64> undef to <192 x i1>
  %V224i64 = trunc <224 x i64> undef to <224 x i1>
  %V256i64 = trunc <256 x i64> undef to <256 x i1>
  %V320i64 = trunc <320 x i64> undef to <320 x i1>
  %V384i64 = trunc <384 x i64> undef to <384 x i1>
  %V448i64 = trunc <448 x i64> undef to <448 x i1>
  %V512i64 = trunc <512 x i64> undef to <512 x i1>
  %V640i64 = trunc <640 x i64> undef to <640 x i1>
  %V768i64 = trunc <768 x i64> undef to <768 x i1>
  %V896i64 = trunc <896 x i64> undef to <896 x i1>
  %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>

  %i32 = trunc i32 undef to i1
  %V2i32 = trunc <2 x i32> undef to <2 x i1>
  %V3i32 = trunc <3 x i32> undef to <3 x i1>
  %V4i32 = trunc <4 x i32> undef to <4 x i1>
  %V5i32 = trunc <5 x i32> undef to <5 x i1>
  %V6i32 = trunc <6 x i32> undef to <6 x i1>
  %V7i32 = trunc <7 x i32> undef to <7 x i1>
  %V8i32 = trunc <8 x i32> undef to <8 x i1>
  %V10i32 = trunc <10 x i32> undef to <10 x i1>
  %V12i32 = trunc <12 x i32> undef to <12 x i1>
  %V14i32 = trunc <14 x i32> undef to <14 x i1>
  %V16i32 = trunc <16 x i32> undef to <16 x i1>
  %V20i32 = trunc <20 x i32> undef to <20 x i1>
  %V24i32 = trunc <24 x i32> undef to <24 x i1>
  %V28i32 = trunc <28 x i32> undef to <28 x i1>
  %V32i32 = trunc <32 x i32> undef to <32 x i1>
  %V40i32 = trunc <40 x i32> undef to <40 x i1>
  %V48i32 = trunc <48 x i32> undef to <48 x i1>
  %V56i32 = trunc <56 x i32> undef to <56 x i1>
  %V64i32 = trunc <64 x i32> undef to <64 x i1>
  %V80i32 = trunc <80 x i32> undef to <80 x i1>
  %V112i32 = trunc <112 x i32> undef to <112 x i1>
  %V128i32 = trunc <128 x i32> undef to <128 x i1>
  %V160i32 = trunc <160 x i32> undef to <160 x i1>
  %V192i32 = trunc <192 x i32> undef to <192 x i1>
  %V224i32 = trunc <224 x i32> undef to <224 x i1>
  %V256i32 = trunc <256 x i32> undef to <256 x i1>
  %V320i32 = trunc <320 x i32> undef to <320 x i1>
  %V384i32 = trunc <384 x i32> undef to <384 x i1>
  %V448i32 = trunc <448 x i32> undef to <448 x i1>
  %V512i32 = trunc <512 x i32> undef to <512 x i1>
  %V640i32 = trunc <640 x i32> undef to <640 x i1>
  %V768i32 = trunc <768 x i32> undef to <768 x i1>
  %V896i32 = trunc <896 x i32> undef to <896 x i1>
  %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>

  %i16 = trunc i16 undef to i1
  %V2i16 = trunc <2 x i16> undef to <2 x i1>
  %V3i16 = trunc <3 x i16> undef to <3 x i1>
  %V4i16 = trunc <4 x i16> undef to <4 x i1>
  %V5i16 = trunc <5 x i16> undef to <5 x i1>
  %V6i16 = trunc <6 x i16> undef to <6 x i1>
  %V7i16 = trunc <7 x i16> undef to <7 x i1>
  %V8i16 = trunc <8 x i16> undef to <8 x i1>
  %V10i16 = trunc <10 x i16> undef to <10 x i1>
  %V12i16 = trunc <12 x i16> undef to <12 x i1>
  %V14i16 = trunc <14 x i16> undef to <14 x i1>
  %V16i16 = trunc <16 x i16> undef to <16 x i1>
  %V20i16 = trunc <20 x i16> undef to <20 x i1>
  %V24i16 = trunc <24 x i16> undef to <24 x i1>
  %V28i16 = trunc <28 x i16> undef to <28 x i1>
  %V32i16 = trunc <32 x i16> undef to <32 x i1>
  %V40i16 = trunc <40 x i16> undef to <40 x i1>
  %V48i16 = trunc <48 x i16> undef to <48 x i1>
  %V56i16 = trunc <56 x i16> undef to <56 x i1>
  %V64i16 = trunc <64 x i16> undef to <64 x i1>
  %V80i16 = trunc <80 x i16> undef to <80 x i1>
  %V112i16 = trunc <112 x i16> undef to <112 x i1>
  %V128i16 = trunc <128 x i16> undef to <128 x i1>
  %V160i16 = trunc <160 x i16> undef to <160 x i1>
  %V192i16 = trunc <192 x i16> undef to <192 x i1>
  %V224i16 = trunc <224 x i16> undef to <224 x i1>
  %V256i16 = trunc <256 x i16> undef to <256 x i1>
  %V320i16 = trunc <320 x i16> undef to <320 x i1>
  %V384i16 = trunc <384 x i16> undef to <384 x i1>
  %V448i16 = trunc <448 x i16> undef to <448 x i1>
  %V512i16 = trunc <512 x i16> undef to <512 x i1>
  %V640i16 = trunc <640 x i16> undef to <640 x i1>
  %V768i16 = trunc <768 x i16> undef to <768 x i1>
  %V896i16 = trunc <896 x i16> undef to <896 x i1>
  %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>

  %i8 = trunc i8 undef to i1
  %V2i8 = trunc <2 x i8> undef to <2 x i1>
  %V3i8 = trunc <3 x i8> undef to <3 x i1>
  %V4i8 = trunc <4 x i8> undef to <4 x i1>
  %V5i8 = trunc <5 x i8> undef to <5 x i1>
  %V6i8 = trunc <6 x i8> undef to <6 x i1>
  %V7i8 = trunc <7 x i8> undef to <7 x i1>
  %V8i8 = trunc <8 x i8> undef to <8 x i1>
  %V10i8 = trunc <10 x i8> undef to <10 x i1>
  %V12i8 = trunc <12 x i8> undef to <12 x i1>
  %V14i8 = trunc <14 x i8> undef to <14 x i1>
  %V16i8 = trunc <16 x i8> undef to <16 x i1>
  %V20i8 = trunc <20 x i8> undef to <20 x i1>
  %V24i8 = trunc <24 x i8> undef to <24 x i1>
  %V28i8 = trunc <28 x i8> undef to <28 x i1>
  %V32i8 = trunc <32 x i8> undef to <32 x i1>
  %V40i8 = trunc <40 x i8> undef to <40 x i1>
  %V48i8 = trunc <48 x i8> undef to <48 x i1>
  %V56i8 = trunc <56 x i8> undef to <56 x i1>
  %V64i8 = trunc <64 x i8> undef to <64 x i1>
  %V80i8 = trunc <80 x i8> undef to <80 x i1>
  %V112i8 = trunc <112 x i8> undef to <112 x i1>
  %V128i8 = trunc <128 x i8> undef to <128 x i1>
  %V160i8 = trunc <160 x i8> undef to <160 x i1>
  %V192i8 = trunc <192 x i8> undef to <192 x i1>
  %V224i8 = trunc <224 x i8> undef to <224 x i1>
  %V256i8 = trunc <256 x i8> undef to <256 x i1>
  %V320i8 = trunc <320 x i8> undef to <320 x i1>
  %V384i8 = trunc <384 x i8> undef to <384 x i1>
  %V448i8 = trunc <448 x i8> undef to <448 x i1>
  %V512i8 = trunc <512 x i8> undef to <512 x i1>
  %V640i8 = trunc <640 x i8> undef to <640 x i1>
  %V768i8 = trunc <768 x i8> undef to <768 x i1>
  %V896i8 = trunc <896 x i8> undef to <896 x i1>
  %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>

  ret i32 undef
}
