; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases -mattr=+e2 -mattr=+2e3 < %s -mtriple=csky | FileCheck %s

define i32 @ctlz_0(i32 %x) {
; CHECK-LABEL: ctlz_0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ff1.32 a0, a0
; CHECK-NEXT:    rts16
entry:
  %nlz = call i32 @llvm.ctlz.i32(i32 %x, i1 0)
  ret i32 %nlz
}

define i32 @ctlz_1(i32 %x) {
; CHECK-LABEL: ctlz_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ff1.32 a0, a0
; CHECK-NEXT:    rts16
entry:
  %nlz = call i32 @llvm.ctlz.i32(i32 %x, i1 1)
  ret i32 %nlz
}

define i32 @cttz_0(i32 %x) {
; CHECK-LABEL: cttz_0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    brev32 a0, a0
; CHECK-NEXT:    ff1.32 a0, a0
; CHECK-NEXT:    rts16
entry:
  %ntz = call i32 @llvm.cttz.i32(i32 %x, i1 0)
  ret i32 %ntz
}

define i32 @cttz_1(i32 %x) {
; CHECK-LABEL: cttz_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    brev32 a0, a0
; CHECK-NEXT:    ff1.32 a0, a0
; CHECK-NEXT:    rts16
entry:
  %ntz = call i32 @llvm.cttz.i32(i32 %x, i1 1)
  ret i32 %ntz
}

define i32 @bswap(i32 %x) {
; CHECK-LABEL: bswap:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    revb16 a0, a0
; CHECK-NEXT:    rts16
entry:
  %revb32 = call i32 @llvm.bswap.i32(i32 %x)
  ret i32 %revb32
}

define i16 @bswap16(i16 %x) {
; CHECK-LABEL: bswap16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    revb16 a0, a0
; CHECK-NEXT:    lsri16 a0, a0, 16
; CHECK-NEXT:    rts16
entry:
  %revb16 = call i16 @llvm.bswap.i16(i16 %x)
  ret i16 %revb16
}

define i32 @bitreverse_32(i32 %x) {
; CHECK-LABEL: bitreverse_32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    brev32 a0, a0
; CHECK-NEXT:    rts16
entry:
  %brev32 = call i32 @llvm.bitreverse.i32(i32 %x)
  ret i32 %brev32
}

define i16 @bitreverse_16(i16 %x) {
; CHECK-LABEL: bitreverse_16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    brev32 a0, a0
; CHECK-NEXT:    lsri16 a0, a0, 16
; CHECK-NEXT:    rts16
entry:
  %brev = call i16 @llvm.bitreverse.i16(i16 %x)
  ret i16 %brev
}

declare i32 @llvm.bswap.i32(i32)
declare i16 @llvm.bswap.i16(i16)
declare i32 @llvm.ctlz.i32 (i32, i1)
declare i32 @llvm.cttz.i32 (i32, i1)
declare i32 @llvm.bitreverse.i32(i32)
declare i16 @llvm.bitreverse.i16(i16)
