; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch64 --mattr=+lasx --fp-contract=fast < %s \
; RUN:   | FileCheck %s --check-prefix=CONTRACT-FAST
; RUN: llc --mtriple=loongarch64 --mattr=+lasx --fp-contract=on < %s \
; RUN:   | FileCheck %s --check-prefix=CONTRACT-ON
; RUN: llc --mtriple=loongarch64 --mattr=+lasx --fp-contract=off < %s \
; RUN:   | FileCheck %s --check-prefix=CONTRACT-OFF

define void @xvfmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-ON-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-ON-NEXT:    xvfadd.d $xr0, $xr0, $xr1
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-OFF-NEXT:    xvfadd.d $xr0, $xr0, $xr1
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul<4 x double> %v0, %v1
  %add = fadd<4 x double> %mul, %v2
  store <4 x double> %add, ptr %res
  ret void
}

define void @xvfmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-ON-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-ON-NEXT:    xvfsub.d $xr0, $xr0, $xr1
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-OFF-NEXT:    xvfsub.d $xr0, $xr0, $xr1
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul<4 x double> %v0, %v1
  %sub = fsub<4 x double> %mul, %v2
  store <4 x double> %sub, ptr %res
  ret void
}

define void @xvfnmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfnmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfnmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-ON-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-ON-NEXT:    xvfadd.d $xr0, $xr0, $xr1
; CONTRACT-ON-NEXT:    xvbitrevi.d $xr0, $xr0, 63
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfnmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-OFF-NEXT:    xvfadd.d $xr0, $xr0, $xr1
; CONTRACT-OFF-NEXT:    xvbitrevi.d $xr0, $xr0, 63
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul<4 x double> %v0, %v1
  %add = fadd<4 x double> %mul, %v2
  %negadd = fneg<4 x double> %add
  store <4 x double> %negadd, ptr %res
  ret void
}

define void @xvfnmadd_d_nsz(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfnmadd_d_nsz:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfnmadd_d_nsz:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-ON-NEXT:    xvbitrevi.d $xr1, $xr1, 63
; CONTRACT-ON-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-ON-NEXT:    xvfsub.d $xr0, $xr0, $xr1
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfnmadd_d_nsz:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-OFF-NEXT:    xvbitrevi.d $xr1, $xr1, 63
; CONTRACT-OFF-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-OFF-NEXT:    xvfsub.d $xr0, $xr0, $xr1
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv0 = fneg nsz<4 x double> %v0
  %negv2 = fneg nsz<4 x double> %v2
  %mul = fmul nsz<4 x double> %negv0, %v1
  %add = fadd nsz<4 x double> %mul, %negv2
  store <4 x double> %add, ptr %res
  ret void
}

;; Check that xvfnmadd.d is not emitted.
define void @not_xvfnmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: not_xvfnmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvbitrevi.d $xr2, $xr2, 63
; CONTRACT-FAST-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: not_xvfnmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-ON-NEXT:    xvbitrevi.d $xr1, $xr1, 63
; CONTRACT-ON-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-ON-NEXT:    xvfsub.d $xr0, $xr0, $xr1
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: not_xvfnmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-OFF-NEXT:    xvbitrevi.d $xr1, $xr1, 63
; CONTRACT-OFF-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-OFF-NEXT:    xvfsub.d $xr0, $xr0, $xr1
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv0 = fneg<4 x double> %v0
  %negv2 = fneg<4 x double> %v2
  %mul = fmul<4 x double> %negv0, %v1
  %add = fadd<4 x double> %mul, %negv2
  store <4 x double> %add, ptr %res
  ret void
}

define void @xvfnmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfnmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfnmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-ON-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-ON-NEXT:    xvfsub.d $xr0, $xr0, $xr1
; CONTRACT-ON-NEXT:    xvbitrevi.d $xr0, $xr0, 63
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfnmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-OFF-NEXT:    xvfsub.d $xr0, $xr0, $xr1
; CONTRACT-OFF-NEXT:    xvbitrevi.d $xr0, $xr0, 63
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv2 = fneg<4 x double> %v2
  %mul = fmul<4 x double> %v0, %v1
  %add = fadd<4 x double> %mul, %negv2
  %neg = fneg<4 x double> %add
  store <4 x double> %neg, ptr %res
  ret void
}

define void @xvfnmsub_d_nsz(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfnmsub_d_nsz:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfnmsub_d_nsz:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-ON-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-ON-NEXT:    xvfsub.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfnmsub_d_nsz:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-OFF-NEXT:    xvfsub.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv0 = fneg nsz<4 x double> %v0
  %mul = fmul nsz<4 x double> %negv0, %v1
  %add = fadd nsz<4 x double> %mul, %v2
  store <4 x double> %add, ptr %res
  ret void
}

;; Check that xvfnmsub.d is not emitted.
define void @not_xvfnmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: not_xvfnmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvbitrevi.d $xr2, $xr2, 63
; CONTRACT-FAST-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: not_xvfnmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-ON-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-ON-NEXT:    xvfsub.d $xr0, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: not_xvfnmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmul.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a3, 0
; CONTRACT-OFF-NEXT:    xvfsub.d $xr0, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv0 = fneg<4 x double> %v0
  %mul = fmul<4 x double> %negv0, %v1
  %add = fadd<4 x double> %mul, %v2
  store <4 x double> %add, ptr %res
  ret void
}

define void @contract_xvfmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_xvfmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_xvfmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_xvfmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul contract <4 x double> %v0, %v1
  %add = fadd contract <4 x double> %mul, %v2
  store <4 x double> %add, ptr %res
  ret void
}

define void @contract_xvfmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_xvfmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_xvfmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_xvfmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul contract <4 x double> %v0, %v1
  %sub = fsub contract <4 x double> %mul, %v2
  store <4 x double> %sub, ptr %res
  ret void
}

define void @contract_xvfnmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_xvfnmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_xvfnmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_xvfnmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul contract <4 x double> %v0, %v1
  %add = fadd contract <4 x double> %mul, %v2
  %negadd = fneg contract <4 x double> %add
  store <4 x double> %negadd, ptr %res
  ret void
}

define void @contract_xvfnmadd_d_nsz(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_xvfnmadd_d_nsz:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_xvfnmadd_d_nsz:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_xvfnmadd_d_nsz:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv0 = fneg contract nsz<4 x double> %v0
  %negv2 = fneg contract nsz<4 x double> %v2
  %mul = fmul contract nsz<4 x double> %negv0, %v1
  %add = fadd contract nsz<4 x double> %mul, %negv2
  store <4 x double> %add, ptr %res
  ret void
}

;; Check that xvfnmadd.d is not emitted.
define void @not_contract_xvfnmadd_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: not_contract_xvfnmadd_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvbitrevi.d $xr2, $xr2, 63
; CONTRACT-FAST-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: not_contract_xvfnmadd_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvbitrevi.d $xr2, $xr2, 63
; CONTRACT-ON-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: not_contract_xvfnmadd_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvbitrevi.d $xr2, $xr2, 63
; CONTRACT-OFF-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv0 = fneg contract <4 x double> %v0
  %negv2 = fneg contract <4 x double> %v2
  %mul = fmul contract <4 x double> %negv0, %v1
  %add = fadd contract <4 x double> %mul, %negv2
  store <4 x double> %add, ptr %res
  ret void
}

define void @contract_xvfnmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_xvfnmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_xvfnmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_xvfnmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv2 = fneg contract <4 x double> %v2
  %mul = fmul contract <4 x double> %v0, %v1
  %add = fadd contract <4 x double> %mul, %negv2
  %neg = fneg contract <4 x double> %add
  store <4 x double> %neg, ptr %res
  ret void
}

define void @contract_xvfnmsub_d_nsz(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: contract_xvfnmsub_d_nsz:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: contract_xvfnmsub_d_nsz:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: contract_xvfnmsub_d_nsz:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv0 = fneg contract nsz<4 x double> %v0
  %mul = fmul contract nsz<4 x double> %negv0, %v1
  %add = fadd contract nsz<4 x double> %mul, %v2
  store <4 x double> %add, ptr %res
  ret void
}

;; Check that xvfnmsub.d is not emitted.
define void @not_contract_xvfnmsub_d(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: not_contract_xvfnmsub_d:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvbitrevi.d $xr2, $xr2, 63
; CONTRACT-FAST-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: not_contract_xvfnmsub_d:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvbitrevi.d $xr2, $xr2, 63
; CONTRACT-ON-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: not_contract_xvfnmsub_d:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvbitrevi.d $xr2, $xr2, 63
; CONTRACT-OFF-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %negv0 = fneg contract <4 x double> %v0
  %mul = fmul contract <4 x double> %negv0, %v1
  %add = fadd contract <4 x double> %mul, %v2
  store <4 x double> %add, ptr %res
  ret void
}

define void @xvfmadd_d_contract(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfmadd_d_contract:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfmadd_d_contract:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfmadd_d_contract:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul contract <4 x double> %v0, %v1
  %add = fadd contract <4 x double> %mul, %v2
  store <4 x double> %add, ptr %res
  ret void
}

define void @xvfmsub_d_contract(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfmsub_d_contract:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfmsub_d_contract:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfmsub_d_contract:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul contract <4 x double> %v0, %v1
  %sub = fsub contract <4 x double> %mul, %v2
  store <4 x double> %sub, ptr %res
  ret void
}

define void @xvfnmadd_d_contract(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfnmadd_d_contract:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfnmadd_d_contract:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfnmadd_d_contract:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfnmadd.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul contract <4 x double> %v0, %v1
  %add = fadd contract <4 x double> %mul, %v2
  %negadd = fneg contract <4 x double> %add
  store <4 x double> %negadd, ptr %res
  ret void
}

define void @xvfnmsub_d_contract(ptr %res, ptr %a0, ptr %a1, ptr %a2) nounwind {
; CONTRACT-FAST-LABEL: xvfnmsub_d_contract:
; CONTRACT-FAST:       # %bb.0: # %entry
; CONTRACT-FAST-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-FAST-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-FAST-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-FAST-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-FAST-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-FAST-NEXT:    ret
;
; CONTRACT-ON-LABEL: xvfnmsub_d_contract:
; CONTRACT-ON:       # %bb.0: # %entry
; CONTRACT-ON-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-ON-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-ON-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-ON-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-ON-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-ON-NEXT:    ret
;
; CONTRACT-OFF-LABEL: xvfnmsub_d_contract:
; CONTRACT-OFF:       # %bb.0: # %entry
; CONTRACT-OFF-NEXT:    xvld $xr0, $a3, 0
; CONTRACT-OFF-NEXT:    xvld $xr1, $a2, 0
; CONTRACT-OFF-NEXT:    xvld $xr2, $a1, 0
; CONTRACT-OFF-NEXT:    xvfnmsub.d $xr0, $xr2, $xr1, $xr0
; CONTRACT-OFF-NEXT:    xvst $xr0, $a0, 0
; CONTRACT-OFF-NEXT:    ret
entry:
  %v0 = load <4 x double>, ptr %a0
  %v1 = load <4 x double>, ptr %a1
  %v2 = load <4 x double>, ptr %a2
  %mul = fmul contract <4 x double> %v0, %v1
  %negv2 = fneg contract <4 x double> %v2
  %add = fadd contract <4 x double> %negv2, %mul
  %negadd = fneg contract <4 x double> %add
  store <4 x double> %negadd, ptr %res
  ret void
}
