; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple powerpc-ibm-aix-xcoff -stop-after=machine-cp -verify-machineinstrs < %s | \
; RUN: FileCheck --check-prefix=32BIT %s

; RUN: llc -mtriple powerpc64-ibm-aix-xcoff -stop-after=machine-cp -verify-machineinstrs < %s | \
; RUN: FileCheck --check-prefix=64BIT %s

define void @call_test_chars() {
  ; 32BIT-LABEL: name: call_test_chars
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 97
  ; 32BIT-NEXT:   $r4 = LI 97
  ; 32BIT-NEXT:   $r5 = LI 97
  ; 32BIT-NEXT:   $r6 = LI 97
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_chars>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit killed $r3, implicit killed $r4, implicit killed $r5, implicit killed $r6, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_chars
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 97
  ; 64BIT-NEXT:   $x4 = LI8 97
  ; 64BIT-NEXT:   $x5 = LI8 97
  ; 64BIT-NEXT:   $x6 = LI8 97
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_chars>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit killed $x3, implicit killed $x4, implicit killed $x5, implicit killed $x6, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  call i8 @test_chars(i8 signext 97, i8 signext 97, i8 signext 97, i8 signext 97)
  ret void
}

define signext i8 @test_chars(i8 signext %c1, i8 signext %c2, i8 signext %c3, i8 signext %c4) {
  ; 32BIT-LABEL: name: test_chars
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4, $r5, $r6
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r4
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r5
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r6
  ; 32BIT-NEXT:   renamable $r3 = EXTSB killed renamable $r3
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_chars
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4, $x5, $x6
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $r3 = ADD4 renamable $r3, renamable $r4, implicit killed $x4, implicit killed $x3
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r5, implicit killed $x5
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r6, implicit killed $x6, implicit-def $x3
  ; 64BIT-NEXT:   renamable $x3 = EXTSB8 killed renamable $x3
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %conv = sext i8 %c1 to i32
  %conv1 = sext i8 %c2 to i32
  %add = add nsw i32 %conv, %conv1
  %conv2 = sext i8 %c3 to i32
  %add3 = add nsw i32 %add, %conv2
  %conv4 = sext i8 %c4 to i32
  %add5 = add nsw i32 %add3, %conv4
  %conv6 = trunc i32 %add5 to i8
  ret i8 %conv6
}

define void @call_test_chars_mix() {
  ; 32BIT-LABEL: name: call_test_chars_mix
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 97
  ; 32BIT-NEXT:   $r4 = LI 225
  ; 32BIT-NEXT:   $r5 = LI 97
  ; 32BIT-NEXT:   $r6 = LI -31
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_chars_mix>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit killed $r3, implicit killed $r4, implicit killed $r5, implicit killed $r6, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_chars_mix
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 97
  ; 64BIT-NEXT:   $x4 = LI8 225
  ; 64BIT-NEXT:   $x5 = LI8 97
  ; 64BIT-NEXT:   $x6 = LI8 -31
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_chars_mix>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit killed $x3, implicit killed $x4, implicit killed $x5, implicit killed $x6, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  call i8 @test_chars_mix(i8 signext 97, i8 zeroext -31, i8 zeroext 97, i8 signext -31)
  ret void
}

define signext i8 @test_chars_mix(i8 signext %c1, i8 zeroext %c2, i8 zeroext %c3, i8 signext %c4) {
  ; 32BIT-LABEL: name: test_chars_mix
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4, $r5, $r6
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r4
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r5
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r6
  ; 32BIT-NEXT:   renamable $r3 = EXTSB killed renamable $r3
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_chars_mix
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4, $x5, $x6
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $r3 = ADD4 renamable $r3, renamable $r4, implicit killed $x4, implicit killed $x3
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r5, implicit killed $x5
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r6, implicit killed $x6, implicit-def $x3
  ; 64BIT-NEXT:   renamable $x3 = EXTSB8 killed renamable $x3
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %conv = sext i8 %c1 to i32
  %conv1 = zext i8 %c2 to i32
  %add = add nsw i32 %conv, %conv1
  %conv2 = zext i8 %c3 to i32
  %add3 = add nsw i32 %add, %conv2
  %conv4 = sext i8 %c4 to i32
  %add5 = add nsw i32 %add3, %conv4
  %conv6 = trunc i32 %add5 to i8
  ret i8 %conv6
}

@global_i1 = global i8 0, align 1

define  void @test_i1(i1 %b)  {
  ; 32BIT-LABEL: name: test_i1
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @global_i1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = RLWINM killed renamable $r3, 0, 31, 31
  ; 32BIT-NEXT:   STB killed renamable $r3, 0, killed renamable $r4 :: (store (s8) into @global_i1)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: test_i1
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @global_i1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $r3 = RLWINM renamable $r3, 0, 31, 31, implicit killed $x3
  ; 64BIT-NEXT:   STB killed renamable $r3, 0, killed renamable $x4 :: (store (s8) into @global_i1)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
  entry:
   %frombool = zext i1 %b to i8
   store i8 %frombool, ptr @global_i1, align 1
   ret void
}

define void @call_test_i1() {
  ; 32BIT-LABEL: name: call_test_i1
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_i1>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit killed $r3, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_i1
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_i1>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit killed $x3, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  call void @test_i1(i1 1)
  ret void
}

define void @test_i1zext(i1 zeroext %b) {
  ; 32BIT-LABEL: name: test_i1zext
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @global_i1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STB killed renamable $r3, 0, killed renamable $r4 :: (store (s8) into @global_i1)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: test_i1zext
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @global_i1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   STB8 killed renamable $x3, 0, killed renamable $x4 :: (store (s8) into @global_i1)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
  entry:
    %frombool = zext i1 %b to i8
    store i8 %frombool, ptr @global_i1, align 1
    ret void
  }

define i32 @test_ints(i32 signext %a, i32 zeroext %b, i32 zeroext %c, i32 signext %d, i32 signext %e, i32 signext %f, i32 signext %g, i32 signext %h) {
  ; 32BIT-LABEL: name: test_ints
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4, $r5, $r6, $r7, $r8, $r9, $r10
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r4
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r5
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r6
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r7
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r8
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r9
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r10
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_ints
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $r3 = ADD4 renamable $r3, renamable $r4, implicit killed $x4, implicit killed $x3
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r5, implicit killed $x5
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r6, implicit killed $x6
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r7, implicit killed $x7
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r8, implicit killed $x8
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r9, implicit killed $x9
  ; 64BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, renamable $r10, implicit killed $x10, implicit-def $x3
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
    %add = add i32 %a, %b
    %add1 = add i32 %add, %c
    %add2 = add i32 %add1, %d
    %add3 = add i32 %add2, %e
    %add4 = add i32 %add3, %f
    %add5 = add i32 %add4, %g
    %add6 = add i32 %add5, %h
    ret i32 %add6
}

define void @call_test_ints() {
  ; 32BIT-LABEL: name: call_test_ints
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 1
  ; 32BIT-NEXT:   $r5 = LIS 32768
  ; 32BIT-NEXT:   $r6 = LIS 32768
  ; 32BIT-NEXT:   $r7 = LI 1
  ; 32BIT-NEXT:   $r8 = LI 1
  ; 32BIT-NEXT:   $r9 = LI 1
  ; 32BIT-NEXT:   $r10 = LI 1
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_ints>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit killed $r3, implicit killed $r4, implicit killed $r5, implicit killed $r6, implicit killed $r7, implicit killed $r8, implicit killed $r9, implicit killed $r10, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_ints
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LI8 1
  ; 64BIT-NEXT:   renamable $x5 = RLDIC killed renamable $x3, 31, 32
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 1
  ; 64BIT-NEXT:   $x6 = LIS8 32768
  ; 64BIT-NEXT:   $x7 = LI8 1
  ; 64BIT-NEXT:   $x8 = LI8 1
  ; 64BIT-NEXT:   $x9 = LI8 1
  ; 64BIT-NEXT:   $x10 = LI8 1
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_ints>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit killed $x4, implicit $x5, implicit killed $x6, implicit killed $x7, implicit killed $x8, implicit killed $x9, implicit killed $x10, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  call i32 @test_ints(i32 signext 1, i32 zeroext 1, i32 zeroext 2147483648, i32 signext -2147483648, i32 signext 1, i32 signext 1, i32 signext 1, i32 signext 1)
  ret void
}

define void @call_test_i64() {
  ; 32BIT-LABEL: name: call_test_i64
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 0
  ; 32BIT-NEXT:   $r4 = LI 1
  ; 32BIT-NEXT:   $r5 = LI 0
  ; 32BIT-NEXT:   $r6 = LI 2
  ; 32BIT-NEXT:   $r7 = LI 0
  ; 32BIT-NEXT:   $r8 = LI 3
  ; 32BIT-NEXT:   $r9 = LI 0
  ; 32BIT-NEXT:   $r10 = LI 4
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_i64>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit killed $r3, implicit killed $r4, implicit killed $r5, implicit killed $r6, implicit killed $r7, implicit killed $r8, implicit killed $r9, implicit killed $r10, implicit $r2, implicit-def $r1, implicit-def dead $r3, implicit-def dead $r4
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_i64
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_i64>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit killed $x3, implicit killed $x4, implicit killed $x5, implicit killed $x6, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  call i64 @test_i64(i64 1, i64 2, i64 3, i64 4)
  ret void
}

define i64 @test_i64(i64 %a, i64 %b, i64 %c, i64 %d) {
  ; 32BIT-LABEL: name: test_i64
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4, $r5, $r6, $r7, $r8, $r9, $r10
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r4 = ADDC killed renamable $r4, killed renamable $r6, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDE killed renamable $r3, killed renamable $r5, implicit-def dead $carry, implicit killed $carry
  ; 32BIT-NEXT:   renamable $r4 = ADDC killed renamable $r4, killed renamable $r8, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDE killed renamable $r3, killed renamable $r7, implicit-def dead $carry, implicit killed $carry
  ; 32BIT-NEXT:   renamable $r4 = ADDC killed renamable $r4, killed renamable $r10, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDE killed renamable $r3, killed renamable $r9, implicit-def dead $carry, implicit killed $carry
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3, implicit $r4
  ;
  ; 64BIT-LABEL: name: test_i64
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4, $x5, $x6
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x4
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x5
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x6
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %add = add nsw i64 %a, %b
  %add1 = add nsw i64 %add, %c
  %add2 = add nsw i64 %add1, %d
  ret i64 %add2
}

define void @call_test_int_ptr() {
  ; 32BIT-LABEL: name: call_test_int_ptr
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LI 0
  ; 32BIT-NEXT:   STW killed renamable $r3, 0, %stack.0.b :: (store (s32) into %ir.b)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = ADDI %stack.0.b, 0
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_int_ptr>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_int_ptr
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LI8 0
  ; 64BIT-NEXT:   STW8 killed renamable $x3, 0, %stack.0.b :: (store (s32) into %ir.b)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = ADDI8 %stack.0.b, 0
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_int_ptr>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %b = alloca i32, align 4
  store i32 0, ptr %b, align 4
  call void @test_int_ptr(ptr %b)
  ret void
}

define void @test_int_ptr(ptr %a) {
  ; 32BIT-LABEL: name: test_int_ptr
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   STW killed renamable $r3, 0, %stack.0.a.addr :: (store (s32) into %ir.a.addr, align 8)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: test_int_ptr
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   STD killed renamable $x3, 0, %stack.0.a.addr :: (store (s64) into %ir.a.addr)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %a.addr = alloca ptr, align 8
  store ptr %a, ptr %a.addr, align 8
  ret void
}

define i32 @caller(i32 %i)  {
  ; 32BIT-LABEL: name: caller
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   STW renamable $r3, 0, %stack.0.i.addr :: (store (s32) into %ir.i.addr)
  ; 32BIT-NEXT:   renamable $r3 = CNTLZW killed renamable $r3
  ; 32BIT-NEXT:   renamable $r3 = NOR killed renamable $r3, renamable $r3
  ; 32BIT-NEXT:   renamable $r3 = RLWINM killed renamable $r3, 27, 31, 31
  ; 32BIT-NEXT:   STB renamable $r3, 0, %stack.1.b :: (store (s8) into %ir.b)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .call_test_bool[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r2, implicit-def $r1, implicit-def $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: caller
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   STW renamable $r3, 0, %stack.0.i.addr :: (store (s32) into %ir.i.addr)
  ; 64BIT-NEXT:   renamable $r3 = CNTLZW renamable $r3, implicit killed $x3
  ; 64BIT-NEXT:   renamable $r3 = RLWINM killed renamable $r3, 27, 5, 31
  ; 64BIT-NEXT:   renamable $r3 = XORI killed renamable $r3, 1, implicit-def $x3
  ; 64BIT-NEXT:   STB renamable $r3, 0, %stack.1.b :: (store (s8) into %ir.b)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .call_test_bool[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x2, implicit-def $r1, implicit-def $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %i.addr = alloca i32, align 4
  %b = alloca i8, align 1
  store i32 %i, ptr %i.addr, align 4
  %0 = load i32, ptr %i.addr, align 4
  %cmp = icmp ne i32 %0, 0
  %frombool = zext i1 %cmp to i8
  store i8 %frombool, ptr %b, align 1
  %1 = load i8, ptr %b, align 1
  %tobool = trunc i8 %1 to i1
  %call = call i32 @call_test_bool(i1 zeroext %tobool)
  ret i32 %call
}

declare i32 @call_test_bool(i1 zeroext)

@f1 = global float 0.000000e+00, align 4
@d1 = global double 0.000000e+00, align 8

define void @call_test_floats() {
  ; 32BIT-LABEL: name: call_test_floats
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f1)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $f2 = COPY renamable $f1
  ; 32BIT-NEXT:   $f3 = COPY renamable $f1
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_floats>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $f1, implicit killed $f2, implicit killed $f3, implicit $r2, implicit-def $r1, implicit-def dead $f1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_floats
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f1)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $f2 = COPY renamable $f1
  ; 64BIT-NEXT:   $f3 = COPY renamable $f1
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_floats>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $f1, implicit killed $f2, implicit killed $f3, implicit $x2, implicit-def $r1, implicit-def dead $f1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f1, align 4
  call float @test_floats(float %0, float %0, float %0)
  ret void
}

define float @test_floats(float %f1, float %f2, float %f3) {
  ; 32BIT-LABEL: name: test_floats
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $f1, $f2, $f3
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADDS killed renamable $f1, killed renamable $f2, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADDS killed renamable $f0, killed renamable $f3, implicit $rm
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $f1
  ;
  ; 64BIT-LABEL: name: test_floats
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $f1, $f2, $f3
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADDS killed renamable $f1, killed renamable $f2, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADDS killed renamable $f0, killed renamable $f3, implicit $rm
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $f1
entry:
  %add = fadd float %f1, %f2
  %add1 = fadd float %add, %f3
  ret float %add1
}

define void @call_test_fpr_max() {
  ; 32BIT-LABEL: name: call_test_fpr_max
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @d1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $r3 :: (dereferenceable load (s64) from @d1)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 128, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   STFD renamable $f1, 120, $r1 :: (store (s64))
  ; 32BIT-NEXT:   STFD renamable $f1, 112, $r1 :: (store (s64))
  ; 32BIT-NEXT:   STFD renamable $f1, 104, $r1 :: (store (s64))
  ; 32BIT-NEXT:   STFD renamable $f1, 96, $r1 :: (store (s64))
  ; 32BIT-NEXT:   STFD renamable $f1, 88, $r1 :: (store (s64))
  ; 32BIT-NEXT:   STFD renamable $f1, 80, $r1 :: (store (s64))
  ; 32BIT-NEXT:   STFD renamable $f1, 72, $r1 :: (store (s64))
  ; 32BIT-NEXT:   STFD renamable $f1, 64, $r1 :: (store (s64))
  ; 32BIT-NEXT:   $f2 = COPY renamable $f1
  ; 32BIT-NEXT:   $f3 = COPY renamable $f1
  ; 32BIT-NEXT:   $f4 = COPY renamable $f1
  ; 32BIT-NEXT:   $f5 = COPY renamable $f1
  ; 32BIT-NEXT:   $f6 = COPY renamable $f1
  ; 32BIT-NEXT:   $f7 = COPY renamable $f1
  ; 32BIT-NEXT:   $f8 = COPY renamable $f1
  ; 32BIT-NEXT:   $f9 = COPY renamable $f1
  ; 32BIT-NEXT:   $f10 = COPY renamable $f1
  ; 32BIT-NEXT:   $f11 = COPY renamable $f1
  ; 32BIT-NEXT:   $f12 = COPY renamable $f1
  ; 32BIT-NEXT:   $f13 = COPY renamable $f1
  ; 32BIT-NEXT:   STFD renamable $f1, 56, $r1 :: (store (s64))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_fpr_max>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $f1, implicit killed $f2, implicit killed $f3, implicit killed $f4, implicit killed $f5, implicit killed $f6, implicit killed $f7, implicit killed $f8, implicit killed $f9, implicit killed $f10, implicit killed $f11, implicit killed $f12, implicit killed $f13, implicit $r2, implicit-def $r1, implicit-def dead $f1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 128, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_fpr_max
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @d1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $x3 :: (dereferenceable load (s64) from @d1)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 152, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   STFD renamable $f1, 144, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STFD renamable $f1, 136, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STFD renamable $f1, 128, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STFD renamable $f1, 120, $x1 :: (store (s64))
  ; 64BIT-NEXT:   $f2 = COPY renamable $f1
  ; 64BIT-NEXT:   $f3 = COPY renamable $f1
  ; 64BIT-NEXT:   $f4 = COPY renamable $f1
  ; 64BIT-NEXT:   $f5 = COPY renamable $f1
  ; 64BIT-NEXT:   $f6 = COPY renamable $f1
  ; 64BIT-NEXT:   $f7 = COPY renamable $f1
  ; 64BIT-NEXT:   $f8 = COPY renamable $f1
  ; 64BIT-NEXT:   $f9 = COPY renamable $f1
  ; 64BIT-NEXT:   $f10 = COPY renamable $f1
  ; 64BIT-NEXT:   $f11 = COPY renamable $f1
  ; 64BIT-NEXT:   $f12 = COPY renamable $f1
  ; 64BIT-NEXT:   $f13 = COPY renamable $f1
  ; 64BIT-NEXT:   STFD renamable $f1, 112, $x1 :: (store (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_fpr_max>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $f1, implicit killed $f2, implicit killed $f3, implicit killed $f4, implicit killed $f5, implicit killed $f6, implicit killed $f7, implicit killed $f8, implicit killed $f9, implicit killed $f10, implicit killed $f11, implicit killed $f12, implicit killed $f13, implicit $x2, implicit-def $r1, implicit-def dead $f1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 152, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load double, ptr @d1, align 8
  call double @test_fpr_max(double %0, double %0, double %0, double %0, double %0, double %0, double %0, double %0, double %0, double %0, double %0, double %0, double %0)
  ret void
}

define double @test_fpr_max(double %d1, double %d2, double %d3, double %d4, double %d5, double %d6, double %d7, double %d8, double %d9, double %d10, double %d11, double %d12, double %d13) {
  ; 32BIT-LABEL: name: test_fpr_max
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, $f13
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f3, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f4, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f5, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f6, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f7, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f8, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f9, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f10, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f11, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f12, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f0, killed renamable $f13, implicit $rm
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $f1
  ;
  ; 64BIT-LABEL: name: test_fpr_max
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, $f13
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f3, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f4, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f5, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f6, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f7, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f8, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f9, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f10, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f11, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f12, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f0, killed renamable $f13, implicit $rm
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $f1
entry:
  %add = fadd double %d1, %d2
  %add1 = fadd double %add, %d3
  %add2 = fadd double %add1, %d4
  %add3 = fadd double %add2, %d5
  %add4 = fadd double %add3, %d6
  %add5 = fadd double %add4, %d7
  %add6 = fadd double %add5, %d8
  %add7 = fadd double %add6, %d9
  %add8 = fadd double %add7, %d10
  %add9 = fadd double %add8, %d11
  %add10 = fadd double %add9, %d12
  %add11 = fadd double %add10, %d13
  ret double %add11
}

define void @call_test_mix() {
  ; 32BIT-LABEL: name: call_test_mix
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @d1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f1)
  ; 32BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $r4 :: (dereferenceable load (s64) from @d1)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r4 = LI 1
  ; 32BIT-NEXT:   $r7 = LI 97
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_mix>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $f1, implicit $r4, implicit $f2, implicit killed $r7, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_mix
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @d1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f1)
  ; 64BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $x4 :: (dereferenceable load (s64) from @d1)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x4 = LI8 1
  ; 64BIT-NEXT:   $x6 = LI8 97
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_mix>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $f1, implicit $x4, implicit $f2, implicit killed $x6, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f1, align 4
  %1 = load double, ptr @d1, align 8
  call i32 @test_mix(float %0, i32 1, double %1, i8 signext 97)
  ret void
}

define i32 @test_mix(float %f, i32 signext %i, double %d, i8 signext %c) {
  ; 32BIT-LABEL: name: test_mix
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $f1, $f2, $r4, $r7
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r3 = LIS 17200
  ; 32BIT-NEXT:   STW killed renamable $r3, 0, %stack.1 :: (store (s32) into %stack.1, align 8)
  ; 32BIT-NEXT:   renamable $r3 = RLWINM killed renamable $r7, 0, 24, 31
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r4, killed renamable $r3
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc %const.0, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = XORIS killed renamable $r3, 32768
  ; 32BIT-NEXT:   STW killed renamable $r3, 4, %stack.1 :: (store (s32) into %stack.1 + 4)
  ; 32BIT-NEXT:   renamable $f0 = LFS 0, killed renamable $r4 :: (load (s32) from constant-pool)
  ; 32BIT-NEXT:   renamable $f3 = LFD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FRSP killed renamable $f1, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FSUB killed renamable $f3, killed renamable $f0, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FRSP killed renamable $f0, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADDS killed renamable $f0, killed renamable $f1, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FCTIWZ killed renamable $f0, implicit $rm
  ; 32BIT-NEXT:   STFD killed renamable $f0, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 32BIT-NEXT:   renamable $r3 = LWZ 4, %stack.0 :: (load (s32) from %stack.0 + 4, basealign 8)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: test_mix
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $f1, $f2, $x4, $x6
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $r3 = RLWINM renamable $r6, 0, 24, 31, implicit killed $x6
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 renamable $r4, killed renamable $r3, implicit killed $x4
  ; 64BIT-NEXT:   renamable $x3 = EXTSW_32_64 killed renamable $r3
  ; 64BIT-NEXT:   STD killed renamable $x3, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 64BIT-NEXT:   renamable $f0 = LFD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FRSP killed renamable $f1, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FCFID killed renamable $f0, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FRSP killed renamable $f0, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADDS killed renamable $f0, killed renamable $f1, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FCTIWZ killed renamable $f0, implicit $rm
  ; 64BIT-NEXT:   STFD killed renamable $f0, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 64BIT-NEXT:   renamable $x3 = LWZ8 4, %stack.0 :: (load (s32) from %stack.0 + 4, basealign 8)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %conv = fpext float %f to double
  %add = fadd double %conv, %d
  %conv1 = fptrunc double %add to float
  %conv2 = zext i8 %c to i32
  %add3 = add nsw i32 %i, %conv2
  %conv4 = sitofp i32 %add3 to float
  %add5 = fadd float %conv4, %conv1
  %conv6 = fptosi float %add5 to i32
  ret i32 %conv6
}

define i64 @callee_mixed_ints(i32 %a, i8 signext %b, i32 %c, i16 signext %d, i64 %e) {
  ; 32BIT-LABEL: name: callee_mixed_ints
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4, $r5, $r6, $r7, $r8
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r4 = RLWINM killed renamable $r4, 0, 24, 31
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r4
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r5
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r6
  ; 32BIT-NEXT:   renamable $r5 = SRAWI renamable $r3, 31, implicit-def dead $carry
  ; 32BIT-NEXT:   renamable $r4 = ADDC killed renamable $r3, killed renamable $r8, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDE killed renamable $r5, killed renamable $r7, implicit-def dead $carry, implicit killed $carry
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3, implicit $r4
  ;
  ; 64BIT-LABEL: name: callee_mixed_ints
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4, $x5, $x6, $x7
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $r4 = RLWINM renamable $r4, 0, 24, 31, implicit killed $x4
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 renamable $r3, killed renamable $r4, implicit killed $x3
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r5, implicit killed $x5
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r6, implicit killed $x6
  ; 64BIT-NEXT:   renamable $x3 = EXTSW_32_64 killed renamable $r3
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x7
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %conv = zext i8 %b to i32
  %add = add nsw i32 %a, %conv
  %add1 = add nsw i32 %add, %c
  %conv2 = sext i16 %d to i32
  %add3 = add nsw i32 %add1, %conv2
  %conv4 = sext i32 %add3 to i64
  %add5 = add nsw i64 %conv4, %e
  ret i64 %add5
  }

define void @call_test_vararg() {
  ; 32BIT-LABEL: name: call_test_vararg
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f1)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @d1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STFD renamable $f1, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 32BIT-NEXT:   renamable $r4 = LWZ 0, %stack.1 :: (load (s32) from %stack.1, align 8)
  ; 32BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $r3 :: (dereferenceable load (s64) from @d1)
  ; 32BIT-NEXT:   renamable $r5 = LWZ 4, %stack.1 :: (load (s32) from %stack.1 + 4)
  ; 32BIT-NEXT:   STFD renamable $f2, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 32BIT-NEXT:   renamable $r6 = LWZ 0, %stack.0 :: (load (s32) from %stack.0, align 8)
  ; 32BIT-NEXT:   renamable $r7 = LWZ 4, %stack.0 :: (load (s32) from %stack.0 + 4)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 42
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_vararg[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $f1, implicit $r4, implicit $r5, implicit $f2, implicit $r6, implicit $r7, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_vararg
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f1)
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @d1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   STFD renamable $f1, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 64BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $x3 :: (dereferenceable load (s64) from @d1)
  ; 64BIT-NEXT:   renamable $x4 = LD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 64BIT-NEXT:   STFD renamable $f2, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 64BIT-NEXT:   renamable $x5 = LD 0, %stack.0 :: (load (s64) from %stack.0)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 42
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_vararg[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $f1, implicit $x4, implicit $f2, implicit $x5, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f1, align 4
  %conv = fpext float %0 to double
  %1 = load double, ptr @d1, align 8
  call void (i32, ...) @test_vararg(i32 42, double %conv, double %1)
  ret void
}

declare void @test_vararg(i32, ...)

define void @call_test_vararg2() {
  ; 32BIT-LABEL: name: call_test_vararg2
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f1)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @d1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STFD renamable $f1, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 32BIT-NEXT:   renamable $r4 = LWZ 0, %stack.1 :: (load (s32) from %stack.1, align 8)
  ; 32BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $r3 :: (dereferenceable load (s64) from @d1)
  ; 32BIT-NEXT:   renamable $r5 = LWZ 4, %stack.1 :: (load (s32) from %stack.1 + 4)
  ; 32BIT-NEXT:   STFD renamable $f2, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 32BIT-NEXT:   renamable $r7 = LWZ 0, %stack.0 :: (load (s32) from %stack.0, align 8)
  ; 32BIT-NEXT:   renamable $r8 = LWZ 4, %stack.0 :: (load (s32) from %stack.0 + 4)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 42
  ; 32BIT-NEXT:   $r6 = LI 42
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_vararg[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $f1, implicit $r4, implicit $r5, implicit killed $r6, implicit $f2, implicit $r7, implicit $r8, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_vararg2
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f1)
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @d1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   STFD renamable $f1, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 64BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $x3 :: (dereferenceable load (s64) from @d1)
  ; 64BIT-NEXT:   renamable $x4 = LD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 64BIT-NEXT:   STFD renamable $f2, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 64BIT-NEXT:   renamable $x6 = LD 0, %stack.0 :: (load (s64) from %stack.0)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 42
  ; 64BIT-NEXT:   $x5 = LI8 42
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_vararg[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $f1, implicit $x4, implicit killed $x5, implicit $f2, implicit $x6, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f1, align 4
  %conv = fpext float %0 to double
  %1 = load double, ptr @d1, align 8
  call void (i32, ...) @test_vararg(i32 42, double %conv, i32 42, double %1)
  ret void
}

define void @call_test_vararg3() {
  ; 32BIT-LABEL: name: call_test_vararg3
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f1)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @d1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STFD renamable $f1, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 32BIT-NEXT:   renamable $r4 = LWZ 0, %stack.1 :: (load (s32) from %stack.1, align 8)
  ; 32BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $r3 :: (dereferenceable load (s64) from @d1)
  ; 32BIT-NEXT:   renamable $r5 = LWZ 4, %stack.1 :: (load (s32) from %stack.1 + 4)
  ; 32BIT-NEXT:   STFD renamable $f2, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 32BIT-NEXT:   renamable $r8 = LWZ 0, %stack.0 :: (load (s32) from %stack.0, align 8)
  ; 32BIT-NEXT:   renamable $r9 = LWZ 4, %stack.0 :: (load (s32) from %stack.0 + 4)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 42
  ; 32BIT-NEXT:   $r6 = LI 0
  ; 32BIT-NEXT:   $r7 = LI 42
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_vararg[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $f1, implicit $r4, implicit $r5, implicit killed $r6, implicit killed $r7, implicit $f2, implicit $r8, implicit $r9, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_vararg3
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f1)
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @d1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   STFD renamable $f1, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 64BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $x3 :: (dereferenceable load (s64) from @d1)
  ; 64BIT-NEXT:   renamable $x4 = LD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 64BIT-NEXT:   STFD renamable $f2, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 64BIT-NEXT:   renamable $x6 = LD 0, %stack.0 :: (load (s64) from %stack.0)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 42
  ; 64BIT-NEXT:   $x5 = LI8 42
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_vararg[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $f1, implicit $x4, implicit killed $x5, implicit $f2, implicit $x6, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f1, align 4
  %conv = fpext float %0 to double
  %1 = load double, ptr @d1, align 8
  call void (i32, ...) @test_vararg(i32 42, double %conv, i64 42, double %1)
  ret void
}

define void @call_test_vararg4() {
  ; 32BIT-LABEL: name: call_test_vararg4
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f1)
  ; 32BIT-NEXT:   STFS renamable $f1, 0, %stack.0 :: (store (s32) into %stack.0)
  ; 32BIT-NEXT:   renamable $r4 = LWZ 0, %stack.0 :: (load (s32) from %stack.0)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 42
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_vararg[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $f1, implicit $r4, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_vararg4
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f1)
  ; 64BIT-NEXT:   STFS renamable $f1, 0, %stack.0 :: (store (s32) into %stack.0)
  ; 64BIT-NEXT:   renamable $x4 = LWZ8 0, %stack.0 :: (load (s32) from %stack.0)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 42
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_vararg[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $f1, implicit $x4, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f1, align 4
  call void (i32, ...) @test_vararg(i32 42, float %0)
  ret void
}

@c = common global i8 0, align 1
@si = common global i16 0, align 2
@i = common global i32 0, align 4
@lli = common global i64 0, align 8
@f = common global float 0.000000e+00, align 4
@d = common global double 0.000000e+00, align 8

; Basic saving of integral type arguments to the parameter save area.
define void @call_test_stackarg_int() {
  ; 32BIT-LABEL: name: call_test_stackarg_int
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @c, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @si, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc @i, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r11 = LBZ 0, killed renamable $r3 :: (dereferenceable load (s8) from @c)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @lli, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LHA 0, killed renamable $r4 :: (dereferenceable load (s16) from @si)
  ; 32BIT-NEXT:   renamable $r5 = LWZ 0, killed renamable $r5 :: (dereferenceable load (s32) from @i)
  ; 32BIT-NEXT:   renamable $r6 = LWZ 0, renamable $r3 :: (dereferenceable load (s32) from @lli, align 8)
  ; 32BIT-NEXT:   renamable $r3 = LWZ 4, killed renamable $r3 :: (dereferenceable load (s32) from @lli + 4, basealign 8)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 80, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   STW renamable $r5, 76, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r3, 72, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r6, 68, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r5, 64, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r4, 60, $r1 :: (store (s32))
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 2
  ; 32BIT-NEXT:   $r5 = LI 3
  ; 32BIT-NEXT:   $r6 = LI 4
  ; 32BIT-NEXT:   $r7 = LI 5
  ; 32BIT-NEXT:   $r8 = LI 6
  ; 32BIT-NEXT:   $r9 = LI 7
  ; 32BIT-NEXT:   $r10 = LI 8
  ; 32BIT-NEXT:   STW killed renamable $r11, 56, $r1 :: (store (s32))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_stackarg_int[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r5, implicit $r6, implicit $r7, implicit $r8, implicit $r9, implicit $r10, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 80, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_stackarg_int
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @c, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @si, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x5 = LDtoc @i, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x6 = LDtoc @lli, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x11 = LBZ8 0, killed renamable $x3 :: (dereferenceable load (s8) from @c)
  ; 64BIT-NEXT:   renamable $x12 = LHA8 0, killed renamable $x4 :: (dereferenceable load (s16) from @si)
  ; 64BIT-NEXT:   renamable $x0 = LWZ8 0, killed renamable $x5 :: (dereferenceable load (s32) from @i)
  ; 64BIT-NEXT:   renamable $x31 = LD 0, killed renamable $x6 :: (dereferenceable load (s64) from @lli)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 152, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   $x7 = LI8 5
  ; 64BIT-NEXT:   $x8 = LI8 6
  ; 64BIT-NEXT:   $x9 = LI8 7
  ; 64BIT-NEXT:   $x10 = LI8 8
  ; 64BIT-NEXT:   STD killed renamable $x31, 136, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD renamable $x0, 144, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x0, 128, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x12, 120, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x11, 112, $x1 :: (store (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_stackarg_int[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $x5, implicit $x6, implicit $x7, implicit $x8, implicit $x9, implicit $x10, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 152, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load i8, ptr @c, align 1
  %1 = load i16, ptr @si, align 2
  %2 = load i32, ptr @i, align 4
  %3 = load i64, ptr @lli, align 8
  %4 = load i32, ptr @i, align 4
  call void @test_stackarg_int(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i8 zeroext %0, i16 signext %1, i32 %2, i64 %3, i32 %4)
  ret void
}

declare void @test_stackarg_int(i32, i32, i32, i32, i32, i32, i32, i32, i8 zeroext, i16 signext, i32, i64, i32)

; Basic saving of floating point type arguments to the parameter save area.
; The float and double arguments will pass in both fpr as well as parameter save area.
define void @call_test_stackarg_float() {
  ; 32BIT-LABEL: name: call_test_stackarg_float
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @d, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f)
  ; 32BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $r4 :: (dereferenceable load (s64) from @d)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 68, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   STFD renamable $f2, 60, $r1 :: (store (s64))
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 2
  ; 32BIT-NEXT:   $r5 = LI 3
  ; 32BIT-NEXT:   $r6 = LI 4
  ; 32BIT-NEXT:   $r7 = LI 5
  ; 32BIT-NEXT:   $r8 = LI 6
  ; 32BIT-NEXT:   $r9 = LI 7
  ; 32BIT-NEXT:   $r10 = LI 8
  ; 32BIT-NEXT:   STFS renamable $f1, 56, $r1 :: (store (s32))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_stackarg_float[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit killed $r5, implicit killed $r6, implicit killed $r7, implicit killed $r8, implicit killed $r9, implicit killed $r10, implicit $f1, implicit $f2, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 68, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_stackarg_float
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @d, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f)
  ; 64BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $x4 :: (dereferenceable load (s64) from @d)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 128, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   STFD renamable $f2, 120, $x1 :: (store (s64))
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   $x7 = LI8 5
  ; 64BIT-NEXT:   $x8 = LI8 6
  ; 64BIT-NEXT:   $x9 = LI8 7
  ; 64BIT-NEXT:   $x10 = LI8 8
  ; 64BIT-NEXT:   STFS renamable $f1, 112, $x1 :: (store (s32))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_stackarg_float[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit killed $x5, implicit killed $x6, implicit killed $x7, implicit killed $x8, implicit killed $x9, implicit killed $x10, implicit $f1, implicit $f2, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 128, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f, align 4
  %1 = load double, ptr @d, align 8
  call void @test_stackarg_float(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, float %0, double %1)
  ret void
}

declare void @test_stackarg_float(i32, i32, i32, i32, i32, i32, i32, i32, float, double)

define void @call_test_stackarg_float2() {
  ; 32BIT-LABEL: name: call_test_stackarg_float2
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @d, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $r3 :: (dereferenceable load (s64) from @d)
  ; 32BIT-NEXT:   STFD renamable $f1, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 32BIT-NEXT:   renamable $r9 = LWZ 0, %stack.0 :: (load (s32) from %stack.0, align 8)
  ; 32BIT-NEXT:   renamable $r10 = LWZ 4, %stack.0 :: (load (s32) from %stack.0 + 4)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 2
  ; 32BIT-NEXT:   $r5 = LI 3
  ; 32BIT-NEXT:   $r6 = LI 4
  ; 32BIT-NEXT:   $r7 = LI 5
  ; 32BIT-NEXT:   $r8 = LI 6
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_stackarg_float2[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit killed $r4, implicit killed $r5, implicit killed $r6, implicit killed $r7, implicit killed $r8, implicit $f1, implicit $r9, implicit $r10, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 56, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_stackarg_float2
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @d, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $x3 :: (dereferenceable load (s64) from @d)
  ; 64BIT-NEXT:   STFD renamable $f1, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 64BIT-NEXT:   renamable $x9 = LD 0, %stack.0 :: (load (s64) from %stack.0)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   $x7 = LI8 5
  ; 64BIT-NEXT:   $x8 = LI8 6
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_stackarg_float2[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit killed $x4, implicit killed $x5, implicit killed $x6, implicit killed $x7, implicit killed $x8, implicit $f1, implicit $x9, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 112, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load double, ptr @d, align 8
  call void (i32, i32, i32, i32, i32, i32, ...) @test_stackarg_float2(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, double %0)
  ret void
}

declare void @test_stackarg_float2(i32, i32, i32, i32, i32, i32, ...)

; A double arg will pass on the stack in PPC32 if there is only one available GPR.
define void @call_test_stackarg_float3() {
  ; 32BIT-LABEL: name: call_test_stackarg_float3
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @d, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $r3 :: (dereferenceable load (s64) from @d)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @f, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STFD renamable $f1, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 32BIT-NEXT:   renamable $r10 = LWZ 0, %stack.0 :: (load (s32) from %stack.0, align 8)
  ; 32BIT-NEXT:   renamable $f2 = LFS 0, killed renamable $r3 :: (dereferenceable load (s32) from @f)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 64, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   STFS renamable $f2, 60, $r1 :: (store (s32))
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 2
  ; 32BIT-NEXT:   $r5 = LI 3
  ; 32BIT-NEXT:   $r6 = LI 4
  ; 32BIT-NEXT:   $r7 = LI 5
  ; 32BIT-NEXT:   $r8 = LI 6
  ; 32BIT-NEXT:   $r9 = LI 7
  ; 32BIT-NEXT:   STFD renamable $f1, 52, $r1 :: (store (s64))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_stackarg_float3[PR]>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit killed $r4, implicit killed $r5, implicit killed $r6, implicit killed $r7, implicit killed $r8, implicit killed $r9, implicit $f1, implicit $r10, implicit $f2, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 64, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_stackarg_float3
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @d, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $x3 :: (dereferenceable load (s64) from @d)
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   STFD renamable $f1, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 64BIT-NEXT:   renamable $x10 = LD 0, %stack.0 :: (load (s64) from %stack.0)
  ; 64BIT-NEXT:   renamable $f2 = LFS 0, killed renamable $x3 :: (dereferenceable load (s32) from @f)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 120, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   $x7 = LI8 5
  ; 64BIT-NEXT:   $x8 = LI8 6
  ; 64BIT-NEXT:   $x9 = LI8 7
  ; 64BIT-NEXT:   STFS renamable $f2, 112, $x1 :: (store (s32))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_stackarg_float3[PR]>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit killed $x4, implicit killed $x5, implicit killed $x6, implicit killed $x7, implicit killed $x8, implicit killed $x9, implicit $f1, implicit $x10, implicit $f2, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 120, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load double, ptr @d, align 8
  %1 = load float, ptr @f, align 4
  call void (i32, i32, i32, i32, i32, i32, i32, ...) @test_stackarg_float3(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, double %0, float %1)
  ret void
}

declare void @test_stackarg_float3(i32, i32, i32, i32, i32, i32, i32, ...)

define i64 @test_ints_stack(i32 %i1, i32 %i2, i32 %i3, i32 %i4, i32 %i5, i32 %i6, i32 %i7, i32 %i8, i64 %ll9, i16 signext %s10, i8 zeroext %c11, i32 %ui12, i32 %si13, i64 %ll14, i8 zeroext %uc15, i32 %i16) {
  ; 32BIT-LABEL: name: test_ints_stack
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $r3, $r4, $r5, $r6, $r7, $r8, $r9, $r10
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r11 = LWZ 0, %fixed-stack.0 :: (load (s32) from %fixed-stack.0)
  ; 32BIT-NEXT:   renamable $r12 = LWZ 0, %fixed-stack.4 :: (load (s32) from %fixed-stack.4)
  ; 32BIT-NEXT:   renamable $r0 = LWZ 0, %fixed-stack.1 :: (load (s32) from %fixed-stack.1, align 8)
  ; 32BIT-NEXT:   renamable $r31 = LWZ 4, %fixed-stack.3 :: (load (s32) from %fixed-stack.3 + 4, basealign 16)
  ; 32BIT-NEXT:   renamable $r30 = LWZ 0, %fixed-stack.3 :: (load (s32) from %fixed-stack.3, align 16)
  ; 32BIT-NEXT:   renamable $r29 = LWZ 0, %fixed-stack.5 :: (load (s32) from %fixed-stack.5, align 8)
  ; 32BIT-NEXT:   renamable $r28 = LWZ 0, %fixed-stack.6 :: (load (s32) from %fixed-stack.6)
  ; 32BIT-NEXT:   renamable $r27 = LWZ 0, %fixed-stack.7 :: (load (s32) from %fixed-stack.7, align 16)
  ; 32BIT-NEXT:   renamable $r26 = LWZ 4, %fixed-stack.9 :: (load (s32) from %fixed-stack.9 + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r25 = LWZ 0, %fixed-stack.9 :: (load (s32) from %fixed-stack.9, align 8)
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r4
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r5
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r6
  ; 32BIT-NEXT:   renamable $r5 = SRAWI renamable $r11, 31, implicit-def dead $carry
  ; 32BIT-NEXT:   renamable $r4 = SRAWI renamable $r12, 31, implicit-def dead $carry
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r7
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r8
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r9
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r10
  ; 32BIT-NEXT:   renamable $r6 = SRAWI renamable $r3, 31, implicit-def dead $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDC killed renamable $r3, killed renamable $r26, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r6 = ADDE killed renamable $r6, killed renamable $r25, implicit-def dead $carry, implicit $carry
  ; 32BIT-NEXT:   renamable $r7 = SRAWI renamable $r27, 31, implicit-def dead $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDC killed renamable $r3, killed renamable $r27, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r6 = ADDE killed renamable $r6, killed renamable $r7, implicit-def dead $carry, implicit $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDC killed renamable $r3, killed renamable $r28, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r6 = ADDZE killed renamable $r6, implicit-def dead $carry, implicit $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDC killed renamable $r3, killed renamable $r29, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r6 = ADDZE killed renamable $r6, implicit-def dead $carry, implicit $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDC killed renamable $r3, killed renamable $r12, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r4 = ADDE killed renamable $r6, killed renamable $r4, implicit-def dead $carry, implicit $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDC killed renamable $r3, killed renamable $r31, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r4 = ADDE killed renamable $r4, killed renamable $r30, implicit-def dead $carry, implicit $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDC killed renamable $r3, killed renamable $r0, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r6 = ADDZE killed renamable $r4, implicit-def dead $carry, implicit $carry
  ; 32BIT-NEXT:   renamable $r4 = ADDC killed renamable $r3, killed renamable $r11, implicit-def $carry
  ; 32BIT-NEXT:   renamable $r3 = ADDE killed renamable $r6, killed renamable $r5, implicit-def dead $carry, implicit $carry
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3, implicit $r4
  ;
  ; 64BIT-LABEL: name: test_ints_stack
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $r11 = LWZ 0, %fixed-stack.1, implicit-def $x11 :: (load (s32) from %fixed-stack.1)
  ; 64BIT-NEXT:   renamable $x12 = LWZ8 0, %fixed-stack.4 :: (load (s32) from %fixed-stack.4)
  ; 64BIT-NEXT:   renamable $x0 = LWA 0, %fixed-stack.0 :: (load (s32) from %fixed-stack.0)
  ; 64BIT-NEXT:   renamable $x31 = LD 0, %fixed-stack.2 :: (load (s64) from %fixed-stack.2)
  ; 64BIT-NEXT:   renamable $x30 = LWA 0, %fixed-stack.3 :: (load (s32) from %fixed-stack.3)
  ; 64BIT-NEXT:   renamable $r29 = LWZ 0, %fixed-stack.5, implicit-def $x29 :: (load (s32) from %fixed-stack.5)
  ; 64BIT-NEXT:   renamable $x28 = LWA 0, %fixed-stack.6 :: (load (s32) from %fixed-stack.6)
  ; 64BIT-NEXT:   renamable $x27 = LD 0, %fixed-stack.7 :: (load (s64) from %fixed-stack.7, align 16)
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 renamable $r3, renamable $r4, implicit killed $x4, implicit killed $x3
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r5, implicit killed $x5
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r6, implicit killed $x6
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r7, implicit killed $x7
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r8, implicit killed $x8
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r9, implicit killed $x9
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r10, implicit killed $x10
  ; 64BIT-NEXT:   renamable $x3 = EXTSW_32_64 killed renamable $r3
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x27
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x28
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x29
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x12
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x30
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x31
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x11
  ; 64BIT-NEXT:   renamable $x3 = nsw ADD8 killed renamable $x3, killed renamable $x0
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  %add = add nsw i32 %i1, %i2
  %add1 = add nsw i32 %add, %i3
  %add2 = add nsw i32 %add1, %i4
  %add3 = add nsw i32 %add2, %i5
  %add4 = add nsw i32 %add3, %i6
  %add5 = add nsw i32 %add4, %i7
  %add6 = add nsw i32 %add5, %i8
  %conv = sext i32 %add6 to i64
  %add7 = add nsw i64 %conv, %ll9
  %conv8 = sext i16 %s10 to i64
  %add9 = add nsw i64 %add7, %conv8
  %conv10 = zext i8 %c11 to i64
  %add11 = add nsw i64 %add9, %conv10
  %conv12 = zext i32 %ui12 to i64
  %add13 = add nsw i64 %add11, %conv12
  %conv14 = sext i32 %si13 to i64
  %add15 = add nsw i64 %add13, %conv14
  %add16 = add nsw i64 %add15, %ll14
  %conv17 = zext i8 %uc15 to i64
  %add18 = add nsw i64 %add16, %conv17
  %conv19 = sext i32 %i16 to i64
  %add20 = add nsw i64 %add18, %conv19
  ret i64 %add20
}

@ll1 = common global i64 0, align 8
@si1 = common global i16 0, align 2
@ch = common global i8 0, align 1
@ui = common global i32 0, align 4
@sint = common global i32 0, align 4
@ll2 = common global i64 0, align 8
@uc1 = common global i8 0, align 1
@i1 = common global i32 0, align 4

define void @caller_ints_stack() {
  ; 32BIT-LABEL: name: caller_ints_stack
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @ll1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @si1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r11 = LWZ 0, renamable $r3 :: (dereferenceable load (s32) from @ll1, align 8)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc @ch, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = LWZ 4, killed renamable $r3 :: (dereferenceable load (s32) from @ll1 + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r6 = LWZtoc @ui, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LHA 0, killed renamable $r4 :: (dereferenceable load (s16) from @si1)
  ; 32BIT-NEXT:   renamable $r7 = LWZtoc @sint, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r5 = LBZ 0, killed renamable $r5 :: (dereferenceable load (s8) from @ch)
  ; 32BIT-NEXT:   renamable $r8 = LWZtoc @ll2, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r6 = LWZ 0, killed renamable $r6 :: (dereferenceable load (s32) from @ui)
  ; 32BIT-NEXT:   renamable $r7 = LWZ 0, killed renamable $r7 :: (dereferenceable load (s32) from @sint)
  ; 32BIT-NEXT:   renamable $r9 = LWZtoc @uc1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r10 = LWZ 0, renamable $r8 :: (dereferenceable load (s32) from @ll2, align 8)
  ; 32BIT-NEXT:   renamable $r12 = LWZtoc @i1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r8 = LWZ 4, killed renamable $r8 :: (dereferenceable load (s32) from @ll2 + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r9 = LBZ 0, killed renamable $r9 :: (dereferenceable load (s8) from @uc1)
  ; 32BIT-NEXT:   renamable $r12 = LWZ 0, killed renamable $r12 :: (dereferenceable load (s32) from @i1)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 96, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   STW killed renamable $r12, 92, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r9, 88, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r8, 84, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r10, 80, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r7, 76, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r6, 72, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r5, 68, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r4, 64, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STW killed renamable $r3, 60, $r1 :: (store (s32))
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 2
  ; 32BIT-NEXT:   $r5 = LI 3
  ; 32BIT-NEXT:   $r6 = LI 4
  ; 32BIT-NEXT:   $r7 = LI 5
  ; 32BIT-NEXT:   $r8 = LI 6
  ; 32BIT-NEXT:   $r9 = LI 7
  ; 32BIT-NEXT:   $r10 = LI 8
  ; 32BIT-NEXT:   STW killed renamable $r11, 56, $r1 :: (store (s32))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_ints_stack>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r5, implicit $r6, implicit $r7, implicit $r8, implicit $r9, implicit $r10, implicit $r2, implicit-def $r1, implicit-def dead $r3, implicit-def dead $r4
  ; 32BIT-NEXT:   ADJCALLSTACKUP 96, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: caller_ints_stack
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @si1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @ch, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x5 = LDtoc @ui, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x11 = LHA8 0, killed renamable $x3 :: (dereferenceable load (s16) from @si1)
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @sint, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x12 = LBZ8 0, killed renamable $x4 :: (dereferenceable load (s8) from @ch)
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @uc1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x0 = LWZ8 0, killed renamable $x5 :: (dereferenceable load (s32) from @ui)
  ; 64BIT-NEXT:   renamable $x5 = LDtoc @ll1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x6 = LDtoc @ll2, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x7 = LDtoc @i1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x31 = LWZ8 0, killed renamable $x3 :: (dereferenceable load (s32) from @sint)
  ; 64BIT-NEXT:   renamable $x30 = LBZ8 0, killed renamable $x4 :: (dereferenceable load (s8) from @uc1)
  ; 64BIT-NEXT:   renamable $x29 = LD 0, killed renamable $x5 :: (dereferenceable load (s64) from @ll1)
  ; 64BIT-NEXT:   renamable $x28 = LD 0, killed renamable $x6 :: (dereferenceable load (s64) from @ll2)
  ; 64BIT-NEXT:   renamable $x27 = LWZ8 0, killed renamable $x7 :: (dereferenceable load (s32) from @i1)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 176, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   $x7 = LI8 5
  ; 64BIT-NEXT:   $x8 = LI8 6
  ; 64BIT-NEXT:   $x9 = LI8 7
  ; 64BIT-NEXT:   $x10 = LI8 8
  ; 64BIT-NEXT:   STD killed renamable $x27, 168, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x30, 160, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x28, 152, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x31, 144, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x0, 136, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x12, 128, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x11, 120, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x29, 112, $x1 :: (store (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_ints_stack>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $x5, implicit $x6, implicit $x7, implicit $x8, implicit $x9, implicit $x10, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 176, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load i64, ptr @ll1, align 8
  %1 = load i16, ptr @si1, align 2
  %2 = load i8, ptr @ch, align 1
  %3 = load i32, ptr @ui, align 4
  %4 = load i32, ptr @sint, align 4
  %5 = load i64, ptr @ll2, align 8
  %6 = load i8, ptr @uc1, align 1
  %7 = load i32, ptr @i1, align 4
  %call = call i64 @test_ints_stack(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i64 %0, i16 signext %1, i8 zeroext %2, i32 %3, i32 %4, i64 %5, i8 zeroext %6, i32 %7)
  ret void
}

@globali1 = global i8 0, align 1

define void @test_i1_stack(i32 %a, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i1 zeroext %b) {
  ; 32BIT-LABEL: name: test_i1_stack
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LBZ 0, %fixed-stack.0 :: (load (s8) from %fixed-stack.0)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @globali1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STB killed renamable $r3, 0, killed renamable $r4 :: (store (s8) into @globali1)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: test_i1_stack
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $r3 = LBZ 0, %fixed-stack.0 :: (load (s8) from %fixed-stack.0)
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @globali1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   STB killed renamable $r3, 0, killed renamable $x4 :: (store (s8) into @globali1)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
  entry:
    %frombool = zext i1 %b to i8
    store i8 %frombool, ptr @globali1, align 1
    ret void
}

define void @call_test_i1_stack() {
  ; 32BIT-LABEL: name: call_test_i1_stack
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 60, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r11 = LI 1
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 2
  ; 32BIT-NEXT:   $r5 = LI 3
  ; 32BIT-NEXT:   $r6 = LI 4
  ; 32BIT-NEXT:   $r7 = LI 5
  ; 32BIT-NEXT:   $r8 = LI 6
  ; 32BIT-NEXT:   $r9 = LI 7
  ; 32BIT-NEXT:   $r10 = LI 8
  ; 32BIT-NEXT:   STW killed renamable $r11, 56, $r1 :: (store (s32))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_i1_stack>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r5, implicit $r6, implicit $r7, implicit $r8, implicit $r9, implicit $r10, implicit $r2, implicit-def $r1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 60, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: call_test_i1_stack
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 120, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x11 = LI8 1
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   $x7 = LI8 5
  ; 64BIT-NEXT:   $x8 = LI8 6
  ; 64BIT-NEXT:   $x9 = LI8 7
  ; 64BIT-NEXT:   $x10 = LI8 8
  ; 64BIT-NEXT:   STD killed renamable $x11, 112, $x1 :: (store (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_i1_stack>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $x5, implicit $x6, implicit $x7, implicit $x8, implicit $x9, implicit $x10, implicit $x2, implicit-def $r1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 120, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
  entry:
    call void @test_i1_stack(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i1 true)
    ret void
}

define double @test_fpr_stack(double %d1, double %d2, double %d3, double %d4, double %d5, double %d6, double %d7, double %d8, double %d9, double %s10, double %l11, double %d12, double %d13, float %f14, double %d15, float %f16) {
  ; 32BIT-LABEL: name: test_fpr_stack
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, $f13
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $f0 = LFD 0, %fixed-stack.1 :: (load (s64) from %fixed-stack.1)
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 32BIT-NEXT:   renamable $f2 = LFS 0, %fixed-stack.2 :: (load (s32) from %fixed-stack.2, align 16)
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f3, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f4, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f5, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f6, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f7, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f8, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f9, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f10, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f11, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f12, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, renamable $f13, implicit $rm
  ; 32BIT-NEXT:   renamable $f3 = LFS 0, %fixed-stack.0 :: (load (s32) from %fixed-stack.0)
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f13, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f1, killed renamable $f0, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f0, killed renamable $f3, implicit $rm
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $f1
  ;
  ; 64BIT-LABEL: name: test_fpr_stack
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, $f13
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $f0 = LFD 0, %fixed-stack.1 :: (load (s64) from %fixed-stack.1, align 16)
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 64BIT-NEXT:   renamable $f2 = LFS 0, %fixed-stack.2 :: (load (s32) from %fixed-stack.2, align 8)
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f3, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f4, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f5, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f6, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f7, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f8, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f9, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f10, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f11, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f12, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, renamable $f13, implicit $rm
  ; 64BIT-NEXT:   renamable $f3 = LFS 0, %fixed-stack.0 :: (load (s32) from %fixed-stack.0, align 8)
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f13, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f1, killed renamable $f0, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f0, killed renamable $f3, implicit $rm
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $f1
  entry:
    %add = fadd double %d1, %d2
    %add1 = fadd double %add, %d3
    %add2 = fadd double %add1, %d4
    %add3 = fadd double %add2, %d5
    %add4 = fadd double %add3, %d6
    %add5 = fadd double %add4, %d7
    %add6 = fadd double %add5, %d8
    %add7 = fadd double %add6, %d9
    %add8 = fadd double %add7, %s10
    %add9 = fadd double %add8, %l11
    %add10 = fadd double %add9, %d12
    %add11 = fadd double %add10, %d13
    %add12 = fadd double %add11, %d13
    %conv = fpext float %f14 to double
    %add13 = fadd double %add12, %conv
    %add14 = fadd double %add13, %d15
    %conv15 = fpext float %f16 to double
    %add16 = fadd double %add14, %conv15
    ret double %add16
  }

@f14 = common global float 0.000000e+00, align 4
@d15 = common global double 0.000000e+00, align 8
@f16 = common global float 0.000000e+00, align 4

define void @caller_fpr_stack() {
  ; 32BIT-LABEL: name: caller_fpr_stack
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc @d15, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc @f14, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f0 = LFD 0, killed renamable $r3 :: (dereferenceable load (s64) from @d15)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc @f16, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $r4 :: (load (s32) from @f14)
  ; 32BIT-NEXT:   renamable $r4 = LWZ 0, killed renamable $r5 :: (load (s32) from @f16)
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 144, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r5 = LI 0
  ; 32BIT-NEXT:   renamable $r6 = LIS 16352
  ; 32BIT-NEXT:   STW killed renamable $r5, 60, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r5 = LIS 13107
  ; 32BIT-NEXT:   STW killed renamable $r6, 56, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16355
  ; 32BIT-NEXT:   renamable $r5 = ORI killed renamable $r5, 13107
  ; 32BIT-NEXT:   STW killed renamable $r5, 68, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r5 = LIS 26214
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 13107
  ; 32BIT-NEXT:   STW killed renamable $r6, 64, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16358
  ; 32BIT-NEXT:   renamable $r5 = ORI killed renamable $r5, 26214
  ; 32BIT-NEXT:   STW killed renamable $r5, 76, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r5 = LIS 39321
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 26214
  ; 32BIT-NEXT:   STW killed renamable $r6, 72, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16361
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 39321
  ; 32BIT-NEXT:   STW killed renamable $r6, 80, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 52428
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 52429
  ; 32BIT-NEXT:   STW killed renamable $r6, 92, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16364
  ; 32BIT-NEXT:   renamable $r5 = ORI killed renamable $r5, 39322
  ; 32BIT-NEXT:   STW renamable $r5, 84, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 52428
  ; 32BIT-NEXT:   STW killed renamable $r6, 88, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16313
  ; 32BIT-NEXT:   STW killed renamable $r5, 100, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r5 = LIS 49807
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 39321
  ; 32BIT-NEXT:   STW killed renamable $r6, 96, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16316
  ; 32BIT-NEXT:   renamable $r5 = ORI killed renamable $r5, 23593
  ; 32BIT-NEXT:   STW killed renamable $r5, 108, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r5 = LIS 60293
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 10485
  ; 32BIT-NEXT:   STW killed renamable $r6, 104, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16318
  ; 32BIT-NEXT:   renamable $r5 = ORI killed renamable $r5, 7864
  ; 32BIT-NEXT:   STW killed renamable $r5, 116, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r5 = LIS 2621
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 47185
  ; 32BIT-NEXT:   STW killed renamable $r6, 112, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16320
  ; 32BIT-NEXT:   renamable $r5 = ORI killed renamable $r5, 28836
  ; 32BIT-NEXT:   STW killed renamable $r5, 124, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.0, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r6, 41943
  ; 32BIT-NEXT:   STW killed renamable $r6, 120, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LWZtoc %const.1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.2, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f3 = LFD 0, killed renamable $r6 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r6 = LWZtoc %const.3, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f4 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.4, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f6 = LFD 0, killed renamable $r6 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r6 = LWZtoc %const.5, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f7 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.6, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f8 = LFD 0, killed renamable $r6 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r6 = LWZtoc %const.7, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f9 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.8, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $r6 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r6 = LWZtoc %const.9, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f11 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.10, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f12 = LFD 0, killed renamable $r6 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r6 = LWZtoc %const.11, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f13 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $f5 = LFS 0, killed renamable $r6 :: (load (s32) from constant-pool)
  ; 32BIT-NEXT:   STW killed renamable $r4, 140, $r1 :: (store (s32))
  ; 32BIT-NEXT:   STFD killed renamable $f0, 132, $r1 :: (store (s64))
  ; 32BIT-NEXT:   $f10 = COPY renamable $f1
  ; 32BIT-NEXT:   STW killed renamable $r3, 128, $r1 :: (store (s32))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .test_fpr_stack>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $f1, implicit $f2, implicit $f3, implicit $f4, implicit $f5, implicit $f6, implicit $f7, implicit $f8, implicit $f9, implicit killed $f10, implicit $f11, implicit $f12, implicit $f13, implicit $r2, implicit-def $r1, implicit-def dead $f1
  ; 32BIT-NEXT:   ADJCALLSTACKUP 144, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: caller_fpr_stack
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   renamable $x3 = LDtoc @f14, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LDtoc @d15, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x5 = LDtoc @f16, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $r3 = LWZ 0, killed renamable $x3 :: (load (s32) from @f14)
  ; 64BIT-NEXT:   renamable $x4 = LD 0, killed renamable $x4 :: (load (s64) from @d15)
  ; 64BIT-NEXT:   renamable $r5 = LWZ 0, killed renamable $x5 :: (load (s32) from @f16)
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 176, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x6 = LDtocCPT %const.0, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   STW killed renamable $r5, 168, $x1 :: (store (s32))
  ; 64BIT-NEXT:   renamable $x5 = LDtocCPT %const.1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x7 = LDtocCPT %const.2, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $x6 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x6 = LDtocCPT %const.3, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f3 = LFD 0, killed renamable $x5 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x5 = LDtocCPT %const.4, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f4 = LFD 0, killed renamable $x7 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x7 = LDtocCPT %const.5, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f6 = LFD 0, killed renamable $x6 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x6 = LDtocCPT %const.6, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f7 = LFD 0, killed renamable $x5 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   STD killed renamable $x4, 160, $x1 :: (store (s64))
  ; 64BIT-NEXT:   renamable $x4 = LDtocCPT %const.7, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f8 = LFD 0, killed renamable $x7 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x5 = LIS8 16320
  ; 64BIT-NEXT:   renamable $x7 = LDtocCPT %const.8, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f9 = LFD 0, killed renamable $x6 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x6 = LIS8 16318
  ; 64BIT-NEXT:   renamable $x8 = LDtocCPT %const.9, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $x4 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x4 = LIS8 16316
  ; 64BIT-NEXT:   renamable $f11 = LFD 0, killed renamable $x7 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x7 = LIS8 16313
  ; 64BIT-NEXT:   renamable $f12 = LFD 0, killed renamable $x8 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x8 = LDtocCPT %const.10, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x5 = ORI8 killed renamable $x5, 41943
  ; 64BIT-NEXT:   renamable $x6 = ORI8 killed renamable $x6, 47185
  ; 64BIT-NEXT:   renamable $x4 = ORI8 killed renamable $x4, 10485
  ; 64BIT-NEXT:   renamable $x7 = ORI8 killed renamable $x7, 39321
  ; 64BIT-NEXT:   renamable $f13 = LFD 0, killed renamable $x8 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x8 = LDtocCPT %const.11, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x5 = RLDIC killed renamable $x5, 32, 2
  ; 64BIT-NEXT:   renamable $x6 = RLDIC killed renamable $x6, 32, 2
  ; 64BIT-NEXT:   renamable $x4 = RLDIC killed renamable $x4, 32, 2
  ; 64BIT-NEXT:   renamable $x7 = RLDIC killed renamable $x7, 32, 2
  ; 64BIT-NEXT:   renamable $x5 = ORIS8 killed renamable $x5, 2621
  ; 64BIT-NEXT:   renamable $x6 = ORIS8 killed renamable $x6, 60293
  ; 64BIT-NEXT:   renamable $x4 = ORIS8 killed renamable $x4, 49807
  ; 64BIT-NEXT:   renamable $x7 = ORIS8 killed renamable $x7, 39321
  ; 64BIT-NEXT:   renamable $x5 = ORI8 killed renamable $x5, 28836
  ; 64BIT-NEXT:   renamable $x6 = ORI8 killed renamable $x6, 7864
  ; 64BIT-NEXT:   renamable $x4 = ORI8 killed renamable $x4, 23593
  ; 64BIT-NEXT:   renamable $f5 = LFS 0, killed renamable $x8 :: (load (s32) from constant-pool)
  ; 64BIT-NEXT:   renamable $x8 = LIS8 4091
  ; 64BIT-NEXT:   renamable $x8 = ORI8 killed renamable $x8, 13107
  ; 64BIT-NEXT:   renamable $x7 = ORI8 killed renamable $x7, 39322
  ; 64BIT-NEXT:   renamable $x8 = RLDIC killed renamable $x8, 34, 2
  ; 64BIT-NEXT:   renamable $x8 = ORIS8 killed renamable $x8, 52428
  ; 64BIT-NEXT:   renamable $x8 = ORI8 killed renamable $x8, 52429
  ; 64BIT-NEXT:   $f10 = COPY renamable $f1
  ; 64BIT-NEXT:   STW killed renamable $r3, 152, $x1 :: (store (s32))
  ; 64BIT-NEXT:   STD killed renamable $x5, 144, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x6, 136, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x4, 128, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x7, 120, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x8, 112, $x1 :: (store (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .test_fpr_stack>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $f1, implicit $f2, implicit $f3, implicit $f4, implicit $f5, implicit $f6, implicit $f7, implicit $f8, implicit $f9, implicit killed $f10, implicit $f11, implicit $f12, implicit $f13, implicit $x2, implicit-def $r1, implicit-def dead $f1
  ; 64BIT-NEXT:   ADJCALLSTACKUP 176, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %0 = load float, ptr @f14, align 4
  %1 = load double, ptr @d15, align 8
  %2 = load float, ptr @f16, align 4
  %call = call double @test_fpr_stack(double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, double 0x3FE6666666666666, double 8.000000e-01, double 9.000000e-01, double 1.000000e-01, double 1.100000e-01, double 1.200000e-01, double 1.300000e-01, float %0, double %1, float %2)
  ret void
}

define i32 @mix_callee(double %d1, double %d2, double %d3, double %d4, i8 zeroext %c1, i16 signext %s1, i64 %ll1, i32 %i1, i32 %i2, i32 %i3) {
  ; 32BIT-LABEL: name: mix_callee
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $f1, $f2, $f3, $f4
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r3 = LWZ 0, %fixed-stack.3 :: (load (s32) from %fixed-stack.3)
  ; 32BIT-NEXT:   renamable $r4 = LWZ 0, %fixed-stack.5 :: (load (s32) from %fixed-stack.5)
  ; 32BIT-NEXT:   renamable $r5 = LWZ 0, %fixed-stack.6 :: (load (s32) from %fixed-stack.6, align 8)
  ; 32BIT-NEXT:   renamable $r6 = LWZ 0, %fixed-stack.2 :: (load (s32) from %fixed-stack.2, align 8)
  ; 32BIT-NEXT:   renamable $r7 = LIS 17200
  ; 32BIT-NEXT:   STW killed renamable $r7, 0, %stack.1 :: (store (s32) into %stack.1, align 8)
  ; 32BIT-NEXT:   renamable $r7 = LWZ 0, %fixed-stack.1 :: (load (s32) from %fixed-stack.1)
  ; 32BIT-NEXT:   renamable $r4 = nsw ADD4 killed renamable $r5, killed renamable $r4
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.0, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r4, killed renamable $r3
  ; 32BIT-NEXT:   renamable $r4 = LWZ 0, %fixed-stack.0 :: (load (s32) from %fixed-stack.0, align 16)
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r6
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r7
  ; 32BIT-NEXT:   renamable $f0 = LFS 0, killed renamable $r5 :: (load (s32) from constant-pool)
  ; 32BIT-NEXT:   renamable $r3 = ADD4 killed renamable $r3, killed renamable $r4
  ; 32BIT-NEXT:   renamable $r3 = XORIS killed renamable $r3, 32768
  ; 32BIT-NEXT:   STW killed renamable $r3, 4, %stack.1 :: (store (s32) into %stack.1 + 4)
  ; 32BIT-NEXT:   renamable $f5 = LFD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f3, implicit $rm
  ; 32BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f4, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FSUB killed renamable $f5, killed renamable $f0, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f1, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FCTIWZ killed renamable $f0, implicit $rm
  ; 32BIT-NEXT:   STFD killed renamable $f0, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 32BIT-NEXT:   renamable $r3 = LWZ 4, %stack.0 :: (load (s32) from %stack.0 + 4, basealign 8)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: mix_callee
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $f1, $f2, $f3, $f4, $x7, $x8, $x9, $x10
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $x3 = LWZ8 0, %fixed-stack.1 :: (load (s32) from %fixed-stack.1)
  ; 64BIT-NEXT:   renamable $r4 = nsw ADD4 renamable $r7, renamable $r8, implicit killed $x8, implicit killed $x7, implicit-def $x4
  ; 64BIT-NEXT:   renamable $x5 = LWZ8 0, %fixed-stack.0 :: (load (s32) from %fixed-stack.0)
  ; 64BIT-NEXT:   renamable $x4 = ADD8 killed renamable $x4, killed renamable $x9
  ; 64BIT-NEXT:   renamable $x4 = ADD8 killed renamable $x4, killed renamable $x10
  ; 64BIT-NEXT:   renamable $x3 = ADD8 killed renamable $x4, killed renamable $x3
  ; 64BIT-NEXT:   renamable $x3 = ADD8 killed renamable $x3, killed renamable $x5
  ; 64BIT-NEXT:   renamable $x3 = EXTSW killed renamable $x3
  ; 64BIT-NEXT:   STD killed renamable $x3, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 64BIT-NEXT:   renamable $f0 = LFD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f3, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f4, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FCFID killed renamable $f0, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f1, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FCTIWZ killed renamable $f0, implicit $rm
  ; 64BIT-NEXT:   STFD killed renamable $f0, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 64BIT-NEXT:   renamable $x3 = LWZ8 4, %stack.0 :: (load (s32) from %stack.0 + 4, basealign 8)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
  entry:
    %add = fadd double %d1, %d2
    %add1 = fadd double %add, %d3
    %add2 = fadd double %add1, %d4
    %conv = zext i8 %c1 to i32
    %conv3 = sext i16 %s1 to i32
    %add4 = add nsw i32 %conv, %conv3
    %conv5 = sext i32 %add4 to i64
    %add6 = add nsw i64 %conv5, %ll1
    %conv7 = sext i32 %i1 to i64
    %add8 = add nsw i64 %add6, %conv7
    %conv9 = sext i32 %i2 to i64
    %add10 = add nsw i64 %add8, %conv9
    %conv11 = sext i32 %i3 to i64
    %add12 = add nsw i64 %add10, %conv11
    %conv13 = trunc i64 %add12 to i32
    %conv14 = sitofp i32 %conv13 to double
    %add15 = fadd double %conv14, %add2
    %conv16 = fptosi double %add15 to i32
    ret i32 %conv16
  }

define void @caller_mix() {
  ; 32BIT-LABEL: name: caller_mix
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 84, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LI 60
  ; 32BIT-NEXT:   STW killed renamable $r3, 80, $r1 :: (store (s32))
  ; 32BIT-NEXT:   renamable $r3 = LI 50
  ; 32BIT-NEXT:   STW killed renamable $r3, 76, $r1 :: (store (s32))
  ; 32BIT-NEXT:   renamable $r3 = LI 40
  ; 32BIT-NEXT:   STW killed renamable $r3, 72, $r1 :: (store (s32))
  ; 32BIT-NEXT:   renamable $r3 = LI 0
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc %const.0, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STW killed renamable $r3, 64, $r1 :: (store (s32))
  ; 32BIT-NEXT:   renamable $r3 = LI 2
  ; 32BIT-NEXT:   STW killed renamable $r3, 60, $r1 :: (store (s32))
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc %const.1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $r4 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc %const.2, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $r3 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc %const.3, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f3 = LFD 0, killed renamable $r4 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $f4 = LFD 0, killed renamable $r3 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r3 = LI 1
  ; 32BIT-NEXT:   STW killed renamable $r3, 56, $r1 :: (store (s32))
  ; 32BIT-NEXT:   renamable $r3 = LIS 457
  ; 32BIT-NEXT:   renamable $r3 = ORI killed renamable $r3, 50048
  ; 32BIT-NEXT:   STW killed renamable $r3, 68, $r1 :: (store (s32))
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .mix_callee>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $f1, implicit $f2, implicit $f3, implicit $f4, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 84, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: caller_mix
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 128, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LDtocCPT %const.0, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x4 = LDtocCPT %const.1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x5 = LDtocCPT %const.2, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $x3 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x3 = LDtocCPT %const.3, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $x4 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x4 = LI8 60
  ; 64BIT-NEXT:   renamable $f3 = LFD 0, killed renamable $x5 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x5 = LI8 50
  ; 64BIT-NEXT:   renamable $f4 = LFD 0, killed renamable $x3 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x3 = LIS8 457
  ; 64BIT-NEXT:   renamable $x9 = ORI8 killed renamable $x3, 50048
  ; 64BIT-NEXT:   $x7 = LI8 1
  ; 64BIT-NEXT:   $x8 = LI8 2
  ; 64BIT-NEXT:   $x10 = LI8 40
  ; 64BIT-NEXT:   STD killed renamable $x4, 120, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x5, 112, $x1 :: (store (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .mix_callee>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $f1, implicit $f2, implicit $f3, implicit $f4, implicit killed $x7, implicit killed $x8, implicit $x9, implicit killed $x10, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 128, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
  entry:
%call = call i32 @mix_callee(double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, i8 zeroext 1, i16 signext 2, i64 30000000, i32 40, i32 50, i32 60)
    ret void
  }

  define i32 @mix_floats(i32 %i1, i32 %i2, i32 %i3, i32 %i4, i32 %i5, i32 %i6, i32 %i7, i32 %i8, double %d1, double %d2, double %d3, double %d4, double %d5, double %d6, double %d7, double %d8, double %d9, double %d10, double %d11, double %d12, double %d13, double %d14) {
  ; 32BIT-LABEL: name: mix_floats
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   liveins: $f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, $f13, $r3, $r4, $r5, $r6, $r7, $r8, $r9, $r10
  ; 32BIT-NEXT: {{  $}}
  ; 32BIT-NEXT:   renamable $r11 = LIS 17200
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r4
  ; 32BIT-NEXT:   STW killed renamable $r11, 0, %stack.1 :: (store (s32) into %stack.1, align 8)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc %const.0, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r5
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r6
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r7
  ; 32BIT-NEXT:   renamable $f0 = LFS 0, killed renamable $r4 :: (load (s32) from constant-pool)
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r8
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r9
  ; 32BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, killed renamable $r10
  ; 32BIT-NEXT:   renamable $r3 = XORIS killed renamable $r3, 32768
  ; 32BIT-NEXT:   STW killed renamable $r3, 4, %stack.1 :: (store (s32) into %stack.1 + 4)
  ; 32BIT-NEXT:   renamable $f31 = LFD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 32BIT-NEXT:   renamable $f30 = LFD 0, %fixed-stack.0 :: (load (s64) from %fixed-stack.0, align 16)
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FSUB killed renamable $f31, killed renamable $f0, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f1, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f2, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f3, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f4, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f5, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f6, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f7, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f8, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f9, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f10, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f11, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f12, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f13, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f0, killed renamable $f30, implicit $rm
  ; 32BIT-NEXT:   renamable $f0 = nofpexcept FCTIWZ killed renamable $f0, implicit $rm
  ; 32BIT-NEXT:   STFD killed renamable $f0, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 32BIT-NEXT:   renamable $r3 = LWZ 4, %stack.0 :: (load (s32) from %stack.0 + 4, basealign 8)
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ;
  ; 64BIT-LABEL: name: mix_floats
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   liveins: $f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, $f13, $x3, $x4, $x5, $x6, $x7, $x8, $x9, $x10
  ; 64BIT-NEXT: {{  $}}
  ; 64BIT-NEXT:   renamable $f0 = LFD 0, %fixed-stack.0 :: (load (s64) from %fixed-stack.0)
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 renamable $r3, renamable $r4, implicit killed $x4, implicit killed $x3
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r5, implicit killed $x5
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r6, implicit killed $x6
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r7, implicit killed $x7
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r8, implicit killed $x8
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r9, implicit killed $x9
  ; 64BIT-NEXT:   renamable $r3 = nsw ADD4 killed renamable $r3, renamable $r10, implicit killed $x10
  ; 64BIT-NEXT:   renamable $x3 = EXTSW_32_64 killed renamable $r3
  ; 64BIT-NEXT:   STD killed renamable $x3, 0, %stack.1 :: (store (s64) into %stack.1)
  ; 64BIT-NEXT:   renamable $f31 = LFD 0, %stack.1 :: (load (s64) from %stack.1)
  ; 64BIT-NEXT:   renamable $f31 = nofpexcept FCFID killed renamable $f31, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f31, killed renamable $f1, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f2, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f3, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f4, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f5, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f6, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f7, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f8, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f9, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f10, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f11, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f12, implicit $rm
  ; 64BIT-NEXT:   renamable $f1 = nofpexcept FADD killed renamable $f1, killed renamable $f13, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FADD killed renamable $f1, killed renamable $f0, implicit $rm
  ; 64BIT-NEXT:   renamable $f0 = nofpexcept FCTIWZ killed renamable $f0, implicit $rm
  ; 64BIT-NEXT:   STFD killed renamable $f0, 0, %stack.0 :: (store (s64) into %stack.0)
  ; 64BIT-NEXT:   renamable $x3 = LWZ8 4, %stack.0 :: (load (s32) from %stack.0 + 4, basealign 8)
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
  entry:
    %add = add nsw i32 %i1, %i2
    %add1 = add nsw i32 %add, %i3
    %add2 = add nsw i32 %add1, %i4
    %add3 = add nsw i32 %add2, %i5
    %add4 = add nsw i32 %add3, %i6
    %add5 = add nsw i32 %add4, %i7
    %add6 = add nsw i32 %add5, %i8
    %conv = sitofp i32 %add6 to double
    %add7 = fadd double %conv, %d1
    %add8 = fadd double %add7, %d2
    %add9 = fadd double %add8, %d3
    %add10 = fadd double %add9, %d4
    %add11 = fadd double %add10, %d5
    %add12 = fadd double %add11, %d6
    %add13 = fadd double %add12, %d7
    %add14 = fadd double %add13, %d8
    %add15 = fadd double %add14, %d9
    %add16 = fadd double %add15, %d10
    %add17 = fadd double %add16, %d11
    %add18 = fadd double %add17, %d12
    %add19 = fadd double %add18, %d13
    %add20 = fadd double %add19, %d14
    %conv21 = fptosi double %add20 to i32
    ret i32 %conv21
  }

  define void @mix_floats_caller() {
  ; 32BIT-LABEL: name: mix_floats_caller
  ; 32BIT: bb.0.entry:
  ; 32BIT-NEXT:   ADJCALLSTACKDOWN 168, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   renamable $r3 = LI 0
  ; 32BIT-NEXT:   renamable $r4 = LIS 16352
  ; 32BIT-NEXT:   renamable $r5 = LIS 16368
  ; 32BIT-NEXT:   renamable $r6 = LIS 39321
  ; 32BIT-NEXT:   renamable $r7 = LIS 16313
  ; 32BIT-NEXT:   renamable $r8 = LIS 16329
  ; 32BIT-NEXT:   renamable $r9 = LIS 13107
  ; 32BIT-NEXT:   renamable $r10 = LIS 16339
  ; 32BIT-NEXT:   STW renamable $r3, 92, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r11 = LIS 16345
  ; 32BIT-NEXT:   STW killed renamable $r4, 88, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r4 = LIS 16355
  ; 32BIT-NEXT:   STW killed renamable $r3, 132, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r3 = LIS 26214
  ; 32BIT-NEXT:   STW killed renamable $r5, 128, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r5 = ORI killed renamable $r6, 39322
  ; 32BIT-NEXT:   STW renamable $r5, 60, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r7, 39321
  ; 32BIT-NEXT:   STW killed renamable $r6, 56, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = LIS 16358
  ; 32BIT-NEXT:   STW renamable $r5, 68, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r7 = ORI killed renamable $r8, 39321
  ; 32BIT-NEXT:   STW killed renamable $r7, 64, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r7 = ORI killed renamable $r9, 13107
  ; 32BIT-NEXT:   STW renamable $r7, 76, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r8 = ORI killed renamable $r10, 13107
  ; 32BIT-NEXT:   STW killed renamable $r8, 72, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r8 = LIS 16361
  ; 32BIT-NEXT:   STW renamable $r5, 84, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r9 = ORI killed renamable $r11, 39321
  ; 32BIT-NEXT:   STW killed renamable $r9, 80, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r9 = LIS 52428
  ; 32BIT-NEXT:   STW renamable $r7, 100, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r4 = ORI killed renamable $r4, 13107
  ; 32BIT-NEXT:   STW killed renamable $r4, 96, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r3 = ORI killed renamable $r3, 26214
  ; 32BIT-NEXT:   STW renamable $r3, 108, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r4 = ORI killed renamable $r6, 26214
  ; 32BIT-NEXT:   STW killed renamable $r4, 104, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r4 = LIS 16364
  ; 32BIT-NEXT:   STW renamable $r5, 116, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r8, 39321
  ; 32BIT-NEXT:   STW killed renamable $r6, 112, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r6 = ORI killed renamable $r9, 52429
  ; 32BIT-NEXT:   STW renamable $r6, 124, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r4 = ORI killed renamable $r4, 52428
  ; 32BIT-NEXT:   STW killed renamable $r4, 120, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r4 = LIS 16369
  ; 32BIT-NEXT:   STW killed renamable $r5, 140, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r4 = ORI killed renamable $r4, 39321
  ; 32BIT-NEXT:   STW killed renamable $r4, 136, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r4 = LIS 16371
  ; 32BIT-NEXT:   STW killed renamable $r7, 148, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r4 = ORI killed renamable $r4, 13107
  ; 32BIT-NEXT:   STW killed renamable $r4, 144, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r4 = LIS 16372
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.0, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STW killed renamable $r6, 156, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r4 = ORI killed renamable $r4, 52428
  ; 32BIT-NEXT:   STW killed renamable $r4, 152, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc %const.1, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   STW killed renamable $r3, 164, $r1 :: (store (s32) into unknown-address + 4, basealign 8)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc %const.2, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.3, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $r4 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc %const.4, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f3 = LFD 0, killed renamable $r3 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc %const.5, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f4 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.6, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f6 = LFD 0, killed renamable $r4 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc %const.7, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f7 = LFD 0, killed renamable $r3 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc %const.8, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f8 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.9, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f9 = LFD 0, killed renamable $r4 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r4 = LWZtoc %const.10, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f11 = LFD 0, killed renamable $r3 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r3 = LWZtoc %const.11, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f12 = LFD 0, killed renamable $r5 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r5 = LWZtoc %const.12, $r2 :: (load (s32) from got)
  ; 32BIT-NEXT:   renamable $f13 = LFD 0, killed renamable $r4 :: (load (s64) from constant-pool)
  ; 32BIT-NEXT:   renamable $r4 = LIS 16374
  ; 32BIT-NEXT:   renamable $f5 = LFS 0, killed renamable $r3 :: (load (s32) from constant-pool)
  ; 32BIT-NEXT:   renamable $r11 = ORI killed renamable $r4, 26214
  ; 32BIT-NEXT:   renamable $f10 = LFS 0, killed renamable $r5 :: (load (s32) from constant-pool)
  ; 32BIT-NEXT:   $r3 = LI 1
  ; 32BIT-NEXT:   $r4 = LI 2
  ; 32BIT-NEXT:   $r5 = LI 3
  ; 32BIT-NEXT:   $r6 = LI 4
  ; 32BIT-NEXT:   $r7 = LI 5
  ; 32BIT-NEXT:   $r8 = LI 6
  ; 32BIT-NEXT:   $r9 = LI 7
  ; 32BIT-NEXT:   $r10 = LI 8
  ; 32BIT-NEXT:   STW killed renamable $r11, 160, $r1 :: (store (s32), align 8)
  ; 32BIT-NEXT:   BL_NOP <mcsymbol .mix_floats>, csr_aix32, implicit-def dead $lr, implicit $rm, implicit $r3, implicit $r4, implicit $r5, implicit $r6, implicit $r7, implicit $r8, implicit $r9, implicit $r10, implicit $f1, implicit $f2, implicit $f3, implicit $f4, implicit $f5, implicit $f6, implicit $f7, implicit $f8, implicit $f9, implicit $f10, implicit $f11, implicit $f12, implicit $f13, implicit $r2, implicit-def $r1, implicit-def dead $r3
  ; 32BIT-NEXT:   ADJCALLSTACKUP 168, 0, implicit-def dead $r1, implicit $r1
  ; 32BIT-NEXT:   BLR implicit $lr, implicit $rm
  ;
  ; 64BIT-LABEL: name: mix_floats_caller
  ; 64BIT: bb.0.entry:
  ; 64BIT-NEXT:   ADJCALLSTACKDOWN 224, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   renamable $x3 = LI8 1023
  ; 64BIT-NEXT:   renamable $x4 = LI8 511
  ; 64BIT-NEXT:   renamable $x5 = LIS8 16374
  ; 64BIT-NEXT:   renamable $x6 = LIS8 16371
  ; 64BIT-NEXT:   renamable $x7 = LIS8 16358
  ; 64BIT-NEXT:   renamable $x8 = LIS8 16355
  ; 64BIT-NEXT:   renamable $x9 = LIS8 16339
  ; 64BIT-NEXT:   renamable $x10 = LIS8 4093
  ; 64BIT-NEXT:   renamable $x11 = LDtocCPT %const.0, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x29 = LIS8 16369
  ; 64BIT-NEXT:   renamable $x28 = LIS8 4091
  ; 64BIT-NEXT:   renamable $x12 = LDtocCPT %const.1, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x27 = LIS8 16361
  ; 64BIT-NEXT:   renamable $x31 = LDtocCPT %const.2, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f1 = LFD 0, killed renamable $x11 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x26 = LIS8 16345
  ; 64BIT-NEXT:   renamable $x11 = LDtocCPT %const.3, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f2 = LFD 0, killed renamable $x12 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x25 = LIS8 16329
  ; 64BIT-NEXT:   renamable $f3 = LFD 0, killed renamable $x31 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x24 = LIS8 16313
  ; 64BIT-NEXT:   renamable $x23 = LDtocCPT %const.4, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x22 = LDtocCPT %const.5, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x21 = LDtocCPT %const.6, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x20 = LDtocCPT %const.7, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x19 = LDtocCPT %const.8, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x18 = LDtocCPT %const.9, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x17 = LDtocCPT %const.10, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $f4 = LFD 0, killed renamable $x11 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x16 = LDtocCPT %const.11, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x11 = ORI8 killed renamable $x5, 26214
  ; 64BIT-NEXT:   renamable $x12 = ORI8 killed renamable $x6, 13107
  ; 64BIT-NEXT:   renamable $x0 = ORI8 killed renamable $x7, 26214
  ; 64BIT-NEXT:   renamable $x31 = ORI8 killed renamable $x8, 13107
  ; 64BIT-NEXT:   renamable $x30 = ORI8 killed renamable $x9, 13107
  ; 64BIT-NEXT:   renamable $x5 = ORI8 killed renamable $x10, 13107
  ; 64BIT-NEXT:   renamable $x6 = ORI8 killed renamable $x29, 39321
  ; 64BIT-NEXT:   renamable $x7 = ORI8 killed renamable $x28, 13107
  ; 64BIT-NEXT:   renamable $x8 = ORI8 killed renamable $x27, 39321
  ; 64BIT-NEXT:   renamable $x9 = ORI8 killed renamable $x26, 39321
  ; 64BIT-NEXT:   renamable $x10 = ORI8 killed renamable $x25, 39321
  ; 64BIT-NEXT:   renamable $x27 = ORI8 killed renamable $x24, 39321
  ; 64BIT-NEXT:   renamable $f6 = LFD 0, killed renamable $x23 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x26 = LDtocCPT %const.12, $x2 :: (load (s64) from got)
  ; 64BIT-NEXT:   renamable $x29 = RLDIC killed renamable $x3, 52, 2
  ; 64BIT-NEXT:   renamable $x28 = RLDIC killed renamable $x4, 53, 2
  ; 64BIT-NEXT:   renamable $x11 = RLDIMI killed renamable $x11, renamable $x11, 32, 0
  ; 64BIT-NEXT:   renamable $x12 = RLDIMI killed renamable $x12, renamable $x12, 32, 0
  ; 64BIT-NEXT:   renamable $x0 = RLDIMI killed renamable $x0, renamable $x0, 32, 0
  ; 64BIT-NEXT:   renamable $x31 = RLDIMI killed renamable $x31, renamable $x31, 32, 0
  ; 64BIT-NEXT:   renamable $x30 = RLDIMI killed renamable $x30, renamable $x30, 32, 0
  ; 64BIT-NEXT:   renamable $x3 = RLDIC killed renamable $x5, 34, 2
  ; 64BIT-NEXT:   renamable $x4 = RLDIC killed renamable $x6, 32, 2
  ; 64BIT-NEXT:   renamable $x5 = RLDIC killed renamable $x7, 34, 2
  ; 64BIT-NEXT:   renamable $x6 = RLDIC killed renamable $x8, 32, 2
  ; 64BIT-NEXT:   renamable $x7 = RLDIC killed renamable $x9, 32, 2
  ; 64BIT-NEXT:   renamable $x8 = RLDIC killed renamable $x10, 32, 2
  ; 64BIT-NEXT:   renamable $x9 = RLDIC killed renamable $x27, 32, 2
  ; 64BIT-NEXT:   renamable $x11 = RLWIMI8 killed renamable $x11, renamable $x11, 16, 0, 15
  ; 64BIT-NEXT:   renamable $x12 = RLWIMI8 killed renamable $x12, renamable $x12, 16, 0, 15
  ; 64BIT-NEXT:   renamable $x0 = RLWIMI8 killed renamable $x0, renamable $x0, 16, 0, 15
  ; 64BIT-NEXT:   renamable $x31 = RLWIMI8 killed renamable $x31, renamable $x31, 16, 0, 15
  ; 64BIT-NEXT:   renamable $x30 = RLWIMI8 killed renamable $x30, renamable $x30, 16, 0, 15
  ; 64BIT-NEXT:   renamable $x3 = ORIS8 killed renamable $x3, 52428
  ; 64BIT-NEXT:   renamable $x4 = ORIS8 killed renamable $x4, 39321
  ; 64BIT-NEXT:   renamable $x5 = ORIS8 killed renamable $x5, 52428
  ; 64BIT-NEXT:   renamable $x6 = ORIS8 killed renamable $x6, 39321
  ; 64BIT-NEXT:   renamable $x7 = ORIS8 killed renamable $x7, 39321
  ; 64BIT-NEXT:   renamable $x8 = ORIS8 killed renamable $x8, 39321
  ; 64BIT-NEXT:   renamable $x9 = ORIS8 killed renamable $x9, 39321
  ; 64BIT-NEXT:   renamable $f7 = LFD 0, killed renamable $x22 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x27 = ORI8 killed renamable $x3, 52429
  ; 64BIT-NEXT:   renamable $f8 = LFD 0, killed renamable $x21 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x25 = ORI8 killed renamable $x4, 39322
  ; 64BIT-NEXT:   renamable $f9 = LFD 0, killed renamable $x20 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x24 = ORI8 killed renamable $x5, 52429
  ; 64BIT-NEXT:   renamable $f11 = LFD 0, killed renamable $x19 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x23 = ORI8 killed renamable $x6, 39322
  ; 64BIT-NEXT:   renamable $f12 = LFD 0, killed renamable $x18 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x22 = ORI8 killed renamable $x7, 39322
  ; 64BIT-NEXT:   renamable $f13 = LFD 0, killed renamable $x17 :: (load (s64) from constant-pool)
  ; 64BIT-NEXT:   renamable $x21 = ORI8 killed renamable $x8, 39322
  ; 64BIT-NEXT:   renamable $f5 = LFS 0, killed renamable $x16 :: (load (s32) from constant-pool)
  ; 64BIT-NEXT:   renamable $x20 = ORI8 killed renamable $x9, 39322
  ; 64BIT-NEXT:   renamable $f10 = LFS 0, killed renamable $x26 :: (load (s32) from constant-pool)
  ; 64BIT-NEXT:   $x3 = LI8 1
  ; 64BIT-NEXT:   $x4 = LI8 2
  ; 64BIT-NEXT:   $x5 = LI8 3
  ; 64BIT-NEXT:   $x6 = LI8 4
  ; 64BIT-NEXT:   $x7 = LI8 5
  ; 64BIT-NEXT:   $x8 = LI8 6
  ; 64BIT-NEXT:   $x9 = LI8 7
  ; 64BIT-NEXT:   $x10 = LI8 8
  ; 64BIT-NEXT:   STD killed renamable $x29, 184, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x28, 144, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x11, 216, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x12, 200, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x0, 160, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x31, 152, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x30, 128, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x27, 208, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x25, 192, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x24, 176, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x23, 168, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x22, 136, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x21, 120, $x1 :: (store (s64))
  ; 64BIT-NEXT:   STD killed renamable $x20, 112, $x1 :: (store (s64))
  ; 64BIT-NEXT:   BL8_NOP <mcsymbol .mix_floats>, csr_ppc64, implicit-def dead $lr8, implicit $rm, implicit $x3, implicit $x4, implicit $x5, implicit $x6, implicit $x7, implicit $x8, implicit $x9, implicit $x10, implicit $f1, implicit $f2, implicit $f3, implicit $f4, implicit $f5, implicit $f6, implicit $f7, implicit $f8, implicit $f9, implicit $f10, implicit $f11, implicit $f12, implicit $f13, implicit $x2, implicit-def $r1, implicit-def dead $x3
  ; 64BIT-NEXT:   ADJCALLSTACKUP 224, 0, implicit-def dead $r1, implicit $r1
  ; 64BIT-NEXT:   BLR8 implicit $lr8, implicit $rm
  entry:
    %call = call i32 @mix_floats(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, double 1.000000e-01, double 2.000000e-01, double 3.000000e-01, double 4.000000e-01, double 5.000000e-01, double 6.000000e-01, double 0x3FE6666666666666, double 8.000000e-01, double 9.000000e-01, double 1.000000e+00, double 1.100000e+00, double 1.200000e+00, double 1.300000e+00, double 1.400000e+00)
    ret void
  }

