; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+sse3 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512F
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+xop,+avx | FileCheck %s --check-prefixes=XOPAVX1
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+xop,+avx2 | FileCheck %s --check-prefixes=XOPAVX2
;
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mcpu=slm | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mcpu=goldmont | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mcpu=btver2 | FileCheck %s --check-prefixes=AVX1

define i32 @cmp_int_eq(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_eq'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp eq i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp eq i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp eq i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp eq i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_eq'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp eq i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp eq i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp eq i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp eq i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_eq'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp eq i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp eq i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp eq i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp eq i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_eq'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp eq i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp eq i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp eq i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp eq i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_eq'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp eq i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp eq i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp eq i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp eq i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_eq'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp eq i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp eq i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp eq i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp eq i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_eq'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp eq i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp eq i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp eq i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp eq i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_eq'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp eq i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp eq i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp eq <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp eq i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp eq i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp eq i8 %arg8, %arg8
  %V16I8 = icmp eq <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp eq <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp eq <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp eq <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp eq i16 %arg16, %arg16
  %V8I16  = icmp eq <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp eq <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp eq <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp eq <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp eq i32 %arg32, %arg32
  %V4I32 = icmp eq <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp eq <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp eq <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp eq <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp eq i64 %arg64, %arg64
  %V2I64 = icmp eq <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp eq <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp eq <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp eq <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_ne(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ne'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ne i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ne i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ne i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ne i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ne'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ne i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ne i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ne i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ne i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ne'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ne i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ne i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ne i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ne i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ne'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ne i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ne i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ne i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ne i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ne'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ne i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ne i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ne i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ne i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ne'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ne i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ne i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ne i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ne i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ne'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ne i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ne i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ne i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ne i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ne'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ne i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ne i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ne <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ne i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ne i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp ne i8 %arg8, %arg8
  %V16I8 = icmp ne <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp ne <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp ne <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp ne <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp ne i16 %arg16, %arg16
  %V8I16  = icmp ne <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp ne <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp ne <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp ne <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp ne i32 %arg32, %arg32
  %V4I32 = icmp ne <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp ne <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp ne <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp ne <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp ne i64 %arg64, %arg64
  %V2I64 = icmp ne <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp ne <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp ne <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp ne <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_sge(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sge'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sge i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sge i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sge i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sge i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sge'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sge i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sge i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sge i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sge i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sge'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sge i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sge i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sge i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sge i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sge'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sge i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sge i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sge i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sge i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sge'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sge i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sge i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sge i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sge i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sge'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sge i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sge i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sge i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sge i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sge'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sge i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sge i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sge i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sge i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sge'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sge i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sge i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sge <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sge i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sge i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp sge i8 %arg8, %arg8
  %V16I8 = icmp sge <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp sge <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp sge <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp sge <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp sge i16 %arg16, %arg16
  %V8I16  = icmp sge <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp sge <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp sge <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp sge <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp sge i32 %arg32, %arg32
  %V4I32 = icmp sge <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp sge <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp sge <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp sge <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp sge i64 %arg64, %arg64
  %V2I64 = icmp sge <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp sge <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp sge <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp sge <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_uge(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE42-LABEL: 'cmp_int_uge'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp uge i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp uge i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp uge i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp uge i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_uge'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp uge i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp uge i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp uge i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp uge i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_uge'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp uge i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp uge i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp uge i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp uge i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_uge'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp uge i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp uge i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp uge i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp uge i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_uge'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp uge i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp uge i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp uge i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp uge i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_uge'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp uge i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp uge i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp uge i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp uge i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_uge'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp uge i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp uge i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp uge <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp uge i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp uge i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp uge i8 %arg8, %arg8
  %V16I8 = icmp uge <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp uge <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp uge <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp uge <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp uge i16 %arg16, %arg16
  %V8I16  = icmp uge <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp uge <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp uge <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp uge <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp uge i32 %arg32, %arg32
  %V4I32 = icmp uge <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp uge <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp uge <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp uge <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp uge i64 %arg64, %arg64
  %V2I64 = icmp uge <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp uge <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp uge <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp uge <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_sgt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sgt'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sgt i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sgt i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sgt i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sgt i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sgt'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sgt i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sgt i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sgt i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sgt i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sgt'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sgt i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sgt i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sgt i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sgt i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sgt'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sgt i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sgt i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sgt i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sgt i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sgt'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sgt i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sgt i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sgt i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sgt i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sgt'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sgt i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sgt i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sgt i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sgt i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sgt'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sgt i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sgt i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sgt i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sgt i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sgt'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sgt i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sgt i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sgt <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sgt i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sgt i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp sgt i8 %arg8, %arg8
  %V16I8 = icmp sgt <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp sgt <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp sgt <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp sgt <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp sgt i16 %arg16, %arg16
  %V8I16  = icmp sgt <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp sgt <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp sgt <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp sgt <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp sgt i32 %arg32, %arg32
  %V4I32 = icmp sgt <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp sgt <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp sgt <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp sgt <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp sgt i64 %arg64, %arg64
  %V2I64 = icmp sgt <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp sgt <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp sgt <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp sgt <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_ugt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ugt'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ugt i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ugt i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ugt i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ugt i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ugt'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ugt i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ugt i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ugt i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ugt i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ugt'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ugt i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ugt i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ugt i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ugt i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ugt'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ugt i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ugt i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ugt i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ugt i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ugt'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ugt i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ugt i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ugt i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ugt i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ugt'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ugt i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ugt i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ugt i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ugt i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ugt'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ugt i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ugt i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ugt i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ugt i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ugt'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ugt i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ugt i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ugt <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ugt i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ugt i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp ugt i8 %arg8, %arg8
  %V16I8 = icmp ugt <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp ugt <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp ugt <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp ugt <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp ugt i16 %arg16, %arg16
  %V8I16  = icmp ugt <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp ugt <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp ugt <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp ugt <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp ugt i32 %arg32, %arg32
  %V4I32 = icmp ugt <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp ugt <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp ugt <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp ugt <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp ugt i64 %arg64, %arg64
  %V2I64 = icmp ugt <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp ugt <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp ugt <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp ugt <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_sle(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_sle'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sle i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sle i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sle i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sle i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_sle'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sle i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sle i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sle i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sle i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_sle'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sle i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sle i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sle i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sle i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_sle'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sle i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sle i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sle i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sle i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_sle'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sle i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sle i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sle i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sle i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_sle'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sle i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sle i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sle i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sle i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_sle'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sle i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sle i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sle i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sle i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_sle'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp sle i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp sle i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp sle <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp sle i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp sle i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp sle i8 %arg8, %arg8
  %V16I8 = icmp sle <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp sle <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp sle <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp sle <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp sle i16 %arg16, %arg16
  %V8I16  = icmp sle <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp sle <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp sle <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp sle <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp sle i32 %arg32, %arg32
  %V4I32 = icmp sle <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp sle <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp sle <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp sle <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp sle i64 %arg64, %arg64
  %V2I64 = icmp sle <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp sle <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp sle <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp sle <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_ule(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE42-LABEL: 'cmp_int_ule'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ule i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ule i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ule i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ule i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ule'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ule i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ule i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ule i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ule i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ule'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ule i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ule i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ule i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ule i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ule'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ule i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ule i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ule i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ule i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ule'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ule i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ule i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ule i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ule i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ule'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ule i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ule i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ule i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ule i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ule'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ule i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ule i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ule <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ule i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ule i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp ule i8 %arg8, %arg8
  %V16I8 = icmp ule <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp ule <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp ule <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp ule <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp ule i16 %arg16, %arg16
  %V8I16  = icmp ule <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp ule <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp ule <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp ule <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp ule i32 %arg32, %arg32
  %V4I32 = icmp ule <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp ule <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp ule <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp ule <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp ule i64 %arg64, %arg64
  %V2I64 = icmp ule <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp ule <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp ule <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp ule <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_slt(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_slt'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp slt i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp slt i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp slt i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp slt i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_slt'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp slt i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp slt i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp slt i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp slt i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_slt'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp slt i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp slt i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp slt i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp slt i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_slt'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp slt i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp slt i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp slt i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp slt i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_slt'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp slt i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp slt i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp slt i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp slt i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_slt'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp slt i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp slt i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp slt i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp slt i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_slt'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp slt i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp slt i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp slt i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp slt i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_slt'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp slt i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp slt i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp slt <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp slt i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp slt i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp slt i8 %arg8, %arg8
  %V16I8 = icmp slt <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp slt <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp slt <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp slt <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp slt i16 %arg16, %arg16
  %V8I16  = icmp slt <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp slt <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp slt <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp slt <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp slt i32 %arg32, %arg32
  %V4I32 = icmp slt <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp slt <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp slt <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp slt <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp slt i64 %arg64, %arg64
  %V2I64 = icmp slt <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp slt <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp slt <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp slt <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

define i32 @cmp_int_ult(i8 %arg8, <16 x i8> %argv16i8, <32 x i8> %argv32i8, <64 x i8> %argv64i8, <128 x i8> %argv128i8, i16 %arg16, <8 x i16> %argv8i16, <16 x i16> %argv16i16, <32 x i16> %argv32i16, <64 x i16> %argv64i16, i32 %arg32, <4 x i32> %argv4i32, <8 x i32> %argv8i32, <16 x i32> %argv16i32, <32 x i32> %argv32i32, i64 %arg64, <2 x i64> %argv2i64, <4 x i64> %argv4i64, <8 x i64> %argv8i64, <16 x i64> %argv16i64) {
; SSE2-LABEL: 'cmp_int_ult'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ult i8 %arg8, %arg8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ult i16 %arg16, %arg16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ult i32 %arg32, %arg32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ult i64 %arg64, %arg64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; SSE42-LABEL: 'cmp_int_ult'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ult i8 %arg8, %arg8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ult i16 %arg16, %arg16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ult i32 %arg32, %arg32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ult i64 %arg64, %arg64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX1-LABEL: 'cmp_int_ult'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ult i8 %arg8, %arg8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ult i16 %arg16, %arg16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ult i32 %arg32, %arg32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ult i64 %arg64, %arg64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX2-LABEL: 'cmp_int_ult'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ult i8 %arg8, %arg8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ult i16 %arg16, %arg16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ult i32 %arg32, %arg32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ult i64 %arg64, %arg64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512F-LABEL: 'cmp_int_ult'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ult i8 %arg8, %arg8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ult i16 %arg16, %arg16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ult i32 %arg32, %arg32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ult i64 %arg64, %arg64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512BW-LABEL: 'cmp_int_ult'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ult i8 %arg8, %arg8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ult i16 %arg16, %arg16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ult i32 %arg32, %arg32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ult i64 %arg64, %arg64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX1-LABEL: 'cmp_int_ult'
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ult i8 %arg8, %arg8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ult i16 %arg16, %arg16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ult i32 %arg32, %arg32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ult i64 %arg64, %arg64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; XOPAVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; XOPAVX2-LABEL: 'cmp_int_ult'
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = icmp ult i8 %arg8, %arg8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = icmp ult i16 %arg16, %arg16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8I16 = icmp ult <8 x i16> %argv8i16, %argv8i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = icmp ult i32 %arg32, %arg32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = icmp ult i64 %arg64, %arg64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64
; XOPAVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %I8 = icmp ult i8 %arg8, %arg8
  %V16I8 = icmp ult <16 x i8> %argv16i8, %argv16i8
  %V32I8 = icmp ult <32 x i8> %argv32i8, %argv32i8
  %V64I8 = icmp ult <64 x i8> %argv64i8, %argv64i8
  %V128I8 = icmp ult <128 x i8> %argv128i8, %argv128i8

  %I16 = icmp ult i16 %arg16, %arg16
  %V8I16  = icmp ult <8 x i16> %argv8i16, %argv8i16
  %V16I16 = icmp ult <16 x i16> %argv16i16, %argv16i16
  %V32I16 = icmp ult <32 x i16> %argv32i16, %argv32i16
  %V64I16 = icmp ult <64 x i16> %argv64i16, %argv64i16

  %I32 = icmp ult i32 %arg32, %arg32
  %V4I32 = icmp ult <4 x i32> %argv4i32, %argv4i32
  %V8I32 = icmp ult <8 x i32> %argv8i32, %argv8i32
  %V16I32 = icmp ult <16 x i32> %argv16i32, %argv16i32
  %V32I32 = icmp ult <32 x i32> %argv32i32, %argv32i32

  %I64 = icmp ult i64 %arg64, %arg64
  %V2I64 = icmp ult <2 x i64> %argv2i64, %argv2i64
  %V4I64 = icmp ult <4 x i64> %argv4i64, %argv4i64
  %V8I64 = icmp ult <8 x i64> %argv8i64, %argv8i64
  %V16I64 = icmp ult <16 x i64> %argv16i64, %argv16i64

  ret i32 undef
}

