; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

;
; FADDA
;

define half @fadda_v4f16(half %start, <4 x half> %a) {
; CHECK-LABEL: fadda_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    mov z2.h, z1.h[1]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[2]
; CHECK-NEXT:    mov z1.h, z1.h[3]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fadd.v4f16(half %start, <4 x half> %a)
  ret half %res
}

define half @fadda_v8f16(half %start, <8 x half> %a) {
; CHECK-LABEL: fadda_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    mov z2.h, z1.h[1]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[2]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[3]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[4]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[5]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[6]
; CHECK-NEXT:    mov z1.h, z1.h[7]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr h1, [sp]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fadd.v8f16(half %start, <8 x half> %a)
  ret half %res
}

define half @fadda_v16f16(half %start, ptr %a) {
; CHECK-LABEL: fadda_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q1, [x0]
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    mov z2.h, z1.h[1]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[2]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[3]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[4]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[5]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[6]
; CHECK-NEXT:    mov z1.h, z1.h[7]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    mov z2.h, z1.h[1]
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[2]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[3]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[4]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[5]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    mov z2.h, z1.h[6]
; CHECK-NEXT:    mov z1.h, z1.h[7]
; CHECK-NEXT:    fadd h0, h0, h2
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x0]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    ldr h1, [sp]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #16]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #18]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #20]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #30]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call half @llvm.vector.reduce.fadd.v16f16(half %start, <16 x half> %op)
  ret half %res
}

define float @fadda_v2f32(float %start, <2 x float> %a) {
; CHECK-LABEL: fadda_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    mov z1.s, z1.s[1]
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    fadd s0, s0, s2
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fadd.v2f32(float %start, <2 x float> %a)
  ret float %res
}

define float @fadda_v4f32(float %start, <4 x float> %a) {
; CHECK-LABEL: fadda_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    mov z2.s, z1.s[1]
; CHECK-NEXT:    fadd s0, s0, s2
; CHECK-NEXT:    mov z2.s, z1.s[2]
; CHECK-NEXT:    mov z1.s, z1.s[3]
; CHECK-NEXT:    fadd s0, s0, s2
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp]
; NONEON-NOSVE-NEXT:    fadd s0, s0, s2
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    fadd s0, s0, s2
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fadd.v4f32(float %start, <4 x float> %a)
  ret float %res
}

define float @fadda_v8f32(float %start, ptr %a) {
; CHECK-LABEL: fadda_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q1, [x0]
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    mov z2.s, z1.s[1]
; CHECK-NEXT:    fadd s0, s0, s2
; CHECK-NEXT:    mov z2.s, z1.s[2]
; CHECK-NEXT:    mov z1.s, z1.s[3]
; CHECK-NEXT:    fadd s0, s0, s2
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    mov z2.s, z1.s[1]
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    fadd s0, s0, s2
; CHECK-NEXT:    mov z2.s, z1.s[2]
; CHECK-NEXT:    mov z1.s, z1.s[3]
; CHECK-NEXT:    fadd s0, s0, s2
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x0]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp]
; NONEON-NOSVE-NEXT:    fadd s0, s0, s2
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    fadd s0, s0, s2
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #16]
; NONEON-NOSVE-NEXT:    fadd s0, s0, s2
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    fadd s0, s0, s2
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call float @llvm.vector.reduce.fadd.v8f32(float %start, <8 x float> %op)
  ret float %res
}

define double @fadda_v1f64(double %start, <1 x double> %a) {
; CHECK-LABEL: fadda_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    fadd d0, d0, d1
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fadd.v1f64(double %start, <1 x double> %a)
  ret double %res
}

define double @fadda_v2f64(double %start, <2 x double> %a) {
; CHECK-LABEL: fadda_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    mov z1.d, z1.d[1]
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp d2, d1, [sp], #16
; NONEON-NOSVE-NEXT:    fadd d0, d0, d2
; NONEON-NOSVE-NEXT:    fadd d0, d0, d1
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fadd.v2f64(double %start, <2 x double> %a)
  ret double %res
}

define double @fadda_v4f64(double %start, ptr %a) {
; CHECK-LABEL: fadda_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q1, [x0]
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    mov z1.d, z1.d[1]
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    ldr q1, [x0, #16]
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    mov z1.d, z1.d[1]
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fadda_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr q1, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x0]
; NONEON-NOSVE-NEXT:    str q1, [sp]
; NONEON-NOSVE-NEXT:    ldp d2, d1, [sp]
; NONEON-NOSVE-NEXT:    fadd d0, d0, d2
; NONEON-NOSVE-NEXT:    fadd d0, d0, d1
; NONEON-NOSVE-NEXT:    ldp d2, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    fadd d0, d0, d2
; NONEON-NOSVE-NEXT:    fadd d0, d0, d1
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call double @llvm.vector.reduce.fadd.v4f64(double %start, <4 x double> %op)
  ret double %res
}

;
; FADDV
;

define half @faddv_v4f16(half %start, <4 x half> %a) {
; CHECK-LABEL: faddv_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    faddv h1, p0, z1.h
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call fast half @llvm.vector.reduce.fadd.v4f16(half %start, <4 x half> %a)
  ret half %res
}

define half @faddv_v8f16(half %start, <8 x half> %a) {
; CHECK-LABEL: faddv_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    faddv h1, p0, z1.h
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr h1, [sp]
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call fast half @llvm.vector.reduce.fadd.v8f16(half %start, <8 x half> %a)
  ret half %res
}

define half @faddv_v16f16(half %start, ptr %a) {
; CHECK-LABEL: faddv_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q2, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fadd z1.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    faddv h1, p0, z1.h
; CHECK-NEXT:    fadd h0, h0, h1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #18]
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h4, [sp]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt s4, h4
; NONEON-NOSVE-NEXT:    fadd s1, s2, s1
; NONEON-NOSVE-NEXT:    fadd s2, s4, s3
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h4, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt s4, h4
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt h2, s2
; NONEON-NOSVE-NEXT:    fadd s3, s4, s3
; NONEON-NOSVE-NEXT:    ldr h4, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s4, h4
; NONEON-NOSVE-NEXT:    fadd s1, s2, s1
; NONEON-NOSVE-NEXT:    fcvt h2, s3
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fadd s3, s4, s3
; NONEON-NOSVE-NEXT:    ldr h4, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s4, h4
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fcvt h2, s3
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fadd s3, s4, s3
; NONEON-NOSVE-NEXT:    ldr h4, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s4, h4
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fcvt h2, s3
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fadd s3, s4, s3
; NONEON-NOSVE-NEXT:    ldr h4, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s4, h4
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fcvt h2, s3
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fadd s2, s4, s3
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr h4, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt s4, h4
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt h2, s2
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fadd s2, s4, s3
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt h2, s2
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call fast half @llvm.vector.reduce.fadd.v16f16(half %start, <16 x half> %op)
  ret half %res
}

define float @faddv_v2f32(float %start, <2 x float> %a) {
; CHECK-LABEL: faddv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    faddv s1, p0, z1.s
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    fadd s1, s2, s1
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call fast float @llvm.vector.reduce.fadd.v2f32(float %start, <2 x float> %a)
  ret float %res
}

define float @faddv_v4f32(float %start, <4 x float> %a) {
; CHECK-LABEL: faddv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    faddv s1, p0, z1.s
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp s4, s3, [sp], #16
; NONEON-NOSVE-NEXT:    fadd s3, s4, s3
; NONEON-NOSVE-NEXT:    fadd s1, s2, s1
; NONEON-NOSVE-NEXT:    fadd s1, s3, s1
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    ret
  %res = call fast float @llvm.vector.reduce.fadd.v4f32(float %start, <4 x float> %a)
  ret float %res
}

define float @faddv_v8f32(float %start, ptr %a) {
; CHECK-LABEL: faddv_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q2, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fadd z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    faddv s1, p0, z1.s
; CHECK-NEXT:    fadd s0, s0, s1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp s4, s3, [sp]
; NONEON-NOSVE-NEXT:    ldp s5, s6, [sp, #24]
; NONEON-NOSVE-NEXT:    ldp s7, s16, [sp, #8]
; NONEON-NOSVE-NEXT:    fadd s1, s3, s1
; NONEON-NOSVE-NEXT:    fadd s2, s4, s2
; NONEON-NOSVE-NEXT:    fadd s3, s7, s5
; NONEON-NOSVE-NEXT:    fadd s4, s16, s6
; NONEON-NOSVE-NEXT:    fadd s1, s2, s1
; NONEON-NOSVE-NEXT:    fadd s2, s3, s4
; NONEON-NOSVE-NEXT:    fadd s1, s1, s2
; NONEON-NOSVE-NEXT:    fadd s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call fast float @llvm.vector.reduce.fadd.v8f32(float %start, <8 x float> %op)
  ret float %res
}

define double @faddv_v1f64(double %start, <1 x double> %a) {
; CHECK-LABEL: faddv_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    fadd d0, d0, d1
; NONEON-NOSVE-NEXT:    ret
  %res = call fast double @llvm.vector.reduce.fadd.v1f64(double %start, <1 x double> %a)
  ret double %res
}

define double @faddv_v2f64(double %start, <2 x double> %a) {
; CHECK-LABEL: faddv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    faddv d1, p0, z1.d
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q1, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp d2, d1, [sp], #16
; NONEON-NOSVE-NEXT:    fadd d1, d2, d1
; NONEON-NOSVE-NEXT:    fadd d0, d0, d1
; NONEON-NOSVE-NEXT:    ret
  %res = call fast double @llvm.vector.reduce.fadd.v2f64(double %start, <2 x double> %a)
  ret double %res
}

define double @faddv_v4f64(double %start, ptr %a) {
; CHECK-LABEL: faddv_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q2, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fadd z1.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    faddv d1, p0, z1.d
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: faddv_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp d2, d1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d4, d3, [sp], #32
; NONEON-NOSVE-NEXT:    fadd d1, d3, d1
; NONEON-NOSVE-NEXT:    fadd d2, d4, d2
; NONEON-NOSVE-NEXT:    fadd d1, d2, d1
; NONEON-NOSVE-NEXT:    fadd d0, d0, d1
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call fast double @llvm.vector.reduce.fadd.v4f64(double %start, <4 x double> %op)
  ret double %res
}

;
; FMAXNMV
;

define half @fmaxv_v4f16(<4 x half> %a) {
; CHECK-LABEL: fmaxv_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fmaxnmv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fmax.v4f16(<4 x half> %a)
  ret half %res
}

define half @fmaxv_v8f16(<8 x half> %a) {
; CHECK-LABEL: fmaxv_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fmaxnmv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr h0, [sp]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fmax.v8f16(<8 x half> %a)
  ret half %res
}

define half @fmaxv_v16f16(ptr %a) {
; CHECK-LABEL: fmaxv_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fmaxnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    fmaxnmv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #18]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h3, [sp]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmaxnm s0, s1, s0
; NONEON-NOSVE-NEXT:    fmaxnm s1, s3, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fmaxnm s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmaxnm s0, s1, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmaxnm s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmaxnm s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmaxnm s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fmaxnm s1, s3, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fmaxnm s1, s3, s2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call half @llvm.vector.reduce.fmax.v16f16(<16 x half> %op)
  ret half %res
}

define float @fmaxv_v2f32(<2 x float> %a) {
; CHECK-LABEL: fmaxv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fmaxnmv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #8]
; NONEON-NOSVE-NEXT:    fmaxnm s0, s1, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> %a)
  ret float %res
}

define float @fmaxv_v4f32(<4 x float> %a) {
; CHECK-LABEL: fmaxv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fmaxnmv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp]
; NONEON-NOSVE-NEXT:    fmaxnm s0, s1, s0
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s2
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> %a)
  ret float %res
}

define float @fmaxv_v8f32(ptr %a) {
; CHECK-LABEL: fmaxv_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fmaxnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    fmaxnmv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp s3, s2, [sp]
; NONEON-NOSVE-NEXT:    fmaxnm s0, s2, s0
; NONEON-NOSVE-NEXT:    fmaxnm s1, s3, s1
; NONEON-NOSVE-NEXT:    ldp s2, s4, [sp, #8]
; NONEON-NOSVE-NEXT:    fmaxnm s0, s1, s0
; NONEON-NOSVE-NEXT:    ldp s3, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    fmaxnm s2, s2, s3
; NONEON-NOSVE-NEXT:    fmaxnm s1, s4, s1
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s2
; NONEON-NOSVE-NEXT:    fmaxnm s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> %op)
  ret float %res
}

define double @fmaxv_v1f64(<1 x double> %a) {
; CHECK-LABEL: fmaxv_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fmax.v1f64(<1 x double> %a)
  ret double %res
}

define double @fmaxv_v2f64(<2 x double> %a) {
; CHECK-LABEL: fmaxv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fmaxnmv d0, p0, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp], #16
; NONEON-NOSVE-NEXT:    fmaxnm d0, d1, d0
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> %a)
  ret double %res
}

define double @fmaxv_v4f64(ptr %a) {
; CHECK-LABEL: fmaxv_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fmaxnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    fmaxnmv d0, p0, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaxv_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d3, d2, [sp], #32
; NONEON-NOSVE-NEXT:    fmaxnm d0, d2, d0
; NONEON-NOSVE-NEXT:    fmaxnm d1, d3, d1
; NONEON-NOSVE-NEXT:    fmaxnm d0, d1, d0
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> %op)
  ret double %res
}

;
; FMINNMV
;

define half @fminv_v4f16(<4 x half> %a) {
; CHECK-LABEL: fminv_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fminnmv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fmin.v4f16(<4 x half> %a)
  ret half %res
}

define half @fminv_v8f16(<8 x half> %a) {
; CHECK-LABEL: fminv_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fminnmv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr h0, [sp]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fmin.v8f16(<8 x half> %a)
  ret half %res
}

define half @fminv_v16f16(ptr %a) {
; CHECK-LABEL: fminv_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fminnm z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    fminnmv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #18]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h3, [sp]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fminnm s0, s1, s0
; NONEON-NOSVE-NEXT:    fminnm s1, s3, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fminnm s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fminnm s0, s1, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fminnm s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fminnm s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fminnm s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fminnm s1, s3, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fminnm s1, s3, s2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call half @llvm.vector.reduce.fmin.v16f16(<16 x half> %op)
  ret half %res
}

define float @fminv_v2f32(<2 x float> %a) {
; CHECK-LABEL: fminv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fminnmv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #8]
; NONEON-NOSVE-NEXT:    fminnm s0, s1, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fmin.v2f32(<2 x float> %a)
  ret float %res
}

define float @fminv_v4f32(<4 x float> %a) {
; CHECK-LABEL: fminv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fminnmv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp]
; NONEON-NOSVE-NEXT:    fminnm s0, s1, s0
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s2
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fmin.v4f32(<4 x float> %a)
  ret float %res
}

define float @fminv_v8f32(ptr %a) {
; CHECK-LABEL: fminv_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fminnm z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    fminnmv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp s3, s2, [sp]
; NONEON-NOSVE-NEXT:    fminnm s0, s2, s0
; NONEON-NOSVE-NEXT:    fminnm s1, s3, s1
; NONEON-NOSVE-NEXT:    ldp s2, s4, [sp, #8]
; NONEON-NOSVE-NEXT:    fminnm s0, s1, s0
; NONEON-NOSVE-NEXT:    ldp s3, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    fminnm s2, s2, s3
; NONEON-NOSVE-NEXT:    fminnm s1, s4, s1
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s2
; NONEON-NOSVE-NEXT:    fminnm s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call float @llvm.vector.reduce.fmin.v8f32(<8 x float> %op)
  ret float %res
}

define double @fminv_v1f64(<1 x double> %a) {
; CHECK-LABEL: fminv_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fmin.v1f64(<1 x double> %a)
  ret double %res
}

define double @fminv_v2f64(<2 x double> %a) {
; CHECK-LABEL: fminv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fminnmv d0, p0, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp], #16
; NONEON-NOSVE-NEXT:    fminnm d0, d1, d0
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fmin.v2f64(<2 x double> %a)
  ret double %res
}

define double @fminv_v4f64(ptr %a) {
; CHECK-LABEL: fminv_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fminnm z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    fminnmv d0, p0, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminv_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d3, d2, [sp], #32
; NONEON-NOSVE-NEXT:    fminnm d0, d2, d0
; NONEON-NOSVE-NEXT:    fminnm d1, d3, d1
; NONEON-NOSVE-NEXT:    fminnm d0, d1, d0
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call double @llvm.vector.reduce.fmin.v4f64(<4 x double> %op)
  ret double %res
}

;
; FMAXV
;

define half @fmaximumv_v4f16(<4 x half> %a) {
; CHECK-LABEL: fmaximumv_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fmaxv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fmaximum.v4f16(<4 x half> %a)
  ret half %res
}

define half @fmaximumv_v8f16(<8 x half> %a) {
; CHECK-LABEL: fmaximumv_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fmaxv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr h0, [sp]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fmaximum.v8f16(<8 x half> %a)
  ret half %res
}

define half @fmaximumv_v16f16(ptr %a) {
; CHECK-LABEL: fmaximumv_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fmax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    fmaxv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #18]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h3, [sp]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmax s0, s1, s0
; NONEON-NOSVE-NEXT:    fmax s1, s3, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fmax s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmax s0, s1, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmax s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmax s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmax s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    fmax s1, s3, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    fmax s1, s3, s2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call half @llvm.vector.reduce.fmaximum.v16f16(<16 x half> %op)
  ret half %res
}

define float @fmaximumv_v2f32(<2 x float> %a) {
; CHECK-LABEL: fmaximumv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fmaxv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #8]
; NONEON-NOSVE-NEXT:    fmax s0, s1, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fmaximum.v2f32(<2 x float> %a)
  ret float %res
}

define float @fmaximumv_v4f32(<4 x float> %a) {
; CHECK-LABEL: fmaximumv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fmaxv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp]
; NONEON-NOSVE-NEXT:    fmax s0, s1, s0
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    fmax s0, s0, s2
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fmaximum.v4f32(<4 x float> %a)
  ret float %res
}

define float @fmaximumv_v8f32(ptr %a) {
; CHECK-LABEL: fmaximumv_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fmax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    fmaxv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp s3, s2, [sp]
; NONEON-NOSVE-NEXT:    fmax s0, s2, s0
; NONEON-NOSVE-NEXT:    fmax s1, s3, s1
; NONEON-NOSVE-NEXT:    ldp s2, s4, [sp, #8]
; NONEON-NOSVE-NEXT:    fmax s0, s1, s0
; NONEON-NOSVE-NEXT:    ldp s3, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    fmax s2, s2, s3
; NONEON-NOSVE-NEXT:    fmax s1, s4, s1
; NONEON-NOSVE-NEXT:    fmax s0, s0, s2
; NONEON-NOSVE-NEXT:    fmax s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call float @llvm.vector.reduce.fmaximum.v8f32(<8 x float> %op)
  ret float %res
}

define double @fmaximumv_v1f64(<1 x double> %a) {
; CHECK-LABEL: fmaximumv_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fmaximum.v1f64(<1 x double> %a)
  ret double %res
}

define double @fmaximumv_v2f64(<2 x double> %a) {
; CHECK-LABEL: fmaximumv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fmaxv d0, p0, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp], #16
; NONEON-NOSVE-NEXT:    fmax d0, d1, d0
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fmaximum.v2f64(<2 x double> %a)
  ret double %res
}

define double @fmaximumv_v4f64(ptr %a) {
; CHECK-LABEL: fmaximumv_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fmax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    fmaxv d0, p0, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fmaximumv_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d3, d2, [sp], #32
; NONEON-NOSVE-NEXT:    fmax d0, d2, d0
; NONEON-NOSVE-NEXT:    fmax d1, d3, d1
; NONEON-NOSVE-NEXT:    fmax d0, d1, d0
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call double @llvm.vector.reduce.fmaximum.v4f64(<4 x double> %op)
  ret double %res
}

;
; FMINV
;

define half @fminimumv_v4f16(<4 x half> %a) {
; CHECK-LABEL: fminimumv_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fminv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v4f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fminimum.v4f16(<4 x half> %a)
  ret half %res
}

define half @fminimumv_v8f16(<8 x half> %a) {
; CHECK-LABEL: fminimumv_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fminv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v8f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldr h0, [sp]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call half @llvm.vector.reduce.fminimum.v8f16(<8 x half> %a)
  ret half %res
}

define half @fminimumv_v16f16(ptr %a) {
; CHECK-LABEL: fminimumv_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    fmin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    fminv h0, p0, z0.h
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v16f16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldr h0, [sp, #18]
; NONEON-NOSVE-NEXT:    ldr h1, [sp, #2]
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr h3, [sp]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmin s0, s1, s0
; NONEON-NOSVE-NEXT:    fmin s1, s3, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #20]
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #4]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fmin s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #6]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmin s0, s1, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #22]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmin s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #8]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #24]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmin s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #10]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #26]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmin s2, s3, s2
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #12]
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h1, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #28]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    fmin s1, s3, s2
; NONEON-NOSVE-NEXT:    ldr h2, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr h3, [sp, #14]
; NONEON-NOSVE-NEXT:    fcvt s2, h2
; NONEON-NOSVE-NEXT:    fcvt s3, h3
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    fmin s1, s3, s2
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    fcvt h1, s1
; NONEON-NOSVE-NEXT:    fcvt s0, h0
; NONEON-NOSVE-NEXT:    fcvt s1, h1
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    fcvt h0, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <16 x half>, ptr %a
  %res = call half @llvm.vector.reduce.fminimum.v16f16(<16 x half> %op)
  ret half %res
}

define float @fminimumv_v2f32(<2 x float> %a) {
; CHECK-LABEL: fminimumv_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fminv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v2f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    str d0, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #8]
; NONEON-NOSVE-NEXT:    fmin s0, s1, s0
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fminimum.v2f32(<2 x float> %a)
  ret float %res
}

define float @fminimumv_v4f32(<4 x float> %a) {
; CHECK-LABEL: fminimumv_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fminv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp]
; NONEON-NOSVE-NEXT:    fmin s0, s1, s0
; NONEON-NOSVE-NEXT:    ldp s2, s1, [sp, #8]
; NONEON-NOSVE-NEXT:    fmin s0, s0, s2
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call float @llvm.vector.reduce.fminimum.v4f32(<4 x float> %a)
  ret float %res
}

define float @fminimumv_v8f32(ptr %a) {
; CHECK-LABEL: fminimumv_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    fmin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    fminv s0, p0, z0.s
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp s3, s2, [sp]
; NONEON-NOSVE-NEXT:    fmin s0, s2, s0
; NONEON-NOSVE-NEXT:    fmin s1, s3, s1
; NONEON-NOSVE-NEXT:    ldp s2, s4, [sp, #8]
; NONEON-NOSVE-NEXT:    fmin s0, s1, s0
; NONEON-NOSVE-NEXT:    ldp s3, s1, [sp, #24]
; NONEON-NOSVE-NEXT:    fmin s2, s2, s3
; NONEON-NOSVE-NEXT:    fmin s1, s4, s1
; NONEON-NOSVE-NEXT:    fmin s0, s0, s2
; NONEON-NOSVE-NEXT:    fmin s0, s0, s1
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %op = load <8 x float>, ptr %a
  %res = call float @llvm.vector.reduce.fminimum.v8f32(<8 x float> %op)
  ret float %res
}

define double @fminimumv_v1f64(<1 x double> %a) {
; CHECK-LABEL: fminimumv_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v1f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fminimum.v1f64(<1 x double> %a)
  ret double %res
}

define double @fminimumv_v2f64(<2 x double> %a) {
; CHECK-LABEL: fminimumv_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    fminv d0, p0, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v2f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    str q0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp], #16
; NONEON-NOSVE-NEXT:    fmin d0, d1, d0
; NONEON-NOSVE-NEXT:    ret
  %res = call double @llvm.vector.reduce.fminimum.v2f64(<2 x double> %a)
  ret double %res
}

define double @fminimumv_v4f64(ptr %a) {
; CHECK-LABEL: fminimumv_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    fmin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    fminv d0, p0, z0.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: fminimumv_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp d3, d2, [sp], #32
; NONEON-NOSVE-NEXT:    fmin d0, d2, d0
; NONEON-NOSVE-NEXT:    fmin d1, d3, d1
; NONEON-NOSVE-NEXT:    fmin d0, d1, d0
; NONEON-NOSVE-NEXT:    ret
  %op = load <4 x double>, ptr %a
  %res = call double @llvm.vector.reduce.fminimum.v4f64(<4 x double> %op)
  ret double %res
}

declare half @llvm.vector.reduce.fadd.v4f16(half, <4 x half>)
declare half @llvm.vector.reduce.fadd.v8f16(half, <8 x half>)
declare half @llvm.vector.reduce.fadd.v16f16(half, <16 x half>)

declare float @llvm.vector.reduce.fadd.v2f32(float, <2 x float>)
declare float @llvm.vector.reduce.fadd.v4f32(float, <4 x float>)
declare float @llvm.vector.reduce.fadd.v8f32(float, <8 x float>)

declare double @llvm.vector.reduce.fadd.v1f64(double, <1 x double>)
declare double @llvm.vector.reduce.fadd.v2f64(double, <2 x double>)
declare double @llvm.vector.reduce.fadd.v4f64(double, <4 x double>)

declare half @llvm.vector.reduce.fmax.v4f16(<4 x half>)
declare half @llvm.vector.reduce.fmax.v8f16(<8 x half>)
declare half @llvm.vector.reduce.fmax.v16f16(<16 x half>)

declare float @llvm.vector.reduce.fmax.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fmax.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fmax.v8f32(<8 x float>)

declare double @llvm.vector.reduce.fmax.v1f64(<1 x double>)
declare double @llvm.vector.reduce.fmax.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fmax.v4f64(<4 x double>)

declare half @llvm.vector.reduce.fmin.v4f16(<4 x half>)
declare half @llvm.vector.reduce.fmin.v8f16(<8 x half>)
declare half @llvm.vector.reduce.fmin.v16f16(<16 x half>)

declare float @llvm.vector.reduce.fmin.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fmin.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fmin.v8f32(<8 x float>)

declare double @llvm.vector.reduce.fmin.v1f64(<1 x double>)
declare double @llvm.vector.reduce.fmin.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fmin.v4f64(<4 x double>)

declare half @llvm.vector.reduce.fmaximum.v4f16(<4 x half>)
declare half @llvm.vector.reduce.fmaximum.v8f16(<8 x half>)
declare half @llvm.vector.reduce.fmaximum.v16f16(<16 x half>)

declare float @llvm.vector.reduce.fmaximum.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fmaximum.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fmaximum.v8f32(<8 x float>)

declare double @llvm.vector.reduce.fmaximum.v1f64(<1 x double>)
declare double @llvm.vector.reduce.fmaximum.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fmaximum.v4f64(<4 x double>)

declare half @llvm.vector.reduce.fminimum.v4f16(<4 x half>)
declare half @llvm.vector.reduce.fminimum.v8f16(<8 x half>)
declare half @llvm.vector.reduce.fminimum.v16f16(<16 x half>)

declare float @llvm.vector.reduce.fminimum.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fminimum.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fminimum.v8f32(<8 x float>)

declare double @llvm.vector.reduce.fminimum.v1f64(<1 x double>)
declare double @llvm.vector.reduce.fminimum.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fminimum.v4f64(<4 x double>)
