; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i32_stride2_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride2_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride2_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX-NEXT:    vmovaps %xmm0, (%rdx)
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride2_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-NEXT:    vmovaps %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride2_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-FP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FP-NEXT:    vmovaps %xmm0, (%rdx)
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride2_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX2-FCP-NEXT:    vmovaps %xmm0, (%rdx)
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride2_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX512-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride2_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX512-FCP-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride2_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX512DQ-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride2_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX512DQ-FCP-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride2_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX512BW-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride2_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512BW-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX512BW-FCP-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride2_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX512DQ-BW-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride2_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512DQ-BW-FCP-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX512DQ-BW-FCP-NEXT:    vmovaps %xmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <2 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i32>, ptr %in.vecptr1, align 64
  %1 = shufflevector <2 x i32> %in.vec0, <2 x i32> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %interleaved.vec = shufflevector <4 x i32> %1, <4 x i32> poison, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  store <4 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride2_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride2_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3]
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps %xmm2, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride2_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[2,0,3,1,6,4,7,5]
; AVX-NEXT:    vshufps {{.*#+}} ymm1 = ymm2[0,2,1,3,4,6,5,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6],ymm1[7]
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride2_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vmovaps {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride2_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX2-FP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride2_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX2-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride2_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovaps (%rdi), %xmm0
; AVX512-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX512-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride2_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX512-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride2_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX512DQ-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride2_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX512DQ-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride2_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovaps (%rdi), %xmm0
; AVX512BW-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX512BW-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512BW-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride2_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX512BW-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512BW-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride2_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX512DQ-BW-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512DQ-BW-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride2_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} ymm1 = [0,4,1,5,2,6,3,7]
; AVX512DQ-BW-FCP-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <4 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i32>, ptr %in.vecptr1, align 64
  %1 = shufflevector <4 x i32> %in.vec0, <4 x i32> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %interleaved.vec = shufflevector <8 x i32> %1, <8 x i32> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  store <8 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride2_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride2_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    unpckhps {{.*#+}} xmm4 = xmm4[2],xmm2[2],xmm4[3],xmm2[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    unpckhps {{.*#+}} xmm2 = xmm2[2],xmm3[2],xmm2[3],xmm3[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm3[0],xmm1[1],xmm3[1]
; SSE-NEXT:    movaps %xmm1, 32(%rdx)
; SSE-NEXT:    movaps %xmm2, 48(%rdx)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps %xmm4, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride2_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rsi), %xmm0
; AVX-NEXT:    vmovaps 16(%rsi), %xmm1
; AVX-NEXT:    vmovaps (%rdi), %xmm2
; AVX-NEXT:    vmovaps 16(%rdi), %xmm3
; AVX-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm2[2],xmm0[2],xmm2[3],xmm0[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm2[0],xmm0[0],xmm2[1],xmm0[1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm3[2],xmm1[2],xmm3[3],xmm1[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride2_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[0,1],ymm2[0,1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride2_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[0,1],ymm2[0,1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride2_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm2 = ymm0[2],ymm1[2],ymm0[3],ymm1[3],ymm0[6],ymm1[6],ymm0[7],ymm1[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[1],ymm1[1],ymm0[4],ymm1[4],ymm0[5],ymm1[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[0,1],ymm2[0,1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm1, (%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride2_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovaps (%rdi), %ymm0
; AVX512-NEXT:    vinsertf64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15]
; AVX512-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride2_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX512-FCP-NEXT:    vinsertf64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15]
; AVX512-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride2_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-NEXT:    vinsertf64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15]
; AVX512DQ-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride2_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vinsertf64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15]
; AVX512DQ-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride2_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovaps (%rdi), %ymm0
; AVX512BW-NEXT:    vinsertf64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15]
; AVX512BW-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride2_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vinsertf64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15]
; AVX512BW-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride2_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vinsertf64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15]
; AVX512DQ-BW-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride2_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vinsertf64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm1 = [0,8,1,9,2,10,3,11,4,12,5,13,6,14,7,15]
; AVX512DQ-BW-FCP-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovaps %zmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <8 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i32>, ptr %in.vecptr1, align 64
  %1 = shufflevector <8 x i32> %in.vec0, <8 x i32> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %interleaved.vec = shufflevector <16 x i32> %1, <16 x i32> poison, <16 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11, i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  store <16 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride2_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride2_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rdi), %xmm3
; SSE-NEXT:    movaps (%rsi), %xmm4
; SSE-NEXT:    movaps 16(%rsi), %xmm5
; SSE-NEXT:    movaps 32(%rsi), %xmm6
; SSE-NEXT:    movaps 48(%rsi), %xmm7
; SSE-NEXT:    movaps %xmm0, %xmm8
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm4[2],xmm8[3],xmm4[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    unpckhps {{.*#+}} xmm4 = xmm4[2],xmm5[2],xmm4[3],xmm5[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm5[0],xmm1[1],xmm5[1]
; SSE-NEXT:    movaps %xmm2, %xmm5
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm6[2],xmm5[3],xmm6[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1]
; SSE-NEXT:    movaps %xmm3, %xmm6
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm7[2],xmm6[3],xmm7[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm7[0],xmm3[1],xmm7[1]
; SSE-NEXT:    movaps %xmm3, 96(%rdx)
; SSE-NEXT:    movaps %xmm6, 112(%rdx)
; SSE-NEXT:    movaps %xmm2, 64(%rdx)
; SSE-NEXT:    movaps %xmm5, 80(%rdx)
; SSE-NEXT:    movaps %xmm1, 32(%rdx)
; SSE-NEXT:    movaps %xmm4, 48(%rdx)
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    movaps %xmm8, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride2_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps (%rsi), %xmm0
; AVX-NEXT:    vmovaps 16(%rsi), %xmm1
; AVX-NEXT:    vmovaps 32(%rsi), %xmm2
; AVX-NEXT:    vmovaps 48(%rsi), %xmm3
; AVX-NEXT:    vmovaps (%rdi), %xmm4
; AVX-NEXT:    vmovaps 16(%rdi), %xmm5
; AVX-NEXT:    vmovaps 32(%rdi), %xmm6
; AVX-NEXT:    vmovaps 48(%rdi), %xmm7
; AVX-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm5[0],xmm1[0],xmm5[1],xmm1[1]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm1, %ymm1
; AVX-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm4[2],xmm0[2],xmm4[3],xmm0[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm4[0],xmm0[0],xmm4[1],xmm0[1]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm6[2],xmm2[2],xmm6[3],xmm2[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm6[0],xmm2[0],xmm6[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm7[2],xmm3[2],xmm7[3],xmm3[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm7[0],xmm3[0],xmm7[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX-NEXT:    vmovaps %ymm3, 96(%rdx)
; AVX-NEXT:    vmovaps %ymm2, 64(%rdx)
; AVX-NEXT:    vmovaps %ymm0, (%rdx)
; AVX-NEXT:    vmovaps %ymm1, 32(%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride2_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[6],ymm2[6],ymm0[7],ymm2[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[4],ymm2[4],ymm0[5],ymm2[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm4[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[0,1],ymm4[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm1[2],ymm3[2],ymm1[3],ymm3[3],ymm1[6],ymm3[6],ymm1[7],ymm3[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[1],ymm3[1],ymm1[4],ymm3[4],ymm1[5],ymm3[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm1[2,3],ymm4[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm4[0,1]
; AVX2-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-NEXT:    vmovaps %ymm3, 96(%rdx)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride2_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[6],ymm2[6],ymm0[7],ymm2[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[4],ymm2[4],ymm0[5],ymm2[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[0,1],ymm4[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm1[2],ymm3[2],ymm1[3],ymm3[3],ymm1[6],ymm3[6],ymm1[7],ymm3[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[1],ymm3[1],ymm1[4],ymm3[4],ymm1[5],ymm3[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm1[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm4[0,1]
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm3, 96(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride2_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm0[2],ymm2[2],ymm0[3],ymm2[3],ymm0[6],ymm2[6],ymm0[7],ymm2[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm2[0],ymm0[1],ymm2[1],ymm0[4],ymm2[4],ymm0[5],ymm2[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[0,1],ymm4[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm4 = ymm1[2],ymm3[2],ymm1[3],ymm3[3],ymm1[6],ymm3[6],ymm1[7],ymm3[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[1],ymm3[1],ymm1[4],ymm3[4],ymm1[5],ymm3[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm1[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm4[0,1]
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 96(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 32(%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride2_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, 64(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm2, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride2_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, 64(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, (%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride2_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, 64(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, (%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride2_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, (%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride2_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 64(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, (%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride2_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 64(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride2_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-BW-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, 64(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, (%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride2_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm2 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm3 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <16 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i32>, ptr %in.vecptr1, align 64
  %1 = shufflevector <16 x i32> %in.vec0, <16 x i32> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %interleaved.vec = shufflevector <32 x i32> %1, <32 x i32> poison, <32 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23, i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  store <32 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride2_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride2_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps 112(%rdi), %xmm0
; SSE-NEXT:    movaps 96(%rdi), %xmm6
; SSE-NEXT:    movaps 80(%rdi), %xmm4
; SSE-NEXT:    movaps 64(%rdi), %xmm3
; SSE-NEXT:    movaps (%rdi), %xmm8
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps 32(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rdi), %xmm5
; SSE-NEXT:    movaps 96(%rsi), %xmm11
; SSE-NEXT:    movaps 80(%rsi), %xmm12
; SSE-NEXT:    movaps 64(%rsi), %xmm13
; SSE-NEXT:    movaps (%rsi), %xmm9
; SSE-NEXT:    movaps 16(%rsi), %xmm10
; SSE-NEXT:    movaps 32(%rsi), %xmm14
; SSE-NEXT:    movaps 48(%rsi), %xmm15
; SSE-NEXT:    movaps %xmm8, %xmm7
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm9[2],xmm7[3],xmm9[3]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; SSE-NEXT:    movaps %xmm1, %xmm9
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm10[2],xmm9[3],xmm10[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm10[0],xmm1[1],xmm10[1]
; SSE-NEXT:    movaps %xmm2, %xmm10
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm14[2],xmm10[3],xmm14[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm14[0],xmm2[1],xmm14[1]
; SSE-NEXT:    movaps %xmm5, %xmm14
; SSE-NEXT:    unpckhps {{.*#+}} xmm14 = xmm14[2],xmm15[2],xmm14[3],xmm15[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm15[0],xmm5[1],xmm15[1]
; SSE-NEXT:    movaps %xmm3, %xmm15
; SSE-NEXT:    unpckhps {{.*#+}} xmm15 = xmm15[2],xmm13[2],xmm15[3],xmm13[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm13[0],xmm3[1],xmm13[1]
; SSE-NEXT:    movaps %xmm4, %xmm13
; SSE-NEXT:    unpckhps {{.*#+}} xmm13 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm12[0],xmm4[1],xmm12[1]
; SSE-NEXT:    movaps %xmm6, %xmm12
; SSE-NEXT:    unpckhps {{.*#+}} xmm12 = xmm12[2],xmm11[2],xmm12[3],xmm11[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm11[0],xmm6[1],xmm11[1]
; SSE-NEXT:    movaps 112(%rsi), %xmm11
; SSE-NEXT:    movaps %xmm0, %xmm7
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm11[2],xmm7[3],xmm11[3]
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm11[0],xmm0[1],xmm11[1]
; SSE-NEXT:    movaps %xmm0, 224(%rdx)
; SSE-NEXT:    movaps %xmm7, 240(%rdx)
; SSE-NEXT:    movaps %xmm6, 192(%rdx)
; SSE-NEXT:    movaps %xmm12, 208(%rdx)
; SSE-NEXT:    movaps %xmm4, 160(%rdx)
; SSE-NEXT:    movaps %xmm13, 176(%rdx)
; SSE-NEXT:    movaps %xmm3, 128(%rdx)
; SSE-NEXT:    movaps %xmm15, 144(%rdx)
; SSE-NEXT:    movaps %xmm5, 96(%rdx)
; SSE-NEXT:    movaps %xmm14, 112(%rdx)
; SSE-NEXT:    movaps %xmm2, 64(%rdx)
; SSE-NEXT:    movaps %xmm10, 80(%rdx)
; SSE-NEXT:    movaps %xmm1, 32(%rdx)
; SSE-NEXT:    movaps %xmm9, 48(%rdx)
; SSE-NEXT:    movaps %xmm8, (%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride2_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps 112(%rsi), %xmm0
; AVX-NEXT:    vmovaps 112(%rdi), %xmm1
; AVX-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovaps 96(%rsi), %xmm1
; AVX-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX-NEXT:    vmovaps 64(%rsi), %xmm2
; AVX-NEXT:    vmovaps 64(%rdi), %xmm3
; AVX-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX-NEXT:    vmovaps 80(%rsi), %xmm3
; AVX-NEXT:    vmovaps 80(%rdi), %xmm4
; AVX-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX-NEXT:    vmovaps (%rsi), %xmm4
; AVX-NEXT:    vmovaps 16(%rsi), %xmm5
; AVX-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX-NEXT:    vmovaps 48(%rsi), %xmm7
; AVX-NEXT:    vmovaps (%rdi), %xmm8
; AVX-NEXT:    vmovaps 16(%rdi), %xmm9
; AVX-NEXT:    vmovaps 32(%rdi), %xmm10
; AVX-NEXT:    vmovaps 48(%rdi), %xmm11
; AVX-NEXT:    vunpckhps {{.*#+}} xmm12 = xmm8[2],xmm4[2],xmm8[3],xmm4[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm8[0],xmm4[0],xmm8[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm4, %ymm4
; AVX-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm10[2],xmm6[2],xmm10[3],xmm6[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm10[0],xmm6[0],xmm10[1],xmm6[1]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm6, %ymm6
; AVX-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm11[2],xmm7[2],xmm11[3],xmm7[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm11[0],xmm7[0],xmm11[1],xmm7[1]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm7, %ymm7
; AVX-NEXT:    vunpckhps {{.*#+}} xmm8 = xmm9[2],xmm5[2],xmm9[3],xmm5[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm9[0],xmm5[0],xmm9[1],xmm5[1]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm5, %ymm5
; AVX-NEXT:    vmovaps %ymm5, 32(%rdx)
; AVX-NEXT:    vmovaps %ymm7, 96(%rdx)
; AVX-NEXT:    vmovaps %ymm6, 64(%rdx)
; AVX-NEXT:    vmovaps %ymm4, (%rdx)
; AVX-NEXT:    vmovaps %ymm3, 160(%rdx)
; AVX-NEXT:    vmovaps %ymm2, 128(%rdx)
; AVX-NEXT:    vmovaps %ymm1, 192(%rdx)
; AVX-NEXT:    vmovaps %ymm0, 224(%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride2_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-NEXT:    vmovaps (%rsi), %ymm4
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm6
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm7
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm0[2],ymm4[2],ymm0[3],ymm4[3],ymm0[6],ymm4[6],ymm0[7],ymm4[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[1],ymm4[1],ymm0[4],ymm4[4],ymm0[5],ymm4[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[2,3],ymm8[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[0,1],ymm8[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm1[2],ymm5[2],ymm1[3],ymm5[3],ymm1[6],ymm5[6],ymm1[7],ymm5[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[1],ymm5[1],ymm1[4],ymm5[4],ymm1[5],ymm5[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm8[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm8[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm2[2],ymm6[2],ymm2[3],ymm6[3],ymm2[6],ymm6[6],ymm2[7],ymm6[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm2 = ymm2[0],ymm6[0],ymm2[1],ymm6[1],ymm2[4],ymm6[4],ymm2[5],ymm6[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm2[2,3],ymm8[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[0,1],ymm8[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm3[2],ymm7[2],ymm3[3],ymm7[3],ymm3[6],ymm7[6],ymm3[7],ymm7[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm3[0],ymm7[0],ymm3[1],ymm7[1],ymm3[4],ymm7[4],ymm3[5],ymm7[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm3[2,3],ymm8[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[0,1],ymm8[0,1]
; AVX2-NEXT:    vmovaps %ymm3, 192(%rdx)
; AVX2-NEXT:    vmovaps %ymm7, 224(%rdx)
; AVX2-NEXT:    vmovaps %ymm2, 128(%rdx)
; AVX2-NEXT:    vmovaps %ymm6, 160(%rdx)
; AVX2-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-NEXT:    vmovaps %ymm5, 96(%rdx)
; AVX2-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-NEXT:    vmovaps %ymm4, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride2_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm4
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm6
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm7
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm0[2],ymm4[2],ymm0[3],ymm4[3],ymm0[6],ymm4[6],ymm0[7],ymm4[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[1],ymm4[1],ymm0[4],ymm4[4],ymm0[5],ymm4[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[2,3],ymm8[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[0,1],ymm8[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm1[2],ymm5[2],ymm1[3],ymm5[3],ymm1[6],ymm5[6],ymm1[7],ymm5[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[1],ymm5[1],ymm1[4],ymm5[4],ymm1[5],ymm5[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm8[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm8[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm2[2],ymm6[2],ymm2[3],ymm6[3],ymm2[6],ymm6[6],ymm2[7],ymm6[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm2 = ymm2[0],ymm6[0],ymm2[1],ymm6[1],ymm2[4],ymm6[4],ymm2[5],ymm6[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm2[2,3],ymm8[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[0,1],ymm8[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm3[2],ymm7[2],ymm3[3],ymm7[3],ymm3[6],ymm7[6],ymm3[7],ymm7[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm3[0],ymm7[0],ymm3[1],ymm7[1],ymm3[4],ymm7[4],ymm3[5],ymm7[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm3[2,3],ymm8[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[0,1],ymm8[0,1]
; AVX2-FP-NEXT:    vmovaps %ymm3, 192(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm7, 224(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm2, 128(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm6, 160(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm5, 96(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm4, 32(%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride2_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm4
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm6
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm7
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm0[2],ymm4[2],ymm0[3],ymm4[3],ymm0[6],ymm4[6],ymm0[7],ymm4[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm0 = ymm0[0],ymm4[0],ymm0[1],ymm4[1],ymm0[4],ymm4[4],ymm0[5],ymm4[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm0[2,3],ymm8[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[0,1],ymm8[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm1[2],ymm5[2],ymm1[3],ymm5[3],ymm1[6],ymm5[6],ymm1[7],ymm5[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm1 = ymm1[0],ymm5[0],ymm1[1],ymm5[1],ymm1[4],ymm5[4],ymm1[5],ymm5[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm8[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm8[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm2[2],ymm6[2],ymm2[3],ymm6[3],ymm2[6],ymm6[6],ymm2[7],ymm6[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm2 = ymm2[0],ymm6[0],ymm2[1],ymm6[1],ymm2[4],ymm6[4],ymm2[5],ymm6[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm2[2,3],ymm8[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[0,1],ymm8[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm8 = ymm3[2],ymm7[2],ymm3[3],ymm7[3],ymm3[6],ymm7[6],ymm3[7],ymm7[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm3[0],ymm7[0],ymm3[1],ymm7[1],ymm3[4],ymm7[4],ymm3[5],ymm7[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm3[2,3],ymm8[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[0,1],ymm8[0,1]
; AVX2-FCP-NEXT:    vmovaps %ymm3, 192(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 224(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 128(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 160(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 96(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 32(%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride2_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512-NEXT:    vpermt2d %zmm2, %zmm4, %zmm5
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512-NEXT:    vpermt2d %zmm2, %zmm6, %zmm0
; AVX512-NEXT:    vpermi2d %zmm3, %zmm1, %zmm4
; AVX512-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm5, 64(%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride2_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm4, %zmm5
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512-FCP-NEXT:    vpermt2d %zmm2, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vpermi2d %zmm3, %zmm1, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride2_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm4, %zmm5
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-NEXT:    vpermt2d %zmm2, %zmm6, %zmm0
; AVX512DQ-NEXT:    vpermi2d %zmm3, %zmm1, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 64(%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride2_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm4, %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm2, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm3, %zmm1, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride2_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm4, %zmm5
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512BW-NEXT:    vpermt2d %zmm2, %zmm6, %zmm0
; AVX512BW-NEXT:    vpermi2d %zmm3, %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 64(%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride2_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm4, %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm2, %zmm6, %zmm0
; AVX512BW-FCP-NEXT:    vpermi2d %zmm3, %zmm1, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride2_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm4, %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm2, %zmm6, %zmm0
; AVX512DQ-BW-NEXT:    vpermi2d %zmm3, %zmm1, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 64(%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride2_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm4 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm4, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm6 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm2, %zmm6, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm3, %zmm1, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <32 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i32>, ptr %in.vecptr1, align 64
  %1 = shufflevector <32 x i32> %in.vec0, <32 x i32> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %interleaved.vec = shufflevector <64 x i32> %1, <64 x i32> poison, <64 x i32> <i32 0, i32 32, i32 1, i32 33, i32 2, i32 34, i32 3, i32 35, i32 4, i32 36, i32 5, i32 37, i32 6, i32 38, i32 7, i32 39, i32 8, i32 40, i32 9, i32 41, i32 10, i32 42, i32 11, i32 43, i32 12, i32 44, i32 13, i32 45, i32 14, i32 46, i32 15, i32 47, i32 16, i32 48, i32 17, i32 49, i32 18, i32 50, i32 19, i32 51, i32 20, i32 52, i32 21, i32 53, i32 22, i32 54, i32 23, i32 55, i32 24, i32 56, i32 25, i32 57, i32 26, i32 58, i32 27, i32 59, i32 28, i32 60, i32 29, i32 61, i32 30, i32 62, i32 31, i32 63>
  store <64 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride2_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride2_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $152, %rsp
; SSE-NEXT:    movaps 112(%rdi), %xmm14
; SSE-NEXT:    movaps 96(%rdi), %xmm13
; SSE-NEXT:    movaps 80(%rdi), %xmm11
; SSE-NEXT:    movaps 64(%rdi), %xmm10
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rdi), %xmm9
; SSE-NEXT:    movaps 48(%rdi), %xmm12
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps 80(%rsi), %xmm1
; SSE-NEXT:    movaps 64(%rsi), %xmm2
; SSE-NEXT:    movaps (%rsi), %xmm3
; SSE-NEXT:    movaps 16(%rsi), %xmm4
; SSE-NEXT:    movaps 32(%rsi), %xmm5
; SSE-NEXT:    movaps 48(%rsi), %xmm6
; SSE-NEXT:    movaps %xmm7, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm3[0],xmm15[1],xmm3[1]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm7 = xmm7[2],xmm3[2],xmm7[3],xmm3[3]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm4[0],xmm7[1],xmm4[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm4[2],xmm8[3],xmm4[3]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm9 = xmm9[2],xmm5[2],xmm9[3],xmm5[3]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm12, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm12 = xmm12[2],xmm6[2],xmm12[3],xmm6[3]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; SSE-NEXT:    movaps %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm2[2],xmm10[3],xmm2[3]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm11 = xmm11[2],xmm1[2],xmm11[3],xmm1[3]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm13 = xmm13[2],xmm0[2],xmm13[3],xmm0[3]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm14 = xmm14[2],xmm0[2],xmm14[3],xmm0[3]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm15
; SSE-NEXT:    movaps 128(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhps {{.*#+}} xmm15 = xmm15[2],xmm0[2],xmm15[3],xmm0[3]
; SSE-NEXT:    movaps 144(%rdi), %xmm13
; SSE-NEXT:    movaps 144(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm13, %xmm14
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm0[0],xmm14[1],xmm0[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm13 = xmm13[2],xmm0[2],xmm13[3],xmm0[3]
; SSE-NEXT:    movaps 160(%rdi), %xmm10
; SSE-NEXT:    movaps 160(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm10, %xmm12
; SSE-NEXT:    unpcklps {{.*#+}} xmm12 = xmm12[0],xmm0[0],xmm12[1],xmm0[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm10 = xmm10[2],xmm0[2],xmm10[3],xmm0[3]
; SSE-NEXT:    movaps 176(%rdi), %xmm8
; SSE-NEXT:    movaps 176(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm8, %xmm11
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm0[0],xmm11[1],xmm0[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm8 = xmm8[2],xmm0[2],xmm8[3],xmm0[3]
; SSE-NEXT:    movaps 192(%rdi), %xmm6
; SSE-NEXT:    movaps 192(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm6, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm0[0],xmm9[1],xmm0[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm6 = xmm6[2],xmm0[2],xmm6[3],xmm0[3]
; SSE-NEXT:    movaps 208(%rdi), %xmm5
; SSE-NEXT:    movaps 208(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm5, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm1[0],xmm7[1],xmm1[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm5 = xmm5[2],xmm1[2],xmm5[3],xmm1[3]
; SSE-NEXT:    movaps 224(%rdi), %xmm1
; SSE-NEXT:    movaps 224(%rsi), %xmm3
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],xmm3[2],xmm1[3],xmm3[3]
; SSE-NEXT:    movaps 240(%rdi), %xmm3
; SSE-NEXT:    movaps 240(%rsi), %xmm4
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm4[0],xmm0[1],xmm4[1]
; SSE-NEXT:    unpckhps {{.*#+}} xmm3 = xmm3[2],xmm4[2],xmm3[3],xmm4[3]
; SSE-NEXT:    movaps %xmm3, 496(%rdx)
; SSE-NEXT:    movaps %xmm0, 480(%rdx)
; SSE-NEXT:    movaps %xmm1, 464(%rdx)
; SSE-NEXT:    movaps %xmm2, 448(%rdx)
; SSE-NEXT:    movaps %xmm5, 432(%rdx)
; SSE-NEXT:    movaps %xmm7, 416(%rdx)
; SSE-NEXT:    movaps %xmm6, 400(%rdx)
; SSE-NEXT:    movaps %xmm9, 384(%rdx)
; SSE-NEXT:    movaps %xmm8, 368(%rdx)
; SSE-NEXT:    movaps %xmm11, 352(%rdx)
; SSE-NEXT:    movaps %xmm10, 336(%rdx)
; SSE-NEXT:    movaps %xmm12, 320(%rdx)
; SSE-NEXT:    movaps %xmm13, 304(%rdx)
; SSE-NEXT:    movaps %xmm14, 288(%rdx)
; SSE-NEXT:    movaps %xmm15, 272(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rdx)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rdx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rdx)
; SSE-NEXT:    addq $152, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i32_stride2_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovaps 240(%rsi), %xmm0
; AVX-NEXT:    vmovaps 240(%rdi), %xmm1
; AVX-NEXT:    vunpckhps {{.*#+}} xmm2 = xmm1[2],xmm0[2],xmm1[3],xmm0[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm1[0],xmm0[0],xmm1[1],xmm0[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rsi), %xmm1
; AVX-NEXT:    vmovaps 224(%rdi), %xmm2
; AVX-NEXT:    vunpckhps {{.*#+}} xmm3 = xmm2[2],xmm1[2],xmm2[3],xmm1[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm0
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rsi), %xmm2
; AVX-NEXT:    vmovaps 128(%rdi), %xmm3
; AVX-NEXT:    vunpckhps {{.*#+}} xmm4 = xmm3[2],xmm2[2],xmm3[3],xmm2[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX-NEXT:    vmovaps 144(%rsi), %xmm3
; AVX-NEXT:    vmovaps 144(%rdi), %xmm4
; AVX-NEXT:    vunpckhps {{.*#+}} xmm5 = xmm4[2],xmm3[2],xmm4[3],xmm3[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX-NEXT:    vmovaps (%rsi), %xmm4
; AVX-NEXT:    vmovaps 16(%rsi), %xmm8
; AVX-NEXT:    vmovaps 32(%rsi), %xmm5
; AVX-NEXT:    vmovaps 48(%rsi), %xmm11
; AVX-NEXT:    vmovaps (%rdi), %xmm6
; AVX-NEXT:    vmovaps 16(%rdi), %xmm9
; AVX-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX-NEXT:    vunpckhps {{.*#+}} xmm10 = xmm6[2],xmm4[2],xmm6[3],xmm4[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm4 = xmm6[0],xmm4[0],xmm6[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm4, %ymm4
; AVX-NEXT:    vunpckhps {{.*#+}} xmm6 = xmm7[2],xmm5[2],xmm7[3],xmm5[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm5 = xmm7[0],xmm5[0],xmm7[1],xmm5[1]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm5, %ymm5
; AVX-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX-NEXT:    vmovaps 64(%rdi), %xmm7
; AVX-NEXT:    vunpckhps {{.*#+}} xmm10 = xmm7[2],xmm6[2],xmm7[3],xmm6[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm6 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; AVX-NEXT:    vinsertf128 $1, %xmm10, %ymm6, %ymm6
; AVX-NEXT:    vmovaps 96(%rsi), %xmm7
; AVX-NEXT:    vmovaps 96(%rdi), %xmm10
; AVX-NEXT:    vunpckhps {{.*#+}} xmm12 = xmm10[2],xmm7[2],xmm10[3],xmm7[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm7 = xmm10[0],xmm7[0],xmm10[1],xmm7[1]
; AVX-NEXT:    vinsertf128 $1, %xmm12, %ymm7, %ymm7
; AVX-NEXT:    vmovaps 160(%rsi), %xmm10
; AVX-NEXT:    vmovaps 160(%rdi), %xmm12
; AVX-NEXT:    vunpckhps {{.*#+}} xmm13 = xmm12[2],xmm10[2],xmm12[3],xmm10[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm10 = xmm12[0],xmm10[0],xmm12[1],xmm10[1]
; AVX-NEXT:    vinsertf128 $1, %xmm13, %ymm10, %ymm10
; AVX-NEXT:    vmovaps 192(%rsi), %xmm12
; AVX-NEXT:    vmovaps 192(%rdi), %xmm13
; AVX-NEXT:    vunpckhps {{.*#+}} xmm14 = xmm13[2],xmm12[2],xmm13[3],xmm12[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm12 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm12, %ymm12
; AVX-NEXT:    vmovaps 80(%rsi), %xmm13
; AVX-NEXT:    vmovaps 80(%rdi), %xmm14
; AVX-NEXT:    vunpckhps {{.*#+}} xmm15 = xmm14[2],xmm13[2],xmm14[3],xmm13[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm13 = xmm14[0],xmm13[0],xmm14[1],xmm13[1]
; AVX-NEXT:    vmovaps 48(%rdi), %xmm14
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm13, %ymm13
; AVX-NEXT:    vunpckhps {{.*#+}} xmm15 = xmm14[2],xmm11[2],xmm14[3],xmm11[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm11 = xmm14[0],xmm11[0],xmm14[1],xmm11[1]
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm11, %ymm11
; AVX-NEXT:    vunpckhps {{.*#+}} xmm14 = xmm9[2],xmm8[2],xmm9[3],xmm8[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm8 = xmm9[0],xmm8[0],xmm9[1],xmm8[1]
; AVX-NEXT:    vinsertf128 $1, %xmm14, %ymm8, %ymm8
; AVX-NEXT:    vmovaps 112(%rsi), %xmm9
; AVX-NEXT:    vmovaps 112(%rdi), %xmm14
; AVX-NEXT:    vunpckhps {{.*#+}} xmm15 = xmm14[2],xmm9[2],xmm14[3],xmm9[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm9 = xmm14[0],xmm9[0],xmm14[1],xmm9[1]
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm9, %ymm9
; AVX-NEXT:    vmovaps 176(%rsi), %xmm14
; AVX-NEXT:    vmovaps 176(%rdi), %xmm15
; AVX-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm14, %ymm1
; AVX-NEXT:    vmovaps 208(%rsi), %xmm14
; AVX-NEXT:    vmovaps 208(%rdi), %xmm15
; AVX-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm15[2],xmm14[2],xmm15[3],xmm14[3]
; AVX-NEXT:    vunpcklps {{.*#+}} xmm14 = xmm15[0],xmm14[0],xmm15[1],xmm14[1]
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm14, %ymm0
; AVX-NEXT:    vmovaps %ymm0, 416(%rdx)
; AVX-NEXT:    vmovaps %ymm1, 352(%rdx)
; AVX-NEXT:    vmovaps %ymm9, 224(%rdx)
; AVX-NEXT:    vmovaps %ymm8, 32(%rdx)
; AVX-NEXT:    vmovaps %ymm11, 96(%rdx)
; AVX-NEXT:    vmovaps %ymm13, 160(%rdx)
; AVX-NEXT:    vmovaps %ymm12, 384(%rdx)
; AVX-NEXT:    vmovaps %ymm10, 320(%rdx)
; AVX-NEXT:    vmovaps %ymm7, 192(%rdx)
; AVX-NEXT:    vmovaps %ymm6, 128(%rdx)
; AVX-NEXT:    vmovaps %ymm5, 64(%rdx)
; AVX-NEXT:    vmovaps %ymm4, (%rdx)
; AVX-NEXT:    vmovaps %ymm3, 288(%rdx)
; AVX-NEXT:    vmovaps %ymm2, 256(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%rdx)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%rdx)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride2_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm6
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm8
; AVX2-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm7
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm9
; AVX2-NEXT:    vmovaps 192(%rsi), %ymm10
; AVX2-NEXT:    vmovaps 160(%rsi), %ymm11
; AVX2-NEXT:    vmovaps 128(%rsi), %ymm12
; AVX2-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm13
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm2 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm15[2,3]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[0,1],ymm15[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm5 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm15[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[0,1],ymm15[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm7[2],ymm13[2],ymm7[3],ymm13[3],ymm7[6],ymm13[6],ymm7[7],ymm13[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm13 = ymm7[0],ymm13[0],ymm7[1],ymm13[1],ymm7[4],ymm13[4],ymm7[5],ymm13[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm13[2,3],ymm15[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm13[0,1],ymm15[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm9[2],ymm14[2],ymm9[3],ymm14[3],ymm9[6],ymm14[6],ymm9[7],ymm14[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm9[0],ymm14[0],ymm9[1],ymm14[1],ymm9[4],ymm14[4],ymm9[5],ymm14[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm9[2,3],ymm15[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[0,1],ymm15[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm8[2],ymm12[2],ymm8[3],ymm12[3],ymm8[6],ymm12[6],ymm8[7],ymm12[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm8 = ymm8[0],ymm12[0],ymm8[1],ymm12[1],ymm8[4],ymm12[4],ymm8[5],ymm12[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm8[2,3],ymm15[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[0,1],ymm15[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm6[2],ymm11[2],ymm6[3],ymm11[3],ymm6[6],ymm11[6],ymm6[7],ymm11[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm6[0],ymm11[0],ymm6[1],ymm11[1],ymm6[4],ymm11[4],ymm6[5],ymm11[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm6[2,3],ymm15[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm6[0,1],ymm15[0,1]
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm3[2],ymm10[2],ymm3[3],ymm10[3],ymm3[6],ymm10[6],ymm3[7],ymm10[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm3[0],ymm10[0],ymm3[1],ymm10[1],ymm3[4],ymm10[4],ymm3[5],ymm10[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm3[2,3],ymm15[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[0,1],ymm15[0,1]
; AVX2-NEXT:    vmovaps 224(%rsi), %ymm15
; AVX2-NEXT:    vmovaps %ymm0, %ymm1
; AVX2-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm15[2],ymm0[3],ymm15[3],ymm0[6],ymm15[6],ymm0[7],ymm15[7]
; AVX2-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm1[0],ymm15[0],ymm1[1],ymm15[1],ymm1[4],ymm15[4],ymm1[5],ymm15[5]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm15[2,3],ymm0[2,3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm15[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps %ymm0, 448(%rdx)
; AVX2-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX2-NEXT:    vmovaps %ymm3, 384(%rdx)
; AVX2-NEXT:    vmovaps %ymm10, 416(%rdx)
; AVX2-NEXT:    vmovaps %ymm6, 320(%rdx)
; AVX2-NEXT:    vmovaps %ymm11, 352(%rdx)
; AVX2-NEXT:    vmovaps %ymm8, 256(%rdx)
; AVX2-NEXT:    vmovaps %ymm12, 288(%rdx)
; AVX2-NEXT:    vmovaps %ymm9, 192(%rdx)
; AVX2-NEXT:    vmovaps %ymm14, 224(%rdx)
; AVX2-NEXT:    vmovaps %ymm13, 128(%rdx)
; AVX2-NEXT:    vmovaps %ymm7, 160(%rdx)
; AVX2-NEXT:    vmovaps %ymm5, 64(%rdx)
; AVX2-NEXT:    vmovaps %ymm4, 96(%rdx)
; AVX2-NEXT:    vmovaps %ymm2, (%rdx)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i32_stride2_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm6
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm8
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm7
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm9
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %ymm10
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %ymm11
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %ymm12
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm13
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm2 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm15[2,3]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[0,1],ymm15[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm5 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm15[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[0,1],ymm15[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm7[2],ymm13[2],ymm7[3],ymm13[3],ymm7[6],ymm13[6],ymm7[7],ymm13[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm13 = ymm7[0],ymm13[0],ymm7[1],ymm13[1],ymm7[4],ymm13[4],ymm7[5],ymm13[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm13[2,3],ymm15[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm13[0,1],ymm15[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm9[2],ymm14[2],ymm9[3],ymm14[3],ymm9[6],ymm14[6],ymm9[7],ymm14[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm9[0],ymm14[0],ymm9[1],ymm14[1],ymm9[4],ymm14[4],ymm9[5],ymm14[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm9[2,3],ymm15[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[0,1],ymm15[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm8[2],ymm12[2],ymm8[3],ymm12[3],ymm8[6],ymm12[6],ymm8[7],ymm12[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm8 = ymm8[0],ymm12[0],ymm8[1],ymm12[1],ymm8[4],ymm12[4],ymm8[5],ymm12[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm8[2,3],ymm15[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[0,1],ymm15[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm6[2],ymm11[2],ymm6[3],ymm11[3],ymm6[6],ymm11[6],ymm6[7],ymm11[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm6[0],ymm11[0],ymm6[1],ymm11[1],ymm6[4],ymm11[4],ymm6[5],ymm11[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm6[2,3],ymm15[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm6[0,1],ymm15[0,1]
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm3[2],ymm10[2],ymm3[3],ymm10[3],ymm3[6],ymm10[6],ymm3[7],ymm10[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm3[0],ymm10[0],ymm3[1],ymm10[1],ymm3[4],ymm10[4],ymm3[5],ymm10[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm3[2,3],ymm15[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[0,1],ymm15[0,1]
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %ymm15
; AVX2-FP-NEXT:    vmovaps %ymm0, %ymm1
; AVX2-FP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm15[2],ymm0[3],ymm15[3],ymm0[6],ymm15[6],ymm0[7],ymm15[7]
; AVX2-FP-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm1[0],ymm15[0],ymm1[1],ymm15[1],ymm1[4],ymm15[4],ymm1[5],ymm15[5]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm15[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm15[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm3, 384(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm10, 416(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm6, 320(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm11, 352(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm8, 256(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm12, 288(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm9, 192(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm14, 224(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm13, 128(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm7, 160(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm5, 64(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm4, 96(%rdx)
; AVX2-FP-NEXT:    vmovaps %ymm2, (%rdx)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i32_stride2_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm6
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm8
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm4
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm7
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm9
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %ymm10
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %ymm11
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %ymm12
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm13
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm14
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm1[2],ymm2[2],ymm1[3],ymm2[3],ymm1[6],ymm2[6],ymm1[7],ymm2[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm2 = ymm1[0],ymm2[0],ymm1[1],ymm2[1],ymm1[4],ymm2[4],ymm1[5],ymm2[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm15[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[0,1],ymm15[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm4[2],ymm5[2],ymm4[3],ymm5[3],ymm4[6],ymm5[6],ymm4[7],ymm5[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm5 = ymm4[0],ymm5[0],ymm4[1],ymm5[1],ymm4[4],ymm5[4],ymm4[5],ymm5[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm5[2,3],ymm15[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[0,1],ymm15[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm7[2],ymm13[2],ymm7[3],ymm13[3],ymm7[6],ymm13[6],ymm7[7],ymm13[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm13 = ymm7[0],ymm13[0],ymm7[1],ymm13[1],ymm7[4],ymm13[4],ymm7[5],ymm13[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm13[2,3],ymm15[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm13[0,1],ymm15[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm9[2],ymm14[2],ymm9[3],ymm14[3],ymm9[6],ymm14[6],ymm9[7],ymm14[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm9 = ymm9[0],ymm14[0],ymm9[1],ymm14[1],ymm9[4],ymm14[4],ymm9[5],ymm14[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm9[2,3],ymm15[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[0,1],ymm15[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm8[2],ymm12[2],ymm8[3],ymm12[3],ymm8[6],ymm12[6],ymm8[7],ymm12[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm8 = ymm8[0],ymm12[0],ymm8[1],ymm12[1],ymm8[4],ymm12[4],ymm8[5],ymm12[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm8[2,3],ymm15[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[0,1],ymm15[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm6[2],ymm11[2],ymm6[3],ymm11[3],ymm6[6],ymm11[6],ymm6[7],ymm11[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm6 = ymm6[0],ymm11[0],ymm6[1],ymm11[1],ymm6[4],ymm11[4],ymm6[5],ymm11[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm6[2,3],ymm15[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm6[0,1],ymm15[0,1]
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm15 = ymm3[2],ymm10[2],ymm3[3],ymm10[3],ymm3[6],ymm10[6],ymm3[7],ymm10[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm3 = ymm3[0],ymm10[0],ymm3[1],ymm10[1],ymm3[4],ymm10[4],ymm3[5],ymm10[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm3[2,3],ymm15[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[0,1],ymm15[0,1]
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %ymm15
; AVX2-FCP-NEXT:    vmovaps %ymm0, %ymm1
; AVX2-FCP-NEXT:    vunpckhps {{.*#+}} ymm0 = ymm0[2],ymm15[2],ymm0[3],ymm15[3],ymm0[6],ymm15[6],ymm0[7],ymm15[7]
; AVX2-FCP-NEXT:    vunpcklps {{.*#+}} ymm15 = ymm1[0],ymm15[0],ymm1[1],ymm15[1],ymm1[4],ymm15[4],ymm1[5],ymm15[5]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm15[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm15[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 480(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 384(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 416(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 320(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm11, 352(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 256(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm12, 288(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 192(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm14, 224(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm13, 128(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 160(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 64(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 96(%rdx)
; AVX2-FCP-NEXT:    vmovaps %ymm2, (%rdx)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rdx)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride2_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512-NEXT:    vpermt2d %zmm4, %zmm8, %zmm9
; AVX512-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512-NEXT:    vpermt2d %zmm5, %zmm8, %zmm4
; AVX512-NEXT:    vpermt2d %zmm5, %zmm10, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512-NEXT:    vpermt2d %zmm6, %zmm8, %zmm5
; AVX512-NEXT:    vpermt2d %zmm6, %zmm10, %zmm2
; AVX512-NEXT:    vpermi2d %zmm7, %zmm3, %zmm8
; AVX512-NEXT:    vpermt2d %zmm7, %zmm10, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, 384(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm8, 448(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm2, 256(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512-NEXT:    vmovdqa64 %zmm9, 64(%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i32_stride2_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm9
; AVX512-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512-FCP-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm8, %zmm4
; AVX512-FCP-NEXT:    vpermt2d %zmm5, %zmm10, %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm8, %zmm5
; AVX512-FCP-NEXT:    vpermt2d %zmm6, %zmm10, %zmm2
; AVX512-FCP-NEXT:    vpermi2d %zmm7, %zmm3, %zmm8
; AVX512-FCP-NEXT:    vpermt2d %zmm7, %zmm10, %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, 384(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 448(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 256(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 64(%rdx)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i32_stride2_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm8, %zmm9
; AVX512DQ-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm8, %zmm4
; AVX512DQ-NEXT:    vpermt2d %zmm5, %zmm10, %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm8, %zmm5
; AVX512DQ-NEXT:    vpermt2d %zmm6, %zmm10, %zmm2
; AVX512DQ-NEXT:    vpermi2d %zmm7, %zmm3, %zmm8
; AVX512DQ-NEXT:    vpermt2d %zmm7, %zmm10, %zmm3
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, 384(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 448(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 256(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 64(%rdx)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i32_stride2_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm8, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm5, %zmm10, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm8, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm6, %zmm10, %zmm2
; AVX512DQ-FCP-NEXT:    vpermi2d %zmm7, %zmm3, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2d %zmm7, %zmm10, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, 384(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 448(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 256(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 64(%rdx)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i32_stride2_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm8, %zmm9
; AVX512BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512BW-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm8, %zmm4
; AVX512BW-NEXT:    vpermt2d %zmm5, %zmm10, %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm8, %zmm5
; AVX512BW-NEXT:    vpermt2d %zmm6, %zmm10, %zmm2
; AVX512BW-NEXT:    vpermi2d %zmm7, %zmm3, %zmm8
; AVX512BW-NEXT:    vpermt2d %zmm7, %zmm10, %zmm3
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 384(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 448(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 256(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 64(%rdx)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i32_stride2_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512BW-FCP-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm8, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2d %zmm5, %zmm10, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2d %zmm6, %zmm8, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2d %zmm6, %zmm10, %zmm2
; AVX512BW-FCP-NEXT:    vpermi2d %zmm7, %zmm3, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2d %zmm7, %zmm10, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 384(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, 448(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 256(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 64(%rdx)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i32_stride2_vf64:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2d %zmm4, %zmm8, %zmm9
; AVX512DQ-BW-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-BW-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm8, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2d %zmm5, %zmm10, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2d %zmm6, %zmm8, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2d %zmm6, %zmm10, %zmm2
; AVX512DQ-BW-NEXT:    vpermi2d %zmm7, %zmm3, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2d %zmm7, %zmm10, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, 384(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, 448(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 256(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 64(%rdx)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i32_stride2_vf64:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm8 = [8,24,9,25,10,26,11,27,12,28,13,29,14,30,15,31]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm4, %zmm8, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbd {{.*#+}} zmm10 = [0,16,1,17,2,18,3,19,4,20,5,21,6,22,7,23]
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm4, %zmm10, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm8, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm5, %zmm10, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm6, %zmm8, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm6, %zmm10, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermi2d %zmm7, %zmm3, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2d %zmm7, %zmm10, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 384(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, 448(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 256(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 320(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 192(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, (%rdx)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 64(%rdx)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <64 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i32>, ptr %in.vecptr1, align 64
  %1 = shufflevector <64 x i32> %in.vec0, <64 x i32> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %interleaved.vec = shufflevector <128 x i32> %1, <128 x i32> poison, <128 x i32> <i32 0, i32 64, i32 1, i32 65, i32 2, i32 66, i32 3, i32 67, i32 4, i32 68, i32 5, i32 69, i32 6, i32 70, i32 7, i32 71, i32 8, i32 72, i32 9, i32 73, i32 10, i32 74, i32 11, i32 75, i32 12, i32 76, i32 13, i32 77, i32 14, i32 78, i32 15, i32 79, i32 16, i32 80, i32 17, i32 81, i32 18, i32 82, i32 19, i32 83, i32 20, i32 84, i32 21, i32 85, i32 22, i32 86, i32 23, i32 87, i32 24, i32 88, i32 25, i32 89, i32 26, i32 90, i32 27, i32 91, i32 28, i32 92, i32 29, i32 93, i32 30, i32 94, i32 31, i32 95, i32 32, i32 96, i32 33, i32 97, i32 34, i32 98, i32 35, i32 99, i32 36, i32 100, i32 37, i32 101, i32 38, i32 102, i32 39, i32 103, i32 40, i32 104, i32 41, i32 105, i32 42, i32 106, i32 43, i32 107, i32 44, i32 108, i32 45, i32 109, i32 46, i32 110, i32 47, i32 111, i32 48, i32 112, i32 49, i32 113, i32 50, i32 114, i32 51, i32 115, i32 52, i32 116, i32 53, i32 117, i32 54, i32 118, i32 55, i32 119, i32 56, i32 120, i32 57, i32 121, i32 58, i32 122, i32 59, i32 123, i32 60, i32 124, i32 61, i32 125, i32 62, i32 126, i32 63, i32 127>
  store <128 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
