; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test incoming i128 arguments.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z17 | FileCheck %s

; Do some arithmetic so that we can see the register being used.
define void @f1(ptr %r2, i16 %r3, i32 %r4, i64 %r5, i128 %r6) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r6), 3
; CHECK-NEXT:    vaq %v0, %v0, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %y = add i128 %r6, %r6
  store i128 %y, ptr %r2
  ret void
}

; Test a case where the i128 address is passed on the stack.
define void @f2(ptr %r2, i16 %r3, i32 %r4, i64 %r5, i128 %r6, i64 %s1, i64 %s2, i128 %s4) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lg %r1, 176(%r15)
; CHECK-NEXT:    vl %v0, 0(%r1), 3
; CHECK-NEXT:    vaq %v0, %v0, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %y = add i128 %s4, %s4
  store i128 %y, ptr %r2
  ret void
}

; Explicit i128 return values are likewise passed indirectly.
define i128 @f14(i128 %r3) {
; CHECK-LABEL: f14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vaq %v0, %v0, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %y = add i128 %r3, %r3
  ret i128 %y
}

