; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

;; Testing that x18 is backed up and restored, and that x29 (if used) still
;; points to the x29,x30 pair on the stack.

; RUN: llc < %s -mtriple=arm64-apple-darwin | FileCheck %s
; RUN: llc < %s -mtriple=arm64-apple-darwin -mattr=+reserve-x18 | FileCheck %s

declare dso_local void @other()

define win64cc void @func(i32 noundef %0) #0 {
; CHECK-LABEL: func:
; CHECK:         ; %bb.0: ; %entry
; CHECK-NEXT:    str x18, [sp, #-32]! ; 8-byte Folded Spill
; CHECK-NEXT:    stp x29, x30, [sp, #16] ; 16-byte Folded Spill
; CHECK:         ldp x29, x30, [sp, #16] ; 16-byte Folded Reload
; CHECK-NEXT:    ldr x18, [sp], #32 ; 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %al = alloca i32, align 4
  store i32 %0, ptr %al, align 4
  tail call void @other()
  ret void
}

define i32 @main() {
  call win64cc void @func(i32 noundef 17)
  ret i32 0
}

attributes #0 = { nounwind }
