; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32f -disable-strictnode-mutation < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi lp64f -disable-strictnode-mutation < %s | FileCheck %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinx -verify-machineinstrs \
; RUN:   -target-abi ilp32 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefix=CHECKIZHINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinx -verify-machineinstrs \
; RUN:   -target-abi lp64 -disable-strictnode-mutation < %s  \
; RUN:   | FileCheck -check-prefix=CHECKIZHINX %s
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32f -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefix=CHECKIZFHMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi lp64f -disable-strictnode-mutation < %s  \
; RUN:   | FileCheck -check-prefix=CHECKIZFHMIN %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinxmin -verify-machineinstrs \
; RUN:   -target-abi ilp32 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefix=CHECKIZHINXMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinxmin -verify-machineinstrs \
; RUN:   -target-abi lp64 -disable-strictnode-mutation < %s  \
; RUN:   | FileCheck -check-prefix=CHECKIZHINXMIN %s

define i32 @fcmp_oeq(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.h a0, fa0, fa1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_oeq:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    feq.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_oeq:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    feq.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_oeq:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}
declare i1 @llvm.experimental.constrained.fcmp.f16(half, half, metadata, metadata)

define i32 @fcmp_ogt(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ogt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a1
; CHECK-NEXT:    flt.h a0, fa1, fa0
; CHECK-NEXT:    fsflags a1
; CHECK-NEXT:    feq.h zero, fa1, fa0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_ogt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a3
; CHECKIZHINX-NEXT:    flt.h a2, a1, a0
; CHECKIZHINX-NEXT:    fsflags a3
; CHECKIZHINX-NEXT:    feq.h zero, a1, a0
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ogt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a1
; CHECKIZFHMIN-NEXT:    flt.h a0, fa1, fa0
; CHECKIZFHMIN-NEXT:    fsflags a1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa1, fa0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_ogt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    frflags a3
; CHECKIZHINXMIN-NEXT:    flt.s a0, a1, a2
; CHECKIZHINXMIN-NEXT:    fsflags a3
; CHECKIZHINXMIN-NEXT:    feq.s zero, a1, a2
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_oge(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_oge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a1
; CHECK-NEXT:    fle.h a0, fa1, fa0
; CHECK-NEXT:    fsflags a1
; CHECK-NEXT:    feq.h zero, fa1, fa0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_oge:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a3
; CHECKIZHINX-NEXT:    fle.h a2, a1, a0
; CHECKIZHINX-NEXT:    fsflags a3
; CHECKIZHINX-NEXT:    feq.h zero, a1, a0
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_oge:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a1
; CHECKIZFHMIN-NEXT:    fle.h a0, fa1, fa0
; CHECKIZFHMIN-NEXT:    fsflags a1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa1, fa0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_oge:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    frflags a3
; CHECKIZHINXMIN-NEXT:    fle.s a0, a1, a2
; CHECKIZHINXMIN-NEXT:    fsflags a3
; CHECKIZHINXMIN-NEXT:    feq.s zero, a1, a2
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"oge", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_olt(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_olt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a1
; CHECK-NEXT:    flt.h a0, fa0, fa1
; CHECK-NEXT:    fsflags a1
; CHECK-NEXT:    feq.h zero, fa0, fa1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_olt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a3
; CHECKIZHINX-NEXT:    flt.h a2, a0, a1
; CHECKIZHINX-NEXT:    fsflags a3
; CHECKIZHINX-NEXT:    feq.h zero, a0, a1
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_olt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a1
; CHECKIZFHMIN-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    fsflags a1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa0, fa1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_olt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    frflags a3
; CHECKIZHINXMIN-NEXT:    flt.s a0, a2, a1
; CHECKIZHINXMIN-NEXT:    fsflags a3
; CHECKIZHINXMIN-NEXT:    feq.s zero, a2, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"olt", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ole(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ole:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a1
; CHECK-NEXT:    fle.h a0, fa0, fa1
; CHECK-NEXT:    fsflags a1
; CHECK-NEXT:    feq.h zero, fa0, fa1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_ole:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a3
; CHECKIZHINX-NEXT:    fle.h a2, a0, a1
; CHECKIZHINX-NEXT:    fsflags a3
; CHECKIZHINX-NEXT:    feq.h zero, a0, a1
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ole:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a1
; CHECKIZFHMIN-NEXT:    fle.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    fsflags a1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa0, fa1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_ole:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    frflags a3
; CHECKIZHINXMIN-NEXT:    fle.s a0, a2, a1
; CHECKIZHINXMIN-NEXT:    fsflags a3
; CHECKIZHINXMIN-NEXT:    feq.s zero, a2, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ole", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

; FIXME: We only need one frflags before the two flts and one fsflags after the
; two flts.
define i32 @fcmp_one(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    flt.h a1, fa0, fa1
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    feq.h zero, fa0, fa1
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    flt.h a2, fa1, fa0
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    or a0, a2, a1
; CHECK-NEXT:    feq.h zero, fa1, fa0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_one:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a2
; CHECKIZHINX-NEXT:    flt.h a3, a0, a1
; CHECKIZHINX-NEXT:    fsflags a2
; CHECKIZHINX-NEXT:    feq.h zero, a0, a1
; CHECKIZHINX-NEXT:    frflags a2
; CHECKIZHINX-NEXT:    flt.h a4, a1, a0
; CHECKIZHINX-NEXT:    fsflags a2
; CHECKIZHINX-NEXT:    or a2, a4, a3
; CHECKIZHINX-NEXT:    feq.h zero, a1, a0
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_one:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a0
; CHECKIZFHMIN-NEXT:    flt.h a1, fa0, fa1
; CHECKIZFHMIN-NEXT:    fsflags a0
; CHECKIZFHMIN-NEXT:    feq.h zero, fa0, fa1
; CHECKIZFHMIN-NEXT:    frflags a0
; CHECKIZFHMIN-NEXT:    flt.h a2, fa1, fa0
; CHECKIZFHMIN-NEXT:    fsflags a0
; CHECKIZFHMIN-NEXT:    or a0, a2, a1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa1, fa0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_one:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    frflags a0
; CHECKIZHINXMIN-NEXT:    flt.s a3, a2, a1
; CHECKIZHINXMIN-NEXT:    fsflags a0
; CHECKIZHINXMIN-NEXT:    feq.s zero, a2, a1
; CHECKIZHINXMIN-NEXT:    frflags a0
; CHECKIZHINXMIN-NEXT:    flt.s a4, a1, a2
; CHECKIZHINXMIN-NEXT:    fsflags a0
; CHECKIZHINXMIN-NEXT:    or a0, a4, a3
; CHECKIZHINXMIN-NEXT:    feq.s zero, a1, a2
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"one", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ord(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ord:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.h a0, fa1, fa1
; CHECK-NEXT:    feq.h a1, fa0, fa0
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_ord:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    feq.h a1, a1, a1
; CHECKIZHINX-NEXT:    feq.h a0, a0, a0
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ord:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    feq.h a0, fa1, fa1
; CHECKIZFHMIN-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_ord:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    feq.s a1, a1, a1
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ord", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

; FIXME: We only need one frflags before the two flts and one fsflags after the
; two flts.
define i32 @fcmp_ueq(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ueq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    flt.h a1, fa0, fa1
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    feq.h zero, fa0, fa1
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    flt.h a2, fa1, fa0
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    or a1, a2, a1
; CHECK-NEXT:    xori a0, a1, 1
; CHECK-NEXT:    feq.h zero, fa1, fa0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_ueq:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a2
; CHECKIZHINX-NEXT:    flt.h a3, a0, a1
; CHECKIZHINX-NEXT:    fsflags a2
; CHECKIZHINX-NEXT:    feq.h zero, a0, a1
; CHECKIZHINX-NEXT:    frflags a2
; CHECKIZHINX-NEXT:    flt.h a4, a1, a0
; CHECKIZHINX-NEXT:    fsflags a2
; CHECKIZHINX-NEXT:    or a3, a4, a3
; CHECKIZHINX-NEXT:    xori a2, a3, 1
; CHECKIZHINX-NEXT:    feq.h zero, a1, a0
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ueq:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a0
; CHECKIZFHMIN-NEXT:    flt.h a1, fa0, fa1
; CHECKIZFHMIN-NEXT:    fsflags a0
; CHECKIZFHMIN-NEXT:    feq.h zero, fa0, fa1
; CHECKIZFHMIN-NEXT:    frflags a0
; CHECKIZFHMIN-NEXT:    flt.h a2, fa1, fa0
; CHECKIZFHMIN-NEXT:    fsflags a0
; CHECKIZFHMIN-NEXT:    or a1, a2, a1
; CHECKIZFHMIN-NEXT:    xori a0, a1, 1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa1, fa0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_ueq:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    frflags a0
; CHECKIZHINXMIN-NEXT:    flt.s a3, a2, a1
; CHECKIZHINXMIN-NEXT:    fsflags a0
; CHECKIZHINXMIN-NEXT:    feq.s zero, a2, a1
; CHECKIZHINXMIN-NEXT:    frflags a0
; CHECKIZHINXMIN-NEXT:    flt.s a4, a1, a2
; CHECKIZHINXMIN-NEXT:    fsflags a0
; CHECKIZHINXMIN-NEXT:    or a3, a4, a3
; CHECKIZHINXMIN-NEXT:    xori a0, a3, 1
; CHECKIZHINXMIN-NEXT:    feq.s zero, a1, a2
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ugt(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    fle.h a1, fa0, fa1
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    xori a0, a1, 1
; CHECK-NEXT:    feq.h zero, fa0, fa1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_ugt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a2
; CHECKIZHINX-NEXT:    fle.h a3, a0, a1
; CHECKIZHINX-NEXT:    fsflags a2
; CHECKIZHINX-NEXT:    xori a2, a3, 1
; CHECKIZHINX-NEXT:    feq.h zero, a0, a1
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ugt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a0
; CHECKIZFHMIN-NEXT:    fle.h a1, fa0, fa1
; CHECKIZFHMIN-NEXT:    fsflags a0
; CHECKIZFHMIN-NEXT:    xori a0, a1, 1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa0, fa1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_ugt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    frflags a0
; CHECKIZHINXMIN-NEXT:    fle.s a3, a2, a1
; CHECKIZHINXMIN-NEXT:    fsflags a0
; CHECKIZHINXMIN-NEXT:    xori a0, a3, 1
; CHECKIZHINXMIN-NEXT:    feq.s zero, a2, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_uge(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    flt.h a1, fa0, fa1
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    xori a0, a1, 1
; CHECK-NEXT:    feq.h zero, fa0, fa1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_uge:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a2
; CHECKIZHINX-NEXT:    flt.h a3, a0, a1
; CHECKIZHINX-NEXT:    fsflags a2
; CHECKIZHINX-NEXT:    xori a2, a3, 1
; CHECKIZHINX-NEXT:    feq.h zero, a0, a1
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_uge:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a0
; CHECKIZFHMIN-NEXT:    flt.h a1, fa0, fa1
; CHECKIZFHMIN-NEXT:    fsflags a0
; CHECKIZFHMIN-NEXT:    xori a0, a1, 1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa0, fa1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_uge:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    frflags a0
; CHECKIZHINXMIN-NEXT:    flt.s a3, a2, a1
; CHECKIZHINXMIN-NEXT:    fsflags a0
; CHECKIZHINXMIN-NEXT:    xori a0, a3, 1
; CHECKIZHINXMIN-NEXT:    feq.s zero, a2, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"uge", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ult(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    fle.h a1, fa1, fa0
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    xori a0, a1, 1
; CHECK-NEXT:    feq.h zero, fa1, fa0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_ult:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a2
; CHECKIZHINX-NEXT:    fle.h a3, a1, a0
; CHECKIZHINX-NEXT:    fsflags a2
; CHECKIZHINX-NEXT:    xori a2, a3, 1
; CHECKIZHINX-NEXT:    feq.h zero, a1, a0
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ult:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a0
; CHECKIZFHMIN-NEXT:    fle.h a1, fa1, fa0
; CHECKIZFHMIN-NEXT:    fsflags a0
; CHECKIZFHMIN-NEXT:    xori a0, a1, 1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa1, fa0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_ult:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    frflags a0
; CHECKIZHINXMIN-NEXT:    fle.s a3, a1, a2
; CHECKIZHINXMIN-NEXT:    fsflags a0
; CHECKIZHINXMIN-NEXT:    xori a0, a3, 1
; CHECKIZHINXMIN-NEXT:    feq.s zero, a1, a2
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ult", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_ule(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    frflags a0
; CHECK-NEXT:    flt.h a1, fa1, fa0
; CHECK-NEXT:    fsflags a0
; CHECK-NEXT:    xori a0, a1, 1
; CHECK-NEXT:    feq.h zero, fa1, fa0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_ule:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    frflags a2
; CHECKIZHINX-NEXT:    flt.h a3, a1, a0
; CHECKIZHINX-NEXT:    fsflags a2
; CHECKIZHINX-NEXT:    xori a2, a3, 1
; CHECKIZHINX-NEXT:    feq.h zero, a1, a0
; CHECKIZHINX-NEXT:    mv a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_ule:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    frflags a0
; CHECKIZFHMIN-NEXT:    flt.h a1, fa1, fa0
; CHECKIZFHMIN-NEXT:    fsflags a0
; CHECKIZFHMIN-NEXT:    xori a0, a1, 1
; CHECKIZFHMIN-NEXT:    feq.h zero, fa1, fa0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_ule:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a2, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    frflags a0
; CHECKIZHINXMIN-NEXT:    flt.s a3, a1, a2
; CHECKIZHINXMIN-NEXT:    fsflags a0
; CHECKIZHINXMIN-NEXT:    xori a0, a3, 1
; CHECKIZHINXMIN-NEXT:    feq.s zero, a1, a2
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"ule", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_une(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_une:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.h a0, fa0, fa1
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_une:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    feq.h a0, a0, a1
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_une:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    feq.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_une:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"une", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmp_uno(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmp_uno:
; CHECK:       # %bb.0:
; CHECK-NEXT:    feq.h a0, fa1, fa1
; CHECK-NEXT:    feq.h a1, fa0, fa0
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmp_uno:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    feq.h a1, a1, a1
; CHECKIZHINX-NEXT:    feq.h a0, a0, a0
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmp_uno:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    feq.h a0, fa1, fa1
; CHECKIZFHMIN-NEXT:    feq.h a1, fa0, fa0
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmp_uno:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    feq.s a1, a1, a1
; CHECKIZHINXMIN-NEXT:    feq.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmp.f16(half %a, half %b, metadata !"uno", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_oeq(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oeq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.h a0, fa1, fa0
; CHECK-NEXT:    fle.h a1, fa0, fa1
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_oeq:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fle.h a2, a1, a0
; CHECKIZHINX-NEXT:    fle.h a0, a0, a1
; CHECKIZHINX-NEXT:    and a0, a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_oeq:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fle.h a0, fa1, fa0
; CHECKIZFHMIN-NEXT:    fle.h a1, fa0, fa1
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_oeq:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fle.s a2, a1, a0
; CHECKIZHINXMIN-NEXT:    fle.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    and a0, a0, a2
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"oeq", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}
declare i1 @llvm.experimental.constrained.fcmps.f16(half, half, metadata, metadata)

define i32 @fcmps_ogt(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ogt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.h a0, fa1, fa0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_ogt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    flt.h a0, a1, a0
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_ogt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    flt.h a0, fa1, fa0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_ogt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    flt.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ogt", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_oge(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_oge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.h a0, fa1, fa0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_oge:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fle.h a0, a1, a0
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_oge:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fle.h a0, fa1, fa0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_oge:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fle.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"oge", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_olt(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_olt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.h a0, fa0, fa1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_olt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    flt.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_olt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_olt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    flt.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"olt", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_ole(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ole:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.h a0, fa0, fa1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_ole:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fle.h a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_ole:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fle.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_ole:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fle.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ole", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_one(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_one:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.h a0, fa0, fa1
; CHECK-NEXT:    flt.h a1, fa1, fa0
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_one:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    flt.h a2, a0, a1
; CHECKIZHINX-NEXT:    flt.h a0, a1, a0
; CHECKIZHINX-NEXT:    or a0, a0, a2
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_one:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    flt.h a1, fa1, fa0
; CHECKIZFHMIN-NEXT:    or a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_one:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    flt.s a2, a0, a1
; CHECKIZHINXMIN-NEXT:    flt.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:    or a0, a0, a2
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"one", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_ord(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ord:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.h a0, fa1, fa1
; CHECK-NEXT:    fle.h a1, fa0, fa0
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_ord:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fle.h a1, a1, a1
; CHECKIZHINX-NEXT:    fle.h a0, a0, a0
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_ord:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fle.h a0, fa1, fa1
; CHECKIZFHMIN-NEXT:    fle.h a1, fa0, fa0
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_ord:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fle.s a1, a1, a1
; CHECKIZHINXMIN-NEXT:    fle.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ord", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_ueq(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ueq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.h a0, fa0, fa1
; CHECK-NEXT:    flt.h a1, fa1, fa0
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_ueq:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    flt.h a2, a0, a1
; CHECKIZHINX-NEXT:    flt.h a0, a1, a0
; CHECKIZHINX-NEXT:    or a0, a0, a2
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_ueq:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    flt.h a1, fa1, fa0
; CHECKIZFHMIN-NEXT:    or a0, a1, a0
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_ueq:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    flt.s a2, a0, a1
; CHECKIZHINXMIN-NEXT:    flt.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:    or a0, a0, a2
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ueq", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_ugt(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ugt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.h a0, fa0, fa1
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_ugt:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fle.h a0, a0, a1
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_ugt:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fle.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_ugt:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fle.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ugt", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_uge(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uge:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.h a0, fa0, fa1
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_uge:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    flt.h a0, a0, a1
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_uge:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    flt.h a0, fa0, fa1
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_uge:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    flt.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"uge", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_ult(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ult:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.h a0, fa1, fa0
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_ult:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fle.h a0, a1, a0
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_ult:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fle.h a0, fa1, fa0
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_ult:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fle.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ult", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_ule(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_ule:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flt.h a0, fa1, fa0
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_ule:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    flt.h a0, a1, a0
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_ule:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    flt.h a0, fa1, fa0
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_ule:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    flt.s a0, a1, a0
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"ule", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_une(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_une:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.h a0, fa1, fa0
; CHECK-NEXT:    fle.h a1, fa0, fa1
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_une:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fle.h a2, a1, a0
; CHECKIZHINX-NEXT:    fle.h a0, a0, a1
; CHECKIZHINX-NEXT:    and a0, a0, a2
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_une:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fle.h a0, fa1, fa0
; CHECKIZFHMIN-NEXT:    fle.h a1, fa0, fa1
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_une:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fle.s a2, a1, a0
; CHECKIZHINXMIN-NEXT:    fle.s a0, a0, a1
; CHECKIZHINXMIN-NEXT:    and a0, a0, a2
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"une", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @fcmps_uno(half %a, half %b) nounwind strictfp {
; CHECK-LABEL: fcmps_uno:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fle.h a0, fa1, fa1
; CHECK-NEXT:    fle.h a1, fa0, fa0
; CHECK-NEXT:    and a0, a1, a0
; CHECK-NEXT:    xori a0, a0, 1
; CHECK-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcmps_uno:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fle.h a1, a1, a1
; CHECKIZHINX-NEXT:    fle.h a0, a0, a0
; CHECKIZHINX-NEXT:    and a0, a0, a1
; CHECKIZHINX-NEXT:    xori a0, a0, 1
; CHECKIZHINX-NEXT:    ret
;
; CHECKIZFHMIN-LABEL: fcmps_uno:
; CHECKIZFHMIN:       # %bb.0:
; CHECKIZFHMIN-NEXT:    fle.h a0, fa1, fa1
; CHECKIZFHMIN-NEXT:    fle.h a1, fa0, fa0
; CHECKIZFHMIN-NEXT:    and a0, a1, a0
; CHECKIZFHMIN-NEXT:    xori a0, a0, 1
; CHECKIZFHMIN-NEXT:    ret
;
; CHECKIZHINXMIN-LABEL: fcmps_uno:
; CHECKIZHINXMIN:       # %bb.0:
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECKIZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINXMIN-NEXT:    fle.s a1, a1, a1
; CHECKIZHINXMIN-NEXT:    fle.s a0, a0, a0
; CHECKIZHINXMIN-NEXT:    and a0, a0, a1
; CHECKIZHINXMIN-NEXT:    xori a0, a0, 1
; CHECKIZHINXMIN-NEXT:    ret
  %1 = call i1 @llvm.experimental.constrained.fcmps.f16(half %a, half %b, metadata !"uno", metadata !"fpexcept.strict") strictfp
  %2 = zext i1 %1 to i32
  ret i32 %2
}
