; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=aarch64-linux-gnu -code-model=large -o - %s | FileCheck %s --check-prefix=STATIC
; RUN: llc -mtriple=aarch64-linux-gnu -code-model=large -relocation-model=pic -o - %s | FileCheck %s --check-prefix=PIC

@var8 = dso_local global i8 0
@var16 = dso_local global i16 0
@var32 = dso_local global i32 0
@var64 = dso_local global i64 0

define dso_local ptr @global_addr() {
;
; STATIC-LABEL: global_addr:
; STATIC:       // %bb.0:
; STATIC-NEXT:    movz x0, #:abs_g0_nc:var8
; STATIC-NEXT:    movk x0, #:abs_g1_nc:var8
; STATIC-NEXT:    movk x0, #:abs_g2_nc:var8
; STATIC-NEXT:    movk x0, #:abs_g3:var8
; STATIC-NEXT:    ret
;
; PIC-LABEL: global_addr:
; PIC:       .Lglobal_addr$local:
; PIC-NEXT:    .type .Lglobal_addr$local,@function
; PIC-NEXT:    .cfi_startproc
; PIC-NEXT:  // %bb.0:
; PIC-NEXT:    adrp x0, .Lvar8$local
; PIC-NEXT:    add x0, x0, :lo12:.Lvar8$local
; PIC-NEXT:    ret
  ret ptr @var8
  ; The movz/movk calculation should end up returned directly in x0.
}

define dso_local i8 @global_i8() {
;
; STATIC-LABEL: global_i8:
; STATIC:       // %bb.0:
; STATIC-NEXT:    movz x8, #:abs_g0_nc:var8
; STATIC-NEXT:    movk x8, #:abs_g1_nc:var8
; STATIC-NEXT:    movk x8, #:abs_g2_nc:var8
; STATIC-NEXT:    movk x8, #:abs_g3:var8
; STATIC-NEXT:    ldrb w0, [x8]
; STATIC-NEXT:    ret
;
; PIC-LABEL: global_i8:
; PIC:       .Lglobal_i8$local:
; PIC-NEXT:    .type .Lglobal_i8$local,@function
; PIC-NEXT:    .cfi_startproc
; PIC-NEXT:  // %bb.0:
; PIC-NEXT:    adrp x8, .Lvar8$local
; PIC-NEXT:    ldrb w0, [x8, :lo12:.Lvar8$local]
; PIC-NEXT:    ret
  %val = load i8, ptr @var8
  ret i8 %val
}

define dso_local i16 @global_i16() {
;
; STATIC-LABEL: global_i16:
; STATIC:       // %bb.0:
; STATIC-NEXT:    movz x8, #:abs_g0_nc:var16
; STATIC-NEXT:    movk x8, #:abs_g1_nc:var16
; STATIC-NEXT:    movk x8, #:abs_g2_nc:var16
; STATIC-NEXT:    movk x8, #:abs_g3:var16
; STATIC-NEXT:    ldrh w0, [x8]
; STATIC-NEXT:    ret
;
; PIC-LABEL: global_i16:
; PIC:       .Lglobal_i16$local:
; PIC-NEXT:    .type .Lglobal_i16$local,@function
; PIC-NEXT:    .cfi_startproc
; PIC-NEXT:  // %bb.0:
; PIC-NEXT:    adrp x8, .Lvar16$local
; PIC-NEXT:    ldrh w0, [x8, :lo12:.Lvar16$local]
; PIC-NEXT:    ret
  %val = load i16, ptr @var16
  ret i16 %val
}

define dso_local i32 @global_i32() {
;
; STATIC-LABEL: global_i32:
; STATIC:       // %bb.0:
; STATIC-NEXT:    movz x8, #:abs_g0_nc:var32
; STATIC-NEXT:    movk x8, #:abs_g1_nc:var32
; STATIC-NEXT:    movk x8, #:abs_g2_nc:var32
; STATIC-NEXT:    movk x8, #:abs_g3:var32
; STATIC-NEXT:    ldr w0, [x8]
; STATIC-NEXT:    ret
;
; PIC-LABEL: global_i32:
; PIC:       .Lglobal_i32$local:
; PIC-NEXT:    .type .Lglobal_i32$local,@function
; PIC-NEXT:    .cfi_startproc
; PIC-NEXT:  // %bb.0:
; PIC-NEXT:    adrp x8, .Lvar32$local
; PIC-NEXT:    ldr w0, [x8, :lo12:.Lvar32$local]
; PIC-NEXT:    ret
  %val = load i32, ptr @var32
  ret i32 %val
}

define dso_local i64 @global_i64() {
;
; STATIC-LABEL: global_i64:
; STATIC:       // %bb.0:
; STATIC-NEXT:    movz x8, #:abs_g0_nc:var64
; STATIC-NEXT:    movk x8, #:abs_g1_nc:var64
; STATIC-NEXT:    movk x8, #:abs_g2_nc:var64
; STATIC-NEXT:    movk x8, #:abs_g3:var64
; STATIC-NEXT:    ldr x0, [x8]
; STATIC-NEXT:    ret
;
; PIC-LABEL: global_i64:
; PIC:       .Lglobal_i64$local:
; PIC-NEXT:    .type .Lglobal_i64$local,@function
; PIC-NEXT:    .cfi_startproc
; PIC-NEXT:  // %bb.0:
; PIC-NEXT:    adrp x8, .Lvar64$local
; PIC-NEXT:    ldr x0, [x8, :lo12:.Lvar64$local]
; PIC-NEXT:    ret
  %val = load i64, ptr @var64
  ret i64 %val
}

define dso_local <2 x i64> @constpool() {
;
; STATIC-LABEL: constpool:
; STATIC:       // %bb.0:
; STATIC-NEXT:    movz x8, #:abs_g0_nc:.LCPI5_0
; STATIC-NEXT:    movk x8, #:abs_g1_nc:.LCPI5_0
; STATIC-NEXT:    movk x8, #:abs_g2_nc:.LCPI5_0
; STATIC-NEXT:    movk x8, #:abs_g3:.LCPI5_0
; STATIC-NEXT:    ldr q0, [x8]
; STATIC-NEXT:    ret
;
; PIC-LABEL: constpool:
; PIC:       .Lconstpool$local:
; PIC-NEXT:    .type .Lconstpool$local,@function
; PIC-NEXT:    .cfi_startproc
; PIC-NEXT:  // %bb.0:
; PIC-NEXT:    adrp x8, .LCPI5_0
; PIC-NEXT:    ldr q0, [x8, :lo12:.LCPI5_0]
; PIC-NEXT:    ret
  ret <2 x i64> <i64 123456789, i64 987654321100>
}
