; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=z15 %s -mtriple=s390x-linux-gnu -o - | FileCheck %s
;
; Test memsets of small constant lengths, that should not be done with MVC.

declare void @llvm.memset.p0.i64(ptr nocapture writeonly, i8, i64, i1 immarg)

define void @reg17(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg17:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stc %r3, 0(%r2)
; CHECK-NEXT:    mvc 1(16,%r2), 0(%r2)
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 17, i1 false)
  ret void
}

define void @reg18(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg18:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    vsteh %v0, 16(%r2), 0
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 18, i1 false)
  ret void
}

define void @reg19(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg19:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vstef %v0, 15(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 19, i1 false)
  ret void
}

define void @reg20(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg20:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vstef %v0, 16(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 20, i1 false)
  ret void
}

define void @reg21(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg21:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vsteg %v0, 13(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 21, i1 false)
  ret void
}

define void @reg22(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg22:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vsteg %v0, 14(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 22, i1 false)
  ret void
}

define void @reg23(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg23:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vsteg %v0, 15(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 23, i1 false)
  ret void
}

define void @reg24(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vsteg %v0, 16(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 24, i1 false)
  ret void
}

define void @reg25(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg25:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 9(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 25, i1 false)
  ret void
}

define void @reg26(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg26:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 10(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 26, i1 false)
  ret void
}

define void @reg27(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg27:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 11(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 27, i1 false)
  ret void
}

define void @reg28(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg28:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 12(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 28, i1 false)
  ret void
}

define void @reg29(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg29:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 13(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 29, i1 false)
  ret void
}

define void @reg30(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg30:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 14(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 30, i1 false)
  ret void
}

define void @reg31(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg31:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 15(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 31, i1 false)
  ret void
}

define void @reg32(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlvgp %v0, %r3, %r3
; CHECK-NEXT:    vrepb %v0, %v0, 7
; CHECK-NEXT:    vst %v0, 16(%r2), 4
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 32, i1 false)
  ret void
}

define void @reg33(ptr %Dst, i8 %val) {
; CHECK-LABEL: reg33:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stc %r3, 0(%r2)
; CHECK-NEXT:    mvc 1(32,%r2), 0(%r2)
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 %val, i64 33, i1 false)
  ret void
}

;; Immediate value

define void @imm17(ptr %Dst) {
; CHECK-LABEL: imm17:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mvi 0(%r2), 1
; CHECK-NEXT:    mvc 1(16,%r2), 0(%r2)
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 17, i1 false)
  ret void
}

define void @imm18(ptr %Dst) {
; CHECK-LABEL: imm18:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    mvhhi 16(%r2), -1
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 -1, i64 18, i1 false)
  ret void
}

define void @zero18(ptr %Dst) {
; CHECK-LABEL: zero18:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xc 0(18,%r2), 0(%r2)
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 0, i64 18, i1 false)
  ret void
}

define void @imm19(ptr %Dst) {
; CHECK-LABEL: imm19:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrepib %v0, 1
; CHECK-NEXT:    vstef %v0, 15(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 19, i1 false)
  ret void
}

define void @imm20(ptr %Dst) {
; CHECK-LABEL: imm20:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    mvhi 16(%r2), -1
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 -1, i64 20, i1 false)
  ret void
}

define void @imm21(ptr %Dst) {
; CHECK-LABEL: imm21:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrepib %v0, 1
; CHECK-NEXT:    vsteg %v0, 13(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 21, i1 false)
  ret void
}

define void @imm22(ptr %Dst) {
; CHECK-LABEL: imm22:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    mvghi 14(%r2), -1
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 -1, i64 22, i1 false)
  ret void
}

define void @imm23(ptr %Dst) {
; CHECK-LABEL: imm23:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrepib %v0, 1
; CHECK-NEXT:    vsteg %v0, 15(%r2), 0
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 23, i1 false)
  ret void
}

define void @imm24(ptr %Dst) {
; CHECK-LABEL: imm24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    mvghi 16(%r2), -1
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 -1, i64 24, i1 false)
  ret void
}

define void @imm25(ptr %Dst) {
; CHECK-LABEL: imm25:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrepib %v0, 1
; CHECK-NEXT:    vst %v0, 9(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 25, i1 false)
  ret void
}

define void @imm26(ptr %Dst) {
; CHECK-LABEL: imm26:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vst %v0, 10(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 -1, i64 26, i1 false)
  ret void
}

define void @zero26(ptr %Dst) {
; CHECK-LABEL: zero26:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xc 0(26,%r2), 0(%r2)
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 0, i64 26, i1 false)
  ret void
}

define void @imm27(ptr %Dst) {
; CHECK-LABEL: imm27:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrepib %v0, 1
; CHECK-NEXT:    vst %v0, 11(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 27, i1 false)
  ret void
}

define void @imm28(ptr %Dst) {
; CHECK-LABEL: imm28:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vst %v0, 12(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 -1, i64 28, i1 false)
  ret void
}

define void @imm29(ptr %Dst) {
; CHECK-LABEL: imm29:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrepib %v0, 1
; CHECK-NEXT:    vst %v0, 13(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 29, i1 false)
  ret void
}

define void @imm30(ptr %Dst) {
; CHECK-LABEL: imm30:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vst %v0, 14(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 -1, i64 30, i1 false)
  ret void
}

define void @imm31(ptr %Dst) {
; CHECK-LABEL: imm31:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vrepib %v0, 1
; CHECK-NEXT:    vst %v0, 15(%r2)
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 31, i1 false)
  ret void
}

define void @imm32(ptr %Dst) {
; CHECK-LABEL: imm32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgbm %v0, 65535
; CHECK-NEXT:    vst %v0, 16(%r2), 4
; CHECK-NEXT:    vst %v0, 0(%r2), 4
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 -1, i64 32, i1 false)
  ret void
}

define void @zero32(ptr %Dst) {
; CHECK-LABEL: zero32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xc 0(32,%r2), 0(%r2)
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 0, i64 32, i1 false)
  ret void
}

define void @imm33(ptr %Dst) {
; CHECK-LABEL: imm33:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mvi 0(%r2), 1
; CHECK-NEXT:    mvc 1(32,%r2), 0(%r2)
; CHECK-NEXT:    br %r14
  call void @llvm.memset.p0.i64(ptr align 16 %Dst, i8 1, i64 33, i1 false)
  ret void
}
