; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 -mattr=+wavefrontsize64 < %s | FileCheck -check-prefix=WAVE64 %s
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 < %s | FileCheck -check-prefix=WAVE32 %s

define i32 @s_andn2_i1_vcc(i32 %arg0, i32 %arg1) {
; WAVE64-LABEL: s_andn2_i1_vcc:
; WAVE64:       ; %bb.0:
; WAVE64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE64-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; WAVE64-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v1
; WAVE64-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; WAVE64-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; WAVE64-NEXT:    s_setpc_b64 s[30:31]
;
; WAVE32-LABEL: s_andn2_i1_vcc:
; WAVE32:       ; %bb.0:
; WAVE32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; WAVE32-NEXT:    v_cmp_ne_u32_e64 s4, 0, v1
; WAVE32-NEXT:    s_and_b32 s4, vcc_lo, s4
; WAVE32-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; WAVE32-NEXT:    s_setpc_b64 s[30:31]
  %src0 = icmp eq i32 %arg0, 0
  %src1 = icmp eq i32 %arg1, 0
  %not.src1 = xor i1 %src1, true
  %and = and i1 %src0, %not.src1
  %select = select i1 %and, i32 1, i32 0
  ret i32 %select
}

define i32 @s_andn2_i1_vcc_commute(i32 %arg0, i32 %arg1) {
; WAVE64-LABEL: s_andn2_i1_vcc_commute:
; WAVE64:       ; %bb.0:
; WAVE64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE64-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; WAVE64-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v1
; WAVE64-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; WAVE64-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; WAVE64-NEXT:    s_setpc_b64 s[30:31]
;
; WAVE32-LABEL: s_andn2_i1_vcc_commute:
; WAVE32:       ; %bb.0:
; WAVE32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; WAVE32-NEXT:    v_cmp_ne_u32_e64 s4, 0, v1
; WAVE32-NEXT:    s_and_b32 s4, s4, vcc_lo
; WAVE32-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; WAVE32-NEXT:    s_setpc_b64 s[30:31]
  %src0 = icmp eq i32 %arg0, 0
  %src1 = icmp eq i32 %arg1, 0
  %not.src1 = xor i1 %src1, true
  %and = and i1 %not.src1, %src0
  %select = select i1 %and, i32 1, i32 0
  ret i32 %select
}

define i32 @s_andn2_i1_vcc_multi_use(i32 %arg0, i32 %arg1) {
; WAVE64-LABEL: s_andn2_i1_vcc_multi_use:
; WAVE64:       ; %bb.0:
; WAVE64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE64-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v1
; WAVE64-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; WAVE64-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; WAVE64-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; WAVE64-NEXT:    v_cndmask_b32_e64 v0, v0, 1, s[4:5]
; WAVE64-NEXT:    s_setpc_b64 s[30:31]
;
; WAVE32-LABEL: s_andn2_i1_vcc_multi_use:
; WAVE32:       ; %bb.0:
; WAVE32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE32-NEXT:    v_cmp_ne_u32_e64 s4, 0, v1
; WAVE32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; WAVE32-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; WAVE32-NEXT:    s_and_b32 s4, vcc_lo, s4
; WAVE32-NEXT:    v_cndmask_b32_e64 v0, v0, 1, s4
; WAVE32-NEXT:    s_setpc_b64 s[30:31]
  %src0 = icmp eq i32 %arg0, 0
  %src1 = icmp eq i32 %arg1, 0
  %not.src1 = xor i1 %src1, -1
  %user = zext i1 %not.src1 to i32
  %and = and i1 %src0, %not.src1
  %select = select i1 %and, i32 1, i32 %user
  ret i32 %select
}

define <2 x i32> @s_andn2_v2i1_vcc(<2 x i32> %arg0, <2 x i32> %arg1) {
; WAVE64-LABEL: s_andn2_v2i1_vcc:
; WAVE64:       ; %bb.0:
; WAVE64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE64-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; WAVE64-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v2
; WAVE64-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v1
; WAVE64-NEXT:    v_cmp_ne_u32_e64 s[8:9], 0, v3
; WAVE64-NEXT:    s_and_b64 s[4:5], vcc, s[4:5]
; WAVE64-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; WAVE64-NEXT:    s_and_b64 s[4:5], s[6:7], s[8:9]
; WAVE64-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; WAVE64-NEXT:    s_setpc_b64 s[30:31]
;
; WAVE32-LABEL: s_andn2_v2i1_vcc:
; WAVE32:       ; %bb.0:
; WAVE32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; WAVE32-NEXT:    v_cmp_ne_u32_e64 s4, 0, v2
; WAVE32-NEXT:    v_cmp_eq_u32_e64 s5, 0, v1
; WAVE32-NEXT:    v_cmp_ne_u32_e64 s6, 0, v3
; WAVE32-NEXT:    s_and_b32 s4, vcc_lo, s4
; WAVE32-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; WAVE32-NEXT:    s_and_b32 s4, s5, s6
; WAVE32-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s4
; WAVE32-NEXT:    s_setpc_b64 s[30:31]
  %src0 = icmp eq <2 x i32> %arg0, zeroinitializer
  %src1 = icmp eq <2 x i32> %arg1, zeroinitializer
  %not.src1 = xor <2 x i1> %src1, <i1 true, i1 true>
  %and = and <2 x i1> %src0, %not.src1
  %select = select <2 x i1> %and, <2 x i32> <i32 1, i32 1>, <2 x i32> zeroinitializer
  ret <2 x i32> %select
}

define <2 x i32> @s_andn2_v2i1_vcc_commute(<2 x i32> %arg0, <2 x i32> %arg1) {
; WAVE64-LABEL: s_andn2_v2i1_vcc_commute:
; WAVE64:       ; %bb.0:
; WAVE64-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE64-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; WAVE64-NEXT:    v_cmp_ne_u32_e64 s[4:5], 0, v2
; WAVE64-NEXT:    v_cmp_eq_u32_e64 s[6:7], 0, v1
; WAVE64-NEXT:    v_cmp_ne_u32_e64 s[8:9], 0, v3
; WAVE64-NEXT:    s_and_b64 s[4:5], s[4:5], vcc
; WAVE64-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; WAVE64-NEXT:    s_and_b64 s[4:5], s[8:9], s[6:7]
; WAVE64-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s[4:5]
; WAVE64-NEXT:    s_setpc_b64 s[30:31]
;
; WAVE32-LABEL: s_andn2_v2i1_vcc_commute:
; WAVE32:       ; %bb.0:
; WAVE32-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; WAVE32-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; WAVE32-NEXT:    v_cmp_ne_u32_e64 s4, 0, v2
; WAVE32-NEXT:    v_cmp_eq_u32_e64 s5, 0, v1
; WAVE32-NEXT:    v_cmp_ne_u32_e64 s6, 0, v3
; WAVE32-NEXT:    s_and_b32 s4, s4, vcc_lo
; WAVE32-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s4
; WAVE32-NEXT:    s_and_b32 s4, s6, s5
; WAVE32-NEXT:    v_cndmask_b32_e64 v1, 0, 1, s4
; WAVE32-NEXT:    s_setpc_b64 s[30:31]
  %src0 = icmp eq <2 x i32> %arg0, zeroinitializer
  %src1 = icmp eq <2 x i32> %arg1, zeroinitializer
  %not.src1 = xor <2 x i1> %src1, <i1 true, i1 true>
  %and = and <2 x i1> %not.src1, %src0
  %select = select <2 x i1> %and, <2 x i32> <i32 1, i32 1>, <2 x i32> zeroinitializer
  ret <2 x i32> %select
}

