This list represents the complete set of commands supported by mtex2MML.

The most obvious gap in this library is the inability to define new commands (via `\mathop`, `\def`, `\mathchoice`, etc.). Everything else in standard TeX math should be fine, though.

## Symbols

``` latex
_
(
)
[
]
/
\
\,
\;
\:
\!
\!
\{
\}
\&
\#
\%
\>
\|
\|
\$
```

## A

``` latex
\above
\abovewithdelims
\acute
\aleph
\alpha
\Alpha
\amalg
\And
\angle
\approx
\approxeq
\arccos
\arcsin
\arctan
\arg
\Arrowvert
\arrowvert
\ast
\asymp
\atop
\atopwithdelims
```

## B

``` latex
\backepsilon
\backprime
\backsim
\backsimeq
\backslash
\bar
\barwedge
\Bbb
\bbox
\bcancel
\because
\beta
\Beta
\beth
\between
\bf
\bgcolor
\big
\Big
\bigcap
\bigcirc
\bigcup
\Bigg
\bigg
\Biggl
\biggl
\Biggm
\biggm
\Biggr
\biggr
\biginterleave
\Bigl
\bigl
\Bigm
\bigm
\bigodot
\bigoplus
\bigotimes
\bigr
\Bigr
\bigsqcap
\bigsqcup
\bigstar
\bigtriangledown
\bigtriangleup
\biguplus
\bigvee
\bigwedge
\binom
\blacklozenge
\blacksquare
\blacktriangle
\blacktriangledown
\blacktriangleleft
\blacktriangleright
\bmod
\boldsymbol
\bot
\bottom
\bowtie
\Box
\boxdot
\boxed
\boxminus
\boxplus
\boxtimes
\brace
\bracevert
\brack
\breve
\buildrel
\bullet
\Bumpeq
\bumpeq
```

## C

``` latex
\cal
\cancel
\cancelto
\canceledto
\Cap
\cap
\cdot
\cdotp
\cdots
\centerdot
\cfrac
\check
\checkmark
\chi
\choose
\circ
\circeq
\circlearrowleft
\circlearrowright
\circledast
\circledcirc
\circleddash
\circledR
\circledS
\clap
\closure
\clubsuit
\colon
\Colonapprox
\colonapprox
\Coloneq
\coloneq
\Coloneqq
\coloneqq
\Colonsim
\colonsim
\color
\colorbox
\complement
\cong
\conint
\contourintegral
\coprod
\coproduct
\cos
\cosh
\cot
\coth
\cr
\csc
\Cup
\cup
\curlyeqprec
\curlyeqsucc
\curlyvee
\curlywedge
\curvearrowbotright
\curvearrowleft
\curvearrowright
```

## D

``` latex
\dagger
\daleth
\darr
\dashleftarrow
\dashrightarrow
\dashv
\dbinom
\dblcolon
\ddagger
\ddddot
\dddot
\ddot
\ddots
\deg
\Del
\Delta
\delta
\det
\dfrac
\diagdown
\diagup
\Diamond
\diamond
\diamondsuit
\digamma
\dim
\displaystyle
\div
\divideontimes
\dot
\Doteq
\doteq
\doteqdot
\dotplus
\dots
\dotsb
\dotsc
\dotsi
\dotsm
\dotso
\doublebarwedge
\doublecap
\doublecup
\doubleintegral
\Downarrow
\downarrow
\downdownarrows
\downharpoonleft
\downharpoonright
\downuparrow
\duparr
```

## E

``` latex
\ell
\embedsin
\emptyset
\enclose
\enspace
\epsilon
\eqcirc
\eqalign
\eqalignno
\eqcolon
\Eqcolon
\eqqcolon
\Eqqcolon
\eqsim
\eqslantgtr
\eqslantless
\equiv
\eta
\Eta
\eth
\exists
\exp
```

## F

``` latex
\fallingdotseq
\fbox
\Finv
\flat
\forall
\frac
\frak
\frown
```

## G

``` latex
\Game
\Gamma
\gamma
\gcd
\ge
\geq
\geqq
\geqslant
\genfrac
\gets
\gg
\ggg
\gggtr
\gimel
\gnapprox
\gneq
\gneqq
\gnsim
\grave
\gt
\gtrapprox
\gtrdot
\gtreqless
\gtreqqless
\gtrless
\gtrsim
\gvertneqq
```

## H

``` latex
\hat
\hbar
\hbox
\hdashline
\heartsuit
\hline
\hom
\hookleftarrow
\hookrightarrow
\hphantom
\hskip
\hslash
\hspace
\Huge
\huge
```

## I

``` latex
\idotsint
\iff
\iiiint
\iiint
\iint
\Im
\imath
\implies
\impliedby
\in
\inf
\infinity
\infty
\injlim
\int
\integral
\intercal
\intersection
\Intersection
\intop
\invamp
\iota
\Iota
\it
```

## J

``` latex
\jmath
\Join
```

## K

``` latex
\Kappa
\kappa
\ker
\kern
```

## L

``` latex
\Lambda
\lambda
\land
\lang
\langle
\LARGE
\Large
\large
\LaTeX
\lbrace
\lbrack
\lceil
\lcorner
\ldotp
\ldots
\le
\leadsto
\Leftarrow
\leftarrow
\leftarrowtail
\leftharpoondown
\leftharpoonup
\leftleftarrows
\Leftrightarrow
\leftrightarrow
\leftrightarrows
\leftrightharpoons
\leftrightsquigarrow
\leftrightsquigarrow
\leftroot
\leftsquigarrow
\leftthreetimes
\lefttorightarrow
\leq
\leqq
\leqslant
\lessapprox
\lessdot
\lesseqgtr
\lesseqqgtr
\lessgtr
\lesssim
\lfloor
\lg
\lgroup
\lhd
\lim
\liminf
\limits
\limsup
\ll
\llangle
\llap
\llcorner
\Lleftarrow
\lll
\llless
\lmoustache
\ln
\lnapprox
\lneq
\lneqq
\lnot
\lnsim
\log
\lor
\Longleftarrow
\longleftarrow
\Longleftrightarrow
\longleftrightarrow
\longmapsto
\longrightarrow
\Longrightarrow
\looparrowleft
\looparrowright
\lrcorner
\lower
\lozenge
\Lsh
\lt
\ltimes
\lVert
\lvert
\lvertneqq
```

## M

``` latex
\maltese
\map
\mapsto
\mathbb
\mathbf
\mathbin
\mathcal
\mathclap
\mathclose
\mathfr
\mathfrak
\mathit
\mathinner
\mathllap
\mathop
\mathopen
\mathord
\mathpunct
\mathraisebox
\mathrel
\mathring
\mathrlap
\mathrm
\mathscr
\mathsf
\mathstrut
\mathtt
\max
\mbox
\measuredangle
\medspace
\mho
\mid
\min
\minusb
\mkern
\mod
\models
\moveleft
\moveright
\mp
\mskip
\mspace
\mtexnum
\mu
\Mu
\multimap
\multiscripts
```

## N

``` latex
\nabla
\natural
\ncong
\ne
\neArr
\nearr
\neArrow
\nearrow
\neg
\negmedspace
\negthickspace
\negthinspace
\neq
\nequiv
\nexists
\ngeq
\ngeqq
\ngeqslant
\ngtr
\ni
\nLeftarrow
\nleftarrow
\nLeftrightarrow
\nleftrightarrow
\nleq
\nleqq
\nleqslant
\nless
\nmid
\nobreakspace
\nolimits
\nonumber
\normalsize
\not
\notag
\notin
\notni
\nparallel
\nprec
\npreceq
\nRightarrow
\nrightarrow
\nshortmid
\nshortparallel
\nsim
\nsubset
\nsubseteq
\nsubseteqq
\nsucc
\nsucceq
\nsupset
\nsupseteq
\nsupseteqq
\ntriangleleft
\ntrianglelefteq
\ntriangleright
\ntrianglerighteq
\Nu
\nu
\nvDash
\nvdash
\nVDash
\nVdash
\nwArr
\nwarr
\nwArrow
\nwarrow
```

## O

``` latex
\odash
\odot
\oint
\oldstyle
\Omega
\omega
\omicron
\ominus
\operatorname
\oplus
\Oplus
\oslash
\otimes
\Otimes
\over
\overbrace
\overbracket
\overleftarrow
\overleftrightarrow
\overline
\overrightarrow
\overset
\overwithdelims
\owns
```

## P

``` latex
\parallel
\parr
\partial
\Perp
\perp
\phantom
\Phi
\phi
\Pi
\pi
\pitchfork
\plusb
\pm
\pmb
\pmod
\pod
\Pr
\prec
\precapprox
\preccurlyeq
\preceq
\precnapprox
\precneqq
\precnsim
\precsim
\prime
\prod
\product
\projlim
\propto
\Psi
\psi
```

## Q

``` latex
\qed
\qquad
\quad
\quadrupleintegral
```

## R

``` latex
\raise
\rang
\rangle
\rbrace
\rbrack
\rceil
\Re
\restriction
\rfloor
\rgroup
\rhd
\Rho
\rho
\Rightarrow
\rightarrow
\rightarrowtail
\rightharpoondown
\rightharpoonup
\rightleftarrows
\rightleftharpoons
\rightrightarrows
\rightsquigarrow
\rightthreetimes
\righttoleftarrow
\risingdotseq
\rlap
\rm
\rmoustache
\root
\Rrightarrow
\rrangle
\Rsh
\rtimes
\rVert
\rvert
```

## S

``` latex
\S
\scr
\scriptscriptsize
\scriptscriptstyle
\scriptsize
\scriptstyle
\searr
\seArr
\searrow
\seArrow
\sec
\setminus
\sf
\sharp
\shortmid
\shortparallel
\sideset
\Sigma
\sigma
\sim
\simeq
\sin
\sinh
\slash
\skew
\small
\smallfrown
\smallint
\smallsetminus
\smallsmile
\smash
\smile
\Space
\space
\spadesuit
\sphericalangle
\sqcap
\sqcup
\sqrt
\sqsubset
\sqsubseteq
\sqsupset
\sqsupseteq
\square
\sslash
\stackrel
\star
\strut
\subset
\Subset
\subseteq
\subseteqq
\subsetneq
\subsetneqq
\substack
\succ
\succapprox
\succcurlyeq
\succeq
\succnapprox
\succneqq
\succnsim
\succsim
\sum
\sup
\supset
\Supset
\supseteq
\supseteqq
\supsetneq
\supsetneqq
\surd
\swarr
\swArr
\swarrow
\swArrow
```

## T

``` latex
\tan
\tanh
\tau
\Tau
\tbinom
\tensor
\TeX
\text
\textbf
\textit
\textgreater
\textless
\textrm
\textsf
\textsize
\textstyle
\texttt
\tfrac
\therefore
\Theta
\theta
\thickapprox
\thicksim
\thickspace
\thinspace
\tilde
\times
\timesb
\Tiny
\tiny
\to
\top
\triangle
\triangledown
\triangleleft
\trianglelefteq
\triangleq
\triangleright
\trianglerighteq
\tripleintegral
\tt
\twoheadleftarrow
\twoheadrightarrow
```

## U

``` latex
\udots
\ulcorner
\underbrace
\underbracket
\underleftarrow
\underleftrightarrow
\underline
\underoverset (such as `\underoverset{subscript}{superscript}{symbol}`)
\underrightarrow
\underset
\Union
\union
\unlhd
\unrhd
\uparr
\Uparrow
\uparrow
\updarr
\Updownarrow
\updownarrow
\upharpoonleft
\upharpoonright
\uplus
\uproot
\Upsi
\Upsilon
\upsilon
\upuparrows
\urcorner
```

## V

``` latex
\varDelta
\varepsilon
\varGamma
\varinjlim
\varkappa
\varLambda
\varliminf
\varlimsup
\varnothing
\varOmega
\varphi
\varPhi
\varpi
\varPi
\varprojlim
\varpropto
\varPsi
\varrho
\varsigma
\varSigma
\varsubsetneq
\varsubsetneqq
\varsupsetneq
\varsupsetneqq
\vartheta
\varTheta
\vartriangle
\vartriangleleft
\vartriangleright
\varUpsilon
\varXi
\Vbar
\vcenter
\vDash
\vdash
\VDash
\Vdash
\vdots
\vec
\vee
\Vee
\veebar
\verb
\Vert
\vert
\vphantom
\Vvdash
```

## W

``` latex
\wedge
\Wedge
\widebar
\widecheck
\widehat
\widetilde
\widevec
\wp
\wr
```

## X

``` latex
\xcancel
\xhookleftarrow
\xhookrightarrow
\Xi
\xi
\xleftarrow
\xLeftarrow
\xleftrightarrow
\xLeftrightarrow
\xleftrightharpoons
\xlongequal
\xmapsto
\xrightarrow
\xRightarrow
\xrightleftharpoons
\xtofrom
\xtwoheadleftarrow
\xtwoheadrightarrow
```

## Y

``` latex
\yen
```

## Z

``` latex
\zeta
\Zeta
```

## Environments

``` latex
\begin{env}...\end{env}
```

where `env` is one of

``` latex
align
align*
alignat
alignat*
aligned
alignedat
array

Bmatrix
bmatrix

cases

eqnarray
eqnarray*
equation
equation*

gather
gather*
gathered

matrix
multline
multline*

pmatrix

smallmatrix
split
subarray
svg

Vmatrix
vmatrix
```

### The `array` Environment

As in standard LaTeX, the `array` environment takes one optional
argument, indicating the alignment of the whole array with the respect
to the equation axis, and one mandatory argument, indicating the
alignment of the columns. Thus

``` latex
\begin{array}[t]{clrc}
  1 & 2 & 3 & 4 \\
  5 & 6 & 7 & 8 \\
  9 & 10& 11& 12
\end{array}
```

produces an array with four columns. The first and last column are
centered; the second and third are, respectively, left- and
right-aligned. The top line of the array is aligned with the equation
axis.

As in AMSLaTeX

``` latex
\begin{matrix}
   ...
\end{matrix}
```

is precisely equivalent to

```
\begin{array}{cc...c}
   ...
\end{array}
```

except that you don't have to explicitly state the number of columns.

### Column separators

While defining columns, you can use `|` to indicate an unbroken vertical line, and `:` to indicate a dashed line. For example:

``` latex
\begin{array}[b]{c:c|c}
Bad & Good & Ugly
\end{array}
```

This creates a dashed column between `Bad & Good` and an unbroken line between `Good & Bad`.

Placing either a `:` or `|` as the first or last character creates a frame around the array. For example:


``` latex
\begin{array}[b]{|c:c|c}
Bad & Good & Ugly
\end{array}
```

This creates an unbroken frame around the array. It's also equivalent to


``` latex
\begin{array}[b]{c:c|c|}
Bad & Good & Ugly
\end{array}
```

### The `svg` Environment

Using the `svg` environment:

``` latex
\begin{svg}
   ...
\end{svg}
```

allows you to embed snippets of SVG in mtex equations. To assist in [Instiki](http://golem.ph.utexas.edu/instiki/show/HomePage)'s LaTeX export feature, you can also include a `graphicx` command:

``` latex
\begin{svg}
   ...
\end{svg}
\includegraphics[width=...]{foo}
```

where `foo.pdf` is a file containing a PDF version of the graphic. In mtex, the `\includegraphics` command is defined as a NOOP, and the SVG is embedded in the MathML output. In Instiki's LaTeX export, the opposite is true: the `svg` environment is a NOOP, and the `\includegraphics` command is included in the output.

## WebTeX-style Arrays and Array Options

The [WebTeX notation for arrays](https://golem.ph.utexas.edu/~distler/WebTeX/docs/wtxsec7.html#ARRAY) is also supported.

The `\array{}` command allows much finer control over the layout of arrays than is available in the standard (AMS)LaTeX-style environments above.

<dl>
 <dt><code>\array</code></dt>
 <dd>
   <dl>
     <dt><code>\arrayopts</code></dt>
     <dd>
              <code>\collayout</code> (=<code>\colalign</code>)
              <code>\rowalign</code>
              <code>\align</code>
              <code>\equalcols</code>
              <code>\equalrows</code>
              <code>\collines</code>
              <code>\rowlines</code>
              <code>\frame</code>
              <code>\padding</code>
      </dd>
      <dt><code>\rowopts</code></dt>
      <dd>
             <code>\colalign</code>
             <code>\rowalign</code>
      </dd>
      <dt><code>\cellopts</code></dt>
      <dd>
             <code>\colalign</code>
             <code>\rowalign</code>
             <code>\rowspan</code>
              <code>\colspan</code>
      </dd>
   </dl>
 </dd>
</dl>

## Numbers

In MathML, numbers are represented as `<mn>127.3</mn>`. mtex2MML does its best to intelligently parse what's a number and what's not. Unfortunately, conventions for things like [decimal markers](http://en.wikipedia.org/wiki/Decimal_separator) are very culture-dependent, and incompatibly-so. If you don't like the way mtex2MML parses the would-be numbers in your input, you can force it to interpret a certain string as a number, using the `\mtexnum{}` command.

## Colors

`\color{colourspec}` changes the current foreground color. `colourspec` is either:

* A CSS named color: https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_Keywords
* A LaTeX named color: http://en.wikibooks.org/wiki/LaTeX/Colors
* An RGB color value:
  * `#rgb` or `#rrggbb`, a three- or six-digit hexadecimal number.
  `#000000` is black `#FFFFFF` is white, and `#1AC=#11AACC`.

For example:

``` latex
a { b \color{red} c \color{#0F0} d } e
```

renders `a`, `b`, and `e` in the default color (usually black), `c` in red, and `d` in green.

The alternate LaTeX syntax, involving specifying a color model is not supported:

``` latex
\color[cmyk]{0, 0.1, 0.5, 0.3}
```

A new command, `\bgcolor{colourspec}` works the same way, but changes the current background color.

`\colorbox` changes the background color, and adds some padding, using the `mpadding` element.

## Interactivity


<dl>
    <dt><code>\href{<i>url</i>}{<i>expression</i>}</code></dt>
    <dd>Turns a mathematical <i>expression</i> into a clickable link. This makes use of <a href="http://www.w3.org/TR/xlink/">Xlink</a>.</dd>

    <dt><code>\statusline{<i>message</i>}{<i>expression</i>}</code></dt>
    <dd>Displays the <i>message</i> text in the browser's status-line, when the user hovers his mouse over the mathematical <i>expression</i>.</dd>

    <dt><code>\tooltip{<i>message</i>}{<i>expression</i>}</code></dt>
    <dd>Displays the <i>message</i> text as a tooltip, when the user hovers his mouse over the mathematical <i>expression</i>.</dd>

    <dt><code>\fghilight{<i>colourspec</i>}{<i>expression</i>}</code> (<code>\fghighlight</code>)</dt>
    <dd>Change the foreground color of an expression when the user hovers over it.</dd>

    <dt><code>\bghilight{<i>colourspec</i>}{<i>expression</i>}</code> (<code>\bghighlight</code>)</dt>
    <dd>Change the background color of an expression when the user hovers over it.</dd>

    <dt><code>\toggle{<i>expression1</i>}{<i>expression2</i>}</code></dt>
    <dd>Toggle between these two expressions when the user clicks on them.</dd>

    <dt><code>\begintoggle{<i>expression1</i>}{<i>expression2</i>}...{<i>expressionN</i>}\endtoggle</code></dt>
    <dd>Toggle between these <i>n</i> expressions when the user clicks on them.</dd>
</dl>
